## Public and Private API ##

_API documentation automatically generated by [docmeteor](https://github.com/raix/docmeteor)._

***

__File: ["http.publish.server.api.js"](http.publish.server.api.js) Where: {server}__

***

### <a name="_publishHTTP"></a>_publishHTTP {any}&nbsp;&nbsp;<sub><i>Server</i></sub> ###

```
GET /note
GET /note/:id
POST /note
PUT /note/:id
DELETE /note/:id
```

> ```_publishHTTP = { ...``` [http.publish.server.api.js:20](http.publish.server.api.js#L20)



-
Could be cool if we could serve some api doc or even an api script
user could do <script href="/note/api?token=1&user=2"></script> and be served
a client-side javascript api?
Eg.
HTTP.api.note.create();
HTTP.api.login(username, password);
HTTP.api.logout
-

### <a name="_publishHTTP.getPublishScope"></a>*_publishhttp*.getPublishScope(scope)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __getPublishScope__ is defined in `_publishHTTP`*

__Arguments__

* __scope__ *{Object}*  

__Returns__  *{httpPublishGetPublishScope.publishScope}*


Creates a nice scope for the publish method

> ```_publishHTTP.getPublishScope = function httpPublishGetPublishScope(scope) { ...``` [http.publish.server.api.js:35](http.publish.server.api.js#L35)


-

### <a name="_publishHTTP.formatHandlers.json"></a>*_publishhttpformathandlers*.json(result)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __json__ is defined in `_publishHTTP.formatHandlers`*

__Arguments__

* __result__ *{Object}*  

 The result object


__Returns__  *{String}*
JSON


Formats the output into JSON and sets the appropriate content type on `this`

> ```_publishHTTP.formatHandlers.json = function httpPublishJSONFormatHandler(result) { ...``` [http.publish.server.api.js:56](http.publish.server.api.js#L56)


-

### <a name="_publishHTTP.formatResult"></a>*_publishhttp*.formatResult(result, scope, [defaultFormat])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __formatResult__ is defined in `_publishHTTP`*

__Arguments__

* __result__ *{Object}*  

 The result object

* __scope__ *{Object}*  
* __defaultFormat__ *{String}*  (Optional, Default = 'json')

 Default format to use if format is not in query string.


__Returns__  *{Any}*
The formatted result


Formats the result into the format selected by querystring eg. "&format=json"

> ```_publishHTTP.formatResult = function httpPublishFormatResult(result, scope, defaultFormat) { ...``` [http.publish.server.api.js:73](http.publish.server.api.js#L73)


-

### <a name="_publishHTTP.error"></a>*_publishhttp*.error(statusCode, message, scope)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __error__ is defined in `_publishHTTP`*

__Arguments__

* __statusCode__ *{String}*  

 The status code

* __message__ *{String}*  

 The message

* __scope__ *{Object}*  

__Returns__  *{Any}*
The formatted result


Responds with error message in the expected format

> ```_publishHTTP.error = function httpPublishError(statusCode, message, scope) { ...``` [http.publish.server.api.js:114](http.publish.server.api.js#L114)


-

### <a name="_publishHTTP.getMethodHandler"></a>*_publishhttp*.getMethodHandler(collection, methodName)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __getMethodHandler__ is defined in `_publishHTTP`*

__Arguments__

* __collection__ *{[Meteor.Collection](#Meteor.Collection)}*  

 The Meteor.Collection instance

* __methodName__ *{String}*  

 The method name


__Returns__  *{Function}*
The server method


Returns the DDP connection handler, already setup and secured

> ```_publishHTTP.getMethodHandler = function httpPublishGetMethodHandler(collection, methodName) { ...``` [http.publish.server.api.js:129](http.publish.server.api.js#L129)


-

### <a name="_publishHTTP.unpublishList"></a>*_publishhttp*.unpublishList(names)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __unpublishList__ is defined in `_publishHTTP`*

__Arguments__

* __names__ *{Array}*  

 List of method names to unpublish


__Returns__  *{undefined}*


Unpublishes all HTTP methods that have names matching the given list.

> ```_publishHTTP.unpublishList = function httpPublishUnpublishList(names) { ...``` [http.publish.server.api.js:149](http.publish.server.api.js#L149)


-

### <a name="_publishHTTP.unpublish"></a>*_publishhttp*.unpublish([name])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method is private*
*This method __unpublish__ is defined in `_publishHTTP`*

__Arguments__

* __name__ *{String|[Meteor.Collection](#Meteor.Collection)}*  (Optional)

 The method name or collection


__Returns__  *{undefined}*


Unpublishes all HTTP methods that were published with the given name or 
for the given collection. Call with no arguments to unpublish all.

> ```_publishHTTP.unpublish = function httpPublishUnpublish(``` [http.publish.server.api.js:177](http.publish.server.api.js#L177)


-

### <a name="HTTP.publishFormats"></a>*http*.publishFormats(newHandlers)&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __publishFormats__ is defined in `HTTP`*

__Arguments__

* __newHandlers__ *{Object}*  

__Returns__  *{undefined}*


Add publish formats. Example:
```js
HTTP.publishFormats({
json: function(inputObject) {
// Set the method scope content type to json
this.setContentType('application/json');
// Return EJSON string
return EJSON.stringify(inputObject);
}
});
```

> ```HTTP.publishFormats = function httpPublishFormats(newHandlers) { ...``` [http.publish.server.api.js:215](http.publish.server.api.js#L215)


-

### <a name="HTTP.publish"></a>*http*.publish(options, [name], [collection], [publishFunc])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __publish__ is defined in `HTTP`*

__Arguments__

* __options__ *{Object}*  
    * __defaultFormat__ *{String}*  (Optional, Default = 'json')

     Format to use for responses when `format` is not found in the query string.

    * __collectionGet__ *{String}*  (Optional, Default = true)

     Add GET restpoint for collection? Requires a publish function.

    * __collectionPost__ *{String}*  (Optional, Default = true)

     Add POST restpoint for adding documents to the collection?

    * __documentGet__ *{String}*  (Optional, Default = true)

     Add GET restpoint for documents in collection? Requires a publish function.

    * __documentPut__ *{String}*  (Optional, Default = true)

     Add PUT restpoint for updating a document in the collection?

    * __documentDelete__ *{String}*  (Optional, Default = true)

     Add DELETE restpoint for deleting a document in the collection?

* __name__ *{String}*  (Optional)

 Restpoint name (url prefix). Optional if `collection` is passed. Will mount on `/api/collectionName` by default.

* __collection__ *{[Meteor.Collection](#Meteor.Collection)}*  (Optional)

 Meteor.Collection instance. Required for all restpoints except collectionGet

* __publishFunc__ *{Function}*  (Optional)

 A publish function. Required to mount GET restpoints.


__Returns__  *{undefined}*

__TODO__
```
* this should use options argument instead of optional args
```


Publishes one or more restpoints, mounted on "name" ("/api/collectionName/"
by default). The GET restpoints are subscribed to the document set (cursor)
returned by the publish function you supply. The other restpoints forward
requests to Meteor's built-in DDP methods (insert, update, remove), meaning
that full allow/deny security is automatic.

__Usage:__

Publish only:

HTTP.publish({name: 'mypublish'}, publishFunc);

Publish and mount crud rest point for collection /api/myCollection:

HTTP.publish({collection: myCollection}, publishFunc);

Mount CUD rest point for collection and documents without GET:

HTTP.publish({collection: myCollection});


> ```HTTP.publish = function httpPublish(options, publishFunc) { ...``` [http.publish.server.api.js:256](http.publish.server.api.js#L256)


-

### <a name="HTTP.unpublish"></a>*http*.unpublish([name])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __unpublish__ is defined in `HTTP`*

__Arguments__

* __name__ *{String|[Meteor.Collection](#Meteor.Collection)}*  (Optional)

 The method name or collection


__Returns__  *{undefined}*


Unpublishes all HTTP methods that were published with the given name or 
for the given collection. Call with no arguments to unpublish all.

> ```HTTP.unpublish = _publishHTTP.unpublish;``` [http.publish.server.api.js:453](http.publish.server.api.js#L453)


