#!/usr/bin/env python3
import argparse

from openpilot.selfdrive.test.process_replay.process_replay import CONFIGS, replay_process
from openpilot.selfdrive.test.process_replay.test_processes import EXCLUDED_PROCS
from openpilot.tools.lib.logreader import LogReader, save_log

ALLOW_PROCS = {c.proc_name for c in CONFIGS}

if __name__ == "__main__":
  parser = argparse.ArgumentParser(description="Run process on route and create new logs",
                                   formatter_class=argparse.ArgumentDefaultsHelpFormatter)
  parser.add_argument("route", help="The route name to use")
  parser.add_argument("--fingerprint", help="The fingerprint to use")
  parser.add_argument("--whitelist-procs", nargs='*', default=ALLOW_PROCS, help="Whitelist given processes (e.g. controlsd)")
  parser.add_argument("--blacklist-procs", nargs='*', default=EXCLUDED_PROCS, help="Blacklist given processes (e.g. controlsd)")
  args = parser.parse_args()

  allowed_procs = set(args.whitelist_procs) - set(args.blacklist_procs)
  cfgs = [c for c in CONFIGS if c.proc_name in allowed_procs]

  inputs = list(LogReader(args.route))
  outputs = replay_process(cfgs, inputs, fingerprint=args.fingerprint)

  # Remove message generated by the process under test and merge in the new messages
  produces = {o.which() for o in outputs}
  inputs = [i for i in inputs if i.which() not in produces]
  outputs = sorted(inputs + outputs, key=lambda x: x.logMonoTime)

  fn = f"{args.route.replace('/', '_')}_{'_'.join(allowed_procs)}.zst"
  print(f"Saving log to {fn}")
  save_log(fn, outputs)
