---
order: 4
title: CometBFT Reference Documentation
description: References
parent:
    order: 4
---

# Reference Documentation

Welcome to the CometBFT Reference Documentation, a comprehensive resource for essential information and
standards related to CometBFT.

In this documentation, you'll find valuable references in three key areas:

## Architecture Decision Records (ADRs)

[Architecture Decision Records (ADRs)](./architecture/README.md) provide a structured approach to documenting key architectural
decisions made during the development of CometBFT. These records help us maintain transparency,
share knowledge, and ensure that architectural choices align with CometBFT's goals and constraints.

### What You'll Find in ADRs:

- Clear explanations of architectural decisions.
- The context and background that led to each decision.
- Rationale for choosing a particular solution.
- Any associated risks and trade-offs.
- Decision status and tracking for ongoing changes.

Browse the ADRs to gain insights into the architectural decisions that shape CometBFT.

## Quality Assurance (QA) Documents

[Quality Assurance (QA)](./qa/README.md) Documents are the foundation of the commitment to delivering a high-quality CometBFT
implementation. These standards guide the testing processes, quality control measures, and best practices
to ensure that CometBFT meets and exceeds industry benchmarks.

### What You'll Find in QA:

- Testing methodologies and strategies.
- Documentation on test plans and test cases.

Explore the QA documents to understand the testing methods to ensure the quality and performance of CometBFT.

## Configuration Manual

The [Configuration Manual](./config/README.md) is a reference manual describing CometBFT configuration options.
It details all configuration files deployed and includes examples and best practices to ensure that
CometBFT is deployed with a proper configuration.

### What You'll Find in the Configuration Manual:

- Documentation of each configuration option.
- Examples for real-world use-cases.

Explore the Configuration Manual to understand the different options of CometBFT to ensure a high-performing deployment.

## Request for Comments (RFCs)

[Request for Comments (RFCs)](./rfc/README.md) documents serve as a platform for open and collaborative discussions on proposed
changes, new features, and improvements within CometBFT. RFCs encourage cross-team communication
and feedback, ensuring that decisions are well-informed and aligned with CometBFT's goals.

### What You'll Find in RFCs:

- Proposals for changes or enhancements.
- Technical details and specifications.
- Discussions and feedback from team members.
- Status updates and implementation progress.

Engage with RFCs to participate in shaping the direction of CometBFT, share your insights,
and contribute to its continuous evolution.

## Storage

[Storage](./storage/README.md) references comprise findings from storage sub-systems
(eg block store, state store) improvements in CometBFT.

### What You'll Find in Storage:

- Prior improvements efforts and reports that documents those efforts
- The testing methodology used to improve storage footprint and performance in Comet
- Conclusions and potential future work

Explore the Storage references to get a deeper understanding of prior work and future plans in these
sub-systems of CometBFT.

## Explore CometBFT References

The CometBFT Reference Documentation empowers you with knowledge and information that enhances
your understanding of CometBFT's architecture, quality assurance, and ongoing improvements.
Whether you're a chain developer, application developer, or simply interested in CometBFT,
you'll find valuable insights and documentation here.

Feel free to explore the sections on ADRs, QA Standards, and RFCs to access the resources you need.
We are committed to transparency, collaboration, and excellence, and this documentation reflects
our dedication to those principles.
