// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

package pcr_test

import (
	"crypto"
	"testing"

	"github.com/stretchr/testify/assert"

	"github.com/cozystack/talm/internal/pkg/secureboot/measure/internal/pcr"
)

func TestExtend(t *testing.T) {
	t.Parallel()

	hash := pcr.NewDigest(crypto.SHA256)

	assert.Equal(t, make([]byte, 32), hash.Hash())

	hash.Extend([]byte("foo"))

	assert.Equal(t,
		[]byte{0x42, 0x48, 0x16, 0xd0, 0x20, 0xcf, 0x3d, 0x79, 0x3a, 0xc0, 0x21, 0xda, 0x47, 0x37, 0x9b, 0xdf, 0x60, 0x80, 0x80, 0xa8, 0x3e, 0xb9, 0x36, 0x4a, 0x7f, 0xbe, 0xb, 0xdf, 0xa8, 0x71, 0x11, 0xd7},
		hash.Hash(),
	)

	hash.Extend([]byte("bar"))

	assert.Equal(t,
		[]byte{0x63, 0x5c, 0x18, 0xb1, 0x5e, 0xf5, 0xc5, 0xd6, 0xc0, 0x20, 0xe7, 0x23, 0x39, 0xdd, 0xef, 0xd8, 0xb0, 0x5c, 0x4c, 0x4a, 0x44, 0xb3, 0x4e, 0xff, 0x8c, 0xef, 0x22, 0x6f, 0x89, 0x2, 0x77, 0x2},
		hash.Hash(),
	)
}
