// Code generated by go run tools/import_commands.go --talos-version v1.10.3 disks
// DO NOT EDIT.

// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

package commands

import (
	"errors"

	"github.com/spf13/cobra"
)

var disksCmd = &cobra.Command{
	Use:    "disks",
	Short:  "Get the list of disks from /sys/block on the machine",
	Long:   ``,
	Hidden: true,
	RunE: func(cmd *cobra.Command, args []string) error {
		return errors.New("`talosctl disks` is deprecated, please use `talosctl get disks`, `talosctl get systemdisk`, `talosctl get discoveredvolumes` instead")
	},
}

func init() {
	disksCmd.Flags().StringSliceVarP(&disksCmdFlags.configFiles, "file",
		"f", nil, "specify config files or patches in a YAML file (can specify multiple)",
	)
	disksCmd.PreRunE = func(cmd *cobra.Command, args []string) error {
		nodesFromArgs := len(GlobalArgs.Nodes) > 0
		endpointsFromArgs := len(GlobalArgs.Endpoints) > 0
		for _, configFile := range disksCmdFlags.configFiles {
			if err := processModelineAndUpdateGlobals(configFile, nodesFromArgs, endpointsFromArgs,
				false); err != nil {
				return err
			}
		}
		return nil
	}

	addCommand(disksCmd)
}

var disksCmdFlags struct {
	configFiles []string
}
