<?php
// +----------------------------------------------------------------------
// | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
// +----------------------------------------------------------------------
// | Author: CRMEB Team <admin@crmeb.com>
// +----------------------------------------------------------------------
namespace crmeb\services\template\storage;

use app\services\message\SystemNotificationServices;
use crmeb\services\template\BaseMessage;
use crmeb\services\app\MiniProgramService;
use think\facade\Log;

/**
 * 订阅消息
 * Class Subscribe
 * @package crmeb\services\template\storage
 */
class Subscribe extends BaseMessage
{
    protected $error;

    protected function initialize(array $config)
    {
        parent::initialize($config); // TODO: Change the autogenerated stub
    }

    /**
     * @param string $templateId
     * @return mixed
     */
    public function getTempId(string $templateId)
    {
        return app()->make(SystemNotificationServices::class)->value(['routine_tempkey' => $templateId], 'routine_tempid');
    }

    /**
     * 发送订阅消息
     * @param string $tempid
     * @param array $data
     * @return bool|\EasyWeChat\Support\Collection|mixed|null
     */
    public function send(string $tempid, array $data = [])
    {
        if (!$tempid) {
            return $this->setError('Template ID does not exist');
        }
        if (!$this->openId) {
            return $this->setError('Openid does not exist');
        }
        try {
            $res = MiniProgramService::sendSubscribeTemlate($this->openId, $tempid, $data, $this->toUrl);
            $this->clear();
            return $res;
        } catch (\Throwable $e) {
            Log::error('发送给openid为:' . $this->openId . '小程序订阅消息失败,模板id为:' . $tempid . ';错误原因为:' . $e->getMessage());
            return $this->setError($e->getMessage());
        }
    }

    public function delete(string $templateId)
    {
        // TODO: Implement delete() method.
    }

    public function add(string $shortId)
    {
        // TODO: Implement add() method.
    }

    public function list()
    {
        // TODO: Implement list() method.
    }

    /**
     * 设置错误信息
     * @param string|null $error
     * @return bool
     */
    protected function setError(?string $error = null)
    {
        $this->error = $error ?: '未知错误';
        return false;
    }

    /**
     * 获取错误信息
     * @return string
     */
    public function getError()
    {
        $error = $this->error;
        $this->error = null;
        return $error;
    }
}
