<?php
// +----------------------------------------------------------------------
// | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
// +----------------------------------------------------------------------
// | Author: CRMEB Team <admin@crmeb.com>
// +----------------------------------------------------------------------
namespace crmeb\services\template\storage;

use app\services\message\SystemNotificationServices;
use crmeb\services\template\BaseMessage;
use crmeb\services\app\WechatService;
use think\facade\Log;

class Wechat extends BaseMessage
{
    protected $error;

    /**
     * 初始化
     * @param array $config
     * @return mixed|void
     */
    protected function initialize(array $config)
    {
        parent::initialize($config); // TODO: Change the autogenerated stub
    }

    /**
     * @param string $templateId
     * @return mixed
     */
    public function getTempId(string $templateId)
    {
        return app()->make(SystemNotificationServices::class)->value(['wechat_tempkey' => $templateId], 'wechat_tempid');
    }

    /**
     * 发送消息
     * @param string $tempid
     * @param array $data
     * @return bool|mixed
     */
    public function send(string $tempid, array $data = [], $wechatToRoutine = 0)
    {
        if (!$tempid) {
            return $this->setError('Template ID does not exist');
        }
        if (!$this->openId) {
            return $this->setError('Openid does not exist');
        }
        try {
            $res = WechatService::sendTemplate($this->openId, $tempid, $data, $this->toUrl, $this->color, $wechatToRoutine);
            $this->clear();
            return $res;
        } catch (\Exception $e) {
            Log::error('发送给openid为:' . $this->openId . '微信模板消息失败,模板id为:' . $tempid . ';错误原因为:' . $e->getMessage());
            return $this->setError($e->getMessage());
        }
    }

    /**
     * 获取所有模板
     * @return \EasyWeChat\Support\Collection|mixed
     */
    public function list()
    {
        return WechatService::noticeService()->getPrivateTemplates();
    }

    /**
     * 添加模板消息
     * @param string $shortId
     * @return \EasyWeChat\Support\Collection|mixed
     */
    public function add(string $shortId)
    {
        return WechatService::noticeService()->addTemplate($shortId);
    }

    /**
     * 删除模板消息
     * @param string $templateId
     * @return \EasyWeChat\Support\Collection|mixed
     */
    public function delete(string $templateId)
    {
        return WechatService::noticeService()->deletePrivateTemplate($templateId);
    }

    /**
     * 返回所有支持的行业列表
     * @return \EasyWeChat\Support\Collection
     */
    public function getIndustry()
    {
        return WechatService::noticeService()->getIndustry();
    }

    /**
     * 设置模版消息行业
     * @return \EasyWeChat\Support\Collection
     */
    public function setIndustry($one, $two)
    {
        return WechatService::noticeService()->setIndustry($one, $two);
    }

    /**
     * 设置错误信息
     * @param string|null $error
     * @return bool
     */
    protected function setError(?string $error = null)
    {
        $this->error = $error ?: '未知错误';
        return false;
    }

    /**
     * 获取错误信息
     * @return string
     */
    public function getError()
    {
        $error = $this->error;
        $this->error = null;
        return $error;
    }
}
