--
-- 表的结构 `eb_agent_level`
--

CREATE TABLE IF NOT EXISTS `eb_agent_level` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '等级名称',
  `image` varchar(255) NOT NULL DEFAULT '' COMMENT '背景图',
  `one_brokerage` smallint(5) NOT NULL DEFAULT '0' COMMENT '一级分拥上浮比例',
  `one_brokerage_percent` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '一级分佣比例',
  `two_brokerage` smallint(5) NOT NULL DEFAULT '0' COMMENT '二级分拥上浮比例',
  `two_brokerage_percent` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '二级分佣比例',
  `grade` smallint(5) NOT NULL DEFAULT '0' COMMENT '等级',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='分销员等级表';

--
-- 转存表中的数据 `eb_agent_level`
--

INSERT INTO `eb_agent_level` (`id`, `name`, `image`, `one_brokerage`, `one_brokerage_percent`, `two_brokerage`, `two_brokerage_percent`, `grade`, `status`, `is_del`, `add_time`) VALUES
(1, '一级分销', '/statics/system_images/spread_level_1.png', 1, '11.00', 1, '6.00', 1, 0, 0, 1630310923),
(2, '二级分销', '/statics/system_images/spread_level_2.png', 2, '12.00', 1, '7.00', 1, 0, 0, 1630311000),
(3, '三级分销', '/statics/system_images/spread_level_3.png', 3, '13.00', 1, '8.00', 1, 0, 0, 1630311024),
(4, '四级分销', '/statics/system_images/spread_level_4.png', 4, '14.00', 1, '9.00', 1, 0, 0, 1630311052),
(5, '五级分销', '/statics/system_images/spread_level_5.png', 5, '15.00', 1, '10.00', 1, 0, 0, 1630311069);

-- --------------------------------------------------------

--
-- 表的结构 `eb_agent_level_task`
--

CREATE TABLE IF NOT EXISTS `eb_agent_level_task` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `level_id` int(10) NOT NULL DEFAULT '0' COMMENT '分销等级id',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '任务名称',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '任务类型',
  `number` int(10) NOT NULL DEFAULT '0' COMMENT '任务限定数',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '任务描述',
  `is_must` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必须达成0:其一1:所有',
  `sort` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='分销员等级任务表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_agent_level_task_record`
--

CREATE TABLE IF NOT EXISTS `eb_agent_level_task_record` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `uid` int(10) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `level_id` int(10) NOT NULL DEFAULT '0' COMMENT '等级id',
  `task_id` int(10) NOT NULL DEFAULT '0' COMMENT '任务id',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='分销员完成等级任务表记录表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_agreement`
--

CREATE TABLE IF NOT EXISTS `eb_agreement` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '协议类型  1：会员协议,2:代理商协议',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '协议名称',
  `content` text COMMENT '协议内容',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序倒序',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '1：显示：0：不显示',
  `add_time` int(50) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `type` (`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='会员协议' ROW_FORMAT=DYNAMIC;

--
-- 转存表中的数据 `eb_agreement`
--

INSERT INTO `eb_agreement` (`id`, `type`, `title`, `content`, `sort`, `status`, `add_time`) VALUES
(1, 1, '付费会员协议', '<p>请认真阅读并理解以下内容，本协议是您与西安众邦网络科技有限公司之间就SVIP会员所订立的契约。请您仔细阅读本协议，会员购买成功后本协议即构成对双方有约束力的法律文件。</p><p><br/></p><h4>第1条 相关定义</h4><p><br/></p><p>1.1 SVIP会员：SVIP 会员是为商城客户打造的高级会员服务，通过提供高品质的客户服务，让网购变的更加方便，省钱和放心。</p><p>1.5 实名信息：用户开通SVIP会员需保证商城用户信息真实，同一自然人如有多个商城账号，可同时开通对应的多个会员。</p><p><br/></p><h4>第2条 本站服务条款的确认和接纳</h4><p><br/></p><p>2.1 本站所提供的SVIP会员试用期及正式期活动的所有权和运作权归本公司所有。</p><p>2.2 用户支付会员成功，即视为用户确认自己同意接受SVIP会员相关服务的条款，且同意按本协议内容履行，如产生用户相关责任的，同意承担相应法律责任。</p><p>2.3 如果您在18周岁以下，您只能在父母或监护人的监护参与下方能参与体验该服务。</p><p>2.4 本公司保留在中华人民共和国大陆地区法施行之法律允许的范围内独自决定拒绝服务、关闭用户账户、清除或编辑内容等相关权利。</p><p>2.5 SVIP会员开通后，您在已开通的服务期内不能主动取消服务或终止资格。</p><p><br/></p><h4>第3条 SVIP会员权益</h4><p><br/></p><p>3.1 会员特价：商城部分商品可享受会员特价</p><p>3.2&nbsp;会员优惠券：会员每月可领优惠券，会员优惠券用户在会员期间30天内未使用，自动作废；</p><p>3.3&nbsp;消费返利：消费返X倍积分</p><p>3.4&nbsp;签到返利：签到得多倍积分</p><p>3.5&nbsp;运费折扣：享受运费折扣XX折</p><p>3.6&nbsp;支付优惠：线下扫码付款享折扣优惠</p><p><br/></p><h4>第4条 用户会员使用注意事项</h4><p><br/></p><p>4.1 服务开通后，用户应谨慎合理的保存、使用其用户名和密码，不得将在本站注册获得的账户借给他人使用，否则用户应承担由此产生的全部责任，同时本公司在该种情况下有权做出独立判断，可采取暂停或关闭用户会员资格等措施。</p><p>4.3 用户同意，商城拥有通过邮件、短信电话等形式，向其发送相关活动信息等必要信息的权利。</p><p>4.4 SVIP用户通过账号操作的各项行为应符合法律法规规定、平台规则规定及SVIP会员正式用户协议，当出现违规行为、违规订单及违规账号时，本公司有权按照上述平台内规则对您的账号和订单予以处理，如冻结或关闭账号、取消订单、暂停或停止提供服务、关闭会员开通资格、关停已开通的会员服务，已绑定的或获取的SVIP会员权益被全部/部分取消或暂停使用等操作，且不进行任何赔偿或补偿。如给本公司或相关方造成损失，用户需承担全部责任。从公平合理的角度，您应知晓所有通过该账户实现的操作产生的全部后果由您自行承担。</p><p>4.5 SVIP用户违规行为包含但不限于以下行为时，本公司有权关闭您的SVIP会员开通资格、关停您已开通的SVIP会员服务，已绑定的或获取的SVIP会员权益被全部/部分取消或暂停使用，且不退还已支付的会员服务费用。从公平合理的角度，您应知晓所有通过该账户实现的操作产生的全部后果或损失由您自行承担。</p><p>1）利用SVIP会员服务进行盈利或非法获利；</p><p>2）以任何形式转让或转移SVIP会员服务或SVIP会员权益；</p><p>3）将SVIP会员服务或会员权益借给他人使用、代他人下单；</p><p>4）通过任何不正当手段或以违反诚实信用原则的方式开通SVIP会员服务，如恶意绕过正常开通流程；</p><p>5）使用SVIP会员权益获取的商品或服务并非用于个人消费或使用；</p><p>7）用户在使用会员服务时，存在套取优惠利差、虚假下单交易、提供虚假交易信息等扰乱交易秩序、违反交易规则的行为；</p><p>8）经本公司判断，SVIP用户行为不符合公平原则或诚实信用原则的情形。</p><p><br/></p><p>4.6 SVIP会员兑换码：即由本公司提供的开通SVIP正式会员识别码，用户可在实体会员卡扫码进入开通入口输入，系统识别成功后该账户便可享受相应期限的SVIP正式会员服务。</p><p>4.6.1 每个SVIP会员兑换码仅限兑换一次，一经绑定，仅可用于被绑定的账户，不能解绑或换账户使用。</p><p>4.6.2 SVIP会员兑换码一旦兑换，属个人所有，个人应妥善保管，本公司不对SVIP会员兑换码的泄露、丢失、被盗等其他不能使用或不能激活的情况负责。</p><p>4.6.3 用户通过正当途径获取的SVIP会员兑换码，不得进行销售。若发现立即冻结，兑换码置为失效，通过此码激活开通的账户也将终止SVIP会员资格，用户双方全部加入黑名单。</p><p><br/></p><h4>第6条 法律管辖和适用</h4><p><br/></p><p>本公司有权以网站公告的方式进行不定期地制定、修改本协议及/或相关服务规则，暂停、取消和修改本协议条款，修改后的协议一旦被公告在本站上即生效，并代替原来的协议。用户应及时关注不时发布的各项服务规则及本协议的变更。若不同意相关规则及条款修改的，应及时终止与本站的协议。如用户继续使用本网站提供的服务的，即视为同意更新后的协议。建议您在使用本站之前阅读本协议及本站的公告。如缔约方就本协议内容或其执行发生任何争议，双方应尽力友好协商解决；协商不成时，任何一方均可向西安市未央区中级人民法院提起诉讼。</p><p><br/></p><h4>第7条 其他</h4><p><br/></p><p>7.1 公司网站所有者是指在政府部门依法许可或备案的网站经营主体。</p><p>7.2 &nbsp;如因不可抗力或其它本站无法控制的原因使本站活动服务无法及时提供或无法按本协议进行的，公司会合理地尽力协助处理善后事宜。</p><p>7.3 本协议自您购买成功SVIP之日起生效</p><p><br/></p>', 0, 1, 1664275153),
(2, 2, '代理商规则', '<p><b>代理商协议</b><br/><br/>在接受本协议之前，请您仔细阅读本协议全部内容。如果您对本协议的条款有疑问，请通过商城客服进行咨询，我们会向您解释条款内容。如果您不同意本协议的任何内容，或者无法准确理解商城对条款的解释，请不要进行后续操作。<br/><br/><b>第一条：立约目的</b><br/><br/>1.1 为了规范商城平台经营秩序，明确代理商及平台的权利义务，保障各方及消费者的合法权益，特拟定本协议。<br/><br/><b>第二条：签约主体</b><br/><br/>2.1 本协议由商城经营者（平台）与申请成为分销商的用户签署。<br/><br/><b>第三条：协议生效和适用范围</b><br/><br/>3.1 您通过网络页面点击确认或以其他方式选择接受本协议，即表示您与平台已达成协议并同意接受本协议的全部约定内容。本协议自您的申请获得平台通过时生效，在您使用代理商身份期间持续有效，在您的代理商身份取消时自动失效。<br/><br/>3.2 本协议内容包括协议正文以及所有平台已发布或将来可能发布的各类规则、操作流程。平台有权以修改、更新等方式不时调整本协议和相关规则的内容。除非您明示并通知平台不愿接受调整后的内容，否则调整后的内容将于修改之日起开始生效<br/><br/><b>第四条：代理商入驻</b><br/><br/>4.1 您申请入驻平台代理商需符合代理商的入驻条件，并通过申请页面提交申请。<br/><br/>4.2 如果您的申请通过平台审核，您可在审核通过之日起与平台确立分销代理关系。代理合作关系确立后，代理商可登录系统后台，添加公司成员成立事业部及代理项目组，并分配激励奖金<br/><br/><b>第五条：代理商承诺与保证</b><br/><br/>5.1 您承诺遵守本协议以及之后平台公布的规则及流程。<br/><br/>5.2 代理商在平台开展的经营活动应遵循诚实守信原则，遵纪守法，为消费者提供优质的商品和服务，快速高效处理交易纠纷。<br/><br/>5.3 代理商与平台有权自行协商解除双方的代理合作关系。如代理商违反平台规则，平台有权立即解除与代理商的合作关系，但合作关系解除前双方已产生的权利义务与责任不受合作关系终止的影响。<br/><br/><b>第六条：协议终止</b><br/><br/>6.1 自然终止：当商城平台停止运营或商城《用户协议》等终止时，则本协议将同时终止。<br/><br/>6.2 通知解除：平台可提前7天以公告或书面通知的方式终止本协议而无需承担违约责任<br/><br/>6.3 单方面除权：出现下列情况之一的，平台有权立即终止本协议，且按有关规则对您进行处罚：<br/><br/>（1）您违反本协议中的任何承诺或保证，包括但不限于本协议项下的任何约定；<br/><br/>（2）您违反平台的相关条款、协议、规则、通告等相关规定，而被平台停止提供服务的；<br/><br/>（3）您被平台清退。<br/><br/>6.4 本协议规定的其他协议终止条件发生或实现，导致本协议终止。<br/><br/>6.5 本协议终止后，代理商无权继续分销产品，但本协议终止前发生的交易，代理商仍需按照本协议的约定向消费者继续履行相关义务。<br/><br/><b>第七条：禁止商业贿赂</b><br/><br/>您不得向平台员工提供任何形式的不正当利益，如有，无论您是否实际获得利益，平台均有权立即解除本合同，并向平台赔偿因此事造成的损失金额。<br/><br/><b>第八条：违约责任</b><br/><br/>您明确理解并同意，如您违反有关法律法规、相关规则或者本协议之规定，使平台遭受任何损失，受到消费者或任何第三方的索赔或者遭受任何行政管理部门的处罚，您应对平台进行全额赔偿，包括合理的律师费用。<br/><br/><b>第九条：免责及有限责任</b><br/><br/>9.1 平台将在现有技术的基础上尽最大努力提供相应的安全措施以保障服务安全和正常运行。但由于可能存在的计算机病毒、网络通讯故障、系统维护等方面的因素以及可能发生的不可抗力事件，平台在此明确声明对服务不作任何明示或暗示的保证，包括但不限于对服务的可适用性、没有错误或疏漏、持续性、准确性、可靠性、适用于某一特定用途。<br/><br/>9.2 本协议的签署、您的入驻审核通过，并不意味着平台对您的入驻身份、资质、履约能力等行为或您自行上传、发布的信息的真实性、准确性、合法性、有效性承担任何明示或暗示的保证或担保等责任。因您的行为导致的任何投诉、纠纷、争议、赔偿等您应以自己的名义独立承担所有法律责任。<br/><br/><b>第十条：其他约定</b><br/><br/>本协议适用于中华人民共和国地区法律。因平台与您就本协议的签订、履行或解释发生争议，双方应努力友好协商解决。如协商不成，您同意由被告住所地人民法院管辖审理双方的纠纷或争议。</p>', 0, 1, 1666918814),
(3, 3, '隐私协议', '<p>本隐私政策与您所使用的CRMEB服务以及该服务所包括的各种业务功能（以下统称“我们的产品与/或服务”）息息相关，希望您在使用我们的产品与/或服务前仔细阅读并确认您已经充分理解本隐私政策所写明的内容，并让您可以按照本隐私政策的指引做出您认为适当的选择。本隐私政策中涉及的相关术语，我们尽量以简明扼要的表述，并提供进一步说明的链接，以便您更好地理解。</p><p>&nbsp;</p><p><strong>一、我们如何收集和使用您的个人信息</strong></p><p>个人信息是以电子或者其他方式记录的与已识别或者可识别的自然人有关的各种信息，不包括匿名化处理后的信息。敏感个人信息是一旦泄露或者非法使用，容易导致自然人的人格尊严受到侵害或者人身、财产安全受到危害的个人信息，包括生物识别、宗教信仰、特定身份、医疗健康、金融账户、行踪轨迹等信息，以及不满十四周岁未成年人的个人信息。</p><p>我们会遵循正当、合法、必要的原则，出于本政策所述的以下目的，收集和使用您在使用产品与/或服务过程中主动提供或因使用产品与/或服务而产生的个人信息，以及从第三方获取您的相关个人信息。如果我们要将您的个人信息用于本政策未载明的其他用途，或将基于特定目的收集而来的信息用于其他目的，我们将以合理的方式向您告知，并在使用前再次征得您的同意。</p><p><strong>（一）您须授权我们收集和使用您个人信息的情形</strong></p><p>我们的产品与/或服务包括一些核心功能，这些功能包含了实现网上购物所必须的功能及保障交易安全所必须的功能。我们可能会收集、保存和使用下列与您有关的信息才能实现上述这些功能。如果您不提供相关信息，您将无法享受我们提供的产品与/或服务。这些功能包括：</p><p>1、实现网上购物所必须的功能</p><p><strong>（1）账号注册、登录与验证</strong></p><p>当您注册CRMEB账号时，您至少需要向我们提供您准备使用的CRMEB账号名、密码、手机号码、电子邮箱，我们将通过发送短信验证码或邮件的方式来验证您的身份是否有效，通过SIM卡信息识别并显示对应的运营商。您的账号名为您的默认昵称，您可以修改和补充您的昵称、性别、生日以及您的实名认证相关信息，这些信息均属于您的“账号信息”。您补充的账号信息将有助于我们为您提供个性化的商品推荐和更优的购物体验，但如果您不提供这些补充信息，不会影响您使用网上购物的基本功能。</p><p>当您成功注册CRMEB账号后，可以使用CRMEB账号登录“CRMEB商城”，登录时您需要向我们提供您的CRMEB账号信息。若您不提供这类信息，您将无法登录和在“CRMEB商城”购买商品，此时您可使用浏览和搜索功能，我们将不会收集您的上述个人信息。</p><p><strong>您可以选择仅使用您本人的脸部信息为您本人所持有的账号使用刷脸登录服务。为了通过您的人脸信息来确认您本人身份，您同意并授权我们获取您在本账号下的个人实名身份信息（姓名、身份证号码、身份证件照片）和面部照片，以便结合您的身份信息、人脸信息来核验您的身份。您若不希望您提供的面部识别信息被我们保存后用于后续您授权的比对核验，您可以选择撤回授权，退出后您的面部识别信息将不再用于后续的比对核验。具体撤回路径为“我的-账户设置-账户与安全-刷脸登录”。</strong></p><p><strong>（2）商品/服务信息展示和搜索</strong></p><p>为了向您展示商品或者服务，我们会收集您的设备信息（包括设备名称、设备型号、MAC地址及IMEI、设备识别码、移动应用列表等软硬件特征信息、操作系统和应用程序版本、语言设置、分辨率、服务提供商网络ID（PLMN））、设备所在位置相关信息（包括您授权的GPS位置信息以及WLAN接入点、蓝牙和基站传感器信息）、浏览器类型来对相应的商品或者服务内容进行排序以适应您的设备界面。</p><p>为了向您提供搜索历史、浏览记录、收藏的商品或店铺、关注的店铺、购物车或订单商品或服务展示服务，我们会收集您的浏览信息、搜索记录、收藏记录、关注记录、加购信息、订单信息。</p><p>我们会根据您的上述信息以及其他您已授权的信息，进行数据分析、预测您的偏好特征，在CRMEB服务或者其他第三方应用中向您推送您可能感兴趣的商品/服务、商业广告、商业性短信及其他营销信息。如您需修改向您展示的商品或服务排序或者商业性广告及其他内容，可通过以下方式实现：</p><p>1）&nbsp;如您对首页“为你推荐”展示的商品或服务不感兴趣，可以通过长按被推荐的商品或服务图片，根据提示弹窗选择减少或者屏蔽相关商品或服务类目；</p><p>2）&nbsp;如您不想接收搜索页为您综合推荐的商品或服务，可以选择按销量、价格或者其他页面可选的维度接收相应的搜索结果展示；</p><p>3）&nbsp;如您不想接收商业性短信，可以根据短信内容提示，来取消我们给您发送的手机促销短信；</p><p>4）&nbsp;如您不想接收APP发送的消息通知，可以通过移动端APP“消息中心-消息设置”设置；</p><p>5）&nbsp;如您想管理我们给您发送的个性化广告，您可以在“我的-账户设置-通用-隐私设置-广告管理”中进行设置。<a href=\"http://jzt.jd.com/public/adManage/index.html\">点击前往</a>。</p><p>6）&nbsp;如您想管理我们给您发送的个性化内容，您可以在“我的-账户设置-通用-隐私设置-推荐管理”中进行设置。<a href=\"http://cfe.m.jd.com/privatedomain/prstate/index.html\">点击前往</a>。</p><p>7）&nbsp;其他：您可通过PC端账户设置页面的邮件订阅菜单中取消邮件订阅的促销信息。</p><p><strong>（3）下单及订单管理</strong></p><p>当您准备对您购物车内的商品进行结算时，CRMEB系统会生成您购买商品的订单。您需要在订单中至少填写您的收货人姓名、收货地址以及手机号码，同时该订单中会载明订单号、您所购买的商品或服务信息、下单时间、您应支付的货款金额及支付方式；您可以另外填写收货人的联系电话、邮箱地址信息以增加更多的联系方式确保商品可以准确送达，但不填写这些信息不影响您订单的生成。若您需要开具发票，还需要提供发票抬头、纳税人识别号以及接收发票的电子邮箱。</p><p>在实现部分特殊类型商品或服务交易时还需要您提供其他必要信息，例如您在CRMEB上办理预订机票、火车票、酒店、跟团旅行、购买手机号卡或合约机、办理宽带、跨境交易、申请节能补贴等业务时，您可能需要根据国家法律法规或服务提供方（包括票务销售方、酒店、旅行社及其授权的代理方、基础电信运营商、移动转售运营商、海关等）的要求<strong>提供您的实名信息，这些实名信息可能包括您的身份信息（比如您的出生证明、户口本、身份证、军官&nbsp;证、护照、驾驶证等载明您身份信息的证件复印件或号码）、您本人的照片或视频、姓名、电话号码。这些订单中将可能包含您的行程、酒店地址、您指定的服务地址或设备安装地址（可能是您的家庭地址）信息。</strong>在您为手机购买意外险时，可能还需要您提供<strong>手机IMEI信息</strong>。</p><p>上述所有信息构成您的“订单信息”，我们将使用您的订单信息来（包括与为您提供上述服务的第三方）进行您的身份核验、确定交易、支付结算、完成配送、为您查询订单以及提供客服咨询与售后服务。我们还会使用您的订单信息来判断您的交易是否存在异常以保护您的交易安全。</p><p><strong>（4）支付功能</strong></p><p>在您下单后，您可以选择CRMEB的关联方或与CRMEB合作的第三方支付机构（包括CRMEB支付、微信支付及银联、网联等支付通道，以下称“支付机构”）所提供的支付服务。我们需要将您的CRMEB订单号与交易金额信息与这些支付机构共享以完成下单支付功能。在您使用支付功能时，支付机构会通过其页面收集或验证您的银行卡（含储蓄卡、信用卡）及其他支付必要信息，以实现其确认您的支付指令并完成支付，具体适用各支付机构相应的隐私政策。为便于您正常使用钱包功能，您开通、使用CRMEB钱包的账户金额信息会在相应的支付机构页面展示。</p><p><strong>（5）交付产品与/或服务功能</strong></p><p>在当您下单并选择货到付款或在线完成支付，或选择获取试用品、奖品后，CRMEB、CRMEB的关联方、供应商、与CRMEB合作的商家或第三方配送公司（以下称“配送公司”）将为您完成订单的交付。您知晓并同意，CRMEB、CRMEB的关联方、供应商、与CRMEB合作的商家或配送公司会在上述环节内使用您的订单信息以保证您的订购的商品能够安全送达。</p><p>我们的配送员在为您提供配送服务的同时，基于某些业务法律要求实名认证的需求，会协助您完成实名认证，如您购买手机号卡服务时。我们在此环节会使用您的身份证通过国家有权认证机构的专有设备对您的身份进行核验，我们不会收集您的身份证信息，且我们的配送员均须遵守公司保密制度的规定。</p><p><strong>（6）客服与售后功能</strong></p><p>我们的电话客服和售后功能会使用您的账号信息和订单信息。为保证您的账号安全，我们的呼叫中心客服和在线客服会使用您的账号信息与您核验您的身份。当您需要我们提供与您订单信息相关的客服与售后服务时，我们将会查询您的订单信息。您有可能会在与我们的客服人员沟通时，提供给出上述信息外的其他信息，如当您要求我们变更配送地址、联系人或联系电话。</p><p>若您有获赠或购买商品运费险，您在退换货时所产生的运费可能申请由运费险服务提供商进行赔付，为实现投保和理赔，我们将收集或查询您购买商品的质保起止期、退换货商品快递公司、快递单号、退货地址、投递时间信息。</p><p>2、保障交易安全所必须的功能</p><p>为保障您使用我们的产品与/或服务时系统的稳定性和安全性，防止您的个人信息被非法获取，更准确地预防欺诈和保护账号安全，我们需要收集您的设备信息（设备型号、设备Mac地址、应用进程列表、设备识别码、设备序列号、操作系统及软件版本、设备状态、网络状况）、历史上网记录、日志信息、面部信息、IP地址、位置信息、浏览信息、订单信息、常用软件列表、ssid、wifi信息、IMSI、SIM卡信息、电池使用情况来识别是否为真实自然人用户、是否为异常地点登录、判断您的账号风险，并可能会记录一些我们认为有风险的链接（“URL”）；我们也会收集您的设备信息用于对CRMEB系统问题进行分析、统计流量并排查可能存在的风险，在您选择向我们发送异常信息时予以排查。如果您不提供上述信息，我们则无法在您使用CRMEB服务过程中对您的服务及账号安全进行保护。</p><p><strong>（二）您可自主选择提供的个人信息的情形</strong></p><p>为使您购物更便捷或更有乐趣，从而提升您在CRMEB的网上购物体验，我们在扩展功能中可能会收集和使用您的个人信息。如果您不提供这些个人信息，您依然可以进行网上购物，但您可能无法使用为您带来购物乐趣的扩展功能或在购买某些商品时需要重复填写一些信息。关于这些扩展功能收集的信息和使用目的，<a href=\"http://h5.m.jd.com/babelDiy/Zeus/KJCAdgAUBfQdFqk9QunevchtAAw/index.html?showhead=no\">详见此处</a>。</p><p>请您注意，您开启任一权限即代表您授权我们可以收集和使用相关个人信息来为您提供对应服务，您一旦关闭任一权限即代表您取消了授权，我们将不再基于对应权限继续收集和使用相关个人信息，也无法继续为您提供该权限所对应的服务。您关闭权限的决定不会影响此前基于您的授权所进行的信息收集及使用。</p><p><strong>（三）我们从第三方获得您个人信息的情形</strong></p><p>我们可能从第三方获取您授权共享的账号信息（头像、昵称及授权页面提示的其他信息），并在您同意本隐私政策后将您的第三方账号与您的CRMEB账号绑定，使您可以通过第三方账号直接登录并使用我们的产品与/或服务。我们会将依据与第三方的约定、对个人信息来源的合法性进行确认后，在符合相关法律和法规规定的前提下，使用您的这些个人信息。您也可以使用本机号码来快捷登录，我们会将您的网络信息提供给运营商完成注册或登录。</p><p>（四）CRMEBAPP涉及嵌入第三方代码、插件传输个人信息的情形逐项列举，<a href=\"http://h5.m.jd.com/babelDiy/Zeus/2TUXHKBMgpgckQbcrDvhX4mxjLc7/index.html?showhead=no\">请见此处</a>。</p><p><strong>（五）您个人信息使用的规则</strong></p><p>1、我们会根据本隐私政策的内容，为实现我们的产品与/或服务功能对所收集的个人信息进行使用。<br/>&nbsp;&nbsp;&nbsp; 2、在收集您的个人信息后，我们将通过技术手段对数据进行去标识化处理。<br/>&nbsp;&nbsp;&nbsp; 3、当我们展示您的个人信息时，我们会采用包括去标识化或者匿名化处理方式对您的信息进行脱敏，以保护您的信息安全。</p><p><strong>4、为统计我们的产品/服务使用情况，我们会对经过技术处理的用户数据进行汇总、分析和使用，并与第三方共享处理后的统计信息。我们会通过安全加密的技术处理方式以及其他方式保障信息接收方无法重新识别特定个人。</strong><br/>&nbsp;&nbsp;&nbsp; 5、当我们要将您的个人信息用于本隐私政策未载明的其它用途时，或基于特定目的收集而来的信息用于其他目的时，会事先征求您的明示同意。</p><p><strong>请您理解，我们向您提供的产品与/或服务将不断更新变化。如果您选择使用本隐私政策中尚未列明的其他产品与/或服务时，我们会在收集您的个人信息前通过协议、页面提示等方式向您详细说明信息收集的目的、方式、范围并征求您的同意。若您不同意提供前述信息，您可能无法使用该项产品与/或服务，但不影响您使用现有产品与/或服务。</strong></p><p>&nbsp;</p><p><strong>二、我们如何使用Cookies和同类技术</strong></p><p><strong>（一）Cookies的使用</strong></p><p>1、为实现您联机体验的个性化需求，使您获得更轻松的访问体验。我们会在您的计算机或移动设备上发送一个或多个名为Cookies的小数据文件，指定给您的Cookies&nbsp;是唯一的，它只能被将Cookies发布给您的域中的Web服务器读取。我们向您发送Cookies是为了简化您重复登录的步骤、存储您的购物偏好或您购物车中的商品等数据进而为您提供购物的偏好设置、帮助您优化对广告的选择与互动、帮助判断您的登录状态以及账号或数据安全。</p><p>2、我们不会将&nbsp;Cookies&nbsp;用于本隐私政策所述目的之外的任何用途。您可根据自己的偏好管理或删除Cookies。您可以清除计算机上保存的所有&nbsp;Cookies，大部分网络浏览器会自动接受Cookies，但您通常可根据自己的需要来修改浏览器的设置以拒绝&nbsp;Cookies；另外，您也可以清除软件内保存的所有Cookies。但如果您这么做，您可能需要在每一次访问CRMEB网站时亲自更改用户设置，而且您之前所记录的相应信息也均会被删除，并且可能会对您所使用服务的安全性有一定影响。</p><p><strong>（二）网络Beacon和同类技术的使用</strong></p><p>除Cookies外，我们还会在网站上使用网络Beacon等其他同类技术。我们的网页上常会包含一些电子图像（称为\"单像素\" GIF&nbsp;文件或&nbsp;\"网络&nbsp;Beacon\"）。我们使用网络Beacon的方式有：<br/>&nbsp;&nbsp;&nbsp;&nbsp;（1）通过在CRMEB网站上使用网络Beacon，计算用户访问数量，并通过访问&nbsp;Cookies&nbsp;辨认注册的CRMEB用户。<br/>&nbsp;&nbsp;&nbsp;&nbsp;（2）通过得到的Cookies信息，为您提供个性化服务。</p><p>&nbsp;</p><p><strong>三、我们如何对外提供您的个人信息</strong></p><p><strong>（一）共享</strong></p><p>1、我们不会与CRMEB以外的任何公司、组织和个人共享您的个人信息，但以下情况除外：<br/>&nbsp;&nbsp;&nbsp;&nbsp;（1）事先获得您明确的同意或授权；<br/>&nbsp;&nbsp;&nbsp;&nbsp;（2）根据法律法规、行政及司法部门强制性要求进行提供；<br/>&nbsp;&nbsp;&nbsp;&nbsp;（3）在法律法规允许的范围内，为维护CRMEB、CRMEB的关联方或合作伙伴、您或其他CRMEB用户或社会公众利益、财产或安全免遭损害而有必要提供；<br/>&nbsp;&nbsp;&nbsp;&nbsp;（4）只有共享您的个人信息，才能实现我们的产品与/或服务的核心功能或提供您需要的服务；<br/>&nbsp;&nbsp;&nbsp;&nbsp;（5）应您需求为您处理您与他人的纠纷或争议；<br/>&nbsp;&nbsp;&nbsp;&nbsp;（6）符合与您签署的相关协议（包括在线签署的电子协议以及相应的平台规则）或其他的法律文件约定所提供；<br/>&nbsp;&nbsp;&nbsp;&nbsp;（7）基于学术研究而使用；<br/>&nbsp;&nbsp;&nbsp;&nbsp;（8）基于符合法律法规的社会公共利益、突发公共卫生事件而使用。</p><p>2、为向您提供相关产品或服务，向您展示可能感兴趣的内容，保护您的账号与交易安全，我们可能会将您的个人信息与我们的关联方或者合作伙伴共享，共享内容及目的<a href=\"http://h5.m.jd.com/babelDiy/Zeus/2TUXHKBMgpgckQbcrDvhX4mxjLc7/index.html?showhead=no\"><strong>详见此处</strong></a>。我们的关联方或者合作伙伴如要改变个人信息的处理目的，将再次征求您的授权同意。</p><p><strong>请您注意，您在使用我们服务时自愿共享甚至公开分享的信息，可能会涉及您或他人的个人信息甚至敏感个人信息。请您共享时谨慎考虑并决定。</strong></p><p><strong>（二）委托处理</strong></p><p>我们可能委托授权合作伙伴处理您的个人信息，以便向您提供相应的产品或服务。但我们仅会出于合法、正当、必要、特定、明确的目的共享您的个人信息，并且只会共享提供产品或服务所必要的个人信息。如果我们的合作伙伴将您的个人信息用于我们未委托的用途，其将单独征得您的同意。</p><p>我们的合作伙伴包括以下类型：</p><p>（1）提供技术服务的供应商。我们可能会将您的个人信息提供给支持我们功能的第三方，包括为我们提供基础设施技术服务、数据分析服务及数据处理服务等的供应商。</p><p>（2）广告、分析服务类合作伙伴。我们会遵守法律法规及行业通用安全技术，委托这些合作伙伴处理与广告投放、覆盖面和有效性相关的信息。</p><p>对我们委托合作伙伴处理个人信息的，我们会与其签署数据保护协议，要求其按照协议约定、本隐私政策以及相关法律法规要求来处理个人信息。为了保障数据在第三方安全可控，我们推出了云鼎服务，在云端提供安全可靠的数据使用和存储环境，确保用户数据的安全性。</p><p><strong>（三）转移</strong></p><p>在因合并、分立、解散、被宣告破产等原因需要转移个人信息的，我们会向您告知接收方的名称或者姓名和联系方式，要求接收您个人信息的公司、组织继续受本隐私政策的约束，否则，我们将要求该公司、组织重新向您征求授权同意。</p><p><strong>（四）公开披露</strong></p><p>我们仅会在以下情况，且在采取符合业界标准的安全防护措施的前提下，才会公开披露您的个人信息：<br/>&nbsp;&nbsp;&nbsp;&nbsp;（1）根据您单独同意的授权范围披露相应个人信息；<br/>&nbsp;&nbsp;&nbsp;&nbsp;（2）如果您严重违反法律法规或者相关协议、规则，我们可能会披露您的相关违规行为及我们对您采取的措施。</p><p>&nbsp;</p><p><strong>四、我们如何保护和保存您的个人信息</strong></p><p><strong>（一）我们保护您个人信息的技术与措施</strong></p><p>我们非常重视个人信息安全，并采取一切合理可行的措施，保护您的个人信息：</p><p>1、数据安全技术措施</p><p>我们会采用符合业界标准的安全防护措施，包括建立合理的制度规范、安全技术来防止您的个人信息遭到未经授权的访问使用、修改，避免数据的损坏或丢失。例如：CRMEB的网络服务采取了传输层安全协议等加密技术，通过https等方式提供浏览服务，确保用户数据在传输过程中的安全；CRMEB采取加密技术对用户个人信息进行加密保存，并通过隔离技术进行隔离；在个人信息使用时，例如个人信息展示、个人信息关联计算，我们会采用包括内容替换、SHA256在内多种数据脱敏技术增强个人信息在使用中安全性；CRMEB采用严格的数据访问权限控制和多重身份认证技术保护个人信息，避免数据被违规使用；CRMEB采用代码安全自动检查、数据访问日志分析技术进行个人信息安全审计。</p><p>2、CRMEB为保护个人信息采取的其他安全措施</p><p>CRMEB通过建立数据分类分级制度、数据安全管理规范、数据安全开发规范来管理规范个人信息的存储和使用；通过信息接触者保密协议、监控和审计机制来对数据进行全面安全控制；CRMEB建立数据安全委员会并下设信息保护专职部门、数据安全应急响应组织来推进和保障个人信息安全。</p><p>我们存储您个人信息的底层云技术取得了数据中心联盟颁发的“可信云”认证三级认证、通过了公安部安全等级保护三级认证，同时还获得了ISO27000认证。我们还会举办安全和隐私保护培训课程，加强员工对于保护个人信息重要性的认识。</p><p>我们仅允许有必要知晓这些信息的CRMEB及CRMEB关联方的员工、合作伙伴访问个人信息，并为此设置了严格的访问权限控制和监控机制。我们同时要求可能接触到您个人信息的所有人员履行相应的保密义务。</p><p>互联网并非绝对安全的环境，而且电子邮件、即时通讯、社交软件等与其他用户的交流方式无法确定是否完全加密，我们建议您使用此类工具时请使用复杂密码，并注意保护您的个人信息安全。在通过CRMEB与第三方进行网上产品与/或服务的交易时，您不可避免的要向交易对方或潜在的交易对方披露自己的个人信息，如联络方式或者邮政地址等。请您妥善保护自己的个人信息，仅在必要的情形下向他人提供。</p><p>3、安全事件处置</p><p>为应对个人信息泄露、损毁和丢失等可能出现的风险，我们制定了多项制度，明确安全事件、安全漏洞的分类分级标准及相应的处理流程。我们也为安全事件建立了专门的应急响应团队，按照安全事件处置规范要求，针对不同安全事件启动安全预案，进行止损、分析、定位、制定补救措施、联合相关部门进行溯源和打击。</p><p>一旦发生个人信息安全事件后，我们将按照法律法规的要求，及时向您告知：安全事件的基本情况和可能的影响、我们已采取或将要采取的处置措施、您可自主防范和降低风险的建议、对您的补救措施等。同时，我们将及时将事件相关情况以邮件、信函、电话、推送通知等方式告知您，难以逐一告知个人信息主体时，我们会采取合理、有效的方式发布公告。同时，我们还将按照监管部门要求，主动上报个人信息安全事件的处置情况。</p><p>如果您对我们的个人信息保护有任何疑问，可通过本隐私政策中约定的联系方式联系我们。如您发现自己的个人信息泄密，尤其是您的账号及密码发生泄露，请您立即通过本隐私政策“八、如何联系我们”中明确的联系方式联络我们，以便我们采取相应措施。</p><p><strong>（二）您个人信息的保存</strong></p><p>1、您的个人信息将存储于中华人民共和国境内。如您使用跨境交易服务，且需要向境外传输您的个人信息完成交易的，我们会单独获取您的授权同意并要求接收方按照双方签署的数据保护协议、本隐私政策以及相关法律法规要求来处理您的个人信息。</p><p>2、在您使用我们的产品与/或服务期间，您的个人信息将在为了实现本政策所述目的之期限内保存，同时将结合法律有强制的留存要求期限的规定确定，如《中华人民共和国电子商务法》要求商品和服务信息、交易信息保存时间自交易完成之日起不少于三年。在超出保存期间后，我们会根据适用法律的要求删除您的个人信息，或进行匿名化处理。</p><p>3、请您注意，当您成功注销CRMEB账号后，我们会根据适用法律的要求删除您的个人信息，或进行匿名化处理。</p><p>4、如果我们终止服务或运营，我们会至少提前三十日向您通知，并在终止服务或运营后对您的个人信息进行删除或匿名化处理。</p><p>&nbsp;</p><p><strong>五、您如何管理您的个人信息</strong></p><p>CRMEB非常重视您对个人信息的关注，并尽全力保护您对于您个人信息访问、更正、删除以及撤回同意的权利，以使您拥有充分的能力保障您的隐私和安全。您的权利包括：</p><p>1、访问和更正您的个人信息</p><p>除法律法规规定外，您有权随时访问和更正您的个人信息，具体包括：</p><p>（1）您的账号信息：PC端您可以在“我的CRMEB”页面的“账户设置”菜单中查阅您提交给CRMEB的个人信息，你也可通过上述途径更新除实名认证信息之外的其他个人信息，您的实名认证信息是您通过实名认证时使用的姓名和身份证信息，如您需要变更您的实名认证信息，您可拨打95118服务热线申请变更。移动端具体路径为：账号名称、个人资料信息：首页--“我的”进入我的CRMEB--右上角“设置”进入账号设置—点击头像进入个人信息页账号密码、电话号码、安全信息：首页--“我的”进入我的CRMEB--右上角“设置按钮”--账户与安全；兴趣爱好：首页--“我的”进入我的CRMEB--商品关注、店铺关注、喜欢的内容（具体名称以网页内容为准）。</p><p>（2）您的收货信息：PC端您可以通过访问“我的CRMEB”页面的“账户设置”-“收货地址”菜单中随时添加、更改、删除您的收货地址信息（包括收货人姓名、收货地址、收货人的电话号码或邮箱）；移动端具体路径为：首页--“我的”进入我的CRMEB--右上角“设置按钮”进入账号设置--地址管理。您也可以将最常用的收货地址设置为默认地址，如此，若您下次购买商品时未更改收货地址，您的商品会配送到该默认地址。</p><p>（3）您的订单信息：PC端您可以通过访问“我的订单”页面查看您的所有已经完成、待付款或待售后的订单。移动端具体路径为：移动端首页--“我的”进入我的CRMEB--我的订单/待收款/待收货/退换售后。您可以选择删除已经完成和已取消的订单来删除您的订单信息，但这样可能导致我们无法准确判断您的购买信息而难以提供相应的售后服务，您也无法对删除的订单使用我们的晒单和评价功能。</p><p>（4）您的浏览信息：您可以访问或清除您的搜索历史记录、查看和修改兴趣以及管理其他数据。移动端路径为：搜索历史记录：首页--“我的”进入我的CRMEB--浏览记录；</p><p>（5）您的评论信息：PC端您可以访问您的个人评论，或对商品进行追评。移动端路径为：我的CRMEB--待评价--评价中心。</p><p>（6）您的发票信息：您可以访问或更新或清除您的发票信息，移动端路径为首页--“我的”进入我的CRMEB--右上角“设置”进入账号设置--增票资质。</p><p>（7）您的档案信息：您可以在移动端“账户设置-档案”中，主动添加您的爱车型号、宝宝昵称、性别、生日和学龄、设备型号、尺码、健康档案，使您在购买相关产品和服务时更加便捷，也便于我们向您推荐您可能感兴趣的商品。您可通过此路径对您的上述信息进行删除和修改。</p><p>对于您在使用我们的产品与/或服务过程中产生的其他个人信息需要访问或更正，请随时联系我们。我们会根据本隐私政策所列明的方式和期限响应您的请求。</p><p>2、删除您的个人信息</p><p>您在我们的产品与/或服务页面中可以直接清除或删除的信息，包括订单信息、浏览信息、收货地址信息。</p><p><strong>在以下情形中，您可以向我们提出删除个人信息的请求：</strong></p><p>（1）如果我们处理个人信息的行为违反法律法规；</p><p>（2）如果我们收集、使用您的个人信息，却未征得您的同意；</p><p>（3）如果我们处理个人信息的行为严重违反了与您的约定；</p><p>（4）如果您不再使用我们的产品或服务，或您注销了CRMEB账号；</p><p>（5）如果我们终止服务及运营，或者保存期限已届满。</p><p>若我们决定响应您的删除请求，我们还将同时尽可能通知从我们获得您的个人信息的实体，要求其及时删除，除非法律法规另有规定，或这些实体已获得您的独立授权。</p><p><strong>请您注意，当您成功注销</strong><strong>CRMEB</strong><strong>账号后，我们将对您的个人信息进行删除或匿名化处理。当您或我们协助您删除相关信息后，因为适用的法律和安全技术限制，我们可能无法立即从系统中删除相应的信息，我们将安全地存储您的个人信息并限制对其的任何进一步的处理，直到可以删除或实现匿名化。</strong></p><p>3、改变您授权同意的范围或撤回您的授权</p><p><strong>您可以通过删除信息、关闭设备功能、在</strong><strong>CRMEB</strong><strong>网站或软件中进行隐私设置等方式改变您授权我们继续收集个人信息的范围或撤回您的授权。您也可以通过注销账号的方式，撤回我们继续收集您个人信息的全部授权。</strong></p><p><strong>请您理解，每个业务功能需要一些基本的个人信息才能得以完成，当您撤回同意或授权后，我们无法继续为您提供撤回同意或授权所对应的服务，也不再处理您相应的个人信息。但您撤回同意或授权的决定，不会影响此前基于您的授权而开展的个人信息处理。</strong></p><p>4、注销账号</p><p><strong>您可以在我们的产品中直接申请注销账号。您可以通过移动端APP访问“我的--账户设置-账户与安全-注销</strong><strong>CRMEB</strong><strong>商城服务”完成账号注销；您还可以通过PC端访问“我的</strong><strong>CRMEB</strong><strong>-账户设置-账户安全-注销账号”完成账号注销。关于您注销账号的方式以及您应满足的条件，请详见《</strong><a href=\"http://h5.m.jd.com/babelDiy/Zeus/4HbRrL7MHffRBEuB9AgLNUwAaSos/index.html\"><strong>CRMEB</strong><strong>商城服务账号注销须知</strong></a><strong>》。您注销账号后，我们将停止为您提供产品与/或服务，并</strong>根据适用法律的要求删除您的个人信息，或进行匿名化处理。</p><p>5、获取您的个人信息副本</p><p>您有权获取您的个人信息副本。如您需要获取我们收集的您的个人信息副本，您随时联系我们。在符合相关法律规定且技术可行的前提下，我们将根据您的要求向您提供相应的个人信息副本。</p><p>6、响应您的请求</p><p>如果您无法通过上述方式访问、更正或删除您的个人信息，或您需要访问、更正或删除您在使用我们产品与/或服务时所产生的其他个人信息或者获取个人信息副本，或您认为CRMEB存在任何违反法律法规或与您关于个人信息的收集或使用的约定，您均可以发送电子邮件至<a href=\"mailto:privacy@jd.com\">privacy@***.com</a>或通过本隐私政策中的其他方式与我们联系。为了保障安全，我们可能需要您提供书面请求，或提供您的身份证明文件，我们将在收到您反馈并验证您的身份后的15天内答复您的请求。对于您合理的请求，我们原则上不收取费用，但对多次重复、超出合理限度的请求，我们将视情收取一定成本费用。对于那些无端重复、需要过多技术手段（例如，需要开发新系统或从根本上改变现行惯例）、给他人合法权益带来风险或者非常不切实际（例如，涉及备份磁带上存放的信息）的请求，我们可能会予以拒绝。</p><p>&nbsp;</p><p><strong>六、未成年人的个人信息保护</strong></p><p>1、CRMEB非常重视对未成年人个人信息的保护。若您是18周岁以下的未成年人，在使用我们的产品与/或服务前，<strong>应事先取得您监护人的同意</strong>。CRMEB根据国家相关法律法规的规定保护未成年人的个人信息。</p><p>2、我们不会主动直接向未成年人收集其个人信息。对于经监护人同意而收集未成年人个人信息的情况，我们只会在受到法律允许、监护人同意或者保护未成年人所必要的情况下使用、共享、转让或披露此信息。</p><p>3、如果有事实证明未成年人在未取得监护人同意的情况下注册使用了我们的产品与/或服务，我们会与相关监护人协商，并设法尽快删除相关个人信息。</p><p>4、对于可能涉及的不满14周岁的儿童个人信息，我们进一步采取以下措施予以保障：</p><p>（1）对于收集到的儿童个人信息，我们除遵守本隐私政策关于用户个人信息的约定外，还会秉持正当必要、知情同意、目的明确、安全保障、依法利用的原则，严格遵循《儿童个人信息网络保护规定》等法律法规的要求进行存储、使用、披露，且不会超过实现收集、使用目的所必须的期限，到期后我们会对儿童个人信息进行删除或匿名化处理。我们会指定专人负责儿童个人信息保护事宜，并设立了儿童个人信息保护的专门邮箱childprivacy@***.com。我们还会制定儿童个人信息保护的内部专门制度。</p><p>（2）当您作为监护人为被监护的儿童选择使用CRMEB相关服务时，我们可能需要向您收集被监护的儿童个人信息，用于向您履行相关服务之必要。在具体服务中需要向您收集儿童个人信息的，我们会事先取得您的授权同意，并告知您收集的目的和用途。如果您不提供前述信息，您将无法享受我们提供的相关服务。此外，您在使用晒单、评价及问答功能分享商品相关信息时可能会主动向我们提供儿童个人信息，请您明确知悉并谨慎选择。您作为监护人应当正确履行监护职责，保护儿童个人信息安全。若儿童本人需要注册或使用我们的产品与/或服务，您应正确引导并予以监护。</p><p>（3）儿童或其监护人有权随时访问和更正儿童个人信息，还可以向我们提出更正和删除的请求。如您对儿童个人信息相关事宜有任何意见、建议或投诉、举报，请联系我们。我们会随时为您提供帮助。</p><p>&nbsp;</p><p><strong>七、通知和修订</strong></p><p>1、为给您提供更好的服务以及随着CRMEB业务的发展，本隐私政策也会随之更新。但未经您明确同意，我们不会削减您依据本隐私政策所应享有的权利。我们会通过在CRMEB网站、CRMEB移动端上发出更新版本并在生效前通过网站公告或以其他适当方式提醒您相关内容的更新，也请您访问CRMEB以便及时了解最新的隐私政策。</p><p>2、对于重大变更，我们还会提供更为显著的通知（我们会通过包括但不限于邮件、短信或在浏览页面做特别提示等方式，说明隐私政策的具体变更内容）。</p><p>本隐私政策所指的重大变更包括但不限于：</p><p>（1）我们的服务模式发生重大变化。如处理个人信息的目的、处理的个人信息类型、个人信息的使用方式等；</p><p>（2）我们在所有权结构、组织架构等方面发生重大变化。如业务调整、破产并购等引起的所有者变更等；</p><p>（3）个人信息共享、转移或公开披露的主要对象发生变化；</p><p>（4）您参与个人信息处理方面的权利及其行使方式发生重大变化；</p><p>（5）我们负责处理个人信息安全的责任部门、联络方式及投诉渠道发生变化时；</p><p>（6）个人信息安全影响评估报告表明存在高风险时。</p><p>3、我们还会将本隐私政策的旧版本存档，供您查阅。</p><p>4、为了您能及时接收到通知，建议您在联系方式更新时及时通知我们。如您在本政策更新生效后继续使用我们的服务，即代表您已充分阅读、理解并接受更新后的政策并愿意受更新后的政策约束。我们鼓励您在每次使用我们服务时都查阅本政策。您可以在CRMEBAPP通过“我的-账户设置-关于CRMEBAPP-隐私政策”中查看本政策。</p><p>&nbsp;</p><p><strong>八、如何联系我们</strong></p><p>1、如您对本隐私政策或您个人信息的相关事宜或者投诉、举报、有任何问题、意见或建议，请通过以下方式与我们联系。</p><p>个人信息保护负责人邮箱<a href=\"mailto:privacy@jd.com\">privacy@***.com</a></p><p>联系电话：【950618】</p><p>联系地址：北京亦庄经济技术开发区科创11街18号院</p><p>您还可以随时通过访问<a href=\"http://help.jd.com/\">http://help.***.com</a>在线客服系统或拨打我们的任何一部客服电话等多种方式与我们联系。</p><p>2、一般情况下，我们将在15天内回复。如果您对我们的回复不满意，特别是我们的个人信息处理行为损害了您的合法权益，您还可以向网信、电信、公安及工商等监管部门进行投诉或举报。</p><p>&nbsp;</p><p>附：个人信息及敏感个人信息示例（非CRMEBAPP或网站所收集的个人信息，仅作示例说明）</p><p>个人信息是以电子或者其他方式记录的与已识别或者可识别的自然人有关的各种信息，不包括匿名化处理后的信息。敏感个人信息是一旦泄露或者非法使用，容易导致自然人的人格尊严受到侵害或者人身、财产安全受到危害的个人信息，包括生物识别、宗教信仰、特定身份、医疗健康、金融账户、行踪轨迹等信息，以及不满十四周岁未成年人的个人信息。（本定义出自于《中华人民共和国个人信息保护法》）。</p><p><br/></p>', 0, 1, 1664275172),
(4, 4, '用户协议', '<h3>一、注册协议条款的确认和接受</h3><p>***网(以下亦称“本网站”)同意按照本协议的规定及其不定时发布的操作规则提供基于互联网和移动互联网的相关服务(以下称“网络服务”)。</p><p>为获得网络服务, 申请人应当认真阅读、充分理解本《协议》中各条款, 包括免除或者限制文都责任的免责条款及对用户的权利限制条款。审慎阅读并选择接受或不接受本《协议》(未成年人应在法定监护人陪同下阅读)。</p><p>同意接受本协议的全部条款的, 申请人应当按照页面上的提示完成全部的注册程序, 并在注册程序过程中点击“同意”按钮, 否则视为不接受本《协议》全部条款, 申请人应当终止并退出申请。</p><p>本《协议》可由文都定期更新, 更新后的协议条款一旦公布即代替原来的协议条款, 恕不再另行通知, 用户可在文都查阅最新版协议条款。在文都修改《协议》条款后, 如果用户不接受修改后的条款, 请立即停止使用文都提供的网络服务, 继续使用的用户将被视为已接受了修改后的协议。</p><h3>二、服务内容</h3><p>1、网络服务的具体内容由文都根据实际情况提供, 包括学习资讯、学习工具、文都社群、文都问答、SIS在线测评、文都直播、文都网校、文都中小学、文都国际教育、文都考研集训营、泉题库及其旗下APP相关应用等服务。</p><p>2、提供的网络服务包括收费和免费。收费服务包括但不限于文都网、文都网校和APP的部分收费课程, 用户使用收费网络服务需要支付约定费用。对于收费服务, 文都会在用户使用之前给予用户明确的提示, 只有用户根据提示确认同意支付相关费用, 用户才能使用该等收费服务。如用户未支付相关费用, 则文都有权不向用户提供该等收费服务。</p><p>3、用户理解, 文都仅提供文都明确承诺的网络服务, 除此之外与相关网络服务有关的设备(如个人电脑、手机、及其他与接入互联网或移动网有关的装置)及所需的费用(如为接入互联网而支付的电话费及上网费、为使用移动网络而支付的手机费)均应由用户自行负担。</p><p>4、用户理解，文都网/文都网校/文都直播平台提供并提请用户在购买课程前先完整试听。用户可按《文都网校退班政策说明》除特别说明外，包括但不限于PC端和移动端下载课件在内的所有服务均附期限，到期终止。用户应在截止日期前享受其购买的服务。</p><h3>三、用户帐号</h3><p>1、经本网站注册系统完成注册程序并通过身份认证的用户即为正式用户。</p><p>2、如发现用户帐号中含有不雅文字或不恰当名称的, 文都保留注销其用户帐号的权利。</p><p>3、用户帐号的所有权归文都, 用户完成申请注册手续后, 用户享有使用权。3个月未使用的用户账号, 文都保留收回的权利。</p><p>4、用户有义务保证密码和帐号的安全, 用户利用该帐号所进行的一切活动引起的任何损失或损害, 由用户自行承担全部责任, 文都不承担任何责任。如用户发现帐号遭到未授权的使用或发生其他任何安全问题, 应立即修改账号密码并妥善保管。因黑客行为或用户的保管疏忽导致帐号非法使用, 文都不承担任何责任。</p><p><strong>5、用户帐号和密码仅由初始申请注册人使用，用户不得将自己用户账户或密码有偿或无偿以转让、出借、授权等方式提供给第三人操作和使用, 否则用户应当自行承担因违反此要求而遭致的任何损失。违反本项约定的，文都并保留收回账号的权利。若因违反本约定对他人造成损害的，用户应与实际使用人承担连带赔偿责任，同时文都保留追究用户违约责任的权利。</strong></p><p>6、用户帐号在丢失、遗忘密码及因合用产生使用权归属纠纷后, 须遵照文都的申诉途径请求找回帐号。用户可以凭初始注册资料向文都申请找回帐号。文都的账户恢复机制仅负责识别申请用户所提资料与系统记录资料是否一致, 而无法识别申诉人是否系帐号的真正使用权人。对用户因被他人冒名申请而致的任何损失, 文都不承担任何责任, 用户知晓帐号及密码保管责任在于用户, 文都并不承诺帐号丢失或遗忘密码后用户一定能通过申诉找回帐号。用户应当谨慎填写初始手机号或注册邮箱作为确认接收争议帐号的指定邮箱。</p><p>7、文都建议用户应当使用本人名义为用户账户充值或行使付款行为。若用户存在使用第三人的名义进行充值或付款，或委托第三人代为充值或付款之行为的，则以上行为被视作本人的行为，若由于该第三人行为导致充值或付款行为失败或成功后又被撤销的，均被认为是用户本人真实意思的表示和用户本人实施的行为，由此所造成的一切法律后果均由用户自行承担。</p><h3>四、使用规则</h3><p>1、用户在使用文都网络服务过程中, 必须遵循国家的相关法律法规, 不得发布危害国家安全、色情、暴力、侵犯版权等任何合法权利等非法内容; 也不得利用文都平台发布含有虚假、有害、胁迫、侵害他人隐私、骚扰、侵害、中伤、粗俗、或其它道德上令人反感的内容。</p><p>2、本网站可依其合理判断, 对违反有关法律法规或本协议约定; 或侵犯、妨害、威胁任何人权利或安全的内容, 或者假冒他人的行为, 文都有权停止传输任何前述内容, 并有权依其自行判断对违反本条款的任何用户采取适当的法律行动, 包括但不限于, 删除具有违法性、侵权性、不当性等内容, 阻止其使用文都全部或部分网络服务, 并且依据法律法规保存有关信息并向有关部门报告等。</p><p>3、对于经由本网络服务而传送的内容, 文都不保证前述内容的正确性、完整性或品质。用户在接受本服务时, 有可能会接触到令人不快、不适当或令人厌恶的内容。在任何情况下, 文都均不对任何内容负责, 包括但不限于任何内容发生任何错误或纰漏以及衍生的任何损失或损害。文都有权(但无义务)自行拒绝或删除经由文都网络服务提供的任何内容。用户使用上述内容, 应自行承担风险。</p><p>4、对于用户通过本网络服务(包括但不限于文都网、文都社群、文都中小学、文都国际教育、文都网校、泉题库、SIS在线测评及对应APP、相关应用等服务)上传到文都上可公开获取区域的任何内容, 用户同意文都在全世界范围内具有免费的、永久性的、不可撤销的、非独 家的和完全再许可的权利和许可, 以使用、复制、修改、改编、出版、翻译、据以创作衍生作品、传播、表演和展示此等内容(整体或部分), 和/或将此等内容编入当前已知的或以后开发的其他任何形式的作品、媒体或技术中。</p><p>5、用户通过文都网络服务所发布的任何内容并不反映文都的观点或政策, 文都对此不承担任何责任。用户须对上述内容的真实性、合法性、无害性、有效性等全权负责, 与用户所发布信息相关的任何法律责任由用户自行承担, 与文都无关。</p><h3>五、版权声明</h3><p>本网站提供的网络服务中包含的任何文本、图片、图形、音频和/或视频资料均受版权、商标和/或其它财产所有权法律的保护, 未经相关权利人同意, 上述资料均不得在任何媒体直接或间接发布、播放、出于播放或发布目的而改写或再发行, 或者被用于其他任何商业目的。所有以上资料或资料的任何部分仅可作为私人和非商业用途保存。文都不就由上述资料产生或在传送或递交全部或部分上述资料过程中产生的延误、不准确、错误和遗漏或从中产生或由此产生的任何损害赔偿, 以任何形式, 向用户或任何第三方负责。</p><h3>六、隐私保护</h3><p>1、保护用户隐私是文都的一项基本政策, 本网站保证不对外公开或向第三方提供用户的注册资料及用户在使用网络服务时存储在文都内的非公开内容, 但下列情况除外:</p><p>（1）事先获得用户的书面明确授权;</p><p>（2）根据有关的法律法规要求;</p><p>（3）按照相关政府主管部门的要求;</p><p>（4）为维护社会公众的利益;</p><p>（5）为维护本网站的合法权益;</p><p>2、为了更好地为用户提供全面服务，用户同意文都可将用户注册资料及使用信息提供文都关联公司使用。文都保证前述关联公司同等级地严格遵循本协议第六条第1款之隐私保护责任。</p><p>3、用户同意：文都或文都运营商的关联公司在必要时有权根据用户注册时或接受服务时所提供的联系信息（包括但不限于电子邮件地址、联系电话、联系地址、即时聊天工具账号等），通过电子邮件、电话、短信、邮寄、即时聊天、弹出页面等方式向用户发送如下信息：</p><p>（1）各类重要通知信息，可能包括但不限于订单、交易单、修改密码提示等重要信息。此类信息可能对用户的权利义务产生重大的有利或不利影响，用户务必及时关注。</p><p>（2）商品和服务广告、促销优惠等商业性信息。若用户不愿意接收此类信息，则可通过告知（口头或书面）的方式通知文都或文都运营商的关联公司取消发送，亦可通过文都或文都运营商关联公司所提供的相应退订功能（若有）进行退订。</p><h3>七、协议的用途、更新和效力</h3><p>1、本协议之服务条款用以规范用户使用文都提供的服务,本协议与文都社区行为准则构成完整的协议。</p><p>2、鉴于国家法律法规不时变化及文都运营之需要，文都有权对本协议条款不时地进行修改，修改后的协议一旦被公布于文都上即告生效，并替代原来的协议。 用户有义务不时关注并阅读最新版的协议及网站公告。如用户不同意更新后的协议，则应立即停止接受文都依据本协议提供的服务；若用户继续使用文都提供的服务的，即视为同意更新后的协议。 如果本协议中任何一条被视为废止、无效或因任何理由不可执行，该条应视为可分的且并不影响任何其余条款的有效性和可执行性。</p><h3>八、联系方式</h3><p>当您有个人信息相关问题或其他的投诉、建议等，可以通过如下方式与文都联系，文都将尽快审核所涉及内容，并于15个工作日内对于您的问题、投诉、建议进行回复；</p><p><br/></p><p><br/></p>', 0, 1, 1664275182),
(5, 5, '注销协议', '<p><strong>&nbsp;注销CRMEB帐号是不可恢复的操作</strong>，你应自行备份CRMEB帐号相关的信息和数据。操作之前，请确认与CRMEB帐号相关的所有服务均已进行妥善处理。</p><p><strong>&nbsp; 请谨记</strong>：注销CRMEB帐号，你将无法再使用本CRMEB帐号或找回你添加或绑定的任何内容或信息（即使你使用相同的手机号码再次注册并使用CRMEB），包括但不限于：</p><p>（1）你将无法登录、使用本CRMEB帐号。你的朋友将无法通过本CRMEB帐号联系你。</p><p>（2）你CRMEB帐号的个人资料和历史信息（包含昵称、头像、二维码名片、消息记录、朋友圈内容、相片、收藏等）都将无法找回。</p><p>（3）注销CRMEB帐号前，你必须注销CRMEB支付（国内及海外）账户。你需妥善处理CRMEB支付账户下所有资金问题。</p><p>（4）你通过CRMEB帐号使用、授权登录或绑定CRMEB帐号后使用的CRMEB公司或第三方的其他服务（包括但不限于CRMEB游戏、理财通、CRMEB支付、第三方网站、第三方游戏、城市服务、生活缴费、机船车票、微粒贷、微票儿、京东、大众点评、美丽说、滴滴出行等）的所有记录将无法找回。你将无法再登录、使用前述服务，你曾获得的充值余额、游戏道具、积分、会籍、资格、订单、优惠券、礼品卡、票券及其他卡券等视为你自行放弃，将无法继续使用。你理解并同意，CRMEB无法协助你重新恢复前述服务。</p><p>（5）你CRMEB帐号所关注的所有CRMEB公众帐号将被取消关注，与CRMEB公众帐号的所有功能或服务都将无法继续使用。</p><p>（6）如果你的CRMEB帐号同时是CRMEB公众帐号（包括：订阅号、服务号、企业号、小程序等）、CRMEB开放平台开发者帐号、企业CRMEB的管理员，你需先解除相关身份。</p><p>（7）在CRMEB帐号注销期间，如果你的CRMEB帐号被他人投诉、被国家机关调查或者正处于诉讼、仲裁程序中，CRMEB有权自行终止你CRMEB帐号的注销而无需另行得到你的同意。</p><p>&nbsp; 请注意，注销你的CRMEB帐号并不代表本CRMEB帐号注销前的帐号行为和相关责任得到豁免或减轻。</p><p><br/></p>', 0, 1, 1664275192),
(6, 6, '积分协议', '<p><b>积分适用范围</b><br/><br/>1. 积分仅可在本商城使用，如用户帐号暂停使用，则商城将取消该用户帐号内积分相关使用权益。<br/>2. 积分可直接用于支付商城网站订单。<br/>3. 积分可在积分商城兑换商品。<br/><br/><b>积分冻结期</b><br/><br/>1. 通过基础购物获得的积分，有一定的冻结期，冻结期内的积分不能使用。<br/>2. 获得积分的订单如发生退款，则冻结期内的积分会自动退回。<br/>3. 积分的冻结期以商城设置的活动规则为准。<br/><br/><b>下单时使用</b><br/><br/>1. 购买商品订单，积分和现金有一定的抵扣比例，抵扣比例由商城进行设置。<br/>2. 用户每单可使用的积分有一定的限额，限额由商城进行设置。<br/>3. 积分功能由商城选择是否使用，最终解释权归商城运营者所有<br/><br/><b>积分获取</b><br/><br/>1. 用户可通过签到获取积分，此积分无冻结期<br/>2. 用户可通过购物获取积分，此积分有冻结期</p>', 0, 1, 1666918736);

-- --------------------------------------------------------

--
-- 表的结构 `eb_app_version`
--

CREATE TABLE IF NOT EXISTS `eb_app_version` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `version` varchar(20) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '版本号',
  `platform` tinyint(1) NOT NULL DEFAULT '0' COMMENT '平台类型:1.安卓 2.IOS',
  `info` text COMMENT '升级信息',
  `url` varchar(1000) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '下载链接',
  `is_force` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否强制升级',
  `is_new` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否最新',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='APP版本表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_article`
--

CREATE TABLE IF NOT EXISTS `eb_article` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '文章管理ID',
  `cid` varchar(255) NOT NULL DEFAULT '0' COMMENT '分类id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `author` varchar(255) NOT NULL DEFAULT '' COMMENT '文章作者',
  `image_input` varchar(255) NOT NULL DEFAULT '' COMMENT '文章图片',
  `synopsis` varchar(255) NOT NULL DEFAULT '' COMMENT '文章简介',
  `share_title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章分享标题',
  `share_synopsis` varchar(255) NOT NULL DEFAULT '' COMMENT '文章分享简介',
  `visit` varchar(255) NOT NULL DEFAULT '0' COMMENT '浏览次数',
  `sort` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '排序',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '原文链接',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '状态',
  `add_time` varchar(255) NOT NULL DEFAULT '' COMMENT '添加时间',
  `hide` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `admin_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '管理员id',
  `mer_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商户id',
  `product_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品关联id',
  `is_hot` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否热门(小程序)',
  `is_banner` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否轮播图(小程序)',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='文章管理表';

--
-- 转存表中的数据 `eb_article`
--

INSERT INTO `eb_article` (`id`, `cid`, `title`, `author`, `image_input`, `synopsis`, `share_title`, `share_synopsis`, `visit`, `sort`, `url`, `status`, `add_time`, `hide`, `admin_id`, `mer_id`, `product_id`, `is_hot`, `is_banner`) VALUES
(1, '1', '祝贺：CRMEB开源商城系统Gitee star突破10000+丨CRMEB标准版优惠中', 'CRMEB', 'http://demo.crmeb.com/uploads/attach/2023/02/20230215/8634bcfc0e07137c1b6fd33c286e3cd3.png', '众邦科技秉承“开放、共享”的互联网精神，坚持开放系统、共建互联网生态，将CRM（客户关系管理）与EB（电子商务）应用场景进行深度集成，身体力行为开发者赋能，同时围绕新零售电商发展趋势，打造出CRMEB开源商城系统，坚持全开源无加密，不断丰富系统功能，支持免费商用，统一对外接口，可满足用户的多样化开发需求。', '', '', '5', 0, '', 1, '1676451047', 0, 0, 0, 0, 1, 1);

-- --------------------------------------------------------

--
-- 表的结构 `eb_article_category`
--

CREATE TABLE IF NOT EXISTS `eb_article_category` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '文章分类id',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '父级ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章分类标题',
  `intr` varchar(255) NOT NULL DEFAULT '' COMMENT '文章分类简介',
  `image` varchar(255) NOT NULL DEFAULT '' COMMENT '文章分类图片',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '状态',
  `sort` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '排序',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '1删除0未删除',
  `add_time` varchar(255) NOT NULL DEFAULT '' COMMENT '添加时间',
  `hidden` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='文章分类表';

--
-- 转存表中的数据 `eb_article_category`
--

INSERT INTO `eb_article_category` (`id`, `pid`, `title`, `intr`, `image`, `status`, `sort`, `is_del`, `add_time`, `hidden`) VALUES
(1, 0, '官方动态', '官方动态', 'http://demo.crmeb.com/uploads/attach/2023/02/20230210/ae1f27591f38ab006ae57bf4bfe2c3fb.png', 1, 0, 0, '1676450508', 0);

-- --------------------------------------------------------

--
-- 表的结构 `eb_article_content`
--

CREATE TABLE IF NOT EXISTS `eb_article_content` (
  `nid` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '文章id',
  `content` text COMMENT '文章内容',
  UNIQUE KEY `nid` (`nid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='文章内容表';

--
-- 转存表中的数据 `eb_article_content`
--

INSERT INTO `eb_article_content` (`nid`, `content`) VALUES
(1, '<p><font face=\"黑体\">众邦科技秉承“开放、共享”的互联网精神，坚持开放系统、共建互联网生态，将CRM（客户关系管理）与EB（电子商务）应用场景进行深度集成，身体力行为开发者赋能，同时围绕新零售电商发展趋势，打造出CRMEB开源商城系统，坚持全开源无加密，不断丰富系统功能，支持免费商用，统一对外接口，可满足用户的多样化开发需求。</font></p><p><strong><font face=\"黑体\">做开源项目很难，做出好的开源项目更难，6年，我们坚守初心，未来，我们会一直坚持！</font></strong></p><p><font face=\"黑体\"><strong>CRMEB开源商城系统Gitee地址： </strong><a href=\"http://gitee.com/ZhongBangKeJi/CRMEB\" target=\"_blank\">http://gitee.com/ZhongBangKeJi/CRMEB</a></font></p><p><font face=\"黑体\"><br/></font></p><p data-we-empty-p=\"\" style=\"text-align:center;\"><font face=\"黑体\"><img src=\"http://demo.crmeb.com/uploads/attach/2023/02/20230215/8634bcfc0e07137c1b6fd33c286e3cd3.png\" style=\"max-width:100%;\"/><br/></font></p><p><font face=\"黑体\"><br/></font></p><p><font face=\"黑体\">自立项以来，CRMEB开源商城系统更新千余次，累计服务40万+开发者，真正做到了赋能开发者，减少重复造轮子，帮助众多开发者快速上手，节省开发时间，提高开发效率，助力企业实现数字化经营！</font></p><p><font face=\"黑体\"><br/></font></p><h3 style=\"text-align:center;\"><strong><font color=\"#000000\" face=\"黑体\">CRMEB标准版（商业版）限时仅需598元/套</font></strong></h3><div><strong><font color=\"#000000\" face=\"黑体\"><br/></font></strong></div><p style=\"text-align:center;\"><strong><font color=\"#1c487f\" face=\"黑体\">官方正版授权、专属会员群、 赠送离线版接口文档！ 全开源无加密、方便二开、终身免费升级~</font></strong></p><p style=\"text-align:center;\"><strong><font color=\"#1c487f\" face=\"黑体\"><br/></font></strong></p><p style=\"text-align:center;\"><strong>【手机扫描下方二维码，立即咨询购买】</strong><strong><font face=\"黑体\"><br/></font></strong></p><p style=\"text-align:center;\"><font face=\"黑体\"><img src=\"http://demo.crmeb.com/uploads/attach/2023/02/20230215/ef39bf5d94bf554d07c825baa124f951.png\" style=\"max-width:100%;\"/></font><strong><br/></strong></p><h3><strong></strong></h3>');

-- --------------------------------------------------------

--
-- 表的结构 `eb_auxiliary`
--

CREATE TABLE IF NOT EXISTS `eb_auxiliary` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `binding_id` int(10) NOT NULL DEFAULT '0' COMMENT '绑定id',
  `relation_id` int(10) NOT NULL DEFAULT '0' COMMENT '关联id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '类型0=客服转接辅助，1=商品和分类辅助，2=优惠券和商品辅助',
  `other` varchar(500) NOT NULL DEFAULT '' COMMENT '其他数据为json',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='辅助表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_cache`
--

CREATE TABLE IF NOT EXISTS `eb_cache` (
  `key` varchar(32) NOT NULL DEFAULT '' COMMENT '缓存key',
  `result` text COMMENT '缓存数据',
  `expire_time` int(11) NOT NULL DEFAULT '0' COMMENT '失效时间0=永久',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '缓存时间',
  PRIMARY KEY (`key`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='微信缓存表';

--
-- 转存表中的数据 `eb_cache`
--

INSERT INTO `eb_cache` (`key`, `result`, `expire_time`, `add_time`) VALUES
('open_adv', '{\"status\":0,\"time\":\"\",\"type\":\"pic\",\"value\":[],\"video_link\":\"\"}', 0, 1642240334);

-- --------------------------------------------------------

--
-- 表的结构 `eb_capital_flow`
--

CREATE TABLE IF NOT EXISTS `eb_capital_flow` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `flow_id` varchar(32) NOT NULL DEFAULT '' COMMENT '流水id',
  `order_id` varchar(50) NOT NULL DEFAULT '' COMMENT '关联id',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT '昵称',
  `phone` varchar(20) NOT NULL DEFAULT '' COMMENT '电话',
  `price` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT '交易金额',
  `trading_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '交易类型',
  `pay_type` varchar(32) NOT NULL DEFAULT '' COMMENT '支付类型',
  `mark` varchar(500) NOT NULL DEFAULT '' COMMENT '备注',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '交易时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='资金流水表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_category`
--

CREATE TABLE IF NOT EXISTS `eb_category` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '上级id',
  `owner_id` int(10) NOT NULL DEFAULT '0' COMMENT '所属人，为全部',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '分类名称',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '分类类型0=标签分类，1=快捷短语分类',
  `other` text COLLATE utf8_unicode_ci COMMENT '其他参数',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `name` (`name`),
  KEY `is_be` (`owner_id`,`type`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='标签分类';

--
-- 转存表中的数据 `eb_category`
--

INSERT INTO `eb_category` (`id`, `pid`, `owner_id`, `name`, `sort`, `type`, `other`, `add_time`) VALUES
(1, 0, 0, '客户性别', 6, 0, NULL, 0),
(2, 0, 0, '客户来源', 10, 0, NULL, 0),
(3, 0, 0, '用过哪类产品', 8, 0, NULL, 0),
(4, 0, 0, '客户年龄段', 4, 0, NULL, 0),
(5, 0, 0, '累计消费次数', 2, 0, NULL, 0),
(6, 0, 0, '累计消费金额', 0, 0, NULL, 0);

-- --------------------------------------------------------

--
-- 表的结构 `eb_delivery_service`
--

CREATE TABLE IF NOT EXISTS `eb_delivery_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '配送员uid',
  `avatar` varchar(250) NOT NULL DEFAULT '' COMMENT '配送员头像',
  `nickname` varchar(50) NOT NULL DEFAULT '' COMMENT '配送员名称',
  `phone` varchar(20) NOT NULL DEFAULT '' COMMENT '手机号码',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '0隐藏1显示',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='配送员表' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `eb_division_agent_apply`
--

CREATE TABLE IF NOT EXISTS `eb_division_agent_apply` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `agent_name` varchar(255) NOT NULL DEFAULT '' COMMENT '代理商名称',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '用户名称',
  `phone` varchar(32) NOT NULL DEFAULT '0' COMMENT '代理商电话',
  `division_id` int(11) NOT NULL DEFAULT '0' COMMENT '事业部id',
  `division_invite` int(11) NOT NULL DEFAULT '0' COMMENT '邀请码',
  `images` varchar(2000) NOT NULL DEFAULT '' COMMENT '申请图片',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '申请时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '申请状态0申请，1同意，2拒绝',
  `refusal_reason` varchar(1000) NOT NULL DEFAULT '' COMMENT '拒绝理由',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='代理商申请表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_diy`
--

CREATE TABLE IF NOT EXISTS `eb_diy` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `version` varchar(255) NOT NULL DEFAULT '' COMMENT '版本号',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '页面名称',
  `template_name` varchar(255) NOT NULL DEFAULT '' COMMENT '模版名称',
  `value` longtext COMMENT '页面数据',
  `default_value` longtext COMMENT '默认页面数据',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否使用',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '页面类型',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '显示首页',
  `is_bg_color` tinyint(1) NOT NULL DEFAULT '0' COMMENT '颜色是否选中',
  `is_bg_pic` tinyint(1) NOT NULL DEFAULT '0' COMMENT '背景图是否选中',
  `color_picker` varchar(50) NOT NULL DEFAULT '' COMMENT '背景颜色',
  `bg_pic` varchar(256) NOT NULL DEFAULT '' COMMENT '背景图',
  `bg_tab_val` tinyint(1) NOT NULL DEFAULT '0' COMMENT '背景图图片样式',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '个人中心订单样式',
  `my_banner_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '个人中心banner是否显示',
  `is_diy` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否diy',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'diy顶部title',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='DIY数据表';

--
-- 转存表中的数据 `eb_diy`
--

INSERT INTO `eb_diy` (`id`, `version`, `name`, `template_name`, `value`, `default_value`, `add_time`, `update_time`, `status`, `type`, `is_show`, `is_bg_color`, `is_bg_pic`, `color_picker`, `bg_pic`, `bg_tab_val`, `is_del`, `order_status`, `my_banner_status`, `is_diy`, `title`) VALUES
(1, '1.0', '默认模版', 'default', '{\"headerSerch\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a01\\u5f20\\u56fe\\u7247\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6128 * 45px\",\"url\":\"\"},\"hotList\":{\"title\":\"\\u70ed\\u8bcd\\u6700\\u591a20\\u4e2a\\u5b57\\uff0c\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u70ed\\u8bcd\\u987a\\u5e8f\",\"max\":99,\"list\":[{\"val\":\"\",\"maxlength\":20}]},\"titleInfo\":{\"title\":\"\",\"type\":2,\"list\":[{\"title\":\"\\u7f51\\u7ad9\\u7b80\\u4ecb\",\"val\":\"\\u7f51\\u7ad9\\u7b80\\u4ecb\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\"}]}},\"default\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a01\\u5f20\\u56fe\\u7247\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6128 * 45px\",\"url\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230210\\/955c6bb44d8e002164bcbc2e7b3b6ea5.png\"},\"hotList\":{\"title\":\"\\u70ed\\u8bcd\\u6700\\u591a20\\u4e2a\\u5b57\\uff0c\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u70ed\\u8bcd\\u987a\\u5e8f\",\"max\":99,\"list\":[{\"val\":\"\",\"maxlength\":20}]},\"titleInfo\":{\"title\":\"\",\"type\":2,\"list\":[{\"title\":\"\\u7f51\\u7ad9\\u7b80\\u4ecb\",\"val\":\"\\u65b0\\u96f6\\u552e\\u9ad8\\u54c1\\u8d28\\u7535\\u5546\\u7cfb\\u7edf\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\"}]}}},\"swiperBg\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u5f20\\u56fe\\u7247\\uff0c\\u5efa\\u8bae\\u5bbd\\u5ea6750px\",\"max\":10,\"list\":[{\"img\":\"\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\",\"maxlength\":10,\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]}]}},\"default\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u5f20\\u56fe\\u7247\\uff0c\\u5efa\\u8bae\\u5bbd\\u5ea6750px\",\"max\":10,\"list\":[{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230213\\/c90caa5e6adfe69bac84281193d8fd3e.jpeg\",\"info\":[{\"maxlength\":10,\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\",\"title\":\"\\u6807\\u9898\",\"value\":\"\"},{\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\",\"title\":\"\\u94fe\\u63a5\",\"value\":\"\"}]}]}},\"cc\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u5f20\\u56fe\\u7247\\uff0c\\u5efa\\u8bae\\u5bbd\\u5ea6750px\",\"max\":10,\"list\":[{\"img\":\"\",\"info\":[{\"maxlength\":10,\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\",\"title\":\"\\u6807\\u9898\",\"value\":\"\"},{\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\",\"title\":\"\\u94fe\\u63a5\",\"value\":\"\"}]}]}},\"aa\":{\"isShow\":{\"val\":false},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u5f20\\u56fe\\u7247\\uff0c\\u5efa\\u8bae\\u5bbd\\u5ea6750px\",\"max\":10,\"list\":[]}}},\"menus\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a020\\u4e2a\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea696*96px\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u56fe\\u6807\\u987a\\u5e8f\",\"max\":20,\"list\":[{\"img\":\"\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/goods_cate\\/goods_cate\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]}]}},\"default\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a020\\u4e2a\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea696*96px\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u56fe\\u6807\\u987a\\u5e8f\",\"max\":20,\"list\":[{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/b8c16ea2a3256c50c52d643d4316690d.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/goods_cate\\/goods_cate\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/571e43d36aff92d990a6558aef9f8b4f.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u9886\\u4f18\\u60e0\\u5238\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/users\\/user_get_coupon\\/index\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/58fa876b83dd76b00208f0b441682a48.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u884c\\u4e1a\\u8d44\\u8baf\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/extension\\/news_list\\/index\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/cf754595c9fe1a63460e0ddee6177467.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u6211\\u7684\\u6536\\u85cf\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/users\\/user_goods_collection\\/index\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/09ef9d23b0b559714672d1438608422c.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u6211\\u8981\\u7b7e\\u5230\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/users\\/user_sgin\\/index\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]}]}}},\"tabNav\":{\"defaultVal\":{\"isShow\":{\"val\":true}},\"default\":{\"isShow\":{\"val\":true}},\"cc\":{\"isShow\":{\"val\":true}}},\"news\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u4e2a\\u6a21\\u677f\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6124 * 28px\",\"url\":\"\"},\"newList\":{\"max\":10,\"list\":[{\"chiild\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"CRMEB_PRO 1.1\\u6b63\\u5f0f\\u516c\\u6d4b\\u5566\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\u94fe\\u63a5\",\"max\":99,\"pla\":\"\\u9009\\u586b\"}]}]}},\"default\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u4e2a\\u6a21\\u677f\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6124 * 28px\",\"url\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/1109cd6ddff02f61a4dfcac584e53952.png\"},\"newList\":{\"max\":10,\"list\":[{\"chiild\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"CRMEB V4.7.0\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/extension\\/news_list\\/index\",\"max\":99,\"pla\":\"\\u9009\\u586b\"}]}]}}},\"activity\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgList\":{\"isDelete\":true,\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a03\\u7ec4\\u6a21\\u5757\\uff0c\\u7b2c\\u4e00\\u5f20260*260px,\\u540e\\u4e24\\u5f20416*124px\",\"max\":3,\"list\":[{\"img\":\"\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u4e00\\u8d77\\u6765\\u62fc\\u56e2\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u4f18\\u60e0\\u591a\\u591a\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_combination\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]},{\"img\":\"\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u79d2\\u6740\\u4e13\\u533a\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u65b0\\u80fd\\u6e90\\u6c7d\\u8f66\\u4f18\\u60e0\\u591a\\u591a\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_seckill\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]},{\"img\":\"\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u780d\\u4ef7\\u6d3b\\u52a8\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u547c\\u670b\\u5524\\u53cb\\u6765\\u780d\\u4ef7~~\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_bargain\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]}]},\"max\":3},\"default\":{\"isShow\":{\"val\":true},\"imgList\":{\"isDelete\":true,\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a03\\u7ec4\\u6a21\\u5757\\uff0c\\u7b2c\\u4e00\\u5f20260*260px,\\u540e\\u4e24\\u5f20416*124px\",\"max\":3,\"list\":[{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/846aaba3f32b030a3d090a1b3e16563f.jpg\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u79d2\\u6740\\u4e13\\u533a\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u4f18\\u60e0\\u591a\\u591a\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_seckill\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/d6bfd7015d6176d6b9ed04fa98a3872a.jpg\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u4e00\\u8d77\\u6765\\u62fc\\u56e2\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u4f18\\u60e0\\u591a\\u591a\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_combination\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/d0e891f63be13b9f46ffdaf7140cb5a0.jpg\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u780d\\u4ef7\\u6d3b\\u52a8\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u547c\\u670b\\u5524\\u53cb\\u6765\\u780d\\u4ef7~~\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_bargain\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]}]},\"max\":3}},\"alive\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u76f4\\u64ad\\u95f4\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u516d\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u7cbe\\u5f69\\u76f4\\u64ad\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"numConfig\":{\"title\":\"\\u663e\\u793a\\u6570\\u91cf\",\"val\":3}},\"default\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u76f4\\u64ad\\u95f4\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u516d\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u7cbe\\u5f69\\u76f4\\u64ad\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/live_list\\/index\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"numConfig\":{\"title\":\"\\u663e\\u793a\\u6570\\u91cf\",\"val\":3}}},\"scrollBox\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u5feb\\u901f\\u9009\\u62e9\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"type\":1,\"activeValue\":\"\",\"list\":[{\"activeValue\":\"\",\"title\":\"\"},{\"activeValue\":\"\",\"title\":\"\"}]},\"numConfig\":{\"title\":\"\\u663e\\u793a\\u6570\\u91cf\",\"val\":6},\"goodsList\":{\"max\":20,\"list\":[]}},\"default\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u5feb\\u901f\\u9009\\u62e9\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u4e0a\\u767e\\u79cd\\u5546\\u54c1\\u5206\\u7c7b\\u4efb\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/goods_cate\\/goods_cate\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"type\":1,\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"title\":\"\\u663e\\u793a\\u6570\\u91cf\",\"val\":6},\"goodsList\":{\"max\":20,\"list\":[]}}},\"adsRecommend\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u56fe\\u7247\\u5efa\\u8bae\\u5c3a\\u5bf8338 * 206px\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u7248\\u5757\\u987a\\u5e8f\",\"max\":10,\"list\":[{\"img\":\"\",\"info\":[{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]}]}},\"default\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u56fe\\u7247\\u5efa\\u8bae\\u5c3a\\u5bf8338 * 206px\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u7248\\u5757\\u987a\\u5e8f\",\"max\":10,\"list\":[{\"img\":\"\",\"info\":[{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]}]}}},\"coupon\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"numConfig\":{\"val\":10}},\"default\":{\"isShow\":{\"val\":true},\"numConfig\":{\"val\":\"8\"}}},\"seckill\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":2,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u9650\\u65f6\\u79d2\\u6740\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"default\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":2,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u9650\\u65f6\\u79d2\\u6740\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}}},\"combination\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":3,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u62fc\\u56e2\\u5217\\u8868\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"default\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":3,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u62fc\\u56e2\\u5217\\u8868\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}}},\"bargain\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":8,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u780d\\u4ef7\\u5217\\u8868\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"default\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":8,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u780d\\u4ef7\\u5217\\u8868\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}}},\"goodList\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u5feb\\u901f\\u9009\\u62e9\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"default\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u5feb\\u901f\\u9009\\u62e9\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"bb\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u6392\\u884c\\u699c\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"7\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"cc\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u9996\\u53d1\\u65b0\\u54c1\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u65b0\\u54c1\\u63a8\\u8350\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"5\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"dd\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u7cbe\\u9009\\u5355\\u54c1\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"aa\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u4fc3\\u9500\\u7cbe\\u54c1\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=4&amp;name=\\u4fc3\\u9500\\u5355\\u54c1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"6\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}}},\"picTxt\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"richText\":{\"val\":\"\"}},\"default\":{\"isShow\":{\"val\":true},\"richText\":{\"val\":\"\"}}},\"titles\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u7cbe\\u54c1\\u63a8\\u8350\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]}},\"default\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u7cbe\\u54c1\\u63a8\\u8350\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]}}},\"customerService\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a01\\u5f20\\u56fe\\u7247\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6128 * 45px\",\"url\":\"\"}},\"default\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a01\\u5f20\\u56fe\\u7247\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6128 * 45px\",\"url\":\"\"}}},\"tabBar\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"tabBarList\":{\"title\":\"\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea681*81px\",\"list\":[{\"name\":\"\\u9996\\u9875\",\"imgList\":[],\"link\":\"\\/pages\\/index\\/index\"},{\"name\":\"\\u5206\\u7c7b\",\"imgList\":[],\"link\":\"\\/pages\\/goods_cate\\/goods_cate\"},{\"name\":\"\\u8d2d\\u7269\\u8f66\",\"imgList\":[],\"link\":\"\\/pages\\/order_addcart\\/order_addcart\"},{\"name\":\"\\u6211\\u7684\",\"imgList\":[],\"link\":\"\\/pages\\/user\\/index\"}]}},\"default\":{\"isShow\":{\"val\":true},\"tabBarList\":{\"title\":\"\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea681*81px\",\"list\":[{\"name\":\"\\u9996\\u9875\",\"imgList\":[\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/a10b02faad102a90d245f94c77961d7b.png\",\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/7ba82cda74d6632df30ea997c3695f8b.png\"],\"link\":\"\\/pages\\/index\\/index\"},{\"name\":\"\\u5206\\u7c7b\",\"imgList\":[\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/fd0c4bda482619c96f955d5d45568d08.png\",\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/21887584064b02ad7f2dfb432e18f7c1.png\"],\"link\":\"\\/pages\\/goods_cate\\/goods_cate\"},{\"name\":\"\\u8d2d\\u7269\\u8f66\",\"imgList\":[\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/373a3c9241329d91fdc2c6543479d922.png\",\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/da71fa631e8fd8eee75d6ddf2d183149.png\"],\"link\":\"\\/pages\\/order_addcart\\/order_addcart\"},{\"name\":\"\\u6211\\u7684\",\"imgList\":[\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/ad6388b565f2e922459193ae50b98409.png\",\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/e81a4b8ea345d061ed2d3806a718d6be.png\"],\"link\":\"\\/pages\\/user\\/index\"}]}}}}', '{\"headerSerch\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a01\\u5f20\\u56fe\\u7247\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6128 * 45px\",\"url\":\"\"},\"hotList\":{\"title\":\"\\u70ed\\u8bcd\\u6700\\u591a20\\u4e2a\\u5b57\\uff0c\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u70ed\\u8bcd\\u987a\\u5e8f\",\"max\":99,\"list\":[{\"val\":\"\",\"maxlength\":20}]},\"titleInfo\":{\"title\":\"\",\"type\":2,\"list\":[{\"title\":\"\\u7f51\\u7ad9\\u7b80\\u4ecb\",\"val\":\"\\u7f51\\u7ad9\\u7b80\\u4ecb\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\"}]}},\"default\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a01\\u5f20\\u56fe\\u7247\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6128 * 45px\",\"url\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/b5516ae0e79ff6960882241416e2c9e8.png\"},\"hotList\":{\"title\":\"\\u70ed\\u8bcd\\u6700\\u591a20\\u4e2a\\u5b57\\uff0c\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u70ed\\u8bcd\\u987a\\u5e8f\",\"max\":99,\"list\":[{\"val\":\"\",\"maxlength\":20}]},\"titleInfo\":{\"title\":\"\",\"type\":2,\"list\":[{\"title\":\"\\u7f51\\u7ad9\\u7b80\\u4ecb\",\"val\":\"\\u4f18\\u8d28\\u7cbe\\u9009\\u597d\\u7269\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\"}]}}},\"swiperBg\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u5f20\\u56fe\\u7247\\uff0c\\u5efa\\u8bae\\u5bbd\\u5ea6750px\",\"max\":10,\"list\":[{\"img\":\"\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\",\"maxlength\":10,\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]}]}},\"default\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u5f20\\u56fe\\u7247\\uff0c\\u5efa\\u8bae\\u5bbd\\u5ea6750px\",\"max\":10,\"list\":[{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/fb73d810b31d7d54c7926e67874c9a25.png\",\"info\":[{\"maxlength\":10,\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\",\"title\":\"\\u6807\\u9898\",\"value\":\"\"},{\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\",\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/index\\/index\"}]}]}},\"cc\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u5f20\\u56fe\\u7247\\uff0c\\u5efa\\u8bae\\u5bbd\\u5ea6750px\",\"max\":10,\"list\":[{\"img\":\"\",\"info\":[{\"maxlength\":10,\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\",\"title\":\"\\u6807\\u9898\",\"value\":\"\"},{\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\",\"title\":\"\\u94fe\\u63a5\",\"value\":\"\"}]}]}},\"aa\":{\"isShow\":{\"val\":false},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u5f20\\u56fe\\u7247\\uff0c\\u5efa\\u8bae\\u5bbd\\u5ea6750px\",\"max\":10,\"list\":[]}}},\"menus\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a020\\u4e2a\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea696*96px\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u56fe\\u6807\\u987a\\u5e8f\",\"max\":20,\"list\":[{\"img\":\"\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/goods_cate\\/goods_cate\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]}]}},\"default\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a020\\u4e2a\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea696*96px\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u56fe\\u6807\\u987a\\u5e8f\",\"max\":20,\"list\":[{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/f29df730d7663c45a06c6797902b8d81.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/goods_cate\\/goods_cate\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/8367d0b2e71d7e9cb82aa5fef9a44519.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u9886\\u4f18\\u60e0\\u5238\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/users\\/user_get_coupon\\/index\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/763ed559229df299a850c3ca4a85f0bb.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u884c\\u4e1a\\u8d44\\u8baf\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/extension\\/news_list\\/index\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/e5a025afe48173efaa4a0f8fcf4abb17.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u6211\\u7684\\u6536\\u85cf\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/users\\/user_goods_collection\\/index\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/619521116dbd3546b2ef63706b861019.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u5730\\u5740\\u7ba1\\u7406\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/users\\/user_address_list\\/index\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/447dc010aa6468deff9977a044b7926d.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u79d2\\u6740\\u6d3b\\u52a8\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_seckill\\/index\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/b2c5eac9983d8c57600e7d038988a098.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u780d\\u4ef7\\u6d3b\\u52a8\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_bargain\\/index\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/df20c7238e310bbbe98bdcf190d1025a.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u62fc\\u56e2\\u6d3b\\u52a8\",\"maxlength\":5,\"tips\":\"\\u8bf7\\u586b\\u5199\\u6807\\u9898\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_combination\\/index\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/303bbdaa2137f13ffa40f23e400bfef0.png\",\"info\":[{\"maxlength\":10,\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\",\"title\":\"\\u6807\\u9898\",\"value\":\"\\u9884\\u552e\\u7ba1\\u7406\"},{\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\",\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/presell\\/index\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/b16e86cdd248429ffc08fab417a3ffd2.png\",\"info\":[{\"maxlength\":10,\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u5341\\u4e2a\\u5b57\",\"title\":\"\\u6807\\u9898\",\"value\":\"\\u79ef\\u5206\\u5546\\u57ce\"},{\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\",\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/points_mall\\/index\"}]}]}}},\"tabNav\":{\"defaultVal\":{\"isShow\":{\"val\":true}},\"default\":{\"isShow\":{\"val\":true}},\"cc\":{\"isShow\":{\"val\":true}}},\"news\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u4e2a\\u6a21\\u677f\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6124 * 28px\",\"url\":\"\"},\"newList\":{\"max\":10,\"list\":[{\"chiild\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"CRMEB_PRO 1.1\\u6b63\\u5f0f\\u516c\\u6d4b\\u5566\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\u94fe\\u63a5\",\"max\":99,\"pla\":\"\\u9009\\u586b\"}]}]}},\"default\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u4e2a\\u6a21\\u677f\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6124 * 28px\",\"url\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/95177075d29af1194e544d4dc791c751.png\"},\"newList\":{\"max\":10,\"list\":[{\"chiild\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"CRMEB V4.6.0\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/extension\\/news_list\\/index\",\"max\":99,\"pla\":\"\\u9009\\u586b\"}]}]}}},\"activity\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgList\":{\"isDelete\":true,\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a03\\u7ec4\\u6a21\\u5757\\uff0c\\u7b2c\\u4e00\\u5f20260*260px,\\u540e\\u4e24\\u5f20416*124px\",\"max\":3,\"list\":[{\"img\":\"\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u4e00\\u8d77\\u6765\\u62fc\\u56e2\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u4f18\\u60e0\\u591a\\u591a\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_combination\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]},{\"img\":\"\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u79d2\\u6740\\u4e13\\u533a\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u65b0\\u80fd\\u6e90\\u6c7d\\u8f66\\u4f18\\u60e0\\u591a\\u591a\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_seckill\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]},{\"img\":\"\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u780d\\u4ef7\\u6d3b\\u52a8\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u547c\\u670b\\u5524\\u53cb\\u6765\\u780d\\u4ef7~~\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_bargain\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]}]},\"max\":3},\"default\":{\"isShow\":{\"val\":true},\"imgList\":{\"isDelete\":true,\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a03\\u7ec4\\u6a21\\u5757\\uff0c\\u7b2c\\u4e00\\u5f20260*260px,\\u540e\\u4e24\\u5f20416*124px\",\"max\":3,\"list\":[{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/e81622f4c9442807a591ac4f8805eb59.jpg\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u79d2\\u6740\\u4e13\\u533a\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u4f18\\u60e0\\u591a\\u591a\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_seckill\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/5b03e2358031f4e52175db666fd54993.jpg\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u4e00\\u8d77\\u6765\\u62fc\\u56e2\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u4f18\\u60e0\\u591a\\u591a\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_combination\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/cc4e77294c3298d8b9b46868f37da126.jpg\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u780d\\u4ef7\\u6d3b\\u52a8\",\"maxlength\":20,\"tips\":\"\\u6807\\u9898\"},{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\\u547c\\u670b\\u5524\\u53cb\\u6765\\u780d\\u4ef7~~\",\"maxlength\":20,\"tips\":\"\\u63cf\\u8ff0\"},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_bargain\\/index\",\"maxlength\":999,\"tips\":\"\\u94fe\\u63a5\"}]}]},\"max\":3}},\"alive\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u76f4\\u64ad\\u95f4\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u516d\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u7cbe\\u5f69\\u76f4\\u64ad\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"numConfig\":{\"title\":\"\\u663e\\u793a\\u6570\\u91cf\",\"val\":3}},\"default\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u76f4\\u64ad\\u95f4\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u516d\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u7cbe\\u5f69\\u76f4\\u64ad\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/live_list\\/index\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"numConfig\":{\"title\":\"\\u663e\\u793a\\u6570\\u91cf\",\"val\":3}}},\"scrollBox\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u5feb\\u901f\\u9009\\u62e9\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"type\":1,\"activeValue\":\"\",\"list\":[{\"activeValue\":\"\",\"title\":\"\"},{\"activeValue\":\"\",\"title\":\"\"}]},\"numConfig\":{\"title\":\"\\u663e\\u793a\\u6570\\u91cf\",\"val\":6},\"goodsList\":{\"max\":20,\"list\":[]}},\"default\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u5feb\\u901f\\u9009\\u62e9\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u4e0a\\u767e\\u79cd\\u5546\\u54c1\\u5206\\u7c7b\\u4efb\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/goods_cate\\/goods_cate\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"type\":1,\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"title\":\"\\u663e\\u793a\\u6570\\u91cf\",\"val\":6},\"goodsList\":{\"max\":20,\"list\":[]}}},\"adsRecommend\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u56fe\\u7247\\u5efa\\u8bae\\u5c3a\\u5bf8338 * 206px\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u7248\\u5757\\u987a\\u5e8f\",\"max\":10,\"list\":[{\"img\":\"\",\"info\":[{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]}]}},\"default\":{\"isShow\":{\"val\":true},\"imgList\":{\"title\":\"\\u56fe\\u7247\\u5efa\\u8bae\\u5c3a\\u5bf8338 * 206px\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u7248\\u5757\\u987a\\u5e8f\",\"max\":10,\"list\":[{\"img\":\"\",\"info\":[{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\",\"maxlength\":999,\"tips\":\"\\u8bf7\\u586b\\u5199\\u94fe\\u63a5\"}]}]}}},\"coupon\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"numConfig\":{\"val\":10}},\"default\":{\"isShow\":{\"val\":true},\"numConfig\":{\"val\":\"8\"}}},\"seckill\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":2,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u9650\\u65f6\\u79d2\\u6740\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"default\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":2,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u9650\\u65f6\\u79d2\\u6740\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}}},\"combination\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":3,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u62fc\\u56e2\\u5217\\u8868\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"default\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":3,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u62fc\\u56e2\\u5217\\u8868\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}}},\"bargain\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":8,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u780d\\u4ef7\\u5217\\u8868\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"default\":{\"isShow\":{\"val\":true},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"titleInfo\":{\"title\":\"\",\"type\":8,\"list\":[{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"val\":\"\\u780d\\u4ef7\\u5217\\u8868\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}}},\"goodList\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u5feb\\u901f\\u9009\\u62e9\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"default\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u5feb\\u901f\\u9009\\u62e9\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"bb\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u6392\\u884c\\u699c\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"7\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"cc\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u9996\\u53d1\\u65b0\\u54c1\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u65b0\\u54c1\\u63a8\\u8350\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"5\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"dd\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u7cbe\\u9009\\u5355\\u54c1\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}},\"aa\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u4fc3\\u9500\\u7cbe\\u54c1\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\"},{\"title\":\"\\u4ecb\\u7ecd\",\"val\":\"\\u8bda\\u610f\\u63a8\\u8350\\u54c1\\u8d28\\u5546\\u54c1\",\"max\":8,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc78\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=4&amp;name=\\u4fc3\\u9500\\u5355\\u54c1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]},\"tabConfig\":{\"tabVal\":0,\"type\":1,\"tabList\":[{\"name\":\"\\u81ea\\u52a8\\u9009\\u62e9\",\"icon\":\"iconzidongxuanze\"},{\"name\":\"\\u624b\\u52a8\\u9009\\u62e9\",\"icon\":\"iconshoudongxuanze\"}]},\"selectSortConfig\":{\"title\":\"\\u5546\\u54c1\\u7c7b\\u578b\",\"activeValue\":\"6\",\"list\":[{\"activeValue\":\"0\",\"title\":\"\\u5546\\u54c1\\u5217\\u8868\"},{\"activeValue\":\"4\",\"title\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"activeValue\":\"5\",\"title\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"activeValue\":\"6\",\"title\":\"\\u4fc3\\u9500\\u5355\\u54c1\"},{\"activeValue\":\"7\",\"title\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"}]},\"selectConfig\":{\"title\":\"\\u5546\\u54c1\\u5206\\u7c7b\",\"activeValue\":\"\",\"list\":[]},\"numConfig\":{\"val\":6},\"goodsSort\":{\"title\":\"\\u5546\\u54c1\\u6392\\u5e8f\",\"name\":\"goodsSort\",\"type\":0,\"list\":[{\"val\":\"\\u7cfb\\u7edf\\u6392\\u5e8f\",\"icon\":\"iconComm_whole\"},{\"val\":\"\\u9500\\u91cf\\u6700\\u9ad8\",\"icon\":\"iconComm_number\"},{\"val\":\"\\u6700\\u65b0\\u4e0a\\u67b6\",\"icon\":\"iconzuixin\"}]},\"goodsList\":{\"max\":20,\"list\":[]}}},\"picTxt\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"richText\":{\"val\":\"\"}},\"default\":{\"isShow\":{\"val\":true},\"richText\":{\"val\":\"\"}}},\"titles\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u7cbe\\u54c1\\u63a8\\u8350\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]}},\"default\":{\"isShow\":{\"val\":true},\"titleInfo\":{\"title\":\"\",\"list\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u7cbe\\u54c1\\u63a8\\u8350\",\"max\":20,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1\",\"max\":999,\"pla\":\"\\u9009\\u586b\"}]}}},\"customerService\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a01\\u5f20\\u56fe\\u7247\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6128 * 45px\",\"url\":\"\"}},\"default\":{\"isShow\":{\"val\":true},\"imgUrl\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a01\\u5f20\\u56fe\\u7247\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea6128 * 45px\",\"url\":\"\"}}},\"tabBar\":{\"defaultVal\":{\"isShow\":{\"val\":true},\"tabBarList\":{\"title\":\"\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea681*81px\",\"list\":[{\"name\":\"\\u9996\\u9875\",\"imgList\":[],\"link\":\"\\/pages\\/index\\/index\"},{\"name\":\"\\u5206\\u7c7b\",\"imgList\":[],\"link\":\"\\/pages\\/goods_cate\\/goods_cate\"},{\"name\":\"\\u8d2d\\u7269\\u8f66\",\"imgList\":[],\"link\":\"\\/pages\\/order_addcart\\/order_addcart\"},{\"name\":\"\\u6211\\u7684\",\"imgList\":[],\"link\":\"\\/pages\\/user\\/index\"}]}},\"default\":{\"isShow\":{\"val\":true},\"tabBarList\":{\"title\":\"\\u56fe\\u7247\\u5efa\\u8bae\\u5bbd\\u5ea681*81px\",\"list\":[{\"name\":\"\\u9996\\u9875\",\"imgList\":[\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/20b0f77e089d89dd0234bd2c1c42167b.png\",\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/80b37f55136d1ddb5c00cd46a8bbeea0.png\"],\"link\":\"\\/pages\\/index\\/index\"},{\"name\":\"\\u5206\\u7c7b\",\"imgList\":[\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/ff4fb519a5f3abd5981399a3b9671555.png\",\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/8b05f6a6e72f9345c2e27e7ca2599389.png\"],\"link\":\"\\/pages\\/goods_cate\\/goods_cate\"},{\"name\":\"\\u8d2d\\u7269\\u8f66\",\"imgList\":[\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/cb71cf5eda692c3c4da155aad9fbeffc.png\",\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/60aa9dce2e8b69f0a04dd69fb113ccee.png\"],\"link\":\"\\/pages\\/order_addcart\\/order_addcart\"},{\"name\":\"\\u6211\\u7684\",\"imgList\":[\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/a7500e6af994f311364d3a9f93506669.png\",\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2022\\/11\\/20221123\\/3805070fdfcd184cc49911a545763a88.png\"],\"link\":\"\\/pages\\/user\\/index\"}]}}}}', 1631932648, 1676450162, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0, '');
INSERT INTO `eb_diy` (`id`, `version`, `name`, `template_name`, `value`, `default_value`, `add_time`, `update_time`, `status`, `type`, `is_show`, `is_bg_color`, `is_bg_pic`, `color_picker`, `bg_pic`, `bg_tab_val`, `is_del`, `order_status`, `my_banner_status`, `is_diy`, `title`) VALUES
(2, '1.0', '一键换色', 'color_change', '3', '1', 1594949966, 1642256550, 0, 1, 0, 0, 0, '', '', 0, 0, 0, 0, 0, ''),
(3, '1.0', '分类页选择', 'category', '1', '1', 1594949966, 1641892764, 0, 1, 0, 0, 0, '', '', 0, 0, 0, 0, 0, ''),
(4, '1.0', '个人中心', 'member', '2', '1', 1594949966, 1676448601, 0, 1, 0, 0, 0, '', '', 0, 0, 1, 0, 0, ''),
(5, '1.0', '模板', '', '{\"1676425779764000\":{\"name\":\"headerSerch\",\"timestamp\":\"1676425779764000\",\"setUp\":{\"tabVal\":0},\"bgColor\":{\"title\":\"\\u80cc\\u666f\\u989c\\u8272(\\u6e10\\u53d8)\",\"name\":\"bgColor\",\"default\":[{\"item\":\"#F62C2C\"},{\"item\":\"#F96E29\"}],\"color\":[{\"item\":\"#F62C2C\"},{\"item\":\"#F96E29\"}]},\"boxStyle\":{\"title\":\"\\u8fb9\\u6846\\u6837\\u5f0f\",\"name\":\"boxStyle\",\"type\":0,\"list\":[{\"val\":\"\\u5706\\u89d2\",\"icon\":\"iconPic_fillet\"},{\"val\":\"\\u76f4\\u89d2\",\"icon\":\"iconPic_square\"}]},\"txtStyle\":{\"title\":\"\\u6587\\u672c\\u4f4d\\u7f6e\",\"name\":\"txtStyle\",\"type\":0,\"list\":[{\"val\":\"\\u5c45\\u5de6\",\"icon\":\"icondoc_left\"},{\"val\":\"\\u5c45\\u4e2d\",\"icon\":\"icondoc_center\"}]},\"prConfig\":{\"title\":\"\\u80cc\\u666f\\u8fb9\\u8ddd\",\"val\":10,\"min\":0},\"mbConfig\":{\"title\":\"\\u9875\\u9762\\u95f4\\u8ddd\",\"val\":0,\"min\":0},\"hotWords\":{\"list\":[{\"val\":\"CRMEB\\u7535\\u5546\\u7cfb\\u7edf\"},{\"val\":\"\\u9ad8\\u54c1\\u8d28\\u9ad8\\u6027\\u80fd\"},{\"val\":\"\\u6811\\u7acb\\u884c\\u4e1a\\u6807\\u6746\"}]},\"logoConfig\":{\"type\":1,\"header\":\"\\u8bbe\\u7f6elogo\",\"title\":\"\",\"url\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230210\\/955c6bb44d8e002164bcbc2e7b3b6ea5.png\"},\"id\":\"id1676425779764000\"},\"1676425779764001\":{\"name\":\"swiperBg\",\"timestamp\":\"1676425779764001\",\"setUp\":{\"tabVal\":0},\"swiperConfig\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u5f20\\u56fe\\u7247\\uff0c\\u5efa\\u8bae\\u5bbd\\u5ea6750px\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u56fe\\u7247 \\u987a\\u5e8f\",\"maxList\":10,\"list\":[{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230213\\/62c718b8f546c0e601fbc00b63e63be2.jpeg\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u4eca\\u65e5\\u63a8\\u8350\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/744211aa7990da47780ac48f4a85e705.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]}]},\"isShow\":{\"title\":\"\\u662f\\u5426\\u663e\\u793a\\u80cc\\u666f\\u8272\",\"val\":true},\"bgColor\":{\"title\":\"\\u80cc\\u666f\\u989c\\u8272(\\u6e10\\u53d8)\",\"default\":[{\"item\":\"#F62C2C\"},{\"item\":\"#F96E29\"}],\"color\":[{\"item\":\"#F62C2C\"},{\"item\":\"#F96E29\"}]},\"dotColor\":{\"title\":\"\\u6307\\u793a\\u5668\\u989c\\u8272\",\"default\":[{\"item\":\"#fff\"}],\"color\":[{\"item\":\"#fff\"}]},\"lrConfig\":{\"title\":\"\\u5de6\\u53f3\\u8fb9\\u8ddd\",\"val\":10,\"min\":0},\"mbConfig\":{\"title\":\"\\u9875\\u9762\\u95f4\\u8ddd\",\"val\":0,\"min\":0},\"docConfig\":{\"cname\":\"swiper\",\"title\":\"\\u6307\\u793a\\u5668\\u6837\\u5f0f\",\"type\":0,\"list\":[{\"val\":\"\\u5706\\u5f62\",\"icon\":\"iconDot\"},{\"val\":\"\\u76f4\\u7ebf\",\"icon\":\"iconSquarepoint\"},{\"val\":\"\\u6570\\u5b57\",\"icon\":\"iconshuzi\"},{\"val\":\"\\u65e0\\u6307\\u793a\\u5668\",\"icon\":\"iconjinyong\"}]},\"txtStyle\":{\"title\":\"\\u6307\\u793a\\u5668\\u4f4d\\u7f6e\",\"type\":0,\"list\":[{\"val\":\"\\u5c45\\u5de6\",\"icon\":\"icondoc_left\"},{\"val\":\"\\u5c45\\u4e2d\",\"icon\":\"icondoc_center\"},{\"val\":\"\\u5c45\\u53f3\",\"icon\":\"icondoc_right\"}]},\"imgConfig\":{\"cname\":\"docStyle\",\"title\":\"\\u8f6e\\u64ad\\u56fe\\u6837\\u5f0f\",\"type\":0,\"list\":[{\"val\":\"\\u5706\\u89d2\",\"icon\":\"iconPic_fillet\"},{\"val\":\"\\u76f4\\u89d2\",\"icon\":\"iconPic_square\"}]},\"id\":\"id1676425779764001\"},\"1676425779764002\":{\"name\":\"news\",\"timestamp\":\"1676425779764002\",\"setUp\":{\"tabVal\":0},\"txtStyle\":{\"title\":\"\\u6587\\u672c\\u4f4d\\u7f6e\",\"name\":\"txtStyle\",\"type\":0,\"list\":[{\"val\":\"\\u5c45\\u5de6\",\"icon\":\"icondoc_left\",\"style\":\"left\"},{\"val\":\"\\u5c45\\u4e2d\",\"icon\":\"icondoc_center\",\"style\":\"center\"},{\"val\":\"\\u5c45\\u53f3\",\"icon\":\"icondoc_right\",\"style\":\"right\"}]},\"bgColor\":{\"title\":\"\\u80cc\\u666f\\u989c\\u8272\",\"default\":[{\"item\":\"#fff\"}],\"color\":[{\"item\":\"#fff\"}]},\"txtColor\":{\"title\":\"\\u6587\\u5b57\\u989c\\u8272\",\"default\":[{\"item\":\"#333\"}],\"color\":[{\"item\":\"#333\"}]},\"listConfig\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a010\\u4e2a\\u7248\\u5757\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u7248\\u5757\\u987a\\u5e8f\",\"max\":10,\"list\":[{\"chiild\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"CRMEB\\u9ad8\\u54c1\\u8d28\\u7535\\u5546\\u7cfb\\u7edf\",\"max\":30,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc730\\u4e2a\\u5b57\",\"empty\":true},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/extension\\/news_details\\/index?id=1\",\"max\":200,\"pla\":\"\\u8bf7\\u8f93\\u5165\\u8fde\\u63a5\"}]},{\"chiild\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"CRMEB\\u9ad8\\u54c1\\u8d28\\u7535\\u5546\\u7cfb\\u7edf\",\"max\":30,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc730\\u4e2a\\u5b57\",\"empty\":true},{\"title\":\"\\u94fe\\u63a5\",\"val\":\"\\/pages\\/extension\\/news_details\\/index?id=1\",\"max\":200,\"pla\":\"\\u8bf7\\u8f93\\u5165\\u8fde\\u63a5\"}]}],\"tabCur\":1},\"bgStyle\":{\"title\":\"\\u80cc\\u666f\\u6837\\u5f0f\",\"name\":\"bgStyle\",\"type\":1,\"list\":[{\"val\":\"\\u76f4\\u89d2\",\"icon\":\"iconPic_square\"},{\"val\":\"\\u5706\\u89d2\",\"icon\":\"iconPic_fillet\"}]},\"prConfig\":{\"title\":\"\\u80cc\\u666f\\u8fb9\\u8ddd\",\"val\":10,\"min\":0},\"mbConfig\":{\"title\":\"\\u9875\\u9762\\u95f4\\u8ddd\",\"val\":10,\"min\":0},\"logoConfig\":{\"header\":\"\\u56fe\\u6807\\u8bbe\\u7f6e\",\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a01\\u5f20\\u56fe\\u7247\\uff0c\\u5efa\\u8bae\\u5bbd\\u5ea6130 * 36px\",\"url\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/1109cd6ddff02f61a4dfcac584e53952.png\"},\"id\":\"id1676425779764002\"},\"1676425779764003\":{\"name\":\"menus\",\"timestamp\":\"1676425779764003\",\"setUp\":{\"tabVal\":0},\"tabConfig\":{\"title\":\"\\u5c55\\u793a\\u6837\\u5f0f\",\"tabVal\":1,\"type\":1,\"tabList\":[{\"name\":\"\\u5355\\u884c\\u5c55\\u793a\",\"icon\":\"icondanhang\"},{\"name\":\"\\u591a\\u884c\\u5c55\\u793a\",\"icon\":\"iconduohang\"}]},\"rowsNum\":{\"title\":\"\\u663e\\u793a\\u884c\\u6570\",\"name\":\"rowsNum\",\"type\":0,\"list\":[{\"val\":\"2\\u884c\",\"icon\":\"icon2hang\"},{\"val\":\"3\\u884c\",\"icon\":\"icon3hang\"},{\"val\":\"4\\u884c\",\"icon\":\"icon4hang\"}]},\"menuStyle\":{\"title\":\"\\u56fe\\u6807\\u6837\\u5f0f\",\"name\":\"menuStyle\",\"type\":0,\"list\":[{\"val\":\"\\u65b9\\u5f62\",\"icon\":\"iconPic_square\"},{\"val\":\"\\u5706\\u5f62\",\"icon\":\"icondayuanjiao\"}]},\"number\":{\"title\":\"\\u663e\\u793a\\u4e2a\\u6570\",\"name\":\"number\",\"type\":1,\"list\":[{\"val\":\"3\\u4e2a\",\"icon\":\"icon3ge\"},{\"val\":\"4\\u4e2a\",\"icon\":\"icon4ge1\"},{\"val\":\"5\\u4e2a\",\"icon\":\"icon5ge1\"}]},\"pointerStyle\":{\"title\":\"\\u6307\\u793a\\u5668\\u6837\\u5f0f\",\"name\":\"pointerStyle\",\"type\":2,\"list\":[{\"val\":\"\\u957f\\u6761\",\"icon\":\"iconSquarepoint\"},{\"val\":\"\\u5706\\u5f62\",\"icon\":\"iconDot\"},{\"val\":\"\\u65e0\\u6307\\u793a\\u5668\",\"icon\":\"iconjinyong\"}]},\"bgStyle\":{\"title\":\"\\u80cc\\u666f\\u6837\\u5f0f\",\"name\":\"bgStyle\",\"type\":1,\"list\":[{\"val\":\"\\u76f4\\u89d2\",\"icon\":\"iconPic_square\"},{\"val\":\"\\u5706\\u89d2\",\"icon\":\"iconPic_fillet\"}]},\"prConfig\":{\"title\":\"\\u80cc\\u666f\\u8fb9\\u8ddd\",\"val\":10,\"min\":0},\"menuConfig\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a01\\u5f20\\u56fe\\u7247\\uff0c\\u5efa\\u8bae\\u5bbd\\u5ea690 * 90px\",\"maxList\":100,\"list\":[{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/b8c16ea2a3256c50c52d643d4316690d.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u7cbe\\u54c1\\u63a8\\u8350\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/columnGoods\\/HotNewGoods\\/index?type=1&name=\\u7cbe\\u54c1\\u63a8\\u8350\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/58fa876b83dd76b00208f0b441682a48.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u65b0\\u95fb\\u4e13\\u9898\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/extension\\/news_list\\/index\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/2657f505e0229de1531a8ebb9cbf80bb.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u5206\\u9500\\u4e2d\\u5fc3\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/users\\/user_spread_user\\/index\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/571e43d36aff92d990a6558aef9f8b4f.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u9886\\u4f18\\u60e0\\u5238\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/users\\/user_get_coupon\\/index\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/cf754595c9fe1a63460e0ddee6177467.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"SVIP\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/annex\\/vip_paid\\/index\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/cbc0349c13a3cc62416222beda4f7d98.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u79ef\\u5206\\u5546\\u57ce\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/points_mall\\/index\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/93d236af3e3b6fa3dd1b4eb68be0bf43.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u6211\\u7684\\u7b49\\u7ea7\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/users\\/user_vip\\/index\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230215\\/09ef9d23b0b559714672d1438608422c.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u6bcf\\u65e5\\u7b7e\\u5230\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/users\\/user_sgin\\/index\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]}]},\"pointerColor\":{\"title\":\"\\u6307\\u793a\\u5668\\u989c\\u8272\",\"name\":\"pointerColor\",\"default\":[{\"item\":\"#f44\"}],\"color\":[{\"item\":\"#f44\"}]},\"bgColor\":{\"title\":\"\\u80cc\\u666f\\u989c\\u8272\",\"name\":\"bgColor\",\"default\":[{\"item\":\"#fff\"}],\"color\":[{\"item\":\"#fff\"}]},\"titleColor\":{\"title\":\"\\u6587\\u5b57\\u989c\\u8272\",\"name\":\"themeColor\",\"default\":[{\"item\":\"#333333\"}],\"color\":[{\"item\":\"#333333\"}]},\"mbConfig\":{\"title\":\"\\u9875\\u9762\\u95f4\\u8ddd\",\"val\":10,\"min\":0},\"id\":\"id1676425779764003\"},\"1676425779764004\":{\"name\":\"activeParty\",\"timestamp\":\"1676425779764004\",\"setUp\":{\"tabVal\":0},\"titleConfig\":{\"title\":\"\\u4fc3\\u9500\\u6807\\u9898\",\"value\":\"\\u7cbe\\u54c1\\u7206\\u6b3e\",\"place\":\"\\u8bf7\\u8f93\\u5165\\u6807\\u9898\",\"max\":10},\"desConfig\":{\"title\":\"\\u4fc3\\u9500\\u7b80\\u4ecb\",\"value\":\"\\u7f8e\\u597d\\u751f\\u6d3b\\u7531\\u6b64\\u5f00\\u59cb\",\"place\":\"\\u8bf7\\u8f93\\u5165\\u7b80\\u4ecb\",\"max\":8},\"menuConfig\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a04\\u4e2a\\u7248\\u5757\\uff0c\\u56fe\\u7247\\u5efa\\u8bae\\u5c3a\\u5bf8140 * 140px\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef \\u8c03\\u6574\\u7248\\u5757\\u987a\\u5e8f\",\"maxList\":4,\"list\":[{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230213\\/a7cfed80049c0d051988da434d5553b6.jpg\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u597d\\u53cb\\u62fc\\u56e2\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u7b80\\u4ecb\",\"value\":\"\\u5e97\\u4e3b\\u8bda\\u610f\\u63a8\\u8350 \\u54c1\\u8d28\\u5546\\u54c1\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc720\\u4e2a\\u5b57\",\"max\":20},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_combination\\/index\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230213\\/afebd475d8c9c75ec8661504abf1c3b8.jpg\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u9650\\u65f6\\u79d2\\u6740\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u7b80\\u4ecb\",\"value\":\"\\u5e97\\u4e3b\\u8bda\\u610f\\u63a8\\u8350 \\u54c1\\u8d28\\u5546\\u54c1\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc720\\u4e2a\\u5b57\",\"max\":20},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_seckill\\/index\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230213\\/cf5414089d598d064b0a4d7154a4f491.png\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u597d\\u53cb\\u780d\\u4ef7\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u7b80\\u4ecb\",\"value\":\"\\u65b0\\u54c1\\u4e0a\\u67b6\\u7b49 \\u4f60\\u6765\\u62ff\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc720\\u4e2a\\u5b57\",\"max\":20},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/goods_bargain\\/index\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]},{\"img\":\"http:\\/\\/demo.crmeb.com\\/uploads\\/attach\\/2023\\/02\\/20230213\\/5aea4687e62d39793ba63161eacf6661.jpg\",\"info\":[{\"title\":\"\\u6807\\u9898\",\"value\":\"\\u9884\\u552e\\u5546\\u54c1\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc74\\u4e2a\\u5b57\",\"max\":4},{\"title\":\"\\u7b80\\u4ecb\",\"value\":\"\\u7efc\\u5408\\u8bc4\\u9009\\u597d \\u4ea7\\u54c1\",\"tips\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc720\\u4e2a\\u5b57\",\"max\":20},{\"title\":\"\\u94fe\\u63a5\",\"value\":\"\\/pages\\/activity\\/presell\\/index\",\"tips\":\"\\u8bf7\\u8f93\\u5165\\u94fe\\u63a5\",\"max\":100}]}]},\"themeColor\":{\"title\":\"\\u4e3b\\u9898\\u989c\\u8272\",\"name\":\"themeColor\",\"default\":[{\"item\":\"#fc3c3e\"}],\"color\":[{\"item\":\"#fc3c3e\"}]},\"bgColor\":{\"title\":\"\\u6807\\u7b7e\\u80cc\\u666f\\u989c\\u8272\",\"name\":\"bgColor\",\"default\":[{\"item\":\"#F62C2C\"},{\"item\":\"#F96E29\"}],\"color\":[{\"item\":\"#F62C2C\"},{\"item\":\"#F96E29\"}]},\"boxColor\":{\"title\":\"\\u80cc\\u666f\\u989c\\u8272\",\"name\":\"boxColor\",\"default\":[{\"item\":\"#ffe5e3\"}],\"color\":[{\"item\":\"#ffe5e3\"}]},\"mbConfig\":{\"title\":\"\\u9875\\u9762\\u95f4\\u8ddd\",\"val\":10,\"min\":0},\"id\":\"id1676425779764004\"},\"1676425779764006\":{\"name\":\"promotionList\",\"timestamp\":\"1676425779764006\",\"setUp\":{\"tabVal\":1},\"productList\":{\"title\":\"\\u4fc3\\u9500\\u5217\\u8868\"},\"titleConfig\":{\"title\":\"\\u6807\\u9898\\u4f4d\\u7f6e\",\"type\":0,\"list\":[{\"val\":\"\\u5c45\\u5de6\",\"icon\":\"icondoc_left\"},{\"val\":\"\\u5c45\\u4e2d\",\"icon\":\"icondoc_center\"},{\"val\":\"\\u5c45\\u53f3\",\"icon\":\"icondoc_right\"}]},\"titleShow\":{\"title\":\"\\u662f\\u5426\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"val\":true},\"opriceShow\":{\"title\":\"\\u662f\\u5426\\u663e\\u793a\\u5546\\u54c1\\u539f\\u4ef7\",\"val\":true},\"priceShow\":{\"title\":\"\\u662f\\u5426\\u663e\\u793a\\u5546\\u54c1\\u4ef7\\u683c\",\"val\":true},\"couponShow\":{\"title\":\"\\u662f\\u5426\\u663e\\u793a\\u4f18\\u60e0\\u5238\",\"val\":true},\"tabConfig\":{\"title\":\"\\u6700\\u591a\\u53ef\\u6dfb\\u52a04\\u4e2a\\u7248\\u5757\\uff1b\\u9f20\\u6807\\u62d6\\u62fd\\u5de6\\u4fa7\\u5706\\u70b9\\u53ef\\u8c03\\u6574\\u7248\\u5757\\u987a\\u5e8f\",\"max\":4,\"tabCur\":3,\"list\":[{\"chiild\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u9996\\u53d1\\u65b0\\u54c1\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u7b80\\u4ecb\",\"val\":\"\\u6700\\u65b0\\u51fa\\u7089\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}],\"link\":{\"title\":\"\\u94fe\\u63a5\",\"activeVal\":1,\"optiops\":[{\"type\":0,\"value\":1,\"label\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"},{\"type\":1,\"value\":2,\"label\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"type\":2,\"value\":3,\"label\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"type\":3,\"value\":4,\"label\":\"\\u4fc3\\u9500\\u5355\\u54c1\"}]}},{\"chiild\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u70ed\\u95e8\\u63a8\\u8350\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u7b80\\u4ecb\",\"val\":\"\\u6700\\u65b0\\u51fa\\u7089\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}],\"link\":{\"title\":\"\\u94fe\\u63a5\",\"activeVal\":1,\"optiops\":[{\"type\":0,\"value\":1,\"label\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"},{\"type\":1,\"value\":2,\"label\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"type\":2,\"value\":3,\"label\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"type\":3,\"value\":4,\"label\":\"\\u4fc3\\u9500\\u5355\\u54c1\"}]}},{\"chiild\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u964d\\u4ef7\\u6392\\u884c\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u7b80\\u4ecb\",\"val\":\"\\u6700\\u65b0\\u51fa\\u7089\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}],\"link\":{\"title\":\"\\u94fe\\u63a5\",\"activeVal\":1,\"optiops\":[{\"type\":0,\"value\":1,\"label\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"},{\"type\":1,\"value\":2,\"label\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"type\":2,\"value\":3,\"label\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"type\":3,\"value\":4,\"label\":\"\\u4fc3\\u9500\\u5355\\u54c1\"}]}},{\"chiild\":[{\"title\":\"\\u6807\\u9898\",\"val\":\"\\u9650\\u65f6\\u6298\\u6263\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"},{\"title\":\"\\u7b80\\u4ecb\",\"val\":\"\\u6700\\u65b0\\u51fa\\u7089\",\"max\":4,\"pla\":\"\\u9009\\u586b\\uff0c\\u4e0d\\u8d85\\u8fc7\\u56db\\u4e2a\\u5b57\"}],\"link\":{\"title\":\"\\u94fe\\u63a5\",\"activeVal\":1,\"optiops\":[{\"type\":0,\"value\":1,\"label\":\"\\u7cbe\\u54c1\\u63a8\\u8350\"},{\"type\":1,\"value\":2,\"label\":\"\\u70ed\\u95e8\\u699c\\u5355\"},{\"type\":2,\"value\":3,\"label\":\"\\u9996\\u53d1\\u65b0\\u54c1\"},{\"type\":3,\"value\":4,\"label\":\"\\u4fc3\\u9500\\u5355\\u54c1\"}]}}]},\"themeColor\":{\"title\":\"\\u4e3b\\u9898\\u98ce\\u683c\",\"name\":\"themeColor\",\"default\":[{\"item\":\"#F95429\"}],\"color\":[{\"item\":\"#F95429\"}]},\"fontColor\":{\"title\":\"\\u4ef7\\u683c\\u989c\\u8272\",\"name\":\"fontColor\",\"default\":[{\"item\":\"#e93323\"}],\"color\":[{\"item\":\"#e93323\"}]},\"labelColor\":{\"title\":\"\\u6d3b\\u52a8\\u6807\\u7b7e\",\"name\":\"labelColor\",\"default\":[{\"item\":\"#e93323\"}],\"color\":[{\"item\":\"#e93323\"}]},\"mbConfig\":{\"title\":\"\\u9875\\u9762\\u95f4\\u8ddd\",\"val\":0,\"min\":0},\"numConfig\":{\"val\":6},\"id\":\"id1676425779764006\"},\"1676451080583000\":{\"name\":\"pageFoot\",\"setUp\":{\"tabVal\":0},\"status\":{\"title\":\"\\u4e13\\u9898\\u9875\\u662f\\u5426\\u663e\\u793a\",\"name\":\"status\",\"status\":false},\"txtColor\":{\"title\":\"\\u6587\\u5b57\\u989c\\u8272\",\"name\":\"txtColor\",\"default\":[{\"item\":\"#282828\"}],\"color\":[{\"item\":\"#282828\"}]},\"activeTxtColor\":{\"title\":\"\\u9009\\u4e2d\\u6587\\u5b57\\u989c\\u8272\",\"name\":\"txtColor\",\"default\":[{\"item\":\"#F62C2C\"}],\"color\":[{\"item\":\"#F62C2C\"}]},\"bgColor\":{\"title\":\"\\u80cc\\u666f\\u989c\\u8272\",\"name\":\"bgColor\",\"default\":[{\"item\":\"#fff\"}],\"color\":[{\"item\":\"#fff\"}]},\"menuList\":[{\"imgList\":[\"data:image\\/png;base64,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\",\"data:image\\/png;base64,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\"],\"name\":\"\\u9996\\u9875\",\"link\":\"\\/pages\\/index\\/index\"},{\"imgList\":[\"data:image\\/png;base64,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\",\"data:image\\/png;base64,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\"],\"name\":\"\\u5206\\u7c7b\",\"link\":\"\\/pages\\/goods_cate\\/goods_cate\"},{\"imgList\":[\"data:image\\/png;base64,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\",\"data:image\\/png;base64,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\"],\"name\":\"\\u8d2d\\u7269\\u8f66\",\"link\":\"\\/pages\\/order_addcart\\/order_addcart\"},{\"imgList\":[\"data:image\\/png;base64,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\",\"data:image\\/png;base64,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\"],\"name\":\"\\u6211\\u7684\",\"link\":\"\\/pages\\/user\\/index\"}],\"id\":\"idundefined\"}}', NULL, 1676424871, 1676451105, 1, 2, 1, 0, 0, '#f5f5f5', '', 0, 0, 0, 1, 1, '首页');

-- --------------------------------------------------------

--
-- 表的结构 `eb_express`
--

CREATE TABLE IF NOT EXISTS `eb_express` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '快递公司id',
  `code` varchar(50) NOT NULL DEFAULT '' COMMENT '快递公司简称',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '快递公司全称',
  `partner_id` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要月结账号',
  `partner_key` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要月结密码',
  `net` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要取件网店',
  `check_man` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否填写电子面单承载快递员名',
  `partner_name` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否填写电子面单客户账户名称',
  `is_code` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否填写电子面单承载编号',
  `courier_name` varchar(100) NOT NULL DEFAULT '' COMMENT '承载快递员名',
  `customer_name` varchar(100) NOT NULL DEFAULT '' COMMENT '客户账户名称',
  `code_name` varchar(100) NOT NULL DEFAULT '' COMMENT '电子面单承载编号',
  `account` varchar(100) NOT NULL DEFAULT '' COMMENT '账号',
  `key` varchar(100) NOT NULL DEFAULT '' COMMENT '密码',
  `net_name` varchar(100) NOT NULL DEFAULT '' COMMENT '网点名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否可用',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `is_show` (`is_show`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1102 DEFAULT CHARSET=utf8 COMMENT='快递公司表';

--
-- 转存表中的数据 `eb_express`
--

INSERT INTO `eb_express` (`id`, `code`, `name`, `partner_id`, `partner_key`, `net`, `check_man`, `partner_name`, `is_code`, `courier_name`, `customer_name`, `code_name`, `account`, `key`, `net_name`, `sort`, `is_show`, `status`) VALUES
(1, 'yunda', '韵达快递', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(2, 'shunfeng', '顺丰速运', 1, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(3, 'yuantong', '圆通速递', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(4, 'zhongtong', '中通快递', 1, 1, 1, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(5, 'shentong', '申通快递', 1, 1, 1, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(6, 'huitongkuaidi', '百世快递', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(7, 'jd', '京东物流', 1, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(8, 'jtexpress', '极兔速递', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(9, 'youzhengguonei', '邮政快递包裹', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(10, 'tiantian', '天天快递', 1, 1, 1, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(11, 'ems', 'EMS', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(12, 'debangwuliu', '德邦物流', 1, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(13, 'debangkuaidi', '德邦快递', 1, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(14, 'zhongyouex', '众邮快递', 1, 0, 1, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(15, 'youshuwuliu', '优速快递', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(16, 'zhongtongkuaiyun', '中通快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(17, 'zhaijisong', '宅急送', 1, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 1, 1),
(18, 'suning', '苏宁物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(19, 'baishiwuliu', '百世快运', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(20, 'zhimakaimen', '芝麻开门', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(21, 'ups', 'UPS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(22, 'yundakuaiyun', '韵达快运', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(23, 'dhlen', 'DHL-全球件', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(24, 'fedex', 'FedEx-国际件', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(25, 'annengwuliu', '安能快运', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(26, 'lianhaowuliu', '联昊通', 1, 1, 0, 1, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(27, 'ewe', 'EWE全球快递', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(28, 'zhongtongguoji', '中通国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(29, 'dhl', 'DHL-中国件', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(30, 'emsguoji', 'EMS-国际件', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(31, 'ubonex', '优邦速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(32, 'kuayue', '跨越速运', 1, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(33, 'yuantongkuaiyun', '圆通快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(34, 'upsen', 'UPS-全球件', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(35, 'rlgaus', '澳洲飞跃物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(36, 'zhongyouwuliu', '中邮物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(37, 'annto', '安得物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(38, 'danniao', '丹鸟', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(39, 'usps', 'USPS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(40, 'suer', '速尔快递', 1, 0, 1, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(41, 'auspost', '澳大利亚(Australia Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(42, 'arkexpress', '方舟速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(43, 'chinaicip', '卓志速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(44, 'zhonghuan', '中环快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(45, 'hkems', '云邮跨境快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(46, 'yimidida', '壹米滴答', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(47, 'shpost', '同城快寄', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(48, 'kuaijiesudi', '快捷速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(49, 'disifang', '递四方', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(50, 'lntjs', '特急送', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(51, 'meiquick', '美快国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(52, 'rrs', '日日顺物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(53, 'auexpress', '澳邮中国快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(54, 'sxjdfreight', '顺心捷达', 1, 1, 1, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(55, 'idamalu', '大马鹿', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(56, 'yuantongguoji', '圆通国际', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(57, 'xinfengwuliu', '信丰物流', 1, 1, 1, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(58, 'sendtochina', '速递中国', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(59, 'auod', '澳德物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(60, 'bpost', '比利时（Bpost）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(61, 'japanposten', '日本（Japan Post）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(62, 'ztky', '中铁快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(63, 'btexpress', '邦泰快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(64, 'tiandihuayu', '天地华宇', 1, 0, 0, 0, 0, 1, '', '', '', '', '', '', 0, 0, 1),
(65, 'lianbangkuaidi', '联邦快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(66, 'dhlde', 'DHL-德国件（DHL Deutschland）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(67, 'banma', '斑马物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(68, 'yangbaoguo', '洋包裹', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(69, 'superb', 'Superb Grace', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(70, 'aramex', 'Aramex', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(71, 'newzealand', '新西兰（New Zealand Post）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(72, 'longbanwuliu', '龙邦速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(73, 'zhuanyunsifang', '转运四方', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(74, 'austa', 'Austa国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(75, 'flyway', '程光快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(76, 'subida', '速必达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(77, 'dpd', 'DPD', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(78, 'fedexcn', 'Fedex-国际件-中文', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(79, 'jinguangsudikuaijian', '京广速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(80, 'weitepai', '微特派', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(81, 'yuxinwuliu', '宇鑫物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(82, 'xlobo', 'Xlobo贝海国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(83, 'sdto', '速达通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(84, 'huisenky', '汇森速运', 1, 1, 0, 1, 1, 0, '', '', '', '', '', '', 0, 0, 1),
(85, 'guotongkuaidi', '国通快递', 1, 1, 1, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(86, 'bsht', '百事亨通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(87, 'jiuyescm', '九曳供应链', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(88, 'tntau', 'TNT Australia', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(89, 'uszcn', '转运中国', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(90, 'tnt', 'TNT', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(91, 'changjiang', '长江国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(92, 'sunjex', '新杰物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(93, 'zhongtiewuliu', '中铁物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(94, 'adapost', '安达速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(95, 'wanjiawuliu', '万家物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(96, 'dpex', 'DPEX', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(97, 'emsbg', 'EMS包裹', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(98, 'aae', 'AAE-中国件', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(99, 'shenghuiwuliu', '盛辉物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(100, 'stosolution', '申通国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(101, 'zhengyikuaidi', '鑫正一快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(102, 'savor', '海信物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(103, 'nsf', '新顺丰（NSF）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(104, 'qexpress', '易达通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(105, 'sanhuwuliu', '叁虎物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(106, 'polarexpress', '极地快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(107, 'rufengda', '如风达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(108, 'wanxiangwuliu', '万象物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(109, 'zhongtongphone', '中通（带电话）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(110, 'epanex', '泛捷国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(111, 'ueq', 'UEQ快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(112, 'lbex', '龙邦物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(113, 'jinan', '金岸物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(114, 'sxexpress', '三象速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(115, 'jiayunmeiwuliu', '加运美', 1, 0, 1, 1, 1, 0, '', '', '', '', '', '', 0, 0, 1),
(116, 'wlwex', '星空国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(117, 'hac56', '瀚朝物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(118, 'la911', '鼎润物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(119, 'ftd', '富腾达国际货运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(120, 'mosuda', '魔速达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(121, 'emsinten', 'EMS-国际件-英文', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(122, 'suteng', '广东速腾物流', 1, 1, 1, 1, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(123, 'feiyuanvipshop', '飞远配送', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(124, 'yuntrack', 'YUN TRACK', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(125, 'pingandatengfei', '平安达腾飞', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(126, 'guexp', '全联速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(127, 'hengluwuliu', '恒路物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(128, 'wjkwl', '万家康物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(129, 'xdexpress', '迅达速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(130, 'yw56', '燕文物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(131, 'bflg', '上海缤纷物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(132, 'nebuex', '星云速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(133, 'unitedex', '联合速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(134, 'baifudongfang', '百福东方', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(135, 'jiajiwuliu', '佳吉快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(136, 'beebird', '锋鸟物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(137, 'chszhonghuanguoji', 'CHS中环国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(138, 'tzky', '铁中快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(139, 'httx56', '汇通天下物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(140, 'wotu', '渥途国际速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(141, 'dsukuaidi', 'D速快递', 1, 1, 1, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(142, 'jumstc', '聚盟共建', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(143, 'aotsd', '澳天速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(144, 'coe', 'COE', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(145, 'crazyexpress', '疯狂快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(146, 'dpexen', 'Toll', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(147, 'sut56', '速通物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(148, 'zengyisudi', '增益速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(149, 'ucs', '合众速递(UCS）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(150, 'valueway', '美通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(151, 'jssdt56', '时达通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(152, 'yuanfeihangwuliu', '原飞航', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(153, 'haidaibao', '海带宝', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(154, 'ubuy', '德国优拜物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(155, 'zhongsukuaidi', '中速快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(156, 'ane66', '安能快递', 1, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(157, 'anxl', '安迅物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(158, 'fujisuyun', '富吉速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(159, 'onehcang', '一号仓', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(160, 'tstexp', 'TST速运通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(161, 'chukou1', '出口易', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(162, 'jiajikuaidi', '佳吉快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(163, 'ndwl', '南方传媒物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(164, 'chnexp', '中翼国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(165, 'hkpost', '中国香港(HongKong Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(166, 'huangmajia', '黄马甲', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(167, 'hnht56', '鸿泰物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(168, 'shangda', '上大物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(169, 'ytkd', '运通中港快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(170, 'canpar', 'Canpar', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(171, 'dekuncn', '德坤物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(172, 'quansutong', '全速通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(173, 'cccc58', '中集冷云', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(174, 'cnpex', 'CNPEX中邮快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(175, 'dfwl', '达发物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(176, 'euasia', '欧亚专线', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(177, 'quanfengkuaidi', '全峰快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(178, 'sagawa', '佐川急便', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(179, 'doortodoor', 'CJ物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(180, 'fedexus', 'FedEx-美国件', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(181, 'etong', 'E通速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(182, 'fastgoexpress', '速派快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(183, 'yujtong', '宇捷通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(184, 'chuangyi', '创一快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(185, 'ocs', 'OCS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(186, 'phlpost', '菲律宾（Philippine Postal）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(187, 'shlindao', '林道国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(188, 'tnten', 'TNT-全球件', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(189, 'ganzhongnengda', '能达速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(190, 'yidatong', '易达通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(191, 'bht', 'BHT', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(192, 'cnausu', '中澳速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(193, 'oneexpress', '一速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(194, 'datianwuliu', '大田物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(195, 'emsen', 'EMS-英文', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(196, 'quanyikuaidi', '全一快递', 1, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(197, 'deutschepost', '德国(Deutsche Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(198, 'pjbest', '品骏快递', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(199, 'shangqiao56', '商桥物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(200, 'tianma', '天马迅达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(201, 'yousutongda', '优速通达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(202, 'yuananda', '源安达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(203, 'astexpress', '安世通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(204, 'exfresh', '安鲜达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(205, 'huanqiu', '环球速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(206, 'jialidatong', '嘉里大通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(207, 'nanjingshengbang', '晟邦物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(208, 'pfcexpress', '皇家物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(209, 'postnlcn', '荷兰邮政-中文(PostNL international reg', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(210, 'qinyuan', '秦远物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(211, 'runhengfeng', '全时速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(212, 'correosdees', '西班牙(Correos de Espa?a)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(213, 'dayangwuliu', '大洋物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(214, 'heimao56', '黑猫速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(215, 'huaxiahuoyun', '华夏货运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(216, 'longfx', 'LUCFLOW EXPRESS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(217, 'myhermes', 'MyHermes', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(218, 'parcelforce', '英国大包、EMS（Parcel Force）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(219, 'zjstky', '苏通快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(220, 'zlink', '三真驿道', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(221, 'canpost', '加拿大(Canada Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(222, 'hd', '宏递快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(223, 'hrex', '锦程快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(224, 'sfwl', '盛丰物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(225, 'taoplus', '淘布斯国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(226, 'yuanchengwuliu', '远成物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(227, 'eshunda', '俄顺达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(228, 'est365', '东方汇', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(229, 'farlogistis', '泛远国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(230, 'gsm', 'GSM', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(231, 'italiane', '意大利(Poste Italiane)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(232, 'lijisong', '成都立即送', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(233, 'morelink56', 'MoreLink', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(234, 'tnjex', '明通国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(235, 'topspeedex', '中运全速', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(236, 'transrush', 'TransRush', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(237, 'yunfeng56', '韵丰物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(238, 'zhongchuan', '众川国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(239, 'csuivi', '法国(La Poste)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(240, 'efs', 'EFS Post（平安快递）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(241, 'express7th', '7号速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(242, 'lfexpress', '龙枫国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(243, 'wherexpess', '威盛快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(244, 'yizhengdasuyun', '一正达速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(245, 'youyou', '优优速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(246, 'ztong', '智通物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(247, 'ajlogistics', '澳捷物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(248, 'chinapostcb', '中邮电商', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(249, 'colissimo', '法国小包（colissimo）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(250, 'gslexpress', '德尚国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(251, 'hlyex', '好来运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(252, 'jgwl', '景光物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(253, 'jiujiuwl', '久久物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(254, 'lineone', '一号线', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(255, 'minghangkuaidi', '民航快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(256, 'postnlchina', '荷兰邮政-中国件', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(257, 'quansu', '全速物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(258, 'synship', 'SYNSHIP快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(259, 'tywl99', '天翼物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(260, 'wondersyd', '中邮速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(261, 'yafengsudi', '亚风速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(262, 'youban', '邮邦国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(263, 'ytchengnuoda', '承诺达', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(264, 'anxindakuaixi', '安信达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(265, 'bjemstckj', '北京EMS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(266, 'chengtong', '城通物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(267, 'com1express', '商壹国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(268, 'ecmscn', '易客满', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(269, 'eupackage', '易优包裹', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(270, 'ftky365', '丰通快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(271, 'gslhkd', '联合快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(272, 'gts', 'GTS快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(273, 'jiayiwuliu', '佳怡物流', 1, 1, 1, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(274, 'jieborne', '捷邦物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(275, 'jxfex', '集先锋快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(276, 'luben', '陆本速递 LUBEN EXPRESS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(277, 'meiguokuaidi', '美国快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(278, 'tcat', '黑猫宅急便', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(279, 'trakpak', 'TRAKPAK', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(280, 'tykd', '天翼快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(281, 'wedepot', 'wedepot物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(282, 'zhaijibian', '宅急便', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(283, 'abf', 'ABF', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(284, 'anposten', '爱尔兰(An Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(285, 'baitengwuliu', '百腾物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(286, 'biaojikuaidi', '彪记快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(287, 'boyol', '贝业物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(288, 'bulgarian', '保加利亚（Bulgarian Posts）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(289, 'chronopostport', 'Chronopost Portugal', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(290, 'cnexps', 'CNE', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(291, 'dhlbenelux', 'DHL Benelux', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(292, 'dhlecommerce', 'dhl小包', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(293, 'exsuda', 'E速达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(294, 'feikangda', '飞康达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(295, 'jiachenexpress', '佳辰国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(296, 'jiacheng', '佳成快递 ', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(297, 'jingshun', '景顺物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(298, 'lasership', 'LaserShip', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(299, 'mingliangwuliu', '明亮物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(300, 'shunjiefengda', '顺捷丰达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(301, 'skynetmalaysia', 'SkyNet Malaysia', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(302, 'sundarexpress', '顺达快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(303, 'swisspost', '瑞士(Swiss Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(304, 'trackparcel', 'track-parcel', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(305, 'uscbexpress', '易境达国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(306, 'xynyc', '新元国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(307, 'yaofeikuaidi', '耀飞同城快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(308, '1ziton', '一智通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(309, 'adp', 'ADP国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(310, 'alog', '心怡物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(311, 'asendiausa', 'Asendia USA', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(312, 'ausexpress', '澳世速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(313, 'bdatong', '八达通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(314, 'bosind', '堡昕德速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(315, 'buytong', '百通物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(316, 'changyuwuliu', '长宇物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(317, 'chuanxiwuliu', '传喜物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(318, 'chunghwa56', '中骅物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(319, 'cllexpress', '澳通华人物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(320, 'cnspeedster', '速舟物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(321, 'comexpress', '邦通国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(322, 'cosco', '中远e环球', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(323, 'didasuyun', '递达速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(324, 'emswuliu', 'EMS物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(325, 'feibaokuaidi', '飞豹快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(326, 'gda', '安的快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(327, 'gdkjk56', '快捷快物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(328, 'gotoubi', 'UBI Australia', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(329, 'guoeryue', '天天快物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(330, 'hermes', 'Hermes', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(331, 'hotwms', '皇家云仓', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(332, 'ht22', '海淘物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(333, 'huaqikuaiyun', '华企快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(334, 'ibuy8', '爱拜物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(335, 'japanpost', '日本郵便', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(336, 'jcsuda', '嘉诚速达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(337, 'kcs', 'KCS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(338, 'longcps', '加拿大龙行速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(339, 'lsexpress', '6LS EXPRESS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(340, 'moldova', '摩尔多瓦(Posta Moldovei)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(341, 'newsway', '家家通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(342, 'pengyuanexpress', '鹏远国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(343, 'postdanmarken', '丹麦(Post Denmark)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(344, 'postnl', '荷兰邮政(PostNL international regist', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(345, 'postnlpacle', '荷兰包裹(PostNL International Parcel', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(346, 'postserv', '台湾（中华邮政）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(347, 'purolator', 'Purolator', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(348, 'qbexpress', '秦邦快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(349, 'quanritongkuaidi', '全日通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(350, 'saiaodi', '赛澳递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(351, 'sanshengco', '三盛快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(352, 'shangcheng', '尚橙物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(353, 'shipgce', '飞洋快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(354, 'shunfenghk', '顺丰-繁体', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(355, 'singpost', '新加坡小包(Singapore Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(356, 'slovenia', '斯洛文尼亚(Slovenia Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(357, 'spring56', '春风物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(358, 'stoexpress', '美国申通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(359, 'sxhongmajia', '红马甲物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(360, 'szshihuatong56', '世华通物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(361, 'tollpriority', 'Toll Priority(Toll Online)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(362, 'wto56kj', '臣邦同城', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(363, 'xiangteng', '翔腾物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(364, 'xunsuexpress', '迅速快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(365, 'yongchangwuliu', '永昌物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(366, 'yuanzhijiecheng', '元智捷诚', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(367, 'yuefengwuliu', '越丰物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(368, 'zhonghuanus', '中环转运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(369, 'zhongjiwuliu', '中技物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(370, 'zlxdjwl', '中粮鲜到家物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(371, 'a2u', 'A2U速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(372, 'abcglobal', '全球快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(373, 'adaexpress', '明大快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(374, 'adiexpress', '安达易国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(375, 'adlerlogi', '德国雄鹰速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(376, 'advancing', '安达信', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(377, 'afghan', '阿富汗(Afghan Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(378, 'afl', 'AFL', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(379, 'agopost', '全程快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(380, 'ahdf', '德方物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(381, 'ahkbps', '卡邦配送', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(382, 'airgtc', '航空快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(383, 'airpak', 'airpak expresss', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(384, 'ajexpress', '捷记方舟', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(385, 'albania', '阿尔巴尼亚(Posta shqipatre)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(386, 'aliexpress', '无忧物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(387, 'amazoncnorder', '亚马逊中国订单', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(388, 'amcnorder', 'amazon-国内订单', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(389, 'amusorder', 'amazon-国际订单', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(390, 'anjiatongcheng', '安家同城快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(391, 'anjie88', '安捷物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(392, 'anjiekuaidi', '青岛安捷快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(393, 'anlexpress', '新干线快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(394, 'aolau', 'AOL澳通速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(395, 'aosu', '澳速物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(396, 'apgecommerce', 'apgecommerce', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(397, 'aplus100', '美国汉邦快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(398, 'aplusex', 'Aplus物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(399, 'ariesfar', '艾瑞斯远', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(400, 'aruba', '阿鲁巴[荷兰]（Post Aruba）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(401, 'auex', '澳货通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(402, 'ausbondexpress', '澳邦国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(403, 'austria', '奥地利(Austrian Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(404, 'auvanda', '中联速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(405, 'auvexpress', 'AUV国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(406, 'axexpress', '澳新物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(407, 'azerbaijan', '阿塞拜疆EMS(EMS AzerExpressPost)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(408, 'bahrain', '巴林(Bahrain Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(409, 'baishiyp', '百世云配', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(410, 'bangbangpost', '帮帮发', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(411, 'bangladesh', '孟加拉国(EMS)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(412, 'bangsongwuliu', '邦送物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(413, 'baotongkd', '宝通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(414, 'baoxianda', '报通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(415, 'barbados', '巴巴多斯(Barbados Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(416, 'bazirim', '皮牙子快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(417, 'bcwelt', 'BCWELT', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(418, 'beckygo', '佰麒快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(419, 'bee001', '蜜蜂速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(420, 'belgiumpost', '比利时(Belgium Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(421, 'belize', '伯利兹(Belize Postal)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(422, 'belpost', '白俄罗斯(Belpochta)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(423, 'benniao', '笨鸟国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(424, 'benteng', '奔腾物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(425, 'bester', '飛斯特', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(426, 'bjqywl', '青云物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(427, 'bjxsrd', '鑫锐达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(428, 'bljt56', '佰乐捷通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(429, 'bluedart', 'BlueDart', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(430, 'bmlchina', '标杆物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(431, 'bohei', '波黑(JP BH Posta)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(432, 'bolivia', '玻利维亚', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(433, 'borderguru', 'BorderGuru', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(434, 'botspost', '博茨瓦纳', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(435, 'bphchina', '速方(Sufast)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(436, 'bpostinter', '比利时国际(Bpost international)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(437, 'bqcwl', '百千诚物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(438, 'brazilposten', '巴西(Brazil Post/Correios)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(439, 'brunei', '文莱(Brunei Postal)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(440, 'byht', '展勤快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(441, 'caledonia', '新喀里多尼亚[法国](New Caledonia)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(442, 'cambodia', '柬埔寨(Cambodia Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(443, 'camekong', '到了港', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(444, 'cameroon', '喀麦隆(CAMPOST)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(445, 'campbellsexpress', 'Campbell’s Express', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(446, 'canhold', '能装能送', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(447, 'canpostfr', '加拿大邮政', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(448, 'cargolux', '卢森堡航空', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(449, 'cbo56', '钏博物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(450, 'ccd', '河南次晨达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(451, 'cces', 'CCES/国通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(452, 'cdek', 'CDEK', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(453, 'cdjx56', '捷祥物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(454, 'cdxinchen56', '鑫宸物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(455, 'ceskaposta', '捷克（?eská po?ta）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(456, 'cevalogistics', 'CEVA Logistic', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(457, 'cex', '城铁速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(458, 'cfss', '银雁专送', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(459, 'changwooair', '昌宇国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(460, 'chengda', '成达国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(461, 'chengji', '城际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(462, 'chengpei', '河北橙配', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(463, 'chile', '智利(Correos Chile)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(464, 'chinasqk', 'SQK国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(465, 'chinastarlogistics', '华欣物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(466, 'chinatzx', '同舟行物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(467, 'chllog', '嘉荣物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(468, 'chronopostfra', '法国大包、EMS-法文（Chronopost France）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(469, 'chronopostfren', '法国大包、EMS-英文(Chronopost France)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(470, 'cht361', '诚和通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(471, 'chunfai', '中国香港骏辉物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(472, 'city56', '城市映急', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(473, 'citylink', 'City-Link', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(474, 'citysprint', 'citysprint', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(475, 'cjkoreaexpress', '大韩通运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(476, 'ckeex', '城晓国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(477, 'cloudexpress', 'CE易欧通国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(478, 'clsp', 'CL日中速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(479, 'cnair', 'CNAIR', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(480, 'cncexp', 'C&C国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(481, 'cneulogistics', '中欧物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(482, 'cnup', 'CNUP 中联邮', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(483, 'cnws', '中国翼', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(484, 'colombia', '哥伦比亚(4-72 La Red Postal de Colom', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(485, 'correios', '莫桑比克（Correios de Moçambique）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(486, 'correo', '乌拉圭（Correo Uruguayo）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(487, 'correoargentino', '阿根廷(Correo Argentina)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(488, 'correos', '哥斯达黎加(Correos de Costa Rica)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(489, 'cpsair', '华中快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(490, 'cqxingcheng', '重庆星程快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(491, 'crossbox', '环旅快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(492, 'csxss', '新时速物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(493, 'ctoexp', '泰国中通CTO', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(494, 'cypruspost', '塞浦路斯(Cyprus Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(495, 'czwlyn', '云南诚中物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(496, 'dadaoex', '大道物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(497, 'dande56', '丹递56', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(498, 'dasu', '达速物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(499, 'dcs', 'DCS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(500, 'dechuangwuliu', '深圳德创物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(501, 'decnlh', '德中快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(502, 'deltec', 'Deltec Courier', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(503, 'desworks', '澳行快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(504, 'dfkuaidi', '东风快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(505, 'dfpost', '达方物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(506, 'dhlhk', 'DHL HK', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(507, 'dhlnetherlands', 'DHL-荷兰（DHL Netherlands）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(508, 'dhlpoland', 'DHL-波兰（DHL Poland）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(509, 'di5pll', '递五方云仓', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(510, 'diantongkuaidi', '店通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(511, 'dianyi', '云南滇驿物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(512, 'dindon', '叮咚澳洲转运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(513, 'dingdong', '叮咚快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(514, 'directlink', 'Direct Link', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(515, 'disifangau', '递四方澳洲', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(516, 'disifangus', '递四方美国', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(517, 'djy56', '天翔东捷运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(518, 'donghanwl', '东瀚物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(519, 'donghong', '东红物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(520, 'dongjun', '成都东骏物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(521, 'dpdgermany', 'DPD Germany', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(522, 'dpdpoland', 'DPD Poland', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(523, 'dpduk', 'DPD UK', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(524, 'dtdcindia', 'DTDC India', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(525, 'duodao56', 'duodao56', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(526, 'ealceair', '东方航空物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(527, 'easyexpress', 'EASY EXPRESS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(528, 'ecallturn', 'E跨通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(529, 'ecfirstclass', 'EC-Firstclass', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(530, 'ecmsglobal', 'ECMS Express', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(531, 'ecotransite', '东西E全运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(532, 'ecuador', '厄瓜多尔(Correos del Ecuador)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(533, 'edaeuexpress', '易达快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(534, 'edragon', '龙象国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(535, 'edtexpress', 'e直运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(536, 'efspost', 'EFSPOST', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(537, 'egypt', '埃及（Egypt Post）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(538, 'eiffel', '艾菲尔国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(539, 'el56', '易联通达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(540, 'elta', '希腊包裹（ELTA Hellenic Post）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(541, 'eltahell', '希腊EMS（ELTA Courier）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(542, 'emirates', '阿联酋(Emirates Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(543, 'emms', '澳州顺风快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(544, 'emonitoring', '波兰小包(Poczta Polska)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(545, 'emssouthafrica', '南非EMS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(546, 'emsukraine', '乌克兰EMS(EMS Ukraine)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(547, 'emsukrainecn', '乌克兰EMS-中文(EMS Ukraine)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(548, 'england', '英国(大包,EMS)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(549, 'epspost', '联众国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(550, 'esinotrans', '中外运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(551, 'estafeta', 'Estafeta', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(552, 'estes', 'Estes', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(553, 'eta100', '易达国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(554, 'ethiopia', '埃塞俄比亚(Ethiopian postal)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(555, 'eucnrail', '中欧国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(556, 'eucpost', '德国 EUC POST', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(557, 'euexpress', 'EU-EXPRESS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(558, 'euguoji', '易邮国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(559, 'europe8', '败欧洲', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(560, 'europeanecom', 'europeanecom', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(561, 'eusacn', '优莎速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(562, 'excocotree', '可可树美中速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(563, 'expressplus', '澳洲新干线快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(564, 'ezhuanyuan', '易转运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(565, 'fandaguoji', '颿达国际快递-英文', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(566, 'fanyukuaidi', '凡宇快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(567, 'fardarww', '颿达国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(568, 'fastontime', '加拿大联通快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(569, 'fastway', 'Fastway Ireland', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(570, 'fastzt', '正途供应链', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(571, 'fbkd', '飞邦快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(572, 'fedexuk', 'FedEx-英国件（FedEx UK)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(573, 'fedexukcn', 'FedEx-英国件', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(574, 'fedroad', 'FedRoad 联邦转运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(575, 'feihukuaidi', '飞狐快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(576, 'feikuaida', '飞快达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(577, 'fenghuangkuaidi', '凤凰快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(578, 'fengyee', '丰羿', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(579, 'fiji', '斐济(Fiji Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(580, 'finland', '芬兰(Itella Posti Oy)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(581, 'flowerkd', '花瓣转运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(582, 'flysman', '飞力士物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(583, 'fourpxus', '四方格', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(584, 'fox', 'FOX国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(585, 'freakyquick', 'FQ狂派速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(586, 'fsexp', '全速快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(587, 'ftlexpress', '法翔速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(588, 'fyex', '飞云快递系统', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(589, 'gaotieex', '高铁快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(590, 'gaticn', 'Gati-中文', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(591, 'gatien', 'Gati-英文', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(592, 'gatikwe', 'Gati-KWE', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(593, 'gdct56', '广东诚通物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(594, 'gdqwwl', '全网物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(595, 'gdrz58', '容智快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(596, 'gdxp', '新鹏快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(597, 'ge2d', 'GE2D跨境物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(598, 'georgianpost', '格鲁吉亚(Georgian Pos）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(599, 'ghl', '环创物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(600, 'ghtexpress', 'GHT物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(601, 'gibraltar', '直布罗陀[英国]( Royal Gibraltar Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(602, 'gjwl', '冠捷物流 ', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(603, 'globaltracktrace', 'globaltracktrace', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(604, 'gls', 'GLS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(605, 'gml', '英脉物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(606, 'goldjet', '高捷快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(607, 'gongsuda', '共速达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(608, 'gooday365', '日日顺智慧物联', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(609, 'greenland', '格陵兰[丹麦]（TELE Greenland A/S）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(610, 'grivertek', '潍鸿', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(611, 'gscq365', '哥士传奇速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(612, 'gswtkd', '万通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(613, 'gtgogo', 'GT国际快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(614, 'gtongsudi', '广通速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(615, 'gttexpress', 'GTT EXPRESS快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(616, 'guangdongtonglu', '广东通路', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(617, 'guanting', '冠庭国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(618, 'guosong', '国送快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(619, 'gvpexpress', '宏观国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(620, 'gxwl', '光线速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(621, 'gzxingcheng', '贵州星程快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(622, 'haihongmmb', '海红for买卖宝', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(623, 'haihongwangsong', '海红网送', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(624, 'haimengsudi', '海盟速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(625, 'haiwaihuanqiu', '海外环球', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(626, 'haixingqiao', '海星桥快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(627, 'haizhongzhuanyun', '海中转运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(628, 'handboy', '汉邦国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(629, 'hanfengjl', '翰丰快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(630, 'hangrui', '上海航瑞货运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(631, 'hangyu', '航宇快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(632, 'haoyoukuai', '好又快物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(633, 'happylink', '开心快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(634, 'haypost', '亚美尼亚(Haypost-Armenian Postal)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(635, 'hdcexpress', '汇达物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(636, 'hengrui56', '恒瑞物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(637, 'hexinexpress', '合心速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(638, 'hgy56', '环国运物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(639, 'hhair56', '华瀚快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(640, 'highsince', 'Highsince', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(641, 'hitaoe', 'Hi淘易快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(642, 'hjs', '猴急送', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(643, 'hkposten', '中国香港(HongKong Post)英文', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(644, 'hlkytj', '互联快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(645, 'hlpgyl', '共联配', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(646, 'hltop', '海联快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(647, 'hmus', '华美快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(648, 'hnfy', '飞鹰物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(649, 'hnqst', '河南全速通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(650, 'hnssd56', '顺时达物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(651, 'hnzqwl', '中强物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(652, 'homecourier', '如家国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(653, 'homexpress', '居家通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(654, 'hongbeixin', '红背心', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(655, 'hongjie', '宏捷国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(656, 'hongpinwuliu', '宏品物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(657, 'hongywl', '红远物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(658, 'hqtd', '环球通达 ', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(659, 'hrbzykd', '卓烨快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(660, 'hre', '高铁速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(661, 'hrvatska', '克罗地亚（Hrvatska Posta）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(662, 'hsgtsd', '海硕高铁速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(663, 'htongexpress', '华通快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(664, 'htwd', '华通务达物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(665, 'huada', '华达快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(666, 'huandonglg', '环东物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(667, 'huanqiuabc', '中国香港环球快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(668, 'huiqiangkuaidi', '汇强快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(669, 'humpline', '驼峰国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(670, 'hungary', '匈牙利（Magyar Posta）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(671, 'huoban', '兰州伙伴物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(672, 'hutongwuliu', '户通物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(673, 'hyeship', '鸿远物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(674, 'hyk', '上海昊宏国际货物', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(675, 'hyytes', '恒宇运通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(676, 'hzpl', '华航快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(677, 'iceland', '冰岛(Iceland Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(678, 'idada', '大达物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(679, 'iexpress', 'iExpress', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(680, 'ilogen', 'logen路坚', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(681, 'ilyang', 'ILYANG', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(682, 'imlb2c', '艾姆勒', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(683, 'india', '印度(India Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(684, 'indonesia', '印度尼西亚EMS(Pos Indonesia-EMS)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(685, 'inposdom', '多米尼加（INPOSDOM – Instituto Postal', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(686, 'interlink', 'Interlink Express', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(687, 'iparcel', 'UPS i-parcel', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(688, 'iran', '伊朗（Iran Post）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(689, 'israelpost', '以色列(Israel Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(690, 'italysad', 'Italy SDA', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(691, 'iyoungspeed', '驿扬国际速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(692, 'jamaicapost', '牙买加（Jamaica Post）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(693, 'jcex', 'jcex', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(694, 'jdexpressusa', '骏达快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(695, 'jdiex', 'JDIEX', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(696, 'jdpplus', '急递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(697, 'jerseypost', '泽西岛', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(698, 'jetexpressgroup', '澳速通国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(699, 'jiajiatong56', '佳家通货运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(700, 'jiajiawl', '加佳物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(701, 'jiazhoumao', '加州猫速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(702, 'jieanda', '捷安达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(703, 'jiguang', '极光转运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(704, 'jinchengwuliu', '锦程物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(705, 'jindawuliu', '金大物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(706, 'jintongkd', '劲通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(707, 'jinyuekuaidi', '晋越快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(708, 'jisu', '冀速物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(709, 'jiugong', '九宫物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(710, 'jiuyicn', '久易快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(711, 'jixianda', '急先达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(712, 'jixiangyouau', '吉祥邮（澳洲）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(713, 'jjx888', '佳捷翔物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(714, 'jordan', '约旦(Jordan Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(715, 'jsexpress', '骏绅物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(716, 'juding', '聚鼎物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(717, 'junfengguoji', '骏丰国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(718, 'juwu', '聚物物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(719, 'juzhongda', '聚中大', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(720, 'kaolaexpress', '考拉国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(721, 'kazpost', '哈萨克斯坦(Kazpost)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(722, 'kejie', '科捷物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(723, 'kenya', '肯尼亚(POSTA KENYA)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(724, 'kerrytj', '嘉里大荣物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(725, 'keypon', '启邦国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(726, 'kfwnet', '快服务', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(727, 'khzto', '柬埔寨中通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(728, 'kingfreight', '货运皇', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(729, 'kjde', '跨境直邮通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(730, 'koalaexp', '考拉速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(731, 'koali', '番薯国际货运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(732, 'koreapost', '韩国（Korea Post）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(733, 'koreapostcn', '韩国邮政', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(734, 'koreapostkr', '韩国邮政韩文', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(735, 'krtao', '淘韩国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(736, 'ksudi', '快速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(737, 'kuai8', '快8速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(738, 'kuaidawuliu', '快达物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(739, 'kuaitao', '快淘快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(740, 'kuaiyouda', '四川快优达速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(741, 'kxda', '凯信达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(742, 'kyrgyzpost', '吉尔吉斯斯坦(Kyrgyz Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(743, 'kyue', '跨跃国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(744, 'lanbiaokuaidi', '蓝镖快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(745, 'landmarkglobal', 'Landmark Global', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(746, 'lanhukuaidi', '蓝弧快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(747, 'lao', '老挝(Lao Express) ', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(748, 'laposte', '塞内加尔', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(749, 'lasy56', '林安物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(750, 'latvia', '拉脱维亚(Latvijas Pasts)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(751, 'lbbk', '立白宝凯物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(752, 'ldxpres', '林道国际快递-英文', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(753, 'ledaowuliu', '楽道物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(754, 'ledii', '乐递供应链', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(755, 'leopard', '云豹国际货运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(756, 'lesotho', '莱索托(Lesotho Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(757, 'letseml', '美联快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(758, 'lgs', 'lazada', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(759, 'lianbangkuaidien', '联邦快递-英文', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(760, 'lianyun', '联运快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(761, 'libanpost', '黎巴嫩(Liban Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(762, 'linex', 'Linex', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(763, 'lishi', '丽狮物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(764, 'lithuania', '立陶宛（Lietuvos pa?tas）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(765, 'littlebearbear', '小熊物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(766, 'lmfex', '良藤国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(767, 'logistics', '華信物流WTO', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(768, 'longlangkuaidi', '隆浪快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(769, 'longvast', '长风物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(770, 'lqht', '恒通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(771, 'ltexp', '乐天速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(772, 'ltparcel', '联通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(773, 'luckyfastex', '吉捷国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(774, 'lundao', '论道国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(775, 'lutong', '鲁通快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(776, 'luxembourg', '卢森堡(Luxembourg Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(777, 'lwe', 'LWE', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(778, 'macao', '中国澳门(Macau Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(779, 'macedonia', '马其顿(Macedonian Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(780, 'mailikuaidi', '麦力快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(781, 'mailongdy', '迈隆递运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(782, 'malaysiaems', '马来西亚大包、EMS（Malaysia Post(parcel,', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(783, 'malaysiapost', '马来西亚小包（Malaysia Post(Registered)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(784, 'maldives', '马尔代夫(Maldives Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(785, 'malta', '马耳他（Malta Post）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(786, 'mangguo', '芒果速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(787, 'mapleexpress', '今枫国际快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(788, 'mauritius', '毛里求斯(Mauritius Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(789, 'maxeedexpress', '澳洲迈速快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(790, 'mchy', '木春货运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(791, 'meibang', '美邦国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(792, 'meidaexpress', '美达快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(793, 'meitai', '美泰物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(794, 'meixi', '美西快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(795, 'mexico', '墨西哥（Correos de Mexico）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(796, 'mexicodenda', 'Mexico Senda Express', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(797, 'milkyway', '银河物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(798, 'minbangsudi', '民邦速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(799, 'mjexp', '美龙快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(800, 'mmlogi', '猛犸速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(801, 'mongolpost', '蒙古国(Mongol Post) ', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(802, 'montenegro', '黑山(Posta Crne Gore)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(803, 'morocco', '摩洛哥 ( Morocco Post )', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(804, 'mrw', 'MRW', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(805, 'multipack', 'Mexico Multipack', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(806, 'mxe56', '中俄速通（淼信）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(807, 'nalexpress', '新亚物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(808, 'namibia', '纳米比亚(NamPost)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(809, 'nedahm', '红马速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(810, 'nederlandpost', '荷兰速递(Nederland Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(811, 'nell', '尼尔快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(812, 'nepalpost', '尼泊尔（Nepal Postal Services）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(813, 'newgistics', 'Newgistics', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(814, 'nigerianpost', '尼日利亚(Nigerian Postal)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(815, 'niuzaiexpress', '牛仔速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(816, 'njhaobo', '浩博物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(817, 'nle', 'NLE', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(818, 'nlebv', '亚欧专线', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(819, 'nmhuahe', '华赫物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(820, 'nntengda', '腾达速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(821, 'novaposhta', 'Nova Poshta', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(822, 'nuoer', '诺尔国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(823, 'nuoyaao', '偌亚奥国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(824, 'nzzto', '新西兰中通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(825, 'ocaargen', 'OCA Argentina', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(826, 'oman', '阿曼(Oman Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(827, 'omniva', '爱沙尼亚(Eesti Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(828, 'ontrac', 'OnTrac', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(829, 'onway', '昂威物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(830, 'opek', 'OPEK', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(831, 'overseaex', '波音速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(832, 'pakistan', '巴基斯坦(Pakistan Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(833, 'paraguay', '巴拉圭(Correo Paraguayo)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(834, 'parcelchina', '诚一物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(835, 'parcelforcecn', '英国邮政大包EMS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(836, 'pcaexpress', 'PCA Express', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(837, 'pdstow', '全球速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(838, 'peex', '派尔快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(839, 'peisihuoyunkuaidi', '配思货运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(840, 'peixingwuliu', '陪行物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(841, 'pengcheng', '鹏程快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(842, 'peru', '秘鲁(SERPOST)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(843, 'pinsuxinda', '品速心达快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(844, 'pinxinkuaidi', '品信快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(845, 'pioneer', '先锋国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(846, 'pmt0704be', '龙行天下', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(847, 'pochta', '俄罗斯邮政(Russian Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(848, 'polarisexpress', '北极星快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(849, 'portugalctt', '葡萄牙（Portugal CTT）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(850, 'portugalseur', 'Portugal Seur', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(851, 'posta', '坦桑尼亚（Tanzania Posts Corporation）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(852, 'postelbe', 'PostElbe', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(853, 'postenab', 'PostNord(Posten AB)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(854, 'postennorge', '挪威（Posten Norge）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(855, 'postpng', '巴布亚新几内亚(PNG Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(856, 'ptt', '土耳其', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(857, 'pzhjst', '急顺通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(858, 'qdants', 'ANTS EXPRESS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(859, 'qesd', '7E速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(860, 'qhxykd', '雪域快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(861, 'qhxyyg', '雪域易购', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(862, 'qianli', '千里速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(863, 'qichen', '启辰国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(864, 'qpost', '卡塔尔（Qatar Post）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(865, 'qskdyxgs', '千顺快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(866, 'quanchuan56', '全川物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(867, 'quanjitong', '全际通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(868, 'quantium', 'Quantium', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(869, 'quantwl', '全通快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(870, 'quanxintong', '全信通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(871, 'qzx56', '全之鑫物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(872, 'redexpress', 'Red Express', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(873, 'republic', '叙利亚(Syrian Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(874, 'rhtexpress', '睿和泰速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(875, 'riyuwuliu', '日昱物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(876, 'rokin', '荣庆物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(877, 'romanian', '罗马尼亚（Posta Romanian）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(878, 'rpx', 'rpx', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(879, 'rrskx', '日日顺快线', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(880, 'rrthk', '日日通国际', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(881, 'rwanda', '卢旺达(Rwanda i-posita)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(882, 's2c', 'S2C', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(883, 'safexpress', 'Safexpress', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(884, 'saiaodimmb', '赛澳递for买卖宝', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(885, 'samoa', '萨摩亚(Samoa Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(886, 'santaisudi', '三态速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(887, 'saudipost', '沙特阿拉伯(Saudi Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(888, 'sccod', '丰程物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(889, 'scic', '中加国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(890, 'scsujiada', '速佳达快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(891, 'scxingcheng', '四川星程快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(892, 'sczpds', '速呈', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(893, 'sd138', '泰国138国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(894, 'sdsy888', '首达速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(895, 'selektvracht', 'Selektvracht', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(896, 'serbia', '塞尔维亚(PE Post of Serbia)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(897, 'seur', 'International Seur', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(898, 'sfau', '澳丰速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(899, 'sfift', '十方通物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(900, 'sfjhd', '圣飞捷快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(901, 'sfpost', '曹操到', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(902, 'shanda56', '衫达快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(903, 'shanghaikuaitong', '上海快通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(904, 'shanghaiwujiangmmb', '上海无疆for买卖宝', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(905, 'shangtuguoji', '尚途国际货运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(906, 'shaoke', '捎客物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(907, 'shd56', '商海德物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(908, 'shenganwuliu', '圣安物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(909, 'shengtongscm', '盛通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(910, 'shenjun', '神骏物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(911, 'shenma', '神马快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(912, 'shiningexpress', '阳光快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(913, 'shipbyace', '王牌快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(914, 'shipsoho', '苏豪快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(915, 'shiyunkuaidi', '世运快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(916, 'shlexp', 'SHL畅灵国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(917, 'shpostwish', 'wish邮', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(918, 'shunbang', '顺邦国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(919, 'shunfengtongcheng', '顺丰同城', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(920, 'shunjieda', '顺捷达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(921, 'shunshid', '顺士达速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(922, 'signedexpress', '签收快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(923, 'sihaiet', '四海快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(924, 'sihiexpress', '四海捷运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(925, 'sinoairinex', '中外运空运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(926, 'sinoex', '中外运速递-中文', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(927, 'siodemka', 'Siodemka', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(928, 'sixroad', '易普递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(929, 'skynet', 'skynet', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(930, 'skynetworldwide', 'skynetworldwide', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(931, 'skypost', '荷兰Sky Post', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(932, 'slovak', '斯洛伐克(Slovenská Posta)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(933, 'slpost', '斯里兰卡(Sri Lanka Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(934, 'sofast56', '嗖一下同城快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(935, 'southafrican', '南非（South African Post Office）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(936, 'speeda', '行必达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(937, 'speedoex', '申必达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(938, 'speedpost', '新加坡EMS、大包(Singapore Speedpost)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(939, 'staky', '首通快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(940, 'starex', '星速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(941, 'staryvr', '星运快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(942, 'stkd', '顺通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(943, 'subaoex', '速豹', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(944, 'sucheng', '速呈宅配', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(945, 'sucmj', '特急便物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(946, 'sudapost', '苏丹（Sudapost）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(947, 'sufengkuaidi', '速风快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(948, 'suijiawuliu', '穗佳物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(949, 'sujievip', '郑州速捷', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(950, 'sunspeedy', '新速航', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(951, 'superoz', '速配欧翼', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(952, 'supinexpress', '速品快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(953, 'swisspostcn', '瑞士邮政', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(954, 'szdpex', '深圳DPEX', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(955, 'szuem', '联运通物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(956, 'taijin', '泰进物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(957, 'taimek', '天美快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(958, 'tanzania', '坦桑尼亚(Tanzania Posts)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(959, 'tcixps', 'TCI XPS', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(960, 'tcxbthai', 'TCXB国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(961, 'tdcargo', 'TD Cargo', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(962, 'thailand', '泰国（Thailand Thai Post）', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(963, 'thaizto', '泰国中通ZTO', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(964, 'thunderexpress', '加拿大雷霆快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(965, 'tianxiang', '天翔快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(966, 'tianzong', '天纵物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(967, 'timedg', '万家通快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(968, 'tlky', '天联快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(969, 'tmg', '株式会社T.M.G', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(970, 'tmwexpress', '明达国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(971, 'tntitaly', 'TNT Italy', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(972, 'tntpostcn', 'TNT Post', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(973, 'tntuk', 'TNT UK', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(974, 'tny', 'TNY物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(975, 'tongdaxing', '通达兴物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(976, 'tonghetianxia', '通和天下', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(977, 'topshey', '顶世国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(978, 'ttkeurope', '天天欧洲物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(979, 'tunisia', '突尼斯EMS(Rapid-Poste)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(980, 'turtle', '海龟国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(981, 'uex', 'UEX国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(982, 'uexiex', '欧洲UEX', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(983, 'uganda', '乌干达(Posta Uganda)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(984, 'ugoexpress', '邮鸽速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(985, 'uhi', '优海国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(986, 'ukraine', '乌克兰小包、大包(UkrPoshta)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(987, 'ukrpost', '乌克兰小包、大包(UkrPost)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(988, 'ukrpostcn', '乌克兰邮政包裹', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(989, 'uluckex', '优联吉运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(990, 'upsfreight', 'UPS Freight', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(991, 'upsmailinno', 'UPS Mail Innovations', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(992, 'uschuaxia', '华夏国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(993, 'uspscn', 'USPSCN', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(994, 'utaoscm', 'UTAO优到', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(995, 'uzbekistan', '乌兹别克斯坦(Post of Uzbekistan)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(996, 'vangenexpress', '万庚国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(997, 'vanuatu', '瓦努阿图(Vanuatu Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(998, 'vctrans', '越中国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(999, 'vietnam', '越南小包(Vietnam Posts)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1000, 'vipexpress', '鹰运国际速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1001, 'vnpost', '越南EMS(VNPost Express)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1002, 'vps', '维普恩物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1003, 'wanboex', '万博快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1004, 'wandougongzhu', '豌豆物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1005, 'wanjiatong', '宁夏万家通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1006, 'wdm', '万达美', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1007, 'wenjiesudi', '文捷航空', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1008, 'westwing', '西翼物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1009, 'wexpress', '威速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1010, 'whgjkd', '香港伟豪国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1011, 'winit', '万邑通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1012, 'wlfast', '凡仕特物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1013, 'wowvip', '沃埃家', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1014, 'wtdchina', '威时沛运货运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1015, 'wtdex', 'WTD海外通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1016, 'wuliuky', '五六快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1017, 'wuyuansudi', '伍圆速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1018, 'wygj168', '万运国际快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1019, 'wykjt', '51跨境通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1020, 'wzhaunyun', '微转运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1021, 'xdshipping', '国晶物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1022, 'xflt56', '蓝天物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1023, 'xianchengliansudi', '西安城联速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1024, 'xiangdawuliu', '湘达物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1025, 'xianglongyuntong', '祥龙运通物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1026, 'xiaocex', '小C海淘', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1027, 'xilaikd', '西安喜来快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1028, 'xingyuankuaidi', '新元快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1029, 'xinning', '新宁物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1030, 'xipost', '西邮寄', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1031, 'xiyoug', '西游寄', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1032, 'xsrd', '鑫世锐达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1033, 'xtb', '鑫通宝物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1034, 'xyd666', '鑫远东速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1035, 'yamaxunwuliu', '亚马逊中国', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1036, 'yatfai', '一辉物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1037, 'ycgglobal', 'YCG物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1038, 'ycgky', '远成快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1039, 'ydglobe', '云达通', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1040, 'ydhex', 'YDH', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1041, 'yemen', '也门(Yemen Post)', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1042, 'yhtlogistics', '宇航通物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1043, 'yibangwuliu', '一邦速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1044, 'yidihui', '驿递汇速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1045, 'yiex', '宜送物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1046, 'yifankd', '艺凡快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1047, 'yihangmall', '易航物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1048, 'yilingsuyun', '亿领速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1049, 'yingchao', '英超物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1050, 'yinjiesudi', '银捷速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1051, 'yiouzhou', '易欧洲国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1052, 'yiqiguojiwuliu', '一柒国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1053, 'yiqisong', '一起送', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1054, 'yishunhang', '亿顺航', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1055, 'yisong', '宜送', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1056, 'yitongda', '易通达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1057, 'yiyou', '易邮速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1058, 'yjhgo', '武汉优进汇', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1059, 'ykouan', '洋口岸', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1060, 'ynztsy', '纵通速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1061, 'yodel', 'YODEL', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1062, 'yongbangwuliu', '永邦国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1063, 'youjia', '友家速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1064, 'youlai', '邮来速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1065, 'yourscm', '雅澳物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1066, 'ypsd', '壹品速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1067, 'ytky168', '运通快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1068, 'yuandun', '远盾物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1069, 'yuanhhk', '远航国际快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1070, 'yue777', '玥玛速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1071, 'yuezhongsh', '粤中国际货运代理（上海）有限公司', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1072, 'yufeng', '御风速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1073, 'yujiawl', '宇佳物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1074, 'yundaexus', '美国云达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1075, 'yunexpress', '德国云快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1076, 'yuntong', '运通速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1077, 'yuntongkuaidi', '运通中港', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1078, 'ywexpress', '远为快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1079, 'yyexp', '西安运逸快递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1080, 'yyqc56', '一运全成物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1081, 'yzswuliu', '亚洲顺物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1082, 'zdepost', '直德邮', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1083, 'zenzen', '三三国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1084, 'zf365', '珠峰速运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1085, 'zhdwl', '众辉达物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1086, 'zhitengwuliu', '志腾物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1087, 'zhongtianwanyun', '中天万运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1088, 'zhongwaiyun', '中外运速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1089, 'zhongxinda', '忠信达', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1090, 'zhpex', '众派速递', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1091, 'zhuoshikuaiyun', '卓实快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1092, 'zjcy56', '创运物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1093, 'zjgj56', '振捷国际货运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1094, 'zsda56', '转瞬达集运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1095, 'zsky123', '准实快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1096, 'zsmhwl', '明辉物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1097, 'zteexpress', 'ZTE中兴物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1098, 'ztjieda', '泰捷达国际物流', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1099, 'zy100', '中远快运', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1100, 'zyzoom', '增速跨境 ', 0, 0, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1),
(1101, 'fengwang', '丰网速运', 1, 1, 0, 0, 0, 0, '', '', '', '', '', '', 0, 0, 1);

-- --------------------------------------------------------

--
-- 表的结构 `eb_lang_code`
--

CREATE TABLE IF NOT EXISTS `eb_lang_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(11) NOT NULL DEFAULT '0' COMMENT '语言类型',
  `code` varchar(255) NOT NULL DEFAULT '' COMMENT '状态码',
  `remarks` varchar(255) NOT NULL DEFAULT '' COMMENT '备注说明',
  `lang_explain` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `is_admin` tinyint(1) NOT NULL DEFAULT '0' COMMENT '服务端1，用户端2',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25001 DEFAULT CHARSET=utf8 COMMENT='语言code表';

--
-- 转存表中的数据 `eb_lang_code`
--

INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(1, 1, '100000', '保存成功', '保存成功', 1),
(2, 1, '100001', '修改成功', '修改成功', 1),
(3, 1, '100002', '删除成功', '删除成功', 1),
(4, 1, '100003', '显示成功', '显示成功', 1),
(5, 1, '100004', '隐藏成功', '隐藏成功', 1),
(6, 1, '100005', '操作失败', '操作失败', 1),
(7, 1, '100006', '保存失败', '保存失败', 1),
(8, 1, '100007', '修改失败', '修改失败', 1),
(9, 1, '100008', '删除失败', '删除失败', 1),
(10, 1, '100009', '图片上传成功', '图片上传成功', 1),
(11, 1, '100010', '操作成功', '操作成功', 1),
(12, 1, '100011', '暂无数据', '暂无数据', 1),
(13, 1, '100012', '更新成功', '更新成功', 1),
(14, 1, '100013', '更新失败', '更新失败', 1),
(15, 1, '100014', '设置成功', '设置成功', 1),
(16, 1, '100015', '设置失败', '设置失败', 1),
(17, 1, '100016', '获取失败', '获取失败', 1),
(18, 1, '100017', '提交成功', '提交成功', 1),
(19, 1, '100018', '提交失败', '提交失败', 1),
(20, 1, '100019', '取消成功', '取消成功', 1),
(21, 1, '100020', '取消失败', '取消失败', 1),
(22, 1, '100021', '添加成功', '添加成功', 1),
(23, 1, '100022', '添加失败', '添加失败', 1),
(24, 1, '100023', '保存token失败', '保存token失败', 1),
(25, 1, '100024', '备注成功', '备注成功', 1),
(26, 1, '100025', '备注失败', '备注失败', 1),
(27, 1, '100026', '数据不存在', '数据不存在', 1),
(28, 1, '100027', '申请成功', '申请成功', 1),
(29, 1, '100028', '申请失败', '申请失败', 1),
(30, 1, '100029', '暂无此方法', '暂无此方法', 1),
(31, 1, '100030', '发送成功', '发送成功', 1),
(32, 1, '100031', '发送失败', '发送失败', 1),
(33, 1, '100032', '上传成功', '上传成功', 1),
(34, 1, '100033', '上传失败', '上传失败', 1),
(35, 1, '100034', '移动成功', '移动成功', 1),
(36, 1, '100035', '移动失败', '移动失败', 1),
(37, 1, '100036', '退款成功', '退款成功', 1),
(38, 1, '100037', '退款失败', '退款失败', 1),
(39, 1, '100038', '同步成功', '同步成功', 1),
(40, 1, '100039', '同步失败', '同步失败', 1),
(41, 1, '100040', '恢复成功', '恢复成功', 1),
(42, 1, '100041', '恢复失败', '恢复失败', 1),
(43, 1, '100042', '退出成功', '退出成功', 1),
(44, 1, '100043', '退出失败', '退出失败', 1),
(45, 1, '100044', '开通成功', '开通成功', 1),
(46, 1, '100045', '开通失败', '开通失败', 1),
(47, 1, '100046', '清除数据成功', '清除数据成功', 1),
(48, 1, '100047', '优化成功', '优化成功', 1),
(49, 1, '100048', '优化失败', '优化失败', 1),
(50, 1, '100049', '修复成功', '修复成功', 1),
(51, 1, '100050', '修复失败', '修复失败', 1),
(52, 1, '100051', '备份成功', '备份成功', 1),
(53, 1, '100052', '备份失败', '备份失败', 1),
(54, 1, '100100', '参数错误', '参数错误', 1),
(55, 1, '100101', '非法操作', '非法操作', 1),
(56, 1, '100102', '数据获取失败', '数据获取失败', 1),
(57, 1, '100103', '站点升级中，请稍候访问', '站点升级中，请稍候访问', 1),
(58, 1, '100104', '缺少code', '缺少code', 1),
(59, 1, '110000', '您暂时没有访问权限', '您暂时没有访问权限', 1),
(60, 1, '110001', '接口未授权，您无法访问', '接口未授权，您无法访问', 1),
(61, 1, '110002', '请登录', '请登录', 1),
(62, 1, '110003', '登录已过期,请重新登录', '登录已过期,请重新登录', 1),
(63, 1, '110004', '登录状态有误,请重新登录', '登录状态有误,请重新登录', 1),
(64, 1, '110005', '请登录', '请登录', 1),
(65, 1, '110006', '登录已过期,请重新登录', '登录已过期,请重新登录', 1),
(66, 1, '110007', '登录状态有误,请重新登录', '登录状态有误,请重新登录', 1),
(67, 1, '400000', '请选择用户头像', '请选择用户头像', 1),
(68, 1, '400001', '请填写用户昵称', '请填写用户昵称', 1),
(69, 1, '400002', '请填写评论内容', '请填写评论内容', 1),
(70, 1, '400003', '请选择商品分数', '请选择商品分数', 1),
(71, 1, '400004', '请选择服务分数', '请选择服务分数', 1),
(72, 1, '400005', '商品分数必须是1-5之间的整数', '商品分数必须是1-5之间的整数', 1),
(73, 1, '400006', '服务分数必须是1-5之间的整数', '服务分数必须是1-5之间的整数', 1),
(74, 1, '400007', '请选择快递公司', '请选择快递公司', 1),
(75, 1, '400008', '请填写寄件人姓名', '请填写寄件人姓名', 1),
(76, 1, '400009', '请输入寄件人手机号码', '请输入寄件人手机号码', 1),
(77, 1, '400010', '寄件人手机号码不正确', '寄件人手机号码不正确', 1),
(78, 1, '400011', '请填写寄件人详细地址', '请填写寄件人详细地址', 1),
(79, 1, '400012', '请填写云打印机编号', '请填写云打印机编号', 1),
(80, 1, '400013', '请传入套餐id', '请传入套餐id', 1),
(81, 1, '400014', '套餐id必须为数字', '套餐id必须为数字', 1),
(82, 1, '400015', '请填写套餐金额', '请填写套餐金额', 1),
(83, 1, '400016', '请填写购买数量', '请填写购买数量', 1),
(84, 1, '400017', '购买数量必须为数字', '购买数量必须为数字', 1),
(85, 1, '400018', '请填写购买套餐类型', '请填写购买套餐类型', 1),
(86, 1, '400019', '您输入的手机号码必须为数字', '您输入的手机号码必须为数字', 1),
(87, 1, '400020', '密码必须填写', '密码必须填写', 1),
(88, 1, '400021', '短信验证码必须为数字', '短信验证码必须为数字', 1),
(89, 1, '400022', '请填写话术内容', '请填写话术内容', 1),
(90, 1, '400023', '请填写排序数字', '请填写排序数字', 1),
(91, 1, '400024', '请填写排序数字', '请填写排序数字', 1),
(92, 1, '400025', '请填写运费模板名称', '请填写运费模板名称', 1),
(93, 1, '400026', '运费信息必须为数组', '运费信息必须为数组', 1),
(94, 1, '400027', '包邮信息必须为数组', '包邮信息必须为数组', 1),
(95, 1, '400028', '不送达信息必须为数组', '不送达信息必须为数组', 1),
(96, 1, '400029', 'type数据格式错误，应为1或2或3', 'type数据格式错误，应为1或2或3', 1),
(97, 1, '400030', 'appoint数据格式错误，应为0或1', 'appoint数据格式错误，应为0或1', 1),
(98, 1, '400031', 'no_delivery数据格式错误，应为0或1', 'no_delivery数据格式错误，应为0或1', 1),
(99, 1, '400032', 'sort数据格式错误，应为整数', 'sort数据格式错误，应为整数', 1),
(100, 1, '400033', '请填写管理员账号', '请填写管理员账号', 1),
(101, 1, '400034', '管理员账号为英文字母', '管理员账号为英文字母', 1),
(102, 1, '400035', '请输管理员姓名', '请输管理员姓名', 1),
(103, 1, '400036', '请选择管理员身份', '请选择管理员身份', 1),
(104, 1, '400037', '身份必须为数组', '身份必须为数组', 1),
(105, 1, '400038', '请填写城市名称', '请填写城市名称', 1),
(106, 1, '400039', 'level数据格式错误，应为整数', 'level数据格式错误，应为整数', 1),
(107, 1, '400040', 'parent_id数据格式错误，应为整数', 'parent_id数据格式错误，应为整数', 1),
(108, 1, '400041', '请输入有效的网址', '请输入有效的网址', 1),
(109, 1, '400042', '一级返佣比例必须为数字', '一级返佣比例必须为数字', 1),
(110, 1, '400043', '一级返佣比例最多两位小数', '一级返佣比例最多两位小数', 1),
(111, 1, '400044', '一级返佣比例填写范围在0-100之间', '一级返佣比例填写范围在0-100之间', 1),
(112, 1, '400045', '二级返佣比例必须为数字', '二级返佣比例必须为数字', 1),
(113, 1, '400046', '二级返佣比例最多两位小数', '二级返佣比例最多两位小数', 1),
(114, 1, '400047', '二级返佣比例填写范围在0-100之间', '二级返佣比例填写范围在0-100之间', 1),
(115, 1, '400048', '待补货数量必须为数字', '待补货数量必须为数字', 1),
(116, 1, '400049', '警戒库存必须为数字', '警戒库存必须为数字', 1),
(117, 1, '400050', '提现最小金额只能为数字', '提现最小金额只能为数字', 1),
(118, 1, '400051', '提现最小金额必须大于0', '提现最小金额必须大于0', 1),
(119, 1, '400052', '佣金冻结时间范围在0-180之间', '佣金冻结时间范围在0-180之间', 1),
(120, 1, '400053', '满额分销金额金额必须为数字', '满额分销金额金额必须为数字', 1),
(121, 1, '400054', '积分抵用比例必须为数字', '积分抵用比例必须为数字', 1),
(122, 1, '400055', '积分抵用比例最多两位小数', '积分抵用比例最多两位小数', 1),
(123, 1, '400056', '积分抵用比例必须在0-1000之间', '积分抵用比例必须在0-1000之间', 1),
(124, 1, '400057', '积分抵用上限必须为数字', '积分抵用上限必须为数字', 1),
(125, 1, '400058', '积分抵用上限必须大于等于0', '积分抵用上限必须大于等于0', 1),
(126, 1, '400059', '下单赠送积分必须为数字', '下单赠送积分必须为数字', 1),
(127, 1, '400060', '下单赠送积分必须在0-1000之间', '下单赠送积分必须在0-1000之间', 1),
(128, 1, '400061', '普通商品未支付取消订单时间必须为数字', '普通商品未支付取消订单时间必须为数字', 1),
(129, 1, '400062', '活动商品未支付取消订单时间必须为数字', '活动商品未支付取消订单时间必须为数字', 1),
(130, 1, '400063', '砍价商品未支付取消订单时间必须为数字', '砍价商品未支付取消订单时间必须为数字', 1),
(131, 1, '400064', '拼团商品未支付取消订单时间必须为数字', '拼团商品未支付取消订单时间必须为数字', 1),
(132, 1, '400065', '订单发货后自动收货时间必须为数字', '订单发货后自动收货时间必须为数字', 1),
(133, 1, '400066', '满额包邮金额必须为数字', '满额包邮金额必须为数字', 1),
(134, 1, '400067', '积分倍数必须大于0', '积分倍数必须大于0', 1),
(135, 1, '400068', '折扣数必须大于0', '折扣数必须大于0', 1),
(136, 1, '400069', '积分倍数必须大于0', '积分倍数必须大于0', 1),
(137, 1, '400070', '折扣数必须大于0', '折扣数必须大于0', 1),
(138, 1, '400071', '下单赠送经验比率必须为数字', '下单赠送经验比率必须为数字', 1),
(139, 1, '400072', '下单赠送经验比率必须大于0', '下单赠送经验比率必须大于0', 1),
(140, 1, '400073', '签到赠送经验必须为数字', '签到赠送经验必须为数字', 1),
(141, 1, '400074', '签到赠送经验必须大于0', '签到赠送经验必须大于0', 1),
(142, 1, '400075', '邀请新用户赠送经验必须为数字', '邀请新用户赠送经验必须为数字', 1),
(143, 1, '400076', '邀请新用户赠送经验必须大于0', '邀请新用户赠送经验必须大于0', 1),
(144, 1, '400077', '发货人姓名必须为汉字', '发货人姓名必须为汉字', 1),
(145, 1, '400078', '发货人姓名长度在2-10位', '发货人姓名长度在2-10位', 1),
(146, 1, '400079', '发货人电话必须为数字', '发货人电话必须为数字', 1),
(147, 1, '400080', '发货人电话请填写有效的手机号', '发货人电话请填写有效的手机号', 1),
(148, 1, '400081', '发货人地址只能是汉字、字母、数字', '发货人地址只能是汉字、字母、数字', 1),
(149, 1, '400082', '发货人地址长度为10-100位', '发货人地址长度为10-100位', 1),
(150, 1, '400083', '电子面单打印机编号必须为数字、字母', '电子面单打印机编号必须为数字、字母', 1),
(151, 1, '400084', '电子面单打印机编号长度为10-50位', '电子面单打印机编号长度为10-50位', 1),
(152, 1, '400085', '客服反馈长度位10-90位', '客服反馈长度位10-90位', 1),
(153, 1, '400086', '请填写标签分类名称', '请填写标签分类名称', 1),
(154, 1, '400087', '请填写标签分类排序', '请填写标签分类排序', 1),
(155, 1, '400088', '标签分类必须为数字', '标签分类必须为数字', 1),
(156, 1, '400089', '账号只能为数字和字母', '账号只能为数字和字母', 1),
(157, 1, '400090', '限量不能超过商品库存', '限量不能超过商品库存', 1),
(158, 1, '400091', '商品已下架或移入回收站', '商品已下架或移入回收站', 1),
(159, 1, '400092', '占用库存失败', '占用库存失败', 1),
(160, 1, '400093', '商品已下架或已删除', '商品已下架或已删除', 1),
(161, 1, '400094', '请选择有效的商品属性', '请选择有效的商品属性', 1),
(162, 1, '400095', '金额不能小于0', '金额不能小于0', 1),
(163, 1, '400096', '结束时间不能小于今天', '结束时间不能小于今天', 1),
(164, 1, '400097', '您不是付费会员', '您不是付费会员', 1),
(165, 1, '400098', '暂时无法领取', '暂时无法领取', 1),
(166, 1, '400099', '请先配置小票打印开发者', '请先配置小票打印开发者', 1),
(167, 1, '400100', '请填写分类名称', '请填写分类名称', 1),
(168, 1, '400101', '该分类已存在', '该分类已存在', 1),
(169, 1, '400102', '请先删除子分类', '请先删除子分类', 1),
(170, 1, '400103', '分类不存在', '分类不存在', 1),
(171, 1, '400104', '文件名称不能为空', '文件名称不能为空', 1),
(172, 1, '400105', '该分类有下级分类，无法修改上级', '该分类有下级分类，无法修改上级', 1),
(173, 1, '400106', '备注不能为空', '备注不能为空', 1),
(174, 1, '400107', '请输入姓名', '请输入姓名', 1),
(175, 1, '400108', '请输入提现金额', '请输入提现金额', 1),
(176, 1, '400109', '请输入支付宝账号', '请输入支付宝账号', 1),
(177, 1, '400110', '请输入微信账号', '请输入微信账号', 1),
(178, 1, '400111', '请输入银行卡号', '请输入银行卡号', 1),
(179, 1, '400112', '请输入开户行', '请输入开户行', 1),
(180, 1, '400113', '拒绝理由不能为空', '拒绝理由不能为空', 1),
(181, 1, '400114', '不能重复收货', '不能重复收货', 1),
(182, 1, '400115', '请先发货或者送货', '请先发货或者送货', 1),
(183, 1, '400116', '收货失败,请稍候再试', '收货失败,请稍候再试', 1),
(184, 1, '400117', '收货成功', '收货成功', 1),
(185, 1, '400118', '订单不存在', '订单不存在', 1),
(186, 1, '400119', '用户信息不存在', '用户信息不存在', 1),
(187, 1, '400120', '快递单号不存在', '快递单号不存在', 1),
(188, 1, '400121', '打印成功', '打印成功', 1),
(189, 1, '400122', '打印失败', '打印失败', 1),
(190, 1, '400123', '快递公司编号缺失', '快递公司编号缺失', 1),
(191, 1, '400124', '请配置腾讯地图KEY', '请配置腾讯地图KEY', 1),
(192, 1, '400125', '请选择门店位置', '请选择门店位置', 1),
(193, 1, '400126', '添加的核销员用户已存在', '添加的核销员用户已存在', 1),
(194, 1, '400127', '请选择所属提货点', '请选择所属提货点', 1),
(195, 1, '400128', '请填写核销员名称', '请填写核销员名称', 1),
(196, 1, '400129', '请填写核销员电话', '请填写核销员电话', 1),
(197, 1, '400130', '核销员添加成功', '核销员添加成功', 1),
(198, 1, '400131', '核销员添加失败', '核销员添加失败', 1),
(199, 1, '400132', '请填写手机号', '请填写手机号', 1),
(200, 1, '400133', '请填写账号', '请填写账号', 1),
(201, 1, '400134', '请填写密码', '请填写密码', 1),
(202, 1, '400135', '请填写短信签名', '请填写短信签名', 1),
(203, 1, '400136', '短信签名最长为8位', '短信签名最长为8位', 1),
(204, 1, '400137', '请填写验证码', '请填写验证码', 1),
(205, 1, '400138', '请填写域名', '请填写域名', 1),
(206, 1, '400139', '登录成功', '登录成功', 1),
(207, 1, '400140', '账号或密码错误', '账号或密码错误', 1),
(208, 1, '400141', '请先填写短信配置', '请先填写短信配置', 1),
(209, 1, '400142', '请输入模板名称', '请输入模板名称', 1),
(210, 1, '400143', '请输入模板内容', '请输入模板内容', 1),
(211, 1, '400144', '售后订单状态不支持该操作', '售后订单状态不支持该操作', 1),
(212, 1, '400145', '修改退款状态成功', '修改退款状态成功', 1),
(213, 1, '400146', '请输入退款金额', '请输入退款金额', 1),
(214, 1, '400147', '已退完支付金额，不能再退款了', '已退完支付金额，不能再退款了', 1),
(215, 1, '400148', '退款金额大于支付金额，请修改退款金额', '退款金额大于支付金额，请修改退款金额', 1),
(216, 1, '400149', '退款成功', '退款成功', 1),
(217, 1, '400150', '退款失败', '退款失败', 1),
(218, 1, '400151', '验证成功', '验证成功', 1),
(219, 1, '400152', '核销成功', '核销成功', 1),
(220, 1, '400153', '核销订单未查到', '核销订单未查到', 1),
(221, 1, '400154', '核销失败', '核销失败', 1),
(222, 1, '400155', '订单金额必须填写', '订单金额必须填写', 1),
(223, 1, '400156', '请选择需要删除的订单', '请选择需要删除的订单', 1),
(224, 1, '400157', '您选择的的订单存在用户未删除的订单', '您选择的的订单存在用户未删除的订单', 1),
(225, 1, '400158', '请选择发货商品', '请选择发货商品', 1),
(226, 1, '400159', '请重新选择发货商品或发货件数', '请重新选择发货商品或发货件数', 1),
(227, 1, '400160', '订单已删除无法退积分', '订单已删除无法退积分', 1),
(228, 1, '400161', '请输入积分', '请输入积分', 1),
(229, 1, '400162', '已退完积分', '已退完积分', 1),
(230, 1, '400163', '退积分大于支付积分，请修改退积分', '退积分大于支付积分，请修改退积分', 1),
(231, 1, '400164', '退积分成功', '退积分成功', 1),
(232, 1, '400165', '退积分失败', '退积分失败', 1),
(233, 1, '400166', '请填写开票号', '请填写开票号', 1),
(234, 1, '400167', '请填写正确的开票号', '请填写正确的开票号', 1),
(235, 1, '400168', '请上传文件', '请上传文件', 1),
(236, 1, '400169', '回复成功', '回复成功', 1),
(237, 1, '400170', '注册成功', '注册成功', 1),
(238, 1, '400171', '注册失败', '注册失败', 1),
(239, 1, '400172', '登录失败', '登录失败', 1),
(240, 1, '400173', '获取套餐列表失败', '获取套餐列表失败', 1),
(241, 1, '400174', '获取支付码失败', '获取支付码失败', 1),
(242, 1, '400175', '请先开通短信服务', '请先开通短信服务', 1),
(243, 1, '400176', '请先开通物流查询服务', '请先开通物流查询服务', 1),
(244, 1, '400177', '请先开通电子面单打印服务', '请先开通电子面单打印服务', 1),
(245, 1, '400178', '请先开通商品采集服务', '请先开通商品采集服务', 1),
(246, 1, '400179', '请设置短信签名', '请设置短信签名', 1),
(247, 1, '400180', '修改短信签名成功', '修改短信签名成功', 1),
(248, 1, '400181', '默认模板不能删除', '默认模板不能删除', 1),
(249, 1, '400182', '管理员信息读取失败', '管理员信息读取失败', 1),
(250, 1, '400183', '密码太过简单，请输入较为复杂的密码', '密码太过简单，请输入较为复杂的密码', 1),
(251, 1, '400184', '协议类型不存在', '协议类型不存在', 1),
(252, 1, '400185', '清除成功', '清除成功', 1),
(253, 1, '400186', '清除失败', '清除失败', 1),
(254, 1, '400187', '请输入名称', '请输入名称', 1),
(255, 1, '400188', '请不要重复添加', '请不要重复添加', 1),
(256, 1, '400189', '添加数据成功', '添加数据成功', 1),
(257, 1, '400190', '请输入开始时间', '请输入开始时间', 1),
(258, 1, '400191', '请输入持续时间', '请输入持续时间', 1),
(259, 1, '400192', '请输入0-23点之前的整点数', '请输入0-23点之前的整点数', 1),
(260, 1, '400193', '请输入1-24点之前的整点数', '请输入1-24点之前的整点数', 1),
(261, 1, '400194', '开始时间+持续时间不能大于24小时', '开始时间+持续时间不能大于24小时', 1),
(262, 1, '400195', '时段已占用', '时段已占用', 1),
(263, 1, '400196', '请输入签到赠送积分', '请输入签到赠送积分', 1),
(264, 1, '400197', '请输入大于等于0的整数', '请输入大于等于0的整数', 1),
(265, 1, '400198', '请填写按钮名称', '请填写按钮名称', 1),
(266, 1, '400199', '没有查到此身份', '没有查到此身份', 1),
(267, 1, '400200', '请输入等级名称', '请输入等级名称', 1),
(268, 1, '400201', '请输入等级', '请输入等级', 1),
(269, 1, '400202', '请选择等级图标', '请选择等级图标', 1),
(270, 1, '400203', '二级返佣比例不能大于一级', '二级返佣比例不能大于一级', 1),
(271, 1, '400204', '当前等级已存在', '当前等级已存在', 1),
(272, 1, '400205', '添加等级成功', '添加等级成功', 1),
(273, 1, '400206', '编辑的等级不存在', '编辑的等级不存在', 1),
(274, 1, '400207', '请输入任务名称', '请输入任务名称', 1),
(275, 1, '400208', '请选择任务类型', '请选择任务类型', 1),
(276, 1, '400209', '请输入限定数量', '请输入限定数量', 1),
(277, 1, '400210', '添加任务成功', '添加任务成功', 1),
(278, 1, '400211', '编辑的任务不存在', '编辑的任务不存在', 1),
(279, 1, '400212', '获取推广二维码失败，请检查您的微信配置', '获取推广二维码失败，请检查您的微信配置', 1),
(280, 1, '400213', '上级推广人不能为自己', '上级推广人不能为自己', 1),
(281, 1, '400214', '用户不存在', '用户不存在', 1),
(282, 1, '400215', '上级用户不存在', '上级用户不存在', 1),
(283, 1, '400216', '当前推广人已经是所选人', '当前推广人已经是所选人', 1),
(284, 1, '400217', '上级推广人不能为自己下级', '上级推广人不能为自己下级', 1),
(285, 1, '400218', '赠送成功', '赠送成功', 1),
(286, 1, '400219', '赠送失败', '赠送失败', 1),
(287, 1, '400220', '请输入身份名称', '请输入身份名称', 1),
(288, 1, '400221', '请选择最少一个权限', '请选择最少一个权限', 1),
(289, 1, '400222', '添加身份成功', '添加身份成功', 1),
(290, 1, '400223', '添加身份失败', '添加身份失败', 1),
(291, 1, '400224', '缺少APPID', '缺少APPID', 1),
(292, 1, '400225', '请先设置空间域名', '请先设置空间域名', 1),
(293, 1, '400226', '格式错误，请输入格式为：http://域名', '格式错误，请输入格式为：http://域名', 1),
(294, 1, '400227', '未有正在使用的存储空间', '未有正在使用的存储空间', 1),
(295, 1, '400228', '切换云存储成功,请检查是否开启使用了存储空间', '切换云存储成功,请检查是否开启使用了存储空间', 1),
(296, 1, '400229', '切换本地存储成功', '切换本地存储成功', 1),
(297, 1, '400230', '请输入模板编号', '请输入模板编号', 1),
(298, 1, '400231', '请输入模板编号已存在,请重新输入', '请输入模板编号已存在,请重新输入', 1),
(299, 1, '400232', '请输入模板ID', '请输入模板ID', 1),
(300, 1, '400233', '请输入模板名', '请输入模板名', 1),
(301, 1, '400234', '请输入回复内容', '请输入回复内容', 1),
(302, 1, '400235', '添加模板消息成功', '添加模板消息成功', 1),
(303, 1, '400236', '请先配置小程序appid、appSecret等参数', '请先配置小程序appid、appSecret等参数', 1),
(304, 1, '400237', '二维码生成失败', '二维码生成失败', 1),
(305, 1, '400238', '请添加至少一个按钮', '请添加至少一个按钮', 1),
(306, 1, '400239', '请输入关键字', '请输入关键字', 1),
(307, 1, '400240', '请选择回复类型', '请选择回复类型', 1),
(308, 1, '400241', '回复类型有误', '回复类型有误', 1),
(309, 1, '400242', '回复消息参数有误', '回复消息参数有误', 1),
(310, 1, '400243', '请添加图文', '请添加图文', 1),
(311, 1, '400244', '标题不能为空', '标题不能为空', 1),
(312, 1, '400245', '作者不能为空', '作者不能为空', 1),
(313, 1, '400246', '正文不能为空', '正文不能为空', 1),
(314, 1, '400247', '摘要不能为空', '摘要不能为空', 1),
(315, 1, '400248', '请先配置微信公众号appid、appSecret等参数', '请先配置微信公众号appid、appSecret等参数', 1),
(316, 1, '400249', '模版消息一键设置成功', '模版消息一键设置成功', 1),
(317, 1, '400250', '请选择用户', '请选择用户', 1),
(318, 1, '400251', '该用户没有绑定手机号，请手动填写', '该用户没有绑定手机号，请手动填写', 1),
(319, 1, '400252', '手机号格式错误', '手机号格式错误', 1),
(320, 1, '400253', '客服已存在', '客服已存在', 1),
(321, 1, '400254', '请输入账号', '请输入账号', 1),
(322, 1, '400255', '账号必须为数字或者字母的组合4-30位', '账号必须为数字或者字母的组合4-30位', 1),
(323, 1, '400256', '请输入密码', '请输入密码', 1),
(324, 1, '400257', '密码必须为数字或者字母的组合6-20位', '密码必须为数字或者字母的组合6-20位', 1),
(325, 1, '400258', '该手机号的客服已存在', '该手机号的客服已存在', 1),
(326, 1, '400259', '该客服账号已存在', '该客服账号已存在', 1),
(327, 1, '400260', '客服添加成功', '客服添加成功', 1),
(328, 1, '400261', '客服添加失败', '客服添加失败', 1),
(329, 1, '400262', '客服名称不能为空', '客服名称不能为空', 1),
(330, 1, '400263', '请输入确认密码', '请输入确认密码', 1),
(331, 1, '400264', '两次输入的密码不一致', '两次输入的密码不一致', 1),
(332, 1, '400265', '用户不存在，客服将强制禁止登录', '用户不存在，客服将强制禁止登录', 1),
(333, 1, '400266', '登录的客服不存在', '登录的客服不存在', 1),
(334, 1, '400267', '请先填写客服账号和密码再尝试进入客服平台', '请先填写客服账号和密码再尝试进入客服平台', 1),
(335, 1, '400268', '反馈内容不存在', '反馈内容不存在', 1),
(336, 1, '400269', '话术不能重复添加', '话术不能重复添加', 1),
(337, 1, '400270', '创建话术成功', '创建话术成功', 1),
(338, 1, '400271', '创建话术失败', '创建话术失败', 1),
(339, 1, '400272', '删除的话术不存在', '删除的话术不存在', 1),
(340, 1, '400273', '系统分类不能删除', '系统分类不能删除', 1),
(341, 1, '400274', '请输入配置名称', '请输入配置名称', 1),
(342, 1, '400275', '请输入字段名称', '请输入字段名称', 1),
(343, 1, '400276', '请输入配置简介', '请输入配置简介', 1),
(344, 1, '400277', '请输入文本框的宽度', '请输入文本框的宽度', 1),
(345, 1, '400278', '请输入正确的文本框的宽度', '请输入正确的文本框的宽度', 1),
(346, 1, '400279', '请输入多行文本框的宽度', '请输入多行文本框的宽度', 1),
(347, 1, '400280', '请输入多行文本框的高度', '请输入多行文本框的高度', 1),
(348, 1, '400281', '请输入正确的多行文本框的宽度', '请输入正确的多行文本框的宽度', 1),
(349, 1, '400282', '请输入正确的多行文本框的宽度', '请输入正确的多行文本框的宽度', 1),
(350, 1, '400283', '请输入配置参数', '请输入配置参数', 1),
(351, 1, '400284', '添加配置成功', '添加配置成功', 1),
(352, 1, '400285', '一二级返佣比例不能大于100%', '一二级返佣比例不能大于100%', 1),
(353, 1, '400286', '分销海报不能多于5张', '分销海报不能多于5张', 1),
(354, 1, '400287', '提现最低金额只能为数字', '提现最低金额只能为数字', 1),
(355, 1, '400288', '满额分销最低金额不能为空', '满额分销最低金额不能为空', 1),
(356, 1, '400289', '满额分销最低金额不能小于0', '满额分销最低金额不能小于0', 1),
(357, 1, '400290', '绑定有效期请填写正整数', '绑定有效期请填写正整数', 1),
(358, 1, '400291', '请输入标题', '请输入标题', 1),
(359, 1, '400292', '添加配置分类成功', '添加配置分类成功', 1),
(360, 1, '400293', '存在下级配置，无法删除', '存在下级配置，无法删除', 1),
(361, 1, '400294', '字段至少存在一个', '字段至少存在一个', 1),
(362, 1, '400295', '添加数据组成功', '添加数据组成功', 1),
(363, 1, '400296', '数据关键字已存在', '数据关键字已存在', 1),
(364, 1, '400297', '字段不能为空', '字段不能为空', 1),
(365, 1, '400298', '不能大于四个', '不能大于四个', 1),
(366, 1, '400299', '签到天数配置不能大于7天', '签到天数配置不能大于7天', 1),
(367, 1, '400300', '关联成功', '关联成功', 1),
(368, 1, '400301', '关联失败', '关联失败', 1),
(369, 1, '400302', '数据缓存刷新成功', '数据缓存刷新成功', 1),
(370, 1, '400303', '数据缓存刷新失败', '数据缓存刷新失败', 1),
(371, 1, '400304', '请输入需要更换的域名', '请输入需要更换的域名', 1),
(372, 1, '400305', '域名不合法', '域名不合法', 1),
(373, 1, '400306', '替换成功', '替换成功', 1),
(374, 1, '400307', '初始化完成', '初始化完成', 1),
(375, 1, '400308', '备份文件可能已经损坏，请检查', '备份文件可能已经损坏，请检查', 1),
(376, 1, '400309', '还原数据出错', '还原数据出错', 1),
(377, 1, '400310', '正在还原...', '正在还原...', 1),
(378, 1, '400311', '还原完成', '还原完成', 1),
(379, 1, '400312', '权益编辑成功', '权益编辑成功', 1),
(380, 1, '400313', '卡片生成成功', '卡片生成成功', 1),
(381, 1, '400314', '手机号已经存在', '手机号已经存在', 1),
(382, 1, '400315', '请输入正确的身份证', '请输入正确的身份证', 1),
(383, 1, '400316', '请选择分组', '请选择分组', 1),
(384, 1, '400317', '请选择标签', '请选择标签', 1),
(385, 1, '400318', '加入消息队列成功', '加入消息队列成功', 1),
(386, 1, '400319', '注销成功', '注销成功', 1),
(387, 1, '400320', '拒绝注销', '拒绝注销', 1),
(388, 1, '400321', '请输入分组名称', '请输入分组名称', 1),
(389, 1, '400322', '会员标签不能为空', '会员标签不能为空', 1),
(390, 1, '400323', '该分类下有标签，请先删除标签', '该分类下有标签，请先删除标签', 1),
(391, 1, '400324', '请输入等级名称', '请输入等级名称', 1),
(392, 1, '400325', '请输入等级', '请输入等级', 1),
(393, 1, '400326', '请输入等级说明', '请输入等级说明', 1),
(394, 1, '400327', '请上传等级图标', '请上传等级图标', 1),
(395, 1, '400328', '请上传等级背景图标', '请上传等级背景图标', 1),
(396, 1, '400329', '请输入升级经验值', '请输入升级经验值', 1),
(397, 1, '400330', '授权成功，写入数据库失败，请检查数据库链接配置', '授权成功，写入数据库失败，请检查数据库链接配置', 1),
(398, 1, '400331', '请填写公司名称', '请填写公司名称', 1),
(399, 1, '400332', '请填写授权域名', '请填写授权域名', 1),
(400, 1, '400333', '请填写手机号码', '请填写手机号码', 1),
(401, 1, '400334', '请填写订单id', '请填写订单id', 1),
(402, 1, '400335', '申请授权成功', '申请授权成功', 1),
(403, 1, '400336', '验证码错误', '验证码错误', 1),
(404, 1, '400337', '请选择商品', '请选择商品', 1),
(405, 1, '400338', '请输入商品名称', '请输入商品名称', 1),
(406, 1, '400339', '请选择背景图', '请选择背景图', 1),
(407, 1, '400340', '请输入直播价格', '请输入直播价格', 1),
(408, 1, '400341', '直播价格必须大于0', '直播价格必须大于0', 1),
(409, 1, '400342', '请输入直播间名称', '请输入直播间名称', 1),
(410, 1, '400343', '请选择背景图', '请选择背景图', 1),
(411, 1, '400344', '请选择分享图', '请选择分享图', 1),
(412, 1, '400345', '请选择主播', '请选择主播', 1),
(413, 1, '400346', '请选择直播开始、结束时间', '请选择直播开始、结束时间', 1),
(414, 1, '400347', '请填写活动简介', '请填写活动简介', 1),
(415, 1, '400348', '请填写单位', '请填写单位', 1),
(416, 1, '400349', '请选择商品轮播图', '请选择商品轮播图', 1),
(417, 1, '400350', '您设置得商品个数超出系统限制', '您设置得商品个数超出系统限制', 1),
(418, 1, '400351', '模板不存在', '模板不存在', 1),
(419, 1, '400352', '请输入页面名称', '请输入页面名称', 1),
(420, 1, '400353', '请选择活动时间段', '请选择活动时间段', 1),
(421, 1, '400354', '请填写购买数量限制', '请填写购买数量限制', 1),
(422, 1, '400355', '购买数量限制必须大于0', '购买数量限制必须大于0', 1),
(423, 1, '400356', '请填写帮砍次数', '请填写帮砍次数', 1),
(424, 1, '400357', '帮砍次数必须大于0', '帮砍次数必须大于0', 1),
(425, 1, '400358', '请填写砍价人数', '请填写砍价人数', 1),
(426, 1, '400359', '砍价人数必须大于1', '砍价人数必须大于1', 1),
(427, 1, '400360', '请选择运费模板', '请选择运费模板', 1),
(428, 1, '400361', '请填写商品详情', '请填写商品详情', 1),
(429, 1, '400362', '请选择规格', '请选择规格', 1),
(430, 1, '400363', '请填写虚拟拼团比例', '请填写虚拟拼团比例', 1),
(431, 1, '400364', '虚拟参团人数不能大于成团人数', '虚拟参团人数不能大于成团人数', 1),
(432, 1, '400365', '虚拟参团人数不能大于成团人数', '虚拟参团人数不能大于成团人数', 1),
(433, 1, '400366', '请填写单次购买数量', '请填写单次购买数量', 1),
(434, 1, '400367', '单次购买数量必须大于0', '单次购买数量必须大于0', 1),
(435, 1, '400368', '请填写成团人数', '请填写成团人数', 1),
(436, 1, '400369', '拼团人数不能小于2人', '拼团人数不能小于2人', 1),
(437, 1, '400370', '请填写成团有效期', '请填写成团有效期', 1),
(438, 1, '400371', '成团有效期必须大于0', '成团有效期必须大于0', 1),
(439, 1, '400372', '请填写优惠券名称', '请填写优惠券名称', 1),
(440, 1, '400373', '请选择商品分类', '请选择商品分类', 1),
(441, 1, '400374', '请填写优惠券金额', '请填写优惠券金额', 1),
(442, 1, '400375', '请填写优惠券最小使用金额', '请填写优惠券最小使用金额', 1),
(443, 1, '400376', '请填写优惠券有效期', '请填写优惠券有效期', 1),
(444, 1, '400377', '请选择秒杀时间段', '请选择秒杀时间段', 1),
(445, 1, '400378', '请填写门店名称', '请填写门店名称', 1),
(446, 1, '400379', '请填写门店简介', '请填写门店简介', 1),
(447, 1, '400380', '请填写门店电话', '请填写门店电话', 1),
(448, 1, '400381', '请选择提货点logo', '请选择提货点logo', 1),
(449, 1, '400382', '请选择提货点大图', '请选择提货点大图', 1),
(450, 1, '400383', '请选择地址', '请选择地址', 1),
(451, 1, '400384', '请填写详细地址', '请填写详细地址', 1),
(452, 1, '400385', '请选择经纬度', '请选择经纬度', 1),
(453, 1, '400386', '请选择营业时间', '请选择营业时间', 1),
(454, 1, '400387', '短信账号必须填写', '短信账号必须填写', 1),
(455, 1, '400388', '短信密码必须填写', '短信密码必须填写', 1),
(456, 1, '400389', '订单号必须存在', '订单号必须存在', 1),
(457, 1, '400390', '订单号有误', '订单号有误', 1),
(458, 1, '400391', '订单号必须为字母和数字', '订单号必须为字母和数字', 1),
(459, 1, '400392', '订单金额必须填写', '订单金额必须填写', 1),
(460, 1, '400393', '订单金额必须为数字', '订单金额必须为数字', 1),
(461, 1, '400394', '订单金额必须填写', '订单金额必须填写', 1),
(462, 1, '400395', '订单金额必须为数字', '订单金额必须为数字', 1),
(463, 1, '400396', '订单邮费必须填写', '订单邮费必须填写', 1),
(464, 1, '400397', '订单邮费必须为数字', '订单邮费必须为数字', 1),
(465, 1, '400398', '赠送积分必须为数字', '赠送积分必须为数字', 1),
(466, 1, '400399', '请选择用户头像', '请选择用户头像', 1),
(467, 1, '400400', '请输入公司名称', '请输入公司名称', 1),
(468, 1, '400401', '添加公司成功', '添加公司成功', 1),
(469, 1, '400402', '请输入月结账号', '请输入月结账号', 1),
(470, 1, '400403', '请输入月结密码', '请输入月结密码', 1),
(471, 1, '400404', '请输入取件网点', '请输入取件网点', 1),
(472, 1, '400405', '缩略图大图尺寸（高）必须为数字', '缩略图大图尺寸（高）必须为数字', 1),
(473, 1, '400406', '缩略图大图尺寸（高）必须大于等于0', '缩略图大图尺寸（高）必须大于等于0', 1),
(474, 1, '400407', '缩略图大图尺寸（宽）必须为数字', '缩略图大图尺寸（宽）必须为数字', 1),
(475, 1, '400408', '缩略图大图尺寸（宽）必须大于等于0', '缩略图大图尺寸（宽）必须大于等于0', 1),
(476, 1, '400409', '缩略图中图尺寸（高）必须为数字', '缩略图中图尺寸（高）必须为数字', 1),
(477, 1, '400410', '缩略图中图尺寸（高）必须大于等于0', '缩略图中图尺寸（高）必须大于等于0', 1),
(478, 1, '400411', '缩略图中图尺寸（宽）必须为数字', '缩略图中图尺寸（宽）必须为数字', 1),
(479, 1, '400412', '缩略图中图尺寸（宽）必须大于等于0', '缩略图中图尺寸（宽）必须大于等于0', 1),
(480, 1, '400413', '缩略图小图尺寸（高）必须为数字', '缩略图小图尺寸（高）必须为数字', 1),
(481, 1, '400414', '缩略图小图尺寸（高）必须大于等于0', '缩略图小图尺寸（高）必须大于等于0', 1),
(482, 1, '400415', '缩略图小图尺寸（宽）必须为数字', '缩略图小图尺寸（宽）必须为数字', 1),
(483, 1, '400416', '缩略图小图尺寸（宽）必须大于等于0', '缩略图小图尺寸（宽）必须大于等于0', 1),
(484, 1, '400417', '水印文字只能是汉字、字母、数字', '水印文字只能是汉字、字母、数字', 1),
(485, 1, '400418', '水印文字长度为1-10位', '水印文字长度为1-10位', 1),
(486, 1, '400419', '水印文字大小必须为数字', '水印文字大小必须为数字', 1),
(487, 1, '400420', '水印文字大小必须大于等于0', '水印文字大小必须大于等于0', 1),
(488, 1, '400421', '水印横坐标偏移量必须为数字', '水印横坐标偏移量必须为数字', 1),
(489, 1, '400422', '水印横坐标偏移量必须大于等于0', '水印横坐标偏移量必须大于等于0', 1),
(490, 1, '400423', '水印纵坐标偏移量必须为数字', '水印纵坐标偏移量必须为数字', 1),
(491, 1, '400424', '水印纵坐标偏移量必须大于等于0', '水印纵坐标偏移量必须大于等于0', 1),
(492, 1, '400425', '该主播已经存在', '该主播已经存在', 1),
(493, 1, '400426', '请先去小程序认证主播', '请先去小程序认证主播', 1),
(494, 1, '400427', '商品已创建', '商品已创建', 1),
(495, 1, '400428', '审核中或审核失败不允许此操作', '审核中或审核失败不允许此操作', 1),
(496, 1, '400429', '在审核中或已经审核通过', '在审核中或已经审核通过', 1),
(497, 1, '400430', '审核通过或失败', '审核通过或失败', 1),
(498, 1, '400431', '商品审核中，无法删除', '商品审核中，无法删除', 1),
(499, 1, '400432', '该主播不存在', '该主播不存在', 1),
(500, 1, '400433', '开播时间需要在当前时间的10分钟后，并且开始时间不能在6个月后', '开播时间需要在当前时间的10分钟后，并且开始时间不能在6个月后', 1),
(501, 1, '400434', '开播时间和结束时间间隔不得短于30分钟，不得超过24小时', '开播时间和结束时间间隔不得短于30分钟，不得超过24小时', 1),
(502, 1, '400435', '请输入理由', '请输入理由', 1),
(503, 1, '400436', '请选择正确的直播商品', '请选择正确的直播商品', 1),
(504, 1, '400437', '直播间状态有误', '直播间状态有误', 1),
(505, 1, '400438', '奖品不存在', '奖品不存在', 1),
(506, 1, '400439', '写入中奖记录失败', '写入中奖记录失败', 1),
(507, 1, '400440', '请继续参与活动抽奖', '请继续参与活动抽奖', 1),
(508, 1, '400441', '已经领取成功', '已经领取成功', 1),
(509, 1, '400442', '分销等级不存在', '分销等级不存在', 1),
(510, 1, '400443', '选择的等级不存在', '选择的等级不存在', 1),
(511, 1, '400444', '该等级已存在此类型任务', '该等级已存在此类型任务', 1),
(512, 1, '400445', '不能小于低等级同类型任务限定数量', '不能小于低等级同类型任务限定数量', 1),
(513, 1, '400446', '不能大于高等级同类型任务限定数量', '不能大于高等级同类型任务限定数量', 1),
(514, 1, '400447', '解除失败', '解除失败', 1),
(515, 1, '400448', '代理商佣金比例不能大于事业部佣金比例', '代理商佣金比例不能大于事业部佣金比例', 1),
(516, 1, '400449', '代理商到期时间不能大于事业部到期时间', '代理商到期时间不能大于事业部到期时间', 1),
(517, 1, '400450', '请填写用户UID', '请填写用户UID', 1),
(518, 1, '400451', '管理员信息未查到', '管理员信息未查到', 1),
(519, 1, '400452', '管理员已经删除', '管理员已经删除', 1),
(520, 1, '400453', '管理员姓名不能为空', '管理员姓名不能为空', 1),
(521, 1, '400454', '该分类有下级分类，无法删除', '该分类有下级分类，无法删除', 1),
(522, 1, '400455', '该分类下有文章，无法删除', '该分类下有文章，无法删除', 1),
(523, 1, '400456', '请稍后查看', '请稍后查看', 1),
(524, 1, '400457', '默认模板不能删除', '默认模板不能删除', 1),
(525, 1, '400458', '该模板使用中，无法删除', '该模板使用中，无法删除', 1),
(526, 1, '400459', '个人中心模板不存在', '个人中心模板不存在', 1),
(527, 1, '400460', '反馈内容没有查到', '反馈内容没有查到', 1),
(528, 1, '400461', '您修改的话术内容不存在', '您修改的话术内容不存在', 1),
(529, 1, '400462', '短信平台：{:msg}', '短信平台：{:msg}', 1),
(530, 1, '400463', '订单商品获取失败,无法打印', '订单商品获取失败,无法打印', 1),
(531, 1, '400464', '小票打印未开启', '小票打印未开启', 1),
(532, 1, '400465', '请先配置小票打印开发者', '请先配置小票打印开发者', 1),
(533, 1, '400466', '请选择图片', '请选择图片', 1),
(534, 1, '400467', '配送员已存在', '配送员已存在', 1),
(535, 1, '400468', '同一个手机号的配送员只能添加一个', '同一个手机号的配送员只能添加一个', 1),
(536, 1, '400469', '配送员名称不能为空', '配送员名称不能为空', 1),
(537, 1, '400470', '订单未能查到,不能发货', '订单未能查到,不能发货', 1),
(538, 1, '400471', '订单已删除,不能发货', '订单已删除,不能发货', 1),
(539, 1, '400472', '订单已发货请勿重复操作', '订单已发货请勿重复操作', 1),
(540, 1, '400473', '核销订单不能发货', '核销订单不能发货', 1),
(541, 1, '400474', '拼团未完成暂不能发货', '拼团未完成暂不能发货', 1),
(542, 1, '400475', '订单有售后申请请先处理', '订单有售后申请请先处理', 1),
(543, 1, '400476', '快递公司编缺失', '快递公司编缺失', 1),
(544, 1, '400477', '请填写寄件人电话', '请填写寄件人电话', 1),
(545, 1, '400478', '请填写寄件人地址', '请填写寄件人地址', 1),
(546, 1, '400479', '虚拟发货，无需修改发货信息', '虚拟发货，无需修改发货信息', 1),
(547, 1, '400480', '未发货，请先发货再修改配送信息', '未发货，请先发货再修改配送信息', 1),
(548, 1, '400481', '自提订单无法打印', '自提订单无法打印', 1),
(549, 1, '400482', '请先发货', '请先发货', 1),
(550, 1, '400483', '请先在系统设置中打开单子面单打印开关', '请先在系统设置中打开单子面单打印开关', 1),
(551, 1, '400484', '发票已申请，正在审核打印中', '发票已申请，正在审核打印中', 1),
(552, 1, '400485', '订单已退款', '订单已退款', 1),
(553, 1, '400486', '正在申请退款中', '正在申请退款中', 1),
(554, 1, '400487', '申请失败', '申请失败', 1),
(555, 1, '400488', '未支付无法退款', '未支付无法退款', 1),
(556, 1, '400489', '回退积分和优惠券失败', '回退积分和优惠券失败', 1),
(557, 1, '400490', '拼团修改失败', '拼团修改失败', 1),
(558, 1, '400491', '回退佣金失败', '回退佣金失败', 1),
(559, 1, '400492', '余额退款失败', '余额退款失败', 1),
(560, 1, '400493', '购买的优惠券已使用或者已过期', '购买的优惠券已使用或者已过期', 1),
(561, 1, '400494', '回退积分增加失败', '回退积分增加失败', 1),
(562, 1, '400495', '售后订单不存在', '售后订单不存在', 1),
(563, 1, '400496', '积分已退或者积分为零无法再退', '积分已退或者积分为零无法再退', 1),
(564, 1, '400497', '未支付无法退积分', '未支付无法退积分', 1),
(565, 1, '400498', '订单退积分失败', '订单退积分失败', 1),
(566, 1, '400499', '请输入拒绝退款理由', '请输入拒绝退款理由', 1),
(567, 1, '400500', '限制单次购买数量不能大于总购买数量', '限制单次购买数量不能大于总购买数量', 1),
(568, 1, '400501', '请添加抽奖活动名称', '请添加抽奖活动名称', 1),
(569, 1, '400502', '请添加抽奖描述等文案', '请添加抽奖描述等文案', 1),
(570, 1, '400503', '活动结束时间必须大于开始时间', '活动结束时间必须大于开始时间', 1),
(571, 1, '400504', '请添加奖品', '请添加奖品', 1),
(572, 1, '400505', '请填写消耗数量', '请填写消耗数量', 1),
(573, 1, '400506', '商品参与其他活动开启，无法开启预售', '商品参与其他活动开启，无法开启预售', 1),
(574, 1, '400507', '活动结束时间不能小于当前时间', '活动结束时间不能小于当前时间', 1),
(575, 1, '400508', '活动已结束,请重新添加或复制', '活动已结束,请重新添加或复制', 1),
(576, 1, '400509', '添加优惠券成功', '添加优惠券成功', 1),
(577, 1, '400510', '发布优惠劵成功', '发布优惠劵成功', 1),
(578, 1, '400511', '砍价最低价不能大于或等于起始金额', '砍价最低价不能大于或等于起始金额', 1),
(579, 1, '400512', '砍价人数不能大于{:num}人', '砍价人数不能大于{:num}人', 1),
(580, 1, '400513', '使用开始时间不能小于领取开始时间', '使用开始时间不能小于领取开始时间', 1),
(581, 1, '400514', '使用结束时间不能小于领取结束时间', '使用结束时间不能小于领取结束时间', 1),
(582, 1, '400515', '优惠券不存在', '优惠券不存在', 1),
(583, 1, '400516', '领取的优惠劵已领完或已过期', '领取的优惠劵已领完或已过期', 1),
(584, 1, '400517', '已领取过该优惠劵', '已领取过该优惠劵', 1),
(585, 1, '400518', '抱歉，优惠券已经领取完了', '抱歉，优惠券已经领取完了', 1),
(586, 1, '400519', '选择用户已拥有该优惠券，请勿重复发放', '选择用户已拥有该优惠券，请勿重复发放', 1),
(587, 1, '400520', '订单已删除', '订单已删除', 1),
(588, 1, '400521', '订单已发货', '订单已发货', 1),
(589, 1, '400522', '暂时不支持其他发货类型', '暂时不支持其他发货类型', 1),
(590, 1, '400523', '请输入送货人姓名', '请输入送货人姓名', 1),
(591, 1, '400524', '请输入送货人电话号码', '请输入送货人电话号码', 1),
(592, 1, '400525', '请输入送货人信息', '请输入送货人信息', 1),
(593, 1, '400526', '请输入正确的送货人电话号码', '请输入正确的送货人电话号码', 1),
(594, 1, '400527', '请选择电子面单模板', '请选择电子面单模板', 1),
(595, 1, '400528', '电子面单已关闭，请选择其他发货方式', '电子面单已关闭，请选择其他发货方式', 1),
(596, 1, '400529', '发货失败', '发货失败', 1),
(597, 1, '400530', '订单状态错误', '订单状态错误', 1),
(598, 1, '400531', '请输入快递单号', '请输入快递单号', 1),
(599, 1, '400532', '请先发货再修改配送信息', '请先发货再修改配送信息', 1),
(600, 1, '400533', '商品不存在', '商品不存在', 1),
(601, 1, '400534', '您查看的积分商品已被删除', '您查看的积分商品已被删除', 1),
(602, 1, '400535', '请添加商品', '请添加商品', 1),
(603, 1, '400536', '添加抽奖活动失败', '添加抽奖活动失败', 1),
(604, 1, '400537', '抽奖活动不存在', '抽奖活动不存在', 1),
(605, 1, '400538', '请填写奖品名称', '请填写奖品名称', 1),
(606, 1, '400539', '请选择奖品图片', '请选择奖品图片', 1),
(607, 1, '400540', '请填写奖品中奖权重', '请填写奖品中奖权重', 1),
(608, 1, '400541', '请选择奖品类型', '请选择奖品类型', 1),
(609, 1, '400542', '请填写奖品赠送{:type}数', '请填写奖品赠送{:type}数', 1),
(610, 1, '400543', '请选择优惠券', '请选择优惠券', 1),
(611, 1, '400544', '生成新订单失败', '生成新订单失败', 1),
(612, 1, '400545', '修改原来订单商品拆分状态失败', '修改原来订单商品拆分状态失败', 1),
(613, 1, '400546', '新增拆分订单商品信息失败', '新增拆分订单商品信息失败', 1),
(614, 1, '400547', '保存新订单商品信息失败', '保存新订单商品信息失败', 1),
(615, 1, '400548', '协议类型缺失', '协议类型缺失', 1),
(616, 1, '400549', '请填写协议名称', '请填写协议名称', 1),
(617, 1, '400550', '请填写协议内容', '请填写协议内容', 1),
(618, 1, '400551', '该类型协议已经存在', '该类型协议已经存在', 1),
(619, 1, '400552', '临时二维码获取错误', '临时二维码获取错误', 1),
(620, 1, '400553', '永久二维码获取错误', '永久二维码获取错误', 1),
(621, 1, '400554', '请先配置接口密钥', '请先配置接口密钥', 1),
(622, 1, '400555', '无法创建文件夹，请检查您的上传目录权限', '无法创建文件夹，请检查您的上传目录权限', 1),
(623, 1, '400556', '商品参数错误', '商品参数错误', 1),
(624, 1, '400557', '上传方式错误', '上传方式错误', 1),
(625, 1, '400558', '格式错误', '格式错误', 1),
(626, 1, '400559', '图片流获取失败', '图片流获取失败', 1),
(627, 1, '400560', '商品详情保存失败', '商品详情保存失败', 1),
(628, 1, '400561', '关联优惠券失败', '关联优惠券失败', 1),
(629, 1, '400562', '缺少商品ID', '缺少商品ID', 1),
(630, 1, '400563', '缺少用户UID', '缺少用户UID', 1),
(631, 1, '400564', '缺少订单ID', '缺少订单ID', 1),
(632, 1, '400565', '暂不支持该类型记录', '暂不支持该类型记录', 1),
(633, 1, '400566', '添加商品记录失败', '添加商品记录失败', 1),
(634, 1, '400567', '评论时间应小于当前时间', '评论时间应小于当前时间', 1),
(635, 1, '400568', '添加虚拟评论失败', '添加虚拟评论失败', 1),
(636, 1, '400569', '回复失败', '回复失败', 1),
(637, 1, '400570', '请选择限购类型', '请选择限购类型', 1),
(638, 1, '400571', '限购数量不能小于1', '限购数量不能小于1', 1),
(639, 1, '400572', '一二级返佣相加不能大于商品售价', '一二级返佣相加不能大于商品售价', 1),
(640, 1, '400573', '商品类型不能切换', '商品类型不能切换', 1),
(641, 1, '400574', '请输入规则名称', '请输入规则名称', 1),
(642, 1, '400575', '请输入属性名称', '请输入属性名称', 1),
(643, 1, '400576', '请输入正确的属性', '请输入正确的属性', 1),
(644, 1, '400577', '请填写正确的商品信息', '请填写正确的商品信息', 1),
(645, 1, '400578', '请填写正确的商品价格', '请填写正确的商品价格', 1),
(646, 1, '400579', '请填写正确的商品库存', '请填写正确的商品库存', 1),
(647, 1, '400580', '请填写正确的商品成本价格', '请填写正确的商品成本价格', 1),
(648, 1, '400581', '请上传商品图片', '请上传商品图片', 1),
(649, 1, '400582', '{:name}规格不存在', '{:name}规格不存在', 1),
(650, 1, '400583', '{:name}属性不存在', '{:name}属性不存在', 1),
(651, 1, '400584', '请设置至少一个属性', '请设置至少一个属性', 1),
(652, 1, '400585', '商品参与秒杀活动开启，无法进行此操作', '商品参与秒杀活动开启，无法进行此操作', 1),
(653, 1, '400586', '商品参与砍价活动开启，无法进行此操作', '商品参与砍价活动开启，无法进行此操作', 1),
(654, 1, '400587', '商品参与拼团活动开启，无法进行此操作', '商品参与拼团活动开启，无法进行此操作', 1),
(655, 1, '400588', '会员价格不能为0', '会员价格不能为0', 1),
(656, 1, '400589', '虚拟优惠券商品请选择优惠券', '虚拟优惠券商品请选择优惠券', 1),
(657, 1, '400590', '卡号：{:key}密码：{:value}，已经添加过，请重新添加卡密', '卡号：{:key}密码：{:value}，已经添加过，请重新添加卡密', 1),
(658, 1, '400591', '缺少城市id无法保存', '缺少城市id无法保存', 1),
(659, 1, '400592', '修改的模板不存在', '修改的模板不存在', 1),
(660, 1, '400593', '指定区域邮费添加失败', '指定区域邮费添加失败', 1),
(661, 1, '400594', '管理员不存在', '管理员不存在', 1),
(662, 1, '400595', '您已被禁止登录', '您已被禁止登录', 1),
(663, 1, '400596', '管理员账号已存在', '管理员账号已存在', 1),
(664, 1, '400597', '原始密码错误', '原始密码错误', 1),
(665, 1, '400598', '请输入新密码', '请输入新密码', 1),
(666, 1, '400599', '请选择要删除的图片', '请选择要删除的图片', 1),
(667, 1, '400600', '移动失败或不能重复移动到同一分类下', '移动失败或不能重复移动到同一分类下', 1),
(668, 1, '400601', '请求不被允许', '请求不被允许', 1),
(669, 1, '400602', '设置类目不被允许', '设置类目不被允许', 1),
(670, 1, '400603', '请输入正确格式的配置参数', '请输入正确格式的配置参数', 1),
(671, 1, '400604', '{:name}请输入默认值', '{:name}请输入默认值', 1),
(672, 1, '400605', '{:name}请输入正确url', '{:name}请输入正确url', 1),
(673, 1, '400606', '保存wss证书失败', '保存wss证书失败', 1),
(674, 1, '400607', '{:name}不能为空', '{:name}不能为空', 1),
(675, 1, '400608', '删除的云存储不存在', '删除的云存储不存在', 1),
(676, 1, '400609', '云存储正在使用中,需要启动其他空间才能删除', '云存储正在使用中,需要启动其他空间才能删除', 1),
(677, 1, '400610', '云空间名称不能重复', '云空间名称不能重复', 1),
(678, 1, '400611', '没有权限', '没有权限', 1),
(679, 1, '400612', '替换失败,失败原因:{:msg}', '替换失败,失败原因:{:msg}', 1),
(680, 1, '400613', '请先删除改菜单下的子菜单', '请先删除改菜单下的子菜单', 1),
(681, 1, '400614', '请填写批次名称', '请填写批次名称', 1),
(682, 1, '400615', '请填写要生成卡的数量', '请填写要生成卡的数量', 1),
(683, 1, '400616', '卡片数量只能为正整数', '卡片数量只能为正整数', 1),
(684, 1, '400617', '单次制卡数量最高不得超过6000张', '单次制卡数量最高不得超过6000张', 1),
(685, 1, '400618', '请填写免费使用天数', '请填写免费使用天数', 1),
(686, 1, '400619', '免费使用天数只能为正整数', '免费使用天数只能为正整数', 1),
(687, 1, '400620', '生成卡失败', '生成卡失败', 1),
(688, 1, '400621', '会员功能暂未开启', '会员功能暂未开启', 1),
(689, 1, '400622', '请输入会员卡号', '请输入会员卡号', 1),
(690, 1, '400623', '请输入领取卡密', '请输入领取卡密', 1),
(691, 1, '400624', '会员卡不存在', '会员卡不存在', 1),
(692, 1, '400625', '会员卡未激活，暂无法使用', '会员卡未激活，暂无法使用', 1),
(693, 1, '400626', '会员卡密码有误', '会员卡密码有误', 1),
(694, 1, '400627', '会员卡已使用', '会员卡已使用', 1),
(695, 1, '400628', '您已是永久会员，无需再领取，可以将此卡转送亲朋好友，一起享受优惠', '您已是永久会员，无需再领取，可以将此卡转送亲朋好友，一起享受优惠', 1),
(696, 1, '400629', '暂无此类型会员卡', '暂无此类型会员卡', 1),
(697, 1, '400630', '会员权益类型缺失', '会员权益类型缺失', 1),
(698, 1, '400631', '请设置权益名称', '请设置权益名称', 1),
(699, 1, '400632', '请上传会员权益图标', '请上传会员权益图标', 1),
(700, 1, '400633', '请设置返还积分倍数', '请设置返还积分倍数', 1),
(701, 1, '400634', '返还积分倍数不能为负数', '返还积分倍数不能为负数', 1),
(702, 1, '400635', '请设置运费折扣', '请设置运费折扣', 1),
(703, 1, '400636', '运费折扣不能为负数', '运费折扣不能为负数', 1),
(704, 1, '400637', '请设置签到积分倍数', '请设置签到积分倍数', 1),
(705, 1, '400638', '签到积分倍数不能为负数', '签到积分倍数不能为负数', 1),
(706, 1, '400639', '请设置线下付款折扣', '请设置线下付款折扣', 1),
(707, 1, '400640', '线下付款不能为负数', '线下付款不能为负数', 1),
(708, 1, '400641', '请填写会员卡名称', '请填写会员卡名称', 1),
(709, 1, '400642', '会员卡类型缺失', '会员卡类型缺失', 1),
(710, 1, '400643', '请填写有效期（天）', '请填写有效期（天）', 1),
(711, 1, '400644', '有效期（天）不能为负数', '有效期（天）不能为负数', 1),
(712, 1, '400645', '请填写价格', '请填写价格', 1),
(713, 1, '400646', '价格不能为负数', '价格不能为负数', 1),
(714, 1, '400647', '优惠价不能大于原价', '优惠价不能大于原价', 1),
(715, 1, '400648', '地址不存在', '地址不存在', 1),
(716, 1, '400649', '取消原来默认地址失败', '取消原来默认地址失败', 1),
(717, 1, '400650', '设置默认地址失败', '设置默认地址失败', 1),
(718, 1, '400651', '地址已存在', '地址已存在', 1),
(719, 1, '400652', '收货地址格式错误', '收货地址格式错误', 1),
(720, 1, '400653', '请登录', '请登录', 1),
(721, 1, '400654', '登录已过期,请重新登录', '登录已过期,请重新登录', 1),
(722, 1, '400655', '增加记录失败', '增加记录失败', 1),
(723, 1, '400656', '记录分享记录失败', '记录分享记录失败', 1),
(724, 1, '400657', '增加用户佣金失败', '增加用户佣金失败', 1),
(725, 1, '400658', '企业付款到零钱失败，请稍后再试', '企业付款到零钱失败，请稍后再试', 1),
(726, 1, '400659', '已经提现', '已经提现', 1),
(727, 1, '400660', '您的提现申请已被拒绝', '您的提现申请已被拒绝', 1),
(728, 1, '400661', '可提现佣金不足', '可提现佣金不足', 1),
(729, 1, '400662', '提现金额不能小于{:money}元', '提现金额不能小于{:money}元', 1),
(730, 1, '400663', '提现佣金不足{:money}元', '提现佣金不足{:money}元', 1),
(731, 1, '400664', '提现佣金大于0', '提现佣金大于0', 1),
(732, 1, '400665', '企业微信付款到零钱最低金额为1元', '企业微信付款到零钱最低金额为1元', 1),
(733, 1, '400666', '该分组已经存在', '该分组已经存在', 1),
(734, 1, '400667', '清空用户标签失败', '清空用户标签失败', 1),
(735, 1, '400668', '设置标签失败', '设置标签失败', 1),
(736, 1, '400669', '请选择标签分类', '请选择标签分类', 1),
(737, 1, '400670', '该标签已经存在', '该标签已经存在', 1),
(738, 1, '400671', '修改用户等级信息失败', '修改用户等级信息失败', 1),
(739, 1, '400672', '用户等级不存在', '用户等级不存在', 1),
(740, 1, '400673', '用户等级经验必须大于上一等级设置的经验', '用户等级经验必须大于上一等级设置的经验', 1),
(741, 1, '400674', '用户等级经验必须小于下一等级设置的经验', '用户等级经验必须小于下一等级设置的经验', 1),
(742, 1, '400675', '已检测到您设置过的用户等级，此等级不可重复', '已检测到您设置过的用户等级，此等级不可重复', 1),
(743, 1, '400676', '已检测到您设置过该用户等级经验值，经验值不可重复', '已检测到您设置过该用户等级经验值，经验值不可重复', 1),
(744, 1, '400677', '订单未支付', '订单未支付', 1),
(745, 1, '400678', '佣金转入余额，不能退款', '佣金转入余额，不能退款', 1),
(746, 1, '400679', '已支付的订单记录无法删除', '已支付的订单记录无法删除', 1),
(747, 1, '400680', '转入金额不能大于可提现佣金', '转入金额不能大于可提现佣金', 1),
(748, 1, '400681', '写入余额充值失败', '写入余额充值失败', 1),
(749, 1, '400682', '您选择的充值方式已下架', '您选择的充值方式已下架', 1),
(750, 1, '400683', '充值订单生成失败', '充值订单生成失败', 1),
(751, 1, '400684', '保存用户信息失败', '保存用户信息失败', 1),
(752, 1, '400685', '密码重置失败', '密码重置失败', 1),
(753, 1, '400686', '增加推广人数失败', '增加推广人数失败', 1),
(754, 1, '400687', '设置登录类型失败', '设置登录类型失败', 1),
(755, 1, '400688', '设置推广员失败', '设置推广员失败', 1),
(756, 1, '400689', '增加用户余额失败', '增加用户余额失败', 1),
(757, 1, '400690', '减少用户余额失败', '减少用户余额失败', 1),
(758, 1, '400691', '减少用户佣金失败', '减少用户佣金失败', 1),
(759, 1, '400692', '增加用户积分失败', '增加用户积分失败', 1),
(760, 1, '400693', '减少用户积分失败', '减少用户积分失败', 1),
(761, 1, '400694', '增加用户经验失败', '增加用户经验失败', 1),
(762, 1, '400695', '减少用户经验失败', '减少用户经验失败', 1),
(763, 1, '400696', '该分组不存在', '该分组不存在', 1),
(764, 1, '400697', '设置分组失败或无改动', '设置分组失败或无改动', 1),
(765, 1, '400698', '有标签不存在或被删除', '有标签不存在或被删除', 1),
(766, 1, '400699', '等级不存在或被删除', '等级不存在或被删除', 1),
(767, 1, '400700', '此用户已有该用户等级，无法再次赠送', '此用户已有该用户等级，无法再次赠送', 1),
(768, 1, '400701', '赠送天数不能为0', '赠送天数不能为0', 1),
(769, 1, '400702', '天数输入错误', '天数输入错误', 1),
(770, 1, '400703', '用户信息储存失败', '用户信息储存失败', 1),
(771, 1, '400704', '您得ip不再白名单中,请前往腾讯微信公众平台添加ip白名单', '您得ip不再白名单中,请前往腾讯微信公众平台添加ip白名单', 1),
(772, 1, '400705', '您填写得appid无效,请检查', '您填写得appid无效,请检查', 1),
(773, 1, '400706', '请输入回复信息内容', '请输入回复信息内容', 1),
(774, 1, '400707', '请上传回复的图片', '请上传回复的图片', 1),
(775, 1, '400708', '请上传回复的声音', '请上传回复的声音', 1),
(776, 1, '400709', '请选择图文消息', '请选择图文消息', 1),
(777, 1, '400710', '对应的uid不存在', '对应的uid不存在', 1),
(778, 1, '400711', '取消关注失败', '取消关注失败', 1),
(779, 1, '400712', '电子面单模板ID缺失', '电子面单模板ID缺失', 1),
(780, 1, '400713', '快递公司编码缺失', '快递公司编码缺失', 1),
(781, 1, '400714', '寄件人信息缺失', '寄件人信息缺失', 1),
(782, 1, '400715', '收件人信息缺失', '收件人信息缺失', 1),
(783, 1, '400716', '云打印机编号缺失', '云打印机编号缺失', 1),
(784, 1, '400717', '商品数量缺失', '商品数量缺失', 1),
(785, 1, '400718', '获取access_token获取失败', '获取access_token获取失败', 1),
(786, 1, '400719', '手机号不能为空', '手机号不能为空', 1),
(787, 1, '400720', '模版ID不存在', '模版ID不存在', 1),
(788, 1, '400721', '请先配置accessKey和secretKey', '请先配置accessKey和secretKey', 1),
(789, 1, '400722', '请先配置水印图片', '请先配置水印图片', 1),
(790, 1, '400723', '请先配置水印文字', '请先配置水印文字', 1),
(791, 1, '400724', '远程水印图片下载失败', '远程水印图片下载失败', 1),
(792, 1, '400725', '上传图片不存在', '上传图片不存在', 1),
(793, 1, '400726', '图片流获取失败', '图片流获取失败', 1),
(794, 1, '400727', '图片下载失败', '图片下载失败', 1),
(795, 1, '400728', '必须上传xlsx格式文件', '必须上传xlsx格式文件', 1),
(796, 1, '400729', '数据不能为空', '数据不能为空', 1),
(797, 1, '400730', '缺少pay_price', '缺少pay_price', 1),
(798, 1, '400731', '退款失败:{:msg}', '退款失败:{:msg}', 1),
(799, 1, '400732', '获取微信粉丝信息失败', '获取微信粉丝信息失败', 1),
(800, 1, '400733', '您已关闭上传功能', '您已关闭上传功能', 1),
(801, 1, '400734', '文件不可写', '文件不可写', 1),
(802, 1, '400735', '时间格式不正确', '时间格式不正确', 1),
(803, 1, '400736', '文件可能损坏，请检查', '文件可能损坏，请检查', 1),
(804, 1, '400737', '修复错误，请重试', '修复错误，请重试', 1),
(805, 1, '400738', '请指定要修复的表', '请指定要修复的表', 1),
(806, 1, '400739', '请配置支付证书', '请配置支付证书', 1),
(807, 1, '400740', '只支持两级分类', '只支持两级分类', 1),
(808, 1, '400741', '运费格式错误', '运费格式错误', 1),
(809, 1, '400742', '请检查属性编码或库存数量', '请检查属性编码或库存数量', 1),
(810, 1, '400743', '同步条数不能超过100', '同步条数不能超过100', 1),
(811, 1, '400744', 'appid或appsecret错误', 'appid或appsecret错误', 1),
(812, 1, '400745', '父级ID参数类型错误', '父级ID参数类型错误', 1),
(813, 1, '400746', '分类名称长度不能超过25个字符', '分类名称长度不能超过25个字符', 1),
(814, 1, '400747', '分类图标长度不能超过128个字符', '分类图标长度不能超过128个字符', 1),
(815, 1, '400748', '分类大图长度不能超过200个字符', '分类大图长度不能超过200个字符', 1),
(816, 1, '400749', '排序参数类型错误', '排序参数类型错误', 1),
(817, 1, '400750', '排序不能小于0', '排序不能小于0', 1),
(818, 1, '400751', '状态必须是0-1之间的整数', '状态必须是0-1之间的整数', 1),
(819, 1, '400752', '权益简介不能大于8个字', '权益简介不能大于8个字', 1),
(820, 1, '400753', '提现方式最少选一种', '提现方式最少选一种', 1),
(821, 1, '400754', '身份使用中，无法删除', '身份使用中，无法删除', 1),
(822, 1, '400755', '展示名称不能大于6个字', '展示名称不能大于6个字', 1),
(823, 1, '400756', '推广佣金单价不能小于0', '推广佣金单价不能小于0', 1),
(824, 1, '400757', '每日推广佣金上限不能小于-1', '每日推广佣金上限不能小于-1', 1),
(825, 1, '400758', '请核对领取方式', '请核对领取方式', 1),
(826, 1, '400759', '请输入优惠券名称', '请输入优惠券名称', 1),
(827, 1, '400760', '请输入真实姓名', '请输入真实姓名', 1),
(828, 1, '400761', '描述内容不能超过120字', '描述内容不能超过120字', 1),
(829, 1, '400762', '账号密码必须是在6到32位之间', '账号密码必须是在6到32位之间', 1),
(830, 1, '400763', '商户号不能为空', '商户号不能为空', 1),
(831, 1, '410000', '请输入账号和密码', '请输入账号和密码', 1),
(832, 1, '410001', '登录成功', '登录成功', 1),
(833, 1, '410002', '退出成功', '退出成功', 1),
(834, 1, '410003', '发送验证码失败,请刷新页面重新获取', '发送验证码失败,请刷新页面重新获取', 1),
(835, 1, '410004', '请输入验证码', '请输入验证码', 1),
(836, 1, '410005', '验证码输入有误', '验证码输入有误', 1),
(837, 1, '410006', '验证码已发送', '验证码已发送', 1),
(838, 1, '410007', '验证码发送成功', '验证码发送成功', 1),
(839, 1, '410008', '验证码发送失败', '验证码发送失败', 1),
(840, 1, '410009', '请先获取验证码', '请先获取验证码', 1),
(841, 1, '410010', '验证码错误', '验证码错误', 1),
(842, 1, '410011', '密码必须是在6到16位之间', '密码必须是在6到16位之间', 1),
(843, 1, '410012', '密码太过简单，请输入较为复杂的密码', '密码太过简单，请输入较为复杂的密码', 1),
(844, 1, '410013', '注册成功', '注册成功', 1),
(845, 1, '410014', '注册失败', '注册失败', 1),
(846, 1, '410015', '请输入手机号', '请输入手机号', 1),
(847, 1, '410016', '绑定成功', '绑定成功', 1),
(848, 1, '410017', '绑定失败', '绑定失败', 1),
(849, 1, '410018', '手机号格式不正确', '手机号格式不正确', 1),
(850, 1, '410019', '登录失败', '登录失败', 1),
(851, 1, '410020', '扫码失败请重新扫描', '扫码失败请重新扫描', 1),
(852, 1, '410021', '二维码已过期请重新扫描', '二维码已过期请重新扫描', 1),
(853, 1, '410022', '授权成功，请绑定手机号', '授权成功，请绑定手机号', 1),
(854, 1, '410023', '授权成功', '授权成功', 1),
(855, 1, '410024', '请先关注公众号', '请先关注公众号', 1),
(856, 1, '410025', '账号或密码错误', '账号或密码错误', 1),
(857, 1, '410026', '请修改您的初始密码，再尝试登录', '请修改您的初始密码，再尝试登录', 1),
(858, 1, '410027', '您已被禁止登录，请联系管理员', '您已被禁止登录，请联系管理员', 1),
(859, 1, '410028', '手机号已注册', '手机号已注册', 1),
(860, 1, '410029', '您今日发送得短信次数已经达到上限', '您今日发送得短信次数已经达到上限', 1),
(861, 1, '410030', '此IP今日发送次数已经达到上限', '此IP今日发送次数已经达到上限', 1),
(862, 1, '410031', '短信平台验证码发送失败', '短信平台验证码发送失败', 1),
(863, 1, '410032', '用户不存在', '用户不存在', 1),
(864, 1, '410033', '修改密码失败', '修改密码失败', 1),
(865, 1, '410034', '用户登录失败,无法生成新用户,请稍后再试', '用户登录失败,无法生成新用户,请稍后再试', 1),
(866, 1, '410035', '用户不存在,无法切换', '用户不存在,无法切换', 1),
(867, 1, '410036', '修改新用户登录类型出错', '修改新用户登录类型出错', 1),
(868, 1, '410037', '请刷新页面或者重新授权', '请刷新页面或者重新授权', 1),
(869, 1, '410038', '获取用户访问token失败', '获取用户访问token失败', 1),
(870, 1, '410039', '此手机已经绑定，无法多次绑定', '此手机已经绑定，无法多次绑定', 1),
(871, 1, '410040', '您的账号已经绑定过手机号码', '您的账号已经绑定过手机号码', 1),
(872, 1, '410041', 'H5已有账号是否绑定此账号上', 'H5已有账号是否绑定此账号上', 1),
(873, 1, '410042', '新手机号和原手机号相同，无需修改', '新手机号和原手机号相同，无需修改', 1),
(874, 1, '410043', '此手机已经注册', '此手机已经注册', 1),
(875, 1, '410044', '用户信息获取失败', '用户信息获取失败', 1),
(876, 1, '410045', '请选择收货地址', '请选择收货地址', 1),
(877, 1, '410046', '地址选择有误', '地址选择有误', 1),
(878, 1, '410047', '可用积分不足', '可用积分不足', 1),
(879, 1, '410048', '奖品不存在', '奖品不存在', 1),
(880, 1, '410049', '写入中奖记录失败', '写入中奖记录失败', 1),
(881, 1, '410050', '请继续参与活动抽奖', '请继续参与活动抽奖', 1),
(882, 1, '410051', '已经领取成功', '已经领取成功', 1),
(883, 1, '410052', '请输入收货人信息', '请输入收货人信息', 1),
(884, 1, '410053', '请输入正确的收货人电话', '请输入正确的收货人电话', 1),
(885, 1, '410054', '抽奖记录不存在', '抽奖记录不存在', 1),
(886, 1, '410055', '该奖品不需要发货', '该奖品不需要发货', 1),
(887, 1, '410056', '请选择快递公司或输入快递单号', '请选择快递公司或输入快递单号', 1),
(888, 1, '410057', '活动不存在或已删除', '活动不存在或已删除', 1),
(889, 1, '410058', '暂未有该类型活动', '暂未有该类型活动', 1),
(890, 1, '410059', '您暂时无法参与该活动', '您暂时无法参与该活动', 1),
(891, 1, '410060', '活动状态有误，请联系管理员', '活动状态有误，请联系管理员', 1),
(892, 1, '410061', '可用积分不足，没有更多抽奖次数', '可用积分不足，没有更多抽奖次数', 1),
(893, 1, '410062', '余额不足，没有更多抽奖次数', '余额不足，没有更多抽奖次数', 1),
(894, 1, '410063', '购买商品之后获得更多抽奖次数', '购买商品之后获得更多抽奖次数', 1),
(895, 1, '410064', '订单完成评价之后获得更多抽奖次数', '订单完成评价之后获得更多抽奖次数', 1),
(896, 1, '410065', '邀请更多好友获取抽奖次数', '邀请更多好友获取抽奖次数', 1),
(897, 1, '410066', '抽奖扣除用户积分失败', '抽奖扣除用户积分失败', 1),
(898, 1, '410067', '抽奖失败，余额不足', '抽奖失败，余额不足', 1),
(899, 1, '410068', '抽奖扣除用户余额失败', '抽奖扣除用户余额失败', 1),
(900, 1, '410069', '抽奖扣除用户推广获取抽奖次数失败', '抽奖扣除用户推广获取抽奖次数失败', 1),
(901, 1, '410070', '抽奖减少奖品总数失败', '抽奖减少奖品总数失败', 1),
(902, 1, '410071', '分销等级不存在', '分销等级不存在', 1),
(903, 1, '410072', '永久二维码获取错误', '永久二维码获取错误', 1),
(904, 1, '410073', '邀请码无效', '邀请码无效', 1),
(905, 1, '410074', '授权失败,参数有误', '授权失败,参数有误', 1),
(906, 1, '410075', 'openid获取失败', 'openid获取失败', 1),
(907, 1, '410076', '获取session_key失败，请检查您的配置', '获取session_key失败，请检查您的配置', 1),
(908, 1, '410077', '获取会话密匙失败', '获取会话密匙失败', 1),
(909, 1, '410078', '静默授权失败', '静默授权失败', 1),
(910, 1, '410079', '获取用户信息失败', '获取用户信息失败', 1),
(911, 1, '410080', '更新信息失败', '更新信息失败', 1),
(912, 1, '410081', '请上传二维码', '请上传二维码', 1),
(913, 1, '410082', '请关注公众号', '请关注公众号', 1),
(914, 1, '410083', '新增用户失败', '新增用户失败', 1),
(915, 1, '410084', '用户关注失败', '用户关注失败', 1),
(916, 1, '410085', '获取token失败{:msg}', '获取token失败{:msg}', 1),
(917, 1, '410086', '配置已更改或token已失效', '配置已更改或token已失效', 1),
(918, 1, '410087', '平台错误：发生异常，请稍后重试', '平台错误：发生异常，请稍后重试', 1),
(919, 1, '410088', '企业微信支付到零钱需要支付证书，检测到您没有上传', '企业微信支付到零钱需要支付证书，检测到您没有上传', 1),
(920, 1, '410089', '发起企业支付到零钱失败', '发起企业支付到零钱失败', 1),
(921, 1, '410090', '无效的token不能查找到用户聊天记录', '无效的token不能查找到用户聊天记录', 1),
(922, 1, '410091', '图片上传成功', '图片上传成功', 1),
(923, 1, '410092', '用户uid不再当前聊天用户范围内', '用户uid不再当前聊天用户范围内', 1),
(924, 1, '410093', '请输入订单价格', '请输入订单价格', 1),
(925, 1, '410094', '请去后台售后订单列表处理', '请去后台售后订单列表处理', 1),
(926, 1, '410095', '分类名称不能为空', '分类名称不能为空', 1),
(927, 1, '410096', '分类不存在', '分类不存在', 1),
(928, 1, '410097', '添加的内容重复', '添加的内容重复', 1),
(929, 1, '410098', '缺少转接人id', '缺少转接人id', 1),
(930, 1, '410099', '转接成功', '转接成功', 1),
(931, 1, '410100', '话术没有被查到', '话术没有被查到', 1),
(932, 1, '410101', '公共话术不能修改', '公共话术不能修改', 1),
(933, 1, '410102', '话术标题内容不能为空', '话术标题内容不能为空', 1),
(934, 1, '410103', '已拥有此分组', '已拥有此分组', 1),
(935, 1, '410104', '缺少标签id', '缺少标签id', 1),
(936, 1, '410105', '请填汉字字母或者数字', '请填汉字字母或者数字', 1),
(937, 1, '410106', '标题长度不能超过50个字', '标题长度不能超过50个字', 1),
(938, 1, '410107', '请选择分类', '请选择分类', 1),
(939, 1, '410108', '分类必须为数字', '分类必须为数字', 1),
(940, 1, '410109', '请填写话术内容', '请填写话术内容', 1),
(941, 1, '410110', '话术长度不能超过500个字', '话术长度不能超过500个字', 1),
(942, 1, '410111', '排序必须为数字', '排序必须为数字', 1),
(943, 1, '410112', '微信最低提现金额不能小于1元', '微信最低提现金额不能小于1元', 1),
(944, 1, '410113', '用户不存在', '用户不存在', 1),
(945, 1, '410114', '提现方式不存在', '提现方式不存在', 1),
(946, 1, '410115', '提现金额输入有误', '提现金额输入有误', 1),
(947, 1, '410116', '银行卡号输入有误', '银行卡号输入有误', 1),
(948, 1, '410117', '请输入支付宝账号', '请输入支付宝账号', 1),
(949, 1, '410118', '请输入银行卡账号', '请输入银行卡账号', 1),
(950, 1, '410119', '请输入开户行信息', '请输入开户行信息', 1),
(951, 1, '410120', '申请提现成功', '申请提现成功', 1),
(952, 1, '410121', '申请提现失败', '申请提现失败', 1),
(953, 1, '410122', '充值金额不能为0元', '充值金额不能为0元', 1),
(954, 1, '410123', '充值方式不支持', '充值方式不支持', 1),
(955, 1, '410124', '充值金额不能低于{:money}', '充值金额不能低于{:money}', 1),
(956, 1, '410125', '充值成功', '充值成功', 1),
(957, 1, '410126', '充值失败', '充值失败', 1),
(958, 1, '410127', '签到获得{:integral}积分', '签到获得{:integral}积分', 1),
(959, 1, '410128', '签到失败', '签到失败', 1),
(960, 1, '410129', '收藏成功', '收藏成功', 1),
(961, 1, '410130', '收藏失败', '收藏失败', 1),
(962, 1, '410131', '授权失败', '授权失败', 1),
(963, 1, '410132', 'unionid不存在', 'unionid不存在', 1),
(964, 1, '410133', '获取用户UID失败', '获取用户UID失败', 1),
(965, 1, '410134', '请输入昵称或者选择头像', '请输入昵称或者选择头像', 1),
(966, 1, '410135', '注销成功', '注销成功', 1),
(967, 1, '410136', '暂无客服人员在线，请稍后联系', '暂无客服人员在线，请稍后联系', 1),
(968, 1, '410137', '不能和自己聊天', '不能和自己聊天', 1),
(969, 1, '410138', '您不是客服无法登录', '您不是客服无法登录', 1),
(970, 1, '410139', '自己不能转接给自己', '自己不能转接给自己', 1),
(971, 1, '410140', '转接客服失败', '转接客服失败', 1),
(972, 1, '410141', '没有此用户', '没有此用户', 1),
(973, 1, '410142', '客服不存在', '客服不存在', 1),
(974, 1, '410143', '商品未查到', '商品未查到', 1),
(975, 1, '410144', '请填写开票手机号', '请填写开票手机号', 1),
(976, 1, '410145', '请填写发票抬头（开具发票企业名称）', '请填写发票抬头（开具发票企业名称）', 1),
(977, 1, '410146', '请填写正确的发票抬头（开具发票企业名称）', '请填写正确的发票抬头（开具发票企业名称）', 1),
(978, 1, '410147', '请填写发票税号', '请填写发票税号', 1),
(979, 1, '410148', '请填写正确的发票税号', '请填写正确的发票税号', 1),
(980, 1, '410149', '请填写正确的银行卡号', '请填写正确的银行卡号', 1),
(981, 1, '410150', '地址不存在', '地址不存在', 1),
(982, 1, '410151', '收货地址格式错误', '收货地址格式错误', 1),
(983, 1, '410152', '收货地址格式错误或系统未完善当前地址', '收货地址格式错误或系统未完善当前地址', 1),
(984, 1, '410153', '收货地址格式错误，请重新选择', '收货地址格式错误，请重新选择', 1),
(985, 1, '410154', '请填写详细地址', '请填写详细地址', 1),
(986, 1, '410155', '名称必须填写', '名称必须填写', 1),
(987, 1, '410156', '名称最多不能超过25个字符', '名称最多不能超过25个字符', 1),
(988, 1, '410157', '手机号必须填写', '手机号必须填写', 1),
(989, 1, '410158', '手机号格式错误', '手机号格式错误', 1),
(990, 1, '410159', '省必须填写', '省必须填写', 1),
(991, 1, '410160', '市必须填写', '市必须填写', 1),
(992, 1, '410161', '区/县必须填写', '区/县必须填写', 1),
(993, 1, '410162', '详细地址必须填写', '详细地址必须填写', 1),
(994, 1, '410163', '请填写反馈内容', '请填写反馈内容', 1),
(995, 1, '410164', '比例不能大于您的比例', '比例不能大于您的比例', 1),
(996, 1, '410165', '激活成功', '激活成功', 1),
(997, 1, '410166', '暂无海报', '暂无海报', 1),
(998, 1, '410167', '二维码生成失败', '二维码生成失败', 1),
(999, 1, '410168', '缺少字体文件Bold', '缺少字体文件Bold', 1),
(1000, 1, '410169', '缺少字体文件Normal', '缺少字体文件Normal', 1),
(1001, 1, '410170', '生成图片失败', '生成图片失败', 1),
(1002, 1, '410171', '生成图片时，系统错误', '生成图片时，系统错误', 1),
(1003, 1, '410172', '生成海报失败', '生成海报失败', 1),
(1004, 1, '410173', '订单不存在', '订单不存在', 1),
(1005, 1, '410174', '订单已支付', '订单已支付', 1),
(1006, 1, '410175', '请填写实际支付金额', '请填写实际支付金额', 1),
(1007, 1, '410176', '实际支付金额不能小于0元', '实际支付金额不能小于0元', 1),
(1008, 1, '410177', '请填写备注内容', '请填写备注内容', 1),
(1009, 1, '410178', '请先处理售后申请', '请先处理售后申请', 1),
(1010, 1, '410179', '用户已取消申请', '用户已取消申请', 1),
(1011, 1, '410180', '售后订单状态不支持该操作', '售后订单状态不支持该操作', 1),
(1012, 1, '410181', '退款修改状态错误', '退款修改状态错误', 1),
(1013, 1, '410182', '修改退款状态成功', '修改退款状态成功', 1),
(1014, 1, '410183', '已退完支付金额，不能再退款了', '已退完支付金额，不能再退款了', 1),
(1015, 1, '410184', '请输入退款金额', '请输入退款金额', 1),
(1016, 1, '410185', '退款金额大于支付金额，请修改退款金额', '退款金额大于支付金额，请修改退款金额', 1),
(1017, 1, '410186', '退款成功', '退款成功', 1),
(1018, 1, '410187', '退款失败', '退款失败', 1),
(1019, 1, '410188', '请输入核销码或者扫描核销二维码', '请输入核销码或者扫描核销二维码', 1),
(1020, 1, '410189', '核销成功', '核销成功', 1),
(1021, 1, '410190', '请输入付款金额', '请输入付款金额', 1),
(1022, 1, '410191', '支付金额不能为0元', '支付金额不能为0元', 1),
(1023, 1, '410192', '付费会员功能暂未开启', '付费会员功能暂未开启', 1),
(1024, 1, '410193', '支付数据生成失败', '支付数据生成失败', 1),
(1025, 1, '410194', '支付订单不存在', '支付订单不存在', 1),
(1026, 1, '410195', '微信支付成功', '微信支付成功', 1),
(1027, 1, '410196', '前往支付', '前往支付', 1),
(1028, 1, '410197', '余额支付成功', '余额支付成功', 1),
(1029, 1, '410198', '请传入支付宝支付回调URL', '请传入支付宝支付回调URL', 1),
(1030, 1, '410199', '支付宝支付成功', '支付宝支付成功', 1),
(1031, 1, '410200', '订单生成失败', '订单生成失败', 1),
(1032, 1, '410201', '请提交购买的商品', '请提交购买的商品', 1),
(1033, 1, '410202', '商品不存在，请重新选择商品下单', '商品不存在，请重新选择商品下单', 1),
(1034, 1, '410203', '订单创建成功', '订单创建成功', 1),
(1035, 1, '410204', '收货成功', '收货成功', 1),
(1036, 1, '410205', '收货失败', '收货失败', 1),
(1037, 1, '410206', '快递单号不存在', '快递单号不存在', 1),
(1038, 1, '410207', '默认运费模板未配置，无法下单', '默认运费模板未配置，无法下单', 1),
(1039, 1, '410208', '订单已过期,请刷新当前页面', '订单已过期,请刷新当前页面', 1),
(1040, 1, '410209', '订单已创建，请点击查看完成支付', '订单已创建，请点击查看完成支付', 1),
(1041, 1, '410210', '订单生成失败，你已经在该团内不能再参加了', '订单生成失败，你已经在该团内不能再参加了', 1),
(1042, 1, '410211', '订单生成失败，你已经参加该团了，请先支付订单', '订单生成失败，你已经参加该团了，请先支付订单', 1),
(1043, 1, '410212', '该团人员已满', '该团人员已满', 1),
(1044, 1, '410213', '暂不支持该支付方式，请刷新页面或者联系管理员', '暂不支持该支付方式，请刷新页面或者联系管理员', 1),
(1045, 1, '410214', '您购买的商品库存已不足{:cart_num}{:unit_name}', '您购买的商品库存已不足{:cart_num}{:unit_name}', 1),
(1046, 1, '410215', '该订单已失效', '该订单已失效', 1),
(1047, 1, '410216', '支付失败', '支付失败', 1),
(1048, 1, '410217', '支付成功', '支付成功', 1),
(1049, 1, '410218', '支付方式错误', '支付方式错误', 1),
(1050, 1, '410219', '订单商品已评价', '订单商品已评价', 1),
(1051, 1, '410220', '请为商品评分', '请为商品评分', 1),
(1052, 1, '410221', '请为商家服务评分', '请为商家服务评分', 1),
(1053, 1, '410222', '评价失败', '评价失败', 1),
(1054, 1, '410223', '请重新选择退款商品或件数', '请重新选择退款商品或件数', 1),
(1055, 1, '410224', '当前状态不能取消申请', '当前状态不能取消申请', 1),
(1056, 1, '410225', '重选成功', '重选成功', 1),
(1057, 1, '410226', '订单已退款', '订单已退款', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(1058, 1, '410227', '使用积分抵扣失败', '使用积分抵扣失败', 1),
(1059, 1, '410228', '会员类型不存在', '会员类型不存在', 1),
(1060, 1, '410229', '您已是永久会员无需再购买', '您已是永久会员无需再购买', 1),
(1061, 1, '410230', '该会员卡暂时无法购买', '该会员卡暂时无法购买', 1),
(1062, 1, '410231', '您已经领取过免费会员', '您已经领取过免费会员', 1),
(1063, 1, '410232', '此类型会员卡暂未开售', '此类型会员卡暂未开售', 1),
(1064, 1, '410233', '获取购物车信息失败', '获取购物车信息失败', 1),
(1065, 1, '410234', '您要购买的优惠券已失效，无法购买', '您要购买的优惠券已失效，无法购买', 1),
(1066, 1, '410235', '您已获取过该优惠券，无法再次购买', '您已获取过该优惠券，无法再次购买', 1),
(1067, 1, '410236', '请刷新后重试', '请刷新后重试', 1),
(1068, 1, '410237', '暂无库存', '暂无库存', 1),
(1069, 1, '410238', '选择的规格库存不足', '选择的规格库存不足', 1),
(1070, 1, '410239', '单次购买数量不能大于 {:limit} 件', '单次购买数量不能大于 {:limit} 件', 1),
(1071, 1, '410240', '该商品限购 {:limit} 件，您已经购买 {:pay_num} 件', '该商品限购 {:limit} 件，您已经购买 {:pay_num} 件', 1),
(1072, 1, '410241', '选择支付方式有误', '选择支付方式有误', 1),
(1073, 1, '410242', '选择的优惠劵无效', '选择的优惠劵无效', 1),
(1074, 1, '410243', '不满足优惠劵的使用条件', '不满足优惠劵的使用条件', 1),
(1075, 1, '410244', '使用优惠劵失败', '使用优惠劵失败', 1),
(1076, 1, '410245', '请填写姓名和电话', '请填写姓名和电话', 1),
(1077, 1, '410246', '营销商品不能使用线下支付', '营销商品不能使用线下支付', 1),
(1078, 1, '410247', '暂无门店无法选择门店自提', '暂无门店无法选择门店自提', 1),
(1079, 1, '410248', '订单商品结算失败', '订单商品结算失败', 1),
(1080, 1, '410249', '发票已申请', '发票已申请', 1),
(1081, 1, '410250', '正在申请退款中', '正在申请退款中', 1),
(1082, 1, '410251', '申请失败', '申请失败', 1),
(1083, 1, '410252', '退款件数大于订单件数', '退款件数大于订单件数', 1),
(1084, 1, '410253', '该订单已全部拆分', '该订单已全部拆分', 1),
(1085, 1, '410254', '申请退款失败', '申请退款失败', 1),
(1086, 1, '410255', '存在待处理退款单', '存在待处理退款单', 1),
(1087, 1, '410256', '该订单无法删除', '该订单无法删除', 1),
(1088, 1, '410257', '订单已经支付无法取消', '订单已经支付无法取消', 1),
(1089, 1, '410258', '拼团商品不能再来一单，请在拼团商品内自行下单', '拼团商品不能再来一单，请在拼团商品内自行下单', 1),
(1090, 1, '410259', '砍价商品不能再来一单，请在砍价商品内自行下单', '砍价商品不能再来一单，请在砍价商品内自行下单', 1),
(1091, 1, '410260', '秒杀商品不能再来一单，请在秒杀商品内自行下单', '秒杀商品不能再来一单，请在秒杀商品内自行下单', 1),
(1092, 1, '410261', '预售商品不能再来一单，请在预售商品内自行下单', '预售商品不能再来一单，请在预售商品内自行下单', 1),
(1093, 1, '410262', '再来一单失败，请重新下单', '再来一单失败，请重新下单', 1),
(1094, 1, '410263', '该订单无法支付', '该订单无法支付', 1),
(1095, 1, '410264', '订单支付状态有误，无法进行支付', '订单支付状态有误，无法进行支付', 1),
(1096, 1, '410265', '该订单已支付', '该订单已支付', 1),
(1097, 1, '410266', '订单状态错误', '订单状态错误', 1),
(1098, 1, '410267', '此订单不能被核销', '此订单不能被核销', 1),
(1099, 1, '410268', '订单有售后申请请先处理', '订单有售后申请请先处理', 1),
(1100, 1, '410269', '您无权限核销此订单，请联系管理员', '您无权限核销此订单，请联系管理员', 1),
(1101, 1, '410270', '订单已核销', '订单已核销', 1),
(1102, 1, '410271', '拼团订单暂未成功无法核销', '拼团订单暂未成功无法核销', 1),
(1103, 1, '410272', '核销失败', '核销失败', 1),
(1104, 1, '410273', '发货成功', '发货成功', 1),
(1105, 1, '410274', '无需支付', '无需支付', 1),
(1106, 1, '410275', '获取用户openid失败,无法支付', '获取用户openid失败,无法支付', 1),
(1107, 1, '410276', '网站名称配置未填写,无法支付', '网站名称配置未填写,无法支付', 1),
(1108, 1, '410277', '支付方式不存在', '支付方式不存在', 1),
(1109, 1, '410278', '不支持该类型方式', '不支持该类型方式', 1),
(1110, 1, '410279', '余额支付失败', '余额支付失败', 1),
(1111, 1, '410280', '暂未开启发票', '暂未开启发票', 1),
(1112, 1, '410281', '暂未开启专用发票', '暂未开启专用发票', 1),
(1113, 1, '410282', '该发票已经存在', '该发票已经存在', 1),
(1114, 1, '410283', '设置默认发票失败', '设置默认发票失败', 1),
(1115, 1, '410284', '没有此用户，无法检测升级用户等级', '没有此用户，无法检测升级用户等级', 1),
(1116, 1, '410285', '检测升级失败', '检测升级失败', 1),
(1117, 1, '410286', '修改订单失败', '修改订单失败', 1),
(1118, 1, '410287', '修改用户信息失败', '修改用户信息失败', 1),
(1119, 1, '410288', '绑定推广关系失败', '绑定推广关系失败', 1),
(1120, 1, '410289', '天数不能为0', '天数不能为0', 1),
(1121, 1, '410290', '添加签到数据失败', '添加签到数据失败', 1),
(1122, 1, '410291', '赠送经验失败', '赠送经验失败', 1),
(1123, 1, '410292', '请先配置签到天数', '请先配置签到天数', 1),
(1124, 1, '410293', '已经签到', '已经签到', 1),
(1125, 1, '410294', '商品不存在', '商品不存在', 1),
(1126, 1, '410295', '该商品已下架或删除', '该商品已下架或删除', 1),
(1127, 1, '410296', '该商品库存不足', '该商品库存不足', 1),
(1128, 1, '410297', '该商品库存不足{:num}', '该商品库存不足{:num}', 1),
(1129, 1, '410298', '每人总共限购{:num}件', '每人总共限购{:num}件', 1),
(1130, 1, '410299', '砍价已结束', '砍价已结束', 1),
(1131, 1, '410300', '您不能再发起此件商品砍价', '您不能再发起此件商品砍价', 1),
(1132, 1, '410301', '该分享未开启砍价', '该分享未开启砍价', 1),
(1133, 1, '410302', '您已经帮砍过此砍价', '您已经帮砍过此砍价', 1),
(1134, 1, '410303', '砍价信息没有查到', '砍价信息没有查到', 1),
(1135, 1, '410304', '用户砍价信息未查到', '用户砍价信息未查到', 1),
(1136, 1, '410305', '请选择有效的商品属性', '请选择有效的商品属性', 1),
(1137, 1, '410306', '砍价商品不存在', '砍价商品不存在', 1),
(1138, 1, '410307', '砍价失败', '砍价失败', 1),
(1139, 1, '410308', '砍价未成功', '砍价未成功', 1),
(1140, 1, '410309', '砍价已支付', '砍价已支付', 1),
(1141, 1, '410310', '您不能再帮砍此件商品', '您不能再帮砍此件商品', 1),
(1142, 1, '410311', '商品已被删除', '商品已被删除', 1),
(1143, 1, '410312', '拼团不存在或已下架,请手动申请退款', '拼团不存在或已下架,请手动申请退款', 1),
(1144, 1, '410313', '每个订单限购{:num}件', '每个订单限购{:num}件', 1),
(1145, 1, '410314', '未查到拼团信息，无法取消', '未查到拼团信息，无法取消', 1),
(1146, 1, '410315', '拼团已到期', '拼团已到期', 1),
(1147, 1, '410316', '拼团已完成，无法取消', '拼团已完成，无法取消', 1),
(1148, 1, '410317', '每人限购{:num}件', '每人限购{:num}件', 1),
(1149, 1, '410318', '抽奖不存在', '抽奖不存在', 1),
(1150, 1, '410319', '领取成功', '领取成功', 1),
(1151, 1, '410320', '领取失败', '领取失败', 1),
(1152, 1, '410321', '活动未开始', '活动未开始', 1),
(1153, 1, '410322', '活动已结束', '活动已结束', 1),
(1154, 1, '410323', '您已有这张优惠券，请勿重复购买', '您已有这张优惠券，请勿重复购买', 1),
(1155, 1, '410324', '请核对快递公司编码', '请核对快递公司编码', 1),
(1156, 1, '410325', '请选择发票', '请选择发票', 1),
(1157, 1, '-1', '系统繁忙，请稍候再试', '系统繁忙，请稍候再试', 1),
(1158, 1, '43104', 'appid与openid不匹配', 'appid与openid不匹配', 1),
(1159, 1, '45009', '达到微信api每日限额上限', '达到微信api每日限额上限', 1),
(1160, 1, '45008', '图文消息超过限制', '图文消息超过限制', 1),
(1161, 1, '45007', '语音播放时间超过限制', '语音播放时间超过限制', 1),
(1162, 1, '45006', '图片链接字段超过限制', '图片链接字段超过限制', 1),
(1163, 1, '45005', '链接字段超过限制', '链接字段超过限制', 1),
(1164, 1, '45004', '描述字段超过限制', '描述字段超过限制', 1),
(1165, 1, '45003', '标题字段超过限制', '标题字段超过限制', 1),
(1166, 1, '45002', '消息内容超过限制', '消息内容超过限制', 1),
(1167, 1, '45001', '多媒体文件大小超过限制', '多媒体文件大小超过限制', 1),
(1168, 1, '44004', '文本消息内容为空', '文本消息内容为空', 1),
(1169, 1, '44003', '图文消息内容为空', '图文消息内容为空', 1),
(1170, 1, '44002', 'POST 的数据包为空', 'POST 的数据包为空', 1),
(1171, 1, '44001', '多媒体文件为空', '多媒体文件为空', 1),
(1172, 1, '43019', '需要将接收者从黑名单中移除', '需要将接收者从黑名单中移除', 1),
(1173, 1, '43005', '需要好友关系', '需要好友关系', 1),
(1174, 1, '43004', '需要接收者关注', '需要接收者关注', 1),
(1175, 1, '43003', '需要 HTTPS 请求', '需要 HTTPS 请求', 1),
(1176, 1, '43002', '需要 POST 请求', '需要 POST 请求', 1),
(1177, 1, '43001', '需要 GET 请求', '需要 GET 请求', 1),
(1178, 1, '42007', '用户修改微信密码， accesstoken 和 refreshtoken 失效，需要重新授权', '用户修改微信密码， accesstoken 和 refreshtoken 失效，需要重新授权', 1),
(1179, 1, '42003', 'oauth_code 超时', 'oauth_code 超时', 1),
(1180, 1, '42002', 'refresh_token 超时', 'refresh_token 超时', 1),
(1181, 1, '42001', 'access_token 超时，请检查 access_token 的有效期，请参考基础支持 - 获取 access_token 中，对 access_token 的详细机制说明', 'access_token 超时，请检查 access_token 的有效期，请参考基础支持 - 获取 access_token 中，对 access_token 的详细机制说明', 1),
(1182, 1, '41009', '缺少 openid', '缺少 openid', 1),
(1183, 1, '41008', '缺少 oauth code', '缺少 oauth code', 1),
(1184, 1, '41007', '缺少子菜单数据', '缺少子菜单数据', 1),
(1185, 1, '41006', '缺少 media_id 参数', '缺少 media_id 参数', 1),
(1186, 1, '41005', '缺少多媒体文件数据', '缺少多媒体文件数据', 1),
(1187, 1, '41004', '缺少 secret 参数', '缺少 secret 参数', 1),
(1188, 1, '41003', '缺少 refresh_token 参数', '缺少 refresh_token 参数', 1),
(1189, 1, '41002', '缺少 appid 参数', '缺少 appid 参数', 1),
(1190, 1, '41001', '缺少 access_token 参数', '缺少 access_token 参数', 1),
(1191, 1, '40163', 'oauth_code已使用', 'oauth_code已使用', 1),
(1192, 1, '40155', '请勿添加其他公众号的主页链接', '请勿添加其他公众号的主页链接', 1),
(1193, 1, '40137', '不支持的图片格式', '不支持的图片格式', 1),
(1194, 1, '40132', '微信号不合法', '微信号不合法', 1),
(1195, 1, '40125', '无效的appsecret', '无效的appsecret', 1),
(1196, 1, '40121', '不合法的 media_id 类型', '不合法的 media_id 类型', 1),
(1197, 1, '40120', '子 button 类型错误', '子 button 类型错误', 1),
(1198, 1, '40119', 'button 类型错误', 'button 类型错误', 1),
(1199, 1, '40118', 'media_id 大小不合法', 'media_id 大小不合法', 1),
(1200, 1, '40117', '分组名字不合法', '分组名字不合法', 1),
(1201, 1, '40060', '删除单篇图文时，指定的 article_idx 不合法', '删除单篇图文时，指定的 article_idx 不合法', 1),
(1202, 1, '40051', '分组名字不合法', '分组名字不合法', 1),
(1203, 1, '40050', '不合法的分组 id', '不合法的分组 id', 1),
(1204, 1, '40048', '无效的url', '无效的url', 1),
(1205, 1, '40039', '不合法的 URL 长度', '不合法的 URL 长度', 1),
(1206, 1, '40035', '不合法的参数', '不合法的参数', 1),
(1207, 1, '40038', '不合法的请求格式', '不合法的请求格式', 1),
(1208, 1, '40033', '不合法的请求字符，不能包含 \\uxxxx 格式的字符', '不合法的请求字符，不能包含 \\uxxxx 格式的字符', 1),
(1209, 1, '40032', '不合法的 openid 列表长度', '不合法的 openid 列表长度', 1),
(1210, 1, '40031', '不合法的 openid 列表', '不合法的 openid 列表', 1),
(1211, 1, '40030', '不合法的 refresh_token', '不合法的 refresh_token', 1),
(1212, 1, '40029', '无效的 oauth_code', '无效的 oauth_code', 1),
(1213, 1, '40028', '不合法的自定义菜单使用用户', '不合法的自定义菜单使用用户', 1),
(1214, 1, '40027', '不合法的子菜单按钮 URL 长度', '不合法的子菜单按钮 URL 长度', 1),
(1215, 1, '40026', '不合法的子菜单按钮 KEY 长度', '不合法的子菜单按钮 KEY 长度', 1),
(1216, 1, '40025', '不合法的子菜单按钮名字长度', '不合法的子菜单按钮名字长度', 1),
(1217, 1, '40024', '不合法的子菜单按钮类型', '不合法的子菜单按钮类型', 1),
(1218, 1, '40023', '不合法的子菜单按钮个数', '不合法的子菜单按钮个数', 1),
(1219, 1, '40022', '不合法的子菜单级数', '不合法的子菜单级数', 1),
(1220, 1, '40021', '不合法的菜单版本号', '不合法的菜单版本号', 1),
(1221, 1, '40020', '不合法的按钮 URL 长度', '不合法的按钮 URL 长度', 1),
(1222, 1, '40019', '不合法的按钮 KEY 长度', '不合法的按钮 KEY 长度', 1),
(1223, 1, '40018', '不合法的按钮名字长度', '不合法的按钮名字长度', 1),
(1224, 1, '40017', '不合法的按钮类型', '不合法的按钮类型', 1),
(1225, 1, '40016', '不合法的按钮个数', '不合法的按钮个数', 1),
(1226, 1, '40015', '不合法的菜单类型', '不合法的菜单类型', 1),
(1227, 1, '40014', '不合法的 access_token ，请开发者认真比对 access_token 的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口', '不合法的 access_token ，请开发者认真比对 access_token 的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口', 1),
(1228, 1, '40013', '不合法的 AppID ，请开发者检查 AppID 的正确性，避免异常字符，注意大小写', '不合法的 AppID ，请开发者检查 AppID 的正确性，避免异常字符，注意大小写', 1),
(1229, 1, '40012', '不合法的缩略图文件大小', '不合法的缩略图文件大小', 1),
(1230, 1, '40011', '不合法的视频文件大小', '不合法的视频文件大小', 1),
(1231, 1, '40010', '不合法的语音文件大小', '不合法的语音文件大小', 1),
(1232, 1, '40009', '不合法的图片文件大小', '不合法的图片文件大小', 1),
(1233, 1, '40008', '不合法的消息类型', '不合法的消息类型', 1),
(1234, 1, '40007', '不合法的媒体文件 id', '不合法的媒体文件 id', 1),
(1235, 1, '40006', '不合法的文件大小', '不合法的文件大小', 1),
(1236, 1, '40005', '不合法的文件类型', '不合法的文件类型', 1),
(1237, 1, '40004', '不合法的媒体文件类型', '不合法的媒体文件类型', 1),
(1238, 1, '40003', '不合法的 OpenID ，请开发者确认 OpenID （该用户）是否已关注公众号，或是否是其他公众号的 OpenID', '不合法的 OpenID ，请开发者确认 OpenID （该用户）是否已关注公众号，或是否是其他公众号的 OpenID', 1),
(1239, 1, '40002', '不合法的凭证类型', '不合法的凭证类型', 1),
(1240, 1, '40001', '获取 access_token 时 AppSecret 错误，或者 access_token 无效。请开发者认真比对 AppSecret 的正确性，或查看是否正在为恰当的公众号调用接口', '获取 access_token 时 AppSecret 错误，或者 access_token 无效。请开发者认真比对 AppSecret 的正确性，或查看是否正在为恰当的公众号调用接口', 1),
(1241, 1, '200011', '此账号已被封禁，无法操作', '此账号已被封禁，无法操作', 1),
(1242, 1, '200012', '个人模版数已达上限，上限25个', '个人模版数已达上限，上限25个', 1),
(1243, 1, '200014', '请检查小程序所属类目', '请检查小程序所属类目', 1),
(1244, 2, '100000', '保存成功', 'Saved succeeded', 1),
(1245, 2, '100001', '修改成功', 'Modification successful', 1),
(1246, 2, '100002', '删除成功', 'Deletion succeeded', 1),
(1247, 2, '100003', '显示成功', 'Display successful', 1),
(1248, 2, '100004', '隐藏成功', 'Hidden successfully', 1),
(1249, 2, '100005', '操作失败', 'operation failed', 1),
(1250, 2, '100006', '保存失败', 'Save failed', 1),
(1251, 2, '100007', '修改失败', 'Modification failed', 1),
(1252, 2, '100008', '删除失败', 'Delete failed', 1),
(1253, 2, '100009', '图片上传成功', 'Picture uploaded successfully', 1),
(1254, 2, '100010', '操作成功', 'Operation successful', 1),
(1255, 2, '100011', '暂无数据', 'No data', 1),
(1256, 2, '100012', '更新成功', 'Update successful', 1),
(1257, 2, '100013', '更新失败', 'Update failed', 1),
(1258, 2, '100014', '设置成功', 'Set successfully', 1),
(1259, 2, '100015', '设置失败', 'Setting failed', 1),
(1260, 2, '100016', '获取失败', 'Get failed', 1),
(1261, 2, '100017', '提交成功', 'Submitted successfully', 1),
(1262, 2, '100018', '提交失败', 'Submit failed', 1),
(1263, 2, '100019', '取消成功', 'Cancellation succeeded', 1),
(1264, 2, '100020', '取消失败', 'Cancel failed', 1),
(1265, 2, '100021', '添加成功', 'Successfully added', 1),
(1266, 2, '100022', '添加失败', 'Add failed', 1),
(1267, 2, '100023', '保存token失败', 'Failed to save token', 1),
(1268, 2, '100024', '备注成功', 'Remarks successful', 1),
(1269, 2, '100025', '备注失败', 'Remarks failed', 1),
(1270, 2, '100026', '数据不存在', 'Data does not exist', 1),
(1271, 2, '100027', '申请成功', 'Successful application', 1),
(1272, 2, '100028', '申请失败', 'Application failed', 1),
(1273, 2, '100029', '暂无此方法', 'No such method', 1),
(1274, 2, '100030', '发送成功', 'Sent successfully', 1),
(1275, 2, '100031', '发送失败', 'fail in send', 1),
(1276, 2, '100032', '上传成功', 'Upload successful', 1),
(1277, 2, '100033', '上传失败', 'Upload failed', 1),
(1278, 2, '100034', '移动成功', 'Move successful', 1),
(1279, 2, '100035', '移动失败', 'Move failed', 1),
(1280, 2, '100036', '退款成功', 'Refund successful', 1),
(1281, 2, '100037', '退款失败', 'Refund failed', 1),
(1282, 2, '100038', '同步成功', 'Synchronization succeeded', 1),
(1283, 2, '100039', '同步失败', 'Synchronization failed', 1),
(1284, 2, '100040', '恢复成功', 'recovery was successful', 1),
(1285, 2, '100041', '恢复失败', 'restore failed', 1),
(1286, 2, '100042', '退出成功', 'Exit successful', 1),
(1287, 2, '100043', '退出失败', 'Exit failed', 1),
(1288, 2, '100044', '开通成功', 'Successfully opened', 1),
(1289, 2, '100045', '开通失败', 'Failed to open', 1),
(1290, 2, '100046', '清除数据成功', 'Data cleared successfully', 1),
(1291, 2, '100047', '优化成功', 'Optimization succeeded', 1),
(1292, 2, '100048', '优化失败', 'Optimization failed', 1),
(1293, 2, '100049', '修复成功', 'Repair successful', 1),
(1294, 2, '100050', '修复失败', 'Repair failed', 1),
(1295, 2, '100051', '备份成功', 'Backup successful', 1),
(1296, 2, '100052', '备份失败', 'Backup failed', 1),
(1297, 2, '100100', '参数错误', 'Parameter error', 1),
(1298, 2, '100101', '非法操作', 'Illegal operation', 1),
(1299, 2, '100102', '数据获取失败', 'Data acquisition failed', 1),
(1300, 2, '100103', '站点升级中，请稍候访问', 'Site upgrade in progress, please visit later', 1),
(1301, 2, '100104', '缺少code', 'Missing Code', 1),
(1302, 2, '110000', '您暂时没有访问权限', 'You do not have access right for the time being', 1),
(1303, 2, '110001', '接口未授权，您无法访问', 'The interface is not authorized and you cannot access it', 1),
(1304, 2, '110002', '请登录', 'Please login', 1),
(1305, 2, '110003', '登录已过期,请重新登录', 'Login has expired, please login again', 1),
(1306, 2, '110004', '登录状态有误,请重新登录', 'Login status error, please login again', 1),
(1307, 2, '110005', '请登录', 'Please login', 1),
(1308, 2, '110006', '登录已过期,请重新登录', 'Login has expired, please login again', 1),
(1309, 2, '110007', '登录状态有误,请重新登录', 'Login status error, please login again', 1),
(1310, 2, '400000', '请选择用户头像', 'Please select a user avatar', 1),
(1311, 2, '400001', '请填写用户昵称', 'Please fill in user nickname', 1),
(1312, 2, '400002', '请填写评论内容', 'Please fill in the comments', 1),
(1313, 2, '400003', '请选择商品分数', 'Please select a product score', 1),
(1314, 2, '400004', '请选择服务分数', 'Please select a service score', 1),
(1315, 2, '400005', '商品分数必须是1-5之间的整数', 'Product score must be an integer between 1-5', 1),
(1316, 2, '400006', '服务分数必须是1-5之间的整数', 'Service Score must be an integer between 1-5', 1),
(1317, 2, '400007', '请选择快递公司', 'Please select a courier company', 1),
(1318, 2, '400008', '请填写寄件人姓名', 'Please fill in the sender`s name', 1),
(1319, 2, '400009', '请输入寄件人手机号码', 'Please enter sender mobile number', 1),
(1320, 2, '400010', '寄件人手机号码不正确', 'Sender`s mobile number is incorrect', 1),
(1321, 2, '400011', '请填写寄件人详细地址', 'Please fill in the sender`s full address', 1),
(1322, 2, '400012', '请填写云打印机编号', 'Please fill in the cloud printer number', 1),
(1323, 2, '400013', '请传入套餐id', 'Please enter the package id', 1),
(1324, 2, '400014', '套餐id必须为数字', 'Package id must be a number', 1),
(1325, 2, '400015', '请填写套餐金额', 'Please fill in the package amount', 1),
(1326, 2, '400016', '请填写购买数量', 'Please fill in the purchase quantity', 1),
(1327, 2, '400017', '购买数量必须为数字', 'Purchase quantity must be a number', 1),
(1328, 2, '400018', '请填写购买套餐类型', 'Please fill in the purchase package type', 1),
(1329, 2, '400019', '您输入的手机号码必须为数字', 'The mobile number you enter must be numeric', 1),
(1330, 2, '400020', '密码必须填写', 'Password must be filled', 1),
(1331, 2, '400021', '短信验证码必须为数字', 'SMS verification code must be a number', 1),
(1332, 2, '400022', '请填写话术内容', 'Please fill in the content of the speech', 1),
(1333, 2, '400023', '请填写排序数字', 'Please fill in the order number', 1),
(1334, 2, '400024', '请填写排序数字', 'Please fill in the order number', 1),
(1335, 2, '400025', '请填写运费模板名称', 'Please fill in the shipping template name', 1),
(1336, 2, '400026', '运费信息必须为数组', 'Shipping information must be an array', 1),
(1337, 2, '400027', '包邮信息必须为数组', 'Free shipping information must be an array', 1),
(1338, 2, '400028', '不送达信息必须为数组', 'Undelivered message must be an array', 1),
(1339, 2, '400029', 'type数据格式错误，应为1或2或3', 'type data format error, should be 1 or 2 or 3', 1),
(1340, 2, '400030', 'appoint数据格式错误，应为0或1', 'appoint data format error，should be 0 or 1', 1),
(1341, 2, '400031', 'no_delivery数据格式错误，应为0或1', 'no_delivery data is malformed, should be 0 or 1', 1),
(1342, 2, '400032', 'sort数据格式错误，应为整数', 'sort data malformed, expected integer', 1),
(1343, 2, '400033', '请填写管理员账号', 'Please fill in the administrator account', 1),
(1344, 2, '400034', '管理员账号为英文字母', 'The administrator account is in English letters', 1),
(1345, 2, '400035', '请输管理员姓名', 'Please enter administrator name', 1),
(1346, 2, '400036', '请选择管理员身份', 'Please select administrator identity', 1),
(1347, 2, '400037', '身份必须为数组', 'Identity must be an array', 1),
(1348, 2, '400038', '请填写城市名称', 'Please fill in the city name', 1),
(1349, 2, '400039', 'level数据格式错误，应为整数', 'level data format error, should be an integer', 1),
(1350, 2, '400040', 'parent_id数据格式错误，应为整数', 'parent_id data is malformed, should be an integer', 1),
(1351, 2, '400041', '请输入有效的网址', 'Please enter a valid URL', 1),
(1352, 2, '400042', '一级返佣比例必须为数字', 'The first-level rebate ratio must be a number', 1),
(1353, 2, '400043', '一级返佣比例最多两位小数', 'The first-level rebate rate can be up to two decimal places', 1),
(1354, 2, '400044', '一级返佣比例填写范围在0-100之间', 'Fill in the first-level rebate ratio in the range of 0-100', 1),
(1355, 2, '400045', '二级返佣比例必须为数字', 'The second-level rebate ratio must be a number', 1),
(1356, 2, '400046', '二级返佣比例最多两位小数', 'The second-level rebate rate can be up to two decimal places', 1),
(1357, 2, '400047', '二级返佣比例填写范围在0-100之间', 'Fill in the second-level rebate ratio in the range of 0-100', 1),
(1358, 2, '400048', '待补货数量必须为数字', 'Quantity to be replenished must be a number', 1),
(1359, 2, '400049', '警戒库存必须为数字', 'Alert Inventory must be a number', 1),
(1360, 2, '400050', '提现最小金额只能为数字', 'The minimum withdrawal amount can only be a number', 1),
(1361, 2, '400051', '提现最小金额必须大于0', 'The minimum withdrawal amount must be greater than 0', 1),
(1362, 2, '400052', '佣金冻结时间范围在0-180之间', 'Commission freeze time range is between 0-180', 1),
(1363, 2, '400053', '满额分销金额金额必须为数字', 'Full distribution amount must be a number', 1),
(1364, 2, '400054', '积分抵用比例必须为数字', 'Points credit ratio must be a number', 1),
(1365, 2, '400055', '积分抵用比例最多两位小数', 'Points credit ratio can be up to two decimal places', 1),
(1366, 2, '400056', '积分抵用比例必须在0-1000之间', 'Points credit ratio must be between 0-1000', 1),
(1367, 2, '400057', '积分抵用上限必须为数字', 'Points credit limit must be a number', 1),
(1368, 2, '400058', '积分抵用上限必须大于等于0', 'The upper limit of points credit must be greater than or equal to 0', 1),
(1369, 2, '400059', '下单赠送积分必须为数字', 'The bonus points for placing an order must be a number', 1),
(1370, 2, '400060', '下单赠送积分必须在0-1000之间', 'The bonus points for placing an order must be between 0-1000', 1),
(1371, 2, '400061', '普通商品未支付取消订单时间必须为数字', 'General merchandise unpaid Cancellation time must be a number', 1),
(1372, 2, '400062', '活动商品未支付取消订单时间必须为数字', 'The event item is not paid, the cancellation order time must be a number', 1),
(1373, 2, '400063', '砍价商品未支付取消订单时间必须为数字', 'Bargained item not paidCancellation time must be a number', 1),
(1374, 2, '400064', '拼团商品未支付取消订单时间必须为数字', 'Group product not paidCancellation time must be a number', 1),
(1375, 2, '400065', '订单发货后自动收货时间必须为数字', 'Auto-receive time after order is shipped must be a number', 1),
(1376, 2, '400066', '满额包邮金额必须为数字', 'Full amount of free shipping must be a number', 1),
(1377, 2, '400067', '积分倍数必须大于0', 'The integral multiplier must be greater than 0', 1),
(1378, 2, '400068', '折扣数必须大于0', 'Discount number must be greater than 0', 1),
(1379, 2, '400069', '积分倍数必须大于0', 'The integral multiplier must be greater than 0', 1),
(1380, 2, '400070', '折扣数必须大于0', 'Discount number must be greater than 0', 1),
(1381, 2, '400071', '下单赠送经验比率必须为数字', 'Order gift experience ratio must be a number', 1),
(1382, 2, '400072', '下单赠送经验比率必须大于0', 'The reward experience ratio for placing an order must be greater than 0', 1),
(1383, 2, '400073', '签到赠送经验必须为数字', 'Sign-in gift experience must be digital', 1),
(1384, 2, '400074', '签到赠送经验必须大于0', 'Sign-in gift experience must be greater than 0', 1),
(1385, 2, '400075', '邀请新用户赠送经验必须为数字', 'Invite new users to give experience must be digital', 1),
(1386, 2, '400076', '邀请新用户赠送经验必须大于0', 'Invite new users to give experience must be greater than 0', 1),
(1387, 2, '400077', '发货人姓名必须为汉字', 'Shipper name must be in Chinese characters', 1),
(1388, 2, '400078', '发货人姓名长度在2-10位', 'The Shipper name should be 2-10 characters long', 1),
(1389, 2, '400079', '发货人电话必须为数字', 'Shipper phone must be a number', 1),
(1390, 2, '400080', '发货人电话请填写有效的手机号', 'Please fill in a valid mobile phone number for the Shipper phone number', 1),
(1391, 2, '400081', '发货人地址只能是汉字、字母、数字', 'Shipper address can only be Chinese characters, letters, numbers', 1),
(1392, 2, '400082', '发货人地址长度为10-100位', 'Shipper address length is 10-100 digits', 1),
(1393, 2, '400083', '电子面单打印机编号必须为数字、字母', 'The serial number of the electronic sheet printer must be numbers and letters', 1),
(1394, 2, '400084', '电子面单打印机编号长度为10-50位', 'The number length of the electronic single printer is 10-50 digits', 1),
(1395, 2, '400085', '客服反馈长度位10-90位', 'Customer service feedback length is 10-90', 1),
(1396, 2, '400086', '请填写标签分类名称', 'Please fill in the label category name', 1),
(1397, 2, '400087', '请填写标签分类排序', 'Please fill in the label sorting order', 1),
(1398, 2, '400088', '标签分类必须为数字', 'Label classification must be numeric', 1),
(1399, 2, '400089', '账号只能为数字和字母', 'Account numbers can only be numbers and letters', 1),
(1400, 2, '400090', '限量不能超过商品库存', 'The limit cannot exceed the product inventory', 1),
(1401, 2, '400091', '商品已下架或移入回收站', 'The item has been removed from the shelf or moved to the recycling bin', 1),
(1402, 2, '400092', '占用库存失败', 'Failed to occupy inventory', 1),
(1403, 2, '400093', '商品已下架或已删除', 'Product has been removed or deleted', 1),
(1404, 2, '400094', '请选择有效的商品属性', 'Please select a valid product attribute', 1),
(1405, 2, '400095', '金额不能小于0', 'Amount cannot be less than 0', 1),
(1406, 2, '400096', '结束时间不能小于今天', 'End time cannot be less than today', 1),
(1407, 2, '400097', '您不是付费会员', 'You are not a paid member', 1),
(1408, 2, '400098', '暂时无法领取', 'Temporarily unavailable', 1),
(1409, 2, '400099', '请先配置小票打印开发者', 'Please configure the receipt printing developer first', 1),
(1410, 2, '400100', '请填写分类名称', 'Please fill in the category name', 1),
(1411, 2, '400101', '该分类已存在', 'This category already exists', 1),
(1412, 2, '400102', '请先删除子分类', 'Please delete subcategories first', 1),
(1413, 2, '400103', '分类不存在', 'Category does not exist', 1),
(1414, 2, '400104', '文件名称不能为空', 'File name cannot be empty', 1),
(1415, 2, '400105', '该分类有下级分类，无法修改上级', 'This category has sub-categories and cannot modify the superior', 1),
(1416, 2, '400106', '备注不能为空', 'Remarks cannot be empty', 1),
(1417, 2, '400107', '请输入姓名', 'Please type in your name', 1),
(1418, 2, '400108', '请输入提现金额', 'Please enter the withdrawal amount', 1),
(1419, 2, '400109', '请输入支付宝账号', 'Please enter your Alipay account', 1),
(1420, 2, '400110', '请输入微信账号', 'Please enter your WeChat account', 1),
(1421, 2, '400111', '请输入银行卡号', 'Please enter bank card number', 1),
(1422, 2, '400112', '请输入开户行', 'Please enter the bank', 1),
(1423, 2, '400113', '拒绝理由不能为空', 'Rejection reason cannot be empty', 1),
(1424, 2, '400114', '不能重复收货', 'No duplicate receipts', 1),
(1425, 2, '400115', '请先发货或者送货', 'Please ship first or deliver', 1),
(1426, 2, '400116', '收货失败,请稍候再试', 'Receipt failed', 1),
(1427, 2, '400117', '收货成功', 'Goods received', 1),
(1428, 2, '400118', '订单不存在', 'Order does not exist', 1),
(1429, 2, '400119', '用户信息不存在', 'User information does not exist', 1),
(1430, 2, '400120', '快递单号不存在', 'The tracking number does not exist', 1),
(1431, 2, '400121', '打印成功', 'Print successfully', 1),
(1432, 2, '400122', '打印失败', 'Print failed', 1),
(1433, 2, '400123', '快递公司编号缺失', 'Courier number missing', 1),
(1434, 2, '400124', '请配置腾讯地图KEY', 'Please configure Tencent map KEY', 1),
(1435, 2, '400125', '请选择门店位置', 'Please select a store location', 1),
(1436, 2, '400126', '添加的核销员用户已存在', 'The added account user already exists', 1),
(1437, 2, '400127', '请选择所属提货点', 'Please select your pickup point', 1),
(1438, 2, '400128', '请填写核销员名称', 'Please fill in the name of the verification officer', 1),
(1439, 2, '400129', '请填写核销员电话', 'Please fill in the phone number of the verification officer', 1),
(1440, 2, '400130', '核销员添加成功', 'Verifier added successfully', 1),
(1441, 2, '400131', '核销员添加失败', 'Failed to add auditor', 1),
(1442, 2, '400132', '请填写手机号', 'Please fill in your phone number', 1),
(1443, 2, '400133', '请填写账号', 'Please fill in the account number', 1),
(1444, 2, '400134', '请填写密码', 'Please fill in the password', 1),
(1445, 2, '400135', '请填写短信签名', 'Please fill in the SMS signature', 1),
(1446, 2, '400136', '短信签名最长为8位', 'SMS signature can be up to 8 characters', 1),
(1447, 2, '400137', '请填写验证码', 'Please fill in the verification code', 1),
(1448, 2, '400138', '请填写域名', 'Please fill in the domain name', 1),
(1449, 2, '400139', '登录成功', 'Login successful', 1),
(1450, 2, '400140', '账号或密码错误', 'Incorrect username or password', 1),
(1451, 2, '400141', '请先填写短信配置', 'Please fill in the SMS configuration first', 1),
(1452, 2, '400142', '请输入模板名称', 'Please enter a template name', 1),
(1453, 2, '400143', '请输入模板内容', 'Please enter template content', 1),
(1454, 2, '400144', '售后订单状态不支持该操作', 'After-sales order status does not support this operation', 1),
(1455, 2, '400145', '修改退款状态成功', 'Modify the refund status successfully', 1),
(1456, 2, '400146', '请输入退款金额', 'Please enter the refund amount', 1),
(1457, 2, '400147', '已退完支付金额，不能再退款了', 'The payment amount has been refunded and cannot be refunded any more', 1),
(1458, 2, '400148', '退款金额大于支付金额，请修改退款金额', 'The refund amount is greater than the payment amount, please modify the refund amount', 1),
(1459, 2, '400149', '退款成功', 'Refund successfully', 1),
(1460, 2, '400150', '退款失败', 'Refund failed', 1),
(1461, 2, '400151', '验证成功', 'Verification succeeded', 1),
(1462, 2, '400152', '核销成功', 'Write-off successful', 1),
(1463, 2, '400153', '核销订单未查到', 'Verification order not found', 1),
(1464, 2, '400154', '核销失败', 'Write-off failed', 1),
(1465, 2, '400155', '订单金额必须填写', 'Order amount is required', 1),
(1466, 2, '400156', '请选择需要删除的订单', 'Please select the order to delete', 1),
(1467, 2, '400157', '您选择的的订单存在用户未删除的订单', 'The order you selected has an order that has not been deleted by the user', 1),
(1468, 2, '400158', '请选择发货商品', 'Please select an item to ship', 1),
(1469, 2, '400159', '请重新选择发货商品或发货件数', 'Please re-select the item to be shipped or the number of items to be shipped', 1),
(1470, 2, '400160', '订单已删除无法退积分', 'The order has been deleted and the points cannot be refunded', 1),
(1471, 2, '400161', '请输入积分', 'Please enter points', 1),
(1472, 2, '400162', '已退完积分', 'Points have been refunded', 1),
(1473, 2, '400163', '退积分大于支付积分，请修改退积分', 'The refund points are greater than the payment points, please modify the refund points', 1),
(1474, 2, '400164', '退积分成功', 'Successfully refunded points', 1),
(1475, 2, '400165', '退积分失败', 'Failed to refund points', 1),
(1476, 2, '400166', '请填写开票号', 'Please fill in the billing number', 1),
(1477, 2, '400167', '请填写正确的开票号', 'Please fill in the correct billing number', 1),
(1478, 2, '400168', '请上传文件', 'Please upload file', 1),
(1479, 2, '400169', '回复成功', 'Reply successful', 1),
(1480, 2, '400170', '注册成功', 'Registration success', 1),
(1481, 2, '400171', '注册失败', 'Registration failed', 1),
(1482, 2, '400172', '登录失败', 'Login failed', 1),
(1483, 2, '400173', '获取套餐列表失败', 'Failed to get plan list', 1),
(1484, 2, '400174', '获取支付码失败', 'Failed to get payment code', 1),
(1485, 2, '400175', '请先开通短信服务', 'Please activate the SMS service first', 1),
(1486, 2, '400176', '请先开通物流查询服务', 'Please activate the logistics inquiry service first', 1),
(1487, 2, '400177', '请先开通电子面单打印服务', 'Please activate the electronic receipt printing service first', 1),
(1488, 2, '400178', '请先开通商品采集服务', 'Please activate the product collection service first', 1),
(1489, 2, '400179', '请设置短信签名', 'Please set SMS signature', 1),
(1490, 2, '400180', '修改短信签名成功', 'Modified SMS Signature Successfully', 1),
(1491, 2, '400181', '默认模板不能删除', 'Default templates cannot be deleted', 1),
(1492, 2, '400182', '管理员信息读取失败', 'Failed to read administrator information', 1),
(1493, 2, '400183', '密码太过简单，请输入较为复杂的密码', 'The password is too simple, please enter a more complex password', 1),
(1494, 2, '400184', '协议类型不存在', 'Protocol type does not exist', 1),
(1495, 2, '400185', '清除成功', 'Cleared successfully', 1),
(1496, 2, '400186', '清除失败', 'Clear failed', 1),
(1497, 2, '400187', '请输入名称', 'Please enter a name', 1),
(1498, 2, '400188', '请不要重复添加', 'Please do not add', 1),
(1499, 2, '400189', '添加数据成功', 'Add data successfully', 1),
(1500, 2, '400190', '请输入开始时间', 'Please enter a start time', 1),
(1501, 2, '400191', '请输入持续时间', 'Please enter a duration', 1),
(1502, 2, '400192', '请输入0-23点之前的整点数', 'Please enter an integer number between 0-23 o`clock', 1),
(1503, 2, '400193', '请输入1-24点之前的整点数', 'Please enter an integer number between 1-24 o`clock', 1),
(1504, 2, '400194', '开始时间+持续时间不能大于24小时', 'Start time + duration cannot be greater than 24 hours', 1),
(1505, 2, '400195', '时段已占用', 'Time slot occupied', 1),
(1506, 2, '400196', '请输入签到赠送积分', 'Please enter the sign-in bonus points', 1),
(1507, 2, '400197', '请输入大于等于0的整数', 'Please enter an integer greater than or equal to 0', 1),
(1508, 2, '400198', '请填写按钮名称', 'Please fill in the button name', 1),
(1509, 2, '400199', '没有查到此身份', 'This identity was not found', 1),
(1510, 2, '400200', '请输入等级名称', 'Please enter a class name', 1),
(1511, 2, '400201', '请输入等级', 'Please enter level', 1),
(1512, 2, '400202', '请选择等级图标', 'Please select the level icon', 1),
(1513, 2, '400203', '二级返佣比例不能大于一级', 'The second-level rebate ratio cannot be greater than the first-level commission', 1),
(1514, 2, '400204', '当前等级已存在', 'The current level already exists', 1),
(1515, 2, '400205', '添加等级成功', 'Add level successfully', 1),
(1516, 2, '400206', '编辑的等级不存在', 'Edited level does not exist', 1),
(1517, 2, '400207', '请输入任务名称', 'Please enter a task name', 1),
(1518, 2, '400208', '请选择任务类型', 'Please select a task type', 1),
(1519, 2, '400209', '请输入限定数量', 'Please enter a limited quantity', 1),
(1520, 2, '400210', '添加任务成功', 'Added task successfully', 1),
(1521, 2, '400211', '编辑的任务不存在', 'Edited task does not exist', 1),
(1522, 2, '400212', '获取推广二维码失败，请检查您的微信配置', 'Failed to get promotion QR code, please check your WeChat configuration', 1),
(1523, 2, '400213', '上级推广人不能为自己', 'Higher-level promoters can`t do it for themselves', 1),
(1524, 2, '400214', '用户不存在', 'User does not exist', 1),
(1525, 2, '400215', '上级用户不存在', 'The superior user does not exist', 1),
(1526, 2, '400216', '当前推广人已经是所选人', 'The current promoter is already selected', 1),
(1527, 2, '400217', '上级推广人不能为自己下级', 'A superior promoter cannot be a subordinate for himself', 1),
(1528, 2, '400218', '赠送成功', 'The gift is successful', 1),
(1529, 2, '400219', '赠送失败', 'Gift failed', 1),
(1530, 2, '400220', '请输入身份名称', 'Please enter an identity', 1),
(1531, 2, '400221', '请选择最少一个权限', 'Please select at least one permission', 1),
(1532, 2, '400222', '添加身份成功', 'Successfully added identity', 1),
(1533, 2, '400223', '添加身份失败', 'Failed to add identity', 1),
(1534, 2, '400224', '缺少APPID', 'Missing APPID', 1),
(1535, 2, '400225', '请先设置空间域名', 'Please set the space domain name first', 1),
(1536, 2, '400226', '格式错误，请输入格式为：http://域名', 'The format is incorrect, please enter the format as: http://domain name', 1),
(1537, 2, '400227', '未有正在使用的存储空间', 'No storage space in use', 1),
(1538, 2, '400228', '切换云存储成功,请检查是否开启使用了存储空间', 'The switch to cloud storage is successful, please check whether the storage space is enabled', 1),
(1539, 2, '400229', '切换本地存储成功', 'Switch local storage successfully', 1),
(1540, 2, '400230', '请输入模板编号', 'Please enter template number', 1),
(1541, 2, '400231', '请输入模板编号已存在,请重新输入', 'Please enter the template number already exists, please re-enter', 1),
(1542, 2, '400232', '请输入模板ID', 'Please enter template ID', 1),
(1543, 2, '400233', '请输入模板名', 'Please enter a template name', 1),
(1544, 2, '400234', '请输入回复内容', 'Please enter a reply', 1),
(1545, 2, '400235', '添加模板消息成功', 'Add template message success', 1),
(1546, 2, '400236', '请先配置小程序appid、appSecret等参数', 'Please configure the applet appid, appSecret and other parameters first', 1),
(1547, 2, '400237', '二维码生成失败', 'QR code generation failed', 1),
(1548, 2, '400238', '请添加至少一个按钮', 'Please add at least one button', 1),
(1549, 2, '400239', '请输入关键字', 'Please enter key words', 1),
(1550, 2, '400240', '请选择回复类型', 'Please select a reply type', 1),
(1551, 2, '400241', '回复类型有误', 'Wrong reply type', 1),
(1552, 2, '400242', '回复消息参数有误', 'Reply message parameter is wrong', 1),
(1553, 2, '400243', '请添加图文', 'Please add graphic', 1),
(1554, 2, '400244', '标题不能为空', 'Title cannot be empty', 1),
(1555, 2, '400245', '作者不能为空', 'Author cannot be empty', 1),
(1556, 2, '400246', '正文不能为空', 'Body cannot be empty', 1),
(1557, 2, '400247', '摘要不能为空', 'Abstract cannot be empty', 1),
(1558, 2, '400248', '请先配置微信公众号appid、appSecret等参数', 'Please configure the applet appid, appSecret and other parameters first', 1),
(1559, 2, '400249', '模版消息一键设置成功', 'One-click setting of template message is successful', 1),
(1560, 2, '400250', '请选择用户', 'Please select a user', 1),
(1561, 2, '400251', '该用户没有绑定手机号，请手动填写', 'The user is not bound with a mobile phone number, please fill in manually', 1),
(1562, 2, '400252', '手机号格式错误', 'Malformed phone number', 1),
(1563, 2, '400253', '客服已存在', 'Customer service already exists', 1),
(1564, 2, '400254', '请输入账号', 'Please enter account', 1),
(1565, 2, '400255', '账号必须为数字或者字母的组合4-30位', 'The account number must be a combination of 4-30 digits or letters', 1),
(1566, 2, '400256', '请输入密码', 'Please enter password', 1),
(1567, 2, '400257', '密码必须为数字或者字母的组合6-20位', 'Password must be a combination of 6-20 digits or letters', 1),
(1568, 2, '400258', '该手机号的客服已存在', 'Customer service for this phone number already exists', 1),
(1569, 2, '400259', '该客服账号已存在', 'The customer service account already exists', 1),
(1570, 2, '400260', '客服添加成功', 'Customer service added successfully', 1),
(1571, 2, '400261', '客服添加失败', 'Customer service failed to add', 1),
(1572, 2, '400262', '客服名称不能为空', 'Customer service name cannot be empty', 1),
(1573, 2, '400263', '请输入确认密码', 'Please enter confirm password', 1),
(1574, 2, '400264', '两次输入的密码不一致', 'The two entered passwords do not match', 1),
(1575, 2, '400265', '用户不存在，客服将强制禁止登录', 'If the user does not exist, the customer service will forcibly prohibit the login', 1),
(1576, 2, '400266', '登录的客服不存在', 'The registered customer service does not exist', 1),
(1577, 2, '400267', '请先填写客服账号和密码再尝试进入客服平台', 'Please fill in the customer service account and password before trying to enter the customer service platform', 1),
(1578, 2, '400268', '反馈内容不存在', 'Feedback content does not exist', 1),
(1579, 2, '400269', '话术不能重复添加', 'Words cannot be added repeatedly', 1),
(1580, 2, '400270', '创建话术成功', 'Created words success', 1),
(1581, 2, '400271', '创建话术失败', 'Failed to create words', 1),
(1582, 2, '400272', '删除的话术不存在', 'Deleted words do not exist', 1),
(1583, 2, '400273', '系统分类不能删除', 'System categories cannot be deleted', 1),
(1584, 2, '400274', '请输入配置名称', 'Please enter a configuration name', 1),
(1585, 2, '400275', '请输入字段名称', 'Please enter a field name', 1),
(1586, 2, '400276', '请输入配置简介', 'Please enter a configuration profile', 1),
(1587, 2, '400277', '请输入文本框的宽度', 'Please enter the width of the text box', 1),
(1588, 2, '400278', '请输入正确的文本框的宽度', 'Please enter the correct width of the text box', 1),
(1589, 2, '400279', '请输入多行文本框的宽度', 'Please enter the width of the multiline text box', 1),
(1590, 2, '400280', '请输入多行文本框的高度', 'Please enter the height of the multiline text box', 1),
(1591, 2, '400281', '请输入正确的多行文本框的宽度', 'Please enter the correct width of the multiline text box', 1),
(1592, 2, '400282', '请输入正确的多行文本框的宽度', 'Please enter the correct width of the multiline text box', 1),
(1593, 2, '400283', '请输入配置参数', 'Please enter configuration parameters', 1),
(1594, 2, '400284', '添加配置成功', 'Add configuration successfully', 1),
(1595, 2, '400285', '一二级返佣比例不能大于100%', 'The first and second level rebate ratio cannot be greater than 100%', 1),
(1596, 2, '400286', '分销海报不能多于5张', 'No more than 5 distribution posters', 1),
(1597, 2, '400287', '提现最低金额只能为数字', 'The minimum withdrawal amount can only be a number', 1),
(1598, 2, '400288', '满额分销最低金额不能为空', 'Full distribution minimum amount cannot be empty', 1),
(1599, 2, '400289', '满额分销最低金额不能小于0', 'The minimum amount of full distribution cannot be less than 0', 1),
(1600, 2, '400290', '绑定有效期请填写正整数', 'Please fill in a positive integer for the binding validity period', 1),
(1601, 2, '400291', '请输入标题', 'Please enter a title', 1),
(1602, 2, '400292', '添加配置分类成功', 'Add configuration category successfully', 1),
(1603, 2, '400293', '存在下级配置，无法删除', 'Subordinate configuration exists and cannot be deleted', 1),
(1604, 2, '400294', '字段至少存在一个', 'At least one field exists', 1),
(1605, 2, '400295', '添加数据组成功', 'Add data group successfully', 1),
(1606, 2, '400296', '数据关键字已存在', 'Data key already exists', 1),
(1607, 2, '400297', '字段不能为空', 'Field cannot be empty', 1),
(1608, 2, '400298', '不能大于四个', 'No more than four', 1),
(1609, 2, '400299', '签到天数配置不能大于7天', 'The number of check-in days cannot be greater than 7 days', 1),
(1610, 2, '400300', '关联成功', 'Association successful', 1),
(1611, 2, '400301', '关联失败', 'Association failed', 1),
(1612, 2, '400302', '数据缓存刷新成功', 'Data cache refreshed successfully', 1),
(1613, 2, '400303', '数据缓存刷新失败', 'Data cache refreshed failed', 1),
(1614, 2, '400304', '请输入需要更换的域名', 'Please enter the domain name that needs to be changed', 1),
(1615, 2, '400305', '域名不合法', 'Invalid domain name', 1),
(1616, 2, '400306', '替换成功', 'Replacement succeeded', 1),
(1617, 2, '400307', '初始化完成', 'Loading finished', 1),
(1618, 2, '400308', '备份文件可能已经损坏，请检查', 'The backup file may be corrupted', 1),
(1619, 2, '400309', '还原数据出错', 'Error restoring data', 1),
(1620, 2, '400310', '正在还原...', 'Restoring...', 1),
(1621, 2, '400311', '还原完成', 'Restore complete', 1),
(1622, 2, '400312', '权益编辑成功', 'Benefit Editing Successfully', 1),
(1623, 2, '400313', '卡片生成成功', 'Card generated successfully', 1),
(1624, 2, '400314', '手机号已经存在', 'Mobile number already exists', 1),
(1625, 2, '400315', '请输入正确的身份证', 'Please enter the correct ID', 1),
(1626, 2, '400316', '请选择分组', 'Please select a group', 1),
(1627, 2, '400317', '请选择标签', 'Please select a label', 1),
(1628, 2, '400318', '加入消息队列成功', 'Join the message queue successfully', 1),
(1629, 2, '400319', '注销成功', 'Cancellation succeeded', 1),
(1630, 2, '400320', '拒绝注销', 'Account refused to cancel', 1),
(1631, 2, '400321', '请输入分组名称', 'Please enter a group name', 1),
(1632, 2, '400322', '会员标签不能为空', 'Member tag cannot be empty', 1),
(1633, 2, '400323', '该分类下有标签，请先删除标签', 'There are tags in this category, please delete the tags first', 1),
(1634, 2, '400324', '请输入等级名称', 'Please enter a class name', 1),
(1635, 2, '400325', '请输入等级', 'Please enter level', 1),
(1636, 2, '400326', '请输入等级说明', 'Please enter a level description', 1),
(1637, 2, '400327', '请上传等级图标', 'Please upload a rating icon', 1),
(1638, 2, '400328', '请上传等级背景图标', 'Please upload the level background icon', 1),
(1639, 2, '400329', '请输入升级经验值', 'Please enter upgrade experience', 1),
(1640, 2, '400330', '授权成功，写入数据库失败，请检查数据库链接配置', 'Authorization succeeded, but failed to write to the database, please check the database link configuration', 1),
(1641, 2, '400331', '请填写公司名称', 'Please fill in the company name', 1),
(1642, 2, '400332', '请填写授权域名', 'Please fill in the authorized domain name', 1),
(1643, 2, '400333', '请填写手机号码', 'Please fill in cell phone number', 1),
(1644, 2, '400334', '请填写订单id', 'Please fill in the order id', 1),
(1645, 2, '400335', '申请授权成功', 'Application for authorization is successful', 1),
(1646, 2, '400336', '验证码错误', 'Verification code error', 1),
(1647, 2, '400337', '请选择商品', 'Please select a product', 1),
(1648, 2, '400338', '请输入商品名称', 'Please enter product name', 1),
(1649, 2, '400339', '请选择背景图', 'Please select a background image', 1),
(1650, 2, '400340', '请输入直播价格', 'Please enter live price', 1),
(1651, 2, '400341', '直播价格必须大于0', 'Live price must be greater than 0', 1),
(1652, 2, '400342', '请输入直播间名称', 'Please enter the live room name', 1),
(1653, 2, '400343', '请选择背景图', 'Please select a background image', 1),
(1654, 2, '400344', '请选择分享图', 'Please select a shared image', 1),
(1655, 2, '400345', '请选择主播', 'Please select an anchor', 1),
(1656, 2, '400346', '请选择直播开始、结束时间', 'Please select the start and end time of the live broadcast', 1),
(1657, 2, '400347', '请填写活动简介', 'Please fill in the event introduction', 1),
(1658, 2, '400348', '请填写单位', 'Please fill in the unit', 1),
(1659, 2, '400349', '请选择商品轮播图', 'Please select a product carousel', 1),
(1660, 2, '400350', '您设置得商品个数超出系统限制', 'The number of products you set exceeds the system limit', 1),
(1661, 2, '400351', '模板不存在', 'Template does not exist', 1),
(1662, 2, '400352', '请输入页面名称', 'Please enter a page name', 1),
(1663, 2, '400353', '请选择活动时间段', 'Please select an event time period', 1),
(1664, 2, '400354', '请填写购买数量限制', 'Please fill in the purchase quantity limit', 1),
(1665, 2, '400355', '购买数量限制必须大于0', 'Purchase quantity limit must be greater than 0', 1),
(1666, 2, '400356', '请填写帮砍次数', 'Please fill in the number of cuts', 1),
(1667, 2, '400357', '帮砍次数必须大于0', 'The number of assists must be greater than 0', 1),
(1668, 2, '400358', '请填写砍价人数', 'Please fill in the number of people who haggle', 1),
(1669, 2, '400359', '砍价人数必须大于1', 'The number of bidders must be greater than 1', 1),
(1670, 2, '400360', '请选择运费模板', 'Please select a shipping template', 1),
(1671, 2, '400361', '请填写商品详情', 'Please fill in the product details', 1),
(1672, 2, '400362', '请选择规格', 'Please select a specification', 1),
(1673, 2, '400363', '请填写虚拟拼团比例', 'Please fill in the virtual group ratio', 1),
(1674, 2, '400364', '虚拟参团人数不能大于成团人数', 'The number of virtual participants cannot be greater than the number of participants', 1),
(1675, 2, '400365', '虚拟参团人数不能大于成团人数', 'The number of virtual participants cannot be greater than the number of participants', 1),
(1676, 2, '400366', '请填写单次购买数量', 'Please fill in the single purchase quantity', 1),
(1677, 2, '400367', '单次购买数量必须大于0', 'A single purchase quantity must be greater than 0', 1),
(1678, 2, '400368', '请填写成团人数', 'Please fill in the number of people in the group', 1),
(1679, 2, '400369', '拼团人数不能小于2人', 'The number of people in the group cannot be less than 2 people', 1),
(1680, 2, '400370', '请填写成团有效期', 'Please fill in the group expiry date', 1),
(1681, 2, '400371', '成团有效期必须大于0', 'The validity period of the group must be greater than 0', 1),
(1682, 2, '400372', '请填写优惠券名称', 'Please fill in the coupon name', 1),
(1683, 2, '400373', '请选择商品分类', 'Please select product category', 1),
(1684, 2, '400374', '请填写优惠券金额', 'Please fill in the coupon amount', 1),
(1685, 2, '400375', '请填写优惠券最小使用金额', 'Please fill in the minimum coupon usage amount', 1),
(1686, 2, '400376', '请填写优惠券有效期', 'Please fill in the coupon validity period', 1),
(1687, 2, '400377', '请选择秒杀时间段', 'Please select a seckill time period', 1),
(1688, 2, '400378', '请填写门店名称', 'Please fill in the store name', 1),
(1689, 2, '400379', '请填写门店简介', 'Please fill in the store introduction', 1),
(1690, 2, '400380', '请填写门店电话', 'Please fill in the store phone number', 1),
(1691, 2, '400381', '请选择提货点logo', 'Please select the pickup point logo', 1),
(1692, 2, '400382', '请选择提货点大图', 'Please select the pickup point for larger image', 1),
(1693, 2, '400383', '请选择地址', 'Please select an address', 1),
(1694, 2, '400384', '请填写详细地址', 'Please fill in the detailed address', 1),
(1695, 2, '400385', '请选择经纬度', 'Please select latitude and longitude', 1),
(1696, 2, '400386', '请选择营业时间', 'Please select business hours', 1),
(1697, 2, '400387', '短信账号必须填写', 'SMS account is required', 1),
(1698, 2, '400388', '短信密码必须填写', 'SMS password must be filled', 1),
(1699, 2, '400389', '订单号必须存在', 'Order number must exist', 1),
(1700, 2, '400390', '订单号有误', 'Wrong order number', 1),
(1701, 2, '400391', '订单号必须为字母和数字', 'Order number must be alphanumeric', 1),
(1702, 2, '400392', '订单金额必须填写', 'Order amount is required', 1),
(1703, 2, '400393', '订单金额必须为数字', 'Order amount must be a number', 1),
(1704, 2, '400394', '订单金额必须填写', 'Order amount is required', 1),
(1705, 2, '400395', '订单金额必须为数字', 'Order amount must be a number', 1),
(1706, 2, '400396', '订单邮费必须填写', 'Order postage must be filled', 1),
(1707, 2, '400397', '订单邮费必须为数字', 'Order postage must be a number', 1),
(1708, 2, '400398', '赠送积分必须为数字', 'Gift points must be numbers', 1),
(1709, 2, '400399', '请选择用户头像', 'Please select a user avatar', 1),
(1710, 2, '400400', '请输入公司名称', 'Please enter company name', 1),
(1711, 2, '400401', '添加公司成功', 'Add company successfully', 1),
(1712, 2, '400402', '请输入月结账号', 'Please enter monthly account number', 1),
(1713, 2, '400403', '请输入月结密码', 'Please enter monthly password', 1),
(1714, 2, '400404', '请输入取件网点', 'Please enter the pickup location', 1),
(1715, 2, '400405', '缩略图大图尺寸（高）必须为数字', 'Thumbnail large size (height) must be a number', 1),
(1716, 2, '400406', '缩略图大图尺寸（高）必须大于等于0', 'Thumbnail large image size (height) must be greater than or equal to 0', 1),
(1717, 2, '400407', '缩略图大图尺寸（宽）必须为数字', 'Thumbnail large size (width) must be a number', 1),
(1718, 2, '400408', '缩略图大图尺寸（宽）必须大于等于0', 'Thumbnail large image size (width) must be greater than or equal to 0', 1),
(1719, 2, '400409', '缩略图中图尺寸（高）必须为数字', 'The image size (height) in the thumbnail must be a number', 1),
(1720, 2, '400410', '缩略图中图尺寸（高）必须大于等于0', 'The image size (height) in the thumbnail must be greater than or equal to 0', 1),
(1721, 2, '400411', '缩略图中图尺寸（宽）必须为数字', 'The image size (width) in the thumbnail must be a number', 1),
(1722, 2, '400412', '缩略图中图尺寸（宽）必须大于等于0', 'The image size (width) in the thumbnail must be greater than or equal to 0', 1),
(1723, 2, '400413', '缩略图小图尺寸（高）必须为数字', 'Thumbnail size (height) must be a number', 1),
(1724, 2, '400414', '缩略图小图尺寸（高）必须大于等于0', 'Thumbnail size (height) must be greater than or equal to 0', 1),
(1725, 2, '400415', '缩略图小图尺寸（宽）必须为数字', 'Thumbnail size (width) must be a number', 1),
(1726, 2, '400416', '缩略图小图尺寸（宽）必须大于等于0', 'Thumbnail size (width) must be greater than or equal to 0', 1),
(1727, 2, '400417', '水印文字只能是汉字、字母、数字', 'Watermark text can only be Chinese characters, letters, numbers', 1),
(1728, 2, '400418', '水印文字长度为1-10位', 'Watermark text length is 1-10 digits', 1),
(1729, 2, '400419', '水印文字大小必须为数字', 'Watermark text size must be numeric', 1),
(1730, 2, '400420', '水印文字大小必须大于等于0', 'The watermark text size must be greater than or equal to 0', 1),
(1731, 2, '400421', '水印横坐标偏移量必须为数字', 'The watermark abscissa offset must be a number', 1),
(1732, 2, '400422', '水印横坐标偏移量必须大于等于0', 'The watermark abscissa offset must be greater than or equal to 0', 1),
(1733, 2, '400423', '水印纵坐标偏移量必须为数字', 'The watermark ordinate offset must be a number', 1),
(1734, 2, '400424', '水印纵坐标偏移量必须大于等于0', 'The watermark ordinate offset must be greater than or equal to 0', 1),
(1735, 2, '400425', '该主播已经存在', 'The anchor already exists', 1),
(1736, 2, '400426', '请先去小程序认证主播', 'Please go to the applet to authenticate the anchor first', 1),
(1737, 2, '400427', '商品已创建', 'Product has been created', 1),
(1738, 2, '400428', '审核中或审核失败不允许此操作', 'This operation is not allowed under review or review failed', 1),
(1739, 2, '400429', '在审核中或已经审核通过', 'Under review or approved', 1),
(1740, 2, '400430', '审核通过或失败', 'Approval passed or failed', 1),
(1741, 2, '400431', '商品审核中，无法删除', 'The product is under review and cannot be deleted', 1),
(1742, 2, '400432', '该主播不存在', 'The anchor does not exist', 1),
(1743, 2, '400433', '开播时间需要在当前时间的10分钟后，并且开始时间不能在6个月后', 'The start time needs to be 10 minutes after the current time, and the start time cannot be 6 months later', 1),
(1744, 2, '400434', '开播时间和结束时间间隔不得短于30分钟，不得超过24小时', 'The interval between the start time and end time shall not be less than 30 minutes and shall not exceed 24 hours', 1),
(1745, 2, '400435', '请输入理由', 'Please enter a reason', 1),
(1746, 2, '400436', '请选择正确的直播商品', 'Please select the correct live product', 1),
(1747, 2, '400437', '直播间状态有误', 'The status of the live room is wrong', 1),
(1748, 2, '400438', '奖品不存在', 'Prize does not exist', 1),
(1749, 2, '400439', '写入中奖记录失败', 'Failed to write winning record', 1),
(1750, 2, '400440', '请继续参与活动抽奖', 'Please continue to participate in the lucky draw', 1),
(1751, 2, '400441', '已经领取成功', 'Received successfully', 1),
(1752, 2, '400442', '分销等级不存在', 'Distribution level does not exist', 1),
(1753, 2, '400443', '选择的等级不存在', 'The selected level does not exist', 1),
(1754, 2, '400444', '该等级已存在此类型任务', 'This type of task already exists at this level', 1),
(1755, 2, '400445', '不能小于低等级同类型任务限定数量', 'Can`t be less than the limited number of low-level tasks of the same type', 1),
(1756, 2, '400446', '不能大于高等级同类型任务限定数量', 'Can`t be larger than the limited number of high-level tasks of the same type', 1),
(1757, 2, '400447', '解除失败', 'Unable to fail', 1),
(1758, 2, '400448', '代理商佣金比例不能大于事业部佣金比例', 'The agent`s commission ratio cannot be greater than the division`s commission ratio', 1),
(1759, 2, '400449', '代理商到期时间不能大于事业部到期时间', 'The expiration time of the agent cannot be greater than the expiration time of the business department', 1),
(1760, 2, '400450', '请填写用户UID', 'Please fill in User UID', 1),
(1761, 2, '400451', '管理员信息未查到', 'Administrator information not found', 1),
(1762, 2, '400452', '管理员已经删除', 'Administrator has been removed', 1),
(1763, 2, '400453', '管理员姓名不能为空', 'Administrator name cannot be empty', 1),
(1764, 2, '400454', '该分类有下级分类，无法删除', 'This category has sub-categories and cannot be deleted', 1),
(1765, 2, '400455', '该分类下有文章，无法删除', 'There are articles in this category and cannot be deleted', 1),
(1766, 2, '400456', '请稍后查看', 'Please check back later', 1),
(1767, 2, '400457', '默认模板不能删除', 'Default templates cannot be deleted', 1),
(1768, 2, '400458', '该模板使用中，无法删除', 'The template is in use and cannot be deleted', 1),
(1769, 2, '400459', '个人中心模板不存在', 'Personal center template does not exist', 1),
(1770, 2, '400460', '反馈内容没有查到', 'Feedback not found', 1),
(1771, 2, '400461', '您修改的话术内容不存在', 'The content of your modified words does not exist', 1),
(1772, 2, '400462', '短信平台：{:msg}', 'SMS platform：{:msg}', 1),
(1773, 2, '400463', '订单商品获取失败,无法打印', 'Failed to get the order item and cannot print', 1),
(1774, 2, '400464', '小票打印未开启', 'Receipt printing is not enabled', 1),
(1775, 2, '400465', '请先配置小票打印开发者', 'Please configure the receipt printing developer first', 1),
(1776, 2, '400466', '请选择图片', 'Please select an image', 1),
(1777, 2, '400467', '配送员已存在', 'Shipper already exists', 1),
(1778, 2, '400468', '同一个手机号的配送员只能添加一个', 'The courier with the same mobile number can only add one', 1),
(1779, 2, '400469', '配送员名称不能为空', 'Shipper name cannot be empty', 1),
(1780, 2, '400470', '订单未能查到,不能发货', 'The order could not be found and cannot be shipped', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(1781, 2, '400471', '订单已删除,不能发货', 'The order has been deleted and cannot be shipped', 1),
(1782, 2, '400472', '订单已发货请勿重复操作', 'The order has been shipped, please do not repeat the operation', 1),
(1783, 2, '400473', '核销订单不能发货', 'Verified order cannot be shipped', 1),
(1784, 2, '400474', '拼团未完成暂不能发货', 'The grouping has not been completed and cannot be shipped temporarily', 1),
(1785, 2, '400475', '订单有售后申请请先处理', 'There is an after-sales application for the order, please process it first', 1),
(1786, 2, '400476', '快递公司编缺失', 'Courier company code missing', 1),
(1787, 2, '400477', '请填写寄件人电话', 'Please enter sender phone number', 1),
(1788, 2, '400478', '请填写寄件人地址', 'Please fill in the sender`s address', 1),
(1789, 2, '400479', '虚拟发货，无需修改发货信息', 'Virtual shipping, no need to modify shipping information', 1),
(1790, 2, '400480', '未发货，请先发货再修改配送信息', 'Not shipped, please ship first and then modify the shipping information', 1),
(1791, 2, '400481', '自提订单无法打印', 'Pick-up orders cannot be printed', 1),
(1792, 2, '400482', '请先发货', 'Please ship first', 1),
(1793, 2, '400483', '请先在系统设置中打开单子面单打印开关', 'Please turn on the single-sided single-sided printing switch in the system settings first', 1),
(1794, 2, '400484', '发票已申请，正在审核打印中', 'The invoice has been applied for and is being reviewed and printed', 1),
(1795, 2, '400485', '订单已退款', 'Order has been refunded', 1),
(1796, 2, '400486', '正在申请退款中', 'Applying for a refund', 1),
(1797, 2, '400487', '申请失败', 'Application failed', 1),
(1798, 2, '400488', '未支付无法退款', 'Unpaid non-refundable', 1),
(1799, 2, '400489', '回退积分和优惠券失败', 'Failed to roll back points and coupons', 1),
(1800, 2, '400490', '拼团修改失败', 'Group modification failed', 1),
(1801, 2, '400491', '回退佣金失败', 'Failed to roll back commission', 1),
(1802, 2, '400492', '余额退款失败', 'Balance refund failed', 1),
(1803, 2, '400493', '购买的优惠券已使用或者已过期', 'The purchased coupon has been used or has expired', 1),
(1804, 2, '400494', '回退积分增加失败', 'Failed to increase rollback points', 1),
(1805, 2, '400495', '售后订单不存在', 'After-sales order does not exist', 1),
(1806, 2, '400496', '积分已退或者积分为零无法再退', 'Points have been refunded or points are zero and cannot be refunded', 1),
(1807, 2, '400497', '未支付无法退积分', 'Unpaid points cannot be refunded', 1),
(1808, 2, '400498', '订单退积分失败', 'Order refund failed', 1),
(1809, 2, '400499', '请输入拒绝退款理由', 'Please enter the reason for rejecting the refund', 1),
(1810, 2, '400500', '限制单次购买数量不能大于总购买数量', 'Limit a single purchase quantity cannot be greater than the total purchase quantity', 1),
(1811, 2, '400501', '请添加抽奖活动名称', 'Please add the name of the raffle', 1),
(1812, 2, '400502', '请添加抽奖描述等文案', 'Please add a description of the lottery', 1),
(1813, 2, '400503', '活动结束时间必须大于开始时间', 'Event end time must be greater than start time', 1),
(1814, 2, '400504', '请添加奖品', 'Please add a prize', 1),
(1815, 2, '400505', '请填写消耗数量', 'Please fill in the consumption quantity', 1),
(1816, 2, '400506', '商品参与其他活动开启，无法开启预售', 'The product participates in other activities to open, and the pre-sale cannot be opened', 1),
(1817, 2, '400507', '活动结束时间不能小于当前时间', 'The event end time cannot be less than the current time', 1),
(1818, 2, '400508', '活动已结束,请重新添加或复制', 'The event has ended, please add or copy again', 1),
(1819, 2, '400509', '添加优惠券成功', 'Coupon added successfully', 1),
(1820, 2, '400510', '发布优惠劵成功', 'Coupon issued successfully', 1),
(1821, 2, '400511', '砍价最低价不能大于或等于起始金额', 'The minimum bargain price cannot be greater than or equal to the starting amount', 1),
(1822, 2, '400512', '砍价人数不能大于{:num}人', 'The number of people who haggle cannot be greater than {:num}', 1),
(1823, 2, '400513', '使用开始时间不能小于领取开始时间', 'The use start time cannot be less than the collection start time', 1),
(1824, 2, '400514', '使用结束时间不能小于领取结束时间', 'The use end time cannot be less than the collection end time', 1),
(1825, 2, '400515', '优惠券不存在', 'Coupon does not exist', 1),
(1826, 2, '400516', '领取的优惠劵已领完或已过期', 'The coupons received have been received or have expired', 1),
(1827, 2, '400517', '已领取过该优惠劵', 'The coupon has been received', 1),
(1828, 2, '400518', '抱歉，优惠券已经领取完了', 'Sorry, the coupons have been collected', 1),
(1829, 2, '400519', '选择用户已拥有该优惠券，请勿重复发放', 'Select the user who already owns the coupon, please do not issue it repeatedly', 1),
(1830, 2, '400520', '订单已删除', 'Order deleted', 1),
(1831, 2, '400521', '订单已发货', 'Order has been shipped', 1),
(1832, 2, '400522', '暂时不支持其他发货类型', 'other delivery types are not supported temporarily', 1),
(1833, 2, '400523', '请输入送货人姓名', 'Please enter the name of the delivery person', 1),
(1834, 2, '400524', '请输入送货人电话号码', 'Please enter the phone number of the delivery person', 1),
(1835, 2, '400525', '请输入送货人信息', 'Please enter the delivery person information', 1),
(1836, 2, '400526', '请输入正确的送货人电话号码', 'Please enter the correct delivery person`s phone number', 1),
(1837, 2, '400527', '请选择电子面单模板', 'Please select the template of electronic face slip', 1),
(1838, 2, '400528', '电子面单已关闭，请选择其他发货方式', 'The electronic bill has been closed, please choose another shipping method', 1),
(1839, 2, '400529', '发货失败', 'Shipment failed', 1),
(1840, 2, '400530', '订单状态错误', 'Order status error', 1),
(1841, 2, '400531', '请输入快递单号', 'Please enter the courier number', 1),
(1842, 2, '400532', '请先发货再修改配送信息', 'Please ship first and then modify the delivery information', 1),
(1843, 2, '400533', '商品不存在', 'Commodity does not exist', 1),
(1844, 2, '400534', '您查看的积分商品已被删除', 'The point product you viewed has been deleted', 1),
(1845, 2, '400535', '请添加商品', 'Please add a product', 1),
(1846, 2, '400536', '添加抽奖活动失败', 'Failed to add lottery event', 1),
(1847, 2, '400537', '抽奖活动不存在', 'The lottery does not exist', 1),
(1848, 2, '400538', '请填写奖品名称', 'Please fill in the name of the prize', 1),
(1849, 2, '400539', '请选择奖品图片', 'Please select the prize picture', 1),
(1850, 2, '400540', '请填写奖品中奖权重', 'Please fill in the prize winning weight', 1),
(1851, 2, '400541', '请选择奖品类型', 'Please select the type of prize', 1),
(1852, 2, '400542', '请填写奖品赠送{:type}数', 'Please fill in the {:type} number of prizes given', 1),
(1853, 2, '400543', '请选择优惠券', 'Please select a coupon', 1),
(1854, 2, '400544', '生成新订单失败', 'Failed to generate new order', 1),
(1855, 2, '400545', '修改原来订单商品拆分状态失败', 'Failed to modify the original order item split status', 1),
(1856, 2, '400546', '新增拆分订单商品信息失败', 'Failed to add product information for split order', 1),
(1857, 2, '400547', '保存新订单商品信息失败', 'Failed to save new order product information', 1),
(1858, 2, '400548', '协议类型缺失', 'Protocol type missing', 1),
(1859, 2, '400549', '请填写协议名称', 'Please fill in the agreement name', 1),
(1860, 2, '400550', '请填写协议内容', 'Please fill in the content of the agreement', 1),
(1861, 2, '400551', '该类型协议已经存在', 'This type of protocol already exists', 1),
(1862, 2, '400552', '临时二维码获取错误', 'Temporary QR code acquisition error', 1),
(1863, 2, '400553', '永久二维码获取错误', 'Permanent QR code acquisition error', 1),
(1864, 2, '400554', '请先配置接口密钥', 'Please configure the interface key first', 1),
(1865, 2, '400555', '无法创建文件夹，请检查您的上传目录权限', 'Unable to create folder, please check your upload directory permission', 1),
(1866, 2, '400556', '商品参数错误', 'Commodity parameter error', 1),
(1867, 2, '400557', '上传方式错误', 'The upload method is wrong', 1),
(1868, 2, '400558', '格式错误', 'Format error', 1),
(1869, 2, '400559', '图片流获取失败', 'Failed to get image stream', 1),
(1870, 2, '400560', '商品详情保存失败', 'Failed to save product details', 1),
(1871, 2, '400561', '关联优惠券失败', 'Failed to associate coupon', 1),
(1872, 2, '400562', '缺少商品ID', 'Missing product ID', 1),
(1873, 2, '400563', '缺少用户UID', 'Missing user UID', 1),
(1874, 2, '400564', '缺少订单ID', 'Missing order ID', 1),
(1875, 2, '400565', '暂不支持该类型记录', 'This type of record is not currently supported', 1),
(1876, 2, '400566', '添加商品记录失败', 'Failed to add product record', 1),
(1877, 2, '400567', '评论时间应小于当前时间', 'The comment time should be less than the current time', 1),
(1878, 2, '400568', '添加虚拟评论失败', 'Failed to add virtual comment', 1),
(1879, 2, '400569', '回复失败', 'Reply failed', 1),
(1880, 2, '400570', '请选择限购类型', 'Please select the type of purchase restriction', 1),
(1881, 2, '400571', '限购数量不能小于1', 'The purchase limit cannot be less than 1', 1),
(1882, 2, '400572', '一二级返佣相加不能大于商品售价', 'The sum of the first and second level rebates cannot be greater than the price of the product', 1),
(1883, 2, '400573', '商品类型不能切换', 'The product type cannot be switched', 1),
(1884, 2, '400574', '请输入规则名称', 'Please enter the rule name', 1),
(1885, 2, '400575', '请输入属性名称', 'Please enter the attribute name', 1),
(1886, 2, '400576', '请输入正确的属性', 'Please enter the correct attribute', 1),
(1887, 2, '400577', '请填写正确的商品信息', 'Please fill in the correct product information', 1),
(1888, 2, '400578', '请填写正确的商品价格', 'Please fill in the correct product price', 1),
(1889, 2, '400579', '请填写正确的商品库存', 'Please fill in the correct product inventory', 1),
(1890, 2, '400580', '请填写正确的商品成本价格', 'Please fill in the correct commodity cost price', 1),
(1891, 2, '400581', '请上传商品图片', 'Please upload the product picture', 1),
(1892, 2, '400582', '{:name}规格不存在', '{:name} specification does not exist', 1),
(1893, 2, '400583', '{:name}属性不存在', '{:name} attribute does not exist', 1),
(1894, 2, '400584', '请设置至少一个属性', 'Please set at least one attribute', 1),
(1895, 2, '400585', '商品参与秒杀活动开启，无法进行此操作', 'Commodity participation in spike activity is enabled, this operation cannot be performed', 1),
(1896, 2, '400586', '商品参与砍价活动开启，无法进行此操作', 'Commodity participation in bargaining is enabled, this operation cannot be performed', 1),
(1897, 2, '400587', '商品参与拼团活动开启，无法进行此操作', 'Commodity participation in group activity is enabled, this operation cannot be performed', 1),
(1898, 2, '400588', '会员价格不能为0', 'The member price cannot be 0', 1),
(1899, 2, '400589', '虚拟优惠券商品请选择优惠券', 'Please select a coupon for virtual coupon products', 1),
(1900, 2, '400590', '卡号：{:key}密码：{:value}，已经添加过，请重新添加卡密', 'Card number: {:key} Password: {:value}, it has been added, please add the card key again', 1),
(1901, 2, '400591', '缺少城市id无法保存', 'The city id is missing and cannot be saved', 1),
(1902, 2, '400592', '修改的模板不存在', 'The modified template does not exist', 1),
(1903, 2, '400593', '指定区域邮费添加失败', 'Failed to add postage in the specified area', 1),
(1904, 2, '400594', '管理员不存在', 'Administrator does not exist', 1),
(1905, 2, '400595', '您已被禁止登录', 'You have been banned from logging in', 1),
(1906, 2, '400596', '管理员账号已存在', 'Administrator account already exists', 1),
(1907, 2, '400597', '原始密码错误', 'Original password error', 1),
(1908, 2, '400598', '请输入新密码', 'Please enter a new password', 1),
(1909, 2, '400599', '请选择要删除的图片', 'Please select the picture to delete', 1),
(1910, 2, '400600', '移动失败或不能重复移动到同一分类下', 'Move failed or cannot be moved to the same category repeatedly', 1),
(1911, 2, '400601', '请求不被允许', 'The request is not allowed', 1),
(1912, 2, '400602', '设置类目不被允许', 'Setting category is not allowed', 1),
(1913, 2, '400603', '请输入正确格式的配置参数', 'Please enter the configuration parameters in the correct format', 1),
(1914, 2, '400604', '{:name}请输入默认值', '{:name} please enter the default value', 1),
(1915, 2, '400605', '{:name}请输入正确url', '{:name} please enter the correct url', 1),
(1916, 2, '400606', '保存wss证书失败', 'Failed to save wss certificate', 1),
(1917, 2, '400607', '{:name}不能为空', '{:name} cannot be empty', 1),
(1918, 2, '400608', '删除的云存储不存在', 'Deleted cloud storage does not exist', 1),
(1919, 2, '400609', '云存储正在使用中,需要启动其他空间才能删除', 'The cloud storage is in use and needs to be activated to delete other spaces', 1),
(1920, 2, '400610', '云空间名称不能重复', 'Cloud space name cannot be repeated', 1),
(1921, 2, '400611', '没有权限', 'No permission', 1),
(1922, 2, '400612', '替换失败,失败原因:{:msg}', 'Replacement failed, failure reason: {:msg}', 1),
(1923, 2, '400613', '请先删除改菜单下的子菜单', 'Please delete the submenu under the menu first', 1),
(1924, 2, '400614', '请填写批次名称', 'Please fill in the batch name', 1),
(1925, 2, '400615', '请填写要生成卡的数量', 'Please fill in the number of cards to be generated', 1),
(1926, 2, '400616', '卡片数量只能为正整数', 'The number of cards can only be a positive integer', 1),
(1927, 2, '400617', '单次制卡数量最高不得超过6000张', 'The maximum number of cards produced in a single time shall not exceed 6000', 1),
(1928, 2, '400618', '请填写免费使用天数', 'Please fill in the number of free usage days', 1),
(1929, 2, '400619', '免费使用天数只能为正整数', 'The number of free usage days can only be a positive integer', 1),
(1930, 2, '400620', '生成卡失败', 'Failed to generate card', 1),
(1931, 2, '400621', '会员功能暂未开启', 'The member function has not been opened yet', 1),
(1932, 2, '400622', '请输入会员卡号', 'Please enter the membership card number', 1),
(1933, 2, '400623', '请输入领取卡密', 'Please enter the card password', 1),
(1934, 2, '400624', '会员卡不存在', 'The membership card does not exist', 1),
(1935, 2, '400625', '会员卡未激活，暂无法使用', 'The membership card is not activated and cannot be used temporarily', 1),
(1936, 2, '400626', '会员卡密码有误', 'The membership card password is incorrect', 1),
(1937, 2, '400627', '会员卡已使用', 'The membership card has been used', 1),
(1938, 2, '400628', '您已是永久会员，无需再领取，可以将此卡转送亲朋好友，一起享受优惠', 'You are already a permanent member, you don`t need to get it anymore, you can transfer this card to friends and relatives to enjoy the discount together', 1),
(1939, 2, '400629', '暂无此类型会员卡', 'There is currently no membership card of this type', 1),
(1940, 2, '400630', '会员权益类型缺失', 'Membership benefit type is missing', 1),
(1941, 2, '400631', '请设置权益名称', 'Please set the equity name', 1),
(1942, 2, '400632', '请上传会员权益图标', 'Please upload the member rights icon', 1),
(1943, 2, '400633', '请设置返还积分倍数', 'Please set the return points multiple', 1),
(1944, 2, '400634', '返还积分倍数不能为负数', 'The multiple of return points cannot be negative', 1),
(1945, 2, '400635', '请设置运费折扣', 'Please set the shipping discount', 1),
(1946, 2, '400636', '运费折扣不能为负数', 'The shipping discount cannot be negative', 1),
(1947, 2, '400637', '请设置签到积分倍数', 'Please set the check-in point multiple', 1),
(1948, 2, '400638', '签到积分倍数不能为负数', 'Sign-in point multiple cannot be negative', 1),
(1949, 2, '400639', '请设置线下付款折扣', 'Please set the offline payment discount', 1),
(1950, 2, '400640', '线下付款不能为负数', 'Offline payment cannot be negative', 1),
(1951, 2, '400641', '请填写会员卡名称', 'Please fill in the name of the membership card', 1),
(1952, 2, '400642', '会员卡类型缺失', 'Missing membership card type', 1),
(1953, 2, '400643', '请填写有效期（天）', 'Please fill in the validity period (days)', 1),
(1954, 2, '400644', '有效期（天）不能为负数', 'The validity period (days) cannot be negative', 1),
(1955, 2, '400645', '请填写价格', 'Please fill in the price', 1),
(1956, 2, '400646', '价格不能为负数', 'Price cannot be negative', 1),
(1957, 2, '400647', '优惠价不能大于原价', 'The discounted price cannot be greater than the original price', 1),
(1958, 2, '400648', '地址不存在', 'Address does not exist', 1),
(1959, 2, '400649', '取消原来默认地址失败', 'Cancel the original default address failed', 1),
(1960, 2, '400650', '设置默认地址失败', 'Failed to set default address', 1),
(1961, 2, '400651', '地址已存在', 'Address already exists', 1),
(1962, 2, '400652', '收货地址格式错误', 'The format of the delivery address is incorrect', 1),
(1963, 2, '400653', '请登录', 'Please log in', 1),
(1964, 2, '400654', '登录已过期,请重新登录', 'Login has expired, please log in again', 1),
(1965, 2, '400655', '增加记录失败', 'Add record failed', 1),
(1966, 2, '400656', '记录分享记录失败', 'Record sharing record failed', 1),
(1967, 2, '400657', '增加用户佣金失败', 'Failed to increase user commission', 1),
(1968, 2, '400658', '企业付款到零钱失败，请稍后再试', 'The company failed to pay the change, please try again later', 1),
(1969, 2, '400659', '已经提现', 'Already withdrawn', 1),
(1970, 2, '400660', '您的提现申请已被拒绝', 'Your withdrawal request has been rejected', 1),
(1971, 2, '400661', '可提现佣金不足', 'Insufficient commission to withdraw cash', 1),
(1972, 2, '400662', '提现金额不能小于{:money}元', 'The withdrawal amount cannot be less than {:money} yuan', 1),
(1973, 2, '400663', '提现佣金不足{:money}元', 'The commission for withdrawal is insufficient {:money} yuan', 1),
(1974, 2, '400664', '提现佣金大于0', 'The commission for withdrawal is greater than 0', 1),
(1975, 2, '400665', '企业微信付款到零钱最低金额为1元', 'Enterprise WeChat payment to change the minimum amount is 1 yuan', 1),
(1976, 2, '400666', '该分组已经存在', 'The group already exists', 1),
(1977, 2, '400667', '清空用户标签失败', 'Failed to clear user label', 1),
(1978, 2, '400668', '设置标签失败', 'Failed to set label', 1),
(1979, 2, '400669', '请选择标签分类', 'Please select label classification', 1),
(1980, 2, '400670', '该标签已经存在', 'The label already exists', 1),
(1981, 2, '400671', '修改用户等级信息失败', 'Failed to modify user level information', 1),
(1982, 2, '400672', '用户等级不存在', 'User level does not exist', 1),
(1983, 2, '400673', '用户等级经验必须大于上一等级设置的经验', 'User level experience must be greater than the experience set by the previous level', 1),
(1984, 2, '400674', '用户等级经验必须小于下一等级设置的经验', 'User level experience must be less than the experience set by the next level', 1),
(1985, 2, '400675', '已检测到您设置过的用户等级，此等级不可重复', 'The user level you set has been detected, this level cannot be repeated', 1),
(1986, 2, '400676', '已检测到您设置过该用户等级经验值，经验值不可重复', 'It has been detected that you have set the experience value of this user level, the experience value cannot be repeated', 1),
(1987, 2, '400677', '订单未支付', 'Order not paid', 1),
(1988, 2, '400678', '佣金转入余额，不能退款', 'The commission is transferred to the balance and cannot be refunded', 1),
(1989, 2, '400679', '已支付的订单记录无法删除', 'The paid order record cannot be deleted', 1),
(1990, 2, '400680', '转入金额不能大于可提现佣金', 'The transfer amount cannot be greater than the commission that can be withdrawn', 1),
(1991, 2, '400681', '写入余额充值失败', 'Failed to write balance recharge', 1),
(1992, 2, '400682', '您选择的充值方式已下架', 'The recharge method you selected has been removed', 1),
(1993, 2, '400683', '充值订单生成失败', 'Failed to generate recharge order', 1),
(1994, 2, '400684', '保存用户信息失败', 'Failed to save user information', 1),
(1995, 2, '400685', '密码重置失败', 'Password reset failed', 1),
(1996, 2, '400686', '增加推广人数失败', 'Failed to increase the number of promotions', 1),
(1997, 2, '400687', '设置登录类型失败', 'Failed to set login type', 1),
(1998, 2, '400688', '设置推广员失败', 'Failed to set promoter', 1),
(1999, 2, '400689', '增加用户余额失败', 'Failed to increase user balance', 1),
(2000, 2, '400690', '减少用户余额失败', 'Failed to reduce user balance', 1),
(2001, 2, '400691', '减少用户佣金失败', 'Failed to reduce user commission', 1),
(2002, 2, '400692', '增加用户积分失败', 'Failed to increase user points', 1),
(2003, 2, '400693', '减少用户积分失败', 'Failed to reduce user points', 1),
(2004, 2, '400694', '增加用户经验失败', 'Failure to increase user experience', 1),
(2005, 2, '400695', '减少用户经验失败', 'Failure to reduce user experience', 1),
(2006, 2, '400696', '该分组不存在', 'The group does not exist', 1),
(2007, 2, '400697', '设置分组失败或无改动', 'Failure to set grouping or no change', 1),
(2008, 2, '400698', '有标签不存在或被删除', 'A label does not exist or is deleted', 1),
(2009, 2, '400699', '等级不存在或被删除', 'Level does not exist or is deleted', 1),
(2010, 2, '400700', '此用户已有该用户等级，无法再次赠送', 'This user already has this user level and cannot give it again', 1),
(2011, 2, '400701', '赠送天数不能为0', 'The gift days cannot be 0', 1),
(2012, 2, '400702', '天数输入错误', 'The number of days is incorrectly entered', 1),
(2013, 2, '400703', '用户信息储存失败', 'Failed to store user information', 1),
(2014, 2, '400704', '您得ip不再白名单中,请前往腾讯微信公众平台添加ip白名单', 'Your ip is no longer in the whitelist, please go to the Tencent WeChat public platform to add the ip to the whitelist', 1),
(2015, 2, '400705', '您填写得appid无效,请检查', 'The appid you filled in is invalid, please check', 1),
(2016, 2, '400706', '请输入回复信息内容', 'Please enter the content of the reply message', 1),
(2017, 2, '400707', '请上传回复的图片', 'Please upload the picture of the reply', 1),
(2018, 2, '400708', '请上传回复的声音', 'Please upload the reply voice', 1),
(2019, 2, '400709', '请选择图文消息', 'Please select a text message', 1),
(2020, 2, '400710', '对应的uid不存在', 'The corresponding uid does not exist', 1),
(2021, 2, '400711', '取消关注失败', 'Unfollow failed', 1),
(2022, 2, '400712', '电子面单模板ID缺失', 'The ID of the electronic face slip template is missing', 1),
(2023, 2, '400713', '快递公司编码缺失', 'The courier company code is missing', 1),
(2024, 2, '400714', '寄件人信息缺失', 'Sender information is missing', 1),
(2025, 2, '400715', '收件人信息缺失', 'The recipient information is missing', 1),
(2026, 2, '400716', '云打印机编号缺失', 'Cloud printer number is missing', 1),
(2027, 2, '400717', '商品数量缺失', 'Item quantity is missing', 1),
(2028, 2, '400718', '获取access_token获取失败', 'Failed to obtain access_token', 1),
(2029, 2, '400719', '手机号不能为空', 'Mobile phone number cannot be empty', 1),
(2030, 2, '400720', '模版ID不存在', 'Template ID does not exist', 1),
(2031, 2, '400721', '请先配置accessKey和secretKey', 'Please configure accessKey and secretKey first', 1),
(2032, 2, '400722', '请先配置水印图片', 'Please configure the watermark image first', 1),
(2033, 2, '400723', '请先配置水印文字', 'Please configure the watermark text first', 1),
(2034, 2, '400724', '远程水印图片下载失败', 'Remote watermark image download failed', 1),
(2035, 2, '400725', '上传图片不存在', 'The uploaded image does not exist', 1),
(2036, 2, '400726', '图片流获取失败', 'Failed to get image stream', 1),
(2037, 2, '400727', '图片下载失败', 'Picture download failed', 1),
(2038, 2, '400728', '必须上传xlsx格式文件', 'Must upload xlsx format file', 1),
(2039, 2, '400729', '数据不能为空', 'Data cannot be empty', 1),
(2040, 2, '400730', '缺少pay_price', 'Missing pay_price', 1),
(2041, 2, '400731', '退款失败:{:msg}', 'Refund failed: {:msg}', 1),
(2042, 2, '400732', '获取微信粉丝信息失败', 'Failed to get WeChat fan information', 1),
(2043, 2, '400733', '您已关闭上传功能', 'You have turned off the upload function', 1),
(2044, 2, '400734', '文件不可写', 'The file is not writable', 1),
(2045, 2, '400735', '时间格式不正确', 'The time format is incorrect', 1),
(2046, 2, '400736', '文件可能损坏，请检查', 'The file may be damaged, please check', 1),
(2047, 2, '400737', '修复错误，请重试', 'Fix the error, please try again', 1),
(2048, 2, '400738', '请指定要修复的表', 'Please specify the table to be repaired', 1),
(2049, 2, '400739', '请配置支付证书', 'Please configure payment certificate', 1),
(2050, 2, '400740', '只支持两级分类', 'Only two-level classification is supported', 1),
(2051, 2, '400741', '运费格式错误', 'Freight format error', 1),
(2052, 2, '400742', '请检查属性编码或库存数量', 'Please check the attribute code or inventory quantity', 1),
(2053, 2, '400743', '同步条数不能超过100', 'The number of synchronization entries cannot exceed 100', 1),
(2054, 2, '400744', 'appid或appsecret错误', 'Appid or AppSecret error', 1),
(2055, 2, '400745', '父级ID参数类型错误', 'Parent ID parameter type error', 1),
(2056, 2, '400746', '分类名称长度不能超过25个字符', 'The length of classification name cannot exceed 25 characters', 1),
(2057, 2, '400747', '分类图标长度不能超过128个字符', 'The length of classification icon cannot exceed 128 characters', 1),
(2058, 2, '400748', '分类大图长度不能超过200个字符', 'The length of the classified large image cannot exceed 200 characters', 1),
(2059, 2, '400749', '排序参数类型错误', 'Wrong sort parameter type', 1),
(2060, 2, '400750', '排序不能小于0', 'Sort cannot be less than 0', 1),
(2061, 2, '400751', '状态必须是0-1之间的整数', 'Status must be an integer between 0 and 1', 1),
(2062, 2, '400752', '权益简介不能大于8个字', 'The introduction of rights and interests cannot be longer than 8 words', 1),
(2063, 2, '400753', '提现方式最少选一种', 'Select at least one withdrawal method', 1),
(2064, 2, '400754', '身份使用中，无法删除', 'The identity is in use and cannot be deleted', 1),
(2065, 2, '400755', '展示名称不能大于6个字', 'The display name cannot be longer than 6 characters', 1),
(2066, 2, '400756', '推广佣金单价不能小于0', 'The unit price of the promotion commission cannot be less than 0', 1),
(2067, 2, '400757', '每日推广佣金上限不能小于-1', 'The daily promotion commission limit cannot be less than -1', 1),
(2068, 2, '400758', '请核对领取方式', 'Please check the collection method', 1),
(2069, 2, '400759', '请输入优惠券名称', 'Please enter the coupon name', 1),
(2070, 2, '400760', '请输入真实姓名', 'Please enter your real name', 1),
(2071, 2, '400761', '描述内容不能超过120字', 'The description cannot exceed 120 words', 1),
(2072, 2, '400762', '账号密码必须是在6到32位之间', 'The account password must be between 6 and 32 bits', 1),
(2073, 2, '400763', '商户号不能为空', 'Merchant number cannot be empty', 1),
(2074, 2, '410000', '请输入账号和密码', 'Please enter the account number and password', 1),
(2075, 2, '410001', '登录成功', 'Login successful', 1),
(2076, 2, '410002', '退出成功', 'Exit successfully', 1),
(2077, 2, '410003', '发送验证码失败,请刷新页面重新获取', 'Failed to send verification code, please refresh the page to get it again', 1),
(2078, 2, '410004', '请输入验证码', 'Please enter the verification code', 1),
(2079, 2, '410005', '验证码输入有误', 'The verification code is entered incorrectly', 1),
(2080, 2, '410006', '验证码已发送', 'Verification code has been sent', 1),
(2081, 2, '410007', '验证码发送成功', 'Verification code sent successfully', 1),
(2082, 2, '410008', '验证码发送失败', 'Verification code sending failed', 1),
(2083, 2, '410009', '请先获取验证码', 'Please get the verification code first', 1),
(2084, 2, '410010', '验证码错误', 'Verification code error', 1),
(2085, 2, '410011', '密码必须是在6到16位之间', 'The password must be between 6 and 16 digits', 1),
(2086, 2, '410012', '密码太过简单，请输入较为复杂的密码', 'The password is too simple, please enter a more complex password', 1),
(2087, 2, '410013', '注册成功', 'Registration successful', 1),
(2088, 2, '410014', '注册失败', 'Registration failed', 1),
(2089, 2, '410015', '请输入手机号', 'Please enter the phone number', 1),
(2090, 2, '410016', '绑定成功', 'Binding successful', 1),
(2091, 2, '410017', '绑定失败', 'Binding failed', 1),
(2092, 2, '410018', '手机号格式不正确', 'The phone number format is incorrect', 1),
(2093, 2, '410019', '登录失败', 'Login failed', 1),
(2094, 2, '410020', '扫码失败请重新扫描', 'Scan code failed, please scan again', 1),
(2095, 2, '410021', '二维码已过期请重新扫描', 'The QR code has expired, please scan again', 1),
(2096, 2, '410022', '授权成功，请绑定手机号', 'The authorization is successful, please bind the mobile phone number', 1),
(2097, 2, '410023', '授权成功', 'Authorization successful', 1),
(2098, 2, '410024', '请先关注公众号', 'Please pay attention to the official account first', 1),
(2099, 2, '410025', '账号或密码错误', 'Account or password error', 1),
(2100, 2, '410026', '请修改您的初始密码，再尝试登录', 'Please modify your initial password and try to log in again', 1),
(2101, 2, '410027', '您已被禁止登录，请联系管理员', 'You have been banned from logging in, please contact the administrator', 1),
(2102, 2, '410028', '手机号已注册', 'The phone number has been registered', 1),
(2103, 2, '410029', '您今日发送得短信次数已经达到上限', 'The number of text messages you have sent today has reached the upper limit', 1),
(2104, 2, '410030', '此IP今日发送次数已经达到上限', 'The number of times this IP has been sent today has reached the upper limit', 1),
(2105, 2, '410031', '短信平台验证码发送失败', 'SMS platform verification code failed to send', 1),
(2106, 2, '410032', '用户不存在', 'User does not exist', 1),
(2107, 2, '410033', '修改密码失败', 'Change password failed', 1),
(2108, 2, '410034', '用户登录失败,无法生成新用户,请稍后再试', 'User login failed, unable to generate new user, please try again later', 1),
(2109, 2, '410035', '用户不存在,无法切换', 'The user does not exist and cannot be switched', 1),
(2110, 2, '410036', '修改新用户登录类型出错', 'Error modifying new user login type', 1),
(2111, 2, '410037', '请刷新页面或者重新授权', 'Please refresh the page or re-authorize', 1),
(2112, 2, '410038', '获取用户访问token失败', 'Failed to obtain user access token', 1),
(2113, 2, '410039', '此手机已经绑定，无法多次绑定', 'This phone has been bound and cannot be bound multiple times', 1),
(2114, 2, '410040', '您的账号已经绑定过手机号码', 'Your account has been bound with a mobile phone number', 1),
(2115, 2, '410041', 'H5已有账号是否绑定此账号上', 'Whether the existing account of H5 is bound to this account', 1),
(2116, 2, '410042', '新手机号和原手机号相同，无需修改', 'The new phone number is the same as the original phone number, no need to modify', 1),
(2117, 2, '410043', '此手机已经注册', 'This phone has been registered', 1),
(2118, 2, '410044', '用户信息获取失败', 'Failed to obtain user information', 1),
(2119, 2, '410045', '请选择收货地址', 'Please select the delivery address', 1),
(2120, 2, '410046', '地址选择有误', 'The address selection is wrong', 1),
(2121, 2, '410047', '可用积分不足', 'Insufficient credits available', 1),
(2122, 2, '410048', '奖品不存在', 'The prize does not exist', 1),
(2123, 2, '410049', '写入中奖记录失败', 'Failed to write winning record', 1),
(2124, 2, '410050', '请继续参与活动抽奖', 'Please continue to participate in the lucky draw', 1),
(2125, 2, '410051', '已经领取成功', 'Received successfully', 1),
(2126, 2, '410052', '请输入收货人信息', 'Please enter the consignee information', 1),
(2127, 2, '410053', '请输入正确的收货人电话', 'Please enter the correct phone number of the consignee', 1),
(2128, 2, '410054', '抽奖记录不存在', 'The lottery record does not exist', 1),
(2129, 2, '410055', '该奖品不需要发货', 'This prize does not need to be shipped', 1),
(2130, 2, '410056', '请选择快递公司或输入快递单号', 'Please select a courier company or enter a courier number', 1),
(2131, 2, '410057', '活动不存在或已删除', 'Activity does not exist or has been deleted', 1),
(2132, 2, '410058', '暂未有该类型活动', 'There is no activity of this type yet', 1),
(2133, 2, '410059', '您暂时无法参与该活动', 'You are temporarily unable to participate in this activity', 1),
(2134, 2, '410060', '活动状态有误，请联系管理员', 'The activity status is incorrect, please contact the administrator', 1),
(2135, 2, '410061', '可用积分不足，没有更多抽奖次数', 'Insufficient points available, no more draws', 1),
(2136, 2, '410062', '余额不足，没有更多抽奖次数', 'Insufficient balance, no more draws', 1),
(2137, 2, '410063', '购买商品之后获得更多抽奖次数', 'Get more lottery draws after purchasing goods', 1),
(2138, 2, '410064', '订单完成评价之后获得更多抽奖次数', 'More prize draws will be obtained after the order is evaluated', 1),
(2139, 2, '410065', '邀请更多好友获取抽奖次数', 'Invite more friends to get the number of lucky draws', 1),
(2140, 2, '410066', '抽奖扣除用户积分失败', 'Lottery draw failed to deduct user points', 1),
(2141, 2, '410067', '抽奖失败，余额不足', 'Lottery draw failed, insufficient balance', 1),
(2142, 2, '410068', '抽奖扣除用户余额失败', 'Lottery draw failed to deduct user balance', 1),
(2143, 2, '410069', '抽奖扣除用户推广获取抽奖次数失败', 'The lottery draw failed to deduct the number of times the user promoted to get the lottery', 1),
(2144, 2, '410070', '抽奖减少奖品总数失败', 'Lottery draw to reduce the total number of prizes failed', 1),
(2145, 2, '410071', '分销等级不存在', 'Distribution level does not exist', 1),
(2146, 2, '410072', '永久二维码获取错误', 'Permanent QR code acquisition error', 1),
(2147, 2, '410073', '邀请码无效', 'Invitation code is invalid', 1),
(2148, 2, '410074', '授权失败,参数有误', 'Authorization failed, parameter is wrong', 1),
(2149, 2, '410075', 'openid获取失败', 'Failed to get openid', 1),
(2150, 2, '410076', '获取session_key失败，请检查您的配置', 'Failed to get session_key, please check your configuration', 1),
(2151, 2, '410077', '获取会话密匙失败', 'Failed to get session key', 1),
(2152, 2, '410078', '静默授权失败', 'Silent authorization failed', 1),
(2153, 2, '410079', '获取用户信息失败', 'Failed to obtain user information', 1),
(2154, 2, '410080', '更新信息失败', 'Update information failed', 1),
(2155, 2, '410081', '请上传二维码', 'Please upload the QR code', 1),
(2156, 2, '410082', '请关注公众号', 'Please pay attention to the public number', 1),
(2157, 2, '410083', '新增用户失败', 'Add user failed', 1),
(2158, 2, '410084', '用户关注失败', 'Failed to follow user', 1),
(2159, 2, '410085', '获取token失败{:msg}', 'Failed to get token {:msg}', 1),
(2160, 2, '410086', '配置已更改或token已失效', 'The configuration has been changed or the token has expired', 1),
(2161, 2, '410087', '平台错误：发生异常，请稍后重试', 'Platform error: An exception occurred, please try again later', 1),
(2162, 2, '410088', '企业微信支付到零钱需要支付证书，检测到您没有上传', 'Enterprise WeChat payment to change needs a payment certificate, it is detected that you have not uploaded', 1),
(2163, 2, '410089', '发起企业支付到零钱失败', 'The initiating enterprise failed to pay the change', 1),
(2164, 2, '410090', '无效的token不能查找到用户聊天记录', 'Invalid token cannot find user chat records', 1),
(2165, 2, '410091', '图片上传成功', 'Image upload successfully', 1),
(2166, 2, '410092', '用户uid不再当前聊天用户范围内', 'The user uid is no longer within the scope of the current chat user', 1),
(2167, 2, '410093', '请输入订单价格', 'Please enter the order price', 1),
(2168, 2, '410094', '请去后台售后订单列表处理', 'Please go to the background after-sales order list processing', 1),
(2169, 2, '410095', '分类名称不能为空', 'Category name cannot be empty', 1),
(2170, 2, '410096', '分类不存在', 'Classification does not exist', 1),
(2171, 2, '410097', '添加的内容重复', 'Added content is repeated', 1),
(2172, 2, '410098', '缺少转接人id', 'Missing transfer person id', 1),
(2173, 2, '410099', '转接成功', 'Transfer successful', 1),
(2174, 2, '410100', '话术没有被查到', 'Speech not found', 1),
(2175, 2, '410101', '公共话术不能修改', 'Public language cannot be modified', 1),
(2176, 2, '410102', '话术标题内容不能为空', 'The content of the topic title cannot be empty', 1),
(2177, 2, '410103', '已拥有此分组', 'Already owns this group', 1),
(2178, 2, '410104', '缺少标签id', 'Missing tag id', 1),
(2179, 2, '410105', '请填汉字字母或者数字', 'Please fill in Chinese letters or numbers', 1),
(2180, 2, '410106', '标题长度不能超过50个字', 'The title length cannot exceed 50 characters', 1),
(2181, 2, '410107', '请选择分类', 'Please select a category', 1),
(2182, 2, '410108', '分类必须为数字', 'The classification must be a number', 1),
(2183, 2, '410109', '请填写话术内容', 'Please fill in the content of the language', 1),
(2184, 2, '410110', '话术长度不能超过500个字', 'The length of the speech cannot exceed 500 words', 1),
(2185, 2, '410111', '排序必须为数字', 'The sort must be a number', 1),
(2186, 2, '410112', '微信最低提现金额不能小于1元', 'Wechat minimum withdrawal amount cannot be less than 1 yuan', 1),
(2187, 2, '410113', '用户不存在', 'User does not exist', 1),
(2188, 2, '410114', '提现方式不存在', 'Withdrawal method does not exist', 1),
(2189, 2, '410115', '提现金额输入有误', 'The withdrawal amount is incorrectly entered', 1),
(2190, 2, '410116', '银行卡号输入有误', 'The bank card number is entered incorrectly', 1),
(2191, 2, '410117', '请输入支付宝账号', 'Please enter the Alipay account number', 1),
(2192, 2, '410118', '请输入银行卡账号', 'Please enter the bank card account number', 1),
(2193, 2, '410119', '请输入开户行信息', 'Please enter the bank information', 1),
(2194, 2, '410120', '申请提现成功', 'The application for withdrawal is successful', 1),
(2195, 2, '410121', '申请提现失败', 'Failed to apply for withdrawal', 1),
(2196, 2, '410122', '充值金额不能为0元', 'The recharge amount cannot be 0 yuan', 1),
(2197, 2, '410123', '充值方式不支持', 'The recharge method is not supported', 1),
(2198, 2, '410124', '充值金额不能低于{:money}', 'The recharge amount cannot be less than {:money}', 1),
(2199, 2, '410125', '充值成功', 'Recharge successful', 1),
(2200, 2, '410126', '充值失败', 'Recharge failed', 1),
(2201, 2, '410127', '签到获得{:integral}积分', 'Sign in to get {:integral} points', 1),
(2202, 2, '410128', '签到失败', 'Sign in failed', 1),
(2203, 2, '410129', '收藏成功', 'Collect Successful', 1),
(2204, 2, '410130', '收藏失败', 'Failed to collect', 1),
(2205, 2, '410131', '授权失败', 'Authorization failed', 1),
(2206, 2, '410132', 'unionid不存在', 'Unionid does not exist', 1),
(2207, 2, '410133', '获取用户UID失败', 'Failed to get user UID', 1),
(2208, 2, '410134', '请输入昵称或者选择头像', 'Please enter a nickname or select an avatar', 1),
(2209, 2, '410135', '注销成功', 'Logout successful', 1),
(2210, 2, '410136', '暂无客服人员在线，请稍后联系', 'There is no customer service staff online, please contact us later', 1),
(2211, 2, '410137', '不能和自己聊天', 'Can`t chat with myself', 1),
(2212, 2, '410138', '您不是客服无法登录', 'You are not customer service and cannot log in', 1),
(2213, 2, '410139', '自己不能转接给自己', 'I cannot transfer to myself', 1),
(2214, 2, '410140', '转接客服失败', 'Transfer customer service failed', 1),
(2215, 2, '410141', '没有此用户', 'There is no such user', 1),
(2216, 2, '410142', '客服不存在', 'Customer service does not exist', 1),
(2217, 2, '410143', '商品未查到', 'Commodity not found', 1),
(2218, 2, '410144', '请填写开票手机号', 'Please fill in the billing phone number', 1),
(2219, 2, '410145', '请填写发票抬头（开具发票企业名称）', 'Please fill in the title of the invoice (name of the company issuing the invoice)', 1),
(2220, 2, '410146', '请填写正确的发票抬头（开具发票企业名称）', 'Please fill in the correct invoice header (name of the company issuing the invoice)', 1),
(2221, 2, '410147', '请填写发票税号', 'Please fill in the invoice tax number', 1),
(2222, 2, '410148', '请填写正确的发票税号', 'Please fill in the correct invoice tax number', 1),
(2223, 2, '410149', '请填写正确的银行卡号', 'Please fill in the correct bank card number', 1),
(2224, 2, '410150', '地址不存在', 'Address does not exist', 1),
(2225, 2, '410151', '收货地址格式错误', 'The format of the delivery address is incorrect', 1),
(2226, 2, '410152', '收货地址格式错误或系统未完善当前地址', 'The format of the delivery address is incorrect or the system does not complete the current address', 1),
(2227, 2, '410153', '收货地址格式错误，请重新选择', 'The format of the delivery address is incorrect, please select again', 1),
(2228, 2, '410154', '请填写详细地址', 'Please fill in the detailed address', 1),
(2229, 2, '410155', '名称必须填写', 'Name must be filled in', 1),
(2230, 2, '410156', '名称最多不能超过25个字符', 'Name cannot exceed 25 characters', 1),
(2231, 2, '410157', '手机号必须填写', 'Mobile phone number must be filled in', 1),
(2232, 2, '410158', '手机号格式错误', 'Mobile phone number format error', 1),
(2233, 2, '410159', '省必须填写', 'The province must fill in', 1),
(2234, 2, '410160', '市必须填写', 'City must fill in', 1),
(2235, 2, '410161', '区/县必须填写', 'The district/county must be filled in', 1),
(2236, 2, '410162', '详细地址必须填写', 'The detailed address must be filled in', 1),
(2237, 2, '410163', '请填写反馈内容', 'Please fill in the feedback content', 1),
(2238, 2, '410164', '比例不能大于您的比例', 'The ratio cannot be greater than your ratio', 1),
(2239, 2, '410165', '激活成功', 'Activation successful', 1),
(2240, 2, '410166', '暂无海报', 'No posters yet', 1),
(2241, 2, '410167', '二维码生成失败', 'QR code generation failed', 1),
(2242, 2, '410168', '缺少字体文件Bold', 'Missing font file Bold', 1),
(2243, 2, '410169', '缺少字体文件Normal', 'Missing font file Normal', 1),
(2244, 2, '410170', '生成图片失败', 'Failed to generate image', 1),
(2245, 2, '410171', '生成图片时，系统错误', 'A system error occurred when generating a picture', 1),
(2246, 2, '410172', '生成海报失败', 'Failed to generate poster', 1),
(2247, 2, '410173', '订单不存在', 'Order does not exist', 1),
(2248, 2, '410174', '订单已支付', 'Order paid', 1),
(2249, 2, '410175', '请填写实际支付金额', 'Please fill in the actual payment amount', 1),
(2250, 2, '410176', '实际支付金额不能小于0元', 'The actual payment amount cannot be less than 0 yuan', 1),
(2251, 2, '410177', '请填写备注内容', 'Please fill in the remarks', 1),
(2252, 2, '410178', '请先处理售后申请', 'Please process the after-sales application first', 1),
(2253, 2, '410179', '用户已取消申请', 'The user has cancelled the application', 1),
(2254, 2, '410180', '售后订单状态不支持该操作', 'After-sales order status does not support this operation', 1),
(2255, 2, '410181', '退款修改状态错误', 'Refund modification status error', 1),
(2256, 2, '410182', '修改退款状态成功', 'Modify the refund status successfully', 1),
(2257, 2, '410183', '已退完支付金额，不能再退款了', 'The payment amount has been refunded and cannot be refunded any more', 1),
(2258, 2, '410184', '请输入退款金额', 'Please enter the refund amount', 1),
(2259, 2, '410185', '退款金额大于支付金额，请修改退款金额', 'The refund amount is greater than the payment amount, please modify the refund amount', 1),
(2260, 2, '410186', '退款成功', 'Refund successful', 1),
(2261, 2, '410187', '退款失败', 'Refund failed', 1),
(2262, 2, '410188', '请输入核销码或者扫描核销二维码', 'Please enter the write-off code or scan the write-off QR code', 1),
(2263, 2, '410189', '核销成功', 'Successful write-off', 1),
(2264, 2, '410190', '请输入付款金额', 'Please enter the payment amount', 1),
(2265, 2, '410191', '支付金额不能为0元', 'The payment amount cannot be 0 yuan', 1),
(2266, 2, '410192', '付费会员功能暂未开启', 'The paid membership function has not been opened yet', 1),
(2267, 2, '410193', '支付数据生成失败', 'Payment data generation failed', 1),
(2268, 2, '410194', '支付订单不存在', 'Payment order does not exist', 1),
(2269, 2, '410195', '微信支付成功', 'WeChat payment is successful', 1),
(2270, 2, '410196', '前往支付', 'Go to payment', 1),
(2271, 2, '410197', '余额支付成功', 'Balance payment successful', 1),
(2272, 2, '410198', '请传入支付宝支付回调URL', 'Please pass in the Alipay payment callback URL', 1),
(2273, 2, '410199', '支付宝支付成功', 'Alipay payment is successful', 1),
(2274, 2, '410200', '订单生成失败', 'Order generation failed', 1),
(2275, 2, '410201', '请提交购买的商品', 'Please submit the purchased product', 1),
(2276, 2, '410202', '商品不存在，请重新选择商品下单', 'The product does not exist, please re-select the product to place an order', 1),
(2277, 2, '410203', '订单创建成功', 'Order created successfully', 1),
(2278, 2, '410204', '收货成功', 'Received goods successfully', 1),
(2279, 2, '410205', '收货失败', 'Receipt failed', 1),
(2280, 2, '410206', '快递单号不存在', 'Express tracking number does not exist', 1),
(2281, 2, '410207', '默认运费模板未配置，无法下单', 'The default shipping template is not configured, so the order cannot be placed', 1),
(2282, 2, '410208', '订单已过期,请刷新当前页面', 'The order has expired, please refresh the current page', 1),
(2283, 2, '410209', '订单已创建，请点击查看完成支付', 'The order has been created, please click to view to complete the payment', 1),
(2284, 2, '410210', '订单生成失败，你已经在该团内不能再参加了', 'The order generation failed, you can no longer participate in the group', 1),
(2285, 2, '410211', '订单生成失败，你已经参加该团了，请先支付订单', 'The order generation failed, you have already joined the group, please pay the order first', 1),
(2286, 2, '410212', '该团人员已满', 'The group is full', 1),
(2287, 2, '410213', '暂不支持该支付方式，请刷新页面或者联系管理员', 'This payment method is not currently supported, please refresh the page or contact the administrator', 1),
(2288, 2, '410214', '您购买的商品库存已不足{:cart_num}{:unit_name}', 'The stock you purchased is not enough {:cart_num}{:unit_name}', 1),
(2289, 2, '410215', '该订单已失效', 'The order has expired', 1),
(2290, 2, '410216', '支付失败', 'Payment failed', 1),
(2291, 2, '410217', '支付成功', 'Payment successful', 1),
(2292, 2, '410218', '支付方式错误', 'Payment method error', 1),
(2293, 2, '410219', '订单商品已评价', 'The order item has been evaluated', 1),
(2294, 2, '410220', '请为商品评分', 'Please rate the product', 1),
(2295, 2, '410221', '请为商家服务评分', 'Please rate the business service', 1),
(2296, 2, '410222', '评价失败', 'Evaluation failed', 1),
(2297, 2, '410223', '请重新选择退款商品或件数', 'Please re-select the refund item or the number of pieces', 1),
(2298, 2, '410224', '当前状态不能取消申请', 'The current state cannot cancel the application', 1),
(2299, 2, '410225', '重选成功', 'Re-successful', 1),
(2300, 2, '410226', '订单已退款', 'Order refunded', 1),
(2301, 2, '410227', '使用积分抵扣失败', 'Failed to use points to deduct', 1),
(2302, 2, '410228', '会员类型不存在', 'Member type does not exist', 1),
(2303, 2, '410229', '您已是永久会员无需再购买', 'You are already a permanent member, no need to purchase any more', 1),
(2304, 2, '410230', '该会员卡暂时无法购买', 'This membership card cannot be purchased temporarily', 1),
(2305, 2, '410231', '您已经领取过免费会员', 'You have already received a free membership', 1),
(2306, 2, '410232', '此类型会员卡暂未开售', 'This type of membership card is not yet available for sale', 1),
(2307, 2, '410233', '获取购物车信息失败', 'Failed to get shopping cart information', 1),
(2308, 2, '410234', '您要购买的优惠券已失效，无法购买', 'The coupon you want to buy has expired and cannot be purchased', 1),
(2309, 2, '410235', '您已获取过该优惠券，无法再次购买', 'You have already obtained the coupon and cannot buy it again', 1),
(2310, 2, '410236', '请刷新后重试', 'Please refresh and try again', 1),
(2311, 2, '410237', '暂无库存', 'No stock', 1),
(2312, 2, '410238', '选择的规格库存不足', 'The selected specification is out of stock', 1),
(2313, 2, '410239', '单次购买数量不能大于 {:limit} 件', 'Single purchase quantity cannot be greater than {:limit} pieces', 1),
(2314, 2, '410240', '该商品限购 {:limit} 件，您已经购买 {:pay_num} 件', 'This product is limited to {:limit} pieces, you have already purchased {:pay_num} pieces', 1),
(2315, 2, '410241', '选择支付方式有误', 'Incorrect payment method selected', 1),
(2316, 2, '410242', '选择的优惠劵无效', 'The selected coupon is invalid', 1),
(2317, 2, '410243', '不满足优惠劵的使用条件', 'The conditions for using the coupons are not met', 1),
(2318, 2, '410244', '使用优惠劵失败', 'Failed to use coupon', 1),
(2319, 2, '410245', '请填写姓名和电话', 'Please fill in your name and phone number', 1),
(2320, 2, '410246', '营销商品不能使用线下支付', 'Offline payment cannot be used for marketing products', 1),
(2321, 2, '410247', '暂无门店无法选择门店自提', 'There is currently no store and cannot choose to pick up at the store', 1),
(2322, 2, '410248', '订单商品结算失败', 'Order item settlement failed', 1),
(2323, 2, '410249', '发票已申请', 'Invoice has been applied', 1),
(2324, 2, '410250', '正在申请退款中', 'Applying for a refund', 1),
(2325, 2, '410251', '申请失败', 'Application failed', 1),
(2326, 2, '410252', '退款件数大于订单件数', 'The number of refunds is greater than the number of orders', 1),
(2327, 2, '410253', '该订单已全部拆分', 'The order has been split', 1),
(2328, 2, '410254', '申请退款失败', 'Failed to apply for refund', 1),
(2329, 2, '410255', '存在待处理退款单', 'There is a pending refund order', 1),
(2330, 2, '410256', '该订单无法删除', 'This order cannot be deleted', 1),
(2331, 2, '410257', '订单已经支付无法取消', 'The order has been paid and cannot be cancelled', 1),
(2332, 2, '410258', '拼团商品不能再来一单，请在拼团商品内自行下单', 'The grouped product cannot be ordered again, please place an order in the grouped product by yourself', 1),
(2333, 2, '410259', '砍价商品不能再来一单，请在砍价商品内自行下单', 'The bargained item cannot be ordered again, please place your own order in the bargained item', 1),
(2334, 2, '410260', '秒杀商品不能再来一单，请在秒杀商品内自行下单', 'The seckill item cannot be ordered again, please place an order within the seckill item', 1),
(2335, 2, '410261', '预售商品不能再来一单，请在预售商品内自行下单', 'The pre-sale item cannot be ordered again, please place an order in the pre-sale item by yourself', 1),
(2336, 2, '410262', '再来一单失败，请重新下单', 'Another order failed, please place a new order', 1),
(2337, 2, '410263', '该订单无法支付', 'The order cannot be paid', 1),
(2338, 2, '410264', '订单支付状态有误，无法进行支付', 'The payment status of the order is incorrect and cannot be paid', 1),
(2339, 2, '410265', '该订单已支付', 'The order has been paid', 1),
(2340, 2, '410266', '订单状态错误', 'Order status error', 1),
(2341, 2, '410267', '此订单不能被核销', 'This order cannot be written off', 1),
(2342, 2, '410268', '订单有售后申请请先处理', 'The order has an after-sales application, please process it first', 1),
(2343, 2, '410269', '您无权限核销此订单，请联系管理员', 'You do not have permission to write off this order, please contact the administrator', 1),
(2344, 2, '410270', '订单已核销', 'Order has been written off', 1),
(2345, 2, '410271', '拼团订单暂未成功无法核销', 'The group order has not been successfully written off yet', 1),
(2346, 2, '410272', '核销失败', 'Verification failed', 1),
(2347, 2, '410273', '发货成功', 'Successful delivery', 1),
(2348, 2, '410274', '无需支付', 'No payment required', 1),
(2349, 2, '410275', '获取用户openid失败,无法支付', 'Failed to obtain user openid, unable to pay', 1),
(2350, 2, '410276', '网站名称配置未填写,无法支付', 'The website name configuration is not filled in, unable to pay', 1),
(2351, 2, '410277', '支付方式不存在', 'Payment method does not exist', 1),
(2352, 2, '410278', '不支持该类型方式', 'This type of method is not supported', 1),
(2353, 2, '410279', '余额支付失败', 'Balance payment failed', 1),
(2354, 2, '410280', '暂未开启发票', 'Invoice has not been opened yet', 1),
(2355, 2, '410281', '暂未开启专用发票', 'Special invoice has not been opened yet', 1),
(2356, 2, '410282', '该发票已经存在', 'The invoice already exists', 1),
(2357, 2, '410283', '设置默认发票失败', 'Failed to set default invoice', 1),
(2358, 2, '410284', '没有此用户，无法检测升级用户等级', 'Without this user, the upgrade user level cannot be detected', 1),
(2359, 2, '410285', '检测升级失败', 'Check upgrade failed', 1),
(2360, 2, '410286', '修改订单失败', 'Failed to modify order', 1),
(2361, 2, '410287', '修改用户信息失败', 'Failed to modify user information', 1),
(2362, 2, '410288', '绑定推广关系失败', 'Failed to bind promotion relationship', 1),
(2363, 2, '410289', '天数不能为0', 'The number of days cannot be 0', 1),
(2364, 2, '410290', '添加签到数据失败', 'Failed to add check-in data', 1),
(2365, 2, '410291', '赠送经验失败', 'Failed to give experience', 1),
(2366, 2, '410292', '请先配置签到天数', 'Please configure the check-in days first', 1),
(2367, 2, '410293', '已经签到', 'Signed in', 1),
(2368, 2, '410294', '商品不存在', 'Commodity does not exist', 1),
(2369, 2, '410295', '该商品已下架或删除', 'The item has been removed or deleted', 1),
(2370, 2, '410296', '该商品库存不足', 'The product is out of stock', 1),
(2371, 2, '410297', '该商品库存不足{:num}', 'Insufficient stock of this product {:num}', 1),
(2372, 2, '410298', '每人总共限购{:num}件', 'Each person is limited to {:num} pieces in total', 1),
(2373, 2, '410299', '砍价已结束', 'Haggling has ended', 1),
(2374, 2, '410300', '您不能再发起此件商品砍价', 'You can no longer initiate bargaining on this item', 1),
(2375, 2, '410301', '该分享未开启砍价', 'The sharing has not been opened for bargaining', 1),
(2376, 2, '410302', '您已经帮砍过此砍价', 'You have already helped cut the price', 1),
(2377, 2, '410303', '砍价信息没有查到', 'The bargaining information was not found', 1),
(2378, 2, '410304', '用户砍价信息未查到', 'User bargaining information is not found', 1),
(2379, 2, '410305', '请选择有效的商品属性', 'Please select a valid product attribute', 1),
(2380, 2, '410306', '砍价商品不存在', 'The bargain item does not exist', 1),
(2381, 2, '410307', '砍价失败', 'Haggling failed', 1),
(2382, 2, '410308', '砍价未成功', 'The bargaining was unsuccessful', 1),
(2383, 2, '410309', '砍价已支付', 'Haggling has been paid', 1),
(2384, 2, '410310', '您不能再帮砍此件商品', 'You can no longer help cut this item', 1),
(2385, 2, '410311', '商品已被删除', 'Item has been deleted', 1),
(2386, 2, '410312', '拼团不存在或已下架,请手动申请退款', 'The group does not exist or has been removed, please apply for a refund manually', 1),
(2387, 2, '410313', '每个订单限购{:num}件', 'Each order is limited to {:num} pieces', 1),
(2388, 2, '410314', '未查到拼团信息，无法取消', 'The group information cannot be found and cannot be cancelled', 1),
(2389, 2, '410315', '拼团已到期', 'The group has expired', 1),
(2390, 2, '410316', '拼团已完成，无法取消', 'The grouping has been completed and cannot be cancelled', 1),
(2391, 2, '410317', '每人限购{:num}件', 'Each person is limited to {:num} pieces', 1),
(2392, 2, '410318', '抽奖不存在', 'The lottery does not exist', 1),
(2393, 2, '410319', '领取成功', 'Received successfully', 1),
(2394, 2, '410320', '领取失败', 'Failed to receive', 1),
(2395, 2, '410321', '活动未开始', 'The event has not started', 1),
(2396, 2, '410322', '活动已结束', 'The event has ended', 1),
(2397, 2, '410323', '您已有这张优惠券，请勿重复购买', 'You already have this coupon, please do not buy it again', 1),
(2398, 2, '410324', '请核对快递公司编码', 'Please check the express company code', 1),
(2399, 2, '410325', '请选择发票', 'Please select invoice', 1),
(2400, 2, '-1', '系统繁忙，请稍候再试', 'The system is busy, please try again later', 1),
(2401, 2, '43104', 'appid与openid不匹配', 'appid does not match openid', 1),
(2402, 2, '45009', '达到微信api每日限额上限', 'Reached the upper limit of WeChat api daily limit', 1),
(2403, 2, '45008', '图文消息超过限制', 'Text message exceeds limit', 1),
(2404, 2, '45007', '语音播放时间超过限制', 'Voice playback time exceeds the limit', 1),
(2405, 2, '45006', '图片链接字段超过限制', 'Picture link field exceeds limit', 1),
(2406, 2, '45005', '链接字段超过限制', 'Link field exceeds limit', 1),
(2407, 2, '45004', '描述字段超过限制', 'Description field exceeds limit', 1),
(2408, 2, '45003', '标题字段超过限制', 'Title field exceeds limit', 1),
(2409, 2, '45002', '消息内容超过限制', 'Message content exceeds limit', 1),
(2410, 2, '45001', '多媒体文件大小超过限制', 'Multimedia file size exceeds limit', 1),
(2411, 2, '44004', '文本消息内容为空', 'Text message content is empty', 1),
(2412, 2, '44003', '图文消息内容为空', 'Text message content is empty', 1),
(2413, 2, '44002', 'POST 的数据包为空', 'Post packet is empty', 1),
(2414, 2, '44001', '多媒体文件为空', 'Multimedia file is empty', 1),
(2415, 2, '43019', '需要将接收者从黑名单中移除', 'The recipient needs to be removed from the blacklist', 1),
(2416, 2, '43005', '需要好友关系', 'Need friends', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(2417, 2, '43004', '需要接收者关注', 'Need recipient is attention', 1),
(2418, 2, '43003', '需要 HTTPS 请求', 'HTTPS request required', 1),
(2419, 2, '43002', '需要 POST 请求', 'Post request required', 1),
(2420, 2, '43001', '需要 GET 请求', 'Get request required', 1),
(2421, 2, '42007', '用户修改微信密码， accesstoken 和 refreshtoken 失效，需要重新授权', 'The user modifies the wechat password. The accesstoken and refreshtoken are invalid and need to be re authorized', 1),
(2422, 2, '42003', 'oauth_code 超时', 'oauth_ Code timeout', 1),
(2423, 2, '42002', 'refresh_token 超时', 'refresh_token timeout', 1),
(2424, 2, '42001', 'access_token 超时，请检查 access_token 的有效期，请参考基础支持 - 获取 access_token 中，对 access_token 的详细机制说明', 'access_ Token timeout, please check access_ For the validity period of the token, please refer to basic support - get access_ In token, access_ Detailed mechanism description of token', 1),
(2425, 2, '41009', '缺少 openid', 'Missing openid', 1),
(2426, 2, '41008', '缺少 oauth code', 'Missing oauth code', 1),
(2427, 2, '41007', '缺少子菜单数据', 'Missing submenu data', 1),
(2428, 2, '41006', '缺少 media_id 参数', 'Missing media_ ID parameter', 1),
(2429, 2, '41005', '缺少多媒体文件数据', 'Missing multimedia file data', 1),
(2430, 2, '41004', '缺少 secret 参数', 'Missing secret parameter', 1),
(2431, 2, '41003', '缺少 refresh_token 参数', 'Missing refresh_token parameter', 1),
(2432, 2, '41002', '缺少 appid 参数', 'Missing appid parameter', 1),
(2433, 2, '41001', '缺少 access_token 参数', 'Missing access_token parameter', 1),
(2434, 2, '40163', 'oauth_code已使用', 'oauth_ Code used', 1),
(2435, 2, '40155', '请勿添加其他公众号的主页链接', 'Do not add links to other wechat home pages', 1),
(2436, 2, '40137', '不支持的图片格式', 'Unsupported picture format', 1),
(2437, 2, '40132', '微信号不合法', 'Wechat number is illegal', 1),
(2438, 2, '40125', '无效的appsecret', 'Invalid appsecret', 1),
(2439, 2, '40121', '不合法的 media_id 类型', 'Illegal media_ ID type', 1),
(2440, 2, '40120', '子 button 类型错误', 'Sub button error in type', 1),
(2441, 2, '40119', 'button 类型错误', 'button error in type', 1),
(2442, 2, '40118', 'media_id 大小不合法', 'media_id Illegal size', 1),
(2443, 2, '40117', '分组名字不合法', 'Illegal group name', 1),
(2444, 2, '40060', '删除单篇图文时，指定的 article_idx 不合法', 'When deleting a single article, the specified article_ Illegal idx', 1),
(2445, 2, '40051', '分组名字不合法', 'Illegal group name', 1),
(2446, 2, '40050', '不合法的分组 id', 'Illegal grouping ID', 1),
(2447, 2, '40048', '无效的url', 'Invalid URL', 1),
(2448, 2, '40039', '不合法的 URL 长度', 'Illegal URL length', 1),
(2449, 2, '40035', '不合法的参数', 'Illegal parameter', 1),
(2450, 2, '40038', '不合法的请求格式', 'Illegal request format', 1),
(2451, 2, '40033', '不合法的请求字符，不能包含 \\uxxxx 格式的字符', 'Illegal request character, cannot contain characters in \\uxxxx format', 1),
(2452, 2, '40032', '不合法的 openid 列表长度', 'Illegal openid list length', 1),
(2453, 2, '40031', '不合法的 openid 列表', 'Illegal openid list', 1),
(2454, 2, '40030', '不合法的 refresh_token', 'Illegal refresh_token', 1),
(2455, 2, '40029', '无效的 oauth_code', 'Invalid OAuth_ code', 1),
(2456, 2, '40028', '不合法的自定义菜单使用用户', 'Illegal user-defined menu user', 1),
(2457, 2, '40027', '不合法的子菜单按钮 URL 长度', 'Illegal submenu button URL length', 1),
(2458, 2, '40026', '不合法的子菜单按钮 KEY 长度', 'Illegal submenu button key length', 1),
(2459, 2, '40025', '不合法的子菜单按钮名字长度', 'Illegal submenu button name length', 1),
(2460, 2, '40024', '不合法的子菜单按钮类型', 'Illegal submenu button type', 1),
(2461, 2, '40023', '不合法的子菜单按钮个数', 'Number of illegal submenu buttons', 1),
(2462, 2, '40022', '不合法的子菜单级数', 'Illegal submenu level', 1),
(2463, 2, '40021', '不合法的菜单版本号', 'Illegal menu version number', 1),
(2464, 2, '40020', '不合法的按钮 URL 长度', 'Illegal button URL length', 1),
(2465, 2, '40019', '不合法的按钮 KEY 长度', 'Illegal button key length', 1),
(2466, 2, '40018', '不合法的按钮名字长度', 'Illegal button name length', 1),
(2467, 2, '40017', '不合法的按钮类型', 'Illegal button type', 1),
(2468, 2, '40016', '不合法的按钮个数', 'Number of illegal buttons', 1),
(2469, 2, '40015', '不合法的菜单类型', 'Illegal menu type', 1),
(2470, 2, '40014', '不合法的 access_token ，请开发者认真比对 access_token 的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口', 'Illegal access_ Token, please compare access carefully_ The validity of the token (for example, whether it is expired), or check whether the interface is being called for the appropriate official account', 1),
(2471, 2, '40013', '不合法的 AppID ，请开发者检查 AppID 的正确性，避免异常字符，注意大小写', 'Illegal appid, please check the correctness of appid, avoid abnormal characters, and pay attention to case', 1),
(2472, 2, '40012', '不合法的缩略图文件大小', 'Illegal thumbnail file size', 1),
(2473, 2, '40011', '不合法的视频文件大小', 'Illegal video file size', 1),
(2474, 2, '40010', '不合法的语音文件大小', 'Illegal voice file size', 1),
(2475, 2, '40009', '不合法的图片文件大小', 'Illegal picture file size', 1),
(2476, 2, '40008', '不合法的消息类型', 'Illegal message type', 1),
(2477, 2, '40007', '不合法的媒体文件 id', 'Illegal media file ID', 1),
(2478, 2, '40006', '不合法的文件大小', 'Illegal file size', 1),
(2479, 2, '40005', '不合法的文件类型', 'Illegal file type', 1),
(2480, 2, '40004', '不合法的媒体文件类型', 'Illegal media file type', 1),
(2481, 2, '40003', '不合法的 OpenID ，请开发者确认 OpenID （该用户）是否已关注公众号，或是否是其他公众号的 OpenID', 'Illegal openid. Please confirm whether openid (the user) has paid attention to wechat or whether it is the openid of other wechat', 1),
(2482, 2, '40002', '不合法的凭证类型', 'Illegal voucher type', 1),
(2483, 2, '40001', '获取 access_token 时 AppSecret 错误，或者 access_token 无效。请开发者认真比对 AppSecret 的正确性，或查看是否正在为恰当的公众号调用接口', 'Get access_ Appsecret error in token, or access_ The token is invalid. Please carefully compare the correctness of appsecret or check whether the interface is being called for the appropriate wechat', 1),
(2484, 2, '200011', '此账号已被封禁，无法操作', 'This account has been banned and cannot be operated', 1),
(2485, 2, '200012', '个人模版数已达上限，上限25个', 'The number of personal templates has reached the upper limit, the upper limit is 25', 1),
(2486, 2, '200014', '请检查小程序所属类目', 'Please check the category of the applet', 1),
(2487, 3, '100000', '保存成功', '保存成功', 1),
(2488, 3, '100001', '修改成功', '修改成功', 1),
(2489, 3, '100002', '删除成功', '刪除成功', 1),
(2490, 3, '100003', '显示成功', '顯示成功', 1),
(2491, 3, '100004', '隐藏成功', '隱藏成功', 1),
(2492, 3, '100005', '操作失败', '操作失敗', 1),
(2493, 3, '100006', '保存失败', '保存失敗', 1),
(2494, 3, '100007', '修改失败', '修改失敗', 1),
(2495, 3, '100008', '删除失败', '刪除失敗', 1),
(2496, 3, '100009', '图片上传成功', '圖片上傳成功', 1),
(2497, 3, '100010', '操作成功', '操作成功', 1),
(2498, 3, '100011', '暂无数据', '暫無數據', 1),
(2499, 3, '100012', '更新成功', '更新成功', 1),
(2500, 3, '100013', '更新失败', '更新失敗', 1),
(2501, 3, '100014', '设置成功', '設置成功', 1),
(2502, 3, '100015', '设置失败', '設置失敗', 1),
(2503, 3, '100016', '获取失败', '獲取失敗', 1),
(2504, 3, '100017', '提交成功', '提交成功', 1),
(2505, 3, '100018', '提交失败', '提交失敗', 1),
(2506, 3, '100019', '取消成功', '取消成功', 1),
(2507, 3, '100020', '取消失败', '取消失敗', 1),
(2508, 3, '100021', '添加成功', '添加成功', 1),
(2509, 3, '100022', '添加失败', '添加失敗', 1),
(2510, 3, '100023', '保存token失败', '保存token失敗', 1),
(2511, 3, '100024', '备注成功', '備註成功', 1),
(2512, 3, '100025', '备注失败', '備註失敗', 1),
(2513, 3, '100026', '数据不存在', '數據不存在', 1),
(2514, 3, '100027', '申请成功', '申請成功', 1),
(2515, 3, '100028', '申请失败', '申請失敗', 1),
(2516, 3, '100029', '暂无此方法', '暫無此方法', 1),
(2517, 3, '100030', '发送成功', '發送成功', 1),
(2518, 3, '100031', '发送失败', '發送失敗', 1),
(2519, 3, '100032', '上传成功', '上傳成功', 1),
(2520, 3, '100033', '上传失败', '上傳失敗', 1),
(2521, 3, '100034', '移动成功', '移動成功', 1),
(2522, 3, '100035', '移动失败', '移動失敗', 1),
(2523, 3, '100036', '退款成功', '退款成功', 1),
(2524, 3, '100037', '退款失败', '退款失敗', 1),
(2525, 3, '100038', '同步成功', '同步成功', 1),
(2526, 3, '100039', '同步失败', '同步失敗', 1),
(2527, 3, '100040', '恢复成功', '恢復成功', 1),
(2528, 3, '100041', '恢复失败', '恢復失敗', 1),
(2529, 3, '100042', '退出成功', '退出成功', 1),
(2530, 3, '100043', '退出失败', '退出失敗', 1),
(2531, 3, '100044', '开通成功', '開通成功', 1),
(2532, 3, '100045', '开通失败', '開通失敗', 1),
(2533, 3, '100046', '清除数据成功', '清除數據成功', 1),
(2534, 3, '100047', '优化成功', '優化成功', 1),
(2535, 3, '100048', '优化失败', '優化失敗', 1),
(2536, 3, '100049', '修复成功', '修復成功', 1),
(2537, 3, '100050', '修复失败', '修復失敗', 1),
(2538, 3, '100051', '备份成功', '備份成功', 1),
(2539, 3, '100052', '备份失败', '備份失敗', 1),
(2540, 3, '100100', '参数错误', '參數錯誤', 1),
(2541, 3, '100101', '非法操作', '非法操作', 1),
(2542, 3, '100102', '数据获取失败', '數據獲取失敗', 1),
(2543, 3, '100103', '站点升级中，请稍候访问', '站點升級中，請稍候訪問', 1),
(2544, 3, '100104', '缺少code', '缺少code', 1),
(2545, 3, '110000', '您暂时没有访问权限', '您暫時沒有訪問權限', 1),
(2546, 3, '110001', '接口未授权，您无法访问', '接口未授權，您無法訪問', 1),
(2547, 3, '110002', '请登录', '請登錄', 1),
(2548, 3, '110003', '登录已过期,请重新登录', '登錄已過期,請重新登錄', 1),
(2549, 3, '110004', '登录状态有误,请重新登录', '登錄狀態有誤,請重新登錄', 1),
(2550, 3, '110005', '请登录', '請登錄', 1),
(2551, 3, '110006', '登录已过期,请重新登录', '登錄已過期,請重新登錄', 1),
(2552, 3, '110007', '登录状态有误,请重新登录', '登錄狀態有誤,請重新登錄', 1),
(2553, 3, '400000', '请选择用户头像', '請選擇用戶頭像', 1),
(2554, 3, '400001', '请填写用户昵称', '請填寫用戶暱稱', 1),
(2555, 3, '400002', '请填写评论内容', '請填寫評論內容', 1),
(2556, 3, '400003', '请选择商品分数', '請選擇商品分數', 1),
(2557, 3, '400004', '请选择服务分数', '請選擇服務分數', 1),
(2558, 3, '400005', '商品分数必须是1-5之间的整数', '商品分數必須是1-5之間的整數', 1),
(2559, 3, '400006', '服务分数必须是1-5之间的整数', '服務分數必須是1-5之間的整數', 1),
(2560, 3, '400007', '请选择快递公司', '請選擇快遞公司', 1),
(2561, 3, '400008', '请填写寄件人姓名', '請填寫寄件人姓名', 1),
(2562, 3, '400009', '请输入寄件人手机号码', '請輸入寄件人手機號碼', 1),
(2563, 3, '400010', '寄件人手机号码不正确', '寄件人手機號碼不正確', 1),
(2564, 3, '400011', '请填写寄件人详细地址', '請填寫寄件人詳細地址', 1),
(2565, 3, '400012', '请填写云打印机编号', '請填寫雲打印機編號', 1),
(2566, 3, '400013', '请传入套餐id', '請傳入套餐id', 1),
(2567, 3, '400014', '套餐id必须为数字', '套餐id必須為數字', 1),
(2568, 3, '400015', '请填写套餐金额', '請填寫套餐金額', 1),
(2569, 3, '400016', '请填写购买数量', '請填寫購買數量', 1),
(2570, 3, '400017', '购买数量必须为数字', '購買數量必須為數字', 1),
(2571, 3, '400018', '请填写购买套餐类型', '請填寫購買套餐類型', 1),
(2572, 3, '400019', '您输入的手机号码必须为数字', '您輸入的手機號碼必須為數字', 1),
(2573, 3, '400020', '密码必须填写', '密碼必須填寫', 1),
(2574, 3, '400021', '短信验证码必须为数字', '短信驗證碼必須為數字', 1),
(2575, 3, '400022', '请填写话术内容', '請填寫話術內容', 1),
(2576, 3, '400023', '请填写排序数字', '請填寫排序數字', 1),
(2577, 3, '400024', '请填写排序数字', '請填寫排序數字', 1),
(2578, 3, '400025', '请填写运费模板名称', '請填寫運費模板名稱', 1),
(2579, 3, '400026', '运费信息必须为数组', '運費信息必須為數組', 1),
(2580, 3, '400027', '包邮信息必须为数组', '包郵信息必須為數組', 1),
(2581, 3, '400028', '不送达信息必须为数组', '不送達信息必須為數組', 1),
(2582, 3, '400029', 'type数据格式错误，应为1或2或3', 'type數據格式錯誤，應為1或2或3', 1),
(2583, 3, '400030', 'appoint数据格式错误，应为0或1', 'appoint數據格式錯誤，應為0或1', 1),
(2584, 3, '400031', 'no_delivery数据格式错误，应为0或1', 'no_delivery數據格式錯誤，應為0或1', 1),
(2585, 3, '400032', 'sort数据格式错误，应为整数', 'sort數據格式錯誤，應為整數', 1),
(2586, 3, '400033', '请填写管理员账号', '請填寫管理員賬號', 1),
(2587, 3, '400034', '管理员账号为英文字母', '管理員賬號為英文字母', 1),
(2588, 3, '400035', '请输管理员姓名', '請輸管理員姓名', 1),
(2589, 3, '400036', '请选择管理员身份', '請選擇管理員身份', 1),
(2590, 3, '400037', '身份必须为数组', '身份必須為數組', 1),
(2591, 3, '400038', '请填写城市名称', '請填寫城市名稱', 1),
(2592, 3, '400039', 'level数据格式错误，应为整数', 'level數據格式錯誤，應為整數', 1),
(2593, 3, '400040', 'parent_id数据格式错误，应为整数', 'parent_id數據格式錯誤，應為整數', 1),
(2594, 3, '400041', '请输入有效的网址', '請輸入有效的網址', 1),
(2595, 3, '400042', '一级返佣比例必须为数字', '一級返佣比例必須為數字', 1),
(2596, 3, '400043', '一级返佣比例最多两位小数', '一級返佣比例最多兩位小數', 1),
(2597, 3, '400044', '一级返佣比例填写范围在0-100之间', '一級返佣比例填寫範圍在0-100之間', 1),
(2598, 3, '400045', '二级返佣比例必须为数字', '二級返佣比例必須為數字', 1),
(2599, 3, '400046', '二级返佣比例最多两位小数', '二級返佣比例最多兩位小數', 1),
(2600, 3, '400047', '二级返佣比例填写范围在0-100之间', '二級返佣比例填寫範圍在0-100之間', 1),
(2601, 3, '400048', '待补货数量必须为数字', '待補貨數量必須為數字', 1),
(2602, 3, '400049', '警戒库存必须为数字', '警戒庫存必須為數字', 1),
(2603, 3, '400050', '提现最小金额只能为数字', '提現最小金額只能為數字', 1),
(2604, 3, '400051', '提现最小金额必须大于0', '提現最小金額必須大於0', 1),
(2605, 3, '400052', '佣金冻结时间范围在0-180之间', '佣金凍結時間範圍在0-180之間', 1),
(2606, 3, '400053', '满额分销金额金额必须为数字', '滿額分銷金額金額必須為數字', 1),
(2607, 3, '400054', '积分抵用比例必须为数字', '積分抵用比例必須為數字', 1),
(2608, 3, '400055', '积分抵用比例最多两位小数', '積分抵用比例最多兩位小數', 1),
(2609, 3, '400056', '积分抵用比例必须在0-1000之间', '積分抵用比例必須在0-1000之間', 1),
(2610, 3, '400057', '积分抵用上限必须为数字', '積分抵用上限必須為數字', 1),
(2611, 3, '400058', '积分抵用上限必须大于等于0', '積分抵用上限必須大於等於0', 1),
(2612, 3, '400059', '下单赠送积分必须为数字', '下單贈送積分必須為數字', 1),
(2613, 3, '400060', '下单赠送积分必须在0-1000之间', '下單贈送積分必須在0-1000之間', 1),
(2614, 3, '400061', '普通商品未支付取消订单时间必须为数字', '普通商品未支付取消訂單時間必須為數字', 1),
(2615, 3, '400062', '活动商品未支付取消订单时间必须为数字', '活動商品未支付取消訂單時間必須為數字', 1),
(2616, 3, '400063', '砍价商品未支付取消订单时间必须为数字', '砍價商品未支付取消訂單時間必須為數字', 1),
(2617, 3, '400064', '拼团商品未支付取消订单时间必须为数字', '拼團商品未支付取消訂單時間必須為數字', 1),
(2618, 3, '400065', '订单发货后自动收货时间必须为数字', '訂單發貨後自動收貨時間必須為數字', 1),
(2619, 3, '400066', '满额包邮金额必须为数字', '滿額包郵金額必須為數字', 1),
(2620, 3, '400067', '积分倍数必须大于0', '積分倍數必須大於0', 1),
(2621, 3, '400068', '折扣数必须大于0', '折扣數必須大於0', 1),
(2622, 3, '400069', '积分倍数必须大于0', '積分倍數必須大於0', 1),
(2623, 3, '400070', '折扣数必须大于0', '折扣數必須大於0', 1),
(2624, 3, '400071', '下单赠送经验比率必须为数字', '下單贈送經驗比率必須為數字', 1),
(2625, 3, '400072', '下单赠送经验比率必须大于0', '下單贈送經驗比率必須大於0', 1),
(2626, 3, '400073', '签到赠送经验必须为数字', '簽到贈送經驗必須為數字', 1),
(2627, 3, '400074', '签到赠送经验必须大于0', '簽到贈送經驗必須大於0', 1),
(2628, 3, '400075', '邀请新用户赠送经验必须为数字', '邀請新用戶贈送經驗必須為數字', 1),
(2629, 3, '400076', '邀请新用户赠送经验必须大于0', '邀請新用戶贈送經驗必須大於0', 1),
(2630, 3, '400077', '发货人姓名必须为汉字', '發貨人姓名必須為漢字', 1),
(2631, 3, '400078', '发货人姓名长度在2-10位', '發貨人姓名長度在2-10位', 1),
(2632, 3, '400079', '发货人电话必须为数字', '發貨人電話必須為數字', 1),
(2633, 3, '400080', '发货人电话请填写有效的手机号', '發貨人電話請填寫有效的手機號', 1),
(2634, 3, '400081', '发货人地址只能是汉字、字母、数字', '發貨人地址只能是漢字、字母、數字', 1),
(2635, 3, '400082', '发货人地址长度为10-100位', '發貨人地址長度為10-100位', 1),
(2636, 3, '400083', '电子面单打印机编号必须为数字、字母', '電子麵單打印機編號必須為數字、字母', 1),
(2637, 3, '400084', '电子面单打印机编号长度为10-50位', '電子麵單打印機編號長度為10-50位', 1),
(2638, 3, '400085', '客服反馈长度位10-90位', '客服反饋長度位10-90位', 1),
(2639, 3, '400086', '请填写标签分类名称', '請填寫標籤分類名稱', 1),
(2640, 3, '400087', '请填写标签分类排序', '請填寫標籤分類排序', 1),
(2641, 3, '400088', '标签分类必须为数字', '標籤分類必須為數字', 1),
(2642, 3, '400089', '账号只能为数字和字母', '賬號只能為數字和字母', 1),
(2643, 3, '400090', '限量不能超过商品库存', '限量不能超過商品庫存', 1),
(2644, 3, '400091', '商品已下架或移入回收站', '商品已下架或移入回收站', 1),
(2645, 3, '400092', '占用库存失败', '佔用庫存失敗', 1),
(2646, 3, '400093', '商品已下架或已删除', '商品已下架或已刪除', 1),
(2647, 3, '400094', '请选择有效的商品属性', '請選擇有效的商品屬性', 1),
(2648, 3, '400095', '金额不能小于0', '金額不能小於0', 1),
(2649, 3, '400096', '结束时间不能小于今天', '結束時間不能小於今天', 1),
(2650, 3, '400097', '您不是付费会员', '您不是付費會員', 1),
(2651, 3, '400098', '暂时无法领取', '暫時無法領取', 1),
(2652, 3, '400099', '请先配置小票打印开发者', '請先配置小票打印開發者', 1),
(2653, 3, '400100', '请填写分类名称', '請填寫分類名稱', 1),
(2654, 3, '400101', '该分类已存在', '該分類已存在', 1),
(2655, 3, '400102', '请先删除子分类', '請先刪除子分類', 1),
(2656, 3, '400103', '分类不存在', '分類不存在', 1),
(2657, 3, '400104', '文件名称不能为空', '文件名稱不能為空', 1),
(2658, 3, '400105', '该分类有下级分类，无法修改上级', '該分類有下級分類，無法修改上級', 1),
(2659, 3, '400106', '备注不能为空', '備註不能為空', 1),
(2660, 3, '400107', '请输入姓名', '請輸入姓名', 1),
(2661, 3, '400108', '请输入提现金额', '請輸入提現金額', 1),
(2662, 3, '400109', '请输入支付宝账号', '請輸入支付寶賬號', 1),
(2663, 3, '400110', '请输入微信账号', '請輸入微信賬號', 1),
(2664, 3, '400111', '请输入银行卡号', '請輸入銀行卡號', 1),
(2665, 3, '400112', '请输入开户行', '請輸入開戶行', 1),
(2666, 3, '400113', '拒绝理由不能为空', '拒絕理由不能為空', 1),
(2667, 3, '400114', '不能重复收货', '不能重複收貨', 1),
(2668, 3, '400115', '请先发货或者送货', '請先發貨或者送貨', 1),
(2669, 3, '400116', '收货失败,请稍候再试', '收貨失敗,請稍候再試', 1),
(2670, 3, '400117', '收货成功', '收貨成功', 1),
(2671, 3, '400118', '订单不存在', '訂單不存在', 1),
(2672, 3, '400119', '用户信息不存在', '用戶信息不存在', 1),
(2673, 3, '400120', '快递单号不存在', '快遞單號不存在', 1),
(2674, 3, '400121', '打印成功', '打印成功', 1),
(2675, 3, '400122', '打印失败', '打印失敗', 1),
(2676, 3, '400123', '快递公司编号缺失', '快遞公司編號缺失', 1),
(2677, 3, '400124', '请配置腾讯地图KEY', '請配置騰訊地圖KEY', 1),
(2678, 3, '400125', '请选择门店位置', '請選擇門店位置', 1),
(2679, 3, '400126', '添加的核销员用户已存在', '添加的核銷員用戶已存在', 1),
(2680, 3, '400127', '请选择所属提货点', '請選擇所屬提貨點', 1),
(2681, 3, '400128', '请填写核销员名称', '請填寫核銷員名稱', 1),
(2682, 3, '400129', '请填写核销员电话', '請填寫核銷員電話', 1),
(2683, 3, '400130', '核销员添加成功', '核銷員添加成功', 1),
(2684, 3, '400131', '核销员添加失败', '核銷員添加失敗', 1),
(2685, 3, '400132', '请填写手机号', '請填寫手機號', 1),
(2686, 3, '400133', '请填写账号', '請填寫賬號', 1),
(2687, 3, '400134', '请填写密码', '請填寫密碼', 1),
(2688, 3, '400135', '请填写短信签名', '請填寫短信簽名', 1),
(2689, 3, '400136', '短信签名最长为8位', '短信簽名最長為8位', 1),
(2690, 3, '400137', '请填写验证码', '請填寫驗證碼', 1),
(2691, 3, '400138', '请填写域名', '請填寫域名', 1),
(2692, 3, '400139', '登录成功', '登錄成功', 1),
(2693, 3, '400140', '账号或密码错误', '賬號或密碼錯誤', 1),
(2694, 3, '400141', '请先填写短信配置', '請先填寫短信配置', 1),
(2695, 3, '400142', '请输入模板名称', '請輸入模板名稱', 1),
(2696, 3, '400143', '请输入模板内容', '請輸入模板內容', 1),
(2697, 3, '400144', '售后订单状态不支持该操作', '售後訂單狀態不支持該操作', 1),
(2698, 3, '400145', '修改退款状态成功', '修改退款狀態成功', 1),
(2699, 3, '400146', '请输入退款金额', '請輸入退款金額', 1),
(2700, 3, '400147', '已退完支付金额，不能再退款了', '已退完支付金額，不能再退款了', 1),
(2701, 3, '400148', '退款金额大于支付金额，请修改退款金额', '退款金額大於支付金額，請修改退款金額', 1),
(2702, 3, '400149', '退款成功', '退款成功', 1),
(2703, 3, '400150', '退款失败', '退款失敗', 1),
(2704, 3, '400151', '验证成功', '驗證成功', 1),
(2705, 3, '400152', '核销成功', '核銷成功', 1),
(2706, 3, '400153', '核销订单未查到', '核銷訂單未查到', 1),
(2707, 3, '400154', '核销失败', '核銷失敗', 1),
(2708, 3, '400155', '订单金额必须填写', '訂單金額必須填寫', 1),
(2709, 3, '400156', '请选择需要删除的订单', '請選擇需要刪除的訂單', 1),
(2710, 3, '400157', '您选择的的订单存在用户未删除的订单', '您選擇的的訂單存在用戶未刪除的訂單', 1),
(2711, 3, '400158', '请选择发货商品', '請選擇發貨商品', 1),
(2712, 3, '400159', '请重新选择发货商品或发货件数', '請重新選擇發貨商品或發貨件數', 1),
(2713, 3, '400160', '订单已删除无法退积分', '訂單已刪除無法退積分', 1),
(2714, 3, '400161', '请输入积分', '請輸入積分', 1),
(2715, 3, '400162', '已退完积分', '已退完積分', 1),
(2716, 3, '400163', '退积分大于支付积分，请修改退积分', '退積分大於支付積分，請修改退積分', 1),
(2717, 3, '400164', '退积分成功', '退積分成功', 1),
(2718, 3, '400165', '退积分失败', '退積分失敗', 1),
(2719, 3, '400166', '请填写开票号', '請填寫開票號', 1),
(2720, 3, '400167', '请填写正确的开票号', '請填寫正確的開票號', 1),
(2721, 3, '400168', '请上传文件', '請上傳文件', 1),
(2722, 3, '400169', '回复成功', '回復成功', 1),
(2723, 3, '400170', '注册成功', '註冊成功', 1),
(2724, 3, '400171', '注册失败', '註冊失敗', 1),
(2725, 3, '400172', '登录失败', '登錄失敗', 1),
(2726, 3, '400173', '获取套餐列表失败', '獲取套餐列表失敗', 1),
(2727, 3, '400174', '获取支付码失败', '獲取支付碼失敗', 1),
(2728, 3, '400175', '请先开通短信服务', '請先開通短信服務', 1),
(2729, 3, '400176', '请先开通物流查询服务', '請先開通物流查詢服務', 1),
(2730, 3, '400177', '请先开通电子面单打印服务', '請先開通電子麵單打印服務', 1),
(2731, 3, '400178', '请先开通商品采集服务', '請先開通商品採集服務', 1),
(2732, 3, '400179', '请设置短信签名', '請設置短信簽名', 1),
(2733, 3, '400180', '修改短信签名成功', '修改短信簽名成功', 1),
(2734, 3, '400181', '默认模板不能删除', '默認模板不能刪除', 1),
(2735, 3, '400182', '管理员信息读取失败', '管理員信息讀取失敗', 1),
(2736, 3, '400183', '密码太过简单，请输入较为复杂的密码', '密碼太過簡單，請輸入較為複雜的密碼', 1),
(2737, 3, '400184', '协议类型不存在', '協議類型不存在', 1),
(2738, 3, '400185', '清除成功', '清除成功', 1),
(2739, 3, '400186', '清除失败', '清除失敗', 1),
(2740, 3, '400187', '请输入名称', '請輸入名稱', 1),
(2741, 3, '400188', '请不要重复添加', '請不要重複添加', 1),
(2742, 3, '400189', '添加数据成功', '添加數據成功', 1),
(2743, 3, '400190', '请输入开始时间', '請輸入開始時間', 1),
(2744, 3, '400191', '请输入持续时间', '請輸入持續時間', 1),
(2745, 3, '400192', '请输入0-23点之前的整点数', '請輸入0-23點之前的整點數', 1),
(2746, 3, '400193', '请输入1-24点之前的整点数', '請輸入1-24點之前的整點數', 1),
(2747, 3, '400194', '开始时间+持续时间不能大于24小时', '開始時間+持續時間不能大於24小時', 1),
(2748, 3, '400195', '时段已占用', '時段已佔用', 1),
(2749, 3, '400196', '请输入签到赠送积分', '請輸入簽到贈送積分', 1),
(2750, 3, '400197', '请输入大于等于0的整数', '請輸入大於等於0的整數', 1),
(2751, 3, '400198', '请填写按钮名称', '請填寫按鈕名稱', 1),
(2752, 3, '400199', '没有查到此身份', '沒有查到此身份', 1),
(2753, 3, '400200', '请输入等级名称', '請輸入等級名稱', 1),
(2754, 3, '400201', '请输入等级', '請輸入等級', 1),
(2755, 3, '400202', '请选择等级图标', '請選擇等級圖標', 1),
(2756, 3, '400203', '二级返佣比例不能大于一级', '二級返佣比例不能大於一級', 1),
(2757, 3, '400204', '当前等级已存在', '當前等級已存在', 1),
(2758, 3, '400205', '添加等级成功', '添加等級成功', 1),
(2759, 3, '400206', '编辑的等级不存在', '編輯的等級不存在', 1),
(2760, 3, '400207', '请输入任务名称', '請輸入任務名稱', 1),
(2761, 3, '400208', '请选择任务类型', '請選擇任務類型', 1),
(2762, 3, '400209', '请输入限定数量', '請輸入限定數量', 1),
(2763, 3, '400210', '添加任务成功', '添加任務成功', 1),
(2764, 3, '400211', '编辑的任务不存在', '編輯的任務不存在', 1),
(2765, 3, '400212', '获取推广二维码失败，请检查您的微信配置', '獲取推廣二維碼失敗，請檢查您的微信配置', 1),
(2766, 3, '400213', '上级推广人不能为自己', '上級推廣人不能為自己', 1),
(2767, 3, '400214', '用户不存在', '用戶不存在', 1),
(2768, 3, '400215', '上级用户不存在', '上級用戶不存在', 1),
(2769, 3, '400216', '当前推广人已经是所选人', '當前推廣人已經是所選人', 1),
(2770, 3, '400217', '上级推广人不能为自己下级', '上級推廣人不能為自己下級', 1),
(2771, 3, '400218', '赠送成功', '贈送成功', 1),
(2772, 3, '400219', '赠送失败', '贈送失敗', 1),
(2773, 3, '400220', '请输入身份名称', '請輸入身份名稱', 1),
(2774, 3, '400221', '请选择最少一个权限', '請選擇最少一個權限', 1),
(2775, 3, '400222', '添加身份成功', '添加身份成功', 1),
(2776, 3, '400223', '添加身份失败', '添加身份失敗', 1),
(2777, 3, '400224', '缺少APPID', '缺少APPID', 1),
(2778, 3, '400225', '请先设置空间域名', '請先設置空間域名', 1),
(2779, 3, '400226', '格式错误，请输入格式为：http://域名', '格式錯誤，請輸入格式為：http://域名', 1),
(2780, 3, '400227', '未有正在使用的存储空间', '未有正在使用的存儲空間', 1),
(2781, 3, '400228', '切换云存储成功,请检查是否开启使用了存储空间', '切換雲存儲成功,請檢查是否開啟使用了存儲空間', 1),
(2782, 3, '400229', '切换本地存储成功', '切換本地存儲成功', 1),
(2783, 3, '400230', '请输入模板编号', '請輸入模板編號', 1),
(2784, 3, '400231', '请输入模板编号已存在,请重新输入', '請輸入模板編號已存在,請重新輸入', 1),
(2785, 3, '400232', '请输入模板ID', '請輸入模板ID', 1),
(2786, 3, '400233', '请输入模板名', '請輸入模板名', 1),
(2787, 3, '400234', '请输入回复内容', '請輸入回复內容', 1),
(2788, 3, '400235', '添加模板消息成功', '添加模板消息成功', 1),
(2789, 3, '400236', '请先配置小程序appid、appSecret等参数', '請先配置小程序appid、appSecret等參數', 1),
(2790, 3, '400237', '二维码生成失败', '二維碼生成失敗', 1),
(2791, 3, '400238', '请添加至少一个按钮', '請添加至少一個按鈕', 1),
(2792, 3, '400239', '请输入关键字', '請輸入關鍵字', 1),
(2793, 3, '400240', '请选择回复类型', '請選擇回复類型', 1),
(2794, 3, '400241', '回复类型有误', '回复類型有誤', 1),
(2795, 3, '400242', '回复消息参数有误', '回复消息參數有誤', 1),
(2796, 3, '400243', '请添加图文', '請添加圖文', 1),
(2797, 3, '400244', '标题不能为空', '標題不能為空', 1),
(2798, 3, '400245', '作者不能为空', '作者不能為空', 1),
(2799, 3, '400246', '正文不能为空', '正文不能為空', 1),
(2800, 3, '400247', '摘要不能为空', '摘要不能為空', 1),
(2801, 3, '400248', '请先配置微信公众号appid、appSecret等参数', '請先配置微信公眾號appid、appSecret等參數', 1),
(2802, 3, '400249', '模版消息一键设置成功', '模版消息一鍵設置成功', 1),
(2803, 3, '400250', '请选择用户', '請選擇用戶', 1),
(2804, 3, '400251', '该用户没有绑定手机号，请手动填写', '該用戶沒有綁定手機號，請手動填寫', 1),
(2805, 3, '400252', '手机号格式错误', '手機號格式錯誤', 1),
(2806, 3, '400253', '客服已存在', '客服已存在', 1),
(2807, 3, '400254', '请输入账号', '請輸入賬號', 1),
(2808, 3, '400255', '账号必须为数字或者字母的组合4-30位', '賬號必須為數字或者字母的組合4-30位', 1),
(2809, 3, '400256', '请输入密码', '請輸入密碼', 1),
(2810, 3, '400257', '密码必须为数字或者字母的组合6-20位', '密碼必須為數字或者字母的組合6-20位', 1),
(2811, 3, '400258', '该手机号的客服已存在', '該手機號的客服已存在', 1),
(2812, 3, '400259', '该客服账号已存在', '該客服賬號已存在', 1),
(2813, 3, '400260', '客服添加成功', '客服添加成功', 1),
(2814, 3, '400261', '客服添加失败', '客服添加失敗', 1),
(2815, 3, '400262', '客服名称不能为空', '客服名稱不能為空', 1),
(2816, 3, '400263', '请输入确认密码', '請輸入確認密碼', 1),
(2817, 3, '400264', '两次输入的密码不一致', '兩次輸入的密碼不一致', 1),
(2818, 3, '400265', '用户不存在，客服将强制禁止登录', '用戶不存在，客服將強制禁止登錄', 1),
(2819, 3, '400266', '登录的客服不存在', '登錄的客服不存在', 1),
(2820, 3, '400267', '请先填写客服账号和密码再尝试进入客服平台', '請先填寫客服賬號和密碼再嘗試進入客服平台', 1),
(2821, 3, '400268', '反馈内容不存在', '反饋內容不存在', 1),
(2822, 3, '400269', '话术不能重复添加', '話術不能重複添加', 1),
(2823, 3, '400270', '创建话术成功', '創建話術成功', 1),
(2824, 3, '400271', '创建话术失败', '創建話術失敗', 1),
(2825, 3, '400272', '删除的话术不存在', '刪除的話術不存在', 1),
(2826, 3, '400273', '系统分类不能删除', '系統分類不能刪除', 1),
(2827, 3, '400274', '请输入配置名称', '請輸入配置名稱', 1),
(2828, 3, '400275', '请输入字段名称', '請輸入字段名稱', 1),
(2829, 3, '400276', '请输入配置简介', '請輸入配置簡介', 1),
(2830, 3, '400277', '请输入文本框的宽度', '請輸入文本框的寬度', 1),
(2831, 3, '400278', '请输入正确的文本框的宽度', '請輸入正確的文本框的寬度', 1),
(2832, 3, '400279', '请输入多行文本框的宽度', '請輸入多行文本框的寬度', 1),
(2833, 3, '400280', '请输入多行文本框的高度', '請輸入多行文本框的高度', 1),
(2834, 3, '400281', '请输入正确的多行文本框的宽度', '請輸入正確的多行文本框的寬度', 1),
(2835, 3, '400282', '请输入正确的多行文本框的宽度', '請輸入正確的多行文本框的寬度', 1),
(2836, 3, '400283', '请输入配置参数', '請輸入配置參數', 1),
(2837, 3, '400284', '添加配置成功', '添加配置成功', 1),
(2838, 3, '400285', '一二级返佣比例不能大于100%', '一二級返佣比例不能大於100%', 1),
(2839, 3, '400286', '分销海报不能多于5张', '分銷海報不能多於5張', 1),
(2840, 3, '400287', '提现最低金额只能为数字', '提現最低金額只能為數字', 1),
(2841, 3, '400288', '满额分销最低金额不能为空', '滿額分銷最低金額不能為空', 1),
(2842, 3, '400289', '满额分销最低金额不能小于0', '滿額分銷最低金額不能小於0', 1),
(2843, 3, '400290', '绑定有效期请填写正整数', '綁定有效期請填寫正整數', 1),
(2844, 3, '400291', '请输入标题', '請輸入標題', 1),
(2845, 3, '400292', '添加配置分类成功', '添加配置分類成功', 1),
(2846, 3, '400293', '存在下级配置，无法删除', '存在下級配置，無法刪除', 1),
(2847, 3, '400294', '字段至少存在一个', '字段至少存在一個', 1),
(2848, 3, '400295', '添加数据组成功', '添加數據組成功', 1),
(2849, 3, '400296', '数据关键字已存在', '數據關鍵字已存在', 1),
(2850, 3, '400297', '字段不能为空', '字段不能為空', 1),
(2851, 3, '400298', '不能大于四个', '不能大於四個', 1),
(2852, 3, '400299', '签到天数配置不能大于7天', '簽到天數配置不能大於7天', 1),
(2853, 3, '400300', '关联成功', '關聯成功', 1),
(2854, 3, '400301', '关联失败', '關聯失敗', 1),
(2855, 3, '400302', '数据缓存刷新成功', '數據緩存刷新成功', 1),
(2856, 3, '400303', '数据缓存刷新失败', '數據緩存刷新失敗', 1),
(2857, 3, '400304', '请输入需要更换的域名', '請輸入需要更換的域名', 1),
(2858, 3, '400305', '域名不合法', '域名不合法', 1),
(2859, 3, '400306', '替换成功', '替換成功', 1),
(2860, 3, '400307', '初始化完成', '初始化完成', 1),
(2861, 3, '400308', '备份文件可能已经损坏，请检查', '備份文件可能已經損壞，請檢查', 1),
(2862, 3, '400309', '还原数据出错', '還原數據出錯', 1),
(2863, 3, '400310', '正在还原...', '正在還原...', 1),
(2864, 3, '400311', '还原完成', '還原完成', 1),
(2865, 3, '400312', '权益编辑成功', '權益編輯成功', 1),
(2866, 3, '400313', '卡片生成成功', '卡片生成成功', 1),
(2867, 3, '400314', '手机号已经存在', '手機號已經存在', 1),
(2868, 3, '400315', '请输入正确的身份证', '請輸入正確的身份證', 1),
(2869, 3, '400316', '请选择分组', '請選擇分組', 1),
(2870, 3, '400317', '请选择标签', '請選擇標籤', 1),
(2871, 3, '400318', '加入消息队列成功', '加入消息隊列成功', 1),
(2872, 3, '400319', '注销成功', '註銷成功', 1),
(2873, 3, '400320', '拒绝注销', '拒絕註銷', 1),
(2874, 3, '400321', '请输入分组名称', '請輸入分組名稱', 1),
(2875, 3, '400322', '会员标签不能为空', '會員標籤不能為空', 1),
(2876, 3, '400323', '该分类下有标签，请先删除标签', '該分類下有標籤，請先刪除標籤', 1),
(2877, 3, '400324', '请输入等级名称', '請輸入等級名稱', 1),
(2878, 3, '400325', '请输入等级', '請輸入等級', 1),
(2879, 3, '400326', '请输入等级说明', '請輸入等級說明', 1),
(2880, 3, '400327', '请上传等级图标', '請上傳等級圖標', 1),
(2881, 3, '400328', '请上传等级背景图标', '請上傳等級背景圖標', 1),
(2882, 3, '400329', '请输入升级经验值', '請輸入升級經驗值', 1),
(2883, 3, '400330', '授权成功，写入数据库失败，请检查数据库链接配置', '授權成功，寫入數據庫失敗，請檢查數據庫鏈接配置', 1),
(2884, 3, '400331', '请填写公司名称', '請填寫公司名稱', 1),
(2885, 3, '400332', '请填写授权域名', '請填寫授權域名', 1),
(2886, 3, '400333', '请填写手机号码', '請填寫手機號碼', 1),
(2887, 3, '400334', '请填写订单id', '請填寫訂單id', 1),
(2888, 3, '400335', '申请授权成功', '申請授權成功', 1),
(2889, 3, '400336', '验证码错误', '驗證碼錯誤', 1),
(2890, 3, '400337', '请选择商品', '請選擇商品', 1),
(2891, 3, '400338', '请输入商品名称', '請輸入商品名稱', 1),
(2892, 3, '400339', '请选择背景图', '請選擇背景圖', 1),
(2893, 3, '400340', '请输入直播价格', '請輸入直播價格', 1),
(2894, 3, '400341', '直播价格必须大于0', '直播價格必須大於0', 1),
(2895, 3, '400342', '请输入直播间名称', '請輸入直播間名稱', 1),
(2896, 3, '400343', '请选择背景图', '請選擇背景圖', 1),
(2897, 3, '400344', '请选择分享图', '請選擇分享圖', 1),
(2898, 3, '400345', '请选择主播', '請選擇主播', 1),
(2899, 3, '400346', '请选择直播开始、结束时间', '請選擇直播開始、結束時間', 1),
(2900, 3, '400347', '请填写活动简介', '請填寫活動簡介', 1),
(2901, 3, '400348', '请填写单位', '請填寫單位', 1),
(2902, 3, '400349', '请选择商品轮播图', '請選擇商品輪播圖', 1),
(2903, 3, '400350', '您设置得商品个数超出系统限制', '您設置得商品個數超出系統限制', 1),
(2904, 3, '400351', '模板不存在', '模板不存在', 1),
(2905, 3, '400352', '请输入页面名称', '請輸入頁面名稱', 1),
(2906, 3, '400353', '请选择活动时间段', '請選擇活動時間段', 1),
(2907, 3, '400354', '请填写购买数量限制', '請填寫購買數量限制', 1),
(2908, 3, '400355', '购买数量限制必须大于0', '購買數量限制必須大於0', 1),
(2909, 3, '400356', '请填写帮砍次数', '請填寫幫砍次數', 1),
(2910, 3, '400357', '帮砍次数必须大于0', '幫砍次數必須大於0', 1),
(2911, 3, '400358', '请填写砍价人数', '請填寫砍價人數', 1),
(2912, 3, '400359', '砍价人数必须大于1', '砍價人數必須大於1', 1),
(2913, 3, '400360', '请选择运费模板', '請選擇運費模板', 1),
(2914, 3, '400361', '请填写商品详情', '請填寫商品詳情', 1),
(2915, 3, '400362', '请选择规格', '請選擇規格', 1),
(2916, 3, '400363', '请填写虚拟拼团比例', '請填寫虛擬拼團比例', 1),
(2917, 3, '400364', '虚拟参团人数不能大于成团人数', '虛擬參團人數不能大於成團人數', 1),
(2918, 3, '400365', '虚拟参团人数不能大于成团人数', '虛擬參團人數不能大於成團人數', 1),
(2919, 3, '400366', '请填写单次购买数量', '請填寫單次購買數量', 1),
(2920, 3, '400367', '单次购买数量必须大于0', '單次購買數量必須大於0', 1),
(2921, 3, '400368', '请填写成团人数', '請填寫成團人數', 1),
(2922, 3, '400369', '拼团人数不能小于2人', '拼團人數不能小於2人', 1),
(2923, 3, '400370', '请填写成团有效期', '請填寫成團有效期', 1),
(2924, 3, '400371', '成团有效期必须大于0', '成團有效期必須大於0', 1),
(2925, 3, '400372', '请填写优惠券名称', '請填寫優惠卷名稱', 1),
(2926, 3, '400373', '请选择商品分类', '請選擇商品分類', 1),
(2927, 3, '400374', '请填写优惠券金额', '請填寫優惠卷金額', 1),
(2928, 3, '400375', '请填写优惠券最小使用金额', '請填寫優惠卷最小使用金額', 1),
(2929, 3, '400376', '请填写优惠券有效期', '請填寫優惠卷有效期', 1),
(2930, 3, '400377', '请选择秒杀时间段', '請選擇秒殺時間段', 1),
(2931, 3, '400378', '请填写门店名称', '請填寫門店名稱', 1),
(2932, 3, '400379', '请填写门店简介', '請填寫門店簡介', 1),
(2933, 3, '400380', '请填写门店电话', '請填寫門店電話', 1),
(2934, 3, '400381', '请选择提货点logo', '請選擇提貨點logo', 1),
(2935, 3, '400382', '请选择提货点大图', '請選擇提貨點大圖', 1),
(2936, 3, '400383', '请选择地址', '請選擇地址', 1),
(2937, 3, '400384', '请填写详细地址', '請填寫詳細地址', 1),
(2938, 3, '400385', '请选择经纬度', '請選擇經緯度', 1),
(2939, 3, '400386', '请选择营业时间', '請選擇營業時間', 1),
(2940, 3, '400387', '短信账号必须填写', '短信賬號必須填寫', 1),
(2941, 3, '400388', '短信密码必须填写', '短信密碼必須填寫', 1),
(2942, 3, '400389', '订单号必须存在', '訂單號必須存在', 1),
(2943, 3, '400390', '订单号有误', '訂單號有誤', 1),
(2944, 3, '400391', '订单号必须为字母和数字', '訂單號必須為字母和數字', 1),
(2945, 3, '400392', '订单金额必须填写', '訂單金額必須填寫', 1),
(2946, 3, '400393', '订单金额必须为数字', '訂單金額必須為數字', 1),
(2947, 3, '400394', '订单金额必须填写', '訂單金額必須填寫', 1),
(2948, 3, '400395', '订单金额必须为数字', '訂單金額必須為數字', 1),
(2949, 3, '400396', '订单邮费必须填写', '訂單郵費必須填寫', 1),
(2950, 3, '400397', '订单邮费必须为数字', '訂單郵費必須為數字', 1),
(2951, 3, '400398', '赠送积分必须为数字', '贈送積分必須為數字', 1),
(2952, 3, '400399', '请选择用户头像', '請選擇用戶頭像', 1),
(2953, 3, '400400', '请输入公司名称', '請輸入公司名稱', 1),
(2954, 3, '400401', '添加公司成功', '添加公司成功', 1),
(2955, 3, '400402', '请输入月结账号', '請輸入月結賬號', 1),
(2956, 3, '400403', '请输入月结密码', '請輸入月結密碼', 1),
(2957, 3, '400404', '请输入取件网点', '請輸入取件網點', 1),
(2958, 3, '400405', '缩略图大图尺寸（高）必须为数字', '縮略圖大圖尺寸（高）必須為數字', 1),
(2959, 3, '400406', '缩略图大图尺寸（高）必须大于等于0', '縮略圖大圖尺寸（高）必須大於等於0', 1),
(2960, 3, '400407', '缩略图大图尺寸（宽）必须为数字', '縮略圖大圖尺寸（寬）必須為數字', 1),
(2961, 3, '400408', '缩略图大图尺寸（宽）必须大于等于0', '縮略圖大圖尺寸（寬）必須大於等於0', 1),
(2962, 3, '400409', '缩略图中图尺寸（高）必须为数字', '縮略圖中圖尺寸（高）必須為數字', 1),
(2963, 3, '400410', '缩略图中图尺寸（高）必须大于等于0', '縮略圖中圖尺寸（高）必須大於等於0', 1),
(2964, 3, '400411', '缩略图中图尺寸（宽）必须为数字', '縮略圖中圖尺寸（寬）必須為數字', 1),
(2965, 3, '400412', '缩略图中图尺寸（宽）必须大于等于0', '縮略圖中圖尺寸（寬）必須大於等於0', 1),
(2966, 3, '400413', '缩略图小图尺寸（高）必须为数字', '縮略圖小圖尺寸（高）必須為數字', 1),
(2967, 3, '400414', '缩略图小图尺寸（高）必须大于等于0', '縮略圖小圖尺寸（高）必須大於等於0', 1),
(2968, 3, '400415', '缩略图小图尺寸（宽）必须为数字', '縮略圖小圖尺寸（寬）必須為數字', 1),
(2969, 3, '400416', '缩略图小图尺寸（宽）必须大于等于0', '縮略圖小圖尺寸（寬）必須大於等於0', 1),
(2970, 3, '400417', '水印文字只能是汉字、字母、数字', '水印文字只能是漢字、字母、數字', 1),
(2971, 3, '400418', '水印文字长度为1-10位', '水印文字長度為1-10位', 1),
(2972, 3, '400419', '水印文字大小必须为数字', '水印文字大小必須為數字', 1),
(2973, 3, '400420', '水印文字大小必须大于等于0', '水印文字大小必須大於等於0', 1),
(2974, 3, '400421', '水印横坐标偏移量必须为数字', '水印橫坐標偏移量必須為數字', 1),
(2975, 3, '400422', '水印横坐标偏移量必须大于等于0', '水印橫坐標偏移量必須大於等於0', 1),
(2976, 3, '400423', '水印纵坐标偏移量必须为数字', '水印縱坐標偏移量必須為數字', 1),
(2977, 3, '400424', '水印纵坐标偏移量必须大于等于0', '水印縱坐標偏移量必須大於等於0', 1),
(2978, 3, '400425', '该主播已经存在', '該主播已經存在', 1),
(2979, 3, '400426', '请先去小程序认证主播', '請先去小程序認證主播', 1),
(2980, 3, '400427', '商品已创建', '商品已創建', 1),
(2981, 3, '400428', '审核中或审核失败不允许此操作', '審核中或審核失敗不允許此操作', 1),
(2982, 3, '400429', '在审核中或已经审核通过', '在審核中或已經審核通過', 1),
(2983, 3, '400430', '审核通过或失败', '審核通過或失敗', 1),
(2984, 3, '400431', '商品审核中，无法删除', '商品審核中，無法刪除', 1),
(2985, 3, '400432', '该主播不存在', '該主播不存在', 1),
(2986, 3, '400433', '开播时间需要在当前时间的10分钟后，并且开始时间不能在6个月后', '開播時間需要在當前時間的10分鐘後，並且開始時間不能在6個月後', 1),
(2987, 3, '400434', '开播时间和结束时间间隔不得短于30分钟，不得超过24小时', '開播時間和結束時間間隔不得短於30分鐘，不得超過24小時', 1),
(2988, 3, '400435', '请输入理由', '請輸入理由', 1),
(2989, 3, '400436', '请选择正确的直播商品', '請選擇正確的直播商品', 1),
(2990, 3, '400437', '直播间状态有误', '直播間狀態有誤', 1),
(2991, 3, '400438', '奖品不存在', '獎品不存在', 1),
(2992, 3, '400439', '写入中奖记录失败', '寫入中獎記錄失敗', 1),
(2993, 3, '400440', '请继续参与活动抽奖', '請繼續參與活動抽獎', 1),
(2994, 3, '400441', '已经领取成功', '已經領取成功', 1),
(2995, 3, '400442', '分销等级不存在', '分銷等級不存在', 1),
(2996, 3, '400443', '选择的等级不存在', '選擇的等級不存在', 1),
(2997, 3, '400444', '该等级已存在此类型任务', '該等級已存在此類型任務', 1),
(2998, 3, '400445', '不能小于低等级同类型任务限定数量', '不能小於低等級同類型任務限定數量', 1),
(2999, 3, '400446', '不能大于高等级同类型任务限定数量', '不能大於高等級同類型任務限定數量', 1),
(3000, 3, '400447', '解除失败', '解除失敗', 1),
(3001, 3, '400448', '代理商佣金比例不能大于事业部佣金比例', '代理商佣金比例不能大於事業部佣金比例', 1),
(3002, 3, '400449', '代理商到期时间不能大于事业部到期时间', '代理商到期時間不能大於事業部到期時間', 1),
(3003, 3, '400450', '请填写用户UID', '請填寫用戶UID', 1),
(3004, 3, '400451', '管理员信息未查到', '管理員信息未查到', 1),
(3005, 3, '400452', '管理员已经删除', '管理員已經刪除', 1),
(3006, 3, '400453', '管理员姓名不能为空', '管理員姓名不能為空', 1),
(3007, 3, '400454', '该分类有下级分类，无法删除', '該分類有下級分類，無法刪除', 1),
(3008, 3, '400455', '该分类下有文章，无法删除', '該分類下有文章，無法刪除', 1),
(3009, 3, '400456', '请稍后查看', '請稍後查看', 1),
(3010, 3, '400457', '默认模板不能删除', '默認模板不能刪除', 1),
(3011, 3, '400458', '该模板使用中，无法删除', '該模板使用中，無法刪除', 1),
(3012, 3, '400459', '个人中心模板不存在', '個人中心模板不存在', 1),
(3013, 3, '400460', '反馈内容没有查到', '反饋內容沒有查到', 1),
(3014, 3, '400461', '您修改的话术内容不存在', '您修改的話術內容不存在', 1),
(3015, 3, '400462', '短信平台：{:msg}', '短信平台：{:msg}', 1),
(3016, 3, '400463', '订单商品获取失败,无法打印', '訂單商品獲取失敗,無法打印', 1),
(3017, 3, '400464', '小票打印未开启', '小票打印未開啟', 1),
(3018, 3, '400465', '请先配置小票打印开发者', '請先配置小票打印開發者', 1),
(3019, 3, '400466', '请选择图片', '請選擇圖片', 1),
(3020, 3, '400467', '配送员已存在', '配送員已存在', 1),
(3021, 3, '400468', '同一个手机号的配送员只能添加一个', '同一個手機號的配送員只能添加一個', 1),
(3022, 3, '400469', '配送员名称不能为空', '配送員名稱不能為空', 1),
(3023, 3, '400470', '订单未能查到,不能发货', '訂單未能查到,不能發貨', 1),
(3024, 3, '400471', '订单已删除,不能发货', '訂單已刪除,不能發貨', 1),
(3025, 3, '400472', '订单已发货请勿重复操作', '訂單已發貨請勿重複操作', 1),
(3026, 3, '400473', '核销订单不能发货', '核銷訂單不能發貨', 1),
(3027, 3, '400474', '拼团未完成暂不能发货', '拼團未完成暫不能發貨', 1),
(3028, 3, '400475', '订单有售后申请请先处理', '訂單有售後申請請先處理', 1),
(3029, 3, '400476', '快递公司编缺失', '快遞公司編缺失', 1),
(3030, 3, '400477', '请填写寄件人电话', '請填寫寄件人電話', 1),
(3031, 3, '400478', '请填写寄件人地址', '請填寫寄件人地址', 1),
(3032, 3, '400479', '虚拟发货，无需修改发货信息', '虛擬發貨，無需修改發貨信息', 1),
(3033, 3, '400480', '未发货，请先发货再修改配送信息', '未發貨，請先發貨再修改配送信息', 1),
(3034, 3, '400481', '自提订单无法打印', '自提訂單無法打印', 1),
(3035, 3, '400482', '请先发货', '請先發貨', 1),
(3036, 3, '400483', '请先在系统设置中打开单子面单打印开关', '請先在系統設置中打開單子麵單打印開關', 1),
(3037, 3, '400484', '发票已申请，正在审核打印中', '發票已申請，正在審核打印中', 1),
(3038, 3, '400485', '订单已退款', '訂單已退款', 1),
(3039, 3, '400486', '正在申请退款中', '正在申請退款中', 1),
(3040, 3, '400487', '申请失败', '申請失敗', 1),
(3041, 3, '400488', '未支付无法退款', '未支付無法退款', 1),
(3042, 3, '400489', '回退积分和优惠券失败', '回退積分和優惠卷失敗', 1),
(3043, 3, '400490', '拼团修改失败', '拼團修改失敗', 1),
(3044, 3, '400491', '回退佣金失败', '回退佣金失敗', 1),
(3045, 3, '400492', '余额退款失败', '餘額退款失敗', 1),
(3046, 3, '400493', '购买的优惠券已使用或者已过期', '購買的優惠券已使用或者已過期', 1),
(3047, 3, '400494', '回退积分增加失败', '回退積分增加失敗', 1),
(3048, 3, '400495', '售后订单不存在', '售後訂單不存在', 1),
(3049, 3, '400496', '积分已退或者积分为零无法再退', '積分已退或者積分為零無法再退', 1),
(3050, 3, '400497', '未支付无法退积分', '未支付無法退積分', 1),
(3051, 3, '400498', '订单退积分失败', '訂單退積分失敗', 1),
(3052, 3, '400499', '请输入拒绝退款理由', '請輸入拒絕退款理由', 1),
(3053, 3, '400500', '限制单次购买数量不能大于总购买数量', '限制單次購買數量不能大於總購買數量', 1),
(3054, 3, '400501', '请添加抽奖活动名称', '請添加抽獎活動名稱', 1),
(3055, 3, '400502', '请添加抽奖描述等文案', '請添加抽獎描述等文案', 1),
(3056, 3, '400503', '活动结束时间必须大于开始时间', '活動結束時間必須大於開始時間', 1),
(3057, 3, '400504', '请添加奖品', '請添加獎品', 1),
(3058, 3, '400505', '请填写消耗数量', '請填寫消耗數量', 1),
(3059, 3, '400506', '商品参与其他活动开启，无法开启预售', '商品參與其他活動開啟，無法開啟預售', 1),
(3060, 3, '400507', '活动结束时间不能小于当前时间', '活動結束時間不能小於當前時間', 1),
(3061, 3, '400508', '活动已结束,请重新添加或复制', '活動已結束,請重新添加或複制', 1),
(3062, 3, '400509', '添加优惠券成功', '添加優惠券成功', 1),
(3063, 3, '400510', '发布优惠劵成功', '發布優惠劵成功', 1),
(3064, 3, '400511', '砍价最低价不能大于或等于起始金额', '砍價最低價不能大於或等於起始金額', 1),
(3065, 3, '400512', '砍价人数不能大于{:num}人', '砍價人數不能大於{:num}人', 1),
(3066, 3, '400513', '使用开始时间不能小于领取开始时间', '使用開始時間不能小於領取開始時間', 1),
(3067, 3, '400514', '使用结束时间不能小于领取结束时间', '使用結束時間不能小於領取結束時間', 1),
(3068, 3, '400515', '优惠券不存在', '優惠券不存在', 1),
(3069, 3, '400516', '领取的优惠劵已领完或已过期', '領取的優惠劵已領完或已過期', 1),
(3070, 3, '400517', '已领取过该优惠劵', '已領取過該優惠劵', 1),
(3071, 3, '400518', '抱歉，优惠券已经领取完了', '抱歉，優惠券已經領取完了', 1),
(3072, 3, '400519', '选择用户已拥有该优惠券，请勿重复发放', '選擇用戶已擁有該優惠券，請勿重複發放', 1),
(3073, 3, '400520', '订单已删除', '訂單已刪除', 1),
(3074, 3, '400521', '订单已发货', '訂單已發貨', 1),
(3075, 3, '400522', '暂时不支持其他发货类型', '暫時不支持其他發貨類型', 1),
(3076, 3, '400523', '请输入送货人姓名', '請輸入送貨人姓名', 1),
(3077, 3, '400524', '请输入送货人电话号码', '請輸入送貨人電話號碼', 1),
(3078, 3, '400525', '请输入送货人信息', '請輸入送貨人信息', 1),
(3079, 3, '400526', '请输入正确的送货人电话号码', '請輸入正確的送貨人電話號碼', 1),
(3080, 3, '400527', '请选择电子面单模板', '請選擇電子麵單模板', 1),
(3081, 3, '400528', '电子面单已关闭，请选择其他发货方式', '電子麵單已關閉，請選擇其他發貨方式', 1),
(3082, 3, '400529', '发货失败', '發貨失敗', 1),
(3083, 3, '400530', '订单状态错误', '訂單狀態錯誤', 1),
(3084, 3, '400531', '请输入快递单号', '請輸入快遞單號', 1),
(3085, 3, '400532', '请先发货再修改配送信息', '請先發貨再修改配送信息', 1),
(3086, 3, '400533', '商品不存在', '商品不存在', 1),
(3087, 3, '400534', '您查看的积分商品已被删除', '您查看的積分商品已被刪除', 1),
(3088, 3, '400535', '请添加商品', '請添加商品', 1),
(3089, 3, '400536', '添加抽奖活动失败', '添加抽獎活動失敗', 1),
(3090, 3, '400537', '抽奖活动不存在', '抽獎活動不存在', 1),
(3091, 3, '400538', '请填写奖品名称', '請填寫獎品名稱', 1),
(3092, 3, '400539', '请选择奖品图片', '請選擇獎品圖片', 1),
(3093, 3, '400540', '请填写奖品中奖权重', '請填寫獎品中獎權重', 1),
(3094, 3, '400541', '请选择奖品类型', '請選擇獎品類型', 1),
(3095, 3, '400542', '请填写奖品赠送{:type}数', '請填寫獎品贈送{:type}數', 1),
(3096, 3, '400543', '请选择优惠券', '請選擇優惠券', 1),
(3097, 3, '400544', '生成新订单失败', '生成新訂單失敗', 1),
(3098, 3, '400545', '修改原来订单商品拆分状态失败', '修改原來訂單商品拆分狀態失敗', 1),
(3099, 3, '400546', '新增拆分订单商品信息失败', '新增拆分訂單商品信息失敗', 1),
(3100, 3, '400547', '保存新订单商品信息失败', '保存新訂單商品信息失敗', 1),
(3101, 3, '400548', '协议类型缺失', '協議類型缺失', 1),
(3102, 3, '400549', '请填写协议名称', '請填寫協議名稱', 1),
(3103, 3, '400550', '请填写协议内容', '請填寫協議內容', 1),
(3104, 3, '400551', '该类型协议已经存在', '該類型協議已經存在', 1),
(3105, 3, '400552', '临时二维码获取错误', '臨時二維碼獲取錯誤', 1),
(3106, 3, '400553', '永久二维码获取错误', '永久二維碼獲取錯誤', 1),
(3107, 3, '400554', '请先配置接口密钥', '請先配置接口密鑰', 1),
(3108, 3, '400555', '无法创建文件夹，请检查您的上传目录权限', '無法創建文件夾，請檢查您的上傳目錄權限', 1),
(3109, 3, '400556', '商品参数错误', '商品參數錯誤', 1),
(3110, 3, '400557', '上传方式错误', '上傳方式錯誤', 1),
(3111, 3, '400558', '格式错误', '格式錯誤', 1),
(3112, 3, '400559', '图片流获取失败', '圖片流獲取失敗', 1),
(3113, 3, '400560', '商品详情保存失败', '商品詳情保存失敗', 1),
(3114, 3, '400561', '关联优惠券失败', '關聯優惠券失敗', 1),
(3115, 3, '400562', '缺少商品ID', '缺少商品ID', 1),
(3116, 3, '400563', '缺少用户UID', '缺少用戶UID', 1),
(3117, 3, '400564', '缺少订单ID', '缺少訂單ID', 1),
(3118, 3, '400565', '暂不支持该类型记录', '暫不支持該類型記錄', 1),
(3119, 3, '400566', '添加商品记录失败', '添加商品記錄失敗', 1),
(3120, 3, '400567', '评论时间应小于当前时间', '評論時間應小於當前時間', 1),
(3121, 3, '400568', '添加虚拟评论失败', '添加虛擬評論失敗', 1),
(3122, 3, '400569', '回复失败', '回复失敗', 1),
(3123, 3, '400570', '请选择限购类型', '請選擇限購類型', 1),
(3124, 3, '400571', '限购数量不能小于1', '限購數量不能小於1', 1),
(3125, 3, '400572', '一二级返佣相加不能大于商品售价', '一二級返佣相加不能大於商品售價', 1),
(3126, 3, '400573', '商品类型不能切换', '商品類型不能切換', 1),
(3127, 3, '400574', '请输入规则名称', '請輸入規則名稱', 1),
(3128, 3, '400575', '请输入属性名称', '請輸入屬性名稱', 1),
(3129, 3, '400576', '请输入正确的属性', '請輸入正確的屬性', 1),
(3130, 3, '400577', '请填写正确的商品信息', '請填寫正確的商品信息', 1),
(3131, 3, '400578', '请填写正确的商品价格', '請填寫正確的商品價格', 1),
(3132, 3, '400579', '请填写正确的商品库存', '請填寫正確的商品庫存', 1),
(3133, 3, '400580', '请填写正确的商品成本价格', '請填寫正確的商品成本價格', 1),
(3134, 3, '400581', '请上传商品图片', '請上傳商品圖片', 1),
(3135, 3, '400582', '{:name}规格不存在', '{:name}規格不存在', 1),
(3136, 3, '400583', '{:name}属性不存在', '{:name}屬性不存在', 1),
(3137, 3, '400584', '请设置至少一个属性', '請設置至少一個屬性', 1),
(3138, 3, '400585', '商品参与秒杀活动开启，无法进行此操作', '商品參與秒殺活動開啟，無法進行此操作', 1),
(3139, 3, '400586', '商品参与砍价活动开启，无法进行此操作', '商品參與砍價活動開啟，無法進行此操作', 1),
(3140, 3, '400587', '商品参与拼团活动开启，无法进行此操作', '商品參與拼團活動開啟，無法進行此操作', 1),
(3141, 3, '400588', '会员价格不能为0', '會員價格不能為0', 1),
(3142, 3, '400589', '虚拟优惠券商品请选择优惠券', '虛擬優惠券商品請選擇優惠券', 1),
(3143, 3, '400590', '卡号：{:key}密码：{:value}，已经添加过，请重新添加卡密', '卡號：{:key}密碼：{:value}，已經添加過，請重新添加卡密', 1),
(3144, 3, '400591', '缺少城市id无法保存', '缺少城市id無法保存', 1),
(3145, 3, '400592', '修改的模板不存在', '修改的模板不存在', 1),
(3146, 3, '400593', '指定区域邮费添加失败', '指定區域郵費添加失敗', 1),
(3147, 3, '400594', '管理员不存在', '管理員不存在', 1),
(3148, 3, '400595', '您已被禁止登录', '您已被禁止登錄', 1),
(3149, 3, '400596', '管理员账号已存在', '管理員賬號已存在', 1),
(3150, 3, '400597', '原始密码错误', '原始密碼錯誤', 1),
(3151, 3, '400598', '请输入新密码', '請輸入新密碼', 1),
(3152, 3, '400599', '请选择要删除的图片', '請選擇要刪除的圖片', 1),
(3153, 3, '400600', '移动失败或不能重复移动到同一分类下', '移動失敗或不能重複移動到同一分類下', 1),
(3154, 3, '400601', '请求不被允许', '請求不被允許', 1),
(3155, 3, '400602', '设置类目不被允许', '設置類目不被允許', 1),
(3156, 3, '400603', '请输入正确格式的配置参数', '請輸入正確格式的配置參數', 1),
(3157, 3, '400604', '{:name}请输入默认值', '{:name}請輸入默認值', 1),
(3158, 3, '400605', '{:name}请输入正确url', '{:name}請輸入正確url', 1),
(3159, 3, '400606', '保存wss证书失败', '保存wss證書失敗', 1),
(3160, 3, '400607', '{:name}不能为空', '{:name}不能為空', 1),
(3161, 3, '400608', '删除的云存储不存在', '刪除的雲存儲不存在', 1),
(3162, 3, '400609', '云存储正在使用中,需要启动其他空间才能删除', '雲存儲正在使用中,需要啟動其他空間才能刪除', 1),
(3163, 3, '400610', '云空间名称不能重复', '雲空間名稱不能重複', 1),
(3164, 3, '400611', '没有权限', '沒有權限', 1),
(3165, 3, '400612', '替换失败,失败原因:{:msg}', '替換失敗,失敗原因:{:msg}', 1),
(3166, 3, '400613', '请先删除改菜单下的子菜单', '請先刪除改菜單下的子菜單', 1),
(3167, 3, '400614', '请填写批次名称', '請填寫批次名稱', 1),
(3168, 3, '400615', '请填写要生成卡的数量', '請填寫要生成卡的數量', 1),
(3169, 3, '400616', '卡片数量只能为正整数', '卡片數量只能為正整數', 1),
(3170, 3, '400617', '单次制卡数量最高不得超过6000张', '單次製卡數量最高不得超過6000張', 1),
(3171, 3, '400618', '请填写免费使用天数', '請填寫免費使用天數', 1),
(3172, 3, '400619', '免费使用天数只能为正整数', '免費使用天數只能為正整數', 1),
(3173, 3, '400620', '生成卡失败', '生成卡失敗', 1),
(3174, 3, '400621', '会员功能暂未开启', '會員功能暫未開啟', 1),
(3175, 3, '400622', '请输入会员卡号', '請輸入會員卡號', 1),
(3176, 3, '400623', '请输入领取卡密', '請輸入領取卡密', 1),
(3177, 3, '400624', '会员卡不存在', '會員卡不存在', 1),
(3178, 3, '400625', '会员卡未激活，暂无法使用', '會員卡未激活，暫無法使用', 1),
(3179, 3, '400626', '会员卡密码有误', '會員卡密碼有誤', 1),
(3180, 3, '400627', '会员卡已使用', '會員卡已使用', 1),
(3181, 3, '400628', '您已是永久会员，无需再领取，可以将此卡转送亲朋好友，一起享受优惠', '您已是永久會員，無需再領取，可以將此卡轉送親朋好友，一起享受優惠', 1),
(3182, 3, '400629', '暂无此类型会员卡', '暫無此類型會員卡', 1),
(3183, 3, '400630', '会员权益类型缺失', '會員權益類型缺失', 1),
(3184, 3, '400631', '请设置权益名称', '請設置權益名稱', 1),
(3185, 3, '400632', '请上传会员权益图标', '請上傳會員權益圖標', 1),
(3186, 3, '400633', '请设置返还积分倍数', '請設置返還積分倍數', 1),
(3187, 3, '400634', '返还积分倍数不能为负数', '返還積分倍數不能為負數', 1),
(3188, 3, '400635', '请设置运费折扣', '請設置運費折扣', 1),
(3189, 3, '400636', '运费折扣不能为负数', '運費折扣不能為負數', 1),
(3190, 3, '400637', '请设置签到积分倍数', '請設置簽到積分倍數', 1),
(3191, 3, '400638', '签到积分倍数不能为负数', '簽到積分倍數不能為負數', 1),
(3192, 3, '400639', '请设置线下付款折扣', '請設置線下付款折扣', 1),
(3193, 3, '400640', '线下付款不能为负数', '線下付款不能為負數', 1),
(3194, 3, '400641', '请填写会员卡名称', '請填寫會員卡名稱', 1),
(3195, 3, '400642', '会员卡类型缺失', '會員卡類型缺失', 1),
(3196, 3, '400643', '请填写有效期（天）', '請填寫有效期（天）', 1),
(3197, 3, '400644', '有效期（天）不能为负数', '有效期（天）不能為負數', 1),
(3198, 3, '400645', '请填写价格', '請填寫價格', 1),
(3199, 3, '400646', '价格不能为负数', '價格不能為負數', 1),
(3200, 3, '400647', '优惠价不能大于原价', '優惠價不能大於原價', 1),
(3201, 3, '400648', '地址不存在', '地址不存在', 1),
(3202, 3, '400649', '取消原来默认地址失败', '取消原來默認地址失敗', 1),
(3203, 3, '400650', '设置默认地址失败', '設置默認地址失敗', 1),
(3204, 3, '400651', '地址已存在', '地址已存在', 1),
(3205, 3, '400652', '收货地址格式错误', '收貨地址格式錯誤', 1),
(3206, 3, '400653', '请登录', '請登錄', 1),
(3207, 3, '400654', '登录已过期,请重新登录', '登錄已過期,請重新登錄', 1),
(3208, 3, '400655', '增加记录失败', '增加記錄失敗', 1),
(3209, 3, '400656', '记录分享记录失败', '記錄分享記錄失敗', 1),
(3210, 3, '400657', '增加用户佣金失败', '增加用戶佣金失敗', 1),
(3211, 3, '400658', '企业付款到零钱失败，请稍后再试', '企業付款到零錢失敗，請稍後再試', 1),
(3212, 3, '400659', '已经提现', '已經提現', 1),
(3213, 3, '400660', '您的提现申请已被拒绝', '您的提現申請已被拒絕', 1),
(3214, 3, '400661', '可提现佣金不足', '可提現佣金不足', 1),
(3215, 3, '400662', '提现金额不能小于{:money}元', '提現金額不能小於{:money}元', 1),
(3216, 3, '400663', '提现佣金不足{:money}元', '提現佣金不足{:money}元', 1),
(3217, 3, '400664', '提现佣金大于0', '提現佣金大於0', 1),
(3218, 3, '400665', '企业微信付款到零钱最低金额为1元', '企業微信付款到零錢最低金額為1元', 1),
(3219, 3, '400666', '该分组已经存在', '該分組已經存在', 1),
(3220, 3, '400667', '清空用户标签失败', '清空用戶標籤失敗', 1),
(3221, 3, '400668', '设置标签失败', '設置標籤失敗', 1),
(3222, 3, '400669', '请选择标签分类', '請選擇標籤分類', 1),
(3223, 3, '400670', '该标签已经存在', '該標籤已經存在', 1),
(3224, 3, '400671', '修改用户等级信息失败', '修改用戶等級信息失敗', 1),
(3225, 3, '400672', '用户等级不存在', '用戶等級不存在', 1),
(3226, 3, '400673', '用户等级经验必须大于上一等级设置的经验', '用戶等級經驗必須大於上一等級設置的經驗', 1),
(3227, 3, '400674', '用户等级经验必须小于下一等级设置的经验', '用戶等級經驗必須小於下一等級設置的經驗', 1),
(3228, 3, '400675', '已检测到您设置过的用户等级，此等级不可重复', '已檢測到您設置過的用戶等級，此等級不可重複', 1),
(3229, 3, '400676', '已检测到您设置过该用户等级经验值，经验值不可重复', '已檢測到您設置過該用戶等級經驗值，經驗值不可重複', 1),
(3230, 3, '400677', '订单未支付', '訂單未支付', 1),
(3231, 3, '400678', '佣金转入余额，不能退款', '佣金轉入餘額，不能退款', 1),
(3232, 3, '400679', '已支付的订单记录无法删除', '已支付的訂單記錄無法刪除', 1),
(3233, 3, '400680', '转入金额不能大于可提现佣金', '轉入金額不能大於可提現佣金', 1),
(3234, 3, '400681', '写入余额充值失败', '寫入餘額充值失敗', 1),
(3235, 3, '400682', '您选择的充值方式已下架', '您選擇的充值方式已下架', 1),
(3236, 3, '400683', '充值订单生成失败', '充值訂單生成失敗', 1),
(3237, 3, '400684', '保存用户信息失败', '保存用戶信息失敗', 1),
(3238, 3, '400685', '密码重置失败', '密碼重置失敗', 1),
(3239, 3, '400686', '增加推广人数失败', '增加推廣人數失敗', 1),
(3240, 3, '400687', '设置登录类型失败', '設置登錄類型失敗', 1),
(3241, 3, '400688', '设置推广员失败', '設置推廣員失敗', 1),
(3242, 3, '400689', '增加用户余额失败', '增加用戶餘額失敗', 1),
(3243, 3, '400690', '减少用户余额失败', '減少用戶餘額失敗', 1),
(3244, 3, '400691', '减少用户佣金失败', '減少用戶佣金失敗', 1),
(3245, 3, '400692', '增加用户积分失败', '增加用戶積分失敗', 1),
(3246, 3, '400693', '减少用户积分失败', '減少用戶積分失敗', 1),
(3247, 3, '400694', '增加用户经验失败', '增加用戶經驗失敗', 1),
(3248, 3, '400695', '减少用户经验失败', '減少用戶經驗失敗', 1),
(3249, 3, '400696', '该分组不存在', '該分組不存在', 1),
(3250, 3, '400697', '设置分组失败或无改动', '設置分組失敗或無改動', 1),
(3251, 3, '400698', '有标签不存在或被删除', '有標籤不存在或被刪除', 1),
(3252, 3, '400699', '等级不存在或被删除', '等級不存在或被刪除', 1),
(3253, 3, '400700', '此用户已有该用户等级，无法再次赠送', '此用戶已有該用戶等級，無法再次贈送', 1),
(3254, 3, '400701', '赠送天数不能为0', '贈送天數不能為0', 1),
(3255, 3, '400702', '天数输入错误', '天數輸入錯誤', 1),
(3256, 3, '400703', '用户信息储存失败', '用戶信息儲存失敗', 1),
(3257, 3, '400704', '您得ip不再白名单中,请前往腾讯微信公众平台添加ip白名单', '您得ip不再白名單中,請前往騰訊微信公眾平台添加ip白名單', 1),
(3258, 3, '400705', '您填写得appid无效,请检查', '您填寫得appid無效,請檢查', 1),
(3259, 3, '400706', '请输入回复信息内容', '請輸入回复信息內容', 1),
(3260, 3, '400707', '请上传回复的图片', '請上傳回复的圖片', 1),
(3261, 3, '400708', '请上传回复的声音', '請上傳回复的聲音', 1),
(3262, 3, '400709', '请选择图文消息', '請選擇圖文消息', 1),
(3263, 3, '400710', '对应的uid不存在', '對應的uid不存在', 1),
(3264, 3, '400711', '取消关注失败', '取消關注失敗', 1),
(3265, 3, '400712', '电子面单模板ID缺失', '電子麵單模板ID缺失', 1),
(3266, 3, '400713', '快递公司编码缺失', '快遞公司編碼缺失', 1),
(3267, 3, '400714', '寄件人信息缺失', '寄件人信息缺失', 1),
(3268, 3, '400715', '收件人信息缺失', '收件人信息缺失', 1),
(3269, 3, '400716', '云打印机编号缺失', '雲打印機編號缺失', 1),
(3270, 3, '400717', '商品数量缺失', '商品數量缺失', 1),
(3271, 3, '400718', '获取access_token获取失败', '獲取access_token獲取失敗', 1),
(3272, 3, '400719', '手机号不能为空', '手機號不能為空', 1),
(3273, 3, '400720', '模版ID不存在', '模版ID不存在', 1),
(3274, 3, '400721', '请先配置accessKey和secretKey', '請先配置accessKey和secretKey', 1),
(3275, 3, '400722', '请先配置水印图片', '請先配置水印圖片', 1),
(3276, 3, '400723', '请先配置水印文字', '請先配置水印文字', 1),
(3277, 3, '400724', '远程水印图片下载失败', '遠程水印圖片下載失敗', 1),
(3278, 3, '400725', '上传图片不存在', '上傳圖片不存在', 1),
(3279, 3, '400726', '图片流获取失败', '圖片流獲取失敗', 1),
(3280, 3, '400727', '图片下载失败', '圖片下載失敗', 1),
(3281, 3, '400728', '必须上传xlsx格式文件', '必須上傳xlsx格式文件', 1),
(3282, 3, '400729', '数据不能为空', '數據不能為空', 1),
(3283, 3, '400730', '缺少pay_price', '缺少pay_price', 1),
(3284, 3, '400731', '退款失败:{:msg}', '退款失敗:{:msg}', 1),
(3285, 3, '400732', '获取微信粉丝信息失败', '獲取微信粉絲信息失敗', 1),
(3286, 3, '400733', '您已关闭上传功能', '您已關閉上傳功能', 1),
(3287, 3, '400734', '文件不可写', '文件不可寫', 1),
(3288, 3, '400735', '时间格式不正确', '時間格式不正確', 1),
(3289, 3, '400736', '文件可能损坏，请检查', '文件可能損壞，請檢查', 1),
(3290, 3, '400737', '修复错误，请重试', '修復錯誤，請重試', 1),
(3291, 3, '400738', '请指定要修复的表', '請指定要修復的表', 1),
(3292, 3, '400739', '请配置支付证书', '請配置支付證書', 1),
(3293, 3, '400740', '只支持两级分类', '只支持兩級分類', 1),
(3294, 3, '400741', '运费格式错误', '運費格式錯誤', 1),
(3295, 3, '400742', '请检查属性编码或库存数量', '請檢查屬性編碼或庫存數量', 1),
(3296, 3, '400743', '同步条数不能超过100', '同步條數不能超過100', 1),
(3297, 3, '400744', 'appid或appsecret错误', 'appid或appsecret錯誤', 1),
(3298, 3, '400745', '父级ID参数类型错误', '父級ID參數類型錯誤', 1),
(3299, 3, '400746', '分类名称长度不能超过25个字符', '分類名稱長度不能超過25個字符', 1),
(3300, 3, '400747', '分类图标长度不能超过128个字符', '分類圖標長度不能超過128個字符', 1),
(3301, 3, '400748', '分类大图长度不能超过200个字符', '分類大圖長度不能超過200個字符', 1),
(3302, 3, '400749', '排序参数类型错误', '排序參數類型錯誤', 1),
(3303, 3, '400750', '排序不能小于0', '排序不能小於0', 1),
(3304, 3, '400751', '状态必须是0-1之间的整数', '狀態必須是0-1之間的整數', 1),
(3305, 3, '400752', '权益简介不能大于8个字', '權益簡介不能大於8個字', 1),
(3306, 3, '400753', '提现方式最少选一种', '提現方式最少選一種', 1),
(3307, 3, '400754', '身份使用中，无法删除', '身份使用中，無法刪除', 1),
(3308, 3, '400755', '展示名称不能大于6个字', '展示名稱不能大於6個字', 1),
(3309, 3, '400756', '推广佣金单价不能小于0', '推廣佣金單價不能小於0', 1),
(3310, 3, '400757', '每日推广佣金上限不能小于-1', '每日推廣佣金上限不能小於-1', 1),
(3311, 3, '400758', '请核对领取方式', '請核對領取方式', 1),
(3312, 3, '400759', '请输入优惠券名称', '請輸入優惠券名稱', 1),
(3313, 3, '400760', '请输入真实姓名', '請輸入真實姓名', 1),
(3314, 3, '400761', '描述内容不能超过120字', '描述內容不能超過120字', 1),
(3315, 3, '400762', '账号密码必须是在6到32位之间', '賬號密碼必須是在6到32位之間', 1),
(3316, 3, '400763', '商户号不能为空', '商戶號不能為空', 1),
(3317, 3, '410000', '请输入账号和密码', '請輸入賬號和密碼', 1),
(3318, 3, '410001', '登录成功', '登錄成功', 1),
(3319, 3, '410002', '退出成功', '退出成功', 1),
(3320, 3, '410003', '发送验证码失败,请刷新页面重新获取', '發送驗證碼失敗,請刷新頁面重新獲取', 1),
(3321, 3, '410004', '请输入验证码', '請輸入驗證碼', 1),
(3322, 3, '410005', '验证码输入有误', '驗證碼輸入有誤', 1),
(3323, 3, '410006', '验证码已发送', '驗證碼已發送', 1),
(3324, 3, '410007', '验证码发送成功', '驗證碼發送成功', 1),
(3325, 3, '410008', '验证码发送失败', '驗證碼發送失敗', 1),
(3326, 3, '410009', '请先获取验证码', '請先獲取驗證碼', 1),
(3327, 3, '410010', '验证码错误', '驗證碼錯誤', 1),
(3328, 3, '410011', '密码必须是在6到16位之间', '密碼必須是在6到16位之間', 1),
(3329, 3, '410012', '密码太过简单，请输入较为复杂的密码', '密碼太過簡單，請輸入較為複雜的密碼', 1),
(3330, 3, '410013', '注册成功', '註冊成功', 1),
(3331, 3, '410014', '注册失败', '註冊失敗', 1),
(3332, 3, '410015', '请输入手机号', '請輸入手機號', 1),
(3333, 3, '410016', '绑定成功', '綁定成功', 1),
(3334, 3, '410017', '绑定失败', '綁定失敗', 1),
(3335, 3, '410018', '手机号格式不正确', '手機號格式不正確', 1),
(3336, 3, '410019', '登录失败', '登錄失敗', 1),
(3337, 3, '410020', '扫码失败请重新扫描', '掃碼失敗請重新掃描', 1),
(3338, 3, '410021', '二维码已过期请重新扫描', '二維碼已過期請重新掃描', 1),
(3339, 3, '410022', '授权成功，请绑定手机号', '授權成功，請綁定手機號', 1),
(3340, 3, '410023', '授权成功', '授權成功', 1),
(3341, 3, '410024', '请先关注公众号', '請先關注公眾號', 1),
(3342, 3, '410025', '账号或密码错误', '賬號或密碼錯誤', 1),
(3343, 3, '410026', '请修改您的初始密码，再尝试登录', '請修改您的初始密碼，再嘗試登錄', 1),
(3344, 3, '410027', '您已被禁止登录，请联系管理员', '您已被禁止登錄，請聯繫管理員', 1),
(3345, 3, '410028', '手机号已注册', '手機號已註冊', 1),
(3346, 3, '410029', '您今日发送得短信次数已经达到上限', '您今日發送得短信次數已經達到上限', 1),
(3347, 3, '410030', '此IP今日发送次数已经达到上限', '此IP今日發送次數已經達到上限', 1),
(3348, 3, '410031', '短信平台验证码发送失败', '短信平台驗證碼發送失敗', 1),
(3349, 3, '410032', '用户不存在', '用戶不存在', 1),
(3350, 3, '410033', '修改密码失败', '修改密碼失敗', 1),
(3351, 3, '410034', '用户登录失败,无法生成新用户,请稍后再试', '用戶登錄失敗,無法生成新用戶,請稍後再試', 1),
(3352, 3, '410035', '用户不存在,无法切换', '用戶不存在,無法切換', 1),
(3353, 3, '410036', '修改新用户登录类型出错', '修改新用戶登錄類型出錯', 1),
(3354, 3, '410037', '请刷新页面或者重新授权', '請刷新頁面或者重新授權', 1),
(3355, 3, '410038', '获取用户访问token失败', '獲取用戶訪問token失敗', 1),
(3356, 3, '410039', '此手机已经绑定，无法多次绑定', '此手機已經綁定，無法多次綁定', 1),
(3357, 3, '410040', '您的账号已经绑定过手机号码', '您的賬號已經綁定過手機號碼', 1),
(3358, 3, '410041', 'H5已有账号是否绑定此账号上', 'H5已有賬號是否綁定此賬號上', 1),
(3359, 3, '410042', '新手机号和原手机号相同，无需修改', '新手機號和原手機號相同，無需修改', 1),
(3360, 3, '410043', '此手机已经注册', '此手機已經註冊', 1),
(3361, 3, '410044', '用户信息获取失败', '用戶信息獲取失敗', 1),
(3362, 3, '410045', '请选择收货地址', '請選擇收貨地址', 1),
(3363, 3, '410046', '地址选择有误', '地址選擇有誤', 1),
(3364, 3, '410047', '可用积分不足', '可用積分不足', 1),
(3365, 3, '410048', '奖品不存在', '獎品不存在', 1),
(3366, 3, '410049', '写入中奖记录失败', '寫入中獎記錄失敗', 1),
(3367, 3, '410050', '请继续参与活动抽奖', '請繼續參與活動抽獎', 1),
(3368, 3, '410051', '已经领取成功', '已經領取成功', 1),
(3369, 3, '410052', '请输入收货人信息', '請輸入收貨人信息', 1),
(3370, 3, '410053', '请输入正确的收货人电话', '請輸入正確的收貨人電話', 1),
(3371, 3, '410054', '抽奖记录不存在', '抽獎記錄不存在', 1),
(3372, 3, '410055', '该奖品不需要发货', '該獎品不需要發貨', 1),
(3373, 3, '410056', '请选择快递公司或输入快递单号', '請選擇快遞公司或輸入快遞單號', 1),
(3374, 3, '410057', '活动不存在或已删除', '活動不存在或已刪除', 1),
(3375, 3, '410058', '暂未有该类型活动', '暫未有該類型活動', 1),
(3376, 3, '410059', '您暂时无法参与该活动', '您暫時無法參與該活動', 1),
(3377, 3, '410060', '活动状态有误，请联系管理员', '活動狀態有誤，請聯繫管理員', 1),
(3378, 3, '410061', '可用积分不足，没有更多抽奖次数', '可用積分不足，沒有更多抽獎次數', 1),
(3379, 3, '410062', '余额不足，没有更多抽奖次数', '餘額不足，沒有更多抽獎次數', 1),
(3380, 3, '410063', '购买商品之后获得更多抽奖次数', '購買商品之後獲得更多抽獎次數', 1),
(3381, 3, '410064', '订单完成评价之后获得更多抽奖次数', '訂單完成評價之後獲得更多抽獎次數', 1),
(3382, 3, '410065', '邀请更多好友获取抽奖次数', '邀請更多好友獲取抽獎次數', 1),
(3383, 3, '410066', '抽奖扣除用户积分失败', '抽獎扣除用戶積分失敗', 1),
(3384, 3, '410067', '抽奖失败，余额不足', '抽獎失敗，餘額不足', 1),
(3385, 3, '410068', '抽奖扣除用户余额失败', '抽獎扣除用戶餘額失敗', 1),
(3386, 3, '410069', '抽奖扣除用户推广获取抽奖次数失败', '抽獎扣除用戶推廣獲取抽獎次數失敗', 1),
(3387, 3, '410070', '抽奖减少奖品总数失败', '抽獎減少獎品總數失敗', 1),
(3388, 3, '410071', '分销等级不存在', '分銷等級不存在', 1),
(3389, 3, '410072', '永久二维码获取错误', '永久二維碼獲取錯誤', 1),
(3390, 3, '410073', '邀请码无效', '邀請碼無效', 1),
(3391, 3, '410074', '授权失败,参数有误', '授權失敗,參數有誤', 1),
(3392, 3, '410075', 'openid获取失败', 'openid獲取失敗', 1),
(3393, 3, '410076', '获取session_key失败，请检查您的配置', '獲取session_key失敗，請檢查您的配置', 1),
(3394, 3, '410077', '获取会话密匙失败', '獲取會話密匙失敗', 1),
(3395, 3, '410078', '静默授权失败', '靜默授權失敗', 1),
(3396, 3, '410079', '获取用户信息失败', '獲取用戶信息失敗', 1),
(3397, 3, '410080', '更新信息失败', '更新信息失敗', 1),
(3398, 3, '410081', '请上传二维码', '請上傳二維碼', 1),
(3399, 3, '410082', '请关注公众号', '請關注公眾號', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(3400, 3, '410083', '新增用户失败', '新增用戶失敗', 1),
(3401, 3, '410084', '用户关注失败', '用戶關注失敗', 1),
(3402, 3, '410085', '获取token失败{:msg}', '獲取token失敗{:msg}', 1),
(3403, 3, '410086', '配置已更改或token已失效', '配置已更改或token已失效', 1),
(3404, 3, '410087', '平台错误：发生异常，请稍后重试', '平台錯誤：發生異常，請稍後重試', 1),
(3405, 3, '410088', '企业微信支付到零钱需要支付证书，检测到您没有上传', '企業微信支付到零錢需要支付證書，檢測到您沒有上傳', 1),
(3406, 3, '410089', '发起企业支付到零钱失败', '發起企業支付到零錢失敗', 1),
(3407, 3, '410090', '无效的token不能查找到用户聊天记录', '無效的token不能查找到用戶聊天記錄', 1),
(3408, 3, '410091', '图片上传成功', '圖片上傳成功', 1),
(3409, 3, '410092', '用户uid不再当前聊天用户范围内', '用戶uid不再當前聊天用戶範圍內', 1),
(3410, 3, '410093', '请输入订单价格', '請輸入訂單價格', 1),
(3411, 3, '410094', '请去后台售后订单列表处理', '請去後台售後訂單列表處理', 1),
(3412, 3, '410095', '分类名称不能为空', '分類名稱不能為空', 1),
(3413, 3, '410096', '分类不存在', '分類不存在', 1),
(3414, 3, '410097', '添加的内容重复', '添加的內容重複', 1),
(3415, 3, '410098', '缺少转接人id', '缺少轉接人id', 1),
(3416, 3, '410099', '转接成功', '轉接成功', 1),
(3417, 3, '410100', '话术没有被查到', '話術沒有被查到', 1),
(3418, 3, '410101', '公共话术不能修改', '公共話術不能修改', 1),
(3419, 3, '410102', '话术标题内容不能为空', '話術標題內容不能為空', 1),
(3420, 3, '410103', '已拥有此分组', '已擁有此分組', 1),
(3421, 3, '410104', '缺少标签id', '缺少標籤id', 1),
(3422, 3, '410105', '请填汉字字母或者数字', '請填漢字字母或者數字', 1),
(3423, 3, '410106', '标题长度不能超过50个字', '標題長度不能超過50個字', 1),
(3424, 3, '410107', '请选择分类', '請選擇分類', 1),
(3425, 3, '410108', '分类必须为数字', '分類必須為數字', 1),
(3426, 3, '410109', '请填写话术内容', '請填寫話術內容', 1),
(3427, 3, '410110', '话术长度不能超过500个字', '話術長度不能超過500個字', 1),
(3428, 3, '410111', '排序必须为数字', '排序必須為數字', 1),
(3429, 3, '410112', '微信最低提现金额不能小于1元', '微信最低提現金額不能小於1元', 1),
(3430, 3, '410113', '用户不存在', '用戶不存在', 1),
(3431, 3, '410114', '提现方式不存在', '提現方式不存在', 1),
(3432, 3, '410115', '提现金额输入有误', '提現金額輸入有誤', 1),
(3433, 3, '410116', '银行卡号输入有误', '銀行卡號輸入有誤', 1),
(3434, 3, '410117', '请输入支付宝账号', '請輸入支付寶賬號', 1),
(3435, 3, '410118', '请输入银行卡账号', '請輸入銀行卡賬號', 1),
(3436, 3, '410119', '请输入开户行信息', '請輸入開戶行信息', 1),
(3437, 3, '410120', '申请提现成功', '申請提現成功', 1),
(3438, 3, '410121', '申请提现失败', '申請提現失敗', 1),
(3439, 3, '410122', '充值金额不能为0元', '充值金額不能為0元', 1),
(3440, 3, '410123', '充值方式不支持', '充值方式不支持', 1),
(3441, 3, '410124', '充值金额不能低于{:money}', '充值金額不能低於{:money}', 1),
(3442, 3, '410125', '充值成功', '充值成功', 1),
(3443, 3, '410126', '充值失败', '充值失敗', 1),
(3444, 3, '410127', '签到获得{:integral}积分', '簽到獲得{:integral}積分', 1),
(3445, 3, '410128', '签到失败', '簽到失敗', 1),
(3446, 3, '410129', '收藏成功', '收藏成功', 1),
(3447, 3, '410130', '收藏失败', '收藏失敗', 1),
(3448, 3, '410131', '授权失败', '授權失敗', 1),
(3449, 3, '410132', 'unionid不存在', 'unionid不存在', 1),
(3450, 3, '410133', '获取用户UID失败', '獲取用戶UID失敗', 1),
(3451, 3, '410134', '请输入昵称或者选择头像', '請輸入暱稱或者選擇頭像', 1),
(3452, 3, '410135', '注销成功', '註銷成功', 1),
(3453, 3, '410136', '暂无客服人员在线，请稍后联系', '暫無客服人員在線，請稍後聯繫', 1),
(3454, 3, '410137', '不能和自己聊天', '不能和自己聊天', 1),
(3455, 3, '410138', '您不是客服无法登录', '您不是客服無法登錄', 1),
(3456, 3, '410139', '自己不能转接给自己', '自己不能轉接給自己', 1),
(3457, 3, '410140', '转接客服失败', '轉接客服失敗', 1),
(3458, 3, '410141', '没有此用户', '沒有此用戶', 1),
(3459, 3, '410142', '客服不存在', '客服不存在', 1),
(3460, 3, '410143', '商品未查到', '商品未查到', 1),
(3461, 3, '410144', '请填写开票手机号', '請填寫開票手機號', 1),
(3462, 3, '410145', '请填写发票抬头（开具发票企业名称）', '請填寫發票抬頭（開具發票企業名稱）', 1),
(3463, 3, '410146', '请填写正确的发票抬头（开具发票企业名称）', '請填寫正確的發票抬頭（開具發票企業名稱）', 1),
(3464, 3, '410147', '请填写发票税号', '請填寫發票稅號', 1),
(3465, 3, '410148', '请填写正确的发票税号', '請填寫正確的發票稅號', 1),
(3466, 3, '410149', '请填写正确的银行卡号', '請填寫正確的銀行卡號', 1),
(3467, 3, '410150', '地址不存在', '地址不存在', 1),
(3468, 3, '410151', '收货地址格式错误', '收貨地址格式錯誤', 1),
(3469, 3, '410152', '收货地址格式错误或系统未完善当前地址', '收貨地址格式錯誤或系統未完善當前地址', 1),
(3470, 3, '410153', '收货地址格式错误，请重新选择', '收貨地址格式錯誤，請重新選擇', 1),
(3471, 3, '410154', '请填写详细地址', '請填寫詳細地址', 1),
(3472, 3, '410155', '名称必须填写', '名稱必須填寫', 1),
(3473, 3, '410156', '名称最多不能超过25个字符', '名稱最多不能超過25個字符', 1),
(3474, 3, '410157', '手机号必须填写', '手機號必須填寫', 1),
(3475, 3, '410158', '手机号格式错误', '手機號格式錯誤', 1),
(3476, 3, '410159', '省必须填写', '省必須填寫', 1),
(3477, 3, '410160', '市必须填写', '市必須填寫', 1),
(3478, 3, '410161', '区/县必须填写', '區/縣必須填寫', 1),
(3479, 3, '410162', '详细地址必须填写', '詳細地址必須填寫', 1),
(3480, 3, '410163', '请填写反馈内容', '請填寫反饋內容', 1),
(3481, 3, '410164', '比例不能大于您的比例', '比例不能大於您的比例', 1),
(3482, 3, '410165', '激活成功', '激活成功', 1),
(3483, 3, '410166', '暂无海报', '暫無海報', 1),
(3484, 3, '410167', '二维码生成失败', '二維碼生成失敗', 1),
(3485, 3, '410168', '缺少字体文件Bold', '缺少字體文件Bold', 1),
(3486, 3, '410169', '缺少字体文件Normal', '缺少字體文件Normal', 1),
(3487, 3, '410170', '生成图片失败', '生成圖片失敗', 1),
(3488, 3, '410171', '生成图片时，系统错误', '生成圖片時，系統錯誤', 1),
(3489, 3, '410172', '生成海报失败', '生成海報失敗', 1),
(3490, 3, '410173', '订单不存在', '訂單不存在', 1),
(3491, 3, '410174', '订单已支付', '訂單已支付', 1),
(3492, 3, '410175', '请填写实际支付金额', '請填寫實際支付金額', 1),
(3493, 3, '410176', '实际支付金额不能小于0元', '實際支付金額不能小於0元', 1),
(3494, 3, '410177', '请填写备注内容', '請填寫備註內容', 1),
(3495, 3, '410178', '请先处理售后申请', '請先處理售後申請', 1),
(3496, 3, '410179', '用户已取消申请', '用戶已取消申請', 1),
(3497, 3, '410180', '售后订单状态不支持该操作', '售後訂單狀態不支持該操作', 1),
(3498, 3, '410181', '退款修改状态错误', '退款修改狀態錯誤', 1),
(3499, 3, '410182', '修改退款状态成功', '修改退款狀態成功', 1),
(3500, 3, '410183', '已退完支付金额，不能再退款了', '已退完支付金額，不能再退款了', 1),
(3501, 3, '410184', '请输入退款金额', '請輸入退款金額', 1),
(3502, 3, '410185', '退款金额大于支付金额，请修改退款金额', '退款金額大於支付金額，請修改退款金額', 1),
(3503, 3, '410186', '退款成功', '退款成功', 1),
(3504, 3, '410187', '退款失败', '退款失敗', 1),
(3505, 3, '410188', '请输入核销码或者扫描核销二维码', '請輸入核銷碼或者掃描核銷二維碼', 1),
(3506, 3, '410189', '核销成功', '核銷成功', 1),
(3507, 3, '410190', '请输入付款金额', '請輸入付款金額', 1),
(3508, 3, '410191', '支付金额不能为0元', '支付金額不能為0元', 1),
(3509, 3, '410192', '付费会员功能暂未开启', '付費會員功能暫未開啟', 1),
(3510, 3, '410193', '支付数据生成失败', '支付數據生成失敗', 1),
(3511, 3, '410194', '支付订单不存在', '支付訂單不存在', 1),
(3512, 3, '410195', '微信支付成功', '微信支付成功', 1),
(3513, 3, '410196', '前往支付', '前往支付', 1),
(3514, 3, '410197', '余额支付成功', '餘額支付成功', 1),
(3515, 3, '410198', '请传入支付宝支付回调URL', '請傳入支付寶支付回調URL', 1),
(3516, 3, '410199', '支付宝支付成功', '支付寶支付成功', 1),
(3517, 3, '410200', '订单生成失败', '訂單生成失敗', 1),
(3518, 3, '410201', '请提交购买的商品', '請提交購買的商品', 1),
(3519, 3, '410202', '商品不存在，请重新选择商品下单', '商品不存在，請重新選擇商品下單', 1),
(3520, 3, '410203', '订单创建成功', '訂單創建成功', 1),
(3521, 3, '410204', '收货成功', '收貨成功', 1),
(3522, 3, '410205', '收货失败', '收貨失敗', 1),
(3523, 3, '410206', '快递单号不存在', '快遞單號不存在', 1),
(3524, 3, '410207', '默认运费模板未配置，无法下单', '默認運費模板未配置，無法下單', 1),
(3525, 3, '410208', '订单已过期,请刷新当前页面', '訂單已過期,請刷新當前頁面', 1),
(3526, 3, '410209', '订单已创建，请点击查看完成支付', '訂單已創建，請點擊查看完成支付', 1),
(3527, 3, '410210', '订单生成失败，你已经在该团内不能再参加了', '訂單生成失敗，你已經在該團內不能再參加了', 1),
(3528, 3, '410211', '订单生成失败，你已经参加该团了，请先支付订单', '訂單生成失敗，你已經參加該團了，請先支付訂單', 1),
(3529, 3, '410212', '该团人员已满', '該團人員已滿', 1),
(3530, 3, '410213', '暂不支持该支付方式，请刷新页面或者联系管理员', '暫不支持該支付方式，請刷新頁面或者聯繫管理員', 1),
(3531, 3, '410214', '您购买的商品库存已不足{:cart_num}{:unit_name}', '您購買的商品庫存已不足{:cart_num}{:unit_name}', 1),
(3532, 3, '410215', '该订单已失效', '該訂單已失效', 1),
(3533, 3, '410216', '支付失败', '支付失敗', 1),
(3534, 3, '410217', '支付成功', '支付成功', 1),
(3535, 3, '410218', '支付方式错误', '支付方式錯誤', 1),
(3536, 3, '410219', '订单商品已评价', '訂單商品已評價', 1),
(3537, 3, '410220', '请为商品评分', '請為商品評分', 1),
(3538, 3, '410221', '请为商家服务评分', '請為商家服務評分', 1),
(3539, 3, '410222', '评价失败', '評價失敗', 1),
(3540, 3, '410223', '请重新选择退款商品或件数', '請重新選擇退款商品或件數', 1),
(3541, 3, '410224', '当前状态不能取消申请', '當前狀態不能取消申請', 1),
(3542, 3, '410225', '重选成功', '重選成功', 1),
(3543, 3, '410226', '订单已退款', '訂單已退款', 1),
(3544, 3, '410227', '使用积分抵扣失败', '使用積分抵扣失敗', 1),
(3545, 3, '410228', '会员类型不存在', '會員類型不存在', 1),
(3546, 3, '410229', '您已是永久会员无需再购买', '您已是永久會員無需再購買', 1),
(3547, 3, '410230', '该会员卡暂时无法购买', '該會員卡暫時無法購買', 1),
(3548, 3, '410231', '您已经领取过免费会员', '您已經領取過免費會員', 1),
(3549, 3, '410232', '此类型会员卡暂未开售', '此類型會員卡暫未開售', 1),
(3550, 3, '410233', '获取购物车信息失败', '獲取購物車信息失敗', 1),
(3551, 3, '410234', '您要购买的优惠券已失效，无法购买', '您要購買的優惠券已失效，無法購買', 1),
(3552, 3, '410235', '您已获取过该优惠券，无法再次购买', '您已獲取過該優惠券，無法再次購買', 1),
(3553, 3, '410236', '请刷新后重试', '請刷新後重試', 1),
(3554, 3, '410237', '暂无库存', '暫無庫存', 1),
(3555, 3, '410238', '选择的规格库存不足', '選擇的規格庫存不足', 1),
(3556, 3, '410239', '单次购买数量不能大于 {:limit} 件', '單次購買數量不能大於 {:limit} 件', 1),
(3557, 3, '410240', '该商品限购 {:limit} 件，您已经购买 {:pay_num} 件', '該商品限購 {:limit} 件，您已經購買 {:pay_num} 件', 1),
(3558, 3, '410241', '选择支付方式有误', '選擇支付方式有誤', 1),
(3559, 3, '410242', '选择的优惠劵无效', '選擇的優惠劵無效', 1),
(3560, 3, '410243', '不满足优惠劵的使用条件', '不滿足優惠劵的使用條件', 1),
(3561, 3, '410244', '使用优惠劵失败', '使用優惠劵失敗', 1),
(3562, 3, '410245', '请填写姓名和电话', '請填寫姓名和電話', 1),
(3563, 3, '410246', '营销商品不能使用线下支付', '營銷商品不能使用線下支付', 1),
(3564, 3, '410247', '暂无门店无法选择门店自提', '暫無門店無法選擇門店自提', 1),
(3565, 3, '410248', '订单商品结算失败', '訂單商品結算失敗', 1),
(3566, 3, '410249', '发票已申请', '發票已申請', 1),
(3567, 3, '410250', '正在申请退款中', '正在申請退款中', 1),
(3568, 3, '410251', '申请失败', '申請失敗', 1),
(3569, 3, '410252', '退款件数大于订单件数', '退款件數大於訂單件數', 1),
(3570, 3, '410253', '该订单已全部拆分', '該訂單已全部拆分', 1),
(3571, 3, '410254', '申请退款失败', '申請退款失敗', 1),
(3572, 3, '410255', '存在待处理退款单', '存在待處理退款單', 1),
(3573, 3, '410256', '该订单无法删除', '該訂單無法刪除', 1),
(3574, 3, '410257', '订单已经支付无法取消', '訂單已經支付無法取消', 1),
(3575, 3, '410258', '拼团商品不能再来一单，请在拼团商品内自行下单', '拼團商品不能再來一單，請在拼團商品內自行下單', 1),
(3576, 3, '410259', '砍价商品不能再来一单，请在砍价商品内自行下单', '砍價商品不能再來一單，請在砍價商品內自行下單', 1),
(3577, 3, '410260', '秒杀商品不能再来一单，请在秒杀商品内自行下单', '秒殺商品不能再來一單，請在秒殺商品內自行下單', 1),
(3578, 3, '410261', '预售商品不能再来一单，请在预售商品内自行下单', '預售商品不能再來一單，請在預售商品內自行下單', 1),
(3579, 3, '410262', '再来一单失败，请重新下单', '再來一單失敗，請重新下單', 1),
(3580, 3, '410263', '该订单无法支付', '該訂單無法支付', 1),
(3581, 3, '410264', '订单支付状态有误，无法进行支付', '訂單支付狀態有誤，無法進行支付', 1),
(3582, 3, '410265', '该订单已支付', '該訂單已支付', 1),
(3583, 3, '410266', '订单状态错误', '訂單狀態錯誤', 1),
(3584, 3, '410267', '此订单不能被核销', '此訂單不能被核銷', 1),
(3585, 3, '410268', '订单有售后申请请先处理', '訂單有售後申請請先處理', 1),
(3586, 3, '410269', '您无权限核销此订单，请联系管理员', '您無權限核銷此訂單，請聯繫管理員', 1),
(3587, 3, '410270', '订单已核销', '訂單已核銷', 1),
(3588, 3, '410271', '拼团订单暂未成功无法核销', '拼團訂單暫未成功無法核銷', 1),
(3589, 3, '410272', '核销失败', '核銷失敗', 1),
(3590, 3, '410273', '发货成功', '發貨成功', 1),
(3591, 3, '410274', '无需支付', '無需支付', 1),
(3592, 3, '410275', '获取用户openid失败,无法支付', '獲取用戶openid失敗,無法支付', 1),
(3593, 3, '410276', '网站名称配置未填写,无法支付', '網站名稱配置未填寫,無法支付', 1),
(3594, 3, '410277', '支付方式不存在', '支付方式不存在', 1),
(3595, 3, '410278', '不支持该类型方式', '不支持該類型方式', 1),
(3596, 3, '410279', '余额支付失败', '餘額支付失敗', 1),
(3597, 3, '410280', '暂未开启发票', '暫未開啟發票', 1),
(3598, 3, '410281', '暂未开启专用发票', '暫未開啟專用發票', 1),
(3599, 3, '410282', '该发票已经存在', '該發票已經存在', 1),
(3600, 3, '410283', '设置默认发票失败', '設置默認發票失敗', 1),
(3601, 3, '410284', '没有此用户，无法检测升级用户等级', '沒有此用戶，無法檢測升級用戶等級', 1),
(3602, 3, '410285', '检测升级失败', '檢測升級失敗', 1),
(3603, 3, '410286', '修改订单失败', '修改訂單失敗', 1),
(3604, 3, '410287', '修改用户信息失败', '修改用戶信息失敗', 1),
(3605, 3, '410288', '绑定推广关系失败', '綁定推廣關係失敗', 1),
(3606, 3, '410289', '天数不能为0', '天數不能為0', 1),
(3607, 3, '410290', '添加签到数据失败', '添加簽到數據失敗', 1),
(3608, 3, '410291', '赠送经验失败', '贈送經驗失敗', 1),
(3609, 3, '410292', '请先配置签到天数', '請先配置簽到天數', 1),
(3610, 3, '410293', '已经签到', '已經簽到', 1),
(3611, 3, '410294', '商品不存在', '商品不存在', 1),
(3612, 3, '410295', '该商品已下架或删除', '該商品已下架或刪除', 1),
(3613, 3, '410296', '该商品库存不足', '該商品庫存不足', 1),
(3614, 3, '410297', '该商品库存不足{:num}', '該商品庫存不足{:num}', 1),
(3615, 3, '410298', '每人总共限购{:num}件', '每人總共限購{:num}件', 1),
(3616, 3, '410299', '砍价已结束', '砍價已結束', 1),
(3617, 3, '410300', '您不能再发起此件商品砍价', '您不能再發起此件商品砍價', 1),
(3618, 3, '410301', '该分享未开启砍价', '該分享未開啟砍價', 1),
(3619, 3, '410302', '您已经帮砍过此砍价', '您已經幫砍過此砍價', 1),
(3620, 3, '410303', '砍价信息没有查到', '砍價信息沒有查到', 1),
(3621, 3, '410304', '用户砍价信息未查到', '用戶砍價信息未查到', 1),
(3622, 3, '410305', '请选择有效的商品属性', '請選擇有效的商品屬性', 1),
(3623, 3, '410306', '砍价商品不存在', '砍價商品不存在', 1),
(3624, 3, '410307', '砍价失败', '砍價失敗', 1),
(3625, 3, '410308', '砍价未成功', '砍價未成功', 1),
(3626, 3, '410309', '砍价已支付', '砍價已支付', 1),
(3627, 3, '410310', '您不能再帮砍此件商品', '您不能再幫砍此件商品', 1),
(3628, 3, '410311', '商品已被删除', '商品已被刪除', 1),
(3629, 3, '410312', '拼团不存在或已下架,请手动申请退款', '拼團不存在或已下架,請手動申請退款', 1),
(3630, 3, '410313', '每个订单限购{:num}件', '每個訂單限購{:num}件', 1),
(3631, 3, '410314', '未查到拼团信息，无法取消', '未查到拼團信息，無法取消', 1),
(3632, 3, '410315', '拼团已到期', '拼團已到期', 1),
(3633, 3, '410316', '拼团已完成，无法取消', '拼團已完成，無法取消', 1),
(3634, 3, '410317', '每人限购{:num}件', '每人限購{:num}件', 1),
(3635, 3, '410318', '抽奖不存在', '抽獎不存在', 1),
(3636, 3, '410319', '领取成功', '領取成功', 1),
(3637, 3, '410320', '领取失败', '領取失敗', 1),
(3638, 3, '410321', '活动未开始', '活動未開始', 1),
(3639, 3, '410322', '活动已结束', '活動已結束', 1),
(3640, 3, '410323', '您已有这张优惠券，请勿重复购买', '您已有這張優惠券，請勿重複購買', 1),
(3641, 3, '410324', '请核对快递公司编码', '請核對快遞公司編碼', 1),
(3642, 3, '410325', '请选择发票', '請選擇發票', 1),
(3643, 3, '-1', '系统繁忙，请稍候再试', '系統繁忙，請稍候再試', 1),
(3644, 3, '43104', 'appid与openid不匹配', 'appid與openid不匹配', 1),
(3645, 3, '45009', '达到微信api每日限额上限', '達到微信api每日限額上限', 1),
(3646, 3, '45008', '图文消息超过限制', '圖文消息超過限制', 1),
(3647, 3, '45007', '语音播放时间超过限制', '語音播放時間超過限制', 1),
(3648, 3, '45006', '图片链接字段超过限制', '圖片鏈接字段超過限制', 1),
(3649, 3, '45005', '链接字段超过限制', '鏈接字段超過限制', 1),
(3650, 3, '45004', '描述字段超过限制', '描述字段超過限制', 1),
(3651, 3, '45003', '标题字段超过限制', '標題字段超過限制', 1),
(3652, 3, '45002', '消息内容超过限制', '消息內容超過限制', 1),
(3653, 3, '45001', '多媒体文件大小超过限制', '多媒體文件大小超過限制', 1),
(3654, 3, '44004', '文本消息内容为空', '文本消息內容為空', 1),
(3655, 3, '44003', '图文消息内容为空', '圖文消息內容為空', 1),
(3656, 3, '44002', 'POST 的数据包为空', 'POST 的數據包為空', 1),
(3657, 3, '44001', '多媒体文件为空', '多媒體文件為空', 1),
(3658, 3, '43019', '需要将接收者从黑名单中移除', '需要將接收者從黑名單中移除', 1),
(3659, 3, '43005', '需要好友关系', '需要好友關係', 1),
(3660, 3, '43004', '需要接收者关注', '需要接收者關注', 1),
(3661, 3, '43003', '需要 HTTPS 请求', '需要 HTTPS 請求', 1),
(3662, 3, '43002', '需要 POST 请求', '需要 POST 請求', 1),
(3663, 3, '43001', '需要 GET 请求', '需要 GET 請求', 1),
(3664, 3, '42007', '用户修改微信密码， accesstoken 和 refreshtoken 失效，需要重新授权', '用戶修改微信密碼， accesstoken 和 refreshtoken 失效，需要重新授權', 1),
(3665, 3, '42003', 'oauth_code 超时', 'oauth_code 超時', 1),
(3666, 3, '42002', 'refresh_token 超时', 'refresh_token 超時', 1),
(3667, 3, '42001', 'access_token 超时，请检查 access_token 的有效期，请参考基础支持 - 获取 access_token 中，对 access_token 的详细机制说明', 'access_token 超時，請檢查 access_token 的有效期，請參考基礎支持 - 獲取 access_token 中，對 access_token 的詳細機制說明', 1),
(3668, 3, '41009', '缺少 openid', '缺少 openid', 1),
(3669, 3, '41008', '缺少 oauth code', '缺少 oauth code', 1),
(3670, 3, '41007', '缺少子菜单数据', '缺少子菜單數據', 1),
(3671, 3, '41006', '缺少 media_id 参数', '缺少 media_id 參數', 1),
(3672, 3, '41005', '缺少多媒体文件数据', '缺少多媒體文件數據', 1),
(3673, 3, '41004', '缺少 secret 参数', '缺少 secret 參數', 1),
(3674, 3, '41003', '缺少 refresh_token 参数', '缺少 refresh_token 參數', 1),
(3675, 3, '41002', '缺少 appid 参数', '缺少 appid 參數', 1),
(3676, 3, '41001', '缺少 access_token 参数', '缺少 access_token 參數', 1),
(3677, 3, '40163', 'oauth_code已使用', 'oauth_code已使用', 1),
(3678, 3, '40155', '请勿添加其他公众号的主页链接', '請勿添加其他公眾號的主頁鏈接', 1),
(3679, 3, '40137', '不支持的图片格式', '不支持的圖片格式', 1),
(3680, 3, '40132', '微信号不合法', '微信號不合法', 1),
(3681, 3, '40125', '无效的appsecret', '無效的appsecret', 1),
(3682, 3, '40121', '不合法的 media_id 类型', '不合法的 media_id 類型', 1),
(3683, 3, '40120', '子 button 类型错误', '子 button 類型錯誤', 1),
(3684, 3, '40119', 'button 类型错误', 'button 類型錯誤', 1),
(3685, 3, '40118', 'media_id 大小不合法', 'media_id 大小不合法', 1),
(3686, 3, '40117', '分组名字不合法', '分組名字不合法', 1),
(3687, 3, '40060', '删除单篇图文时，指定的 article_idx 不合法', '刪除單篇圖文時，指定的 article_idx 不合法', 1),
(3688, 3, '40051', '分组名字不合法', '分組名字不合法', 1),
(3689, 3, '40050', '不合法的分组 id', '不合法的分組 id', 1),
(3690, 3, '40048', '无效的url', '無效的url', 1),
(3691, 3, '40039', '不合法的 URL 长度', '不合法的 URL 長度', 1),
(3692, 3, '40035', '不合法的参数', '不合法的參數', 1),
(3693, 3, '40038', '不合法的请求格式', '不合法的請求格式', 1),
(3694, 3, '40033', '不合法的请求字符，不能包含 \\uxxxx 格式的字符', '不合法的請求字符，不能包含 \\uxxxx 格式的字符', 1),
(3695, 3, '40032', '不合法的 openid 列表长度', '不合法的 openid 列表長度', 1),
(3696, 3, '40031', '不合法的 openid 列表', '不合法的 openid 列表', 1),
(3697, 3, '40030', '不合法的 refresh_token', '不合法的 refresh_token', 1),
(3698, 3, '40029', '无效的 oauth_code', '無效的 oauth_code', 1),
(3699, 3, '40028', '不合法的自定义菜单使用用户', '不合法的自定義菜單使用用戶', 1),
(3700, 3, '40027', '不合法的子菜单按钮 URL 长度', '不合法的子菜單按鈕 URL 長度', 1),
(3701, 3, '40026', '不合法的子菜单按钮 KEY 长度', '不合法的子菜單按鈕 KEY 長度', 1),
(3702, 3, '40025', '不合法的子菜单按钮名字长度', '不合法的子菜單按鈕名字長度', 1),
(3703, 3, '40024', '不合法的子菜单按钮类型', '不合法的子菜單按鈕類型', 1),
(3704, 3, '40023', '不合法的子菜单按钮个数', '不合法的子菜單按鈕個數', 1),
(3705, 3, '40022', '不合法的子菜单级数', '不合法的子菜單級數', 1),
(3706, 3, '40021', '不合法的菜单版本号', '不合法的菜單版本號', 1),
(3707, 3, '40020', '不合法的按钮 URL 长度', '不合法的按鈕 URL 長度', 1),
(3708, 3, '40019', '不合法的按钮 KEY 长度', '不合法的按鈕 KEY 長度', 1),
(3709, 3, '40018', '不合法的按钮名字长度', '不合法的按鈕名字長度', 1),
(3710, 3, '40017', '不合法的按钮类型', '不合法的按鈕類型', 1),
(3711, 3, '40016', '不合法的按钮个数', '不合法的按鈕個數', 1),
(3712, 3, '40015', '不合法的菜单类型', '不合法的菜單類型', 1),
(3713, 3, '40014', '不合法的 access_token ，请开发者认真比对 access_token 的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口', '不合法的 access_token ，請開發者認真比對 access_token 的有效性（如是否過期），或查看是否正在為恰當的公眾號調用接口', 1),
(3714, 3, '40013', '不合法的 AppID ，请开发者检查 AppID 的正确性，避免异常字符，注意大小写', '不合法的 AppID ，請開發者檢查 AppID 的正確性，避免異常字符，注意大小寫', 1),
(3715, 3, '40012', '不合法的缩略图文件大小', '不合法的縮略圖文件大小', 1),
(3716, 3, '40011', '不合法的视频文件大小', '不合法的視頻文件大小', 1),
(3717, 3, '40010', '不合法的语音文件大小', '不合法的語音文件大小', 1),
(3718, 3, '40009', '不合法的图片文件大小', '不合法的圖片文件大小', 1),
(3719, 3, '40008', '不合法的消息类型', '不合法的消息類型', 1),
(3720, 3, '40007', '不合法的媒体文件 id', '不合法的媒體文件 id', 1),
(3721, 3, '40006', '不合法的文件大小', '不合法的文件大小', 1),
(3722, 3, '40005', '不合法的文件类型', '不合法的文件類型', 1),
(3723, 3, '40004', '不合法的媒体文件类型', '不合法的媒體文件類型', 1),
(3724, 3, '40003', '不合法的 OpenID ，请开发者确认 OpenID （该用户）是否已关注公众号，或是否是其他公众号的 OpenID', '不合法的 OpenID ，請開發者確認 OpenID （該用戶）是否已關注公眾號，或是否是其他公眾號的 OpenID', 1),
(3725, 3, '40002', '不合法的凭证类型', '不合法的憑證類型', 1),
(3726, 3, '40001', '获取 access_token 时 AppSecret 错误，或者 access_token 无效。请开发者认真比对 AppSecret 的正确性，或查看是否正在为恰当的公众号调用接口', '獲取 access_token 時 AppSecret 錯誤，或者 access_token 無效。請開發者認真比對 AppSecret 的正確性，或查看是否正在為恰當的公眾號調用接口', 1),
(3727, 3, '200011', '此账号已被封禁，无法操作', '此賬號已被封禁，無法操作', 1),
(3728, 3, '200012', '个人模版数已达上限，上限25个', '個人模版數已達上限，上限25個', 1),
(3729, 3, '200014', '请检查小程序所属类目', '請檢查小程序所屬類目', 1),
(3730, 4, '100000', '保存成功', 'Enregistrer avec succès', 1),
(3731, 4, '100001', '修改成功', 'Modifié avec succès', 1),
(3732, 4, '100002', '删除成功', 'Suppression réussie', 1),
(3733, 4, '100003', '显示成功', 'Afficher le succès', 1),
(3734, 4, '100004', '隐藏成功', 'Masquer avec succès', 1),
(3735, 4, '100005', '操作失败', 'L`opération a échoué', 1),
(3736, 4, '100006', '保存失败', 'Échec de la sauvegarde', 1),
(3737, 4, '100007', '修改失败', 'Modification échouée', 1),
(3738, 4, '100008', '删除失败', 'La suppression a échoué', 1),
(3739, 4, '100009', '图片上传成功', 'Téléchargement de l`image réussi', 1),
(3740, 4, '100010', '操作成功', 'Opération réussie', 1),
(3741, 4, '100011', '暂无数据', 'Pas encore de données', 1),
(3742, 4, '100012', '更新成功', 'Mise à jour réussie', 1),
(3743, 4, '100013', '更新失败', 'Échec de la mise à jour', 1),
(3744, 4, '100014', '设置成功', 'Réglé avec succès', 1),
(3745, 4, '100015', '设置失败', 'Échec de l`installation', 1),
(3746, 4, '100016', '获取失败', 'Impossible d`obtenir', 1),
(3747, 4, '100017', '提交成功', 'Soumettre avec succès', 1),
(3748, 4, '100018', '提交失败', 'La soumission a échoué', 1),
(3749, 4, '100019', '取消成功', 'Annulation réussie', 1),
(3750, 4, '100020', '取消失败', 'Échec de l`annulation', 1),
(3751, 4, '100021', '添加成功', 'Ajouté avec succès', 1),
(3752, 4, '100022', '添加失败', 'Échec de l`ajout', 1),
(3753, 4, '100023', '保存token失败', 'Échec de la sauvegarde du jeton', 1),
(3754, 4, '100024', '备注成功', 'Remarque réussie', 1),
(3755, 4, '100025', '备注失败', 'La remarque a échoué', 1),
(3756, 4, '100026', '数据不存在', 'La donnée n`existe pas', 1),
(3757, 4, '100027', '申请成功', 'Candidature réussie', 1),
(3758, 4, '100028', '申请失败', 'L`application a échoué', 1),
(3759, 4, '100029', '暂无此方法', 'Une telle méthode n`existe pas', 1),
(3760, 4, '100030', '发送成功', 'Envoyer avec succès', 1),
(3761, 4, '100031', '发送失败', 'Echec de l`envoi', 1),
(3762, 4, '100032', '上传成功', 'Téléchargement réussi', 1),
(3763, 4, '100033', '上传失败', 'Le téléchargement a échoué', 1),
(3764, 4, '100034', '移动成功', 'Déplacement réussi', 1),
(3765, 4, '100035', '移动失败', 'Le déplacement a échoué', 1),
(3766, 4, '100036', '退款成功', 'Remboursement réussi', 1),
(3767, 4, '100037', '退款失败', 'Remboursement échoué', 1),
(3768, 4, '100038', '同步成功', 'Synchronisation réussie', 1),
(3769, 4, '100039', '同步失败', 'La synchronisation a échoué', 1),
(3770, 4, '100040', '恢复成功', 'Récupération réussie', 1),
(3771, 4, '100041', '恢复失败', 'La récupération a échoué', 1),
(3772, 4, '100042', '退出成功', 'Quitter avec succès', 1),
(3773, 4, '100043', '退出失败', 'Échec de la sortie', 1),
(3774, 4, '100044', '开通成功', 'Ouvrir avec succès', 1),
(3775, 4, '100045', '开通失败', 'Échec de l`activation', 1),
(3776, 4, '100046', '清除数据成功', 'Effacer les données avec succès', 1),
(3777, 4, '100047', '优化成功', 'Optimisation réussie', 1),
(3778, 4, '100048', '优化失败', 'L`optimisation a échoué', 1),
(3779, 4, '100049', '修复成功', 'Réparation réussie', 1),
(3780, 4, '100050', '修复失败', 'La réparation a échoué', 1),
(3781, 4, '100051', '备份成功', 'Sauvegarde réussie', 1),
(3782, 4, '100052', '备份失败', 'La sauvegarde a échoué', 1),
(3783, 4, '100100', '参数错误', 'Erreur de paramètre', 1),
(3784, 4, '100101', '非法操作', 'Opération illégale', 1),
(3785, 4, '100102', '数据获取失败', 'L`acquisition des données a échoué', 1),
(3786, 4, '100103', '站点升级中，请稍候访问', 'Le site est en cours de mise à jour, veuillez revenir plus tard', 1),
(3787, 4, '100104', '缺少code', 'Code manquant', 1),
(3788, 4, '110000', '您暂时没有访问权限', 'Vous n`avez pas accès pour le moment', 1),
(3789, 4, '110001', '接口未授权，您无法访问', 'L`interface n`est pas autorisée et vous ne pouvez pas y accéder', 1),
(3790, 4, '110002', '请登录', 'Veuillez vous connecter', 1),
(3791, 4, '110003', '登录已过期,请重新登录', 'La connexion a expiré, veuillez vous reconnecter', 1),
(3792, 4, '110004', '登录状态有误,请重新登录', 'Le statut de connexion est incorrect, veuillez vous reconnecter', 1),
(3793, 4, '110005', '请登录', 'Veuillez vous connecter', 1),
(3794, 4, '110006', '登录已过期,请重新登录', 'La connexion a expiré, veuillez vous reconnecter', 1),
(3795, 4, '110007', '登录状态有误,请重新登录', 'Le statut de connexion est incorrect, veuillez vous reconnecter', 1),
(3796, 4, '400000', '请选择用户头像', 'Veuillez sélectionner l`avatar de l`utilisateur', 1),
(3797, 4, '400001', '请填写用户昵称', 'Veuillez renseigner le pseudo de l`utilisateur', 1),
(3798, 4, '400002', '请填写评论内容', 'Veuillez remplir le contenu du commentaire', 1),
(3799, 4, '400003', '请选择商品分数', 'Veuillez sélectionner le score de l`élément', 1),
(3800, 4, '400004', '请选择服务分数', 'Veuillez sélectionner un score de service', 1),
(3801, 4, '400005', '商品分数必须是1-5之间的整数', 'Le score du produit doit être un entier compris entre 1 et 5', 1),
(3802, 4, '400006', '服务分数必须是1-5之间的整数', 'Le score de service doit être un entier compris entre 1 et 5', 1),
(3803, 4, '400007', '请选择快递公司', 'Veuillez sélectionner une entreprise de messagerie', 1),
(3804, 4, '400008', '请填写寄件人姓名', 'Veuillez renseigner le nom de l`expéditeur', 1),
(3805, 4, '400009', '请输入寄件人手机号码', 'Veuillez entrer le numéro de téléphone portable de l`expéditeur', 1),
(3806, 4, '400010', '寄件人手机号码不正确', 'Le numéro de téléphone portable de l`expéditeur est incorrect', 1),
(3807, 4, '400011', '请填写寄件人详细地址', 'Veuillez renseigner l`adresse détaillée de l`expéditeur', 1),
(3808, 4, '400012', '请填写云打印机编号', 'Veuillez renseigner le numéro d`imprimante cloud', 1),
(3809, 4, '400013', '请传入套餐id', 'Veuillez transmettre l`identifiant du package', 1),
(3810, 4, '400014', '套餐id必须为数字', 'L`identifiant du paquet doit être un nombre', 1),
(3811, 4, '400015', '请填写套餐金额', 'Veuillez renseigner le montant du forfait', 1),
(3812, 4, '400016', '请填写购买数量', 'Veuillez renseigner la quantité d`achat', 1),
(3813, 4, '400017', '购买数量必须为数字', 'La quantité d`achat doit être un nombre', 1),
(3814, 4, '400018', '请填写购买套餐类型', 'Veuillez renseigner le type de package d`achat', 1),
(3815, 4, '400019', '您输入的手机号码必须为数字', 'Le numéro de mobile que vous entrez doit être un numéro', 1),
(3816, 4, '400020', '密码必须填写', 'Le mot de passe doit être renseigné', 1),
(3817, 4, '400021', '短信验证码必须为数字', 'Le code de vérification SMS doit être un nombre', 1),
(3818, 4, '400022', '请填写话术内容', 'Veuillez renseigner le contenu des mots', 1),
(3819, 4, '400023', '请填写排序数字', 'Veuillez renseigner les numéros de tri', 1),
(3820, 4, '400024', '请填写排序数字', 'Veuillez renseigner les numéros de tri', 1),
(3821, 4, '400025', '请填写运费模板名称', 'Veuillez renseigner le nom du modèle d`expédition', 1),
(3822, 4, '400026', '运费信息必须为数组', 'Les informations de livraison doivent être un tableau', 1),
(3823, 4, '400027', '包邮信息必须为数组', 'Les informations sur le paquet doivent être un tableau', 1),
(3824, 4, '400028', '不送达信息必须为数组', 'Le message non délivré doit être un tableau', 1),
(3825, 4, '400029', 'type数据格式错误，应为1或2或3', 'erreur de format de données de type, doit être 1 ou 2 ou 3', 1),
(3826, 4, '400030', 'appoint数据格式错误，应为0或1', 'Le format des données de rendez-vous est incorrect, il doit être 0 ou 1', 1),
(3827, 4, '400031', 'no_delivery数据格式错误，应为0或1', 'Erreur de format de données no_delivery, doit être 0 ou 1', 1),
(3828, 4, '400032', 'sort数据格式错误，应为整数', 'Le format des données de tri est incorrect, il doit s`agir d`un entier', 1),
(3829, 4, '400033', '请填写管理员账号', 'Veuillez renseigner le compte administrateur', 1),
(3830, 4, '400034', '管理员账号为英文字母', 'Le compte administrateur est en lettres anglaises', 1),
(3831, 4, '400035', '请输管理员姓名', 'Veuillez saisir le nom de l`administrateur', 1),
(3832, 4, '400036', '请选择管理员身份', 'Veuillez sélectionner le statut d`administrateur', 1),
(3833, 4, '400037', '身份必须为数组', 'L`identité doit être un tableau', 1),
(3834, 4, '400038', '请填写城市名称', 'Veuillez renseigner le nom de la ville', 1),
(3835, 4, '400039', 'level数据格式错误，应为整数', 'Le format des données de niveau est incorrect, il doit s`agir d`un nombre entier', 1),
(3836, 4, '400040', 'parent_id数据格式错误，应为整数', 'Erreur de format de données Parent_id, doit être un entier', 1),
(3837, 4, '400041', '请输入有效的网址', 'Veuillez saisir une URL valide', 1),
(3838, 4, '400042', '一级返佣比例必须为数字', 'Le taux de remise de premier niveau doit être un nombre', 1),
(3839, 4, '400043', '一级返佣比例最多两位小数', 'Le taux de remboursement de premier niveau peut être jusqu`à deux décimales', 1),
(3840, 4, '400044', '一级返佣比例填写范围在0-100之间', 'Le taux de remboursement de premier niveau remplit la plage entre 0 et 100', 1),
(3841, 4, '400045', '二级返佣比例必须为数字', 'Le taux de remboursement secondaire doit être un nombre', 1),
(3842, 4, '400046', '二级返佣比例最多两位小数', 'Le taux de rabais secondaire peut être jusqu`à deux décimales', 1),
(3843, 4, '400047', '二级返佣比例填写范围在0-100之间', 'Le taux de remboursement de second niveau remplit la plage entre 0 et 100', 1),
(3844, 4, '400048', '待补货数量必须为数字', 'La quantité à réapprovisionner doit être un nombre', 1),
(3845, 4, '400049', '警戒库存必须为数字', 'Le stock d`alerte doit être un nombre', 1),
(3846, 4, '400050', '提现最小金额只能为数字', 'Le montant minimum de retrait ne peut être qu`un nombre', 1),
(3847, 4, '400051', '提现最小金额必须大于0', 'Le montant minimum de retrait doit être supérieur à 0', 1),
(3848, 4, '400052', '佣金冻结时间范围在0-180之间', 'La plage de temps de gel de la commission est comprise entre 0 et 180', 1),
(3849, 4, '400053', '满额分销金额金额必须为数字', 'Le montant total de la distribution doit être un nombre', 1),
(3850, 4, '400054', '积分抵用比例必须为数字', 'Le ratio de crédit de points doit être un nombre', 1),
(3851, 4, '400055', '积分抵用比例最多两位小数', 'Le pourcentage de déduction de points peut aller jusqu`à deux décimales', 1),
(3852, 4, '400056', '积分抵用比例必须在0-1000之间', 'Le pourcentage de points de crédit doit être compris entre 0 et 1000', 1),
(3853, 4, '400057', '积分抵用上限必须为数字', 'La limite supérieure des points de crédit doit être un nombre', 1),
(3854, 4, '400058', '积分抵用上限必须大于等于0', 'La limite supérieure des points de crédit doit être supérieure ou égale à 0', 1),
(3855, 4, '400059', '下单赠送积分必须为数字', 'Les points bonus de la commande doivent être des nombres', 1),
(3856, 4, '400060', '下单赠送积分必须在0-1000之间', 'Les points bonus de la commande doivent être compris entre 0 et 1000', 1),
(3857, 4, '400061', '普通商品未支付取消订单时间必须为数字', 'Le délai d`annulation d`un article ordinaire non payé doit être un nombre', 1),
(3858, 4, '400062', '活动商品未支付取消订单时间必须为数字', 'L`heure d`annulation de la commande doit être un nombre si l`article de l`événement n`est pas payé', 1),
(3859, 4, '400063', '砍价商品未支付取消订单时间必须为数字', 'Le délai pour annuler la commande si l`article bon marché n`est pas payé doit être un nombre', 1),
(3860, 4, '400064', '拼团商品未支付取消订单时间必须为数字', 'Le délai pour annuler la commande si l`article du groupe n`est pas payé doit être un nombre', 1),
(3861, 4, '400065', '订单发货后自动收货时间必须为数字', 'L`heure de livraison automatique après l`expédition de la commande doit être un nombre', 1),
(3862, 4, '400066', '满额包邮金额必须为数字', 'Le montant de la livraison gratuite doit être un nombre', 1),
(3863, 4, '400067', '积分倍数必须大于0', 'Le multiplicateur intégral doit être supérieur à 0', 1),
(3864, 4, '400068', '折扣数必须大于0', 'Le nombre de remises doit être supérieur à 0', 1),
(3865, 4, '400069', '积分倍数必须大于0', 'Le multiplicateur intégral doit être supérieur à 0', 1),
(3866, 4, '400070', '折扣数必须大于0', 'La remise doit être supérieure à 0', 1),
(3867, 4, '400071', '下单赠送经验比率必须为数字', 'Le rapport d`expérience du bonus de commande doit être un nombre', 1),
(3868, 4, '400072', '下单赠送经验比率必须大于0', 'Le taux d`expérience du bonus de commande doit être supérieur à 0', 1),
(3869, 4, '400073', '签到赠送经验必须为数字', 'L`expérience cadeau de connexion doit être un nombre', 1),
(3870, 4, '400074', '签到赠送经验必须大于0', 'L`expérience de connexion doit être supérieure à 0', 1),
(3871, 4, '400075', '邀请新用户赠送经验必须为数字', 'Inviter de nouveaux utilisateurs à donner de l`expérience doit être un nombre', 1),
(3872, 4, '400076', '邀请新用户赠送经验必须大于0', 'Inviter de nouveaux utilisateurs à donner de l`expérience doit être supérieur à 0', 1),
(3873, 4, '400077', '发货人姓名必须为汉字', 'Le nom de l`expéditeur doit être en caractères chinois', 1),
(3874, 4, '400078', '发货人姓名长度在2-10位', 'La longueur du nom de l`expéditeur est de 2 à 10 chiffres', 1),
(3875, 4, '400079', '发货人电话必须为数字', 'Le numéro de téléphone de l`expéditeur doit être un numéro', 1),
(3876, 4, '400080', '发货人电话请填写有效的手机号', 'Veuillez saisir un numéro de téléphone portable valide pour le numéro de téléphone de l`expéditeur', 1),
(3877, 4, '400081', '发货人地址只能是汉字、字母、数字', 'L`adresse de l`expéditeur ne peut être composée que de caractères chinois, de lettres et de chiffres', 1),
(3878, 4, '400082', '发货人地址长度为10-100位', 'La longueur de l`adresse de l`expéditeur est de 10 à 100 chiffres', 1),
(3879, 4, '400083', '电子面单打印机编号必须为数字、字母', 'Le numéro de série de l`imprimante de formulaires électroniques doit être composé de chiffres et de lettres', 1),
(3880, 4, '400084', '电子面单打印机编号长度为10-50位', 'La longueur du numéro de série de l`imprimante de feuilles électroniques est de 10 à 50 chiffres', 1),
(3881, 4, '400085', '客服反馈长度位10-90位', 'La longueur des commentaires du service client est de 10 à 90', 1),
(3882, 4, '400086', '请填写标签分类名称', 'Veuillez renseigner le nom de la catégorie du libellé', 1),
(3883, 4, '400087', '请填写标签分类排序', 'Veuillez renseigner l`ordre de classement des étiquettes', 1),
(3884, 4, '400088', '标签分类必须为数字', 'La catégorie du libellé doit être un nombre', 1),
(3885, 4, '400089', '账号只能为数字和字母', 'Le compte ne peut contenir que des chiffres et des lettres', 1),
(3886, 4, '400090', '限量不能超过商品库存', 'La quantité limitée ne peut pas dépasser l`inventaire du produit', 1),
(3887, 4, '400091', '商品已下架或移入回收站', 'L`élément a été supprimé ou déplacé vers la corbeille', 1),
(3888, 4, '400092', '占用库存失败', 'Impossible d`occuper l`inventaire', 1),
(3889, 4, '400093', '商品已下架或已删除', 'L`élément a été retiré ou supprimé', 1),
(3890, 4, '400094', '请选择有效的商品属性', 'Veuillez sélectionner un attribut de produit valide', 1),
(3891, 4, '400095', '金额不能小于0', 'Le montant ne peut pas être inférieur à 0', 1),
(3892, 4, '400096', '结束时间不能小于今天', 'L`heure de fin ne peut pas être inférieure à aujourd`hui', 1),
(3893, 4, '400097', '您不是付费会员', 'Vous n`êtes pas un membre payant', 1),
(3894, 4, '400098', '暂时无法领取', 'Temporairement indisponible', 1),
(3895, 4, '400099', '请先配置小票打印开发者', 'Veuillez d`abord configurer le développeur de l`impression des reçus', 1),
(3896, 4, '400100', '请填写分类名称', 'Veuillez renseigner le nom de la catégorie', 1),
(3897, 4, '400101', '该分类已存在', 'Cette catégorie existe déjà', 1),
(3898, 4, '400102', '请先删除子分类', 'Veuillez d`abord supprimer la sous-catégorie', 1),
(3899, 4, '400103', '分类不存在', 'Le classement n`existe pas', 1),
(3900, 4, '400104', '文件名称不能为空', 'Le nom du fichier ne peut pas être vide', 1),
(3901, 4, '400105', '该分类有下级分类，无法修改上级', 'Cette catégorie a des sous-catégories et ne peut pas modifier la supérieure', 1),
(3902, 4, '400106', '备注不能为空', 'Les remarques ne peuvent pas être vides', 1),
(3903, 4, '400107', '请输入姓名', 'Veuillez saisir votre nom', 1),
(3904, 4, '400108', '请输入提现金额', 'Veuillez entrer le montant du retrait', 1),
(3905, 4, '400109', '请输入支付宝账号', 'Veuillez entrer le numéro de compte Alipay', 1),
(3906, 4, '400110', '请输入微信账号', 'Veuillez saisir votre compte WeChat', 1),
(3907, 4, '400111', '请输入银行卡号', 'Veuillez saisir le numéro de carte bancaire', 1),
(3908, 4, '400112', '请输入开户行', 'Veuillez saisir la banque du compte', 1),
(3909, 4, '400113', '拒绝理由不能为空', 'Le motif de rejet ne peut pas être vide', 1),
(3910, 4, '400114', '不能重复收货', 'Impossible de recevoir des marchandises à plusieurs reprises', 1),
(3911, 4, '400115', '请先发货或者送货', 'Veuillez expédier ou livrer en premier', 1),
(3912, 4, '400116', '收货失败,请稍候再试', 'Échec de réception de la livraison, veuillez réessayer plus tard', 1),
(3913, 4, '400117', '收货成功', 'Marchandises reçues avec succès', 1),
(3914, 4, '400118', '订单不存在', 'La commande n`existe pas', 1),
(3915, 4, '400119', '用户信息不存在', 'Les informations utilisateur n`existent pas', 1),
(3916, 4, '400120', '快递单号不存在', 'Le numéro de suivi express n`existe pas', 1),
(3917, 4, '400121', '打印成功', 'Imprimer avec succès', 1),
(3918, 4, '400122', '打印失败', 'Échec de l`impression', 1),
(3919, 4, '400123', '快递公司编号缺失', 'Le numéro de la société de messagerie est manquant', 1),
(3920, 4, '400124', '请配置腾讯地图KEY', 'Veuillez configurer la clé de la carte Tencent', 1),
(3921, 4, '400125', '请选择门店位置', 'Veuillez sélectionner l`emplacement du magasin', 1),
(3922, 4, '400126', '添加的核销员用户已存在', 'L`utilisateur du compte ajouté existe déjà', 1),
(3923, 4, '400127', '请选择所属提货点', 'Veuillez sélectionner le point de retrait auquel vous appartenez', 1),
(3924, 4, '400128', '请填写核销员名称', 'Veuillez renseigner le nom du vérificateur', 1),
(3925, 4, '400129', '请填写核销员电话', 'Veuillez renseigner le numéro de téléphone du vérificateur', 1),
(3926, 4, '400130', '核销员添加成功', 'Personnel de vérification ajouté avec succès', 1),
(3927, 4, '400131', '核销员添加失败', 'Échec de l`ajout du personnel radié', 1),
(3928, 4, '400132', '请填写手机号', 'Veuillez renseigner le numéro de téléphone', 1),
(3929, 4, '400133', '请填写账号', 'Veuillez renseigner le numéro de compte', 1),
(3930, 4, '400134', '请填写密码', 'Veuillez renseigner le mot de passe', 1),
(3931, 4, '400135', '请填写短信签名', 'Veuillez renseigner la signature SMS', 1),
(3932, 4, '400136', '短信签名最长为8位', 'La longueur maximale de la signature SMS est de 8', 1),
(3933, 4, '400137', '请填写验证码', 'Veuillez renseigner le code de vérification', 1),
(3934, 4, '400138', '请填写域名', 'Veuillez renseigner le nom de domaine', 1),
(3935, 4, '400139', '登录成功', 'Connexion réussie', 1),
(3936, 4, '400140', '账号或密码错误', 'Compte ou mot de passe incorrect', 1),
(3937, 4, '400141', '请先填写短信配置', 'Veuillez d`abord remplir la configuration SMS', 1),
(3938, 4, '400142', '请输入模板名称', 'Veuillez saisir un nom de modèle', 1),
(3939, 4, '400143', '请输入模板内容', 'Veuillez saisir le contenu du modèle', 1),
(3940, 4, '400144', '售后订单状态不支持该操作', 'Le statut de la commande SAV ne supporte pas cette opération', 1),
(3941, 4, '400145', '修改退款状态成功', 'Modifier le statut du remboursement avec succès', 1),
(3942, 4, '400146', '请输入退款金额', 'Veuillez saisir le montant du remboursement', 1),
(3943, 4, '400147', '已退完支付金额，不能再退款了', 'Le montant du paiement a été remboursé, plus de remboursement', 1),
(3944, 4, '400148', '退款金额大于支付金额，请修改退款金额', 'Le montant du remboursement est supérieur au montant du paiement, veuillez modifier le montant du remboursement', 1),
(3945, 4, '400149', '退款成功', 'Remboursement réussi', 1),
(3946, 4, '400150', '退款失败', 'Échec du remboursement', 1),
(3947, 4, '400151', '验证成功', 'Vérification réussie', 1),
(3948, 4, '400152', '核销成功', 'Annulation réussie', 1),
(3949, 4, '400153', '核销订单未查到', 'Ordre de vérification introuvable', 1),
(3950, 4, '400154', '核销失败', 'Échec de la radiation', 1),
(3951, 4, '400155', '订单金额必须填写', 'Le montant de la commande doit être renseigné', 1),
(3952, 4, '400156', '请选择需要删除的订单', 'Veuillez sélectionner la commande à supprimer', 1),
(3953, 4, '400157', '您选择的的订单存在用户未删除的订单', 'La commande que vous avez sélectionnée a une commande non supprimée par l`utilisateur', 1),
(3954, 4, '400158', '请选择发货商品', 'Veuillez sélectionner l`article à expédier', 1),
(3955, 4, '400159', '请重新选择发货商品或发货件数', 'Veuillez re-sélectionner le produit ou le nombre de pièces à expédier', 1),
(3956, 4, '400160', '订单已删除无法退积分', 'La commande a été supprimée et les points ne peuvent pas être remboursés', 1),
(3957, 4, '400161', '请输入积分', 'Veuillez entrer des points', 1),
(3958, 4, '400162', '已退完积分', 'Les points ont été remboursés', 1),
(3959, 4, '400163', '退积分大于支付积分，请修改退积分', 'Les points remboursés sont supérieurs aux points payés, veuillez modifier les points remboursés', 1),
(3960, 4, '400164', '退积分成功', 'Retrait de points réussi', 1),
(3961, 4, '400165', '退积分失败', 'Échec du retrait des points', 1),
(3962, 4, '400166', '请填写开票号', 'Veuillez renseigner le numéro de facture', 1),
(3963, 4, '400167', '请填写正确的开票号', 'Veuillez renseigner le bon numéro de facturation', 1),
(3964, 4, '400168', '请上传文件', 'Veuillez télécharger le fichier', 1),
(3965, 4, '400169', '回复成功', 'Réponse réussie', 1),
(3966, 4, '400170', '注册成功', 'Enregistrement réussi', 1),
(3967, 4, '400171', '注册失败', 'L`enregistrement a échoué', 1),
(3968, 4, '400172', '登录失败', 'La connexion a échoué', 1),
(3969, 4, '400173', '获取套餐列表失败', 'Impossible d`obtenir la liste des packages', 1),
(3970, 4, '400174', '获取支付码失败', 'Impossible d`obtenir le code de paiement', 1),
(3971, 4, '400175', '请先开通短信服务', 'Veuillez d`abord activer le service SMS', 1),
(3972, 4, '400176', '请先开通物流查询服务', 'Veuillez d`abord ouvrir le service de demande logistique', 1),
(3973, 4, '400177', '请先开通电子面单打印服务', 'Veuillez d`abord activer le service d`impression de reçus électroniques', 1),
(3974, 4, '400178', '请先开通商品采集服务', 'Veuillez d`abord activer le service de collecte des marchandises', 1),
(3975, 4, '400179', '请设置短信签名', 'Veuillez définir la signature SMS', 1),
(3976, 4, '400180', '修改短信签名成功', 'Modifier la signature SMS avec succès', 1),
(3977, 4, '400181', '默认模板不能删除', 'Le modèle par défaut ne peut pas être supprimé', 1),
(3978, 4, '400182', '管理员信息读取失败', 'Impossible de lire les informations de l`administrateur', 1),
(3979, 4, '400183', '密码太过简单，请输入较为复杂的密码', 'Le mot de passe est trop simple, veuillez saisir un mot de passe plus complexe', 1),
(3980, 4, '400184', '协议类型不存在', 'Le type de protocole n`existe pas', 1),
(3981, 4, '400185', '清除成功', 'Effacer avec succès', 1),
(3982, 4, '400186', '清除失败', 'Échec de la purge', 1),
(3983, 4, '400187', '请输入名称', 'Veuillez entrer un nom', 1),
(3984, 4, '400188', '请不要重复添加', 'Veuillez ne pas en ajouter plus', 1),
(3985, 4, '400189', '添加数据成功', 'Ajouter les données avec succès', 1),
(3986, 4, '400190', '请输入开始时间', 'Veuillez entrer l`heure de début', 1),
(3987, 4, '400191', '请输入持续时间', 'Veuillez saisir une durée', 1),
(3988, 4, '400192', '请输入0-23点之前的整点数', 'Veuillez entrer le nombre entier avant 0-23', 1),
(3989, 4, '400193', '请输入1-24点之前的整点数', 'Veuillez entrer le nombre entier avant 1-24', 1),
(3990, 4, '400194', '开始时间+持续时间不能大于24小时', 'L`heure de début + la durée ne peuvent pas être supérieures à 24 heures', 1),
(3991, 4, '400195', '时段已占用', 'La plage horaire est occupée', 1),
(3992, 4, '400196', '请输入签到赠送积分', 'Veuillez saisir les points bonus d`enregistrement', 1),
(3993, 4, '400197', '请输入大于等于0的整数', 'Veuillez saisir un entier supérieur ou égal à 0', 1),
(3994, 4, '400198', '请填写按钮名称', 'Veuillez renseigner le nom du bouton', 1),
(3995, 4, '400199', '没有查到此身份', 'L`identité n`a pas été trouvée', 1),
(3996, 4, '400200', '请输入等级名称', 'Veuillez saisir le nom du niveau', 1),
(3997, 4, '400201', '请输入等级', 'Veuillez entrer le niveau', 1),
(3998, 4, '400202', '请选择等级图标', 'Veuillez sélectionner l`icône du niveau', 1),
(3999, 4, '400203', '二级返佣比例不能大于一级', 'Le taux de la remise de second niveau ne peut être supérieur à celui de premier niveau', 1),
(4000, 4, '400204', '当前等级已存在', 'Le niveau actuel existe déjà', 1),
(4001, 4, '400205', '添加等级成功', 'Ajouter le niveau avec succès', 1),
(4002, 4, '400206', '编辑的等级不存在', 'Le niveau modifié n`existe pas', 1),
(4003, 4, '400207', '请输入任务名称', 'Veuillez saisir le nom de la tâche', 1),
(4004, 4, '400208', '请选择任务类型', 'Veuillez sélectionner un type de tâche', 1),
(4005, 4, '400209', '请输入限定数量', 'Veuillez saisir une quantité limitée', 1),
(4006, 4, '400210', '添加任务成功', 'Ajouter la tâche avec succès', 1),
(4007, 4, '400211', '编辑的任务不存在', 'La tâche éditée n`existe pas', 1),
(4008, 4, '400212', '获取推广二维码失败，请检查您的微信配置', 'Impossible d`obtenir le code QR de la promotion, veuillez vérifier votre configuration WeChat', 1),
(4009, 4, '400213', '上级推广人不能为自己', 'Les promoteurs supérieurs ne peuvent pas être eux-mêmes', 1),
(4010, 4, '400214', '用户不存在', 'L`utilisateur n`existe pas', 1),
(4011, 4, '400215', '上级用户不存在', 'L`utilisateur supérieur n`existe pas', 1),
(4012, 4, '400216', '当前推广人已经是所选人', 'Le promoteur actuel est déjà sélectionné', 1),
(4013, 4, '400217', '上级推广人不能为自己下级', 'Les promoteurs supérieurs ne peuvent pas être leurs subordonnés', 1),
(4014, 4, '400218', '赠送成功', 'Cadeau réussi', 1),
(4015, 4, '400219', '赠送失败', 'Le cadeau a échoué', 1),
(4016, 4, '400220', '请输入身份名称', 'Veuillez entrer le nom d`identité', 1),
(4017, 4, '400221', '请选择最少一个权限', 'Veuillez sélectionner au moins une autorisation', 1),
(4018, 4, '400222', '添加身份成功', 'Ajouter l`identité avec succès', 1),
(4019, 4, '400223', '添加身份失败', 'Impossible d`ajouter l`identité', 1),
(4020, 4, '400224', '缺少APPID', 'ID APP manquant', 1),
(4021, 4, '400225', '请先设置空间域名', 'Veuillez d`abord définir le nom de domaine de l`espace', 1),
(4022, 4, '400226', '格式错误，请输入格式为：http://域名', 'Erreur de format, veuillez saisir le format : http://nom de domaine', 1),
(4023, 4, '400227', '未有正在使用的存储空间', 'Aucun espace de stockage utilisé', 1),
(4024, 4, '400228', '切换云存储成功,请检查是否开启使用了存储空间', 'Passage réussi au stockage cloud, veuillez vérifier si l`espace de stockage est activé', 1),
(4025, 4, '400229', '切换本地存储成功', 'Changer de stockage local avec succès', 1),
(4026, 4, '400230', '请输入模板编号', 'Veuillez saisir le numéro du modèle', 1),
(4027, 4, '400231', '请输入模板编号已存在,请重新输入', 'Veuillez entrer le numéro de modèle qui existe déjà, veuillez le saisir à nouveau', 1),
(4028, 4, '400232', '请输入模板ID', 'Veuillez saisir l`ID du modèle', 1),
(4029, 4, '400233', '请输入模板名', 'Veuillez saisir le nom du modèle', 1),
(4030, 4, '400234', '请输入回复内容', 'Veuillez saisir le contenu de la réponse', 1),
(4031, 4, '400235', '添加模板消息成功', 'Ajouter un modèle de message avec succès', 1),
(4032, 4, '400236', '请先配置小程序appid、appSecret等参数', 'Veuillez d`abord configurer l`applet appid, appSecret et les autres paramètres', 1),
(4033, 4, '400237', '二维码生成失败', 'Impossible de générer le code QR', 1),
(4034, 4, '400238', '请添加至少一个按钮', 'Veuillez ajouter au moins un bouton', 1),
(4035, 4, '400239', '请输入关键字', 'Veuillez saisir un mot-clé', 1),
(4036, 4, '400240', '请选择回复类型', 'Veuillez sélectionner un type de réponse', 1),
(4037, 4, '400241', '回复类型有误', 'Type de réponse incorrect', 1),
(4038, 4, '400242', '回复消息参数有误', 'Le paramètre du message de réponse est incorrect', 1),
(4039, 4, '400243', '请添加图文', 'Veuillez ajouter un graphique', 1),
(4040, 4, '400244', '标题不能为空', 'Le titre ne peut pas être vide', 1),
(4041, 4, '400245', '作者不能为空', 'L`auteur ne peut pas être vide', 1),
(4042, 4, '400246', '正文不能为空', 'Le texte ne peut pas être vide', 1),
(4043, 4, '400247', '摘要不能为空', 'Le résumé ne peut pas être vide', 1),
(4044, 4, '400248', '请先配置微信公众号appid、appSecret等参数', 'Veuillez d`abord configurer l`appid du compte public WeChat, appSecret et d`autres paramètres', 1),
(4045, 4, '400249', '模版消息一键设置成功', 'La configuration en un clic du modèle de message est réussie', 1),
(4046, 4, '400250', '请选择用户', 'Veuillez sélectionner un utilisateur', 1),
(4047, 4, '400251', '该用户没有绑定手机号，请手动填写', 'L`utilisateur n`est pas lié à un numéro de téléphone mobile, veuillez le remplir manuellement', 1),
(4048, 4, '400252', '手机号格式错误', 'Erreur de format de numéro de téléphone portable', 1),
(4049, 4, '400253', '客服已存在', 'Le service client existe déjà', 1),
(4050, 4, '400254', '请输入账号', 'Veuillez entrer le numéro de compte', 1),
(4051, 4, '400255', '账号必须为数字或者字母的组合4-30位', 'Le numéro de compte doit être une combinaison de 4 à 30 chiffres ou lettres', 1),
(4052, 4, '400256', '请输入密码', 'Veuillez entrer votre mot de passe', 1),
(4053, 4, '400257', '密码必须为数字或者字母的组合6-20位', 'Le mot de passe doit être une combinaison de 6 à 20 chiffres ou lettres', 1),
(4054, 4, '400258', '该手机号的客服已存在', 'Le service client pour ce numéro de téléphone existe déjà', 1),
(4055, 4, '400259', '该客服账号已存在', 'Le compte service client existe déjà', 1),
(4056, 4, '400260', '客服添加成功', 'Service client ajouté avec succès', 1),
(4057, 4, '400261', '客服添加失败', 'Échec de l`ajout du service client', 1),
(4058, 4, '400262', '客服名称不能为空', 'Le nom du service client ne peut pas être vide', 1),
(4059, 4, '400263', '请输入确认密码', 'Veuillez entrer le mot de passe de confirmation', 1),
(4060, 4, '400264', '两次输入的密码不一致', 'Les mots de passe entrés deux fois sont incohérents', 1),
(4061, 4, '400265', '用户不存在，客服将强制禁止登录', 'L`utilisateur n`existe pas, le service client interdira de force la connexion', 1),
(4062, 4, '400266', '登录的客服不存在', 'Le service client connecté n`existe pas', 1),
(4063, 4, '400267', '请先填写客服账号和密码再尝试进入客服平台', 'Veuillez renseigner le compte et le mot de passe du service client avant d`essayer d`accéder à la plateforme du service client', 1),
(4064, 4, '400268', '反馈内容不存在', 'Le contenu des commentaires n`existe pas', 1),
(4065, 4, '400269', '话术不能重复添加', 'Les mots ne peuvent pas être ajoutés à plusieurs reprises', 1),
(4066, 4, '400270', '创建话术成功', 'Création réussie d`une conversation', 1),
(4067, 4, '400271', '创建话术失败', 'Échec de la création d`une conversation', 1),
(4068, 4, '400272', '删除的话术不存在', 'Les mots supprimés n`existent pas', 1),
(4069, 4, '400273', '系统分类不能删除', 'La classification du système ne peut pas être supprimée', 1),
(4070, 4, '400274', '请输入配置名称', 'Veuillez entrer un nom de configuration', 1),
(4071, 4, '400275', '请输入字段名称', 'Veuillez saisir le nom du champ', 1),
(4072, 4, '400276', '请输入配置简介', 'Veuillez entrer le profil de configuration', 1),
(4073, 4, '400277', '请输入文本框的宽度', 'Veuillez entrer la largeur de la zone de texte', 1),
(4074, 4, '400278', '请输入正确的文本框的宽度', 'Veuillez entrer la largeur correcte de la zone de texte', 1),
(4075, 4, '400279', '请输入多行文本框的宽度', 'Veuillez saisir la largeur de la zone de texte multiligne', 1),
(4076, 4, '400280', '请输入多行文本框的高度', 'Veuillez saisir la hauteur de la zone de texte multiligne', 1),
(4077, 4, '400281', '请输入正确的多行文本框的宽度', 'Veuillez entrer la largeur correcte de la zone de texte multiligne', 1),
(4078, 4, '400282', '请输入正确的多行文本框的宽度', 'Veuillez entrer la largeur correcte de la zone de texte multiligne', 1),
(4079, 4, '400283', '请输入配置参数', 'Veuillez saisir les paramètres de configuration', 1),
(4080, 4, '400284', '添加配置成功', 'Ajouter la configuration avec succès', 1),
(4081, 4, '400285', '一二级返佣比例不能大于100%', 'Le taux de rabais de premier et deuxième niveau ne peut pas être supérieur à 100 %', 1),
(4082, 4, '400286', '分销海报不能多于5张', 'Pas plus de 5 affiches de distribution', 1),
(4083, 4, '400287', '提现最低金额只能为数字', 'Le montant minimum de retrait ne peut être qu`un nombre', 1),
(4084, 4, '400288', '满额分销最低金额不能为空', 'Le montant minimum pour une distribution complète ne peut pas être vide', 1),
(4085, 4, '400289', '满额分销最低金额不能小于0', 'Le montant minimum de distribution complète ne peut pas être inférieur à 0', 1),
(4086, 4, '400290', '绑定有效期请填写正整数', 'Veuillez renseigner un entier positif pour la durée de validité de la liaison', 1),
(4087, 4, '400291', '请输入标题', 'Veuillez entrer un titre', 1),
(4088, 4, '400292', '添加配置分类成功', 'Ajouter la catégorie de configuration avec succès', 1),
(4089, 4, '400293', '存在下级配置，无法删除', 'La configuration subordonnée existe et ne peut pas être supprimée', 1),
(4090, 4, '400294', '字段至少存在一个', 'Au moins un champ existe', 1),
(4091, 4, '400295', '添加数据组成功', 'Ajouter le groupe de données avec succès', 1),
(4092, 4, '400296', '数据关键字已存在', 'La clé de données existe déjà', 1),
(4093, 4, '400297', '字段不能为空', 'Le champ ne peut pas être vide', 1),
(4094, 4, '400298', '不能大于四个', 'Ne peut pas être supérieur à quatre', 1),
(4095, 4, '400299', '签到天数配置不能大于7天', 'La configuration des jours d`enregistrement ne peut pas être supérieure à 7 jours', 1),
(4096, 4, '400300', '关联成功', 'Associé avec succès', 1),
(4097, 4, '400301', '关联失败', 'Échec de l`association', 1),
(4098, 4, '400302', '数据缓存刷新成功', 'Rafraîchissement du cache de données réussi', 1),
(4099, 4, '400303', '数据缓存刷新失败', 'Échec de l`actualisation du cache de données', 1),
(4100, 4, '400304', '请输入需要更换的域名', 'Veuillez saisir le nom de domaine à modifier', 1),
(4101, 4, '400305', '域名不合法', 'Le nom de domaine est invalide', 1),
(4102, 4, '400306', '替换成功', 'Remplacement réussi', 1),
(4103, 4, '400307', '初始化完成', 'Initialisation terminée', 1),
(4104, 4, '400308', '备份文件可能已经损坏，请检查', 'Le fichier de sauvegarde est peut-être endommagé, veuillez vérifier', 1),
(4105, 4, '400309', '还原数据出错', 'Erreur lors de la restauration des données', 1),
(4106, 4, '400310', '正在还原...', 'Restauration en cours...', 1),
(4107, 4, '400311', '还原完成', 'Restauration terminée', 1),
(4108, 4, '400312', '权益编辑成功', 'Modification des actions réussie', 1),
(4109, 4, '400313', '卡片生成成功', 'Carte générée avec succès', 1),
(4110, 4, '400314', '手机号已经存在', 'Le numéro de téléphone existe déjà', 1),
(4111, 4, '400315', '请输入正确的身份证', 'Veuillez entrer la bonne carte d`identité', 1),
(4112, 4, '400316', '请选择分组', 'Veuillez sélectionner un groupe', 1),
(4113, 4, '400317', '请选择标签', 'Veuillez sélectionner un libellé', 1),
(4114, 4, '400318', '加入消息队列成功', 'Rejoindre la file d`attente des messages avec succès', 1),
(4115, 4, '400319', '注销成功', 'Déconnexion réussie', 1),
(4116, 4, '400320', '拒绝注销', 'Refusé de se déconnecter', 1),
(4117, 4, '400321', '请输入分组名称', 'Veuillez entrer un nom de groupe', 1),
(4118, 4, '400322', '会员标签不能为空', 'La balise membre ne peut pas être vide', 1),
(4119, 4, '400323', '该分类下有标签，请先删除标签', 'Il y a un libellé dans cette catégorie, veuillez d`abord le supprimer', 1),
(4120, 4, '400324', '请输入等级名称', 'Veuillez saisir le nom du niveau', 1),
(4121, 4, '400325', '请输入等级', 'Veuillez entrer le niveau', 1),
(4122, 4, '400326', '请输入等级说明', 'Veuillez entrer la description du niveau', 1),
(4123, 4, '400327', '请上传等级图标', 'Veuillez télécharger l`icône de niveau', 1),
(4124, 4, '400328', '请上传等级背景图标', 'Veuillez télécharger l`icône d`arrière-plan du niveau', 1),
(4125, 4, '400329', '请输入升级经验值', 'Veuillez saisir la valeur de l`expérience de mise à niveau', 1),
(4126, 4, '400330', '授权成功，写入数据库失败，请检查数据库链接配置', 'L`autorisation a réussi, mais l`écriture dans la base de données a échoué, veuillez vérifier la configuration du lien de la base de données', 1),
(4127, 4, '400331', '请填写公司名称', 'Veuillez renseigner le nom de l`entreprise', 1),
(4128, 4, '400332', '请填写授权域名', 'Veuillez renseigner le nom de domaine autorisé', 1),
(4129, 4, '400333', '请填写手机号码', 'Veuillez renseigner le numéro de téléphone', 1),
(4130, 4, '400334', '请填写订单id', 'Veuillez renseigner l`identifiant de la commande', 1),
(4131, 4, '400335', '申请授权成功', 'Demande d`autorisation réussie', 1),
(4132, 4, '400336', '验证码错误', 'Erreur de code de vérification', 1),
(4133, 4, '400337', '请选择商品', 'Veuillez sélectionner un article', 1),
(4134, 4, '400338', '请输入商品名称', 'Veuillez saisir le nom du produit', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(4135, 4, '400339', '请选择背景图', 'Veuillez sélectionner une image de fond', 1),
(4136, 4, '400340', '请输入直播价格', 'Veuillez entrer le prix de diffusion en direct', 1),
(4137, 4, '400341', '直播价格必须大于0', 'Le prix de diffusion en direct doit être supérieur à 0', 1),
(4138, 4, '400342', '请输入直播间名称', 'Veuillez saisir le nom de la salle de diffusion en direct', 1),
(4139, 4, '400343', '请选择背景图', 'Veuillez sélectionner une image de fond', 1),
(4140, 4, '400344', '请选择分享图', 'Veuillez sélectionner une image à partager', 1),
(4141, 4, '400345', '请选择主播', 'Veuillez sélectionner une ancre', 1),
(4142, 4, '400346', '请选择直播开始、结束时间', 'Veuillez sélectionner l`heure de début et de fin de la diffusion en direct', 1),
(4143, 4, '400347', '请填写活动简介', 'Veuillez remplir l`introduction de l`événement', 1),
(4144, 4, '400348', '请填写单位', 'Veuillez renseigner l`unité', 1),
(4145, 4, '400349', '请选择商品轮播图', 'Veuillez sélectionner le carrousel produit', 1),
(4146, 4, '400350', '您设置得商品个数超出系统限制', 'Le nombre d`éléments que vous avez défini dépasse la limite du système', 1),
(4147, 4, '400351', '模板不存在', 'Le modèle n`existe pas', 1),
(4148, 4, '400352', '请输入页面名称', 'Veuillez saisir le nom de la page', 1),
(4149, 4, '400353', '请选择活动时间段', 'Veuillez sélectionner une période d`événement', 1),
(4150, 4, '400354', '请填写购买数量限制', 'Veuillez renseigner la quantité limite d`achat', 1),
(4151, 4, '400355', '购买数量限制必须大于0', 'La quantité limite d`achat doit être supérieure à 0', 1),
(4152, 4, '400356', '请填写帮砍次数', 'Veuillez renseigner le nombre de coupes', 1),
(4153, 4, '400357', '帮砍次数必须大于0', 'Le nombre de slash doit être supérieur à 0', 1),
(4154, 4, '400358', '请填写砍价人数', 'Veuillez renseigner le nombre de négociateurs', 1),
(4155, 4, '400359', '砍价人数必须大于1', 'Le nombre de personnes qui marchandent doit être supérieur à 1', 1),
(4156, 4, '400360', '请选择运费模板', 'Veuillez sélectionner un modèle d`expédition', 1),
(4157, 4, '400361', '请填写商品详情', 'Veuillez renseigner les détails du produit', 1),
(4158, 4, '400362', '请选择规格', 'Veuillez sélectionner une spécification', 1),
(4159, 4, '400363', '请填写虚拟拼团比例', 'Veuillez renseigner le ratio du groupe virtuel', 1),
(4160, 4, '400364', '虚拟参团人数不能大于成团人数', 'Le nombre de participants virtuels ne peut pas être supérieur au nombre de participants dans le groupe', 1),
(4161, 4, '400365', '虚拟参团人数不能大于成团人数', 'Le nombre de participants virtuels ne peut pas être supérieur au nombre de participants', 1),
(4162, 4, '400366', '请填写单次购买数量', 'Veuillez renseigner la quantité d`achat unique', 1),
(4163, 4, '400367', '单次购买数量必须大于0', 'La quantité d`achat unique doit être supérieure à 0', 1),
(4164, 4, '400368', '请填写成团人数', 'Veuillez renseigner le nombre de personnes du groupe', 1),
(4165, 4, '400369', '拼团人数不能小于2人', 'Le nombre de personnes dans le groupe ne peut pas être inférieur à 2', 1),
(4166, 4, '400370', '请填写成团有效期', 'Veuillez renseigner la période de validité du groupe', 1),
(4167, 4, '400371', '成团有效期必须大于0', 'La période de validité du groupe doit être supérieure à 0', 1),
(4168, 4, '400372', '请填写优惠券名称', 'Veuillez renseigner le nom du coupon', 1),
(4169, 4, '400373', '请选择商品分类', 'Veuillez sélectionner une catégorie de produit', 1),
(4170, 4, '400374', '请填写优惠券金额', 'Veuillez renseigner le montant du coupon', 1),
(4171, 4, '400375', '请填写优惠券最小使用金额', 'Veuillez renseigner le montant minimum d`utilisation du coupon', 1),
(4172, 4, '400376', '请填写优惠券有效期', 'Veuillez renseigner la période de validité du coupon', 1),
(4173, 4, '400377', '请选择秒杀时间段', 'Veuillez sélectionner la période de temps seckill', 1),
(4174, 4, '400378', '请填写门店名称', 'Veuillez renseigner le nom du magasin', 1),
(4175, 4, '400379', '请填写门店简介', 'Veuillez renseigner le profil du magasin', 1),
(4176, 4, '400380', '请填写门店电话', 'Veuillez renseigner le numéro de téléphone du magasin', 1),
(4177, 4, '400381', '请选择提货点logo', 'Veuillez sélectionner le logo du point de retrait', 1),
(4178, 4, '400382', '请选择提货点大图', 'Veuillez sélectionner une image plus grande du point de retrait', 1),
(4179, 4, '400383', '请选择地址', 'Veuillez sélectionner une adresse', 1),
(4180, 4, '400384', '请填写详细地址', 'Veuillez renseigner l`adresse détaillée', 1),
(4181, 4, '400385', '请选择经纬度', 'Veuillez sélectionner la latitude et la longitude', 1),
(4182, 4, '400386', '请选择营业时间', 'Veuillez sélectionner les heures d`ouverture', 1),
(4183, 4, '400387', '短信账号必须填写', 'Le numéro de compte SMS doit être renseigné', 1),
(4184, 4, '400388', '短信密码必须填写', 'Le mot de passe SMS doit être renseigné', 1),
(4185, 4, '400389', '订单号必须存在', 'Le numéro de commande doit exister', 1),
(4186, 4, '400390', '订单号有误', 'Le numéro de commande est incorrect', 1),
(4187, 4, '400391', '订单号必须为字母和数字', 'Le numéro de commande doit être alphanumérique', 1),
(4188, 4, '400392', '订单金额必须填写', 'Le montant de la commande doit être renseigné', 1),
(4189, 4, '400393', '订单金额必须为数字', 'Le montant de la commande doit être un nombre', 1),
(4190, 4, '400394', '订单金额必须填写', 'Le montant de la commande doit être renseigné', 1),
(4191, 4, '400395', '订单金额必须为数字', 'Le montant de la commande doit être un nombre', 1),
(4192, 4, '400396', '订单邮费必须填写', 'Les frais de port de la commande doivent être renseignés', 1),
(4193, 4, '400397', '订单邮费必须为数字', 'L`affranchissement de la commande doit être un nombre', 1),
(4194, 4, '400398', '赠送积分必须为数字', 'Les points cadeaux doivent être des nombres', 1),
(4195, 4, '400399', '请选择用户头像', 'Veuillez sélectionner l`avatar de l`utilisateur', 1),
(4196, 4, '400400', '请输入公司名称', 'Veuillez saisir le nom de l`entreprise', 1),
(4197, 4, '400401', '添加公司成功', 'Ajouter l`entreprise avec succès', 1),
(4198, 4, '400402', '请输入月结账号', 'Veuillez entrer le numéro de compte mensuel', 1),
(4199, 4, '400403', '请输入月结密码', 'Veuillez entrer le mot de passe mensuel', 1),
(4200, 4, '400404', '请输入取件网点', 'Veuillez saisir le lieu de prise en charge', 1),
(4201, 4, '400405', '缩略图大图尺寸（高）必须为数字', 'La taille de la grande image de la vignette (hauteur) doit être un nombre', 1),
(4202, 4, '400406', '缩略图大图尺寸（高）必须大于等于0', 'La taille de la grande image de la vignette (hauteur) doit être supérieure ou égale à 0', 1),
(4203, 4, '400407', '缩略图大图尺寸（宽）必须为数字', 'La taille de la grande image de la vignette (largeur) doit être un nombre', 1),
(4204, 4, '400408', '缩略图大图尺寸（宽）必须大于等于0', 'La taille de la grande image de la vignette (largeur) doit être supérieure ou égale à 0', 1),
(4205, 4, '400409', '缩略图中图尺寸（高）必须为数字', 'La taille (hauteur) de l`image dans la vignette doit être un nombre', 1),
(4206, 4, '400410', '缩略图中图尺寸（高）必须大于等于0', 'La taille (hauteur) de l`image dans la vignette doit être supérieure ou égale à 0', 1),
(4207, 4, '400411', '缩略图中图尺寸（宽）必须为数字', 'La taille (largeur) de l`image dans la vignette doit être un nombre', 1),
(4208, 4, '400412', '缩略图中图尺寸（宽）必须大于等于0', 'La taille (largeur) de l`image dans la vignette doit être supérieure ou égale à 0', 1),
(4209, 4, '400413', '缩略图小图尺寸（高）必须为数字', 'La taille de la vignette (hauteur) doit être un nombre', 1),
(4210, 4, '400414', '缩略图小图尺寸（高）必须大于等于0', 'La taille de la vignette (hauteur) doit être supérieure ou égale à 0', 1),
(4211, 4, '400415', '缩略图小图尺寸（宽）必须为数字', 'La taille de la vignette (largeur) doit être un nombre', 1),
(4212, 4, '400416', '缩略图小图尺寸（宽）必须大于等于0', 'La taille de la vignette (largeur) doit être supérieure ou égale à 0', 1),
(4213, 4, '400417', '水印文字只能是汉字、字母、数字', 'Le texte du filigrane ne peut être que des caractères chinois, des lettres, des chiffres', 1),
(4214, 4, '400418', '水印文字长度为1-10位', 'La longueur du texte du filigrane est de 1 à 10 chiffres', 1),
(4215, 4, '400419', '水印文字大小必须为数字', 'La taille du texte du filigrane doit être un nombre', 1),
(4216, 4, '400420', '水印文字大小必须大于等于0', 'La taille du texte du filigrane doit être supérieure ou égale à 0', 1),
(4217, 4, '400421', '水印横坐标偏移量必须为数字', 'Le décalage de l`abscisse du filigrane doit être un nombre', 1),
(4218, 4, '400422', '水印横坐标偏移量必须大于等于0', 'Le décalage de l`abscisse du filigrane doit être supérieur ou égal à 0', 1),
(4219, 4, '400423', '水印纵坐标偏移量必须为数字', 'Le décalage d`ordonnée du filigrane doit être un nombre', 1),
(4220, 4, '400424', '水印纵坐标偏移量必须大于等于0', 'Le décalage de l`ordonnée du filigrane doit être supérieur ou égal à 0', 1),
(4221, 4, '400425', '该主播已经存在', 'L`hôte existe déjà', 1),
(4222, 4, '400426', '请先去小程序认证主播', 'Veuillez d`abord accéder à l`applet pour authentifier l`ancre', 1),
(4223, 4, '400427', '商品已创建', 'L`élément a été créé', 1),
(4224, 4, '400428', '审核中或审核失败不允许此操作', 'Cette opération n`est pas autorisée en cas d`échec de révision ou de révision', 1),
(4225, 4, '400429', '在审核中或已经审核通过', 'En cours d`examen ou approuvé', 1),
(4226, 4, '400430', '审核通过或失败', 'Approbation réussie ou échouée', 1),
(4227, 4, '400431', '商品审核中，无法删除', 'Le produit est en cours d`examen et ne peut pas être supprimé', 1),
(4228, 4, '400432', '该主播不存在', 'L`hôte n`existe pas', 1),
(4229, 4, '400433', '开播时间需要在当前时间的10分钟后，并且开始时间不能在6个月后', 'L`heure de diffusion doit être 10 minutes après l`heure actuelle, et l`heure de début ne peut pas être 6 mois plus tard', 1),
(4230, 4, '400434', '开播时间和结束时间间隔不得短于30分钟，不得超过24小时', 'L`intervalle entre l`heure de début et l`heure de fin ne doit pas être inférieur à 30 minutes et ne doit pas dépasser 24 heures', 1),
(4231, 4, '400435', '请输入理由', 'Veuillez entrer la raison', 1),
(4232, 4, '400436', '请选择正确的直播商品', 'Veuillez sélectionner le bon produit en direct', 1),
(4233, 4, '400437', '直播间状态有误', 'Le statut de la salle en direct est incorrect', 1),
(4234, 4, '400438', '奖品不存在', 'Le prix n`existe pas', 1),
(4235, 4, '400439', '写入中奖记录失败', 'Impossible d`écrire l`enregistrement gagnant', 1),
(4236, 4, '400440', '请继续参与活动抽奖', 'Veuillez continuer à participer au tirage au sort', 1),
(4237, 4, '400441', '已经领取成功', 'Reçu avec succès', 1),
(4238, 4, '400442', '分销等级不存在', 'Le niveau de distribution n`existe pas', 1),
(4239, 4, '400443', '选择的等级不存在', 'Le niveau sélectionné n`existe pas', 1),
(4240, 4, '400444', '该等级已存在此类型任务', 'Ce type de tâche existe déjà à ce niveau', 1),
(4241, 4, '400445', '不能小于低等级同类型任务限定数量', 'Ne peut pas être inférieur au nombre limité de tâches de bas niveau du même type', 1),
(4242, 4, '400446', '不能大于高等级同类型任务限定数量', 'Ne peut pas être supérieur au nombre de tâches de haut niveau du même type', 1),
(4243, 4, '400447', '解除失败', 'Échec de la libération', 1),
(4244, 4, '400448', '代理商佣金比例不能大于事业部佣金比例', 'Le ratio de commission de l`agent ne peut pas être supérieur au ratio de commission de la division', 1),
(4245, 4, '400449', '代理商到期时间不能大于事业部到期时间', 'L`heure d`expiration de l`agent ne peut pas être supérieure à l`heure d`expiration de la division', 1),
(4246, 4, '400450', '请填写用户UID', 'Veuillez renseigner l`UID de l`utilisateur', 1),
(4247, 4, '400451', '管理员信息未查到', 'Informations administrateur introuvables', 1),
(4248, 4, '400452', '管理员已经删除', 'L`administrateur a été supprimé', 1),
(4249, 4, '400453', '管理员姓名不能为空', 'Le nom de l`administrateur ne peut pas être vide', 1),
(4250, 4, '400454', '该分类有下级分类，无法删除', 'Cette catégorie a des sous-catégories et ne peut pas être supprimée', 1),
(4251, 4, '400455', '该分类下有文章，无法删除', 'Il y a des articles dans cette catégorie et ne peuvent pas être supprimés', 1),
(4252, 4, '400456', '请稍后查看', 'Veuillez vérifier plus tard', 1),
(4253, 4, '400457', '默认模板不能删除', 'Le modèle par défaut ne peut pas être supprimé', 1),
(4254, 4, '400458', '该模板使用中，无法删除', 'Ce modèle est en cours d`utilisation et ne peut pas être supprimé', 1),
(4255, 4, '400459', '个人中心模板不存在', 'Le modèle de centre personnel n`existe pas', 1),
(4256, 4, '400460', '反馈内容没有查到', 'Contenu des commentaires introuvable', 1),
(4257, 4, '400461', '您修改的话术内容不存在', 'Le contenu des mots que vous avez modifiés n`existe pas', 1),
(4258, 4, '400462', '短信平台：{:msg}', 'Plateforme SMS : {:msg}', 1),
(4259, 4, '400463', '订单商品获取失败,无法打印', 'Impossible d`obtenir l`article commandé, impossible d`imprimer', 1),
(4260, 4, '400464', '小票打印未开启', 'L`impression des reçus n`est pas activée', 1),
(4261, 4, '400465', '请先配置小票打印开发者', 'Veuillez d`abord configurer le développeur de l`impression des reçus', 1),
(4262, 4, '400466', '请选择图片', 'Veuillez sélectionner une image', 1),
(4263, 4, '400467', '配送员已存在', 'Le livreur existe déjà', 1),
(4264, 4, '400468', '同一个手机号的配送员只能添加一个', 'Un seul livreur avec le même numéro de mobile peut être ajouté', 1),
(4265, 4, '400469', '配送员名称不能为空', 'Le nom du livreur ne peut pas être vide', 1),
(4266, 4, '400470', '订单未能查到,不能发货', 'La commande est introuvable et ne peut pas être expédiée', 1),
(4267, 4, '400471', '订单已删除,不能发货', 'La commande a été supprimée et ne peut pas être expédiée', 1),
(4268, 4, '400472', '订单已发货请勿重复操作', 'La commande a été expédiée, merci de ne pas répéter l`opération', 1),
(4269, 4, '400473', '核销订单不能发货', 'La commande vérifiée ne peut pas être expédiée', 1),
(4270, 4, '400474', '拼团未完成暂不能发货', 'Le groupe ne peut pas être expédié temporairement', 1),
(4271, 4, '400475', '订单有售后申请请先处理', 'La commande a une application SAV, merci de la traiter en premier', 1),
(4272, 4, '400476', '快递公司编缺失', 'La société de messagerie est manquante', 1),
(4273, 4, '400477', '请填写寄件人电话', 'Veuillez renseigner le numéro de téléphone de l`expéditeur', 1),
(4274, 4, '400478', '请填写寄件人地址', 'Veuillez renseigner l`adresse de l`expéditeur', 1),
(4275, 4, '400479', '虚拟发货，无需修改发货信息', 'Livraison virtuelle, pas besoin de modifier les informations de livraison', 1),
(4276, 4, '400480', '未发货，请先发货再修改配送信息', 'Non expédié, veuillez d`abord expédier puis modifier les informations de livraison', 1),
(4277, 4, '400481', '自提订单无法打印', 'Impossible d`imprimer la commande de retrait en libre-service', 1),
(4278, 4, '400482', '请先发货', 'Veuillez expédier en premier', 1),
(4279, 4, '400483', '请先在系统设置中打开单子面单打印开关', 'Veuillez d`abord activer le commutateur d`impression recto simple dans les paramètres système', 1),
(4280, 4, '400484', '发票已申请，正在审核打印中', 'La facture a été demandée et est en cours de révision et d`impression', 1),
(4281, 4, '400485', '订单已退款', 'Commande remboursée', 1),
(4282, 4, '400486', '正在申请退款中', 'Demande de remboursement', 1),
(4283, 4, '400487', '申请失败', 'L`application a échoué', 1),
(4284, 4, '400488', '未支付无法退款', 'Aucun remboursement si non payé', 1),
(4285, 4, '400489', '回退积分和优惠券失败', 'Échec de restauration des points et des coupons', 1),
(4286, 4, '400490', '拼团修改失败', 'La modification du groupe a échoué', 1),
(4287, 4, '400491', '回退佣金失败', 'Échec de l`annulation de la commission', 1),
(4288, 4, '400492', '余额退款失败', 'Échec du remboursement du solde', 1),
(4289, 4, '400493', '购买的优惠券已使用或者已过期', 'Le coupon acheté a été utilisé ou a expiré', 1),
(4290, 4, '400494', '回退积分增加失败', 'Échec de l`augmentation des points de restauration', 1),
(4291, 4, '400495', '售后订单不存在', 'La commande après-vente n`existe pas', 1),
(4292, 4, '400496', '积分已退或者积分为零无法再退', 'Les points ont été remboursés ou les points ne peuvent pas être remboursés si les points sont nuls', 1),
(4293, 4, '400497', '未支付无法退积分', 'Les points ne peuvent pas être remboursés sans paiement', 1),
(4294, 4, '400498', '订单退积分失败', 'Échec du remboursement des points pour la commande', 1),
(4295, 4, '400499', '请输入拒绝退款理由', 'Veuillez entrer le motif du refus du remboursement', 1),
(4296, 4, '400500', '限制单次购买数量不能大于总购买数量', 'La quantité d`achat unique ne peut pas être supérieure à la quantité totale d`achat', 1),
(4297, 4, '400501', '请添加抽奖活动名称', 'Veuillez ajouter le nom du tirage au sort', 1),
(4298, 4, '400502', '请添加抽奖描述等文案', 'Veuillez ajouter une description de la loterie et autre copie', 1),
(4299, 4, '400503', '活动结束时间必须大于开始时间', 'L`heure de fin de l`événement doit être supérieure à l`heure de début', 1),
(4300, 4, '400504', '请添加奖品', 'Veuillez ajouter un prix', 1),
(4301, 4, '400505', '请填写消耗数量', 'Veuillez renseigner la quantité consommée', 1),
(4302, 4, '400506', '商品参与其他活动开启，无法开启预售', 'La participation des marchandises à d`autres activités est activée, la prévente ne peut pas être ouverte', 1),
(4303, 4, '400507', '活动结束时间不能小于当前时间', 'L`heure de fin de l`événement ne peut pas être inférieure à l`heure actuelle', 1),
(4304, 4, '400508', '活动已结束,请重新添加或复制', 'L`événement est terminé, veuillez le rajouter ou le copier', 1),
(4305, 4, '400509', '添加优惠券成功', 'Ajouter le coupon avec succès', 1),
(4306, 4, '400510', '发布优惠劵成功', 'Coupons émis avec succès', 1),
(4307, 4, '400511', '砍价最低价不能大于或等于起始金额', 'Le prix de négociation le plus bas ne peut être supérieur ou égal au montant de départ', 1),
(4308, 4, '400512', '砍价人数不能大于{:num}人', 'Le nombre de personnes qui marchandent ne peut pas être supérieur à {:num}', 1),
(4309, 4, '400513', '使用开始时间不能小于领取开始时间', 'L`heure de début d`utilisation ne peut pas être inférieure à l`heure de début de collecte', 1),
(4310, 4, '400514', '使用结束时间不能小于领取结束时间', 'L`heure de fin d`utilisation ne peut être inférieure à l`heure de fin de collecte', 1),
(4311, 4, '400515', '优惠券不存在', 'Le coupon n`existe pas', 1),
(4312, 4, '400516', '领取的优惠劵已领完或已过期', 'Les coupons que vous avez reçus sont épuisés ou ont expiré', 1),
(4313, 4, '400517', '已领取过该优惠劵', 'Le coupon a été reçu', 1),
(4314, 4, '400518', '抱歉，优惠券已经领取完了', 'Désolé, les coupons ont été récupérés', 1),
(4315, 4, '400519', '选择用户已拥有该优惠券，请勿重复发放', 'Sélectionnez l`utilisateur qui possède déjà le coupon, veuillez ne pas l`émettre à plusieurs reprises', 1),
(4316, 4, '400520', '订单已删除', 'Commande supprimée', 1),
(4317, 4, '400521', '订单已发货', 'Commande expédiée', 1),
(4318, 4, '400522', '暂时不支持其他发货类型', 'Ne prend temporairement pas en charge les autres types de livraison', 1),
(4319, 4, '400523', '请输入送货人姓名', 'Veuillez entrer le nom du livreur', 1),
(4320, 4, '400524', '请输入送货人电话号码', 'Veuillez saisir le numéro de téléphone du livreur', 1),
(4321, 4, '400525', '请输入送货人信息', 'Veuillez entrer les informations du livreur', 1),
(4322, 4, '400526', '请输入正确的送货人电话号码', 'Veuillez saisir le bon numéro de téléphone du livreur', 1),
(4323, 4, '400527', '请选择电子面单模板', 'Veuillez sélectionner un modèle pour le reçu électronique', 1),
(4324, 4, '400528', '电子面单已关闭，请选择其他发货方式', 'La facture électronique a été clôturée, veuillez choisir un autre mode d`expédition', 1),
(4325, 4, '400529', '发货失败', 'L`envoi a échoué', 1),
(4326, 4, '400530', '订单状态错误', 'Erreur d`état de la commande', 1),
(4327, 4, '400531', '请输入快递单号', 'Veuillez entrer le numéro de suivi', 1),
(4328, 4, '400532', '请先发货再修改配送信息', 'Veuillez d`abord expédier puis modifier les informations de livraison', 1),
(4329, 4, '400533', '商品不存在', 'L`article n`existe pas', 1),
(4330, 4, '400534', '您查看的积分商品已被删除', 'L`élément de points que vous avez consulté a été supprimé', 1),
(4331, 4, '400535', '请添加商品', 'Veuillez ajouter un produit', 1),
(4332, 4, '400536', '添加抽奖活动失败', 'Échec de l`ajout des tirages au sort', 1),
(4333, 4, '400537', '抽奖活动不存在', 'La loterie n`existe pas', 1),
(4334, 4, '400538', '请填写奖品名称', 'Veuillez renseigner le nom du prix', 1),
(4335, 4, '400539', '请选择奖品图片', 'Veuillez sélectionner la photo du prix', 1),
(4336, 4, '400540', '请填写奖品中奖权重', 'Veuillez renseigner le poids gagnant du lot', 1),
(4337, 4, '400541', '请选择奖品类型', 'Veuillez sélectionner le type de prix', 1),
(4338, 4, '400542', '请填写奖品赠送{:type}数', 'Veuillez renseigner le {:type} nombre de prix', 1),
(4339, 4, '400543', '请选择优惠券', 'Veuillez sélectionner un coupon', 1),
(4340, 4, '400544', '生成新订单失败', 'Impossible de générer une nouvelle commande', 1),
(4341, 4, '400545', '修改原来订单商品拆分状态失败', 'Impossible de modifier le statut de fractionnement de l`article de la commande d`origine', 1),
(4342, 4, '400546', '新增拆分订单商品信息失败', 'Impossible d`ajouter des informations sur le produit pour la commande fractionnée', 1),
(4343, 4, '400547', '保存新订单商品信息失败', 'Impossible d`enregistrer les informations sur le produit de la nouvelle commande', 1),
(4344, 4, '400548', '协议类型缺失', 'Type de protocole manquant', 1),
(4345, 4, '400549', '请填写协议名称', 'Veuillez renseigner le nom de l`accord', 1),
(4346, 4, '400550', '请填写协议内容', 'Veuillez renseigner le contenu de l`accord', 1),
(4347, 4, '400551', '该类型协议已经存在', 'Ce type de protocole existe déjà', 1),
(4348, 4, '400552', '临时二维码获取错误', 'Erreur lors de l`obtention du code QR temporaire', 1),
(4349, 4, '400553', '永久二维码获取错误', 'Erreur lors de l`obtention du code QR permanent', 1),
(4350, 4, '400554', '请先配置接口密钥', 'Veuillez d`abord configurer la clé d`interface', 1),
(4351, 4, '400555', '无法创建文件夹，请检查您的上传目录权限', 'Échec de la création du dossier, veuillez vérifier les autorisations de votre répertoire de téléchargement', 1),
(4352, 4, '400556', '商品参数错误', 'Erreur de paramètre de marchandise', 1),
(4353, 4, '400557', '上传方式错误', 'Méthode de téléchargement incorrecte', 1),
(4354, 4, '400558', '格式错误', 'Erreur de formatage', 1),
(4355, 4, '400559', '图片流获取失败', 'Impossible d`obtenir le flux d`images', 1),
(4356, 4, '400560', '商品详情保存失败', 'Échec de l`enregistrement des détails du produit', 1),
(4357, 4, '400561', '关联优惠券失败', 'Échec de l`association du coupon', 1),
(4358, 4, '400562', '缺少商品ID', 'Identifiant d`article manquant', 1),
(4359, 4, '400563', '缺少用户UID', 'UID utilisateur manquant', 1),
(4360, 4, '400564', '缺少订单ID', 'ID de commande manquant', 1),
(4361, 4, '400565', '暂不支持该类型记录', 'Ce type d`enregistrement n`est pas supporté actuellement', 1),
(4362, 4, '400566', '添加商品记录失败', 'Échec de l`ajout de l`enregistrement du produit', 1),
(4363, 4, '400567', '评论时间应小于当前时间', 'L`heure du commentaire doit être inférieure à l`heure actuelle', 1),
(4364, 4, '400568', '添加虚拟评论失败', 'Impossible d`ajouter un commentaire virtuel', 1),
(4365, 4, '400569', '回复失败', 'La réponse a échoué', 1),
(4366, 4, '400570', '请选择限购类型', 'Veuillez sélectionner le type de restriction d`achat', 1),
(4367, 4, '400571', '限购数量不能小于1', 'La limite d`achat ne peut pas être inférieure à 1', 1),
(4368, 4, '400572', '一二级返佣相加不能大于商品售价', 'La somme des premier et second rabais ne peut être supérieure au prix du produit', 1),
(4369, 4, '400573', '商品类型不能切换', 'Le type de produit ne peut pas être changé', 1),
(4370, 4, '400574', '请输入规则名称', 'Veuillez saisir le nom de la règle', 1),
(4371, 4, '400575', '请输入属性名称', 'Veuillez saisir le nom de l`attribut', 1),
(4372, 4, '400576', '请输入正确的属性', 'Veuillez entrer le bon attribut', 1),
(4373, 4, '400577', '请填写正确的商品信息', 'Veuillez renseigner les bonnes informations produit', 1),
(4374, 4, '400578', '请填写正确的商品价格', 'Veuillez renseigner le bon prix du produit', 1),
(4375, 4, '400579', '请填写正确的商品库存', 'Veuillez renseigner le bon inventaire produit', 1),
(4376, 4, '400580', '请填写正确的商品成本价格', 'Veuillez renseigner le prix de revient correct de la marchandise', 1),
(4377, 4, '400581', '请上传商品图片', 'Veuillez télécharger l`image du produit', 1),
(4378, 4, '400582', '{:name}规格不存在', 'La spécification {:name} n`existe pas', 1),
(4379, 4, '400583', '{:name}属性不存在', 'L`attribut {:name} n`existe pas', 1),
(4380, 4, '400584', '请设置至少一个属性', 'Veuillez définir au moins un attribut', 1),
(4381, 4, '400585', '商品参与秒杀活动开启，无法进行此操作', 'La participation de la marchandise à l`activité de pointe est activée, cette opération ne peut pas être effectuée', 1),
(4382, 4, '400586', '商品参与砍价活动开启，无法进行此操作', 'La participation de la marchandise à la négociation est activée, cette opération ne peut pas être effectuée', 1),
(4383, 4, '400587', '商品参与拼团活动开启，无法进行此操作', 'La participation de la marchandise à l`activité de groupe est activée, cette opération ne peut pas être effectuée', 1),
(4384, 4, '400588', '会员价格不能为0', 'Le prix membre ne peut pas être 0', 1),
(4385, 4, '400589', '虚拟优惠券商品请选择优惠券', 'Veuillez sélectionner un coupon pour les produits de coupon virtuel', 1),
(4386, 4, '400590', '卡号：{:key}密码：{:value}，已经添加过，请重新添加卡密', 'Numéro de carte : {:key} Mot de passe : {:value}, il a été ajouté, veuillez ajouter à nouveau la clé de la carte', 1),
(4387, 4, '400591', '缺少城市id无法保存', 'Impossible d`enregistrer l`identifiant de ville manquant', 1),
(4388, 4, '400592', '修改的模板不存在', 'Le modèle modifié n`existe pas', 1),
(4389, 4, '400593', '指定区域邮费添加失败', 'Impossible d`ajouter l`affranchissement dans la zone spécifiée', 1),
(4390, 4, '400594', '管理员不存在', 'L`administrateur n`existe pas', 1),
(4391, 4, '400595', '您已被禁止登录', 'Vous avez été interdit de connexion', 1),
(4392, 4, '400596', '管理员账号已存在', 'Le compte administrateur existe déjà', 1),
(4393, 4, '400597', '原始密码错误', 'Erreur de mot de passe d`origine', 1),
(4394, 4, '400598', '请输入新密码', 'Veuillez entrer un nouveau mot de passe', 1),
(4395, 4, '400599', '请选择要删除的图片', 'Veuillez sélectionner une image à supprimer', 1),
(4396, 4, '400600', '移动失败或不能重复移动到同一分类下', 'Le déplacement a échoué ou ne peut pas être déplacé plusieurs fois dans la même catégorie', 1),
(4397, 4, '400601', '请求不被允许', 'Demande non autorisée', 1),
(4398, 4, '400602', '设置类目不被允许', 'La catégorie de réglage n`est pas autorisée', 1),
(4399, 4, '400603', '请输入正确格式的配置参数', 'Veuillez saisir les paramètres de configuration au format correct', 1),
(4400, 4, '400604', '{:name}请输入默认值', '{:name} veuillez entrer la valeur par défaut', 1),
(4401, 4, '400605', '{:name}请输入正确url', '{:name} veuillez entrer la bonne URL', 1),
(4402, 4, '400606', '保存wss证书失败', 'Impossible d`enregistrer le certificat wss', 1),
(4403, 4, '400607', '{:name}不能为空', '{:name} ne peut pas être vide', 1),
(4404, 4, '400608', '删除的云存储不存在', 'Le stockage cloud supprimé n`existe pas', 1),
(4405, 4, '400609', '云存储正在使用中,需要启动其他空间才能删除', 'Le stockage cloud est en cours d`utilisation, vous devez activer un autre espace à supprimer', 1),
(4406, 4, '400610', '云空间名称不能重复', 'Le nom de l`espace cloud ne peut pas être répété', 1),
(4407, 4, '400611', '没有权限', 'Aucune autorisation', 1),
(4408, 4, '400612', '替换失败,失败原因:{:msg}', 'Échec du remplacement, raison de l`échec : {:msg}', 1),
(4409, 4, '400613', '请先删除改菜单下的子菜单', 'Veuillez d`abord supprimer le sous-menu sous le menu', 1),
(4410, 4, '400614', '请填写批次名称', 'Veuillez renseigner le nom du lot', 1),
(4411, 4, '400615', '请填写要生成卡的数量', 'Veuillez renseigner le nombre de cartes à générer', 1),
(4412, 4, '400616', '卡片数量只能为正整数', 'Le nombre de cartes ne peut être qu`un entier positif', 1),
(4413, 4, '400617', '单次制卡数量最高不得超过6000张', 'Le nombre maximum de cartes créées à la fois ne doit pas dépasser 6000', 1),
(4414, 4, '400618', '请填写免费使用天数', 'Veuillez renseigner le nombre de jours d`utilisation gratuite', 1),
(4415, 4, '400619', '免费使用天数只能为正整数', 'Le nombre de jours d`utilisation gratuite ne peut être qu`un nombre entier positif', 1),
(4416, 4, '400620', '生成卡失败', 'Impossible de générer la carte', 1),
(4417, 4, '400621', '会员功能暂未开启', 'La fonction membre n`a pas encore été ouverte', 1),
(4418, 4, '400622', '请输入会员卡号', 'Veuillez entrer le numéro de carte de membre', 1),
(4419, 4, '400623', '请输入领取卡密', 'Veuillez entrer le mot de passe pour recevoir la carte', 1),
(4420, 4, '400624', '会员卡不存在', 'La carte de membre n`existe pas', 1),
(4421, 4, '400625', '会员卡未激活，暂无法使用', 'La carte de membre n`est pas activée et ne peut pas être utilisée temporairement', 1),
(4422, 4, '400626', '会员卡密码有误', 'Le mot de passe de la carte de membre est incorrect', 1),
(4423, 4, '400627', '会员卡已使用', 'La carte de membre a été utilisée', 1),
(4424, 4, '400628', '您已是永久会员，无需再领取，可以将此卡转送亲朋好友，一起享受优惠', 'Vous êtes déjà membre permanent, vous n`avez plus besoin de l`obtenir, vous pouvez transférer cette carte à vos proches et amis pour profiter ensemble de la réduction', 1),
(4425, 4, '400629', '暂无此类型会员卡', 'Il n`y a actuellement aucune carte de membre de ce type', 1),
(4426, 4, '400630', '会员权益类型缺失', 'Le type d`avantage d`adhésion est manquant', 1),
(4427, 4, '400631', '请设置权益名称', 'Veuillez définir le nom de l`équité', 1),
(4428, 4, '400632', '请上传会员权益图标', 'Veuillez télécharger l`icône des droits des membres', 1),
(4429, 4, '400633', '请设置返还积分倍数', 'Veuillez définir le multiple du point de retour', 1),
(4430, 4, '400634', '返还积分倍数不能为负数', 'Le multiple du point de retour ne peut pas être négatif', 1),
(4431, 4, '400635', '请设置运费折扣', 'Veuillez définir la remise sur les frais d`expédition', 1),
(4432, 4, '400636', '运费折扣不能为负数', 'La remise sur les frais de port ne peut pas être négative', 1),
(4433, 4, '400637', '请设置签到积分倍数', 'Veuillez définir le multiplicateur du point d`enregistrement', 1),
(4434, 4, '400638', '签到积分倍数不能为负数', 'Le multiple du point de connexion ne peut pas être négatif', 1),
(4435, 4, '400639', '请设置线下付款折扣', 'Veuillez définir un escompte pour paiement hors ligne', 1),
(4436, 4, '400640', '线下付款不能为负数', 'Le paiement hors ligne ne peut pas être négatif', 1),
(4437, 4, '400641', '请填写会员卡名称', 'Veuillez renseigner le nom de la carte de membre', 1),
(4438, 4, '400642', '会员卡类型缺失', 'Type de carte de membre manquant', 1),
(4439, 4, '400643', '请填写有效期（天）', 'Veuillez renseigner la période de validité (jours)', 1),
(4440, 4, '400644', '有效期（天）不能为负数', 'La période de validité (jours) ne peut pas être négative', 1),
(4441, 4, '400645', '请填写价格', 'Veuillez renseigner le prix', 1),
(4442, 4, '400646', '价格不能为负数', 'Le prix ne peut pas être négatif', 1),
(4443, 4, '400647', '优惠价不能大于原价', 'Le prix réduit ne peut pas être supérieur au prix d`origine', 1),
(4444, 4, '400648', '地址不存在', 'L`adresse n`existe pas', 1),
(4445, 4, '400649', '取消原来默认地址失败', 'L`annulation de l`adresse par défaut d`origine a échoué', 1),
(4446, 4, '400650', '设置默认地址失败', 'Impossible de définir l`adresse par défaut', 1),
(4447, 4, '400651', '地址已存在', 'L`adresse existe déjà', 1),
(4448, 4, '400652', '收货地址格式错误', 'Le format de l`adresse de livraison est incorrect', 1),
(4449, 4, '400653', '请登录', 'Veuillez vous connecter', 1),
(4450, 4, '400654', '登录已过期,请重新登录', 'La connexion a expiré, veuillez vous reconnecter', 1),
(4451, 4, '400655', '增加记录失败', 'Échec de l`ajout de l`enregistrement', 1),
(4452, 4, '400656', '记录分享记录失败', 'Échec du partage d`enregistrement', 1),
(4453, 4, '400657', '增加用户佣金失败', 'Impossible d`augmenter la commission utilisateur', 1),
(4454, 4, '400658', '企业付款到零钱失败，请稍后再试', 'L`entreprise n`a pas payé la monnaie, veuillez réessayer plus tard', 1),
(4455, 4, '400659', '已经提现', 'Retiré', 1),
(4456, 4, '400660', '您的提现申请已被拒绝', 'Votre demande de retrait a été rejetée', 1),
(4457, 4, '400661', '可提现佣金不足', 'Commission insuffisante pour retirer', 1),
(4458, 4, '400662', '提现金额不能小于{:money}元', 'Le montant du retrait ne peut pas être inférieur à {:money} yuan', 1),
(4459, 4, '400663', '提现佣金不足{:money}元', 'La commission de retrait n`est pas assez {:money} yuan', 1),
(4460, 4, '400664', '提现佣金大于0', 'La commission de retrait est supérieure à 0', 1),
(4461, 4, '400665', '企业微信付款到零钱最低金额为1元', 'Le montant minimum de monnaie à payer par l`entreprise WeChat est de 1 yuan', 1),
(4462, 4, '400666', '该分组已经存在', 'Le groupe existe déjà', 1),
(4463, 4, '400667', '清空用户标签失败', 'Échec de la suppression de l`onglet utilisateur', 1),
(4464, 4, '400668', '设置标签失败', 'Impossible de définir l`étiquette', 1),
(4465, 4, '400669', '请选择标签分类', 'Veuillez sélectionner une catégorie de libellé', 1),
(4466, 4, '400670', '该标签已经存在', 'Le libellé existe déjà', 1),
(4467, 4, '400671', '修改用户等级信息失败', 'Impossible de modifier les informations de niveau utilisateur', 1),
(4468, 4, '400672', '用户等级不存在', 'Le niveau utilisateur n`existe pas', 1),
(4469, 4, '400673', '用户等级经验必须大于上一等级设置的经验', 'L`expérience du niveau utilisateur doit être supérieure à l`expérience définie par le niveau précédent', 1),
(4470, 4, '400674', '用户等级经验必须小于下一等级设置的经验', 'L`expérience du niveau utilisateur doit être inférieure à l`expérience définie par le niveau suivant', 1),
(4471, 4, '400675', '已检测到您设置过的用户等级，此等级不可重复', 'Le niveau utilisateur que vous avez défini a été détecté, ce niveau ne peut pas être répété', 1),
(4472, 4, '400676', '已检测到您设置过该用户等级经验值，经验值不可重复', 'Il a été détecté que vous avez défini la valeur d`expérience de ce niveau d`utilisateur, la valeur d`expérience ne peut pas être répétée', 1),
(4473, 4, '400677', '订单未支付', 'Commande non payée', 1),
(4474, 4, '400678', '佣金转入余额，不能退款', 'La commission est transférée sur le solde et ne peut être remboursée', 1),
(4475, 4, '400679', '已支付的订单记录无法删除', 'L`enregistrement de la commande payée ne peut pas être supprimé', 1),
(4476, 4, '400680', '转入金额不能大于可提现佣金', 'Le montant du transfert ne peut être supérieur à la commission pouvant être retirée', 1),
(4477, 4, '400681', '写入余额充值失败', 'Échec de l`écriture de la recharge du solde', 1),
(4478, 4, '400682', '您选择的充值方式已下架', 'La méthode de recharge que vous avez sélectionnée a été interrompue', 1),
(4479, 4, '400683', '充值订单生成失败', 'Impossible de générer la commande de recharge', 1),
(4480, 4, '400684', '保存用户信息失败', 'Échec de l`enregistrement des informations utilisateur', 1),
(4481, 4, '400685', '密码重置失败', 'La réinitialisation du mot de passe a échoué', 1),
(4482, 4, '400686', '增加推广人数失败', 'Impossible d`augmenter le nombre de promotions', 1),
(4483, 4, '400687', '设置登录类型失败', 'Impossible de définir le type de connexion', 1),
(4484, 4, '400688', '设置推广员失败', 'Impossible de définir le promoteur', 1),
(4485, 4, '400689', '增加用户余额失败', 'Impossible d`augmenter le solde de l`utilisateur', 1),
(4486, 4, '400690', '减少用户余额失败', 'Impossible de réduire le solde de l`utilisateur', 1),
(4487, 4, '400691', '减少用户佣金失败', 'Impossible de réduire la commission utilisateur', 1),
(4488, 4, '400692', '增加用户积分失败', 'Échec de l`augmentation des points utilisateur', 1),
(4489, 4, '400693', '减少用户积分失败', 'Échec de la réduction des points utilisateur', 1),
(4490, 4, '400694', '增加用户经验失败', 'Échec de l`amélioration de l`expérience utilisateur', 1),
(4491, 4, '400695', '减少用户经验失败', 'Impossible de réduire l`expérience utilisateur', 1),
(4492, 4, '400696', '该分组不存在', 'Le groupe n`existe pas', 1),
(4493, 4, '400697', '设置分组失败或无改动', 'Échec de la définition du regroupement ou pas de changement', 1),
(4494, 4, '400698', '有标签不存在或被删除', 'Une étiquette n`existe pas ou a été supprimée', 1),
(4495, 4, '400699', '等级不存在或被删除', 'La classe n`existe pas ou a été supprimée', 1),
(4496, 4, '400700', '此用户已有该用户等级，无法再次赠送', 'Cet utilisateur a déjà ce niveau d`utilisateur et ne peut pas le redonner', 1),
(4497, 4, '400701', '赠送天数不能为0', 'Les jours cadeaux ne peuvent pas être 0', 1),
(4498, 4, '400702', '天数输入错误', 'Nombre de jours entré erroné', 1),
(4499, 4, '400703', '用户信息储存失败', 'Échec de l`enregistrement des informations utilisateur', 1),
(4500, 4, '400704', '您得ip不再白名单中,请前往腾讯微信公众平台添加ip白名单', 'Votre IP n`est plus dans la liste blanche, veuillez vous rendre sur la plateforme publique Tencent WeChat pour ajouter l`IP à la liste blanche', 1),
(4501, 4, '400705', '您填写得appid无效,请检查', 'L`appid que vous avez renseigné n`est pas valide, veuillez vérifier', 1),
(4502, 4, '400706', '请输入回复信息内容', 'Veuillez saisir le contenu du message de réponse', 1),
(4503, 4, '400707', '请上传回复的图片', 'Veuillez télécharger l`image de réponse', 1),
(4504, 4, '400708', '请上传回复的声音', 'Veuillez télécharger la réponse vocale', 1),
(4505, 4, '400709', '请选择图文消息', 'Veuillez sélectionner un SMS', 1),
(4506, 4, '400710', '对应的uid不存在', 'L`uid correspondant n`existe pas', 1),
(4507, 4, '400711', '取消关注失败', 'Le désabonnement a échoué', 1),
(4508, 4, '400712', '电子面单模板ID缺失', 'L`identifiant du modèle de bordereau de visage électronique est manquant', 1),
(4509, 4, '400713', '快递公司编码缺失', 'Le code de l`entreprise de messagerie est manquant', 1),
(4510, 4, '400714', '寄件人信息缺失', 'Informations sur l`expéditeur manquantes', 1),
(4511, 4, '400715', '收件人信息缺失', 'Les informations du destinataire sont manquantes', 1),
(4512, 4, '400716', '云打印机编号缺失', 'Numéro d`imprimante Cloud manquant', 1),
(4513, 4, '400717', '商品数量缺失', 'La quantité d`articles est manquante', 1),
(4514, 4, '400718', '获取access_token获取失败', 'Impossible d`obtenir le jeton d`accès', 1),
(4515, 4, '400719', '手机号不能为空', 'Le numéro de téléphone mobile ne peut pas être vide', 1),
(4516, 4, '400720', '模版ID不存在', 'L`ID de modèle n`existe pas', 1),
(4517, 4, '400721', '请先配置accessKey和secretKey', 'Veuillez d`abord configurer accessKey et secretKey', 1),
(4518, 4, '400722', '请先配置水印图片', 'Veuillez d`abord configurer l`image du filigrane', 1),
(4519, 4, '400723', '请先配置水印文字', 'Veuillez d`abord configurer le texte du filigrane', 1),
(4520, 4, '400724', '远程水印图片下载失败', 'Impossible de télécharger l`image du filigrane distant', 1),
(4521, 4, '400725', '上传图片不存在', 'L`image téléchargée n`existe pas', 1),
(4522, 4, '400726', '图片流获取失败', 'Impossible d`obtenir le flux d`images', 1),
(4523, 4, '400727', '图片下载失败', 'Le téléchargement de l`image a échoué', 1),
(4524, 4, '400728', '必须上传xlsx格式文件', 'Doit télécharger un fichier au format xlsx', 1),
(4525, 4, '400729', '数据不能为空', 'Les données ne peuvent pas être vides', 1),
(4526, 4, '400730', '缺少pay_price', 'Paiement_prix manquant', 1),
(4527, 4, '400731', '退款失败:{:msg}', 'Échec du remboursement : {:msg}', 1),
(4528, 4, '400732', '获取微信粉丝信息失败', 'Impossible d`obtenir les informations sur les fans de WeChat', 1),
(4529, 4, '400733', '您已关闭上传功能', 'Vous avez désactivé le téléchargement', 1),
(4530, 4, '400734', '文件不可写', 'Le fichier n`est pas accessible en écriture', 1),
(4531, 4, '400735', '时间格式不正确', 'Format d`heure incorrect', 1),
(4532, 4, '400736', '文件可能损坏，请检查', 'Le fichier est peut-être corrompu, veuillez vérifier', 1),
(4533, 4, '400737', '修复错误，请重试', 'Corrigez l`erreur, veuillez réessayer', 1),
(4534, 4, '400738', '请指定要修复的表', 'Veuillez préciser la table à réparer', 1),
(4535, 4, '400739', '请配置支付证书', 'Veuillez configurer le certificat de paiement', 1),
(4536, 4, '400740', '只支持两级分类', 'Supporte uniquement la classification à deux niveaux', 1),
(4537, 4, '400741', '运费格式错误', 'Erreur de format d`expédition', 1),
(4538, 4, '400742', '请检查属性编码或库存数量', 'Veuillez vérifier le code d`attribut ou la quantité de stock', 1),
(4539, 4, '400743', '同步条数不能超过100', 'Le nombre de barres de synchronisation ne peut pas dépasser 100', 1),
(4540, 4, '400744', 'appid或appsecret错误', 'erreur appid ou appsecret', 1),
(4541, 4, '400745', '父级ID参数类型错误', 'Le type de paramètre ID parent est incorrect', 1),
(4542, 4, '400746', '分类名称长度不能超过25个字符', 'La longueur du nom de catégorie ne peut pas dépasser 25 caractères', 1),
(4543, 4, '400747', '分类图标长度不能超过128个字符', 'La longueur de l`icône de catégorie ne peut pas dépasser 128 caractères', 1),
(4544, 4, '400748', '分类大图长度不能超过200个字符', 'La longueur de la grande image de classement ne peut pas dépasser 200 caractères', 1),
(4545, 4, '400749', '排序参数类型错误', 'Type de paramètre de tri incorrect', 1),
(4546, 4, '400750', '排序不能小于0', 'Le tri ne peut pas être inférieur à 0', 1),
(4547, 4, '400751', '状态必须是0-1之间的整数', 'Le statut doit être un entier compris entre 0 et 1', 1),
(4548, 4, '400752', '权益简介不能大于8个字', 'L`introduction de l`avantage ne peut pas dépasser 8 mots', 1),
(4549, 4, '400753', '提现方式最少选一种', 'Choisissez au moins une méthode de retrait', 1),
(4550, 4, '400754', '身份使用中，无法删除', 'L`identité est en cours d`utilisation et ne peut pas être supprimée', 1),
(4551, 4, '400755', '展示名称不能大于6个字', 'Le nom d`affichage ne peut pas dépasser 6 caractères', 1),
(4552, 4, '400756', '推广佣金单价不能小于0', 'Le prix unitaire de la commission de promotion ne peut être inférieur à 0', 1),
(4553, 4, '400757', '每日推广佣金上限不能小于-1', 'La limite de commission de promotion quotidienne ne peut pas être inférieure à -1', 1),
(4554, 4, '400758', '请核对领取方式', 'Veuillez vérifier la méthode de collecte', 1),
(4555, 4, '400759', '请输入优惠券名称', 'Veuillez saisir le nom du coupon', 1),
(4556, 4, '400760', '请输入真实姓名', 'Veuillez entrer votre vrai nom', 1),
(4557, 4, '400761', '描述内容不能超过120字', 'La description ne peut excéder 120 caractères', 1),
(4558, 4, '400762', '账号密码必须是在6到32位之间', 'Le mot de passe du compte doit comporter entre 6 et 32 ​​caractères', 1),
(4559, 4, '400763', '商户号不能为空', 'Le numéro de commerçant ne peut pas être vide', 1),
(4560, 4, '410000', '请输入账号和密码', 'Veuillez saisir un compte et un mot de passe', 1),
(4561, 4, '410001', '登录成功', 'Connexion réussie', 1),
(4562, 4, '410002', '退出成功', 'Quitter avec succès', 1),
(4563, 4, '410003', '发送验证码失败,请刷新页面重新获取', 'Échec de l`envoi du code de vérification, veuillez actualiser la page pour le récupérer', 1),
(4564, 4, '410004', '请输入验证码', 'Veuillez entrer le code de vérification', 1),
(4565, 4, '410005', '验证码输入有误', 'Le code de vérification est mal saisi', 1),
(4566, 4, '410006', '验证码已发送', 'Le code de vérification a été envoyé', 1),
(4567, 4, '410007', '验证码发送成功', 'Code de vérification envoyé avec succès', 1),
(4568, 4, '410008', '验证码发送失败', 'Échec de l`envoi du code de vérification', 1),
(4569, 4, '410009', '请先获取验证码', 'Veuillez d`abord obtenir le code de vérification', 1),
(4570, 4, '410010', '验证码错误', 'Erreur de code de vérification', 1),
(4571, 4, '410011', '密码必须是在6到16位之间', 'Le mot de passe doit comporter entre 6 et 16 chiffres', 1),
(4572, 4, '410012', '密码太过简单，请输入较为复杂的密码', 'Le mot de passe est trop simple, veuillez saisir un mot de passe plus complexe', 1),
(4573, 4, '410013', '注册成功', 'Enregistrement réussi', 1),
(4574, 4, '410014', '注册失败', 'L`enregistrement a échoué', 1),
(4575, 4, '410015', '请输入手机号', 'Veuillez entrer votre numéro de téléphone', 1),
(4576, 4, '410016', '绑定成功', 'Liaison réussie', 1),
(4577, 4, '410017', '绑定失败', 'La liaison a échoué', 1),
(4578, 4, '410018', '手机号格式不正确', 'Le format du numéro de téléphone est incorrect', 1),
(4579, 4, '410019', '登录失败', 'Échec de la connexion', 1),
(4580, 4, '410020', '扫码失败请重新扫描', 'Le scan du code a échoué, veuillez le scanner à nouveau', 1),
(4581, 4, '410021', '二维码已过期请重新扫描', 'Le code QR a expiré, veuillez scanner à nouveau', 1),
(4582, 4, '410022', '授权成功，请绑定手机号', 'L`autorisation est réussie, veuillez lier le numéro de téléphone', 1),
(4583, 4, '410023', '授权成功', 'Autorisation réussie', 1),
(4584, 4, '410024', '请先关注公众号', 'Veuillez d`abord prêter attention au compte officiel', 1),
(4585, 4, '410025', '账号或密码错误', 'Compte ou mot de passe incorrect', 1),
(4586, 4, '410026', '请修改您的初始密码，再尝试登录', 'Veuillez modifier votre mot de passe initial et réessayez de vous connecter', 1),
(4587, 4, '410027', '您已被禁止登录，请联系管理员', 'Vous avez été interdit de connexion, veuillez contacter l`administrateur', 1),
(4588, 4, '410028', '手机号已注册', 'Le numéro de téléphone a été enregistré', 1),
(4589, 4, '410029', '您今日发送得短信次数已经达到上限', 'Le nombre de SMS que vous avez envoyés aujourd`hui a atteint la limite supérieure', 1),
(4590, 4, '410030', '此IP今日发送次数已经达到上限', 'Le nombre de fois que cette IP a été envoyée aujourd`hui a atteint la limite supérieure', 1),
(4591, 4, '410031', '短信平台验证码发送失败', 'Échec de l`envoi du code de vérification de la plate-forme SMS', 1),
(4592, 4, '410032', '用户不存在', 'L`utilisateur n`existe pas', 1),
(4593, 4, '410033', '修改密码失败', 'Échec du changement de mot de passe', 1),
(4594, 4, '410034', '用户登录失败,无法生成新用户,请稍后再试', 'La connexion de l`utilisateur a échoué, impossible de générer un nouvel utilisateur, veuillez réessayer plus tard', 1),
(4595, 4, '410035', '用户不存在,无法切换', 'L`utilisateur n`existe pas et ne peut pas être changé', 1),
(4596, 4, '410036', '修改新用户登录类型出错', 'Erreur lors de la modification du nouveau type de connexion utilisateur', 1),
(4597, 4, '410037', '请刷新页面或者重新授权', 'Veuillez actualiser la page ou ré-autoriser', 1),
(4598, 4, '410038', '获取用户访问token失败', 'Impossible d`obtenir le jeton d`accès utilisateur', 1),
(4599, 4, '410039', '此手机已经绑定，无法多次绑定', 'Ce téléphone est déjà lié et ne peut pas être lié plusieurs fois', 1),
(4600, 4, '410040', '您的账号已经绑定过手机号码', 'Votre compte a été lié à un numéro de téléphone portable', 1),
(4601, 4, '410041', 'H5已有账号是否绑定此账号上', 'Si le compte existant de H5 est lié à ce compte', 1),
(4602, 4, '410042', '新手机号和原手机号相同，无需修改', 'Le nouveau numéro de téléphone est le même que le numéro de téléphone d`origine, pas besoin de le modifier', 1),
(4603, 4, '410043', '此手机已经注册', 'Ce téléphone est déjà enregistré', 1),
(4604, 4, '410044', '用户信息获取失败', 'Impossible d`obtenir les informations utilisateur', 1),
(4605, 4, '410045', '请选择收货地址', 'Veuillez sélectionner l`adresse de livraison', 1),
(4606, 4, '410046', '地址选择有误', 'Sélection d`adresse incorrecte', 1),
(4607, 4, '410047', '可用积分不足', 'Points disponibles insuffisants', 1),
(4608, 4, '410048', '奖品不存在', 'Le prix n`existe pas', 1),
(4609, 4, '410049', '写入中奖记录失败', 'Impossible d`écrire l`enregistrement gagnant', 1),
(4610, 4, '410050', '请继续参与活动抽奖', 'Veuillez continuer à participer au tirage au sort', 1),
(4611, 4, '410051', '已经领取成功', 'Reçu avec succès', 1),
(4612, 4, '410052', '请输入收货人信息', 'Veuillez entrer les informations du destinataire', 1),
(4613, 4, '410053', '请输入正确的收货人电话', 'Veuillez saisir le numéro de téléphone correct du destinataire', 1),
(4614, 4, '410054', '抽奖记录不存在', 'L`enregistrement de la loterie n`existe pas', 1),
(4615, 4, '410055', '该奖品不需要发货', 'Ce prix n`a pas besoin d`être expédié', 1),
(4616, 4, '410056', '请选择快递公司或输入快递单号', 'Veuillez sélectionner une entreprise de messagerie ou entrer un numéro de messagerie', 1),
(4617, 4, '410057', '活动不存在或已删除', 'L`activité n`existe pas ou a été supprimée', 1),
(4618, 4, '410058', '暂未有该类型活动', 'Il n`y a pas encore d`activité de ce type', 1),
(4619, 4, '410059', '您暂时无法参与该活动', 'Vous ne pouvez temporairement pas participer à cet événement', 1),
(4620, 4, '410060', '活动状态有误，请联系管理员', 'Le statut de l`activité est incorrect, veuillez contacter l`administrateur', 1),
(4621, 4, '410061', '可用积分不足，没有更多抽奖次数', 'Points disponibles insuffisants, plus de tirages', 1),
(4622, 4, '410062', '余额不足，没有更多抽奖次数', 'Solde insuffisant, plus de tirages', 1),
(4623, 4, '410063', '购买商品之后获得更多抽奖次数', 'Obtenez plus de tirages au sort après avoir acheté des objets', 1),
(4624, 4, '410064', '订单完成评价之后获得更多抽奖次数', 'Obtenez plus de tirages de loterie après l`évaluation de la commande', 1),
(4625, 4, '410065', '邀请更多好友获取抽奖次数', 'Invitez plus d`amis pour obtenir le nombre de tirages au sort', 1),
(4626, 4, '410066', '抽奖扣除用户积分失败', 'Le tirage au sort n`a pas réussi à déduire les points utilisateur', 1),
(4627, 4, '410067', '抽奖失败，余额不足', 'Échec du tirage au sort, solde insuffisant', 1),
(4628, 4, '410068', '抽奖扣除用户余额失败', 'Le tirage au sort n`a pas réussi à déduire le solde de l`utilisateur', 1),
(4629, 4, '410069', '抽奖扣除用户推广获取抽奖次数失败', 'Impossible de déduire le nombre de tirages de loterie de la promotion utilisateur', 1),
(4630, 4, '410070', '抽奖减少奖品总数失败', 'Le tirage au sort pour réduire le nombre total de prix a échoué', 1),
(4631, 4, '410071', '分销等级不存在', 'Le niveau de distribution n`existe pas', 1),
(4632, 4, '410072', '永久二维码获取错误', 'Erreur lors de l`obtention du code QR permanent', 1),
(4633, 4, '410073', '邀请码无效', 'Le code d`invitation est invalide', 1),
(4634, 4, '410074', '授权失败,参数有误', 'L`autorisation a échoué, le paramètre est erroné', 1),
(4635, 4, '410075', 'openid获取失败', 'Impossible d`obtenir l`openid', 1),
(4636, 4, '410076', '获取session_key失败，请检查您的配置', 'Impossible d`obtenir la session_key, veuillez vérifier votre configuration', 1),
(4637, 4, '410077', '获取会话密匙失败', 'Impossible d`obtenir la clé de session', 1),
(4638, 4, '410078', '静默授权失败', 'L`autorisation silencieuse a échoué', 1),
(4639, 4, '410079', '获取用户信息失败', 'Impossible d`obtenir les informations sur l`utilisateur', 1),
(4640, 4, '410080', '更新信息失败', 'La mise à jour des informations a échoué', 1),
(4641, 4, '410081', '请上传二维码', 'Veuillez télécharger le code QR', 1),
(4642, 4, '410082', '请关注公众号', 'Veuillez faire attention au numéro public', 1),
(4643, 4, '410083', '新增用户失败', 'Échec de l`ajout d`utilisateur', 1),
(4644, 4, '410084', '用户关注失败', 'Impossible de suivre l`utilisateur', 1),
(4645, 4, '410085', '获取token失败{:msg}', 'Impossible d`obtenir le jeton {:msg}', 1),
(4646, 4, '410086', '配置已更改或token已失效', 'La configuration a été modifiée ou le jeton a expiré', 1),
(4647, 4, '410087', '平台错误：发生异常，请稍后重试', 'Erreur de plateforme : Une exception s`est produite, veuillez réessayer plus tard', 1),
(4648, 4, '410088', '企业微信支付到零钱需要支付证书，检测到您没有上传', 'Le paiement Enterprise WeChat pour changer a besoin d`un certificat de paiement, il est détecté que vous n`avez pas téléchargé', 1),
(4649, 4, '410089', '发起企业支付到零钱失败', 'Échec de l`initiation de l`entreprise au paiement de la monnaie', 1),
(4650, 4, '410090', '无效的token不能查找到用户聊天记录', 'Le jeton invalide ne peut pas trouver l`historique de chat de l`utilisateur', 1),
(4651, 4, '410091', '图片上传成功', 'Téléchargement de l`image réussi', 1),
(4652, 4, '410092', '用户uid不再当前聊天用户范围内', 'L`uid de l`utilisateur n`est plus dans la plage d`utilisateurs actuelle du chat', 1),
(4653, 4, '410093', '请输入订单价格', 'Veuillez entrer le prix de la commande', 1),
(4654, 4, '410094', '请去后台售后订单列表处理', 'Veuillez vous rendre dans les coulisses du traitement de la liste des commandes après-vente', 1),
(4655, 4, '410095', '分类名称不能为空', 'Le nom de la catégorie ne peut pas être vide', 1),
(4656, 4, '410096', '分类不存在', 'Le classement n`existe pas', 1),
(4657, 4, '410097', '添加的内容重复', 'Dupliquer le contenu ajouté', 1),
(4658, 4, '410098', '缺少转接人id', 'Identifiant de transfert manquant', 1),
(4659, 4, '410099', '转接成功', 'Transfert réussi', 1),
(4660, 4, '410100', '话术没有被查到', 'Mots introuvables', 1),
(4661, 4, '410101', '公共话术不能修改', 'La langue publique ne peut pas être modifiée', 1),
(4662, 4, '410102', '话术标题内容不能为空', 'Le contenu du titre ne peut pas être vide', 1),
(4663, 4, '410103', '已拥有此分组', 'Possède déjà ce groupe', 1),
(4664, 4, '410104', '缺少标签id', 'Identifiant de balise manquant', 1),
(4665, 4, '410105', '请填汉字字母或者数字', 'Veuillez saisir des lettres ou des chiffres chinois', 1),
(4666, 4, '410106', '标题长度不能超过50个字', 'La longueur du titre ne peut pas dépasser 50 caractères', 1),
(4667, 4, '410107', '请选择分类', 'Veuillez sélectionner une catégorie', 1),
(4668, 4, '410108', '分类必须为数字', 'Les catégories doivent être des nombres', 1),
(4669, 4, '410109', '请填写话术内容', 'Veuillez renseigner le contenu des mots', 1),
(4670, 4, '410110', '话术长度不能超过500个字', 'La longueur du mot ne peut pas dépasser 500 caractères', 1),
(4671, 4, '410111', '排序必须为数字', 'Le tri doit être numérique', 1),
(4672, 4, '410112', '微信最低提现金额不能小于1元', 'Le montant minimum de retrait Wechat ne peut pas être inférieur à 1 yuan', 1),
(4673, 4, '410113', '用户不存在', 'L`utilisateur n`existe pas', 1),
(4674, 4, '410114', '提现方式不存在', 'La méthode de retrait n`existe pas', 1),
(4675, 4, '410115', '提现金额输入有误', 'Le montant du retrait est mal renseigné', 1),
(4676, 4, '410116', '银行卡号输入有误', 'Le numéro de carte bancaire a été mal renseigné', 1),
(4677, 4, '410117', '请输入支付宝账号', 'Veuillez entrer le numéro de compte Alipay', 1),
(4678, 4, '410118', '请输入银行卡账号', 'Veuillez saisir le numéro de compte de la carte bancaire', 1),
(4679, 4, '410119', '请输入开户行信息', 'Veuillez entrer les informations bancaires', 1),
(4680, 4, '410120', '申请提现成功', 'Demande de retrait réussie', 1),
(4681, 4, '410121', '申请提现失败', 'Échec de la demande de retrait', 1),
(4682, 4, '410122', '充值金额不能为0元', 'Le montant de la recharge ne peut pas être de 0 yuan', 1),
(4683, 4, '410123', '充值方式不支持', 'La méthode de recharge n`est pas supportée', 1),
(4684, 4, '410124', '充值金额不能低于{:money}', 'Le montant de la recharge ne peut pas être inférieur à {:money}', 1),
(4685, 4, '410125', '充值成功', 'Recharge réussie', 1),
(4686, 4, '410126', '充值失败', 'Echec de la recharge', 1),
(4687, 4, '410127', '签到获得{:integral}积分', 'Connectez-vous pour obtenir {:integral} points', 1),
(4688, 4, '410128', '签到失败', 'Échec de la connexion', 1),
(4689, 4, '410129', '收藏成功', 'Collecte réussie', 1),
(4690, 4, '410130', '收藏失败', 'Échec de la collecte', 1),
(4691, 4, '410131', '授权失败', 'L`autorisation a échoué', 1),
(4692, 4, '410132', 'unionid不存在', 'unionid n`existe pas', 1),
(4693, 4, '410133', '获取用户UID失败', 'Impossible d`obtenir l`UID de l`utilisateur', 1),
(4694, 4, '410134', '请输入昵称或者选择头像', 'Veuillez entrer un pseudonyme ou sélectionner un avatar', 1),
(4695, 4, '410135', '注销成功', 'Déconnexion réussie', 1),
(4696, 4, '410136', '暂无客服人员在线，请稍后联系', 'Il n`y a pas de service client en ligne, veuillez nous contacter plus tard', 1),
(4697, 4, '410137', '不能和自己聊天', 'Je ne peux pas discuter avec moi-même', 1),
(4698, 4, '410138', '您不是客服无法登录', 'Vous n`êtes pas un service client et ne pouvez pas vous connecter', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(4699, 4, '410139', '自己不能转接给自己', 'Je ne peux pas me transférer', 1),
(4700, 4, '410140', '转接客服失败', 'Échec du transfert du service client', 1),
(4701, 4, '410141', '没有此用户', 'Aucun tel utilisateur', 1),
(4702, 4, '410142', '客服不存在', 'Le service client n`existe pas', 1),
(4703, 4, '410143', '商品未查到', 'Article introuvable', 1),
(4704, 4, '410144', '请填写开票手机号', 'Veuillez renseigner le numéro de téléphone de facturation', 1),
(4705, 4, '410145', '请填写发票抬头（开具发票企业名称）', 'Veuillez renseigner l`en-tête de la facture (nom de la société émettrice de la facture)', 1),
(4706, 4, '410146', '请填写正确的发票抬头（开具发票企业名称）', 'Veuillez renseigner le bon en-tête de facture (nom de la société émettrice de la facture)', 1),
(4707, 4, '410147', '请填写发票税号', 'Veuillez renseigner le numéro fiscal de la facture', 1),
(4708, 4, '410148', '请填写正确的发票税号', 'Veuillez renseigner le bon numéro fiscal de facture', 1),
(4709, 4, '410149', '请填写正确的银行卡号', 'Veuillez renseigner le bon numéro de carte bancaire', 1),
(4710, 4, '410150', '地址不存在', 'L`adresse n`existe pas', 1),
(4711, 4, '410151', '收货地址格式错误', 'Le format de l`adresse de livraison est incorrect', 1),
(4712, 4, '410152', '收货地址格式错误或系统未完善当前地址', 'Le format de l`adresse de livraison est incorrect ou le système ne complète pas l`adresse actuelle', 1),
(4713, 4, '410153', '收货地址格式错误，请重新选择', 'Le format de l`adresse de livraison est incorrect, veuillez sélectionner à nouveau', 1),
(4714, 4, '410154', '请填写详细地址', 'Veuillez renseigner l`adresse détaillée', 1),
(4715, 4, '410155', '名称必须填写', 'Le nom doit être renseigné', 1),
(4716, 4, '410156', '名称最多不能超过25个字符', 'Le nom ne peut pas dépasser 25 caractères', 1),
(4717, 4, '410157', '手机号必须填写', 'Le numéro de téléphone portable doit être renseigné', 1),
(4718, 4, '410158', '手机号格式错误', 'Erreur de format de numéro de téléphone portable', 1),
(4719, 4, '410159', '省必须填写', 'La province doit être renseignée', 1),
(4720, 4, '410160', '市必须填写', 'La ville doit être renseignée', 1),
(4721, 4, '410161', '区/县必须填写', 'District/Comté doit être rempli', 1),
(4722, 4, '410162', '详细地址必须填写', 'L`adresse détaillée doit être renseignée', 1),
(4723, 4, '410163', '请填写反馈内容', 'Veuillez remplir le contenu du commentaire', 1),
(4724, 4, '410164', '比例不能大于您的比例', 'Le ratio ne peut pas être supérieur à votre ratio', 1),
(4725, 4, '410165', '激活成功', 'Activation réussie', 1),
(4726, 4, '410166', '暂无海报', 'Pas encore d`affiches', 1),
(4727, 4, '410167', '二维码生成失败', 'Impossible de générer le code QR', 1),
(4728, 4, '410168', '缺少字体文件Bold', 'Fichier de police manquant Gras', 1),
(4729, 4, '410169', '缺少字体文件Normal', 'Fichier de police manquant Normal', 1),
(4730, 4, '410170', '生成图片失败', 'Impossible de générer l`image', 1),
(4731, 4, '410171', '生成图片时，系统错误', 'Une erreur système s`est produite lors de la génération de l`image', 1),
(4732, 4, '410172', '生成海报失败', 'Impossible de générer l`affiche', 1),
(4733, 4, '410173', '订单不存在', 'La commande n`existe pas', 1),
(4734, 4, '410174', '订单已支付', 'Commande payée', 1),
(4735, 4, '410175', '请填写实际支付金额', 'Veuillez renseigner le montant réel du paiement', 1),
(4736, 4, '410176', '实际支付金额不能小于0元', 'Le montant réel du paiement ne peut pas être inférieur à 0 yuan', 1),
(4737, 4, '410177', '请填写备注内容', 'Veuillez remplir les remarques', 1),
(4738, 4, '410178', '请先处理售后申请', 'Veuillez d`abord traiter la demande SAV', 1),
(4739, 4, '410179', '用户已取消申请', 'L`utilisateur a annulé l`application', 1),
(4740, 4, '410180', '售后订单状态不支持该操作', 'Le statut de la commande SAV ne supporte pas cette opération', 1),
(4741, 4, '410181', '退款修改状态错误', 'Erreur de statut de modification de remboursement', 1),
(4742, 4, '410182', '修改退款状态成功', 'Modifier le statut du remboursement avec succès', 1),
(4743, 4, '410183', '已退完支付金额，不能再退款了', 'Le montant du paiement a été remboursé, plus de remboursement', 1),
(4744, 4, '410184', '请输入退款金额', 'Veuillez saisir le montant du remboursement', 1),
(4745, 4, '410185', '退款金额大于支付金额，请修改退款金额', 'Le montant du remboursement est supérieur au montant du paiement, veuillez modifier le montant du remboursement', 1),
(4746, 4, '410186', '退款成功', 'Remboursement réussi', 1),
(4747, 4, '410187', '退款失败', 'Remboursement échoué', 1),
(4748, 4, '410188', '请输入核销码或者扫描核销二维码', 'Veuillez saisir le code d`annulation ou scanner le code QR d`annulation', 1),
(4749, 4, '410189', '核销成功', 'Radiation réussie', 1),
(4750, 4, '410190', '请输入付款金额', 'Veuillez entrer le montant du paiement', 1),
(4751, 4, '410191', '支付金额不能为0元', 'Le montant du paiement ne peut pas être de 0 yuan', 1),
(4752, 4, '410192', '付费会员功能暂未开启', 'La fonction d`abonnement payant n`a pas encore été ouverte', 1),
(4753, 4, '410193', '支付数据生成失败', 'Impossible de générer les données de paiement', 1),
(4754, 4, '410194', '支付订单不存在', 'L`ordre de paiement n`existe pas', 1),
(4755, 4, '410195', '微信支付成功', 'Paiement WeChat réussi', 1),
(4756, 4, '410196', '前往支付', 'Aller au paiement', 1),
(4757, 4, '410197', '余额支付成功', 'Paiement du solde réussi', 1),
(4758, 4, '410198', '请传入支付宝支付回调URL', 'Veuillez passer l`URL de rappel de paiement Alipay', 1),
(4759, 4, '410199', '支付宝支付成功', 'Paiement Alipay réussi', 1),
(4760, 4, '410200', '订单生成失败', 'La génération de la commande a échoué', 1),
(4761, 4, '410201', '请提交购买的商品', 'Veuillez soumettre l`article acheté', 1),
(4762, 4, '410202', '商品不存在，请重新选择商品下单', 'Le produit n`existe pas, veuillez re-sélectionner le produit pour passer une commande', 1),
(4763, 4, '410203', '订单创建成功', 'Commande créée avec succès', 1),
(4764, 4, '410204', '收货成功', 'Marchandises reçues avec succès', 1),
(4765, 4, '410205', '收货失败', 'Echec de la réception', 1),
(4766, 4, '410206', '快递单号不存在', 'Le numéro de suivi express n`existe pas', 1),
(4767, 4, '410207', '默认运费模板未配置，无法下单', 'Le modèle d`expédition par défaut n`est pas configuré, la commande ne peut donc pas être passée', 1),
(4768, 4, '410208', '订单已过期,请刷新当前页面', 'La commande a expiré, veuillez actualiser la page en cours', 1),
(4769, 4, '410209', '订单已创建，请点击查看完成支付', 'La commande a été créée, veuillez cliquer pour voir pour finaliser le paiement', 1),
(4770, 4, '410210', '订单生成失败，你已经在该团内不能再参加了', 'La génération de la commande a échoué, vous ne pouvez plus participer au groupe', 1),
(4771, 4, '410211', '订单生成失败，你已经参加该团了，请先支付订单', 'La génération de la commande a échoué, vous avez déjà rejoint le groupe, veuillez d`abord payer la commande', 1),
(4772, 4, '410212', '该团人员已满', 'Le régiment est complet', 1),
(4773, 4, '410213', '暂不支持该支付方式，请刷新页面或者联系管理员', 'Ce moyen de paiement n`est pas supporté actuellement, veuillez actualiser la page ou contacter l`administrateur', 1),
(4774, 4, '410214', '您购买的商品库存已不足{:cart_num}{:unit_name}', 'Le produit que vous avez acheté est en rupture de stock {:cart_num}{:unit_name}', 1),
(4775, 4, '410215', '该订单已失效', 'La commande a expiré', 1),
(4776, 4, '410216', '支付失败', 'Le paiement a échoué', 1),
(4777, 4, '410217', '支付成功', 'Paiement réussi', 1),
(4778, 4, '410218', '支付方式错误', 'Méthode de paiement incorrecte', 1),
(4779, 4, '410219', '订单商品已评价', 'L`article de la commande a été évalué', 1),
(4780, 4, '410220', '请为商品评分', 'Veuillez évaluer le produit', 1),
(4781, 4, '410221', '请为商家服务评分', 'Veuillez noter le service commercial', 1),
(4782, 4, '410222', '评价失败', 'Échec de l`évaluation', 1),
(4783, 4, '410223', '请重新选择退款商品或件数', 'Veuillez re-sélectionner l`article remboursé ou le nombre de pièces', 1),
(4784, 4, '410224', '当前状态不能取消申请', 'Le statut actuel ne peut pas annuler la candidature', 1),
(4785, 4, '410225', '重选成功', 'Resélection réussie', 1),
(4786, 4, '410226', '订单已退款', 'Commande remboursée', 1),
(4787, 4, '410227', '使用积分抵扣失败', 'Impossible d`utiliser les points à déduire', 1),
(4788, 4, '410228', '会员类型不存在', 'Le type de membre n`existe pas', 1),
(4789, 4, '410229', '您已是永久会员无需再购买', 'Vous êtes un membre permanent, plus besoin d`acheter', 1),
(4790, 4, '410230', '该会员卡暂时无法购买', 'Cette carte de membre ne peut pas être achetée temporairement', 1),
(4791, 4, '410231', '您已经领取过免费会员', 'Vous avez déjà reçu un abonnement gratuit', 1),
(4792, 4, '410232', '此类型会员卡暂未开售', 'Ce type de carte de membre n`est pas encore disponible à la vente', 1),
(4793, 4, '410233', '获取购物车信息失败', 'Impossible d`obtenir les informations sur le panier', 1),
(4794, 4, '410234', '您要购买的优惠券已失效，无法购买', 'Le coupon que vous souhaitez acheter a expiré et ne peut pas être acheté', 1),
(4795, 4, '410235', '您已获取过该优惠券，无法再次购买', 'Vous avez déjà obtenu ce coupon et ne pouvez plus l`acheter', 1),
(4796, 4, '410236', '请刷新后重试', 'Veuillez actualiser et réessayer', 1),
(4797, 4, '410237', '暂无库存', 'Pas de stock pour le moment', 1),
(4798, 4, '410238', '选择的规格库存不足', 'La spécification sélectionnée est en rupture de stock', 1),
(4799, 4, '410239', '单次购买数量不能大于 {:limit} 件', 'La quantité d`achat unique ne peut pas être supérieure à {:limit} pièces', 1),
(4800, 4, '410240', '该商品限购 {:limit} 件，您已经购买 {:pay_num} 件', 'Cet article est limité à {:limit} pièces, vous avez déjà acheté {:pay_num} pièces', 1),
(4801, 4, '410241', '选择支付方式有误', 'Méthode de paiement sélectionnée incorrecte', 1),
(4802, 4, '410242', '选择的优惠劵无效', 'Le coupon sélectionné n`est pas valide', 1),
(4803, 4, '410243', '不满足优惠劵的使用条件', 'Les conditions d`utilisation du coupon ne sont pas remplies', 1),
(4804, 4, '410244', '使用优惠劵失败', 'Échec de l`utilisation du coupon', 1),
(4805, 4, '410245', '请填写姓名和电话', 'Veuillez renseigner votre nom et numéro de téléphone', 1),
(4806, 4, '410246', '营销商品不能使用线下支付', 'Le paiement hors ligne ne peut pas être utilisé pour commercialiser des produits', 1),
(4807, 4, '410247', '暂无门店无法选择门店自提', 'Il n`y a actuellement aucun magasin et ne peut pas choisir de retirer en magasin', 1),
(4808, 4, '410248', '订单商品结算失败', 'Impossible de régler l`article de la commande', 1),
(4809, 4, '410249', '发票已申请', 'Une facture a été demandée', 1),
(4810, 4, '410250', '正在申请退款中', 'Demande de remboursement', 1),
(4811, 4, '410251', '申请失败', 'L`application a échoué', 1),
(4812, 4, '410252', '退款件数大于订单件数', 'Le nombre de remboursements est supérieur au nombre de commandes', 1),
(4813, 4, '410253', '该订单已全部拆分', 'La commande a été fractionnée', 1),
(4814, 4, '410254', '申请退款失败', 'Échec de la demande de remboursement', 1),
(4815, 4, '410255', '存在待处理退款单', 'Il y a une commande de remboursement en attente', 1),
(4816, 4, '410256', '该订单无法删除', 'La commande ne peut pas être supprimée', 1),
(4817, 4, '410257', '订单已经支付无法取消', 'La commande a été payée et ne peut pas être annulée', 1),
(4818, 4, '410258', '拼团商品不能再来一单，请在拼团商品内自行下单', 'Le produit du groupe ne peut pas être commandé à nouveau, veuillez passer une commande dans le produit du groupe', 1),
(4819, 4, '410259', '砍价商品不能再来一单，请在砍价商品内自行下单', 'Vous ne pouvez pas avoir une autre commande pour l`article négocié, veuillez passer votre propre commande dans l`article négocié', 1),
(4820, 4, '410260', '秒杀商品不能再来一单，请在秒杀商品内自行下单', 'L`article seckill ne peut pas être commandé à nouveau, veuillez passer une commande dans l`article seckill', 1),
(4821, 4, '410261', '预售商品不能再来一单，请在预售商品内自行下单', 'L`article en prévente ne peut pas être commandé à nouveau, veuillez passer votre propre commande dans l`article en prévente', 1),
(4822, 4, '410262', '再来一单失败，请重新下单', 'Une autre commande a échoué, veuillez passer une nouvelle commande', 1),
(4823, 4, '410263', '该订单无法支付', 'La commande ne peut pas être payée', 1),
(4824, 4, '410264', '订单支付状态有误，无法进行支付', 'Le statut de paiement de la commande est incorrect et le paiement ne peut pas être effectué', 1),
(4825, 4, '410265', '该订单已支付', 'La commande a été payée', 1),
(4826, 4, '410266', '订单状态错误', 'Erreur d`état de la commande', 1),
(4827, 4, '410267', '此订单不能被核销', 'Cette commande ne peut pas être annulée', 1),
(4828, 4, '410268', '订单有售后申请请先处理', 'La commande a une application SAV, merci de la traiter en premier', 1),
(4829, 4, '410269', '您无权限核销此订单，请联系管理员', 'Vous n`êtes pas autorisé à annuler cette commande, veuillez contacter l`administrateur', 1),
(4830, 4, '410270', '订单已核销', 'La commande a été annulée', 1),
(4831, 4, '410271', '拼团订单暂未成功无法核销', 'La commande groupée n`a pas encore été annulée avec succès', 1),
(4832, 4, '410272', '核销失败', 'Échec de la radiation', 1),
(4833, 4, '410273', '发货成功', 'Livraison réussie', 1),
(4834, 4, '410274', '无需支付', 'Aucun paiement requis', 1),
(4835, 4, '410275', '获取用户openid失败,无法支付', 'Impossible d`obtenir l`openid de l`utilisateur, impossible de payer', 1),
(4836, 4, '410276', '网站名称配置未填写,无法支付', 'La configuration du nom du site n`est pas renseignée, impossible de payer', 1),
(4837, 4, '410277', '支付方式不存在', 'Le moyen de paiement n`existe pas', 1),
(4838, 4, '410278', '不支持该类型方式', 'Ce type de méthode n`est pas supporté', 1),
(4839, 4, '410279', '余额支付失败', 'Le paiement du solde a échoué', 1),
(4840, 4, '410280', '暂未开启发票', 'La facture n`a pas encore été ouverte', 1),
(4841, 4, '410281', '暂未开启专用发票', 'La facture spéciale n`a pas encore été ouverte', 1),
(4842, 4, '410282', '该发票已经存在', 'La facture existe déjà', 1),
(4843, 4, '410283', '设置默认发票失败', 'Impossible de définir la facture par défaut', 1),
(4844, 4, '410284', '没有此用户，无法检测升级用户等级', 'Impossible de détecter le niveau d`utilisateur de mise à niveau sans cet utilisateur', 1),
(4845, 4, '410285', '检测升级失败', 'La vérification de la mise à jour a échoué', 1),
(4846, 4, '410286', '修改订单失败', 'Impossible de modifier la commande', 1),
(4847, 4, '410287', '修改用户信息失败', 'Impossible de modifier les informations utilisateur', 1),
(4848, 4, '410288', '绑定推广关系失败', 'Impossible de lier la relation de promotion', 1),
(4849, 4, '410289', '天数不能为0', 'Le nombre de jours ne peut pas être 0', 1),
(4850, 4, '410290', '添加签到数据失败', 'Échec de l`ajout des données d`enregistrement', 1),
(4851, 4, '410291', '赠送经验失败', 'Impossible de donner l`expérience', 1),
(4852, 4, '410292', '请先配置签到天数', 'Veuillez d`abord configurer les jours d`enregistrement', 1),
(4853, 4, '410293', '已经签到', 'Enregistré', 1),
(4854, 4, '410294', '商品不存在', 'L`article n`existe pas', 1),
(4855, 4, '410295', '该商品已下架或删除', 'Ce produit a été supprimé ou supprimé', 1),
(4856, 4, '410296', '该商品库存不足', 'L`article est en rupture de stock', 1),
(4857, 4, '410297', '该商品库存不足{:num}', 'L`article est en rupture de stock{:num}', 1),
(4858, 4, '410298', '每人总共限购{:num}件', 'Une limite totale de {:num} pièces par personne', 1),
(4859, 4, '410299', '砍价已结束', 'Le marchandage est terminé', 1),
(4860, 4, '410300', '您不能再发起此件商品砍价', 'Vous ne pouvez plus initier de négociation sur cet article', 1),
(4861, 4, '410301', '该分享未开启砍价', 'Le partage n`a pas été ouvert à la négociation', 1),
(4862, 4, '410302', '您已经帮砍过此砍价', 'Vous avez déjà aidé à baisser le prix', 1),
(4863, 4, '410303', '砍价信息没有查到', 'Les informations de négociation n`ont pas été trouvées', 1),
(4864, 4, '410304', '用户砍价信息未查到', 'Informations de négociation utilisateur introuvables', 1),
(4865, 4, '410305', '请选择有效的商品属性', 'Veuillez sélectionner un attribut de produit valide', 1),
(4866, 4, '410306', '砍价商品不存在', 'L`article promotionnel n`existe pas', 1),
(4867, 4, '410307', '砍价失败', 'Le marchandage a échoué', 1),
(4868, 4, '410308', '砍价未成功', 'Le marchandage a échoué', 1),
(4869, 4, '410309', '砍价已支付', 'Marchandage payé', 1),
(4870, 4, '410310', '您不能再帮砍此件商品', 'Vous ne pouvez plus aider à couper cet article', 1),
(4871, 4, '410311', '商品已被删除', 'L`élément a été supprimé', 1),
(4872, 4, '410312', '拼团不存在或已下架,请手动申请退款', 'Le groupe n`existe pas ou a été supprimé, veuillez demander un remboursement manuellement', 1),
(4873, 4, '410313', '每个订单限购{:num}件', 'Chaque commande est limitée à {:num} pièces', 1),
(4874, 4, '410314', '未查到拼团信息，无法取消', 'Impossible d`annuler les informations de groupe car aucune information de groupe n`a été trouvée', 1),
(4875, 4, '410315', '拼团已到期', 'Le groupe a expiré', 1),
(4876, 4, '410316', '拼团已完成，无法取消', 'Le regroupement est terminé et ne peut pas être annulé', 1),
(4877, 4, '410317', '每人限购{:num}件', 'Limite {:num} pièces par personne', 1),
(4878, 4, '410318', '抽奖不存在', 'La loterie n`existe pas', 1),
(4879, 4, '410319', '领取成功', 'Reçu avec succès', 1),
(4880, 4, '410320', '领取失败', 'Échec de la réclamation', 1),
(4881, 4, '410321', '活动未开始', 'Evénement non démarré', 1),
(4882, 4, '410322', '活动已结束', 'L`événement est terminé', 1),
(4883, 4, '410323', '您已有这张优惠券，请勿重复购买', 'Vous avez déjà ce coupon, merci de ne pas l`acheter à nouveau', 1),
(4884, 4, '410324', '请核对快递公司编码', 'Veuillez vérifier le code du transporteur', 1),
(4885, 4, '410325', '请选择发票', 'Veuillez sélectionner une facture', 1),
(4886, 4, '-1', '系统繁忙，请稍候再试', 'Le système est occupé, veuillez réessayer plus tard', 1),
(4887, 4, '43104', 'appid与openid不匹配', 'l`appid ne correspond pas à l`openid', 1),
(4888, 4, '45009', '达到微信api每日限额上限', 'La limite journalière de l`api WeChat a été atteinte', 1),
(4889, 4, '45008', '图文消息超过限制', 'Le SMS dépasse la limite', 1),
(4890, 4, '45007', '语音播放时间超过限制', 'Le temps de lecture de la voix dépasse la limite', 1),
(4891, 4, '45006', '图片链接字段超过限制', 'Le champ lien image dépasse la limite', 1),
(4892, 4, '45005', '链接字段超过限制', 'Le champ de lien dépasse la limite', 1),
(4893, 4, '45004', '描述字段超过限制', 'Le champ de description dépasse la limite', 1),
(4894, 4, '45003', '标题字段超过限制', 'Le champ titre dépasse la limite', 1),
(4895, 4, '45002', '消息内容超过限制', 'Le contenu du message dépasse la limite', 1),
(4896, 4, '45001', '多媒体文件大小超过限制', 'La taille du fichier multimédia dépasse la limite', 1),
(4897, 4, '44004', '文本消息内容为空', 'Le contenu du SMS est vide', 1),
(4898, 4, '44003', '图文消息内容为空', 'Le contenu du SMS est vide', 1),
(4899, 4, '44002', 'POST 的数据包为空', 'Le paquet POST est vide', 1),
(4900, 4, '44001', '多媒体文件为空', 'Le fichier multimédia est vide', 1),
(4901, 4, '43019', '需要将接收者从黑名单中移除', 'Le destinataire doit être retiré de la liste noire', 1),
(4902, 4, '43005', '需要好友关系', 'Besoin d`une relation amicale', 1),
(4903, 4, '43004', '需要接收者关注', 'Nécessite l`attention du destinataire', 1),
(4904, 4, '43003', '需要 HTTPS 请求', 'Nécessite une requête HTTPS', 1),
(4905, 4, '43002', '需要 POST 请求', 'Nécessite une requête POST', 1),
(4906, 4, '43001', '需要 GET 请求', 'Nécessite une requête GET', 1),
(4907, 4, '42007', '用户修改微信密码， accesstoken 和 refreshtoken 失效，需要重新授权', 'Les utilisateurs modifient le mot de passe WeChat, le jeton d`accès et le jeton d`actualisation ne sont pas valides et doivent être réautorisés', 1),
(4908, 4, '42003', 'oauth_code 超时', 'oauth_code a expiré', 1),
(4909, 4, '42002', 'refresh_token 超时', 'refresh_token a expiré', 1),
(4910, 4, '42001', 'access_token 超时，请检查 access_token 的有效期，请参考基础支持 - 获取 access_token 中，对 access_token 的详细机制说明', 'L`access_token a expiré, veuillez vérifier la période de validité de l`access_token, veuillez vous référer à Support de base - Obtention de l`access_token, le mécanisme détaillé de l`access_token', 1),
(4911, 4, '41009', '缺少 openid', 'ID d`ouverture manquant', 1),
(4912, 4, '41008', '缺少 oauth code', 'Code oauth manquant', 1),
(4913, 4, '41007', '缺少子菜单数据', 'Données de sous-menu manquantes', 1),
(4914, 4, '41006', '缺少 media_id 参数', 'Paramètre media_id manquant', 1),
(4915, 4, '41005', '缺少多媒体文件数据', 'Données du fichier multimédia manquantes', 1),
(4916, 4, '41004', '缺少 secret 参数', 'Paramètre secret manquant', 1),
(4917, 4, '41003', '缺少 refresh_token 参数', 'Paramètre refresh_token manquant', 1),
(4918, 4, '41002', '缺少 appid 参数', 'Paramètre appid manquant', 1),
(4919, 4, '41001', '缺少 access_token 参数', 'Paramètre access_token manquant', 1),
(4920, 4, '40163', 'oauth_code已使用', 'oauth_code est utilisé', 1),
(4921, 4, '40155', '请勿添加其他公众号的主页链接', 'Ne pas ajouter de liens vers les pages d`accueil d`autres comptes officiels', 1),
(4922, 4, '40137', '不支持的图片格式', 'Format d`image non pris en charge', 1),
(4923, 4, '40132', '微信号不合法', 'L`identifiant Wechat est invalide', 1),
(4924, 4, '40125', '无效的appsecret', 'Secret d`application invalide', 1),
(4925, 4, '40121', '不合法的 media_id 类型', 'Type de media_id illégal', 1),
(4926, 4, '40120', '子 button 类型错误', 'Erreur de type de sous-bouton', 1),
(4927, 4, '40119', 'button 类型错误', 'erreur de type de bouton', 1),
(4928, 4, '40118', 'media_id 大小不合法', 'La taille de media_id est invalide', 1),
(4929, 4, '40117', '分组名字不合法', 'Le nom du groupe est invalide', 1),
(4930, 4, '40060', '删除单篇图文时，指定的 article_idx 不合法', 'Lors de la suppression d`une seule image, l`article_idx spécifié n`est pas valide', 1),
(4931, 4, '40051', '分组名字不合法', 'Le nom du groupe est invalide', 1),
(4932, 4, '40050', '不合法的分组 id', 'Identifiant de groupe illégal', 1),
(4933, 4, '40048', '无效的url', 'URL invalide', 1),
(4934, 4, '40039', '不合法的 URL 长度', 'Longueur d`URL illégale', 1),
(4935, 4, '40035', '不合法的参数', 'Paramètre illégal', 1),
(4936, 4, '40038', '不合法的请求格式', 'Format de requête illégal', 1),
(4937, 4, '40033', '不合法的请求字符，不能包含 \\uxxxx 格式的字符', 'Caractère de requête illégal, ne peut pas contenir de caractères au format \\uxxxx', 1),
(4938, 4, '40032', '不合法的 openid 列表长度', 'Longueur de liste openid illégale', 1),
(4939, 4, '40031', '不合法的 openid 列表', 'Liste openid illégale', 1),
(4940, 4, '40030', '不合法的 refresh_token', 'Refresh_token illégal', 1),
(4941, 4, '40029', '无效的 oauth_code', 'Code oauth_invalide', 1),
(4942, 4, '40028', '不合法的自定义菜单使用用户', 'Utilisateur de menu personnalisé illégal', 1),
(4943, 4, '40027', '不合法的子菜单按钮 URL 长度', 'Longueur d`URL de bouton de sous-menu illégale', 1),
(4944, 4, '40026', '不合法的子菜单按钮 KEY 长度', 'Longueur de clé de bouton de sous-menu illégale', 1),
(4945, 4, '40025', '不合法的子菜单按钮名字长度', 'Longueur de nom de bouton de sous-menu illégale', 1),
(4946, 4, '40024', '不合法的子菜单按钮类型', 'Type de bouton de sous-menu illégal', 1),
(4947, 4, '40023', '不合法的子菜单按钮个数', 'Nombre illégal de boutons de sous-menu', 1),
(4948, 4, '40022', '不合法的子菜单级数', 'Niveau de sous-menu illégal', 1),
(4949, 4, '40021', '不合法的菜单版本号', 'Numéro de version de menu illégal', 1),
(4950, 4, '40020', '不合法的按钮 URL 长度', 'Longueur d`URL de bouton illégale', 1),
(4951, 4, '40019', '不合法的按钮 KEY 长度', 'Longueur de clé de bouton illégale', 1),
(4952, 4, '40018', '不合法的按钮名字长度', 'Longueur de nom de bouton illégale', 1),
(4953, 4, '40017', '不合法的按钮类型', 'Type de bouton illégal', 1),
(4954, 4, '40016', '不合法的按钮个数', 'Nombre de boutons illégaux', 1),
(4955, 4, '40015', '不合法的菜单类型', 'Type de menu illégal', 1),
(4956, 4, '40014', '不合法的 access_token ，请开发者认真比对 access_token 的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口', 'Access_token illégal, veuillez comparer soigneusement la validité de l`access_token (par exemple s`il a expiré), ou vérifiez si l`interface est appelée pour le compte officiel approprié', 1),
(4957, 4, '40013', '不合法的 AppID ，请开发者检查 AppID 的正确性，避免异常字符，注意大小写', 'AppID illégal, veuillez vérifier l`exactitude de l`AppID, évitez les caractères anormaux, faites attention à la casse', 1),
(4958, 4, '40012', '不合法的缩略图文件大小', 'Taille de fichier de vignettes illégale', 1),
(4959, 4, '40011', '不合法的视频文件大小', 'Taille de fichier vidéo illégale', 1),
(4960, 4, '40010', '不合法的语音文件大小', 'Taille de fichier vocal illégale', 1),
(4961, 4, '40009', '不合法的图片文件大小', 'Taille de fichier image illégale', 1),
(4962, 4, '40008', '不合法的消息类型', 'Type de message illégal', 1),
(4963, 4, '40007', '不合法的媒体文件 id', 'ID de fichier multimédia invalide', 1),
(4964, 4, '40006', '不合法的文件大小', 'Taille de fichier illégale', 1),
(4965, 4, '40005', '不合法的文件类型', 'Type de fichier illégal', 1),
(4966, 4, '40004', '不合法的媒体文件类型', 'Type de fichier multimédia illégal', 1),
(4967, 4, '40003', '不合法的 OpenID ，请开发者确认 OpenID （该用户）是否已关注公众号，或是否是其他公众号的 OpenID', 'OpenID illégal, veuillez confirmer si OpenID (l`utilisateur) a suivi le compte officiel, ou s`il s`agit de l`OpenID d`un autre compte officiel', 1),
(4968, 4, '40002', '不合法的凭证类型', 'Type de certificat illégal', 1),
(4969, 4, '40001', '获取 access_token 时 AppSecret 错误，或者 access_token 无效。请开发者认真比对 AppSecret 的正确性，或查看是否正在为恰当的公众号调用接口', 'L`AppSecret est erroné lors de l`obtention de l`access_token, ou l`access_token est invalide. Veuillez vérifier attentivement l`exactitude de l`AppSecret, ou vérifiez si l`interface est appelée pour le compte officiel approprié', 1),
(4970, 4, '200011', '此账号已被封禁，无法操作', 'Ce compte a été banni et ne peut pas être exploité', 1),
(4971, 4, '200012', '个人模版数已达上限，上限25个', 'Le nombre de modèles personnels a atteint la limite supérieure, la limite supérieure est de 25', 1),
(4972, 4, '200014', '请检查小程序所属类目', 'Veuillez vérifier la catégorie de l`applet', 1),
(4973, 5, '100000', '保存成功', 'Salvataggio riuscito', 1),
(4974, 5, '100001', '修改成功', 'Modificato con successo', 1),
(4975, 5, '100002', '删除成功', 'Eliminazione riuscita', 1),
(4976, 5, '100003', '显示成功', 'Mostra successo', 1),
(4977, 5, '100004', '隐藏成功', 'Nascondi con successo', 1),
(4978, 5, '100005', '操作失败', 'Operazione fallita', 1),
(4979, 5, '100006', '保存失败', 'Salvataggio fallito', 1),
(4980, 5, '100007', '修改失败', 'Modifica fallita', 1),
(4981, 5, '100008', '删除失败', 'Eliminazione fallita', 1),
(4982, 5, '100009', '图片上传成功', 'Caricamento dell`immagine riuscito', 1),
(4983, 5, '100010', '操作成功', 'Operazione riuscita', 1),
(4984, 5, '100011', '暂无数据', 'Nessun dato ancora', 1),
(4985, 5, '100012', '更新成功', 'Aggiornamento riuscito', 1),
(4986, 5, '100013', '更新失败', 'Aggiornamento fallito', 1),
(4987, 5, '100014', '设置成功', 'Imposta con successo', 1),
(4988, 5, '100015', '设置失败', 'Installazione fallita', 1),
(4989, 5, '100016', '获取失败', 'Impossibile ottenere', 1),
(4990, 5, '100017', '提交成功', 'Invia con successo', 1),
(4991, 5, '100018', '提交失败', 'Invio fallito', 1),
(4992, 5, '100019', '取消成功', 'Annulla riuscita', 1),
(4993, 5, '100020', '取消失败', 'Annullamento fallito', 1),
(4994, 5, '100021', '添加成功', 'Aggiunto con successo', 1),
(4995, 5, '100022', '添加失败', 'Aggiungi fallito', 1),
(4996, 5, '100023', '保存token失败', 'Impossibile salvare il token', 1),
(4997, 5, '100024', '备注成功', 'Osservazione riuscita', 1),
(4998, 5, '100025', '备注失败', 'Osservazione non riuscita', 1),
(4999, 5, '100026', '数据不存在', 'I dati non esistono', 1),
(5000, 5, '100027', '申请成功', 'Applicazione riuscita', 1),
(5001, 5, '100028', '申请失败', 'Applicazione non riuscita', 1),
(5002, 5, '100029', '暂无此方法', 'Non esiste un metodo del genere', 1),
(5003, 5, '100030', '发送成功', 'Invia con successo', 1),
(5004, 5, '100031', '发送失败', 'Invio fallito', 1),
(5005, 5, '100032', '上传成功', 'Caricamento riuscito', 1),
(5006, 5, '100033', '上传失败', 'Caricamento fallito', 1),
(5007, 5, '100034', '移动成功', 'Sposta con successo', 1),
(5008, 5, '100035', '移动失败', 'Spostamento fallito', 1),
(5009, 5, '100036', '退款成功', 'Rimborso riuscito', 1),
(5010, 5, '100037', '退款失败', 'Rimborso fallito', 1),
(5011, 5, '100038', '同步成功', 'Sincronizzazione riuscita', 1),
(5012, 5, '100039', '同步失败', 'Sincronizzazione fallita', 1),
(5013, 5, '100040', '恢复成功', 'Recupero riuscito', 1),
(5014, 5, '100041', '恢复失败', 'Ripristino fallito', 1),
(5015, 5, '100042', '退出成功', 'Esci con successo', 1),
(5016, 5, '100043', '退出失败', 'Uscita fallita', 1),
(5017, 5, '100044', '开通成功', 'Apri con successo', 1),
(5018, 5, '100045', '开通失败', 'Attivazione non riuscita', 1),
(5019, 5, '100046', '清除数据成功', 'Cancella i dati con successo', 1),
(5020, 5, '100047', '优化成功', 'Ottimizzazione riuscita', 1),
(5021, 5, '100048', '优化失败', 'Ottimizzazione fallita', 1),
(5022, 5, '100049', '修复成功', 'Riparazione riuscita', 1),
(5023, 5, '100050', '修复失败', 'Riparazione fallita', 1),
(5024, 5, '100051', '备份成功', 'Backup riuscito', 1),
(5025, 5, '100052', '备份失败', 'Backup fallito', 1),
(5026, 5, '100100', '参数错误', 'Errore parametro', 1),
(5027, 5, '100101', '非法操作', 'Operazione illegale', 1),
(5028, 5, '100102', '数据获取失败', 'Acquisizione dati fallita', 1),
(5029, 5, '100103', '站点升级中，请稍候访问', 'Il sito è in fase di aggiornamento, visita più tardi', 1),
(5030, 5, '100104', '缺少code', 'Codice mancante', 1),
(5031, 5, '110000', '您暂时没有访问权限', 'Non hai accesso in questo momento', 1),
(5032, 5, '110001', '接口未授权，您无法访问', 'L`interfaccia non è autorizzata e non puoi accedervi', 1),
(5033, 5, '110002', '请登录', 'Accedi', 1),
(5034, 5, '110003', '登录已过期,请重新登录', 'Il login è scaduto, per favore accedi di nuovo', 1),
(5035, 5, '110004', '登录状态有误,请重新登录', 'Lo stato di accesso non è corretto, per favore accedi di nuovo', 1),
(5036, 5, '110005', '请登录', 'Accedi', 1),
(5037, 5, '110006', '登录已过期,请重新登录', 'Il login è scaduto, per favore accedi di nuovo', 1),
(5038, 5, '110007', '登录状态有误,请重新登录', 'Lo stato di accesso non è corretto, per favore accedi di nuovo', 1),
(5039, 5, '400000', '请选择用户头像', 'Seleziona avatar utente', 1),
(5040, 5, '400001', '请填写用户昵称', 'Inserisci il nickname dell`utente', 1),
(5041, 5, '400002', '请填写评论内容', 'Compila il contenuto del commento', 1),
(5042, 5, '400003', '请选择商品分数', 'Seleziona il punteggio dell`oggetto', 1),
(5043, 5, '400004', '请选择服务分数', 'Seleziona un punteggio di servizio', 1),
(5044, 5, '400005', '商品分数必须是1-5之间的整数', 'Il punteggio della merce deve essere un numero intero compreso tra 1-5', 1),
(5045, 5, '400006', '服务分数必须是1-5之间的整数', 'Il punteggio del servizio deve essere un numero intero compreso tra 1 e 5', 1),
(5046, 5, '400007', '请选择快递公司', 'Seleziona un corriere', 1),
(5047, 5, '400008', '请填写寄件人姓名', 'Inserisci il nome del mittente', 1),
(5048, 5, '400009', '请输入寄件人手机号码', 'Inserisci il numero di cellulare del mittente', 1),
(5049, 5, '400010', '寄件人手机号码不正确', 'Il numero di cellulare del mittente non è corretto', 1),
(5050, 5, '400011', '请填写寄件人详细地址', 'Si prega di inserire l`indirizzo dettagliato del mittente', 1),
(5051, 5, '400012', '请填写云打印机编号', 'Compila il numero della stampante cloud', 1),
(5052, 5, '400013', '请传入套餐id', 'Inserisci l`ID del pacchetto', 1),
(5053, 5, '400014', '套餐id必须为数字', 'L`ID pacchetto deve essere un numero', 1),
(5054, 5, '400015', '请填写套餐金额', 'Compila l`importo del pacchetto', 1),
(5055, 5, '400016', '请填写购买数量', 'Compila la quantità di acquisto', 1),
(5056, 5, '400017', '购买数量必须为数字', 'La quantità di acquisto deve essere un numero', 1),
(5057, 5, '400018', '请填写购买套餐类型', 'Compila il tipo di pacchetto di acquisto', 1),
(5058, 5, '400019', '您输入的手机号码必须为数字', 'Il numero di cellulare che inserisci deve essere un numero', 1),
(5059, 5, '400020', '密码必须填写', 'La password deve essere inserita', 1),
(5060, 5, '400021', '短信验证码必须为数字', 'Il codice di verifica SMS deve essere un numero', 1),
(5061, 5, '400022', '请填写话术内容', 'Compila il contenuto delle parole', 1),
(5062, 5, '400023', '请填写排序数字', 'Compila i numeri di smistamento', 1),
(5063, 5, '400024', '请填写排序数字', 'Compila i numeri di smistamento', 1),
(5064, 5, '400025', '请填写运费模板名称', 'Compila il nome del modello di spedizione', 1),
(5065, 5, '400026', '运费信息必须为数组', 'Le informazioni sulla spedizione devono essere un array', 1),
(5066, 5, '400027', '包邮信息必须为数组', 'Le informazioni sul pacchetto devono essere un array', 1),
(5067, 5, '400028', '不送达信息必须为数组', 'Il messaggio non consegnato deve essere un array', 1),
(5068, 5, '400029', 'type数据格式错误，应为1或2或3', 'digitare errore di formato dati, dovrebbe essere 1 o 2 o 3', 1),
(5069, 5, '400030', 'appoint数据格式错误，应为0或1', 'Il formato dei dati di nomina non è corretto, dovrebbe essere 0 o 1', 1),
(5070, 5, '400031', 'no_delivery数据格式错误，应为0或1', 'errore formato dati no_delivery, dovrebbe essere 0 o 1', 1),
(5071, 5, '400032', 'sort数据格式错误，应为整数', 'Il formato dei dati di ordinamento è errato, dovrebbe essere un numero intero', 1),
(5072, 5, '400033', '请填写管理员账号', 'Compila l`account amministratore', 1),
(5073, 5, '400034', '管理员账号为英文字母', 'L`account amministratore è in lettere inglesi', 1),
(5074, 5, '400035', '请输管理员姓名', 'Inserisci il nome dell`amministratore', 1),
(5075, 5, '400036', '请选择管理员身份', 'Seleziona lo stato di amministratore', 1),
(5076, 5, '400037', '身份必须为数组', 'L`identità deve essere un array', 1),
(5077, 5, '400038', '请填写城市名称', 'Inserisci il nome della città', 1),
(5078, 5, '400039', 'level数据格式错误，应为整数', 'Il formato dei dati di livello non è corretto, dovrebbe essere un numero intero', 1),
(5079, 5, '400040', 'parent_id数据格式错误，应为整数', 'Errore nel formato dei dati Parent_id, dovrebbe essere un numero intero', 1),
(5080, 5, '400041', '请输入有效的网址', 'Inserisci un URL valido', 1),
(5081, 5, '400042', '一级返佣比例必须为数字', 'Il rapporto di sconto di primo livello deve essere un numero', 1),
(5082, 5, '400043', '一级返佣比例最多两位小数', 'Il tasso di sconto di primo livello può essere fino a due decimali', 1),
(5083, 5, '400044', '一级返佣比例填写范围在0-100之间', 'Il rapporto di sconto di primo livello riempie l`intervallo tra 0-100', 1),
(5084, 5, '400045', '二级返佣比例必须为数字', 'Il rapporto di sconto secondario deve essere un numero', 1),
(5085, 5, '400046', '二级返佣比例最多两位小数', 'Il rapporto di sconto secondario può essere fino a due cifre decimali', 1),
(5086, 5, '400047', '二级返佣比例填写范围在0-100之间', 'Il rapporto di sconto di secondo livello riempie l`intervallo tra 0-100', 1),
(5087, 5, '400048', '待补货数量必须为数字', 'La quantità da reintegrare deve essere un numero', 1),
(5088, 5, '400049', '警戒库存必须为数字', 'Lo stock di avviso deve essere un numero', 1),
(5089, 5, '400050', '提现最小金额只能为数字', 'L`importo minimo di prelievo può essere solo un numero', 1),
(5090, 5, '400051', '提现最小金额必须大于0', 'L`importo minimo di prelievo deve essere maggiore di 0', 1),
(5091, 5, '400052', '佣金冻结时间范围在0-180之间', 'L`intervallo di tempo di blocco della commissione è compreso tra 0 e 180', 1),
(5092, 5, '400053', '满额分销金额金额必须为数字', 'L`intero importo della distribuzione deve essere un numero', 1),
(5093, 5, '400054', '积分抵用比例必须为数字', 'Il rapporto di credito dei punti deve essere un numero', 1),
(5094, 5, '400055', '积分抵用比例最多两位小数', 'La percentuale di detrazione dei punti può arrivare fino a due decimali', 1),
(5095, 5, '400056', '积分抵用比例必须在0-1000之间', 'La percentuale dei punti di credito deve essere compresa tra 0-1000', 1),
(5096, 5, '400057', '积分抵用上限必须为数字', 'Il limite massimo dei punti di credito deve essere un numero', 1),
(5097, 5, '400058', '积分抵用上限必须大于等于0', 'Il limite massimo dei punti di credito deve essere maggiore o uguale a 0', 1),
(5098, 5, '400059', '下单赠送积分必须为数字', 'I punti bonus dell`ordine devono essere numeri', 1),
(5099, 5, '400060', '下单赠送积分必须在0-1000之间', 'I punti bonus dell`ordine devono essere compresi tra 0-1000', 1),
(5100, 5, '400061', '普通商品未支付取消订单时间必须为数字', 'Il tempo di annullamento dell`oggetto ordinario non pagato deve essere un numero', 1),
(5101, 5, '400062', '活动商品未支付取消订单时间必须为数字', 'L`ora dell`annullamento dell`ordine deve essere un numero se l`oggetto dell`evento non è stato pagato', 1),
(5102, 5, '400063', '砍价商品未支付取消订单时间必须为数字', 'Il tempo per annullare l`ordine se l`oggetto dell`affare non viene pagato deve essere un numero', 1),
(5103, 5, '400064', '拼团商品未支付取消订单时间必须为数字', 'Il tempo per annullare l`ordine se l`articolo del gruppo non viene pagato deve essere un numero', 1),
(5104, 5, '400065', '订单发货后自动收货时间必须为数字', 'Il tempo di consegna automatica dopo la spedizione dell`ordine deve essere un numero', 1),
(5105, 5, '400066', '满额包邮金额必须为数字', 'L`importo della spedizione gratuita deve essere un numero', 1),
(5106, 5, '400067', '积分倍数必须大于0', 'Il moltiplicatore integrale deve essere maggiore di 0', 1),
(5107, 5, '400068', '折扣数必须大于0', 'Il numero di sconti deve essere maggiore di 0', 1),
(5108, 5, '400069', '积分倍数必须大于0', 'Il moltiplicatore integrale deve essere maggiore di 0', 1),
(5109, 5, '400070', '折扣数必须大于0', 'Lo sconto deve essere maggiore di 0', 1),
(5110, 5, '400071', '下单赠送经验比率必须为数字', 'Il rapporto esperienza bonus ordine deve essere un numero', 1),
(5111, 5, '400072', '下单赠送经验比率必须大于0', 'Il rapporto esperienza bonus ordine deve essere maggiore di 0', 1),
(5112, 5, '400073', '签到赠送经验必须为数字', 'L`esperienza regalo di accesso deve essere un numero', 1),
(5113, 5, '400074', '签到赠送经验必须大于0', 'L`esperienza di accesso deve essere maggiore di 0', 1),
(5114, 5, '400075', '邀请新用户赠送经验必须为数字', 'Invitare nuovi utenti a dare esperienza deve essere un numero', 1),
(5115, 5, '400076', '邀请新用户赠送经验必须大于0', 'Invita nuovi utenti a dare esperienza deve essere maggiore di 0', 1),
(5116, 5, '400077', '发货人姓名必须为汉字', 'Il nome del mittente deve essere in caratteri cinesi', 1),
(5117, 5, '400078', '发货人姓名长度在2-10位', 'La lunghezza del nome del mittente è di 2-10 cifre', 1),
(5118, 5, '400079', '发货人电话必须为数字', 'Il numero di telefono del mittente deve essere un numero', 1),
(5119, 5, '400080', '发货人电话请填写有效的手机号', 'Inserisci un numero di cellulare valido per il numero di telefono del mittente', 1),
(5120, 5, '400081', '发货人地址只能是汉字、字母、数字', 'L`indirizzo del mittente può essere solo caratteri cinesi, lettere e numeri', 1),
(5121, 5, '400082', '发货人地址长度为10-100位', 'La lunghezza dell`indirizzo del mittente è 10-100 cifre', 1),
(5122, 5, '400083', '电子面单打印机编号必须为数字、字母', 'Il numero di serie della stampante per moduli elettronici deve essere numeri e lettere', 1),
(5123, 5, '400084', '电子面单打印机编号长度为10-50位', 'La lunghezza del numero di serie della stampante per fogli elettronici è di 10-50 cifre', 1),
(5124, 5, '400085', '客服反馈长度位10-90位', 'La lunghezza del feedback del servizio clienti è 10-90', 1),
(5125, 5, '400086', '请填写标签分类名称', 'Compila il nome della categoria dell`etichetta', 1),
(5126, 5, '400087', '请填写标签分类排序', 'Compila l`ordine di classificazione dell`etichetta', 1),
(5127, 5, '400088', '标签分类必须为数字', 'La categoria dell`etichetta deve essere un numero', 1),
(5128, 5, '400089', '账号只能为数字和字母', 'L`account può essere solo numeri e lettere', 1),
(5129, 5, '400090', '限量不能超过商品库存', 'La quantità limitata non può superare l`inventario dei prodotti', 1),
(5130, 5, '400091', '商品已下架或移入回收站', 'L`oggetto è stato rimosso o spostato nel cestino', 1),
(5131, 5, '400092', '占用库存失败', 'Impossibile occupare l`inventario', 1),
(5132, 5, '400093', '商品已下架或已删除', 'L`oggetto è stato rimosso o eliminato', 1),
(5133, 5, '400094', '请选择有效的商品属性', 'Seleziona un attributo prodotto valido', 1),
(5134, 5, '400095', '金额不能小于0', 'L`importo non può essere inferiore a 0', 1),
(5135, 5, '400096', '结束时间不能小于今天', 'L`ora di fine non può essere inferiore a quella di oggi', 1),
(5136, 5, '400097', '您不是付费会员', 'Non sei un membro pagato', 1),
(5137, 5, '400098', '暂时无法领取', 'Temporaneamente non disponibile', 1),
(5138, 5, '400099', '请先配置小票打印开发者', 'Configura prima lo sviluppatore della stampa delle ricevute', 1),
(5139, 5, '400100', '请填写分类名称', 'Compila il nome della categoria', 1),
(5140, 5, '400101', '该分类已存在', 'Questa categoria esiste già', 1),
(5141, 5, '400102', '请先删除子分类', 'Elimina prima la sottocategoria', 1),
(5142, 5, '400103', '分类不存在', 'La classificazione non esiste', 1),
(5143, 5, '400104', '文件名称不能为空', 'Il nome del file non può essere vuoto', 1),
(5144, 5, '400105', '该分类有下级分类，无法修改上级', 'Questa categoria ha delle sottocategorie e non può modificare il superiore', 1),
(5145, 5, '400106', '备注不能为空', 'I commenti non possono essere vuoti', 1),
(5146, 5, '400107', '请输入姓名', 'Inserisci il tuo nome', 1),
(5147, 5, '400108', '请输入提现金额', 'Inserisci l`importo del prelievo', 1),
(5148, 5, '400109', '请输入支付宝账号', 'Inserisci il numero di conto Alipay', 1),
(5149, 5, '400110', '请输入微信账号', 'Inserisci il tuo account WeChat', 1),
(5150, 5, '400111', '请输入银行卡号', 'Inserisci il numero della carta bancaria', 1),
(5151, 5, '400112', '请输入开户行', 'Inserisci il conto bancario', 1),
(5152, 5, '400113', '拒绝理由不能为空', 'Il motivo del rifiuto non può essere vuoto', 1),
(5153, 5, '400114', '不能重复收货', 'Impossibile ricevere merci ripetutamente', 1),
(5154, 5, '400115', '请先发货或者送货', 'Si prega di spedire o consegnare prima', 1),
(5155, 5, '400116', '收货失败,请稍候再试', 'Impossibile ricevere la consegna, riprova più tardi', 1),
(5156, 5, '400117', '收货成功', 'Merce ricevuta con successo', 1),
(5157, 5, '400118', '订单不存在', 'L`ordine non esiste', 1),
(5158, 5, '400119', '用户信息不存在', 'Le informazioni sull`utente non esistono', 1),
(5159, 5, '400120', '快递单号不存在', 'Il numero di tracciamento espresso non esiste', 1),
(5160, 5, '400121', '打印成功', 'Stampa riuscita', 1),
(5161, 5, '400122', '打印失败', 'Stampa non riuscita', 1),
(5162, 5, '400123', '快递公司编号缺失', 'Manca il numero del corriere', 1),
(5163, 5, '400124', '请配置腾讯地图KEY', 'Configura la chiave della mappa Tencent', 1),
(5164, 5, '400125', '请选择门店位置', 'Seleziona la posizione del negozio', 1),
(5165, 5, '400126', '添加的核销员用户已存在', 'L`utente dell`account aggiunto esiste già', 1),
(5166, 5, '400127', '请选择所属提货点', 'Seleziona il punto di ritiro a cui appartieni', 1),
(5167, 5, '400128', '请填写核销员名称', 'Compila il nome dell`ufficiale di verifica', 1),
(5168, 5, '400129', '请填写核销员电话', 'Compila il numero di telefono dell`ufficiale di verifica', 1),
(5169, 5, '400130', '核销员添加成功', 'Lo staff di verifica è stato aggiunto con successo', 1),
(5170, 5, '400131', '核销员添加失败', 'Impossibile aggiungere il personale di cancellazione', 1),
(5171, 5, '400132', '请填写手机号', 'Compila il numero di telefono', 1),
(5172, 5, '400133', '请填写账号', 'Compila il numero di conto', 1),
(5173, 5, '400134', '请填写密码', 'Inserisci la password', 1),
(5174, 5, '400135', '请填写短信签名', 'Compila la firma dell`SMS', 1),
(5175, 5, '400136', '短信签名最长为8位', 'La lunghezza massima della firma SMS è 8', 1),
(5176, 5, '400137', '请填写验证码', 'Compila il codice di verifica', 1),
(5177, 5, '400138', '请填写域名', 'Compila il nome di dominio', 1),
(5178, 5, '400139', '登录成功', 'Accesso riuscito', 1),
(5179, 5, '400140', '账号或密码错误', 'Account o password errati', 1),
(5180, 5, '400141', '请先填写短信配置', 'Compila prima la configurazione SMS', 1),
(5181, 5, '400142', '请输入模板名称', 'Inserisci un nome per il modello', 1),
(5182, 5, '400143', '请输入模板内容', 'Inserisci il contenuto del modello', 1),
(5183, 5, '400144', '售后订单状态不支持该操作', 'Lo stato dell`ordine post-vendita non supporta questa operazione', 1),
(5184, 5, '400145', '修改退款状态成功', 'Modifica lo stato del rimborso con successo', 1),
(5185, 5, '400146', '请输入退款金额', 'Inserisci l`importo del rimborso', 1),
(5186, 5, '400147', '已退完支付金额，不能再退款了', 'L`importo del pagamento è stato rimborsato, non più rimborsi', 1),
(5187, 5, '400148', '退款金额大于支付金额，请修改退款金额', 'L`importo del rimborso è maggiore dell`importo del pagamento, modificare l`importo del rimborso', 1),
(5188, 5, '400149', '退款成功', 'Rimborso riuscito', 1),
(5189, 5, '400150', '退款失败', 'Rimborso fallito', 1),
(5190, 5, '400151', '验证成功', 'Verifica riuscita', 1),
(5191, 5, '400152', '核销成功', 'Cancellazione riuscita', 1),
(5192, 5, '400153', '核销订单未查到', 'Ordine di verifica non trovato', 1),
(5193, 5, '400154', '核销失败', 'Cancellazione fallita', 1),
(5194, 5, '400155', '订单金额必须填写', 'È necessario compilare l`importo dell`ordine', 1),
(5195, 5, '400156', '请选择需要删除的订单', 'Seleziona l`ordine da eliminare', 1),
(5196, 5, '400157', '您选择的的订单存在用户未删除的订单', 'L`ordine che hai selezionato ha un ordine non cancellato dall`utente', 1),
(5197, 5, '400158', '请选择发货商品', 'Seleziona l`articolo da spedire', 1),
(5198, 5, '400159', '请重新选择发货商品或发货件数', 'Selezionare nuovamente il prodotto o il numero di pezzi da spedire', 1),
(5199, 5, '400160', '订单已删除无法退积分', 'L`ordine è stato cancellato e i punti non possono essere rimborsati', 1),
(5200, 5, '400161', '请输入积分', 'Inserisci punti', 1),
(5201, 5, '400162', '已退完积分', 'I punti sono stati rimborsati', 1),
(5202, 5, '400163', '退积分大于支付积分，请修改退积分', 'I punti rimborsati sono maggiori dei punti pagati, si prega di modificare i punti rimborsati', 1),
(5203, 5, '400164', '退积分成功', 'Ritiro di punti riuscito', 1),
(5204, 5, '400165', '退积分失败', 'Impossibile prelevare punti', 1),
(5205, 5, '400166', '请填写开票号', 'Compila il numero della fattura', 1),
(5206, 5, '400167', '请填写正确的开票号', 'Inserisci il numero di fatturazione corretto', 1),
(5207, 5, '400168', '请上传文件', 'Carica il file', 1),
(5208, 5, '400169', '回复成功', 'Risposta riuscita', 1),
(5209, 5, '400170', '注册成功', 'Registrazione riuscita', 1),
(5210, 5, '400171', '注册失败', 'Registrazione fallita', 1),
(5211, 5, '400172', '登录失败', 'Accesso fallito', 1),
(5212, 5, '400173', '获取套餐列表失败', 'Impossibile ottenere l`elenco dei pacchetti', 1),
(5213, 5, '400174', '获取支付码失败', 'Impossibile ottenere il codice di pagamento', 1),
(5214, 5, '400175', '请先开通短信服务', 'Si prega di attivare prima il servizio SMS', 1),
(5215, 5, '400176', '请先开通物流查询服务', 'Apri prima il servizio di richiesta logistica', 1),
(5216, 5, '400177', '请先开通电子面单打印服务', 'Si prega di attivare prima il servizio di stampa di scontrini elettronici', 1),
(5217, 5, '400178', '请先开通商品采集服务', 'Si prega di attivare prima il servizio di ritiro merce', 1),
(5218, 5, '400179', '请设置短信签名', 'Imposta firma SMS', 1),
(5219, 5, '400180', '修改短信签名成功', 'Modifica con successo la firma SMS', 1),
(5220, 5, '400181', '默认模板不能删除', 'Impossibile eliminare il modello predefinito', 1),
(5221, 5, '400182', '管理员信息读取失败', 'Impossibile leggere le informazioni dell`amministratore', 1),
(5222, 5, '400183', '密码太过简单，请输入较为复杂的密码', 'La password è troppo semplice, inserisci una password più complessa', 1),
(5223, 5, '400184', '协议类型不存在', 'Il tipo di protocollo non esiste', 1),
(5224, 5, '400185', '清除成功', 'Cancella con successo', 1),
(5225, 5, '400186', '清除失败', 'Eliminazione fallita', 1),
(5226, 5, '400187', '请输入名称', 'Inserisci un nome', 1),
(5227, 5, '400188', '请不要重复添加', 'Per favore non aggiungere altro', 1),
(5228, 5, '400189', '添加数据成功', 'Aggiungi dati con successo', 1),
(5229, 5, '400190', '请输入开始时间', 'Inserisci l`ora di inizio', 1),
(5230, 5, '400191', '请输入持续时间', 'Inserisci una durata', 1),
(5231, 5, '400192', '请输入0-23点之前的整点数', 'Inserisci il numero intero prima di 0-23', 1),
(5232, 5, '400193', '请输入1-24点之前的整点数', 'Inserisci il numero intero prima di 1-24', 1),
(5233, 5, '400194', '开始时间+持续时间不能大于24小时', 'Ora inizio + durata non può essere maggiore di 24 ore', 1),
(5234, 5, '400195', '时段已占用', 'La fascia oraria è occupata', 1),
(5235, 5, '400196', '请输入签到赠送积分', 'Inserisci i punti bonus check-in', 1),
(5236, 5, '400197', '请输入大于等于0的整数', 'Inserisci un numero intero maggiore o uguale a 0', 1),
(5237, 5, '400198', '请填写按钮名称', 'Inserisci il nome del pulsante', 1),
(5238, 5, '400199', '没有查到此身份', 'L`identità non è stata trovata', 1),
(5239, 5, '400200', '请输入等级名称', 'Inserisci il nome del livello', 1),
(5240, 5, '400201', '请输入等级', 'Inserisci il livello', 1),
(5241, 5, '400202', '请选择等级图标', 'Seleziona l`icona del livello', 1),
(5242, 5, '400203', '二级返佣比例不能大于一级', 'L`aliquota dello sconto di secondo livello non può essere maggiore del primo livello', 1),
(5243, 5, '400204', '当前等级已存在', 'Il livello attuale esiste già', 1),
(5244, 5, '400205', '添加等级成功', 'Aggiungi livello con successo', 1),
(5245, 5, '400206', '编辑的等级不存在', 'Il livello modificato non esiste', 1),
(5246, 5, '400207', '请输入任务名称', 'Inserisci il nome dell`attività', 1),
(5247, 5, '400208', '请选择任务类型', 'Seleziona un tipo di attività', 1),
(5248, 5, '400209', '请输入限定数量', 'Inserisci una quantità limitata', 1),
(5249, 5, '400210', '添加任务成功', 'Aggiungi attività con successo', 1),
(5250, 5, '400211', '编辑的任务不存在', 'L`attività modificata non esiste', 1),
(5251, 5, '400212', '获取推广二维码失败，请检查您的微信配置', 'Impossibile ottenere il codice QR della promozione, controlla la configurazione di WeChat', 1),
(5252, 5, '400213', '上级推广人不能为自己', 'I promotori superiori non possono essere se stessi', 1),
(5253, 5, '400214', '用户不存在', 'L`utente non esiste', 1),
(5254, 5, '400215', '上级用户不存在', 'L`utente superiore non esiste', 1),
(5255, 5, '400216', '当前推广人已经是所选人', 'L`attuale promotore è già selezionato', 1),
(5256, 5, '400217', '上级推广人不能为自己下级', 'I promotori superiori non possono essere loro subordinati', 1),
(5257, 5, '400218', '赠送成功', 'Regalo riuscito', 1),
(5258, 5, '400219', '赠送失败', 'Regalo fallito', 1),
(5259, 5, '400220', '请输入身份名称', 'Inserisci il nome dell`identità', 1),
(5260, 5, '400221', '请选择最少一个权限', 'Seleziona almeno un`autorizzazione', 1),
(5261, 5, '400222', '添加身份成功', 'Aggiungi identità con successo', 1),
(5262, 5, '400223', '添加身份失败', 'Impossibile aggiungere identità', 1),
(5263, 5, '400224', '缺少APPID', 'APPID mancante', 1),
(5264, 5, '400225', '请先设置空间域名', 'Imposta prima il nome del dominio dello spazio', 1),
(5265, 5, '400226', '格式错误，请输入格式为：http://域名', 'Errore di formattazione, inserisci il formato: http://nome dominio', 1),
(5266, 5, '400227', '未有正在使用的存储空间', 'Nessuno spazio di archiviazione in uso', 1),
(5267, 5, '400228', '切换云存储成功,请检查是否开启使用了存储空间', 'Passaggio riuscito al cloud storage, controlla se lo spazio di archiviazione è abilitato', 1),
(5268, 5, '400229', '切换本地存储成功', 'Cambia memoria locale con successo', 1),
(5269, 5, '400230', '请输入模板编号', 'Inserisci il numero del modello', 1),
(5270, 5, '400231', '请输入模板编号已存在,请重新输入', 'Inserisci il numero del modello già esistente, per favore reinserisci', 1),
(5271, 5, '400232', '请输入模板ID', 'Inserisci l`ID del modello', 1),
(5272, 5, '400233', '请输入模板名', 'Inserisci il nome del modello', 1),
(5273, 5, '400234', '请输入回复内容', 'Inserisci il contenuto della risposta', 1),
(5274, 5, '400235', '添加模板消息成功', 'Aggiungi messaggio modello riuscito', 1),
(5275, 5, '400236', '请先配置小程序appid、appSecret等参数', 'Configura prima l`applet appid, appSecret e altri parametri', 1),
(5276, 5, '400237', '二维码生成失败', 'Impossibile generare codice QR', 1),
(5277, 5, '400238', '请添加至少一个按钮', 'Aggiungi almeno un pulsante', 1),
(5278, 5, '400239', '请输入关键字', 'Inserisci una parola chiave', 1),
(5279, 5, '400240', '请选择回复类型', 'Seleziona un tipo di risposta', 1),
(5280, 5, '400241', '回复类型有误', 'Tipo di risposta errato', 1),
(5281, 5, '400242', '回复消息参数有误', 'Il parametro del messaggio di risposta non è corretto', 1),
(5282, 5, '400243', '请添加图文', 'Aggiungi grafica', 1),
(5283, 5, '400244', '标题不能为空', 'Il titolo non può essere vuoto', 1),
(5284, 5, '400245', '作者不能为空', 'L`autore non può essere vuoto', 1),
(5285, 5, '400246', '正文不能为空', 'Il testo non può essere vuoto', 1),
(5286, 5, '400247', '摘要不能为空', 'Il riepilogo non può essere vuoto', 1),
(5287, 5, '400248', '请先配置微信公众号appid、appSecret等参数', 'Configura prima l`appid dell`account pubblico WeChat, appSecret e altri parametri', 1),
(5288, 5, '400249', '模版消息一键设置成功', 'L`impostazione del messaggio modello con un clic è riuscita', 1),
(5289, 5, '400250', '请选择用户', 'Seleziona un utente', 1),
(5290, 5, '400251', '该用户没有绑定手机号，请手动填写', 'L`utente non è vincolato a un numero di cellulare, si prega di compilare manualmente', 1),
(5291, 5, '400252', '手机号格式错误', 'Errore nel formato del numero di cellulare', 1),
(5292, 5, '400253', '客服已存在', 'Il servizio clienti esiste già', 1),
(5293, 5, '400254', '请输入账号', 'Inserisci il numero di conto', 1),
(5294, 5, '400255', '账号必须为数字或者字母的组合4-30位', 'Il numero di conto deve essere una combinazione di 4-30 cifre o lettere', 1),
(5295, 5, '400256', '请输入密码', 'Inserisci la tua password', 1),
(5296, 5, '400257', '密码必须为数字或者字母的组合6-20位', 'La password deve essere una combinazione di 6-20 cifre o lettere', 1),
(5297, 5, '400258', '该手机号的客服已存在', 'Il servizio clienti per questo numero di telefono esiste già', 1),
(5298, 5, '400259', '该客服账号已存在', 'L`account del servizio clienti esiste già', 1),
(5299, 5, '400260', '客服添加成功', 'Servizio clienti aggiunto con successo', 1),
(5300, 5, '400261', '客服添加失败', 'Impossibile aggiungere il servizio clienti', 1),
(5301, 5, '400262', '客服名称不能为空', 'Il nome del servizio clienti non può essere vuoto', 1),
(5302, 5, '400263', '请输入确认密码', 'Inserisci la password di conferma', 1),
(5303, 5, '400264', '两次输入的密码不一致', 'Le password inserite due volte non sono coerenti', 1),
(5304, 5, '400265', '用户不存在，客服将强制禁止登录', 'L`utente non esiste, il servizio clienti vieterà forzatamente l`accesso', 1),
(5305, 5, '400266', '登录的客服不存在', 'Il servizio clienti connesso non esiste', 1),
(5306, 5, '400267', '请先填写客服账号和密码再尝试进入客服平台', 'Compila l`account del servizio clienti e la password prima di provare ad accedere alla piattaforma del servizio clienti', 1),
(5307, 5, '400268', '反馈内容不存在', 'Il contenuto del feedback non esiste', 1),
(5308, 5, '400269', '话术不能重复添加', 'Le parole non possono essere aggiunte ripetutamente', 1),
(5309, 5, '400270', '创建话术成功', 'Riuscito a creare un discorso', 1),
(5310, 5, '400271', '创建话术失败', 'Impossibile creare un discorso', 1),
(5311, 5, '400272', '删除的话术不存在', 'Le parole cancellate non esistono', 1),
(5312, 5, '400273', '系统分类不能删除', 'Impossibile eliminare la classificazione del sistema', 1),
(5313, 5, '400274', '请输入配置名称', 'Inserisci un nome di configurazione', 1),
(5314, 5, '400275', '请输入字段名称', 'Inserisci il nome del campo', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(5315, 5, '400276', '请输入配置简介', 'Inserisci il profilo di configurazione', 1),
(5316, 5, '400277', '请输入文本框的宽度', 'Inserisci la larghezza della casella di testo', 1),
(5317, 5, '400278', '请输入正确的文本框的宽度', 'Inserisci la larghezza corretta della casella di testo', 1),
(5318, 5, '400279', '请输入多行文本框的宽度', 'Inserisci la larghezza della casella di testo su più righe', 1),
(5319, 5, '400280', '请输入多行文本框的高度', 'Inserisci l`altezza della casella di testo su più righe', 1),
(5320, 5, '400281', '请输入正确的多行文本框的宽度', 'Inserisci la larghezza corretta della casella di testo su più righe', 1),
(5321, 5, '400282', '请输入正确的多行文本框的宽度', 'Inserisci la larghezza corretta della casella di testo su più righe', 1),
(5322, 5, '400283', '请输入配置参数', 'Inserisci parametri di configurazione', 1),
(5323, 5, '400284', '添加配置成功', 'Aggiungi configurazione con successo', 1),
(5324, 5, '400285', '一二级返佣比例不能大于100%', 'Il rapporto di sconto di primo e secondo livello non può essere maggiore del 100%', 1),
(5325, 5, '400286', '分销海报不能多于5张', 'Non più di 5 manifesti di distribuzione', 1),
(5326, 5, '400287', '提现最低金额只能为数字', 'L`importo minimo di prelievo può essere solo un numero', 1),
(5327, 5, '400288', '满额分销最低金额不能为空', 'L`importo minimo per la distribuzione completa non può essere vuoto', 1),
(5328, 5, '400289', '满额分销最低金额不能小于0', 'L`importo minimo della distribuzione completa non può essere inferiore a 0', 1),
(5329, 5, '400290', '绑定有效期请填写正整数', 'Compila un numero intero positivo per il periodo di validità vincolante', 1),
(5330, 5, '400291', '请输入标题', 'Inserisci un titolo', 1),
(5331, 5, '400292', '添加配置分类成功', 'Aggiungi categoria di configurazione con successo', 1),
(5332, 5, '400293', '存在下级配置，无法删除', 'La configurazione subordinata esiste e non può essere eliminata', 1),
(5333, 5, '400294', '字段至少存在一个', 'Esiste almeno un campo', 1),
(5334, 5, '400295', '添加数据组成功', 'Aggiungi gruppo di dati con successo', 1),
(5335, 5, '400296', '数据关键字已存在', 'La chiave dati esiste già', 1),
(5336, 5, '400297', '字段不能为空', 'Il campo non può essere vuoto', 1),
(5337, 5, '400298', '不能大于四个', 'Non possono essere più di quattro', 1),
(5338, 5, '400299', '签到天数配置不能大于7天', 'La configurazione dei giorni di check-in non può essere maggiore di 7 giorni', 1),
(5339, 5, '400300', '关联成功', 'Associato con successo', 1),
(5340, 5, '400301', '关联失败', 'Associazione fallita', 1),
(5341, 5, '400302', '数据缓存刷新成功', 'Aggiornamento cache dati riuscito', 1),
(5342, 5, '400303', '数据缓存刷新失败', 'Aggiornamento cache dati fallito', 1),
(5343, 5, '400304', '请输入需要更换的域名', 'Inserisci il nome di dominio da modificare', 1),
(5344, 5, '400305', '域名不合法', 'Il nome di dominio non è valido', 1),
(5345, 5, '400306', '替换成功', 'Sostituzione riuscita', 1),
(5346, 5, '400307', '初始化完成', 'Inizializzazione completata', 1),
(5347, 5, '400308', '备份文件可能已经损坏，请检查', 'Il file di backup potrebbe essere danneggiato, per favore controlla', 1),
(5348, 5, '400309', '还原数据出错', 'Errore ripristino dati', 1),
(5349, 5, '400310', '正在还原...', 'Ripristino...', 1),
(5350, 5, '400311', '还原完成', 'Ripristino completato', 1),
(5351, 5, '400312', '权益编辑成功', 'Modifica del patrimonio con successo', 1),
(5352, 5, '400313', '卡片生成成功', 'Carta generata con successo', 1),
(5353, 5, '400314', '手机号已经存在', 'Il numero di telefono esiste già', 1),
(5354, 5, '400315', '请输入正确的身份证', 'Inserisci la carta d`identità corretta', 1),
(5355, 5, '400316', '请选择分组', 'Seleziona un gruppo', 1),
(5356, 5, '400317', '请选择标签', 'Seleziona un`etichetta', 1),
(5357, 5, '400318', '加入消息队列成功', 'Unisciti alla coda dei messaggi con successo', 1),
(5358, 5, '400319', '注销成功', 'Logout riuscito', 1),
(5359, 5, '400320', '拒绝注销', 'Disconnessione rifiutata', 1),
(5360, 5, '400321', '请输入分组名称', 'Inserisci il nome di un gruppo', 1),
(5361, 5, '400322', '会员标签不能为空', 'Il tag membro non può essere vuoto', 1),
(5362, 5, '400323', '该分类下有标签，请先删除标签', 'C`è un`etichetta in questa categoria, per favore cancella prima l`etichetta', 1),
(5363, 5, '400324', '请输入等级名称', 'Inserisci il nome del livello', 1),
(5364, 5, '400325', '请输入等级', 'Inserisci il livello', 1),
(5365, 5, '400326', '请输入等级说明', 'Inserisci la descrizione del livello', 1),
(5366, 5, '400327', '请上传等级图标', 'Si prega di caricare l`icona del livello', 1),
(5367, 5, '400328', '请上传等级背景图标', 'Carica l`icona dello sfondo del livello', 1),
(5368, 5, '400329', '请输入升级经验值', 'Inserisci il valore dell`esperienza di aggiornamento', 1),
(5369, 5, '400330', '授权成功，写入数据库失败，请检查数据库链接配置', 'Autorizzazione riuscita, ma non è stato possibile scrivere nel database, verificare la configurazione del collegamento al database', 1),
(5370, 5, '400331', '请填写公司名称', 'Compila il nome dell`azienda', 1),
(5371, 5, '400332', '请填写授权域名', 'Compila il nome di dominio autorizzato', 1),
(5372, 5, '400333', '请填写手机号码', 'Compila il numero di telefono', 1),
(5373, 5, '400334', '请填写订单id', 'Compila l`ID dell`ordine', 1),
(5374, 5, '400335', '申请授权成功', 'Richiesta autorizzazione riuscita', 1),
(5375, 5, '400336', '验证码错误', 'Errore codice di verifica', 1),
(5376, 5, '400337', '请选择商品', 'Seleziona un elemento', 1),
(5377, 5, '400338', '请输入商品名称', 'Inserisci il nome del prodotto', 1),
(5378, 5, '400339', '请选择背景图', 'Seleziona un`immagine di sfondo', 1),
(5379, 5, '400340', '请输入直播价格', 'Inserisci il prezzo della trasmissione in diretta', 1),
(5380, 5, '400341', '直播价格必须大于0', 'Il prezzo della trasmissione in diretta deve essere maggiore di 0', 1),
(5381, 5, '400342', '请输入直播间名称', 'Inserisci il nome della sala di trasmissione in diretta', 1),
(5382, 5, '400343', '请选择背景图', 'Seleziona un`immagine di sfondo', 1),
(5383, 5, '400344', '请选择分享图', 'Seleziona un`immagine da condividere', 1),
(5384, 5, '400345', '请选择主播', 'Seleziona un`ancora', 1),
(5385, 5, '400346', '请选择直播开始、结束时间', 'Selezionare l`ora di inizio e di fine della trasmissione in diretta', 1),
(5386, 5, '400347', '请填写活动简介', 'Compila l`introduzione dell`evento', 1),
(5387, 5, '400348', '请填写单位', 'Compila l`unità', 1),
(5388, 5, '400349', '请选择商品轮播图', 'Seleziona il carosello dei prodotti', 1),
(5389, 5, '400350', '您设置得商品个数超出系统限制', 'Il numero di elementi che hai impostato supera il limite di sistema', 1),
(5390, 5, '400351', '模板不存在', 'Il modello non esiste', 1),
(5391, 5, '400352', '请输入页面名称', 'Inserisci il nome della pagina', 1),
(5392, 5, '400353', '请选择活动时间段', 'Seleziona un periodo di tempo dell`evento', 1),
(5393, 5, '400354', '请填写购买数量限制', 'Compila il limite della quantità di acquisto', 1),
(5394, 5, '400355', '购买数量限制必须大于0', 'Il limite della quantità di acquisto deve essere maggiore di 0', 1),
(5395, 5, '400356', '请填写帮砍次数', 'Compila il numero di tagli', 1),
(5396, 5, '400357', '帮砍次数必须大于0', 'Il numero di barre deve essere maggiore di 0', 1),
(5397, 5, '400358', '请填写砍价人数', 'Si prega di compilare il numero di contrattatori', 1),
(5398, 5, '400359', '砍价人数必须大于1', 'Il numero di persone che contraggono deve essere maggiore di 1', 1),
(5399, 5, '400360', '请选择运费模板', 'Seleziona un modello di spedizione', 1),
(5400, 5, '400361', '请填写商品详情', 'Compila i dettagli del prodotto', 1),
(5401, 5, '400362', '请选择规格', 'Seleziona una specifica', 1),
(5402, 5, '400363', '请填写虚拟拼团比例', 'Compila il rapporto del gruppo virtuale', 1),
(5403, 5, '400364', '虚拟参团人数不能大于成团人数', 'Il numero dei partecipanti virtuali non può essere maggiore del numero dei partecipanti al gruppo', 1),
(5404, 5, '400365', '虚拟参团人数不能大于成团人数', 'Il numero dei partecipanti virtuali non può essere maggiore del numero dei partecipanti', 1),
(5405, 5, '400366', '请填写单次购买数量', 'Compila la singola quantità di acquisto', 1),
(5406, 5, '400367', '单次购买数量必须大于0', 'La quantità di acquisto singola deve essere maggiore di 0', 1),
(5407, 5, '400368', '请填写成团人数', 'Inserisci il numero di persone nel gruppo', 1),
(5408, 5, '400369', '拼团人数不能小于2人', 'Il numero delle persone nel gruppo non può essere inferiore a 2', 1),
(5409, 5, '400370', '请填写成团有效期', 'Compila il periodo di validità del gruppo', 1),
(5410, 5, '400371', '成团有效期必须大于0', 'Il periodo di validità del gruppo deve essere maggiore di 0', 1),
(5411, 5, '400372', '请填写优惠券名称', 'Compila il nome del coupon', 1),
(5412, 5, '400373', '请选择商品分类', 'Seleziona una categoria di prodotto', 1),
(5413, 5, '400374', '请填写优惠券金额', 'Compila l`importo del coupon', 1),
(5414, 5, '400375', '请填写优惠券最小使用金额', 'Compila l`importo minimo di utilizzo del coupon', 1),
(5415, 5, '400376', '请填写优惠券有效期', 'Compila il periodo di validità del coupon', 1),
(5416, 5, '400377', '请选择秒杀时间段', 'Seleziona il periodo di seckill', 1),
(5417, 5, '400378', '请填写门店名称', 'Compila il nome del negozio', 1),
(5418, 5, '400379', '请填写门店简介', 'Compila il profilo del negozio', 1),
(5419, 5, '400380', '请填写门店电话', 'Compila il numero di telefono del negozio', 1),
(5420, 5, '400381', '请选择提货点logo', 'Seleziona il logo del punto di ritiro', 1),
(5421, 5, '400382', '请选择提货点大图', 'Seleziona un`immagine più grande del punto di raccolta', 1),
(5422, 5, '400383', '请选择地址', 'Seleziona un indirizzo', 1),
(5423, 5, '400384', '请填写详细地址', 'Si prega di compilare l`indirizzo dettagliato', 1),
(5424, 5, '400385', '请选择经纬度', 'Seleziona latitudine e longitudine', 1),
(5425, 5, '400386', '请选择营业时间', 'Selezionare l`orario di lavoro', 1),
(5426, 5, '400387', '短信账号必须填写', 'Il numero di conto SMS deve essere inserito', 1),
(5427, 5, '400388', '短信密码必须填写', 'La password SMS deve essere inserita', 1),
(5428, 5, '400389', '订单号必须存在', 'Il numero d`ordine deve esistere', 1),
(5429, 5, '400390', '订单号有误', 'Il numero d`ordine non è corretto', 1),
(5430, 5, '400391', '订单号必须为字母和数字', 'Il numero d`ordine deve essere alfanumerico', 1),
(5431, 5, '400392', '订单金额必须填写', 'L`importo dell`ordine deve essere compilato', 1),
(5432, 5, '400393', '订单金额必须为数字', 'L`importo dell`ordine deve essere un numero', 1),
(5433, 5, '400394', '订单金额必须填写', 'È necessario compilare l`importo dell`ordine', 1),
(5434, 5, '400395', '订单金额必须为数字', 'L`importo dell`ordine deve essere un numero', 1),
(5435, 5, '400396', '订单邮费必须填写', 'L`affrancatura dell`ordine deve essere compilata', 1),
(5436, 5, '400397', '订单邮费必须为数字', 'La spedizione dell`ordine deve essere un numero', 1),
(5437, 5, '400398', '赠送积分必须为数字', 'I punti regalo devono essere numeri', 1),
(5438, 5, '400399', '请选择用户头像', 'Seleziona avatar utente', 1),
(5439, 5, '400400', '请输入公司名称', 'Inserisci il nome dell`azienda', 1),
(5440, 5, '400401', '添加公司成功', 'Aggiungi azienda con successo', 1),
(5441, 5, '400402', '请输入月结账号', 'Inserisci il numero di conto mensile', 1),
(5442, 5, '400403', '请输入月结密码', 'Inserisci la password mensile', 1),
(5443, 5, '400404', '请输入取件网点', 'Inserisci il luogo di ritiro', 1),
(5444, 5, '400405', '缩略图大图尺寸（高）必须为数字', 'La dimensione dell`immagine grande della miniatura (altezza) deve essere un numero', 1),
(5445, 5, '400406', '缩略图大图尺寸（高）必须大于等于0', 'La dimensione dell`immagine grande della miniatura (altezza) deve essere maggiore o uguale a 0', 1),
(5446, 5, '400407', '缩略图大图尺寸（宽）必须为数字', 'La dimensione dell`immagine grande della miniatura (larghezza) deve essere un numero', 1),
(5447, 5, '400408', '缩略图大图尺寸（宽）必须大于等于0', 'La dimensione dell`immagine grande (larghezza) della miniatura deve essere maggiore o uguale a 0', 1),
(5448, 5, '400409', '缩略图中图尺寸（高）必须为数字', 'La dimensione dell`immagine (altezza) nella miniatura deve essere un numero', 1),
(5449, 5, '400410', '缩略图中图尺寸（高）必须大于等于0', 'La dimensione dell`immagine (altezza) nella miniatura deve essere maggiore o uguale a 0', 1),
(5450, 5, '400411', '缩略图中图尺寸（宽）必须为数字', 'La dimensione (larghezza) dell`immagine nella miniatura deve essere un numero', 1),
(5451, 5, '400412', '缩略图中图尺寸（宽）必须大于等于0', 'La dimensione dell`immagine (larghezza) nella miniatura deve essere maggiore o uguale a 0', 1),
(5452, 5, '400413', '缩略图小图尺寸（高）必须为数字', 'La dimensione della miniatura (altezza) deve essere un numero', 1),
(5453, 5, '400414', '缩略图小图尺寸（高）必须大于等于0', 'La dimensione della miniatura (altezza) deve essere maggiore o uguale a 0', 1),
(5454, 5, '400415', '缩略图小图尺寸（宽）必须为数字', 'La dimensione della miniatura (larghezza) deve essere un numero', 1),
(5455, 5, '400416', '缩略图小图尺寸（宽）必须大于等于0', 'La dimensione della miniatura (larghezza) deve essere maggiore o uguale a 0', 1),
(5456, 5, '400417', '水印文字只能是汉字、字母、数字', 'Il testo della filigrana può essere solo caratteri cinesi, lettere, numeri', 1),
(5457, 5, '400418', '水印文字长度为1-10位', 'La lunghezza del testo della filigrana è di 1-10 cifre', 1),
(5458, 5, '400419', '水印文字大小必须为数字', 'La dimensione del testo della filigrana deve essere un numero', 1),
(5459, 5, '400420', '水印文字大小必须大于等于0', 'La dimensione del testo della filigrana deve essere maggiore o uguale a 0', 1),
(5460, 5, '400421', '水印横坐标偏移量必须为数字', 'L`offset dell`ascissa della filigrana deve essere un numero', 1),
(5461, 5, '400422', '水印横坐标偏移量必须大于等于0', 'L`offset dell`ascissa della filigrana deve essere maggiore o uguale a 0', 1),
(5462, 5, '400423', '水印纵坐标偏移量必须为数字', 'L`offset dell`ordinata della filigrana deve essere un numero', 1),
(5463, 5, '400424', '水印纵坐标偏移量必须大于等于0', 'L`offset dell`ordinata della filigrana deve essere maggiore o uguale a 0', 1),
(5464, 5, '400425', '该主播已经存在', 'L`host esiste già', 1),
(5465, 5, '400426', '请先去小程序认证主播', 'Vai all`applet per autenticare prima l`ancora', 1),
(5466, 5, '400427', '商品已创建', 'L`oggetto è stato creato', 1),
(5467, 5, '400428', '审核中或审核失败不允许此操作', 'Questa operazione non è consentita in fase di revisione o revisione non riuscita', 1),
(5468, 5, '400429', '在审核中或已经审核通过', 'In corso di revisione o approvato', 1),
(5469, 5, '400430', '审核通过或失败', 'Approvazione superata o non riuscita', 1),
(5470, 5, '400431', '商品审核中，无法删除', 'Il prodotto è in fase di revisione e non può essere cancellato', 1),
(5471, 5, '400432', '该主播不存在', 'L`host non esiste', 1),
(5472, 5, '400433', '开播时间需要在当前时间的10分钟后，并且开始时间不能在6个月后', 'L`ora di trasmissione deve essere 10 minuti dopo l`ora corrente e l`ora di inizio non può essere 6 mesi dopo', 1),
(5473, 5, '400434', '开播时间和结束时间间隔不得短于30分钟，不得超过24小时', 'L`intervallo tra l`ora di inizio e l`ora di fine non deve essere inferiore a 30 minuti e non deve superare le 24 ore', 1),
(5474, 5, '400435', '请输入理由', 'Inserisci il motivo', 1),
(5475, 5, '400436', '请选择正确的直播商品', 'Seleziona il prodotto live corretto', 1),
(5476, 5, '400437', '直播间状态有误', 'Lo stato della live room non è corretto', 1),
(5477, 5, '400438', '奖品不存在', 'Il premio non esiste', 1),
(5478, 5, '400439', '写入中奖记录失败', 'Impossibile scrivere record di vincita', 1),
(5479, 5, '400440', '请继续参与活动抽奖', 'Continua a partecipare all`estrazione fortunata', 1),
(5480, 5, '400441', '已经领取成功', 'Ricevuto con successo', 1),
(5481, 5, '400442', '分销等级不存在', 'Il livello di distribuzione non esiste', 1),
(5482, 5, '400443', '选择的等级不存在', 'Il livello selezionato non esiste', 1),
(5483, 5, '400444', '该等级已存在此类型任务', 'Questo tipo di attività esiste già a questo livello', 1),
(5484, 5, '400445', '不能小于低等级同类型任务限定数量', 'Non può essere inferiore al numero limitato di attività di basso livello dello stesso tipo', 1),
(5485, 5, '400446', '不能大于高等级同类型任务限定数量', 'Non può essere maggiore del numero di attività di alto livello dello stesso tipo', 1),
(5486, 5, '400447', '解除失败', 'Rilascio fallito', 1),
(5487, 5, '400448', '代理商佣金比例不能大于事业部佣金比例', 'Il rapporto di commissione dell`agente non può essere maggiore del rapporto di commissione di divisione', 1),
(5488, 5, '400449', '代理商到期时间不能大于事业部到期时间', 'Il tempo di scadenza dell`agente non può essere maggiore del tempo di scadenza della divisione', 1),
(5489, 5, '400450', '请填写用户UID', 'Compila l`UID utente', 1),
(5490, 5, '400451', '管理员信息未查到', 'Informazioni amministratore non trovate', 1),
(5491, 5, '400452', '管理员已经删除', 'L`amministratore è stato cancellato', 1),
(5492, 5, '400453', '管理员姓名不能为空', 'Il nome dell`amministratore non può essere vuoto', 1),
(5493, 5, '400454', '该分类有下级分类，无法删除', 'Questa categoria ha delle sottocategorie e non può essere cancellata', 1),
(5494, 5, '400455', '该分类下有文章，无法删除', 'Ci sono articoli in questa categoria e non possono essere cancellati', 1),
(5495, 5, '400456', '请稍后查看', 'Verifica più tardi', 1),
(5496, 5, '400457', '默认模板不能删除', 'Impossibile eliminare il modello predefinito', 1),
(5497, 5, '400458', '该模板使用中，无法删除', 'Questo modello è in uso e non può essere cancellato', 1),
(5498, 5, '400459', '个人中心模板不存在', 'Il modello del centro personale non esiste', 1),
(5499, 5, '400460', '反馈内容没有查到', 'Contenuto di feedback non trovato', 1),
(5500, 5, '400461', '您修改的话术内容不存在', 'Il contenuto delle parole che hai modificato non esiste', 1),
(5501, 5, '400462', '短信平台：{:msg}', 'Piattaforma SMS: {:msg}', 1),
(5502, 5, '400463', '订单商品获取失败,无法打印', 'Impossibile ottenere l`articolo dell`ordine, impossibile stampare', 1),
(5503, 5, '400464', '小票打印未开启', 'La stampa dello scontrino non è abilitata', 1),
(5504, 5, '400465', '请先配置小票打印开发者', 'Configura prima lo sviluppatore della stampa delle ricevute', 1),
(5505, 5, '400466', '请选择图片', 'Seleziona un`immagine', 1),
(5506, 5, '400467', '配送员已存在', 'Il fattorino esiste già', 1),
(5507, 5, '400468', '同一个手机号的配送员只能添加一个', 'Può essere aggiunto un solo corriere con lo stesso numero di cellulare', 1),
(5508, 5, '400469', '配送员名称不能为空', 'Il nome del corriere non può essere vuoto', 1),
(5509, 5, '400470', '订单未能查到,不能发货', 'Impossibile trovare l`ordine e non può essere spedito', 1),
(5510, 5, '400471', '订单已删除,不能发货', 'L`ordine è stato cancellato e non può essere spedito', 1),
(5511, 5, '400472', '订单已发货请勿重复操作', 'L`ordine è stato spedito, si prega di non ripetere l`operazione', 1),
(5512, 5, '400473', '核销订单不能发货', 'L`ordine verificato non può essere spedito', 1),
(5513, 5, '400474', '拼团未完成暂不能发货', 'Il gruppo non può essere spedito temporaneamente', 1),
(5514, 5, '400475', '订单有售后申请请先处理', 'L`ordine ha un`applicazione post-vendita, si prega di elaborarla prima', 1),
(5515, 5, '400476', '快递公司编缺失', 'Manca il corriere', 1),
(5516, 5, '400477', '请填写寄件人电话', 'Inserisci il numero di telefono del mittente', 1),
(5517, 5, '400478', '请填写寄件人地址', 'Inserisci l`indirizzo del mittente', 1),
(5518, 5, '400479', '虚拟发货，无需修改发货信息', 'Consegna virtuale, non è necessario modificare le informazioni di consegna', 1),
(5519, 5, '400480', '未发货，请先发货再修改配送信息', 'Non spedito, spedisci prima e poi modifica le informazioni di consegna', 1),
(5520, 5, '400481', '自提订单无法打印', 'Impossibile stampare l`ordine di ritiro automatico', 1),
(5521, 5, '400482', '请先发货', 'Per favore spedisci prima', 1),
(5522, 5, '400483', '请先在系统设置中打开单子面单打印开关', 'Attiva prima l`interruttore di stampa su un solo lato nelle impostazioni di sistema', 1),
(5523, 5, '400484', '发票已申请，正在审核打印中', 'La fattura è stata richiesta ed è in corso di revisione e stampa', 1),
(5524, 5, '400485', '订单已退款', 'Ordine rimborsato', 1),
(5525, 5, '400486', '正在申请退款中', 'Richiesta di rimborso', 1),
(5526, 5, '400487', '申请失败', 'Applicazione non riuscita', 1),
(5527, 5, '400488', '未支付无法退款', 'Nessun rimborso se non pagato', 1),
(5528, 5, '400489', '回退积分和优惠券失败', 'Impossibile ripristinare punti e coupon', 1),
(5529, 5, '400490', '拼团修改失败', 'Modifica gruppo fallita', 1),
(5530, 5, '400491', '回退佣金失败', 'Impossibile ripristinare la commissione', 1),
(5531, 5, '400492', '余额退款失败', 'Rimborso saldo fallito', 1),
(5532, 5, '400493', '购买的优惠券已使用或者已过期', 'Il coupon acquistato è stato utilizzato o è scaduto', 1),
(5533, 5, '400494', '回退积分增加失败', 'Impossibile aumentare i punti di rollback', 1),
(5534, 5, '400495', '售后订单不存在', 'L`ordine post vendita non esiste', 1),
(5535, 5, '400496', '积分已退或者积分为零无法再退', 'I punti sono stati rimborsati oppure i punti non possono essere rimborsati se i punti sono zero', 1),
(5536, 5, '400497', '未支付无法退积分', 'I punti non possono essere rimborsati senza pagamento', 1),
(5537, 5, '400498', '订单退积分失败', 'Rimborso punti per ordine non riuscito', 1),
(5538, 5, '400499', '请输入拒绝退款理由', 'Inserisci il motivo del rifiuto del rimborso', 1),
(5539, 5, '400500', '限制单次购买数量不能大于总购买数量', 'La singola quantità di acquisto non può essere maggiore della quantità totale di acquisto', 1),
(5540, 5, '400501', '请添加抽奖活动名称', 'Aggiungi il nome dell`estrazione fortunata', 1),
(5541, 5, '400502', '请添加抽奖描述等文案', 'Aggiungi una descrizione della lotteria e un`altra copia', 1),
(5542, 5, '400503', '活动结束时间必须大于开始时间', 'L`ora di fine dell`evento deve essere maggiore dell`ora di inizio', 1),
(5543, 5, '400504', '请添加奖品', 'Aggiungi un premio', 1),
(5544, 5, '400505', '请填写消耗数量', 'Compila la quantità di consumo', 1),
(5545, 5, '400506', '商品参与其他活动开启，无法开启预售', 'La partecipazione delle merci ad altre attività è abilitata, non è possibile aprire la prevendita', 1),
(5546, 5, '400507', '活动结束时间不能小于当前时间', 'L`ora di fine dell`evento non può essere inferiore all`ora corrente', 1),
(5547, 5, '400508', '活动已结束,请重新添加或复制', 'L`evento è terminato, aggiungi nuovamente o copia', 1),
(5548, 5, '400509', '添加优惠券成功', 'Aggiungi coupon con successo', 1),
(5549, 5, '400510', '发布优惠劵成功', 'Buoni emessi con successo', 1),
(5550, 5, '400511', '砍价最低价不能大于或等于起始金额', 'Il prezzo di contrattazione più basso non può essere maggiore o uguale all`importo di partenza', 1),
(5551, 5, '400512', '砍价人数不能大于{:num}人', 'Il numero di persone che contraggono non può essere maggiore di {:num}', 1),
(5552, 5, '400513', '使用开始时间不能小于领取开始时间', 'L`ora di inizio utilizzo non può essere inferiore all`ora di inizio raccolta', 1),
(5553, 5, '400514', '使用结束时间不能小于领取结束时间', 'L`ora di fine utilizzo non può essere inferiore all`ora di fine raccolta', 1),
(5554, 5, '400515', '优惠券不存在', 'Il coupon non esiste', 1),
(5555, 5, '400516', '领取的优惠劵已领完或已过期', 'I coupon che hai ricevuto sono esauriti o sono scaduti', 1),
(5556, 5, '400517', '已领取过该优惠劵', 'Il coupon è stato ricevuto', 1),
(5557, 5, '400518', '抱歉，优惠券已经领取完了', 'Siamo spiacenti, i coupon sono stati raccolti', 1),
(5558, 5, '400519', '选择用户已拥有该优惠券，请勿重复发放', 'Seleziona l`utente che possiede già il coupon, per favore non emetterlo ripetutamente', 1),
(5559, 5, '400520', '订单已删除', 'Ordine cancellato', 1),
(5560, 5, '400521', '订单已发货', 'Ordine spedito', 1),
(5561, 5, '400522', '暂时不支持其他发货类型', 'Temporaneamente non supportano altri tipi di consegna', 1),
(5562, 5, '400523', '请输入送货人姓名', 'Inserisci il nome del corriere', 1),
(5563, 5, '400524', '请输入送货人电话号码', 'Inserisci il numero di telefono del corriere', 1),
(5564, 5, '400525', '请输入送货人信息', 'Inserisci i dati del corriere', 1),
(5565, 5, '400526', '请输入正确的送货人电话号码', 'Inserisci il numero di telefono del corriere corretto', 1),
(5566, 5, '400527', '请选择电子面单模板', 'Seleziona un modello per la ricevuta elettronica', 1),
(5567, 5, '400528', '电子面单已关闭，请选择其他发货方式', 'La fattura elettronica è stata chiusa, scegli un altro metodo di spedizione', 1),
(5568, 5, '400529', '发货失败', 'Spedizione fallita', 1),
(5569, 5, '400530', '订单状态错误', 'Errore stato ordine', 1),
(5570, 5, '400531', '请输入快递单号', 'Inserisci il numero di tracciamento', 1),
(5571, 5, '400532', '请先发货再修改配送信息', 'Si prega di spedire prima e poi modificare le informazioni di consegna', 1),
(5572, 5, '400533', '商品不存在', 'L`oggetto non esiste', 1),
(5573, 5, '400534', '您查看的积分商品已被删除', 'L`elemento punti che hai visualizzato è stato cancellato', 1),
(5574, 5, '400535', '请添加商品', 'Aggiungi un prodotto', 1),
(5575, 5, '400536', '添加抽奖活动失败', 'Impossibile aggiungere lotterie', 1),
(5576, 5, '400537', '抽奖活动不存在', 'La lotteria non esiste', 1),
(5577, 5, '400538', '请填写奖品名称', 'Inserisci il nome del premio', 1),
(5578, 5, '400539', '请选择奖品图片', 'Seleziona l`immagine del premio', 1),
(5579, 5, '400540', '请填写奖品中奖权重', 'Inserisci il peso vincente del premio', 1),
(5580, 5, '400541', '请选择奖品类型', 'Seleziona il tipo di premio', 1),
(5581, 5, '400542', '请填写奖品赠送{:type}数', 'Compila il {:type} numero di premi', 1),
(5582, 5, '400543', '请选择优惠券', 'Seleziona un coupon', 1),
(5583, 5, '400544', '生成新订单失败', 'Impossibile generare nuovo ordine', 1),
(5584, 5, '400545', '修改原来订单商品拆分状态失败', 'Impossibile modificare lo stato di divisione dell`articolo dell`ordine originale', 1),
(5585, 5, '400546', '新增拆分订单商品信息失败', 'Impossibile aggiungere le informazioni sul prodotto per l`ordine diviso', 1),
(5586, 5, '400547', '保存新订单商品信息失败', 'Impossibile salvare le informazioni sul nuovo prodotto dell`ordine', 1),
(5587, 5, '400548', '协议类型缺失', 'Tipo di protocollo mancante', 1),
(5588, 5, '400549', '请填写协议名称', 'Compila il nome dell`accordo', 1),
(5589, 5, '400550', '请填写协议内容', 'Compila il contenuto dell`accordo', 1),
(5590, 5, '400551', '该类型协议已经存在', 'Questo tipo di protocollo esiste già', 1),
(5591, 5, '400552', '临时二维码获取错误', 'Errore durante l`ottenimento del codice QR temporaneo', 1),
(5592, 5, '400553', '永久二维码获取错误', 'Errore durante l`ottenimento del codice QR permanente', 1),
(5593, 5, '400554', '请先配置接口密钥', 'Configura prima la chiave di interfaccia', 1),
(5594, 5, '400555', '无法创建文件夹，请检查您的上传目录权限', 'Impossibile creare la cartella, controlla i permessi della directory di caricamento', 1),
(5595, 5, '400556', '商品参数错误', 'Errore parametro merce', 1),
(5596, 5, '400557', '上传方式错误', 'Metodo di caricamento errato', 1),
(5597, 5, '400558', '格式错误', 'Errore di formattazione', 1),
(5598, 5, '400559', '图片流获取失败', 'Impossibile ottenere il flusso di immagini', 1),
(5599, 5, '400560', '商品详情保存失败', 'Impossibile salvare i dettagli del prodotto', 1),
(5600, 5, '400561', '关联优惠券失败', 'Impossibile associare coupon', 1),
(5601, 5, '400562', '缺少商品ID', 'ID articolo mancante', 1),
(5602, 5, '400563', '缺少用户UID', 'UID utente mancante', 1),
(5603, 5, '400564', '缺少订单ID', 'ID ordine mancante', 1),
(5604, 5, '400565', '暂不支持该类型记录', 'Questo tipo di record non è attualmente supportato', 1),
(5605, 5, '400566', '添加商品记录失败', 'Impossibile aggiungere il record del prodotto', 1),
(5606, 5, '400567', '评论时间应小于当前时间', 'Il tempo del commento dovrebbe essere inferiore all`ora corrente', 1),
(5607, 5, '400568', '添加虚拟评论失败', 'Impossibile aggiungere commento virtuale', 1),
(5608, 5, '400569', '回复失败', 'Risposta non riuscita', 1),
(5609, 5, '400570', '请选择限购类型', 'Seleziona il tipo di restrizione all`acquisto', 1),
(5610, 5, '400571', '限购数量不能小于1', 'Il limite di acquisto non può essere inferiore a 1', 1),
(5611, 5, '400572', '一二级返佣相加不能大于商品售价', 'La somma del primo e del secondo sconto non può essere superiore al prezzo del prodotto', 1),
(5612, 5, '400573', '商品类型不能切换', 'Il tipo di prodotto non può essere cambiato', 1),
(5613, 5, '400574', '请输入规则名称', 'Inserisci il nome della regola', 1),
(5614, 5, '400575', '请输入属性名称', 'Inserisci il nome dell`attributo', 1),
(5615, 5, '400576', '请输入正确的属性', 'Inserisci l`attributo corretto', 1),
(5616, 5, '400577', '请填写正确的商品信息', 'Compila le informazioni corrette sul prodotto', 1),
(5617, 5, '400578', '请填写正确的商品价格', 'Inserisci il prezzo corretto del prodotto', 1),
(5618, 5, '400579', '请填写正确的商品库存', 'Compila l`inventario del prodotto corretto', 1),
(5619, 5, '400580', '请填写正确的商品成本价格', 'Si prega di inserire il prezzo di costo della merce corretto', 1),
(5620, 5, '400581', '请上传商品图片', 'Carica l`immagine del prodotto', 1),
(5621, 5, '400582', '{:name}规格不存在', 'La specifica {:name} non esiste', 1),
(5622, 5, '400583', '{:name}属性不存在', '{:name} l`attributo non esiste', 1),
(5623, 5, '400584', '请设置至少一个属性', 'Imposta almeno un attributo', 1),
(5624, 5, '400585', '商品参与秒杀活动开启，无法进行此操作', 'La partecipazione delle merci all`attività spike è abilitata, questa operazione non può essere eseguita', 1),
(5625, 5, '400586', '商品参与砍价活动开启，无法进行此操作', 'La partecipazione della merce alla contrattazione è abilitata, questa operazione non può essere eseguita', 1),
(5626, 5, '400587', '商品参与拼团活动开启，无法进行此操作', 'La partecipazione della merce ad attività di gruppo è abilitata, questa operazione non può essere eseguita', 1),
(5627, 5, '400588', '会员价格不能为0', 'Il prezzo del membro non può essere 0', 1),
(5628, 5, '400589', '虚拟优惠券商品请选择优惠券', 'Seleziona un coupon per prodotti con coupon virtuali', 1),
(5629, 5, '400590', '卡号：{:key}密码：{:value}，已经添加过，请重新添加卡密', 'Numero carta: {:key} Password: {:value}, è stata aggiunta, aggiungere nuovamente la chiave della carta', 1),
(5630, 5, '400591', '缺少城市id无法保存', 'Impossibile salvare l`ID città mancante', 1),
(5631, 5, '400592', '修改的模板不存在', 'Il modello modificato non esiste', 1),
(5632, 5, '400593', '指定区域邮费添加失败', 'Impossibile aggiungere l`affrancatura nell`area specificata', 1),
(5633, 5, '400594', '管理员不存在', 'L`amministratore non esiste', 1),
(5634, 5, '400595', '您已被禁止登录', 'Sei stato bandito dall`accesso', 1),
(5635, 5, '400596', '管理员账号已存在', 'L`account amministratore esiste già', 1),
(5636, 5, '400597', '原始密码错误', 'Errore password originale', 1),
(5637, 5, '400598', '请输入新密码', 'Inserisci una nuova password', 1),
(5638, 5, '400599', '请选择要删除的图片', 'Seleziona un`immagine da eliminare', 1),
(5639, 5, '400600', '移动失败或不能重复移动到同一分类下', 'Lo spostamento non è riuscito o non può essere spostato ripetutamente nella stessa categoria', 1),
(5640, 5, '400601', '请求不被允许', 'Richiesta non consentita', 1),
(5641, 5, '400602', '设置类目不被允许', 'La categoria di impostazione non è consentita', 1),
(5642, 5, '400603', '请输入正确格式的配置参数', 'Inserisci i parametri di configurazione nel formato corretto', 1),
(5643, 5, '400604', '{:name}请输入默认值', '{:name} inserisci il valore predefinito', 1),
(5644, 5, '400605', '{:name}请输入正确url', '{:name} inserisci l`URL corretto', 1),
(5645, 5, '400606', '保存wss证书失败', 'Impossibile salvare il certificato wss', 1),
(5646, 5, '400607', '{:name}不能为空', '{:name} non può essere vuoto', 1),
(5647, 5, '400608', '删除的云存储不存在', 'Il cloud storage eliminato non esiste', 1),
(5648, 5, '400609', '云存储正在使用中,需要启动其他空间才能删除', 'Il cloud storage è in uso, devi attivare un altro spazio da eliminare', 1),
(5649, 5, '400610', '云空间名称不能重复', 'Il nome dello spazio cloud non può essere ripetuto', 1),
(5650, 5, '400611', '没有权限', 'Nessun permesso', 1),
(5651, 5, '400612', '替换失败,失败原因:{:msg}', 'Sostituzione non riuscita, motivo errore: {:msg}', 1),
(5652, 5, '400613', '请先删除改菜单下的子菜单', 'Elimina prima il sottomenu sotto il menu', 1),
(5653, 5, '400614', '请填写批次名称', 'Compila il nome del lotto', 1),
(5654, 5, '400615', '请填写要生成卡的数量', 'Compila il numero di carte da generare', 1),
(5655, 5, '400616', '卡片数量只能为正整数', 'Il numero di carte può essere solo un numero intero positivo', 1),
(5656, 5, '400617', '单次制卡数量最高不得超过6000张', 'Il numero massimo di carte create contemporaneamente non deve superare 6000', 1),
(5657, 5, '400618', '请填写免费使用天数', 'Inserisci il numero di giorni di utilizzo gratuito', 1),
(5658, 5, '400619', '免费使用天数只能为正整数', 'Il numero di giorni di utilizzo gratuito può essere solo un numero intero positivo', 1),
(5659, 5, '400620', '生成卡失败', 'Impossibile generare la carta', 1),
(5660, 5, '400621', '会员功能暂未开启', 'La funzione membro non è stata ancora aperta', 1),
(5661, 5, '400622', '请输入会员卡号', 'Inserisci il numero della tessera', 1),
(5662, 5, '400623', '请输入领取卡密', 'Inserisci la password per ricevere la carta', 1),
(5663, 5, '400624', '会员卡不存在', 'La tessera associativa non esiste', 1),
(5664, 5, '400625', '会员卡未激活，暂无法使用', 'La tessera associativa non è attivata e non può essere utilizzata temporaneamente', 1),
(5665, 5, '400626', '会员卡密码有误', 'La password della tessera associativa non è corretta', 1),
(5666, 5, '400627', '会员卡已使用', 'La tessera è stata utilizzata', 1),
(5667, 5, '400628', '您已是永久会员，无需再领取，可以将此卡转送亲朋好友，一起享受优惠', 'Sei già iscritto a tempo indeterminato, non hai più bisogno di ottenerla, puoi cedere questa card ai tuoi parenti e amici per godere insieme dello sconto', 1),
(5668, 5, '400629', '暂无此类型会员卡', 'Al momento non esiste una tessera associativa di questo tipo', 1),
(5669, 5, '400630', '会员权益类型缺失', 'Manca il tipo di vantaggio per l`abbonamento', 1),
(5670, 5, '400631', '请设置权益名称', 'Imposta il nome dell`equità', 1),
(5671, 5, '400632', '请上传会员权益图标', 'Si prega di caricare l`icona dei diritti dei membri', 1),
(5672, 5, '400633', '请设置返还积分倍数', 'Si prega di impostare il punto di ritorno multiplo', 1),
(5673, 5, '400634', '返还积分倍数不能为负数', 'Il multiplo del punto di ritorno non può essere negativo', 1),
(5674, 5, '400635', '请设置运费折扣', 'Imposta lo sconto sulla spedizione', 1),
(5675, 5, '400636', '运费折扣不能为负数', 'Lo sconto sulla spedizione non può essere negativo', 1),
(5676, 5, '400637', '请设置签到积分倍数', 'Imposta il moltiplicatore del punto di check-in', 1),
(5677, 5, '400638', '签到积分倍数不能为负数', 'Il multiplo del punto di accesso non può essere negativo', 1),
(5678, 5, '400639', '请设置线下付款折扣', 'Imposta uno sconto per il pagamento offline', 1),
(5679, 5, '400640', '线下付款不能为负数', 'Il pagamento offline non può essere negativo', 1),
(5680, 5, '400641', '请填写会员卡名称', 'Compila il nome della tessera associativa', 1),
(5681, 5, '400642', '会员卡类型缺失', 'Tipo tessera mancante', 1),
(5682, 5, '400643', '请填写有效期（天）', 'Compila il periodo di validità (giorni)', 1),
(5683, 5, '400644', '有效期（天）不能为负数', 'Il periodo di validità (giorni) non può essere negativo', 1),
(5684, 5, '400645', '请填写价格', 'Inserisci il prezzo', 1),
(5685, 5, '400646', '价格不能为负数', 'Il prezzo non può essere negativo', 1),
(5686, 5, '400647', '优惠价不能大于原价', 'Il prezzo scontato non può essere maggiore del prezzo originario', 1),
(5687, 5, '400648', '地址不存在', 'L`indirizzo non esiste', 1),
(5688, 5, '400649', '取消原来默认地址失败', 'Annulla l`indirizzo predefinito originale non riuscito', 1),
(5689, 5, '400650', '设置默认地址失败', 'Impossibile impostare l`indirizzo predefinito', 1),
(5690, 5, '400651', '地址已存在', 'L`indirizzo esiste già', 1),
(5691, 5, '400652', '收货地址格式错误', 'Il formato dell`indirizzo di consegna non è corretto', 1),
(5692, 5, '400653', '请登录', 'Accedi', 1),
(5693, 5, '400654', '登录已过期,请重新登录', 'Il login è scaduto, per favore accedi di nuovo', 1),
(5694, 5, '400655', '增加记录失败', 'Impossibile aggiungere record', 1),
(5695, 5, '400656', '记录分享记录失败', 'Registrazione condivisione record fallita', 1),
(5696, 5, '400657', '增加用户佣金失败', 'Impossibile aumentare la commissione utente', 1),
(5697, 5, '400658', '企业付款到零钱失败，请稍后再试', 'La società non ha pagato il resto, riprova più tardi', 1),
(5698, 5, '400659', '已经提现', 'Ritirato', 1),
(5699, 5, '400660', '您的提现申请已被拒绝', 'La tua richiesta di prelievo è stata rifiutata', 1),
(5700, 5, '400661', '可提现佣金不足', 'Commissione insufficiente per recedere', 1),
(5701, 5, '400662', '提现金额不能小于{:money}元', 'L`importo del prelievo non può essere inferiore a {:money} yuan', 1),
(5702, 5, '400663', '提现佣金不足{:money}元', 'La commissione di prelievo non basta {:money} yuan', 1),
(5703, 5, '400664', '提现佣金大于0', 'La commissione di prelievo è maggiore di 0', 1),
(5704, 5, '400665', '企业微信付款到零钱最低金额为1元', 'L`importo minimo di resto che deve essere pagato dall`impresa WeChat è 1 yuan', 1),
(5705, 5, '400666', '该分组已经存在', 'Il gruppo esiste già', 1),
(5706, 5, '400667', '清空用户标签失败', 'Impossibile cancellare la scheda utente', 1),
(5707, 5, '400668', '设置标签失败', 'Impossibile impostare l`etichetta', 1),
(5708, 5, '400669', '请选择标签分类', 'Seleziona una categoria di etichetta', 1),
(5709, 5, '400670', '该标签已经存在', 'L`etichetta esiste già', 1),
(5710, 5, '400671', '修改用户等级信息失败', 'Impossibile modificare le informazioni sul livello utente', 1),
(5711, 5, '400672', '用户等级不存在', 'Il livello utente non esiste', 1),
(5712, 5, '400673', '用户等级经验必须大于上一等级设置的经验', 'L`esperienza del livello utente deve essere maggiore dell`esperienza impostata dal livello precedente', 1),
(5713, 5, '400674', '用户等级经验必须小于下一等级设置的经验', 'L`esperienza del livello utente deve essere inferiore all`esperienza impostata dal livello successivo', 1),
(5714, 5, '400675', '已检测到您设置过的用户等级，此等级不可重复', 'Il livello utente impostato è stato rilevato, questo livello non può essere ripetuto', 1),
(5715, 5, '400676', '已检测到您设置过该用户等级经验值，经验值不可重复', 'È stato rilevato che hai impostato il valore dell`esperienza di questo livello utente, il valore dell`esperienza non può essere ripetuto', 1),
(5716, 5, '400677', '订单未支付', 'Ordine non pagato', 1),
(5717, 5, '400678', '佣金转入余额，不能退款', 'La commissione viene trasferita a saldo e non è rimborsabile', 1),
(5718, 5, '400679', '已支付的订单记录无法删除', 'Impossibile eliminare il record dell`ordine pagato', 1),
(5719, 5, '400680', '转入金额不能大于可提现佣金', 'L`importo del bonifico non può essere maggiore della commissione prelevabile', 1),
(5720, 5, '400681', '写入余额充值失败', 'Impossibile scrivere ricarica saldo', 1),
(5721, 5, '400682', '您选择的充值方式已下架', 'Il metodo di ricarica selezionato è stato interrotto', 1),
(5722, 5, '400683', '充值订单生成失败', 'Impossibile generare l`ordine di ricarica', 1),
(5723, 5, '400684', '保存用户信息失败', 'Impossibile salvare le informazioni sull`utente', 1),
(5724, 5, '400685', '密码重置失败', 'Ripristino password fallito', 1),
(5725, 5, '400686', '增加推广人数失败', 'Impossibile aumentare il numero di promozioni', 1),
(5726, 5, '400687', '设置登录类型失败', 'Impossibile impostare il tipo di accesso', 1),
(5727, 5, '400688', '设置推广员失败', 'Impossibile impostare il promotore', 1),
(5728, 5, '400689', '增加用户余额失败', 'Impossibile aumentare il saldo utente', 1),
(5729, 5, '400690', '减少用户余额失败', 'Impossibile ridurre il saldo utente', 1),
(5730, 5, '400691', '减少用户佣金失败', 'Impossibile ridurre la commissione utente', 1),
(5731, 5, '400692', '增加用户积分失败', 'Impossibile aumentare i punti utente', 1),
(5732, 5, '400693', '减少用户积分失败', 'Impossibile ridurre i punti utente', 1),
(5733, 5, '400694', '增加用户经验失败', 'Impossibile aumentare l`esperienza utente', 1),
(5734, 5, '400695', '减少用户经验失败', 'Mancata riduzione dell`esperienza utente', 1),
(5735, 5, '400696', '该分组不存在', 'Il gruppo non esiste', 1),
(5736, 5, '400697', '设置分组失败或无改动', 'Impossibile impostare il raggruppamento o nessuna modifica', 1),
(5737, 5, '400698', '有标签不存在或被删除', 'Un`etichetta non esiste o è stata eliminata', 1),
(5738, 5, '400699', '等级不存在或被删除', 'La classe non esiste o è stata eliminata', 1),
(5739, 5, '400700', '此用户已有该用户等级，无法再次赠送', 'Questo utente ha già questo livello utente e non può darlo di nuovo', 1),
(5740, 5, '400701', '赠送天数不能为0', 'I giorni del regalo non possono essere 0', 1),
(5741, 5, '400702', '天数输入错误', 'Numero di giorni inserito errato', 1),
(5742, 5, '400703', '用户信息储存失败', 'Impossibile salvare le informazioni sull`utente', 1),
(5743, 5, '400704', '您得ip不再白名单中,请前往腾讯微信公众平台添加ip白名单', 'Il tuo IP non è più nella whitelist, vai alla piattaforma pubblica Tencent WeChat per aggiungere l`IP alla whitelist', 1),
(5744, 5, '400705', '您填写得appid无效,请检查', 'L`appid che hai compilato non è valido, per favore controlla', 1),
(5745, 5, '400706', '请输入回复信息内容', 'Inserisci il contenuto del messaggio di risposta', 1),
(5746, 5, '400707', '请上传回复的图片', 'Carica l`immagine della risposta', 1),
(5747, 5, '400708', '请上传回复的声音', 'Carica la voce di risposta', 1),
(5748, 5, '400709', '请选择图文消息', 'Seleziona messaggio di testo', 1),
(5749, 5, '400710', '对应的uid不存在', 'L`uid corrispondente non esiste', 1),
(5750, 5, '400711', '取消关注失败', 'Unfollow fallito', 1),
(5751, 5, '400712', '电子面单模板ID缺失', 'Manca l`ID del modello di slip elettronico', 1),
(5752, 5, '400713', '快递公司编码缺失', 'Manca il codice del corriere', 1),
(5753, 5, '400714', '寄件人信息缺失', 'Informazioni sul mittente mancanti', 1),
(5754, 5, '400715', '收件人信息缺失', 'Mancano le informazioni sul destinatario', 1),
(5755, 5, '400716', '云打印机编号缺失', 'Manca il numero della stampante cloud', 1),
(5756, 5, '400717', '商品数量缺失', 'Manca quantità articolo', 1),
(5757, 5, '400718', '获取access_token获取失败', 'Impossibile ottenere access_token', 1),
(5758, 5, '400719', '手机号不能为空', 'Il numero di cellulare non può essere vuoto', 1),
(5759, 5, '400720', '模版ID不存在', 'L`ID modello non esiste', 1),
(5760, 5, '400721', '请先配置accessKey和secretKey', 'Configura prima accessKey e secretKey', 1),
(5761, 5, '400722', '请先配置水印图片', 'Configura prima l`immagine della filigrana', 1),
(5762, 5, '400723', '请先配置水印文字', 'Configura prima il testo della filigrana', 1),
(5763, 5, '400724', '远程水印图片下载失败', 'Impossibile scaricare l`immagine filigrana remota', 1),
(5764, 5, '400725', '上传图片不存在', 'L`immagine caricata non esiste', 1),
(5765, 5, '400726', '图片流获取失败', 'Impossibile ottenere il flusso di immagini', 1),
(5766, 5, '400727', '图片下载失败', 'Download dell`immagine fallito', 1),
(5767, 5, '400728', '必须上传xlsx格式文件', 'Deve caricare il file in formato xlsx', 1),
(5768, 5, '400729', '数据不能为空', 'I dati non possono essere vuoti', 1),
(5769, 5, '400730', '缺少pay_price', 'Prezzo_pagamento mancante', 1),
(5770, 5, '400731', '退款失败:{:msg}', 'Rimborso fallito: {:msg}', 1),
(5771, 5, '400732', '获取微信粉丝信息失败', 'Impossibile ottenere informazioni sui fan di WeChat', 1),
(5772, 5, '400733', '您已关闭上传功能', 'Hai disabilitato il caricamento', 1),
(5773, 5, '400734', '文件不可写', 'Il file non è scrivibile', 1),
(5774, 5, '400735', '时间格式不正确', 'Formato dell`ora errato', 1),
(5775, 5, '400736', '文件可能损坏，请检查', 'Il file potrebbe essere danneggiato, per favore controlla', 1),
(5776, 5, '400737', '修复错误，请重试', 'Correggi l`errore, per favore riprova', 1),
(5777, 5, '400738', '请指定要修复的表', 'Specificare il tavolo da riparare', 1),
(5778, 5, '400739', '请配置支付证书', 'Configura il certificato di pagamento', 1),
(5779, 5, '400740', '只支持两级分类', 'Supporta solo la classificazione a due livelli', 1),
(5780, 5, '400741', '运费格式错误', 'Errore formato spedizione', 1),
(5781, 5, '400742', '请检查属性编码或库存数量', 'Controlla il codice attributo o la quantità di stock', 1),
(5782, 5, '400743', '同步条数不能超过100', 'Il numero di barre di sincronizzazione non può superare 100', 1),
(5783, 5, '400744', 'appid或appsecret错误', 'errore appid o appsecret', 1),
(5784, 5, '400745', '父级ID参数类型错误', 'Il tipo di parametro ID padre è errato', 1),
(5785, 5, '400746', '分类名称长度不能超过25个字符', 'La lunghezza del nome della categoria non può superare i 25 caratteri', 1),
(5786, 5, '400747', '分类图标长度不能超过128个字符', 'La lunghezza dell`icona della categoria non può superare i 128 caratteri', 1),
(5787, 5, '400748', '分类大图长度不能超过200个字符', 'La lunghezza dell`immagine di classificazione grande non può superare i 200 caratteri', 1),
(5788, 5, '400749', '排序参数类型错误', 'Tipo di parametro di ordinamento errato', 1),
(5789, 5, '400750', '排序不能小于0', 'L`ordinamento non può essere inferiore a 0', 1),
(5790, 5, '400751', '状态必须是0-1之间的整数', 'Lo stato deve essere un numero intero compreso tra 0-1', 1),
(5791, 5, '400752', '权益简介不能大于8个字', 'L`introduzione del vantaggio non può essere più lunga di 8 parole', 1),
(5792, 5, '400753', '提现方式最少选一种', 'Scegli almeno un metodo di prelievo', 1),
(5793, 5, '400754', '身份使用中，无法删除', 'L`identità è in uso e non può essere cancellata', 1),
(5794, 5, '400755', '展示名称不能大于6个字', 'Il nome visualizzato non può essere più lungo di 6 caratteri', 1),
(5795, 5, '400756', '推广佣金单价不能小于0', 'Il prezzo unitario della commissione di promozione non può essere inferiore a 0', 1),
(5796, 5, '400757', '每日推广佣金上限不能小于-1', 'Il limite della commissione giornaliera della promozione non può essere inferiore a -1', 1),
(5797, 5, '400758', '请核对领取方式', 'Verifica il metodo di raccolta', 1),
(5798, 5, '400759', '请输入优惠券名称', 'Inserisci il nome del coupon', 1),
(5799, 5, '400760', '请输入真实姓名', 'Inserisci il tuo vero nome', 1),
(5800, 5, '400761', '描述内容不能超过120字', 'La descrizione non può superare i 120 caratteri', 1),
(5801, 5, '400762', '账号密码必须是在6到32位之间', 'La password dell`account deve essere compresa tra 6 e 32 caratteri', 1),
(5802, 5, '400763', '商户号不能为空', 'Il numero commerciante non può essere vuoto', 1),
(5803, 5, '410000', '请输入账号和密码', 'Inserisci account e password', 1),
(5804, 5, '410001', '登录成功', 'Accesso riuscito', 1),
(5805, 5, '410002', '退出成功', 'Esci con successo', 1),
(5806, 5, '410003', '发送验证码失败,请刷新页面重新获取', 'Impossibile inviare il codice di verifica, aggiorna la pagina per riceverlo di nuovo', 1),
(5807, 5, '410004', '请输入验证码', 'Inserisci il codice di verifica', 1),
(5808, 5, '410005', '验证码输入有误', 'Il codice di verifica è stato inserito in modo errato', 1),
(5809, 5, '410006', '验证码已发送', 'Codice di verifica inviato', 1),
(5810, 5, '410007', '验证码发送成功', 'Codice di verifica inviato con successo', 1),
(5811, 5, '410008', '验证码发送失败', 'Impossibile inviare il codice di verifica', 1),
(5812, 5, '410009', '请先获取验证码', 'Per favore procurati prima il codice di verifica', 1),
(5813, 5, '410010', '验证码错误', 'Errore codice di verifica', 1),
(5814, 5, '410011', '密码必须是在6到16位之间', 'La password deve essere compresa tra 6 e 16 cifre', 1),
(5815, 5, '410012', '密码太过简单，请输入较为复杂的密码', 'La password è troppo semplice, inserisci una password più complessa', 1),
(5816, 5, '410013', '注册成功', 'Registrazione riuscita', 1),
(5817, 5, '410014', '注册失败', 'Registrazione fallita', 1),
(5818, 5, '410015', '请输入手机号', 'Inserisci il tuo numero di telefono', 1),
(5819, 5, '410016', '绑定成功', 'Rilegatura riuscita', 1),
(5820, 5, '410017', '绑定失败', 'Rilegatura fallita', 1),
(5821, 5, '410018', '手机号格式不正确', 'Il formato del numero di telefono non è corretto', 1),
(5822, 5, '410019', '登录失败', 'Accesso fallito', 1),
(5823, 5, '410020', '扫码失败请重新扫描', 'Scansione codice fallita, eseguire nuovamente la scansione', 1),
(5824, 5, '410021', '二维码已过期请重新扫描', 'Il codice QR è scaduto, scansiona di nuovo', 1),
(5825, 5, '410022', '授权成功，请绑定手机号', 'Autorizzazione riuscita, vincolare il numero di telefono', 1),
(5826, 5, '410023', '授权成功', 'Autorizzazione riuscita', 1),
(5827, 5, '410024', '请先关注公众号', 'Si prega di prestare attenzione prima all`account ufficiale', 1),
(5828, 5, '410025', '账号或密码错误', 'Account o password errati', 1),
(5829, 5, '410026', '请修改您的初始密码，再尝试登录', 'Per favore cambia la tua password iniziale e prova ad accedere di nuovo', 1),
(5830, 5, '410027', '您已被禁止登录，请联系管理员', 'Sei stato bannato dall`accesso, per favore contatta l`amministratore', 1),
(5831, 5, '410028', '手机号已注册', 'Il numero di telefono è stato registrato', 1),
(5832, 5, '410029', '您今日发送得短信次数已经达到上限', 'Il numero di SMS che hai inviato oggi ha raggiunto il limite massimo', 1),
(5833, 5, '410030', '此IP今日发送次数已经达到上限', 'Il numero di volte che questo IP è stato inviato oggi ha raggiunto il limite superiore', 1),
(5834, 5, '410031', '短信平台验证码发送失败', 'Impossibile inviare il codice di verifica della piattaforma SMS', 1),
(5835, 5, '410032', '用户不存在', 'L`utente non esiste', 1),
(5836, 5, '410033', '修改密码失败', 'Cambia password fallita', 1),
(5837, 5, '410034', '用户登录失败,无法生成新用户,请稍后再试', 'Accesso utente fallito, impossibile generare un nuovo utente, riprovare più tardi', 1),
(5838, 5, '410035', '用户不存在,无法切换', 'L`utente non esiste e non può essere cambiato', 1),
(5839, 5, '410036', '修改新用户登录类型出错', 'Errore durante la modifica del nuovo tipo di login utente', 1),
(5840, 5, '410037', '请刷新页面或者重新授权', 'Aggiorna la pagina o autorizza nuovamente', 1),
(5841, 5, '410038', '获取用户访问token失败', 'Impossibile ottenere il token di accesso utente', 1),
(5842, 5, '410039', '此手机已经绑定，无法多次绑定', 'Questo telefono è già collegato e non può essere collegato più volte', 1),
(5843, 5, '410040', '您的账号已经绑定过手机号码', 'Il tuo account è stato associato a un numero di cellulare', 1),
(5844, 5, '410041', 'H5已有账号是否绑定此账号上', 'Se l`account esistente di H5 è legato a questo account', 1),
(5845, 5, '410042', '新手机号和原手机号相同，无需修改', 'Il nuovo numero di telefono è lo stesso del numero di telefono originale, non è necessario modificarlo', 1),
(5846, 5, '410043', '此手机已经注册', 'Questo telefono è già registrato', 1),
(5847, 5, '410044', '用户信息获取失败', 'Impossibile ottenere informazioni sull`utente', 1),
(5848, 5, '410045', '请选择收货地址', 'Selezionare l`indirizzo di consegna', 1),
(5849, 5, '410046', '地址选择有误', 'Selezione indirizzo errata', 1),
(5850, 5, '410047', '可用积分不足', 'Punti disponibili insufficienti', 1),
(5851, 5, '410048', '奖品不存在', 'Il premio non esiste', 1),
(5852, 5, '410049', '写入中奖记录失败', 'Impossibile scrivere record di vincita', 1),
(5853, 5, '410050', '请继续参与活动抽奖', 'Continua a partecipare all`estrazione fortunata', 1),
(5854, 5, '410051', '已经领取成功', 'Ricevuto con successo', 1),
(5855, 5, '410052', '请输入收货人信息', 'Inserisci le informazioni sul destinatario', 1),
(5856, 5, '410053', '请输入正确的收货人电话', 'Inserisci il numero di telefono corretto del destinatario', 1),
(5857, 5, '410054', '抽奖记录不存在', 'Il record della lotteria non esiste', 1),
(5858, 5, '410055', '该奖品不需要发货', 'Questo premio non ha bisogno di essere spedito', 1),
(5859, 5, '410056', '请选择快递公司或输入快递单号', 'Seleziona un corriere o inserisci un numero di corriere', 1),
(5860, 5, '410057', '活动不存在或已删除', 'L`attività non esiste o è stata eliminata', 1),
(5861, 5, '410058', '暂未有该类型活动', 'Non ci sono ancora attività di questo tipo', 1),
(5862, 5, '410059', '您暂时无法参与该活动', 'Non sei momentaneamente in grado di partecipare a questo evento', 1),
(5863, 5, '410060', '活动状态有误，请联系管理员', 'Lo stato dell`attività non è corretto, si prega di contattare l`amministratore', 1),
(5864, 5, '410061', '可用积分不足，没有更多抽奖次数', 'Punti disponibili insufficienti, non più estrazioni', 1),
(5865, 5, '410062', '余额不足，没有更多抽奖次数', 'Saldo insufficiente, non più pareggi', 1),
(5866, 5, '410063', '购买商品之后获得更多抽奖次数', 'Ottieni più estrazioni fortunate dopo aver acquistato oggetti', 1),
(5867, 5, '410064', '订单完成评价之后获得更多抽奖次数', 'Ottieni più estrazioni della lotteria dopo che l`ordine è stato valutato', 1),
(5868, 5, '410065', '邀请更多好友获取抽奖次数', 'Invita più amici per ottenere il numero di estrazioni fortunate', 1),
(5869, 5, '410066', '抽奖扣除用户积分失败', 'L`estrazione della lotteria non è riuscita a detrarre punti utente', 1),
(5870, 5, '410067', '抽奖失败，余额不足', 'Estrazione della lotteria fallita, saldo insufficiente', 1),
(5871, 5, '410068', '抽奖扣除用户余额失败', 'L`estrazione della lotteria non è riuscita a detrarre il saldo dell`utente', 1),
(5872, 5, '410069', '抽奖扣除用户推广获取抽奖次数失败', 'Impossibile detrarre il numero di estrazioni della lotteria dalla promozione utente', 1),
(5873, 5, '410070', '抽奖减少奖品总数失败', 'Estrazione della lotteria per ridurre il numero totale dei premi falliti', 1),
(5874, 5, '410071', '分销等级不存在', 'Il livello di distribuzione non esiste', 1),
(5875, 5, '410072', '永久二维码获取错误', 'Errore durante l`ottenimento del codice QR permanente', 1),
(5876, 5, '410073', '邀请码无效', 'Il codice di invito non è valido', 1),
(5877, 5, '410074', '授权失败,参数有误', 'Autorizzazione fallita, parametro errato', 1),
(5878, 5, '410075', 'openid获取失败', 'Impossibile ottenere l`openid', 1),
(5879, 5, '410076', '获取session_key失败，请检查您的配置', 'Impossibile ottenere session_key, controlla la tua configurazione', 1),
(5880, 5, '410077', '获取会话密匙失败', 'Impossibile ottenere la chiave di sessione', 1),
(5881, 5, '410078', '静默授权失败', 'Autorizzazione silenziosa fallita', 1),
(5882, 5, '410079', '获取用户信息失败', 'Impossibile ottenere le informazioni sull`utente', 1),
(5883, 5, '410080', '更新信息失败', 'Aggiornamento informazioni fallito', 1),
(5884, 5, '410081', '请上传二维码', 'Carica il codice QR', 1),
(5885, 5, '410082', '请关注公众号', 'Si prega di prestare attenzione al numero pubblico', 1),
(5886, 5, '410083', '新增用户失败', 'Aggiunta utente fallita', 1),
(5887, 5, '410084', '用户关注失败', 'Impossibile seguire l`utente', 1),
(5888, 5, '410085', '获取token失败{:msg}', 'Impossibile ottenere il token {:msg}', 1),
(5889, 5, '410086', '配置已更改或token已失效', 'La configurazione è stata modificata o il token è scaduto', 1),
(5890, 5, '410087', '平台错误：发生异常，请稍后重试', 'Errore piattaforma: si è verificata un`eccezione, riprova più tardi', 1),
(5891, 5, '410088', '企业微信支付到零钱需要支付证书，检测到您没有上传', 'Il pagamento WeChat aziendale per cambiare necessita di un certificato di pagamento, è stato rilevato che non hai caricato', 1),
(5892, 5, '410089', '发起企业支付到零钱失败', 'Avvio dell`azienda a pagare la modifica fallito', 1),
(5893, 5, '410090', '无效的token不能查找到用户聊天记录', 'Il token non valido non riesce a trovare la cronologia chat dell`utente', 1),
(5894, 5, '410091', '图片上传成功', 'Caricamento immagine riuscito', 1),
(5895, 5, '410092', '用户uid不再当前聊天用户范围内', 'User uid non è più nell`attuale intervallo di utenti della chat', 1),
(5896, 5, '410093', '请输入订单价格', 'Inserisci il prezzo dell`ordine', 1),
(5897, 5, '410094', '请去后台售后订单列表处理', 'Vai all`elaborazione dell`elenco ordini post-vendita dietro le quinte', 1),
(5898, 5, '410095', '分类名称不能为空', 'Il nome della categoria non può essere vuoto', 1),
(5899, 5, '410096', '分类不存在', 'La classificazione non esiste', 1),
(5900, 5, '410097', '添加的内容重复', 'Contenuto aggiunto duplicato', 1),
(5901, 5, '410098', '缺少转接人id', 'ID persona di trasferimento mancante', 1),
(5902, 5, '410099', '转接成功', 'Trasferimento riuscito', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(5903, 5, '410100', '话术没有被查到', 'Parole non trovate', 1),
(5904, 5, '410101', '公共话术不能修改', 'La lingua pubblica non può essere modificata', 1),
(5905, 5, '410102', '话术标题内容不能为空', 'Il contenuto del titolo non può essere vuoto', 1),
(5906, 5, '410103', '已拥有此分组', 'Possiede già questo gruppo', 1),
(5907, 5, '410104', '缺少标签id', 'ID tag mancante', 1),
(5908, 5, '410105', '请填汉字字母或者数字', 'Compila lettere o numeri cinesi', 1),
(5909, 5, '410106', '标题长度不能超过50个字', 'La lunghezza del titolo non può superare i 50 caratteri', 1),
(5910, 5, '410107', '请选择分类', 'Seleziona una categoria', 1),
(5911, 5, '410108', '分类必须为数字', 'Le categorie devono essere numeri', 1),
(5912, 5, '410109', '请填写话术内容', 'Compila il contenuto delle parole', 1),
(5913, 5, '410110', '话术长度不能超过500个字', 'La lunghezza della parola non può superare i 500 caratteri', 1),
(5914, 5, '410111', '排序必须为数字', 'L`ordinamento deve essere numerico', 1),
(5915, 5, '410112', '微信最低提现金额不能小于1元', 'L`importo minimo di prelievo di Wechat non può essere inferiore a 1 yuan', 1),
(5916, 5, '410113', '用户不存在', 'L`utente non esiste', 1),
(5917, 5, '410114', '提现方式不存在', 'Il metodo di prelievo non esiste', 1),
(5918, 5, '410115', '提现金额输入有误', 'L`importo del prelievo è stato inserito in modo errato', 1),
(5919, 5, '410116', '银行卡号输入有误', 'Il numero della carta di credito è stato inserito in modo errato', 1),
(5920, 5, '410117', '请输入支付宝账号', 'Inserisci il numero di conto Alipay', 1),
(5921, 5, '410118', '请输入银行卡账号', 'Inserisci il numero di conto della carta bancaria', 1),
(5922, 5, '410119', '请输入开户行信息', 'Inserisci le coordinate bancarie', 1),
(5923, 5, '410120', '申请提现成功', 'Richiesta di recesso con successo', 1),
(5924, 5, '410121', '申请提现失败', 'Mancata richiesta di recesso', 1),
(5925, 5, '410122', '充值金额不能为0元', 'L`importo della ricarica non può essere 0 yuan', 1),
(5926, 5, '410123', '充值方式不支持', 'Il metodo di ricarica non è supportato', 1),
(5927, 5, '410124', '充值金额不能低于{:money}', 'L`importo della ricarica non può essere inferiore a {:money}', 1),
(5928, 5, '410125', '充值成功', 'Ricarica riuscita', 1),
(5929, 5, '410126', '充值失败', 'Ricarica fallita', 1),
(5930, 5, '410127', '签到获得{:integral}积分', 'Accedi per ottenere {:integral} punti', 1),
(5931, 5, '410128', '签到失败', 'Accesso fallito', 1),
(5932, 5, '410129', '收藏成功', 'Raccolta riuscita', 1),
(5933, 5, '410130', '收藏失败', 'Impossibile raccogliere', 1),
(5934, 5, '410131', '授权失败', 'Autorizzazione fallita', 1),
(5935, 5, '410132', 'unionid不存在', 'unionid non esiste', 1),
(5936, 5, '410133', '获取用户UID失败', 'Impossibile ottenere l`UID utente', 1),
(5937, 5, '410134', '请输入昵称或者选择头像', 'Inserisci un nickname o seleziona un avatar', 1),
(5938, 5, '410135', '注销成功', 'Logout riuscito', 1),
(5939, 5, '410136', '暂无客服人员在线，请稍后联系', 'Non c`è personale del servizio clienti online, ti preghiamo di contattarci più tardi', 1),
(5940, 5, '410137', '不能和自己聊天', 'Non posso chattare con me stesso', 1),
(5941, 5, '410138', '您不是客服无法登录', 'Non sei un servizio clienti e non puoi accedere', 1),
(5942, 5, '410139', '自己不能转接给自己', 'Non posso trasferirmi su me stesso', 1),
(5943, 5, '410140', '转接客服失败', 'Impossibile trasferire il servizio clienti', 1),
(5944, 5, '410141', '没有此用户', 'Nessun utente del genere', 1),
(5945, 5, '410142', '客服不存在', 'Il servizio clienti non esiste', 1),
(5946, 5, '410143', '商品未查到', 'Articolo non trovato', 1),
(5947, 5, '410144', '请填写开票手机号', 'Compila il numero di telefono per la fatturazione', 1),
(5948, 5, '410145', '请填写发票抬头（开具发票企业名称）', 'Compila l`intestazione della fattura (nome della società che emette la fattura)', 1),
(5949, 5, '410146', '请填写正确的发票抬头（开具发票企业名称）', 'Compila l`intestazione della fattura corretta (nome della società che ha emesso la fattura)', 1),
(5950, 5, '410147', '请填写发票税号', 'Compila il codice fiscale della fattura', 1),
(5951, 5, '410148', '请填写正确的发票税号', 'Compila il codice fiscale della fattura corretto', 1),
(5952, 5, '410149', '请填写正确的银行卡号', 'Inserisci il numero di carta di credito corretto', 1),
(5953, 5, '410150', '地址不存在', 'L`indirizzo non esiste', 1),
(5954, 5, '410151', '收货地址格式错误', 'Il formato dell`indirizzo di consegna non è corretto', 1),
(5955, 5, '410152', '收货地址格式错误或系统未完善当前地址', 'Il formato dell`indirizzo di consegna non è corretto o il sistema non completa l`indirizzo attuale', 1),
(5956, 5, '410153', '收货地址格式错误，请重新选择', 'Il formato dell`indirizzo di spedizione non è corretto, seleziona nuovamente', 1),
(5957, 5, '410154', '请填写详细地址', 'Si prega di compilare l`indirizzo dettagliato', 1),
(5958, 5, '410155', '名称必须填写', 'Il nome deve essere compilato', 1),
(5959, 5, '410156', '名称最多不能超过25个字符', 'Il nome non può superare i 25 caratteri', 1),
(5960, 5, '410157', '手机号必须填写', 'Il numero di cellulare deve essere inserito', 1),
(5961, 5, '410158', '手机号格式错误', 'Errore nel formato del numero di cellulare', 1),
(5962, 5, '410159', '省必须填写', 'La provincia deve essere compilata', 1),
(5963, 5, '410160', '市必须填写', 'La città deve compilare', 1),
(5964, 5, '410161', '区/县必须填写', 'Compilare il Distretto/Contea', 1),
(5965, 5, '410162', '详细地址必须填写', 'È necessario compilare l`indirizzo dettagliato', 1),
(5966, 5, '410163', '请填写反馈内容', 'Compila il contenuto del feedback', 1),
(5967, 5, '410164', '比例不能大于您的比例', 'Il rapporto non può essere maggiore del tuo rapporto', 1),
(5968, 5, '410165', '激活成功', 'Attivazione riuscita', 1),
(5969, 5, '410166', '暂无海报', 'Nessun poster ancora', 1),
(5970, 5, '410167', '二维码生成失败', 'Impossibile generare codice QR', 1),
(5971, 5, '410168', '缺少字体文件Bold', 'File font mancante grassetto', 1),
(5972, 5, '410169', '缺少字体文件Normal', 'File font mancante Normale', 1),
(5973, 5, '410170', '生成图片失败', 'Impossibile generare l`immagine', 1),
(5974, 5, '410171', '生成图片时，系统错误', 'Si è verificato un errore di sistema durante la generazione dell`immagine', 1),
(5975, 5, '410172', '生成海报失败', 'Impossibile generare poster', 1),
(5976, 5, '410173', '订单不存在', 'L`ordine non esiste', 1),
(5977, 5, '410174', '订单已支付', 'Ordine pagato', 1),
(5978, 5, '410175', '请填写实际支付金额', 'Compila l`importo effettivo del pagamento', 1),
(5979, 5, '410176', '实际支付金额不能小于0元', 'L`importo effettivo del pagamento non può essere inferiore a 0 yuan', 1),
(5980, 5, '410177', '请填写备注内容', 'Compila i commenti', 1),
(5981, 5, '410178', '请先处理售后申请', 'Si prega di elaborare prima la domanda post-vendita', 1),
(5982, 5, '410179', '用户已取消申请', 'L`utente ha cancellato l`applicazione', 1),
(5983, 5, '410180', '售后订单状态不支持该操作', 'Lo stato dell`ordine post-vendita non supporta questa operazione', 1),
(5984, 5, '410181', '退款修改状态错误', 'Errore stato modifica rimborso', 1),
(5985, 5, '410182', '修改退款状态成功', 'Modifica stato rimborso con successo', 1),
(5986, 5, '410183', '已退完支付金额，不能再退款了', 'L`importo del pagamento è stato rimborsato, non più rimborsi', 1),
(5987, 5, '410184', '请输入退款金额', 'Inserisci l`importo del rimborso', 1),
(5988, 5, '410185', '退款金额大于支付金额，请修改退款金额', 'L`importo del rimborso è maggiore dell`importo del pagamento, modificare l`importo del rimborso', 1),
(5989, 5, '410186', '退款成功', 'Rimborso riuscito', 1),
(5990, 5, '410187', '退款失败', 'Rimborso fallito', 1),
(5991, 5, '410188', '请输入核销码或者扫描核销二维码', 'Inserisci il codice di cancellazione o scansiona il codice QR di cancellazione', 1),
(5992, 5, '410189', '核销成功', 'Cancellazione riuscita', 1),
(5993, 5, '410190', '请输入付款金额', 'Inserisci l`importo del pagamento', 1),
(5994, 5, '410191', '支付金额不能为0元', 'L`importo del pagamento non può essere 0 yuan', 1),
(5995, 5, '410192', '付费会员功能暂未开启', 'La funzione di abbonamento a pagamento non è stata ancora aperta', 1),
(5996, 5, '410193', '支付数据生成失败', 'Impossibile generare i dati di pagamento', 1),
(5997, 5, '410194', '支付订单不存在', 'L`ordine di pagamento non esiste', 1),
(5998, 5, '410195', '微信支付成功', 'Pagamento WeChat riuscito', 1),
(5999, 5, '410196', '前往支付', 'Vai a pagare', 1),
(6000, 5, '410197', '余额支付成功', 'Pagamento saldo riuscito', 1),
(6001, 5, '410198', '请传入支付宝支付回调URL', 'Inserisci l`URL di richiamata del pagamento Alipay', 1),
(6002, 5, '410199', '支付宝支付成功', 'Pagamento Alipay andato a buon fine', 1),
(6003, 5, '410200', '订单生成失败', 'Generazione dell`ordine fallita', 1),
(6004, 5, '410201', '请提交购买的商品', 'Invia l`oggetto acquistato', 1),
(6005, 5, '410202', '商品不存在，请重新选择商品下单', 'Il prodotto non esiste, si prega di riselezionare il prodotto per effettuare un ordine', 1),
(6006, 5, '410203', '订单创建成功', 'Ordine creato con successo', 1),
(6007, 5, '410204', '收货成功', 'Merce ricevuta con successo', 1),
(6008, 5, '410205', '收货失败', 'Ricevuta fallita', 1),
(6009, 5, '410206', '快递单号不存在', 'Il numero di tracciamento espresso non esiste', 1),
(6010, 5, '410207', '默认运费模板未配置，无法下单', 'Il modello di spedizione predefinito non è configurato, quindi l`ordine non può essere effettuato', 1),
(6011, 5, '410208', '订单已过期,请刷新当前页面', 'L`ordine è scaduto, aggiorna la pagina corrente', 1),
(6012, 5, '410209', '订单已创建，请点击查看完成支付', 'L`ordine è stato creato, fare clic per visualizzare per completare il pagamento', 1),
(6013, 5, '410210', '订单生成失败，你已经在该团内不能再参加了', 'La generazione dell`ordine è fallita, non puoi più partecipare al gruppo', 1),
(6014, 5, '410211', '订单生成失败，你已经参加该团了，请先支付订单', 'La generazione dell`ordine è fallita, sei già entrato nel gruppo, per favore paga prima l`ordine', 1),
(6015, 5, '410212', '该团人员已满', 'Il reggimento è al completo', 1),
(6016, 5, '410213', '暂不支持该支付方式，请刷新页面或者联系管理员', 'Questo metodo di pagamento non è attualmente supportato, aggiorna la pagina o contatta l`amministratore', 1),
(6017, 5, '410214', '您购买的商品库存已不足{:cart_num}{:unit_name}', 'Il prodotto che hai acquistato è esaurito {:cart_num}{:unit_name}', 1),
(6018, 5, '410215', '该订单已失效', 'L`ordine è scaduto', 1),
(6019, 5, '410216', '支付失败', 'Pagamento fallito', 1),
(6020, 5, '410217', '支付成功', 'Pagamento andato a buon fine', 1),
(6021, 5, '410218', '支付方式错误', 'Metodo di pagamento errato', 1),
(6022, 5, '410219', '订单商品已评价', 'L`articolo dell`ordine è stato valutato', 1),
(6023, 5, '410220', '请为商品评分', 'Si prega di valutare il prodotto', 1),
(6024, 5, '410221', '请为商家服务评分', 'Si prega di valutare il servizio business', 1),
(6025, 5, '410222', '评价失败', 'Valutazione fallita', 1),
(6026, 5, '410223', '请重新选择退款商品或件数', 'Selezionare nuovamente l`oggetto del rimborso o il numero di pezzi', 1),
(6027, 5, '410224', '当前状态不能取消申请', 'Lo stato attuale non può annullare la domanda', 1),
(6028, 5, '410225', '重选成功', 'Riselezione riuscita', 1),
(6029, 5, '410226', '订单已退款', 'Ordine rimborsato', 1),
(6030, 5, '410227', '使用积分抵扣失败', 'Impossibile utilizzare i punti da detrarre', 1),
(6031, 5, '410228', '会员类型不存在', 'Il tipo di membro non esiste', 1),
(6032, 5, '410229', '您已是永久会员无需再购买', 'Sei un membro permanente, non c`è più bisogno di acquistare', 1),
(6033, 5, '410230', '该会员卡暂时无法购买', 'Questa tessera non può essere acquistata temporaneamente', 1),
(6034, 5, '410231', '您已经领取过免费会员', 'Hai già ricevuto un abbonamento gratuito', 1),
(6035, 5, '410232', '此类型会员卡暂未开售', 'Questo tipo di tessera non è ancora disponibile per la vendita', 1),
(6036, 5, '410233', '获取购物车信息失败', 'Impossibile ottenere informazioni sul carrello', 1),
(6037, 5, '410234', '您要购买的优惠券已失效，无法购买', 'Il coupon che vuoi acquistare è scaduto e non può essere acquistato', 1),
(6038, 5, '410235', '您已获取过该优惠券，无法再次购买', 'Hai già ottenuto questo coupon e non puoi riacquistarlo', 1),
(6039, 5, '410236', '请刷新后重试', 'Aggiorna e riprova', 1),
(6040, 5, '410237', '暂无库存', 'Nessuna scorta al momento', 1),
(6041, 5, '410238', '选择的规格库存不足', 'La specifica selezionata è esaurita', 1),
(6042, 5, '410239', '单次购买数量不能大于 {:limit} 件', 'La singola quantità di acquisto non può essere maggiore di {:limit} pezzi', 1),
(6043, 5, '410240', '该商品限购 {:limit} 件，您已经购买 {:pay_num} 件', 'Questo articolo è limitato a {:limit} pezzi, hai già acquistato {:pay_num} pezzi', 1),
(6044, 5, '410241', '选择支付方式有误', 'Metodo di pagamento selezionato errato', 1),
(6045, 5, '410242', '选择的优惠劵无效', 'Il coupon selezionato non è valido', 1),
(6046, 5, '410243', '不满足优惠劵的使用条件', 'Le condizioni per l`utilizzo del coupon non sono soddisfatte', 1),
(6047, 5, '410244', '使用优惠劵失败', 'Impossibile utilizzare il coupon', 1),
(6048, 5, '410245', '请填写姓名和电话', 'Inserisci il tuo nome e numero di telefono', 1),
(6049, 5, '410246', '营销商品不能使用线下支付', 'Il pagamento offline non può essere utilizzato per la commercializzazione di prodotti', 1),
(6050, 5, '410247', '暂无门店无法选择门店自提', 'Al momento non c`è negozio e non posso scegliere di ritirare in negozio', 1),
(6051, 5, '410248', '订单商品结算失败', 'Impossibile saldare l`articolo dell`ordine', 1),
(6052, 5, '410249', '发票已申请', 'Richiesta fattura', 1),
(6053, 5, '410250', '正在申请退款中', 'Richiesta di rimborso', 1),
(6054, 5, '410251', '申请失败', 'Applicazione non riuscita', 1),
(6055, 5, '410252', '退款件数大于订单件数', 'Il numero dei rimborsi è maggiore del numero degli ordini', 1),
(6056, 5, '410253', '该订单已全部拆分', 'L`ordine è stato diviso', 1),
(6057, 5, '410254', '申请退款失败', 'Impossibile richiedere il rimborso', 1),
(6058, 5, '410255', '存在待处理退款单', 'C`è un ordine di rimborso in sospeso', 1),
(6059, 5, '410256', '该订单无法删除', 'L`ordine non può essere cancellato', 1),
(6060, 5, '410257', '订单已经支付无法取消', 'L`ordine è stato pagato e non può essere annullato', 1),
(6061, 5, '410258', '拼团商品不能再来一单，请在拼团商品内自行下单', 'Il prodotto del gruppo non può essere ordinato di nuovo, si prega di effettuare un ordine nel prodotto del gruppo', 1),
(6062, 5, '410259', '砍价商品不能再来一单，请在砍价商品内自行下单', 'Non puoi avere un altro ordine per l`oggetto contrattato, effettua il tuo ordine nell`oggetto contrattato', 1),
(6063, 5, '410260', '秒杀商品不能再来一单，请在秒杀商品内自行下单', 'L`articolo seckill non può essere ordinato di nuovo, si prega di effettuare un ordine all`interno dell`articolo seckill', 1),
(6064, 5, '410261', '预售商品不能再来一单，请在预售商品内自行下单', 'L`articolo in prevendita non può essere ordinato di nuovo, si prega di effettuare il proprio ordine nell`articolo in prevendita', 1),
(6065, 5, '410262', '再来一单失败，请重新下单', 'Un altro ordine fallito, effettua un nuovo ordine', 1),
(6066, 5, '410263', '该订单无法支付', 'L`ordine non può essere pagato', 1),
(6067, 5, '410264', '订单支付状态有误，无法进行支付', 'Lo stato del pagamento dell`ordine non è corretto e il pagamento non può essere effettuato', 1),
(6068, 5, '410265', '该订单已支付', 'L`ordine è stato pagato', 1),
(6069, 5, '410266', '订单状态错误', 'Errore stato ordine', 1),
(6070, 5, '410267', '此订单不能被核销', 'Questo ordine non può essere cancellato', 1),
(6071, 5, '410268', '订单有售后申请请先处理', 'L`ordine ha un`applicazione post-vendita, si prega di elaborarla prima', 1),
(6072, 5, '410269', '您无权限核销此订单，请联系管理员', 'Non hai il permesso di cancellare questo ordine, contatta l`amministratore', 1),
(6073, 5, '410270', '订单已核销', 'L`ordine è stato cancellato', 1),
(6074, 5, '410271', '拼团订单暂未成功无法核销', 'L`ordine di gruppo non è stato ancora cancellato con successo', 1),
(6075, 5, '410272', '核销失败', 'Cancellazione fallita', 1),
(6076, 5, '410273', '发货成功', 'Consegna riuscita', 1),
(6077, 5, '410274', '无需支付', 'Nessun pagamento richiesto', 1),
(6078, 5, '410275', '获取用户openid失败,无法支付', 'Impossibile ottenere l`openid dell`utente, impossibile pagare', 1),
(6079, 5, '410276', '网站名称配置未填写,无法支付', 'La configurazione del nome del sito web non è compilata, non posso pagare', 1),
(6080, 5, '410277', '支付方式不存在', 'Metodo di pagamento non esiste', 1),
(6081, 5, '410278', '不支持该类型方式', 'Questo tipo di metodo non è supportato', 1),
(6082, 5, '410279', '余额支付失败', 'Pagamento saldo fallito', 1),
(6083, 5, '410280', '暂未开启发票', 'La fattura non è stata ancora aperta', 1),
(6084, 5, '410281', '暂未开启专用发票', 'La fattura speciale non è stata ancora aperta', 1),
(6085, 5, '410282', '该发票已经存在', 'La fattura esiste già', 1),
(6086, 5, '410283', '设置默认发票失败', 'Impossibile impostare la fattura predefinita', 1),
(6087, 5, '410284', '没有此用户，无法检测升级用户等级', 'Impossibile rilevare il livello utente di aggiornamento senza questo utente', 1),
(6088, 5, '410285', '检测升级失败', 'Verifica aggiornamento fallito', 1),
(6089, 5, '410286', '修改订单失败', 'Impossibile modificare l`ordine', 1),
(6090, 5, '410287', '修改用户信息失败', 'Impossibile modificare le informazioni utente', 1),
(6091, 5, '410288', '绑定推广关系失败', 'Impossibile vincolare il rapporto di promozione', 1),
(6092, 5, '410289', '天数不能为0', 'Il numero di giorni non può essere 0', 1),
(6093, 5, '410290', '添加签到数据失败', 'Impossibile aggiungere i dati di check-in', 1),
(6094, 5, '410291', '赠送经验失败', 'Impossibile fornire esperienza', 1),
(6095, 5, '410292', '请先配置签到天数', 'Configura prima i giorni di check-in', 1),
(6096, 5, '410293', '已经签到', 'Registrato', 1),
(6097, 5, '410294', '商品不存在', 'L`oggetto non esiste', 1),
(6098, 5, '410295', '该商品已下架或删除', 'Questo prodotto è stato rimosso o cancellato', 1),
(6099, 5, '410296', '该商品库存不足', 'L`articolo è esaurito', 1),
(6100, 5, '410297', '该商品库存不足{:num}', 'L`articolo è esaurito{:num}', 1),
(6101, 5, '410298', '每人总共限购{:num}件', 'Un limite totale di {:num} pezzi per persona', 1),
(6102, 5, '410299', '砍价已结束', 'La contrattazione è finita', 1),
(6103, 5, '410300', '您不能再发起此件商品砍价', 'Non puoi più avviare la contrattazione su questo articolo', 1),
(6104, 5, '410301', '该分享未开启砍价', 'La condivisione non è stata aperta per la contrattazione', 1),
(6105, 5, '410302', '您已经帮砍过此砍价', 'Hai già contribuito a ridurre il prezzo', 1),
(6106, 5, '410303', '砍价信息没有查到', 'Le informazioni di contrattazione non sono state trovate', 1),
(6107, 5, '410304', '用户砍价信息未查到', 'Informazioni sulla contrattazione utente non trovate', 1),
(6108, 5, '410305', '请选择有效的商品属性', 'Seleziona un attributo prodotto valido', 1),
(6109, 5, '410306', '砍价商品不存在', 'L`oggetto affare non esiste', 1),
(6110, 5, '410307', '砍价失败', 'Contrattazione fallita', 1),
(6111, 5, '410308', '砍价未成功', 'Contrattazione fallita', 1),
(6112, 5, '410309', '砍价已支付', 'Contrattazione pagata', 1),
(6113, 5, '410310', '您不能再帮砍此件商品', 'Non puoi più aiutare a tagliare questo oggetto', 1),
(6114, 5, '410311', '商品已被删除', 'L`oggetto è stato cancellato', 1),
(6115, 5, '410312', '拼团不存在或已下架,请手动申请退款', 'Il gruppo non esiste o è stato rimosso, richiedere il rimborso manualmente', 1),
(6116, 5, '410313', '每个订单限购{:num}件', 'Ogni ordine è limitato a {:num} pezzi', 1),
(6117, 5, '410314', '未查到拼团信息，无法取消', 'Impossibile cancellare le informazioni sul gruppo perché non sono state trovate informazioni sul gruppo', 1),
(6118, 5, '410315', '拼团已到期', 'Il gruppo è scaduto', 1),
(6119, 5, '410316', '拼团已完成，无法取消', 'Il raggruppamento è stato completato e non può essere cancellato', 1),
(6120, 5, '410317', '每人限购{:num}件', 'Limite {:num} pezzi per persona', 1),
(6121, 5, '410318', '抽奖不存在', 'La lotteria non esiste', 1),
(6122, 5, '410319', '领取成功', 'Ricevuto con successo', 1),
(6123, 5, '410320', '领取失败', 'Impossibile rivendicare', 1),
(6124, 5, '410321', '活动未开始', 'Evento non iniziato', 1),
(6125, 5, '410322', '活动已结束', 'Evento terminato', 1),
(6126, 5, '410323', '您已有这张优惠券，请勿重复购买', 'Hai già questo coupon, per favore non comprarlo più', 1),
(6127, 5, '410324', '请核对快递公司编码', 'Si prega di verificare il codice del corriere', 1),
(6128, 5, '410325', '请选择发票', 'Seleziona una fattura', 1),
(6129, 5, '-1', '系统繁忙，请稍候再试', 'Il sistema è occupato, per favore riprova più tardi', 1),
(6130, 5, '43104', 'appid与openid不匹配', 'appid non corrisponde a openid', 1),
(6131, 5, '45009', '达到微信api每日限额上限', 'È stato raggiunto il limite giornaliero delle API di WeChat', 1),
(6132, 5, '45008', '图文消息超过限制', 'Il messaggio di testo supera il limite', 1),
(6133, 5, '45007', '语音播放时间超过限制', 'Il tempo di riproduzione della voce supera il limite', 1),
(6134, 5, '45006', '图片链接字段超过限制', 'Il campo del link dell`immagine supera il limite', 1),
(6135, 5, '45005', '链接字段超过限制', 'Il campo del collegamento supera il limite', 1),
(6136, 5, '45004', '描述字段超过限制', 'Il campo della descrizione supera il limite', 1),
(6137, 5, '45003', '标题字段超过限制', 'Il campo del titolo supera il limite', 1),
(6138, 5, '45002', '消息内容超过限制', 'Il contenuto del messaggio supera il limite', 1),
(6139, 5, '45001', '多媒体文件大小超过限制', 'La dimensione del file multimediale supera il limite', 1),
(6140, 5, '44004', '文本消息内容为空', 'Il contenuto del messaggio di testo è vuoto', 1),
(6141, 5, '44003', '图文消息内容为空', 'Il contenuto del messaggio di testo è vuoto', 1),
(6142, 5, '44002', 'POST 的数据包为空', 'Il pacchetto POST è vuoto', 1),
(6143, 5, '44001', '多媒体文件为空', 'Il file multimediale è vuoto', 1),
(6144, 5, '43019', '需要将接收者从黑名单中移除', 'Il destinatario deve essere rimosso dalla blacklist', 1),
(6145, 5, '43005', '需要好友关系', 'Ho bisogno di una relazione amica', 1),
(6146, 5, '43004', '需要接收者关注', 'Richiede l`attenzione del destinatario', 1),
(6147, 5, '43003', '需要 HTTPS 请求', 'Richiede richiesta HTTPS', 1),
(6148, 5, '43002', '需要 POST 请求', 'Richiede una richiesta POST', 1),
(6149, 5, '43001', '需要 GET 请求', 'Richiede una richiesta GET', 1),
(6150, 5, '42007', '用户修改微信密码， accesstoken 和 refreshtoken 失效，需要重新授权', 'Gli utenti modificano la password WeChat, accesstoken e refreshtoken non sono validi e devono essere nuovamente autorizzati', 1),
(6151, 5, '42003', 'oauth_code 超时', 'oauth_code scaduto', 1),
(6152, 5, '42002', 'refresh_token 超时', 'refresh_token scaduto', 1),
(6153, 5, '42001', 'access_token 超时，请检查 access_token 的有效期，请参考基础支持 - 获取 access_token 中，对 access_token 的详细机制说明', 'Il token di accesso è scaduto, controlla il periodo di validità del token di accesso, fai riferimento a Supporto di base - Ottenere il token di accesso, il meccanismo dettagliato del token di accesso', 1),
(6154, 5, '41009', '缺少 openid', 'Openid mancante', 1),
(6155, 5, '41008', '缺少 oauth code', 'Codice di autenticazione mancante', 1),
(6156, 5, '41007', '缺少子菜单数据', 'Dati del sottomenu mancanti', 1),
(6157, 5, '41006', '缺少 media_id 参数', 'Parametro media_id mancante', 1),
(6158, 5, '41005', '缺少多媒体文件数据', 'Dati file multimediali mancanti', 1),
(6159, 5, '41004', '缺少 secret 参数', 'Parametro segreto mancante', 1),
(6160, 5, '41003', '缺少 refresh_token 参数', 'Parametro refresh_token mancante', 1),
(6161, 5, '41002', '缺少 appid 参数', 'Parametro appid mancante', 1),
(6162, 5, '41001', '缺少 access_token 参数', 'Parametro access_token mancante', 1),
(6163, 5, '40163', 'oauth_code已使用', 'è usato oauth_code', 1),
(6164, 5, '40155', '请勿添加其他公众号的主页链接', 'Non aggiungere link alle homepage di altri account ufficiali', 1),
(6165, 5, '40137', '不支持的图片格式', 'Formato immagine non supportato', 1),
(6166, 5, '40132', '微信号不合法', 'L`ID Wechat non è valido', 1),
(6167, 5, '40125', '无效的appsecret', 'Segreto app non valido', 1),
(6168, 5, '40121', '不合法的 media_id 类型', 'Tipo di media_id illegale', 1),
(6169, 5, '40120', '子 button 类型错误', 'Errore tipo sottopulsante', 1),
(6170, 5, '40119', 'button 类型错误', 'errore tipo pulsante', 1),
(6171, 5, '40118', 'media_id 大小不合法', 'La dimensione di media_id non è valida', 1),
(6172, 5, '40117', '分组名字不合法', 'Il nome del gruppo non è valido', 1),
(6173, 5, '40060', '删除单篇图文时，指定的 article_idx 不合法', 'Quando si elimina una singola immagine, l`idx_articolo specificato non è valido', 1),
(6174, 5, '40051', '分组名字不合法', 'Il nome del gruppo non è valido', 1),
(6175, 5, '40050', '不合法的分组 id', 'ID gruppo illegale', 1),
(6176, 5, '40048', '无效的url', 'URL non valido', 1),
(6177, 5, '40039', '不合法的 URL 长度', 'Lunghezza URL illegale', 1),
(6178, 5, '40035', '不合法的参数', 'Parametro non valido', 1),
(6179, 5, '40038', '不合法的请求格式', 'Formato richiesta illegale', 1),
(6180, 5, '40033', '不合法的请求字符，不能包含 \\uxxxx 格式的字符', 'Carattere di richiesta illegale, non può contenere caratteri in formato \\uxxxx', 1),
(6181, 5, '40032', '不合法的 openid 列表长度', 'Lunghezza dell`elenco di openid illegale', 1),
(6182, 5, '40031', '不合法的 openid 列表', 'Lista openid illegale', 1),
(6183, 5, '40030', '不合法的 refresh_token', 'Recupero_token illegale', 1),
(6184, 5, '40029', '无效的 oauth_code', 'Oauth_code non valido', 1),
(6185, 5, '40028', '不合法的自定义菜单使用用户', 'Utente menu personalizzato illegale', 1),
(6186, 5, '40027', '不合法的子菜单按钮 URL 长度', 'Lunghezza URL pulsante sottomenu illegale', 1),
(6187, 5, '40026', '不合法的子菜单按钮 KEY 长度', 'Lunghezza chiave pulsante sottomenu illegale', 1),
(6188, 5, '40025', '不合法的子菜单按钮名字长度', 'Lunghezza nome pulsante sottomenu illegale', 1),
(6189, 5, '40024', '不合法的子菜单按钮类型', 'Tipo di pulsante di sottomenu illegale', 1),
(6190, 5, '40023', '不合法的子菜单按钮个数', 'Numero illegale di pulsanti di sottomenu', 1),
(6191, 5, '40022', '不合法的子菜单级数', 'Livello di sottomenu illegale', 1),
(6192, 5, '40021', '不合法的菜单版本号', 'Numero di versione del menu illegale', 1),
(6193, 5, '40020', '不合法的按钮 URL 长度', 'Lunghezza URL pulsante illegale', 1),
(6194, 5, '40019', '不合法的按钮 KEY 长度', 'Lunghezza CHIAVE pulsante illegale', 1),
(6195, 5, '40018', '不合法的按钮名字长度', 'Lunghezza nome pulsante illegale', 1),
(6196, 5, '40017', '不合法的按钮类型', 'Tipo di pulsante illegale', 1),
(6197, 5, '40016', '不合法的按钮个数', 'Numero di bottoni illegali', 1),
(6198, 5, '40015', '不合法的菜单类型', 'Tipo di menu illegale', 1),
(6199, 5, '40014', '不合法的 access_token ，请开发者认真比对 access_token 的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口', 'token di accesso illegale, per favore confronta attentamente la validità del token di accesso (ad esempio se è scaduto), o controlla se l`interfaccia è stata chiamata per l`account ufficiale appropriato', 1),
(6200, 5, '40013', '不合法的 AppID ，请开发者检查 AppID 的正确性，避免异常字符，注意大小写', 'AppID illegale, verificare la correttezza di AppID, evitare caratteri anomali, prestare attenzione alle maiuscole', 1),
(6201, 5, '40012', '不合法的缩略图文件大小', 'Dimensione file miniatura illegale', 1),
(6202, 5, '40011', '不合法的视频文件大小', 'Dimensioni file video illegali', 1),
(6203, 5, '40010', '不合法的语音文件大小', 'Dimensione file vocale illegale', 1),
(6204, 5, '40009', '不合法的图片文件大小', 'Dimensioni file immagine non valide', 1),
(6205, 5, '40008', '不合法的消息类型', 'Tipo di messaggio illegale', 1),
(6206, 5, '40007', '不合法的媒体文件 id', 'ID file multimediale non valido', 1),
(6207, 5, '40006', '不合法的文件大小', 'Dimensioni file non consentite', 1),
(6208, 5, '40005', '不合法的文件类型', 'Tipo di file illegale', 1),
(6209, 5, '40004', '不合法的媒体文件类型', 'Tipo di file multimediale illegale', 1),
(6210, 5, '40003', '不合法的 OpenID ，请开发者确认 OpenID （该用户）是否已关注公众号，或是否是其他公众号的 OpenID', 'OpenID illegale, per favore conferma se OpenID (l`utente) ha seguito l`account ufficiale, o se è l`OpenID di un altro account ufficiale', 1),
(6211, 5, '40002', '不合法的凭证类型', 'Tipo di certificato illegale', 1),
(6212, 5, '40001', '获取 access_token 时 AppSecret 错误，或者 access_token 无效。请开发者认真比对 AppSecret 的正确性，或查看是否正在为恰当的公众号调用接口', 'AppSecret è errato quando si ottiene access_token, o access_token non è valido. Verificare attentamente la correttezza di AppSecret, o verificare se l`interfaccia è stata chiamata per l`account ufficiale appropriato', 1),
(6213, 5, '200011', '此账号已被封禁，无法操作', 'Questo account è stato bannato e non può essere utilizzato', 1),
(6214, 5, '200012', '个人模版数已达上限，上限25个', 'Il numero di modelli personali ha raggiunto il limite superiore, il limite superiore è 25', 1),
(6215, 5, '200014', '请检查小程序所属类目', 'Controlla la categoria dell`applet', 1),
(6216, 6, '100000', '保存成功', '保存成功', 1),
(6217, 6, '100001', '修改成功', '修正成功', 1),
(6218, 6, '100002', '删除成功', '削除成功', 1),
(6219, 6, '100003', '显示成功', '表示成功', 1),
(6220, 6, '100004', '隐藏成功', '隠された成功', 1),
(6221, 6, '100005', '操作失败', '操作に失敗しました', 1),
(6222, 6, '100006', '保存失败', '保存に失敗しました', 1),
(6223, 6, '100007', '修改失败', '変更に失敗しました', 1),
(6224, 6, '100008', '删除失败', '削除に失敗しました', 1),
(6225, 6, '100009', '图片上传成功', '画像のアップロードに成功しました', 1),
(6226, 6, '100010', '操作成功', '操作は成功しました', 1),
(6227, 6, '100011', '暂无数据', 'データなし', 1),
(6228, 6, '100012', '更新成功', '更新成功', 1),
(6229, 6, '100013', '更新失败', '更新に失敗しました', 1),
(6230, 6, '100014', '设置成功', '正常に設定されました', 1),
(6231, 6, '100015', '设置失败', 'セットアップに失敗しました', 1),
(6232, 6, '100016', '获取失败', '取得に失敗しました', 1),
(6233, 6, '100017', '提交成功', '正常に送信', 1),
(6234, 6, '100018', '提交失败', '送信に失敗しました', 1),
(6235, 6, '100019', '取消成功', '成功をキャンセル', 1),
(6236, 6, '100020', '取消失败', 'キャンセルに失敗しました', 1),
(6237, 6, '100021', '添加成功', '正常に追加されました', 1),
(6238, 6, '100022', '添加失败', '追加に失敗しました', 1),
(6239, 6, '100023', '保存token失败', 'トークンの保存に失敗しました', 1),
(6240, 6, '100024', '备注成功', 'コメントは成功しました', 1),
(6241, 6, '100025', '备注失败', 'リマークに失敗しました', 1),
(6242, 6, '100026', '数据不存在', 'データが存在しません', 1),
(6243, 6, '100027', '申请成功', 'アプリケーションの成功', 1),
(6244, 6, '100028', '申请失败', '申請に失敗しました', 1),
(6245, 6, '100029', '暂无此方法', 'そのような方法はありません', 1),
(6246, 6, '100030', '发送成功', '送信成功', 1),
(6247, 6, '100031', '发送失败', '送信に失敗しました', 1),
(6248, 6, '100032', '上传成功', 'アップロード成功', 1),
(6249, 6, '100033', '上传失败', 'アップロードに失敗しました', 1),
(6250, 6, '100034', '移动成功', '正常に移動しました', 1),
(6251, 6, '100035', '移动失败', '移動に失敗しました', 1),
(6252, 6, '100036', '退款成功', '払い戻し成功', 1),
(6253, 6, '100037', '退款失败', '払い戻しに失敗しました', 1),
(6254, 6, '100038', '同步成功', '同期に成功しました', 1),
(6255, 6, '100039', '同步失败', '同期に失敗しました', 1),
(6256, 6, '100040', '恢复成功', '復元成功', 1),
(6257, 6, '100041', '恢复失败', '復元に失敗しました', 1),
(6258, 6, '100042', '退出成功', '正常に終了しました', 1),
(6259, 6, '100043', '退出失败', '終了に失敗しました', 1),
(6260, 6, '100044', '开通成功', '正常に開きました', 1),
(6261, 6, '100045', '开通失败', 'アクティブ化に失敗しました', 1),
(6262, 6, '100046', '清除数据成功', 'データを正常に消去', 1),
(6263, 6, '100047', '优化成功', '最適化成功', 1),
(6264, 6, '100048', '优化失败', '最適化に失敗しました', 1),
(6265, 6, '100049', '修复成功', '修復成功', 1),
(6266, 6, '100050', '修复失败', '修復に失敗しました', 1),
(6267, 6, '100051', '备份成功', 'バックアップ成功', 1),
(6268, 6, '100052', '备份失败', 'バックアップに失敗しました', 1),
(6269, 6, '100100', '参数错误', 'パラメータ エラー', 1),
(6270, 6, '100101', '非法操作', '不正な操作', 1),
(6271, 6, '100102', '数据获取失败', 'データ取得に失敗しました', 1),
(6272, 6, '100103', '站点升级中，请稍候访问', 'サイトはアップグレード中です。後でアクセスしてください', 1),
(6273, 6, '100104', '缺少code', '不足しているコード', 1),
(6274, 6, '110000', '您暂时没有访问权限', '一時的にアクセス権がありません', 1),
(6275, 6, '110001', '接口未授权，您无法访问', 'インターフェースが認証されていないため、アクセスできません', 1),
(6276, 6, '110002', '请登录', 'ログインしてください', 1),
(6277, 6, '110003', '登录已过期,请重新登录', 'ログインの有効期限が切れています。再度ログインしてください', 1),
(6278, 6, '110004', '登录状态有误,请重新登录', 'ログイン ステータスが正しくありません。もう一度ログインしてください', 1),
(6279, 6, '110005', '请登录', 'ログインしてください', 1),
(6280, 6, '110006', '登录已过期,请重新登录', 'ログインの有効期限が切れています。再度ログインしてください', 1),
(6281, 6, '110007', '登录状态有误,请重新登录', 'ログイン ステータスが正しくありません。もう一度ログインしてください', 1),
(6282, 6, '400000', '请选择用户头像', 'ユーザーアバターを選択してください', 1),
(6283, 6, '400001', '请填写用户昵称', 'ユーザーのニックネームを入力してください', 1),
(6284, 6, '400002', '请填写评论内容', 'コメントを記入してください', 1),
(6285, 6, '400003', '请选择商品分数', '製品スコアを選択してください', 1),
(6286, 6, '400004', '请选择服务分数', 'サービス スコアを選択してください', 1),
(6287, 6, '400005', '商品分数必须是1-5之间的整数', '商品スコアは 1 ～ 5 の整数でなければなりません', 1),
(6288, 6, '400006', '服务分数必须是1-5之间的整数', 'サービス スコアは 1 ～ 5 の整数でなければなりません', 1),
(6289, 6, '400007', '请选择快递公司', '宅配業者を選択してください', 1),
(6290, 6, '400008', '请填写寄件人姓名', '差出人の名前を記入してください', 1),
(6291, 6, '400009', '请输入寄件人手机号码', '送信者の携帯電話番号を入力してください', 1),
(6292, 6, '400010', '寄件人手机号码不正确', '送信者の携帯電話番号が正しくありません', 1),
(6293, 6, '400011', '请填写寄件人详细地址', '差出人の詳細な住所を記入してください', 1),
(6294, 6, '400012', '请填写云打印机编号', 'クラウド プリンターの番号を入力してください', 1),
(6295, 6, '400013', '请传入套餐id', 'パッケージ ID を渡してください', 1),
(6296, 6, '400014', '套餐id必须为数字', 'パッケージ ID は数字でなければなりません', 1),
(6297, 6, '400015', '请填写套餐金额', 'パッケージの金額を入力してください', 1),
(6298, 6, '400016', '请填写购买数量', '購入数量を入力してください', 1),
(6299, 6, '400017', '购买数量必须为数字', '購入数量は数値でなければなりません', 1),
(6300, 6, '400018', '请填写购买套餐类型', '購入パッケージの種類を入力してください', 1),
(6301, 6, '400019', '您输入的手机号码必须为数字', '入力する携帯電話番号は数字でなければなりません', 1),
(6302, 6, '400020', '密码必须填写', 'パスワードを入力する必要があります', 1),
(6303, 6, '400021', '短信验证码必须为数字', 'SMS 確認コードは数字でなければなりません', 1),
(6304, 6, '400022', '请填写话术内容', '言語の内容を記入してください', 1),
(6305, 6, '400023', '请填写排序数字', 'ソート番号を入力してください', 1),
(6306, 6, '400024', '请填写排序数字', 'ソート番号を入力してください', 1),
(6307, 6, '400025', '请填写运费模板名称', '配送テンプレートの名前を入力してください', 1),
(6308, 6, '400026', '运费信息必须为数组', '配送情報は配列でなければなりません', 1),
(6309, 6, '400027', '包邮信息必须为数组', 'パッケージ情報は配列でなければなりません', 1),
(6310, 6, '400028', '不送达信息必须为数组', '配信されていない情報は配列でなければなりません', 1),
(6311, 6, '400029', 'type数据格式错误，应为1或2或3', 'タイプ データ形式エラー、1 または 2 または 3 である必要があります', 1),
(6312, 6, '400030', 'appoint数据格式错误，应为0或1', '任命データ形式が正しくありません。0 または 1 である必要があります', 1),
(6313, 6, '400031', 'no_delivery数据格式错误，应为0或1', 'no_delivery データ形式エラー、0 または 1 でなければなりません', 1),
(6314, 6, '400032', 'sort数据格式错误，应为整数', 'ソートデータフォーマットエラー、整数でなければなりません', 1),
(6315, 6, '400033', '请填写管理员账号', '管理者アカウントを入力してください', 1),
(6316, 6, '400034', '管理员账号为英文字母', '管理者アカウントは英字です', 1),
(6317, 6, '400035', '请输管理员姓名', '管理者の名前を入力してください', 1),
(6318, 6, '400036', '请选择管理员身份', '管理者 ID を選択してください', 1),
(6319, 6, '400037', '身份必须为数组', 'ID は配列でなければなりません', 1),
(6320, 6, '400038', '请填写城市名称', '都市名を入力してください', 1),
(6321, 6, '400039', 'level数据格式错误，应为整数', 'レベル データ形式エラー、整数でなければなりません', 1),
(6322, 6, '400040', 'parent_id数据格式错误，应为整数', 'parent_id データ形式エラー、整数でなければなりません', 1),
(6323, 6, '400041', '请输入有效的网址', '有効な URL を入力してください', 1),
(6324, 6, '400042', '一级返佣比例必须为数字', '第 1 レベルのリベート率は数値でなければなりません', 1),
(6325, 6, '400043', '一级返佣比例最多两位小数', '第 1 レベルのリベート率は小数点以下 2 桁までです', 1),
(6326, 6, '400044', '一级返佣比例填写范围在0-100之间', '第 1 レベルのリベート率は 0 ～ 100 の範囲を満たします', 1),
(6327, 6, '400045', '二级返佣比例必须为数字', '第 2 レベルのリベート率は数値でなければなりません', 1),
(6328, 6, '400046', '二级返佣比例最多两位小数', '第 2 レベルのリベート率は小数点以下 2 桁までです', 1),
(6329, 6, '400047', '二级返佣比例填写范围在0-100之间', '第 2 レベルのリベート率は 0 ～ 100 の範囲を満たします', 1),
(6330, 6, '400048', '待补货数量必须为数字', '補充する数量は数値でなければなりません', 1),
(6331, 6, '400049', '警戒库存必须为数字', 'アラート在庫は数値でなければなりません', 1),
(6332, 6, '400050', '提现最小金额只能为数字', '最低出金額は数字のみです', 1),
(6333, 6, '400051', '提现最小金额必须大于0', '最低出金額は 0 より大きくなければなりません', 1),
(6334, 6, '400052', '佣金冻结时间范围在0-180之间', 'コミッションの凍結時間の範囲は 0 ～ 180 です', 1),
(6335, 6, '400053', '满额分销金额金额必须为数字', '完全な分配額は数値でなければなりません', 1),
(6336, 6, '400054', '积分抵用比例必须为数字', 'ポイントのクレジット率は数値でなければなりません', 1),
(6337, 6, '400055', '积分抵用比例最多两位小数', '控除可能なポイントのパーセンテージは、小数点以下 2 桁までです', 1),
(6338, 6, '400056', '积分抵用比例必须在0-1000之间', 'クレジット ポイントのパーセンテージは 0 から 1000 の間でなければなりません', 1),
(6339, 6, '400057', '积分抵用上限必须为数字', '与信限度額の上限は数値でなければなりません', 1),
(6340, 6, '400058', '积分抵用上限必须大于等于0', '減点の上限は 0 以上でなければなりません', 1),
(6341, 6, '400059', '下单赠送积分必须为数字', '注文ボーナス ポイントは数字でなければなりません', 1),
(6342, 6, '400060', '下单赠送积分必须在0-1000之间', 'オーダー ボーナス ポイントは 0 ～ 1000 の間でなければなりません', 1),
(6343, 6, '400061', '普通商品未支付取消订单时间必须为数字', '通常の商品は支払われていません。キャンセル時間は数値でなければなりません', 1),
(6344, 6, '400062', '活动商品未支付取消订单时间必须为数字', 'イベントアイテムの代金が支払われていない場合、注文キャンセルの時間は数字でなければなりません', 1),
(6345, 6, '400063', '砍价商品未支付取消订单时间必须为数字', '特売品が支払われない場合、注文をキャンセルする時間は数値でなければなりません', 1),
(6346, 6, '400064', '拼团商品未支付取消订单时间必须为数字', 'グループ商品が支払われない場合、注文をキャンセルする時間は数値でなければなりません', 1),
(6347, 6, '400065', '订单发货后自动收货时间必须为数字', '注文が出荷された後の自動受領時間は数値でなければなりません', 1),
(6348, 6, '400066', '满额包邮金额必须为数字', '全額を含む送料無料の金額は数値でなければなりません', 1),
(6349, 6, '400067', '积分倍数必须大于0', '整数倍は 0 より大きい必要があります', 1),
(6350, 6, '400068', '折扣数必须大于0', '割引の数は 0 より大きくなければなりません', 1),
(6351, 6, '400069', '积分倍数必须大于0', '整数倍は 0 より大きい必要があります', 1),
(6352, 6, '400070', '折扣数必须大于0', '割引の数は 0 より大きくなければなりません', 1),
(6353, 6, '400071', '下单赠送经验比率必须为数字', '注文時の報酬経験率は数値でなければなりません', 1),
(6354, 6, '400072', '下单赠送经验比率必须大于0', '注文ボーナスの経験率は 0 より大きくなければなりません', 1),
(6355, 6, '400073', '签到赠送经验必须为数字', 'サインイン経験は数値でなければなりません', 1),
(6356, 6, '400074', '签到赠送经验必须大于0', 'サインイン エクスペリエンスは 0 より大きい必要があります', 1),
(6357, 6, '400075', '邀请新用户赠送经验必须为数字', '経験を与えるために新しいユーザーを招待するのは数字でなければなりません', 1),
(6358, 6, '400076', '邀请新用户赠送经验必须大于0', '新しいユーザーを経験値として招待するには、0 より大きくする必要があります', 1),
(6359, 6, '400077', '发货人姓名必须为汉字', '差出人の名前は漢字でなければなりません', 1),
(6360, 6, '400078', '发货人姓名长度在2-10位', '送信者名の長さは 2 ～ 10 桁です', 1),
(6361, 6, '400079', '发货人电话必须为数字', '送信者の電話番号は数字でなければなりません', 1),
(6362, 6, '400080', '发货人电话请填写有效的手机号', '送信者の電話番号には有効な携帯電話番号を入力してください', 1),
(6363, 6, '400081', '发货人地址只能是汉字、字母、数字', '送信者のアドレスは漢字、文字、数字のみです', 1),
(6364, 6, '400082', '发货人地址长度为10-100位', '送信者のアドレスの長さは 10 ～ 100 桁です', 1),
(6365, 6, '400083', '电子面单打印机编号必须为数字、字母', '電子フォームのプリンターの番号は、数字と文字でなければなりません', 1),
(6366, 6, '400084', '电子面单打印机编号长度为10-50位', '電子シングル プリンターのシリアル番号の長さは 10 ～ 50 桁です', 1),
(6367, 6, '400085', '客服反馈长度位10-90位', 'カスタマー サービスのフィードバックの長さは 10 ～ 90 桁です', 1),
(6368, 6, '400086', '请填写标签分类名称', 'ラベルのカテゴリ名を入力してください', 1),
(6369, 6, '400087', '请填写标签分类排序', 'ラベル分類順を記入してください', 1),
(6370, 6, '400088', '标签分类必须为数字', 'ラベル分類は数値でなければなりません', 1),
(6371, 6, '400089', '账号只能为数字和字母', '口座番号は数字と文字のみです', 1),
(6372, 6, '400090', '限量不能超过商品库存', '制限は製品在庫を超えることはできません', 1),
(6373, 6, '400091', '商品已下架或移入回收站', 'アイテムは棚から削除されたか、ごみ箱に移動されました', 1),
(6374, 6, '400092', '占用库存失败', '在庫の占有に失敗しました', 1),
(6375, 6, '400093', '商品已下架或已删除', '商品は棚から取り除かれたか、削除されました', 1),
(6376, 6, '400094', '请选择有效的商品属性', '有効な製品属性を選択してください', 1),
(6377, 6, '400095', '金额不能小于0', '金額を 0 未満にすることはできません', 1),
(6378, 6, '400096', '结束时间不能小于今天', '終了時刻を今日より短くすることはできません', 1),
(6379, 6, '400097', '您不是付费会员', 'あなたは有料会員ではありません', 1),
(6380, 6, '400098', '暂时无法领取', '一時的に利用できません', 1),
(6381, 6, '400099', '请先配置小票打印开发者', '最初にレシート印刷の開発者を設定してください', 1),
(6382, 6, '400100', '请填写分类名称', 'カテゴリ名を入力してください', 1),
(6383, 6, '400101', '该分类已存在', 'このカテゴリは既に存在します', 1),
(6384, 6, '400102', '请先删除子分类', '最初にサブカテゴリを削除してください', 1),
(6385, 6, '400103', '分类不存在', '分類が存在しません', 1),
(6386, 6, '400104', '文件名称不能为空', 'ファイル名を空にすることはできません', 1),
(6387, 6, '400105', '该分类有下级分类，无法修改上级', 'このカテゴリにはサブカテゴリがあり、上位を変更することはできません', 1),
(6388, 6, '400106', '备注不能为空', 'コメントを空にすることはできません', 1),
(6389, 6, '400107', '请输入姓名', 'あなたの名前を入力してください', 1),
(6390, 6, '400108', '请输入提现金额', '出金額を入力してください', 1),
(6391, 6, '400109', '请输入支付宝账号', 'アリペイの口座番号を入力してください', 1),
(6392, 6, '400110', '请输入微信账号', 'WeChat アカウントを入力してください', 1),
(6393, 6, '400111', '请输入银行卡号', '銀行カード番号を入力してください', 1),
(6394, 6, '400112', '请输入开户行', '口座開設銀行を入力してください', 1),
(6395, 6, '400113', '拒绝理由不能为空', '拒否理由を空にすることはできません', 1),
(6396, 6, '400114', '不能重复收货', '商品を繰り返し受け取ることができません', 1),
(6397, 6, '400115', '请先发货或者送货', '最初に送信または配信してください', 1),
(6398, 6, '400116', '收货失败,请稍候再试', '商品の受け取りに失敗しました。後でもう一度お試しください', 1),
(6399, 6, '400117', '收货成功', '商品を受け取りました', 1),
(6400, 6, '400118', '订单不存在', '注文が存在しません', 1),
(6401, 6, '400119', '用户信息不存在', 'ユーザー情報がありません', 1),
(6402, 6, '400120', '快递单号不存在', 'エクスプレス追跡番号が存在しません', 1),
(6403, 6, '400121', '打印成功', '印刷成功', 1),
(6404, 6, '400122', '打印失败', '印刷に失敗しました', 1),
(6405, 6, '400123', '快递公司编号缺失', '宅配会社の番号がありません', 1),
(6406, 6, '400124', '请配置腾讯地图KEY', 'Tencent マップ KEY を設定してください', 1),
(6407, 6, '400125', '请选择门店位置', 'ストアの場所を選択してください', 1),
(6408, 6, '400126', '添加的核销员用户已存在', '追加された償却メンバー ユーザーは既に存在します', 1),
(6409, 6, '400127', '请选择所属提货点', '所属するピックアップポイントを選択してください', 1),
(6410, 6, '400128', '请填写核销员名称', '償却会員の名前を記入してください', 1),
(6411, 6, '400129', '请填写核销员电话', '確認担当者の電話番号を入力してください', 1),
(6412, 6, '400130', '核销员添加成功', '検証メンバーが正常に追加されました', 1),
(6413, 6, '400131', '核销员添加失败', '償却メンバーの追加に失敗しました', 1),
(6414, 6, '400132', '请填写手机号', '電話番号を入力してください', 1),
(6415, 6, '400133', '请填写账号', '口座番号を入力してください', 1),
(6416, 6, '400134', '请填写密码', 'パスワードを入力してください', 1),
(6417, 6, '400135', '请填写短信签名', 'SMS 署名を入力してください', 1),
(6418, 6, '400136', '短信签名最长为8位', '最長の SMS 署名は 8 桁です', 1),
(6419, 6, '400137', '请填写验证码', '認証コードを入力してください', 1),
(6420, 6, '400138', '请填写域名', 'ドメイン名を入力してください', 1),
(6421, 6, '400139', '登录成功', 'ログイン成功', 1),
(6422, 6, '400140', '账号或密码错误', 'アカウントまたはパスワードのエラー', 1),
(6423, 6, '400141', '请先填写短信配置', '最初に SMS 設定を入力してください', 1),
(6424, 6, '400142', '请输入模板名称', 'テンプレート名を入力してください', 1),
(6425, 6, '400143', '请输入模板内容', 'テンプレートの内容を入力してください', 1),
(6426, 6, '400144', '售后订单状态不支持该操作', 'アフター オーダー ステータスでは、この操作はサポートされていません', 1),
(6427, 6, '400145', '修改退款状态成功', '返金ステータスを正常に変更', 1),
(6428, 6, '400146', '请输入退款金额', '返金額を入力してください', 1),
(6429, 6, '400147', '已退完支付金额，不能再退款了', '支払い金額は返金されました。これ以上返金することはできません', 1),
(6430, 6, '400148', '退款金额大于支付金额，请修改退款金额', '返金額が支払い額を超えています。返金額を変更してください', 1),
(6431, 6, '400149', '退款成功', '返金成功', 1),
(6432, 6, '400150', '退款失败', '払い戻しに失敗しました', 1),
(6433, 6, '400151', '验证成功', '検証成功', 1),
(6434, 6, '400152', '核销成功', '償却が成功しました', 1),
(6435, 6, '400153', '核销订单未查到', '償却注文が見つかりません', 1),
(6436, 6, '400154', '核销失败', '検証に失敗しました', 1),
(6437, 6, '400155', '订单金额必须填写', '注文金額を入力する必要があります', 1),
(6438, 6, '400156', '请选择需要删除的订单', '削除する注文を選択してください', 1),
(6439, 6, '400157', '您选择的的订单存在用户未删除的订单', '選択した注文には、ユーザーが削除していない注文があります', 1),
(6440, 6, '400158', '请选择发货商品', '発送する商品を選択してください', 1),
(6441, 6, '400159', '请重新选择发货商品或发货件数', '配送商品または配送個数を再選択してください', 1),
(6442, 6, '400160', '订单已删除无法退积分', '注文が削除されたため、ポイントは返金できません', 1),
(6443, 6, '400161', '请输入积分', 'ポイントを入力してください', 1),
(6444, 6, '400162', '已退完积分', 'ポイントは返金されました', 1),
(6445, 6, '400163', '退积分大于支付积分，请修改退积分', '払い戻されたポイントが支払ったポイントを超えています。払い戻されたポイントを変更してください', 1),
(6446, 6, '400164', '退积分成功', 'ポイントが正常に返されました', 1),
(6447, 6, '400165', '退积分失败', 'ポイントの引き出しに失敗しました', 1),
(6448, 6, '400166', '请填写开票号', '請求番号を入力してください', 1),
(6449, 6, '400167', '请填写正确的开票号', '正しい請求番号を入力してください', 1),
(6450, 6, '400168', '请上传文件', 'ファイルをアップロードしてください', 1),
(6451, 6, '400169', '回复成功', '成功した返信', 1),
(6452, 6, '400170', '注册成功', '登録成功', 1),
(6453, 6, '400171', '注册失败', '登録に失敗しました', 1),
(6454, 6, '400172', '登录失败', 'ログインに失敗しました', 1),
(6455, 6, '400173', '获取套餐列表失败', 'パッケージ リストの取得に失敗しました', 1),
(6456, 6, '400174', '获取支付码失败', '支払いコードの取得に失敗しました', 1),
(6457, 6, '400175', '请先开通短信服务', '最初に SMS サービスを有効にしてください', 1),
(6458, 6, '400176', '请先开通物流查询服务', '最初にロジスティクス照会サービスを開いてください', 1),
(6459, 6, '400177', '请先开通电子面单打印服务', '最初に電子フェイス シングル プリント サービスを有効にしてください', 1),
(6460, 6, '400178', '请先开通商品采集服务', 'まず商品回収サービスを有効にしてください', 1),
(6461, 6, '400179', '请设置短信签名', 'SMS 署名を設定してください', 1),
(6462, 6, '400180', '修改短信签名成功', 'SMS 署名の変更に成功', 1),
(6463, 6, '400181', '默认模板不能删除', 'デフォルトのテンプレートは削除できません', 1),
(6464, 6, '400182', '管理员信息读取失败', '管理者情報の読み取りに失敗しました', 1),
(6465, 6, '400183', '密码太过简单，请输入较为复杂的密码', 'パスワードが単純すぎます。より複雑なパスワードを入力してください', 1),
(6466, 6, '400184', '协议类型不存在', 'プロトコル タイプが存在しません', 1),
(6467, 6, '400185', '清除成功', '明確な成功', 1),
(6468, 6, '400186', '清除失败', 'クリアに失敗しました', 1),
(6469, 6, '400187', '请输入名称', '名前を入力してください', 1),
(6470, 6, '400188', '请不要重复添加', '繰り返し追加しないでください', 1),
(6471, 6, '400189', '添加数据成功', 'データの追加に成功', 1),
(6472, 6, '400190', '请输入开始时间', '開始時刻を入力してください', 1),
(6473, 6, '400191', '请输入持续时间', '期間を入力してください', 1),
(6474, 6, '400192', '请输入0-23点之前的整点数', '0-23 時より前の整数を入力してください', 1),
(6475, 6, '400193', '请输入1-24点之前的整点数', '1 時から 24 時までの整数を入力してください', 1),
(6476, 6, '400194', '开始时间+持续时间不能大于24小时', '開始時間 + 継続時間は 24 時間を超えることはできません', 1),
(6477, 6, '400195', '时段已占用', 'タイムスロットが占有されています', 1),
(6478, 6, '400196', '请输入签到赠送积分', 'チェックインボーナスポイントを入力してください', 1),
(6479, 6, '400197', '请输入大于等于0的整数', '0 以上の整数を入力してください', 1),
(6480, 6, '400198', '请填写按钮名称', 'ボタン名を入力してください', 1),
(6481, 6, '400199', '没有查到此身份', 'ID が見つかりません', 1),
(6482, 6, '400200', '请输入等级名称', 'レベル名を入力してください', 1),
(6483, 6, '400201', '请输入等级', 'レベルに入ってください', 1),
(6484, 6, '400202', '请选择等级图标', 'レベルアイコンを選択してください', 1),
(6485, 6, '400203', '二级返佣比例不能大于一级', '第 2 レベルのリベートの比率は、第 1 レベルより大きくすることはできません', 1),
(6486, 6, '400204', '当前等级已存在', '現在のレベルは既に存在します', 1),
(6487, 6, '400205', '添加等级成功', 'レベルの追加に成功', 1),
(6488, 6, '400206', '编辑的等级不存在', '編集レベルが存在しません', 1),
(6489, 6, '400207', '请输入任务名称', 'タスク名を入力してください', 1),
(6490, 6, '400208', '请选择任务类型', 'タスクの種類を選択してください', 1),
(6491, 6, '400209', '请输入限定数量', '数量限定で入力してください', 1),
(6492, 6, '400210', '添加任务成功', 'タスクを正常に追加', 1),
(6493, 6, '400211', '编辑的任务不存在', '編集されたタスクは存在しません', 1),
(6494, 6, '400212', '获取推广二维码失败，请检查您的微信配置', 'プロモーション QR コードの取得に失敗しました。WeChat の設定を確認してください', 1),
(6495, 6, '400213', '上级推广人不能为自己', '優れたプロモーターは自分自身であってはならない', 1),
(6496, 6, '400214', '用户不存在', 'ユーザーが存在しません', 1),
(6497, 6, '400215', '上级用户不存在', '上級ユーザーが存在しません', 1),
(6498, 6, '400216', '当前推广人已经是所选人', '現在のプロモーターはすでに選択された人物です', 1),
(6499, 6, '400217', '上级推广人不能为自己下级', '優れたプロモーターは部下にはなれません', 1),
(6500, 6, '400218', '赠送成功', 'ギフト成功', 1),
(6501, 6, '400219', '赠送失败', 'ギフトに失敗しました', 1),
(6502, 6, '400220', '请输入身份名称', '識別名を入力してください', 1),
(6503, 6, '400221', '请选择最少一个权限', '少なくとも 1 つの権限を選択してください', 1),
(6504, 6, '400222', '添加身份成功', 'ID の追加に成功しました', 1),
(6505, 6, '400223', '添加身份失败', 'ID の追加に失敗しました', 1),
(6506, 6, '400224', '缺少APPID', 'APPID がありません', 1),
(6507, 6, '400225', '请先设置空间域名', '最初にスペース ドメイン名を設定してください', 1),
(6508, 6, '400226', '格式错误，请输入格式为：http://域名', '形式が正しくありません。次の形式で入力してください: http://ドメイン名', 1),
(6509, 6, '400227', '未有正在使用的存储空间', '使用中のストレージ容量がありません', 1),
(6510, 6, '400228', '切换云存储成功,请检查是否开启使用了存储空间', 'クラウド ストレージの切り替えに成功しました。ストレージ スペースが有効になっているかどうかを確認してください', 1),
(6511, 6, '400229', '切换本地存储成功', 'ローカル ストレージの切り替えに成功しました', 1),
(6512, 6, '400230', '请输入模板编号', 'テンプレート番号を入力してください', 1),
(6513, 6, '400231', '请输入模板编号已存在,请重新输入', '既に存在するテンプレート番号を入力してください。再入力してください', 1),
(6514, 6, '400232', '请输入模板ID', 'テンプレート ID を入力してください', 1),
(6515, 6, '400233', '请输入模板名', 'テンプレート名を入力してください', 1),
(6516, 6, '400234', '请输入回复内容', '返信内容を入力してください', 1),
(6517, 6, '400235', '添加模板消息成功', 'テンプレート メッセージが正常に追加されました', 1),
(6518, 6, '400236', '请先配置小程序appid、appSecret等参数', '最初にアプレットの appid、appSecret およびその他のパラメータを設定してください', 1),
(6519, 6, '400237', '二维码生成失败', 'QR コードの生成に失敗しました', 1),
(6520, 6, '400238', '请添加至少一个按钮', '少なくとも 1 つのボタンを追加してください', 1),
(6521, 6, '400239', '请输入关键字', 'キーワードを入力してください', 1),
(6522, 6, '400240', '请选择回复类型', '返信タイプを選択してください', 1),
(6523, 6, '400241', '回复类型有误', '返信タイプが間違っています', 1),
(6524, 6, '400242', '回复消息参数有误', '返信メッセージのパラメータが間違っています', 1),
(6525, 6, '400243', '请添加图文', '画像を追加してください', 1),
(6526, 6, '400244', '标题不能为空', 'タイトルを空にすることはできません', 1),
(6527, 6, '400245', '作者不能为空', '作成者を空にすることはできません', 1),
(6528, 6, '400246', '正文不能为空', 'テキストを空にすることはできません', 1),
(6529, 6, '400247', '摘要不能为空', 'サマリーを空にすることはできません', 1),
(6530, 6, '400248', '请先配置微信公众号appid、appSecret等参数', '最初に WeChat パブリック アカウント appid、appSecret およびその他のパラメーターを構成してください', 1),
(6531, 6, '400249', '模版消息一键设置成功', 'テンプレート メッセージのワンクリック設定が成功しました', 1),
(6532, 6, '400250', '请选择用户', 'ユーザーを選択してください', 1),
(6533, 6, '400251', '该用户没有绑定手机号，请手动填写', 'ユーザーは携帯電話番号に縛られていません。手動で入力してください', 1),
(6534, 6, '400252', '手机号格式错误', '携帯電話番号の形式エラー', 1),
(6535, 6, '400253', '客服已存在', 'カスタマー サービスは既に存在します', 1),
(6536, 6, '400254', '请输入账号', '口座番号を入力してください', 1),
(6537, 6, '400255', '账号必须为数字或者字母的组合4-30位', '口座番号は 4 ～ 30 桁または文字の組み合わせである必要があります', 1),
(6538, 6, '400256', '请输入密码', 'パスワードを入力してください', 1),
(6539, 6, '400257', '密码必须为数字或者字母的组合6-20位', 'パスワードは 6 ～ 20 桁の数字または文字の組み合わせである必要があります', 1),
(6540, 6, '400258', '该手机号的客服已存在', 'この電話番号のカスタマー サービスは既に存在します', 1),
(6541, 6, '400259', '该客服账号已存在', 'カスタマー サービス アカウントは既に存在します', 1),
(6542, 6, '400260', '客服添加成功', 'カスタマー サービスが正常に追加されました', 1),
(6543, 6, '400261', '客服添加失败', 'カスタマー サービスの追加に失敗しました', 1),
(6544, 6, '400262', '客服名称不能为空', 'カスタマー サービス名を空にすることはできません', 1),
(6545, 6, '400263', '请输入确认密码', '確認用パスワードを入力してください', 1),
(6546, 6, '400264', '两次输入的密码不一致', '2 回入力されたパスワードに一貫性がありません', 1),
(6547, 6, '400265', '用户不存在，客服将强制禁止登录', 'ユーザーが存在しません。カスタマー サービスが強制的にログインを禁止します', 1),
(6548, 6, '400266', '登录的客服不存在', 'ログインしたカスタマー サービスが存在しません', 1),
(6549, 6, '400267', '请先填写客服账号和密码再尝试进入客服平台', 'カスタマー サービス プラットフォームに入る前に、カスタマー サービス アカウントとパスワードを入力してください', 1),
(6550, 6, '400268', '反馈内容不存在', 'フィードバックの内容が存在しません', 1),
(6551, 6, '400269', '话术不能重复添加', '単語を繰り返し追加することはできません', 1),
(6552, 6, '400270', '创建话术成功', '単語の作成に成功', 1),
(6553, 6, '400271', '创建话术失败', 'トークの作成に失敗しました', 1),
(6554, 6, '400272', '删除的话术不存在', '削除された単語は存在しません', 1),
(6555, 6, '400273', '系统分类不能删除', 'システム分類は削除できません', 1),
(6556, 6, '400274', '请输入配置名称', '設定名を入力してください', 1),
(6557, 6, '400275', '请输入字段名称', 'フィールド名を入力してください', 1),
(6558, 6, '400276', '请输入配置简介', '構成プロファイルを入力してください', 1),
(6559, 6, '400277', '请输入文本框的宽度', 'テキスト ボックスの幅を入力してください', 1),
(6560, 6, '400278', '请输入正确的文本框的宽度', 'テキスト ボックスの正しい幅を入力してください', 1),
(6561, 6, '400279', '请输入多行文本框的宽度', '複数行テキスト ボックスの幅を入力してください', 1),
(6562, 6, '400280', '请输入多行文本框的高度', '複数行テキスト ボックスの高さを入力してください', 1),
(6563, 6, '400281', '请输入正确的多行文本框的宽度', '複数行テキスト ボックスの正しい幅を入力してください', 1),
(6564, 6, '400282', '请输入正确的多行文本框的宽度', '複数行テキスト ボックスの正しい幅を入力してください', 1),
(6565, 6, '400283', '请输入配置参数', '設定パラメータを入力してください', 1),
(6566, 6, '400284', '添加配置成功', '構成の追加に成功しました', 1),
(6567, 6, '400285', '一二级返佣比例不能大于100%', '第 1 および第 2 レベルのリベート率は 100% を超えることはできません', 1),
(6568, 6, '400286', '分销海报不能多于5张', '配布ポスターは 5 枚までです', 1),
(6569, 6, '400287', '提现最低金额只能为数字', '最低出金額は数字のみです', 1),
(6570, 6, '400288', '满额分销最低金额不能为空', '全額分配の最低金額を空にすることはできません', 1),
(6571, 6, '400289', '满额分销最低金额不能小于0', '完全な配布の最小量は 0 より小さくすることはできません', 1),
(6572, 6, '400290', '绑定有效期请填写正整数', '拘束力のある有効期間を正の整数で入力してください', 1),
(6573, 6, '400291', '请输入标题', 'タイトルを入力してください', 1),
(6574, 6, '400292', '添加配置分类成功', '設定カテゴリを正常に追加しました', 1),
(6575, 6, '400293', '存在下级配置，无法删除', '下位構成があり、削除できません', 1),
(6576, 6, '400294', '字段至少存在一个', '少なくとも 1 つのフィールドが存在します', 1),
(6577, 6, '400295', '添加数据组成功', 'データ グループが正常に追加されました', 1),
(6578, 6, '400296', '数据关键字已存在', 'データキーワードは既に存在します', 1),
(6579, 6, '400297', '字段不能为空', 'フィールドを空にすることはできません', 1),
(6580, 6, '400298', '不能大于四个', '4 つ以下', 1),
(6581, 6, '400299', '签到天数配置不能大于7天', 'チェックイン日の設定は 7 日を超えることはできません', 1),
(6582, 6, '400300', '关联成功', '正常に関連付けられました', 1),
(6583, 6, '400301', '关联失败', '関連付けに失敗しました', 1),
(6584, 6, '400302', '数据缓存刷新成功', 'データキャッシュが正常に更新されました', 1),
(6585, 6, '400303', '数据缓存刷新失败', 'データ キャッシュの更新に失敗しました', 1),
(6586, 6, '400304', '请输入需要更换的域名', '置き換えが必要なドメイン名を入力してください', 1),
(6587, 6, '400305', '域名不合法', 'ドメイン名が無効です', 1),
(6588, 6, '400306', '替换成功', '交換成功', 1),
(6589, 6, '400307', '初始化完成', '初期化完了', 1),
(6590, 6, '400308', '备份文件可能已经损坏，请检查', 'バックアップ ファイルが破損している可能性があります。確認してください', 1),
(6591, 6, '400309', '还原数据出错', 'データ復元エラー', 1),
(6592, 6, '400310', '正在还原...', '復元中...', 1),
(6593, 6, '400311', '还原完成', '復元完了', 1),
(6594, 6, '400312', '权益编辑成功', 'エクイティの編集が成功しました', 1),
(6595, 6, '400313', '卡片生成成功', 'カードは正常に生成されました', 1),
(6596, 6, '400314', '手机号已经存在', 'この電話番号は既に存在します', 1),
(6597, 6, '400315', '请输入正确的身份证', '正しい ID を入力してください', 1),
(6598, 6, '400316', '请选择分组', 'グループを選択してください', 1),
(6599, 6, '400317', '请选择标签', 'ラベルを選択してください', 1),
(6600, 6, '400318', '加入消息队列成功', 'メッセージ キューに正常に参加しました', 1),
(6601, 6, '400319', '注销成功', 'ログアウト成功', 1),
(6602, 6, '400320', '拒绝注销', 'ログアウトを拒否', 1),
(6603, 6, '400321', '请输入分组名称', 'グループ名を入力してください', 1),
(6604, 6, '400322', '会员标签不能为空', 'メンバー ラベルを空にすることはできません', 1),
(6605, 6, '400323', '该分类下有标签，请先删除标签', 'このカテゴリの下にラベルがあります。最初にラベルを削除してください', 1),
(6606, 6, '400324', '请输入等级名称', 'レベル名を入力してください', 1),
(6607, 6, '400325', '请输入等级', 'レベルに入ってください', 1),
(6608, 6, '400326', '请输入等级说明', 'レベルの説明を入力してください', 1),
(6609, 6, '400327', '请上传等级图标', 'レベル アイコンをアップロードしてください', 1),
(6610, 6, '400328', '请上传等级背景图标', 'レベル背景アイコンをアップロードしてください', 1),
(6611, 6, '400329', '请输入升级经验值', 'アップグレード経験値を入力してください', 1),
(6612, 6, '400330', '授权成功，写入数据库失败，请检查数据库链接配置', '認証は成功しましたが、データベースへの書き込みに失敗しました。データベース リンクの設定を確認してください', 1),
(6613, 6, '400331', '请填写公司名称', '会社名を入力してください', 1),
(6614, 6, '400332', '请填写授权域名', '承認済みドメイン名を入力してください', 1),
(6615, 6, '400333', '请填写手机号码', '携帯電話番号を入力してください', 1),
(6616, 6, '400334', '请填写订单id', 'オーダー ID を入力してください', 1),
(6617, 6, '400335', '申请授权成功', 'オーソリ申請成功', 1),
(6618, 6, '400336', '验证码错误', '検証コード エラー', 1),
(6619, 6, '400337', '请选择商品', '製品を選択してください', 1),
(6620, 6, '400338', '请输入商品名称', '商品名を入力してください', 1),
(6621, 6, '400339', '请选择背景图', '背景画像を選択してください', 1),
(6622, 6, '400340', '请输入直播价格', '生放送の価格を入力してください', 1),
(6623, 6, '400341', '直播价格必须大于0', '生放送の価格は 0 より大きくなければなりません', 1),
(6624, 6, '400342', '请输入直播间名称', 'ライブ配信ルームの名前を入力してください', 1),
(6625, 6, '400343', '请选择背景图', '背景画像を選択してください', 1),
(6626, 6, '400344', '请选择分享图', '画像の共有を選択してください', 1),
(6627, 6, '400345', '请选择主播', 'アンカーを選択してください', 1),
(6628, 6, '400346', '请选择直播开始、结束时间', '生放送の開始時間と終了時間を選択してください', 1),
(6629, 6, '400347', '请填写活动简介', 'イベント紹介を記入してください', 1),
(6630, 6, '400348', '请填写单位', '単位を入力してください', 1),
(6631, 6, '400349', '请选择商品轮播图', '製品カルーセルを選択してください', 1),
(6632, 6, '400350', '您设置得商品个数超出系统限制', '設定した製品の数がシステムの制限を超えています', 1),
(6633, 6, '400351', '模板不存在', 'テンプレートが存在しません', 1),
(6634, 6, '400352', '请输入页面名称', 'ページ名を入力してください', 1),
(6635, 6, '400353', '请选择活动时间段', '活動期間を選択してください', 1),
(6636, 6, '400354', '请填写购买数量限制', '購入数量制限を入力してください', 1),
(6637, 6, '400355', '购买数量限制必须大于0', '購入数量制限は 0 より大きくなければなりません', 1),
(6638, 6, '400356', '请填写帮砍次数', '助けて切った回数を記入してください', 1),
(6639, 6, '400357', '帮砍次数必须大于0', 'スラッシュの数は 0 より大きくなければなりません', 1),
(6640, 6, '400358', '请填写砍价人数', '交渉人数を記入してください', 1),
(6641, 6, '400359', '砍价人数必须大于1', '交渉する人の数は 1 より大きくなければなりません', 1),
(6642, 6, '400360', '请选择运费模板', '配送パターンを選択してください', 1),
(6643, 6, '400361', '请填写商品详情', '商品の詳細を入力してください', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(6644, 6, '400362', '请选择规格', '仕様を選択してください', 1),
(6645, 6, '400363', '请填写虚拟拼团比例', '仮想グループ比率を入力してください', 1),
(6646, 6, '400364', '虚拟参团人数不能大于成团人数', '仮想参加者の数は、グループ内の参加者の数より多くすることはできません', 1),
(6647, 6, '400365', '虚拟参团人数不能大于成团人数', '仮想参加者の数は、グループの参加者数より多くすることはできません', 1),
(6648, 6, '400366', '请填写单次购买数量', '単品購入数量を入力してください', 1),
(6649, 6, '400367', '单次购买数量必须大于0', '単一の購入数量は 0 より大きくなければなりません', 1),
(6650, 6, '400368', '请填写成团人数', 'グループの人数を入力してください', 1),
(6651, 6, '400369', '拼团人数不能小于2人', 'グループ内の人数を 2 人未満にすることはできません', 1),
(6652, 6, '400370', '请填写成团有效期', 'グループの有効期間を入力してください', 1),
(6653, 6, '400371', '成团有效期必须大于0', 'グループの有効期間は 0 より大きい必要があります', 1),
(6654, 6, '400372', '请填写优惠券名称', 'クーポン名を入力してください', 1),
(6655, 6, '400373', '请选择商品分类', '製品カテゴリを選択してください', 1),
(6656, 6, '400374', '请填写优惠券金额', 'クーポンの金額を入力してください', 1),
(6657, 6, '400375', '请填写优惠券最小使用金额', 'クーポンの最低利用額を入力してください', 1),
(6658, 6, '400376', '请填写优惠券有效期', 'クーポンの有効期間を入力してください', 1),
(6659, 6, '400377', '请选择秒杀时间段', 'seckill 期間を選択してください', 1),
(6660, 6, '400378', '请填写门店名称', '店舗名を入力してください', 1),
(6661, 6, '400379', '请填写门店简介', 'ストアのプロフィールを入力してください', 1),
(6662, 6, '400380', '请填写门店电话', '店舗の電話番号を入力してください', 1),
(6663, 6, '400381', '请选择提货点logo', 'ピックアップポイントのロゴを選択してください', 1),
(6664, 6, '400382', '请选择提货点大图', 'ピックアップ ポイントの大きな画像を選択してください', 1),
(6665, 6, '400383', '请选择地址', 'アドレスを選択してください', 1),
(6666, 6, '400384', '请填写详细地址', '詳しい住所を記入してください', 1),
(6667, 6, '400385', '请选择经纬度', '緯度と経度を選択してください', 1),
(6668, 6, '400386', '请选择营业时间', '営業時間を選択してください', 1),
(6669, 6, '400387', '短信账号必须填写', 'SMS アカウントを入力する必要があります', 1),
(6670, 6, '400388', '短信密码必须填写', 'SMS パスワードを入力する必要があります', 1),
(6671, 6, '400389', '订单号必须存在', '注文番号が存在する必要があります', 1),
(6672, 6, '400390', '订单号有误', '注文番号が正しくありません', 1),
(6673, 6, '400391', '订单号必须为字母和数字', '注文番号は文字と数字でなければなりません', 1),
(6674, 6, '400392', '订单金额必须填写', '注文金額を入力する必要があります', 1),
(6675, 6, '400393', '订单金额必须为数字', '注文金額は数値でなければなりません', 1),
(6676, 6, '400394', '订单金额必须填写', '注文金額を入力する必要があります', 1),
(6677, 6, '400395', '订单金额必须为数字', '注文金額は数値でなければなりません', 1),
(6678, 6, '400396', '订单邮费必须填写', '注文の送料を入力する必要があります', 1),
(6679, 6, '400397', '订单邮费必须为数字', '注文の送料は数字でなければなりません', 1),
(6680, 6, '400398', '赠送积分必须为数字', 'ボーナス ポイントは数字でなければなりません', 1),
(6681, 6, '400399', '请选择用户头像', 'ユーザーアバターを選択してください', 1),
(6682, 6, '400400', '请输入公司名称', '会社名を入力してください', 1),
(6683, 6, '400401', '添加公司成功', '会社が正常に追加されました', 1),
(6684, 6, '400402', '请输入月结账号', '毎月の口座番号を入力してください', 1),
(6685, 6, '400403', '请输入月结密码', '毎月のパスワードを入力してください', 1),
(6686, 6, '400404', '请输入取件网点', '乗車場所を入力してください', 1),
(6687, 6, '400405', '缩略图大图尺寸（高）必须为数字', 'サムネイル画像のサイズ (高さ) は数値でなければなりません', 1),
(6688, 6, '400406', '缩略图大图尺寸（高）必须大于等于0', 'サムネイルの大きな画像サイズ (高さ) は 0 以上でなければなりません', 1),
(6689, 6, '400407', '缩略图大图尺寸（宽）必须为数字', 'サムネイル画像のサイズ (幅) は数値でなければなりません', 1),
(6690, 6, '400408', '缩略图大图尺寸（宽）必须大于等于0', 'サムネイル画像のサイズ (幅) は 0 以上でなければなりません', 1),
(6691, 6, '400409', '缩略图中图尺寸（高）必须为数字', 'サムネイルの画像のサイズ (高さ) は数値でなければなりません', 1),
(6692, 6, '400410', '缩略图中图尺寸（高）必须大于等于0', 'サムネイルの画像のサイズ (高さ) は 0 以上でなければなりません', 1),
(6693, 6, '400411', '缩略图中图尺寸（宽）必须为数字', 'サムネイルの画像のサイズ (幅) は数値でなければなりません', 1),
(6694, 6, '400412', '缩略图中图尺寸（宽）必须大于等于0', 'サムネイルの画像のサイズ (幅) は 0 以上でなければなりません', 1),
(6695, 6, '400413', '缩略图小图尺寸（高）必须为数字', 'サムネイルのサイズ (高さ) は数値でなければなりません', 1),
(6696, 6, '400414', '缩略图小图尺寸（高）必须大于等于0', 'サムネイルのサイズ (高さ) は 0 以上でなければなりません', 1),
(6697, 6, '400415', '缩略图小图尺寸（宽）必须为数字', 'サムネイルのサイズ (幅) は数値でなければなりません', 1),
(6698, 6, '400416', '缩略图小图尺寸（宽）必须大于等于0', 'サムネイルのサイズ (幅) は 0 以上でなければなりません', 1),
(6699, 6, '400417', '水印文字只能是汉字、字母、数字', '透かしテキストには漢字、文字、数字のみを使用できます', 1),
(6700, 6, '400418', '水印文字长度为1-10位', 'ウォーターマーク テキストの長さは 1 ～ 10 桁です', 1),
(6701, 6, '400419', '水印文字大小必须为数字', '透かしテキストのサイズは数値でなければなりません', 1),
(6702, 6, '400420', '水印文字大小必须大于等于0', '透かしテキストのサイズは 0 以上でなければなりません', 1),
(6703, 6, '400421', '水印横坐标偏移量必须为数字', 'ウォーターマークの横座標のオフセットは数値でなければなりません', 1),
(6704, 6, '400422', '水印横坐标偏移量必须大于等于0', 'ウォーターマークの横座標のオフセットは 0 以上でなければなりません', 1),
(6705, 6, '400423', '水印纵坐标偏移量必须为数字', 'ウォーターマーク縦オフセットは数値でなければなりません', 1),
(6706, 6, '400424', '水印纵坐标偏移量必须大于等于0', '透かし縦オフセットは 0 以上でなければなりません', 1),
(6707, 6, '400425', '该主播已经存在', 'ホストは既に存在します', 1),
(6708, 6, '400426', '请先去小程序认证主播', 'アプレットにアクセスしてアンカーを認証してください', 1),
(6709, 6, '400427', '商品已创建', 'アイテムが作成されました', 1),
(6710, 6, '400428', '审核中或审核失败不允许此操作', 'この操作は、監査中または監査失敗中は許可されていません', 1),
(6711, 6, '400429', '在审核中或已经审核通过', '審査中または承認中', 1),
(6712, 6, '400430', '审核通过或失败', '承認が成功または失敗しました', 1),
(6713, 6, '400431', '商品审核中，无法删除', '商品は審査中のため削除できません', 1),
(6714, 6, '400432', '该主播不存在', 'アンカーが存在しません', 1),
(6715, 6, '400433', '开播时间需要在当前时间的10分钟后，并且开始时间不能在6个月后', '放送時間は現在時刻の 10 分後にする必要があり、開始時刻を 6 か月後にすることはできません', 1),
(6716, 6, '400434', '开播时间和结束时间间隔不得短于30分钟，不得超过24小时', '放送時間と終了時間の間の間隔は 30 分より短くしてはならず、24 時間を超えてはならない', 1),
(6717, 6, '400435', '请输入理由', '理由を入力してください', 1),
(6718, 6, '400436', '请选择正确的直播商品', '正しい製品を選択してください', 1),
(6719, 6, '400437', '直播间状态有误', 'ライブ ルームのステータスが正しくありません', 1),
(6720, 6, '400438', '奖品不存在', '賞品は存在しません', 1),
(6721, 6, '400439', '写入中奖记录失败', '優勝記録の書き込みに失敗しました', 1),
(6722, 6, '400440', '请继续参与活动抽奖', '引き続き抽選にご参加ください', 1),
(6723, 6, '400441', '已经领取成功', '正常に受信', 1),
(6724, 6, '400442', '分销等级不存在', '配布レベルが存在しません', 1),
(6725, 6, '400443', '选择的等级不存在', '選択したレベルは存在しません', 1),
(6726, 6, '400444', '该等级已存在此类型任务', 'このタイプのタスクはこのレベルに既に存在します', 1),
(6727, 6, '400445', '不能小于低等级同类型任务限定数量', '同じタイプの低レベル タスクの制限数より少なくすることはできません', 1),
(6728, 6, '400446', '不能大于高等级同类型任务限定数量', '同じタイプの高レベル タスクの制限数よりも大きくすることはできません', 1),
(6729, 6, '400447', '解除失败', '削除に失敗しました', 1),
(6730, 6, '400448', '代理商佣金比例不能大于事业部佣金比例', 'エージェントのコミッション率は、部門のコミッション率より大きくすることはできません', 1),
(6731, 6, '400449', '代理商到期时间不能大于事业部到期时间', 'エージェントの有効期限は、ビジネス部門の有効期限より長くすることはできません', 1),
(6732, 6, '400450', '请填写用户UID', 'ユーザー UID を入力してください', 1),
(6733, 6, '400451', '管理员信息未查到', '管理者情報が見つかりません', 1),
(6734, 6, '400452', '管理员已经删除', '管理者は削除されました', 1),
(6735, 6, '400453', '管理员姓名不能为空', '管理者名を空にすることはできません', 1),
(6736, 6, '400454', '该分类有下级分类，无法删除', 'このカテゴリにはサブカテゴリがあり、削除できません', 1),
(6737, 6, '400455', '该分类下有文章，无法删除', 'このカテゴリには記事があり、削除できません', 1),
(6738, 6, '400456', '请稍后查看', '後で確認してください', 1),
(6739, 6, '400457', '默认模板不能删除', 'デフォルトのテンプレートは削除できません', 1),
(6740, 6, '400458', '该模板使用中，无法删除', 'このテンプレートは使用中のため削除できません', 1),
(6741, 6, '400459', '个人中心模板不存在', 'パーソナル センター テンプレートが存在しません', 1),
(6742, 6, '400460', '反馈内容没有查到', 'フィードバックの内容が見つかりません', 1),
(6743, 6, '400461', '您修改的话术内容不存在', '変更した単語の内容は存在しません', 1),
(6744, 6, '400462', '短信平台：{:msg}', 'SMS プラットフォーム: {:msg}', 1),
(6745, 6, '400463', '订单商品获取失败,无法打印', '注文商品の取得に失敗したため、印刷できません', 1),
(6746, 6, '400464', '小票打印未开启', '領収書の印刷が有効になっていません', 1),
(6747, 6, '400465', '请先配置小票打印开发者', '最初にレシート印刷の開発者を設定してください', 1),
(6748, 6, '400466', '请选择图片', '画像を選択してください', 1),
(6749, 6, '400467', '配送员已存在', '配達担当者は既に存在します', 1),
(6750, 6, '400468', '同一个手机号的配送员只能添加一个', '同じ携帯番号の配達担当者は 1 人しか追加できません', 1),
(6751, 6, '400469', '配送员名称不能为空', '配達担当者の名前を空にすることはできません', 1),
(6752, 6, '400470', '订单未能查到,不能发货', '注文が見つからず、発送できません', 1),
(6753, 6, '400471', '订单已删除,不能发货', '注文が削除されたため、発送できません', 1),
(6754, 6, '400472', '订单已发货请勿重复操作', '注文は発送されました。操作を繰り返さないでください', 1),
(6755, 6, '400473', '核销订单不能发货', '償却注文は発送できません', 1),
(6756, 6, '400474', '拼团未完成暂不能发货', 'グループ化が完了していないため、一時的に出荷できません', 1),
(6757, 6, '400475', '订单有售后申请请先处理', '注文にはアフターセールス アプリケーションがあります。最初に処理してください', 1),
(6758, 6, '400476', '快递公司编缺失', '宅配会社がありません', 1),
(6759, 6, '400477', '请填写寄件人电话', '送信者の電話番号を入力してください', 1),
(6760, 6, '400478', '请填写寄件人地址', '送信者のアドレスを入力してください', 1),
(6761, 6, '400479', '虚拟发货，无需修改发货信息', '仮想配送、配送情報を変更する必要はありません', 1),
(6762, 6, '400480', '未发货，请先发货再修改配送信息', '未発送です。最初に発送してから配送情報を変更してください', 1),
(6763, 6, '400481', '自提订单无法打印', 'セルフピックアップ注文は印刷できません', 1),
(6764, 6, '400482', '请先发货', '最初に出荷してください', 1),
(6765, 6, '400483', '请先在系统设置中打开单子面单打印开关', 'システム設定で片面片面印刷スイッチをオンにしてください', 1),
(6766, 6, '400484', '发票已申请，正在审核打印中', '請求書は申請済みで、審査および印刷中', 1),
(6767, 6, '400485', '订单已退款', '注文は返金されました', 1),
(6768, 6, '400486', '正在申请退款中', '払い戻しを申請中', 1),
(6769, 6, '400487', '申请失败', '申請に失敗しました', 1),
(6770, 6, '400488', '未支付无法退款', '未払いのため返金不可', 1),
(6771, 6, '400489', '回退积分和优惠券失败', 'ポイントとクーポンのロールバックに失敗しました', 1),
(6772, 6, '400490', '拼团修改失败', 'グループの変更に失敗しました', 1),
(6773, 6, '400491', '回退佣金失败', 'コミッションのロールバックに失敗しました', 1),
(6774, 6, '400492', '余额退款失败', '残高の払い戻しに失敗しました', 1),
(6775, 6, '400493', '购买的优惠券已使用或者已过期', '購入したクーポンは使用済みまたは期限切れです', 1),
(6776, 6, '400494', '回退积分增加失败', 'ロールバック ポイントの増加に失敗しました', 1),
(6777, 6, '400495', '售后订单不存在', 'アフターオーダーは存在しません', 1),
(6778, 6, '400496', '积分已退或者积分为零无法再退', 'ポイントが返金されたか、ポイントがゼロの場合はポイントを返金できません', 1),
(6779, 6, '400497', '未支付无法退积分', '未払いのポイントは返金できません', 1),
(6780, 6, '400498', '订单退积分失败', '注文のポイントを返金できませんでした', 1),
(6781, 6, '400499', '请输入拒绝退款理由', '返金を拒否する理由を入力してください', 1),
(6782, 6, '400500', '限制单次购买数量不能大于总购买数量', '単一の購入数量を合計購入数量より大きくすることはできません', 1),
(6783, 6, '400501', '请添加抽奖活动名称', 'ラッキー ドローの名前を追加してください', 1),
(6784, 6, '400502', '请添加抽奖描述等文案', '宝くじの説明とその他のコピーを追加してください', 1),
(6785, 6, '400503', '活动结束时间必须大于开始时间', 'イベントの終了時間は開始時間より長くなければなりません', 1),
(6786, 6, '400504', '请添加奖品', '賞品を追加してください', 1),
(6787, 6, '400505', '请填写消耗数量', '消費量を入力してください', 1),
(6788, 6, '400506', '商品参与其他活动开启，无法开启预售', '他のアクティビティへの商品参加が有効になっているため、プレセールを開くことはできません', 1),
(6789, 6, '400507', '活动结束时间不能小于当前时间', 'イベントの終了時刻は、現在の時刻より前にすることはできません', 1),
(6790, 6, '400508', '活动已结束,请重新添加或复制', 'イベントは終了しました。もう一度追加またはコピーしてください', 1),
(6791, 6, '400509', '添加优惠券成功', 'クーポンが正常に追加されました', 1),
(6792, 6, '400510', '发布优惠劵成功', 'クーポンは正常に発行されました', 1),
(6793, 6, '400511', '砍价最低价不能大于或等于起始金额', '交渉の最低価格は、開始額以上にすることはできません', 1),
(6794, 6, '400512', '砍价人数不能大于{:num}人', '交渉する人の数は {:num} を超えることはできません', 1),
(6795, 6, '400513', '使用开始时间不能小于领取开始时间', '使用の開始時刻は、収集の開始時刻より前にすることはできません', 1),
(6796, 6, '400514', '使用结束时间不能小于领取结束时间', '使用の終了時刻は、収集の終了時刻より前にすることはできません', 1),
(6797, 6, '400515', '优惠券不存在', 'クーポンが存在しません', 1),
(6798, 6, '400516', '领取的优惠劵已领完或已过期', '受け取ったクーポンは既に受け取っているか、有効期限が切れています', 1),
(6799, 6, '400517', '已领取过该优惠劵', 'クーポンを受け取りました', 1),
(6800, 6, '400518', '抱歉，优惠券已经领取完了', '申し訳ありませんが、クーポンは収集されました', 1),
(6801, 6, '400519', '选择用户已拥有该优惠券，请勿重复发放', '既にクーポンを所有しているユーザーを選択してください。繰り返し発行しないでください', 1),
(6802, 6, '400520', '订单已删除', '注文が削除されました', 1),
(6803, 6, '400521', '订单已发货', '注文は発送されました', 1),
(6804, 6, '400522', '暂时不支持其他发货类型', '他の配信タイプは一時的にサポートされていません', 1),
(6805, 6, '400523', '请输入送货人姓名', '配達担当者の名前を入力してください', 1),
(6806, 6, '400524', '请输入送货人电话号码', '配達担当者の電話番号を入力してください', 1),
(6807, 6, '400525', '请输入送货人信息', '配達担当者情報を入力してください', 1),
(6808, 6, '400526', '请输入正确的送货人电话号码', '正しい配達担当者の電話番号を入力してください', 1),
(6809, 6, '400527', '请选择电子面单模板', '電子帳票のテンプレートを選択してください', 1),
(6810, 6, '400528', '电子面单已关闭，请选择其他发货方式', '電子請求書は閉鎖されました。別の配送方法を選択してください', 1),
(6811, 6, '400529', '发货失败', '発送に失敗しました', 1),
(6812, 6, '400530', '订单状态错误', '注文ステータス エラー', 1),
(6813, 6, '400531', '请输入快递单号', '宅配便番号を入力してください', 1),
(6814, 6, '400532', '请先发货再修改配送信息', '最初に出荷してから、配送情報を変更してください', 1),
(6815, 6, '400533', '商品不存在', '商品が存在しません', 1),
(6816, 6, '400534', '您查看的积分商品已被删除', 'あなたが閲覧したポイント商品は削除されました', 1),
(6817, 6, '400535', '请添加商品', '商品を追加してください', 1),
(6818, 6, '400536', '添加抽奖活动失败', '宝くじイベントの追加に失敗しました', 1),
(6819, 6, '400537', '抽奖活动不存在', '宝くじは存在しません', 1),
(6820, 6, '400538', '请填写奖品名称', '賞品の名前を入力してください', 1),
(6821, 6, '400539', '请选择奖品图片', '賞品の写真を選択してください', 1),
(6822, 6, '400540', '请填写奖品中奖权重', '当選重量を入力してください', 1),
(6823, 6, '400541', '请选择奖品类型', '賞品の種類を選択してください', 1),
(6824, 6, '400542', '请填写奖品赠送{:type}数', '賞品の{:type}数を記入してください', 1),
(6825, 6, '400543', '请选择优惠券', 'クーポンを選択してください', 1),
(6826, 6, '400544', '生成新订单失败', '新しい注文の生成に失敗しました', 1),
(6827, 6, '400545', '修改原来订单商品拆分状态失败', '元の注文商品分割ステータスの変更に失敗しました', 1),
(6828, 6, '400546', '新增拆分订单商品信息失败', '分割注文の商品情報の追加に失敗しました', 1),
(6829, 6, '400547', '保存新订单商品信息失败', '新規注文商品情報の保存に失敗しました', 1),
(6830, 6, '400548', '协议类型缺失', 'プロトコル タイプがありません', 1),
(6831, 6, '400549', '请填写协议名称', '契約名を入力してください', 1),
(6832, 6, '400550', '请填写协议内容', '同意書の内容を記入してください', 1),
(6833, 6, '400551', '该类型协议已经存在', 'このタイプのプロトコルは既に存在します', 1),
(6834, 6, '400552', '临时二维码获取错误', '一時QRコード取得エラー', 1),
(6835, 6, '400553', '永久二维码获取错误', '永続的な QR コード取得エラー', 1),
(6836, 6, '400554', '请先配置接口密钥', '最初にインターフェイス キーを設定してください', 1),
(6837, 6, '400555', '无法创建文件夹，请检查您的上传目录权限', 'フォルダを作成できません。アップロード ディレクトリの権限を確認してください', 1),
(6838, 6, '400556', '商品参数错误', '商品パラメータエラー', 1),
(6839, 6, '400557', '上传方式错误', 'アップロード方法が間違っています', 1),
(6840, 6, '400558', '格式错误', 'フォーマット エラー', 1),
(6841, 6, '400559', '图片流获取失败', '画像ストリームの取得に失敗しました', 1),
(6842, 6, '400560', '商品详情保存失败', '商品の詳細を保存できませんでした', 1),
(6843, 6, '400561', '关联优惠券失败', 'クーポンの関連付けに失敗しました', 1),
(6844, 6, '400562', '缺少商品ID', '製品 ID がありません', 1),
(6845, 6, '400563', '缺少用户UID', 'ユーザー UID がありません', 1),
(6846, 6, '400564', '缺少订单ID', 'オーダー ID がありません', 1),
(6847, 6, '400565', '暂不支持该类型记录', 'このタイプのレコードは現在サポートされていません', 1),
(6848, 6, '400566', '添加商品记录失败', '製品レコードの追加に失敗しました', 1),
(6849, 6, '400567', '评论时间应小于当前时间', 'コメント時間は現在の時間より短くなければなりません', 1),
(6850, 6, '400568', '添加虚拟评论失败', '仮想コメントの追加に失敗しました', 1),
(6851, 6, '400569', '回复失败', '返信に失敗しました', 1),
(6852, 6, '400570', '请选择限购类型', '購入制限の種類を選択してください', 1),
(6853, 6, '400571', '限购数量不能小于1', '購入制限は 1 未満にすることはできません', 1),
(6854, 6, '400572', '一二级返佣相加不能大于商品售价', '第 1 レベルと第 2 レベルのリベートの合計は、製品の価格を超えることはできません', 1),
(6855, 6, '400573', '商品类型不能切换', '製品タイプを切り替えることはできません', 1),
(6856, 6, '400574', '请输入规则名称', 'ルール名を入力してください', 1),
(6857, 6, '400575', '请输入属性名称', '属性名を入力してください', 1),
(6858, 6, '400576', '请输入正确的属性', '正しい属性を入力してください', 1),
(6859, 6, '400577', '请填写正确的商品信息', '正しい製品情報を入力してください', 1),
(6860, 6, '400578', '请填写正确的商品价格', '正しい商品価格を入力してください', 1),
(6861, 6, '400579', '请填写正确的商品库存', '正しい商品在庫を入力してください', 1),
(6862, 6, '400580', '请填写正确的商品成本价格', '正しい商品原価を入力してください', 1),
(6863, 6, '400581', '请上传商品图片', '商品画像をアップロードしてください', 1),
(6864, 6, '400582', '{:name}规格不存在', '{:name} 仕様が存在しません', 1),
(6865, 6, '400583', '{:name}属性不存在', '{:name} 属性が存在しません', 1),
(6866, 6, '400584', '请设置至少一个属性', '少なくとも 1 つの属性を設定してください', 1),
(6867, 6, '400585', '商品参与秒杀活动开启，无法进行此操作', 'スパイク アクティビティへの商品参加が有効になっています。この操作は実行できません', 1),
(6868, 6, '400586', '商品参与砍价活动开启，无法进行此操作', '交渉への商品参加が有効になっています。この操作は実行できません', 1),
(6869, 6, '400587', '商品参与拼团活动开启，无法进行此操作', 'グループ活動への商品参加が有効になっています。この操作は実行できません', 1),
(6870, 6, '400588', '会员价格不能为0', 'メンバー価格を 0 にすることはできません', 1),
(6871, 6, '400589', '虚拟优惠券商品请选择优惠券', '仮想クーポン商品のクーポンを選択してください', 1),
(6872, 6, '400590', '卡号：{:key}密码：{:value}，已经添加过，请重新添加卡密', 'カード番号: {:key} パスワード: {:value}、追加されました。もう一度カードキーを追加してください', 1),
(6873, 6, '400591', '缺少城市id无法保存', '都市 ID が見つからないため、保存できません', 1),
(6874, 6, '400592', '修改的模板不存在', '変更されたテンプレートは存在しません', 1),
(6875, 6, '400593', '指定区域邮费添加失败', '指定された地域で送料を追加できませんでした', 1),
(6876, 6, '400594', '管理员不存在', '管理者が存在しません', 1),
(6877, 6, '400595', '您已被禁止登录', 'あなたはログインを禁止されています', 1),
(6878, 6, '400596', '管理员账号已存在', '管理者アカウントは既に存在します', 1),
(6879, 6, '400597', '原始密码错误', '元のパスワード エラー', 1),
(6880, 6, '400598', '请输入新密码', '新しいパスワードを入力してください', 1),
(6881, 6, '400599', '请选择要删除的图片', '削除する画像を選択してください', 1),
(6882, 6, '400600', '移动失败或不能重复移动到同一分类下', '移動に失敗したか、同じカテゴリに繰り返し移動できません', 1),
(6883, 6, '400601', '请求不被允许', 'リクエストは許可されていません', 1),
(6884, 6, '400602', '设置类目不被允许', 'カテゴリの設定は許可されていません', 1),
(6885, 6, '400603', '请输入正确格式的配置参数', '設定パラメータを正しい形式で入力してください', 1),
(6886, 6, '400604', '{:name}请输入默认值', '{:name} デフォルト値を入力してください', 1),
(6887, 6, '400605', '{:name}请输入正确url', '{:name} 正しい URL を入力してください', 1),
(6888, 6, '400606', '保存wss证书失败', 'wss 証明書の保存に失敗しました', 1),
(6889, 6, '400607', '{:name}不能为空', '{:name} を空にすることはできません', 1),
(6890, 6, '400608', '删除的云存储不存在', '削除されたクラウド ストレージは存在しません', 1),
(6891, 6, '400609', '云存储正在使用中,需要启动其他空间才能删除', 'クラウド ストレージは使用中です。他のスペースを削除するには、アクティブ化する必要があります', 1),
(6892, 6, '400610', '云空间名称不能重复', 'クラウド スペース名を繰り返すことはできません', 1),
(6893, 6, '400611', '没有权限', '許可なし', 1),
(6894, 6, '400612', '替换失败,失败原因:{:msg}', '交換に失敗しました。失敗の理由: {:msg}', 1),
(6895, 6, '400613', '请先删除改菜单下的子菜单', '最初にメニューの下のサブメニューを削除してください', 1),
(6896, 6, '400614', '请填写批次名称', 'バッチ名を入力してください', 1),
(6897, 6, '400615', '请填写要生成卡的数量', '生成するカードの数を入力してください', 1),
(6898, 6, '400616', '卡片数量只能为正整数', 'カードの枚数は正の整数のみです', 1),
(6899, 6, '400617', '单次制卡数量最高不得超过6000张', '一度に生成されるカードの最大数は 6000 を超えてはならない', 1),
(6900, 6, '400618', '请填写免费使用天数', '無料利用日数を記入してください', 1),
(6901, 6, '400619', '免费使用天数只能为正整数', '無料使用日数は正の整数のみです', 1),
(6902, 6, '400620', '生成卡失败', 'カードの生成に失敗しました', 1),
(6903, 6, '400621', '会员功能暂未开启', 'メンバー関数はまだ開かれていません', 1),
(6904, 6, '400622', '请输入会员卡号', '会員証番号を入力してください', 1),
(6905, 6, '400623', '请输入领取卡密', 'カードのパスワードを入力してください', 1),
(6906, 6, '400624', '会员卡不存在', '会員カードが存在しません', 1),
(6907, 6, '400625', '会员卡未激活，暂无法使用', '会員カードが有効になっておらず、一時的に使用できません', 1),
(6908, 6, '400626', '会员卡密码有误', '会員カードのパスワードが正しくありません', 1),
(6909, 6, '400627', '会员卡已使用', '会員カードは使用済み', 1),
(6910, 6, '400628', '您已是永久会员，无需再领取，可以将此卡转送亲朋好友，一起享受优惠', 'あなたはすでに正会員です。もう取得する必要はありません。このカードを友人や親戚に譲渡して、一緒に割引を楽しむことができます', 1),
(6911, 6, '400629', '暂无此类型会员卡', '現在、このタイプの会員カードはありません', 1),
(6912, 6, '400630', '会员权益类型缺失', '会員特典の種類がありません', 1),
(6913, 6, '400631', '请设置权益名称', 'エクイティ名を設定してください', 1),
(6914, 6, '400632', '请上传会员权益图标', '会員権アイコンをアップロードしてください', 1),
(6915, 6, '400633', '请设置返还积分倍数', 'リターンポイントを複数設定してください', 1),
(6916, 6, '400634', '返还积分倍数不能为负数', 'リターン ポイントの倍数を負にすることはできません', 1),
(6917, 6, '400635', '请设置运费折扣', '送料割引を設定してください', 1),
(6918, 6, '400636', '运费折扣不能为负数', '送料割引をマイナスにすることはできません', 1),
(6919, 6, '400637', '请设置签到积分倍数', 'チェックインポイントを複数設定してください', 1),
(6920, 6, '400638', '签到积分倍数不能为负数', 'サインイン ポイントの倍数を負にすることはできません', 1),
(6921, 6, '400639', '请设置线下付款折扣', 'オフライン決済割引を設定してください', 1),
(6922, 6, '400640', '线下付款不能为负数', 'オフライン決済はマイナスにはなりません', 1),
(6923, 6, '400641', '请填写会员卡名称', '会員証の名前を記入してください', 1),
(6924, 6, '400642', '会员卡类型缺失', '会員カードの種類がありません', 1),
(6925, 6, '400643', '请填写有效期（天）', '有効期間 (日数) を入力してください', 1),
(6926, 6, '400644', '有效期（天）不能为负数', '有効期間 (日) を負にすることはできません', 1),
(6927, 6, '400645', '请填写价格', '価格を入力してください', 1),
(6928, 6, '400646', '价格不能为负数', '価格をマイナスにすることはできません', 1),
(6929, 6, '400647', '优惠价不能大于原价', '割引価格を元の価格より高くすることはできません', 1),
(6930, 6, '400648', '地址不存在', 'アドレスが存在しません', 1),
(6931, 6, '400649', '取消原来默认地址失败', '元のデフォルト アドレスのキャンセルに失敗しました', 1),
(6932, 6, '400650', '设置默认地址失败', 'デフォルトアドレスの設定に失敗しました', 1),
(6933, 6, '400651', '地址已存在', 'アドレスは既に存在します', 1),
(6934, 6, '400652', '收货地址格式错误', '配送先住所の形式が正しくありません', 1),
(6935, 6, '400653', '请登录', 'ログインしてください', 1),
(6936, 6, '400654', '登录已过期,请重新登录', 'ログインの有効期限が切れました。再度ログインしてください', 1),
(6937, 6, '400655', '增加记录失败', 'レコードの追加に失敗しました', 1),
(6938, 6, '400656', '记录分享记录失败', 'レコードの共有に失敗しました', 1),
(6939, 6, '400657', '增加用户佣金失败', 'ユーザー手数料の増加に失敗しました', 1),
(6940, 6, '400658', '企业付款到零钱失败，请稍后再试', '会社は釣り銭の支払いに失敗しました。後でもう一度試してください', 1),
(6941, 6, '400659', '已经提现', 'すでに撤回済み', 1),
(6942, 6, '400660', '您的提现申请已被拒绝', 'あなたの引き出しリクエストは拒否されました', 1),
(6943, 6, '400661', '可提现佣金不足', '現金を引き出すための手数料が不足しています', 1),
(6944, 6, '400662', '提现金额不能小于{:money}元', '引き出し額は {:money} 元未満にはできません', 1),
(6945, 6, '400663', '提现佣金不足{:money}元', '出金手数料が足りない {:money} 元', 1),
(6946, 6, '400664', '提现佣金大于0', '出金手数料が 0 より大きい', 1),
(6947, 6, '400665', '企业微信付款到零钱最低金额为1元', '最小額を変更するためのエンタープライズ WeChat 支払いは 1 元です', 1),
(6948, 6, '400666', '该分组已经存在', 'グループは既に存在します', 1),
(6949, 6, '400667', '清空用户标签失败', 'ユーザー ラベルのクリアに失敗しました', 1),
(6950, 6, '400668', '设置标签失败', 'ラベルの設定に失敗しました', 1),
(6951, 6, '400669', '请选择标签分类', 'ラベル分類を選択してください', 1),
(6952, 6, '400670', '该标签已经存在', 'ラベルは既に存在します', 1),
(6953, 6, '400671', '修改用户等级信息失败', 'ユーザーレベル情報の変更に失敗しました', 1),
(6954, 6, '400672', '用户等级不存在', 'ユーザーレベルが存在しません', 1),
(6955, 6, '400673', '用户等级经验必须大于上一等级设置的经验', 'ユーザー レベルの経験値は、前のレベルで設定された経験値より高くなければなりません', 1),
(6956, 6, '400674', '用户等级经验必须小于下一等级设置的经验', 'ユーザー レベルの経験値は、次のレベルで設定された経験値よりも低くなければなりません', 1),
(6957, 6, '400675', '已检测到您设置过的用户等级，此等级不可重复', '設定したユーザー レベルが検出されました。このレベルを繰り返すことはできません', 1),
(6958, 6, '400676', '已检测到您设置过该用户等级经验值，经验值不可重复', 'このユーザー レベルの経験値を設定したことが検出されました。経験値を繰り返すことはできません', 1),
(6959, 6, '400677', '订单未支付', '注文未払い', 1),
(6960, 6, '400678', '佣金转入余额，不能退款', 'コミッションは残高に転送され、返金できません', 1),
(6961, 6, '400679', '已支付的订单记录无法删除', '支払い済みの注文レコードを削除できません', 1),
(6962, 6, '400680', '转入金额不能大于可提现佣金', '送金金額は、引き出し可能なコミッションを超えることはできません', 1),
(6963, 6, '400681', '写入余额充值失败', 'バランス再充電の書き込みに失敗しました', 1),
(6964, 6, '400682', '您选择的充值方式已下架', '選択した充電方法は削除されました', 1),
(6965, 6, '400683', '充值订单生成失败', 'リチャージ注文の生成に失敗しました', 1),
(6966, 6, '400684', '保存用户信息失败', 'ユーザー情報の保存に失敗しました', 1),
(6967, 6, '400685', '密码重置失败', 'パスワードのリセットに失敗しました', 1),
(6968, 6, '400686', '增加推广人数失败', 'プロモーションの数を増やすことができませんでした', 1),
(6969, 6, '400687', '设置登录类型失败', 'ログイン タイプの設定に失敗しました', 1),
(6970, 6, '400688', '设置推广员失败', 'プロモーターの設定に失敗しました', 1),
(6971, 6, '400689', '增加用户余额失败', 'ユーザー残高の増加に失敗しました', 1),
(6972, 6, '400690', '减少用户余额失败', 'ユーザー残高の削減に失敗しました', 1),
(6973, 6, '400691', '减少用户佣金失败', 'ユーザー手数料の削減に失敗しました', 1),
(6974, 6, '400692', '增加用户积分失败', 'ユーザー ポイントの増加に失敗しました', 1),
(6975, 6, '400693', '减少用户积分失败', 'ユーザー ポイントの削減に失敗しました', 1),
(6976, 6, '400694', '增加用户经验失败', 'ユーザー エクスペリエンスの向上に失敗しました', 1),
(6977, 6, '400695', '减少用户经验失败', 'ユーザー エクスペリエンスの低下に失敗しました', 1),
(6978, 6, '400696', '该分组不存在', 'グループが存在しません', 1),
(6979, 6, '400697', '设置分组失败或无改动', 'グループ化の設定に失敗したか、変更がありません', 1),
(6980, 6, '400698', '有标签不存在或被删除', 'ラベルが存在しないか削除されています', 1),
(6981, 6, '400699', '等级不存在或被删除', 'クラスが存在しないか削除されています', 1),
(6982, 6, '400700', '此用户已有该用户等级，无法再次赠送', 'このユーザーはすでにこのユーザー レベルを持っているため、再度付与することはできません', 1),
(6983, 6, '400701', '赠送天数不能为0', 'ギフト日数を 0 にすることはできません', 1),
(6984, 6, '400702', '天数输入错误', '日数が正しく入力されていません', 1),
(6985, 6, '400703', '用户信息储存失败', 'ユーザー情報の保存に失敗しました', 1),
(6986, 6, '400704', '您得ip不再白名单中,请前往腾讯微信公众平台添加ip白名单', 'あなたの IP はホワイトリストにありません。Tencent WeChat パブリック プラットフォームに移動して、IP をホワイトリストに追加してください', 1),
(6987, 6, '400705', '您填写得appid无效,请检查', '入力した appid は無効です。確認してください', 1),
(6988, 6, '400706', '请输入回复信息内容', '返信メッセージの内容を入力してください', 1),
(6989, 6, '400707', '请上传回复的图片', '返信の画像をアップロードしてください', 1),
(6990, 6, '400708', '请上传回复的声音', '返信音声をアップロードしてください', 1),
(6991, 6, '400709', '请选择图文消息', 'テキスト メッセージを選択してください', 1),
(6992, 6, '400710', '对应的uid不存在', '対応する uid が存在しません', 1),
(6993, 6, '400711', '取消关注失败', 'フォロー解除に失敗しました', 1),
(6994, 6, '400712', '电子面单模板ID缺失', '電子伝票テンプレートの ID がありません', 1),
(6995, 6, '400713', '快递公司编码缺失', '運送会社コードがありません', 1),
(6996, 6, '400714', '寄件人信息缺失', '送信者情報がありません', 1),
(6997, 6, '400715', '收件人信息缺失', '受取人情報がありません', 1),
(6998, 6, '400716', '云打印机编号缺失', 'クラウド プリンター番号がありません', 1),
(6999, 6, '400717', '商品数量缺失', 'アイテムの数量がありません', 1),
(7000, 6, '400718', '获取access_token获取失败', 'access_token の取得に失敗しました', 1),
(7001, 6, '400719', '手机号不能为空', '携帯電話番号を空にすることはできません', 1),
(7002, 6, '400720', '模版ID不存在', 'テンプレート ID が存在しません', 1),
(7003, 6, '400721', '请先配置accessKey和secretKey', '先に accessKey と secretKey を設定してください', 1),
(7004, 6, '400722', '请先配置水印图片', '最初に透かし画像を設定してください', 1),
(7005, 6, '400723', '请先配置水印文字', '最初に透かしテキストを設定してください', 1),
(7006, 6, '400724', '远程水印图片下载失败', '透かし画像のリモートダウンロードに失敗しました', 1),
(7007, 6, '400725', '上传图片不存在', 'アップロードされた画像が存在しません', 1),
(7008, 6, '400726', '图片流获取失败', '画像ストリームの取得に失敗しました', 1),
(7009, 6, '400727', '图片下载失败', '画像のダウンロードに失敗しました', 1),
(7010, 6, '400728', '必须上传xlsx格式文件', 'xlsx 形式のファイルをアップロードする必要があります', 1),
(7011, 6, '400729', '数据不能为空', 'データを空にすることはできません', 1),
(7012, 6, '400730', '缺少pay_price', 'pay_price がありません', 1),
(7013, 6, '400731', '退款失败:{:msg}', '払い戻しに失敗しました: {:msg}', 1),
(7014, 6, '400732', '获取微信粉丝信息失败', 'WeChat ファン情報の取得に失敗しました', 1),
(7015, 6, '400733', '您已关闭上传功能', 'アップロード機能をオフにしました', 1),
(7016, 6, '400734', '文件不可写', 'ファイルは書き込み可能ではありません', 1),
(7017, 6, '400735', '时间格式不正确', '時刻の形式が正しくありません', 1),
(7018, 6, '400736', '文件可能损坏，请检查', 'ファイルが破損している可能性があります。確認してください', 1),
(7019, 6, '400737', '修复错误，请重试', 'エラーを修正して、もう一度お試しください', 1),
(7020, 6, '400738', '请指定要修复的表', '修復するテーブルを指定してください', 1),
(7021, 6, '400739', '请配置支付证书', '支払い証明書を設定してください', 1),
(7022, 6, '400740', '只支持两级分类', '2 レベルの分類のみをサポート', 1),
(7023, 6, '400741', '运费格式错误', '貨物形式エラー', 1),
(7024, 6, '400742', '请检查属性编码或库存数量', '属性コードまたは在庫数を確認してください', 1),
(7025, 6, '400743', '同步条数不能超过100', '同期バーの数は 100 を超えることはできません', 1),
(7026, 6, '400744', 'appid或appsecret错误', 'appid または appsecret エラー', 1),
(7027, 6, '400745', '父级ID参数类型错误', '親 ID パラメータの型が間違っています', 1),
(7028, 6, '400746', '分类名称长度不能超过25个字符', 'カテゴリ名の長さは 25 文字を超えることはできません', 1),
(7029, 6, '400747', '分类图标长度不能超过128个字符', 'カテゴリ アイコンの長さは 128 文字を超えることはできません', 1),
(7030, 6, '400748', '分类大图长度不能超过200个字符', '大きな分類画像の長さは 200 文字を超えることはできません', 1),
(7031, 6, '400749', '排序参数类型错误', '並べ替えパラメータの型が間違っています', 1),
(7032, 6, '400750', '排序不能小于0', '並べ替えは 0 未満にはできません', 1),
(7033, 6, '400751', '状态必须是0-1之间的整数', 'ステータスは 0 ～ 1 の整数でなければなりません', 1),
(7034, 6, '400752', '权益简介不能大于8个字', '権利と利益の紹介は 8 語より長くすることはできません', 1),
(7035, 6, '400753', '提现方式最少选一种', '出金方法を少なくとも1つ選択してください', 1),
(7036, 6, '400754', '身份使用中，无法删除', 'ID は使用中のため削除できません', 1),
(7037, 6, '400755', '展示名称不能大于6个字', '表示名は 6 文字より長くすることはできません', 1),
(7038, 6, '400756', '推广佣金单价不能小于0', 'プロモーション コミッションの単価を 0 未満にすることはできません', 1),
(7039, 6, '400757', '每日推广佣金上限不能小于-1', '毎日のプロモーション コミッションの上限は -1 より小さくすることはできません', 1),
(7040, 6, '400758', '请核对领取方式', '収集方法を確認してください', 1),
(7041, 6, '400759', '请输入优惠券名称', 'クーポン名を入力してください', 1),
(7042, 6, '400760', '请输入真实姓名', '本名を入力してください', 1),
(7043, 6, '400761', '描述内容不能超过120字', '説明の内容は 120 文字を超えることはできません', 1),
(7044, 6, '400762', '账号密码必须是在6到32位之间', 'アカウントのパスワードは 6 ～ 32 桁でなければなりません', 1),
(7045, 6, '400763', '商户号不能为空', 'マーチャント番号を空にすることはできません', 1),
(7046, 6, '410000', '请输入账号和密码', 'アカウント番号とパスワードを入力してください', 1),
(7047, 6, '410001', '登录成功', 'ログイン成功', 1),
(7048, 6, '410002', '退出成功', '正常に終了しました', 1),
(7049, 6, '410003', '发送验证码失败,请刷新页面重新获取', '認証コードの送信に失敗しました。ページを更新して再度取得してください', 1),
(7050, 6, '410004', '请输入验证码', '確認コードを入力してください', 1),
(7051, 6, '410005', '验证码输入有误', '確認コードが正しく入力されていません', 1),
(7052, 6, '410006', '验证码已发送', '確認コードが送信されました', 1),
(7053, 6, '410007', '验证码发送成功', '確認コードが正常に送信されました', 1),
(7054, 6, '410008', '验证码发送失败', '検証コードの送信に失敗しました', 1),
(7055, 6, '410009', '请先获取验证码', '最初に確認コードを取得してください', 1),
(7056, 6, '410010', '验证码错误', '検証コード エラー', 1),
(7057, 6, '410011', '密码必须是在6到16位之间', 'パスワードは 6 ～ 16 桁でなければなりません', 1),
(7058, 6, '410012', '密码太过简单，请输入较为复杂的密码', 'パスワードが単純すぎます。より複雑なパスワードを入力してください', 1),
(7059, 6, '410013', '注册成功', '登録成功', 1),
(7060, 6, '410014', '注册失败', '登録に失敗しました', 1),
(7061, 6, '410015', '请输入手机号', '電話番号を入力してください', 1),
(7062, 6, '410016', '绑定成功', 'バインド成功', 1),
(7063, 6, '410017', '绑定失败', 'バインドに失敗しました', 1),
(7064, 6, '410018', '手机号格式不正确', '電話番号の形式が正しくありません', 1),
(7065, 6, '410019', '登录失败', 'ログインに失敗しました', 1),
(7066, 6, '410020', '扫码失败请重新扫描', 'コードのスキャンに失敗しました。もう一度スキャンしてください', 1),
(7067, 6, '410021', '二维码已过期请重新扫描', 'QR コードの有効期限が切れています。もう一度スキャンしてください', 1),
(7068, 6, '410022', '授权成功，请绑定手机号', '承認が成功しました。携帯電話番号をバインドしてください', 1),
(7069, 6, '410023', '授权成功', '認証成功', 1),
(7070, 6, '410024', '请先关注公众号', 'まずは公式アカウントにご注目ください', 1),
(7071, 6, '410025', '账号或密码错误', 'アカウントまたはパスワードのエラー', 1),
(7072, 6, '410026', '请修改您的初始密码，再尝试登录', '初期パスワードを変更して、再度ログインしてください', 1),
(7073, 6, '410027', '您已被禁止登录，请联系管理员', 'ログインが禁止されています。管理者に連絡してください', 1),
(7074, 6, '410028', '手机号已注册', '電話番号が登録されました', 1),
(7075, 6, '410029', '您今日发送得短信次数已经达到上限', '今日送信したテキスト メッセージの数が上限に達しました', 1),
(7076, 6, '410030', '此IP今日发送次数已经达到上限', 'この IP が今日送信された回数が上限に達しました', 1),
(7077, 6, '410031', '短信平台验证码发送失败', 'SMS プラットフォーム検証コードの送信に失敗しました', 1),
(7078, 6, '410032', '用户不存在', 'ユーザーが存在しません', 1),
(7079, 6, '410033', '修改密码失败', 'パスワードの変更に失敗しました', 1),
(7080, 6, '410034', '用户登录失败,无法生成新用户,请稍后再试', 'ユーザー ログインに失敗しました。新しいユーザーを生成できません。後でもう一度試してください', 1),
(7081, 6, '410035', '用户不存在,无法切换', 'ユーザーが存在しないため切り替えられません', 1),
(7082, 6, '410036', '修改新用户登录类型出错', '新しいユーザー ログイン タイプの変更中にエラーが発生しました', 1),
(7083, 6, '410037', '请刷新页面或者重新授权', 'ページを更新するか、再認証してください', 1),
(7084, 6, '410038', '获取用户访问token失败', 'ユーザー アクセス トークンの取得に失敗しました', 1),
(7085, 6, '410039', '此手机已经绑定，无法多次绑定', 'この電話はバインドされており、複数回バインドすることはできません', 1),
(7086, 6, '410040', '您的账号已经绑定过手机号码', 'あなたのアカウントは携帯電話番号にバインドされています', 1),
(7087, 6, '410041', 'H5已有账号是否绑定此账号上', 'H5 の既存のアカウントがこのアカウントにバインドされているかどうか', 1),
(7088, 6, '410042', '新手机号和原手机号相同，无需修改', '新しい電話番号は元の電話番号と同じです。変更する必要はありません', 1),
(7089, 6, '410043', '此手机已经注册', 'この電話は登録されています', 1),
(7090, 6, '410044', '用户信息获取失败', 'ユーザー情報の取得に失敗しました', 1),
(7091, 6, '410045', '请选择收货地址', '配送先住所を選択してください', 1),
(7092, 6, '410046', '地址选择有误', 'アドレスの選択が間違っています', 1),
(7093, 6, '410047', '可用积分不足', 'クレジットが不足しています', 1),
(7094, 6, '410048', '奖品不存在', '賞品は存在しません', 1),
(7095, 6, '410049', '写入中奖记录失败', '優勝記録の書き込みに失敗しました', 1),
(7096, 6, '410050', '请继续参与活动抽奖', '引き続き抽選にご参加ください', 1),
(7097, 6, '410051', '已经领取成功', '正常に受信', 1),
(7098, 6, '410052', '请输入收货人信息', '荷受人情報を入力してください', 1),
(7099, 6, '410053', '请输入正确的收货人电话', '荷受人の正しい電話番号を入力してください', 1),
(7100, 6, '410054', '抽奖记录不存在', '宝くじの記録がありません', 1),
(7101, 6, '410055', '该奖品不需要发货', 'この賞品は発送する必要はありません', 1),
(7102, 6, '410056', '请选择快递公司或输入快递单号', '宅配会社を選択するか、宅配便番号を入力してください', 1),
(7103, 6, '410057', '活动不存在或已删除', 'アクティビティが存在しないか、削除されました', 1),
(7104, 6, '410058', '暂未有该类型活动', 'このタイプのアクティビティはまだありません', 1),
(7105, 6, '410059', '您暂时无法参与该活动', 'あなたは一時的にこのアクティビティに参加できません', 1),
(7106, 6, '410060', '活动状态有误，请联系管理员', 'アクティビティのステータスが正しくありません。管理者に連絡してください', 1),
(7107, 6, '410061', '可用积分不足，没有更多抽奖次数', '利用可能なポイントが不十分です。これ以上抽選はできません', 1),
(7108, 6, '410062', '余额不足，没有更多抽奖次数', 'バランスが不十分です。これ以上引き分けはありません', 1),
(7109, 6, '410063', '购买商品之后获得更多抽奖次数', '商品購入後、より多くの宝くじを獲得', 1),
(7110, 6, '410064', '订单完成评价之后获得更多抽奖次数', '注文が評価された後、より多くの抽選が行われます', 1),
(7111, 6, '410065', '邀请更多好友获取抽奖次数', 'より多くの友達を招待して、ラッキー ドローの数を獲得', 1),
(7112, 6, '410066', '抽奖扣除用户积分失败', '宝くじの抽選でユーザー ポイントを差し引くことができませんでした', 1),
(7113, 6, '410067', '抽奖失败，余额不足', '宝くじの抽選に失敗しました。残高不足です', 1),
(7114, 6, '410068', '抽奖扣除用户余额失败', '宝くじの抽選でユーザーの残高を差し引くことができませんでした', 1),
(7115, 6, '410069', '抽奖扣除用户推广获取抽奖次数失败', '宝くじの抽選で、ユーザーが宝くじに当選した回数を差し引くことができませんでした', 1),
(7116, 6, '410070', '抽奖减少奖品总数失败', '賞品の総数を減らす宝くじの抽選に失敗しました', 1),
(7117, 6, '410071', '分销等级不存在', '配布レベルが存在しません', 1),
(7118, 6, '410072', '永久二维码获取错误', '永続的な QR コード取得エラー', 1),
(7119, 6, '410073', '邀请码无效', '招待コードが無効です', 1),
(7120, 6, '410074', '授权失败,参数有误', '承認に失敗しました。パラメータが間違っています', 1),
(7121, 6, '410075', 'openid获取失败', 'openid の取得に失敗しました', 1),
(7122, 6, '410076', '获取session_key失败，请检查您的配置', 'session_key の取得に失敗しました。設定を確認してください', 1),
(7123, 6, '410077', '获取会话密匙失败', 'セッション キーの取得に失敗しました', 1),
(7124, 6, '410078', '静默授权失败', 'サイレント認証に失敗しました', 1),
(7125, 6, '410079', '获取用户信息失败', 'ユーザー情報の取得に失敗しました', 1),
(7126, 6, '410080', '更新信息失败', '情報の更新に失敗しました', 1),
(7127, 6, '410081', '请上传二维码', 'QR コードをアップロードしてください', 1),
(7128, 6, '410082', '请关注公众号', '公開番号にご注意ください', 1),
(7129, 6, '410083', '新增用户失败', 'ユーザーの追加に失敗しました', 1),
(7130, 6, '410084', '用户关注失败', 'ユーザーのフォローに失敗しました', 1),
(7131, 6, '410085', '获取token失败{:msg}', 'トークン {:msg} の取得に失敗しました', 1),
(7132, 6, '410086', '配置已更改或token已失效', '構成が変更されたか、トークンの有効期限が切れています', 1),
(7133, 6, '410087', '平台错误：发生异常，请稍后重试', 'プラットフォーム エラー: 例外が発生しました。後で再試行してください', 1),
(7134, 6, '410088', '企业微信支付到零钱需要支付证书，检测到您没有上传', '変更するエンタープライズ WeChat 支払いには支払い証明書が必要です。アップロードしていないことが検出されました', 1),
(7135, 6, '410089', '发起企业支付到零钱失败', '開始した企業は変更を支払うことができませんでした', 1),
(7136, 6, '410090', '无效的token不能查找到用户聊天记录', '無効なトークンのため、ユーザーのチャット レコードが見つかりません', 1),
(7137, 6, '410091', '图片上传成功', '画像のアップロードに成功しました', 1),
(7138, 6, '410092', '用户uid不再当前聊天用户范围内', 'ユーザー uid は現在のチャット ユーザーの範囲外です', 1),
(7139, 6, '410093', '请输入订单价格', '注文価格を入力してください', 1),
(7140, 6, '410094', '请去后台售后订单列表处理', 'バックグラウンドのアフター オーダー リスト処理に移動してください', 1),
(7141, 6, '410095', '分类名称不能为空', 'カテゴリ名を空にすることはできません', 1),
(7142, 6, '410096', '分类不存在', '分類が存在しません', 1),
(7143, 6, '410097', '添加的内容重复', '追加されたコンテンツが繰り返されます', 1),
(7144, 6, '410098', '缺少转接人id', '転送者 ID がありません', 1),
(7145, 6, '410099', '转接成功', '転送成功', 1),
(7146, 6, '410100', '话术没有被查到', '音声が見つかりません', 1),
(7147, 6, '410101', '公共话术不能修改', '公用語は変更できません', 1),
(7148, 6, '410102', '话术标题内容不能为空', 'トピック タイトルの内容を空にすることはできません', 1),
(7149, 6, '410103', '已拥有此分组', 'すでにこのグループを所有しています', 1),
(7150, 6, '410104', '缺少标签id', 'タグ ID がありません', 1),
(7151, 6, '410105', '请填汉字字母或者数字', '漢字または数字を入力してください', 1),
(7152, 6, '410106', '标题长度不能超过50个字', 'タイトルの長さは 50 文字を超えることはできません', 1),
(7153, 6, '410107', '请选择分类', 'カテゴリを選択してください', 1),
(7154, 6, '410108', '分类必须为数字', '分類は数値でなければなりません', 1),
(7155, 6, '410109', '请填写话术内容', '言語の内容を記入してください', 1),
(7156, 6, '410110', '话术长度不能超过500个字', 'スピーチの長さは 500 語を超えることはできません', 1),
(7157, 6, '410111', '排序必须为数字', '並べ替えは数値でなければなりません', 1),
(7158, 6, '410112', '微信最低提现金额不能小于1元', 'Wechat の最低引き出し額は 1 元未満にすることはできません', 1),
(7159, 6, '410113', '用户不存在', 'ユーザーが存在しません', 1),
(7160, 6, '410114', '提现方式不存在', '出金方法が存在しません', 1),
(7161, 6, '410115', '提现金额输入有误', '引き出し金額が正しく入力されていません', 1),
(7162, 6, '410116', '银行卡号输入有误', '銀行カード番号が正しく入力されていません', 1),
(7163, 6, '410117', '请输入支付宝账号', 'アリペイの口座番号を入力してください', 1),
(7164, 6, '410118', '请输入银行卡账号', '銀行カードの口座番号を入力してください', 1),
(7165, 6, '410119', '请输入开户行信息', '銀行情報を入力してください', 1),
(7166, 6, '410120', '申请提现成功', '出金申請が成功しました', 1),
(7167, 6, '410121', '申请提现失败', '出金申請に失敗しました', 1),
(7168, 6, '410122', '充值金额不能为0元', 'リチャージ額を 0 元にすることはできません', 1),
(7169, 6, '410123', '充值方式不支持', '再充電方法はサポートされていません', 1),
(7170, 6, '410124', '充值金额不能低于{:money}', 'リチャージ額を {:money} 未満にすることはできません', 1),
(7171, 6, '410125', '充值成功', 'リチャージ成功', 1),
(7172, 6, '410126', '充值失败', '再充電に失敗しました', 1),
(7173, 6, '410127', '签到获得{:integral}积分', 'サインインして {:integral} ポイントを獲得', 1),
(7174, 6, '410128', '签到失败', 'サインインに失敗しました', 1),
(7175, 6, '410129', '收藏成功', 'コレクションは成功しました', 1),
(7176, 6, '410130', '收藏失败', '収集に失敗しました', 1),
(7177, 6, '410131', '授权失败', '認証に失敗しました', 1),
(7178, 6, '410132', 'unionid不存在', 'unionid が存在しません', 1),
(7179, 6, '410133', '获取用户UID失败', 'ユーザー UID の取得に失敗しました', 1),
(7180, 6, '410134', '请输入昵称或者选择头像', 'ニックネームを入力するか、アバターを選択してください', 1),
(7181, 6, '410135', '注销成功', 'ログアウト成功', 1),
(7182, 6, '410136', '暂无客服人员在线，请稍后联系', 'カスタマー サービス スタッフがオンラインにいません。後でご連絡ください', 1),
(7183, 6, '410137', '不能和自己聊天', '自分とチャットできません', 1),
(7184, 6, '410138', '您不是客服无法登录', 'あなたはカスタマー サービスではないため、ログインできません', 1),
(7185, 6, '410139', '自己不能转接给自己', '自分自身に転送できません', 1),
(7186, 6, '410140', '转接客服失败', '顧客サービスの転送に失敗しました', 1),
(7187, 6, '410141', '没有此用户', 'そのようなユーザーはいません', 1),
(7188, 6, '410142', '客服不存在', 'カスタマーサービスは存在しません', 1),
(7189, 6, '410143', '商品未查到', '商品が見つかりません', 1),
(7190, 6, '410144', '请填写开票手机号', '請求先電話番号を入力してください', 1),
(7191, 6, '410145', '请填写发票抬头（开具发票企业名称）', '請求書のタイトル（請求書発行会社名）を記入してください', 1),
(7192, 6, '410146', '请填写正确的发票抬头（开具发票企业名称）', '請求書のヘッダー (請求書を発行した会社の名前) を正しく入力してください', 1),
(7193, 6, '410147', '请填写发票税号', 'インボイス税番号を入力してください', 1),
(7194, 6, '410148', '请填写正确的发票税号', '正しいインボイス税番号を入力してください', 1),
(7195, 6, '410149', '请填写正确的银行卡号', '正しい銀行カード番号を入力してください', 1),
(7196, 6, '410150', '地址不存在', 'アドレスが存在しません', 1),
(7197, 6, '410151', '收货地址格式错误', '配送先住所の形式が正しくありません', 1),
(7198, 6, '410152', '收货地址格式错误或系统未完善当前地址', '配送先住所の形式が正しくないか、システムが現在の住所を補完していません', 1),
(7199, 6, '410153', '收货地址格式错误，请重新选择', '配送先住所の形式が正しくありません。もう一度選択してください', 1),
(7200, 6, '410154', '请填写详细地址', '詳しい住所を記入してください', 1),
(7201, 6, '410155', '名称必须填写', '名前を入力する必要があります', 1),
(7202, 6, '410156', '名称最多不能超过25个字符', '名前は 25 文字を超えることはできません', 1),
(7203, 6, '410157', '手机号必须填写', '携帯電話番号を入力する必要があります', 1),
(7204, 6, '410158', '手机号格式错误', '携帯電話番号の形式エラー', 1),
(7205, 6, '410159', '省必须填写', '都道府県を記入する必要があります', 1),
(7206, 6, '410160', '市必须填写', '市が記入する必要があります', 1),
(7207, 6, '410161', '区/县必须填写', '地区/郡を入力する必要があります', 1),
(7208, 6, '410162', '详细地址必须填写', '詳細な住所を入力する必要があります', 1),
(7209, 6, '410163', '请填写反馈内容', 'フィードバックの内容を記入してください', 1),
(7210, 6, '410164', '比例不能大于您的比例', '比率をあなたの比率より大きくすることはできません', 1),
(7211, 6, '410165', '激活成功', 'アクティベーション成功', 1),
(7212, 6, '410166', '暂无海报', 'まだポスターがありません', 1),
(7213, 6, '410167', '二维码生成失败', 'QR コードの生成に失敗しました', 1),
(7214, 6, '410168', '缺少字体文件Bold', 'フォント ファイル Bold がありません', 1),
(7215, 6, '410169', '缺少字体文件Normal', '不足しているフォント ファイル Normal', 1),
(7216, 6, '410170', '生成图片失败', '画像の生成に失敗しました', 1),
(7217, 6, '410171', '生成图片时，系统错误', '画像の生成中にシステム エラーが発生しました', 1),
(7218, 6, '410172', '生成海报失败', 'ポスターの生成に失敗しました', 1),
(7219, 6, '410173', '订单不存在', '注文が存在しません', 1),
(7220, 6, '410174', '订单已支付', '支払い済みの注文', 1),
(7221, 6, '410175', '请填写实际支付金额', '実際の支払い額を入力してください', 1),
(7222, 6, '410176', '实际支付金额不能小于0元', '実際の支払い額は 0 元未満にすることはできません', 1),
(7223, 6, '410177', '请填写备注内容', '備考欄にご記入ください', 1),
(7224, 6, '410178', '请先处理售后申请', 'アフターサービス申請を先に処理してください', 1),
(7225, 6, '410179', '用户已取消申请', 'ユーザーがアプリケーションをキャンセルしました', 1),
(7226, 6, '410180', '售后订单状态不支持该操作', 'アフター オーダー ステータスはこの操作をサポートしていません', 1),
(7227, 6, '410181', '退款修改状态错误', '払い戻し変更ステータス エラー', 1),
(7228, 6, '410182', '修改退款状态成功', '返金ステータスを正常に変更', 1),
(7229, 6, '410183', '已退完支付金额，不能再退款了', '支払い金額は返金されました。これ以上返金することはできません', 1),
(7230, 6, '410184', '请输入退款金额', '返金額を入力してください', 1),
(7231, 6, '410185', '退款金额大于支付金额，请修改退款金额', '返金額が支払い額を超えています。返金額を変更してください', 1),
(7232, 6, '410186', '退款成功', '払い戻し成功', 1),
(7233, 6, '410187', '退款失败', '払い戻しに失敗しました', 1),
(7234, 6, '410188', '请输入核销码或者扫描核销二维码', '償却コードを入力するか、償却QRコードをスキャンしてください', 1),
(7235, 6, '410189', '核销成功', '成功した償却', 1),
(7236, 6, '410190', '请输入付款金额', 'お支払い金額を入力してください', 1),
(7237, 6, '410191', '支付金额不能为0元', '支払額を 0 元にすることはできません', 1),
(7238, 6, '410192', '付费会员功能暂未开启', '有料会員機能はまだ開いていません', 1),
(7239, 6, '410193', '支付数据生成失败', '支払いデータの生成に失敗しました', 1),
(7240, 6, '410194', '支付订单不存在', '支払い注文が存在しません', 1),
(7241, 6, '410195', '微信支付成功', 'WeChat での支払いが成功しました', 1),
(7242, 6, '410196', '前往支付', '支払いに進む', 1),
(7243, 6, '410197', '余额支付成功', '残高の支払いが成功しました', 1),
(7244, 6, '410198', '请传入支付宝支付回调URL', 'アリペイ支払いコールバック URL を渡してください', 1),
(7245, 6, '410199', '支付宝支付成功', 'Alipay での支払いが成功しました', 1),
(7246, 6, '410200', '订单生成失败', '注文の生成に失敗しました', 1),
(7247, 6, '410201', '请提交购买的商品', '購入した製品を提出してください', 1),
(7248, 6, '410202', '商品不存在，请重新选择商品下单', '製品が存在しません。製品を再選択して注文してください', 1),
(7249, 6, '410203', '订单创建成功', '注文が正常に作成されました', 1),
(7250, 6, '410204', '收货成功', '商品を受け取りました', 1),
(7251, 6, '410205', '收货失败', '受信に失敗しました', 1),
(7252, 6, '410206', '快递单号不存在', 'エクスプレス追跡番号が存在しません', 1),
(7253, 6, '410207', '默认运费模板未配置，无法下单', 'デフォルトの配送テンプレートが設定されていないため、注文できません', 1),
(7254, 6, '410208', '订单已过期,请刷新当前页面', '注文の有効期限が切れています。現在のページを更新してください', 1),
(7255, 6, '410209', '订单已创建，请点击查看完成支付', '注文が作成されました。支払いを完了するにはクリックして表示してください', 1),
(7256, 6, '410210', '订单生成失败，你已经在该团内不能再参加了', '注文の生成に失敗しました。グループに参加できなくなりました', 1),
(7257, 6, '410211', '订单生成失败，你已经参加该团了，请先支付订单', '注文の生成に失敗しました。すでにグループに参加しています。最初に注文を支払ってください', 1),
(7258, 6, '410212', '该团人员已满', 'グループは満員です', 1),
(7259, 6, '410213', '暂不支持该支付方式，请刷新页面或者联系管理员', 'この支払い方法は現在サポートされていません。ページを更新するか、管理者に連絡してください', 1),
(7260, 6, '410214', '您购买的商品库存已不足{:cart_num}{:unit_name}', '購入した在庫は十分ではありません {:cart_num}{:unit_name}', 1),
(7261, 6, '410215', '该订单已失效', '注文は期限切れです', 1),
(7262, 6, '410216', '支付失败', '支払いに失敗しました', 1),
(7263, 6, '410217', '支付成功', '支払いが成功しました', 1),
(7264, 6, '410218', '支付方式错误', '支払い方法エラー', 1),
(7265, 6, '410219', '订单商品已评价', '注文商品は評価されました', 1),
(7266, 6, '410220', '请为商品评分', '製品を評価してください', 1),
(7267, 6, '410221', '请为商家服务评分', 'ビジネス サービスを評価してください', 1),
(7268, 6, '410222', '评价失败', '評価に失敗しました', 1),
(7269, 6, '410223', '请重新选择退款商品或件数', '返金アイテムまたは個数を再選択してください', 1),
(7270, 6, '410224', '当前状态不能取消申请', '現在の状態では申請をキャンセルできません', 1),
(7271, 6, '410225', '重选成功', '再成功', 1),
(7272, 6, '410226', '订单已退款', '注文は返金されました', 1),
(7273, 6, '410227', '使用积分抵扣失败', '減点にポイントを使用できませんでした', 1),
(7274, 6, '410228', '会员类型不存在', 'メンバー タイプが存在しません', 1),
(7275, 6, '410229', '您已是永久会员无需再购买', 'あなたはすでに永久会員です。これ以上購入する必要はありません', 1),
(7276, 6, '410230', '该会员卡暂时无法购买', 'この会員カードは一時的に購入できません', 1),
(7277, 6, '410231', '您已经领取过免费会员', 'あなたはすでに無料メンバーシップを受け取っています', 1),
(7278, 6, '410232', '此类型会员卡暂未开售', 'このタイプの会員カードはまだ販売されていません', 1),
(7279, 6, '410233', '获取购物车信息失败', 'ショッピング カートの情報を取得できませんでした', 1),
(7280, 6, '410234', '您要购买的优惠券已失效，无法购买', '購入したいクーポンは期限切れのため購入できません', 1),
(7281, 6, '410235', '您已获取过该优惠券，无法再次购买', 'すでにクーポンを取得しているため、再度購入することはできません', 1),
(7282, 6, '410236', '请刷新后重试', '更新して再試行してください', 1),
(7283, 6, '410237', '暂无库存', '在庫なし', 1),
(7284, 6, '410238', '选择的规格库存不足', '選択した仕様は在庫切れです', 1),
(7285, 6, '410239', '单次购买数量不能大于 {:limit} 件', '1 回の購入数量は {:limit} 個を超えることはできません', 1),
(7286, 6, '410240', '该商品限购 {:limit} 件，您已经购买 {:pay_num} 件', 'この商品は {:limit} 個に限定されています。すでに {:pay_num} 個を購入しています', 1),
(7287, 6, '410241', '选择支付方式有误', '間違った支払い方法が選択されました', 1),
(7288, 6, '410242', '选择的优惠劵无效', '選択したクーポンは無効です', 1),
(7289, 6, '410243', '不满足优惠劵的使用条件', 'クーポンを使用するための条件が満たされていません', 1),
(7290, 6, '410244', '使用优惠劵失败', 'クーポンの使用に失敗しました', 1),
(7291, 6, '410245', '请填写姓名和电话', 'お名前と電話番号を入力してください', 1),
(7292, 6, '410246', '营销商品不能使用线下支付', 'オフライン決済は商品のマーケティングには使用できません', 1),
(7293, 6, '410247', '暂无门店无法选择门店自提', '現在店舗がなく、店舗での受け取りを選択できません', 1),
(7294, 6, '410248', '订单商品结算失败', '注文商品の決済に失敗しました', 1),
(7295, 6, '410249', '发票已申请', '請求書が適用されました', 1),
(7296, 6, '410250', '正在申请退款中', '払い戻しを申請中', 1),
(7297, 6, '410251', '申请失败', '申請に失敗しました', 1),
(7298, 6, '410252', '退款件数大于订单件数', '返金数が注文数より多い', 1),
(7299, 6, '410253', '该订单已全部拆分', '注文が分割されました', 1),
(7300, 6, '410254', '申请退款失败', '払い戻しの申請に失敗しました', 1),
(7301, 6, '410255', '存在待处理退款单', '保留中の返金注文があります', 1),
(7302, 6, '410256', '该订单无法删除', 'この注文は削除できません', 1),
(7303, 6, '410257', '订单已经支付无法取消', '注文は支払い済みで、キャンセルできません', 1),
(7304, 6, '410258', '拼团商品不能再来一单，请在拼团商品内自行下单', 'グループ化された製品は再度注文できません。ご自身でグループ化された製品を注文してください', 1),
(7305, 6, '410259', '砍价商品不能再来一单，请在砍价商品内自行下单', '特価品は再注文できません。特価品で独自に注文してください', 1),
(7306, 6, '410260', '秒杀商品不能再来一单，请在秒杀商品内自行下单', 'seckill アイテムを再度注文することはできません。seckill アイテム内で注文してください', 1),
(7307, 6, '410261', '预售商品不能再来一单，请在预售商品内自行下单', 'プレセール商品は再注文できません。ご自身でプレセール商品を注文してください', 1),
(7308, 6, '410262', '再来一单失败，请重新下单', '別の注文が失敗しました。新しい注文をしてください', 1),
(7309, 6, '410263', '该订单无法支付', '注文を支払うことができません', 1),
(7310, 6, '410264', '订单支付状态有误，无法进行支付', '注文の支払い状況が正しくなく、支払いができません', 1),
(7311, 6, '410265', '该订单已支付', '注文は支払われました', 1),
(7312, 6, '410266', '订单状态错误', '注文ステータス エラー', 1),
(7313, 6, '410267', '此订单不能被核销', 'この注文は償却できません', 1),
(7314, 6, '410268', '订单有售后申请请先处理', '注文にはアフターセールス アプリケーションがあります。最初に処理してください', 1),
(7315, 6, '410269', '您无权限核销此订单，请联系管理员', 'この注文を破棄する権限がありません。管理者に連絡してください', 1),
(7316, 6, '410270', '订单已核销', '注文は償却されました', 1),
(7317, 6, '410271', '拼团订单暂未成功无法核销', 'グループ注文はまだ正常に償却されていません', 1),
(7318, 6, '410272', '核销失败', '検証に失敗しました', 1),
(7319, 6, '410273', '发货成功', '配信成功', 1),
(7320, 6, '410274', '无需支付', '支払いは必要ありません', 1),
(7321, 6, '410275', '获取用户openid失败,无法支付', 'ユーザーの openid を取得できませんでした。支払いができません', 1),
(7322, 6, '410276', '网站名称配置未填写,无法支付', 'ウェブサイト名の設定が入力されていないため、支払いができません', 1),
(7323, 6, '410277', '支付方式不存在', '支払い方法が存在しません', 1),
(7324, 6, '410278', '不支持该类型方式', 'このタイプのメソッドはサポートされていません', 1),
(7325, 6, '410279', '余额支付失败', '残高の支払いに失敗しました', 1),
(7326, 6, '410280', '暂未开启发票', '請求書はまだ開封されていません', 1),
(7327, 6, '410281', '暂未开启专用发票', '特別請求書はまだ開封されていません', 1),
(7328, 6, '410282', '该发票已经存在', '請求書は既に存在します', 1),
(7329, 6, '410283', '设置默认发票失败', 'デフォルトの請求書の設定に失敗しました', 1),
(7330, 6, '410284', '没有此用户，无法检测升级用户等级', 'このユーザーがいないと、アップグレード ユーザー レベルを検出できません', 1),
(7331, 6, '410285', '检测升级失败', 'アップグレードのチェックに失敗しました', 1),
(7332, 6, '410286', '修改订单失败', '注文の変更に失敗しました', 1),
(7333, 6, '410287', '修改用户信息失败', 'ユーザー情報の変更に失敗しました', 1),
(7334, 6, '410288', '绑定推广关系失败', 'プロモーション関係のバインドに失敗しました', 1),
(7335, 6, '410289', '天数不能为0', '日数を 0 にすることはできません', 1),
(7336, 6, '410290', '添加签到数据失败', 'チェックイン データの追加に失敗しました', 1),
(7337, 6, '410291', '赠送经验失败', '経験値の付与に失敗しました', 1),
(7338, 6, '410292', '请先配置签到天数', '最初にチェックイン日を設定してください', 1),
(7339, 6, '410293', '已经签到', 'サインイン', 1),
(7340, 6, '410294', '商品不存在', '商品が存在しません', 1),
(7341, 6, '410295', '该商品已下架或删除', 'アイテムは削除または削除されました', 1),
(7342, 6, '410296', '该商品库存不足', 'この商品は在庫切れです', 1),
(7343, 6, '410297', '该商品库存不足{:num}', 'この製品 {:num} の在庫が不足しています', 1),
(7344, 6, '410298', '每人总共限购{:num}件', 'お一人様合計 {:num} 個まで', 1),
(7345, 6, '410299', '砍价已结束', '交渉は終了しました', 1),
(7346, 6, '410300', '您不能再发起此件商品砍价', 'このアイテムの交渉を開始することはできなくなりました', 1),
(7347, 6, '410301', '该分享未开启砍价', '共有は交渉のために開かれていません', 1),
(7348, 6, '410302', '您已经帮砍过此砍价', 'あなたはすでに値下げに協力しています', 1),
(7349, 6, '410303', '砍价信息没有查到', '交渉情報が見つかりませんでした', 1),
(7350, 6, '410304', '用户砍价信息未查到', 'ユーザー交渉情報が見つかりません', 1),
(7351, 6, '410305', '请选择有效的商品属性', '有効な製品属性を選択してください', 1),
(7352, 6, '410306', '砍价商品不存在', '特価品は存在しません', 1),
(7353, 6, '410307', '砍价失败', '交渉に失敗しました', 1),
(7354, 6, '410308', '砍价未成功', '交渉は失敗に終わった', 1),
(7355, 6, '410309', '砍价已支付', '交渉は支払われました', 1),
(7356, 6, '410310', '您不能再帮砍此件商品', 'あなたはもはやこのアイテムをカットするのを助けることができません', 1),
(7357, 6, '410311', '商品已被删除', 'アイテムは削除されました', 1),
(7358, 6, '410312', '拼团不存在或已下架,请手动申请退款', 'グループが存在しないか削除されました。手動で払い戻しを申請してください', 1),
(7359, 6, '410313', '每个订单限购{:num}件', '各注文は {:num} 個に制限されています', 1),
(7360, 6, '410314', '未查到拼团信息，无法取消', 'グループ情報が見つからず、キャンセルできません', 1),
(7361, 6, '410315', '拼团已到期', 'グループの有効期限が切れています', 1),
(7362, 6, '410316', '拼团已完成，无法取消', 'グループ化が完了し、キャンセルできません', 1),
(7363, 6, '410317', '每人限购{:num}件', 'お一人様 {:num} 個までに制限されています', 1),
(7364, 6, '410318', '抽奖不存在', '宝くじは存在しません', 1),
(7365, 6, '410319', '领取成功', '正常に受信', 1),
(7366, 6, '410320', '领取失败', '受信に失敗しました', 1),
(7367, 6, '410321', '活动未开始', 'イベントは開始されていません', 1),
(7368, 6, '410322', '活动已结束', 'イベントは終了しました', 1),
(7369, 6, '410323', '您已有这张优惠券，请勿重复购买', 'このクーポンは既にお持ちです。再度購入しないでください', 1),
(7370, 6, '410324', '请核对快递公司编码', '宅配会社コードを確認してください', 1),
(7371, 6, '410325', '请选择发票', '請求書を選択してください', 1),
(7372, 6, '-1', '系统繁忙，请稍候再试', 'システムがビジーです。後でもう一度試してください', 1),
(7373, 6, '43104', 'appid与openid不匹配', 'appid が openid と一致しません', 1),
(7374, 6, '45009', '达到微信api每日限额上限', 'WeChat API の 1 日の上限に達しました', 1),
(7375, 6, '45008', '图文消息超过限制', 'テキスト メッセージが制限を超えています', 1),
(7376, 6, '45007', '语音播放时间超过限制', '音声再生時間が制限を超えています', 1),
(7377, 6, '45006', '图片链接字段超过限制', '画像リンク フィールドが制限を超えています', 1),
(7378, 6, '45005', '链接字段超过限制', 'リンク フィールドが制限を超えています', 1),
(7379, 6, '45004', '描述字段超过限制', '説明フィールドが制限を超えています', 1),
(7380, 6, '45003', '标题字段超过限制', 'タイトル フィールドが制限を超えています', 1),
(7381, 6, '45002', '消息内容超过限制', 'メッセージの内容が制限を超えています', 1),
(7382, 6, '45001', '多媒体文件大小超过限制', 'マルチメディア ファイルのサイズが制限を超えています', 1),
(7383, 6, '44004', '文本消息内容为空', 'テキスト メッセージの内容が空です', 1),
(7384, 6, '44003', '图文消息内容为空', 'テキスト メッセージの内容が空です', 1),
(7385, 6, '44002', 'POST 的数据包为空', 'POST データ パケットが空です', 1),
(7386, 6, '44001', '多媒体文件为空', 'マルチメディア ファイルが空です', 1),
(7387, 6, '43019', '需要将接收者从黑名单中移除', '受信者をブラックリストから削除する必要があります', 1),
(7388, 6, '43005', '需要好友关系', '友情が必要', 1),
(7389, 6, '43004', '需要接收者关注', '受信者の注意が必要です', 1),
(7390, 6, '43003', '需要 HTTPS 请求', 'HTTPS リクエストが必要です', 1),
(7391, 6, '43002', '需要 POST 请求', 'POST リクエストが必要です', 1),
(7392, 6, '43001', '需要 GET 请求', 'GET リクエストが必要です', 1),
(7393, 6, '42007', '用户修改微信密码， accesstoken 和 refreshtoken 失效，需要重新授权', 'ユーザーが WeChat パスワードを変更しました。アクセストークンとリフレッシュトークンが無効であり、再認証する必要があります', 1),
(7394, 6, '42003', 'oauth_code 超时', 'oauth_code タイムアウト', 1),
(7395, 6, '42002', 'refresh_token 超时', 'refresh_token タイムアウト', 1),
(7396, 6, '42001', 'access_token 超时，请检查 access_token 的有效期，请参考基础支持 - 获取 access_token 中，对 access_token 的详细机制说明', 'access_token がタイムアウトしました。access_token の有効期間を確認してください。基本サポート - access_token の取得、access_token の詳細なメカニズムを参照してください', 1),
(7397, 6, '41009', '缺少 openid', 'openid がありません', 1),
(7398, 6, '41008', '缺少 oauth code', 'oauth コードがありません', 1),
(7399, 6, '41007', '缺少子菜单数据', 'サブメニュー データがありません', 1),
(7400, 6, '41006', '缺少 media_id 参数', 'media_id パラメータがありません', 1),
(7401, 6, '41005', '缺少多媒体文件数据', 'マルチメディア ファイル データがありません', 1),
(7402, 6, '41004', '缺少 secret 参数', 'シークレット パラメータがありません', 1),
(7403, 6, '41003', '缺少 refresh_token 参数', 'refresh_token パラメータがありません', 1),
(7404, 6, '41002', '缺少 appid 参数', 'appid パラメータがありません', 1),
(7405, 6, '41001', '缺少 access_token 参数', 'access_token パラメータがありません', 1),
(7406, 6, '40163', 'oauth_code已使用', 'oauth_code が使用されています', 1),
(7407, 6, '40155', '请勿添加其他公众号的主页链接', '他の公式アカウントへのリンクを追加しないでください', 1),
(7408, 6, '40137', '不支持的图片格式', 'サポートされていない画像形式', 1),
(7409, 6, '40132', '微信号不合法', 'Wechat ID は違法です', 1),
(7410, 6, '40125', '无效的appsecret', 'appsecret が無効です', 1),
(7411, 6, '40121', '不合法的 media_id 类型', 'media_id タイプが不正です', 1),
(7412, 6, '40120', '子 button 类型错误', 'サブボタンの種類が間違っています', 1),
(7413, 6, '40119', 'button 类型错误', 'ボタン タイプ エラー', 1),
(7414, 6, '40118', 'media_id 大小不合法', 'media_id のサイズが無効です', 1),
(7415, 6, '40117', '分组名字不合法', 'グループ名が無効です', 1),
(7416, 6, '40060', '删除单篇图文时，指定的 article_idx 不合法', '単一の画像を削除する場合、指定された article_idx は無効です', 1),
(7417, 6, '40051', '分组名字不合法', 'グループ名が無効です', 1),
(7418, 6, '40050', '不合法的分组 id', '不正なグループ ID', 1),
(7419, 6, '40048', '无效的url', '無効な URL', 1),
(7420, 6, '40039', '不合法的 URL 长度', 'URL の長さが不正です', 1),
(7421, 6, '40035', '不合法的参数', '不正なパラメータ', 1),
(7422, 6, '40038', '不合法的请求格式', '不正なリクエスト形式', 1),
(7423, 6, '40033', '不合法的请求字符，不能包含 \\uxxxx 格式的字符', '不正なリクエスト文字です。\\uxxxx 形式の文字を含めることはできません', 1),
(7424, 6, '40032', '不合法的 openid 列表长度', 'openid リストの長さが不正です', 1),
(7425, 6, '40031', '不合法的 openid 列表', '不正な openid リスト', 1),
(7426, 6, '40030', '不合法的 refresh_token', '不正な refresh_token', 1),
(7427, 6, '40029', '无效的 oauth_code', '無効な oauth_code', 1),
(7428, 6, '40028', '不合法的自定义菜单使用用户', '不正なカスタム メニュー ユーザー', 1),
(7429, 6, '40027', '不合法的子菜单按钮 URL 长度', 'サブメニュー ボタンの URL の長さが不正です', 1),
(7430, 6, '40026', '不合法的子菜单按钮 KEY 长度', 'サブメニュー ボタンのキーの長さが不正です', 1),
(7431, 6, '40025', '不合法的子菜单按钮名字长度', 'サブメニュー ボタン名の長さが不正です', 1),
(7432, 6, '40024', '不合法的子菜单按钮类型', 'サブメニュー ボタンの種類が正しくありません', 1),
(7433, 6, '40023', '不合法的子菜单按钮个数', 'サブメニュー ボタンの数が不正です', 1),
(7434, 6, '40022', '不合法的子菜单级数', '不正なサブメニュー レベル', 1),
(7435, 6, '40021', '不合法的菜单版本号', 'メニューのバージョン番号が不正です', 1),
(7436, 6, '40020', '不合法的按钮 URL 长度', 'ボタン URL の長さが不正です', 1),
(7437, 6, '40019', '不合法的按钮 KEY 长度', '不正なボタン KEY 長', 1),
(7438, 6, '40018', '不合法的按钮名字长度', 'ボタン名の長さが不正です', 1),
(7439, 6, '40017', '不合法的按钮类型', '不正なボタン タイプ', 1),
(7440, 6, '40016', '不合法的按钮个数', '不正なボタンの数', 1),
(7441, 6, '40015', '不合法的菜单类型', '不正なメニュー タイプ', 1),
(7442, 6, '40014', '不合法的 access_token ，请开发者认真比对 access_token 的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口', '不正な access_token です。access_token の有効性 (有効期限が切れているかどうかなど) を慎重に比較するか、適切な公式アカウントに対してインターフェイスが呼び出されているかどうかを確認してください', 1),
(7443, 6, '40013', '不合法的 AppID ，请开发者检查 AppID 的正确性，避免异常字符，注意大小写', '不正な AppID です。AppID の正確性を確認してください。異常な文字を避け、大文字と小文字に注意してください', 1),
(7444, 6, '40012', '不合法的缩略图文件大小', 'サムネールのファイルサイズが不正です', 1),
(7445, 6, '40011', '不合法的视频文件大小', '動画ファイルのサイズが不正です', 1),
(7446, 6, '40010', '不合法的语音文件大小', '音声ファイルのサイズが不正です', 1),
(7447, 6, '40009', '不合法的图片文件大小', '画像ファイルのサイズが不正です', 1),
(7448, 6, '40008', '不合法的消息类型', '不正なメッセージ タイプ', 1),
(7449, 6, '40007', '不合法的媒体文件 id', '不正なメディア ファイル ID', 1),
(7450, 6, '40006', '不合法的文件大小', '不正なファイル サイズ', 1),
(7451, 6, '40005', '不合法的文件类型', '不正なファイル タイプ', 1),
(7452, 6, '40004', '不合法的媒体文件类型', '不正なメディア ファイル タイプ', 1),
(7453, 6, '40003', '不合法的 OpenID ，请开发者确认 OpenID （该用户）是否已关注公众号，或是否是其他公众号的 OpenID', '不正な OpenID です。OpenID (ユーザー) が公式アカウントをフォローしているかどうか、または他の公式アカウントの OpenID であるかどうかを確認してください', 1),
(7454, 6, '40002', '不合法的凭证类型', '不正な証明書タイプ', 1),
(7455, 6, '40001', '获取 access_token 时 AppSecret 错误，或者 access_token 无效。请开发者认真比对 AppSecret 的正确性，或查看是否正在为恰当的公众号调用接口', 'access_token 取得時の AppSecret エラー、または access_token が無効です。開発者は、AppSecret の正確性を慎重に比較するか、適切な公式アカウントに対してインターフェイスが呼び出されているかどうかを確認する必要があります', 1),
(7456, 6, '200011', '此账号已被封禁，无法操作', 'このアカウントは禁止されており、操作できません', 1),
(7457, 6, '200012', '个人模版数已达上限，上限25个', '個人用テンプレートの数が上限に達しました。上限は 25 です', 1),
(7458, 6, '200014', '请检查小程序所属类目', 'アプレットのカテゴリを確認してください', 1),
(7459, 7, '100000', '保存成功', '저장 성공', 1),
(7460, 7, '100001', '修改成功', '수정 성공', 1),
(7461, 7, '100002', '删除成功', '삭제 성공', 1),
(7462, 7, '100003', '显示成功', '성공 표시', 1),
(7463, 7, '100004', '隐藏成功', '숨겨진 성공', 1),
(7464, 7, '100005', '操作失败', '작업 실패', 1),
(7465, 7, '100006', '保存失败', '저장 실패', 1),
(7466, 7, '100007', '修改失败', '수정 실패', 1),
(7467, 7, '100008', '删除失败', '삭제 실패', 1),
(7468, 7, '100009', '图片上传成功', '이미지 업로드 성공', 1),
(7469, 7, '100010', '操作成功', '작업 성공', 1),
(7470, 7, '100011', '暂无数据', '데이터 없음', 1),
(7471, 7, '100012', '更新成功', '업데이트 성공', 1),
(7472, 7, '100013', '更新失败', '업데이트 실패', 1),
(7473, 7, '100014', '设置成功', '성공적으로 설정', 1),
(7474, 7, '100015', '设置失败', '설정 실패', 1),
(7475, 7, '100016', '获取失败', '실패', 1),
(7476, 7, '100017', '提交成功', '제출 성공', 1),
(7477, 7, '100018', '提交失败', '제출 실패', 1),
(7478, 7, '100019', '取消成功', '성공 취소', 1),
(7479, 7, '100020', '取消失败', '취소 실패', 1),
(7480, 7, '100021', '添加成功', '성공적으로 추가됨', 1),
(7481, 7, '100022', '添加失败', '추가 실패', 1),
(7482, 7, '100023', '保存token失败', '토큰 저장 실패', 1),
(7483, 7, '100024', '备注成功', '비고 성공', 1),
(7484, 7, '100025', '备注失败', '댓글 실패', 1),
(7485, 7, '100026', '数据不存在', '데이터가 존재하지 않습니다', 1),
(7486, 7, '100027', '申请成功', '적용 성공', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(7487, 7, '100028', '申请失败', '신청 실패', 1),
(7488, 7, '100029', '暂无此方法', '이런 방법이 없습니다', 1),
(7489, 7, '100030', '发送成功', '성공적으로 보내기', 1),
(7490, 7, '100031', '发送失败', '전송 실패', 1),
(7491, 7, '100032', '上传成功', '업로드 성공', 1),
(7492, 7, '100033', '上传失败', '업로드 실패', 1),
(7493, 7, '100034', '移动成功', '성공적으로 이동', 1),
(7494, 7, '100035', '移动失败', '이동 실패', 1),
(7495, 7, '100036', '退款成功', '환불 성공', 1),
(7496, 7, '100037', '退款失败', '환불 실패', 1),
(7497, 7, '100038', '同步成功', '동기화 성공', 1),
(7498, 7, '100039', '同步失败', '동기화 실패', 1),
(7499, 7, '100040', '恢复成功', '복구 성공', 1),
(7500, 7, '100041', '恢复失败', '복구 실패', 1),
(7501, 7, '100042', '退出成功', '성공적으로 종료', 1),
(7502, 7, '100043', '退出失败', '종료 실패', 1),
(7503, 7, '100044', '开通成功', '성공적으로 열림', 1),
(7504, 7, '100045', '开通失败', '활성화 실패', 1),
(7505, 7, '100046', '清除数据成功', '데이터 지우기 성공', 1),
(7506, 7, '100047', '优化成功', '최적화 성공', 1),
(7507, 7, '100048', '优化失败', '최적화 실패', 1),
(7508, 7, '100049', '修复成功', '수리 성공', 1),
(7509, 7, '100050', '修复失败', '수리 실패', 1),
(7510, 7, '100051', '备份成功', '백업 성공', 1),
(7511, 7, '100052', '备份失败', '백업 실패', 1),
(7512, 7, '100100', '参数错误', '매개변수 오류', 1),
(7513, 7, '100101', '非法操作', '불법 조작', 1),
(7514, 7, '100102', '数据获取失败', '데이터 수집 실패', 1),
(7515, 7, '100103', '站点升级中，请稍候访问', '사이트가 업그레이드 중입니다. 나중에 방문하세요', 1),
(7516, 7, '100104', '缺少code', '코드 누락', 1),
(7517, 7, '110000', '您暂时没有访问权限', '일시적으로 접근 권한이 없습니다', 1),
(7518, 7, '110001', '接口未授权，您无法访问', '인터페이스가 인증되지 않아 액세스할 수 없습니다', 1),
(7519, 7, '110002', '请登录', '로그인하세요', 1),
(7520, 7, '110003', '登录已过期,请重新登录', '로그인이 만료되었습니다. 다시 로그인하십시오', 1),
(7521, 7, '110004', '登录状态有误,请重新登录', '로그인 상태가 올바르지 않습니다. 다시 로그인하십시오', 1),
(7522, 7, '110005', '请登录', '로그인하세요', 1),
(7523, 7, '110006', '登录已过期,请重新登录', '로그인이 만료되었습니다. 다시 로그인하십시오', 1),
(7524, 7, '110007', '登录状态有误,请重新登录', '로그인 상태가 올바르지 않습니다. 다시 로그인하십시오', 1),
(7525, 7, '400000', '请选择用户头像', '사용자 아바타를 선택하세요', 1),
(7526, 7, '400001', '请填写用户昵称', '사용자의 닉네임을 입력해주세요', 1),
(7527, 7, '400002', '请填写评论内容', '댓글을 작성해주세요', 1),
(7528, 7, '400003', '请选择商品分数', '상품 점수를 선택해주세요', 1),
(7529, 7, '400004', '请选择服务分数', '서비스 점수를 선택하세요', 1),
(7530, 7, '400005', '商品分数必须是1-5之间的整数', '상품 점수는 1-5 사이의 정수여야 합니다', 1),
(7531, 7, '400006', '服务分数必须是1-5之间的整数', '서비스 점수는 1-5 사이의 정수여야 합니다', 1),
(7532, 7, '400007', '请选择快递公司', '택배사를 선택하세요', 1),
(7533, 7, '400008', '请填写寄件人姓名', '발신자 이름을 입력하세요', 1),
(7534, 7, '400009', '请输入寄件人手机号码', '발신인의 휴대폰 번호를 입력하세요', 1),
(7535, 7, '400010', '寄件人手机号码不正确', '발신자 휴대폰 번호가 틀립니다', 1),
(7536, 7, '400011', '请填写寄件人详细地址', '발신인 상세 주소를 입력해주세요', 1),
(7537, 7, '400012', '请填写云打印机编号', '클라우드 프린터 번호를 입력하세요', 1),
(7538, 7, '400013', '请传入套餐id', '패키지 ID를 전달하세요', 1),
(7539, 7, '400014', '套餐id必须为数字', '패키지 ID는 숫자여야 합니다', 1),
(7540, 7, '400015', '请填写套餐金额', '패키지 금액을 입력하세요', 1),
(7541, 7, '400016', '请填写购买数量', '구매 수량을 기입해주세요', 1),
(7542, 7, '400017', '购买数量必须为数字', '구매 수량은 숫자여야 합니다', 1),
(7543, 7, '400018', '请填写购买套餐类型', '구매 패키지 유형을 입력하세요', 1),
(7544, 7, '400019', '您输入的手机号码必须为数字', '입력하신 휴대폰 번호는 반드시 숫자여야 합니다', 1),
(7545, 7, '400020', '密码必须填写', '비밀번호는 반드시 입력해야 합니다', 1),
(7546, 7, '400021', '短信验证码必须为数字', 'SMS 인증번호는 반드시 숫자여야 합니다', 1),
(7547, 7, '400022', '请填写话术内容', '언어의 내용을 입력하세요', 1),
(7548, 7, '400023', '请填写排序数字', '정렬 번호를 입력하세요', 1),
(7549, 7, '400024', '请填写排序数字', '정렬 번호를 입력하세요', 1),
(7550, 7, '400025', '请填写运费模板名称', '배송 템플릿 이름을 입력하세요', 1),
(7551, 7, '400026', '运费信息必须为数组', '배송 정보는 배열이어야 합니다', 1),
(7552, 7, '400027', '包邮信息必须为数组', '패키지 정보는 배열이어야 합니다', 1),
(7553, 7, '400028', '不送达信息必须为数组', '전달되지 않은 정보는 배열이어야 합니다', 1),
(7554, 7, '400029', 'type数据格式错误，应为1或2或3', '유형 데이터 형식 오류, 1 또는 2 또는 3이어야 함', 1),
(7555, 7, '400030', 'appoint数据格式错误，应为0或1', '지정 데이터 형식이 올바르지 않습니다. 0 또는 1이어야 합니다', 1),
(7556, 7, '400031', 'no_delivery数据格式错误，应为0或1', 'no_delivery 데이터 형식 오류, 0 또는 1이어야 함', 1),
(7557, 7, '400032', 'sort数据格式错误，应为整数', '정렬 데이터 형식 오류, 정수여야 합니다', 1),
(7558, 7, '400033', '请填写管理员账号', '관리자 계정을 입력하세요', 1),
(7559, 7, '400034', '管理员账号为英文字母', '관리자 계정은 영문입니다', 1),
(7560, 7, '400035', '请输管理员姓名', '관리자 이름을 입력하세요', 1),
(7561, 7, '400036', '请选择管理员身份', '관리자 ID를 선택하십시오', 1),
(7562, 7, '400037', '身份必须为数组', 'ID는 배열이어야 합니다', 1),
(7563, 7, '400038', '请填写城市名称', '도시 이름을 입력하세요', 1),
(7564, 7, '400039', 'level数据格式错误，应为整数', '레벨 데이터 형식 오류, 정수여야 함', 1),
(7565, 7, '400040', 'parent_id数据格式错误，应为整数', 'parent_id 데이터 형식 오류, 정수여야 함', 1),
(7566, 7, '400041', '请输入有效的网址', '유효한 URL을 입력하세요', 1),
(7567, 7, '400042', '一级返佣比例必须为数字', '1단계 리베이트 비율은 숫자여야 합니다', 1),
(7568, 7, '400043', '一级返佣比例最多两位小数', '첫 번째 수준의 리베이트 비율은 소수점 이하 두 자리까지 가능합니다.', 1),
(7569, 7, '400044', '一级返佣比例填写范围在0-100之间', '첫 번째 수준의 리베이트 비율은 0-100 사이의 범위로 채워집니다.', 1),
(7570, 7, '400045', '二级返佣比例必须为数字', '2차 리베이트 비율은 숫자여야 합니다', 1),
(7571, 7, '400046', '二级返佣比例最多两位小数', '2차 리베이트 비율은 소수점 이하 두 자리까지 가능합니다.', 1),
(7572, 7, '400047', '二级返佣比例填写范围在0-100之间', '2차 리베이트 비율은 0-100 사이의 범위로 채워집니다', 1),
(7573, 7, '400048', '待补货数量必须为数字', '보충할 수량은 반드시 숫자여야 합니다', 1),
(7574, 7, '400049', '警戒库存必须为数字', '경고 재고는 숫자여야 합니다', 1),
(7575, 7, '400050', '提现最小金额只能为数字', '최소 출금금액은 숫자만 가능합니다', 1),
(7576, 7, '400051', '提现最小金额必须大于0', '최소 출금 금액은 0보다 커야 합니다', 1),
(7577, 7, '400052', '佣金冻结时间范围在0-180之间', '수수료 동결 시간 범위는 0-180입니다', 1),
(7578, 7, '400053', '满额分销金额金额必须为数字', '전체 분배 금액은 숫자여야 합니다', 1),
(7579, 7, '400054', '积分抵用比例必须为数字', '포인트 적립 비율은 숫자여야 합니다', 1),
(7580, 7, '400055', '积分抵用比例最多两位小数', '공제 가능한 포인트의 백분율은 소수점 이하 두 자리까지 가능합니다.', 1),
(7581, 7, '400056', '积分抵用比例必须在0-1000之间', '크레딧 포인트의 백분율은 0-1000 사이여야 합니다', 1),
(7582, 7, '400057', '积分抵用上限必须为数字', '신용 한도의 상한선은 숫자여야 합니다', 1),
(7583, 7, '400058', '积分抵用上限必须大于等于0', '포인트 차감 상한선은 0보다 크거나 같아야 합니다', 1),
(7584, 7, '400059', '下单赠送积分必须为数字', '주문 보너스 포인트는 숫자여야 합니다', 1),
(7585, 7, '400060', '下单赠送积分必须在0-1000之间', '주문 보너스 포인트는 0-1000 사이여야 합니다', 1),
(7586, 7, '400061', '普通商品未支付取消订单时间必须为数字', '일반 상품은 미납, 취소 시간은 숫자여야 합니다', 1),
(7587, 7, '400062', '活动商品未支付取消订单时间必须为数字', '이벤트 아이템 미결제 시 주문 취소 시점은 숫자여야 합니다', 1),
(7588, 7, '400063', '砍价商品未支付取消订单时间必须为数字', '할인된 상품이 결제되지 않은 경우 주문을 취소하는 시간은 반드시 숫자여야 합니다', 1),
(7589, 7, '400064', '拼团商品未支付取消订单时间必须为数字', '단체 상품 미결제 시 주문 취소 시간은 반드시 숫자여야 합니다', 1),
(7590, 7, '400065', '订单发货后自动收货时间必须为数字', '주문 후 자동 입고 시간은 반드시 숫자여야 합니다', 1),
(7591, 7, '400066', '满额包邮金额必须为数字', '무료배송 금액 전액은 반드시 숫자여야 합니다', 1),
(7592, 7, '400067', '积分倍数必须大于0', '적분배수는 0보다 커야 합니다', 1),
(7593, 7, '400068', '折扣数必须大于0', '할인 횟수는 0보다 커야 합니다', 1),
(7594, 7, '400069', '积分倍数必须大于0', '적분배수는 0보다 커야 합니다', 1),
(7595, 7, '400070', '折扣数必须大于0', '할인 횟수는 0보다 커야 합니다', 1),
(7596, 7, '400071', '下单赠送经验比率必须为数字', '주문 시 보상 경험치 비율은 숫자여야 합니다', 1),
(7597, 7, '400072', '下单赠送经验比率必须大于0', '주문 보너스 경험치 비율은 0보다 커야 합니다', 1),
(7598, 7, '400073', '签到赠送经验必须为数字', '로그인 경험은 숫자여야 합니다', 1),
(7599, 7, '400074', '签到赠送经验必须大于0', '로그인 경험치는 0보다 커야 합니다', 1),
(7600, 7, '400075', '邀请新用户赠送经验必须为数字', '경험치를 주기 위해 신규 사용자를 초대하는 것은 숫자여야 합니다', 1),
(7601, 7, '400076', '邀请新用户赠送经验必须大于0', '경험치를 주기 위한 신규 사용자 초대는 0보다 커야 합니다', 1),
(7602, 7, '400077', '发货人姓名必须为汉字', '보내는 사람의 이름은 한자여야 합니다', 1),
(7603, 7, '400078', '发货人姓名长度在2-10位', '발신자 이름의 길이는 2-10자리입니다', 1),
(7604, 7, '400079', '发货人电话必须为数字', '발신자 전화번호는 반드시 숫자여야 합니다', 1),
(7605, 7, '400080', '发货人电话请填写有效的手机号', '발신자 전화번호에 유효한 휴대폰 번호를 입력하세요', 1),
(7606, 7, '400081', '发货人地址只能是汉字、字母、数字', '발신인 주소는 한자,문자,숫자만 가능합니다', 1),
(7607, 7, '400082', '发货人地址长度为10-100位', '발신인 주소의 길이는 10-100자리입니다', 1),
(7608, 7, '400083', '电子面单打印机编号必须为数字、字母', '전자서식의 프린터 번호는 반드시 숫자와 문자여야 합니다', 1),
(7609, 7, '400084', '电子面单打印机编号长度为10-50位', '전자 단일 프린터의 일련 번호 길이는 10-50자리입니다', 1),
(7610, 7, '400085', '客服反馈长度位10-90位', '고객 서비스 피드백 길이는 10-90자리입니다', 1),
(7611, 7, '400086', '请填写标签分类名称', '레이블 카테고리 이름을 입력하세요', 1),
(7612, 7, '400087', '请填写标签分类排序', '라벨 분류 순서를 작성해주세요', 1),
(7613, 7, '400088', '标签分类必须为数字', '레이블 분류는 숫자여야 합니다', 1),
(7614, 7, '400089', '账号只能为数字和字母', '계좌번호는 숫자와 문자만 가능합니다', 1),
(7615, 7, '400090', '限量不能超过商品库存', '한도는 제품 재고를 초과할 수 없습니다', 1),
(7616, 7, '400091', '商品已下架或移入回收站', '아이템이 선반에서 제거되었거나 휴지통으로 이동되었습니다', 1),
(7617, 7, '400092', '占用库存失败', '인벤토리 점유 실패', 1),
(7618, 7, '400093', '商品已下架或已删除', '제품이 선반에서 제거되거나 삭제되었습니다', 1),
(7619, 7, '400094', '请选择有效的商品属性', '올바른 제품 속성을 선택하십시오', 1),
(7620, 7, '400095', '金额不能小于0', '금액은 0보다 작을 수 없습니다', 1),
(7621, 7, '400096', '结束时间不能小于今天', '종료 시간은 오늘보다 작을 수 없습니다', 1),
(7622, 7, '400097', '您不是付费会员', '유료회원이 아닙니다', 1),
(7623, 7, '400098', '暂时无法领取', '일시적으로 사용할 수 없음', 1),
(7624, 7, '400099', '请先配置小票打印开发者', '영수증 출력 개발자를 먼저 설정해주세요', 1),
(7625, 7, '400100', '请填写分类名称', '카테고리 이름을 입력하세요', 1),
(7626, 7, '400101', '该分类已存在', '이 카테고리는 이미 존재합니다', 1),
(7627, 7, '400102', '请先删除子分类', '하위 카테고리를 먼저 삭제하세요', 1),
(7628, 7, '400103', '分类不存在', '분류가 존재하지 않습니다', 1),
(7629, 7, '400104', '文件名称不能为空', '파일 이름은 비워둘 수 없습니다', 1),
(7630, 7, '400105', '该分类有下级分类，无法修改上级', '이 범주에는 하위 범주가 있으며 상위 범주를 수정할 수 없습니다', 1),
(7631, 7, '400106', '备注不能为空', '비고란은 비워둘 수 없습니다', 1),
(7632, 7, '400107', '请输入姓名', '이름을 입력하세요', 1),
(7633, 7, '400108', '请输入提现金额', '출금금액을 입력하세요', 1),
(7634, 7, '400109', '请输入支付宝账号', '알리페이 계좌번호를 입력하세요', 1),
(7635, 7, '400110', '请输入微信账号', '위챗 계정을 입력하세요', 1),
(7636, 7, '400111', '请输入银行卡号', '은행 카드 번호를 입력하세요', 1),
(7637, 7, '400112', '请输入开户行', '계좌 개설 은행을 입력하세요', 1),
(7638, 7, '400113', '拒绝理由不能为空', '거부 사유는 비워둘 수 없습니다', 1),
(7639, 7, '400114', '不能重复收货', '반복 상품 수령 불가', 1),
(7640, 7, '400115', '请先发货或者送货', '먼저 보내거나 배달해주세요', 1),
(7641, 7, '400116', '收货失败,请稍候再试', '상품을 받지 못했습니다. 나중에 다시 시도해 주세요', 1),
(7642, 7, '400117', '收货成功', '성공적으로 상품을 받았습니다', 1),
(7643, 7, '400118', '订单不存在', '주문이 존재하지 않습니다', 1),
(7644, 7, '400119', '用户信息不存在', '사용자 정보가 존재하지 않습니다', 1),
(7645, 7, '400120', '快递单号不存在', '특급추적번호가 존재하지 않습니다', 1),
(7646, 7, '400121', '打印成功', '인쇄 성공', 1),
(7647, 7, '400122', '打印失败', '인쇄 실패', 1),
(7648, 7, '400123', '快递公司编号缺失', '택배사 번호가 누락되었습니다', 1),
(7649, 7, '400124', '请配置腾讯地图KEY', '텐센트 맵 KEY를 설정해주세요', 1),
(7650, 7, '400125', '请选择门店位置', '매장 위치를 ​​선택하세요', 1),
(7651, 7, '400126', '添加的核销员用户已存在', '추가된 상각 회원 사용자가 이미 존재합니다', 1),
(7652, 7, '400127', '请选择所属提货点', '소속 픽업 지점을 선택하세요', 1),
(7653, 7, '400128', '请填写核销员名称', '제출회원의 이름을 입력해주세요', 1),
(7654, 7, '400129', '请填写核销员电话', '인증담당자 전화번호를 입력해주세요', 1),
(7655, 7, '400130', '核销员添加成功', '인증 멤버가 성공적으로 추가되었습니다', 1),
(7656, 7, '400131', '核销员添加失败', '상각 멤버 추가 실패', 1),
(7657, 7, '400132', '请填写手机号', '전화번호를 입력하세요', 1),
(7658, 7, '400133', '请填写账号', '계좌번호를 입력하세요', 1),
(7659, 7, '400134', '请填写密码', '비밀번호를 입력하세요', 1),
(7660, 7, '400135', '请填写短信签名', 'SMS 서명을 작성해주세요', 1),
(7661, 7, '400136', '短信签名最长为8位', '가장 긴 SMS 서명은 8자리입니다', 1),
(7662, 7, '400137', '请填写验证码', '인증번호를 입력하세요', 1),
(7663, 7, '400138', '请填写域名', '도메인 이름을 입력하세요', 1),
(7664, 7, '400139', '登录成功', '로그인 성공', 1),
(7665, 7, '400140', '账号或密码错误', '계정 또는 비밀번호 오류', 1),
(7666, 7, '400141', '请先填写短信配置', '먼저 SMS 설정을 채워주세요', 1),
(7667, 7, '400142', '请输入模板名称', '템플릿 이름을 입력하세요', 1),
(7668, 7, '400143', '请输入模板内容', '템플릿 내용을 입력하세요', 1),
(7669, 7, '400144', '售后订单状态不支持该操作', '판매 후 주문 상태는 이 작업을 지원하지 않습니다', 1),
(7670, 7, '400145', '修改退款状态成功', '환불 상태 수정 성공', 1),
(7671, 7, '400146', '请输入退款金额', '환불금액을 입력하세요', 1),
(7672, 7, '400147', '已退完支付金额，不能再退款了', '결제금액이 이미 환불되어 더 이상 환불 불가', 1),
(7673, 7, '400148', '退款金额大于支付金额，请修改退款金额', '환불금액이 결제금액보다 많습니다, 환불금액을 수정해주세요', 1),
(7674, 7, '400149', '退款成功', '환불 성공', 1),
(7675, 7, '400150', '退款失败', '환불 실패', 1),
(7676, 7, '400151', '验证成功', '인증 성공', 1),
(7677, 7, '400152', '核销成功', '상각 성공', 1),
(7678, 7, '400153', '核销订单未查到', '상각 주문을 찾을 수 없습니다', 1),
(7679, 7, '400154', '核销失败', '확인 실패', 1),
(7680, 7, '400155', '订单金额必须填写', '주문금액을 채워주셔야 합니다', 1),
(7681, 7, '400156', '请选择需要删除的订单', '삭제할 주문을 선택하세요', 1),
(7682, 7, '400157', '您选择的的订单存在用户未删除的订单', '선택한 주문에는 사용자가 삭제하지 않은 주문이 있습니다', 1),
(7683, 7, '400158', '请选择发货商品', '배송할 상품을 선택해주세요', 1),
(7684, 7, '400159', '请重新选择发货商品或发货件数', '배송상품 또는 배송할 개수를 다시 선택해주세요', 1),
(7685, 7, '400160', '订单已删除无法退积分', '주문이 삭제되어 포인트를 환불받을 수 없습니다', 1),
(7686, 7, '400161', '请输入积分', '포인트를 입력하세요', 1),
(7687, 7, '400162', '已退完积分', '포인트 환불 완료', 1),
(7688, 7, '400163', '退积分大于支付积分，请修改退积分', '환급된 포인트가 결제된 포인트보다 많으므로 환불된 포인트를 수정해주세요', 1),
(7689, 7, '400164', '退积分成功', '성공적으로 반환된 점수', 1),
(7690, 7, '400165', '退积分失败', '포인트 인출 실패', 1),
(7691, 7, '400166', '请填写开票号', '인보이스 번호를 입력하세요', 1),
(7692, 7, '400167', '请填写正确的开票号', '올바른 청구번호를 입력하세요', 1),
(7693, 7, '400168', '请上传文件', '파일을 업로드하세요', 1),
(7694, 7, '400169', '回复成功', '성공적인 응답', 1),
(7695, 7, '400170', '注册成功', '등록 성공', 1),
(7696, 7, '400171', '注册失败', '등록 실패', 1),
(7697, 7, '400172', '登录失败', '로그인 실패', 1),
(7698, 7, '400173', '获取套餐列表失败', '패키지 목록 가져오기 실패', 1),
(7699, 7, '400174', '获取支付码失败', '결제코드 획득 실패', 1),
(7700, 7, '400175', '请先开通短信服务', '먼저 SMS 서비스를 활성화하세요', 1),
(7701, 7, '400176', '请先开通物流查询服务', '물류조회 서비스를 먼저 열어주세요', 1),
(7702, 7, '400177', '请先开通电子面单打印服务', '전자얼굴 단일인쇄 서비스 먼저 활성화해주세요', 1),
(7703, 7, '400178', '请先开通商品采集服务', '상품 수거 서비스를 먼저 활성화해주세요', 1),
(7704, 7, '400179', '请设置短信签名', 'SMS 서명을 설정하세요', 1),
(7705, 7, '400180', '修改短信签名成功', 'SMS 서명 수정 성공', 1),
(7706, 7, '400181', '默认模板不能删除', '기본 템플릿은 삭제할 수 없습니다', 1),
(7707, 7, '400182', '管理员信息读取失败', '관리자 정보 읽기 실패', 1),
(7708, 7, '400183', '密码太过简单，请输入较为复杂的密码', '비밀번호가 너무 간단합니다. 더 복잡한 비밀번호를 입력하세요', 1),
(7709, 7, '400184', '协议类型不存在', '프로토콜 유형이 존재하지 않습니다', 1),
(7710, 7, '400185', '清除成功', '명확한 성공', 1),
(7711, 7, '400186', '清除失败', '지우기 실패', 1),
(7712, 7, '400187', '请输入名称', '이름을 입력하세요', 1),
(7713, 7, '400188', '请不要重复添加', '반복해서 추가하지 마세요', 1),
(7714, 7, '400189', '添加数据成功', '데이터 추가 성공', 1),
(7715, 7, '400190', '请输入开始时间', '시작 시간을 입력하세요', 1),
(7716, 7, '400191', '请输入持续时间', '시간을 입력하세요', 1),
(7717, 7, '400192', '请输入0-23点之前的整点数', '0-23시 이전의 정수를 입력하세요', 1),
(7718, 7, '400193', '请输入1-24点之前的整点数', '1시부터 24시까지의 정수를 입력하세요', 1),
(7719, 7, '400194', '开始时间+持续时间不能大于24小时', '시작 시간 + 지속 시간은 24시간을 초과할 수 없습니다', 1),
(7720, 7, '400195', '时段已占用', '시간 슬롯이 찼습니다', 1),
(7721, 7, '400196', '请输入签到赠送积分', '체크인 보너스 포인트를 입력하세요', 1),
(7722, 7, '400197', '请输入大于等于0的整数', '0 이상의 정수를 입력하세요', 1),
(7723, 7, '400198', '请填写按钮名称', '버튼 이름을 입력하세요', 1),
(7724, 7, '400199', '没有查到此身份', '아이덴티티를 찾을 수 없음', 1),
(7725, 7, '400200', '请输入等级名称', '레벨 이름을 입력하세요', 1),
(7726, 7, '400201', '请输入等级', '레벨을 입력하세요', 1),
(7727, 7, '400202', '请选择等级图标', '레벨 아이콘을 선택하세요', 1),
(7728, 7, '400203', '二级返佣比例不能大于一级', '2차 리베이트 비율은 1차 리베이트보다 클 수 없습니다', 1),
(7729, 7, '400204', '当前等级已存在', '현재 레벨이 이미 존재합니다', 1),
(7730, 7, '400205', '添加等级成功', '레벨 추가 성공', 1),
(7731, 7, '400206', '编辑的等级不存在', '편집 레벨이 존재하지 않습니다', 1),
(7732, 7, '400207', '请输入任务名称', '작업 이름을 입력하세요', 1),
(7733, 7, '400208', '请选择任务类型', '작업 유형을 선택하세요', 1),
(7734, 7, '400209', '请输入限定数量', '한정 수량을 입력하세요', 1),
(7735, 7, '400210', '添加任务成功', '작업 추가 성공', 1),
(7736, 7, '400211', '编辑的任务不存在', '편집된 작업이 존재하지 않습니다', 1),
(7737, 7, '400212', '获取推广二维码失败，请检查您的微信配置', '프로모션 QR코드를 받지 못했습니다. 위챗 설정을 확인해주세요', 1),
(7738, 7, '400213', '上级推广人不能为自己', '우수한 발기인은 자신이 될 수 없습니다', 1),
(7739, 7, '400214', '用户不存在', '사용자가 존재하지 않습니다', 1),
(7740, 7, '400215', '上级用户不存在', '상위 사용자가 없습니다', 1),
(7741, 7, '400216', '当前推广人已经是所选人', '현재 발기인은 이미 선택된 인물입니다', 1),
(7742, 7, '400217', '上级推广人不能为自己下级', '상급 발기인은 부하 직원이 될 수 없습니다', 1),
(7743, 7, '400218', '赠送成功', '선물 성공', 1),
(7744, 7, '400219', '赠送失败', '선물 실패', 1),
(7745, 7, '400220', '请输入身份名称', '아이덴티티 이름을 입력하세요', 1),
(7746, 7, '400221', '请选择最少一个权限', '최소한 하나의 권한을 선택하세요', 1),
(7747, 7, '400222', '添加身份成功', 'ID 추가 성공', 1),
(7748, 7, '400223', '添加身份失败', 'ID 추가 실패', 1),
(7749, 7, '400224', '缺少APPID', 'APPID 누락', 1),
(7750, 7, '400225', '请先设置空间域名', '스페이스 도메인 이름을 먼저 설정하세요', 1),
(7751, 7, '400226', '格式错误，请输入格式为：http://域名', '형식이 올바르지 않습니다. 형식을 http://도메인 이름으로 입력하십시오.', 1),
(7752, 7, '400227', '未有正在使用的存储空间', '사용중인 저장공간이 없습니다', 1),
(7753, 7, '400228', '切换云存储成功,请检查是否开启使用了存储空间', '클라우드 저장장치 전환 성공, 저장공간 활성화 여부를 확인해주세요', 1),
(7754, 7, '400229', '切换本地存储成功', '로컬 저장소 전환 성공', 1),
(7755, 7, '400230', '请输入模板编号', '템플릿 번호를 입력하세요', 1),
(7756, 7, '400231', '请输入模板编号已存在,请重新输入', '템플릿 번호를 입력하세요. 이미 존재합니다, 다시 입력하세요', 1),
(7757, 7, '400232', '请输入模板ID', '템플릿 ID를 입력하세요', 1),
(7758, 7, '400233', '请输入模板名', '템플릿 이름을 입력하세요', 1),
(7759, 7, '400234', '请输入回复内容', '답글 내용을 입력하세요', 1),
(7760, 7, '400235', '添加模板消息成功', '템플릿 메시지 추가 성공', 1),
(7761, 7, '400236', '请先配置小程序appid、appSecret等参数', '애플릿 appid, appSecret 및 기타 매개변수를 먼저 구성하십시오', 1),
(7762, 7, '400237', '二维码生成失败', 'QR코드 생성 실패', 1),
(7763, 7, '400238', '请添加至少一个按钮', '하나 이상의 버튼을 추가하세요', 1),
(7764, 7, '400239', '请输入关键字', '키워드를 입력하세요', 1),
(7765, 7, '400240', '请选择回复类型', '답장 유형을 선택하세요', 1),
(7766, 7, '400241', '回复类型有误', '응답 유형이 잘못되었습니다', 1),
(7767, 7, '400242', '回复消息参数有误', '응답 메시지 매개변수가 잘못되었습니다', 1),
(7768, 7, '400243', '请添加图文', '그래픽을 추가하세요', 1),
(7769, 7, '400244', '标题不能为空', '제목은 비워둘 수 없습니다', 1),
(7770, 7, '400245', '作者不能为空', '저자는 비워둘 수 없습니다', 1),
(7771, 7, '400246', '正文不能为空', '텍스트는 비워둘 수 없습니다', 1),
(7772, 7, '400247', '摘要不能为空', '요약은 비워둘 수 없습니다', 1),
(7773, 7, '400248', '请先配置微信公众号appid、appSecret等参数', 'WeChat 공개 계정 appid, appSecret 및 기타 매개변수를 먼저 구성하십시오', 1),
(7774, 7, '400249', '模版消息一键设置成功', '템플릿 메시지의 원클릭 설정 성공', 1),
(7775, 7, '400250', '请选择用户', '사용자를 선택하세요', 1),
(7776, 7, '400251', '该用户没有绑定手机号，请手动填写', '사용자는 휴대전화 번호에 묶여 있지 않습니다. 수동으로 입력하세요', 1),
(7777, 7, '400252', '手机号格式错误', '휴대전화 번호 형식 오류', 1),
(7778, 7, '400253', '客服已存在', '고객 서비스가 이미 존재합니다', 1),
(7779, 7, '400254', '请输入账号', '계좌번호를 입력하세요', 1),
(7780, 7, '400255', '账号必须为数字或者字母的组合4-30位', '계좌번호는 4~30자리 숫자 또는 문자 조합이어야 합니다', 1),
(7781, 7, '400256', '请输入密码', '비밀번호를 입력하세요', 1),
(7782, 7, '400257', '密码必须为数字或者字母的组合6-20位', '비밀번호는 6-20자리 숫자 또는 문자 조합이어야 합니다', 1),
(7783, 7, '400258', '该手机号的客服已存在', '이 전화번호에 대한 고객 서비스는 이미 존재합니다', 1),
(7784, 7, '400259', '该客服账号已存在', '고객 서비스 계정이 이미 존재합니다', 1),
(7785, 7, '400260', '客服添加成功', '고객 서비스 추가 성공', 1),
(7786, 7, '400261', '客服添加失败', '고객 서비스 추가 실패', 1),
(7787, 7, '400262', '客服名称不能为空', '고객 서비스 이름은 비워둘 수 없습니다', 1),
(7788, 7, '400263', '请输入确认密码', '확인 비밀번호를 입력하세요', 1),
(7789, 7, '400264', '两次输入的密码不一致', '두 번 입력한 비밀번호가 일치하지 않습니다', 1),
(7790, 7, '400265', '用户不存在，客服将强制禁止登录', '사용자가 존재하지 않습니다. 고객센터에서 강제로 로그인을 금지합니다', 1),
(7791, 7, '400266', '登录的客服不存在', '로그인한 고객센터가 존재하지 않습니다', 1),
(7792, 7, '400267', '请先填写客服账号和密码再尝试进入客服平台', '고객 서비스 플랫폼에 진입하기 전에 고객 서비스 계정과 비밀번호를 입력하세요', 1),
(7793, 7, '400268', '反馈内容不存在', '피드백 내용이 존재하지 않습니다', 1),
(7794, 7, '400269', '话术不能重复添加', '단어를 반복해서 추가할 수 없습니다', 1),
(7795, 7, '400270', '创建话术成功', '성공적인 단어 생성', 1),
(7796, 7, '400271', '创建话术失败', '대화 생성 실패', 1),
(7797, 7, '400272', '删除的话术不存在', '삭제된 단어가 존재하지 않습니다', 1),
(7798, 7, '400273', '系统分类不能删除', '시스템 분류를 삭제할 수 없습니다', 1),
(7799, 7, '400274', '请输入配置名称', '구성 이름을 입력하세요', 1),
(7800, 7, '400275', '请输入字段名称', '필드명을 입력하세요', 1),
(7801, 7, '400276', '请输入配置简介', '구성 프로필을 입력하십시오', 1),
(7802, 7, '400277', '请输入文本框的宽度', '텍스트 상자의 너비를 입력하세요', 1),
(7803, 7, '400278', '请输入正确的文本框的宽度', '텍스트 상자의 올바른 너비를 입력하십시오', 1),
(7804, 7, '400279', '请输入多行文本框的宽度', '여러 줄 텍스트 상자의 너비를 입력하세요', 1),
(7805, 7, '400280', '请输入多行文本框的高度', '여러 줄 텍스트 상자의 높이를 입력하세요', 1),
(7806, 7, '400281', '请输入正确的多行文本框的宽度', '여러 줄 텍스트 상자의 올바른 너비를 입력하세요', 1),
(7807, 7, '400282', '请输入正确的多行文本框的宽度', '여러 줄 텍스트 상자의 올바른 너비를 입력하십시오', 1),
(7808, 7, '400283', '请输入配置参数', '구성 매개변수를 입력하십시오', 1),
(7809, 7, '400284', '添加配置成功', '구성 추가 성공', 1),
(7810, 7, '400285', '一二级返佣比例不能大于100%', '1차 및 2차 리베이트 비율은 100%를 초과할 수 없습니다', 1),
(7811, 7, '400286', '分销海报不能多于5张', '배포 포스터는 5개를 넘을 수 없습니다', 1),
(7812, 7, '400287', '提现最低金额只能为数字', '최소 출금 금액은 숫자만 가능합니다', 1),
(7813, 7, '400288', '满额分销最低金额不能为空', '전체 배포를 위한 최소 금액은 비워둘 수 없습니다', 1),
(7814, 7, '400289', '满额分销最低金额不能小于0', '전체 분배의 최소 금액은 0보다 작을 수 없습니다', 1),
(7815, 7, '400290', '绑定有效期请填写正整数', '바인딩 유효 기간 동안 양의 정수를 입력하세요', 1),
(7816, 7, '400291', '请输入标题', '제목을 입력하세요', 1),
(7817, 7, '400292', '添加配置分类成功', '구성 범주 추가 성공', 1),
(7818, 7, '400293', '存在下级配置，无法删除', '하위 구성이 있어 삭제할 수 없습니다', 1),
(7819, 7, '400294', '字段至少存在一个', '최소한 하나의 필드가 존재합니다', 1),
(7820, 7, '400295', '添加数据组成功', '데이터 그룹 추가 성공', 1),
(7821, 7, '400296', '数据关键字已存在', '데이터 키워드가 이미 존재합니다', 1),
(7822, 7, '400297', '字段不能为空', '필드는 비워둘 수 없습니다', 1),
(7823, 7, '400298', '不能大于四个', '4개 이하', 1),
(7824, 7, '400299', '签到天数配置不能大于7天', '체크인 날짜 설정은 7일을 초과할 수 없습니다', 1),
(7825, 7, '400300', '关联成功', '성공적으로 연결됨', 1),
(7826, 7, '400301', '关联失败', '연결 실패', 1),
(7827, 7, '400302', '数据缓存刷新成功', '데이터 캐시 새로 고침 성공', 1),
(7828, 7, '400303', '数据缓存刷新失败', '데이터 캐시 새로 고침 실패', 1),
(7829, 7, '400304', '请输入需要更换的域名', '교체해야 할 도메인 이름을 입력하세요', 1),
(7830, 7, '400305', '域名不合法', '도메인 이름이 잘못되었습니다', 1),
(7831, 7, '400306', '替换成功', '교체 성공', 1),
(7832, 7, '400307', '初始化完成', '초기화 완료', 1),
(7833, 7, '400308', '备份文件可能已经损坏，请检查', '백업 파일이 손상되었을 수 있으니 확인해주세요', 1),
(7834, 7, '400309', '还原数据出错', '데이터 복원 오류', 1),
(7835, 7, '400310', '正在还原...', '복원 중...', 1),
(7836, 7, '400311', '还原完成', '복원 완료', 1),
(7837, 7, '400312', '权益编辑成功', '지분 편집 성공', 1),
(7838, 7, '400313', '卡片生成成功', '카드가 성공적으로 생성되었습니다', 1),
(7839, 7, '400314', '手机号已经存在', '이미 존재하는 전화번호', 1),
(7840, 7, '400315', '请输入正确的身份证', '올바른 아이디를 입력하세요', 1),
(7841, 7, '400316', '请选择分组', '그룹을 선택하세요', 1),
(7842, 7, '400317', '请选择标签', '레이블을 선택하세요', 1),
(7843, 7, '400318', '加入消息队列成功', '메시지 대기열에 성공적으로 참여', 1),
(7844, 7, '400319', '注销成功', '로그아웃 성공', 1),
(7845, 7, '400320', '拒绝注销', '로그아웃 거부', 1),
(7846, 7, '400321', '请输入分组名称', '그룹명을 입력하세요', 1),
(7847, 7, '400322', '会员标签不能为空', '멤버 레이블은 비워둘 수 없습니다', 1),
(7848, 7, '400323', '该分类下有标签，请先删除标签', '이 카테고리 아래에 레이블이 있습니다. 먼저 레이블을 삭제하십시오', 1),
(7849, 7, '400324', '请输入等级名称', '레벨 이름을 입력하세요', 1),
(7850, 7, '400325', '请输入等级', '레벨을 입력하세요', 1),
(7851, 7, '400326', '请输入等级说明', '레벨 설명을 입력하세요', 1),
(7852, 7, '400327', '请上传等级图标', '레벨 아이콘을 올려주세요', 1),
(7853, 7, '400328', '请上传等级背景图标', '레벨 배경 아이콘을 업로드하세요', 1),
(7854, 7, '400329', '请输入升级经验值', '업그레이드 경험치 값을 입력하세요', 1),
(7855, 7, '400330', '授权成功，写入数据库失败，请检查数据库链接配置', '인증에 성공했지만 데이터베이스에 쓰지 못했습니다. 데이터베이스 링크 구성을 확인하십시오', 1),
(7856, 7, '400331', '请填写公司名称', '회사명을 입력하세요', 1),
(7857, 7, '400332', '请填写授权域名', '인증된 도메인 이름을 입력하세요', 1),
(7858, 7, '400333', '请填写手机号码', '휴대전화 번호를 입력하세요', 1),
(7859, 7, '400334', '请填写订单id', '주문 ID를 입력하세요', 1),
(7860, 7, '400335', '申请授权成功', '승인 신청 성공', 1),
(7861, 7, '400336', '验证码错误', '인증 코드 오류', 1),
(7862, 7, '400337', '请选择商品', '상품을 선택해주세요', 1),
(7863, 7, '400338', '请输入商品名称', '상품명을 입력하세요', 1),
(7864, 7, '400339', '请选择背景图', '배경 이미지를 선택하세요', 1),
(7865, 7, '400340', '请输入直播价格', '생방송 가격을 입력하세요', 1),
(7866, 7, '400341', '直播价格必须大于0', '생방송 가격은 0보다 커야 합니다', 1),
(7867, 7, '400342', '请输入直播间名称', '생방송방 이름을 입력하세요', 1),
(7868, 7, '400343', '请选择背景图', '배경 이미지를 선택하세요', 1),
(7869, 7, '400344', '请选择分享图', '사진 공유를 선택해주세요', 1),
(7870, 7, '400345', '请选择主播', '앵커를 선택하세요', 1),
(7871, 7, '400346', '请选择直播开始、结束时间', '생방송 시작 시간과 종료 시간을 선택하세요', 1),
(7872, 7, '400347', '请填写活动简介', '이벤트 소개를 작성해주세요', 1),
(7873, 7, '400348', '请填写单位', '단위를 입력하세요', 1),
(7874, 7, '400349', '请选择商品轮播图', '상품 캐러셀을 선택하세요', 1),
(7875, 7, '400350', '您设置得商品个数超出系统限制', '설정한 상품의 개수가 시스템 제한을 초과합니다', 1),
(7876, 7, '400351', '模板不存在', '템플릿이 존재하지 않습니다', 1),
(7877, 7, '400352', '请输入页面名称', '페이지 이름을 입력하세요', 1),
(7878, 7, '400353', '请选择活动时间段', '활동 기간을 선택하세요', 1),
(7879, 7, '400354', '请填写购买数量限制', '구매 수량 제한을 채워주세요', 1),
(7880, 7, '400355', '购买数量限制必须大于0', '구매 수량 제한은 0보다 커야 합니다', 1),
(7881, 7, '400356', '请填写帮砍次数', '도움과 자르기 횟수를 입력하세요', 1),
(7882, 7, '400357', '帮砍次数必须大于0', '슬래시 수는 0보다 커야 합니다', 1),
(7883, 7, '400358', '请填写砍价人数', '교섭 인원수를 입력하세요', 1),
(7884, 7, '400359', '砍价人数必须大于1', '흥정하는 사람의 수는 1보다 커야 합니다', 1),
(7885, 7, '400360', '请选择运费模板', '배송 템플릿을 선택하세요', 1),
(7886, 7, '400361', '请填写商品详情', '상품 정보를 입력해주세요', 1),
(7887, 7, '400362', '请选择规格', '사양을 선택하세요', 1),
(7888, 7, '400363', '请填写虚拟拼团比例', '가상 그룹 비율을 입력하세요', 1),
(7889, 7, '400364', '虚拟参团人数不能大于成团人数', '가상 참가자의 수는 그룹의 참가자 수보다 클 수 없습니다', 1),
(7890, 7, '400365', '虚拟参团人数不能大于成团人数', '가상 참가자의 수는 그룹의 참가자 수보다 클 수 없습니다', 1),
(7891, 7, '400366', '请填写单次购买数量', '단품 구매 수량을 입력해주세요', 1),
(7892, 7, '400367', '单次购买数量必须大于0', '단일 구매 수량은 0보다 커야 합니다', 1),
(7893, 7, '400368', '请填写成团人数', '그룹 인원수를 입력해주세요', 1),
(7894, 7, '400369', '拼团人数不能小于2人', '그룹의 인원은 2명 이상이어야 합니다', 1),
(7895, 7, '400370', '请填写成团有效期', '그룹 유효기간을 입력해주세요', 1),
(7896, 7, '400371', '成团有效期必须大于0', '그룹의 유효 기간은 0보다 커야 합니다', 1),
(7897, 7, '400372', '请填写优惠券名称', '쿠폰명을 입력해주세요', 1),
(7898, 7, '400373', '请选择商品分类', '제품 카테고리를 선택하세요', 1),
(7899, 7, '400374', '请填写优惠券金额', '쿠폰 금액을 입력하세요', 1),
(7900, 7, '400375', '请填写优惠券最小使用金额', '쿠폰의 최소 사용금액을 입력해주세요', 1),
(7901, 7, '400376', '请填写优惠券有效期', '쿠폰 유효기간을 채워주세요', 1),
(7902, 7, '400377', '请选择秒杀时间段', '세킬 시간을 선택하세요', 1),
(7903, 7, '400378', '请填写门店名称', '상점명을 입력하세요', 1),
(7904, 7, '400379', '请填写门店简介', '상점 프로필을 작성해주세요', 1),
(7905, 7, '400380', '请填写门店电话', '매장 전화번호를 입력하세요', 1),
(7906, 7, '400381', '请选择提货点logo', '픽업 포인트 로고를 선택해주세요', 1),
(7907, 7, '400382', '请选择提货点大图', '픽업 지점의 큰 이미지를 선택하세요', 1),
(7908, 7, '400383', '请选择地址', '주소를 선택하세요', 1),
(7909, 7, '400384', '请填写详细地址', '자세한 주소를 입력하세요', 1),
(7910, 7, '400385', '请选择经纬度', '위도와 경도를 선택하세요', 1),
(7911, 7, '400386', '请选择营业时间', '영업시간을 선택하세요', 1),
(7912, 7, '400387', '短信账号必须填写', 'SMS 계정은 반드시 입력해야 합니다', 1),
(7913, 7, '400388', '短信密码必须填写', 'SMS 비밀번호는 반드시 입력해야 합니다', 1),
(7914, 7, '400389', '订单号必须存在', '주문 번호가 있어야 합니다', 1),
(7915, 7, '400390', '订单号有误', '주문번호가 틀립니다', 1),
(7916, 7, '400391', '订单号必须为字母和数字', '주문번호는 문자와 숫자여야 합니다', 1),
(7917, 7, '400392', '订单金额必须填写', '주문금액은 반드시 채워주셔야 합니다', 1),
(7918, 7, '400393', '订单金额必须为数字', '주문금액은 반드시 숫자여야 합니다', 1),
(7919, 7, '400394', '订单金额必须填写', '주문금액은 반드시 채워주셔야 합니다', 1),
(7920, 7, '400395', '订单金额必须为数字', '주문금액은 반드시 숫자여야 합니다', 1),
(7921, 7, '400396', '订单邮费必须填写', '주문 우송료는 반드시 기입하셔야 합니다', 1),
(7922, 7, '400397', '订单邮费必须为数字', '주문 우송료는 숫자여야 합니다', 1),
(7923, 7, '400398', '赠送积分必须为数字', '보너스 포인트는 숫자여야 합니다', 1),
(7924, 7, '400399', '请选择用户头像', '사용자 아바타를 선택하세요', 1),
(7925, 7, '400400', '请输入公司名称', '회사명을 입력하세요', 1),
(7926, 7, '400401', '添加公司成功', '회사 추가 성공', 1),
(7927, 7, '400402', '请输入月结账号', '월별 계좌번호를 입력하세요', 1),
(7928, 7, '400403', '请输入月结密码', '월간 비밀번호를 입력하세요', 1),
(7929, 7, '400404', '请输入取件网点', '픽업 장소를 입력하세요', 1),
(7930, 7, '400405', '缩略图大图尺寸（高）必须为数字', '썸네일 이미지의 크기(높이)는 반드시 숫자여야 합니다', 1),
(7931, 7, '400406', '缩略图大图尺寸（高）必须大于等于0', '썸네일 큰 이미지 크기(높이)는 0보다 크거나 같아야 합니다', 1),
(7932, 7, '400407', '缩略图大图尺寸（宽）必须为数字', '썸네일 이미지의 크기(너비)는 반드시 숫자여야 합니다', 1),
(7933, 7, '400408', '缩略图大图尺寸（宽）必须大于等于0', '썸네일 이미지의 크기(너비)는 0보다 크거나 같아야 합니다', 1),
(7934, 7, '400409', '缩略图中图尺寸（高）必须为数字', '썸네일 이미지의 크기(높이)는 반드시 숫자여야 합니다', 1),
(7935, 7, '400410', '缩略图中图尺寸（高）必须大于等于0', '썸네일 이미지의 크기(높이)는 0보다 크거나 같아야 합니다', 1),
(7936, 7, '400411', '缩略图中图尺寸（宽）必须为数字', '썸네일 이미지의 크기(너비)는 반드시 숫자여야 합니다', 1),
(7937, 7, '400412', '缩略图中图尺寸（宽）必须大于等于0', '썸네일 이미지의 크기(너비)는 0보다 크거나 같아야 합니다', 1),
(7938, 7, '400413', '缩略图小图尺寸（高）必须为数字', '썸네일 크기(높이)는 반드시 숫자여야 합니다', 1),
(7939, 7, '400414', '缩略图小图尺寸（高）必须大于等于0', '썸네일 크기(높이)는 0보다 크거나 같아야 합니다', 1),
(7940, 7, '400415', '缩略图小图尺寸（宽）必须为数字', '썸네일 크기(너비)는 반드시 숫자여야 합니다', 1),
(7941, 7, '400416', '缩略图小图尺寸（宽）必须大于等于0', '썸네일 크기(너비)는 0보다 크거나 같아야 합니다', 1),
(7942, 7, '400417', '水印文字只能是汉字、字母、数字', '워터마크 텍스트는 한자,문자,숫자만 가능합니다', 1),
(7943, 7, '400418', '水印文字长度为1-10位', '워터마크 텍스트의 길이는 1-10자리입니다', 1),
(7944, 7, '400419', '水印文字大小必须为数字', '워터마크 텍스트의 크기는 숫자여야 합니다', 1),
(7945, 7, '400420', '水印文字大小必须大于等于0', '워터마크 텍스트의 크기는 0보다 크거나 같아야 합니다', 1),
(7946, 7, '400421', '水印横坐标偏移量必须为数字', '워터마크 가로 좌표 오프셋은 숫자여야 합니다', 1),
(7947, 7, '400422', '水印横坐标偏移量必须大于等于0', '워터마크 가로 좌표 오프셋은 0보다 크거나 같아야 합니다', 1),
(7948, 7, '400423', '水印纵坐标偏移量必须为数字', '워터마크 세로 좌표 오프셋은 숫자여야 합니다', 1),
(7949, 7, '400424', '水印纵坐标偏移量必须大于等于0', '워터마크 세로좌표 오프셋은 0보다 크거나 같아야 합니다', 1),
(7950, 7, '400425', '该主播已经存在', '호스트가 이미 존재합니다', 1),
(7951, 7, '400426', '请先去小程序认证主播', '앵커를 인증하려면 애플릿으로 이동하세요', 1),
(7952, 7, '400427', '商品已创建', '아이템이 생성되었습니다', 1),
(7953, 7, '400428', '审核中或审核失败不允许此操作', '이 작업은 감사 또는 감사 실패 중에는 허용되지 않습니다.', 1),
(7954, 7, '400429', '在审核中或已经审核通过', '검토 중 또는 승인됨', 1),
(7955, 7, '400430', '审核通过或失败', '승인 통과 또는 실패', 1),
(7956, 7, '400431', '商品审核中，无法删除', '검토중이며 삭제할 수 없습니다', 1),
(7957, 7, '400432', '该主播不存在', '앵커가 존재하지 않습니다', 1),
(7958, 7, '400433', '开播时间需要在当前时间的10分钟后，并且开始时间不能在6个月后', '방송 시간은 현재 시간 이후 10분이어야 하며, 시작 시간은 6개월 이후일 수 없습니다', 1),
(7959, 7, '400434', '开播时间和结束时间间隔不得短于30分钟，不得超过24小时', '방송 시간과 종료 시간 사이의 간격은 30분 이상 24시간을 초과해서는 안 됩니다', 1),
(7960, 7, '400435', '请输入理由', '이유를 입력하세요', 1),
(7961, 7, '400436', '请选择正确的直播商品', '올바른 라이브 제품을 선택하세요', 1),
(7962, 7, '400437', '直播间状态有误', '라이브룸 상태가 틀립니다', 1),
(7963, 7, '400438', '奖品不存在', '상품이 존재하지 않습니다', 1),
(7964, 7, '400439', '写入中奖记录失败', '우승 기록 작성 실패', 1),
(7965, 7, '400440', '请继续参与活动抽奖', '추첨에 계속 참여해주세요', 1),
(7966, 7, '400441', '已经领取成功', '성공적으로 수신', 1),
(7967, 7, '400442', '分销等级不存在', '배포 레벨이 존재하지 않습니다', 1),
(7968, 7, '400443', '选择的等级不存在', '선택한 레벨이 존재하지 않습니다', 1),
(7969, 7, '400444', '该等级已存在此类型任务', '이 유형의 작업은 이미 이 수준에 있습니다', 1),
(7970, 7, '400445', '不能小于低等级同类型任务限定数量', '동일한 유형의 제한된 수의 하위 수준 작업보다 작을 수 없음', 1),
(7971, 7, '400446', '不能大于高等级同类型任务限定数量', '동일한 유형의 제한된 수의 고급 작업보다 클 수 없습니다.', 1),
(7972, 7, '400447', '解除失败', '제거 실패', 1),
(7973, 7, '400448', '代理商佣金比例不能大于事业部佣金比例', '에이전트 수수료 비율은 분할 수수료 비율보다 클 수 없습니다', 1),
(7974, 7, '400449', '代理商到期时间不能大于事业部到期时间', '에이전트의 만료 시간은 사업부의 만료 시간보다 클 수 없습니다', 1),
(7975, 7, '400450', '请填写用户UID', '사용자 UID를 입력하세요', 1),
(7976, 7, '400451', '管理员信息未查到', '관리자 정보를 찾을 수 없습니다', 1),
(7977, 7, '400452', '管理员已经删除', '관리자가 삭제되었습니다', 1),
(7978, 7, '400453', '管理员姓名不能为空', '관리자 이름은 비워둘 수 없습니다', 1),
(7979, 7, '400454', '该分类有下级分类，无法删除', '이 카테고리에는 하위 카테고리가 있으며 삭제할 수 없습니다', 1),
(7980, 7, '400455', '该分类下有文章，无法删除', '이 카테고리에 기사가 있으며 삭제할 수 없습니다', 1),
(7981, 7, '400456', '请稍后查看', '나중에 확인하세요', 1),
(7982, 7, '400457', '默认模板不能删除', '기본 템플릿은 삭제할 수 없습니다', 1),
(7983, 7, '400458', '该模板使用中，无法删除', '이 템플릿은 사용 중이며 삭제할 수 없습니다', 1),
(7984, 7, '400459', '个人中心模板不存在', '개인 센터 템플릿이 존재하지 않습니다', 1),
(7985, 7, '400460', '反馈内容没有查到', '피드백 내용을 찾을 수 없습니다', 1),
(7986, 7, '400461', '您修改的话术内容不存在', '수정한 단어의 내용이 존재하지 않습니다', 1),
(7987, 7, '400462', '短信平台：{:msg}', 'SMS 플랫폼: {:msg}', 1),
(7988, 7, '400463', '订单商品获取失败,无法打印', '주문 아이템 획득 실패, 인쇄 불가', 1),
(7989, 7, '400464', '小票打印未开启', '영수증 출력 불가', 1),
(7990, 7, '400465', '请先配置小票打印开发者', '영수증 출력 개발자를 먼저 설정해주세요', 1),
(7991, 7, '400466', '请选择图片', '사진을 선택하세요', 1),
(7992, 7, '400467', '配送员已存在', '배달원이 이미 존재합니다', 1),
(7993, 7, '400468', '同一个手机号的配送员只能添加一个', '동일한 휴대폰 번호로 1명의 배달원만 추가 가능', 1),
(7994, 7, '400469', '配送员名称不能为空', '배송인 이름은 비워둘 수 없습니다', 1),
(7995, 7, '400470', '订单未能查到,不能发货', '주문을 찾을 수 없으며 배송할 수 없습니다', 1),
(7996, 7, '400471', '订单已删除,不能发货', '주문이 삭제되어 배송할 수 없습니다', 1),
(7997, 7, '400472', '订单已发货请勿重复操作', '주문이 배송되었습니다. 작업을 반복하지 마십시오.', 1),
(7998, 7, '400473', '核销订单不能发货', '상각 주문은 배송할 수 없습니다', 1),
(7999, 7, '400474', '拼团未完成暂不能发货', '그룹화가 완료되지 않아 일시적으로 배송할 수 없습니다', 1),
(8000, 7, '400475', '订单有售后申请请先处理', '주문에 A/S 신청이 있으니 먼저 처리해 주세요', 1),
(8001, 7, '400476', '快递公司编缺失', '택배사 부재', 1),
(8002, 7, '400477', '请填写寄件人电话', '발신자 전화번호를 입력하세요', 1),
(8003, 7, '400478', '请填写寄件人地址', '보내는 사람의 주소를 입력하세요', 1),
(8004, 7, '400479', '虚拟发货，无需修改发货信息', '가상배송, 배송정보 수정 불필요', 1),
(8005, 7, '400480', '未发货，请先发货再修改配送信息', '배송 안됨, 먼저 배송 후 배송정보 수정해주세요', 1),
(8006, 7, '400481', '自提订单无法打印', '셀프 픽업 주문서를 출력할 수 없습니다', 1),
(8007, 7, '400482', '请先发货', '먼저 배송해주세요', 1),
(8008, 7, '400483', '请先在系统设置中打开单子面单打印开关', '시스템 설정에서 단면 단면 인쇄 스위치를 켜주세요', 1),
(8009, 7, '400484', '发票已申请，正在审核打印中', '인보이스가 신청되어 검토 및 인쇄 중', 1),
(8010, 7, '400485', '订单已退款', '주문이 환불되었습니다', 1),
(8011, 7, '400486', '正在申请退款中', '환불 신청', 1),
(8012, 7, '400487', '申请失败', '신청 실패', 1),
(8013, 7, '400488', '未支付无法退款', '미지급 및 환불 불가', 1),
(8014, 7, '400489', '回退积分和优惠券失败', '포인트 및 쿠폰 롤백 실패', 1),
(8015, 7, '400490', '拼团修改失败', '그룹 수정 실패', 1),
(8016, 7, '400491', '回退佣金失败', '수수료 롤백 실패', 1),
(8017, 7, '400492', '余额退款失败', '잔액 환불 실패', 1),
(8018, 7, '400493', '购买的优惠券已使用或者已过期', '구매한 쿠폰은 사용 또는 만료되었습니다', 1),
(8019, 7, '400494', '回退积分增加失败', '롤백 포인트 증가 실패', 1),
(8020, 7, '400495', '售后订单不存在', '판매 후 주문이 존재하지 않습니다', 1),
(8021, 7, '400496', '积分已退或者积分为零无法再退', '포인트가 환불되었거나 포인트가 0인 경우 환불 불가', 1),
(8022, 7, '400497', '未支付无法退积分', '결제하지 않으면 포인트 환불 불가', 1),
(8023, 7, '400498', '订单退积分失败', '주문에 대한 포인트 환불 실패', 1),
(8024, 7, '400499', '请输入拒绝退款理由', '환불 거부 사유를 입력하세요', 1),
(8025, 7, '400500', '限制单次购买数量不能大于总购买数量', '단일 구매 수량 제한은 총 구매 수량보다 클 수 없습니다', 1),
(8026, 7, '400501', '请添加抽奖活动名称', '추첨 이름을 추가해주세요', 1),
(8027, 7, '400502', '请添加抽奖描述等文案', '복권 및 기타 카피에 대한 설명을 추가해주세요', 1),
(8028, 7, '400503', '活动结束时间必须大于开始时间', '이벤트 종료 시간은 시작 시간보다 커야 합니다', 1),
(8029, 7, '400504', '请添加奖品', '상품을 추가해주세요', 1),
(8030, 7, '400505', '请填写消耗数量', '소모량을 채워주세요', 1),
(8031, 7, '400506', '商品参与其他活动开启，无法开启预售', '다른 활동에 대한 상품 참여가 가능하며, 사전 판매는 열 수 없습니다', 1),
(8032, 7, '400507', '活动结束时间不能小于当前时间', '이벤트 종료 시간은 현재 시간보다 작을 수 없습니다', 1),
(8033, 7, '400508', '活动已结束,请重新添加或复制', '이벤트가 종료되었습니다, 다시 추가 또는 복사해주세요', 1),
(8034, 7, '400509', '添加优惠券成功', '쿠폰 추가 성공', 1),
(8035, 7, '400510', '发布优惠劵成功', '쿠폰 발급 성공', 1),
(8036, 7, '400511', '砍价最低价不能大于或等于起始金额', '최저 흥정 가격은 시작 금액보다 크거나 같을 수 없습니다', 1),
(8037, 7, '400512', '砍价人数不能大于{:num}人', '흥정하는 사람의 수는 {:num}보다 클 수 없습니다', 1),
(8038, 7, '400513', '使用开始时间不能小于领取开始时间', '사용 시작 시간은 수집 시작 시간보다 작을 수 없습니다', 1),
(8039, 7, '400514', '使用结束时间不能小于领取结束时间', '사용 종료 시간은 수집 종료 시간보다 작을 수 없습니다', 1),
(8040, 7, '400515', '优惠券不存在', '쿠폰이 존재하지 않습니다', 1),
(8041, 7, '400516', '领取的优惠劵已领完或已过期', '받은 쿠폰이 수신되었거나 만료되었습니다', 1),
(8042, 7, '400517', '已领取过该优惠劵', '쿠폰을 받았습니다', 1),
(8043, 7, '400518', '抱歉，优惠券已经领取完了', '죄송합니다. 쿠폰이 모였습니다', 1),
(8044, 7, '400519', '选择用户已拥有该优惠券，请勿重复发放', '쿠폰을 이미 보유하고 있는 사용자를 선택하고, 중복 발행하지 말아주세요', 1),
(8045, 7, '400520', '订单已删除', '주문 삭제', 1),
(8046, 7, '400521', '订单已发货', '주문이 배송되었습니다', 1),
(8047, 7, '400522', '暂时不支持其他发货类型', '다른 배달 유형은 일시적으로 지원되지 않습니다', 1),
(8048, 7, '400523', '请输入送货人姓名', '배송사명을 입력해주세요', 1),
(8049, 7, '400524', '请输入送货人电话号码', '배달원 전화번호를 입력해주세요', 1),
(8050, 7, '400525', '请输入送货人信息', '배송인 정보를 입력해주세요', 1),
(8051, 7, '400526', '请输入正确的送货人电话号码', '정확한 배송사 전화번호를 입력해주세요', 1),
(8052, 7, '400527', '请选择电子面单模板', '전자 얼굴 전표 템플릿을 선택하세요', 1),
(8053, 7, '400528', '电子面单已关闭，请选择其他发货方式', '전자청구서 마감되었습니다. 다른 배송 방법을 선택하세요', 1),
(8054, 7, '400529', '发货失败', '배송 실패', 1),
(8055, 7, '400530', '订单状态错误', '주문 상태 오류', 1),
(8056, 7, '400531', '请输入快递单号', '택배번호를 입력하세요', 1),
(8057, 7, '400532', '请先发货再修改配送信息', '먼저 발송 후 배송정보 수정 부탁드립니다', 1),
(8058, 7, '400533', '商品不存在', '상품이 존재하지 않습니다', 1),
(8059, 7, '400534', '您查看的积分商品已被删除', '본 포인트 상품이 삭제되었습니다', 1),
(8060, 7, '400535', '请添加商品', '상품을 추가해주세요', 1),
(8061, 7, '400536', '添加抽奖活动失败', '추첨 이벤트 추가 실패', 1),
(8062, 7, '400537', '抽奖活动不存在', '복권은 존재하지 않습니다', 1),
(8063, 7, '400538', '请填写奖品名称', '상품명을 입력해주세요', 1),
(8064, 7, '400539', '请选择奖品图片', '상품 사진을 선택해주세요', 1),
(8065, 7, '400540', '请填写奖品中奖权重', '당첨 무게를 입력하세요', 1),
(8066, 7, '400541', '请选择奖品类型', '상품 종류를 선택하세요', 1),
(8067, 7, '400542', '请填写奖品赠送{:type}数', '제공된 경품의 {:type} 수를 입력하세요', 1),
(8068, 7, '400543', '请选择优惠券', '쿠폰을 선택하세요', 1),
(8069, 7, '400544', '生成新订单失败', '새 주문 생성 실패', 1),
(8070, 7, '400545', '修改原来订单商品拆分状态失败', '원래 주문 품목 분할 상태 수정 실패', 1),
(8071, 7, '400546', '新增拆分订单商品信息失败', '분할 주문 상품 정보 추가 실패', 1),
(8072, 7, '400547', '保存新订单商品信息失败', '신규 주문 상품 정보 저장 실패', 1),
(8073, 7, '400548', '协议类型缺失', '프로토콜 유형 누락', 1),
(8074, 7, '400549', '请填写协议名称', '계약명을 입력하세요', 1),
(8075, 7, '400550', '请填写协议内容', '계약서 내용을 작성해주세요', 1),
(8076, 7, '400551', '该类型协议已经存在', '이런 유형의 프로토콜이 이미 존재합니다', 1),
(8077, 7, '400552', '临时二维码获取错误', '일시적인 QR코드 획득 오류', 1),
(8078, 7, '400553', '永久二维码获取错误', '영구적 QR코드 획득 오류', 1),
(8079, 7, '400554', '请先配置接口密钥', '인터페이스 키를 먼저 구성하십시오', 1),
(8080, 7, '400555', '无法创建文件夹，请检查您的上传目录权限', '폴더를 생성할 수 없습니다. 업로드 디렉토리 권한을 확인하십시오', 1),
(8081, 7, '400556', '商品参数错误', '상품 매개변수 오류', 1),
(8082, 7, '400557', '上传方式错误', '업로드 방식이 잘못되었습니다', 1),
(8083, 7, '400558', '格式错误', '포맷 오류', 1),
(8084, 7, '400559', '图片流获取失败', '이미지 스트림 가져오기 실패', 1),
(8085, 7, '400560', '商品详情保存失败', '상품 정보 저장 실패', 1),
(8086, 7, '400561', '关联优惠券失败', '쿠폰 연결 실패', 1),
(8087, 7, '400562', '缺少商品ID', '제품 ID 누락', 1),
(8088, 7, '400563', '缺少用户UID', '사용자 UID 누락', 1),
(8089, 7, '400564', '缺少订单ID', '주문 ID 누락', 1),
(8090, 7, '400565', '暂不支持该类型记录', '이 유형의 레코드는 현재 지원되지 않습니다', 1),
(8091, 7, '400566', '添加商品记录失败', '제품 레코드 추가 실패', 1),
(8092, 7, '400567', '评论时间应小于当前时间', '댓글 시간은 현재 시간보다 짧아야 합니다', 1),
(8093, 7, '400568', '添加虚拟评论失败', '가상 댓글 추가 실패', 1),
(8094, 7, '400569', '回复失败', '답장 실패', 1),
(8095, 7, '400570', '请选择限购类型', '구매 제한 유형을 선택하세요', 1),
(8096, 7, '400571', '限购数量不能小于1', '구매 한도는 1보다 작을 수 없습니다', 1),
(8097, 7, '400572', '一二级返佣相加不能大于商品售价', '1단계 및 2단계 리베이트의 합은 제품 가격보다 클 수 없습니다.', 1),
(8098, 7, '400573', '商品类型不能切换', '제품 유형을 변경할 수 없습니다', 1),
(8099, 7, '400574', '请输入规则名称', '규칙 이름을 입력하세요', 1),
(8100, 7, '400575', '请输入属性名称', '속성 이름을 입력하세요', 1),
(8101, 7, '400576', '请输入正确的属性', '올바른 속성을 입력하세요', 1),
(8102, 7, '400577', '请填写正确的商品信息', '올바른 상품정보를 입력해주세요', 1),
(8103, 7, '400578', '请填写正确的商品价格', '제품 가격을 정확히 입력해주세요', 1),
(8104, 7, '400579', '请填写正确的商品库存', '올바른 상품 재고를 채워주세요', 1),
(8105, 7, '400580', '请填写正确的商品成本价格', '상품 원가를 정확히 입력해주세요', 1),
(8106, 7, '400581', '请上传商品图片', '상품 사진을 올려주세요', 1),
(8107, 7, '400582', '{:name}规格不存在', '{:name} 사양이 존재하지 않습니다', 1),
(8108, 7, '400583', '{:name}属性不存在', '{:name} 속성이 존재하지 않습니다', 1),
(8109, 7, '400584', '请设置至少一个属性', '적어도 하나의 속성을 설정하십시오', 1),
(8110, 7, '400585', '商品参与秒杀活动开启，无法进行此操作', '스파이크 활동에 대한 상품 참여가 활성화되었습니다. 이 작업을 수행할 수 없습니다.', 1),
(8111, 7, '400586', '商品参与砍价活动开启，无法进行此操作', '상품 교섭 참여가 가능하며, 이 작업은 수행할 수 없습니다', 1),
(8112, 7, '400587', '商品参与拼团活动开启，无法进行此操作', '그룹 활동에 상품 참여가 활성화되었습니다. 이 작업은 수행할 수 없습니다.', 1),
(8113, 7, '400588', '会员价格不能为0', '회원가는 0이 될 수 없습니다', 1),
(8114, 7, '400589', '虚拟优惠券商品请选择优惠券', '가상쿠폰 상품의 쿠폰을 선택해주세요', 1),
(8115, 7, '400590', '卡号：{:key}密码：{:value}，已经添加过，请重新添加卡密', '카드번호: {:key} 비밀번호: {:value} 추가되었으니 카드키를 다시 추가해주세요', 1),
(8116, 7, '400591', '缺少城市id无法保存', '도시 ID가 누락되어 저장할 수 없습니다', 1),
(8117, 7, '400592', '修改的模板不存在', '수정된 템플릿이 존재하지 않습니다', 1),
(8118, 7, '400593', '指定区域邮费添加失败', '지정된 지역에 우편요금 추가 실패', 1),
(8119, 7, '400594', '管理员不存在', '관리자가 존재하지 않습니다', 1),
(8120, 7, '400595', '您已被禁止登录', '로그인이 금지되었습니다', 1),
(8121, 7, '400596', '管理员账号已存在', '관리자 계정이 이미 존재합니다', 1),
(8122, 7, '400597', '原始密码错误', '원래 비밀번호 오류', 1),
(8123, 7, '400598', '请输入新密码', '새 비밀번호를 입력하세요', 1),
(8124, 7, '400599', '请选择要删除的图片', '삭제할 사진을 선택하세요', 1),
(8125, 7, '400600', '移动失败或不能重复移动到同一分类下', '이동에 실패했거나 같은 카테고리로 반복해서 이동할 수 없습니다', 1),
(8126, 7, '400601', '请求不被允许', '요청이 허용되지 않습니다', 1),
(8127, 7, '400602', '设置类目不被允许', '범주 설정이 허용되지 않습니다', 1),
(8128, 7, '400603', '请输入正确格式的配置参数', '구성 매개변수를 올바른 형식으로 입력하십시오', 1),
(8129, 7, '400604', '{:name}请输入默认值', '{:name}은(는) 기본값을 입력하십시오', 1),
(8130, 7, '400605', '{:name}请输入正确url', '{:name} 올바른 URL을 입력하세요', 1),
(8131, 7, '400606', '保存wss证书失败', 'wss 인증서 저장 실패', 1),
(8132, 7, '400607', '{:name}不能为空', '{:name}은(는) 비워둘 수 없습니다', 1),
(8133, 7, '400608', '删除的云存储不存在', '삭제된 클라우드 저장소가 존재하지 않습니다', 1),
(8134, 7, '400609', '云存储正在使用中,需要启动其他空间才能删除', '클라우드 저장소가 사용 중이며 다른 공간을 삭제하려면 활성화해야 합니다', 1),
(8135, 7, '400610', '云空间名称不能重复', '클라우드 공간 이름은 중복될 수 없습니다', 1),
(8136, 7, '400611', '没有权限', '권한 없음', 1),
(8137, 7, '400612', '替换失败,失败原因:{:msg}', '교체 실패, 실패 이유: {:msg}', 1),
(8138, 7, '400613', '请先删除改菜单下的子菜单', '먼저 메뉴 아래의 하위 메뉴를 삭제하세요', 1),
(8139, 7, '400614', '请填写批次名称', '배치명을 입력하세요', 1),
(8140, 7, '400615', '请填写要生成卡的数量', '생성할 카드의 수를 입력하세요', 1),
(8141, 7, '400616', '卡片数量只能为正整数', '카드의 수는 양의 정수만 가능합니다', 1),
(8142, 7, '400617', '单次制卡数量最高不得超过6000张', '한 번에 생산할 수 있는 최대 카드 수는 6000장을 초과할 수 없습니다', 1),
(8143, 7, '400618', '请填写免费使用天数', '무료이용일수를 입력해주세요', 1),
(8144, 7, '400619', '免费使用天数只能为正整数', '무료 사용 일수는 양의 정수만 가능합니다', 1),
(8145, 7, '400620', '生成卡失败', '카드 생성 실패', 1),
(8146, 7, '400621', '会员功能暂未开启', '멤버 함수는 아직 열리지 않았습니다', 1),
(8147, 7, '400622', '请输入会员卡号', '회원카드 번호를 입력하세요', 1),
(8148, 7, '400623', '请输入领取卡密', '카드 비밀번호를 입력하세요', 1),
(8149, 7, '400624', '会员卡不存在', '멤버십 카드가 존재하지 않습니다', 1),
(8150, 7, '400625', '会员卡未激活，暂无法使用', '멤버십 카드가 활성화되지 않아 일시적으로 사용할 수 없습니다', 1),
(8151, 7, '400626', '会员卡密码有误', '회원카드 비밀번호가 틀립니다', 1),
(8152, 7, '400627', '会员卡已使用', '멤버십 카드가 사용되었습니다', 1),
(8153, 7, '400628', '您已是永久会员，无需再领取，可以将此卡转送亲朋好友，一起享受优惠', '이미 정회원이세요, 더 이상 받을 필요가 없습니다. 이 카드를 친구, 친척에게 양도하여 함께 할인을 받을 수 있습니다', 1),
(8154, 7, '400629', '暂无此类型会员卡', '현재 이런 종류의 회원카드는 없습니다', 1),
(8155, 7, '400630', '会员权益类型缺失', '회원 혜택 유형이 누락되었습니다', 1),
(8156, 7, '400631', '请设置权益名称', '지분명을 설정하세요', 1),
(8157, 7, '400632', '请上传会员权益图标', '회원권한 아이콘을 올려주세요', 1),
(8158, 7, '400633', '请设置返还积分倍数', '반환 포인트를 배수로 설정하세요', 1),
(8159, 7, '400634', '返还积分倍数不能为负数', '반환점의 배수는 음수일 수 없습니다', 1),
(8160, 7, '400635', '请设置运费折扣', '배송비 할인을 설정해주세요', 1),
(8161, 7, '400636', '运费折扣不能为负数', '배송 할인은 음수일 수 없습니다', 1),
(8162, 7, '400637', '请设置签到积分倍数', '체크인 포인트를 배수로 설정해주세요', 1),
(8163, 7, '400638', '签到积分倍数不能为负数', '로그인 포인트 배수는 음수일 수 없습니다', 1),
(8164, 7, '400639', '请设置线下付款折扣', '오프라인 결제 할인을 설정해주세요', 1),
(8165, 7, '400640', '线下付款不能为负数', '오프라인 결제는 음수일 수 없습니다', 1),
(8166, 7, '400641', '请填写会员卡名称', '회원카드 이름을 입력해주세요', 1),
(8167, 7, '400642', '会员卡类型缺失', '멤버십 카드 유형 누락', 1),
(8168, 7, '400643', '请填写有效期（天）', '유효기간(일)을 기입해주세요', 1),
(8169, 7, '400644', '有效期（天）不能为负数', '유효기간(일)은 음수일 수 없습니다', 1),
(8170, 7, '400645', '请填写价格', '가격을 입력하세요', 1),
(8171, 7, '400646', '价格不能为负数', '가격은 음수일 수 없습니다', 1),
(8172, 7, '400647', '优惠价不能大于原价', '할인된 가격은 원래 가격보다 클 수 없습니다', 1),
(8173, 7, '400648', '地址不存在', '주소가 존재하지 않습니다', 1),
(8174, 7, '400649', '取消原来默认地址失败', '원래 기본 주소 취소 실패', 1),
(8175, 7, '400650', '设置默认地址失败', '기본 주소 설정 실패', 1),
(8176, 7, '400651', '地址已存在', '주소가 이미 존재합니다', 1),
(8177, 7, '400652', '收货地址格式错误', '배송지 형식이 틀립니다', 1),
(8178, 7, '400653', '请登录', '로그인하세요', 1),
(8179, 7, '400654', '登录已过期,请重新登录', '로그인이 만료되었습니다. 다시 로그인하십시오', 1),
(8180, 7, '400655', '增加记录失败', '레코드 추가 실패', 1),
(8181, 7, '400656', '记录分享记录失败', '기록 공유 기록 실패', 1),
(8182, 7, '400657', '增加用户佣金失败', '사용자 수수료 인상 실패', 1),
(8183, 7, '400658', '企业付款到零钱失败，请稍后再试', '회사에서 잔금을 지불하지 못했습니다. 나중에 다시 시도해주세요', 1),
(8184, 7, '400659', '已经提现', '이미 철회', 1),
(8185, 7, '400660', '您的提现申请已被拒绝', '귀하의 출금 요청이 거부되었습니다', 1),
(8186, 7, '400661', '可提现佣金不足', '현금 인출 수수료 부족', 1),
(8187, 7, '400662', '提现金额不能小于{:money}元', '출금 금액은 {:money} 위안보다 작을 수 없습니다.', 1),
(8188, 7, '400663', '提现佣金不足{:money}元', '출금 수수료가 {:money} 위안 부족합니다', 1),
(8189, 7, '400664', '提现佣金大于0', '출금 수수료가 0보다 큽니다', 1),
(8190, 7, '400665', '企业微信付款到零钱最低金额为1元', '기업 위챗 결제 최소금액 1위안', 1),
(8191, 7, '400666', '该分组已经存在', '그룹이 이미 존재합니다', 1),
(8192, 7, '400667', '清空用户标签失败', '사용자 레이블 지우기 실패', 1),
(8193, 7, '400668', '设置标签失败', '레이블 설정 실패', 1),
(8194, 7, '400669', '请选择标签分类', '라벨 분류를 선택하세요', 1),
(8195, 7, '400670', '该标签已经存在', '레이블이 이미 존재합니다', 1),
(8196, 7, '400671', '修改用户等级信息失败', '사용자 등급 정보 수정 실패', 1),
(8197, 7, '400672', '用户等级不存在', '사용자 등급이 존재하지 않습니다', 1),
(8198, 7, '400673', '用户等级经验必须大于上一等级设置的经验', '사용자 레벨 경험치는 이전 레벨에서 설정한 경험치보다 높아야 합니다', 1),
(8199, 7, '400674', '用户等级经验必须小于下一等级设置的经验', '사용자 레벨 경험치는 다음 레벨에서 설정한 경험치보다 낮아야 합니다', 1),
(8200, 7, '400675', '已检测到您设置过的用户等级，此等级不可重复', '설정한 사용자 레벨이 감지되었습니다. 이 레벨은 반복할 수 없습니다', 1),
(8201, 7, '400676', '已检测到您设置过该用户等级经验值，经验值不可重复', '이 사용자 레벨의 경험치를 설정한 것으로 감지되었습니다. 경험치는 반복할 수 없습니다', 1),
(8202, 7, '400677', '订单未支付', '결제되지 않은 주문', 1),
(8203, 7, '400678', '佣金转入余额，不能退款', '수수료는 잔액으로 이체되어 환불 불가', 1),
(8204, 7, '400679', '已支付的订单记录无法删除', '결제된 주문내역은 삭제할 수 없습니다', 1),
(8205, 7, '400680', '转入金额不能大于可提现佣金', '이체 금액은 인출 가능한 수수료보다 클 수 없습니다', 1),
(8206, 7, '400681', '写入余额充值失败', '잔액 충전 실패', 1),
(8207, 7, '400682', '您选择的充值方式已下架', '선택하신 충전 방법이 삭제되었습니다', 1),
(8208, 7, '400683', '充值订单生成失败', '충전 주문 생성 실패', 1),
(8209, 7, '400684', '保存用户信息失败', '사용자 정보 저장 실패', 1),
(8210, 7, '400685', '密码重置失败', '비밀번호 재설정 실패', 1),
(8211, 7, '400686', '增加推广人数失败', '승진 횟수 증가 실패', 1),
(8212, 7, '400687', '设置登录类型失败', '로그인 유형 설정 실패', 1),
(8213, 7, '400688', '设置推广员失败', '프로모터 설정 실패', 1),
(8214, 7, '400689', '增加用户余额失败', '사용자 잔고 증가 실패', 1),
(8215, 7, '400690', '减少用户余额失败', '사용자 잔고 감소 실패', 1),
(8216, 7, '400691', '减少用户佣金失败', '사용자 수수료 절감 실패', 1),
(8217, 7, '400692', '增加用户积分失败', '사용자 포인트 증가 실패', 1),
(8218, 7, '400693', '减少用户积分失败', '사용자 포인트 감소 실패', 1),
(8219, 7, '400694', '增加用户经验失败', '사용자 경험 향상 실패', 1),
(8220, 7, '400695', '减少用户经验失败', '사용자 경험 감소 실패', 1),
(8221, 7, '400696', '该分组不存在', '그룹이 존재하지 않습니다', 1),
(8222, 7, '400697', '设置分组失败或无改动', '그룹화 설정 실패 또는 변경 없음', 1),
(8223, 7, '400698', '有标签不存在或被删除', '레이블이 존재하지 않거나 삭제되었습니다', 1),
(8224, 7, '400699', '等级不存在或被删除', '클래스가 존재하지 않거나 삭제되었습니다', 1),
(8225, 7, '400700', '此用户已有该用户等级，无法再次赠送', '이 사용자는 이미 이 사용자 등급을 가지고 있어 다시 줄 수 없습니다', 1),
(8226, 7, '400701', '赠送天数不能为0', '선물 날짜는 0일 수 없습니다', 1),
(8227, 7, '400702', '天数输入错误', '일수가 잘못 입력되었습니다', 1),
(8228, 7, '400703', '用户信息储存失败', '사용자 정보 저장 실패', 1),
(8229, 7, '400704', '您得ip不再白名单中,请前往腾讯微信公众平台添加ip白名单', '귀하의 IP는 더 이상 허용 목록에 없습니다. Tencent WeChat 공개 플랫폼으로 이동하여 해당 IP를 허용 목록에 추가하세요', 1),
(8230, 7, '400705', '您填写得appid无效,请检查', '입력하신 신청서가 유효하지 않습니다. 확인해주세요', 1),
(8231, 7, '400706', '请输入回复信息内容', '답장 메시지의 내용을 입력하세요', 1),
(8232, 7, '400707', '请上传回复的图片', '답글 사진을 올려주세요', 1),
(8233, 7, '400708', '请上传回复的声音', '답장 음성을 올려주세요', 1),
(8234, 7, '400709', '请选择图文消息', '문자 메시지를 선택하세요', 1),
(8235, 7, '400710', '对应的uid不存在', '해당 uid가 존재하지 않습니다', 1),
(8236, 7, '400711', '取消关注失败', '팔로우 해제 실패', 1),
(8237, 7, '400712', '电子面单模板ID缺失', '전자 얼굴 전표 템플릿의 ID가 누락되었습니다', 1),
(8238, 7, '400713', '快递公司编码缺失', '택배사 코드가 누락되었습니다', 1),
(8239, 7, '400714', '寄件人信息缺失', '발신자 정보가 없습니다', 1),
(8240, 7, '400715', '收件人信息缺失', '수신인 정보가 누락되었습니다', 1),
(8241, 7, '400716', '云打印机编号缺失', '클라우드 프린터 번호가 없습니다', 1),
(8242, 7, '400717', '商品数量缺失', '항목 수량이 누락되었습니다', 1),
(8243, 7, '400718', '获取access_token获取失败', 'access_token 획득 실패', 1),
(8244, 7, '400719', '手机号不能为空', '휴대전화 번호는 비워둘 수 없습니다', 1),
(8245, 7, '400720', '模版ID不存在', '템플릿 ID가 존재하지 않습니다', 1),
(8246, 7, '400721', '请先配置accessKey和secretKey', 'accessKey와 secretKey를 먼저 설정하세요', 1),
(8247, 7, '400722', '请先配置水印图片', '워터마크 이미지를 먼저 설정하세요', 1),
(8248, 7, '400723', '请先配置水印文字', '워터마크 텍스트를 먼저 설정하세요', 1),
(8249, 7, '400724', '远程水印图片下载失败', '원격 워터마크 이미지 다운로드 실패', 1),
(8250, 7, '400725', '上传图片不存在', '업로드한 이미지가 존재하지 않습니다', 1),
(8251, 7, '400726', '图片流获取失败', '이미지 스트림 가져오기 실패', 1),
(8252, 7, '400727', '图片下载失败', '사진 다운로드 실패', 1),
(8253, 7, '400728', '必须上传xlsx格式文件', 'xlsx 형식 파일을 업로드해야 함', 1),
(8254, 7, '400729', '数据不能为空', '데이터는 비워둘 수 없습니다', 1),
(8255, 7, '400730', '缺少pay_price', 'pay_price 누락', 1),
(8256, 7, '400731', '退款失败:{:msg}', '환불 실패: {:msg}', 1),
(8257, 7, '400732', '获取微信粉丝信息失败', '위챗 팬 정보 가져오기 실패', 1),
(8258, 7, '400733', '您已关闭上传功能', '업로드 기능을 껐습니다', 1),
(8259, 7, '400734', '文件不可写', '파일을 쓸 수 없습니다', 1),
(8260, 7, '400735', '时间格式不正确', '시간 형식이 잘못되었습니다', 1),
(8261, 7, '400736', '文件可能损坏，请检查', '파일이 손상되었을 수 있으니 확인해주세요', 1),
(8262, 7, '400737', '修复错误，请重试', '오류를 수정하고 다시 시도하십시오', 1),
(8263, 7, '400738', '请指定要修复的表', '수리할 테이블을 지정하십시오', 1),
(8264, 7, '400739', '请配置支付证书', '결제 증명서를 설정해주세요', 1),
(8265, 7, '400740', '只支持两级分类', '2단계 분류만 지원', 1),
(8266, 7, '400741', '运费格式错误', '화물 형식 오류', 1),
(8267, 7, '400742', '请检查属性编码或库存数量', '속성 코드 또는 재고 수량을 확인하십시오', 1),
(8268, 7, '400743', '同步条数不能超过100', '동기화 막대의 수는 100을 초과할 수 없습니다', 1),
(8269, 7, '400744', 'appid或appsecret错误', 'appid 또는 appsecret 오류', 1),
(8270, 7, '400745', '父级ID参数类型错误', '상위 ID 매개변수 유형이 잘못되었습니다', 1),
(8271, 7, '400746', '分类名称长度不能超过25个字符', '카테고리 이름의 길이는 25자를 초과할 수 없습니다', 1),
(8272, 7, '400747', '分类图标长度不能超过128个字符', '카테고리 아이콘의 길이는 128자를 초과할 수 없습니다', 1),
(8273, 7, '400748', '分类大图长度不能超过200个字符', '큰 분류 이미지의 길이는 200자를 초과할 수 없습니다', 1),
(8274, 7, '400749', '排序参数类型错误', '정렬 매개변수 유형이 잘못되었습니다', 1),
(8275, 7, '400750', '排序不能小于0', '정렬은 0보다 작을 수 없습니다', 1),
(8276, 7, '400751', '状态必须是0-1之间的整数', '상태는 0-1 사이의 정수여야 합니다', 1),
(8277, 7, '400752', '权益简介不能大于8个字', '권익 소개는 8자 이내', 1),
(8278, 7, '400753', '提现方式最少选一种', '적어도 하나의 출금 방법을 선택하세요', 1),
(8279, 7, '400754', '身份使用中，无法删除', '아이덴티티는 사용 중이며 삭제할 수 없습니다', 1),
(8280, 7, '400755', '展示名称不能大于6个字', '표시 이름은 6자를 초과할 수 없습니다', 1),
(8281, 7, '400756', '推广佣金单价不能小于0', '프로모션 수수료의 단가는 0보다 작을 수 없습니다', 1),
(8282, 7, '400757', '每日推广佣金上限不能小于-1', '일일 프로모션 수수료 한도는 -1보다 작을 수 없습니다', 1),
(8283, 7, '400758', '请核对领取方式', '수집 방법을 확인하세요', 1),
(8284, 7, '400759', '请输入优惠券名称', '쿠폰명을 입력하세요', 1),
(8285, 7, '400760', '请输入真实姓名', '실명을 입력하세요', 1),
(8286, 7, '400761', '描述内容不能超过120字', '설명 내용은 120자를 초과할 수 없습니다', 1),
(8287, 7, '400762', '账号密码必须是在6到32位之间', '계정 비밀번호는 6자리에서 32자리 사이여야 합니다', 1),
(8288, 7, '400763', '商户号不能为空', '판매자 번호는 비워둘 수 없습니다', 1),
(8289, 7, '410000', '请输入账号和密码', '계좌번호와 비밀번호를 입력하세요', 1),
(8290, 7, '410001', '登录成功', '로그인 성공', 1),
(8291, 7, '410002', '退出成功', '성공적으로 종료', 1),
(8292, 7, '410003', '发送验证码失败,请刷新页面重新获取', '인증코드 전송에 실패했습니다. 페이지를 새로고침하여 다시 받으십시오', 1),
(8293, 7, '410004', '请输入验证码', '인증번호를 입력하세요', 1),
(8294, 7, '410005', '验证码输入有误', '인증번호가 잘못 입력되었습니다', 1),
(8295, 7, '410006', '验证码已发送', '인증 코드가 전송되었습니다', 1),
(8296, 7, '410007', '验证码发送成功', '인증 코드가 성공적으로 전송되었습니다', 1),
(8297, 7, '410008', '验证码发送失败', '인증코드 전송 실패', 1),
(8298, 7, '410009', '请先获取验证码', '인증번호를 먼저 받아주세요', 1),
(8299, 7, '410010', '验证码错误', '인증 코드 오류', 1),
(8300, 7, '410011', '密码必须是在6到16位之间', '비밀번호는 6자리에서 16자리 사이여야 합니다', 1),
(8301, 7, '410012', '密码太过简单，请输入较为复杂的密码', '비밀번호가 너무 간단합니다, 더 복잡한 비밀번호를 입력하세요', 1),
(8302, 7, '410013', '注册成功', '등록 성공', 1),
(8303, 7, '410014', '注册失败', '등록 실패', 1),
(8304, 7, '410015', '请输入手机号', '전화번호를 입력하세요', 1),
(8305, 7, '410016', '绑定成功', '바인딩 성공', 1),
(8306, 7, '410017', '绑定失败', '바인딩 실패', 1),
(8307, 7, '410018', '手机号格式不正确', '전화번호 형식이 올바르지 않습니다', 1),
(8308, 7, '410019', '登录失败', '로그인 실패', 1),
(8309, 7, '410020', '扫码失败请重新扫描', '코드 스캔 실패, 다시 스캔하십시오', 1),
(8310, 7, '410021', '二维码已过期请重新扫描', 'QR 코드가 만료되었습니다. 다시 스캔하세요', 1),
(8311, 7, '410022', '授权成功，请绑定手机号', '인증 성공, 휴대폰 번호를 묶어주세요', 1),
(8312, 7, '410023', '授权成功', '인증 성공', 1),
(8313, 7, '410024', '请先关注公众号', '공식계정 먼저 주목해주세요', 1),
(8314, 7, '410025', '账号或密码错误', '계정 또는 비밀번호 오류', 1),
(8315, 7, '410026', '请修改您的初始密码，再尝试登录', '초기 비밀번호를 수정하고 다시 로그인해 주세요', 1),
(8316, 7, '410027', '您已被禁止登录，请联系管理员', '로그인이 금지되었습니다. 관리자에게 문의하세요', 1),
(8317, 7, '410028', '手机号已注册', '전화번호가 등록되었습니다', 1),
(8318, 7, '410029', '您今日发送得短信次数已经达到上限', '오늘 보낸 문자가 상한선에 도달했습니다', 1),
(8319, 7, '410030', '此IP今日发送次数已经达到上限', '오늘 이 IP가 전송된 횟수가 상한선에 도달했습니다', 1),
(8320, 7, '410031', '短信平台验证码发送失败', 'SMS 플랫폼 인증 코드 전송 실패', 1),
(8321, 7, '410032', '用户不存在', '사용자가 존재하지 않습니다', 1),
(8322, 7, '410033', '修改密码失败', '비밀번호 변경 실패', 1),
(8323, 7, '410034', '用户登录失败,无法生成新用户,请稍后再试', '사용자 로그인에 실패했습니다. 새 사용자를 생성할 수 없습니다. 나중에 다시 시도하십시오', 1),
(8324, 7, '410035', '用户不存在,无法切换', '사용자가 존재하지 않아 전환할 수 없습니다', 1),
(8325, 7, '410036', '修改新用户登录类型出错', '새 사용자 로그인 유형 수정 오류', 1),
(8326, 7, '410037', '请刷新页面或者重新授权', '페이지를 새로고침하거나 재인증하세요', 1),
(8327, 7, '410038', '获取用户访问token失败', '사용자 액세스 토큰 획득 실패', 1),
(8328, 7, '410039', '此手机已经绑定，无法多次绑定', '이 전화는 연결되어 있으므로 여러 번 연결할 수 없습니다', 1),
(8329, 7, '410040', '您的账号已经绑定过手机号码', '귀하의 계정은 휴대폰 번호와 연결되어 있습니다', 1),
(8330, 7, '410041', 'H5已有账号是否绑定此账号上', 'H5의 기존 계정이 이 계정에 바인딩되어 있는지', 1),
(8331, 7, '410042', '新手机号和原手机号相同，无需修改', '새 전화번호는 원래 전화번호와 동일하므로 수정할 필요가 없습니다', 1),
(8332, 7, '410043', '此手机已经注册', '이 전화는 등록되었습니다', 1),
(8333, 7, '410044', '用户信息获取失败', '사용자 정보 획득 실패', 1),
(8334, 7, '410045', '请选择收货地址', '배송지 주소를 선택해주세요', 1),
(8335, 7, '410046', '地址选择有误', '주소 선택이 잘못되었습니다', 1),
(8336, 7, '410047', '可用积分不足', '사용 가능한 크레딧이 부족합니다', 1),
(8337, 7, '410048', '奖品不存在', '상품이 존재하지 않습니다', 1),
(8338, 7, '410049', '写入中奖记录失败', '우승 기록 작성 실패', 1),
(8339, 7, '410050', '请继续参与活动抽奖', '추첨에 계속 참여해주세요', 1),
(8340, 7, '410051', '已经领取成功', '성공적으로 수신', 1),
(8341, 7, '410052', '请输入收货人信息', '수취인 정보를 입력하세요', 1),
(8342, 7, '410053', '请输入正确的收货人电话', '수하인의 정확한 전화번호를 입력하세요', 1),
(8343, 7, '410054', '抽奖记录不存在', '복권 기록이 존재하지 않습니다', 1),
(8344, 7, '410055', '该奖品不需要发货', '이 상품은 배송할 필요가 없습니다', 1),
(8345, 7, '410056', '请选择快递公司或输入快递单号', '택배 회사를 선택하거나 택배 번호를 입력하세요', 1),
(8346, 7, '410057', '活动不存在或已删除', '활동이 존재하지 않거나 삭제되었습니다', 1),
(8347, 7, '410058', '暂未有该类型活动', '아직 이 유형의 활동이 없습니다', 1),
(8348, 7, '410059', '您暂时无法参与该活动', '이 활동에 일시적으로 참여할 수 없습니다', 1),
(8349, 7, '410060', '活动状态有误，请联系管理员', '활동 상태가 잘못되었습니다. 관리자에게 문의하세요', 1),
(8350, 7, '410061', '可用积分不足，没有更多抽奖次数', '사용 가능한 점수가 충분하지 않아 더 이상 무승부가 없습니다', 1),
(8351, 7, '410062', '余额不足，没有更多抽奖次数', '잔액 부족, 무승부', 1),
(8352, 7, '410063', '购买商品之后获得更多抽奖次数', '상품 구매 후 더 많은 복권 받기', 1),
(8353, 7, '410064', '订单完成评价之后获得更多抽奖次数', '주문이 평가된 후 더 많은 경품 추첨을 받게 됩니다', 1),
(8354, 7, '410065', '邀请更多好友获取抽奖次数', '더 많은 친구를 초대하여 행운의 추첨 횟수', 1),
(8355, 7, '410066', '抽奖扣除用户积分失败', '복권 추첨에서 사용자 포인트 차감 실패', 1),
(8356, 7, '410067', '抽奖失败，余额不足', '복권 추첨 실패, 잔액 부족', 1),
(8357, 7, '410068', '抽奖扣除用户余额失败', '복권 추첨에서 사용자 잔액 공제 실패', 1),
(8358, 7, '410069', '抽奖扣除用户推广获取抽奖次数失败', '추첨은 사용자가 복권을 얻기 위해 승격한 횟수를 공제하지 못했습니다', 1),
(8359, 7, '410070', '抽奖减少奖品总数失败', '총 경품 수를 줄이기 위한 추첨 실패', 1),
(8360, 7, '410071', '分销等级不存在', '배포 레벨이 존재하지 않습니다', 1),
(8361, 7, '410072', '永久二维码获取错误', '영구적 QR코드 획득 오류', 1),
(8362, 7, '410073', '邀请码无效', '초대 코드가 잘못되었습니다', 1),
(8363, 7, '410074', '授权失败,参数有误', '인증 실패, 매개변수가 잘못되었습니다', 1),
(8364, 7, '410075', 'openid获取失败', 'openid 가져오기 실패', 1),
(8365, 7, '410076', '获取session_key失败，请检查您的配置', 'session_key를 가져오지 못했습니다. 구성을 확인하십시오', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(8366, 7, '410077', '获取会话密匙失败', '세션 키 가져오기 실패', 1),
(8367, 7, '410078', '静默授权失败', '자동 인증 실패', 1),
(8368, 7, '410079', '获取用户信息失败', '사용자 정보 획득 실패', 1),
(8369, 7, '410080', '更新信息失败', '정보 업데이트 실패', 1),
(8370, 7, '410081', '请上传二维码', 'QR코드를 올려주세요', 1),
(8371, 7, '410082', '请关注公众号', '공개번호 주의하세요', 1),
(8372, 7, '410083', '新增用户失败', '사용자 추가 실패', 1),
(8373, 7, '410084', '用户关注失败', '사용자 팔로우 실패', 1),
(8374, 7, '410085', '获取token失败{:msg}', '{:msg} 토큰 가져오기 실패', 1),
(8375, 7, '410086', '配置已更改或token已失效', '구성이 변경되었거나 토큰이 만료되었습니다', 1),
(8376, 7, '410087', '平台错误：发生异常，请稍后重试', '플랫폼 오류: 예외가 발생했습니다. 나중에 다시 시도하십시오', 1),
(8377, 7, '410088', '企业微信支付到零钱需要支付证书，检测到您没有上传', '기업 WeChat 결제를 변경하려면 결제 증명서가 필요하며 업로드하지 않은 것으로 감지되었습니다', 1),
(8378, 7, '410089', '发起企业支付到零钱失败', '개시 기업이 변경금을 지불하지 못했습니다', 1),
(8379, 7, '410090', '无效的token不能查找到用户聊天记录', '유효하지 않은 토큰은 사용자 채팅 기록을 찾을 수 없습니다', 1),
(8380, 7, '410091', '图片上传成功', '이미지 업로드 성공', 1),
(8381, 7, '410092', '用户uid不再当前聊天用户范围内', '사용자 uid는 더 이상 현재 채팅 사용자의 범위 내에 있지 않습니다', 1),
(8382, 7, '410093', '请输入订单价格', '주문 가격을 입력하세요', 1),
(8383, 7, '410094', '请去后台售后订单列表处理', '백그라운드 애프터 리스트 처리로 가세요', 1),
(8384, 7, '410095', '分类名称不能为空', '카테고리 이름은 비워둘 수 없습니다', 1),
(8385, 7, '410096', '分类不存在', '분류가 존재하지 않습니다', 1),
(8386, 7, '410097', '添加的内容重复', '추가된 내용이 반복됩니다', 1),
(8387, 7, '410098', '缺少转接人id', '전송자 ID 누락', 1),
(8388, 7, '410099', '转接成功', '전송 성공', 1),
(8389, 7, '410100', '话术没有被查到', '음성을 찾을 수 없음', 1),
(8390, 7, '410101', '公共话术不能修改', '공개 언어는 수정할 수 없습니다', 1),
(8391, 7, '410102', '话术标题内容不能为空', '주제 제목의 내용은 비워둘 수 없습니다', 1),
(8392, 7, '410103', '已拥有此分组', '이 그룹을 이미 소유하고 있습니다', 1),
(8393, 7, '410104', '缺少标签id', '태그 ID 누락', 1),
(8394, 7, '410105', '请填汉字字母或者数字', '한자나 숫자를 입력하세요', 1),
(8395, 7, '410106', '标题长度不能超过50个字', '제목 길이는 50자를 초과할 수 없습니다', 1),
(8396, 7, '410107', '请选择分类', '카테고리를 선택하세요', 1),
(8397, 7, '410108', '分类必须为数字', '분류는 숫자여야 합니다', 1),
(8398, 7, '410109', '请填写话术内容', '언어의 내용을 입력하세요', 1),
(8399, 7, '410110', '话术长度不能超过500个字', '발언의 길이는 500단어를 초과할 수 없습니다', 1),
(8400, 7, '410111', '排序必须为数字', '정렬은 숫자여야 합니다', 1),
(8401, 7, '410112', '微信最低提现金额不能小于1元', '위챗 최소 출금금액은 1위안 미만일 수 없습니다', 1),
(8402, 7, '410113', '用户不存在', '사용자가 존재하지 않습니다', 1),
(8403, 7, '410114', '提现方式不存在', '출금 방식이 존재하지 않습니다', 1),
(8404, 7, '410115', '提现金额输入有误', '출금금액이 잘못 입력되었습니다', 1),
(8405, 7, '410116', '银行卡号输入有误', '은행 카드 번호가 잘못 입력되었습니다', 1),
(8406, 7, '410117', '请输入支付宝账号', '알리페이 계좌번호를 입력하세요', 1),
(8407, 7, '410118', '请输入银行卡账号', '은행 카드 계좌번호를 입력하세요', 1),
(8408, 7, '410119', '请输入开户行信息', '은행 정보를 입력하세요', 1),
(8409, 7, '410120', '申请提现成功', '출금 신청 성공', 1),
(8410, 7, '410121', '申请提现失败', '출금 신청 실패', 1),
(8411, 7, '410122', '充值金额不能为0元', '충전 금액은 0위안이 될 수 없습니다', 1),
(8412, 7, '410123', '充值方式不支持', '충전 방식은 지원하지 않습니다', 1),
(8413, 7, '410124', '充值金额不能低于{:money}', '충전 금액은 {:money}보다 작을 수 없습니다.', 1),
(8414, 7, '410125', '充值成功', '재충전 성공', 1),
(8415, 7, '410126', '充值失败', '재충전 실패', 1),
(8416, 7, '410127', '签到获得{:integral}积分', '{:integral} 포인트를 얻으려면 로그인하세요', 1),
(8417, 7, '410128', '签到失败', '로그인 실패', 1),
(8418, 7, '410129', '收藏成功', '수집 성공', 1),
(8419, 7, '410130', '收藏失败', '수집 실패', 1),
(8420, 7, '410131', '授权失败', '인증 실패', 1),
(8421, 7, '410132', 'unionid不存在', 'unionid가 존재하지 않습니다', 1),
(8422, 7, '410133', '获取用户UID失败', '사용자 UID 가져오기 실패', 1),
(8423, 7, '410134', '请输入昵称或者选择头像', '닉네임을 입력하거나 아바타를 선택하세요', 1),
(8424, 7, '410135', '注销成功', '로그아웃 성공', 1),
(8425, 7, '410136', '暂无客服人员在线，请稍后联系', '온라인에 고객센터 직원이 없으니 나중에 연락주세요', 1),
(8426, 7, '410137', '不能和自己聊天', '나와 채팅할 수 없음', 1),
(8427, 7, '410138', '您不是客服无法登录', '고객 서비스가 아니므로 로그인할 수 없습니다', 1),
(8428, 7, '410139', '自己不能转接给自己', '나 자신에게 이전할 수 없습니다', 1),
(8429, 7, '410140', '转接客服失败', '고객 서비스 이전 실패', 1),
(8430, 7, '410141', '没有此用户', '그런 사용자가 없습니다', 1),
(8431, 7, '410142', '客服不存在', '고객 서비스가 존재하지 않습니다', 1),
(8432, 7, '410143', '商品未查到', '상품을 찾을 수 없음', 1),
(8433, 7, '410144', '请填写开票手机号', '결제 전화번호를 입력하세요', 1),
(8434, 7, '410145', '请填写发票抬头（开具发票企业名称）', '인보이스 제목(인보이스를 발행하는 회사명)을 입력해주세요', 1),
(8435, 7, '410146', '请填写正确的发票抬头（开具发票企业名称）', '올바른 인보이스 헤더(인보이스 발행 회사 이름)를 입력하세요', 1),
(8436, 7, '410147', '请填写发票税号', '인보이스 세금 번호를 입력하세요', 1),
(8437, 7, '410148', '请填写正确的发票税号', '올바른 인보이스 세금 번호를 입력하세요', 1),
(8438, 7, '410149', '请填写正确的银行卡号', '올바른 은행 카드 번호를 입력하세요', 1),
(8439, 7, '410150', '地址不存在', '주소가 존재하지 않습니다', 1),
(8440, 7, '410151', '收货地址格式错误', '배송지 형식이 틀립니다', 1),
(8441, 7, '410152', '收货地址格式错误或系统未完善当前地址', '배송 주소의 형식이 잘못되었거나 시스템이 현재 주소를 완성하지 못했습니다', 1),
(8442, 7, '410153', '收货地址格式错误，请重新选择', '배송지 형식이 틀립니다, 다시 선택해 주세요', 1),
(8443, 7, '410154', '请填写详细地址', '자세한 주소를 입력하세요', 1),
(8444, 7, '410155', '名称必须填写', '이름은 반드시 채워야 합니다', 1),
(8445, 7, '410156', '名称最多不能超过25个字符', '이름은 25자를 초과할 수 없습니다', 1),
(8446, 7, '410157', '手机号必须填写', '휴대전화 번호는 반드시 입력해야 합니다', 1),
(8447, 7, '410158', '手机号格式错误', '휴대전화 번호 형식 오류', 1),
(8448, 7, '410159', '省必须填写', '지방이 채워져야 합니다', 1),
(8449, 7, '410160', '市必须填写', '도시가 채워야 함', 1),
(8450, 7, '410161', '区/县必须填写', '구/군은 반드시 기입해야 합니다', 1),
(8451, 7, '410162', '详细地址必须填写', '자세한 주소는 반드시 입력해야 합니다', 1),
(8452, 7, '410163', '请填写反馈内容', '피드백 내용을 작성해주세요', 1),
(8453, 7, '410164', '比例不能大于您的比例', '비율은 당신의 비율보다 클 수 없습니다', 1),
(8454, 7, '410165', '激活成功', '활성화 성공', 1),
(8455, 7, '410166', '暂无海报', '아직 포스터 없음', 1),
(8456, 7, '410167', '二维码生成失败', 'QR 코드 생성 실패', 1),
(8457, 7, '410168', '缺少字体文件Bold', 'Bold 글꼴 파일 누락', 1),
(8458, 7, '410169', '缺少字体文件Normal', '보통 글꼴 파일 누락', 1),
(8459, 7, '410170', '生成图片失败', '이미지 생성 실패', 1),
(8460, 7, '410171', '生成图片时，系统错误', '사진 생성 중 시스템 오류가 발생했습니다', 1),
(8461, 7, '410172', '生成海报失败', '포스터 생성 실패', 1),
(8462, 7, '410173', '订单不存在', '주문이 존재하지 않습니다', 1),
(8463, 7, '410174', '订单已支付', '주문 결제', 1),
(8464, 7, '410175', '请填写实际支付金额', '실제 결제금액을 입력해주세요', 1),
(8465, 7, '410176', '实际支付金额不能小于0元', '실제 결제 금액은 0위안 미만일 수 없습니다', 1),
(8466, 7, '410177', '请填写备注内容', '비고란에 작성해주세요', 1),
(8467, 7, '410178', '请先处理售后申请', '애프터서비스 신청을 먼저 처리해주세요', 1),
(8468, 7, '410179', '用户已取消申请', '사용자가 신청을 취소했습니다', 1),
(8469, 7, '410180', '售后订单状态不支持该操作', '판매 후 주문 상태는 이 작업을 지원하지 않습니다', 1),
(8470, 7, '410181', '退款修改状态错误', '환불 수정 상태 오류', 1),
(8471, 7, '410182', '修改退款状态成功', '환불 상태 수정 성공', 1),
(8472, 7, '410183', '已退完支付金额，不能再退款了', '결제 금액이 환불되어 더 이상 환불이 불가능합니다', 1),
(8473, 7, '410184', '请输入退款金额', '환불 금액을 입력하세요', 1),
(8474, 7, '410185', '退款金额大于支付金额，请修改退款金额', '환불금액이 결제금액보다 많습니다, 환불금액을 수정해주세요', 1),
(8475, 7, '410186', '退款成功', '환불 성공', 1),
(8476, 7, '410187', '退款失败', '환불 실패', 1),
(8477, 7, '410188', '请输入核销码或者扫描核销二维码', '상각 코드를 입력하거나 상쇄 QR 코드를 스캔하세요', 1),
(8478, 7, '410189', '核销成功', '상각 성공', 1),
(8479, 7, '410190', '请输入付款金额', '결제금액을 입력하세요', 1),
(8480, 7, '410191', '支付金额不能为0元', '결제 금액은 0위안이 될 수 없습니다', 1),
(8481, 7, '410192', '付费会员功能暂未开启', '아직 유료 회원 기능이 열리지 않았습니다', 1),
(8482, 7, '410193', '支付数据生成失败', '결제 데이터 생성 실패', 1),
(8483, 7, '410194', '支付订单不存在', '지불 주문이 존재하지 않습니다', 1),
(8484, 7, '410195', '微信支付成功', '위챗 결제 성공', 1),
(8485, 7, '410196', '前往支付', '결제하러 가기', 1),
(8486, 7, '410197', '余额支付成功', '잔액 결제 성공', 1),
(8487, 7, '410198', '请传入支付宝支付回调URL', '알리페이 결제 콜백 URL을 전달해주세요', 1),
(8488, 7, '410199', '支付宝支付成功', '알리페이 결제 성공', 1),
(8489, 7, '410200', '订单生成失败', '주문 생성 실패', 1),
(8490, 7, '410201', '请提交购买的商品', '구매한 상품을 제출해주세요', 1),
(8491, 7, '410202', '商品不存在，请重新选择商品下单', '상품이 존재하지 않습니다, 주문하실 상품을 다시 선택해주세요', 1),
(8492, 7, '410203', '订单创建成功', '주문이 성공적으로 생성되었습니다', 1),
(8493, 7, '410204', '收货成功', '성공적으로 상품을 받았습니다', 1),
(8494, 7, '410205', '收货失败', '수신 실패', 1),
(8495, 7, '410206', '快递单号不存在', '특급 추적 번호가 존재하지 않습니다', 1),
(8496, 7, '410207', '默认运费模板未配置，无法下单', '기본 배송 템플릿이 구성되지 않아 주문할 수 없습니다', 1),
(8497, 7, '410208', '订单已过期,请刷新当前页面', '주문이 만료되었습니다. 현재 페이지를 새로고침하세요', 1),
(8498, 7, '410209', '订单已创建，请点击查看完成支付', '주문이 생성되었습니다. 결제를 완료하려면 보기를 클릭하세요', 1),
(8499, 7, '410210', '订单生成失败，你已经在该团内不能再参加了', '주문 생성 실패, 더 이상 그룹에 참여할 수 없습니다', 1),
(8500, 7, '410211', '订单生成失败，你已经参加该团了，请先支付订单', '주문 생성에 실패했습니다. 이미 그룹에 가입되어 있습니다. 먼저 주문을 결제하세요', 1),
(8501, 7, '410212', '该团人员已满', '그룹이 꽉 찼습니다', 1),
(8502, 7, '410213', '暂不支持该支付方式，请刷新页面或者联系管理员', '현재 지원되지 않는 결제 수단입니다. 페이지를 새로고침하거나 관리자에게 문의하세요', 1),
(8503, 7, '410214', '您购买的商品库存已不足{:cart_num}{:unit_name}', '구매하신 재고가 {:cart_num}{:unit_name}이(가) 부족합니다', 1),
(8504, 7, '410215', '该订单已失效', '주문이 만료되었습니다', 1),
(8505, 7, '410216', '支付失败', '결제 실패', 1),
(8506, 7, '410217', '支付成功', '결제 성공', 1),
(8507, 7, '410218', '支付方式错误', '결제 수단 오류', 1),
(8508, 7, '410219', '订单商品已评价', '주문 항목이 평가되었습니다', 1),
(8509, 7, '410220', '请为商品评分', '상품을 평가해주세요', 1),
(8510, 7, '410221', '请为商家服务评分', '비즈니스 서비스를 평가해 주세요', 1),
(8511, 7, '410222', '评价失败', '평가 실패', 1),
(8512, 7, '410223', '请重新选择退款商品或件数', '환불 품목이나 개수를 다시 선택하세요', 1),
(8513, 7, '410224', '当前状态不能取消申请', '현재 상태에서는 신청을 취소할 수 없습니다', 1),
(8514, 7, '410225', '重选成功', '재성공', 1),
(8515, 7, '410226', '订单已退款', '주문 환불됨', 1),
(8516, 7, '410227', '使用积分抵扣失败', '포인트 차감 실패', 1),
(8517, 7, '410228', '会员类型不存在', '멤버 유형이 존재하지 않습니다', 1),
(8518, 7, '410229', '您已是永久会员无需再购买', '이미 정회원이므로 더 이상 구매할 필요가 없습니다', 1),
(8519, 7, '410230', '该会员卡暂时无法购买', '이 멤버십 카드는 일시적으로 구매할 수 없습니다', 1),
(8520, 7, '410231', '您已经领取过免费会员', '이미 무료 회원권을 받으셨습니다', 1),
(8521, 7, '410232', '此类型会员卡暂未开售', '이런 종류의 멤버십 카드는 아직 판매되지 않습니다', 1),
(8522, 7, '410233', '获取购物车信息失败', '장바구니 정보 가져오기 실패', 1),
(8523, 7, '410234', '您要购买的优惠券已失效，无法购买', '구매하려는 쿠폰이 만료되어 구매할 수 없습니다', 1),
(8524, 7, '410235', '您已获取过该优惠券，无法再次购买', '이미 획득한 쿠폰이므로 다시 구매할 수 없습니다', 1),
(8525, 7, '410236', '请刷新后重试', '새로 고침 후 다시 시도하십시오', 1),
(8526, 7, '410237', '暂无库存', '재고 없음', 1),
(8527, 7, '410238', '选择的规格库存不足', '선택한 사양이 품절되었습니다', 1),
(8528, 7, '410239', '单次购买数量不能大于 {:limit} 件', '단일 구매 수량은 {:limit}개보다 클 수 없습니다.', 1),
(8529, 7, '410240', '该商品限购 {:limit} 件，您已经购买 {:pay_num} 件', '이 제품은 {:limit}개 한정 상품이며, 이미 {:pay_num}개 구매하셨습니다', 1),
(8530, 7, '410241', '选择支付方式有误', '잘못된 결제 수단 선택', 1),
(8531, 7, '410242', '选择的优惠劵无效', '선택한 쿠폰은 유효하지 않습니다', 1),
(8532, 7, '410243', '不满足优惠劵的使用条件', '쿠폰 사용 조건 미충족', 1),
(8533, 7, '410244', '使用优惠劵失败', '쿠폰 사용 실패', 1),
(8534, 7, '410245', '请填写姓名和电话', '이름과 전화번호를 입력하세요', 1),
(8535, 7, '410246', '营销商品不能使用线下支付', '오프라인 결제는 상품 마케팅에 사용할 수 없습니다', 1),
(8536, 7, '410247', '暂无门店无法选择门店自提', '현재 매장이 없으며 매장에서 픽업을 선택할 수 없습니다', 1),
(8537, 7, '410248', '订单商品结算失败', '주문 아이템 결제 실패', 1),
(8538, 7, '410249', '发票已申请', '송장이 적용되었습니다', 1),
(8539, 7, '410250', '正在申请退款中', '환불 신청', 1),
(8540, 7, '410251', '申请失败', '신청 실패', 1),
(8541, 7, '410252', '退款件数大于订单件数', '주문건수보다 환불건수가 많습니다', 1),
(8542, 7, '410253', '该订单已全部拆分', '주문이 분할되었습니다', 1),
(8543, 7, '410254', '申请退款失败', '환불 신청 실패', 1),
(8544, 7, '410255', '存在待处理退款单', '대기 중인 환불 주문이 있습니다', 1),
(8545, 7, '410256', '该订单无法删除', '이 주문은 삭제할 수 없습니다', 1),
(8546, 7, '410257', '订单已经支付无法取消', '주문이 결제되었으며 취소할 수 없습니다', 1),
(8547, 7, '410258', '拼团商品不能再来一单，请在拼团商品内自行下单', '그룹화된 상품은 다시 주문할 수 없습니다. 그룹화된 상품은 본인이 직접 주문해주세요', 1),
(8548, 7, '410259', '砍价商品不能再来一单，请在砍价商品内自行下单', '할인상품은 다시 주문할 수 없습니다. 흥정상품에 직접 주문해주세요', 1),
(8549, 7, '410260', '秒杀商品不能再来一单，请在秒杀商品内自行下单', '세킬 아이템은 다시 주문할 수 없습니다. 세킬 아이템 내에서 주문해주세요', 1),
(8550, 7, '410261', '预售商品不能再来一单，请在预售商品内自行下单', '선판매 상품은 다시 주문할 수 없습니다. 선판매 상품에 직접 주문해 주세요', 1),
(8551, 7, '410262', '再来一单失败，请重新下单', '다른 주문이 실패했습니다. 새로 주문하세요', 1),
(8552, 7, '410263', '该订单无法支付', '주문을 지불할 수 없습니다', 1),
(8553, 7, '410264', '订单支付状态有误，无法进行支付', '주문의 결제 상태가 잘못되어 결제가 되지 않습니다', 1),
(8554, 7, '410265', '该订单已支付', '주문이 완료되었습니다', 1),
(8555, 7, '410266', '订单状态错误', '주문 상태 오류', 1),
(8556, 7, '410267', '此订单不能被核销', '이 주문은 취소할 수 없습니다', 1),
(8557, 7, '410268', '订单有售后申请请先处理', '주문에 A/S 신청이 있으니 먼저 처리해 주세요', 1),
(8558, 7, '410269', '您无权限核销此订单，请联系管理员', '이 주문을 취소할 권한이 없습니다. 관리자에게 문의하세요', 1),
(8559, 7, '410270', '订单已核销', '주문이 취소되었습니다', 1),
(8560, 7, '410271', '拼团订单暂未成功无法核销', '그룹 주문이 아직 성공적으로 작성되지 않았습니다', 1),
(8561, 7, '410272', '核销失败', '확인 실패', 1),
(8562, 7, '410273', '发货成功', '배송 성공', 1),
(8563, 7, '410274', '无需支付', '결제 필요 없음', 1),
(8564, 7, '410275', '获取用户openid失败,无法支付', '사용자 openid 획득 실패, 결제 불가', 1),
(8565, 7, '410276', '网站名称配置未填写,无法支付', '웹사이트 이름 구성이 채워지지 않아 결제할 수 없습니다', 1),
(8566, 7, '410277', '支付方式不存在', '결제 수단이 존재하지 않습니다', 1),
(8567, 7, '410278', '不支持该类型方式', '이 유형의 방법은 지원되지 않습니다', 1),
(8568, 7, '410279', '余额支付失败', '잔액 결제 실패', 1),
(8569, 7, '410280', '暂未开启发票', '송장이 아직 열리지 않았습니다', 1),
(8570, 7, '410281', '暂未开启专用发票', '특별 인보이스가 아직 열리지 않았습니다', 1),
(8571, 7, '410282', '该发票已经存在', '송장이 이미 존재합니다', 1),
(8572, 7, '410283', '设置默认发票失败', '기본 송장 설정 실패', 1),
(8573, 7, '410284', '没有此用户，无法检测升级用户等级', '이 사용자가 없으면 업그레이드 사용자 수준을 감지할 수 없습니다', 1),
(8574, 7, '410285', '检测升级失败', '업그레이드 확인 실패', 1),
(8575, 7, '410286', '修改订单失败', '주문 수정 실패', 1),
(8576, 7, '410287', '修改用户信息失败', '사용자 정보 수정 실패', 1),
(8577, 7, '410288', '绑定推广关系失败', '승진 관계 바인딩 실패', 1),
(8578, 7, '410289', '天数不能为0', '일 수는 0일 수 없습니다', 1),
(8579, 7, '410290', '添加签到数据失败', '체크인 데이터 추가 실패', 1),
(8580, 7, '410291', '赠送经验失败', '경험치 부여 실패', 1),
(8581, 7, '410292', '请先配置签到天数', '체크인 날짜를 먼저 설정하세요', 1),
(8582, 7, '410293', '已经签到', '로그인', 1),
(8583, 7, '410294', '商品不存在', '상품이 존재하지 않습니다', 1),
(8584, 7, '410295', '该商品已下架或删除', '항목이 제거 또는 삭제되었습니다', 1),
(8585, 7, '410296', '该商品库存不足', '제품이 품절되었습니다', 1),
(8586, 7, '410297', '该商品库存不足{:num}', '이 제품 {:num}의 재고 부족', 1),
(8587, 7, '410298', '每人总共限购{:num}件', '각 사람은 총 {:num}개의 조각으로 제한됩니다', 1),
(8588, 7, '410299', '砍价已结束', '흥정이 종료되었습니다', 1),
(8589, 7, '410300', '您不能再发起此件商品砍价', '이 항목에 대해 더 이상 협상을 시작할 수 없습니다.', 1),
(8590, 7, '410301', '该分享未开启砍价', '교섭을 위해 공유가 열리지 않았습니다', 1),
(8591, 7, '410302', '您已经帮砍过此砍价', '이미 가격 인하를 도왔습니다', 1),
(8592, 7, '410303', '砍价信息没有查到', '교섭 정보를 찾을 수 없습니다', 1),
(8593, 7, '410304', '用户砍价信息未查到', '사용자 교섭 정보를 찾을 수 없습니다', 1),
(8594, 7, '410305', '请选择有效的商品属性', '올바른 제품 속성을 선택하세요', 1),
(8595, 7, '410306', '砍价商品不存在', '할인 아이템이 존재하지 않습니다', 1),
(8596, 7, '410307', '砍价失败', '흥정 실패', 1),
(8597, 7, '410308', '砍价未成功', '협상이 실패했습니다', 1),
(8598, 7, '410309', '砍价已支付', '흥정이 지급되었습니다', 1),
(8599, 7, '410310', '您不能再帮砍此件商品', '이 아이템을 자르는 것을 더 이상 도울 수 없습니다', 1),
(8600, 7, '410311', '商品已被删除', '항목이 삭제되었습니다', 1),
(8601, 7, '410312', '拼团不存在或已下架,请手动申请退款', '그룹이 존재하지 않거나 제거되었습니다. 수동으로 환불을 신청하세요', 1),
(8602, 7, '410313', '每个订单限购{:num}件', '각 주문은 {:num}개로 제한됩니다', 1),
(8603, 7, '410314', '未查到拼团信息，无法取消', '그룹 정보를 찾을 수 없으며 취소할 수 없습니다', 1),
(8604, 7, '410315', '拼团已到期', '그룹이 만료되었습니다', 1),
(8605, 7, '410316', '拼团已完成，无法取消', '그룹화가 완료되어 취소할 수 없습니다', 1),
(8606, 7, '410317', '每人限购{:num}件', '각 사람은 {:num}개의 조각으로 제한됩니다', 1),
(8607, 7, '410318', '抽奖不存在', '복권은 존재하지 않습니다', 1),
(8608, 7, '410319', '领取成功', '성공적으로 수신됨', 1),
(8609, 7, '410320', '领取失败', '수신 실패', 1),
(8610, 7, '410321', '活动未开始', '이벤트가 시작되지 않았습니다', 1),
(8611, 7, '410322', '活动已结束', '이벤트가 종료되었습니다', 1),
(8612, 7, '410323', '您已有这张优惠券，请勿重复购买', '이 쿠폰을 이미 가지고 있습니다. 다시 구매하지 마세요.', 1),
(8613, 7, '410324', '请核对快递公司编码', '택배사 코드를 확인해주세요', 1),
(8614, 7, '410325', '请选择发票', '송장을 선택하세요', 1),
(8615, 7, '-1', '系统繁忙，请稍候再试', '시스템이 사용 중입니다. 나중에 다시 시도하십시오', 1),
(8616, 7, '43104', 'appid与openid不匹配', 'appid가 openid와 일치하지 않습니다', 1),
(8617, 7, '45009', '达到微信api每日限额上限', 'WeChat API의 일일 한도에 도달했습니다', 1),
(8618, 7, '45008', '图文消息超过限制', '문자 메시지가 한도를 초과했습니다', 1),
(8619, 7, '45007', '语音播放时间超过限制', '음성 재생 시간이 제한을 초과했습니다', 1),
(8620, 7, '45006', '图片链接字段超过限制', '이미지 링크 필드가 제한을 초과했습니다', 1),
(8621, 7, '45005', '链接字段超过限制', '링크 필드가 제한을 초과했습니다', 1),
(8622, 7, '45004', '描述字段超过限制', '설명 필드가 한도를 초과했습니다', 1),
(8623, 7, '45003', '标题字段超过限制', '제목 필드가 제한을 초과했습니다', 1),
(8624, 7, '45002', '消息内容超过限制', '메시지 내용이 한도를 초과했습니다', 1),
(8625, 7, '45001', '多媒体文件大小超过限制', '멀티미디어 파일 크기가 제한을 초과합니다', 1),
(8626, 7, '44004', '文本消息内容为空', '문자 메시지 내용이 비어 있습니다', 1),
(8627, 7, '44003', '图文消息内容为空', '문자 메시지의 내용이 비어 있습니다', 1),
(8628, 7, '44002', 'POST 的数据包为空', 'POST 데이터 패킷이 비어 있습니다', 1),
(8629, 7, '44001', '多媒体文件为空', '멀티미디어 파일이 비어 있습니다', 1),
(8630, 7, '43019', '需要将接收者从黑名单中移除', '수신인을 블랙리스트에서 제거해야 합니다', 1),
(8631, 7, '43005', '需要好友关系', '우정 필요', 1),
(8632, 7, '43004', '需要接收者关注', '수신자의 주의가 필요합니다', 1),
(8633, 7, '43003', '需要 HTTPS 请求', 'HTTPS 요청 필요', 1),
(8634, 7, '43002', '需要 POST 请求', 'POST 요청이 필요합니다', 1),
(8635, 7, '43001', '需要 GET 请求', 'GET 요청이 필요합니다', 1),
(8636, 7, '42007', '用户修改微信密码， accesstoken 和 refreshtoken 失效，需要重新授权', '사용자가 WeChat 비밀번호를 수정했습니다. accesstoken과 refreshtoken이 유효하지 않아 재인증이 필요합니다', 1),
(8637, 7, '42003', 'oauth_code 超时', 'oauth_code 시간 초과', 1),
(8638, 7, '42002', 'refresh_token 超时', '새로고침_토큰 시간 초과', 1),
(8639, 7, '42001', 'access_token 超时，请检查 access_token 的有效期，请参考基础支持 - 获取 access_token 中，对 access_token 的详细机制说明', 'access_token이 시간 초과되었습니다. access_token의 유효 기간을 확인하십시오. 기본 지원 - access_token의 자세한 메커니즘인 access_token 얻기를 참조하십시오.', 1),
(8640, 7, '41009', '缺少 openid', 'openid 누락', 1),
(8641, 7, '41008', '缺少 oauth code', '인증 코드 누락', 1),
(8642, 7, '41007', '缺少子菜单数据', '하위 메뉴 데이터 누락', 1),
(8643, 7, '41006', '缺少 media_id 参数', 'media_id 매개변수 누락', 1),
(8644, 7, '41005', '缺少多媒体文件数据', '멀티미디어 파일 데이터 누락', 1),
(8645, 7, '41004', '缺少 secret 参数', '비밀 매개변수 누락', 1),
(8646, 7, '41003', '缺少 refresh_token 参数', 'refresh_token 매개변수 누락', 1),
(8647, 7, '41002', '缺少 appid 参数', 'appid 매개변수 누락', 1),
(8648, 7, '41001', '缺少 access_token 参数', 'access_token 매개변수가 없습니다', 1),
(8649, 7, '40163', 'oauth_code已使用', 'oauth_code가 사용되었습니다', 1),
(8650, 7, '40155', '请勿添加其他公众号的主页链接', '다른 공식 계정으로의 링크 추가 금지', 1),
(8651, 7, '40137', '不支持的图片格式', '지원되지 않는 이미지 형식', 1),
(8652, 7, '40132', '微信号不合法', '위챗 아이디는 불법입니다', 1),
(8653, 7, '40125', '无效的appsecret', '잘못된 앱비밀', 1),
(8654, 7, '40121', '不合法的 media_id 类型', '잘못된 media_id 유형', 1),
(8655, 7, '40120', '子 button 类型错误', '하위 버튼 유형이 잘못되었습니다', 1),
(8656, 7, '40119', 'button 类型错误', '버튼 유형 오류', 1),
(8657, 7, '40118', 'media_id 大小不合法', 'media_id 크기가 잘못되었습니다', 1),
(8658, 7, '40117', '分组名字不合法', '그룹 이름이 잘못되었습니다', 1),
(8659, 7, '40060', '删除单篇图文时，指定的 article_idx 不合法', '단일 이미지를 삭제할 때 지정한 article_idx가 잘못되었습니다', 1),
(8660, 7, '40051', '分组名字不合法', '그룹 이름이 잘못되었습니다', 1),
(8661, 7, '40050', '不合法的分组 id', '잘못된 그룹 ID', 1),
(8662, 7, '40048', '无效的url', '잘못된 URL', 1),
(8663, 7, '40039', '不合法的 URL 长度', '잘못된 URL 길이', 1),
(8664, 7, '40035', '不合法的参数', '잘못된 매개변수', 1),
(8665, 7, '40038', '不合法的请求格式', '잘못된 요청 형식', 1),
(8666, 7, '40033', '不合法的请求字符，不能包含 \\uxxxx 格式的字符', '잘못된 요청 문자, \\uxxxx 형식의 문자를 포함할 수 없음', 1),
(8667, 7, '40032', '不合法的 openid 列表长度', '불법 openid 목록 길이', 1),
(8668, 7, '40031', '不合法的 openid 列表', '불법 공개 ID 목록', 1),
(8669, 7, '40030', '不合法的 refresh_token', '불법 새로고침_토큰', 1),
(8670, 7, '40029', '无效的 oauth_code', '잘못된 oauth_code', 1),
(8671, 7, '40028', '不合法的自定义菜单使用用户', '불법 사용자 정의 메뉴 사용자', 1),
(8672, 7, '40027', '不合法的子菜单按钮 URL 长度', '잘못된 하위 메뉴 버튼 URL 길이', 1),
(8673, 7, '40026', '不合法的子菜单按钮 KEY 长度', '부적합한 하위 메뉴 버튼 KEY 길이', 1),
(8674, 7, '40025', '不合法的子菜单按钮名字长度', '잘못된 하위 메뉴 버튼 이름 길이', 1),
(8675, 7, '40024', '不合法的子菜单按钮类型', '잘못된 하위 메뉴 버튼 유형', 1),
(8676, 7, '40023', '不合法的子菜单按钮个数', '하위 메뉴 버튼의 수가 잘못되었습니다', 1),
(8677, 7, '40022', '不合法的子菜单级数', '잘못된 하위 메뉴 수준', 1),
(8678, 7, '40021', '不合法的菜单版本号', '잘못된 메뉴 버전 번호', 1),
(8679, 7, '40020', '不合法的按钮 URL 长度', '잘못된 버튼 URL 길이', 1),
(8680, 7, '40019', '不合法的按钮 KEY 长度', '잘못된 버튼 키 길이', 1),
(8681, 7, '40018', '不合法的按钮名字长度', '잘못된 버튼 이름 길이', 1),
(8682, 7, '40017', '不合法的按钮类型', '잘못된 버튼 유형', 1),
(8683, 7, '40016', '不合法的按钮个数', '잘못된 버튼의 수', 1),
(8684, 7, '40015', '不合法的菜单类型', '잘못된 메뉴 유형', 1),
(8685, 7, '40014', '不合法的 access_token ，请开发者认真比对 access_token 的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口', '불법 access_token, access_token의 유효성(만료 여부 등)을 주의 깊게 비교하거나 적절한 공식 계정에 대해 인터페이스가 호출되는지 확인하세요', 1),
(8686, 7, '40013', '不合法的 AppID ，请开发者检查 AppID 的正确性，避免异常字符，注意大小写', '불법 AppID, AppID의 정확성을 확인하고, 비정상적인 문자를 피하고, 대소문자에 주의하세요', 1),
(8687, 7, '40012', '不合法的缩略图文件大小', '잘못된 썸네일 파일 크기', 1),
(8688, 7, '40011', '不合法的视频文件大小', '잘못된 동영상 파일 크기', 1),
(8689, 7, '40010', '不合法的语音文件大小', '음성 파일 크기가 잘못되었습니다', 1),
(8690, 7, '40009', '不合法的图片文件大小', '잘못된 이미지 파일 크기', 1),
(8691, 7, '40008', '不合法的消息类型', '잘못된 메시지 유형', 1),
(8692, 7, '40007', '不合法的媒体文件 id', '잘못된 미디어 파일 ID', 1),
(8693, 7, '40006', '不合法的文件大小', '잘못된 파일 크기', 1),
(8694, 7, '40005', '不合法的文件类型', '잘못된 파일 형식', 1),
(8695, 7, '40004', '不合法的媒体文件类型', '잘못된 미디어 파일 형식', 1),
(8696, 7, '40003', '不合法的 OpenID ，请开发者确认 OpenID （该用户）是否已关注公众号，或是否是其他公众号的 OpenID', '불법 OpenID, OpenID(사용자)가 공식 계정을 팔로우했는지, 아니면 다른 공식 계정의 OpenID인지 확인해주세요', 1),
(8697, 7, '40002', '不合法的凭证类型', '불법 인증서 유형', 1),
(8698, 7, '40001', '获取 access_token 时 AppSecret 错误，或者 access_token 无效。请开发者认真比对 AppSecret 的正确性，或查看是否正在为恰当的公众号调用接口', 'access_token을 가져올 때 AppSecret 오류가 발생하거나 access_token이 유효하지 않습니다. 개발자들은 AppSecret의 정확성을 신중하게 비교하거나 적절한 공식 계정에 대한 인터페이스가 호출되는지 확인하십시오', 1),
(8699, 7, '200011', '此账号已被封禁，无法操作', '이 계정은 차단되어 운영할 수 없습니다', 1),
(8700, 7, '200012', '个人模版数已达上限，上限25个', '개인 템플릿의 개수가 상한선에 도달했습니다. 상한선은 25개입니다', 1),
(8701, 7, '200014', '请检查小程序所属类目', '애플릿 카테고리를 확인해주세요', 1),
(8702, 8, '100000', '保存成功', 'Амжилттай хадгалсан', 1),
(8703, 8, '100001', '修改成功', 'Өөрчлөлт амжилттай', 1),
(8704, 8, '100002', '删除成功', 'Амжилттай устгасан', 1),
(8705, 8, '100003', '显示成功', 'Амжилтыг харуулах', 1),
(8706, 8, '100004', '隐藏成功', 'Нуугдсан амжилт', 1),
(8707, 8, '100005', '操作失败', 'Үйл ажиллагаа амжилтгүй боллоо', 1),
(8708, 8, '100006', '保存失败', 'Хадгалж чадсангүй', 1),
(8709, 8, '100007', '修改失败', 'Өөрчлөлт амжилтгүй боллоо', 1),
(8710, 8, '100008', '删除失败', 'Устгаж чадсангүй', 1),
(8711, 8, '100009', '图片上传成功', 'Зургийг амжилттай байршууллаа', 1),
(8712, 8, '100010', '操作成功', 'Үйл ажиллагаа амжилттай боллоо', 1),
(8713, 8, '100011', '暂无数据', 'Өгөгдөл байхгүй', 1),
(8714, 8, '100012', '更新成功', 'Шинэчлэлт амжилттай', 1),
(8715, 8, '100013', '更新失败', 'Шинэчилж чадсангүй', 1),
(8716, 8, '100014', '设置成功', 'Амжилттай тохируулсан', 1),
(8717, 8, '100015', '设置失败', 'Тохиргоо амжилтгүй боллоо', 1),
(8718, 8, '100016', '获取失败', 'Амжилтгүй болсон', 1),
(8719, 8, '100017', '提交成功', 'Амжилттай илгээсэн', 1),
(8720, 8, '100018', '提交失败', 'Илгээж чадсангүй', 1),
(8721, 8, '100019', '取消成功', 'Амжилтыг цуцлах', 1),
(8722, 8, '100020', '取消失败', 'Цуцалж чадсангүй', 1),
(8723, 8, '100021', '添加成功', 'Амжилттай нэмсэн', 1),
(8724, 8, '100022', '添加失败', 'Нэмж чадсангүй', 1),
(8725, 8, '100023', '保存token失败', 'Токеныг хадгалж чадсангүй', 1),
(8726, 8, '100024', '备注成功', 'Тайлбар амжилттай болсон', 1),
(8727, 8, '100025', '备注失败', 'Тайлбар амжилтгүй боллоо', 1),
(8728, 8, '100026', '数据不存在', 'Өгөгдөл байхгүй', 1),
(8729, 8, '100027', '申请成功', 'Ашиглалт амжилттай боллоо', 1),
(8730, 8, '100028', '申请失败', 'Програм амжилтгүй боллоо', 1),
(8731, 8, '100029', '暂无此方法', 'Ийм арга байхгүй', 1),
(8732, 8, '100030', '发送成功', 'Амжилттай илгээсэн', 1),
(8733, 8, '100031', '发送失败', 'Илгээж чадсангүй', 1),
(8734, 8, '100032', '上传成功', 'Байршуулалт амжилттай', 1),
(8735, 8, '100033', '上传失败', 'Байршуулж чадсангүй', 1),
(8736, 8, '100034', '移动成功', 'Амжилттай хөдөлж байна', 1),
(8737, 8, '100035', '移动失败', 'Зөөж чадсангүй', 1),
(8738, 8, '100036', '退款成功', 'Буцаан олголт амжилттай', 1),
(8739, 8, '100037', '退款失败', 'Төлбөрийг буцааж чадсангүй', 1),
(8740, 8, '100038', '同步成功', 'Амжилттай синхрончлол', 1),
(8741, 8, '100039', '同步失败', 'Синк амжилтгүй боллоо', 1),
(8742, 8, '100040', '恢复成功', 'Сэргээлт амжилттай', 1),
(8743, 8, '100041', '恢复失败', 'Сэргэж чадсангүй', 1),
(8744, 8, '100042', '退出成功', 'Амжилттай гарлаа', 1),
(8745, 8, '100043', '退出失败', 'Гарах амжилтгүй', 1),
(8746, 8, '100044', '开通成功', 'Амжилттай нээлээ', 1),
(8747, 8, '100045', '开通失败', 'Идэвхжүүлж чадсангүй', 1),
(8748, 8, '100046', '清除数据成功', 'Өгөгдлийг амжилттай устгалаа', 1),
(8749, 8, '100047', '优化成功', 'Оновчлол амжилттай', 1),
(8750, 8, '100048', '优化失败', 'Оновчлол амжилтгүй боллоо', 1),
(8751, 8, '100049', '修复成功', 'Засвар амжилттай', 1),
(8752, 8, '100050', '修复失败', 'Засвар амжилтгүй боллоо', 1),
(8753, 8, '100051', '备份成功', 'Нөөцлөлт амжилттай', 1),
(8754, 8, '100052', '备份失败', 'Нөөцлөлт амжилтгүй боллоо', 1),
(8755, 8, '100100', '参数错误', 'Параметрийн алдаа', 1),
(8756, 8, '100101', '非法操作', 'Хууль бус ажиллагаа', 1),
(8757, 8, '100102', '数据获取失败', 'Мэдээлэл цуглуулж чадсангүй', 1),
(8758, 8, '100103', '站点升级中，请稍候访问', 'Сайт шинэчлэгдэж байна, дараа зочилно уу', 1),
(8759, 8, '100104', '缺少code', 'код дутуу', 1),
(8760, 8, '110000', '您暂时没有访问权限', 'Танд түр зуур нэвтрэх эрх байхгүй', 1),
(8761, 8, '110001', '接口未授权，您无法访问', 'Интерфэйс зөвшөөрөлгүй, та нэвтрэх боломжгүй', 1),
(8762, 8, '110002', '请登录', 'Нэвтэрнэ үү', 1),
(8763, 8, '110003', '登录已过期,请重新登录', 'Нэвтрэх хугацаа дууссан тул дахин нэвтэрнэ үү', 1),
(8764, 8, '110004', '登录状态有误,请重新登录', 'Нэвтрэх төлөв буруу байна, дахин нэвтэрнэ үү', 1),
(8765, 8, '110005', '请登录', 'Нэвтэрнэ үү', 1),
(8766, 8, '110006', '登录已过期,请重新登录', 'Нэвтрэх хугацаа дууссан тул дахин нэвтэрнэ үү', 1),
(8767, 8, '110007', '登录状态有误,请重新登录', 'Нэвтрэх төлөв буруу байна, дахин нэвтэрнэ үү', 1),
(8768, 8, '400000', '请选择用户头像', 'Хэрэглэгчийн аватарыг сонгоно уу', 1),
(8769, 8, '400001', '请填写用户昵称', 'Хэрэглэгчийн хочыг оруулна уу', 1),
(8770, 8, '400002', '请填写评论内容', 'Сэтгэгдэл бичнэ үү', 1),
(8771, 8, '400003', '请选择商品分数', 'Бүтээгдэхүүний оноог сонгоно уу', 1),
(8772, 8, '400004', '请选择服务分数', 'Үйлчилгээний оноог сонгоно уу', 1),
(8773, 8, '400005', '商品分数必须是1-5之间的整数', 'Барааны оноо 1-5 хүртэлх бүхэл тоо байх ёстой', 1),
(8774, 8, '400006', '服务分数必须是1-5之间的整数', 'Үйлчилгээний оноо 1-5 хүртэлх бүхэл тоо байх ёстой', 1),
(8775, 8, '400007', '请选择快递公司', 'Та шуудангийн компанийг сонгоно уу', 1),
(8776, 8, '400008', '请填写寄件人姓名', 'Илгээгчийн нэрийг оруулна уу', 1),
(8777, 8, '400009', '请输入寄件人手机号码', 'Илгээгчийн гар утасны дугаарыг оруулна уу', 1),
(8778, 8, '400010', '寄件人手机号码不正确', 'Илгээгчийн гар утасны дугаар буруу байна', 1),
(8779, 8, '400011', '请填写寄件人详细地址', 'Илгээгчийн дэлгэрэнгүй хаягийг бөглөнө үү', 1),
(8780, 8, '400012', '请填写云打印机编号', 'Үүлэн принтерийн дугаарыг бөглөнө үү', 1),
(8781, 8, '400013', '请传入套餐id', 'Багцын ID-г оруулна уу', 1),
(8782, 8, '400014', '套餐id必须为数字', 'Багцын ID нь тоо байх ёстой', 1),
(8783, 8, '400015', '请填写套餐金额', 'Багцын дүнг бөглөнө үү', 1),
(8784, 8, '400016', '请填写购买数量', 'Худалдан авалтын тоо хэмжээг бөглөнө үү', 1),
(8785, 8, '400017', '购买数量必须为数字', 'Худалдан авах хэмжээ нь тоо байх ёстой', 1),
(8786, 8, '400018', '请填写购买套餐类型', 'Худалдан авах багцын төрлийг бөглөнө үү', 1),
(8787, 8, '400019', '您输入的手机号码必须为数字', 'Таны оруулсан утасны дугаар заавал дугаар байх ёстой', 1),
(8788, 8, '400020', '密码必须填写', 'Нууц үг заавал бөглөх ёстой', 1),
(8789, 8, '400021', '短信验证码必须为数字', 'SMS баталгаажуулах код нь тоо байх ёстой', 1),
(8790, 8, '400022', '请填写话术内容', 'Хэлний агуулгыг бөглөнө үү', 1),
(8791, 8, '400023', '请填写排序数字', 'Ангилах дугаарыг бөглөнө үү', 1),
(8792, 8, '400024', '请填写排序数字', 'Ангилах дугаарыг бөглөнө үү', 1),
(8793, 8, '400025', '请填写运费模板名称', 'Тээвэрлэлтийн загварын нэрийг оруулна уу', 1),
(8794, 8, '400026', '运费信息必须为数组', 'Тээвэрлэлтийн мэдээлэл нь массив байх ёстой', 1),
(8795, 8, '400027', '包邮信息必须为数组', 'Багцын мэдээлэл нь массив байх ёстой', 1),
(8796, 8, '400028', '不送达信息必须为数组', 'Хүргээгдээгүй мэдээлэл нь массив байх ёстой', 1),
(8797, 8, '400029', 'type数据格式错误，应为1或2或3', 'төрлийн өгөгдлийн форматын алдаа, 1 эсвэл 2 эсвэл 3 байх ёстой', 1),
(8798, 8, '400030', 'appoint数据格式错误，应为0或1', 'Тогтоосон мэдээллийн формат буруу байна, 0 эсвэл 1 байх ёстой', 1),
(8799, 8, '400031', 'no_delivery数据格式错误，应为0或1', 'хүргэх_өгөгдлийн форматын алдаа, 0 эсвэл 1 байх ёстой', 1),
(8800, 8, '400032', 'sort数据格式错误，应为整数', 'өгөгдлийн форматын алдаа, бүхэл тоо байх ёстой', 1),
(8801, 8, '400033', '请填写管理员账号', 'Администраторын бүртгэлийг бөглөнө үү', 1),
(8802, 8, '400034', '管理员账号为英文字母', 'Администраторын бүртгэл нь англи үсэг', 1),
(8803, 8, '400035', '请输管理员姓名', 'Администраторын нэрийг оруулна уу', 1),
(8804, 8, '400036', '请选择管理员身份', 'Администраторын үнэмлэхийг сонгоно уу', 1),
(8805, 8, '400037', '身份必须为数组', 'Identity нь массив байх ёстой', 1),
(8806, 8, '400038', '请填写城市名称', 'Хотын нэрийг оруулна уу', 1),
(8807, 8, '400039', 'level数据格式错误，应为整数', 'түвшингийн өгөгдлийн форматын алдаа, бүхэл тоо байх ёстой', 1),
(8808, 8, '400040', 'parent_id数据格式错误，应为整数', 'parent_id өгөгдлийн форматын алдаа, бүхэл тоо байх ёстой', 1),
(8809, 8, '400041', '请输入有效的网址', 'Хүчинтэй URL оруулна уу', 1),
(8810, 8, '400042', '一级返佣比例必须为数字', 'Эхний түвшний хөнгөлөлтийн харьцаа нь тоо байх ёстой', 1),
(8811, 8, '400043', '一级返佣比例最多两位小数', 'Эхний түвшний буцаан олголт нь хоёр аравтын орон хүртэл байж болно', 1),
(8812, 8, '400044', '一级返佣比例填写范围在0-100之间', 'Нэгдүгээр түвшний буцаан олголтын харьцаа 0-100 хүртэлх мужийг дүүргэж байна', 1),
(8813, 8, '400045', '二级返佣比例必须为数字', 'Хоёр дахь түвшний хөнгөлөлтийн харьцаа нь тоо байх ёстой', 1),
(8814, 8, '400046', '二级返佣比例最多两位小数', 'Хоёр дахь түвшний хөнгөлөлтийн харьцаа нь хоёр аравтын орон хүртэл байж болно', 1),
(8815, 8, '400047', '二级返佣比例填写范围在0-100之间', 'Хоёр дахь түвшний буцаан олголтын харьцаа 0-100 хүртэлх мужийг дүүргэж байна', 1),
(8816, 8, '400048', '待补货数量必须为数字', 'Нөхөх тоо нь тоо байх ёстой', 1),
(8817, 8, '400049', '警戒库存必须为数字', 'Анхааруулга нь тоо байх ёстой', 1),
(8818, 8, '400050', '提现最小金额只能为数字', 'Мөнгө авах хамгийн бага хэмжээ нь зөвхөн тоо байж болно', 1),
(8819, 8, '400051', '提现最小金额必须大于0', 'Татан авалтын доод хэмжээ 0-ээс их байх ёстой', 1),
(8820, 8, '400052', '佣金冻结时间范围在0-180之间', 'Хорооны хөлдөөх хугацаа 0-180 хооронд байна', 1),
(8821, 8, '400053', '满额分销金额金额必须为数字', 'Бүрэн түгээлтийн дүн нь тоо байх ёстой', 1),
(8822, 8, '400054', '积分抵用比例必须为数字', 'Онооны зээлийн харьцаа нь тоо байх ёстой', 1),
(8823, 8, '400055', '积分抵用比例最多两位小数', 'Хасах онооны хувь нь аравтын хоёр орон хүртэл байж болно', 1),
(8824, 8, '400056', '积分抵用比例必须在0-1000之间', 'Зээлийн онооны хувь 0-1000 хооронд байх ёстой', 1),
(8825, 8, '400057', '积分抵用上限必须为数字', 'Зээлийн хязгаарын дээд хязгаар нь тоо байх ёстой', 1),
(8826, 8, '400058', '积分抵用上限必须大于等于0', 'Оноо хасах дээд хязгаар нь 0-ээс их буюу тэнцүү байх ёстой', 1),
(8827, 8, '400059', '下单赠送积分必须为数字', 'Захиалгын урамшууллын оноо нь тоо байх ёстой', 1),
(8828, 8, '400060', '下单赠送积分必须在0-1000之间', 'Захиалгын урамшууллын оноо 0-1000 хооронд байх ёстой', 1),
(8829, 8, '400061', '普通商品未支付取消订单时间必须为数字', 'Энгийн барааны төлбөр төлөхгүй, цуцлах хугацаа нь тоо байх ёстой', 1),
(8830, 8, '400062', '活动商品未支付取消订单时间必须为数字', 'Хэрэв үйл явдлын төлбөрийг төлөөгүй бол захиалга цуцлах хугацаа нь тоо байх ёстой', 1),
(8831, 8, '400063', '砍价商品未支付取消订单时间必须为数字', 'Хэрэв тохиролцсон бараагаа төлөөгүй бол захиалгыг цуцлах хугацаа нь тоо байх ёстой', 1),
(8832, 8, '400064', '拼团商品未支付取消订单时间必须为数字', 'Бүлгийн бүтээгдэхүүний төлбөрийг төлөөгүй тохиолдолд захиалгыг цуцлах хугацаа нь тоо байх ёстой', 1),
(8833, 8, '400065', '订单发货后自动收货时间必须为数字', 'Захиалга хүргэгдсэний дараа автоматаар хүлээн авах хугацаа нь тоо байх ёстой', 1),
(8834, 8, '400066', '满额包邮金额必须为数字', 'Бүрэн хэмжээний үнэгүй хүргэлтийн хэмжээ нь тоо байх ёстой', 1),
(8835, 8, '400067', '积分倍数必须大于0', 'Интеграл үржвэр нь 0-ээс их байх ёстой', 1),
(8836, 8, '400068', '折扣数必须大于0', 'Хөнгөлөлтийн тоо 0-ээс их байх ёстой', 1),
(8837, 8, '400069', '积分倍数必须大于0', 'Интеграл үржвэр нь 0-ээс их байх ёстой', 1),
(8838, 8, '400070', '折扣数必须大于0', 'Хөнгөлөлтийн тоо 0-ээс их байх ёстой', 1),
(8839, 8, '400071', '下单赠送经验比率必须为数字', 'Захиалга өгөхдөө шагналын туршлагын харьцаа нь тоо байх ёстой', 1),
(8840, 8, '400072', '下单赠送经验比率必须大于0', 'Захиалгын урамшууллын туршлагын харьцаа 0-ээс их байх ёстой', 1),
(8841, 8, '400073', '签到赠送经验必须为数字', 'Нэвтрэх туршлага нь тоо байх ёстой', 1),
(8842, 8, '400074', '签到赠送经验必须大于0', 'Нэвтрэх туршлага 0-ээс их байх ёстой', 1),
(8843, 8, '400075', '邀请新用户赠送经验必须为数字', 'Шинэ хэрэглэгчдийг туршлага өгөхөд урих нь тоо байх ёстой', 1),
(8844, 8, '400076', '邀请新用户赠送经验必须大于0', 'Шинэ хэрэглэгчдийг туршлага өгөхөд урих нь 0-ээс их байх ёстой', 1),
(8845, 8, '400077', '发货人姓名必须为汉字', 'Илгээгчийн нэр хятад үсгээр бичигдсэн байх ёстой', 1),
(8846, 8, '400078', '发货人姓名长度在2-10位', 'Илгээгчийн нэрийн урт нь 2-10 оронтой', 1),
(8847, 8, '400079', '发货人电话必须为数字', 'Илгээгчийн утасны дугаар нь дугаар байх ёстой', 1),
(8848, 8, '400080', '发货人电话请填写有效的手机号', 'Илгээгчийн утасны дугаарыг хүчинтэй гар утасны дугаараар бөглөнө үү', 1),
(8849, 8, '400081', '发货人地址只能是汉字、字母、数字', 'Илгээгчийн хаяг нь зөвхөн хятад тэмдэгт, үсэг, тоо байж болно', 1),
(8850, 8, '400082', '发货人地址长度为10-100位', 'Илгээгчийн хаягийн урт нь 10-100 оронтой', 1),
(8851, 8, '400083', '电子面单打印机编号必须为数字、字母', 'Цахим маягтын хэвлэгчийн дугаар нь тоо, үсэг байх ёстой', 1),
(8852, 8, '400084', '电子面单打印机编号长度为10-50位', 'Цахим нэг хэвлэгчийн серийн дугаарын урт нь 10-50 оронтой', 1),
(8853, 8, '400085', '客服反馈长度位10-90位', 'Хэрэглэгчийн үйлчилгээний санал хүсэлтийн урт нь 10-90 оронтой', 1),
(8854, 8, '400086', '请填写标签分类名称', 'Шошгоны ангиллын нэрийг бөглөнө үү', 1),
(8855, 8, '400087', '请填写标签分类排序', 'Шошгоны ангиллын дарааллыг бөглөнө үү', 1),
(8856, 8, '400088', '标签分类必须为数字', 'Шошгоны ангилал нь тоо байх ёстой', 1),
(8857, 8, '400089', '账号只能为数字和字母', 'Дансны дугаар нь зөвхөн тоо, үсэг байж болно', 1),
(8858, 8, '400090', '限量不能超过商品库存', 'Хязгаарлалт нь бүтээгдэхүүний нөөцөөс хэтэрч болохгүй', 1),
(8859, 8, '400091', '商品已下架或移入回收站', 'Энэ зүйлийг тавиураас хассан эсвэл хогийн сав руу зөөсөн', 1),
(8860, 8, '400092', '占用库存失败', 'Бараа материал эзэлж чадсангүй', 1),
(8861, 8, '400093', '商品已下架或已删除', 'Бүтээгдэхүүнийг тавиураас гаргасан эсвэл устгасан', 1),
(8862, 8, '400094', '请选择有效的商品属性', 'Хүчтэй бүтээгдэхүүний шинж чанарыг сонгоно уу', 1),
(8863, 8, '400095', '金额不能小于0', 'Хэмжээ нь 0-ээс бага байж болохгүй', 1),
(8864, 8, '400096', '结束时间不能小于今天', 'Төгсгөлийн цаг өнөөдрөөс бага байж болохгүй', 1),
(8865, 8, '400097', '您不是付费会员', 'Та төлбөртэй гишүүн биш', 1),
(8866, 8, '400098', '暂时无法领取', 'Түр ашиглах боломжгүй', 1),
(8867, 8, '400099', '请先配置小票打印开发者', 'Эхлээд төлбөрийн баримт хэвлэх хөгжүүлэгчийг тохируулна уу', 1),
(8868, 8, '400100', '请填写分类名称', 'Ангиллын нэрийг бөглөнө үү', 1),
(8869, 8, '400101', '该分类已存在', 'Энэ ангилал аль хэдийн бий', 1),
(8870, 8, '400102', '请先删除子分类', 'Эхлээд дэд ангиллыг устгана уу', 1),
(8871, 8, '400103', '分类不存在', 'Ангилал байхгүй', 1),
(8872, 8, '400104', '文件名称不能为空', 'Файлын нэр хоосон байж болохгүй', 1),
(8873, 8, '400105', '该分类有下级分类，无法修改上级', 'Энэ ангилал нь дэд ангилалтай бөгөөд дээд ангилалд өөрчлөлт оруулах боломжгүй', 1),
(8874, 8, '400106', '备注不能为空', 'Тайлбарууд хоосон байж болохгүй', 1),
(8875, 8, '400107', '请输入姓名', 'Нэрээ оруулна уу', 1),
(8876, 8, '400108', '请输入提现金额', 'Татан авалтын дүнг оруулна уу', 1),
(8877, 8, '400109', '请输入支付宝账号', 'Alipay дансны дугаараа оруулна уу', 1),
(8878, 8, '400110', '请输入微信账号', 'WeChat бүртгэлээ оруулна уу', 1),
(8879, 8, '400111', '请输入银行卡号', 'Банкны картын дугаараа оруулна уу', 1),
(8880, 8, '400112', '请输入开户行', 'Данс нээх банкаа оруулна уу', 1),
(8881, 8, '400113', '拒绝理由不能为空', 'Татгалзсан шалтгаан хоосон байж болохгүй', 1),
(8882, 8, '400114', '不能重复收货', 'Барааг дахин дахин хүлээн авах боломжгүй', 1),
(8883, 8, '400115', '请先发货或者送货', 'Эхлээд илгээнэ үү эсвэл хүргэнэ үү', 1),
(8884, 8, '400116', '收货失败,请稍候再试', 'Бараа хүлээж авч чадсангүй, дараа дахин оролдоно уу', 1),
(8885, 8, '400117', '收货成功', 'Барааг амжилттай хүлээн авлаа', 1),
(8886, 8, '400118', '订单不存在', 'Захиалга байхгүй', 1),
(8887, 8, '400119', '用户信息不存在', 'Хэрэглэгчийн мэдээлэл байхгүй', 1),
(8888, 8, '400120', '快递单号不存在', 'Экспресс хяналтын дугаар байхгүй', 1),
(8889, 8, '400121', '打印成功', 'Амжилттай хэвлэв', 1),
(8890, 8, '400122', '打印失败', 'Хэвлэж чадсангүй', 1),
(8891, 8, '400123', '快递公司编号缺失', 'Шуудангийн компанийн дугаар дутуу байна', 1),
(8892, 8, '400124', '请配置腾讯地图KEY', 'Tencent map KEY-г тохируулна уу', 1),
(8893, 8, '400125', '请选择门店位置', 'Дэлгүүрийн байршлыг сонгоно уу', 1),
(8894, 8, '400126', '添加的核销员用户已存在', 'Нэмэгдсэн хасагдсан гишүүн хэрэглэгч аль хэдийн байна', 1),
(8895, 8, '400127', '请选择所属提货点', 'Өөрийн харьяалагдах цэгээ сонгоно уу', 1),
(8896, 8, '400128', '请填写核销员名称', 'Таслах гишүүний нэрийг бичнэ үү', 1),
(8897, 8, '400129', '请填写核销员电话', 'Баталгаажуулах ажилтны утасны дугаарыг бөглөнө үү', 1),
(8898, 8, '400130', '核销员添加成功', 'Баталгаажуулах гишүүнийг амжилттай нэмсэн', 1),
(8899, 8, '400131', '核销员添加失败', 'Таслах гишүүнийг нэмж чадсангүй', 1),
(8900, 8, '400132', '请填写手机号', 'Утасны дугаараа бөглөнө үү', 1),
(8901, 8, '400133', '请填写账号', 'Дансны дугаараа бөглөнө үү', 1),
(8902, 8, '400134', '请填写密码', 'Нууц үгээ оруулна уу', 1),
(8903, 8, '400135', '请填写短信签名', 'SMS гарын үсгийг бөглөнө үү', 1),
(8904, 8, '400136', '短信签名最长为8位', 'Хамгийн урт SMS гарын үсэг нь 8 оронтой', 1),
(8905, 8, '400137', '请填写验证码', 'Баталгаажуулах кодыг бөглөнө үү', 1),
(8906, 8, '400138', '请填写域名', 'Домэйн нэрийг бөглөнө үү', 1),
(8907, 8, '400139', '登录成功', 'Нэвтрэх амжилттай', 1),
(8908, 8, '400140', '账号或密码错误', 'Бүртгэл эсвэл нууц үгийн алдаа', 1),
(8909, 8, '400141', '请先填写短信配置', 'Эхлээд SMS тохиргоог бөглөнө үү', 1),
(8910, 8, '400142', '请输入模板名称', 'Загварын нэрийг оруулна уу', 1),
(8911, 8, '400143', '请输入模板内容', 'Загварын агуулгыг оруулна уу', 1),
(8912, 8, '400144', '售后订单状态不支持该操作', 'Борлуулалтын дараах захиалгын төлөв энэ үйлдлийг дэмждэггүй', 1),
(8913, 8, '400145', '修改退款状态成功', 'Буцаан олголтын төлөвийг амжилттай өөрчлөх', 1),
(8914, 8, '400146', '请输入退款金额', 'Буцаан олголтын дүнг оруулна уу', 1),
(8915, 8, '400147', '已退完支付金额，不能再退款了', 'Төлбөрийн дүнг буцаан олгосон бөгөөд цаашид буцаан олгох боломжгүй', 1),
(8916, 8, '400148', '退款金额大于支付金额，请修改退款金额', 'Буцаан олголтын хэмжээ төлбөрийн дүнгээс их байна, буцаан олголтын хэмжээг өөрчилнө үү', 1),
(8917, 8, '400149', '退款成功', 'Буцаан олголт амжилттай', 1),
(8918, 8, '400150', '退款失败', 'Буцаан олгоогүй', 1),
(8919, 8, '400151', '验证成功', 'Баталгаажуулалт амжилттай', 1),
(8920, 8, '400152', '核销成功', 'Тасалгаа амжилттай боллоо', 1),
(8921, 8, '400153', '核销订单未查到', 'Басах захиалга олдсонгүй', 1),
(8922, 8, '400154', '核销失败', 'Баталгаажуулалт амжилтгүй боллоо', 1),
(8923, 8, '400155', '订单金额必须填写', 'Захиалгын дүнг заавал бөглөх ёстой', 1),
(8924, 8, '400156', '请选择需要删除的订单', 'Устгах захиалгаа сонгоно уу', 1),
(8925, 8, '400157', '您选择的的订单存在用户未删除的订单', 'Таны сонгосон захиалгад хэрэглэгч устгаагүй захиалга байна', 1),
(8926, 8, '400158', '请选择发货商品', 'Ачаалах бараагаа сонгоно уу', 1),
(8927, 8, '400159', '请重新选择发货商品或发货件数', 'Хүргэх бүтээгдэхүүн эсвэл нийлүүлэх ширхэгийн тоог дахин сонгоно уу', 1),
(8928, 8, '400160', '订单已删除无法退积分', 'Захиалга устгагдсан бөгөөд оноог буцааж өгөх боломжгүй', 1),
(8929, 8, '400161', '请输入积分', 'Оноо оруулна уу', 1),
(8930, 8, '400162', '已退完积分', 'Оноог буцаан олгосон', 1),
(8931, 8, '400163', '退积分大于支付积分，请修改退积分', 'Буцаан олгосон оноо нь төлсөн онооноос их байгаа тул буцаан олгосон оноогоо өөрчилнө үү', 1),
(8932, 8, '400164', '退积分成功', 'Оноог амжилттай буцаалаа', 1),
(8933, 8, '400165', '退积分失败', 'Оноо авч чадсангүй', 1),
(8934, 8, '400166', '请填写开票号', 'Нэхэмжлэхийн дугаарыг бөглөнө үү', 1),
(8935, 8, '400167', '请填写正确的开票号', 'Төлбөрийн дугаараа зөв бөглөнө үү', 1),
(8936, 8, '400168', '请上传文件', 'Файлыг байршуулна уу', 1),
(8937, 8, '400169', '回复成功', 'Амжилттай хариулт', 1),
(8938, 8, '400170', '注册成功', 'Бүртгэл амжилттай боллоо', 1),
(8939, 8, '400171', '注册失败', 'Бүртгэл амжилтгүй боллоо', 1),
(8940, 8, '400172', '登录失败', 'Нэвтэрч чадсангүй', 1),
(8941, 8, '400173', '获取套餐列表失败', 'Багцын жагсаалтыг авч чадсангүй', 1),
(8942, 8, '400174', '获取支付码失败', 'Төлбөрийн код авч чадсангүй', 1),
(8943, 8, '400175', '请先开通短信服务', 'Эхлээд SMS үйлчилгээг идэвхжүүлнэ үү', 1),
(8944, 8, '400176', '请先开通物流查询服务', 'Эхлээд ложистикийн лавлагааны үйлчилгээг нээнэ үү', 1),
(8945, 8, '400177', '请先开通电子面单打印服务', 'Эхлээд цахим нүүр дан хэвлэх үйлчилгээг идэвхжүүлнэ үү', 1),
(8946, 8, '400178', '请先开通商品采集服务', 'Эхлээд бараа цуглуулах үйлчилгээг идэвхжүүлнэ үү', 1),
(8947, 8, '400179', '请设置短信签名', 'SMS гарын үсэг тохируулна уу', 1),
(8948, 8, '400180', '修改短信签名成功', 'SMS гарын үсэг амжилттай өөрчлөгдсөн', 1),
(8949, 8, '400181', '默认模板不能删除', 'Өгөгдмөл загварыг устгах боломжгүй', 1),
(8950, 8, '400182', '管理员信息读取失败', 'Администраторын мэдээллийг уншиж чадсангүй', 1),
(8951, 8, '400183', '密码太过简单，请输入较为复杂的密码', 'Нууц үг хэтэрхий энгийн байна, илүү төвөгтэй нууц үг оруулна уу', 1),
(8952, 8, '400184', '协议类型不存在', 'Протоколын төрөл байхгүй', 1),
(8953, 8, '400185', '清除成功', 'Тодорхой амжилт', 1),
(8954, 8, '400186', '清除失败', 'Арилгаж чадсангүй', 1),
(8955, 8, '400187', '请输入名称', 'Нэр оруулна уу', 1),
(8956, 8, '400188', '请不要重复添加', 'Дахин бүү нэмээрэй', 1),
(8957, 8, '400189', '添加数据成功', 'Өгөгдлийг амжилттай нэмлээ', 1),
(8958, 8, '400190', '请输入开始时间', 'Эхлэх цагаа оруулна уу', 1),
(8959, 8, '400191', '请输入持续时间', 'Хугацааг оруулна уу', 1),
(8960, 8, '400192', '请输入0-23点之前的整点数', '0-23 цагийн өмнө бүхэл тоог оруулна уу', 1),
(8961, 8, '400193', '请输入1-24点之前的整点数', '1-24 цагийн өмнө бүхэл тоо оруулна уу', 1),
(8962, 8, '400194', '开始时间+持续时间不能大于24小时', 'Эхлэх цаг + үргэлжлэх хугацаа 24 цагаас илүү байж болохгүй', 1),
(8963, 8, '400195', '时段已占用', 'Цагийн завсар дүүрсэн', 1),
(8964, 8, '400196', '请输入签到赠送积分', 'Шалгах урамшууллын оноогоо оруулна уу', 1),
(8965, 8, '400197', '请输入大于等于0的整数', '0-ээс их буюу тэнцүү бүхэл тоо оруулна уу', 1),
(8966, 8, '400198', '请填写按钮名称', 'Товчлуурын нэрийг бөглөнө үү', 1),
(8967, 8, '400199', '没有查到此身份', 'Бие олдсонгүй', 1),
(8968, 8, '400200', '请输入等级名称', 'Түвшингийн нэрийг оруулна уу', 1),
(8969, 8, '400201', '请输入等级', 'Түвшингээ оруулна уу', 1),
(8970, 8, '400202', '请选择等级图标', 'Түвшингийн дүрсийг сонгоно уу', 1),
(8971, 8, '400203', '二级返佣比例不能大于一级', 'Хоёр дахь түвшний хөнгөлөлтийн харьцаа эхний түвшнээс их байж болохгүй', 1),
(8972, 8, '400204', '当前等级已存在', 'Одоогийн түвшин аль хэдийн бий', 1),
(8973, 8, '400205', '添加等级成功', 'Түвшин амжилттай нэмлээ', 1),
(8974, 8, '400206', '编辑的等级不存在', 'Засварлах түвшин байхгүй', 1),
(8975, 8, '400207', '请输入任务名称', 'Даалгаврын нэрийг оруулна уу', 1),
(8976, 8, '400208', '请选择任务类型', 'Даалгаврын төрлийг сонгоно уу', 1),
(8977, 8, '400209', '请输入限定数量', 'Хязгаарлагдмал тоогоор оруулна уу', 1),
(8978, 8, '400210', '添加任务成功', 'Даалгаврыг амжилттай нэмэх', 1),
(8979, 8, '400211', '编辑的任务不存在', 'Засварласан даалгавар байхгүй байна', 1),
(8980, 8, '400212', '获取推广二维码失败，请检查您的微信配置', 'Урамшууллын QR кодыг авч чадсангүй, WeChat тохиргоогоо шалгана уу', 1),
(8981, 8, '400213', '上级推广人不能为自己', 'Дээд зэргийн дэмжигчид өөрсдөө байж чадахгүй', 1),
(8982, 8, '400214', '用户不存在', 'Хэрэглэгч байхгүй', 1),
(8983, 8, '400215', '上级用户不存在', 'Дээд зэргийн хэрэглэгч байхгүй', 1),
(8984, 8, '400216', '当前推广人已经是所选人', 'Одоогийн сурталчлагч аль хэдийн сонгогдсон хүн', 1),
(8985, 8, '400217', '上级推广人不能为自己下级', 'Дээд сурталчлагч нь тэдний харьяалал байж болохгүй', 1),
(8986, 8, '400218', '赠送成功', 'Бэлгийн амжилт', 1),
(8987, 8, '400219', '赠送失败', 'Бэлэг амжилтгүй боллоо', 1),
(8988, 8, '400220', '请输入身份名称', 'Таны нэрийг оруулна уу', 1),
(8989, 8, '400221', '请选择最少一个权限', 'Ядаж нэг зөвшөөрөл сонгоно уу', 1),
(8990, 8, '400222', '添加身份成功', 'Таниулалтыг амжилттай нэмлээ', 1),
(8991, 8, '400223', '添加身份失败', 'Таниулалтыг нэмж чадсангүй', 1),
(8992, 8, '400224', '缺少APPID', 'APPID дутуу', 1),
(8993, 8, '400225', '请先设置空间域名', 'Эхлээд орон зайн домайн нэрийг тохируулна уу', 1),
(8994, 8, '400226', '格式错误，请输入格式为：http://域名', 'Формат буруу байна, форматыг дараах байдлаар оруулна уу: http://domain name', 1),
(8995, 8, '400227', '未有正在使用的存储空间', 'Ашиглаж байгаа хадгалах зай байхгүй', 1),
(8996, 8, '400228', '切换云存储成功,请检查是否开启使用了存储空间', 'Үүлэн санах ойн сэлгэн залгалт амжилттай боллоо, хадгалах зай идэвхжсэн эсэхийг шалгана уу', 1),
(8997, 8, '400229', '切换本地存储成功', 'Дотоод хадгалах санг амжилттай сэлгэх', 1),
(8998, 8, '400230', '请输入模板编号', 'Загварын дугаарыг оруулна уу', 1),
(8999, 8, '400231', '请输入模板编号已存在,请重新输入', 'Загварын дугаарыг оруулна уу, дахин оруулна уу', 1),
(9000, 8, '400232', '请输入模板ID', 'Загварын ID-г оруулна уу', 1),
(9001, 8, '400233', '请输入模板名', 'Загварын нэрийг оруулна уу', 1),
(9002, 8, '400234', '请输入回复内容', 'Хариултын агуулгыг оруулна уу', 1),
(9003, 8, '400235', '添加模板消息成功', 'Загварын мессежийг амжилттай нэмлээ', 1),
(9004, 8, '400236', '请先配置小程序appid、appSecret等参数', 'Эхлээд applet appid, appSecret болон бусад параметрүүдийг тохируулна уу', 1),
(9005, 8, '400237', '二维码生成失败', 'QR код үүсгэж чадсангүй', 1),
(9006, 8, '400238', '请添加至少一个按钮', 'Ядаж нэг товчлуур нэмнэ үү', 1),
(9007, 8, '400239', '请输入关键字', 'Түлхүүр үг оруулна уу', 1),
(9008, 8, '400240', '请选择回复类型', 'Хариултын төрлийг сонгоно уу', 1),
(9009, 8, '400241', '回复类型有误', 'Хариултын төрөл буруу', 1),
(9010, 8, '400242', '回复消息参数有误', 'Хариу мессежийн параметр буруу байна', 1),
(9011, 8, '400243', '请添加图文', 'График нэмнэ үү', 1),
(9012, 8, '400244', '标题不能为空', 'Гарчиг хоосон байж болохгүй', 1),
(9013, 8, '400245', '作者不能为空', 'Зохиогч хоосон байж болохгүй', 1),
(9014, 8, '400246', '正文不能为空', 'Текст хоосон байж болохгүй', 1),
(9015, 8, '400247', '摘要不能为空', 'Дүгнэлт хоосон байж болохгүй', 1),
(9016, 8, '400248', '请先配置微信公众号appid、appSecret等参数', 'Эхлээд WeChat нийтийн бүртгэлийн appid, appSecret болон бусад параметрүүдийг тохируулна уу', 1),
(9017, 8, '400249', '模版消息一键设置成功', 'Загварын мессежийн нэг товшилт амжилттай боллоо', 1),
(9018, 8, '400250', '请选择用户', 'Хэрэглэгч сонгоно уу', 1),
(9019, 8, '400251', '该用户没有绑定手机号，请手动填写', 'Хэрэглэгч гар утасны дугаартай холбогдоогүй тул гараар бөглөнө үү', 1),
(9020, 8, '400252', '手机号格式错误', 'Гар утасны дугаарын форматын алдаа', 1),
(9021, 8, '400253', '客服已存在', 'Хэрэглэгчийн үйлчилгээ аль хэдийн бий', 1),
(9022, 8, '400254', '请输入账号', 'Дансны дугаараа оруулна уу', 1),
(9023, 8, '400255', '账号必须为数字或者字母的组合4-30位', 'Дансны дугаар нь 4-30 цифр эсвэл үсгийн хослол байх ёстой', 1),
(9024, 8, '400256', '请输入密码', 'Нууц үгээ оруулна уу', 1),
(9025, 8, '400257', '密码必须为数字或者字母的组合6-20位', 'Нууц үг нь 6-20 цифр эсвэл үсгийн хослол байх ёстой', 1),
(9026, 8, '400258', '该手机号的客服已存在', 'Энэ утасны дугаарын хэрэглэгчийн үйлчилгээ аль хэдийн байна', 1),
(9027, 8, '400259', '该客服账号已存在', 'Хэрэглэгчийн үйлчилгээний данс аль хэдийн байна', 1),
(9028, 8, '400260', '客服添加成功', 'Хэрэглэгчийн үйлчилгээг амжилттай нэмсэн', 1),
(9029, 8, '400261', '客服添加失败', 'Хэрэглэгчийн үйлчилгээг нэмж чадсангүй', 1),
(9030, 8, '400262', '客服名称不能为空', 'Хэрэглэгчийн үйлчилгээний нэр хоосон байж болохгүй', 1),
(9031, 8, '400263', '请输入确认密码', 'Баталгаажуулах нууц үгээ оруулна уу', 1),
(9032, 8, '400264', '两次输入的密码不一致', 'Хоёр удаа оруулсан нууц үгнүүд зөрчилтэй байна', 1),
(9033, 8, '400265', '用户不存在，客服将强制禁止登录', 'Хэрэглэгч байхгүй, хэрэглэгчийн үйлчилгээ нэвтрэхийг албадан хориглоно', 1),
(9034, 8, '400266', '登录的客服不存在', 'Нэвтэрсэн хэрэглэгчийн үйлчилгээ байхгүй байна', 1),
(9035, 8, '400267', '请先填写客服账号和密码再尝试进入客服平台', 'Хэрэглэгчийн үйлчилгээний платформ руу орохоосоо өмнө хэрэглэгчийн үйлчилгээний данс болон нууц үгээ бөглөнө үү', 1),
(9036, 8, '400268', '反馈内容不存在', 'Санал хүсэлтийн агуулга байхгүй', 1),
(9037, 8, '400269', '话术不能重复添加', 'Үг дахин нэмж болохгүй', 1),
(9038, 8, '400270', '创建话术成功', 'Үг амжилттай бүтээгдсэн', 1),
(9039, 8, '400271', '创建话术失败', 'Яриа үүсгэж чадсангүй', 1),
(9040, 8, '400272', '删除的话术不存在', 'Устгасан үгс байхгүй', 1),
(9041, 8, '400273', '系统分类不能删除', 'Системийн ангиллыг устгах боломжгүй', 1),
(9042, 8, '400274', '请输入配置名称', 'Тохиргооны нэрийг оруулна уу', 1),
(9043, 8, '400275', '请输入字段名称', 'Талбарын нэрийг оруулна уу', 1),
(9044, 8, '400276', '请输入配置简介', 'Тохиргооны профайлыг оруулна уу', 1),
(9045, 8, '400277', '请输入文本框的宽度', 'Текст хайрцагны өргөнийг оруулна уу', 1),
(9046, 8, '400278', '请输入正确的文本框的宽度', 'Текстийн хайрцгийн зөв өргөнийг оруулна уу', 1),
(9047, 8, '400279', '请输入多行文本框的宽度', 'Олон мөрт текстийн хайрцгийн өргөнийг оруулна уу', 1),
(9048, 8, '400280', '请输入多行文本框的高度', 'Олон мөрт текстийн хайрцгийн өндрийг оруулна уу', 1),
(9049, 8, '400281', '请输入正确的多行文本框的宽度', 'Олон мөрт текстийн хайрцгийн зөв өргөнийг оруулна уу', 1),
(9050, 8, '400282', '请输入正确的多行文本框的宽度', 'Олон мөрт текстийн хайрцгийн зөв өргөнийг оруулна уу', 1),
(9051, 8, '400283', '请输入配置参数', 'Тохиргооны параметрүүдийг оруулна уу', 1),
(9052, 8, '400284', '添加配置成功', 'Тохиргоог амжилттай нэмсэн', 1),
(9053, 8, '400285', '一二级返佣比例不能大于100%', 'Нэг ба хоёр дахь түвшний хөнгөлөлтийн харьцаа 100%-иас их байж болохгүй', 1),
(9054, 8, '400286', '分销海报不能多于5张', 'Түгээлтийн зурагт хуудас 5-аас илүү байж болохгүй', 1),
(9055, 8, '400287', '提现最低金额只能为数字', 'Мөнгө авах хамгийн бага хэмжээ нь зөвхөн тоо байж болно', 1),
(9056, 8, '400288', '满额分销最低金额不能为空', 'Бүрэн түгээлтийн доод хэмжээ хоосон байж болохгүй', 1),
(9057, 8, '400289', '满额分销最低金额不能小于0', 'Бүрэн түгээлтийн доод хэмжээ 0-ээс бага байж болохгүй', 1),
(9058, 8, '400290', '绑定有效期请填写正整数', 'Хэрэглэх хүчинтэй хугацааны эерэг бүхэл тоог бөглөнө үү', 1),
(9059, 8, '400291', '请输入标题', 'Гарчиг оруулна уу', 1),
(9060, 8, '400292', '添加配置分类成功', 'Тохиргооны ангиллыг амжилттай нэмэх', 1),
(9061, 8, '400293', '存在下级配置，无法删除', 'Дадагдах тохиргоо байгаа тул устгах боломжгүй', 1),
(9062, 8, '400294', '字段至少存在一个', 'Хамгийн багадаа нэг талбар байна', 1),
(9063, 8, '400295', '添加数据组成功', 'Өгөгдлийн бүлгийг амжилттай нэмэх', 1),
(9064, 8, '400296', '数据关键字已存在', 'Өгөгдлийн түлхүүр үг аль хэдийн байна', 1),
(9065, 8, '400297', '字段不能为空', 'Талбар хоосон байж болохгүй', 1),
(9066, 8, '400298', '不能大于四个', 'Дөрөвөөс илүүгүй', 1),
(9067, 8, '400299', '签到天数配置不能大于7天', 'Бүртгүүлэх өдрүүдийн тохиргоо 7 хоногоос илүү байж болохгүй', 1),
(9068, 8, '400300', '关联成功', 'Амжилттай холбосон', 1),
(9069, 8, '400301', '关联失败', 'Холбоо амжилтгүй боллоо', 1),
(9070, 8, '400302', '数据缓存刷新成功', 'Өгөгдлийн кэш амжилттай шинэчлэгдсэн', 1),
(9071, 8, '400303', '数据缓存刷新失败', 'Өгөгдлийн кэшийг сэргээж чадсангүй', 1),
(9072, 8, '400304', '请输入需要更换的域名', 'Орлуулах шаардлагатай домэйн нэрийг оруулна уу', 1),
(9073, 8, '400305', '域名不合法', 'Домэйн нэр буруу байна', 1),
(9074, 8, '400306', '替换成功', 'Амжилттай сольсон', 1),
(9075, 8, '400307', '初始化完成', 'Эхэлж дууслаа', 1),
(9076, 8, '400308', '备份文件可能已经损坏，请检查', 'Нөөц файл гэмтсэн байж магадгүй, шалгана уу', 1),
(9077, 8, '400309', '还原数据出错', 'Өгөгдлийг сэргээхэд алдаа гарлаа', 1),
(9078, 8, '400310', '正在还原...', 'Сэргээж байна...', 1),
(9079, 8, '400311', '还原完成', 'Сэргээж дууслаа', 1),
(9080, 8, '400312', '权益编辑成功', 'Өмчийн засвар амжилттай боллоо', 1),
(9081, 8, '400313', '卡片生成成功', 'Картыг амжилттай үүсгэсэн', 1),
(9082, 8, '400314', '手机号已经存在', 'Утасны дугаар аль хэдийн байна', 1),
(9083, 8, '400315', '请输入正确的身份证', 'Зөв ID оруулна уу', 1),
(9084, 8, '400316', '请选择分组', 'Бүлэг сонгоно уу', 1),
(9085, 8, '400317', '请选择标签', 'Шошго сонгоно уу', 1),
(9086, 8, '400318', '加入消息队列成功', 'Мессежийн дараалалд амжилттай нэгдээрэй', 1),
(9087, 8, '400319', '注销成功', 'Гаралт амжилттай', 1),
(9088, 8, '400320', '拒绝注销', 'Гарахаас татгалзсан', 1),
(9089, 8, '400321', '请输入分组名称', 'Бүлгийн нэрийг оруулна уу', 1),
(9090, 8, '400322', '会员标签不能为空', 'Гишүүдийн шошго хоосон байж болохгүй', 1),
(9091, 8, '400323', '该分类下有标签，请先删除标签', 'Энэ ангилалд шошго байна, эхлээд шошгыг устгана уу', 1),
(9092, 8, '400324', '请输入等级名称', 'Түвшингийн нэрийг оруулна уу', 1),
(9093, 8, '400325', '请输入等级', 'Түвшингээ оруулна уу', 1),
(9094, 8, '400326', '请输入等级说明', 'Түвшингийн тайлбарыг оруулна уу', 1),
(9095, 8, '400327', '请上传等级图标', 'Түвшингийн дүрсийг байршуулна уу', 1),
(9096, 8, '400328', '请上传等级背景图标', 'Түвшингийн дэвсгэр дүрсийг байршуулна уу', 1),
(9097, 8, '400329', '请输入升级经验值', 'Шинэчлэх туршлагын утгыг оруулна уу', 1),
(9098, 8, '400330', '授权成功，写入数据库失败，请检查数据库链接配置', 'Зөвшөөрөл амжилттай болсон боловч өгөгдлийн санд бичиж чадсангүй. Өгөгдлийн сангийн холбоосын тохиргоог шалгана уу', 1),
(9099, 8, '400331', '请填写公司名称', 'Компанийн нэрийг оруулна уу', 1),
(9100, 8, '400332', '请填写授权域名', 'Эрх бүхий домэйн нэрийг бөглөнө үү', 1),
(9101, 8, '400333', '请填写手机号码', 'Гар утасны дугаараа бөглөнө үү', 1),
(9102, 8, '400334', '请填写订单id', 'Захиалгын ID-г бөглөнө үү', 1),
(9103, 8, '400335', '申请授权成功', 'Зөвшөөрөл авах хүсэлтээ амжилттай өгсөн', 1),
(9104, 8, '400336', '验证码错误', 'Баталгаажуулах кодын алдаа', 1),
(9105, 8, '400337', '请选择商品', 'Бүтээгдэхүүнээ сонгоно уу', 1),
(9106, 8, '400338', '请输入商品名称', 'Бүтээгдэхүүний нэрийг оруулна уу', 1),
(9107, 8, '400339', '请选择背景图', 'Дэвсгэр зураг сонгоно уу', 1),
(9108, 8, '400340', '请输入直播价格', 'Шууд нэвтрүүлгийн үнийг оруулна уу', 1),
(9109, 8, '400341', '直播价格必须大于0', 'Шууд нэвтрүүлгийн үнэ 0-ээс их байх ёстой', 1),
(9110, 8, '400342', '请输入直播间名称', 'Шууд нэвтрүүлгийн өрөөний нэрийг оруулна уу', 1),
(9111, 8, '400343', '请选择背景图', 'Дэвсгэр зураг сонгоно уу', 1),
(9112, 8, '400344', '请选择分享图', 'Зургийг хуваалцахаар сонгоно уу', 1),
(9113, 8, '400345', '请选择主播', 'Зангуу сонгоно уу', 1),
(9114, 8, '400346', '请选择直播开始、结束时间', 'Шууд нэвтрүүлгийн эхлэх болон дуусах цагийг сонгоно уу', 1),
(9115, 8, '400347', '请填写活动简介', 'Үйл явдлын танилцуулгыг бөглөнө үү', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(9116, 8, '400348', '请填写单位', 'Нэгжийг бөглөнө үү', 1),
(9117, 8, '400349', '请选择商品轮播图', 'Бүтээгдэхүүний тойргийг сонгоно уу', 1),
(9118, 8, '400350', '您设置得商品个数超出系统限制', 'Таны тохируулсан бүтээгдэхүүний тоо системийн хязгаараас хэтэрсэн байна', 1),
(9119, 8, '400351', '模板不存在', 'Загвар байхгүй', 1),
(9120, 8, '400352', '请输入页面名称', 'Хуудасны нэрийг оруулна уу', 1),
(9121, 8, '400353', '请选择活动时间段', 'Үйл ажиллагааны хугацааг сонгоно уу', 1),
(9122, 8, '400354', '请填写购买数量限制', 'Худалдан авах үнийн хязгаарыг бөглөнө үү', 1),
(9123, 8, '400355', '购买数量限制必须大于0', 'Худалдан авах хэмжээ 0-ээс их байх ёстой', 1),
(9124, 8, '400356', '请填写帮砍次数', 'Туслах, зүсэх тоог бичнэ үү', 1),
(9125, 8, '400357', '帮砍次数必须大于0', 'Талуу зураасын тоо 0-ээс их байх ёстой', 1),
(9126, 8, '400358', '请填写砍价人数', 'Хэлэлцэх хүмүүсийн тоог бөглөнө үү', 1),
(9127, 8, '400359', '砍价人数必须大于1', 'Харилцаж буй хүмүүсийн тоо 1-ээс их байх ёстой', 1),
(9128, 8, '400360', '请选择运费模板', 'Тээвэрлэлтийн загварыг сонгоно уу', 1),
(9129, 8, '400361', '请填写商品详情', 'Бүтээгдэхүүний дэлгэрэнгүй мэдээллийг бөглөнө үү', 1),
(9130, 8, '400362', '请选择规格', 'Үзүүлэлтээ сонгоно уу', 1),
(9131, 8, '400363', '请填写虚拟拼团比例', 'Виртуал бүлгийн харьцааг бөглөнө үү', 1),
(9132, 8, '400364', '虚拟参团人数不能大于成团人数', 'Виртуал оролцогчдын тоо нь бүлгийн оролцогчдын тооноос их байж болохгүй', 1),
(9133, 8, '400365', '虚拟参团人数不能大于成团人数', 'Виртуал оролцогчдын тоо бүлгийн оролцогчдын тооноос их байж болохгүй', 1),
(9134, 8, '400366', '请填写单次购买数量', 'Нэг худалдан авалтын тоо хэмжээг бөглөнө үү', 1),
(9135, 8, '400367', '单次购买数量必须大于0', 'Нэг удаагийн худалдан авалтын тоо 0-ээс их байх ёстой', 1),
(9136, 8, '400368', '请填写成团人数', 'Бүлэгт байгаа хүмүүсийн тоог бичнэ үү', 1),
(9137, 8, '400369', '拼团人数不能小于2人', 'Бүлэгт байгаа хүмүүсийн тоо 2-оос бага байж болохгүй', 1),
(9138, 8, '400370', '请填写成团有效期', 'Бүлгийн хүчинтэй байх хугацааг бөглөнө үү', 1),
(9139, 8, '400371', '成团有效期必须大于0', 'Бүлгийн хүчинтэй хугацаа 0-ээс их байх ёстой', 1),
(9140, 8, '400372', '请填写优惠券名称', 'Купоны нэрийг бөглөнө үү', 1),
(9141, 8, '400373', '请选择商品分类', 'Бүтээгдэхүүний ангилал сонгоно уу', 1),
(9142, 8, '400374', '请填写优惠券金额', 'Купоны дүнг бөглөнө үү', 1),
(9143, 8, '400375', '请填写优惠券最小使用金额', 'Купоныг ашиглах хамгийн бага хэмжээг бөглөнө үү', 1),
(9144, 8, '400376', '请填写优惠券有效期', 'Купон хүчинтэй байх хугацааг бөглөнө үү', 1),
(9145, 8, '400377', '请选择秒杀时间段', 'Сэцлийн хугацааг сонгоно уу', 1),
(9146, 8, '400378', '请填写门店名称', 'Дэлгүүрийн нэрийг оруулна уу', 1),
(9147, 8, '400379', '请填写门店简介', 'Дэлгүүрийн профайлыг бөглөнө үү', 1),
(9148, 8, '400380', '请填写门店电话', 'Дэлгүүрийн утасны дугаарыг бөглөнө үү', 1),
(9149, 8, '400381', '请选择提货点logo', 'Татаж авах цэгийн логог сонгоно уу', 1),
(9150, 8, '400382', '请选择提货点大图', 'Татаж авах цэгийн том зургийг сонгоно уу', 1),
(9151, 8, '400383', '请选择地址', 'Хаяг сонгоно уу', 1),
(9152, 8, '400384', '请填写详细地址', 'Дэлгэрэнгүй хаягийг бөглөнө үү', 1),
(9153, 8, '400385', '请选择经纬度', 'Өргөрөг, уртраг сонгоно уу', 1),
(9154, 8, '400386', '请选择营业时间', 'Ажлын цагийг сонгоно уу', 1),
(9155, 8, '400387', '短信账号必须填写', 'SMS данс бөглөх ёстой', 1),
(9156, 8, '400388', '短信密码必须填写', 'SMS нууц үг бөглөх ёстой', 1),
(9157, 8, '400389', '订单号必须存在', 'Захиалгын дугаар байх ёстой', 1),
(9158, 8, '400390', '订单号有误', 'Захиалгын дугаар буруу байна', 1),
(9159, 8, '400391', '订单号必须为字母和数字', 'Захиалгын дугаар нь үсэг, тоо байх ёстой', 1),
(9160, 8, '400392', '订单金额必须填写', 'Захиалгын дүнг заавал бөглөх ёстой', 1),
(9161, 8, '400393', '订单金额必须为数字', 'Захиалгын дүн нь тоо байх ёстой', 1),
(9162, 8, '400394', '订单金额必须填写', 'Захиалгын дүнг заавал бөглөх ёстой', 1),
(9163, 8, '400395', '订单金额必须为数字', 'Захиалгын дүн нь тоо байх ёстой', 1),
(9164, 8, '400396', '订单邮费必须填写', 'Захиалгын шуудангийн төлбөрийг заавал бөглөх ёстой', 1),
(9165, 8, '400397', '订单邮费必须为数字', 'Захиалгын шуудангийн төлбөр нь тоо байх ёстой', 1),
(9166, 8, '400398', '赠送积分必须为数字', 'Урамшууллын оноо нь тоо байх ёстой', 1),
(9167, 8, '400399', '请选择用户头像', 'Хэрэглэгчийн аватарыг сонгоно уу', 1),
(9168, 8, '400400', '请输入公司名称', 'Компанийн нэрийг оруулна уу', 1),
(9169, 8, '400401', '添加公司成功', 'Компанийг амжилттай нэмэх', 1),
(9170, 8, '400402', '请输入月结账号', 'Сар бүрийн дансны дугаараа оруулна уу', 1),
(9171, 8, '400403', '请输入月结密码', 'Сар бүрийн нууц үгээ оруулна уу', 1),
(9172, 8, '400404', '请输入取件网点', 'Татаж авах цэгээ оруулна уу', 1),
(9173, 8, '400405', '缩略图大图尺寸（高）必须为数字', 'Өнгөрсөн зургийн хэмжээ (өндөр) тоо байх ёстой', 1),
(9174, 8, '400406', '缩略图大图尺寸（高）必须大于等于0', 'Том зургийн хэмжээ (өндөр) 0-ээс их буюу тэнцүү байх ёстой', 1),
(9175, 8, '400407', '缩略图大图尺寸（宽）必须为数字', 'Өнгөрсөн зургийн хэмжээ (өргөн) нь тоо байх ёстой', 1),
(9176, 8, '400408', '缩略图大图尺寸（宽）必须大于等于0', 'Өнгөрсөн зургийн хэмжээ (өргөн) 0-ээс их буюу тэнцүү байх ёстой', 1),
(9177, 8, '400409', '缩略图中图尺寸（高）必须为数字', 'Өнгөрсөн зурган дээрх зургийн хэмжээ (өндөр) нь тоо байх ёстой', 1),
(9178, 8, '400410', '缩略图中图尺寸（高）必须大于等于0', 'Өнгөрсөн зурган дээрх зургийн хэмжээ (өндөр) 0-ээс их буюу тэнцүү байх ёстой', 1),
(9179, 8, '400411', '缩略图中图尺寸（宽）必须为数字', 'Өнгөрсөн зурган дээрх зургийн хэмжээ (өргөн) нь тоо байх ёстой', 1),
(9180, 8, '400412', '缩略图中图尺寸（宽）必须大于等于0', 'Өнгөрсөн зурган дээрх зургийн хэмжээ (өргөн) 0-ээс их буюу тэнцүү байх ёстой', 1),
(9181, 8, '400413', '缩略图小图尺寸（高）必须为数字', 'Дөнгөж зургийн хэмжээ (өндөр) нь тоо байх ёстой', 1),
(9182, 8, '400414', '缩略图小图尺寸（高）必须大于等于0', 'Дөнгөж зургийн хэмжээ (өндөр) 0-ээс их буюу тэнцүү байх ёстой', 1),
(9183, 8, '400415', '缩略图小图尺寸（宽）必须为数字', 'Дөнгөж зургийн хэмжээ (өргөн) нь тоо байх ёстой', 1),
(9184, 8, '400416', '缩略图小图尺寸（宽）必须大于等于0', 'Дөнгөж зургийн хэмжээ (өргөн) 0-ээс их буюу тэнцүү байх ёстой', 1),
(9185, 8, '400417', '水印文字只能是汉字、字母、数字', 'Усан тэмдгийн текст нь зөвхөн хятад тэмдэгт, үсэг, тоо байж болно', 1),
(9186, 8, '400418', '水印文字长度为1-10位', 'Усан тэмдгийн текстийн урт нь 1-10 оронтой', 1),
(9187, 8, '400419', '水印文字大小必须为数字', 'Усан тэмдгийн текстийн хэмжээ нь тоо байх ёстой', 1),
(9188, 8, '400420', '水印文字大小必须大于等于0', 'Усан тэмдгийн текстийн хэмжээ 0-ээс их буюу тэнцүү байх ёстой', 1),
(9189, 8, '400421', '水印横坐标偏移量必须为数字', 'Усан тэмдгийн абсцисса офсет нь тоо байх ёстой', 1),
(9190, 8, '400422', '水印横坐标偏移量必须大于等于0', 'Усан тэмдгийн абсцисса офсет нь 0-ээс их буюу тэнцүү байх ёстой', 1),
(9191, 8, '400423', '水印纵坐标偏移量必须为数字', 'Усан тэмдгийн ординатын зөрүү нь тоо байх ёстой', 1),
(9192, 8, '400424', '水印纵坐标偏移量必须大于等于0', 'Усан тэмдгийн ординатын зөрүү нь 0-ээс их буюу тэнцүү байх ёстой', 1),
(9193, 8, '400425', '该主播已经存在', 'Хост аль хэдийн байна', 1),
(9194, 8, '400426', '请先去小程序认证主播', 'Зангууг баталгаажуулахын тулд апплет руу очно уу', 1),
(9195, 8, '400427', '商品已创建', 'Зүйл үүсгэгдсэн', 1),
(9196, 8, '400428', '审核中或审核失败不允许此操作', 'Аудит эсвэл аудитын бүтэлгүйтлийн үед энэ үйлдлийг хийхийг зөвшөөрөхгүй', 1),
(9197, 8, '400429', '在审核中或已经审核通过', 'Хянаж байгаа эсвэл батлагдсан', 1),
(9198, 8, '400430', '审核通过或失败', 'Зөвшөөрөлд тэнцсэн эсвэл амжилтгүй болсон', 1),
(9199, 8, '400431', '商品审核中，无法删除', 'Бүтээгдэхүүнийг хянаж байгаа бөгөөд устгах боломжгүй', 1),
(9200, 8, '400432', '该主播不存在', 'Зангуу байхгүй', 1),
(9201, 8, '400433', '开播时间需要在当前时间的10分钟后，并且开始时间不能在6个月后', 'Нэвтрүүлэх хугацаа нь одоогийн цагаас хойш 10 минутын дараа байх ёстой бөгөөд эхлэх цаг нь 6 сарын дараа байж болохгүй', 1),
(9202, 8, '400434', '开播时间和结束时间间隔不得短于30分钟，不得超过24小时', 'Нэвтрүүлэх цаг болон дуусах цаг хоорондын зай 30 минутаас багагүй, 24 цагаас илүүгүй байна', 1),
(9203, 8, '400435', '请输入理由', 'Шалтгааныг оруулна уу', 1),
(9204, 8, '400436', '请选择正确的直播商品', 'Зөв амьд бүтээгдэхүүнийг сонгоно уу', 1),
(9205, 8, '400437', '直播间状态有误', 'Амьдрах өрөөний төлөв буруу байна', 1),
(9206, 8, '400438', '奖品不存在', 'Шагнал байхгүй', 1),
(9207, 8, '400439', '写入中奖记录失败', 'Ялалтын бичлэгийг бичиж чадсангүй', 1),
(9208, 8, '400440', '请继续参与活动抽奖', 'Азтан шалгаруулах тэмцээнд үргэлжлүүлэн оролцоорой', 1),
(9209, 8, '400441', '已经领取成功', 'Амжилттай хүлээн авлаа', 1),
(9210, 8, '400442', '分销等级不存在', 'Тохируулгын түвшин байхгүй', 1),
(9211, 8, '400443', '选择的等级不存在', 'Сонгосон түвшин байхгүй', 1),
(9212, 8, '400444', '该等级已存在此类型任务', 'Энэ төрлийн даалгавар энэ түвшинд аль хэдийн байгаа', 1),
(9213, 8, '400445', '不能小于低等级同类型任务限定数量', 'Ижил төрлийн доод түвшний даалгавруудын хязгаарлагдмал тооноос бага байж болохгүй', 1),
(9214, 8, '400446', '不能大于高等级同类型任务限定数量', 'Энэ нь ижил төрлийн дээд түвшний даалгавруудын хязгаарлагдмал тооноос илүү байж болохгүй', 1),
(9215, 8, '400447', '解除失败', 'Арилгаж чадсангүй', 1),
(9216, 8, '400448', '代理商佣金比例不能大于事业部佣金比例', 'Агентийн шимтгэлийн харьцаа нь хэлтсийн комиссын харьцаанаас их байж болохгүй', 1),
(9217, 8, '400449', '代理商到期时间不能大于事业部到期时间', 'Төлөөлөгчийн хугацаа нь бизнесийн хэлтсийн дуусах хугацаанаас илүү байж болохгүй', 1),
(9218, 8, '400450', '请填写用户UID', 'Хэрэглэгчийн UID-г бөглөнө үү', 1),
(9219, 8, '400451', '管理员信息未查到', 'Администраторын мэдээлэл олдсонгүй', 1),
(9220, 8, '400452', '管理员已经删除', 'Администратор устгагдсан', 1),
(9221, 8, '400453', '管理员姓名不能为空', 'Администраторын нэр хоосон байж болохгүй', 1),
(9222, 8, '400454', '该分类有下级分类，无法删除', 'Энэ ангилалд дэд ангилал байгаа тул устгах боломжгүй', 1),
(9223, 8, '400455', '该分类下有文章，无法删除', 'Энэ ангилалд нийтлэлүүд байгаа бөгөөд устгах боломжгүй', 1),
(9224, 8, '400456', '请稍后查看', 'Дараа шалгана уу', 1),
(9225, 8, '400457', '默认模板不能删除', 'Өгөгдмөл загварыг устгах боломжгүй', 1),
(9226, 8, '400458', '该模板使用中，无法删除', 'Энэ загварыг ашиглаж байгаа бөгөөд устгах боломжгүй', 1),
(9227, 8, '400459', '个人中心模板不存在', 'Хувийн төвийн загвар байхгүй', 1),
(9228, 8, '400460', '反馈内容没有查到', 'Санал хүсэлтийн агуулга олдсонгүй', 1),
(9229, 8, '400461', '您修改的话术内容不存在', 'Таны өөрчилсөн үгсийн агуулга байхгүй байна', 1),
(9230, 8, '400462', '短信平台：{:msg}', 'SMS платформ: {:msg}', 1),
(9231, 8, '400463', '订单商品获取失败,无法打印', 'Захиалгын зүйлийг авч чадсангүй, хэвлэх боломжгүй', 1),
(9232, 8, '400464', '小票打印未开启', 'Баримт хэвлэхийг идэвхжүүлээгүй', 1),
(9233, 8, '400465', '请先配置小票打印开发者', 'Эхлээд төлбөрийн баримт хэвлэх хөгжүүлэгчийг тохируулна уу', 1),
(9234, 8, '400466', '请选择图片', 'Зураг сонгоно уу', 1),
(9235, 8, '400467', '配送员已存在', 'Хүргэгч аль хэдийн байгаа', 1),
(9236, 8, '400468', '同一个手机号的配送员只能添加一个', 'Зөвхөн нэг гар утасны дугаартай хүргэгчийг нэмэх боломжтой', 1),
(9237, 8, '400469', '配送员名称不能为空', 'Хүргэлтийн хүний ​​нэр хоосон байж болохгүй', 1),
(9238, 8, '400470', '订单未能查到,不能发货', 'Захиалга олдсонгүй, тээвэрлэх боломжгүй', 1),
(9239, 8, '400471', '订单已删除,不能发货', 'Захиалга устгагдсан тул тээвэрлэх боломжгүй', 1),
(9240, 8, '400472', '订单已发货请勿重复操作', 'Захиалга хүргэгдсэн тул дахин үйлдлийг бүү хий', 1),
(9241, 8, '400473', '核销订单不能发货', 'Басгах захиалгыг тээвэрлэх боломжгүй', 1),
(9242, 8, '400474', '拼团未完成暂不能发货', 'Бүлэглэл дуусаагүй тул түр тээвэрлэх боломжгүй', 1),
(9243, 8, '400475', '订单有售后申请请先处理', 'Захиалга нь борлуулалтын дараах програмтай тул эхлээд боловсруулна уу', 1),
(9244, 8, '400476', '快递公司编缺失', 'Шуудангийн компани байхгүй байна', 1),
(9245, 8, '400477', '请填写寄件人电话', 'Илгээгчийн утасны дугаарыг оруулна уу', 1),
(9246, 8, '400478', '请填写寄件人地址', 'Илгээгчийн хаягийг оруулна уу', 1),
(9247, 8, '400479', '虚拟发货，无需修改发货信息', 'Виртуал хүргэлт, хүргэлтийн мэдээллийг өөрчлөх шаардлагагүй', 1),
(9248, 8, '400480', '未发货，请先发货再修改配送信息', 'Ачилгаагүй, эхлээд ачуулаад дараа нь хүргэлтийн мэдээллийг өөрчилнө үү', 1),
(9249, 8, '400481', '自提订单无法打印', 'Өөртөө авах захиалгыг хэвлэх боломжгүй', 1),
(9250, 8, '400482', '请先发货', 'Эхлээд илгээнэ үү', 1),
(9251, 8, '400483', '请先在系统设置中打开单子面单打印开关', 'Системийн тохиргоонд нэг талт нэг талт хэвлэх унтраалгыг асаана уу', 1),
(9252, 8, '400484', '发票已申请，正在审核打印中', 'Нэхэмжлэх хүсэлт гаргасан бөгөөд хянаж, хэвлэж байна', 1),
(9253, 8, '400485', '订单已退款', 'Захиалгын төлбөрийг буцаан олгосон', 1),
(9254, 8, '400486', '正在申请退款中', 'Төлбөрийг буцаан авах хүсэлт гаргаж байна', 1),
(9255, 8, '400487', '申请失败', 'Програм амжилтгүй боллоо', 1),
(9256, 8, '400488', '未支付无法退款', 'Төлбөрийг төлөөгүй, буцаан олгох боломжгүй', 1),
(9257, 8, '400489', '回退积分和优惠券失败', 'Оноо болон купоныг буцааж чадсангүй', 1),
(9258, 8, '400490', '拼团修改失败', 'Бүлгийн өөрчлөлт амжилтгүй боллоо', 1),
(9259, 8, '400491', '回退佣金失败', 'Комиссыг буцааж чадаагүй', 1),
(9260, 8, '400492', '余额退款失败', 'Үлдэгдлийг буцааж чадсангүй', 1),
(9261, 8, '400493', '购买的优惠券已使用或者已过期', 'Худалдан авсан купон ашигласан эсвэл хугацаа нь дууссан', 1),
(9262, 8, '400494', '回退积分增加失败', 'Буцах оноог нэмэгдүүлж чадаагүй', 1),
(9263, 8, '400495', '售后订单不存在', 'Борлуулалтын дараах захиалга байхгүй', 1),
(9264, 8, '400496', '积分已退或者积分为零无法再退', 'Оноог буцаан олгосон эсвэл оноо нь тэг байвал оноог буцааж өгөх боломжгүй', 1),
(9265, 8, '400497', '未支付无法退积分', 'Төлбөр хийхгүйгээр оноог буцаан олгох боломжгүй', 1),
(9266, 8, '400498', '订单退积分失败', 'Захиалгын оноог буцааж чадсангүй', 1),
(9267, 8, '400499', '请输入拒绝退款理由', 'Төлбөрийг буцаан олгохоос татгалзах шалтгаанаа оруулна уу', 1),
(9268, 8, '400500', '限制单次购买数量不能大于总购买数量', 'Нэг худалдан авалтын хэмжээг хязгаарлах нь нийт худалдан авалтын тооноос их байж болохгүй', 1),
(9269, 8, '400501', '请添加抽奖活动名称', 'Азтан шалгаруулах тэмцээний нэрийг оруулна уу', 1),
(9270, 8, '400502', '请添加抽奖描述等文案', 'Сугалааны тайлбар болон бусад хуулбарыг оруулна уу', 1),
(9271, 8, '400503', '活动结束时间必须大于开始时间', 'Үйл явдал дуусах хугацаа эхлэх цагаас илүү байх ёстой', 1),
(9272, 8, '400504', '请添加奖品', 'Шагналаа нэмнэ үү', 1),
(9273, 8, '400505', '请填写消耗数量', 'Хэрэглээний хэмжээг бөглөнө үү', 1),
(9274, 8, '400506', '商品参与其他活动开启，无法开启预售', 'Бусад үйл ажиллагаанд барааны оролцоо идэвхжсэн, урьдчилсан борлуулалтыг нээх боломжгүй', 1),
(9275, 8, '400507', '活动结束时间不能小于当前时间', 'Үйл явдлын дуусах цаг нь одоогийн цагаас бага байж болохгүй', 1),
(9276, 8, '400508', '活动已结束,请重新添加或复制', 'Үйл явдал дууслаа, нэмж эсвэл дахин хуулна уу', 1),
(9277, 8, '400509', '添加优惠券成功', 'Купоныг амжилттай нэмлээ', 1),
(9278, 8, '400510', '发布优惠劵成功', 'Купон амжилттай олгогдлоо', 1),
(9279, 8, '400511', '砍价最低价不能大于或等于起始金额', 'Хэлэлцээний хамгийн бага үнэ нь анхны үнийн дүнгээс их буюу тэнцүү байж болохгүй', 1),
(9280, 8, '400512', '砍价人数不能大于{:num}人', 'Хэлэлцдэг хүмүүсийн тоо {:num}-аас их байж болохгүй', 1),
(9281, 8, '400513', '使用开始时间不能小于领取开始时间', 'Ашиглаж эхлэх хугацаа нь цуглуулах хугацаанаас бага байж болохгүй', 1),
(9282, 8, '400514', '使用结束时间不能小于领取结束时间', 'Ашиглалтын эцсийн хугацаа нь цуглуулах хугацаанаас бага байж болохгүй', 1),
(9283, 8, '400515', '优惠券不存在', 'Купон байхгүй', 1),
(9284, 8, '400516', '领取的优惠劵已领完或已过期', 'Хүлээн авсан купонууд хүлээн авсан эсвэл хугацаа нь дууссан', 1),
(9285, 8, '400517', '已领取过该优惠劵', 'Купоныг хүлээн авлаа', 1),
(9286, 8, '400518', '抱歉，优惠券已经领取完了', 'Уучлаарай, купонуудыг цуглуулсан', 1),
(9287, 8, '400519', '选择用户已拥有该优惠券，请勿重复发放', 'Купоныг аль хэдийн эзэмшиж байгаа хэрэглэгчийг сонго, дахин дахин бүү гаргаарай', 1),
(9288, 8, '400520', '订单已删除', 'Захиалга устсан', 1),
(9289, 8, '400521', '订单已发货', 'Захиалга хүргэгдсэн', 1),
(9290, 8, '400522', '暂时不支持其他发货类型', 'бусад төрлийн хүргэлтийг түр хугацаанд дэмждэггүй', 1),
(9291, 8, '400523', '请输入送货人姓名', 'Хүргэх хүний ​​нэрийг оруулна уу', 1),
(9292, 8, '400524', '请输入送货人电话号码', 'Хүргээгчийн утасны дугаарыг оруулна уу', 1),
(9293, 8, '400525', '请输入送货人信息', 'Хүргэх хүний ​​мэдээллийг оруулна уу', 1),
(9294, 8, '400526', '请输入正确的送货人电话号码', 'Хүргэгчийн утасны дугаарыг зөв оруулна уу', 1),
(9295, 8, '400527', '请选择电子面单模板', 'Цахим нүүр хуудасны загварыг сонгоно уу', 1),
(9296, 8, '400528', '电子面单已关闭，请选择其他发货方式', 'Цахим тооцоо хаагдсан тул өөр тээвэрлэлтийн аргыг сонгоно уу', 1),
(9297, 8, '400529', '发货失败', 'Тээвэрлэлт амжилтгүй боллоо', 1),
(9298, 8, '400530', '订单状态错误', 'Захиалгын төлөвийн алдаа', 1),
(9299, 8, '400531', '请输入快递单号', 'Шуудангийн дугаараа оруулна уу', 1),
(9300, 8, '400532', '请先发货再修改配送信息', 'Эхлээд тээвэрлэж, дараа нь хүргэлтийн мэдээллийг өөрчилнө үү', 1),
(9301, 8, '400533', '商品不存在', 'Бараа байхгүй', 1),
(9302, 8, '400534', '您查看的积分商品已被删除', 'Таны үзсэн бүтээгдэхүүн устгагдсан', 1),
(9303, 8, '400535', '请添加商品', 'Бүтээгдэхүүн нэмнэ үү', 1),
(9304, 8, '400536', '添加抽奖活动失败', 'Сугалааны арга хэмжээг нэмж чадсангүй', 1),
(9305, 8, '400537', '抽奖活动不存在', 'Сугалаа байхгүй', 1),
(9306, 8, '400538', '请填写奖品名称', 'Шагналын нэрийг бөглөнө үү', 1),
(9307, 8, '400539', '请选择奖品图片', 'Шагналын зургийг сонгоно уу', 1),
(9308, 8, '400540', '请填写奖品中奖权重', 'Шагналын жинг бөглөнө үү', 1),
(9309, 8, '400541', '请选择奖品类型', 'Шагналын төрлийг сонгоно уу', 1),
(9310, 8, '400542', '请填写奖品赠送{:type}数', 'Өгөгдсөн шагналын {:type} тоог бөглөнө үү', 1),
(9311, 8, '400543', '请选择优惠券', 'Купон сонгоно уу', 1),
(9312, 8, '400544', '生成新订单失败', 'Шинэ захиалга үүсгэж чадсангүй', 1),
(9313, 8, '400545', '修改原来订单商品拆分状态失败', 'Эх захиалгын зүйлийн хуваагдлын төлөвийг өөрчилж чадсангүй', 1),
(9314, 8, '400546', '新增拆分订单商品信息失败', 'Хуваах захиалгад бүтээгдэхүүний мэдээллийг нэмж чадсангүй', 1),
(9315, 8, '400547', '保存新订单商品信息失败', 'Шинэ захиалгын бүтээгдэхүүний мэдээллийг хадгалж чадсангүй', 1),
(9316, 8, '400548', '协议类型缺失', 'Протоколын төрөл дутуу', 1),
(9317, 8, '400549', '请填写协议名称', 'Гэрээний нэрийг оруулна уу', 1),
(9318, 8, '400550', '请填写协议内容', 'Гэрээний агуулгыг бөглөнө үү', 1),
(9319, 8, '400551', '该类型协议已经存在', 'Энэ төрлийн протокол аль хэдийн байгаа', 1),
(9320, 8, '400552', '临时二维码获取错误', 'Түр зуурын QR код авах алдаа', 1),
(9321, 8, '400553', '永久二维码获取错误', 'Байнгын QR код олж авахад алдаа гарсан', 1),
(9322, 8, '400554', '请先配置接口密钥', 'Эхлээд интерфэйсийн түлхүүрийг тохируулна уу', 1),
(9323, 8, '400555', '无法创建文件夹，请检查您的上传目录权限', 'Фолдер үүсгэх боломжгүй байна, байршуулах лавлах зөвшөөрлөө шалгана уу', 1),
(9324, 8, '400556', '商品参数错误', 'Барааны параметрийн алдаа', 1),
(9325, 8, '400557', '上传方式错误', 'Байршуулах арга буруу', 1),
(9326, 8, '400558', '格式错误', 'Форматын алдаа', 1),
(9327, 8, '400559', '图片流获取失败', 'Зургийн дамжуулалтыг авч чадсангүй', 1),
(9328, 8, '400560', '商品详情保存失败', 'Бүтээгдэхүүний дэлгэрэнгүй мэдээллийг хадгалж чадсангүй', 1),
(9329, 8, '400561', '关联优惠券失败', 'Купоныг холбож чадсангүй', 1),
(9330, 8, '400562', '缺少商品ID', 'Бүтээгдэхүүний ID дутуу', 1),
(9331, 8, '400563', '缺少用户UID', 'Хэрэглэгчийн UID дутуу байна', 1),
(9332, 8, '400564', '缺少订单ID', 'Захиалгын ID дутуу', 1),
(9333, 8, '400565', '暂不支持该类型记录', 'Энэ төрлийн бичлэгийг одоогоор дэмждэггүй', 1),
(9334, 8, '400566', '添加商品记录失败', 'Бүтээгдэхүүний бүртгэлийг нэмж чадсангүй', 1),
(9335, 8, '400567', '评论时间应小于当前时间', 'Сэтгэгдэл бичих хугацаа одоогийн цагаас бага байх ёстой', 1),
(9336, 8, '400568', '添加虚拟评论失败', 'Виртуал сэтгэгдэл нэмж чадсангүй', 1),
(9337, 8, '400569', '回复失败', 'Хариулж чадсангүй', 1),
(9338, 8, '400570', '请选择限购类型', 'Худалдан авалтын хязгаарлалтын төрлийг сонгоно уу', 1),
(9339, 8, '400571', '限购数量不能小于1', 'Худалдан авах хязгаар 1-ээс бага байж болохгүй', 1),
(9340, 8, '400572', '一二级返佣相加不能大于商品售价', 'Нэг ба хоёрдугаар түвшний хөнгөлөлтийн нийлбэр нь бүтээгдэхүүний үнээс их байж болохгүй', 1),
(9341, 8, '400573', '商品类型不能切换', 'Бүтээгдэхүүний төрлийг солих боломжгүй', 1),
(9342, 8, '400574', '请输入规则名称', 'Дүрмийн нэрийг оруулна уу', 1),
(9343, 8, '400575', '请输入属性名称', 'Атрибутын нэрийг оруулна уу', 1),
(9344, 8, '400576', '请输入正确的属性', 'Зөв шинж чанарыг оруулна уу', 1),
(9345, 8, '400577', '请填写正确的商品信息', 'Бүтээгдэхүүний мэдээллийг зөв бөглөнө үү', 1),
(9346, 8, '400578', '请填写正确的商品价格', 'Бүтээгдэхүүний үнийг зөв бөглөнө үү', 1),
(9347, 8, '400579', '请填写正确的商品库存', 'Бүтээгдэхүүний бүртгэлийг зөв бөглөнө үү', 1),
(9348, 8, '400580', '请填写正确的商品成本价格', 'Барааны өртгийн үнийг зөв бөглөнө үү', 1),
(9349, 8, '400581', '请上传商品图片', 'Бүтээгдэхүүний зургийг оруулна уу', 1),
(9350, 8, '400582', '{:name}规格不存在', '{:name} тодорхойлолт байхгүй', 1),
(9351, 8, '400583', '{:name}属性不存在', '{:name} атрибут байхгүй', 1),
(9352, 8, '400584', '请设置至少一个属性', 'Ядаж нэг атрибут тохируулна уу', 1),
(9353, 8, '400585', '商品参与秒杀活动开启，无法进行此操作', 'Баяжуулалтын үйл ажиллагаанд барааны оролцоо идэвхжсэн, энэ үйлдлийг гүйцэтгэх боломжгүй', 1),
(9354, 8, '400586', '商品参与砍价活动开启，无法进行此操作', 'Хэлэлцээнд барааны оролцоо идэвхжсэн, энэ үйлдлийг гүйцэтгэх боломжгүй', 1),
(9355, 8, '400587', '商品参与拼团活动开启，无法进行此操作', 'Бүлгийн үйл ажиллагаанд барааны оролцоо идэвхжсэн, энэ үйлдлийг гүйцэтгэх боломжгүй', 1),
(9356, 8, '400588', '会员价格不能为0', 'Гишүүдийн үнэ 0 байж болохгүй', 1),
(9357, 8, '400589', '虚拟优惠券商品请选择优惠券', 'Виртуал купоны бүтээгдэхүүний купон сонгоно уу', 1),
(9358, 8, '400590', '卡号：{:key}密码：{:value}，已经添加过，请重新添加卡密', 'Картын дугаар: {:key} Нууц үг: {:value}, нэмэгдсэн байна, картын түлхүүрийг дахин нэмнэ үү', 1),
(9359, 8, '400591', '缺少城市id无法保存', 'Хотын id байхгүй тул хадгалах боломжгүй', 1),
(9360, 8, '400592', '修改的模板不存在', 'Өөрчлөгдсөн загвар байхгүй байна', 1),
(9361, 8, '400593', '指定区域邮费添加失败', 'Заасан хэсэгт шуудангийн мөнгө нэмж чадсангүй', 1),
(9362, 8, '400594', '管理员不存在', 'Администратор байхгүй', 1),
(9363, 8, '400595', '您已被禁止登录', 'Та нэвтрэхийг хориглосон', 1),
(9364, 8, '400596', '管理员账号已存在', 'Администраторын бүртгэл аль хэдийн байна', 1),
(9365, 8, '400597', '原始密码错误', 'Эх нууц үгийн алдаа', 1),
(9366, 8, '400598', '请输入新密码', 'Шинэ нууц үг оруулна уу', 1),
(9367, 8, '400599', '请选择要删除的图片', 'Устгах зургаа сонгоно уу', 1),
(9368, 8, '400600', '移动失败或不能重复移动到同一分类下', 'Зөөж чадсангүй эсвэл нэг ангилалд дахин дахин шилжүүлэх боломжгүй', 1),
(9369, 8, '400601', '请求不被允许', 'Хүсэлтийг зөвшөөрөхгүй', 1),
(9370, 8, '400602', '设置类目不被允许', 'Ангилал тогтоохыг зөвшөөрөхгүй', 1),
(9371, 8, '400603', '请输入正确格式的配置参数', 'Тохиргооны параметрүүдийг зөв форматаар оруулна уу', 1),
(9372, 8, '400604', '{:name}请输入默认值', '{:name} өгөгдмөл утгыг оруулна уу', 1),
(9373, 8, '400605', '{:name}请输入正确url', '{:name} зөв url оруулна уу', 1),
(9374, 8, '400606', '保存wss证书失败', 'WSS сертификатыг хадгалж чадсангүй', 1),
(9375, 8, '400607', '{:name}不能为空', '{:name} хоосон байж болохгүй', 1),
(9376, 8, '400608', '删除的云存储不存在', 'Устгасан үүл хадгалах сан байхгүй', 1),
(9377, 8, '400609', '云存储正在使用中,需要启动其他空间才能删除', 'Үүлэн санах ойг ашиглаж байгаа бөгөөд бусад зайг устгахын тулд идэвхжүүлэх шаардлагатай', 1),
(9378, 8, '400610', '云空间名称不能重复', 'Үүлэн орон зайн нэрийг давтах боломжгүй', 1),
(9379, 8, '400611', '没有权限', 'Зөвшөөрөлгүй', 1),
(9380, 8, '400612', '替换失败,失败原因:{:msg}', 'Солилт амжилтгүй болсон, бүтэлгүйтлийн шалтгаан: {:msg}', 1),
(9381, 8, '400613', '请先删除改菜单下的子菜单', 'Эхлээд цэсний доорх дэд цэсийг устгана уу', 1),
(9382, 8, '400614', '请填写批次名称', 'Багцын нэрийг бөглөнө үү', 1),
(9383, 8, '400615', '请填写要生成卡的数量', 'Үйлдвэрлэх картын тоог бөглөнө үү', 1),
(9384, 8, '400616', '卡片数量只能为正整数', 'Картын тоо зөвхөн эерэг бүхэл тоо байж болно', 1),
(9385, 8, '400617', '单次制卡数量最高不得超过6000张', 'Нэг удаад үйлдвэрлэсэн картын дээд хэмжээ 6000-аас хэтрэхгүй байх ёстой', 1),
(9386, 8, '400618', '请填写免费使用天数', 'Үнэгүй ашиглалтын өдрийн тоог бөглөнө үү', 1),
(9387, 8, '400619', '免费使用天数只能为正整数', 'Үнэгүй хэрэглээний өдрийн тоо зөвхөн эерэг бүхэл тоо байж болно', 1),
(9388, 8, '400620', '生成卡失败', 'Карт үүсгэж чадсангүй', 1),
(9389, 8, '400621', '会员功能暂未开启', 'Гишүүн функц хараахан нээгдээгүй байна', 1),
(9390, 8, '400622', '请输入会员卡号', 'Гишүүнчлэлийн картын дугаараа оруулна уу', 1),
(9391, 8, '400623', '请输入领取卡密', 'Картын нууц үгээ оруулна уу', 1),
(9392, 8, '400624', '会员卡不存在', 'Гишүүнчлэлийн карт байхгүй', 1),
(9393, 8, '400625', '会员卡未激活，暂无法使用', 'Гишүүнчлэлийн карт идэвхжээгүй тул түр ашиглах боломжгүй', 1),
(9394, 8, '400626', '会员卡密码有误', 'Гишүүнчлэлийн картын нууц үг буруу байна', 1),
(9395, 8, '400627', '会员卡已使用', 'Гишүүнчлэлийн картыг ашигласан', 1),
(9396, 8, '400628', '您已是永久会员，无需再领取，可以将此卡转送亲朋好友，一起享受优惠', 'Та байнгын гишүүн болсон тул цаашид авах шаардлагагүй, та энэ картыг найз нөхөд, хамаатан садандаа шилжүүлж хөнгөлөлт эдлэх боломжтой', 1),
(9397, 8, '400629', '暂无此类型会员卡', 'Одоогоор ийм төрлийн гишүүнчлэлийн карт байхгүй', 1),
(9398, 8, '400630', '会员权益类型缺失', 'Гишүүнчлэлийн тэтгэмжийн төрөл байхгүй', 1),
(9399, 8, '400631', '请设置权益名称', 'Өмчийн нэрийг тохируулна уу', 1),
(9400, 8, '400632', '请上传会员权益图标', 'Гишүүдийн эрхийн дүрсийг байршуулна уу', 1),
(9401, 8, '400633', '请设置返还积分倍数', 'Буцах цэгүүдийг олон болгож тохируулна уу', 1),
(9402, 8, '400634', '返还积分倍数不能为负数', 'Буцах цэгийн олон тоо сөрөг байж болохгүй', 1),
(9403, 8, '400635', '请设置运费折扣', 'Тээвэрлэлтийн хөнгөлөлтийг тохируулна уу', 1),
(9404, 8, '400636', '运费折扣不能为负数', 'Тээвэрлэлтийн хөнгөлөлт сөрөг байж болохгүй', 1),
(9405, 8, '400637', '请设置签到积分倍数', 'Бүртгүүлэх цэгийг олон болгож тохируулна уу', 1),
(9406, 8, '400638', '签到积分倍数不能为负数', 'Нэвтрэх олон цэг сөрөг байж болохгүй', 1),
(9407, 8, '400639', '请设置线下付款折扣', 'Офлайн төлбөрийн хөнгөлөлтийг тохируулна уу', 1),
(9408, 8, '400640', '线下付款不能为负数', 'Оффлайн төлбөр сөрөг байж болохгүй', 1),
(9409, 8, '400641', '请填写会员卡名称', 'Гишүүнчлэлийн үнэмлэхний нэрийг бөглөнө үү', 1),
(9410, 8, '400642', '会员卡类型缺失', 'Гишүүнчлэлийн картын төрөл дутуу', 1),
(9411, 8, '400643', '请填写有效期（天）', 'Хэрэглэх хугацааг (өдөр) бөглөнө үү', 1),
(9412, 8, '400644', '有效期（天）不能为负数', 'Хэрэглэх хугацаа (өдөр) сөрөг байж болохгүй', 1),
(9413, 8, '400645', '请填写价格', 'Үнэ бөглөнө үү', 1),
(9414, 8, '400646', '价格不能为负数', 'Үнэ сөрөг байж болохгүй', 1),
(9415, 8, '400647', '优惠价不能大于原价', 'Хөнгөлөлттэй үнэ нь анхны үнээс их байж болохгүй', 1),
(9416, 8, '400648', '地址不存在', 'Хаяг байхгүй', 1),
(9417, 8, '400649', '取消原来默认地址失败', 'Анхны өгөгдмөл хаягийг цуцалж чадсангүй', 1),
(9418, 8, '400650', '设置默认地址失败', 'Өгөгдмөл хаягийг тохируулж чадсангүй', 1),
(9419, 8, '400651', '地址已存在', 'Хаяг аль хэдийн байна', 1),
(9420, 8, '400652', '收货地址格式错误', 'Хүргэх хаягийн формат буруу байна', 1),
(9421, 8, '400653', '请登录', 'Нэвтэрнэ үү', 1),
(9422, 8, '400654', '登录已过期,请重新登录', 'Нэвтрэх хугацаа дууссан тул дахин нэвтэрнэ үү', 1),
(9423, 8, '400655', '增加记录失败', 'Бичлэг нэмж чадсангүй', 1),
(9424, 8, '400656', '记录分享记录失败', 'Бичлэг хуваалцах бичлэг амжилтгүй боллоо', 1),
(9425, 8, '400657', '增加用户佣金失败', 'Хэрэглэгчийн хураамжийг нэмэгдүүлж чадсангүй', 1),
(9426, 8, '400658', '企业付款到零钱失败，请稍后再试', 'Компани өөрчлөлтийг төлж чадсангүй, дараа дахин оролдоно уу', 1),
(9427, 8, '400659', '已经提现', 'Аль хэдийн татагдсан', 1),
(9428, 8, '400660', '您的提现申请已被拒绝', 'Таны мөнгө татах хүсэлтийг татгалзсан', 1),
(9429, 8, '400661', '可提现佣金不足', 'Бэлэн мөнгө авахад шимтгэл хангалтгүй', 1),
(9430, 8, '400662', '提现金额不能小于{:money}元', 'Татан авалтын дүн {:money} юаниас бага байж болохгүй', 1),
(9431, 8, '400663', '提现佣金不足{:money}元', 'Татан авалтын комисс {:money} юань хангалтгүй байна', 1),
(9432, 8, '400664', '提现佣金大于0', 'Татан авалтын комисс 0-ээс их', 1),
(9433, 8, '400665', '企业微信付款到零钱最低金额为1元', 'Аж ахуйн нэгжийн WeChat төлбөр нь 1 юань болсныг өөрчлөх', 1),
(9434, 8, '400666', '该分组已经存在', 'Бүлэг аль хэдийн бий', 1),
(9435, 8, '400667', '清空用户标签失败', 'Хэрэглэгчийн шошгыг арилгаж чадсангүй', 1),
(9436, 8, '400668', '设置标签失败', 'Шошго тохируулж чадсангүй', 1),
(9437, 8, '400669', '请选择标签分类', 'Шошгоны ангиллыг сонгоно уу', 1),
(9438, 8, '400670', '该标签已经存在', 'Шошго аль хэдийн байна', 1),
(9439, 8, '400671', '修改用户等级信息失败', 'Хэрэглэгчийн түвшний мэдээллийг өөрчилж чадсангүй', 1),
(9440, 8, '400672', '用户等级不存在', 'Хэрэглэгчийн түвшин байхгүй', 1),
(9441, 8, '400673', '用户等级经验必须大于上一等级设置的经验', 'Хэрэглэгчийн түвшний туршлага нь өмнөх түвшнийхээс илүү байх ёстой', 1),
(9442, 8, '400674', '用户等级经验必须小于下一等级设置的经验', 'Хэрэглэгчийн түвшний туршлага нь дараагийн түвшний туршлагаас бага байх ёстой', 1),
(9443, 8, '400675', '已检测到您设置过的用户等级，此等级不可重复', 'Таны тохируулсан хэрэглэгчийн түвшин илэрсэн, энэ түвшинг давтах боломжгүй', 1),
(9444, 8, '400676', '已检测到您设置过该用户等级经验值，经验值不可重复', 'Та энэ хэрэглэгчийн түвшний туршлагын утгыг тохируулсан нь тогтоогдлоо, туршлагын утгыг давтах боломжгүй', 1),
(9445, 8, '400677', '订单未支付', 'Захиалга төлөөгүй', 1),
(9446, 8, '400678', '佣金转入余额，不能退款', 'Комисс нь үлдэгдэл рүү шилжсэн тул буцаан олгох боломжгүй', 1),
(9447, 8, '400679', '已支付的订单记录无法删除', 'Төлбөртэй захиалгын бүртгэлийг устгах боломжгүй', 1),
(9448, 8, '400680', '转入金额不能大于可提现佣金', 'Шилжүүлгийн дүн нь татан авч болох шимтгэлээс их байж болохгүй', 1),
(9449, 8, '400681', '写入余额充值失败', 'Үлдэгдлийг цэнэглэж чадсангүй', 1),
(9450, 8, '400682', '您选择的充值方式已下架', 'Таны сонгосон цэнэглэх аргыг устгасан', 1),
(9451, 8, '400683', '充值订单生成失败', 'Цэнэглэх захиалга үүсгэж чадсангүй', 1),
(9452, 8, '400684', '保存用户信息失败', 'Хэрэглэгчийн мэдээллийг хадгалж чадсангүй', 1),
(9453, 8, '400685', '密码重置失败', 'Нууц үг дахин тохируулж чадсангүй', 1),
(9454, 8, '400686', '增加推广人数失败', 'Урамшууллын тоог нэмэгдүүлж чадсангүй', 1),
(9455, 8, '400687', '设置登录类型失败', 'Нэвтрэх төрлийг тохируулж чадсангүй', 1),
(9456, 8, '400688', '设置推广员失败', 'Дэмжигчийг тохируулж чадсангүй', 1),
(9457, 8, '400689', '增加用户余额失败', 'Хэрэглэгчийн үлдэгдлийг нэмэгдүүлж чадсангүй', 1),
(9458, 8, '400690', '减少用户余额失败', 'Хэрэглэгчийн үлдэгдлийг бууруулж чадсангүй', 1),
(9459, 8, '400691', '减少用户佣金失败', 'Хэрэглэгчийн хураамжийг бууруулж чадсангүй', 1),
(9460, 8, '400692', '增加用户积分失败', 'Хэрэглэгчийн оноог нэмэгдүүлж чадсангүй', 1),
(9461, 8, '400693', '减少用户积分失败', 'Хэрэглэгчийн оноог багасгаж чадсангүй', 1),
(9462, 8, '400694', '增加用户经验失败', 'Хэрэглэгчийн туршлагыг нэмэгдүүлж чадаагүй', 1),
(9463, 8, '400695', '减少用户经验失败', 'Хэрэглэгчийн туршлагыг бууруулж чадаагүй', 1),
(9464, 8, '400696', '该分组不存在', 'Бүлэг байхгүй', 1),
(9465, 8, '400697', '设置分组失败或无改动', 'Бүлэглэлтийг тохируулаагүй эсвэл өөрчлөлт ороогүй', 1),
(9466, 8, '400698', '有标签不存在或被删除', 'Шошго байхгүй эсвэл устгагдсан', 1),
(9467, 8, '400699', '等级不存在或被删除', 'Анги байхгүй эсвэл устгагдсан', 1),
(9468, 8, '400700', '此用户已有该用户等级，无法再次赠送', 'Энэ хэрэглэгч аль хэдийн энэ хэрэглэгчийн түвшнийг эзэмшсэн бөгөөд дахин өгөх боломжгүй', 1),
(9469, 8, '400701', '赠送天数不能为0', 'Бэлгийн өдрүүд 0 байж болохгүй', 1),
(9470, 8, '400702', '天数输入错误', 'Өдрийн тоог буруу оруулсан', 1),
(9471, 8, '400703', '用户信息储存失败', 'Хэрэглэгчийн мэдээллийг хадгалж чадсангүй', 1),
(9472, 8, '400704', '您得ip不再白名单中,请前往腾讯微信公众平台添加ip白名单', 'Таны IP цагаан жагсаалтад байхаа больсон тул Tencent WeChat нийтийн платформ руу орж, IP-г цагаан жагсаалтад нэмнэ үү', 1),
(9473, 8, '400705', '您填写得appid无效,请检查', 'Таны бөглөсөн програм буруу байна, шалгана уу', 1),
(9474, 8, '400706', '请输入回复信息内容', 'Хариу мессежийн агуулгыг оруулна уу', 1),
(9475, 8, '400707', '请上传回复的图片', 'Хариултын зургийг оруулна уу', 1),
(9476, 8, '400708', '请上传回复的声音', 'Хариулт дуу хоолойг оруулна уу', 1),
(9477, 8, '400709', '请选择图文消息', 'Мессеж сонгоно уу', 1),
(9478, 8, '400710', '对应的uid不存在', 'Харгалзах uid байхгүй', 1),
(9479, 8, '400711', '取消关注失败', 'Дагахаа болих амжилтгүй', 1),
(9480, 8, '400712', '电子面单模板ID缺失', 'Цахим нүүр хуудасны загварын ID дутуу байна', 1),
(9481, 8, '400713', '快递公司编码缺失', 'Шуудангийн компанийн код дутуу байна', 1),
(9482, 8, '400714', '寄件人信息缺失', 'Илгээгчийн мэдээлэл дутуу байна', 1),
(9483, 8, '400715', '收件人信息缺失', 'Хүлээн авагчийн мэдээлэл дутуу байна', 1),
(9484, 8, '400716', '云打印机编号缺失', 'Cloud принтерийн дугаар дутуу байна', 1),
(9485, 8, '400717', '商品数量缺失', 'Барааны тоо дутуу байна', 1),
(9486, 8, '400718', '获取access_token获取失败', 'Хандалтын_токен авч чадсангүй', 1),
(9487, 8, '400719', '手机号不能为空', 'Гар утасны дугаар хоосон байж болохгүй', 1),
(9488, 8, '400720', '模版ID不存在', 'Загвар ID байхгүй', 1),
(9489, 8, '400721', '请先配置accessKey和secretKey', 'Эхлээд accessKey болон secretKey-г тохируулна уу', 1),
(9490, 8, '400722', '请先配置水印图片', 'Эхлээд усан тэмдгийн зургийг тохируулна уу', 1),
(9491, 8, '400723', '请先配置水印文字', 'Эхлээд усан тэмдгийн текстийг тохируулна уу', 1),
(9492, 8, '400724', '远程水印图片下载失败', 'Алсын усан тэмдгийн зургийг татаж чадсангүй', 1),
(9493, 8, '400725', '上传图片不存在', 'Байршуулсан зураг байхгүй', 1),
(9494, 8, '400726', '图片流获取失败', 'Зургийн дамжуулалтыг авч чадсангүй', 1),
(9495, 8, '400727', '图片下载失败', 'Зургийг татаж чадсангүй', 1),
(9496, 8, '400728', '必须上传xlsx格式文件', 'Xlsx форматтай файл байршуулах ёстой', 1),
(9497, 8, '400729', '数据不能为空', 'Өгөгдөл хоосон байж болохгүй', 1),
(9498, 8, '400730', '缺少pay_price', 'Төлбөрийн үнэ дутуу', 1),
(9499, 8, '400731', '退款失败:{:msg}', 'Төлбөрийг буцааж чадсангүй: {:msg}', 1),
(9500, 8, '400732', '获取微信粉丝信息失败', 'WeChat фэнүүдийн мэдээллийг авч чадсангүй', 1),
(9501, 8, '400733', '您已关闭上传功能', 'Та байршуулах функцийг унтраасан байна', 1),
(9502, 8, '400734', '文件不可写', 'Файлыг бичих боломжгүй', 1),
(9503, 8, '400735', '时间格式不正确', 'Цагийн формат буруу байна', 1),
(9504, 8, '400736', '文件可能损坏，请检查', 'Файл гэмтсэн байж магадгүй, шалгана уу', 1),
(9505, 8, '400737', '修复错误，请重试', 'Алдааг зас, дахин оролдоно уу', 1),
(9506, 8, '400738', '请指定要修复的表', 'Засварлах ширээг зааж өгнө үү', 1),
(9507, 8, '400739', '请配置支付证书', 'Төлбөрийн гэрчилгээг тохируулна уу', 1),
(9508, 8, '400740', '只支持两级分类', 'Зөвхөн хоёр түвшний ангиллыг дэмжинэ', 1),
(9509, 8, '400741', '运费格式错误', 'Ачааны форматын алдаа', 1),
(9510, 8, '400742', '请检查属性编码或库存数量', 'Атрибутын код эсвэл хувьцааны хэмжээг шалгана уу', 1),
(9511, 8, '400743', '同步条数不能超过100', 'Синхрончлолын мөрний тоо 100-аас хэтрэхгүй', 1),
(9512, 8, '400744', 'appid或appsecret错误', 'appid эсвэл appsecret алдаа', 1),
(9513, 8, '400745', '父级ID参数类型错误', 'Эцэг эхийн ID параметрийн төрөл буруу байна', 1),
(9514, 8, '400746', '分类名称长度不能超过25个字符', 'Ангиллын нэрийн урт 25 тэмдэгтээс хэтрэхгүй', 1),
(9515, 8, '400747', '分类图标长度不能超过128个字符', 'Ангиллын дүрсний урт 128 тэмдэгтээс хэтрэхгүй', 1),
(9516, 8, '400748', '分类大图长度不能超过200个字符', 'Том ангилсан зургийн урт 200 тэмдэгтээс хэтрэхгүй', 1),
(9517, 8, '400749', '排序参数类型错误', 'Ангилах параметрийн төрөл буруу байна', 1),
(9518, 8, '400750', '排序不能小于0', 'Ангилах нь 0-ээс бага байж болохгүй', 1),
(9519, 8, '400751', '状态必须是0-1之间的整数', 'Төлөв 0-1 хооронд бүхэл тоо байх ёстой', 1),
(9520, 8, '400752', '权益简介不能大于8个字', 'Эрх, ашиг сонирхлын танилцуулга 8 үгээс илүү байж болохгүй', 1),
(9521, 8, '400753', '提现方式最少选一种', 'Хамгийн багадаа нэг мөнгө авах аргыг сонго', 1),
(9522, 8, '400754', '身份使用中，无法删除', 'Таниулалтыг ашиглаж байгаа бөгөөд устгах боломжгүй', 1),
(9523, 8, '400755', '展示名称不能大于6个字', 'Дэлгэцийн нэр 6 тэмдэгтээс урт байж болохгүй', 1),
(9524, 8, '400756', '推广佣金单价不能小于0', 'Урамшууллын комиссын нэгж үнэ 0-ээс бага байж болохгүй', 1),
(9525, 8, '400757', '每日推广佣金上限不能小于-1', 'Өдөр тутмын урамшууллын шимтгэлийн хязгаар -1-ээс бага байж болохгүй', 1),
(9526, 8, '400758', '请核对领取方式', 'Цуглуулах аргыг шалгана уу', 1),
(9527, 8, '400759', '请输入优惠券名称', 'Купоны нэрийг оруулна уу', 1),
(9528, 8, '400760', '请输入真实姓名', 'Жинхэнэ нэрээ оруулна уу', 1),
(9529, 8, '400761', '描述内容不能超过120字', 'Тайлбарын агуулга 120 тэмдэгтээс хэтрэхгүй', 1),
(9530, 8, '400762', '账号密码必须是在6到32位之间', 'Бүртгэлийн нууц үг 6-32 оронтой байх ёстой', 1),
(9531, 8, '400763', '商户号不能为空', 'Худалдааны дугаар хоосон байж болохгүй', 1),
(9532, 8, '410000', '请输入账号和密码', 'Дансны дугаар болон нууц үгээ оруулна уу', 1),
(9533, 8, '410001', '登录成功', 'Нэвтрэх амжилттай', 1),
(9534, 8, '410002', '退出成功', 'Амжилттай гарлаа', 1),
(9535, 8, '410003', '发送验证码失败,请刷新页面重新获取', 'Баталгаажуулах кодыг илгээж чадсангүй, дахин авахын тулд хуудсыг сэргээнэ үү', 1),
(9536, 8, '410004', '请输入验证码', 'Баталгаажуулах кодыг оруулна уу', 1),
(9537, 8, '410005', '验证码输入有误', 'Баталгаажуулах кодыг буруу оруулсан', 1),
(9538, 8, '410006', '验证码已发送', 'Баталгаажуулах код илгээгдсэн', 1),
(9539, 8, '410007', '验证码发送成功', 'Баталгаажуулах кодыг амжилттай илгээсэн', 1),
(9540, 8, '410008', '验证码发送失败', 'Баталгаажуулах кодыг илгээж чадсангүй', 1),
(9541, 8, '410009', '请先获取验证码', 'Эхлээд баталгаажуулах кодыг авна уу', 1),
(9542, 8, '410010', '验证码错误', 'Баталгаажуулах кодын алдаа', 1),
(9543, 8, '410011', '密码必须是在6到16位之间', 'Нууц үг нь 6-16 оронтой байх ёстой', 1),
(9544, 8, '410012', '密码太过简单，请输入较为复杂的密码', 'Нууц үг хэтэрхий энгийн байна, илүү төвөгтэй нууц үг оруулна уу', 1),
(9545, 8, '410013', '注册成功', 'Бүртгэл амжилттай боллоо', 1),
(9546, 8, '410014', '注册失败', 'Бүртгэл амжилтгүй боллоо', 1),
(9547, 8, '410015', '请输入手机号', 'Утасны дугаараа оруулна уу', 1),
(9548, 8, '410016', '绑定成功', 'Холбоо амжилттай', 1),
(9549, 8, '410017', '绑定失败', 'Холбоо амжилтгүй боллоо', 1),
(9550, 8, '410018', '手机号格式不正确', 'Утасны дугаарын формат буруу байна', 1),
(9551, 8, '410019', '登录失败', 'Нэвтэрч чадсангүй', 1),
(9552, 8, '410020', '扫码失败请重新扫描', 'Кодыг скан хийж чадсангүй, дахин скан хийнэ үү', 1),
(9553, 8, '410021', '二维码已过期请重新扫描', 'QR кодын хугацаа дууссан тул дахин скан хийнэ үү', 1),
(9554, 8, '410022', '授权成功，请绑定手机号', 'Зөвшөөрөл амжилттай боллоо, гар утасны дугаараа холбоно уу', 1),
(9555, 8, '410023', '授权成功', 'Зөвшөөрөл амжилттай боллоо', 1),
(9556, 8, '410024', '请先关注公众号', 'Эхлээд албан ёсны бүртгэлд анхаарлаа хандуулна уу', 1),
(9557, 8, '410025', '账号或密码错误', 'Бүртгэл эсвэл нууц үгийн алдаа', 1),
(9558, 8, '410026', '请修改您的初始密码，再尝试登录', 'Анхны нууц үгээ өөрчлөөд дахин нэвтэрч үзнэ үү', 1),
(9559, 8, '410027', '您已被禁止登录，请联系管理员', 'Та нэвтрэхийг хориглосон тул админтай холбогдоно уу', 1),
(9560, 8, '410028', '手机号已注册', 'Утасны дугаар бүртгэгдсэн байна', 1),
(9561, 8, '410029', '您今日发送得短信次数已经达到上限', 'Таны өнөөдрийн илгээсэн мессежийн тоо дээд хязгаарт хүрсэн байна', 1),
(9562, 8, '410030', '此IP今日发送次数已经达到上限', 'Өнөөдөр энэ IP-г илгээсэн тоо дээд хязгаарт хүрсэн байна', 1),
(9563, 8, '410031', '短信平台验证码发送失败', 'SMS платформ баталгаажуулах кодыг илгээж чадсангүй', 1),
(9564, 8, '410032', '用户不存在', 'Хэрэглэгч байхгүй', 1),
(9565, 8, '410033', '修改密码失败', 'Нууц үг солигдож чадсангүй', 1),
(9566, 8, '410034', '用户登录失败,无法生成新用户,请稍后再试', 'Хэрэглэгч нэвтэрч чадсангүй, шинэ хэрэглэгч үүсгэх боломжгүй, дараа дахин оролдоно уу', 1),
(9567, 8, '410035', '用户不存在,无法切换', 'Хэрэглэгч байхгүй бөгөөд солих боломжгүй', 1),
(9568, 8, '410036', '修改新用户登录类型出错', 'Хэрэглэгчийн шинэ нэвтрэх төрлийг өөрчлөхөд алдаа гарлаа', 1),
(9569, 8, '410037', '请刷新页面或者重新授权', 'Хуудсыг сэргээнэ үү, эсвэл дахин зөвшөөрнө үү', 1),
(9570, 8, '410038', '获取用户访问token失败', 'Хэрэглэгчийн хандалтын токен авч чадсангүй', 1),
(9571, 8, '410039', '此手机已经绑定，无法多次绑定', 'Энэ утас хэд хэдэн удаа холбогдсон ба холбогдох боломжгүй', 1),
(9572, 8, '410040', '您的账号已经绑定过手机号码', 'Таны данс гар утасны дугаартай холбогдсон байна', 1),
(9573, 8, '410041', 'H5已有账号是否绑定此账号上', 'Одоо байгаа H5 данс энэ дансанд холбогдсон эсэх', 1),
(9574, 8, '410042', '新手机号和原手机号相同，无需修改', 'Шинэ утасны дугаар нь анхны утасны дугаартай ижил байна, өөрчлөх шаардлагагүй', 1),
(9575, 8, '410043', '此手机已经注册', 'Энэ утас бүртгэгдсэн байна', 1),
(9576, 8, '410044', '用户信息获取失败', 'Хэрэглэгчийн мэдээллийг авч чадсангүй', 1),
(9577, 8, '410045', '请选择收货地址', 'Хүргэх хаягаа сонгоно уу', 1),
(9578, 8, '410046', '地址选择有误', 'Хаягийн сонголт буруу байна', 1),
(9579, 8, '410047', '可用积分不足', 'Боломжтой кредит хангалтгүй', 1),
(9580, 8, '410048', '奖品不存在', 'Шагнал байхгүй', 1),
(9581, 8, '410049', '写入中奖记录失败', 'Ялалтын бичлэгийг бичиж чадсангүй', 1),
(9582, 8, '410050', '请继续参与活动抽奖', 'Азтан шалгаруулах тэмцээнд үргэлжлүүлэн оролцоорой', 1),
(9583, 8, '410051', '已经领取成功', 'Амжилттай хүлээн авлаа', 1),
(9584, 8, '410052', '请输入收货人信息', 'Ачаа хүлээн авагчийн мэдээллийг оруулна уу', 1),
(9585, 8, '410053', '请输入正确的收货人电话', 'Ачаа хүлээн авагчийн утасны дугаарыг зөв оруулна уу', 1),
(9586, 8, '410054', '抽奖记录不存在', 'Сугалааны бүртгэл байхгүй', 1),
(9587, 8, '410055', '该奖品不需要发货', 'Энэ шагналыг тээвэрлэх шаардлагагүй', 1),
(9588, 8, '410056', '请选择快递公司或输入快递单号', 'Та шуудангийн компанийг сонгоно уу эсвэл шуудангийн дугаар оруулна уу', 1),
(9589, 8, '410057', '活动不存在或已删除', 'Үйл ажиллагаа байхгүй эсвэл устгагдсан', 1),
(9590, 8, '410058', '暂未有该类型活动', 'Одоохондоо ийм төрлийн үйл ажиллагаа алга', 1),
(9591, 8, '410059', '您暂时无法参与该活动', 'Та энэ үйл ажиллагаанд түр зуур оролцох боломжгүй', 1),
(9592, 8, '410060', '活动状态有误，请联系管理员', 'Үйл ажиллагааны төлөв буруу байна, админтай холбогдоно уу', 1),
(9593, 8, '410061', '可用积分不足，没有更多抽奖次数', 'Оноо хангалтгүй, дахин сугалаа байхгүй', 1),
(9594, 8, '410062', '余额不足，没有更多抽奖次数', 'Үлдэл хангалтгүй, дахин сугалахгүй', 1),
(9595, 8, '410063', '购买商品之后获得更多抽奖次数', 'Бараа худалдаж авсны дараа дахин сугалааны тохирол авах', 1),
(9596, 8, '410064', '订单完成评价之后获得更多抽奖次数', 'Захиалгыг үнэлсний дараа илүү олон шагнал авах болно', 1),
(9597, 8, '410065', '邀请更多好友获取抽奖次数', 'Илүү олон найзуудаа урьж азын сугалааны тоог аваарай', 1),
(9598, 8, '410066', '抽奖扣除用户积分失败', 'Сугалааны тохирол хэрэглэгчийн оноог хасаж чадсангүй', 1),
(9599, 8, '410067', '抽奖失败，余额不足', 'Сугалааны тохирол амжилтгүй боллоо, үлдэгдэл хангалтгүй', 1),
(9600, 8, '410068', '抽奖扣除用户余额失败', 'Сугалааны тохирол хэрэглэгчийн үлдэгдлийг хасч чадсангүй', 1),
(9601, 8, '410069', '抽奖扣除用户推广获取抽奖次数失败', 'Сугалааны тохирол нь хэрэглэгч сугалаа авахын тулд дэвшүүлсэн тоог хасаж чадсангүй', 1),
(9602, 8, '410070', '抽奖减少奖品总数失败', 'Нийт шагналын тоог бууруулах сугалааны тохирол амжилтгүй боллоо', 1),
(9603, 8, '410071', '分销等级不存在', 'Тохируулгын түвшин байхгүй', 1),
(9604, 8, '410072', '永久二维码获取错误', 'Байнгын QR код олж авахад алдаа гарсан', 1),
(9605, 8, '410073', '邀请码无效', 'Урилгын код буруу байна', 1),
(9606, 8, '410074', '授权失败,参数有误', 'Зөвшөөрөл амжилтгүй боллоо, параметр буруу байна', 1),
(9607, 8, '410075', 'openid获取失败', 'Нээлттэй код авч чадсангүй', 1),
(9608, 8, '410076', '获取session_key失败，请检查您的配置', 'sess_key-г авч чадсангүй, тохиргоогоо шалгана уу', 1),
(9609, 8, '410077', '获取会话密匙失败', 'Сурсын түлхүүрийг авч чадсангүй', 1),
(9610, 8, '410078', '静默授权失败', 'Чимээгүй зөвшөөрөл амжилтгүй боллоо', 1),
(9611, 8, '410079', '获取用户信息失败', 'Хэрэглэгчийн мэдээллийг авч чадсангүй', 1),
(9612, 8, '410080', '更新信息失败', 'Мэдээллийг шинэчилж чадсангүй', 1),
(9613, 8, '410081', '请上传二维码', 'QR кодыг байршуулна уу', 1),
(9614, 8, '410082', '请关注公众号', 'Олон нийтийн дугаарт анхаарлаа хандуулна уу', 1),
(9615, 8, '410083', '新增用户失败', 'Хэрэглэгч нэмж чадсангүй', 1),
(9616, 8, '410084', '用户关注失败', 'Хэрэглэгчийг дагаж чадсангүй', 1),
(9617, 8, '410085', '获取token失败{:msg}', 'Токен {:msg} авч чадсангүй', 1),
(9618, 8, '410086', '配置已更改或token已失效', 'Тохиргоо өөрчлөгдсөн эсвэл жетон хугацаа дууссан', 1),
(9619, 8, '410087', '平台错误：发生异常，请稍后重试', 'Платформын алдаа: Онцгой тохиолдол гарлаа, дараа дахин оролдоно уу', 1),
(9620, 8, '410088', '企业微信支付到零钱需要支付证书，检测到您没有上传', 'Аж ахуйн нэгжийн WeChat төлбөрийг өөрчлөхийн тулд төлбөрийн гэрчилгээ шаардлагатай байна, таныг байршуулаагүй нь тогтоогдсон', 1),
(9621, 8, '410089', '发起企业支付到零钱失败', 'Санаачлагч байгууллага өөрчлөлтийг төлж чадсангүй', 1),
(9622, 8, '410090', '无效的token不能查找到用户聊天记录', 'Буруу токен хэрэглэгчийн чатын бичлэгийг олж чадсангүй', 1),
(9623, 8, '410091', '图片上传成功', 'Зургийг амжилттай байршууллаа', 1),
(9624, 8, '410092', '用户uid不再当前聊天用户范围内', 'Хэрэглэгчийн uid нь одоо байгаа чатын хэрэглэгчийн хамрах хүрээд байхаа больсон', 1),
(9625, 8, '410093', '请输入订单价格', 'Захиалгын үнийг оруулна уу', 1),
(9626, 8, '410094', '请去后台售后订单列表处理', 'Борлуулалтын дараах захиалгын жагсаалт боловсруулах хэсэгт очно уу', 1),
(9627, 8, '410095', '分类名称不能为空', 'Ангиллын нэр хоосон байж болохгүй', 1),
(9628, 8, '410096', '分类不存在', 'Ангилал байхгүй', 1),
(9629, 8, '410097', '添加的内容重复', 'Нэмсэн контент давтагдсан', 1),
(9630, 8, '410098', '缺少转接人id', 'Шилжүүлсэн хүний ​​ID дутуу', 1),
(9631, 8, '410099', '转接成功', 'Шилжүүлэг амжилттай', 1),
(9632, 8, '410100', '话术没有被查到', 'Яриа олдсонгүй', 1),
(9633, 8, '410101', '公共话术不能修改', 'Нийтийн хэлийг өөрчлөх боломжгүй', 1),
(9634, 8, '410102', '话术标题内容不能为空', 'Сэдвийн гарчигийн агуулга хоосон байж болохгүй', 1),
(9635, 8, '410103', '已拥有此分组', 'Энэ бүлгийг аль хэдийн эзэмшсэн', 1),
(9636, 8, '410104', '缺少标签id', 'Тагийн ID дутуу', 1),
(9637, 8, '410105', '请填汉字字母或者数字', 'Хятад үсэг эсвэл тоо оруулна уу', 1),
(9638, 8, '410106', '标题长度不能超过50个字', 'Гарчигны урт 50 тэмдэгтээс хэтрэхгүй', 1),
(9639, 8, '410107', '请选择分类', 'Ангилал сонгоно уу', 1),
(9640, 8, '410108', '分类必须为数字', 'Ангилал нь тоо байх ёстой', 1),
(9641, 8, '410109', '请填写话术内容', 'Хэлний агуулгыг бөглөнө үү', 1),
(9642, 8, '410110', '话术长度不能超过500个字', 'Ярианы урт 500 үгнээс хэтрэхгүй', 1),
(9643, 8, '410111', '排序必须为数字', 'Ангилал нь тоо байх ёстой', 1),
(9644, 8, '410112', '微信最低提现金额不能小于1元', 'Wechat-аас мөнгө авах доод хэмжээ 1 юаниас бага байж болохгүй', 1),
(9645, 8, '410113', '用户不存在', 'Хэрэглэгч байхгүй', 1),
(9646, 8, '410114', '提现方式不存在', 'Татаж авах арга байхгүй', 1),
(9647, 8, '410115', '提现金额输入有误', 'Татан авалтын дүнг буруу оруулсан', 1),
(9648, 8, '410116', '银行卡号输入有误', 'Банкны картын дугаарыг буруу оруулсан', 1),
(9649, 8, '410117', '请输入支付宝账号', 'Alipay дансны дугаараа оруулна уу', 1),
(9650, 8, '410118', '请输入银行卡账号', 'Банкны картын дансны дугаараа оруулна уу', 1),
(9651, 8, '410119', '请输入开户行信息', 'Банкны мэдээллийг оруулна уу', 1),
(9652, 8, '410120', '申请提现成功', 'Татаж авах өргөдөл амжилттай боллоо', 1),
(9653, 8, '410121', '申请提现失败', 'Татаж авах хүсэлт гаргаж чадсангүй', 1),
(9654, 8, '410122', '充值金额不能为0元', 'Цэнэглэх хэмжээ 0 юань байж болохгүй', 1),
(9655, 8, '410123', '充值方式不支持', 'Цэнэглэх аргыг дэмждэггүй', 1),
(9656, 8, '410124', '充值金额不能低于{:money}', 'Цэнэглэх хэмжээ {:money}-ээс бага байж болохгүй', 1),
(9657, 8, '410125', '充值成功', 'Амжилттай цэнэглэлээ', 1),
(9658, 8, '410126', '充值失败', 'Цэнэглэж чадсангүй', 1),
(9659, 8, '410127', '签到获得{:integral}积分', '{:integral} оноо авахын тулд нэвтэрнэ үү', 1),
(9660, 8, '410128', '签到失败', 'Нэвтэрч чадсангүй', 1),
(9661, 8, '410129', '收藏成功', 'Цуглуулга амжилттай боллоо', 1),
(9662, 8, '410130', '收藏失败', 'Цуглуулж чадсангүй', 1),
(9663, 8, '410131', '授权失败', 'Зөвшөөрөл амжилтгүй боллоо', 1),
(9664, 8, '410132', 'unionid不存在', 'unionid байхгүй', 1),
(9665, 8, '410133', '获取用户UID失败', 'Хэрэглэгчийн UID-г авч чадсангүй', 1),
(9666, 8, '410134', '请输入昵称或者选择头像', 'Хоч оруулна уу эсвэл аватар сонгоно уу', 1),
(9667, 8, '410135', '注销成功', 'Гаралт амжилттай', 1),
(9668, 8, '410136', '暂无客服人员在线，请稍后联系', 'Онлайнаар харилцагчийн үйлчилгээний ажилтан байхгүй, бидэнтэй дараа холбогдоно уу', 1),
(9669, 8, '410137', '不能和自己聊天', 'Өөртэйгөө чатлаж чадахгүй байна', 1),
(9670, 8, '410138', '您不是客服无法登录', 'Та хэрэглэгчийн үйлчилгээ биш бөгөөд нэвтрэх боломжгүй', 1),
(9671, 8, '410139', '自己不能转接给自己', 'Би өөртөө шилжүүлж чадахгүй', 1),
(9672, 8, '410140', '转接客服失败', 'Хэрэглэгчийн үйлчилгээг шилжүүлж чадсангүй', 1),
(9673, 8, '410141', '没有此用户', 'Тийм хэрэглэгч байхгүй', 1),
(9674, 8, '410142', '客服不存在', 'Хэрэглэгчийн үйлчилгээ байхгүй', 1),
(9675, 8, '410143', '商品未查到', 'Бараа олдсонгүй', 1),
(9676, 8, '410144', '请填写开票手机号', 'Төлбөрийн утасны дугаараа бөглөнө үү', 1),
(9677, 8, '410145', '请填写发票抬头（开具发票企业名称）', 'Нэхэмжлэхийн нэрийг (нэхэмжлэх гаргасан компанийн нэр) бөглөнө үү', 1),
(9678, 8, '410146', '请填写正确的发票抬头（开具发票企业名称）', 'Нэхэмжлэхийн толгой хэсгийг зөв бөглөнө үү (нэхэмжлэх гаргасан компанийн нэр)', 1),
(9679, 8, '410147', '请填写发票税号', 'Нэхэмжлэлийн татварын дугаарыг бөглөнө үү', 1),
(9680, 8, '410148', '请填写正确的发票税号', 'Нэхэмжлэлийн татварын дугаарыг зөв бөглөнө үү', 1),
(9681, 8, '410149', '请填写正确的银行卡号', 'Банкны картын дугаарыг зөв бөглөнө үү', 1),
(9682, 8, '410150', '地址不存在', 'Хаяг байхгүй', 1),
(9683, 8, '410151', '收货地址格式错误', 'Хүргэх хаягийн формат буруу байна', 1),
(9684, 8, '410152', '收货地址格式错误或系统未完善当前地址', 'Хүргэх хаягийн формат буруу эсвэл систем одоогийн хаягийг бөглөөгүй байна', 1),
(9685, 8, '410153', '收货地址格式错误，请重新选择', 'Хүргэх хаягийн формат буруу байна, дахин сонгоно уу', 1),
(9686, 8, '410154', '请填写详细地址', 'Дэлгэрэнгүй хаягийг бөглөнө үү', 1),
(9687, 8, '410155', '名称必须填写', 'Нэр бөглөх ёстой', 1),
(9688, 8, '410156', '名称最多不能超过25个字符', 'Нэр 25 тэмдэгтээс хэтрэхгүй', 1),
(9689, 8, '410157', '手机号必须填写', 'Гар утасны дугаарыг заавал бөглөх ёстой', 1),
(9690, 8, '410158', '手机号格式错误', 'Гар утасны дугаарын форматын алдаа', 1),
(9691, 8, '410159', '省必须填写', 'Аймаг бөглөх ёстой', 1),
(9692, 8, '410160', '市必须填写', 'Хот бөглөх ёстой', 1),
(9693, 8, '410161', '区/县必须填写', 'Дүүрэг/дүргийг бөглөх ёстой', 1),
(9694, 8, '410162', '详细地址必须填写', 'Нарийвчилсан хаягийг заавал бөглөх ёстой', 1),
(9695, 8, '410163', '请填写反馈内容', 'Санал хүсэлтийн агуулгыг бөглөнө үү', 1),
(9696, 8, '410164', '比例不能大于您的比例', 'Харьцаа нь таны харьцаанаас их байж болохгүй', 1),
(9697, 8, '410165', '激活成功', 'Идэвхжүүлэх амжилттай', 1),
(9698, 8, '410166', '暂无海报', 'Одоохондоо зурагт хуудас байхгүй', 1),
(9699, 8, '410167', '二维码生成失败', 'QR код үүсгэж чадсангүй', 1),
(9700, 8, '410168', '缺少字体文件Bold', 'Болд үсгийн файл дутуу', 1),
(9701, 8, '410169', '缺少字体文件Normal', 'Хэвийн үсгийн файл дутуу', 1),
(9702, 8, '410170', '生成图片失败', 'Зураг үүсгэж чадсангүй', 1),
(9703, 8, '410171', '生成图片时，系统错误', 'Зураг үүсгэх үед системийн алдаа гарлаа', 1),
(9704, 8, '410172', '生成海报失败', 'Зурагт хуудас үүсгэж чадсангүй', 1),
(9705, 8, '410173', '订单不存在', 'Захиалга байхгүй', 1),
(9706, 8, '410174', '订单已支付', 'Захиалга төлсөн', 1),
(9707, 8, '410175', '请填写实际支付金额', 'Бодит төлбөрийн дүнг бөглөнө үү', 1),
(9708, 8, '410176', '实际支付金额不能小于0元', 'Бодит төлбөрийн хэмжээ 0 юаниас бага байж болохгүй', 1),
(9709, 8, '410177', '请填写备注内容', 'Тайлбарыг бөглөнө үү', 1),
(9710, 8, '410178', '请先处理售后申请', 'Эхлээд борлуулалтын дараах өргөдлийг боловсруулна уу', 1),
(9711, 8, '410179', '用户已取消申请', 'Хэрэглэгч програмыг цуцалсан', 1),
(9712, 8, '410180', '售后订单状态不支持该操作', 'Борлуулалтын дараах захиалгын төлөв энэ үйлдлийг дэмждэггүй', 1),
(9713, 8, '410181', '退款修改状态错误', 'Буцаан олголтын өөрчлөлтийн төлөвийн алдаа', 1),
(9714, 8, '410182', '修改退款状态成功', 'Буцаан олголтын төлөвийг амжилттай өөрчлөх', 1),
(9715, 8, '410183', '已退完支付金额，不能再退款了', 'Төлбөрийн дүнг буцаан олгосон бөгөөд цаашид буцаан олгох боломжгүй', 1),
(9716, 8, '410184', '请输入退款金额', 'Буцаан олголтын дүнг оруулна уу', 1),
(9717, 8, '410185', '退款金额大于支付金额，请修改退款金额', 'Буцаан олголтын хэмжээ төлбөрийн дүнгээс их байна, буцаан олголтын хэмжээг өөрчилнө үү', 1),
(9718, 8, '410186', '退款成功', 'Буцаан олголт амжилттай', 1),
(9719, 8, '410187', '退款失败', 'Буцаан олгоогүй', 1),
(9720, 8, '410188', '请输入核销码或者扫描核销二维码', 'Татгалын кодыг оруулна уу эсвэл хасагдах QR кодыг уншина уу', 1),
(9721, 8, '410189', '核销成功', 'Амжилттай хасагдсан', 1),
(9722, 8, '410190', '请输入付款金额', 'Төлбөрийн дүнг оруулна уу', 1),
(9723, 8, '410191', '支付金额不能为0元', 'Төлбөрийн хэмжээ 0 юань байж болохгүй', 1),
(9724, 8, '410192', '付费会员功能暂未开启', 'Төлбөртэй гишүүнчлэлийн функц хараахан нээгдээгүй байна', 1),
(9725, 8, '410193', '支付数据生成失败', 'Төлбөрийн өгөгдөл үүсгэж чадсангүй', 1),
(9726, 8, '410194', '支付订单不存在', 'Төлбөрийн захиалга байхгүй', 1),
(9727, 8, '410195', '微信支付成功', 'WeChat төлбөр амжилттай боллоо', 1),
(9728, 8, '410196', '前往支付', 'Төлбөр рүү очих', 1),
(9729, 8, '410197', '余额支付成功', 'Үлдэгдэл төлбөр амжилттай боллоо', 1),
(9730, 8, '410198', '请传入支付宝支付回调URL', 'Alipay төлбөрийн буцаан дуудлагын URL-г оруулна уу', 1),
(9731, 8, '410199', '支付宝支付成功', 'Alipay төлбөр амжилттай боллоо', 1),
(9732, 8, '410200', '订单生成失败', 'Захиалга үүсгэж чадсангүй', 1),
(9733, 8, '410201', '请提交购买的商品', 'Худалдан авсан бүтээгдэхүүнээ илгээнэ үү', 1),
(9734, 8, '410202', '商品不存在，请重新选择商品下单', 'Бүтээгдэхүүн байхгүй байна, захиалга өгөхийн тулд бүтээгдэхүүнийг дахин сонгоно уу', 1),
(9735, 8, '410203', '订单创建成功', 'Захиалга амжилттай үүсгэгдсэн', 1),
(9736, 8, '410204', '收货成功', 'Барааг амжилттай хүлээн авлаа', 1),
(9737, 8, '410205', '收货失败', 'Баримт амжилтгүй боллоо', 1),
(9738, 8, '410206', '快递单号不存在', 'Экспресс хяналтын дугаар байхгүй', 1),
(9739, 8, '410207', '默认运费模板未配置，无法下单', 'Өгөгдмөл тээвэрлэлтийн загвар тохируулагдаагүй тул захиалга өгөх боломжгүй', 1),
(9740, 8, '410208', '订单已过期,请刷新当前页面', 'Захиалгын хугацаа дууссан тул одоо байгаа хуудсыг сэргээнэ үү', 1),
(9741, 8, '410209', '订单已创建，请点击查看完成支付', 'Захиалга үүсгэгдсэн тул төлбөрөө дуусгахын тулд товшино уу', 1),
(9742, 8, '410210', '订单生成失败，你已经在该团内不能再参加了', 'Захиалга үүсгэж чадсангүй, та цаашид бүлэгт оролцох боломжгүй', 1),
(9743, 8, '410211', '订单生成失败，你已经参加该团了，请先支付订单', 'Захиалга үүсгэж чадсангүй, та бүлэгт аль хэдийн нэгдсэн байна, эхлээд захиалгаа төлнө үү', 1),
(9744, 8, '410212', '该团人员已满', 'Бүлэг дүүрсэн', 1),
(9745, 8, '410213', '暂不支持该支付方式，请刷新页面或者联系管理员', 'Энэ төлбөрийн аргыг одоогоор дэмжихгүй байгаа тул хуудсыг дахин сэргээх эсвэл админтай холбогдоно уу', 1),
(9746, 8, '410214', '您购买的商品库存已不足{:cart_num}{:unit_name}', 'Таны худалдаж авсан хувьцаа хангалтгүй байна {:cart_num}{:unit_name}', 1),
(9747, 8, '410215', '该订单已失效', 'Захиалгын хугацаа дууссан', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(9748, 8, '410216', '支付失败', 'Төлбөр амжилтгүй боллоо', 1),
(9749, 8, '410217', '支付成功', 'Төлбөр амжилттай боллоо', 1),
(9750, 8, '410218', '支付方式错误', 'Төлбөрийн аргын алдаа', 1),
(9751, 8, '410219', '订单商品已评价', 'Захиалгын зүйл үнэлэгдсэн', 1),
(9752, 8, '410220', '请为商品评分', 'Бүтээгдэхүүнд үнэлгээ өгнө үү', 1),
(9753, 8, '410221', '请为商家服务评分', 'Бизнесийн үйлчилгээг үнэлнэ үү', 1),
(9754, 8, '410222', '评价失败', 'Үнэлгээ амжилтгүй боллоо', 1),
(9755, 8, '410223', '请重新选择退款商品或件数', 'Буцаан олголтын бараа эсвэл ширхэгийн тоог дахин сонгоно уу', 1),
(9756, 8, '410224', '当前状态不能取消申请', 'Одоогийн төлөв програмыг цуцлах боломжгүй', 1),
(9757, 8, '410225', '重选成功', 'Дахин амжилттай', 1),
(9758, 8, '410226', '订单已退款', 'Захиалгыг буцаан олгосон', 1),
(9759, 8, '410227', '使用积分抵扣失败', 'Оноо хасахад ашиглаж чадсангүй', 1),
(9760, 8, '410228', '会员类型不存在', 'Гишүүдийн төрөл байхгүй', 1),
(9761, 8, '410229', '您已是永久会员无需再购买', 'Та аль хэдийн байнгын гишүүн болсон тул цаашид худалдан авалт хийх шаардлагагүй', 1),
(9762, 8, '410230', '该会员卡暂时无法购买', 'Энэ гишүүнчлэлийн картыг түр хугацаанд худалдаж авах боломжгүй', 1),
(9763, 8, '410231', '您已经领取过免费会员', 'Та аль хэдийн үнэгүй гишүүнчлэл авсан байна', 1),
(9764, 8, '410232', '此类型会员卡暂未开售', 'Ийм төрлийн гишүүнчлэлийн карт худалдаанд гараагүй байна', 1),
(9765, 8, '410233', '获取购物车信息失败', 'Сагсны мэдээллийг авч чадсангүй', 1),
(9766, 8, '410234', '您要购买的优惠券已失效，无法购买', 'Таны худалдан авахыг хүссэн купоны хугацаа дууссан тул худалдан авах боломжгүй', 1),
(9767, 8, '410235', '您已获取过该优惠券，无法再次购买', 'Та купоныг аль хэдийн авсан тул дахин худалдаж авах боломжгүй', 1),
(9768, 8, '410236', '请刷新后重试', 'Дахин сэргээгээд дахин оролдоно уу', 1),
(9769, 8, '410237', '暂无库存', 'Хувьцаа байхгүй', 1),
(9770, 8, '410238', '选择的规格库存不足', 'Сонгосон техникийн үзүүлэлтүүд дууссан', 1),
(9771, 8, '410239', '单次购买数量不能大于 {:limit} 件', 'Нэг удаагийн худалдан авалтын хэмжээ {:limit} ширхэгээс их байж болохгүй', 1),
(9772, 8, '410240', '该商品限购 {:limit} 件，您已经购买 {:pay_num} 件', 'Энэ бүтээгдэхүүн нь {:limit} ширхэгээр хязгаарлагдах тул та аль хэдийн {:pay_num} ширхэг худалдаж авсан байна', 1),
(9773, 8, '410241', '选择支付方式有误', 'Төлбөрийн аргыг буруу сонгосон', 1),
(9774, 8, '410242', '选择的优惠劵无效', 'Сонгосон купон хүчингүй', 1),
(9775, 8, '410243', '不满足优惠劵的使用条件', 'Купоныг ашиглах нөхцөл хангагдаагүй байна', 1),
(9776, 8, '410244', '使用优惠劵失败', 'Купоныг ашиглаж чадсангүй', 1),
(9777, 8, '410245', '请填写姓名和电话', 'Нэр, утасны дугаараа оруулна уу', 1),
(9778, 8, '410246', '营销商品不能使用线下支付', 'Офлайн төлбөрийг маркетингийн бүтээгдэхүүнд ашиглах боломжгүй', 1),
(9779, 8, '410247', '暂无门店无法选择门店自提', 'Одоогоор дэлгүүр байхгүй тул дэлгүүрээс авахаар сонгох боломжгүй', 1),
(9780, 8, '410248', '订单商品结算失败', 'Захиалгын зүйлийн тооцоо амжилтгүй боллоо', 1),
(9781, 8, '410249', '发票已申请', 'Нэхэмжлэл ашигласан', 1),
(9782, 8, '410250', '正在申请退款中', 'Төлбөрийг буцаан авах хүсэлт гаргаж байна', 1),
(9783, 8, '410251', '申请失败', 'Програм амжилтгүй боллоо', 1),
(9784, 8, '410252', '退款件数大于订单件数', 'Буцаан олголтын тоо захиалгын тооноос их байна', 1),
(9785, 8, '410253', '该订单已全部拆分', 'Захиалга хуваагдсан', 1),
(9786, 8, '410254', '申请退款失败', 'Төлбөрийг буцаан авах хүсэлт гаргаж чадсангүй', 1),
(9787, 8, '410255', '存在待处理退款单', 'Төлбөрийг буцаан олгох захиалга хүлээгдэж байна', 1),
(9788, 8, '410256', '该订单无法删除', 'Энэ захиалгыг устгах боломжгүй', 1),
(9789, 8, '410257', '订单已经支付无法取消', 'Захиалга төлсөн тул цуцлах боломжгүй', 1),
(9790, 8, '410258', '拼团商品不能再来一单，请在拼团商品内自行下单', 'Бүлэглэсэн бүтээгдэхүүнийг дахин захиалах боломжгүй тул бүлэглэсэн бүтээгдэхүүнд өөрөө захиалга өгнө үү', 1),
(9791, 8, '410259', '砍价商品不能再来一单，请在砍价商品内自行下单', 'Хямдралтай барааг дахин захиалах боломжгүй, хямдарсан бараан дээр өөрөө захиалгаа өгнө үү', 1),
(9792, 8, '410260', '秒杀商品不能再来一单，请在秒杀商品内自行下单', 'Seckill-ийн барааг дахин захиалах боломжгүй, та seckill зүйл дотор захиалгаа өгнө үү', 1),
(9793, 8, '410261', '预售商品不能再来一单，请在预售商品内自行下单', 'Хямдралын өмнөх барааг дахин захиалах боломжгүй тул өөрөө захиалгаа өгнө үү', 1),
(9794, 8, '410262', '再来一单失败，请重新下单', 'Өөр захиалга амжилтгүй боллоо, шинэ захиалга өгнө үү', 1),
(9795, 8, '410263', '该订单无法支付', 'Захиалга төлөх боломжгүй', 1),
(9796, 8, '410264', '订单支付状态有误，无法进行支付', 'Захиалгын төлбөрийн төлөв буруу, төлөх боломжгүй', 1),
(9797, 8, '410265', '该订单已支付', 'Захиалга төлсөн', 1),
(9798, 8, '410266', '订单状态错误', 'Захиалгын төлөвийн алдаа', 1),
(9799, 8, '410267', '此订单不能被核销', 'Энэ захиалгыг хасч болохгүй', 1),
(9800, 8, '410268', '订单有售后申请请先处理', 'Захиалга нь борлуулалтын дараах програмтай тул эхлээд боловсруулна уу', 1),
(9801, 8, '410269', '您无权限核销此订单，请联系管理员', 'Танд энэ захиалгыг цуцлах зөвшөөрөл байхгүй тул админтай холбогдоно уу', 1),
(9802, 8, '410270', '订单已核销', 'Захиалга хасагдсан', 1),
(9803, 8, '410271', '拼团订单暂未成功无法核销', 'Бүлгийн захиалгыг амжилттай хасаагүй байна', 1),
(9804, 8, '410272', '核销失败', 'Баталгаажуулалт амжилтгүй боллоо', 1),
(9805, 8, '410273', '发货成功', 'Амжилттай хүргэлт', 1),
(9806, 8, '410274', '无需支付', 'Төлбөр хийх шаардлагагүй', 1),
(9807, 8, '410275', '获取用户openid失败,无法支付', 'Хэрэглэгчийн нээлттэй кодыг авч чадсангүй, төлбөр төлөх боломжгүй', 1),
(9808, 8, '410276', '网站名称配置未填写,无法支付', 'Вэб сайтын нэрийн тохиргоог бөглөөгүй, төлбөр төлөх боломжгүй', 1),
(9809, 8, '410277', '支付方式不存在', 'Төлбөрийн арга байхгүй', 1),
(9810, 8, '410278', '不支持该类型方式', 'Энэ төрлийн аргыг дэмждэггүй', 1),
(9811, 8, '410279', '余额支付失败', 'Үлдэгдэл төлбөр амжилтгүй боллоо', 1),
(9812, 8, '410280', '暂未开启发票', 'Нэхэмжлэл хараахан нээгдээгүй байна', 1),
(9813, 8, '410281', '暂未开启专用发票', 'Тусгай нэхэмжлэх хараахан нээгдээгүй байна', 1),
(9814, 8, '410282', '该发票已经存在', 'Нэхэмжлэх нь аль хэдийн байна', 1),
(9815, 8, '410283', '设置默认发票失败', 'Өгөгдмөл нэхэмжлэхийг тохируулж чадсангүй', 1),
(9816, 8, '410284', '没有此用户，无法检测升级用户等级', 'Энэ хэрэглэгч байхгүй бол хэрэглэгчийн сайжруулалтын түвшинг илрүүлэх боломжгүй', 1),
(9817, 8, '410285', '检测升级失败', 'Шинэчлэлтийг шалгаж чадсангүй', 1),
(9818, 8, '410286', '修改订单失败', 'Захиалгыг өөрчилж чадсангүй', 1),
(9819, 8, '410287', '修改用户信息失败', 'Хэрэглэгчийн мэдээллийг өөрчилж чадсангүй', 1),
(9820, 8, '410288', '绑定推广关系失败', 'Урамшууллын харилцааг холбож чадсангүй', 1),
(9821, 8, '410289', '天数不能为0', 'Өдрийн тоо 0 байж болохгүй', 1),
(9822, 8, '410290', '添加签到数据失败', 'Бүртгэлийн өгөгдлийг нэмж чадсангүй', 1),
(9823, 8, '410291', '赠送经验失败', 'Туршлага өгч чадсангүй', 1),
(9824, 8, '410292', '请先配置签到天数', 'Эхлээд бүртгүүлэх өдрүүдээ тохируулна уу', 1),
(9825, 8, '410293', '已经签到', 'Нэвтэрсэн', 1),
(9826, 8, '410294', '商品不存在', 'Бараа байхгүй', 1),
(9827, 8, '410295', '该商品已下架或删除', 'Зүйлийг устгасан эсвэл устгасан', 1),
(9828, 8, '410296', '该商品库存不足', 'Бүтээгдэхүүн дууссан байна', 1),
(9829, 8, '410297', '该商品库存不足{:num}', 'Энэ бүтээгдэхүүний нөөц хангалтгүй {:num}', 1),
(9830, 8, '410298', '每人总共限购{:num}件', 'Хүн бүр нийтдээ {:num} ширхэгээр хязгаарлагддаг', 1),
(9831, 8, '410299', '砍价已结束', 'Худалдан авалт дууссан', 1),
(9832, 8, '410300', '您不能再发起此件商品砍价', 'Та цаашид энэ зүйл дээр наймаа хийх боломжгүй', 1),
(9833, 8, '410301', '该分享未开启砍价', 'Хуваалцах боломж нээгдээгүй', 1),
(9834, 8, '410302', '您已经帮砍过此砍价', 'Та үнийг бууруулахад аль хэдийн тусалсан', 1),
(9835, 8, '410303', '砍价信息没有查到', 'Хэлэлцээний мэдээлэл олдсонгүй', 1),
(9836, 8, '410304', '用户砍价信息未查到', 'Хэрэглэгчийн хэлэлцээрийн мэдээлэл олдсонгүй', 1),
(9837, 8, '410305', '请选择有效的商品属性', 'Хүчтэй бүтээгдэхүүний шинж чанарыг сонгоно уу', 1),
(9838, 8, '410306', '砍价商品不存在', 'Худалдааны зүйл байхгүй', 1),
(9839, 8, '410307', '砍价失败', 'Худалдан авалт амжилтгүй боллоо', 1),
(9840, 8, '410308', '砍价未成功', 'Хэлэлцээ амжилтгүй болсон', 1),
(9841, 8, '410309', '砍价已支付', 'Төлбөрийг төлсөн', 1),
(9842, 8, '410310', '您不能再帮砍此件商品', 'Та цаашид энэ зүйлийг таслахад тусалж чадахгүй', 1),
(9843, 8, '410311', '商品已被删除', 'Зүйлийг устгасан', 1),
(9844, 8, '410312', '拼团不存在或已下架,请手动申请退款', 'Бүлэг байхгүй эсвэл хасагдсан тул гар аргаар буцаан олгох хүсэлт гаргана уу', 1),
(9845, 8, '410313', '每个订单限购{:num}件', 'Захиалга бүр {:num} ширхэгээр хязгаарлагдана', 1),
(9846, 8, '410314', '未查到拼团信息，无法取消', 'Бүлгийн мэдээллийг олж чадаагүй бөгөөд цуцлах боломжгүй', 1),
(9847, 8, '410315', '拼团已到期', 'Бүлгийн хугацаа дууссан', 1),
(9848, 8, '410316', '拼团已完成，无法取消', 'Бүлэглэл дууссан бөгөөд цуцлах боломжгүй', 1),
(9849, 8, '410317', '每人限购{:num}件', 'Хүн бүр {:num} ширхэгээр хязгаарлагддаг', 1),
(9850, 8, '410318', '抽奖不存在', 'Сугалаа байхгүй', 1),
(9851, 8, '410319', '领取成功', 'Амжилттай хүлээн авлаа', 1),
(9852, 8, '410320', '领取失败', 'Хүлээн авч чадсангүй', 1),
(9853, 8, '410321', '活动未开始', 'Үйл явдал эхлээгүй байна', 1),
(9854, 8, '410322', '活动已结束', 'Үйл явдал дууслаа', 1),
(9855, 8, '410323', '您已有这张优惠券，请勿重复购买', 'Танд энэ купон байгаа тул дахиж битгий худалдаж аваарай', 1),
(9856, 8, '410324', '请核对快递公司编码', 'Та шуудангийн компанийн кодыг шалгана уу', 1),
(9857, 8, '410325', '请选择发票', 'Нэхэмжлэх сонгоно уу', 1),
(9858, 8, '-1', '系统繁忙，请稍候再试', 'Систем завгүй байна, дараа дахин оролдоно уу', 1),
(9859, 8, '43104', 'appid与openid不匹配', 'appid openid-тай тохирохгүй байна', 1),
(9860, 8, '45009', '达到微信api每日限额上限', 'WeChat api-н өдрийн хязгаарт хүрсэн байна', 1),
(9861, 8, '45008', '图文消息超过限制', 'Мессеж хязгаараас хэтэрсэн байна', 1),
(9862, 8, '45007', '语音播放时间超过限制', 'Дуу тоглуулах хугацаа хязгаараас хэтэрсэн', 1),
(9863, 8, '45006', '图片链接字段超过限制', 'Зургийн холбоосын талбар хязгаараас хэтэрсэн', 1),
(9864, 8, '45005', '链接字段超过限制', 'Холбоос талбар хязгаараас хэтэрсэн', 1),
(9865, 8, '45004', '描述字段超过限制', 'Тодорхойлолтын талбар хязгаараас хэтэрсэн', 1),
(9866, 8, '45003', '标题字段超过限制', 'Гарчигны талбар хязгаараас хэтэрсэн', 1),
(9867, 8, '45002', '消息内容超过限制', 'Мессежийн агуулга хязгаараас хэтэрсэн', 1),
(9868, 8, '45001', '多媒体文件大小超过限制', 'Мультимедиа файлын хэмжээ хязгаараас хэтэрсэн', 1),
(9869, 8, '44004', '文本消息内容为空', 'Текст мессежийн агуулга хоосон', 1),
(9870, 8, '44003', '图文消息内容为空', 'Мессежийн агуулга хоосон байна', 1),
(9871, 8, '44002', 'POST 的数据包为空', 'POST өгөгдлийн багц хоосон байна', 1),
(9872, 8, '44001', '多媒体文件为空', 'Мультимедиа файл хоосон байна', 1),
(9873, 8, '43019', '需要将接收者从黑名单中移除', 'Хүлээн авагчийг хар жагсаалтаас хасах шаардлагатай', 1),
(9874, 8, '43005', '需要好友关系', 'Нөхөрлөл шаардлагатай', 1),
(9875, 8, '43004', '需要接收者关注', 'Хүлээн авагчийн анхаарал шаардлагатай', 1),
(9876, 8, '43003', '需要 HTTPS 请求', 'HTTPS хүсэлт шаардлагатай', 1),
(9877, 8, '43002', '需要 POST 请求', 'POST хүсэлт шаардлагатай', 1),
(9878, 8, '43001', '需要 GET 请求', 'GET хүсэлт шаардлагатай', 1),
(9879, 8, '42007', '用户修改微信密码， accesstoken 和 refreshtoken 失效，需要重新授权', 'Хэрэглэгч WeChat-ын нууц үгийг өөрчилсөн, хандалтын тэмдэг болон сэргээн засварлах тэмдэг хүчингүй тул дахин зөвшөөрөл авах шаардлагатай', 1),
(9880, 8, '42003', 'oauth_code 超时', 'oauth_code хугацаа дууссан', 1),
(9881, 8, '42002', 'refresh_token 超时', 'refresh_token timeout', 1),
(9882, 8, '42001', 'access_token 超时，请检查 access_token 的有效期，请参考基础支持 - 获取 access_token 中，对 access_token 的详细机制说明', 'Хандалтын_токен хугацаа хэтэрсэн, хандалтын_токены хүчинтэй байх хугацааг шалгана уу. Үндсэн дэмжлэг - Хандалтын_токеныг авах, хандалтын_токенын нарийвчилсан механизмыг үзнэ үү', 1),
(9883, 8, '41009', '缺少 openid', 'Openid дутуу', 1),
(9884, 8, '41008', '缺少 oauth code', 'Таны код дутуу', 1),
(9885, 8, '41007', '缺少子菜单数据', 'Дэд цэсний өгөгдөл дутуу', 1),
(9886, 8, '41006', '缺少 media_id 参数', 'media_id параметр алга', 1),
(9887, 8, '41005', '缺少多媒体文件数据', 'Мультимедиа файлын өгөгдөл дутуу', 1),
(9888, 8, '41004', '缺少 secret 参数', 'Нууц параметр дутуу', 1),
(9889, 8, '41003', '缺少 refresh_token 参数', 'Reresh_token параметр дутуу байна', 1),
(9890, 8, '41002', '缺少 appid 参数', 'Аппидын параметр алга', 1),
(9891, 8, '41001', '缺少 access_token 参数', 'Хандалтын_токен параметр алга', 1),
(9892, 8, '40163', 'oauth_code已使用', 'oauth_code ашигласан', 1),
(9893, 8, '40155', '请勿添加其他公众号的主页链接', 'Бусад албан ёсны акаунт руу холбоос нэмж болохгүй', 1),
(9894, 8, '40137', '不支持的图片格式', 'Дэмжигдээгүй зургийн формат', 1),
(9895, 8, '40132', '微信号不合法', 'Wechat ID хууль бус', 1),
(9896, 8, '40125', '无效的appsecret', 'Програмын нууцлал буруу', 1),
(9897, 8, '40121', '不合法的 media_id 类型', 'Хууль бус медиа_id төрөл', 1),
(9898, 8, '40120', '子 button 类型错误', 'Дэд товчлуурын төрөл буруу', 1),
(9899, 8, '40119', 'button 类型错误', 'товчлуурын төрлийн алдаа', 1),
(9900, 8, '40118', 'media_id 大小不合法', 'media_id хэмжээ буруу байна', 1),
(9901, 8, '40117', '分组名字不合法', 'Бүлгийн нэр буруу байна', 1),
(9902, 8, '40060', '删除单篇图文时，指定的 article_idx 不合法', 'Нэг зургийг устгах үед заасан article_idx хүчингүй байна', 1),
(9903, 8, '40051', '分组名字不合法', 'Бүлгийн нэр буруу байна', 1),
(9904, 8, '40050', '不合法的分组 id', 'Хууль бус бүлгийн ID', 1),
(9905, 8, '40048', '无效的url', 'Хүчингүй url', 1),
(9906, 8, '40039', '不合法的 URL 长度', 'Хууль бус URL урт', 1),
(9907, 8, '40035', '不合法的参数', 'Хууль бус параметр', 1),
(9908, 8, '40038', '不合法的请求格式', 'Хууль бус хүсэлтийн формат', 1),
(9909, 8, '40033', '不合法的请求字符，不能包含 \\uxxxx 格式的字符', 'Хууль бус хүсэлтийн тэмдэгтүүд, \\uxxxx форматтай тэмдэгтүүдийг агуулж болохгүй', 1),
(9910, 8, '40032', '不合法的 openid 列表长度', 'Хууль бус нээлттэй жагсаалтын урт', 1),
(9911, 8, '40031', '不合法的 openid 列表', 'Хууль бус нээлттэй жагсаалт', 1),
(9912, 8, '40030', '不合法的 refresh_token', 'Хууль бус сэргээх_токен', 1),
(9913, 8, '40029', '无效的 oauth_code', 'Oauth_code буруу', 1),
(9914, 8, '40028', '不合法的自定义菜单使用用户', 'Хууль бус захиалгат цэс хэрэглэгч', 1),
(9915, 8, '40027', '不合法的子菜单按钮 URL 长度', 'Хууль бус дэд цэсийн товчлуурын URL урт', 1),
(9916, 8, '40026', '不合法的子菜单按钮 KEY 长度', 'Хууль бус дэд цэс товчны ТҮЛХҮҮР урт', 1),
(9917, 8, '40025', '不合法的子菜单按钮名字长度', 'Хууль бус дэд цэсийн товчлуурын нэрний урт', 1),
(9918, 8, '40024', '不合法的子菜单按钮类型', 'Хууль бус дэд цэсийн товчлуурын төрөл', 1),
(9919, 8, '40023', '不合法的子菜单按钮个数', 'Дэд цэсийн товчлууруудын хууль бус тоо', 1),
(9920, 8, '40022', '不合法的子菜单级数', 'Хууль бус дэд цэсийн түвшин', 1),
(9921, 8, '40021', '不合法的菜单版本号', 'Хууль бус цэсийн хувилбарын дугаар', 1),
(9922, 8, '40020', '不合法的按钮 URL 长度', 'Хууль бус товчлуурын URL урт', 1),
(9923, 8, '40019', '不合法的按钮 KEY 长度', 'Хууль бус товчлуурын ТҮЛХҮҮР урт', 1),
(9924, 8, '40018', '不合法的按钮名字长度', 'Хууль бус товчлуурын нэрний урт', 1),
(9925, 8, '40017', '不合法的按钮类型', 'Хууль бус товчлуурын төрөл', 1),
(9926, 8, '40016', '不合法的按钮个数', 'Хууль бус товчлуурын тоо', 1),
(9927, 8, '40015', '不合法的菜单类型', 'Хууль бус цэсийн төрөл', 1),
(9928, 8, '40014', '不合法的 access_token ，请开发者认真比对 access_token 的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口', 'Хууль бус хандалтын_токен, хандалтын_токенын хүчинтэй хугацааг сайтар харьцуулна уу (хугацаа нь дууссан гэх мэт) эсвэл интерфэйс зохих албан ёсны бүртгэлээр дуудагдаж байгаа эсэхийг шалгана уу', 1),
(9929, 8, '40013', '不合法的 AppID ，请开发者检查 AppID 的正确性，避免异常字符，注意大小写', 'Хууль бус AppID, AppID-ийн зөв эсэхийг шалгана уу, хэвийн бус тэмдэгтээс зайлсхий, том жижиг үсэгт анхаарлаа хандуулна уу', 1),
(9930, 8, '40012', '不合法的缩略图文件大小', 'Хууль бус өнгөц зургийн файлын хэмжээ', 1),
(9931, 8, '40011', '不合法的视频文件大小', 'Хууль бус видео файлын хэмжээ', 1),
(9932, 8, '40010', '不合法的语音文件大小', 'Хууль бус дуут файлын хэмжээ', 1),
(9933, 8, '40009', '不合法的图片文件大小', 'Зургийн файлын хэмжээ хууль бус', 1),
(9934, 8, '40008', '不合法的消息类型', 'Хууль бус мессежийн төрөл', 1),
(9935, 8, '40007', '不合法的媒体文件 id', 'Хууль бус медиа файлын id', 1),
(9936, 8, '40006', '不合法的文件大小', 'Хууль бус файлын хэмжээ', 1),
(9937, 8, '40005', '不合法的文件类型', 'Хууль бус файлын төрөл', 1),
(9938, 8, '40004', '不合法的媒体文件类型', 'Хууль бус медиа файлын төрөл', 1),
(9939, 8, '40003', '不合法的 OpenID ，请开发者确认 OpenID （该用户）是否已关注公众号，或是否是其他公众号的 OpenID', 'Хууль бус OpenID, OpenID (хэрэглэгч) албан ёсны бүртгэлийг дагасан эсэх, эсвэл бусад албан ёсны акаунтын OpenID эсэхийг баталгаажуулна уу', 1),
(9940, 8, '40002', '不合法的凭证类型', 'Хууль бус гэрчилгээний төрөл', 1),
(9941, 8, '40001', '获取 access_token 时 AppSecret 错误，或者 access_token 无效。请开发者认真比对 AppSecret 的正确性，或查看是否正在为恰当的公众号调用接口', ' Access_token авах үед AppSecret алдаа гарлаа, эсвэл access_token буруу байна. Хөгжүүлэгчдээс AppSecret-ийн үнэн зөвийг сайтар харьцуулах эсвэл интерфэйс нь зохих албан ёсны бүртгэлд холбогдож байгаа эсэхийг шалгахыг хүсч байна', 1),
(9942, 8, '200011', '此账号已被封禁，无法操作', 'Энэ бүртгэлийг хориглосон тул ажиллуулах боломжгүй', 1),
(9943, 8, '200012', '个人模版数已达上限，上限25个', 'Хувийн загваруудын тоо дээд хязгаарт хүрсэн, дээд хязгаар нь 25', 1),
(9944, 8, '200014', '请检查小程序所属类目', 'Аплетын ангиллыг шалгана уу', 1),
(9945, 9, '100000', '保存成功', 'บันทึกสำเร็จ', 1),
(9946, 9, '100001', '修改成功', 'การปรับเปลี่ยนสำเร็จ', 1),
(9947, 9, '100002', '删除成功', 'ลบสำเร็จ', 1),
(9948, 9, '100003', '显示成功', 'แสดงผลสำเร็จ', 1),
(9949, 9, '100004', '隐藏成功', 'ความสำเร็จที่ซ่อนอยู่', 1),
(9950, 9, '100005', '操作失败', 'การดำเนินการล้มเหลว', 1),
(9951, 9, '100006', '保存失败', 'บันทึกล้มเหลว', 1),
(9952, 9, '100007', '修改失败', 'การแก้ไขล้มเหลว', 1),
(9953, 9, '100008', '删除失败', 'การลบล้มเหลว', 1),
(9954, 9, '100009', '图片上传成功', 'อัปโหลดรูปภาพสำเร็จ', 1),
(9955, 9, '100010', '操作成功', 'ดำเนินการสำเร็จ', 1),
(9956, 9, '100011', '暂无数据', 'ไม่มีข้อมูล', 1),
(9957, 9, '100012', '更新成功', 'อัปเดตสำเร็จ', 1),
(9958, 9, '100013', '更新失败', 'การอัปเดตล้มเหลว', 1),
(9959, 9, '100014', '设置成功', 'ตั้งค่าสำเร็จ', 1),
(9960, 9, '100015', '设置失败', 'การติดตั้งล้มเหลว', 1),
(9961, 9, '100016', '获取失败', 'ล้มเหลว', 1),
(9962, 9, '100017', '提交成功', 'ส่งสำเร็จ', 1),
(9963, 9, '100018', '提交失败', 'การส่งล้มเหลว', 1),
(9964, 9, '100019', '取消成功', 'ยกเลิกสำเร็จ', 1),
(9965, 9, '100020', '取消失败', 'ยกเลิกไม่สำเร็จ', 1),
(9966, 9, '100021', '添加成功', 'เพิ่มสำเร็จ', 1),
(9967, 9, '100022', '添加失败', 'เพิ่มไม่สำเร็จ', 1),
(9968, 9, '100023', '保存token失败', 'ไม่สามารถบันทึกโทเค็น', 1),
(9969, 9, '100024', '备注成功', 'หมายเหตุสำเร็จ', 1),
(9970, 9, '100025', '备注失败', 'หมายเหตุล้มเหลว', 1),
(9971, 9, '100026', '数据不存在', 'ไม่มีข้อมูล', 1),
(9972, 9, '100027', '申请成功', 'สมัครสำเร็จ', 1),
(9973, 9, '100028', '申请失败', 'การสมัครล้มเหลว', 1),
(9974, 9, '100029', '暂无此方法', 'ไม่มีวิธีดังกล่าว', 1),
(9975, 9, '100030', '发送成功', 'ส่งสำเร็จ', 1),
(9976, 9, '100031', '发送失败', 'ส่งล้มเหลว', 1),
(9977, 9, '100032', '上传成功', 'อัปโหลดสำเร็จ', 1),
(9978, 9, '100033', '上传失败', 'การอัปโหลดล้มเหลว', 1),
(9979, 9, '100034', '移动成功', 'ย้ายสำเร็จ', 1),
(9980, 9, '100035', '移动失败', 'การย้ายล้มเหลว', 1),
(9981, 9, '100036', '退款成功', 'การคืนเงินสำเร็จ', 1),
(9982, 9, '100037', '退款失败', 'การคืนเงินล้มเหลว', 1),
(9983, 9, '100038', '同步成功', 'การซิงโครไนซ์สำเร็จ', 1),
(9984, 9, '100039', '同步失败', 'การซิงค์ล้มเหลว', 1),
(9985, 9, '100040', '恢复成功', 'กู้คืนสำเร็จ', 1),
(9986, 9, '100041', '恢复失败', 'การกู้คืนล้มเหลว', 1),
(9987, 9, '100042', '退出成功', 'ออกสำเร็จ', 1),
(9988, 9, '100043', '退出失败', 'การออกล้มเหลว', 1),
(9989, 9, '100044', '开通成功', 'เปิดสำเร็จ', 1),
(9990, 9, '100045', '开通失败', 'ไม่สามารถเปิดใช้งานได้', 1),
(9991, 9, '100046', '清除数据成功', 'ล้างข้อมูลสำเร็จ', 1),
(9992, 9, '100047', '优化成功', 'การเพิ่มประสิทธิภาพสำเร็จ', 1),
(9993, 9, '100048', '优化失败', 'การเพิ่มประสิทธิภาพล้มเหลว', 1),
(9994, 9, '100049', '修复成功', 'ซ่อมแซมสำเร็จ', 1),
(9995, 9, '100050', '修复失败', 'การซ่อมแซมล้มเหลว', 1),
(9996, 9, '100051', '备份成功', 'สำรองข้อมูลสำเร็จ', 1),
(9997, 9, '100052', '备份失败', 'การสำรองข้อมูลล้มเหลว', 1),
(9998, 9, '100100', '参数错误', 'ข้อผิดพลาดของพารามิเตอร์', 1),
(9999, 9, '100101', '非法操作', 'การดำเนินการที่ผิดกฎหมาย', 1),
(10000, 9, '100102', '数据获取失败', 'การรับข้อมูลล้มเหลว', 1),
(10001, 9, '100103', '站点升级中，请稍候访问', 'กำลังปรับปรุงเว็บไซต์ กรุณาเยี่ยมชมภายหลัง', 1),
(10002, 9, '100104', '缺少code', 'รหัสหายไป', 1),
(10003, 9, '110000', '您暂时没有访问权限', 'คุณไม่มีสิทธิ์เข้าถึงชั่วคราว', 1),
(10004, 9, '110001', '接口未授权，您无法访问', 'อินเทอร์เฟซไม่ได้รับอนุญาต คุณไม่สามารถเข้าถึง', 1),
(10005, 9, '110002', '请登录', 'กรุณาเข้าสู่ระบบ', 1),
(10006, 9, '110003', '登录已过期,请重新登录', 'การเข้าสู่ระบบหมดอายุ กรุณาเข้าสู่ระบบใหม่อีกครั้ง', 1),
(10007, 9, '110004', '登录状态有误,请重新登录', 'สถานะการเข้าสู่ระบบไม่ถูกต้อง โปรดเข้าสู่ระบบอีกครั้ง', 1),
(10008, 9, '110005', '请登录', 'กรุณาเข้าสู่ระบบ', 1),
(10009, 9, '110006', '登录已过期,请重新登录', 'การเข้าสู่ระบบหมดอายุ กรุณาเข้าสู่ระบบใหม่อีกครั้ง', 1),
(10010, 9, '110007', '登录状态有误,请重新登录', 'สถานะการเข้าสู่ระบบไม่ถูกต้อง โปรดเข้าสู่ระบบอีกครั้ง', 1),
(10011, 9, '400000', '请选择用户头像', 'กรุณาเลือกรูปประจำตัวของผู้ใช้', 1),
(10012, 9, '400001', '请填写用户昵称', 'กรุณากรอกชื่อเล่นของผู้ใช้', 1),
(10013, 9, '400002', '请填写评论内容', 'กรุณากรอกความคิดเห็น', 1),
(10014, 9, '400003', '请选择商品分数', 'กรุณาเลือกคะแนนผลิตภัณฑ์', 1),
(10015, 9, '400004', '请选择服务分数', 'กรุณาเลือกคะแนนบริการ', 1),
(10016, 9, '400005', '商品分数必须是1-5之间的整数', 'คะแนนสินค้าต้องเป็นจำนวนเต็มระหว่าง 1-5', 1),
(10017, 9, '400006', '服务分数必须是1-5之间的整数', 'คะแนนการบริการต้องเป็นจำนวนเต็มระหว่าง 1-5', 1),
(10018, 9, '400007', '请选择快递公司', 'กรุณาเลือกบริษัทจัดส่ง', 1),
(10019, 9, '400008', '请填写寄件人姓名', 'กรุณากรอกชื่อผู้ส่ง', 1),
(10020, 9, '400009', '请输入寄件人手机号码', 'โปรดป้อนหมายเลขโทรศัพท์มือถือของผู้ส่ง', 1),
(10021, 9, '400010', '寄件人手机号码不正确', 'หมายเลขโทรศัพท์มือถือของผู้ส่งไม่ถูกต้อง', 1),
(10022, 9, '400011', '请填写寄件人详细地址', 'กรุณากรอกที่อยู่โดยละเอียดของผู้ส่ง', 1),
(10023, 9, '400012', '请填写云打印机编号', 'กรุณากรอกหมายเลขเครื่องพิมพ์บนคลาวด์', 1),
(10024, 9, '400013', '请传入套餐id', 'กรุณาส่งรหัสแพ็คเกจ', 1),
(10025, 9, '400014', '套餐id必须为数字', 'รหัสแพ็คเกจต้องเป็นตัวเลข', 1),
(10026, 9, '400015', '请填写套餐金额', 'กรุณากรอกจำนวนแพ็คเกจ', 1),
(10027, 9, '400016', '请填写购买数量', 'กรุณากรอกจำนวนที่ซื้อ', 1),
(10028, 9, '400017', '购买数量必须为数字', 'ปริมาณการซื้อต้องเป็นตัวเลข', 1),
(10029, 9, '400018', '请填写购买套餐类型', 'กรุณากรอกประเภทแพ็คเกจที่ซื้อ', 1),
(10030, 9, '400019', '您输入的手机号码必须为数字', 'หมายเลขโทรศัพท์มือถือที่คุณป้อนต้องเป็นตัวเลข', 1),
(10031, 9, '400020', '密码必须填写', 'ต้องกรอกรหัสผ่าน', 1),
(10032, 9, '400021', '短信验证码必须为数字', 'รหัสยืนยัน SMS ต้องเป็นตัวเลข', 1),
(10033, 9, '400022', '请填写话术内容', 'กรุณากรอกเนื้อหาของภาษา', 1),
(10034, 9, '400023', '请填写排序数字', 'กรุณากรอกหมายเลขการเรียงลำดับ', 1),
(10035, 9, '400024', '请填写排序数字', 'กรุณากรอกหมายเลขการเรียงลำดับ', 1),
(10036, 9, '400025', '请填写运费模板名称', 'กรุณากรอกชื่อเทมเพลตการจัดส่ง', 1),
(10037, 9, '400026', '运费信息必须为数组', 'ข้อมูลการจัดส่งต้องเป็นอาร์เรย์', 1),
(10038, 9, '400027', '包邮信息必须为数组', 'ข้อมูลแพ็คเกจต้องเป็นอาร์เรย์', 1),
(10039, 9, '400028', '不送达信息必须为数组', 'ข้อมูลที่ส่งไม่ได้ต้องเป็นอาร์เรย์', 1),
(10040, 9, '400029', 'type数据格式错误，应为1或2或3', 'ข้อผิดพลาดของรูปแบบข้อมูลประเภท ควรเป็น 1 หรือ 2 หรือ 3', 1),
(10041, 9, '400030', 'appoint数据格式错误，应为0或1', 'รูปแบบข้อมูลการนัดหมายไม่ถูกต้อง ควรเป็น 0 หรือ 1', 1),
(10042, 9, '400031', 'no_delivery数据格式错误，应为0或1', 'ข้อผิดพลาดรูปแบบข้อมูล no_delivery ควรเป็น 0 หรือ 1', 1),
(10043, 9, '400032', 'sort数据格式错误，应为整数', 'รูปแบบข้อมูลผิดพลาด ควรเป็นจำนวนเต็ม', 1),
(10044, 9, '400033', '请填写管理员账号', 'กรุณากรอกบัญชีผู้ดูแลระบบ', 1),
(10045, 9, '400034', '管理员账号为英文字母', 'บัญชีผู้ดูแลระบบเป็นตัวอักษรภาษาอังกฤษ', 1),
(10046, 9, '400035', '请输管理员姓名', 'กรุณาใส่ชื่อผู้ดูแลระบบ', 1),
(10047, 9, '400036', '请选择管理员身份', 'โปรดเลือกข้อมูลประจำตัวของผู้ดูแลระบบ', 1),
(10048, 9, '400037', '身份必须为数组', 'ข้อมูลประจำตัวต้องเป็นอาร์เรย์', 1),
(10049, 9, '400038', '请填写城市名称', 'กรุณากรอกชื่อเมือง', 1),
(10050, 9, '400039', 'level数据格式错误，应为整数', 'ข้อผิดพลาดของรูปแบบข้อมูลระดับ ควรเป็นจำนวนเต็ม', 1),
(10051, 9, '400040', 'parent_id数据格式错误，应为整数', 'ข้อผิดพลาดรูปแบบข้อมูล parent_id ควรเป็นจำนวนเต็ม', 1),
(10052, 9, '400041', '请输入有效的网址', 'โปรดป้อน URL ที่ถูกต้อง', 1),
(10053, 9, '400042', '一级返佣比例必须为数字', 'อัตราส่วนเงินคืนระดับแรกต้องเป็นตัวเลข', 1),
(10054, 9, '400043', '一级返佣比例最多两位小数', 'อัตราส่วนเงินคืนระดับแรกสามารถเป็นทศนิยมได้สูงสุดสองตำแหน่ง', 1),
(10055, 9, '400044', '一级返佣比例填写范围在0-100之间', 'อัตราส่วนเงินคืนระดับแรกจะเติมในช่วงระหว่าง 0-100', 1),
(10056, 9, '400045', '二级返佣比例必须为数字', 'อัตราส่วนเงินคืนระดับที่สองต้องเป็นตัวเลข', 1),
(10057, 9, '400046', '二级返佣比例最多两位小数', 'อัตราส่วนเงินคืนระดับที่สองสามารถเป็นทศนิยมได้สูงสุดสองตำแหน่ง', 1),
(10058, 9, '400047', '二级返佣比例填写范围在0-100之间', 'อัตราส่วนเงินคืนระดับที่สองเติมในช่วงระหว่าง 0-100', 1),
(10059, 9, '400048', '待补货数量必须为数字', 'ปริมาณที่จะเติมต้องเป็นตัวเลข', 1),
(10060, 9, '400049', '警戒库存必须为数字', 'สต็อคแจ้งเตือนต้องเป็นตัวเลข', 1),
(10061, 9, '400050', '提现最小金额只能为数字', 'จำนวนถอนขั้นต่ำต้องเป็นตัวเลขเท่านั้น', 1),
(10062, 9, '400051', '提现最小金额必须大于0', 'จำนวนถอนขั้นต่ำต้องมากกว่า 0', 1),
(10063, 9, '400052', '佣金冻结时间范围在0-180之间', 'ช่วงเวลาการแช่แข็งค่าคอมมิชชั่นอยู่ระหว่าง 0-180', 1),
(10064, 9, '400053', '满额分销金额金额必须为数字', 'จำนวนการแจกจ่ายทั้งหมดต้องเป็นตัวเลข', 1),
(10065, 9, '400054', '积分抵用比例必须为数字', 'อัตราส่วนเครดิตต้องเป็นตัวเลข', 1),
(10066, 9, '400055', '积分抵用比例最多两位小数', 'เปอร์เซ็นต์ของคะแนนที่สามารถหักเป็นทศนิยมได้สูงสุดสองตำแหน่ง', 1),
(10067, 9, '400056', '积分抵用比例必须在0-1000之间', 'เปอร์เซ็นต์ของคะแนนเครดิตต้องอยู่ระหว่าง 0-1000', 1),
(10068, 9, '400057', '积分抵用上限必须为数字', 'วงเงินสูงสุดของวงเงินต้องเป็นตัวเลข', 1),
(10069, 9, '400058', '积分抵用上限必须大于等于0', 'ขีดจำกัดสูงสุดของการหักคะแนนต้องมากกว่าหรือเท่ากับ 0', 1),
(10070, 9, '400059', '下单赠送积分必须为数字', 'คะแนนโบนัสการสั่งซื้อต้องเป็นตัวเลข', 1),
(10071, 9, '400060', '下单赠送积分必须在0-1000之间', 'คะแนนโบนัสคำสั่งซื้อต้องอยู่ระหว่าง 0-1000', 1),
(10072, 9, '400061', '普通商品未支付取消订单时间必须为数字', 'ไม่ชำระค่าสินค้าธรรมดา เวลายกเลิกต้องเป็นตัวเลข', 1),
(10073, 9, '400062', '活动商品未支付取消订单时间必须为数字', 'เวลาของการยกเลิกคำสั่งซื้อต้องเป็นตัวเลขหากไม่ได้ชำระเงินสำหรับรายการกิจกรรม', 1),
(10074, 9, '400063', '砍价商品未支付取消订单时间必须为数字', 'เวลายกเลิกคำสั่งซื้อหากสินค้าที่ต่อรองไม่ชำระเงินต้องเป็นตัวเลข', 1),
(10075, 9, '400064', '拼团商品未支付取消订单时间必须为数字', 'เวลายกเลิกคำสั่งซื้อถ้าสินค้ากลุ่มไม่ชำระเงินต้องเป็นตัวเลข', 1),
(10076, 9, '400065', '订单发货后自动收货时间必须为数字', 'เวลารับสินค้าอัตโนมัติหลังจากจัดส่งคำสั่งซื้อต้องเป็นตัวเลข', 1),
(10077, 9, '400066', '满额包邮金额必须为数字', 'จำนวนการจัดส่งฟรีและเต็มจำนวนต้องเป็นตัวเลข', 1),
(10078, 9, '400067', '积分倍数必须大于0', 'ตัวคูณอินทิกรัลต้องมากกว่า 0', 1),
(10079, 9, '400068', '折扣数必须大于0', 'จำนวนส่วนลดต้องมากกว่า 0', 1),
(10080, 9, '400069', '积分倍数必须大于0', 'จำนวนเต็มต้องมากกว่า 0', 1),
(10081, 9, '400070', '折扣数必须大于0', 'จำนวนส่วนลดต้องมากกว่า 0', 1),
(10082, 9, '400071', '下单赠送经验比率必须为数字', 'อัตราส่วนประสบการณ์รางวัลต้องเป็นตัวเลขเมื่อทำการสั่งซื้อ', 1),
(10083, 9, '400072', '下单赠送经验比率必须大于0', 'อัตราส่วนประสบการณ์โบนัสคำสั่งต้องมากกว่า 0', 1),
(10084, 9, '400073', '签到赠送经验必须为数字', 'ประสบการณ์การลงชื่อเข้าใช้ต้องเป็นตัวเลข', 1),
(10085, 9, '400074', '签到赠送经验必须大于0', 'ประสบการณ์การลงชื่อเข้าใช้ต้องมากกว่า 0', 1),
(10086, 9, '400075', '邀请新用户赠送经验必须为数字', 'เชิญผู้ใช้ใหม่ให้ประสบการณ์ต้องเป็นตัวเลข', 1),
(10087, 9, '400076', '邀请新用户赠送经验必须大于0', 'เชิญผู้ใช้ใหม่เพื่อให้ประสบการณ์ต้องมากกว่า 0', 1),
(10088, 9, '400077', '发货人姓名必须为汉字', 'ชื่อผู้ส่งต้องเป็นตัวอักษรจีน', 1),
(10089, 9, '400078', '发货人姓名长度在2-10位', 'ความยาวของชื่อผู้ส่งคือ 2-10 หลัก', 1),
(10090, 9, '400079', '发货人电话必须为数字', 'หมายเลขโทรศัพท์ของผู้ส่งต้องเป็นตัวเลข', 1),
(10091, 9, '400080', '发货人电话请填写有效的手机号', 'กรุณากรอกหมายเลขโทรศัพท์มือถือที่ถูกต้องสำหรับหมายเลขโทรศัพท์ของผู้ส่ง', 1),
(10092, 9, '400081', '发货人地址只能是汉字、字母、数字', 'ที่อยู่ของผู้ส่งต้องเป็นตัวอักษรจีน ตัวอักษร และตัวเลขเท่านั้น', 1),
(10093, 9, '400082', '发货人地址长度为10-100位', 'ความยาวของที่อยู่ผู้ส่งคือ 10-100 หลัก', 1),
(10094, 9, '400083', '电子面单打印机编号必须为数字、字母', 'หมายเลขเครื่องพิมพ์ของแบบฟอร์มอิเล็กทรอนิกส์ต้องเป็นตัวเลขและตัวอักษร', 1),
(10095, 9, '400084', '电子面单打印机编号长度为10-50位', 'ความยาวของหมายเลขซีเรียลของเครื่องพิมพ์อิเล็กทรอนิคส์เครื่องเดียวคือ 10-50 หลัก', 1),
(10096, 9, '400085', '客服反馈长度位10-90位', 'ความยาวตอบกลับของฝ่ายบริการลูกค้าคือ 10-90 หลัก', 1),
(10097, 9, '400086', '请填写标签分类名称', 'กรุณากรอกชื่อหมวดหมู่ป้ายกำกับ', 1),
(10098, 9, '400087', '请填写标签分类排序', 'กรุณากรอกลำดับการจำแนกฉลาก', 1),
(10099, 9, '400088', '标签分类必须为数字', 'การจัดหมวดหมู่ฉลากต้องเป็นตัวเลข', 1),
(10100, 9, '400089', '账号只能为数字和字母', 'หมายเลขบัญชีต้องเป็นตัวเลขและตัวอักษรเท่านั้น', 1),
(10101, 9, '400090', '限量不能超过商品库存', 'ขีดจำกัดต้องไม่เกินสินค้าคงคลัง', 1),
(10102, 9, '400091', '商品已下架或移入回收站', 'สินค้าถูกนำออกจากชั้นวางหรือย้ายไปยังถังรีไซเคิล', 1),
(10103, 9, '400092', '占用库存失败', 'ไม่สามารถครอบครองสินค้าคงคลัง', 1),
(10104, 9, '400093', '商品已下架或已删除', 'สินค้าถูกถอดออกจากชั้นวางหรือถูกลบ', 1),
(10105, 9, '400094', '请选择有效的商品属性', 'โปรดเลือกแอตทริบิวต์ผลิตภัณฑ์ที่ถูกต้อง', 1),
(10106, 9, '400095', '金额不能小于0', 'จำนวนต้องไม่น้อยกว่า 0', 1),
(10107, 9, '400096', '结束时间不能小于今天', 'เวลาสิ้นสุดต้องไม่น้อยกว่าวันนี้', 1),
(10108, 9, '400097', '您不是付费会员', 'คุณไม่ได้เป็นสมาชิกแบบชำระเงิน', 1),
(10109, 9, '400098', '暂时无法领取', 'ไม่สามารถใช้งานได้ชั่วคราว', 1),
(10110, 9, '400099', '请先配置小票打印开发者', 'โปรดกำหนดค่าผู้พัฒนาการพิมพ์ใบเสร็จก่อน', 1),
(10111, 9, '400100', '请填写分类名称', 'กรุณากรอกชื่อหมวดหมู่', 1),
(10112, 9, '400101', '该分类已存在', 'หมวดหมู่นี้มีอยู่แล้ว', 1),
(10113, 9, '400102', '请先删除子分类', 'กรุณาลบหมวดหมู่ย่อยก่อน', 1),
(10114, 9, '400103', '分类不存在', 'ไม่มีการจำแนกประเภท', 1),
(10115, 9, '400104', '文件名称不能为空', 'ชื่อไฟล์ไม่สามารถเว้นว่างได้', 1),
(10116, 9, '400105', '该分类有下级分类，无法修改上级', 'หมวดหมู่นี้มีหมวดหมู่ย่อยและไม่สามารถแก้ไขส่วนที่เหนือกว่า', 1),
(10117, 9, '400106', '备注不能为空', 'หมายเหตุไม่สามารถเว้นว่างได้', 1),
(10118, 9, '400107', '请输入姓名', 'กรุณาใส่ชื่อของคุณ', 1),
(10119, 9, '400108', '请输入提现金额', 'กรุณากรอกจำนวนเงินที่ถอน', 1),
(10120, 9, '400109', '请输入支付宝账号', 'โปรดป้อนหมายเลขบัญชี Alipay', 1),
(10121, 9, '400110', '请输入微信账号', 'โปรดป้อนบัญชี WeChat ของคุณ', 1),
(10122, 9, '400111', '请输入银行卡号', 'กรุณาใส่หมายเลขบัตรธนาคาร', 1),
(10123, 9, '400112', '请输入开户行', 'กรุณาป้อนธนาคารที่เปิดบัญชี', 1),
(10124, 9, '400113', '拒绝理由不能为空', 'ต้องระบุเหตุผลในการปฏิเสธ', 1),
(10125, 9, '400114', '不能重复收货', 'ไม่สามารถรับสินค้าซ้ำได้', 1),
(10126, 9, '400115', '请先发货或者送货', 'กรุณาส่งหรือส่งก่อน', 1),
(10127, 9, '400116', '收货失败,请稍候再试', 'ไม่สามารถรับสินค้าได้ โปรดลองอีกครั้งในภายหลัง', 1),
(10128, 9, '400117', '收货成功', 'ได้รับสินค้าเรียบร้อยแล้ว', 1),
(10129, 9, '400118', '订单不存在', 'ไม่มีคำสั่งซื้อ', 1),
(10130, 9, '400119', '用户信息不存在', 'ไม่มีข้อมูลผู้ใช้', 1),
(10131, 9, '400120', '快递单号不存在', 'ไม่มีหมายเลขติดตามด่วน', 1),
(10132, 9, '400121', '打印成功', 'พิมพ์สำเร็จ', 1),
(10133, 9, '400122', '打印失败', 'การพิมพ์ล้มเหลว', 1),
(10134, 9, '400123', '快递公司编号缺失', 'ไม่มีหมายเลขบริษัทจัดส่ง', 1),
(10135, 9, '400124', '请配置腾讯地图KEY', 'โปรดกำหนดค่า KEY แผนที่ Tencent', 1),
(10136, 9, '400125', '请选择门店位置', 'กรุณาเลือกที่ตั้งร้าน', 1),
(10137, 9, '400126', '添加的核销员用户已存在', 'มีสมาชิกที่ถูกตัดสิทธิ์ที่เพิ่มเข้ามาแล้ว', 1),
(10138, 9, '400127', '请选择所属提货点', 'กรุณาเลือกจุดรับสินค้าที่คุณอยู่', 1),
(10139, 9, '400128', '请填写核销员名称', 'กรุณากรอกชื่อสมาชิกที่ถูกตัดสิทธิ์', 1),
(10140, 9, '400129', '请填写核销员电话', 'กรุณากรอกหมายเลขโทรศัพท์ของเจ้าหน้าที่ตรวจสอบ', 1),
(10141, 9, '400130', '核销员添加成功', 'เพิ่มการยืนยันสมาชิกเรียบร้อยแล้ว', 1),
(10142, 9, '400131', '核销员添加失败', 'ไม่สามารถเพิ่มสมาชิกตัดจ่าย', 1),
(10143, 9, '400132', '请填写手机号', 'กรุณากรอกหมายเลขโทรศัพท์', 1),
(10144, 9, '400133', '请填写账号', 'กรุณากรอกหมายเลขบัญชี', 1),
(10145, 9, '400134', '请填写密码', 'กรุณากรอกรหัสผ่าน', 1),
(10146, 9, '400135', '请填写短信签名', 'กรุณากรอกลายเซ็น SMS', 1),
(10147, 9, '400136', '短信签名最长为8位', 'ลายเซ็น SMS ที่ยาวที่สุดคือ 8 หลัก', 1),
(10148, 9, '400137', '请填写验证码', 'กรุณากรอกรหัสยืนยัน', 1),
(10149, 9, '400138', '请填写域名', 'กรุณากรอกชื่อโดเมน', 1),
(10150, 9, '400139', '登录成功', 'เข้าสู่ระบบสำเร็จ', 1),
(10151, 9, '400140', '账号或密码错误', 'บัญชีหรือรหัสผ่านผิดพลาด', 1),
(10152, 9, '400141', '请先填写短信配置', 'กรุณากรอกการกำหนดค่า SMS ก่อน', 1),
(10153, 9, '400142', '请输入模板名称', 'โปรดป้อนชื่อเทมเพลต', 1),
(10154, 9, '400143', '请输入模板内容', 'โปรดป้อนเนื้อหาเทมเพลต', 1),
(10155, 9, '400144', '售后订单状态不支持该操作', 'สถานะคำสั่งซื้อหลังการขายไม่รองรับการดำเนินการนี้', 1),
(10156, 9, '400145', '修改退款状态成功', 'แก้ไขสถานะการคืนเงินสำเร็จ', 1),
(10157, 9, '400146', '请输入退款金额', 'กรุณากรอกจำนวนเงินคืน', 1),
(10158, 9, '400147', '已退完支付金额，不能再退款了', 'จำนวนเงินที่ชำระได้รับคืนแล้วและไม่สามารถขอคืนได้อีก', 1),
(10159, 9, '400148', '退款金额大于支付金额，请修改退款金额', 'จำนวนเงินที่คืนมากกว่าจำนวนเงินที่ชำระ โปรดแก้ไขจำนวนเงินที่คืน', 1),
(10160, 9, '400149', '退款成功', 'การคืนเงินสำเร็จ', 1),
(10161, 9, '400150', '退款失败', 'การคืนเงินล้มเหลว', 1),
(10162, 9, '400151', '验证成功', 'ยืนยันสำเร็จ', 1),
(10163, 9, '400152', '核销成功', 'การตัดจำหน่ายสำเร็จ', 1),
(10164, 9, '400153', '核销订单未查到', 'ไม่พบคำสั่งตัดจำหน่าย', 1),
(10165, 9, '400154', '核销失败', 'การตรวจสอบล้มเหลว', 1),
(10166, 9, '400155', '订单金额必须填写', 'ต้องกรอกจำนวนการสั่งซื้อ', 1),
(10167, 9, '400156', '请选择需要删除的订单', 'โปรดเลือกคำสั่งที่จะลบ', 1),
(10168, 9, '400157', '您选择的的订单存在用户未删除的订单', 'คำสั่งซื้อที่คุณเลือกมีคำสั่งซื้อที่ผู้ใช้ยังไม่ได้ลบ', 1),
(10169, 9, '400158', '请选择发货商品', 'กรุณาเลือกรายการที่จะจัดส่ง', 1),
(10170, 9, '400159', '请重新选择发货商品或发货件数', 'กรุณาเลือกสินค้าที่จะจัดส่งอีกครั้งหรือจำนวนชิ้นที่จะจัดส่ง', 1),
(10171, 9, '400160', '订单已删除无法退积分', 'คำสั่งถูกลบและไม่สามารถขอคืนคะแนนได้', 1),
(10172, 9, '400161', '请输入积分', 'กรุณาใส่คะแนน', 1),
(10173, 9, '400162', '已退完积分', 'ได้รับแต้มคืนแล้ว', 1),
(10174, 9, '400163', '退积分大于支付积分，请修改退积分', 'คะแนนที่ได้รับคืนมากกว่าคะแนนที่จ่ายไป โปรดแก้ไขคะแนนที่ได้รับคืน', 1),
(10175, 9, '400164', '退积分成功', 'คะแนนกลับมาสำเร็จ', 1),
(10176, 9, '400165', '退积分失败', 'การถอนคะแนนล้มเหลว', 1),
(10177, 9, '400166', '请填写开票号', 'กรุณากรอกหมายเลขใบแจ้งหนี้', 1),
(10178, 9, '400167', '请填写正确的开票号', 'กรุณากรอกหมายเลขการเรียกเก็บเงินที่ถูกต้อง', 1),
(10179, 9, '400168', '请上传文件', 'กรุณาอัพโหลดไฟล์', 1),
(10180, 9, '400169', '回复成功', 'ตอบสำเร็จ', 1),
(10181, 9, '400170', '注册成功', 'การลงทะเบียนสำเร็จ', 1),
(10182, 9, '400171', '注册失败', 'การลงทะเบียนล้มเหลว', 1),
(10183, 9, '400172', '登录失败', 'การเข้าสู่ระบบล้มเหลว', 1),
(10184, 9, '400173', '获取套餐列表失败', 'ไม่สามารถรับรายการแพ็คเกจ', 1),
(10185, 9, '400174', '获取支付码失败', 'ไม่สามารถรับรหัสการชำระเงิน', 1),
(10186, 9, '400175', '请先开通短信服务', 'กรุณาเปิดใช้งานบริการ SMS ก่อน', 1),
(10187, 9, '400176', '请先开通物流查询服务', 'กรุณาเปิดบริการสอบถามด้านลอจิสติกส์ก่อน', 1),
(10188, 9, '400177', '请先开通电子面单打印服务', 'กรุณาเปิดใช้งานบริการการพิมพ์หน้าเดียวแบบอิเล็กทรอนิกส์ก่อน', 1),
(10189, 9, '400178', '请先开通商品采集服务', 'กรุณาเปิดใช้บริการรับสินค้าก่อน', 1),
(10190, 9, '400179', '请设置短信签名', 'โปรดตั้งค่าลายเซ็น SMS', 1),
(10191, 9, '400180', '修改短信签名成功', 'แก้ไขลายเซ็น SMS สำเร็จ', 1),
(10192, 9, '400181', '默认模板不能删除', 'ไม่สามารถลบเทมเพลตเริ่มต้นได้', 1),
(10193, 9, '400182', '管理员信息读取失败', 'ไม่สามารถอ่านข้อมูลผู้ดูแลระบบ', 1),
(10194, 9, '400183', '密码太过简单，请输入较为复杂的密码', 'รหัสผ่านง่ายเกินไป โปรดป้อนรหัสผ่านที่ซับซ้อนกว่านี้', 1),
(10195, 9, '400184', '协议类型不存在', 'ไม่มีประเภทโปรโตคอล', 1),
(10196, 9, '400185', '清除成功', 'ความสำเร็จที่ชัดเจน', 1),
(10197, 9, '400186', '清除失败', 'ล้างล้มเหลว', 1),
(10198, 9, '400187', '请输入名称', 'กรุณาใส่ชื่อ', 1),
(10199, 9, '400188', '请不要重复添加', 'โปรดอย่าเพิ่มซ้ำ', 1),
(10200, 9, '400189', '添加数据成功', 'เพิ่มข้อมูลสำเร็จ', 1),
(10201, 9, '400190', '请输入开始时间', 'โปรดป้อนเวลาเริ่มต้น', 1),
(10202, 9, '400191', '请输入持续时间', 'โปรดป้อนระยะเวลา', 1),
(10203, 9, '400192', '请输入0-23点之前的整点数', 'กรุณาใส่เลขจำนวนเต็มก่อน 0-23 นาฬิกา', 1),
(10204, 9, '400193', '请输入1-24点之前的整点数', 'กรุณาใส่เลขจำนวนเต็มก่อน 1-24 นาฬิกา', 1),
(10205, 9, '400194', '开始时间+持续时间不能大于24小时', 'เวลาเริ่มต้น + ระยะเวลาต้องไม่เกิน 24 ชั่วโมง', 1),
(10206, 9, '400195', '时段已占用', 'ช่วงเวลาถูกครอบครอง', 1),
(10207, 9, '400196', '请输入签到赠送积分', 'กรุณาใส่คะแนนโบนัสเช็คอิน', 1),
(10208, 9, '400197', '请输入大于等于0的整数', 'โปรดป้อนจำนวนเต็มที่มากกว่าหรือเท่ากับ 0', 1),
(10209, 9, '400198', '请填写按钮名称', 'กรุณากรอกชื่อปุ่ม', 1),
(10210, 9, '400199', '没有查到此身份', 'ไม่พบข้อมูลประจำตัว', 1),
(10211, 9, '400200', '请输入等级名称', 'โปรดป้อนชื่อระดับ', 1),
(10212, 9, '400201', '请输入等级', 'โปรดป้อนระดับ', 1),
(10213, 9, '400202', '请选择等级图标', 'โปรดเลือกไอคอนระดับ', 1),
(10214, 9, '400203', '二级返佣比例不能大于一级', 'อัตราส่วนของเงินคืนระดับที่สองไม่สามารถมากกว่าระดับแรก', 1),
(10215, 9, '400204', '当前等级已存在', 'ระดับปัจจุบันมีอยู่แล้ว', 1),
(10216, 9, '400205', '添加等级成功', 'เพิ่มระดับสำเร็จ', 1),
(10217, 9, '400206', '编辑的等级不存在', 'ไม่มีระดับการแก้ไข', 1),
(10218, 9, '400207', '请输入任务名称', 'โปรดป้อนชื่องาน', 1),
(10219, 9, '400208', '请选择任务类型', 'กรุณาเลือกประเภทงาน', 1),
(10220, 9, '400209', '请输入限定数量', 'กรุณาใส่จำนวนจำกัด', 1),
(10221, 9, '400210', '添加任务成功', 'เพิ่มงานสำเร็จ', 1),
(10222, 9, '400211', '编辑的任务不存在', 'ไม่มีงานที่แก้ไข', 1),
(10223, 9, '400212', '获取推广二维码失败，请检查您的微信配置', 'ไม่สามารถรับรหัส QR ส่งเสริมการขาย โปรดตรวจสอบการกำหนดค่า WeChat ของคุณ', 1),
(10224, 9, '400213', '上级推广人不能为自己', 'โปรโมเตอร์ที่เหนือกว่าไม่สามารถเป็นตัวของตัวเองได้', 1),
(10225, 9, '400214', '用户不存在', 'ไม่มีผู้ใช้', 1),
(10226, 9, '400215', '上级用户不存在', 'ไม่มีผู้ใช้ที่เหนือกว่า', 1),
(10227, 9, '400216', '当前推广人已经是所选人', 'โปรโมเตอร์ปัจจุบันเป็นผู้ถูกเลือกแล้ว', 1),
(10228, 9, '400217', '上级推广人不能为自己下级', 'โปรโมเตอร์ที่เหนือกว่าไม่สามารถเป็นผู้ใต้บังคับบัญชาได้', 1),
(10229, 9, '400218', '赠送成功', 'ความสำเร็จของของขวัญ', 1),
(10230, 9, '400219', '赠送失败', 'ของขวัญล้มเหลว', 1),
(10231, 9, '400220', '请输入身份名称', 'กรุณาใส่ชื่อประจำตัว', 1),
(10232, 9, '400221', '请选择最少一个权限', 'โปรดเลือกอย่างน้อยหนึ่งสิทธิ์', 1),
(10233, 9, '400222', '添加身份成功', 'เพิ่มข้อมูลประจำตัวสำเร็จ', 1),
(10234, 9, '400223', '添加身份失败', 'เพิ่มข้อมูลประจำตัวล้มเหลว', 1),
(10235, 9, '400224', '缺少APPID', 'ไม่มี APPID', 1),
(10236, 9, '400225', '请先设置空间域名', 'โปรดตั้งชื่อโดเมนช่องว่างก่อน', 1),
(10237, 9, '400226', '格式错误，请输入格式为：http://域名', 'รูปแบบไม่ถูกต้อง โปรดป้อนรูปแบบเป็น: http://ชื่อโดเมน', 1),
(10238, 9, '400227', '未有正在使用的存储空间', 'ไม่มีพื้นที่จัดเก็บในการใช้งาน', 1),
(10239, 9, '400228', '切换云存储成功,请检查是否开启使用了存储空间', 'สวิตช์ที่เก็บข้อมูลบนคลาวด์สำเร็จ โปรดตรวจสอบว่าเปิดใช้งานพื้นที่เก็บข้อมูลแล้วหรือไม่', 1),
(10240, 9, '400229', '切换本地存储成功', 'สลับที่เก็บข้อมูลในเครื่องสำเร็จ', 1),
(10241, 9, '400230', '请输入模板编号', 'กรุณาใส่หมายเลขแม่แบบ', 1),
(10242, 9, '400231', '请输入模板编号已存在,请重新输入', 'โปรดป้อนหมายเลขเทมเพลตที่มีอยู่แล้ว โปรดป้อนใหม่', 1),
(10243, 9, '400232', '请输入模板ID', 'กรุณาใส่รหัสแม่แบบ', 1),
(10244, 9, '400233', '请输入模板名', 'โปรดป้อนชื่อเทมเพลต', 1),
(10245, 9, '400234', '请输入回复内容', 'โปรดป้อนเนื้อหาตอบกลับ', 1),
(10246, 9, '400235', '添加模板消息成功', 'เพิ่มข้อความเทมเพลตเรียบร้อยแล้ว', 1),
(10247, 9, '400236', '请先配置小程序appid、appSecret等参数', 'โปรดกำหนดค่าแอพเพล็ต appid, appSecret และพารามิเตอร์อื่น ๆ ก่อน', 1),
(10248, 9, '400237', '二维码生成失败', 'การสร้างรหัส QR ล้มเหลว', 1),
(10249, 9, '400238', '请添加至少一个按钮', 'โปรดเพิ่มอย่างน้อยหนึ่งปุ่ม', 1),
(10250, 9, '400239', '请输入关键字', 'โปรดป้อนคำหลัก', 1),
(10251, 9, '400240', '请选择回复类型', 'กรุณาเลือกประเภทการตอบกลับ', 1),
(10252, 9, '400241', '回复类型有误', 'ประเภทการตอบกลับไม่ถูกต้อง', 1),
(10253, 9, '400242', '回复消息参数有误', 'พารามิเตอร์ข้อความตอบกลับไม่ถูกต้อง', 1),
(10254, 9, '400243', '请添加图文', 'กรุณาเพิ่มกราฟิก', 1),
(10255, 9, '400244', '标题不能为空', 'ต้องระบุหัวข้อ', 1),
(10256, 9, '400245', '作者不能为空', 'ต้องระบุผู้เขียน', 1),
(10257, 9, '400246', '正文不能为空', 'ข้อความไม่สามารถเว้นว่างได้', 1),
(10258, 9, '400247', '摘要不能为空', 'ข้อมูลสรุปไม่สามารถเว้นว่างได้', 1),
(10259, 9, '400248', '请先配置微信公众号appid、appSecret等参数', 'โปรดกำหนดค่าแอพบัญชีสาธารณะ WeChat, appSecret และพารามิเตอร์อื่น ๆ ก่อน', 1),
(10260, 9, '400249', '模版消息一键设置成功', 'การตั้งค่าข้อความเทมเพลตสำเร็จในคลิกเดียว', 1),
(10261, 9, '400250', '请选择用户', 'กรุณาเลือกผู้ใช้', 1),
(10262, 9, '400251', '该用户没有绑定手机号，请手动填写', 'ผู้ใช้ไม่ได้ผูกมัดกับหมายเลขโทรศัพท์มือถือ โปรดกรอกด้วยตนเอง', 1),
(10263, 9, '400252', '手机号格式错误', 'ข้อผิดพลาดรูปแบบหมายเลขโทรศัพท์มือถือ', 1),
(10264, 9, '400253', '客服已存在', 'บริการลูกค้าอยู่แล้ว', 1),
(10265, 9, '400254', '请输入账号', 'โปรดป้อนหมายเลขบัญชี', 1),
(10266, 9, '400255', '账号必须为数字或者字母的组合4-30位', 'หมายเลขบัญชีต้องเป็นตัวเลขหรือตัวอักษรรวมกัน 4-30 ตัว', 1),
(10267, 9, '400256', '请输入密码', 'โปรดป้อนรหัสผ่านของคุณ', 1),
(10268, 9, '400257', '密码必须为数字或者字母的组合6-20位', 'รหัสผ่านต้องเป็นตัวเลขหรือตัวอักษรผสมกัน 6-20 หลัก', 1),
(10269, 9, '400258', '该手机号的客服已存在', 'ฝ่ายบริการลูกค้าสำหรับหมายเลขโทรศัพท์นี้มีอยู่แล้ว', 1),
(10270, 9, '400259', '该客服账号已存在', 'บัญชีบริการลูกค้ามีอยู่แล้ว', 1),
(10271, 9, '400260', '客服添加成功', 'เพิ่มบริการลูกค้าเรียบร้อยแล้ว', 1),
(10272, 9, '400261', '客服添加失败', 'ไม่สามารถเพิ่มฝ่ายบริการลูกค้า', 1),
(10273, 9, '400262', '客服名称不能为空', 'ชื่อบริการลูกค้าไม่สามารถเว้นว่างได้', 1),
(10274, 9, '400263', '请输入确认密码', 'กรุณาใส่รหัสผ่านยืนยัน', 1),
(10275, 9, '400264', '两次输入的密码不一致', 'รหัสผ่านที่ป้อนสองครั้งไม่สอดคล้องกัน', 1),
(10276, 9, '400265', '用户不存在，客服将强制禁止登录', 'ไม่มีผู้ใช้ ฝ่ายบริการลูกค้าจะบังคับให้เข้าสู่ระบบ', 1),
(10277, 9, '400266', '登录的客服不存在', 'ไม่มีบริการลูกค้าที่เข้าสู่ระบบ', 1),
(10278, 9, '400267', '请先填写客服账号和密码再尝试进入客服平台', 'โปรดกรอกบัญชีบริการลูกค้าและรหัสผ่านก่อนพยายามเข้าสู่แพลตฟอร์มบริการลูกค้า', 1),
(10279, 9, '400268', '反馈内容不存在', 'ไม่มีเนื้อหาข้อเสนอแนะ', 1),
(10280, 9, '400269', '话术不能重复添加', 'ไม่สามารถเพิ่มคำซ้ำได้', 1),
(10281, 9, '400270', '创建话术成功', 'สร้างคำได้สำเร็จ', 1),
(10282, 9, '400271', '创建话术失败', 'สร้างการพูดคุยล้มเหลว', 1),
(10283, 9, '400272', '删除的话术不存在', 'ไม่มีคำที่ถูกลบ', 1),
(10284, 9, '400273', '系统分类不能删除', 'ไม่สามารถลบการจัดประเภทระบบ', 1),
(10285, 9, '400274', '请输入配置名称', 'โปรดป้อนชื่อการกำหนดค่า', 1),
(10286, 9, '400275', '请输入字段名称', 'โปรดป้อนชื่อฟิลด์', 1),
(10287, 9, '400276', '请输入配置简介', 'โปรดป้อนโปรไฟล์การกำหนดค่า', 1),
(10288, 9, '400277', '请输入文本框的宽度', 'โปรดป้อนความกว้างของกล่องข้อความ', 1),
(10289, 9, '400278', '请输入正确的文本框的宽度', 'โปรดป้อนความกว้างที่ถูกต้องของกล่องข้อความ', 1),
(10290, 9, '400279', '请输入多行文本框的宽度', 'โปรดป้อนความกว้างของช่องข้อความหลายบรรทัด', 1),
(10291, 9, '400280', '请输入多行文本框的高度', 'โปรดป้อนความสูงของช่องข้อความหลายบรรทัด', 1),
(10292, 9, '400281', '请输入正确的多行文本框的宽度', 'โปรดป้อนความกว้างที่ถูกต้องของช่องข้อความหลายบรรทัด', 1),
(10293, 9, '400282', '请输入正确的多行文本框的宽度', 'โปรดป้อนความกว้างที่ถูกต้องของช่องข้อความหลายบรรทัด', 1),
(10294, 9, '400283', '请输入配置参数', 'โปรดป้อนพารามิเตอร์การกำหนดค่า', 1),
(10295, 9, '400284', '添加配置成功', 'เพิ่มการกำหนดค่าสำเร็จ', 1),
(10296, 9, '400285', '一二级返佣比例不能大于100%', 'อัตราส่วนเงินคืนระดับแรกและระดับที่สองต้องไม่เกิน 100%', 1),
(10297, 9, '400286', '分销海报不能多于5张', 'โปสเตอร์การแจกจ่ายต้องไม่เกิน 5', 1),
(10298, 9, '400287', '提现最低金额只能为数字', 'จำนวนการถอนขั้นต่ำต้องเป็นตัวเลขเท่านั้น', 1),
(10299, 9, '400288', '满额分销最低金额不能为空', 'จำนวนขั้นต่ำสำหรับการกระจายแบบเต็มไม่สามารถเว้นว่างได้', 1),
(10300, 9, '400289', '满额分销最低金额不能小于0', 'จำนวนขั้นต่ำของการกระจายแบบเต็มต้องไม่น้อยกว่า 0', 1),
(10301, 9, '400290', '绑定有效期请填写正整数', 'กรุณากรอกจำนวนเต็มบวกสำหรับระยะเวลามีผลผูกพัน', 1),
(10302, 9, '400291', '请输入标题', 'โปรดป้อนชื่อ', 1),
(10303, 9, '400292', '添加配置分类成功', 'เพิ่มหมวดหมู่การกำหนดค่าสำเร็จ', 1),
(10304, 9, '400293', '存在下级配置，无法删除', 'มีการกำหนดค่าย่อยและไม่สามารถลบได้', 1),
(10305, 9, '400294', '字段至少存在一个', 'มีอย่างน้อยหนึ่งฟิลด์', 1),
(10306, 9, '400295', '添加数据组成功', 'เพิ่มกลุ่มข้อมูลสำเร็จ', 1),
(10307, 9, '400296', '数据关键字已存在', 'มีคีย์เวิร์ดข้อมูลอยู่แล้ว', 1),
(10308, 9, '400297', '字段不能为空', 'ฟิลด์นี้ไม่สามารถเว้นว่างได้', 1),
(10309, 9, '400298', '不能大于四个', 'ไม่เกินสี่', 1),
(10310, 9, '400299', '签到天数配置不能大于7天', 'กำหนดวันเช็คอินต้องไม่เกิน 7 วัน', 1),
(10311, 9, '400300', '关联成功', 'เชื่อมโยงสำเร็จ', 1),
(10312, 9, '400301', '关联失败', 'สมาคมล้มเหลว', 1),
(10313, 9, '400302', '数据缓存刷新成功', 'การรีเฟรชแคชข้อมูลสำเร็จ', 1),
(10314, 9, '400303', '数据缓存刷新失败', 'การรีเฟรชแคชข้อมูลล้มเหลว', 1),
(10315, 9, '400304', '请输入需要更换的域名', 'โปรดป้อนชื่อโดเมนที่ต้องการเปลี่ยน', 1),
(10316, 9, '400305', '域名不合法', 'ชื่อโดเมนไม่ถูกต้อง', 1),
(10317, 9, '400306', '替换成功', 'เปลี่ยนสำเร็จ', 1),
(10318, 9, '400307', '初始化完成', 'การเริ่มต้นเสร็จสมบูรณ์', 1),
(10319, 9, '400308', '备份文件可能已经损坏，请检查', 'ไฟล์สำรองอาจเสียหาย โปรดตรวจสอบ', 1),
(10320, 9, '400309', '还原数据出错', 'เกิดข้อผิดพลาดในการกู้คืนข้อมูล', 1),
(10321, 9, '400310', '正在还原...', 'กำลังกู้คืน...', 1),
(10322, 9, '400311', '还原完成', 'กู้คืนเสร็จสมบูรณ์', 1),
(10323, 9, '400312', '权益编辑成功', 'แก้ไขส่วนของผู้ถือหุ้นสำเร็จ', 1),
(10324, 9, '400313', '卡片生成成功', 'สร้างการ์ดสำเร็จ', 1),
(10325, 9, '400314', '手机号已经存在', 'หมายเลขโทรศัพท์มีอยู่แล้ว', 1),
(10326, 9, '400315', '请输入正确的身份证', 'โปรดป้อน ID ที่ถูกต้อง', 1),
(10327, 9, '400316', '请选择分组', 'กรุณาเลือกกลุ่ม', 1),
(10328, 9, '400317', '请选择标签', 'กรุณาเลือกป้ายกำกับ', 1),
(10329, 9, '400318', '加入消息队列成功', 'เข้าร่วมคิวข้อความสำเร็จ', 1),
(10330, 9, '400319', '注销成功', 'ออกจากระบบสำเร็จ', 1),
(10331, 9, '400320', '拒绝注销', 'ปฏิเสธที่จะออกจากระบบ', 1),
(10332, 9, '400321', '请输入分组名称', 'กรุณาใส่ชื่อกลุ่ม', 1),
(10333, 9, '400322', '会员标签不能为空', 'ต้องระบุป้ายกำกับสมาชิก', 1),
(10334, 9, '400323', '该分类下有标签，请先删除标签', 'มีป้ายกำกับในหมวดหมู่นี้ โปรดลบป้ายกำกับก่อน', 1),
(10335, 9, '400324', '请输入等级名称', 'โปรดป้อนชื่อระดับ', 1),
(10336, 9, '400325', '请输入等级', 'โปรดป้อนระดับ', 1),
(10337, 9, '400326', '请输入等级说明', 'โปรดป้อนคำอธิบายระดับ', 1),
(10338, 9, '400327', '请上传等级图标', 'โปรดอัปโหลดไอคอนระดับ', 1),
(10339, 9, '400328', '请上传等级背景图标', 'โปรดอัปโหลดไอคอนพื้นหลังระดับ', 1),
(10340, 9, '400329', '请输入升级经验值', 'โปรดป้อนค่าประสบการณ์การอัพเกรด', 1),
(10341, 9, '400330', '授权成功，写入数据库失败，请检查数据库链接配置', 'การอนุญาตสำเร็จ แต่ไม่สามารถเขียนไปยังฐานข้อมูล โปรดตรวจสอบการกำหนดค่าลิงก์ฐานข้อมูล', 1),
(10342, 9, '400331', '请填写公司名称', 'กรุณากรอกชื่อบริษัท', 1),
(10343, 9, '400332', '请填写授权域名', 'กรุณากรอกชื่อโดเมนที่ได้รับอนุญาต', 1),
(10344, 9, '400333', '请填写手机号码', 'กรุณากรอกหมายเลขโทรศัพท์มือถือ', 1),
(10345, 9, '400334', '请填写订单id', 'กรุณากรอกรหัสคำสั่งซื้อ', 1),
(10346, 9, '400335', '申请授权成功', 'สมัครเพื่อขออนุมัติสำเร็จ', 1),
(10347, 9, '400336', '验证码错误', 'รหัสยืนยันผิดพลาด', 1),
(10348, 9, '400337', '请选择商品', 'กรุณาเลือกผลิตภัณฑ์', 1),
(10349, 9, '400338', '请输入商品名称', 'กรุณาใส่ชื่อผลิตภัณฑ์', 1),
(10350, 9, '400339', '请选择背景图', 'กรุณาเลือกภาพพื้นหลัง', 1),
(10351, 9, '400340', '请输入直播价格', 'กรุณาใส่ราคาถ่ายทอดสด', 1),
(10352, 9, '400341', '直播价格必须大于0', 'ราคาถ่ายทอดสดต้องมากกว่า 0', 1),
(10353, 9, '400342', '请输入直播间名称', 'กรุณาใส่ชื่อห้องถ่ายทอดสด', 1),
(10354, 9, '400343', '请选择背景图', 'กรุณาเลือกภาพพื้นหลัง', 1),
(10355, 9, '400344', '请选择分享图', 'โปรดเลือกแชร์รูปภาพ', 1),
(10356, 9, '400345', '请选择主播', 'กรุณาเลือกจุดยึด', 1),
(10357, 9, '400346', '请选择直播开始、结束时间', 'โปรดเลือกเวลาเริ่มต้นและสิ้นสุดของการถ่ายทอดสด', 1),
(10358, 9, '400347', '请填写活动简介', 'กรุณากรอกข้อมูลแนะนำกิจกรรม', 1),
(10359, 9, '400348', '请填写单位', 'กรุณากรอกหน่วย', 1),
(10360, 9, '400349', '请选择商品轮播图', 'โปรดเลือกภาพหมุนของผลิตภัณฑ์', 1),
(10361, 9, '400350', '您设置得商品个数超出系统限制', 'จำนวนผลิตภัณฑ์ที่คุณตั้งค่าเกินขีดจำกัดของระบบ', 1),
(10362, 9, '400351', '模板不存在', 'ไม่มีเทมเพลต', 1),
(10363, 9, '400352', '请输入页面名称', 'กรุณาใส่ชื่อเพจ', 1),
(10364, 9, '400353', '请选择活动时间段', 'กรุณาเลือกช่วงเวลากิจกรรม', 1),
(10365, 9, '400354', '请填写购买数量限制', 'กรุณากรอกจำนวนจำกัดการซื้อ', 1),
(10366, 9, '400355', '购买数量限制必须大于0', 'ปริมาณการสั่งซื้อต้องมากกว่า 0', 1),
(10367, 9, '400356', '请填写帮砍次数', 'กรุณากรอกจำนวนครั้งที่ช่วยและตัด', 1),
(10368, 9, '400357', '帮砍次数必须大于0', 'จำนวนเครื่องหมายทับต้องมากกว่า 0', 1),
(10369, 9, '400358', '请填写砍价人数', 'กรุณากรอกจำนวนผู้ต่อรอง', 1),
(10370, 9, '400359', '砍价人数必须大于1', 'จำนวนคนที่ต่อรองต้องมากกว่า 1', 1),
(10371, 9, '400360', '请选择运费模板', 'โปรดเลือกเทมเพลตการจัดส่ง', 1),
(10372, 9, '400361', '请填写商品详情', 'กรุณากรอกรายละเอียดผลิตภัณฑ์', 1),
(10373, 9, '400362', '请选择规格', 'กรุณาเลือกข้อกำหนด', 1),
(10374, 9, '400363', '请填写虚拟拼团比例', 'กรุณากรอกอัตราส่วนกลุ่มเสมือน', 1),
(10375, 9, '400364', '虚拟参团人数不能大于成团人数', 'จำนวนผู้เข้าร่วมเสมือนต้องไม่เกินจำนวนผู้เข้าร่วมในกลุ่ม', 1),
(10376, 9, '400365', '虚拟参团人数不能大于成团人数', 'จำนวนผู้เข้าร่วมเสมือนต้องไม่เกินจำนวนผู้เข้าร่วมในกลุ่ม', 1),
(10377, 9, '400366', '请填写单次购买数量', 'กรุณากรอกจำนวนการซื้อครั้งเดียว', 1),
(10378, 9, '400367', '单次购买数量必须大于0', 'ปริมาณการซื้อครั้งเดียวต้องมากกว่า 0', 1),
(10379, 9, '400368', '请填写成团人数', 'กรุณากรอกจำนวนคนในกลุ่ม', 1),
(10380, 9, '400369', '拼团人数不能小于2人', 'จำนวนคนในกลุ่มต้องไม่น้อยกว่า 2', 1),
(10381, 9, '400370', '请填写成团有效期', 'กรุณากรอกอายุของกลุ่ม', 1),
(10382, 9, '400371', '成团有效期必须大于0', 'ระยะเวลาที่ใช้ได้ของกลุ่มต้องมากกว่า 0', 1),
(10383, 9, '400372', '请填写优惠券名称', 'กรุณากรอกชื่อคูปอง', 1),
(10384, 9, '400373', '请选择商品分类', 'กรุณาเลือกหมวดหมู่สินค้า', 1),
(10385, 9, '400374', '请填写优惠券金额', 'กรุณากรอกจำนวนคูปอง', 1),
(10386, 9, '400375', '请填写优惠券最小使用金额', 'กรุณากรอกจำนวนการใช้คูปองขั้นต่ำ', 1),
(10387, 9, '400376', '请填写优惠券有效期', 'กรุณากรอกระยะเวลาการใช้คูปอง', 1),
(10388, 9, '400377', '请选择秒杀时间段', 'โปรดเลือกช่วงเวลาของสกิล', 1),
(10389, 9, '400378', '请填写门店名称', 'กรุณากรอกชื่อร้าน', 1),
(10390, 9, '400379', '请填写门店简介', 'กรุณากรอกรายละเอียดร้านค้า', 1),
(10391, 9, '400380', '请填写门店电话', 'กรุณากรอกหมายเลขโทรศัพท์ของร้าน', 1),
(10392, 9, '400381', '请选择提货点logo', 'โปรดเลือกโลโก้จุดรับ', 1),
(10393, 9, '400382', '请选择提货点大图', 'โปรดเลือกภาพขนาดใหญ่ของจุดรับ', 1),
(10394, 9, '400383', '请选择地址', 'กรุณาเลือกที่อยู่', 1),
(10395, 9, '400384', '请填写详细地址', 'กรุณากรอกที่อยู่โดยละเอียด', 1),
(10396, 9, '400385', '请选择经纬度', 'กรุณาเลือกละติจูดและลองจิจูด', 1),
(10397, 9, '400386', '请选择营业时间', 'กรุณาเลือกเวลาทำการ', 1),
(10398, 9, '400387', '短信账号必须填写', 'ต้องกรอกบัญชี SMS', 1),
(10399, 9, '400388', '短信密码必须填写', 'ต้องกรอกรหัสผ่าน SMS', 1),
(10400, 9, '400389', '订单号必须存在', 'ต้องมีหมายเลขคำสั่งซื้อ', 1),
(10401, 9, '400390', '订单号有误', 'หมายเลขคำสั่งซื้อไม่ถูกต้อง', 1),
(10402, 9, '400391', '订单号必须为字母和数字', 'หมายเลขคำสั่งซื้อต้องเป็นตัวอักษรและตัวเลข', 1),
(10403, 9, '400392', '订单金额必须填写', 'ต้องกรอกจำนวนการสั่งซื้อ', 1),
(10404, 9, '400393', '订单金额必须为数字', 'จำนวนการสั่งซื้อต้องเป็นตัวเลข', 1),
(10405, 9, '400394', '订单金额必须填写', 'ต้องกรอกจำนวนการสั่งซื้อ', 1),
(10406, 9, '400395', '订单金额必须为数字', 'จำนวนการสั่งซื้อต้องเป็นตัวเลข', 1),
(10407, 9, '400396', '订单邮费必须填写', 'ต้องกรอกใบสั่งซื้อ', 1),
(10408, 9, '400397', '订单邮费必须为数字', 'การสั่งซื้อทางไปรษณีย์ต้องเป็นตัวเลข', 1),
(10409, 9, '400398', '赠送积分必须为数字', 'คะแนนโบนัสต้องเป็นตัวเลข', 1),
(10410, 9, '400399', '请选择用户头像', 'กรุณาเลือกรูปประจำตัวของผู้ใช้', 1),
(10411, 9, '400400', '请输入公司名称', 'กรุณาใส่ชื่อบริษัท', 1),
(10412, 9, '400401', '添加公司成功', 'เพิ่มบริษัทเรียบร้อยแล้ว', 1),
(10413, 9, '400402', '请输入月结账号', 'โปรดป้อนหมายเลขบัญชีรายเดือน', 1),
(10414, 9, '400403', '请输入月结密码', 'กรุณาใส่รหัสผ่านรายเดือน', 1),
(10415, 9, '400404', '请输入取件网点', 'กรุณาป้อนจุดรับ', 1),
(10416, 9, '400405', '缩略图大图尺寸（高）必须为数字', 'ขนาดของภาพขนาดย่อ (สูง) ต้องเป็นตัวเลข', 1),
(10417, 9, '400406', '缩略图大图尺寸（高）必须大于等于0', 'ภาพขนาดย่อขนาดใหญ่ (ความสูง) ต้องมากกว่าหรือเท่ากับ 0', 1),
(10418, 9, '400407', '缩略图大图尺寸（宽）必须为数字', 'ขนาดของภาพขนาดย่อ (กว้าง) ต้องเป็นตัวเลข', 1),
(10419, 9, '400408', '缩略图大图尺寸（宽）必须大于等于0', 'ขนาดของภาพขนาดย่อ (กว้าง) ต้องมากกว่าหรือเท่ากับ 0', 1),
(10420, 9, '400409', '缩略图中图尺寸（高）必须为数字', 'ขนาด (ความสูง) ของภาพในภาพขนาดย่อต้องเป็นตัวเลข', 1),
(10421, 9, '400410', '缩略图中图尺寸（高）必须大于等于0', 'ขนาด (ความสูง) ของภาพในภาพขนาดย่อต้องมากกว่าหรือเท่ากับ 0', 1),
(10422, 9, '400411', '缩略图中图尺寸（宽）必须为数字', 'ขนาด (ความกว้าง) ของภาพในภาพขนาดย่อต้องเป็นตัวเลข', 1),
(10423, 9, '400412', '缩略图中图尺寸（宽）必须大于等于0', 'ขนาด (ความกว้าง) ของรูปภาพในภาพขนาดย่อต้องมากกว่าหรือเท่ากับ 0', 1),
(10424, 9, '400413', '缩略图小图尺寸（高）必须为数字', 'ขนาดภาพย่อ (สูง) ต้องเป็นตัวเลข', 1),
(10425, 9, '400414', '缩略图小图尺寸（高）必须大于等于0', 'ขนาดภาพขนาดย่อ (ความสูง) ต้องมากกว่าหรือเท่ากับ 0', 1),
(10426, 9, '400415', '缩略图小图尺寸（宽）必须为数字', 'ขนาดภาพขนาดย่อ (กว้าง) ต้องเป็นตัวเลข', 1),
(10427, 9, '400416', '缩略图小图尺寸（宽）必须大于等于0', 'ขนาดภาพขนาดย่อ (ความกว้าง) ต้องมากกว่าหรือเท่ากับ 0', 1),
(10428, 9, '400417', '水印文字只能是汉字、字母、数字', 'ข้อความลายน้ำต้องเป็นตัวอักษรจีน ตัวอักษร และตัวเลขเท่านั้น', 1),
(10429, 9, '400418', '水印文字长度为1-10位', 'ความยาวของข้อความลายน้ำ 1-10 หลัก', 1),
(10430, 9, '400419', '水印文字大小必须为数字', 'ขนาดของข้อความลายน้ำต้องเป็นตัวเลข', 1),
(10431, 9, '400420', '水印文字大小必须大于等于0', 'ขนาดของข้อความลายน้ำต้องมากกว่าหรือเท่ากับ 0', 1),
(10432, 9, '400421', '水印横坐标偏移量必须为数字', 'การชดเชยลายน้ำ abscissa ต้องเป็นตัวเลข', 1),
(10433, 9, '400422', '水印横坐标偏移量必须大于等于0', 'การชดเชยลายน้ำ abscissa ต้องมากกว่าหรือเท่ากับ 0', 1),
(10434, 9, '400423', '水印纵坐标偏移量必须为数字', 'การชดเชยลายน้ำต้องเป็นตัวเลข', 1),
(10435, 9, '400424', '水印纵坐标偏移量必须大于等于0', 'การชดเชยลายน้ำต้องมากกว่าหรือเท่ากับ 0', 1),
(10436, 9, '400425', '该主播已经存在', 'มีโฮสต์อยู่แล้ว', 1),
(10437, 9, '400426', '请先去小程序认证主播', 'โปรดไปที่แอปเพล็ตเพื่อตรวจสอบสมอ', 1),
(10438, 9, '400427', '商品已创建', 'สร้างไอเท็มแล้ว', 1),
(10439, 9, '400428', '审核中或审核失败不允许此操作', 'ไม่อนุญาตให้ดำเนินการนี้ในระหว่างการตรวจสอบหรือการตรวจสอบล้มเหลว', 1),
(10440, 9, '400429', '在审核中或已经审核通过', 'อยู่ระหว่างตรวจสอบหรืออนุมัติ', 1);
INSERT INTO `eb_lang_code` (`id`, `type_id`, `code`, `remarks`, `lang_explain`, `is_admin`) VALUES
(10441, 9, '400430', '审核通过或失败', 'ผ่านการอนุมัติหรือล้มเหลว', 1),
(10442, 9, '400431', '商品审核中，无法删除', 'สินค้าอยู่ระหว่างตรวจทานและไม่สามารถลบได้', 1),
(10443, 9, '400432', '该主播不存在', 'ไม่มีสมอ', 1),
(10444, 9, '400433', '开播时间需要在当前时间的10分钟后，并且开始时间不能在6个月后', 'เวลาออกอากาศต้องเป็น 10 นาทีหลังจากเวลาปัจจุบัน และเวลาเริ่มต้นต้องไม่เกิน 6 เดือนหลังจากนั้น', 1),
(10445, 9, '400434', '开播时间和结束时间间隔不得短于30分钟，不得超过24小时', 'ช่วงเวลาระหว่างเวลาออกอากาศและเวลาสิ้นสุดต้องไม่เกิน 30 นาทีและไม่เกิน 24 ชั่วโมง', 1),
(10446, 9, '400435', '请输入理由', 'โปรดป้อนเหตุผล', 1),
(10447, 9, '400436', '请选择正确的直播商品', 'กรุณาเลือกผลิตภัณฑ์สดที่ถูกต้อง', 1),
(10448, 9, '400437', '直播间状态有误', 'สถานะของห้องถ่ายทอดสดไม่ถูกต้อง', 1),
(10449, 9, '400438', '奖品不存在', 'ไม่มีรางวัล', 1),
(10450, 9, '400439', '写入中奖记录失败', 'ไม่สามารถเขียนบันทึกที่ชนะ', 1),
(10451, 9, '400440', '请继续参与活动抽奖', 'โปรดเข้าร่วมการจับฉลากต่อไป', 1),
(10452, 9, '400441', '已经领取成功', 'ได้รับเรียบร้อยแล้ว', 1),
(10453, 9, '400442', '分销等级不存在', 'ไม่มีระดับการกระจาย', 1),
(10454, 9, '400443', '选择的等级不存在', 'ไม่มีระดับที่เลือก', 1),
(10455, 9, '400444', '该等级已存在此类型任务', 'งานประเภทนี้มีอยู่แล้วในระดับนี้', 1),
(10456, 9, '400445', '不能小于低等级同类型任务限定数量', 'ต้องไม่น้อยกว่างานระดับต่ำประเภทเดียวกันจำนวนจำกัด', 1),
(10457, 9, '400446', '不能大于高等级同类型任务限定数量', 'ต้องไม่เกินจำนวนงานระดับสูงประเภทเดียวกันที่จำกัดไม่ได้', 1),
(10458, 9, '400447', '解除失败', 'การลบล้มเหลว', 1),
(10459, 9, '400448', '代理商佣金比例不能大于事业部佣金比例', 'อัตราส่วนค่าคอมมิชชั่นตัวแทนต้องไม่เกินอัตราส่วนคอมมิชชั่นของดิวิชั่น', 1),
(10460, 9, '400449', '代理商到期时间不能大于事业部到期时间', 'เวลาหมดอายุของตัวแทนต้องไม่เกินเวลาหมดอายุของแผนกธุรกิจ', 1),
(10461, 9, '400450', '请填写用户UID', 'กรุณากรอก UID ของผู้ใช้', 1),
(10462, 9, '400451', '管理员信息未查到', 'ไม่พบข้อมูลผู้ดูแลระบบ', 1),
(10463, 9, '400452', '管理员已经删除', 'ผู้ดูแลระบบถูกลบ', 1),
(10464, 9, '400453', '管理员姓名不能为空', 'ชื่อผู้ดูแลระบบไม่สามารถเว้นว่างได้', 1),
(10465, 9, '400454', '该分类有下级分类，无法删除', 'หมวดหมู่นี้มีหมวดหมู่ย่อยและไม่สามารถลบได้', 1),
(10466, 9, '400455', '该分类下有文章，无法删除', 'มีบทความในหมวดหมู่นี้และไม่สามารถลบได้', 1),
(10467, 9, '400456', '请稍后查看', 'โปรดตรวจสอบภายหลัง', 1),
(10468, 9, '400457', '默认模板不能删除', 'ไม่สามารถลบเทมเพลตเริ่มต้นได้', 1),
(10469, 9, '400458', '该模板使用中，无法删除', 'เทมเพลตนี้ใช้งานอยู่และไม่สามารถลบได้', 1),
(10470, 9, '400459', '个人中心模板不存在', 'ไม่มีเทมเพลตศูนย์ส่วนบุคคล', 1),
(10471, 9, '400460', '反馈内容没有查到', 'ไม่พบเนื้อหาข้อเสนอแนะ', 1),
(10472, 9, '400461', '您修改的话术内容不存在', 'ไม่มีเนื้อหาของคำที่คุณแก้ไข', 1),
(10473, 9, '400462', '短信平台：{:msg}', 'แพลตฟอร์ม SMS: {:msg}', 1),
(10474, 9, '400463', '订单商品获取失败,无法打印', 'ไม่สามารถรับรายการสั่งซื้อ ไม่สามารถพิมพ์', 1),
(10475, 9, '400464', '小票打印未开启', 'ไม่ได้เปิดใช้งานการพิมพ์ใบเสร็จ', 1),
(10476, 9, '400465', '请先配置小票打印开发者', 'โปรดกำหนดค่าผู้พัฒนาการพิมพ์ใบเสร็จก่อน', 1),
(10477, 9, '400466', '请选择图片', 'กรุณาเลือกรูปภาพ', 1),
(10478, 9, '400467', '配送员已存在', 'มีคนส่งของอยู่แล้ว', 1),
(10479, 9, '400468', '同一个手机号的配送员只能添加一个', 'เพิ่มคนส่งของได้เพียงคนเดียวที่มีหมายเลขโทรศัพท์มือถือเดียวกัน', 1),
(10480, 9, '400469', '配送员名称不能为空', 'ต้องระบุชื่อผู้ส่งของ', 1),
(10481, 9, '400470', '订单未能查到,不能发货', 'ไม่พบคำสั่งซื้อและไม่สามารถจัดส่งได้', 1),
(10482, 9, '400471', '订单已删除,不能发货', 'คำสั่งซื้อถูกลบและไม่สามารถจัดส่งได้', 1),
(10483, 9, '400472', '订单已发货请勿重复操作', 'ส่งคำสั่งซื้อแล้ว โปรดอย่าดำเนินการซ้ำ', 1),
(10484, 9, '400473', '核销订单不能发货', 'ไม่สามารถจัดส่งคำสั่งตัดจ่าย', 1),
(10485, 9, '400474', '拼团未完成暂不能发货', 'การจัดกลุ่มยังไม่เสร็จสมบูรณ์และไม่สามารถจัดส่งได้ชั่วคราว', 1),
(10486, 9, '400475', '订单有售后申请请先处理', 'คำสั่งซื้อมีการสมัครหลังการขาย โปรดดำเนินการก่อน', 1),
(10487, 9, '400476', '快递公司编缺失', 'บริษัทจัดส่งหายไป', 1),
(10488, 9, '400477', '请填写寄件人电话', 'กรุณากรอกหมายเลขโทรศัพท์ของผู้ส่ง', 1),
(10489, 9, '400478', '请填写寄件人地址', 'กรุณากรอกที่อยู่ของผู้ส่ง', 1),
(10490, 9, '400479', '虚拟发货，无需修改发货信息', 'การจัดส่งเสมือนจริง ไม่จำเป็นต้องแก้ไขข้อมูลการจัดส่ง', 1),
(10491, 9, '400480', '未发货，请先发货再修改配送信息', 'ไม่ได้จัดส่ง กรุณาจัดส่งก่อนแล้วจึงแก้ไขข้อมูลการจัดส่ง', 1),
(10492, 9, '400481', '自提订单无法打印', 'ไม่สามารถพิมพ์คำสั่งให้ไปรับเองได้', 1),
(10493, 9, '400482', '请先发货', 'กรุณาจัดส่งก่อน', 1),
(10494, 9, '400483', '请先在系统设置中打开单子面单打印开关', 'โปรดเปิดสวิตช์การพิมพ์ด้านเดียวด้านเดียวในการตั้งค่าระบบ', 1),
(10495, 9, '400484', '发票已申请，正在审核打印中', 'ใบแจ้งหนี้ถูกนำไปใช้และกำลังตรวจสอบและพิมพ์', 1),
(10496, 9, '400485', '订单已退款', 'คืนเงินคำสั่งซื้อแล้ว', 1),
(10497, 9, '400486', '正在申请退款中', 'ขอเงินคืน', 1),
(10498, 9, '400487', '申请失败', 'แอปพลิเคชันล้มเหลว', 1),
(10499, 9, '400488', '未支付无法退款', 'ยังไม่ได้ชำระเงินและไม่สามารถขอคืนเงินได้', 1),
(10500, 9, '400489', '回退积分和优惠券失败', 'ไม่สามารถย้อนกลับคะแนนและคูปอง', 1),
(10501, 9, '400490', '拼团修改失败', 'การแก้ไขกลุ่มล้มเหลว', 1),
(10502, 9, '400491', '回退佣金失败', 'ไม่สามารถย้อนกลับค่าคอมมิชชั่น', 1),
(10503, 9, '400492', '余额退款失败', 'การคืนเงินยอดคงเหลือล้มเหลว', 1),
(10504, 9, '400493', '购买的优惠券已使用或者已过期', 'คูปองที่ซื้อถูกใช้หรือหมดอายุแล้ว', 1),
(10505, 9, '400494', '回退积分增加失败', 'ไม่สามารถเพิ่มจุดย้อนกลับ', 1),
(10506, 9, '400495', '售后订单不存在', 'ไม่มีคำสั่งซื้อหลังการขาย', 1),
(10507, 9, '400496', '积分已退或者积分为零无法再退', 'คะแนนได้รับคืนแล้วหรือไม่สามารถขอคืนคะแนนได้หากคะแนนเป็นศูนย์', 1),
(10508, 9, '400497', '未支付无法退积分', 'คะแนนไม่สามารถคืนได้หากไม่ชำระเงิน', 1),
(10509, 9, '400498', '订单退积分失败', 'ไม่สามารถคืนคะแนนสำหรับการสั่งซื้อ', 1),
(10510, 9, '400499', '请输入拒绝退款理由', 'โปรดป้อนเหตุผลในการปฏิเสธการคืนเงิน', 1),
(10511, 9, '400500', '限制单次购买数量不能大于总购买数量', 'จำกัดปริมาณการซื้อครั้งเดียวไม่เกินปริมาณการซื้อทั้งหมด', 1),
(10512, 9, '400501', '请添加抽奖活动名称', 'กรุณาใส่ชื่อผู้โชคดี', 1),
(10513, 9, '400502', '请添加抽奖描述等文案', 'โปรดเพิ่มคำอธิบายของลอตเตอรีและสำเนาอื่นๆ', 1),
(10514, 9, '400503', '活动结束时间必须大于开始时间', 'เวลาสิ้นสุดกิจกรรมต้องมากกว่าเวลาเริ่มต้น', 1),
(10515, 9, '400504', '请添加奖品', 'กรุณาเพิ่มรางวัล', 1),
(10516, 9, '400505', '请填写消耗数量', 'กรุณากรอกปริมาณการบริโภค', 1),
(10517, 9, '400506', '商品参与其他活动开启，无法开启预售', 'เปิดใช้งานการมีส่วนร่วมของสินค้าในกิจกรรมอื่น ๆ ไม่สามารถเปิดการขายล่วงหน้าได้', 1),
(10518, 9, '400507', '活动结束时间不能小于当前时间', 'เวลาสิ้นสุดของกิจกรรมต้องไม่น้อยกว่าเวลาปัจจุบัน', 1),
(10519, 9, '400508', '活动已结束,请重新添加或复制', 'กิจกรรมสิ้นสุดลง โปรดเพิ่มหรือคัดลอกอีกครั้ง', 1),
(10520, 9, '400509', '添加优惠券成功', 'เพิ่มคูปองสำเร็จ', 1),
(10521, 9, '400510', '发布优惠劵成功', 'ออกคูปองเรียบร้อยแล้ว', 1),
(10522, 9, '400511', '砍价最低价不能大于或等于起始金额', 'ราคาต่อรองต่ำสุดต้องไม่เกินหรือเท่ากับจำนวนเงินเริ่มต้น', 1),
(10523, 9, '400512', '砍价人数不能大于{:num}人', 'จำนวนคนที่ต่อรองต้องไม่เกิน {:num}', 1),
(10524, 9, '400513', '使用开始时间不能小于领取开始时间', 'เวลาเริ่มต้นใช้งานต้องไม่น้อยกว่าเวลาเริ่มต้นของการรวบรวม', 1),
(10525, 9, '400514', '使用结束时间不能小于领取结束时间', 'เวลาสิ้นสุดการใช้งานต้องไม่น้อยกว่าเวลาสิ้นสุดของการรวบรวม', 1),
(10526, 9, '400515', '优惠券不存在', 'ไม่มีคูปอง', 1),
(10527, 9, '400516', '领取的优惠劵已领完或已过期', 'ได้รับคูปองหรือหมดอายุแล้ว', 1),
(10528, 9, '400517', '已领取过该优惠劵', 'ได้รับคูปองแล้ว', 1),
(10529, 9, '400518', '抱歉，优惠券已经领取完了', 'ขออภัย คูปองถูกเก็บแล้ว', 1),
(10530, 9, '400519', '选择用户已拥有该优惠券，请勿重复发放', 'เลือกผู้ใช้ที่เป็นเจ้าของคูปองแล้ว กรุณาอย่าออกคูปองซ้ำ', 1),
(10531, 9, '400520', '订单已删除', 'คำสั่งที่ถูกลบ', 1),
(10532, 9, '400521', '订单已发货', 'ส่งคำสั่งซื้อแล้ว', 1),
(10533, 9, '400522', '暂时不支持其他发货类型', 'ไม่รองรับการจัดส่งประเภทอื่นชั่วคราว', 1),
(10534, 9, '400523', '请输入送货人姓名', 'กรุณาใส่ชื่อผู้ส่งของ', 1),
(10535, 9, '400524', '请输入送货人电话号码', 'กรุณาใส่หมายเลขโทรศัพท์ของผู้จัดส่ง', 1),
(10536, 9, '400525', '请输入送货人信息', 'กรุณาป้อนข้อมูลผู้จัดส่ง', 1),
(10537, 9, '400526', '请输入正确的送货人电话号码', 'โปรดป้อนหมายเลขโทรศัพท์ของผู้จัดส่งที่ถูกต้อง', 1),
(10538, 9, '400527', '请选择电子面单模板', 'โปรดเลือกเทมเพลตหน้าสลิปอิเล็กทรอนิกส์', 1),
(10539, 9, '400528', '电子面单已关闭，请选择其他发货方式', 'ใบเรียกเก็บเงินอิเล็กทรอนิกส์ถูกปิด โปรดเลือกวิธีการจัดส่งแบบอื่น', 1),
(10540, 9, '400529', '发货失败', 'การจัดส่งล้มเหลว', 1),
(10541, 9, '400530', '订单状态错误', 'สถานะการสั่งซื้อผิดพลาด', 1),
(10542, 9, '400531', '请输入快递单号', 'กรุณาใส่หมายเลขจัดส่ง', 1),
(10543, 9, '400532', '请先发货再修改配送信息', 'กรุณาจัดส่งก่อนแล้วจึงแก้ไขข้อมูลการจัดส่ง', 1),
(10544, 9, '400533', '商品不存在', 'ไม่มีสินค้าโภคภัณฑ์', 1),
(10545, 9, '400534', '您查看的积分商品已被删除', 'ลบผลิตภัณฑ์จุดที่คุณดูแล้ว', 1),
(10546, 9, '400535', '请添加商品', 'กรุณาเพิ่มสินค้า', 1),
(10547, 9, '400536', '添加抽奖活动失败', 'ไม่สามารถเพิ่มกิจกรรมลอตเตอรี', 1),
(10548, 9, '400537', '抽奖活动不存在', 'ไม่มีลอตเตอรี', 1),
(10549, 9, '400538', '请填写奖品名称', 'กรุณากรอกชื่อรางวัล', 1),
(10550, 9, '400539', '请选择奖品图片', 'กรุณาเลือกรูปรางวัล', 1),
(10551, 9, '400540', '请填写奖品中奖权重', 'กรุณากรอกน้ำหนักที่ชนะรางวัล', 1),
(10552, 9, '400541', '请选择奖品类型', 'กรุณาเลือกประเภทของรางวัล', 1),
(10553, 9, '400542', '请填写奖品赠送{:type}数', 'กรุณากรอกจำนวนรางวัลที่ได้รับ {:type}', 1),
(10554, 9, '400543', '请选择优惠券', 'กรุณาเลือกคูปอง', 1),
(10555, 9, '400544', '生成新订单失败', 'ไม่สามารถสร้างคำสั่งซื้อใหม่', 1),
(10556, 9, '400545', '修改原来订单商品拆分状态失败', 'ไม่สามารถแก้ไขสถานะการแยกรายการสั่งซื้อดั้งเดิม', 1),
(10557, 9, '400546', '新增拆分订单商品信息失败', 'ไม่สามารถเพิ่มข้อมูลผลิตภัณฑ์สำหรับการแยกคำสั่ง', 1),
(10558, 9, '400547', '保存新订单商品信息失败', 'ไม่สามารถบันทึกข้อมูลการสั่งซื้อใหม่', 1),
(10559, 9, '400548', '协议类型缺失', 'ไม่มีประเภทโปรโตคอล', 1),
(10560, 9, '400549', '请填写协议名称', 'กรุณากรอกชื่อข้อตกลง', 1),
(10561, 9, '400550', '请填写协议内容', 'กรุณากรอกเนื้อหาของข้อตกลง', 1),
(10562, 9, '400551', '该类型协议已经存在', 'โปรโตคอลประเภทนี้มีอยู่แล้ว', 1),
(10563, 9, '400552', '临时二维码获取错误', 'ข้อผิดพลาดในการรับรหัส QR ชั่วคราว', 1),
(10564, 9, '400553', '永久二维码获取错误', 'ข้อผิดพลาดในการรับรหัส QR ถาวร', 1),
(10565, 9, '400554', '请先配置接口密钥', 'โปรดกำหนดค่าคีย์อินเทอร์เฟซก่อน', 1),
(10566, 9, '400555', '无法创建文件夹，请检查您的上传目录权限', 'ไม่สามารถสร้างโฟลเดอร์ได้ โปรดตรวจสอบการอนุญาตไดเร็กทอรีอัพโหลดของคุณ', 1),
(10567, 9, '400556', '商品参数错误', 'ข้อผิดพลาดของพารามิเตอร์สินค้าโภคภัณฑ์', 1),
(10568, 9, '400557', '上传方式错误', 'วิธีการอัปโหลดไม่ถูกต้อง', 1),
(10569, 9, '400558', '格式错误', 'รูปแบบผิดพลาด', 1),
(10570, 9, '400559', '图片流获取失败', 'ไม่สามารถรับกระแสข้อมูลภาพ', 1),
(10571, 9, '400560', '商品详情保存失败', 'ไม่สามารถบันทึกรายละเอียดผลิตภัณฑ์', 1),
(10572, 9, '400561', '关联优惠券失败', 'ไม่สามารถเชื่อมโยงคูปองได้', 1),
(10573, 9, '400562', '缺少商品ID', 'ไม่มีรหัสผลิตภัณฑ์', 1),
(10574, 9, '400563', '缺少用户UID', 'ไม่มี UID ผู้ใช้', 1),
(10575, 9, '400564', '缺少订单ID', 'ไม่มีรหัสคำสั่งซื้อ', 1),
(10576, 9, '400565', '暂不支持该类型记录', 'ไม่รองรับบันทึกประเภทนี้ในขณะนี้', 1),
(10577, 9, '400566', '添加商品记录失败', 'ไม่สามารถเพิ่มบันทึกผลิตภัณฑ์', 1),
(10578, 9, '400567', '评论时间应小于当前时间', 'เวลาแสดงความคิดเห็นควรน้อยกว่าเวลาปัจจุบัน', 1),
(10579, 9, '400568', '添加虚拟评论失败', 'ไม่สามารถเพิ่มความคิดเห็นเสมือน', 1),
(10580, 9, '400569', '回复失败', 'ตอบกลับไม่สำเร็จ', 1),
(10581, 9, '400570', '请选择限购类型', 'โปรดเลือกประเภทของข้อจำกัดในการซื้อ', 1),
(10582, 9, '400571', '限购数量不能小于1', 'ขีดจำกัดการซื้อต้องไม่น้อยกว่า 1', 1),
(10583, 9, '400572', '一二级返佣相加不能大于商品售价', 'ผลรวมของเงินคืนระดับที่หนึ่งและสองต้องไม่เกินราคาของผลิตภัณฑ์', 1),
(10584, 9, '400573', '商品类型不能切换', 'ไม่สามารถเปลี่ยนประเภทผลิตภัณฑ์ได้', 1),
(10585, 9, '400574', '请输入规则名称', 'โปรดป้อนชื่อกฎ', 1),
(10586, 9, '400575', '请输入属性名称', 'โปรดป้อนชื่อแอตทริบิวต์', 1),
(10587, 9, '400576', '请输入正确的属性', 'โปรดป้อนแอตทริบิวต์ที่ถูกต้อง', 1),
(10588, 9, '400577', '请填写正确的商品信息', 'กรุณากรอกข้อมูลผลิตภัณฑ์ให้ถูกต้อง', 1),
(10589, 9, '400578', '请填写正确的商品价格', 'กรุณากรอกราคาสินค้าให้ถูกต้อง', 1),
(10590, 9, '400579', '请填写正确的商品库存', 'กรุณากรอกสินค้าคงคลังที่ถูกต้อง', 1),
(10591, 9, '400580', '请填写正确的商品成本价格', 'กรุณากรอกราคาต้นทุนสินค้าโภคภัณฑ์ที่ถูกต้อง', 1),
(10592, 9, '400581', '请上传商品图片', 'กรุณาอัพโหลดรูปภาพสินค้า', 1),
(10593, 9, '400582', '{:name}规格不存在', 'ไม่มีข้อกำหนด {:name}', 1),
(10594, 9, '400583', '{:name}属性不存在', 'ไม่มีแอตทริบิวต์ {:name}', 1),
(10595, 9, '400584', '请设置至少一个属性', 'โปรดตั้งค่าแอตทริบิวต์อย่างน้อยหนึ่งรายการ', 1),
(10596, 9, '400585', '商品参与秒杀活动开启，无法进行此操作', 'เปิดใช้งานการเข้าร่วมสินค้าโภคภัณฑ์ในกิจกรรมขัดขวาง การดำเนินการนี้ไม่สามารถทำได้', 1),
(10597, 9, '400586', '商品参与砍价活动开启，无法进行此操作', 'สินค้าโภคภัณฑ์ถูกเปิดใช้งานในการเจรจาต่อรอง การดำเนินการนี้ไม่สามารถดำเนินการ', 1),
(10598, 9, '400587', '商品参与拼团活动开启，无法进行此操作', 'เปิดใช้งานการมีส่วนร่วมของสินค้าในกิจกรรมกลุ่ม การดำเนินการนี้ไม่สามารถทำได้', 1),
(10599, 9, '400588', '会员价格不能为0', 'ราคาสมาชิกไม่สามารถเป็น 0', 1),
(10600, 9, '400589', '虚拟优惠券商品请选择优惠券', 'โปรดเลือกคูปองสำหรับผลิตภัณฑ์คูปองเสมือน', 1),
(10601, 9, '400590', '卡号：{:key}密码：{:value}，已经添加过，请重新添加卡密', 'หมายเลขบัตร: {:key} รหัสผ่าน: {:value} เพิ่มแล้ว โปรดเพิ่มรหัสการ์ดอีกครั้ง', 1),
(10602, 9, '400591', '缺少城市id无法保存', 'ไม่มีรหัสเมืองและไม่สามารถบันทึกได้', 1),
(10603, 9, '400592', '修改的模板不存在', 'ไม่มีเทมเพลตที่แก้ไข', 1),
(10604, 9, '400593', '指定区域邮费添加失败', 'ไม่สามารถเพิ่มไปรษณีย์ในพื้นที่ที่ระบุ', 1),
(10605, 9, '400594', '管理员不存在', 'ไม่มีผู้ดูแลระบบ', 1),
(10606, 9, '400595', '您已被禁止登录', 'คุณถูกแบนจากการเข้าสู่ระบบ', 1),
(10607, 9, '400596', '管理员账号已存在', 'บัญชีผู้ดูแลระบบมีอยู่แล้ว', 1),
(10608, 9, '400597', '原始密码错误', 'รหัสผ่านเดิมผิดพลาด', 1),
(10609, 9, '400598', '请输入新密码', 'โปรดป้อนรหัสผ่านใหม่', 1),
(10610, 9, '400599', '请选择要删除的图片', 'กรุณาเลือกรูปภาพที่จะลบ', 1),
(10611, 9, '400600', '移动失败或不能重复移动到同一分类下', 'การย้ายล้มเหลวหรือไม่สามารถย้ายไปยังหมวดหมู่เดียวกันซ้ำแล้วซ้ำอีก', 1),
(10612, 9, '400601', '请求不被允许', 'ไม่อนุญาตคำขอ', 1),
(10613, 9, '400602', '设置类目不被允许', 'ไม่อนุญาตให้ตั้งค่าหมวดหมู่', 1),
(10614, 9, '400603', '请输入正确格式的配置参数', 'โปรดป้อนพารามิเตอร์การกำหนดค่าในรูปแบบที่ถูกต้อง', 1),
(10615, 9, '400604', '{:name}请输入默认值', '{:name} โปรดป้อนค่าเริ่มต้น', 1),
(10616, 9, '400605', '{:name}请输入正确url', '{:name} กรุณาใส่ url ที่ถูกต้อง', 1),
(10617, 9, '400606', '保存wss证书失败', 'ไม่สามารถบันทึกใบรับรอง wss', 1),
(10618, 9, '400607', '{:name}不能为空', '{:name} ไม่สามารถเว้นว่างได้', 1),
(10619, 9, '400608', '删除的云存储不存在', 'ไม่มีที่เก็บข้อมูลบนคลาวด์ที่ถูกลบ', 1),
(10620, 9, '400609', '云存储正在使用中,需要启动其他空间才能删除', 'มีการใช้ที่เก็บข้อมูลบนคลาวด์และจำเป็นต้องเปิดใช้งานเพื่อลบพื้นที่อื่น', 1),
(10621, 9, '400610', '云空间名称不能重复', 'ชื่อพื้นที่คลาวด์ไม่สามารถทำซ้ำได้', 1),
(10622, 9, '400611', '没有权限', 'ไม่ได้รับอนุญาต', 1),
(10623, 9, '400612', '替换失败,失败原因:{:msg}', 'การเปลี่ยนล้มเหลว, สาเหตุความล้มเหลว: {:msg}', 1),
(10624, 9, '400613', '请先删除改菜单下的子菜单', 'กรุณาลบเมนูย่อยใต้เมนูก่อน', 1),
(10625, 9, '400614', '请填写批次名称', 'กรุณากรอกชื่อชุดงาน', 1),
(10626, 9, '400615', '请填写要生成卡的数量', 'กรุณากรอกจำนวนการ์ดที่จะสร้าง', 1),
(10627, 9, '400616', '卡片数量只能为正整数', 'จำนวนไพ่ต้องเป็นจำนวนเต็มบวกเท่านั้น', 1),
(10628, 9, '400617', '单次制卡数量最高不得超过6000张', 'จำนวนการ์ดสูงสุดที่ผลิตในครั้งเดียวต้องไม่เกิน 6000', 1),
(10629, 9, '400618', '请填写免费使用天数', 'กรุณากรอกจำนวนวันใช้งานฟรี', 1),
(10630, 9, '400619', '免费使用天数只能为正整数', 'จำนวนวันใช้งานฟรีต้องเป็นจำนวนเต็มบวกเท่านั้น', 1),
(10631, 9, '400620', '生成卡失败', 'ไม่สามารถสร้างการ์ด', 1),
(10632, 9, '400621', '会员功能暂未开启', 'ยังไม่ได้เปิดฟังก์ชั่นสมาชิก', 1),
(10633, 9, '400622', '请输入会员卡号', 'กรุณาใส่หมายเลขบัตรสมาชิก', 1),
(10634, 9, '400623', '请输入领取卡密', 'กรุณาใส่รหัสผ่านบัตร', 1),
(10635, 9, '400624', '会员卡不存在', 'ไม่มีบัตรสมาชิก', 1),
(10636, 9, '400625', '会员卡未激活，暂无法使用', 'บัตรสมาชิกไม่ได้เปิดใช้งานและไม่สามารถใช้ได้ชั่วคราว', 1),
(10637, 9, '400626', '会员卡密码有误', 'รหัสผ่านบัตรสมาชิกไม่ถูกต้อง', 1),
(10638, 9, '400627', '会员卡已使用', 'บัตรสมาชิกถูกใช้แล้ว', 1),
(10639, 9, '400628', '您已是永久会员，无需再领取，可以将此卡转送亲朋好友，一起享受优惠', 'คุณเป็นสมาชิกถาวรแล้ว คุณไม่จำเป็นต้องซื้ออีกต่อไป คุณสามารถโอนการ์ดใบนี้ไปให้เพื่อนและญาติเพื่อรับส่วนลดด้วยกัน', 1),
(10640, 9, '400629', '暂无此类型会员卡', 'ขณะนี้ยังไม่มีบัตรสมาชิกประเภทนี้', 1),
(10641, 9, '400630', '会员权益类型缺失', 'ประเภทผลประโยชน์การเป็นสมาชิกหายไป', 1),
(10642, 9, '400631', '请设置权益名称', 'โปรดตั้งชื่อทุน', 1),
(10643, 9, '400632', '请上传会员权益图标', 'โปรดอัปโหลดไอคอนสิทธิ์ของสมาชิก', 1),
(10644, 9, '400633', '请设置返还积分倍数', 'โปรดตั้งค่าจุดส่งคืนหลายจุด', 1),
(10645, 9, '400634', '返还积分倍数不能为负数', 'คะแนนผลตอบแทนหลายเท่าไม่สามารถติดลบได้', 1),
(10646, 9, '400635', '请设置运费折扣', 'กรุณาตั้งค่าส่วนลดการจัดส่ง', 1),
(10647, 9, '400636', '运费折扣不能为负数', 'ส่วนลดค่าขนส่งไม่สามารถติดลบได้', 1),
(10648, 9, '400637', '请设置签到积分倍数', 'กรุณาตั้งค่าจุดเช็คอินหลายจุด', 1),
(10649, 9, '400638', '签到积分倍数不能为负数', 'การลงชื่อเข้าใช้หลายจุดไม่เป็นค่าลบ', 1),
(10650, 9, '400639', '请设置线下付款折扣', 'โปรดตั้งค่าส่วนลดการชำระเงินออฟไลน์', 1),
(10651, 9, '400640', '线下付款不能为负数', 'การชำระเงินแบบออฟไลน์ไม่สามารถติดลบได้', 1),
(10652, 9, '400641', '请填写会员卡名称', 'กรุณากรอกชื่อบัตรสมาชิก', 1),
(10653, 9, '400642', '会员卡类型缺失', 'ไม่มีประเภทบัตรสมาชิก', 1),
(10654, 9, '400643', '请填写有效期（天）', 'กรุณากรอกระยะเวลาที่ใช้ได้ (วัน)', 1),
(10655, 9, '400644', '有效期（天）不能为负数', 'ระยะเวลาที่ใช้ได้ (วัน) ไม่สามารถติดลบได้', 1),
(10656, 9, '400645', '请填写价格', 'กรุณากรอกราคา', 1),
(10657, 9, '400646', '价格不能为负数', 'ราคาไม่สามารถติดลบ', 1),
(10658, 9, '400647', '优惠价不能大于原价', 'ราคาลดต้องไม่เกินราคาเดิม', 1),
(10659, 9, '400648', '地址不存在', 'ไม่มีที่อยู่', 1),
(10660, 9, '400649', '取消原来默认地址失败', 'ยกเลิกที่อยู่เริ่มต้นเดิมล้มเหลว', 1),
(10661, 9, '400650', '设置默认地址失败', 'ไม่สามารถตั้งค่าที่อยู่เริ่มต้น', 1),
(10662, 9, '400651', '地址已存在', 'ที่อยู่นี้อยู่แล้ว', 1),
(10663, 9, '400652', '收货地址格式错误', 'รูปแบบที่อยู่จัดส่งไม่ถูกต้อง', 1),
(10664, 9, '400653', '请登录', 'กรุณาเข้าสู่ระบบ', 1),
(10665, 9, '400654', '登录已过期,请重新登录', 'การเข้าสู่ระบบหมดอายุ โปรดเข้าสู่ระบบอีกครั้ง', 1),
(10666, 9, '400655', '增加记录失败', 'เพิ่มบันทึกล้มเหลว', 1),
(10667, 9, '400656', '记录分享记录失败', 'บันทึกการแชร์บันทึกล้มเหลว', 1),
(10668, 9, '400657', '增加用户佣金失败', 'ไม่สามารถเพิ่มค่าคอมมิชชั่นผู้ใช้', 1),
(10669, 9, '400658', '企业付款到零钱失败，请稍后再试', 'บริษัทไม่สามารถชำระเงินได้ โปรดลองอีกครั้งในภายหลัง', 1),
(10670, 9, '400659', '已经提现', 'ถอนออกแล้ว', 1),
(10671, 9, '400660', '您的提现申请已被拒绝', 'คำขอถอนเงินของคุณถูกปฏิเสธ', 1),
(10672, 9, '400661', '可提现佣金不足', 'ค่าคอมมิชชั่นไม่เพียงพอในการถอนเงินสด', 1),
(10673, 9, '400662', '提现金额不能小于{:money}元', 'จำนวนถอนต้องไม่น้อยกว่า {:money} หยวน', 1),
(10674, 9, '400663', '提现佣金不足{:money}元', 'ค่าคอมมิชชั่นสำหรับการถอนไม่เพียงพอ {:money} หยวน', 1),
(10675, 9, '400664', '提现佣金大于0', 'ค่าคอมมิชชั่นสำหรับการถอนมากกว่า 0', 1),
(10676, 9, '400665', '企业微信付款到零钱最低金额为1元', 'การชำระเงิน WeChat สำหรับองค์กรเพื่อเปลี่ยนจำนวนเงินขั้นต่ำคือ 1 หยวน', 1),
(10677, 9, '400666', '该分组已经存在', 'กลุ่มนี้มีอยู่แล้ว', 1),
(10678, 9, '400667', '清空用户标签失败', 'ไม่สามารถล้างป้ายกำกับผู้ใช้', 1),
(10679, 9, '400668', '设置标签失败', 'ไม่สามารถตั้งค่าป้ายกำกับ', 1),
(10680, 9, '400669', '请选择标签分类', 'โปรดเลือกการจัดหมวดหมู่ป้ายกำกับ', 1),
(10681, 9, '400670', '该标签已经存在', 'ป้ายกำกับมีอยู่แล้ว', 1),
(10682, 9, '400671', '修改用户等级信息失败', 'ไม่สามารถแก้ไขข้อมูลระดับผู้ใช้', 1),
(10683, 9, '400672', '用户等级不存在', 'ไม่มีระดับผู้ใช้', 1),
(10684, 9, '400673', '用户等级经验必须大于上一等级设置的经验', 'ประสบการณ์ระดับผู้ใช้ต้องมากกว่าประสบการณ์ที่กำหนดโดยระดับก่อนหน้า', 1),
(10685, 9, '400674', '用户等级经验必须小于下一等级设置的经验', 'ประสบการณ์ระดับผู้ใช้ต้องน้อยกว่าประสบการณ์ที่กำหนดโดยระดับถัดไป', 1),
(10686, 9, '400675', '已检测到您设置过的用户等级，此等级不可重复', 'ตรวจพบระดับผู้ใช้ที่คุณตั้งไว้ ระดับนี้ไม่สามารถทำซ้ำได้', 1),
(10687, 9, '400676', '已检测到您设置过该用户等级经验值，经验值不可重复', 'ตรวจพบว่าคุณตั้งค่าประสบการณ์ระดับผู้ใช้นี้ ค่าประสบการณ์ไม่สามารถทำซ้ำได้', 1),
(10688, 9, '400677', '订单未支付', 'คำสั่งซื้อไม่ชำระเงิน', 1),
(10689, 9, '400678', '佣金转入余额，不能退款', 'ค่าคอมมิชชั่นถูกโอนไปยังยอดคงเหลือและไม่สามารถขอคืนได้', 1),
(10690, 9, '400679', '已支付的订单记录无法删除', 'ไม่สามารถลบบันทึกการสั่งซื้อที่ชำระเงินแล้ว', 1),
(10691, 9, '400680', '转入金额不能大于可提现佣金', 'จำนวนเงินที่โอนต้องไม่เกินค่าคอมมิชชั่นที่สามารถถอนได้', 1),
(10692, 9, '400681', '写入余额充值失败', 'ไม่สามารถเขียนการเติมเงินได้', 1),
(10693, 9, '400682', '您选择的充值方式已下架', 'วิธีการเติมเงินที่คุณเลือกถูกลบ', 1),
(10694, 9, '400683', '充值订单生成失败', 'ไม่สามารถสร้างคำสั่งเติมเงิน', 1),
(10695, 9, '400684', '保存用户信息失败', 'ไม่สามารถบันทึกข้อมูลผู้ใช้', 1),
(10696, 9, '400685', '密码重置失败', 'การรีเซ็ตรหัสผ่านล้มเหลว', 1),
(10697, 9, '400686', '增加推广人数失败', 'ไม่สามารถเพิ่มจำนวนโปรโมชั่น', 1),
(10698, 9, '400687', '设置登录类型失败', 'ไม่สามารถตั้งค่าประเภทการเข้าสู่ระบบ', 1),
(10699, 9, '400688', '设置推广员失败', 'ตั้งค่าโปรโมเตอร์ล้มเหลว', 1),
(10700, 9, '400689', '增加用户余额失败', 'ไม่สามารถเพิ่มยอดเงินคงเหลือของผู้ใช้', 1),
(10701, 9, '400690', '减少用户余额失败', 'ไม่สามารถลดยอดเงินคงเหลือของผู้ใช้', 1),
(10702, 9, '400691', '减少用户佣金失败', 'ล้มเหลวในการลดค่าคอมมิชชั่นผู้ใช้', 1),
(10703, 9, '400692', '增加用户积分失败', 'ไม่สามารถเพิ่มคะแนนผู้ใช้', 1),
(10704, 9, '400693', '减少用户积分失败', 'ล้มเหลวในการลดคะแนนผู้ใช้', 1),
(10705, 9, '400694', '增加用户经验失败', 'ไม่สามารถเพิ่มประสบการณ์ผู้ใช้', 1),
(10706, 9, '400695', '减少用户经验失败', 'ความล้มเหลวในการลดประสบการณ์ผู้ใช้', 1),
(10707, 9, '400696', '该分组不存在', 'ไม่มีกลุ่ม', 1),
(10708, 9, '400697', '设置分组失败或无改动', 'ไม่สามารถตั้งค่าการจัดกลุ่มหรือไม่มีการเปลี่ยนแปลง', 1),
(10709, 9, '400698', '有标签不存在或被删除', 'ไม่มีป้ายกำกับหรือถูกลบ', 1),
(10710, 9, '400699', '等级不存在或被删除', 'ไม่มีคลาสหรือถูกลบ', 1),
(10711, 9, '400700', '此用户已有该用户等级，无法再次赠送', 'ผู้ใช้รายนี้มีระดับผู้ใช้นี้อยู่แล้วและไม่สามารถให้ได้อีก', 1),
(10712, 9, '400701', '赠送天数不能为0', 'วันของขวัญไม่สามารถเป็น 0', 1),
(10713, 9, '400702', '天数输入错误', 'จำนวนวันไม่ถูกต้อง', 1),
(10714, 9, '400703', '用户信息储存失败', 'ไม่สามารถจัดเก็บข้อมูลผู้ใช้', 1),
(10715, 9, '400704', '您得ip不再白名单中,请前往腾讯微信公众平台添加ip白名单', 'ไอพีของคุณไม่อยู่ในรายการที่อนุญาตอีกต่อไป โปรดไปที่แพลตฟอร์มสาธารณะ Tencent WeChat เพื่อเพิ่ม IP ในรายการที่อนุญาต', 1),
(10716, 9, '400705', '您填写得appid无效,请检查', 'Appid ที่คุณกรอกไม่ถูกต้อง โปรดตรวจสอบ', 1),
(10717, 9, '400706', '请输入回复信息内容', 'โปรดป้อนเนื้อหาของข้อความตอบกลับ', 1),
(10718, 9, '400707', '请上传回复的图片', 'โปรดอัปโหลดรูปภาพของการตอบกลับ', 1),
(10719, 9, '400708', '请上传回复的声音', 'โปรดอัปโหลดเสียงตอบกลับ', 1),
(10720, 9, '400709', '请选择图文消息', 'กรุณาเลือกข้อความ', 1),
(10721, 9, '400710', '对应的uid不存在', 'ไม่มี uid ที่เกี่ยวข้อง', 1),
(10722, 9, '400711', '取消关注失败', 'เลิกติดตามล้มเหลว', 1),
(10723, 9, '400712', '电子面单模板ID缺失', 'ไม่มี ID ของเทมเพลตสลิปหน้าอิเล็กทรอนิกส์', 1),
(10724, 9, '400713', '快递公司编码缺失', 'ไม่มีรหัสบริษัทจัดส่ง', 1),
(10725, 9, '400714', '寄件人信息缺失', 'ข้อมูลผู้ส่งหายไป', 1),
(10726, 9, '400715', '收件人信息缺失', 'ข้อมูลผู้รับหายไป', 1),
(10727, 9, '400716', '云打印机编号缺失', 'ไม่มีหมายเลขเครื่องพิมพ์บนคลาวด์', 1),
(10728, 9, '400717', '商品数量缺失', 'ไม่มีจำนวนสินค้า', 1),
(10729, 9, '400718', '获取access_token获取失败', 'ไม่สามารถรับ access_token', 1),
(10730, 9, '400719', '手机号不能为空', 'หมายเลขโทรศัพท์มือถือไม่สามารถเว้นว่างได้', 1),
(10731, 9, '400720', '模版ID不存在', 'ไม่มีรหัสเทมเพลต', 1),
(10732, 9, '400721', '请先配置accessKey和secretKey', 'โปรดกำหนดค่า accessKey และ secretKey ก่อน', 1),
(10733, 9, '400722', '请先配置水印图片', 'โปรดกำหนดค่าภาพลายน้ำก่อน', 1),
(10734, 9, '400723', '请先配置水印文字', 'โปรดกำหนดค่าข้อความลายน้ำก่อน', 1),
(10735, 9, '400724', '远程水印图片下载失败', 'การดาวน์โหลดภาพลายน้ำระยะไกลล้มเหลว', 1),
(10736, 9, '400725', '上传图片不存在', 'ไม่มีภาพที่อัปโหลด', 1),
(10737, 9, '400726', '图片流获取失败', 'ไม่สามารถรับกระแสข้อมูลภาพ', 1),
(10738, 9, '400727', '图片下载失败', 'การดาวน์โหลดรูปภาพล้มเหลว', 1),
(10739, 9, '400728', '必须上传xlsx格式文件', 'ต้องอัปโหลดไฟล์รูปแบบ xlsx', 1),
(10740, 9, '400729', '数据不能为空', 'ข้อมูลต้องไม่ว่างเปล่า', 1),
(10741, 9, '400730', '缺少pay_price', 'ไม่มี pay_price', 1),
(10742, 9, '400731', '退款失败:{:msg}', 'การคืนเงินล้มเหลว: {:msg}', 1),
(10743, 9, '400732', '获取微信粉丝信息失败', 'ไม่สามารถรับข้อมูลแฟน WeChat', 1),
(10744, 9, '400733', '您已关闭上传功能', 'คุณได้ปิดฟังก์ชันการอัปโหลด', 1),
(10745, 9, '400734', '文件不可写', 'ไฟล์นี้ไม่สามารถเขียนได้', 1),
(10746, 9, '400735', '时间格式不正确', 'รูปแบบเวลาไม่ถูกต้อง', 1),
(10747, 9, '400736', '文件可能损坏，请检查', 'ไฟล์อาจเสียหาย โปรดตรวจสอบ', 1),
(10748, 9, '400737', '修复错误，请重试', 'แก้ไขข้อผิดพลาด โปรดลองอีกครั้ง', 1),
(10749, 9, '400738', '请指定要修复的表', 'โปรดระบุตารางที่จะซ่อม', 1),
(10750, 9, '400739', '请配置支付证书', 'โปรดกำหนดค่าใบรับรองการชำระเงิน', 1),
(10751, 9, '400740', '只支持两级分类', 'รองรับการจำแนกสองระดับเท่านั้น', 1),
(10752, 9, '400741', '运费格式错误', 'รูปแบบการขนส่งสินค้าผิดพลาด', 1),
(10753, 9, '400742', '请检查属性编码或库存数量', 'โปรดตรวจสอบรหัสแอตทริบิวต์หรือจำนวนสต็อค', 1),
(10754, 9, '400743', '同步条数不能超过100', 'จำนวนแถบการซิงโครไนซ์ต้องไม่เกิน 100', 1),
(10755, 9, '400744', 'appid或appsecret错误', 'appid หรือ appsecret error', 1),
(10756, 9, '400745', '父级ID参数类型错误', 'ประเภทพารามิเตอร์ ID หลักไม่ถูกต้อง', 1),
(10757, 