<?php
# Code generated by protoc-gen-volcengine-sdk
# source: Vod
# DO NOT EDIT!

namespace Volc\Service\Vod;

use Exception;
use Throwable;
use Volc\Base\V4Curl;
use Volc\Service\Vod\Models\Request\VodGetAllPlayInfoRequest;
use Volc\Service\Vod\Models\Response\VodGetAllPlayInfoResponse;
use Volc\Service\Vod\Models\Request\VodGetPlayInfoRequest;
use Volc\Service\Vod\Models\Response\VodGetPlayInfoResponse;
use Volc\Service\Vod\Models\Request\VodGetPrivateDrmPlayAuthRequest;
use Volc\Service\Vod\Models\Response\VodGetPrivateDrmPlayAuthResponse;
use Volc\Service\Vod\Models\Request\VodGetHlsDecryptionKeyRequest;
use Volc\Service\Vod\Models\Response\VodGetHlsDecryptionKeyResponse;
use Volc\Service\Vod\Models\Request\VodGetPlayInfoWithLiveTimeShiftSceneRequest;
use Volc\Service\Vod\Models\Response\VodGetPlayInfoWithLiveTimeShiftSceneResponse;
use Volc\Service\Vod\Models\Request\VodUrlUploadRequest;
use Volc\Service\Vod\Models\Response\VodUrlUploadResponse;
use Volc\Service\Vod\Models\Request\VodQueryUploadTaskInfoRequest;
use Volc\Service\Vod\Models\Response\VodQueryUploadTaskInfoResponse;
use Volc\Service\Vod\Models\Request\VodApplyUploadInfoRequest;
use Volc\Service\Vod\Models\Response\VodApplyUploadInfoResponse;
use Volc\Service\Vod\Models\Request\VodCommitUploadInfoRequest;
use Volc\Service\Vod\Models\Response\VodCommitUploadInfoResponse;
use Volc\Service\Vod\Models\Request\VodUpdateMediaInfoRequest;
use Volc\Service\Vod\Models\Response\VodUpdateMediaInfoResponse;
use Volc\Service\Vod\Models\Request\VodUpdateMediaPublishStatusRequest;
use Volc\Service\Vod\Models\Response\VodUpdateMediaPublishStatusResponse;
use Volc\Service\Vod\Models\Request\VodGetMediaInfosRequest;
use Volc\Service\Vod\Models\Response\VodGetMediaInfosResponse;
use Volc\Service\Vod\Models\Request\VodGetRecommendedPosterRequest;
use Volc\Service\Vod\Models\Response\VodGetRecommendedPosterResponse;
use Volc\Service\Vod\Models\Request\VodDeleteMediaRequest;
use Volc\Service\Vod\Models\Response\VodDeleteMediaResponse;
use Volc\Service\Vod\Models\Request\VodDeleteTranscodesRequest;
use Volc\Service\Vod\Models\Response\VodDeleteTranscodesResponse;
use Volc\Service\Vod\Models\Request\VodGetMediaListRequest;
use Volc\Service\Vod\Models\Response\VodGetMediaListResponse;
use Volc\Service\Vod\Models\Request\VodGetSubtitleInfoListRequest;
use Volc\Service\Vod\Models\Response\VodGetSubtitleInfoListResponse;
use Volc\Service\Vod\Models\Request\VodUpdateSubtitleStatusRequest;
use Volc\Service\Vod\Models\Response\VodUpdateSubtitleStatusResponse;
use Volc\Service\Vod\Models\Request\VodUpdateSubtitleInfoRequest;
use Volc\Service\Vod\Models\Response\VodUpdateSubtitleInfoResponse;
use Volc\Service\Vod\Models\Request\VodGetAuditFramesForAuditRequest;
use Volc\Service\Vod\Models\Response\VodGetAuditFramesForAuditResponse;
use Volc\Service\Vod\Models\Request\VodGetMLFramesForAuditRequest;
use Volc\Service\Vod\Models\Response\VodGetMLFramesForAuditResponse;
use Volc\Service\Vod\Models\Request\VodGetBetterFramesForAuditRequest;
use Volc\Service\Vod\Models\Response\VodGetBetterFramesForAuditResponse;
use Volc\Service\Vod\Models\Request\VodGetAudioInfoForAuditRequest;
use Volc\Service\Vod\Models\Response\VodGetAudioInfoForAuditResponse;
use Volc\Service\Vod\Models\Request\VodGetAutomaticSpeechRecognitionForAuditRequest;
use Volc\Service\Vod\Models\Response\VodGetAutomaticSpeechRecognitionForAuditResponse;
use Volc\Service\Vod\Models\Request\VodGetAudioEventDetectionForAuditRequest;
use Volc\Service\Vod\Models\Response\VodGetAudioEventDetectionForAuditResponse;
use Volc\Service\Vod\Models\Request\VodCreateVideoClassificationRequest;
use Volc\Service\Vod\Models\Response\VodCreateVideoClassificationResponse;
use Volc\Service\Vod\Models\Request\VodUpdateVideoClassificationRequest;
use Volc\Service\Vod\Models\Response\VodUpdateVideoClassificationResponse;
use Volc\Service\Vod\Models\Request\VodDeleteVideoClassificationRequest;
use Volc\Service\Vod\Models\Response\VodDeleteVideoClassificationResponse;
use Volc\Service\Vod\Models\Request\VodListVideoClassificationsRequest;
use Volc\Service\Vod\Models\Response\VodListVideoClassificationsResponse;
use Volc\Service\Vod\Models\Request\VodListSnapshotsRequest;
use Volc\Service\Vod\Models\Response\VodListSnapshotsResponse;
use Volc\Service\Vod\Models\Request\VodStartWorkflowRequest;
use Volc\Service\Vod\Models\Response\VodStartWorkflowResponse;
use Volc\Service\Vod\Models\Request\VodRetrieveTranscodeResultRequest;
use Volc\Service\Vod\Models\Response\VodRetrieveTranscodeResultResponse;
use Volc\Service\Vod\Models\Request\VodGetWorkflowExecutionStatusRequest;
use Volc\Service\Vod\Models\Response\VodGetWorkflowExecutionStatusResponse;
use Volc\Service\Vod\Models\Request\VodSubmitDirectEditTaskAsyncRequest;
use Volc\Service\Vod\Models\Response\VodSubmitDirectEditTaskAsyncResponse;
use Volc\Service\Vod\Models\Request\VodGetDirectEditResultRequest;
use Volc\Service\Vod\Models\Response\VodGetDirectEditResultResponse;
use Volc\Service\Vod\Models\Request\VodGetDirectEditProgressRequest;
use Volc\Service\Vod\Models\Response\VodGetDirectEditProgressResponse;
use Volc\Service\Vod\Models\Request\VodCreateSpaceRequest;
use Volc\Service\Vod\Models\Response\VodCreateSpaceResponse;
use Volc\Service\Vod\Models\Request\VodListSpaceRequest;
use Volc\Service\Vod\Models\Response\VodListSpaceResponse;
use Volc\Service\Vod\Models\Request\VodGetSpaceDetailRequest;
use Volc\Service\Vod\Models\Response\VodGetSpaceDetailResponse;
use Volc\Service\Vod\Models\Request\VodUpdateSpaceRequest;
use Volc\Service\Vod\Models\Response\VodUpdateSpaceResponse;
use Volc\Service\Vod\Models\Request\VodUpdateSpaceUploadConfigRequest;
use Volc\Service\Vod\Models\Response\VodUpdateSpaceUploadConfigResponse;
use Volc\Service\Vod\Models\Request\VodDescribeVodSpaceStorageDataRequest;
use Volc\Service\Vod\Models\Response\VodDescribeVodSpaceStorageDataResponse;
use Volc\Service\Vod\Models\Request\VodListDomainRequest;
use Volc\Service\Vod\Models\Response\VodListDomainResponse;
use Volc\Service\Vod\Models\Request\VodCreateCdnRefreshTaskRequest;
use Volc\Service\Vod\Models\Response\VodCreateCdnRefreshTaskResponse;
use Volc\Service\Vod\Models\Request\VodCreateCdnPreloadTaskRequest;
use Volc\Service\Vod\Models\Response\VodCreateCdnPreloadTaskResponse;
use Volc\Service\Vod\Models\Request\VodListCdnTasksRequest;
use Volc\Service\Vod\Models\Response\VodListCdnTasksResponse;
use Volc\Service\Vod\Models\Request\VodListCdnAccessLogRequest;
use Volc\Service\Vod\Models\Response\VodListCdnAccessLogResponse;
use Volc\Service\Vod\Models\Request\VodListCdnTopAccessUrlRequest;
use Volc\Service\Vod\Models\Response\VodListCdnTopAccessUrlResponse;
use Volc\Service\Vod\Models\Request\VodDescribeVodDomainBandwidthDataRequest;
use Volc\Service\Vod\Models\Response\VodDescribeVodDomainBandwidthDataResponse;
use Volc\Service\Vod\Models\Request\VodListCdnUsageDataRequest;
use Volc\Service\Vod\Models\Response\VodCdnStatisticsCommonResponse;
use Volc\Service\Vod\Models\Request\VodListCdnStatusDataRequest;
use Volc\Service\Vod\Models\Request\VodDescribeIPInfoRequest;
use Volc\Service\Vod\Models\Response\VodDescribeIPInfoResponse;
use Volc\Service\Vod\Models\Request\VodDescribeVodDomainTrafficDataRequest;
use Volc\Service\Vod\Models\Response\VodDescribeVodDomainTrafficDataResponse;
use Volc\Service\Vod\Models\Request\VodListCdnPvDataRequest;
use Volc\Service\Vod\Models\Request\VodAddCallbackSubscriptionRequest;
use Volc\Service\Vod\Models\Response\VodAddCallbackSubscriptionResponse;
use Volc\Service\Vod\Models\Request\VodSetCallbackEventRequest;
use Volc\Service\Vod\Models\Response\VodSetCallbackEventResponse;
use Volc\Service\Vod\Models\Request\VodGetSmartStrategyLitePlayInfoRequest;
use Volc\Service\Vod\Models\Response\VodGetSmartStrategyLitePlayInfoResponse;
use Volc\Service\Vod\Models\Request\VodGetAppInfoRequest;
use Volc\Service\Vod\Models\Response\VodGetAppInfoResponse;

/**
 * Generated from protobuf service <code>vod/service/service_vod.proto</code>
 */
class Vod extends V4Curl
{

    protected $apiList;

    public function __construct()
    {
        $this->region = func_get_arg(0);
        $this->apiList = VodOption::$apiList;
        parent::__construct($this->region);
    }

    /**
     * @throws Exception
     */
    protected function getConfig(string $region): array
    {
        try {
            return VodOption::getConfig($region);
        } catch (Exception $e) {
            print_r($e->getMessage());
            print_r($e->getTraceAsString());
            throw $e;
        }
    }

    /**
     * @throws Throwable
     */
    public function getPlayAuthToken(VodGetPlayInfoRequest $req, int $expireSeconds): string
    {
        try {
            $query = VodUtils::formatRequestParam($req);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($expireSeconds > 0) {
            $query["X-Expires"] = $expireSeconds;
        }
        $token = ["TokenVersion" => "V2"];
        $token["GetPlayInfoToken"] = parse_url($this->getRequestUrl("GetPlayInfo", ['query' => $query]))['query'];
        return base64_encode(json_encode($token));
    }

    /**
     * @throws Throwable
     */
    public function getSubtitleAuthToken(VodGetSubtitleInfoListRequest $req, int $expireSeconds): string
    {
        try {
            if ($req->getVid() == "") {
                throw new Exception("传入的Vid为空");
            }
            $query = array("Vid" => $req->getVid());
            $query["Status"] = "Published";
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($expireSeconds > 0) {
            $query["X-Expires"] = $expireSeconds;
        }
        $token["GetSubtitleAuthToken"] = parse_url($this->getRequestUrl("GetSubtitleInfoList", ['query' => $query]))['query'];
        return base64_encode(json_encode($token));
    }

    public function getUploadVideoAuth(): array
    {
        return $this->getUploadVideoAuthWithExpiredTime(60 * 60);
    }

    public function getUploadVideoAuthWithExpiredTime(int $expire): array
    {
        $actions = [ActionApplyUpload, ActionCommitUpload];
        $resources = [];
        $statement = $this->newAllowStatement($actions, $resources);
        $policy = [
            Statement => [$statement],
        ];
        return $this->signSts2($policy, $expire);
    }

    /**
     * @throws Throwable
     */
    public function getSHA1HlsDrmAuthToken(int $expireSeconds): string
    {
        return $this->createHlsDrmAuthToken("HMAC-SHA1", $expireSeconds);
    }

    /**
     * @throws Throwable
     */
    public function getPrivateDrmPlayAuthToken(VodGetPrivateDrmPlayAuthRequest $req, int $expireSeconds): string
    {
        try {
            $query = VodUtils::formatRequestParam($req);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($expireSeconds > 0) {
            $query["X-Expires"] = $expireSeconds;
        }
        return parse_url($this->getRequestUrl("GetPrivateDrmPlayAuth", ['query' => $query]))['query'];
    }

    /**
     * GetAllPlayInfo.
     *
     * @param $req VodGetAllPlayInfoRequest
     * @return VodGetAllPlayInfoResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getAllPlayInfo(VodGetAllPlayInfoRequest $req): VodGetAllPlayInfoResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetAllPlayInfo', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetAllPlayInfoResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetPlayInfo.
     *
     * @param $req VodGetPlayInfoRequest
     * @return VodGetPlayInfoResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getPlayInfo(VodGetPlayInfoRequest $req): VodGetPlayInfoResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetPlayInfo', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetPlayInfoResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetPrivateDrmPlayAuth.
     *
     * @param $req VodGetPrivateDrmPlayAuthRequest
     * @return VodGetPrivateDrmPlayAuthResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getPrivateDrmPlayAuth(VodGetPrivateDrmPlayAuthRequest $req): VodGetPrivateDrmPlayAuthResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetPrivateDrmPlayAuth', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetPrivateDrmPlayAuthResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetHlsDecryptionKey.
     *
     * @param $req VodGetHlsDecryptionKeyRequest
     * @return VodGetHlsDecryptionKeyResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getHlsDecryptionKey(VodGetHlsDecryptionKeyRequest $req): VodGetHlsDecryptionKeyResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetHlsDecryptionKey', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetHlsDecryptionKeyResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetPlayInfoWithLiveTimeShiftScene.
     *
     * @param $req VodGetPlayInfoWithLiveTimeShiftSceneRequest
     * @return VodGetPlayInfoWithLiveTimeShiftSceneResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getPlayInfoWithLiveTimeShiftScene(VodGetPlayInfoWithLiveTimeShiftSceneRequest $req): VodGetPlayInfoWithLiveTimeShiftSceneResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetPlayInfoWithLiveTimeShiftScene', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetPlayInfoWithLiveTimeShiftSceneResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * UploadMediaByUrl.
     *
     * @param $req VodUrlUploadRequest
     * @return VodUrlUploadResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function uploadMediaByUrl(VodUrlUploadRequest $req): VodUrlUploadResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('UploadMediaByUrl', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodUrlUploadResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * QueryUploadTaskInfo.
     *
     * @param $req VodQueryUploadTaskInfoRequest
     * @return VodQueryUploadTaskInfoResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function queryUploadTaskInfo(VodQueryUploadTaskInfoRequest $req): VodQueryUploadTaskInfoResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('QueryUploadTaskInfo', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodQueryUploadTaskInfoResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * ApplyUploadInfo.
     *
     * @param $req VodApplyUploadInfoRequest
     * @return VodApplyUploadInfoResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function applyUploadInfo(VodApplyUploadInfoRequest $req): VodApplyUploadInfoResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('ApplyUploadInfo', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodApplyUploadInfoResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * CommitUploadInfo.
     *
     * @param $req VodCommitUploadInfoRequest
     * @return VodCommitUploadInfoResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function commitUploadInfo(VodCommitUploadInfoRequest $req): VodCommitUploadInfoResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('CommitUploadInfo', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodCommitUploadInfoResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * UpdateMediaInfo.
     *
     * @param $req VodUpdateMediaInfoRequest
     * @return VodUpdateMediaInfoResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function updateMediaInfo(VodUpdateMediaInfoRequest $req): VodUpdateMediaInfoResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('UpdateMediaInfo', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodUpdateMediaInfoResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * UpdateMediaPublishStatus.
     *
     * @param $req VodUpdateMediaPublishStatusRequest
     * @return VodUpdateMediaPublishStatusResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function updateMediaPublishStatus(VodUpdateMediaPublishStatusRequest $req): VodUpdateMediaPublishStatusResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('UpdateMediaPublishStatus', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodUpdateMediaPublishStatusResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetMediaInfos.
     *
     * @param $req VodGetMediaInfosRequest
     * @return VodGetMediaInfosResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getMediaInfos(VodGetMediaInfosRequest $req): VodGetMediaInfosResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetMediaInfos', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetMediaInfosResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetRecommendedPoster.
     *
     * @param $req VodGetRecommendedPosterRequest
     * @return VodGetRecommendedPosterResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getRecommendedPoster(VodGetRecommendedPosterRequest $req): VodGetRecommendedPosterResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetRecommendedPoster', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetRecommendedPosterResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * DeleteMedia.
     *
     * @param $req VodDeleteMediaRequest
     * @return VodDeleteMediaResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function deleteMedia(VodDeleteMediaRequest $req): VodDeleteMediaResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('DeleteMedia', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodDeleteMediaResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * DeleteTranscodes.
     *
     * @param $req VodDeleteTranscodesRequest
     * @return VodDeleteTranscodesResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function deleteTranscodes(VodDeleteTranscodesRequest $req): VodDeleteTranscodesResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('DeleteTranscodes', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodDeleteTranscodesResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetMediaList.
     *
     * @param $req VodGetMediaListRequest
     * @return VodGetMediaListResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getMediaList(VodGetMediaListRequest $req): VodGetMediaListResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetMediaList', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetMediaListResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetSubtitleInfoList.
     *
     * @param $req VodGetSubtitleInfoListRequest
     * @return VodGetSubtitleInfoListResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getSubtitleInfoList(VodGetSubtitleInfoListRequest $req): VodGetSubtitleInfoListResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetSubtitleInfoList', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetSubtitleInfoListResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * UpdateSubtitleStatus.
     *
     * @param $req VodUpdateSubtitleStatusRequest
     * @return VodUpdateSubtitleStatusResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function updateSubtitleStatus(VodUpdateSubtitleStatusRequest $req): VodUpdateSubtitleStatusResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('UpdateSubtitleStatus', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodUpdateSubtitleStatusResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * UpdateSubtitleInfo.
     *
     * @param $req VodUpdateSubtitleInfoRequest
     * @return VodUpdateSubtitleInfoResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function updateSubtitleInfo(VodUpdateSubtitleInfoRequest $req): VodUpdateSubtitleInfoResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('UpdateSubtitleInfo', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodUpdateSubtitleInfoResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetAuditFramesForAudit.
     *
     * @param $req VodGetAuditFramesForAuditRequest
     * @return VodGetAuditFramesForAuditResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getAuditFramesForAudit(VodGetAuditFramesForAuditRequest $req): VodGetAuditFramesForAuditResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetAuditFramesForAudit', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetAuditFramesForAuditResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetMLFramesForAudit.
     *
     * @param $req VodGetMLFramesForAuditRequest
     * @return VodGetMLFramesForAuditResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getMLFramesForAudit(VodGetMLFramesForAuditRequest $req): VodGetMLFramesForAuditResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetMLFramesForAudit', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetMLFramesForAuditResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetBetterFramesForAudit.
     *
     * @param $req VodGetBetterFramesForAuditRequest
     * @return VodGetBetterFramesForAuditResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getBetterFramesForAudit(VodGetBetterFramesForAuditRequest $req): VodGetBetterFramesForAuditResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetBetterFramesForAudit', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetBetterFramesForAuditResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetAudioInfoForAudit.
     *
     * @param $req VodGetAudioInfoForAuditRequest
     * @return VodGetAudioInfoForAuditResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getAudioInfoForAudit(VodGetAudioInfoForAuditRequest $req): VodGetAudioInfoForAuditResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetAudioInfoForAudit', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetAudioInfoForAuditResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetAutomaticSpeechRecognitionForAudit.
     *
     * @param $req VodGetAutomaticSpeechRecognitionForAuditRequest
     * @return VodGetAutomaticSpeechRecognitionForAuditResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getAutomaticSpeechRecognitionForAudit(VodGetAutomaticSpeechRecognitionForAuditRequest $req): VodGetAutomaticSpeechRecognitionForAuditResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetAutomaticSpeechRecognitionForAudit', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetAutomaticSpeechRecognitionForAuditResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetAudioEventDetectionForAudit.
     *
     * @param $req VodGetAudioEventDetectionForAuditRequest
     * @return VodGetAudioEventDetectionForAuditResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getAudioEventDetectionForAudit(VodGetAudioEventDetectionForAuditRequest $req): VodGetAudioEventDetectionForAuditResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetAudioEventDetectionForAudit', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetAudioEventDetectionForAuditResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * CreateVideoClassification.
     *
     * @param $req VodCreateVideoClassificationRequest
     * @return VodCreateVideoClassificationResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function createVideoClassification(VodCreateVideoClassificationRequest $req): VodCreateVideoClassificationResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('CreateVideoClassification', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodCreateVideoClassificationResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * UpdateVideoClassification.
     *
     * @param $req VodUpdateVideoClassificationRequest
     * @return VodUpdateVideoClassificationResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function updateVideoClassification(VodUpdateVideoClassificationRequest $req): VodUpdateVideoClassificationResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('UpdateVideoClassification', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodUpdateVideoClassificationResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * DeleteVideoClassification.
     *
     * @param $req VodDeleteVideoClassificationRequest
     * @return VodDeleteVideoClassificationResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function deleteVideoClassification(VodDeleteVideoClassificationRequest $req): VodDeleteVideoClassificationResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('DeleteVideoClassification', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodDeleteVideoClassificationResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * ListVideoClassifications.
     *
     * @param $req VodListVideoClassificationsRequest
     * @return VodListVideoClassificationsResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function listVideoClassifications(VodListVideoClassificationsRequest $req): VodListVideoClassificationsResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('ListVideoClassifications', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodListVideoClassificationsResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * ListSnapshots.
     *
     * @param $req VodListSnapshotsRequest
     * @return VodListSnapshotsResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function listSnapshots(VodListSnapshotsRequest $req): VodListSnapshotsResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('ListSnapshots', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodListSnapshotsResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * StartWorkflow.
     *
     * @param $req VodStartWorkflowRequest
     * @return VodStartWorkflowResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function startWorkflow(VodStartWorkflowRequest $req): VodStartWorkflowResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('StartWorkflow', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodStartWorkflowResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * RetrieveTranscodeResult.
     *
     * @param $req VodRetrieveTranscodeResultRequest
     * @return VodRetrieveTranscodeResultResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function retrieveTranscodeResult(VodRetrieveTranscodeResultRequest $req): VodRetrieveTranscodeResultResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('RetrieveTranscodeResult', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodRetrieveTranscodeResultResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetWorkflowExecution.
     *
     * @param $req VodGetWorkflowExecutionStatusRequest
     * @return VodGetWorkflowExecutionStatusResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function GetWorkflowExecution(VodGetWorkflowExecutionStatusRequest $req): VodGetWorkflowExecutionStatusResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetWorkflowExecution', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetWorkflowExecutionStatusResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * SubmitDirectEditTaskAsync.
     *
     * @param $req VodSubmitDirectEditTaskAsyncRequest
     * @return VodSubmitDirectEditTaskAsyncResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function submitDirectEditTaskAsync(VodSubmitDirectEditTaskAsyncRequest $req): VodSubmitDirectEditTaskAsyncResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $query["EditParam"] = json_decode($req->getEditParam());
            $response = $this->request('SubmitDirectEditTaskAsync', ['json' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodSubmitDirectEditTaskAsyncResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetDirectEditResult.
     *
     * @param $req VodGetDirectEditResultRequest
     * @return VodGetDirectEditResultResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getDirectEditResult(VodGetDirectEditResultRequest $req): VodGetDirectEditResultResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $query["ReqIds"] = json_decode($query["ReqIds"]);
            $response = $this->request('GetDirectEditResult', ['json' => $query]);
            $json_decode = json_decode($response->getBody());
            $results = null;
            if (!empty($json_decode->Result)) {
                $results = $json_decode->Result;
                foreach ($results as $key => $result) {
                    $result->EditParam = json_encode($result->EditParam);
                }
            }

            $resp = new class($json_decode->ResponseMetadata, $results) {
                public function __construct($ResponseMetadata, $Result)
                {
                    $this->ResponseMetadata = $ResponseMetadata;
                    $this->Result = $Result;
                }

                public $ResponseMetadata = null;
                public $Result = null;

                public function getBody()
                {
                    return json_encode($this);
                }
            };
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetDirectEditResultResponse();
        try {
            $respData = VodUtils::parseResponseData($resp, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetDirectEditProgress.
     *
     * @param $req VodGetDirectEditProgressRequest
     * @return VodGetDirectEditProgressResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getDirectEditProgress(VodGetDirectEditProgressRequest $req): VodGetDirectEditProgressResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetDirectEditProgress', ['query' => $query]);
            $json_decode = json_decode($response->getBody());
            $res = null;
            if (!empty($json_decode->Result)) {
                $res = $json_decode->Result;
            }
            $resp = new class($json_decode->ResponseMetadata, $res) {
                public function __construct($ResponseMetadata, $Result)
                {
                    $this->ResponseMetadata = $ResponseMetadata;
                    $this->Result = new class($Result) {
                        public $Result;

                        public function __construct($Result)
                        {
                            $this->Result = $Result;
                        }
                    };
                }

                public $ResponseMetadata = null;
                public $Result = null;

                public function getBody()
                {
                    return json_encode($this);
                }
            };
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetDirectEditProgressResponse();
        try {
            $respData = VodUtils::parseResponseData($resp, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }


    /**
     * CreateSpace.
     *
     * @param $req VodCreateSpaceRequest
     * @return VodCreateSpaceResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function createSpace(VodCreateSpaceRequest $req): VodCreateSpaceResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('CreateSpace', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodCreateSpaceResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * ListSpace.
     *
     * @param $req VodListSpaceRequest
     * @return VodListSpaceResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function listSpace(VodListSpaceRequest $req): VodListSpaceResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('ListSpace', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodListSpaceResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetSpaceDetail.
     *
     * @param $req VodGetSpaceDetailRequest
     * @return VodGetSpaceDetailResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getSpaceDetail(VodGetSpaceDetailRequest $req): VodGetSpaceDetailResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetSpaceDetail', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetSpaceDetailResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * UpdateSpace.
     *
     * @param $req VodUpdateSpaceRequest
     * @return VodUpdateSpaceResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function updateSpace(VodUpdateSpaceRequest $req): VodUpdateSpaceResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('UpdateSpace', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodUpdateSpaceResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * UpdateSpaceUploadConfig.
     *
     * @param $req VodUpdateSpaceUploadConfigRequest
     * @return VodUpdateSpaceUploadConfigResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function updateSpaceUploadConfig(VodUpdateSpaceUploadConfigRequest $req): VodUpdateSpaceUploadConfigResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('UpdateSpaceUploadConfig', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodUpdateSpaceUploadConfigResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * DescribeVodSpaceStorageData.
     *
     * @param $req VodDescribeVodSpaceStorageDataRequest
     * @return VodDescribeVodSpaceStorageDataResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function describeVodSpaceStorageData(VodDescribeVodSpaceStorageDataRequest $req): VodDescribeVodSpaceStorageDataResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('DescribeVodSpaceStorageData', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodDescribeVodSpaceStorageDataResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * ListDomain.
     *
     * @param $req VodListDomainRequest
     * @return VodListDomainResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function listDomain(VodListDomainRequest $req): VodListDomainResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('ListDomain', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodListDomainResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * CreateCdnRefreshTask.
     *
     * @param $req VodCreateCdnRefreshTaskRequest
     * @return VodCreateCdnRefreshTaskResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function createCdnRefreshTask(VodCreateCdnRefreshTaskRequest $req): VodCreateCdnRefreshTaskResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('CreateCdnRefreshTask', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodCreateCdnRefreshTaskResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * CreateCdnPreloadTask.
     *
     * @param $req VodCreateCdnPreloadTaskRequest
     * @return VodCreateCdnPreloadTaskResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function createCdnPreloadTask(VodCreateCdnPreloadTaskRequest $req): VodCreateCdnPreloadTaskResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('CreateCdnPreloadTask', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodCreateCdnPreloadTaskResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * ListCdnTasks.
     *
     * @param $req VodListCdnTasksRequest
     * @return VodListCdnTasksResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function listCdnTasks(VodListCdnTasksRequest $req): VodListCdnTasksResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('ListCdnTasks', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodListCdnTasksResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * ListCdnAccessLog.
     *
     * @param $req VodListCdnAccessLogRequest
     * @return VodListCdnAccessLogResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function listCdnAccessLog(VodListCdnAccessLogRequest $req): VodListCdnAccessLogResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('ListCdnAccessLog', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodListCdnAccessLogResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * ListCdnTopAccessUrl.
     *
     * @param $req VodListCdnTopAccessUrlRequest
     * @return VodListCdnTopAccessUrlResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function listCdnTopAccessUrl(VodListCdnTopAccessUrlRequest $req): VodListCdnTopAccessUrlResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('ListCdnTopAccessUrl', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodListCdnTopAccessUrlResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * DescribeVodDomainBandwidthData.
     *
     * @param $req VodDescribeVodDomainBandwidthDataRequest
     * @return VodDescribeVodDomainBandwidthDataResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function describeVodDomainBandwidthData(VodDescribeVodDomainBandwidthDataRequest $req): VodDescribeVodDomainBandwidthDataResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('DescribeVodDomainBandwidthData', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodDescribeVodDomainBandwidthDataResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * ListCdnUsageData.
     *
     * @param $req VodListCdnUsageDataRequest
     * @return VodCdnStatisticsCommonResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function listCdnUsageData(VodListCdnUsageDataRequest $req): VodCdnStatisticsCommonResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('ListCdnUsageData', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodCdnStatisticsCommonResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * ListCdnStatusData.
     *
     * @param $req VodListCdnStatusDataRequest
     * @return VodCdnStatisticsCommonResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function listCdnStatusData(VodListCdnStatusDataRequest $req): VodCdnStatisticsCommonResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('ListCdnStatusData', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodCdnStatisticsCommonResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * DescribeIpInfo.
     *
     * @param $req VodDescribeIPInfoRequest
     * @return VodDescribeIPInfoResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function describeIpInfo(VodDescribeIPInfoRequest $req): VodDescribeIPInfoResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('DescribeIpInfo', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodDescribeIPInfoResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * DescribeVodDomainTrafficData.
     *
     * @param $req VodDescribeVodDomainTrafficDataRequest
     * @return VodDescribeVodDomainTrafficDataResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function describeVodDomainTrafficData(VodDescribeVodDomainTrafficDataRequest $req): VodDescribeVodDomainTrafficDataResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('DescribeVodDomainTrafficData', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodDescribeVodDomainTrafficDataResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * ListCdnPvData.
     *
     * @param $req VodListCdnPvDataRequest
     * @return VodCdnStatisticsCommonResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function listCdnPvData(VodListCdnPvDataRequest $req): VodCdnStatisticsCommonResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('ListCdnPvData', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodCdnStatisticsCommonResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * AddCallbackSubscription.
     *
     * @param $req VodAddCallbackSubscriptionRequest
     * @return VodAddCallbackSubscriptionResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function addCallbackSubscription(VodAddCallbackSubscriptionRequest $req): VodAddCallbackSubscriptionResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('AddCallbackSubscription', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodAddCallbackSubscriptionResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * SetCallbackEvent.
     *
     * @param $req VodSetCallbackEventRequest
     * @return VodSetCallbackEventResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function setCallbackEvent(VodSetCallbackEventRequest $req): VodSetCallbackEventResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('SetCallbackEvent', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodSetCallbackEventResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetSmartStrategyLitePlayInfo.
     *
     * @param $req VodGetSmartStrategyLitePlayInfoRequest
     * @return VodGetSmartStrategyLitePlayInfoResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getSmartStrategyLitePlayInfo(VodGetSmartStrategyLitePlayInfoRequest $req): VodGetSmartStrategyLitePlayInfoResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetSmartStrategyLitePlayInfo', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetSmartStrategyLitePlayInfoResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

    /**
     * GetAppInfo.
     *
     * @param $req VodGetAppInfoRequest
     * @return VodGetAppInfoResponse
     * @throws Exception the exception
     * @throws Throwable the exception
     */
    public function getAppInfo(VodGetAppInfoRequest $req): VodGetAppInfoResponse
    {
        try {
            $query = VodUtils::formatRequestParam($req);
            $response = $this->request('GetAppInfo', ['query' => $query]);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        if ($response->getStatusCode() != 200) {
            echo $response->getStatusCode(), "\n";
            echo $response->getBody()->getContents(), "\n";
        }
        $respData = new VodGetAppInfoResponse();
        try {
            $respData = VodUtils::parseResponseData($response, $respData);
        } catch (Exception $e) {
            throw $e;
        } catch (Throwable $t) {
            throw $t;
        }
        return $respData;
    }

}  // end of service
