/*

 Copyright (c) 2005-2025, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 https://css4j.github.io/LICENSE.txt

 */

// SPDX-License-Identifier: BSD-3-Clause

package io.sf.carte.doc.style.css;

/**
 * Enumeration of CSS transform functions.
 */
public enum TransformFunctions {

	/**
	 * {@code matrix()} function.
	 */
	MATRIX,

	/**
	 * {@code perspective()} function.
	 */
	PERSPECTIVE,

	/**
	 * {@code translate()} function.
	 */
	TRANSLATE,

	/**
	 * {@code translate3d()} function.
	 */
	TRANSLATE_3D,

	/**
	 * {@code translateX()} function.
	 */
	TRANSLATE_X,

	/**
	 * {@code translateY()} function.
	 */
	TRANSLATE_Y,

	/**
	 * {@code translateZ()} function.
	 */
	TRANSLATE_Z,

	/**
	 * {@code scale()} function.
	 */
	SCALE,

	/**
	 * {@code scale3d()} function.
	 */
	SCALE_3D,

	/**
	 * {@code scaleX()} function.
	 */
	SCALE_X,

	/**
	 * {@code scaleY()} function.
	 */
	SCALE_Y,

	/**
	 * {@code scaleZ()} function.
	 */
	SCALE_Z,

	/**
	 * {@code rotate()} function.
	 */
	ROTATE,

	/**
	 * {@code rotate3d()} function.
	 */
	ROTATE_3D,

	/**
	 * {@code rotateX()} function.
	 */
	ROTATE_X,

	/**
	 * {@code rotateY()} function.
	 */
	ROTATE_Y,

	/**
	 * {@code rotateZ()} function.
	 */
	ROTATE_Z,

	/**
	 * {@code skew()} function.
	 */
	SKEW,

	/**
	 * {@code skewX()} function.
	 */
	SKEW_X,

	/**
	 * {@code skewY()} function.
	 */
	SKEW_Y,

	/**
	 * Other transform functions.
	 */
	OTHER,

}
