/*

 Copyright (c) 2005-2025, Carlos Amengual.

 SPDX-License-Identifier: BSD-3-Clause

 Licensed under a BSD-style License. You can find the license here:
 https://css4j.github.io/LICENSE.txt

 */

package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.Selector;

abstract class AbstractSelector implements Selector, java.io.Serializable {

	private static final long serialVersionUID = 1L;

	@Override
	public int hashCode() {
		return getSelectorType().hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Selector))
			return false;
		Selector other = (Selector) obj;
		return getSelectorType() == other.getSelectorType();
	}
}
