This is only the tail - the most recent changes are at the tail of [README.md](README.md#changelog).


- 1.1.817
    - Aliased `Sqlite` to `ODBC` and `DB` also; since it is not specifically Sqlite.
    - Added `run()` function in SQL module; this returns a promise and runs the query in a background thread.
    - Added support for windows to set window and class styles; manually control borders of other windows for example.
    - Added support to stop/kill processes by process ID on windows (instead of just launched tasks).
    - Added windows Process List (sack.Task.getProcessList) support.
    - Added linux process list (sack.Task.getProcessList) support.
    - Updated Libressl to 3.2.3.
    - Fixed default stdio handle inheritance.
    - Improved stdio inheritance disabling when launching tasks (prevent holding stdout/stderr redirected logging locks for example).
    - (windows) Added set and get window position to set where a position is; both for launched tasks, and by task ID.
    - Added better mouse support on windows to set/get mouse position. Can also generate arbitrary mouse clicks.
    - Added http:// support in import.mjs node loader module.
    - Improved user-agent support for HTTP requests; added `agent` option, but also pay attention to 'user-agent' if specified as an option in `headers` in request options.
    - Added a callback when a SQL connection is opened (or re-opened after a failure) to be able to condition the connection.
    - added content-type handling for `.webm` and `.mp4` in default websocket/HTTP(S) modules ("sack.vfs/http-ws" or "sack.vfs/apps/http-ws").
- 1.1.816
    - (Windows)Add method to get task window title.
    - Sqlite method added - `provider` - returns what the target database is from ODBC information.
    - (Windows)Add mouse hook ability to get where the mouse is.  Improved Keyboard interface.
    - Added `noKill` option to tasks - doesn't kill task on exit.
    - Added `noWait` option to tasks - doesn't wait for task end (Default: true).
    - (Windows)Added primary and current indicators to monitor/device information.
    - (Windows)Added hide cursor method; failes to restore animated cursors.
    - Some fixes for GUI build and latest node (Array buffer backing store).
    - (Windows) Fixed some constant flags used with ShellExecute().
    - Added ability to consume keyboard events.  (so they don't get sent to other things)
    - improve exit handling in linux.
    - add SQL provider identifier for mariadb odbc driver.
    - Add static methods for events that allow class-based events.
    - Added scripts to make typescript types definitions (unvetted, but mostly work)
    - Improved GUI Event loop registration to only register 1 uv_loop.
    - Improved install path handling/features.
    - Improved path expansion/substitution.
    - Wide character system interface improved on windows. 
- 1.1.815
    - process fixes; add ability to register an event to terminate a process, and hook into it.
    - Fix standard IO handles to be inheritable.
    - Add options to terminate tasks (useBreak, useSignal).
    - Made terminte task only terminate, not attempt stop.
    - (Windows)Add method to move task window; Add option to task to move window.
- 1.1.814
    - Apply volatile to fields of CriticalSection so code isn't badly optimized.
    - Add internal test for critical sections.
- 1.1.813
    - implement `useBreak` option to control how tasks are ended.
    - fixed sack core handling of task termination.
- 1.1.812
    - fix missing `exitCode` accessor for tasks.  Fixed file scan directory check.
- 1.1.811
    - Add `dumpMemory` to system interface.
    - Fixed some leaked memory.
- 1.1.810
    - Fix some network issues.
    - Add module isTopLevel utility.
- 1.1.809
    - fix struct name overlap that causes a error in C++ compilation.
    - minor fixes to apps
- 1.1.808
    - Fixed accept event premature deallocation.
    - fixed parsing CGI options on requests. (didn't consume enough tokens).
    - add reboot() command for windows under system.
    - Improve uexpress/http server interface.
- 1.1.807
    - Convert SQL int to full size of target. (handle -1 int)
    - Update to build with node 19+ and stdc++17 option.
    - Fix race condition in deallocation in accept event.
    - Handle wide long varchar SQL type.
    - Fix pretty print for JSOX stringify.
    - Fix parsing negative ISO-8601 Dates.
    - generate specific timestamp for `new Date( "0000-01-01T00:00:00.000Z" ).getTime()` to return that string anyway.
- 1.1.806
   - fix wide character directory creation on windows.
- 1.1.805
   - fixed linux network stall.
   - improved SQL interface.
   - TLS Certificate generation update/fix; true is 0xFF not `not 0`.
   - fixed double Release() in error socket path.
   - Improve Electron compatibility; electrons package system is still deficient to be useful thuogh.
- 1.1.804
   - missing source in pack.
- 1.1.803  
   - include LibreSSL 3.5.3 to avoid conflicts/incompatibilities with Node's included OpenSSL versions.
   - change npm install to use cmake-js to be able to use included LibreSSL
   - handle SQL DATE type as a time(TIMESTAMP).
   - fix for collecting trailing HTML reply without a length.
   - fix linux lost close event; socket closed, without a next buffer, failed to read the close 0.
   - handle stdout/stderr split logging better.
   - report websocket send parameter failures better.
   - include application support `app/http-ws` simple module that can be included; see documentation in directory.
   - include CGI parameters in WS server instance object.
   - Fix crash when a launched windows task fails.
   - Fix parsing state error for `Volume().readJSOX()`.
   - Fixed parsing state after a failure in object storage; reset parsing state after error.
   - Fixed a double free on binary websocket buffers.
   - Added apps
     - http-ws : A generic HTTP server with primary WS provision; used as a module for other apps.
     - uExpress : A minimal Express() emulator that hooks to http-ws.
     - task-manager : A multi-service launcher
     - prng : Add some tiny seedable PRNGs.
     - events : Utility class to provide `.on()`, `.off()`.
     - dbUtil : Utilities for database schema update and reading.
   - Fix writing binary buffer that's a Uint8Array.
   - Reset environment variables after launching tasks.
- 1.1.802
   - task input handling failure on windows; if only one callback was issued.
- 1.1.801
   - expose network option TCP_NODELAY to connected server instances, and client websockets.
- 1.1.8
   - Fix dependancy references in published version.
- 1.1.7
   - (TODO) Improve documentation/tutorials somewhere.
   - Add check for \ufeff as a whitespace character; legacy BOM usage requires treating this as a significant whitespace literal.
   - Add JSOX.DateNS class that extends date to keep extended information that might have been encoded in a time value.
   - Fix closing stderr/stdout when changing syslog file output. (CRITICAL!)
   - Fix some compatibility with early 12 versions.  LTS Should only include the last 12 not any 12.
   - Fixed issue with journal on initialized object storage; also failed to commit file changes to BAT blocks involved with the journal.
   - Improve/extend API around stored objects to get timestamp information.
   - Added DateNS() extension of date class which keeps sub-millisecond time values.
   - 
- 1.1.6
   - fix calling json, json6 `.write()` methods to use empty parameters as stream push.
   - improve http regression fix.
   - fix build with node 17's OpenSSL 3 (which is and isn't available depending on actual target platform).
   - Simplify HTTP server example.
   - updated object file api to be more predicable about open/create states; Create must not exist, and Open Must exist; otherwise resulting promises are rejected.
- 1.1.5
   - fix regression handling http get with content-length.
   - fix loading SSL keys to verify certificates on linux (native OpenSSL config).
   - fixes JSOX object revival with references of field names already revived.
   - cleanup signing and verifying object storage content.
   - fixes partial insenstive compare error in object storage hash lookup.
- 1.1.4
   - fix exporting import.mjs for others to use.
   - Fixed name comparison for object storage.
- 1.1.3
   - Fixed bad name comparison in object storage.
- 1.1.2
   - fix using strlen on potentially NULL value for websocket close reason.
- 1.1.1
   - fixed HTTP request chain handling.
- 1.1.0
   - Split README.md into multiple files, so each section can be expanded.
   - add parse() command to JSOX parser instances.
   - add JSOX automatic encoding for `RegExp` as 'regex'.
   - handle badly formatted JSOX better; partial evaluations left states set that affected future valid expressions.
   - Fix setting 'undefined' results to fields.  (should be ignored)
   - fix onmessage, onopen, onclose, onerror websocket methods to be getter/setters, not function call based. (sorry; nearly warrants 1.1; though, it's also just broken so.).
   - Added some test services for a standlone checkout.
   - fixed keyboard lock shutdown.
   - handle POST HTTP Get requests better.
- 1.0.1012
   - Fix small leak closing com ports.
   - Fix order object fields are revived; assign object after it has been built; use internal context stack for references.
   - Fix failure to send final revive for an object containing an array.
- 1.0.1011
	- Websocket server connection instances didn't complete opening correctly (regression in 1.0.1010). 
- 1.0.1010
   - fix base64 typed array encoding (regression in 1009).
   - forgive double-posting a websocket socket.
   - lock first websocket send until header can be sent.
- 1.0.1009
   - Added node support for `--experimental-loader=node_modules/sack.vfs/import.mjs`.
   - Removed noisy debug(?)
- 1.0.1008
   - Object filesystem reprocessed journal; flush journal root block when cleaned.
   - Handle exceptions thrown by callbacks provided to JSOX parser better.
   - Fix a potential segfault while parsing invalid data.
   - update links to travis-ci.com instead of travis-ci.org.
- 1.0.1007
   - CRITICAL - fix reversion failure in base64 and interpreting JSOX unquoted typed-array values.
   - fix reversion at quote after string before ':' in JSOX.
- 1.0.1006
   - added remove() method for object storage directories.
    - getRemoteFragment() get code fragment for this API to connect a remote.
   - Added idle flush for object storage directory updates.
   - Removed noisy debug logging.
- 1.0.1005
   - fixed several issues reviving custom data types with references and replacement operations.
   - Added newer tests from [JSOX](https://github.com/d3x0r/JSOX).
- 1.0.1004
   - fixed keyboard input; object GC caused fault.
   - fixed JSOX parsing and stringification issues; Emit `string string` not `stringstring` if the tag and string are both unquoted; fix object revival issues.
- 1.0.1001-1.0.1003
   - first 1.0 version.
   - Fixes for JSOX; improved object storage; updated GUI interface code.
- 0.9.161
   - Added thread local storage
   - Added control flag to disallow per-thread spawn permission.
   - Improved object storage system; implemented rollback journal.
   - Shutdown stability issues; new worker-thread support shutdown invokes a library shutdown, and weak references can still fire their callbacks.
   - control-c shutdown is done in an external thread, which inadvertantly self triggers thread reference creation while locking.
   - JSOX object revival improvements in the C library side/C++ object creation side.
- 0.9.160
   - Improve worker_thread support (missed some other static constructors)
   - Added .log() to allow log output outside of any JS.
   - Fix event dispatches to callbacks that create promises that need to resolve.
- 0.9.159
   - Implement websocket thread interface to post accepted sockets to other threads.
- 0.9.158
   - add test for typed array revival; fix typed array revival (JSOX).
- 0.9.157 
   - revert UTC change.
- 0.9.156
   - missed getFullYear->getUTCFullYear update.
- 0.9.155
   - normalize JSOX class defintiion keys for later comparison to objects.
   - removed node 7 travis integration; `#  - "7" (doesn't have Utf8Value with isolate, 12 doesn't have Utf8Value without isolate())`
   - added FileMonitor interface to get event changes when files change on the disk.   
   - fixed some issues with JSOX parsing ( tagged class in tagged class in map )
   - fix time precision in JSOX stringification (add ms), and was encoding Localtime but claiming UTC.
   - fix error in salty random generator partial bit streams.
   - Implement worker_threads support better; remove static global persistent things.
   - Updated parsers so '\xa0' is the same as '\x20'.  Most parsers are for human-readable code; JSOX, TextParse, BurstExx.
- 0.9.154
   - Continued applying deprecation fixes; republished as 154
- 0.9.153
   - Republish 0.9.152 with ignored source
- 0.9.152
   - Update to Node 12 (Requires usage of context, and MaybeLocal types)
   - Fixed id regnerator to match JS version in more cases.
   - Use pthread_mutex for waits.
   - Improve static global usage so no external memory allocation gets used. (/tmp/.shared*)
   - Removed now unused signal handler registrations.
- 0.9.151
   - SKipped due to error in tagging.
- 0.9.150
   - Fix regression handline NUL inline in JSOX parser (re fix partial codepoints received across buffer bounds)
   - Fix releasing the buffer too soon on HTTP fallback from HTTPS.
- 0.9.149
   - Fixed getting events from listening sockets before being fully setup.
- 0.9.148
   - Updated documentation to cover lowerror event and disableSSL.
   - Added ping() method call on sockets accepted by a server and sockets connected to a server.
   - Fixed lost event during SSL handshake.
   - Fixed linux network write lock issue.
   - Fix static initializing SQL.
- 0.9.147 
   - fixed some issues with JSOX.
   - Fixed occasional event loss for SSL connections.
   - Improved ODBC Data marshalling ability.
   - Fix lost task output from task module tasks.
   - Added Text() type.  Which is the internal rich text segment tracking.  (for output to GUI console) 
- 0.9.146
   - SACK Update; add XSWS 
   - Fixed stall issue with http server and lots of requests in series from browser.
   - Fixed http server issue getting data while processing another header.
- 0.9.145 
   - Add 'mv', 'rename' methods to Volume() instance.  
   - Split locks on ssl read/write.  
   - Fix VFS directory truncation issue (early EODMARK injection). 
   - TLS Certificate add Certificate Policy
   - Add JSOX Parser.
   - Add Object Storage Module.
   - Added support for paramter binding in Sqlite.
   - Improve data marshalling for Sqlite to JS and vice versa.
   - Network improvement for send and close edge conditions.
   - Implement parameter binding for sqlite and ODBC (less tested).
   - Fixed spurious HTTP request failures when the connection closed with writes pending.
   - Improves SRG module; allow configuring SRG instance with a specific entropy generator.
   - Fixed task output stall.
- 0.9.144 - Fix websocket receiving packets with multiple frames.
- 0.9.143 - Improve task interface.  Simplify com data buffer; it's now only valid during receive callback. Improve websocket server handling http requests; add a event callback when socket closes, after server HTTP to distinguish between incomplete(TLS error) connections. Sync SACK updates: improve SQL parsing/table-index generation, library load path for current and name as passed, event for http close, some protection against dereferencing null parameters.
- 0.9.142 - Fix node-gyp for windows build.
- 0.9.141 - Add callback event to trigger background thread preload memory mapped files.
- 0.9.140 - Fix bad test on opening file in VFS.
- 0.9.139 - Added onerror callback for websocket server connections.  Add low level windows keyboard interface module.  Added memory mapped file to arraybuffer.  Fix https init failure with certain combinations of options.
- 0.9.138 - Add alpha methods for generating signing identifiers.  Fixes some lost network close notivications.
- 0.9.137 - fix pathchr insensitive path comparison; update tls interface for newer openssl; allow opening volumes by mount name only.
- 0.9.136 - added log option to sql connections.
- 0.9.135 - Fix unmounted volumes to instead mount hidden.
- 0.9.134 - disable delay-load build option for node-gyp build.
- 0.9.133 - Isolate in Utf8Value is actually a very new thing.
- 0,9.132 - Make a pass to cleanup deprecated Utf8Value() usage.
- 0.9.131 - Fixes for Node 10 (missing export TLS_1_2...; backfix for < 10)
- 0.9.130 - Fixes for Node 10.
- 0.9.129 - (cont) merge linux changes.
- 0.9.128 - (cont) lost some changes; reapply on windows.
- 0.9.127 - (cont) Also implement respecting keep-alive on connection.
- 0.9.126 - (cont)
- 0.9.125 - Updated VESL Parsing(WIP); Fixed latency on windows server socket close.
- 0.9.124 - Fix segfault in latest node; resolve ToInteger deprication warnings.  
- 0.9.123 - Fix missing sources in binding.gyp build rules.
- 0.9.122(unpublished) - Add VESL parsing(in progress). Add Task interface.  Fix create table emitter.
- 0.9.121 - Fix missing close after all data queued to be sent was sent.
- 0.9.120 - Fix crash caused by closing socket during http request dispatch.
- 0.9.119 - Network Scheduling error on windows.
- 0.9.118 - Fix lock issue with SSL read/write.  Fix windows wait on short event count.  Fix VES unlink so files disappear even though still open.
- 0.9.117 - lock on wrong side. 
- 0.9.116 - Fix a windows network lock issue. Handle ArrayBuffer output for http response.
- 0.9.115 - Fix stray unlock.
- 0.9.114 - Fix leave critical section in release mode.
- 0.9.113 - Added optional version parameter for VFS. Sync sack sources... A lot of reformats; updates for split network lock.  Added Sqlite.procedure to define deterministic function.
- 0.9.112 - decode of unicode character escape had bad calculation.
- 0.9.111 - promote to more appropriate version.  If anyone else joins; this should go to 1.0.  Improve TLS error reporting and SQL result set ability.  Improve table parsing.
- 0.1.99324 Test and Update sqlite user defined functions (function/aggregate); improved data type retention.
- 0.1.99323 Fix mac ( got travis integration working for mac).
- 0.1.99322 Some fixes building on mac.  Added error accessor to sqlite object.  Added user functions and aggregates to sqlite interface.
Fixed windows registr access. Added interface to configscript parser.  Added analog interface for clock object (GUI build).  Lots of changes 
SACK core code for user functions, json parse fixes, DeleteFromSet parameters, optimize poplink, added nolock dequelink, added callback for websocket
data receive completion, 
- 0.1.99321 Fix some edge json parsing cases.  Fixed some network issues.  Allow NUL characters in json parsing.
- 0.1.99320 Fix json escape of strings containing NUL characters.  Add HTTP(s) request methods.
Improve/modify PSI control registration/creation a little.  Expose font select dialog, color picker dialog, 
Fix property accessors in websocket module.
- 0.1.99319 Fix older gcc crash from bad optimization.
- 0.1.99318 Fix udp readStrings option.
- 0.1.99317 Added optional GUI interfaces. (build with `npm run build-gui` or `npm run build-gui-debug`)
- 0.1.99316 Fix rekey.
- 0.1.99315 Add rekey method to volumes.
- 0.1.99314 Fixed duplicating address sent with UDP messages.  
Fix reading files from /sys/class/*.  Fix reading directory.  
Fix websocket protocol option before options object.  
Fix websocket connection sequence.  
Allocate new connection object during accept so protocol lookup can attach data to that object. 
Fix handling SSL certificates on websocket connections.  
Simplify sending/receiving UDP subnet broadcasts by simply enabling broadcast. Other small fixes.
- 0.1.99313 remove some debug logging.
- 0.1.99312 fixes building on mac a little.
- 0.1.99311 Fixes building on msvs (exception flag)
- 0.1.99310 Fix rebinding on linux to subnet broadcast address.
- 0.1.99309 Fix clearing some persistant handles so objects can be garbage collected. 
Fix SSL server issues.  Implement onrequest handling for websocket connections.  Improve websocket close reason handling.
Fix TLS certification validation.  Fix passing additional root certificate for validation.
- 0.1.99308 Improve network event handling; Allow more connections dynamically; fix some locking issues with critical sections.
- 0.1.99307 Implement interface to websocket library. Implement interface to UDP sockets.
- 0.1.99306 Move json reviver parameter handling internal.  Implement volume JSON stream reader interface.  Fix options to create/reopen an existing file.
- 0.1.99305 Fix handling exceptions triggered from callbacks. Fix missing truncate in more instances;  Sync sack filesystem updates; fix unlink return value; add pos() method to File.
- 0.1.99304 fix truncate on simple writes into a volume.
- 0.1.99302, 0.1.99303 improvements for sqlite interface.
- 0.1.99301 add SaltyRandomGenerator interface.
- 0.1.99300 fix random generator overflows.
- 0.1.99299 set default sql auto checkpoint to off.
- 0.1.99298 add preferGlobal to package.json.
- 0.1.99297 replace Persistent strings with Eternal, which work on nodev4.
- 0.1.99296 fix deprecated v8::Delete method to use Maybe version.
- 0.1.99295 fix build error on older versions of node.
- 0.1.99294 fix stream paring empty array elements; and a error stream parsing a break between a field label just at the colon.
