/*CMake Option defined*/
// clang-format off
#define NO_AUTO_VECTLIB_NAMES
#define NODE_ADDON_BUILD
/*
 BLOCKINDEX BAT[BLOCKS_PER_BAT] // link of next blocks; 0 if free, FFFFFFFF if end of file block
 uint8_t  block_data[BLOCKS_PER_BAT][BLOCK_SIZE];
 // (1+BLOCKS_PER_BAT) * BLOCK_SIZE total...
 BAT[0] = first directory cluster; array of struct directory_entry
 BAT[1] = name space; directory offsets land in a block referenced by this chain
 */
#define SACK_VFS_SOURCE
#if 1
/* Includes the system platform as required or appropriate. If
   under a linux system, include appropriate basic linux type
   headers, if under windows pull "windows.h".
   Includes the MOST stuff here ( a full windows.h parse is many
   many lines of code.)                                          */
/* A macro to build a wide character string of __FILE__ */
#define _WIDE__FILE__(n) n
#define WIDE__FILE__ _WIDE__FILE__(__FILE__)
#if _XOPEN_SOURCE < 500
#  undef _XOPEN_SOURCE
#  define _XOPEN_SOURCE 500
#endif
#  ifndef _GNU_SOURCE
#    define _GNU_SOURCE
#  endif
#ifndef STANDARD_HEADERS_INCLUDED
/* multiple inclusion protection symbol */
#define STANDARD_HEADERS_INCLUDED
#if _POSIX_C_SOURCE < 200112L
#  ifdef _POSIX_C_SOURCE
#    undef _POSIX_C_SOURCE
#  endif
#  define _POSIX_C_SOURCE 200112L
#endif
#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>
#include <stdint.h>
#if _MSC_VER
#  ifdef EXCLUDE_SAFEINT_H
#    define _INTSAFE_H_INCLUDED_
#  endif
 //_MSC_VER
#endif
#ifndef WINVER
#  define WINVER 0x0601
#endif
#ifndef _WIN32
#  ifndef __LINUX__
#    define __LINUX__
#  endif
#endif
#if !defined(__LINUX__)
#  ifndef STRICT
#    define STRICT
#  endif
#  define WIN32_LEAN_AND_MEAN
// #define NOGDICAPMASKS             // CC_*, LC_*, PC_*, CP_*, TC_*, RC_
// #define NOVIRTUALKEYCODES         // VK_*
// #define NOWINMESSAGES             // WM_*, EM_*, LB_*, CB_*
// #define NOWINSTYLES               // WS_*, CS_*, ES_*, LBS_*, SBS_*, CBS_*
// #define NOSYSMETRICS              // SM_*
// #define NOMENUS                   // MF_*
// #define NOICONS                   // IDI_*
// #define NOKEYSTATES               // MK_*
// #define NOSYSCOMMANDS             // SC_*
// #define NORASTEROPS               // Binary and Tertiary raster ops
// #define NOSHOWWINDOW              // SW_*
               // OEM Resource values
#  define OEMRESOURCE
// #define NOATOM                    // Atom Manager routines
#  ifndef _INCLUDE_CLIPBOARD
               // Clipboard routines
#    define NOCLIPBOARD
#  endif
// #define NOCOLOR                   // Screen colors
// #define NOCTLMGR                  // Control and Dialog routines
//(spv) #define NODRAWTEXT                // DrawText() and DT_*
// #define NOGDI                     // All GDI defines and routines
// #define NOKERNEL                  // All KERNEL defines and routines
// #define NOUSER                    // All USER defines and routines
#  ifndef _ARM_
#    ifndef _INCLUDE_NLS
                     // All NLS defines and routines
#      define NONLS
#    endif
#  endif
// #define NOMB                      // MB_* and MessageBox()
                  // GMEM_*, LMEM_*, GHND, LHND, associated routines
#  define NOMEMMGR
                // typedef METAFILEPICT
#  define NOMETAFILE
#  ifndef NOMINMAX
                  // Macros min(a,b) and max(a,b)
#    define NOMINMAX
#  endif
// #define NOMSG                     // typedef MSG and associated routines
// #define NOOPENFILE                // OpenFile(), OemToAnsi, AnsiToOem, and OF_*
// #define NOSCROLL                  // SB_* and scrolling routines
                 // All Service Controller routines, SERVICE_ equates, etc.
#  define NOSERVICE
//#define NOSOUND                   // Sound driver routines
#  ifndef _INCLUDE_TEXTMETRIC
              // typedef TEXTMETRIC and associated routines
#    define NOTEXTMETRIC
#  endif
// #define NOWH                      // SetWindowsHook and WH_*
// #define NOWINOFFSETS              // GWL_*, GCL_*, associated routines
// #define NOCOMM                    // COMM driver routines
                   // Kanji support stuff.
#  define NOKANJI
                    // Help engine interface.
#  define NOHELP
                // Profiler interface.
#  define NOPROFILER
//#define NODEFERWINDOWPOS          // DeferWindowPos routines
                     // Modem Configuration Extensions
#  define NOMCX
   // no StrCat StrCmp StrCpy etc functions.  (used internally)
#  define NO_SHLWAPI_STRFCNS
  // This also has defines that override StrCmp StrCpy etc... but no override
#  define STRSAFE_NO_DEPRECATE
#  ifdef _MSC_VER
#    ifndef _WIN32_WINDOWS
// needed at least this for what - updatelayeredwindow?
#      define _WIN32_WINDOWS 0x0601
#    endif
#  endif
// INCLUDE WINDOWS.H
#  ifdef __WATCOMC__
#    undef _WINDOWS_
#  endif
#  ifdef UNDER_CE
// just in case windows.h also fails after undef WIN32
// these will be the correct order for primitives we require.
#    include <excpt.h>
#    include <windef.h>
#    include <winnt.h>
#    include <winbase.h>
#    include <wingdi.h>
#    include <wtypes.h>
#    include <winuser.h>
#    undef WIN32
#  endif
#  define _WINSOCKAPI_
#  include <windows.h>
#  undef _WINSOCKAPI_
#  if defined( WIN32 ) && defined( NEED_SHLOBJ )
#    include <shlobj.h>
#  endif
#  if _MSC_VER > 1500
#    define fileno _fileno
#    define stricmp _stricmp
#    define strdup _strdup
#  endif
#  ifdef WANT_MMSYSTEM
#    include <mmsystem.h>
#  endif
#  if USE_NATIVE_TIME_GET_TIME
//#  include <windowsx.h>
// we like timeGetTime() instead of GetTickCount()
//#  include <mmsystem.h>
#    ifdef __cplusplus
extern "C"
#    endif
__declspec(dllimport) DWORD WINAPI timeGetTime(void);
#  endif
#  ifdef WIN32
#    if defined( NEED_SHLAPI )
#      include <shlwapi.h>
#      include <shellapi.h>
#    endif
#    ifdef NEED_V4W
#      include <vfw.h>
#    endif
#  endif
#  if defined( HAVE_ENVIRONMENT )
#    define getenv(name)       OSALOT_GetEnvironmentVariable(name)
#    define setenv(name,val)   SetEnvironmentVariable(name,val)
#  endif
#  define Relinquish()       Sleep(0)
//#pragma pragnoteonly("GetFunctionAddress is lazy and has no library cleanup - needs to be a lib func")
//#define GetFunctionAddress( lib, proc ) GetProcAddress( LoadLibrary( lib ), (proc) )
#  ifdef __cplusplus_cli
#    include <vcclr.h>
 /*lprintf( */
#    define DebugBreak() System::Console::WriteLine(gcnew System::String( WIDE__FILE__ "(" STRSYM(__LINE__) ") Would DebugBreak here..." ) );
//typedef unsigned int HANDLE;
//typedef unsigned int HMODULE;
//typedef unsigned int HWND;
//typedef unsigned int HRC;
//typedef unsigned int HMENU;
//typedef unsigned int HICON;
//typedef unsigned int HINSTANCE;
#  endif
 // ifdef unix/linux
#else
#  include <pthread.h>
#  include <sched.h>
#  include <unistd.h>
#  include <sys/time.h>
#  if defined( __ARM__ )
#    define DebugBreak()
#  else
/* A symbol used to cause a debugger to break at a certain
   point. Sometimes dynamicly loaded plugins can be hard to set
   the breakpoint in the debugger, so it becomes easier to
   recompile with a breakpoint in the right place.
   Example
   <code lang="c++">
   DebugBreak();
	</code>                                                      */
#    ifdef __ANDROID__
#      define DebugBreak()
#    else
#      if defined( __EMSCRIPTEN__ ) || defined( __ARM__ )
#        define DebugBreak()
#      else
#        define DebugBreak()  __asm__("int $3\n" )
#      endif
#    endif
#  endif
#  ifdef __ANDROID_OLD_PLATFORM_SUPPORT__
extern __sighandler_t bsd_signal(int, __sighandler_t);
#  endif
// moved into timers - please linnk vs timers to get Sleep...
//#define Sleep(n) (usleep((n)*1000))
#  define Relinquish() sched_yield()
#  define GetLastError() (int32_t)errno
/* return with a THREAD_ID that is a unique, universally
   identifier for the thread for inter process communication. */
#  define GetCurrentProcessId() ((uint32_t)getpid())
#  define GetCurrentThreadId() ((uint32_t)getpid())
  // end if( !__LINUX__ )
#endif
#include <errno.h>
#ifndef NEED_MIN_MAX
#  ifndef NO_MIN_MAX_MACROS
#    define NO_MIN_MAX_MACROS
#  endif
#endif
#ifndef NO_MIN_MAX_MACROS
#  ifdef __cplusplus
#    ifdef __GNUC__
#      ifndef min
#        define min(a,b) ((a)<(b))?(a):(b)
#      endif
#    endif
#  endif
/* Define a min(a,b) macro when the compiler lacks it. */
#  ifndef min
#    define min(a,b) (((a)<(b))?(a):(b))
#  endif
/* Why not add the max macro, also? */
#  ifndef max
#    define max(a,b) (((a)>(b))?(a):(b))
#  endif
#endif
/* Define most of the sack core types on which everything else is
   based. Also defines some of the primitive container
   structures. We also handle a lot of platform/compiler
   abstraction here.
   A reFactoring for stdint.h and uint32_t etc would be USEFUL!
   where types don't exist, define them as apprpritate types instead.
But WHO doesn't have stdint?  BTW is sizeof( size_t ) == sizeof( void* )
   This is automatically included with stdhdrs.h; however, when
   including sack_types.h, the minimal headers are pulled. */
#ifndef SACK_PRIMITIVE_TYPES_INCLUDED
#define SACK_PRIMITIVE_TYPES_INCLUDED
#define HAS_STDINT
//#define USE_SACK_CUSTOM_MEMORY_ALLOCATION
	// this has to be a compile option (option from cmake)
   // enables debug dump mem...
#ifdef USE_SACK_CUSTOM_MEMORY_ALLOCATION
#  define USE_CUSTOM_ALLOCER 1
#else
#  define USE_CUSTOM_ALLOCER 0
#endif
#ifndef __64__
#  if defined( _WIN64 ) || defined( ENVIRONMENT64 ) || defined( __x86_64__ ) || defined( __ia64 ) || defined( __ppc64__ ) || defined( __LP64__ )
#    define __64__ 1
#  endif
#endif
#ifdef _MSC_VER
#  ifndef _WIN32_WINNT
#    define _WIN32_WINNT 0x501
#  endif
#  ifndef WIN32
#    ifdef _WIN32
#      define WIN32 _WIN32
#    endif
#  endif
// force windows on __MSVC
#  ifndef WIN32
#    define WIN32
#  endif
#endif
#if !defined( __NO_THREAD_LOCAL__ ) && ( defined( _MSC_VER ) || defined( __WATCOMC__ ) )
#  define HAS_TLS 1
#  ifdef __cplusplus
#    define DeclareThreadLocal static thread_local
#    define DeclareThreadVar  thread_local
#  else
#    define DeclareThreadLocal static __declspec(thread)
#    define DeclareThreadVar __declspec(thread)
#  endif
#elif !defined( __NO_THREAD_LOCAL__ ) && ( defined( __GNUC__ ) || defined( __MAC__ ) )
#    define HAS_TLS 1
#    ifdef __cplusplus
#      define DeclareThreadLocal static thread_local
#      define DeclareThreadVar thread_local
#    else
#    define DeclareThreadLocal static __thread
#    define DeclareThreadVar __thread
#  endif
#else
// if no HAS_TLS
#  define DeclareThreadLocal static
#  define DeclareThreadVar
#endif
#ifdef __cplusplus_cli
// these things define a type called 'Byte'
	// which causes confusion... so don't include vcclr for those guys.
#  ifdef SACK_BAG_EXPORTS
// maybe only do this while building sack_bag project itself...
#    if !defined( ZCONF_H )        && !defined( __FT2_BUILD_GENERIC_H__ )        && !defined( ZUTIL_H )        && !defined( SQLITE_PRIVATE )        && !defined( NETSERVICE_SOURCE )        && !defined( LIBRARY_DEF )
//using namespace System;
#    endif
#  endif
#endif
// Defined for building visual studio monolithic build.  These symbols are not relavent with cmakelists.
#ifdef SACK_BAG_EXPORTS
#  define SACK_BAG_CORE_EXPORTS
// exports don't really matter with CLI compilation.
#  ifndef BAG
//#ifndef TARGETNAME
//#  define TARGETNAME "sack_bag.dll"  //$(TargetFileName)
//#endif
#    define MD5_SOURCE
#    define SHA2_SOURCE
#    define USE_SACK_FILE_IO
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define MEM_LIBRARY_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define SYSLOG_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define _TYPELIBRARY_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define HTTP_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define TIMER_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define IDLE_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define CLIENTMSG_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define FRACTION_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define NETWORK_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define CONFIGURATION_LIBRARY_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define FILESYSTEM_LIBRARY_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define SYSTEM_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define FILEMONITOR_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define VECTOR_LIBRARY_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define SHA1_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define CONSTRUCT_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define PROCREG_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define SQLPROXY_LIBRARY_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#      define TYPELIB_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#      define JSON_EMITTER_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
	individual library module once upon a time.           */
#      define JSOX_PARSER_SOURCE
#      define HTML5_WEBSOCKET_SOURCE
#      define SACK_WEBSOCKET_CLIENT_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define SERVICE_SOURCE
#    ifndef __NO_SQL__
#      ifndef __NO_OPTIONS__
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.    and not NO_SQL and not NO_OPTIONS   */
#        define SQLGETOPTION_SOURCE
#      endif
#    endif
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define PSI_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define MNG_BUILD_DLL
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define BAGIMAGE_EXPORTS
/* Defined when SACK_BAG_EXPORTS is defined. This was an
 individual library module once upon a time.           */
#    ifndef IMAGE_LIBRARY_SOURCE
#      define IMAGE_LIBRARY_SOURCE
#    endif
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define SYSTRAY_LIBRARAY
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define SOURCE_PSI2
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
#    define VIDEO_LIBRARY_SOURCE
/* Defined when SACK_BAG_EXPORTS is defined. This was an
   individual library module once upon a time.           */
	/* define RENDER SOURCE when building monolithic. */
#    ifndef RENDER_LIBRARY_SOURCE
#      define RENDER_LIBRARY_SOURCE
#    endif
// define a type that is a public name struct type...
// good thing that typedef and struct were split
// during the process of port to /clr option.
//#define PUBLIC_TYPE public
#  else
//#define PUBLIC_TYPE
#    ifdef __cplusplus_CLR
//using namespace System;
#    endif
#  endif
#endif
 // wchar for X_16 definition
#include <wchar.h>
#include <sys/types.h>
#include <sys/stat.h>
#if !defined( _WIN32 ) && !defined( __MAC__ )
#  include <sys/syscall.h>
#elif defined( __MAC__ )
#endif
#ifndef MY_TYPES_INCLUDED
#  define MY_TYPES_INCLUDED
// include this before anything else
// thereby allowing us to redefine exit()
 // CHAR_BIT
#  include <limits.h>
 // typelib requires this
#  include <stdarg.h>
#  ifdef _MSC_VER
#    ifndef UNDER_CE
 // memlib requires this, and it MUST be included befoer string.h if it is used.
#      include <intrin.h>
#    endif
#  endif
 // typelib requires this
#  include <string.h>
#  if !defined( WIN32 ) && !defined( _WIN32 ) && !defined( _PNACL )
#    include <dlfcn.h>
#  endif
#  if defined( _MSC_VER )
#    define EMPTY_STRUCT struct { char nothing[]; }
#  endif
#  if defined( __WATCOMC__ )
#     define EMPTY_STRUCT char
#  endif
#  ifdef __cplusplus
/* Could also consider defining 'SACK_NAMESPACE' as 'extern "C"
   ' {' and '..._END' as '}'                                    */
#    define SACK_NAMESPACE namespace sack {
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define SACK_NAMESPACE_END }
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _CONTAINER_NAMESPACE namespace containers {
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _CONTAINER_NAMESPACE_END }
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _LINKLIST_NAMESPACE namespace list {
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _LINKLIST_NAMESPACE_END }
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _DATALIST_NAMESPACE namespace data_list {
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _DATALIST_NAMESPACE_END }
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _SETS_NAMESPACE namespace sets {
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _SETS_NAMESPACE_END }
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _TEXT_NAMESPACE namespace text {
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _TEXT_NAMESPACE_END }
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define TEXT_NAMESPACE SACK_NAMESPACE _CONTAINER_NAMESPACE namespace text {
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define TEXT_NAMESPACE_END  } _CONTAINER_NAMESPACE_END SACK_NAMESPACE_END
#  else
/* Define the sack namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define SACK_NAMESPACE
/* Define the sack namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define SACK_NAMESPACE_END
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _CONTAINER_NAMESPACE
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _CONTAINER_NAMESPACE_END
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _LINKLIST_NAMESPACE
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _LINKLIST_NAMESPACE_END
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _DATALIST_NAMESPACE
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _DATALIST_NAMESPACE_END
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _SETS_NAMESPACE
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _SETS_NAMESPACE_END
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _TEXT_NAMESPACE
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define _TEXT_NAMESPACE_END
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define TEXT_NAMESPACE
/* Define the container namespace (when building with C++, the
   wrappers are namespace{} instead of extern"c"{} )           */
#    define TEXT_NAMESPACE_END
#  endif
/* declare composite SACK_CONTAINER namespace to declare sack::container in a single line */
#  define SACK_CONTAINER_NAMESPACE SACK_NAMESPACE _CONTAINER_NAMESPACE
/* declare composite SACK_CONTAINER namespace to close sack::container in a single line */
#  define SACK_CONTAINER_NAMESPACE_END _CONTAINER_NAMESPACE_END SACK_NAMESPACE_END
/* declare composite SACK_CONTAINER namespace to declare sack::container::list in a single line */
#  define SACK_CONTAINER_LINKLIST_NAMESPACE SACK_CONTAINER_NAMESPACE _LISTLIST_NAMESPACE
/* declare composite SACK_CONTAINER namespace to close sack::container::list in a single line */
#  define SACK_CONTAINER_LINKLIST_NAMESPACE_END _LISTLIST_NAMESPACE_END SACK_CONTAINER_NAMESPACE
// this symbols is defined to enforce
// the C Procedure standard - using a stack, and resulting
// in EDX:EAX etc...
#  define CPROC
#if !defined( _WIN32 )
#  define PUBLIC_METHOD
#  define REFERENCE_METHOD extern
#else
#  define PUBLIC_METHOD __declspec(dllexport)
#  define REFERENCE_METHOD __declspec(dllimport)
#endif
#  ifdef SACK_BAG_EXPORTS
#    ifdef BUILD_GLUE
// this is used as the export method appropriate for C#?
#      define EXPORT_METHOD [DllImport(LibName)] public
#    else
#      ifdef __cplusplus_cli
#        if defined( __STATIC__ ) || defined( __LINUX__ ) || defined( __ANDROID__ )
#          define EXPORT_METHOD
#          define IMPORT_METHOD extern
#        else
#          define EXPORT_METHOD __declspec(dllexport)
#          define IMPORT_METHOD __declspec(dllimport)
#        endif
#        define LITERAL_LIB_EXPORT_METHOD __declspec(dllexport)
#        define LITERAL_LIB_IMPORT_METHOD extern
//__declspec(dllimport)
#      else
#        if defined( __STATIC__ ) || defined( __LINUX__ ) || defined( __ANDROID__ )
#          define EXPORT_METHOD
#          define IMPORT_METHOD extern
#        else
/* Method to declare functions exported from a DLL. (nothign on
   LINUX or building statically, but __declspec(dllimport) on
   windows )                                                    */
#          define EXPORT_METHOD __declspec(dllexport)
/* method to define a function which will be Imported from a
   library. Under windows, this is probably
   __declspec(dllimport). Under linux this is probably 'extern'. */
#          define IMPORT_METHOD __declspec(dllimport)
#        endif
#        define LITERAL_LIB_EXPORT_METHOD __declspec(dllexport)
#        define LITERAL_LIB_IMPORT_METHOD __declspec(dllimport)
#      endif
#    endif
#  else
#  if ( !defined( __STATIC__ ) && defined( WIN32 ) && !defined( __cplusplus_cli) )
#    define EXPORT_METHOD __declspec(dllexport)
#    define IMPORT_METHOD __declspec(dllimport)
#    define LITERAL_LIB_EXPORT_METHOD __declspec(dllexport)
#    define LITERAL_LIB_IMPORT_METHOD __declspec(dllimport)
#  else
// MRT:  This is needed.  Need to see what may be defined wrong and fix it.
#    if defined( __LINUX__ ) || defined( __STATIC__ ) || defined( __ANDROID__ )
#      define EXPORT_METHOD
#      define IMPORT_METHOD extern
#      define LITERAL_LIB_EXPORT_METHOD
#      define LITERAL_LIB_IMPORT_METHOD extern
#    else
#      define EXPORT_METHOD __declspec(dllexport)
#      define IMPORT_METHOD __declspec(dllimport)
/* Define how methods in LITERAL_LIBRARIES are exported.
   literal_libraries are libraries that are used for plugins,
   and are dynamically loaded by code. They break the rules of
   system prefix and suffix extensions. LITERAL_LIBRARIES are
   always dynamic, and never static.                           */
#      define LITERAL_LIB_EXPORT_METHOD __declspec(dllexport)
/* Define how methods in LITERAL_LIBRARIES are imported.
   literal_libraries are libraries that are used for plugins,
   and are dynamically loaded by code. They break the rules of
   system prefix and suffix extensions. LITERAL_LIBRARIES are
   always dynamic, and never static.                           */
#      define LITERAL_LIB_IMPORT_METHOD __declspec(dllimport)
#    endif
#  endif
#endif
#ifdef __EMSCRIPTEN__
#include <emscripten.h>
#include <emscripten/emscripten.h>
// Emscripten exports just need to be not optimized out.
#  undef  EXPORT_METHOD
#  define EXPORT_METHOD                EMSCRIPTEN_KEEPALIVE
#  undef  LITERAL_LIB_EXPORT_METHOD
#  define LITERAL_LIB_EXPORT_METHOD    EMSCRIPTEN_KEEPALIVE
#endif
// used when the keword specifying a structure is packed
// needs to prefix the struct keyword.
#define PREFIX_PACKED
// private thing left as a note, and forgotten.  some compilers did not define offsetof
#define my_offsetof( ppstruc, member ) ((uintptr_t)&((*ppstruc)->member)) - ((uintptr_t)(*ppstruc))
#ifdef __cplusplus
namespace sack {
#endif
#ifdef BCC16
#define __inline__
#define MAINPROC(type,name)     type _pascal name
// winproc is intended for use at libmain/wep/winmain...
#define WINPROC(type,name)      type _far _pascal _export name
// callbackproc is for things like timers, dlgprocs, wndprocs...
#define CALLBACKPROC(type,name) type _far _pascal _export name
#define PUBLIC(type,name)       type STDPROC _export name
 /* here would be if dwReason == process_attach */
#define LIBMAIN() WINPROC(int, LibMain)(HINSTANCE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpCmdLine )		 { {
 /* end if */
 /*endproc*/
#define LIBEXIT() } }	    int STDPROC WEP(int nSystemExit )  {
#define LIBMAIN_END()  }
// should use this define for all local defines...
// this will allow one place to modify ALL _pascal or not to _pascal decls.
#define STDPROC _far _pascal
#endif
#if defined( __LCC__ ) || defined( _MSC_VER ) || defined(__DMC__) || defined( __WATCOMC__ )
#ifdef __WATCOMC__
#undef CPROC
#define CPROC __cdecl
#define STDPROC __cdecl
#ifndef __WATCOMC__
// watcom windef.h headers define this
#define STDCALL _stdcall
#endif
#if __WATCOMC__ >= 1280
// watcom windef.h headers no longer define this.
#define STDCALL __stdcall
#endif
#undef PREFIX_PACKED
#define PREFIX_PACKED _Packed
#else
#undef CPROC
//#error blah
#define CPROC __cdecl
#define STDPROC
#define STDCALL _stdcall
#endif
#define far
#define huge
#define near
#define _far
#define _huge
#define _near
/* portability type for porting legacy 16 bit applications. */
/* portability macro for legacy 16 bit applications. */
#define __far
#ifndef FAR
#define FAR
#endif
//#define HUGE
//#ifndef NEAR
//#define NEAR
//#endif
#define _fastcall
#ifdef __cplusplus
#ifdef __cplusplus_cli
#define PUBLIC(type,name) extern "C"  LITERAL_LIB_EXPORT_METHOD type CPROC name
#else
//#error what the hell!?
// okay Public functions are meant to be loaded with LoadFuncion( "library" , "function name"  );
#define PUBLIC(type,name) extern "C"  LITERAL_LIB_EXPORT_METHOD type CPROC name
#endif
#else
#define PUBLIC(type,name) LITERAL_LIB_EXPORT_METHOD type CPROC name
#endif
#define MAINPROC(type,name)  type WINAPI name
#define WINPROC(type,name)   type WINAPI name
#define CALLBACKPROC(type,name) type CALLBACK name
#if defined( __WATCOMC__ )
#define LIBMAIN()   static int __LibMain( HINSTANCE ); PRELOAD( LibraryInitializer ) {	 __LibMain( GetModuleHandle(TARGETNAME) );   }	 static int __LibMain( HINSTANCE hInstance ) {
#define LIBEXIT() } static int LibExit( void ); ATEXIT( LiraryUninitializer ) { LibExit(); } int LibExit(void) {
#define LIBMAIN_END() }
#else
#ifdef TARGETNAME
#define LIBMAIN()   static int __LibMain( HINSTANCE ); PRELOAD( LibraryInitializer ) {	 __LibMain( GetModuleHandle(TARGETNAME) );   }	 static int __LibMain( HINSTANCE hInstance ) {
#else
#define LIBMAIN()   TARGETNAME_NOT_DEFINED
#endif
#define LIBEXIT() } static int LibExit( void ); ATEXIT( LiraryUninitializer ) { LibExit(); } int LibExit(void) {
#define LIBMAIN_END() }
#endif
#define PACKED
#endif
#if defined( __GNUC__ )
#  ifndef STDPROC
#    define STDPROC
#  endif
#  ifndef STDCALL
 // for IsBadCodePtr which isn't a linux function...
#    define STDCALL
#  endif
#  ifndef WINAPI
#    ifdef __LINUX__
#       define WINAPI
#    else
#       define WINAPI __stdcall
#    endif
#  endif
#  ifndef PASCAL
//#define PASCAL
#  endif
#  define WINPROC(type,name)   type WINAPI name
#  define CALLBACKPROC( type, name ) type name
#  define PUBLIC(type,name) EXPORT_METHOD type CPROC name
#  define LIBMAIN()   static int __LibMain( HINSTANCE ); PRELOAD( LibraryInitializer ) {	 __LibMain( GetModuleHandle(TARGETNAME) );   }	 static int __LibMain( HINSTANCE hInstance ) {
#  define LIBEXIT() } static int LibExit( void ); ATEXIT( LiraryUninitializer ) { LibExit(); } int LibExit(void) {
#  define LIBMAIN_END()  }
/* Portability Macro for porting legacy code forward. */
#  define FAR
#  define NEAR
//#define HUGE
#  define far
#  define near
#  define huge
#  define PACKED __attribute__((packed))
#endif
#if defined( BCC32 )
#define far
#define huge
/* define obsolete keyword for porting purposes */
/* defined for porting from 16 bit environments */
#define near
/* portability macro for legacy 16 bit applications. */
#define _far
#define _huge
#define _near
/* portability type for porting to compilers that don't inline. */
/* portability macro for legacy 16 bit applications. */
#define __inline__
#define MAINPROC(type,name)     type _pascal name
// winproc is intended for use at libmain/wep/winmain...
#define WINPROC(type,name)      EXPORT_METHOD type _pascal name
// callbackproc is for things like timers, dlgprocs, wndprocs...
#define CALLBACKPROC(type,name) EXPORT_METHOD type _stdcall name
#define STDCALL _stdcall
#define PUBLIC(type,name)        type STDPROC name
#ifdef __STATIC__
			/*Log( "Library Enter" );*/
#define LIBMAIN() static WINPROC(int, LibMain)(HINSTANCE hInstance, DWORD dwReason, void *unused )		 { if( dwReason == DLL_PROCESS_ATTACH ) {
 /* end if */
#define LIBEXIT() } if( dwReason == DLL_PROCESS_DETACH ) {
#define LIBMAIN_END()  } return 1; }
#else
			/*Log( "Library Enter" );*/
#define LIBMAIN() WINPROC(int, LibMain)(HINSTANCE hInstance, DWORD dwReason, void *unused )		 { if( dwReason == DLL_PROCESS_ATTACH ) {
 /* end if */
#define LIBEXIT() } if( dwReason == DLL_PROCESS_DETACH ) {
#define LIBMAIN_END()  } return 1; }
#endif
// should use this define for all local defines...
// this will allow one place to modify ALL _pascal or not to _pascal decls.
#define STDPROC _pascal
#define PACKED
#endif
#define TOCHR(n) #n[0]
#define TOSTR(n) #n
#define STRSYM(n) TOSTR(n)
#define _WIDE__FILE__(n) n
#define WIDE__FILE__ _WIDE__FILE__(__FILE__)
/* a constant text string that represents the current source
   filename and line... fourmated as "source.c(11) :"        */
#define FILELINE  TEXT(__FILE__) "(" TEXT(STRSYM(__LINE__))" : ")
#if defined( _MSC_VER ) || defined( __PPCCPP__ )
/* try and define a way to emit comipler messages... but like no compilers support standard ways to do this accross the board.*/
#define pragnote(msg) message( FILELINE msg )
/* try and define a way to emit comipler messages... but like no compilers support standard ways to do this accross the board.*/
#define pragnoteonly(msg) message( msg )
#else
/* try and define a way to emit comipler messages... but like no compilers support standard ways to do this accross the board.*/
#define pragnote(msg) msg
/* try and define a way to emit comipler messages... but like no compilers support standard ways to do this accross the board.*/
#define pragnoteonly(msg) msg
#endif
/* specify a consistant macro to pass current file and line information.   This are appended parameters, and common usage is to only use these with _DEBUG set. */
#define FILELINE_SRC         , __FILE__, __LINE__
/* specify a consistant macro to pass current file and line information, to functions which void param lists.   This are appended parameters, and common usage is to only use these with _DEBUG set. */
#define FILELINE_VOIDSRC     __FILE__, __LINE__
//#define FILELINE_LEADSRC     __FILE__, __LINE__,
/* specify a consistant macro to define file and line parameters, to functions with otherwise void param lists.  This are appended parameters, and common usage is to only use these with _DEBUG set. */
#define FILELINE_VOIDPASS    CTEXTSTR pFile, uint32_t nLine
//#define FILELINE_LEADPASS    CTEXTSTR pFile, uint32_t nLine,
/* specify a consistant macro to define file and line parameters.   This are appended parameters, and common usage is to only use these with _DEBUG set. */
#define FILELINE_PASS        , CTEXTSTR pFile, uint32_t nLine
/* specify a consistant macro to forward file and line parameters.   This are appended parameters, and common usage is to only use these with _DEBUG set. */
#define FILELINE_RELAY       , pFile, nLine
/* specify a consistant macro to forward file and line parameters.   This are appended parameters, and common usage is to only use these with _DEBUG set. */
#define FILELINE_NULL        , NULL, 0
/* specify a consistant macro to forward file and line parameters, to functions which have void parameter lists without this information.  This are appended parameters, and common usage is to only use these with _DEBUG set. */
#define FILELINE_VOIDRELAY   pFile, nLine
/* specify a consistant macro to format file and line information for printf formated strings. */
#define FILELINE_FILELINEFMT "%s(%" _32f "): "
#define FILELINE_FILELINEFMT_MIN "%s(%" _32f ")"
#define FILELINE_NULL        , NULL, 0
#define FILELINE_VOIDNULL    NULL, 0
/* define static parameters which are the declaration's current file and line, for stubbing in where debugging is being stripped.
  usage
    FILELINE_VARSRC: // declare pFile and nLine variables.
	*/
#define FILELINE_VARSRC       CTEXTSTR pFile = __FILE__; uint32_t nLine = __LINE__
// this is for passing FILE, LINE information to allocate
// useful during DEBUG phases only...
// drop out these debug relay paramters for managed code...
// we're going to have the full call frame managed and known...
#if !defined( _DEBUG ) && !defined( _DEBUG_INFO )
#  define DBG_AVAILABLE   0
/* in NDEBUG mode, pass nothing */
#  define DBG_SRC
/* <combine sack::DBG_PASS>
   in NDEBUG mode, pass nothing */
#  define DBG_VOIDSRC
/* <combine sack::DBG_PASS>
   \#define DBG_LEADSRC in NDEBUG mode, declare (void) */
/* <combine sack::DBG_PASS>
   \ \                      */
#  define DBG_VOIDPASS    void
/* <combine sack::DBG_PASS>
   in NDEBUG mode, pass nothing */
#  define DBG_PASS
/* <combine sack::DBG_PASS>
   in NDEBUG mode, pass nothing */
#  define DBG_RELAY
/* <combine sack::DBG_PASS>
   in _DEBUG mode, pass FILELINE_NULL */
#  define DBG_NULL
/* <combine sack::DBG_PASS>
   in NDEBUG mode, pass nothing */
#  define DBG_VOIDRELAY
/* <combine sack::DBG_PASS>
   in NDEBUG mode, pass nothing */
#  define DBG_FILELINEFMT
/* <combine sack::DBG_PASS>
   in NDEBUG mode, pass nothing */
#  define DBG_FILELINEFMT_MIN
/* <combine sack::DBG_PASS>
   in NDEBUG mode, pass nothing
   Example
   printf( DBG_FILELINEFMT ": extra message" DBG_PASS ); */
#  define DBG_VARSRC
#else
// used to specify whether debug information is being passed - can be referenced in compiled code
#  define DBG_AVAILABLE   1
/* <combine sack::DBG_PASS>
   in _DEBUG mode, pass FILELINE_SRC */
#  define DBG_SRC         FILELINE_SRC
/* <combine sack::DBG_PASS>
   in _DEBUG mode, pass FILELINE_VOIDSRC */
#  define DBG_VOIDSRC     FILELINE_VOIDSRC
/* <combine sack::DBG_PASS>
   in _DEBUG mode, pass FILELINE_VOIDPASS */
#define DBG_VOIDPASS    FILELINE_VOIDPASS
/* <combine sack::DBG_PASS>
   in NDEBUG mode, pass nothing */
/* Example
   This example shows forwarding debug information through a
   chain of routines.
   <code lang="c++">
   void ReportFunction( int sum DBG_PASS )
   {
       printf( "%s(%d):started this whole mess\\n" DBG_RELAY );
   }
   void TrackingFunction( int a, int b DBG_PASS )
   {
       ReportFunction( a+b, DBG_RELAY );
   }
   void CallTrack( void )
   {
       TrackingFunction( 1, 2 DBG_SRC );
   }
   </code>
   In this example, the debug information is passed to the
   logging system. This allows logging to blame the user
   application for allocations, releases, locks, etc...
   <code lang="c++">
   void MyAlloc( int size DBG_PASS )
   {
       _lprintf( DBG_RELAY )( ": alloc %d\\n", size );
   }
   void g( void )
   {
       lprintf( "Will Allocate %d\\n", 32 );
       MyAlloc( 32 DBG_SRC );
   }
   </code>
   This example uses the void argument macros
   <code>
   void SimpleFunction( DBG_VOIDPASS )
   {
       // this function usually has (void) parameters.
   }
   void f( void )
   {
       SimpleFunction( DBG_VOIDSRC );
   }
   </code>
   Description
   in NDEBUG mode, pass nothing.
   This function allows specification of DBG_RELAY or DBG_SRC
   under debug compilation. Otherwise, the simple AddLink macro
   should be used. DBG_RELAY can be used to forward file and
   line information which has been passed via DBG_PASS
   declaration in the function parameters.
   This is a part of a set of macros which allow additional
   logging information to be passed.
   These 3 are the most commonly used.
   DBG_SRC - this passes the current __FILE__, __LINE__
   \parameters.
   DBG_PASS - this is used on a function declaration, is a
   filename and line number from DBG_SRC or DBG_RELAY.
   DBG_RELAY - this passes the file and line passed to this
   function to another function with DBG_PASS defined on it.
   DBG_VOIDPASS - used when the argument list is ( void )
   without debugging information.
   DBG_VOIDSRC - used to call a function who's argument list is
   ( void ) without debugging information.
   DBG_VOIDRELAY - pass file and line information forward to
   another function, who's argument list is ( void ) without
   debugging information.
   Remarks
   The SACK library is highly instrumented with this sort of
   information. Very commonly the only difference between a
   specific function called 'MyFunctionName' and
   'MyFunctionNameEx' is the addition of debug information
   tracking.
   The following code blocks show the evolution added to add
   instrumentation...
   <code lang="c++">
   int MyFunction( int param )
   {
       // do stuff
   }
   int CallingFunction( void )
   {
       return MyFunction();
   }
   </code>
   Pretty simple code, a function that takes a parameter, and a
   function that calls it.
   The first thing is to extend the called function.
   <code>
   int MyFunctionEx( int param DBG_PASS )
   {
       // do stuff
   }
   </code>
   And provide a macro for everyone else calling the function to
   automatically pass their file and line information
   <code lang="c++">
   \#define MyFunction(param)  MyFunctionEx(param DBG_SRC)
   </code>
   Then all-together
   <code>
   \#define MyFunction(param)  MyFunctionEx(param DBG_SRC)
   int MyFunctionEx( int param DBG_PASS )
   {
       // do stuff
   }
   int CallingFunction( void )
   {
       // and this person calling doesn't matter
       // does require a recompile of source.
       return MyFunction( 3 );
   }
   </code>
   But then... what if CallingFunction decided wasn't really the
   one at fault, or responsible for the allocation, or other
   issue being tracked, then she could be extended....
   <code>
   int CallingFunctionEx( DBG_VOIDPASS )
   \#define CallingFunction() CallingFunction( DBG_VOIDSRC )
   {
       // and this person calling doesn't matter
       // does require a recompile of source.
       return MyFunction( 1 DBG_RELAY );
   }
   </code>
   Now, calling function will pass it's callers information to
   MyFunction....
   Why?
   Now, when you call CreateList, your code callng the list
   creation method is marked as the one who allocates the space.
   Or on a DeleteList, rather than some internal library code
   being blamed, the actual culprit can be tracked and
   identified, because it's surely not the fault of CreateList
   that the reference to the memory for the list wasn't managed
   correctly.
   Note
   It is important to note, every usage of these macros does not
   have a ',' before them. This allows non-debug code to
   eliminate these extra parameters cleanly. If the ',' was
   outside of the macro, then it would remain on the line, and
   an extra parameter would have be be passed that was unused.
   This is also why DBG_VOIDPASS exists, because in release mode
   this is substituted with 'void'.
   In Release mode, DBG_VOIDRELAY becomes nothing, but when in
   debug mode, DBG_RELAY has a ',' in the macro, so without a
   paramter f( DBG_RELAY ) would fail; on expansion this would
   be f( , pFile, nLine ); (note the extra comma, with no
   parameter would be a syntax error.                            */
#  define DBG_PASS        FILELINE_PASS
/* <combine sack::DBG_PASS>
   in _DEBUG mode, pass FILELINE_RELAY */
#  define DBG_RELAY       FILELINE_RELAY
/* <combine sack::DBG_PASS>
	  in _DEBUG mode, pass FILELINE_NULL */
#  define DBG_NULL        FILELINE_NULL
/* <combine sack::DBG_PASS>
   in _DEBUG mode, pass FILELINE_VOIDRELAY */
#  define DBG_VOIDRELAY   FILELINE_VOIDRELAY
/* <combine sack::DBG_PASS>
   in _DEBUG mode, pass FILELINE_FILELINEFMT */
#  define DBG_FILELINEFMT FILELINE_FILELINEFMT
/* <combine sack::DBG_PASS>
   in _DEBUG mode, pass FILELINE_FILELINEFMT_MIN */
#  define DBG_FILELINEFMT_MIN FILELINE_FILELINEFMT_MIN
/* <combine sack::DBG_PASS>
   in _DEBUG mode, pass FILELINE_VARSRC */
#  define DBG_VARSRC      FILELINE_VARSRC
#endif
/* cannot declare _0 since that overloads the
   vector library definition for origin (0,0,0,0,...) */
//typedef void             _0; // totally unusable to declare 0 size things.
/* the only type other than when used in a function declaration that void is valid is as a pointer to void. no _0 type exists
 *  (it does, but it's in vectlib, and is an origin vector)
*/
typedef void             *P_0;
/*
 * several compilers are rather picky about the types of data
 * used for bit field declaration, therefore this type
 * should be used instead of uint32_t (DWORD)
 */
typedef unsigned int  BIT_FIELD;
/*
 * several compilers are rather picky about the types of data
 * used for bit field declaration, therefore this type
 * should be used instead of int32_t (LONG)
 */
typedef int  SBIT_FIELD;
// have to do this on a per structure basis - otherwise
// any included headers with structures to use will get
// padded as normal; this is appended to a strcture
// and is ued on GCC comiplers for __attribute__((packed))
#ifndef PACKED
#  define PACKED
#endif
/* An pointer to a volatile unsigned integer type that is 64 bits long. */
//typedef volatile uint64_t  *volatile int64_t*;
/* An pointer to a volatile pointer size type that is as long as a pointer. */
typedef volatile uintptr_t        *PVPTRSZVAL;
/* an unsigned type meant to index arrays.  (By convention, arrays are not indexed negatively.)  An index which is not valid is INVALID_INDEX, which equates to 0xFFFFFFFFUL or negative one cast as an INDEX... ((INDEX)-1). */
typedef size_t         INDEX;
/* An index which is not valid; equates to 0xFFFFFFFFUL or negative one cast as an INDEX... ((INDEX)-1). */
#define INVALID_INDEX ((INDEX)-1)
// constant text string content
typedef const char     *CTEXTSTR;
/* A non constant array of TEXTCHAR. A pointer to TEXTCHAR. A
   pointer to non-constant characters. (A non-static string
   probably)                                                  */
typedef char           *TEXTSTR;
#if defined( __LINUX__ ) && defined( __cplusplus )
// pointer to constant text string content
typedef TEXTSTR const  *PCTEXTSTR;
#else
// char const *const *
typedef CTEXTSTR const *PCTEXTSTR;
#endif
/* a text 8 bit character  */
typedef char            TEXTCHAR;
/* a character rune.  Strings should be interpreted as UTF-8 or 16 depending on UNICODE compile option.
   GetUtfChar() from strings.  */
typedef uint32_t             TEXTRUNE;
/* Used to handle returned values that are past end or beginning of string for instance */
#define RUNE_AFTER_END     0x8000000
#define RUNE_BEFORE_START  0x8000001
/* Used to handle returned values that are invalid utf8 encodings. */
#define BADUTF8            0xFFFD
//typedef enum { FALSE, TRUE } LOGICAL; // smallest information
#ifndef FALSE
#define FALSE 0
/* Define TRUE when not previously defined in the platform. TRUE
   is (!FALSE) so anything not 0 is true.                        */
#define TRUE (!FALSE)
#endif
/* Meant to hold boolean and only boolean values. Should be
   implemented per-platform as appropriate for the bool type the
   compiler provides.                                            */
typedef uint32_t LOGICAL;
/* This is a pointer. It is a void*. It is meant to point to a
   single thing, and cannot be used to reference arrays of bytes
   without recasting.                                            */
typedef P_0 POINTER;
/* This is a pointer to constant data. void const *. Compatible
   with things like char const *.                               */
typedef const void *CPOINTER;
#ifdef __cplusplus
 //SACK_NAMESPACE_END // namespace sack {
}
#endif
//------------------------------------------------------
// formatting macro defintions for [vsf]printf output of the above types
#if !defined( _MSC_VER ) || ( _MSC_VER >= 1900 )
#ifndef __STDC_FORMAT_MACROS
#  define __STDC_FORMAT_MACROS
#endif
#include <inttypes.h>
#endif
/*
   Top level namespace.  SACK Is the System Abstraction Componnet Kit.
   With a little work subsets of this namesapce can be used.  Typrically
   this is built as just one large c/c++ shared library.
*/
#ifdef __cplusplus
namespace sack {
#endif
/* 16 bit unsigned decimal output printf format specifier. This would
   otherwise be defined in \<inttypes.h\>                */
#define _16f   "u"
/* 16 bit hex output printf format specifier. This would
   otherwise be defined in \<inttypes.h\>                */
#define _16fx   "x"
/* 16 bit HEX output printf format specifier. This would
   otherwise be defined in \<inttypes.h\>                */
#define _16fX   "X"
/* 16 bit signed decimal output printf format specifier. This
   would otherwise be defined in \<inttypes.h\>               */
#define _16fs   "d"
/* 8 bit unsigned decimal output printf format specifier. This would
   otherwise be defined in \<inttypes.h\>                */
#define _8f   "u"
/* 8 bit hex output printf format sppecifier. This would
   otherwise be defined in \<inttypes.h\>                */
#define _8fx   "x"
/* 8 bit HEX output printf format specifier. This would
   otherwise be defined in \<inttypes.h\>                */
#define _8fX   "X"
/* 8 bit signed decimal output printf format specifier. This
   would otherwise be defined in \<inttypes.h\>               */
#define _8fs   "d"
#if defined( __STDC_FORMAT_MACROS )
#  define _32f   PRIu32
#  define _32fx    PRIx32
#  define _32fX    PRIX32
#  define _32fs    PRId32
#  define _64f    PRIu64
#  define _64fx   PRIx64
#  define _64fX   PRIX64
#  define _64fs   PRId64
// non-unicode strings
#  define c_32f    PRIu32
#  define c_32fx   PRIx32
#  define c_32fX   PRIX32
#  define c_32fs   PRId32
#  define c_64f    PRIu64
#  define c_64fx   PRIx64
#  define c_64fX   PRIX64
#  define c_64fs   PRId64
#else
#  define _32f   "u"
#  define _32fx   "x"
#  define _32fX   "X"
#  define _32fs   "d"
#  define c_32f   "u"
#  define c_32fx  "x"
#  define c_32fX  "X"
#  define c_32fs  "d"
#  define c_64f    "llu"
#  define c_64fx   "llx"
#  define c_64fX   "llX"
#  define c_64fs   "lld"
#endif
#  define _cstring_f "s"
#  define _string_f "s"
#  define _ustring_f "S"
#if defined( __64__ )
#  if defined( __STDC_FORMAT_MACROS )
#    if !defined( __GNUC__ ) || defined( _WIN32 )
#      define _size_f     PRIu64
#      define _size_fx    PRIx64
#      define _size_fX    PRIX64
#      define _size_fs    PRId64
#      define c_size_f    PRIu64
#      define c_size_fx   PRIx64
#      define c_size_fX   PRIX64
#      define c_size_fs   PRId64
#    else
#      define _size_f    "zu"
#      define _size_fx   "zx"
#      define _size_fX   "zX"
#      define _size_fs   "zd"
#      define c_size_f    "zu"
#      define c_size_fx   "zx"
#      define c_size_fX   "zX"
#      define c_size_fs   "zd"
#    endif
#    define _PTRSZVALfs  PRIuPTR
#    define _PTRSZVALfx  PRIxPTR
#    define cPTRSZVALfs PRIuPTR
#    define cPTRSZVALfx PRIxPTR
#  else
#    if !defined( __GNUC__ ) || defined( _WIN32 )
#      define _size_f    _64f
#      define _size_fx   _64fx
#      define _size_fX   _64fX
#      define _size_fs   _64fs
#      define c_size_f   c_64f
#      define c_size_fx  c_64fx
#      define c_size_fX  c_64fX
#      define c_size_fs  c_64fs
#    else
#      define _size_f    "zu"
#      define _size_fx   "zx"
#      define _size_fX   "zX"
#      define _size_fs   "zd"
#      define c_size_f    "zu"
#      define c_size_fx   "zx"
#      define c_size_fX   "zX"
#      define c_size_fs   "zd"
#    endif
#    define _PTRSZVALfs  PRIuPTR
#    define _PTRSZVALfx  PRIxPTR
#    define cPTRSZVALfs PRIuPTR
#    define cPTRSZVALfx PRIxPTR
#  endif
#else
#  if defined( __STDC_FORMAT_MACROS )
      // this HAS been fixed in UCRT - 2015!  but it'll take 5 years before everyone has that...
#    if !defined( __GNUC__ ) || defined( _WIN32 )
#      define _size_f     PRIu32
#      define _size_fx    PRIx32
#      define _size_fX    PRIX32
#      define _size_fs    PRId32
#      define c_size_f    PRIu32
#      define c_size_fx   PRIx32
#      define c_size_fX   PRIX32
#      define c_size_fs   PRId32
#    else
#      define _size_f    "zu"
#      define _size_fx   "zx"
#      define _size_fX   "zX"
#      define _size_fs   "zd"
#      define c_size_f    "zu"
#      define c_size_fx   "zx"
#      define c_size_fX   "zX"
#      define c_size_fs   "zd"
#    endif
#    define _PTRSZVALfs  PRIuPTR
#    define _PTRSZVALfx  PRIxPTR
#    define cPTRSZVALfs PRIuPTR
#    define cPTRSZVALfx PRIxPTR
#  else
      // this HAS been fixed in UCRT - 2015!  but it'll take 5 years before everyone has that...
#    if !defined( __GNUC__ ) || defined( _WIN32 )
#      define _size_f    _32f
#      define _size_fx   _32fx
#      define _size_fX   _32fX
#      define _size_fs   _32fs
#      define c_size_f    c_32f
#      define c_size_fx   c_32fx
#      define c_size_fX   c_32fX
#      define c_size_fs   c_32fs
#    else
#      define _size_f    "zu"
#      define _size_fx   "zx"
#      define _size_fX   "zX"
#      define _size_fs   "zd"
#      define c_size_f    "zu"
#      define c_size_fx   "zx"
#      define c_size_fX   "zX"
#      define c_size_fs   "zd"
#    endif
#    define _PTRSZVALfs  PRIuPTR
#    define _PTRSZVALfx  PRIxPTR
#    define cPTRSZVALfs PRIuPTR
#    define cPTRSZVALfx PRIxPTR
#  endif
#endif
#define PTRSZVALf "p"
#define _PTRSZVALf "p"
#if defined( _MSC_VER ) && ( _MSC_VER < 1900 )
/* 64 bit unsigned decimal output printf format specifier. This would
   otherwise be defined in \<inttypes.h\> as PRIu64              */
#define _64f    "llu"
/* 64 bit hex output printf format specifier. This would
   otherwise be defined in \<inttypes.h\> as PRIxFAST64                */
#define _64fx   "llx"
/* 64 bit HEX output printf format specifier. This would
   otherwise be defined in \<inttypes.h\> as PRIxFAST64                */
#define _64fX   "llX"
/* 64 bit signed decimal output printf format specifier. This
   would otherwise be defined in \<inttypes.h\> as PRIdFAST64               */
#define _64fs   "lld"
#endif
// This should be for several years a
// sufficiently large type to represent
// threads and processes.
typedef uint64_t THREAD_ID;
#define GetMyThreadIDNL GetMyThreadID
#if defined( _WIN32 )
#  define _GetMyThreadID()  ( (( ((uint64_t)GetCurrentProcessId()) << 32 ) | ( (uint64_t)GetCurrentThreadId() ) ) )
#  define GetMyThreadID()  (GetThisThreadID())
#else
// this is now always the case
// it's a safer solution anyhow...
#  ifdef __MAC__
     DeclareThreadLocal uint64_t tmpThreadid;
#    define GetMyThreadID()  ((pthread_threadid_np(NULL, &tmpThreadid)),tmpThreadid)
#  else
#    ifndef GETPID_RETURNS_PPID
#      define GETPID_RETURNS_PPID
#    endif
#    ifdef GETPID_RETURNS_PPID
#      ifdef __ANDROID__
#        define GetMyThreadID()  (( ((uint64_t)getpid()) << 32 ) | ( (uint64_t)(gettid()) ) )
#      else
#        if defined( __EMSCRIPTEN__ )
#          define GetMyThreadID()  ( (uint64_t)(pthread_self()) )
#        else
#          define GetMyThreadID()  (( ((uint64_t)getpid()) << 32 ) | ( (uint64_t)(syscall(SYS_gettid)) ) )
#        endif
#      endif
#    else
#      define GetMyThreadID()  (( ((uint64_t)getppid()) << 32 ) | ( (uint64_t)(getpid()|0x40000000)) )
#    endif
#  endif
#  define _GetMyThreadID GetMyThreadID
#endif
//---------------------- Declare Link; 'single and a half'ly-linked lists -----------------------
// Thse macros are for linking and unlininking things in a linked list.
// The list is basically a singly-linked list, but also references the pointer that
// is pointing at the current node.  This simplifies insert/remove operations, because
// the specific list that the node is in, is not required.
// List heads will always be updated correctly.
//
// A few 'tricks' are available, such as
//     0) These are deemed dangerous; and uncomprehendable by anyone but the maintainer.
//        use at your own time and expense required to explain WHY these work.
//     1) when declaring a root node, include another node before it, and it's
//        simple to make this a circularly linked list.
//     2) defining DeclareLink at the start of the strcture, the 'me' pointer
//        also happens to be 'prior', so you can step through the list in both
//        directions.
//
//
//
// struct my_node {
//    DeclareLink( struct my_node );
//    // ...
// };
//
// that declares
//      struct my_node *next;  // the next node in list.
//      struct my_node **me;   // address of the pointer pointing to 'me';
//
//
//  struct my_node *root; // a root of a list of my_node.  It should be initialized to NULL.
//
//  struct my_node *newNode = (struct my_node*)malloc( sizeof( *newNode ) );
//     // does not require next or me to be initiialized.
//  LinkThing( root, newNode );
//     // now newNode is in the list.
//
//  to remove from a list
//
//  struct my_node *someNode; // this should be a pointer to some valid node.
//  UnlinkThing( someNode );
//     The new node is now not in the list.
//
//  To move one node from one list to another
//
//   struct my_node *rootAvail;  // available nodes
//   struct my_node *rootUsed;   // nodes in use
//
//   struct my_node *someNode; // some node in a list
//   someNode = rootAvail; // get first available.
//   if( !someNode ) ; // create a new one or abort
//   RelinkThing( rootUsed, someNode );
//      'someNode' is removed from its existing list, and added to the 'rootUsed' list.
//
// For Declaring the link structure members for lists
#define DeclareLink( type )  type *next; type **me
/* Link a new node into the list.
   Example
   struct mynode
   {
       DeclareLink( struct mynode );
   } *node;
	struct mynode *list;
   // node allocation not shown.
	LinkThing( list_root, node );
*/
#define LinkThing( root, node )		     ((( (node)->next = (root) )?	        (((root)->me) = &((node)->next)):0),	  (((node)->me) = &(root)),	             ((root) = (node)) )
/* Link a node to the end of a list. LinkThing() inserts the new
 node as the new head of the list.
 this has to scan the list to find the end, so it is a O(n) operation.
 All other linked list operations are O(1)
 */
#define LinkLast( root, type, node ) if( node ) do { if( !root )	 { root = node; (node)->me=&root; }	 else { type tmp;	 for( tmp = root; tmp->next; tmp = tmp->next );	 tmp->next = (node);	 (node)->me = &tmp->next;	 } } while (0)
// put 'Thing' after 'node'
// inserts 'node' after Thing
#define LinkThingAfter( node, thing )	 ( ( (thing)&&(node))	   ?(((((thing)->next = (node)->next))?((node)->next->me = &(thing)->next):0)	  ,((thing)->me = &(node)->next), ((node)->next = thing))	  :((node)=(thing)) )
//
// put 'Thing' before 'node'... so (*node->me) = thing
// similar to LinkThingAfter but puts the new 'thing'
// before the 'node' specified.
#define LinkThingBefore( node, thing )	 {  thing->next = (*node->me);	(*node->me) = thing;    thing->me = node->me;       node->me = &thing->next;     }
// move a list from one list to another.
// unlinks node from where it was, inserts at the head of another.
// this can also be use to reproiritize within the same list.
#define RelinkThing( root, node )	   ((( node->me && ( (*node->me)=node->next ) )?	  node->next->me = node->me:0),(node->next = NULL),(node->me = NULL),node),	 ((( node->next = root )?	        (root->me = &node->next):0),	  (node->me = &root),	             (root = node) )
/* Remove a node from a list. Requires only the node. */
#define UnlinkThing( node )	                      ((( (node) && (node)->me && ( (*(node)->me)=(node)->next ) )?	  (node)->next->me = (node)->me:0),((node)->next = NULL),((node)->me = NULL),(node))
// this has two expressions duplicated...
// but in being so safe in this expression,
// the self-circular link needs to be duplicated.
// GrabThing is used for nodes which are circularly bound
#define GrabThing( node )	    ((node)?(((node)->me)?(((*(node)->me)=(node)->next)?	 ((node)->next->me=(node)->me),((node)->me=&(node)->next):NULL):((node)->me=&(node)->next)):NULL)
/* Go to the next node with links declared by DeclareLink
 safe iterator macro that tests if node is valid, which returns
 the next item in the list, else returns NULL
 */
#define NextLink(node) ((node)?(node)->next:NULL)
// everything else is called a thing... should probably migrate to using this...
#define NextThing(node) ((node)?(node)->next:NULL)
//----------- FLAG SETS (single bit fields) -----------------
/* the default type to use for flag sets - flag sets are arrays of bits
 which can be set/read with/as integer values an index.
 All of the fields in a maskset are the same width */
#define FLAGSETTYPE uintmax_t
/* the number of bits a specific type is.
   Example
   int bit_size_int = FLAGTYPEBITS( int ); */
#define FLAGTYPEBITS(t) (sizeof(t)*CHAR_BIT)
/* how many bits to add to make sure we round to the next greater index if even 1 bit overflows */
#define FLAGROUND(t) (FLAGTYPEBITS(t)-1)
/* the index of the FLAGSETTYPE which contains the bit in question */
#define FLAGTYPE_INDEX(t,n)  (((n)+FLAGROUND(t))/FLAGTYPEBITS(t))
/* how big the flag set is in count of FLAGSETTYPEs required in a row ( size of the array of FLAGSETTYPE that contains n bits) */
#define FLAGSETSIZE(t,n) (FLAGTYPE_INDEX(t,n) * sizeof( FLAGSETTYPE ) )
// declare a set of flags...
#define FLAGSET(v,n)   FLAGSETTYPE (v)[((n)+FLAGROUND(FLAGSETTYPE))/FLAGTYPEBITS(FLAGSETTYPE)]
// set a single flag index
#define SETFLAG(v,n)   ( ( (v)[(n)/FLAGTYPEBITS((v)[0])] |= (FLAGSETTYPE)1 << ( (n) & FLAGROUND((v)[0]) )),1)
// clear a single flag index
#define RESETFLAG(v,n) ( ( (v)[(n)/FLAGTYPEBITS((v)[0])] &= ~( (FLAGSETTYPE)1 << ( (n) & FLAGROUND((v)[0]) ) ) ),0)
// test if a flags is set
//  result is 0 or not; the value returned is the bit shifted within the word, and not always '1'
#define TESTFLAG(v,n)  ( (v)[(n)/FLAGTYPEBITS((v)[0])] & ( (FLAGSETTYPE)1 << ( (n) & FLAGROUND((v)[0]) ) ) )
// reverse a flag from 1 to 0 and vice versa
// return value is undefined... and is a whole bunch of flags from some offset...
// if you want ot toggle and flag and test the result, use TESTGOGGLEFLAG() instead.
#define TOGGLEFLAG(v,n)   ( (v)[(n)/FLAGTYPEBITS((v)[0])] ^= (FLAGSETTYPE)1 << ( (n) & FLAGROUND((v)[0]) ))
// Toggle a bit, return the state of the bit after toggling.
#define TESTTOGGLEFLAG(v,n)  ( TOGGLEFLAG(v,n), TESTFLAG(v,n) )
//----------- MASK SETS -----------------
//  MASK Sets are arrays of bit-fields of some bit-width (5, 3, ... )
//  they are set/returned as integer values.
//  They are stored-in/accessed via a uint8_t which gives byte-offset calculations.
// they return their value as uintmax_t from the offset memory address directly;
//   Some platforms(Arm) may SIGBUS because of wide offset accesses spanning word boundaries.
//   This issue may be fixed by rounding, grabbing the word aligned values and shifting manually
// Declarataion/Instantiation of a mask set is done with MASKSET macro below
// 32 bits max for range on mask
#define MASK_MAX_LENGTH (sizeof(MASKSET_READTYPE)*CHAR_BIT)
/* gives a 32 bit mask possible from flagset..
 - updated; return max int possible; but only the low N bits will be set
 - mask sets are meant for small values, but could be used for like 21 bit fields. (another form of unicode encoding I suppose)
 */
#define MASKSET_READTYPE uintmax_t
// gives byte index...
#define MASKSETTYPE uint8_t
/* how many bits the type specified can hold
   Parameters
   t :  data type to measure (int, uint32_t, ... ) */
#define MASKTYPEBITS(t) (sizeof(t)*CHAR_BIT)
/* the maximum number of bits storable in a type */
#define MASK_MAX_TYPEBITS(t) (sizeof(t)*CHAR_BIT)
/* round up to the next count of types that fits 1 bit - used as a cieling round factor */
#define MASKROUND(t) (MASKTYPEBITS(t)-1)
/* define MAX_MAX_ROUND factor based on MASKSET_READTYPE - how to read it... */
#define MASK_MAX_ROUND() (MASK_MAX_TYPEBITS(MASKSET_READTYPE)-1)
/* byte index of the start of the mask
   Parameters
   t :  type to measure with
   n :  mask index                     */
#define MASKTYPE_INDEX(t,n)  (((n)+MASKROUND(t))/MASKTYPEBITS(t))
/* The number of bytes the set would be.
   Parameters
   t :  the given type to measure with
   n :  the count of masks to fit.       */
#define MASKSETSIZE(t,n) (MASKTYPE_INDEX(t,(n+1)))
// declare a set of flags...
#define MASK_TOP_MASK_VAL(length,val) ((val)&( ((MASKSET_READTYPE)-1) >> ((sizeof(MASKSET_READTYPE) * CHAR_BIT)-(length)) ))
/* the mask in the dword resulting from shift-right.   (gets a mask of X bits in length) */
#define MASK_TOP_MASK(length) ( ((MASKSET_READTYPE)-1) >> ((sizeof(MASKSET_READTYPE) * CHAR_BIT)-(length)) )
/* the mast in the dword shifted to the left to overlap the field in the word */
#define MASK_MASK(n,length)   (MASK_TOP_MASK(length) << (((n)*(length)) & (sizeof(MASKSET_READTYPE) - 1) ) )
// masks value with the mask size, then applies that mask back to the correct word indexing
#define MASK_MASK_VAL(n,length,val)   (MASK_TOP_MASK_VAL(length,val) << (((n)*(length))&(sizeof(MASKSET_READTYPE) - 1)) )
/* declare a mask set.
 MASKSET( maskVariableName
        , 32 //number of items
		  , 5 // number of bits per field
		  );
   declares
	uint8_t maskVariableName[ (32*5 +(CHAR_BIT-1))/CHAR_BIT ];  //data array used for storage.
   const int askVariableName_mask_size = 5;  // used aautomatically by macros
*/
#define MASKSET(v,n,r)  MASKSETTYPE  (v)[(((n)*(r))+MASK_MAX_ROUND())/MASKTYPEBITS(MASKSETTYPE)]; const int v##_mask_size = r
#define MASKSET_(v,n,r)  MASKSETTYPE  (v)[(((n)*(r))+MASK_MAX_ROUND())/MASKTYPEBITS(MASKSETTYPE)]
/* set a field index to a value
    SETMASK( askVariableName, 3, 13 );  // set set member 3 to the value '13'
 */
#define SETMASK(v,n,val)    (((MASKSET_READTYPE*)((v)+((n)*(v##_mask_size))/MASKTYPEBITS((v)[0])))[0] =    ( ((MASKSET_READTYPE*)((v)+((n)*(v##_mask_size))/MASKTYPEBITS(uint8_t)))[0]                                  & (~(MASK_MASK(n,v##_mask_size))) )	                                                                           | MASK_MASK_VAL(n,v##_mask_size,val) )
#define SETMASK_(v,v2,n,val)    (((MASKSET_READTYPE*)((v)+((n)*(v2##_mask_size))/MASKTYPEBITS((v)[0])))[0] =    ( ((MASKSET_READTYPE*)((v)+((n)*(v2##_mask_size))/MASKTYPEBITS(uint8_t)))[0]                                  & (~(MASK_MASK(n,v2##_mask_size))) )	                                                                           | MASK_MASK_VAL(n,v2##_mask_size,val) )
/* get the value of a field
     GETMASK( maskVariableName, 3 );   // returns '13' given the SETMASK() example code.
 */
#define GETMASK(v,n)  ( ( ((MASKSET_READTYPE*)((v)+((n)*(v##_mask_size))/MASKTYPEBITS((v)[0])))[0]         & MASK_MASK(n,v##_mask_size) )	                                                                           >> (((n)*(v##_mask_size))&(sizeof(MASKSET_READTYPE) - 1)))
#define GETMASK_(v,v2,n)  ( ( ((MASKSET_READTYPE*)((v)+((n)*(v2##_mask_size))/MASKTYPEBITS((v)[0])))[0]         & MASK_MASK(n,v2##_mask_size) )	                                                                           >> (((n)*(v2##_mask_size))&(sizeof(MASKSET_READTYPE) - 1)))
/* This type stores data, it has a self-contained length in
   bytes of the data stored.  Length is in characters       */
_CONTAINER_NAMESPACE
/* LIST is a slab array of pointers, each pointer may be
	assigned to point to any user data.
	Remarks
	When the list is filled to the capacity of Cnt elements, the
	list is reallocated to be larger.
	Cannot add NULL pointer to list, empty elements in the list
	are represented with NULL, and may be filled by any non-NULL
	value.                                                       */
	_LINKLIST_NAMESPACE
	/* <combine sack::containers::list::LinkBlock>
		\ \                                         */
	typedef struct LinkBlock
{
	/* How many pointers the list can contain now. */
	INDEX     Cnt;
	/* \ \  */
	POINTER pNode[1];
} LIST;
typedef struct LinkBlock volatile* volatile PLIST;
_LINKLIST_NAMESPACE_END
#ifdef __cplusplus
using namespace sack::containers::list;
#endif
_DATALIST_NAMESPACE
/* a list of data structures... a slab array of N members of X size */
typedef struct DataBlock  DATALIST;
/* A typedef of a pointer to a DATALIST struct DataList. */
typedef struct DataBlock volatile * volatile PDATALIST;
/* Data Blocks are like LinkBlocks, and store blocks of data in
   slab format. If the count of elements exceeds available, the
   structure is grown, to always contain a continuous array of
   structures of Size size. No locking is provided.
   Remarks
   When blocks are deleted, all subsequent blocks are shifted
   down in the array. So the free blocks are always at the end. */
struct DataBlock
{
	/* How many elements are used. */
	INDEX     Cnt;
	/* How many elements are available in his array. */
	INDEX     Avail;
	/* A simple exchange lock on the data for insert and delete. For
	   thread safety.                                                */
	//volatile uint32_t     Lock;
	/* How big each element of the array is. */
	INDEX     Size;
	/* The physical array. */
	uint8_t      data[1];
};
_DATALIST_NAMESPACE_END
/* This is a stack that contains pointers to user objects.
	Remarks
	This is a stack 'by reference'. When extended, the stack will
	occupy different memory, care must be taken to not duplicate
	pointers to this stack.                                       */
	typedef struct LinkStack
{
	/* This is the index of the next pointer to be pushed or popped.
		If top == 0, the stack is empty, until a pointer is added and
		top is incremented.                                           */
	INDEX     Top;
	/* How many pointers the stack can contain. */
	INDEX     Cnt;
	/* thread interlock using InterlockedExchange semaphore. For
							thread safety.                                            */
							//volatile uint32_t     Lock;
							/*  a defined maximum capacity of stacked values... values beyond this are lost from the bottom  */
	uint32_t     Max;
	/* Reserved data portion that stores the pointers. */
	POINTER pNode[1];
} LINKSTACK;
typedef struct LinkStack volatile* volatile PLINKSTACK;
/* A Stack that stores information in an array of structures of
   known size.
   Remarks
   The size of each element must be known at stack creation
   time. Structures are literally copied to and from this stack.
   This is a stack 'by value'. When extended, the stack will
   occupy different memory, care must be taken to not duplicate
   pointers to this stack.                                       */
typedef struct DataListStack
{
	volatile INDEX     Top;
 /* enable logging the program executable (probably the same for
						 all messages, unless they are network)
																										  */
 // How many elements are on the stack.
	INDEX     Cnt;
	//volatile uint32_t     Lock;  /* thread interlock using InterlockedExchange semaphore. For
	//                  thread safety.                                            */
	INDEX     Size;
	INDEX     Max;
	uint8_t      data[1];
} DATASTACK;
typedef struct DataListStack volatile* volatile PDATASTACK;
/* A queue which contains pointers to user objects. If the queue
   is filled to capacity and new queue is allocated, and all
   existing pointers are transferred.                            */
typedef struct LinkQueue
{
	/* This is the index of the next pointer to be added to the
		queue. If Top==Bottom, then the queue is empty, until a
		pointer is added to the queue, and Top is incremented.   */
	volatile INDEX     Top;
	/* This is the index of the next element to leave the queue. */
	volatile INDEX     Bottom;
	/* This is the current count of pointers that can be stored in
		the queue.                                                  */
	INDEX     Cnt;
	/* thread interlock using InterlockedExchange semaphore. For
		thread safety.                                            */
#if USE_CUSTOM_ALLOCER
	volatile uint32_t     Lock;
#endif
 // need two to have distinct empty/full conditions
	POINTER pNode[2];
} LINKQUEUE;
typedef struct LinkQueue volatile* volatile PLINKQUEUE;
/* A queue of structure elements.
   Remarks
   The size of each element must be known at stack creation
   time. Structures are literally copied to and from this stack.
   This is a stack 'by value'. When extended, the stack will
   occupy different memory, care must be taken to not duplicate
   pointers to this stack.                                       */
typedef struct DataQueue
{
	/* This is the next index to be added to. If Top==Bottom, the
		queue is empty, until an entry is added at Top, and Top
		increments.                                                */
	volatile INDEX     Top;
	/* The current bottom index. This is the next one to be
		returned.                                            */
	volatile INDEX     Bottom;
	/* How many elements the queue can hold. If a queue has more
		elements added to it than it has count, it will be expanded,
		and a new queue returned.                                    */
	INDEX     Cnt;
	/* thread interlock using InterlockedExchange semaphore */
	//volatile uint32_t     Lock;
	/* How big each element in the queue is. */
	INDEX     Size;
	/* How many elements to expand the queue by, when its capacity
		is reached.                                                 */
	INDEX     ExpandBy;
	/* The data area of the queue. */
	uint8_t      data[1];
} DATAQUEUE;
typedef struct DataQueue volatile* volatile PDATAQUEUE;
/* A mostly obsolete function, but can return the status of
   whether all initially scheduled startups are completed. (Or
   maybe whether we are not complete, and are processing
   startups)                                                   */
_CONTAINER_NAMESPACE_END
#ifdef __cplusplus
 //SACK_NAMESPACE_END // namespace sack {
}
#endif
/* This contains the methods to use the base container types
   defined in sack_types.h.                                  */
#ifndef LINKSTUFF
#define LINKSTUFF
#  define TYPELIB_CALLTYPE
#  if defined( _TYPELIBRARY_SOURCE_STEAL )
#    define TYPELIB_PROC extern
#  elif defined( NO_EXPORTS )
#    if defined( _TYPELIBRARY_SOURCE )
#      define TYPELIB_PROC
#    else
#      define TYPELIB_PROC extern
#    endif
#  elif defined( _TYPELIBRARY_SOURCE )
#    define TYPELIB_PROC EXPORT_METHOD
#  else
#    define TYPELIB_PROC IMPORT_METHOD
#  endif
#  ifdef __cplusplus
	namespace sack {
   /* Containers is a bunch of common types like lists, queues,
      stacks.                                                   */
	   namespace containers {
#  endif
#  ifdef __cplusplus
/* virtual file system using file system IO instead of memory mapped IO */
namespace list {
#  endif
//--------------------------------------------------------
TYPELIB_PROC  PLIST TYPELIB_CALLTYPE        CreateListEx   ( DBG_VOIDPASS );
TYPELIB_PROC  void TYPELIB_CALLTYPE        MakeListEx   ( PLIST *pList DBG_PASS );
/* Destroy a PLIST. */
TYPELIB_PROC  void TYPELIB_CALLTYPE        DeleteListEx   ( PLIST *plist DBG_PASS );
/* See <link AddLink>.
   See <link DBG_PASS>. */
TYPELIB_PROC  void TYPELIB_CALLTYPE        AddLinkEx      ( PLIST *pList, POINTER p DBG_PASS );
/* Sets the value of a link at the specified index.
   Parameters
   pList :     address of a PLIST
   idx :       index of the element to set
   p :         new link value to be set at the specified index
   DBG_PASS :  debug file and line information                 */
TYPELIB_PROC  void TYPELIB_CALLTYPE        SetLinkEx      ( PLIST *pList, INDEX idx, POINTER p DBG_PASS );
/* Gets the link at the specified index.
   Parameters
   pList :  address of a PLIST pointer.
   idx :    index to get the link from.  */
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      GetLink        ( PLIST *pList, INDEX idx );
/* Gets the address of the link node in the PLIST.
   Parameters
   pList :  address of a PLIST to get the node address
   idx :    index of the node to get the adddress of
   Example
   <code lang="c++">
   PLIST list = NULL; // don't have to use CreateList();
   POINTER *a;
   POINTER b;
   POINTER *result;
   a = &amp;b;
   AddLink( &amp;list, a );
   \result = GetLinkAddress( &amp;list, 0 );
    ( (*result) == b )
   </code>                                               */
TYPELIB_PROC  POINTER* TYPELIB_CALLTYPE     GetLinkAddress ( PLIST *pList, INDEX idx );
/* Locate a pointer in a PLIST. Return the index.
   Parameters
   pList :  address of a list pointer to locate link
   value :  link to find in the list
   Return Value List
   INVALID_INDEX :  Not found in the list
   0\-n :           Index of the first occurance of the link in the
                    list.                                           */
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE        FindLink       ( PLIST *pList, POINTER value );
/* return the count of used members in a PLIST
    pList : the list to count
	Return Value
	   number of things in the list.
*/
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE        GetLinkCount   ( PLIST pList );
#define GetLinkCount(l) GetLinksUsed(&(l))
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE        GetLinksUsed( PLIST *pList );
/* Uses FindLink on the list for the value to delete, and then
   sets the index of the found link to NULL.
   Parameters
   pList :  Address of a PLIST pointer
   value :  the link to find and remove from the list.
   Example
   <code lang="c++">
   PLIST list = NULL;
	POINTER a = &#47;*some address*&#47;;
   </code>
   <code>
   AddLink( &amp;list, a );
   DeleteLink( &amp;list, a );
   </code>                                                     */
TYPELIB_PROC  LOGICAL TYPELIB_CALLTYPE      DeleteLink     ( PLIST *pList, CPOINTER value );
/* Remove all links from a PLIST. */
TYPELIB_PROC  void TYPELIB_CALLTYPE         EmptyList      ( PLIST *pList );
#ifdef __cplusplus
/* This was a basic attempt to make list into a C++ class. I
   gave up doing this sort of thing afterwards after realizing
   the methods of a library and these static methods for a class
   aren't much different.                                        */
#  if defined( INCLUDE_SAMPLE_CPLUSPLUS_WRAPPERS )
typedef class iList
{
public:
	volatile PLIST list;
	INDEX idx;
	inline iList() { list = CreateListEx( DBG_VOIDSRC ); }
	inline ~iList() { DeleteListEx( &list DBG_SRC ); }
	inline iList &operator+=( POINTER &p ){ AddLinkEx( &list, p DBG_SRC ); return *this; }
	inline void add( POINTER p ) { AddLinkEx( &list, p DBG_SRC ); }
	inline void remove( POINTER p ) { DeleteLink( &list, p ); }
	inline POINTER first( void ) { POINTER p; for( idx = 0, p = NULL;list && (idx < list->Cnt) && (( p = GetLink( &list, idx ) )==0); )idx++; return p; }
	inline POINTER next( void ) { POINTER p; for( idx++;list && (( p = GetLink( &list, idx ) )==0) && idx < list->Cnt; )idx++; return p; }
	inline POINTER get(INDEX index) { return GetLink( &list, index ); }
} *piList;
#  endif
#endif
// address of the thing...
typedef uintptr_t (CPROC *ForProc)( uintptr_t user, INDEX idx, POINTER *item );
// if the callback function returns non 0 - then the looping is aborted,
// and the value is returned... the user value is passed to the callback.
TYPELIB_PROC  uintptr_t TYPELIB_CALLTYPE     ForAllLinks    ( PLIST *pList, ForProc func, uintptr_t user );
/* This is a iterator which can be used to check each member in
   a PLIST.
   Parameters
   list :     List to iterate through
   index :    variable to use to index the list
   type :     type of the elements stored in the list (for C++)
   pointer :  variable used to get the current member of the
              list.
   Example
   <code lang="c++">
   POINTER p;  // the pointer to receive the list member pointer (should be a user type)
   INDEX idx; // indexer
   PLIST pList; // some list.
   LIST_FORALL( pList, idx, POINTER, p )
   {
       // p will never be NULL here.
       // each link stored in the list is set to p here..
       // this is a way to remove this item from the list...
       SetLink( &amp;pList, idx, NULL );
       if( some condition )
          break;
   }
   </code>
   Another example that uses data and searches..
   <code lang="c++">
   PLIST pList = NULL;
   INDEX idx;
   CTEXTSTR string;
   AddLink( &amp;pList, (POINTER)"hello" );
   </code>
   <code>
   AddLink( &amp;pList, (POINTER)"world" );
   LITS_FORALL( pList, idx, CTEXTSTR, string )
   {
       if( strcmp( string, "hello" ) == 0 )
           break;
   }
   // here 'string' will be NULL if not found, else will be what was found
   </code>
   Remarks
   This initializes the parameters passed to the macro so that
   if the list is NULL or empty, then p will be set to NULL. If
   there are no non-nulll members in the list, p will be set to
   NULL. If you break in the loop, like in the case of searching
   the list for something, then p will be non-null at the end of
   the loop.
                                                                                         */
#define LIST_FORALL( l, i, t, v )  if(((i)=0),((v)=(t)(uintptr_t)NULL),(l))                                                        for( ; ((i) < ((l)->Cnt))?                                         (((v)=(t)(uintptr_t)((l)->pNode[i])),1):(((v)=(t)(uintptr_t)NULL),0); (i)++ )  if( v )
/* This can be used to continue iterating through a list after a
   LIST_FORALL has been interrupted.
   Parameters
   list :     \Description
   index :    index variable for stepping through the list
   type :     type of the members in the list.
   pointer :  variable name to use to store the the current list
              element.
   Example
   <code lang="c++">
   PLIST pList = NULL;
   CTEXTSTR p;
   INDEX idx;
   </code>
   <code>
   AddLink( &amp;pList, "this" );
   AddLink( &amp;pList, "is" );
   AddLink( &amp;pList, "a" );
   AddLink( &amp;pList, "test" );
   LIST_FORALL( pList, idx, CTEXTSTR, p )
   {
       if( strcmp( p, "is" ) == 0 )
           break;
   }
   LIST_NEXTALL( pList, idx, CTEXTSTR, p )
   {
       printf( "remaining element : %s", p );
   }
   </code>
   <code lang="c++">
   j
   </code>                                                       */
#define LIST_NEXTALL( l, i, t, v )  if(l)                for( ++(i),((v)=(t)NULL); ((i) < ((l)->Cnt))?     (((v)=(t)(l)->pNode[i]),1):(((v)=(t)NULL),0); (i)++ )  if( v )
/* <combine sack::containers::list::CreateListEx@DBG_VOIDPASS>
   \ \                                                         */
#define CreateList()       ( CreateListEx( DBG_VOIDSRC ) )
/* <combine sack::containers::list::DeleteListEx@PLIST *plist>
   \ \                                                         */
#ifndef FIX_RELEASE_COM_COLLISION
#  define DeleteList(p)      ( DeleteListEx( (p) DBG_SRC ) )
#endif
/* Adds a pointer to a user object to a list.
   Example
   <code lang="c++">
   // the list can be initialized to NULL,
   // it does not have to be assigned the result of a CreateList().
   // this allows the list to only be allocated if it is used.
   PLIST list = NULL;
   AddLink( &amp;list, (POINTER)user_pointer );
   {
       POINTER p; // this should be USER_DATA_TYPE *p;
       INDEX idx; // just a generic counter.
       LIST_FORALL( list, idx, POINTER, p )
       {
           // for each item in the list, p will be not null.
           if( p-\>something == some_other_thing )
               break;
       }
       // p will be NULL if the list is empty
       // p will be NULL if the LIST_FORALL loop completes to termination.
       // p will be not NULL if the LIST_FORALL loop executed a 'break;'
   }
   </code>                                                                 */
#define AddLink(p,v)       ( AddLinkEx( (p),((POINTER)(v)) DBG_SRC ) )
/* <combine sack::containers::list::SetLinkEx@PLIST *@INDEX@POINTER p>
   \ \                                                                 */
#define SetLink(p,i,v)     ( SetLinkEx( (p),(i),((POINTER)(v)) DBG_SRC ) )
#ifdef __cplusplus
 //		namespace list;
	}
#endif
//--------------------------------------------------------
#ifdef __cplusplus
/* A type of dynamic array that contains the data of the elements and not just pointers like PLIST. Has no locks builtin. */
namespace data_list {
#endif
/* Creates a data list which hold data elements of the specified
   size.
                                                                 */
TYPELIB_PROC  PDATALIST TYPELIB_CALLTYPE  CreateDataListEx ( uintptr_t nSize DBG_PASS );
/* <combine sack::containers::data_list::DeleteDataList>
   \ \                                                   */
TYPELIB_PROC  void TYPELIB_CALLTYPE       DeleteDataListEx ( PDATALIST *ppdl DBG_PASS );
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE    SetDataItemEx ( PDATALIST *ppdl, INDEX idx, POINTER data DBG_PASS );
/* Adds an item to a DataList.
   Example
   <code lang="c++">
   PDATALIST datalist = CreateDataList();
   struct my_struct {
       uint32_t my_data;
   }
   struct my_struct my_item;
   my_item.my_data = 0;
   AddDataItem( &amp;datalist, &amp;my_item );
   </code>                                     */
#define AddDataItem(list,data) (((list)&&(*(list)))?SetDataItemEx((list),(*list)->Cnt,data DBG_SRC ):NULL)
/* Sets the item at a specific nodes to the new data.
   Parameters
   ppdl :      address of a PDATALIST.
   idx :       index of element in list to set
   data :      POINTER to data to set element to
   DBG_PASS :  optional debug file/line information
   Example
   <code lang="c++">
      PDATALIST pdl;
      int oldval = 3;
      int newval = 5;
      pdl = CreateDataList( sizeof( int ) ); // store int's as data
      AddDataItem( &amp;pdl, &amp;oldval );
      SetDataItem( &amp;pdl, 0, &amp;newval );
   </code>                                                          */
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE    SetDataItemEx ( PDATALIST *ppdl, INDEX idx, POINTER data DBG_PASS );
/* \Returns a pointer to the data at a specified index.
   Parameters
   \    ppdl :  address of a PDATALIST
   idx :   index of element to get                      */
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE    GetDataItem ( PDATALIST *ppdl, INDEX idx );
/* Removes a data element from the list (moves all other
   elements down over it since there is no used indicator.
   Parameters
   ppdl :  address of a PDATALIST.
   idx :   index of element to delete                      */
TYPELIB_PROC  void TYPELIB_CALLTYPE       DeleteDataItem ( PDATALIST *ppdl, INDEX idx );
/* Empties a PDATALIST of all content.
   Parameters
   ppdl :  address of a PDATALIST
   Example
   <code lang="c++">
   PDATALIST pdl;
   pdl = CreateDataList( sizeof( int ) ); // store int's as data
   EmptyDataList( &amp;pdl );
   </code>                                                       */
TYPELIB_PROC  void TYPELIB_CALLTYPE       EmptyDataList ( PDATALIST *ppdl );
/* For loop to iterate through all items in a PDATALIST.
   <code lang="c++">
   PDATALIST pdl;
   pdl = CreateDataList( sizeof( int ) );
   {
      INDEX index;
      int *value;
      DATA_FORALL( pdl, index, int, value )
      {
      }
   }
   </code>                                               */
#define DATA_FORALL( l, i, t, v )  if(((i)=0),((v)=(t)NULL),(l)&&((l)->Cnt != INVALID_INDEX))	   for( ;	                                               (((i) < (l)->Cnt)                                             ?(((v)=(t)((l)->data + (uintptr_t)(((l)->Size) * (i)))),1)	         :(((v)=(t)NULL),0))&&(v); (i)++ )
/* <code>
   PDATALIST pdl;
   pdl = CreateDataList( sizeof( int ) );
   {
      INDEX index;
      int *value;
      DATA_FORALL( pdl, index, int, value )
      {
          // abort loop early
      }
      DATA_NEXTALL( pdl, index, int, value )
      {
      }
   }
   </code>                                   */
#define DATA_NEXTALL( l, i, t, v )  if(((v)=(t)NULL),(l))	   for( ((i)++);	                         ((i) < (l)->Cnt)                                             ?(((v)=(t)((l)->data + (((l)->Size) * (i)))),1)	         :(((v)=(t)NULL),0); (i)++ )
/* <combine sack::containers::data_list::CreateDataListEx@uintptr_t nSize>
   Creates a DataList specifying just the size. Uses the current
   source and line for debugging parameter.                               */
#define CreateDataList(sz) ( CreateDataListEx( (sz) DBG_SRC ) )
/* Destroy a DataList.
   Example
   <code>
   PDATALIST datalist = CreateDataList( 4 );
   DeleteDataList( &amp;datalist );
   </code>
   Parameters
   ppDataList :  pointer to the PDATALIST.   */
#define DeleteDataList(p)  ( DeleteDataListEx( (p) DBG_SRC ) )
/* <combine sack::containers::data_list::SetDataItemEx@PDATALIST *@INDEX@POINTER data>
   \ \                                                                                 */
#define SetDataItem(p,i,v) ( SetDataItemEx( (p),(i),(v) DBG_SRC ) )
   _DATALIST_NAMESPACE_END
//--------------------------------------------------------
#ifdef __cplusplus
		namespace link_stack {
#endif
/* Creates a new stack for links (POINTERS).
   Parameters
   DBG_PASS :  Debug file and line information to use for the
               allocation of the stack.
   Returns
   Pointer to a new link stack.                               */
TYPELIB_PROC  PLINKSTACK TYPELIB_CALLTYPE   CreateLinkStackEx( DBG_VOIDPASS );
/* Creates a new stack for links (POINTERS).  Link stack has a limited number of entries.
    When the stack fills, the oldest item on the stack is removed automatically.
	 Parameters
	 max_entries : maximum depth of the stack.
   DBG_PASS :  Debug file and line information to use for the
               allocation of the stack.
   Returns
   Pointer to a new link stack.                               */
         // creates a link stack with maximum entries - any extra entries are pushed off the bottom into NULL
TYPELIB_PROC  PLINKSTACK TYPELIB_CALLTYPE      CreateLinkStackLimitedEx        ( int max_entries  DBG_PASS );
/* <combine sack::containers::link_stack::CreateLinkStackLimitedEx@int max_entries>
   Macro to pass default debug file and line information.                           */
#define CreateLinkStackLimited(n) CreateLinkStackLimitedEx(n DBG_SRC)
/* Destroy a link stack. Sets the pointer to the stack to NULL
   on deletion.
   Parameters
   pls :       address of a link stack pointer
   DBG_PASS :  debug file and line information                 */
TYPELIB_PROC  void TYPELIB_CALLTYPE         DeleteLinkStackEx( PLINKSTACK *pls DBG_PASS);
/* Pushes a new link on the stack.
   Parameters
   pls :       address of a link stack pointer
   p :         new pointer to push on the stack
   DBG_PASS :  debug source file and line information.
   Returns
   New link stack pointer if the stack was reallocated to have
   more space. Since the address of the pointer is passed, the
   pointer is already updated, and the return value is
   unimportant.                                                */
TYPELIB_PROC  void TYPELIB_CALLTYPE   PushLinkEx       ( PLINKSTACK *pls, POINTER p DBG_PASS);
/* Reads the top value of the stack and returns it, removes top
   link on the stack.
   Parameters
   pls :  address of a link stack pointer
   Return Value List
   NULL :      Stack was empty
   not NULL :  Link that was on the top of the stack.           */
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      PopLink          ( PLINKSTACK *pls );
/* Look at the top link on the stack.
   Parameters
   pls :  address of a link stack pointer
   Return Value List
   NULL :      Nothing on stack.
   not NULL :  link on the top of the stack. */
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      PeekLink         ( PLINKSTACK *pls );
/* Look at links in the stack.
   Parameters
	pls :  address of a link stack pointer
	n : index of the element from the top to look at
   Return Value List
   NULL :      Nothing on stack at the position specified.
   not NULL :  link on the top of the stack. */
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      PeekLinkEx         ( PLINKSTACK *pls, INDEX n );
// thought about adding these, but decided on creating a limited stack instead.
//TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      StackLength      ( PLINKSTACK *pls );
//TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      PopLinkEx        ( PLINKSTACK *pls, int position );
/* <combine sack::containers::link_stack::CreateLinkStackEx@DBG_VOIDPASS>
   Macro to pass default file and line information.                       */
#define CreateLinkStack()  CreateLinkStackEx( DBG_VOIDSRC )
/* <combine sack::containers::link_stack::DeleteLinkStackEx@PLINKSTACK *pls>
   Macro to pass default file and line information.                          */
#define DeleteLinkStack(p) DeleteLinkStackEx((p) DBG_SRC)
/* <combine sack::containers::link_stack::PushLinkEx@PLINKSTACK *@POINTER p>
   Macro to pass default debug file and line information.                    */
#define PushLink(p, v)     PushLinkEx((p),(v) DBG_SRC)
#ifdef __cplusplus
 //		namespace link_stack {
		}
#endif
//--------------------------------------------------------
#ifdef __cplusplus
		namespace data_stack {
#endif
/* Creates a data stack for data element of the specified size.
   Parameters
   size :       size of elements in the stack
   DBG_PASS :  debug file and line information.                 */
TYPELIB_PROC  void TYPELIB_CALLTYPE   MakeDataStackEx( PDATASTACK *pds, size_t size DBG_PASS );
/* Creates a data stack for data element of the specified size.
   Parameters
   size :       size of elements in the stack
   DBG_PASS :  debug file and line information.                 */
TYPELIB_PROC  PDATASTACK TYPELIB_CALLTYPE   CreateDataStackEx( size_t size DBG_PASS );
/* Creates a data stack for data element of the specified size.
   Parameters
   size :       size of items in the stack
   count :      max items in stack (oldest gets deleted)
   DBG_PASS :  debug file and line information.                 */
TYPELIB_PROC  void TYPELIB_CALLTYPE   MakeDataStackLimitedEx( PDATASTACK *pds, size_t size, INDEX count DBG_PASS );
/* Creates a data stack for data element of the specified size.
   Parameters
   size :       size of items in the stack
   count :      max items in stack (oldest gets deleted)
   DBG_PASS :  debug file and line information.                 */
TYPELIB_PROC PDATASTACK TYPELIB_CALLTYPE CreateDataStackLimitedEx( size_t size, INDEX count DBG_PASS );
/* Destroys a data stack.
   Parameters
   pds :       address of a data stack pointer. The pointer will
               be set to NULL when the queue is destroyed.
   DBG_PASS :  Debug file and line information.                  */
TYPELIB_PROC  void TYPELIB_CALLTYPE         DeleteDataStackEx( PDATASTACK *pds DBG_PASS);
/* Push a data element onto the stack. The size of the element
   is known at the stack creation time.
   Parameters
   pds :       address of a data stack pointer
   p :         pointer to data to push on stack
   DBG_PASS :  debug file and line information                 */
TYPELIB_PROC void TYPELIB_CALLTYPE PushDataEx( PDATASTACK *pds, POINTER pdata DBG_PASS );
/* \Returns an allocated buffer containing the data on the
   stack. Removes item from the stack.
   Parameters
   pds :  address of a data stack to get data from         */
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      PopData        ( PDATASTACK *pds );
/* Clear all data stored in the stack.
   Parameters
   pds :  address of a data stack pointer. */
TYPELIB_PROC  void TYPELIB_CALLTYPE         EmptyDataStack ( PDATASTACK *pds );
/* Look at top item in the stack without removing it.
   Parameters
   pds :  address of a data stack to look at          */
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      PeekData       ( PDATASTACK *pds );
// Incrementing Item moves progressivly down the stack
// final(invalid) stack, and/or empty stack will return NULL;
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      PeekDataEx     ( PDATASTACK *pds, INDEX Item );
 /* keeps data on stack (can be used)
                                                                                      Parameters
                                                                                      pds :   address of a data stack pointer
                                                                                      Item :  Item to peek at; 0 is the top, 1 is just below it...
                                                                                              (maybe \-1 is last and further up)
                                                                                      Returns
                                                                                      \returns the address of the data item in the data stack.     */
/* <combine sack::containers::data_stack::CreateDataStackEx@INDEX size>
   Macro to pass default file and line information.                     */
#define CreateDataStack(size) CreateDataStackEx( size DBG_SRC )
/* <combine sack::containers::data_stack::CreateDataStackEx@INDEX size>
   Macro to pass default file and line information.                     */
#define CreateDataStackLimited(size,items) CreateDataStackLimitedEx( size,items DBG_SRC )
/* <combine sack::containers::data_stack::DeleteDataStackEx@PDATASTACK *pds>
   Macro to pass default file and line information.                          */
#define DeleteDataStack(p) DeleteDataStackEx((p) DBG_SRC)
/* <combine sack::containers::data_stack::PushDataEx@PDATASTACK *@POINTER pdata>
   Macro to pass default file and line information.                              */
#define PushData(pds,p) PushDataEx(pds,p DBG_SRC )
#ifdef __cplusplus
 //		namespace data_stack {
		}
#endif
/* Queue container - can enque (at tail) deque (from head) and preque (at head). Can also browse the queue with peekqueue. */
#ifdef __cplusplus
		namespace queue {
#endif
/* Creates a <link sack::containers::PLINKQUEUE, LinkQueue>. In
   debug mode, gets passed the current source and file so it can
   blame the user for the allocation.                            */
TYPELIB_PROC  void TYPELIB_CALLTYPE   MakeLinkQueueEx( PLINKQUEUE *into DBG_PASS );
/* Creates a <link sack::containers::PLINKQUEUE, LinkQueue>. In
   debug mode, gets passed the current source and file so it can
   blame the user for the allocation.                            */
TYPELIB_PROC  PLINKQUEUE TYPELIB_CALLTYPE   CreateLinkQueueEx( DBG_VOIDPASS );
/* Delete a link queue. Pass the address of the pointer to the
   queue to delete, this function sets the pointer to NULL if
   the queue is actually deleted.                              */
TYPELIB_PROC  void TYPELIB_CALLTYPE         DeleteLinkQueueEx( PLINKQUEUE *pplq DBG_PASS );
/* Enque a link to the queue.  */
TYPELIB_PROC  void TYPELIB_CALLTYPE   EnqueLinkEx      ( PLINKQUEUE *pplq, POINTER link DBG_PASS );
TYPELIB_PROC  void TYPELIB_CALLTYPE   EnqueLinkNLEx( PLINKQUEUE *pplq, POINTER link DBG_PASS );
/* EnqueLink adds the new item at the end of the list. PrequeueLink
   puts the new item at the head of the queue (so it's the next
   one to be retrieved).                                            */
TYPELIB_PROC void TYPELIB_CALLTYPE PrequeLinkEx( PLINKQUEUE *pplq, POINTER link DBG_PASS );
/* If the queue is not empty, returns the address of the next
   element in the queue and removes the element from the queue.
                                                                */
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      DequeLink        ( PLINKQUEUE *pplq );
TYPELIB_PROC POINTER  TYPELIB_CALLTYPE      DequeLinkNL      ( PLINKQUEUE *pplq );
/* Return TRUE/FALSE if the queue is empty or not. */
TYPELIB_PROC  LOGICAL TYPELIB_CALLTYPE      IsQueueEmpty     ( PLINKQUEUE *pplq );
/* Gets the number of elements current in the queue. */
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE        GetQueueLength   ( PLINKQUEUE plq );
// get a PLINKQUEUE element at index
//  If idx < 0 then count from the end of the queue, otherwise count from the start of the queue
// start of the queue is the next element to be dequeue, end of the queue is the last element added to the queue.
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      PeekQueueEx    ( PLINKQUEUE plq, int idx );
/* Can be used to look at the next element in the queue without
   removing it from the queue. PeekQueueEx allows you to specify
   an index of an item in the queue to get.                      */
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE      PeekQueue    ( PLINKQUEUE plq );
/* <combinewith sack::containers::queue::CreateLinkQueueEx@DBG_VOIDPASS>
   \ \                                                                   */
#define     CreateLinkQueue()     CreateLinkQueueEx( DBG_VOIDSRC )
/* <combine sack::containers::queue::PrequeLinkEx@PLINKQUEUE *@POINTER link>
   \ \                                                                       */
#define     PrequeLink(pplq,link) PrequeLinkEx( pplq, link DBG_SRC )
/* <combine sack::containers::queue::DeleteLinkQueueEx@PLINKQUEUE *pplq>
   \ \                                                                   */
#define     DeleteLinkQueue(pplq) DeleteLinkQueueEx( pplq DBG_SRC )
/* <combine sack::containers::queue::EnqueLinkEx@PLINKQUEUE *@POINTER link>
   \ \                                                                      */
#define     EnqueLink(pplq, link) EnqueLinkEx( pplq, link DBG_SRC )
#define     EnqueLinkNL(pplq, link) EnqueLinkNLEx( pplq, link DBG_SRC )
#ifdef __cplusplus
//		namespace queue {
		}
#endif
/* Functions related to PDATAQUEUE container. DataQueue stores
   literal data elements in the list instead of just a pointer. (could
   be used for optimized vertex arrays for instance).
   int data = 3;
   int result;
   PDATAQUEUE pdq = CreateDataQueue( sizeof( int ) );
   EnqueData( &amp;pdq, &amp;data );
   DequeData( &amp;pdq, &amp;result );
   DestroyDataQueue( &amp;pdq );                                       */
#ifdef __cplusplus
		namespace data_queue {
#endif
/* Creates a PDATAQUEUE. Can pass DBG_FILELINE information to
   blame other code for the allocation.                       */
TYPELIB_PROC  void TYPELIB_CALLTYPE   MakeDataQueueEx( PDATAQUEUE *into, INDEX size DBG_PASS );
/* Creates a PDATAQUEUE. Can pass DBG_FILELINE information to
   blame other code for the allocation.                       */
TYPELIB_PROC  PDATAQUEUE TYPELIB_CALLTYPE   CreateDataQueueEx( INDEX size DBG_PASS );
/* Creates a PDATAQUEUE that has an overridden expand-by amount
   and initial amount of entries in the queue. (expecting
   something like 1000 to start and expand by 500, instead of
   the default 0, and expand by 1.                              */
TYPELIB_PROC void TYPELIB_CALLTYPE MakeLargeDataQueueEx( PDATAQUEUE *pdq, INDEX size, INDEX entries, INDEX expand DBG_PASS );
/* Creates a PDATAQUEUE that has an overridden expand-by amount
   and initial amount of entries in the queue. (expecting
   something like 1000 to start and expand by 500, instead of
   the default 0, and expand by 1.                              */
TYPELIB_PROC  PDATAQUEUE TYPELIB_CALLTYPE   CreateLargeDataQueueEx( INDEX size, INDEX entries, INDEX expand DBG_PASS );
/* Destroys a data queue. */
TYPELIB_PROC  void TYPELIB_CALLTYPE         DeleteDataQueueEx( PDATAQUEUE *pplq DBG_PASS );
/* Add a data element into the queue. */
TYPELIB_PROC  void TYPELIB_CALLTYPE   EnqueDataEx      ( PDATAQUEUE *pplq, POINTER Data DBG_PASS );
/* Enque data at the head of the queue instead of the tail. (Normally
   add at tail, take from head).                                      */
TYPELIB_PROC void TYPELIB_CALLTYPE PrequeDataEx( PDATAQUEUE *pplq, POINTER Data DBG_PASS );
/* Removes data from a queue, resulting with the data in the
   specified buffer, and result TRUE if there was an element
   else FALSE, and the buffer is not modified.               */
TYPELIB_PROC  LOGICAL TYPELIB_CALLTYPE      DequeData        ( PDATAQUEUE *pplq, POINTER Data );
/* Removes the last element in the queue. (takes from the tail). */
TYPELIB_PROC  LOGICAL TYPELIB_CALLTYPE      UnqueData        ( PDATAQUEUE *pplq, POINTER Data );
/* Checks if the queue is empty, result TRUE if nothing in it,
   else FALSE.                                                 */
TYPELIB_PROC  LOGICAL TYPELIB_CALLTYPE      IsDataQueueEmpty ( PDATAQUEUE *pplq );
/* Empty a dataqueue of all data. (Sets head=tail). */
TYPELIB_PROC  void TYPELIB_CALLTYPE         EmptyDataQueue ( PDATAQUEUE *pplq );
/* returns how many entries are in the queue. */
TYPELIB_PROC  INDEX   TYPELIB_CALLTYPE      GetDataQueueLength( PDATAQUEUE pdq );
/*
 * get a PDATAQUEUE element at index
 * result buffer is a pointer to the type of structure expected to be
 * stored within this.  The buffer result is a copy of the data stored in the queue.
 * This enforces that data stored in the list is immutable.
 * Also on the basic DequeData function, after resulting, if the pointer to the
 * data within the queue were returned, it could become invalid immediatly after
 * returning by having another enque happen which overwrites that position in the buffer.
 * One could, in theory, set a flag in the queue that a deque was done, and not update the
 * bottom until that flag is encountered while within DequeData again...
 * the pointer to the data in the queue may also not be returned because the queue may be
 * reallocated and moved.
 */
TYPELIB_PROC  LOGICAL TYPELIB_CALLTYPE  PeekDataQueueEx    ( PDATAQUEUE *pplq, POINTER ResultBuffer, INDEX idx );
#define PeekDataQueueEx( q, type, result, idx ) PeekDataQueueEx( q, (POINTER)result, idx )
/*
 * Result buffer is filled with the last element, and the result is true, otherwise the return
 * value is FALSE, and the data was not filled in.
 */
TYPELIB_PROC  LOGICAL TYPELIB_CALLTYPE  PeekDataQueue    ( PDATAQUEUE *pplq, POINTER ResultBuffer );
#define PeekDataQueue( q, type, result ) PeekDataQueueEx( q, type, result, 0 )
/*
 * gets the address a PDATAQUEUE element at index
 * result buffer is a pointer to the type of structure expected to be
 * stored within this.  Index from 0 to N indexes from first ( to be dequeued )
 * to last item in queue.
 */
TYPELIB_PROC POINTER TYPELIB_CALLTYPE  PeekDataInQueueEx    ( PDATAQUEUE *pplq, INDEX idx );
/*
 * Results with the first item in the queue, else NULL.
 */
TYPELIB_PROC POINTER TYPELIB_CALLTYPE  PeekDataInQueue    ( PDATAQUEUE *pplq );
/* <combine sack::containers::data_queue::CreateDataQueueEx@INDEX size>
   \ \                                                                  */
#define     CreateDataQueue(size)     CreateDataQueueEx( size DBG_SRC )
/* <combine sack::containers::data_queue::CreateLargeDataQueueEx@INDEX@INDEX@INDEX expand>
   \ \                                                                                     */
#define     CreateLargeDataQueue(size,entries)     CreateLargeDataQueueEx( size,entries, 0 DBG_SRC )
/* <combine sack::containers::data_queue::DeleteDataQueueEx@PDATAQUEUE *pplq>
   \ \                                                                        */
#define     DeleteDataQueue(pplq) DeleteDataQueueEx( pplq DBG_SRC )
/* <combine sack::containers::data_queue::EnqueDataEx@PDATAQUEUE *@POINTER Data>
   \ \                                                                           */
#define     EnqueData(pplq, Data) EnqueDataEx( pplq, Data DBG_SRC )
/* <combine sack::containers::data_queue::PrequeDataEx@PDATAQUEUE *@POINTER Data>
   \ \                                                                            */
#define     PrequeData(pplq, Data) PrequeDataEx( pplq, Data DBG_SRC )
#ifdef __cplusplus
//		namespace data_queue {
		}
#endif
//---------------------------------------------------------------------------
#ifdef __cplusplus
/* This is a rough emulation of SYSv IPC Message Queue objects.
*/
namespace message {
#endif
/* handle to a message queue. */
typedef struct MsgDataHandle *PMSGHANDLE;
//typedef struct MsgDataQueue *PMSGQUEUE;
// messages sent - the first dword of them must be
// a message ID.
typedef void (CPROC *MsgQueueReadCallback)( uintptr_t psv, CPOINTER p, uintptr_t sz );
/* Create a named shared memory message queue.
   Parameters
   name :     name of the queue to create
   size :     size of the queue.
   Read :     read callback, called when a message is received on
              the queue.
   psvRead :  user data associated with the queue. Passed to the
              read callback.                                      */
TYPELIB_PROC  PMSGHANDLE TYPELIB_CALLTYPE  SackCreateMsgQueue ( CTEXTSTR name, size_t size
                                                      , MsgQueueReadCallback Read
                                                      , uintptr_t psvRead );
/* Open a message queue. Opens if it exists, does not create.
   Parameters
   name :     name of the queue.
   Read :     read callback called when a message is received.
   psvRead :  user data associated with this queue, and passed to
              the read callback.                                  */
TYPELIB_PROC  PMSGHANDLE TYPELIB_CALLTYPE  SackOpenMsgQueue ( CTEXTSTR name
													 , MsgQueueReadCallback Read
													 , uintptr_t psvRead );
/* Destroys a message queue.
   Parameters
   ppmh :  address of the message queue handle to close (sets
           pointer to NULL when deleted)                      */
TYPELIB_PROC  void TYPELIB_CALLTYPE  DeleteMsgQueue ( PMSGHANDLE **ppmh );
 // if enque, fail send, return immediate on fail
#define MSGQUE_NOWAIT 0x0001
                             // if deque, fail no msg ready to get...
 // read any msg BUT MsgID
#define MSGQUE_EXCEPT 0x0002
 // enque this message... it is a task ID which is waiting.
#define MSGQUE_WAIT_ID 0x0004
/* Error result if there is no message to read. (GetLastError()
   after peekmsg or readmsg returns -1)                         */
#define MSGQUE_ERROR_NOMSG 1
/* Error result if the message to read is bigger than the buffer
   passed to read the message.                                   */
#define MSGQUE_ERROR_E2BIG 2
/* Error result. Unexpected error (queue head/tail out of
   bounds)                                                */
#define MSGQUE_ERROR_EABORT 5
// result is the size of the message, or 0 if no message.
// -1 if some other error?
TYPELIB_PROC  int TYPELIB_CALLTYPE  DequeMsgEx ( PMSGHANDLE pmh, long *MsgID, POINTER buffer, size_t msgsize, uint32_t options DBG_PASS );
/* Receives a message from the message queue.
   Parameters
   Message Queue :  PMSGHANDLE to read from
   Message ID * :   a Pointer to the message ID to read. Updated
                    with the message ID from the queue.
   buffer :         buffer to read message into
   buffer length :  length of the buffer to read
   options :        extra options for the read
   Return Value List
   \-1 :  Error
   0 :    No Message to read
   \>0 :  size of message read.
   Returns
   \ \                                                           */
#define DequeMsg(q,b,s,i,o) DequeMsgEx(q,b,s,i,o DBG_SRC )
/* <combine sack::containers::message::PeekMsg>
   \ \                                          */
TYPELIB_PROC  int TYPELIB_CALLTYPE  PeekMsgEx ( PMSGHANDLE pmh, long MsgID, POINTER buffer, size_t msgsize, uint32_t options DBG_PASS );
/* Just peek at the next message.
   Parameters
   queue :        The PMSGHANDLE queue to read.
   MsgID :        what message to read. 0 is read any message.
   buffer :       where to read the message data into.
   buffer_size :  the length of the message buffer.
   options :      Options controlling the read
   Returns
   \-1 on error
   0 if no message
   length of the message read                                  */
#define PeekMsg(q,b,s,i,o) PeekMsgEx(q,b,s,i,o DBG_SRC )
/* <combine sack::containers::message::EnqueMsg>
   \ \                                          */
TYPELIB_PROC  int TYPELIB_CALLTYPE  EnqueMsgEx ( PMSGHANDLE pmh, POINTER buffer, size_t msgsize, uint32_t options DBG_PASS );
/* Add a message to the queue.
   Parameters
   Message Queue :  PMSGQUEUE to write to.
   Buffer :         pointer to the message to send. THe MSgID is
                    the first part of the message buffer.
   Buffer Length :  how long the message to send is
   Options :        Extra options for send
   Return Value List
   \-1 :  Error
   \>0 :  bytes of message sent                                  */
#define EnqueMsg(q,b,s,o) EnqueMsgEx(q,b,s,o DBG_SRC )
/* Check if the message queue is empty.
   Parameters
   pmh :  queue to check if it's empty. */
TYPELIB_PROC  int TYPELIB_CALLTYPE  IsMsgQueueEmpty ( PMSGHANDLE pmh );
#ifdef __cplusplus
 //namespace message {
}
#endif
/* Routines to deal with SLAB allocated blocks of structures.
   Each slab has multiple elements of a type in it, and the
   blocks are tracked as a linked list. Each block also has a
   bitmask of allocated elements in the set.
   \---------------------------------------------------------------------------
   Set type
   Usage:
   typedef struct name_tag { } \<name\>;
   \#define MAX\<name\>SPERSET
   DeclareSet( \<name\> );
   Should alias GetFromset, DeleteFromSet, CountUsedInSet,
   GetLinearSetArray
   etc so that the type name is reflected there
   another good place where #define defining defines is good.
   \---------------------------------------------------------------------------
                                                                                */
_SETS_NAMESPACE
//---------------------------------------------------------------------------
// Set type
//   Usage:
//      typedef struct name_tag { } <name>;
//      #define MAX<name>SPERSET
//      DeclareSet( <name> );
//    Should alias GetFromset, DeleteFromSet, CountUsedInSet, GetLinearSetArray
//       etc so that the type name is reflected there
//       another good place where #define defining defines is good.
//---------------------------------------------------------------------------
/* Hard coded 32 bit division for getting word index. (x\>\>5) */
#define UNIT_USED_IDX(n)   ((n) >> 5)
/* Hard coded 32 bit division for getting bit index. (x &amp;
   0x1f)                                                      */
#define UNIT_USED_MASK(n)  (1 << ((n) &0x1f))
/* A macro for use by internal code that marks a member of a set
   as used.
   Parameters
   set :    pointer to a genericset
   index :  item to mark used.                                   */
#define SetUsed(set,n)   ((((set)->bUsed[UNIT_USED_IDX(n)]) |= UNIT_USED_MASK(n)), (++(set)->nUsed) )
/* A macro for use by internal code that marks a member of a set
   as available.
   Parameters
   set :    pointer to a genericset
   index :  item to mark available.                              */
#define ClearUsed(set,n) ((((set)->bUsed[UNIT_USED_IDX(n)]) &= ~UNIT_USED_MASK(n)), (--(set)->nUsed) )
/* A macro for use by internal code that tests a whole set of
   bits for used. (32 bits, can check to see if any in 32 is
   free)
   Parameters
   set :    pointer to a genericset
   index :  index of an one in the set of 32 being tested.
   Returns
   0 if not all are used.
   1 if all in this block of bits are used.                   */
#define AllUsed(set,n)   (((set)->bUsed[UNIT_USED_IDX(n)]) == 0xFFFFFFFF )
/* A macro for use by internal code that tests a member of a set
   as used.
   Parameters
   set :    pointer to a genericset
   index :  item to test used.
   Returns
   not zero if is used, otherwise is free.                       */
#define IsUsed(set,n)    (((set)->bUsed[UNIT_USED_IDX(n)]) & UNIT_USED_MASK(n) )
#ifdef __cplusplus
#define CPP_(n)
/* A macro which is used to emit code in C++ mode... */
#else
#define CPP_(n)
#endif
// requires a symbol of MAX<insert name>SPERSET to declare max size...
#define SizeOfSet(size,count)  (sizeof(POINTER)*2+sizeof(int)+sizeof( uint32_t[((count)+31)/32] ) + ((size)*(count)))
// declare a type that is a set; this type isn't used internally, but is used for
// some utility macros, and to get the size of memory to allocate a set block.
#define DeclareSet( name )  typedef struct name##set_tag {	   struct name##set_tag *next, *prior;	                      uint32_t nUsed;	                                               uint32_t nBias;	                                               uint32_t bUsed[(MAX##name##SPERSET + 31 ) / 32];	              name p[MAX##name##SPERSET];	                           CPP_(int forall(uintptr_t(CPROC*f)(void*,uintptr_t),uintptr_t psv) {if( this ) return _ForAllInSet( (struct genericset_tag*)this, sizeof(name), MAX##name##SPERSET, f, psv ); else return 0; })	 CPP_(name##set_tag() { next = NULL;prior = NULL;nUsed = 0; nBias = 0; MemSet( bUsed, 0, sizeof( bUsed ) ); MemSet( p, 0, sizeof( p ) );} )	} name##SET, *P##name##SET
// declare a set type that contains class elements; this type isn't used internally, but is used for
// some utility macros, and to get the size of memory to allocate a set block.
#define DeclareClassSet( name ) typedef struct name##set_tag {	   struct name##set_tag *next, *prior;	                      uint32_t nUsed;	                                               uint32_t nBias;	                                               uint32_t bUsed[(MAX##name##SPERSET + 31 ) / 32];	              class name p[MAX##name##SPERSET];	                        CPP_(int forall(uintptr_t(CPROC*)(void*f,uintptr_t),uintptr_t psv) {if( this ) return _ForAllInSet( (struct genericset_tag*)this, sizeof(class name), MAX##name##SPERSET, f, psv ); else return 0; })	 } name##SET, *P##name##SET
/* This represents the basic generic set structure. Addtional
   data is allocated at the end of this strcture to fit the bit
   array that maps usage of the set, and for the set size of
   elements.
   Remarks
   \    Summary
   Generic sets are good for tracking lots of tiny structures.
   They track slabs of X structures at a time. They allocate a
   slab of X structures with an array of X bits indicating
   whether a node is used or not. The structure overall has how
   many are used, so once full, a block can be quickly checked
   whether there is anything free. Then when checking a block
   that might have room, the availablility is checked 32 bits at
   a time, until a free spot is found.
   Sets of 1024 members of x,y coordinates for example are good
   for this sort of storage. the points are often static, once
   loaded they all exist until none of them do. This storage has
   gross deletion methods too, quickly evaporate all allocated
   chunks. Storing tiny chunks in a slab is more efficient
   because every allocation method has some sort of tracking
   associated with it - an overhead of having it. Plus, when
   operating on sets of data, a single solid slab of exatly the
   structures you are working with is more efficient to cache.
   Example
   <code lang="c++">
   struct treenode_tag {
       uint32_t treenode_data;  // abitrary structure data
   };
   typedef struct treenode_tag TREENODE;
   \#define MAXTREENODESPERSET 256
   DeclareSet( TREENODE );
   </code>
   The important part of the prior code is the last two lines.
   \#define MAX\<your type name\>SPERSET \<how many\>
   This defines how many of your structure are kept per set
   block.
   The DeclareSet( type ) declares a typedefed structure called
   'struct type##set_tag', 'name##SET', and '*P##name##SET'; in
   the above case, it would be 'struct TREENODEset_tag',
   'TREENODESET', and 'PTREENODESET'.
   Then to actually use the set...
   <code lang="c#">
   // declare a set pointer with one of the magic names.
   PTREENODESET nodeset = NULL;
   // get a node from the set.
   TREENODE *node = GetFromSet( TREENODE, nodeset );
   </code>
   Notice there is no CreateSet, getting a set member will
   create the set as required. Many operations may expend the
   set, except for GetUsedSetMember which will only result with
   \members that are definatly in the set. Accesses to the set
   are all prefixed by the type name the set was created with,
   'TREENODE' in this example.
   <code lang="c++">
   DeleteFromSet( TREENODE, nodeset, node );
   node = GetFromSet( TREENODE, nodeset );
   {
      int index = GetMemberIndex( TREENODE, nodeset, node );
   }
   </code>
   The accessor macros take care of expanding several parameters
   that require sizeof structure expansion.                      */
typedef struct genericset_tag {
	// wow might be nice to have some flags...
	// first flag - bSetSet - meaning that this is a set of sets of
	// the type specified...
	struct genericset_tag *next;
	/* This is the pointer that's pointing at the pointer pointing
	   to me. (did you get that?) See <link DeclareLink>.          */
	struct genericset_tag **me;
	/* number of spots in this set block that are used. */
	uint32_t nUsed;
    // this is the size of the bit pool before the pointer pool
	uint32_t nBias;
 // the bit pool starts here (booleanUsed) after a number of
	uint32_t bUsed[1];
	                   // bits begins the aligned pointer pool.
} GENERICSET, *PGENERICSET;
/* \    Parameters
   pSet :      pointer to a generic set
   nMember :   index of the member
   setsize :   number of elements in each block
   unitsize :  set block
   maxcnt :    max elements per set block       */
TYPELIB_PROC  POINTER  TYPELIB_CALLTYPE GetFromSetEx( GENERICSET **pSet, int setsize, int unitsize, int maxcnt DBG_PASS );
/* <combine sack::containers::sets::GetFromSetEx@GENERICSET **@int@int@int maxcnt>
   \ \                                                                             */
#define GetFromSeta(ps, ss, us, max) GetFromSetPoolEx( NULL, 0, 0, 0, (ps), (ss), (us), (max) DBG_SRC )
/* <combine sack::containers::sets::GetFromSetEx@GENERICSET **@int@int@int maxcnt>
   \    Parameters
   name :  name of type the set contains.
   pSet :  pointer to a set to get an element from.                                */
#define GetFromSet( name, pset ) (name*)GetFromSeta( (GENERICSET**)(pset), sizeof( name##SET ), sizeof( name ), MAX##name##SPERSET )
/* \    Parameters
   pSet :      pointer to a generic set
   nMember :   index of the member
   setsize :   number of elements in each block
   unitsize :  set block
   maxcnt :    max elements per set block       */
TYPELIB_PROC  PGENERICSET  TYPELIB_CALLTYPE GetFromSetPoolEx( GENERICSET **pSetSet
													 , int setsetsize, int setunitsize, int setmaxcnt
													 , GENERICSET **pSet
													 , int setsize, int unitsize, int maxcnt DBG_PASS );
/* <combine sack::containers::sets::GetFromSetPoolEx@GENERICSET **@int@int@int@GENERICSET **@int@int@int maxcnt>
   \ \                                                                                                           */
#define GetFromSetPoola(pl, sss, sus, smax, ps, ss, us, max) GetFromSetPoolEx( (pl), (sss), (sus), (smax), (ps), (ss), (us), (max) DBG_SRC )
/* <combine sack::containers::sets::GetFromSetPoolEx@GENERICSET **@int@int@int@GENERICSET **@int@int@int maxcnt>
   \ \                                                                                                           */
#define GetFromSetPool( name, pool, pset ) (name*)GetFromSetPoola( (GENERICSET**)(pool)	    , sizeof( name##SETSET ), sizeof( name##SET ), MAX##name##SETSPERSET	, (GENERICSET**)(pset), sizeof( name##SET ), sizeof( name ), MAX##name##SPERSET )
/* \    Parameters
   pSet :      pointer to a generic set
   nMember :   index of the member
   setsize :   number of elements in each block
   unitsize :  set block
   maxcnt :    max elements per set block       */
TYPELIB_PROC  POINTER  TYPELIB_CALLTYPE GetSetMemberEx( GENERICSET **pSet, INDEX nMember, int setsize, int unitsize, int maxcnt DBG_PASS );
/* <combine sack::containers::sets::GetSetMemberEx@GENERICSET **@INDEX@int@int@int maxcnt>
   \ \                                                                                     */
#define GetSetMembera(ps, member, ss, us, max) (GetSetMemberEx( (ps), (member), (ss), (us), (max) DBG_SRC ))
/* <combine sack::containers::sets::GetSetMemberEx@GENERICSET **@INDEX@int@int@int maxcnt>
   \ \                                                                                     */
#define GetSetMember( name, pset, member ) ((name*)GetSetMembera( (GENERICSET**)(pset), (member), sizeof( name##SET ), sizeof( name ), MAX##name##SPERSET ))
/* \    Parameters
   pSet :      pointer to a generic set
   nMember :   index of the member
   setsize :   number of elements in each block
   unitsize :  set block
   maxcnt :    max elements per set block       */
TYPELIB_PROC  POINTER  TYPELIB_CALLTYPE GetUsedSetMemberEx( GENERICSET **pSet, INDEX nMember, int setsize, int unitsize, int maxcnt DBG_PASS );
/* <combine sack::containers::sets::GetUsedSetMemberEx@GENERICSET **@INDEX@int@int@int maxcnt>
   \ \                                                                                         */
#define GetUsedSetMembera(ps, member, ss, us, max) (GetUsedSetMemberEx( (ps), (member), (ss), (us), (max) DBG_SRC ))
/* <combine sack::containers::sets::GetUsedSetMemberEx@GENERICSET **@INDEX@int@int@int maxcnt>
   \ \                                                                                         */
#define GetUsedSetMember( name, pset, member ) ((name*)GetUsedSetMembera( (GENERICSET**)(pset), (member), sizeof( name##SET ), sizeof( name ), MAX##name##SPERSET ))
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE  GetMemberIndex(GENERICSET **set, POINTER unit, int unitsize, int max );
/* Gets the index of a member passed as a pointer.
   Parameters
   set :       pointer to the set the member is in
   unit :      pointer to the member in the set to get the index
               of.
   unitsize :  size of each member in the set
   max :       count of members in each set block.
   Returns
   \Returns the index of the member passed in as a pointer.      */
#define GetMemberIndex(name,set,member) GetMemberIndex( (GENERICSET**)set, member, sizeof( name ), MAX##name##SPERSET )
/* <combine sack::containers::sets::GetMemberIndex>
   \ \                                              */
#define GetIndexFromSet( name, pset ) GetMemberIndex( name, pset, GetFromSet( name, pset ) )
/* \    Parameters
   pSet :      pointer to a generic set
   nMember :   index of the member
   setsize :   number of elements in each block
   unitsize :  set block
   maxcnt :    max elements per set block       */
TYPELIB_PROC  void TYPELIB_CALLTYPE  DeleteFromSetExx( GENERICSET *set, POINTER unit, int unitsize, int max DBG_PASS );
/* <combine sack::containers::sets::DeleteFromSetExx@GENERICSET *@POINTER@int@int max>
   \ \                                                                                 */
#define DeleteFromSetEx( name, set, member, xx ) DeleteFromSetExx( (GENERICSET*)set, member, sizeof( name ), MAX##name##SPERSET DBG_SRC )
/* <combine sack::containers::sets::DeleteFromSetExx@GENERICSET *@POINTER@int@int max>
   \ \                                                                                 */
#define DeleteFromSet( name, set, member ) DeleteFromSetExx( (GENERICSET*)set, (POINTER)member, sizeof( name ), MAX##name##SPERSET DBG_SRC )
/* Marks a member in a set as usable.
   Parameters
   set :       pointer to a genericset pointer
   iMember :   index of member to delete
   unitsize :  (filled by macro) size of element in set
   max :       (filled by macro) size of a block of elements. */
TYPELIB_PROC  void TYPELIB_CALLTYPE  DeleteSetMemberEx( GENERICSET *set, INDEX iMember, uintptr_t unitsize, INDEX max );
/* <combine sack::containers::sets::DeleteSetMemberEx@GENERICSET *@INDEX@uintptr_t@INDEX>
   \ \                                                                                   */
#define DeleteSetMember( name, set, member ) DeleteSetMemberEx( (GENERICSET*)set, member, sizeof( name ), MAX##name##SPERSET )
/* This function can check to see if a pointer is a valid
   element from a set.
   Parameters
   set :       pointer to a set to check
   unit :      pointer to an element from the set
   unitsize :  size of element structures in the set.
   max :       count of structures per set block
   Returns
   TRUE if unit is in the set, else FALSE.                */
TYPELIB_PROC  int TYPELIB_CALLTYPE  MemberValidInSetEx( GENERICSET *set, POINTER unit, int unitsize, int max );
/* <combine sack::containers::sets::MemberValidInSetEx@GENERICSET *@POINTER@int@int>
   \ \                                                                               */
#define MemberValidInSet( name, set, member ) MemberValidInSetEx( (GENERICSET*)set, member, sizeof( name ), MAX##name##SPERSET )
TYPELIB_PROC  int TYPELIB_CALLTYPE  CountUsedInSetEx( GENERICSET *set, int max );
/* Count number of elements that are allocated in the set.
   Parameters
   set :  The set to check
   max :  max items per set (may be unused, since this is stored
          internally now)
   Returns
   The number of items in the step.                              */
#define CountUsedInSet( name, set ) CountUsedInSetEx( (GENERICSET*)set, MAX##name##SPERSET )
TYPELIB_PROC  POINTER * TYPELIB_CALLTYPE GetLinearSetArrayEx( GENERICSET *pSet, int *pCount, int unitsize, int max );
/* Converts a set into a copy of the objects in the set
   organized in a flat array.
   Parameters
   pSet :      set to convert to an array
   pCount :    address of an integer to receive the count of
               elements put in the array.
   unitsize :  size of each element in the set
   max :       count of elements per set block
   Returns
   Pointer to an array that are a copy of the objects in the
   set.                                                      */
#define GetLinearSetArray( name, set, pCount ) GetLinearSetArrayEx( (GENERICSET*)set, pCount, sizeof( name ), MAX##name##SPERSET )
/* Returned the index of an item in a linear array returned from
   a set.
   Parameters
   pArray :      pointer to an array which has been returned from
                 the set
   nArraySize :  size fo the array
   unit :        pointer to an element in the array
   Returns
   Index of the unit in the array, INVALID_INDEX if not in the
   array.                                                         */
TYPELIB_PROC  int TYPELIB_CALLTYPE  FindInArray( POINTER *pArray, int nArraySize, POINTER unit );
/* Delete all allocated slabs.
   Parameters
   ppSet :  pointer to a generic set pointer to delete. */
TYPELIB_PROC  void TYPELIB_CALLTYPE  DeleteSet( GENERICSET **ppSet );
/* <combine sack::containers::sets::DeleteSet@GENERICSET **>
   \ \                                                       */
#define DeleteSetEx( name, ppset ) { name##SET **delete_me = ppset; DeleteSet( (GENERICSET**)delete_me ); }
/* <combine sack::containers::sets::ForAllInSet>
   ForAllinSet Callback - callback fucntion used with
   ForAllInSet                                        */
typedef uintptr_t (CPROC *FAISCallback)(void*,uintptr_t);
/* \    Parameters
   pSet :      poiner to a set
   unitsize :  size of elements in the array
   max :       count of elements per set block
   f :         user callback function to call for each element in
               the set
   psv :       user data passed to the user callback when it is
               invoked for a member of the set.
   Returns
   If the user callback returns 0, the loop continues. If the
   user callback returns non zero then the looping through the
   set ends, and that result is returned.                         */
TYPELIB_PROC  uintptr_t TYPELIB_CALLTYPE  _ForAllInSet( GENERICSET *pSet, int unitsize, int max, FAISCallback f, uintptr_t psv );
/* <combine sack::containers::sets::ForEachSetMember>
   ForEachSetMember Callback function - for the function '
   ForEachSetMember'                                       */
typedef uintptr_t (CPROC *FESMCallback)(INDEX,uintptr_t);
TYPELIB_PROC  uintptr_t TYPELIB_CALLTYPE  ForEachSetMember ( GENERICSET *pSet, int unitsize, int max, FESMCallback f, uintptr_t psv );
 //def __cplusplus
#if 0
#define DeclareSet(name)	                                struct name##set_tag {	               uint32_t set_size;	                             uint32_t element_size;	                         uint32_t element_cnt;	                          PGENERICSET pool;	                        name##set_tag() {	                        element_size = sizeof( name );	             element_cnt = MAX##name##SPERSET;	          set_size = (element_size * element_cnt )+ ((((element_cnt + 31 )/ 32 )- 1 ) * 4) + sizeof( GENERICSET );	 pool = NULL;	                               }	    ~name##set_tag() { DeleteSet( &pool ); }	 name* grab() { return (name*)GetFromSetEx( &pool, set_size, element_size, element_cnt DBG_SRC ); }	 name* grab(INDEX member) { return (name*)GetSetMemberEx( &pool, member, set_size, element_size, element_cnt DBG_SRC ); }	 name* get(INDEX member) { return (this)?(name*)GetUsedSetMemberEx( &pool, member, set_size, element_size, element_cnt DBG_SRC ):(NULL); }	 void drop( name* member ) { DeleteFromSetEx( pool, (POINTER)member, element_size, element_cnt ); }	 int valid( name* member ) { return MemberValidInSetEx( pool, (POINTER)member, element_size, element_cnt ); }	 uintptr_t forall( FAISCallback f, uintptr_t psv ) { if( this ) return _ForAllInSet( pool, element_size, element_cnt, f, psv ); else return 0; }	 };	       typedef struct name##set_tag *P##name##SET, name##SET;
#define ForAllInSet(name, pset,f,psv) _ForAllInSet( (GENERICSET*)(pset), sizeof( name ), MAX##name##SPERSET, (f), (psv) )
#else
/* <combine sack::containers::sets::_ForAllInSet@GENERICSET *@int@int@FAISCallback@uintptr_t>
   \ \                                                                                       */
#define ForAllInSet(name, pset,f,psv) _ForAllInSet( (GENERICSET*)(pset), sizeof( name ), MAX##name##SPERSET, (f), (psv) )
/* Performs an iteration over each allocated set member. Calls
   the user provided callback routine with each element in the
   set.
   Parameters
   pSet :      pointer to the set to iterate
   unitsize :  size of each element
   max :       max count of elements per set block
   f :         function to call ( uintptr_t (*)(INDEX,uintptr_t) )
   psv :       user data value to pass to function as uintptr_t
   Returns
   uintptr_t - this value is the return of the user function if
   the function does not return 0. A non zero return from the
   user callback stops iteration.                                */
#define ForEachSetMember(name,pset,f,psv) ForEachSetMember( (GENERICSET*)(pset),sizeof(name),MAX##name##SPERSET, (f), (psv) )
#endif
//---------------------------------------------------------------------------
_SETS_NAMESPACE_END
_TEXT_NAMESPACE
// this defines more esoteric formatting notions...
// these data blocks will be zero sized, and ahve the TF_FORMATEX
// bit set.
//#define DEFAULT_COLOR 0xF7
//#define PRIOR_COLOR 0xF6 // this does not change the color....
// these enumerated ops put in the foreground field of a format
// with a flag of TF_FORMATEX will cause the specified operation
// to be carried out on a display (not files) or generated into
// the appropriate sequence (ansi out encode)
// -- correction
//  this is encoded into its own field for the format
// size, due to machine optimization, 16 bits were free
// this was expanded and used for all information
// a segment may contain extended op, color, attributes,
// and text, everything short of a font for it...
//  - not sure how to address that issue... there's
// certainly modifications to current font... italic for
// instance..
	enum FORMAT_OPS {
      /* this segment clears to the end of the line.  Its content is then added to the output */
		FORMAT_OP_CLEAR_END_OF_LINE = 1
        ,FORMAT_OP_CLEAR_START_OF_LINE
                   ,
						  FORMAT_OP_CLEAR_LINE
						 ,
						  FORMAT_OP_CLEAR_END_OF_PAGE
                   ,
						  FORMAT_OP_CLEAR_START_OF_PAGE
						 ,
/* clear the entire vieable page (pushes all content to history)
                    set cursor home ;6*/
						  FORMAT_OP_CLEAR_PAGE
						 ,
						  FORMAT_OP_CONCEAL
                   ,
						  FORMAT_OP_DELETE_CHARS
                   ,
						  FORMAT_OP_SET_SCROLL_REGION
                   ,
						  FORMAT_OP_GET_CURSOR
						 ,
						  FORMAT_OP_SET_CURSOR
						 ,
						  FORMAT_OP_PAGE_BREAK
						 ,
/* break between paragraphs - kinda same as lines...
						  since lines are as long as possible... ;13 */
						 FORMAT_OP_PARAGRAPH_BREAK
						 ,
/* Justify line(s if wrapped) to the right
						   This attribute should be passed through to renderer;14*/
                   FORMAT_OP_JUSTIFY_RIGHT
						 ,
/* Justify line(s if wrapped) to the center
						 This attribute should be passed through to renderer;15*/
                   FORMAT_OP_JUSTIFY_CENTER
};
//typedef struct text_color_tag { uint32_t color: 8; } TEXTCOLOR;
// this was a 32 bit structure, but 8 fore, 8 back
// 8 x, 8 y failed for positioning...
// extended position, added more information
// reduced color, 16 colors is really all that there
// are... 4 bits... added bits for extended formatting
// like blink, bold, wide, high
// foreground/background  values will be
// sufficient... they retain full informaiton
//
typedef struct format_info_tag
{
   /* bit-packed flags indicating the type of format information that is applied to this segment.*/
	struct {
		// extended operation from enumeration above...
		// might shrink if more attributes are desired...
		// if many more are needed, one might consider
      // adding FONT!
     /* this segment uses the prior foreground, not its own. */
		BIT_FIELD prior_foreground : 1;
     /* this segment uses the prior background, not its own. */
		BIT_FIELD prior_background : 1;
     /* this segment uses the default foreground, not its own. */
		BIT_FIELD default_foreground : 1;
      /* this segment uses the default background, not its own. */
		BIT_FIELD default_background : 1;
      /* the foreground color of this segment (0-16 standard console text [ANSI text]) */
		BIT_FIELD foreground : 4;
      /* the background color of this segment (0-16 standard console text [ANSI text]) */
		BIT_FIELD background : 4;
      /* a bit indicating the text should blink if supported */
		BIT_FIELD blink : 1;
      /* a bit indicating the foreground and background color should be reversed */
		BIT_FIELD reverse : 1;
		// usually highly is bolder, perhaps it's
      // a highlighter effect and changes the background
		BIT_FIELD highlight : 1;
		// this is double height modifications to the font...
		BIT_FIELD tall : 1;
      // this is thicker characters...
		BIT_FIELD bold : 1;
      // draw a line under the text...
		BIT_FIELD underline : 1;
		// strike through - if able, draw a line right
		// through the middle of the text... maybe
		// it's a wiggly scribble line?  maybe that
      // could be extended again?
		BIT_FIELD strike : 1;
      // text is drawn wide (printer kinda font?)
		BIT_FIELD wide : 1;
       // this is pretty common......
		BIT_FIELD italic : 1;
		// --
		// these flags are free, but since we already have text segments
		// and I'm bringing in consoles, perhaps we should consider using
		// this to describe captions, but provide the api layer for CTEXTSTR
		// --
		// position data remains constant.
		// text is mounted at the top/left of the
		// first character... (unless center, then
		// the position specifies the middle of the text
		// draw vertical instead of horizontal
		BIT_FIELD bVertical:1;
		// draw opposite/upside down from normal
		// vertical/down, right/left upside down if not centered
		// if centered, the text pivots around position.
		BIT_FIELD bInvert:1;
		// 0 = default alignment 1 = left, 2 = center 3 = right
		// 0 is not set, the flag set in the lower 32 bit flags
		// is not needed any longer.... anything non zero
		// is that operation to apply.
		BIT_FIELD bAlign:2;
      /* format op indicates one of the enum FORMAT_OPS applies to this segment */
		BIT_FIELD format_op : 7;
	} flags;
	// if x,y are valid segment will have TF_POSFORMAT set...
	union {
		/* Coordinate information attached to a text segment. */
		/* Positioning specification of this text segment. with
		   basically 0 format options, position is used.
		   Position represents the distance from this segment to the
		   prior segment in count of tabs and spaces.
		   coords specifies an x,y coordinate location for the segment.
		   Usage of this union is dependant on <link text::format_info_tag::flags@1::format_op, format_op>. */
		struct {
         // Signed coordinate of this segment on a text display.  May be relative depending on format_op.
			int16_t x;
         // Signed coordinate of this segment on a text display.  May be relative depending on format_op.
			int16_t y;
		} coords;
		/* Defines the distance from the prior segment in count of tabs
		   and spaces (mostly count of spaces).                         */
		struct {
   // tabs preceed spaces....
			uint16_t tabs;
 // not sure what else to put with this...
			uint16_t spaces;
		} offset;
	} position;
} FORMAT, *PFORMAT;
 // special coordinate which is NO coordinate
#define IGNORE_CURSOR_POS -16384
/* test flag, format has position data */
#define TF_FORMATPOS (TF_FORMATABS|TF_FORMATREL|TF_FORMATEX)
/* these flags are used in PTEXT.flags member
 applications may use these flags to group expressions
 will affect the BuildLine but is not generated by library.
( TF_QUOTE, TF_SQUOTE, TF_BRACKET, TF_BRACE, TF_PAREN, and TF_TAG).
*/
enum TextFlags {
   // declared in program data.... do NOT release
 TF_STATIC    = 0x00000001,
   // double quoted string segment " "
 TF_QUOTE     = 0x00000002,
   // single quoted string ' '
 TF_SQUOTE    = 0x00000004,
   // bracketed expression []
 TF_BRACKET   = 0x00000008,
   // braced expression {}
 TF_BRACE     = 0x00000010,
   // parenthised expression ()
 TF_PAREN     = 0x00000020,
   // HTML tag like expression &lt;&gt;
 TF_TAG       = 0x00000040,
   // foreground is FORMAT_OP
 TF_FORMATEX  = 0x00000080,
   // x,y position used (relative)
 TF_FORMATREL = 0x00000100,
   // size field extually points at PTEXT
 TF_INDIRECT  = 0x00000200,
   // format position is x/y - else space count
 TF_FORMATABS = 0x00000800,
   // set during burst for last segment...
 TF_COMPLETE  = 0x00001000,
   // set for non-text variable
 TF_BINARY    = 0x00002000,
   // on release release indrect also...
 TF_DEEP      = 0x00004000,
   // set on first segment to send to omit lead \r\n
 TF_NORETURN  = 0x00008000,
// these values used originally for ODBC query construction....
// these values are flags stored on the indirect following a value
// label...
// Low bound of value...
  TF_LOWER     = 0x00010000,
// these values used originally for ODBC query construction....
// these values are flags stored on the indirect following a value
// label...
  // Upper bound of a value...
  TF_UPPER     = 0x00020000,
// these values used originally for ODBC query construction....
// these values are flags stored on the indirect following a value
// label...
// boundry may be ON this value...
 TF_EQUAL     = 0x00040000,
   // this segment is not a permanent part (SubstToken)
 TF_TEMP      = 0x00080000,
  // this is something special do not treat as text indirect.
 TF_APPLICATION = 0x00100000,
};
//--------------------------------------------------------------------------
// flag combinatoin which represents actual data is present even with 0 size
// extended format operations (position, ops) are also considered data.
#define IS_DATA_FLAGS (TF_QUOTE|TF_SQUOTE|TF_BRACKET|TF_BRACE|                              TF_PAREN|TF_TAG|TF_FORMATEX|TF_FORMATABS|TF_FORMATREL)
// this THis defines/initializes the data part of a PTEXT/TEXT structure.
// used with DECLTEXTSZTYPE
#define DECLDATA(name,length) struct {size_t size; TEXTCHAR data[length];} name
#define DECLTEXTSZTYPE( name, size ) struct {    uint32_t flags;    struct text_segment_tag *Next, *Prior;    FORMAT format;    DECLDATA(data, size); } name
/* A macro to declare a structure which is the same physically
   as a PTEXT, (for declaring static buffers). Has to be cast to
   (PTEXT) is used. Is defined as a size, but no string content.
   Parameters
   name :  name of the variable to create
   size :  size of the static text element. (0 content)          */
#define DECLTEXTSZ( name, size ) DECLTEXTSZTYPE( name,(size) )	 = { TF_STATIC, NULL, NULL, {{1,1  ,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}} }
/* Defines an initializer block which can be used to satisfy a
   TEXT elemnt of a structure
   Parameters
   str :  string content of the TEXT
   Example
   <code lang="c++">
   TEXT something = DEFTEXT( "abc" );
   </code>                                                     */
#define DEFTEXT(str) {TF_STATIC,NULL,NULL,{{1,1}},{(sizeof(str)/sizeof(str[0]))-1,str}}
/* A macro to declare a structure which is the same physically
   as a PTEXT, (for declaring constant static strings
   basically). Has to be cast to (PTEXT) is used.
   Parameters
   name :   name of the variable to create
   value :  static string constant to initialize variable to.  */
#define DECLTEXT(name, str) static DECLTEXTSZTYPE( name, (sizeof(str)/sizeof(str[0])) ) = DEFTEXT(str)
/* Description
   A Text segment, it is based on DataBlock that has a length
   and an addtional region at the end of the structure which
   contains the text of the segment. Segments may have
   formatting attributes. Segments may be linked to other
   segments in a NEXTLINE/PRIORLINE. Segments may have indirect
   content, which may represent phrases. Sets of segments may
   represent sentence diagrams. A Pointer to a <link text::TEXT, TEXT>
   type.
   TEXT is a type I created to provide a variety of functions.
   One particular application was a common language processor,
   and I created the TEXT structure to store elements which are
   described by language. Sentences are words, and phases. A
   phrase is a set of words, but sometimes a word is a phrase.
   (sentence) = ( word ) ... (phrase ) ...
   (phrase) = (word)...
   hmm.. how to describe this.
   <code lang="c++">
   PTEXT phrase = NULL;
   SegAppend( phrase, SegCreateFromText( "Test" ) );
   </code>
   <code>
   SegAppend( phrase, SegCreateFromText( "Test" ) );
   SegAppend( phrase, SegCreateFromText( "Test" ) );
   </code>
   PTEXT segments point at other segments. A list of segments is
   a sentence. Segments can have information encoded on them
   that remove text from them. For instance, \< and \> tags
   might be removed around a phrase and stored as an attribute
   of the segment. A segment with such an attribute could be an
   indirect segment that points at a list of words which are the
   phrases in the tag.
   <code lang="c++">
   a map of two segments, and their content...
       (segment with TF_TAG) -\> (segment with TF_TAG)
             |                        |
             \+ - ("html")             + - (body) -\> (background="#000000")
   would actually expand to
      \<html\>\<body background="#000000"\>
   </code>
   See Also
   SegCreate
   burst
   TextParse
   SegAppend
   SegSubst
   SegSplit
   SegGrab
   SegDelete
   LineRelease
   BuildLine
   and also.....
   PVARTEXT                                                                  */
typedef struct text_segment_tag
{
	// then here I could overlap with pEnt .bshadow, bmacro, btext ?
   uint32_t flags;
	/* This points to the next segment in the sentence or phrase. NULL
	   if at the end of the line.                                      */
		struct text_segment_tag *Next;
	/* This points to the prior segment in the sentence or phrase. (NULL
	   if at the first segment)                                          */
		struct text_segment_tag *Prior;
	/* format is 64 bits.
      it's two 32 bit bitfields (position, expression)
	 valid if TF_FORMAT is set... */
	FORMAT format;
   /* A description of the data stored here.  It is compatible with a DATABLOCk.... */
   struct {
	   /* unsigned size; size is sometimes a pointer value...
                  this means bad thing when we change platforms... Or not, since we went to uintptr_t which is big enough for a pointer. */
		uintptr_t size;
		/* the data of the test segment
		 beginning of var data - this is created size+sizeof(TEXT) */
		   TEXTCHAR  data[1];
	} data;
} TEXT, *PTEXT;
//
// PTEXT DumpText( PTEXT somestring )
//    PTExT (single data segment with full description \r in text)
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  DumpText ( PTEXT text );
//SegCreateFromText( ".." );
// Burst, SegAppend, SegGrab
// segments are ment to be lines, the meaninful tag "TF_NORETURN" means it's part of the prior line.
//--------------------------------------------------------------------------
#define HAS_WHITESPACE(pText) ( pText && ( (pText)->format.position.offset.spaces || (pText)->format.position.offset.tabs ) )
/* A convenient macro to go from one segment in a line of text
   to the next segment.                                        */
#define NEXTLINE(line)   ((PTEXT)(((PTEXT)line)?(((PTEXT)line)->Next):(NULL)))
/* A convenient macro to go from one segment in a line of text
   to the prior segment.                                       */
#define PRIORLINE(line)  ((PTEXT)(((PTEXT)line)?(((PTEXT)line)->Prior):(NULL)))
/* Link one PTEXT segment to another. Sets one half of the links
   appropriate for usage.
   Example
   This example sets the prior pointer of 'word' to 'line'.
   <code>
   PTEXT line;
   PTEXT word;
   SETPRIORLINE( word, line );
   </code>                                                       */
#define SETPRIORLINE(line,p) ((line)?(((line)->Prior) = (PTEXT)(p)):0)
/* Link one PTEXT segment to another. Sets one half of the links
   appropriate for usage.
   Example
   This example sets the next pointer of 'line' to 'word'.
   <code lang="c#">
   PTEXT line;
   PTEXT word;
   SETNEXTLINE( line, word );
   </code>                                                       */
#define SETNEXTLINE(line,p)  ((line)?(((line)->Next ) = (PTEXT)(p)):0)
/* Sets a pointer to PTEXT to the first text segment in the
   list.                                                    */
#define SetStart(line)     for(; line && PRIORLINE(line);line=PRIORLINE(line))
/* Sets a PTEXT to the last segment that it points to.
   Parameters
   line :  segment in the line to move to the end of.
   Remarks
   Updates the variable passed to point to the last segment. */
#define SetEnd(line)      for(; line && NEXTLINE(line); line=NEXTLINE(line))
// might also check to see if pseg is an indirect - setting this size would be BAD
#define SetTextSize(pseg, sz ) ((pseg)?((pseg)->data.size = (sz )):0)
/* gets the indect segment content (if any) from a PTEXT
   segment.                                              */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  GetIndirect(PTEXT segment );
/* Get the format flags of a PTEXT.
                                    */
TYPELIB_PROC  uint32_t TYPELIB_CALLTYPE  GetTextFlags( PTEXT segment );
/* Gets the text segment length. */
TYPELIB_PROC  size_t TYPELIB_CALLTYPE  GetTextSize( PTEXT segment );
/* Gets the text of a PTEXT segment. (convert to a CTEXTSTR)
   Parameters
   segment :  segment to get the string content from         */
TYPELIB_PROC  TEXTSTR TYPELIB_CALLTYPE  GetText( PTEXT segment );
// by registering for TF_APPLICTION is set on the segment
// and flags anded with the segment flags match, the
// function is called.... the result is the actual
// segment of this - since a TF_APPLICATION is also
// TF_INDIRECT - using the size to point to some application
// defined structure instead of a PTEXT structure.
TYPELIB_PROC  void TYPELIB_CALLTYPE  RegisterTextExtension ( uint32_t flags, PTEXT(CPROC*)(uintptr_t,POINTER), uintptr_t );
// similar to GetIndirect - but results in the literal pointer
// instead of the text that the application may have registered to result with.
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE  GetApplicationPointer ( PTEXT text );
/* Used to set the content of a segment to some application
   defined value. This allows a users application to store
   chunks of data in lists of text. These external chunks are
   handled like other words.
   Parameters
   text :  this is the text segment to set application data on
   p :     this is a pointer to application data               */
TYPELIB_PROC  void TYPELIB_CALLTYPE  SetApplicationPointer ( PTEXT text, POINTER p);
/* Set segment's indirect data.
   Parameters
   segment :  pointer to a TEXT segment to set the indirect content
              of.
   data :     pointer to a PTEXT to be referenced indirectly.       */
#define SetIndirect(Seg,Where)  ( (Seg)->data.size = ((uintptr_t)(Where)-(uintptr_t)NULL) )
		/* these return 1 for more(l1&gt;l2) -1 for (l1&lt;l2) and 0 for match.
       */
TYPELIB_PROC  int TYPELIB_CALLTYPE  SameText ( PTEXT l1, PTEXT l2 );
/* A test if one PTEXT is similar to another PTEXT.
   Parameters
   l1 :  PTEXT segment one
   l2 :  PTEXT segment two
   Return Value List
   \<0 :  l1 with case insensitive comparison is less then l2
   0 :    Texts compare case insenitive match
   \>0 :  l1 with case insensitive comparison is more than l2 */
TYPELIB_PROC  int TYPELIB_CALLTYPE  LikeText ( PTEXT l1, PTEXT l2 );
/* Compares if text is like a C string. Case Sensitive.
   <b>Returns</b>
   TRUE if they are alike.
   FALSE if they are different.
   <b>Parameters</b>                                    */
TYPELIB_PROC  int TYPELIB_CALLTYPE  TextIs  ( PTEXT pText, CTEXTSTR text );
/* Compares if text is like a C string. Case insensitive (like).
   Returns
   TRUE if they are alike.
   FALSE if they are different.
   Parameters
   pText :  PTEXT segment to compare
   text :   C string buffer to compare against                   */
TYPELIB_PROC  int TYPELIB_CALLTYPE  TextLike  ( PTEXT pText, CTEXTSTR text );
/* Compares if text is like a C string. Case insensitive (like). Uses min string length for max match.
   Returns
   TRUE if they are similar (both case insensitive using shorter of the strings for maxlen).
   FALSE if they are different.
   Parameters
   pText :  PTEXT segment to compare
   text :   C string buffer to compare against                   */
TYPELIB_PROC  int TYPELIB_CALLTYPE  TextSimilar  ( PTEXT pText, CTEXTSTR text );
//#define SameText( l1, l2 )  ( strcmp( GetText(l1), GetText(l2) ) )
#define textmin(a,b) ( (((a)>0)&&((b)>0))?(((a)<(b))?(a):(b)):(((a)>0)?(a):((b)>0)?(b):0) )
#ifdef __LINUX__
#  include <strings.h>
/* windows went with stricmp() and strnicmp(), whereas linux
 went with strcasecmp() and strncasecmp()                  */
#  define strnicmp strncasecmp
/* windows went with stricmp() and strnicmp(), whereas linux
   went with strcasecmp() and strncasecmp()                  */
#  define stricmp strcasecmp
#endif
/* Copy segment formatting to another segment... */
TYPELIB_PROC  void TYPELIB_CALLTYPE  SegCopyFormat( PTEXT to_this, PTEXT copy_this );
/* Create a text segment of sepecified size; inclues one more character for NUL terminator */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegCreateEx( size_t nSize DBG_PASS );
/* Create a PTEXT with specified number of character capacity.
   Example
   <code lang="c#">
   PTEXT text = SegCreate( 10 );
   </code>                                                     */
#define SegCreate(s) SegCreateEx(s DBG_SRC)
/* \    See Also
   <link DBG_PASS>
   <link SegCreateFromText> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegCreateFromTextEx( CTEXTSTR text DBG_PASS );
/* Creates a PTEXT segment from a string.
   Example
   <code lang="c++">
   PTEXT line = SegCreateFromText( "Around the world in a day." );
   </code>                                                         */
#define SegCreateFromText(t) SegCreateFromTextEx(t DBG_SRC)
/* \    See Also
   <link DBG_PASS>
   <link SegCreateFromChar> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegCreateFromCharLenEx( const char *text, size_t len DBG_PASS );
/* \    See Also
   <link DBG_PASS>
   <link SegCreateFromChar> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegCreateFromCharEx( const char *text DBG_PASS );
/* Creates a PTEXT segment from a string.
   Example
   <code lang="c++">
   PTEXT line = SegCreateFromChar( "Around the world in a day." );
   </code>                                                         */
#define SegCreateFromChar(t) SegCreateFromCharEx(t DBG_SRC)
/* \    See Also
   <link DBG_PASS>
   <link SegCreateFromChar> */
#define SegCreateFromCharLen(t,len) SegCreateFromCharLenEx((t),(len) DBG_SRC)
/* \    See Also
   <link DBG_PASS>
   <link SegCreateFromWide> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegCreateFromWideLenEx( const wchar_t *text, size_t len DBG_PASS );
/* \    See Also
   <link DBG_PASS>
   <link SegCreateFromWide> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegCreateFromWideEx( const wchar_t *text DBG_PASS );
/* Creates a PTEXT segment from a string.
   Example
   <code lang="c++">
   PTEXT line = SegCreateFromWideLen( L"Around the world in a day.", 26 );
   </code>                                                         */
#define SegCreateFromWideLen(t,len) SegCreateFromWideLenEx((t),(len) DBG_SRC)
/* \    See Also
   <link DBG_PASS>
   <link SegCreateFromWide> */
#define SegCreateFromWide(t) SegCreateFromWideEx(t DBG_SRC)
/* \    See Also
   <link DBG_PASS>
   <link SegCreateIndirect> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegCreateIndirectEx( PTEXT pText DBG_PASS );
/* Creates a text segment that refers to the parameter
   indirectly. The new segment is not really a clone, but a
   reference of the original PTEXT.
   Example
   <code lang="c#">
   PTEXT phrase = SegCreateIndirect( SegAppend( SegCreateFromText( "Hello" )
                                              , SegCreateFromText( "World" ) ) );
   </code>
   The resulting phrase is a single segment with no prior or
   next, but its content is "HelloWorld" if it was passed to
   buildline... it's go the content of the two text segments
   linked together, but not in its buffer. It is actually a 0
   length buffer for a TEXT segment.
                                                                                  */
#define SegCreateIndirect(t) SegCreateIndirectEx(t DBG_SRC)
/* \    See Also
   <link DBG_PASS>
   <link SegDuplicate> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegDuplicateEx( PTEXT pText DBG_PASS);
/* This duplicates a specific segment. It duplicates the first
   segment of a string. If the segment has indirect data, then
   the first segment of the indirect data is duplicated.       */
#define SegDuplicate(pt) SegDuplicateEx( pt DBG_SRC )
/* Duplicates a linked list of segments.
   Duplicates the structure of a line. The resulting line is an
   exact duplicate of the input line. All segments linked in
   exactly the same sorts of ways.
   Parameters
   line :  list of segments to duplicate                        */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  LineDuplicateEx( PTEXT pText DBG_PASS );
/* <combine sack::containers::text::LineDuplicateEx@PTEXT pText>
   \ \                                                           */
#define LineDuplicate(pt) LineDuplicateEx(pt DBG_SRC )
/* \    See Also
   <link DBG_PASS>
   <link TextDuplicate> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  TextDuplicateEx( PTEXT pText, int bSingle DBG_PASS );
/* Duplicate the whole string of text to another string with
   exactly the same content.                                 */
#define TextDuplicate(pt,s) TextDuplicateEx(pt,s DBG_SRC )
/* \    See Also
   <link DBG_PASS>
   <link SegCreateFromInt> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegCreateFromIntEx( int value DBG_PASS );
/* Creates a text segment from a 64 bit integer.
   Example
   <code>
   PTEXT number = SegCreateFromInt( 3314 );
   </code>                                       */
#define SegCreateFromInt(v) SegCreateFromIntEx( v DBG_SRC )
/* Converts an integer to a PTEXT segment.
   Parameters
   _64bit_value :  integer value to convert to a PTEXT segment. */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegCreateFrom_64Ex( int64_t value DBG_PASS );
/* Create a text segment from a uint64_t bit value. (long long int) */
#define SegCreateFrom_64(v) SegCreateFrom_64Ex( v DBG_SRC )
/* \    See Also
   <link DBG_PASS>
   <link SegCreateFromFloat> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegCreateFromFloatEx( double value DBG_PASS );
/* Creates a text segment from a floating point value. Probably
   uses something like '%g' to format output. Fairly limited.
   Example
   <code lang="c++">
   PTEXT short_PI = SegCreateFromFloat( 3.14 );
   </code>                                                      */
#define SegCreateFromFloat(v) SegCreateFromFloatEx( v DBG_SRC )
/* Appends a list of segments to an existing list of segments. This
   assumes that the additional segment is referncing the head of
   the segment list.
   Parameters
   source :  source list to add to
   other :   additional segments to add to source.                  */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegAppend   ( PTEXT source, PTEXT other );
/* Inserts a segment before another segment.
   Parameters
   what :    what to insert into the list
   before :  insert the segments before this segment
   Returns
   The parameter 'what'.                             */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegInsert   ( PTEXT what, PTEXT before );
/* This expands a segment by a number of characters.
   Parameters
   PTEXT :  the segment to expand
   int :    count of character to expand by
   Returns
   A pointer to a new segment that is bigger, but has the same
   existing content.                                           */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegExpandEx (PTEXT source, INDEX nSize DBG_PASS );
/* <combine sack::containers::text::SegExpandEx@PTEXT@INDEX nSize>
   \ \                                                             */
#define SegExpand(s,n) SegExpandEx( s,n DBG_SRC )
/* Release a linked list of PTEXT segments.
   Parameters
   segments :  a segment in a list of segments to delete, first
               this routine goes to the start of the segment
               list, and then deletes all segments in the list.
   DBG_PASS :  debug file and line information                  */
TYPELIB_PROC  void TYPELIB_CALLTYPE   LineReleaseEx (PTEXT line DBG_PASS );
/* Release a line of text.
   A line may be a single segment.
   This is the proper way to dispose of PTEXT segments.
   Any segment in the line may be passed, the first segment is
   found, and then all segments in the line are deleted.       */
#define LineRelease(l) LineReleaseEx(l DBG_SRC )
/* \
   <b>See Also</b>
   <link DBG_PASS>
   <link SegRelease> */
TYPELIB_PROC  void TYPELIB_CALLTYPE  SegReleaseEx( PTEXT seg DBG_PASS );
/* Release a single segment. UNSAFE. Does not respect that it is
   in a list.
   See Also
   <link LineRelease>                                            */
#define SegRelease(l) SegReleaseEx(l DBG_SRC )
/* Adds a part of input to the segment list of output.
   Parameters
   output\ :   the segment list to append to.
   input\ :    the input buffer to append from
   offset :    starting offset in 'input' to start from
   length :    how much from 'offset' in input to append as a new
               segment to output.
   DBG_PASS :  \file and line debugging information               */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegConcatEx   (PTEXT output,PTEXT input,int32_t offset,size_t length DBG_PASS);
/* <combine sack::containers::text::SegConcatEx@PTEXT@PTEXT@int32_t@size_t length>
   looks like it takes a piece of one segment and appends it to
   another....
   Needs More research to document correctly and exemplify.                     */
#define SegConcat(out,in,ofs,len) SegConcatEx(out,in,ofs,len DBG_SRC)
/* Removes a segment from a list of segments. Links what was
   prior and what was after together. Sets both next and prior
   of the segment unlinked to NULL.
   Example
   <code lang="c++">
   SegUnlink( segment );
   </code>
   Returns
   The segment passed.                                         */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegUnlink   (PTEXT segment);
/* Breaks a list of PTEXT segments at the specified segment and
   \returns a segment that was before the specified.
   Parameters
   segment :  segment to break the chain at
   Returns
   Any existing segment before the segment to break at.
   Example
   <code lang="c++">
   {
      PTEXT segs;
      PTEXT breakat;
      PTEXT leftover;
		&#47;* ... segs gets populated with some segments ... *&#47;
      breakat = NEXTLINE( segs );
   </code>
   <code>
      breakat = NEXTLINE( segs );
      leftover = segbreak( breakat );
      // now breakat begins a new chain of segments
      // leftover is the segment that was just before breakat
      SegStart( leftover );  // leftover would be equal to segs...
   }
   </code>                                                         */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegBreak    (PTEXT segment);
/* Removes a segment from a list. It also releases the segment.
    Example
    <code lang="c#">
    SegDelete( segment );
    </code>
    the result is NULL;                                          */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegDelete   (PTEXT segment);
/* removes segment from any list it might be in, returns
   segment.                                              */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegGrab     (PTEXT segment);
/* Substitute one PTEXT segment for another in a list of PTEXT
   segments.
   Parameters
   _this :  This is the segment to remove
   that :   This is the segment to subustitute with. This may be
            a list of segments, and it is linked in from the
            first segment to the prior to '_this' and the last to
            the next after '_this'
   Returns
   \Returns the '_this' that was substituted.                     */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegSubst    ( PTEXT _this, PTEXT that );
/* \    See Also
   <link DBG_PASS>
   <link SegSplit> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  SegSplitEx( PTEXT *pLine, INDEX nPos DBG_PASS);
/* Split a PTEXT segment.
   Example
   \    <code lang="c++">
   PTEXT result = SegSplit( &amp;old_string, 5 );
   </code>
   Returns
   PTEXT new_string;
   Remarks
   the old string segment is split at the position indicated. The
   pointer to the old segment is modified to point to now two
   segments linked dynamically, each part of the segment after
   the split. If the index is beyond the bounds of the segment,
   the segment remains unmodified.                                */
#define SegSplit(line,pos) SegSplitEx( line, pos DBG_SRC )
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  FlattenLine ( PTEXT pLine );
/* Create a highest precision signed integer from a PTEXT. */
TYPELIB_PROC  int64_t TYPELIB_CALLTYPE  IntCreateFromSeg( PTEXT pText );
/* Converts a text to the longest precision signed integer
   value.
     allows +/- leadin ([-*]|[+*])*
     supports 0x### (hex), 0b#### (binary), 0o#### (octal), 0### (octal)
	 decimal 1-9[0-9]*
	 buggy implementation supports +/- inline continue number and are either ignored(+)
	 or changes the overall sign of the number(-).  A Decimal definatly ends the number.
	 And octal/binary digits aren't checked for range, so 8/9 will over-flow in octal,
	 and 2-9 overflow to upper bits in octal...
	    0b901090 // would be like   0b 10100110    0b1001 +  010 + 1001<<3 + 0
   */
TYPELIB_PROC  int64_t TYPELIB_CALLTYPE  IntCreateFromText( CTEXTSTR p );
/* Converts a text to the longest precision signed integer
   value.  Does the work of IntCreateFromText.
   IntCreateFromTextRef updates the pointer passed by reference so
   the pointer ends at the first character after the returned number.
   */
TYPELIB_PROC  int64_t TYPELIB_CALLTYPE  IntCreateFromTextRef( CTEXTSTR *p_ );
/* Create a high precision floating point value from PTEXT
   segment.                                                */
TYPELIB_PROC  double TYPELIB_CALLTYPE  FloatCreateFromSeg( PTEXT pText );
/* Create a high precision floating point value from text
   string.                                                */
TYPELIB_PROC  double TYPELIB_CALLTYPE  FloatCreateFromText( CTEXTSTR p, CTEXTSTR *pp );
//
// IsSegAnyNumber returns 0 if no, 1 if is int, 2 if is float
//   if pfNumber or piNumber are available then the text pointer
//   will be updated to the next segment after what was used to resolve
//   the number.
//   bUseAllSegs is for testing pTexts which are indirect, such that
//      only all segments within the indirect segment will result valid.
//   pfNumber and piNumber may be passed as NULL, and the function can still
// be used to determine ifnumber
//   the number resulting in the values pointed to will be filled in
//    with (*pfNumber)=FltCreateFromSeg(p) (or Int as appropriate)
//
//#define IsNumber(p) IsSegAnyNumberEx( &(p), NULL, NULL, NULL, 0 )
#define IsIntNumber(p, pint) IsSegAnyNumberEx( &(p), NULL, pint, NULL, 0 )
/* Tests a PTEXT segment to see if it might be a floating point
   number.                                                      */
#define IsFltNumber(p, pflt) IsSegAnyNumberEx( &(p), pflt, NULL, NULL, 0 )
/* Tests the content of a PTEXT to see if it might be a number.
   Parameters
   ppText :       pointer to PTEXT to check
   pfNumber :     pointer to double to get result of number it's
                  a float
   piNumber :     pointer to a signed 64 bit value to get the
                  \result if it's not a float.
   pbIsInt :      point to a integer \- receives boolean result
                  if the segment was an integer is TRUE else it's
                  a double.
   bUseAllSegs :  if TRUE, use all the segments starting with the
                  first, and update the pointer to the next
                  stgment. If false, use only the first segment. if
                  uses all segments, it must also use ALL
                  segments to get the number.
   Returns
   0 if not a number or fails.
   1 if a valid conversion took place.                              */
TYPELIB_PROC  int TYPELIB_CALLTYPE  IsSegAnyNumberEx ( PTEXT *ppText, double *pfNumber, int64_t *piNumber, int *pbIsInt, int bUseAllSegs );
/* <combine sack::containers::text::IsSegAnyNumberEx@PTEXT *@double *@int64_t *@int *@int>
   \ \                                                                                  */
#define IsSegAnyNumber(pptext, pfNum, piNum, pbIsInt) IsSegAnyNumberEx( pptext, pfNum, piNum, pbIsInt, 0 )
/* \Returns the amount of space required to store this segment,
   and all indirect statements it contains.
   Parameters
   segment :   segment to measure
   position :  starting position in the segment to measure from
   nTabSize :  how big tabs are supposed to be
   tabs :      list of tab positions (for arbitrary tab
               positioning\- table column alignment?)           */
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE  GetSegmentSpaceEx ( PTEXT segment, INDEX position, int nTabs, INDEX *tabs);
/* \Returns the amount of space required to store this segment,
   and all indirect statements it contains.
   Parameters
   segment :   segment to measure
   position :  starting position in the segment to measure
               from
   nTabSize :  how big tabs are supposed to be                  */
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE  GetSegmentSpace ( PTEXT segment, INDEX position, int nTabSize );
/* Simlar to getsegment space... */
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE  GetSegmentLengthEx ( PTEXT segment, INDEX position, int nTabs, INDEX *tabs );
/* \Returns the length of a single PTEXT segment.
   Parameters
   segment :   segment to measure
   position :  string position in the string to measure
   nTabSize :  how many characters a tab is supposed to be. */
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE  GetSegmentLength ( PTEXT segment, INDEX position, int nTabSize );
/* Measure the length of a list of segments (combined length of
   all linked segments)                                         */
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE  LineLengthExEx( PTEXT pt, LOGICAL bSingle, int nTabsize, PTEXT pEOL );
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE  LineLengthExx( PTEXT pt, LOGICAL bSingle,PTEXT pEOL );
/* <combine sack::containers::text::LineLengthExEx@PTEXT@LOGICAL@int@PTEXT>
   \ \                                                                      */
#define LineLengthExx(pt,single,eol) LineLengthExEx( pt,single,8,eol)
/* \    Parameters
   Text segment :  PTEXT line or segment to get the length of
   single :        boolean, if set then only a single segment is
                   measured, otherwise all segments from this to
                   the end are measured.                         */
#define LineLengthEx(pt,single) LineLengthExx( pt,single,NULL)
/* Computes the length of characters in a line, if all segments
   in the line are flattened into a single word.                */
#define LineLength(pt) LineLengthEx( pt, FALSE )
/* Collapses an indirect segment or a while list of segments
   into a single segment with content expanded. When passed to
   things like TextParse and Burst, segments have their
   positioning encoded to counters for tabs and spaces; the
   segment itself contains only text without whitespace. Buildline
   expands these segments into their plain text representation.
   Parameters
   pt :        pointer to a PTEXT segment.
   bSingle :   if TRUE, build only the first segment. If the
               segment is indirect, builds entire content of
               indirect.
   nTabsize :  how wide tabs are. When written into a line, tabs
               are written as spaces. (maybe if 0, tabs are
               emitted directly?)
   pEOL :      the segment to use to represent an end of line. Often
               this is a SegCreate(0) segment.                       */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  BuildLineExEx( PTEXT pt, LOGICAL bSingle, int nTabsize, PTEXT pEOL DBG_PASS );
/* Collapses an indirect segment or a while list of segments
into a single segment with content expanded. When passed to
things like TextParse and Burst, segments have their
positioning encoded to counters for tabs and spaces; the
segment itself contains only text without whitespace. Buildline
expands these segments into their plain text representation.
Parameters
pt :        pointer to a PTEXT segment.
bSingle :   if TRUE, build only the first segment. If the
segment is indirect, builds entire content of
indirect.
pEOL :      the segment to use to represent an end of line. Often
this is a SegCreate(0) segment.                       */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  BuildLineExx( PTEXT pt, LOGICAL bSingle, PTEXT pEOL DBG_PASS );
/* <combine sack::containers::text::BuildLineExEx@PTEXT@LOGICAL@int@PTEXT pEOL>
\ \                                                                          */
#define BuildLineExx(from,single,eol) BuildLineExEx( from,single,8,NULL DBG_SRC )
/* <combine sack::containers::text::BuildLineExEx@PTEXT@LOGICAL@int@PTEXT pEOL>
   \ \                                                                          */
#define BuildLineEx(from,single) BuildLineExEx( from,single,8,NULL DBG_SRC )
/* <combine sack::containers::text::BuildLineExEx@PTEXT@LOGICAL@int@PTEXT pEOL>
   \     Flattens all segments in a line to a single segment result.
*/
#define BuildLine(from) BuildLineExEx( from, FALSE,8,NULL DBG_SRC )
//
// text parse - more generic flavor of burst.
//
//static CTEXTSTR normal_punctuation=WIDE("\'\"\\({[<>]}):@%/,;!?=*&$^~#`");
// filter_to_space " \t"
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  TextParse ( PTEXT input, CTEXTSTR punctuation, CTEXTSTR filter_tospace, int bTabs, int bSpaces  DBG_PASS );
/* normal_punctuation=WIDE("'"\\({[\<\>]}):@%/,;!?=*&amp;$^~#`");
   Process a line of PTEXT into another line of PTEXT, but with
   words parsed as appropriate for common language.
   Parameters
   input\ :  pointer to a list of PTEXT segments to parse.
   Remarks
   Burst is a simple method of breaking a sentence into its word
   and phrase parts. It collapses space and tabs before words
   into the word. Any space representation is space preceeding
   the word. Sentences are also broken on any punctuation.
   "({[\<\>]})'";;.,/?\\!@#$%^&amp;*=" for instances. + and - are
   treated specially if they prefix numbers, otherwise they are
   also punctuation. Also groups of '.' like '...' are kept
   together. if the '.' is in a number, it is stored as part of
   the number. Otherwise a '.' used in an abbreviation like P.S.
   will be a '.' with 0 spaces followed by a segment also with 0
   spaces. (unless it's the lsat one)
   so initials are encoded badly.
   Bugs
   There is an exploit in the parser such that . followed by a
   number will cause fail to break into seperate words. This is
   used by configuration scripts to write binary blocks, and
   read them back in, having the block parsed into a segment
   correctly.
   See Also
   <link sack::containers::text::TextParse@PTEXT@CTEXTSTR@CTEXTSTR@int@int bSpaces, TextParse> */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  burstEx( PTEXT input DBG_PASS);
/* <combine sack::containers::text::burstEx@PTEXT input>
   \ \                                                   */
#define burst( input ) burstEx( (input) DBG_SRC )
/* Compares a couple lists of text segments.
   Parameters
   pt1 :      pointer to a phrase
   single1 :  use only the first word, not the whole phrase
   pt2 :      pointer to a phrase
   single2 :  use only the first segment, not the whole phrase
   bExact :   if FALSE, match case insensitive, otherwise match
              exact case.                                       */
TYPELIB_PROC  int TYPELIB_CALLTYPE  CompareStrings( PTEXT pt1, int single1
                            , PTEXT pt2, int single2
                            , int bExact );
/* This removes indirect segments, replacing them with their
   indirect content.
   Parameters
   pLine :  pointer to a PTEXT segment list to flatten.      */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  FlattenLine ( PTEXT pLine );
/* Steps through a linked list of segments, just a convenient
   for loop wrapper.                                          */
#define FORALLTEXT(start,var)  for(var=start;var; var=NEXTLINE(var))
/* returns number of characters filled into output.  Output needs to be at maximum 6 chars */
TYPELIB_PROC int TYPELIB_CALLTYPE ConvertToUTF8( char *output, TEXTRUNE rune );
/* returns number of characters filled into output.  Output needs to be at maximum 6 chars;  if overlong is set
   characters are deliberatly padded to be overlong */
TYPELIB_PROC int TYPELIB_CALLTYPE ConvertToUTF8Ex( char *output, TEXTRUNE rune, LOGICAL overlong );
/* returns number of wchar filled into output.  Output needs to be at maximum 2 wchar. */
TYPELIB_PROC int TYPELIB_CALLTYPE ConvertToUTF16( wchar_t *output, TEXTRUNE rune );
TYPELIB_PROC TEXTRUNE TYPELIB_CALLTYPE GetUtfChar( const char **from );
TYPELIB_PROC TEXTRUNE TYPELIB_CALLTYPE GetUtfCharIndexed( const char *from, size_t *index, size_t length );
TYPELIB_PROC TEXTRUNE TYPELIB_CALLTYPE GetPriorUtfChar( const char *start, const char **from );
TYPELIB_PROC TEXTRUNE TYPELIB_CALLTYPE GetPriorUtfCharIndexed( const char *from, size_t *index );
TYPELIB_PROC TEXTRUNE TYPELIB_CALLTYPE GetUtfCharW( const wchar_t **from );
TYPELIB_PROC TEXTRUNE TYPELIB_CALLTYPE GetUtfCharIndexedW( const wchar_t *from, size_t *index );
TYPELIB_PROC TEXTRUNE TYPELIB_CALLTYPE GetPriorUtfCharW( const wchar_t *start, const wchar_t **from );
TYPELIB_PROC TEXTRUNE TYPELIB_CALLTYPE GetPriorUtfCharIndexedW( const wchar_t *from, size_t *index );
TYPELIB_PROC size_t TYPELIB_CALLTYPE GetDisplayableCharacterCount( const char *string, size_t max_bytes );
TYPELIB_PROC CTEXTSTR TYPELIB_CALLTYPE GetDisplayableCharactersAtCount( const char *string, size_t character_index );
TYPELIB_PROC size_t TYPELIB_CALLTYPE  GetDisplayableCharacterBytes( const char *string, size_t character_count );
/* You Must Deallocate the result */
TYPELIB_PROC char * TYPELIB_CALLTYPE WcharConvert_v2 ( const wchar_t *wch, size_t len, size_t *outlen DBG_PASS );
/* You Must Deallocate the result */
TYPELIB_PROC  char * TYPELIB_CALLTYPE  WcharConvertExx ( const wchar_t *wch, size_t len DBG_PASS );
/* You Must Deallocate the result */
TYPELIB_PROC  char * TYPELIB_CALLTYPE  WcharConvertEx ( const wchar_t *wch DBG_PASS );
/* <combine sack::containers::text::WcharConvertExx@wchar_t *@size_t len>
   \ \                                                                    */
#define WcharConvertLen(s,len) WcharConvertExx(s, len DBG_SRC )
/* <combine sack::containers::text::WcharConvertExx@wchar_t *@size_t len>
   \ \                                                                    */
#define WcharConvert(s) WcharConvertEx(s DBG_SRC )
/* You Must Deallocate the result */
TYPELIB_PROC wchar_t * TYPELIB_CALLTYPE CharWConvertExx ( const char *wch, size_t len DBG_PASS );
/* Convert wchar_t strings to char strings.
   Parameters
   string :    wchar_t string to convert
   DBG_PASS :  debug file and line information
   Returns
   A char * string. This string must be Release()'ed or
   Deallocate()'ed by the user.                         */
TYPELIB_PROC wchar_t * TYPELIB_CALLTYPE CharWConvertEx ( const char *wch DBG_PASS );
/* <combine sack::containers::text::CharWConvertExx@char *@size_t len>
   \ \                                                                 */
#define CharWConvertLen(s,len) CharWConvertExx(s,len DBG_SRC )
/* <combine sack::containers::text::CharWConvertExx@char *@size_t len>
   \ \                                                                 */
#define CharWConvert(s) CharWConvertEx(s DBG_SRC )
//--------------------------------------------------------------------------
/* This is a string collector type.  It has an interface to be able to vtprintf( vartext, "format string", ... ); which appends the specified string to the collected text.
  Example
   PVARTEXT pvt = VarTextCreate();
   vtprintf( pvt, "hello world!" );
   {
      PTEXT text = VarTextGet( pvt );
	  printf( "Text is : %s(%d)", GetText( text ), GetTextSize( text ) );
	  LineRelease( text );
   }
   VarTextDestroy( &pvt );
   */
typedef struct vartext_tag *PVARTEXT;
/* Creates a variable text collector. Allows specification of
   initial size and amount to expand by. SQL Command line sample
   utility uses this and allocates like 10,000 initial and sets
   expand as 40,000, because it expects to build very large
   strings, and expansion of 32 at a time is ludicrous; if the
   space required is more than the expansion factor, then it is
   expanded by the amount required plus the expansion factor.
   Parameters
   initial :   amount of initial buffer
   exand_by :  how much to expand the buffer by when more room
               is needed
   DBG_PASS :  debug file and line parameters.                   */
TYPELIB_PROC  PVARTEXT TYPELIB_CALLTYPE  VarTextCreateExEx ( uint32_t initial, uint32_t expand DBG_PASS );
/* <combine sack::containers::text::VarTextCreateExEx@uint32_t@uint32_t expand>
   \ \                                                                */
#define VarTextCreateExx(i,e) VarTextCreateExEx(i,e DBG_SRC )
/* <combine sack::containers::text::VarTextCreateExEx@uint32_t@uint32_t expand>
   Creates a variable text collector. Default initial size and
   expansion is 0 and 32.
                                                                      */
TYPELIB_PROC  PVARTEXT TYPELIB_CALLTYPE  VarTextCreateEx ( DBG_VOIDPASS );
/* The simplest, most general way to create a PVARTEXT
   collector. The most extended vartext creator allows
   specification of how long the initial buffer is, and how much
   the buffer expands by when required. This was added to
   optimize building HUGE SQL queries, working withing 100k
   buffers that expanded by 50k at a time was a lot less
   operations than expanding 32 bytes or something at a time.    */
#define VarTextCreate() VarTextCreateEx( DBG_VOIDSRC )
/* Empties and destroys all resources associated with the
   variable text collector.
   Parameters
   pvt * :     address of a PVARTEXT reference to destroy. Sets
               the pointer to NULL when it's destroyed.
   DBG_PASS :  debugging file and line parameters
   Example
   <code lang="c++">
   {
      PVARTEXT pvt = VarTextCreate();
      VarTextDestroy( &amp;pvt );
   }
   void Function( int something DBG_PASS )
   {
      pvt = VarTextCreateEx( DBG_RELAY );
      VarTextDestroyEx( &amp;pvt DBG_RELAY );
   }
   </code>
   C++ Syntax
   \ \                                                          */
TYPELIB_PROC  void TYPELIB_CALLTYPE  VarTextDestroyEx ( PVARTEXT* DBG_PASS );
/* Destroy a VarText collector. */
#define VarTextDestroy(pvt) VarTextDestroyEx( pvt DBG_SRC )
/* \Internal function - used to initialize a VARTEXT structure. */
TYPELIB_PROC  void TYPELIB_CALLTYPE  VarTextInitEx( PVARTEXT pvt DBG_PASS);
/* Probably should not be exported. Initializes a VARTEXT
   structure to prepare it for subsequent VarText operations. */
#define VarTextInit(pvt) VarTextInitEx( (pvt) DBG_SRC )
/* Empties a PVARTEXT structure.
   Parameters
   pvt :  PVARTEXT to empty.     */
TYPELIB_PROC  void TYPELIB_CALLTYPE  VarTextEmptyEx( PVARTEXT pvt DBG_PASS);
/* <combine sack::containers::text::VarTextEmptyEx@PVARTEXT pvt>
   \ \                                                           */
#define VarTextEmpty(pvt) VarTextEmptyEx( (pvt) DBG_SRC )
/* Add a single character to a vartext collector.
   Note
   \    Parameters
   pvt :       PVARTEXT to add character to
   c :         character to add
   DBG_PASS :  optional debug information         */
TYPELIB_PROC  void TYPELIB_CALLTYPE  VarTextAddCharacterEx( PVARTEXT pvt, TEXTCHAR c DBG_PASS );
TYPELIB_PROC  void TYPELIB_CALLTYPE  VarTextAddRuneEx( PVARTEXT pvt, TEXTRUNE c, LOGICAL overlong DBG_PASS );
/* Adds a single character to a PVARTEXT collector.
   Example
   <code lang="c++">
   PVARTEXT pvt = VarTextCreate();
   VarTextAddCharacter( pvt, 'a' );
   </code>                                          */
#define VarTextAddCharacter(pvt,c) VarTextAddCharacterEx( (pvt),(c) DBG_SRC )
/* Adds a single rune to a PVARTEXT collector. (may be multiple characters convert to UTF8)
   Example
   <code lang="c++">
   PVARTEXT pvt = VarTextCreate();
   VarTextAddRune( pvt, 'a' );
   </code>                                          */
#define VarTextAddRune(pvt,c) VarTextAddRuneEx( (pvt),(c), FALSE DBG_SRC )
/* Adds a length of data to the vartext. This allows strings
   with nuls included to be added.
   Parameters
   pvt :       PVARTEXT to add data to
   block :     pointer to data to add
   size :      length of data block to add
	DBG_PASS :  optional file and line parameters             */
#define VARTEXT_ADD_DATA_NULTERM ((size_t)0xFF000000)
TYPELIB_PROC  void TYPELIB_CALLTYPE  VarTextAddDataEx( PVARTEXT pvt, CTEXTSTR block, size_t length DBG_PASS );
/* Adds a single character to a PVARTEXT collector.
   Example
   <code lang="c++">
   PVARTEXT pvt = VarTextCreate();
   VarTextAddData( pvt, "test one", 8 );
   </code>                                          */
#define VarTextAddData(pvt,block,length) VarTextAddDataEx( (pvt),(block),(length) DBG_SRC )
/* Commits the currently collected text to segment, and adds the
   segment to the internal line accumulator.
		 returns true if any data was added...
       move any collected text to commit... */
TYPELIB_PROC  LOGICAL TYPELIB_CALLTYPE  VarTextEndEx( PVARTEXT pvt DBG_PASS );
/* <combine sack::containers::text::VarTextEndEx@PVARTEXT pvt>
   \ \                                                         */
#define VarTextEnd(pvt) VarTextEndEx( (pvt) DBG_SRC )
/* Gets the length of the current collection in the VARTEXT.
   Parameters
   pvt :  PVARTEXT collector to get the length.              */
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE  VarTextLength( PVARTEXT pvt );
/* Gets the text segment built in the VarText. The PVARTEXT is
   set to empty. Clears the collector.
   Parameters
   pvt :  PVARTEXT to get text from.                           */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  VarTextGetEx( PVARTEXT pvt DBG_PASS );
/* <combine sack::containers::text::VarTextGetEx@PVARTEXT pvt>
   \ \                                                         */
#define VarTextGet(pvt) VarTextGetEx( (pvt) DBG_SRC )
/* Used to look at the vartext collector and get the current
   collection. Does not clear the collector.
   Parameters
   pvt :       PVARTEXT collector to peek at
   DBG_PASS :  debugging file and line parameters
   Return Value List
   NULL :      No data
   not NULL :  text segment which is in the collector.       */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  VarTextPeekEx ( PVARTEXT pvt DBG_PASS );
/* \Returns the PTEXT that is currently in a PVARTEXT. It does
   not alter the contents of the PVARTEXT. Do not LineRelease
   this peeked value.                                          */
#define VarTextPeek(pvt) VarTextPeekEx( (pvt) DBG_SRC )
/* Increases the internal storage size of the variable text
   collector.
   Parameters
   pvt :       the var text collector to expand
   amount :    amount of size to expand the collector
   DBG_PASS :  debugging file and line parameters           */
TYPELIB_PROC  void TYPELIB_CALLTYPE  VarTextExpandEx( PVARTEXT pvt, INDEX size DBG_PASS );
/* Add a specified number of characters to the amount of space
   in the VARTEXT collector.                                   */
#define VarTextExpand(pvt, sz) VarTextExpandEx( (pvt), (sz) DBG_SRC )
//TYPELIB_PROC  int vtprintfEx( PVARTEXT pvt DBG_PASS TYPELIB_CALLTYPE  CTEXTSTR format, ... ;
// note - don't include format - MUST have at least one parameter passed to ...
//#define vtprintf(pvt, ...) vtprintfEx( (pvt) DBG_SRC, __VA_ARGS__ )
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE  vtprintfEx( PVARTEXT pvt, CTEXTSTR format, ... );
/* <combine sack::containers::text::vtprintfEx@PVARTEXT@CTEXTSTR@...>
   Note                                                               */
#define vtprintf vtprintfEx
/* variable argument VARTEXT printf. Is passed a PVARTEXT to
   collect the formatted output using printf sort of formatting. */
TYPELIB_PROC  INDEX TYPELIB_CALLTYPE  vvtprintf( PVARTEXT pvt, CTEXTSTR format, va_list args );
/* encode binary buffer into base64 encoding.
   outsize is updated with the length of the buffer.
 */
TYPELIB_PROC  TEXTCHAR * TYPELIB_CALLTYPE  EncodeBase64Ex( const uint8_t* buf, size_t length, size_t *outsize, const char *encoding );
/* decode base64 buffer into binary buffer
   outsize is updated with the length of the buffer.
   result should be Release()'d
 */
TYPELIB_PROC  uint8_t * TYPELIB_CALLTYPE  DecodeBase64Ex( const char* buf, size_t length, size_t *outsize, const char *encoding );
/* xor a base64 encoded string over a utf8 string, keeping the utf8 characters in the same length...
   although technically this can result in invalid character encoding where upper bits get zeroed
   result should be Release()'d
*/
TYPELIB_PROC  char * TYPELIB_CALLTYPE  u8xor( const char *a, size_t alen, const char *b, size_t blen, int *ofs );
/* xor two base64 encoded strings, resulting in a base64 string
   result should be Release()'d
*/
TYPELIB_PROC  char * TYPELIB_CALLTYPE  b64xor( const char *a, const char *b );
//--------------------------------------------------------------------------
// extended command entry stuff... handles editing buffers with insert/overwrite/copy/paste/etc...
typedef struct user_input_buffer_tag {
	// -------------------- custom cmd buffer extension
  // position counter for pulling history; negative indexes are recalled commands.
	int nHistory;
  // a link queue which contains the prior lines of text entered for commands.
	PLINKQUEUE InputHistory;
 // set to TRUE when nHistory has wrapped...
	int   bRecallBegin;
   /* A exchange-lock variable for controlling access to the
      \history (so things aren't being read from it while it is
      scrolling old data out).                                  */
	uint32_t   CollectionBufferLock;
  // used to store index.. for insert type operations...
	INDEX CollectionIndex;
 // flag for whether we are inserting or overwriting
	int   CollectionInsert;
 // flag for whether we are inserting or overwriting
	int   storeCR;
 // used to store partial from GatherLine
	PTEXT CollectionBuffer;
 // called when a buffer is complete.
	void (CPROC*CollectedEvent)( uintptr_t psv, PTEXT text );
  // passed to the event callback when a line is completed
	uintptr_t psvCollectedEvent;
} USER_INPUT_BUFFER, *PUSER_INPUT_BUFFER;
/* Creates a buffer structure which behaves like the command
   line command recall queue.
                                                             */
TYPELIB_PROC  PUSER_INPUT_BUFFER TYPELIB_CALLTYPE  CreateUserInputBuffer ( void );
/* Destroy a created user input buffer. */
TYPELIB_PROC  void TYPELIB_CALLTYPE  DestroyUserInputBuffer ( PUSER_INPUT_BUFFER *pci );
// negative with SEEK_SET is SEEK_END -nPos
enum CommandPositionOps {
	// defined that the x,y position in the segment should be used for absolute positioning.
   // can also be SEEK_SET
 COMMAND_POS_SET = 0,
 // defined that the x,y position in the segment should be used for relative positioning.
 // can also be SEEK_CUR
 COMMAND_POS_CUR = 1
};
/* Updates the current input position, for things like input,
   etc. Some external process indicates where in the line to set
   the cursor position.                                          */
TYPELIB_PROC  LOGICAL TYPELIB_CALLTYPE  SetUserInputPosition ( PUSER_INPUT_BUFFER pci, int nPos, int whence );
// bInsert < 0 toggle insert.  bInsert == 0 clear isnert(set overwrite) else
// set insert (clear overwrite )
TYPELIB_PROC  void TYPELIB_CALLTYPE  SetUserInputInsert ( PUSER_INPUT_BUFFER pci, int bInsert );
TYPELIB_PROC  void TYPELIB_CALLTYPE  SetUserInputSaveCR( PUSER_INPUT_BUFFER pci, int bSaveCR );
/* Get the next command in the queue in the speicifed direction
   Parameters
   pci :  pointer to command input buffer
   bUp :  if TRUE \- get older command; else get the newer
          command.                                              */
TYPELIB_PROC  void TYPELIB_CALLTYPE  RecallUserInput ( PUSER_INPUT_BUFFER pci, int bUp );
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  GetUserInputLine( PUSER_INPUT_BUFFER pOutput );
/* Add a buffer to the history buffer.
                                       */
TYPELIB_PROC  void TYPELIB_CALLTYPE  EnqueUserInputHistory ( PUSER_INPUT_BUFFER pci, PTEXT pHistory );
/* Arbitrary PTEXT blocks are fed to the user input queue with
   this.
   Parameters
   pci :     pointer to command buffer
   stroke :  the stroke to add to the buffer (may be a whole
             String or linked list of segments). or NULL if
             getting existing input...
   Return Value List
   NULL :      There is no command available \- no text followed
               by a newline.
   not NULL :  A command line collected from the input text. There
               may be multiple commands in a single 'stroke'
               buffer.
   Example
   This may be used something like .... to add the storke to the
   \input buffer, and while there is a result, get the result
   from the buffer.
   <code lang="c++">
   {
       PUSER_INPUT_BUFFER pci = CreateUserInputBuffer();
       PTEXT result;
       for( result = GatherUserInput( pci, new_stroke ); result; result = GatherUserInput( pci, NULL ) )
       {
       }
   }
   </code>                                                                                               */
TYPELIB_PROC  PTEXT TYPELIB_CALLTYPE  GatherUserInput ( PUSER_INPUT_BUFFER pci, PTEXT stroke );
/* delete 1 character at current user input index */
TYPELIB_PROC  void TYPELIB_CALLTYPE  DeleteUserInput( PUSER_INPUT_BUFFER pci );
/* Converts ascii character set to ebcidc. */
TYPELIB_PROC TEXTSTR TYPELIB_CALLTYPE  ConvertAsciiEbdic( TEXTSTR text, INDEX length );
/* Routine to convert from ebcdic character set to ascii. */
TYPELIB_PROC TEXTSTR TYPELIB_CALLTYPE  ConvertEbcdicAscii( TEXTSTR text, INDEX length );
/* Converts ascii 85 to ascii */
TYPELIB_PROC TEXTSTR FtnATA( TEXTSTR buf );
/* Converts ascii character set to ascii 85  */
TYPELIB_PROC TEXTSTR ATFtnA( TEXTSTR buf );
/* Expand characters which are outside of standard ascii to URI
   compatible escapes.
   Parameters
   text :        Text to convert
   length :      max length of text to convert
   skip_slash :  if TRUE, keep slash characters as literal,
                 otherwise they get converted.                  */
TYPELIB_PROC TEXTSTR TYPELIB_CALLTYPE ConvertTextURI( CTEXTSTR text, INDEX length, int skip_slash );
/* Converts URI escape characters like %3B to the appropriate
   ascii characters. The resulting string must be released by
   the application.
   Parameters
   text :    TEXTCHAR * string to convert.
   length :  max length of text to convert.
   Example
   <code lang="c++">
   TEXTCHAR *sample = WIDE( "https://www.google.com/#hl=en&amp;sugexp=eqn&amp;cp=11&amp;gs_id=1a&amp;xhr=t&amp;q=%3B+%5C+%2B+:+";
   TEXTCHAR *result;
   \result = ConvertURIText( sample, StrLen( sample ) );
   \result == https://www.google.com/#hl=en&amp;sugexp=eqn&amp;cp=11&amp;gs_id=1a&amp;xhr=t&amp;q=;+\\+++:+
   </code>                                                                                                                        */
TYPELIB_PROC TEXTSTR TYPELIB_CALLTYPE ConvertURIText( CTEXTSTR text, INDEX length );
/* Parses a string that contains a comma separated list of
   strings into an array of strings. Has no quoting support, and
   simply parses on any comma in a string.
   Parameters
   \ \
                                                                 */
TYPELIB_PROC LOGICAL TYPELIB_CALLTYPE ParseStringVector( CTEXTSTR data, CTEXTSTR **pData, int *nData );
/* Parses a string with numbers separated by commas into an
   array of ints.                                           */
TYPELIB_PROC LOGICAL TYPELIB_CALLTYPE ParseIntVector( CTEXTSTR data, int **pData, int *nData );
#ifdef __cplusplus
 //namespace text {
}
#endif
//--------------------------------------------------------------------------
#ifdef __cplusplus
/* Binary tree object; supports custom sort routines
*/
	namespace BinaryTree {
#endif
/* This type defines a specific node in the tree. It is entirely
   private, and is a useless definition.                         */
typedef struct treenode_tag *PTREENODE;
/* Defines a Binary Tree.
   See Also
   <link CreateBinaryTree> */
typedef struct treeroot_tag *PTREEROOT;
/* This option may be passed to extended CreateBinaryTree
   methods to disallow adding of duplicates. Otherwise
   duplicates will be added; they will be added to the side of
   the node with the same value that has less children. Trees
   are created by default without this option, allowing the
   addition of duplicates.
   Example
   <code lang="c++">
   PTREEROOT = <link CreateBinaryTreeExtended>( BT_OPT_NODUPLICATES, NULL, NULL DBG_SRC );
   </code>                                                                                 */
#define BT_OPT_NODUPLICATES 1
/* Generic Compare is the type declaration for the callback routine for user custom comparisons.
  This routine should return -1 if new is less than old, it should return 1 if new is more than old, and it
  should return 0 if new and old are the same key. */
typedef int (CPROC *GenericCompare)( uintptr_t oldnode,uintptr_t newnode );
/* Signature for the user callback passed to CreateBinaryTreeEx
   that will be called for each node removed from the binary
   list.                                                        */
typedef void (CPROC *GenericDestroy)( CPOINTER user, uintptr_t key);
/* when adding a node if Compare is NULL the default method of a
   basic unsigned integer compare on the key value is done. if
   Compare is specified the specified key value of the orginal
   node (old) and of the new node (new) is added. Result of
   compare should be ( \<0 (lesser)) ( 0 (equal)) ( \>0
   (greater))
   Example
   <code lang="c++">
   int CPROC MyGenericCompare( uintptr_t oldnode,uintptr_t newnode )
   {
   </code>
   <code>
      if(oldnode\>newnode)
          return 1;
      else if(oldnode\<newnode)
          return -1;
      else return 0;
   </code>
   <code lang="c++">
      return (oldnode\>newnode)? 1
             \:(oldnode\<newnode)? -1
             \:0;
   }
   void CPROC MyGenericDestroy(POINTER user, uintptr_t key)
   {
      // do something custom with your user data and or key value
   }
   PTREEROOT tree = CreateBinaryTreeExtended( 0 // BT_OPT_NODUPLICATES
                                            , MyGenericCompare
                                            , MyGenericDestroy
                                            <link DBG_PASS, DBG_SRC> );
   </code>
   See Also
   <link CreateBinaryTreeExx>
   <link CreateBinaryTreeEx>
   <link CreateBinaryTree>                                               */
TYPELIB_PROC  PTREEROOT TYPELIB_CALLTYPE  CreateBinaryTreeExtended( uint32_t flags
															, GenericCompare Compare
															, GenericDestroy Destroy DBG_PASS);
/* This is the simpler case of <link CreateBinaryTreeExtended>,
   which does not make you pass DBG_SRC.
   Example
   <code lang="c++">
   PTREEROOT tree = CreateBinaryTreeExx( BT_OPT_NODUPLICATES, NULL, NULL );
   </code>                                                                  */
#define CreateBinaryTreeExx(flags,compare,destroy) CreateBinaryTreeExtended(flags,compare,destroy DBG_SRC)
/* Creates a binary tree, allowing specification of comparison
   and destruction routines.
   Example
   <code lang="c++">
   PTREEROOT tree = CreateBinaryTreeEx( <link CreateBinaryTreeExtended, MyGenericCompare>, <link CreateBinaryTreeExtended, MyGenericDestroy> );
   </code>                                                                                                                                      */
#define CreateBinaryTreeEx(compare,destroy) CreateBinaryTreeExx( 0, compare, destroy )
/* This is the simplest way to create a binary tree.
   The default compare routine treats 'key' as an integer value
   that is compared against other for lesser/greater condition.
   This tree also allows duplicates to be added.
   Example
   <code lang="c++">
   PTREEROOT tree = CreateBinaryTree();
   </code>                                                      */
#define CreateBinaryTree() CreateBinaryTreeEx( NULL, NULL )
/* \    Example
   <code lang="c++">
   PTREEROOT tree = CreateBinaryTree();
   DestroyBinaryTree( tree );
   tree = NULL;
   </code>                              */
TYPELIB_PROC  void TYPELIB_CALLTYPE  DestroyBinaryTree( PTREEROOT root );
/* Drops all the nodes in a tree so it becomes empty...
   \    Example
   <code lang="c++">
   PTREEROOT tree = CreateBinaryTree();
   ResetBinaryTree( tree );
   tree = NULL;
   </code>                              */
TYPELIB_PROC  void TYPELIB_CALLTYPE  ResetBinaryTree( PTREEROOT root );
/* Balances a binary tree. If data is added to a binary list in
   a linear way (from least to most), the tree can become
   unbalanced, and all be on the left or right side of data. This
   routine can analyze branches and perform rotations so that
   the tree can be discretely rebalanced.
   Example
   <code lang="c++">
   <link PTREEROOT> tree;
   // <link AddBinaryNode>...
   BalanceBinaryTree( tree );
   </code>                                                        */
TYPELIB_PROC  void TYPELIB_CALLTYPE  BalanceBinaryTree( PTREEROOT root );
/* \    See Also
   <link AddBinaryNode>
   <link DBG_PASS>
                        */
TYPELIB_PROC  int TYPELIB_CALLTYPE  AddBinaryNodeEx( PTREEROOT root
                                                   , CPOINTER userdata
                                                   , uintptr_t key DBG_PASS );
/* Adds a user pointer identified by key to a binary list.
   See Also
   <link BinaryTree::CreateBinaryTree, CreateBinaryTree>
   Example
   <code lang="c++">
   PTREEROOT tree = CreateBinaryTree();
   uintptr_t key = 1;
   POINTER data = NewArray( TEXTCHAR, 32 );
   AddBinaryNode( tree, data, key );
   </code>
   Parameters
   root :  PTREEROOT binary tree instance.
   data :  POINTER to some user object.
   key :   uintptr_t a integer type which can be used to identify
           the data. (used to compare in the tree).<p /><p />If
           the user has specified a custom comparison routine in
           an extended CreateBinaryTree(), then this value might
           be a pointer to some other data. Often the thing used
           to key into a binary tree is a <link CTEXTSTR>.
   Returns
   The tree may be created with <link BT_OPT_NODUPLICATES>, in
   which case this will result FALSE if the key is found
   duplicated in the list. Otherwise this returns TRUE. if the
   root parameter is NULL, the result is FALSE.                  */
#define AddBinaryNode(r,u,k) AddBinaryNodeEx((r),(u),(k) DBG_SRC )
//TYPELIB_PROC  int TYPELIB_CALLTYPE  AddBinaryNode( PTREEROOT root
//                                    , POINTER userdata
//                                    , uintptr_t key );
TYPELIB_PROC  void TYPELIB_CALLTYPE  RemoveBinaryNode( PTREEROOT root, POINTER use, uintptr_t key );
/* Search in a binary tree for the specified key.
   Returns
   user data POINTER if found, else NULL.
   Example
   <code lang="c++">
   PTREEROOT tree;
   void f( void )
   {
      CPOINTER mydata = FindInBinaryTree( tree, 5 );
      if( mydata )
      {
          // found '5' as the key in the tree
      }
   }
   </code>                                          */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  FindInBinaryTree( PTREEROOT root, uintptr_t key );
// result of fuzzy routine is 0 = match.  100 = inexact match
// 101 = no longer matching; result with last 100 match.
// 1 = no match, actual may be larger
// -1 = no match, actual may be lesser
// 100 = inexact match- checks nodes near for better match.
//
// Basically scans left and right from 100 match to find best match.
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  LocateInBinaryTree( PTREEROOT root, uintptr_t key
														, int (CPROC*fuzzy)( uintptr_t psv, uintptr_t node_key ) );
/* During FindInBinaryTree and LocateInBinaryTree, the last
   found result is stored. This function allows deletion of that
   node.
   Example
   <code lang="c++">
   FindInBinaryTree( tree, 5 );
   RemoveLastFoundNode( tree );
   </code>                                                       */
TYPELIB_PROC  void TYPELIB_CALLTYPE  RemoveLastFoundNode(PTREEROOT root );
/* Removes the currently browsed node from the tree.
   See Also
   <link GetChildNode>                               */
TYPELIB_PROC  void TYPELIB_CALLTYPE  RemoveCurrentNode(PTREEROOT root );
/* Basically this is meant to dump to a log, if the print
   function is passed as NULL, then the tree's contents are
   dumped to the log. It dumps a very cryptic log of how all
   nodes in the tree are arranged. But by allowing the user to
   provide a method to log his data and key, the logging is more
   meaningful based on the application. The basic code for
   managing trees and nodes works....
   Example
   <code>
   int ForEachNode( POINTER user, uintptr_t key )
   {
       // return not 1 to dump to log the internal tree structure
       return 0; // probably did own logging here, so don't log tree internal
   }
   <link PTREEROOT> tree;
   void f( void )
   {
       DumpTree( tree, ForEachNode );
   }
   </code>                                                                    */
TYPELIB_PROC  void TYPELIB_CALLTYPE  DumpTree( PTREEROOT root
                          , int (*Dump)( CPOINTER user, uintptr_t key ) );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetLeastNodeEx( PTREEROOT root, POINTER *cursor );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetLeastNode( PTREEROOT root );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetGreatestNodeEx( PTREEROOT root, POINTER *cursor );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetGreatestNode( PTREEROOT root );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetLesserNodeEx( PTREEROOT root, POINTER *cursor );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetLesserNode( PTREEROOT root );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetGreaterNodeEx( PTREEROOT root, POINTER *cursor );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetGreaterNode( PTREEROOT root );
/* \Returns the node that is set as 'current' in the tree. There
   is a cursor within the tree that can be used for browsing.
   See Also
   <link GetChildNode>                                           */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetCurrentNodeEx( PTREEROOT root, POINTER *cursor );
/* \Returns the node that is set as 'current' in the tree. There
   is a cursor within the tree that can be used for browsing.
   See Also
   <link GetChildNode>                                           */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetCurrentNode( PTREEROOT root );
/* This sets the current node cursor to the root of the node.
   See Also
   <link GetChildNode>                                        */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetRootNode( PTREEROOT root );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetParentNodeEx( PTREEROOT root, POINTER *cursor );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetParentNode( PTREEROOT root );
/* While browsing the tree after a find operation move to the
   next child node, direction 0 is lesser direction !0 is
   greater.
   Binary Trees have a 'current' cursor. These operations may be
   used to browse the tree.
   Example
   \    <code>
   // this assumes you have a tree, and it's fairly populated, then this demonstrates
   // all steps of browsing.
   POINTER my_data;
   // go to the 'leftmost' least node. (as determined by the compare callback)
   my_data = GetLeastNode( tree );
   // go to the 'rightmost' greatest node. (as determined by the compare callback)
   my_data = GetGreatestNode( tree );
   // move to the node that is less than the current node.  (move to the 'left')
   my_data = GetLesserNode( tree );
   // move to the node that is greater than the current node.  (move to the 'right')
   my_data = GetGreaterNode( tree );
   // follow the tree to the left down from here
   my_data = GetChildNode( tree, 0 );
   // follow the tree to the right down from here
   my_data = GetChildNode( tree, 1 );
   // follow the tree up to the node above the current one.
   //  (the one who's lesser or greater points at this)
   my_data = GetParentNode( tree );
   // this is probably the least useful, but someone clever might find a trick for it
   // Move back to the node we were just at.
   //  (makes the current the prior, and moves to what the prior was,
   //     but then it's just back and forth between the last two; it's not a stack ).
   my_data = GetPriorNode( tree );
   </code>
   A more practical example...
   <code lang="c++">
   POINTER my_data;
   for( my_data = GetLeastNode( tree );
        my_data;
        my_data = GetGreaterNode( tree ) )
   {
        // browse the tree from least to most.
   }
   </code>                                                                            */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetChildNode( PTREEROOT root, int direction );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetChildNodeEx( PTREEROOT root, POINTER *cursor, int direction );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetPriorNodeEx( PTREEROOT root, POINTER *cursor );
/* See Also
   <link GetChildNode> */
TYPELIB_PROC  CPOINTER TYPELIB_CALLTYPE  GetPriorNode( PTREEROOT root );
/* \Returns the total number of nodes in the tree.
   Example
   <code lang="c++">
   int total_nodes = GetNodeCount(tree);
   </code>                                         */
TYPELIB_PROC  int TYPELIB_CALLTYPE  GetNodeCount ( PTREEROOT root );
 // returns a shadow of the original.
TYPELIB_PROC  PTREEROOT TYPELIB_CALLTYPE  ShadowBinaryTree( PTREEROOT root );
#ifdef __cplusplus
 //namespace BinaryTree {
	}
#endif
//--------------------------------------------------------------------------
#ifdef __cplusplus
namespace family {
#endif
/* A family tree structure, for tracking elements that have
   multiple children.
                                                            */
typedef struct familyroot_tag *PFAMILYTREE;
typedef struct familynode_tag *PFAMILYNODE;
/* <unfinished>
   Incomplete Work in progress (maybe) */
TYPELIB_PROC  PFAMILYTREE TYPELIB_CALLTYPE  CreateFamilyTree ( int (CPROC *Compare)(uintptr_t key1, uintptr_t key2)
															, void (CPROC *Destroy)(POINTER user, uintptr_t key) );
/* <unfinished>
   Incomplete, Family tree was never completed. */
TYPELIB_PROC  POINTER TYPELIB_CALLTYPE  FamilyTreeFindChild ( PFAMILYTREE root
														  , uintptr_t psvKey );
/* <unfinished>
   Incomplete, Family tree was never completed. */
TYPELIB_PROC  POINTER  TYPELIB_CALLTYPE FamilyTreeFindChildEx ( PFAMILYTREE root, PFAMILYNODE root_node
													 , uintptr_t psvKey );
/* Resets the search cursors in the tree... */
TYPELIB_PROC  void TYPELIB_CALLTYPE  FamilyTreeReset ( PFAMILYTREE *option_tree );
/* Resets the content of the tree (should call destroy methods, at this time it does not) */
TYPELIB_PROC  void TYPELIB_CALLTYPE  FamilyTreeClear ( PFAMILYTREE option_tree );
/* <unfinished>
   Incomplete Work in progress (maybe) */
TYPELIB_PROC  PFAMILYNODE TYPELIB_CALLTYPE  FamilyTreeAddChild ( PFAMILYTREE *root, PFAMILYNODE parent, POINTER userdata, uintptr_t key );
TYPELIB_PROC LOGICAL TYPELIB_CALLTYPE FamilyTreeForEachChild( PFAMILYTREE root, PFAMILYNODE node
			, LOGICAL (CPROC *ProcessNode)( uintptr_t psvForeach, uintptr_t psvNodeData )
			, uintptr_t psvUserData );
TYPELIB_PROC LOGICAL TYPELIB_CALLTYPE FamilyTreeForEach( PFAMILYTREE root, PFAMILYNODE node
			, LOGICAL (CPROC *ProcessNode)( uintptr_t psvForeach, uintptr_t psvNodeData, int level )
			, uintptr_t psvUserData );
#ifdef __cplusplus
 //namespace family {
}
#endif
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
#ifdef __cplusplus
//} // extern "c"
 // namespace containers
}
 // namespace sack
}
using namespace sack::containers::link_stack;
using namespace sack::containers::data_stack;
using namespace sack::containers::data_list;
using namespace sack::containers::data_queue;
using namespace sack::containers::queue;
using namespace sack::containers::BinaryTree;
using namespace sack::containers::text;
using namespace sack::containers::message;
using namespace sack::containers::sets;
using namespace sack::containers::family;
using namespace sack::containers;
#else
// should 'class'ify these things....
#endif
#ifndef _TYPELIBRARY_SOURCE
//#undef TYPELIB_PROC // we don't need this symbol after having built the right prototypes
#endif
#endif
// $Log: sack_typelib.h,v $
// Revision 1.99  2005/07/10 23:56:25  d3x0r
// Fix types for C++...
//
//
// Revision 1.39  2003/03/25 08:38:11  panther
// Add logging
//
#ifdef __cplusplus
namespace sack {
#endif
#ifndef IS_DEADSTART
// this is always statically linked with libraries, so they may contact their
// core executable to know when it's done loading everyone else also...
#  ifdef __cplusplus
extern "C"
#  endif
#  if defined( WIN32 ) && !defined( __STATIC__ ) && !defined( __ANDROID__ )
#    ifdef __NO_WIN32API__
// DllImportAttribute ?
#    else
__declspec(dllimport)
#    endif
#  else
#ifndef __cplusplus
extern
#endif
#  endif
/* a function true/false which indicates whether the root
   deadstart has been invoked already. If not, one should call
   InvokeDeadstart and MarkDeadstartComplete.
   <code lang="c++">
   int main( )
   {
       if( !is_deadstart_complete() )
       {
           InvokeDeadstart();
           MarkDeadstartComplete()
       }
       ... your code here ....
       return 0;  // or some other appropriate return.
   }
   </code>
   sack::app::deadstart                                        */
LOGICAL
#  if defined( __WATCOMC__ )
__cdecl
#  endif
is_deadstart_complete( void );
#endif
/* Define a routine to call for exit().  This triggers specific code to handle shutdown event registration */
#ifndef NO_EXPORTS
#  ifdef SACK_BAG_CORE_EXPORTS
EXPORT_METHOD
#  else
IMPORT_METHOD
#  endif
#else
#  ifndef SACK_BAG_CORE_EXPORTS
	extern
#  endif
#endif
		void CPROC BAG_Exit( int code );
#ifndef NO_SACK_EXIT_OVERRIDE
#define exit(n) BAG_Exit(n)
#endif
#ifdef __cplusplus
 //SACK_NAMESPACE_END // namespace sack {
}
#endif
// this should become common to all libraries and programs...
//#include <construct.h> // pronounced 'kahn-struct'
/*
 *  Crafted by James Buckeyne
 *  Part of SACK github.com/d3x0r/SACK
 *
 *   (c) Freedom Collective 2000-2006++, 2016++
 *
 *   created to provide standard logging features
 *   lprintf( format, ... ); simple, basic
 *   if DEBUG, then logs to a file of the same name as the program
 *   if RELEASE most of this logging goes away at compile time.
 *
 *  standardized to never use int.
 */
#ifndef LOGGING_MACROS_DEFINED
#define LOGGING_MACROS_DEFINED
#define SYSLOG_API CPROC
#ifdef SYSLOG_SOURCE
#define SYSLOG_PROC EXPORT_METHOD
#else
#define SYSLOG_PROC IMPORT_METHOD
#endif
#ifdef __cplusplus
#define LOGGING_NAMESPACE namespace sack { namespace logging {
#define LOGGING_NAMESPACE_END } }
#else
#define LOGGING_NAMESPACE
#define LOGGING_NAMESPACE_END
#endif
#ifdef __cplusplus
	namespace sack {
/* Handles log output. Logs can be directed to UDP directed, or
   broadcast, or localhost, or to a file location, and under
   windows the debugging console log.
   lprintf
   SetSystemLog
   SystemLogTime
   there are options, when options code is enabled, which
   control logging output and format. Log file location can be
   specified generically for instance.... see Options.
	This namespace contains the logging functions. The most basic
   thing you can do to start logging is use 'lprintf'.
   <code lang="c++">
   lprintf( "My printf like format %s %d times", "string", 15 );
   </code>
   This function takes a format string and arguments compatible
   with vsnprintf. Internally strings are truncated to 4k
   length. (that is no single logging message can be more than
   4k in length).
   There are functions to control logging behavior.
   See Also
   SetSystemLog
   SystemLogTime
   SystemLogOptions
   lprintf
   _lprintf
   xlprintf
   _xlprintf
                                                                 */
		namespace logging {
#endif
/* \Parameters for SetSystemLog() to specify where the logging
   should go.                                                  */
enum syslog_types {
 // disable any log output.
SYSLOG_NONE     =   -1
,
SYSLOG_UDP      =    0
,
SYSLOG_FILE     =    1
,
 /* Set logging to output to a file. The file passed is a FILE*. This
   may be a FILE* like stdout, stderr, or some file the
   application opens.                                                */
SYSLOG_FILENAME =    2
,
 /* Set logging to go to a file, pass the string text name of the
   \file to open as the second parameter of SetSystemLog.        */
SYSLOG_SYSTEM   =    3
,
 /* Specify that logging should go to system (this actually means
   Windows system debugging channel. OutputDebugString() ).      */
SYSLOG_UDPBROADCAST= 4
// Allow user to specify a void UserCallback( char * )
// which recieves the formatted output.
,
SYSLOG_CALLBACK    = 5
,
 /* Send Logging to a specified user callback to handle. This
   lets logging go anywhere else that's not already thought of. */
SYSLOG_AUTO_FILE = SYSLOG_FILE + 100
 /* Send logging to a file. If the file is not open, open the
   \file. If no logging happens, no log file is created.     */
,
SYSLOG_SOCKET_SYSLOGD
};
#if !defined( NO_LOGGING )
#define DO_LOGGING
#endif
// this was forced, force no_logging off...
#if defined( DO_LOGGING )
#undef NO_LOGGING
#endif
#ifdef __LINUX__
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
SYSLOG_PROC  LOGICAL SYSLOG_API  IsBadReadPtr ( CPOINTER pointer, uintptr_t len );
#endif
SYSLOG_PROC  CTEXTSTR SYSLOG_API  GetPackedTime ( void );
//  returns the millisecond of the day (since UNIX Epoch) * 256 ( << 8 )
// the lowest 8 bits are the timezone / 15.
// The effect of the low [7/]8 bits being the time zone is that within the same millisecond
// UTC +0 sorts first, followed by +1, +2, ... etc until -14, -13, -12,... -1
// the low [7/]8 bits are the signed timezone
// (timezone could have been either be hr*60 + min (ISO TZ format)
// or in minutes (hr*60+mn) this would only take 7 bits
// one would think 8 bit shifts would be slightly more efficient than 7 bits.
// and sign extension for 8 bits already exists.
// - REVISION - timezone with hr*100 does not divide by 15 cleanly.
//     The timezone is ( hour*60 + min ) / 15 which is a range from -56 to 48
//     minimal representation is 7 bits (0 - 127 or -64 - 63)
//     still keeping 8 bits for shifting, so the effective range is only -56 to 48 of -128 to 127
// struct time_of_day {
//    uint64_t epoch_milliseconds : 56;
//    int64_t timezone : 8; divided by 15... hours * 60 / 15
// }
// returns the nanosecond of the day (since UNIX Epoch) and timezone/15
SYSLOG_PROC  int64_t SYSLOG_API GetTimeOfDay( uint64_t* tick, int8_t* ptz );
// binary little endian order; somewhat
typedef struct sack_expanded_time_tag
{
	uint16_t ms;
	uint8_t sc,mn,hr,dy,mo;
	uint16_t yr;
	int8_t zhr, zmn;
} SACK_TIME;
typedef struct sack_expanded_time_tag *PSACK_TIME;
// convert a integer time value to an expanded structure.
SYSLOG_PROC void     SYSLOG_API ConvertTickToTime( int64_t, PSACK_TIME st );
// convert a expanded time structure to a integer value.
SYSLOG_PROC int64_t SYSLOG_API ConvertTimeToTick( PSACK_TIME st );
// returns timezone as hours*100 + minutes.
// result is often negated?
SYSLOG_PROC  int SYSLOG_API GetTimeZone(void);
//
typedef void (CPROC*UserLoggingCallback)( CTEXTSTR log_string );
SYSLOG_PROC  void SYSLOG_API  SetSystemLog ( enum syslog_types type, const void *data );
SYSLOG_PROC  void SYSLOG_API  ProtectLoggedFilenames ( LOGICAL bEnable );
SYSLOG_PROC  void SYSLOG_API  SystemLogFL ( CTEXTSTR FILELINE_PASS );
//SYSLOG_PROC  void SYSLOG_API  SystemLogEx ( CTEXTSTR DBG_PASS );
//SYSLOG_PROC  void SYSLOG_API  SystemLog ( CTEXTSTR );
SYSLOG_PROC  void SYSLOG_API  BinaryToString( PVARTEXT pvt, const uint8_t* buffer, size_t size DBG_PASS );
SYSLOG_PROC  void SYSLOG_API  LogBinaryFL ( const uint8_t* buffer, size_t size FILELINE_PASS );
SYSLOG_PROC  void SYSLOG_API  LogBinaryEx ( const uint8_t* buffer, size_t size DBG_PASS );
SYSLOG_PROC  void SYSLOG_API  LogBinary ( const uint8_t* buffer, size_t size );
// logging level defaults to 1000 which is log everything
SYSLOG_PROC  void SYSLOG_API  SetSystemLoggingLevel ( uint32_t nLevel );
#if defined( _DEBUG ) || defined( _DEBUG_INFO )
/* Log a binary buffer. Logs lines representing 16 bytes of data
   at a time. The hex of each byte in a buffer followed by the
   text is logged.
   Example
   <code lang="c#">
   char sample[] = "sample string";
   LogBinary( sample, sizeof( sample ) );
   </code>
   Results with the following output in the log...
   <code>
    73 61 6D 70 6C 65 20 73 74 72 69 6E 67 00 sample string.
   </code>
   The '.' at the end of 'sample string' is a non printable
   character. characters 0-31 and 127+ are printed as '.'.       */
#define LogBinary(buf,sz) LogBinaryFL((uint8_t*)(buf),sz DBG_SRC )
#define SystemLogEx(buf,...) SystemLogFL(buf,##__VA_ARGS__)
#define SystemLog(buf)    SystemLogFL(buf DBG_SRC )
#else
// need to include the typecast... binary logging doesn't really care what sort of pointer it gets.
#define LogBinary(buf,sz) LogBinary((uint8_t*)(buf),sz )
//#define LogBinaryEx(buf,sz,...) LogBinaryFL(buf,sz FILELINE_NULL)
#define SystemLogEx(buf,...) SystemLogFL(buf FILELINE_NULL )
#define SystemLog(buf)    SystemLogFL(buf FILELINE_NULL )
#endif
// int result is useless... but allows this to be
// within expressions, which with this method should be easy.
typedef INDEX (CPROC*RealVLogFunction)(CTEXTSTR format, va_list args )
//#if defined( __GNUC__ )
//	__attribute__ ((__format__ (__vprintf__, 1, 2)))
//#endif
	;
typedef INDEX (CPROC*RealLogFunction)(CTEXTSTR format,...)
#if defined( __GNUC__ )
	__attribute__ ((__format__ (__printf__, 1, 2)))
#endif
	;
SYSLOG_PROC  RealVLogFunction SYSLOG_API  _vxlprintf ( uint32_t level DBG_PASS );
SYSLOG_PROC  RealLogFunction SYSLOG_API  _xlprintf ( uint32_t level DBG_PASS );
// utility function to format a cpu delta into a buffer...
// end-start is always printed... therefore tick_end-0 is
// print absolute time... formats as millisecond.NNN
SYSLOG_PROC  void SYSLOG_API  PrintCPUDelta ( TEXTCHAR *buffer, size_t buflen, uint64_t tick_start, uint64_t tick_end );
// return the current CPU tick
SYSLOG_PROC  uint64_t SYSLOG_API  GetCPUTick ( void );
// result in nano seconds - thousanths of a millisecond...
SYSLOG_PROC  uint32_t SYSLOG_API  ConvertTickToMicrosecond ( uint64_t tick );
SYSLOG_PROC  uint64_t SYSLOG_API  GetCPUFrequency ( void );
SYSLOG_PROC  CTEXTSTR SYSLOG_API  GetTimeEx ( int bUseDay );
SYSLOG_PROC  void SYSLOG_API  SetSyslogOptions ( FLAGSETTYPE *options );
/* When setting options using SetSyslogOptions() these are the
   defines for the bits passed.
   SYSLOG_OPT_OPENAPPEND - the file, when opened, will be opened
   for append.
   SYSLOG_OPT_OPEN_BACKUP - the file, if it exists, will be
   renamed automatically.
   SYSLOG_OPT_LOG_PROGRAM_NAME - enable logging the program
   executable (probably the same for all messages, unless they
   are network)
   SYSLOG_OPT_LOG_THREAD_ID - enables logging the unique process
   and thread ID.
   SYSLOG_OPT_LOG_SOURCE_FILE - enable logging source file
   information. See <link DBG_PASS>
   SYSLOG_OPT_MAX - used for declaring a flagset to pass to
   setoptions.                                                   */
enum system_logging_option_list {
		/* the file, when opened, will be opened for append.
		 */
		SYSLOG_OPT_OPENAPPEND
										  ,
  /* the file, if it exists, will be renamed automatically.
										  */
										  SYSLOG_OPT_OPEN_BACKUP
                                ,
 /* enable logging the program executable (probably the same for
                                   all messages, unless they are network)
                                                                                                */
                                 SYSLOG_OPT_LOG_PROGRAM_NAME
										  ,
 /* enables logging the unique process and thread ID.
										                                                       */
                                 SYSLOG_OPT_LOG_THREAD_ID
                                ,
 /* enable logging source file information. See <link DBG_PASS>
                                                                                               */
										   SYSLOG_OPT_LOG_SOURCE_FILE
										  ,
										  SYSLOG_OPT_MAX
};
// this solution was developed to provide the same
// functionality for compilers that refuse to implement __VA_ARGS__
// this therefore means that the leader of the function is replace
// and that extra parenthesis exist after this... therefore the remaining
// expression must be ignored... thereofre when defining a NULL function
// this will result in other warnings, about ignored, or meaningless expressions
# if defined( DO_LOGGING )
#  define vlprintf      _vxlprintf(LOG_NOISE DBG_SRC)
#  define lprintf       _xlprintf(LOG_NOISE DBG_SRC)
#  define _lprintf(file_line,...)       _xlprintf(LOG_NOISE file_line,##__VA_ARGS__)
#  define xlprintf(level)       _xlprintf(level DBG_SRC)
#  define vxlprintf(level)       _vxlprintf(level DBG_SRC)
# else
#  ifdef _MSC_VER
#   define vlprintf      (1)?(0):
#   define lprintf       (1)?(0):
#   define _lprintf(DBG_VOIDRELAY)       (1)?(0):
#   define xlprintf(level)       (1)?(0):
#   define vxlprintf(level)      (1)?(0):
#  else
#   define vlprintf(f,...)
/* use printf formating to output to the log. (log printf).
   Parameters
   Format :  Just like printf, the format string to print.
   ... :     extra arguments passed as required for the format.
   Example
   <code lang="c++">
      lprintf( "Test Logging %d %d", 13, __LINE__ );
   </code>                                                      */
#   define lprintf(f,...)
#   define  _lprintf(DBG_VOIDRELAY)       lprintf
#   define xlprintf(level) lprintf
#   define vxlprintf(level) lprintf
#  endif
# endif
#undef LOG_WARNING
#undef LOG_ADVISORIES
#undef LOG_INFO
// Defined Logging Levels
enum {
	  // and you are free to use any numerical value,
	  // this is a rough guideline for wide range
	  // to provide a good scaling for levels of logging
 // unless logging is disabled, this will be logged
	LOG_ALWAYS = 1
 // logging level set to 50 or more will cause this to log
	, LOG_ERRORS = 50
	,
 /* Specify a logging level which only ERROR level logging is
	   logged.                                                   */
 // logging level set to 50 or more will cause this to log
	 LOG_ERROR = LOG_ERRORS
	,
 // .......
	 LOG_WARNINGS = 500
	,
 // .......
	 LOG_WARNING = LOG_WARNINGS
   ,
 /* Use to specify that the log message is a warning level
      message.                                               */
    LOG_ADVISORY = 625
   ,
    LOG_ADVISORIES = LOG_ADVISORY
	,
 /* A symbol to specify to log Adviseries, Warnings and Error
	   level messages only.                                      */
	 LOG_INFO = 750
	  ,
 /* A moderate logging level, which is near maximum verbosity of
	     logging.                                                     */
	   LOG_NOISE = 1000
     ,
 /* Define that the message is just noisy - though verbosly
	  informative, it's level is less critical than even INFO.
	  default iS LOG_NOISE which is 1000, an ddefault for disabling most messages
	  is to set log level to 999.  Have to increase to 2000 to see debug, and this name
     has beviously
	  */
      LOG_LEVEL_DEBUG = 2000
	,
 /* Specify the message is of DEBUG importance, which is far
	   above even NOISY. If debug logging is enabled, all logging,
	   ERROR, WARNING, ADVISORY, INFO, NOISY and DEBUG will be
	   logged.                                                     */
 // not quite a negative number, but really big
	 LOG_CUSTOM = 0x40000000
	,
 /* A bit with LOG_CUSTOM might be enabled, and the lower bits
	   under 0x40000000 (all bits 0x3FFFFFFF ) can be used to
	   indicate a logging type. Then SetLoggingLevel can be passed a
	   mask of bits to filter types of messages.                     */
 // not quite a negative number, but really big
	 LOG_CUSTOM_DISABLE = 0x20000000
	// bits may be user specified or'ed with this value
	// such that ...
	// Example 1:SetSystemLoggingLevel( LOG_CUSTOM | 1 ) will
	// enable custom logging messages which have the '1' bit on... a logical
	// and is used to test the low bits of this value.
	// example 2:SetSystemLogging( LOG_CUSTOM_DISABLE | 1 ) will disable logging
	// of messages with the 1 bit set.
  // mask of bits which may be used to enable and disable custom logging
#define LOG_CUSTOM_BITS 0xFFFFFF
};
 // this is a flag set consisting of 0 or more or'ed symbols
enum SyslogTimeSpecifications {
 // disable time logging
 SYSLOG_TIME_DISABLE = 0,
 // enable is anything not zero.
 SYSLOG_TIME_ENABLE  = 1,
 // specify to log milliseconds
 SYSLOG_TIME_HIGH    = 2,
 // log the year/month/day also
 SYSLOG_TIME_LOG_DAY = 4,
 // log the difference in time instead of the absolute time
 SYSLOG_TIME_DELTA   = 8,
 // logs cpu ticks... implied delta
 SYSLOG_TIME_CPU     =16
};
/* Specify how time is logged. */
SYSLOG_PROC void SYSLOG_API SystemLogTime( uint32_t enable );
#ifndef NO_LOGGING
#define OutputLogString(s) SystemLogFL(s FILELINE_SRC )
/* Depricated. Logs a format string that takes 0 parameters.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log(s)                                   SystemLogFL( s FILELINE_SRC )
#else
#define OutputLogString(s)
/* Depricated. Logs a format string that takes 0 parameters.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log(s)
#endif
/* Depricated. Logs a format string that takes 1 parameter.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log1(s,p1)                               lprintf( s, p1 )
/* Depricated. Logs a format string that takes 2 parameters.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log2(s,p1,p2)                            lprintf( s, p1, p2 )
/* Depricated. Logs a format string that takes 3 parameters.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log3(s,p1,p2,p3)                         lprintf( s, p1, p2, p3 )
/* Depricated. Logs a format string that takes 4 parameters.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log4(s,p1,p2,p3,p4)                      lprintf( s, p1, p2, p3,p4)
/* Depricated. Logs a format string that takes 5 parameters.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log5(s,p1,p2,p3,p4,p5)                   lprintf( s, p1, p2, p3,p4,p5)
/* Depricated. Logs a format string that takes 6 parameters.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log6(s,p1,p2,p3,p4,p5,p6)                lprintf( s, p1, p2, p3,p4,p5,p6)
/* Depricated. Logs a format string that takes 7 parameters.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log7(s,p1,p2,p3,p4,p5,p6,p7)             lprintf( s, p1, p2, p3,p4,p5,p6,p7 )
/* Depricated. Logs a format string that takes 8 parameters.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log8(s,p1,p2,p3,p4,p5,p6,p7,p8)          lprintf( s, p1, p2, p3,p4,p5,p6,p7,p8 )
/* Depricated. Logs a format string that takes 9 parameters.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log9(s,p1,p2,p3,p4,p5,p6,p7,p8,p9)       lprintf( s, p1, p2, p3,p4,p5,p6,p7,p8,p9 )
/* Depricated. Logs a format string that takes 10 parameters.
   See Also
   <link sack::logging::lprintf, lprintf>                    */
#define Log10(s,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10)  lprintf( s, p1, p2, p3,p4,p5,p6,p7,p8,p9,p10 )
#ifdef __cplusplus
 //LOGGING_NAMESPACE_END
} }
using namespace sack::logging;
#endif
#endif
// these macros test the the range of integer and unsigned
// such that an unsigned > integer range is true if it is more than an maxint
// and signed integer < 0 is less than any unsigned value.
// the macro prefix SUS  or USS is the comparison type
// Signed-UnSigned and UnSigned-Signed  depending on the
// operand order.
// the arguments passed are variable a and b and the respective types of those
// if( SUS_GT( 324, int, 545, unsigned int ) ) {
//    is >
// }
/* Compare two numbers a>b, the first being signed and the second
   being unsigned. Compares only within overlapping ranges else
   \returns condition of non-overlap.
   at is the type of a and bt is the type of b
*/
#  define SUS_GT(a,at,b,bt)   (((a)<0)?0:(((bt)a)>(b)))
/* Compare two numbers a>b, the first being unsigned and the second
   being signed. Compares only within overlapping ranges else
   \returns condition of non-overlap.
   at is the type of a and bt is the type of b
*/
#  define USS_GT(a,at,b,bt)   (((b)<0)?1:((a)>((at)b)))
/* Compare two numbers, the first being unsigned and the second
   being signed. Compares only within overlapping ranges else
   \returns condition of non-overlap.
   at is the type of a and bt is the type of b
*/
#  define SUS_LT(a,at,b,bt)   (((a)<0)?1:(((bt)a)<(b)))
/* Compare two numbers, the first being unsigned and the second
   being signed. Compares only within overlapping ranges else
   \returns condition of non-overlap.
   at is the type of a and bt is the type of b
*/
#  define USS_LT(a,at,b,bt)   (((b)<0)?0:((a)<((at)b)))
/* Compare two numbers a>=b, the first being signed and the second
   being unsigned. Compares only within overlapping ranges else
   \returns condition of non-overlap.
   at is the type of a and bt is the type of b
*/
#  define SUS_GTE(a,at,b,bt)  (((a)<0)?0:(((bt)a)>=(b)))
/* Compare two numbers a>=b, the first being unsigned and the second
   being signed. Compares only within overlapping ranges else
   \returns condition of non-overlap.
   at is the type of a and bt is the type of b
*/
#  define USS_GTE(a,at,b,bt)  (((b)<0)?1:((a)>=((at)b)))
/* Compare two numbers a<=b, the first being signed and the second
   being unsigned. Compares only within overlapping ranges else
   \returns condition of non-overlap.
   at is the type of a and bt is the type of b
*/
#  define SUS_LTE(a,at,b,bt)  (((a)<0)?1:(((bt)a)<=(b)))
/* Compare two numbers a<=b, the first being unsigned and the second
   being signed. Compares only within overlapping ranges else
   \returns condition of non-overlap.
   at is the type of a and bt is the type of b
*/
#  define USS_LTE(a,at,b,bt)  (((b)<0)?0:((a)<=((at)b)))
#if 0
// simplified meanings of the macros
#  define SUS_GT(a,at,b,bt)   ((a)>(b))
#  define USS_GT(a,at,b,bt)   ((a)>(b))
#  define SUS_LT(a,at,b,bt)   ((a)<(b))
/* Compare two numbers, the first being unsigned and the second
   being signed. Compares only within overlapping ranges else
   \returns condition of non-overlap.                           */
#  define USS_LT(a,at,b,bt)   ((a)<(b))
#  define SUS_GTE(a,at,b,bt)  ((a)>=(b))
#  define USS_GTE(a,at,b,bt)  ((a)>=(b))
#  define SUS_LTE(a,at,b,bt)  ((a)<=(b))
#  define USS_LTE(a,at,b,bt)  ((a)<=(b))
#endif
#ifdef __cplusplus
using namespace sack;
using namespace sack::containers;
#endif
#endif
#endif
// incldue this first so we avoid a conflict.
// hopefully this comes from sack system?
/*
 *  Created by Jim Buckeyne
 *
 *  Purpose
 *    Generalization of system routines which began in
 *   dekware development.
 *   - Process control (load,start,stop)
 *   - Library runtime link control (load, unload)
 *
 */
#ifndef SYSTEM_LIBRARY_DEFINED
#define SYSTEM_LIBRARY_DEFINED
#ifdef SYSTEM_SOURCE
#define SYSTEM_PROC(type,name) EXPORT_METHOD type CPROC name
#else
#define SYSTEM_PROC(type,name) IMPORT_METHOD type CPROC name
#endif
#ifdef __LINUX__
// Hmm I thought that dlopen resulted in an int...
// but this doc says void * (redhat9)
//typedef void *HLIBRARY;
#else
//typedef HMODULE HLIBRARY;
#endif
#ifdef __cplusplus
#define _SYSTEM_NAMESPACE namespace system {
#define _SYSTEM_NAMESPACE_END }
#else
#define _SYSTEM_NAMESPACE
#define _SYSTEM_NAMESPACE_END
#endif
#define SACK_SYSTEM_NAMESPACE SACK_NAMESPACE _SYSTEM_NAMESPACE
#define SACK_SYSTEM_NAMESPACE_END _SYSTEM_NAMESPACE_END SACK_NAMESPACE_END
#ifndef UNDER_CE
#define HAVE_ENVIRONMENT
#endif
#ifdef __cplusplus
namespace sack {
  /*
    System interface namespace has Tasks, Environment, and dynamic library loading.
  */
	namespace system {
#endif
typedef struct task_info_tag *PTASK_INFO;
typedef void (CPROC*TaskEnd)(uintptr_t, PTASK_INFO task_ended);
typedef void (CPROC*TaskOutput)(uintptr_t, PTASK_INFO task, CTEXTSTR buffer, size_t size );
// Run a program completely detached from the current process
// it runs independantly.  Program does not suspend until it completes.
// Use GetTaskExitCode() to get the return code of the process
#define LPP_OPTION_DO_NOT_HIDE           1
// for services to launch normal processes (never got it to work; used to work in XP/NT?)
#define LPP_OPTION_IMPERSONATE_EXPLORER  2
#define LPP_OPTION_FIRST_ARG_IS_ARG      4
#define LPP_OPTION_NEW_GROUP             8
#define LPP_OPTION_NEW_CONSOLE          16
#define LPP_OPTION_SUSPEND              32
#define LPP_OPTION_ELEVATE              64
// use ctrl-break instead of ctrl-c for break (see also LPP_OPTION_USE_SIGNAL)
#define LPP_OPTION_USE_CONTROL_BREAK   128
// specify CREATE_NO_WINDOW in create process
#define LPP_OPTION_NO_WINDOW           256
// use process signal to kill process instead of ctrl-c or ctrl-break
#define LPP_OPTION_USE_SIGNAL          512
// This might be a useful windows option in some cases
#define LPP_OPTION_DETACH             1024
// this is a Linux option - uses forkpty() instead of just fork() to
// start a process - meant for interactive processes.
#define LPP_OPTION_INTERACTIVE        2048
struct environmentValue {
	char* field;
	char* value;
};
/**
 start process end monitoring based on a process ID
 */
SYSTEM_PROC( PTASK_INFO, MonitorTaskEx )( int pid, int flags, TaskEnd EndNotice, uintptr_t psv DBG_PASS );
#define MonitorTask(pid,flags,end,psv) MonitorTaskEx( pid, flags, end, psv DBG_SRC )
/**
 Launch a process...
 provides hoooks for task output, task end notification, flags control spawning behavior...
 */
SYSTEM_PROC( PTASK_INFO, LaunchPeerProgramExx )( CTEXTSTR program, CTEXTSTR path, PCTEXTSTR args
                                               , int flags
                                               , TaskOutput OutputHandler
                                               , TaskEnd EndNotice
                                               , uintptr_t psv
                                                DBG_PASS
                                               );
SYSTEM_PROC( PTASK_INFO, LaunchPeerProgram_v2 )( CTEXTSTR program, CTEXTSTR path, PCTEXTSTR args
                                               , int flags
                                               , TaskOutput OutputHandler
                                               , TaskOutput OutputHandler2
                                               , TaskEnd EndNotice
                                               , uintptr_t psv
                                               , PLIST envStrings
                                                DBG_PASS
                                               );
SYSTEM_PROC( PTASK_INFO, LaunchProgramEx )( CTEXTSTR program, CTEXTSTR path, PCTEXTSTR args, TaskEnd EndNotice, uintptr_t psv );
// launch a process, program name (including leading path), a optional path to start in (defaults to
// current process' current working directory.  And a array of character pointers to args
// args should be the NULL.
SYSTEM_PROC( PTASK_INFO, LaunchProgram )( CTEXTSTR program, CTEXTSTR path, PCTEXTSTR  args );
// abort task, no kill signal, sigabort basically.  Use StopProgram for a more graceful terminate.
// if (!StopProgram(task)) TerminateProgram(task) would be appropriate.
SYSTEM_PROC( uintptr_t, TerminateProgram )( PTASK_INFO task );
enum terminate_program_flags {
	TERMINATE_PROGRAM_CHAIN = 1,
	TERMINATE_PROGRAM_CHILDMOST = 2,
};
// abort task, no kill signal, sigabort basically.  Use StopProgram for a more graceful terminate.
// if (!StopProgram(task)) TerminateProgram(task) would be appropriate.
// additional flags from the enum terminate_program_flags may be used.
//   _CHAIN = terminate the whole chain, starting from child-most task.
//   _CHILDMOST = terminate the youngest child in the chain.
SYSTEM_PROC( uintptr_t, TerminateProgramEx )( PTASK_INFO task, int options );
SYSTEM_PROC( void, ResumeProgram )( PTASK_INFO task );
// get first address of program startup code(?) Maybe first byte of program code?
SYSTEM_PROC( uintptr_t, GetProgramAddress )( PTASK_INFO task );
// before luanchProgramEx, there was no userdata...
SYSTEM_PROC( void, SetProgramUserData )( PTASK_INFO task, uintptr_t psv );
// attempt to implement a method on windows that allows a service to launch a user process
// current systems don't have such methods
SYSTEM_PROC( void, ImpersonateInteractiveUser )( void );
// after launching a process should revert to a protected state.
SYSTEM_PROC( void, EndImpersonation )( void );
// generate a Ctrl-C to the task.
// maybe also signal systray icon
// maybe also signal process.lock region
// maybe end process?
// maybe then terminate process?
SYSTEM_PROC( LOGICAL, StopProgram )( PTASK_INFO task );
// ctextstr as its own type is a pointer so a
//  PcTextStr is a pointer to strings -
//   char ** - returns a quoted string if args have spaces (and escape quotes in args?)
SYSTEM_PROC( TEXTSTR, GetArgsString )( PCTEXTSTR pArgs );
// after a task has exited, this can return its code.
// undefined if task has not exited (probably 0)
SYSTEM_PROC( uint32_t, GetTaskExitCode )( PTASK_INFO task );
// returns the name of the executable that is this process (without last . extension   .exe for instance)
SYSTEM_PROC( CTEXTSTR, GetProgramName )( void );
// returns the path of the executable that is this process
SYSTEM_PROC( CTEXTSTR, GetProgramPath )( void );
// this approximates the install path, as the parent of a program in /bin/ so GetProgramPath()/..; otherwise is TARGET_INSTALL_PREFIX
SYSTEM_PROC( CTEXTSTR, GetInstallPath )( void );
// returns the path that was the working directory when the program started
SYSTEM_PROC( CTEXTSTR, GetStartupPath )( void );
// returns the path of the current sack library.
SYSTEM_PROC( CTEXTSTR, GetLibraryPath )( void );
// on windows, queries an event that indicates the system is rebooting.
SYSTEM_PROC( LOGICAL, IsSystemShuttingDown )( void );
// HandlePeerOutput is called whenever a peer task has generated output on stdout or stderr
//   - someday evolution may require processing stdout and stderr with different event handlers
SYSTEM_PROC( PTASK_INFO, LaunchPeerProgramEx )( CTEXTSTR program, CTEXTSTR path, PCTEXTSTR args
                                              , TaskOutput HandlePeerOutput
                                              , TaskEnd EndNotice
                                              , uintptr_t psv
                                               DBG_PASS
                                              );
#define LaunchPeerProgram(prog,path,args,out,end,psv) LaunchPeerProgramEx(prog,path,args,out,end,psv DBG_SRC)
SYSTEM_PROC( PTASK_INFO, SystemEx )( CTEXTSTR command_line
                                   , TaskOutput OutputHandler
                                   , uintptr_t psv
                                   DBG_PASS
                                   );
#define System(command_line,output_handler,user_data) SystemEx( command_line, output_handler, user_data DBG_SRC )
// generate output to a task... read by peer task on standard input pipe
// if a task has been opened with an output handler, than IO is trapped, and this is a method of
// sending output to a task.
SYSTEM_PROC( int, pprintf )( PTASK_INFO task, CTEXTSTR format, ... );
// if a task has been opened with an otuput handler, than IO is trapped, and this is a method of
// sending output to a task.
SYSTEM_PROC( int, vpprintf )( PTASK_INFO task, CTEXTSTR format, va_list args );
// send data to child process.  buffer is an array of bytes of length buflen
SYSTEM_PROC( size_t, task_send )( PTASK_INFO task, const uint8_t*buffer, size_t buflen );
typedef void (CPROC*generic_function)(void);
SYSTEM_PROC( generic_function, LoadFunctionExx )( CTEXTSTR library, CTEXTSTR function, LOGICAL bPrivate DBG_PASS);
SYSTEM_PROC( generic_function, LoadFunctionEx )( CTEXTSTR library, CTEXTSTR function DBG_PASS);
SYSTEM_PROC( void *, GetPrivateModuleHandle )( CTEXTSTR libname );
/*
  Add a custom loaded library; attach a name to the DLL space; this should allow
  getcustomsybmol to resolve these
  */
SYSTEM_PROC( void, AddMappedLibrary )( CTEXTSTR libname, POINTER image_memory );
SYSTEM_PROC( LOGICAL, IsMappedLibrary )( CTEXTSTR libname );
SYSTEM_PROC( void, DeAttachThreadToLibraries )( LOGICAL attach );
#define LoadFunction(l,f) LoadFunctionEx(l,f DBG_SRC )
SYSTEM_PROC( generic_function, LoadPrivateFunctionEx )( CTEXTSTR libname, CTEXTSTR funcname DBG_PASS );
#define LoadPrivateFunction(l,f) LoadPrivateFunctionEx(l,f DBG_SRC )
#define OnLibraryLoad(name)	  DefineRegistryMethod("SACK",_OnLibraryLoad,"system/library","load_event",name "_LoadEvent",void,(void), __LINE__)
// the callback passed will be called during LoadLibrary to allow an external
// handler to download or extract the library; the resulting library should also
// be loaded by the callback using the standard 'LoadFunction' methods
SYSTEM_PROC( void, SetExternalLoadLibrary )( LOGICAL (CPROC*f)(const char *) );
// please Release or Deallocate the reutrn value
// the callback should search for the file specified, if required, download or extract it
// and then return with a Release'able utf-8 char *.
SYSTEM_PROC( void, SetExternalFindProgram )( char * (CPROC*f)(const char *) );
// override the default program name.
// Certain program wrappers might use this to change log location, configuration, etc other defaults.
SYSTEM_PROC( void, SetProgramName )( CTEXTSTR filename );
// this is a pointer pointer - being that generic_fucntion is
// a pointer...
SYSTEM_PROC( int, UnloadFunctionEx )( generic_function* DBG_PASS );
#ifdef HAVE_ENVIRONMENT
SYSTEM_PROC( CTEXTSTR, OSALOT_GetEnvironmentVariable )(CTEXTSTR name);
SYSTEM_PROC( void, OSALOT_SetEnvironmentVariable )(CTEXTSTR name, CTEXTSTR value);
SYSTEM_PROC( void, OSALOT_AppendEnvironmentVariable )(CTEXTSTR name, CTEXTSTR value);
SYSTEM_PROC( void, OSALOT_PrependEnvironmentVariable )(CTEXTSTR name, CTEXTSTR value);
#endif
/* this needs to have 'GetCommandLine()' passed to it.
 * Otherwise, the command line needs to have the program name, and arguments passed in the string
 * the parameter to winmain has the program name skipped
 */
SYSTEM_PROC( void, ParseIntoArgs )( TEXTCHAR const *lpCmdLine, int *pArgc, TEXTCHAR ***pArgv );
#define UnloadFunction(p) UnloadFunctionEx(p DBG_SRC )
/*
   Check if task spawning is allowed...
*/
SYSTEM_PROC( LOGICAL, sack_system_allow_spawn )( void );
/*
   Disallow task spawning.
*/
SYSTEM_PROC( void, sack_system_disallow_spawn )( void );
#ifdef __ANDROID__
// sets the path the program using this is at
SYSTEM_PROC(void, SACKSystemSetProgramPath)( CTEXTSTR path );
// sets the name of the program using this library
SYSTEM_PROC(void, SACKSystemSetProgramName)( CTEXTSTR name );
// sets the current working path of the system using this library(getcwd doesn't work?)
SYSTEM_PROC(void, SACKSystemSetWorkingPath)( CTEXTSTR name );
// Set the path of this library.
SYSTEM_PROC(void, SACKSystemSetLibraryPath)( CTEXTSTR name );
#endif
/*
* Creates a process-identified exit event which can be signaled to terminate the process.
*/
SYSTEM_PROC( void, EnableExitEvent )( void );
/*
  Add callback which is called when the exit event is executed.
  The callback can return non-zero to prevent the task from exiting; but the event is no
  longer valid, and cannot be triggered again.
*/
SYSTEM_PROC( void, AddKillSignalCallback )( int( *cb )( uintptr_t ), uintptr_t );
/*
  Remove a callback which was added to event callback list.
*/
SYSTEM_PROC( void, RemoveKillSignalCallback )( int( *cb )( uintptr_t ), uintptr_t );
#if _WIN32
/*
  moves the window of the task; if there is a main window for the task within the timeout perioud.
  callback is called when the window is moved; this allows a background thread to wait
  until the task has created its window.
*/
SYSTEM_PROC( void, MoveTaskWindow )( PTASK_INFO task, int timeout, int left, int top, int width, int height, void cb( uintptr_t, LOGICAL ), uintptr_t psv );
/*
  sets styles for window (class and window style attributes)
  runs a thread which is able to wait for the task's window to be created.  callback is called when completed.
  If no callback is supplied, there is no notification of success or failure.
  `int` status passed to the callback is a combination of statuses for window(1), windowEx(2), and class(4) styles
  and is 7 if all styles are set successfully.
  -1 can be passed as a style value to prevent updates to that style type.
*/
SYSTEM_PROC( void, StyleTaskWindow )( PTASK_INFO task, int timeout, int windowStyle, int windowExStyle, int classStyle, void cb( uintptr_t, int ), uintptr_t psv );
/*
  Moves the window of the specified task to the specified display device; using a lookup to get the display size.
  -1 is an invalid display.
  0 is the default display
  1+ is the first display and subsequent displays - one of which may be the default
*/
SYSTEM_PROC( void, MoveTaskWindowToDisplay )( PTASK_INFO task, int timeout, int display, void cb( uintptr_t, LOGICAL ), uintptr_t psv );
/*
  Moves the window of the specified task to the specified monitor; using a lookup to get the display size.
  0 and less is an invalid display.
  1+ is the first monitor and subsequent monitors
*/
SYSTEM_PROC( void, MoveTaskWindowToMonitor )( PTASK_INFO task, int timeout, int display, void cb( uintptr_t, LOGICAL ), uintptr_t psv );
/*
  Refresh internal window handle for task; uses internal handle as cached value for performance.
*/
SYSTEM_PROC( HWND, RefreshTaskWindow )( PTASK_INFO task );
/*
  Returns a character string with the window title in it.  If the window is not found for
  the task the string is "No Window".
  The caller is responsible for releasing the string buffer;
*/
SYSTEM_PROC( char*, GetWindowTitle )( PTASK_INFO task );
struct process_tree_pair {
    int process_id;
    INDEX parent_id;
    INDEX child_id;
    INDEX next_id;
};
/*
  returns a datalist of process_tree_pair members;
    parent_id is an index into the datalist...
    current = GetDataItem( &pdlResult, 0)
    while( current->child_id >= 0 ) {
      current = GetDataItem( &pdlResult,current->child_id );
    }
    // although that doesn't account for peers - and assumes a linear
    // child list.
    struct depth_node {
      struct process_tree_pair *pair;
      int level;
    }
    PDATASTACK stack = CreateDataStack( sizeof( struct depth_node ));
    struct depth_node node;
    struct depth_node deepest_node;
    deepest_node.level = -1;
    node.pair = GetDataItem( &pdlResult, 0);
    node.level = 0;
    PushData( &node );
    while( current = PopData( &stack ) ) {
      if( current->child_id >= 0 ){
        node.pair = GetDataItem( &pdlResult, current->child_id );
        node.level = current.level+1;
        if( node.level > deepest_node.level ) {
          deepest_node = node;
        }
        PushData( &node );
      }
      if( current->next_id >= 0 ){
        node.pair = GetDataItem( &pdlResult, current->next_id );
        node.level = current.level;
        PushData( &node );
      }
    }
*/
SYSTEM_PROC( PDATALIST, GetProcessTree )( PTASK_INFO task );
#endif
#ifdef __LINUX__
/*
  Processes launched with LPP_OPTION_INTERACTIVE have a PTY handle.
  This retrieves that handle so things like setting terminal size can
  be done.
*/
SYSTEM_PROC( int, GetTaskPTY )( PTASK_INFO task );
#endif
#ifdef __cplusplus
 // SACK_SYSTEM_NAMESPACE_END
} }
using namespace sack::system;
#endif
#endif
//----------------------------------------------------------------------
// $Log: system.h,v $
// Revision 1.14  2005/07/06 00:33:55  jim
// Fixes for all sorts of mangilng with the system.h header.
//
//
// Revision 1.2  2003/10/24 14:59:21  panther
// Added Load/Unload Function for system shared library abstraction
//
// Revision 1.1  2003/10/24 13:22:06  panther
// Initial commit
//
//
#if defined( _MSC_VER )|| defined(__LCC__) || defined( __WATCOMC__ ) || defined( __GNUC__ )
/* Includes networking as appropriate for the target platform. Providing
   compatibility definitions as are lacking between platforms...
   or perhaps appropriate name aliasing to the correct types.            */
#ifndef INCLUDED_SOCKET_LIBRARY
#define INCLUDED_SOCKET_LIBRARY
#if defined( _WIN32 ) || defined( __CYGWIN__ )
//#ifndef __cplusplus_cli
#ifdef UNDER_CE
#define USE_WSA_EVENTS
#endif
#include <winsock2.h>
#include <ws2tcpip.h>
#if defined( MINGW_SUX ) && ( __GNUC__ < 5 )
/* Address information */
typedef struct addrinfoA {
    int             ai_flags;
    int             ai_family;
    int             ai_socktype;
    int             ai_protocol;
    size_t          ai_addrlen;
    char            *ai_canonname;
    struct sockaddr *ai_addr;
    struct addrinfoA *ai_next;
} ADDRINFOA;
typedef ADDRINFOA   *PADDRINFOA;
typedef struct addrinfoW {
    int                 ai_flags;
    int                 ai_family;
    int                 ai_socktype;
    int                 ai_protocol;
    size_t              ai_addrlen;
    PWSTR               ai_canonname;
    struct sockaddr     *ai_addr;
    struct addrinfoW    *ai_next;
} ADDRINFOW;
typedef ADDRINFOW   *PADDRINFOW;
/* Compatibility declaration for MinGW (use MinGW64 to build now
   please?)                                                      */
typedef ADDRINFOA   ADDRINFOT;
typedef ADDRINFOA   *PADDRINFOT;
/* Compatibility declaration for MinGW (use MinGW64 to build now
   please?)                                                      */
typedef ADDRINFOA   ADDRINFO;
typedef ADDRINFOA   *LPADDRINFO;
#endif
#ifdef __CYGWIN__
// just need this simple symbol
typedef int socklen_t;
#endif
//#endif
#elif defined( __LINUX__ )
#if defined( FBSD )
#endif
 // INADDR_ANY/NONE
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#if !defined( _PNACL )
#  include <net/if.h>
#endif
#define SOCKET int
#define SOCKADDR struct sockaddr
#define SOCKET_ERROR -1
//#define HWND int // unused params...
#define WSAEWOULDBLOCK EAGAIN
#define INVALID_SOCKET -1
#define WSAAsynchSelect( a,b,c,d ) (0)
#define WSAGetLastError()  (errno)
#define closesocket(s) close(s)
typedef struct hostent *PHOSTENT;
#ifndef __LINUX__
#define INADDR_ANY (-1)
#define INADDR_NONE (0)
#endif
struct win_in_addr {
	union {
		struct { uint8_t s_b1,s_b2,s_b3,s_b4; } S_un_b;
		struct { uint16_t s_w1,s_w2; } S_un_w;
		uint32_t S_addr;
	} S_un;
#ifndef __ANDROID__
#define s_addr  S_un.S_addr
/* can be used for most tcp & ip code */
#define s_host  S_un.S_un_b.s_b2
	/* host on imp */
#define s_net   S_un.S_un_b.s_b1
	/* network */
#define s_imp   S_un.S_un_w.s_w2
	/* imp */
#define s_impno S_un.S_un_b.s_b4
	/* imp # */
#define s_lh    S_un.S_un_b.s_b3
	/* logical host */
#endif
};
struct win_sockaddr_in {
#ifdef __MAC__
	uint8_t sa_len;
	uint8_t sin_family;
#else
	short   sin_family;
#endif
	uint16_t sin_port;
	struct  win_in_addr sin_addr;
	char    sin_zero[8];
};
typedef struct win_sockaddr_in SOCKADDR_IN;
#endif
#endif
// $Log: loadsock.h,v $
// Revision 1.7  2005/01/27 08:09:25  panther
// Linux cleaned.
//
// Revision 1.6  2003/06/04 11:38:01  panther
// Define PACKED
//
// Revision 1.5  2003/03/25 08:38:11  panther
// Add logging
//
#  if defined( __MAC__ )
#  else
               // _heapmin() included here
#    include <malloc.h>
#  endif
#else
//#include "loadsock.h"
#endif
#ifdef __CYGWIN__
 // provided by -lgcc
// lots of things end up including 'setjmp.h' which lacks sigset_t defined here.
// lots of things end up including 'setjmp.h' which lacks sigset_t defined here.
#  include <sys/signal.h>
#endif
// GetTickCount() and Sleep(n) Are typically considered to be defined by including stdhdrs...
/*
 *  Crafted by Jim Buckeyne
 *
 *  (c)2001-2006++ Freedom Collective
 *
 *  Provide API interface for timers, critical sections
 *  and other thread things.
 *
 */
#ifndef TIMERS_DEFINED
/* timers.h mutliple inclusion protection symbol. */
#define TIMERS_DEFINED
#if defined( _WIN32 )
// on windows, we add a function that returns HANDLE
#endif
/* Memory interface. see <link memory>, */
#ifndef SHARED_MEM_DEFINED
/* Multiple inclusion protection symbol. */
#define SHARED_MEM_DEFINED
#if defined (_WIN32)
//#define USE_NATIVE_CRITICAL_SECTION
#endif
#if defined( _SHLWAPI_H ) || defined( _INC_SHLWAPI )
#undef StrChr
#undef StrCpy
#undef StrDup
#undef StrRChr
#undef StrStr
#endif
#if defined( __MAC__ )
#  define strdup(s) StrDup(s)
#  define strdup_free(s) Release(s)
#else
#  define strdup_free(s) free(s)
#endif
#ifdef __cplusplus
#define SACK_MEMORY_NAMESPACE SACK_NAMESPACE namespace memory {
#define SACK_MEMORY_NAMESPACE_END } SACK_NAMESPACE_END
#else
#define SACK_MEMORY_NAMESPACE
#define SACK_MEMORY_NAMESPACE_END
#endif
/* A declaration of the call type for memory library routines. */
#define MEM_API CPROC
#    ifdef MEM_LIBRARY_SOURCE
#      define MEM_PROC EXPORT_METHOD
#    else
/* Defines library linkage specification. */
#      define MEM_PROC IMPORT_METHOD
#    endif
#ifndef TIMER_NAMESPACE
#ifdef __cplusplus
#define _TIMER_NAMESPACE namespace timers {
#define _TIMER_NAMESPACE_END }
/* define a timer library namespace in C++. */
#define TIMER_NAMESPACE SACK_NAMESPACE namespace timers {
/* define a timer library namespace in C++ end. */
#define TIMER_NAMESPACE_END } SACK_NAMESPACE_END
#else
#define _TIMER_NAMESPACE
#define _TIMER_NAMESPACE_END
#define TIMER_NAMESPACE
#define TIMER_NAMESPACE_END
#endif
#endif
#ifdef __cplusplus
namespace sack {
/*
   timer, timing, threading, and criticalsection.
*/
namespace timers {
# endif
   // enables file/line monitoring of sections and a lot of debuglogging
//#define DEBUG_CRITICAL_SECTIONS
   /* this symbol controls the logging in timers.c... (higher level interface to NoWait primatives)*/
//#define LOG_DEBUG_CRITICAL_SECTIONS
/* A custom implementation of windows CRITICAL_SECTION api.
   Provides same capability for Linux type systems. Can be
   checked as a study in how to implement safe locks.
   See Also
   InitCriticalSec
   EnterCriticalSec
   LeaveCriticalSec
   Example
   <c>For purposes of this example this is declared in global
   memory, known to initialize to all 0.</c>
   <code lang="c++">
   CRITICALSECTION cs_lock_test;
   </code>
   In some bit of code that can be executed by several
   threads...
   <code lang="c++">
   {
      EnterCriticalSec( &amp;cs_lock_test );
      // the code in here will only be run by a single thread
      LeaveCriticalSec( &amp;cs_lock_test );
   }
   </code>
   Remarks
   The __Ex versions of functions passes source file and line
   information in debug mode. This can be used if critical
   section debugging is turned on, or if critical section
   logging is turned on. (See ... ) This allows applications to
   find deadlocks by tracking who is entering critical sections
   and probably failing to leave them.                          */
struct critical_section_tag {
 // this is set when entering or leaving (updating)...
	volatile uint32_t dwUpdating;
  // count of locks entered.  (only low 24 bits may count for 16M entries, upper bits indicate internal statuses.
	volatile uint32_t dwLocks;
 // windows upper 16 is process ID, lower is thread ID
	THREAD_ID dwThreadID;
 // ID of thread waiting for this..
	THREAD_ID dwThreadWaiting;
#ifdef DEBUG_CRITICAL_SECTIONS
	// these are not included without a special compile flag
	// only required by low level deveopers who may be against
   // undefined behavior.
#define MAX_SECTION_LOG_QUEUE 16
	uint32_t bCollisions ;
	CTEXTSTR pFile[16];
	uint32_t  nLine[16];
	uint32_t  nLineCS[16];
 // windows upper 16 is process ID, lower is thread ID
	THREAD_ID dwThreadPrior[16];
 // windows upper 16 is process ID, lower is thread ID
	uint8_t isLock[16];
	int nPrior;
#endif
};
#if !defined( _WIN32 )
#undef USE_NATIVE_CRITICAL_SECTION
#endif
/* <combine sack::timers::critical_section_tag>
   \ \                                          */
#if defined( USE_NATIVE_CRITICAL_SECTION )
#define CRITICALSECTION CRITICAL_SECTION
#else
typedef struct critical_section_tag CRITICALSECTION;
#endif
/* <combine sack::timers::critical_section_tag>
   defines a pointer to a CRITICALSECTION type  */
#if defined( USE_NATIVE_CRITICAL_SECTION )
#define PCRITICALSECTION LPCRITICAL_SECTION
#else
#define InitializeCriticalSection InitializeCriticalSec
typedef struct critical_section_tag *PCRITICALSECTION;
#endif
/* attempts to enter the critical section, and does not block.
   Returns
   If it enters the return is 1, else the return is 0.
   Parameters
   pcs :    pointer to a critical section
   prior :  if not NULL, prior will be set to the current thread
            ID of the owning thread.                             */
#ifndef USE_NATIVE_CRITICAL_SECTION
MEM_PROC  int32_t MEM_API  EnterCriticalSecNoWaitEx ( PCRITICALSECTION pcs, THREAD_ID *prior DBG_PASS );
#define EnterCriticalSecNoWait( pcs,prior ) EnterCriticalSecNoWaitEx( pcs, prior DBG_SRC )
#else
#define EnterCriticalSecNoWait( pcs,prior ) TryEnterCriticalSection( (pcs) )
#endif
/* <combine sack::timers::EnterCriticalSecNoWaitEx@PCRITICALSECTION@THREAD_ID *prior>
   \ \                                                                                */
//#define EnterCriticalSecNoWait( pcs,prior ) EnterCriticalSecNoWaitEx( (pcs),(prior) DBG_SRC )
/* clears all members of a CRITICALSECTION.  Same as memset( pcs, 0, sizeof( CRITICALSECTION ) ); */
#ifndef USE_NATIVE_CRITICAL_SECTION
MEM_PROC  void MEM_API  InitializeCriticalSec ( PCRITICALSECTION pcs );
#else
#define InitializeCriticalSec(pcs)  InitializeCriticalSection(pcs)
#endif
/* Get a count of how many times a critical section is locked */
//MEM_PROC  uint32_t MEM_API  CriticalSecOwners ( PCRITICALSECTION pcs );
/* Namespace of all memory related functions for allocating and
   releasing memory.                                            */
#ifdef __cplusplus
 // namespace timers
}
 // namespace sack
}
using namespace sack::timers;
#endif
#ifdef __cplusplus
namespace sack {
/* Memory namespace contains functions for allocating and
   releasing memory. Also contains methods for accessing shared
   memory (if available on the target platform).
   Allocate / New - get new memory
   Release / Deallocate - allow others to use this memory
   Hold - keep the memory; requires an additional Release.
   Reallocate - given an existing block, allocate a new block, and copy the minimum of what's already in the block, and the new block size.  It is possible this is the same address, which is just extended into a free block.
   OpenSpace - Low level system memory; requested by filename and region name and provides sharing;  NULL, NULL is just new memory.
   GetHeapMemStats - Run diagnostics on the heap blocks.
   SetAllocateLogging - enable allocate/deallocate loggging for debugging; returns the previous logging state.
   SetAllocateDebug -  disables additional runtime checks compiled in for debug builds/
   SetManualAllocateCheck - GetHeapMemStats is run every Allocate/Deallocate in debug mode; this disables that behavior, and expects the libary's user to check as required.
   SetCriticalLogging - Enable/disable critical section logging; does of course influence timing when enabled.
   SetMinAllocate - defines a minimum size that will be tracked internally; if every block is at least 100 bytes (for example), there is less chance at fragmentation when allocating 32-96 byte blocks.
   SetHeapUnit - How much to expand the heap when more space is required.   Very large allocations will end up with their own memory mapped; but the sum of all small allocations will fill up a block of memory, and this controls the expansion rate.
   AlignOfMemBlock - Get the alignment of a memory block; allows reallocate
                                                */
namespace memory {
#endif
typedef struct memory_block_tag* PMEM;
// what is an abstract name for the memory mapping handle...
// where is a filename for the filebacking of the shared memory
// DigSpace( "Picture Memory", "Picture.mem", 100000 );
/* <combinewith sack::memory::OpenSpaceExx@CTEXTSTR@CTEXTSTR@uintptr_t@uintptr_t *@uint32_t*>
   \ \                                                                                 */
MEM_PROC  POINTER MEM_API  OpenSpace ( CTEXTSTR pWhat, CTEXTSTR pWhere, size_t *dwSize );
/* <unfinished>
   Open a shared memory region. The region may be named with a
   text string (this does not work under linux platforms, and
   the name of the file to back the shared region is the sharing
   point). The region may be backed with a file (and must be if
   it is to be shared on linux.
   If the region exists by name, the region is opened, and a
   pointer to that region is returned.
   If the file exists, the file is opened, and mapped into
   memory, and a pointer to the file backed memory is returned.
   if the file does not exist, and the size parameter passed is
   not 0, then the file is created, and expanded to the size
   requested. The bCreate flag is set to true.
   If NULL is passed for pWhat and pWhere, then a block of
   memory is allocated in system memory, backed by pagefile.
   if dwSize is 0, then the region is specified for open only,
   and will not create.
   Parameters
   pWhat :     String to a named shared memory region. NULL is
               unnamed.
   pWhere :    Filename to back the shared memory with. The file
               name itself may also be used to share the memory.
   address :   A base address to map the memory at. If 0,
               specifies do not care.
   dwSize :    pointer to a uintptr_t that defines the size to
               create. If 0, then the region is only opened. The
               size of the region opened is set back into this
               value after it is opened.
   bCreated :  pointer to a boolean to indicate whether the space
               was created or not.
   Returns
   Pointer to region requested to be opened. NULL on failure.
   Example
   Many examples of this are appropriate.
   1) Open or create a file backed shared space.
   2) Open a file for direct memory access, the file is loaded
   into memory by system paging routines and not any API.         */
MEM_PROC  POINTER MEM_API  OpenSpaceExx ( CTEXTSTR pWhat, CTEXTSTR pWhere, uintptr_t address
	, size_t *dwSize, uint32_t* bCreated );
/* <combine sack::memory::OpenSpaceExx@CTEXTSTR@CTEXTSTR@uintptr_t@uintptr_t *@uint32_t*>
   \ \                                                                             */
#define OpenSpaceEx( what,where,address,psize) OpenSpaceExx( what,where,address,psize,NULL )
/* Closes a shared memory region. Calls CloseSpaceEx() with
   bFinal set TRUE.
   Parameters
   pMem :  pointer to a memory region opened by OpenSpace.  */
MEM_PROC  void MEM_API  CloseSpace ( POINTER pMem );
/* Closes a memory region. Release can also be used to close
   opened spaces.
   Parameters
   pMem :    pointer to a memory region opened with OpenSpace()
   bFinal :  If final is set, the file used for backing the shared
             region is deleted.                                    */
MEM_PROC  void MEM_API  CloseSpaceEx ( POINTER pMem, int bFinal );
/* This can give the size back of a memory space.
   Returns
   The size of the memory block.
   Parameters
   pMem :  pointer to a block of memory that was opened with
           OpenSpace().                                      */
MEM_PROC  uintptr_t MEM_API  GetSpaceSize ( POINTER pMem );
/* even if pMem is just a POINTER returned from OpenSpace this
   will create a valid heap pointer.
   will result TRUE if a valid heap is present will result FALSE
   if heap is not able to init (has content)
   Parameters
   pMem :    pointer to a memory space to setup as a heap.
   dwSize :  size of the memory space pointed at by pMem.        */
MEM_PROC  int MEM_API  InitHeap( PMEM pMem, size_t dwSize );
/* Dumps all blocks into the log.
   Parameters
   pHeap :     Heap to dump. If NULL or unspecified, dump the
               default heap.
   bVerbose :  Specify to dump each block's information,
               otherwise only summary information is generated. */
MEM_PROC  void MEM_API  DebugDumpHeapMemEx ( PMEM pHeap, LOGICAL bVerbose );
/* <combine sack::memory::DebugDumpHeapMemEx@PMEM@LOGICAL>
   Logs all of the blocks tracked in a specific heap.
   Parameters
   Heap :  Heap to dump the memory blocks of.              */
#define DebugDumpHeapMem(h)     DebugDumpMemEx( (h), TRUE )
/* <combine sack::memory::DebugDumpHeapMemEx@PMEM@LOGICAL>
   \ \                                                     */
MEM_PROC  void MEM_API  DebugDumpMemEx ( LOGICAL bVerbose );
/* Dumps all tracked heaps.
   Parameters
   None.                    */
#define DebugDumpMem()     DebugDumpMemEx( TRUE )
/* Dumps a heap to a specific file.
   Parameters
   pHeap :      Heap. If NULL or unspecified, dumps default heap.
   pFilename :  name of the file to write output to.              */
MEM_PROC  void MEM_API  DebugDumpHeapMemFile ( PMEM pHeap, CTEXTSTR pFilename );
/* <combine sack::memory::DebugDumpHeapMemFile@PMEM@CTEXTSTR>
   \ \                                                        */
MEM_PROC  void MEM_API  DebugDumpMemFile ( CTEXTSTR pFilename );
#ifdef __GNUC__
MEM_PROC  POINTER MEM_API  HeapAllocateAlignedEx ( PMEM pHeap, size_t dwSize, uint16_t alignment DBG_PASS ) __attribute__( (malloc) );
MEM_PROC  POINTER MEM_API  HeapAllocateEx ( PMEM pHeap, uintptr_t nSize DBG_PASS ) __attribute__((malloc));
MEM_PROC  POINTER MEM_API  AllocateEx ( uintptr_t nSize DBG_PASS ) __attribute__((malloc));
#else
/* \ \
   Parameters
   pHeap :  pointer to a heap which was initialized with
            InitHeap()
   Size :   Size of block to allocate                    */
MEM_PROC  POINTER MEM_API  HeapAllocateEx ( PMEM pHeap, uintptr_t nSize DBG_PASS );
/* \ Parameters
pHeap :  pointer to a heap which was initialized with
InitHeap()
Size :   Size of block to allocate
Alignment : count of bytes to return block on (1,2,4,8,16,32)  */
MEM_PROC  POINTER MEM_API  HeapAllocateAlignedEx( PMEM pHeap, uintptr_t nSize, uint16_t alignment DBG_PASS );
/* Allocates a block of memory of specific size. Debugging
   information if passed is recorded on the block.
   Parameters
   size :  size of the memory block to create              */
MEM_PROC  POINTER MEM_API  AllocateEx ( uintptr_t nSize DBG_PASS );
#endif
/* A simple macro to allocate a new single unit of a structure. Adds
   a typecast automatically to be (type*) so C++ compilation is
   clean. Does not burden the user with extra typecasts. This,
   being in definition use means that all other things that are
   typecast are potentially error prone. Memory is considered
   uninitialized.
   Parameters
   type :  type to allocate
   Example
   <code lang="c++">
   int *p_int = New( int );
   </code>                                                           */
#define New(type) ((type*)HeapAllocate(0,sizeof(type)))
/* Reallocates an array of type.
   Parameters
   type :  type to use for sizeof(type) * sz for resulting size.
   p :     pointer to realloc
   sz :    count of elements in the array                        */
#define Renew(type,p,sz) ((type*)HeapReallocate(0,p, sizeof(type)*sz))
/* an advantage of C, can define extra space at end of structure
   which is allowed to carry extra data, which is unknown by
   other code room for exploits rock.
   Parameters
   type :   passed to sizeof()
   extra :  Number of additional bytes to allocate beyond the
            sizeof( type )
   Example
   Create a text segment plus 18 characters of data. (This
   should not be done, use SegCreate instead)
   <code lang="c#">
   PTEXT text = NewPlus( TEXT, 18 );
   </code>                                                       */
#define NewPlus(type,extra) ((type*)HeapAllocate(0,sizeof(type)+(extra)))
/* Allocate a new array of type.
   Parameters
   type :   type to determine size of array element to allocate.
   count :  count of elements to allocate in the array.
   Returns
   A pointer to type. (this is important, since in C++ it's cast
   correctly to the destination type).                           */
#define NewArray(type,count) ((type*)HeapAllocate(0,(uintptr_t)(sizeof(type)*(count))))
/* Allocate sizeof(type). Will invoke some sort of registered
   initializer
   Parameters
   type :  type to allocate for. Passes the name of the type so
           the allocator can do a registered procedure lookup and
           invok an initializer for the type.                     */
//#define NewObject(type) ((type*)FancyAllocate(sizeof(type),#type DBG_SRC))
#ifdef __cplusplus
/* A 'safe' release macro. casts the block to the type to
   release. Makes sure the pointer being released is the type
   specified.
   Parameters
   type :   type of the variable
   thing :  the thing to actually release.                    */
#  ifdef _DEBUG
#    define Deallocate(type,thing) for(type _zzqz_tmp=thing;ReleaseEx((POINTER)(_zzqz_tmp)DBG_SRC),0;)
#  else
#    define Deallocate(type,thing) ReleaseEx((POINTER)(thing)DBG_SRC)
#  endif
#else
#  define Deallocate(type,thing) (ReleaseEx((POINTER)(thing)DBG_SRC))
#endif
/* <combine sack::memory::HeapAllocateEx@PMEM@uintptr_t nSize>
   \ \                                                        */
#define HeapAllocate(heap, n) HeapAllocateEx( (heap), (n) DBG_SRC )
   /* <combine sack::memory::HeapAllocateAlignedEx@PMEM@uintptr_t@uint32_t>
   \ \                                                        */
#define HeapAllocateAligned(heap, n, m) HeapAllocateAlignedEx( (heap), (n), m DBG_SRC )
   /* <combine sack::memory::AllocateEx@uintptr_t nSize>
   \ \                                               */
#ifdef FIX_RELEASE_COM_COLLISION
#else
#define Allocate( n ) HeapAllocateEx( (PMEM)0, (n) DBG_SRC )
#endif
//MEM_PROC  POINTER MEM_API  AllocateEx ( uintptr_t nSize DBG_PASS );
//#define Allocate(n) AllocateEx(n DBG_SRC )
MEM_PROC  POINTER MEM_API  GetFirstUsedBlock ( PMEM pHeap );
/* Releases an allocated block. Memory becomes free to allocate
   again. If debugging information is passed, the releasing
   source and line is recorded in the block. (can be used to
   find code deallocating memory it shouldn't).
   This also works with Hold(), and decrements the hold counter.
   If there are no more holds on the block, then the block is
   released.
   Parameters
   p :  pointer to allocated block to release.                   */
MEM_PROC  POINTER MEM_API  ReleaseEx ( POINTER pData DBG_PASS ) ;
/* <combine sack::memory::ReleaseEx@POINTER pData>
   \ \                                             */
#ifdef FIX_RELEASE_COM_COLLISION
#else
/* <combine sack::memory::ReleaseEx@POINTER pData>
   \ \                                             */
#define Release(p) ReleaseEx( (POINTER)(p) DBG_SRC )
#endif
/* Adds a usage count to a block of memory. For each count
   added, an additional release must be used. This can be used
   to keep a copy of the block, even if some other code
   automatically releases it.
   Parameters
   pointer :  pointer to a block of memory that was Allocate()'d.
   Example
   Allocate a block of memory, and release it properly. But we
   passed it to some function. That function wanted to keep a
   copy of the block, so it can apply a hold. It needs to later
   do a Release again to actually free the memory.
   <code lang="c++">
   POINTER p = Allocate( 32 );
   call_some_function( p );
   Release( p );
   void call_some_function( POINTER p )
   {
      static POINTER my_p_copy;
      my_p_copy = p;
      Hold( p );
   }
   </code>                                                        */
MEM_PROC  POINTER MEM_API  HoldEx ( POINTER pData DBG_PASS  );
/* <combine sack::memory::HoldEx@POINTER pData>
   \ \                                          */
#define Hold(p) HoldEx((POINTER)p DBG_SRC )
/* This can be used to add additional space after the end of a
   memory block.
   Parameters
   pHeap :   If NULL or not specified, uses the common memory heap.
   source :  pointer to the block to pre\-allocate. If NULL, a new
             memory block will be allocated that is filled with 0.
   size :    the new size of the block.
   Returns
   A pointer to a new block of memory that is the new size.
   Remarks
   If the size specified for the new block is larger than the
   previous size of the block, the curernt data is copied to the
   beginning of the new block, and the memory after the existing
   content is cleared to 0.
   If the size specified for the new block is smaller than the
   previous size, the end of the original block is not copied to
   the new block.
   If NULL is passed as the source block, then a new block
   filled with 0 is created.                                        */
MEM_PROC  POINTER MEM_API  HeapReallocateAlignedEx ( PMEM pHeap, POINTER source, uintptr_t size, uint16_t alignment DBG_PASS );
MEM_PROC  POINTER MEM_API  HeapReallocateEx ( PMEM pHeap, POINTER source, uintptr_t size DBG_PASS );
/* <combine sack::memory::HeapReallocateEx@PMEM@POINTER@uintptr_t size>
   \ \                                                                 */
#define HeapReallocateAligned(heap,p,sz,al) HeapReallocateEx( (heap),(p),(sz),(al) DBG_SRC )
#define HeapReallocate(heap,p,sz) HeapReallocateEx( (heap),(p),(sz) DBG_SRC )
/* <combine sack::memory::HeapReallocateEx@PMEM@POINTER@uintptr_t size>
   \ \                                                                 */
MEM_PROC  POINTER MEM_API  ReallocateEx ( POINTER source, uintptr_t size DBG_PASS );
/* <combine sack::memory::ReallocateEx@POINTER@uintptr_t size>
   \ \                                                        */
#ifdef FIX_RELEASE_COM_COLLISION
#else
#define Reallocate(p,sz) ReallocateEx( (p),(sz) DBG_SRC )
#endif
/* This can be used to add additional space before the beginning
   of a memory block.
   Parameters
   pHeap :   If NULL or not specified, uses the common memory heap.
   source :  pointer to the block to pre\-allocate. If NULL, a new
             memory block will be allocated that is filled with 0.
   size :    the new size of the block.
   Returns
   A pointer to a new block of memory that is the new size.
   Remarks
   If the size specified for the new block is larger than the
   previous size of the block, the content data is copied to the
   end of the new block, and the memory leading up to the block
   is cleared to 0.
   If the size specified for the new block is smaller than the
   previous size, the end of the original block is not copied to
   the new block.
   If NULL is passed as the source block, then a new block
   filled with 0 is created.                                        */
MEM_PROC  POINTER MEM_API  HeapPreallocateEx ( PMEM pHeap, POINTER source, uintptr_t size DBG_PASS );
/* <combine sack::memory::HeapPreallocateEx@PMEM@POINTER@uintptr_t size>
   \ \                                                                  */
#define HeapPreallocate(heap,p,sz) HeapPreallocateEx( (heap),(p),(sz) DBG_SRC )
/* <combine sack::memory::HeapPreallocateEx@PMEM@POINTER@uintptr_t size>
   \ \                                                                  */
MEM_PROC  POINTER MEM_API  PreallocateAlignedEx ( POINTER source, uintptr_t size, uint16_t alignment DBG_PASS );
MEM_PROC  POINTER MEM_API  PreallocateEx ( POINTER source, uintptr_t size DBG_PASS );
/* <combine sack::memory::PreallocateEx@POINTER@uintptr_t size>
   \ \                                                         */
#define PreallocateAligned(p,sz,al) PreallocateAlignedEx( (p),(sz),(al) DBG_SRC )
#define Preallocate(p,sz) PreallocateEx( (p),(sz) DBG_SRC )
/* Moves a block of memory from one heap to another.
   Parameters
   pNewHeap :  heap target to move the block to.
   source :    source block to move \- pointer to the data in the
               block.
   Remarks
   Since each block remembers its own size, it is possible to
   move a block from one heap to another. A heap might be a
   memory mapped file at a specific address for instance.         */
MEM_PROC  POINTER MEM_API  HeapMoveEx ( PMEM pNewHeap, POINTER source DBG_PASS );
/* <combine sack::memory::HeapMoveEx@PMEM@POINTER source>
   \ \                                                    */
#define HeapMove(h,s) HeapMoveEx( (h), (s) DBG_SRC )
/* \returns the size of a memory block which was Allocate()'d.
   Parameters
   pData :  pointer to a allocated memory block.
   Returns
   The size of the block that was specified by the Allocate(). */
MEM_PROC uintptr_t MEM_API  SizeOfMemBlock ( CPOINTER pData );
/* \returns the allocation alignment of a memory block which was Allocate()'d.
Parameters
pData :  pointer to a allocated memory block.
Returns
The alignment of the block that was specified from Allocate(). */
MEM_PROC uint16_t  AlignOfMemBlock( CPOINTER pData );
/* not so much of a fragment as a consolidation. Finds a free
   spot earlier in the heap and attempts to move the block
   there. This can help alleviate heap fragmentation.
   Parameters
   ppMemory :  pointer to a pointer to memory which might move */
MEM_PROC  LOGICAL MEM_API  Defragment ( POINTER *ppMemory );
/* \ \
   Parameters
   pHeap :        pointer to a heap
   pFree :        pointer to a 32 bit value to receive the size
                  of free space
   pUsed :        pointer to a 32 bit value to receive the size
                  of used space
   pChunks :      pointer to a 32 bit value to receive the total
                  count of chunks.
   pFreeChunks :  pointer to a 32 bit value to receive the total
                  count of free chunks.
   Remarks
   It looks like DBG_PASS parameter isn't used... not sure why
   it would here, there is no allocate or delete.
   The count of allocated chunks can be gotten by subtracting
   FreeChunks from Chunks.
   Example
   <code lang="c++">
   uint32_t free;
   uint32_t used;
   uint32_t chunks;
   uint32_t free_chunks;
   GetHeapMemStatsEx( NULL, &amp;free, &amp;used, &amp;chunks, &amp;free_chunks );
   </code>                                                                         */
MEM_PROC  void MEM_API  GetHeapMemStatsEx ( PMEM pHeap, uint32_t *pFree, uint32_t *pUsed, uint32_t *pChunks, uint32_t *pFreeChunks DBG_PASS );
/* <combine sack::memory::GetHeapMemStatsEx@PMEM@uint32_t *@uint32_t *@uint32_t *@uint32_t *pFreeChunks>
   \ \                                                                               */
#define GetHeapMemStats(h,f,u,c,fc) GetHeapMemStatsEx( h,f,u,c,fc DBG_SRC )
//MEM_PROC  void MEM_API  GetHeapMemStats ( PMEM pHeap, uint32_t *pFree, uint32_t *pUsed, uint32_t *pChunks, uint32_t *pFreeChunks );
MEM_PROC  void MEM_API  GetMemStats ( uint32_t *pFree, uint32_t *pUsed, uint32_t *pChunks, uint32_t *pFreeChunks );
/* Sets whether to log allocations or not.
   \returns the prior state of logging...
   Parameters
   bTrueFalse :  if TRUE, allocation logging is turned on. Enables
                 logging when each block is Allocated, Released,
                 or Held.                                          */
MEM_PROC  int MEM_API  SetAllocateLoggingEx ( LOGICAL bTrueFalse DBG_PASS );
#define SetAllocateLogging(tf) SetAllocateLoggingEx( tf DBG_SRC )
MEM_PROC  int MEM_API  ClearAllocateLoggingEx ( LOGICAL bTrueFalse DBG_PASS );
#define ClearAllocateLogging(tf) ClearAllocateLoggingEx( tf DBG_SRC )
MEM_PROC  int MEM_API  ResetAllocateLoggingEx ( LOGICAL bTrueFalse DBG_PASS );
#define ResetAllocateLogging(tf) ResetAllocateLoggingEx( tf DBG_SRC )
/* disables storing file/line, also disables auto GetMemStats
   checking
   Parameters
   bDisable :  set to TRUE to disable allocate debug logging. */
MEM_PROC  int MEM_API  SetAllocateDebug ( LOGICAL bDisable );
/* disables auto GemMemStats on every allocate/release/Hold
   GetMemStats will evaluate each and every block allocated in
   memory and inspect it for corruption.
   Parameters
   bDisable :  set to TRUE to disable auto mem check.          */
MEM_PROC  int MEM_API  SetManualAllocateCheck ( LOGICAL bDisable );
/* Sets whether to log critical sections or not.
   \returns the prior state of logging...
   Parameters
   bTrueFalse :  if TRUE, critical section logging is turned on. Logs
                 when each thread enters or leaves a
                 CRITICIALSECTION.                                    */
MEM_PROC  int MEM_API  SetCriticalLogging ( LOGICAL bTrueFalse );
/* Sets the minimum size to allocate. If a block size less than
   this is allocated, then this much is actually allocated.
   Parameters
   nSize :  Specify the minimum allocation size                 */
MEM_PROC  void MEM_API  SetMinAllocate ( size_t nSize );
/* Sets how much a heap is expanded by when it is out of space. Default
   is like 512k.
   Parameters
   dwSize :  the new size to expand heaps by.
   Remarks
   Probably internally, this is rounded up to the next 4k
   boundary.                                                            */
MEM_PROC  void MEM_API  SetHeapUnit ( size_t dwSize );
/* Multi-processor safe exchange operation. Returns the prior
   value at the pointer.
   Parameters
   p :    pointer to a volatile 64 bit value.
   val :  a new 64 bit value to put at (*p)
   Example
   <code lang="c#">
   uint64_t value = 13;
   uint64_t oldvalue = LockedExchange64( &amp;value, 15 );
   // old value will be 13
   // value will be 15
   </code>                                                    */
MEM_PROC  uint64_t MEM_API  LockedExchange64 ( volatile uint64_t* p, uint64_t val );
/* A multi-processor safe increment of a variable.
   Parameters
   p :  pointer to a 32 bit value to increment.    */
MEM_PROC  uint32_t MEM_API  LockedIncrement ( volatile uint32_t* p );
/* Does a multi-processor safe decrement on a variable.
   Parameters
   p :  pointer to a 32 bit value to decrement.         */
MEM_PROC  uint32_t MEM_API  LockedDecrement ( volatile uint32_t* p );
#ifdef __cplusplus
// like also __if_assembly__
//extern "C" {
#endif
#ifdef __64__
#define LockedExchangePtrSzVal(a,b) LockedExchange64((volatile uint64_t*)(a),b)
#else
#define LockedExchangePtrSzVal(a,b) LockedExchange((volatile uint32_t*)(a),b)
#endif
/* Multiprocessor safe swap of the contents of a variable with a
   new value, and result with the old variable.
   Parameters
   p :    pointer to a 32 bit value to exchange
   val :  value to set into the variable
   Returns
   The prior value in p.
   Example
   <code>
   uint32_t variable = 0;
   uint32_t oldvalue = LockedExchange( &amp;variable, 1 );
   </code>                                                       */
MEM_PROC  uint32_t MEM_API  LockedExchange ( volatile uint32_t* p, uint32_t val );
/* Sets a 32 bit value into memory. If the length to set is not
   a whole number of 32 bit words, the last bytes may contain
   the low 16 bits of the value and the low 8 bits.
   Parameters
   p :   pointer to memory to set
   n :   32 bit value to set memory with
   sz :  length to set
   Remarks
   Writes as many 32 it values as will fit in sz.
   If (sz &amp; 2), the low 16 bits of n are written at the end.
   then if ( sz &amp; 1 ) the low 8 bits of n are written at the
   end.                                                          */
MEM_PROC  void MEM_API  MemSet ( POINTER p, uintptr_t n, size_t sz );
//#define _memset_ MemSet
/* memory copy operation. not safe when buffers overlap. Performs
   platform-native memory stream operation to copy from one
   place in memory to another. (32 or 64 bit operations as
   possible).
   Parameters
   pTo :    Memory to copy to
   pFrom :  memory to copy from
   sz :     size of block of memory to copy                       */
MEM_PROC  void MEM_API  MemCpy ( POINTER pTo, CPOINTER pFrom, size_t sz );
//#define _memcpy_ MemCpy
/* Binary byte comparison of one block of memory to another. Results
   \-1 if less, 1 if more and 0 if equal.
   Parameters
   pOne :  pointer to memory one
   pTwo :  pointer to some other memory
   sz :    count of bytes to compare
   Returns
   0 if equal
   \-1 if the first different byte in pOne is less than pTwo.
   1 if the first different byte in pOne is more than pTwo.          */
MEM_PROC  int MEM_API  MemCmp ( CPOINTER pOne, CPOINTER pTwo, size_t sz );
	/* nothing.
   does nothing, returns nothing. */
//#define memnop(mem,sz,comment)
/* Compares two strings. Must match exactly.
   Parameters
   s1 :  string to compare
   s2 :  string to compare
   Returns
   0 if equal.
   1 if (s1 \>s2)
   \-1 if (s1 \< s2)
   if s1 is NULL and s2 is not NULL, return is -1.
   if s2 is NULL and s1 is not NULL, return is 1.
	if s1 and s2 are NULL return is 0.              */
#ifdef StrCmp
#undef StrCmp
 // StrCmp
#endif
MEM_PROC  int MEM_API  StrCmp ( CTEXTSTR pOne, CTEXTSTR pTwo );
/* Compares two strings, case insensitively.
   Parameters
   s1 :  string to compare
   s2 :  string to compare
   Returns
   0 if equal.
   1 if (s1 \>s2)
   \-1 if (s1 \< s2)
   if s1 is NULL and s2 is not NULL, return is -1.
   if s2 is NULL and s1 is not NULL, return is 1.
   if s1 and s2 are NULL return is 0.              */
MEM_PROC  int MEM_API  StrCaseCmp ( CTEXTSTR s1, CTEXTSTR s2 );
/* Compares two strings, one utf8 and one utf16, case insensitively.
	Parameters
	s1 :  string to compare
	s2 :  string to compare
	Returns
	0 if equal.
	1 if (s1 \>s2)
	\-1 if (s1 \< s2)
	if s1 is NULL and s2 is not NULL, return is -1.
	if s2 is NULL and s1 is not NULL, return is 1.
	if s1 and s2 are NULL return is 0.              */
MEM_PROC  int MEM_API StrCaseCmp_u8u16( const char* s1, const wchar_t* s2 );
/* Compares two strings, one utf8 and one utf16, case insensitively.
	Parameters
	s1 :  string to compare
	s2 :  string to compare
	maxlen : maximum characters to compare
	Returns
	0 if equal.
	1 if (s1 \>s2)
	\-1 if (s1 \< s2)
	if s1 is NULL and s2 is not NULL, return is -1.
	if s2 is NULL and s1 is not NULL, return is 1.
	if s1 and s2 are NULL return is 0.              */
MEM_PROC  int MEM_API StrCaseCmpEx_u8u16( const char* s1, const wchar_t* s2, size_t maxLen );
/* Compares two strings, both utf16, case insensitively.
	Parameters
	s1 :  string to compare
	s2 :  string to compare
	Returns
	0 if equal.
	1 if (s1 \>s2)
	\-1 if (s1 \< s2)
	if s1 is NULL and s2 is not NULL, return is -1.
	if s2 is NULL and s1 is not NULL, return is 1.
	if s1 and s2 are NULL return is 0.              */
MEM_PROC  int MEM_API  StrCaseCmpW( const wchar_t* s1, const wchar_t* s2 );
/* String insensitive case comparison with maximum length
   specified.
   Parameters
   s1 :      string to compare
   s2 :      string to compare
   maxlen :  maximum character required to match
   Returns
   0 if equal up to the number of characters.
   1 if (s1 \>s2)
   \-1 if (s1 \< s2)
   if s1 is NULL and s2 is not NULL, return is -1.
   if s2 is NULL and s1 is not NULL, return is 1.
   if s1 and s2 are NULL return is 0.                     */
MEM_PROC  int MEM_API  StrCaseCmpEx ( CTEXTSTR s1, CTEXTSTR s2, size_t maxlen );
/* This searches a string for the first character that matches
   some specified character.
   A custom strchr function, since microsoft is saying this is
   an unsafe function. This Compiles to compare native strings,
   if UNICODE uses unicode, otherwise uses 8 bit characters.
   Parameters
   s1 :  String to search
   c :   Character to find
   Returns
   pointer in string to search that is the first character that
   matches. NULL if no character matches.
   Note
   This flavor is the only one on C where operator overloading
   cannot switch between CTEXTSTR and TEXTSTR parameters, to
   \result with the correct type. If a CTEXTSTR is passed to
   this it should result with a CTEXTSTR, but if that's the only
   choice, then the result of this is never modifiable, even if
	it is a pointer to a non-const TEXTSTR.                       */
MEM_PROC  CTEXTSTR MEM_API  StrChr ( CTEXTSTR s1, TEXTCHAR c );
/* copy S2 to S1, with a maximum of N characters.
   The last byte of S1 will always be a 'nul'. If S2 was longer
   than S1, then it will be truncated to fit within S1. Perferred
   method over this is SaveText or StrDup.
   Parameters
   s1 :      desitnation TEXTCHAR buffer
   s2 :      source string
   length :  the maximum number of characters that S1 can hold. (this
             is not a size, but is a character count)                 */
MEM_PROC  TEXTSTR MEM_API  StrCpyEx ( TEXTSTR s1, CTEXTSTR s2, size_t n );
/* copy S2 to S1. This is 'unsafe', since neither paramter's
   size is known. Prefer StrCpyEx which passes the maximum
   length for S1.
   Parameters
   s1 :  desitnation TEXTCHAR buffer
   s2 :  source string                                       */
MEM_PROC  TEXTSTR MEM_API  StrCpy ( TEXTSTR s1, CTEXTSTR s2 );
/* \Returns the count of characters in a string.
   Parameters
   s :  string to measure
   Returns
   length of string.                             */
MEM_PROC  size_t MEM_API  StrLen ( CTEXTSTR s );
/* \Returns the count of bytes in a string, which includes the \u0000 at the end.
	Parameters
	s :  string to measure (with wide characters)
	Returns
	length of string.                             */
MEM_PROC  size_t MEM_API  StrBytesW( wchar_t const* s );
/* \Returns the count of bytes in a string, if converted to utf8.
	Parameters
	s : wide string to measure (with wide characters)
	Returns
	length of string.                             */
MEM_PROC  size_t MEM_API  StrBytesWu8( wchar_t const* s );
/* Get the length of a string in C chars.
   Parameters
   s :  char * to count.
   Returns
   the length of s. If s is NULL, return 0. */
MEM_PROC  size_t MEM_API  CStrLen ( char const*s );
/* Finds the last instance of a character in a string.
   Parameters
   s1 :  String to search in
   c :   character to find
   Returns
   NULL if character is not in the string.
   a pointer to the last character in s1 that matches c. */
MEM_PROC  CTEXTSTR MEM_API  StrRChr ( CTEXTSTR s1, TEXTRUNE c );
/* Finds the last instance of a character in a string.
	Parameters
	s1 :  String to search in
	c :   character to find
	Returns
	NULL if character is not in the string.
	a pointer to the last character in s1 that matches c. */
MEM_PROC  const wchar_t* MEM_API  StrRChrW( const wchar_t* s1, TEXTRUNE c );
#ifdef __cplusplus
/* This searches a string for the first character that matches
   some specified character.
   A custom strchr function, since microsoft is saying this is
   an unsafe function. This Compiles to compare native strings,
   if UNICODE uses unicode, otherwise uses 8 bit characters.
   Parameters
   s1 :  String to search
   c :   Character to find
   Returns
   pointer in string to search that is the first character that
   matches. NULL if no character matches.
   Note
   This second flavor is only available on C++ where operator
   overloading will switch between CTEXTSTR and TEXTSTR
   \parameters, to result with the correct type. If a CTEXTSTR
   is passed to this it should result with a CTEXTSTR, but if
   that's the only choice, then the result of this is never
   modifiable, even if it is a pointer to a non-const TEXTSTR.  */
MEM_PROC  TEXTSTR MEM_API  StrChr ( TEXTSTR s1, TEXTCHAR c );
/* This searches a string for the last character that matches
   some specified character.
   A custom strrchr function, since microsoft is saying this is
   an unsafe function. This Compiles to compare native strings,
   if UNICODE uses unicode, otherwise uses 8 bit characters.
   Parameters
   s1 :  String to search
   c :   Character to find
   Returns
   pointer in string to search that is the first character that
   matches. NULL if no character matches.
   Note
   This second flavor is only available on C++ where operator
   overloading will switch between CTEXTSTR and TEXTSTR
   \parameters, to result with the correct type. If a CTEXTSTR
   is passed to this it should result with a CTEXTSTR, but if
   that's the only choice, then the result of this is never
   modifiable, even if it is a pointer to a non-const TEXTSTR.  */
MEM_PROC  TEXTSTR MEM_API  StrRChr ( TEXTSTR s1, TEXTCHAR c );
/* <combine sack::memory::StrCmp@CTEXTSTR@CTEXTSTR>
   \ \                                              */
MEM_PROC  int MEM_API  StrCmp ( const char * s1, CTEXTSTR s2 );
MEM_PROC  wchar_t* MEM_API  StrRChrW( wchar_t* s1, TEXTRUNE c );
#endif
/* <combine sack::memory::StrCmp@char *@CTEXTSTR>
   \ \                                            */
MEM_PROC  int MEM_API  StrCmpEx ( CTEXTSTR s1, CTEXTSTR s2, INDEX maxlen );
/* Finds an instance of a string in another string.
   Custom implementation because strstr is declared unsafe, and
   to handle switching between unicode and char.
   Parameters
   s1 :  the string to search in
   s2 :  the string to locate
   Returns
   NULL if s2 is not in s1.
   The beginning of the string in s1 that matches s2.
   Example
   <code lang="c++">
   TEXTCHAR const *found = StrStr( "look in this string", "in" );
                                               ^returns a pointer to here.
   </code>                                                                        */
MEM_PROC  CTEXTSTR MEM_API  StrStr ( CTEXTSTR s1, CTEXTSTR s2 );
#ifdef __cplusplus
/* Finds an instance of a string in another string.
   Custom implementation because strstr is declared unsafe, and
   to handle switching between unicode and char.
   Parameters
   s1 :  the string to search in
   s2 :  the string to locate
   Returns
   NULL if s2 is not in s1.
   The beginning of the string in s1 that matches s2.
   Example
   <code>
   TEXTCHAR *writable_string = StrDup( "look in this string" );
   TEXTCHAR *found = StrStr( writable_string, "in" );
   // returns a pointer to 'in' in the writable string, which can then be modified.
   </code>                                                                          */
MEM_PROC  TEXTSTR MEM_API  StrStr ( TEXTSTR s1, CTEXTSTR s2 );
#endif
/* Searches for one string in another. Compares case
   insensitively.
   Parameters
   s1 :  string to search in
   s2 :  string to locate
   See Also
   <link sack::memory::StrStr@CTEXTSTR@CTEXTSTR, StrStr> */
MEM_PROC  CTEXTSTR MEM_API  StrCaseStr ( CTEXTSTR s1, CTEXTSTR s2 );
/* This duplicates a block of memory.
   Parameters
   p :  pointer to a block of memory that was allocated.
   Returns
   a pointer to a new block of memory that has the same content
   as the original.                                             */
MEM_PROC  POINTER MEM_API  MemDupEx ( CPOINTER thing DBG_PASS );
/* <combine sack::memory::MemDupEx@CPOINTER thing>
   \ \                                             */
#define MemDup(thing) MemDupEx(thing DBG_SRC )
/* Duplicates a string, and returns a pointer to the copy.
   Parameters
   original :  string to duplicate                         */
MEM_PROC  TEXTSTR MEM_API  StrDupEx ( CTEXTSTR original DBG_PASS );
/* Translates from a TEXTCHAR string to a char string. Probably
   only for UNICODE to non wide translation points.
   Parameters
   original :  string to duplicate                              */
MEM_PROC  char *  MEM_API  CStrDupEx ( CTEXTSTR original DBG_PASS );
/* Translates from a TEXTCHAR string to a wchar_t string. Probably
   only for UNICODE to non wide translation points.
   Parameters
   original :  string to duplicate                              */
MEM_PROC  wchar_t *  MEM_API  DupTextToWideEx( CTEXTSTR original DBG_PASS );
#define DupTextToWide(s) DupTextToWideEx( s DBG_SRC )
/* Translates from a TEXTCHAR string to a wchar_t string. Probably
   only for UNICODE to non wide translation points.
   Parameters
   original :  string to duplicate                              */
MEM_PROC  char *     MEM_API  DupTextToCharEx( CTEXTSTR original DBG_PASS );
#define DupTextToChar(s) DupTextToCharEx( s DBG_SRC )
/* Translates from a TEXTCHAR string to a wchar_t string. Probably
   only for UNICODE to non wide translation points.
   Parameters
   original :  string to duplicate                              */
MEM_PROC TEXTSTR     MEM_API  DupWideToTextEx( const wchar_t *original DBG_PASS );
#define DupWideToText(s) DupWideToTextEx( s DBG_SRC )
/* Translates from a TEXTCHAR string to a wchar_t string. Probably
   only for UNICODE to non wide translation points.
   Parameters
   original :  string to duplicate                              */
MEM_PROC TEXTSTR     MEM_API  DupCharToTextEx( const char *original DBG_PASS );
#define DupCharToText(s) DupCharToTextEx( s DBG_SRC )
/* Converts from 8 bit char to 16 bit wchar (or no-op if not
   UNICODE compiled)
   Parameters
   original :  original string of C char.
   Returns
   a pointer to a wide character string.                     */
MEM_PROC  TEXTSTR MEM_API  DupCStrEx ( const char * original DBG_PASS );
/* Converts from 8 bit char to 16 bit wchar (or no-op if not
UNICODE compiled)
Parameters
original :  original string of C char.
Returns
a pointer to a wide character string.                     */
MEM_PROC  TEXTSTR MEM_API  DupCStrLenEx( const char * original, size_t chars DBG_PASS );
/* <combine sack::memory::StrDupEx@CTEXTSTR original>
   \ \                                                */
#define StrDup(o) StrDupEx( (o) DBG_SRC )
/* <combine sack::memory::CStrDupEx@CTEXTSTR original>
   \ \                                                 */
#define CStrDup(o) CStrDupEx( (o) DBG_SRC )
/* <combine sack::memory::DupCStrEx@char * original>
   \ \                                               */
#define DupCStr(o) DupCStrEx( (o) DBG_SRC )
/* <combine sack::memory::DupCStrLenEx@char * original@size_t chars>
   \ \                                               */
#define DupCStrLen(o,l) DupCStrLenEx( (o),(l) DBG_SRC )
//------------------------------------------------------------------------
#if 0
// this code was going to provide network oriented shared memory.
#ifndef TRANSPORT_STRUCTURE_DEFINED
typedef uintptr_t PTRANSPORT_QUEUE;
struct transport_queue_tag { uint8_t private_data_here; };
#endif
MEM_PROC  struct transport_queue_tag * MEM_API  CreateQueue ( int size );
MEM_PROC  int MEM_API  EnqueMessage ( struct transport_queue_tag *queue, POINTER msg, int size );
MEM_PROC  int MEM_API  DequeMessage ( struct transport_queue_tag *queue, POINTER msg, int *size );
MEM_PROC  int MEM_API  PequeMessage ( struct transport_queue_tag *queue, POINTER *msg, int *size );
#endif
//------------------------------------------------------------------------
#ifdef __cplusplus
 // namespace memory
}
 // namespace sack
}
using namespace sack::memory;
#if defined( _DEBUG ) || defined( _DEBUG_INFO )
/*
inline void operator delete( void * p )
{ Release( p ); }
#ifdef DELETE_HANDLES_OPTIONAL_ARGS
inline void operator delete (void * p DBG_PASS )
{ ReleaseEx( p DBG_RELAY ); }
#define delete delete( DBG_VOIDSRC )
#endif
//#define deleteEx(file,line) delete(file,line)
#ifdef USE_SACK_ALLOCER
inline void * operator new( size_t size DBG_PASS )
{ return AllocateEx( (uintptr_t)size DBG_RELAY ); }
static void * operator new[]( size_t size DBG_PASS )
{ return AllocateEx( (uintptr_t)size DBG_RELAY ); }
#define new new( DBG_VOIDSRC )
#define newEx(file,line) new(file,line)
#endif
*/
// common names - sometimes in conflict when declaring
// other functions... AND - release is a common
// component of iComObject
//#undef Allocate
//#undef Release
// Hmm wonder where this conflicted....
//#undef LineDuplicate
#else
#ifdef USE_SACK_ALLOCER
inline void * operator new(size_t size)
{ return AllocateEx( size ); }
inline void operator delete (void * p)
{ ReleaseEx( p ); }
#endif
#endif
#endif
#endif
#ifdef __LINUX__
#endif
#ifndef _TIMER_NAMESPACE
#ifdef __cplusplus
#define _TIMER_NAMESPACE namespace timers {
#define _TIMER_NAMESPACE_END }
/* define a timer library namespace in C++. */
#define TIMER_NAMESPACE SACK_NAMESPACE namespace timers {
/* define a timer library namespace in C++ end. */
#define TIMER_NAMESPACE_END } SACK_NAMESPACE_END
#else
#define _TIMER_NAMESPACE
#define _TIMER_NAMESPACE_END
#define TIMER_NAMESPACE
#define TIMER_NAMESPACE_END
#endif
#endif
// this is a method replacement to use PIPEs instead of SEMAPHORES
// replacement code only affects linux.
#if defined( __QNX__ ) || defined( __MAC__) || defined( __LINUX__ )
#  if defined( __ANDROID__ ) || defined( EMSCRIPTEN ) || defined( __MAC__ )
// android > 21 can use pthread_mutex_timedop
#    define USE_PIPE_SEMS
#  else
//   Default behavior is to use pthread_mutex_timedlock for wakeable sleeps.
// no semtimedop; no semctl, etc
//#    include <sys/sem.h>
//originally used semctl; but that consumes system resources that are not
//cleaned up when the process exits.
#endif
#endif
#ifdef USE_PIPE_SEMS
#  define _NO_SEMTIMEDOP_
#endif
SACK_NAMESPACE
/* This namespace contains methods for working with timers and
   threads. Since timers are implemented in an asynchronous
   thread, the thread creation and control can be exposed here
   also.
   ThreadTo
   WakeThread
   WakeableSleep [Example]
   AddTimer
   RemoveTimer
   RescheduleTimer
   EnterCriticalSec see Also
 EnterCriticalSecNoWait
   LeaveCriticalSec                                            */
#ifdef __cplusplus
namespace timers {
#endif
#ifdef TIMER_SOURCE
#define TIMER_PROC(type,name) EXPORT_METHOD type CPROC name
#else
/* Defines import export and call method for timers. Looks like
   timers are native calltype by default instead of CPROC.      */
#define TIMER_PROC(type,name) IMPORT_METHOD type CPROC name
#endif
#if defined( __LINUX__ ) || defined( __ANDROID__ )
TIMER_PROC( uint32_t, timeGetTime )( void );
TIMER_PROC( uint32_t, GetTickCount )( void );
TIMER_PROC( void, Sleep )( uint32_t ms );
#endif
/* Function signature for user callbacks passed to AddTimer. */
typedef void (CPROC *TimerCallbackProc)( uintptr_t psv );
/* Adds a new periodic timer. From now, until the timer is
   removed with RemoveTimer, it will call the timer procedure at
   the specified frequency of milliseconds. The delay until the
   first time the timer fires can be specified independant of
   frequency. If it is not specified, the first time the timer
   will get invoked is at +1 frequency from now.
   Parameters
   start :      how long in milliseconds until the timer starts. Can
                be 0 and timer will fire at the next opportunity.
   frequency :  how long the delay is between event invocations,
                in milliseconds.
   callback :   user routine to call when the timer's delay
                expires.
   user :       user data to pass to the callback when it is
                invoked.
   Returns
   a 32 bit ID that identifies the timer for this application.
   Example
   First some setup valid for all timer creations...
   <code lang="c++">
   void CPROC TimerProc( uintptr_t user_data )
   {
       // user_data of the timer is the 'user' parameter passed to AddTimer(Exx)
   }
   </code>
   you might want to save this for something like
   RescheduleTimer
   <code>
   uint32_t timer_id;
   </code>
   Create a simple timer, it will fire at 250 milliseconds from
   now, and again every 250 milliseconds from the time it
   starts.
   <code lang="c++">
   timer_id = AddTimer( 250, TimerProc, 0 );
   </code>
   Create a timer that fires immediately, and 732 milliseconds
   after, passing some value 1234 as user data...
   <code lang="c++">
   timer_id = AddTimerEx( 0, 732, TimerProc, 1234 );
	</code>
	Remarks
	if a timer is dispatched and needs to wait - please link with idlelib, and call Idle.
	this will allow other timers to fire on schedule.  The timer that is waiting is not
	in the list of timers to process.
	*/
TIMER_PROC( uint32_t, AddTimerExx )( uint32_t start, uint32_t frequency
					, TimerCallbackProc callback
					, uintptr_t user DBG_PASS);
/* <combine sack::timers::AddTimerExx@uint32_t@uint32_t@TimerCallbackProc@uintptr_t user>
   \ \                                                                         */
#define AddTimerEx( s,f,c,u ) AddTimerExx( (s),(f),(c),(u) DBG_SRC )
/* <combine sack::timers::AddTimerExx@uint32_t@uint32_t@TimerCallbackProc@uintptr_t user>
   \ \                                                                         */
#define AddTimer( f, c, u ) AddTimerExx( (f), (f), (c), (u) DBG_SRC)
/* Stops a timer. The next time this timer would run, it will be
   removed. If it is currently dispatched, it is safe to remove
   from within the timer itself.
   Parameters
   timer :  32 bit timer ID from AddTimer.                       */
TIMER_PROC( void, RemoveTimer )( uint32_t timer );
/* Reschedule when a timer can fire. The delay can be 0 to make
   wake the timer.
   Parameters
   timer :  32 bit timer identifier from AddTimer.
   delay :  How long before the timer should run now.<p />If 0,
            will issue timer immediately.<p />If not specified,
            using the macro, the default delay is the timer's
            frequency. (can prevent the timer from firing until
            it's frequency from now.)                           */
TIMER_PROC( void, RescheduleTimerEx )( uint32_t timer, uint32_t delay );
/* <combine sack::timers::RescheduleTimerEx@uint32_t@uint32_t>
   \ \                                               */
TIMER_PROC( void, RescheduleTimer )( uint32_t timer );
/* Changes the frequency of a timer. Reschedule timer only
   changes the next time it fires, this can adjust the
   frequency. The simple ChangeTimer macro is sufficient.
   Parameters
   ID :         32 bit ID of the time created by AddTimer.
   initial :    initial delay of the timer. (Might matter if the
                timer hasn't fired the first time)
   frequency :  new delay between timer callback invokations.    */
TIMER_PROC( void, ChangeTimerEx )( uint32_t ID, uint32_t initial, uint32_t frequency );
/* <combine sack::timers::ChangeTimerEx@uint32_t@uint32_t@uint32_t>
   \ \                                               */
#define ChangeTimer( ID, Freq ) ChangeTimerEx( ID, Freq, Freq )
/* This is the type returned by MakeThread, and passed to
   ThreadTo. This is a private structure, and no definition is
   publicly available, this should be treated like a handle.   */
typedef struct threads_tag *PTHREAD;
/* Function signature for a thread entry point passed to
   ThreadTo.                                             */
typedef uintptr_t (CPROC*ThreadStartProc)( PTHREAD );
/* Function signature for a thread entry point passed to
   ThreadToSimple.                                             */
typedef uintptr_t (*ThreadSimpleStartProc)( POINTER );
/*
  OnThreadCreate allows registering a procedure to run
  when a thread is created.  (Or an existing thread becomes
  tracked within this library, via MakeThread() ).
  It is called once per thread, for each thread created
  after registering the callback.
*/
TIMER_PROC( void, OnThreadCreate )( void ( *v )( void ) );
/*
  OnThreadExit allows registering a procedure to run
  when a thread exits.
  It is called once per thread, for each thread that exits
  after registering the callback.
*/
TIMER_PROC( void, OnThreadExit )( void ( *v )( void ) );
/* Create a separate thread that starts in the routine
   specified. The uintptr_t value (something that might be a
   pointer), is passed in the PTHREAD structure. (See
   GetThreadParam)
   Parameters
   proc :       starting routine for the thread
   user_data :  some value that can be stored in the number of
                bits that a pointer is. This is passed to the
                proc when the thread starts.
   Example
   See WakeableSleepEx.                                        */
TIMER_PROC( PTHREAD, ThreadToEx )( ThreadStartProc proc, uintptr_t param DBG_PASS );
/* <combine sack::timers::ThreadToEx@ThreadStartProc@uintptr_t param>
   \ \                                                               */
#define ThreadTo(proc,param) ThreadToEx( proc,param DBG_SRC )
/* Create a separate thread that starts in the routine
   specified. The uintptr_t value (something that might be a
   pointer), is passed in the PTHREAD structure. (See
   GetThreadParam)
   Parameters
   proc :       starting routine for the thread
   user_data :  some value that can be stored in the number of
                bits that a pointer is. This is passed to the
                proc when the thread starts.
   Example
   See WakeableSleepEx.                                        */
TIMER_PROC( PTHREAD, ThreadToSimpleEx )( ThreadSimpleStartProc proc, POINTER param DBG_PASS );
/* <combine sack::timers::ThreadToEx@ThreadStartProc@uintptr_t param>
   \ \                                                               */
#define ThreadToSimple(proc,param) ThreadToSimpleEx( proc,param DBG_SRC )
/* \Returns a PTHREAD that represents the current thread. This
   can be used to create a PTHREAD identifier for the main
   thread.
   Parameters
   None.
   Returns
   a pointer to a thread structure that identifies the current
   thread. If this thread already has this structure created,
   the same one results on subsequent MakeThread calls.        */
TIMER_PROC( PTHREAD, MakeThread )( void );
/* This returns the parameter passed as user data to ThreadTo.
   Parameters
   thread :  thread to get the parameter from.
   Example
   See WakeableSleepEx.                                        */
TIMER_PROC( uintptr_t, GetThreadParam )( PTHREAD thread );
/* \returns the numeric THREAD_ID from a PTHREAD.
   Parameters
   thread :  thread to get the system wide unique ID of. */
TIMER_PROC( THREAD_ID, GetThreadID )( PTHREAD thread );
/* \returns the numeric THREAD_ID from a PTHREAD.
   Parameters
   thread :  thread to get the system wide unique ID of. */
TIMER_PROC( THREAD_ID, GetThisThreadID )( void );
/* Symbol defined to pass to Wakeable_Sleep to sleep until
   someone calls WakeThread.                               */
#define SLEEP_FOREVER 0xFFFFFFFF
/* Sleeps a number of milliseconds or until the thread is passed
   to WakeThread.
   Parameters
   dwMilliseconds :  How long to sleep. Can be indefinite if
                     value is SLEEP_FOREVER.
   Example
   <code lang="c++">
   PTHREAD main_thread;
   uintptr_t CPROC WakeMeThread( PTHREAD thread )
   {
      // get the value passed to ThreadTo as user_data.
      uintptr_t user_data = GetThreadParam( thread );
      // let the main thread sleep a little wile
       WakeableSleep( 250 );
      // then wake it up
       WakeThread( main_thread );
       return 0;
   }
   int main( void )
   {
       // save my PTHREAD globally.
       main_thread = MakeThread();
       // create a thread that can wake us
       ThreadTo( WakeMeThread, 0 );
       // demonstrate sleeping
       WakableSleep( SLEEP_FOREVER );
       return 0;
   }
   </code>                                                       */
TIMER_PROC( void, WakeableSleepEx )( uint32_t milliseconds DBG_PASS );
TIMER_PROC( void, WakeableSleep )( uint32_t milliseconds );
TIMER_PROC( void, WakeableNamedSleepEx )( CTEXTSTR name, uint32_t n DBG_PASS );
#define WakeableNamedSleep( name, n )   WakeableNamedSleepEx( name, n DBG_SRC )
TIMER_PROC( void, WakeNamedSleeperEx )( CTEXTSTR name DBG_PASS );
#define WakeNamedSleeper( name )   WakeNamedSleeperEx( name DBG_SRC )
TIMER_PROC( void, WakeableNamedThreadSleepEx )( CTEXTSTR name, uint32_t n DBG_PASS );
#define WakeableNamedThreadSleep( name, n )   WakeableNamedThreadSleepEx( name, n DBG_SRC )
TIMER_PROC( void, WakeNamedThreadSleeperEx )( CTEXTSTR name, THREAD_ID therad DBG_PASS );
#define WakeNamedThreadSleeper( name, thread )   WakeNamedThreadSleeperEx( name, thread DBG_SRC )
#ifdef USE_PIPE_SEMS
TIMER_PROC( int, GetThreadSleeper )( PTHREAD thread );
#endif
/* <combine sack::timers::WakeableSleepEx@uint32_t milliseconds>
   \ \                                                      */
#define WakeableSleep(n) WakeableSleepEx(n DBG_SRC )
/* Wake a thread by ID, if the pThread is not available. Can be
   used cross-process for instance. Although someone could add a
   method to provide a PTHREAD wrapper around THREAD_ID for
   threads in remote processes, this may not be a best practice.
   Parameters
   thread_id :  THREAD_ID from GetMyThreadID, which is a macro
                appropriate for a platform.                      */
TIMER_PROC( void, WakeThreadIDEx )( THREAD_ID thread DBG_PASS );
/* Wake a thread.
   Example
   See WakeableSleepEx.
   Parameters
   pThread :  thread to wake up from a WakeableSleep. */
TIMER_PROC( void, WakeThreadEx )( PTHREAD thread DBG_PASS );
/* <combine sack::timers::WakeThreadIDEx@THREAD_ID thread>
   \ \                                                     */
#define WakeThreadID(thread) WakeThreadIDEx( thread DBG_SRC )
/* <combine sack::timers::WakeThreadEx@PTHREAD thread>
   \ \                                                 */
#define WakeThread(t) WakeThreadEx(t DBG_SRC )
/* This can be checked to see if the THREAD_ID to wake still has
   an event. Sometimes threads end.
   Parameters
   thread :  thread identifier to check to see if it exists/can be
             woken.
   Returns
   TRUE if the thread can be signaled to wake up.
   FALSE if the thread cannot be found or cannot be woken up.      */
TIMER_PROC( int, TestWakeThreadID )( THREAD_ID thread );
/* This can be checked to see if the PTHREAD to wake still has
   an event. Sometimes threads call UnmakeThread(). This is a
   more practical test using a THREAD_ID instead. See
   TestWakeThreadID.
   Returns
   TRUE if the thread can be signaled to wake up.
   FALSE if the thread cannot be found or cannot be woken up.  */
TIMER_PROC( int, TestWakeThread )( PTHREAD thread );
//TIMER_PROC( void, WakeThread )( PTHREAD thread );
TIMER_PROC( void, EndThread )( PTHREAD thread );
/* This tests to see if a pointer to a thread references the
   current thread.
   Parameters
   thread :  thread to check to see if it is the current thread.
   Returns
   TRUE if this thread is the same as the PTHREAD passed.
   otherwise FALSE.
   Example
   <code lang="c++">
   PTHREAD main_thread;
   LOGICAL thread_finished_check;
   uintptr_t CPROC ThreadProc( PTHREAD thread )
   {
       if( IsThisThread( main_thread ) )
            printf( "This thread is not the main thread.\\n" );
       else
            printf( "This is the main thread - cannot happen :)\\n" );
   </code>
   <code>
       // mark that this thread is complete
       thread_finished_check = TRUE;
   </code>
   <code lang="c++">
       // hmm - for some reason, just pass the uintptr_t that was passed to ThreadTo as the result.
       return GetThreadParam( thread );
   }
   int main( void )
   {
        main_thread = MakeThread();
        ThreadTo( ThreadProc, 0 );
        // wait for the thread to finish its thread identity check.
        while( !thread_finished_check )
            Relinquish();
        return 0;
   }
   </code>                                                                                         */
TIMER_PROC( int, IsThisThreadEx )( PTHREAD pThreadTest DBG_PASS );
/* <combine sack::timers::IsThisThreadEx@PTHREAD pThreadTest>
   \ \                                                        */
#define IsThisThread(thread) IsThisThreadEx(thread DBG_SRC)
/* Enter a critical section. Only a single thread may be in a
   critical section, if a second thread attempts to enter the
   section while another thread is in it will block until the
   original thread leaves the section. The same thread may enter
   a critical section multiple times. For each time a critical
   section is entered, the thread must also leave the critical
   section (See LeaveCriticalSection).
   Parameters
   pcs :  pointer to a critical section to enter                 */
TIMER_PROC( LOGICAL, EnterCriticalSecEx )( PCRITICALSECTION pcs DBG_PASS );
/* Leaves a critical section. See EnterCriticalSecEx.
   Parameters
   pcs :  pointer to a critical section.              */
TIMER_PROC( LOGICAL, LeaveCriticalSecEx )( PCRITICALSECTION pcs DBG_PASS );
/* Does nothing. There are no extra resources required for
   critical sections, and the memory is allocated by the
	application; native windows criticalsections allocate an
   external object; this should be called typically.
   Parameters
   pcs :  pointer to critical section to do nothing with.  */
TIMER_PROC( void, DeleteCriticalSec )( PCRITICALSECTION pcs );
#ifdef _WIN32
	TIMER_PROC( HANDLE, GetWakeEvent )( void );
	TIMER_PROC( HANDLE, GetThreadHandle )( PTHREAD thread );
#endif
#ifdef __LINUX__
	TIMER_PROC( pthread_t, GetThreadHandle )(PTHREAD thread);
#endif
#ifdef USE_NATIVE_CRITICAL_SECTION
#  define EnterCriticalSec(pcs) EnterCriticalSection( pcs )
#  define LeaveCriticalSec(pcs) LeaveCriticalSection( pcs )
#  if DBG_AVAILABLE
#    define EnterCriticalSecEx(pcs, a, b) EnterCriticalSection( pcs )
#    define LeaveCriticalSecEx(pcs, a, b) LeaveCriticalSection( pcs )
#    define InitializeCriticalSecEx(pcs, a, b) InitializeCriticalSection( pcs )
#  else
#    define EnterCriticalSecEx(pcs) EnterCriticalSection( pcs )
#    define LeaveCriticalSecEx(pcs) LeaveCriticalSection( pcs )
#    define InitializeCriticalSecEx(pcs) InitializeCriticalSection( pcs )
#  endif
#else
/* <combine sack::timers::EnterCriticalSecEx@PCRITICALSECTION pcs>
   \ \                                                             */
#define EnterCriticalSec( pcs ) EnterCriticalSecEx( (pcs) DBG_SRC )
/* <combine sack::timers::LeaveCriticalSecEx@PCRITICALSECTION pcs>
   \ \                                                             */
#define LeaveCriticalSec( pcs ) LeaveCriticalSecEx( (pcs) DBG_SRC )
#endif
TIMER_NAMESPACE_END
#ifdef __cplusplus
using namespace sack::timers;
#endif
#endif
// $Log: timers.h,v $
// Revision 1.37  2005/05/16 19:06:58  jim
// Extend wakeable sleep to know the originator of the sleep.
//
// Revision 1.36  2004/09/29 16:42:51  d3x0r
// fixed queues a bit - added a test wait function for timers/threads
//
// Revision 1.35  2004/07/07 15:33:54  d3x0r
// Cleaned c++ warnings, bad headers, fixed make system, fixed reallocate...
//
// Revision 1.34  2004/05/02 02:04:16  d3x0r
// Begin border exclusive option, define PushMethod explicitly, fix LaunchProgram in timers.h
//
// Revision 1.33  2003/12/10 15:38:25  panther
// Move Sleep and GetTickCount to real code
//
// Revision 1.32  2003/11/02 00:31:47  panther
// Added debuginfo pass to wakethread
//
// Revision 1.31  2003/10/24 14:59:21  panther
// Added Load/Unload Function for system shared library abstraction
//
// Revision 1.30  2003/10/17 00:56:04  panther
// Rework critical sections.
// Moved most of heart of these sections to timers.
// When waiting, sleep forever is used, waking only when
// released... This is preferred rather than continuous
// polling of section with a Relinquish.
// Things to test, event wakeup order uner linxu and windows.
// Even see if the wake ever happens.
// Wake should be able to occur across processes.
// Also begin implmeenting MessageQueue in containers....
// These work out of a common shared memory so multiple
// processes have access to this region.
//
// Revision 1.29  2003/09/21 04:03:30  panther
// Build thread ID with pthread_self and getgid
//
// Revision 1.28  2003/07/29 10:41:25  panther
// Predefine struct threads_tag to avoid warning
//
// Revision 1.27  2003/07/24 22:49:20  panther
// Define callback procs as CDECL
//
// Revision 1.26  2003/07/24 16:56:41  panther
// Updates to expliclity define C procedure model for callbacks and assembly modules - incomplete
//
// Revision 1.25  2003/07/22 15:33:19  panther
// Added comment about idle()
//
// Revision 1.24  2003/04/03 10:10:20  panther
// Add file/line debugging to addtimer
//
// Revision 1.23  2003/03/27 13:47:14  panther
// Immplement a EndThread
//
// Revision 1.22  2003/03/25 08:38:11  panther
// Add logging
//
#ifndef MAXPATH
// windef.h has MAX_PATH
#  define MAXPATH MAX_PATH
#  if (!MAXPATH)
#    undef MAXPATH
#    define MAXPATH 256
#  endif
#endif
#ifndef PATH_MAX
// sometimes PATH_MAX is what's used, well it's should be MAXPATH which is MAX_PATH
# define PATH_MAX MAXPATH
#endif
#ifdef _WIN32
#  ifdef CONSOLE_SHELL
 // in order to get wide characters from the commandline we have to use the GetCommandLineW function, convert it to utf8 for internal usage.
#    define SaneWinMain(a,b) int main( int a, char **argv_real ) { char *tmp; TEXTCHAR **b; ParseIntoArgs( tmp = WcharConvert( GetCommandLineW() ), &a, &b ); Deallocate( char*, tmp ); {
#    define EndSaneWinMain() } }
#  else
#    define SaneWinMain(a,b) int APIENTRY WinMain( HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmdLine, int nCmdShow ) { int a; char *tmp; TEXTCHAR **b; ParseIntoArgs( tmp = WcharConvert( GetCommandLineW() ), &a, &b ); {
#    define EndSaneWinMain() } }
#  endif
#else
#  if defined( __ANDROID__ ) && !defined( ANDROID_CONSOLE_UTIL )
#    define SaneWinMain(a,b) int SACK_Main( int a, char **b )
#    define EndSaneWinMain()
#  else
#    define SaneWinMain(a,b) int main( int a, char **b ) { char **argv_real = b; {
#    define EndSaneWinMain() } }
#  endif
#endif
/**
 * https://stackoverflow.com/questions/3585583/convert-unix-linux-time-to-windows-filetime
 * number of seconds from 1 Jan. 1601 00:00 to 1 Jan 1970 00:00 UTC
 * subtract from FILETIME to get timespec
 * add to timespec to get FILETIME ticks.
 * * 1000000000
 */
#define EPOCH_DIFF 11644473600ULL
#define EPOCH_DIFF_MS 11644473600000ULL
#define EPOCH_DIFF_NS 11644473600000000000ULL
#ifdef WIN32
DeclareThreadLocal FILETIME ft;
// we want this as fast as possible, so inline always.
#define timeGetTime64ns( ) ( GetSystemTimeAsFileTime( &ft ),((uint64_t*)&ft)[0]*100-EPOCH_DIFF_NS )
#define timeGetTime64( ) ( GetSystemTimeAsFileTime( &ft ),((uint64_t*)&ft)[0]/10000-EPOCH_DIFF_MS )
#define timeGetTime() (uint32_t)(timeGetTime64())
#else
DeclareThreadLocal struct timespec global_static_time_ts;
#define timeGetTime64ns( ) ( clock_gettime(CLOCK_REALTIME, &global_static_time_ts), (uint64_t)global_static_time_ts.tv_sec*(uint64_t)1000000000 + (uint64_t)global_static_time_ts.tv_nsec )
#define timeGetTime64( ) ( clock_gettime(CLOCK_REALTIME, &global_static_time_ts), (uint64_t)global_static_time_ts.tv_sec*(uint64_t)1000 + (uint64_t)global_static_time_ts.tv_nsec/1000000 )
#define timeGetTime() (uint32_t)(timeGetTime64())
#endif
#define tickToTimeSpec(ts,tick) (((ts).tv_sec = (tick) / 1000ULL),((ts).tv_nsec=((tick)%1000ULL)*1000000ULL))
#define tickToFileTime(ft,tick) ((((ft).highPart).tv_sec = ((tick*10000)+EPOCH_DIFF_MS)>>32 ),(((ft).lowPart)=((tick*10000)+EPOCH_DIFF_MS) & 0XFFFFFFFF ))
#define tickNsToTimeSpec(ts,tick) (((ts).tv_sec = (tick) / 1000000000ULL),((ts).tv_nsec=(tick)%1000000000ULL))
#define tickNsToFileTime(ft,tick) ((((ft).highPart).tv_sec = ((tick)+EPOCH_DIFF_NS)>>32 ),(((ft).lowPart)=((tick)+EPOCH_DIFF_NS) & 0XFFFFFFFF ))
//  these are rude defines overloading otherwise very practical types
// but - they have to be dispatched after all standard headers.
#ifndef FINAL_TYPES
#define FINAL_TYPES
#  ifdef __WATCOMC__
 //__WATCOMC__
#  endif
#  ifdef _WIN32
#    include <basetsd.h>
  // this redefines lprintf sprintf etc... and strsafe is preferred
 // more things that need override by strsafe.h
#    include <tchar.h>
 // added for mingw64 actually
#    ifdef __GNUC__
#      undef __CRT__NO_INLINE
#    endif
#    ifndef MINGW_SUX
#      include <strsafe.h>
#    else
#      define STRSAFE_E_INSUFFICIENT_BUFFER  0x8007007AL
#    endif
#  else
#  endif
// may consider changing this to uint16_t* for unicode...
#ifdef UNICODE
#  ifndef NO_UNICODE_C
#    define strrchr          wcsrchr
#    define strchr           wcschr
#    define strncpy          wcsncpy
#    ifdef strcpy
#      undef strcpy
#    endif
#    define strcpy           wcscpy
#    define strcmp           wcscmp
#    ifndef __LINUX__
// linux also translates 'i' to 'case' in sack_typelib.h
#      define stricmp          wcsicmp
#      define strnicmp         wcsnicmp
//#  define strlen           mbrlen
#    endif
#    define strlen           wcslen
#    ifdef WIN32
#      define stat(a,b)        _wstat(a,b)
#    else
#    endif
#    define printf           wprintf
#    define fprintf          fwprintf
#    define fputs            fputws
#    define fgets            fgetws
#    define atoi             _wtoi
#    ifdef __WATCOMC__
#      undef atof
#    endif
//#    define atof             _wtof
#    ifdef _MSC_VER
#      ifndef __cplusplus_cli
#        define fprintf   fwprintf
#        define atoi      _wtoi
// define sprintf here.
#      endif
#    endif
#    if defined( _ARM_ ) && defined( WIN32 )
// len should be passed as character count. this was the wrongw ay to default this.
#      define snprintf StringCbPrintf
//#define snprintf StringCbPrintf
#    endif
#  else
//#    define atoi             wtoi
#  endif
 // not unicode...
#else
#endif
#  ifdef _MSC_VER
#    define snprintf _snprintf
#    define vsnprintf _vsnprintf
#    if defined( _UNICODE )
#      define tnprintf _snwprintf
#      define vtnprintf _vsnwprintf
#    else
#      define tnprintf _snprintf
#      define vtnprintf _vsnprintf
#    endif
#    define snwprintf _snwprintf
#    if defined( _UNICODE ) && !defined( NO_UNICODE_C )
#    define tscanf swscanf_s
#    else
#    define tscanf sscanf_s
#    endif
#    define scanf sscanf_s
#    define swcanf swscanf_s
 // _MSC_VER
#  endif
#  ifdef  __GNUC__
#      if defined( _UNICODE )
#        define VSNPRINTF_FAILS_RETURN_SIZE
#        define tnprintf  swprintf
#        define vtnprintf vswprintf
#        if !defined( NO_UNICODE_C )
#           define snprintf   swprintf
#           define vsnprintf  vswprintf
//#           define sscanf     swscanf
#        else
#        endif
#      else
#        define tnprintf snprintf
#        define vtnprintf vsnprintf
//#        define snprintf snprintf
//#        define vsnprintf vsnprintf
#    if defined( _UNICODE ) && !defined( NO_UNICODE_C )
#    define tscanf swscanf
#    else
#    define tscanf sscanf
#    endif
#      endif
 // __GNUC__
#  endif
#  ifdef __WATCOMC__
#      if defined( _UNICODE )
#        define tnprintf  _snwprintf
#        define vtnprintf _vsnwprintf
#        if !defined( NO_UNICODE_C )
#           define snprintf  _snwprintf
#           define vsnprintf _vsnwprintf
#           define sscanf     swscanf
#        else
#        endif
#      else
#         define tnprintf  snprintf
#         define vtnprintf vsnprintf
//#        define snprintf snprintf
//#        define vsnprintf vsnprintf
#      endif
#        define snwprintf  _snwprintf
 // __WATCOMC__
#  endif
#endif
#endif
 // tolower on linux
#  include <ctype.h>
/*
 *  Created By Jim Buckeyne
 *
 *  Purpose:
 *    Provides some cross platform/library functionatlity for
 *  filesystem activities.
 *  - File dates, times, stuff like that
 *  - make paths, change paths
 *  - path parsing (like strchr, strrchr, but looking for closest / or \)
 *  - scan a directory for a set of files... using a recursive callback method
 */
#ifndef FILESYSTEM_UTILS_DEFINED
/* Header multiple inclusion protection symbol. */
#define FILESYSTEM_UTILS_DEFINED
#if _MSC_VER >= 1600
#include <share.h>
#endif
#if !defined( UNDER_CE )
#include <fcntl.h>
#if !defined( __LINUX__ )
#include <io.h>
#else
#define LPFILETIME uint64_t*
#define FILETIME uint64_t
#endif
#endif
/* uhmm in legacy usage this was not CPROC, but was unspecified */
#define FILESYS_API CPROC
// DOM-IGNORE-BEGIN
#ifdef FILESYSTEM_LIBRARY_SOURCE
#  define FILESYS_PROC EXPORT_METHOD
#else
#  define FILESYS_PROC IMPORT_METHOD
#endif
// DOM-IGNORE-END
#ifdef __cplusplus
/* defined the file system partial namespace (under
   SACK_NAMESPACE probably)                         */
#define _FILESYS_NAMESPACE  namespace filesys {
/* Define the ending symbol for file system namespace. */
#define _FILESYS_NAMESPACE_END }
/* Defined the namespace of file montior utilities. File monitor
   provides event notification based on file system changes.     */
#define _FILEMON_NAMESPACE  namespace monitor {
/* Define the end symbol for file monitor namespace. */
#define _FILEMON_NAMESPACE_END }
#else
#define _FILESYS_NAMESPACE
#define _FILESYS_NAMESPACE_END
#define _FILEMON_NAMESPACE
#define _FILEMON_NAMESPACE_END
#endif
/* define the file system namespace end. */
#define FILESYS_NAMESPACE_END _FILESYS_NAMESPACE_END SACK_NAMESPACE_END
/* define the file system namespace. */
#define FILESYS_NAMESPACE SACK_NAMESPACE _FILESYS_NAMESPACE
/* Define end file monitor namespace. */
#define FILEMON_NAMESPACE_END _FILEMON_NAMESPACE_END _FILESYS_NAMESPACE_END SACK_NAMESPACE_END
/* Defines the file montior namespace when compiling C++. */
#define FILEMON_NAMESPACE SACK_NAMESPACE _FILESYS_NAMESPACE _FILEMON_NAMESPACE
#ifdef __cplusplus
namespace sack {
#endif
/* \File system abstractions. A few things like get current path
   may or may not exist on a function.
   Primarily this defines functions 'pathchr' and 'pathrchr'
   which resemble 'strchr' and 'strrchr' but search a string for
   a path character. A path character is either a / or a \\.
   Also in this area is file monitoring functions which support
   methods on windows and linux to get event notifications when
   directories and, by filtering, files that have changed.
                                                                 */
#ifdef __cplusplus
	namespace filesys {
#endif
	enum ScanFileFlags {
SFF_DEFAULT = 0,
 // go into subdirectories
SFF_SUBCURSE    = 1,
 // return directory names also
SFF_DIRECTORIES = 2,
 // don't concatenate base with filename to result.
SFF_NAMEONLY    = 4,
 // when matching filename - do not match case.
SFF_IGNORECASE  = 8,
 // don't concatenate base with filename to result, but do build path relative to root specified
SFF_SUBPATHONLY    = 16,
	};
 // flags sent to Process when called with a matching name
enum ScanFileProcessFlags{
 // is a directory...
SFF_DIRECTORY  = 1,
 // this is a drive...
		SFF_DRIVE      = 2,
};
struct file_system_mounted_interface;
/* Extended external file system interface to be able to use external file systems */
struct file_system_interface {
                                                  //filename
	void* (CPROC *open)(uintptr_t psvInstance, const char *, const char *);
                                                 //file *
	int (CPROC *_close)(void *);
                    //file *, buffer, length (to read)
	size_t (CPROC *_read)(void *,void *, size_t);
                    //file *, buffer, length (to write)
	size_t (CPROC *_write)(void*,const void *, size_t);
	size_t (CPROC *seek)( void *, size_t, int whence);
	void  (CPROC *truncate)( void *);
	int (CPROC *_unlink)( uintptr_t psvInstance, const char *);
 // get file size
	size_t (CPROC *size)( void *);
 // get file current position
	size_t (CPROC *tell)( void *);
	int (CPROC *flush )(void *kp);
	int (CPROC *exists)( uintptr_t psvInstance, const char *file );
	LOGICAL (CPROC*copy_write_buffer)(void );
	struct find_cursor *(CPROC *find_create_cursor )( uintptr_t psvInstance, const char *root, const char *filemask );
	int (CPROC *find_first)( struct find_cursor *cursor );
	int (CPROC *find_close)( struct find_cursor *cursor );
	int (CPROC *find_next)( struct find_cursor *cursor );
	char * (CPROC *find_get_name)( struct find_cursor *cursor );
	size_t (CPROC *find_get_size)( struct find_cursor *cursor );
	LOGICAL (CPROC *find_is_directory)( struct find_cursor *cursor );
	LOGICAL (CPROC *is_directory)( uintptr_t psvInstance, const char *cursor );
	LOGICAL (CPROC *rename )( uintptr_t psvInstance, const char *original_name, const char *new_name );
	uintptr_t (CPROC *ioctl)( uintptr_t psvInstance, uintptr_t opCode, va_list args );
	uintptr_t (CPROC *fs_ioctl)(uintptr_t psvInstance, uintptr_t opCode, va_list args);
	uint64_t( CPROC *find_get_ctime )(struct find_cursor *cursor);
	uint64_t( CPROC *find_get_wtime )(struct find_cursor *cursor);
	int ( CPROC* _mkdir )( uintptr_t psvInstance, const char* );
	int ( CPROC* _rmdir )( uintptr_t psvInstance, const char* );
                //file *
	int (CPROC* _lock)(void*);
              //file *
	int (CPROC* _unlock)(void*);
 // set chmod( filename, 0777 )
	int (CPROC* _make_public)( uintptr_t psvInstance, CTEXTSTR filename );
	int ( CPROC* _chdir )( uintptr_t psvInstance, const char* );
};
/* \ \
   Parameters
   mask :      This is the mask used to compare
   name :      this is the name to compare against using the mask.
   keepcase :  if TRUE, must match case also.
   Returns
   TRUE if name is matched by mask. Otherwise returns FALSE.
   Example
   <code lang="c++">
   if( CompareMask( "*.exe", "program.exe", FALSE ) )
   {
       // then program.exe is matched by the mask.
   }
   </code>
   Remarks
   The mask support standard 'globbing' characters.
   ? matches one character
   \* matches 0 or more characters
   otherwise the literal character must match, unless comparing
   case insensitive, in which case 'A' == 'a' also.                */
FILESYS_PROC  int FILESYS_API  CompareMask ( CTEXTSTR mask, CTEXTSTR name, int keepcase );
// ScanFiles usage:
//   base - base path to scan
//   mask - file mask to process if NULL or "*" is everything "*.*" must contain a .
//   pInfo is a pointer to a void* - this pointer is used to maintain
//        internal information...
//   Process is called with the full name of any matching files
//   subcurse is a flag - set to go into all subdirectories looking for files.
// There is no way to abort the scan...
FILESYS_PROC  int FILESYS_API  ScanFilesEx ( CTEXTSTR base
           , CTEXTSTR mask
           , void **pInfo
           , void CPROC Process( uintptr_t psvUser, CTEXTSTR name, enum ScanFileProcessFlags flags )
           , enum ScanFileFlags flags
		   , uintptr_t psvUser, LOGICAL begin_sub_path, struct file_system_mounted_interface *mount );
FILESYS_PROC  int FILESYS_API  ScanFiles ( CTEXTSTR base
           , CTEXTSTR mask
           , void **pInfo
           , void CPROC Process( uintptr_t psvUser, CTEXTSTR name, enum ScanFileProcessFlags flags )
           , enum ScanFileFlags flags
           , uintptr_t psvUser );
FILESYS_PROC  void FILESYS_API  ScanDrives ( void (CPROC *Process)(uintptr_t user, CTEXTSTR letter, int flags)
										  , uintptr_t user );
// pass the pointer (pInfo) from aobve; get find_cursor.
FILESYS_PROC struct find_cursor * FILESYS_API GetScanFileCursor( void *pInfo );
// result is length of name filled into pResult if pResult == NULL && nResult = 0
// the result will the be length of the name matching the file.
FILESYS_PROC  int FILESYS_API  GetMatchingFileName ( CTEXTSTR filemask, enum ScanFileFlags flags, TEXTSTR pResult, int nResult );
// searches a path for the last '/' or '\'
FILESYS_PROC  CTEXTSTR FILESYS_API  pathrchr ( CTEXTSTR path );
// searches a path for the last '/' or '\'
FILESYS_PROC  const wchar_t* FILESYS_API  pathrchrW( const wchar_t* path );
#ifdef __cplusplus
FILESYS_PROC  TEXTSTR FILESYS_API  pathrchr ( TEXTSTR path );
FILESYS_PROC  wchar_t* FILESYS_API pathrchrW( wchar_t* path );
#endif
// searches a path for the first '/' or '\'
FILESYS_PROC  CTEXTSTR FILESYS_API  pathchr ( CTEXTSTR path );
/*
   compares filenames case insensitively and slash agnostic
*/
FILESYS_PROC int FILESYS_API PathCmpEx( CTEXTSTR s1, CTEXTSTR s2, int maxlen );
/*
   compares filenames case insensitively and slash agnostic.  Uses PathCmpEx() with maxlen=65535
*/
FILESYS_PROC int FILESYS_API PathCmp( CTEXTSTR s1, CTEXTSTR s2 );
// returns pointer passed (if it worked?)
FILESYS_PROC  TEXTSTR FILESYS_API  GetCurrentPath ( TEXTSTR path, int buffer_len );
FILESYS_PROC  int FILESYS_API  SetCurrentPath ( CTEXTSTR path );
/* Creates a directory. If parent pieces of the directory do not
   exist, those parts are created also.
   Example
   <code lang="c#">
   MakePath( "c:\\where\\I'm/going/to/store/data" );
   </code>                                                       */
FILESYS_PROC  int FILESYS_API  MakePath ( CTEXTSTR path );
/* A boolean result function whether a specified name is a
   directory or not. (if not, assumes it's a file).
   Example
   <code lang="c#">
   if( IsPath( "c:/windows" ) )
   {
       // if yes, then c:\\windows is a directory.
   }
   </code>                                                 */
FILESYS_PROC LOGICAL  FILESYS_API  IsPath ( CTEXTSTR path );
FILESYS_PROC LOGICAL  FILESYS_API  IsAbsolutePath( CTEXTSTR path );
FILESYS_PROC  uint64_t     FILESYS_API  GetFileWriteTime ( CTEXTSTR name );
FILESYS_PROC  uint64_t     FILESYS_API  GetTimeAsFileTime ( void );
FILESYS_PROC  LOGICAL FILESYS_API  SetFileWriteTime( CTEXTSTR name, uint64_t filetime );
FILESYS_PROC  LOGICAL FILESYS_API  SetFileTimes( CTEXTSTR name
  // last modification time.
															  , uint64_t filetime_create
 // last modification time.
															  , uint64_t filetime_modify
  // last modification time.
															  , uint64_t filetime_access
															  );
FILESYS_PROC  void    FILESYS_API  SetDefaultFilePath ( CTEXTSTR path );
FILESYS_PROC  INDEX   FILESYS_API  SetGroupFilePath ( CTEXTSTR group, CTEXTSTR path );
FILESYS_PROC  TEXTSTR FILESYS_API  sack_prepend_path ( INDEX group, CTEXTSTR filename );
/* This is a new feature added for supporting systems without a
   current file location. This gets an integer ID of a group of
   files by name.
   the name 'default' is used to specify files to go into the
   'current working directory'
	There are some special symbols.
	. = use CurrentPath
	@ = use program path base
   ^ = use program startup path (may not be current)
   Parameters
   groupname :     name of the group
   default_path :  the path of the group, if the name is not
                   found.
   Returns
   the ID of a file group.
   Example
   <code lang="c++">
   int group = GetFileGroup( "fonts", "./fonts" );
   </code>                                                      */
FILESYS_PROC INDEX FILESYS_API  GetFileGroup ( CTEXTSTR groupname, CTEXTSTR default_path );
/*
   Get the path the filegroup is defined as; or has been reloaded from option
   database as.
*/
FILESYS_PROC TEXTSTR FILESYS_API GetFileGroupText ( INDEX group, TEXTSTR path, int path_chars );
/*
ExpandPath() returns a string, which the caller must release.  The path is insepcted to see if it is
an absolute path ( '/' on unix or '?:/' on windows, where ? is any character).  All checks for slashes
check both `\` and `/` as the same character.
If it is absolute, it returns a copy of the path.
If the path starts with a special character followed by a slash, then the character is replaced.
|character| meaning|
|---|----|
|'./'| the current directory.  The dot is replaced with the full path to the current directory. |
|'~/'|the home directory.  The `~` is replaced with `HOME` (on *nix) or `HOMEPATH`(on windows), and '.' (on android). This is also checked after all of these have previously been checked. so ';' can use '~'|
|`@/`| the libraries path.  This is the path of the library or program currently running the filesystem abstraction. |
|'?/'| %resources%.  This is defaulted to the install location, and is the common resources instealled with SACK. |
|'^/'| Startup path.  This is the first path the application started in.  This is often the same as current directory, but current directoy can change. |
|'*' '/'| on linux this is /var/Freedom Collective/<application>, on windows this is c:/programdata/Freedom Collective/<application.  This is actually (common writeable data/<provider>/<application>/ and it is possible to set/change the provider name.  The application name is determined by the name used to run the program.|
|';/'| on linux this is ~/.[provider]/<application>, on windows this is c:/users/<user>/programdata/[provider]/[application].
The default `[provider]` is Freedom Collective (shrug) needed to come up with a company name at some point.  To date
there is no company other than in name only.
Varibles bounded by `%` are replaced with file group path, if there is no filepath, then the name is looked up
in the environment and that's used.
The path characters `/` and `\` are then forced to the host system preferred type of slash.  Although windows
has been agnositic, updating the interfaces on windows to the system to be unicode(since ascii isn't uft8),
the wide APIs require `\`; and really linux requires `/`.
Finally relative paths that are left are resolved, if there is a path part before the `..` to remove.
*/
FILESYS_PROC TEXTSTR FILESYS_API ExpandPathExx( CTEXTSTR path, struct file_system_interface* fsi DBG_PASS );
#define ExpandPathEx( path, fsi )  ExpandPathExx( path, fsi DBG_SRC )
#define ExpandPath(path) ExpandPathExx( path, NULL DBG_SRC )
FILESYS_PROC LOGICAL FILESYS_API SetFileLength( CTEXTSTR path, size_t length );
/* \Returns the size of the file.
   Parameters
   name :  name of the file to get information about
   Returns
   \Returns the size of the file. or -1 if the file did not
   exist.                                                   */
FILESYS_PROC  size_t FILESYS_API  GetSizeofFile ( TEXTCHAR *name, uint32_t* unused );
#ifndef __ANDROID__
/* An extended function, which returns a uint64_t bit time
   appropriate for the current platform. This is meant to
   replace 'stat'. It can get all commonly checked attributes of
   a file.
   Parameters
   name :              name of the file to get information about
   lpCreationTime :    pointer to a FILETIME type to get creation
                       time. can be NULL.
   lpLastAccessTime :  pointer to a FILETIME type to get access
                       time. can be NULL.
   lpLastWriteTime :   pointer to a FILETIME type to get write
                       time. can be NULL.
   IsDirectory :       pointer to a LOGICAL to receive indicator
                       whether the file was a directory. can be
                       NULL.
   Returns
   \Returns the size of the file. or -1 if the file did not
	exist.                                                         */
FILESYS_PROC  uint32_t FILESYS_API  GetFileTimeAndSize ( CTEXTSTR name
													, LPFILETIME lpCreationTime
													,  LPFILETIME lpLastAccessTime
													,  LPFILETIME lpLastWriteTime
													, int *IsDirectory
													);
FILESYS_PROC void FILESYS_API ConvertFileIntToFileTime( uint64_t int_filetime, FILETIME *filetime );
FILESYS_PROC uint64_t FILESYS_API ConvertFileTimeToInt( const FILETIME *filetime );
#endif
// can use 0 as filegroup default - single 'current working directory'
#ifndef NEED_OLDNAMES
#define _NO_OLDNAMES
#endif
//#ifdef UNDER_CE
# ifndef O_RDONLY
#define O_RDONLY       0x0000
#define O_WRONLY       0x0001
#define O_RDWR         0x0002
#define O_APPEND       0x0008
#define O_CREAT        0x0100
#define O_TRUNC        0x0200
#define O_EXCL         0x0400
#endif
#ifndef __ANDROID__
#  ifndef S_IRUSR
#    define S_IRUSR 1
#    define S_IWUSR 2
#  endif
#endif
//# endif
#ifndef __LINUX__
// legacy 3.1 support.  Please use a FILE* instead.
FILESYS_PROC  HANDLE FILESYS_API  sack_open ( INDEX group, CTEXTSTR filename, int opts, ... );
FILESYS_PROC  LOGICAL FILESYS_API  sack_set_eof ( HANDLE file_handle );
FILESYS_PROC  long  FILESYS_API   sack_tell( INDEX file_handle );
FILESYS_PROC  HANDLE FILESYS_API  sack_openfile ( INDEX group, CTEXTSTR filename, OFSTRUCT *of, int flags );
FILESYS_PROC  HANDLE FILESYS_API  sack_creat ( INDEX group, CTEXTSTR file, int opts, ... );
FILESYS_PROC  int FILESYS_API  sack_close ( HANDLE file_handle );
FILESYS_PROC  int FILESYS_API  sack_lseek ( HANDLE file_handle, int pos, int whence );
FILESYS_PROC  int FILESYS_API  sack_read ( HANDLE file_handle, POINTER buffer, int size );
FILESYS_PROC  int FILESYS_API  sack_write ( HANDLE file_handle, CPOINTER buffer, int size );
#endif
FILESYS_PROC  INDEX FILESYS_API  sack_iopen ( INDEX group, CTEXTSTR filename, int opts, ... );
FILESYS_PROC  INDEX FILESYS_API  sack_iopenfile ( INDEX group, CTEXTSTR filename, int opts, int flags );
FILESYS_PROC  INDEX FILESYS_API  sack_icreat ( INDEX group, CTEXTSTR file, int opts, ... );
FILESYS_PROC  LOGICAL FILESYS_API  sack_iset_eof ( INDEX file_handle );
FILESYS_PROC  int FILESYS_API  sack_iclose ( INDEX file_handle );
FILESYS_PROC  int FILESYS_API  sack_ilseek ( INDEX file_handle, size_t pos, int whence );
FILESYS_PROC  int FILESYS_API  sack_iread ( INDEX file_handle, POINTER buffer, int size );
FILESYS_PROC  int FILESYS_API  sack_iwrite ( INDEX file_handle, CPOINTER buffer, int size );
/*
	Enable per-thread mounts.
	once you do this, you will have to provide the thread with some mounts.
*/
FILESYS_PROC void FILESYS_API sack_filesys_enable_thread_mounts( void );
/* internal (c library) file system is registered as prority 1000.... lower priorities are checked first for things like
  ScanFiles(), fopen( ..., "r" ), ... exists(), */
FILESYS_PROC struct file_system_mounted_interface * FILESYS_API sack_mount_filesystem( const char *name, struct file_system_interface *, int priority, uintptr_t psvInstance, LOGICAL writable );
/*
  Mount filesystem again, using an existing mount as a reference.
  name is not required (NULL)
  priority, if 0, will use the priority of the existing mount.
  writeable will apply for writes through this mount.  If the previous mount
  is writable and writable != 0, the new mount can be written, if either
  is 0, this mount will not be writable.  (cannnot remount-write)
*/
FILESYS_PROC struct file_system_mounted_interface* FILESYS_API sack_remount_filesystem( const char* name, struct file_system_mounted_interface* oldMount, int priority, LOGICAL writable );
/*
  Remove a mount from chain of mounts.
*/
FILESYS_PROC void FILESYS_API sack_unmount_filesystem( struct file_system_mounted_interface *mount );
/*
   get a mounted filesystem by name.
*/
FILESYS_PROC struct file_system_mounted_interface * FILESYS_API sack_get_mounted_filesystem( const char *name );
/*
   returrn inteface used on the mounted filesystem.
*/
FILESYS_PROC struct file_system_interface * FILESYS_API sack_get_mounted_filesystem_interface( struct file_system_mounted_interface * );
/*
   Some file system interfaces might use this(?), This is probably already deprecated.
*/
FILESYS_PROC uintptr_t FILESYS_API sack_get_mounted_filesystem_instance( struct file_system_mounted_interface *mount );
/* sometimes you want scanfiles to only scan external files...
  so this is how to get that mount */
FILESYS_PROC struct file_system_mounted_interface * FILESYS_API sack_get_default_mount( void );
/* specify a mounted system to open... multiple volumes of the same type need a different handle */
FILESYS_PROC  FILE* FILESYS_API  sack_fopenEx( INDEX group, CTEXTSTR filename, CTEXTSTR opts, struct file_system_mounted_interface *fsi );
/* if mode is read, all mounted file systems are attempted... */
FILESYS_PROC  FILE* FILESYS_API  sack_fopen ( INDEX group, CTEXTSTR filename, CTEXTSTR opts );
/* specify a mounted system to open... multiple volumes of the same type need a different handle */
FILESYS_PROC  FILE* FILESYS_API  sack_fsopenEx ( INDEX group, CTEXTSTR filename, CTEXTSTR opts, int share_mode, struct file_system_mounted_interface *fsi );
/* if mode is read, all mounted file systems are attempted...
   if mode is write/create only the first writable file system is used...
*/
FILESYS_PROC  FILE* FILESYS_API  sack_fsopen ( INDEX group, CTEXTSTR filename, CTEXTSTR opts, int share_mode );
FILESYS_PROC  struct file_system_interface * FILESYS_API sack_get_filesystem_interface( CTEXTSTR name );
FILESYS_PROC  void FILESYS_API sack_set_default_filesystem_interface( struct file_system_interface *fsi );
/*
 register a name for a file system interface object.
 This interface provides all the callbacks used to access file and directory objects
 */
FILESYS_PROC  void FILESYS_API sack_register_filesystem_interface( CTEXTSTR name, struct file_system_interface *fsi );
FILESYS_PROC  int FILESYS_API  sack_fclose ( FILE *file_file );
FILESYS_PROC  size_t FILESYS_API  sack_fseekEx ( FILE *file_file, size_t pos, int whence, struct file_system_mounted_interface *mount );
FILESYS_PROC  size_t FILESYS_API  sack_fseek ( FILE *file_file, size_t pos, int whence );
FILESYS_PROC  size_t FILESYS_API  sack_ftell ( FILE *file_file );
FILESYS_PROC  size_t FILESYS_API  sack_fsize ( FILE *file_file );
FILESYS_PROC  LOGICAL FILESYS_API  sack_existsEx ( const char * filename, struct file_system_mounted_interface *mount );
FILESYS_PROC  LOGICAL FILESYS_API  sack_exists ( const char *file_file );
// tests if the text passed is a directory or path to a file... for a specific mount.
FILESYS_PROC  LOGICAL FILESYS_API  sack_isPathEx ( const char *filename, struct file_system_mounted_interface *fsi );
// tests if the text passed is a directory or path to a file... for all mounts
FILESYS_PROC  LOGICAL FILESYS_API  sack_isPath( const char * filename );
FILESYS_PROC  size_t FILESYS_API  sack_fread ( POINTER buffer, size_t size, int count,FILE *file_file );
FILESYS_PROC  size_t FILESYS_API  sack_fwrite ( CPOINTER buffer, size_t size, int count,FILE *file_file );
FILESYS_PROC  TEXTSTR FILESYS_API  sack_fgets ( TEXTSTR  buffer, size_t size,FILE *file_file );
FILESYS_PROC  int FILESYS_API  sack_fflush ( FILE *file );
FILESYS_PROC  int FILESYS_API  sack_ftruncate ( FILE *file );
FILESYS_PROC int FILESYS_API sack_vfprintf( FILE *file_handle, const char *format, va_list args );
FILESYS_PROC int FILESYS_API sack_fprintf( FILE *file, const char *format, ... );
FILESYS_PROC int FILESYS_API sack_fputs( const char *format, FILE *file );
FILESYS_PROC  int FILESYS_API  sack_unlinkEx ( INDEX group, CTEXTSTR filename, struct file_system_mounted_interface *mount );
FILESYS_PROC  int FILESYS_API  sack_unlink ( INDEX group, CTEXTSTR filename );
FILESYS_PROC  int FILESYS_API  sack_rmdirEx( INDEX group, CTEXTSTR filename, struct file_system_mounted_interface* mount );
FILESYS_PROC  int FILESYS_API  sack_rmdir( INDEX group, CTEXTSTR filename );
FILESYS_PROC  int FILESYS_API  sack_mkdirEx( INDEX group, CTEXTSTR filename, struct file_system_mounted_interface* mount );
FILESYS_PROC  int FILESYS_API  sack_chdirEx( INDEX group, CTEXTSTR filename, struct file_system_mounted_interface* mount );
FILESYS_PROC  int FILESYS_API  sack_mkdir( INDEX group, CTEXTSTR filename );
FILESYS_PROC  int FILESYS_API  sack_renameEx ( CTEXTSTR file_source, CTEXTSTR new_name, struct file_system_mounted_interface *mount );
FILESYS_PROC  int FILESYS_API  sack_rename ( CTEXTSTR file_source, CTEXTSTR new_name );
FILESYS_PROC  void FILESYS_API sack_set_common_data_application( CTEXTSTR name );
FILESYS_PROC  void FILESYS_API sack_set_common_data_producer( CTEXTSTR name );
FILESYS_PROC  uintptr_t FILESYS_API  sack_ioctl( FILE *file, uintptr_t opCode, ... );
FILESYS_PROC  uintptr_t FILESYS_API  sack_fs_ioctl( struct file_system_mounted_interface *mount, uintptr_t opCode, ... );
FILESYS_PROC int FILESYS_API sack_flock( FILE* file );
FILESYS_PROC int FILESYS_API sack_funlock( FILE* file );
/*
  change permissions so everyone can read and write the file.
  result is < 0 and errno is set to ENOENT if there is no handler entry for the mount found.
*/
FILESYS_PROC int FILESYS_API make_public( CTEXTSTR filename );
/*
  change permissions so everyone can read and write the file; on a given mount.
  many mounts do not support this yet.
  result is < 0 and errno is set to ENOENT if there is no handler entry for the mount specified.
*/
FILESYS_PROC int FILESYS_API make_public_mount( CTEXTSTR filename, struct file_system_mounted_interface*mount );
#ifndef NO_FILEOP_ALIAS
#  ifndef NO_OPEN_MACRO
# define open(a,...) sack_iopen(0,a,##__VA_ARGS__)
# define set_eof(a)  sack_iset_eof(a)
#  endif
#ifdef WIN32
#if !defined( SACK_BAG_EXPORTS ) && !defined( BAG_EXTERNALS ) && !defined( FILESYSTEM_LIBRARY_SOURCE )
# define _lopen(a,...) sack_open(0,a,##__VA_ARGS__)
# define tell(a)      sack_tell(a)
# define lseek(a,b,c) sack_ilseek(a,b,c)
# define _llseek(a,b,c) sack_lseek(a,b,c)
# define HFILE HANDLE
# undef HFILE_ERROR
# define HFILE_ERROR INVALID_HANDLE_VALUE
# define creat(a,...)  sack_icreat( 0,a,##__VA_ARGS__ )
# define close(a)  sack_iclose(a)
# define OpenFile(a,b,c) sack_openfile(0,a,b,c)
# define _lclose(a)  sack_close(a)
# define read(a,b,c) sack_iread(a,b,c)
# define write(a,b,c) sack_iwrite(a,b,c)
# define _lread(a,b,c) sack_read(a,b,c)
# define _lwrite(a,b,c) sack_write(a,b,c)
# define _lcreat(a,b) sack_creat(0,a,b)
# define remove(a)   sack_unlink(0,a)
# define unlink(a)   sack_unlink(0,a)
# define rmdir(a)   sack_rmdir(0,a)
# define mkdir(a)   sack_mkdir(0,a)
#endif
#endif
 //NO_FILEOP_ALIAS
#endif
#ifdef __LINUX__
#define SYSPATHCHAR "/"
#else
#define SYSPATHCHAR "\\"
#endif
FILESYS_NAMESPACE_END
#ifdef __cplusplus
using namespace sack::filesys;
#endif
#endif
/*
 * Create: James Buckeyne
 *
 * Purpose: Provide a general structure to register names of
 *   routines and data structures which may be consulted
 *   for runtime linking.  Aliases and other features make this
 *   a useful library for tracking interface registration...
 *
 *  The namespace may be enumerated.
 */
#ifndef PROCEDURE_REGISTRY_LIBRARY_DEFINED
#define PROCEDURE_REGISTRY_LIBRARY_DEFINED
/* Deadstart interface. Deadstart is like bootstrap, and handles
   code that runs before main(). See <link deadstart>            */
#ifndef DEADSTART_DEFINED
#define DEADSTART_DEFINED
#ifdef WIN32
//#include <stdhdrs.h>
#endif
 // leach, assuming this will be compiled with this part at least.
#define pastejunk_(a,b) a##b
#define pastejunk(a,b) pastejunk_(a,b)
#ifdef __cplusplus
#  define USE_SACK_DEADSTART_NAMESPACE using namespace sack::app::deadstart;
#  define SACK_DEADSTART_NAMESPACE  SACK_NAMESPACE namespace app { namespace deadstart {
#  define SACK_DEADSTART_NAMESPACE_END  } } SACK_NAMESPACE_END
namespace sack{
	namespace app{
/* Application namespace. */
/* These are compiler-platform abstractions to provide a method
   of initialization that allows for creation of threads, and
   transparent (easy to use) method of scheduling routines for
   initialization.
   Example
   This schedules a routine to run at startup. Fill in the
   routine with the code you want, and it will run at
   DEFAULT_PRELOAD_PRIORITY which is the number 69.
   <code lang="c++">
   PRELOAD( MyCustomInit )
   {
       // do something here (do anything here,
       // without limitations that are imposed by DllMain/LibMain.
   }
   </code>
   If you wanted a routine which was guaranteed to run before
   MyCustomInit you might use PRIORITY_PRELOAD whcih allows you
   to specify a priority.
   <code lang="c++">
   PRIORITY_PRELOAD( MyOtherInit, DEFAULT_PRELOAD_PRIORITY-10 )
   {
      // this will run before other things.
   }
   </code>
   Priorities are listed in deadstart.h and exit_priorities.h. The
   priorities are treated backwards, so low number startup
   priorities go first, and higher number shutdown priorities go
   first.
   Remarks
   In some compilers and compile modes this is also fairly easy
   to do. A lot of compilers do not offer priority, and are
   impossible to maintain an order in. Some compilers only
   provide startup priority for C++ mode. This system works as
   \long as there is a way to run a single function at some
   point before main() and after C runtime initializes.
   In Windows, you might think you have this ability with
   DllMain, but there are severe limitations that you would have
   to get around; primary is the inability to create a thread,
   well, you can create it, but it will remain suspended until
   you leave DllMains and all DllMains finish. There is also no
   way to consistantly provide initialization order, like memory
   needs to be initialized before anything else.
                                                                   */
		namespace deadstart {
		}
	}
 //SACK_NAMESPACE_END
}
#else
#define USE_SACK_DEADSTART_NAMESPACE
#define SACK_DEADSTART_NAMESPACE
#define SACK_DEADSTART_NAMESPACE_END
#endif
#ifdef TYPELIB_SOURCE
#define DEADSTART_SOURCE
#endif
#ifdef __cplusplus
namespace sack{
	namespace app{
		namespace deadstart {
//SACK_DEADSTART_NAMESPACE
#endif
/* A macro to specify the call type of schedule routines. This
   can be changed in most projects without affect, it comes into
   play if plugins built by different compilers are used,
   __cdecl is most standard.                                     */
#define DEADSTART_CALLTYPE CPROC
#  if defined( _TYPELIBRARY_SOURCE_STEAL )
#    define DEADSTART_PROC extern
#  elif defined( _TYPELIBRARY_SOURCE )
#    define DEADSTART_PROC EXPORT_METHOD
#  else
/* A definition for how to declare these functions. if the
   source itself is comipling these are _export, otherwise
   external things linking here are _import.               */
#    define DEADSTART_PROC IMPORT_METHOD
#  endif
     // 28 (thread ID for critical sections used to allocate memory)
#define TIMER_MODULE_PRELOAD_PRIORITY  (CONFIG_SCRIPT_PRELOAD_PRIORITY-3)
     // 30 specify where to load external resources from... like the option database
#define VIRTUAL_FILESYSTEM_PRELOAD_PRIORITY (CONFIG_SCRIPT_PRELOAD_PRIORITY-1)
   /* this is just a global space initializer (shared, named
      region, allows static link plugins to share information)
      Allocates its shared memory global region, so if this library
      is built statically and referenced in multiple plugins
      ConfigScript can share the same symbol tables. This also
		provides sharing between C++ and C.                           */
         // 31
#define CONFIG_SCRIPT_PRELOAD_PRIORITY    (SQL_PRELOAD_PRIORITY-3)
			// this is just a global space initializer (shared, named region, allows static link plugins to share information)
         // 34
#define SQL_PRELOAD_PRIORITY    (SYSLOG_PRELOAD_PRIORITY-1)
/* Level at which logging is initialized. Nothing under this
   should be doing logging, if it does, the behavior is not as
   well defined.                                               */
#define SYSLOG_PRELOAD_PRIORITY 35
   // global_init_preload_priority-1 is used by sharemem.. memory needs init before it can register itself
#define GLOBAL_INIT_PRELOAD_PRIORITY 37
 // OS A[bstraction] L[ayer] O[n] T[op] - system lib
#define OSALOT_PRELOAD_PRIORITY (CONFIG_SCRIPT_PRELOAD_PRIORITY-1)
/* Level which names initializes. Names is the process
   registration code. It has a common shared global registered.
   <link sack::app::registry, procreg; aka names.c>             */
#define NAMESPACE_PRELOAD_PRIORITY 39
/* image_preload MUST be after Namespce preload (anything that
   uses RegisterAndCreateGlobal) should init this before vidlib
   (which needs image?)                                         */
#define IMAGE_PRELOAD_PRIORITY  45
/* Level at which the video render library performs its
   initialization; RegisterClass() level code.          */
#define VIDLIB_PRELOAD_PRIORITY 46
/* Initialization level where PSI registers its builtin
   controls.                                            */
#define PSI_PRELOAD_PRIORITY    47
// need to open the queues and threads before the service server can begin...
#define MESSAGE_CLIENT_PRELOAD_PRIORITY 65
/* Level which message core service initializes. During startup
   message services can register themselves also; but not before
   this priority level.                                          */
#define MESSAGE_SERVICE_PRELOAD_PRIORITY 66
/* Routines are scheduled at this priority when the PRELOAD
   function is used.                                        */
#define DEFAULT_PRELOAD_PRIORITY (DEADSTART_PRELOAD_PRIORITY-1)
/* Not sure where this is referenced, this the core routine
   itself is scheduled with this symbol to the compiler if
   appropriate.                                             */
#define DEADSTART_PRELOAD_PRIORITY 70
#define PRIORITY_UNLOAD(proc,priority) PRIORITY_ATEXIT( proc##_unload, priority )
/* Used by PRELOAD and PRIORITY_PRELOAD macros to register a
   startup routine at a specific priority. Lower number
   priorities are scheduled to run before higher number
   priorities*backwards from ATEXIT priorities*. Using this
   scheduling mechanisms, routines which create threads under
   windows are guaranteed to run before main, and are guaranteed
   able to create threads. (They are outside of the loader lock)
   Parameters
   function :  pointer to a function to call at startup.
   name :      text name of the function
   priority :  priority at which to call the function.
   unused :    this is an unused parameter. The macros fill it
               with &amp;ThisRegisteringRoutine, so that the
               routine itself is referenced by code, and helps
               the compile not optimize out this code. The
               functions which perform the registration are prone
               to be optimized because it's hard for the compiler
               to identify that they are refernced by other names
               indirectly.
   file\ :     usually DBG_PASS of the code doing this
               registration.
   line :      usually DBG_PASS of the code doing this
               registration.                                      */
DEADSTART_PROC  void DEADSTART_CALLTYPE  RegisterPriorityStartupProc( void(CPROC*)(void), CTEXTSTR,int,void* unused DBG_PASS);
/* Used by ATEXIT and PRIORITY_ATEXIT macros to register a
   shutdown routine at a specific priority. Higher number
   priorities are scheduled to run before lower number
   priorities. *backwards from PRELOAD priorities* This
   registers functions which are run while the program exits if
   it is at all able to run when exiting. calling exit() or
   BAG_Exit() will invoke these.
   Parameters
   function :  pointer to a function to call at shutdown.
   name :      text name of the function
   priority :  priority at which to call the function.
   unused :    this is an unused parameter. The macros fill it
               with &amp;ThisRegisteringRoutine, so that the
               routine itself is referenced by code, and helps
               the compile not optimize out this code. The
               functions which perform the registration are prone
               to be optimized because it's hard for the compiler
               to identify that they are refernced by other names
               indirectly.
   file\ :     usually DBG_PASS of the code doing this
               registration.
   line :      usually DBG_PASS of the code doing this
               registration.                                      */
DEADSTART_PROC  void DEADSTART_CALLTYPE  RegisterPriorityShutdownProc( void(CPROC*)(void), CTEXTSTR,int,void* unused DBG_PASS);
/* This routine is used internally when LoadFunction is called.
   After MarkDeadstartComplete is called, any call to a
   RegisterPriorityStartupProc will call the startup routine
   immediately instead of waiting. This function disables the
   auto-running of this function, and instead enques the startup
   to the list of startups. When completed, at some later point,
   call ResumeDeadstart() to dispatched all scheduled routines,
   and release the suspend; however, if initial deastart was not
   dispatched, then ResumeDeadstart does not do the invoke, it
   only releases the suspend.                                    */
DEADSTART_PROC  void DEADSTART_CALLTYPE  SuspendDeadstart ( void );
/* Resumes a suspended deadstart. If root deadstart is
   completed, then ResumeDeadstart will call InvokeDeadstarts
   after resuming deadstart.                                  */
DEADSTART_PROC  void DEADSTART_CALLTYPE  ResumeDeadstart ( void );
/* Not usually used by user code, but this invokes all the
   routines which have been scheduled to run for startup. If
   your compiler doesn't have a method of handling deadstart
   code, this can be manually called. It can also be called if
   you loaded a library yourself without using the LoadFunction
   interface, to invoke startups scheduled in the loaded
   library.                                                     */
DEADSTART_PROC  void DEADSTART_CALLTYPE  InvokeDeadstart (void);
/* This just calls the list of shutdown procedures. This should
   not be used usually from user code, since internally this is
   handled by catching atexit() or with a static destructor.    */
DEADSTART_PROC  void DEADSTART_CALLTYPE  InvokeExits (void);
/* This is typically called after the first InvokeDeadstarts
   completes. The code that runs this is usually a routine just
   before main(). So once code in main begins to run, all prior
   initialization has been performed.                           */
DEADSTART_PROC  void DEADSTART_CALLTYPE  MarkRootDeadstartComplete ( void );
/* \returns whether InvokeDeadstarts has been called. */
DEADSTART_PROC  LOGICAL DEADSTART_CALLTYPE  IsRootDeadstartStarted ( void );
/* \returns whether MarkRootDeadstartComplete has been called. */
DEADSTART_PROC  LOGICAL DEADSTART_CALLTYPE  IsRootDeadstartComplete ( void );
/*
   Setup flags to ignore control C Events on windows.  use 1 << (ControlType) or'd together to set ignore.
   Use 0 to clear ignore.
*/
DEADSTART_PROC void DEADSTART_CALLTYPE IgnoreBreakHandler( int ignore );
#if defined( __LINUX__ )
// call this after a fork().  Otherwise, it will falsely invoke shutdown when it exits.
DEADSTART_PROC  void DEADSTART_CALLTYPE  DispelDeadstart ( void );
#endif
#ifdef DOC_O_MAT
// call this after a fork().  Otherwise, it will falsely invoke shutdown when it exits.
DEADSTART_PROC  void DEADSTART_CALLTYPE  DispelDeadstart ( void );
#endif
#ifdef __cplusplus
/* Defines some code to run at program inialization time. Allows
   specification of a priority. Lower priorities run first. (default
   is 69).
   Example
   <code>
   PRIORITY_PRELOAD( MyOtherInit, 153 )
   {
      // run some code probably after most all other initializtion is done.
   }
   </code>
   See Also
   <link sack::app::deadstart, deadstart Namespace>                         */
#define PRIORITY_PRELOAD(name,priority) static void CPROC name(void);	 namespace { static class pastejunk(schedule_,name) {        public:pastejunk(schedule_,name)() {	    RegisterPriorityStartupProc( name,TOSTR(name),priority,(void*)this DBG_SRC);	  }	  } pastejunk(do_schedule_,name);   }	  static void name(void)
/* This is used once in deadstart_prog.c which is used to invoke
   startups when the program finishes loading.                   */
#define MAGIC_PRIORITY_PRELOAD(name,priority) static void CPROC name(void);	 namespace { static class pastejunk(schedule_,name) {	     public:pastejunk(schedule_,name)() {	  name();	    }	  } pastejunk(do_schedul_,name);   }	  static void name(void)
/*
  Internal macro used to trigger InvokeExits() which runs scheduled exits.
                                                                     */
#define ATEXIT_INVOKE_INTERNAL(name) static void CPROC name(void);    static class pastejunk(schedule_,name) {        public:pastejunk(~schedule_,name)() {			    name();	  }	  } pastejunk(do_schedule_,name);	     static void name(void)
/* Defines some code to run at program shutdown time. Allows
   specification of a priority. Higher priorities are run first.
   Example
   <code>
   PRIORITY_ATEXIT( MyOtherShutdown, 153 )
   {
      // run some code probably before most library code dissolves.
      // last to load, first to unload.
   }
   </code>
   See Also
   <link sack::app::deadstart, deadstart Namespace>                 */
	/*name(); / * call on destructor of static object.*/
#define PRIORITY_ATEXIT(name,priority) static void CPROC name(void);    static class pastejunk(shutdown_,name) {	   public:pastejunk(shutdown_,name)() {       RegisterPriorityShutdownProc( name,TOSTR(name),priority,(void*)this DBG_SRC );	   }	  } do_shutdown_##name;	     void name(void)
/* This is the most basic way to define some code to run
   initialization before main.
   Example
   <code lang="c++">
   PRELOAD( MyInitCode )
   {
      // some code here
   }
   </code>
   See Also
   <link sack::app::deadstart, deadstart Namespace>      */
#define PRELOAD(name) PRIORITY_PRELOAD(name,DEFAULT_PRELOAD_PRIORITY)
/* Basic way to register a routine to run when the program exits
   gracefully.
   Example
   \    <code>
   ATEXIT( MyExitRoutine )
   {
       // this will be run sometime during program shutdown
   }
   </code>                                                       */
#define ATEXIT(name)      PRIORITY_ATEXIT(name,ATEXIT_PRIORITY_DEFAULT)
/* This is the core atexit. It dispatches all other exit
   routines. This is defined for internal use only...    */
#define ROOT_ATEXIT(name) ATEXIT_INVOKE_INTERNAL(name)
//------------------------------------------------------------------------------------
// Win32 Watcom
//------------------------------------------------------------------------------------
#elif defined( __WATCOMC__ )
#pragma off (check_stack)
/* code taken from openwatcom/bld/watcom/h/rtinit.h */
typedef unsigned char   __type_rtp;
typedef unsigned short  __type_pad;
typedef void(*__type_rtn ) ( void );
#ifdef __cplusplus
#pragma pack(1)
#else
#pragma pack(1)
#endif
 // structure placed in XI/YI segment
struct rt_init
{
#define DEADSTART_RT_LIST_START 0xFF
 // - near=0/far=1 routine indication
    __type_rtp  rtn_type;
                          //   also used when walking table to flag
                          //   completed entries
 // - priority (0-highest 255-lowest)
    __type_rtp  priority;
      // - routine
    __type_rtn  rtn;
};
#pragma pack()
/* end code taken from openwatcom/bld/watcom/h/rtinit.h */
//------------------------------------------------------------------------------------
// watcom
//------------------------------------------------------------------------------------
//void RegisterStartupProc( void (*proc)(void) );
#define PRIORITY_PRELOAD(name,priority) static void pastejunk(schedule_,name)(void); static void CPROC name(void);	 static struct rt_init __based(__segname("XI")) pastejunk(name,_ctor_label)={0,(DEADSTART_PRELOAD_PRIORITY-1),pastejunk(schedule_,name)};	 static void pastejunk(schedule_,name)(void) {	                 RegisterPriorityStartupProc( name,TOSTR(name),priority,&pastejunk(name,_ctor_label) DBG_SRC );	}	                                       void name(void)
#define ATEXIT_PRIORITY(name,priority) static void pastejunk(schedule_exit_,name)(void); static void CPROC name(void);	 static struct rt_init __based(__segname("XI")) pastejunk(name,_dtor_label)={0,69,pastejunk(schedule_exit_,name)};	 static void pastejunk(schedule_exit_,name)(void) {	                                              RegisterPriorityShutdownProc( name,TOSTR(name),priority,&name##_dtor_label DBG_SRC );	}	                                       void name(void)
// syslog runs preload at priority 65
// message service runs preload priority 66
// deadstart itself tries to run at priority 70 (after all others have registered)
#define PRELOAD(name) PRIORITY_PRELOAD(name,DEFAULT_PRELOAD_PRIORITY)
// this is a special case macro used in client.c
// perhaps all PRIORITY_ATEXIT routines should use this
// this enables cleaning up things that require threads to be
// active under windows... (message disconnect)
// however this routine is only triggered in windows by calling
// BAG_Exit(nn) which is aliased to replace exit(n) automatically
#define PRIORITY_ATEXIT(name,priority) ATEXIT_PRIORITY( name,priority)
/*
static void name(void); static void name##_x_(void);	static struct rt_init __based(__segname("YI")) name##_dtor_label={0,priority,name##_x_};	 static void name##_x_(void) { char myname[256];myname[0]=*(CTEXTSTR)&name##_dtor_label;GetModuleFileName(NULL,myname,sizeof(myname));name(); }	 static void name(void)
  */
#define ROOT_ATEXIT(name) ATEXIT_PRIORITY(name,ATEXIT_PRIORITY_ROOT)
#define ATEXIT(name)      PRIORITY_ATEXIT(name,ATEXIT_PRIORITY_DEFAULT)
// if priority_atexit is used with priority 0 - the proc is scheduled into
// atexit, and exit() is then invoked.
//#define PRIORITY_ATEXIT(name,priority) ATEXIT_PRIORITY(name,priority )
//------------------------------------------------------------------------------------
// Linux
//------------------------------------------------------------------------------------
#elif defined( __GNUC__ )
/* code taken from openwatcom/bld/watcom/h/rtinit.h */
typedef unsigned char   __type_rtp;
typedef void(*__type_rtn ) ( void );
 // structure placed in XI/YI segment
struct rt_init
{
#define DEADSTART_RT_LIST_START 0xFF
 // - near=0/far=1 routine indication
    __type_rtp  rtn_type;
                          //   also used when walking table to flag
                          //   completed entries
 // has this been scheduled? (0 if no)
    __type_rtp  scheduled;
 // - priority (0-highest 255-lowest)
    __type_rtp  priority;
#if defined( __64__ ) ||defined( __arm__ )||defined( __GNUC__ )
#define INIT_PADDING ,{0}
 // need this otherwise it's 23 bytes and that'll be bad.
	 char padding[1];
#else
#define INIT_PADDING
#endif
 // 32 bits in 64 bits....
	 int line;
// this ends up being nicely aligned for 64 bit platforms
// specially with the packed attributes
      // - routine (rtn)
	 __type_rtn  routine;
#if defined( _DEBUG ) || defined( _DEBUG_INFO )
	 CTEXTSTR file;
#endif
	 CTEXTSTR funcname;
	 struct rt_init *junk;
#if defined( _DEBUG ) || defined( _DEBUG_INFO )
#if defined( __GNUC__ ) && defined( __64__)
    // this provides padding - inter-object segments are packed
    // to 32 bytes...
	 struct rt_init *junk2[3];
#endif
#endif
} __attribute__((packed));
#if defined( _DEBUG ) || defined( _DEBUG_INFO )
#  if defined( __GNUC__ ) && defined( __64__)
#    define JUNKINIT(name) ,&pastejunk(name,_ctor_label), {0,0}
#  else
#    define JUNKINIT(name) ,&pastejunk(name,_ctor_label)
#  endif
#else
#  define JUNKINIT(name) ,&pastejunk(name,_ctor_label)
#endif
#define RTINIT_STATIC static
#define ATEXIT_PRIORITY PRIORITY_ATEXIT
#if defined( _DEBUG ) || defined( _DEBUG_INFO )
#  define PASS_FILENAME ,WIDE__FILE__
#else
#  define PASS_FILENAME
#endif
#ifdef __MAC__
#  define DEADSTART_SECTION "TEXT,deadstart_list"
#else
#  define DEADSTART_SECTION "deadstart_list"
#endif
#ifdef __MANUAL_PRELOAD__
#define PRIORITY_PRELOAD(name,pr) static void name(void);	 RTINIT_STATIC struct rt_init pastejunk(name,_ctor_label)		__attribute__((section(DEADSTART_SECTION))) __attribute__((used))	 =	 {0,0,pr INIT_PADDING, __LINE__, name PASS_FILENAME	, TOSTR(name) JUNKINIT(name)} ;	 void name(void);	 void pastejunk(registerStartup,name)(void) __attribute__((constructor));	 void pastejunk(registerStartup,name)(void) {	 RegisterPriorityStartupProc(name,TOSTR(name),pr,NULL DBG_SRC); }	 void name(void)
#else
#if defined( _WIN32 ) || defined( __GNUC__ )
#  define HIDDEN_VISIBILITY
#else
#  define HIDDEN_VISIBILITY  __attribute__((visibility("hidden")))
#endif
#define PRIORITY_PRELOAD(name,pr) static void name(void);	         RTINIT_STATIC struct rt_init pastejunk(name,_ctor_label)	         __attribute__((section(DEADSTART_SECTION))) __attribute__((used))	  ={0,0,pr INIT_PADDING	                                           ,__LINE__,name	                                                 PASS_FILENAME	                                                 ,TOSTR(name)	                                                   JUNKINIT(name)};	                                               static void name(void) __attribute__((used));	 void name(void)
#endif
typedef void(*atexit_priority_proc)(void (*)(void),CTEXTSTR,int DBG_PASS);
#define PRIORITY_ATEXIT(name,priority) static void name(void);           static void pastejunk(atexit,name)(void) __attribute__((constructor));   void pastejunk(atexit,name)(void)                                        {	                                                                        RegisterPriorityShutdownProc(name,TOSTR(name),priority,NULL DBG_SRC); }                                                                        void name(void)
#define ATEXIT(name) PRIORITY_ATEXIT( name,ATEXIT_PRIORITY_DEFAULT )
#define ROOT_ATEXIT(name) static void name(void) __attribute__((destructor));    static void name(void)
#define PRELOAD(name) PRIORITY_PRELOAD(name,DEFAULT_PRELOAD_PRIORITY)
//------------------------------------------------------------------------------------
// CYGWIN (-mno-cygwin)
//------------------------------------------------------------------------------------
#elif defined( __CYGWIN__ )
/* code taken from openwatcom/bld/watcom/h/rtinit.h */
typedef unsigned char   __type_rtp;
typedef void(*__type_rtn ) ( void );
 // structure placed in XI/YI segment
struct rt_init
{
#ifdef __cplusplus
	//rt_init( int _rtn_type ) { rt_init::rtn_type = _rtn_type; }
	/*rt_init( int _priority, CTEXTSTR name, __type_rtn rtn, CTEXTSTR _file, int _line )
	{
		rtn_type = 0;
		scheduled = 0;
		priority = priority;
		file = _file;
		line = _line;
      routine = rtn;
		}
      */
#endif
#define DEADSTART_RT_LIST_START 0xFF
 // - near=0/far=1 routine indication
    __type_rtp  rtn_type;
                          //   also used when walking table to flag
                          //   completed entries
 // has this been scheduled? (0 if no)
    __type_rtp  scheduled;
 // - priority (0-highest 255-lowest)
    __type_rtp  priority;
#if defined( __GNUC__ ) || defined( __64__ ) || defined( __arm__ ) || defined( __CYGWIN__ )
#define INIT_PADDING ,{0}
 // need this otherwise it's 23 bytes and that'll be bad.
	 char padding[1];
#else
#define INIT_PADDING
#endif
 // 32 bits in 64 bits....
	 int line;
// this ends up being nicely aligned for 64 bit platforms
// specially with the packed attributes
      // - routine (rtn)
	 __type_rtn  routine;
	 CTEXTSTR file;
	 CTEXTSTR funcname;
	 struct rt_init *junk;
#if defined( __GNUC__ ) && defined( __64__ )
    // this provides padding - inter-object segments are packed
    // to 32 bytes...
	 struct rt_init *junk2[3];
#endif
} __attribute__((packed));
#define JUNKINIT(name) ,&pastejunk(name,_ctor_label)
#ifdef __cplusplus
#define RTINIT_STATIC
#else
#define RTINIT_STATIC static
#endif
typedef void(*atexit_priority_proc)(void (*)(void),CTEXTSTR,int DBG_PASS);
#define ATEXIT_PRIORITY(name,priority) static void name(void); static void atexit##name(void) __attribute__((constructor));	  void atexit_failed##name(void(*f)(void),int i,CTEXTSTR s1,CTEXTSTR s2,int n) { lprintf( "Failed to load atexit_priority registerar from core program." );} void atexit##name(void)                                                  {	                                                                        static char myname[256];HMODULE mod;if(myname[0])return;myname[0]='a';GetModuleFileName( NULL, myname, sizeof( myname ) );	mod=LoadLibrary(myname);if(mod){   typedef void (*x)(void);void(*rsp)( x,const CTEXTSTR,int,const CTEXTSTR,int);	 if((rsp=((void(*)(void(*)(void),const CTEXTSTR,int,const CTEXTSTR,int))(GetProcAddress( mod, "RegisterPriorityShutdownProc")))))	 {rsp( name,TOSTR(name),priority DBG_SRC);}	 else atexit_failed##name(name,priority,TOSTR(name) DBG_SRC);	        }     FreeLibrary( mod);	 }             void name( void)
#ifdef _DEBUG
#  define PASS_FILENAME ,WIDE__FILE__
#else
#  define PASS_FILENAME
#endif
#define PRIORITY_PRELOAD(name,pr) static void name(void);	 RTINIT_STATIC struct pastejunk(rt_init name,_ctor_label)	   __attribute__((section("deadstart_list")))	 ={0,0,pr INIT_PADDING	     ,__LINE__,name	          PASS_FILENAME	        ,TOSTR(name)	        JUNKINIT(name)};	 static void name(void)
#define ATEXIT(name)      ATEXIT_PRIORITY(name,ATEXIT_PRIORITY_DEFAULT)
#define PRIORITY_ATEXIT ATEXIT_PRIORITY
#define ROOT_ATEXIT(name) static void name(void) __attribute__((destructor));    static void name(void)
#define PRELOAD(name) PRIORITY_PRELOAD(name,DEFAULT_PRELOAD_PRIORITY)
//------------------------------------------------------------------------------------
// WIN32 MSVC
//------------------------------------------------------------------------------------
#elif defined( _MSC_VER ) && defined( _WIN32 )
//#define PRELOAD(name) __declspec(allocate(".CRT$XCAA")) void CPROC name(void)
//#pragma section(".CRT$XCA",long,read)
//#pragma section(".CRT$XCZ",long,read)
// put init in both C startup and C++ startup list...
// looks like only one or the other is invoked, not both?
/////// also the variables to be put into these segments
#if defined( __cplusplus_cli )
#define LOG_ERROR(n) System::Console::WriteLine( gcnew System::String(n) + gcnew System::String( myname) ) )
#else
#define LOG_ERROR(n) SystemLog( n )
// since we get linked first, then the runtime is added, we have to link against the last indicator of section,
// so we get put between start to end.
#define _STARTSEG_ ".CRT$XIM"
#define _STARTSEG2_ ".CRT$XCY"
#define _ENDSEG_ ".CRT$XTM"
//#pragma data_seg(".CRT$XIA")
#pragma data_seg(".CRT$XIM")
#pragma section(".CRT$XIM",long,read)
#pragma data_seg(".CRT$XCY")
#pragma section(".CRT$XCY",long,read)
//#pragma data_seg(".CRT$XIZ")
//#pragma data_seg(".CRT$YCZ")
#pragma data_seg(".CRT$XTM")
#pragma section(".CRT$XTM",long,read)
#pragma data_seg()
	                                       /*static __declspec(allocate(_STARTSEG_)) void (CPROC*pointer_##name)(void) = pastejunk(schedule_,name);*/
#define PRIORITY_PRELOAD(name,priority) static void CPROC name(void);    static int CPROC pastejunk(schedule_,name)(void);	   __declspec(allocate(_STARTSEG_)) int (CPROC*pastejunk(TARGET_LABEL,pastejunk( pastejunk(x_,name),__LINE__)))(void) = pastejunk(schedule_,name);	 int CPROC pastejunk(schedule_,name)(void) {	                 RegisterPriorityStartupProc( name,TOSTR(name),priority,pastejunk(TARGET_LABEL,pastejunk( pastejunk(x_,name),__LINE__)) DBG_SRC );	return 0;	 }	 static void CPROC name(void)
#define ROOT_ATEXIT(name) static void name(void);	 __declspec(allocate(_ENDSEG_)) static void (*f##name)(void)=name;    static void name(void)
#define ATEXIT(name) PRIORITY_ATEXIT(name,ATEXIT_PRIORITY_DEFAULT)
typedef void(*atexit_priority_proc)(void (*)(void),int,CTEXTSTR DBG_PASS);
#define PRIORITY_ATEXIT(name,priority) static void CPROC name(void);    static int schedule_atexit_##name(void);	   __declspec(allocate(_STARTSEG_)) void (CPROC*pastejunk(TARGET_LABEL,pastejunk( x_##name,__LINE__)))(void) = (void(CPROC*)(void))schedule_atexit_##name;	 static int schedule_atexit_##name(void) {	                 RegisterPriorityShutdownProc( name,TOSTR(name),priority,pastejunk(TARGET_LABEL,pastejunk( x_##name,__LINE__)) DBG_SRC );	return 0;	 }	                                       static void CPROC name(void)
#define ATEXIT_PRIORITY(name,priority) PRIORITY_ATEXIT(name,priority)
#endif
#ifdef __cplusplus_cli
#define InvokeDeadstart() do {	                                              TEXTCHAR myname[256];HMODULE mod;	 mod=LoadLibrary("sack_bag.dll");if(mod){           void(*rsp)(void);	 if((rsp=((void(*)(void))(GetProcAddress( mod, "RunDeadstart"))))){rsp();}else{lprintf( "Hey failed to get proc %d", GetLastError() );}	FreeLibrary( mod); }} while(0)
#else
#endif
#define PRELOAD(name) PRIORITY_PRELOAD(name,DEFAULT_PRELOAD_PRIORITY)
//extern uint32_t deadstart_complete;
//#define DEADSTART_LINK uint32_t *deadstart_link_couple = &deadstart_complete; // make sure we reference this symbol
//#pragma data_seg(".CRT$XCAA")
//extern void __cdecl __security_init_cookie(void);
//static _CRTALLOC(".CRT$XCAA") _PVFV init_cookie = __security_init_cookie;
//#pragma data_seg()
//------------------------------------------------------------------------------------
// UNDEFINED
//------------------------------------------------------------------------------------
#else
#error "there's nothing I can do to wrap PRELOAD() or ATEXIT()!"
/* This is the most basic way to define some startup code that
   runs at some point before the program starts. This code is
   declared as static, so the same preload initialization name
   can be used in multiple files.
   <link sack::app::deadstart, See Also.>                      */
#define PRELOAD(name)
#endif
/* Defines ATEXIT priorities so the library can tear itself down
   gracefully.                                                   */
// the higher the number the earlier it is run
#define ATEXIT_PRIORITY_SHAREMEM  1
#define ATEXIT_PRIORITY_THREAD_SEMS ATEXIT_PRIORITY_SYSLOG-1
#define ATEXIT_PRIORITY_SYSLOG    35
#define ATEXIT_PRIORITY_MSGCLIENT 85
#define ATEXIT_PRIORITY_DEFAULT   90
#define ATEXIT_PRIORITY_TIMERS   (ATEXIT_PRIORITY_DEFAULT+1)
// this is the first exit to be run.
// under linux it is __attribute__((destructor))
// under all it is registered during preload as atexit()
// only the runexits in deadstart should use ROOT_ATEXIT
#ifdef __WATCOMC__
#define ATEXIT_PRIORITY_ROOT 255
#else
#define ATEXIT_PRIORITY_ROOT 101
#endif
#ifdef __cplusplus
 //SACK_DEADSTART_NAMESPACE_END
} } }
#endif
USE_SACK_DEADSTART_NAMESPACE
#endif
#ifdef PROCREG_SOURCE
#define PROCREG_PROC(type,name) EXPORT_METHOD type CPROC name
#else
#define PROCREG_PROC(type,name) IMPORT_METHOD type CPROC name
#endif
#ifdef __cplusplus
#ifdef __cplusplus_cli
//using namespace System;
#endif
#   define _INTERFACE_NAMESPACE namespace Interface {
#   define _INTERFACE_NAMESPACE_END }
#define PROCREG_NAMESPACE namespace sack { namespace app { namespace registry {
#define _PROCREG_NAMESPACE namespace registry {
#define _APP_NAMESPACE namespace app {
#define PROCREG_NAMESPACE_END }}}
//extern "C"  {
#else
#   define _INTERFACE_NAMESPACE
#   define _INTERFACE_NAMESPACE_END
#define _PROCREG_NAMESPACE
#define _APP_NAMESPACE
#define PROCREG_NAMESPACE
#define PROCREG_NAMESPACE_END
#endif
#ifdef __cplusplus
namespace sack {
#endif
/* Deadstart is support which differs per compiler, but allows
   applications access a C++ feature - static classes with
   constructors that initialize at loadtime, but, have the
   feature that you can create threads. Deadstart code is run
   after the DLL load lock under windows that prevents creation
   of threads; however, deadstart is run before main. Deadstart
   routines can have a priority. Certain features require others
   to be present always. This allows explicit control of
   priority unlink using classes with static constructors, which
   requires ordering of objects to provide linking order. Also
   provides a similar registration mechanism for atexit, but
   extending with priority. Deadstop registrations are done
   sometime during normal C atexit() handling, but may be
   triggered first by calling BAG_Exit.
   Registry offers support to register functions, and data under
   a hierarchy of names. Names are kept in a string cache, which
   applications can take benefit of. Strings will exist only a
   single time. This table could be saved, and a look-aside
   table for language translation purposes. Registry is the
   support that the latest PSI relies on for registering event
   callbacks for controls. The registry was always used, but,
   the access to it was encapsulated by DoRegisterControl
   registering the appropriate methods.                          */
	_APP_NAMESPACE
   /* Contains methods dealing with registering routines and values
      in memory. Provisions are available to save the configuration
      state, but the best that can be offered here would be a
      translation tool for text strings. The namespace is savable,
      but most of the content of the registration space are short
      term pointers. Namespace containing registry namespace.
      old notes - very discongruant probably should delete them.
      Process name registry
      it's a tree of names.
      there are paths, and entries
      paths are represented as class_name
      PCLASSROOT is also a suitable class name
      PCLASSROOT is defined as a valid CTEXTSTR.
      there is (apparently) a name that is not valid as a path name
      that is TREE
      guess.
      POINTER in these two are equal to (void(*)(void)) but -
      that's rarely the most useful thing... so
      name class is a tree of keys... /\<...\>
      psi/control/## might contain procs Init Destroy Move
      RegAlias( "psi/control/3", "psi/control/button"
      ); psi/control/button and psi/control/3 might reference the
      same routines
      psi/frame Init Destroy Move memlib Alloc Free
      network/tcp
      I guess name class trees are somewhat shallow at the moment
      not going beyond 1-3 layers
      names may eventually be registered and reference out of body
      services, even out of box...
      the values passed as returntype and parms/args need not be
      real genuine types, but do need to be consistant between the
      registrant and the requestor... this provides for full name
      dressing, return type and paramter type may both cause
      overridden functions to occur...                              */
_PROCREG_NAMESPACE
#ifndef REGISTRY_STRUCTURE_DEFINED
	// make these a CTEXTSTR to be compatible with name_class...
#ifdef __cplusplus
	// because of name mangling and stronger type casting
	// it becomes difficult to pass a tree_def_tag * as a CTEXTSTR classname
	// as valid as this is.
	typedef struct tree_def_tag const * PCLASSROOT;
#else
	typedef CTEXTSTR PCLASSROOT;
#endif
	typedef void (CPROC *PROCEDURE)(void);
#ifdef __cplusplus_cli
	typedef void (__stdcall *STDPROCEDURE)(array<System::Object^>^);
#endif
#else
	typedef struct tree_def_tag const * PCLASSROOT;
	typedef void (CPROC *PROCEDURE)(void);
#ifdef __cplusplus_cli
	typedef void (__stdcall *STDPROCEDURE)(array<System::Object^>^);
#endif
#endif
/* CheckClassRoot reads for a path of names, but does not create
   it if it does not exist.                                      */
PROCREG_PROC( PCLASSROOT, CheckClassRoot )( CTEXTSTR class_name );
/* \Returns a PCLASSROOT of a specified path. The path may be
   either a PCLASSROOT or a text string indicating the path. the
   Ex versions allow passing a base PCLASSROOT path and an
   additional subpath to get. GetClassRoot will always create
   the path if it did not exist before, and will always result
   with a root.
   Remarks
   a CTEXTSTR (plain text string, probably wide character if
   compiled unicode) and a PCLASSROOT are always
   interchangeable. Though you may need a forced type cast, I
   have defined both CTEXTSTR and PCLASSROOT function overloads
   for c++ compiled code, and C isn't so unkind about the
   conversion. I think problem might lie that CTEXTSTR has a
   const qualifier and PCLASSROOT doesn't (but should).
   Example
   <code lang="c++">
   PCLASSROOT root = GetClassRoot( "psi/resource" );
   // returns the root of all resource names.
   </code>
   <code>
   PCLASSROOT root2 = GetClassRootEx( "psi/resource", "buttons" );
   </code>                                                         */
PROCREG_PROC( PCLASSROOT, GetClassRoot )( CTEXTSTR class_name );
/* <combine sack::app::registry::GetClassRoot@CTEXTSTR>
   \ \                                                  */
PROCREG_PROC( PCLASSROOT, GetClassRootEx )( PCLASSROOT root, CTEXTSTR name_class );
#ifdef __cplusplus
/* <combine sack::app::registry::GetClassRoot@CTEXTSTR>
   \ \                                                  */
PROCREG_PROC( PCLASSROOT, GetClassRoot )( PCLASSROOT class_name );
/* <combine sack::app::registry::GetClassRoot@CTEXTSTR>
   \ \                                                  */
PROCREG_PROC( PCLASSROOT, GetClassRootEx )( PCLASSROOT root, PCLASSROOT name_class );
#endif
/* Fills a string with the path name to the specified node */
PROCREG_PROC( int, GetClassPath )( TEXTSTR out, size_t len, PCLASSROOT root );
/* Sets the interface configuration file to be used by the
	registry. This is the file that will be used to save the
	configuration of the interface, and will be loaded at startup.
	If this is not set, then the default interface configuration
	file will be used.
	Parameters
	filename :  The name of the file to use for the interface
	         configuration.  the file is duplicated, so the value
			 may be deallocated after this.
	Example
	<code lang="c++">
	char *filename = strdup( "my_interface.cfg" );
	SetInterfaceConfigFile( filename );
	free( filename );
	</code>                                                                 */
PROCREG_PROC( void, SetInterfaceConfigFile )( TEXTCHAR *filename );
/* Sets the interface configuration file to be used by the
	registry. This is the file that will be used to save the
	configuration of the interface, and will be loaded at startup.
	If this is not set, then the default interface configuration
	file will be used.
	Parameters
	filename :  The name of the file to use for the interface
	         configuration.  The pointer passed is retained,
			 and is not duplicated.
	Example
	<code lang="c++">
	  SetStaticInterfaceConfigFile( "my_interface.cfg" );
	</code>                                                                 */
PROCREG_PROC( void, SetStaticInterfaceConfigFile )( CTEXTSTR filename );
/* Get[First/Next]RegisteredName( "classname", &amp;data );
   these operations are not threadsafe and multiple thread
   accesses will cause mis-stepping
   These functions as passed the address of a POINTER. this
   POINTER is for the use of the browse routines and should is
   meaningless to he calling application.
   Parameters
   root :       The root to search from
   classname :  A sub\-path from the root to search from
   data :       the address of a pointer that keeps track of
                information about the search. (opaque to user)
   Example
   Usage:
   <code lang="c++">
   CTEXTSTR result;
   POINTER data = NULL;
   for( result = GetFirstRegisteredName( "some/class/path", &amp;data );
        \result;
        \result = GetNextRegisteredName( &amp;data ) )
   {
        // result is a string name of the current node.
        // can use that name and GetRegistered____ (function/int/value)
        if( NameHasBranches( &amp;data ) ) // for consitancy in syntax
        {
            // consider recursing through tree, name becomes a valid classname for GetFirstRegisteredName()
        }
   }
   </code>                                                                                                  */
PROCREG_PROC( CTEXTSTR, GetFirstRegisteredNameEx )( PCLASSROOT root, CTEXTSTR classname, PCLASSROOT *data );
#ifdef __cplusplus
/* <combine sack::app::registry::GetFirstRegisteredNameEx@PCLASSROOT@CTEXTSTR@PCLASSROOT *>
   \ \                                                                                      */
	PROCREG_PROC( CTEXTSTR, GetFirstRegisteredName )( PCLASSROOT classname, PCLASSROOT *data );
#endif
/* <combine sack::app::registry::GetFirstRegisteredNameEx@PCLASSROOT@CTEXTSTR@PCLASSROOT *>
   \ \                                                                                      */
PROCREG_PROC( CTEXTSTR, GetFirstRegisteredName )( CTEXTSTR classname, PCLASSROOT *data );
/* Steps to the next registered name being browsed. Is passed
   only the pointer to data. See GetFirstRegisteredName for
   usage.
   See Also
   <link sack::app::registry::GetFirstRegisteredNameEx@PCLASSROOT@CTEXTSTR@PCLASSROOT *, sack::app::registry::GetFirstRegisteredNameEx Function> */
PROCREG_PROC( CTEXTSTR, GetNextRegisteredName )( PCLASSROOT *data );
/* When using GetFirstRegisteredName and GetNextRegisteredName
   to browse through names, this function is able to get the
   current PCLASSROOT of the current node, usually you end up
   with just the content of that registered name.
   \result with the current node ( useful for pulling registered
   subvalues like description, or file and line )
                                                                 */
PROCREG_PROC( PCLASSROOT, GetCurrentRegisteredTree )( PCLASSROOT *data );
#ifdef __cplusplus
//PROCREG_PROC( CTEXTSTR, GetFirstRegisteredName )( CTEXTSTR classname, POINTER *data );
//PROCREG_PROC( CTEXTSTR, GetNextRegisteredName )( POINTER *data );
#endif
// while doing a scan for registered procedures, allow applications to check for branches
//PROCREG_PROC( int, NameHasBranches )( POINTER *data );
PROCREG_PROC( int, NameHasBranches )( PCLASSROOT *data );
// while doing a scan for registered procedures, allow applications to ignore aliases...
PROCREG_PROC( int, NameIsAlias )( PCLASSROOT *data );
/*
 * RegisterProcedureExx(
 *
 */
 // root name or PCLASSROOT of base path
PROCREG_PROC( int, RegisterProcedureExx )( PCLASSROOT root
 // an additional path on root
													  , CTEXTSTR name_class
 // the name of the value entry saved in the tree
													  , CTEXTSTR public_name
 // the text return type of this function - may be checked to validate during GetRegisteredProcedure
													  , CTEXTSTR returntype
 // name of the library this symbol is in - may be checked to validate during GetRegisteredProcedure
													  , CTEXTSTR library
 // actual C function name in library - may be checked to validate during GetRegisteredProcedure
													  , CTEXTSTR name
 // preferably the raw argument string of types and no variable references "([type][,type]...)"
													  , CTEXTSTR args
 // file and line of the calling application.  May be no parameter in release mode.
													  DBG_PASS
													  );
/*
 * RegisterProcedureEx( root       // root path
 *                    , name_class // additional name
 *                    , nice_name  // nice name
 *                    , return type not in quotes  'void'
 *                    , function_name in quotes '"Function"'
 *                    , args not in quotes '(int,char,float,UserType*)'
 */
#define RegisterProcedureEx(root,nc,n,rtype,proc,args)  RegisterProcedureExx( (root),(nc),(n),#rtype,TARGETNAME,(proc), #args DBG_SRC)
/*
 * RegisterProcedure( name_class // additional name
 *                    , nice_name  // nice name
 *                    , return type not in quotes  'void'
 *                    , function_name in quotes '"Function"'
 *                    , args not in quotes '(int,char,float,UserType*)'
 */
#define RegisterProcedure(nc,n,rtype,proc,args)  RegisterProcedureExx( NULL, (nc),(n),#rtype,TARGETNAME,(proc), #args DBG_SRC)
/*
 * Branches on the tree may be aliased together to form a single branch
 *
 */
				// RegisterClassAlias( "psi/control/button", "psi/control/3" );
				// then the same set of values can be referenced both ways with
				// really only a single modified value.
/* parameters to RegisterClassAliasEx are the original name, and the new alias name for the origianl branch*/
PROCREG_PROC( PCLASSROOT, RegisterClassAliasEx )( PCLASSROOT root, CTEXTSTR original, CTEXTSTR alias );
/* <combine sack::app::registry::RegisterClassAliasEx@PCLASSROOT@CTEXTSTR@CTEXTSTR>
   \ \                                                                              */
PROCREG_PROC( PCLASSROOT, RegisterClassAlias )( CTEXTSTR original, CTEXTSTR newalias );
// root, return, public, args, address
PROCREG_PROC( PROCEDURE, ReadRegisteredProcedureEx )( PCLASSROOT root
                                                    , CTEXTSTR returntype
																	 , CTEXTSTR parms
																  );
#define ReadRegisteredProcedure( root,rt,a) ((rt(CPROC*)a)ReadRegisteredProcedureEx(root,#rt,#a))
/* Gets a function that has been registered. */
PROCREG_PROC( PROCEDURE, GetRegisteredProcedureExxx )( PCLASSROOT root
																	 , PCLASSROOT name_class
                                                    , CTEXTSTR returntype
																	 , CTEXTSTR name
																	 , CTEXTSTR parms
																	 );
#define GetRegisteredProcedureExx(root,nc,rt,n,a) ((rt (CPROC*)a)GetRegisteredProcedureExxx(root,nc,#rt,n,#a))
#define GetRegisteredProcedure2(nc,rtype,name,args) (rtype (CPROC*)args)GetRegisteredProcedureEx((nc),#rtype, name, #args )
#define GetRegisteredProcedureNonCPROC(nc,rtype,name,args) (rtype (*)args)GetRegisteredProcedureEx((nc),#rtype, name, #args )
/* <combine sack::app::registry::GetRegisteredProcedureExxx@PCLASSROOT@PCLASSROOT@CTEXTSTR@CTEXTSTR@CTEXTSTR>
   \ \                                                                                                        */
PROCREG_PROC( PROCEDURE, GetRegisteredProcedureEx )( PCLASSROOT name_class
																	, CTEXTSTR returntype
																	, CTEXTSTR name
																	, CTEXTSTR parms
																	);
PROCREG_PROC( LOGICAL, RegisterFunctionExx )( PCLASSROOT root
													, PCLASSROOT name_class
													, CTEXTSTR public_name
													, CTEXTSTR returntype
													, PROCEDURE proc
													 , CTEXTSTR args
													 , CTEXTSTR library
													 , CTEXTSTR real_name
													  DBG_PASS
														  );
#ifdef __cplusplus
/* <combine sack::app::registry::GetRegisteredProcedureExxx@PCLASSROOT@PCLASSROOT@CTEXTSTR@CTEXTSTR@CTEXTSTR>
   \ \                                                                                                        */
PROCREG_PROC( PROCEDURE, GetRegisteredProcedureExxx )( CTEXTSTR root
																	 , CTEXTSTR name_class
                                                    , CTEXTSTR returntype
																	 , CTEXTSTR name
																	 , CTEXTSTR parms
																	 );
/* <combine sack::app::registry::GetRegisteredProcedureExxx@PCLASSROOT@PCLASSROOT@CTEXTSTR@CTEXTSTR@CTEXTSTR>
   \ \                                                                                                        */
PROCREG_PROC( PROCEDURE, GetRegisteredProcedureExxx )( CTEXTSTR root
																	 , PCLASSROOT name_class
                                                    , CTEXTSTR returntype
																	 , CTEXTSTR name
																	 , CTEXTSTR parms
																	 );
/* <combine sack::app::registry::GetRegisteredProcedureExxx@PCLASSROOT@PCLASSROOT@CTEXTSTR@CTEXTSTR@CTEXTSTR>
   \ \                                                                                                        */
PROCREG_PROC( PROCEDURE, GetRegisteredProcedureExxx )( PCLASSROOT root
																	 , CTEXTSTR name_class
                                                    , CTEXTSTR returntype
																	 , CTEXTSTR name
																	 , CTEXTSTR parms
																	 );
/* <combine sack::app::registry::GetRegisteredProcedureExxx@PCLASSROOT@PCLASSROOT@CTEXTSTR@CTEXTSTR@CTEXTSTR>
   \ \                                                                                                        */
PROCREG_PROC( PROCEDURE, GetRegisteredProcedureEx )( CTEXTSTR name_class
																	, CTEXTSTR returntype
																	, CTEXTSTR name
																	, CTEXTSTR parms
																	);
PROCREG_PROC( LOGICAL, RegisterFunctionExx )( CTEXTSTR root
													, CTEXTSTR name_class
													, CTEXTSTR public_name
													, CTEXTSTR returntype
                                       , PROCEDURE proc
													 , CTEXTSTR args
													 , CTEXTSTR library
													 , CTEXTSTR real_name
													  DBG_PASS
														  );
#endif
//#define RegisterFunctionExx( r,nc,p,rt,proc,ar ) RegisterFunctionExx( r,nc,p,rt,proc,ar,TARGETNAME,NULL DBG_SRC )
//#define RegisterFunctionEx(r,nc,pn,rt,proc,args,lib,rn) RegisterFunctionExx(r,nc,pn,rt,proc,args,lib,rn DBG_SRC)
#define RegisterFunctionEx( root,proc,rt,pn,a) RegisterFunctionExx( root,NULL,pn,rt,(PROCEDURE)(proc),a,NULL,NULL DBG_SRC )
#define RegisterFunction( nc,proc,rt,pn,a) RegisterFunctionExx( (PCLASSROOT)NULL,nc,pn,rt,(PROCEDURE)(proc),a,TARGETNAME,NULL DBG_SRC )
#define SimpleRegisterMethod(r,proc,rt,name,args) RegisterFunctionExx(r,NULL,name,rt,(PROCEDURE)proc,args,NULL,NULL DBG_SRC )
#define GetRegisteredProcedure(nc,rtype,name,args) (rtype (CPROC*)args)GetRegisteredProcedureEx((nc),#rtype, #name, #args )
PROCREG_PROC( int, RegisterIntValueEx )( PCLASSROOT root, CTEXTSTR name_class, CTEXTSTR name, uintptr_t value );
PROCREG_PROC( int, RegisterIntValue )( CTEXTSTR name_class, CTEXTSTR name, uintptr_t value );
PROCREG_PROC( int, RegisterValueExx )( PCLASSROOT root, CTEXTSTR name_class, CTEXTSTR name, int bIntVal, CTEXTSTR value );
PROCREG_PROC( int, RegisterValueEx )( CTEXTSTR name_class, CTEXTSTR name, int bIntVal, CTEXTSTR value );
PROCREG_PROC( int, RegisterValue )( CTEXTSTR name_class, CTEXTSTR name, CTEXTSTR value );
/* \ \
   Parameters
   root :        Root class to start searching from
   name_class :  An additional sub\-path to get the name from
   name :        the name within the path specified
   bIntVal :     a true/false whether to get the string or
                 integer value from the specified node.
   Returns
   A pointer to a string if bIntVal is not set. (NULL if there
   was no string).
   Otherwise will be an int shorter than or equal to the size of
   a pointer, which should be cast to an int if bIntVal is set,
   and there is a value registered there. Probably 0 if no
   value, so registered 0 value and no value is
   indistinguisable.                                             */
PROCREG_PROC( CTEXTSTR, GetRegisteredValueExx )( PCLASSROOT root, CTEXTSTR name_class, CTEXTSTR name, int bIntVal );
/* <combine sack::app::registry::GetRegisteredValueExx@PCLASSROOT@CTEXTSTR@CTEXTSTR@int>
   \ \                                                                                   */
PROCREG_PROC( CTEXTSTR, GetRegisteredValueEx )( CTEXTSTR name_class, CTEXTSTR name, int bIntVal );
/* <combine sack::app::registry::GetRegisteredValueExx@PCLASSROOT@CTEXTSTR@CTEXTSTR@int>
   \ \                                                                                   */
PROCREG_PROC( CTEXTSTR, GetRegisteredValue )( CTEXTSTR name_class, CTEXTSTR name );
#ifdef __cplusplus
/* <combine sack::app::registry::GetRegisteredValueExx@PCLASSROOT@CTEXTSTR@CTEXTSTR@int>
   \ \                                                                                   */
PROCREG_PROC( CTEXTSTR, GetRegisteredValueExx )( CTEXTSTR root, CTEXTSTR name_class, CTEXTSTR name, int bIntVal );
PROCREG_PROC( int, RegisterIntValueEx )( CTEXTSTR root, CTEXTSTR name_class, CTEXTSTR name, uintptr_t value );
#endif
/* This is like GetRegisteredValue, but takes the address of the
   type to return into instead of having to cast the final
   \result.
   if bIntValue, result should be passed as an (&amp;int)        */
PROCREG_PROC( int, GetRegisteredStaticValue )( PCLASSROOT root, CTEXTSTR name_class, CTEXTSTR name
															, CTEXTSTR *result
															, int bIntVal );
#define GetRegisteredStaticIntValue(r,nc,name,result) GetRegisteredStaticValue(r,nc,name,(CTEXTSTR*)result,TRUE )
/* <combine sack::app::registry::GetRegisteredValueExx@PCLASSROOT@CTEXTSTR@CTEXTSTR@int>
   \ \                                                                                   */
PROCREG_PROC( int, GetRegisteredIntValueEx )( PCLASSROOT root, CTEXTSTR name_class, CTEXTSTR name );
/* <combine sack::app::registry::GetRegisteredIntValueEx@PCLASSROOT@CTEXTSTR@CTEXTSTR>
   \ \                                                                                 */
PROCREG_PROC( int, GetRegisteredIntValue )( CTEXTSTR name_class, CTEXTSTR name );
#ifdef __cplusplus
/* <combine sack::app::registry::GetRegisteredIntValueEx@PCLASSROOT@CTEXTSTR@CTEXTSTR>
   \ \                                                                                 */
PROCREG_PROC( int, GetRegisteredIntValue )( PCLASSROOT name_class, CTEXTSTR name );
#endif
typedef void (CPROC*OpenCloseNotification)( POINTER, uintptr_t );
#define PUBLIC_DATA( public, struct, open, close )	    PRELOAD( Data_##open##_##close ) {	 RegisterDataType( "system/data/structs"	        , public, sizeof(struct)	    , (OpenCloseNotification)open, (OpenCloseNotification)close ); }
#define PUBLIC_DATA_EX( public, struct, open, update, close )	    PRELOAD( Data_##open##_##close ) {	 RegisterDataTypeEx( "system/data/structs"	        , public, sizeof(struct)	    , (OpenCloseNotification)open, (OpenCloseNotification)update, (OpenCloseNotification)close ); }
#define GET_PUBLIC_DATA( public, type, instname )    (type*)CreateRegisteredDataType( "system/data/structs", public, instname )
PROCREG_PROC( uintptr_t, RegisterDataType )( CTEXTSTR classname
												 , CTEXTSTR name
												 , uintptr_t size
												 , OpenCloseNotification open
												 , OpenCloseNotification close );
/* Registers a structure as creatable in shared memory by name.
   So a single name of the structure can be used to retrieve a
   pointer to one created.
   Example
   \ \
   <code lang="c++">
   POINTER p = CreateRegisteredDataType( "My types", "my_registered_type", "my instance" );
   // p will result to a region of type 'my_registered_type' called 'my_instance'
   // if it did not exist, it will be created, otherwise the one existing is returned.
   </code>
   Parameters
   root :          optional root name (ex version uses this)
   classname :     path to the type
   name :          name of the type to create an instance of
   instancename :  a name for the instance created.                                         */
PROCREG_PROC( uintptr_t, CreateRegisteredDataType)( CTEXTSTR classname
																 , CTEXTSTR name
																 , CTEXTSTR instancename );
PROCREG_PROC( uintptr_t, RegisterDataTypeEx )( PCLASSROOT root
													, CTEXTSTR classname
													, CTEXTSTR name
													, uintptr_t size
													, OpenCloseNotification Open
													, OpenCloseNotification Close );
/* <combine sack::app::registry::CreateRegisteredDataType@CTEXTSTR@CTEXTSTR@CTEXTSTR>
   \ \                                                                                */
PROCREG_PROC( uintptr_t, CreateRegisteredDataTypeEx)( PCLASSROOT root
																	, CTEXTSTR classname
																	, CTEXTSTR name
																	, CTEXTSTR instancename );
/* Outputs through syslog a tree dump of all names registered. */
PROCREG_PROC( void, DumpRegisteredNames )( void );
/* Dumps through syslog all names registered from the specified
   root point. (instead of dumping the whole tree)              */
PROCREG_PROC( void, DumpRegisteredNamesFrom )( PCLASSROOT root );
PROCREG_PROC( int, SaveTree )( void );
PROCREG_PROC( int, LoadTree )( void );
#define METHOD_PTR(type,name) type (CPROC *_##name)
#define DMETHOD_PTR(type,name) type (CPROC **_##name)
#define METHOD_ALIAS(i,name) ((i)->_##name)
#define PDMETHOD_ALIAS(i,name) (*(i)->_##name)
/* Releases an interface. When interfaces are registered, they
   register with a OnGetInterface and an OnDropInterface
   callback so that it may do additional work to cleanup from
   giving you a copy of the interface.
   Example
   <code lang="c++">
   POINTER p = GetInterface( "image" );
   DropInterface( p );
   </code>                                                     */
PROCREG_PROC( void, DropInterface )( CTEXTSTR pServiceName, POINTER interface_x );
PROCREG_PROC( POINTER, GetInterface_v4 )( CTEXTSTR pServiceName, LOGICAL ReadConfig, int quietFail DBG_PASS );
#define GetInterfaceV4( a, b )  GetInterface_v4( a, FALSE, b DBG_SRC )
/* \Returns the pointer to a registered interface. This is
   typically a structure that contains pointer to functions. Takes
   a text string to an interface. Interfaces are registered at a
   known location in the registry tree.                            */
PROCREG_PROC( POINTER, GetInterfaceDbg )( CTEXTSTR pServiceName DBG_PASS );
#define GetInterface(n) GetInterfaceDbg( n DBG_SRC )
#define GetRegisteredInterface(name) GetInterface(name)
PROCREG_PROC( LOGICAL, RegisterInterfaceEx )( CTEXTSTR name, POINTER(CPROC*load)(void), void(CPROC*unload)(POINTER) DBG_PASS );
//PROCREG_PROC( LOGICAL, RegisterInterface )(CTEXTSTR name, POINTER( CPROC*load )(void), void(CPROC*unload)(POINTER));
#define RegisterInterface(n,l,u) RegisterInterfaceEx( n,l,u DBG_SRC )
// unregister a function, should be smart and do full return type
// and parameters..... but for now this only references name, this indicates
// that this has not been properly(fully) extended, and should be layered
// in such a way as to allow this function work in it's minimal form.
PROCREG_PROC( int, ReleaseRegisteredFunctionEx )( PCLASSROOT root
													, CTEXTSTR name_class
													, CTEXTSTR public_name
													  );
#define ReleaseRegisteredFunction(nc,pn) ReleaseRegisteredFunctionEx(NULL,nc,pn)
/* This is a macro used to paste two symbols together. */
#define paste_(a,b) a##b
#define paste(a,b) paste_(a,b)
#define preproc_symbol(a)  a
#ifdef __cplusplus
#define EXTRA_PRELOAD_SYMBOL _
#else
#define EXTRA_PRELOAD_SYMBOL
#endif
#define DefineRegistryMethod2_i(task,name,classtype,methodname,desc,returntype,argtypes,line)	   CPROC paste(name,line)argtypes;	       PRIORITY_PRELOAD( paste(paste(paste(paste(Register,name),Method),preproc_symbol(EXTRA_PRELOAD_SYMBOL)),line), SQL_PRELOAD_PRIORITY ) {	  SimpleRegisterMethod( task "/" classtype, paste(name,line)	  , #returntype, methodname, #argtypes );    RegisterValue( task "/" classtype "/" methodname, "Description", desc ); }	                                                                          static returntype CPROC paste(name,line)
#define DefineRegistryMethod2(task,name,classtype,methodname,desc,returntype,argtypes,line)	   DefineRegistryMethod2_i(task,name,classtype,methodname,desc,returntype,argtypes,line)
/* Dekware uses this macro.
     passes preload priority override.
	 so it can register new internal commands before initial macros are run.
*/
#define DefineRegistryMethod2P_i(priority,task,name,classtype,methodname,desc,returntype,argtypes,line)	   CPROC paste(name,line)argtypes;	       PRIORITY_PRELOAD( paste(paste(paste(paste(Register,name),Method),preproc_symbol(EXTRA_PRELOAD_SYMBOL)),line), priority ) {	  SimpleRegisterMethod( task "/" classtype, paste(name,line)	  , #returntype, methodname, #argtypes );    RegisterValue( task "/" classtype "/" methodname, "Description", desc ); }	                                                                          static returntype CPROC paste(name,line)
/* This macro indirection is to resolve inner macros like "" around text.  */
#define DefineRegistryMethod2P(priority,task,name,classtype,methodname,desc,returntype,argtypes,line)	   DefineRegistryMethod2P_i(priority,task,name,classtype,methodname,desc,returntype,argtypes,line)
/*
    This method is used by PSI/Intershell.
	no description
*/
#define DefineRegistryMethod_i(task,name,classtype,classbase,methodname,returntype,argtypes,line)	   CPROC paste(name,line)argtypes;	       PRELOAD( paste(paste(Register##name##Button,preproc_symbol(EXTRA_PRELOAD_SYMBOL)),line) ) {	  SimpleRegisterMethod( task "/" classtype "/" classbase, paste(name,line)	  , #returntype, methodname, #argtypes ); }	                                                                          static returntype CPROC paste(name,line)
#define DefineRegistryMethod(task,name,classtype,classbase,methodname,returntype,argtypes,line)	   DefineRegistryMethod_i(task,name,classtype,classbase,methodname,returntype,argtypes,line)
/*
#define _0_DefineRegistryMethod(task,name,classtype,classbase,methodname,returntype,argtypes,line)	   static returntype _1__DefineRegistryMethod(task,name,classtype,classbase,methodname,returntype,argtypes,line)
#define DefineRegistryMethod(task,name,classtype,classbase,methodname,returntype,argtypes)	  _1__DefineRegistryMethod(task,name,classtype,classbase,methodname,returntype,argtypes,__LINE__)
*/
// this macro is used for ___DefineRegistryMethodP. Because this is used with complex names
// an extra define wrapper of priority_preload must be used to fully resolve paramters.
/*
#define DefineRegistryMethodP(priority,task,name,classtype,classbase,methodname,returntype,argtypes,line)	   CPROC paste(name,line)argtypes;	       PRIOR_PRELOAD( paste(paset(Register##name##Button,preproc_symbol(EXTRA_PRELOAD_SYMBOL),line), priority ) {	  SimpleRegisterMethod( task "/" classtype "/" classbase, paste(name,line)	  , #returntype, methodname, #argtypes ); }	                                                                          static returntype CPROC paste(name,line)
*/
/* <combine sack::app::registry::SimpleRegisterMethod>
   General form to build a registered procedure. Used by simple
   macros to create PRELOAD'ed registered functions. This flavor
   requires the user to provide 'static' and a return type that
   matches the return type specified in the macro. This makes
   usage most C-like, and convenient to know what the return
   value of a function should be (if any).
   Parameters
   priority :    The preload priority to load at.
   task :        process level name registry. This would be
                 "Intershell" or "psi" or some other base prefix.
                 The prefix can contain a path longer than 1
                 level.
   name :        This is the function name to build. (Can be used
                 for link debugging sometimes)
   classtype :   class of the name being registered
   methodname :  name of the routine to register
   returntype :  the literal type of the return type of this
                 function (void, int, PStruct* )
   argtypes :    Argument signature of the routine in parenthesis
   line :        this is usually filled with __LINE__ so that the
                 same function name (name) will be different in
                 different files (even in the same file)
   Remarks
   This registers a routine at the specified preload priority.
   Registers under [task]/[classname]/methodname. The name of
   the registered routine from a C perspective is [name][line]. This
   function is not called directly, but will only be referenced
   from the registered name.
   Example
   See <link sack::app::registry::GetFirstRegisteredNameEx@PCLASSROOT@CTEXTSTR@PCLASSROOT *, GetFirstRegisteredNameEx> */
/*
#define _1__DefineRegistryMethodP(priority,task,name,classtype,classbase,methodname,returntype,argtypes,line)	   _2___DefineRegistryMethodP(priority,task,name,classtype,classbase,methodname,returntype,argtypes,line)
#define _0_DefineRegistryMethodP(priority,task,name,classtype,classbase,methodname,returntype,argtypes,line)	   _1__DefineRegistryMethodP(priority,task,name,classtype,classbase,methodname,returntype,argtypes,line)
#define DefineRegistryMethodP(priority,task,name,classtype,classbase,methodname,returntype,argtypes)	  _0_DefineRegistryMethodP(priority,task,name,classtype,classbase,methodname,returntype,argtypes,__LINE__)
*/
#define DefineRegistrySubMethod_i(task,name,classtype,classbase,methodname,subname,returntype,argtypes,line)	   CPROC paste(name,line)argtypes;	       PRELOAD( paste(paste(Register##name##Button,preproc_symbol(EXTRA_PRELOAD_SYMBOL)),line) ) {	  SimpleRegisterMethod( task "/" classtype "/" classbase "/" methodname, paste(name,line)	  , #returntype, subname, #argtypes ); }	                                                                          static returntype CPROC paste(name,line)
#define DefineRegistrySubMethod(task,name,classtype,classbase,methodname,subname,returntype,argtypes)	  DefineRegistrySubMethod_i(task,name,classtype,classbase,methodname,subname,returntype,argtypes,__LINE__)
/* attempts to use dynamic linking functions to resolve passed
   global name if that fails, then a type is registered for this
   global, and an instance created, so that that instance may be
   reloaded again, otherwise the data in the main application is
   used... actually we should deprecate the dynamic loading
   part, and just register the type.
   SimpleRegisterAndCreateGlobal Simply registers the type as a
   global variable type. Allows creation of the global space
   later.
   Parameters
   name :         name of the pointer to global type to create.<p />text
                  string to register this created global as.
   ppGlobal :     address of the pointer to global memory.
   global_size :  size of the global area to create
   Example
   <code lang="c++">
   typedef struct {
      int data;
   } my_global;
   my_global *global;
   PRELOAD( Init )
   {
       SimpleRegisterAndCreateGlobal( global );
   }
   </code>                                                               */
PROCREG_PROC( void, RegisterAndCreateGlobal )( POINTER *ppGlobal, uintptr_t global_size, CTEXTSTR name );
/* <combine sack::app::registry::RegisterAndCreateGlobal@POINTER *@uintptr_t@CTEXTSTR>
   \ \                                                                                   */
#define SimpleRegisterAndCreateGlobal( name )	 RegisterAndCreateGlobal( (POINTER*)&name, sizeof( *name ), #name )
/* Init routine is called, otherwise a 0 filled space is
   returned. Init routine is passed the pointer to the global
   and the size of the global block the global data block is
   zero initialized.
   Parameters
   ppGlobal :     Address of the pointer to the global region
   global_size :  size of the global region to create
   name :         name of the global region to register (so
                  future users get back the same data area)
   Init :         function to call to initialize the region when
                  created. (doesn't have to be a global. Could be
                  used to implement types that have class
                  constructors \- or not, since there's only one
                  instance of a global \- this is more for
                  singletons).
   Example
   <code>
   typedef struct {
      int data;
   } my_global;
   my_global *global;
   </code>
   <code lang="c++">
   void __cdecl InitRegion( POINTER region, uintptr_t region_size )
   {
       // do something to initialize 'region'
   }
   PRELOAD( InitGlobal )
   {
       SimpleRegisterAndCreateGlobalWithInit( global, InitRegion );
   }
   </code>                                                          */
PROCREG_PROC( void, RegisterAndCreateGlobalWithInit )( POINTER *ppGlobal, uintptr_t global_size, CTEXTSTR name, void (CPROC*Init)(POINTER,uintptr_t) );
/* <combine sack::app::registry::RegisterAndCreateGlobalWithInit@POINTER *@uintptr_t@CTEXTSTR@void __cdecl*InitPOINTER\,uintptr_t>
   \ \                                                                                                                              */
#define SimpleRegisterAndCreateGlobalWithInit( name,init )	 RegisterAndCreateGlobalWithInit( (POINTER*)&name, sizeof( *name ), #name, init )
/* a tree dump will result with dictionary names that may translate automatically. */
/* This has been exported as a courtesy for StrDup.
 * this routine MAY result with a translated string.
 * this routine MAY result with the same pointer.
 * this routine MAY need to be improved if MANY more strdups are replaced
 * Add a binary tree search index when large.
 * Add a transaltion tree index at the same time.
 */
PROCREG_PROC( CTEXTSTR, SaveNameConcatN )( CTEXTSTR name1, ... );
// no space stripping, saves literal text (case insensitive indexing; '/' and '\' are the same)
PROCREG_PROC( CTEXTSTR, SaveText )( CTEXTSTR text );
// no space stripping, saves literal text (case sensitive indexing; '/' and '\' are the same)
PROCREG_PROC( CTEXTSTR, SaveTextCS )( CTEXTSTR text );
PROCREG_NAMESPACE_END
#ifdef __cplusplus
	using namespace sack::app::registry;
#endif
#endif
/* Salty Random Generator is a random bitstream generator. It
   generates blobs
   of randomness, and provides an interface to get a number of
   bits from 1 to N of the random stream.                      */
#ifdef SALTY_RANDOM_GENERATOR_SOURCE
#define SRG_EXPORT EXPORT_METHOD
#else
/* Defines export method for SaltyRandomGenerator functions. */
#define SRG_EXPORT IMPORT_METHOD
#endif
//
// struct random_context *entropy = CreateEntropy( void (*getsalt)( uintptr_t, POINTER *salt, size_t *salt_size ), uintptr_t psv_user );
// uses sha1
SRG_EXPORT struct random_context *SRG_CreateEntropy( void (*getsalt)( uintptr_t, POINTER *salt, size_t *salt_size ), uintptr_t psv_user );
//
// struct random_context *entropy = CreateEntropy2( void (*getsalt)( uintptr_t, POINTER *salt, size_t *salt_size ), uintptr_t psv_user );
//  uses a larger salt generator... (sha2-512)
SRG_EXPORT struct random_context *SRG_CreateEntropy2( void (*getsalt)( uintptr_t, POINTER *salt, size_t *salt_size ), uintptr_t psv_user );
//
// struct random_context *entropy = CreateEntropy2( void (*getsalt)( uintptr_t, POINTER *salt, size_t *salt_size ), uintptr_t psv_user );
//  uses a sha2-256
SRG_EXPORT struct random_context *SRG_CreateEntropy2_256( void (*getsalt)( uintptr_t, POINTER *salt, size_t *salt_size ), uintptr_t psv_user );
//
// struct random_context *entropy = CreateEntropy3( void (*getsalt)( uintptr_t, POINTER *salt, size_t *salt_size ), uintptr_t psv_user );
//  uses a sha3-512 (keccak)
SRG_EXPORT struct random_context *SRG_CreateEntropy3( void (*getsalt)( uintptr_t, POINTER *salt, size_t *salt_size ), uintptr_t psv_user );
//
// struct random_context *entropy = CreateEntropy4( void (*getsalt)( uintptr_t, POINTER *salt, size_t *salt_size ), uintptr_t psv_user );
//  uses a K12-32768
SRG_EXPORT struct random_context *SRG_CreateEntropy4( void( *getsalt )(uintptr_t, POINTER *salt, size_t *salt_size), uintptr_t psv_user );
// Destroya  context.  Pass the address of your 'struct random_context *entropy;   ... SRG_DestroyEntropy( &entropy );
SRG_EXPORT void SRG_DestroyEntropy( struct random_context **ppEntropy );
// get a large number of bits of entropy from the random_context
// buffer needs to be an integral number of 32 bit elements....
SRG_EXPORT void SRG_GetEntropyBuffer( struct random_context *ctx, uint32_t *buffer, uint32_t bits );
// get a number of bits of entropy from the
// if get_signed is not 0, the result will be sign extended if the last bit is set
//  (coded on little endian; tests for if ( result & ( 1 << bits - 1 ) ) then sign extend
SRG_EXPORT int32_t SRG_GetEntropy( struct random_context *ctx, int bits, int get_signed );
// get a single bit.
SRG_EXPORT uint32_t SRG_GetBit( struct random_context *ctx );
// opportunity to reset an entropy generator back to initial condition
// next call to getentropy will be the same as the first call after create.
SRG_EXPORT void SRG_ResetEntropy( struct random_context *ctx );
// After SRG_ResetEntropy(), this takes the existing entropy
// already in the random_context and seeds the entropy generator
// with this existing digest;  GetEntropy/GetEntropyBuffer do this
// internally; but for user control, this is separated from just
// ResetEntropy().
//   SRG_ResetEntropy(ctx);   // reset entropy generator to empty.
//   SRG_StreamEntropy(ctx);  // continue from last ending
//   SRG_FeedEntropy(ctx, /*buffer*/ ); // mix in some more entropy
//
SRG_EXPORT void SRG_StreamEntropy( struct random_context *ctx );
// Manually load some salt into the next enropy buffer to e retreived.
// sets up to add the next salt into the buffer.
SRG_EXPORT void SRG_FeedEntropy( struct random_context *ctx, const uint8_t *salt, size_t salt_size );
// Flush the current entropy feed to internal entropy feed
// and initialize with previous feed.
SRG_EXPORT void SRG_StepEntropy( struct random_context* ctx );
// reset the state of the random context entirely. (?)
SRG_EXPORT void SRG_Reset( struct random_context* ctx );
// restore the random contxt from the external holder specified
// {
//    POINTER save_context;
//    SRG_SaveState( ctx, &save_context );  // will allocate space for the context
//    SRG_RestoreState( ctx, save_context ); // context should previously be saved
// }
SRG_EXPORT void SRG_RestoreState( struct random_context *ctx, POINTER external_buffer_holder );
// save the random context in an external buffer holder.
// external buffer holder needs to be initialized to NULL.
// {
//    POINTER save_context = NULL;
//    SRG_SaveState( ctx, &save_context );
// }
SRG_EXPORT void SRG_SaveState( struct random_context *ctx, POINTER *external_buffer_holder, size_t *dataSize );
//
// Randeom Hash generators.  Returns a 256 bit hash in a base 64 string.
// internally seeded by clocks
// Are thread safe; current thread pool is 32 before having to wait
//
// return a unique ID using SHA2_512
SRG_EXPORT char * SRG_ID_Generator( void );
// return a unique ID using SHA2_256
SRG_EXPORT char *SRG_ID_Generator_256( void );
// return a unique ID using SHA3-keccak-512
SRG_EXPORT char *SRG_ID_Generator3( void );
// return a unique ID using K12-32768
SRG_EXPORT char *SRG_ID_Generator4( void );
// return a short unique ID using K12-32768
SRG_EXPORT char *SRG_ID_ShortGenerator4( void );
//------------------------------------------------------------------------
//   crypt_util.c extra simple routines - kinda like 'passwd'
//
// usage
/// { uint8_t* buf; size_t buflen; SRG_DecryptData( <resultfrom encrypt>, &buf, &buflen ); }
//  buffer result must be released by user
SRG_EXPORT void SRG_DecryptData( CTEXTSTR local_password, uint8_t* *buffer, size_t *chars );
SRG_EXPORT void SRG_DecryptRawData( CPOINTER binary, size_t length, uint8_t* *buffer, size_t *chars );
// text result must release by user
SRG_EXPORT TEXTSTR SRG_DecryptString( CTEXTSTR local_password );
// encrypt a block of binary data to another binary buffer
SRG_EXPORT void SRG_EncryptRawData( CPOINTER buffer, size_t buflen, uint8_t* *result_buf, size_t *result_size );
// text result must release by user
SRG_EXPORT TEXTCHAR * SRG_EncryptData( CPOINTER buffer, size_t buflen );
// text result must release by user
// calls EncrytpData with buffer and string length + 1 to include the null for decryption.
SRG_EXPORT TEXTCHAR * SRG_EncryptString( CTEXTSTR buffer );
// Simplified encyprtion wrapper around OpenSSL/LibreSSL EVP AES-256-CBC, uses key as IV also.
// result is length; address of pointer to cyphertext is filled in with an Allocated buffer.
// Limitation of 4G-byte encryption.
// automaically adds padding as required.
SRG_EXPORT int SRG_AES_decrypt( uint8_t *ciphertext, int ciphertext_len, uint8_t *key, uint8_t **plaintext );
// Simplified encyprtion wrapper around OpenSSL/LibreSSL EVP AES-256-CBC, uses key as IV also.
// result is length; address of pointer to cyphertext is filled in with an Allocated buffer.
// Limitation of 4G-byte encryption.
// automaically adds padding as required.
SRG_EXPORT size_t SRG_AES_encrypt( uint8_t *plaintext, size_t plaintext_len, uint8_t *key, uint8_t **ciphertext );
// xor-sub-wipe-sub encryption.
// encrypts objBuf of objBufLen using (keyBuf+tick)
// pointers refrenced passed to outBuf and outBufLen are filled in with the result
// Will automatically add 4 bytes and pad up to 8
SRG_EXPORT void SRG_XSWS_encryptData( uint8_t *objBuf, size_t objBufLen
	, uint64_t tick, const uint8_t *keyBuf, size_t keyBufLen
	, uint8_t **outBuf, size_t *outBufLen
);
// xor-sub-wipe-sub decryption.
// decrypts objBuf of objBufLen using (keyBuf+tick)
// pointers refrenced passed to outBuf and outBufLen are filled in with the result
//
SRG_EXPORT void SRG_XSWS_decryptData( uint8_t *objBuf, size_t objBufLen
	, uint64_t tick, const uint8_t *keyBuf, size_t keyBufLen
	, uint8_t **outBuf, size_t *outBufLen
);
//--------------------------------------------------------------
// block_shuffle.c
//
// Utilities to shuffle 2D data.
//
//  This can use a small swap block to tile over a larger 2D area
//
//  shuffles a matrix of bytes
//  1D operation is available by setting either height to 1
//  (arrays are 'wide' before they are 'high')
/*
{
	struct block_shuffle_key *key = BlockShuffle_CreateKey( SRG_CreateEntropy( NULL, 0 ), 8, 8 );
	uint8_t input_bytes[8][18];
	uint8_t encoded_bytes[8][8];
	uint8_t output_bytes[8][36];
	BlockShuffle_SetDataBlock( key, input, 2, 2, 15, 3, sizeof( input_bytes[0] )
		encoded, 0, 0, sizeof( encoded_bytes[0] ) );
	BlockShuffle_GetDataBlock( key, encoded, 2, 2, 15, 3, sizeof( encoded_bytes[0] )
		output_bytes, 0, 0, sizeof( input_bytes[0] ) );
}
{
	struct block_shuffle_key *BlockShuffle_CreateKey( SRG_CreateEntropy( NULL, 0 ), 8, 8 );
	uint8_t input_bytes[8][18];
	uint8_t encoded_bytes[8][8];
	uint8_t output_bytes[8][36];
}
*/
// API subjet to CHANGE!
// creates a swap-matrix of width by height matrix.  Could be a linear
// swap width (or height) is 1
SRG_EXPORT struct block_shuffle_key *BlockShuffle_CreateKey( struct random_context *ctx, size_t width, size_t height );
// do substitution within a range of data
SRG_EXPORT void BlockShuffle_SetDataBlock( struct block_shuffle_key *key
	, uint8_t* encrypted, int x, int y, size_t w, size_t h, size_t output_stride
	, uint8_t* input, int ofs_x, int ofs_y, size_t input_stride );
// do linear substitution over a range
SRG_EXPORT void BlockShuffle_SetData( struct block_shuffle_key *key
	, uint8_t* encrypted, int x, size_t w
	, uint8_t* input, int ofs_x );
// reverse subsittuion within a range of data
SRG_EXPORT void BlockShuffle_GetDataBlock( struct block_shuffle_key *key
	, uint8_t* encrypted, int x, int y, size_t w, size_t h, size_t encrypted_stride
	, uint8_t* output, int ofs_x, int ofs_y, size_t stride );
// reverse linear substituion over a range.
SRG_EXPORT void BlockShuffle_GetData( struct block_shuffle_key *key
	, uint8_t* encrypted, size_t x, size_t w
	, uint8_t* output, size_t ofs_x );
// Allocate a byte shuffler.
// This transformation creates a unique mapping of byteA to byteB.
// The SubByte and BusByte operations may be performed in either order
// but the complimentary function is required to decode the buffer.
//  (A->B) mapping with SubByte is different from (A->B) mapping with BusByte
// Bus(A) != Sub(A)  but  Bus(Sub(A)) == Sub(Bus(A)) == A
SRG_EXPORT struct byte_shuffle_key *BlockShuffle_ByteShuffler( struct random_context *ctx );
// Releases any resource sassociated with_byte shuffler_key.
void BlockShuffle_DropByteShuffler( struct byte_shuffle_key *key );
// BlockSHuffle_SubBytes and BLockShuffle_BusBytes are reflective routines.
//  They read bytes from 'bytes' and otuput to 'out_bytes'
//  in-place operation (bytes == out_bytes) is posssible.
// SubBytes swaps A->B
SRG_EXPORT void BlockShuffle_SubBytes( struct byte_shuffle_key *key
	, uint8_t *bytes, uint8_t *out_bytes, size_t byteCount );
// swap a single byte; can be in-place.
SRG_EXPORT void BlockShuffle_SubByte( struct byte_shuffle_key *key
	, uint8_t *bytes, uint8_t *out_bytes );
// BlockSHuffle_SubBytes and BlockShuffle_BusBytes are reflective routines.
//  They read bytes from 'bytes' and otuput to 'out_bytes'
//  in-place operation (bytes == out_bytes) is posssible.
// BusBytes swaps B->A
SRG_EXPORT void BlockShuffle_BusBytes( struct byte_shuffle_key *key, uint8_t *bytes
	, uint8_t *out_bytes, size_t byteCount );
// swap a single byte; can be in-place.
SRG_EXPORT void BlockShuffle_BusByte( struct byte_shuffle_key *key
	, uint8_t *bytes, uint8_t *out_bytes );
/* Provides Sack Virtual Filesystem interfaces. */
#ifndef SACK_VFS_DEFINED
/* Header multiple inclusion protection symbol. */
#define SACK_VFS_DEFINED
#ifdef SACK_VFS_STATIC
#  ifdef SACK_VFS_SOURCE
#    define SACK_VFS_PROC
#  else
#    define SACK_VFS_PROC extern
#  endif
#else
#  ifdef SACK_VFS_SOURCE
#    define SACK_VFS_PROC EXPORT_METHOD
#  else
#    define SACK_VFS_PROC IMPORT_METHOD
#  endif
#endif
#ifdef __cplusplus
/* defined the file system partial namespace (under
   SACK_NAMESPACE probably)                         */
#define _SACK_VFS_NAMESPACE  namespace SACK_VFS {
/* Define the ending symbol for file system namespace. */
#define _SACK_VFS_NAMESPACE_END }
#else
#define _SACK_VFS_NAMESPACE
#define _SACK_VFS_NAMESPACE_END
#endif
/* define the file system namespace end. */
#define SACK_VFS_NAMESPACE_END _SACK_VFS_NAMESPACE_END SACK_NAMESPACE_END
/* define the file system namespace. */
#define SACK_VFS_NAMESPACE SACK_NAMESPACE _SACK_VFS_NAMESPACE
#ifdef __cplusplus
namespace sack {
	/* Virtual File System interface/module. */
	namespace SACK_VFS {
#endif
#if !defined( VIRTUAL_OBJECT_STORE ) && !defined( FILE_BASED_VFS )
struct sack_vfs_volume;
struct sack_vfs_file;
struct sack_vfs_find_info;
// if the option to auto mount a file system is used, this is the
// name of the 'file system interface'  ( sack_get_filesystem_interface( SACK_VFS_FILESYSTEM_NAME ) )
#define SACK_VFS_FILESYSTEM_NAME "sack_shmem"
// open a volume at the specified pathname.
// if the volume does not exist, will create it.
// if the volume does exist, a quick validity check is made on it, and then the result is opened
// returns NULL if failure.  (permission denied to the file, or invalid filename passed, could be out of space... )
// same as load_cyrypt_volume with userkey and devkey NULL.
SACK_VFS_PROC struct sack_vfs_volume * sack_vfs_load_volume( CTEXTSTR filepath );
// open a volume at the specified pathname.  Use the specified keys to encrypt it.
// if the volume does not exist, will create it.
// if the volume does exist, a quick validity check is made on it, and then the result is opened
// returns NULL if failure.  (permission denied to the file, or invalid filename passed, could be out of space... )
// if the keys are NULL same as load_volume.
SACK_VFS_PROC struct sack_vfs_volume * sack_vfs_load_crypt_volume( CTEXTSTR filepath, uintptr_t version, CTEXTSTR userkey, CTEXTSTR devkey );
// pass some memory and a memory length of the memory to use as a volume.
// if userkey and/or devkey are not NULL the memory is assume to be encrypted with those keys.
// the space is opened as readonly; write accesses/expanding operations will fail.
SACK_VFS_PROC struct sack_vfs_volume * sack_vfs_use_crypt_volume( POINTER filemem, size_t size, uintptr_t version, CTEXTSTR userkey, CTEXTSTR devkey );
// close a volume; release all resources; any open files will keep the volume open.
// when the final file closes the volume will complete closing.
SACK_VFS_PROC void            sack_vfs_unload_volume( struct sack_vfs_volume * vol );
// remove unused extra allocated space at end of volume.  During working process, extra space is preallocated for
// things to be stored in.
SACK_VFS_PROC void            sack_vfs_shrink_volume( struct sack_vfs_volume * vol );
// remove encryption from volume.
SACK_VFS_PROC LOGICAL         sack_vfs_decrypt_volume( struct sack_vfs_volume *vol );
// change the key applied to a volume.
SACK_VFS_PROC LOGICAL         sack_vfs_encrypt_volume( struct sack_vfs_volume *vol, uintptr_t version, CTEXTSTR key1, CTEXTSTR key2 );
// create a signature of current directory of volume.
// can be used to validate content.  Returns 256 character hex string.
SACK_VFS_PROC const char *    sack_vfs_get_signature( struct sack_vfs_volume *vol );
// pass an offset from memory start and the memory start...
// computes the distance, uses that to generate a signature
// returns BLOCK_SIZE length signature; recommend using at least 128 bits of it.
SACK_VFS_PROC const uint8_t * sack_vfs_get_signature2( POINTER disk, POINTER diskReal );
// ---------- Operations on files in volumes ------------------
// open a file, creates if does not exist.
SACK_VFS_PROC struct sack_vfs_file * sack_vfs_openfile( struct sack_vfs_volume *vol, CTEXTSTR filename );
// check if a file exists (if it does not exist, and you don't want it created, can use this and not openfile)
SACK_VFS_PROC int sack_vfs_exists( struct sack_vfs_volume *vol, const char * file );
// close a file.
SACK_VFS_PROC int sack_vfs_close( struct sack_vfs_file *file );
// get the current File Position Index (FPI).
SACK_VFS_PROC size_t sack_vfs_tell( struct sack_vfs_file *file );
// get the length of the file
SACK_VFS_PROC size_t sack_vfs_size( struct sack_vfs_file *file );
// set the current File Position Index (FPI).
SACK_VFS_PROC size_t sack_vfs_seek( struct sack_vfs_file *file, size_t pos, int whence );
// write starting at the current FPI.
SACK_VFS_PROC size_t sack_vfs_write( struct sack_vfs_file *file, const void * data, size_t length );
// read starting at the current FPI.
SACK_VFS_PROC size_t sack_vfs_read( struct sack_vfs_file *file, void * data, size_t length );
// sets the file length to the current FPI.
SACK_VFS_PROC size_t sack_vfs_truncate( struct sack_vfs_file *file );
// psv should be struct sack_vfs_volume *vol;
// delete a filename.  Clear the space it was occupying.
SACK_VFS_PROC int sack_vfs_unlink_file( struct sack_vfs_volume *vol, const char * filename );
// rename a file within the filesystem; if the target name exists, it is deleted.  If the target file is also open, it will be prevented from deletion; and duplicate filenames will end up exising(?)
SACK_VFS_PROC LOGICAL sack_vfs_rename( uintptr_t psvInstance, const char *original, const char *newname );
// -----------  directory interface commands. ----------------------
// returns find_info which is then used in subsequent commands.
SACK_VFS_PROC struct sack_vfs_find_info * sack_vfs_find_create_cursor(uintptr_t psvInst,const char *base,const char *mask );
// reset find_info to the first directory entry.  returns 0 if no entry.
SACK_VFS_PROC int sack_vfs_find_first( struct sack_vfs_find_info *info );
// closes a find cursor; returns 0.
SACK_VFS_PROC int sack_vfs_find_close( struct sack_vfs_find_info *info );
// move to the next entry returns 0 if no entry.
SACK_VFS_PROC int sack_vfs_find_next( struct sack_vfs_find_info *info );
// get file information for the file at the current cursor position...
SACK_VFS_PROC char * sack_vfs_find_get_name( struct sack_vfs_find_info *info );
// get file information for the file at the current cursor position...
SACK_VFS_PROC size_t   sack_vfs_find_get_size ( struct sack_vfs_find_info *info );
SACK_VFS_PROC uint64_t sack_vfs_find_get_ctime( struct sack_vfs_find_info *info );
SACK_VFS_PROC uint64_t sack_vfs_find_get_wtime( struct sack_vfs_find_info *info );
#endif
#ifdef __cplusplus
/* virtual file system using file system IO instead of memory mapped IO */
namespace fs {
#endif
	struct sack_vfs_fs_volume;
	struct sack_vfs_fs_file;
	struct sack_vfs_fs_find_info;
	// open a volume at the specified pathname.
	// if the volume does not exist, will create it.
	// if the volume does exist, a quick validity check is made on it, and then the result is opened
	// returns NULL if failure.  (permission denied to the file, or invalid filename passed, could be out of space... )
	// same as load_cyrypt_volume with userkey and devkey NULL.
	SACK_VFS_PROC struct sack_vfs_fs_volume * sack_vfs_fs_load_volume( CTEXTSTR filepath );
	// open a volume at the specified pathname.  Use the specified keys to encrypt it.
	// if the volume does not exist, will create it.
	// if the volume does exist, a quick validity check is made on it, and then the result is opened
	// returns NULL if failure.  (permission denied to the file, or invalid filename passed, could be out of space... )
	// if the keys are NULL same as load_volume.
	SACK_VFS_PROC struct sack_vfs_fs_volume * sack_vfs_fs_load_crypt_volume( CTEXTSTR filepath, uintptr_t version, CTEXTSTR userkey, CTEXTSTR devkey );
	// pass some memory and a memory length of the memory to use as a volume.
	// if userkey and/or devkey are not NULL the memory is assume to be encrypted with those keys.
	// the space is opened as readonly; write accesses/expanding operations will fail.
	SACK_VFS_PROC struct sack_vfs_fs_volume * sack_vfs_fs_use_crypt_volume( POINTER filemem, size_t size, uintptr_t version, CTEXTSTR userkey, CTEXTSTR devkey );
	// close a volume; release all resources; any open files will keep the volume open.
	// when the final file closes the volume will complete closing.
	SACK_VFS_PROC void            sack_vfs_fs_unload_volume( struct sack_vfs_fs_volume * vol );
	// remove unused extra allocated space at end of volume.  During working process, extra space is preallocated for
	// things to be stored in.
	SACK_VFS_PROC void            sack_vfs_fs_shrink_volume( struct sack_vfs_fs_volume * vol );
	// remove encryption from volume.
	SACK_VFS_PROC LOGICAL         sack_vfs_fs_decrypt_volume( struct sack_vfs_fs_volume *vol );
	// change the key applied to a volume.
	SACK_VFS_PROC LOGICAL         sack_vfs_fs_encrypt_volume( struct sack_vfs_fs_volume *vol, uintptr_t version, CTEXTSTR key1, CTEXTSTR key2 );
	// create a signature of current directory of volume.
	// can be used to validate content.  Returns 256 character hex string.
	SACK_VFS_PROC const char *    sack_vfs_fs_get_signature( struct sack_vfs_fs_volume *vol );
	// pass an offset from memory start and the memory start...
	// computes the distance, uses that to generate a signature
	// returns BLOCK_SIZE length signature; recommend using at least 128 bits of it.
	SACK_VFS_PROC const uint8_t * sack_vfs_fs_get_signature2( POINTER disk, POINTER diskReal );
	// ---------- Operations on files in volumes ------------------
	// open a file, creates if does not exist.
	SACK_VFS_PROC struct sack_vfs_fs_file * sack_vfs_fs_openfile( struct sack_vfs_fs_volume *vol, CTEXTSTR filename );
	// check if a file exists (if it does not exist, and you don't want it created, can use this and not openfile)
	SACK_VFS_PROC int sack_vfs_fs_exists( struct sack_vfs_fs_volume *vol, const char * file );
	// close a file.
	SACK_VFS_PROC int sack_vfs_fs_close( struct sack_vfs_fs_file *file );
	// get the current File Position Index (FPI).
	SACK_VFS_PROC size_t sack_vfs_fs_tell( struct sack_vfs_fs_file *file );
	// get the length of the file
	SACK_VFS_PROC size_t sack_vfs_fs_size( struct sack_vfs_fs_file *file );
	// set the current File Position Index (FPI).
	SACK_VFS_PROC size_t sack_vfs_fs_seek( struct sack_vfs_fs_file *file, size_t pos, int whence );
	// write starting at the current FPI.
	SACK_VFS_PROC size_t sack_vfs_fs_write( struct sack_vfs_fs_file *file, const void * data, size_t length );
	// read starting at the current FPI.
	SACK_VFS_PROC size_t sack_vfs_fs_read( struct sack_vfs_fs_file *file, void * data, size_t length );
	// sets the file length to the current FPI.
	SACK_VFS_PROC size_t sack_vfs_fs_truncate( struct sack_vfs_fs_file *file );
	// psv should be struct sack_vfs_fs_volume *vol;
	// delete a filename.  Clear the space it was occupying.
	SACK_VFS_PROC int sack_vfs_fs_unlink_file( struct sack_vfs_fs_volume *vol, const char * filename );
	// rename a file within the filesystem; if the target name exists, it is deleted.  If the target file is also open, it will be prevented from deletion; and duplicate filenames will end up exising(?)
	SACK_VFS_PROC LOGICAL sack_vfs_fs_rename( uintptr_t psvInstance, const char *original, const char *newname );
	// -----------  directory interface commands. ----------------------
	// returns find_info which is then used in subsequent commands.
	SACK_VFS_PROC struct sack_vfs_fs_find_info * sack_vfs_fs_find_create_cursor( uintptr_t psvInst, const char *base, const char *mask );
	// reset find_info to the first directory entry.  returns 0 if no entry.
	SACK_VFS_PROC int sack_vfs_fs_find_first( struct sack_vfs_fs_find_info *info );
	// closes a find cursor; returns 0.
	SACK_VFS_PROC int sack_vfs_fs_find_close( struct sack_vfs_fs_find_info *info );
	// move to the next entry returns 0 if no entry.
	SACK_VFS_PROC int sack_vfs_fs_find_next( struct sack_vfs_fs_find_info *info );
	// get file information for the file at the current cursor position...
	SACK_VFS_PROC char * sack_vfs_fs_find_get_name( struct sack_vfs_fs_find_info *info );
	// get file information for the file at the current cursor position...
	SACK_VFS_PROC size_t sack_vfs_fs_find_get_size( struct sack_vfs_fs_find_info *info );
#ifdef __cplusplus
}
#endif
#ifdef __cplusplus
/* Object storage system, uses a optimized hash map to index unique identifiers and data associated with them.
Timeline exists, Multi-versioning support possible using the same file and different timestamps with associated data.
*/
namespace objStore {
#endif
	struct sack_vfs_os_volume;
	struct sack_vfs_os_file;
	struct sack_vfs_os_find_info;
	struct sack_vfs_os_time_cursor;
	/* thse should probably be moved to sack_vfs_os.h being file system specific extensions. */
	enum sack_object_store_file_system_file_ioctl_ops {
  // psvInstance should be a file handle pass (char*, size_t length )
		SOSFSFIO_PROVIDE_SEALANT,
 // test if file has been tampered, is is still sealed. pass (address of int)
		SOSFSFIO_TAMPERED,
 // get the resulting storage ID.  (Move ID creation into low level driver)
		SOSFSFIO_STORE_OBJECT,
 // set key required to read this record.
		SOSFSFIO_PROVIDE_READKEY,
		//SFSIO_GET_OBJECT_ID, // get the resulting storage ID.  (Move ID creation into low level driver)
 // creates an index for this record.
		SOSFSFIO_CREATE_INDEX,
 // remove an index (by name)
		SOSFSFIO_DESTROY_INDEX,
		SOSFSFIO_ADD_INDEX_ITEM,
		SOSFSFIO_REMOVE_INDEX_ITEM,
		SOSFSFIO_ADD_REFERENCE,
		SOSFSFIO_REMOVE_REFERENCE,
		SOSFSFIO_ADD_REFERENCE_BY,
		SOSFSFIO_REMOVE_REFERENCE_BY,
 // set file preferred block size intead of automatic
		SOSFSFIO_SET_BLOCKSIZE,
 // set the last updated time of a file
		SOSFSFIO_SET_TIME,
 // get the list of all times associated with a file
		SOSFSFIO_GET_TIMES,
 // get the last(current) time of the file
		SOSFSFIO_GET_TIME,
	};
	enum sack_object_store_file_system_system_ioctl_ops {
 // get the resulting storage ID.  (Move ID creation into low level driver)
		SOSFSSIO_STORE_OBJECT,
		SOSFSSIO_PATCH_OBJECT,
		SOSFSSIO_LOAD_OBJECT,
		SOSFSSIO_OPEN_VERSION,
		SOSFSSIO_NEW_VERSION,
		SOSFSSIO_OPEN_TIMELINE,
		SOSFSSIO_READ_TIMELINE,
		//SFSIO_GET_OBJECT_ID, // get the resulting storage ID.  (Move ID creation into low level driver)
	};
// returns a pointer to and array of buffers.
// the last pointer in the list is NULL.
// each pointer in the list points to a structure containing a pointer to the data and the length of the data
#define sack_vfs_os_ioctl_load_decrypt_object( vol, objId,objIdLen, seal,seallen )                            ((struct {uint8_t*, size_t}*)sack_fs_ioctl( vol, SOSFSSIO_LOAD_OBJECT, objId, objIdLen, seal, seallen ))
// returns a pointer to and array of buffers.
// the last pointer in the list is NULL.
// each pointer in the list points to a structure containing a pointer to the data and the length of the data
#define sack_vfs_os_ioctl_load_object( vol, objId,objIdLen )                                                  ((struct {uint8_t*, size_t}*)sack_fs_ioctl( vol, SOSFSSIO_LOAD_OBJECT, objId, objIdLen ))
// unsealed store/update(patch)
// returns TRUE/FALSE. true if the object already exists, or was successfully written.
// store object data, get a unique ID for the data.
// {
//     char data[] = "some data";
//     char result[44];
//     sack_vfs_os_ioctl_store_rw_object( vol, data, sizeof( data ), result, 44 );
// }
#define sack_vfs_os_ioctl_store_rw_object( vol, obj,objlen, result, resultlen )                                 sack_fs_ioctl( vol, SOSFSSIO_STORE_OBJECT, FALSE, obj, objlen, NULL, 0, NULL, 0, NULL, 0, result, resultlen )
// re-write an object with new content using old ID.
// returns TRUE/FALSE. true if the patch already exists, or was successfully written.
// {
//     char data[] = "some data";
//     char oldResult[] = "AAAAAAAAAAAAAAAAAAAAAAAA"; // ID from previous store result
//     char result[44];
//     sack_vfs_os_ioctl_patch_rw_object( vol, oldResult, sizeof( oldReult-1 ), data, sizeof( data ), result, 44 );
// }
#define sack_vfs_os_ioctl_patch_rw_object( vol, objId,objIdLen, obj,objlen )                                     sack_fs_ioctl( vol, SOSFSSIO_PATCH_OBJECT, FALSE, objId, objIdLen, NULL, 0, obj, objlen, NULL, 0, NULL, 0 )
// sealed store and patch
// store a unencrypted, sealed object using specified sealant
// store data to a new sealed block.  Also encrypt the data
// returns TRUE/FALSE. true if the object already exists, or was successfully written.
// {
//     char data[] = "some data";
//     char seal[] = "BBBBBBBBBBBBBBBBBBBBBBBB"; // Some sealant bsea64
//     char result[44];
//     sack_vfs_os_ioctl_store_crypt_object( vol, data, sizeof( data ), seal, sizeof( seal ), result, 44 );
// }
#define sack_vfs_os_ioctl_store_crypt_owned_object( vol, obj,objlen, seal,seallen, readkey,readkeylen, result, resultlen )                 sack_fs_ioctl( vol, SOSFSSIO_STORE_OBJECT, TRUE,TRUE,  obj, objlen, NULL, 0, seal, seallen, readkey,readkeylen, result, resultlen )
// store data to a new sealed block.  Also encrypt the data
// returns TRUE/FALSE. true if the object already exists, or was successfully written.
// {
//     char data[] = "some data";
//     char seal[] = "BBBBBBBBBBBBBBBBBBBBBBBB"; // Some sealant bsea64
//     char result[44];
//     sack_vfs_os_ioctl_store_crypt_object( vol, data, sizeof( data ), seal, sizeof( seal ), result, 44 );
// }
#define sack_vfs_os_ioctl_store_crypt_sealed_object( vol, obj,objlen, seal,seallen, readkey,readkeylen, result, resultlen )                 sack_fs_ioctl( vol, SOSFSSIO_STORE_OBJECT, TRUE,FALSE,  obj, objlen, NULL, 0, seal, seallen, readkey,readkeylen, result, resultlen )
// store patch to an existing sealed block.  (Writes never change existing data), also encrypt the data
// returns TRUE/FALSE. true if the patch already exists, or was successfully written.
// {
//     char data[] = "some data";
//     char seal[] = "BBBBBBBBBBBBBBBBBBBBBBBB"; // Some sealant bsea64
//     char oldResult[] = "AAAAAAAAAAAAAAAAAAAAAAAA"; // ID from previous store result
//     char result[44];
//     sack_vfs_os_ioctl_patch_crypt_object( vol, oldResult, sizeof( oldResult )-1, data, sizeof( data ), seal, sizeof( seal ), result, 44 );
// }
#define sack_vfs_os_ioctl_patch_crypt_owned_object( vol, objId,objIdLen, obj,objlen, seal,seallen, readkey,readkeylen, result, resultlen ) sack_fs_ioctl( vol, SOSFSSIO_PATCH_OBJECT, TRUE, TRUE, objId, objIdLen, authId, authIdLen, obj, objlen, seal, seallen, readkey,readkeylen, result, resultlen )
// store patch to an existing sealed block.  (Writes never change existing data), also encrypt the data
// returns TRUE/FALSE. true if the patch already exists, or was successfully written.
// {
//     char data[] = "some data";
//     char seal[] = "BBBBBBBBBBBBBBBBBBBBBBBB"; // Some sealant bsea64
//     char oldResult[] = "AAAAAAAAAAAAAAAAAAAAAAAA"; // ID from previous store result
//     char result[44];
//     sack_vfs_os_ioctl_patch_crypt_object( vol, oldResult, sizeof( oldResult )-1, data, sizeof( data ), seal, sizeof( seal ), result, 44 );
// }
#define sack_vfs_os_ioctl_patch_crypt_sealed_object( vol, objId,objIdLen, obj,objlen, seal,seallen, result, resultlen ) sack_fs_ioctl( vol, SOSFSSIO_PATCH_OBJECT, TRUE, FALSE, objId, objIdLen, authId, authIdLen, obj, objlen, seal, seallen, result, resultlen )
// store data to a new sealed block.  Data is publically readable.
// returns TRUE/FALSE. true if the object already exists, or was successfully written.
// {
//     char data[] = "some data";
//     char seal[] = "BBBBBBBBBBBBBBBBBBBBBBBB"; // Some sealant bsea64
//     char result[44];
//     sack_vfs_os_ioctl_store_owned_object( vol, data, sizeof( data ), seal, sizeof( seal ), result, 44 );
// }
#define sack_vfs_os_ioctl_store_owned_object( vol, obj,objlen, seal,seallen, result, resultlen )                 sack_fs_ioctl( vol, SOSFSSIO_STORE_OBJECT, FALSE, TRUE, obj, objlen, NULL, 0, seal, seallen, NULL, 0, result, resultlen )
// store data to a new sealed block.  Data is publically readable.
// returns TRUE/FALSE. true if the object already exists, or was successfully written.
// {
//     char data[] = "some data";
//     char seal[] = "BBBBBBBBBBBBBBBBBBBBBBBB"; // Some sealant bsea64
//     char result[44];
//     sack_vfs_os_ioctl_store_sealed_object( vol, data, sizeof( data ), seal, sizeof( seal ), result, 44 );
// }
#define sack_vfs_os_ioctl_store_sealed_object( vol, obj,objlen, seal,seallen, result, resultlen )                 sack_fs_ioctl( vol, SOSFSSIO_STORE_OBJECT, FALSE, FALSE, obj, objlen, NULL, 0, seal, seallen, NULL, 0, result, resultlen )
// store patch to an existing sealed block.  (Writes never change existing data).  Data is publically readable.
// returns TRUE/FALSE. true if the patch already exists, or was successfully written.
// {
//     char data[] = "some data";
//     char seal[] = "BBBBBBBBBBBBBBBBBBBBBBBB"; // Some sealant bsea64
//     char oldResult[] = "AAAAAAAAAAAAAAAAAAAAAAAA"; // ID from previous store result
//     char result[44];
//     sack_vfs_os_ioctl_patch_object( vol, oldResult, sizeof( oldResult )-1, data, sizeof( data ), seal, sizeof( seal ), result, 44 );
// }
#define sack_vfs_os_ioctl_patch_owned_object( vol, objId,objIdLen, obj,objlen, seal,seallen, result, resultlen ) sack_fs_ioctl( vol, SOSFSSIO_PATCH_OBJECT, FALSE, TRUE, objId, objIdLen, authId, authIdLen, obj, objlen, seal, seallen, result, resultlen )
// store patch to an existing sealed block.  (Writes never change existing data).  Data is publically readable.
// returns TRUE/FALSE. true if the patch already exists, or was successfully written.
// {
//     char data[] = "some data";
//     char seal[] = "BBBBBBBBBBBBBBBBBBBBBBBB"; // Some sealant bsea64
//     char oldResult[] = "AAAAAAAAAAAAAAAAAAAAAAAA"; // ID from previous store result
//     char result[44];
//     sack_vfs_os_ioctl_patch_object( vol, oldResult, sizeof( oldResult )-1, data, sizeof( data ), seal, sizeof( seal ), result, 44 );
// }
#define sack_vfs_os_ioctl_patch_sealed_object( vol, objId,objIdLen, obj,objlen, seal,seallen, result, resultlen ) sack_fs_ioctl( vol, SOSFSSIO_PATCH_OBJECT, FALSE, FALSE, objId, objIdLen, authId, authIdLen, obj, objlen, seal, seallen, result, resultlen )
#define sack_vfs_os_ioctl_create_index( file, indexName ) sack_vfs_os_file_ioctl( file, SOSFSFIO_CREATE_INDEX, indexName )
#define sack_vfs_os_ioctl_get_times( file, timeArray,tzArray,timeCount ) sack_vfs_os_file_ioctl( file, SOSFSFIO_GET_TIMES, timeArray,tzArray,timeCount )
// get the last write timeline index of a file
//     sack_vfs_os_ioctl_get_time( file )
#define sack_vfs_os_ioctl_get_time( file ) sack_vfs_os_file_ioctl( file, SOSFSFIO_GET_TIME )
#define sack_vfs_os_ioctl_set_time( file, timestamp,tz )            sack_vfs_os_file_ioctl( file, SOSFSFIO_SETTIME, timestamp,tz )
// open a volume at the specified pathname.
// if the volume does not exist, will create it.
// if the volume does exist, a quick validity check is made on it, and then the result is opened
// returns NULL if failure.  (permission denied to the file, or invalid filename passed, could be out of space... )
// same as load_cyrypt_volume with userkey and devkey NULL.
SACK_VFS_PROC struct sack_vfs_os_volume * sack_vfs_os_load_volume( CTEXTSTR filepath, struct file_system_mounted_interface* mount );
/*
    polish volume cleans up some of the dirty sectors.  It starts a background thread that
	waits a short time of no dirty updates. (flush, but polish <-> dirty )
 */
SACK_VFS_PROC void sack_vfs_os_polish_volume( struct sack_vfs_os_volume* vol );
SACK_VFS_PROC void sack_vfs_os_flush_volume( struct sack_vfs_os_volume* vol, LOGICAL unload );
// open a volume at the specified pathname.  Use the specified keys to encrypt it.
// if the volume does not exist, will create it.
// if the volume does exist, a quick validity check is made on it, and then the result is opened
// returns NULL if failure.  (permission denied to the file, or invalid filename passed, could be out of space... )
// if the keys are NULL same as load_volume.
SACK_VFS_PROC struct sack_vfs_os_volume * sack_vfs_os_load_crypt_volume( CTEXTSTR filepath, uintptr_t version, CTEXTSTR userkey, CTEXTSTR devkey, struct file_system_mounted_interface* mount );
// diagnostics can use this open; flags may control whether the journal is processed automatically on open.
// this flag can be used to disable journal replay.
#define SACK_VFS_LOAD_FLAG_NO_REPLAY 1
SACK_VFS_PROC struct sack_vfs_os_volume* sack_vfs_os_load_volume_v2( int flags, CTEXTSTR filepath, uintptr_t version, CTEXTSTR userkey, CTEXTSTR devkey, struct file_system_mounted_interface* mount );
// pass some memory and a memory length of the memory to use as a volume.
// if userkey and/or devkey are not NULL the memory is assume to be encrypted with those keys.
// the space is opened as readonly; write accesses/expanding operations will fail.
SACK_VFS_PROC struct sack_vfs_os_volume * sack_vfs_os_use_crypt_volume( POINTER filemem, size_t size, uintptr_t version, CTEXTSTR userkey, CTEXTSTR devkey );
// close a volume; release all resources; any open files will keep the volume open.
// when the final file closes the volume will complete closing.
SACK_VFS_PROC void            sack_vfs_os_unload_volume( struct sack_vfs_os_volume * vol );
// remove unused extra allocated space at end of volume.  During working process, extra space is preallocated for
// things to be stored in.
SACK_VFS_PROC void            sack_vfs_os_shrink_volume( struct sack_vfs_os_volume * vol );
// remove encryption from volume.
SACK_VFS_PROC LOGICAL         sack_vfs_os_decrypt_volume( struct sack_vfs_os_volume *vol );
// change the key applied to a volume.
SACK_VFS_PROC LOGICAL         sack_vfs_os_encrypt_volume( struct sack_vfs_os_volume *vol, uintptr_t version, CTEXTSTR key1, CTEXTSTR key2 );
// create a signature of current directory of volume.
// can be used to validate content.  Returns 256 character hex string.
SACK_VFS_PROC const char *    sack_vfs_os_get_signature( struct sack_vfs_os_volume *vol );
// pass an offset from memory start and the memory start...
// computes the distance, uses that to generate a signature
// returns BLOCK_SIZE length signature; recommend using at least 128 bits of it.
SACK_VFS_PROC const uint8_t * sack_vfs_os_get_signature2( POINTER disk, POINTER diskReal );
// extra file system operations, not in the normal API definition set.
SACK_VFS_PROC uintptr_t sack_vfs_os_system_ioctl( struct sack_vfs_os_volume* psvInstance, uintptr_t opCode, ... );
// ---------- Operations on files in volumes ------------------
// open a file, creates if does not exist.
SACK_VFS_PROC struct sack_vfs_os_file * sack_vfs_os_openfile( struct sack_vfs_os_volume *vol, CTEXTSTR filename );
// check if a file exists (if it does not exist, and you don't want it created, can use this and not openfile)
SACK_VFS_PROC int sack_vfs_os_exists( struct sack_vfs_os_volume *vol, const char * file );
// extra operations, not in the normal API definition set.
SACK_VFS_PROC uintptr_t sack_vfs_os_file_ioctl( struct sack_vfs_os_file *file, uintptr_t opCode, ... );
// close a file.
SACK_VFS_PROC int sack_vfs_os_close( struct sack_vfs_os_file *file );
// get the current File Position Index (FPI).
SACK_VFS_PROC size_t sack_vfs_os_tell( struct sack_vfs_os_file *file );
// get the length of the file
SACK_VFS_PROC size_t sack_vfs_os_size( struct sack_vfs_os_file *file );
// set the current File Position Index (FPI).
SACK_VFS_PROC size_t sack_vfs_os_seek( struct sack_vfs_os_file *file, size_t pos, int whence );
// write starting at the current FPI.
SACK_VFS_PROC size_t sack_vfs_os_write( struct sack_vfs_os_file *file, const void * data, size_t length );
// read starting at the current FPI.
SACK_VFS_PROC size_t sack_vfs_os_read( struct sack_vfs_os_file *file, void * data, size_t length );
// sets the file length to the current FPI.
SACK_VFS_PROC size_t sack_vfs_os_truncate( struct sack_vfs_os_file *file );
// psv should be struct sack_vfs_os_volume *vol;
// delete a filename.  Clear the space it was occupying.
SACK_VFS_PROC int sack_vfs_os_unlink_file( struct sack_vfs_os_volume *vol, const char * filename );
// rename a file within the filesystem; if the target name exists, it is deleted.  If the target file is also open, it will be prevented from deletion; and duplicate filenames will end up exising(?)
SACK_VFS_PROC LOGICAL sack_vfs_os_rename( uintptr_t psvInstance, const char *original, const char *newname );
// -----------  directory interface commands. ----------------------
// returns find_info which is then used in subsequent commands.
SACK_VFS_PROC struct sack_vfs_os_find_info * sack_vfs_os_find_create_cursor( uintptr_t psvInst, const char *base, const char *mask );
// reset find_info to the first directory entry.  returns 0 if no entry.
SACK_VFS_PROC int sack_vfs_os_find_first( struct sack_vfs_os_find_info *info );
// closes a find cursor; returns 0.
SACK_VFS_PROC int sack_vfs_os_find_close( struct sack_vfs_os_find_info *info );
// move to the next entry returns 0 if no entry.
SACK_VFS_PROC int sack_vfs_os_find_next( struct sack_vfs_os_find_info *info );
// get file information for the file at the current cursor position...
SACK_VFS_PROC char * sack_vfs_os_find_get_name( struct sack_vfs_os_find_info *info );
// get file information for the file at the current cursor position...
SACK_VFS_PROC size_t sack_vfs_os_find_get_size( struct sack_vfs_os_find_info *info );
// get times for the object in storage.
SACK_VFS_PROC LOGICAL sack_vfs_os_get_times( struct sack_vfs_os_file* file, uint64_t** timeArray, int8_t**tzArray, size_t* timeCount );
// set last time for object in storage. (overwrites current tick used to update on write)
SACK_VFS_PROC LOGICAL sack_vfs_os_set_time( struct sack_vfs_os_file* file, uint64_t time, int8_t tz );
SACK_VFS_PROC struct sack_vfs_os_time_cursor* sack_vfs_os_get_time_cursor( struct sack_vfs_os_volume* vol );
SACK_VFS_PROC LOGICAL sack_vfs_os_read_time_cursor( struct sack_vfs_os_time_cursor* cursor, int step, uint64_t time_, uint64_t* entry, const char** filename, uint64_t* result_timestamp, int8_t* result_tz, const char** buffer, size_t* size );
// force disabling any further writes to the volue; for unit-testing journal recovery.
SACK_VFS_PROC LOGICAL sack_vfs_os_halt( struct sack_vfs_os_volume* volume );
// generate a report about the internal structure of the volue...
// journal parameters, timeline length?  File Entries?
SACK_VFS_PROC LOGICAL sack_vfs_os_analyze( struct sack_vfs_os_volume* volume );
#ifdef __cplusplus
}
#endif
//DOM-IGNORE-BEGIN
#if defined USE_VFS_FS_INTERFACE
#define sack_vfs_volume sack_vfs_fs_volume
#define sack_vfs_file sack_vfs_fs_file
#define sack_vfs_load_volume  sack_vfs_fs_load_volume
#define sack_vfs_load_crypt_volume  sack_vfs_fs_load_crypt_volume
#define sack_vfs_use_crypt_volume  sack_vfs_fs_use_crypt_volume
#define sack_vfs_unload_volume  sack_vfs_fs_unload_volume
#define sack_vfs_shrink_volume  sack_vfs_fs_shrink_volume
#define sack_vfs_decrypt_volume  sack_vfs_fs_decrypt_volume
#define sack_vfs_encrypt_volume  sack_vfs_fs_encrypt_volume
#define sack_vfs_get_signature  sack_vfs_fs_get_signature
#define sack_vfs_get_signature2  sack_vfs_fs_get_signature2
#define sack_vfs_openfile  sack_vfs_fs_openfile
#define sack_vfs_exists  sack_vfs_fs_exists
#define sack_vfs_close  sack_vfs_fs_close
#define sack_vfs_tell  sack_vfs_fs_tell
#define sack_vfs_size  sack_vfs_fs_size
#define sack_vfs_seek  sack_vfs_fs_seek
#define sack_vfs_write  sack_vfs_fs_write
#define sack_vfs_read  sack_vfs_fs_read
#define sack_vfs_truncate  sack_vfs_fs_truncate
#define sack_vfs_unlink_file  sack_vfs_fs_unlink_file
#define sack_vfs_rename  sack_vfs_fs_rename
#define sack_vfs_find_create_cursor  sack_vfs_fs_find_create_cursor
#define sack_vfs_find_first  sack_vfs_fs_find_first
#define sack_vfs_find_close  sack_vfs_fs_find_close
#define sack_vfs_find_next  sack_vfs_fs_find_next
#define sack_vfs_find_get_name  sack_vfs_fs_find_get_name
#define sack_vfs_find_get_size  sack_vfs_fs_find_get_size
#define sack_vfs_find_get_cdate  sack_vfs_fs_find_get_cdate
#define sack_vfs_find_get_wdate  sack_vfs_fs_find_get_wdate
#endif
#if defined USE_VFS_OS_INTERFACE
#define sack_vfs_volume sack_vfs_os_volume
#define sack_vfs_file sack_vfs_os_file
#define sack_vfs_load_volume(a)  sack_vfs_os_load_volume(a,NULL)
#define sack_vfs_load_crypt_volume(a,b,c,d)  sack_vfs_os_load_crypt_volume(a,b,c,d,NULL)
#define sack_vfs_use_crypt_volume  sack_vfs_os_use_crypt_volume
#define sack_vfs_unload_volume  sack_vfs_os_unload_volume
#define sack_vfs_shrink_volume  sack_vfs_os_shrink_volume
#define sack_vfs_decrypt_volume  sack_vfs_os_decrypt_volume
#define sack_vfs_encrypt_volume  sack_vfs_os_encrypt_volume
#define sack_vfs_get_signature  sack_vfs_os_get_signature
#define sack_vfs_get_signature2  sack_vfs_os_get_signature2
#define sack_vfs_openfile  sack_vfs_os_openfile
#define sack_vfs_exists  sack_vfs_os_exists
#define sack_vfs_close  sack_vfs_os_close
#define sack_vfs_tell  sack_vfs_os_tell
#define sack_vfs_size  sack_vfs_os_size
#define sack_vfs_seek  sack_vfs_os_seek
#define sack_vfs_write  sack_vfs_os_write
#define sack_vfs_read  sack_vfs_os_read
#define sack_vfs_truncate  sack_vfs_os_truncate
#define sack_vfs_unlink_file  sack_vfs_os_unlink_file
#define sack_vfs_rename  sack_vfs_os_rename
#define sack_vfs_find_create_cursor  sack_vfs_os_find_create_cursor
#define sack_vfs_find_first  sack_vfs_os_find_first
#define sack_vfs_find_close  sack_vfs_os_find_close
#define sack_vfs_find_next  sack_vfs_os_find_next
#define sack_vfs_find_get_name  sack_vfs_os_find_get_name
#define sack_vfs_find_get_size  sack_vfs_os_find_get_size
#define sack_vfs_find_get_cdate  sack_vfs_os_find_get_cdate
#define sack_vfs_find_get_wdate  sack_vfs_os_find_get_wdate
#endif
//DOM-IGNORE-END
#if defined( __cplusplus )
 //SACK_VFS_NAMESPACE_END
} }
using namespace sack::SACK_VFS;
using namespace sack::SACK_VFS::fs;
using namespace sack::SACK_VFS::objStore;
#endif
#endif
/* SQL Option Interface. Gets and sets options; option interface
   resembles legacy windows INI interface.                       */
#ifndef SQL_OPTIONS_DEFINED
#define SQL_OPTIONS_DEFINED
/* more documentation at end */
/*
 *
 *   Creator: Panther   #implemented in Dekware
 *   Modified by: Jim Buckeyne #ported to service SQL via proxy.
 *   Returned to sack by: Jim Buckeyne
 *                  # stripped application specific
 *                  # features, returned to SACK.
 *
 *  Provides a simple, intuitive interface to SQL.  Used sensibly,
 *  provides garbage collection of resources.
 *
 *  Commands without an ODBC specifier are the perferred method to
 *  use this interface.  This allows the internal system to maintain
 *  a primary and a redundant backup connection to provide transparent
 *  reliability to the application.
 *
 *  Provides some slick table creation routines
 *     - check for existance, and drop  (CTO_DROP)
 *     - check for existance, and match (CTO_MATCH)
 *     - check for existance, and merge (CTO_MERGE)
 *     - create table if not exist.
 *
 *  Latest additions provide ...RecordQuery... functions which
 *  result with a const CTEXTSTR * of results;  (ie, result[0] = (CTEXTSTR)result1 )
 *  also available are the column names from the query.
 *  I strongly recommend passing NULL always to the field names, and
 *  using sensible enumerators that follow the query definition.
 *
 *  (c)Freedom Collective (Jim Buckeyne 2000-2016)
 *
 */
#ifndef PSSQL_STUB_DEFINED
/* multiple inclusion protection symbol */
#define PSSQL_STUB_DEFINED
#if defined( SQLSTUB_SOURCE ) || defined( SQLPROXY_LIBRARY_SOURCE )
#define PSSQL_PROC(type,name) EXPORT_METHOD type CPROC name
#else
/* Macro declaring PSSQL procs. */
#define PSSQL_PROC(type,name) IMPORT_METHOD type CPROC name
#endif
#ifdef __cplusplus
#define _SQL_NAMESPACE   namespace sql {
#define _SQL_NAMESPACE_END   }
#define SQL_NAMESPACE   namespace sack { namespace sql {
#define SQL_NAMESPACE_END } }
#else
#define _SQL_NAMESPACE
#define _SQL_NAMESPACE_END
/* Marks the beginning of SQL Namespace. */
#define SQL_NAMESPACE
/* Marks the end of SQL Namespace. */
#define SQL_NAMESPACE_END
#endif
#ifdef __cplusplus
namespace sack {
#endif
/* SQL access library. This provides a simple access to ODBC
   connections, and to sqlite. If no database is specified,
   there is an internal database that can be used. These methods
   on the PODBC connection are NOT thread safe. Multiple threads
   shall never use the same PODBC; they can use seperate PODBC
   connections. Under linux this links to unixODBC.
   DoSQLCommandf
   DoSQLRecordQueryf
   GetSQLRecord
   ConnectToDatabase
   DoSQLCommandf
   DoSQLRecordQueryf
   FetchSQLRecord
   There is a configuration file for the default SQL connection,
   this is kept in a file 'sql.config' which is processed with
   ProcessConfigurationFile(); If this file does not exist, it
   will be automatically created with default values.
   (Need to describe this sql.config file)                       */
#ifdef __cplusplus
    namespace sql {
#endif
/* <combine PSSQL_PROC>
   \ \                    */
#define SQLPROXY_PROC PSSQL_PROC
/* This is the connection object that provides interface to the
   database. Can be NULL to specify the default connection
   interface. See namespace <link sack::sql, sql>.
   An ODBC connection handles commands as a stack. Each command
   is done as a temporary entry on the stack. A query is done as
   an entry on the stack, but the entry remains on the stack
   until the final result is retrieved or an early PopODBC is
   called.
   The structure of this is such that if a command is slow to a
   database, it would be possible to stack commands that are
   temporary and pending until the database connection is
   restored.
   Example
   <code lang="c++">
   int f( void )
   {
       // results from the query
       CTEXTSTR *results;
       // connect.
       PODBC odbc = ConnectToDatabase( "system_dsn_name" );
       // do a command, does a temporary entry on the stack, unless the database is slow
       SQLCommandf( odbc, "create temporary table my_test_table( ID int, value int )" );
       // start a new entry on the command stack.
       SQLRecordQueryf( odbc, NULL, &amp;results, NULL, "select 1+1" );
       // when this command is done, it is stacked on the query.
       SQLCommandf( odbc, "insert into my_test_table (value) values(%d)", 1234 );
       // at this point there is technically 2 entries on the command stack until the next
       // FetchSQLResult( odbc, &amp;results );
   }
	</code>                                                                                 */
#if !defined( __GNUC__ ) || !defined( SQLSTUB_SOURCE )
   // GCC doesn't identify this as exactly the same declaration
	typedef struct odbc_handle_tag *PODBC;
#endif
typedef struct odbc_handle_tag ODBC;
// recently added {} container braces for structure element
#define FIELDS(n) {( sizeof( n ) / sizeof( FIELD ) ), n}
/* a field definition can be a rename, and contain prior names,
   so that the rename can be tracked and migrated appropraitely.
   Unfortuntaly this sort of operation only affects this code,
   and not all auxiliary code.                                   */
#define MAX_PREVIOUS_FIELD_NAMES 4
/* <combine sack::sql::required_field_tag>
   <code lang="c++">
     FIELD fields[] = { { "ID", "int" }, ... };
   </code>                                            */
typedef struct required_field_tag
{
	/* This is the name of the column described in this table. */
	CTEXTSTR name;
	/* pointer to a string describing the type of this column.  */
	CTEXTSTR type;
	/* extra information about the field... grab all addtional
	   information like 'NOT NULL' "default 'zxa'" to describe a
	   field. Sometimes target databases don't understand extra
	   \parameters, and these can be translated as required or
	   ignored.                                                  */
	CTEXTSTR extra;
	// if you have renamed this column more than 1
	// times - you really need to stop messing around
	// and get a life.
	CTEXTSTR previous_names[MAX_PREVIOUS_FIELD_NAMES];
} FIELD, *PFIELD;
#if !defined( _MSC_VER ) || ( _MSC_VER >= 800 )
/* A macro to append a NULL automatically to a list of strings.
   Example
   <code lang="c++">
   CTEXTSTR strings[] = { KEY_COLUMNS( "one", "two", "three" ) };
   </code>
   strings will be set to 4 elements with the 3 strings listed
   in KEY_COLUMNS plus a NULL string.                             */
#define KEY_COLUMNS(...) { __VA_ARGS__, NULL }
#endif
/* sets the count and the array of a statically declared
   required_table_tag.
   Example
   <code lang="c++">
   </code>
   <code>
   FIELD fields[5];
   DB_KEY_DEF keys[3];
   TABLE table = { "table_name", FIELDS( fields ), TABLE_KEYS( keys ) };
   </code>
   This creates a static table definition with the name
   "table_name" and 5 fields with 3 keys. fields[] = { } is
   usally the declartion. Also DB_KEY_DEF keys[] = { ... }; for
   keys.
                                                                         */
#define TABLE_KEYS(n) {( sizeof( n ) / sizeof( DB_KEY_DEF ) ), n}
/* maximum columns that can be specified for a multicolumn index
   in required_key_def.                                          */
#define MAX_KEY_COLUMNS 8
/* <combine sack::sql::required_key_def>
   \ \                                   */
typedef struct required_key_def  DB_KEY_DEF;
enum uniqueResolutions {
  // no on conflict specification.
	UNIQRES_UNSET = 0,
	UNIQRES_REPLACE,
	UNIQRES_IGNORE,
	UNIQRES_FAIL,
	UNIQRES_ABORT,
	UNIQRES_ROLLBACK
};
/* <combine sack::sql::required_key_def>
   \ \                                   */
typedef struct required_key_def  *PDB_KEY_DEF;
struct required_key_def
{
	/* Flags describing attributes of this key */
	/* <combine sack::sql::required_key_def::flags@1>
	   \ \                                            */
	struct {
		/* this defines the primary key for the table */
		BIT_FIELD bPrimary : 1;
		/* the key is meant to be unique. */
		BIT_FIELD bUnique : 1;
		BIT_FIELD uniqueResolution : 3;
	} flags;
	/* Name of the key column. Can be NULL if primary. */
	CTEXTSTR name;
 // uhm up to 5 colnames...
	CTEXTSTR colnames[MAX_KEY_COLUMNS];
 // if not null, broken structure...
	CTEXTSTR null;
#ifdef __cplusplus
   /* <combine sack::sql::required_key_def>
      This is used when actually building C++ for providing an
      initializer to this structure.                           */
   required_key_def( int bPrimary, int bUnique, CTEXTSTR _name, CTEXTSTR colname1 ) { flags.bPrimary = bPrimary; flags.bUnique = bUnique; name = _name; colnames[0] = colname1; colnames[1] = NULL; }
   /* <combine sack::sql::required_key_def>
      This is used when actually building C++ for providing an
      initializer to this structure.                           */
   required_key_def( int bPrimary, int bUnique, CTEXTSTR _name, CTEXTSTR colname1, CTEXTSTR colname2 ) { flags.bPrimary = bPrimary; flags.bUnique = bUnique; name = _name; colnames[0] = colname1; colnames[1] = colname2; colnames[2] = 0; }
	/* Just another required_key_def constructor. */
	required_key_def( int bPrimary, int bUnique, CTEXTSTR _name, CTEXTSTR colname1, CTEXTSTR colname2, CTEXTSTR colname3 ) { flags.bPrimary = bPrimary; flags.bUnique = bUnique; name = _name; colnames[0] = colname1; colnames[1] = colname2; colnames[2] = colname3; colnames[3] = 0; }
#else
#define required_key_def( a,b,c,...) { {a,b}, c, {__VA_ARGS__} }
#endif
};
 /* Describes a key column of a table.
      <code lang="c++">
      DB_KEY_DEF keys[] = { { "lockey", KEY_COLUMNS("hall_id","charity_id") } };
      </code>                                                                    */
/* <combine sack::sql::required_constraint_def>
   \ \                                   */
typedef struct required_constraint_def  DB_CONSTRAINT_DEF;
/* <combine sack::sql::required_constraint_def>
   \ \                                   */
typedef struct required_constraint_def  *PDB_CONSTRAINT_DEF;
struct required_constraint_def
{
	struct {
		BIT_FIELD cascade_on_delete : 1;
		BIT_FIELD cascade_on_update : 1;
		BIT_FIELD restrict_on_delete : 1;
		BIT_FIELD restrict_on_update : 1;
		BIT_FIELD noaction_on_delete : 1;
		BIT_FIELD noaction_on_update : 1;
		BIT_FIELD setnull_on_delete : 1;
		BIT_FIELD setnull_on_update : 1;
		BIT_FIELD setdefault_on_delete : 1;
		BIT_FIELD setdefault_on_update : 1;
		BIT_FIELD foreign_key : 1;
	} flags;
	CTEXTSTR name;
 // uhm up to 5 colnames...
	CTEXTSTR colnames[MAX_KEY_COLUMNS];
	CTEXTSTR references;
 // uhm up to 5 colnames...
	CTEXTSTR foriegn_colnames[MAX_KEY_COLUMNS];
 // if not null, broken structure...
	CTEXTSTR null;
 // Describes a constraint clause
};
/* Example
   By default, CreateTable( CTEXTSTR tablename, CTEXTSTR
   filename ) which reads a 'create table' statement from a file
   to create a table, this now parses the create table structure
   into an internal structure TABLE which has FIELDs and
   DB_KEY_DEFs. This structure is now passed to CheckODBCTable
   which is able to compare the structure with the table
   definition available from the database via DESCRIBE TABLE,
   and then update the table in the database to match the TABLE
   definition.
   One can use the table structure to define tables instead of
   maintaining external files... and without having to create a
   temporary external file which could then contain a create
   table statement to create the table.
   <code>
   // declare some fields...
   FIELD some_table_field_array_name[] = { { "field one", "int", NULL }
   , { "field two", "varchar(100)", NULL }
   , { "ID field", "int", "auto_increment" }
   , { "some other field", "int", "NOT NULL default '8'" }
   };
   // define some keys...
   DB_KEY_DEF some_table_key_array_name[] = { { .flags = { .bPrimary = 1 }, NULL, {"ID Field"} }
   , { {0}, "namekey", { "field two", NULL } }
   };
   </code>
   // the structure for DB_KEY_DEF takes an array of column
   names used to define the key, there should be a NULL to end
   the list. The value after the array of field names is called
   'null' which should always be set to NULL. If these are
   declared in global data space, then any unset value will be
   initialized to zero.
   <code>
   TABLE some_table_var_name = { "table name", FIELDS( some_table_field_array_name ), TABLE_KEYS( some_table_key_array_name ), 1 );
    LOGICAL CheckODBCTable( PODBC odbc, PTABLE table, uint32_t options )
        PODBC odbc - may be left NULL to use the default database connection.
        PTABLE table - a pointer to a TABLE structure which has been initialized.
        uint32_t options - zero or more of  the following symbols or'ed together.
                   \#define CTO_MATCH 4  // attempt to figure out alter statements to drop or add columns to exact match definition
                   \#define CTO_MERGE 8  // attempt to figure out alter statements to add missing columns, do not drop.  Rename?
   </code>
   Then some routine later
   <code>
   {
      ...
      CheckODBCTable( NULL, &amp;some_table_var_name, CTO_MERGE );
      ..
   }
   </code>
   * ---------------------------------------------------------- *
   alternatively tables may be checked and updated using the
   following code, given an internal constant text string that
   is the create table statement, this may be parsed into a
   PTABLE structure which the resulting table can be used in
   CheckODBCTable();
   <code>
   static CTEXTSTR create_player_info = "CREATE TABLE `players_info` ("
         "  `player_id` int(11) NOT NULL auto_increment,           "
         "  PRIMARY KEY  (`player_id`),                            "
         ")                               ";
   PTABLE table = GetFieldsInSQL( create_player_info, FALSE );
   CheckODBCTable( NULL, table, CTO_MERGE );
   DestroySQLTable( table );
   </code>                                                                                                                          */
struct required_table_tag
{
	/* This is the name of the table. */
	CTEXTSTR name;
	/* describes the columns (fields) in a table. */
	struct pssql_table_fields {
		/* number of fields in the array pointed at by field. */
		int count;
		/* pointer to an array of FIELD. */
		PFIELD field;
	} fields;
	/* Describes the keys on the table.  */
	/* <combine sack::sql::required_table_tag::keys@1>
	   \ \                                             */
	struct pssql_table_key {
		/* number of keys pointed at by key. */
		int count;
      /* pointer to an array of DB_REQ_KEY. */
      PDB_KEY_DEF key;
	} keys;
	struct pssql_table_constraint {
		int count;
		PDB_CONSTRAINT_DEF constraint;
	} constraints;
	/* <combine sack::sql::required_table_tag::flags@1>
	   \ \                                              */
	/* flags controlling the table. */
		struct pssql_table_flags {
         // set this if defined dynamically (from getfields in SQL)
		BIT_FIELD bDynamic : 1;
		/* This is a table that is allocated in memory, static table
		   definitions should leave this 0.                          */
		BIT_FIELD bTemporary : 1;
		/* Issue the create statement always, but include 'if not
		   exists'. Don't try and compare the table structure.    */
		BIT_FIELD bIfNotExist : 1;
	} flags;
   /* name of another table that already exists. Creates this table
      using that table's description.                               */
   CTEXTSTR create_like_table_name;
   /* name of the database that contains this table. */
   CTEXTSTR database;
   /* an additional field that can specify the database storage
      engine to use. (Hmm maybe use this to specify sqlite target?) */
   CTEXTSTR type;
   /* This is an additional field to add as a description to the
      database if supported by the target database.              */
   CTEXTSTR comment;
};
/* <combine sack::sql::required_table_tag>
   \ \                                     */
typedef struct required_table_tag TABLE;
/* <combine sack::sql::required_table_tag>
   \ \                                     */
typedef struct required_table_tag *PTABLE;
/* Checks a table in a database to see if it exists, and that
   all the columns in the table definition passed exist as
   column in the database. Will generate alter statements to the
   table as appropriate.
   Parameters
   odbc :     connection to check the table on
   table :    a table which was created with GetFieldsInSQL, or
              created by filling in a structure.
   options :  Options from CreateTableOptions.                   */
PSSQL_PROC( LOGICAL, CheckODBCTableEx)( PODBC odbc, PTABLE table, uint32_t options DBG_PASS );
/* Checks a table in a database to see if it exists, and that
   all the columns in the table definition passed exist as
   column in the database. Will generate alter statements to the
   table as appropriate.
   Parameters
   odbc :     connection to check the table on
   table :    a table which was created with GetFieldsInSQL, or
              created by filling in a structure.
   options :  Options from CreateTableOptions.                   */
PSSQL_PROC( LOGICAL, CheckODBCTable)( PODBC odbc, PTABLE table, uint32_t options );
/* <combine sack::sql::CheckODBCTableEx@PODBC@PTABLE@uint32_t options>
   \ \                                                            */
#define CheckODBCTable(odbc,t,opt) CheckODBCTableEx(odbc,t,opt DBG_SRC )
/* Enable or disable logging SQL to the sql.log file and to the
   application's log.
   Parameters
   odbc :      connection to disable logging on
   bDisable :  if TRUE disables logging, else restores logging. */
PSSQL_PROC( void, SetSQLLoggingDisable )( PODBC odbc, LOGICAL bDisable );
/* Set required connection flag, this causes a connection that fails, to wait until
   the connection is reconnected before continuing.
*/
PSSQL_PROC( void, SetConnectionRequired )( PODBC odbc, LOGICAL require );
/* Get the required connection flag froma connection.
*/
PSSQL_PROC( LOGICAL, GetConnectionRequired )( PODBC odbc );
#ifndef SQLPROXY_INCLUDE
// result is FALSE on error
// result is TRUE on success
PSSQL_PROC( int, DoSQLCommandEx )( CTEXTSTR command DBG_PASS);
#endif
/* <combine sack::sql::DoSQLCommandEx@CTEXTSTR command>
   \ \                                                  */
#define DoSQLCommand(c) DoSQLCommandEx(c DBG_SRC )
/* Generate a commit for any outstanding transactions. Commit
   syntax is variable depending on the connection. Connections
   also have the feature to auto generate begin transaction, and
   flush after a period of idle.
   Parameters
   odbc :  connection to database to commit                      */
PSSQL_PROC( void, SQLCommit )( PODBC odbc );
/* generates the begin transaction for a commection.
   Parameters
   odbc :  connection to database to start a transaction        */
PSSQL_PROC( void, SQLBeginTransact )( PODBC odbc );
// parameters to this are pairs of "name", type, "value"
//  type == 0 - value is text, do not quote
//  type == 1 - value is text, add quotes appropriate for database
//  type == 2 - value is an integer, do not quote
// the last pair's name is NULL, and value does not matter.
// insert values into said table.
PSSQL_PROC( int, DoSQLInsert )( CTEXTSTR table, ... );
#ifndef SQLPROXY_INCLUDE
/* This opens or re-opens a database connection. Mostly an
   \internal function(?)
   Parameters
   odbc :  connection to open.                             */
PSSQL_PROC( int, OpenSQLConnection )( PODBC );
#endif
/* This opens or re-opens a database connection. Mostly an
   \internal function(?)
   Parameters
   odbc :  connection to open.                             */
PSSQL_PROC( int, OpenSQLConnectionEx )( PODBC DBG_PASS );
/* <combine sack::sql::OpenSQLConnectionEx@PODBC>
   \ \                                            */
#define OpenSQLConnect(o) OpenSQLConnectionEx( o DBG_SRC )
// should pass to this a &(CTEXTSTR) which starts as NULL for result.
// result is FALSE on error
// result is TRUE on success, and **result is updated to
// contain the resulting data.
PSSQL_PROC( int, DoSQLQueryEx )( CTEXTSTR query, CTEXTSTR *result DBG_PASS);
/* <combine sack::sql::DoSQLQueryEx@CTEXTSTR@CTEXTSTR *result>
   \ \                                                         */
#define DoSQLQuery(q,r) DoSQLQueryEx( q,r DBG_SRC )
/* <combine sack::sql::DoSQLRecordQueryf@int *@CTEXTSTR **@CTEXTSTR **@CTEXTSTR@...>
   \ \                                                                               */
#define DoSQLRecordQuery(q,r,c,f) SQLRecordQueryEx( NULL,q,r,c,f DBG_SRC )
/* <combine sack::sql::SQLRecordQueryEx@PODBC@CTEXTSTR@int *@CTEXTSTR **@CTEXTSTR **fields>
   \ \                                                                                      */
#define DoSQLQueryRecord(q,r,c)   DoSQLRecordQuery(q,r,c,NULL)
/* <combine sack::sql::SQLRecordQueryEx@PODBC@CTEXTSTR@int *@CTEXTSTR **@CTEXTSTR **fields>
   \ \                                                                                      */
#define SQLQueryRecord(o,q,r,c)   SQLRecordQuery(o,q,r,c,NULL)
/* <combine sack::sql::GetSQLRecord@CTEXTSTR **>
   \ \                                           */
#define GetSQLResultRecord(r,c)   GetSQLRecord(c)
/* <combine sack::sql::FetchSQLResult@PODBC@CTEXTSTR *>
   \ \                                                  */
PSSQL_PROC( int, GetSQLResult )( CTEXTSTR *result );
/* <combine sack::sql::FetchSQLRecord@PODBC@CTEXTSTR **>
   \ \                                                   */
PSSQL_PROC( int, GetSQLRecord )( CTEXTSTR **result );
/* Gets the last result on the default ODBC connection.
   Parameters
   result\ :  address of a string pointer to get set to the error
              string.
   Example
   <code>
   {
      CTEXTSTR error;
      GetSQLError( &amp;error );
      printf( "Error: %s", error );
   }
   </code>                                                        */
PSSQL_PROC( int, GetSQLError )( CTEXTSTR *result );
/* This is a test command that tests to see if the default
   database connection is able to work.                    */
PSSQL_PROC( int, IsSQLReady )( void );
/* <combine sack::sql::PushSQLQueryExEx@PODBC>
   \ \                                         */
PSSQL_PROC( int, PushSQLQuery )( void );
/* <combine sack::sql::PopODBCEx@PODBC>
   \ \                                  */
PSSQL_PROC( void, PopODBC )( void );
#ifndef SQLPROXY_INCLUDE
/* Clear the top non temporary sql statement from the PODBC
   stack.
   Parameters
   odbc :  connection to remove the statement from.
   Remarks
   A SQLCommand is temporary, a SQLQuery or a PushODBC is not. Pop
   MAY be used to clear a query early, but it is recommended to
   read to the end of it instead.                                  */
PSSQL_PROC( void, PopODBCExx )( PODBC, LOGICAL DBG_PASS );
PSSQL_PROC( void, PopODBCEx )( PODBC );
/* <combine sack::sql::PopODBCExx@PODBC@LOGICAL>
   \ \                                           */
#define PopODBCEx(o) PopODBCExx(o,FALSE DBG_SRC)
/* <combine sack::sql::PopODBCEx>
   \ \                            */
#define PopODBC() PopODBCExx(NULL,FALSE DBG_SRC)
#endif
/* This terminates a query on the PODBC stack. (It was mentioned
   in pop odbc that it could be used to terminate a query, but
   that will log that a pop is being done without a push. This
   is the proper way to prematurely end a query.)
   Parameters
   odbc :  connection to end a query on.                         */
PSSQL_PROC( void, SQLEndQuery )( PODBC odbc );
// release any open queries on the database... all result
// sets are now invalid... uhmm what about things like fields?
// could be messy...
PSSQL_PROC( void, ReleaseODBC )( PODBC odbc );
// does a query responce kinda thing returning types.
// if( GetSQLTypes() ) while( GetSQLResult( &result ) && result )
PSSQL_PROC( int, GetSQLTypes )( void );
#ifndef SQLPROXY_INCLUDE
/* parse the string passed as a date/time as returned from a
   MySQL database.
   Parameters
   date :    string to parse
   year :    pointer to an int that will receive the year portion
             of the date
   month :   pointer to an int that will receive the month
             portion of the date
   day :     pointer to an int that will receive the day portion
             of the date
   hour :    pointer to an int that will receive the hours
             portion of the date
   minute :  pointer to an int that will receive the minutes
             portion of the date
   second :  pointer to an int that will receive the second
             portion of the date
   msec :    pointer to an int that will receive the milli\-second
             portion of the date
   nsec :    pointer to an int that will receive the nano second portion
             of the date                                                 */
PSSQL_PROC( void, ConvertSQLDateEx )( CTEXTSTR date
												  , int *year, int *month, int *day
												  , int *hour, int *minute, int *second
												  , int *msec, int32_t *nsec
												  , int *zone_hr, int *zone_mn
												  );
#endif
/* <combine sack::sql::ConvertSQLDateEx@CTEXTSTR@int *@int *@int *@int *@int *@int *@int *@int32_t *>
   \ \                                                                                             */
#define ConvertSQLDate( date, y,m,d) ConvertSQLDateEx( date,y,m,d,NULL,NULL,NULL,NULL,NULL)
/* <combine sack::sql::ConvertSQLDateEx@CTEXTSTR@int *@int *@int *@int *@int *@int *@int *@int32_t *>
   \ \                                                                                             */
#define ConvertSQLDateTime( date, y,mo,d,h,mn,s) ConvertSQLDateEx( date,y,mo,d,h,mn,s,NULL,NULL)
//------------------------------
// this set of functions will auto create a suitable name table
// providing table_name_id and table_name_name as the columns to query by standard
// previous defaults where "id" and "name" which results in inability to use natural join
//
PSSQL_PROC( INDEX, FetchSQLNameID )( PODBC odbc, CTEXTSTR table_name, CTEXTSTR name );
/* A specialized function which takes a name, looks in a SQL
   table on the default database connection for in column
   'name', and returns the value in the 'ID' column. This
   function may create a table with the required fields. This
   table is very bad, if you have 3 tables all with the same
   'name' column reverse engineering and natural join clauses
   fail.
   Parameters
   table_name :  name of the table to get the name's ID from.
   name :        name to lookup its ID for.
   Returns
   the ID of the name or INVALID_INDEX if not found.          */
PSSQL_PROC( INDEX, GetSQLNameID )( CTEXTSTR table_name, CTEXTSTR name );
/* Still a bad function to use.... just don't.
   Parameters
   odbc :        _nt_
   table_name :  _nt_
   iName :       _nt_                          */
PSSQL_PROC( CTEXTSTR, FetchSQLName )( PODBC odbc, CTEXTSTR table_name, INDEX iName );
/* A specialized function which takes an ID, looks in a SQL
   table on the default database connection for in column 'ID',
   and returns the value in the 'name' column. This function may
   create a table with the required fields. This table is very
   bad, if you have 3 tables all with the same 'name' column
   reverse engineering and natural join clauses fail.
   Parameters
   table_name :  name of the database table to read from
   iName :       ID of the name to get                           */
PSSQL_PROC( CTEXTSTR, GetSQLName )( CTEXTSTR table_name, INDEX iName );
/* <combine sack::sql::SQLReadNameTableExEx@PODBC@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@int bCreate>
   \ \
   Note
   If database connection is not specified or is NULL, uses the
   default SQL connection.                                                                         */
PSSQL_PROC( INDEX, ReadNameTableExEx)( CTEXTSTR name, CTEXTSTR table, CTEXTSTR col, CTEXTSTR namecol, int bCreate DBG_PASS );
/* <combine sack::sql::ReadNameTableExEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@int bCreate>
   \ \                                                                                    */
#define ReadNameTableExx( name,table,col,namecol,bCreate) ReadNameTableExEx( name,table,col,namecol,bCreate DBG_SRC )
//column name if NOT specified will be 'ID'
PSSQL_PROC( INDEX, ReadNameTableEx)( CTEXTSTR name, CTEXTSTR table, CTEXTSTR col DBG_PASS );
/* <combine sack::sql::ReadNameTableExEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@int bCreate>
   \ \                                                                                    */
#define ReadNameTable(n,t,c) ReadNameTableExEx( n,t,c, "name",TRUE DBG_SRC )
/* <combine sack::sql::ReadFromNameTableExEx@INDEX@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR *result>
   \ \                                                                                          */
PSSQL_PROC( int, ReadFromNameTableEx )( INDEX id, CTEXTSTR table, CTEXTSTR id_colname, CTEXTSTR name_colname, CTEXTSTR *result DBG_PASS);
/* TRUE if name in result... again if !colname colname = 'ID'
   Parameters
   odbc :       connection to use
   id :         ID of the name to read
   table :      table to read from
   id_column :  name of the column that contains the ID
   colname :    name of the column that is where the name is
   result\ :    pointer to a CTEXTSTR which will be filled with
                the name in the table                           */
PSSQL_PROC( int, ReadFromNameTableExEx )( INDEX id, CTEXTSTR table, CTEXTSTR id_column, CTEXTSTR colname, CTEXTSTR *result DBG_PASS);
/* <combine sack::sql::ReadFromNameTableExEx@INDEX@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR *result>
   \ \                                                                                          */
#define ReadFromNameTableExx(id,t,ic,nc,r) ReadFromNameTableExEx(id,t,ic,nc,r DBG_SRC )
/* <combine sack::sql::ReadFromNameTableEx@INDEX@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR *result>
   \ \                                                                                        */
#define ReadFromNameTable(id,t,c,r) ReadFromNameTableEx(id,t,c,"name",r DBG_SRC )
/* This is a better name resolution function. It will also
   create a table that contains the required columns, but the
   column names may be more intelligent than 'ID' and 'name'.
   Parameters
   odbc :     database connection to read from
   name :     the name to lookup the ID for
   table :    table the name column is in
   col :      name of the key column(s) to read.
   namecol :  name of column containing the name to lookup.
   bCreate :  if TRUE, will insert the name into the table, and
              return the resulting columns.                     */
PSSQL_PROC( TEXTSTR, SQLReadNameTableKeyExEx)( PODBC odbc, CTEXTSTR name, CTEXTSTR table, CTEXTSTR col, CTEXTSTR namecol, int bCreate DBG_PASS );
/* This is a better name resolution function. It will also
   create a table that contains the required columns, but the
   column names may be more intelligent than 'ID' and 'name'.
   Parameters
   odbc :     database connection to read from
   name :     the name to lookup the ID for
   table :    table the name column is in
   col :      name of the key column(s) to read.
   namecol :  name of column containing the name to lookup.
   bCreate :  if TRUE, will insert the name into the table, and
              return the resulting columns.                     */
PSSQL_PROC( INDEX, SQLReadNameTableExEx)( PODBC odbc, CTEXTSTR name, CTEXTSTR table, CTEXTSTR col, CTEXTSTR namecol, int bCreate DBG_PASS );
/* <combine sack::sql::SQLReadNameTableExEx@PODBC@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@int bCreate>
   \ \                                                                                             */
#define SQLReadNameTableExx( odbc,name,table,col,namecol,bCreate) SQLReadNameTableExEx( odbc,name,table,col,namecol,bCreate DBG_SRC )
/* <combine sack::sql::SQLReadNameTableExEx@PODBC@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@int bCreate>
   \ \                                                                                             */
#define SQLReadNameTable(o,n,t,c) SQLReadNameTableExEx( o,n,t,c,"name",TRUE DBG_SRC )
/* Reads a table that's assumed to be a primary key ID and a
   name sort of dictionary table. This also maintains an
   \internal cache of names queried, since it is assumed words
   in a dictionary don't move or change.
   Parameters
   odbc :      odbc connection to use
   name :      name to get the index of
   table :     table to get the index from
   col :       column name of the ID columns (macros allow this to
               be defaulted)
   namecol :   column name of the name column (macros allow this to
               be defaulted)
   bCreate :   If the name doesn't exist, setting this to TRUE will
               insert the new name, else return will be
               INVALID_INDEX.
   bQuote :    Indicates if the name should be quoted (else use no
               quotes)
   DBG_PASS :  _nt_                                                 */
PSSQL_PROC( INDEX, GetNameIndexExtended)( PODBC odbc, CTEXTSTR name, CTEXTSTR table, CTEXTSTR col, CTEXTSTR namecol, int bCreate, int bQuote DBG_PASS );
/* <combine sack::sql::GetNameIndexExtended@PODBC@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@int@int bQuote>
   \ \                                                                                                */
PSSQL_PROC( INDEX, GetNameIndexExx)( PODBC odbc, CTEXTSTR name, CTEXTSTR table, CTEXTSTR col, CTEXTSTR namecol, int bCreate DBG_PASS );
/* <combine sack::sql::GetNameIndexExx@PODBC@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@int bCreate>
   \ \                                                                                        */
#define GetNameIndexEx( odbc,name,table,col,namecol,bCreate) GetNameIndexExx( odbc,name,table,col,namecol,bCreate DBG_SRC )
/* <combine sack::sql::GetNameIndexExx@PODBC@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@int bCreate>
   \ \                                                                                        */
#define GetNameIndex(o,n,t,c) GetNameIndexExx( o,n,t,c,"name",TRUE DBG_SRC )
// table and col are not used if a MySQL backend is used...
// they are needed to get the last ID from a postgresql backend.
PSSQL_PROC( INDEX, GetLastInsertIDEx)( CTEXTSTR table, CTEXTSTR col DBG_PASS );
/* <combine sack::sql::GetLastInsertIDEx@CTEXTSTR@CTEXTSTR col>
   \ \                                                          */
#define GetLastInsertID(t,c) GetLastInsertIDEx(t,c DBG_SRC )
/* Gets the ID of the primary key from the prior insert. This
   value can be used in subsequent inserts to relate detail
   records to a master.
   Parameters
   odbc :    database connection
   table :   if NULL, just get's the connection's last insert
             into whatever table. PostgreSQL requires a table
             name and column name to get the last insert for. So,
             proper portability for certain databases may use
             this parameter.
   column :  if NULL, just get's the connection's last insert id
             from the auto increment primary key. PostgreSQL
             requires a table name and column name to get the
             last insert for. So, proper portability for certain
             databases may use this parameter.
   Returns
   a 64 bit row identifier.                                       */
PSSQL_PROC( INDEX, FetchLastInsertIDEx)( PODBC odbc, CTEXTSTR table, CTEXTSTR col DBG_PASS );
/* <combine sack::sql::FetchLastInsertIDEx@PODBC@CTEXTSTR@CTEXTSTR col>
   \ \                                                                  */
#define FetchLastInsertID(o,t,c) FetchLastInsertIDEx(o,t,c DBG_SRC )
/* <combine sack::sql::FetchLastInsertIDEx@PODBC@CTEXTSTR@CTEXTSTR col>
   \ \                                                                  */
#define FetchLastInsertKey(o,t,c) FetchLastInsertKeyEx(o,t,c DBG_SRC )
/* <combine sack::sql::FetchLastInsertIDEx@PODBC@CTEXTSTR@CTEXTSTR col>
   \ \                                                                  */
PSSQL_PROC( CTEXTSTR, FetchLastInsertKeyEx)( PODBC odbc, CTEXTSTR table, CTEXTSTR col DBG_PASS );
/* <combine sack::sql::GetLastInsertIDEx@CTEXTSTR@CTEXTSTR col>
   \ \                                                          */
PSSQL_PROC( CTEXTSTR, GetLastInsertKeyEx)( CTEXTSTR table, CTEXTSTR col DBG_PASS );
/* <combine sack::sql::GetLastInsertIDEx@CTEXTSTR@CTEXTSTR col>
   \ \                                                          */
#define GetLastInsertKey(t,c) GetLastInsertKeyEx(t,c DBG_SRC )
// CreateTable Options (CTO_)
enum CreateTableOptions {
   // drop old table before create.
 CTO_DROP  = 1,
  // attempt to figure out alter statements to drop or add columns to exact match definition
 CTO_MATCH = 4,
  // attempt to figure out alter statements to add missing columns, do not drop.  Rename?
 CTO_MERGE = 8,
 // log changes to "changes.sql"
		CTO_LOG_CHANGES = 16
};
/* \ \
   Parameters
   odbc :          database connection to check table in
   filename :      name of file containing sql CREATE TABLE
                   statements.
   templatename :  name of the table specified by the CREATE
                   TABLE statement.
   tablename :     table name to use when actually creating this.
                   May be different from template table name.
   options :       Options from CreateTableOptions.               */
PSSQL_PROC( int, SQLCreateTableEx )(PODBC odbc, CTEXTSTR filename, CTEXTSTR templatename, CTEXTSTR tablename, uint32_t options );
/* <combine sack::sql::SQLCreateTableEx@PODBC@CTEXTSTR@CTEXTSTR@CTEXTSTR@uint32_t>
   \ \                                                                        */
#define SQLCreateTable( odbc, file, table ) SQLCreateTableEx(odbc,file,table,table,0)
/* Creates a table in a database by reading an external file
   containing the table definition. It can also perform
   iterative updates to table structure if the template
   definition adds or deletes columns.
   Parameters
   filename :      filename to read the template from
   templatename :  name of the table in the create table template
                   statement.
   tablename :     the name of the table to create (may be
                   different than template)
   options :       Options from CreateTableOptions.
   Returns
   TRUE if success.
   FALSE if failure. (No further information)                     */
PSSQL_PROC( int, CreateTableEx )( CTEXTSTR filename, CTEXTSTR templatename, CTEXTSTR tablename, uint32_t options );
/* <combine sack::sql::CreateTableEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@uint32_t>
   \ \                                                               */
#define CreateTable( file, table ) CreateTableEx(file,table,table,0)
// results in a static buffer with escapes filled in for characterws
// which would otherwise conflict with string punctuators.
PSSQL_PROC( TEXTSTR ,EscapeStringEx )( CTEXTSTR name DBG_PASS );
/* <combine sack::sql::EscapeStringEx@CTEXTSTR name>
   \ \                                               */
#define EscapeString(s) EscapeStringEx( s DBG_SRC )
/* <combine sack::sql::EscapeStringEx@CTEXTSTR name>
   \ \                                               */
#define EscapeStringOpt(s,q) EscapeSQLBinaryExx( NULL,s,StrLen(s),NULL, q DBG_SRC )
/* \ \
   Parameters
   odbc :  connection to escape the string appropriately for. Different
           database engines require different string escapes.
   name :  string to escape
   Returns
   a TEXTSTR that is the content of the string passed properly
   escaped.
   it is appropriate to Release( result );
   Example
   This is difficult to describe coorectly, since in C, you have
   to do escaping on the parameters anyhow....
   <code lang="c++">
   {
       TEXTSTR result = EscapeSQLString( "\\"test \\'escape\\'" );
       printf( "original : %s\\n"
               "result   : %s\\n"
             , "\\"test \\'escape\\'"
             , \result );
   }
   </code>
   \Output
   <code lang="c++">
   original : "test 'escape'
   \result   : \\"test \\'escape\\'
   </code>                                                              */
PSSQL_PROC( TEXTCHAR *,EscapeSQLStringEx )( PODBC odbc, CTEXTSTR name DBG_PASS );
/* <combine sack::sql::EscapeSQLStringEx@PODBC@CTEXTSTR name>
   \ \                                                        */
#define EscapeSQLString(odbc, s) EscapeSQLStringEx( odbc, s DBG_SRC )
// the following functions return an allcoated buffer which the application must Release()
PSSQL_PROC( TEXTSTR ,EscapeBinaryEx )( CTEXTSTR blob, uintptr_t bloblen DBG_PASS );
/* <combine sack::sql::EscapeBinaryEx@CTEXTSTR@uintptr_t bloblen>
   \ \                                                           */
#define EscapeBinary(b,bl) EscapeBinaryEx(b,bl DBG_SRC )
/* <combine sack::sql::EscapeBinaryEx@CTEXTSTR@uintptr_t bloblen>
   \ \                                                           */
#define EscapeBinaryOpt(b,bl,q) EscapeSQLBinaryExx(NULL,b,bl,NULL,q DBG_SRC )
/* <combine sack::sql::EscapeBinaryEx@CTEXTSTR@uintptr_t bloblen>
   \ \                                                           */
PSSQL_PROC( TEXTSTR,EscapeSQLBinaryExx )( PODBC odbc, CTEXTSTR blob, size_t bloblen, size_t *resultLen, LOGICAL bQuote DBG_PASS );
/* <combine sack::sql::EscapeBinaryEx@CTEXTSTR@uintptr_t bloblen>
   \ \                                                           */
//PSSQL_PROC( TEXTSTR,EscapeSQLBinaryEx )( PODBC odbc, CTEXTSTR blob, uintptr_t bloblen DBG_PASS );
/* <combine sack::sql::EscapeSQLBinaryEx@PODBC@CTEXTSTR@uintptr_t bloblen>
   \ \                                                                    */
#define EscapeSQLBinary(odbc,blob,len) EscapeSQLBinaryExx( odbc,blob,len, NULL, FALSE DBG_SRC )
/* <combine sack::sql::EscapeSQLBinaryEx@PODBC@CTEXTSTR@uintptr_t bloblen>
   \ \                                                                    */
#define EscapeSQLBinaryOpt(odbc,blob,len,q) EscapeSQLBinaryExx( odbc,blob,len,NULL,q DBG_SRC )
#define EscapeSQLBinaryLen(odbc,blob,len,resLen,q) EscapeSQLBinaryExx( odbc,blob,len,resLen, q DBG_SRC )
/* Remove escape sequences which are inserted into a text
   string. (for things like quotes and binary characters?)
   Parameters
   name :  string to remove string escapes from
   Returns
   a copy of the string without quotes. This result should be
   freed with Release when user is done with it.              */
PSSQL_PROC( TEXTSTR ,RevertEscapeString )( CTEXTSTR name );
/* Remove escape sequences which are inserted into a binary
   string.
   Parameters
   blob :     pointer to data to remove binary escape sequences
              from
   bloblen :  length of the data block to handle
   Returns
   a pointer to the string without escapes. (Even though it says
   binary, it's still to and from text?) This result should be
   freed with Release when user is done with it.                 */
PSSQL_PROC( TEXTSTR ,RevertEscapeBinary )( CTEXTSTR blob, size_t *bloblen );
/* Parse a Blob string stored as hex... that is text character
   0-9 and A-F.
   Parameters
   blob :    pointer to the string containing the blob string
   buffer :  target buffer for data
   buflen :  length of target buffer                           */
PSSQL_PROC( TEXTSTR , DeblobifyString )( CTEXTSTR blob, TEXTSTR buffer, size_t buflen );
/* parse the string passed as a date/time as returned from a
   MySQL database.
   Parameters
   timestring :     string to parse
   endtimestring :  pointer to a pointer to a string to receive
                    the position of the character after the
                    timestring.
   year :           pointer to an int that will receive the year
                    portion of the date
   month :          pointer to an int that will receive the month
                    portion of the date
   day :            pointer to an int that will receive the day
                    portion of the date
   hour :           pointer to an int that will receive the hours
                    portion of the date
   minute :         pointer to an int that will receive the
                    minutes portion of the date
   second :         pointer to an int that will receive the
                    second portion of the date
   Returns
   A true/false status whether the string passed was a valid
   time string (?).                                               */
PSSQL_PROC( int, ConvertDBTimeString )( CTEXTSTR timestring
                                      , CTEXTSTR *endtimestring
                                      , int *pyr, int *pmo, int *pdy
                                      , int *phr, int *pmn, int *psc );
#ifndef SQLPROXY_INCLUDE
/* Issue a command to a SQL database. Things like Update and
   Insert are commands.
   Parameters
   odbc :     database connection to perform the command on. If
              NULL uses the default global connection.
   command :  text string to send to the database to execute.
   Returns
   TRUE if the statement succeeds.
   FALSE if the statement fails. See FetchSQLError.             */
PSSQL_PROC( int, SQLCommandEx )( PODBC odbc, CTEXTSTR command DBG_PASS);
#endif
PSSQL_PROC( int, SQLCommandExx )(PODBC odbc, CTEXTSTR command, size_t commandLen DBG_PASS);
/* <combine sack::sql::SQLCommandEx@PODBC@CTEXTSTR command>
   \ \                                                      */
#define SQLCommand(o,c) SQLCommandEx(o,c DBG_SRC )
#define SQLCommandLen(o,c,len) SQLCommandExx(o,c,len DBG_SRC )
   /* Begin collecting insert statements for batch output.
   Parameters
   odbc :  database connection to start collecting inserts for */
PSSQL_PROC( int, SQLInsertBegin )( PODBC odbc );
/* Generate a SQL insert statement from a variable parameter
   list.
   Parameters
   odbc :   connection to generate an insert on
   table :  table to insert into
   args :   a list of fields.
   Remarks
   args each column is a set of 3 parameters; the first
   parameter is the name of the column to insert into, the
   second is a value 0 or 1 whether to quote the value or not,
   and a string pointer.
   Inserts may be batched together and flushed as a whole to the
   database connection.                                          */
PSSQL_PROC( int, vSQLInsert )( PODBC odbc, CTEXTSTR table, va_list args );
/* Generate an insert to the database. Inserts to a single table
   can be cached internally and flushed.
   Parameters
   odbc :   database connection to use
   table :  name of table to insert into
   ... :    sets of column paramters.                            */
PSSQL_PROC( int, SQLInsert )( PODBC odbc, CTEXTSTR table, ... );
PSSQL_PROC( int, DoSQLInsert )( CTEXTSTR table, ... );
/* Flushes all cached inserts collected on a database
   connection.
   Parameters
   odbc :  database connection to flush inserts       */
PSSQL_PROC( int, SQLInsertFlush )( PODBC odbc );
/* This was the original implementation, it returned the results
   as a comma separated list, with quotes around results that
   had commas in them, and quotes around empty strings to
   distinguish NULL result which is just ',,'.
   Parameters
   odbc :     database connection to do the query
   query :    the string query to do
   result\ :  address of a CTEXTSTR to get a comma seperated
              \result of the query in.
   Returns
   TRUE if the query succeeded
   FALSE if the query was in error. See FetchSQLError.
   Example
   <code lang="c++">
   PODBC odbc = NULL; // just use the default connection...
   CTEXTSTR result;
   DoSQLQuery( odbc, "select 1,2,3", &amp;result );
   printf( "result : %s" );
   </code>
   \Output
   <code lang="c++">
   \result : 1,2,3
   </code>
   See Also
   SQLRecordQuery                                                */
PSSQL_PROC( int, SQLQueryEx )( PODBC odbc, CTEXTSTR query, CTEXTSTR *result DBG_PASS);
/* <combine sack::sql::SQLQueryEx@PODBC@CTEXTSTR@CTEXTSTR *result>
   \ \                                                             */
#define SQLQuery(o,q,r) SQLQueryEx( o,q,r DBG_SRC )
/* <combine sack::sql::DoSQLRecordQueryf@int *@CTEXTSTR **@CTEXTSTR **@CTEXTSTR@...>
   \ \                                                                               */
PSSQL_PROC( int, SQLRecordQueryEx )( PODBC odbc
                                   , CTEXTSTR query
                                   , int *pnResult
                                   , CTEXTSTR **result
                                   , CTEXTSTR **fields DBG_PASS);
/* Do a SQL query on the default odbc connection. The first
   record results immediately if there are any records. Returns
   the results as an array of strings. If you know the select
   you are using .... "select a,b,c from xyz" then you know that
   this will have 3 columns resulting.
   Parameters
   odbc :     connection to do the query on.
   query :    query to execute.
   queryLength : actual length of the query (allows embedded NUL characters)
   PDATALIST* :  pointer to datalist pointer which will contain struct jsox_value_container.
			 for each result in this list until VALUE_UNDEFINED is used.
		.name is the field name (constant)
		.string is the text, value_type is the value type (so numbers can stay numbers)
	pdlParams : parameters to bind to the query.  (struct json_value_container types)
   Example
   See SQLRecordQueryf, but omit the database parameter.         */
PSSQL_PROC( int, SQLRecordQuery_js )( PODBC odbc
	, CTEXTSTR query
	, size_t queryLen
	, PDATALIST *pdlResults
	, PDATALIST pdlParams
	DBG_PASS );
/*
	this properly releases the list and all allocated strings within the entires
 */
PSSQL_PROC( void, ReleaseSQLResults )( PDATALIST *ppdlResults );
/* Do a SQL query on the default odbc connection. The first
   record results immediately if there are any records. Returns
   the results as an array of strings. If you know the select
   you are using .... "select a,b,c from xyz" then you know that
   this will have 3 columns resulting.
   Parameters
   odbc :     connection to do the query on.
   query :    query to execute.
   queryLength : actual length of the query (allows embedded NUL characters)
   columns :  pointer to an int to receive the number of columns
              in the result. (the user will know this based on
              the query issued usually, so it can be NULL to
              ignore parameter)
   result\ :  pointer to a pointer to strings... see example
   resultLengths : pointer to a size_t* that will contain an array of
              lengths of the result values.
   fields :   address of a pointer to strings which will get the
              field names
   Example
   See SQLRecordQueryf, but omit the database parameter.         */
PSSQL_PROC( int, SQLRecordQuery_v4 )( PODBC odbc
                                   , CTEXTSTR query
                                   , size_t queryLength
                                   , int *pnResult
                                   , CTEXTSTR **result
                                   , size_t **resultLengths
                                   , CTEXTSTR **fields
                                   , PDATALIST pdlParameters
                                   DBG_PASS);
/* <combine sack::sql::SQLRecordQueryEx@PODBC@CTEXTSTR@int *@CTEXTSTR **@CTEXTSTR **fields>
   \ \                                                                                      */
#define SQLRecordQuery(o,q,prn,r,f) SQLRecordQueryEx( o,q,prn,r,f DBG_SRC )
/* <combine sack::sql::SQLRecordQueryExx@PODBC@CTEXTSTR@size_t@int *@CTEXTSTR **@size_t *@CTEXTSTR **fields>
   \ \                                                                                      */
#if defined _DEBUG || defined _DEBUG_INFO
#  define SQLRecordQueryLen(o,q,ql,prn,r,rl,f) SQLRecordQueryExx( o,q,ql,prn,r,rl,f, __FILE__,__LINE__ )
#  define SQLRecordQueryExx(o,q,ql,ppr,res,reslen,fields ,file,line )  SQLRecordQuery_v4(o,q,ql,ppr,res,reslen,fields,NULL ,file,line )
#else
#  define SQLRecordQueryLen(o,q,ql,prn,r,rl,f) SQLRecordQueryExx( o,q,ql,prn,r,rl,f  )
#  define SQLRecordQueryExx(o,q,ql,ppr,res,reslen,fields )  SQLRecordQuery_v4(o,q,ql,ppr,res,reslen,fields,NULL )
#endif
   /* Gets the next result from a query.
   Parameters
   odbc :     database connection that the query was executed on
   result\ :  address of the result variable.
   Example
   See SQLRecordQueryf.                                          */
PSSQL_PROC( int, FetchSQLResult )( PODBC, CTEXTSTR *result );
/* Gets the next record result from the connection.
   Parameters
   odbc :     connection to get the result from; if NULL, uses
              \internal static connection.
   result\ :  address of a CTEXTSTR *; to set to an array of
              CTEXTSTR results.
   Remarks
   Values received are invalid after the next FetchSQLRecord or
   possibly other query.                                        */
PSSQL_PROC( int, FetchSQLRecord )( PODBC, CTEXTSTR **result );
/* Gets the next record result from the connection.
   Parameters
   odbc :     connection to get the result from; if NULL, uses
			  \internal static connection.
   result\ :  (unchanged; is same list as original)
   Remarks
   Values received are invalid after the next FetchSQLRecord or
   possibly other query.                                        */
PSSQL_PROC( int, FetchSQLRecordJS )(PODBC odbc, PDATALIST *ppdlRecord);
/* Gets the last result on the specified ODBC connection.
   Parameters
   odbc :     connection to get the last error of
   result\ :  address of a string pointer to receive the error
              \result.
   Example
   <code lang="c++">
   {
      CTEXTSTR error;
      FetchSQLError( NULL, &amp;error );
   </code>
   <code>
      printf( "Error: %s", error );
   </code>
   <code lang="c++">
   }
   </code>                                                     */
PSSQL_PROC( int, FetchSQLError )( PODBC, CTEXTSTR *result );
#ifndef SQLPROXY_INCLUDE
/* Test if a database connection is open
   Parameters
   odbc :  database connection to check
   Returns
   TRUE if the connection is open and works.
   FALSE if the connection would not work because it is not
   connected.                                               */
PSSQL_PROC( int, IsSQLOpenEx )( PODBC DBG_PASS );
/* Test if a database connection is open
   Parameters
   odbc :  database connection to check
   Returns
   TRUE if the connection is open and works.
   FALSE if the connection would not work because it is not
   connected.                                               */
PSSQL_PROC( int, IsSQLOpen )( PODBC );
/* <combine sack::sql::IsSQLOpenEx@PODBC>
   \ \                                    */
#define IsSQLOpen(odbc) IsSQLOpenEx(odbc DBG_SRC )
/* An PODBC connection handles commands as a stack, this saves
   the current query state (that you want to still get results
   from), so you can start a new query within the outer query.
   Parameters
   odbc :  database connection to save the current query state. */
PSSQL_PROC( int, PushSQLQueryExEx )(PODBC DBG_PASS);
PSSQL_PROC( int, PushSQLQueryEx )(PODBC);
/* <combine sack::sql::PushSQLQueryExEx@PODBC>
   \ \                                         */
#define PushSQLQueryEx(odbc) PushSQLQueryExEx(odbc DBG_SRC )
// no application support for username/password, sorry, trust thy odbc layer, please
PSSQL_PROC( PODBC, ConnectToDatabase )( CTEXTSTR dsn );
// get a connection to a database by name.
PSSQL_PROC( PODBC, SQLGetODBC )( CTEXTSTR dsn );
// get a connection to the database specifying user and password.
PSSQL_PROC( PODBC, SQLGetODBCEx )( CTEXTSTR dsn, CTEXTSTR user, CTEXTSTR pass );
// drop an interface (no longer in use/close); these are in a pool, and the underlaying connection might not close.
PSSQL_PROC( void, SQLDropODBC )( PODBC odbc );
// Drop the odbc instance, and close the connection.
PSSQL_PROC( void, SQLDropAndCloseODBC )( CTEXTSTR dsn );
#endif
// default parameter to require is the global flag RequireConnection from sql.config....
PSSQL_PROC( PODBC, ConnectToDatabaseExx )( CTEXTSTR DSN, LOGICAL bRequireConnection DBG_PASS );
// default parameter to require is the global flag RequireConnection from sql.config....
// the require connection parameter indicates the connection must connect, and will block until connected.
PSSQL_PROC( PODBC, ConnectToDatabaseEx )( CTEXTSTR DSN, LOGICAL bRequireConnection );
// default parameter to require is the global flag RequireConnection from sql.config....
#define ConnectToDatabaseEx( dsn, required ) ConnectToDatabaseExx( dsn, required DBG_SRC )
// default parameter to require is the global flag RequireConnection from sql.config....
#define ConnectToDatabase( dsn ) ConnectToDatabaseExx( dsn, FALSE DBG_SRC )
// Extended connect to database function; provides user and password separate from the DSN
// which allows logging the SQL connection name, without dumping the username ans password.
// adds onOpen Callback, which, especially on reconnection, triggers a callback to condition
// the connection (issue pragmas, setup database options).
PSSQL_PROC( PODBC, ConnectToDatabaseLoginCallback)( CTEXTSTR DSN, CTEXTSTR user, CTEXTSTR pass, LOGICAL bRequireConnection
			, void (*onOpen)(uintptr_t,PODBC), uintptr_t psv DBG_PASS );
/* Close a database connection. Releases all resources
   associated with the odbc connection.
   Parameters
   odbc :  connection to database to close. Should not be NULL.  */
PSSQL_PROC( void, CloseDatabase)(PODBC odbc );
// does a query responce kinda thing returning types.
// if( GetSQLTypes() ) while( GetSQLResult( &result ) && result )
PSSQL_PROC( int, GetSQLTypes )( void );
/* ODBC only (sqlite no support?). Gets the types of data that
   the ODBC connection supports.
   Parameters
   odbc :  database connection to get the types from.
   Example
   <code>
   PODBC odbc = NULL; // or do a ConnectToDatabsae
   CTEXTSTR result; // the singular line result
   if( FetchSQLTypes(odbc) )
       while( FetchSQLResult( &amp;result ) &amp;&amp; result )
       {
           printf( "Supported Type: %s\\n", result );
       }
   </code>
   <code lang="c++">
   if( GetSQLTypes() )
       while( GetSQLResult( &amp;result ) &amp;&amp; result )
   </code>
   <code>
       {
           printf( "Supported Type: %s\\n", result );
       }
   </code>                                                      */
PSSQL_PROC( int, FetchSQLTypes )( PODBC );
#define PSSQL_VARARG_PROC(a,b,c)  PSSQL_PROC(a,b)c; typedef a(CPROC * __f_##b)c; PSSQL_PROC( __f_##b, __##b )(DBG_VOIDPASS)
/* Do a SQL query on the default odbc connection. The first
   record results immediately if there are any records. Returns
   the results as an array of strings. If you know the select
   you are using .... "select a,b,c from xyz" then you know that
   this will have 3 columns resulting.
   Parameters
   columns :  pointer to an int to receive the number of columns
              in the result. (the user will know this based on
              the query issued usually, so it can be NULL to
              ignore parameter)
   result\ :  pointer to a pointer to strings... see example
   fields :   address of a pointer to strings which will get the
              field names
   fmt :      format string as is appropriate for vsnprintf
   .... :     extra arguments to pass to format string
   Example
   See SQLRecordQueryf, but omit the database parameter.         */
PSSQL_VARARG_PROC( int, DoSQLRecordQueryf ,( int *columns, CTEXTSTR **result, CTEXTSTR **fields, CTEXTSTR fmt, ... ) );
#define DoSQLRecordQueryf   (__DoSQLRecordQueryf( DBG_VOIDSRC ))
/* <combine sack::sql::SQLQueryf@PODBC@CTEXTSTR *@CTEXTSTR@...>
   \ \                                                          */
PSSQL_VARARG_PROC( int, DoSQLQueryf, ( CTEXTSTR *result, CTEXTSTR fmt, ... ) );
#define DoSQLQueryf   (__DoSQLQueryf( DBG_VOIDSRC ))
/* This does a command to the database as a formatted command.
   This allows the user to simply specify the command and
   \parameters, and not also maintain a buffer to build the
   string into before passing the string to the ODBC connection
   as a command.
   Parameters
   fmt :  format string appropriate for vsnprintf. ... \: extra
          \parameters to fill the format string.
   See Also
   SQLCommandf
   Returns
   TRUE if command success, else FALSE.
   if FALSE, can get the error from GetSQLError.
	*/
PSSQL_VARARG_PROC( int, DoSQLCommandf, ( CTEXTSTR fmt, ... ) );
#define DoSQLCommandf   (__DoSQLCommandf( DBG_VOIDSRC ))
/* Do a SQL query on the default odbc connection. The first
   record results immediately if there are any records. Returns
   the results as an array of strings. If you know the select
   you are using .... "select a,b,c from xyz" then you know that
   this will have 3 columns resulting.
   Parameters
   odbc :     database connection to perform the query on
   columns :  pointer to an int to receive the number of columns
              in the result. (the user will know this based on
              the query issued usually, so it can be NULL to
              ignore parameter)
   result\ :  pointer to a pointer to strings... see example
   fields :   address of a pointer to strings which will get the
              field names. May be ommited if you don't want to
              know the names. (is less work internally if this is
              not built).
   fmt :      format string as is appropriate for vsnprintf
   .... :     extra arguments to pass to format string
   Example
   <code lang="c++">
   PODBC odbc = ConnectToDatabase( "MySQL" );
   CTEXTSTR *results;
   CTEXTSTR *column_names;
   int columns;
   for( SQLRecordQueryf( odbc, &amp;columns, &amp;results, &amp;column_names
                       , "select a,b,c from %s where %s=%s"
                       , "table_name"
                       , "column_name"
                       , "'value'"
                       );
        results;
        FetchSQLRecord( odbc, &amp;results ) )
   {
      int n;
       // draw a seperator between rows returned
      printf( " ----- record data ----- \\n" );
      for( n = 0; n \< columns; n++ )
      {
         printf( "Result column '%s' = '%s'\\n", column_name[n], results[n] );
      }
   }
   CloseDatabase( odbc );
   </code>
   If the default connection is used, odbc can be NULL in the
   prior example, or the for staement could be
   <code>
   for( DoSQLRecordQueryf( &amp;columns, &amp;results, &amp;column_names
                         , "select a,b,c from %s where %s=%s"
                         , "table_name"
                         , "column_name"
                         , "'value'"
                         );
        results;
        GetSQLRecord( &amp;results ) )
   {
   }
   </code>                                                                     */
//PSSQL_PROC( int, SQLRecordQueryf )( PODBC odbc, int *columns, CTEXTSTR **result, CTEXTSTR **fields, CTEXTSTR fmt, ... );
PSSQL_VARARG_PROC( int, SQLRecordQueryf, ( PODBC odbc, int *columns, CTEXTSTR **result, CTEXTSTR **fields, CTEXTSTR fmt, ... ) );
#define SQLRecordQueryf   (__SQLRecordQueryf( DBG_VOIDSRC ))
PSSQL_VARARG_PROC( int, SQLRecordQueryf_v2, ( PODBC odbc, int *nResults, CTEXTSTR **result, size_t **resultLengths, CTEXTSTR **fields, CTEXTSTR fmt, ... ) );
#define SQLRecordQueryf_v2   (__SQLRecordQueryf_v2( DBG_VOIDSRC ))
/* This was the original implementation, it returned the results
   as a comma separated list, with quotes around results that
   had commas in them, and quotes around empty strings to
   distinguish NULL result which is just ',,'.
   Parameters
   odbc :     database connection to do the query
   result\ :  address of a CTEXTSTR to get a comma seperated
              \result of the query in.
   query :    the string query to do
   ... :      extra parameters for the query format string
   Returns
   TRUE if the query succeeded
   FALSE if the query was in error. See FetchSQLError.
   Example
   <code>
   PODBC odbc = NULL; // just use the default connection...
   CTEXTSTR result;
   DoSQLQueryf( odbc, &amp;result, "select %d,%d,%d", 1, 2, 3 );
   printf( "result : %s" );
   </code>
   \Output
   <code>
   \result : 1,2,3
   </code>
   See Also
   SQLRecordQueryf                                               */
PSSQL_VARARG_PROC( int, SQLQueryf ,( PODBC odbc, CTEXTSTR *result, CTEXTSTR fmt, ... ) );
#define SQLQueryf   (__SQLQueryf( DBG_VOIDSRC ))
/* This performs a command on a SQL connection.
   Parameters
   odbc :  database connection to do the command on
   fmt :   format string as appropriate for vsnprintf
   ... :   extra arguments as required by the format string
   Returns
   TRUE if command success, else FALSE.
   if FALSE, can get the error from FetchSQLError.
                                                            */
PSSQL_VARARG_PROC( int, SQLCommandf, ( PODBC odbc, CTEXTSTR fmt, ... ) );
#define SQLCommandf   (__SQLCommandf( DBG_VOIDSRC ))
/* Function signature for the callback when the SQL layer can
   log a status about a database connection (connection,
   disconnected, failed...) See SQLSetFeedbackHandler.        */
typedef void (CPROC *HandleSQLFeedback)(CTEXTSTR message);
// register a feedback message for startup messages
//  allows external bannering of status... perhaps this can handle failures
//  and disconnects also...
PSSQL_PROC( void, SQLSetFeedbackHandler )( HandleSQLFeedback handler );
/* Parses a CREATE TABLE statement and builds a PTABLE from it.
   Parameters
   cmd :         a CREATE TABLE sql command. It is a little
                 sqlite/mysql centric, and may fail on column
                 types for SQL Server.
   writestate :  if writestate is TRUE, a file called
                 'sparse.txt' will be generated with a C
                 structure of the Create Table statement passed. This
                 \file could then be used to copy into code, and
                 have a code\-static definition instead of going
                 from the create table statement.
   Returns
   a PTABLE which represents the create table statement.              */
PSSQL_PROC( PTABLE, GetFieldsInSQLEx )( CTEXTSTR cmd, int writestate DBG_PASS );
/* <combine sack::sql::GetFieldsInSQLEx@CTEXTSTR@int writestate>
   \ \                                                           */
#define GetFieldsInSQL(c,w) GetFieldsInSQLEx( c, w DBG_SRC )
//PSSQL_PROC( PTABLE, GetFieldsInSQL )( CTEXTSTR cmd, int writestate);
// this is used to destroy the table returned by GetFieldsInSQL
PSSQL_PROC( void, DestroySQLTable )( PTABLE table );
// allow setting and getting of a bit of user data associated with the PODBC...
// though this can result in memory losses at the moment, cause there is no notification
// that the PODBC has gone away, and that the user needs to remove his data...
PSSQL_PROC( uintptr_t, SQLGetUserData )( PODBC odbc );
/* A PODBC may have a user data assigned to it.
   Parameters
   odbc :  connection to set the data for; shouldn't be NULL.
   psv :   user data to assign to the database connection.
   See Also
   SQLGetUserData                                             */
PSSQL_PROC( void, SQLSetUserData )( PODBC odbc, uintptr_t );
/* Returns a text string GUID, the guid is saved in psersistant text space and will
   not be released or overwritten.  */
PSSQL_PROC( CTEXTSTR, GetGUID )( void );
/* Returns a text string GUID, This uses UuidCreateSequential  */
PSSQL_PROC( CTEXTSTR, GetSeqGUID )( void );
/* Returns a text string GUID, the guid is saved in psersistant text space and will
   not be released or overwritten.  This tring is the constant 0 guid */
PSSQL_PROC( CTEXTSTR, GuidZero )( void );
/* convert a string GUID to a binary representation of 16 bytes.
   litte_endian will byte-swap the grouped portions of numbers in a guid so they can be printed appropriately*/
PSSQL_PROC( uint8_t*, GetGUIDBinaryEx )( CTEXTSTR guid, LOGICAL litte_endian );
#define GetGUIDBinary(g) GetGUIDBinaryEx(g, TRUE )
/* structure of a little endian UUID.  This allows formatting into the various
 size fields of a uuid text string.
 */
struct guid_binary {
	union {
		struct {
			uint8_t bytes[16];
			uint8_t zero[2];
		} b;
		struct {
			uint32_t l1;
			uint16_t w1;
			uint16_t w2;
			uint16_t w3;
			uint64_t ll1;
		} d;
	} u;
};
// snprintf( buf, 256, guid_format, guid_param_pass(&guid_binary) )
// snprintf( buf, 256, guid_format, guid_param_pass(binary_buffer_result) )
#define guid_format "%08" _32fx "-%04" _16fx "-%04" _16fx "-%04" _16fx "-%012" _64fx
#define guid_param_pass(n) ((struct guid_binary*)(n))->u.d.l1,((struct guid_binary*)(n))->u.d.w1,((struct guid_binary*)(n))->u.d.w2,((struct guid_binary*)(n))->u.d.w3,((struct guid_binary*)(n))->u.d.ll1
/* some internal stub-proxy linkage for generating remote
   responders..
   This was work in progress for providing a msgsvr service to
   SQL. One of the implementations of this library was across a
   windows message queue using ATOM types to transport results
   and commands. Was going to implement this on the abstract
   msgqueue interface.                                          */
typedef struct responce_tag
{
	struct {
		BIT_FIELD bSingleLine : 1;
		BIT_FIELD bMultiLine : 1;
		BIT_FIELD bFields : 1;
	} flags;
	PVARTEXT result_single_line;
	int nLines;
	CTEXTSTR *pLines;
	CTEXTSTR *pFields;
} SQL_RESPONCE, *PSQL_RESPONCE;
/* *WORK IN PROGRESS* function call signature for callback method passed to
   RegisterResponceHandler.                              */
typedef void (CPROC *result_responder)( int responce
									  , PSQL_RESPONCE result );
/* *WORK IN PROGRESS*
   result_responder :  callback function to get called with sql
                       global status messages.
   See Also
   <link sack::sql::result_responder, Result Responder Type>    */
PSSQL_PROC( void, RegisterResponceHandler )( result_responder );
/* Thread protect means to use critical sections to protect this
   connection against multiple thread access. Recommended usage
   is to not use a PODBC with more than one thread in the first
   place.
   Parameters
   odbc :     connection to enable; if null, references the
              \internal static connection.
   bEnable :  TRUE to enable, FALSE to disable.                  */
PSSQL_PROC( void, SetSQLThreadProtect )( PODBC odbc, LOGICAL bEnable );
/* Enable using 'BEGIN TRANSACTION' and 'COMMIT' commands automatically
   around commands. If there is a lull of 500ms (1/2 second),
   then the commit automatically fires. SQLCommit can be called
   to trigger this process early.
   Parameters
   odbc :     connection to set auto transact on
   bEnable :  TRUE to enable, FALSE to disable.                         */
PSSQL_PROC( void, SetSQLAutoTransact )( PODBC odbc, LOGICAL bEnable );
/* Enable using 'BEGIN TRANSACTION' and 'COMMIT' commands automatically
   around commands. If there is a lull of 500ms (1/2 second),
   then the commit automatically fires. SQLCommit can be called
	to trigger this process early.
	if Callback is set, automatically enables AutoTransact
   if Callback is NULL, automatically clears AutoTransact
   Parameters
   odbc :     connection to set auto transact on
   callback :  not NULL to enable, NULL to disable.                         */
PSSQL_PROC( void, SetSQLAutoTransactCallback )( PODBC odbc, void (CPROC*callback)(uintptr_t,PODBC), uintptr_t psv );
/* Relevant for SQLite databases. After a certain period of
   inactivity the database is closed (allowing the file to be
   not-in-use during idle). PODBC odject remains valid, and
   connection to database is re-enabled on next usage.
   Parameters
   odbc :     connection to enable auto close behavior on
   bEnable :  TRUE to enable auto close FALSE to disable.     */
PSSQL_PROC( void, SetSQLAutoClose )( PODBC odbc, LOGICAL bEnable );
/* Relevant for SQLite databases. After a certain period of
   inactivity the database is issued a PRAGMA wal_checkpoint
   Parameters
   odbc :     connection to enable auto checkpoint behavior on
   bEnable :  TRUE to enable auto checkpoint FALSE to disable.     */
PSSQL_PROC( void, SetSQLAutoCheckpoint )( PODBC odbc, LOGICAL bEnable );
/* returns the current value of auto checkpoint mode on a conneciton
   Parameters
   odbc :     connection to enable auto checkpoint behavior on */
PSSQL_PROC( LOGICAL, GetSQLAutoCheckpoint )( PODBC odbc );
/* A function to apply a time offset for fiscal time
   calculations; sometimes the day doesn't end at midnight, but
   a shift might last until 5 in the morning.
   Parameters
   odbc :            connection to get the appropriate SQL
                     expression for
   BeginOfDayType :  name of the type of beginning of the day
   default_begin :   the default time when a day begins.
   Note
   default_begin is a format sort of like a time. If this is a
   simple integer 5 then it's 5:00am, if it's more than 100,
   then it's assumed to be hours and minutes so 530 would be
   5:30 in the monring. this is also stored in the option
   databse, so the default value can be overridden; if the SQL
   value has a ':' in it then it is parsed as hours and minutes.
   Negative time may be used to indicate that the day begins
   before the day ends (-2 would be day end at 10pm).            */
PSSQL_PROC( CTEXTSTR, GetSQLOffsetDate )( PODBC odbc, CTEXTSTR BeginOfDayType, int default_begin );
/* Performs a low level backup of one database to another.  This API supports
   sqlite3 connections ONLY.
   Parameters
   source :            original database to copy from
   dest :    database to copy to
   */
PSSQL_PROC( LOGICAL, BackupDatabase )( PODBC source, PODBC dest );
/* return the underlaying native connection handle of the database connection
 */
// deprecated during dev, instead added function hook exports
//PSSQL_PROC( POINTER, GetODBCHandle )( PODBC odbc );
/* set a handler to be triggered when SQLite Database finds corruption type error...
 */
PSSQL_PROC( void, SetSQLCorruptionHandler )( PODBC odbc, void (CPROC*f)(uintptr_t psv, PODBC odbc), uintptr_t psv );
/* Utility function to parse DSN according to sack sqlite vfs rules... */
PSSQL_PROC( void, ParseDSN )( CTEXTSTR dsn, char **vfs, char **vfsInfo, char **dbFile );
#if defined( USE_SQLITE ) || defined( USE_SQLITE_INTERFACE )
#ifdef __cplusplus
SQL_NAMESPACE_END
#endif
struct sqlite3_value;
struct sqlite3_context;
#ifdef __cplusplus
SQL_NAMESPACE
#endif
PSSQL_PROC( int, PSSQL_AddSqliteFunction )( PODBC odbc
	, const char *name
	, void( *callUserFunction )( struct sqlite3_context*onwhat, int argc, struct sqlite3_value**argv )
	, void( *callUserDestroy )( void * )
	, int args
	, void *userData );
PSSQL_PROC( int, PSSQL_AddSqliteProcedure )( PODBC odbc
	, const char *name
	, void( *callUserFunction )( struct sqlite3_context*onwhat, int argc, struct sqlite3_value**argv )
	, void( *callUserDestroy )( void * )
	, int args
	, void *userData );
PSSQL_PROC( int, PSSQL_AddSqliteAggregate )( PODBC odbc
	, const char *name
	, void( *callStep )( struct sqlite3_context*onwhat, int argc, struct sqlite3_value**argv )
	, void( *callFinal )( struct sqlite3_context*onwhat )
	, void( *callUserDestroy )( void * )
	, int args
	, void *userData );
PSSQL_PROC( POINTER, PSSQL_GetSqliteFunctionData )( struct sqlite3_context*context );
PSSQL_PROC( void, PSSQL_ResultSqliteText )( struct sqlite3_context*context, const char *data, int dataLen, void (*done)(void*) );
PSSQL_PROC( void, PSSQL_ResultSqliteBlob )( struct sqlite3_context*context, const char *data, int dataLen, void (*done)(void*) );
PSSQL_PROC( void, PSSQL_ResultSqliteDouble )( struct sqlite3_context*context, double val );
PSSQL_PROC( void, PSSQL_ResultSqliteInt )( struct sqlite3_context*context, int val );
PSSQL_PROC( void, PSSQL_ResultSqliteInt64 )( struct sqlite3_context*context, int64_t val );
PSSQL_PROC( void, PSSQL_ResultSqliteNull )( struct sqlite3_context*context );
enum sqlite_data_types {
	PSSQL_TYPE_INTEGER= 1,
	PSSQL_TYPE_FLOAT= 2,
	PSSQL_TYPE_TEXT = 3,
	PSSQL_TYPE_BLOB  = 4,
	PSSQL_TYPE_NULL = 5,
};
PSSQL_PROC( enum sqlite_data_types, PSSQL_GetSqliteValueType )( struct sqlite3_value *val );
PSSQL_PROC( void, PSSQL_GetSqliteValueText )( struct sqlite3_value *val, const char **text, int *textLen );
PSSQL_PROC( void, PSSQL_GetSqliteValueBlob )( struct sqlite3_value *val, const char **text, int *textLen );
PSSQL_PROC( void, PSSQL_GetSqliteValueDouble )( struct sqlite3_value *val, double *result );
PSSQL_PROC( void, PSSQL_GetSqliteValueInt )( struct sqlite3_value *val, int *result );
PSSQL_PROC( void, PSSQL_GetSqliteValueInt64 )( struct sqlite3_value *val, int64_t *result );
PSSQL_PROC( const char *, PSSQL_GetColumnTableName )( PODBC odbc, int col );
PSSQL_PROC( const char *, PSSQL_GetColumnTableAliasName )( PODBC odbc, int col );
PSSQL_PROC( void, PSSQL_GetSqliteValue )( struct sqlite3_value *val, const char **text, int *textLen );
/*
 Get Database Provider (type of database).
   1=Sqlite, 2=MyQL, 3=PSQL, 4=Access, 5=MariaDB, 6=?, -1=unknown
*/
PSSQL_PROC( int, GetDatabaseProvider )( PODBC odbc );
#endif
SQL_NAMESPACE_END
#ifdef __cplusplus
	using namespace sack::sql;
#endif
#endif
#if 0
#endif
// sqloptint.h leaves namespace open.
// these headers should really be collapsed.
/* Provies SQL Option Interface. Options are implemented as a
   tree of nodes with names and values. Defines abstract
   interface that can be filled by varying providers.         */
#ifndef SQL_GET_OPTION_DEFINED
/* Inclusion protection; used to prevent duplicate inclusion of
   the same file.                                               */
#define SQL_GET_OPTION_DEFINED
#ifdef __cplusplus
#define _OPTION_NAMESPACE namespace options {
#define _OPTION_NAMESPACE_END }
#define USE_OPTION_NAMESPACE	 using namespace sack::sql::options;
#else
#define _OPTION_NAMESPACE
#define _OPTION_NAMESPACE_END
#define USE_OPTION_NAMESPACE
#endif
SACK_NAMESPACE
   _SQL_NAMESPACE
	/* Contains methods for saving and recovering options from a
	   database. If enabled, will use a local option.db sqlite
	   database. Use EditOptions application to modify options. Can
	   use any database connection, but sql.config file will specify
	   'option.db' to start.                                         */
	_OPTION_NAMESPACE
#define SACK_OPTION_NAMESPACE SACK_NAMESPACE _SQL_NAMESPACE _OPTION_NAMESPACE
#define SACK_OPTION_NAMESPACE_END _OPTION_NAMESPACE_END _SQL_NAMESPACE_END SACK_NAMESPACE_END
#ifdef SQLGETOPTION_SOURCE
#define SQLGETOPTION_PROC(type,name) EXPORT_METHOD type CPROC name
#else
#define SQLGETOPTION_PROC(type,name) IMPORT_METHOD type CPROC name
#endif
#ifndef __NO_INTERFACES__
   _INTERFACE_NAMESPACE
/* Defines a set of functions that can be registered as an
   interface, and the interface can be used for saving options. Module
   ideas might be to save into the windows registry system or
   into INI files.                                                     */
typedef struct option_interface_tag
{
   // these provide simple section, key, value queries.
	METHOD_PTR( size_t, GetPrivateProfileString )( CTEXTSTR pSection, CTEXTSTR pOptname, CTEXTSTR pDefaultbuf, TEXTSTR pBuffer, size_t nBuffer, CTEXTSTR pININame );
	METHOD_PTR( int32_t, GetPrivateProfileInt )( CTEXTSTR pSection, CTEXTSTR pOptname, int32_t nDefault, CTEXTSTR pININame );
	METHOD_PTR( size_t, GetProfileString )( CTEXTSTR pSection, CTEXTSTR pOptname, CTEXTSTR pDefaultbuf, TEXTSTR pBuffer, size_t nBuffer );
	METHOD_PTR( int32_t, GetProfileInt )( CTEXTSTR pSection, CTEXTSTR pOptname, int32_t defaultval );
   // these provide an additional level of abstraction - the ini file
	METHOD_PTR( LOGICAL, WritePrivateProfileString )( CTEXTSTR pSection, CTEXTSTR pName, CTEXTSTR pValue, CTEXTSTR pINIFile );
	METHOD_PTR( int32_t, WritePrivateProfileInt )( CTEXTSTR pSection, CTEXTSTR pName, int32_t value, CTEXTSTR pINIFile );
	METHOD_PTR( LOGICAL, WriteProfileString )( CTEXTSTR pSection, CTEXTSTR pName, CTEXTSTR pValue );
	METHOD_PTR( int32_t, WriteProfileInt )( CTEXTSTR pSection, CTEXTSTR pName, int32_t value );
   // these offer(expose) the option to be quiet
	METHOD_PTR( size_t, GetPrivateProfileStringEx )( CTEXTSTR pSection, CTEXTSTR pOptname, CTEXTSTR pDefaultbuf, TEXTSTR pBuffer, size_t nBuffer, CTEXTSTR pININame, LOGICAL bQuiet );
	METHOD_PTR( int32_t, GetPrivateProfileIntEx )( CTEXTSTR pSection, CTEXTSTR pOptname, int32_t nDefault, CTEXTSTR pININame, LOGICAL bQuiet );
	METHOD_PTR( size_t, GetProfileStringEx )( CTEXTSTR pSection, CTEXTSTR pOptname, CTEXTSTR pDefaultbuf, TEXTSTR pBuffer, size_t nBuffer, LOGICAL bQuiet );
	METHOD_PTR( int32_t, GetProfileIntEx )( CTEXTSTR pSection, CTEXTSTR pOptname, int32_t defaultval, LOGICAL bQuiet );
	METHOD_PTR( LOGICAL, WriteProfileStringEx )( CTEXTSTR pSection, CTEXTSTR pName, CTEXTSTR pValue, CTEXTSTR pINIFile, LOGICAL flush );
	METHOD_PTR( LOGICAL, WritePrivateProfileStringEx )( CTEXTSTR pSection, CTEXTSTR pName, CTEXTSTR pValue, CTEXTSTR pINIFile, LOGICAL commit );
} *POPTION_INTERFACE;
#define GetOptionInterface() ((POPTION_INTERFACE)GetInterface( "options" ))
//POPTION_INTERFACE GetOptionInterface( void );
//void DropOptionInterface( POPTION_INTERFACE );
#ifndef DEFAULT_OPTION_INTERFACE
#define DEFAULT_OPTION_INTERFACE ((!pOptionInterface)?(pOptionInterface=GetOptionInterface()):pOptionInterface)
#ifdef USES_OPTION_INTERFACE
static POPTION_INTERFACE pOptionInterface;
#ifdef __WATCOMC__
static void UseInterface( void )
{
	// use the value of this function and set pOptionInterface with it
	// makes pOptionInterface marked as used so is UseInterface.
	// Visual Studio pucked on this because converting a function pointer to data pointer
   // but this function should never be called.
   pOptionInterface = (POPTION_INTERFACE)UseInterface;
}
#endif
#endif
#endif
   _INTERFACE_NAMESPACE_END
#ifdef __cplusplus
using namespace sack::sql::options::Interface;
#endif
#endif
#define OptGetPrivateProfileString   METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),GetPrivateProfileString)
#define OptGetPrivateProfileInt      METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),GetPrivateProfileInt)
#define OptGetProfileString          METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),GetProfileString)
#define OptGetProfileInt             METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),GetProfileInt)
#define OptWritePrivateProfileString METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),WritePrivateProfileString)
#define OptWritePrivateProfileInt    METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),WritePrivateProfileInt)
#define OptWriteProfileString        METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),WriteProfileString)
#define OptWriteProfileInt           METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),WriteProfileInt)
#define OptGetPrivateProfileStringEx   METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),GetPrivateProfileStringEx)
#define OptGetPrivateProfileIntEx      METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),GetPrivateProfileIntEx)
#define OptGetProfileStringEx          METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),GetProfileStringEx)
#define OptGetProfileIntEx             METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),GetProfileIntEx)
#define OptWritePrivateProfileStringEx     METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),WritePrivateProfileStringEx)
#define OptWriteProfileStringEx     METHOD_ALIAS((DEFAULT_OPTION_INTERFACE),WriteProfileStringEx)
SACK_OPTION_NAMESPACE_END
#endif
SACK_OPTION_NAMESPACE
typedef struct sack_option_tree_family_node *POPTION_TREE_NODE;
typedef struct sack_option_tree_family *POPTION_TREE;
/* <combine sack::sql::options::SACK_GetPrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@TEXTCHAR *@size_t@CTEXTSTR@LOGICAL>
   \ \                                                                                                                        */
SQLGETOPTION_PROC( size_t, SACK_GetPrivateProfileString )( CTEXTSTR pSection, CTEXTSTR pOptname, CTEXTSTR pDefaultbuf, TEXTCHAR *pBuffer, size_t nBuffer, CTEXTSTR pININame );
/* <combine sack::sql::options::SACK_GetPrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@TEXTCHAR *@size_t@CTEXTSTR@LOGICAL>
   \ \                                                                                                                        */
SQLGETOPTION_PROC( int32_t, SACK_GetPrivateProfileInt )( CTEXTSTR pSection, CTEXTSTR pOptname, int32_t nDefault, CTEXTSTR pININame );
/* <combine sack::sql::options::SACK_GetPrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@TEXTCHAR *@size_t@CTEXTSTR@LOGICAL>
   \ \                                                                                                                        */
SQLGETOPTION_PROC( size_t, SACK_GetProfileString )( CTEXTSTR pSection, CTEXTSTR pOptname, CTEXTSTR pDefaultbuf, TEXTCHAR *pBuffer, size_t nBuffer );
/* <combine sack::sql::options::SACK_GetPrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@TEXTCHAR *@size_t@CTEXTSTR@LOGICAL>
   \ \                                                                                                                        */
SQLGETOPTION_PROC( int, SACK_GetProfileBlob )( CTEXTSTR pSection, CTEXTSTR pOptname, TEXTCHAR **pBuffer, size_t *pnBuffer );
/* <combine sack::sql::options::SACK_GetPrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@TEXTCHAR *@size_t@CTEXTSTR@LOGICAL>
   \ \                                                                                                                        */
SQLGETOPTION_PROC( int, SACK_GetProfileBlobOdbc )( PODBC odbc, CTEXTSTR pSection, CTEXTSTR pOptname, TEXTCHAR **pBuffer, size_t *pnBuffer );
/* <combine sack::sql::options::SACK_GetPrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@TEXTCHAR *@size_t@CTEXTSTR@LOGICAL>
   \ \                                                                                                                        */
SQLGETOPTION_PROC( int32_t, SACK_GetProfileInt )( CTEXTSTR pSection, CTEXTSTR pOptname, int32_t defaultval );
/* All gets eventually end up here. This function gets a value
   from a database. Functions which return an 'int' use this
   function, but has extra processing to convert the text into a
   number; also if the text is 'Y', or 'y' then the option's int
   value is 1.
   Parameters
   pSection :     Path of the option to retrieve.
   pOptname :     Actual option name to retrieve.
   pDefaultbuf :  Default value if the option doesn't exist
                  already.
   pBuffer :      Pointer to the buffer to get the result
   nBuffer :      size of the result buffer in characters (not
                  bytes).
   pININame :     This is the upper level name. If a function
                  does not have a pININame, then the name
                  "DEFAULT' is used. (pass NULL here for
                  non\-private)
   bQuiet :       Boolean, if configured to prompt the user for
                  option values, this overrides the default to
                  disable prompting.                             */
SQLGETOPTION_PROC( size_t, SACK_GetPrivateProfileStringEx )( CTEXTSTR pSection, CTEXTSTR pOptname, CTEXTSTR pDefaultbuf, TEXTCHAR *pBuffer, size_t nBuffer, CTEXTSTR pININame, LOGICAL bQuiet );
SQLGETOPTION_PROC( LOGICAL, SACK_WritePrivateOptionStringEx )(PODBC odbc, CTEXTSTR pSection, CTEXTSTR pName, CTEXTSTR pValue, CTEXTSTR pINIFile, LOGICAL flush);
/* <combine sack::sql::options::SACK_GetPrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@TEXTCHAR *@size_t@CTEXTSTR@LOGICAL>
   \ \                                                                                                                        */
SQLGETOPTION_PROC( int32_t, SACK_GetPrivateProfileIntEx )( CTEXTSTR pSection, CTEXTSTR pOptname, int32_t nDefault, CTEXTSTR pININame, LOGICAL bQuiet );
/* <combine sack::sql::options::SACK_GetPrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@TEXTCHAR *@size_t@CTEXTSTR@LOGICAL>
   \ \                                                                                                                        */
SQLGETOPTION_PROC( size_t, SACK_GetProfileStringEx )( CTEXTSTR pSection, CTEXTSTR pOptname, CTEXTSTR pDefaultbuf, TEXTCHAR *pBuffer, size_t nBuffer, LOGICAL bQuiet );
/* <combine sack::sql::options::SACK_GetPrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@TEXTCHAR *@size_t@CTEXTSTR@LOGICAL>
   \ \                                                                                                                        */
SQLGETOPTION_PROC( int32_t, SACK_GetProfileIntEx )( CTEXTSTR pSection, CTEXTSTR pOptname, int32_t defaultval, LOGICAL bQuiet );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   \ \                                                                                                            */
SQLGETOPTION_PROC( int32_t, SACK_WritePrivateProfileIntEx )( CTEXTSTR pSection, CTEXTSTR pName, int32_t value, CTEXTSTR pINIFile, LOGICAL bQuiet );
SQLGETOPTION_PROC( LOGICAL, SACK_WritePrivateProfileStringEx )( CTEXTSTR pSection, CTEXTSTR pName, CTEXTSTR pValue, CTEXTSTR pINIFile, LOGICAL bFlush );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   \ \                                                                                                            */
SQLGETOPTION_PROC( LOGICAL, SACK_WriteProfileStringEx )( CTEXTSTR pSection, CTEXTSTR pName, CTEXTSTR pValue, CTEXTSTR pINIfile, LOGICAL flush );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   \ \                                                                                                            */
SQLGETOPTION_PROC( int32_t, SACK_WriteProfileIntEx )( CTEXTSTR pSection, CTEXTSTR pName, int32_t value, LOGICAL bQuiet );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   \ \                                                                                                            */
SQLGETOPTION_PROC( LOGICAL, SACK_WritePrivateProfileString )( CTEXTSTR pSection, CTEXTSTR pName, CTEXTSTR pValue, CTEXTSTR pINIFile );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   \ \                                                                                                            */
SQLGETOPTION_PROC( int32_t, SACK_WritePrivateProfileInt )( CTEXTSTR pSection, CTEXTSTR pName, int32_t value, CTEXTSTR pINIFile );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   \ \                                                                                                            */
SQLGETOPTION_PROC( LOGICAL, SACK_WriteProfileString )( CTEXTSTR pSection, CTEXTSTR pName, CTEXTSTR pValue );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   \ \                                                                                                            */
SQLGETOPTION_PROC( LOGICAL, SACK_WriteOptionString )( PODBC odbc, CTEXTSTR pSection, CTEXTSTR pName, CTEXTSTR pValue );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   \ \                                                                                                            */
SQLGETOPTION_PROC( int, SACK_WriteProfileBlob )( CTEXTSTR pSection, CTEXTSTR pOptname, TEXTCHAR *pBuffer, size_t nBuffer );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   \ \                                                                                                            */
SQLGETOPTION_PROC( int, SACK_WriteProfileBlobOdbc )( PODBC odbc, CTEXTSTR pSection, CTEXTSTR pOptname, TEXTCHAR *pBuffer, size_t nBuffer );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   returns boolean true/false whether the write worked or not.
   \ \                                                                                                            */
SQLGETOPTION_PROC( int, SACK_WritePrivateProfileBlob )( CTEXTSTR pSection, CTEXTSTR pOptname, TEXTCHAR *pBuffer, size_t nBuffer, CTEXTSTR app );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   returns boolean true/false whether the write worked or not.
   \ \                                                                                                            */
SQLGETOPTION_PROC( int, SACK_WritePrivateProfileBlobOdbc )( PODBC odbc, CTEXTSTR pSection, CTEXTSTR pOptname, TEXTCHAR *pBuffer, size_t nBuffer,  CTEXTSTR app);
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   returns boolean true/false whether the write worked or not.
   \ \                                                                                                            */
SQLGETOPTION_PROC( int32_t, SACK_WriteProfileInt )( CTEXTSTR pSection, CTEXTSTR pName, int32_t value );
/* <combinewith sack::sql::options::SACK_WritePrivateProfileStringEx@CTEXTSTR@CTEXTSTR@CTEXTSTR@CTEXTSTR@LOGICAL>
   \ \                                                                                                            */
SQLGETOPTION_PROC( size_t, SACK_GetPrivateProfileStringExxx )( PODBC odbc
																				, CTEXTSTR pSection
																				, CTEXTSTR pOptname
																				, CTEXTSTR pDefaultbuf
																				, TEXTCHAR *pBuffer
																				, size_t nBuffer
																				, CTEXTSTR pININame
																				, LOGICAL bQuiet
																				 DBG_PASS
																				);
#ifdef __NO_OPTIONS__
#define SACK_GetProfileInt( s,e,d ) (d)
#define SACK_GetProfileString( s,e,d,b,n ) ((d)?StrCpyEx( b,d,n ):0)
#endif
#define SACK_GetPrivateOptionString( odbc, section, option, default_buf, buf, buf_size, ini_name )	   SACK_GetPrivateProfileStringExxx( odbc, section, option, default_buf, buf, buf_size, ini_name, FALSE DBG_SRC )
#define SACK_GetPrivateOptionStringEx( odbc, section, option, default_buf, buf, buf_size, ini_name, quiet )      SACK_GetPrivateProfileStringExxx( odbc, section, option, default_buf, buf, buf_size, ini_name, quiet DBG_SRC )
#define SACK_GetOptionString( odbc, section, option, default_buf, buf, buf_size )      SACK_GetPrivateProfileStringExxx( odbc, section, option, default_buf, buf, buf_size, NULL, FALSE DBG_SRC )
#define SACK_GetOptionStringEx( odbc, section, option, default_buf, buf, buf_size, quiet )      SACK_GetPrivateProfileStringExxx( odbc, section, option, default_buf, buf, buf_size, NULL, quiet DBG_SRC )
SQLGETOPTION_PROC( int32_t, SACK_GetPrivateProfileIntExx )( PODBC odbc, CTEXTSTR pSection, CTEXTSTR pOptname, int32_t nDefault, CTEXTSTR pININame, LOGICAL bQuiet DBG_PASS );
#define SACK_GetPrivateOptionInt( odbc, section, option, default_val, ini_name )	   SACK_GetPrivateProfileIntExx( odbc, section, option, default_val, ini_name, FALSE DBG_SRC )
#define SACK_GetPrivateOptionIntEx( odbc, section, option, default_val, ini_name, quiet )      SACK_GetPrivateProfileIntExx( odbc, section, option, default_val, ini_name, quiet DBG_SRC )
#define SACK_GetOptionInt( odbc, section, option, default_val )      SACK_GetPrivateProfileIntExx( odbc, section, option, default_val, NULL, FALSE DBG_SRC )
#define SACK_GetOptionIntEx( odbc, section, option, default_val, quiet )      SACK_GetPrivateProfileIntExx( odbc, section, option, default_val, NULL, quiet DBG_SRC )
SQLGETOPTION_PROC( CTEXTSTR, GetSystemID )( void );
SQLGETOPTION_PROC( void, EnumOptions )( POPTION_TREE_NODE parent
					 , int (CPROC *Process)(uintptr_t psv, CTEXTSTR name, POPTION_TREE_NODE ID, int flags )
                , uintptr_t psvUser );
SQLGETOPTION_PROC( void, EnumOptionsEx )( PODBC odbc, POPTION_TREE_NODE parent
					 , int (CPROC *Process)(uintptr_t psv, CTEXTSTR name, POPTION_TREE_NODE ID, int flags )
                , uintptr_t psvUser );
SQLGETOPTION_PROC( POPTION_TREE, GetOptionTreeExxx )( PODBC odbc, PFAMILYTREE existing_tree DBG_PASS );
/* Sets the option database to use (does not prevent
   preload/deadstart code from using the old database) but this
   can be used for comparison utilities.
   Parameters
   odbc :  The PODBC connection to use.
   See Also
   PODBC                                                        */
SQLGETOPTION_PROC( POPTION_TREE, SetOptionDatabase )( PODBC odbc );
SQLGETOPTION_PROC( CTEXTSTR, GetDefaultOptionDatabaseDSN )( void );
SQLGETOPTION_PROC( void, SetOptionDatabaseOption )( PODBC odbc );
SQLGETOPTION_PROC( void, BeginBatchUpdate )( void );
SQLGETOPTION_PROC( void, EndBatchUpdate )( void );
SQLGETOPTION_PROC( POPTION_TREE_NODE, GetOptionIndexEx )( POPTION_TREE_NODE parent, const TEXTCHAR *file, const TEXTCHAR *pBranch, const TEXTCHAR *pValue, int bCreate, int bBypassParsing DBG_PASS );
SQLGETOPTION_PROC( POPTION_TREE_NODE, GetOptionIndexExx )( PODBC odbc, POPTION_TREE_NODE parent, CTEXTSTR program, const TEXTCHAR *file, const TEXTCHAR *pBranch, const TEXTCHAR *pValue, int bCreate, int bBypassParsing DBG_PASS );
#define GetOptionIndex(p,f,b,v) GetOptionIndexEx( p,f,b,v,FALSE,FALSE DBG_SRC )
SQLGETOPTION_PROC( size_t, GetOptionStringValueEx )( PODBC odbc, POPTION_TREE_NODE optval, TEXTCHAR **buffer, size_t *len DBG_PASS );
SQLGETOPTION_PROC( void,SetOptionStringValueEx )( PODBC odbc, POPTION_TREE_NODE node, CTEXTSTR value );
SQLGETOPTION_PROC( size_t, GetOptionStringValue )( POPTION_TREE_NODE optval, TEXTCHAR **buffer, size_t *len );
SQLGETOPTION_PROC( LOGICAL, SetOptionStringValue )( POPTION_TREE tree, POPTION_TREE_NODE optval, CTEXTSTR pValue );
SQLGETOPTION_PROC( void, DeleteOption )( POPTION_TREE_NODE iRoot );
SQLGETOPTION_PROC( void, DuplicateOption )( POPTION_TREE_NODE iRoot, CTEXTSTR pNewName );
 // flush the map cache.
SQLGETOPTION_PROC( void, ResetOptionMap )( PODBC odbc );
SQLGETOPTION_PROC( PODBC, GetOptionODBCEx )( CTEXTSTR dsn DBG_PASS );
SQLGETOPTION_PROC( void, DropOptionODBCEx )( PODBC odbc DBG_PASS );
SQLGETOPTION_PROC( PODBC, GetOptionODBC )( CTEXTSTR dsn );
SQLGETOPTION_PROC( void, DropOptionODBC )( PODBC odbc );
#define GetOptionODBC( b) GetOptionODBCEx( b DBG_SRC )
#define DropOptionODBC(a) DropOptionODBCEx( a DBG_SRC )
SQLGETOPTION_PROC( void, FindOptions )( PODBC odbc, PLIST *result_list, CTEXTSTR name );
_OPTION_NAMESPACE_END _SQL_NAMESPACE_END SACK_NAMESPACE_END
	USE_OPTION_NAMESPACE
#endif
#else
#  include <sack.h>
 // tolower on linux
//#include <filesys.h>
//#include <procreg.h>
//#include <salty_generator.h>
//#include <sack_vfs.h>
//#include <sqlgetoption.h>
#endif
#ifdef _MSC_VER
// integer partial expresions summed into 64 bit.
#  pragma warning( disable: 26451 )
#endif
SACK_VFS_NAMESPACE
//#define PARANOID_INIT
//#define DEBUG_TRACE_LOG
#ifdef DEBUG_TRACE_LOG
#define LoG( a,... ) lprintf( a,##__VA_ARGS__ )
#else
#define LoG( a,... )
#endif
// more verbose logging...
//#define DEBUG_BLOCK_TRACKING
//#define DEBUG_NAME_POSITION_SEEK
//#define DEBUG_VERBOSE_CHAIN_FOLLOW
//#define DEBUG_BAT_UPDATES
#ifdef DEBUG_BAT_UPDATES
#define LoGB( a,... ) lprintf( a,##__VA_ARGS__ )
#else
#define LoGB( a,... )
#endif
#define MMAP_BASED_VFS
#ifndef _MSC_VER
#endif
/**************
  VFS_VERSION
     used to track migration of keys and keying methods.
  0x100 = version 1; SHORTKEY_LENGTH = 16
 **************/
#define VFS_VERSION     0x100
// 12 bits = 1 << 12 = 4096
#define BLOCK_SIZE_BITS 12
// BLOCKINDEX is either 4 or 8 bytes... sizeof( size_t )...
// all constants though should compile out to a single value... and just for grins went to 16 bit size_t and 0 shift... or 1 byte
#define BLOCK_BAT_SHIFT (BLOCK_SIZE_BITS-(sizeof(BLOCKINDEX)==16?4:sizeof(BLOCKINDEX)==8?3:sizeof(BLOCKINDEX)==4?2:sizeof(BLOCKINDEX)==2?1:0) )
#define BLOCK_INDEX_SHIFT ((sizeof(BLOCKINDEX)==16?4:sizeof(BLOCKINDEX)==8?3:sizeof(BLOCKINDEX)==4?2:sizeof(BLOCKINDEX)==2?1:0) )
#define BLOCK_BYTE_SHIFT (BLOCK_SIZE_BITS)
#define BLOCK_SIZE (1<<BLOCK_SIZE_BITS)
#define BLOCK_SMALL_SIZE     256
#define DIR_BLOCK_SIZE_BITS   12
#define DIR_BLOCK_SIZE      (1<<DIR_BLOCK_SIZE_BITS)
#define BAT_BLOCK_SIZE      4096
#define NAME_BLOCK_SIZE     4096
#define KEY_SIZE            1024
#define TIME_BLOCK_SIZE     4096
#define ROLLBACK_BLOCK_SIZE 4096
#define FILE_NAME_MAXLEN    4096
#define BLOCK_MASK (BLOCK_SIZE-1)
#ifdef VIRTUAL_OBJECT_STORE
// if the block index & BAT_BLOCK_MASK, is a data block
// all BATs are 4096
#  undef BLOCKS_PER_BAT
#  undef BLOCK_SECTOR_MASK
#  define BLOCKS_PER_BAT ((BAT_BLOCK_SIZE >> BLOCK_INDEX_SHIFT)-1)
#  define BLOCK_SECTOR_MASK BLOCKS_PER_BAT
#else
#  undef BLOCKS_PER_BAT
#  undef BLOCK_SECTOR_MASK
#  define BLOCKS_PER_BAT ((BAT_BLOCK_SIZE >> BLOCK_INDEX_SHIFT))
#  define BLOCK_SECTOR_MASK (BLOCKS_PER_BAT-1)
#endif
#define BAT_BLOCK_MASK ( ( BAT_BLOCK_SIZE >> BLOCK_INDEX_SHIFT ) - 1)
#define BLOCKS_PER_SECTOR (1+BLOCKS_PER_BAT)
// per-sector perumation; needs to be a power of 2 (in bytes)
#define SHORTKEY_LENGTH 16
#ifndef VFS_DISK_DATATYPE
#  define VFS_DISK_DATATYPE size_t
#endif
 // BLOCK_SIZE blocks...
typedef VFS_DISK_DATATYPE BLOCKINDEX;
 // file position type
typedef VFS_DISK_DATATYPE FPI;
/* BEFORE DEF */
#undef BC
#ifdef VIRTUAL_OBJECT_STORE
/* THIS DEFINES SACK_VFS_OS_VOLUME */
#  define BC(n) BLOCK_CACHE_VOS_##n
#    ifdef sack_vfs_volume
#      undef block_cache_entries
#      undef directory_entry
#      undef sack_vfs_disk
#      undef sack_vfs_diskSection
#      undef directory_hash_lookup_block
#      undef sack_vfs_volume
#      undef sack_vfs_file
#    endif
#    define block_cache_entries block_cache_entries_os
#    define directory_entry directory_entry_os
#    define sack_vfs_disk sack_vfs_disk_os
#    define sack_vfs_diskSection sack_vfs_diskSection_os
#    define directory_hash_lookup_block directory_hash_lookup_block_os
#    define sack_vfs_volume sack_vfs_os_volume
#    define sack_vfs_file sack_vfs_os_file
#   ifdef __cplusplus
namespace objStore {
#   endif
#elif defined FILE_BASED_VFS
#  define BC(n) BLOCK_CACHE_FS_##n
#    ifdef block_cache_entries
#      undef block_cache_entries
#      undef directory_entry
#      undef sack_vfs_disk
#      undef sack_vfs_diskSection
#      undef directory_hash_lookup_block
#      undef sack_vfs_volume
#      undef sack_vfs_file
#    endif
#    define block_cache_entries block_cache_entries_fs
#    define directory_entry directory_entry_fs
#    define sack_vfs_disk sack_vfs_disk_fs
#    define sack_vfs_diskSection sack_vfs_diskSection_fs
#    define directory_hash_lookup_block directory_hash_lookup_block_fs
/* THIS DEFINES SACK_VS_VOLUME */
#    define sack_vfs_volume sack_vfs_fs_volume
#    define sack_vfs_file sack_vfs_fs_file
#   ifdef __cplusplus
namespace fs {
#   endif
#else
#  define BC(n) BLOCK_CACHE_##n
#endif
/* AFTER DEF */
enum block_cache_entries
{
	BC( ZERO )
	, BC( DIRECTORY ) = 0
#ifdef VIRTUAL_OBJECT_STORE
	, BC( DIRECTORY_LAST ) = BC( DIRECTORY ) + 64
#endif
	, BC( NAMES )
	, BC( NAMES_LAST ) = BC( NAMES ) + 16
	, BC( BAT )
#ifdef VIRTUAL_OBJECT_STORE
	// keep a few tables for cache (file system too?)
	, BC( BAT_LAST ) = BC( BAT ) + 16
#endif
	, BC(DATAKEY)
	, BC(FILE)
	, BC(FILE_LAST) = BC(FILE) + 32
#ifdef VIRTUAL_OBJECT_STORE
	, BC( TIMELINE )
	, BC( TIMELINE_LAST ) = BC( TIMELINE ) + 48
#endif
#if defined( VIRTUAL_OBJECT_STORE )
	// really shouldn't need more than one of these...
	// record
	// 1 - header
	// 0/1 - entry (might be with header)
	// 1 - small/big block journal entry
	// replay
	// 1 - header
	// 0/1 - entry (might be with header)
	// 1 - small/big block journal entry
	// 1 - target disk sector
	, BC( ROLLBACK )
	, BC( ROLLBACK_LAST ) = BC( ROLLBACK ) + 6
#endif
#if defined( VIRTUAL_OBJECT_STORE ) && defined( DEBUG_VALIDATE_TREE )
	// debug timeline, keep a mirror for comparisons, when links were lost, etc...
	// can be factored out at some point.
	, BC( TIMELINE_RO )
	, BC( TIMELINE_RO_LAST ) = BC( TIMELINE_RO ) + 48
#endif
	, BC(COUNT)
};
// could effecitvely be fewer than this
// 82 dirents * 512 byte names = 40000
#define DIRENT_NAME_OFFSET_OFFSET             0x0001FFFF
// (sealant length / 4)  (mulitply by 4 to get real length)
#define DIRENT_NAME_OFFSET_FLAG_SEALANT       0x003E0000
#define DIRENT_NAME_OFFSET_FLAG_SEALANT_SHIFT 17
#define DIRENT_NAME_OFFSET_FLAG_OWNED         0x00400000
#define DIRENT_NAME_OFFSET_FLAG_READ_KEYED    0x00800000
// unused flag; previous indicated versioning.
#define DIRENT_NAME_OFFSET_UNUSED_0         0x01000000
#define DIRENT_NAME_OFFSET_VERSION_SHIFT      25
#define DIRENT_NAME_OFFSET_VERSIONS           0x1E000000
#define DIRENT_NAME_OFFSET_UNUSED             0xFE000000
#  ifdef _MSC_VER
#    pragma pack (push, 1)
#  endif
PREFIX_PACKED struct directory_entry
{
  // name offset from beginning of disk
	FPI name_offset;
  // first block of data of the file
	BLOCKINDEX first_block;
  // how big the file is
	VFS_DISK_DATATYPE filesize;
#ifdef VIRTUAL_OBJECT_STORE
  // when the file was created/last written
	uint64_t timelineEntry;
#endif
} PACKED;
#  ifdef _MSC_VER
#    pragma pack (pop)
#  endif
#undef VFS_DIRECTORY_ENTRIES
#ifdef VIRTUAL_OBJECT_STORE
// subtract name has index
// subtrace name index
#  define VFS_DIRECTORY_ENTRIES ( ( BLOCK_SIZE - ( 2*sizeof(BLOCKINDEX) + 256*sizeof(BLOCKINDEX)) ) /sizeof( struct directory_entry) )
#  define VFS_PATCH_ENTRIES ( ( BLOCK_SIZE ) /sizeof( struct directory_entry) )
#else
#  define VFS_DIRECTORY_ENTRIES ( ( BLOCK_SIZE ) /sizeof( struct directory_entry) )
#  define VFS_PATCH_ENTRIES ( ( BLOCK_SIZE ) /sizeof( struct directory_entry) )
#endif
/*
struct sack_vfs_diskSection
{
	// BAT is at 0 of every BLOCK_SIZE blocks (4097 total)
	// &BAT[0] == itself....
	// BAT[0] == first directory entry (actually next entry; first is always here)
	// BAT[1] == first name entry (actually next name block; first is known as here)
	// bat[BLOCK_SIZE] == NEXT_BAT[0]; NEXT_BAT = BAT + BLOCK_SIZE + 1024*BLOCK_SIZE;
	// bat[8192] == ... ( 0 + ( BLOCK_SIZE + BLOCKS_PER_BAT*BLOCK_SIZE ) * N >> 12 )
	BLOCKINDEX BAT[BLOCKS_PER_BAT];
	//struct directory_entry directory[BLOCK_SIZE/sizeof( struct directory_entry)]; // 256
	//char  names[BLOCK_SIZE/sizeof(char)];
	uint8_t  block_data[BLOCKS_PER_BAT][BLOCK_SIZE];
};
struct sack_vfs_disk {
	struct sack_vfs_diskSection firstBlock;
	struct sack_vfs_diskSection blocks[];
};
*/
#undef SMUDGECACHE
#undef CLEANCACHE
#ifdef DEBUG_SECTOR_DIRT
#define SMUDGECACHE(vol,n) {	 lprintf( "set dirty on %d %d %d", n, vol->segment[n], vol->bufferFPI[n]);	 vfs_os_smudge_cache(vol,n);   }
#define CLEANCACHE(vol,n) {	 lprintf( "reset dirty on %d", n);	 RESETFLAG( vol->dirty, n ); }
#else
#define SMUDGECACHE(vol,n) {    vfs_os_smudge_cache(vol,n);   }
#define CLEANCACHE(vol,n) {	 RESETFLAG( vol->dirty, n ); }
#endif
#ifndef ROLLBACK_JOURNAL_DEFINED
#define ROLLBACK_JOURNAL_DEFINED
static int const seglock_mask_size = 4;
struct sack_vfs_os_BAT_info {
	FPI sectorStart;
	FPI sectorEnd;
	BLOCKINDEX blockStart;
	int size;
};
struct vfs_os_rollback_journal {
	struct sack_vfs_os_file* rollback_file;
	struct sack_vfs_os_file* rollback_journal_file;
	struct sack_vfs_os_file* rollback_small_journal_file;
	PDATALIST pdlPendingRecord;
	BLOCKINDEX nextBlock;
	BLOCKINDEX nextSmallBlock;
	PDATALIST pdlJournaled;
 // sectors that are in rollback already
	BLOCKINDEX *pJournaled;
 // how long pJournaled is used
	int journalLength;
 // max length of pJournaled
	int journalAvail;
};
#ifdef small
#  undef small
#endif
#  ifdef _MSC_VER
#    pragma pack (push, 1)
#  endif
PREFIX_PACKED struct vfs_os_rollback_entry {
	BLOCKINDEX fileBlock;
	struct {
		uint64_t small : 1;
  // block was full of 0's
		uint64_t zero : 1;
	} flags;
	// block size is retrievable when the block is reloadeded to write
// PACKED entries[1];
};
PREFIX_PACKED struct vfs_os_rollback_header {
	struct {
		uint64_t dirty : 1;
		uint64_t processing : 1;
	} flags;
  // where the blocks are tracked.
	BLOCKINDEX journal;
 // where small blocks are tracked
	BLOCKINDEX small_journal;
	BLOCKINDEX unused_rollbackLength;
	BLOCKINDEX nextBlock;
	BLOCKINDEX nextSmallBlock;
	BLOCKINDEX nextEntry;
  // align entries on 4096 boundaries
	uint64_t   Filler1;
	// where this is tracked.
	struct vfs_os_rollback_entry  entries[1];
}PACKED ;
#  ifdef _MSC_VER
#    pragma pack (pop)
#  endif
#endif
struct sack_vfs_volume {
	const char * volname;
#ifdef FILE_BASED_VFS
	FILE *file;
	struct file_system_mounted_interface *mount;
#else
	struct sack_vfs_disk *disk;
 // disk might be offset from diskReal because it's a .exe attached.
	struct sack_vfs_disk *diskReal;
#endif
	//uint32_t dirents;  // constant 0
	//uint32_t nameents; // constant 1
	uintptr_t dwSize;
  // used for directory signatures
	const char * datakey;
	const char * userkey;
	const char * devkey;
	enum block_cache_entries curseg;
// cached segment with usekey[n]
	BLOCKINDEX _segment[BC(COUNT)];
// associated with usekey[n]
	BLOCKINDEX segment[BC(COUNT)];
#ifdef VIRTUAL_OBJECT_STORE
	struct vfs_volume_flags {
		BIT_FIELD skipRollbackProcessing : 1;
 // stop any disk activity; test journal recoverability.
		BIT_FIELD halted : 1;
 // stop any disk activity; test journal recoverability.
		BIT_FIELD versioned : 1;
	}flags;
	struct vfs_os_rollback_journal journal;
	BLOCKINDEX lastBlock;
	PDATALIST pdl_BAT_information;
	PLIST pending_rollback;
	//PDATASTACK pdsCTimeStack;// = CreateDataStack( sizeof( struct memoryTimelineNode ) );
	//PDATASTACK pdsWTimeStack;// = CreateDataStack( sizeof( struct memoryTimelineNode ) );
 // timeline root
	struct storageTimeline *timeline;
	enum block_cache_entries timelineCache;
 // timeline root key
	struct storageTimeline *timelineKey;
	struct sack_vfs_os_file *timeline_file;
	struct sack_vfs_os_file* timeline_index_file;
	//struct storageTimelineCursor *timeline_cache;
  // segment is locked into cache.
	MASKSET_( seglock, BC( COUNT ), 4 );
	unsigned int sector_size[BC( COUNT )];
#endif
	uint8_t fileCacheAge[BC(FILE_LAST) - BC(FILE)];
#ifdef VIRTUAL_OBJECT_STORE
	uint8_t dirHashCacheAge[BC(DIRECTORY_LAST) - BC(DIRECTORY)];
	uint8_t batHashCacheAge[BC(BAT_LAST) - BC(BAT)];
	uint8_t timelineCacheAge[BC( TIMELINE_LAST ) - BC( TIMELINE )];
	uint8_t rollbackCacheAge[BC( ROLLBACK_LAST ) - BC( ROLLBACK )];
#endif
	uint8_t nameCacheAge[BC(NAMES_LAST) - BC(NAMES)];
	struct random_context *entropy;
  // root of all cached key buffers
	uint8_t* key;
#ifdef FILE_BASED_VFS
  // root of all cached key buffers
	uint8_t* oldkey;
#endif
#ifndef VIRTUAL_OBJECT_STORE
  // allow byte encrypting... key based on sector volume file index
	uint8_t* segkey;
 // composite key
	uint8_t* usekey[BC( COUNT )];
#endif
  // signature of executable attached as header
	uint8_t* sigkey;
  // signature of executable attached as header
	uint8_t* sigsalt;
	size_t sigkeyLength;
#  ifdef FILE_BASED_VFS
  // root buffer space of all cache blocks
	uint8_t* key_buffer;
 // data cache blocks
	uint8_t* usekey_buffer[BC(COUNT)];
 // duplicate copy of original sector data
	uint8_t* usekey_buffer_clean[BC(COUNT)];
	PTHREAD flusher;
	volatile LOGICAL flushing;
	PVARTEXT pvtDeleteBuffer;
#ifdef DEBUG_CACHE_FAULTS
	int cacheRequests[10];
	int cacheFaults[10];
#endif
	FLAGSET( dirty, BC(COUNT) );
	FLAGSET( _dirty, BC( COUNT ) );
	FPI bufferFPI[BC(COUNT)];
#  endif
	BLOCKINDEX lastBatBlock;
	PDATALIST pdlFreeBlocks;
#ifdef VIRTUAL_OBJECT_STORE
	BLOCKINDEX lastBatSmallBlock;
	PDATALIST pdlFreeSmallBlocks;
#endif
 // when reopened file structures need to be updated also...
	PLIST files;
	LOGICAL read_only;
	LOGICAL external_memory;
	LOGICAL closed;
	volatile uint32_t lock;
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	THREAD_ID locked_thread;
#endif
	uint8_t tmpSalt[16];
	uintptr_t clusterKeyVersion;
};
#if !defined( VIRTUAL_OBJECT_STORE )
struct sack_vfs_file
{
 // which volume this is in
	struct sack_vfs_volume *vol;
	struct directory_entry dirent_key;
	FPI fpi;
	BLOCKINDEX _first_block;
 // this should be in-sync with current FPI always; plz
	BLOCKINDEX block;
  // someone already deleted this...
	LOGICAL delete_on_close;
	BLOCKINDEX *blockChain;
	BLOCKINDEX blockChainAvail;
	BLOCKINDEX blockChainLength;
#  ifdef FILE_BASED_VFS
  // where to write the directory entry update to
	FPI entry_fpi;
#    ifdef VIRTUAL_OBJECT_STORE
	enum block_cache_entries cache;
	struct memoryTimelineNode *timeline;
	uint8_t *seal;
	uint8_t *sealant;
	uint8_t *readKey;
	uint16_t readKeyLen;
	uint8_t sealantLen;
 // boolean, on read, validates seal.  Defaults to FALSE.
	uint8_t sealed;
	char *filename;
#    endif
  // has file size within
	struct directory_entry _entry;
  // has file size within
	struct directory_entry *entry;
#  else
  // has file size within
	struct directory_entry *entry;
#  endif
};
#endif
#  undef TSEEK
#  undef BTSEEK
#  ifdef VIRTUAL_OBJECT_STORE
#    define TSEEK(type,v,o,s,c) ((type)vfs_os_SEEK(v,o,s,&c))
#    define BTSEEK(type,v,o,s,c) ((type)vfs_os_BSEEK(v,o,s,&c))
#  elif defined FILE_BASED_VFS
#    define TSEEK(type,v,o,c) ((type)vfs_fs_SEEK(v,o,&c))
#    define BTSEEK(type,v,o,c) ((type)vfs_fs_BSEEK(v,o,&c))
#  else
#    define TSEEK(type,v,o,c) ((type)vfs_SEEK(v,o,&c))
#    define BTSEEK(type,v,o,c) ((type)vfs_BSEEK(v,o,&c))
#  endif
#if defined( __GNUC__ ) && !defined( _WIN32 )
#define HIDDEN __attribute__ ((visibility ("hidden")))
#else
#define HIDDEN
#endif
#if !defined( VIRTUAL_OBJECT_STORE ) && !defined( FILE_BASED_VFS )
  uintptr_t vfs_SEEK( struct sack_vfs_volume* vol, FPI offset, enum block_cache_entries* cache_index ) HIDDEN;
  uintptr_t vfs_BSEEK( struct sack_vfs_volume* vol, BLOCKINDEX block, enum block_cache_entries* cache_index ) HIDDEN;
#elif defined( VIRTUAL_OBJECT_STORE )
  uintptr_t vfs_os_SEEK( struct sack_vfs_os_volume* vol, FPI offset, int size, enum block_cache_entries* cache_index ) HIDDEN;
  uintptr_t vfs_os_BSEEK( struct sack_vfs_os_volume* vol, BLOCKINDEX block, int size, enum block_cache_entries* cache_index ) HIDDEN;
#elif defined( FILE_BASED_VFS )
  uintptr_t vfs_fs_SEEK( struct sack_vfs_fs_volume* vol, FPI offset, enum block_cache_entries* cache_index ) HIDDEN;
  uintptr_t vfs_fs_BSEEK( struct sack_vfs_fs_volume* vol, BLOCKINDEX block, enum block_cache_entries* cache_index ) HIDDEN;
#endif
#if defined( VIRTUAL_OBJECT_STORE ) || defined( FILE_BASED_VFS )
#   ifdef __cplusplus
}
using namespace sack::SACK_VFS;
#   endif
#  endif
static struct {
	struct directory_entry zero_entkey;
	uint8_t zerokey[BLOCK_SIZE];
} l;
#define EOFBLOCK  (~(BLOCKINDEX)0)
#define EOBBLOCK  ((BLOCKINDEX)1)
#define EODMARK   (1)
#define GFB_INIT_NONE   0
#define GFB_INIT_DIRENT 1
#define GFB_INIT_NAMES  2
static BLOCKINDEX GetFreeBlock( struct sack_vfs_volume *vol, int init );
static struct directory_entry * VFSScanDirectory( struct sack_vfs_volume *vol, const char * filename, struct directory_entry *dirkey, int path_match );
static char mytolower( int c ) {	if( c == '\\' ) return '/'; return tolower( c ); }
static int  PathCaseCmpEx ( CTEXTSTR s1, CTEXTSTR s2, size_t maxlen )
{
	if( !s1 )
		if( s2 )
			return -1;
		else
			return 0;
	else
		if( !s2 )
			return 1;
	if( s1 == s2 )
 // ==0 is success.
		return 0;
	for( ;s1[0] && s2[0] && ( (s1[0]=='/'&&s2[0]=='\\')||(s1[0]=='\\'&&s2[0]=='/')||
									 (((s1[0] >='a' && s1[0] <='z' )?s1[0]-('a'-'A'):s1[0])
									 == ((s2[0] >='a' && s2[0] <='z' )?s2[0]-('a'-'A'):s2[0])) ) && maxlen;
		  s1++, s2++, maxlen-- );
	if( maxlen )
		return tolower(s1[0]) - tolower(s2[0]);
	return 0;
}
// read the byte from namespace at offset; decrypt byte in-register
// compare against the filename bytes.
static int MaskStrCmp( struct sack_vfs_volume *vol, CTEXTSTR filename, FPI name_offset, int path_match ) {
	if( vol->key ) {
		int c;
		while(  ( c = ( ((uint8_t*)vol->disk)[name_offset] ^ vol->usekey[BC(NAMES)][name_offset&BLOCK_MASK] ) )
			  && filename[0] ) {
			int del = mytolower(filename[0]) - mytolower(c);
			if( ( filename[0] == '/' && c == '\\' )
			    || ( filename[0] == '\\' && c == '/' ) )
				del = 0;
			if( del ) return del;
			filename++;
			name_offset++;
			if( path_match && !filename[0] ) {
				c = ( ((uint8_t*)vol->disk)[name_offset] ^ vol->usekey[BC(NAMES)][name_offset&BLOCK_MASK] );
				if( c == '/' || c == '\\' ) return 0;
			}
		}
		// c will be 0 or filename will be 0...
		if( path_match ) return 1;
		return filename[0] - c;
	} else {
		//LoG( "doesn't volume always have a key?" );
		if( path_match ) {
			size_t l;
			int r = PathCaseCmpEx( filename, (CTEXTSTR)(((uint8_t*)vol->disk) + name_offset), l = strlen( filename ) );
			if( !r )
				if( ((const char *)(((uint8_t*)vol->disk) + name_offset))[l] == '/' || ((const char *)(((uint8_t*)vol->disk) + name_offset))[l] == '\\' )
					return 0;
				else
					return 1;
			return r;
		}
		else
			return PathCaseCmpEx( filename, (CTEXTSTR)(((uint8_t*)vol->disk) + name_offset), strlen(filename) );
	}
}
#ifdef DEBUG_TRACE_LOG
static void MaskStrCpy( char *output, size_t outlen, struct sack_vfs_volume *vol, FPI name_offset ) {
	if( vol->key ) {
		int c;
		FPI name_start = name_offset;
		while(  ( c = ( ((uint8_t*)vol->disk)[name_offset] ^ vol->usekey[BC(NAMES)][name_offset&BLOCK_MASK] ) ) ) {
			if( ( name_offset - name_start ) < outlen )
				output[name_offset-name_start] = c;
			name_offset++;
		}
		if( ( name_offset - name_start ) < outlen )
			output[name_offset-name_start] = 0;
		else
			output[outlen-1] = 0;
	} else {
		//LoG( "doesn't volume always have a key?" );
		StrCpyEx( output, (const char *)(((uint8_t*)vol->disk) + name_offset), outlen );
	}
}
#endif
static void ExtendBlockChain( struct sack_vfs_file *file ) {
	FPI newSize = ( file->blockChainAvail ) * 2 + 1;
	file->blockChain = (BLOCKINDEX*)Reallocate( file->blockChain, (size_t)(newSize * sizeof( BLOCKINDEX )) );
#ifdef _DEBUG
	// debug
	memset( file->blockChain + file->blockChainAvail, 0, (newSize - file->blockChainAvail ) * sizeof(BLOCKINDEX) );
#endif
	file->blockChainAvail = newSize;
}
static void SetBlockChain( struct sack_vfs_file *file, FPI fpi, BLOCKINDEX newBlock ) {
	FPI fileBlock = fpi >> BLOCK_SIZE_BITS;
#ifdef _DEBUG
	if( !newBlock ) DebugBreak();
#endif
	while( (fileBlock) >= file->blockChainAvail ) {
		ExtendBlockChain( file );
	}
	if( fileBlock >= file->blockChainLength )
		file->blockChainLength = (fileBlock + 1);
	//_lprintf(DBG_RELAY)( "setting %d to %d", (int)fileBlock, (int)newBlock );
	if( file->blockChain[fileBlock] ) {
		if( file->blockChain[fileBlock] == newBlock ) {
			return;
		}
	}
	file->blockChain[fileBlock] = newBlock;
}
static enum block_cache_entries UpdateSegmentKey( struct sack_vfs_volume *vol, enum block_cache_entries cache_idx, BLOCKINDEX segment )
{
	if( !vol->key ) {
		vol->segment[cache_idx] = segment;
		return cache_idx;
	}
	if( cache_idx == BC(FILE) ) {
		int n, m;
		int nLeast;
		//uint8_t next = 0;
		for( n = 0; n < (BC(FILE_LAST) - BC(FILE)); n++ ) {
			if( vol->segment[cache_idx + n] == segment ) {
				cache_idx = (enum block_cache_entries)((cache_idx)+n);
				for( m = 0; m < (BC(FILE_LAST) - BC(FILE)); m++ ) {
					if( !vol->fileCacheAge[m] ) break;
					if( vol->fileCacheAge[m] > vol->fileCacheAge[n] )
						vol->fileCacheAge[m]--;
				}
				vol->fileCacheAge[n] = m;
				break;
			}
			if( !vol->fileCacheAge[n] ) {
				cache_idx = (enum block_cache_entries)((cache_idx)+n);
				for( m = 0; m < (BC(FILE_LAST) - BC(FILE)); m++ ) {
					if( !vol->fileCacheAge[m] ) break;
					if( vol->fileCacheAge[m] >( n + 1 ) )
						vol->fileCacheAge[m]--;
				}
				vol->fileCacheAge[n] = n + 1;
				break;
			}
			if( vol->fileCacheAge[n] == 1 ) nLeast = n;
		}
		if( n == (BC(FILE_LAST) - BC(FILE)) ) {
			for( n = 0; n < (BC(FILE_LAST) - BC(FILE)); n++ ) {
				vol->fileCacheAge[n]--;
			}
			vol->fileCacheAge[nLeast] = (BC(FILE_LAST) - BC(FILE));
			cache_idx = (enum block_cache_entries)(BC(FILE) + nLeast);
		}
	}
	vol->segment[cache_idx] = segment;
	if( vol->segment[cache_idx] == vol->_segment[cache_idx] )
		return cache_idx;
	SRG_ResetEntropy( vol->entropy );
	vol->_segment[cache_idx] = vol->segment[cache_idx];
  // so we know which 'segment[idx]' to use.
	vol->curseg = cache_idx;
	SRG_GetEntropyBuffer( vol->entropy, (uint32_t*)vol->segkey, SHORTKEY_LENGTH * 8 );
	{
		int n;
#ifdef __64__
		uint64_t* usekey = (uint64_t*)vol->usekey[cache_idx];
		uint64_t* volkey = (uint64_t*)vol->key;
		uint64_t* segkey = (uint64_t*)vol->segkey;
		for( n = 0; n < (BLOCK_SIZE / SHORTKEY_LENGTH); n++ ) {
			usekey[0] = volkey[0] ^ (segkey[0]);
			usekey[1] = volkey[1] ^ (segkey[1]);
			usekey += 2;
			volkey += 2;
		}
#else
		uint32_t* usekey = (uint32_t*)vol->usekey[cache_idx];
		uint32_t* volkey = (uint32_t*)vol->key;
		uint32_t* segkey = (uint32_t*)vol->segkey;
		for( n = 0; n < (BLOCK_SIZE / SHORTKEY_LENGTH); n++ ) {
			usekey[0] = volkey[0] ^ (segkey[0]);
			usekey[1] = volkey[1] ^ (segkey[1]);
			usekey[2] = volkey[2] ^ (segkey[2]);
			usekey[3] = volkey[3] ^ (segkey[3]);
			usekey += 4;
			volkey += 4;
		}
#endif
	}
	return cache_idx;
}
static LOGICAL ValidateBAT( struct sack_vfs_volume *vol ) {
	BLOCKINDEX first_slab = 0;
	BLOCKINDEX slab = (BLOCKINDEX)(vol->dwSize / ( BLOCK_SIZE ));
	BLOCKINDEX last_block = ( slab * BLOCKS_PER_BAT ) / BLOCKS_PER_SECTOR;
	BLOCKINDEX n;
	BLOCKINDEX sector;
	BLOCKINDEX sector_b = (BLOCKINDEX)-1;
	FLAGSETTYPE *usedSectors;
	if( vol->dwSize & 0xfFF ) {
		lprintf( "Volume is setup to fail with an odd number of bytes total : %d %08" _size_f, (int)(vol->dwSize & 0xFFF), vol->dwSize );
	}
	size_t size;
	usedSectors = NewArray( FLAGSETTYPE, size= (2+(vol->dwSize / BLOCK_SIZE)/(CHAR_BIT*sizeof(FLAGSETTYPE) )) );
	MemSet( usedSectors, 0, size * sizeof( FLAGSETTYPE ) );
	//if( vol->key )
	{
		for( sector = 0, n = first_slab; n < slab; n += BLOCKS_PER_SECTOR, sector++ ) {
			size_t m;
			BLOCKINDEX *BAT;
			BLOCKINDEX *blockKey;
			BLOCKINDEX *BAT_;
			BLOCKINDEX *blockKey_;
			BLOCKINDEX *checkBAT;
			BLOCKINDEX *checkBlockKey;
			BAT_      = BAT      = (BLOCKINDEX*)(((uint8_t*)vol->disk) + n * BLOCK_SIZE);
			UpdateSegmentKey( vol, BC(BAT), n + 1 );
			// have to update the key first... it might not be pointing at the right thing.
			blockKey_ = blockKey = ((BLOCKINDEX*)vol->usekey[BC( BAT )]);
			for( m = 0; m < BLOCKS_PER_BAT; m++ )
			{
				BLOCKINDEX block = BAT[0] ^ blockKey[0];
				BLOCKINDEX blockIndex = (sector*BLOCKS_PER_BAT) + m;
				BAT++; blockKey++;
				if( block == EOBBLOCK ) {
					LoGB( "Bat Length was %d is now: %d (really %d)", vol->lastBatBlock, n+m, (sector*BLOCKS_PER_BAT)+m );
					vol->lastBatBlock = (BLOCKINDEX)((sector*BLOCKS_PER_BAT) + m);
					break;
				}
				if( block )
					if( !TESTFLAG( usedSectors, blockIndex ) ) {
						if( block == EOFBLOCK )
							SETFLAG( usedSectors, blockIndex );
						else {
							//BLOCKINDEX chainLen = 0;
							//enum block_cache_entries cache = BC( FILE );
							BLOCKINDEX nextBlock = block;
							BLOCKINDEX nextBlock_;
							SETFLAG( usedSectors, blockIndex );
							LoG( "ValidateBAT: following chain of blocks from block %d", blockIndex );
							while( nextBlock != EOFBLOCK ) {
								BLOCKINDEX b;
								BLOCKINDEX nn;
								if( nextBlock == EOBBLOCK ) {
									lprintf( "File chains hould not have EOB block in it." );
									DebugBreak();
								}
								if( !nextBlock ) {
									lprintf( "Empty space should never be in a file chain." );
									DebugBreak();
								}
								if( nextBlock >= last_block ) {
									Release( usedSectors );
									return FALSE;
								}
								b = nextBlock / (BLOCKS_PER_BAT);
								nn = nextBlock & (BLOCKS_PER_BAT - 1);
								if( !TESTFLAG( usedSectors, nextBlock ) ) {
									nextBlock_ = nextBlock;
									SETFLAG( usedSectors, nextBlock );
									if( b != sector ) {
										checkBAT = (BLOCKINDEX*)(((uint8_t*)vol->disk) + (b)* BLOCKS_PER_SECTOR*BLOCK_SIZE);
										checkBlockKey = ((BLOCKINDEX*)vol->usekey[BC( DATAKEY )]);
										if( b != sector_b ) {
											UpdateSegmentKey( vol, BC( DATAKEY ), ((b)* BLOCKS_PER_SECTOR) + 1 );
											sector_b = b;
										}
									}
									else {
										checkBAT = BAT_;
										checkBlockKey = blockKey_;
									}
									nextBlock = checkBAT[nn] ^ checkBlockKey[nn];
									if( !nextBlock ) {
										lprintf( "FELL OFF OF FILE CHAIN INTO EMPTY SPACE (0)! (find file and delete it?)" );
										LogBinary( (uint8_t*)usedSectors, size * sizeof( FLAGSETTYPE ) );
										DebugBreak();
										break;
									}
#ifdef DEBUG_VERBOSE_CHAIN_FOLLOW
									LoG( "Next block in chain to follow: %d %p", nextBlock, checkBAT );
#endif
								}
								else {
									if( nextBlock < ((sector*BLOCKS_PER_BAT) + m) ) {
										// this is actually ok... we just iterated over the tail part of the file.
										break;
									}
									BAT[-1] = EOFBLOCK ^ blockKey[-1];
									//return FALSE;
#ifdef _MSC_VER
#pragma warning( disable: 6001 )
#endif
									// this was something.
									// the warning _nextblock will have always been set in this state, it's
									// not uninitialized.
									lprintf( "THIS IS BAD - cross-linked files; or otherwise %d  %d", (int)nextBlock, (int)nextBlock_ );
#ifdef _MSC_VER
#pragma warning( default: 6001 )
#endif
									LogBinary( (uint8_t*)usedSectors, size * sizeof( FLAGSETTYPE ) );
									DebugBreak();
								}
								//chainLen++;
							}
						}
					}
					else {
						// block was already found in a previous file chain.
					}
				if( block == EOFBLOCK ) continue;
				if( block >= last_block ) return FALSE;
				//if( initial )
					if( block == 0 ) {
 // use as a temp variable....
						vol->lastBatBlock = (BLOCKINDEX)(sector*BLOCKS_PER_BAT + m);
						LoGB( "SET LAST BLOCK AVAIL: %d", (int)vol->lastBatBlock );
						AddDataItem( &vol->pdlFreeBlocks, &vol->lastBatBlock );
					}
			}
			if( m < BLOCKS_PER_BAT ) break;
		}
	}
	Release( usedSectors );
	if( !VFSScanDirectory( vol, NULL, NULL, 0 ) ) return FALSE;
	return TRUE;
}
//-------------------------------------------------------
// function to process a currently loaded program to get the
// data offset at the end of the executable.
static POINTER GetExtraData( POINTER block )
{
#ifdef WIN32
#  define Seek(a,b) (((uintptr_t)a)+(b))
	//uintptr_t source_memory_length = block_len;
	POINTER source_memory = block;
	{
		PIMAGE_DOS_HEADER source_dos_header = (PIMAGE_DOS_HEADER)source_memory;
		PIMAGE_NT_HEADERS source_nt_header = (PIMAGE_NT_HEADERS)Seek( source_memory, source_dos_header->e_lfanew );
		if( source_dos_header->e_magic != IMAGE_DOS_SIGNATURE ) {
			LoG( "Basic signature check failed; not a library" );
			return NULL;
		}
		if( source_nt_header->Signature != IMAGE_NT_SIGNATURE ) {
			LoG( "Basic NT signature check failed; not a library" );
			return NULL;
		}
		if( source_nt_header->FileHeader.SizeOfOptionalHeader )
		{
			if( source_nt_header->OptionalHeader.Magic != IMAGE_NT_OPTIONAL_HDR_MAGIC )
			{
				LoG( "Optional header signature is incorrect..." );
				return NULL;
			}
		}
		{
			int n;
			long FPISections = source_dos_header->e_lfanew
				+ sizeof( DWORD ) + sizeof( IMAGE_FILE_HEADER )
				+ source_nt_header->FileHeader.SizeOfOptionalHeader;
			PIMAGE_SECTION_HEADER source_section = (PIMAGE_SECTION_HEADER)Seek( source_memory, FPISections );
			uintptr_t dwSize = 0;
			uintptr_t newSize;
			source_section = (PIMAGE_SECTION_HEADER)Seek( source_memory, FPISections );
			for( n = 0; n < source_nt_header->FileHeader.NumberOfSections; n++ )
			{
				newSize = (source_section[n].PointerToRawData) + source_section[n].SizeOfRawData;
				if( newSize > dwSize )
					dwSize = newSize;
			}
 // pad 1 full block, plus all but 1 byte of a full block(round up)
			dwSize += (BLOCK_SIZE*2)-1;
 // mask off the low bits; floor result to block boundary
			dwSize &= ~(BLOCK_SIZE-1);
			return (POINTER)Seek( source_memory, dwSize );
		}
	}
#  undef Seek
#else
	// need to get elf size...
	return 0;
#endif
}
static void AddSalt2( uintptr_t psv, POINTER *salt, size_t *salt_size ) {
	struct datatype { void* start; size_t length; } *data = (struct datatype*)psv;
	(*salt_size) = data->length;
	(*salt) = (POINTER)data->start;
	// only need to make one pass of it....
	data->length = 0;
	data->start = NULL;
}
const uint8_t *sack_vfs_get_signature2( POINTER disk, POINTER diskReal ) {
	if( disk != diskReal ) {
		static uint8_t usekey[BLOCK_SIZE];
		static struct random_context *entropy;
		static struct datatype { void* start; size_t length; } data;
		data.start = diskReal;
		data.length = ((uintptr_t)disk - (uintptr_t)diskReal) - BLOCK_SIZE;
		if( !entropy ) entropy = SRG_CreateEntropy2( AddSalt2, (uintptr_t)&data );
		SRG_ResetEntropy( entropy );
		SRG_GetEntropyBuffer( entropy, (uint32_t*)usekey, BLOCK_SIZE*CHAR_BIT );
		return usekey;
	}
	return NULL;
}
// add some space to the volume....
static LOGICAL ExpandVolume( struct sack_vfs_volume *vol ) {
	LOGICAL created;
	//LOGICAL path_checked = FALSE;
	struct sack_vfs_disk* new_disk;
	BLOCKINDEX oldsize = (BLOCKINDEX)vol->dwSize;
	if( vol->read_only ) return TRUE;
	if( !vol->dwSize ) {
		{
			char *tmp = StrDup( vol->volname );
			char *dir = (char*)pathrchr( tmp );
			if( dir ) {
				dir[0] = 0;
				if( !IsPath( tmp ) ) MakePath( tmp );
			}
			Deallocate( char*, tmp );
		}
		new_disk = (struct sack_vfs_disk*)OpenSpaceExx( NULL, vol->volname, 0, &vol->dwSize, &created );
		if( new_disk && vol->dwSize ) {
			if( vol->dwSize & BLOCK_MASK ) {
				size_t oldSize = vol->dwSize;
				lprintf( "DISK IS A BAD SIZE... trying to fix!" );
				Release( new_disk );
				vol->dwSize = (vol->dwSize + BLOCK_SIZE) & ~BLOCK_MASK;
				new_disk = (struct sack_vfs_disk*)OpenSpaceExx( NULL, vol->volname, 0, &vol->dwSize, &created );
				if( !(vol->dwSize & BLOCK_MASK) ) {
					MemSet( ((uint8_t*)new_disk) + oldSize, 0, vol->dwSize - oldSize );
					lprintf( "DISK SHOULD BE OK now" );
				}
				else {
					DebugBreak();
				}
			}
			CloseSpace( vol->diskReal );
			vol->diskReal = new_disk;
#ifdef WIN32
			// elf has a different signature to check for .so extended data...
			struct sack_vfs_disk *actual_disk;
			if( ((char*)new_disk)[0] == 'M' && ((char*)new_disk)[1] == 'Z' ) {
				actual_disk = (struct sack_vfs_disk*)GetExtraData( new_disk );
				if( actual_disk ) {
					if( ( ( (uintptr_t)actual_disk - (uintptr_t)new_disk ) < vol->dwSize ) ) {
						lprintf( "Size to check %zd", (uintptr_t)actual_disk - (uintptr_t)new_disk );
						const uint8_t *sig = sack_vfs_get_signature2( (POINTER)((uintptr_t)actual_disk-BLOCK_SIZE), new_disk );
						LogBinary( sig, BLOCK_SIZE / 2 );
						if( memcmp( sig, (POINTER)(((uintptr_t)actual_disk)-BLOCK_SIZE), BLOCK_SIZE/2 ) ) {
							lprintf( "Signature failed comparison; the core has changed since it was attached." );
							CloseSpace( vol->diskReal );
							vol->diskReal = NULL;
							vol->dwSize = 0;
							return FALSE;
						}
						{
							char* check_sig = (char*)( ( (uintptr_t)actual_disk ) - BLOCK_SIZE / 2 );
							int ofs;
							for( ofs = 0; ofs < BLOCK_SIZE / 2; ofs++ ) if( check_sig[0] ) break; else check_sig++;
							if( ofs < ( BLOCK_SIZE / 2 ) ){
								const uint8_t* sig = sack_vfs_get_signature2( (POINTER)( (uintptr_t)actual_disk + vol->dwSize - ((uintptr_t)actual_disk - (uintptr_t)new_disk)), actual_disk );
								if( memcmp( sig, (POINTER)( ( (uintptr_t)actual_disk ) - BLOCK_SIZE/2 ), BLOCK_SIZE / 2 ) ){
									lprintf( "Payload signature failed." );
									CloseSpace( vol->diskReal );
									vol->diskReal = NULL;
									vol->dwSize = 0;
									return FALSE;
								}
							}
						}
						vol->dwSize -= ((uintptr_t)actual_disk - (uintptr_t)new_disk);
						new_disk = actual_disk;
					} else {
						lprintf( "Signature failed comparison; the core is not attached to anything." );
						CloseSpace( vol->diskReal );
						vol->diskReal = NULL;
						vol->dwSize = 0;
						return FALSE;
					}
				}
			}
#endif
			vol->disk = new_disk;
			if( created && vol->disk == vol->diskReal ) {
				enum block_cache_entries cache = BC(DIRECTORY);
				//struct directory_entry *next_entries =
					BTSEEK( struct directory_entry *, vol, 0, cache );
				struct directory_entry *entkey = (vol->key) ? ((struct directory_entry *)vol->usekey[cache]) : &l.zero_entkey;
				// initialize directory list.
				((struct directory_entry*)(((uintptr_t)vol->disk) + BLOCK_SIZE))->first_block = EODMARK ^ entkey->first_block;
				// initialize first BAT block.
				cache = BC(BAT);
				TSEEK( BLOCKINDEX*, vol, 0, cache );
				((BLOCKINDEX*)(((uintptr_t)vol->disk) + 0))[0] = EOBBLOCK ^ ((BLOCKINDEX*)vol->usekey[cache])[0];
			}
			return TRUE;
		}
		else {
			// really this is bad anyway.
			if( new_disk )
 // zero size result?, but with memory
				created = 1;
			else
				vol->dwSize = 0;
		}
	}
	if( oldsize ) CloseSpace( vol->diskReal );
	vol->dwSize += ((uintptr_t)vol->disk - (uintptr_t)vol->diskReal);
	// a BAT plus the sectors it references... ( BLOCKS_PER_BAT + 1 ) * BLOCK_SIZE
	vol->dwSize += BLOCKS_PER_SECTOR*BLOCK_SIZE;
	new_disk = (struct sack_vfs_disk*)OpenSpaceExx( NULL, vol->volname, 0, &vol->dwSize, &created );
	if( !new_disk ) {
		DebugBreak();
	}
	LoG( "created expanded volume: %p from %p size:%" _size_f, new_disk, vol->disk, vol->dwSize );
	if( new_disk && new_disk != vol->disk ) {
		INDEX idx;
		struct sack_vfs_file *file;
		CloseSpace( vol->diskReal );
		vol->diskReal = new_disk;
#ifdef WIN32
		// elf has a different signature to check for .so extended data...
		{
			struct sack_vfs_disk *actual_disk;
			if( ((char*)new_disk)[0] == 'M' && ((char*)new_disk)[1] == 'Z' ) {
				actual_disk = (struct sack_vfs_disk*)GetExtraData( new_disk );
				if( actual_disk ) {
					const uint8_t *sig = sack_vfs_get_signature2( (POINTER)((uintptr_t)actual_disk-BLOCK_SIZE), new_disk );
					if( memcmp( sig, (POINTER)(((uintptr_t)actual_disk)-BLOCK_SIZE), BLOCK_SIZE/2 ) ) {
						lprintf( "Signature failed comparison; the core has changed since it was attached" );
						CloseSpace( vol->diskReal );
						vol->diskReal = NULL;
						vol->dwSize = 0;
						return FALSE;
					}
					{
						char* check_sig = (char*)( ( (uintptr_t)actual_disk ) - BLOCK_SIZE / 2 );
						int ofs;
						for( ofs = 0; ofs < BLOCK_SIZE / 2; ofs++ ) if( check_sig[0] ) break; else check_sig++;
						if( ofs < ( BLOCK_SIZE / 2 ) ){
							const uint8_t* sig = sack_vfs_get_signature2( (POINTER)( (uintptr_t)actual_disk + vol->dwSize - ( (uintptr_t)actual_disk - (uintptr_t)new_disk ) ), actual_disk );
							if( memcmp( sig, (POINTER)( ( (uintptr_t)actual_disk ) - BLOCK_SIZE / 2 ), BLOCK_SIZE / 2 ) ){
								lprintf( "Payload signature failed." );
								CloseSpace( vol->diskReal );
								vol->diskReal = NULL;
								vol->dwSize = 0;
								return FALSE;
							}
						}
					}
					vol->dwSize -= ((uintptr_t)actual_disk - (uintptr_t)new_disk);
					new_disk = actual_disk;
				}
			}
		}
#endif
		LIST_FORALL( vol->files, idx, struct sack_vfs_file *, file ) {
			file->entry = (struct directory_entry*)((uintptr_t)file->entry - (uintptr_t)vol->disk + (uintptr_t)new_disk);
		}
		vol->disk = new_disk;
	}
	if( vol->key ) {
		BLOCKINDEX first_slab = oldsize / ( BLOCK_SIZE );
		BLOCKINDEX slab = vol->dwSize / ( BLOCK_SIZE );
		BLOCKINDEX n;
		for( n = first_slab; n < slab; n++  ) {
			//vol->segment[BC(BAT)] = n + 1;
			if( ( n % (BLOCKS_PER_SECTOR) ) == 0 )	 UpdateSegmentKey( vol, BC(BAT), n + 1 );
#ifdef PARANOID_INIT
			else SRG_GetEntropyBuffer( vol->entropy, (uint32_t*)vol->usekey[BC(BAT)], BLOCK_SIZE * 8 );
#else
			else continue;
#endif
			//memcpy( ((uint8_t*)vol->disk) + n * BLOCK_SIZE, vol->usekey[BC(BAT)], BLOCK_SIZE );
			((BLOCKINDEX*)(((uint8_t*)vol->disk) + n * BLOCK_SIZE))[0] = EOBBLOCK ^ ((BLOCKINDEX*)vol->usekey[BC(BAT)])[0];
			memset( ((BLOCKINDEX*)(((uint8_t*)vol->disk) + n * BLOCK_SIZE))+1, 0, BLOCK_SIZE - sizeof( BLOCKINDEX ) );
		}
	}
	else if( !oldsize )  {
		memset( vol->disk, 0, vol->dwSize );
	} else if( oldsize )  {
		memset( ((uint8_t*)vol->disk) + oldsize, 0, (size_t)(vol->dwSize - oldsize) );
	}
	if( !oldsize ) {
		// can't recover dirents and nameents dynamically; so just assume
		// use the GetFreeBlock because it will update encypted
		//vol->disk->BAT[0] = EOFBLOCK;  // allocate 1 directory entry block
		//vol->disk->BAT[1] = EOFBLOCK;  // allocate 1 name block
		if( created && vol->disk == vol->diskReal ) {
			UpdateSegmentKey( vol, BC(BAT), 1 );
			((BLOCKINDEX*)(((uintptr_t)vol->disk) + 0))[0] = EOBBLOCK ^ ((BLOCKINDEX*)vol->usekey[BC(BAT)])[0];
		}
		/* vol->dirents = */
GetFreeBlock( vol, GFB_INIT_DIRENT );
		/* vol->nameents = */
GetFreeBlock( vol, GFB_INIT_NAMES );
	}
	return TRUE;
}
// shared with fuse module
uintptr_t vfs_SEEK( struct sack_vfs_volume *vol, FPI offset, enum block_cache_entries *cache_index ) {
	while( offset >= vol->dwSize ) if( !ExpandVolume( vol ) ) return 0;
	if( vol->key ) {
		BLOCKINDEX seg = ( offset / BLOCK_SIZE ) + 1;
		if( seg != vol->segment[cache_index[0]] ) {
			//vol->segment[cache_index] = seg;
			cache_index[0] = UpdateSegmentKey( vol, cache_index[0], seg );
		}
	}
	return ((uintptr_t)vol->disk) + (uintptr_t)offset;
}
// shared with fuse module
uintptr_t vfs_BSEEK( struct sack_vfs_volume *vol, BLOCKINDEX block, enum block_cache_entries *cache_index ) {
	BLOCKINDEX b = BLOCK_SIZE + (block >> BLOCK_BAT_SHIFT ) * (BLOCKS_PER_SECTOR*BLOCK_SIZE) + ( block & (BLOCKS_PER_BAT-1) ) * BLOCK_SIZE;
	while( b >= vol->dwSize ) if( !ExpandVolume( vol ) ) return 0;
	if( vol->key ) {
		BLOCKINDEX seg = ( b / BLOCK_SIZE ) + 1;
		if( seg != vol->segment[cache_index[0]] ) {
			//vol->segment[cache_index] = seg;
			if( (cache_index[0] == BC(FILE))
				&& (seg < 3) ) {
				lprintf( "CRITICAL FAILURE, SEEK OUT OF DISK %d", (int)seg );
#ifdef __clang__
				__builtin_trap();
#else
				( *(int*)0 ) = 0;
#endif
			}
			cache_index[0] = UpdateSegmentKey( vol, cache_index[0], seg );
		}
	}
	return ((uintptr_t)vol->disk) + (uintptr_t)b;
}
static BLOCKINDEX GetFreeBlock( struct sack_vfs_volume *vol, int init )
{
	size_t n;
	BLOCKINDEX b = 0;
	enum block_cache_entries cache = BC(BAT);
	// don't need to init to 0 anymore.
// = TSEEK( BLOCKINDEX*, vol, 0, cache );
	BLOCKINDEX *current_BAT;
	BLOCKINDEX *blockKey;
	BLOCKINDEX check_val;
	BLOCKINDEX result;
	if( vol->pdlFreeBlocks->Cnt ) {
		BLOCKINDEX newblock = ((BLOCKINDEX*)GetDataItem( &vol->pdlFreeBlocks, vol->pdlFreeBlocks->Cnt - 1 ))[0];
		LoGB( "Got free block from existin tracked blocks:%d", newblock );
		check_val = 0;
		b = newblock / BLOCKS_PER_BAT;
		n = newblock % BLOCKS_PER_BAT;
		vol->pdlFreeBlocks->Cnt--;
	}
	else {
		check_val = EOBBLOCK;
		b = vol->lastBatBlock / BLOCKS_PER_BAT;
		n = vol->lastBatBlock % BLOCKS_PER_BAT;
	}
#ifdef DEBUG_BLOCK_TRACKING
	LoG( "(should be 0(free in-bat) or 1(end of tracked)) check, start, b, n %d %d %d %d", (int)check_val, (int) vol->lastBatBlock, (int)b, (int)n );
#endif
	current_BAT = TSEEK( BLOCKINDEX*, vol, b*BLOCKS_PER_SECTOR*BLOCK_SIZE, cache ) + n;
	blockKey = ((BLOCKINDEX*)vol->usekey[cache]) + n;
	result = b * BLOCKS_PER_BAT + n;
	if( !current_BAT ) return 0;
	current_BAT[0] = EOFBLOCK ^ blockKey[0];
	LoGB( "Write to BAT: EOF at %d  %d", (int)n, result );
	if( (check_val == EOBBLOCK) ) {
		if( n < (BLOCKS_PER_BAT - 1) ) {
			current_BAT[1] = EOBBLOCK ^ blockKey[1];
			LoGB( "Write to BAT: EOB at %d  %d", (int)n+1, result + 1 );
			vol->lastBatBlock++;
		}
		else {
			cache = BC( BAT );
			LoG( "Expanding disk Here, get next block block.");
			current_BAT = TSEEK( BLOCKINDEX*, vol, (b + 1) * (BLOCKS_PER_SECTOR*BLOCK_SIZE), cache );
			blockKey = ((BLOCKINDEX*)vol->usekey[cache]);
			current_BAT[0] = EOBBLOCK ^ blockKey[0];
			LoGB( "Write to BAT: EOF at %d  %d", (int)0, (b+1) * BLOCKS_PER_BAT );
			vol->lastBatBlock = (b + 1) * BLOCKS_PER_BAT;
			//lprintf( "Set last block....%d", (int)vol->lastBatBlock );
		}
	}
	if( init ) {
		enum block_cache_entries cache;
		if( init == GFB_INIT_DIRENT )
			cache = BC( DIRECTORY );
		else if( init == GFB_INIT_NAMES )
			cache = BC( NAMES );
		else
			cache = BC( FILE );
		while( ((b * BLOCKS_PER_SECTOR +n) * BLOCK_SIZE) > vol->dwSize ) {
			LoG( "looping to get a size %d", ((vol->segment[cache] - 1)*BLOCK_SIZE) );
			if( !ExpandVolume( vol ) ) return 0;
		}
		if( init == GFB_INIT_DIRENT ) {
			uint8_t* dirsec = (uint8_t*)vfs_BSEEK( vol, result, &cache );
			((struct directory_entry*)dirsec)->first_block = EODMARK ^ ((struct directory_entry*)vol->usekey[cache])->first_block;
			//((struct directory_entry*)(((uint8_t*)vol->disk) + (vol->segment[cache] - 1) * BLOCK_SIZE))[0].first_block = EODMARK ^ ((struct directory_entry*)vol->usekey[cache])->first_block;
		}
		else if( init == GFB_INIT_NAMES ) {
			uint8_t* namesec = (uint8_t*)vfs_BSEEK( vol, result, &cache );
			((char*)namesec)[0] = ((char*)vol->usekey[cache])[0];
			//((char*)(((uint8_t*)vol->disk) + (vol->segment[cache] - 1) * BLOCK_SIZE))[0] = ((char*)vol->usekey[cache])[0];
		}
		//else
		//	memcpy( ((uint8_t*)vol->disk) + (vol->segment[cache]-1) * BLOCK_SIZE, vol->usekey[cache], BLOCK_SIZE );
	}
	//lprintf( "Return block:%d   %d  %d", (int)(b*BLOCKS_PER_BAT + n), (int)b, (int)n );
	return result;
}
static BLOCKINDEX vfs_GetNextBlock( struct sack_vfs_volume *vol, BLOCKINDEX block, int init, LOGICAL expand ) {
	BLOCKINDEX sector = block / BLOCKS_PER_BAT;
	enum block_cache_entries cache = BC(BAT);
	BLOCKINDEX *this_BAT = TSEEK( BLOCKINDEX *, vol, sector * (BLOCKS_PER_SECTOR*BLOCK_SIZE), cache );
	BLOCKINDEX seg;
	BLOCKINDEX check_val;
 // if this passes, later ones will also.
	if( !this_BAT ) return 0;
	seg = ( ((uintptr_t)this_BAT - (uintptr_t)vol->disk) / BLOCK_SIZE ) + 1;
	if( seg != vol->segment[cache] ) {
		//vol->segment[BC(BAT)] = seg;
		UpdateSegmentKey( vol, cache, seg );
	}
	check_val = (this_BAT[block & (BLOCKS_PER_BAT - 1)]) ^ ((BLOCKINDEX*)vol->usekey[cache])[block & (BLOCKS_PER_BAT-1)];
	if( check_val == EOBBLOCK ) {
		lprintf( "the file itself should never get a EOBBLOCK in it. %d  %d", (int)block, (int)sector );
#ifdef __clang__
		__builtin_trap();
#else
		( *(int*)0 ) = 0;
#endif
		// the file itself should never get a EOBBLOCK in it.
		//(this_BAT[block & (BLOCKS_PER_BAT-1)]) = EOFBLOCK^((BLOCKINDEX*)vol->usekey[BC(BAT)])[block & (BLOCKS_PER_BAT-1)];
		//(this_BAT[1+block & (BLOCKS_PER_BAT-1)]) = EOBBLOCK^((BLOCKINDEX*)vol->usekey[BC(BAT)])[1+block & (BLOCKS_PER_BAT-1)];
	}
	if( check_val == EOFBLOCK ) {
		if( expand ) {
			BLOCKINDEX key;
			check_val = GetFreeBlock( vol, init );
			// free block might have expanded...
			cache = BC( BAT );
			this_BAT = TSEEK( BLOCKINDEX*, vol, sector * ( BLOCKS_PER_SECTOR*BLOCK_SIZE ), cache );
			key = ((BLOCKINDEX*)vol->usekey[cache])[block & (BLOCKS_PER_BAT - 1)];
			if( !this_BAT ) return 0;
#ifdef _DEBUG
			if( !block && init != GFB_INIT_DIRENT ) DebugBreak();
#endif
			// segment could already be set from the GetFreeBlock...
			this_BAT[block & (BLOCKS_PER_BAT-1)] = check_val ^ key;
			LoGB( "Write to BAT: Chain %d at %d  %d  %p", check_val, (int)(block&(BLOCKS_PER_BAT-1)), block, this_BAT );
		}
	}
	return check_val;
}
static void AddSalt( uintptr_t psv, POINTER *salt, size_t *salt_size ) {
	struct sack_vfs_volume *vol = (struct sack_vfs_volume *)psv;
	if( vol->sigsalt ) {
		(*salt_size) = vol->sigkeyLength;
		(*salt) = (POINTER)vol->sigsalt;
		vol->sigsalt = NULL;
	}
	else if( vol->datakey ) {
		(*salt_size) = BLOCK_SIZE;
		(*salt) = (POINTER)vol->datakey;
		vol->datakey = NULL;
	}
	else if( vol->userkey ) {
		(*salt_size) = StrLen( vol->userkey );
		(*salt) = (POINTER)vol->userkey;
		vol->userkey = NULL;
	}
	else if( vol->devkey ) {
		(*salt_size) = StrLen( vol->devkey );
		(*salt) = (POINTER)vol->devkey;
		vol->devkey = NULL;
	}
	else if( vol->segment[vol->curseg] ) {
		BLOCKINDEX sector = vol->segment[vol->curseg];
		switch( vol->clusterKeyVersion ) {
		case 0:
			( *salt_size ) = sizeof( vol->segment[vol->curseg] );
			( *salt ) = &vol->segment[vol->curseg];
			break;
		case 1:
			memcpy( vol->tmpSalt, vol->key, 16 );
			vol->tmpSalt[sector & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[0];
			vol->tmpSalt[( sector >> 4 ) & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[1];
			vol->tmpSalt[( sector >> 8 ) & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[2];
			vol->tmpSalt[( sector >> 12 ) & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[3];
			( (BLOCKINDEX*)vol->tmpSalt )[0] ^= sector;
			( (BLOCKINDEX*)vol->tmpSalt )[1] ^= sector;
// sizeof( vol->segment[vol->curseg] );
			( *salt_size ) = 12;
			( *salt ) = vol->tmpSalt;
			break;
		}
	}
	else
		(*salt_size) = 0;
}
static void AssignKey( struct sack_vfs_volume *vol, const char *key1, const char *key2 )
{
	vol->userkey = key1;
	vol->devkey = key2;
	if( key1 || key2 )
	{
		uintptr_t size = BLOCK_SIZE + BLOCK_SIZE * BC(COUNT) + BLOCK_SIZE + SHORTKEY_LENGTH;
		int n;
		if( !vol->entropy )
			vol->entropy = SRG_CreateEntropy2( AddSalt, (uintptr_t)vol );
		else
			SRG_ResetEntropy( vol->entropy );
		vol->key = (uint8_t*)OpenSpace( NULL, NULL, &size );
		for( n = 0; n < BC(COUNT); n++ ) {
			vol->usekey[n] = vol->key + (n + 1) * BLOCK_SIZE;
			vol->segment[n] = 0;
		}
		vol->segkey = vol->key + BLOCK_SIZE * (BC(COUNT) + 1);
		vol->sigkey = vol->key + BLOCK_SIZE * (BC(COUNT) + 1) + SHORTKEY_LENGTH;
		vol->curseg = BC(DIRECTORY);
		vol->segment[BC(DIRECTORY)] = 0;
		SRG_GetEntropyBuffer( vol->entropy, (uint32_t*)vol->key, BLOCK_SIZE * 8 );
	}
	else {
		int n;
		for( n = 0; n < BC(COUNT); n++ )
			vol->usekey[n] = l.zerokey;
		vol->segkey = l.zerokey;
		vol->sigkey = l.zerokey;
		vol->key = NULL;
	}
}
struct sack_vfs_volume *sack_vfs_load_volume( const char * filepath )
{
	struct sack_vfs_volume *vol = New( struct sack_vfs_volume );
	memset( vol, 0, sizeof( struct sack_vfs_volume ) );
	vol->pdlFreeBlocks = CreateDataList( sizeof( BLOCKINDEX ) );
	vol->volname = SaveText( filepath );
	AssignKey( vol, NULL, NULL );
	if( !ExpandVolume( vol ) || !ValidateBAT( vol ) ) { Deallocate( struct sack_vfs_volume*, vol ); return NULL; }
	return vol;
}
struct sack_vfs_volume *sack_vfs_load_crypt_volume( const char * filepath, uintptr_t version, const char * userkey, const char * devkey ) {
	struct sack_vfs_volume *vol = New( struct sack_vfs_volume );
	MemSet( vol, 0, sizeof( struct sack_vfs_volume ) );
	if( !version ) version = 2;
	vol->pdlFreeBlocks = CreateDataList( sizeof( BLOCKINDEX ) );
	vol->clusterKeyVersion = version - 1;
	vol->volname = SaveText( filepath );
	vol->userkey = userkey;
	vol->devkey = devkey;
	AssignKey( vol, userkey, devkey );
	if( !ExpandVolume( vol ) || !ValidateBAT( vol ) ) { sack_vfs_unload_volume( vol ); return NULL; }
	return vol;
}
struct sack_vfs_volume *sack_vfs_use_crypt_volume( POINTER memory, size_t sz, uintptr_t version, const char * userkey, const char * devkey ) {
	struct sack_vfs_volume *vol = New( struct sack_vfs_volume );
	MemSet( vol, 0, sizeof( struct sack_vfs_volume ) );
	vol->read_only = 1;
	AssignKey( vol, userkey, devkey );
	if( !version ) version = 2;
	vol->pdlFreeBlocks = CreateDataList( sizeof( BLOCKINDEX ) );
	vol->clusterKeyVersion = version - 1;
	vol->external_memory = TRUE;
	vol->diskReal = (struct sack_vfs_disk*)memory;
	vol->dwSize = sz;
#ifdef WIN32
	// elf has a different signature to check for .so extended data...
	struct sack_vfs_disk *actual_disk;
	if( ((char*)memory)[0] == 'M' && ((char*)memory)[1] == 'Z' ) {
		actual_disk = (struct sack_vfs_disk*)GetExtraData( memory );
		if( actual_disk ) {
			if( ( ( (uintptr_t)actual_disk - (uintptr_t)memory ) < vol->dwSize ) ) {
				const uint8_t *sig = sack_vfs_get_signature2( (POINTER)(((uintptr_t)actual_disk)-BLOCK_SIZE), memory );
				if( memcmp( sig, (POINTER)(((uintptr_t)actual_disk)-BLOCK_SIZE), BLOCK_SIZE/2 ) ) {
					lprintf( "Signature failed comparison; the core has changed since it was attached" );
					vol->diskReal = NULL;
					vol->dwSize = 0;
					sack_vfs_unload_volume( vol );
					return FALSE;
				}
				{
					char* check_sig = (char*)( ( (uintptr_t)actual_disk ) - BLOCK_SIZE / 2 );
					int ofs;
					for( ofs = 0; ofs < BLOCK_SIZE / 2; ofs++ ) if( check_sig[0] ) break; else check_sig++;
					if( ofs < ( BLOCK_SIZE / 2 ) ){
						const uint8_t* sig = sack_vfs_get_signature2( (POINTER)( (uintptr_t)actual_disk + vol->dwSize - ( (uintptr_t)actual_disk - (uintptr_t)memory ) ), actual_disk );
						if( memcmp( sig, (POINTER)( ( (uintptr_t)actual_disk ) - BLOCK_SIZE / 2 ), BLOCK_SIZE / 2 ) ){
							lprintf( "Payload signature failed." );
							vol->diskReal = NULL;
							vol->dwSize = 0;
							return FALSE;
						}
					}
				}
				vol->dwSize -= ((uintptr_t)actual_disk - (uintptr_t)memory);
				memory = (POINTER)actual_disk;
			} else {
				// not enough length to have a volume.
				vol->diskReal = NULL;
				vol->disk = NULL;
				vol->dwSize = 0;
				sack_vfs_unload_volume( vol );
				return NULL;
			}
		}
	}
#endif
	vol->disk = (struct sack_vfs_disk*)memory;
	if( !ValidateBAT( vol ) ) { sack_vfs_unload_volume( vol );  return NULL; }
	return vol;
}
void sack_vfs_unload_volume( struct sack_vfs_volume * vol ) {
	INDEX idx;
	struct sack_vfs_file *file;
	LIST_FORALL( vol->files, idx, struct sack_vfs_file *, file )
		break;
	if( file ) {
		vol->closed = TRUE;
		return;
	}
	DeleteListEx( &vol->files DBG_SRC );
	DeleteDataList( &vol->pdlFreeBlocks );
	if( !vol->external_memory )	CloseSpace( vol->diskReal );
	if( vol->key ) {
		Deallocate( uint8_t*, vol->key );
		SRG_DestroyEntropy( &vol->entropy );
	}
	Deallocate( struct sack_vfs_volume*, vol );
}
void sack_vfs_shrink_volume( struct sack_vfs_volume * vol ) {
	size_t n;
	BLOCKINDEX b = 0;
	//int found_free; // this block has free data; should be last BAT?
	BLOCKINDEX last_block = 0;
	BLOCKINDEX last_bat = 0;
	enum block_cache_entries cache = BC(BAT);
	BLOCKINDEX *current_BAT = TSEEK( BLOCKINDEX*, vol, 0, cache );
 // expand failed, tseek failed in response, so don't do anything
	if( !current_BAT ) return;
	do {
		BLOCKINDEX check_val;
		BLOCKINDEX *blockKey;
		blockKey = (BLOCKINDEX*)vol->usekey[cache];
		for( n = 0; n < BLOCKS_PER_BAT; n++ ) {
			check_val = *(current_BAT++);
			if( vol->key )	check_val ^= *(blockKey++);
			if( check_val ) {
				last_bat = b;
				last_block = n;
			}
		}
		b++;
		if( b * ( BLOCKS_PER_SECTOR*BLOCK_SIZE) < vol->dwSize ) {
			current_BAT = TSEEK( BLOCKINDEX*, vol, b * ( BLOCKS_PER_SECTOR*BLOCK_SIZE), cache );
		} else
			break;
	}while( 1 );
	CloseSpace( vol->diskReal );
	SetFileLength( vol->volname,
			((uintptr_t)vol->disk - (uintptr_t)vol->diskReal) +
			(size_t)(last_bat * BLOCKS_PER_SECTOR * BLOCK_SIZE + ( last_block + 1 + 1 )* BLOCK_SIZE) );
	// setting 0 size will cause expand to do an initial open instead of expanding
	vol->diskReal = NULL;
	vol->dwSize = 0;
}
static void mask_block( struct sack_vfs_volume *vol, size_t n ) {
	BLOCKINDEX b = ( 1 + (n >> BLOCK_INDEX_SHIFT) * (BLOCKS_PER_SECTOR) + (n & (BLOCKS_PER_BAT - 1)));
	UpdateSegmentKey( vol, BC(DATAKEY), b + 1 );
	{
#ifdef __64__
		uint64_t* usekey = (uint64_t*)vol->usekey[BC(DATAKEY)];
		uint64_t* block = (uint64_t*)(((uintptr_t)vol->disk) + b * BLOCK_SIZE );
		for( n = 0; n < (BLOCK_SIZE / 16); n++ ) {
			block[0] = block[0] ^ usekey[0];
			block[1] = block[1] ^ usekey[1];
			block += 2; usekey += 2;
		}
#else
		uint32_t* usekey = (uint32_t*)vol->usekey[BC(DATAKEY)];
		uint32_t* block = (uint32_t*)(((uintptr_t)vol->disk) + b * BLOCK_SIZE );
		for( n = 0; n < (BLOCK_SIZE / 16); n++ ) {
			block[0] = block[0] ^ usekey[0];
			block[1] = block[1] ^ usekey[1];
			block[2] = block[2] ^ usekey[2];
			block[3] = block[3] ^ usekey[3];
			block += 4; usekey += 4;
		}
#endif
	}
}
LOGICAL sack_vfs_decrypt_volume( struct sack_vfs_volume *vol )
{
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	while( vol->locked_thread && vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
 // volume is already decrypted, cannot remove key
	if( !vol->key ) { vol->lock = 0; return FALSE; }
	{
		enum block_cache_entries cache = BC(BAT);
		size_t n;
		BLOCKINDEX slab = vol->dwSize / ( BLOCKS_PER_SECTOR * BLOCK_SIZE );
		for( n = 0; n < slab; n++  ) {
			size_t m;
			BLOCKINDEX *blockKey;
// = (BLOCKINDEX*)(((uint8_t*)vol->disk) + n * (BLOCKS_PER_SECTOR * BLOCK_SIZE));
			BLOCKINDEX *block;
			block = TSEEK( BLOCKINDEX*, vol, n * (BLOCKS_PER_SECTOR*BLOCK_SIZE), cache );
			blockKey = ((BLOCKINDEX*)vol->usekey[cache]);
			for( m = 0; m < BLOCKS_PER_BAT; m++ ) {
				block[0] ^= blockKey[0];
				if( block[0] == EOBBLOCK ) break;
				else if( block[0] ) mask_block( vol, (n*BLOCKS_PER_BAT) + m );
				block++;
				blockKey++;
			}
			if( m < BLOCKS_PER_BAT ) break;
		}
	}
	AssignKey( vol, NULL, NULL );
	vol->lock = 0;
	return TRUE;
}
LOGICAL sack_vfs_encrypt_volume( struct sack_vfs_volume *vol, uintptr_t version, CTEXTSTR key1, CTEXTSTR key2 ) {
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	while( vol->locked_thread && vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
 // volume already has a key, cannot apply new key
	if( vol->key ) { vol->lock = 0; return FALSE; }
	if( !version ) version = 2;
	vol->clusterKeyVersion = version-1;
	AssignKey( vol, key1, key2 );
	{
		int done;
		size_t n;
		enum block_cache_entries cache = BC(BAT);
		BLOCKINDEX slab = (vol->dwSize + (BLOCKS_PER_SECTOR*BLOCK_SIZE-1)) / ( BLOCKS_PER_SECTOR * BLOCK_SIZE );
		done = 0;
		for( n = 0; n < slab; n++  ) {
			size_t m;
			BLOCKINDEX *blockKey;
// = (BLOCKINDEX*)(((uint8_t*)vol->disk) + n * (BLOCKS_PER_SECTOR * BLOCK_SIZE));
			BLOCKINDEX *block;
			block = TSEEK( BLOCKINDEX*, vol, n * (BLOCKS_PER_SECTOR*BLOCK_SIZE), cache );
			blockKey = ((BLOCKINDEX*)vol->usekey[cache]);
			for( m = 0; m < BLOCKS_PER_BAT; m++ ) {
				if( block[0] == EOBBLOCK ) done = TRUE;
				else if( block[0] ) mask_block( vol, (n*BLOCKS_PER_BAT) + m );
				block[0] ^= blockKey[0];
				if( done ) break;
				block++;
				blockKey++;
			}
			if( done ) break;
		}
	}
	vol->lock = 0;
	return TRUE;
}
const char *sack_vfs_get_signature( struct sack_vfs_volume *vol ) {
	static char signature[257];
	static const char *output = "0123456789ABCDEF";
	if( !vol )
		return NULL;
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	while( vol->locked_thread && vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	{
		static BLOCKINDEX datakey[BLOCKS_PER_BAT];
		uint8_t* usekey = vol->key?vol->usekey[BC(DATAKEY)]:l.zerokey;
		signature[256] = 0;
		memset( datakey, 0, sizeof( datakey ) );
		{
			{
				size_t n;
				BLOCKINDEX this_dir_block = 0;
				BLOCKINDEX next_dir_block;
				BLOCKINDEX *next_entries;
				do {
					enum block_cache_entries cache = BC(DATAKEY);
					next_entries = BTSEEK( BLOCKINDEX *, vol, this_dir_block, cache );
					for( n = 0; n < BLOCKS_PER_BAT; n++ )
						datakey[n] ^= next_entries[n] ^ ((BLOCKINDEX*)(((uint8_t*)usekey)))[n];
					next_dir_block = vfs_GetNextBlock( vol, this_dir_block, GFB_INIT_DIRENT, FALSE );
#ifdef _DEBUG
					if( this_dir_block == next_dir_block )
						DebugBreak();
					if( next_dir_block == 0 )
						DebugBreak();
#endif
					this_dir_block = next_dir_block;
				}
				while( next_dir_block != EOFBLOCK );
			}
		}
		if( !vol->entropy )
			vol->entropy = SRG_CreateEntropy2( AddSalt, (uintptr_t)vol );
		SRG_ResetEntropy( vol->entropy );
		vol->curseg = BC(DIRECTORY);
		vol->segment[vol->curseg] = 0;
		vol->datakey = (const char *)datakey;
		SRG_GetEntropyBuffer( vol->entropy, (uint32_t*)usekey, 128 * 8 );
		{
			int n;
			for( n = 0; n < 128; n++ ) {
				signature[n*2] = output[( usekey[n] >> 4 ) & 0xF];
				signature[n*2+1] = output[usekey[n] & 0xF];
			}
		}
	}
	vol->lock = 0;
	return signature;
}
struct directory_entry * VFSScanDirectory( struct sack_vfs_volume *vol, const char * filename, struct directory_entry *dirkey, int path_match ) {
	size_t n;
	BLOCKINDEX this_dir_block = 0;
	BLOCKINDEX next_dir_block;
	struct directory_entry *next_entries;
	if( filename && filename[0] == '.' && filename[1] == '/' ) filename += 2;
	do {
		enum block_cache_entries cache = BC(DIRECTORY);
		next_entries = BTSEEK( struct directory_entry *, vol, this_dir_block, cache );
		for( n = 0; n < VFS_DIRECTORY_ENTRIES; n++ ) {
			BLOCKINDEX bi;
			enum block_cache_entries name_cache = BC(NAMES);
			struct directory_entry *entkey = ( vol->key)?((struct directory_entry *)vol->usekey[cache])+n:&l.zero_entkey;
			//const char * testname;
			FPI name_ofs = next_entries[n].name_offset ^ entkey->name_offset;
 // done.
			if( filename && !name_ofs )	return NULL;
			//LoG( "%d name_ofs = %" _size_f "(%" _size_f ") block = %d  vs %s"
			//   , n, name_ofs
			//   , next_entries[n].name_offset ^ entkey->name_offset
			//   , next_entries[n].first_block ^ entkey->first_block
			//   , filename );
			bi = next_entries[n].first_block ^ entkey->first_block;
			// if file is deleted; don't check it's name.
			if( !bi ) continue;
			// if file is end of directory, done sanning.
 // done.
			if( bi == EODMARK ) return filename?NULL:((struct directory_entry*)1);
			if( name_ofs > vol->dwSize ) { return NULL; }
			//testname =
			if( filename ) {
 // have to do the seek to the name block otherwise it might not be loaded.
				TSEEK( const char *, vol, name_ofs, name_cache );
				if( MaskStrCmp( vol, filename, name_ofs, path_match ) == 0 ) {
					if( dirkey ) dirkey[0] = (*entkey);
					LoG( "return found entry: %p (%" _size_f ":%" _size_f ") %s", next_entries + n, name_ofs, next_entries[n].first_block ^ dirkey->first_block, filename );
					return next_entries + n;
				}
			}
		}
		next_dir_block = vfs_GetNextBlock( vol, this_dir_block, GFB_INIT_DIRENT, TRUE );
		LoG( "this_dir_block was and will be:%d %d", this_dir_block, next_dir_block );
#ifdef _DEBUG
		if( this_dir_block == next_dir_block ) DebugBreak();
  // should have a last-entry before no more blocks....
		if( next_dir_block == 0 ) { DebugBreak(); return NULL; }
#endif
		this_dir_block = next_dir_block;
	}
	while( 1 );
}
// this results in an absolute disk position
static FPI SaveFileName( struct sack_vfs_volume *vol, const char * filename ) {
	size_t n;
	BLOCKINDEX this_name_block = 1;
	while( 1 ) {
		enum block_cache_entries cache = BC(NAMES);
		TEXTSTR names = BTSEEK( TEXTSTR, vol, this_name_block, cache );
		unsigned char *name = (unsigned char*)names;
		while( name < ( (unsigned char*)names + BLOCK_SIZE ) ) {
			int c = name[0];
			if( vol->key ) c = c ^ vol->usekey[BC(NAMES)][name-(unsigned char*)names];
			if( !c ) {
				size_t namelen;
				if( ( namelen = StrLen( filename ) ) < (size_t)( ( (unsigned char*)names + BLOCK_SIZE ) - name ) ) {
					LoG( "using unused entry for new file...%" _size_f "  %" _size_f " %s", this_name_block, (uintptr_t)name - (uintptr_t)names, filename );
					if( vol->key ) {
						for( n = 0; n < namelen + 1; n++ )
							name[n] = filename[n] ^ vol->usekey[BC(NAMES)][n + (name-(unsigned char*)names)];
						if( (namelen + 1) < (size_t)(((unsigned char*)names + BLOCK_SIZE) - name) )
							name[n] = vol->usekey[BC(NAMES)][n + (name - (unsigned char*)names)];
					} else
						memcpy( name, filename, ( namelen + 1 ) );
					return ((uintptr_t)name) - ((uintptr_t)vol->disk);
				}
			}
			else
				if( MaskStrCmp( vol, filename, name - (unsigned char*)vol->disk, 0 ) == 0 ) {
					LoG( "using existing entry for new file...%s", filename );
					return ((uintptr_t)name) - ((uintptr_t)vol->disk);
				}
			if( vol->key ) {
				while( ( name[0] ^ vol->usekey[BC(NAMES)][name-(unsigned char*)names] ) ) name++;
				name++;
			} else
				name = name + StrLen( (const char*)name ) + 1;
#ifdef DEBUG_NAME_POSITION_SEEK
			LoG( "new position is %" _size_f "  %" _size_f, this_name_block, (uintptr_t)name - (uintptr_t)names );
#endif
		}
		this_name_block = vfs_GetNextBlock( vol, this_name_block, GFB_INIT_NAMES, TRUE );
		LoG( "Need a new(next) name block.... %zd" , this_name_block );
	}
}
static struct directory_entry * GetNewDirectory( struct sack_vfs_volume *vol, const char * filename ) {
	size_t n;
	BLOCKINDEX this_dir_block = 0;
	struct directory_entry *next_entries;
	LOGICAL moveMark = FALSE;
	do {
		enum block_cache_entries cache = BC(DIRECTORY);
		next_entries = BTSEEK( struct directory_entry *, vol, this_dir_block, cache );
		for( n = 0; n < VFS_DIRECTORY_ENTRIES; n++ ) {
			struct directory_entry *entkey = ( vol->key )?((struct directory_entry *)vol->usekey[cache])+n:&l.zero_entkey;
			struct directory_entry *ent = next_entries + n;
			FPI name_ofs = ent->name_offset ^ entkey->name_offset;
			BLOCKINDEX first_blk = ent->first_block ^ entkey->first_block;
			// not name_offset (end of list) or not first_block(free entry) use this entry
			if( name_ofs && (first_blk > 1) )  continue;
			if( first_blk == EODMARK ) moveMark = TRUE;
			name_ofs = SaveFileName( vol, filename ) ^ entkey->name_offset;
			first_blk = GetFreeBlock( vol, FALSE ) ^ entkey->first_block;
			// get free block might have expanded and moved the disk; reseek and get ent address
			next_entries = BTSEEK( struct directory_entry *, vol, this_dir_block, cache );
			ent = next_entries + n;
			ent->filesize = entkey->filesize;
			ent->name_offset = name_ofs;
			ent->first_block = first_blk;
			if( n < (VFS_DIRECTORY_ENTRIES - 1) ) {
				if( moveMark ) {
					struct directory_entry *enttmp = next_entries + (n + 1);
					enttmp->first_block = EODMARK ^ entkey[1].first_block;
				}
			} else {
				// otherwise pre-init the next directory sector
				this_dir_block = vfs_GetNextBlock( vol, this_dir_block, GFB_INIT_DIRENT, TRUE );
			}
			return ent;
		}
		this_dir_block = vfs_GetNextBlock( vol, this_dir_block, GFB_INIT_DIRENT, TRUE );
	}
	while( 1 );
}
struct sack_vfs_file * CPROC sack_vfs_openfile( struct sack_vfs_volume *vol, const char * filename ) {
	struct sack_vfs_file *file = New( struct sack_vfs_file );
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	while( vol->locked_thread && vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	if( filename[0] == '.' && filename[1] == '/' ) filename += 2;
	LoG( "sack_vfs open %s = %p on %s", filename, file, vol->volname );
	file->entry = VFSScanDirectory( vol, filename, &file->dirent_key, 0 );
	if( !file->entry ) {
		if( vol->read_only ) { LoG( "Fail open: readonly" ); vol->lock = 0; Deallocate( struct sack_vfs_file *, file ); return NULL; }
		else file->entry = GetNewDirectory( vol, filename );
	}
	if( vol->key )
		memcpy( &file->dirent_key, vol->usekey[BC(DIRECTORY)] + ( (uintptr_t)file->entry & BLOCK_MASK ), sizeof( struct directory_entry ) );
	else
		memset( &file->dirent_key, 0, sizeof( struct directory_entry ) );
	file->vol = vol;
	file->fpi = 0;
	file->delete_on_close = 0;
	file->_first_block = file->block = file->entry->first_block ^ file->dirent_key.first_block;
	LoG( "open file start file block is %d", (int)file->block );
	file->blockChain = NULL;
	file->blockChainAvail = 0;
	file->blockChainLength = 0;
	SetBlockChain( file, 0, file->block );
	AddLink( &vol->files, file );
	vol->lock = 0;
	return file;
}
static struct sack_vfs_file * CPROC sack_vfs_open( uintptr_t psvInstance, const char * filename, const char *opts ) {
	return sack_vfs_openfile( (struct sack_vfs_volume*)psvInstance, filename );
}
int CPROC sack_vfs_exists( struct sack_vfs_volume *vol, const char * file ) {
	struct directory_entry entkey;
	struct directory_entry *ent;
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	while( vol->locked_thread && vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	if( file[0] == '.' && file[1] == '/' ) file += 2;
	ent = VFSScanDirectory( vol, file, &entkey, 0 );
	//lprintf( "sack_vfs exists %s %s", ent?"ya":"no", file );
	vol->lock = 0;
	if( ent ) return TRUE;
	return FALSE;
}
size_t CPROC sack_vfs_tell( struct sack_vfs_file *file ) { return (size_t)file->fpi; }
size_t CPROC sack_vfs_size( struct sack_vfs_file *file ) { return (size_t)(file->entry->filesize ^ file->dirent_key.filesize); }
size_t CPROC sack_vfs_seek( struct sack_vfs_file *file, size_t pos, int whence )
{
	FPI old_fpi = file->fpi;
	BLOCKINDEX b;
	if( whence == SEEK_SET ) file->fpi = pos;
	if( whence == SEEK_CUR ) file->fpi += pos;
	if( whence == SEEK_END ) file->fpi = ( file->entry->filesize  ^ file->dirent_key.filesize ) + pos;
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	while( file->vol->locked_thread && file->vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	if( (file->fpi >> BLOCK_SIZE_BITS) < file->blockChainLength ) {
		enum block_cache_entries cache = BC( FILE );
		file->block = file->blockChain[file->fpi >> BLOCK_SIZE_BITS];
#ifdef DEBUG_BLOCK_TRACKING
		LoG( "(_seek)File block set to %d from block chain", (int)file->block );
#endif
#ifdef _DEBUG
		if( !file->block )DebugBreak();
#endif
		//LoG( "file block is %d", (int)file->block );
		vfs_BSEEK( file->vol, file->block, &cache );
		file->vol->lock = 0;
		return (size_t)file->fpi;
	}
	else {
		file->block = b = file->blockChain[file->blockChainLength - 1];
#ifdef DEBUG_BLOCK_TRACKING
		LoG( "Need more blocks after end of file.... %d", file->block );
#endif
		old_fpi = ( file->blockChainLength - 1 ) * BLOCK_SIZE;
	}
	{
		if( ( file->fpi & ( ~BLOCK_MASK ) ) >= ( old_fpi & ( ~BLOCK_MASK ) ) ) {
			do {
				if( ( file->fpi & ( ~BLOCK_MASK ) ) == ( old_fpi & ( ~BLOCK_MASK ) ) ) {
					file->block = b;
					file->vol->lock = 0;
					LoG( "-- file block is finally %d", (int)b );
					return (size_t)file->fpi;
				}
				b = vfs_GetNextBlock( file->vol, b, FALSE, TRUE );
#ifdef DEBUG_BLOCK_TRACKING
				LoG( "-- file block will be %d   %d  %d", (int)b, (int)file->fpi, (int)(old_fpi) );
#endif
// the actual old FPI already had a block (input file->block), new FPI gets this block.
				old_fpi += BLOCK_SIZE;
				SetBlockChain( file, old_fpi, b );
				//SetBlockChain( file, old_fpi, file->block );
			} while( 1 );
		}
	}
	{
		size_t n = (size_t)(file->blockChainLength - 1);
#ifdef _DEBUG
		if( n & 0x80000000 ) DebugBreak();
#endif
		while( n * BLOCK_SIZE < ( pos & ~BLOCK_MASK ) ) {
			b = vfs_GetNextBlock( file->vol, b, FALSE, TRUE );
			n++;
		}
		file->block = b;
		LoG( "++ file block is %d", (int)file->block );
		SetBlockChain( file, file->fpi, file->block );
	}
	file->vol->lock = 0;
	return (size_t)file->fpi;
}
static void MaskBlock( struct sack_vfs_volume *vol, uint8_t* usekey, uint8_t* block, BLOCKINDEX block_ofs, size_t ofs, const char *data, size_t length ) {
	size_t n;
	block += block_ofs;
	usekey += ofs;
	if( vol->key )
		for( n = 0; n < length; n++ ) (*block++) = (*data++) ^ (*usekey++);
	else {
		for( n = 0; n < length; n++, block++, data++ ) block[0] = data[0];
		//memcpy( block, data, length );
	}
}
size_t CPROC sack_vfs_write( struct sack_vfs_file *file, const void * data_, size_t length ) {
	const char* data = (const char*)data_;
	size_t written = 0;
	size_t ofs = file->fpi & BLOCK_MASK;
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	while( file->vol->locked_thread && file->vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	LoG( "Write to file %p %" _size_f "  @%" _size_f, file, length, file->fpi );
	if( ofs ) {
		enum block_cache_entries cache = BC(FILE);
		uint8_t* block = (uint8_t*)vfs_BSEEK( file->vol, file->block, &cache );
		if( length >= ( BLOCK_SIZE - ( ofs ) ) ) {
			MaskBlock( file->vol, file->vol->usekey[cache], block, ofs, ofs, data, BLOCK_SIZE - ofs );
			data += BLOCK_SIZE - ofs;
			written += BLOCK_SIZE - ofs;
			file->fpi += BLOCK_SIZE - ofs;
			if( file->fpi > ( file->entry->filesize ^ file->dirent_key.filesize ) )
				file->entry->filesize = file->fpi ^ file->dirent_key.filesize;
			if( !file->block )
				DebugBreak();
			file->block = vfs_GetNextBlock( file->vol, file->block, FALSE, TRUE );
			if( !file->block ) {
				lprintf( "File is corrupt");
				file->vol->lock = 0;
				return written;
			}
 // in case the block needs to be allocated/expanded.
			block = (uint8_t*)vfs_BSEEK( file->vol, file->block, &cache );
			LoG( "file block is %d", (int)file->block );
			SetBlockChain( file, file->fpi, file->block );
			length -= BLOCK_SIZE - ofs;
		} else {
			MaskBlock( file->vol, file->vol->usekey[cache], block, ofs, ofs, data, length );
			data += length;
			written += length;
			file->fpi += length;
			if( file->fpi > ( file->entry->filesize ^ file->dirent_key.filesize ) )
				file->entry->filesize = file->fpi ^ file->dirent_key.filesize;
			length = 0;
		}
	}
	// if there's still length here, FPI is now on the start of blocks
	while( length )
	{
		enum block_cache_entries cache = BC(FILE);
		uint8_t* block = (uint8_t*)vfs_BSEEK( file->vol, file->block, &cache );
		if( length >= BLOCK_SIZE ) {
			MaskBlock( file->vol, file->vol->usekey[cache], block, 0, 0, data, BLOCK_SIZE - ofs );
			data += BLOCK_SIZE;
			written += BLOCK_SIZE;
			file->fpi += BLOCK_SIZE;
			if( !file->block )
				DebugBreak();
			file->block = vfs_GetNextBlock( file->vol, file->block, FALSE, TRUE );
			if( !file->block ) {
				lprintf( "File is corrupt");
				file->vol->lock = 0;
				return written;
			}
			LoG( "File block was %d", file->block );
 // in case the block needs to be allocated/expanded.
			block = (uint8_t*)vfs_BSEEK( file->vol, file->block, &cache );
#ifdef _DEBUG
			if( !file->block ) DebugBreak();
#endif
			if( file->fpi > ( file->entry->filesize ^ file->dirent_key.filesize ) ) {
				SetBlockChain( file, file->fpi, file->block );
				file->entry->filesize = file->fpi ^ file->dirent_key.filesize;
			}
			LoG( "(write,block) file block is %d", (int)file->block );
			length -= BLOCK_SIZE;
		} else {
			MaskBlock( file->vol, file->vol->usekey[cache], block, 0, 0, data, length );
			data += length;
			written += length;
			file->fpi += length;
			if( file->fpi > ( file->entry->filesize ^ file->dirent_key.filesize ) )
				file->entry->filesize = file->fpi ^ file->dirent_key.filesize;
			length = 0;
		}
	}
	file->vol->lock = 0;
	return written;
}
size_t CPROC sack_vfs_read( struct sack_vfs_file *file, void * data_, size_t length ) {
	char* data = (char*)data_;
	size_t written = 0;
	size_t ofs = file->fpi & BLOCK_MASK;
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	while( file->vol->locked_thread && file->vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	if( ( file->entry->filesize  ^ file->dirent_key.filesize ) < ( file->fpi + length ) ) {
		if( ( file->entry->filesize  ^ file->dirent_key.filesize ) < file->fpi )
			length = 0;
		else
			length = (size_t)( file->entry->filesize  ^ file->dirent_key.filesize ) - (size_t)file->fpi;
	}
	if( !length ) {  file->vol->lock = 0; return 0; }
	if( ofs ) {
		enum block_cache_entries cache = BC(FILE);
		uint8_t* block = (uint8_t*)vfs_BSEEK( file->vol, file->block, &cache );
		if( length >= ( BLOCK_SIZE - ( ofs ) ) ) {
			MaskBlock( file->vol, file->vol->usekey[cache], (uint8_t*)data, 0, ofs, (const char*)(block+ofs), BLOCK_SIZE - ofs );
			written += BLOCK_SIZE - ofs;
			data += BLOCK_SIZE - ofs;
			length -= BLOCK_SIZE - ofs;
			file->fpi += BLOCK_SIZE - ofs;
			file->block = vfs_GetNextBlock( file->vol, file->block, FALSE, TRUE );
			if( !file->block ) {
				lprintf( "File is corrupt");
				file->vol->lock = 0;
				return written;
			}
 // in case the block needs to be allocated/expanded.
			block = (uint8_t*)vfs_BSEEK( file->vol, file->block, &cache );
			LoG( "file block is %d", (int)file->block );
			SetBlockChain( file, file->fpi, file->block );
		} else {
			MaskBlock( file->vol, file->vol->usekey[cache], (uint8_t*)data, 0, ofs, (const char*)(block+ofs), length );
			written += length;
			file->fpi += length;
			length = 0;
		}
	}
	// if there's still length here, FPI is now on the start of blocks
	while( length ) {
		enum block_cache_entries cache = BC(FILE);
		uint8_t* block = (uint8_t*)vfs_BSEEK( file->vol, file->block, &cache );
		if( length >= BLOCK_SIZE ) {
			MaskBlock( file->vol, file->vol->usekey[cache], (uint8_t*)data, 0, 0, (const char*)block, BLOCK_SIZE - ofs );
			written += BLOCK_SIZE;
			data += BLOCK_SIZE;
			length -= BLOCK_SIZE;
			file->fpi += BLOCK_SIZE;
			file->block = vfs_GetNextBlock( file->vol, file->block, FALSE, TRUE );
			if( !file->block ) {
				lprintf( "File is corrupt");
				file->vol->lock = 0;
				return written;
			}
 // in case the block needs to be allocated/expanded.
			block = (uint8_t*)vfs_BSEEK( file->vol, file->block, &cache );
			LoG( "file block is %d", (int)file->block );
			SetBlockChain( file, file->fpi, file->block );
		} else {
			MaskBlock( file->vol, file->vol->usekey[cache], (uint8_t*)data, 0, 0, (const char*)block, length );
			written += length;
			file->fpi += length;
			length = 0;
		}
	}
	file->vol->lock = 0;
	return written;
}
static void sack_vfs_unlink_file_entry( struct sack_vfs_volume *vol, struct directory_entry *entry, struct directory_entry *entkey, BLOCKINDEX first_block, LOGICAL deleted ) {
	BLOCKINDEX block, _block;
	struct sack_vfs_file *file_found = NULL;
	struct sack_vfs_file *file;
	INDEX idx;
	LIST_FORALL( vol->files, idx, struct sack_vfs_file *, file ) {
		if( file->_first_block == ( entry->first_block ^ entkey->first_block ) ) {
			file_found = file;
			file->delete_on_close = TRUE;
		}
	}
	if( !deleted ) {
 // zero the block... keep the name.
		entry->first_block = entkey->first_block;
	}
	if( !file_found ) {
// entry->first_block ^ entkey->first_block;
		_block = block = first_block;
		LoG( "(marking physical deleted (again?)) entry starts at %d", block );
		// wipe out file chain BAT
		do {
			enum block_cache_entries cache = BC(BAT);
			BLOCKINDEX *this_BAT = TSEEK( BLOCKINDEX*, vol, ( ( block >> BLOCK_BAT_SHIFT ) * ( BLOCKS_PER_SECTOR*BLOCK_SIZE) ), cache );
			BLOCKINDEX _thiskey = ( vol->key )?((BLOCKINDEX*)vol->usekey[cache])[_block & (BLOCKS_PER_BAT-1)]:0;
			uint8_t* blockData = (uint8_t*)vfs_BSEEK( vol, block, &cache );
			//LoG( "Clearing file datablock...%p", (uintptr_t)blockData - (uintptr_t)vol->disk );
			memset( blockData, 0, BLOCK_SIZE );
			block = vfs_GetNextBlock( vol, block, FALSE, FALSE );
			this_BAT[_block & (BLOCKS_PER_BAT-1)] = _thiskey;
			LoGB( "Write to BAT: 0 at %d  %d  %p (STORE FREE too)", (int)(_block&(BLOCKS_PER_BAT - 1)), _block, this_BAT );
			AddDataItem( &vol->pdlFreeBlocks, &_block );
			_block = block;
		} while( block != EOFBLOCK );
	}
}
static void shrinkBAT( struct sack_vfs_file *file ) {
	struct sack_vfs_volume *vol = file->vol;
	struct directory_entry *entry = file->entry;
	struct directory_entry *entkey = &file->dirent_key;
	BLOCKINDEX block, _block;
	size_t bsize = 0;
	_block = block = entry->first_block ^ entkey->first_block;
	do {
		enum block_cache_entries cache = BC(BAT);
		enum block_cache_entries data_cache = BC(DATAKEY);
		BLOCKINDEX *this_BAT = TSEEK( BLOCKINDEX*, vol, ( ( block >> BLOCK_BAT_SHIFT ) * ( BLOCKS_PER_SECTOR*BLOCK_SIZE) ), cache );
		BLOCKINDEX _thiskey;
		_thiskey = ( vol->key )?((BLOCKINDEX*)vol->usekey[cache])[_block & (BLOCKS_PER_BAT-1)]:0;
		block = vfs_GetNextBlock( vol, block, FALSE, FALSE );
		if( bsize > (entry->filesize ^ entkey->filesize) ) {
			uint8_t* blockData = (uint8_t*)vfs_BSEEK( file->vol, _block, &data_cache );
			//LoG( "clearing a datablock after a file..." );
			memset( blockData, 0, BLOCK_SIZE );
			this_BAT[_block & (BLOCKS_PER_BAT-1)] = _thiskey;
		} else {
			bsize++;
			if( bsize > (entry->filesize ^ entkey->filesize) ) {
				uint8_t* blockData = (uint8_t*)vfs_BSEEK( file->vol, _block, &data_cache );
				//LoG( "clearing a partial datablock after a file..., %d, %d", BLOCK_SIZE-(entry->filesize & (BLOCK_SIZE-1)), ( entry->filesize & (BLOCK_SIZE-1)) );
				memset( blockData + ( entry->filesize & (BLOCK_SIZE-1)), 0, BLOCK_SIZE-(entry->filesize & (BLOCK_SIZE-1)) );
				this_BAT[_block & (BLOCKS_PER_BAT-1)] = ~_thiskey;
			}
		}
		_block = block;
	} while( block != EOFBLOCK );
}
size_t CPROC sack_vfs_truncate( struct sack_vfs_file *file ) { file->entry->filesize = file->fpi ^ file->dirent_key.filesize; shrinkBAT( file ); return (size_t)file->fpi; }
int CPROC sack_vfs_close( struct sack_vfs_file *file ) {
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	while( file->vol->locked_thread && file->vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
#ifdef DEBUG_TRACE_LOG
	{
		enum block_cache_entries cache = BC(NAMES);
		static char fname[256];
		FPI name_ofs = file->entry->name_offset ^ file->dirent_key.name_offset;
 // have to do the seek to the name block otherwise it might not be loaded.
		TSEEK( const char *, file->vol, name_ofs, cache );
		MaskStrCpy( fname, sizeof( fname ), file->vol, name_ofs );
		LoG( "close file:%s(%p)", fname, file );
	}
#endif
	DeleteLink( &file->vol->files, file );
	if( file->delete_on_close ) sack_vfs_unlink_file_entry( file->vol, file->entry, &file->dirent_key, file->_first_block, TRUE );
	file->vol->lock = 0;
	//ValidateBAT( file->vol );
	if( file->vol->closed ) sack_vfs_unload_volume( file->vol );
	Deallocate( struct sack_vfs_file *, file );
	return 0;
}
int CPROC sack_vfs_unlink_file( struct sack_vfs_volume *vol, const char * filename ) {
	int result = 0;
	struct directory_entry entkey;
	struct directory_entry *entry;
	if( !vol ) return 0;
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	while( vol->locked_thread && vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	LoG( "unlink file:%s", filename );
	if( ( entry  = VFSScanDirectory( vol, filename, &entkey, 0 ) ) ) {
		sack_vfs_unlink_file_entry( vol, entry, &entkey, entry->first_block ^ entkey.first_block, FALSE );
		result = 1;
	}
	vol->lock = 0;
	return result;
}
	/* noop */
int CPROC sack_vfs_flush( struct sack_vfs_file *file ) {	return 0; }
static LOGICAL CPROC sack_vfs_need_copy_write( void ) {	return FALSE; }
struct sack_vfs_find_info {
	BLOCKINDEX this_dir_block;
	char filename[BLOCK_SIZE];
	struct sack_vfs_volume *vol;
	CTEXTSTR base;
	size_t base_len;
	size_t filenamelen;
	VFS_DISK_DATATYPE filesize;
	CTEXTSTR mask;
	size_t thisent;
};
struct sack_vfs_find_info * CPROC sack_vfs_find_create_cursor(uintptr_t psvInst,const char *base,const char *mask )
{
	struct sack_vfs_find_info *info = New( struct sack_vfs_find_info );
	info->base = base;
	info->base_len = StrLen( base );
	info->mask = mask;
	info->vol = (struct sack_vfs_volume *)psvInst;
	return info;
}
static int iterate_find( struct sack_vfs_find_info *info ) {
	struct directory_entry *next_entries;
	size_t n;
	do {
		enum block_cache_entries cache = BC(DIRECTORY);
		enum block_cache_entries name_cache = BC(NAMES);
		next_entries = BTSEEK( struct directory_entry *, info->vol, info->this_dir_block, cache );
		for( n = info->thisent; n < VFS_DIRECTORY_ENTRIES; n++ ) {
			struct directory_entry *entkey = ( info->vol->key)?((struct directory_entry *)info->vol->usekey[cache])+n:&l.zero_entkey;
			FPI name_ofs = next_entries[n].name_offset ^ entkey->name_offset;
			if( !name_ofs )
				return 0;
			// if file is deleted; don't check it's name.
			if( !(next_entries[n].first_block ^ entkey->first_block ) )
				continue;
			if( (next_entries[n].first_block ^ entkey->first_block ) == EODMARK )
 // end of directory.
				return 0;
			info->filesize = next_entries[n].filesize ^ entkey->filesize;
			if( (name_ofs) > info->vol->dwSize ) {
				LoG( "corrupted volume." );
				return 0;
			}
			TSEEK( const char *, info->vol, name_ofs, name_cache );
			if( info->vol->key ) {
				int c;
				info->filenamelen = 0;
				while( ( c = ( ((uint8_t*)info->vol->disk)[name_ofs] ^ info->vol->usekey[name_cache][name_ofs&BLOCK_MASK] ) ) ) {
					info->filename[info->filenamelen++] = c;
					name_ofs++;
				}
				info->filename[info->filenamelen]	 = c;
				LoG( "Scan return filename: %s", info->filename );
				if( info->base
				    && ( info->base[0] != '.' && info->base_len != 1 )
				    && StrCaseCmpEx( info->base, info->filename, info->base_len ) )
					continue;
			} else {
				StrCpy( info->filename, (const char *)(((uint8_t*)info->vol->disk) + name_ofs) );
				LoG( "Scan return filename: %s", info->filename );
				if( info->base
				    && ( info->base[0] != '.' && info->base_len != 1 )
				    && StrCaseCmpEx( info->base, info->filename, info->base_len ) )
					continue;
			}
			info->thisent = n + 1;
			return 1;
		}
 // new block, set new starting index.
		info->thisent = 0;
		info->this_dir_block = vfs_GetNextBlock( info->vol, info->this_dir_block, FALSE, FALSE );
	}
	while( info->this_dir_block != EOFBLOCK );
	return 0;
}
int CPROC sack_vfs_find_first( struct sack_vfs_find_info *info ) {
	info->this_dir_block = 0;
	info->thisent = 0;
	return iterate_find( info );
}
int CPROC sack_vfs_find_close( struct sack_vfs_find_info *info ) { Deallocate( struct sack_vfs_find_info*, info ); return 0; }
int CPROC sack_vfs_find_next( struct sack_vfs_find_info *info ) { return iterate_find( info ); }
char * CPROC sack_vfs_find_get_name( struct sack_vfs_find_info *info ) { return ((struct sack_vfs_find_info*)info)->filename; }
size_t CPROC sack_vfs_find_get_size( struct sack_vfs_find_info *info ) { return (size_t)((struct sack_vfs_find_info*)info)->filesize; }
LOGICAL CPROC sack_vfs_find_is_directory( struct sack_vfs_find_info *cursor ) { return FALSE; }
LOGICAL CPROC sack_vfs_is_directory( uintptr_t psvInstance, const char *path ) {
	if( path[0] == '.' && path[1] == 0 ) return TRUE;
	{
		struct sack_vfs_volume *vol = (struct sack_vfs_volume *)psvInstance;
		if( VFSScanDirectory( vol, path, NULL, 1 ) ) {
			return TRUE;
		}
	}
	return FALSE;
}
uint64_t CPROC sack_vfs_find_get_ctime( struct sack_vfs_find_info *info ) { return (size_t)0; }
uint64_t CPROC sack_vfs_find_get_wtime( struct sack_vfs_find_info *info ) { return (size_t)0; }
LOGICAL CPROC sack_vfs_rename( uintptr_t psvInstance, const char *original, const char *newname ) {
	struct sack_vfs_volume *vol = (struct sack_vfs_volume *)psvInstance;
	// fail if the names are the same.
	if( strcmp( original, newname ) == 0 )
		return FALSE;
	if( vol ) {
		struct directory_entry entkey;
		struct directory_entry *entry;
#ifdef VFS_IMPLEMENT_FILE_LOCKING
		while( vol->locked_thread && vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
		while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
		if( ( entry  = VFSScanDirectory( vol, original, &entkey, 0 ) ) ) {
			struct directory_entry new_entkey;
			struct directory_entry *new_entry;
			if( (new_entry = VFSScanDirectory( vol, newname, &new_entkey, 0 )) ) {
				vol->lock = 0;
				sack_vfs_unlink_file( vol, newname );
#ifdef VFS_IMPLEMENT_FILE_LOCKING
				while( vol->locked_thread && vol->locked_thread != GetThisThreadID() ) Relinquish();
#endif
				while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
			}
			entry->name_offset = SaveFileName( vol, newname ) ^ entkey.name_offset;
			vol->lock = 0;
			return TRUE;
		}
		vol->lock = 0;
	}
	return FALSE;
}
#ifdef VFS_IMPLEMENT_FILE_LOCKING
int CPROC sack_vfs_file_lock( struct sack_vfs_file* file, int disposition ) {
	while( LockedExchange64( &file->vol->locked_thread, GetThisThreadID() ) ) Relinquish();
	return 1;
}
int CPROC sack_vfs_file_unlock( struct sack_vfs_file* file, int disposition ) {
	file->vol->locked_thread = 0;
	return 1;
}
#endif
static struct file_system_interface sack_vfs_fsi = {
                                                     (void*(CPROC*)(uintptr_t,const char *, const char*))sack_vfs_open
                                                   , (int(CPROC*)(void*))sack_vfs_close
                                                   , (size_t(CPROC*)(void*,void*,size_t))sack_vfs_read
                                                   , (size_t(CPROC*)(void*,const void*,size_t))sack_vfs_write
                                                   , (size_t(CPROC*)(void*,size_t,int))sack_vfs_seek
                                                   , (void(CPROC*)(void*))sack_vfs_truncate
                                                   , (int(CPROC*)(uintptr_t,const char*))sack_vfs_unlink_file
                                                   , (size_t(CPROC*)(void*))sack_vfs_size
                                                   , (size_t(CPROC*)(void*))sack_vfs_tell
                                                   , (int(CPROC*)(void*))sack_vfs_flush
                                                   , (int(CPROC*)(uintptr_t,const char*))sack_vfs_exists
                                                   , sack_vfs_need_copy_write
                                                   , (struct find_cursor*(CPROC*)(uintptr_t,const char *,const char *))             sack_vfs_find_create_cursor
                                                   , (int(CPROC*)(struct find_cursor*))             sack_vfs_find_first
                                                   , (int(CPROC*)(struct find_cursor*))             sack_vfs_find_close
                                                   , (int(CPROC*)(struct find_cursor*))             sack_vfs_find_next
                                                   , (char*(CPROC*)(struct find_cursor*))           sack_vfs_find_get_name
                                                   , (size_t(CPROC*)(struct find_cursor*))          sack_vfs_find_get_size
                                                   , (LOGICAL(CPROC*)(struct find_cursor *))        sack_vfs_find_is_directory
                                                   , sack_vfs_is_directory
                                                   , sack_vfs_rename
	, (uintptr_t( CPROC* )(uintptr_t, uintptr_t, va_list))NULL
	, (uintptr_t( CPROC* )(uintptr_t, uintptr_t, va_list))NULL
	, (uint64_t( CPROC* )(struct find_cursor* cursor))sack_vfs_find_get_ctime
	, (uint64_t( CPROC* )(struct find_cursor* cursor))sack_vfs_find_get_wtime
	 //int (CPROC* _mkdir)(uintptr_t psvInstance, const char*);
	, NULL
 //int (CPROC* _rmdir)(uintptr_t psvInstance, const char*);
	, NULL
 //(int(CPROC*)(void*))sack_vfs_file_lock
	, NULL
 //(int(CPROC*)(void*))sack_vfs_file_unlock
	, NULL
};
PRIORITY_PRELOAD( Sack_VFS_Register, VIRTUAL_FILESYSTEM_PRELOAD_PRIORITY )
{
#ifdef ALT_VFS_NAME
#   define DEFAULT_VFS_NAME SACK_VFS_FILESYSTEM_NAME ".runner"
#else
#   define DEFAULT_VFS_NAME SACK_VFS_FILESYSTEM_NAME
#endif
	sack_register_filesystem_interface( DEFAULT_VFS_NAME, &sack_vfs_fsi );
}
PRIORITY_PRELOAD( Sack_VFS_RegisterDefaultFilesystem, SQL_PRELOAD_PRIORITY + 1 ) {
	if( SACK_GetProfileInt( GetProgramName(), "SACK/VFS/Mount VFS", 0 ) ) {
		struct sack_vfs_volume *vol;
		TEXTCHAR volfile[256];
		TEXTSTR tmp;
		SACK_GetProfileString( GetProgramName(), "SACK/VFS/File", "*/../assets.svfs", volfile, 256 );
		tmp = ExpandPath( volfile );
		vol = sack_vfs_load_volume( tmp );
		Deallocate( TEXTSTR, tmp );
		sack_mount_filesystem( "sack_shmem", sack_get_filesystem_interface( DEFAULT_VFS_NAME )
		                     , 900, (uintptr_t)vol, TRUE );
	}
}
SACK_VFS_NAMESPACE_END
#ifdef _MSC_VER
// integer partial expresions summed into 64 bit.
#  pragma warning( default: 26451 )
#endif
/*
 BLOCKINDEX BAT[BLOCKS_PER_BAT] // link of next blocks; 0 if free, FFFFFFFF if end of file block
 uint8_t  block_data[BLOCKS_PER_BAT][BLOCK_SIZE];
 // (1+BLOCKS_PER_BAT) * BLOCK_SIZE total...
 BAT[0] = first directory cluster; array of struct directory_entry
 BAT[1] = name space; directory offsets land in a block referenced by this chain
 */
#define SACK_VFS_SOURCE
//#define USE_STDIO
#if 1
 // tolower on linux
#ifndef USE_STDIO
#endif
#else
 // tolower on linux
//#include <filesys.h>
//#include <procreg.h>
//#include <salty_generator.h>
//#include <sack_vfs.h>
//#include <sqlgetoption.h>
#endif
#ifdef _MSC_VER
// integer partial expresions summed into 64 bit.
#pragma warning( disable: 26451 )
#endif
#ifdef USE_STDIO
#define sack_fopen(a,b,c)     fopen(b,c)
#define sack_fseek(a,b,c)     fseek(a,(long)b,c)
#define sack_fclose(a)        fclose(a)
#define sack_fread(a,b,c,d)   fread(a,b,c,d)
#define sack_fwrite(a,b,c,d)  fwrite(a,b,c,d)
#define sack_ftell(a)         ftell(a)
#ifdef __cplusplus
namespace sack {
	namespace filesys {
#endif
		// pathops.c
		extern LOGICAL  CPROC  IsPath( CTEXTSTR path );
		extern  int CPROC  MakePath( CTEXTSTR path );
		extern CTEXTSTR CPROC pathrchr( CTEXTSTR path );
		extern CTEXTSTR CPROC pathchr( CTEXTSTR path );
#ifdef __cplusplus
	}
}
using namespace sack::filesys;
#endif
#endif
SACK_VFS_NAMESPACE
#define FILE_BASED_VFS
#ifndef _MSC_VER
#endif
/**************
  VFS_VERSION
     used to track migration of keys and keying methods.
  0x100 = version 1; SHORTKEY_LENGTH = 16
 **************/
#define VFS_VERSION     0x100
// 12 bits = 1 << 12 = 4096
#define BLOCK_SIZE_BITS 12
// BLOCKINDEX is either 4 or 8 bytes... sizeof( size_t )...
// all constants though should compile out to a single value... and just for grins went to 16 bit size_t and 0 shift... or 1 byte
#define BLOCK_BAT_SHIFT (BLOCK_SIZE_BITS-(sizeof(BLOCKINDEX)==16?4:sizeof(BLOCKINDEX)==8?3:sizeof(BLOCKINDEX)==4?2:sizeof(BLOCKINDEX)==2?1:0) )
#define BLOCK_INDEX_SHIFT ((sizeof(BLOCKINDEX)==16?4:sizeof(BLOCKINDEX)==8?3:sizeof(BLOCKINDEX)==4?2:sizeof(BLOCKINDEX)==2?1:0) )
#define BLOCK_BYTE_SHIFT (BLOCK_SIZE_BITS)
#define BLOCK_SIZE (1<<BLOCK_SIZE_BITS)
#define BLOCK_SMALL_SIZE     256
#define DIR_BLOCK_SIZE_BITS   12
#define DIR_BLOCK_SIZE      (1<<DIR_BLOCK_SIZE_BITS)
#define BAT_BLOCK_SIZE      4096
#define NAME_BLOCK_SIZE     4096
#define KEY_SIZE            1024
#define TIME_BLOCK_SIZE     4096
#define ROLLBACK_BLOCK_SIZE 4096
#define FILE_NAME_MAXLEN    4096
#define BLOCK_MASK (BLOCK_SIZE-1)
#ifdef VIRTUAL_OBJECT_STORE
// if the block index & BAT_BLOCK_MASK, is a data block
// all BATs are 4096
#  undef BLOCKS_PER_BAT
#  undef BLOCK_SECTOR_MASK
#  define BLOCKS_PER_BAT ((BAT_BLOCK_SIZE >> BLOCK_INDEX_SHIFT)-1)
#  define BLOCK_SECTOR_MASK BLOCKS_PER_BAT
#else
#  undef BLOCKS_PER_BAT
#  undef BLOCK_SECTOR_MASK
#  define BLOCKS_PER_BAT ((BAT_BLOCK_SIZE >> BLOCK_INDEX_SHIFT))
#  define BLOCK_SECTOR_MASK (BLOCKS_PER_BAT-1)
#endif
#define BAT_BLOCK_MASK ( ( BAT_BLOCK_SIZE >> BLOCK_INDEX_SHIFT ) - 1)
#define BLOCKS_PER_SECTOR (1+BLOCKS_PER_BAT)
// per-sector perumation; needs to be a power of 2 (in bytes)
#define SHORTKEY_LENGTH 16
#ifndef VFS_DISK_DATATYPE
#  define VFS_DISK_DATATYPE size_t
#endif
 // BLOCK_SIZE blocks...
typedef VFS_DISK_DATATYPE BLOCKINDEX;
 // file position type
typedef VFS_DISK_DATATYPE FPI;
/* BEFORE DEF */
#undef BC
#ifdef VIRTUAL_OBJECT_STORE
/* THIS DEFINES SACK_VFS_OS_VOLUME */
#  define BC(n) BLOCK_CACHE_VOS_##n
#    ifdef sack_vfs_volume
#      undef block_cache_entries
#      undef directory_entry
#      undef sack_vfs_disk
#      undef sack_vfs_diskSection
#      undef directory_hash_lookup_block
#      undef sack_vfs_volume
#      undef sack_vfs_file
#    endif
#    define block_cache_entries block_cache_entries_os
#    define directory_entry directory_entry_os
#    define sack_vfs_disk sack_vfs_disk_os
#    define sack_vfs_diskSection sack_vfs_diskSection_os
#    define directory_hash_lookup_block directory_hash_lookup_block_os
#    define sack_vfs_volume sack_vfs_os_volume
#    define sack_vfs_file sack_vfs_os_file
#   ifdef __cplusplus
namespace objStore {
#   endif
#elif defined FILE_BASED_VFS
#  define BC(n) BLOCK_CACHE_FS_##n
#    ifdef block_cache_entries
#      undef block_cache_entries
#      undef directory_entry
#      undef sack_vfs_disk
#      undef sack_vfs_diskSection
#      undef directory_hash_lookup_block
#      undef sack_vfs_volume
#      undef sack_vfs_file
#    endif
#    define block_cache_entries block_cache_entries_fs
#    define directory_entry directory_entry_fs
#    define sack_vfs_disk sack_vfs_disk_fs
#    define sack_vfs_diskSection sack_vfs_diskSection_fs
#    define directory_hash_lookup_block directory_hash_lookup_block_fs
/* THIS DEFINES SACK_VS_VOLUME */
#    define sack_vfs_volume sack_vfs_fs_volume
#    define sack_vfs_file sack_vfs_fs_file
#   ifdef __cplusplus
namespace fs {
#   endif
#else
#  define BC(n) BLOCK_CACHE_##n
#endif
/* AFTER DEF */
enum block_cache_entries
{
	BC( ZERO )
	, BC( DIRECTORY ) = 0
#ifdef VIRTUAL_OBJECT_STORE
	, BC( DIRECTORY_LAST ) = BC( DIRECTORY ) + 64
#endif
	, BC( NAMES )
	, BC( NAMES_LAST ) = BC( NAMES ) + 16
	, BC( BAT )
#ifdef VIRTUAL_OBJECT_STORE
	// keep a few tables for cache (file system too?)
	, BC( BAT_LAST ) = BC( BAT ) + 16
#endif
	, BC(DATAKEY)
	, BC(FILE)
	, BC(FILE_LAST) = BC(FILE) + 32
#ifdef VIRTUAL_OBJECT_STORE
	, BC( TIMELINE )
	, BC( TIMELINE_LAST ) = BC( TIMELINE ) + 48
#endif
#if defined( VIRTUAL_OBJECT_STORE )
	// really shouldn't need more than one of these...
	// record
	// 1 - header
	// 0/1 - entry (might be with header)
	// 1 - small/big block journal entry
	// replay
	// 1 - header
	// 0/1 - entry (might be with header)
	// 1 - small/big block journal entry
	// 1 - target disk sector
	, BC( ROLLBACK )
	, BC( ROLLBACK_LAST ) = BC( ROLLBACK ) + 6
#endif
#if defined( VIRTUAL_OBJECT_STORE ) && defined( DEBUG_VALIDATE_TREE )
	// debug timeline, keep a mirror for comparisons, when links were lost, etc...
	// can be factored out at some point.
	, BC( TIMELINE_RO )
	, BC( TIMELINE_RO_LAST ) = BC( TIMELINE_RO ) + 48
#endif
	, BC(COUNT)
};
// could effecitvely be fewer than this
// 82 dirents * 512 byte names = 40000
#define DIRENT_NAME_OFFSET_OFFSET             0x0001FFFF
// (sealant length / 4)  (mulitply by 4 to get real length)
#define DIRENT_NAME_OFFSET_FLAG_SEALANT       0x003E0000
#define DIRENT_NAME_OFFSET_FLAG_SEALANT_SHIFT 17
#define DIRENT_NAME_OFFSET_FLAG_OWNED         0x00400000
#define DIRENT_NAME_OFFSET_FLAG_READ_KEYED    0x00800000
// unused flag; previous indicated versioning.
#define DIRENT_NAME_OFFSET_UNUSED_0         0x01000000
#define DIRENT_NAME_OFFSET_VERSION_SHIFT      25
#define DIRENT_NAME_OFFSET_VERSIONS           0x1E000000
#define DIRENT_NAME_OFFSET_UNUSED             0xFE000000
#  ifdef _MSC_VER
#    pragma pack (push, 1)
#  endif
PREFIX_PACKED struct directory_entry
{
  // name offset from beginning of disk
	FPI name_offset;
  // first block of data of the file
	BLOCKINDEX first_block;
  // how big the file is
	VFS_DISK_DATATYPE filesize;
#ifdef VIRTUAL_OBJECT_STORE
  // when the file was created/last written
	uint64_t timelineEntry;
#endif
} PACKED;
#  ifdef _MSC_VER
#    pragma pack (pop)
#  endif
#undef VFS_DIRECTORY_ENTRIES
#ifdef VIRTUAL_OBJECT_STORE
// subtract name has index
// subtrace name index
#  define VFS_DIRECTORY_ENTRIES ( ( BLOCK_SIZE - ( 2*sizeof(BLOCKINDEX) + 256*sizeof(BLOCKINDEX)) ) /sizeof( struct directory_entry) )
#  define VFS_PATCH_ENTRIES ( ( BLOCK_SIZE ) /sizeof( struct directory_entry) )
#else
#  define VFS_DIRECTORY_ENTRIES ( ( BLOCK_SIZE ) /sizeof( struct directory_entry) )
#  define VFS_PATCH_ENTRIES ( ( BLOCK_SIZE ) /sizeof( struct directory_entry) )
#endif
/*
struct sack_vfs_diskSection
{
	// BAT is at 0 of every BLOCK_SIZE blocks (4097 total)
	// &BAT[0] == itself....
	// BAT[0] == first directory entry (actually next entry; first is always here)
	// BAT[1] == first name entry (actually next name block; first is known as here)
	// bat[BLOCK_SIZE] == NEXT_BAT[0]; NEXT_BAT = BAT + BLOCK_SIZE + 1024*BLOCK_SIZE;
	// bat[8192] == ... ( 0 + ( BLOCK_SIZE + BLOCKS_PER_BAT*BLOCK_SIZE ) * N >> 12 )
	BLOCKINDEX BAT[BLOCKS_PER_BAT];
	//struct directory_entry directory[BLOCK_SIZE/sizeof( struct directory_entry)]; // 256
	//char  names[BLOCK_SIZE/sizeof(char)];
	uint8_t  block_data[BLOCKS_PER_BAT][BLOCK_SIZE];
};
struct sack_vfs_disk {
	struct sack_vfs_diskSection firstBlock;
	struct sack_vfs_diskSection blocks[];
};
*/
#undef SMUDGECACHE
#undef CLEANCACHE
#ifdef DEBUG_SECTOR_DIRT
#define SMUDGECACHE(vol,n) {	 lprintf( "set dirty on %d %d %d", n, vol->segment[n], vol->bufferFPI[n]);	 vfs_os_smudge_cache(vol,n);   }
#define CLEANCACHE(vol,n) {	 lprintf( "reset dirty on %d", n);	 RESETFLAG( vol->dirty, n ); }
#else
#define SMUDGECACHE(vol,n) {    vfs_os_smudge_cache(vol,n);   }
#define CLEANCACHE(vol,n) {	 RESETFLAG( vol->dirty, n ); }
#endif
#ifndef ROLLBACK_JOURNAL_DEFINED
#define ROLLBACK_JOURNAL_DEFINED
static int const seglock_mask_size = 4;
struct sack_vfs_os_BAT_info {
	FPI sectorStart;
	FPI sectorEnd;
	BLOCKINDEX blockStart;
	int size;
};
struct vfs_os_rollback_journal {
	struct sack_vfs_os_file* rollback_file;
	struct sack_vfs_os_file* rollback_journal_file;
	struct sack_vfs_os_file* rollback_small_journal_file;
	PDATALIST pdlPendingRecord;
	BLOCKINDEX nextBlock;
	BLOCKINDEX nextSmallBlock;
	PDATALIST pdlJournaled;
 // sectors that are in rollback already
	BLOCKINDEX *pJournaled;
 // how long pJournaled is used
	int journalLength;
 // max length of pJournaled
	int journalAvail;
};
#ifdef small
#  undef small
#endif
#  ifdef _MSC_VER
#    pragma pack (push, 1)
#  endif
PREFIX_PACKED struct vfs_os_rollback_entry {
	BLOCKINDEX fileBlock;
	struct {
		uint64_t small : 1;
  // block was full of 0's
		uint64_t zero : 1;
	} flags;
	// block size is retrievable when the block is reloadeded to write
// PACKED entries[1];
};
PREFIX_PACKED struct vfs_os_rollback_header {
	struct {
		uint64_t dirty : 1;
		uint64_t processing : 1;
	} flags;
  // where the blocks are tracked.
	BLOCKINDEX journal;
 // where small blocks are tracked
	BLOCKINDEX small_journal;
	BLOCKINDEX unused_rollbackLength;
	BLOCKINDEX nextBlock;
	BLOCKINDEX nextSmallBlock;
	BLOCKINDEX nextEntry;
  // align entries on 4096 boundaries
	uint64_t   Filler1;
	// where this is tracked.
	struct vfs_os_rollback_entry  entries[1];
}PACKED ;
#  ifdef _MSC_VER
#    pragma pack (pop)
#  endif
#endif
struct sack_vfs_volume {
	const char * volname;
#ifdef FILE_BASED_VFS
	FILE *file;
	struct file_system_mounted_interface *mount;
#else
	struct sack_vfs_disk *disk;
 // disk might be offset from diskReal because it's a .exe attached.
	struct sack_vfs_disk *diskReal;
#endif
	//uint32_t dirents;  // constant 0
	//uint32_t nameents; // constant 1
	uintptr_t dwSize;
  // used for directory signatures
	const char * datakey;
	const char * userkey;
	const char * devkey;
	enum block_cache_entries curseg;
// cached segment with usekey[n]
	BLOCKINDEX _segment[BC(COUNT)];
// associated with usekey[n]
	BLOCKINDEX segment[BC(COUNT)];
#ifdef VIRTUAL_OBJECT_STORE
	struct vfs_volume_flags {
		BIT_FIELD skipRollbackProcessing : 1;
 // stop any disk activity; test journal recoverability.
		BIT_FIELD halted : 1;
 // stop any disk activity; test journal recoverability.
		BIT_FIELD versioned : 1;
	}flags;
	struct vfs_os_rollback_journal journal;
	BLOCKINDEX lastBlock;
	PDATALIST pdl_BAT_information;
	PLIST pending_rollback;
	//PDATASTACK pdsCTimeStack;// = CreateDataStack( sizeof( struct memoryTimelineNode ) );
	//PDATASTACK pdsWTimeStack;// = CreateDataStack( sizeof( struct memoryTimelineNode ) );
 // timeline root
	struct storageTimeline *timeline;
	enum block_cache_entries timelineCache;
 // timeline root key
	struct storageTimeline *timelineKey;
	struct sack_vfs_os_file *timeline_file;
	struct sack_vfs_os_file* timeline_index_file;
	//struct storageTimelineCursor *timeline_cache;
  // segment is locked into cache.
	MASKSET_( seglock, BC( COUNT ), 4 );
	unsigned int sector_size[BC( COUNT )];
#endif
	uint8_t fileCacheAge[BC(FILE_LAST) - BC(FILE)];
#ifdef VIRTUAL_OBJECT_STORE
	uint8_t dirHashCacheAge[BC(DIRECTORY_LAST) - BC(DIRECTORY)];
	uint8_t batHashCacheAge[BC(BAT_LAST) - BC(BAT)];
	uint8_t timelineCacheAge[BC( TIMELINE_LAST ) - BC( TIMELINE )];
	uint8_t rollbackCacheAge[BC( ROLLBACK_LAST ) - BC( ROLLBACK )];
#endif
	uint8_t nameCacheAge[BC(NAMES_LAST) - BC(NAMES)];
	struct random_context *entropy;
  // root of all cached key buffers
	uint8_t* key;
#ifdef FILE_BASED_VFS
  // root of all cached key buffers
	uint8_t* oldkey;
#endif
#ifndef VIRTUAL_OBJECT_STORE
  // allow byte encrypting... key based on sector volume file index
	uint8_t* segkey;
 // composite key
	uint8_t* usekey[BC( COUNT )];
#endif
  // signature of executable attached as header
	uint8_t* sigkey;
  // signature of executable attached as header
	uint8_t* sigsalt;
	size_t sigkeyLength;
#  ifdef FILE_BASED_VFS
  // root buffer space of all cache blocks
	uint8_t* key_buffer;
 // data cache blocks
	uint8_t* usekey_buffer[BC(COUNT)];
 // duplicate copy of original sector data
	uint8_t* usekey_buffer_clean[BC(COUNT)];
	PTHREAD flusher;
	volatile LOGICAL flushing;
	PVARTEXT pvtDeleteBuffer;
#ifdef DEBUG_CACHE_FAULTS
	int cacheRequests[10];
	int cacheFaults[10];
#endif
	FLAGSET( dirty, BC(COUNT) );
	FLAGSET( _dirty, BC( COUNT ) );
	FPI bufferFPI[BC(COUNT)];
#  endif
	BLOCKINDEX lastBatBlock;
	PDATALIST pdlFreeBlocks;
#ifdef VIRTUAL_OBJECT_STORE
	BLOCKINDEX lastBatSmallBlock;
	PDATALIST pdlFreeSmallBlocks;
#endif
 // when reopened file structures need to be updated also...
	PLIST files;
	LOGICAL read_only;
	LOGICAL external_memory;
	LOGICAL closed;
	volatile uint32_t lock;
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	THREAD_ID locked_thread;
#endif
	uint8_t tmpSalt[16];
	uintptr_t clusterKeyVersion;
};
#if !defined( VIRTUAL_OBJECT_STORE )
struct sack_vfs_file
{
 // which volume this is in
	struct sack_vfs_volume *vol;
	struct directory_entry dirent_key;
	FPI fpi;
	BLOCKINDEX _first_block;
 // this should be in-sync with current FPI always; plz
	BLOCKINDEX block;
  // someone already deleted this...
	LOGICAL delete_on_close;
	BLOCKINDEX *blockChain;
	BLOCKINDEX blockChainAvail;
	BLOCKINDEX blockChainLength;
#  ifdef FILE_BASED_VFS
  // where to write the directory entry update to
	FPI entry_fpi;
#    ifdef VIRTUAL_OBJECT_STORE
	enum block_cache_entries cache;
	struct memoryTimelineNode *timeline;
	uint8_t *seal;
	uint8_t *sealant;
	uint8_t *readKey;
	uint16_t readKeyLen;
	uint8_t sealantLen;
 // boolean, on read, validates seal.  Defaults to FALSE.
	uint8_t sealed;
	char *filename;
#    endif
  // has file size within
	struct directory_entry _entry;
  // has file size within
	struct directory_entry *entry;
#  else
  // has file size within
	struct directory_entry *entry;
#  endif
};
#endif
#  undef TSEEK
#  undef BTSEEK
#  ifdef VIRTUAL_OBJECT_STORE
#    define TSEEK(type,v,o,s,c) ((type)vfs_os_SEEK(v,o,s,&c))
#    define BTSEEK(type,v,o,s,c) ((type)vfs_os_BSEEK(v,o,s,&c))
#  elif defined FILE_BASED_VFS
#    define TSEEK(type,v,o,c) ((type)vfs_fs_SEEK(v,o,&c))
#    define BTSEEK(type,v,o,c) ((type)vfs_fs_BSEEK(v,o,&c))
#  else
#    define TSEEK(type,v,o,c) ((type)vfs_SEEK(v,o,&c))
#    define BTSEEK(type,v,o,c) ((type)vfs_BSEEK(v,o,&c))
#  endif
#if defined( __GNUC__ ) && !defined( _WIN32 )
#define HIDDEN __attribute__ ((visibility ("hidden")))
#else
#define HIDDEN
#endif
#if !defined( VIRTUAL_OBJECT_STORE ) && !defined( FILE_BASED_VFS )
  uintptr_t vfs_SEEK( struct sack_vfs_volume* vol, FPI offset, enum block_cache_entries* cache_index ) HIDDEN;
  uintptr_t vfs_BSEEK( struct sack_vfs_volume* vol, BLOCKINDEX block, enum block_cache_entries* cache_index ) HIDDEN;
#elif defined( VIRTUAL_OBJECT_STORE )
  uintptr_t vfs_os_SEEK( struct sack_vfs_os_volume* vol, FPI offset, int size, enum block_cache_entries* cache_index ) HIDDEN;
  uintptr_t vfs_os_BSEEK( struct sack_vfs_os_volume* vol, BLOCKINDEX block, int size, enum block_cache_entries* cache_index ) HIDDEN;
#elif defined( FILE_BASED_VFS )
  uintptr_t vfs_fs_SEEK( struct sack_vfs_fs_volume* vol, FPI offset, enum block_cache_entries* cache_index ) HIDDEN;
  uintptr_t vfs_fs_BSEEK( struct sack_vfs_fs_volume* vol, BLOCKINDEX block, enum block_cache_entries* cache_index ) HIDDEN;
#endif
#if defined( VIRTUAL_OBJECT_STORE ) || defined( FILE_BASED_VFS )
#   ifdef __cplusplus
}
using namespace sack::SACK_VFS;
#   endif
#  endif
#ifdef __cplusplus
namespace fs {
#endif
//#define PARANOID_INIT
//#define DEBUG_TRACE_LOG
#ifdef DEBUG_TRACE_LOG
#define LoG( a,... ) lprintf( a,##__VA_ARGS__ )
#else
#define LoG( a,... )
#endif
#undef TSEEK
#define TSEEK(type,v,o,c) ((type)vfs_fs_SEEK(v,o,&c))
#undef BTSEEK
#define BTSEEK(type,v,o,c) ((type)vfs_fs_BSEEK(v,o,&c))
#define l vfs_fs_local
static struct {
	struct directory_entry zero_entkey;
	uint8_t zerokey[BLOCK_SIZE];
} l;
#define EOFBLOCK  (~(BLOCKINDEX)0)
#define EOBBLOCK  ((BLOCKINDEX)1)
#define EODMARK   (1)
#define GFB_INIT_NONE   0
#define GFB_INIT_DIRENT 1
#define GFB_INIT_NAMES  2
static BLOCKINDEX _fs_GetFreeBlock( struct sack_vfs_fs_volume *vol, int init );
static LOGICAL _fs_ScanDirectory( struct sack_vfs_fs_volume *vol, const char * filename, FPI *dirFPI, struct directory_entry *dirent, struct directory_entry *dirkey, int path_match );
static char _fs_mytolower( int c ) {	if( c == '\\' ) return '/'; return tolower( c ); }
static int  _fs_PathCaseCmpEx ( CTEXTSTR s1, CTEXTSTR s2, size_t maxlen )
{
	if( !s1 )
		if( s2 )
			return -1;
		else
			return 0;
	else
		if( !s2 )
			return 1;
	if( s1 == s2 )
 // ==0 is success.
		return 0;
	for( ;s1[0] && s2[0] && ( (s1[0]=='/'&&s2[0]=='\\')||(s1[0]=='\\'&&s2[0]=='/')||
									 (((s1[0] >='a' && s1[0] <='z' )?s1[0]-('a'-'A'):s1[0])
									 == ((s2[0] >='a' && s2[0] <='z' )?s2[0]-('a'-'A'):s2[0])) ) && maxlen;
		  s1++, s2++, maxlen-- );
	if( maxlen )
		return tolower(s1[0]) - tolower(s2[0]);
	return 0;
}
// read the byte from namespace at offset; decrypt byte in-register
// compare against the filename bytes.
static int _fs_MaskStrCmp( struct sack_vfs_fs_volume *vol, CTEXTSTR filename, FPI name_offset, int path_match ) {
	const char *dirname = (const char*)(vol->usekey_buffer[BC(NAMES)] + (name_offset&BLOCK_MASK));
	if( vol->key ) {
		int c;
		while(  ( c = (dirname[name_offset] ^ vol->usekey[BC(NAMES)][name_offset&BLOCK_MASK] ) )
			  && filename[0] ) {
			int del = _fs_mytolower(filename[0]) - _fs_mytolower(c);
			if( del ) return del;
			filename++;
			name_offset++;
			if( path_match && !filename[0] ) {
				c = (dirname[name_offset] ^ vol->usekey[BC(NAMES)][name_offset&BLOCK_MASK] );
				if( c == '/' || c == '\\' ) return 0;
			}
		}
		// c will be 0 or filename will be 0...
		if( path_match ) return 1;
		return filename[0] - c;
	} else {
		//LoG( "doesn't volume always have a key?" );
		if( path_match ) {
			size_t l;
			int r = _fs_PathCaseCmpEx( filename, dirname + name_offset, l = strlen( filename ) );
			if( !r )
				if( (dirname + name_offset)[l] == '/' || (dirname + name_offset)[l] == '\\' )
					return 0;
				else
					return 1;
			return r;
		}
		else
			return _fs_PathCaseCmpEx( filename, dirname, strlen(filename) );
	}
}
#ifdef DEBUG_TRACE_LOG
static void _fs_MaskStrCpy( char *output, size_t outlen, struct sack_vfs_fs_volume *vol, FPI name_offset ) {
	if( vol->key ) {
		int c;
		FPI name_start = name_offset;
		while(  ( c = ( vol->usekey_buffer[BC(NAMES)][name_offset&BLOCK_MASK] ^ vol->usekey[BC(NAMES)][name_offset&BLOCK_MASK] ) ) ) {
			if( ( name_offset - name_start ) < outlen )
				output[name_offset-name_start] = c;
			name_offset++;
		}
		if( ( name_offset - name_start ) < outlen )
			output[name_offset-name_start] = 0;
		else
			output[outlen-1] = 0;
	} else {
		//LoG( "doesn't volume always have a key?" );
		StrCpyEx( output, (const char *)(vol->usekey[BC(NAMES)] + (name_offset & BLOCK_MASK )), outlen );
	}
}
#endif
#ifdef _MSC_VER
// this is about nLeast being uninitialized.  If nLeast is used
// its value will have been set; otherwise it will not be used.
#pragma warning( disable: 6001 )
#endif
static int _fs_updateCacheAge( struct sack_vfs_fs_volume *vol, enum block_cache_entries *cache_idx, BLOCKINDEX segment, uint8_t *age, int ageLength ) {
	int n, m;
	int nLeast;
	for( n = 0; n < (ageLength); n++ ) {
		if( vol->segment[cache_idx[0] + n] == segment ) {
			cache_idx[0] = (enum block_cache_entries)((cache_idx[0])+n);
			for( m = 0; m < (ageLength); m++ ) {
				if( !age[m] ) break;
				if( age[m] > age[n] )
					age[m]--;
			}
			age[n] = m;
			break;
		}
		if( !age[n] ) {
			cache_idx[0] = (enum block_cache_entries)((cache_idx[0])+n);
			for( m = 0; m < (ageLength); m++ ) {
				if( !age[m] ) break;
				if( age[m] > ( n + 1 ) )
					age[m]--;
			}
			age[n] = n + 1;
			break;
		}
		if( age[n] == 1 ) nLeast = n;
	}
	if( n == (ageLength) ) {
		for( n = 0; n < (ageLength); n++ ) {
			age[n]--;
		}
		age[nLeast] = (ageLength);
		return (enum block_cache_entries)(nLeast);
	}
	return (enum block_cache_entries)(n);
}
#ifdef _MSC_VER
#pragma warning( default: 6001 )
#endif
static enum block_cache_entries _fs_UpdateSegmentKey( struct sack_vfs_fs_volume *vol, enum block_cache_entries cache_idx, BLOCKINDEX segment )
{
	if( !vol->key ) {
		vol->segment[cache_idx] = segment;
		return cache_idx;
	}
	if( cache_idx == BC(FILE) ) {
		_fs_updateCacheAge( vol, &cache_idx, segment, vol->fileCacheAge, (BC(FILE_LAST) - BC(FILE)) );
	}
	else if( cache_idx == BC(NAMES) ) {
		_fs_updateCacheAge( vol, &cache_idx, segment, vol->nameCacheAge, (BC(NAMES_LAST) - BC(NAMES)) );
	}
	vol->segment[cache_idx] = segment;
	if( vol->segment[cache_idx] == vol->_segment[cache_idx] )
		return cache_idx;
	SRG_ResetEntropy( vol->entropy );
	vol->_segment[cache_idx] = vol->segment[cache_idx];
  // so we know which 'segment[idx]' to use.
	vol->curseg = cache_idx;
	SRG_GetEntropyBuffer( vol->entropy, (uint32_t*)vol->segkey, SHORTKEY_LENGTH * 8 );
	{
		int n;
#ifdef __64__
		uint64_t* usekey = (uint64_t*)vol->usekey[cache_idx];
		uint64_t* volkey = (uint64_t*)vol->key;
		uint64_t* segkey = (uint64_t*)vol->segkey;
		for( n = 0; n < (BLOCK_SIZE / SHORTKEY_LENGTH); n++ ) {
			usekey[0] = volkey[0] ^ (segkey[0]);
			usekey[1] = volkey[1] ^ (segkey[1]);
			usekey += 2;
			volkey += 2;
		}
#else
		uint32_t* usekey = (uint32_t*)vol->usekey[cache_idx];
		uint32_t* volkey = (uint32_t*)vol->key;
		uint32_t* segkey = (uint32_t*)vol->segkey;
		for( n = 0; n < (BLOCK_SIZE / SHORTKEY_LENGTH); n++ ) {
			usekey[0] = volkey[0] ^ (segkey[0]);
			usekey[1] = volkey[1] ^ (segkey[1]);
			usekey[2] = volkey[2] ^ (segkey[2]);
			usekey[3] = volkey[3] ^ (segkey[3]);
			usekey += 4;
			volkey += 4;
		}
#endif
	}
	return cache_idx;
}
static LOGICAL _fs_ValidateBAT( struct sack_vfs_fs_volume *vol ) {
	BLOCKINDEX first_slab = 0;
	BLOCKINDEX slab = (BLOCKINDEX)(vol->dwSize / ( BLOCK_SIZE ));
	BLOCKINDEX last_block = ( slab * BLOCKS_PER_BAT ) / BLOCKS_PER_SECTOR;
	BLOCKINDEX n;
	enum block_cache_entries cache = BC(BAT);
	if( vol->key ) {
		for( n = first_slab; n < slab; n += BLOCKS_PER_SECTOR  ) {
			size_t m;
			BLOCKINDEX *BAT;
			BLOCKINDEX *blockKey;
			BAT = TSEEK( BLOCKINDEX*, vol, n * BLOCK_SIZE, cache );
			blockKey = ((BLOCKINDEX*)vol->usekey[BC(BAT)]);
			_fs_UpdateSegmentKey( vol, BC(BAT), n + 1 );
			for( m = 0; m < BLOCKS_PER_BAT; m++ )
			{
				BLOCKINDEX block = BAT[0] ^ blockKey[0];
				BAT++; blockKey++;
				if( block == EOFBLOCK ) continue;
				if( block == EOBBLOCK ) break;
				if( block >= last_block ) return FALSE;
			}
			if( m < BLOCKS_PER_BAT ) break;
		}
	} else {
		for( n = first_slab; n < slab; n += BLOCKS_PER_SECTOR  ) {
			size_t m;
			BLOCKINDEX *BAT = TSEEK( BLOCKINDEX*, vol, n * BLOCK_SIZE, cache );
			for( m = 0; m < BLOCKS_PER_BAT; m++ ) {
				BLOCKINDEX block = BAT[m];
				if( block == EOFBLOCK ) continue;
				if( block == EOBBLOCK ) break;
				if( block >= last_block ) return FALSE;
			}
			if( m < BLOCKS_PER_BAT ) break;
		}
	}
	if( !_fs_ScanDirectory( vol, NULL, NULL, NULL, NULL, 0 ) ) return FALSE;
	return TRUE;
}
//-------------------------------------------------------
// function to process a currently loaded program to get the
// data offset at the end of the executable.
#if 0
static POINTER _fs_GetExtraData( POINTER block )
{
#ifdef WIN32
#  define Seek(a,b) (((uintptr_t)a)+(b))
	//uintptr_t source_memory_length = block_len;
	POINTER source_memory = block;
	{
		PIMAGE_DOS_HEADER source_dos_header = (PIMAGE_DOS_HEADER)source_memory;
		PIMAGE_NT_HEADERS source_nt_header = (PIMAGE_NT_HEADERS)Seek( source_memory, source_dos_header->e_lfanew );
		if( source_dos_header->e_magic != IMAGE_DOS_SIGNATURE ) {
			LoG( "Basic signature check failed; not a library" );
			return NULL;
		}
		if( source_nt_header->Signature != IMAGE_NT_SIGNATURE ) {
			LoG( "Basic NT signature check failed; not a library" );
			return NULL;
		}
		if( source_nt_header->FileHeader.SizeOfOptionalHeader )
		{
			if( source_nt_header->OptionalHeader.Magic != IMAGE_NT_OPTIONAL_HDR_MAGIC )
			{
				LoG( "Optional header signature is incorrect..." );
				return NULL;
			}
		}
		{
			int n;
			long FPISections = source_dos_header->e_lfanew
				+ sizeof( DWORD ) + sizeof( IMAGE_FILE_HEADER )
				+ source_nt_header->FileHeader.SizeOfOptionalHeader;
			PIMAGE_SECTION_HEADER source_section = (PIMAGE_SECTION_HEADER)Seek( source_memory, FPISections );
			uintptr_t dwSize = 0;
			uintptr_t newSize;
			source_section = (PIMAGE_SECTION_HEADER)Seek( source_memory, FPISections );
			for( n = 0; n < source_nt_header->FileHeader.NumberOfSections; n++ )
			{
				newSize = (source_section[n].PointerToRawData) + source_section[n].SizeOfRawData;
				if( newSize > dwSize )
					dwSize = newSize;
			}
 // pad 1 full block, plus all but 1 byte of a full block(round up)
			dwSize += (BLOCK_SIZE*2)-1;
 // mask off the low bits; floor result to block boundary
			dwSize &= ~(BLOCK_SIZE-1);
			return (POINTER)Seek( source_memory, dwSize );
		}
	}
#  undef Seek
#else
	// need to get elf size...
	return 0;
#endif
}
#endif
static void _fs_AddSalt2( uintptr_t psv, POINTER *salt, size_t *salt_size ) {
	struct datatype { void* start; size_t length; } *data = (struct datatype*)psv;
	(*salt_size) = data->length;
	(*salt) = (POINTER)data->start;
	// only need to make one pass of it....
	data->length = 0;
	data->start = NULL;
}
const uint8_t *sack_vfs_fs_get_signature2( POINTER disk, POINTER diskReal ) {
	if( disk != diskReal ) {
		static uint8_t usekey[BLOCK_SIZE];
		static struct random_context *entropy;
		static struct datatype { void* start; size_t length; } data;
		data.start = diskReal;
		data.length = ((uintptr_t)disk - (uintptr_t)diskReal) - BLOCK_SIZE;
		if( !entropy ) entropy = SRG_CreateEntropy2( _fs_AddSalt2, (uintptr_t)&data );
		SRG_ResetEntropy( entropy );
		SRG_GetEntropyBuffer( entropy, (uint32_t*)usekey, BLOCK_SIZE*CHAR_BIT );
		return usekey;
	}
	return NULL;
}
// add some space to the volume....
static LOGICAL _fs_ExpandVolume( struct sack_vfs_fs_volume *vol ) {
	LOGICAL created = FALSE;
	//LOGICAL path_checked = FALSE;
	//size_t oldsize = vol->dwSize;
	if( vol->file && vol->read_only ) return TRUE;
	if( !vol->file ) {
		{
			char *tmp = StrDup( vol->volname );
			char *dir = (char*)pathrchr( tmp );
			if( dir ) {
				dir[0] = 0;
				if( !IsPath( tmp ) ) MakePath( tmp );
			}
			Deallocate( char*, tmp );
		}
		vol->file = sack_fopen( 0, vol->volname, "rb+" );
		if( !vol->file ) {
			created = TRUE;
			vol->file = sack_fopen( 0, vol->volname, "wb+" );
		}
		sack_fseek( vol->file, 0, SEEK_END );
		vol->dwSize = sack_ftell( vol->file );
		sack_fseek( vol->file, 0, SEEK_SET );
	}
	//vol->dwSize += ((uintptr_t)vol->disk - (uintptr_t)vol->diskReal);
	// a BAT plus the sectors it references... ( BLOCKS_PER_BAT + 1 ) * BLOCK_SIZE
	vol->dwSize += BLOCKS_PER_SECTOR*BLOCK_SIZE;
	LoG( "created expanded volume: %p from %p size:%" _size_f, vol->file, BLOCKS_PER_SECTOR*BLOCK_SIZE, vol->dwSize );
	// can't recover dirents and nameents dynamically; so just assume
	// use the _fs_GetFreeBlock because it will update encypted
	//vol->disk->BAT[0] = EOFBLOCK;  // allocate 1 directory entry block
	//vol->disk->BAT[1] = EOFBLOCK;  // allocate 1 name block
	if( created ) {
		_fs_UpdateSegmentKey( vol, BC(BAT), 1 );
		((BLOCKINDEX*)vol->usekey_buffer[BC(BAT)])[0]
			= EOBBLOCK ^ ((BLOCKINDEX*)vol->usekey[BC(BAT)])[0];
		SETFLAG( vol->dirty, BC(BAT) );
		sack_fseek( vol->file, 0, SEEK_SET );
		sack_fwrite( vol->usekey_buffer[BC(BAT)], 1, BLOCK_SIZE, vol->file );
		/* vol->dirents = */
_fs_GetFreeBlock( vol, GFB_INIT_DIRENT );
		/* vol->nameents = */
_fs_GetFreeBlock( vol, GFB_INIT_NAMES );
	}
	return TRUE;
}
// shared with fuse module
uintptr_t vfs_fs_SEEK( struct sack_vfs_fs_volume *vol, FPI offset, enum block_cache_entries *cache_index ) {
	while( offset >= vol->dwSize ) if( !_fs_ExpandVolume( vol ) ) return 0;
	{
		BLOCKINDEX seg = (offset / BLOCK_SIZE) + 1;
		if( seg != vol->segment[cache_index[0]] ) {
			vol->segment[cache_index[0]] = seg;
			if( TESTFLAG( vol->dirty, cache_index[0] ) ) {
				sack_fseek( vol->file, (size_t)vol->bufferFPI[cache_index[0]], SEEK_SET );
				sack_fwrite( vol->usekey_buffer[cache_index[0]], 1, BLOCK_SIZE, vol->file );
				RESETFLAG( vol->dirty, cache_index[0] );
			}
			cache_index[0] = _fs_UpdateSegmentKey( vol, cache_index[0], seg );
			sack_fseek( vol->file, (size_t)(offset & ~BLOCK_MASK), SEEK_SET );
			if( !sack_fread( vol->usekey_buffer[cache_index[0]], 1, BLOCK_SIZE, vol->file ) )
				memset( vol->usekey_buffer[cache_index[0]], 0, BLOCK_SIZE );
		}
		vol->bufferFPI[cache_index[0]] = offset & ~BLOCK_MASK;
		sack_fseek( vol->file, (size_t)(offset & ~BLOCK_MASK), SEEK_SET );
		return ((uintptr_t)vol->usekey_buffer[cache_index[0]]) + (offset&BLOCK_MASK);
	}
}
// shared with fuse module
uintptr_t vfs_fs_BSEEK( struct sack_vfs_fs_volume *vol, BLOCKINDEX block, enum block_cache_entries *cache_index ) {
	BLOCKINDEX b = BLOCK_SIZE + (block >> BLOCK_INDEX_SHIFT) * (BLOCKS_PER_SECTOR*BLOCK_SIZE) + ( block & (BLOCKS_PER_BAT-1) ) * BLOCK_SIZE;
	while( b >= vol->dwSize ) if( !_fs_ExpandVolume( vol ) ) return 0;
	{
		BLOCKINDEX seg = ( b / BLOCK_SIZE ) + 1;
		if( seg != vol->segment[cache_index[0]] ) {
			vol->segment[cache_index[0]] = seg;
			if( TESTFLAG( vol->dirty, cache_index[0] ) ) {
				sack_fseek( vol->file, (size_t)vol->bufferFPI[cache_index[0]], SEEK_SET );
				sack_fwrite( vol->usekey_buffer[cache_index[0]], 1, BLOCK_SIZE, vol->file );
				RESETFLAG( vol->dirty, cache_index[0] );
			}
			cache_index[0] = _fs_UpdateSegmentKey( vol, cache_index[0], seg );
			sack_fseek( vol->file, (size_t)(b & ~BLOCK_MASK), SEEK_SET );
			if( !sack_fread( vol->usekey_buffer[cache_index[0]], 1, BLOCK_SIZE, vol->file ) )
				memset( vol->usekey_buffer[cache_index[0]], 0, BLOCK_SIZE );
		}
		vol->bufferFPI[cache_index[0]] = b & ~BLOCK_MASK;
		sack_fseek( vol->file, (size_t)(b & ~BLOCK_MASK), SEEK_SET );
		return ((uintptr_t)vol->usekey_buffer[cache_index[0]]) + (b&BLOCK_MASK);
	}
}
static BLOCKINDEX _fs_GetFreeBlock( struct sack_vfs_fs_volume *vol, int init )
{
	size_t n;
	int b = 0;
	enum block_cache_entries cache = BC(BAT);
	BLOCKINDEX *current_BAT = TSEEK( BLOCKINDEX*, vol, 0, cache );
	//FPI start_POS = sack_ftell( vol->file );
	//BLOCKINDEX *start_BAT = current_BAT;
	if( !current_BAT ) return 0;
	do
	{
		BLOCKINDEX check_val;
		BLOCKINDEX *blockKey;
		blockKey = ((BLOCKINDEX*)vol->usekey[BC(BAT)]);
		for( n = 0; n < BLOCKS_PER_BAT; n++ )
		{
			check_val = current_BAT[0] ^ blockKey[0];
			if( !check_val || (check_val == 1) )
			{
				// mark it as claimed; will be enf of file marker...
				// adn thsi result will overwrite previous EOF.
				current_BAT[0] = EOFBLOCK ^ blockKey[0];
				if( init )
				{
					enum block_cache_entries cache;
					cache = _fs_UpdateSegmentKey( vol, BC(FILE), b * (BLOCKS_PER_SECTOR)+n + 1 + 1 );
					while( ((vol->segment[cache]-1)*BLOCK_SIZE) > vol->dwSize ){
						LoG( "looping to get a size %d", ((vol->segment[cache]-1)*BLOCK_SIZE) );
						if( !_fs_ExpandVolume( vol ) ) return 0;
					}
					if( init == GFB_INIT_DIRENT ) {
						memset( vol->usekey_buffer[BC(DIRECTORY)], 0, BLOCK_SIZE );
						((struct directory_entry*)(vol->usekey_buffer[BC(DIRECTORY)]))[0].first_block = EODMARK ^ ((struct directory_entry*)vol->usekey[cache])->first_block;
						LoG( "Initialize Dirent block, make sure disk exists behind target block" );
						sack_fseek( vol->file, (size_t)(vol->segment[cache] - 1) * BLOCK_SIZE, SEEK_SET );
						sack_fwrite( vol->usekey_buffer[BC(DIRECTORY)], 1, BLOCK_SIZE, vol->file );
					}
					else if( init == GFB_INIT_NAMES ) {
						memset( vol->usekey_buffer[BC(NAMES)], 0, BLOCK_SIZE );
						((char*)(vol->usekey_buffer[BC(NAMES)]))[0] = ((char*)vol->usekey[cache])[0];
						LoG( "Initialize name block, make sure disk exists behind target block" );
						sack_fseek( vol->file, (size_t)(vol->segment[cache] - 1) * BLOCK_SIZE, SEEK_SET );
						sack_fwrite( vol->usekey_buffer[BC(NAMES)], 1, BLOCK_SIZE, vol->file );
					}
					//else
					//	memcpy( ((uint8_t*)vol->disk) + (vol->segment[cache]-1) * BLOCK_SIZE, vol->usekey[cache], BLOCK_SIZE );
				}
				SETFLAG( vol->dirty, cache );
				if( (check_val == EOBBLOCK) )
					if( n < (BLOCKS_PER_BAT - 1) ) {
						LoG( "Write EOB to %d", b * BLOCKS_PER_BAT +n + 1 );
						current_BAT[1] = EOBBLOCK ^ blockKey[1];
					}
					else {
						// have to write what is there now, seek will read new block in...
						current_BAT = TSEEK( BLOCKINDEX*, vol, (b + 1) * (BLOCKS_PER_SECTOR*BLOCK_SIZE), cache );
						blockKey = ((BLOCKINDEX*)vol->usekey[BC(BAT)]);
						LoG( "Write EOB to %d", b * BLOCKS_PER_BAT + n );
						current_BAT[0] = EOBBLOCK ^ blockKey[0];
						SETFLAG( vol->dirty, cache );
					}
				LoG( "Return new block:%d", b * BLOCKS_PER_BAT + n );
				return b * BLOCKS_PER_BAT + n;
			}
			current_BAT++;
			blockKey++;
		}
		b++;
		current_BAT = TSEEK( BLOCKINDEX*, vol, b * ( BLOCKS_PER_SECTOR*BLOCK_SIZE), cache );
		//start_POS = sack_ftell( vol->file );
	}while( 1 );
}
static BLOCKINDEX vfs_fs_GetNextBlock( struct sack_vfs_fs_volume *vol, BLOCKINDEX block, int init, LOGICAL expand ) {
	BLOCKINDEX sector = block >> BLOCK_INDEX_SHIFT;
	enum block_cache_entries cache = BC(BAT);
	BLOCKINDEX *this_BAT = TSEEK( BLOCKINDEX *, vol, sector * (BLOCKS_PER_SECTOR*BLOCK_SIZE), cache );
	BLOCKINDEX check_val;
 // if this passes, later ones will also.
	if( !this_BAT ) return 0;
	check_val = (this_BAT[block & (BLOCKS_PER_BAT - 1)]) ^ ((BLOCKINDEX*)vol->usekey[cache])[block & (BLOCKS_PER_BAT-1)];
	if( check_val == EOBBLOCK ) {
		LoG( "This adds a new block becuase after %d is %d", block, check_val );
		(this_BAT[block & (BLOCKS_PER_BAT-1)]) = EOFBLOCK^((BLOCKINDEX*)vol->usekey[BC(BAT)])[block & (BLOCKS_PER_BAT-1)];
		(this_BAT[1+block & (BLOCKS_PER_BAT-1)]) = EOBBLOCK^((BLOCKINDEX*)vol->usekey[BC(BAT)])[1+block & (BLOCKS_PER_BAT-1)];
	}
	else
		LoG( "Block after %d is %d", block, check_val );
	if( check_val == EOFBLOCK || check_val == EOBBLOCK ) {
		LoG( "(DOUBLE UPDATE] This adds a new block becuase after %d is %d", block, check_val );
		if( expand ) {
			BLOCKINDEX key = vol->key?((BLOCKINDEX*)vol->usekey[BC(BAT)])[block & (BLOCKS_PER_BAT-1)]:0;
			check_val = _fs_GetFreeBlock( vol, init );
			// free block might have expanded...
			this_BAT = TSEEK( BLOCKINDEX*, vol, sector * ( BLOCKS_PER_SECTOR*BLOCK_SIZE ), cache );
			if( !this_BAT ) return 0;
			// segment could already be set from the _fs_GetFreeBlock...
			this_BAT[block & (BLOCKS_PER_BAT-1)] = check_val ^ key;
			fwrite( this_BAT, 1, BLOCK_SIZE, vol->file );
		}
	}
	return check_val;
}
static void _fs_AddSalt( uintptr_t psv, POINTER *salt, size_t *salt_size ) {
	struct sack_vfs_fs_volume *vol = (struct sack_vfs_fs_volume *)psv;
	if( vol->sigsalt ) {
		(*salt_size) = vol->sigkeyLength;
		(*salt) = (POINTER)vol->sigsalt;
		vol->sigsalt = NULL;
	}
	else if( vol->datakey ) {
		(*salt_size) = BLOCK_SIZE;
		(*salt) = (POINTER)vol->datakey;
		vol->datakey = NULL;
	}
	else if( vol->userkey ) {
		(*salt_size) = StrLen( vol->userkey );
		(*salt) = (POINTER)vol->userkey;
		vol->userkey = NULL;
	}
	else if( vol->devkey ) {
		(*salt_size) = StrLen( vol->devkey );
		(*salt) = (POINTER)vol->devkey;
		vol->devkey = NULL;
	}
	else if( vol->segment[vol->curseg] ) {
		BLOCKINDEX sector = vol->segment[vol->curseg];
		switch( vol->clusterKeyVersion ) {
		case 0:
			( *salt_size ) = sizeof( vol->segment[vol->curseg] );
			( *salt ) = &vol->segment[vol->curseg];
			break;
		case 1:
			memcpy( vol->tmpSalt, vol->key, 16 );
			vol->tmpSalt[sector & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[0];
			vol->tmpSalt[( sector >> 4 ) & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[1];
			vol->tmpSalt[( sector >> 8 ) & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[2];
			vol->tmpSalt[( sector >> 12 ) & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[3];
			( (BLOCKINDEX*)vol->tmpSalt )[0] ^= sector;
			( (BLOCKINDEX*)vol->tmpSalt )[1] ^= sector;
// sizeof( vol->segment[vol->curseg] );
			( *salt_size ) = 12;
			( *salt ) = vol->tmpSalt;
			break;
		}
	}
	else
		(*salt_size) = 0;
}
static void _fs_AssignKey( struct sack_vfs_fs_volume *vol, const char *key1, const char *key2 )
{
	uintptr_t size = BLOCK_SIZE + BLOCK_SIZE * BC(COUNT) + BLOCK_SIZE + SHORTKEY_LENGTH;
	if( !vol->key_buffer ) {
		int n;
		vol->key_buffer = NewArray( uint8_t, size );
		memset( vol->key_buffer, 0, size );
		for( n = 0; n < BC(COUNT); n++ ) {
			vol->usekey_buffer[n] = vol->key_buffer + (n + 1) * BLOCK_SIZE;
		}
	}
	vol->userkey = key1;
	vol->devkey = key2;
	if( key1 || key2 )
	{
		int n;
		if( !vol->entropy )
			vol->entropy = SRG_CreateEntropy2( _fs_AddSalt, (uintptr_t)vol );
		else
			SRG_ResetEntropy( vol->entropy );
		vol->key = NewArray( uint8_t, size );
		for( n = 0; n < BC(COUNT); n++ ) {
			vol->usekey[n] = vol->key + (n + 1) * BLOCK_SIZE;
			vol->segment[n] = 0;
		}
		vol->segkey = vol->key + BLOCK_SIZE * (BC(COUNT) + 1);
		vol->sigkey = vol->key + BLOCK_SIZE * (BC(COUNT) + 1) + SHORTKEY_LENGTH;
		vol->curseg = BC(DIRECTORY);
		vol->segment[BC(DIRECTORY)] = 0;
		SRG_GetEntropyBuffer( vol->entropy, (uint32_t*)vol->key, BLOCK_SIZE * 8 );
	}
	else {
		int n;
		for( n = 0; n < BC(COUNT); n++ )
			vol->usekey[n] = l.zerokey;
		vol->segkey = l.zerokey;
		vol->sigkey = l.zerokey;
		vol->key = NULL;
	}
}
struct sack_vfs_fs_volume *sack_vfs_fs_load_volume( const char * filepath )
{
	struct sack_vfs_fs_volume *vol = New( struct sack_vfs_fs_volume );
	memset( vol, 0, sizeof( struct sack_vfs_fs_volume ) );
	vol->volname = strdup( filepath );
	_fs_AssignKey( vol, NULL, NULL );
	if( !_fs_ExpandVolume( vol ) || !_fs_ValidateBAT( vol ) ) { Deallocate( struct sack_vfs_fs_volume*, vol ); return NULL; }
	return vol;
}
struct sack_vfs_fs_volume *sack_vfs_fs_load_crypt_volume( const char * filepath, uintptr_t version, const char * userkey, const char * devkey ) {
	struct sack_vfs_fs_volume *vol = New( struct sack_vfs_fs_volume );
	MemSet( vol, 0, sizeof( struct sack_vfs_fs_volume ) );
	if( !version ) version = 2;
	vol->clusterKeyVersion = version - 1;
	vol->volname = strdup( filepath );
	vol->userkey = userkey;
	vol->devkey = devkey;
	_fs_AssignKey( vol, userkey, devkey );
	if( !_fs_ExpandVolume( vol ) || !_fs_ValidateBAT( vol ) ) { sack_vfs_fs_unload_volume( vol ); return NULL; }
	return vol;
}
#if 0
struct sack_vfs_fs_volume *sack_vfs_fs_use_crypt_volume( POINTER memory, size_t sz, uintptr_t version, const char * userkey, const char * devkey ) {
	struct sack_vfs_fs_volume *vol = New( struct sack_vfs_fs_volume );
	MemSet( vol, 0, sizeof( struct sack_vfs_fs_volume ) );
	vol->read_only = 1;
	_fs_AssignKey( vol, userkey, devkey );
	if( !version ) version = 2;
	vol->clusterKeyVersion = version - 1;
	vol->external_memory = TRUE;
	vol->diskReal = (struct sack_vfs_disk*)memory;
	vol->dwSize = sz;
#ifdef WIN32
	// elf has a different signature to check for .so extended data...
	struct sack_vfs_disk *actual_disk;
	if( ((char*)memory)[0] == 'M' && ((char*)memory)[1] == 'Z' ) {
		actual_disk = (struct sack_vfs_disk*)GetExtraData( memory );
		if( actual_disk ) {
			if( ( ( (uintptr_t)actual_disk - (uintptr_t)memory ) < vol->dwSize ) ) {
				const uint8_t *sig = sack_vfs_fs_get_signature2( (POINTER)((uintptr_t)actual_disk-BLOCK_SIZE), memory );
				if( memcmp( sig, (POINTER)(((uintptr_t)actual_disk)-BLOCK_SIZE), BLOCK_SIZE ) ) {
					lprintf( "Signature failed comparison; the core has changed since it was attached" );
					vol->diskReal = NULL;
					vol->dwSize = 0;
					sack_vfs_fs_unload_volume( vol );
					return FALSE;
				}
				vol->dwSize -= ((uintptr_t)actual_disk - (uintptr_t)memory);
				memory = (POINTER)actual_disk;
			} else {
				lprintf( "Signature failed comparison; the core is not attached to anything." );
				vol->diskReal = NULL;
				vol->disk = NULL;
				vol->dwSize = 0;
				sack_vfs_fs_unload_volume( vol );
				return NULL;
			}
		}
	}
#endif
	vol->disk = (struct sack_vfs_disk*)memory;
	if( !_fs_ValidateBAT( vol ) ) { sack_vfs_fs_unload_volume( vol );  return NULL; }
	return vol;
}
#endif
void sack_vfs_fs_unload_volume( struct sack_vfs_fs_volume * vol ) {
	INDEX idx;
	struct sack_vfs_fs_file *file;
	LIST_FORALL( vol->files, idx, struct sack_vfs_fs_file *, file )
		break;
	if( file ) {
		vol->closed = TRUE;
		return;
	}
	strdup_free( (char*)vol->volname );
	DeleteListEx( &vol->files DBG_SRC );
	sack_fclose( vol->file );
	//if( !vol->external_memory )	CloseSpace( vol->diskReal );
	if( vol->key ) {
		Deallocate( uint8_t*, vol->key );
		SRG_DestroyEntropy( &vol->entropy );
	}
	Deallocate( uint8_t*, vol->key_buffer );
	Deallocate( struct sack_vfs_fs_volume*, vol );
}
void sack_vfs_fs_shrink_volume( struct sack_vfs_fs_volume * vol ) {
	size_t n;
	unsigned int b = 0;
	//int found_free; // this block has free data; should be last BAT?
	//BLOCKINDEX last_block = 0;
	//unsigned int last_bat = 0;
	enum block_cache_entries cache = BC(BAT);
	BLOCKINDEX *current_BAT = TSEEK( BLOCKINDEX*, vol, 0, cache );
 // expand failed, tseek failed in response, so don't do anything
	if( !current_BAT ) return;
	do {
		BLOCKINDEX check_val;
		BLOCKINDEX *blockKey;
		blockKey = (BLOCKINDEX*)vol->usekey[BC(BAT)];
		for( n = 0; n < BLOCKS_PER_BAT; n++ ) {
			check_val = *(current_BAT++);
			if( vol->key )	check_val ^= *(blockKey++);
			if( check_val ) {
				//last_bat = b;
				//last_block = n;
			}
		}
		b++;
		if( b * ( BLOCKS_PER_SECTOR*BLOCK_SIZE) < vol->dwSize ) {
			current_BAT = TSEEK( BLOCKINDEX*, vol, b * ( BLOCKS_PER_SECTOR*BLOCK_SIZE), cache );
		} else
			break;
	}while( 1 );
	sack_fclose( vol->file );
	vol->file = NULL;
	/*
	SetFileLength( vol->volname,
			last_bat * BLOCKS_PER_SECTOR * BLOCK_SIZE + ( last_block + 1 + 1 )* BLOCK_SIZE );
	*/
	// setting 0 size will cause expand to do an initial open instead of expanding
	vol->dwSize = 0;
}
static void _fs_mask_block( struct sack_vfs_fs_volume *vol, size_t n ) {
	BLOCKINDEX b = ( 1 + (n >> BLOCK_INDEX_SHIFT) * (BLOCKS_PER_SECTOR) + (n & (BLOCKS_PER_BAT - 1)));
	_fs_UpdateSegmentKey( vol, BC(DATAKEY), b + 1 );
	{
#ifdef __64__
		uint64_t* usekey = (uint64_t*)vol->usekey[BC(DATAKEY)];
		uint64_t* block = (uint64_t*)vol->usekey_buffer[BC( DATAKEY )];
		for( n = 0; n < (BLOCK_SIZE / 16); n++ ) {
			block[0] = block[0] ^ usekey[0];
			block[1] = block[1] ^ usekey[1];
			block += 2; usekey += 2;
		}
#else
		uint32_t* usekey = (uint32_t*)vol->usekey[BC(DATAKEY)];
		uint32_t* block = (uint32_t*)vol->usekey_buffer[BC(DATAKEY)];
		for( n = 0; n < (BLOCK_SIZE / 16); n++ ) {
			block[0] = block[0] ^ usekey[0];
			block[1] = block[1] ^ usekey[1];
			block[2] = block[2] ^ usekey[2];
			block[3] = block[3] ^ usekey[3];
			block += 4; usekey += 4;
		}
#endif
	}
}
LOGICAL sack_vfs_fs_decrypt_volume( struct sack_vfs_fs_volume *vol )
{
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
 // volume is already decrypted, cannot remove key
	if( !vol->key ) { vol->lock = 0; return FALSE; }
	{
		enum block_cache_entries cache = BC(BAT);
		size_t n;
		BLOCKINDEX slab = vol->dwSize / ( BLOCKS_PER_SECTOR * BLOCK_SIZE );
		for( n = 0; n < slab; n++  ) {
			size_t m;
			BLOCKINDEX *blockKey;
// = (BLOCKINDEX*)(((uint8_t*)vol->disk) + n * (BLOCKS_PER_SECTOR * BLOCK_SIZE));
			BLOCKINDEX *block;
			block = TSEEK( BLOCKINDEX*, vol, n * (BLOCKS_PER_SECTOR*BLOCK_SIZE), cache );
			blockKey = ((BLOCKINDEX*)vol->usekey[BC(BAT)]);
			for( m = 0; m < BLOCKS_PER_BAT; m++ ) {
				block[0] ^= blockKey[0];
				if( block[0] == EOBBLOCK ) break;
				else if( block[0] ) _fs_mask_block( vol, (n*BLOCKS_PER_BAT) + m );
				block++;
				blockKey++;
			}
			if( m < BLOCKS_PER_BAT ) break;
		}
	}
	_fs_AssignKey( vol, NULL, NULL );
	vol->lock = 0;
	return TRUE;
}
LOGICAL sack_vfs_fs_encrypt_volume( struct sack_vfs_fs_volume *vol, uintptr_t version, CTEXTSTR key1, CTEXTSTR key2 ) {
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
 // volume already has a key, cannot apply new key
	if( vol->key ) { vol->lock = 0; return FALSE; }
	if( !version ) version = 2;
	vol->clusterKeyVersion = version-1;
	_fs_AssignKey( vol, key1, key2 );
	{
		int done;
		size_t n;
		enum block_cache_entries cache = BC(BAT);
		BLOCKINDEX slab = (vol->dwSize + (BLOCKS_PER_SECTOR*BLOCK_SIZE-1)) / ( BLOCKS_PER_SECTOR * BLOCK_SIZE );
		done = 0;
		for( n = 0; n < slab; n++  ) {
			size_t m;
			BLOCKINDEX *blockKey;
// = (BLOCKINDEX*)(((uint8_t*)vol->disk) + n * (BLOCKS_PER_SECTOR * BLOCK_SIZE));
			BLOCKINDEX *block;
			block = TSEEK( BLOCKINDEX*, vol, n * (BLOCKS_PER_SECTOR*BLOCK_SIZE), cache );
			blockKey = ((BLOCKINDEX*)vol->usekey[BC(BAT)]);
			//vol->segment[BC(BAT)] = n + 1;
			for( m = 0; m < BLOCKS_PER_BAT; m++ ) {
				if( block[0] == EOBBLOCK ) done = TRUE;
				else if( block[0] ) _fs_mask_block( vol, (n*BLOCKS_PER_BAT) + m );
				block[0] ^= blockKey[0];
				if( done ) break;
				block++;
				blockKey++;
			}
			if( done ) break;
		}
	}
	vol->lock = 0;
	return TRUE;
}
const char *sack_vfs_fs_get_signature( struct sack_vfs_fs_volume *vol ) {
	static char signature[257];
	static const char *output = "0123456789ABCDEF";
	if( !vol )
		return NULL;
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	{
		static BLOCKINDEX datakey[BLOCKS_PER_BAT];
		uint8_t* usekey = vol->key?vol->usekey[BC(DATAKEY)]:l.zerokey;
		signature[256] = 0;
		memset( datakey, 0, sizeof( datakey ) );
		{
			{
				size_t n;
				BLOCKINDEX this_dir_block = 0;
				BLOCKINDEX next_dir_block;
				BLOCKINDEX *next_entries;
				do {
					enum block_cache_entries cache = BC(DATAKEY);
					next_entries = BTSEEK( BLOCKINDEX *, vol, this_dir_block, cache );
					for( n = 0; n < BLOCKS_PER_BAT; n++ )
						datakey[n] ^= next_entries[n] ^ ((BLOCKINDEX*)(((uint8_t*)usekey)))[n];
					next_dir_block = vfs_fs_GetNextBlock( vol, this_dir_block, GFB_INIT_DIRENT, FALSE );
					if( this_dir_block == next_dir_block )
						DebugBreak();
					if( next_dir_block == 0 )
						DebugBreak();
					this_dir_block = next_dir_block;
				}
				while( next_dir_block != EOFBLOCK );
			}
		}
		if( !vol->entropy )
			vol->entropy = SRG_CreateEntropy2( _fs_AddSalt, (uintptr_t)vol );
		SRG_ResetEntropy( vol->entropy );
		vol->curseg = BC(DIRECTORY);
		vol->segment[vol->curseg] = 0;
		vol->datakey = (const char *)datakey;
		SRG_GetEntropyBuffer( vol->entropy, (uint32_t*)usekey, 128 * 8 );
		{
			int n;
			for( n = 0; n < 128; n++ ) {
				signature[n*2] = output[( usekey[n] >> 4 ) & 0xF];
				signature[n*2+1] = output[usekey[n] & 0xF];
			}
		}
	}
	vol->lock = 0;
	return signature;
}
LOGICAL _fs_ScanDirectory( struct sack_vfs_fs_volume *vol, const char * filename, FPI *dirFPI, struct directory_entry *dirent, struct directory_entry *dirkey, int path_match ) {
	size_t n;
	BLOCKINDEX this_dir_block = 0;
	BLOCKINDEX next_dir_block;
	struct directory_entry *next_entries;
	if( filename && filename[0] == '.' && filename[1] == '/' ) filename += 2;
	do {
		enum block_cache_entries cache = BC(DIRECTORY);
		next_entries = BTSEEK( struct directory_entry *, vol, this_dir_block, cache );
		for( n = 0; n < VFS_DIRECTORY_ENTRIES; n++ ) {
			BLOCKINDEX bi;
			struct directory_entry *entkey = ( vol->key)?((struct directory_entry *)vol->usekey[cache])+n:&l.zero_entkey;
			struct directory_entry *entry = ((struct directory_entry *)vol->usekey_buffer[cache]) + n;
			//const char * testname;
			FPI name_ofs = next_entries[n].name_offset ^ entkey->name_offset;
 // done.
			if( filename && !name_ofs )	return FALSE;
			LoG( "%d ch:%d addr:%p name_ofs = %" _size_f "(%" _size_f ") block = %d  vs %s"
			   , n, cache, next_entries + n , name_ofs
			   , next_entries[n].name_offset ^ entkey->name_offset
			   , next_entries[n].first_block ^ entkey->first_block
			   , filename );
			bi = next_entries[n].first_block ^ entkey->first_block;
			// if file is deleted; don't check it's name.
			if( !bi ) continue;
			// if file is end of directory, done sanning.
 // done.
			if( bi == EODMARK ) return filename?FALSE:(2);
			if( name_ofs > vol->dwSize ) { return FALSE; }
			//testname =
			if( filename ) {
#if defined( DEBUG_TRACE_LOG )
				enum block_cache_entries name_cache = BC(NAMES);
 // have to do the seek to the name block otherwise it might not be loaded.
				const char *names = TSEEK( const char *, vol, name_ofs, name_cache );
				LoG( "this name: %s", names );
#endif
				if( _fs_MaskStrCmp( vol, filename, name_ofs, path_match ) == 0 ) {
					if( dirkey ) {
						dirkey[0] = (*entkey);
						if( dirent ) {
							if( dirFPI )
								dirFPI[0] = vol->segment[cache] * BLOCK_SIZE
								          + ( n * sizeof( struct directory_entry ) );
							dirent->first_block = entry->first_block;
							dirent->name_offset = entry->name_offset;
							dirent->filesize = entry->filesize;
						}
					}
					LoG( "return found entry: %p (%" _size_f ":%" _size_f ") %s", next_entries + n, name_ofs, next_entries[n].first_block ^ dirkey->first_block, filename );
					return TRUE;
				}
			}
		}
		next_dir_block = vfs_fs_GetNextBlock( vol, this_dir_block, FALSE, TRUE );
#ifdef _DEBUG
		if( this_dir_block == next_dir_block ) DebugBreak();
#endif
  // should have a last-entry before no more blocks....
		if( next_dir_block == 0 ) { DebugBreak(); return FALSE; }
		this_dir_block = next_dir_block;
	}
	while( 1 );
}
// this results in an absolute disk position
static FPI _fs_SaveFileName( struct sack_vfs_fs_volume *vol, const char * filename ) {
	size_t n;
	BLOCKINDEX this_name_block = 1;
	while( 1 ) {
		enum block_cache_entries cache = BC(NAMES);
		TEXTSTR names = BTSEEK( TEXTSTR, vol, this_name_block, cache );
		unsigned char *name = (unsigned char*)names;
		while( name < ( (unsigned char*)names + BLOCK_SIZE ) ) {
			int c = name[0];
			if( vol->key ) c = c ^ vol->usekey[cache][(uintptr_t)name-(uintptr_t)names];
			if( !c ) {
				size_t namelen;
				if( ( namelen = StrLen( filename ) ) < (size_t)( ( (unsigned char*)names + BLOCK_SIZE ) - name ) ) {
					LoG( "using unused entry for new file...%" _size_f "  %" _size_f " %s", this_name_block, (uintptr_t)name - (uintptr_t)names, filename );
					if( vol->key ) {
						for( n = 0; n < namelen + 1; n++ )
							name[n] = filename[n] ^ vol->usekey[cache][n + (name-(unsigned char*)names)];
						if( (namelen + 1) < (size_t)(((unsigned char*)names + BLOCK_SIZE) - name) )
							name[n] = vol->usekey[cache][n + (name - (unsigned char*)names)];
					} else
						memcpy( name, filename, ( namelen + 1 ) );
					sack_fwrite( vol->usekey_buffer[cache], 1, BLOCK_SIZE, vol->file );
					return ((uintptr_t)name) - ((uintptr_t)names) + vol->bufferFPI[cache];
				}
			}
			else
				if( _fs_MaskStrCmp( vol, filename, (uintptr_t)name - (uintptr_t)names, 0 ) == 0 ) {
					LoG( "using existing entry for new file...%s", filename );
					return ((uintptr_t)name) - ((uintptr_t)names) + vol->bufferFPI[cache];
				}
			if( vol->key ) {
				while( ( name[0] ^ vol->usekey[cache][name-(unsigned char*)names] ) ) name++;
				name++;
			} else
				name = name + StrLen( (const char*)name ) + 1;
			//LoG( "new position is %" _size_f "  %" _size_f, this_name_block, (uintptr_t)name - (uintptr_t)names );
		}
		this_name_block = vfs_fs_GetNextBlock( vol, this_name_block, GFB_INIT_DIRENT, TRUE );
		LoG( "Need a new directory block....", this_name_block );
	}
}
static struct directory_entry * _fs_GetNewDirectory( struct sack_vfs_fs_volume *vol, const char * filename, FPI *entFPI, struct directory_entry *dirent, struct directory_entry *_entkey ) {
	size_t n;
	BLOCKINDEX this_dir_block = 0;
	struct directory_entry *next_entries;
	LOGICAL moveMark = FALSE;
	do {
		enum block_cache_entries cache = BC(DIRECTORY);
		FPI dirblockFPI;
		next_entries = BTSEEK( struct directory_entry *, vol, this_dir_block, cache );
		dirblockFPI = sack_ftell( vol->file );
		for( n = 0; n < VFS_DIRECTORY_ENTRIES; n++ ) {
			struct directory_entry *entkey = ( vol->key )?((struct directory_entry *)vol->usekey[cache])+n:&l.zero_entkey;
			struct directory_entry *ent = next_entries + n;
			FPI name_ofs = ent->name_offset ^ entkey->name_offset;
			BLOCKINDEX first_blk = ent->first_block ^ entkey->first_block;
			// not name_offset (end of list) or not first_block(free entry) use this entry
			if( name_ofs && (first_blk > 1) )  continue;
			if( first_blk == EODMARK ) moveMark = TRUE;
			name_ofs = _fs_SaveFileName( vol, filename ) ^ entkey->name_offset;
			first_blk = _fs_GetFreeBlock( vol, FALSE ) ^ entkey->first_block;
			//ent = next_entries + n;
			_entkey[0] = entkey[0];
			entFPI[0] = dirblockFPI + n * sizeof( struct directory_entry );
			dirent->filesize = ent->filesize = entkey->filesize;
			dirent->name_offset = ent->name_offset = name_ofs;
			dirent->first_block = ent->first_block = first_blk;
			sack_fseek( vol->file, (size_t)entFPI[0], SEEK_SET );
			sack_fwrite( dirent, 1, sizeof( *dirent ), vol->file );
			if( n < (VFS_DIRECTORY_ENTRIES - 1) ) {
				if( moveMark ) {
					struct directory_entry *enttmp = next_entries + (n + 1);
					enttmp->first_block = EODMARK ^ entkey[1].first_block;
					sack_fseek( vol->file, (size_t)(entFPI[0] + sizeof( struct directory_entry )), SEEK_SET );
					sack_fwrite( enttmp, 1, sizeof( *dirent ), vol->file );
				}
			} else {
				// otherwise pre-init the next directory sector
				this_dir_block = vfs_fs_GetNextBlock( vol, this_dir_block, GFB_INIT_DIRENT, TRUE );
			}
			return dirent;
		}
		this_dir_block = vfs_fs_GetNextBlock( vol, this_dir_block, GFB_INIT_DIRENT, TRUE );
	}
	while( 1 );
}
struct sack_vfs_fs_file * CPROC sack_vfs_fs_openfile( struct sack_vfs_fs_volume *vol, const char * filename ) {
	struct sack_vfs_fs_file *file = New( struct sack_vfs_fs_file );
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	if( filename[0] == '.' && filename[1] == '/' ) filename += 2;
	LoG( "sack_vfs open %s = %p on %s", filename, file, vol->volname );
	file->entry = &file->_entry;
	if( !_fs_ScanDirectory( vol, filename, &file->entry_fpi, &file->_entry, &file->dirent_key, 0 ) ) {
		if( vol->read_only ) { LoG( "Fail open: readonly" ); vol->lock = 0; Deallocate( struct sack_vfs_fs_file *, file ); return NULL; }
		else _fs_GetNewDirectory( vol, filename, &file->entry_fpi, file->entry, &file->dirent_key );
	}
	file->vol = vol;
	file->fpi = 0;
	file->delete_on_close = 0;
	file->_first_block = file->block = file->entry->first_block ^ file->dirent_key.first_block;
	AddLink( &vol->files, file );
	vol->lock = 0;
	return file;
}
static struct sack_vfs_fs_file * CPROC sack_vfs_fs_open( uintptr_t psvInstance, const char * filename, const char *opts ) {
	return sack_vfs_fs_openfile( (struct sack_vfs_fs_volume*)psvInstance, filename );
}
int CPROC sack_vfs_fs_exists( struct sack_vfs_fs_volume *vol, const char * file ) {
	LOGICAL result;
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	if( file[0] == '.' && file[1] == '/' ) file += 2;
	result = _fs_ScanDirectory( vol, file, NULL, NULL, NULL, 0 );
	vol->lock = 0;
	return result;
}
size_t CPROC sack_vfs_fs_tell( struct sack_vfs_fs_file *file ) { return (size_t)file->fpi; }
size_t CPROC sack_vfs_fs_size( struct sack_vfs_fs_file *file ) { return (size_t)(file->entry->filesize ^ file->dirent_key.filesize); }
size_t CPROC sack_vfs_fs_seek( struct sack_vfs_fs_file *file, size_t pos, int whence )
{
	FPI old_fpi = file->fpi;
	if( whence == SEEK_SET ) file->fpi = pos;
	if( whence == SEEK_CUR ) file->fpi += pos;
	if( whence == SEEK_END ) file->fpi = ( file->entry->filesize  ^ file->dirent_key.filesize ) + pos;
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	{
		if( ( file->fpi & ( ~BLOCK_MASK ) ) >= ( old_fpi & ( ~BLOCK_MASK ) ) ) {
			do {
				if( ( file->fpi & ( ~BLOCK_MASK ) ) == ( old_fpi & ( ~BLOCK_MASK ) ) ) {
					file->vol->lock = 0;
					return (size_t)file->fpi;
				}
				file->block = vfs_fs_GetNextBlock( file->vol, file->block, FALSE, TRUE );
				old_fpi += BLOCK_SIZE;
			} while( 1 );
		}
	}
	{
		size_t n = 0;
		BLOCKINDEX b = file->_first_block;
		while( n * BLOCK_SIZE < ( pos & ~BLOCK_MASK ) ) {
			b = vfs_fs_GetNextBlock( file->vol, b, FALSE, TRUE );
			n++;
		}
		file->block = b;
	}
	file->vol->lock = 0;
	return (size_t)file->fpi;
}
static void _fs_MaskBlock( struct sack_vfs_fs_volume *vol, uint8_t* usekey, uint8_t* block, BLOCKINDEX block_ofs, size_t ofs, const char *data, size_t length ) {
	size_t n;
	block += block_ofs;
	usekey += ofs;
	if( vol->key )
		for( n = 0; n < length; n++ ) (*block++) = (*data++) ^ (*usekey++);
	else
		memcpy( block, data, length );
}
size_t CPROC sack_vfs_fs_write( struct sack_vfs_fs_file *file, const void * data_, size_t length ) {
	const char* data = (const char*)data_;
	size_t written = 0;
	size_t ofs = file->fpi & BLOCK_MASK;
	LOGICAL updated = FALSE;
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	LoG( "Write to file %p %" _size_f "  @%" _size_f, file, length, ofs );
	if( ofs ) {
		enum block_cache_entries cache = BC(FILE);
		uint8_t* block = (uint8_t*)vfs_fs_BSEEK( file->vol, file->block, &cache );
		if( length >= ( BLOCK_SIZE - ( ofs ) ) ) {
			_fs_MaskBlock( file->vol, file->vol->usekey[cache], block, ofs, ofs, data, BLOCK_SIZE - ofs );
			sack_fwrite( block + ofs, BLOCK_SIZE - ofs, 1, file->vol->file );
			data += BLOCK_SIZE - ofs;
			written += BLOCK_SIZE - ofs;
			file->fpi += BLOCK_SIZE - ofs;
			if( file->fpi > (file->entry->filesize ^ file->dirent_key.filesize) ) {
				file->entry->filesize = file->fpi ^ file->dirent_key.filesize;
				updated = TRUE;
			}
			file->block = vfs_fs_GetNextBlock( file->vol, file->block, FALSE, TRUE );
			length -= BLOCK_SIZE - ofs;
		} else {
			_fs_MaskBlock( file->vol, file->vol->usekey[cache], block, ofs, ofs, data, length );
			sack_fwrite( file->vol->usekey_buffer[cache] + ofs, BLOCK_SIZE - ofs, 1, file->vol->file );
			data += length;
			written += length;
			file->fpi += length;
			if( file->fpi > (file->entry->filesize ^ file->dirent_key.filesize) ) {
				file->entry->filesize = file->fpi ^ file->dirent_key.filesize;
				updated = TRUE;
			}
			length = 0;
		}
	}
	// if there's still length here, FPI is now on the start of blocks
	while( length )
	{
		enum block_cache_entries cache = BC(FILE);
		uint8_t* block = (uint8_t*)vfs_fs_BSEEK( file->vol, file->block, &cache );
		if( file->block < 2 ) DebugBreak();
		if( length >= BLOCK_SIZE ) {
			_fs_MaskBlock( file->vol, file->vol->usekey[cache], block, 0, 0, data, BLOCK_SIZE );
			sack_fwrite( block, 1, BLOCK_SIZE, file->vol->file );
			data += BLOCK_SIZE;
			written += BLOCK_SIZE;
			file->fpi += BLOCK_SIZE;
			if( file->fpi > (file->entry->filesize ^ file->dirent_key.filesize) ) {
				updated = TRUE;
				file->entry->filesize = file->fpi ^ file->dirent_key.filesize;
			}
			file->block = vfs_fs_GetNextBlock( file->vol, file->block, FALSE, TRUE );
			length -= BLOCK_SIZE;
		} else {
			_fs_MaskBlock( file->vol, file->vol->usekey[cache], block, 0, 0, data, length );
			sack_fwrite( block, 1, BLOCK_SIZE, file->vol->file );
			data += length;
			written += length;
			file->fpi += length;
			if( file->fpi > (file->entry->filesize ^ file->dirent_key.filesize) ) {
				updated = TRUE;
				file->entry->filesize = file->fpi ^ file->dirent_key.filesize;
			}
			length = 0;
		}
	}
	if( updated ) {
		sack_fseek( file->vol->file, (size_t)file->entry_fpi, SEEK_SET );
		sack_fwrite( file->entry, 1, sizeof( *file->entry ), file->vol->file );
	}
	file->vol->lock = 0;
	LoG( "Data to write, return %d.", written );
	return written;
}
size_t CPROC sack_vfs_fs_read( struct sack_vfs_fs_file *file, void * data_, size_t length ) {
	char* data = (char*)data_;
	size_t written = 0;
	size_t ofs = file->fpi & BLOCK_MASK;
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	LoG( "Read to file %p %" _size_f "  @%" _size_f, file, length, ofs );
	if( ( file->entry->filesize  ^ file->dirent_key.filesize ) < ( file->fpi + length ) ) {
		if( ( file->entry->filesize  ^ file->dirent_key.filesize ) < file->fpi )
			length = 0;
		else
			length = (size_t)(( file->entry->filesize  ^ file->dirent_key.filesize ) - file->fpi);
	}
	if( !length ) { errno = file->vol->lock = 0; LoG( "No Data to write..." );  return 0; }
	if( ofs ) {
		enum block_cache_entries cache = BC(FILE);
		uint8_t* block = (uint8_t*)vfs_fs_BSEEK( file->vol, file->block, &cache );
		if( length >= ( BLOCK_SIZE - ( ofs ) ) ) {
			_fs_MaskBlock( file->vol, file->vol->usekey[cache], (uint8_t*)data, 0, ofs, (const char*)(block+ofs), BLOCK_SIZE - ofs );
			written += BLOCK_SIZE - ofs;
			data += BLOCK_SIZE - ofs;
			length -= BLOCK_SIZE - ofs;
			file->fpi += BLOCK_SIZE - ofs;
			file->block = vfs_fs_GetNextBlock( file->vol, file->block, FALSE, TRUE );
		} else {
			_fs_MaskBlock( file->vol, file->vol->usekey[cache], (uint8_t*)data, 0, ofs, (const char*)(block+ofs), length );
			written += length;
			file->fpi += length;
			length = 0;
		}
	}
	// if there's still length here, FPI is now on the start of blocks
	while( length ) {
		enum block_cache_entries cache = BC(FILE);
		uint8_t* block = (uint8_t*)vfs_fs_BSEEK( file->vol, file->block, &cache );
		if( length >= BLOCK_SIZE ) {
			_fs_MaskBlock( file->vol, file->vol->usekey[cache], (uint8_t*)data, 0, 0, (const char*)block, BLOCK_SIZE - ofs );
			written += BLOCK_SIZE;
			data += BLOCK_SIZE;
			length -= BLOCK_SIZE;
			file->fpi += BLOCK_SIZE;
			file->block = vfs_fs_GetNextBlock( file->vol, file->block, FALSE, TRUE );
		} else {
			_fs_MaskBlock( file->vol, file->vol->usekey[cache], (uint8_t*)data, 0, 0, (const char*)block, length );
			written += length;
			file->fpi += length;
			length = 0;
		}
	}
	file->vol->lock = 0;
	LoG( "Data read, return %d.", written );
	return written;
}
static void sack_vfs_fs_unlink_file_entry( struct sack_vfs_fs_volume *vol, FPI entFPI, struct directory_entry *entry, struct directory_entry *entkey, BLOCKINDEX first_block, LOGICAL deleted ) {
	BLOCKINDEX block, _block;
	struct sack_vfs_fs_file *file_found = NULL;
	struct sack_vfs_fs_file *file;
	INDEX idx;
	LoG( "Files?%d", vol->files->Cnt );
	LIST_FORALL( vol->files, idx, struct sack_vfs_fs_file *, file ) {
		LoG( "FILE CHECK: %d  %d", idx, file->_first_block );
		if( file->_first_block == first_block ) {
			file_found = file;
			file->delete_on_close = TRUE;
			LoG( "File is still open, mark to delete on close..." );
		}
	}
	if( !deleted ) {
		// delete the file entry now; this disk entry may be reused immediately.
		entry->first_block = entkey->first_block;
		LoG( "Release directory entry (zero first block of file) %d", entry->first_block );
		{
			enum block_cache_entries cache = BC( DIRECTORY );
			struct directory_entry* entkey = (vol->key) ? ((struct directory_entry*)vol->usekey[cache] + (entFPI&BLOCK_MASK)) : &l.zero_entkey;
			struct directory_entry* entry = ((struct directory_entry*)(vol->usekey_buffer[cache] + (entFPI & BLOCK_MASK)));
			LoG( "Entry was: %p %d %d", entry, cache, entry->first_block );
			entry->first_block = entkey->first_block;
		}
		sack_fseek( vol->file, (size_t)entFPI, SEEK_SET );
		sack_fwrite( entry, 1, sizeof( *entry ), vol->file );
	}
	if( !file_found ) {
// entry->first_block ^ entkey->first_block;
		_block = block = first_block;
		LoG( "(marking physical deleted (again?)) entry starts at %d", block );
		// wipe out file chain BAT
		do {
			enum block_cache_entries cache = BC(BAT);
			enum block_cache_entries fileCache = BC(DATAKEY);
			BLOCKINDEX *this_BAT = TSEEK( BLOCKINDEX*, vol, ( ( block >> BLOCK_INDEX_SHIFT ) * ( BLOCKS_PER_SECTOR*BLOCK_SIZE) ), cache );
			BLOCKINDEX _thiskey = ( vol->key )?((BLOCKINDEX*)vol->usekey[cache])[_block & (BLOCKS_PER_BAT-1)]:0;
			//BLOCKINDEX b = BLOCK_SIZE + (block >> BLOCK_INDEX_SHIFT) * (BLOCKS_PER_SECTOR*BLOCK_SIZE) + (block & (BLOCKS_PER_BAT - 1)) * BLOCK_SIZE;
			uint8_t* blockData = (uint8_t*)vfs_fs_BSEEK( vol, block, &fileCache );
			LoG( "Clearing file datablock...%p", (uintptr_t)block*BLOCK_SIZE );
			memset( blockData, 0, BLOCK_SIZE );
			// after seek, block was read, and file position updated.
			sack_fwrite( blockData, 1, BLOCK_SIZE, vol->file );
			block = vfs_fs_GetNextBlock( vol, block, FALSE, FALSE );
			this_BAT[_block & (BLOCKS_PER_BAT-1)] = _thiskey;
			_block = block;
		} while( block != EOFBLOCK );
	}
}
static void _fs_shrinkBAT( struct sack_vfs_fs_file *file ) {
	struct sack_vfs_fs_volume *vol = file->vol;
	BLOCKINDEX block, _block;
	size_t bsize = 0;
	_block = block = file->entry->first_block ^ file->dirent_key.first_block;
	do {
		enum block_cache_entries cache = BC(BAT);
		enum block_cache_entries data_cache = BC(DATAKEY);
		BLOCKINDEX *this_BAT = TSEEK( BLOCKINDEX*, vol, ( ( block >> BLOCK_INDEX_SHIFT ) * ( BLOCKS_PER_SECTOR*BLOCK_SIZE) ), cache );
		BLOCKINDEX _thiskey;
		_thiskey = ( vol->key )?((BLOCKINDEX*)vol->usekey[cache])[_block & (BLOCKS_PER_BAT-1)]:0;
		block = vfs_fs_GetNextBlock( vol, block, FALSE, FALSE );
		if( bsize > (file->entry->filesize ^ file->dirent_key.filesize) ) {
			uint8_t* blockData = (uint8_t*)vfs_fs_BSEEK( file->vol, _block, &data_cache );
			//LoG( "clearing a datablock after a file..." );
			memset( blockData, 0, BLOCK_SIZE );
			this_BAT[_block & (BLOCKS_PER_BAT-1)] = _thiskey;
		} else {
			bsize++;
			if( bsize > (file->entry->filesize ^ file->dirent_key.filesize) ) {
				uint8_t* blockData = (uint8_t*)vfs_fs_BSEEK( file->vol, _block, &data_cache );
				//LoG( "clearing a partial datablock after a file..., %d, %d", BLOCK_SIZE-(file->entry->filesize & (BLOCK_SIZE-1)), ( file->entry->filesize & (BLOCK_SIZE-1)) );
				memset( blockData + (file->entry->filesize & (BLOCK_SIZE-1)), 0, BLOCK_SIZE-(file->entry->filesize & (BLOCK_SIZE-1)) );
				this_BAT[_block & (BLOCKS_PER_BAT-1)] = ~_thiskey;
			}
		}
		_block = block;
	} while( block != EOFBLOCK );
}
size_t CPROC sack_vfs_fs_truncate( struct sack_vfs_fs_file *file ) { file->entry->filesize = file->fpi ^ file->dirent_key.filesize; _fs_shrinkBAT( file ); return (size_t)file->fpi; }
int CPROC sack_vfs_fs_close( struct sack_vfs_fs_file *file ) {
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
#ifdef DEBUG_TRACE_LOG
	{
		enum block_cache_entries cache = BC(NAMES);
		static char fname[256];
		FPI name_ofs = file->entry->name_offset ^ file->dirent_key.name_offset;
 // have to do the seek to the name block otherwise it might not be loaded.
		TSEEK( const char *, file->vol, name_ofs, cache );
		_fs_MaskStrCpy( fname, sizeof( fname ), file->vol, name_ofs );
		LoG( "close file:%s(%p)", fname, file );
	}
#endif
	DeleteLink( &file->vol->files, file );
	if( file->delete_on_close ) sack_vfs_fs_unlink_file_entry( file->vol, file->entry_fpi, file->entry, &file->dirent_key, file->_first_block, TRUE );
	file->vol->lock = 0;
	if( file->vol->closed ) sack_vfs_fs_unload_volume( file->vol );
	Deallocate( struct sack_vfs_fs_file *, file );
	return 0;
}
int CPROC sack_vfs_fs_unlink_file( struct sack_vfs_fs_volume *vol, const char * filename ) {
	int result = 0;
	struct directory_entry entkey;
	struct directory_entry entry;
	FPI entFPI;
	if( !vol ) return 0;
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	LoG( "unlink file:%s", filename );
	if( _fs_ScanDirectory( vol, filename, &entFPI, &entry, &entkey, 0 ) ) {
		sack_vfs_fs_unlink_file_entry( vol, entFPI, &entry, &entkey, entry.first_block ^ entkey.first_block, FALSE );
		result = 1;
	}
	vol->lock = 0;
	return result;
}
	/* noop */
int CPROC sack_vfs_fs_flush( struct sack_vfs_fs_file *file ) {	return 0; }
static LOGICAL CPROC sack_vfs_fs_need_copy_write( void ) {	return FALSE; }
struct sack_vfs_fs_find_info {
	BLOCKINDEX this_dir_block;
	char filename[BLOCK_SIZE];
	struct sack_vfs_fs_volume *vol;
	CTEXTSTR base;
	size_t base_len;
	size_t filenamelen;
	size_t filesize;
	CTEXTSTR mask;
	size_t thisent;
};
struct sack_vfs_fs_find_info * CPROC sack_vfs_fs_find_create_cursor(uintptr_t psvInst,const char *base,const char *mask )
{
	struct sack_vfs_fs_find_info *info = New( struct sack_vfs_fs_find_info );
	info->base = base;
	info->base_len = StrLen( base );
	info->mask = mask;
	info->vol = (struct sack_vfs_fs_volume *)psvInst;
	return (struct sack_vfs_fs_find_info*)info;
}
static int _fs_iterate_find( struct sack_vfs_fs_find_info* cinfo ) {
	struct sack_vfs_fs_find_info *info = (struct sack_vfs_fs_find_info*)cinfo;
	struct directory_entry *next_entries;
	size_t n;
	do {
		enum block_cache_entries cache = BC(DIRECTORY);
		enum block_cache_entries name_cache = BC(NAMES);
		next_entries = BTSEEK( struct directory_entry *, info->vol, info->this_dir_block, cache );
		for( n = info->thisent; n < VFS_DIRECTORY_ENTRIES; n++ ) {
			struct directory_entry *entkey = ( info->vol->key)?((struct directory_entry *)info->vol->usekey[cache])+n:&l.zero_entkey;
			FPI name_ofs = next_entries[n].name_offset ^ entkey->name_offset;
			const char *filename;
			if( !name_ofs )
				return 0;
			// if file is deleted; don't check it's name.
			if( !(next_entries[n].first_block ^ entkey->first_block ) )
				continue;
			if( (next_entries[n].first_block ^ entkey->first_block ) == EODMARK )
 // end of directory.
				return 0;
			info->filesize = (size_t)(next_entries[n].filesize ^ entkey->filesize);
			if( (name_ofs) > info->vol->dwSize ) {
				LoG( "corrupted volume." );
				return 0;
			}
			filename = TSEEK( const char *, info->vol, name_ofs, name_cache );
			if( info->vol->key ) {
				int c;
				info->filenamelen = 0;
				while( ( c = ( ((uint8_t*)filename)[0] ^ info->vol->usekey[name_cache][name_ofs&BLOCK_MASK] ) ) ) {
					info->filename[info->filenamelen++] = c;
					filename++;
					name_ofs++;
				}
				info->filename[info->filenamelen]	 = c;
				LoG( "Scan return filename: %s", info->filename );
				if( info->base
				    && ( info->base[0] != '.' && info->base_len != 1 )
				    && StrCaseCmpEx( info->base, info->filename, info->base_len ) )
					continue;
			} else {
				StrCpy( info->filename, filename );
				LoG( "Scan return filename: %s", info->filename );
				if( info->base
				    && ( info->base[0] != '.' && info->base_len != 1 )
				    && StrCaseCmpEx( info->base, info->filename, info->base_len ) )
					continue;
			}
			info->thisent = n + 1;
			return 1;
		}
 // new block, set new starting index.
		info->thisent = 0;
		info->this_dir_block = vfs_fs_GetNextBlock( info->vol, info->this_dir_block, FALSE, FALSE );
	}
	while( info->this_dir_block != EOFBLOCK );
	return 0;
}
int CPROC sack_vfs_fs_find_first( struct sack_vfs_fs_find_info *cinfo ) {
	struct sack_vfs_fs_find_info *info = (struct sack_vfs_fs_find_info*)cinfo;
	info->this_dir_block = 0;
	info->thisent = 0;
	return _fs_iterate_find( info );
}
int CPROC sack_vfs_fs_find_close( struct sack_vfs_fs_find_info *info ) { Deallocate( struct sack_vfs_fs_find_info*, info ); return 0; }
int CPROC sack_vfs_fs_find_next( struct sack_vfs_fs_find_info *info ) { return _fs_iterate_find( (struct sack_vfs_fs_find_info*)info ); }
char * CPROC sack_vfs_fs_find_get_name( struct sack_vfs_fs_find_info *info ) { return ((struct sack_vfs_fs_find_info*)info)->filename; }
size_t CPROC sack_vfs_fs_find_get_size( struct sack_vfs_fs_find_info *info ) { return ((struct sack_vfs_fs_find_info*)info)->filesize; }
LOGICAL CPROC sack_vfs_fs_find_is_directory( struct sack_vfs_fs_find_info *cursor ) { return FALSE; }
LOGICAL CPROC sack_vfs_fs_is_directory( uintptr_t psvInstance, const char *path ) {
	if( path[0] == '.' && path[1] == 0 ) return TRUE;
	{
		struct sack_vfs_fs_volume *vol = (struct sack_vfs_fs_volume *)psvInstance;
		if( _fs_ScanDirectory( vol, path, NULL, NULL, NULL, 1 ) ) {
			return TRUE;
		}
	}
	return FALSE;
}
uint64_t  CPROC sack_vfs_fs_find_get_ctime( struct sack_vfs_fs_find_info *info ) { return (size_t)0; }
uint64_t  CPROC sack_vfs_fs_find_get_wtime( struct sack_vfs_fs_find_info *info ) { return (size_t)0; }
LOGICAL CPROC sack_vfs_fs_rename( uintptr_t psvInstance, const char *original, const char *newname ) {
	struct sack_vfs_fs_volume *vol = (struct sack_vfs_fs_volume *)psvInstance;
	// fail if the names are the same.
	if( strcmp( original, newname ) == 0 )
		return FALSE;
	if( vol ) {
		struct directory_entry entkey;
		struct directory_entry entry;
		FPI entFPI;
		while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
		if( ( _fs_ScanDirectory( vol, original, &entFPI, &entry, &entkey, 0 ) ) ) {
			struct directory_entry new_entkey;
			struct directory_entry new_entry;
			if( (_fs_ScanDirectory( vol, newname, &entFPI, &new_entry, &new_entkey, 0 )) ) {
				vol->lock = 0;
				sack_vfs_fs_unlink_file( vol, newname );
				while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
			}
			entry.name_offset = _fs_SaveFileName( vol, newname ) ^ entkey.name_offset;
			sack_fseek( vol->file, (size_t)entFPI, SEEK_SET );
			sack_fwrite( &entry, 1, sizeof( entry ), vol->file );
			vol->lock = 0;
			return TRUE;
		}
		vol->lock = 0;
	}
	return FALSE;
}
#ifndef USE_STDIO
static struct file_system_interface sack_vfs_fs_fsi = {
                                                     (void*(CPROC*)(uintptr_t,const char *, const char*))sack_vfs_fs_open
                                                   , (int(CPROC*)(void*))sack_vfs_fs_close
                                                   , (size_t(CPROC*)(void*,void*,size_t))sack_vfs_fs_read
                                                   , (size_t(CPROC*)(void*,const void*,size_t))sack_vfs_fs_write
                                                   , (size_t(CPROC*)(void*,size_t,int))sack_vfs_fs_seek
                                                   , (void(CPROC*)(void*))sack_vfs_fs_truncate
                                                   , (int(CPROC*)(uintptr_t,const char*))sack_vfs_fs_unlink_file
                                                   , (size_t(CPROC*)(void*))sack_vfs_fs_size
                                                   , (size_t(CPROC*)(void*))sack_vfs_fs_tell
                                                   , (int(CPROC*)(void*))sack_vfs_fs_flush
                                                   , (int(CPROC*)(uintptr_t,const char*))sack_vfs_fs_exists
                                                   , sack_vfs_fs_need_copy_write
                                                   , (struct find_cursor*(CPROC*)(uintptr_t,const char *,const char *))             sack_vfs_fs_find_create_cursor
                                                   , (int(CPROC*)(struct find_cursor*))             sack_vfs_fs_find_first
                                                   , (int(CPROC*)(struct find_cursor*))             sack_vfs_fs_find_close
                                                   , (int(CPROC*)(struct find_cursor*))             sack_vfs_fs_find_next
                                                   , (char*(CPROC*)(struct find_cursor*))           sack_vfs_fs_find_get_name
                                                   , (size_t(CPROC*)(struct find_cursor*))          sack_vfs_fs_find_get_size
                                                   , (LOGICAL(CPROC*)(struct find_cursor*))         sack_vfs_fs_find_is_directory
                                                   , sack_vfs_fs_is_directory
                                                   , sack_vfs_fs_rename
	, (uintptr_t( CPROC* )(uintptr_t, uintptr_t, va_list))NULL
	, (uintptr_t( CPROC* )(uintptr_t, uintptr_t, va_list))NULL
	, (uint64_t( CPROC* )(struct find_cursor* cursor))sack_vfs_fs_find_get_ctime
	, (uint64_t( CPROC* )(struct find_cursor* cursor))sack_vfs_fs_find_get_wtime
};
PRIORITY_PRELOAD( Sack_VFS_FS_Register, CONFIG_SCRIPT_PRELOAD_PRIORITY - 2 )
{
#undef DEFAULT_VFS_NAME
#ifdef ALT_VFS_NAME
#   define DEFAULT_VFS_NAME SACK_VFS_FILESYSTEM_NAME ".runner"
#else
#   define DEFAULT_VFS_NAME SACK_VFS_FILESYSTEM_NAME "-fs"
#endif
	sack_register_filesystem_interface( DEFAULT_VFS_NAME, &sack_vfs_fs_fsi );
}
PRIORITY_PRELOAD( Sack_VFS_FS_RegisterDefaultFilesystem, SQL_PRELOAD_PRIORITY + 1 ) {
	if( SACK_GetProfileInt( GetProgramName(), "SACK/VFS/Mount FS VFS", 0 ) ) {
		struct sack_vfs_fs_volume *vol;
		TEXTCHAR volfile[256];
		TEXTSTR tmp;
		SACK_GetProfileString( GetProgramName(), "SACK/VFS/FS File", "*/../assets.sfs", volfile, 256 );
		tmp = ExpandPath( volfile );
		vol = sack_vfs_fs_load_volume( tmp );
		Deallocate( TEXTSTR, tmp );
		sack_mount_filesystem( "sack_shmem-fs", sack_get_filesystem_interface( DEFAULT_VFS_NAME )
		                     , 900, (uintptr_t)vol, TRUE );
	}
}
#endif
#ifdef __cplusplus
}
#endif
#ifdef USE_STDIO
#  undef sack_fopen
#  undef sack_fseek
#  undef sack_fclose
#  undef sack_fread
#  undef sack_fwrite
#  undef sack_ftell
#endif
SACK_VFS_NAMESPACE_END
#undef l
#undef FILE_BASED_VFS
#ifdef _MSC_VER
// integer partial expresions summed into 64 bit.
#pragma warning( default: 26451 )
#endif
#if !defined( SACK_AMALGAMATE ) || defined( __cplusplus )
/*
	FILE Data has extra fields stored with the data.
	   File Data - Directory entry filesize
	   references - a reference to a blockchain that contains the references to this object.
	        In the reference data block is FPI which is the directory entry ( converted directories? )
	   Sealant - length stored in NAME_OFFSET field of directory entry
	   patches - a sealed object has the ability to be modified with other signed and sealed patches.
			 A reference to the patch FileData is stored for each patch object.
			 (The patch object has a unique object identifier?  Or does it only exist for this object?)
*/
/*
 BLOCKINDEX BAT[BLOCKS_PER_BAT] // link of next blocks; 0 if free, FFFFFFFF if end of file block, FFFFFFFE end of BAT
 // (1+BLOCKS_PER_BAT) * BLOCK_SIZE total...
 BAT[0] = first directory cluster; array of struct directory_entry
 BAT[1] = name space; directory offsets land in a block referenced by this chain
 */
#define SACK_VFS_SOURCE
#define SACK_VFS_OS_SOURCE
#define SKIP_LIGHT_ENCRYPTION(n)
#define VFS_OS_PARANOID_TRUNCATE
// this is a badly named debug symbol;
// it is the LAST debugging of delete logging/checking...
//#define DEBUG_DELETE_LAST
//#define USE_STDIO
#if 1
 // tolower on linux
#ifndef USE_STDIO
#endif
/* JSOX Parser
   Parses JSOX (github.com/d3x0r/jsox)
   This function is meant for a simple utility to just take a
   known completed packet, and get the values from it. There may
   be mulitple top level values, although the JSON standard will
   only supply a single object or array as the first value.
   jsox_parse_message( "utf8 data", sizeof( "utf8 data" )-1,
   &amp;pdlMessage );
   \Example :
   <code>
   // call to parse a message... and iterate through each value
   {
     PDATALIST pdlMessage;
     LOGICAL gotMessage;
     if( jsox_parse_message( "utf8 data", sizeof( "utf8 data" )-1, &amp;pdlMessage ) )
     {
       int index;
       struct jsox_value_container *value;
       DATALIST_FORALL( pdlMessage, index, struct jsox_value_container *. value )
       {
          // for each value in the result.... the first layer will
          // always be just one element, either a simple type, or a VALUE_ARRAY or VALUE_OBJECT, which
		  // then for each value-\>contains (as a datalist like above),
          // process each of those values.
       }
       jsox_dispose_mesage( &amp;pdlMessage );
     }
   }
   </code>
   This is a streaming setup, where a data block can be added, and
   the stream of objects can be returned from it....
   \Example 2:
   <code lang="c++">
   // allocate a parser to keep track of the parsing state... struct jsox_parse_state *parser = jsox_begin_parse();
   // at some point later, add some data to it... jsox_parse_add_data( parser, "utf8-data", sizeof( "utf8-data" ) - 1 );
   // and then get any objects that have been parsed from the stream so far...
   {
     PDATALIST pdlMessage;
     pdlMessage = jsox_parse_get_data( parser );
     if( pdlMessage )
     {
       int index;
       struct jsox_value_container *value;
       DATALIST_FORALL( pdlMessage, index, struct jsox_value_container *. value )
       {
         // for each value in the result.... the first layer will
         // always be just
         // one element, either a simple type, or a VALUE_ARRAY or VALUE_OBJECT, which
         // then for each value-\>contains (as a datalist like above), process each of those values.
       }
       jsox_dispose_mesage( &amp;pdlMessage );
       jsox_parse_add_data( parser, NULL, 0 );
       // trigger parsing next message.
     }
   }
   </code>                                                                                                                                                                                                                    */
#ifndef JSOX_PARSER_HEADER_INCLUDED
#define JSOX_PARSER_HEADER_INCLUDED
// include types to get namespace, and, well PDATALIST types
#ifdef __cplusplus
namespace sack { namespace network {
	/* <combinewith jsox_parser.h>
	   \ \                         */
	namespace jsox {
#endif
#ifdef JSOX_PARSER_SOURCE
#  define JSOX_PARSER_PROC(type,name) EXPORT_METHOD type name
#else
#  define JSOX_PARSER_PROC(type,name) IMPORT_METHOD type name
#endif
enum jsox_value_types {
	JSOX_VALUE_UNDEFINED = -1
	, JSOX_VALUE_UNSET = 0
 //= 1 no data
	, JSOX_VALUE_NULL
 //= 2 no data
	, JSOX_VALUE_TRUE
 //= 3 no data
	, JSOX_VALUE_FALSE
 //= 4 string
	, JSOX_VALUE_STRING
 //= 5 string + result_d | result_n
	, JSOX_VALUE_NUMBER
 //= 6 contains
	, JSOX_VALUE_OBJECT
 //= 7 contains
	, JSOX_VALUE_ARRAY
	// up to here is supported in JSON
 //= 8 no data
	, JSOX_VALUE_NEG_NAN
 //= 9 no data
	, JSOX_VALUE_NAN
 //= 10 no data
	, JSOX_VALUE_NEG_INFINITY
 //= 11 no data
	, JSOX_VALUE_INFINITY
  // = 12 comes in as a number, string is data.
	, JSOX_VALUE_DATE
 // = 13 string data, needs bigint library to process...
	, JSOX_VALUE_BIGINT
 // = 14 no data; used in [,,,] as place holder of empty
	, JSOX_VALUE_EMPTY
  // = 15 string is base64 encoding of bytes.
	, JSOX_VALUE_TYPED_ARRAY
  // = 14 string is base64 encoding of bytes.
	, JSOX_VALUE_TYPED_ARRAY_MAX = JSOX_VALUE_TYPED_ARRAY +12
};
struct jsox_value_container {
  // name of this value (if it's contained in an object)
	char * name;
	size_t nameLen;
 // value from above indiciating the type of this value
	enum jsox_value_types value_type;
   // the string value of this value (strings and number types only)
	char *string;
	size_t stringLen;
  // boolean whether to use result_n or result_d
	int float_result;
	union {
		double result_d;
		int64_t result_n;
		//struct json_value_container *nextToken;
	};
  // list of struct json_value_container that this contains.
	PDATALIST contains;
  // acutal source datalist(?)
	PDATALIST *_contains;
  // if VALUE_OBJECT or VALUE_TYPED_ARRAY; this may be non NULL indicating what the class name is.
	char *className;
	size_t classNameLen;
};
// allocates a JSOX parsing context and is prepared to begin parsing data.
JSOX_PARSER_PROC( struct jsox_parse_state *, jsox_begin_parse )(void);
// clear state; after an error state, this can allow reusing a state.
JSOX_PARSER_PROC( void, jsox_parse_clear_state )( struct jsox_parse_state *state );
// get actual allocated root for a value... allows holding that.
JSOX_PARSER_PROC( const char *, jsox_get_parse_buffer )(struct jsox_parse_state *pState, const char *buf);
// destroy current parse state.
JSOX_PARSER_PROC( void, jsox_parse_dispose_state )(struct jsox_parse_state **ppState);
// return >0 when a completed value/object is available.
// after returning >0, call json_parse_get_data.  It is possible that there is
// still unconsumed data that can begin a new object.  Call this with NULL, 0 for data
// to consume this internal data.  if this returns 0, then ther is no further object
// to retrieve.  If this return -1 there was an error, and use jsox_parse_get_error() to
// retrieve the error text.
JSOX_PARSER_PROC( int, jsox_parse_add_data )(struct jsox_parse_state *context
	, const char * msg
	, size_t msglen
	);
JSOX_PARSER_PROC( PTEXT, jsox_parse_get_error )(struct jsox_parse_state *state);
JSOX_PARSER_PROC( PDATALIST, jsox_parse_get_data )(struct jsox_parse_state *context);
// single all-in-one parsing of an input buffer.
JSOX_PARSER_PROC( LOGICAL, jsox_parse_message )(const char * msg
	, size_t msglen
	, PDATALIST *msg_data_out
	);
// release all resources of a message from jsox_parse_message or jsox_parse_get_data
JSOX_PARSER_PROC( void, jsox_dispose_message )(PDATALIST *msg_data);
JSOX_PARSER_PROC( struct jsox_parse_state *, jsox_get_messge_parser )(void);
JSOX_PARSER_PROC( char *, jsox_escape_string_length )(const char *string, size_t len, size_t *outlen);
JSOX_PARSER_PROC( char *, jsox_escape_string )(const char *string);
/*
	jsox_get_pared_value()
	takes a parsed message data list as a parameer, and a path.
	A message may have been parsed into multiple parts.  This
	early version will return just the first value in the datalist.
	If there is an optional `path` specified, then that is used to
	step through the JSOX parsed structure to get deeper values.
	Path is specified as a list of fieldnames and array index numbers.
	optional separator characters may be used between members '.', ' ', '/' and '\'.
	Separator characters may be repeated or mixed with other seaprators and are all
	considered a single separation.
	optional bracket characters around an array index may be used     [0]    is often as good as 0.
	Some example paths
		messages[0]from
		messages.0.from
		messages [0] from
		messages [0] lines[0]
	{ messages : [ // array of messages
	    { from : "someone", lines: [ "lines","of","message"] }
	  ]
	}
	jsox_get_parsed_value() returns a value from a PDATALIST
	jsox_get_parsed_object_value() and jsox_get_parsed_array_value() :  returns a value from a value member.
*/
JSOX_PARSER_PROC( struct jsox_value_container *, jsox_get_parsed_value )(PDATALIST pdlMessage, const char *path
	, void( *callback )(uintptr_t psv, struct jsox_value_container *val), uintptr_t psv
	);
JSOX_PARSER_PROC( struct jsox_value_container *, jsox_get_parsed_object_value )(struct jsox_value_container *pdlMessage, const char *path
	, void( *callback )(uintptr_t psv, struct jsox_value_container *val), uintptr_t psv
	);
JSOX_PARSER_PROC( struct jsox_value_container *, jsox_get_parsed_array_value )(struct jsox_value_container * pdlMessage, const char *path
	, void( *callback )(uintptr_t psv, struct jsox_value_container *val), uintptr_t psv
	);
#ifdef __cplusplus
//SACK_NAMESPACE_END
} } }
using namespace sack::network::jsox;
#endif
#endif
#else
 // tolower on linux
//#include <filesys.h>
//#include <procreg.h>
//#include <salty_generator.h>
//#include <sack_vfs.h>
//#include <sqlgetoption.h>
#endif
#ifdef _MSC_VER
// integer partial expresions summed into 64 bit.
#  pragma warning( disable: 26451 )
#endif
#ifdef USE_STDIO
#define sack_fopen(a,b,c)     fopen(b,c)
#define sack_fseek(a,b,c)     fseek(a,(long)b,c)
#define sack_fclose(a)        fclose(a)
#define sack_fread(a,b,c,d)   fread(a,b,c,d)
#define sack_fwrite(a,b,c,d)  fwrite(a,b,c,d)
#define sack_ftell(a)         ftell(a)
#undef StrDup
#define StrDup(a)             strdup(a)
#define free(a)               Deallocate( POINTER, a )
#ifdef __cplusplus
namespace sack {
	namespace filesys {
#endif
		// filesyslib/pathops.c
		extern LOGICAL  CPROC  IsPath( CTEXTSTR path );
		extern  int CPROC  MakePath( CTEXTSTR path );
		extern CTEXTSTR CPROC pathrchr( CTEXTSTR path );
		extern CTEXTSTR CPROC pathchr( CTEXTSTR path );
#ifdef __cplusplus
	}
}
using namespace sack::filesys;
#endif
#else
#define free(a)               Deallocate( POINTER, a )
#endif
SACK_VFS_NAMESPACE
// have to enable TRACE_LOG for most of the symbols to actually log
//#define DEBUG_TRACE_LOG
//#define DEBUG_ROLLBACK_JOURNAL
//#define DEBUG_FILE_OPS
// this is large binary blocks.
//#define DEBUG_DISK_IO
//#define DEBUG_DISK_DATA
//#define DEBUG_DIRECTORIES
//#define DEBUG_BLOCK_INIT
//#define DEBUG_TIMELINE_AVL
//#define DEBUG_TIMELINE_DIR_TRACKING
//#define DEBUG_FILE_SCAN
//#define DEBUG_FILE_OPEN
//#define DEBUG_VALIDATE_TREE
//#define DEBUG_BLOCK_COMPUTE
//#define DEBUG_SECTOR_DIRT
//#define DEBUG_CACHE_FAULTS
//#define DEBUG_CACHE_FLUSH
//#define DEBUG_SET_SECTOR_SIZE
//#define DEBUG_FILE_TRUNCATE
#define FILE_BASED_VFS
#define VIRTUAL_OBJECT_STORE
#ifndef _MSC_VER
#endif
/**************
  VFS_VERSION
     used to track migration of keys and keying methods.
  0x100 = version 1; SHORTKEY_LENGTH = 16
 **************/
#define VFS_VERSION     0x100
// 12 bits = 1 << 12 = 4096
#define BLOCK_SIZE_BITS 12
// BLOCKINDEX is either 4 or 8 bytes... sizeof( size_t )...
// all constants though should compile out to a single value... and just for grins went to 16 bit size_t and 0 shift... or 1 byte
#define BLOCK_BAT_SHIFT (BLOCK_SIZE_BITS-(sizeof(BLOCKINDEX)==16?4:sizeof(BLOCKINDEX)==8?3:sizeof(BLOCKINDEX)==4?2:sizeof(BLOCKINDEX)==2?1:0) )
#define BLOCK_INDEX_SHIFT ((sizeof(BLOCKINDEX)==16?4:sizeof(BLOCKINDEX)==8?3:sizeof(BLOCKINDEX)==4?2:sizeof(BLOCKINDEX)==2?1:0) )
#define BLOCK_BYTE_SHIFT (BLOCK_SIZE_BITS)
#define BLOCK_SIZE (1<<BLOCK_SIZE_BITS)
#define BLOCK_SMALL_SIZE     256
#define DIR_BLOCK_SIZE_BITS   12
#define DIR_BLOCK_SIZE      (1<<DIR_BLOCK_SIZE_BITS)
#define BAT_BLOCK_SIZE      4096
#define NAME_BLOCK_SIZE     4096
#define KEY_SIZE            1024
#define TIME_BLOCK_SIZE     4096
#define ROLLBACK_BLOCK_SIZE 4096
#define FILE_NAME_MAXLEN    4096
#define BLOCK_MASK (BLOCK_SIZE-1)
#ifdef VIRTUAL_OBJECT_STORE
// if the block index & BAT_BLOCK_MASK, is a data block
// all BATs are 4096
#  undef BLOCKS_PER_BAT
#  undef BLOCK_SECTOR_MASK
#  define BLOCKS_PER_BAT ((BAT_BLOCK_SIZE >> BLOCK_INDEX_SHIFT)-1)
#  define BLOCK_SECTOR_MASK BLOCKS_PER_BAT
#else
#  undef BLOCKS_PER_BAT
#  undef BLOCK_SECTOR_MASK
#  define BLOCKS_PER_BAT ((BAT_BLOCK_SIZE >> BLOCK_INDEX_SHIFT))
#  define BLOCK_SECTOR_MASK (BLOCKS_PER_BAT-1)
#endif
#define BAT_BLOCK_MASK ( ( BAT_BLOCK_SIZE >> BLOCK_INDEX_SHIFT ) - 1)
#define BLOCKS_PER_SECTOR (1+BLOCKS_PER_BAT)
// per-sector perumation; needs to be a power of 2 (in bytes)
#define SHORTKEY_LENGTH 16
#ifndef VFS_DISK_DATATYPE
#  define VFS_DISK_DATATYPE size_t
#endif
 // BLOCK_SIZE blocks...
typedef VFS_DISK_DATATYPE BLOCKINDEX;
 // file position type
typedef VFS_DISK_DATATYPE FPI;
/* BEFORE DEF */
#undef BC
#ifdef VIRTUAL_OBJECT_STORE
/* THIS DEFINES SACK_VFS_OS_VOLUME */
#  define BC(n) BLOCK_CACHE_VOS_##n
#    ifdef sack_vfs_volume
#      undef block_cache_entries
#      undef directory_entry
#      undef sack_vfs_disk
#      undef sack_vfs_diskSection
#      undef directory_hash_lookup_block
#      undef sack_vfs_volume
#      undef sack_vfs_file
#    endif
#    define block_cache_entries block_cache_entries_os
#    define directory_entry directory_entry_os
#    define sack_vfs_disk sack_vfs_disk_os
#    define sack_vfs_diskSection sack_vfs_diskSection_os
#    define directory_hash_lookup_block directory_hash_lookup_block_os
#    define sack_vfs_volume sack_vfs_os_volume
#    define sack_vfs_file sack_vfs_os_file
#   ifdef __cplusplus
namespace objStore {
#   endif
#elif defined FILE_BASED_VFS
#  define BC(n) BLOCK_CACHE_FS_##n
#    ifdef block_cache_entries
#      undef block_cache_entries
#      undef directory_entry
#      undef sack_vfs_disk
#      undef sack_vfs_diskSection
#      undef directory_hash_lookup_block
#      undef sack_vfs_volume
#      undef sack_vfs_file
#    endif
#    define block_cache_entries block_cache_entries_fs
#    define directory_entry directory_entry_fs
#    define sack_vfs_disk sack_vfs_disk_fs
#    define sack_vfs_diskSection sack_vfs_diskSection_fs
#    define directory_hash_lookup_block directory_hash_lookup_block_fs
/* THIS DEFINES SACK_VS_VOLUME */
#    define sack_vfs_volume sack_vfs_fs_volume
#    define sack_vfs_file sack_vfs_fs_file
#   ifdef __cplusplus
namespace fs {
#   endif
#else
#  define BC(n) BLOCK_CACHE_##n
#endif
/* AFTER DEF */
enum block_cache_entries
{
	BC( ZERO )
	, BC( DIRECTORY ) = 0
#ifdef VIRTUAL_OBJECT_STORE
	, BC( DIRECTORY_LAST ) = BC( DIRECTORY ) + 64
#endif
	, BC( NAMES )
	, BC( NAMES_LAST ) = BC( NAMES ) + 16
	, BC( BAT )
#ifdef VIRTUAL_OBJECT_STORE
	// keep a few tables for cache (file system too?)
	, BC( BAT_LAST ) = BC( BAT ) + 16
#endif
	, BC(DATAKEY)
	, BC(FILE)
	, BC(FILE_LAST) = BC(FILE) + 32
#ifdef VIRTUAL_OBJECT_STORE
	, BC( TIMELINE )
	, BC( TIMELINE_LAST ) = BC( TIMELINE ) + 48
#endif
#if defined( VIRTUAL_OBJECT_STORE )
	// really shouldn't need more than one of these...
	// record
	// 1 - header
	// 0/1 - entry (might be with header)
	// 1 - small/big block journal entry
	// replay
	// 1 - header
	// 0/1 - entry (might be with header)
	// 1 - small/big block journal entry
	// 1 - target disk sector
	, BC( ROLLBACK )
	, BC( ROLLBACK_LAST ) = BC( ROLLBACK ) + 6
#endif
#if defined( VIRTUAL_OBJECT_STORE ) && defined( DEBUG_VALIDATE_TREE )
	// debug timeline, keep a mirror for comparisons, when links were lost, etc...
	// can be factored out at some point.
	, BC( TIMELINE_RO )
	, BC( TIMELINE_RO_LAST ) = BC( TIMELINE_RO ) + 48
#endif
	, BC(COUNT)
};
// could effecitvely be fewer than this
// 82 dirents * 512 byte names = 40000
#define DIRENT_NAME_OFFSET_OFFSET             0x0001FFFF
// (sealant length / 4)  (mulitply by 4 to get real length)
#define DIRENT_NAME_OFFSET_FLAG_SEALANT       0x003E0000
#define DIRENT_NAME_OFFSET_FLAG_SEALANT_SHIFT 17
#define DIRENT_NAME_OFFSET_FLAG_OWNED         0x00400000
#define DIRENT_NAME_OFFSET_FLAG_READ_KEYED    0x00800000
// unused flag; previous indicated versioning.
#define DIRENT_NAME_OFFSET_UNUSED_0         0x01000000
#define DIRENT_NAME_OFFSET_VERSION_SHIFT      25
#define DIRENT_NAME_OFFSET_VERSIONS           0x1E000000
#define DIRENT_NAME_OFFSET_UNUSED             0xFE000000
#  ifdef _MSC_VER
#    pragma pack (push, 1)
#  endif
PREFIX_PACKED struct directory_entry
{
  // name offset from beginning of disk
	FPI name_offset;
  // first block of data of the file
	BLOCKINDEX first_block;
  // how big the file is
	VFS_DISK_DATATYPE filesize;
#ifdef VIRTUAL_OBJECT_STORE
  // when the file was created/last written
	uint64_t timelineEntry;
#endif
} PACKED;
#  ifdef _MSC_VER
#    pragma pack (pop)
#  endif
#undef VFS_DIRECTORY_ENTRIES
#ifdef VIRTUAL_OBJECT_STORE
// subtract name has index
// subtrace name index
#  define VFS_DIRECTORY_ENTRIES ( ( BLOCK_SIZE - ( 2*sizeof(BLOCKINDEX) + 256*sizeof(BLOCKINDEX)) ) /sizeof( struct directory_entry) )
#  define VFS_PATCH_ENTRIES ( ( BLOCK_SIZE ) /sizeof( struct directory_entry) )
#else
#  define VFS_DIRECTORY_ENTRIES ( ( BLOCK_SIZE ) /sizeof( struct directory_entry) )
#  define VFS_PATCH_ENTRIES ( ( BLOCK_SIZE ) /sizeof( struct directory_entry) )
#endif
/*
struct sack_vfs_diskSection
{
	// BAT is at 0 of every BLOCK_SIZE blocks (4097 total)
	// &BAT[0] == itself....
	// BAT[0] == first directory entry (actually next entry; first is always here)
	// BAT[1] == first name entry (actually next name block; first is known as here)
	// bat[BLOCK_SIZE] == NEXT_BAT[0]; NEXT_BAT = BAT + BLOCK_SIZE + 1024*BLOCK_SIZE;
	// bat[8192] == ... ( 0 + ( BLOCK_SIZE + BLOCKS_PER_BAT*BLOCK_SIZE ) * N >> 12 )
	BLOCKINDEX BAT[BLOCKS_PER_BAT];
	//struct directory_entry directory[BLOCK_SIZE/sizeof( struct directory_entry)]; // 256
	//char  names[BLOCK_SIZE/sizeof(char)];
	uint8_t  block_data[BLOCKS_PER_BAT][BLOCK_SIZE];
};
struct sack_vfs_disk {
	struct sack_vfs_diskSection firstBlock;
	struct sack_vfs_diskSection blocks[];
};
*/
#undef SMUDGECACHE
#undef CLEANCACHE
#ifdef DEBUG_SECTOR_DIRT
#define SMUDGECACHE(vol,n) {	 lprintf( "set dirty on %d %d %d", n, vol->segment[n], vol->bufferFPI[n]);	 vfs_os_smudge_cache(vol,n);   }
#define CLEANCACHE(vol,n) {	 lprintf( "reset dirty on %d", n);	 RESETFLAG( vol->dirty, n ); }
#else
#define SMUDGECACHE(vol,n) {    vfs_os_smudge_cache(vol,n);   }
#define CLEANCACHE(vol,n) {	 RESETFLAG( vol->dirty, n ); }
#endif
#ifndef ROLLBACK_JOURNAL_DEFINED
#define ROLLBACK_JOURNAL_DEFINED
static int const seglock_mask_size = 4;
struct sack_vfs_os_BAT_info {
	FPI sectorStart;
	FPI sectorEnd;
	BLOCKINDEX blockStart;
	int size;
};
struct vfs_os_rollback_journal {
	struct sack_vfs_os_file* rollback_file;
	struct sack_vfs_os_file* rollback_journal_file;
	struct sack_vfs_os_file* rollback_small_journal_file;
	PDATALIST pdlPendingRecord;
	BLOCKINDEX nextBlock;
	BLOCKINDEX nextSmallBlock;
	PDATALIST pdlJournaled;
 // sectors that are in rollback already
	BLOCKINDEX *pJournaled;
 // how long pJournaled is used
	int journalLength;
 // max length of pJournaled
	int journalAvail;
};
#ifdef small
#  undef small
#endif
#  ifdef _MSC_VER
#    pragma pack (push, 1)
#  endif
PREFIX_PACKED struct vfs_os_rollback_entry {
	BLOCKINDEX fileBlock;
	struct {
		uint64_t small : 1;
  // block was full of 0's
		uint64_t zero : 1;
	} flags;
	// block size is retrievable when the block is reloadeded to write
// PACKED entries[1];
};
PREFIX_PACKED struct vfs_os_rollback_header {
	struct {
		uint64_t dirty : 1;
		uint64_t processing : 1;
	} flags;
  // where the blocks are tracked.
	BLOCKINDEX journal;
 // where small blocks are tracked
	BLOCKINDEX small_journal;
	BLOCKINDEX unused_rollbackLength;
	BLOCKINDEX nextBlock;
	BLOCKINDEX nextSmallBlock;
	BLOCKINDEX nextEntry;
  // align entries on 4096 boundaries
	uint64_t   Filler1;
	// where this is tracked.
	struct vfs_os_rollback_entry  entries[1];
}PACKED ;
#  ifdef _MSC_VER
#    pragma pack (pop)
#  endif
#endif
struct sack_vfs_volume {
	const char * volname;
#ifdef FILE_BASED_VFS
	FILE *file;
	struct file_system_mounted_interface *mount;
#else
	struct sack_vfs_disk *disk;
 // disk might be offset from diskReal because it's a .exe attached.
	struct sack_vfs_disk *diskReal;
#endif
	//uint32_t dirents;  // constant 0
	//uint32_t nameents; // constant 1
	uintptr_t dwSize;
  // used for directory signatures
	const char * datakey;
	const char * userkey;
	const char * devkey;
	enum block_cache_entries curseg;
// cached segment with usekey[n]
	BLOCKINDEX _segment[BC(COUNT)];
// associated with usekey[n]
	BLOCKINDEX segment[BC(COUNT)];
#ifdef VIRTUAL_OBJECT_STORE
	struct vfs_volume_flags {
		BIT_FIELD skipRollbackProcessing : 1;
 // stop any disk activity; test journal recoverability.
		BIT_FIELD halted : 1;
 // stop any disk activity; test journal recoverability.
		BIT_FIELD versioned : 1;
	}flags;
	struct vfs_os_rollback_journal journal;
	BLOCKINDEX lastBlock;
	PDATALIST pdl_BAT_information;
	PLIST pending_rollback;
	//PDATASTACK pdsCTimeStack;// = CreateDataStack( sizeof( struct memoryTimelineNode ) );
	//PDATASTACK pdsWTimeStack;// = CreateDataStack( sizeof( struct memoryTimelineNode ) );
 // timeline root
	struct storageTimeline *timeline;
	enum block_cache_entries timelineCache;
 // timeline root key
	struct storageTimeline *timelineKey;
	struct sack_vfs_os_file *timeline_file;
	struct sack_vfs_os_file* timeline_index_file;
	//struct storageTimelineCursor *timeline_cache;
  // segment is locked into cache.
	MASKSET_( seglock, BC( COUNT ), 4 );
	unsigned int sector_size[BC( COUNT )];
#endif
	uint8_t fileCacheAge[BC(FILE_LAST) - BC(FILE)];
#ifdef VIRTUAL_OBJECT_STORE
	uint8_t dirHashCacheAge[BC(DIRECTORY_LAST) - BC(DIRECTORY)];
	uint8_t batHashCacheAge[BC(BAT_LAST) - BC(BAT)];
	uint8_t timelineCacheAge[BC( TIMELINE_LAST ) - BC( TIMELINE )];
	uint8_t rollbackCacheAge[BC( ROLLBACK_LAST ) - BC( ROLLBACK )];
#endif
	uint8_t nameCacheAge[BC(NAMES_LAST) - BC(NAMES)];
	struct random_context *entropy;
  // root of all cached key buffers
	uint8_t* key;
#ifdef FILE_BASED_VFS
  // root of all cached key buffers
	uint8_t* oldkey;
#endif
#ifndef VIRTUAL_OBJECT_STORE
  // allow byte encrypting... key based on sector volume file index
	uint8_t* segkey;
 // composite key
	uint8_t* usekey[BC( COUNT )];
#endif
  // signature of executable attached as header
	uint8_t* sigkey;
  // signature of executable attached as header
	uint8_t* sigsalt;
	size_t sigkeyLength;
#  ifdef FILE_BASED_VFS
  // root buffer space of all cache blocks
	uint8_t* key_buffer;
 // data cache blocks
	uint8_t* usekey_buffer[BC(COUNT)];
 // duplicate copy of original sector data
	uint8_t* usekey_buffer_clean[BC(COUNT)];
	PTHREAD flusher;
	volatile LOGICAL flushing;
	PVARTEXT pvtDeleteBuffer;
#ifdef DEBUG_CACHE_FAULTS
	int cacheRequests[10];
	int cacheFaults[10];
#endif
	FLAGSET( dirty, BC(COUNT) );
	FLAGSET( _dirty, BC( COUNT ) );
	FPI bufferFPI[BC(COUNT)];
#  endif
	BLOCKINDEX lastBatBlock;
	PDATALIST pdlFreeBlocks;
#ifdef VIRTUAL_OBJECT_STORE
	BLOCKINDEX lastBatSmallBlock;
	PDATALIST pdlFreeSmallBlocks;
#endif
 // when reopened file structures need to be updated also...
	PLIST files;
	LOGICAL read_only;
	LOGICAL external_memory;
	LOGICAL closed;
	volatile uint32_t lock;
#ifdef VFS_IMPLEMENT_FILE_LOCKING
	THREAD_ID locked_thread;
#endif
	uint8_t tmpSalt[16];
	uintptr_t clusterKeyVersion;
};
#if !defined( VIRTUAL_OBJECT_STORE )
struct sack_vfs_file
{
 // which volume this is in
	struct sack_vfs_volume *vol;
	struct directory_entry dirent_key;
	FPI fpi;
	BLOCKINDEX _first_block;
 // this should be in-sync with current FPI always; plz
	BLOCKINDEX block;
  // someone already deleted this...
	LOGICAL delete_on_close;
	BLOCKINDEX *blockChain;
	BLOCKINDEX blockChainAvail;
	BLOCKINDEX blockChainLength;
#  ifdef FILE_BASED_VFS
  // where to write the directory entry update to
	FPI entry_fpi;
#    ifdef VIRTUAL_OBJECT_STORE
	enum block_cache_entries cache;
	struct memoryTimelineNode *timeline;
	uint8_t *seal;
	uint8_t *sealant;
	uint8_t *readKey;
	uint16_t readKeyLen;
	uint8_t sealantLen;
 // boolean, on read, validates seal.  Defaults to FALSE.
	uint8_t sealed;
	char *filename;
#    endif
  // has file size within
	struct directory_entry _entry;
  // has file size within
	struct directory_entry *entry;
#  else
  // has file size within
	struct directory_entry *entry;
#  endif
};
#endif
#  undef TSEEK
#  undef BTSEEK
#  ifdef VIRTUAL_OBJECT_STORE
#    define TSEEK(type,v,o,s,c) ((type)vfs_os_SEEK(v,o,s,&c))
#    define BTSEEK(type,v,o,s,c) ((type)vfs_os_BSEEK(v,o,s,&c))
#  elif defined FILE_BASED_VFS
#    define TSEEK(type,v,o,c) ((type)vfs_fs_SEEK(v,o,&c))
#    define BTSEEK(type,v,o,c) ((type)vfs_fs_BSEEK(v,o,&c))
#  else
#    define TSEEK(type,v,o,c) ((type)vfs_SEEK(v,o,&c))
#    define BTSEEK(type,v,o,c) ((type)vfs_BSEEK(v,o,&c))
#  endif
#if defined( __GNUC__ ) && !defined( _WIN32 )
#define HIDDEN __attribute__ ((visibility ("hidden")))
#else
#define HIDDEN
#endif
#if !defined( VIRTUAL_OBJECT_STORE ) && !defined( FILE_BASED_VFS )
  uintptr_t vfs_SEEK( struct sack_vfs_volume* vol, FPI offset, enum block_cache_entries* cache_index ) HIDDEN;
  uintptr_t vfs_BSEEK( struct sack_vfs_volume* vol, BLOCKINDEX block, enum block_cache_entries* cache_index ) HIDDEN;
#elif defined( VIRTUAL_OBJECT_STORE )
  uintptr_t vfs_os_SEEK( struct sack_vfs_os_volume* vol, FPI offset, int size, enum block_cache_entries* cache_index ) HIDDEN;
  uintptr_t vfs_os_BSEEK( struct sack_vfs_os_volume* vol, BLOCKINDEX block, int size, enum block_cache_entries* cache_index ) HIDDEN;
#elif defined( FILE_BASED_VFS )
  uintptr_t vfs_fs_SEEK( struct sack_vfs_fs_volume* vol, FPI offset, enum block_cache_entries* cache_index ) HIDDEN;
  uintptr_t vfs_fs_BSEEK( struct sack_vfs_fs_volume* vol, BLOCKINDEX block, enum block_cache_entries* cache_index ) HIDDEN;
#endif
#if defined( VIRTUAL_OBJECT_STORE ) || defined( FILE_BASED_VFS )
#   ifdef __cplusplus
}
using namespace sack::SACK_VFS;
#   endif
#  endif
#define vfs_SEEK vfs_os_SEEK
#define vfs_BSEEK vfs_os_BSEEK
#define MAX_FILENAME_LEN 256
struct memoryTimelineNode;
#ifdef __cplusplus
namespace objStore {
#endif
//#define PARANOID_INIT
#undef LoG
#undef LoG_
#ifdef DEBUG_TRACE_LOG
#define LoG( a,... ) lprintf( a,##__VA_ARGS__ )
#define LoG_( a,... ) _lprintf(DBG_RELAY)( a,##__VA_ARGS__ )
#else
#define LoG( a,... )
#define LoG_( a,... )
#endif
//#if !defined __GNUC__ and defined( __CPLUSPLUS )
#define sane_offsetof(type,member) ((size_t)&(((type*)0)->member))
//#endif
#define EOFBLOCK  (~(BLOCKINDEX)0)
#define EOBBLOCK  ((BLOCKINDEX)1)
#define EODMARK   (1)
#define DIR_ALLOCATING_MARK (~0)
//#define DIR_DELETED_MARK    (1)
//#define DIR_CREATED_MARK    (2)
#undef GFB_INIT_NONE
#undef GFB_INIT_DIRENT
#undef GFB_INIT_NAMES
enum getFreeBlockInit {
	GFB_INIT_NONE       ,
	GFB_INIT_DIRENT     ,
	GFB_INIT_NAMES      ,
	GFB_INIT_PATCHBLOCK ,
	GFB_INIT_TIMELINE   ,
	GFB_INIT_TIMELINE_MORE,
	GFB_INIT_ROLLBACK   ,
};
// End Of Text Block
#define UTF8_EOTB 0xFF
// End Of Text
#define UTF8_EOT 0xFE
#define FIRST_DIR_BLOCK      0
//#define FIRST_NAMES_BLOCK    1
#define FIRST_TIMELINE_BLOCK 2
#define FIRST_ROLLBACK_BLOCK 3
// use this byte in hash as parent directory (block & char)
// utf8 names never use 0xFF as a codeunit.
#define DIRNAME_CHAR_PARENT 0xFF
struct dirent_cache {
	BLOCKINDEX entry_fpi;
  // has file size within
	struct directory_entry entry;
  // has file size within
	struct directory_entry entry_key;
	struct dirent_cache *patches;
	int usedPatches;
	int availPatches;
} dirCache;
struct hashnode {
	char leadin[MAX_FILENAME_LEN];
	int leadinDepth;
	BLOCKINDEX this_dir_block;
	size_t thisent;
};
struct sack_vfs_os_find_info {
	char filename[FILE_NAME_MAXLEN];
	struct sack_vfs_os_volume *vol;
	CTEXTSTR base;
	size_t base_len;
	size_t filenamelen;
	size_t filesize;
	CTEXTSTR mask;
#ifdef VIRTUAL_OBJECT_STORE
	char leadin[MAX_FILENAME_LEN];
	int leadinDepth;
	PDATASTACK pds_directories;
	uint64_t ctime;
	uint64_t wtime;
	struct memoryTimelineNode *time;
#else
	BLOCKINDEX this_dir_block;
	size_t thisent;
#endif
};
static void sack_vfs_os_flush_block( struct sack_vfs_os_volume* vol, enum block_cache_entries entry );
static void vfs_os_smudge_cache( struct sack_vfs_os_volume* vol, enum block_cache_entries n );
static BLOCKINDEX _os_GetFreeBlock_( struct sack_vfs_os_volume *vol, enum block_cache_entries* cache, enum getFreeBlockInit init, int blocksize, LOGICAL flush_BAT_caches  DBG_PASS );
#define _os_GetFreeBlock(v,c,i,s) _os_GetFreeBlock_(v,c,i,s,FALSE DBG_SRC )
#define IS_OWNED(file)  ( (file->entry->name_offset) & DIRENT_NAME_OFFSET_FLAG_OWNED )
LOGICAL _os_ScanDirectory_( struct sack_vfs_os_volume *vol, const char * filename
	, BLOCKINDEX dirBlockSeg
	, BLOCKINDEX *nameBlockStart
	, struct sack_vfs_os_file *file
	, int path_match
	, char *leadin
	, int *leadinDepth
);
#define _os_ScanDirectory(v,f,db,nb,file,pm) ((l.leadinDepth = 0), _os_ScanDirectory_(v,f,db,nb,file,pm, l.leadin, &l.leadinDepth ))
// This getNextBlock is optional allocate new one; it uses _os_getFreeBlock_
static BLOCKINDEX vfs_os_GetNextBlock_v2( struct sack_vfs_os_volume* vol, BLOCKINDEX block, enum block_cache_entries* blockCache, enum getFreeBlockInit init, LOGICAL expand, int blockSize, int* realBlockSize, LOGICAL flush_BAT_caches );
static BLOCKINDEX vfs_os_GetNextBlock( struct sack_vfs_os_volume *vol, BLOCKINDEX block, enum block_cache_entries *cache, enum getFreeBlockInit init, LOGICAL expand, int blockSize, int *realBlockSize );
static LOGICAL _os_ExpandVolume( struct sack_vfs_os_volume *vol, BLOCKINDEX fromBlock, int size );
//static void reloadTimeEntry( struct memoryTimelineNode *time, struct sack_vfs_os_volume *vol, uint64_t timeEntry DBG_PASS );
#define vfs_os_BSEEK(v,b,s,c) vfs_os_BSEEK_(v,b,s,c DBG_SRC )
uintptr_t vfs_os_BSEEK_( struct sack_vfs_os_volume *vol, BLOCKINDEX block, int blockSize, enum block_cache_entries *cache_index DBG_PASS );
uint8_t* vfs_os_DSEEK_( struct sack_vfs_os_volume* vol, FPI dataFPI, int blockSize, enum block_cache_entries* cache_index DBG_PASS );
#define vfs_os_DSEEK(v,b,s,c) vfs_os_DSEEK_(v,b,s,c DBG_SRC )
uintptr_t vfs_os_FSEEK( struct sack_vfs_os_volume* vol
	, struct sack_vfs_os_file* file
	, BLOCKINDEX firstblock
	, FPI offset
	, enum block_cache_entries* cache_index
	, int blockSize
	DBG_PASS
);
static size_t CPROC sack_vfs_os_seek_internal( struct sack_vfs_os_file* file, size_t pos, int whence );
static size_t CPROC sack_vfs_os_write_internal( struct sack_vfs_os_file* file, const void* data_, size_t length
	, POINTER writeState );
static size_t CPROC sack_vfs_os_read_internal( struct sack_vfs_os_file* file, uint64_t version, void* data_, size_t length );
#  ifdef _MSC_VER
#    pragma pack (push, 1)
#  endif
PREFIX_PACKED struct directory_hash_lookup_block
{
	BLOCKINDEX next_block[256];
	struct directory_entry entries[VFS_DIRECTORY_ENTRIES];
	BLOCKINDEX names_first_block;
	uint8_t used_names;
} PACKED;
PREFIX_PACKED struct directory_patch_block
{
	union direction_patch_block_entry_union {
		struct direction_patch_block_entry {
			BIT_FIELD index : 8;
			BIT_FIELD hash_block : 24;
		} dirIndex;
		FPI raw;
	}entries[(DIR_BLOCK_SIZE-sizeof(BLOCKINDEX))/sizeof(uint32_t)];
	uint8_t usedEntries;
	BLOCKINDEX morePatches;
} PACKED;
PREFIX_PACKED struct directory_patch_ref_block
{
	PREFIX_PACKED struct directory_patch_ref_entry {
		BLOCKINDEX patchBlockStart;
 // first patch block
		BLOCKINDEX dirBlock;
		uint16_t patchNum;
 // which directory entry this patches
		uint8_t dirEntry;
	} entries[(DIR_BLOCK_SIZE)/sizeof( struct directory_patch_ref_entry )] PACKED;
} PACKED;
#  ifdef _MSC_VER
#    pragma pack (pop)
#  endif
enum sack_vfs_os_seal_states {
	SACK_VFS_OS_SEAL_NONE = 0,
	SACK_VFS_OS_SEAL_LOAD,
	SACK_VFS_OS_SEAL_VALID,
	SACK_VFS_OS_SEAL_STORE,
  // validate failed (read whole file check)
	SACK_VFS_OS_SEAL_INVALID,
  // stored patch is writeable
	SACK_VFS_OS_SEAL_CLEARED,
  // stored patch new sealant (after read valid, new write)
	SACK_VFS_OS_SEAL_STORE_PATCH,
};
struct file_block_definition {
	uint32_t avail;
	uint32_t used;
};
struct file_block_small_definition {
	uint16_t avail;
	uint16_t used;
};
struct file_block_large_definition {
	uint64_t avail;
	uint64_t used;
};
struct file_header {
	struct file_block_small_definition sealant;
	struct file_block_definition references;
	struct file_block_large_definition fileData;
	struct file_block_small_definition indexes;
	struct file_block_definition referencedBy;
};
#if 0
static void flushFileSuffix( struct sack_vfs_os_file* file );
static void WriteIntoBlock( struct sack_vfs_os_file* file, int blockType, FPI pos, CPOINTER data, FPI length );
#endif
//#define DEBUG_TEST_LOCKS
//#define DEBUG_VALIDATE_TREE_ADD
//#define DEBUG_LOG_LOCKS
//#define INVERSE_TEST
//#define DEBUG_DELETE_BALANCE
//#define DEBUG_TIMELINE_REORDER_LOGGING
//#define DEBUG_AVL_DETAIL
int nodes;
struct storageTimelineCache {
	BLOCKINDEX timelineSector;
	FPI dirEntry[BLOCK_SIZE / sizeof( FPI )];
	struct dirent_cache caches[BLOCK_SIZE / sizeof( FPI )];
	//	struct dirent_cache caches[BLOCK_SIZE / sizeof( FPI )];
};
#define timelineBlockIndexNull 0
typedef union timelineBlockType {
	// 0 is invalid; indexes must subtract 1 to get
	// real timeline index.
	uint64_t raw;
	struct timelineBlockReference {
		uint64_t index;
	} ref;
} TIMELINE_BLOCK_TYPE;
#  ifdef _MSC_VER
#    pragma pack (push, 1)
#  endif
PREFIX_PACKED struct timelineHeader {
	TIMELINE_BLOCK_TYPE first_free_entry;
	TIMELINE_BLOCK_TYPE crootNode_deleted;
  // this index is 0 when initialized, and has a +1 to the entry number.
	TIMELINE_BLOCK_TYPE srootNode;
	TIMELINE_BLOCK_TYPE last_added_entry;
	uint64_t unused[4];
	//uint64_t unused2[8];
} PACKED;
// current size is 64 bytes.
// me_fpi is the physical FPI in the timeline file of the TIMELINE_BLOCK_TYPE that references 'this' block.
// structure defines little endian structure for storage.
PREFIX_PACKED struct storageTimelineNode0 {
	// if dirent_fpi == 0; it's free; and priorData will point at another free node
	uint64_t dirent_fpi;
	uint32_t priorTime;
	uint16_t priorDataPad;
 // how much of the last block in the file is not used
	uint8_t  filler8_1;
 // lesser least significant byte of time... sometimes can read time including timezone offset with time - 1 byte
	uint8_t  timeTz;
	uint64_t time;
 // if not 0, references a start block version of data.
	uint64_t priorData;
} PACKED;
PREFIX_PACKED struct storageTimelineNode {
	// if dirent_fpi == 0; it's free; and priorData will point at another free node
	uint64_t dirent_fpi;
	uint32_t priorTime;
	uint16_t priorDataPad;
 // how much of the last block in the file is not used
	uint8_t  filler8_1;
 // lesser least significant byte of time... sometimes can read time including timezone offset with time - 1 byte
	uint8_t  timeTz;
	uint64_t time;
 // if not 0, references a start block version of data.
	uint64_t priorData;
 // if not 0, references a start block version of data.
	uint64_t nextWrite;
 // if not 0, references a start block version of data.
	uint64_t priorWrite;
 // This is the actual size of the data starting at block priorData
	uint64_t priorDataSize;
 // if not 0, references a start block version of data.
	uint64_t filler64_2;
} PACKED;
#  ifdef _MSC_VER
#    pragma pack (pop)
#  endif
struct memoryTimelineNode {
	// if dirent_fpi == 0; it's free.
	FPI this_fpi;
	uint64_t index;
	// the end of this is the same as storage timeline.
	struct storageTimelineNode* disk;
	enum block_cache_entries diskCache;
};
struct storageTimelineCursor {
  // save stack of parents in cursor
	PDATASTACK parentNodes;
 // temp; needs work.
	struct storageTimelineCache dirents;
};
struct sack_vfs_os_time_cursor {
	struct sack_vfs_os_volume* vol;
	uint64_t at;
};
#  ifdef _MSC_VER
#    pragma pack (push, 1)
#  endif
#define NUM_ROOT_TIMELINE_NODES (TIME_BLOCK_SIZE - sizeof( struct timelineHeader )) / sizeof( struct storageTimelineNode )
PREFIX_PACKED struct storageTimeline {
	struct timelineHeader header;
	struct storageTimelineNode entries[NUM_ROOT_TIMELINE_NODES];
} PACKED;
/*
#define NUM_TIMELINE_NODES (TIME_BLOCK_SIZE) / sizeof( struct storageTimelineNode )
PREFIX_PACKED struct storageTimelineBlock {
	struct storageTimelineNode entries[(TIME_BLOCK_SIZE) / sizeof( struct storageTimelineNode )];
} PACKED;
*/
#  ifdef _MSC_VER
#    pragma pack (pop)
#  endif
#ifdef DEBUG_VALIDATE_TREE
#define VTReadOnly  , TRUE
#define VTReadWrite  , FALSE
#else
#define VTReadOnly
#define VTReadWrite
#endif
#ifdef _DEBUG
#define GRTENoLog ,0
#define GRTELog ,1
#else
#define GRTENoLog
#define GRTELog
#endif
#define convertMeToParentFPI(n) ((n)&~0x3f)
#define convertMeToParentIndex(n) (((n)>sizeof(struct timelineHeader))?( ( convertMeToParentFPI((n)&~0x3f)- sizeof( struct timelineHeader ) ) / sizeof( struct storageTimelineNode ) + 1 ):0)
struct storageTimelineNode* getRawTimeEntry( struct sack_vfs_os_volume* vol, uint64_t timeEntry, enum block_cache_entries *cache
#if _DEBUG
	, int log
#endif
	 DBG_PASS )
{
	int locks;
	cache[0] = BC( TIMELINE );
	FPI pos = sane_offsetof( struct storageTimeline, entries[timeEntry - 1] );
/*no block*/
	struct storageTimelineNode* node = ( struct storageTimelineNode* )vfs_os_FSEEK( vol, vol->timeline_file, 0, pos, cache, TIME_BLOCK_SIZE DBG_SRC );
	//_lprintf(DBG_RELAY)( "Load Entry %d", (int)timeEntry );
	locks = GETMASK_( vol->seglock, seglock, cache[0] );
#ifdef DEBUG_TEST_LOCKS
#  ifdef DEBUG_LOG_LOCKS
#    ifdef _DEBUG
	if( log )
#    endif
		_lprintf(DBG_RELAY)( "Lock %d %d %d", (int)timeEntry, cache[0], locks );
#  endif
	if( locks > 9 ) {
		lprintf( "Lock OVERFLOW" );
		DebugBreak();
	}
#endif
	locks++;
	SETMASK_( vol->seglock, seglock, cache[0], locks );
	return node;
}
TIMELINE_BLOCK_TYPE* getRawTimePointer( struct sack_vfs_os_volume* vol, uint64_t fpi, enum block_cache_entries *cache ) {
	cache[0] = BC( TIMELINE );
/*no block*/
	return (TIMELINE_BLOCK_TYPE*)vfs_os_FSEEK( vol, vol->timeline_file, 0, fpi, cache, TIME_BLOCK_SIZE DBG_SRC );
}
void dropRawTimeEntry( struct sack_vfs_os_volume* vol, enum block_cache_entries cache
#if _DEBUG
	, int log
#endif
	 DBG_PASS ) {
	int locks;
	locks = GETMASK_( vol->seglock, seglock, cache );
#ifdef DEBUG_TEST_LOCKS
#  ifdef DEBUG_LOG_LOCKS
#    ifdef _DEBUG
	if( log )
#    endif
	_lprintf(DBG_RELAY)( "UnLock %d %d", cache, locks );
#  endif
	if( !locks ) {
		lprintf( "Lock UNDERFLOW" );
		DebugBreak();
	}
#endif
	locks--;
	SETMASK_( vol->seglock, seglock, cache, locks );
}
void reloadTimeEntry( struct memoryTimelineNode* time, struct sack_vfs_os_volume* vol, uint64_t timeEntry
#ifdef DEBUG_VALIDATE_TREE
	, LOGICAL readOnly
#endif
#if _DEBUG
	, int log
#endif
	 DBG_PASS )
{
	enum block_cache_entries cache =
#ifdef DEBUG_VALIDATE_TREE
		readOnly ?BC(TIMELINE_RO):
#endif
		BC( TIMELINE );
	//uintptr_t vfs_os_FSEEK( struct sack_vfs_os_volume *vol, BLOCKINDEX firstblock, FPI offset, enum block_cache_entries *cache_index DBG_SRC ) {
	//if( timeEntry > 62 )DebugBreak();
	int locks;
	FPI pos = sane_offsetof( struct storageTimeline, entries[timeEntry - 1] );
	//lprintf( "Read Entry %d", (int)timeEntry );
/*no block*/
	struct storageTimelineNode* node = ( struct storageTimelineNode* )vfs_os_FSEEK( vol, vol->timeline_file, 0, pos, &cache, TIME_BLOCK_SIZE DBG_RELAY );
	locks = GETMASK_( vol->seglock, seglock, cache );
#ifdef DEBUG_TEST_LOCKS
#ifdef DEBUG_LOG_LOCKS
#ifdef _DEBUG
	if( log )
#endif
		_lprintf(DBG_RELAY)( "Lock %d %d %d", (int)timeEntry, cache, locks );
#endif
	if( locks > 12 ) {
		lprintf( "Lock OVERFLOW" );
		DebugBreak();
	}
#endif
	locks++;
	SETMASK_( vol->seglock, seglock, cache, locks );
	time->disk = node;
	time->diskCache = cache;
	time->index = timeEntry;
	time->this_fpi = pos;
}
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
// didn't actually have to use this.
static void dumpTimeline( struct sack_vfs_os_volume* vol ) {
	lprintf( "--- Timeline ----" );
	lprintf( "root %lld last %lld free %lld", vol->timeline->header.srootNode.raw, vol->timeline->header.last_added_entry.raw, vol->timeline->header.first_free_entry.raw );
	int entry;
	enum block_cache_entries_os cache = BC( TIMELINE );
	struct storageTimelineNode* block;
	for( entry = 1; entry != vol->timeline->header.first_free_entry.raw; entry++ ) {
		block = getRawTimeEntry( vol, entry, &cache GRTENoLog DBG_SRC );
		lprintf( "Entry %d  de:%lld prev:%lld next:%lld time:%lld tz:%d", entry, block->dirent_fpi, block->priorWrite, block->nextWrite, block->time, block->timeTz );
		dropRawTimeEntry( vol, cache GRTENoLog DBG_SRC );
	}
}
#endif
//-----------------------------------------------------------------------------------
// Timeline Support Functions
//-----------------------------------------------------------------------------------
static void reorderEntry( struct memoryTimelineNode* time, struct sack_vfs_os_volume* vol, int toEnd DBG_PASS ) {
	if( time ) {
		// time changed...(maybe?)
		{
			uint64_t myself = time->index;
			struct storageTimelineNode* prev;
			enum block_cache_entries_os cache, _cache = BC(ZERO);
			if( time->disk->priorWrite ) {
				prev = getRawTimeEntry( vol, time->disk->priorWrite, &cache GRTENoLog DBG_RELAY );
			} else { prev = NULL; cache = BC(ZERO); }
			enum block_cache_entries_os cache2, _cache2 = BC(ZERO);
			struct storageTimelineNode* next;
			if( time->disk->nextWrite ) {
				next = getRawTimeEntry( vol, time->disk->nextWrite, &cache2 GRTENoLog DBG_RELAY );
			} else { next = NULL; cache2 = BC(ZERO); }
			if( toEnd ) {
				enum block_cache_entries_os cache3;
				struct storageTimelineNode* last;
				last = getRawTimeEntry( vol, vol->timeline->header.last_added_entry.ref.index, &cache3 GRTENoLog DBG_SRC );
				if( last && last->time <= time->disk->time ) {
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
					dumpTimeline( vol );
#endif
					last->nextWrite = myself;
					if( !time->disk->priorWrite ) {
						if( next ) next->priorWrite = 0;
						vol->timeline->header.srootNode.ref.index = time->disk->nextWrite;
					} else if(next ) next->priorWrite = time->disk->priorWrite;
					if( prev ) prev->nextWrite = time->disk->nextWrite;
					time->disk->priorWrite = vol->timeline->header.last_added_entry.ref.index;
					time->disk->nextWrite = 0;
					// if this is the new end of the list, update the last entry....
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
					lprintf( "new last block:%lld after %lld", myself, vol->timeline->header.last_added_entry.ref.index );
#endif
					vol->timeline->header.last_added_entry.ref.index = myself;
					SMUDGECACHE( vol, vol->timelineCache );
					if( prev ) dropRawTimeEntry( vol, cache GRTELog DBG_RELAY );
					if( next ) dropRawTimeEntry( vol, cache2 GRTELog DBG_RELAY );
					if( last ) dropRawTimeEntry( vol, cache3 GRTELog DBG_RELAY );
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
					dumpTimeline( vol );
#endif
					return;
				} else {
					if( last ) dropRawTimeEntry( vol, cache3 GRTENoLog DBG_RELAY );
				}
			}
			if( next && ( next->time < time->disk->time ) ) {
				//myself = next->priorWrite;
				if( prev )
					prev->nextWrite = time->disk->nextWrite;
				else {
					vol->timeline->header.srootNode.ref.index = time->disk->nextWrite;
					SMUDGECACHE( vol, vol->timelineCache );
				}
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
				lprintf( "Searching forward...." );
#endif
				next->priorWrite = time->disk->priorWrite;
				while( ( prev = next ) && ( ( _cache ? dropRawTimeEntry( vol, _cache GRTENoLog DBG_RELAY ) : (void)0 ), ( _cache = cache ), ( cache = BC( TIMELINE ) ),
					( next = getRawTimeEntry( vol, prev->nextWrite, &cache GRTENoLog DBG_SRC ) ) )
					) {
					if( !next->nextWrite ) {
						if( !time->disk->priorWrite ) {
							struct storageTimelineNode* next;
							enum block_cache_entries_os cache = BC( TIMELINE );
							next = getRawTimeEntry( vol, time->disk->nextWrite, &cache GRTENoLog DBG_RELAY );
							if( next ) next->priorWrite = 0;
							vol->timeline->header.srootNode.ref.index = time->disk->nextWrite;
							dropRawTimeEntry( vol, cache GRTENoLog DBG_RELAY );
						}
						time->disk->priorWrite = prev->nextWrite;
						time->disk->nextWrite = 0;
						next->nextWrite = myself;
						dropRawTimeEntry( vol, cache GRTELog DBG_RELAY );
						if( cache2 ) dropRawTimeEntry( vol, cache2 GRTELog DBG_RELAY );
						// if this is the new end of the list, update the last entry....
						vol->timeline->header.last_added_entry.ref.index = myself;
						SMUDGECACHE( vol, vol->timelineCache );
 // done. (at end anyway)
						break;
					}
					if( next->time > time->disk->time ) {
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
						lprintf( "found insertion point %lld  %lld %lld", myself, prev->nextWrite, next->priorWrite );
#endif
						if( !time->disk->priorWrite ) {
							struct storageTimelineNode* next;
							enum block_cache_entries_os cache = BC( TIMELINE );
							next = getRawTimeEntry( vol, time->disk->nextWrite, &cache GRTENoLog DBG_RELAY );
							if( next ) next->priorWrite = 0;
							vol->timeline->header.srootNode.ref.index = time->disk->nextWrite;
							dropRawTimeEntry( vol, cache GRTENoLog DBG_RELAY );
						}
						time->disk->nextWrite = prev->nextWrite;
						time->disk->priorWrite = next->priorWrite;
						prev->nextWrite = myself;
						next->priorWrite = myself;
						dropRawTimeEntry( vol, cache GRTELog DBG_RELAY );
						if( cache2 ) dropRawTimeEntry( vol, cache2 GRTELog DBG_RELAY );
						break;
					}
				}
			} else if( prev && ( prev->time > time->disk->time ) ) {
				//myself = prev->nextWrite;
				if( !( prev->nextWrite = time->disk->nextWrite ) ) {
					vol->timeline->header.last_added_entry.ref.index = time->disk->priorWrite;
					SMUDGECACHE( vol, vol->timelineCache );
				}
				if( next )
					next->priorWrite = time->disk->priorWrite;
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
				lprintf( "Searching backward" );
				dumpTimeline( vol );
#endif
				while( ( _cache2 ? dropRawTimeEntry( vol, _cache2 GRTENoLog DBG_RELAY ) : (void)0 ), ( _cache2 = cache2 ), ( cache2 = BC( TIMELINE ) )
					, ( next = prev ) ) {
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
					lprintf( "checking next record %lld", next->priorWrite );
#endif
					if( !next->priorWrite ) {
						next->priorWrite = myself;
						if( !time->disk->nextWrite ) {
							struct storageTimelineNode* prev;
							enum block_cache_entries_os cache = BC( TIMELINE );
							prev = getRawTimeEntry( vol, time->disk->priorWrite, &cache GRTENoLog DBG_RELAY );
							if( prev ) prev->nextWrite = 0;
							vol->timeline->header.last_added_entry.ref.index = time->disk->priorWrite;
							dropRawTimeEntry( vol, cache GRTENoLog DBG_RELAY );
						}
						time->disk->nextWrite = vol->timeline->header.srootNode.ref.index;
						time->disk->priorWrite = 0;
						vol->timeline->header.srootNode.ref.index = myself;
						SMUDGECACHE( vol, vol->timelineCache );
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
						lprintf( "Saving as first..." );
#endif
						if( cache ) dropRawTimeEntry( vol, cache GRTELog DBG_RELAY );
						dropRawTimeEntry( vol, cache2 GRTELog DBG_RELAY );
						break;
					} else {
						( prev = getRawTimeEntry( vol, next->priorWrite, &cache2 GRTENoLog DBG_SRC ) );
					}
					if( !prev->priorWrite ) {
						// new root node...
						vol->timeline->header.srootNode.ref.index = prev->priorWrite = myself;
						SMUDGECACHE( vol, vol->timelineCache );
						if( !time->disk->nextWrite ) {
							struct storageTimelineNode* prev;
							enum block_cache_entries_os cache = BC( TIMELINE );
							prev = getRawTimeEntry( vol, time->disk->priorWrite, &cache GRTENoLog DBG_RELAY );
							if( prev ) prev->nextWrite = 0;
							vol->timeline->header.last_added_entry.ref.index = time->disk->priorWrite;
							dropRawTimeEntry( vol, cache GRTENoLog DBG_RELAY );
						}
						time->disk->nextWrite = next->priorWrite;
						time->disk->priorWrite = 0;
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
						lprintf( "Saving as first(2)..." );
#endif
						if( cache ) dropRawTimeEntry( vol, cache GRTELog DBG_RELAY );
						dropRawTimeEntry( vol, cache2 GRTELog DBG_RELAY );
 // done. (at end anyway)
						break;
					}
					if( prev->time < time->disk->time ) {
						if( !time->disk->nextWrite ) {
							struct storageTimelineNode* prev;
							enum block_cache_entries_os cache = BC( TIMELINE );
							prev = getRawTimeEntry( vol, time->disk->priorWrite, &cache GRTENoLog DBG_RELAY );
							if( prev ) prev->nextWrite = 0;
							vol->timeline->header.last_added_entry.ref.index = time->disk->priorWrite;
							dropRawTimeEntry( vol, cache GRTENoLog DBG_RELAY );
						}
						time->disk->nextWrite = prev->nextWrite;
						time->disk->priorWrite = next->priorWrite;
						prev->nextWrite = myself;
						next->priorWrite = myself;
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
						lprintf( "Saving in middle..." );
#endif
						if( cache ) dropRawTimeEntry( vol, cache GRTELog DBG_RELAY );
						dropRawTimeEntry( vol, cache2 GRTELog DBG_RELAY );
						break;
					}
				}
			} else {
				// didn't have to move anything... maybe it's time is still the same relative to everything?
			}
		}
	}
#ifdef DEBUG_TIMELINE_REORDER_LOGGING
	dumpTimeline( vol );
#endif
}
//-----------------------------------------------------------------------------------
// Timeline Support Functions
//-----------------------------------------------------------------------------------
void updateTimeEntry( struct memoryTimelineNode* time, struct sack_vfs_os_volume* vol, LOGICAL drop DBG_PASS ) {
	if( time ) {
		SMUDGECACHE( vol, time->diskCache );
		// time changed...(maybe?)
	}
	if( drop ) {
		int locks;
		int bit = time->diskCache;
		locks = GETMASK_( vol->seglock, seglock, bit );
#ifdef DEBUG_TEST_LOCKS
#ifdef DEBUG_LOG_LOCKS
		lprintf( "Unlock %d %d", time->diskCache, locks );
#endif
		if( !locks ) {
			lprintf( "Lock UNDERFLOW" );
			DebugBreak();
		}
#endif
		locks--;
		SETMASK_( vol->seglock, seglock, bit, locks );
	}
}
//---------------------------------------------------------------------------
void reloadDirectoryEntry( struct sack_vfs_os_volume* vol, struct memoryTimelineNode* time, struct sack_vfs_os_find_info* decoded_dirent DBG_PASS ) {
	enum block_cache_entries cache = BC( DIRECTORY );
// , * entkey;
	struct directory_entry* dirent;
	struct directory_hash_lookup_block* dirblock;
	//struct directory_hash_lookup_block* dirblockkey;
	PDATASTACK pdsChars = CreateDataStack( 1 );
	BLOCKINDEX this_dir_block = (time->disk->dirent_fpi >> DIR_BLOCK_SIZE_BITS )-1;
	BLOCKINDEX next_block;
	dirblock = BTSEEK( struct directory_hash_lookup_block*, vol, this_dir_block, DIR_BLOCK_SIZE, cache );
	//dirblockkey = (struct directory_hash_lookup_block*)vol->usekey[cache];
	dirent = (struct directory_entry*)( ( (uintptr_t)dirblock ) + ( time->disk->dirent_fpi & ( DIR_BLOCK_SIZE - 1 ) ) );
	//entkey = (struct directory_entry*)(((uintptr_t)dirblockkey) + (time->dirent_fpi & BLOCK_SIZE));
	decoded_dirent->vol = vol;
	// all of this regards the current state of a find cursor...
	decoded_dirent->base = NULL;
	decoded_dirent->base_len = 0;
	decoded_dirent->mask = NULL;
	decoded_dirent->pds_directories = NULL;
	decoded_dirent->filesize = (size_t)( dirent->filesize );
	if( time->disk->priorTime ) {
		enum block_cache_entries cache;
		struct storageTimelineNode* prior = getRawTimeEntry( vol, time->disk->priorTime, &cache GRTENoLog DBG_SRC );
		while( prior->priorTime ) {
			dropRawTimeEntry( vol, cache GRTENoLog DBG_RELAY );
			prior = getRawTimeEntry( vol, prior->priorTime, &cache GRTENoLog DBG_RELAY );
		}
		decoded_dirent->ctime = prior->time;
		dropRawTimeEntry( vol, cache GRTENoLog DBG_RELAY );
	}
	else
		decoded_dirent->ctime = time->disk->time;
	decoded_dirent->wtime = time->disk->time;
	while( (next_block = dirblock->next_block[DIRNAME_CHAR_PARENT]) ) {
		enum block_cache_entries back_cache = BC( DIRECTORY );
		struct directory_hash_lookup_block* back_dirblock;
		back_dirblock = BTSEEK( struct directory_hash_lookup_block*, vol, next_block, DIR_BLOCK_SIZE, back_cache );
		//back_dirblockkey = (struct directory_hash_lookup_block*)vol->usekey[back_cache];
		int i;
		for( i = 0; i < DIRNAME_CHAR_PARENT; i++ ) {
			if( (back_dirblock->next_block[i]) == this_dir_block ) {
				PushData( &pdsChars, &i );
				break;
			}
		}
		if( i == DIRNAME_CHAR_PARENT ) {
			// directory didn't have a forward link to it?
			DebugBreak();
		}
		this_dir_block = next_block;
		dirblock = back_dirblock;
	}
	char* c;
	int n = 0;
	// could fill leadin....
	decoded_dirent->leadin[0] = 0;
	decoded_dirent->leadinDepth = 0;
	while( c = (char*)PopData( &pdsChars ) )
		decoded_dirent->filename[n++] = c[0];
	DeleteDataStack( &pdsChars );
	{
		BLOCKINDEX nameBlock;
		nameBlock = dirblock->names_first_block;
		FPI name_offset = (dirent[n].name_offset ) & DIRENT_NAME_OFFSET_OFFSET;
		enum block_cache_entries cache = BC( NAMES );
		const char* dirname = (const char*)vfs_os_FSEEK( vol, NULL, nameBlock, name_offset, &cache, NAME_BLOCK_SIZE DBG_SRC );
		const char* dirname_ = dirname;
		//const char* dirkey = (const char*)(vol->usekey[cache]) + (name_offset & BLOCK_MASK);
		const char* prior_dirname = dirname;
		int c;
		do {
			while( (((unsigned char)(c = (dirname[0] )) != UTF8_EOT))
				&& ((((uintptr_t)prior_dirname) & ~BLOCK_MASK) == (((uintptr_t)dirname) & ~BLOCK_MASK))
				) {
				decoded_dirent->filename[n++] = c;
				dirname++;
				//dirkey++;
			}
			if( ((((uintptr_t)prior_dirname) & ~BLOCK_MASK) != (((uintptr_t)dirname) & ~BLOCK_MASK)) ) {
				int partial = (int)(dirname - dirname_);
				cache = BC( NAMES );
				dirname = (const char*)vfs_os_FSEEK( vol, NULL, nameBlock, name_offset + partial, &cache, NAME_BLOCK_SIZE DBG_SRC );
				//dirkey = (const char*)(vol->usekey[cache]) + ((name_offset + partial) & BLOCK_MASK);
				dirname_ = dirname - partial;
				prior_dirname = dirname;
				continue;
			}
			// didn't stop because it exceeded a sector boundary
			break;
		} while( 1 );
	}
	decoded_dirent->filename[n] = 0;
	decoded_dirent->filenamelen = n;
	//time->dirent_fpi
}
//---------------------------------------------------------------------------
static void deleteTimelineIndex( struct sack_vfs_os_volume* vol, BLOCKINDEX index ) {
	BLOCKINDEX next;
	do {
		struct storageTimelineNode* time;
		enum block_cache_entries cache = BC( TIMELINE );
		//lprintf( "Delete start... %d", index );
		time = getRawTimeEntry( vol, index, &cache GRTELog DBG_SRC );
 // this type is larger than index in some configurations
		next = (BLOCKINDEX)time->priorTime;
		nodes--;
		if( !next ) {
			if( vol->timeline->header.srootNode.ref.index == index ) {
				vol->timeline->header.srootNode.ref.index = time->nextWrite;
			}
		}
		{
			struct storageTimeline* timeline = vol->timeline;
			time->priorTime = (uint32_t)timeline->header.first_free_entry.ref.index;
			timeline->header.first_free_entry.ref.index = index;
			SMUDGECACHE( vol, vol->timelineCache );
			SMUDGECACHE( vol, cache );
		}
		dropRawTimeEntry( vol, cache GRTELog DBG_SRC );
#ifdef DEBUG_VALIDATE_TREE
		//ValidateTimelineTree( vol DBG_SRC );
#endif
		//lprintf( "Delete done... %d", index );
	} while( index = next );
#ifdef DEBUG_DELETE_LAST
	checkRoot( vol );
#endif
	//lprintf( "Root is now %d %d", nodes, vol->timeline->header.srootNode.ref.index );
}
BLOCKINDEX getTimeEntry( struct memoryTimelineNode* time, struct sack_vfs_os_volume* vol, LOGICAL unused, void(*init)(uintptr_t, struct memoryTimelineNode*), uintptr_t psv DBG_PASS ) {
	//enum block_cache_entries cache = BC( TIMELINE );
	//enum block_cache_entries cache_last = BC( TIMELINE );
	//enum block_cache_entries cache_free = BC( TIMELINE );
	//enum block_cache_entries cache_new = BC( TIMELINE );
	struct storageTimeline* timeline = vol->timeline;
	TIMELINE_BLOCK_TYPE freeIndex;
	BLOCKINDEX index;
	//BLOCKINDEX priorIndex = (BLOCKINDEX)time->index; // ref.index type is larger than index in some configurations; but won't exceed those bounds
	BLOCKINDEX lastIndex = timeline->header.last_added_entry.ref.index;
	freeIndex.ref.index = timeline->header.first_free_entry.ref.index;
	// update next free.
 // ref.index type is larger than index in some configurations; but won't exceed those bounds
	reloadTimeEntry( time, vol, index = (BLOCKINDEX)freeIndex.ref.index VTReadWrite GRTELog DBG_RELAY );
	if( !timeline->header.srootNode.ref.index )
		timeline->header.srootNode.ref.index = 1;
	timeline->header.first_free_entry.ref.index = timeline->header.first_free_entry.ref.index + 1;
	// make sure the new entry is emptied.
	//time->disk->me_fpi = 0;
	time->disk->dirent_fpi = 0;
	time->disk->priorTime = 0;
	time->disk->priorData = 0;
	time->disk->priorDataSize = 0;
	if( lastIndex )
	{
		enum block_cache_entries cache_near = BC( TIMELINE );
		struct storageTimelineNode* last = getRawTimeEntry( vol, lastIndex, &cache_near GRTENoLog DBG_RELAY );
		if( !last->nextWrite ) {
			last->nextWrite = index;
			// updated a value here...
			SMUDGECACHE( vol, cache_near );
		} else {
			lprintf( "Shouldn't have to find what the last node in the chain is...." );
			/*
			dropRawTimeEntry( vol, cache_near GRTENoLog DBG_RELAY );
			while( last = getRawTimeEntry( vol, last->nextWrite, &cache_near GRTENoLog DBG_RELAY ) ) {
				dropRawTimeEntry( vol, cache_near );
				if( !last->nextWrite ) {
					last->nextWrite = index;
					break;
				}
			}
			*/
		}
		dropRawTimeEntry( vol, cache_near GRTENoLog DBG_RELAY );
	}
	time->disk->priorWrite = lastIndex;
	time->disk->nextWrite = 0;
 // there really shouldn't be any times after this one....
	time->disk->time = timeGetTime64ns();
	timeline->header.last_added_entry.ref.index = index;
	SMUDGECACHE( vol, vol->timelineCache );
	{
		int tz = GetTimeZone();
		if( tz < 0 )
 // -840/15 = -56
			tz = -( ( ( -tz / 100 ) * 60 ) + ( -tz % 100 ) ) / 15;
		else
 // -840/15 = -56  720/15 = 48
			tz = ( ( ( tz / 100 ) * 60 ) + ( tz % 100 ) ) / 15;
		//time->disk->time += (int64_t)tz * 900 * (int64_t)1000000000;
		time->disk->timeTz = tz;
	}
	if( init ) init( psv, time );
	//nodes++;
	//lprintf( "Add start... %d", freeIndex.ref.index );
#if defined( DEBUG_TIMELINE_DIR_TRACKING) || defined( DEBUG_TIMELINE_AVL )
	LoG( "Return time entry:%d", time->index );
#endif
 // don't drop; returning this one.
	updateTimeEntry( time, vol, FALSE DBG_RELAY );
	return index;
}
BLOCKINDEX updateTimeEntryTime( struct memoryTimelineNode* time
			, struct sack_vfs_os_volume *vol, uint64_t index
			, LOGICAL allocateNew
			, void( *init )( uintptr_t, struct memoryTimelineNode* ), uintptr_t psv DBG_PASS ) {
	if( allocateNew ) {
		if( time ) {
			uint64_t inputIndex = time ? time->index : index;
			// gets a new timestamp.
			//enum block_cache_entries inputCache = time ? time->diskCache : BC( ZERO );
			BLOCKINDEX newIndex = getTimeEntry( time, vol, TRUE, init, psv DBG_RELAY );
			time->disk->priorTime = (uint32_t)inputIndex;
			updateTimeEntry( time, vol, FALSE DBG_RELAY );
			//dropRawTimeEntry( vol, inputCache GRTELog DBG_RELAY );
			return newIndex;
		}
		else {
			struct memoryTimelineNode time_;
			struct storageTimelineNode* timeold;
			uint64_t inputIndex = index;
			enum block_cache_entries inputCache;
			FPI dirent_fpi;
			timeold = getRawTimeEntry( vol, index, &inputCache GRTELog DBG_RELAY );
 // ref.index type is larger than index in some configurations; but won't exceed those bounds
			dirent_fpi = (FPI)timeold->dirent_fpi;
			dropRawTimeEntry( vol, inputCache GRTELog DBG_RELAY );
			// gets a new timestamp.
			time_.index = index;
			BLOCKINDEX newIndex = getTimeEntry( &time_, vol, TRUE, init, psv DBG_RELAY );
			time_.disk->priorTime = (uint32_t)inputIndex;
			time_.disk->dirent_fpi = dirent_fpi;
			updateTimeEntry( &time_, vol, TRUE DBG_RELAY );
			return newIndex;
		}
	}
	else {
		struct memoryTimelineNode time_;
		//LOGICAL existing = ( time ) ? 1 : 0;
		if( !time ) time = &time_;
		reloadTimeEntry( time, vol, index VTReadWrite GRTENoLog DBG_RELAY );
		time->disk->time = timeGetTime64ns();
		{
			int tz = GetTimeZone();
			if( tz < 0 )
 // -840/15 = -56
				tz = -( ( ( -tz / 100 ) * 60 ) + ( -tz % 100 ) ) / 15;
			else
 // -840/15 = -56  720/15 = 48
				tz = ( ( ( tz / 100 ) * 60 ) + ( tz % 100 ) ) / 15;
			//time->disk->time += (int64_t)tz * 900 * (int64_t)1000000000;
			time->disk->timeTz = tz;
		}
		reorderEntry( time, vol, 1 DBG_RELAY );
		updateTimeEntry( time, vol, TRUE DBG_RELAY );
 // index type is larger than index in some configurations; but won't exceed those bounds
		return (BLOCKINDEX)index;
	}
}
LOGICAL setTimeEntryTime( struct memoryTimelineNode* time
			, struct sack_vfs_os_volume *vol
			, uint64_t tick
			, int tz ) {
	if( !time ) {
//time = &time_;
		lprintf( "invalid time entry passed" );
		return FALSE;
	} else {
		//reloadTimeEntry( time, vol, index VTReadWrite GRTENoLog DBG_RELAY );
		time->disk->timeTz = tz;
		time->disk->time = tick;
		reorderEntry( time, vol, 0 DBG_SRC );
		updateTimeEntry( time, vol, FALSE DBG_SRC );
		return TRUE;
	}
}
struct sack_vfs_os_time_cursor* sack_vfs_os_get_time_cursor( struct sack_vfs_os_volume *vol ) {
	struct sack_vfs_os_time_cursor* cursor;
	cursor = New( struct sack_vfs_os_time_cursor );
	cursor->vol = vol;
	cursor->at = 0;
	return cursor;
}
//--------------------------------
//  read TIme Cursor reads/steps the cursor...
//    step==0 && time === 0 && at === 0 ; start at the start of timeline.
//    step==0 && time === N ; seek to time N, update at to the found record
//    step==1 && time === N ; seek to record N, update at to the time at the indexed record
//
LOGICAL sack_vfs_os_read_time_cursor( struct sack_vfs_os_time_cursor* cursor, int step, uint64_t time, uint64_t* result_entry, const char**filename
	, uint64_t *result_timestamp, int8_t *result_tz, const char**buffer, size_t *size ) {
	static char* dataBuffer;
	static size_t bufsize;
	//uint64_t time = (time_ >> 8) * 1000000;
 // last raw entry cache
	enum block_cache_entries_os cache;
	LOGICAL dropCache = FALSE;
 // used as the record found indicator.
	uint64_t entry = 0;
	if( step == 2 ) {
		entry = cursor->at;
	}
	else if( step == 1 ) {
		if( !time ) {
			cursor->at = entry = cursor->vol->timeline->header.srootNode.ref.index;
		}else
			cursor->at = entry = time;
	}
	else if( step == 0 ) {
		// if( !time_ )
		struct storageTimelineNode* timeNode = getRawTimeEntry( cursor->vol, cursor->vol->timeline->header.srootNode.ref.index, &cache GRTENoLog DBG_SRC );
		while( timeNode && timeNode->time < time ) {
			uint64_t next = timeNode->nextWrite;
			dropRawTimeEntry( cursor->vol, cache  GRTENoLog DBG_SRC );
			if( next ) timeNode = getRawTimeEntry( cursor->vol, next, &cache GRTENoLog DBG_SRC );
			else timeNode = NULL;
			entry = next;
		}
		if( !timeNode )
			return FALSE;
		dropCache = TRUE;
	}
	if( entry )
	{
		LOGICAL retVal = TRUE;
		{
		struct memoryTimelineNode memEntry;
		reloadTimeEntry( &memEntry, cursor->vol, entry GRTENoLog DBG_SRC );
		if( memEntry.disk->dirent_fpi ) {
			cursor->at = memEntry.disk->nextWrite;
			struct sack_vfs_os_find_info decoded_dirent;
			reloadDirectoryEntry( cursor->vol, &memEntry, &decoded_dirent DBG_SRC );
			if( result_entry ) {
				result_entry[0] = memEntry.index;
			}
			if( result_tz ) {
				result_tz[0] = memEntry.disk->timeTz;
			}
			if( result_timestamp ) {
				result_timestamp[0] = memEntry.disk->time;
			}
			if( filename ) {
				filename[0] = StrDup( decoded_dirent.filename );
			}
			if( size ) {
				size[0] = decoded_dirent.filesize;
				if( buffer ) {
					if( bufsize < size[0] ) {
						dataBuffer = (char*)Reallocate( dataBuffer, size[0] );
					}
					buffer[0] = dataBuffer;
					{
						// there might be a more optimal method of doing this; but this is easy to read.
						struct sack_vfs_file* file = sack_vfs_os_openfile( cursor->vol, decoded_dirent.filename );
						sack_vfs_os_read( file, dataBuffer, size[0] );
						sack_vfs_os_close( file );
					}
				}
			}
		} else
			retVal = FALSE;
		dropRawTimeEntry( cursor->vol, memEntry.diskCache GRTENoLog DBG_SRC );
		if( dropCache )
			dropRawTimeEntry( cursor->vol, cache  GRTENoLog DBG_SRC );
		}
		return retVal;
		//cursor->at = time;
	}
	return FALSE;
}
//#include "vfs_os_timeline.c"
//#define priorData prior.ref.index
struct blockInfo {
	BLOCKINDEX block;
	FPI start;
	int size;
};
struct sack_vfs_os_file
{
 // which volume this is in
	struct sack_vfs_os_volume* vol;
	FPI fpi;
	BLOCKINDEX _first_block;
 // this should be in-sync with current FPI always; plz
	BLOCKINDEX block;
  // someone already deleted this...
	LOGICAL delete_on_close;
	struct blockInfo* blockChain;
	unsigned int blockChainAvail;
	unsigned int blockChainLength;
#  ifdef FILE_BASED_VFS
  // where to write the directory entry update to
	FPI entry_fpi;
 // delete also needs the block number
	BLOCKINDEX dir_block;
#    ifdef XX_VIRTUAL_OBJECT_STORE
	/* extended internal file information that just makes it harder to recover in a crash.*/
	int blockSize;
	struct file_header diskHeader;
  // in-memory size, so we can just do generic move op
	struct file_header header;
	//struct memoryTimelineNode timeline;
	uint8_t* seal;
	uint8_t* sealant;
	uint8_t* readKey;
	uint16_t readKeyLen;
	//uint8_t sealantLen;
 // boolean, on read, validates seal.  Defaults to FALSE.
	uint8_t sealed;
	//char* filename;
	LOGICAL fileName;
#    endif
	struct sack_vfs_os_file_flags {
		BIT_FIELD versioned : 1;
	}flags;
  // has file size within
	struct directory_entry  entry_;
  // has file size within
	struct directory_entry* entry;
  // how big the file is (live - reflects size for files opened by version)
	VFS_DISK_DATATYPE filesize_;
 // files without names use this as thier preferred cache target
	enum block_cache_entries cache;
#  else
  // has file size within
	struct directory_entry* entry;
#  endif
};
typedef struct sack_vfs_os_file VFS_OS_FILE;
#define MAXVFS_OS_FILESPERSET 256
DeclareSet( VFS_OS_FILE );
#define l vfs_os_local
static struct {
	struct directory_entry zero_entkey;
	uint8_t zerokey[KEY_SIZE];
	uint16_t index[256][256];
	char leadin[MAX_FILENAME_LEN];
	int leadinDepth;
	PLINKQUEUE plqCrypters;
	PLIST volumes;
	LOGICAL exited;
	PVFS_OS_FILESET files;
 // symbol not defined
#ifdef DEBUG_CONVERT_DIRECTORY
	int fileCount;
	int fileCount_old;
#endif
} l;
//static void _os_UpdateFileBlocks( struct sack_vfs_os_file* file );
static struct sack_vfs_os_file* _os_createFile( struct sack_vfs_os_volume* vol, BLOCKINDEX first_block, int blockSize );
static int sack_vfs_os_close_internal( struct sack_vfs_os_file* file, int unlock );
static enum block_cache_entries _os_UpdateSegmentKey_( struct sack_vfs_os_volume* vol, enum block_cache_entries* cache_idx, BLOCKINDEX segment DBG_PASS );
#ifdef DEBUG_DIRECTORIES
static int _os_dumpDirectories( struct sack_vfs_os_volume *vol, BLOCKINDEX start, LOGICAL init );
#endif
//#include "vfs_os_index.c"
#ifdef XX_VIRTUAL_OBJECT_STORE
static void _os_SetSmallBlockUsage( struct file_block_small_definition* block, int more ) {
	block->used = more;
	while( block->avail < block->used )
		block->avail += 128;
}
static uint32_t _os_AddSmallBlockUsage( struct file_block_small_definition* block, uint32_t more ) {
	uint32_t oldval = block->used;
	_os_SetSmallBlockUsage( block, block->used + more );
	return oldval;
}
static void _os_SetFileBlockUsage( struct file_block_small_definition* block, uint32_t more ) {
	block->used = more;
	while( block->avail < block->used )
		block->avail += 256;
}
#endif
ATEXIT( flushVolumes ){
	INDEX idx;
	struct sack_vfs_os_volume* vol;
	l.exited = 1;
	LIST_FORALL( l.volumes, idx, struct sack_vfs_os_volume*, vol ) {
		if( vol->file )
		sack_vfs_os_flush_volume( vol, TRUE );
#ifdef DEBUG_DIRECTORIES
		_os_dumpDirectories( vol, 0, 1 );
#endif
	}
}
#if 0
#define FILE_BLOCK_SEALANT 0
#define FILE_BLOCK_REFERENCES 1
#define FILE_BLOCK_DATA 2
#define FILE_BLOCK_INDEXES 3
#define FILE_BLOCK_REFERENCED_BY 4
static FPI GetBlockStart( struct sack_vfs_os_file* file, int blockType ) {
	FPI blockStart = sizeof( struct file_header );
	switch( blockType ) {
		//case 5:
		//	blockStart += file->header.fileData.avail; // end of file.
	case FILE_BLOCK_REFERENCED_BY:
		blockStart += file->header.indexes.avail;
	case FILE_BLOCK_INDEXES:
		blockStart += (FPI)file->header.fileData.avail;
	case FILE_BLOCK_DATA:
		blockStart += file->header.references.avail;
	case FILE_BLOCK_REFERENCES:
		blockStart += file->header.sealant.avail;
	case FILE_BLOCK_SEALANT:
		// starts at position 0.
		break;
	}
	return blockStart;
}
void WriteIntoBlock( struct sack_vfs_os_file* file, int blockType, FPI pos, CPOINTER data, FPI length ) {
	FPI blockStart = GetBlockStart( file, blockType );
	sack_vfs_os_seek_internal( file, (size_t)blockStart, SEEK_SET );
	sack_vfs_os_write_internal( file, data, (size_t)length, NULL );
}
static void _os_SetLargeBlockUsage( struct file_block_large_definition* block, uint64_t more ) {
	block->used = more;
	while( block->avail < block->used )
		block->avail = ( block->used + BLOCK_SIZE ) & BLOCK_MASK;
}
#endif
static void _os_ExtendBlockChain( struct sack_vfs_os_file* file ) {
	int newSize = ( file->blockChainAvail ) * 2 + 1;
	file->blockChain = ( struct blockInfo*)Reallocate( file->blockChain, newSize * sizeof( struct blockInfo ) );
#ifdef _DEBUG
	// debug
	memset( file->blockChain + file->blockChainAvail, 0, ( newSize - file->blockChainAvail ) * sizeof( struct blockInfo ) );
#endif
	 file->blockChainAvail = newSize;
}
static unsigned int getBlockChainBlock( struct sack_vfs_os_file* file, FPI fpi ) {
	unsigned int fileBlock = file->blockChainLength;
	int block;
	int minLen = 0;
	int maxLen = file->blockChainLength - 1;
	while( minLen <= maxLen ) {
		block = ( minLen + maxLen ) / 2;
		if( fpi >= ( file->blockChain[block].start + file->blockChain[block].size ) )
			minLen = block + 1;
		else if( fpi < file->blockChain[block].start )
			maxLen = block - 1;
		else {
			fileBlock = block;
			break;
		}
	}
	return fileBlock;
}
static void _os_SetBlockChain( struct sack_vfs_os_file* file, FPI fpi, BLOCKINDEX newBlock, int size ) {
	FPI fileBlock = file->blockChainLength;
	//lprintf( "Set chain %p %d %d %d", file, (int)fpi, (int)newBlock, (int)size );
	if( file->blockChainLength ) {
		if( fpi < ( file->blockChain[file->blockChainLength - 1].start + file->blockChain[file->blockChainLength - 1].size ) ) {
			// when seek happens and initial position is past the end,
			// seek has to step through the file, for each block to adjust size properly...
			//lprintf( "Re-setting an internal block?" );
			fileBlock = getBlockChainBlock( file, fpi );
		}
		else if( fpi == ( file->blockChain[file->blockChainLength - 1].start + file->blockChain[file->blockChainLength - 1].size ) ) {
		}
	}
#ifdef _DEBUG
	if( !newBlock ) DebugBreak();
#endif
	while( (fileBlock) >= file->blockChainAvail ) {
		_os_ExtendBlockChain( file );
	}
	if( fileBlock >= file->blockChainLength )
		file->blockChainLength = (unsigned int)(fileBlock + 1);
	//_lprintf(DBG_SRC)( "setting file at %d  to  %d to %d", (int)file->_first_block, (int)fileBlock, (int)newBlock );
	if( file->blockChain[fileBlock].block ) {
		if( file->blockChain[fileBlock].block == newBlock ) {
			return;
		}
		else {
			lprintf( "Re-setting chain to a new block... %d was %d and wants to be %d", (int)fpi, (int)file->blockChain[fileBlock].block, (int)newBlock );
			DebugBreak();
		}
	}
	file->blockChain[fileBlock].block = newBlock;
	file->blockChain[fileBlock].size = size;
	file->blockChain[fileBlock].start = fpi;
}
// seek by byte position from a starting block; as file; result with an offset into a block.
uintptr_t vfs_os_FSEEK_v2( struct sack_vfs_os_volume *vol
  // if no file, first block must be manually specified
	, struct sack_vfs_os_file *file
  // if file, firstblock comes from the file
	, BLOCKINDEX firstblock
    // offset in the block-chain from the specified start
	, FPI offset
  // this is the cache entry that the data was loaded into
	, enum block_cache_entries *cache_index
   // if a new block is needed, use this size to allocate.
	, int blockSize
 // where the new block ( if any) is updated;
	, LOGICAL flush_BAT_caches
	DBG_PASS
)
{
#ifdef DEBUG_FILE_SEEK
	LoG_( "File Seek: %p %d %d", file, (int)offset, cache_index[0] );
#endif
	enum block_cache_entries cacheRoot = cache_index[0];
	size_t priorSize;
	uint8_t *data;
	FPI pos = 0;
	if( file ) {
		unsigned chainBlock = getBlockChainBlock( file, offset );
		if( chainBlock < file->blockChainLength ) {
			firstblock = file->blockChain[chainBlock].block;
			pos = file->blockChain[chainBlock].start;
			offset -= pos;
			priorSize = file->blockChain[chainBlock].size;
		} else {
			if( file->blockChainLength ) {
				if( offset >= file->blockChain[file->blockChainLength - 1].start ) {
					firstblock = file->blockChain[file->blockChainLength - 1].block;
					offset -= ( pos = file->blockChain[file->blockChainLength - 1].start );
					priorSize = file->blockChain[file->blockChainLength - 1].size;
				}
				else {
					lprintf( "Should have found a block for this offset before here." );
					DebugBreak();
				}
			}
			else {
				firstblock = file->_first_block;
				priorSize = vol->sector_size[cache_index[0]];
				cache_index[0] = cacheRoot;
			}
		}
	} else priorSize = blockSize;
	while( firstblock != EOFBLOCK && offset >= priorSize ) {
		int size;
		enum block_cache_entries cache =
				file ?
#ifdef XX_VIRTUAL_OBJECT_STORE
			file->fileName ? BC( FILE ) :
#endif
			file->cache: cacheRoot;
#ifdef DEBUG_FILE_SEEK
		LoG_( "Getting next block after %p %d %d", file, firstblock, blockSize );
#endif
		firstblock = vfs_os_GetNextBlock_v2( vol, firstblock
			, &cache
			, file?
#ifdef XX_VIRTUAL_OBJECT_STORE
			file->fileName?GFB_INIT_NONE:
#endif
			GFB_INIT_TIMELINE_MORE:GFB_INIT_NAMES, 1, blockSize, &size, flush_BAT_caches );
		if( size != blockSize ) {
			lprintf( "Tried to allocate %d got %d at %d (from %d)", blockSize, size, *cache_index, cacheRoot );
			DebugBreak();
		}
		offset -= priorSize;
		pos += priorSize;
		priorSize = size;
		if( file ) {
			_os_SetBlockChain( file, pos, firstblock, size );
		}
	}
	data = (uint8_t*)vfs_os_BSEEK_( vol, firstblock, blockSize, cache_index DBG_RELAY );
#if DEBUG_SET_SECTOR_SIZE
	LoG_( "Sector size: %p (ss)%d (blk)%d (ofs)%d (cache)%d",data, priorSize, (int)firstblock, (int)offset , cache_index[0] );
#endif
	return (uintptr_t)(data + (offset));
}
uintptr_t vfs_os_FSEEK( struct sack_vfs_os_volume* vol
  // if no file, first block must be manually specified
	, struct sack_vfs_os_file* file
  // if file, firstblock comes from the file
	, BLOCKINDEX firstblock
    // offset in the block-chain from the specified start
	, FPI offset
  // this is the cache entry that the data was loaded into
	, enum block_cache_entries* cache_index
   // if a new block is needed, use this size to allocate.
	, int blockSize
	DBG_PASS
) {
	return vfs_os_FSEEK_v2( vol, file, firstblock, offset, cache_index, blockSize, FALSE DBG_RELAY );
}
static void vfs_os_empty_rollback( struct sack_vfs_os_volume* vol ) {
	enum block_cache_entries rollbackCache = BC( ROLLBACK );
	struct vfs_os_rollback_header* rollback = ( struct vfs_os_rollback_header* )vfs_os_FSEEK( vol, vol->journal.rollback_file, 0, 0, &rollbackCache, ROLLBACK_BLOCK_SIZE DBG_SRC );
#ifdef DEBUG_ROLLBACK_JOURNAL
	LoG( "------- ROLLBACK FLUSH---------------- %d", rollback->flags.dirty );
#endif
	if( rollback->flags.dirty ) {
		vol->journal.pdlJournaled->Cnt = 0;
		vol->journal.journalLength = 0;
		rollback->flags.dirty = 0;
		rollback->nextBlock = 0;
		rollback->nextSmallBlock = 0;
		rollback->nextEntry = 0;
		SMUDGECACHE( vol, rollbackCache );
		sack_vfs_os_flush_block( vol, rollbackCache );
	}
}
//---------------------------------------------------------------------------
static void ExpandJournalIndex(struct vfs_os_rollback_journal *journal ) {
 // sectors that are in rollback already
	BLOCKINDEX *pNewJournaled;
	//int journalLength; // how long pJournaled is used
	//int journalAvail; // max length of pJournaled
	journal->journalAvail = journal->journalAvail*2+1;
	pNewJournaled = NewArray( BLOCKINDEX,	 journal->journalAvail );
	MemCpy( pNewJournaled, journal->pJournaled, journal->journalLength * sizeof( *pNewJournaled ) );
	Release( journal->pJournaled );
	journal->pJournaled = pNewJournaled;
}
//---------------------------------------------------------------------------
static void vfs_os_record_rollback( struct sack_vfs_os_volume* vol, enum block_cache_entries entry ) {
	INDEX nextRecord = 0;
	INDEX curIdx = 0;
	BLOCKINDEX segment = vol->segment[entry];
	if( entry >= BC( ROLLBACK ) ) {
		return;
	}
	// not setup to journal yet (initial loading/configuration)
	if( !vol->journal.rollback_file ) {
		//lprintf( "Journal is not a file... bad open? Unjournaled storage?");
		//AddLink( &vol->pending_rollback, (uintptr_t)entry );
		sack_vfs_os_flush_block( vol, entry );
		return;
	}
	if( vol->journal.journalLength )
	{
		int imin = 0;
		int imax = vol->journal.journalLength-1;
		if( segment < vol->journal.pJournaled[imax] )
		{
			curIdx = imax >> 1;
			while( imin <= imax && ( curIdx <= imax ) && ( imax >= 0 ) ) {
				int d;
				//LoG( "this name: %s", names );
				if( ( d = (int)(segment - vol->journal.pJournaled[curIdx] ) ) == 0  ) {
					return;
				}
				if( d > 0 ) {
					imin = (int)curIdx + 1;
				} else {
					if( !curIdx ) break;
					imax = (int)curIdx - 1;
				}
				curIdx = (imin + imax) >> 1;
			}
		}
		else if( segment == vol->journal.pJournaled[imax] )
 // is already saved as the last.
			return;
		else
			curIdx = imax;
		if( 0 )
		{
			INDEX idx;
			BLOCKINDEX* check;
			DATA_FORALL( vol->journal.pdlJournaled, idx, BLOCKINDEX*, check ) {
				if( check[0] == segment ) {
#ifdef DEBUG_ROLLBACK_JOURNAL
					LoG( "Journal recording already has this sector marked %d %d", idx, segment );
#endif
					return;
				}
			}
		}
	}
#ifdef DEBUG_ROLLBACK_JOURNAL
	LoG( "Recording rollback for %d %d", (int)entry, (int)vol->segment[entry] );
#endif
	if( vol->journal.pdlPendingRecord->Cnt ) {
		// is already in-progress, record that this should be done later.
		AddDataItem( &vol->journal.pdlPendingRecord, &entry );
		return;
	}
	// mark in-progress.
	AddDataItem( &vol->journal.pdlPendingRecord, &entry );
	{
		if( (vol->journal.journalLength+1) >= vol->journal.journalAvail ) ExpandJournalIndex( &vol->journal );
		if( curIdx >= vol->journal.journalLength ) {
			if( curIdx && ( segment < vol->journal.pJournaled[curIdx-1] ) )  {
				vol->journal.pJournaled[curIdx] = vol->journal.pJournaled[curIdx-1];
				vol->journal.pJournaled[curIdx-1] = segment;
				vol->journal.journalLength++;
			}else {
				vol->journal.pJournaled[curIdx] = segment;
				vol->journal.journalLength++;
			}
		} else {
			if( segment < vol->journal.pJournaled[curIdx] ){
				if( curIdx ) {
					if( segment > vol->journal.pJournaled[curIdx-1] ){
						for( int n = vol->journal.journalLength; n > curIdx; n-- ) {
							vol->journal.pJournaled[n] = vol->journal.pJournaled[n-1];
						}
					}
					else lprintf( "segment is bad" );
				}else {
					for( int n = vol->journal.journalLength; n > curIdx; n-- ) {
						vol->journal.pJournaled[n] = vol->journal.pJournaled[n-1];
					}
				}
			}
			else if( segment > vol->journal.pJournaled[curIdx] ){
				if( curIdx + 1 >= vol->journal.journalLength ) {
					curIdx = curIdx+1;
				} else {
					while( segment > vol->journal.pJournaled[curIdx] ) curIdx++;
					for( int n = vol->journal.journalLength; n > (curIdx); n-- ) {
						vol->journal.pJournaled[n] = vol->journal.pJournaled[n-1];
					}
				}
			}
			vol->journal.pJournaled[curIdx] = segment;
			vol->journal.journalLength++;
		}
	}
	//AddDataItem( &vol->journal.pdlJournaled, &segment );
	enum block_cache_entries rollbackCache = BC( ROLLBACK );
	struct vfs_os_rollback_header* rollback = ( struct vfs_os_rollback_header* )vfs_os_FSEEK( vol, vol->journal.rollback_file, 0, 0, &rollbackCache, ROLLBACK_BLOCK_SIZE DBG_SRC );
 // don't journal recovery.
	if( rollback->flags.processing ) return;
	rollback->flags.dirty = 1;
	do {
		enum block_cache_entries rollbackCacheJournal;
		enum block_cache_entries rollbackEntryCache ;
// = vfs_os_FSEEK( vol, vol->journal.rollback_file, 0, 0, &rollbackCache, ROLLBACK_BLOCK_SIZE DBG_SRC );
		struct vfs_os_rollback_entry* rollbackEntry;
		POINTER journal;
		rollbackEntryCache = BC( ROLLBACK );
#ifdef DEBUG_ROLLBACK_JOURNAL
		LoG( "Record to journal: e: %d fpi:%x seg:%d  ne: %d  at %d", entry, (int)vol->bufferFPI[entry], (int)vol->segment[entry], rollback->nextEntry, sane_offsetof( struct vfs_os_rollback_header, entries[rollback->nextEntry]) );
#endif
		rollbackEntry = (struct vfs_os_rollback_entry*)vfs_os_FSEEK_v2( vol, vol->journal.rollback_file, 0
			, sane_offsetof( struct vfs_os_rollback_header, entries[rollback->nextEntry++] )
			, &rollbackEntryCache, ROLLBACK_BLOCK_SIZE, FALSE DBG_SRC );
		rollbackEntry->fileBlock = vol->segment[entry];
		rollbackCacheJournal = BC( ROLLBACK );
		if( vol->sector_size[entry] == BLOCK_SIZE ) {
			int n;
			uint64_t* p = (uint64_t*)vol->usekey_buffer_clean[entry];
			rollbackEntry->flags.zero = 0;
			rollbackEntry->flags.small = 0;
			for( n = 0; !p[0] && (n < (BLOCK_SIZE / sizeof( uint64_t ))); n++, p++ ) ;
			if( n < BLOCK_SIZE / sizeof( uint64_t ) ) {
#ifdef DEBUG_ROLLBACK_JOURNAL
				LoG( "Found non 0 at: %d  %d", n, p[0] );
				LoG( "Saving large, clean block" );
#endif
				journal = (POINTER)vfs_os_FSEEK_v2( vol, vol->journal.rollback_journal_file, 0, vol->sector_size[entry] * rollback->nextBlock++, &rollbackCacheJournal, vol->sector_size[entry], TRUE DBG_SRC );
			}  else {
#ifdef DEBUG_ROLLBACK_JOURNAL
				LoG( "Save as large zero" );
#endif
				rollbackEntry->flags.zero = 1;
			}
		} else {
			int n;
			uint64_t* p = (uint64_t*)vol->usekey_buffer_clean[entry];
			rollbackEntry->flags.zero = 0;
			rollbackEntry->flags.small = 1;
			for( n = 0; !p[0] && n < BLOCK_SMALL_SIZE / sizeof( uint64_t ); n++, p++ ) ;
			if( n < BLOCK_SMALL_SIZE / sizeof( uint64_t ) ) {
#ifdef DEBUG_ROLLBACK_JOURNAL
				LoG( "Found non 0 at: %d  %d", n, p[0] );
				LoG( "Saving small, clean block" );
#endif
				journal = (POINTER)vfs_os_FSEEK_v2( vol, vol->journal.rollback_small_journal_file, 0, vol->sector_size[entry] * rollback->nextSmallBlock++, &rollbackCacheJournal, vol->sector_size[entry], TRUE DBG_SRC );
			} else {
#ifdef DEBUG_ROLLBACK_JOURNAL
				LoG( "Save as small zero" );
#endif
				rollbackEntry->flags.zero = 1;
			}
		}
		if( !rollbackEntry->flags.zero ) {
			memcpy( journal, vol->usekey_buffer_clean[entry], vol->sector_size[entry] );
			SMUDGECACHE( vol, rollbackCacheJournal );
			sack_vfs_os_flush_block( vol, rollbackCacheJournal );
		}
		if( rollbackEntryCache != rollbackCache ) {
			SMUDGECACHE( vol, rollbackEntryCache );
			sack_vfs_os_flush_block( vol, rollbackEntryCache );
		}
		if( ++nextRecord < vol->journal.pdlPendingRecord->Cnt )
			entry = ( ( enum block_cache_entries* )GetDataItem( &vol->journal.pdlPendingRecord, nextRecord ) )[0];
		else {
 // empty the list.
			vol->journal.pdlPendingRecord->Cnt = 0;
			//vol->journal.pdlJournaled->Cnt = 0; // empty the list.
		}
	} while( vol->journal.pdlPendingRecord->Cnt );
	{
		int n;
		BLOCKINDEX prior = vol->journal.pJournaled[0];
		for( n = 1; n < vol->journal.journalLength; n++ ) {
			if( vol->journal.pJournaled[n] < prior ) DebugBreak();
			prior = vol->journal.pJournaled[n];
		}
	}
	SMUDGECACHE( vol, rollbackCache );
	sack_vfs_os_flush_block( vol, rollbackCache );
}
// reads the rollback journal and reverts anything.
static void vfs_os_process_rollback( struct sack_vfs_os_volume* vol ) {
	enum block_cache_entries rollbackCache = BC( ROLLBACK );
	enum block_cache_entries rollbackCacheJournal;
	enum block_cache_entries rollbackEntryCache;
	enum block_cache_entries rollbackEntryCache_ = BC( ZERO );
	enum block_cache_entries entry;
	struct vfs_os_rollback_header* rollback = ( struct vfs_os_rollback_header* )vfs_os_FSEEK( vol, vol->journal.rollback_file, 0, 0, &rollbackCache, ROLLBACK_BLOCK_SIZE DBG_SRC );
// = vfs_os_FSEEK( vol, vol->journal.rollback_file, 0, 0, &rollbackCache, ROLLBACK_BLOCK_SIZE DBG_SRC );
	struct vfs_os_rollback_entry* rollbackEntry;
	POINTER journal;
	SETMASK_( vol->seglock, seglock, rollbackCache, GETMASK_( vol->seglock, seglock, rollbackCache )+1 );
	BLOCKINDEX e;
#ifdef DEBUG_ROLLBACK_JOURNAL
	LoG( "---- READ ROLLBACK ---- %d", rollback->flags.dirty );
#endif
	if( rollback->flags.dirty ) {
		BLOCKINDEX bigSector = 0;
		BLOCKINDEX smallSector = 0;
		struct BATInfo {
			struct vfs_os_rollback_entry entry;
			BLOCKINDEX bigSector;
		};
		PDATALIST pdlBATs = CreateDataList( sizeof( struct BATInfo ) );
		rollback->flags.processing = 1;
		for( e = 0; e < rollback->nextEntry; e++ ) {
			rollbackEntryCache = BC( ROLLBACK );
			rollbackEntry = ( struct vfs_os_rollback_entry* )vfs_os_FSEEK( vol, vol->journal.rollback_file, 0
				, sane_offsetof( struct vfs_os_rollback_header, entries[e] )
				, &rollbackEntryCache, ROLLBACK_BLOCK_SIZE DBG_SRC );
			if( rollbackEntryCache != rollbackEntryCache_ ) {
				if( rollbackEntryCache_ ) {
					// unlock the previous (if there was one)
					SETMASK_( vol->seglock, seglock, rollbackEntryCache_, GETMASK_( vol->seglock, seglock, rollbackEntryCache_ ) - 1 );
				}
				// lock the new one
				SETMASK_( vol->seglock, seglock, rollbackEntryCache, GETMASK_( vol->seglock, seglock, rollbackEntryCache ) + 1 );
				rollbackEntryCache_ = rollbackEntryCache;
			}
			if( ( ( rollbackEntry->fileBlock - 1 ) % BLOCKS_PER_SECTOR ) == 0 ) {
				// defer restoring BAT blocks until end;
				// the journal itself may exist in the dirty blocks already in the image.
				struct BATInfo info;
				info.entry = rollbackEntry[0];
				info.bigSector = bigSector++;
				AddDataItem( &pdlBATs, &info );
				continue;
			}
#ifdef DEBUG_ROLLBACK_JOURNAL
			LoG( "Reading rollback fileblock:%d %s", rollbackEntry->fileBlock, rollbackEntry->flags.zero ? "Empty" : "" );
#endif
			entry = BC( ROLLBACK );
			_os_UpdateSegmentKey_( vol, &entry, rollbackEntry->fileBlock DBG_SRC );
			vol->sector_size[entry] = rollbackEntry->flags.small ? BLOCK_SMALL_SIZE : BLOCK_SIZE;
			if( rollbackEntry->flags.zero ) {
				memset( vol->usekey_buffer[entry], 0, rollbackEntry->flags.small ? BLOCK_SMALL_SIZE : BLOCK_SIZE );
			}
			else {
				int useSize;
				rollbackCacheJournal = BC( ROLLBACK );
				if( !rollbackEntry->flags.small ) {
					journal = (POINTER)vfs_os_FSEEK( vol, vol->journal.rollback_journal_file, 0
						, BLOCK_SIZE * bigSector++, &rollbackCacheJournal, BLOCK_SIZE DBG_SRC );
#ifdef DEBUG_ROLLBACK_JOURNAL
					if( memcmp( vol->usekey_buffer[entry], journal, BLOCK_SIZE ) == 1 ) {
						LoG( "Journal is actually updating data..." );
					}
#endif
					memcpy( vol->usekey_buffer[entry], journal, useSize = BLOCK_SIZE );
				}
				else {
					journal = (POINTER)vfs_os_FSEEK( vol, vol->journal.rollback_small_journal_file, 0
						, BLOCK_SMALL_SIZE * smallSector++, &rollbackCacheJournal, BLOCK_SMALL_SIZE DBG_SRC );
#ifdef DEBUG_ROLLBACK_JOURNAL
					if( memcmp( vol->usekey_buffer[entry], journal, BLOCK_SMALL_SIZE ) == 1 ) {
						LoG( "Journal is actually updating data..." );
					}
#endif
					memcpy( vol->usekey_buffer[entry], journal, useSize = BLOCK_SMALL_SIZE );
				}
				{
					int seg;
					for( seg = 0; seg < BC( ROLLBACK ); seg++ ) {
						if( vol->segment[seg] == rollbackEntry->fileBlock ) {
							//lprintf( "Duplicate! %d", vol->segment[seg] );
							memcpy( vol->usekey_buffer[seg], vol->usekey_buffer[entry], useSize );
							memcpy( vol->usekey_buffer_clean[seg], vol->usekey_buffer[entry], useSize );
						}
					}
				}
			}
			SMUDGECACHE( vol, entry );
		}
		// finally, clear the BAT entries with any existing bat sectors
		{
			struct BATInfo *info;
			DATA_FORALL( pdlBATs, e, struct BATInfo*, info ) {
				entry = BC( ROLLBACK );
				_os_UpdateSegmentKey_( vol, &entry, info->entry.fileBlock DBG_SRC );
				// BATs are always not-small blocks.
				vol->sector_size[entry] = BLOCK_SIZE;
				if( info->entry.flags.zero ) {
					// might happen later; usually these are non-zero filled
					memset( vol->usekey_buffer[entry], 0, BLOCK_SIZE );
				}
				else {
					rollbackCacheJournal = BC( ROLLBACK );
					journal = (POINTER)vfs_os_FSEEK( vol, vol->journal.rollback_journal_file, 0
						, BLOCK_SIZE * info->bigSector++, &rollbackCacheJournal, BLOCK_SIZE DBG_SRC );
					memcpy( vol->usekey_buffer[entry], journal, BLOCK_SIZE );
					memcpy( vol->usekey_buffer_clean[entry], journal, BLOCK_SIZE );
				}
				{
					int seg;
					for( seg = 0; seg < BC( ROLLBACK ); seg++ ) {
						if( vol->segment[seg] == info->entry.fileBlock ) {
							//lprintf( "Duplicate! %d", vol->segment[seg] );
							memcpy( vol->usekey_buffer[seg], vol->usekey_buffer[entry], BLOCK_SIZE );
							memcpy( vol->usekey_buffer_clean[seg], vol->usekey_buffer[entry], BLOCK_SIZE );
						}
					}
				}
			}
			DeleteDataList( &pdlBATs );
		}
		rollback->flags.dirty = 0;
		rollback->nextEntry = 0;
		rollback->nextBlock = 0;
		rollback->nextSmallBlock = 0;
		SETMASK_( vol->seglock, seglock, rollbackEntryCache_, GETMASK_( vol->seglock, seglock, rollbackEntryCache_ ) - 1 );
		//SETMASK_( vol->seglock, seglock, rollbackCacheJournal, GETMASK_( vol->seglock, seglock, rollbackCacheJournal ) - 1 );
		SETMASK_( vol->seglock, seglock, rollbackCache, GETMASK_( vol->seglock, seglock, rollbackCache ) - 1 );
		SMUDGECACHE( vol, rollbackCache );
		rollback->flags.processing = 0;
		// after processing, the disk should be back to 0; so don't rollback NEXT reload again.
		sack_vfs_os_flush_block( vol, rollbackCache );
	}
}
void vfs_os_smudge_cache( struct sack_vfs_os_volume* vol, enum block_cache_entries n ) {
	if( !TESTFLAG( vol->dirty, n ) ) {
#ifdef DEBUG_SECTOR_DIRT
		lprintf( "set dirty on %d", n);
#endif
		SETFLAG( vol->dirty, n );
		if( !TESTFLAG( vol->_dirty, n ) )
			vfs_os_record_rollback( vol, n );
	}
}
// pass absolute, 0 based, block number that is the index of the block in the filesystem.
static FPI vfs_os_compute_block( struct sack_vfs_os_volume *vol, BLOCKINDEX block, enum block_cache_entries cache ) {
	struct sack_vfs_os_BAT_info *info;
	INDEX idx = block / BLOCKS_PER_SECTOR;
	info = (struct sack_vfs_os_BAT_info*)GetDataItem( &vol->pdl_BAT_information, idx );
	if( !info ) {
		if( !block ) return 0;
		else {
			info = (struct sack_vfs_os_BAT_info*)GetDataItem( &vol->pdl_BAT_information, idx-1 );
			if( info )
				return info->sectorEnd;
		}
		return ~0;
	}
	{
 // not reading a BAT, add the fixed offset, 0 based data offset
		if( block % BLOCKS_PER_SECTOR ) {
			//if( cache < BC(COUNT) )
#if defined( DEBUG_SET_SECTOR_SIZE )
			LoG( "Setting sector size according to BAT information:%d %d %d %d", info->size, (int)block, (cache<BC(COUNT))?(int)vol->segment[cache]:0, (int)cache );
#endif
//lprintf( "CACHE OVERFLOW not setting info %d", info->size );
			if( cache >= BC(COUNT) ) ;
			else vol->sector_size[cache] = info->size;
			// the first 'block' is always bat size, so add that, and then the remaining
			// smaller blocks...
			return info->sectorStart + BAT_BLOCK_SIZE + ( ( block % BLOCKS_PER_SECTOR ) - 1 ) * info->size;
		} else {
//lprintf( "CACHE OVERFLOW skipping size(BAT)" );
			if( cache >= BC(COUNT) ) ;
			else vol->sector_size[cache] = BAT_BLOCK_SIZE;
			return info->sectorStart;
		}
	}
	return 0;
}
// pass absolute, 0 based, block number that is the index of the block in the filesystem.
static FPI vfs_os_compute_data_block( struct sack_vfs_os_volume* vol, BLOCKINDEX block, enum block_cache_entries cache ) {
	struct sack_vfs_os_BAT_info* info;
	INDEX idx = block / BLOCKS_PER_BAT;
	info = ( struct sack_vfs_os_BAT_info* )GetDataItem( &vol->pdl_BAT_information, idx );
	if( !info ) return 0;
	// not reading a BAT, add the fixed offset, 0 based data offset
	if( cache < BC( COUNT ) )
		vol->sector_size[cache] = info->size;
	// the first 'block' is always bat size, so add that, and then the remaining
	// smaller blocks...
	return info->sectorStart + BAT_BLOCK_SIZE + ( ( block - 1 ) % BLOCKS_PER_BAT ) * info->size;
}
#define tolower_(c) (c)
static int  _os_PathCaseCmpEx ( CTEXTSTR s1, CTEXTSTR s2, size_t maxlen )
{
	if( !s1 )
		if( s2 )
			return -1;
		else
			return 0;
	else
		if( !s2 )
			return 1;
	if( s1 == s2 )
 // ==0 is success.
		return 0;
	for( ;s1[0] && ((unsigned char)s2[0] != UTF8_EOT) && (s1[0] == s2[0]) && maxlen;
		  s1++, s2++, maxlen-- );
	if( maxlen )
		return s1[0] - (((unsigned char)s2[0] == UTF8_EOT)?0:s2[0]);
	return 0;
}
// read the byte from namespace at offset; decrypt byte in-register
// compare against the filename bytes.
static int _os_MaskStrCmp( struct sack_vfs_os_volume *vol, CTEXTSTR filename, BLOCKINDEX nameBlock, FPI name_offset, int path_match ) {
	enum block_cache_entries cache = BC(NAMES);
	const char *dirname = (const char*)vfs_os_FSEEK( vol, NULL, nameBlock, name_offset, &cache, NAME_BLOCK_SIZE DBG_SRC );
	//const char *prior_dirname = dirname;
	if( !dirname ) return 1;
	{
		//LoG( "doesn't volume always have a key?" );
		if( path_match ) {
			size_t l;
			int r = _os_PathCaseCmpEx( filename, dirname, l = strlen( filename ) );
			if( !r )
				if( (dirname)[l] == '/' || (dirname)[l] == '\\' )
					return 0;
				else
					return 1;
			return r;
		}
		else
			return _os_PathCaseCmpEx( filename, dirname, strlen(filename) );
	}
}
#ifdef DEBUG_TRACE_LOG
static void _os_MaskStrCpy( char *output, size_t outlen, struct sack_vfs_os_volume *vol, enum block_cache_entries cache, FPI name_offset ) {
	{
		int c;
		FPI name_start = name_offset;
		while( UTF8_EOT != (unsigned char)( c = vol->usekey_buffer[cache][name_offset&BLOCK_MASK] ) ) {
			if( ( name_offset - name_start ) < outlen )
				output[name_offset-name_start] = c;
			name_offset++;
		}
		if( ( name_offset - name_start ) < outlen )
			output[name_offset-name_start] = 0;
		else
			output[outlen-1] = 0;
	}
}
#endif
#ifdef DEBUG_DIRECTORIES
int _os_dumpDirectories( struct sack_vfs_os_volume *vol, BLOCKINDEX start, LOGICAL init ) {
	struct directory_hash_lookup_block *dirBlock;
	struct directory_entry *next_entries;
	static char leadin[MAX_FILENAME_LEN];
	static int leadinDepth;
	char outfilename[MAX_FILENAME_LEN];
	int outfilenamelen;
	size_t n;
	if( init )
		leadinDepth = 0;
	LoG( "Starting directory dump: %d %d", start, init );
	{
		enum block_cache_entries cache = BC( DIRECTORY );
		enum block_cache_entries name_cache = BC( NAMES );
		struct directory_hash_lookup_block _dirBlock;
		dirBlock = BTSEEK( struct directory_hash_lookup_block *, vol, start, DIR_BLOCK_SIZE, cache );
		_dirBlock = dirBlock[0];
		dirBlock = &_dirBlock;
		lprintf( "leadin : %*.*s %d names:%d start:%d", leadinDepth, leadinDepth, leadin, leadinDepth, dirBlock->used_names, (int)start );
		next_entries = dirBlock->entries;
		for( n = 0; n < dirBlock->used_names; n++ ) {
			FPI name_ofs = next_entries[n].name_offset & DIRENT_NAME_OFFSET_OFFSET;
			const char *filename;
			int l;
			// if file is deleted; don't check it's name.
			if( (name_ofs) > vol->dwSize ) {
				LoG( "corrupted volume." );
				return 0;
			}
			name_cache = BC( NAMES );
			filename = (const char *)vfs_os_FSEEK( vol, NULL, dirBlock->names_first_block, name_ofs, &name_cache, NAME_BLOCK_SIZE DBG_SRC );
			if( !filename ) return 0;
			outfilenamelen = 0;
			for( l = 0; l < leadinDepth; l++ ) outfilename[outfilenamelen++] = leadin[l];
			if( vol->key ) {
				int c;
				while( (c = (((uint8_t*)filename)[0] )) != UTF8_EOT ) {
					if( c == UTF8_EOTB ) break;
					outfilename[outfilenamelen++] = c;
					//filename++;
					name_ofs++;
					name_cache = BC( NAMES );
					filename = (const char *)vfs_os_FSEEK( vol, NULL, dirBlock->names_first_block, name_ofs, &name_cache, NAME_BLOCK_SIZE DBG_SRC );
				}
			}
			else {
				int c;
				while( (c = (((uint8_t*)filename)[0] )) != UTF8_EOT ) {
					if( c == UTF8_EOTB ) break;
					outfilename[outfilenamelen++] = c;
					//filename++;
					name_ofs++;
					name_cache = BC( NAMES );
					filename = (const char *)vfs_os_FSEEK( vol, NULL, dirBlock->names_first_block, name_ofs, &name_cache, NAME_BLOCK_SIZE DBG_SRC );
				}
			}
			lprintf( "%3d filename: %5d %.*s", n, next_entries[n].name_offset & DIRENT_NAME_OFFSET_OFFSET, outfilenamelen, outfilename );
			if( outfilenamelen > 44 ) DebugBreak();
		}
		for( n = 0; n < 255; n++ ) {
			BLOCKINDEX block = dirBlock->next_block[n];
			if( block ) {
				lprintf( "Found directory with char '%c' %d", n, block );
				leadin[leadinDepth] = (char)n;
				leadinDepth = leadinDepth + 1;
#ifdef DEBUG_DIRECTORIES
				_os_dumpDirectories( vol, block, 0 );
#endif
				leadinDepth = leadinDepth - 1;
			}
		}
	};
	return 0;
}
#endif
#ifdef _MSC_VER
// this is about nLeast not being initialized.
// it will be set if it's used, if it's not
// initialized, it won't be used.
#pragma warning( disable: 6001 )
#endif
#define _os_updateCacheAge(v,c,s,a,l) _os_updateCacheAge_(v,c,s,a,l DBG_SRC )
//
// THis is assigning segment into a cache entry, and then reading that data into memory.
// Large block filebuffers (? like 64 megs of empty space?)
// where the block is located determines the size of that block; this updates
// the size
static void _os_updateCacheAge_( struct sack_vfs_os_volume *vol, enum block_cache_entries *cache_idx, BLOCKINDEX segment, uint8_t *age, int ageLength DBG_PASS ) {
	int n, m;
	int least;
	int nLeast = -1;
	enum block_cache_entries cacheRoot = cache_idx[0];
	BLOCKINDEX *test_segment = vol->segment + cacheRoot;
	least = ageLength + 1;
#ifdef DEBUG_CACHE_FAULTS
	switch( cacheRoot ) {
	case BC(TIMELINE):
		vol->cacheRequests[0]++;
		break;
	case BC( DIRECTORY ):
		vol->cacheRequests[1]++;
		break;
	}
#endif
	for( n = 0; n < (ageLength); n++,test_segment++ ) {
		if( test_segment[0] == segment ) {
			//if( pFile ) LoG_( "Cache found existing segment already. %d at %d(%d)", (int)segment, (cache_idx[0]+n), (int)n );
#ifdef DEBUG_VALIDATE_TREE
			//if( cache_idx[0] < BC( TIMELINE_RO ) )
			//	_lprintf( DBG_RELAY )( "FOUND segment in cache: %d   %d  %d   %d", segment, n, age[n], cache_idx[0] );
#endif
			cache_idx[0] = (enum block_cache_entries)((cache_idx[0]) + n);
			for( m = 0; m < (ageLength); m++ ) {
				if( !age[m] ) break;
				if( age[m] > age[n] ) {
					age[m]--;
				}
			}
			age[n] = m;
			return;
			//break;
		}
 // end of list, empty entry.
		if( !age[n] ) {
			//LoG_( "Cache found unused segment already. %d at %d(%d)", (int)segment, (cache_idx[0] + n), (int)n );
			cache_idx[0] = (enum block_cache_entries)((cache_idx[0]) + n);
 // age entries up to this one.
			for( m = 0; m < (ageLength); m++ ) {
				if( !age[m] ) break;
				if( age[m] > ( n + 1 ) )
					age[m]--;
			}
			vol->segment[cache_idx[0]] = segment;
 // make this one newest
			age[n] = n + 1;
			break;
		}
		if( (age[n] < least) && !GETMASK_( vol->seglock, seglock, cache_idx[0] + n ) ) {
			least = age[n];
 // this one will be oldest, unlocked candidate
			nLeast = n;
		}
	}
	if( ( n == ( ageLength ) ) && ( nLeast < 0 ) ) {
		lprintf( "All cache blocks are locked, unable to find a free, old block." );
		DebugBreak();
	}
	if( n == (ageLength) ) {
		int useCache = cacheRoot + nLeast;
#ifdef _DEBUG
		if( least > ageLength ) DebugBreak();
#endif
  // age evernthing.
		for( n = 0; n < (ageLength); n++ ) {
			if( age[n] > least )
				age[n]--;
		}
		cache_idx[0] = (enum block_cache_entries)useCache;
 // make this one the newest, and return it.
		age[nLeast] = (ageLength);
		//_lprintf(DBG_RELAY)( "reclaim %d for seg %d", useCache, segment );
		if( TESTFLAG( vol->dirty, useCache ) || TESTFLAG( vol->_dirty, useCache ) ) {
#ifdef DEBUG_DISK_IO
			LoG_( "MUST CLAIM SEGMENT Flush dirty segment: %d fpi:%x %d cache:%d", nLeast, vol->bufferFPI[useCache], vol->segment[useCache], useCache );
#  ifdef DEBUG_DISK_DATA
			LogBinary( vol->usekey_buffer[useCache], vol->sector_size[useCache] );
#  endif
#endif
			sack_fseek( vol->file, (size_t)vol->bufferFPI[useCache], SEEK_SET );
			if( vol->key ) {
				uint8_t* crypt;
				size_t cryptlen;
				SRG_XSWS_encryptData( vol->usekey_buffer[useCache], vol->sector_size[useCache]
					, vol->segment[useCache], (const uint8_t*)vol->key, 1024
					, &crypt, &cryptlen );
				if( !vol->flags.halted )
					sack_fwrite( crypt, 1, vol->sector_size[useCache], vol->file );
				Deallocate( uint8_t*, crypt );
			}else {
				if( !vol->flags.halted )
					sack_fwrite( vol->usekey_buffer[useCache], 1, vol->sector_size[useCache], vol->file );
			}
#ifdef DEBUG_CACHE_FLUSH
			// if not dirty, then clean and buffer have to match; and this is clearing the dirty flag
			memcpy( vol->usekey_buffer_clean[useCache], vol->usekey_buffer[useCache], BLOCK_SIZE );
#  ifdef DEBUG_VALIDATE_TREE
 // timeline cache is noisy for readonly
			if( useCache < BC( TIMELINE_RO ) )
#  endif
				_lprintf(DBG_RELAY)( "(usedto)Updated clean buffer %d", useCache );
#endif
			CLEANCACHE( vol, useCache );
			RESETFLAG( vol->_dirty, useCache );
		}
#ifdef DEBUG_VALIDATE_TREE
		else {
#ifdef DEBUG_CACHE_FLUSH
#  ifdef DEBUG_VALIDATE_TREE
			if( cache_idx[0] < BC(TIMELINE_RO) )
#  endif
				if( memcmp( vol->usekey_buffer_clean[cache_idx[0]], vol->usekey_buffer[cache_idx[0]], BLOCK_SIZE ) ) {
					lprintf( "Block was written to, but was not flagged as dirty, changes will be lost." );
					DebugBreak();
				}
#endif
		}
#endif
		vol->segment[useCache] = segment;
	}
#ifdef DEBUG_VALIDATE_TREE
	//if( cache_idx[0] < BC(TIMELINE_RO) )
	//	_lprintf(DBG_RELAY)( "Get segment into cache: %d   %d", segment, cache_idx[0] );
#endif
#ifdef DEBUG_CACHE_FAULTS
	switch( cacheRoot ) {
	case BC( TIMELINE ):
		vol->cacheFaults[0]++;
		break;
	case BC( DIRECTORY ):
		vol->cacheFaults[1]++;
		break;
	}
#endif
	{
		size_t short_Read;
		do {
			vol->bufferFPI[cache_idx[0]] = vfs_os_compute_block( vol, segment - 1, cache_idx[0] );
			if( vol->bufferFPI[cache_idx[0]] == ~0 )
				_os_ExpandVolume( vol, vol->lastBlock, vol->sector_size[cache_idx[0]] );
		} while( vol->bufferFPI[cache_idx[0]] == ~0 );
		// read new buffer for new segment
		sack_fseek( vol->file, (size_t)vol->bufferFPI[cache_idx[0]], SEEK_SET );
#ifdef DEBUG_DISK_IO
		LoG_( "Read into block: fpi:%x cache:%d n:%d  seg:%d buf:%p size:%d", (int)vol->bufferFPI[cache_idx[0]], (int)cache_idx[0] , (int)n, (int)segment, vol->usekey_buffer[cache_idx[0]], vol->sector_size[cache_idx[0]]  );
#endif
		if( !( short_Read = sack_fread( vol->usekey_buffer[cache_idx[0]], 1, vol->sector_size[cache_idx[0]], vol->file ) ) ) {
			memset( vol->usekey_buffer[cache_idx[0]], 0, vol->sector_size[cache_idx[0]] );
			// only need to clear this if it's checked for write data without setting dirty flag.
			memset( vol->usekey_buffer_clean[cache_idx[0]], 0, vol->sector_size[cache_idx[0]] );
		} else {
			if( short_Read != vol->sector_size[cache_idx[0]] ) {
				lprintf( "Short read on file:%" _size_f, short_Read );
			}
			if( vol->key )
				SRG_XSWS_decryptData( vol->usekey_buffer[cache_idx[0]], vol->sector_size[cache_idx[0]]
					, vol->segment[cache_idx[0]], (const uint8_t*)vol->oldkey?vol->oldkey:vol->key, 1024
					, NULL, NULL );
			// after reading what was on the disk (in the sector), save it as the 'clean' state for journaling
			// modifications happen to usekey_buffer before SMUDGE is called.
			memcpy( vol->usekey_buffer_clean[cache_idx[0]], vol->usekey_buffer[cache_idx[0]], vol->sector_size[cache_idx[0]] );
#ifdef DEBUG_CACHE_FLUSH
#  ifdef DEBUG_VALIDATE_TREE
			if( cache_idx[0] < BC(TIMELINE_RO) )
#  endif
				_lprintf(DBG_RELAY)( "Updated clean buffer %d", cache_idx[0] );
#endif
		}
#ifdef DEBUG_DISK_IO
#  ifdef DEBUG_DISK_DATA
		LogBinary( vol->usekey_buffer[cache_idx[0]], vol->sector_size[cache_idx[0]] );
#  endif
#endif
	}
#ifdef DEBUG_CACHE_AGING
	LoG( "age end2:" );
	LogBinary( age, ageLength );
#endif
}
#define _os_UpdateSegmentKey(v,c,s) _os_UpdateSegmentKey_(v,c,s DBG_SRC )
enum block_cache_entries _os_UpdateSegmentKey_( struct sack_vfs_os_volume *vol, enum block_cache_entries* cache_idx, BLOCKINDEX segment DBG_PASS )
{
	//BLOCKINDEX oldSegs[BC(COUNT)];
	//memcpy(oldSegs, vol->segment, sizeof(oldSegs));
	if( cache_idx[0] == BC(FILE) ) {
		_os_updateCacheAge_( vol, cache_idx, segment, vol->fileCacheAge, (BC(FILE_LAST) - BC(FILE)) DBG_RELAY );
	}
	else if( cache_idx[0] == BC(NAMES) ) {
		_os_updateCacheAge_( vol, cache_idx, segment, vol->nameCacheAge, (BC(NAMES_LAST) - BC(NAMES)) DBG_RELAY );
	}
#ifdef VIRTUAL_OBJECT_STORE
	else if( cache_idx[0] == BC(DIRECTORY) ) {
		_os_updateCacheAge_( vol, cache_idx, segment, vol->dirHashCacheAge, (BC(DIRECTORY_LAST) - BC(DIRECTORY)) DBG_RELAY );
	}
	else if( cache_idx[0] == BC( TIMELINE ) ) {
		_os_updateCacheAge_( vol, cache_idx, segment, vol->timelineCacheAge, (BC( TIMELINE_LAST ) - BC( TIMELINE )) DBG_RELAY );
	}
	else if( cache_idx[0] == BC( ROLLBACK ) ) {
		//lprintf( "Cache age rollback: %d", (int)segment );
		_os_updateCacheAge_( vol, cache_idx, segment, vol->rollbackCacheAge, ( BC( ROLLBACK_LAST ) - BC( ROLLBACK ) ) DBG_RELAY );
	}
#ifdef DEBUG_VALIDATE_TREE
	else if( cache_idx[0] == BC( TIMELINE_RO ) ) {
		_os_updateCacheAge_( vol, cache_idx, segment, vol->timelineCacheAge, ( BC( TIMELINE_RO_LAST ) - BC( TIMELINE_RO ) ) DBG_RELAY );
		{
			int n;
			for( n = BC( TIMELINE ); n < BC( TIMELINE_LAST ); n++ ) {
				if( vol->segment[n] == segment ) {
					if( TESTFLAG( vol->dirty, n ) || TESTFLAG( vol->_dirty, n ) ) {
						// use the cached value instead of the disk value.
						memcpy( vol->usekey_buffer[cache_idx[0]], vol->usekey_buffer[n], BLOCK_SIZE );
						memcpy( vol->usekey_buffer_clean[cache_idx[0]], vol->usekey_buffer[n], BLOCK_SIZE );
						//lprintf( "Updaed clean buffer %d", n );
					}
					break;
				}
			}
		}
	}
#endif
	else if( cache_idx[0] == BC( BAT ) ) {
		_os_updateCacheAge_( vol, cache_idx, segment, vol->batHashCacheAge, (BC(BAT_LAST) - BC(BAT)) DBG_RELAY );
	}
#endif
	else {
		if( vol->segment[cache_idx[0]] != segment ) {
			if( TESTFLAG( vol->dirty, cache_idx[0] ) || TESTFLAG( vol->_dirty, cache_idx[0] ) ) {
#ifdef DEBUG_DISK_IO
				LoG_( "MUST CLAIM SEGMENT Flush dirty segment: fpi:%x %d", vol->bufferFPI[cache_idx[0]], vol->segment[cache_idx[0]] );
#  ifdef DEBUG_DISK_DATA
				LogBinary( vol->usekey_buffer[cache_idx[0]], vol->sector_size[cache_idx[0]] );
#  endif
#endif
				sack_fseek( vol->file, (size_t)vol->bufferFPI[cache_idx[0]], SEEK_SET );
				if( vol->key ) {
					uint8_t* crypt;
					size_t cryptlen;
					SRG_XSWS_encryptData( vol->usekey_buffer[cache_idx[0]], vol->sector_size[cache_idx[0]]
						, vol->segment[cache_idx[0]], (const uint8_t*)vol->key, 1024
						, &crypt, &cryptlen );
					if( !vol->flags.halted )
						sack_fwrite( crypt, 1, vol->sector_size[cache_idx[0]], vol->file );
					Deallocate( uint8_t*, crypt );
				}
				else {
					if( !vol->flags.halted )
						sack_fwrite( vol->usekey_buffer[cache_idx[0]], 1, vol->sector_size[cache_idx[0]], vol->file );
				}
				CLEANCACHE( vol, cache_idx[0] );
				RESETFLAG( vol->_dirty, cache_idx[0] );
#ifdef DEBUG_DISK_IO
				LoG( "Flush dirty sector: %d", cache_idx[0], vol->bufferFPI[cache_idx[0]] );
#endif
			}
			// read new buffer for new segment
			vol->bufferFPI[cache_idx[0]] = vfs_os_compute_block( vol, segment - 1, cache_idx[0] );
			if( vol->bufferFPI[cache_idx[0]] >= vol->dwSize ) _os_ExpandVolume( vol, vol->lastBlock, vol->sector_size[cache_idx[0]] );
			sack_fseek( vol->file, (size_t)(vol->bufferFPI[cache_idx[0]]), SEEK_SET);
#ifdef DEBUG_DISK_IO
			LoG( "OS VFS read old sector: fpi:%d %d %d", (int)vol->bufferFPI[cache_idx[0]], cache_idx[0], segment );
#endif
			if( !sack_fread( vol->usekey_buffer[cache_idx[0]], 1, vol->sector_size[cache_idx[0]], vol->file ) ) {
				//lprintf( "Cleared BLock on failed read." );
				memset( vol->usekey_buffer[cache_idx[0]], 0, vol->sector_size[cache_idx[0]] );
				// only need to clear this if it's checked for write data without setting dirty flag.
				memset( vol->usekey_buffer_clean[cache_idx[0]], 0, vol->sector_size[cache_idx[0]] );
			}
			else {
				if( vol->key )
					SRG_XSWS_decryptData( vol->usekey_buffer[cache_idx[0]], vol->sector_size[cache_idx[0]]
						, vol->segment[cache_idx[0]], (const uint8_t*)vol->oldkey?vol->oldkey:vol->key, 1024
						, NULL, NULL );
				// after reading what was on the disk (in the sector), save it as the 'clean' state for journaling
				// modifications happen to usekey_buffer before SMUDGE is called.
				memcpy( vol->usekey_buffer_clean[cache_idx[0]], vol->usekey_buffer[cache_idx[0]], vol->sector_size[cache_idx[0]] );
			}
#ifdef DEBUG_DISK_IO
#  ifdef DEBUG_DISK_DATA
		LogBinary( vol->usekey_buffer[cache_idx[0]], vol->sector_size[cache_idx[0]] );
#  endif
#endif
		}
		vol->segment[cache_idx[0]] = segment;
	}
//#ifdef DEBUG_TRACE_LOG
//	if (segment != oldSegs[cache_idx])
//		_lprintf(DBG_RELAY)("UPDATE OS SEGKEY %d %d", cache_idx, segment);
//#endif
	//LoG( "Resulting stored segment in %d", cache_idx );
	//lprintf( "Got Block %d into cache %d", (int)segment, cache_idx );
	return cache_idx[0];
}
#ifdef _MSC_VER
#pragma warning( default: 6001 )
#endif
//---------------------------------------------------------------------------
struct sack_vfs_os_file * _os_createFile( struct sack_vfs_os_volume *vol, BLOCKINDEX first_block, int blockSize )
{
//New( struct sack_vfs_os_file );
	struct sack_vfs_os_file * file = GetFromSet( VFS_OS_FILE, &l.files );
	// breaks in C++
	//file[0] = ( struct sack_vfs_os_file ){ 0 };
	MemSet( file, 0, sizeof( struct sack_vfs_os_file ) );
	_os_SetBlockChain( file, 0, first_block, blockSize );
	//lprintf( "Create simple file: %d", first_block );
	file->_first_block = first_block;
	file->block = first_block;
	file->vol = vol;
	file->cache = BC( FILE );
	return file;
}
//---------------------------------------------------------------------------
uintptr_t vfs_os_block_index_SEEK( struct sack_vfs_os_volume* vol, BLOCKINDEX block, int blockSize, enum block_cache_entries* cache_index ) {
	FPI offset;
	while( ( offset = vfs_os_compute_block( vol, block, cache_index[0] ) ) >= vol->dwSize )
		if( !_os_ExpandVolume( vol, vol->lastBlock, blockSize ) ) return 0;
	{
		_os_UpdateSegmentKey( vol, cache_index, block + 1 );
		//LoG( "RETURNING SEEK CACHED %p %d  0x%x   %d", vol->usekey_buffer[cache_index[0]], cache_index[0], (int)offset, (int)seg );
		return ( (uintptr_t)vol->usekey_buffer[cache_index[0]] ) + ( offset % vol->sector_size[cache_index[0]] );
	}
}
// shared with fuse module
// seek by byte position; result with an offset into a block.
// this is used to access BAT information; and should be otherwise avoided.
uintptr_t vfs_os_SEEKX( struct sack_vfs_os_volume* vol, FPI offset, int blockSize, enum block_cache_entries* cache_index ) {
	//lprintf( "This is more complicated with variable size data blocks" );
	// unused function mostly.
	while( offset >= vol->dwSize ) if( !_os_ExpandVolume( vol, vol->lastBlock, blockSize ) ) return 0;
	// this assumes that all blocks are the same size; which is untrue.  This should be removed.
	{
		BLOCKINDEX seg = ( offset / BLOCK_SIZE ) + 1;
		_os_UpdateSegmentKey( vol, cache_index, seg );
		//LoG( "RETURNING SEEK CACHED %p %d  0x%x   %d", vol->usekey_buffer[cache_index[0]], cache_index[0], (int)offset, (int)seg );
		return ( (uintptr_t)vol->usekey_buffer[cache_index[0]] ) + ( offset & BLOCK_MASK );
	}
}
// shared with fuse module
// seek by block, outside of BAT.  block 0 = first block after first BAT.
uintptr_t vfs_os_BSEEK_( struct sack_vfs_os_volume* vol, BLOCKINDEX block, int blockSize, enum block_cache_entries* cache_index DBG_PASS ) {
	// b is the absolute block number
	if( block != DIR_ALLOCATING_MARK ) {
 /* for first BAT */
		BLOCKINDEX b = ( 1 + ( block / BLOCKS_PER_BAT ) * (BLOCKS_PER_SECTOR)+( block % BLOCKS_PER_BAT ) );
#define _os_segment_to_block( s ) ( ( (s) - 1 ) / BLOCKS_PER_SECTOR ) * BLOCKS_PER_BAT + ( ( (s) - ( 1 + (s) / BLOCKS_PER_SECTOR ) ) % BLOCKS_PER_BAT );
#if defined( DEBUG_BLOCK_COMPUTE )
		{
			//int block_ = ( ( b - 1 ) / BLOCKS_PER_SECTOR ) * BLOCKS_PER_BAT + ( ( b - ( 1 + b / BLOCKS_PER_SECTOR ) ) % BLOCKS_PER_BAT );
			int block_ = _os_segment_to_block( b );
			if( block_ != block ) {
				lprintf( "FAILED" );
				DebugBreak();
			}
		}
#endif
		// first call can skip setting information
		while( vfs_os_compute_block( vol, b, BC( COUNT ) ) >= vol->dwSize ) if( !_os_ExpandVolume( vol, vol->lastBlock, blockSize ) ) return 0;
		{
			_os_UpdateSegmentKey_( vol, cache_index, b + 1 DBG_RELAY );
			//LoG( "RETURNING BSEEK CACHED %p  %d %d %d  0x%x  %d   %d", vol->usekey_buffer[cache_index[0]], cache_index[0], (int)(block/ BLOCKS_PER_BAT), (int)(BLOCKS_PER_BAT-1), (int)b, (int)block, (int)seg );
/* + (b&BLOCK_MASK) always 0 */
			return ( (uintptr_t)vol->usekey_buffer[cache_index[0]] );
		}
	} else {
		BLOCKINDEX b = _os_GetFreeBlock( vol, cache_index, GFB_INIT_NONE, blockSize );
 /* for first BAT */
		b = ( 1 + ( b / BLOCKS_PER_BAT ) * (BLOCKS_PER_SECTOR)+( b % BLOCKS_PER_BAT ) );
		_os_UpdateSegmentKey_( vol, cache_index, b + 1 DBG_RELAY );
		// the returned block is set in the ((segment[cache_index[0]]-1)-1)
		return ( (uintptr_t)vol->usekey_buffer[cache_index[0]] );
	}
}
// shared with fuse module
// seek by block, outside of BAT.  block 0 = first block of disk.
uint8_t * vfs_os_DSEEK_( struct sack_vfs_os_volume* vol, FPI dataFPI, int blockSize, enum block_cache_entries* cache_index DBG_PASS ) {
	BLOCKINDEX block;
	struct sack_vfs_os_BAT_info* info;
	INDEX idx;
	INDEX minIndex = 0;
	INDEX maxIndex = vol->pdl_BAT_information->Cnt;
	//DATA_FORALL( vol->pdl_BAT_information, idx, struct sack_vfs_os_BAT_info *, info )
	while( minIndex <= maxIndex )
	{
		idx = ( minIndex + maxIndex ) / 2;
		info = ((struct sack_vfs_os_BAT_info*)vol->pdl_BAT_information->data) + idx;
		if( dataFPI < info->sectorStart ) { maxIndex = idx - 1; continue; }
		if( dataFPI > info->sectorEnd ) { minIndex = idx + 1; continue; }
		{
			dataFPI -= info->sectorStart;
			if( dataFPI < BAT_BLOCK_SIZE )
				block = 0;
			else
				block = 1 + ( dataFPI - BAT_BLOCK_SIZE ) / info->size;
			_os_UpdateSegmentKey( vol, cache_index, info->blockStart + block + 1 );
			return vol->usekey_buffer[cache_index[0]] + ( dataFPI & (vol->sector_size[cache_index[0]] - 1) );
		}
	}
	return 0;
}
//---------------------------------------------------------------------------
static LOGICAL _os_ValidateBAT( struct sack_vfs_os_volume *vol ) {
	//BLOCKINDEX slab = vol->dwSize / ( BLOCK_SIZE );
	BLOCKINDEX n;
	enum block_cache_entries cache = BC(BAT);
	//BLOCKINDEX sector = 0;
	{
		struct sack_vfs_os_BAT_info info;
		struct sack_vfs_os_BAT_info *priorInfo;
		FPI thisPos;
		//struct sack_vfs_os_BAT_info* oldinfo;
		vol->pdl_BAT_information->Cnt = 0;
		info.sectorEnd = BAT_BLOCK_SIZE + ( BLOCKS_PER_BAT * 4096 );
		info.sectorStart = 0;
		info.blockStart = n = 0;
		info.size = 4096;
		AddDataItem( &vol->pdl_BAT_information, &info );
		priorInfo = (struct sack_vfs_os_BAT_info*)GetDataItem( &vol->pdl_BAT_information, vol->pdl_BAT_information->Cnt-1 );
		for( n = 0; ( thisPos = info.sectorStart ) < vol->dwSize; n += BLOCKS_PER_SECTOR ) {
			BLOCKINDEX dataBlock = ( n / BLOCKS_PER_SECTOR ) * BLOCKS_PER_BAT;
			size_t m;
			BLOCKINDEX *BAT;
 // reset cache, so we get a new bat cache block
			cache = BC(BAT);
			// seek loads and updates the segment key...
			BAT = (BLOCKINDEX*)vfs_os_block_index_SEEK( vol, n, 0, &cache );
			info.size = priorInfo->size = BAT[BLOCKS_PER_BAT] ? BLOCK_SMALL_SIZE : 4096;
			{
				priorInfo->sectorEnd = thisPos + BAT_BLOCK_SIZE + ( ( ( BLOCKS_PER_BAT * info.size ) + 4095 ) & ~4095 );
				info.sectorStart = priorInfo->sectorEnd;
				info.blockStart = n + BLOCKS_PER_SECTOR;
				vol->lastBlock = n + BLOCKS_PER_SECTOR;
				AddDataItem( &vol->pdl_BAT_information, &info );
				priorInfo = (struct sack_vfs_os_BAT_info*)GetDataItem( &vol->pdl_BAT_information, vol->pdl_BAT_information->Cnt-1 );
			}
			//sector++;
			for( m = 0; m < BLOCKS_PER_BAT; m++ )
			{
				BLOCKINDEX block = BAT[0];
				BAT++;
				if( block == EOFBLOCK ) continue;
				if( block == EOBBLOCK ) {
					if( info.size == 4096 )
						vol->lastBatBlock = dataBlock + m;
					else
						vol->lastBatSmallBlock = dataBlock + m;
					break;
				}
				//if( block >= last_block ) return FALSE;
				if( block == 0 ) {
					if( info.size == 4096 ) {
 // use as a temp variable....
						vol->lastBatBlock = dataBlock + m;
						LoG( "Marking free (lg)blank sector %d", vol->lastBatBlock );
						AddDataItem( &vol->pdlFreeBlocks, &vol->lastBatBlock );
					}
					else {
 // use as a temp variable....
						vol->lastBatSmallBlock = dataBlock + m;
						LoG( "Marking free (sm)blank sector %d", vol->lastBatBlock );
						AddDataItem( &vol->pdlFreeSmallBlocks, &vol->lastBatSmallBlock );
					}
				}
			}
			//if( m < BLOCKS_PER_BAT ) break;
		}
		// this ends up pusing 1 more so that compute can actually work on reload
		vol->pdl_BAT_information->Cnt--;
		priorInfo = (struct sack_vfs_os_BAT_info*)GetDataItem( &vol->pdl_BAT_information, vol->pdl_BAT_information->Cnt-1 );
		if( priorInfo->sectorEnd > vol->dwSize )
			vol->dwSize = priorInfo->sectorEnd;
	}
	// need to handle rollback before any timeline/directory loading
	// otherwise they will cache sectors that are duplicated here.
	if( !vol->journal.rollback_file ) {
		struct sack_vfs_os_file* file;
		file = _os_createFile( vol, FIRST_ROLLBACK_BLOCK, ROLLBACK_BLOCK_SIZE );
		file->cache = BC( ROLLBACK );
		enum block_cache_entries rollbackCache = BC( ROLLBACK );
		struct vfs_os_rollback_header* rollback = (struct vfs_os_rollback_header*)vfs_os_FSEEK( vol, file, 0, 0, &rollbackCache, ROLLBACK_BLOCK_SIZE DBG_SRC );
		if( !rollback->journal ) {
			enum block_cache_entries firstBlockCache = BC( ROLLBACK );
			rollback->journal = _os_GetFreeBlock( vol, &firstBlockCache, GFB_INIT_NONE, 4096 );
			firstBlockCache = BC( ROLLBACK );
			rollback->small_journal = _os_GetFreeBlock( vol, &firstBlockCache, GFB_INIT_NONE, 256 );
			LoG( "Initial allocate of journal blocks: %d %d", rollback->journal, rollback->small_journal );
		} else {
			LoG( "Reload allocate of journal blocks: %d %d", rollback->journal, rollback->small_journal );
		}
		vol->journal.rollback_journal_file = _os_createFile( vol, rollback->journal, BLOCK_SIZE );
		vol->journal.rollback_journal_file->cache = BC( ROLLBACK );
		vol->journal.rollback_small_journal_file = _os_createFile( vol, rollback->small_journal, BLOCK_SMALL_SIZE );
		vol->journal.rollback_small_journal_file->cache = BC( ROLLBACK );
		vol->journal.rollback_file = file;
		vol->journal.pdlPendingRecord = CreateDataList( sizeof( enum block_cache_entries ) );
		vol->journal.pdlJournaled = CreateDataList( sizeof( BLOCKINDEX ) );
		if( !vol->flags.skipRollbackProcessing )
			vfs_os_process_rollback( vol );
		{
			INDEX idx;
			enum block_cache_entries block;
			LIST_FORALL( vol->pending_rollback, idx, enum block_cache_entries, block ) {
				vfs_os_record_rollback( vol, block );
			}
			DeleteList( &vol->pending_rollback );
			sack_vfs_os_polish_volume( vol );
		}
	}
	vol->timeline_file = _os_createFile( vol, FIRST_TIMELINE_BLOCK, TIME_BLOCK_SIZE );
	vol->timeline_file->cache = BC( TIMELINE );
	{
		int locks;
		vol->timelineCache = BC( TIMELINE );
		vol->timeline = (struct storageTimeline *)vfs_os_BSEEK( vol, FIRST_TIMELINE_BLOCK, TIME_BLOCK_SIZE, &vol->timelineCache );
		SETMASK_( vol->seglock, seglock, vol->timelineCache, locks = GETMASK_( vol->seglock, seglock, vol->timelineCache )+1 );
		if( locks > 5 ) {
			lprintf( "Lock is in danger of overflow" );
		}
	}
	if( !_os_ScanDirectory( vol, NULL, FIRST_DIR_BLOCK, NULL, NULL, 0 ) ) return FALSE;
	//lprintf( "total files:%d", l.fileCount );
	return TRUE;
}
//-------------------------------------------------------
// function to process a currently loaded program to get the
// data offset at the end of the executable.
static void _os_AddSalt2( uintptr_t psv, POINTER *salt, size_t *salt_size ) {
	struct datatype { void* start; size_t length; } *data = (struct datatype*)psv;
	(*salt_size) = data->length;
	(*salt) = (POINTER)data->start;
	// only need to make one pass of it....
	data->length = 0;
	data->start = NULL;
}
const uint8_t *sack_vfs_os_get_signature2( POINTER disk, POINTER diskReal ) {
	if( disk != diskReal ) {
		static uint8_t usekey[BLOCK_SIZE];
		static struct random_context *entropy;
		static struct datatype { void* start; size_t length; } data;
		data.start = diskReal;
		data.length = ((uintptr_t)disk - (uintptr_t)diskReal) - BLOCK_SIZE;
		if( !entropy ) entropy = SRG_CreateEntropy2( _os_AddSalt2, (uintptr_t)&data );
		SRG_ResetEntropy( entropy );
		SRG_GetEntropyBuffer( entropy, (uint32_t*)usekey, BLOCK_SIZE*CHAR_BIT );
		return usekey;
	}
	return NULL;
}
// add some space to the volume....
LOGICAL _os_ExpandVolume( struct sack_vfs_os_volume *vol, BLOCKINDEX fromBlock, int size ) {
	LOGICAL created = FALSE;
	//LOGICAL path_checked = FALSE;
	int n;
	LoG( "Expand Volume: %d %d", fromBlock, size );
	size_t oldsize = vol->dwSize;
	if( vol->file && vol->read_only ) return TRUE;
	if( !size ) return FALSE;
	if( !vol->file ) {
		char *fname;
		char *iface;
		char *tmp;
#ifndef USE_STDIO
		if( tmp =(char*)StrChr( vol->volname, '@' ) ) {
			if( tmp[1] == '@' ) {
				strcpy( tmp, tmp + 1 );
				goto defaultOpen;
			} else {
				tmp[0] = 0;
				iface = (char*)vol->volname;
				fname = tmp + 1;
				struct file_system_mounted_interface* mount = sack_get_mounted_filesystem( iface );
				//struct file_system_interface *iface = sack_get_filesystem_interface( iface );
				if( !sack_exists( fname ) ) {
					vol->file = sack_fopenEx( 0, fname, "rb+", mount );
					if( !vol->file )
						vol->file = sack_fopenEx( 0, fname, "wb+", mount );
					created = TRUE;
				} else
					vol->file = sack_fopenEx( 0, fname, "rb+", mount );
				tmp[0] = '@';
			}
		}
		else {
defaultOpen:
			{
				char* tmp = StrDup( vol->volname );
				char* dir = (char*)pathrchr( tmp );
				if( dir ) {
					dir[0] = 0;
					if( !IsPath( tmp ) ) MakePath( tmp );
				}
				free( tmp );
				//Deallocate( char*, tmp );
			}
			vol->file = sack_fopenEx( 0, vol->volname, "rb+", vol->mount );
			if( !vol->file ) {
				created = TRUE;
				vol->file = sack_fopenEx( 0, vol->volname, "wb+", vol->mount );
			}
		}
#else
		vol->file = fopen( 0, vol->volname, "rb+" );
		if( !vol->file ) {
			created = TRUE;
			vol->file = fopen( 0, vol->volname, "wb+" );
		}
#endif
		if( !vol->file ) {
			//lprintf( "Failed to open volume" );
			return FALSE;
		}
		sack_fseek( vol->file, 0, SEEK_END );
		vol->dwSize = sack_ftell( vol->file );
		if( vol->dwSize == 0 )
			created = TRUE;
		sack_fseek( vol->file, 0, SEEK_SET );
	}
	{
		struct sack_vfs_os_BAT_info info;
		struct sack_vfs_os_BAT_info* pinfo;
		if( vol->pdl_BAT_information->Cnt )
			pinfo = ( struct sack_vfs_os_BAT_info* )GetDataItem( &vol->pdl_BAT_information, vol->pdl_BAT_information->Cnt - 1 );
		else
			pinfo = NULL;
		info.sectorEnd = ( pinfo ? pinfo->sectorEnd : 0 ) + ( BAT_BLOCK_SIZE + ( ( ( BLOCKS_PER_BAT * size ) + 4095 ) & ( ~4095 ) ) );
		info.sectorStart = ( pinfo ? pinfo->sectorEnd : 0 );
		info.blockStart = ( pinfo ? ( pinfo->blockStart + BLOCKS_PER_SECTOR ) : 0 );
		info.size = size;
		AddDataItem( &vol->pdl_BAT_information, &info );
		/*
		{
			INDEX idx;
			struct sack_vfs_os_BAT_info *info;
			// dump reloaded bat information (or bat so far...)
			DATA_FORALL( vol->pdl_BAT_information, idx, struct sack_vfs_os_BAT_info *, info ) {
				lprintf( "BAT Updated expanded: %d %d %d %d", info->blockStart, info->sectorStart, info->sectorEnd, info->size );
			}
		}
		*/
		// a BAT plus the sectors it references... ( BLOCKS_PER_BAT + 1 ) * BLOCK_SIZE
		if( info.sectorEnd > vol->dwSize )
			vol->dwSize = info.sectorEnd;
	}
	LoG( "created expanded volume: %p from %p size:%" _size_f, vol->file, BLOCKS_PER_SECTOR*size, vol->dwSize );
	vol->lastBlock += BLOCKS_PER_SECTOR;
	// can't recover dirents and nameents dynamically; so just assume
	// use the _os_GetFreeBlock because it will update encypted
	//vol->disk->BAT[0] = EOFBLOCK;  // allocate 1 directory entry block
	//vol->disk->BAT[1] = EOFBLOCK;  // allocate 1 name block
	n = 0;
	if( created || ( (n=1),size == BLOCK_SMALL_SIZE && oldsize == ( BLOCK_SIZE * BLOCKS_PER_SECTOR ) ) ) {
		enum block_cache_entries cache = BC(BAT);
		_os_UpdateSegmentKey( vol, &cache, n*BLOCKS_PER_SECTOR + 1 );
		((BLOCKINDEX*)vol->usekey_buffer[cache])[0] = EOBBLOCK;
		((BLOCKINDEX*)vol->usekey_buffer[cache])[BLOCKS_PER_BAT] = (size== BLOCK_SMALL_SIZE )?1:(size==4096)?0:2;
		if( created ) {
			enum block_cache_entries dirCache = BC( DIRECTORY );
			enum block_cache_entries timeCache = BC( TIMELINE );
			enum block_cache_entries rollbackCache = BC( ROLLBACK );
			//BLOCKINDEX dirblock =
				_os_GetFreeBlock( vol, &dirCache, GFB_INIT_DIRENT, DIR_BLOCK_SIZE );
			//BLOCKINDEX timeblock =
				_os_GetFreeBlock( vol, &timeCache, GFB_INIT_TIMELINE, TIME_BLOCK_SIZE );
			//BLOCKINDEX rollbackblock =
				_os_GetFreeBlock( vol, &rollbackCache, GFB_INIT_ROLLBACK, ROLLBACK_BLOCK_SIZE );
			vol->lastBatBlock = 0;
		}
		else {
			//vol->lastBatSmallBlock = BLOCKS_PER_BAT;
		}
		SMUDGECACHE( vol, cache );
		sack_vfs_os_flush_block( vol, cache );
		vol->bufferFPI[cache] = oldsize;
	}
	return TRUE;
}
static BLOCKINDEX _os_GetFreeBlock_( struct sack_vfs_os_volume *vol, enum block_cache_entries *blockCache, enum getFreeBlockInit init, int blockSize, LOGICAL flush_BAT_caches DBG_PASS )
{
	size_t n;
	unsigned int b = 0;
	enum block_cache_entries cache = BC( BAT );
	BLOCKINDEX *current_BAT;
	BLOCKINDEX check_val;
	if( blockSize == 4096 ) {
		if( vol->pdlFreeBlocks->Cnt ) {
			BLOCKINDEX newblock = ((BLOCKINDEX*)GetDataItem( &vol->pdlFreeBlocks, vol->pdlFreeBlocks->Cnt - 1 ))[0];
			check_val = 0;
			b = (unsigned int)(newblock / BLOCKS_PER_BAT);
			n = newblock % BLOCKS_PER_BAT;
			vol->pdlFreeBlocks->Cnt--;
		}
		else {
			check_val = EOBBLOCK;
			b = (unsigned int)(vol->lastBatBlock / BLOCKS_PER_BAT);
			n = vol->lastBatBlock % BLOCKS_PER_BAT;
		}
	}
	else {
		if( vol->pdlFreeSmallBlocks->Cnt ) {
			BLOCKINDEX newblock = ( (BLOCKINDEX*)GetDataItem( &vol->pdlFreeSmallBlocks, vol->pdlFreeSmallBlocks->Cnt - 1 ) )[0];
			check_val = 0;
			n = newblock % BLOCKS_PER_BAT;
			b = (unsigned int)( newblock / BLOCKS_PER_BAT );
			vol->pdlFreeSmallBlocks->Cnt--;
		}
		else {
			check_val = EOBBLOCK;
			n = vol->lastBatSmallBlock % BLOCKS_PER_BAT;
			b = (unsigned int)( vol->lastBatSmallBlock / BLOCKS_PER_BAT );
		}
	}
#ifdef DEBUG_SET_SECTOR_SIZE
	LoG_( "GetFreeBlock is using... check, start, b, n %d %d %d %d", (int)check_val, (int) vol->lastBatBlock, (int)b, (int)n );
#endif
//	vfs_os_compute_block( vol, b * BLOCKS_PER_SECTOR, cache );
	current_BAT =  (BLOCKINDEX*)vfs_os_block_index_SEEK( vol, b*BLOCKS_PER_SECTOR, blockSize, &cache ) + n;
	if( !current_BAT ) return 0;
	current_BAT[0] = EOFBLOCK;
	if( (check_val == EOBBLOCK) ) {
		if( n < (BLOCKS_PER_BAT - 1) ) {
			current_BAT[1] = EOBBLOCK;
			if( blockSize == 4096 )
				vol->lastBatBlock++;
			else
				vol->lastBatSmallBlock++;
		}
		else {
			BLOCKINDEX lastB = ( ( vol->lastBatSmallBlock > vol->lastBatBlock ) ? vol->lastBatSmallBlock : vol->lastBatBlock ) / BLOCKS_PER_BAT;
			enum block_cache_entries cache = BC( BAT );
			//_os_ExpandVolume( vol, lastB, blockSize );
			current_BAT = (BLOCKINDEX*)vfs_os_block_index_SEEK( vol, ( lastB + 1 ) * ( BLOCKS_PER_SECTOR ), blockSize, &cache );
			current_BAT[BLOCKS_PER_BAT] = ( blockSize == BLOCK_SMALL_SIZE ) ? 1 : ( blockSize == 4096 ) ? 0 : 2;
			//lprintf( "Initialized bat at block %d to %d", lastB + 1, current_BAT[BLOCKS_PER_BAT] );
			current_BAT[0] = EOBBLOCK;
			// update the clean buffer, so journal writes initialized data.
			//memcpy( vol->usekey_buffer_clean[cache], vol->usekey_buffer[cache], DIR_BLOCK_SIZE );
			if( blockSize == 4096 )
				vol->lastBatBlock = ( lastB + 1) * BLOCKS_PER_BAT;
			else
				vol->lastBatSmallBlock = ( lastB + 1 ) * BLOCKS_PER_BAT;
			if( flush_BAT_caches ) sack_vfs_os_flush_block( vol, cache );
 // make sure this gets saved...
			else SMUDGECACHE( vol, cache );
			//lprintf( "Set last block....%d", (int)vol->lastBatBlock );
		}
	}
	if( flush_BAT_caches ) sack_vfs_os_flush_block( vol, cache );
	else SMUDGECACHE( vol, cache );
	switch( init ) {
	case GFB_INIT_DIRENT: {
			struct directory_hash_lookup_block *dir;
#ifdef DEBUG_BLOCK_INIT
			LoG( "Create new directory: result %d", (int)(b * BLOCKS_PER_BAT + n) );
#endif
			blockCache[0] = BC( DIRECTORY );
			_os_UpdateSegmentKey_( vol, blockCache, b * (BLOCKS_PER_SECTOR)+n + 1 + 1 DBG_RELAY );
			memset( vol->usekey_buffer[blockCache[0]], 0, DIR_BLOCK_SIZE );
			dir = (struct directory_hash_lookup_block *)vol->usekey_buffer[blockCache[0]];
			enum block_cache_entries newcache2 = BC( NAMES );
			dir->names_first_block = _os_GetFreeBlock( vol, &newcache2, GFB_INIT_NAMES, NAME_BLOCK_SIZE );
			dir->used_names = 0;
			// update the clean buffer, so journal writes initialized data.
			//memcpy( vol->usekey_buffer_clean[newcache], vol->usekey_buffer[newcache2], DIR_BLOCK_SIZE );
			break;
		}
	case GFB_INIT_TIMELINE: {
			struct storageTimeline *tl;
#ifdef DEBUG_BLOCK_INIT
			LoG( "new block, init as root timeline" );
#endif
			_os_UpdateSegmentKey_( vol, blockCache, b * (BLOCKS_PER_SECTOR)+n + 1 + 1 DBG_RELAY );
			tl = (struct storageTimeline *)vol->usekey_buffer[blockCache[0]];
			//tl->header.timeline_length  = 0;
			//tl->header.crootNode.raw = 0;
			tl->header.srootNode.raw = 0;
			tl->header.first_free_entry.ref.index = 1;
			//tl->header.first_free_entry.ref.depth = 0;
			// update the clean buffer, so journal writes initialized data.
			//memcpy( vol->usekey_buffer_clean[blockCache[0]], vol->usekey_buffer[blockCache[0]], TIME_BLOCK_SIZE );
			break;
		}
	case GFB_INIT_TIMELINE_MORE:
#ifdef DEBUG_BLOCK_INIT
		LoG( "new block, init timeline more " );
#endif
		_os_UpdateSegmentKey_( vol, blockCache, b * (BLOCKS_PER_SECTOR)+n + 1 + 1 DBG_RELAY );
		memset( vol->usekey_buffer[blockCache[0]], 0, vol->sector_size[blockCache[0]] );
		// update the clean buffer, so journal writes initialized data.
		//memcpy( vol->usekey_buffer_clean[blockCache[0]],  vol->usekey_buffer[blockCache[0]], TIME_BLOCK_SIZE );
		break;
	case GFB_INIT_NAMES:
#ifdef DEBUG_BLOCK_INIT
		LoG( "new block, init names" );
#endif
		_os_UpdateSegmentKey_( vol, blockCache, b * (BLOCKS_PER_SECTOR)+n + 1 + 1 DBG_RELAY );
		memset( vol->usekey_buffer[blockCache[0]], 0, vol->sector_size[blockCache[0]] );
		((char*)(vol->usekey_buffer[blockCache[0]]))[0] = (char)UTF8_EOTB;
		// update the clean buffer, so journal writes initialized data.
		//memcpy( vol->usekey_buffer_clean[blockCache[0]], vol->usekey_buffer[blockCache[0]], DIR_BLOCK_SIZE );
		//LoG( "New Name Buffer: %x %p", vol->segment[blockCache[0]], vol->usekey_buffer[blockCache[0]] );
		break;
	default:
#ifdef DEBUG_BLOCK_INIT
		LoG( "Default or NO init..." );
#endif
		_os_UpdateSegmentKey_( vol, blockCache, b * (BLOCKS_PER_SECTOR)+n + 1 + 1 DBG_RELAY );
		break;
	}
	SMUDGECACHE( vol, blockCache[0] );
#ifdef DEBUG_ROLLBACK_JOURNAL
	LoG( "(post smudge)Return Free block:%d   %d  %d", (int)(b*BLOCKS_PER_BAT + n), (int)b, (int)n );
#endif
	//lprintf( "return block allocated: %d %d %d", (int)(b* BLOCKS_PER_BAT + n), (int)b, n );
	return b * BLOCKS_PER_BAT + n;
}
static BLOCKINDEX vfs_os_GetNextBlock_v2( struct sack_vfs_os_volume *vol, BLOCKINDEX block, enum block_cache_entries* blockCache, enum getFreeBlockInit init, LOGICAL expand, int blockSize, int *realBlockSize, LOGICAL flush_BAT_caches ) {
	BLOCKINDEX sector = block / BLOCKS_PER_BAT;
	enum block_cache_entries cache = BC(BAT);
	BLOCKINDEX *this_BAT = (BLOCKINDEX*)vfs_os_block_index_SEEK( vol, sector * (BLOCKS_PER_SECTOR), blockSize, &cache );
	int thisSize = this_BAT[BLOCKS_PER_BAT]? BLOCK_SMALL_SIZE :4096;
	BLOCKINDEX check_val;
 // if this passes, later ones will also.
	if( !this_BAT ) return 0;
#ifdef _DEBUG
	if( !block ) DebugBreak();
#endif
	check_val = (this_BAT[block % BLOCKS_PER_BAT]);
#ifdef _DEBUG
	if( !check_val ) {
		lprintf( "STOP: %p  %d  %d  %d", this_BAT, (int)check_val, (int)(block), (int)sector );
		DebugBreak();
	}
#endif
	if( check_val == EOBBLOCK ) {
		(this_BAT[block % (BLOCKS_PER_BAT)]) = EOFBLOCK;
		if( block < (BLOCKS_PER_BAT - 1) )
			(this_BAT[(1 + block) % BLOCKS_PER_BAT]) = EOBBLOCK;
		//else
		//	lprintf( "THIS NEEDS A NEW BAT BLOCK TO MOVE THE MARKER" );//
	}
	if( check_val == EOFBLOCK || check_val == EOBBLOCK ) {
		if( expand ) {
			SETMASK_( vol->seglock, seglock, cache, GETMASK_( vol->seglock, seglock, cache )+1 );
			check_val = _os_GetFreeBlock_( vol, blockCache, init, blockSize, flush_BAT_caches DBG_SRC );
#ifdef _DEBUG
			if( !check_val )DebugBreak();
#endif
			{
				// free block might have expanded... get the size that was actually allocated
				BLOCKINDEX nextSector = check_val / BLOCKS_PER_BAT;
				if( sector != nextSector ) {
					enum block_cache_entries cache = BC(BAT);
					BLOCKINDEX* this_BAT2 = (BLOCKINDEX*)vfs_os_block_index_SEEK( vol, nextSector * ( BLOCKS_PER_SECTOR ), BAT_BLOCK_SIZE, &cache );
					if( !this_BAT2 ) {
						lprintf( "failed to load next bat to get size" );
						return 0;
					}
					thisSize = this_BAT2[BLOCKS_PER_BAT] ? BLOCK_SMALL_SIZE : 4096;
				} else
					thisSize = this_BAT[BLOCKS_PER_BAT] ? BLOCK_SMALL_SIZE : 4096;
			}
			// segment could already be set from the _os_GetFreeBlock...
			//lprintf( "set block %d %d %d to %d", (int)block, (int)( block % BLOCKS_PER_BAT ), (int)sector, (int)check_val );
			this_BAT[block % BLOCKS_PER_BAT] = check_val;
			//lprintf( "Set %d  %d %d to %d", block, sector, block % BLOCKS_PER_BAT, check_val );
			if( flush_BAT_caches ) sack_vfs_os_flush_block( vol, cache );
			else SMUDGECACHE( vol, cache );
			SETMASK_( vol->seglock, seglock, cache, GETMASK_( vol->seglock, seglock, cache ) - 1 );
		}
	} else {
		enum block_cache_entries cache = BC(BAT);
		BLOCKINDEX nextSector = check_val / BLOCKS_PER_BAT;
		if( nextSector != sector ) {
			BLOCKINDEX* this_BAT2 = (BLOCKINDEX*)vfs_os_block_index_SEEK( vol, nextSector * ( BLOCKS_PER_SECTOR ), BAT_BLOCK_SIZE, &cache );
			if( !this_BAT2 ) {
				lprintf( "failed to load next bat to get size" );
				return 0;
			}
			thisSize = this_BAT2[BLOCKS_PER_BAT] ? BLOCK_SMALL_SIZE : 4096;
		} else
			thisSize = this_BAT[BLOCKS_PER_BAT] ? BLOCK_SMALL_SIZE : 4096;
	}
#ifdef _DEBUG
	if( !check_val )DebugBreak();
#endif
	if( realBlockSize ) realBlockSize[0] = thisSize;
	//LoG( "return next block:%d %d", (int)block, (int)check_val );
	return check_val;
}
static BLOCKINDEX vfs_os_GetNextBlock( struct sack_vfs_os_volume* vol, BLOCKINDEX block, enum block_cache_entries* blockCache, enum getFreeBlockInit init, LOGICAL expand, int blockSize, int* realBlockSize ) {
	return vfs_os_GetNextBlock_v2( vol, block, blockCache, init, expand, blockSize, realBlockSize, FALSE );
}
static void _os_AddSalt( uintptr_t psv, POINTER *salt, size_t *salt_size ) {
	struct sack_vfs_os_volume *vol = (struct sack_vfs_os_volume *)psv;
	if( vol->sigsalt ) {
		(*salt_size) = vol->sigkeyLength;
		(*salt) = (POINTER)vol->sigsalt;
		vol->sigsalt = NULL;
	}
	else if( vol->datakey ) {
		(*salt_size) = BLOCK_SIZE;
		(*salt) = (POINTER)vol->datakey;
		vol->datakey = NULL;
	}
	else if( vol->userkey ) {
		(*salt_size) = StrLen( vol->userkey );
		(*salt) = (POINTER)vol->userkey;
		vol->userkey = NULL;
	}
	else if( vol->devkey ) {
		(*salt_size) = StrLen( vol->devkey );
		(*salt) = (POINTER)vol->devkey;
		vol->devkey = NULL;
	}
	else if( vol->curseg < BC(COUNT) && vol->segment[vol->curseg] != ~0 ) {
		BLOCKINDEX sector = vol->segment[vol->curseg];
		switch( vol->clusterKeyVersion ) {
		case 0:
			( *salt_size ) = sizeof( vol->segment[vol->curseg] );
			( *salt ) = &vol->segment[vol->curseg];
			break;
		case 1:
			memcpy( vol->tmpSalt, vol->key, 16 );
			vol->tmpSalt[sector & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[0];
			vol->tmpSalt[( sector >> 4 ) & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[1];
			vol->tmpSalt[( sector >> 8 ) & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[2];
			vol->tmpSalt[( sector >> 12 ) & 0xF] ^= ( (uint8_t*)( &vol->segment[vol->curseg] ) )[3];
			( (BLOCKINDEX*)vol->tmpSalt )[0] ^= sector;
			( (BLOCKINDEX*)vol->tmpSalt )[1] ^= sector;
			( *salt_size ) = 12;
			( *salt ) = vol->tmpSalt;
			break;
		}
	}
	else
		(*salt_size) = 0;
}
static void _os_AssignKey( struct sack_vfs_os_volume *vol, const char *key1, const char *key2 )
{
	// *2 is to duplicate all buffers so there's a backing clean-copy for rollback
	uintptr_t size = BLOCK_SIZE + BLOCK_SIZE * ( BC(COUNT) * 2 )
		+ BLOCK_SIZE + SHORTKEY_LENGTH;
	if( !vol->key_buffer ) {
		int n;
		// internal buffers to read and decode into
// NewArray( uint8_t, size );
		vol->key_buffer = (uint8_t*)HeapAllocateAligned( NULL, size, 4096 );
		memset( vol->key_buffer, 0, size );
		for( n = 0; n < BC(COUNT); n++ ) {
			vol->usekey_buffer[n] = vol->key_buffer + (n + 1) * BLOCK_SIZE;
			vol->usekey_buffer_clean[n] = vol->key_buffer + ( n + 1 + BC(COUNT) ) * BLOCK_SIZE ;
		}
		for( n = 0; n < BC( COUNT ); n++ ) {
 // if not dirty, ~0 wont' be written but ages don't have to change.
			vol->segment[n] = ~0;
			CLEANCACHE( vol, n );
			RESETFLAG( vol->_dirty, n );
		}
	}
	vol->userkey = key1;
	vol->devkey = key2;
	if( key1 || key2 )
	{
		if( !vol->entropy )
			vol->entropy = SRG_CreateEntropy2( _os_AddSalt, (uintptr_t)vol );
		else
			SRG_ResetEntropy( vol->entropy );
		if( vol->oldkey ) Release( vol->oldkey );
		vol->oldkey = vol->key;
 //NewArray( uint8_t, size );
		vol->key = (uint8_t*)HeapAllocateAligned( NULL, 1024, 4096 );
		vol->curseg = BC(COUNT);
		SRG_GetEntropyBuffer( vol->entropy, (uint32_t*)vol->key, 1024 * 8 );
	}
	else {
		if( vol->oldkey ) Release( vol->oldkey );
		vol->oldkey = vol->key;
		vol->key = NULL;
	}
}
static void sack_vfs_os_flush_block( struct sack_vfs_os_volume* vol, enum block_cache_entries entry ) {
	INDEX idx = entry;
#ifdef DEBUG_DISK_IO
	LoG( "Flush dirty segment: %d  fpi:%zx %d", (int)idx, vol->bufferFPI[idx], vol->segment[idx] );
#  ifdef DEBUG_DISK_DATA
	LogBinary( vol->usekey_buffer[idx], vol->sector_size[idx] );
#  endif
#endif
	sack_fseek( vol->file, (size_t)vol->bufferFPI[idx], SEEK_SET );
	if( vol->key ) {
		uint8_t* crypt;
		size_t cryptlen;
		SRG_XSWS_encryptData( vol->usekey_buffer[idx], vol->sector_size[idx]
			, vol->segment[idx], (const uint8_t*)vol->key, 1024
			, &crypt, &cryptlen );
		if( !vol->flags.halted )
			sack_fwrite( crypt, 1, vol->sector_size[idx], vol->file );
		Deallocate( uint8_t*, crypt );
	} else {
		if( !vol->flags.halted )
			sack_fwrite( vol->usekey_buffer[idx], vol->sector_size[idx], 1, vol->file );
	}
	/*
	if( !GETMASK_( vol->seglock, seglock, idx ) )
		// don't HAVE To release that this segment is in this cache block...
		// it's just claimable, and not dirty.
		// vol->segment[idx] = ~0;
		;
	*/
	memcpy( vol->usekey_buffer_clean[idx], vol->usekey_buffer[idx], vol->sector_size[idx] );
	//lprintf( "Updated clean buffer %d", idx );
	CLEANCACHE( vol, idx );
	RESETFLAG( vol->_dirty, idx );
	//RESETFLAG( vol->dirty, idx );  // CLEANCACHE is this op...
}
void sack_vfs_os_flush_volume( struct sack_vfs_os_volume * vol, LOGICAL unload ) {
	{
		INDEX idx;
		while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
		for( idx = 0; idx < BC( ROLLBACK ); idx++ ) {
			if( unload ) {
  // reset any locks. (will fail any open files)
				SETMASK_( vol->seglock, seglock, idx, 0 );
				//RESETFLAG( vol->seglock, idx );
			}
			if( TESTFLAG( vol->dirty, idx ) || TESTFLAG( vol->_dirty, idx ) ) {
				sack_vfs_os_flush_block( vol, ( enum block_cache_entries )idx );
			} else {
#ifdef DEBUG_CACHE_FLUSH
				if( memcmp( vol->usekey_buffer_clean[idx], vol->usekey_buffer[idx], BLOCK_SIZE ) ) {
					lprintf( "Block was written to, but was not flagged as dirty, changes will be lost." );
					DebugBreak();
				}
#endif
			}
		}
		vfs_os_empty_rollback( vol );
	}
	vol->lock = 0;
}
static uintptr_t volume_flusher( PTHREAD thread ) {
	struct sack_vfs_os_volume *vol = (struct sack_vfs_os_volume *)GetThreadParam( thread );
	while( 1 ) {
		vol->flushing = 1;
		while( 1 ) {
			int updated;
			INDEX idx;
			updated = 0;
			if( !LockedExchange( &vol->lock, 1 ) ) {
				// this could be 'faster' testing the whole
				// flag type size data.
				for( idx = 0; idx < BC( COUNT ); idx++ )
					if( TESTFLAG( vol->dirty, idx ) ) {
						updated = 1;
						SETFLAG( vol->_dirty, idx );
						CLEANCACHE( vol, idx );
					}
				if( updated ) {
 // data changed, don't flush.
					vol->lock = 0;
					WakeableSleep( 256 );
					if( l.exited )break;
				}
				else
 // have lock, break; no new changes; flush dirty sectors(if any)
					break;
			}
 // didn't get lock, wait.
			else {
				WakeableSleep( 10 );
				if( l.exited )break;
				continue;
			}
		}
		if( l.exited )break;
		{
			INDEX idx;
			for( idx = 0; idx < BC( ROLLBACK ); idx++ )
  // last pass marked this dirty
				if( TESTFLAG( vol->_dirty, idx )
 // hasn't been re-marked as dirty, so it's been idle...
					&& !TESTFLAG( vol->dirty, idx ) ) {
					sack_vfs_os_flush_block( vol, (enum block_cache_entries)idx );
				}
				else {
#ifdef DEBUG_CACHE_FLUSH
					if( !TESTFLAG( vol->_dirty, idx )
						// hasn't been re-marked as dirty, so it's been idle...
						&& !TESTFLAG( vol->dirty, idx ) )
						if( memcmp( vol->usekey_buffer_clean[idx], vol->usekey_buffer[idx], BLOCK_SIZE ) ) {
							lprintf( "Block was written to, but was not flagged as dirty, changes will be lost." );
							//DebugBreak();
						}
#endif
				}
#ifdef DEBUG_DIRECTORIES
			_os_dumpDirectories( vol, 0, 1 );
#endif
			vfs_os_empty_rollback(vol);
		}
		vol->flushing = 0;
		vol->lock = 0;
		// for all dirty
		WakeableSleep( SLEEP_FOREVER );
		if( l.exited )break;
	}
	return 0;
}
void sack_vfs_os_polish_volume( struct sack_vfs_os_volume* vol ) {
	if( !vol->flusher )
		vol->flusher = ThreadTo( volume_flusher, (uintptr_t)vol );
	else if( !vol->flushing )
		WakeThread( vol->flusher );
}
void sack_vfs_os_unload_volume( struct sack_vfs_os_volume* vol );
struct sack_vfs_os_volume *sack_vfs_os_load_volume( const char * filepath, struct file_system_mounted_interface*mount )
{
	struct sack_vfs_os_volume *vol = New( struct sack_vfs_os_volume );
	memset( vol, 0, sizeof( struct sack_vfs_os_volume ) );
	if( !mount )
		mount = sack_get_default_mount();
	vol->mount = mount;
	// since time is morely forward going; keeping the stack for the avl
	// balancer can reduce forward-scanning insertion time
	// vol->pdsCTimeStack = CreateDataStack( sizeof( struct memoryTimelineNode ) );
	// vol->pdsWTimeStack = CreateDataStack( sizeof( struct memoryTimelineNode ) );
	vol->pdl_BAT_information = CreateDataList( sizeof( struct sack_vfs_os_BAT_info ) );
	vol->pdlFreeBlocks = CreateDataList( sizeof( BLOCKINDEX ) );
	vol->pdlFreeSmallBlocks = CreateDataList( sizeof( BLOCKINDEX ) );
	vol->volname = StrDup( filepath );
#ifdef DEBUG_DELETE_LAST
	vol->pvtDeleteBuffer = VarTextCreate();
#endif
	_os_AssignKey( vol, NULL, NULL );
	if( !_os_ExpandVolume( vol, 0, 4096 )
	  || !_os_ExpandVolume(vol, BLOCKS_PER_SECTOR, BLOCK_SMALL_SIZE )
	  || !_os_ValidateBAT( vol ) )
	{
		sack_vfs_os_unload_volume( vol );
		return NULL;
	}
#ifdef DEBUG_DIRECTORIES
	_os_dumpDirectories( vol, 0, 1 );
#endif
	AddLink( &l.volumes, vol );
	return vol;
}
struct sack_vfs_os_volume* sack_vfs_os_load_volume_v2( int flags, CTEXTSTR filepath, uintptr_t version, CTEXTSTR userkey, CTEXTSTR devkey, struct file_system_mounted_interface* mount )	 {
	struct sack_vfs_os_volume *vol = New( struct sack_vfs_os_volume );
	MemSet( vol, 0, sizeof( struct sack_vfs_os_volume ) );
	if( !mount )
		mount = sack_get_default_mount();
	vol->mount = mount;
	if( !version ) version = 2;
	if( flags & 1 ) vol->flags.skipRollbackProcessing = TRUE;
	if( flags & 2 ) vol->flags.halted = TRUE;
	vol->pdl_BAT_information = CreateDataList( sizeof( struct sack_vfs_os_BAT_info ) );
	vol->pdlFreeBlocks = CreateDataList( sizeof( BLOCKINDEX ) );
	vol->pdlFreeSmallBlocks = CreateDataList( sizeof( BLOCKINDEX ) );
	vol->clusterKeyVersion = version - 1;
	vol->volname = StrDup( filepath );
	vol->pvtDeleteBuffer = VarTextCreate();
	_os_AssignKey( vol, userkey, devkey );
	if( !_os_ExpandVolume( vol, 0, 4096 ) || !_os_ExpandVolume( vol, BLOCKS_PER_SECTOR, BLOCK_SMALL_SIZE ) || !_os_ValidateBAT( vol ) ) { sack_vfs_os_unload_volume( vol ); return NULL; }
#ifdef DEBUG_DIRECTORIES
	_os_dumpDirectories( vol, 0, 1 );
#endif
	AddLink( &l.volumes, vol );
	return vol;
}
struct sack_vfs_os_volume* sack_vfs_os_load_crypt_volume( const char* filepath, uintptr_t version, const char* userkey, const char* devkey, struct file_system_mounted_interface* mount ) {
	return sack_vfs_os_load_volume_v2( 0, filepath, version, userkey, devkey, mount );
}
void sack_vfs_os_unload_volume( struct sack_vfs_os_volume * vol ) {
	INDEX idx;
	struct sack_vfs_file *file;
#ifdef DEBUG_DIRECTORIES
	_os_dumpDirectories( vol, 0, 1 );
#endif
	LIST_FORALL( vol->files, idx, struct sack_vfs_file *, file )
		break;
	if( file ) {
		vol->closed = TRUE;
		return;
	}
	DeleteLink( &l.volumes, vol );
	if( vol->file )
		sack_vfs_os_flush_volume( vol, TRUE );
	free( (char*)vol->volname );
	DeleteListEx( &vol->files DBG_SRC );
	sack_fclose( vol->file );
	DeleteDataList( &vol->pdl_BAT_information );
	DeleteDataList( &vol->pdlFreeBlocks );
	DeleteDataList( &vol->pdlFreeSmallBlocks );
	//if( !vol->external_memory )	CloseSpace( vol->diskReal );
	if( vol->key ) {
		Deallocate( uint8_t*, vol->key );
		SRG_DestroyEntropy( &vol->entropy );
	}
	Deallocate( uint8_t*, vol->key_buffer );
	Deallocate( struct sack_vfs_os_volume*, vol );
}
void sack_vfs_os_shrink_volume( struct sack_vfs_os_volume * vol ) {
	size_t n;
	unsigned int b = 0;
	//int found_free; // this block has free data; should be last BAT?
	//BLOCKINDEX last_block = 0;
	//unsigned int last_bat = 0;
	enum block_cache_entries cache = BC(BAT);
	BLOCKINDEX *current_BAT = (BLOCKINDEX*)vfs_os_block_index_SEEK( vol, 0, 0, &cache );
 // expand failed, tseek failed in response, so don't do anything
	if( !current_BAT ) return;
	do {
		BLOCKINDEX check_val;
		for( n = 0; n < BLOCKS_PER_BAT; n++ ) {
			check_val = *(current_BAT++);
			if( check_val ) {
				//last_bat = b;
				//last_block = n;
			}
		}
		b++;
		if( vfs_os_compute_block( vol, b * BLOCKS_PER_SECTOR, BC(COUNT) ) < vol->dwSize ) {
			current_BAT = (BLOCKINDEX*)vfs_os_block_index_SEEK(  vol, b * ( BLOCKS_PER_SECTOR), 0, &cache );
		} else
			break;
	}while( 1 );
	sack_fclose( vol->file );
	vol->file = NULL;
	// setting 0 size will cause expand to do an initial open instead of expanding
	vol->dwSize = 0;
}
LOGICAL sack_vfs_os_decrypt_volume( struct sack_vfs_os_volume *vol )
{
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
 // volume is already decrypted, cannot remove key
	if( !vol->key ) { vol->lock = 0; return FALSE; }
	_os_AssignKey( vol, NULL, NULL );
	{
		enum block_cache_entries cache = BC(BAT);
		enum block_cache_entries cache2 = BC(BAT);
		size_t n;
		for( n = 0; vfs_os_compute_block( vol, n, BC(COUNT) ) < vol->dwSize; n++ ) {
			size_t m;
			BLOCKINDEX *block = (BLOCKINDEX*)vfs_os_block_index_SEEK(  vol, n, 0, &cache );
			for( m = 0; m < BLOCKS_PER_BAT; m++ ) {
				if( block[0] == EOBBLOCK ) break;
 // load the block using oldkey, flush will use new key
				else if( block[0] ) vfs_os_block_index_SEEK( vol, n + m, 0, &cache2 );
				block++;
			}
			if( m < BLOCKS_PER_BAT ) break;
			n += m;
		}
	}
	return TRUE;
}
LOGICAL sack_vfs_os_encrypt_volume( struct sack_vfs_os_volume *vol, uintptr_t version, CTEXTSTR key1, CTEXTSTR key2 ) {
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	//if( vol->key ) { vol->lock = 0; return FALSE; } // volume already has a key, cannot apply new key
	if( !version ) version = 2;
 // how key gets computed.
	vol->clusterKeyVersion = version-1;
	_os_AssignKey( vol, key1, key2 );
	{
		size_t n;
		enum block_cache_entries cache = BC(BAT);
		enum block_cache_entries cache2 = BC(BAT);
		for( n = 0; vfs_os_compute_block( vol, n, BC(COUNT) ) < vol->dwSize; n++ ) {
			size_t m;
			BLOCKINDEX *block = (BLOCKINDEX*)vfs_os_block_index_SEEK( vol, n, 0, &cache );
			for( m = 0; m < BLOCKS_PER_BAT; m++ ) {
				if( block[0] == EOBBLOCK ) break;
 // load the block using oldkey, flush will use new key
				else if( block[0] ) vfs_os_block_index_SEEK( vol, n + m, 0, &cache2 );
				block++;
			}
			if( m < BLOCKS_PER_BAT ) break;
			n += m;
		}
	}
	vol->lock = 0;
	return TRUE;
}
const char *sack_vfs_os_get_signature( struct sack_vfs_os_volume *vol ) {
	static char signature[257];
	static const char *output = "0123456789ABCDEF";
	if( !vol )
		return NULL;
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	{
		static BLOCKINDEX datakey[BLOCKS_PER_BAT];
		uint8_t usekey[128];
		signature[256] = 0;
		memset( datakey, 0, sizeof( datakey ) );
		{
			{
				size_t n;
				BLOCKINDEX this_dir_block = 0;
				BLOCKINDEX next_dir_block;
				BLOCKINDEX *next_entries;
				do {
					enum block_cache_entries cache = BC(DATAKEY);
					next_entries = BTSEEK( BLOCKINDEX *, vol, this_dir_block, DIR_BLOCK_SIZE, cache );
					for( n = 0; n < ( DIR_BLOCK_SIZE / BLOCKS_PER_BAT ); n++ )
						datakey[n] ^= next_entries[n];
					next_dir_block = vfs_os_GetNextBlock( vol, this_dir_block, &cache, GFB_INIT_DIRENT, FALSE, 4096, NULL );
#ifdef _DEBUG
					if( this_dir_block == next_dir_block )
						DebugBreak();
					if( next_dir_block == 0 )
						DebugBreak();
#endif
					this_dir_block = next_dir_block;
				}
				while( next_dir_block != EOFBLOCK );
			}
		}
		if( !vol->entropy )
			vol->entropy = SRG_CreateEntropy2( _os_AddSalt, (uintptr_t)vol );
		SRG_ResetEntropy( vol->entropy );
		vol->curseg = BC(DIRECTORY);
		vol->segment[vol->curseg] = 0;
		vol->datakey = (const char *)datakey;
		SRG_GetEntropyBuffer( vol->entropy, (uint32_t*)usekey, sizeof(usekey) * 8 );
		{
			int n;
			for( n = 0; n < sizeof(usekey); n++ ) {
				signature[n*2] = output[( usekey[n] >> 4 ) & 0xF];
				signature[n*2+1] = output[usekey[n] & 0xF];
			}
		}
	}
	vol->lock = 0;
	return signature;
}
LOGICAL checkFileLength( struct sack_vfs_os_volume *vol
	, BLOCKINDEX firstBlock
	, FPI expectedLength ) {
	BLOCKINDEX curBlock = firstBlock;
	size_t len;
	enum block_cache_entries cache;
	BLOCKINDEX sector = firstBlock / BLOCKS_PER_BAT;
	enum block_cache_entries batcache = BC(BAT);
	BLOCKINDEX *this_BAT = (BLOCKINDEX*)vfs_os_block_index_SEEK( vol, sector * (BLOCKS_PER_SECTOR), BLOCK_SIZE, &batcache );
	len = this_BAT[BLOCKS_PER_BAT] ? BLOCK_SMALL_SIZE : 4096;
	while( curBlock != EOFBLOCK ) {
		int blockSize;
		cache = BC(FILE);
		curBlock = vfs_os_GetNextBlock( vol, curBlock, &cache, GFB_INIT_NONE, FALSE, 0, &blockSize );
		if( curBlock != EOFBLOCK )
			len += blockSize;
	}
	if( len < expectedLength ) {
		lprintf( "Short file chain: %d %d", (int)len, (int)expectedLength );
		return FALSE;
	}
	//else lprintf( "Success: %d %d %d",  (int) firstBlock, (int)len, (int)expectedLength );
	return TRUE;
}
//-----------------------------------------------------------------------------------
// Director Support Functions
//-----------------------------------------------------------------------------------
LOGICAL _os_ScanDirectory_( struct sack_vfs_os_volume *vol, const char * filename
	, BLOCKINDEX dirBlockSeg
	, BLOCKINDEX *nameBlockStart
	, struct sack_vfs_os_file *file
	, int path_match
	, char *leadin
	, int *leadinDepth
) {
	int ofs = 0;
	BLOCKINDEX this_dir_block = dirBlockSeg;
	int usedNames;
	int minName;
	int curName;
	struct directory_hash_lookup_block *dirblock;
	//struct directory_entry *next_entries;
	if( filename && filename[0] == '.' && ( filename[1] == '/' || filename[1] == '\\' ) ) filename += 2;
	if( !file && !filename && nameBlockStart )
		lprintf( "Begin a scan dir:%d", (int)dirBlockSeg );
	do {
		enum block_cache_entries cache = BC(DIRECTORY);
		BLOCKINDEX nameBlock;
		dirblock = BTSEEK( struct directory_hash_lookup_block *, vol, this_dir_block, DIR_BLOCK_SIZE, cache );
		SETMASK_( vol->seglock, seglock, cache, GETMASK_( vol->seglock, seglock, cache )+1 );
		if( !dirblock->next_block[255] ) {
 // symbol not defined
#ifdef DEBUG_CONVERT_DIRECTORY
			l.fileCount = 0;
#endif
		}
		else{
			if( !file && !filename && nameBlockStart )
				 lprintf( "parent block(may be truncated): %d(%d) %d p:%d c:%d c:%c", (int)this_dir_block, cache, (int)dirblock->used_names
							, (int)(dirblock->next_block[255] >> 8)
							, (int)(dirblock->next_block[255] & 0xFF), (char)(dirblock->next_block[255] & 0xFF) );
		}
		nameBlock = dirblock->names_first_block;
		if( filename )
		{
			BLOCKINDEX nextblock = dirblock->next_block[(unsigned)filename[ofs]];
			if( nextblock ) {
				leadin[(*leadinDepth)++] = filename[ofs];
				ofs += 1;
				this_dir_block = nextblock;
				// just stepping to new block - unlock old, will lock new.
				SETMASK_( vol->seglock, seglock, cache, GETMASK_( vol->seglock, seglock, cache )-1 );
				//lprintf( "Follow subdirectory %d", (int)nextblock );
				continue;
			}
		}
		else {
			uint8_t charIndex;
			for( charIndex = 0; charIndex < 255; charIndex++ ) {
				BLOCKINDEX nextblock = dirblock->next_block[charIndex];
				if( nextblock ) {
					LOGICAL r;
					leadin[(*leadinDepth)++] = (char)charIndex;
#ifdef _DEBUG
					if( !file && !filename && nameBlockStart )
						lprintf( "Check subdirectory %d %d %c", (int)nextblock, (int)(dirblock->next_block[255] >> 8), charIndex );
#endif
					r = _os_ScanDirectory_( vol, NULL, nextblock, nameBlockStart, file, path_match, leadin, leadinDepth );
					(*leadinDepth)--;
					if( r && r != 2 )   {
						lprintf( "scan is returning early.. %d",r );
						SETMASK_( vol->seglock, seglock, cache, GETMASK_( vol->seglock, seglock, cache )-1 );
						return r;
					}
				}
			}
		}
		usedNames = dirblock->used_names - 1;
		if( SUS_GT( usedNames, int, ( sizeof( dirblock->entries ) / sizeof( dirblock->entries[0] ) ), size_t ) ) {
			lprintf( "Directory block name count is corrupt." );
			DebugBreak();
		}
		minName = 0;
		curName = (usedNames) >> 1;
		{
			//next_entries = dirblock->entries;
			//lprintf( "name block %d %d %d", (int)dirBlockSeg, (int)usedNames, (int)cache );
			while( minName <= usedNames && ( curName <= usedNames ) && ( curName >= 0 ) )
			{
				BLOCKINDEX bi;
				//enum block_cache_entries name_cache = BC(NAMES);
				struct directory_entry *entry = dirblock->entries + curName;
				//const char * testname;
				FPI name_ofs = ( entry->name_offset ) & DIRENT_NAME_OFFSET_OFFSET;
 // symbol not defined
#ifdef DEBUG_CONVERT_DIRECTORY
				l.fileCount++;
#endif
#ifdef DEBUG_TIMELINE_DIR_TRACKING
 // else we have a different issue.
				if( entry->timelineEntry )
				{
					// make sure timeline and file entries reference each other.
					struct memoryTimelineNode time;
					reloadTimeEntry( &time, vol, entry->timelineEntry VTReadOnly GRTELog DBG_SRC );
					FPI entry_fpi = vol->bufferFPI[cache] + sane_offsetof( struct directory_hash_lookup_block, entries[curName] );
					if( entry_fpi != time.disk->dirent_fpi ) {
						lprintf( "!!!! directory entry doesn't match: %d %d", entry_fpi, time.disk->dirent_fpi );
						DebugBreak();
					}
					dropRawTimeEntry( vol, time.diskCache GRTELog DBG_SRC );
				}
#endif
				//if( filename && !name_ofs )	return FALSE; // done.
				if( 0 ) {
					LoG( "%d name_ofs = %" _size_f "(%" _size_f ") block = %d  vs %s"
						, curName, name_ofs
						, entry->name_offset
						, entry->first_block
						, filename + ofs );
				}
				if( curName < usedNames ) {
					bi = entry->first_block ;
					// if file is deleted; don't check it's name.
					if( !bi ) {
						lprintf( "File is already deleted... (these should be removed)" );
						continue;
					}
					// if file is end of directory, done sanning.
// done.
					if( bi == EODMARK ) { lprintf( "Found end of directory mark." ); return filename ? FALSE : (2); }
					if( name_ofs > vol->dwSize ) { lprintf( "name offset is bigger than volume size!"); return FALSE; }
				}
				//testname =
				if( filename ) {
					int d;
					//LoG( "this name: %s", names );
					if( ( d = _os_MaskStrCmp( vol, filename+ofs, nameBlock, name_ofs, path_match ) ) == 0 ) {
						if( file )
						{
							/* can just keep the existing lock...
							int locks = GETMASK_( vol->seglock, seglock, cache ) + 1;
							if( locks > 12 ) {
								lprintf( "Too many locks open... " );
								DebugBreak();
							}
							SETMASK_( vol->seglock, seglock, cache, locks );
							*/
							file->cache = cache;
							file->entry_fpi = vol->bufferFPI[BC(DIRECTORY)] + ((uintptr_t)(((struct directory_hash_lookup_block *)0)->entries + curName));
							file->dir_block = this_dir_block;
							file->entry_.name_offset = ( entry->name_offset & DIRENT_NAME_OFFSET_OFFSET ) + vfs_os_compute_data_block( vol, dirblock->names_first_block, BC( COUNT ) );
							file->entry = entry;
						}
#ifdef DEBUG_DIRECTORIES
						if(0)
						LoG( "return found entry: %p (%" _size_f ":%" _size_f ") %*.*s%s"
							, entry, name_ofs, entry->first_block
							, *leadinDepth, *leadinDepth, leadin
							, filename+ofs );
#endif
						if( nameBlockStart ) nameBlockStart[0] = dirblock->names_first_block ;
						// keep the lock because of the file cache reference.
						if( !file )
							SETMASK_( vol->seglock, seglock, cache, GETMASK_( vol->seglock, seglock, cache )-1 );
						return TRUE;
					}
					if( d > 0 ) {
						minName = curName + 1;
					} else {
						usedNames = curName - 1;
					}
					curName = (minName + usedNames) >> 1;
				}
				else {
					if( minName < usedNames && !file ) {
						if( !checkFileLength( vol, entry->first_block, entry->filesize ) ) {
							lprintf( "directory scan found a short file chain" );
							return FALSE;
						}
					}
					curName++;
				}
			}
			// no file created, found end, unlock this directory
			SETMASK_( vol->seglock, seglock, cache, GETMASK_( vol->seglock, seglock, cache )-1 );
 // done.;
			return filename ? FALSE : (2);
		}
		// unreachable, and broken code.
#if 0
		BLOCKINDEX next_dir_block;
		next_dir_block = vfs_os_GetNextBlock( vol, this_dir_block, GFB_INIT_TIMELINE_MORE, TRUE, DIR_BLOCK_SIZE, NULL );
#ifdef _DEBUG
		if( this_dir_block == next_dir_block ) DebugBreak();
  // should have a last-entry before no more blocks....
		if( next_dir_block == 0 ) { DebugBreak(); return FALSE; }
#endif
		this_dir_block = next_dir_block;
#endif
	}
	while( 1 );
}
// this results in an absolute disk position
static FPI _os_SaveFileName( struct sack_vfs_os_volume *vol, BLOCKINDEX firstNameBlock, const char * filename, size_t namelen ) {
	int blocks = 0;
	LOGICAL scanToEnd = FALSE;
	BLOCKINDEX this_name_block = firstNameBlock;
#ifdef _DEBUG
	if( !firstNameBlock ) DebugBreak();
#endif
	//lprintf( "Save filename:%s", filename );
	while( 1 ) {
		enum block_cache_entries cache = BC(NAMES);
		unsigned char *names = BTSEEK( unsigned char *, vol, this_name_block, NAME_BLOCK_SIZE, cache );
		unsigned char *name = (unsigned char*)names;
		if( scanToEnd ) {
			while(
				(UTF8_EOT != (name[0] ))
				&& (name - names < NAME_BLOCK_SIZE)
				) name++;
			if( ( name - names ) >= NAME_BLOCK_SIZE ) {
				// wow, that is a really LONG name.
				cache = BC( NAMES );
				this_name_block = vfs_os_GetNextBlock( vol, this_name_block, &cache, GFB_INIT_NAMES, TRUE, NAME_BLOCK_SIZE, NULL );
				blocks++;
				continue;
			}
		}
		scanToEnd = FALSE;
		while( name < ( (unsigned char*)names + NAME_BLOCK_SIZE ) ) {
			int c = name[0];
			if( (unsigned char)c == UTF8_EOTB ) {
				if( namelen < (size_t)( ( (unsigned char*)names + NAME_BLOCK_SIZE ) - name ) ) {
					//LoG( "using unused entry for new file...%" _size_f " %d(%d)  %" _size_f " %s", this_name_block, cache, cache - BC(NAMES), name - names, filename );
					memcpy( name, filename, namelen );
					name[namelen+0] = UTF8_EOT;
					name[namelen+1] = UTF8_EOTB;
					SMUDGECACHE( vol, cache );
					//LoG( "save name OFFSET:%d %d", (name) - (names), +blocks * NAME_BLOCK_SIZE );
					return (name) - (names) + blocks * NAME_BLOCK_SIZE;
				}
			}
			else
				if( _os_MaskStrCmp( vol, filename, firstNameBlock, (name - names)+blocks*NAME_BLOCK_SIZE, 0 ) == 0 ) {
					LoG( "using existing entry for new file...%s", filename );
					lprintf( "name already in cache %d", cache );
					return (name) - (names) + blocks * NAME_BLOCK_SIZE;
				}
			while(
				( UTF8_EOT != ( name[0] ) )
				&& ( name-names < NAME_BLOCK_SIZE )
			) name++;
			if( name - names <= NAME_BLOCK_SIZE ) {
				if( name - names < NAME_BLOCK_SIZE ) {
					name++;
				}
				else {
					// next seek will be on right character...
				}
			}
			else
 // still looking for EOT
				scanToEnd = TRUE;
			//LoG( "new position is %" _size_f "  %" _size_f, this_name_block, name - names );
		}
		this_name_block = vfs_os_GetNextBlock( vol, this_name_block, &cache, GFB_INIT_NAMES, TRUE, NAME_BLOCK_SIZE, NULL );
		blocks++;
		//LoG( "Need a new name block.... %d", this_name_block );
	}
	lprintf( "didn't actually save the name?" );
}
static void deleteDirectoryEntryName( struct sack_vfs_os_volume* vol, struct sack_vfs_os_file* file, int nameOffset, enum block_cache_entries nameCache, BLOCKINDEX dir_block_index ) {
	size_t n;
	FPI nameoffset_temp = 0;
	//static uint8_t namebuffer[3 * 4096];
	uint8_t* nameblock = NULL;
	uint8_t* nameblock_;
	int f;
	int e = -1;
	enum block_cache_entries name_cache = BC(ZERO), name_cache_;
 // this will be a smallish int
	int endNameOffset = 0;
	int findNameOffset = nameOffset;
	struct directory_hash_lookup_block* dirblock = (struct directory_hash_lookup_block*)vol->usekey_buffer[nameCache];
	BLOCKINDEX name_block = dirblock->names_first_block;
#ifdef DEBUG_FILE_OPEN
	LoG( "------------ BEGIN DELETE DIRECTORY ENTRY NAME ----------------------" );
#endif
	// read name block chain into a single array
	do {
		uint8_t* out;
		uint8_t* in;
		name_cache_ = name_cache;
		name_cache = BC( NAMES );
		nameblock_ = nameblock;
		nameblock = BTSEEK( uint8_t*, vol, name_block, NAME_BLOCK_SIZE, name_cache );
		if( findNameOffset < NAME_BLOCK_SIZE ) {
			// first read block (nameoffset_temp = 0)
			// not already found end of text mark ( endNameOffset = 0 )
			SETMASK_( vol->seglock, seglock, name_cache, GETMASK_( vol->seglock, seglock, name_cache ) + 1 );
			if( !endNameOffset ) {
				for( n = findNameOffset; n < NAME_BLOCK_SIZE; n++ ) {
					if( nameblock[n] == UTF8_EOT ) {
						endNameOffset = (int)(nameoffset_temp + n + 1);
						break;
					}
				}
				// if the difference was found, move the rest of this block.
				if( endNameOffset ) {
					in = nameblock + endNameOffset;
					out = nameblock + findNameOffset;
					for( n = endNameOffset; n < NAME_BLOCK_SIZE; n++ ) {
						( *out++ ) = ( *in++ );
					}
  // re-wrote block;
					SMUDGECACHE( vol, name_cache );
				}
			}
			else {
				// already have a known end of name, and the offset
				// move the data in this block forward.
				unsigned int namelength = ( endNameOffset - findNameOffset );
				unsigned int length = NAME_BLOCK_SIZE - ( namelength );
				in = nameblock;
				out = nameblock_ + length;
				for( n = 0; n < namelength; n++ ) {
					( *out++ ) = ( *in++ );
				}
				// switch blocks.
				out = nameblock;
				for( n = 0; n < length; n++ ) {
					( *out++ ) = ( *in++ );
				}
  // re-wrote block;
				SMUDGECACHE( vol, name_cache );
				// unlock the previous block (if there was one);
				if( name_cache_ )
					SETMASK_( vol->seglock, seglock, name_cache_, GETMASK_( vol->seglock, seglock, name_cache_ ) - 1 );
			}
			nameoffset_temp += NAME_BLOCK_SIZE;
		}
		else {
			findNameOffset -= NAME_BLOCK_SIZE;
		}
		enum block_cache_entries gnbCache = BC( NAMES );
		name_block = vfs_os_GetNextBlock( vol, name_block, &gnbCache, GFB_INIT_NONE, FALSE, NAME_BLOCK_SIZE, NULL );
	} while( name_block != EOFBLOCK );
	// unlock the last block
	SETMASK_( vol->seglock, seglock, name_cache, GETMASK_( vol->seglock, seglock, name_cache ) - 1 );
	{
		uint8_t* out;
		out = nameblock + ( n = NAME_BLOCK_SIZE - ( endNameOffset - findNameOffset ) );
		// fill tail of block with 0.
		for( ; n < NAME_BLOCK_SIZE; n++ ) {
			( *out++ ) = 0;
		}
	}
	// move the directory entries down.
	//file->entry->name_offset = 0;
	for( f = 0; f < dirblock->used_names; f++ ) {
		if( USS_GT( ( dirblock->entries[f].name_offset & DIRENT_NAME_OFFSET_OFFSET ), FPI, nameOffset, int ) )
			dirblock->entries[f].name_offset -= endNameOffset - findNameOffset;
		if( ( dirblock->entries + f ) == file->entry ) {
			e = f;
		}
		else if( e >= 0 ) {
			if( dirblock->entries[f].timelineEntry ) {
				struct memoryTimelineNode time;
				//enum block_cache_entries  timeCache = BC( TIMELINE );
				reloadTimeEntry( &time, vol, ( dirblock->entries[f].timelineEntry ) VTReadWrite GRTENoLog DBG_SRC );
				time.disk->dirent_fpi = vol->bufferFPI[nameCache] + sane_offsetof( struct directory_hash_lookup_block, entries[f - 1] );
				{
					uint64_t index = time.disk->priorTime;
					while( index ) {
						struct memoryTimelineNode time2;
						reloadTimeEntry( &time2, vol, index GRTENoLog VTReadWrite DBG_SRC );
						time2.disk->dirent_fpi = time.disk->dirent_fpi;
						index = time2.disk->priorTime;
						updateTimeEntry( &time2, vol, TRUE DBG_SRC );
					}
				}
#ifdef DEBUG_TIMELINE_DIR_TRACKING
				lprintf( "Set timeline %d to %d", (int)time.index, (int)time.disk->dirent_fpi );
#endif
				updateTimeEntry( &time, vol, TRUE DBG_SRC );
			}
			dirblock->entries[f - 1] = dirblock->entries[f];
		}
	}
	dirblock->used_names--;
	SMUDGECACHE( vol, name_cache );
}
static void ConvertDirectory( struct sack_vfs_os_volume *vol, const char *leadin, int leadinLength, BLOCKINDEX this_dir_block, struct directory_hash_lookup_block *orig_dirblock, enum block_cache_entries *newCache ) {
	size_t n;
#ifdef DEBUG_CONVERT_DIRECTORY
	LoG( "------------ BEGIN CONVERT DIRECTORY ---------------------- %d", this_dir_block );
#endif
 // symbol not defined
#ifdef DEBUG_CONVERT_DIRECTORY
	{
		BLOCKINDEX a;
		if( !_os_ScanDirectory( vol, NULL, FIRST_DIR_BLOCK, NULL, NULL, 0 ) ) {
			 lprintf( "Directory scan in close failed" );
			DebugBreak();
			//return ;
		}
		if( l.fileCount_old > l.fileCount ) {
			BLOCKINDEX x;
			lprintf( "operation befoe the convert lost files. %d %d", l.fileCount_old, l.fileCount );
			//if( !_os_ScanDirectory( vol, NULL, FIRST_DIR_BLOCK, &x, NULL, 0 ) ) {
			 //lprintf( "Directory scan in close failed" );
			DebugBreak();
			//return ;
		}
	}
	lprintf( "total files:%d", l.fileCount );
	l.fileCount_old = l.fileCount;
#endif
	do {
		enum block_cache_entries cache = BC(DIRECTORY);
		FPI nameoffset_temp = 0;
		BLOCKINDEX new_dir_block;
		struct directory_hash_lookup_block *dirblock;
		dirblock = BTSEEK( struct directory_hash_lookup_block *, vol, this_dir_block, DIR_BLOCK_SIZE, cache );
		{
			static int counters[256];
			static uint8_t namebuffer[18*4096];
			uint8_t *nameblock;
			int maxc = 0;
			int imax = 0;
			int f;
			enum block_cache_entries name_cache;
			BLOCKINDEX name_block = dirblock->names_first_block;
			// read name block chain into a single array
			do {
				uint8_t *out = namebuffer + nameoffset_temp;
				name_cache = BC( NAMES );
				nameblock = BTSEEK( uint8_t *, vol, name_block, NAME_BLOCK_SIZE, name_cache );
				for( n = 0; n < 4096; n++ )
					(*out++) = (*nameblock++);
				enum block_cache_entries gnbCache = BC( NAMES );
				name_block = vfs_os_GetNextBlock( vol, name_block, &gnbCache, GFB_INIT_NONE, 0, NAME_BLOCK_SIZE, NULL );
				nameoffset_temp += NAME_BLOCK_SIZE;
			} while( name_block != EOFBLOCK );
			memset( counters, 0, sizeof( counters ) );
			// 257/85
			for( f = 0; f < VFS_DIRECTORY_ENTRIES; f++ ) {
				BLOCKINDEX first = dirblock->entries[f].first_block;
				FPI name;
				int count;
				if( first == EODMARK ) break;
				name = dirblock->entries[f].name_offset & DIRENT_NAME_OFFSET_OFFSET;
				count = (++counters[namebuffer[name]]);
				if( count > maxc ) {
					imax = namebuffer[name];
					maxc = count;
				}
			}
			// after finding most used first byte; get a new block, and point
			// hash entry to that.
			enum block_cache_entries newBlockCache = BC( DIRECTORY );
			dirblock->next_block[imax]
				= ( new_dir_block
				  = _os_GetFreeBlock( vol, &newBlockCache, GFB_INIT_DIRENT, 4096 ) );
			//if( new_dir_block == 48 || new_dir_block == 36 )
			//	DebugBreak();
			SMUDGECACHE( vol, cache );
			{
				struct directory_hash_lookup_block *newDirblock;
				enum block_cache_entries newdir_cache;
				BLOCKINDEX newFirstNameBlock;
				int usedNames = dirblock->used_names;
				//int _usedNames = usedNames;
				int nf = 0;
				//int firstNameOffset = -1;
				//int finalNameOffset = 0;;
				int movedEntry = 0;
				int offset;
				newdir_cache = BC(DIRECTORY);
				newDirblock = BTSEEK( struct directory_hash_lookup_block *, vol, new_dir_block, DIR_BLOCK_SIZE, newdir_cache );
#ifdef DEBUG_CONVERT_DIRECTORY
				LoG( "new dir block cache is  %d   %d   %d  %d", newdir_cache, (int)new_dir_block, (int)this_dir_block, imax );
#endif
				newFirstNameBlock = newDirblock->names_first_block;
#ifdef _DEBUG
				if( !newDirblock->names_first_block )
					DebugBreak();
#endif
				newDirblock->next_block[DIRNAME_CHAR_PARENT] = (this_dir_block << 8) | imax;
				//SMUDGECACHE( vol, newdir_cache ); // this will be dirty because it was init above.
				for( f = 0; f < usedNames; f++ ) {
					//BLOCKINDEX first = dirblock->entries[f].first_block;
					struct directory_entry *entry;
					struct directory_entry *newEntry;
					FPI name;
					FPI name_ofs;
					entry = dirblock->entries + (f);
					name = ( entry->name_offset ) & DIRENT_NAME_OFFSET_OFFSET;
					if( namebuffer[name] == imax ) {
						int namelen;
						if( !movedEntry ) movedEntry = f+1;
						newEntry = newDirblock->entries + (nf);
						//LoG( "Saving existing name %d %s", name, namebuffer + name );
						//LogBinary( namebuffer, 32 );
						namelen = 0;
						while( namebuffer[name + namelen] != UTF8_EOT )namelen++;
						name_ofs = _os_SaveFileName( vol, newFirstNameBlock, (char*)(namebuffer + name + 1), namelen -1 );
						{
							INDEX idx;
							struct sack_vfs_os_file  * file;
							LIST_FORALL( vol->files, idx, struct sack_vfs_file  *, file ) {
								if( file->entry == entry ) {
 // new entry_fpi.
									file->entry_fpi = 0;
								}
							}
						}
						dirblock->used_names = ((dirblock->used_names) - 1);
						if( dirblock->used_names > ( sizeof( dirblock->entries ) / sizeof( dirblock->entries[0] ) ) ) {
							lprintf( "Directory block name count is corrupt." );
							DebugBreak();
						}
						newEntry->filesize = entry->filesize;
						{
							struct memoryTimelineNode time;
							FPI oldFPI;
							//enum block_cache_entries  timeCache = BC( TIMELINE );
							reloadTimeEntry( &time, vol, (entry->timelineEntry     ) VTReadWrite GRTENoLog DBG_SRC );
 // dirent_fpi type is larger than index in some configurations; but won't exceed those bounds
							oldFPI = (FPI)time.disk->dirent_fpi;
							// new entry is still the same timeline entry as the old entry.
							newEntry->timelineEntry = (entry->timelineEntry     )     ;
							// timeline points at new entry.
							time.disk->dirent_fpi = vol->bufferFPI[newdir_cache] + sane_offsetof(struct directory_hash_lookup_block, entries[nf]);
							{
								uint64_t index = time.disk->priorTime;
								while( index ) {
									struct memoryTimelineNode time2;
									reloadTimeEntry( &time2, vol, index VTReadWrite GRTENoLog DBG_SRC );
									time2.disk->dirent_fpi = time.disk->dirent_fpi;
									updateTimeEntry( &time2, vol, TRUE DBG_SRC );
									index = time2.disk->priorTime;
								}
							}
#ifdef DEBUG_TIMELINE_DIR_TRACKING
							lprintf( "Set timeline %d to %d", (int)time.index, (int)time.disk->dirent_fpi );
#endif
							updateTimeEntry( &time, vol, TRUE DBG_SRC );
#ifdef DEBUG_TIMELINE_DIR_TRACKING
							lprintf( "direntry at %d  %d is time %d", (int)new_dir_block, (int)nf, (int)newEntry->timelineEntry );
#endif
							{
								INDEX idx;
								struct sack_vfs_file  * file;
								LIST_FORALL( vol->files, idx, struct sack_vfs_file  *, file ) {
									if( file->entry_fpi == oldFPI ) {
										// unlock old directory
										int locks = GETMASK_( vol->seglock, seglock, file->cache ) - 1;
										if( locks < 0 ) {
											lprintf( "File lock in convert underflow... " );
											DebugBreak();
										}
										SETMASK_( vol->seglock, seglock, cache, locks );
										// new entry_fpi.
 // dirent_fpi type is larger than index in some configurations; but won't exceed those bounds
										file->entry_fpi = (FPI)time.disk->dirent_fpi;
										//file->dir_block = time.disk->dir
										lprintf( "File cache might have been wrong... (AND USED OLD ENTRY)" );
										file->entry = newEntry;
										file->cache = newdir_cache;
										// lock new cache entry
										locks = GETMASK_( vol->seglock, seglock, file->cache ) + 1;
										if( locks < 0 ) {
											lprintf( "File lock in convert underflow... " );
											DebugBreak();
										}
										SETMASK_( vol->seglock, seglock, cache, locks );
									}
								}
							}
						}
						newEntry->name_offset = name_ofs;
						newEntry->first_block = (entry->first_block ) ;
						//lprintf( "Convert File new block %d", entry->first_block );
						SMUDGECACHE( vol, cache );
						nf++;
						newDirblock->used_names = ((newDirblock->used_names) + 1);
						if( newDirblock->used_names > ( sizeof( newDirblock->entries ) / sizeof( newDirblock->entries[0] ) ) ) {
							lprintf( "Directory block name count is corrupt." );
							DebugBreak();
						}
						//usedNames--;
					}
					else {
						if( movedEntry ) {
							break;
						}
					}
				}
				LoG( "blocks: %d %d %d old names new names %d %d = %d"
						, this_dir_block, new_dir_block
						, imax
						, dirblock->used_names, newDirblock->used_names, dirblock->used_names+ newDirblock->used_names );
				// move all others down 1.
				movedEntry = movedEntry - 1;
				offset = (f - movedEntry);
				usedNames -= (f-movedEntry);
				//for( ; f < usedNames; f++ )
				{
					int m;
					for( m = movedEntry; m < usedNames; m++ ) {
						dirblock->entries[m].first_block = dirblock->entries[m + offset].first_block;
						dirblock->entries[m].name_offset = dirblock->entries[m + offset].name_offset;
						dirblock->entries[m].filesize = dirblock->entries[m + offset].filesize;
						dirblock->entries[m].timelineEntry = dirblock->entries[m + offset].timelineEntry;
#ifdef DEBUG_TIMELINE_DIR_TRACKING
						lprintf( "direntry at %d  %d is time %d", (int)this_dir_block, (int)m, (int)dirblock->entries[m].timelineEntry );
#endif
						{
							struct memoryTimelineNode time;
							//enum block_cache_entries  timeCache = BC( TIMELINE );
							reloadTimeEntry( &time, vol, (dirblock->entries[m + offset].timelineEntry) VTReadWrite GRTENoLog DBG_SRC );
 /*vol->bufferFPI[cache]*/
							time.disk->dirent_fpi = this_dir_block * BLOCK_SIZE + sane_offsetof( struct directory_hash_lookup_block, entries[m] );
							{
								uint64_t index = time.disk->priorTime;
								while( index ) {
									struct memoryTimelineNode time2;
									reloadTimeEntry( &time2, vol, index VTReadWrite GRTENoLog DBG_SRC );
									time2.disk->dirent_fpi = time.disk->dirent_fpi;
									updateTimeEntry( &time2, vol, TRUE DBG_SRC );
									index = time2.disk->priorTime;
								}
							}
#ifdef DEBUG_TIMELINE_DIR_TRACKING
							lprintf( "Set timeline %d to %d", (int)time.index, (int)time.disk->dirent_fpi );
#endif
							updateTimeEntry( &time, vol, TRUE DBG_SRC );
						}
#ifdef _DEBUG
						if( !dirblock->names_first_block ) DebugBreak();
#endif
					}
					for( m = usedNames; m < VFS_DIRECTORY_ENTRIES; m++ ) {
						dirblock->entries[m].first_block = (0);
						dirblock->entries[m].name_offset = (0);
						dirblock->entries[m].filesize = (0);
						dirblock->entries[m].timelineEntry = (0);
#ifdef _DEBUG
						if( !dirblock->names_first_block ) DebugBreak();
#endif
					}
				}
				if( usedNames ) {
					static uint8_t newnamebuffer[18 * 4096];
					int newout = 0;
					//int min_name = NAME_BLOCK_SIZE + 1;
					//int _min_name = -1; // min found has to be after this one.
					//lprintf( "%d names remained.", usedNames );
					for( f = 0; f < usedNames; f++ ) {
						struct directory_entry *entry;
						FPI name;
						entry = dirblock->entries + (f);
						name = ( entry->name_offset ) & DIRENT_NAME_OFFSET_OFFSET;
						entry->name_offset = ( newout )
							| ( (entry->name_offset)
								& ~DIRENT_NAME_OFFSET_OFFSET );
						while( namebuffer[name] != UTF8_EOT )
							newnamebuffer[newout++] = namebuffer[name++];
						newnamebuffer[newout++] = namebuffer[name++];
					}
					newnamebuffer[newout++] = UTF8_EOTB;
					memcpy( namebuffer, newnamebuffer, newout );
 // tidy up the end of the old buffer.
					memset( namebuffer + newout, 0, NAME_BLOCK_SIZE - newout );
					memset( newnamebuffer, 0, newout );
				}
				else {
					namebuffer[0] = UTF8_EOTB;
				}
				{
					name_block = dirblock->names_first_block;
					nameoffset_temp = 0;
					do {
						uint8_t *out;
						nameblock = namebuffer + nameoffset_temp;
						name_cache = BC( NAMES );
						out = BTSEEK( uint8_t *, vol, name_block, NAME_BLOCK_SIZE, name_cache );
						for( n = 0; n < 4096; n++ )
							(*out++) = (*nameblock++);
						SMUDGECACHE( vol, name_cache );
						enum block_cache_entries gnbCache = BC(NAMES);
						name_block = vfs_os_GetNextBlock( vol, name_block, &gnbCache, GFB_INIT_NONE, 0, NAME_BLOCK_SIZE, NULL );
						nameoffset_temp += 4096;
					} while( name_block != EOFBLOCK );
				}
			}
 // symbol not defined
#ifdef DEBUG_CONVERT_DIRECTORY
			if( !_os_ScanDirectory( vol, NULL, FIRST_DIR_BLOCK, NULL, NULL, 0 ) ) {
				 lprintf( "Directory scan in close failed" );
				DebugBreak();
				//return ;
			}
			if( l.fileCount_old > l.fileCount ) {
				BLOCKINDEX x;
				lprintf( "This convert operation lost files. %d %d", l.fileCount_old, l.fileCount );
				if( !_os_ScanDirectory( vol, NULL, FIRST_DIR_BLOCK, &x, NULL, 0 ) ) {
					 lprintf( "Directory scan in close failed" );
					DebugBreak();
					//return ;
				}
				DebugBreak();
			}
			lprintf( "total files:%d", l.fileCount );
			l.fileCount_old = l.fileCount;
#endif
  // a set of names has been moved out of this block.
			break;
			// has block.
		}
	} while( 0 );
	// unlink here
	// unlink dirblock->names_first_block
}
static struct directory_entry * _os_GetNewDirectory( struct sack_vfs_os_volume *vol,
#if defined( _MSC_VER )
	_In_
#endif
	const char * filename
		, struct sack_vfs_os_file *file ) {
	size_t n;
	//const char *_filename = filename;
	static char leadin[256];
	static int leadinDepth = 0;
	BLOCKINDEX this_dir_block = FIRST_DIR_BLOCK;
	//struct directory_entry *next_entries;
	//LOGICAL moveMark = FALSE;
	if( filename && filename[0] == '.' && ( filename[1] == '/' || filename[1] == '\\' ) ) filename += 2;
	leadinDepth = 0;
	do {
		enum block_cache_entries cache;
		FPI dirblockFPI;
		int usedNames;
		struct directory_hash_lookup_block *dirblock;
		BLOCKINDEX firstNameBlock;
		cache = BC( DIRECTORY );
		dirblock = BTSEEK( struct directory_hash_lookup_block *, vol, this_dir_block, DIR_BLOCK_SIZE, cache );
#ifdef _DEBUG
		if( !dirblock->names_first_block ) {
			if( dirblock->used_names )
				DebugBreak();
			{
				enum block_cache_entries newcache = BC( NAMES );
				dirblock->names_first_block = _os_GetFreeBlock( vol, &newcache, GFB_INIT_NAMES, NAME_BLOCK_SIZE );
			}
			dirblock->used_names = 0;
		}
#endif
		dirblockFPI = vol->bufferFPI[cache];
		firstNameBlock = dirblock->names_first_block;
		{
			BLOCKINDEX nextblock = dirblock->next_block[(unsigned)filename[0]];
			if( nextblock ) {
				leadin[leadinDepth++] = filename[0];
				filename++;
				this_dir_block = nextblock;
				// retry;
				continue;
			}
		}
		usedNames = dirblock->used_names;
		//lprintf( " --------------- THIS DIR BLOCK ---------------" );
		if( usedNames == VFS_DIRECTORY_ENTRIES ) {
			ConvertDirectory( vol, leadin, leadinDepth, this_dir_block, dirblock, &cache );
			/* retry */
#ifdef DEBUG_DIRECTORIES
			lprintf( "----- CONVERTED-------" );
			_os_dumpDirectories( vol, this_dir_block, 1 );
			lprintf( "----- CONVERTED (ALL)-------" );
			_os_dumpDirectories( vol, 0, 1 );
#endif
			continue;
		}
		{
			struct directory_entry *ent;
			FPI name_ofs;
			//BLOCKINDEX first_blk;
			//next_entries = dirblock->entries;
			ent = dirblock->entries;
			for( n = 0; USS_LT( n, size_t, usedNames, int ); n++ ) {
				ent = dirblock->entries + (n);
				name_ofs = ( ent->name_offset ) & DIRENT_NAME_OFFSET_OFFSET;
				//first_blk = ent->first_block;
				// not name_offset (end of list) or not first_block(free entry) use this entry
				//if( name_ofs && (first_blk > 1) )  continue;
				if( _os_MaskStrCmp( vol, filename, firstNameBlock, name_ofs, 0 ) < 0 ) {
					int m;
#ifdef DEBUG_FILE_OPEN
					LoG( "Insert new directory" );
#endif
					for( m = dirblock->used_names; SUS_GT( m, int, n, size_t ); m-- ) {
						struct memoryTimelineNode node;
						dirblock->entries[m].filesize      = dirblock->entries[m - 1].filesize      ;
						dirblock->entries[m].first_block   = dirblock->entries[m - 1].first_block   ;
						dirblock->entries[m].name_offset   = dirblock->entries[m - 1].name_offset   ;
						reloadTimeEntry( &node, vol, dirblock->entries[m - 1].timelineEntry VTReadWrite GRTENoLog DBG_SRC );
						dirblock->entries[m].timelineEntry = dirblock->entries[m - 1].timelineEntry;
#ifdef DEBUG_TIMELINE_DIR_TRACKING
						LoG( "direntry at %d  %d is time %d", (int)this_dir_block, (int)m, (int)dirblock->entries[m].timelineEntry );
#endif
						node.disk->dirent_fpi = dirblockFPI + sane_offsetof( struct directory_hash_lookup_block, entries[m] );
						{
							uint64_t index = node.disk->priorTime;
							while( index ) {
								struct memoryTimelineNode time2;
								reloadTimeEntry( &time2, vol, index VTReadWrite GRTENoLog DBG_SRC );
								time2.disk->dirent_fpi = node.disk->dirent_fpi;
#ifdef DEBUG_TIMELINE_DIR_TRACKING
								LoG( "(Move)Set timeline %d to %d", (int)time2.index, (int)time2.disk->dirent_fpi );
#endif
								updateTimeEntry( &time2, vol, TRUE DBG_SRC );
								index = time2.disk->priorTime;
							}
						}
#ifdef DEBUG_TIMELINE_DIR_TRACKING
						lprintf( "Set timeline %d to %d", (int)node.index, (int)node.disk->dirent_fpi );
#endif
						updateTimeEntry( &node, vol, TRUE DBG_SRC );
					}
					dirblock->used_names++;
					break;
				}
			}
			ent = dirblock->entries + (n);
			if( n == usedNames ) {
				dirblock->used_names = (uint8_t)((n + 1));
			}
			if( dirblock->used_names > ( sizeof( dirblock->entries ) / sizeof( dirblock->entries[0] ) ) ) {
				lprintf( "Directory block name count is corrupt." );
				DebugBreak();
			}
			//LoG( "Get New Directory save naem:%s", filename );
			name_ofs = _os_SaveFileName( vol, firstNameBlock, filename, StrLen( filename ) );
			ent->filesize = 0;
			ent->name_offset = name_ofs;
			// have to allocate a block for the file, otherwise it would be deleted.
// first_blk;
			ent->first_block = DIR_ALLOCATING_MARK;
			{
				struct memoryTimelineNode time_;
				struct memoryTimelineNode *time = &time_;
				time_.index = 0;
				ent->timelineEntry = getTimeEntry( time, vol, 0, NULL, 0 DBG_SRC );
				// reset dirent_fpi afterward.
				time->disk->dirent_fpi = dirblockFPI + sane_offsetof( struct directory_hash_lookup_block, entries[n] );;
				// associate a time entry with this directory entry, and vice-versa.
#ifdef DEBUG_TIMELINE_DIR_TRACKING
				lprintf( "Set timeline %d to %d", (int)time->index, (int)time->disk->dirent_fpi );
#endif
#ifdef DEBUG_TIMELINE_DIR_TRACKING
				lprintf( "direntry at %d  %d is time %d", (int)this_dir_block, (int)n, (int)dirblock->entries[n].timelineEntry );
#endif
				// update drop the new entry.
				updateTimeEntry( time, vol, TRUE DBG_SRC );
			}
			if( file ) {
				int locks;
				locks = GETMASK_( vol->seglock, seglock, cache ) + 1;
				if( locks > 12 ) {
					lprintf( "Too many locks open... " );
					DebugBreak();
				}
				SETMASK_( vol->seglock, seglock, cache, locks );
				file->entry_fpi = dirblockFPI + sane_offsetof( struct directory_hash_lookup_block, entries[n] );;
				file->dir_block = this_dir_block;
				file->entry_.name_offset = ( file->entry->name_offset & DIRENT_NAME_OFFSET_OFFSET ) + vfs_os_compute_data_block( vol, dirblock->names_first_block, BC( COUNT ) );
				// the modern version only uses entry and cache; entry_fpi, dir_block above are unused; this dirent is locked into the caching subsystem.
				file->entry = ent;
				file->cache = cache;
			}
			SMUDGECACHE( vol, cache );
			return ent;
		}
	}
	while( 1 );
}
static struct sack_vfs_os_file * CPROC sack_vfs_os_openfile_internal( struct sack_vfs_os_volume *vol, const char * filename, uint64_t version, LOGICAL create ) {
//New( struct sack_vfs_os_file );
	struct sack_vfs_os_file *file = GetFromSet( VFS_OS_FILE, &l.files );
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	MemSet( file, 0, sizeof( struct sack_vfs_os_file ) );
#ifdef XX_VIRTUAL_OBJECT_STORE
	BLOCKINDEX offset;
#endif
	file->vol = vol;
 // default to internal buffer; might never have a real directory
	file->entry = &file->entry_;
	//file->sealant = NULL;
	if( filename[0] == '.' && ( filename[1] == '\\' || filename[1] == '/' ) ) filename += 2;
#ifdef DEBUG_FILE_OPEN
	LoG( "sack_vfs open %s = %p on %s", filename, file, vol->volname );
#endif
	if( filename )
		if( !_os_ScanDirectory( vol, filename, FIRST_DIR_BLOCK, NULL, file, 0 ) ) {
			if( vol->read_only ) { LoG( "Fail open: readonly" ); vol->lock = 0;
 //Deallocate( struct sack_vfs_os_file*, file );
				DeleteFromSet( VFS_OS_FILE, &l.files, file );
				return NULL;
			}
			else _os_GetNewDirectory( vol, filename, file );
		}
	if( ( file->entry->first_block != DIR_ALLOCATING_MARK ) && create ) {
		// if there is already data
		file->flags.versioned = 1;
	} else
		file->flags.versioned = 0;
 // saved for versioning really
	file->filesize_ = file->entry->filesize;
	// update to the file's first block (allocating, data, whatever)
	file->_first_block = file->block = file->entry->first_block;
  // sort of a opened for write
	if( create ) {
		// this updates the timestamp of the file, and allocates a new one
		//PDATALIST pdlTimes = CreateDataList( sizeof( uint64_t ) );
		struct sack_vfs_os_volume* vol = file->vol;
		struct memoryTimelineNode time;
		//enum block_cache_entries  timeCache = BC( TIMELINE );
		//BLOCKINDEX priorData = file->entry->first_block;
		reloadTimeEntry( &time, vol, file->entry->timelineEntry VTReadWrite GRTENoLog  DBG_SRC );
#ifdef _DEBUG
		if( !time.disk->time ) DebugBreak();
#endif
		// open oldest by default, with no prior time set...
		if( time.disk->priorTime ) {
			BLOCKINDEX priorTime = time.disk->priorTime;
			while( priorTime ) {
				enum block_cache_entries cache;
				struct storageTimelineNode* prior = getRawTimeEntry( vol, priorTime, &cache GRTENoLog DBG_SRC );
				//prior->
				priorTime = prior->priorTime;
				//priorData = prior->priorData;
				file->filesize_ = prior->priorDataSize;
				if( prior->time <= version ) break;
				dropRawTimeEntry( file->vol, cache GRTENoLog DBG_SRC );
			}
		}
		dropRawTimeEntry( vol, time.diskCache GRTENoLog DBG_SRC );
	}
	//file->filename = StrDup( filename );
	//file->fileName = !!filename;
#ifdef XX_VIRTUAL_OBJECT_STORE
 // file->entry->name_offset;
	offset = file->entry_.name_offset;
	if( ( file->entry->name_offset ) & DIRENT_NAME_OFFSET_FLAG_SEALANT ) {
		sack_vfs_os_read_internal( file, 0, &file->diskHeader, sizeof( file->diskHeader ) );
		file->header = file->diskHeader;
		file->fpi = file->header.sealant.avail + file->header.references.avail;
		{
			uint32_t sealLen = (offset & DIRENT_NAME_OFFSET_FLAG_SEALANT) >> DIRENT_NAME_OFFSET_FLAG_SEALANT_SHIFT;
			if( sealLen ) {
				file->seal = NewArray( uint8_t, sealLen );
				//file->sealantLen = sealLen;
				file->sealed = SACK_VFS_OS_SEAL_LOAD;
			}
			else {
				file->seal = NULL;
				//file->sealantLen = 0;
				file->sealed = SACK_VFS_OS_SEAL_NONE;
			}
		}
	}
#endif
	AddLink( &vol->files, file );
	vol->lock = 0;
	return file;
}
struct sack_vfs_os_file * CPROC sack_vfs_os_openfile( struct sack_vfs_os_volume *vol, const char * filename ) {
	return sack_vfs_os_openfile_internal( vol, filename, 0, FALSE );
}
static struct sack_vfs_os_file * CPROC sack_vfs_os_open( uintptr_t psvInstance, const char * filename, const char *opts ) {
	return sack_vfs_os_openfile( (struct sack_vfs_os_volume*)psvInstance, filename );
}
#ifdef XX_VIRTUAL_OBJECT_STORE
static char * getFilename( const char *objBuf, size_t objBufLen
	, char *sealBuf, size_t sealBufLen, LOGICAL owner
	, char **idBuf, size_t *idBufLen ) {
	if( sealBuf ) {
		struct random_context *signEntropy = (struct random_context *)DequeLink( &l.plqCrypters );
		char *fileKey;
		size_t keyLen;
		uint8_t outbuf[32];
		if( !signEntropy )
			signEntropy = SRG_CreateEntropy4( NULL, (uintptr_t)0 );
		if( owner ) {
			char *metakey = SRG_ID_Generator3();
			SRG_ResetEntropy( signEntropy );
			SRG_FeedEntropy( signEntropy, (const uint8_t*)metakey, 44 );
			SRG_FeedEntropy( signEntropy, (const uint8_t*)sealBuf, sealBufLen );
			SRG_GetEntropyBuffer( signEntropy, (uint32_t*)outbuf, 256 );
		}
		else {
			SRG_ResetEntropy( signEntropy );
			SRG_FeedEntropy( signEntropy, (const uint8_t*)sealBuf, sealBufLen );
			SRG_GetEntropyBuffer( signEntropy, (uint32_t*)outbuf, 256 );
		}
		SRG_ResetEntropy( signEntropy );
		SRG_FeedEntropy( signEntropy, (const uint8_t*)objBuf, objBufLen );
		SRG_FeedEntropy( signEntropy, (const uint8_t*)outbuf, 32 );
		fileKey = EncodeBase64Ex( outbuf, 32, &keyLen, (const char*)1 );
		SRG_GetEntropyBuffer( signEntropy, (uint32_t*)outbuf, 256 );
		SRG_DestroyEntropy( &signEntropy );
		idBuf[0] = EncodeBase64Ex( outbuf, 256 / 8, idBufLen, (const char *)1 );
		EnqueLink( &l.plqCrypters, signEntropy );
		return fileKey;
	}
	else {
		idBuf[0] = SRG_ID_Generator3();
		idBufLen[0] = 42;
		return idBuf[0];
	}
}
#endif
int CPROC sack_vfs_os_exists( struct sack_vfs_os_volume *vol, const char * file ) {
	LOGICAL result;
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
	if( file[0] == '.' && file[1] == '/' ) file += 2;
	result = _os_ScanDirectory( vol, file, FIRST_DIR_BLOCK, NULL, NULL, 0 );
	vol->lock = 0;
	return result;
}
size_t CPROC sack_vfs_os_tell( struct sack_vfs_os_file *file ) { return (size_t)file->fpi; }
size_t CPROC sack_vfs_os_size( struct sack_vfs_os_file *file ) {	return (size_t)(file->filesize_); }
size_t CPROC sack_vfs_os_seek_internal( struct sack_vfs_os_file *file, size_t pos, int whence )
{
	FPI old_fpi = file->fpi;
	if( whence == SEEK_SET ) file->fpi = pos;
	if( whence == SEEK_CUR ) file->fpi += pos;
	if( whence == SEEK_END ) file->fpi = ( file->filesize_  ) + pos;
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	{
		if( file->fpi >= old_fpi ) {
			FPI dist = file->fpi - old_fpi;
			if( dist > 4096 ) {
				do {
					int blockSize;
					if( file->fpi <= old_fpi ) {
						file->vol->lock = 0;
 // block in file can accept data now...
						return (size_t)file->fpi;
					}
					enum block_cache_entries gnbCache = BC( FILE );
					file->block = vfs_os_GetNextBlock( file->vol, file->block, &gnbCache, GFB_INIT_NONE
						, TRUE
						, dist>4096?4096:dist<2048? BLOCK_SMALL_SIZE :4096
						, &blockSize );
					old_fpi += blockSize;
				} while( 1 );
			}
		}
	}
	{
		size_t n = 0;
///aa
		BLOCKINDEX b = file->_first_block;
		while( n < ( pos ) ) {
			enum block_cache_entries cache;
			int bs;
			size_t dist = pos-n;
			cache = BC( FILE );
			if( b == DIR_ALLOCATING_MARK )
				file->entry->first_block
					= file->_first_block
					= b
					= _os_GetFreeBlock( file->vol, &cache, GFB_INIT_NONE, bs=(dist > 4096 ? 4096 : dist < 2048 ? BLOCK_SMALL_SIZE : 4096) );
			else
				b = vfs_os_GetNextBlock( file->vol, b, &cache, GFB_INIT_NONE, TRUE, dist>4096?4096:dist<2048? BLOCK_SMALL_SIZE :4096, &bs );
			n += bs;
		}
		file->block = b;
	}
	file->vol->lock = 0;
	return (size_t)file->fpi;
}
size_t CPROC sack_vfs_os_seek( struct sack_vfs_os_file* file, size_t pos, int whence ) {
	return sack_vfs_os_seek_internal( (struct sack_vfs_os_file*) file, pos, whence );
}
size_t CPROC sack_vfs_os_write_internal( struct sack_vfs_os_file* file, const void* data_, size_t length
		, POINTER writeState ) {
	const char* data = (const char*)data_;
	size_t written = 0;
	size_t ofs = file->fpi & BLOCK_MASK;
	LOGICAL updated = FALSE;
#ifdef DEBUG_DISK_DATA
	lprintf( "Write to %p %d at %d", data_, length, file->fpi );
	LogBinary( data, file->blockSize );
#endif
#ifdef XX_VIRTUAL_OBJECT_STORE
	uint8_t* cdata;
	size_t cdataLen;
	if( file->readKey && !file->fpi ) {
		enum block_cache_entries cache;
		struct storageTimelineNode* time = getRawTimeEntry( file->vol, file->entry->timelineEntry, &cache GRTENoLog DBG_SRC );
		SRG_XSWS_encryptData( (uint8_t*)data, length, time->time
			, (const uint8_t*)file->readKey, file->readKeyLen
			, &cdata, &cdataLen );
		dropRawTimeEntry( file->vol, cache GRTENoLog DBG_SRC );
		data = (const char*)cdata;
		length = cdataLen;
	}
	else {
		cdata = NULL;
	}
#endif
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	if( file->entry->first_block != DIR_ALLOCATING_MARK )
		if( file->flags.versioned )
		{
			// if versioned, but no limit, just do this.
			if( file->entry->name_offset & DIRENT_NAME_OFFSET_VERSIONS ) {
				// if there's a limit to the number of versions
			}
			{
				int last = file->blockChainLength - 1;
				enum block_cache_entries cache;
				struct storageTimelineNode* timeline = getRawTimeEntry( file->vol, file->entry->timelineEntry, &cache GRTENoLog DBG_SRC );
				timeline->priorDataPad = (uint16_t)( file->blockChain[last].size - ( file->entry->filesize & ( file->blockChain[last].size - 1 ) ) );
				//timeline->priorData = file->entry->first_block;
				timeline->priorData = file->entry->first_block;
				timeline->priorDataSize = file->entry->filesize;
				file->entry->first_block = DIR_ALLOCATING_MARK;
				file->entry->filesize = 0;
				file->filesize_ = 0;
				file->blockChainLength = 0;
				dropRawTimeEntry( file->vol, cache GRTENoLog DBG_SRC );
			}
			//lprintf( "this needs to result with the new timestamp" );
			//file->entry->timelineEntry = file->entry->timelineEntry;
			updated = TRUE;
		} else {
			// no versioning - so just keep 1 block so we get last write and first create
			if( !( file->entry->name_offset & DIRENT_NAME_OFFSET_VERSIONS ) ) {
				// don't have a new time block for write time; so create one
				file->entry->timelineEntry = updateTimeEntryTime( NULL, file->vol, file->entry->timelineEntry, TRUE, NULL, 0 DBG_SRC );
				file->entry->name_offset |= 1 << DIRENT_NAME_OFFSET_VERSION_SHIFT;
			}
			else {
				// update the current time.
				file->entry->timelineEntry = updateTimeEntryTime( NULL, file->vol, file->entry->timelineEntry, FALSE, NULL, 0 DBG_SRC );
			}
			//file->entry->timelineEntry = file->timeline.index;
			updated = TRUE;
		}
#ifdef XX_VIRTUAL_OBJECT_STORE
	if( (file->entry->name_offset) & DIRENT_NAME_OFFSET_FLAG_SEALANT ) {
		char* filename;
		size_t filenameLen = 64;
		// read-only data block.
		lprintf( "INCOMPLETE - TODO WRITE PATCH" );
		char* sealer = getFilename( data, length, (char*)file->sealant, file->header.sealant.used, IS_OWNED( file ), &filename, &filenameLen );
		struct sack_vfs_os_file* pFile = (struct sack_vfs_os_file*)sack_vfs_os_openfile( file->vol, filename );
		pFile->sealant = (uint8_t*)sealer;
		if( cdata ) Release( cdata );
		return sack_vfs_os_write_internal( pFile, data, length, (POINTER)1 );
	}
#endif
#ifdef DEBUG_FILE_OPS
	LoG( "Write to file %p %" _size_f "  @%" _size_f, file, length, ofs );
#endif
	if( ofs ) {
		enum block_cache_entries cache = BC( FILE );
		uint8_t* block = (uint8_t*)vfs_os_BSEEK( file->vol, file->block, length > 4096 ? 4096 : length < 2048 ? BLOCK_SMALL_SIZE : 4096, &cache );
		int blockSize = file->vol->sector_size[cache];
		if( length >= (blockSize - (ofs)) ) {
			memcpy( block + ofs, data, blockSize-ofs );
			SMUDGECACHE( file->vol, cache );
			data += blockSize - ofs;
			written += blockSize - ofs;
			file->fpi += blockSize - ofs;
			if( file->fpi > (file->entry->filesize) ) {
				file->filesize_ = file->entry->filesize = file->fpi;
				updated = TRUE;
			}
			length -= blockSize - ofs;
			cache = BC( FILE );
			// the following code is never run anyway, it's always a get next block...
			if( file->block == DIR_ALLOCATING_MARK )
				file->entry->first_block
				= file->_first_block
				= file->block
				= _os_GetFreeBlock( file->vol, &cache, GFB_INIT_NONE, length > 4096 ? 4096 : length < 2048 ? BLOCK_SMALL_SIZE : 4096 );
			else
				file->block = vfs_os_GetNextBlock( file->vol, file->block, &cache, GFB_INIT_NONE, TRUE
					,
#ifdef XX_VIRTUAL_OBJECT_STORE
					file->blockSize
						? file->blockSize
						:
#endif
					(length>4096)?4096:length<2048? BLOCK_SMALL_SIZE :4096, (int*)&blockSize );
		}
		else {
			memcpy( block+ofs, data, length );
			SMUDGECACHE( file->vol, cache );
			data += length;
			written += length;
			file->fpi += length;
			if( file->fpi > (file->entry->filesize) ) {
				file->filesize_ = file->entry->filesize = file->fpi;
				updated = TRUE;
			}
			length = 0;
		}
	}
	// if there's still length here, FPI is now on the start of blocks
	while( length ) {
		enum block_cache_entries cache = BC( FILE );
		uint8_t* block = (uint8_t*)vfs_os_BSEEK( file->vol, file->block,
			/*
#ifdef XX_VIRTUAL_OBJECT_STORE
			file->blockSize
			? file->blockSize
			:
#endif
			*/
			length > 4096 ? 4096 : length < 2048 ? BLOCK_SMALL_SIZE : 4096, &cache );
		unsigned int blockSize = file->vol->sector_size[cache];
		if( file->block == DIR_ALLOCATING_MARK ) {
  // directy now has a real block.
			updated = TRUE;
			// this are data blocks...
			file->block = file->entry->first_block = (
				( file->vol->segment[cache] - 2 ) / BLOCKS_PER_SECTOR ) * BLOCKS_PER_BAT
				+ ( ( file->vol->segment[cache] - 1 - ( 1+ ( file->vol->segment[cache] - 1 ) / BLOCKS_PER_SECTOR ) ) % BLOCKS_PER_BAT );
				//- 1 /* minus first BAT */;
			//lprintf( "computed new file block %d from %d", (int)file->block, (int)file->vol->segment[cache] );
		}
#ifdef _DEBUG
		if( file->block < 2 ) DebugBreak();
#endif
		if( length >= blockSize ) {
			memcpy( block, data, blockSize );
			SMUDGECACHE( file->vol, cache );
			data += blockSize;
			written += blockSize;
			file->fpi += blockSize;
			if( file->fpi > ( file->entry->filesize  ) ) {
				updated = TRUE;
				file->filesize_ = file->entry->filesize = file->fpi ;
			}
			length -= blockSize;
			cache = BC( FILE );
			file->block = vfs_os_GetNextBlock( file->vol, file->block, &cache, GFB_INIT_NONE, TRUE
				,
#ifdef XX_VIRTUAL_OBJECT_STORE
				file->blockSize
				? file->blockSize
				:
#endif
				(length>4096)?4096:length<2048?BLOCK_SMALL_SIZE:4096, (int*)&blockSize );
		}
		else {
			memcpy( block, data, length );
			SMUDGECACHE( file->vol, cache );
			data += length;
			written += length;
			file->fpi += length;
			if( file->fpi > (file->entry->filesize ) ) {
				updated = TRUE;
				file->filesize_ = file->entry->filesize = file->fpi ;
			}
			length = 0;
		}
	}
#if 0
	if( !writeState && file->sealant && (void*)file->sealant != (void*)data ) {
		flushFileSuffix( file );
		BLOCKINDEX saveSize = file->entry->filesize;
		BLOCKINDEX saveFpi = file->fpi;
		sack_vfs_os_write_internal( file, (char*)file->sealant, file->header.sealant.used, (POINTER)1 );
		file->entry->filesize = saveSize;
		file->fpi = saveFpi;
	}
#endif
	if( updated ) {
		SMUDGECACHE( file->vol, file->cache );
	}
	//if( cdata ) Release( cdata );
	//if( !writeState )
	file->vol->lock = 0;
	return written;
}
size_t CPROC sack_vfs_os_write( struct sack_vfs_os_file *file, const void * data_, size_t length ) {
	return sack_vfs_os_write_internal( (struct sack_vfs_os_file* )file, data_, length, NULL );
}
#ifdef XX_VIRTUAL_OBJECT_STORE
static enum sack_vfs_os_seal_states ValidateSeal( struct sack_vfs_os_file *file, char *data, size_t length ) {
	BLOCKINDEX offset = (file->entry->name_offset );
	uint32_t sealLen = (offset & DIRENT_NAME_OFFSET_FLAG_SEALANT) >> DIRENT_NAME_OFFSET_FLAG_SEALANT_SHIFT;
// = (struct random_context *)DequeLink( &signingEntropies );
	struct random_context *signEntropy;
	uint8_t outbuf[32];
	signEntropy = SRG_CreateEntropy4( NULL, (uintptr_t)0 );
	SRG_ResetEntropy( signEntropy );
	SRG_FeedEntropy( signEntropy, (const uint8_t*)file->sealant, file->header.sealant.used );
	SRG_GetEntropyBuffer( signEntropy, (uint32_t*)outbuf, 256 );
	if( (file->header.sealant.used != 32) || MemCmp( outbuf, file->sealant, 32 ) )
		return SACK_VFS_OS_SEAL_INVALID;
	SRG_ResetEntropy( signEntropy );
	SRG_FeedEntropy( signEntropy, (const uint8_t*)data, length );
	// DO NOT DOUBLE_PROCESS THIS DATA
	SRG_FeedEntropy( signEntropy, (const uint8_t*)file->sealant, file->header.sealant.used );
	SRG_GetEntropyBuffer( signEntropy, (uint32_t*)outbuf, 256 );
	SRG_DestroyEntropy( &signEntropy );
	{
		enum sack_vfs_os_seal_states success = SACK_VFS_OS_SEAL_INVALID;
		size_t len;
		char *rid = EncodeBase64Ex( outbuf, 256 / 8, &len, (const char *)1 );
		//if( StrCmp( file->filename, rid ) == 0 )
		//	success = SACK_VFS_OS_SEAL_VALID;
		Deallocate( char *, rid );
		return success;
	}
}
#endif
size_t CPROC sack_vfs_os_read_internal( struct sack_vfs_os_file *file, uint64_t version, void * data_, size_t length ) {
	char* data = (char*)data_;
	size_t written = 0;
	size_t ofs = file->fpi & BLOCK_MASK;
#ifdef XX_VIRTUAL_OBJECT_STORE
	if( (file->entry->name_offset ) & DIRENT_NAME_OFFSET_FLAG_READ_KEYED ) {
		if( !file->readKey ) return 0;
	}
#endif
	if( ( file->filesize_ ) < ( file->fpi + length ) ) {
		if( ( file->filesize_ ) < file->fpi )
			length = 0;
		else
			length = (size_t)(( file->filesize_ ) - file->fpi);
	}
	if( !length || file->block == EOFBLOCK ) {  return 0; }
	if( ofs ) {
		enum block_cache_entries cache = BC(FILE);
		uint8_t* block = (uint8_t*)vfs_os_BSEEK( file->vol, file->block, 0, &cache );
		int blockSize = file->vol->sector_size[cache];
		if( length >= ( blockSize - ( ofs ) ) ) {
			memcpy( data, block+ofs, blockSize-ofs );
			written += blockSize - ofs;
			data += blockSize - ofs;
			length -= blockSize - ofs;
			file->fpi += blockSize - ofs;
			cache = BC( FILE );
			file->block = vfs_os_GetNextBlock( file->vol, file->block, &cache, GFB_INIT_NONE, FALSE, 0, &blockSize );
#ifdef _DEBUG
			if( file->block == EOFBLOCK ) {
				lprintf( "bad read - file data too short" );
				DebugBreak();
			}
#endif
		} else {
			memcpy( data, block + ofs, length );
			written += length;
			file->fpi += length;
			length = 0;
		}
	}
	// if there's still length here, FPI is now on the start of blocks
	while( length ) {
		enum block_cache_entries cache = BC(FILE);
		uint8_t* block = (uint8_t*)vfs_os_BSEEK( file->vol, file->block, 0, &cache );
		unsigned int blockSize = file->vol->sector_size[cache];
		if( length >= blockSize ) {
			memcpy( data, block, blockSize - ofs );
			written += blockSize;
			data += blockSize;
			length -= blockSize;
			file->fpi += blockSize;
			cache = BC( FILE );
			file->block = vfs_os_GetNextBlock( file->vol, file->block, &cache, GFB_INIT_NONE, FALSE, 0, (int*)&blockSize );
#ifdef _DEBUG
			if( file->block == EOFBLOCK ) {
				lprintf( "bad read - file data too short" );
				DebugBreak();
			}
#endif
		} else {
			memcpy( data, block, length );
			written += length;
			file->fpi += length;
			length = 0;
		}
	}
#ifdef XX_VIRTUAL_OBJECT_STORE
	if( file->readKey
 //entry->filesize ) )
	   && ( file->fpi == ( file->filesize_ ) )
	   && ( (file->entry->name_offset)
	      & DIRENT_NAME_OFFSET_FLAG_READ_KEYED) )
	{
		uint8_t *outbuf;
		size_t outlen;
		enum block_cache_entries cache;
		struct storageTimelineNode* time = getRawTimeEntry( file->vol, file->entry->timelineEntry, &cache GRTENoLog DBG_SRC );
		SRG_XSWS_decryptData( (uint8_t*)data, written, time->time
		                    , (const uint8_t*)file->readKey, file->readKeyLen
		                    , &outbuf, &outlen );
		dropRawTimeEntry( file->vol, cache GRTENoLog DBG_SRC );
		memcpy( data, outbuf, outlen );
		Release( outbuf );
		written = outlen;
	}
	if( file->sealant
		&& (void*)file->sealant != (void*)data
 //file->entry->filesize ) ) {
		&& length == ( file->filesize_ ) ) {
		BLOCKINDEX saveSize = file->entry->filesize;
		BLOCKINDEX saveFpi = file->fpi;
		file->entry->filesize = ((file->entry->filesize
			) + file->header.sealant.used + sizeof( BLOCKINDEX ))
			;
		sack_vfs_os_read_internal( file, 0, (char*)file->sealant, file->header.sealant.used );
		file->entry->filesize = saveSize;
		file->fpi = saveFpi;
		file->sealed = ValidateSeal( file, data, length );
	}
#endif
	return written;
}
size_t CPROC sack_vfs_os_read( struct sack_vfs_os_file* file, void* data_, size_t length ) {
	size_t result;
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	result = sack_vfs_os_read_internal( (struct sack_vfs_os_file*)file, 0, data_, length );
	file->vol->lock = 0;
	return result;
}
#ifdef XX_VIRTUAL_OBJECT_STORE
static BLOCKINDEX sack_vfs_os_read_patches( struct sack_vfs_os_file *file ) {
	size_t written = 0;
	BLOCKINDEX saveFpi = file->fpi;
	size_t length;
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
//entry->filesize);
	length = (size_t)(file->filesize_ );
	if( !length ) { file->vol->lock = 0; return 0; }
	sack_vfs_os_seek_internal( file, length, SEEK_SET );
#if 0
	if( file->sealant ) {
		BLOCKINDEX saveSize = file->entry->filesize;
		BLOCKINDEX patches;
		//WriteIntoBlock( file, 0, 0, file->sealant, file->header.sealant.used );
		file->entry->filesize = saveSize;
		file->fpi = saveFpi;
		file->sealed = SACK_VFS_OS_SEAL_LOAD;
		return patches;
	}
#endif
	file->vol->lock = 0;
	return written;
}
static size_t sack_vfs_os_set_patch_block( struct sack_vfs_os_file *file, BLOCKINDEX patchBlock ) {
	size_t written = 0;
	size_t length;
	BLOCKINDEX saveFpi = file->fpi;
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	length = (size_t)(file->entry->filesize);
	if( !length ) { file->vol->lock = 0; return 0; }
	sack_vfs_os_seek_internal( file, length, SEEK_SET );
	if( file->header.sealant.avail ) {
		sack_vfs_os_seek_internal( file, file->header.sealant.used, SEEK_CUR );
		sack_vfs_os_write_internal( file, (char*)&patchBlock, sizeof( BLOCKINDEX ), NULL );
		file->fpi = saveFpi;
	} else {
		BLOCKINDEX saveSize = file->entry->filesize;
		sack_vfs_os_seek_internal( file, file->header.sealant.used, SEEK_CUR );
		sack_vfs_os_write_internal( file, (char*)&patchBlock, sizeof( BLOCKINDEX ), NULL );
		file->fpi = saveFpi;
	}
	file->vol->lock = 0;
	return written;
}
static size_t sack_vfs_os_set_reference_block( struct sack_vfs_os_file *file, BLOCKINDEX patchBlock ) {
	size_t written = 0;
	size_t length;
	BLOCKINDEX saveFpi = file->fpi;
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	length = (size_t)(file->entry->filesize);
	if( !length ) { file->vol->lock = 0; return 0; }
	sack_vfs_os_seek_internal( file, length, SEEK_SET );
	if( file->sealant ) {
		sack_vfs_os_seek_internal( file, file->header.sealant.used, SEEK_CUR );
		sack_vfs_os_write_internal( file, (char*)&patchBlock, sizeof( BLOCKINDEX ), NULL );
		file->fpi = saveFpi;
	}
	else {
		sack_vfs_os_seek_internal( file, file->header.sealant.used, SEEK_CUR );
		sack_vfs_os_write_internal( file, (char*)&patchBlock, sizeof( BLOCKINDEX ), NULL );
		file->fpi = saveFpi;
	}
	file->vol->lock = 0;
	return written;
}
#endif
static void sack_vfs_os_unlink_file_entry( struct sack_vfs_os_volume *vol, struct sack_vfs_os_file *dirinfo, BLOCKINDEX first_block, LOGICAL deleted ) {
	//FPI entFPI, struct directory_entry *entry, struct directory_entry *entkey
	BLOCKINDEX block, _block;
	struct sack_vfs_os_file *file_found = NULL;
	struct sack_vfs_os_file *file;
	INDEX idx;
	LIST_FORALL( vol->files, idx, struct sack_vfs_os_file *, file ) {
		if( file->_first_block == first_block ) {
			file_found = file;
			file->delete_on_close = TRUE;
		}
	}
	if( !deleted ) {
		// delete the file entry now; this disk entry may be reused immediately.
		dirinfo->entry_.first_block = dirinfo->_first_block;
		dirinfo->_first_block = dirinfo->entry->first_block = 0;
		SMUDGECACHE( vol, dirinfo->cache );
	}
	if( !file_found ) {
		_block = block = first_block;
#ifdef DEBUG_DIRECTORIES
		LoG( "(marking physical deleted (again?)) entry starts at %d", block );
#endif
		// wipe out file chain BAT
		if( first_block != DIR_ALLOCATING_MARK )
			do {
				enum block_cache_entries cache = BC(BAT);
				enum block_cache_entries fileCache = BC(DATAKEY);
				BLOCKINDEX *this_BAT = (BLOCKINDEX*)vfs_os_block_index_SEEK( vol, ( ( block / BLOCKS_PER_BAT ) * ( BLOCKS_PER_SECTOR ) ), 0, &cache );
				uint8_t* blockData = (uint8_t*)vfs_os_BSEEK( vol, block, 0, &fileCache );
				//LoG( "Clearing file datablock...%p", (uintptr_t)blockData - (uintptr_t)vol->disk );
				memset( blockData, 0, vol->sector_size[fileCache] );
				// after seek, block was read, and file position updated.
				SMUDGECACHE( vol, fileCache );
				SMUDGECACHE( vol, cache );
				//lprintf( "clear block %d %d %d ", (int)block, (int)( block% BLOCKS_PER_BAT ), (int)(block/BLOCKS_PER_BAT) );
				enum block_cache_entries gnbCache = BC( ZERO );
				block = vfs_os_GetNextBlock( vol, block, &gnbCache, GFB_INIT_NONE, FALSE, vol->sector_size[fileCache], NULL );
				this_BAT[_block % BLOCKS_PER_BAT] = 0;
				if( vol->sector_size[fileCache] == BLOCK_SMALL_SIZE )
					AddDataItem( &vol->pdlFreeSmallBlocks, &_block );
				else
					AddDataItem( &vol->pdlFreeBlocks, &_block );
				LoG( "unlink storing free block:%d", _block );
				_block = block;
			} while( block != EOFBLOCK );
		// this deletes the allocated name
		// it also removes the directory entry from list of entries
 // timelineEntry type is larger than index in some configurations; but won't exceed those bounds
		deleteTimelineIndex( vol, (BLOCKINDEX)dirinfo->entry->timelineEntry );
		deleteDirectoryEntryName( vol, dirinfo, dirinfo->entry->name_offset & DIRENT_NAME_OFFSET_OFFSET, dirinfo->cache, dirinfo->dir_block );
	}
}
static void _os_shrinkBAT( struct sack_vfs_os_file *file ) {
	struct sack_vfs_os_volume *vol = file->vol;
	BLOCKINDEX block, _block;
	size_t bsize = 0;
	int smallBlocks = 0;
	int nBlock = 0;
  // no data blocks already.
	if( file->entry->first_block == EOFBLOCK ) return;
	_block = block = file->entry->first_block;
	do {
		enum block_cache_entries cache = BC(BAT);
		enum block_cache_entries data_cache = BC( FILE );
		//lprintf( " block %d %d %d ", (int)block, (int)( block % BLOCKS_PER_BAT ), (int)( block / BLOCKS_PER_BAT ) );
		BLOCKINDEX *this_BAT = (BLOCKINDEX*)vfs_os_block_index_SEEK( vol, ( ( block / BLOCKS_PER_BAT ) * ( BLOCKS_PER_SECTOR) ), 0, &cache );
		if( !this_BAT[block % BLOCKS_PER_BAT] ) {
			lprintf( "This file is already deleted..." );
			return;
		}
		enum block_cache_entries gnbCache = BC( FILE );
		block = vfs_os_GetNextBlock( vol, block, &gnbCache, GFB_INIT_NONE, FALSE, BAT_BLOCK_SIZE, NULL );
		if( bsize >= (file->entry->filesize) ) {
#ifdef VFS_OS_PARANOID_TRUNCATE
			uint8_t* blockData = (uint8_t*)vfs_os_BSEEK( file->vol, _block, 0, &data_cache );
			memset( blockData, 0, file->vol->sector_size[data_cache] );
			//LoG( "clearing a datablock after a file..." );
#endif
			//lprintf( "Should be able to unlink this... extra block of data %d", (int)_block );
			if( vol->sector_size[data_cache] == BLOCK_SMALL_SIZE )
				AddDataItem( &vol->pdlFreeSmallBlocks, &_block );
			else
				AddDataItem( &vol->pdlFreeBlocks, &_block );
#ifdef DEBUG_FILE_TRUNCATE
			LoG( "shrink storing free block:%d", _block );
#endif
			this_BAT[_block % BLOCKS_PER_BAT] = 0;
		} else {
			if( this_BAT[BLOCKS_PER_BAT] ) {
				smallBlocks++;
				bsize += BLOCK_SMALL_SIZE;
			} else
				bsize += 4096;
			if( bsize > (file->entry->filesize) ) {
				uint8_t* blockData = (uint8_t*)vfs_os_BSEEK( file->vol, _block, 0, &data_cache );
				int blockSize = file->vol->sector_size[data_cache];
				//LoG( "clearing a partial datablock after a file..., %d, %d", blockSize-(file->entry->filesize & (blockSize-1)), ( file->entry->filesize & (blockSize-1)) );
#ifdef VFS_OS_PARANOID_TRUNCATE
				memset( blockData + (file->entry->filesize & (blockSize-1)), 0, blockSize-(file->entry->filesize & (blockSize-1)) );
#endif
				//this_BAT[_block % BLOCKS_PER_BAT] = 0;
			}
			else if( file->entry->filesize )
				nBlock++;
		}
		_block = block;
	} while( block != EOFBLOCK );
	if( !file->entry->filesize ) {
		file->_first_block = file->block = file->entry->first_block = EOFBLOCK;
#ifdef DEBUG_FILE_TRUNCATE
		LoG( "Truncated file block chain length is now:%d", nBlock );
#endif
		file->blockChainLength = nBlock;
	}
	if( smallBlocks > ( 4096 / BLOCK_SMALL_SIZE ) * 2 ) {
		lprintf( "File has lots of fragments, consider defragmenting its small blocks" );
	}
}
size_t CPROC sack_vfs_os_truncate_internal( struct sack_vfs_os_file *file ) {
	if( file->entry->filesize != file->fpi ) {
		file->filesize_ = file->entry->filesize = file->fpi;
		_os_shrinkBAT( file );
		SMUDGECACHE( file->vol, file->cache );
	}
	return (size_t)file->fpi;
}
size_t CPROC sack_vfs_os_truncate( struct sack_vfs_os_file* file ) {
	size_t result;
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	result = sack_vfs_os_truncate_internal( (struct sack_vfs_os_file*)file );
	file->vol->lock = 0;
	return result;
}
int sack_vfs_os_close_internal( struct sack_vfs_os_file *file, int unlock ) {
#ifdef DEBUG_TRACE_LOG
#  ifdef DEBUG_FILE_OPS
	{
		enum block_cache_entries cache = BC(NAMES);
		static char fname[256];
		FPI name_ofs = file->entry_.name_offset;
		// this following line needs to be updated.
		//FPI base = (const char *)
		//char const *filename = (char const *)vfs_os_DSEEK( file->vol, name_ofs, 0, &cache ); // have to do the seek to the name block otherwise it might not be loaded.
		_os_MaskStrCpy( fname, sizeof( fname ), file->vol, cache, name_ofs );
		LoG( "close file:%s(%p)", fname, file );
	}
#  endif
#endif
	DeleteLink( &file->vol->files, file );
	if( file->delete_on_close ) sack_vfs_os_unlink_file_entry( file->vol, file, file->_first_block, TRUE );
	{
		INDEX idx;
		struct sack_vfs_file * testFile;
		LIST_FORALL( file->vol->files, idx, struct sack_vfs_file *, testFile ) {
			if( testFile->cache == file->cache )
				break;
		}
		if( !testFile ) {
			int locks = GETMASK_( file->vol->seglock, seglock, file->cache );
			if( !locks ) {
				lprintf( "Underflow file locks... " );
				DebugBreak();
			}
			locks--;
			SETMASK_( file->vol->seglock, seglock, file->cache, locks );
		}
	}
	//Deallocate( char *, file->filename );
#ifdef XX_VIRTUAL_OBJECT_STORE
	if( file->sealant )
		Deallocate( uint8_t*, file->sealant );
#endif
	if( file->vol->closed ) sack_vfs_os_unload_volume( file->vol );
	if( unlock ) file->vol->lock = 0;
	DeleteFromSet( VFS_OS_FILE, &l.files, file );
	//Deallocate( struct sack_vfs_os_file *, file );
	return 0;
}
int CPROC sack_vfs_os_close( struct sack_vfs_os_file* file ) {
	while( LockedExchange( &file->vol->lock, 1 ) ) Relinquish();
	int status = sack_vfs_os_close_internal( (struct sack_vfs_os_file*) file, TRUE );
	return status;
}
int CPROC sack_vfs_os_unlink_file( struct sack_vfs_os_volume *vol, const char * filename ) {
	int result = 0;
	struct sack_vfs_os_file tmp_dirinfo;
	if( !vol ) return 0;
	while( LockedExchange( &vol->lock, 1 ) ) Relinquish();
#ifdef DEBUG_DIRECTORIES
	LoG( "unlink file:%s", filename );
#endif
	if( _os_ScanDirectory( vol, filename, FIRST_DIR_BLOCK, NULL, &tmp_dirinfo, 0 ) ) {
		sack_vfs_os_unlink_file_entry( vol, &tmp_dirinfo, tmp_dirinfo.entry->first_block, FALSE );
		{
			int locks = GETMASK_( vol->seglock, seglock, tmp_dirinfo.cache );
			if( !locks ) {
				lprintf( "File locks underflowed" );
				DebugBreak();
			}
			else locks--;
			SETMASK_( vol->seglock, seglock, tmp_dirinfo.cache, locks );
		}
		result = 1;
	}
	vol->lock = 0;
	return result;
}
	/* noop */
int CPROC sack_vfs_os_flush( struct sack_vfs_os_file *file ) {	return 0; }
static LOGICAL CPROC sack_vfs_os_need_copy_write( void ) {	return FALSE; }
struct sack_vfs_os_find_info * CPROC sack_vfs_os_find_create_cursor(uintptr_t psvInst,const char *base,const char *mask )
{
	struct sack_vfs_os_find_info *info = New( struct sack_vfs_os_find_info );
	info->pds_directories = CreateDataStack( sizeof( struct hashnode ) );
	info->base = base;
	info->base_len = StrLen( base );
	info->mask = mask;
	info->vol = (struct sack_vfs_os_volume *)psvInst;
	info->leadinDepth = 0;
	return (struct sack_vfs_os_find_info*)info;
}
static int _os_iterate_find( struct sack_vfs_os_find_info *_info ) {
	struct sack_vfs_os_find_info *info = (struct sack_vfs_os_find_info *)_info;
	struct directory_hash_lookup_block *dirBlock;
	struct directory_entry *next_entries;
	int n;
	do
	{
		enum block_cache_entries cache = BC(DIRECTORY);
		enum block_cache_entries name_cache = BC(NAMES);
		struct hashnode node = ((struct hashnode *)PopData( &info->pds_directories ))[0];
		dirBlock = BTSEEK( struct directory_hash_lookup_block *, info->vol, node.this_dir_block, 0, cache );
		if( !node.thisent ) {
			struct hashnode subnode;
			subnode.thisent = 0;
			for( n = 254; n >= 0; n-- ) {
				BLOCKINDEX block = dirBlock->next_block[n];
				if( block ) {
					memcpy( subnode.leadin, node.leadin, node.leadinDepth );
					subnode.leadin[node.leadinDepth] = (char)n;
					subnode.leadinDepth = node.leadinDepth + 1;
					subnode.leadin[subnode.leadinDepth] = 0;
					subnode.this_dir_block = block;
					PushData( &info->pds_directories, &subnode );
				}
			}
		}
		//lprintf( "%p ledin : %*.*s %d", node, node.leadinDepth, node.leadinDepth, node.leadin, node.leadinDepth );
		next_entries = dirBlock->entries;
		for( n = (int)node.thisent; n < (dirBlock->used_names ); n++ ) {
			FPI name_ofs = ( next_entries[n].name_offset ) & DIRENT_NAME_OFFSET_OFFSET;
			FPI name_ofs_ = name_ofs;
			const char *filename, *filename_;
			int l;
			struct memoryTimelineNode time;
			//enum block_cache_entries  timeCache = BC( TIMELINE );
			reloadTimeEntry( &time, info->vol, (next_entries[n].timelineEntry) VTReadWrite GRTENoLog  DBG_SRC );
			if( !time.disk->time ) DebugBreak();
			if( time.disk->priorTime )
			{
				enum block_cache_entries cache;
				struct storageTimelineNode* prior = getRawTimeEntry( info->vol, time.disk->priorTime, &cache GRTENoLog DBG_SRC );
				while( prior->priorTime ) prior = getRawTimeEntry( info->vol, prior->priorTime, &cache GRTENoLog DBG_SRC );
				info->ctime = (prior->time/1000000)<<8 | prior->timeTz;
			}
			else
				info->ctime = (time.disk->time / 1000000) << 8 | time.disk->timeTz;
			info->wtime = (time.disk->time / 1000000) << 8 | time.disk->timeTz;
			dropRawTimeEntry( info->vol, time.diskCache GRTENoLog DBG_SRC );
			// if file is deleted; don't check it's name.
			info->filesize = (size_t)(next_entries[n].filesize);
			if( (name_ofs) > info->vol->dwSize ) {
				lprintf( "corrupted volume." );
				return 0;
			}
			name_cache = BC( NAMES );
			filename = (const char *)vfs_os_FSEEK( info->vol, NULL, dirBlock->names_first_block, name_ofs, &name_cache, NAME_BLOCK_SIZE DBG_SRC );
			filename_ = filename;
			info->filenamelen = 0;
			for( l = 0; l < node.leadinDepth; l++ ) info->filename[info->filenamelen++] = node.leadin[l];
			if( info->vol->key ) {
				int c;
				do {
					while( ((name_ofs & ~BLOCK_MASK) == (name_ofs_ & ~BLOCK_MASK))
						&& (((c = ((uint8_t*)filename)[0] )) != UTF8_EOT)
						) {
						info->filename[info->filenamelen++] = c;
						filename++;
						name_ofs++;
					}
					if( ((name_ofs & ~BLOCK_MASK) == (name_ofs_ & ~BLOCK_MASK)) ) {
						name_cache = BC( NAMES );
						filename = (const char *)vfs_os_FSEEK( info->vol, NULL, dirBlock->names_first_block, name_ofs, &name_cache, NAME_BLOCK_SIZE DBG_SRC );
						name_ofs_ = name_ofs;
						continue;
					}
					break;
				} while( 1 );
				info->filename[info->filenamelen]	 = 0;
				//LoG( "Scan return filename: %s", info->filename );
				if( info->base
				    && ( info->base[0] != '.' && info->base_len != 1 )
				    && StrCaseCmpEx( info->base, info->filename, info->base_len ) )
					continue;
			} else {
				int c;
				do {
					while(
						((name_ofs&~BLOCK_MASK) == (name_ofs_ & ~BLOCK_MASK))
						&& ((c = (((uint8_t*)filename)[0])) != UTF8_EOT)
						) {
						info->filename[info->filenamelen++] = c;
						filename_ = filename;
						filename++;
						name_ofs++;
					}
					if( ((((uintptr_t)filename)&~BLOCK_MASK) != (((uintptr_t)filename_)&~BLOCK_MASK)) ) {
						name_cache = BC( NAMES );
						filename = (const char*)vfs_os_FSEEK( info->vol, NULL, dirBlock->names_first_block, name_ofs, &name_cache, NAME_BLOCK_SIZE DBG_SRC );
						name_ofs_ = name_ofs;
						continue;
					}
					break;
				}
				while( 1 );
				info->filename[info->filenamelen] = 0;
#ifdef DEBUG_FILE_SCAN
				LoG( "Scan return filename: %s", info->filename );
#endif
				if( info->base
				    && ( info->base[0] != '.' && info->base_len != 1 )
				    && StrCaseCmpEx( info->base, info->filename, info->base_len ) )
					continue;
			}
			node.thisent = n + 1;
			PushData( &info->pds_directories, &node );
			return 1;
		}
	}
	while( info->pds_directories->Top );
	return 0;
}
int CPROC sack_vfs_os_find_first( struct sack_vfs_os_find_info *_info ) {
	struct sack_vfs_os_find_info *info = (struct sack_vfs_os_find_info *)_info;
	struct hashnode root;
	root.this_dir_block = 0;
	root.leadinDepth = 0;
	root.thisent = 0;
	PushData( &info->pds_directories, &root );
	//info->thisent = 0;
	return _os_iterate_find( _info );
}
int CPROC sack_vfs_os_find_close( struct sack_vfs_os_find_info *_info ) {
	struct sack_vfs_os_find_info *info = (struct sack_vfs_os_find_info *)_info;
	Deallocate( struct sack_vfs_os_find_info*, info ); return 0; }
int CPROC sack_vfs_os_find_next( struct sack_vfs_os_find_info *_info ) { return _os_iterate_find( _info ); }
char * CPROC sack_vfs_os_find_get_name( struct sack_vfs_os_find_info *_info ) {
	struct sack_vfs_os_find_info *info = (struct sack_vfs_os_find_info *)_info;
	return info->filename; }
size_t CPROC sack_vfs_os_find_get_size( struct sack_vfs_os_find_info *_info ) {
	struct sack_vfs_os_find_info *info = (struct sack_vfs_os_find_info *)_info;
	return info->filesize; }
LOGICAL CPROC sack_vfs_os_find_is_directory( struct sack_vfs_os_find_info *cursor ) { return FALSE; }
LOGICAL CPROC sack_vfs_os_is_directory( uintptr_t psvInstance, const char *path ) {
	if( path[0] == '.' && path[1] == 0 ) return TRUE;
	{
		struct sack_vfs_os_volume *vol = (struct sack_vfs_os_volume *)psvInstance;
		if( _os_ScanDirectory( vol, path, FIRST_DIR_BLOCK, NULL, NULL, 1 ) ) {
			return TRUE;
		}
	}
	return FALSE;
}
uint64_t CPROC sack_vfs_os_find_get_ctime( struct sack_vfs_os_find_info *_info ) {
	struct sack_vfs_os_find_info *info = (struct sack_vfs_os_find_info *)_info;
	if( info ) return info->ctime;
	return 0;
}
uint64_t CPROC sack_vfs_os_find_get_wtime( struct sack_vfs_os_find_info *_info ) {
	struct sack_vfs_os_find_info *info = (struct sack_vfs_os_find_info *)_info;
	if( info ) return info->wtime;
	return 0;
}
LOGICAL CPROC sack_vfs_os_rename( uintptr_t psvInstance, const char *original, const char *newname ) {
	//struct sack_vfs_os_volume *vol = (struct sack_vfs_os_volume *)psvInstance;
	lprintf( "RENAME IS NOT SUPPORTED IN OBJECT STORAGE(OR NEEDS TO BE FIXED)" );
	// fail if the names are the same.
	return TRUE;
}
uintptr_t CPROC sack_vfs_os_file_ioctl_internal( struct sack_vfs_os_file* file, uintptr_t opCode, va_list args ) {
	//va_list args;
	//va_start( args, opCode );
	switch( opCode ) {
	default:
		// unhandled/ignored opcode
		return FALSE;
		break;
	case SOSFSFIO_DESTROY_INDEX:
	{
		//const char* indexname = va_arg( args, const char* );
		break;
	}
	case SOSFSFIO_CREATE_INDEX:
	{
		//const char* indexname = va_arg( args, const char* );
		//size_t indexnameLen = va_arg( args, size_t );
		lprintf( "Indexes should be implemented higher..." );
		//enum jsox_value_types type = va_arg( args, enum jsox_value_types );
		//int typeExtra = va_arg( args, int );
		//struct memoryStorageIndex* index = allocateIndex( file, indexname, indexnameLen );
		//file->
/*index*/
		return (uintptr_t)0;
		break;
	}
	case SOSFSFIO_ADD_INDEX_ITEM:
	{
		//struct memoryStorageIndex* index = (struct memoryStorageIndex*)va_arg( args, uintptr_t );
		//struct sack_vfs_os_file *reference = va_arg( args, struct sack_vfs_os_file* );
		//struct jsox_value_container * value = va_arg( args, struct jsox_value_container* );
		//file->
		break;
	}
	case SOSFSFIO_REMOVE_INDEX_ITEM:
	{
		//const char* indexname = va_arg( args, const char* );
		//file->
		break;
	}
	case SOSFSFIO_ADD_REFERENCE:
	{
		//const char* indexname = va_arg( args, const char* );
		//file->
		break;
	}
	case SOSFSFIO_REMOVE_REFERENCE:
	{
		//const char* indexname = va_arg( args, const char* );
		//file->
		break;
	}
	case SOSFSFIO_ADD_REFERENCE_BY:
	{
		//const char* indexname = va_arg( args, const char* );
		//file->
		break;
	}
	case SOSFSFIO_REMOVE_REFERENCE_BY:
	{
		//const char* indexname = va_arg( args, const char* );
		//file->
		break;
	}
	case SOSFSFIO_TAMPERED:
	{
		//struct sack_vfs_file *file = (struct sack_vfs_file *)psvInstance;
#ifdef XX_VIRTUAL_OBJECT_STORE
		int *result = va_arg( args, int* );
		if( file->sealant ) {
			switch( file->sealed ) {
			case SACK_VFS_OS_SEAL_STORE:
			case SACK_VFS_OS_SEAL_VALID:
				(*result) = 1;
            break;
			default:
				(*result) = 0;
			}
		}
		else
			(*result) = 1;
#endif
	}
	break;
	case SOSFSFIO_PROVIDE_SEALANT:
#ifdef XX_VIRTUAL_OBJECT_STORE
	{
		const char *sealant = va_arg( args, const char * );
		size_t sealantLen = va_arg( args, size_t );
		lprintf( "This should be a higher level thing." );
		//struct sack_vfs_file *file = (struct sack_vfs_file *)psvInstance;
		{
			size_t len;
			if( file->sealant )
				Release( file->sealant );
			file->sealant = (uint8_t*)DecodeBase64Ex( sealant, sealantLen, &len, (const char*)1 );
			_os_SetSmallBlockUsage( &file->header.sealant, (uint8_t)len );
			//_os_UpdateFileBlocks( file );
			if( file->sealed == SACK_VFS_OS_SEAL_NONE )
				file->sealed = SACK_VFS_OS_SEAL_STORE;
			else if( file->sealed == SACK_VFS_OS_SEAL_VALID || file->sealed == SACK_VFS_OS_SEAL_LOAD )
				file->sealed = SACK_VFS_OS_SEAL_STORE_PATCH;
			else
				lprintf( "Unhandled SEAL state." );
			//file->sealant = sealant;
			//file->sealantLen = sealantLen;
			// set the sealant length in the name offset.
			file->entry->name_offset = (((file->entry->name_offset)
				| ((len >> 2) << 17)) );
		}
	}
#endif
	break;
	case SOSFSFIO_PROVIDE_READKEY:
#ifdef XX_VIRTUAL_OBJECT_STORE
	{
		const char *sealant = va_arg( args, const char * );
		size_t sealantLen = va_arg( args, size_t );
		//struct sack_vfs_file *file = (struct sack_vfs_file *)psvInstance;
		{
			size_t len;
			if( file->readKey )
				Release( file->readKey );
			file->readKey = (uint8_t*)DecodeBase64Ex( sealant, sealantLen, &len, (const char*)1 );
			file->readKeyLen = (uint16_t)len;
			// set the sealant length in the name offset.
			file->entry->name_offset = (((file->entry->name_offset )
				| DIRENT_NAME_OFFSET_FLAG_READ_KEYED) );
		}
	}
#endif
	break;
	case SOSFSFIO_SET_TIME:
	{
		uint64_t timestamp = va_arg( args, uint64_t );
		int8_t tz = (uint8_t)va_arg( args, int );
		return sack_vfs_os_set_time( file, timestamp, tz );
	}
	break;
	case SOSFSFIO_GET_TIME:
	{
		//uint64_t** timeArray = va_arg( args, uint64_t** );
		//int8_t** tzArray = va_arg( args, int8_t** );
		//size_t* timeCount  = va_arg( args, size_t* );
		return file->entry->timelineEntry;
	}
	break;
	case SOSFSFIO_GET_TIMES:
	{
		uint64_t** timeArray = va_arg( args, uint64_t** );
		int8_t** tzArray = va_arg( args, int8_t** );
		size_t* timeCount  = va_arg( args, size_t* );
		return sack_vfs_os_get_times( file, timeArray, tzArray, timeCount );
	}
	break;
 // automatic managment is good enough?
	case SOSFSFIO_SET_BLOCKSIZE:
	{
		//int size = va_arg( args, int );
		//file->blockSize = size;
	}
	break;
	}
	return TRUE;
}
uintptr_t CPROC sack_vfs_os_file_ioctl_interface( uintptr_t psvInstance, uintptr_t opCode, va_list args ) {
	return sack_vfs_os_file_ioctl_internal( (struct sack_vfs_os_file*)psvInstance, opCode, args );
}
uintptr_t CPROC sack_vfs_os_file_ioctl( struct sack_vfs_os_file *psvInstance, uintptr_t opCode, ... ) {
	va_list args;
	va_start( args, opCode );
	return sack_vfs_os_file_ioctl_internal( (struct sack_vfs_os_file*)psvInstance, opCode, args );
}
uintptr_t CPROC sack_vfs_os_system_ioctl_internal( struct sack_vfs_os_volume *vol, uintptr_t opCode, va_list args ) {
	//va_list args;
	//va_start( args, opCode );
	switch( opCode ) {
	default:
		// unhandled/ignored opcode
		return FALSE;
	case SOSFSSIO_OPEN_VERSION:
		{
			const char * name;name = va_arg( args, const char* );
			uint64_t version = va_arg( args, uint64_t );
			return (uintptr_t)sack_vfs_os_openfile_internal( vol, name, version, FALSE );
		}
		break;
	case SOSFSSIO_NEW_VERSION:
		{
			const char * name;name = va_arg( args, const char* );
			return (uintptr_t)sack_vfs_os_openfile_internal( vol, name, 0, TRUE );
		}
		break;
	case SOSFSSIO_OPEN_TIMELINE:
		{
			return (uintptr_t)sack_vfs_os_get_time_cursor( vol );
		}
		break;
	case SOSFSSIO_READ_TIMELINE:
		{
			struct sack_vfs_os_time_cursor* cursor;cursor = va_arg(args, struct sack_vfs_os_time_cursor* );
			int step = va_arg( args, int );
			uint64_t timestamp; timestamp = va_arg( args, uint64_t );
			uint64_t* result_entry; result_entry = va_arg( args, uint64_t* );
			const char ** filename;filename = va_arg( args, const char ** );
			uint64_t* timestamp_result;timestamp_result = va_arg( args, uint64_t* );
			int8_t* tz_result;tz_result = va_arg( args, int8_t* );
			const char** buffer;buffer = va_arg( args, const char** );
			size_t* size_result;size_result = va_arg( args, size_t* );
			sack_vfs_os_read_time_cursor( cursor, step, timestamp, result_entry, filename, timestamp_result, tz_result, buffer, size_result );
			return TRUE;
		}
		break;
	case SOSFSSIO_LOAD_OBJECT:
		return FALSE;
	case SOSFSSIO_PATCH_OBJECT:
		{
		//LOGICAL owner;owner = va_arg( args, LOGICAL );  // seal input is a constant, generate random meta key
		//char *objIdBuf;objIdBuf = va_arg( args, char * );
		/*
		size_t objIdBufLen = va_arg( args, size_t );
		char *patchAuth = va_arg( args, char * );
		size_t patchAuthLen = va_arg( args, size_t );
		char *objBuf = va_arg( args, char * );
		size_t objBufLen = va_arg( args, size_t );
		char *sealBuf = va_arg( args, char * );
		size_t sealBufLen = va_arg( args, size_t );
		char *keyBuf = va_arg( args, char * );
		size_t keyBufLen = va_arg( args, size_t );
		char *idBuf = va_arg( args, char * );
		size_t idBufLen = va_arg( args, size_t );
		*/
#ifdef XX_VIRTUAL_OBJECT_STORE
		if( sack_vfs_os_exists( vol, objIdBuf ) ) {
			struct sack_vfs_os_file* file = (struct sack_vfs_os_file*)sack_vfs_os_openfile( vol, objIdBuf );
			BLOCKINDEX patchBlock = sack_vfs_os_read_patches( file );
			enum block_cache_entries cacheSomething = BC(FILE);
			if( !patchBlock ) {
				patchBlock = _os_GetFreeBlock( vol, &cacheSomething, GFB_INIT_PATCHBLOCK, 4096 );
			}
			{
				enum block_cache_entries cache;
				struct directory_patch_block *newPatchblock;
				cache = BC(FILE);
				newPatchblock = BTSEEK( struct directory_patch_block *, vol, patchBlock, DIR_BLOCK_SIZE, cache );
				while( 1 ) {
					//char objId[45];
					//size_t objIdLen;
					char *seal = getFilename( objBuf, objBufLen, sealBuf, sealBufLen, FALSE, &idBuf, &idBufLen );
					if( sack_vfs_os_exists( vol, idBuf ) ) {
 // accidental key collision.
						if( !sealBuf ) {
 // try again.
							continue;
						}
						else {
							// deliberate key collision; and record already exists.
							return TRUE;
						}
					}
					else {
						struct sack_vfs_os_file* file = (struct sack_vfs_os_file*)sack_vfs_os_openfile( vol, idBuf );
						//  file->entry_fpi
						newPatchblock->entries[newPatchblock->usedEntries].raw
							= file->entry_fpi;
						newPatchblock->usedEntries = (newPatchblock->usedEntries + 1);
						SMUDGECACHE( vol, cache );
						file->sealant = (uint8_t*)seal;
						_os_SetSmallBlockUsage( &file->header.sealant, (uint8_t)strlen( seal ) );
						//_os_UpdateFileBlocks( file );
						sack_vfs_os_seek_internal( file, (size_t)GetBlockStart( file, FILE_BLOCK_DATA ), SEEK_SET );
						sack_vfs_os_write_internal( file, objBuf, objBufLen, 0 );
						sack_vfs_os_close_internal( file, FALSE );
					}
					return TRUE;
				}
			}
		}
#endif
 // object to patch was not found.
		return FALSE;
	}
	break;
	case SOSFSSIO_STORE_OBJECT:
	#if 0
	{
  // seal input is a constant, generate random meta key
		LOGICAL owner = va_arg( args, LOGICAL );
		char *objBuf = va_arg( args, char * );
		size_t objBufLen = va_arg( args, size_t );
  // provided for re-write; provided also for private named objects
		char *objIdBuf = va_arg( args, char * );
		size_t objIdBufLen = va_arg( args, size_t );
  // user provided sealant if any
		char *sealBuf = va_arg( args, char * );
		size_t sealBufLen = va_arg( args, size_t );
  // encryption key
		char *keyBuf = va_arg( args, char * );
		size_t keyBufLen = va_arg( args, size_t );
  // output buffer
		char **idBuf = va_arg( args, char ** );
		size_t *idBufLen = va_arg( args, size_t* );
		while( 1 ) {
			char *seal = getFilename( objBuf, objBufLen, sealBuf, sealBufLen, owner, idBuf, idBufLen );
			if( sack_vfs_os_exists( vol, idBuf[0] ) ) {
 // accidental key collision.
				if( !sealBuf ) {
 // try again.
					continue;
				}
				else {
					// deliberate key collision; and record already exists.
					return TRUE;
				}
			}
			else {
				struct sack_vfs_os_file* file = (struct sack_vfs_os_file*)sack_vfs_os_openfile( vol, idBuf[0] );
#ifdef XX_VIRTUAL_OBJECT_STORE
				if( sealBuf ) {
					file->sealant = (uint8_t*)seal;
					_os_SetSmallBlockUsage( &file->header.sealant, (uint8_t)strlen( seal ) );
					WriteIntoBlock( file, 0, 0, seal, strlen( seal ) );
					//file->sealantLen = (uint8_t)strlen( seal );
				} else {
					file->sealant = NULL;
					_os_SetSmallBlockUsage( &file->header.sealant, 0 );
					//file->sealantLen = 0;
				}
#endif
				sack_vfs_os_write_internal( file, objBuf, objBufLen, NULL );
				sack_vfs_os_close_internal( file, FALSE );
			}
			return TRUE;
		}
	}
#endif
	break;
	}
	return 0;
}
uintptr_t CPROC sack_vfs_os_system_ioctl_interface( uintptr_t psvInstance, uintptr_t opCode, va_list args ) {
	return sack_vfs_os_system_ioctl_internal( (struct sack_vfs_os_volume*)psvInstance, opCode, args );
}
uintptr_t CPROC sack_vfs_os_system_ioctl( struct sack_vfs_os_volume* vol, uintptr_t opCode, ... ) {
	va_list args;
	va_start( args, opCode );
	return sack_vfs_os_system_ioctl_internal( vol, opCode, args );
}
LOGICAL sack_vfs_os_get_times( struct sack_vfs_os_file* file, uint64_t** timeArray, int8_t** tzArray, size_t* timeCount ) {
	if( !timeArray ) return TRUE;
	struct s_scratchTime {
		uint64_t scratchTime;
		uint8_t scratchTz;
	} scratch;
	PDATALIST pdlTimes = CreateDataList( sizeof( scratch ) );
	struct sack_vfs_os_volume* vol = file->vol;
	struct memoryTimelineNode time;
	//enum block_cache_entries  timeCache = BC( TIMELINE );
	reloadTimeEntry( &time, vol, file->entry->timelineEntry VTReadWrite GRTENoLog  DBG_SRC );
	if( !time.disk->time ) DebugBreak();
	scratch.scratchTime = time.disk->time;
	scratch.scratchTz = time.disk->timeTz;
	AddDataItem( &pdlTimes, &scratch );
	if( time.disk->priorTime ) {
		BLOCKINDEX priorTime = time.disk->priorTime;
		while( priorTime ) {
			enum block_cache_entries cache;
			struct storageTimelineNode* prior = getRawTimeEntry( vol, priorTime, &cache GRTENoLog DBG_SRC );
			scratch.scratchTime = prior->time;
			scratch.scratchTz = prior->timeTz;
			priorTime = prior->priorTime;
			dropRawTimeEntry( file->vol, cache GRTENoLog DBG_SRC );
			AddDataItem( &pdlTimes, &scratch );
		}
	}
	dropRawTimeEntry( vol, time.diskCache GRTENoLog DBG_SRC );
	timeArray[0] = NewArray( uint64_t, pdlTimes->Cnt );
	tzArray[0] = NewArray( int8_t, pdlTimes->Cnt );
	{
		struct s_scratchTime* st;
		INDEX idx;
		DATA_FORALL( pdlTimes, idx, struct s_scratchTime*, st ) {
			timeArray[0][idx] = st->scratchTime;
			tzArray[0][idx] = st->scratchTz;
		}
	}
	//MemCpy( timeArray[0], pdlTimes->data, pdlTimes->Cnt * sizeof( timeArray[0] ) );
	timeCount[0] = pdlTimes->Cnt;
	DeleteDataList( &pdlTimes );
	return TRUE;
}
LOGICAL sack_vfs_os_set_time( struct sack_vfs_os_file* file, uint64_t timeVal, int8_t tz ) {
	struct sack_vfs_os_volume* vol = file->vol;
	struct memoryTimelineNode time;
	//enum block_cache_entries  timeCache = BC( TIMELINE );
	reloadTimeEntry( &time, vol, file->entry->timelineEntry VTReadWrite GRTENoLog  DBG_SRC );
	//int tz = timeVal & 0xFF;
	//timeVal = ( timeVal >> 8 ) * 1000000LL;
	return setTimeEntryTime( &time, vol, timeVal, tz );
}
LOGICAL sack_vfs_os_halt( struct sack_vfs_os_volume* volume ) {
	LOGICAL prior = volume->flags.halted;
	volume->flags.halted = TRUE;
	return prior;
}
#ifndef USE_STDIO
static struct file_system_interface sack_vfs_os_fsi = {
                                                     (void*(CPROC*)(uintptr_t,const char *, const char*))sack_vfs_os_open
                                                   , (int(CPROC*)(void*))sack_vfs_os_close
                                                   , (size_t(CPROC*)(void*,void*,size_t))sack_vfs_os_read
                                                   , (size_t(CPROC*)(void*,const void*,size_t))sack_vfs_os_write
                                                   , (size_t(CPROC*)(void*,size_t,int))sack_vfs_os_seek
                                                   , (void(CPROC*)(void*))sack_vfs_os_truncate
                                                   , (int(CPROC*)(uintptr_t,const char*))sack_vfs_os_unlink_file
                                                   , (size_t(CPROC*)(void*))sack_vfs_os_size
                                                   , (size_t(CPROC*)(void*))sack_vfs_os_tell
                                                   , (int(CPROC*)(void*))sack_vfs_os_flush
                                                   , (int(CPROC*)(uintptr_t,const char*))sack_vfs_os_exists
                                                   , sack_vfs_os_need_copy_write
                                                   , (struct find_cursor*(CPROC*)(uintptr_t,const char *,const char *))             sack_vfs_os_find_create_cursor
                                                   , (int(CPROC*)(struct find_cursor*))             sack_vfs_os_find_first
                                                   , (int(CPROC*)(struct find_cursor*))             sack_vfs_os_find_close
                                                   , (int(CPROC*)(struct find_cursor*))             sack_vfs_os_find_next
                                                   , (char*(CPROC*)(struct find_cursor*))           sack_vfs_os_find_get_name
                                                   , (size_t(CPROC*)(struct find_cursor*))          sack_vfs_os_find_get_size
                                                   , (LOGICAL(CPROC*)(struct find_cursor*))         sack_vfs_os_find_is_directory
                                                   , (LOGICAL(CPROC*)(uintptr_t, const char*))      sack_vfs_os_is_directory
                                                   , (LOGICAL(CPROC*)(uintptr_t, const char*, const char*))sack_vfs_os_rename
                                                   , (uintptr_t(CPROC*)(uintptr_t, uintptr_t, va_list))sack_vfs_os_file_ioctl_interface
												   , (uintptr_t(CPROC*)(uintptr_t, uintptr_t, va_list))sack_vfs_os_system_ioctl_interface
	, (uint64_t( CPROC*)(struct find_cursor* cursor)) sack_vfs_os_find_get_ctime
	, (uint64_t( CPROC* )(struct find_cursor* cursor)) sack_vfs_os_find_get_wtime
};
PRIORITY_PRELOAD( Sack_VFS_OS_Register, CONFIG_SCRIPT_PRELOAD_PRIORITY - 2 )
{
#undef DEFAULT_VFS_NAME
#ifdef ALT_VFS_NAME
#   define DEFAULT_VFS_NAME SACK_VFS_FILESYSTEM_NAME "-os.runner"
#else
#   define DEFAULT_VFS_NAME SACK_VFS_FILESYSTEM_NAME "-os"
#endif
	sack_register_filesystem_interface( DEFAULT_VFS_NAME, &sack_vfs_os_fsi );
}
PRIORITY_PRELOAD( Sack_VFS_OS_RegisterDefaultFilesystem, SQL_PRELOAD_PRIORITY + 1 ) {
	if( SACK_GetProfileInt( GetProgramName(), "SACK/VFS/Mount FS VFS", 0 ) ) {
		struct sack_vfs_os_volume *vol;
		TEXTCHAR volfile[256];
		TEXTSTR tmp;
		SACK_GetProfileString( GetProgramName(), "SACK/VFS/OS File", "*/../assets.os", volfile, 256 );
		tmp = ExpandPath( volfile );
		vol = sack_vfs_os_load_volume( tmp, NULL );
		Deallocate( TEXTSTR, tmp );
		sack_mount_filesystem( "sack_shmem-os", sack_get_filesystem_interface( DEFAULT_VFS_NAME )
		                     , 900, (uintptr_t)vol, TRUE );
	}
}
#endif
#ifdef __cplusplus
}
#endif
#ifdef USE_STDIO
#  undef sack_fopen
#  undef sack_fseek
#  undef sack_fclose
#  undef sack_fread
#  undef sack_fwrite
#  undef sack_ftell
#  undef free
#  undef StrDup
#  define StrDup(o) StrDupEx( (o) DBG_SRC )
#endif
#undef free
SACK_VFS_NAMESPACE_END
#undef l
#endif
#undef SACK_VFS_SOURCE
#undef SACK_VFS_OS_SOURCE
#ifdef _MSC_VER
// integer partial expresions summed into 64 bit.
#  pragma warning( default: 26451 )
#endif
#ifdef _WIN64
#ifndef __64__
#define __64__
#endif
#endif
#ifdef WIN32
#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x501
#endif
#endif
// debugging only gets you the ordering(priority) logging and something else...
// useful logging is now controlled with l.flags.bLog
#define DISABLE_DEBUG_REGISTER_AND_DISPATCH
//#define DEBUG_SHUTDOWN
//#define DEBUG_ATEXIT
#define LOG_ALL 0
//
// core library load
//    all procs scheduled, initial = 0
// Application starts, invokes preloads
//    additional libraries load, scheduling because of suspend
//    library load completes by invoking the newly registered list
// final core application schedulging happens, after initial preload completes
//    additional preload scheduligin happens( not suspended, is initial)
//#define DEBUG_CYGWIN_START
//#ifndef __LINUX__
#define IS_DEADSTART
#ifdef __LINUX__
#include <signal.h>
#endif
#ifdef WIN32
 // GetConsoleWindow()
#include <wincon.h>
#endif
#ifdef __NO_BAG__
#undef lprintf
#define lprintf printf
#define BAG_Exit exit
#else
#endif
#ifdef __LINUX__
#endif
typedef struct startup_proc_tag {
	DeclareLink( struct startup_proc_tag );
	int bUsed;
	int priority;
	void (CPROC*proc)(void);
	CTEXTSTR func;
#ifdef _DEBUG
	CTEXTSTR file;
	int line;
#endif
} STARTUP_PROC, *PSTARTUP_PROC;
typedef struct shutdown_proc_tag {
	DeclareLink( struct shutdown_proc_tag );
	int bUsed;
	int priority;
	void (CPROC*proc)(void);
	CTEXTSTR func;
#ifdef _DEBUG
	CTEXTSTR file;
	int line;
#endif
} SHUTDOWN_PROC, *PSHUTDOWN_PROC;
struct deadstart_local_data_
{
	// this is a lot of procs...
	int nShutdownProcs;
#ifdef __LINUX__
	LOGICAL registerdSigint ;
	struct sigaction prior_sigint;
#endif
#define nShutdownProcs l.nShutdownProcs
	SHUTDOWN_PROC shutdown_procs[512];
#define shutdown_procs l.shutdown_procs
	int bInitialDone;
#define bInitialDone l.bInitialDone
	LOGICAL bInitialStarted;
#define bInitialStarted l.bInitialStarted
	int bSuspend;
#define bSuspend l.bSuspend
	int bDispatched;
//#define bDispatched l.bDispatched
	PSHUTDOWN_PROC shutdown_proc_schedule;
#define shutdown_proc_schedule l.shutdown_proc_schedule
 // count of used procs...
	int nProcs;
#define nProcs l.nProcs
	STARTUP_PROC procs[1024];
#define procs l.procs
	PSTARTUP_PROC proc_schedule;
#define proc_schedule l.proc_schedule
	struct
	{
		BIT_FIELD bInitialized : 1;
		BIT_FIELD bLog : 1;
	} flags;
};
//#define lprintf(f,...) printf(f "\n",##__VA_ARGS__)
//#define _lprintf(n) lprintf
#ifdef UNDER_CE
#define LockedExchange InterlockedExchange
#endif
#ifndef __STATIC_GLOBALS__
#  ifdef __cplusplus
extern "C" {
#  endif
	IMPORT_METHOD struct deadstart_local_data_* GetDeadstartSharedGlobal( void );
#  ifdef __cplusplus
}
#  endif
#endif
SACK_DEADSTART_NAMESPACE
//#undef PRELOAD
EXPORT_METHOD void RunDeadstart( void );
#ifdef __STATIC_GLOBALS__
struct deadstart_local_data_ deadstart_local_data;
#  define l (deadstart_local_data)
#else
static struct deadstart_local_data_ *deadstart_local_data;
#  define l (*deadstart_local_data)
#endif
EXPORT_METHOD void RunExits( void )
{
#ifdef DEBUG_ATEXIT
	fprintf( stderr, "Run Exits InvokeExits()\n" );
#endif
	InvokeExits();
}
static void InitLocal( void )
{
#ifndef __STATIC_GLOBALS__
	if( !deadstart_local_data ) deadstart_local_data = GetDeadstartSharedGlobal();
#endif
	if( !l.flags.bInitialized )
	{
		l.flags.bInitialized = 1;
	}
}
#ifndef  DISABLE_DEBUG_REGISTER_AND_DISPATCH
#define ENQUE_STARTUP_DBG_SRC DBG_SRC
static void EnqueStartupProc( PSTARTUP_PROC *root, PSTARTUP_PROC proc DBG_PASS )
#else
#define ENQUE_STARTUP_DBG_SRC
static void EnqueStartupProc( PSTARTUP_PROC *root, PSTARTUP_PROC proc )
#endif
{
	PSTARTUP_PROC check;
	PSTARTUP_PROC last;
		if( proc->next || proc->me )
		{
			if( ( (*proc->me) = proc->next ) )
				proc->next->me = proc->me;
		}
		for( last = check = (*root); check; check = check->next )
		{
			// if the current one being added is less then the one in the list
			// then the one in the list becomes the new one's next...
			if( proc->priority < check->priority )
			{
#ifndef  DISABLE_DEBUG_REGISTER_AND_DISPATCH
				_lprintf(DBG_RELAY)( "%s(%d) is to run before %s and after %s first is %s"
						 , proc->func
						 , proc - procs
						 , check->func
						 , (check->me==root)?"Is First":((PSTARTUP_PROC)check->me)->func
						 , (*root)?(*root)->func:"First"
						 );
#endif
				proc->next = check;
				proc->me = check->me;
				(*check->me) = proc;
				check->me = &proc->next;
				break;
			}
			last = check;
		}
		if( !check )
		{
#ifndef  DISABLE_DEBUG_REGISTER_AND_DISPATCH
			lprintf( "%s(%d) is to run after all"
					 , proc->func
					 , proc - procs
					 );
#endif
			proc->next = NULL;
			if( last )
			{
				last->next = proc;
				proc->me = &last->next;
			}
			else
			{
				(*root) = proc;
				proc->me = root;
			}
		}
}
// parameter 4 is just used so the external code is not killed
// we don't actually do anything with this?
void RegisterPriorityStartupProc( void (CPROC*proc)(void), CTEXTSTR func,int priority, void *use_label DBG_PASS )
{
	int use_proc;
	InitLocal();
	if( LOG_ALL || (
#ifndef __STATIC_GLOBALS__
		 deadstart_local_data &&
#endif
		  l.flags.bLog ))
		lprintf( "Register %s@" DBG_FILELINEFMT_MIN " %d", func DBG_RELAY, priority);
	if( nProcs == 1024 )
	{
		for( use_proc = 0; use_proc < 1024; use_proc++ )
			if( !procs[use_proc].bUsed )
				break;
		if( use_proc == 1024 )
		{
			lprintf( "Used all 1024, and, have 1024 startups total scheduled." );
			DebugBreak();
		}
	}
	else
		use_proc = nProcs;
	procs[use_proc].proc = proc;
	procs[use_proc].func = func;
#ifdef _DEBUG
	procs[use_proc].file = pFile;
	procs[use_proc].line = nLine;
#endif
	procs[use_proc].priority = priority;
	procs[use_proc].bUsed = 1;
 // initialize so it doesn't try unlink in requeue common routine.
	procs[use_proc].next = NULL;
 // initialize so it doesn't try unlink in requeue common routine.
	procs[use_proc].me = NULL;
	EnqueStartupProc( &proc_schedule, procs + use_proc ENQUE_STARTUP_DBG_SRC );
	if( nProcs < 1024 )
		nProcs++;
	/*
	if( nProcs == 1024 )
	{
		lprintf( "Excessive number of startup procs!" );
		DebugBreak();
	}
	*/
	if( bInitialDone && !bSuspend )
	{
#ifdef _DEBUG
		_xlprintf(LOG_NOISE,pFile,nLine)( "Initial done, not suspended, dispatch immediate." );
#endif
		InvokeDeadstart();
	}
	//lprintf( "Total procs %d", nProcs );
}
#ifdef __LINUX__
// this handles the peculiarities of fork() and exit()
void ClearDeadstarts( void )
{
	// this is reserved for the sole use of
	// fork() success and then exec() failing...
	// when oh wait - __attribute__((destructor))
	// if( registered_pid != getppid() )
	shutdown_proc_schedule = NULL;
	// be rude - yes we lose resources. but everything goes away cause
	// this is just a clone..
}
#endif
static int ignoreBreak;
void IgnoreBreakHandler( int ignore) {
	ignoreBreak = ignore;
}
#ifndef UNDER_CE
#  if defined( WIN32 )
#    ifndef __cplusplus_cli
static BOOL WINAPI CtrlC( DWORD dwCtrlType )
{
	if( ignoreBreak & ( 1 << dwCtrlType ) ) return TRUE;
#ifdef DEBUG_ATEXIT
	fprintf( stderr, "Received ctrlC Event %08x %d\n", ignoreBreak, dwCtrlType );
#endif
	switch( dwCtrlType )
	{
	case CTRL_BREAK_EVENT:
	case CTRL_C_EVENT:
	case CTRL_CLOSE_EVENT:
	case CTRL_LOGOFF_EVENT:
	case CTRL_SHUTDOWN_EVENT:
		InvokeExits();
		// allow C api to exit, whatever C api we're using
		// (allows triggering atexit functions)
		//exit(3);
		break;
	}
	// default... return not processed.
 // allow others to process this too
	return FALSE;
}
#    endif
#  endif
#  ifndef WIN32
static void CtrlC( int signal, siginfo_t* siginfo, void*p )
{
	static int tries;
	static int in_self;
#ifdef DEBUG_ATEXIT
	fprintf( stderr, "linux system SIGINT... %d\n", in_self);
#endif
	if( in_self ) return;
	in_self = 1;
	if( ignoreBreak ) return;
	if( l.prior_sigint.sa_handler ) {
		if( l.prior_sigint.sa_handler == SIG_DFL ){
			fprintf( stderr, "default handler...\n");
		}
		else if( l.prior_sigint.sa_handler == SIG_IGN ){
			fprintf( stderr, "ignore handler...\n");
		}
		else if( l.prior_sigint.sa_handler ){
			if( 1 || (l.prior_sigint.sa_flags & SA_SIGINFO) )
			{
				l.prior_sigint.sa_sigaction( signal, siginfo, p );
			} else {
				l.prior_sigint.sa_handler( signal );
			}
		}
	}
	in_self = 0;
	InvokeExits();
	if( tries++ == 10 )
		exit(3);
}
#  endif
#endif
// wow no such thing as static-izing this... it's
// always retrieved with dynamic function loading, therefore
// MUST be exported if at all possible.
// this one is used when a library is loaded.
void InvokeDeadstart( void )
{
	PSTARTUP_PROC proc;
	PSTARTUP_PROC resumed_proc;
#ifndef __STATIC_GLOBALS__
 // nothing was registerd to run.
	if( !deadstart_local_data ) return;
#endif
	if( bInitialStarted )
		return;
	bInitialStarted = 1;
	// allowing initial start to be set lets final resume do this invoke.
	if( bSuspend )
	{
		if( l.flags.bLog )
 //-V595
			lprintf( "Suspended, first proc is %s", proc_schedule?proc_schedule->func:"No First" );
		return;
	}
#ifdef WIN32
	if( !bInitialDone && !l.bDispatched )
	{
#  ifndef UNDER_CE
		if( GetConsoleWindow() )
		{
			if( !SetConsoleCtrlHandler( CtrlC, TRUE ) ) fprintf( stderr, "failed to SetConsoleCtrlHandler? %lu\n", GetLastError() );
		}
		else
		{
			//MessageBox( NULL, "!!--!! NO CtrlC", "blah", MB_OK );
			// do nothing if not actually a console window. this should fix ctrl-c not working in CMD prompts launched by MILK/InterShell
		}
#  endif
	}
#else
	if( !bInitialDone && !l.bDispatched )
	{
		struct sigaction sact;
		/*
           struct sigaction {
			union{
               void     (*sa_handler)(int);
               void     (*sa_sigaction)(int, siginfo_t *, void *);
			}
               sigset_t   sa_mask;
               int        sa_flags;
               void     (*sa_restorer)(void);
           };
		*/
		if( !l.registerdSigint )
		{
			l.registerdSigint = TRUE;
			MemSet( &sact, 0, sizeof( sact ));
			sact.sa_sigaction = CtrlC;
			sigemptyset(&sact.sa_mask);
			//sigaddset( &sact.sa_mask, SIGINT );
			sact.sa_flags = SA_SIGINFO | SA_NODEFER;
			sact.sa_restorer = NULL;
			// this means I have to generate a terminate myself....
			//sigaction(SIGINT, &sact, &l.prior_sigint);
			//fprintf( stderr, "Registered sigint handler...\n");
		}
	}
#endif
	while( ( proc = (PSTARTUP_PROC)LockedExchangePtrSzVal( (PVPTRSZVAL)&proc_schedule, 0 ) ) != NULL )
	{
		// need to set this to point to new head of list... it's not in proc_schedule anymore
		//proc->me = &proc;
		if( LOG_ALL || (
#ifndef __STATIC_GLOBALS__
		   deadstart_local_data  &&
#endif
		   l.flags.bLog ))
		{
#ifdef _DEBUG
			lprintf( "Dispatch %s@%s(%d)p:%d ", proc->func,proc->file,proc->line, proc->priority );
#else
			lprintf( "Dispatch %s@p:%d ", proc->func, proc->priority );
#endif
		}
		{
			l.bDispatched = 1;
#ifdef _DEBUG
			if( proc->proc
#  ifndef __LINUX__
#    if  __WATCOMC__ >= 1280
				&& !IsBadCodePtr( (int(STDCALL*)(void))proc->proc )
#    elif defined( __64__ )
				&& !IsBadCodePtr( (FARPROC)proc->proc )
#    else
//				&& !IsBadCodePtr( (int STDCALL(*)(void))proc->proc )
#    endif
#  endif
			  )
#endif
			{
				proc->proc();
			}
			proc->bUsed = 0;
			l.bDispatched = 0;
		}
		// look to see if anything new was scheduled.  Grab the list, add it to the one's we're processing.
		{
			{
				PSTARTUP_PROC newly_scheduled_things;
				proc->me = &proc;
				resumed_proc = proc;
				if( ( newly_scheduled_things = (PSTARTUP_PROC)LockedExchangePtrSzVal( (PVPTRSZVAL)&proc_schedule, 0 ) ) != NULL )
				{
					newly_scheduled_things->me = &newly_scheduled_things;
					//lprintf( "------------------  newly scheduled startups; requeue old startups into new list ------------------ " );
					while( newly_scheduled_things )
					{
						EnqueStartupProc( &proc, newly_scheduled_things ENQUE_STARTUP_DBG_SRC );
					}
				}
				else
					resumed_proc = NULL;
			}
			proc_schedule = proc;
			proc_schedule->me = &proc_schedule;
		}
		if( resumed_proc )
			UnlinkThing( resumed_proc );
		else
			UnlinkThing( proc );
	}
	bInitialStarted = 0;
}
void MarkRootDeadstartComplete( void )
{
	bInitialDone = 1;
}
#ifndef __NO_OPTIONS__
// options initializes at SQL+1
PRIORITY_PRELOAD( InitDeadstartOptions, NAMESPACE_PRELOAD_PRIORITY+1 )
{
#ifdef DISABLE_DEBUG_REGISTER_AND_DISPATCH
#  ifndef __NO_OPTIONS
	l.flags.bLog = SACK_GetProfileIntEx( "SACK/Deadstart", "Logging Enabled?", 0, TRUE );
#  else
	l.flags.bLog = 0;
#  endif
#else
	l.flags.bLog = 1;
#endif
}
#endif
// parameter 4 is just used so the external code is not killed
// we don't actually do anything with this?
void RegisterPriorityShutdownProc( void (CPROC*proc)(void), CTEXTSTR func, int priority,void *use_label DBG_PASS )
{
	InitLocal();
	if( LOG_ALL || (
#ifndef __STATIC_GLOBALS__
		deadstart_local_data &&
#endif
		   l.flags.bLog ))
		lprintf( "Exit Proc %s(%p) from " DBG_FILELINEFMT_MIN " registered..."
				 , func
				 , proc DBG_RELAY );
	shutdown_procs[nShutdownProcs].proc = proc;
	shutdown_procs[nShutdownProcs].func = func;
#ifdef _DEBUG
	shutdown_procs[nShutdownProcs].file = pFile;
	shutdown_procs[nShutdownProcs].line = nLine;
#endif
	shutdown_procs[nShutdownProcs].bUsed = 1;
	shutdown_procs[nShutdownProcs].priority = priority;
	{
		PSHUTDOWN_PROC check;
		for( check = shutdown_proc_schedule; check; check = check->next )
		{
			if( shutdown_procs[nShutdownProcs].priority >= check->priority )
			{
#ifdef DEBUG_SHUTDOWN
				lprintf( "%s(%d) is to run before %s(%d) %s"
						 , shutdown_procs[nShutdownProcs].func
						 , nShutdownProcs
						 , check->file
						 , check->line
						 , check->func );
#endif
				shutdown_procs[nShutdownProcs].next = check;
				shutdown_procs[nShutdownProcs].me = check->me;
				(*check->me) = shutdown_procs + nShutdownProcs;
				check->me = &shutdown_procs[nShutdownProcs].next;
				break;
			}
		}
		if( !check )
			LinkLast( shutdown_proc_schedule, PSHUTDOWN_PROC, shutdown_procs + nShutdownProcs );
		//lprintf( "first routine is %s(%d)"
		//		 , shutdown_proc_schedule->func
		//		 , shutdown_proc_schedule->line );
	}
	nShutdownProcs++;
	//lprintf( "Total procs %d", nProcs );
}
void InvokeExits( void )
{
	// okay well since noone previously scheduled exits...
	// this runs a prioritized list of exits - all within
	// a single moment of exited-ness.
	PSHUTDOWN_PROC proc;
	// shutdown is much easier than startup cause more
	// procedures shouldn't be added as a property of shutdown.
#ifdef DEBUG_ATEXIT
	fprintf( stderr, "InvokeExits()\n" );
#endif
	// don't allow shutdown procs to schedule more shutdown procs...
	// although in theory we could; if the first list contained
	// ReleaseAllMemory(); then there is no memory.
	if(
#ifndef __STATIC_GLOBALS__
		deadstart_local_data &&
#endif
			( proc = (PSHUTDOWN_PROC)LockedExchangePtrSzVal( (PVPTRSZVAL)&shutdown_proc_schedule, 0 ) ) != NULL
		  )
	{
		// just before all memory goes away
		// global memory goes away (including mine) so deadstart_local_data is invalidated.
#ifndef __STATIC_GLOBALS__
		//struct deadstart_local_data_ *local_pointer = (struct deadstart_local_data_*)(((uintptr_t)deadstart_local_data)-sizeof(PLIST));
#endif
		PSHUTDOWN_PROC proclist = proc;
		// link list to myself..
#ifndef __STATIC_GLOBALS__
		//Hold( local_pointer );
#endif
		proc->me = &proclist;
		while( ( proc = proclist ) )
		{
#if defined( DEBUG_SHUTDOWN )
			lprintf( "Exit Proc %s(%p)(%d) priority %d from %s(%d)..."
			       , proc->func
			       , proc->proc
			       , proc - shutdown_procs
			       , proc->priority
			       , proc->file
			       , proc->line );
#endif
			if( proc->priority == 0 )
			{
				//atexit( proc->proc );
				//continue;
			}
			// don't release this stuff... memory might be one of the autoexiters.
			UnlinkThing( proc );
			if( proc->proc
#ifndef __LINUX__
				&& !IsBadCodePtr( (FARPROC)proc->proc )
#endif
			  )
			{
#ifdef DEBUG_SHUTDOWN
				lprintf( "Dispatching..." );
#endif
				proc->proc();
			}
			// okay I have the whol elist... so...
#ifdef DEBUG_SHUTDOWN
			lprintf( "Okay and that's done... next is %p %p", proclist, shutdown_proc_schedule );
#endif
		}
		// nope by this time memory doesn't exist anywhere.
		//Release( local_pointer );
		//shutdown_proc_schedule = proc;
	}
#ifndef __STATIC_GLOBALS__
	deadstart_local_data = (struct deadstart_local_data_*)NULL;
#endif
	//shutdown_proc_schedule = NULL;
}
void DispelDeadstart( void )
{
	shutdown_proc_schedule = NULL;
}
#ifdef __cplusplus
ROOT_ATEXIT(AutoRunExits)
{
#ifdef DEBUG_ATEXIT
	fprintf( stderr, "ROOT_ATEXIT()" );
#endif
	InvokeExits();
}
#endif
void SuspendDeadstart( void )
{
	bSuspend++;
}
void ResumeDeadstart( void )
{
	bSuspend--;
	if( !bSuspend )
	{
		if( bInitialDone )
			InvokeDeadstart();
	}
}
SACK_DEADSTART_NAMESPACE_END
SACK_NAMESPACE
// linked into BAG to provide a common definition for function Exit()
// this then invokes an exit in the mainline program (if available)
void BAG_Exit( int code )
{
#ifdef DEBUG_ATEXIT
	fprintf( stderr, "BAG_Exit();" );
#endif
	InvokeExits();
#undef exit
	exit( code );
}
// legacy linking code - might still be usin this for linux...
LOGICAL is_deadstart_complete( void )
{
	//extern uint32_t deadstart_complete;
#ifndef __STATIC_GLOBALS__
	if( deadstart_local_data )
//deadstart_complete;
		return bInitialDone;
#endif
	return FALSE;
}
SACK_NAMESPACE_END
SACK_DEADSTART_NAMESPACE
LOGICAL IsRootDeadstartStarted( void )
{
#ifndef __STATIC_GLOBALS__
	if( deadstart_local_data )
		return bInitialStarted;
	return 0;
#else
	return bInitialStarted;
#endif
}
LOGICAL IsRootDeadstartComplete( void )
{
#ifndef __STATIC_GLOBALS__
	if( deadstart_local_data )
		return bInitialDone;
	return 0;
#else
	return bInitialDone;
#endif
}
#ifndef __STATIC__
#  ifndef __WATCOMC__
#    if !defined( NO_DEADSTART_DLLMAIN ) && !defined( BUILD_PORTABLE_EXECUTABLE )
#      if !defined( __LINUX__ ) && !defined( __GNUC__ )
#        ifdef __cplusplus
extern "C"
#        endif
__declspec(dllexport)
	BOOL WINAPI DllMain(  HINSTANCE hinstDLL,
   DWORD fdwReason,
   LPVOID lpvReserved
		   )
{
	if( fdwReason == DLL_PROCESS_DETACH ) {
#ifdef DEBUG_ATEXIT
		fprintf( stderr, "DLL_DETACH\n" );
#endif
		InvokeExits();
	}
	return TRUE;
}
#      else
void RootDestructor(void) __attribute__((destruc