
//data:image/png;base64,
var sack = require( ".." );
var vol = sack.Volume();

var s = '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';



// Converts an ArrayBuffer directly to base64, without any intermediate 'convert to string then
// use window.btoa' step. According to my tests, this appears to be a faster approach:
// http://jsperf.com/encoding-xhr-image-data/5
// doesn't have to be reversable....
const encodings = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789$_'
const decodings = { '=':0 };
var u8 = '';


for( var x = 0; x < 256; x++ ) {
	if( x < 64 ) {
		decodings[encodings[x]] = x;
		u8 += String.fromCharCode(x);
	}
	else if( x < 128 ) {
		u8 += String.fromCharCode(x);
	}
	else {
		u8 += String.fromCharCode(x);
	}
}

decodings['+'] = 62;
decodings['/'] = 63;


//console.log( "u8 is...", u8 );

function base64ArrayBuffer(arrayBuffer) {
  var base64    = ''

  var bytes         = new Uint8Array(arrayBuffer)
  var byteLength    = bytes.byteLength
  var byteRemainder = byteLength % 3
  var mainLength    = byteLength - byteRemainder

  var a, b, c, d
  var chunk
  //throw "who's using this?"
  //console.log( "buffer..", arrayBuffer )
  // Main loop deals with bytes in chunks of 3
  for (var i = 0; i < mainLength; i = i + 3) {
    // Combine the three bytes into a single integer
    chunk = (bytes[i] << 16) | (bytes[i + 1] << 8) | bytes[i + 2]

    // Use bitmasks to extract 6-bit segments from the triplet
    a = (chunk & 16515072) >> 18 // 16515072 = (2^6 - 1) << 18
    b = (chunk & 258048)   >> 12 // 258048   = (2^6 - 1) << 12
    c = (chunk & 4032)     >>  6 // 4032     = (2^6 - 1) << 6
    d = chunk & 63               // 63       = 2^6 - 1

    // Convert the raw binary segments to the appropriate ASCII encoding
    base64 += encodings[a] + encodings[b] + encodings[c] + encodings[d]
  }

  // Deal with the remaining bytes and padding
  if (byteRemainder == 1) {
    chunk = bytes[mainLength]
    a = (chunk & 252) >> 2 // 252 = (2^6 - 1) << 2
    // Set the 4 least significant bits to zero
    b = (chunk & 3)   << 4 // 3   = 2^2 - 1
    base64 += encodings[a] + encodings[b] + '=='
  } else if (byteRemainder == 2) {
    chunk = (bytes[mainLength] << 8) | bytes[mainLength + 1]
    a = (chunk & 64512) >> 10 // 64512 = (2^6 - 1) << 10
    b = (chunk & 1008)  >>  4 // 1008  = (2^6 - 1) << 4
    // Set the 2 least significant bits to zero
    c = (chunk & 15)    <<  2 // 15    = 2^4 - 1
    base64 += encodings[a] + encodings[b] + encodings[c] + '='
  }
  //console.log( "dup?", base64)
  return base64
}


function DecodeBase64( out, buf )
{
	{
		var n;
		var l = (buf.length+3)/4;
		for( n = 0; n < l; n++ )
		{
			var index0 = decodings[buf[n*4]];
			var index1 = decodings[buf[n*4+1]];
			var index2 = decodings[buf[n*4+2]];
			var index3 = decodings[buf[n*4+3]];
			
			out[n*3+0] = (( index0 ) << 2 | ( index1 ) >> 4);
			out[n*3+1] = (( index1 ) << 4 | ( ( ( index2 ) >> 2 ) & 0x0f ));
			out[n*3+2] = (( index2 ) << 6 | ( ( index3 ) & 0x3F ));
		}
	}
}


var out = new Uint8Array( s.length/4*3 );
DecodeBase64( out, s );
console.log( "out?", out );
console.log( "VOL?", vol, Object.getPrototypeOf( vol ) );
vol.write( "testout.png", out );

var s2 = "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";
out = new Uint8Array( s2.length/4*3);
DecodeBase64( out, s2 );
vol.write( "testout2.png", out );

var sarr = ['iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAgAElEQVR4XnV79XedV5bl+ytmzTRUuipoxsTMJFtgEljMzMzM+MTMemJmZrJkWbLM7CSOIVBJJSlIT3XXnn1uz8yaX6bWquXEkd77vnvPPWfT1ZheOoftn36MzY5qpLmY4/X8MAaLM+BlfAl3x3pQlBiFECdr/LY+iZaMGBifPgJvazPcnR6Bm4UxbjWVYKmvHd/dmoar+XVEejihvSwPM51NcLMyQ3qYPwLdnBDk6oAfH9/ByuwUQr1cURLihrSIYAxV5KK7qR7eNuZYHBvCdYOLCLS4Al1hDvJ9HfButg9BHi7wMr+G/Jhg1BdoEe7thr7qEvTVlMCMz+9pYoDhkiwMtjfh3nAH7A3OoTzCGyOVuRhvrkG8ux3GGquw2FoNXz57flQQOkpyYXfNEJpnM0O4MzkE12uXYHb2KOqSIxBgZ44DWz+C542rGGqqhdNlPbjx5XxvXMa23/8rHox2weTiOYS4O2GhqxGrI31wNTbExQO7MaqrwnJ3E/wsrmGkowW3h7tRGhcKH/77+sQgwjxd8O9fPcaXXeXw5gK9urWAtuYmLlQAyhIjUFuUh0xfZ5SnxSPAxgwPhtrRX12Mw7u2orEgCy83VpEd4o2uykIc37MDTUU56OU/yzMHOVqp5wt2sESIix2KI/2R4OUIN1Mj3J0axq2eRix0NqiXv9lei/bKEmhezQ1D/8jnaC3Nw0p/B3+oGf1ludA7vB9vF0eQGeoLe6ML8OCHvL/LL/dxQHdOPEbqyvDFtk8Q5mqH9MR4WBicR0GQGzICPTBQmo3F3jakBnqpqihPiMD5z3disakcplcMEckdLE5LRKE2G6NNNfC3vAaX6wY4vmsLdLlpuMTniWAlFSREwpM7ttzTAscrF6HLTkZ7aS5CWRHLQz3orq3A5kgX9n72MaZ72+FudgV3WMnvbs8j2tsVnpYmrOJeFPNzKpOj8ODmPDxYtXs//RBjbTqE2FtAc+7IQbV637D0s8L9cf7YIVTEBGKpS4fhxmos80Vqs5IxVluMsepCuBqdhc+NK1jpa+MDJeHn1XGkBHjg6UQPGkvyUc8KmizLxHB9BTqrSlQFPRlux1dDjdy1IiSE+KM8Jgjl3O1nvXW4cvYEokODcG9jHc0FmdCGeKnfe7c8BrMLp7DMsk3wdsGj6UEMctE9HGwx3VQFi0tn4O9gja1/+ABe1y6yUtq4EB9xA5tgev4EKlJiUc8F6yrJQQ8/L87fixv2KYq4GN8ujWJ9fAC6Ii00xSzPDa7SXHMVbPXPqLOyPNqPX188QGZ0GKpy0nHmi71oK8rGYKsOtfnZqM1Owd35SZ5ld7UwbjaWSPJygL+1Cbb94XcoCPNBSWo8PucX9ra3oKulCdWpMdj20e9Rw8VsyMvAYGMN3G0s+PMfYLGhGAXhfqhMT1ALM8gKenVvA8MNlZiqL8PTO2uojAtBU146fn68gTOf78bNtlo08nNqYwPRnxEJ8wsn8WJ1AXX8np9ePMJcVxPK+Tut/J0Aq+uoyc1AR1k+TuzbiccLU+jmwkx3NELjYHQeaQHuMDp9HJlBnvjm/joMjh9Egp878qOD0ZCZgLYSLb4e78CDpRm43rgGt+v6GKjIR2VOGs5/sZuldAPPBxphb3wZoxVavFxbRIDtDXy1uYbStASc3L8bd1tKMFqSiUetpXh+cxat9bVwvqaPp6vzKI4KxIUTR2F27jhyIgJwYMcWVZX5MaEY5YbEBfmhpaIY5alxcOZR2fK7f4IuKxGRTpbwZHM8vWcrOjKiMdtUgRhWSwYbryM/21r/HL6cG0IdN61Vmwwb4yuq9BuLc5ETFwkXc2Nons+PoiIpEqvt1fjj5jIaCrPx+fYtKOW5zQjxRVqgJ4riIxDDEpJdWJkaRwibjSU/PJpfdnDrx/jT2iQq4sMw0NaM2rRYdLK5GPAcVxTkYisf1t/FAc26eqxNDOHyicOwuGqEKxfOwsXgLI7t2Y7m9GjMj/SjOCkGS83lWB/rw3Rrveo3yewjBscOwIol31uSjUR/TzZHU1VRY7pKLPClx1obsDbYiR42Q+k5RiePoK+xFt2lWnTUVaO/ogCtuSkoy0jCvZlR1GQmYoK/uznQCs0LLkALy7ssJwPdHF+u3F3p5lXswvj2FaLYTHJCfdCRl8KFioCLpRmcjM5hvK4Ub+/eQkNOKtJ9HNFZlIUIF1ts8gvk5Vu0KSjh2Kpjyaf6uSHF3x0X9u9QHfjN6gxejnWgvTAL74cbYXrmCJ7063D13Ckc27sT43y4Zv7+6X07MM/G+Zf1aTWKnQzPYKalGht9XOj0WHUEwrzdVbXaXL6oRtyLB3exNjOBe9116GWVjvAYddeWoyydTTc2hA3UGbUJoehkM5URr3G4bogSNoyt//Yv7LCcBKMDSArwgjNfsjYtBvG+7NhZadj9yYcIc3OA843rWB7sRnlKDGbYebdy7Mz3daI4OQZJcTEIsLdEgKcbzM8fxxB7huPVS2gvL0RPajjuNBZivr0OY+z8j/ob4e3lhb8sDqKOPeX5RDf685MxmJeIzeV5xIQFQ5scj7m+Dn6GPt7dX0OQ5RVsLs2rv0/0dMR4ZwtSQgOQyv7TmhaFycZKvFmZ4si9itP7dyHaw5HVao3DO7dysTPhZHKFozQbCW42mOWzB9ndgEbG2Trn4x12xRJ25+Qgb5TxZTb6W3CTL1odE4Dy5GjV3LorCjlnf4e3s/3qSyJ9PXhGq/H+2SNc0TtHUJMHZ9OrqGalNJUX4W/vv8ZUWwPe3JyAHquiMTEE69065PFIFbC/yMze8elHsLhwAmFOVmjiFJHRd+WLHfj21ozqHSuTo6o3xQb6womjsIqNsowbUpCagJutVZjkRJBR7cUxPd/fpY7KPYK0irhg4Ldf8erZE0xwYapTolCVlQLrq4YId3fEb9+/Za8IgCbZww7XTh1Gd3UZtn34b7jTVQez8yeJvK7C29RQfdgd/v/xeC8aeL7/8WgF+SGe6OQMtjE8j3hPBwTaWSCWqzpclIY2NquOnAR05yXD3cEOhnrnkRQaiFO7tyrA015TjhyOuoRAH+hSo7Bj6xbkpiSgNCkKTRyrJWyI7TySday+haE+4E9vuIuWuHKMPSUxEkujg3h+7w5Mzp1AcUocGtgMFydGcIKLFc6m2JiThMdry2gpJpKMj0S4pzOO7N6uGmNHfhoGywicyvNRwcUIs2ETXJyeRGFyHF7ODOCb0Vb015ZhtLkWJayCBUJcLbFBRmwkzgpeIGApY8NsKivAZlU6utgXHs+MICs1BbrKUvhdPc9pcgw/PNqA93U9yOLGh4cgJyEaY4XswibXUF9ThU6OrZ08UnMjQ+hhg3o2SbDCHnRkx6dIcTJFe1oEx1k0gtjsMoO94efugrcP78CNaFVA0VU2UC27eAtBU31eJko5cl9ymphxFF4/cwzJfq4YrCmFByfWleMH1Nhenhxj/9EigU10ob6IYOgPuDnQAY38speVKT7f+gn8+IUedlbIjo9GF3H/o9kxPB1sRkwId4UrG0TkVMAdsiDQaCgtwHhpBgpS4hFoS3ydGI3AG4awPHcMHayO6a5mYotqnPpijzoas9W5HLcecLSzRbqvE0wunccqO/f2Tz7CvK4UT5enea7t0ZaTqGD3NvakCR4vQ06AAXb0+kItXt25hUIiyGc35zDf3QJnwm/nK3qqCQ+0NiKD4zzc8jK+efEMlwmwMiKDkcEFfDI7ingvZ/QTe6TyGTZ6m5AbG45nG7eg6SepqGSHzI8Lx6PlWcSx6ekRDV44uI/EZVLNXWvuXDnPXn5SLN5O9+If3zxDDD9QFqQ5Mw75PI8NbC49qaH4brobr6Z6kZ2aDCsuRkZCHHZ8+AGqs1NV6TfWVuNPz+7B0+I6RgqS8Wy8B21NOtizWU50taIyMxlh5kZId7fGT18+w+pQN48KoWxRPrbziJrrnSYUT0APy9ifWOPA9s8Qz6bdV1UEJ2MjGHLMzgz182c/wMbSHM6wGd6dHER/XQW6tUm4w3eyu34ZCU7muDveD02gkw1KOR7C3ezx67dvcPXMceD7r/H65hQ6ywvY1K7g+9UpPJvqRz2JSivPVhbP03Oes6GqfCSxpFxMLhMg8YUq8xTutiXLsjczhu/VCxxtJzGQFYVBsrXJ7nbE+ntzUligu65KNUFHCzOM1JfDw8QQW/71f+Dk3h04fWAvOpob4cTFj+Pn1xPITFQXcAG9cYskxptQPDvIAzXp8fCxMsFUtfCYNsyMDKK5ugI93NQulntzWaECTQKCYjg18tgTgvndZqcOYaq2EFaXL0EjY0/Hc2ROWnmND3tD/wLmW2tQwqbkaHaNpdwKbVQwNtZuEd2Zob+hCrmZ6arp1OemEx434gVxemtmLAbqyrFJ1iWlHmxjgggSJZkewsRK4sPRJlD08z1czAE2TVvkBLjA18EKy8O9cL58HvjHb/jtlz8hlruzMTGAuIgwNdMFxAhZut9RiY2FGQy2NCAnOQGxHg5qdEoPk+eRCVGekYi+1ibUEfqmshdkRwbh4I7PyBSt8evz+yRv9kgL9VeTqjknGZqGuADMNpTgyUQ/XpBqOvJMRbrYIMLqKt4vDGG2u1WVV5NOh0By+sHeHnRx996uL6EpPhiV+VrEBvkqdDavK4HhqaPwMDZQCxXH0pQ+0ZoSii8HdHA3vYwGEpRBIrasxDjs3fopooID4WeqrxjpjYtnMMqqinazw+r4ID7/5Pfw5Q4XJ8eikL1GSFgAX0Tgd6yLFXysTXGbjezxYAubXrFitCmk0vaG1AMyUzDR3oh6AjU5rlJB1ZlJikjF+bgi3NYEuz/8HTT3xvswOz4GLyd73DC8iGaShz8/vg1toJsiNP7OdvC2J8/mmaotKVSNR/49gQwumjuQSfpbTU7w07dv1Rnd/ukn2OCOP1pfVaMt3dsRPhQsBNGtj/RgqquFgkk+ojiLtaHeJC732Ol9EE4U2UOa/fLmDHq1CUjgBJGKerW+DA/S3L76KhSxTy0SSBVwQSoJxCIdzFER7ILSzFT2Lnc4E1pXpsZiqLkegZxYzlcvsj94Y2OwDT9yMj0Y6oDe0YMYIDo8xYpJD/WDJpg9IMjFHtl+TiyLcEzXF5Mzm8CEnT6L0yCBM3yGFRJEcvLT4gBOkYn18QF1/Fk/zn+BlV3sC6WshCRSXcezh/DHhQEYG+kjm+PzGuFtDpWd1+zMegf3YrynE/5cwAPUEmTUylhqoaixwGOXHxOCqpRo2BH5lXPxcgmWLPRO4bdHa6iiEiSbcIKawaOVBWy0VatdFortZnQGlznuZNSGEq1GudooftNSSihMAubFDXCytYaNkR5WWTHRzlbq8xtTIqGREmnjXJ/ubMYkSyaEZW7HHxzQVWM76WtDRjzuD3diiDKZAKPv7t+G8YkDePX8GVxJg5uJ7SO5m93ZMYhzvIHSKH+kRoaw0VmhLiGYJdqGrwd1CnfXRPkqxHeANHm1oxYb/Nx0fzfFQ2oLcsgbEtFcrMVFijFJ0ZGqaeUGuipgtTA2jHoCp398/w10BEl6R77Agb2kxQNdCPHzRhoRbDChsvCDeBdL4Luv0cdK8CNilYa4wuYpTfT20gJaCc0XGssxxCmkqU8KU4CggTC1v6oYVeTj7VlxwM/v1Bm729+sRIW0uGhMdLexAvbAz8pYlfvtlZtkZbGKqDRyF2sJN4MdLPDw1rI6BqLzXT11RPGM6d4OhPh4wuDiBQx1tmGanxVKVrmHgGi5rUZBYw/qA6LkLDWWEhEGUMq6gihKaMLt29kI3anmFJAxGpw6pgBUDwnYBFmjMXXEWm5kdpgvnpNUzfW0Ynl8CKcO7IPjDWPEsgdMN5TC5oo+yhLCUatNR0Z4gOIpmnWuiODsG5wCckZjfdzYoGL5A4G4SlRXxbPmx8ZTHOGrXvr+yiJmx0bQlJ+BubY6VFAwKSY0LiIWMD5zFLMUVmqjfRHFMovx88Tm+m08H+/Gm/E2BHK+P5sgRmBnNiMDTCXV/uO9W4hh0zM7ewzvqNSc3vUZmrSpBD910KXHwNfMiMw0Toklz+7c5u4VYfsH/4RxNrVhVqksnICwJ5N9aK0qhS+1x7a0SEQTvLWwmlRDzEpVhE5wTC0bd29RJuHzKC6fPAzNKHejobJCaX6T3JWtJDsdrICF6Sk1zlrz0/H3F5uYaChDvJs1Xg03kxqnsmzTsUneft3wkursx/ftUqNFdvkH9oB6cu5FlmdXQRqiQoIx3lCO4f5eZHjZoSjMG3//7c/IcrfCwsgAgtmDpIrGOltVPxLKukAp7m5/E3fPBZlRoQizIhhjF68vL8Ei+cA4hZJHazcxXVeEi6eOU1o7iaPE/Dl+zkplSo0MVUx1iNBe2Kt8/k5qgRsEP2NEmFKVojxpWriiXdWlKI0OQA5lqZ9ePUUHm1pFQZ4iDENdHaoXHCKlTOU5Kw3zxCLxeHpSAjI8bNTDNlFEEa4dKMgwIxbzUoLkEVEsvTxCTtEHpoj701lVF06dxNuZXiV0HKHSG2d9BaaGegouB5OeCm+v54u2k7iUJ4QpCjtVV6LU5/bcVARQditmtUn1xDpbIsXbiQRHi8edlfjl4S3MkhF6UAz97e4C3q5OI5cKUzHpvgilHUSC+kcP4OKxg3DjNGvNS4Nmz0cfKKBhePIorHlG5qm1+VD+lvn7ZmEYhUnRSKc2WBHqju/Wqaryw7PY5A7u24MANsxSIr8SsrSJmkJUsn/c5HnOiaO8zekw2VKH44Si6QQeD9orUJWXRYxhC11NNUFLPEoyUrBCKm7B49deUYQ+CjIn2WPa2KTkvx3etQ03+9uR488qIPmxI/uM4RE9uHsH9Pm8IukL0gxztICurAiRrBZZGB15wxJ3PcbPi9VdTjYaQB3DmN9zFjHUCPz4bvjLtxgqz4OmgnLxeH8PnnZQF+isUSpKNHdunk0jL8IfRelJKPC1U1LSN5Nd5NkhFFH70JkeqZqWExuJyFS6xFBksqPLkemtKYOr2VU1QR42FWKyrR4vB5vIL/YqscT/wgHMVWoV8XInYxN1WT5HaHZRQT5qWQEijT3ua8DmaI9qfjlkpfJiMbbXURQdiPXhLoigO0r4PUCKG0AzpYxqdiH/W0qA53+JHgPdGCFFFyqf4O2Mx6tLyOQR6SzMQDvBnMh8mmyurszpn1bGlOBhQSUnkfPcin+mkl2JAHJs24eoi/JGb3cXrlH4qCFVlYVbmxzG7bpchBNeRpBL/DJNLyAiROmCMg5bSJFFaXa048OwpwQS9jbU1qCfI7WI4KWurBg/fPUKST7OSOZDR7mQAL1+gc7iLBRSNBmtKUItF1FXVY509oEZLuQk1ad0apU9rBYZraHW15SGIOjV5uIp1JD6FmckI5LPE0uwFskGKz3jKT2BWj63fOZpqtyvNm4i2d8Dmhk2kS6etzB7c5SGeCCR+loy9bvmCA/YXTqFPz29i7fz5O3snDkcMz0EHp6XjnPk+PN8+cObICOMJsYIoajWwwrD7M5ynmWB9E8cwWBOLCIDuRgJgfz7fOz7mEcuOwFPpgYR5XBDKczB1PVE5DSkmLk61KVU3BZ28hpiA3tzU4X523h+6zm+hIiVR/qhlCLskDTWqgISsAgkUmBp5PRY7KiHF8fvGo/WMr2NooQouPC8h7FXpYQFKgfrJrmH8JsCVpzmOs9QIUfJMKUxF1srNBKMiDIkTO01RZJKjiA/N2cSCD8Myc+Ym+AsqfJiRwPM9c8ruNlH3X+xKIFs7r+jTpuG3KwMsrN2HKfAOVlbhLW2SgVq8glqhon1Fzk+jU4cUg3qK7LOSC5Ehp8L2jNj0Mzx2l5byZ1MxtxgD22vImhjI1DIl+wiHC7WZqGLeCUvMgBW9ACFxo/UluA2lSwj4gMjSvqiVkcTDTrzGFYQ8Y1mRaCFgK2elD2S/aKBQGqDDlJ/Xy80Uz3tePNwE3HSHChoduRSyrpwGH8jRu+hRSZSUiXPZA3n50ApgQeNinqWrvv1Swp1lbEBrve1oLq8FEM0K3spRYs2L118jO5QCWWrUFaXYIPXswMwI59vIkSVIyDnN5H6w3hVHirJ4kRcsb1ioBpblKeTUns9bS1puLIJBnkpVDepK0d+uK/aAMH/BZGBqvEO0oHqyk1idSVigGRrrr0eGZTVO6kbCK1PcjbHg5ZSOmBDyrLryIhSoEuD71/i5we3sIO0dbg8h3PUCTYkFcFEaYkESDZXLsHX1oLHJFUpwY4cS/+H6wvF7E4LRwHPazwb4Z6tn2Gkl2YoVZt9tKlsTY1RTSGjlbjB3JjuTDFfPCcT3boa8vIb0PIIJYfT8aX54m12WQEUcXJ1yWHYw5kdzSYlnL6xOE9Jc0X8+XKOyamBXsUiQ830Ee3Ixc3PgieNVh9bmimcSsJK3fl5jyf70cT+Mc5zn+DFY0pTRNSmlPhYch8XXDy0j6KomxXiiNgWyLJGeH6D3RzVOOzmKg4SSz+mbSa2uGiFG3R3U9kfgsj1hb1du3CGDdAOCRRGWxt1yh6rjOZL0QdIdreFNx+ohgxSbKmcEB80pUQghyhwqqUGUQG+SgEe4/jMpu+QyHk+xwY3QJBSFh9K5heqGF8rJbKR3i4KH6bI5XhtzohTBEgWTBrnCY7ZWKrTL1dmlQwuDE9XlKv0w+6mBvV3+cEeyI4ORX16HCI5Gr9bncQIJft8irGaBz31uE+8P85mUldahB7qeW9uL6I5IQQVeTn/X64fH+iNPpacGKPVfGCvq+eIIeqw3lgEgzMnlWkp7HCFjpNYX82VxciKCEQXj0g6F0PUHgFfsYTMl6j7SYcv4QuH0dZu4I4G0uLeyaqU4xdKAlVXUoAEVoe8SDIbntjfm90NCKJIM1RZADdLU6VeiSvtwj+lYkfKCNBYnc0kewtktD42NzBZkEibrRQr5D/3Rjqhud+Qyw/IowIUTRp8/X9z/cD/h+un4sf3b/4v119nluC/uD4lZx6TSHcHvCVgEkUohw+XFx2E8aEB9cU/rgxhprUO2Um008u1eHF7Gdf1ziLJ1wV//vGPCHayJYnS8mdq+WJhrARvaotZamfF8xdiNdlUiR6yOWF7Tham7NweqOMLhPp4wJaWfAbHYxqPUZyrNWIs9BFGoWOA8ttKSyV2//5f4Gh4FhXUGSsIvJYJ8kwunqeMb648hqP790BjoXcSxX4cM0SDdjQ3e8j1hSf7c2ZX0VzooYVUyHMrI8Tt0gm8J4w1Ea4fE8aj44GhHKZGeBRaCGaCKELIuBHl15z+n+01IxRS9iqkHHbx9Am4WfNIUDxpocg5THdIFi+bk6A8O41WG3UIAqtEX1fk86w30hqz1j+LRk6FTNJYWVDhBKVkn68eP8CzW0vYu+UTeFnfwDdPHijsUUUv8jkN2TJWUjVfuDX7v3IMvZTN2goyEMFjF8mKG6E6fP3scfSRwmsaGUUJ9HBFNMtqrKFCnWnh4lIReZyhYoa4GusjiyKk+H1yFkXrKyI7lIecLkzC2cNfkI6moTHMFf/xYFYpPg0BDljhTM7gzhZRwZmqyMGjuXFMsOPvpfkqBEakrJmWWvhT988gt8iN8KOlHUpBxABLw33wp+CSxwUS2a6VoGqdHMT58gVE8cyf2b9T7eyXKzNwIeNrJwKVRIqQHjn3JewvMibjfTiRKIpGcbFDKJYM5cWjlIjRgz7iLaZXNOL1yX+QMTRTnoUCrn4FUVwSR9C7d2/RS6JUm5HAvMB9rLZWwsjQADmcy3coL5UQiXk72qomtkx3tyA2FOePHEBfZhT6cuLQySZ0dN9ulFHNMdU7Q2bnhBQ2yFGO08jgINxfW1UuczEtuT7i8roc4QbNBDu+HMdJSAvxo6UViVpyiGzy9wR3+gYkauPM/nRykYcIgft4VBbYe6xZbfn0DNdonHbQnY6kIyTE7CYDEy0EXiKzZREGJwb7oYrCzGgBK9bLDZqXPJe3R3vRy4eW0afjaocG+KGLfFyka2seEQkzVVHXj+fcLSR6Mj97RKU54mNjkcCzt9bbTJZ3QuEIHYURR/qD3tf0WJ5mSkoXMJJEtaicKx/M0VlDRFfKxRupLuKO2SiC5O3sgAJ/Z/QUUAvIiuUCpKCaC59HoHOX+n4chVdn9gABQ3enhhSbFOJWGRukhJshfpaPgw3yY8PQTZ6yqStQ3oOMvV2M0FjxmcPsTDFWlsWjZo6vHt2HLStN85RmiJyPm0xpPB8lzmazWWfn1iUGc8ydJR29jFymqkTHi7W6jCQ+yM83R/BisocBiXSE2zHoNNOvKHUa6XE8YesSFd22dDk+0ewjQZihEivqyxgRW6yzBepLi+k028OCIuylk8cUSVql6rNr21bEsFSTWbba9FSlS4j+KL5+PtHl9y+f4G5dDpLZj8TzE4ss3cMaeqdPoi2Ui5ebiP98sIgSEiJBsqJVioE6mhaMY6Tel44fRimDU1Yc8y3xAaiIDYbmEW0jTxdnBFKIEJPBjyqwQMnHVG5+3JjH6Z2f4Nu3b9BTV0kbvB3lUX44/Pl+ojE/5okO48LxI8wP+CKDSO0kJSgJQonSnOROs7Qyn/y8Ew2cyxJ6ejLSjvdEYvWssoVyenrsDZ3tbXzYf8Evk82K5z+gEWvLZjzD+IpokALTO3iGhWr3xvsofjLT08bjYKtEGu/LZ1CYmaZM1jlmB4r4gs4mRuQDN3BvcQaH9u5SzV3wxk9vvlaRwDziCUGYVaxETQdLebI4DdXJkUpJmW+uRFtLM8NO4bAwuoQvV+ew2FiGq4b6yCf+zubLFrOrb3ZUoSYxTEnf1ZSrvr01q/C/GJmZHHsuBqcV5OwszsZ1IwME+fvBy9MDPc06ZFNyFw3vGv07ASuCKGurKtFBXX+ReYAKWvIdujoc3LkNoYzihbEqpLfs372TVaOHRmYBzu/bDkcrC2z94J9VUmRKG4Uwki4xU01PfKGsvBZaFIEAABEiSURBVHYKHiKB/c8fv4M2LUUhQi3lvklmB8epJT5sK4VmoiQdaZzLwoxGyK7udtcjls1GaKwJR0UEx5r8WU7Mn+Bohq54PzQnh6ou6kszpIQi5WP6e+IfrnfWIZFmyN3bt9CVHAQdyUcRSVA/+8lAfSWhqgWqiAxT6APs2rEDXz9+SMdHHylcqBEyyNYsji7md/RYWYLfb87NULy4zkqhU12jxXezvbC6eBrXOXZdaeD89Y/fKUL2bpjpEoNLLGuyPaZISgjFVymb1xNCR9mbsesHI8rOBM08khKu8uGzi9AjtqDG8NBehpUuKX/w5zsLJDw5yngQKTqZSgqerJKGkgeQfkoyw5J+mgk7+k8P15Ed7Klob3u0F24zMRpOfH5ncRaVxQVKIc4gLBVn2YuOzlK1Fp3c/RyiQYngJbOxDiQFMjQRrMQLD1d2bc58MVw3by4ii56CeIif79iK3uxY3KfB2U4V2IuK1C+Uu0pJidvpOImkH0tSA/xNqVUiqNZTnJHww8PBVphdo7f5/BHVYRNsoQ6Yy94izyB5KDFeNMcOH8KpI4d4xiJxga7JQbqtwqd3ffIHPKOd1UQdbozz9T8fLSvOb0/RIS8pDk9H2zFN2+vN2jxja7sUV+9muYvbU0qdXwKJotBICdreMIUnsXsJ1SVdUiheP9hUYUmBpjqmQqJdbdGWGIRqjjstz/xUTwf62lqYRYhCV3YcGSJxfUE6DC6ch5ujPcZHR5W3qCU2sWOIc5yaoZge3ZwQkv0zoys93aFTSK+VDd7u3BEurDnaqBo/o0IdbWuMeIK4VDZTzYyuDONNTFdurmKeONqflPNvz+8ij9zd390V9lw5sbUv69O+5vydr6PHxvN14dB+ZZA05meyZA+SvIQpfL7js08wU5KKtapMeDLU2JoSjqrCPJU8E7Oyi2de+L8DHeQ/E1vIGH091Q198njpB/1UndoZfFAxV/KNdu6woMeK3GyV6mogJ5DzKy/nRHFD6+uISsLyOM73vz7dQBV5yZHd20DJBy4O9viRmUFDehFz7Q34liTIlyPT8ZoBFmskznOFvkBdPg0RoYuOjJYaK9mohmUdRSkp3dsBiwQ44hl68/zu3L4Nxw8dQDF1eAFADdzNeMpOkjGsLStRfl4rm+oqXRg3qxs4TYQo87g9zFkhOQZ9WaamSgespz5QFOqhaGq4zXXGVmhx1xdgmaZIDNXeCmYCM5gNEqU53d8VhcwMJpNcrRO9rQ730BVmU6vOJ5QOZPn/B/LoEJvo6yldsZKVVELhpJfpsAk2PtH/Xj99hCa6waIvul0+hzaGpgbpEWqa2BgaqZC0JZP9MRqXHRWiYOa3jKqmxUbRhopWI2++pQp485gPZIme9Ag11wMIVf2YAcTDBZTxgaMczKBNTcLq9Dh+obYnDy3CxBAhdlp8DHZQXndg8LqHR0U0gKMHvsACvQMxRYaZETCnDygSfAg9gGoqUW1EdLNMmXhxY+bp/T+5v4lqSvXxbMYSekwO9lWxumx+ZzGBVRcBkMR0BdcsD3TCjoRngv5BFuF4GGn+9i1bVBDsyvkzGGprxBKfTePAVIUD8XUTz86zhQlmgQ4oXeAxYyhB7JKNWQl4vTCKu7dWlJkQTj4tJmVnahh+XptGBWPvxcFuSq7GD69VU8rh2QxnJL6AzPDx3JgaYYU0Pn98tM5YrYWKxAxwxx8y2l7AkShZo9WaHDWGh7QMPnFxRoeH0OJ+HQ6m1xDA57jVUsFQZCUa2NklfPlgiWOXIEd28seXj+FkY6UYa0N8EKLIBaYLmSQV6MwetlqXxxBFPhrpNM0wqtNeW0WRNQyh1CI1aeFB1OkKldAhYoVE0vryksiZSzgFApVCFEHqWRzujUskMH99dAsdZFk5bIT311bQzRH3gG7tyvgwrp88BAMKoaZ0i54sTiKNM1ncWvHip6kNOlFPlLsGfkYnKaelU8M7Cvz9z/AldjhLQDVPAvR0bQlfd5cr0UT6yfeM2AWzIuoZjDy3ewtaUsJIac8CXz1kvuhjlLPhDtaWUuNj9vDOOo2VJNwkFb5KzuJMLPKCQonE/MRab6mpRDjHeojlVczRHJVIjUaiaUbM1dybHmaAOBdZ6Wl4sDzHhHgS/GmCGlC89GEJBpK7x0eEIpdzfecWpq6DXNFKsGJ94ThdoVBlZHrbWUJLS/3n9VnucK6azY/Zdf/+YAlri/MMP1co7z6dRmsPvYNmluoO9hXD/TRAeGwkKH2CkvV2GqZyaULUaS2JkZicEsOXQNUsVSOJ2zSwYudqC/ALv0uyRabMGReSoT5jxZWQUU7zKDixsn949YTj2ktFarsIq6M5qh9zw4rCfVR2QDNCJUgAiyQyBJDIag1xRSXSuuPjP+AX5ob++vI+4yyu+GG2hyAjQZGUJEpYD+YnVHZPcj6VtLEkPe7GBvfXtQlFS1MdjGF5+qA6Cil0kyQLJBreKndohuUsFyH2kKjYMw+A2RZ0ckG6tYlYm5/BMCU4w4O7FdKbZjUMECgNkUuk0nwR1VoqUIybB4zppTElZkCnqCTQhSp2vEqieLk40gIvwybDERKokncUK16abxmFWrHXZ2oKiATZJQdJT0Poy0mkrIAagNjW5zjmrhJxiVvcSYW3irr99fOnVdD4Lw==Xz9Tqspb+m2SLxR/IJ0j7tf3rxlGpHb/vzW+PpKTL9cWOJ+rUcs8UUtSCFHlMY7SQoTzWHUQ2Dyia/NkaRo9HW0qaT7B+L1kFzMIpxs5ZZ5ykRk84lSyV2RGIvdC2FYG2hXLnONnSf5wjmNN8kEHtnyIKxx7bxdHmWI3V3qE0PU8NvIiTi8RTd8w+e4k8hmzgxpvzkV/lreEFkp4nup41rK97VBHApPH8hujhSXj4xWzvIOUvYWwlOdlI5QzX0ZVOHH6WEs9qglx65kaiZQUGK+66B/9AgZnT6njI/cDgmmNL/O6yiaPVz4XuYjIc4z4w9PgFFoZde/p6sIuxmYvUKmdYWSnkbJXUWoiHnfXYBebruzkalU23q8vquYnzflLvkgaDdcClrMTdY0SfqYz2atwl00Rc7kZcv9BJLYQCrmLzRX80xgeLk6Y7u/G3AQXoIGkR4JJlXwZcVnlBkkUkVlvYToSyehEIMlIiEU0leMzDD1KWlREDUl1vFkcUyNSImv1sQFIJ3x1YU7fkKLoBr27TYajRQiVELXpZUOV3eviCOzLTcDkYB/zPvVMcrykpHYaDSHOMDy8DzdJxv5Eum1H9FeYla4ySdZmJpjMDGMe+TyqaMGn07JbbauC61U9NFFDzOLoXmcT1NKJjmSg4h3R6QCF0mjK+nYEPXLszvHZBSB1M1jxdHZYqd+SYdAMFzHyyhKXM6Wj5GxtdBE/3bupWJgkNUSD7+VUCHW2QW2EF9aJxmooL+u4cFU89/IyT3hdJt3HSVFRLwaapAG+5/EQcGXK2N0lIkVHltwwj5vc4jBmSrSf1bRck4sjnOMCkERn+IGJ8B82l9QYHSmkqpsbx2N3SsXwLrMZ19P3y4hh6nx2QlH3QjbkcdLcScZ7zAl/s6gaLTJB6sgEvBdzQxKKnqX1F0LBpZ2+Z77bDdxmKPwcc4iDzEXIcdJUhrPxccRpw/yQQ6HzTnOpuq0x1lynxJDC/Dx8wSzOJLm33LWZq2VC09Od+T5rQtxcuFozKJVLdYgddYIlXUjmJUHqMMpNlqYmaCVzPEhCU8ud+yMNGD2O0kWOO602R4WkJCafk8DLD4y+yxHUMt4aGx4KbzfaWzRGOqkOyRUcAUd/frBCkhUJHbNHcQw+SpbJlAKtBKtlZMvVvVwStOrEcPUu43Sx8tNT4MdnjabT5Ep0Ok/oL3jj16ebMGSoQlNJJfXd+gJ+eXYXtwcZI+PVleuXLtBf78LLpQl1/04eWipCDAuJxAiCEqVGTItsIrxRCh855Nn2RHnTFD21VHHl4tN93iuSOTzLLxWbXO4S3Ja4PKUvcZPqYvxgQXorSpHVuaMYGxpEIl9EKHQYE+K5lNlFxb3PvFF5cRFpOF2otCSFFuXuXzQXvYKKchw5g6mBHsOeZ5keq8ArWv22fBb5GYHnYu8JGrwz2I4AZ3tksdmLeiR5BU0VjYfLp48qoVMYXA/H0CR38vX9DXUJUp+GYzdNyyU2HlFTpMtL/KSfx0LGUmt1Oc4cPaSSoW+IGAV/T1PnNzx+iMmRHLVTQTxvcv9PBS2pC0hwWSis/rkzpKj/in0MRO76+N+wREvrEpunqLsPKXuP8iLkIYYkUgjWakixdxAfyGQKcrZlHuAqjZVA/ProtmKWEpQUmFtEni/p1GGO8tdUn8Q1Eju9hb5FsLUxeul3epLtSn7xFSeUxoVnVi4/LPF6mgAaT5IeuQgZSxdGRIWx3k7MlPKCAtnehFx+4Hjp5lx1IA0VAUUSY42cHGPMATcTagocdeUcFum8hy8beMMIwbamiLa5SuHFmdaUJ5roQD9jqMmFnVv+N8t5nJtLvSArBp0EV395+5UiOZk8DqHMHvQy+t5KXCJ0+j7vCeLrhwoYfX1nBVOk5NIwV4j9xT98ujKPiEA/vKaSJdd0bJkqyeL3ymdJUm1SV6EC2Xd5K0V4giaO+t8SgYmEnCQbpCMbNGdkVWbmIjuyMS9TyM6nML3dTfSGn9+rCwzykjqON0mCTNSX8sraPFZ5Y1TuFbwZa1Xx+JfT/RihAVIc5AJHanmSFZAIrZiWwsXDKWEJ3K2m9+BobamaklRBJFUcUZ0lktuSGqEktIxAd5RK2os9JkN6hhwbipvbCdbmGLQaIpwXYaeGeEUMEmGANSRO8ozzHIviKq9N8YIYzR7pO4IHAr2ZD4iwYAyNd++0NCCs2FSusOuOEh02UZo6/gVFTvJ/ecEnhLRxBEUXiaAeLkzSS3BU0rVcm5EUaRdvnMi8l519x8i8+HkCQoQESezFmZet3s0NwJosbnqwVx0ByfO18UHbyS3WW8vx+tYcOgma4kixRY8Ip4Nswgyg+HgicLhx7AlIG6Musf2jP6hw59OeWv7ZpLLEs+xNX/IyViqPTBd7kIgoy9MTKoEqN1RWSaXtOCHkznCql72SATQ7BNdT5BRRtD8xAD+zGY5xXFlc1lcByQhna+TyxkchAZDZZQO8v7OMRiY2pQokHyCXmkUyy6UXn0R8IBeY5A7PyQP7CUHzlBYfF+zP+Z/Fucu46kVK2IS86SzLQY7LCwf2wJJxnEBm/90paWWw9LOIO+Qo9TDjjx/eKCkuN8idPD+b8n0hvJhNkHzA23trsOQdoR+/e692dpTX58Qqfzg9hLJI5hpZHZI1lCtAcoOtm+df7iiLKJrGsf0T2ammgGgrgJxeyIIeUZhcKnC3t6EjE6vSHlm83fHr43WkEepK1v5ur04BiFL6b0287/fDnUWmsV1IUDI4HepUGrufJkUH3dlsusDyELMVJC/sE3VUdr7hZCnlNLmlK6KSE8Ho62sYHd1PcSUMq2MDqI70wTSd4kHqdau83GDNBXPRPwUH5hLw8/dUqIyVoiR3A3q5QaanD6sLXsJPRqgOy+2XXCJYPcLmIQakRLlqYT6hiQGrZd5OF0gv/MKEiyKKlEY0+3BSVm9CViELBUxfyE0vuYwgTcSXhogDvTe5EPHdozv4dvMmrtFhzSQE3fbh73l9/bzqA+U8b9eoHh/avxcpvCXy799+A0ve0PrhzpIKT/hQEv/sn/8b53wgznPULvACprhEMtLaW1vxhh371caKss4HWnQq3CTR/b07tqvbKA96G3ixi7dbOPbkotSDgWZ1w1wMkjzihAL2LDFm5bZrBTlBEyM2ki7tL86k/1iDUDbiMIK5VI7AYQao8e4pnexg/C/MmRbeKomD9wAAAABJRU5ErkJggg=='
,'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'
,'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04pUtkMShNA8TVk530YcJfQ44x+EOHi1NdSXxMPJNFffRPjAaLjLN13BEpPNT5sSVQscVH0VMaLF01Xc2PNzLO/LRTfSh6B274lx4l1O0+cO30OWO4IQqVhHP/B38AHP7pEfNH3/GFH0d1eYEq7ghizqliP/FHhQgr5PHPqACrDvH1rUkTfUEdYIHdetWBHW75qEosbGO7HuTZS8fGmyLDRGOyz6fCwKV7Dq2llFTN5JdFjLez6rqRNQ7Bhd9YOouOgKzvfaODWK+Db48D0+k506ZTD7cjZiovAiCoZFVIhWxATRmn9AiH24wMZoyO+hK1js2M8rOUaFwzzHd5aJBA5PxUvTVrQcvuC+8War+oDmbZNkz5abs47qCIuzlTML2AyQ7XES2aBw0IZAgmii9URP0M6wPUGblZxskze746VpWTYY905aWbyNDQdExdf2M0XQ/A3ksPUFoNuhPCZB2UKzFhgvLTgqYw/ABgx8Efca1A+Gb5zFm6J2hh2VsR2mKxA5fGlat2kOIo7x3tP1nk6Cx33NP4ZRzDQfgraqrVK1+Oth/S+S0DFYU+pjigAAAABJRU5ErkJggg=='

,'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'

,'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'

,'iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAACxIAAAsSAdLdfvwAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuOWwzfk4AAAF0SURBVHhe7duxSsNAHAbwS1rbVMSGtIugECWkog4SW4fSShqQJiXVgoKiTn0Eq0tx1AdQsItrXfqSn3enY57g/IaPG/Jf/r/cjZ9Il7fIZJLFBPHHBeL38e9pauR+A3mef10jXz1AZMsbnL4kCK6O4GehTMvspCF2830cTNtIPicQyeJSL7+x46Li1lCpO/I0OHI/x6uhebyFzjyGUFfCH7VQlctblgUhhPGx10pwgwaiWU8CyPfgpy0tUzRsYuyyjc3AQ/TY/wOQb0Ndj6JhE6MA6gQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCodNDAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgQOGwiSEAAQhAAAIQgAAEIIAGUMXJNPynvUFdnBzrLq3jretGpfpoekrVMtywiZPnMwjVoj6ctnWXVl0L06P+vBs2sJ3sofs6hMhX97o635kPED319bswOz3957tvQ4y+7/ADdV5pHc/hJ1UAAAAASUVORK5CYII='
];

sarr.forEach( (img,idx)=>{

	out = new Uint8Array( img.length/4*3);
	DecodeBase64( out, img );
	vol.write( "testout-"+(idx+1)+".png", out );

} );

