var sack = require( ".." );

var val = sack.JSON6.parse( "\"\nthis.clientKeyRequests = [];\nthis.clientEvents = {};\nthis.clientServiceCallbacks = [];\nthis.createServiceLogin = function( name, remote, client_id) {\n\tconsole.log( \\\"createServiceLogin:\\\", this );\n\tthis.send( `{op:\\\"createLogin\\\",name:\\\"${name}\\\",client_id:\\\"${client_id}\\\",remote:\\\"${remote}\\\"}` );\n};\nthis.on = function( eventName, cb ) {\n\tthis.clientEvents[eventName] = cb;\n};\nthis.checkLogin = function( user, password, devKey ) {\n\tconsole.log( \\\"checkLogin\\\", this );\n\tthis.send( `{op:\\\"clientLogin\\\",name:\\\"${user}\\\",password:\\\"${password}\\\",devKey:\\\"${devKey}\\\"}` );\n};\nthis.getClientKey = function( ws, msg ) {\n\tconsole.log( \\\"GETCLIENTKEY\\\" );\n\tws.send( `{op:\\\"setClientKey\\\", key:\\\"${msg.key}\\\"}` );\n};\nthis.getClientID = function( account, cb ) {\n\tconsole.log( \\\"GETCLIENTID\\\" );\n        clientServiceCallbacks.push( cb );\n\tthis.send( `{op:\\\"getClientByAccount\\\", account:\\\"${JSON.escape(account)}\\\"}` );\n};\nthis.getUserName = function( client_id, cb ) {\n\tconsole.log( \\\"GETUSERNAME\\\" );\n        clientServiceCallbacks.push( cb );\n\tthis.send( `{op:\\\"getUserName\\\", client_id:\\\"${client_id}\\\"}` );\n};\nthis.inviteUser = function( username ) {\n\tconsole.log( \\\"inviteUser\\\" );\n\tthis.send( `{op:\\\"invite\\\", user:\\\"${JSON.escape(username)}\\\"}` );\n};\nthis.rejectUser = function( username ) {\n\tconsole.log( \\\"rejectUser\\\" );\n\tthis.send( `{op:\\\"reject\\\", user:\\\"${JSON.escape(username)}\\\"}` );\n};\nthis.acceptUser = function( username ) {\n\tconsole.log( \\\"acceptUser\\\" );\n\tthis.send( `{op:\\\"accept\\\", user:\\\"${JSON.escape(username)}\\\"}` );\n};\n\nthis.fw_message = function( ws, msg, _msg ) {\n\tvar cb = this.clientEvents[msg.op]; if( cb ) { cb( msg ); return true; }\n\tif( msg.op == \\\"setClientKey\\\" ) {\n\t\tif( !msg.id ) return true;\n\t\tthis.ws.send( _msg );\n\t\treturn true;\n\t}\n\telse if( msg.op == \\\"replyClientKey\\\" ) {\n\t\tvar replyTo = this.clientKeyRequests.shift();\n\t\treplyTo.send( `{op:\\\"setClientKey\\\", key:\\\"${msg.key}\\\"}` );\n\t\treturn true;\n\t}\n\telse if( msg.op == \\\"client\\\" ) {\n\t\tvar replyTo = this.clientServiceCallbacks.shift();\n\t\treplyTo( msg.client_id );\n\t\treturn true;\n\t}\n\telse if( msg.op == \\\"username\\\" ) {\n\t\tvar replyTo = this.clientServiceCallbacks.shift();\n\t\treplyTo( msg.username );\n\t\treturn true;\n\t}\n\telse if( msg.op == \\\"accountStatus\\\" || msg.op == \\\"emailStatus\\\" || msg.op==\\\"userStatus\\\" ) {\n\t\tvar replyTo = this.clientKeyRequests.shift();\n\t\treplyTo.send( _msg );\n\t\treturn true;\n\t}\n\telse if( msg.op == \\\"loginOk\\\" ) {\n\t\tvar replyTo = this.clientKeyRequests.shift();\n\t\treplyTo.send( _msg );\n\t\treturn true;\n\t}\n\telse if( msg.op == \\\"error\\\" ) {\n\t\tvar replyTo = this.clientKeyRequests.shift();\n\t\treplyTo.send( _msg );\n\t\treturn true;\n\t}\n};\n\n\nthis.message = function( ws, msg, _msg ) {\n\tfunction saveRequestor(cr,rws)\n\t{\n\t\tvar pending = cr.find( (cr)=>cr===rws );\n\t\tif( pending ) {\n\t\t\tconsole.log( \\\"already pending\\\");\n\t\t\tws.send( '{op:\\\"error\\\",msg:\\\"Already in progress... Please wait...\\\"}');\n\t\t\treturn false; }\n\t\tcr.push( rws );\n\t\treturn true;\n\t}\n\tconsole.log( \\\"userDbExt handle message:\\\", _msg );\n\tif( msg.op == \\\"userLogin\\\" ) {\n\t\tif( !msg.id ) return true;\n\t\tif( saveRequestor( this.clientKeyRequests, ws )){\n\t\t\tthis.send( _msg );\n\t\t}return true;\n\t}\n\tif( msg.op == \\\"createUser\\\" ) {\n\t\tif( !msg.id ) return true;\n\t\tif( saveRequestor( this.clientKeyRequests, ws ))\n\t\t\tthis.send( _msg );\n\t\treturn true;\n\t}\n\tif( msg.op == \\\"checkAccount\\\" || msg.op == \\\"checkUser\\\" || msg.op == \\\"checkEmail\\\" ) {\n\t\tif(saveRequestor( this.clientKeyRequests, ws ))\n\t\t\tthis.send( _msg );\n\t\treturn true;\n\t}\n\tif( msg.op == \\\"getClientKey\\\" ) {\n\t\tif(saveRequestor( this.clientKeyRequests, ws ))\n\t\t\tmsg.remote = ws.connection.remoteAddress;\n\t\tthis.send( JSON.stringify( msg ) );\n\t\treturn true;\n\t}\n\treturn false;\n}\n//# startup-userdb-fireallextensions.js\n\n\"" )
console.log( "result:" );
console.log( val );