# Mercure Documentation

- [Mercure in a Few Words](mercure.md)
- [Getting Started](getting-started.md)

## Protocol Specification

- [The Specification](../spec/mercure.md) (also available as an [IETF Internet Draft](https://datatracker.ietf.org/doc/draft-dunglas-mercure/) designed to be published as an RFC)
- [Case studies and use cases](spec/use-cases.md)
- [Frequently Asked Questions](spec/faq.md)
- [OpenAPI spec](https://github.com/dunglas/mercure/blob/master/spec/openapi.yaml)

## Mercure.rocks Hub

- [Installing the Mercure.rocks Hub](hub/install.md)
- [Configuration](hub/config.md)
- [The Cloud version](hub/cloud.md)
- [Creating a cluster of hubs](hub/cluster.md)
- [Cookbooks](hub/cookbooks.md)
- [Running behind NGINX](hub/nginx.md)
- [Running behind Traefik Proxy](hub/traefik.md)
- [Troubleshooting](hub/troubleshooting.md)
- [Debug the Mercure.rocks Hub](hub/debug.md)
- [Upgrade to new versions](UPGRADE.md)
- [Load Testing](hub/load-test.md)

## Ecosystem

- [Awesome Mercure: Libraries, Examples and Learning Resources](ecosystem/awesome.md)
- [Using a Mercure Service in Your GitHub Actions](ecosystem/github-actions.md)
- [Using Mercure and Hotwire to Stream Page Changes](ecosystem/hotwire.md)
- [Getting Help](ecosystem/help.md)
- [Conformance Tests](ecosystem/conformance-tests.md)
