# 2018-11-17

zap and zerolog are from global GOPATH, using go1.11

based on https://godoc.org/golang.org/x/tools/benchmark/parse

- N number of iteration
- ns/op nano second per iteration
- B/op bytes allocated per iteration
- allocs/op allocs per iteration
- MB/s need to use `b.SetBytes` in test to have this working...

````text
go test -bench=. -benchmem
goos: linux
goarch: amd64
pkg: github.com/dyweb/gommon/log/_benchmarks
BenchmarkWithoutFieldsJSON/gommon-8         	10000000	       126 ns/op	     496 B/op	       4 allocs/op
BenchmarkWithoutFieldsJSON/Zap-8            	10000000	       205 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithoutFieldsJSON/Zap.Sugar-8      	 3000000	       353 ns/op	     128 B/op	       2 allocs/op
BenchmarkWithoutFieldsJSON/zerorlog-8       	10000000	       131 ns/op	       0 B/op	       0 allocs/op
PASS
ok  	github.com/dyweb/gommon/log/_benchmarks	6.617s
````

Need to see where the allocation comes from, need to focus on changing the interface of gommon first

- most allocation comes from the `formatHead` method of json handler
  - but how other library reduce allocation? using pool maybe?

````text
  Total:     17.55GB    17.55GB (flat, cum) 66.94%
     61            .          .           		s.Sync() 
     62            .          .           	} 
     63            .          .           } 
     64            .          .            
     65            .          .           func formatHead(level log.Level, time time.Time, msg string) []byte { 
     66       6.20GB     6.20GB           	b := make([]byte, 0, 5+4+10+len(msg)) 
     67            .          .           	b = append(b, `{"l":"`...) 
     68            .          .           	b = append(b, level.String()...) 
     69            .          .           	b = append(b, `","t":`...) 
     70            .          .           	b = strconv.AppendInt(b, time.Unix(), 10) 
     71            .          .           	b = append(b, `,"m":"`...) 
     72      11.35GB    11.35GB           	b = append(b, msg...) 
     73            .          .           	b = append(b, '"') 
     74            .          .           	return b 
     75            .          .           } 
     76            .          .            
     77            .          .           func formatFields(b []byte, fields log.Fields) []byte { 
````

After increase size of init slice and accept slice as input, the allocation is reduced by 1

````go
// handlers/json/handler.go
func formatHead(dst []byte, level log.Level, time int64, msg string) []byte {
	dst = append(dst, `{"l":"`...)
	dst = append(dst, level.String()...)
	dst = append(dst, `","t":`...)
	dst = strconv.AppendInt(dst, time, 10)
	dst = append(dst, `,"m":"`...)
	dst = append(dst, msg...)
	dst = append(dst, '"')
	return dst
}
````

After include logrus and apex/log

````text
BenchmarkWithoutFieldsText/gommon-8         	30000000	       129 ns/op	     272 B/op	       3 allocs/op
BenchmarkWithoutFieldsText/std-8            	10000000	       401 ns/op	     128 B/op	       2 allocs/op
BenchmarkWithoutFieldsText/zap-8            	20000000	       273 ns/op	      72 B/op	       3 allocs/op
BenchmarkWithoutFieldsText/zap.sugar-8      	20000000	       309 ns/op	     200 B/op	       5 allocs/op
BenchmarkWithoutFieldsText/zerolog-8        	 3000000	      1395 ns/op	    2011 B/op	      36 allocs/op
BenchmarkWithoutFieldsText/apex-8           	 3000000	      1551 ns/op	     320 B/op	      15 allocs/op
BenchmarkWithoutFieldsText/logrus-8         	 1000000	      3209 ns/op	     769 B/op	      15 allocs/op
BenchmarkWithoutFieldsJSON/gommon-8         	50000000	        79.6 ns/op	     288 B/op	       3 allocs/op
BenchmarkWithoutFieldsJSON/zap-8            	20000000	       179 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithoutFieldsJSON/zap.sugar-8      	20000000	       259 ns/op	     128 B/op	       2 allocs/op
BenchmarkWithoutFieldsJSON/zerolog-8        	50000000	       113 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithoutFieldsJSON/apex-8           	 2000000	      1920 ns/op	     512 B/op	      10 allocs/op
BenchmarkWithoutFieldsJSON/logrus-8         	 2000000	      2990 ns/op	    1218 B/op	      22 allocs/op
````

## Conclusion

- [ ] `formatHead` need to accept by and return byte in all handlers, the hard coded length for level and time need adjustment

## Commands

Ref

- https://www.ardanlabs.com/blog/2017/05/language-mechanics-on-escape-analysis.html
  - `go build -gcflags "-m -m" .`
- https://github.com/ardanlabs/gotraining/blob/master/topics/go/profiling/memcpu/README.md
  - `go test -run none -bench . -benchtime 3s -benchmem -memprofile p.out`
- https://segment.com/blog/allocation-efficiency-in-high-performance-go-services/
- https://rakyll.org/pprof-ui/
  - `go tool pprof -http=:8080 p.out`