# 2018-11-25

````text
go test -run none -bench . -benchtime 3s -benchmem -memprofile p.out
goos: linux
goarch: amd64
pkg: github.com/dyweb/gommon/log/_benchmarks
BenchmarkDisabledLevelNoFormat/gommon-8         	1000000000	         6.92 ns/op	      16 B/op	       1 allocs/op
BenchmarkDisabledLevelNoFormat/gommon.F-8       	5000000000	         0.58 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/gommon.check-8   	5000000000	         0.22 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/zap-8            	500000000	        10.9 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/zap.check-8      	500000000	        11.2 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/zap.sugar-8      	500000000	         9.32 ns/op	      16 B/op	       1 allocs/op
BenchmarkDisabledLevelNoFormat/zerolog-8        	5000000000	         1.66 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/apex-8           	2000000000	         2.56 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/logrus-8         	1000000000	         6.91 ns/op	      16 B/op	       1 allocs/op
BenchmarkWithoutFieldsText/gommon-8             	30000000	       132 ns/op	     288 B/op	       3 allocs/op
BenchmarkWithoutFieldsText/gommon.F-8           	50000000	        88.2 ns/op	     160 B/op	       1 allocs/op
BenchmarkWithoutFieldsText/std-8                	10000000	       401 ns/op	     128 B/op	       2 allocs/op
BenchmarkWithoutFieldsText/zap-8                	20000000	       275 ns/op	      72 B/op	       3 allocs/op
BenchmarkWithoutFieldsText/zap.sugar-8          	20000000	       311 ns/op	     200 B/op	       5 allocs/op
BenchmarkWithoutFieldsText/zerolog-8            	 3000000	      1422 ns/op	    2011 B/op	      36 allocs/op
BenchmarkWithoutFieldsText/apex-8               	 2000000	      1538 ns/op	     320 B/op	      15 allocs/op
BenchmarkWithoutFieldsText/logrus-8             	 1000000	      3154 ns/op	     769 B/op	      15 allocs/op
BenchmarkWithoutFieldsText/klog-8               	10000000	       615 ns/op	      16 B/op	       1 allocs/op
BenchmarkWithoutFieldsTextFormat/gommon-8       	20000000	       210 ns/op	     360 B/op	       4 allocs/op
BenchmarkWithoutFieldsTextFormat/zap.sugar-8    	10000000	       369 ns/op	     241 B/op	       6 allocs/op
BenchmarkWithoutFieldsTextFormat/apex-8         	 2000000	      1944 ns/op	     488 B/op	      18 allocs/op
BenchmarkWithoutFieldsTextFormat/logrus-8       	 1000000	      4012 ns/op	    1001 B/op	      18 allocs/op
BenchmarkWithoutFieldsTextFormat/klog-8         	10000000	       634 ns/op	      24 B/op	       2 allocs/op
BenchmarkWithoutFieldsJSON/gommon-8             	50000000	       107 ns/op	     288 B/op	       3 allocs/op
BenchmarkWithoutFieldsJSON/gommon.F-8           	100000000	        63.5 ns/op	     160 B/op	       1 allocs/op
BenchmarkWithoutFieldsJSON/zap-8                	30000000	       182 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithoutFieldsJSON/zap.sugar-8          	20000000	       260 ns/op	     128 B/op	       2 allocs/op
BenchmarkWithoutFieldsJSON/zerolog-8            	50000000	       116 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithoutFieldsJSON/apex-8               	 2000000	      2440 ns/op	     512 B/op	      10 allocs/op
BenchmarkWithoutFieldsJSON/logrus-8             	 1000000	      3867 ns/op	    1218 B/op	      22 allocs/op
BenchmarkWithContextFieldsJSON/gommon-8         	30000000	       158 ns/op	     608 B/op	       4 allocs/op
BenchmarkWithContextFieldsJSON/gommon.F-8       	30000000	       110 ns/op	     480 B/op	       2 allocs/op
BenchmarkWithContextFieldsJSON/zap-8            	30000000	       187 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithContextFieldsJSON/zap.sugar-8      	20000000	       258 ns/op	     128 B/op	       2 allocs/op
BenchmarkWithContextFieldsJSON/zerolog-8        	50000000	       113 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithContextFieldsJSON/apex-8           	 1000000	      4718 ns/op	    1089 B/op	      19 allocs/op
BenchmarkWithContextFieldsJSON/logrus-8         	 1000000	      5014 ns/op	    1362 B/op	      25 allocs/op
BenchmarkNoContextWithFieldsJSON/gommon.F-8     	30000000	       128 ns/op	     608 B/op	       3 allocs/op
BenchmarkNoContextWithFieldsJSON/zap-8          	20000000	       282 ns/op	     128 B/op	       1 allocs/op
BenchmarkNoContextWithFieldsJSON/zap.sugar-8    	20000000	       296 ns/op	     256 B/op	       1 allocs/op
BenchmarkNoContextWithFieldsJSON/zerolog-8      	30000000	       123 ns/op	       0 B/op	       0 allocs/op
BenchmarkNoContextWithFieldsJSON/apex-8         	 1000000	      4123 ns/op	    1545 B/op	      23 allocs/op
BenchmarkNoContextWithFieldsJSON/logrus-8       	 1000000	      4560 ns/op	    1844 B/op	      29 allocs/op
PASS
ok  	github.com/dyweb/gommon/log/_benchmarks	228.248s
````

gommon only

````text
  make bench-gommon 
go test -run none -bench=".*/gommon" -benchtime 3s -benchmem -memprofile p.out
goos: linux
goarch: amd64
pkg: github.com/dyweb/gommon/log/_benchmarks
BenchmarkDisabledLevelNoFormat/gommon-8         	1000000000	         6.81 ns/op	      16 B/op	       1 allocs/op
BenchmarkDisabledLevelNoFormat/gommon.F-8       	5000000000	         0.57 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/gommon.check-8   	5000000000	         0.22 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithoutFieldsText/gommon-8             	30000000	       129 ns/op	     288 B/op	       3 allocs/op
BenchmarkWithoutFieldsText/gommon.F-8           	50000000	        89.6 ns/op	     160 B/op	       1 allocs/op
BenchmarkWithoutFieldsTextFormat/gommon-8       	20000000	       202 ns/op	     360 B/op	       4 allocs/op
BenchmarkWithoutFieldsJSON/gommon-8             	50000000	       103 ns/op	     288 B/op	       3 allocs/op
BenchmarkWithoutFieldsJSON/gommon.F-8           	100000000	        61.9 ns/op	     160 B/op	       1 allocs/op
BenchmarkWithContextFieldsJSON/gommon-8         	30000000	       146 ns/op	     608 B/op	       4 allocs/op
BenchmarkWithContextFieldsJSON/gommon.F-8       	50000000	       103 ns/op	     480 B/op	       2 allocs/op
BenchmarkNoContextWithFieldsJSON/gommon.F-8     	30000000	       119 ns/op	     608 B/op	       3 allocs/op
PASS
ok  	github.com/dyweb/gommon/log/_benchmarks	49.553s
````

gommon, after allocating more space for fields, `.F` reduced to one alloc

````text
make bench-gommon     
go test -run none -bench=".*/gommon" -benchtime 3s -benchmem -memprofile p.out
goos: linux
goarch: amd64
pkg: github.com/dyweb/gommon/log/_benchmarks
BenchmarkDisabledLevelNoFormat/gommon-8         	1000000000	         6.91 ns/op	      16 B/op	       1 allocs/op
BenchmarkDisabledLevelNoFormat/gommon.F-8       	5000000000	         0.57 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/gommon.check-8   	5000000000	         0.23 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithoutFieldsText/gommon-8             	30000000	       130 ns/op	     288 B/op	       3 allocs/op
BenchmarkWithoutFieldsText/gommon.F-8           	50000000	        87.4 ns/op	     160 B/op	       1 allocs/op
BenchmarkWithoutFieldsTextFormat/gommon-8       	20000000	       205 ns/op	     360 B/op	       4 allocs/op
BenchmarkWithoutFieldsJSON/gommon-8             	50000000	       101 ns/op	     288 B/op	       3 allocs/op
BenchmarkWithoutFieldsJSON/gommon.F-8           	100000000	        62.2 ns/op	     160 B/op	       1 allocs/op
BenchmarkWithContextFieldsJSON/gommon-8         	30000000	       117 ns/op	     352 B/op	       3 allocs/op
BenchmarkWithContextFieldsJSON/gommon.F-8       	50000000	        74.0 ns/op	     224 B/op	       1 allocs/op
BenchmarkNoContextWithFieldsJSON/gommon.F-8     	50000000	        92.2 ns/op	     352 B/op	       2 allocs/op
PASS
ok  	github.com/dyweb/gommon/log/_benchmarks	48.130s
````

The allocation comes from ~~creating new slice~~ arguments escaped to heap because down the road they are passed as parameter
to interface method calls

````text
BenchmarkWithContextFieldsJSON/gommon.F-8       	50000000	        74.0 ns/op	     224 B/op	       1 allocs/op
BenchmarkNoContextWithFieldsJSON/gommon.F-8     	50000000	        92.2 ns/op	     352 B/op	       2 allocs/op
````

````go
    533       6.05GB    16.61GB           				logger.InfoF(msg, dlog.Fields{ 
    534            .          .           					dlog.Int("i1", 1), dlog.Str("s1", "v1"), 
````

Found the reason

- first there is a typo ... `BenchmarkWithContextFieldsJSON` should be `BenchmarkWithContextNoFieldsJSON`
- second is handler is interface, since fields are passed to handler, it will have the `parameter to indirect call` problem,
  - [ ] the 128 bytes is because we have two fields? and size of each field is 64 byte (or is same as zap's)
- zerolog does not have the problem because when its field method like `Int` it didn't call any method any interface,
it just encode to bytes directly, which is why zerolog's text is extremely slow, because it need to decode all the encoded ...

````go
var (
	enc = json.Encoder{}
)

func (e *Event) Int(key string, i int) *Event {
	if e == nil {
		return e
	}
	e.buf = enc.AppendInt(enc.AppendKey(e.buf, key), i)
	return e
}

func (Encoder) AppendInt(dst []byte, val int) []byte {
	return strconv.AppendInt(dst, int64(val), 10)
}

// Write transforms the JSON input with formatters and appends to w.Out.
func (w ConsoleWriter) Write(p []byte) (n int, err error) {
	var evt map[string]interface{}
	p = decodeIfBinaryToBytes(p)
	d := json.NewDecoder(bytes.NewReader(p))
	d.UseNumber()
	err = d.Decode(&evt)
	if err != nil {
		return n, fmt.Errorf("cannot decode event: %s", err)
	}

	for _, p := range w.PartsOrder {
		w.writePart(buf, evt, p)
	}

	w.writeFields(evt, buf)

	buf.WriteByte('\n')
	buf.WriteTo(w.Out)
	return len(p), nil
}
````
 
````text
make bench
go test -run none -bench . -benchtime 3s -benchmem -memprofile p.out
goos: linux
goarch: amd64
pkg: github.com/dyweb/gommon/log/_benchmarks
BenchmarkDisabledLevelNoFormat/gommon-8         	1000000000	         8.35 ns/op	      16 B/op	       1 allocs/op
BenchmarkDisabledLevelNoFormat/gommon.F-8       	5000000000	         0.58 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/gommon.check-8   	5000000000	         0.23 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/zap-8            	500000000	        13.2 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/zap.check-8      	300000000	        14.6 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/zap.sugar-8      	300000000	        11.3 ns/op	      16 B/op	       1 allocs/op
BenchmarkDisabledLevelNoFormat/zerolog-8        	5000000000	         1.74 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/apex-8           	2000000000	         2.60 ns/op	       0 B/op	       0 allocs/op
BenchmarkDisabledLevelNoFormat/logrus-8         	1000000000	         7.40 ns/op	      16 B/op	       1 allocs/op
BenchmarkWithoutFieldsText/gommon-8             	30000000	       145 ns/op	     288 B/op	       3 allocs/op
BenchmarkWithoutFieldsText/gommon.F-8           	50000000	        99.1 ns/op	     160 B/op	       1 allocs/op
BenchmarkWithoutFieldsText/std-8                	10000000	       446 ns/op	     128 B/op	       2 allocs/op
BenchmarkWithoutFieldsText/zap-8                	20000000	       293 ns/op	      72 B/op	       3 allocs/op
BenchmarkWithoutFieldsText/zap.sugar-8          	20000000	       327 ns/op	     200 B/op	       5 allocs/op
BenchmarkWithoutFieldsText/zerolog-8            	 3000000	      1414 ns/op	    2012 B/op	      36 allocs/op
BenchmarkWithoutFieldsText/apex-8               	 3000000	      1549 ns/op	     320 B/op	      15 allocs/op
BenchmarkWithoutFieldsText/logrus-8             	 1000000	      3469 ns/op	     769 B/op	      15 allocs/op
BenchmarkWithoutFieldsText/klog-8               	10000000	       674 ns/op	      16 B/op	       1 allocs/op
BenchmarkWithoutFieldsTextFormat/gommon-8       	20000000	       283 ns/op	     360 B/op	       4 allocs/op
BenchmarkWithoutFieldsTextFormat/zap.sugar-8    	10000000	       379 ns/op	     241 B/op	       6 allocs/op
BenchmarkWithoutFieldsTextFormat/apex-8         	 2000000	      1976 ns/op	     488 B/op	      18 allocs/op
BenchmarkWithoutFieldsTextFormat/logrus-8       	 1000000	      4055 ns/op	    1001 B/op	      18 allocs/op
BenchmarkWithoutFieldsTextFormat/klog-8         	10000000	       690 ns/op	      24 B/op	       2 allocs/op
BenchmarkWithoutFieldsJSON/gommon-8             	30000000	       135 ns/op	     288 B/op	       3 allocs/op
BenchmarkWithoutFieldsJSON/gommon.F-8           	100000000	        70.7 ns/op	     160 B/op	       1 allocs/op
BenchmarkWithoutFieldsJSON/zap-8                	30000000	       186 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithoutFieldsJSON/zap.sugar-8          	20000000	       263 ns/op	     128 B/op	       2 allocs/op
BenchmarkWithoutFieldsJSON/zerolog-8            	50000000	       115 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithoutFieldsJSON/apex-8               	 2000000	      2010 ns/op	     512 B/op	      10 allocs/op
BenchmarkWithoutFieldsJSON/logrus-8             	 1000000	      3138 ns/op	    1218 B/op	      22 allocs/op
BenchmarkWithContextNoFieldsJSON/gommon-8       	30000000	       127 ns/op	     352 B/op	       3 allocs/op
BenchmarkWithContextNoFieldsJSON/gommon.F-8     	50000000	        75.9 ns/op	     224 B/op	       1 allocs/op
BenchmarkWithContextNoFieldsJSON/zap-8          	30000000	       186 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithContextNoFieldsJSON/zap.sugar-8    	20000000	       262 ns/op	     128 B/op	       2 allocs/op
BenchmarkWithContextNoFieldsJSON/zerolog-8      	50000000	       113 ns/op	       0 B/op	       0 allocs/op
BenchmarkWithContextNoFieldsJSON/apex-8         	 1000000	      3609 ns/op	    1089 B/op	      19 allocs/op
BenchmarkWithContextNoFieldsJSON/logrus-8       	 1000000	      4560 ns/op	    1362 B/op	      25 allocs/op
BenchmarkNoContextWithFieldsJSON/gommon.F-8     	50000000	        96.8 ns/op	     352 B/op	       2 allocs/op
BenchmarkNoContextWithFieldsJSON/zap-8          	20000000	       263 ns/op	     128 B/op	       1 allocs/op
BenchmarkNoContextWithFieldsJSON/zap.sugar-8    	20000000	       298 ns/op	     256 B/op	       1 allocs/op
BenchmarkNoContextWithFieldsJSON/zerolog-8      	30000000	       124 ns/op	       0 B/op	       0 allocs/op
BenchmarkNoContextWithFieldsJSON/apex-8         	 1000000	      4498 ns/op	    1545 B/op	      23 allocs/op
BenchmarkNoContextWithFieldsJSON/logrus-8       	 1000000	      4678 ns/op	    1844 B/op	      29 allocs/op
PASS
ok  	github.com/dyweb/gommon/log/_benchmarks	236.741s
````