# 2018-09-05

Haven't really write clear doc about the design decisions made along the way, so start from now

## Issues

Handler

- `MultiHandler` for fan out [#87](https://github.com/dyweb/gommon/issues/87)
- add parser for generated log [#89](https://github.com/dyweb/gommon/issues/89)

Context (tree hierarchy)

- Use fields attached to logger [#79](https://github.com/dyweb/gommon/issues/79)
- Simplify relationship of loggers [#78](https://github.com/dyweb/gommon/issues/78)
- A tree of logger has GC problem [#33](https://github.com/dyweb/gommon/issues/33)

Runtime

- allow specify caller skip [#86](https://github.com/dyweb/gommon/issues/86)
- debug log in init never show [#60](https://github.com/dyweb/gommon/issues/60)

Performance

- add benchmark code [#88](https://github.com/dyweb/gommon/issues/88)

## Background

### History

In the early design and implementation, gommon/log is basically following other libraries, 
v1 followed logrus (using structured logging, have entry, formatter and writer).
v2 followed zap (using typed fields) and apex/log (using handler to replace formatter and writer).

### Goals

Performance was a goal, though I always say it's not a major goal, but that can't explain those ugly magic number 
and manually inline in handlers. However, without out measurement, those things could lead to poor performance.
Also performance is sometimes opposite with (strict) correctness, like if you don't do escape on fields, it will
be faster but if will break json format if you log a field with key `"contains quote"`, and if you don't de-dup fields
by key, careless user may log same key twice.

Observability or fine grained control is another goal, this is mainly from using Solr during my internship at PayPal.
Solr has an admin page to control logging level of individual package, which is really amazing.
Considering when  people report bug of an application and attach the log, 
it will be filled with useless information when debug level is turned on for every library, 
however if you can control level of single package (including those from dependency), 
you can just ask user to run it with specific log flags like `--log-debug-packages=gommon,go.ice` 

### Current

Current implementation (before this refactor) is already usable (for a long time).
However, it's far from production ready, I need a 'new' gommon for a side project at work, 
an advanced e2e test framework that writes log to both file and stdout and eventually ship to ELK.

There are something I really like about current implementation.

First is simplicity, unlike zap which pass struct around with slice of pointers (interfaces) in struct field,
all a handler needed is its function parameters, no entry struct.

Second is using generator, a logging library, especially a leveled logging library, 
a bunch of code is duplicated, `Info` has no difference with `Debug`. 
Go does not have marco, but you can use `text/template` and then call format to have a poor man's generator.
A counter example is logrus, one thing surprised me about logrus is when you call `logrus.Infof` it is calling `logrus.Info(fmt.Sprintf)`,
this add extra call stack and makes finding source line for logrus hard, you need to traverse callers until you find one that is not logrus.

There are something I really don't like about current implementation as well.

First is over design, the tree of logger is inspired by solr but it goes too extreme, when each struct logger is
child of a package logger, the children map will contain a bunch of trash and may even cause those struct can't be
garbage collected.

Second is blind optimization on performance with sacrifice on correctness, using magic number for initial slice size
when formatting is not wise, and don't escape for cli handler is fine, for json handler it's damaging.

Third is no design doc before implementation, normally after the implementation I forgot the detail in 1 week if not 1 day,
and for some other libraries like noodle, I even [forgot how to use it](https://github.com/dyweb/gommon/pull/83).

## Implementation

This section is written two weeks after the start of the doc due to I can't free myself from working stuff (I can't blame
anyone for that though, was having a good time before the ddl approached)

Before starting implementation, I first need to sort out of the dependency between the issues I am going to solve 
in this milestone, it's not just I can pick the hardest/easiest, interface/functionality change may cause previous 
effort in vain, and the order matters.

I decided to go with benchmark first, there are two reasons. First writing benchmark force me to use other people's library
and I may have overlooked something when I am looking at godoc and source code. Second, benchmark can be used throughout
rest of the implementation in this milestone, especially when it comes to fields, tree of logger, handler interface and
implementation, there were many blind optimization that makes the code hard to maintain, but I have no clue if they
are following my assumption or the opposite.

After benchmark is partially settled (we don't support inherit parent logger's fields so can't replica zap's benchmark fully),
We can start rework on fields, first is log should combine fields in logger and ad-hoc fields, this requires change in
handler interface and implementations (which was mainly copy and paste ...)

At last is the tree of logger problem and improve logging source line (i.e. allow skip caller, using fields maybe)
