package stdlib

import (
	"fmt"
	"os"
	"testing"
)

// For #31 [log] extra square brackets when using fmt.Sprint
// https://github.com/dyweb/gommon/issues/31

func printArgs(args ...interface{}) {
	//	fmt.Println(args) // WRONG, it will have [arg1 arg2 arg3] NOTE: this is already disabled when go test is used
	fmt.Println(args...)
}

func TestFmt_Sprintf(t *testing.T) {
	fmt.Print("This a debug message", 1, "\n")
	fmt.Println("This a debug message", 1) // NOTE: Println add space between words, and \n at last
	fmt.Fprintln(os.Stdout, fmt.Sprint("This a debug message", 1))
	printArgs("Tell me", 123)
}
