/*
 *   Copyright (c) 2019 Dario Lucia (https://www.dariolucia.eu)
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

package eu.dariolucia.ccsds.encdec.definition;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.io.Serializable;

/**
 * This class allows to specify where the parameter is encoded: at a fixed absolute location (see {@link FixedAbsoluteLocation}) or at a relative location
 * with respect to the current position (see {@link LastRelativeLocation}).
 */
@XmlAccessorType(XmlAccessType.FIELD)
public abstract class AbstractEncodedLocation implements Serializable { // NOSONAR I won't convert this class into an interface, logically it is not an interface

    public AbstractEncodedLocation() {
        // Nothing to do
    }
}
