/*
 * Copyright 2018-2019 Dario Lucia (https://www.dariolucia.eu)
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package eu.dariolucia.ccsds.inspector.api;

public interface IConnector {

    String ANNOTATION_TIME_KEY = "Time";

    String getName();

	String getDescription();

	String getVersion();

	void start();

	default void step() {
		throw new UnsupportedOperationException();
	}

	void stop();

	boolean isDisposed();

	boolean isStarted();

	ConnectorConfiguration getConfiguration();

	void dispose();
}
