/*
 *   Copyright (c) 2019 Dario Lucia (https://www.dariolucia.eu)
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

package eu.dariolucia.ccsds.tmtc.cop1.fop;

import eu.dariolucia.ccsds.tmtc.datalink.pdu.TcTransferFrame;

/**
 * Listener interface for FOP status and operations.
 */
public interface IFopObserver {

    /**
     * Notify that the reported {@link TcTransferFrame} reached the reported status.
     *
     * @param engine the FOP entity
     * @param status the TC frame status
     * @param frame the TC frame
     */
    void transferNotification(FopEngine engine, FopOperationStatus status, TcTransferFrame frame);

    /**
     * Notify that the reported directive, identified by the tag, reached the reported status.
     *
     * @param engine the FOP entity
     * @param status the directive status
     * @param tag the tag to identify the directive invocation
     * @param directive the directive ID
     * @param qualifier the directive qualifier
     */
    void directiveNotification(FopEngine engine, FopOperationStatus status, Object tag, FopDirective directive, int qualifier);

    /**
     * Notify an alert indication, with code, generated by the FOP engine.
     *
     * @param engine the FOP entity
     * @param code the alert code
     */
    void alert(FopEngine engine, FopAlertCode code);

    /**
     * Notify a suspend indication generated by the FOP engine.
     *
     * @param engine the FOP entity
     */
    void suspend(FopEngine engine);

    /**
     * Provide a status report of the internal FOP engine status.
     *
     * @param engine the FOP entity
     * @param status the FOP status
     */
    void statusReport(FopEngine engine, FopStatus status);
}
