/*
 * Copyright 2018-2019 Dario Lucia (https://www.dariolucia.eu)
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package eu.dariolucia.ccsds.tmtc.datalink.builder;

import eu.dariolucia.ccsds.tmtc.datalink.pdu.AbstractTransferFrame;

/**
 * A common interface for builder objects that construct transfer frames.
 *
 * @param <T> the specific type of the transfer frame
 */
public interface ITransferFrameBuilder<T extends AbstractTransferFrame> {

    /**
     * Factory method to create the transfer frame.
     *
     * @return the transfer frame
     */
    T build();

    /**
     * This method returns the currently available user data in bytes.
     *
     * @return the currently available user data in bytes
     */
    int getFreeUserDataLength();

}
