/*
 * Copyright 2018-2019 Dario Lucia (https://www.dariolucia.eu)
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package eu.dariolucia.ccsds.tmtc.datalink.pdu;

import eu.dariolucia.ccsds.tmtc.util.StringUtil;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

class TmTransferFrameTest {

    private static byte[] FIRST_FRAME = StringUtil.toByteArray( "07B503B29A9E0302B0D60000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001DFA500014DAFF14108B4D5710025100319000CBC6A7B0B17C201BE119B3F20900000BE22EA6731FAEC003E2D164972EA2380A18108A4FEC60024100319000CBC6A7B120165079007900776075E076E07740792075A075907670764076FD3E808B2ED08008C100319000CBC6A7B2B1A2FBFE8C9FBF45FEC72BFE3E7C9A27A5122BF8D5C4B59858D8CBFBCEBCD2636C89EBF330D11BE32FF43BEAC4FD48350BFD53E7D715A42B709AF0000000000000000BEA4031FF4DEEAC1BE9BE3D0805555B60000000000000000000000000000000000000000000000000000000A0000017C0000024E0000000A0000000A000000146AF008C4CAED0173100319000CBC6A7B8EEA6B002E0CBC6A79000C00050000FFFF007000000000819495F1302EFFFF00037FFF0000000000000000000000000000000000000000000000000000000000000000000A7E42262466D6FF697F7F1C2B292300003E0D0000000100000000005FBFF0000000BF0000AC9030FF0000000000000000000000000000000000000000000000008E5400001401FFFFFF0000070A100A0309FB09F50A1A09F409EB09F009FA0A0009EB0A070A030A040A1C0A1809F3086D01080002A689");
    private static byte[] SECOND_FRAME = StringUtil.toByteArray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

    @Test
    public void testTmTransferFrameDecoding() {
        TmTransferFrame ttf = new TmTransferFrame(FIRST_FRAME, false);
        assertEquals(123, ttf.getSpacecraftId());
        assertEquals(2, ttf.getVirtualChannelId());
        assertTrue(ttf.isOcfPresent());
        assertEquals(ttf.getLength() - 4, ttf.getOcfStart());
        assertEquals(3, ttf.getMasterChannelFrameCount());
        assertEquals(178, ttf.getVirtualChannelFrameCount());
        assertTrue(ttf.isSecondaryHeaderPresent());
        assertFalse(ttf.isSynchronisationFlag());
        assertFalse(ttf.isPacketOrderFlag());
        assertEquals(3, ttf.getSegmentLengthIdentifier());
        assertEquals(0, ttf.getSecondaryHeaderVersionNumber());
        assertEquals(3, ttf.getSecondaryHeaderLength());

        ttf = new TmTransferFrame(SECOND_FRAME, false);
        assertEquals(123, ttf.getSpacecraftId());
        assertEquals(2, ttf.getVirtualChannelId());
        assertTrue(ttf.isOcfPresent());
    }
}