const encodeTable = (table) => {
  const result = new Uint8Array(table.length);
  table.forEach((e, index) => {
    result[index] = e.charCodeAt(0)
  });
  return result;
}

export const stressInputTable = encodeTable(['*', '1', '2', '3', '4', '5', '6', '7', '8']);

export const signInputTable1 = encodeTable([
  ' ', '.', '?', ',', '-', 'I', 'I', 'E',
  'A', 'A', 'A', 'A', 'U', 'A', 'I', 'E',
  'U', 'O', 'R', 'L', 'W', 'Y', 'W', 'R',
  'L', 'W', 'Y', 'M', 'N', 'N', 'D', 'Q',
  'S', 'S', 'F', 'T', '/', '/', 'Z', 'Z',
  'V', 'D', 'C', '*', 'J', '*', '*', '*',
  'E', 'A', 'O', 'A', 'O', 'U', 'B', '*',
  '*', 'D', '*', '*', 'G', '*', '*', 'G',
  '*', '*', 'P', '*', '*', 'T', '*', '*',
  'K', '*', '*', 'K', '*', '*', 'U', 'U',
  'U'
]);
export const signInputTable2 = encodeTable([
  '*', '*', '*', '*', '*', 'Y', 'H', 'H',
  'E', 'A', 'H', 'O', 'H', 'X', 'X', 'R',
  'X', 'H', 'X', 'X', 'X', 'X', 'H', '*',
  '*', '*', '*', '*', '*', 'X', 'X', '*',
  '*', 'H', '*', 'H', 'H', 'X', '*', 'H',
  '*', 'H', 'H', '*', '*', '*', '*', '*',
  'Y', 'Y', 'Y', 'W', 'W', 'W', '*', '*',
  '*', '*', '*', '*', '*', '*', '*', 'X',
  '*', '*', '*', '*', '*', '*', '*', '*',
  '*', '*', '*', 'X', '*', '*', 'L', 'M',
  'N'
]);

// Merged from the original two tables via:
//   oldFlags[i] | (oldFlags2[i] << 8)
export const flags = [
  0x8000, 0xC100, 0xC100, 0xC100, 0xC100, 0x00A4, 0x00A4, 0x00A4,
  0x00A4, 0x00A4, 0x00A4, 0x0084, 0x0084, 0x00A4, 0x00A4, 0x0084,
  0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0044, 0x1044,
  0x1044, 0x1044, 0x1044, 0x084C, 0x0C4C, 0x084C, 0x0448, 0x404C,

  0x2440, 0x2040, 0x2040, 0x2440, 0x0040, 0x0040, 0x2444, 0x2044,
  0x2044, 0x2444, 0x2048, 0x2040, 0x004C, 0x2044, 0x0000, 0x0000,
  0x00B4, 0x00B4, 0x00B4, 0x0094, 0x0094, 0x0094, 0x004E, 0x004E,

  0x004E, 0x044E, 0x044E, 0x044E, 0x004E, 0x004E, 0x004E, 0x004E,
  0x004E, 0x004E, 0x004B, 0x004B, 0x004B, 0x044B, 0x044B, 0x044B,
  0x004B, 0x004B, 0x004B, 0x004B, 0x004B, 0x004B, 0x0080, 0x00C1,
  0x00C1
];

export const phonemeStressedLengthTable = [
  0x00, 0x12, 0x12, 0x12, 0x08, 0x0B, 0x09, 0x0B,
  0x0E, 0x0F, 0x0B, 0x10, 0x0C, 0x06, 0x06, 0x0E,
  0x0C, 0x0E, 0x0C, 0x0B, 0x08, 0x08, 0x0B, 0x0A,
  0x09, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x05,
  0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x06, 0x06,
  0x08, 0x06, 0x06, 0x02, 0x09, 0x04, 0x02, 0x01,
  0x0E, 0x0F, 0x0F, 0x0F, 0x0E, 0x0E, 0x08, 0x02,
  0x02, 0x07, 0x02, 0x01, 0x07, 0x02, 0x02, 0x07,
  0x02, 0x02, 0x08, 0x02, 0x02, 0x06, 0x02, 0x02,
  0x07, 0x02, 0x04, 0x07, 0x01, 0x04, 0x05, 0x05
];
export const phonemeLengthTable = [
  0x00, 0x12, 0x12, 0x12, 0x08, 0x08, 0x08, 0x08,
  0x08, 0x0B, 0x06, 0x0C, 0x0A, 0x05, 0x05, 0x0B,
  0x0A, 0x0A, 0x0A, 0x09, 0x08, 0x07, 0x09, 0x07,
  0x06, 0x08, 0x06, 0x07, 0x07, 0x07, 0x02, 0x05,
  0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x06, 0x06,
  0x07, 0x06, 0x06, 0x02, 0x08, 0x03, 0x01, 0x1E,
  0x0D, 0x0C, 0x0C, 0x0C, 0x0E, 0x09, 0x06, 0x01,
  0x02, 0x05, 0x01, 0x01, 0x06, 0x01, 0x02, 0x06,
  0x01, 0x02, 0x08, 0x02, 0x02, 0x04, 0x02, 0x02,
  0x06, 0x01, 0x04, 0x06, 0x01, 0x04, 0xC7, 0xFF
];

/*

Ind  | phoneme |  flags   |
-----|---------|----------|
0    |   *     | 00000000 |
1    |  .*     | 00000000 |
2    |  ?*     | 00000000 |
3    |  ,*     | 00000000 |
4    |  -*     | 00000000 |

VOWELS
5    |  IY     | 10100100 |
6    |  IH     | 10100100 |
7    |  EH     | 10100100 |
8    |  AE     | 10100100 |
9    |  AA     | 10100100 |
10   |  AH     | 10100100 |
11   |  AO     | 10000100 |
17   |  OH     | 10000100 |
12   |  UH     | 10000100 |
16   |  UX     | 10000100 |
15   |  ER     | 10000100 |
13   |  AX     | 10100100 |
14   |  IX     | 10100100 |

DIPHTONGS
48   |  EY     | 10110100 |
49   |  AY     | 10110100 |
50   |  OY     | 10110100 |
51   |  AW     | 10010100 |
52   |  OW     | 10010100 |
53   |  UW     | 10010100 |


21   |  YX     | 10000100 |
20   |  WX     | 10000100 |
18   |  RX     | 10000100 |
19   |  LX     | 10000100 |
37   |  /X     | 01000000 |
30   |  DX     | 01001000 |


22   |  WH     | 01000100 |


VOICED CONSONANTS
23   |  R*     | 01000100 |
24   |  L*     | 01000100 |
25   |  W*     | 01000100 |
26   |  Y*     | 01000100 |
27   |  M*     | 01001100 |
28   |  N*     | 01001100 |
29   |  NX     | 01001100 |
54   |  B*     | 01001110 |
57   |  D*     | 01001110 |
60   |  G*     | 01001110 |
44   |  J*     | 01001100 |
38   |  Z*     | 01000100 |
39   |  ZH     | 01000100 |
40   |  V*     | 01000100 |
41   |  DH     | 01000100 |

unvoiced CONSONANTS
32   |  S*     | 01000000 |
33   |  SH     | 01000000 |
34   |  F*     | 01000000 |
35   |  TH     | 01000000 |
66   |  P*     | 01001011 |
69   |  T*     | 01001011 |
72   |  K*     | 01001011 |
42   |  CH     | 01001000 |
36   |  /H     | 01000000 |

43   |  **     | 01000000 |
45   |  **     | 01000100 |
46   |  **     | 00000000 |
47   |  **     | 00000000 |


55   |  **     | 01001110 |
56   |  **     | 01001110 |
58   |  **     | 01001110 |
59   |  **     | 01001110 |
61   |  **     | 01001110 |
62   |  **     | 01001110 |
63   |  GX     | 01001110 |
64   |  **     | 01001110 |
65   |  **     | 01001110 |
67   |  **     | 01001011 |
68   |  **     | 01001011 |
70   |  **     | 01001011 |
71   |  **     | 01001011 |
73   |  **     | 01001011 |
74   |  **     | 01001011 |
75   |  KX     | 01001011 |
76   |  **     | 01001011 |
77   |  **     | 01001011 |


SPECIAL
78   |  UL     | 10000000 |
79   |  UM     | 11000001 |
80   |  UN     | 11000001 |
31   |  Q*     | 01001100 |

*/
