function UTConfigurationDAO(e) {
  UTObject.call(this),
    utils.Debug.Assert(
      utils.JS.isValid(e) && e.conforms(interfaces.AuthDelegate),
      'Expected an object conforming to the AuthDelegate interface.'
    ),
    (this._authDelegate = e),
    Object.defineProperty(this, '_authDelegate', {
      writable: !1,
      enumerable: !1
    });
}

function UTCampaignEntryUpdateDTO(e, t, i, s, n, o) {
  UTObject.call(this),
    (this.categoryId = e),
    Object.defineProperty(this, 'categoryId', {
      writable: !1,
      enumerable: !0
    }),
    (this.groupId = t),
    Object.defineProperty(this, 'groupId', {
      writable: !1,
      enumerable: !0
    }),
    (this.objectiveId = i),
    Object.defineProperty(this, 'objectiveId', {
      writable: !1,
      enumerable: !0
    }),
    (this.groupState = s),
    Object.defineProperty(this, 'groupState', {
      writable: !1,
      enumerable: !0
    }),
    (this.objectiveState = n),
    Object.defineProperty(this, 'objectiveState', {
      writable: !1,
      enumerable: !0
    }),
    (this.objectiveProgress = o),
    Object.defineProperty(this, 'objectiveProgress', {
      writable: !1,
      enumerable: !0
    });
}

function UTMessagesDAO(e) {
  UTObject.call(this),
    utils.Debug.Assert(
      utils.JS.isValid(e) && e.conforms(interfaces.AuthDelegate),
      'Expected an object conforming to the AuthDelegate interface.'
    ),
    (this._authDelegate = e),
    Object.defineProperty(this, '_authDelegate', {
      writable: !1,
      enumerable: !1
    });
}

function UTCampaignEntity(e) {
  UTObject.call(this),
    (this.title = e.title || ''),
    Object.defineProperty(this, 'title', {
      writable: !1,
      enumerable: !0
    }),
    (this.startTime = e.startTime || 0),
    Object.defineProperty(this, 'startTime', {
      writable: !1,
      enumerable: !0
    }),
    (this.endTime = e.endTime || 0),
    Object.defineProperty(this, 'endTime', {
      writable: !1,
      enumerable: !0
    }),
    (this.serverCrtTime = e.serverCrtTime || 0),
    Object.defineProperty(this, 'serverCrtTime', {
      writable: !1,
      enumerable: !0
    }),
    (this.nextCampaignStartTime = e.nextCampaignStartTime || 0),
    Object.defineProperty(this, 'nextCampaignStartTime', {
      writable: !1,
      enumerable: !0
    }),
    (this.hasPreviousCampaign = e.hasPreviousCampaign || !1),
    Object.defineProperty(this, 'hasPreviousCampaign', {
      writable: !1,
      enumerable: !0
    }),
    (this.needsAutoClaim = e.needsAutoClaim || !1),
    Object.defineProperty(this, 'needsAutoClaim', {
      writable: !1,
      enumerable: !0
    }),
    (this.remainingRewards = e.remainingRewards || 0),
    Object.defineProperty(this, 'remainingRewards', {
      writable: !0,
      enumerable: !0
    }),
    (this.campaignBg = e.campaignBg || ''),
    Object.defineProperty(this, 'campaignBg', {
      writable: !1,
      enumerable: !0
    }),
    (this.campaignSquadBg = e.campaignSquadBg || ''),
    Object.defineProperty(this, 'campaignSquadBg', {
      writable: !1,
      enumerable: !0
    }),
    (this.campaignWidgetBg = e.campaignWidgetBg || ''),
    Object.defineProperty(this, 'campaignWidgetBg', {
      writable: !1,
      enumerable: !0
    }),
    (this.campaignWidgetIcon = e.campaignWidgetIcon || ''),
    Object.defineProperty(this, 'campaignWidgetIcon', {
      writable: !1,
      enumerable: !0
    }),
    (this.categoryIds = Array.isArray(e.categoriesList)
      ? e.categoriesList.map(function(e) {
          return e.categoryId;
        })
      : []),
    Object.defineProperty(this, 'categoryIds', {
      writable: !1,
      enumerable: !0
    }),
    (this.levels = new UTHashTable()),
    Object.defineProperty(this, 'levels', {
      writable: !1,
      enumerable: !0
    }),
    (this.xp = e.userXp),
    Object.defineProperty(this, 'xp', {
      writable: !0,
      enumerable: !0
    });
}

function UTCampaignCategoryEntity(e, t) {
  UTObject.call(this),
    (this.id = e.categoryId),
    Object.defineProperty(this, 'id', {
      writable: !1,
      enumerable: !0
    }),
    (this.priority = e.priority),
    Object.defineProperty(this, 'priority', {
      writable: !1,
      enumerable: !0
    }),
    (this.name = e.name),
    Object.defineProperty(this, 'name', {
      writable: !1,
      enumerable: !0
    }),
    (this.groups = new UTHashTable()),
    Object.defineProperty(this, 'groups', {
      writable: !1,
      enumerable: !0
    }),
    t.forEach(function(e) {
      this.groups.set(e.id, e);
    }, this);
}

function UTCampaignGroupEntity(e) {
  var i;
  UTObject.call(this),
    (this.id = e.groupId),
    Object.defineProperty(this, 'id', {
      writable: !1,
      enumerable: !0
    }),
    (this.priority = e.priority),
    Object.defineProperty(this, 'priority', {
      writable: !1,
      enumerable: !0
    }),
    (this.title = e.title),
    Object.defineProperty(this, 'title', {
      writable: !1,
      enumerable: !0
    }),
    (this.subtitle = e.subTitle),
    Object.defineProperty(this, 'subtitle', {
      writable: !1,
      enumerable: !0
    }),
    (this.state = e.groupState || enums.Objectives.GroupState.UNDEFINED_STATE),
    Object.defineProperty(this, 'state', {
      writable: !0,
      enumerable: !0
    }),
    Object.defineProperty(this, 'type', {
      get: function() {
        return i;
      },
      set: function(e) {
        var t;
        for (t in enums.Objectives.GroupType)
          if (
            enums.Objectives.GroupType.hasOwnProperty(t) &&
            enums.Objectives.GroupType[t] === e
          )
            return void (i = e);
        utils.Debug.Assert(
          !1,
          'UTCampaignGroupEntity::Unsupported Group Type.'
        );
      },
      enumerable: !0
    }),
    (this.type = e.groupType),
    (this.startTime = e.startTime),
    Object.defineProperty(this, 'startTime', {
      writable: !1,
      enumerable: !0
    }),
    (this.endTime = e.endTime),
    Object.defineProperty(this, 'endTime', {
      writable: !1,
      enumerable: !0
    }),
    (this.visibilityTime = e.visibilityTime),
    Object.defineProperty(this, 'visibilityTime', {
      writable: !1,
      enumerable: !0
    }),
    (this.objectivesNumber = e.objectivesNumber || 0),
    Object.defineProperty(this, 'objectivesNumber', {
      writable: !1,
      enumerable: !0
    }),
    (this.objectivesCompleted = e.objectivesCompleted),
    Object.defineProperty(this, 'objectivesCompleted', {
      writable: !1,
      enumerable: !0
    }),
    (this.groupIdsToUnlock = e.groupIdsToUnlock || []),
    Object.defineProperty(this, 'groupIdsToUnlock', {
      writable: !1,
      enumerable: !0
    }),
    (this.awards = utils.JS.valToArray(e.awardsList).map(function(e) {
      return new transferobjects.Reward(e);
    })),
    Object.defineProperty(this, 'awards', {
      writable: !1,
      enumerable: !0
    }),
    (this.objectives = new UTHashTable()),
    Object.defineProperty(this, 'objectives', {
      writable: !1,
      enumerable: !0
    }),
    (this._isLockedByGroups = !1),
    Object.defineProperty(this, '_isLockedByGroups', {
      writable: !0,
      enumerable: !0
    });
}

function UTCampaignObjectiveEntity(e, t, i) {
  var s;
  UTObject.call(this),
    (this.id = e.objectiveId),
    Object.defineProperty(this, 'id', {
      writable: !1,
      enumerable: !0
    }),
    (this.title = e.name),
    Object.defineProperty(this, 'title', {
      writable: !1,
      enumerable: !0
    }),
    (this.description = e.description),
    Object.defineProperty(this, 'description', {
      writable: !1,
      enumerable: !0
    }),
    (this.shortDescription = e.shortDescription),
    Object.defineProperty(this, 'shortDescription', {
      writable: !1,
      enumerable: !0
    }),
    (this.imageBase = e.imageBase),
    Object.defineProperty(this, 'imageBase', {
      writable: !1,
      enumerable: !0
    }),
    (this.gameArea = e.gameArea),
    Object.defineProperty(this, 'gameArea', {
      writable: !1,
      enumerable: !0
    }),
    Object.defineProperty(this, 'link', {
      get: function() {
        return s;
      },
      set: function(e) {
        var t;
        for (t in ((e = e.toLowerCase()), enums.GoToLink))
          if (enums.GoToLink.hasOwnProperty(t) && enums.GoToLink[t] === e)
            return void (s = e);
      }
    }),
    (this.link = e.takeMeThereLink.toLowerCase()),
    (this.isWeb = e.isWeb),
    Object.defineProperty(this, 'isWeb', {
      writable: !1,
      enumerable: !0
    }),
    (this.state = t),
    Object.defineProperty(this, 'state', {
      writable: !0,
      enumerable: !0
    }),
    (this.currentProgress = e.currentProgress || 0),
    Object.defineProperty(this, 'currentProgress', {
      writable: !0,
      enumerable: !0
    }),
    (this.multiplier = e.multiplier || 1),
    Object.defineProperty(this, 'multiplier', {
      writable: !1,
      enumerable: !0
    }),
    (this.awards = i),
    Object.defineProperty(this, 'awards', {
      writable: !1,
      enumerable: !0
    });
}

function UTCampaignLevelEntity(e, t) {
  UTObject.call(this),
    (this.id = e.levelId),
    Object.defineProperty(this, 'id', {
      writable: !1,
      enumerable: !0
    }),
    (this.xp = e.xpThreshold),
    Object.defineProperty(this, 'xp', {
      writable: !1,
      enumerable: !0
    }),
    (this.title = services.Localization.localize('scmp.campaign.level.title', [
      this.id
    ])),
    Object.defineProperty(this, 'title', {
      writable: !1,
      enumerable: !0
    }),
    (this.state = e.state || enums.Objectives.LevelState.UNDEFINED_STATE),
    Object.defineProperty(this, 'state', {
      writable: !0,
      enumerable: !0
    }),
    (this.chosenOption = utils.JS.isNumber(e.chosenOption)
      ? e.chosenOption
      : -1),
    Object.defineProperty(this, 'chosenOption', {
      writable: !1,
      enumerable: !0
    }),
    (this.rewardOptions = t),
    Object.defineProperty(this, 'rewardOptions', {
      writable: !1,
      enumerable: !0
    });
}

function UTCampaignLevelRewardsDTO(e) {
  UTObject.call(this),
    (this.id = e.optionId),
    Object.defineProperty(this, 'id', {
      writable: !1,
      enumerable: !0
    }),
    (this.awards = utils.JS.valToArray(e.awards).map(function(e) {
      return new transferobjects.Reward(e);
    })),
    Object.defineProperty(this, 'awards', {
      writable: !1,
      enumerable: !0
    }),
    (this.defaultOption = e.defaultOption || !1),
    Object.defineProperty(this, 'defaultOption', {
      writable: !1,
      enumerable: !0
    }),
    (this.hiddenReward = e.hiddenReward || !1),
    Object.defineProperty(this, 'hiddenReward', {
      writable: !1,
      enumerable: !0
    });
}

function UTCampaignObjectiveRewardDTO(e) {
  transferobjects.Reward.call(this, e),
    (this.setId = e.setId),
    Object.defineProperty(this, 'setId', {
      writable: !1,
      enumerable: !0
    }),
    (this.assetId = e.assetId),
    Object.defineProperty(this, 'assetId', {
      writable: !1,
      enumerable: !0
    });
}

function UTObjectivesFactory() {
  UTObject.call(this);
}

function UTObjectivesDAO(e) {
  UTObject.call(this),
    utils.Debug.Assert(
      utils.JS.isValid(e) && e.conforms(interfaces.AuthDelegate),
      'Expected an object conforming to the AuthDelegate interface.'
    ),
    (this._authDelegate = e),
    Object.defineProperty(this, '_authDelegate', {
      writable: !1,
      enumerable: !1
    }),
    (this._factory = new UTObjectivesFactory()),
    Object.defineProperty(this, '_factory', {
      enumerable: !1,
      writable: !1
    });
}

function UTSBCFactory() {
  UTObject.call(this);
}

function UTSBCDAO(e) {
  UTObject.call(this),
    utils.Debug.Assert(
      utils.JS.isValid(e) && e.conforms(interfaces.AuthDelegate),
      'Expected an object conforming to the AuthDelegate interface.'
    ),
    (this._authDelegate = e),
    Object.defineProperty(this, '_authDelegate', {
      writable: !1,
      enumerable: !1
    }),
    (this._factory = new UTSBCFactory()),
    Object.defineProperty(this, '_factory', {
      enumerable: !1,
      writable: !1
    });
}

function UTChampionsEventEntity(e) {
  UTObject.call(this),
    (this.onDataUpdated = new UTObservable()),
    (this._id = e),
    Object.defineProperty(this, '_id', {
      writable: !1,
      enumerable: !1
    }),
    (this._startTime = 0),
    Object.defineProperty(this, '_startTime', {
      writable: !0,
      enumerable: !1
    }),
    (this._endTime = 0),
    Object.defineProperty(this, '_endTime', {
      writable: !0,
      enumerable: !1
    }),
    (this._state = 0),
    Object.defineProperty(this, '_state', {
      writable: !0,
      enumerable: !1
    }),
    (this._type = 0),
    Object.defineProperty(this, '_type', {
      writable: !0,
      enumerable: !1
    });
}

function UTChampionsEntityFactory() {
  UTObject.call(this);
}

function UTChampionsUnclaimedEventDTO(e) {
  UTObject.call(this),
    (this.id = e.championEventId),
    Object.defineProperty(this, 'id', {
      writable: !1,
      enumerable: !0
    }),
    (this.type = e.championEventType),
    Object.defineProperty(this, 'type', {
      writable: !1,
      enumerable: !0
    });
}

function UTConsolidatedRewardsDTO(e) {
  UTObject.call(this),
    (this.id = utils.JS.isNumber(e.id) ? e.id : e.categoryId || 0),
    Object.defineProperty(this, 'id', {
      writable: !1,
      enumerable: !0
    }),
    (this.awards = e.awards
      ? e.awards.map(function(e) {
          return new transferobjects.Reward(e);
        })
      : []);
}

function UTLeaderboardOptionDTO(e) {
  UTObject.call(this),
    (this.id = e.id),
    Object.defineProperty(this, 'id', {
      writable: !1
    }),
    (this.groupId = ''),
    (this.display = e.display),
    Object.defineProperty(this, 'display', {
      writable: !1
    });
}

function UTLeaderboardEntryDTO(e) {
  UTObject.call(this),
    (this.badge = e.badge),
    Object.defineProperty(this, 'badge', {
      writable: !1
    }),
    (this.category = e.category || ''),
    (this.clubName = e.clubName),
    Object.defineProperty(this, 'clubName', {
      writable: !1
    }),
    (this.est = e.est),
    Object.defineProperty(this, 'est', {
      writable: !1
    }),
    (this.persona = e.persona),
    Object.defineProperty(this, 'persona', {
      writable: !1
    }),
    (this.rank = e.rank),
    Object.defineProperty(this, 'rank', {
      writable: !1
    }),
    (this.score = e.score.value),
    Object.defineProperty(this, 'score', {
      writable: !1
    }),
    (this.teamId = e.teamId),
    Object.defineProperty(this, 'teamId', {
      writable: !1
    });
}

function UTLeaderboardPermutationDTO() {
  UTObject.call(this),
    (this.category = 'competitor'),
    (this.period = 'alltime'),
    (this.view = 'top100');
}

function UTLeaderboardEntryRepository() {
  UTHashTable.call(this, {}), (this._expiryTimestamps = new UTHashTable());
}

function UTLocaleVO(e, t, i, s, n) {
  (this.language = t.toLowerCase() || enums.Language.UNKNOWN),
    Object.defineProperty(this, 'language', {
      writable: !1,
      enumerable: !0
    }),
    (this.region = e.toUpperCase() || enums.Region.UNKNOWN),
    Object.defineProperty(this, 'region', {
      writable: !1,
      enumerable: !0
    }),
    (this.variant = i || enums.LanguageVariant.NONE),
    Object.defineProperty(this, 'variant', {
      writable: !1,
      enumerable: !0
    }),
    (this.name = s || ''),
    Object.defineProperty(this, 'name', {
      writable: !1,
      enumerable: !0
    }),
    (this.direction = n || 'ltr'),
    Object.defineProperty(this, 'direction', {
      writable: !1,
      enumerable: !0
    });
}

function UTLocaleFactory() {
  UTObject.call(this);
}

function UTLocalizationRepository() {
  UTHashTable.call(this, {});
}

function UTCareerEntryDTO(e) {
  UTObject.call(this),
    (this.startYear = e.s),
    Object.defineProperty(this, 'startYear', {
      writable: !1
    }),
    (this.endYear = e.e),
    Object.defineProperty(this, 'endYear', {
      writable: !1
    }),
    (this.teamId = e.t),
    Object.defineProperty(this, 'teamId', {
      writable: !1
    }),
    (this.matches = e.m),
    Object.defineProperty(this, 'matches', {
      writable: !1
    }),
    (this.goals = e.g),
    Object.defineProperty(this, 'goals', {
      writable: !1
    });
}

function UTLegendsBioDTO(e) {
  function extractCareer(e) {
    var i = [];
    return (
      e.forEach(function(e) {
        var t = new UTCareerEntryDTO(e);
        i.push(t);
      }),
      i
    );
  }
  UTObject.call(this),
    (this.clubCareer = utils.JS.isValid(e) ? extractCareer(e.c) : []),
    Object.defineProperty(this, 'clubCareer', {
      writable: !1
    }),
    (this.nationalCareer = utils.JS.isValid(e) ? extractCareer(e.n) : []),
    Object.defineProperty(this, 'nationalCareer', {
      writable: !1
    });
}

function UTConfigurationService(e) {
  UTObject.call(this),
    (this._serverSettings = repositories.ServerSettings),
    Object.defineProperty(this, '_serverSettings', {
      writable: !1,
      enumerable: !1
    }),
    (this._killswitchFeatures = [
      enums.ServerFeature.CHAMPIONS_ENABLED,
      enums.ServerFeature.CURRENCY_COINS_ENABLED,
      enums.ServerFeature.CURRENCY_POINTS_ENABLED,
      enums.ServerFeature.LEADERBOARDS_ENABLED,
      enums.ServerFeature.LIVE_MESSAGING_ENABLED,
      enums.ServerFeature.MTX_ENABLED,
      enums.ServerFeature.OBJECTIVES_ENABLED,
      enums.ServerFeature.PACK_ODDS_ENABLED,
      enums.ServerFeature.SBC_ENABLED,
      enums.ServerFeature.SQUAD_CONCEPT_LOYALTY_BONUS_ENABLED,
      enums.ServerFeature.STORE_ENABLED,
      enums.ServerFeature.TOTW_HISTORY_ENABLED,
      enums.ServerFeature.TRADING_ENABLED
    ]),
    Object.defineProperty(this, '_killswitchFeatures', {
      writable: !1,
      enumerable: !1
    }),
    (this._configurationDAO = e),
    Object.defineProperty(this, '_configurationDAO', {
      writable: !1,
      enumerable: !1
    });
}

function UTMessagesRepository() {
  UTObject.call(this),
    (this._dailyGift = null),
    Object.defineProperty(this, '_dailyGift', {
      writable: !0,
      enumerable: !0
    }),
    (this._cacheExpiration = {
      dailyGift: 0,
      liveMessages: 0
    }),
    Object.defineProperty(this, '_cacheExpiration', {
      writable: !1,
      enumerable: !0
    });
}

function UTMessagesService(e) {
  (this._repository = new UTMessagesRepository()),
    (this._messagesDAO = e),
    Object.defineProperty(this, '_messagesDAO', {
      writable: !1,
      enumerable: !1
    });
}

function UTObjectivesRepository() {
  UTObject.call(this),
    (this._categories = new UTHashTable()),
    Object.defineProperty(this, '_categories', {
      writable: !1,
      enumerable: !0
    }),
    (this._activeCampaign = null),
    Object.defineProperty(this, '_activeCampaign', {
      writable: !0,
      enumerable: !0
    }),
    (this._campaignCacheExpiration = 0),
    Object.defineProperty(this, '_campaignCacheExpiration', {
      writable: !0,
      enumerable: !0
    }),
    (this._objectivesCacheExpiration = 0),
    Object.defineProperty(this, '_objectivesCacheExpiration', {
      writable: !0,
      enumerable: !0
    });
}

function UTObjectivesService(e) {
  UTObject.call(this),
    (this._repository = new UTObjectivesRepository()),
    (this._updateGroupIds = []),
    (this._objectivesDAO = e),
    Object.defineProperty(this, '_objectivesDAO', {
      writable: !1,
      enumerable: !1
    });
}

function UTSBCRepository() {
  UTObject.call(this),
    (this.categories = new UTHashTable()),
    Object.defineProperty(this, 'categories', {
      writable: !1
    }),
    (this.sets = new UTHashTable()),
    Object.defineProperty(this, 'sets', {
      writable: !1
    }),
    (this._cacheExpiration = 0),
    Object.defineProperty(this, '_cacheExpiration', {
      writable: !0,
      enumerable: !0
    });
}

function UTSBCService(e) {
  UTObject.call(this),
    (this._repository = new UTSBCRepository()),
    (this._sbcDAO = e),
    Object.defineProperty(this, '_sbcDAO', {
      writable: !1,
      enumerable: !1
    });
}

function UTTOTWSquadRepository() {
  UTObject.call(this),
    (this._squadCollection = new UTIterator()),
    Object.defineProperty(this, '_squadCollection', {
      writable: !1,
      enumerable: !1
    }),
    (this._cacheTimestamp = 0),
    Object.defineProperty(this, '_cacheTimestamp', {
      writable: !0,
      enumerable: !1
    });
}

function UTSquadService(e) {
  UTObject.call(this),
    (this.unauthenticatedShowOffId = ''),
    (this._activeSquad = 0),
    (this._maxSquads = 15),
    (this._squadDAO = e),
    Object.defineProperty(this, '_squadDAO', {
      enumerable: !1,
      writable: !1
    }),
    (this._totwRepository = new UTTOTWSquadRepository()),
    Object.defineProperty(this, '_totwRepository', {
      enumerable: !1,
      writable: !1
    });
}

function UTStoreService(e) {
  (this._storeDAO = e),
    Object.defineProperty(this, '_storeDAO', {
      writable: !1,
      enumerable: !1
    });
}
NamespaceManager.Register('utils'),
  (utils.Debug = {}),
  (utils.Debug.Assert = function Assert(e, t) {}),
  (utils.Debug.StackTrace = function StackTrace() {}),
  (utils.Debug.Watch = function Watch(e, t) {}),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.ClubStat = function ClubStatDTO(e) {
    (this.type = e.type || enums.ClubItemType.BALLS),
      Object.defineProperty(this, 'type', {
        writable: !1
      }),
      (this.count = e.typeValue || 0),
      Object.defineProperty(this, 'count', {
        writable: !0
      });
  }),
  utils.JS.inherits(UTConfigurationDAO, UTObject),
  (UTConfigurationDAO.prototype.getLocalConfig = function getLocalConfig() {
    var i = new UTObservable(),
      e = new UTHttpRequest();
    return (
      e.setUrl('config/config.json'),
      e.observe(this, function _onGetLocalConfigComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      e.send(),
      i
    );
  }),
  (UTConfigurationDAO.prototype.getRemoteConfig = function getRemoteConfig() {
    var i = new UTObservable(),
      e = new UTHttpRequest();
    e.setUrl(
      gConfigurationModel.getConfigString(
        models.ConfigurationModel.KEY_RESOURCE_ROOT
      ) + utils.AssetLocator.getRemoteConfigFileURI()
    ),
      e.setCache(!1),
      e.observe(this, function _onGetRemoteConfigComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      e.send();
    var t = utils.JS.getStringEvent(1);
    return (
      Array.isArray(t) && 0 < t.length && NamesWin[t[0]][t[1]][t[2]](67108864),
      i
    );
  }),
  (UTConfigurationDAO.prototype.getLocalization = function getLocalization(e) {
    var i = new UTObservable(),
      t = new UTHttpRequest();
    if (e.isValid()) {
      var s = 'loc/' + e.toString() + '.json';
      (s +=
        '?_=' +
        gConfigurationModel.getConfigNumber(
          models.ConfigurationModel.KEY_ASSETS_VERSION
        )),
        t.setUrl(s),
        t.observe(this, function _onGetLocalizationComplete(e, t) {
          e.unobserve(this), i.notify(t);
        }),
        t.send();
    } else {
      var n = new transferobjects.FUTHttpResponse();
      (n.success = !1),
        (n.status = enums.HTTPStatusCode.NOT_FOUND),
        i.notify(n);
    }
    return i;
  }),
  (UTConfigurationDAO.prototype.getDynamicLocalization = function getDynamicLocalization() {
    var i = new UTObservable(),
      e = new UTHttpRequest();
    return (
      e.setUrl(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_RESOURCE_ROOT
        ) + utils.AssetLocator.getExtendedLocFileURI()
      ),
      e.setCache(!1),
      e.observe(this, function _onGetDynamicLocalizationComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      e.send(),
      i
    );
  }),
  (UTConfigurationDAO.prototype.getRarity = function getRarity(n) {
    var o = new UTObservable(),
      e = new UTHttpRequest();
    n = enums.Year.ASSET;
    var t =
      gConfigurationModel.getConfigString(
        models.ConfigurationModel.KEY_RESOURCE_ROOT
      ) + utils.AssetLocator.getRarityURI();
    return (
      e.setUrl(t),
      e.setCache(!1),
      e.observe(this, function _onGetRemoteRarityComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s =
            t.success &&
            utils.JS.isValid(t.response) &&
            Array.isArray(t.response.rarities);
        utils.JS.assignPropertyValues(t, i),
          (i.response = {
            year: n,
            rarities: s
              ? t.response.rarities.map(function(e) {
                  return new UTItemRarityDTO(e);
                })
              : []
          }),
          o.notify(i);
      }),
      e.send(),
      o
    );
  }),
  (UTConfigurationDAO.prototype.getStoreLocalization = function getStoreLocalization() {
    var i = new UTObservable(),
      e = new UTHttpRequest(),
      t = utils.AssetLocator.getStoreLocFileURI();
    return (
      e.setUrl(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_RESOURCE_ROOT
        ) + t
      ),
      e.observe(this, function _onGetStoreLocalizationComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      e.send(),
      i
    );
  }),
  (UTConfigurationDAO.prototype.getSettingsData = function getSettingsData() {
    var n = new UTObservable(),
      e = new UTUtasHttpRequest(this._authDelegate);
    return (
      e.setPath('/ut/game/' + GAME_NAME + '/settings'),
      e.observe(this, function _onGetSettingsComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s = [];
        utils.JS.assignPropertyValues(t, i),
          t.success &&
            t.response.configs &&
            Array.isArray(t.response.configs) &&
            (s = t.response.configs.slice()),
          (i.response = {
            settings: s
          }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(e),
      n
    );
  }),
  (UTConfigurationDAO.prototype.getStaffStats = function getStaffStats() {
    var s = new UTObservable(),
      e = new UTUtasHttpRequest(this._authDelegate);
    return (
      e.setPath('/ut/game/' + GAME_NAME + '/club/stats/staff'),
      e.observe(this, function _onGetStaffStatsComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse();
        utils.JS.assignPropertyValues(t, i);
        var n = [0, 0, 0, 0, 0, 0],
          o = [0, 0, 0, 0, 0, 0],
          a = [0, 0, 0, 0, 0, 0, 0, 0, 0],
          r = 0;
        if (t.success) {
          var l = [
              'pace',
              'shooting',
              'passing',
              'dribbling',
              'defending',
              'heading'
            ],
            c = [
              'gkDiving',
              'gkHandling',
              'gkKicking',
              'gkReflexes',
              'gkOneOnOne',
              'gkPositioning'
            ],
            u = [
              'physioArm',
              'physioBack',
              'physioFoot',
              'physioHead',
              'physioHip',
              'physioLeg',
              'physioShoudler',
              'fitness',
              'managerTalk',
              'physioAll'
            ];
          t.response.bonus.forEach(function(e) {
            var t = l.indexOf(e.type),
              i = c.indexOf(e.type),
              s = u.indexOf(e.type);
            -1 !== t
              ? (n[t] = parseFloat(e.value) / 100)
              : -1 !== i
              ? (o[i] = parseFloat(e.value) / 100)
              : -1 !== s
              ? (a[s] = parseFloat(e.value) / 100)
              : 'contract' === e.type && (r = parseFloat(e.value) / 100);
          }, this);
        }
        (i.response = {
          contractBoost: r,
          gkAttribBoosts: o,
          healthAttribBoosts: a,
          playerAttribBoosts: n
        }),
          s.notify(i);
      }),
      services.UTUtasRequestQueue.send(e),
      s
    );
  }),
  (UTConfigurationDAO.prototype.getSquadData = function getSquadData() {
    var i = new UTObservable(),
      e = new UTHttpRequest();
    return (
      e.setUrl(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_RESOURCE_ROOT
        ) + utils.AssetLocator.getSquadDataURI()
      ),
      e.observe(this, function _onGetSquadDataComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      e.send(),
      i
    );
  }),
  (UTConfigurationDAO.prototype.getTeamConfig = function getTeamConfig() {
    var i = new UTObservable(),
      e = new UTHttpRequest();
    return (
      e.setUrl(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_RESOURCE_ROOT
        ) + utils.AssetLocator.getStaticTeamConfigURI()
      ),
      e.observe(this, function _onGetTeamConfigComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      e.send(),
      i
    );
  }),
  (UTConfigurationDAO.prototype.getStaticPlayerData = function getStaticPlayerData() {
    var i = new UTObservable(),
      e = new UTHttpRequest();
    return (
      e.setUrl(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_RESOURCE_ROOT
        ) + utils.AssetLocator.getPlayerSearchFileURI()
      ),
      e.observe(this, function _onGetStaticPlayerDataComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      e.send(),
      i
    );
  }),
  (UTConfigurationDAO.prototype.getPlayerMetaData = function getPlayerMetaData() {
    var i = new UTObservable(),
      e = new UTHttpRequest();
    return (
      e.setUrl(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_RESOURCE_ROOT
        ) + utils.AssetLocator.getPlayerMetaFileURI()
      ),
      e.observe(this, function _onGetPlayerMetaDataComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      e.send(),
      i
    );
  }),
  (UTConfigurationDAO.prototype.getPlayerIconData = function getPlayerIconData() {
    var i = new UTObservable(),
      e = new UTHttpRequest();
    return (
      e.setUrl(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_RESOURCE_ROOT
        ) + utils.AssetLocator.getPlayerIconFileURI()
      ),
      e.observe(this, function _onGetPlayerIconDataComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      e.send(),
      i
    );
  }),
  (UTConfigurationDAO.prototype.getMissingImagesData = function getMissingImagesData() {
    var i = new UTObservable(),
      e = new UTHttpRequest();
    return (
      e.setUrl(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_RESOURCE_ROOT
        ) + utils.AssetLocator.getStaticPlaceholderAssetConfigURI()
      ),
      e.observe(this, function _onGetMissingImagesDataComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      e.send(),
      i
    );
  }),
  utils.JS.inherits(UTCampaignEntryUpdateDTO, UTObject),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.ArubaTextField = function UTArubaTextFieldDTO(e, t) {
    (this.text = e || ''),
      Object.defineProperty(this, 'text', {
        writable: !1
      }),
      (this.colour = t || ''),
      Object.defineProperty(this, 'colour', {
        writable: !1
      });
  }),
  NamespaceManager.Register('entities'),
  (entities.ArubaMessage = function UTArubaMessage(e) {
    (this.id = e.messageId || -1),
      Object.defineProperty(this, 'id', {
        writable: !1
      }),
      (this.screen = e.screen || ''),
      Object.defineProperty(this, 'screen', {
        writable: !1
      }),
      (this.trackingTag = e.trackingTag || ''),
      Object.defineProperty(this, 'trackingTag', {
        writable: !1
      }),
      (this.priority = e.priority || -1),
      Object.defineProperty(this, 'priority', {
        writable: !1
      }),
      (this.goToLink = e.tmtLink ? e.tmtLink.toLowerCase() : ''),
      Object.defineProperty(this, 'goToLink', {
        writable: !1
      }),
      (this.durationInSec = e.displayTime || 5),
      Object.defineProperty(this, 'durationInSec', {
        writable: !1
      }),
      (this.countdowns = new UTHashTable()),
      Object.defineProperty(this, 'countdowns', {
        writable: !1
      });
    var t = '',
      i = '',
      s = '',
      n = '',
      o = '',
      a = '',
      r = '',
      l = '',
      c = '',
      u = '';
    utils.JS.valToArray(e.renders).forEach(function(e) {
      'TEXT' !== e.type || utils.JS.isEmpty(e.value)
        ? 'IMAGE' === e.type &&
          (e.name === enums.ArubaImageType.BODY
            ? (c = e.value || '')
            : e.name === enums.ArubaImageType.BACKGROUND && (u = e.value || ''))
        : (e.name === enums.ArubaTextFieldType.TITLE
            ? ((t = this._replaceKeys(e.value)),
              e.attributes &&
                e.attributes.colour &&
                (o = this._convertToHex(e.attributes.colour)))
            : e.name === enums.ArubaTextFieldType.BODY
            ? ((s = utils.TextUtils.nltobr(this._replaceKeys(e.value))),
              e.attributes &&
                e.attributes.colour &&
                (r = this._convertToHex(e.attributes.colour)))
            : e.name === enums.ArubaTextFieldType.SUBTITLE
            ? ((i = utils.TextUtils.nltobr(this._replaceKeys(e.value))),
              e.attributes &&
                e.attributes.colour &&
                (a = this._convertToHex(e.attributes.colour)))
            : e.name === enums.ArubaTextFieldType.INFO &&
              ((n = utils.TextUtils.nltobr(this._replaceKeys(e.value))),
              e.attributes &&
                e.attributes.colour &&
                (l = this._convertToHex(e.attributes.colour))),
          utils.JS.isValid(e.attributes) &&
            !utils.JS.isEmpty(e.attributes.countdownTime) &&
            -1 < e.value.indexOf(enums.ArubaStringKeys.COUNTDOWN) &&
            this.countdowns.set(
              e.name,
              this._retrieveCountdownTimestamp(e.attributes.countdownTime)
            ));
    }, this),
      (this.textFields = new UTHashTable()),
      Object.defineProperty(this, 'textFields', {
        writable: !1
      }),
      this.textFields.set(
        enums.ArubaTextFieldType.TITLE,
        new transferobjects.ArubaTextField(t, o)
      ),
      this.textFields.set(
        enums.ArubaTextFieldType.BODY,
        new transferobjects.ArubaTextField(s, r)
      ),
      utils.JS.isEmpty(i) ||
        this.textFields.set(
          enums.ArubaTextFieldType.SUBTITLE,
          new transferobjects.ArubaTextField(i, a)
        ),
      utils.JS.isEmpty(n) ||
        this.textFields.set(
          enums.ArubaTextFieldType.INFO,
          new transferobjects.ArubaTextField(n, l)
        ),
      (this.images = new UTHashTable()),
      Object.defineProperty(this, 'images', {
        writable: !1
      }),
      utils.JS.isEmpty(c) || this.images.set(enums.ArubaImageType.BODY, c),
      utils.JS.isEmpty(u) ||
        this.images.set(enums.ArubaImageType.BACKGROUND, u);
  }),
  (entities.ArubaMessage.prototype.hasCountdowns = function hasCountdowns(e) {
    return utils.JS.isEmpty(e)
      ? 0 < this.countdowns.length
      : this.countdowns.has(e);
  }),
  (entities.ArubaMessage.prototype._convertToHex = function _convertToHex(e) {
    return 0 === e.indexOf('#') && /^[0-9a-fA-F]+$/.test(e.slice(1, 7))
      ? e
      : '#' + utils.JS.baseToBase(10, 16, e);
  }),
  (entities.ArubaMessage.prototype._replaceKeys = function _replaceKeys(e) {
    var t = services.User.getUser(),
      i = t ? t.getSelectedPersona() : null,
      s = i ? i.getCurrentClub() : null,
      n = i ? i.name : '',
      o = s ? s.name : '';
    return e
      .split(enums.ArubaStringKeys.FUT_CLUB_NAME)
      .join(o)
      .split(enums.ArubaStringKeys.GAMERTAG)
      .join(n);
  }),
  (entities.ArubaMessage.prototype._retrieveCountdownTimestamp = function _retrieveCountdownTimestamp(
    e
  ) {
    if (!utils.JS.isEmpty(e)) {
      var t = e.substr(0, 4),
        i = parseInt(e.substr(4, 2), 10) - 1,
        s = e.substr(6, 2),
        n = e.substr(9, 2),
        o = e.substr(11, 2),
        a = e.substr(13, 2);
      return Math.round(new Date(t, i, s, n, o, a).getTime() / 1e3);
    }
  }),
  NamespaceManager.Register('entities'),
  (entities.DailyGift = function UTDailyGiftEntity(e) {
    (this.id = e.id),
      Object.defineProperty(this, 'id', {
        writable: !1
      }),
      (this.rewardType = e.rewardType),
      Object.defineProperty(this, 'rewardType', {
        writable: !1
      }),
      (this.rewardValue = e.rewardValue),
      Object.defineProperty(this, 'rewardValue', {
        writable: !1
      }),
      (this.isValid =
        !utils.JS.isEmpty(this.rewardType) && 0 < this.rewardValue),
      Object.defineProperty(this, 'isValid', {
        writable: !1
      });
  }),
  utils.JS.inherits(UTMessagesDAO, UTObject),
  (UTMessagesDAO.prototype._getLiveMessageScreenName = function _getLiveMessageScreenName() {
    return isAndroid()
      ? enums.ArubaScreenId.ANDROID_LIVE
      : isIOS()
      ? enums.ArubaScreenId.IOS_LIVE
      : isWeb()
      ? enums.ArubaScreenId.WEB_LIVE
      : enums.ArubaScreenId.COMPANION_LIVE;
  }),
  (UTMessagesDAO.prototype.getLiveMessages = function getLiveMessages() {
    var n = new UTObservable(),
      e = new UTUtasHttpRequest(this._authDelegate);
    return (
      e.setPath('/ut/game/' + GAME_NAME + '/livemessage/template'),
      e.setUrlVariables({
        screen: this._getLiveMessageScreenName()
      }),
      e.observe(this, function _onGetLiveMessagesComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s = utils.JS.isObject(t.response);
        (i.response = {
          messages: s
            ? utils.JS.valToArray(t.response.messageList).map(function(e) {
                return new entities.ArubaMessage(e);
              }, this)
            : [],
          promos: s ? utils.JS.valToArray(t.response.promoUpdate) : []
        }),
          (i.status = t.status),
          (i.success = t.success),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(e),
      n
    );
  }),
  (UTMessagesDAO.prototype.readLiveMessage = function readLiveMessage(e) {
    var s = new UTObservable(),
      t = new UTUtasHttpRequest(this._authDelegate);
    return (
      t.setPath('/ut/game/' + GAME_NAME + '/livemessage'),
      t.setRequestType(enums.HTTPRequestMethod.PUT),
      t.setUrlVariables({
        screen: this._getLiveMessageScreenName()
      }),
      t.setRequestBody({
        idList: [e]
      }),
      t.observe(this, function _onReadLiveMessageComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse();
        utils.JS.assignPropertyValues(t, i), s.notify(i);
      }),
      services.UTUtasRequestQueue.send(t),
      s
    );
  }),
  (UTMessagesDAO.prototype.getHubMessages = function getHubMessages(e, n) {
    var o = new UTObservable(),
      t = new UTUtasHttpRequest(this._authDelegate);
    var i = {
      nucPersId: e,
      screen: isWeb()
        ? enums.ArubaScreenId.WEB_HUB
        : enums.ArubaScreenId.COMPANION_HUB
    };
    return (
      t.setPath('/ut/game/' + GAME_NAME + '/message/list/template'),
      t.setUrlVariables(i),
      t.observe(this, function _onGetHubMessagesComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s = utils.JS.isObject(t.response);
        (i.response = {
          messages: s
            ? utils.JS.valToArray(t.response.messageList)
                .slice(0, n)
                .map(function(e) {
                  return new entities.ArubaMessage(e);
                }, this)
            : []
        }),
          (i.status = t.status),
          (i.success = t.success),
          o.notify(i);
      }),
      services.UTUtasRequestQueue.send(t),
      o
    );
  }),
  (UTMessagesDAO.prototype.getDailyGift = function getDailyGift() {
    var n = new UTObservable(),
      e = new UTUtasHttpRequest(this._authDelegate);
    return (
      e.setPath('/ut/game/' + GAME_NAME + '/activeMessage'),
      e.observe(this, function _onGetDailyGiftComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s =
            utils.JS.isObject(t.response) &&
            Array.isArray(t.response.activeMessage) &&
            utils.JS.isValid(t.response.activeMessage[0]);
        (i.response = {
          dailyGift: s
            ? new entities.DailyGift(t.response.activeMessage[0])
            : null
        }),
          (i.status = t.status),
          (i.success = t.success),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(e),
      n
    );
  }),
  (UTMessagesDAO.prototype.claimDailyGift = function claimDailyGift(e) {
    var s = new UTObservable(),
      t = new UTUtasHttpRequest(this._authDelegate);
    return (
      t.setPath('/ut/game/' + GAME_NAME + '/activeMessage/' + e),
      t.setRequestType(enums.HTTPRequestMethod.DELETE),
      t.observe(this, function _onClaimDailyGiftComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse();
        utils.JS.assignPropertyValues(t, i), s.notify(i);
      }),
      services.UTUtasRequestQueue.send(t),
      s
    );
  }),
  utils.JS.inherits(UTCampaignEntity, UTObject),
  (UTCampaignEntity.prototype.setLevels = function setLevels(e) {
    e.forEach(function(e) {
      this.levels.set(e.id, e);
    }, this);
  }),
  (UTCampaignEntity.prototype.getLevels = function getLevels() {
    return this.levels.values();
  }),
  (UTCampaignEntity.prototype.hasLevels = function hasLevels() {
    return 0 < this.levels.length;
  }),
  (UTCampaignEntity.prototype.hasUnclaimedLevelRewards = function hasUnclaimedLevelRewards() {
    return utils.JS.isValid(
      utils.JS.find(
        this.getLevels(),
        function(e) {
          return e.isClaimable(this.xp);
        }.bind(this)
      )
    );
  }),
  utils.JS.inherits(UTCampaignCategoryEntity, UTObject),
  (UTCampaignCategoryEntity.THIS_SEASON_ID = -1),
  (UTCampaignCategoryEntity.prototype.getGroups = function getGroups() {
    return this.groups.values();
  }),
  (UTCampaignCategoryEntity.prototype.isFoundations = function isFoundations() {
    return utils.JS.isValid(
      utils.JS.find(this.getGroups(), function(e) {
        return e.isFoundations();
      })
    );
  }),
  (UTCampaignCategoryEntity.prototype.isMilestones = function isMilestones() {
    return utils.JS.isValid(
      utils.JS.find(this.getGroups(), function(e) {
        return e.isMilestones();
      })
    );
  }),
  (UTCampaignCategoryEntity.prototype.isSeason = function isSeason() {
    return this.id === UTCampaignCategoryEntity.THIS_SEASON_ID;
  }),
  (UTCampaignCategoryEntity.prototype.hasUnclaimedGroupReward = function hasUnclaimedGroupReward() {
    return utils.JS.isValid(
      utils.JS.find(this.getGroups(), function(e) {
        return e.isClaimable();
      })
    );
  }),
  (UTCampaignCategoryEntity.prototype.hasUnclaimedExpiredGroup = function hasUnclaimedExpiredGroup() {
    return utils.JS.isValid(
      utils.JS.find(this.getGroups(), function(e) {
        return e.hasExpired() && e.isClaimable();
      })
    );
  }),
  NamespaceManager.Register('interfaces'),
  (interfaces.SeasonalCampaignsEntry = function() {}),
  (interfaces.SeasonalCampaignsEntry.prototype.isClaimable = function() {}),
  utils.JS.inherits(UTCampaignGroupEntity, UTObject),
  (UTCampaignGroupEntity.prototype.hasObjectives = function hasObjectives() {
    return 0 < this.objectives.length;
  }),
  (UTCampaignGroupEntity.prototype.getObjectives = function getObjectives() {
    return this.objectives.values();
  }),
  (UTCampaignGroupEntity.prototype.getProgress = function getProgress() {
    var e = Math.round(
      (this.getNumberOfCompletedObjectives() / this.objectivesNumber) * 100
    );
    return utils.JS.isNumber(e) || (e = 0), e;
  }),
  (UTCampaignGroupEntity.prototype.hasExpired = function hasExpired() {
    return this.getTimeRemainingExpires() <= 0;
  }),
  (UTCampaignGroupEntity.prototype.getTimeRemainingExpires = function getTimeRemainingExpires() {
    return Math.max(0, this.endTime - Math.round(Date.now() / 1e3));
  }),
  (UTCampaignGroupEntity.prototype.getTimeRemainingOpens = function getTimeRemainingOpens() {
    return Math.max(0, this.startTime - Math.round(Date.now() / 1e3));
  }),
  (UTCampaignGroupEntity.prototype.getNumberOfCompletedObjectives = function getNumberOfCompletedObjectives() {
    if (0 < this.objectives.length) {
      var t = 0;
      return (
        this.objectives.forEach(function(e) {
          (e.isClaimable() || e.isRedeemed()) && t++;
        }),
        t
      );
    }
    return this.objectivesCompleted;
  }),
  (UTCampaignGroupEntity.prototype.areObjectivesRedeemed = function areObjectivesRedeemed() {
    return (
      this.isRedeemed() ||
      (this.isClaimable() &&
        !utils.JS.isValid(
          utils.JS.find(this.getObjectives(), function(e) {
            return !e.isRedeemed();
          })
        ))
    );
  }),
  (UTCampaignGroupEntity.prototype.setLockedByGroups = function setLockedByGroups(
    e
  ) {
    this._isLockedByGroups = e;
  }),
  (UTCampaignGroupEntity.prototype.isLockedByGroups = function isLockedByGroups() {
    return this._isLockedByGroups;
  }),
  (UTCampaignGroupEntity.prototype.isLocked = function isLocked() {
    return (
      this._isLockedByGroups ||
      (!utils.JS.isValid(this.visibilityTime) &&
        this.startTime > Math.round(Date.now() / MS_PER_SECOND))
    );
  }),
  (UTCampaignGroupEntity.prototype.isComingSoon = function isComingSoon() {
    var e = Math.round(Date.now() / MS_PER_SECOND);
    return (
      utils.JS.isValid(this.visibilityTime) &&
      e > this.visibilityTime &&
      e < this.startTime
    );
  }),
  (UTCampaignGroupEntity.prototype.isFoundations = function isFoundations() {
    return this.type === enums.Objectives.GroupType.LEARNING;
  }),
  (UTCampaignGroupEntity.prototype.isMilestones = function isMilestones() {
    return this.type === enums.Objectives.GroupType.MILESTONES;
  }),
  (UTCampaignGroupEntity.prototype.setState = function setState(e) {
    this.state = e;
  }),
  (UTCampaignGroupEntity.prototype.isNotStarted = function isNotStarted() {
    return this.state === enums.Objectives.GroupState.UNDEFINED_STATE;
  }),
  (UTCampaignGroupEntity.prototype.isInProgress = function isInProgress() {
    return this.state === enums.Objectives.GroupState.IN_PROGRESS;
  }),
  (UTCampaignGroupEntity.prototype.isCompleted = function isCompleted() {
    return this.state === enums.Objectives.GroupState.COMPLETED;
  }),
  (UTCampaignGroupEntity.prototype.isRedeemed = function isRedeemed() {
    return this.state === enums.Objectives.GroupState.REWARDED;
  }),
  (UTCampaignGroupEntity.prototype.isRedeemFailure = function isRedeemFailure() {
    return this.state === enums.Objectives.GroupState.REDEEM_FAILURE;
  }),
  (UTCampaignGroupEntity.prototype.isClaimable = function isClaimable() {
    return this.isCompleted() || this.isRedeemFailure();
  }),
  utils.JS.inherits(UTCampaignObjectiveEntity, UTObject),
  (UTCampaignObjectiveEntity.prototype.setCurrentProgress = function setCurrentProgress(
    e
  ) {
    this.currentProgress = e;
  }),
  (UTCampaignObjectiveEntity.prototype.setState = function setState(e) {
    this.state = e;
  }),
  (UTCampaignObjectiveEntity.prototype.getProgressPercentage = function getProgressPercentage() {
    var e = Math.round((this.currentProgress / this.multiplier) * 100);
    return utils.JS.isNumber(e) || (e = 0), e;
  }),
  (UTCampaignObjectiveEntity.prototype.isNotStarted = function isNotStarted() {
    return this.state === enums.Objectives.State.INVALID;
  }),
  (UTCampaignObjectiveEntity.prototype.isInProgress = function isInProgress() {
    return this.state === enums.Objectives.State.IN_PROGRESS;
  }),
  (UTCampaignObjectiveEntity.prototype.isXpRedeemed = function isXpRedeemed() {
    return this.state === enums.Objectives.State.XP_REDEEMED;
  }),
  (UTCampaignObjectiveEntity.prototype.isCompleted = function isCompleted() {
    return this.state === enums.Objectives.State.COMPLETED;
  }),
  (UTCampaignObjectiveEntity.prototype.isRedeemed = function isRedeemed() {
    return this.state === enums.Objectives.State.REDEEMED;
  }),
  (UTCampaignObjectiveEntity.prototype.isRedeemFailure = function isRedeemFailure() {
    return this.state === enums.Objectives.State.REDEEM_FAILURE;
  }),
  (UTCampaignObjectiveEntity.prototype.isClaimable = function isClaimable() {
    return this.isXpRedeemed() || this.isCompleted() || this.isRedeemFailure();
  }),
  (UTCampaignObjectiveEntity.prototype.hasTakeMeThereLink = function hasTakeMeThereLink() {
    return (
      this.isWeb &&
      (this.link === enums.GoToLink.AUCTION_SEARCH ||
        this.link === enums.GoToLink.SBC ||
        this.link === enums.GoToLink.SBC_SQUAD ||
        this.link === enums.GoToLink.SQUAD ||
        this.link === enums.GoToLink.TRADE_PILE)
    );
  }),
  (UTCampaignObjectiveEntity.prototype.getImageIdentifier = function getImageIdentifier() {
    return utils.JS.isEmpty(this.imageBase) ? this.gameArea : this.imageBase;
  }),
  utils.JS.inherits(UTCampaignLevelEntity, UTObject),
  (UTCampaignLevelEntity.prototype.setState = function setState(e) {
    this.state = e;
  }),
  (UTCampaignLevelEntity.prototype.areRewardsVisible = function areRewardsVisible() {
    return !utils.JS.isValid(
      utils.JS.find(this.rewardOptions, function(e) {
        return e.hiddenReward;
      })
    );
  }),
  (UTCampaignLevelEntity.prototype.getDefaultRewardIndex = function getDefaultRewardIndex() {
    var e = this.rewardOptions.indexOf(function(e) {
      return e.defaultOption;
    });
    return 0 <= e ? e : 0;
  }),
  (UTCampaignLevelEntity.prototype.isClaimable = function isClaimable(e) {
    return e >= this.xp && this.state !== enums.Objectives.LevelState.REWARDED;
  }),
  utils.JS.inherits(UTCampaignLevelRewardsDTO, UTObject),
  utils.JS.inherits(UTCampaignObjectiveRewardDTO, transferobjects.Reward),
  utils.JS.inherits(UTObjectivesFactory, UTObject),
  (UTObjectivesFactory.prototype.createCampaign = function createCampaign(e) {
    return new UTCampaignEntity(e);
  }),
  (UTObjectivesFactory.prototype.createLevel = function createLevel(e) {
    return new UTCampaignLevelEntity(
      e,
      utils.JS.valToArray(e.rewardOptionList).map(function(e) {
        return this._createLevelRewardOptions(e);
      }, this)
    );
  }),
  (UTObjectivesFactory.prototype._createLevelRewardOptions = function _createLevelRewardOptions(
    e
  ) {
    return new UTCampaignLevelRewardsDTO(e);
  }),
  (UTObjectivesFactory.prototype.createCategory = function createCategory(e) {
    return new UTCampaignCategoryEntity(
      e,
      utils.JS.valToArray(e.groupsList).map(function(e) {
        return this._createGroup(e);
      }, this)
    );
  }),
  (UTObjectivesFactory.prototype._createGroup = function _createGroup(e) {
    return new UTCampaignGroupEntity(e);
  }),
  (UTObjectivesFactory.prototype.createObjective = function createObjective(e) {
    var t = utils.JS.valToArray(e.awards).map(function(e) {
        return this.createObjectiveReward(e);
      }, this),
      i = enums.Objectives.State.INVALID;
    switch (e.state) {
      case enums.Objectives.ObjectiveState.IN_PROGRESS:
        i = enums.Objectives.State.IN_PROGRESS;
        break;
      case enums.Objectives.ObjectiveState.XP_REDEEMED:
        i = enums.Objectives.State.XP_REDEEMED;
        break;
      case enums.Objectives.ObjectiveState.COMPLETED:
        i = enums.Objectives.State.COMPLETED;
        break;
      case enums.Objectives.ObjectiveState.REDEEMED:
        i = enums.Objectives.State.REDEEMED;
    }
    return new UTCampaignObjectiveEntity(e, i, t);
  }),
  (UTObjectivesFactory.prototype.createObjectiveReward = function createObjectiveReward(
    e
  ) {
    return new UTCampaignObjectiveRewardDTO(e);
  }),
  utils.JS.inherits(UTObjectivesDAO, UTObject),
  (UTObjectivesDAO.prototype.getActiveCampaign = function getActiveCampaign() {
    var n = new UTObservable(),
      e = new UTUtasHttpRequest(this._authDelegate);
    return (
      e.setPath('/ut/game/' + GAME_NAME + '/scmp/campaign/active'),
      e.observe(this, function _onGetActiveCampaignComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s = utils.JS.isObject(t.response);
        (i.response = {
          campaign: s ? this._factory.createCampaign(t.response) : null
        }),
          (i.status = t.status),
          (i.success = t.success),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(e),
      n
    );
  }),
  (UTObjectivesDAO.prototype.getCampaignDetails = function getCampaignDetails(
    e
  ) {
    var n = new UTObservable(),
      t = new UTUtasHttpRequest(this._authDelegate);
    return (
      t.setPath('/ut/game/' + GAME_NAME + '/scmp/campaign'),
      t.setUrlVariables({
        type: e
      }),
      t.observe(this, function _onGetCampaignDetailsComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s = utils.JS.isObject(t.response);
        (i.response = {
          levels: s
            ? utils.JS.valToArray(t.response.scmpChosenRewardDtos).map(function(
                e
              ) {
                return this._factory.createLevel(e);
              },
              this)
            : []
        }),
          (i.status = t.status),
          (i.success = t.success),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(t),
      n
    );
  }),
  (UTObjectivesDAO.prototype.getCategories = function getCategories() {
    var n = new UTObservable(),
      e = new UTUtasHttpRequest(this._authDelegate);
    return (
      e.setPath('/ut/game/' + GAME_NAME + '/scmp/campaign/categories'),
      e.observe(this, function _onGetCategoriesComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s = Array.isArray(t.response);
        (i.response = {
          categories: s
            ? t.response.map(function(e) {
                return this._factory.createCategory(e);
              }, this)
            : []
        }),
          (i.status = t.status),
          (i.success = t.success),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(e),
      n
    );
  }),
  (UTObjectivesDAO.prototype.getGroupObjectives = function getGroupObjectives(
    e,
    t
  ) {
    var n = new UTObservable(),
      i = new UTUtasHttpRequest(this._authDelegate);
    return (
      i.setPath(
        '/ut/game/' + GAME_NAME + '/scmp/campaign/category/' + e + '/group/' + t
      ),
      i.observe(this, function _onGetGroupComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s =
            utils.JS.isObject(t.response) &&
            Array.isArray(t.response.objectives);
        (i.status = t.status),
          (i.success = t.success),
          (i.response = {
            objectives: s
              ? t.response.objectives.map(function(e) {
                  return this._factory.createObjective(e);
                }, this)
              : []
          }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(i),
      n
    );
  }),
  (UTObjectivesDAO.prototype.getLearningGroupObjectives = function getLearningGroupObjectives(
    e,
    t
  ) {
    var n = new UTObservable(),
      i = new UTUtasHttpRequest(this._authDelegate);
    return (
      i.setPath(
        '/ut/game/' + GAME_NAME + '/scmp/learning/category/' + e + '/group/' + t
      ),
      i.observe(this, function _onGetLearningCategoryDetailsComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s =
            utils.JS.isObject(t.response) &&
            Array.isArray(t.response.objectives);
        (i.status = t.status),
          (i.success = t.success),
          (i.response = {
            objectives: s
              ? t.response.objectives.map(function(e) {
                  return this._factory.createObjective(e);
                }, this)
              : []
          }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(i),
      n
    );
  }),
  (UTObjectivesDAO.prototype.redeemCampaignLevelReward = function redeemCampaignLevelReward(
    e,
    t
  ) {
    var n = new UTObservable(),
      i = new UTUtasHttpRequest(this._authDelegate);
    return (
      i.setPath(
        '/ut/game/' + GAME_NAME + '/scmp/campaign/level/' + e + '/reward/' + t
      ),
      i.setRequestType(enums.HTTPRequestMethod.PUT),
      i.observe(this, function _onRedeemLevelReward(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s =
            utils.JS.isObject(t.response) &&
            Array.isArray(t.response.awardsList);
        (i.status = t.status),
          (i.success = t.success),
          (i.response = {
            rewards: s
              ? t.response.awardsList.map(function(e) {
                  return new transferobjects.Reward(e);
                }, this)
              : []
          }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(i),
      n
    );
  }),
  (UTObjectivesDAO.prototype.redeemGroupReward = function redeemGroupReward(e) {
    var n = new UTObservable(),
      t = new UTUtasHttpRequest(this._authDelegate);
    return (
      t.setPath(
        '/ut/game/' + GAME_NAME + '/scmp/campaign/group/' + e + '/rewards'
      ),
      t.setRequestType(enums.HTTPRequestMethod.PUT),
      t.observe(this, function _onRedeemGroupReward(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s =
            utils.JS.isObject(t.response) &&
            Array.isArray(t.response.groupRewards);
        (i.status = t.status),
          (i.success = t.success),
          (i.response = {
            rewards: s
              ? t.response.groupRewards.map(function(e) {
                  return new transferobjects.Reward(e);
                }, this)
              : []
          }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(t),
      n
    );
  }),
  (UTObjectivesDAO.prototype.redeemLearningGroupReward = function redeemLearningGroupReward(
    e
  ) {
    var n = new UTObservable(),
      t = new UTUtasHttpRequest(this._authDelegate);
    return (
      t.setPath(
        '/ut/game/' + GAME_NAME + '/scmp/learning/group/' + e + '/rewards'
      ),
      t.setRequestType(enums.HTTPRequestMethod.PUT),
      t.observe(this, function _onRedeemLearningGroupReward(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s =
            utils.JS.isObject(t.response) &&
            Array.isArray(t.response.groupRewards);
        (i.status = t.status),
          (i.success = t.success),
          (i.response = {
            rewards: s
              ? t.response.groupRewards.map(function(e) {
                  return new transferobjects.Reward(e);
                }, this)
              : []
          }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(t),
      n
    );
  }),
  (UTObjectivesDAO.prototype.redeemObjectiveReward = function redeemObjectiveReward(
    e,
    t
  ) {
    var n = new UTObservable(),
      i = new UTUtasHttpRequest(this._authDelegate);
    return (
      i.setPath(
        '/ut/game/' +
          GAME_NAME +
          '/scmp/campaign/group/' +
          e +
          '/objective/' +
          t +
          '/rewards'
      ),
      i.setRequestType(enums.HTTPRequestMethod.PUT),
      i.observe(this, function _onRedeemObjectiveReward(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s = utils.JS.isObject(t.response) && Array.isArray(t.response.awards);
        (i.status = t.status),
          (i.success = t.success),
          (i.response = {
            rewards: s
              ? t.response.awards.map(function(e) {
                  return this._factory.createObjectiveReward(e);
                }, this)
              : []
          }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(i),
      n
    );
  }),
  (UTObjectivesDAO.prototype.redeemLearningObjectiveReward = function redeemLearningObjectiveReward(
    e,
    t
  ) {
    var n = new UTObservable(),
      i = new UTUtasHttpRequest(this._authDelegate);
    return (
      i.setPath(
        '/ut/game/' +
          GAME_NAME +
          '/scmp/learning/group/' +
          e +
          '/objective/' +
          t +
          '/rewards'
      ),
      i.setRequestType(enums.HTTPRequestMethod.PUT),
      i.observe(this, function _onRedeemLearningObjectiveReward(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s = utils.JS.isObject(t.response) && Array.isArray(t.response.awards);
        (i.status = t.status),
          (i.success = t.success),
          (i.response = {
            rewards: s
              ? t.response.awards.map(function(e) {
                  return this._factory.createObjectiveReward(e);
                }, this)
              : []
          }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(i),
      n
    );
  }),
  (UTObjectivesDAO.prototype.redeemExpiredRewards = function redeemExpiredRewards() {
    var n = new UTObservable(),
      e = new UTUtasHttpRequest(this._authDelegate);
    return (
      e.setPath('/ut/game/' + GAME_NAME + '/scmp/campaign/rewards/all'),
      e.setRequestType(enums.HTTPRequestMethod.PUT),
      e.observe(this, function _onRedeemRewards(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s =
            utils.JS.isObject(t.response) &&
            Array.isArray(t.response.awardsList);
        (i.status = t.status),
          (i.success = t.success),
          (i.response = {
            rewards: s
              ? t.response.awardsList.map(function(e) {
                  return this._factory.createObjectiveReward(e);
                }, this)
              : []
          }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(e),
      n
    );
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.SBCEligibility = function UTSBCEligibilityDTO(e) {
    (this.kvPairs = new UTHashTable()),
      (this.count = -1),
      (this.scope = -1),
      (this.isCombinedRequirement = !1),
      Object.defineProperty(this, 'isCombinedRequirement', {
        get: function() {
          return 1 < this.kvPairs.length;
        },
        enumerable: !0
      }),
      e.forEach(function(e) {
        switch (e.eligibilityKey) {
          case enums.SBC.ELG_KEY.FUT_ELGRULE_SCOPE:
            this.scope = e.eligibilityValue;
            break;
          case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_COUNT:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_COUNT_COMBINED:
            this.count = e.eligibilityValue;
            break;
          case enums.SBC.ELG_KEY.FUT_ELGRULE_TEAM_STAR_RATING:
            this.kvPairs.set(e.eligibilityKey, [e.eligibilityValue / 2]);
            break;
          case enums.SBC.ELG_KEY.FUT_ELGRULE_TEAM_CHEMISTRY:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_TEAM_RATING:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_ID:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_ID:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_ID:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_LEVEL:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_RARITY:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_RARITY_GROUP:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_QUALITY:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_SAME_NATION_COUNT:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_SAME_LEAGUE_COUNT:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_SAME_CLUB_COUNT:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_COUNT:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_COUNT:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_COUNT:
          case enums.SBC.ELG_KEY.FUT_ELGRULE_LEGEND_COUNT:
            var t = e.eligibilityValue;
            this.kvPairs.set(e.eligibilityKey, utils.JS.valToArray(t));
            break;
          default:
            utils.Debug.Assert(!1, 'Reached default case: ' + e.eligibilityKey);
        }
      }, this),
      Object.defineProperty(this, 'kvPairs', {
        writable: !1,
        enumerable: !0
      }),
      Object.defineProperty(this, 'count', {
        writable: !1,
        enumerable: !0
      }),
      Object.defineProperty(this, 'scope', {
        writable: !1,
        enumerable: !0
      });
  }),
  (transferobjects.SBCEligibility.prototype.getValue = function getValue(e) {
    return this.kvPairs.has(e) ? this.kvPairs.get(e) : [-1];
  }),
  (transferobjects.SBCEligibility.prototype.getFirstKey = function getFirstKey() {
    return 0 < this.kvPairs.length
      ? parseInt(this.kvPairs.keys()[0], 10)
      : (utils.Debug.Assert(
          !1,
          'transferobjects.SBCEligibility::getFirstKey. Requirement is empty or invalid.'
        ),
        -1);
  }),
  (transferobjects.SBCEligibility.prototype.getFirstValue = function getFirstValue(
    e
  ) {
    return this.kvPairs.has(e) ? this.kvPairs.get(e)[0] : -1;
  }),
  (transferobjects.SBCEligibility.prototype.buildString = function buildString() {
    var e = '',
      t = 'sbc.requirements.',
      i = 'scope' + this.scope,
      s = this.getFirstKey(),
      o = this.getValue(s),
      n = this.count,
      a = 1 === n ? t + 'player.' + i : t + 'players.' + i;

    function createStringFromValues(i, s) {
      if (1 < o.length) {
        var n = '';
        return (
          o.forEach(function(e, t) {
            (n += utils.JS.isValid(s) ? i.call(this, s + e) : i.call(this, e)),
              (n +=
                t < o.length - 1
                  ? ' ' +
                    services.Localization.localize(
                      'label.general.or'
                    ).toUpperCase() +
                    ' '
                  : '');
          }, this),
          n
        );
      }
      var e = o[0];
      return utils.JS.isValid(s) ? i.call(this, s + e) : i.call(this, e);
    }
    if (this.isCombinedRequirement) {
      var r = [];
      this.kvPairs.keys().forEach(function(e) {
        switch (((e = parseInt(e, 10)), (o = this.getValue(e)), e)) {
          case enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_ID:
            r.push(
              createStringFromValues.call(
                this,
                utils.FUTLocalization.getNationNameById
              )
            );
            break;
          case enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_ID:
            r.push(
              createStringFromValues.call(
                this,
                utils.FUTLocalization.getLeagueNameByID
              )
            );
            break;
          case enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_ID:
            r.push(
              createStringFromValues.call(
                this,
                utils.FUTLocalization.getTeamAbb15ByID
              )
            );
            break;
          default:
            utils.Debug.Assert(
              !1,
              '[transferobjects.SBCEligibility::buildString] | Reached invalid combined case: ' +
                e
            );
        }
      }, this),
        (e =
          services.Localization.localize(a + '.val', [n]) +
          ' ' +
          r.join(' + '));
    } else
      switch (s) {
        case enums.SBC.ELG_KEY.FUT_ELGRULE_TEAM_STAR_RATING:
          e = services.Localization.localize(t + 'team.rating.' + i, o);
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_TEAM_RATING:
          e = services.Localization.localize(t + 'team.rating1to100.' + i, o);
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_TEAM_CHEMISTRY:
          e = services.Localization.localize(t + 'team.chemistry.' + i, o);
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_QUALITY:
          e = services.Localization.localize(t + i);
          var l = o[0];
          l === enums.SBC.ELG_QUALITY_TYPES.BRONZE
            ? (e +=
                ' ' + services.Localization.localize('packtype.bronzePlayers'))
            : l === enums.SBC.ELG_QUALITY_TYPES.SILVER
            ? (e +=
                ' ' + services.Localization.localize('packtype.silverPlayers'))
            : (e +=
                ' ' + services.Localization.localize('packtype.goldPlayers'));
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_LEVEL:
          e =
            services.Localization.localize(t + 'rare.' + i, [n]) +
            ' ' +
            createStringFromValues.call(
              services.Localization,
              services.Localization.localize,
              'search.cardLevels.cardLevel'
            );
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_SAME_NATION_COUNT:
          e = services.Localization.localize(a, [
            o,
            services.Localization.localize(t + 'subType.nation')
          ]);
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_SAME_LEAGUE_COUNT:
          e = services.Localization.localize(a, [
            o,
            services.Localization.localize(t + 'subType.league')
          ]);
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_SAME_CLUB_COUNT:
          e = services.Localization.localize(a, [
            o,
            services.Localization.localize(t + 'subType.club')
          ]);
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_COUNT:
          e = services.Localization.localize(t + 'nations.' + i, [o]);
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_COUNT:
          e = services.Localization.localize(t + 'leagues.' + i, [o]);
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_COUNT:
          e = services.Localization.localize(t + 'clubs.' + i, [o]);
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_ID:
          e =
            services.Localization.localize(a + '.val', [n]) +
            ' ' +
            createStringFromValues.call(
              this,
              utils.FUTLocalization.getNationNameById
            );
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_ID:
          e =
            services.Localization.localize(a + '.val', [n]) +
            ' ' +
            createStringFromValues.call(
              this,
              utils.FUTLocalization.getLeagueNameByID
            );
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_ID:
          e =
            services.Localization.localize(a + '.val', [n]) +
            ' ' +
            createStringFromValues.call(
              this,
              utils.FUTLocalization.getTeamAbb15ByID
            );
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_LEGEND_COUNT:
          (a = 1 === o ? t + 'legend.' + i : t + 'legends.' + i),
            (e = services.Localization.localize(a, [o]));
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_RARITY:
          e =
            services.Localization.localize(t + 'rare.' + i, [n]) +
            ' ' +
            createStringFromValues.call(
              services.Localization,
              services.Localization.localize,
              'item.raretype'
            );
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_RARITY_GROUP:
          e =
            services.Localization.localize(t + 'rare.' + i, [n]) +
            ' ' +
            createStringFromValues.call(
              services.Localization,
              services.Localization.localize,
              'Player_Group_'
            );
          break;
        default:
          utils.Debug.Assert(
            !1,
            '[transferobjects.SBCEligibility::buildString] | Reached default case: ' +
              s
          );
      }
    return e;
  }),
  utils.JS.inherits(UTSBCFactory, UTObject),
  (UTSBCFactory.prototype.createCategory = function createCategory(e) {
    return new transferobjects.SBCCategory(
      e.categoryId,
      e.priority,
      e.name,
      enums.SBC.CATEGORY_TYPE.SERVER
    );
  }),
  (UTSBCFactory.prototype.createSet = function createSet(e) {
    return new entities.SBCSet(e);
  }),
  (UTSBCFactory.prototype.createChallenge = function createSet(e) {
    return new entities.SBCChallenge(e, this.createRequirements(e.elgReq));
  }),
  (UTSBCFactory.prototype.createSetsFromCategories = function createSetsFromCategories(
    e
  ) {
    var t = [],
      s = [];
    return (
      e.forEach(function(e) {
        var i = this.createCategory(e);
        t.push(i),
          e.sets.forEach(function(e) {
            var t = this.createSet(e);
            i.setIds.push(t.id), s.push(t);
          }, this);
      }, this),
      {
        categories: t,
        sets: s
      }
    );
  }),
  (UTSBCFactory.prototype.createSetChallenges = function createSetChallenges(
    e
  ) {
    return e.map(function(e) {
      return this.createChallenge(e);
    }, this);
  }),
  (UTSBCFactory.prototype.createRequirements = function(e) {
    var i,
      s,
      n = [];
    return (
      e.forEach(function(e) {
        if (s !== e.eligibilitySlot)
          (s = e.eligibilitySlot),
            (i = new UTHashTable()).set(e.type, e),
            (n[s] = i);
        else {
          var t = (i = n[s]).get(e.type);
          utils.JS.isValid(t)
            ? (t.eligibilityValue = [].concat(
                t.eligibilityValue,
                e.eligibilityValue
              ))
            : i.set(e.type, e);
        }
      }, this),
      n.reduce(
        function(e, t) {
          return (
            utils.JS.isValid(t) &&
              e.push(this._createEligibilityRequirement(t)),
            e
          );
        }.bind(this),
        []
      )
    );
  }),
  (UTSBCFactory.prototype._createEligibilityRequirement = function _createEligibilityRequirement(
    e
  ) {
    return new transferobjects.SBCEligibility(e.values());
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.SBCCategory = function UTSBCCategoryDTO(e, t, i, s) {
    (this.id = e),
      Object.defineProperty(this, 'id', {
        writable: !1
      }),
      (this.priority = t),
      Object.defineProperty(this, 'priority', {
        writable: !1
      }),
      (this.name = i),
      Object.defineProperty(this, 'name', {
        writable: !1
      }),
      (this.setIds = []),
      Object.defineProperty(this, 'setIds', {
        writable: !0
      }),
      (this.displayable = !1),
      Object.defineProperty(this, 'displayable', {
        writable: !0
      }),
      (this.isAll = s === enums.SBC.CATEGORY_TYPE.CUSTOM_ALL),
      Object.defineProperty(this, 'isAll', {
        writable: !1
      }),
      (this.isFavourite = s === enums.SBC.CATEGORY_TYPE.CUSTOM_FAVOURITE),
      Object.defineProperty(this, 'isFavourite', {
        writable: !1
      }),
      (this.type = s),
      Object.defineProperty(this, 'type', {
        writable: !1
      });
  }),
  NamespaceManager.Register('interfaces'),
  (interfaces.SquadSaveDelegate = function ISquadSaveDelegate() {}),
  (interfaces.SquadSaveDelegate.prototype.save = function save(e) {}),
  NamespaceManager.Register('entities'),
  (entities.SBCChallenge = function(e, t) {
    var i;
    (this.id = e.challengeId),
      Object.defineProperty(this, 'id', {
        writable: !1,
        enumerable: !0
      }),
      (this.name = e.name),
      Object.defineProperty(this, 'name', {
        writable: !1,
        enumerable: !0
      }),
      (this.description = e.description),
      Object.defineProperty(this, 'description', {
        writable: !1,
        enumerable: !0
      }),
      (this.endTime =
        utils.JS.isNumber(e.endTime) && 0 < e.endTime
          ? e.endTime + Math.round(new Date().getTime() / 1e3)
          : 0),
      Object.defineProperty(this, 'endTime', {
        writable: !1,
        enumerable: !0
      }),
      (this.notExpirable = 0 === this.endTime),
      Object.defineProperty(this, 'notExpirable', {
        writable: !1,
        enumerable: !0
      }),
      (this.priority = e.priority),
      Object.defineProperty(this, 'priority', {
        writable: !1,
        enumerable: !0
      }),
      (this.repeatable = e.repeatable),
      Object.defineProperty(this, 'repeatable', {
        writable: !1,
        enumerable: !0
      }),
      (this.setId = e.setId),
      Object.defineProperty(this, 'setId', {
        writable: !1,
        enumerable: !0
      }),
      (this.assetId = utils.JS.isEmpty(e.challengeImageId)
        ? e.trophyId
        : e.challengeImageId),
      (this.formation = e.formation),
      Object.defineProperty(this, 'formation', {
        writable: !1,
        enumerable: !0
      }),
      (this.type = e.type),
      Object.defineProperty(this, 'type', {
        writable: !1,
        enumerable: !0
      }),
      Object.defineProperty(this, 'status', {
        get: function() {
          return i;
        },
        set: function(e) {
          var t;
          for (t in enums.SBC.CHALLENGE_STATUS)
            if (
              enums.SBC.CHALLENGE_STATUS.hasOwnProperty(t) &&
              enums.SBC.CHALLENGE_STATUS[t] === e
            )
              return void (i = e);
          utils.Debug.Assert(
            !1,
            'Invalid assignment to entity: SBCChallenge.status'
          );
        }
      }),
      (this.status = e.status),
      (this.timesCompleted = e.timesCompleted),
      Object.defineProperty(this, 'timesCompleted', {
        writable: !0
      }),
      (this.awards = utils.JS.isValid(e.awards)
        ? e.awards.map(function(e) {
            return new transferobjects.SBCReward(e);
          }, this)
        : []),
      this.awards.sort(function awardSort(e, t) {
        return e.getPriority() < t.getPriority()
          ? -1
          : e.getPriority() > t.getPriority()
          ? 1
          : 0;
      }),
      Object.defineProperty(this, 'awards', {
        writable: !1,
        enumerable: !0
      }),
      (this._eligibilityOperation =
        e.elgOperation === enums.SBC.ELG_OPERATION.AND ||
        e.elgOperation === enums.SBC.ELG_OPERATION.OR
          ? e.elgOperation
          : enums.SBC.ELG_OPERATION.AND),
      Object.defineProperty(this, '_eligibilityOperation', {
        writable: !1,
        enumerable: !1
      }),
      (this.eligibilityRequirements = t),
      Object.defineProperty(this, 'eligibilityRequirements', {
        writable: !1,
        enumerable: !0
      }),
      (this.squad = null),
      Object.defineProperty(this, 'squad', {
        writable: !0
      }),
      (this.onDataChange = new UTObservable()),
      Object.defineProperty(this, 'onDataChange', {
        writable: !1,
        enumerable: !0
      }),
      (this.onSave = new UTObservable()),
      Object.defineProperty(this, 'onSave', {
        writable: !1,
        enumerable: !0
      });
  }),
  (entities.SBCChallenge.prototype.reset = function reset() {
    (this.status = enums.SBC.CHALLENGE_STATUS.NOT_STARTED),
      (this.squad = null),
      this.onDataChange.notify({
        status: this.status,
        squad: this.squad
      });
  }),
  (entities.SBCChallenge.prototype.hasNotStarted = function hasNotStarted() {
    return this.status === enums.SBC.CHALLENGE_STATUS.NOT_STARTED;
  }),
  (entities.SBCChallenge.prototype.isInProgress = function isInProgress() {
    return this.status === enums.SBC.CHALLENGE_STATUS.IN_PROGRESS;
  }),
  (entities.SBCChallenge.prototype.isCompleted = function isCompleted() {
    return this.status === enums.SBC.CHALLENGE_STATUS.COMPLETED;
  }),
  (entities.SBCChallenge.prototype.isBrickChallenge = function isBrickChallenge() {
    return (
      this.type === enums.SBC.CHALLENGE_TYPE.BRICK ||
      this.type === enums.SBC.CHALLENGE_TYPE.CUSTOM_BRICK
    );
  }),
  (entities.SBCChallenge.prototype.hasExpired = function hasExpired(e) {
    if (this.notExpirable) return !1;
    var t = this.endTime - Math.round(new Date().getTime() / 1e3);
    return (
      e &&
        (t +=
          60 *
          services.Configuration.getFeatureSetting(
            enums.ServerFeature.SBC_GRACE_PERIOD_MINUTES
          )),
      t < 0
    );
  }),
  (entities.SBCChallenge.prototype._getApplicableSlotsForCombinedReq = function _getApplicableSlotsForCombinedReq(
    i
  ) {
    var s = [];
    return (
      i.kvPairs.keys().forEach(function(e) {
        e = parseInt(e, 10);
        var t = i.getFirstValue(e);
        switch (e) {
          case enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_ID:
            s = s.concat(this.squad.getSlotIndicesByNation(t));
            break;
          case enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_ID:
            s = s.concat(this.squad.getSlotIndicesByLeague(t));
            break;
          case enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_ID:
            s = s.concat(this.squad.getSlotIndicesByClub(t));
            break;
          default:
            utils.Debug.Assert(!1, 'Reached invalid combined case: ' + e);
        }
      }, this),
      s
    );
  }),
  (entities.SBCChallenge.prototype._hasMultipleValues = function _hasMultipleValues(
    e,
    t
  ) {
    return !!e.kvPairs.has(t) && 1 < e.kvPairs.get(t).length;
  }),
  (entities.SBCChallenge.prototype.isRequirementMet = function isRequirementMet(
    e
  ) {
    var t,
      i = e.kvPairs.keys().length,
      s = 0,
      n = 0;
    if (!this.squad || this.eligibilityRequirements.indexOf(e) < 0) return !1;
    if (e.isCombinedRequirement) {
      n = e.count;
      var o = {};
      this._getApplicableSlotsForCombinedReq(e).forEach(function(e) {
        o[e] ? ((o[e] += 1), o[e] === i && s++) : (o[e] = 1);
      }, e);
    } else {
      if (1 !== i)
        return utils.Debug.Assert(!1, 'Requirement is empty or invalid.'), !1;
      var a = e.getFirstKey(),
        r = this._hasMultipleValues(e, a) ? e.getValue(a) : e.getFirstValue(a);
      switch (((n = r), a)) {
        case enums.SBC.ELG_KEY.FUT_ELGRULE_TEAM_STAR_RATING:
          s = this.squad.getStarRating();
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_TEAM_RATING:
          s = this.squad.getRating();
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_TEAM_CHEMISTRY:
          s = this.squad.getChemistry();
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_QUALITY:
          s = -1;
          var l = this.squad.getPlayersPerQualityTier().keys();
          if (0 === l.length) break;
          e.scope === enums.SBC.ELG_SCOPE.FUT_ELGRULE_SCOPE_GREATER
            ? (s = Math.min.apply(Math, l))
            : e.scope === enums.SBC.ELG_SCOPE.FUT_ELGRULE_SCOPE_LOWER
            ? (s = Math.max.apply(Math, l))
            : 1 === l.length && (s = parseInt(l[0], 10));
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_LEVEL:
          (n = e.count), (s = this.squad.getNumberOfPlayersByQualityTier(r));
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_SAME_NATION_COUNT:
          t = this.squad.getPlayersPerNation();
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_SAME_LEAGUE_COUNT:
          t = this.squad.getPlayersPerLeague();
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_SAME_CLUB_COUNT:
          t = this.squad.getPlayersPerClub();
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_COUNT:
          s = this.squad.getPopularNationalities().length;
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_COUNT:
          s = this.squad.getPopularLeagues().length;
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_COUNT:
          s = this.squad.getPopularClubs().length;
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_ID:
          (n = e.count), (s = this.squad.getNumberOfPlayersByNation(r));
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_ID:
          (n = e.count), (s = this.squad.getNumberOfPlayersByLeague(r));
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_ID:
          (n = e.count), (s = this.squad.getNumberOfPlayersByClub(r));
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_LEGEND_COUNT:
          s = this.squad.getNumberOfLegends();
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_RARITY:
          (n = e.count), (s = this.squad.getNumberOfPlayersByRarity(r));
          break;
        case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_RARITY_GROUP:
          (n = e.count), (s = this.squad.getNumberOfPlayersByGroup(r));
          break;
        default:
          utils.Debug.Assert(!1, 'Reached default case: ' + a);
      }
    }
    return e.scope === enums.SBC.ELG_SCOPE.FUT_ELGRULE_SCOPE_GREATER
      ? (utils.JS.isValid(t) && (s = Math.max.apply(Math, t.values())), n <= s)
      : e.scope === enums.SBC.ELG_SCOPE.FUT_ELGRULE_SCOPE_LOWER
      ? (utils.JS.isValid(t) && (s = Math.max.apply(Math, t.values())), s <= n)
      : (utils.JS.isValid(t) && (s = Math.max.apply(Math, t.values())),
        s === n);
  }),
  (entities.SBCChallenge.prototype.meetsRequirements = function meetsRequirements() {
    if (this.squad && !this.squad.isSquadFull()) return !1;
    for (var e = this.eligibilityRequirements.length; 0 < e--; ) {
      var t = this.isRequirementMet(this.eligibilityRequirements[e]);
      if (!t && this._eligibilityOperation === enums.SBC.ELG_OPERATION.AND)
        return !1;
      if (t && this._eligibilityOperation === enums.SBC.ELG_OPERATION.OR)
        return !0;
    }
    return !0;
  }),
  (entities.SBCChallenge.prototype.canSubmit = function canSubmit() {
    return (
      !this.hasExpired(!0) &&
      this.meetsRequirements() &&
      this.squad.isSBCSquadEligible()
    );
  }),
  (entities.SBCChallenge.prototype.hasUntradeableItems = function hasUntradeableItems() {
    return utils.JS.isValid(
      utils.JS.find(this.squad.getNonBrickSlots(), function(e) {
        return e.getItem().untradeable;
      })
    );
  }),
  (entities.SBCChallenge.prototype.getRequirementCounter = function getRequirementCounter(
    e
  ) {
    var t = 0;
    if (
      !this.isInProgress() ||
      !this.squad ||
      this.eligibilityRequirements.indexOf(e) < 0
    )
      return -1;
    if (e.isCombinedRequirement) return -1;
    var i = e.getFirstKey(),
      s = this._hasMultipleValues(e, i) ? e.getValue(i) : e.getFirstValue(i);
    switch (i) {
      case enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_COUNT:
        t += this.squad.getPopularNationalities().length;
        break;
      case enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_COUNT:
        t += this.squad.getPopularLeagues().length;
        break;
      case enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_COUNT:
        t += this.squad.getPopularClubs().length;
        break;
      case enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_ID:
        t += this.squad.getNumberOfPlayersByNation(s);
        break;
      case enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_ID:
        t += this.squad.getNumberOfPlayersByLeague(s);
        break;
      case enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_ID:
        t += this.squad.getNumberOfPlayersByClub(s);
        break;
      case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_LEVEL:
        t += this.squad.getNumberOfPlayersByQualityTier(s);
        break;
      case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_RARITY:
        t += this.squad.getNumberOfPlayersByRarity(s);
        break;
      case enums.SBC.ELG_KEY.FUT_ELGRULE_PLAYER_RARITY_GROUP:
        t += this.squad.getNumberOfPlayersByGroup(s);
        break;
      default:
        return -1;
    }
    return t;
  }),
  (entities.SBCChallenge.prototype.getNumberOfRequirementsMet = function getNumberOfRequirementsMet() {
    var t = 0;
    return (
      this.squad.isSquadFull() && t++,
      this.eligibilityRequirements.forEach(function(e) {
        this.isRequirementMet(e) && t++;
      }, this),
      t
    );
  }),
  (transferobjects.SBCReward = function(e) {
    transferobjects.Reward.call(this, e),
      (this.loan = e.loan),
      Object.defineProperty(this, 'loan', {
        writable: !1
      });
  }),
  utils.JS.inherits(transferobjects.SBCReward, transferobjects.Reward),
  NamespaceManager.Register('entities'),
  (entities.SBCSet = function UTSBCSetEntity(e) {
    (this.id = e.setId),
      Object.defineProperty(this, 'id', {
        writable: !1
      }),
      (this.name = e.name),
      Object.defineProperty(this, 'name', {
        writable: !1
      }),
      (this.description = e.description),
      Object.defineProperty(this, 'description', {
        writable: !1
      }),
      (this.endTime =
        utils.JS.isNumber(e.endTime) && 0 < e.endTime
          ? e.endTime + Math.round(new Date().getTime() / 1e3)
          : 0),
      Object.defineProperty(this, 'endTime', {
        writable: !1
      }),
      (this.notExpirable = 0 === this.endTime),
      Object.defineProperty(this, 'notExpirable', {
        writable: !1
      }),
      (this.priority = e.priority),
      Object.defineProperty(this, 'priority', {
        writable: !1
      }),
      (this.repeatable = e.repeatable),
      Object.defineProperty(this, 'repeatable', {
        writable: !1
      }),
      (this.assetId = utils.JS.isEmpty(e.setImageId)
        ? e.trophyId
        : e.setImageId),
      (this.challengesCount = e.challengesCount),
      Object.defineProperty(this, 'challengesCount', {
        writable: !1
      }),
      (this.challengesCompletedCount = e.challengesCompletedCount),
      Object.defineProperty(this, 'challengesCompletedCount', {
        writable: !0
      }),
      (this.timesCompleted = e.timesCompleted),
      Object.defineProperty(this, 'timesCompleted', {
        writable: !0
      }),
      (this.isFeatured = e.taggedByProduction),
      Object.defineProperty(this, 'isFeatured', {
        writable: !1
      }),
      (this.isFavourite = e.taggedByUser),
      Object.defineProperty(this, 'isFavourite', {
        writable: !0
      }),
      (this.awards = e.awards.map(function(e) {
        return new transferobjects.SBCReward(e);
      }, this)),
      this.awards.sort(function awardSort(e, t) {
        return e.getPriority() < t.getPriority()
          ? -1
          : e.getPriority() > t.getPriority()
          ? 1
          : 0;
      }),
      Object.defineProperty(this, 'awards', {
        writable: !1
      }),
      (this.hidden = e.hidden),
      Object.defineProperty(this, 'hidden', {
        writable: !1
      }),
      (this._previewImageId = e.rewardPreviewImageId),
      Object.defineProperty(this, '_previewImageId', {
        writable: !1
      }),
      (this.tutorial = e.tutorial),
      Object.defineProperty(this, 'tutorial', {
        writable: !1
      }),
      (this.challenges = new UTHashTable()),
      Object.defineProperty(this, 'challenges', {
        writable: !1
      });
  }),
  (entities.SBCSet.prototype.isComplete = function isComplete() {
    return this.challengesCount === this.challengesCompletedCount;
  }),
  (entities.SBCSet.prototype.isDisplayable = function isDisplayable() {
    return !this.hasExpired();
  }),
  (entities.SBCSet.prototype.hasExpired = function hasExpired(e) {
    if (this.notExpirable) return !1;
    var t = this.endTime - Math.round(new Date().getTime() / 1e3);
    return (
      e &&
        (t +=
          60 *
          services.Configuration.getFeatureSetting(
            enums.ServerFeature.SBC_GRACE_PERIOD_MINUTES
          )),
      t < 0
    );
  }),
  (entities.SBCSet.prototype.addChallenge = function addChallenge(e) {
    this.challenges.set(e.id, e);
  }),
  (entities.SBCSet.prototype.getChallenge = function getChallenge(e) {
    return this.challenges.get(e);
  }),
  (entities.SBCSet.prototype.getPreviewImageId = function getPreviewImageId() {
    return this._previewImageId;
  }),
  utils.JS.inherits(UTSBCDAO, UTObject),
  (UTSBCDAO.prototype.getSets = function getSets() {
    var n = new UTObservable(),
      e = new UTUtasHttpRequest(this._authDelegate);
    return (
      e.setPath('/ut/game/' + GAME_NAME + '/sbs/sets'),
      e.observe(this, function _onGetSetsComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s = t.success && utils.JS.isObject(t.response);
        utils.JS.assignPropertyValues(t, i),
          (i.response = s
            ? this._factory.createSetsFromCategories(t.response.categories)
            : {
                sets: [],
                categories: []
              }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(e),
      n
    );
  }),
  (UTSBCDAO.prototype.getChallengesForSet = function getChallengesForSet(e) {
    var n = new UTObservable(),
      t = new UTUtasHttpRequest(this._authDelegate);
    return (
      t.setPath('/ut/game/' + GAME_NAME + '/sbs/setId/' + e.id + '/challenges'),
      t.observe(this, function _onGetChallengesComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s = t.success && utils.JS.isObject(t.response);
        utils.JS.assignPropertyValues(t, i),
          (i.response = {
            challenges: s
              ? this._factory.createSetChallenges(t.response.challenges)
              : []
          }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(t),
      n
    );
  }),
  (UTSBCDAO.prototype.loadChallenge = function loadChallenge(e, t) {
    var n = new UTObservable(),
      i = new UTUtasHttpRequest(this._authDelegate);
    var s = '';
    return (
      t ? (s = '/squad') : i.setRequestType(enums.HTTPRequestMethod.POST),
      i.setPath('/ut/game/' + GAME_NAME + '/sbs/challenge/' + e + s),
      i.observe(this, function _onLoadChallengeComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse(),
          s = t.success && utils.JS.isObject(t.response);
        utils.JS.assignPropertyValues(t, i),
          (i.response = {
            squad: s
              ? factories.Squad.createSBCSquad(
                  t.response.squad,
                  this._factory,
                  t.response.playerRequirements
                )
              : null
          }),
          n.notify(i);
      }),
      services.UTUtasRequestQueue.send(i),
      n
    );
  }),
  (UTSBCDAO.prototype.saveChallenge = function saveChallenge(e, t) {
    var i = new UTObservable(),
      s = new UTUtasHttpRequest(this._authDelegate);
    var n = {};
    return (
      (n.players = t.getPlayers().map(function(e) {
        var t = e.getItem();
        return {
          index: e.getIndex(),
          itemData: {
            id: t.id,
            dream: t.concept
          }
        };
      })),
      s.setPath('/ut/game/' + GAME_NAME + '/sbs/challenge/' + e + '/squad'),
      s.setRequestType(enums.HTTPRequestMethod.PUT),
      s.setRequestBody(n),
      s.observe(this, function _onSaveChallengeComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      services.UTUtasRequestQueue.send(s),
      i
    );
  }),
  (UTSBCDAO.prototype.submitChallenge = function submitChallenge(e, t) {
    var s = new UTObservable(),
      i = new UTUtasHttpRequest(this._authDelegate);
    return (
      i.setPath('/ut/game/' + GAME_NAME + '/sbs/challenge/' + e),
      i.setRequestType(enums.HTTPRequestMethod.PUT),
      i.setUrlVariables({
        skipUserSquadValidation: t
      }),
      i.observe(this, function _onSubmitChallengeComplete(e, t) {
        e.unobserve(this);
        var i = new transferobjects.FUTHttpResponse();
        (i.success = t.success),
          (i.status = t.status),
          (i.response = {}),
          t.success &&
            (t.response.squads
              ? ((i.status = enums.HTTPStatusCode.CONFLICT),
                (i.success = !1),
                (i.response.itemViolations = []),
                t.response.squads.forEach(function(e) {
                  var t = e.playerList.filter(function(e) {
                    return 0 < e;
                  });
                  t.length < 1 ||
                    i.response.itemViolations.push({
                      name: e.squad,
                      itemIds: t
                    });
                }))
              : ((i.response.objectiveUpdates = new UTCampaignUpdatesDTO(
                  t.response ? t.response.dynamicObjectivesUpdates : null
                )),
                (i.response.credits = t.response.credits || 0),
                (i.response.preOrderPacks = t.response.preOrderPacks || 0),
                (i.response.recoveredPacks = t.response.recoveredPacks || 0),
                (i.response.challengeId = t.response.challengeId || 0),
                (i.response.grantedChallengeAwards =
                  t.response.grantedChallengeAwards || []),
                (i.response.setId = t.response.setId || 0))),
          s.notify(i);
      }),
      services.UTUtasRequestQueue.send(i),
      s
    );
  }),
  (UTSBCDAO.prototype.setFavouriteTag = function setFavouriteTag(e, t) {
    var i = new UTObservable(),
      s = new UTUtasHttpRequest(this._authDelegate);
    return (
      s.setPath('/ut/game/' + GAME_NAME + '/sbs/sets/tag'),
      s.setRequestType(enums.HTTPRequestMethod.PUT),
      s.setRequestBody({
        sets: [
          {
            setId: e.id,
            tagged: t
          }
        ]
      }),
      s.observe(this, function _onSetFavouriteTagComplete(e, t) {
        e.unobserve(this), i.notify(t);
      }),
      services.UTUtasRequestQueue.send(s),
      i
    );
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.ShowOffSquad = function UTShowOffSquadDTO(e, t) {
    (this.squad = e),
      (this.id = t.showoffid),
      (this.url =
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_SHOW_OFF_URL
        ) + t.url),
      (this.timestamp = t.timestamp),
      (this.viewcount = t.viewcount),
      (this.persona = t.persona),
      (this.platform = t.platform),
      (this.clubName = utils.JS.isValid(this.squad)
        ? t.data.squad[0].clubName
        : ''),
      (this.clubAbbr = utils.JS.isValid(this.squad)
        ? t.data.squad[0].clubAbbr
        : ''),
      (this.estDate = utils.JS.isValid(this.squad)
        ? t.data.squad[0].estDate
        : '');
  }),
  utils.JS.inherits(UTChampionsEventEntity, UTObject),
  (UTChampionsEventEntity.prototype.isValid = function isValid() {
    return 0 <= this._id;
  }),
  (UTChampionsEventEntity.prototype.getId = function getId() {
    return this._id;
  }),
  (UTChampionsEventEntity.prototype.getStartTime = function getStartTime() {
    return this._startTime;
  }),
  (UTChampionsEventEntity.prototype.setStartTime = function setStartTime(e) {
    (this._startTime = e),
      this.onDataUpdated.notify({
        startTime: this._startTime
      });
  }),
  (UTChampionsEventEntity.prototype.getEndTime = function getEndTime() {
    return this._endTime;
  }),
  (UTChampionsEventEntity.prototype.setEndTime = function setEndTime(e) {
    (this._endTime = e),
      this.onDataUpdated.notify({
        endTime: this._endTime
      });
  }),
  (UTChampionsEventEntity.prototype.getState = function getState() {
    return this._state;
  }),
  (UTChampionsEventEntity.prototype.setState = function setState(e) {
    (this._state = e),
      this.onDataUpdated.notify({
        state: this._state
      });
  }),
  (UTChampionsEventEntity.prototype.getType = function getType() {
    return this._type;
  }),
  (UTChampionsEventEntity.prototype.setType = function setType(e) {
    (this._type = e),
      this.onDataUpdated.notify({
        type: this._type
      });
  }),
  (UTChampionsEventEntity.prototype.isInGracePeriod = function isInGracePeriod() {
    var e = Math.round(Date.now() / 1e3),
      t =
        services.Configuration.getFeatureSetting(
          enums.ServerFeature.WEEKEND_LEAGUE_GRACE_PERIOD_HOURS
        ) || 0;
    return this._startTime <= e && (e - this._startTime) / 3600 < t;
  }),
  utils.JS.inherits(UTChampionsEntityFactory, UTObject),
  (UTChampionsEntityFactory.prototype.createChampionsEvent = function createChampionsEvent(
    e
  ) {
    var t = new UTChampionsEventEntity(e.id || -1);
    return (
      (t._startTime = e.startTime),
      (t._endTime = e.endTime),
      (t._state = e.state),
      (t._type = e.type),
      t
    );
  }),
  NamespaceManager.Register('factories'),
  (factories.ChampionsEntity = new UTChampionsEntityFactory()),
  utils.JS.inherits(UTChampionsUnclaimedEventDTO, UTObject),
  NamespaceManager.Register('accessobjects'),
  (accessobjects.Champions = (function() {
    function UTChampionsDAO() {
      UTObject.call(this),
        (this._authDelegate = null),
        Object.defineProperty(this, '_authDelegate', {
          writable: !0,
          enumerable: !1
        });
    }
    return (
      utils.JS.inherits(UTChampionsDAO, UTObject),
      (UTChampionsDAO.prototype.setAuthDelegate = function setAuthDelegate(e) {
        e && e.conforms(interfaces.AuthDelegate) && (this._authDelegate = e);
      }),
      (UTChampionsDAO.prototype._triggerUnauthorizedResponse = function _triggerUnauthorizedResponse(
        e
      ) {
        console.log(
          'Missing composite authentication delegate in UTChampionsDAO'
        );
        var t = new transferobjects.FUTHttpResponse();
        (t.status = enums.HTTPStatusCode.UNAUTHORIZED), e.notify(t);
      }),
      (UTChampionsDAO.prototype.getUpcomingEvents = function getUpcomingEvents() {
        var n = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(n), n;
        var e = new UTUtasHttpRequest(this._authDelegate);
        return (
          e.setPath('/ut/game/' + GAME_NAME + '/champion/events/upcoming'),
          e.observe(this, function _onGetUpcomingEventsComplete(e, t) {
            e.unobserve(this);
            var i,
              s = new transferobjects.FUTHttpResponse();
            utils.JS.assignPropertyValues(t, s),
              (i = t.success
                ? t.response.championEvents.map(function(e) {
                    return factories.ChampionsEntity.createChampionsEvent(e);
                  })
                : []),
              (s.response = {
                events: i
              }),
              n.notify(s);
          }),
          services.UTUtasRequestQueue.send(e),
          n
        );
      }),
      (UTChampionsDAO.prototype.getUnclaimedEvents = function getUnclaimedEvents() {
        var n = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(n), n;
        var e = new UTUtasHttpRequest(this._authDelegate);
        return (
          e.setPath('/ut/game/' + GAME_NAME + '/champion/user/hub'),
          e.setUrlVariables({
            scope: 'nano'
          }),
          e.observe(this, function _onGetUnclaimedEventsComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse(),
              s =
                utils.JS.isObject(t.response) &&
                Array.isArray(t.response.unclaimedPrizesChampionEvents);
            (i.response = {
              unclaimedPrizesChampionEvents: s
                ? t.response.unclaimedPrizesChampionEvents.map(function(e) {
                    return new UTChampionsUnclaimedEventDTO(e);
                  })
                : []
            }),
              (i.status = t.status),
              (i.success = t.success),
              n.notify(i);
          }),
          services.UTUtasRequestQueue.send(e),
          n
        );
      }),
      (UTChampionsDAO.prototype.claimById = function claimById(o) {
        var a = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(a), a;
        var e = new UTUtasHttpRequest(this._authDelegate);
        return (
          e.setPath('/ut/game/' + GAME_NAME + '/champion/user/prize'),
          e.setRequestBody({
            idList: o
          }),
          e.setRequestType(enums.HTTPRequestMethod.POST),
          e.observe(this, function _onClaimByIdComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            if (
              ((i.response = {
                awards: [],
                eventsFullyClaimed: []
              }),
              (i.status = t.status),
              (i.success = t.success),
              t.success &&
                t.response &&
                utils.JS.isObject(t.response) &&
                0 < Object.keys(t.response).length &&
                t.response.awardedPrizes)
            ) {
              t.response.awardedPrizes.forEach(function(e) {
                e.awards.forEach(function(e) {
                  i.response.awards.push(new transferobjects.Reward(e));
                }, this);
              }, this);
              var s = o;
              if (0 < t.response.prizesInError.length) {
                var n = t.response.prizesInError.map(function(e) {
                  return e.eventId;
                }, this);
                s = utils.JS.removeElementsFromArray(o, n);
              }
              i.response.eventsFullyClaimed = s;
            }
            a.notify(i);
          }),
          services.UTUtasRequestQueue.send(e),
          a
        );
      }),
      new UTChampionsDAO()
    );
  })()),
  utils.JS.inherits(UTConsolidatedRewardsDTO, UTObject),
  (UTConsolidatedRewardsDTO.prototype.organize = function organize() {
    this.awards.sort(function(e, t) {
      return utils.JS.sortCompare(
        e.isChampionQualificationPoints,
        t.isChampionQualificationPoints
      );
    });
  }),
  NamespaceManager.Register('services'),
  (services.Champions = (function() {
    function ChampionsService() {
      this._events = new UTHashTable();
    }
    return (
      (ChampionsService.prototype.reset = function reset() {
        this._events.clear();
      }),
      (ChampionsService.prototype.requestUpcomingEvents = function requestUpcomingEvents() {
        var i = new UTObservable(),
          s = new transferobjects.ServiceResponse();
        if (
          !services.Configuration.checkFeatureEnabled(
            enums.ServerFeature.CHAMPIONS_ENABLED
          )
        )
          return (
            (s.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED),
            i.notify(s),
            i
          );
        return (
          accessobjects.Champions.getUpcomingEvents().observe(
            this,
            function _onGetUpcomingEventsComplete(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                (s.data = {
                  events: t.response.events
                }),
                s.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
                  services.Configuration.setFeatureEnabled(
                    enums.ServerFeature.CHAMPIONS_ENABLED,
                    !1
                  ),
                i.notify(s);
            }
          ),
          i
        );
      }),
      (ChampionsService.prototype.requestUnclaimedEvents = function requestUnclaimedEvents() {
        var i = new UTObservable(),
          s = new transferobjects.ServiceResponse();
        if (
          ((s.data = {
            unclaimedEvents: []
          }),
          !services.Configuration.checkFeatureEnabled(
            enums.ServerFeature.CHAMPIONS_ENABLED
          ))
        )
          return (
            (s.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED),
            i.notify(s),
            i
          );
        if (0 < this._events.length)
          return (
            (s.success = !0),
            (s.status = enums.HTTPStatusCode.OK),
            (s.data.unclaimedEvents = this._events.values()),
            i.notify(s),
            i
          );
        return (
          accessobjects.Champions.getUnclaimedEvents().observe(
            this,
            function _onUnclaimedEventsRetrieved(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                s.success
                  ? (t.response.unclaimedPrizesChampionEvents.forEach(function(
                      e
                    ) {
                      this._events.set(e.id, e);
                    },
                    this),
                    (s.data.unclaimedEvents = this._events.values()))
                  : s.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
                    services.Configuration.setFeatureEnabled(
                      enums.ServerFeature.CHAMPIONS_ENABLED,
                      !1
                    ),
                i.notify(s);
            }
          ),
          i
        );
      }),
      (ChampionsService.prototype.claimById = function claimById(e) {
        var n = new UTObservable(),
          o = new transferobjects.ServiceResponse();
        return (
          accessobjects.Champions.claimById(utils.JS.valToArray(e)).observe(
            this,
            function _onClaimByIdComplete(e, t) {
              e.unobserve(this);
              var i = {};
              if (
                (((i = {
                  id: 1
                }).awards = t.response.awards),
                (o.success = t.success),
                (o.status = t.status),
                (o.data = {
                  awards: [new UTConsolidatedRewardsDTO(i)],
                  allClaimed: !1
                }),
                t.success && 0 < o.data.awards.length)
              ) {
                t.response.eventsFullyClaimed.forEach(function(e) {
                  this._events.remove(e);
                }, this);
                var s = 0 === this._events.length;
                s ||
                  services.Notification.queue([
                    services.Localization.localize(
                      'notification.champions.claimAllFailed'
                    ),
                    enums.UINotificationType.NEGATIVE
                  ]),
                  (o.data.allClaimed = s);
              } else
                o.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
                  services.Configuration.setFeatureEnabled(
                    enums.ServerFeature.CHAMPIONS_ENABLED,
                    !1
                  ),
                  services.Notification.queue([
                    services.Localization.localize(
                      'notification.champions.claimFailed'
                    ),
                    enums.UINotificationType.NEGATIVE
                  ]);
              n.notify(o);
            }
          ),
          n
        );
      }),
      (ChampionsService.prototype.claimRewards = function claimRewards() {
        var i = new UTObservable(),
          s = new transferobjects.ServiceResponse();

        function _onClaimComplete(e, t) {
          e.unobserve(this), (s = t), i.notify(t);
        }
        return (
          this.requestUnclaimedEvents().observe(this, function(e) {
            if ((e.unobserve(this), 0 < this._events.length)) {
              var t = this._events.map(function(e) {
                return e.id;
              });
              this.claimById(t).observe(this, _onClaimComplete);
            } else services.Notification.queue([services.Localization.localize('notification.champions.claimFailed'), enums.UINotificationType.NEGATIVE]), i.notify(s);
          }),
          i
        );
      }),
      new ChampionsService()
    );
  })()),
  utils.JS.inherits(UTLeaderboardOptionDTO, UTObject),
  utils.JS.inherits(UTLeaderboardEntryDTO, UTObject),
  utils.JS.inherits(UTLeaderboardPermutationDTO, UTObject),
  NamespaceManager.Register('accessobjects'),
  (accessobjects.Leaderboards = (function() {
    function UTLeaderboardsDAO() {
      UTObject.call(this),
        (this._authDelegate = null),
        Object.defineProperty(this, '_authDelegate', {
          writable: !0,
          enumerable: !1
        });
    }
    return (
      utils.JS.inherits(UTLeaderboardsDAO, UTObject),
      (UTLeaderboardsDAO.prototype.setAuthDelegate = function setAuthDelegate(
        e
      ) {
        e && e.conforms(interfaces.AuthDelegate) && (this._authDelegate = e);
      }),
      (UTLeaderboardsDAO.prototype._triggerUnauthorizedResponse = function _triggerUnauthorizedResponse(
        e
      ) {
        console.log(
          'Missing composite authentication delegate in UTLeaderboardsDAO'
        );
        var t = new transferobjects.FUTHttpResponse();
        (t.status = enums.HTTPStatusCode.UNAUTHORIZED), e.notify(t);
      }),
      (UTLeaderboardsDAO.prototype.getOptions = function getOptions() {
        var o = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(o), o;
        var e = new UTUtasHttpRequest(this._authDelegate);
        return (
          e.setPath('/ut/game/' + GAME_NAME + '/leaderboards/options'),
          e.observe(this, function _onGetOptionsComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse(),
              s = utils.JS.isObject(t.response),
              n = new UTLeaderboardPermutationDTO();
            utils.JS.assignPropertyValues(t, i),
              t.success &&
                s &&
                utils.JS.isObject(t.response.selection) &&
                ((n.category = t.response.selection.category),
                (n.period = t.response.selection.period),
                (n.view = t.response.selection.view)),
              (i.response = {
                options:
                  s && 0 < t.response.options.length
                    ? utils.JS.flattenArray(
                        t.response.options.map(function(i) {
                          var s = [];
                          return (
                            i[i.id].forEach(function(e) {
                              var t = new UTLeaderboardOptionDTO(e);
                              (t.groupId = i.id), s.push(t);
                            }, this),
                            s
                          );
                        })
                      )
                    : [],
                selection: n
              }),
              o.notify(i);
          }),
          services.UTUtasRequestQueue.send(e),
          o
        );
      }),
      (UTLeaderboardsDAO.prototype.getLeaderboardByPermutation = function getLeaderboardByPermutation(
        n
      ) {
        var o = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(o), o;
        var e = new UTUtasHttpRequest(this._authDelegate);
        return (
          e.setPath(
            '/ut/game/' +
              GAME_NAME +
              '/leaderboards/period/' +
              n.period +
              '/category/' +
              n.category +
              '/view/' +
              n.view
          ),
          e.observe(this, function _onGetLeaderboardComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse(),
              s = utils.JS.isObject(t.response);
            utils.JS.assignPropertyValues(t, i),
              (i.response = {
                entries:
                  s &&
                  Array.isArray(t.response.entries) &&
                  0 < t.response.entries.length
                    ? t.response.entries.map(function(e) {
                        var t = new UTLeaderboardEntryDTO(e);
                        return (t.category = n.category), t;
                      })
                    : []
              }),
              o.notify(i);
          }),
          services.UTUtasRequestQueue.send(e),
          o
        );
      }),
      (UTLeaderboardsDAO.prototype.getUserStatsByPeriod = function getUserStatsByPeriod(
        e
      ) {
        var n = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(n), n;
        var t = new UTUtasHttpRequest(this._authDelegate),
          o = this._authDelegate.getCurrentUser().getSelectedPersona(),
          i = o.id;
        return (
          t.setPath(
            '/ut/game/' + GAME_NAME + '/leaderboards/period/' + e + '/user/' + i
          ),
          t.observe(this, function _onGetUserStatsComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            if (
              ((i.success = t.success),
              (i.status = t.status),
              (i.response = {
                entries: []
              }),
              i.success && Array.isArray(t.response.category))
            ) {
              var s = o.getCurrentClub();
              i.response.entries = t.response.category.map(function(e) {
                return new UTLeaderboardEntryDTO({
                  badge: s.assetId,
                  category: e.id,
                  clubName: s.name,
                  est: s.established,
                  persona: o.name,
                  rank: 0,
                  score: {
                    value: e.score.value
                  },
                  teamId: 0
                });
              });
            }
            n.notify(i);
          }),
          services.UTUtasRequestQueue.send(t),
          n
        );
      }),
      new UTLeaderboardsDAO()
    );
  })()),
  utils.JS.inherits(UTLeaderboardEntryRepository, UTHashTable),
  (UTLeaderboardEntryRepository.prototype.reset = function reset() {
    this.clear(), this._expiryTimestamps.clear();
  }),
  (UTLeaderboardEntryRepository.prototype.setEntriesByPermutation = function setEntriesByPermutation(
    e,
    t
  ) {
    var i = this._generateUniqueIdFromPermutation(e);
    this.remove(i), this.set(i, t);
  }),
  (UTLeaderboardEntryRepository.prototype.getEntriesByPermutation = function getEntriesByPermutation(
    e
  ) {
    var t = this._generateUniqueIdFromPermutation(e),
      i = this.get(t);
    return Array.isArray(i) ? i : [];
  }),
  (UTLeaderboardEntryRepository.prototype.isEmpty = function isEmpty(e) {
    if (utils.JS.isValid(e)) {
      var t = this._generateUniqueIdFromPermutation(e),
        i = this.get(t);
      return !Array.isArray(i) || i.length < 1;
    }
    return this.values().length < 1;
  }),
  (UTLeaderboardEntryRepository.prototype.isCacheExpired = function isCacheExpired(
    e
  ) {
    var t = this._generateUniqueIdFromPermutation(e);
    return (this._expiryTimestamps.get(t) || 0) < Date.now();
  }),
  (UTLeaderboardEntryRepository.prototype.setCacheTimestamp = function setCacheTimestamp(
    e,
    t,
    i
  ) {
    var s = this._generateUniqueIdFromPermutation(e);
    this._expiryTimestamps.set(
      s,
      t + (utils.JS.isNumber(i) ? i * MS_PER_SECOND : 3e5)
    );
  }),
  (UTLeaderboardEntryRepository.prototype._generateUniqueIdFromPermutation = function _generateUniqueIdFromPermutation(
    e
  ) {
    return e.category + ':' + e.view + ':' + e.period;
  }),
  NamespaceManager.Register('services'),
  (services.Leaderboards = (function() {
    function UTLeaderboardsService() {
      UTObject.call(this),
        (this._leaderboardEntries = new UTLeaderboardEntryRepository()),
        Object.defineProperty(this, '_leaderboardEntries', {
          writable: !1,
          enumerable: !1
        }),
        (this._userEntries = new UTLeaderboardEntryRepository()),
        Object.defineProperty(this, '_userEntries', {
          writable: !1,
          enumerable: !1
        });
    }
    return (
      utils.JS.inherits(UTLeaderboardsService, UTObject),
      (UTLeaderboardsService.prototype.requestOptions = function requestOptions() {
        var i = new UTObservable(),
          s = new transferobjects.ServiceResponse();
        return (
          accessobjects.Leaderboards.getOptions().observe(
            this,
            function _onGetOptionsComplete(e, t) {
              e.unobserve(this),
                (s.status = t.status),
                (s.success = t.success),
                (s.data = {
                  options: t.response.options,
                  selection: t.response.selection
                }),
                i.notify(s);
            }
          ),
          i
        );
      }),
      (UTLeaderboardsService.prototype.requestLeaderboardByPermutation = function requestLeaderboardByPermutation(
        i
      ) {
        var s = new UTObservable(),
          n = new transferobjects.ServiceResponse();
        if (
          !this._leaderboardEntries.isEmpty(i) &&
          !this._leaderboardEntries.isCacheExpired(i)
        )
          return (
            (n.success = !0),
            (n.status = enums.HTTPStatusCode.NOT_MODIFIED),
            (n.data = {
              entries: this._leaderboardEntries.getEntriesByPermutation(i)
            }),
            s.notify(n),
            s
          );
        return (
          accessobjects.Leaderboards.getLeaderboardByPermutation(i).observe(
            this,
            function _onGetLeaderboardComplete(e, t) {
              e.unobserve(this),
                (n.status = t.status),
                (n.success = t.success),
                (n.data = {
                  entries: []
                }),
                t.success &&
                  Array.isArray(t.response.entries) &&
                  ((n.data.entries = t.response.entries.sort(function(e, t) {
                    return utils.JS.sortCompare(e.rank, t.rank);
                  })),
                  this._leaderboardEntries.setEntriesByPermutation(
                    i,
                    n.data.entries
                  ),
                  this._leaderboardEntries.setCacheTimestamp(i, Date.now())),
                s.notify(n);
            }
          ),
          s
        );
      }),
      (UTLeaderboardsService.prototype.requestUserStatsByPermutation = function requestUserStatsByPermutation(
        i
      ) {
        var s = new UTObservable(),
          n = new transferobjects.ServiceResponse();
        if (
          !this._userEntries.isEmpty(i) &&
          !this._userEntries.isCacheExpired(i)
        ) {
          var e = this._userEntries.getEntriesByPermutation(i);
          return (
            (n.success = !0),
            (n.status = enums.HTTPStatusCode.NOT_MODIFIED),
            (n.data = {
              entries: e,
              current: utils.JS.find(e, function(e) {
                return e.category === i.category;
              })
            }),
            s.notify(n),
            s
          );
        }
        return (
          accessobjects.Leaderboards.getUserStatsByPeriod(i.period).observe(
            this,
            function _onGetUserStatsComplete(e, t) {
              e.unobserve(this),
                (n.status = t.status),
                (n.success = t.success),
                (n.data = {
                  entries: [],
                  current: null
                }),
                t.success &&
                  Array.isArray(t.response.entries) &&
                  ((n.data.entries = t.response.entries),
                  (n.data.current = utils.JS.find(t.response.entries, function(
                    e
                  ) {
                    return e.category === i.category;
                  })),
                  this._userEntries.setEntriesByPermutation(
                    i,
                    t.response.entries
                  ),
                  this._userEntries.setCacheTimestamp(
                    i,
                    Date.now(),
                    0 < t.maxAge ? t.maxAge : null
                  )),
                s.notify(n);
            }
          ),
          s
        );
      }),
      new UTLeaderboardsService()
    );
  })()),
  (UTLocaleVO.prototype.equals = function equals(e) {
    return (
      this.language === e.language &&
      this.region === e.region &&
      this.variant === e.variant
    );
  }),
  (UTLocaleVO.prototype.toString = function toString() {
    return (
      this.language +
      (this.variant !== enums.LanguageVariant.NONE ? '_' + this.variant : '') +
      '_' +
      this.region
    );
  }),
  (UTLocaleVO.prototype.toBCPString = function toBCPString() {
    return (
      this.language +
      (this.variant !== enums.LanguageVariant.NONE ? '-' + this.variant : '') +
      '-' +
      this.region
    );
  }),
  (UTLocaleVO.prototype.toEAFIFAString = function toEAFIFAString() {
    var e = this.language,
      t = this.region;
    return (
      e === enums.Language.JAPANESE && (e = 'jp'),
      t === enums.Region.TAIWAN && (t = enums.Region.HONGKONG),
      e + '-' + t
    );
  }),
  (UTLocaleVO.prototype.toEANetworkString = function toEANetworkString() {
    return this.language + '_' + this.region;
  }),
  (UTLocaleVO.prototype.isValid = function isValid() {
    return (
      this.language !== enums.Language.UNKNOWN &&
      this.region !== enums.Region.UNKNOWN
    );
  }),
  utils.JS.inherits(UTLocaleFactory, UTObject),
  (UTLocaleFactory.prototype._convertLanguageToSupportedLanguage = function _convertLanguageToSupportedLanguage(
    e
  ) {
    switch (e) {
      case enums.Language.FRENCH:
        return enums.Language.FRENCH;
      case enums.Language.ITALIAN:
        return enums.Language.ITALIAN;
      case enums.Language.GERMAN:
        return enums.Language.GERMAN;
      case enums.Language.SPANISH:
        return enums.Language.SPANISH;
      case enums.Language.DUTCH:
        return enums.Language.DUTCH;
      case enums.Language.PORTUGUESE:
        return enums.Language.PORTUGUESE;
      case enums.Language.POLISH:
        return enums.Language.POLISH;
      case enums.Language.ARABIC:
        return enums.Language.ARABIC;
      case enums.Language.RUSSIAN:
        return enums.Language.RUSSIAN;
      case enums.Language.TURKISH:
        return enums.Language.TURKISH;
      case enums.Language.JAPANESE:
        return enums.Language.JAPANESE;
      case enums.Language.KOREAN:
        return enums.Language.KOREAN;
      case enums.Language.CHINESE:
        return enums.Language.CHINESE;
      default:
        return enums.Language.ENGLISH;
    }
  }),
  (UTLocaleFactory.prototype._convertLanguageVariantToSupportedVariant = function _convertLanguageVariantToSupportedVariant(
    e
  ) {
    switch (e) {
      case enums.LanguageVariant.CHINESE_SIMPLIFIED:
        return enums.LanguageVariant.CHINESE_SIMPLIFIED;
      case enums.LanguageVariant.CHINESE_TRADITIONAL:
        return enums.LanguageVariant.CHINESE_TRADITIONAL;
      default:
        return enums.LanguageVariant.NONE;
    }
  }),
  (UTLocaleFactory.prototype._convertRegionToSupportedRegion = function _convertRegionToSupportedRegion(
    e
  ) {
    switch (e) {
      case enums.Region.FRANCE:
        return enums.Region.FRANCE;
      case enums.Region.ITALY:
        return enums.Region.ITALY;
      case enums.Region.GERMANY:
        return enums.Region.GERMANY;
      case enums.Region.SPAIN:
        return enums.Region.SPAIN;
      case enums.Region.MEXICO:
        return enums.Region.MEXICO;
      case enums.Region.NETHERLANDS:
        return enums.Region.NETHERLANDS;
      case enums.Region.BRAZIL:
        return enums.Region.BRAZIL;
      case enums.Region.POLAND:
        return enums.Region.POLAND;
      case enums.Region.SAUDI_ARABIA:
        return enums.Region.SAUDI_ARABIA;
      case enums.Region.RUSSIA:
        return enums.Region.RUSSIA;
      case enums.Region.TURKEY:
        return enums.Region.TURKEY;
      case enums.Region.JAPAN:
        return enums.Region.JAPAN;
      case enums.Region.KOREA:
        return enums.Region.KOREA;
      case enums.Region.TAIWAN:
        return enums.Region.TAIWAN;
      case enums.Region.CHINA:
        return enums.Region.CHINA;
      default:
        return enums.Region.USA;
    }
  }),
  (UTLocaleFactory.prototype._getLanguageFromRegion = function _getLanguageFromRegion(
    e
  ) {
    switch (e) {
      case enums.Region.USA:
        return enums.Language.ENGLISH;
      case enums.Region.FRANCE:
        return enums.Language.FRENCH;
      case enums.Region.ITALY:
        return enums.Language.ITALIAN;
      case enums.Region.GERMANY:
        return enums.Language.GERMAN;
      case enums.Region.SPAIN:
      case enums.Region.MEXICO:
        return enums.Language.SPANISH;
      case enums.Region.NETHERLANDS:
        return enums.Language.DUTCH;
      case enums.Region.BRAZIL:
        return enums.Language.PORTUGUESE;
      case enums.Region.POLAND:
        return enums.Language.POLISH;
      case enums.Region.SAUDI_ARABIA:
        return enums.Language.ARABIC;
      case enums.Region.RUSSIA:
        return enums.Language.RUSSIAN;
      case enums.Region.TURKEY:
        return enums.Language.TURKISH;
      case enums.Region.JAPAN:
        return enums.Language.JAPANESE;
      case enums.Region.KOREA:
        return enums.Language.KOREAN;
      case enums.Region.CHINA:
      case enums.Region.TAIWAN:
        return enums.Language.CHINESE;
      default:
        return enums.Language.ENGLISH;
    }
  }),
  (UTLocaleFactory.prototype._getLanguageVariantFromRegion = function _getLanguageVariantFromRegion(
    e
  ) {
    switch (e) {
      case enums.Region.TAIWAN:
        return enums.LanguageVariant.CHINESE_TRADITIONAL;
      case enums.Region.CHINA:
        return enums.LanguageVariant.CHINESE_SIMPLIFIED;
      default:
        return enums.LanguageVariant.NONE;
    }
  }),
  (UTLocaleFactory.prototype._getRegionFromLanguage = function _getRegionFromLanguage(
    e,
    t
  ) {
    switch (e) {
      case enums.Language.ENGLISH:
        return enums.Region.USA;
      case enums.Language.FRENCH:
        return enums.Region.FRANCE;
      case enums.Language.ITALIAN:
        return enums.Region.ITALY;
      case enums.Language.GERMAN:
        return enums.Region.GERMANY;
      case enums.Language.SPANISH:
        return enums.Region.SPAIN;
      case enums.Language.DUTCH:
        return enums.Region.NETHERLANDS;
      case enums.Language.PORTUGUESE:
        return enums.Region.BRAZIL;
      case enums.Language.POLISH:
        return enums.Region.POLAND;
      case enums.Language.ARABIC:
        return enums.Region.SAUDI_ARABIA;
      case enums.Language.RUSSIAN:
        return enums.Region.RUSSIA;
      case enums.Language.TURKISH:
        return enums.Region.TURKEY;
      case enums.Language.JAPANESE:
        return enums.Region.JAPAN;
      case enums.Language.KOREAN:
        return enums.Region.KOREA;
      case enums.Language.CHINESE:
        return t === enums.LanguageVariant.CHINESE_TRADITIONAL
          ? enums.Region.TAIWAN
          : enums.Region.CHINA;
      default:
        return enums.Region.USA;
    }
  }),
  (UTLocaleFactory.prototype._getLanguageName = function _getLanguageName(
    e,
    t,
    i
  ) {
    switch (e) {
      case enums.Language.ENGLISH:
        return 'English';
      case enums.Language.FRENCH:
        return 'FranÃ§ais';
      case enums.Language.ITALIAN:
        return 'Italiano';
      case enums.Language.GERMAN:
        return 'Deutsch';
      case enums.Language.SPANISH:
        return t === enums.Region.MEXICO
          ? 'EspaÃ±ol (AmÃ©rica Latina)'
          : 'EspaÃ±ol';
      case enums.Language.DUTCH:
        return 'Nederlands';
      case enums.Language.PORTUGUESE:
        return 'PortuguÃªs do Brasil';
      case enums.Language.POLISH:
        return 'Polski';
      case enums.Language.ARABIC:
        return 'Ø§Ù„Ø¹ÙŽØ±ÙŽØ¨ÙÙŠÙŽÙ‘Ø©';
      case enums.Language.RUSSIAN:
        return 'Ð ÑƒÑÑÐºÐ¸Ð¹';
      case enums.Language.TURKISH:
        return 'TÃ¼rkÃ§e';
      case enums.Language.JAPANESE:
        return 'æ—¥æœ¬èªž';
      case enums.Language.KOREAN:
        return 'í•œêµ­ì–´';
      case enums.Language.CHINESE:
        return i === enums.LanguageVariant.CHINESE_TRADITIONAL
          ? 'ç¹é«”ä¸­æ–‡'
          : 'ç®€ä½“ä¸­æ–‡';
      default:
        return '';
    }
  }),
  (UTLocaleFactory.prototype._getLanguageDirection = function _getLanguageDirection(
    e
  ) {
    switch (e) {
      case enums.Language.ARABIC:
        return 'rtl';
      default:
        return 'ltr';
    }
  }),
  (UTLocaleFactory.prototype.createLocaleFromLanguage = function createLocaleFromLanguage(
    e,
    t
  ) {
    (e = this._convertLanguageToSupportedLanguage(e.toLowerCase())),
      (t = this._convertLanguageVariantToSupportedVariant(t));
    var i = this._getRegionFromLanguage(e, t);
    return new UTLocaleVO(
      i,
      e,
      t,
      this._getLanguageName(e, i, t),
      this._getLanguageDirection(e)
    );
  }),
  (UTLocaleFactory.prototype.createLocaleFromRegion = function createLocaleFromRegion(
    e
  ) {
    e = this._convertRegionToSupportedRegion(e.toUpperCase());
    var t = this._getLanguageFromRegion(e),
      i = this._getLanguageVariantFromRegion(e);
    return new UTLocaleVO(
      e,
      t,
      i,
      this._getLanguageName(t, e, i),
      this._getLanguageDirection(t)
    );
  }),
  utils.JS.inherits(UTLocalizationRepository, UTHashTable),
  NamespaceManager.Register('services'),
  (services.Localization = (function() {
    function UTLocalizationService() {
      UTObject.call(this),
        (this.storeLocLoaded = !1),
        (this.localizationEnabled = !0),
        (this._factory = new UTLocaleFactory()),
        (this._repository = new UTLocalizationRepository()),
        Object.defineProperty(this, '_repository', {
          writable: !1,
          enumerable: !1
        }),
        (this._locale = this._factory.createLocaleFromLanguage(
          enums.Language.ENGLISH
        )),
        Object.defineProperty(this, '_locale', {
          writable: !0,
          enumerable: !1
        }),
        (this._supportedLanguages = [
          enums.Language.ENGLISH,
          enums.Language.FRENCH,
          enums.Language.ITALIAN,
          enums.Language.GERMAN,
          enums.Language.SPANISH,
          enums.Language.DUTCH,
          enums.Language.PORTUGUESE,
          enums.Language.ARABIC,
          enums.Language.TURKISH,
          enums.Language.POLISH,
          enums.Language.RUSSIAN,
          enums.Language.JAPANESE,
          enums.Language.KOREAN,
          enums.Language.CHINESE
        ]),
        Object.defineProperty(this, '_supportedLanguages', {
          writable: !1,
          enumerable: !1
        }),
        (this._rtlLanguages = [enums.Language.ARABIC]),
        Object.defineProperty(this, '_rtlLanguages', {
          writable: !1,
          enumerable: !1
        });
    }
    return (
      utils.JS.inherits(UTLocalizationService, UTObject),
      (UTLocalizationService.prototype.setLocale = function setLocale(e) {
        this._locale = e;
      }),
      (UTLocalizationService.prototype.setLocaleFromString = function setLocaleFromString(
        e
      ) {
        var t = e.split('_');
        2 < t.length
          ? this.setLocaleFromLanguage(t[0], t[1])
          : 2 === t.length
          ? this.setLocaleFromRegion(t[1])
          : this.setLocaleFromLanguage(t[0]);
      }),
      (UTLocalizationService.prototype.setLocaleFromRegion = function setLocaleFromRegion(
        e
      ) {
        this._locale = this._factory.createLocaleFromRegion(e);
      }),
      (UTLocalizationService.prototype.setLocaleFromLanguage = function setLocaleFromLanguage(
        e,
        t
      ) {
        this._locale = this._factory.createLocaleFromLanguage(e, t);
      }),
      (UTLocalizationService.prototype.getLocale = function getLocale() {
        return this._locale;
      }),
      (UTLocalizationService.prototype.getSupportedLocales = function getSupportedLocales() {
        return [
          this._factory.createLocaleFromLanguage(enums.Language.ENGLISH),
          this._factory.createLocaleFromLanguage(enums.Language.FRENCH),
          this._factory.createLocaleFromLanguage(enums.Language.ITALIAN),
          this._factory.createLocaleFromLanguage(enums.Language.GERMAN),
          this._factory.createLocaleFromRegion(enums.Region.SPAIN),
          this._factory.createLocaleFromLanguage(enums.Language.DUTCH),
          this._factory.createLocaleFromLanguage(enums.Language.PORTUGUESE),
          this._factory.createLocaleFromLanguage(enums.Language.POLISH),
          this._factory.createLocaleFromLanguage(enums.Language.ARABIC),
          this._factory.createLocaleFromLanguage(enums.Language.RUSSIAN),
          this._factory.createLocaleFromLanguage(enums.Language.TURKISH),
          this._factory.createLocaleFromRegion(enums.Region.MEXICO),
          this._factory.createLocaleFromLanguage(enums.Language.JAPANESE),
          this._factory.createLocaleFromLanguage(enums.Language.KOREAN),
          this._factory.createLocaleFromLanguage(
            enums.Language.CHINESE,
            enums.LanguageVariant.CHINESE_SIMPLIFIED
          ),
          this._factory.createLocaleFromLanguage(
            enums.Language.CHINESE,
            enums.LanguageVariant.CHINESE_TRADITIONAL
          )
        ];
      }),
      (UTLocalizationService.prototype.isRTL = function isRTL() {
        return 0 <= this._rtlLanguages.indexOf(this._locale.language);
      }),
      (UTLocalizationService.prototype.isLatinAlphabet = function isLatinAlphabet() {
        return (
          this._locale.language !== enums.Language.JAPANESE &&
          this._locale.language !== enums.Language.KOREAN &&
          this._locale.language !== enums.Language.CHINESE &&
          this._locale.language !== enums.Language.ARABIC &&
          this._locale.language !== enums.Language.RUSSIAN
        );
      }),
      (UTLocalizationService.prototype.isLanguageSupported = function isLanguageSupported(
        e
      ) {
        return 0 <= this._supportedLanguages.indexOf(e);
      }),
      (UTLocalizationService.prototype.addLocalizationStrings = function addLocalizationStrings(
        e
      ) {
        var t;
        for (t in e) e.hasOwnProperty(t) && this._repository.set(t, e[t]);
      }),
      (UTLocalizationService.prototype.localize = function localize(e, t) {
        var i = this._repository.get(e);
        return i
          ? (Array.isArray(t) &&
              0 < t.length &&
              t.forEach(function(e, t) {
                i = i.replace('%' + (t + 1).toString(), e.toString());
              }),
            i)
          : (i = '*' + e);
      }),
      (UTLocalizationService.prototype.localizeNumber = function localizeNumber(
        e
      ) {
        return this._locale.language === enums.Language.ARABIC
          ? e.toLocaleString(enums.Language.ENGLISH + '-' + enums.Region.USA)
          : e.toLocaleString(this._locale.toBCPString());
      }),
      (UTLocalizationService.prototype.localizeHeight = function localizeHeight(
        e
      ) {
        return this._locale.region === enums.Region.USA
          ? utils.TextUtils.centimetersToFeet(e)
          : e + ' cm';
      }),
      (UTLocalizationService.prototype.localizeDate = function localizeDate(e) {
        var t = utils.TextUtils.formatToTwoDigits(e.getMonth() + 1),
          i = utils.TextUtils.formatToTwoDigits(e.getDate()),
          s = e.getFullYear().toString();
        return this.localize('date.mmddyyyy', [t, i, s]);
      }),
      (UTLocalizationService.prototype.localizeDateTime = function localizeDateTime(
        e,
        t
      ) {
        var i = t ? e.getUTCHours() : e.getHours(),
          s = utils.TextUtils.formatToTwoDigits(
            t ? e.getUTCMinutes() : e.getMinutes()
          ),
          n = t ? e.getUTCDate().toString() : e.getDate().toString(),
          o = this.localize(MONTH_NAMES[t ? e.getUTCMonth() : e.getMonth()]),
          a = t ? e.getUTCFullYear().toString() : e.getFullYear().toString(),
          r = this._locale.language === enums.Language.ENGLISH,
          l = r ? (i % 12 || 12).toString() : i.toString(),
          c = '';
        return (
          r && (c = 12 <= i ? 'pm' : 'am'),
          this.localize('date.ddmmmyyyyhhmm', [n, o, a, l, s, c])
        );
      }),
      (UTLocalizationService.prototype.localizeEstablishedDate = function localizeEstablishedDate(
        e
      ) {
        return (function _FUTFounder(e) {
          return e.valueOf() < new Date(2009, 4, 1).valueOf();
        })(e)
          ? this.localize('controlbar.FUTFounder')
          : this.localize('controlbar.clubinfo.established', [
              function _localizeMonthYear(e) {
                var t = e.getMonth(),
                  i = e.getFullYear().toString();
                return this.localize('date.mmyy', [
                  this.localize(MONTH_NAMES[t]),
                  i
                ]);
              }.call(this, e)
            ]);
      }),
      (UTLocalizationService.prototype.localizeTimeRemaining = function localizeTimeRemaining(
        e
      ) {
        utils.Debug.Assert(
          0 <= e,
          'Expected parameter to be a positive integer.'
        );
        var t = Math.floor(e / SECONDS_PER_DAY),
          i = Math.floor(e / SECONDS_PER_HOUR),
          s = Math.floor(e / SECONDS_PER_MINUTE),
          n = Math.floor(
            e -
              (t * SECONDS_PER_DAY +
                i * SECONDS_PER_HOUR +
                s * SECONDS_PER_MINUTE)
          );
        return 0 < t
          ? ((i = Math.floor((e - t * SECONDS_PER_DAY) / SECONDS_PER_HOUR)),
            this.localize('timespan.dayshours', [this.localizeNumber(t), i]))
          : 0 < i
          ? ((s = Math.floor((e - i * SECONDS_PER_HOUR) / SECONDS_PER_MINUTE)),
            this.localize('timespan.hoursminutes', [i, s]))
          : 0 < s
          ? this.localize('timespan.minutesseconds', [s, n])
          : 1 === n
          ? '1 ' + this.localize('timespan.second')
          : this.localize('timespan.seconds', [n]);
      }),
      (UTLocalizationService.prototype.localizePromoTimeRemaining = function localizePromoTimeRemaining(
        e
      ) {
        if (
          (utils.Debug.Assert(
            0 <= e,
            'Expected parameter to be a positive integer.'
          ),
          e < 0)
        )
          return this.localize('timespan.listview.seconds');
        var t = Math.floor(e / SECONDS_PER_DAY),
          i = Math.floor(e / SECONDS_PER_HOUR),
          s = Math.floor(e / SECONDS_PER_MINUTE);
        return 0 < t
          ? ((i = Math.floor((e - t * SECONDS_PER_DAY) / SECONDS_PER_HOUR)),
            this.localize('timespan.dayshours', [t, i]))
          : 0 < i
          ? ((s = Math.floor((e - i * SECONDS_PER_HOUR) / SECONDS_PER_MINUTE)),
            this.localize('timespan.hoursminutes', [i, s]))
          : 0 < s
          ? 1 === s
            ? '1 ' + this.localize('timespan.minute')
            : this.localize('timespan.minutes', [s])
          : this.localize('timespan.listview.seconds');
      }),
      (UTLocalizationService.prototype.localizeAuctionTimeRemaining = function localizeAuctionTimeRemaining(
        e
      ) {
        utils.Debug.Assert(
          0 <= e,
          'Expected parameter to be a positive integer.'
        );
        var t = Math.floor(e / SECONDS_PER_DAY),
          i = Math.floor(e / SECONDS_PER_HOUR),
          s = Math.floor(e / SECONDS_PER_MINUTE);
        return (
          (e = Math.floor(
            e -
              (t * SECONDS_PER_DAY +
                i * SECONDS_PER_HOUR +
                s * SECONDS_PER_MINUTE)
          )),
          0 < t
            ? 1 === t
              ? '1 ' + this.localize('timespan.day')
              : this.localize('timespan.days', [t])
            : 0 < i
            ? 1 === i
              ? '1 ' + this.localize('timespan.hour')
              : this.localize('timespan.hours', [i])
            : 0 < s
            ? 1 === s
              ? '1 ' + this.localize('timespan.minute')
              : this.localize('timespan.minutes', [s])
            : 30 < e
            ? this.localize('timespan.listview.seconds')
            : 15 < e
            ? this.localize('timespan.listview.underseconds', [30])
            : 5 < e
            ? this.localize('timespan.listview.underseconds', [15])
            : this.localize('timespan.listview.underseconds', [5])
        );
      }),
      (UTLocalizationService.prototype.addObfuscatedLocalizationStrings = function addObfuscatedLocalizationStrings(
        e
      ) {
        function b64DecodeUnicode(e) {
          return decodeURIComponent(
            atob(e)
              .split('')
              .map(function(e) {
                return '%' + ('00' + e.charCodeAt(0).toString(16)).slice(-2);
              })
              .join('')
          );
        }
        var t;
        for (t in e)
          if (e.hasOwnProperty(t)) {
            var i = b64DecodeUnicode(e[t]);
            (t = b64DecodeUnicode(t)), this._repository.set(t, i);
          }
      }),
      (UTLocalizationService.prototype.requestLocalization = function requestLocalization() {
        var i = new UTObservable(),
          s = new transferobjects.ServiceResponse();
        return (
          accessobjects.Configuration.getLocalization(this._locale).observe(
            this,
            function _onGetLocalizationComplete(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                t.success && this.addObfuscatedLocalizationStrings(t.response),
                i.notify(s);
            }
          ),
          i
        );
      }),
      (UTLocalizationService.prototype.requestStoreLocalization = function requestStoreLocalization() {
        var i = new UTObservable(),
          s = new transferobjects.ServiceResponse();
        return (
          accessobjects.Configuration.getStoreLocalization().observe(
            this,
            function _onGetStoreLocalizationComplete(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                t.success &&
                  ((function _convertStoreLocXMLToKeyValuePairs(e) {
                    return DOMKit.HTMLCollectionToArray(
                      e.getElementsByTagName('trans-unit')
                    ).reduce(function(e, t) {
                      var i = t.attributes.resname;
                      if (i && utils.JS.isValid(i.value)) {
                        var s = t.getElementsByTagName('source')[0];
                        e.push({
                          key: i.value,
                          value: s.textContent
                        });
                      }
                      return e;
                    }, []);
                  })(t.response).forEach(function(e) {
                    this._repository.set(e.key, e.value);
                  }, this),
                  (this.storeLocLoaded = !0)),
                i.notify(s);
            }
          ),
          i
        );
      }),
      new UTLocalizationService()
    );
  })()),
  NamespaceManager.Register('services'),
  (services.MTX = (function() {
    function UTMTXService() {
      (this._transactions = new UTHashTable()),
        Object.defineProperty(this, '_transactions', {
          writable: !1,
          enumerable: !1
        }),
        (this._nimbleMTXDisableFlag = !1),
        Object.defineProperty(this, '_nimbleMTXDisableFlag', {
          writable: !0,
          enumerable: !1
        });
    }
    return (
      (UTMTXService.prototype.reset = function reset() {
        this._transactions.clear(), (this._nimbleMTXDisableFlag = !1);
      }),
      (UTMTXService.prototype.hasUnverifiedTransactions = function hasUnverifiedTransactions() {
        return 0 < this._transactions.length;
      }),
      (UTMTXService.prototype.isNimbleMTXEnabled = function isNimbleMTXEnabled() {
        return !this._nimbleMTXDisableFlag;
      }),
      (UTMTXService.prototype.disableNimbleMTX = function disableNimbleMTX() {
        this._nimbleMTXDisableFlag = !0;
      }),
      (UTMTXService.prototype.storeNimbleMTXItems = function storeNimbleMTXItems(
        e
      ) {
        repositories.UTNimbleMTXItem.reset(),
          repositories.UTNimbleMTXItem.add(e);
      }),
      (UTMTXService.prototype.getNimbleMTXItems = function getNimbleMTXItems() {
        return repositories.UTNimbleMTXItem.values();
      }),
      (UTMTXService.prototype.hasNimbleMTXItems = function hasNimbleMTXItems() {
        return !repositories.UTNimbleMTXItem.isEmpty();
      }),
      (UTMTXService.prototype.beginTransaction = function beginTransaction(e) {
        var t = new UTObservable(),
          i = new transferobjects.ServiceResponse();
        return (
          window.plugins.utilities.startMTXPurchase(
            e,
            function transactionSuccessCb(e) {
              (i.success = !0), t.notify(i);
            },
            function transactionFailCb(e) {
              t.notify(i);
            }
          ),
          t
        );
      }),
      (UTMTXService.prototype.verifyTransaction = function verifyTransaction(
        i
      ) {
        var s = new UTObservable(),
          n = new transferobjects.ServiceResponse();
        if (
          ((n.data = {
            verified: !1
          }),
          this._transactions.set(i.id, i),
          !services.Configuration.checkFeatureEnabled(
            enums.ServerFeature.COMPANION_COMMERCE_ENABLED
          ))
        )
          return (
            (n.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED),
            s.notify(n),
            s
          );
        return (
          accessobjects.MTX.verifyAndRecordPurchase(i).observe(
            this,
            function _onVerificationComplete(e, t) {
              e.unobserve(this),
                (n.success = t.success),
                (n.status = t.status),
                (n.data.verified =
                  t.success || t.status === enums.HTTPStatusCode.CONFLICT),
                t.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
                  services.Configuration.setFeatureEnabled(
                    enums.ServerFeature.COMPANION_COMMERCE_ENABLED,
                    !1
                  ),
                n.data.verified && this._transactions.remove(i.id),
                s.notify(n);
            }
          ),
          s
        );
      }),
      (UTMTXService.prototype.verifyStoredTransactions = function verifyStoredTransactions() {
        var e = new UTObservable(),
          t = new transferobjects.ServiceResponse();
        if (!this.hasUnverifiedTransactions())
          return (
            utils.Debug.Assert(
              !1,
              "No transactions to verify. verifyStoredTransactions() shouldn't have been called."
            ),
            e.notify(t),
            e
          );
        var i = this._transactions.values()[0];
        return this.verifyTransaction(i);
      }),
      (UTMTXService.prototype.checkForOutstandingTransactions = function checkForOutstandingTransactions() {
        var i = new UTObservable(),
          s = new transferobjects.ServiceResponse();
        return (
          accessobjects.MTX.checkForOutstandingTransactions().observe(
            this,
            function _onCheckComplete(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                (s.data = t.response),
                t.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
                  (isWeb()
                    ? services.Configuration.setFeatureEnabled(
                        enums.ServerFeature.MTX_ENABLED,
                        !1
                      )
                    : services.Configuration.setFeatureEnabled(
                        enums.ServerFeature.COMPANION_COMMERCE_ENABLED,
                        !1
                      )),
                i.notify(s);
            }
          ),
          i
        );
      }),
      new UTMTXService()
    );
  })()),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.Notification = function UTNotificationDTO(e, t) {
    (this.message = e),
      Object.defineProperty(this, 'message', {
        writable: !1
      }),
      (this.type = t),
      Object.defineProperty(this, 'type', {
        writable: !1
      });
  }),
  NamespaceManager.Register('services'),
  (services.Notification = (function() {
    var t;

    function NotificationService() {
      (this.display = new UTObservable()),
        Object.freeze(this.display),
        (this._queue = []),
        Object.defineProperty(this, '_queue', {
          writable: !1,
          enumerable: !1
        });
    }
    return (
      (NotificationService.prototype.clearAll = function clearAll() {
        (t = clearInterval(t)), (this._queue.length = 0);
      }),
      (NotificationService.prototype.queue = function queue(e) {
        Array.prototype.slice.call(arguments).forEach(function(e) {
          if (Array.isArray(e)) {
            var t = new transferobjects.Notification(e[0], e[1]);
            this._queue.push(t);
          } else e instanceof transferobjects.Notification && this._queue.push(e);
        }, this),
          t ||
            function pushNotification() {
              if (0 < this._queue.length) {
                t || (t = setInterval(pushNotification.bind(this), 2e3));
                var e = this._queue.shift();
                this.display.notify(e);
              } else 0 === this._queue.length && (t = clearInterval(t));
            }.call(this);
      }),
      new NotificationService()
    );
  })()),
  NamespaceManager.Register('accessobjects'),
  (accessobjects.Onboarding = (function() {
    function UTOnboardingDAO() {
      UTObject.call(this),
        (this.UTAS_REQUEST_PATH = '/ut/game/' + GAME_NAME + '/'),
        Object.defineProperty(this, 'UTAS_REQUEST_PATH', {
          writable: !1,
          enumerable: !0
        });
    }
    return (
      utils.JS.inherits(UTOnboardingDAO, UTObject),
      (UTOnboardingDAO.prototype.getHistorical = function getHistorical(e) {
        var s = new UTObservable(),
          t = new UTUtasHttpRequest(e);

        function _mapToRewardDTO(e) {
          var t = {
            halId: e.halId,
            count: e.rewardQuantity,
            value: e.rewardValue
          };
          switch (e.rewardType) {
            case enums.LoyaltyRewardType.PACKS:
              t.type = enums.AwardType.PACK;
              break;
            case enums.LoyaltyRewardType.COINS:
              t.type = enums.AwardType.COIN;
              break;
            case enums.LoyaltyRewardType.ITEMS:
              (t.type = enums.AwardType.ITEM), (t.itemData = e.itemData);
          }
          return new transferobjects.Reward(t);
        }
        return (
          t.setPath(this.UTAS_REQUEST_PATH + 'user/historical'),
          t.observe(this, function _onGetHistoricalComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            utils.JS.assignPropertyValues(t, i),
              (i.response = {
                name: t.success ? t.response.clubName : '',
                abbr: t.success ? t.response.clubAbbr : '',
                rewards:
                  t.success && t.response.returningUserRewards
                    ? t.response.returningUserRewards.map(_mapToRewardDTO)
                    : []
              }),
              s.notify(i);
          }),
          services.UTUtasRequestQueue.send(t),
          s
        );
      }),
      (UTOnboardingDAO.prototype.createClub = function createClub(e, t, i) {
        var n = new UTObservable(),
          s = new UTUtasHttpRequest(e);
        return (
          s.setPath(this.UTAS_REQUEST_PATH + 'user'),
          s.setRequestType(enums.HTTPRequestMethod.POST),
          s.setRequestBody({
            clubName: t,
            clubAbbr: i,
            purchased: !0
          }),
          s.observe(this, function _onCreateClubComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse(),
              s = utils.JS.isObject(t.response);
            (i.success = t.success),
              (i.status = t.status),
              (i.response = {
                login: s ? t.response.login : {},
                starterPack: s ? t.response.starterPack : []
              }),
              (i.maxAge = t.maxAge),
              (i.retryAfter = t.retryAfter),
              n.notify(t);
          }),
          services.UTUtasRequestQueue.send(s),
          n
        );
      }),
      (UTOnboardingDAO.prototype.getState = function getState(e) {
        var i = new UTObservable(),
          t = new UTUtasHttpRequest(e);
        return (
          t.setPath(this.UTAS_REQUEST_PATH + 'clientdata/onboarding'),
          t.observe(this, function _onGetStateComplete(e, t) {
            e.unobserve(this), i.notify(t);
          }),
          services.UTUtasRequestQueue.send(t),
          i
        );
      }),
      (UTOnboardingDAO.prototype.setState = function setState(e, t) {
        var i = new UTObservable(),
          s = new UTUtasHttpRequest(e);
        return (
          s.setPath(+this.UTAS_REQUEST_PATH + 'clientdata/onboarding'),
          s.setRequestType(enums.HTTPRequestMethod.PUT),
          s.setRequestBody({
            entries: [
              {
                key: 0,
                value: t
              }
            ]
          }),
          s.observe(this, function _onSetStateComplete(e, t) {
            e.unobserve(this), i.notify(t);
          }),
          services.UTUtasRequestQueue.send(s),
          i
        );
      }),
      (UTOnboardingDAO.prototype.selectCountry = function selectCountry(e, s) {
        var n = new UTObservable(),
          t = new UTUtasHttpRequest(e);
        return (
          t.setPath(
            this.UTAS_REQUEST_PATH +
              'user/action/ONBOARDING_COUNTRY_' +
              s +
              '_SELECTED'
          ),
          t.setRequestType(enums.HTTPRequestMethod.POST),
          t.observe(this, function _onSelectCountryComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            utils.JS.assignPropertyValues(t, i),
              (i.response = {
                countryId: s
              }),
              n.notify(i);
          }),
          services.UTUtasRequestQueue.send(t),
          n
        );
      }),
      (UTOnboardingDAO.prototype.getBadges = function getBadges(e) {
        var s = new UTObservable(),
          t = new UTUtasHttpRequest(e);
        return (
          t.setPath(this.UTAS_REQUEST_PATH + 'onboarding/badges'),
          t.observe(this, function _onGetBadgesComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            utils.JS.assignPropertyValues(t, i),
              (i.response = {
                badges: t.success
                  ? factories.Item.generateItemsFromItemData(
                      t.response.badgeItemDataList
                    )
                  : []
              }),
              s.notify(i);
          }),
          services.UTUtasRequestQueue.send(t),
          s
        );
      }),
      (UTOnboardingDAO.prototype.selectBadge = function selectBadge(e, t) {
        var s = new UTObservable(),
          i = new UTUtasHttpRequest(e);
        return (
          i.setPath(this.UTAS_REQUEST_PATH + 'onboarding/badge/' + t),
          i.setRequestType(enums.HTTPRequestMethod.POST),
          i.observe(this, function _onSelectBadgeComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            utils.JS.assignPropertyValues(t, i),
              (i.response = {
                badgeId: t.success ? t.response.badgeId : 0
              }),
              s.notify(i);
          }),
          services.UTUtasRequestQueue.send(i),
          s
        );
      }),
      (UTOnboardingDAO.prototype.getKits = function getKits(e) {
        var s = new UTObservable(),
          t = new UTUtasHttpRequest(e);
        return (
          t.setPath(this.UTAS_REQUEST_PATH + 'onboarding/kits'),
          t.observe(this, function _onGetKitsComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            utils.JS.assignPropertyValues(t, i),
              (i.response = {
                homeKits: t.success
                  ? factories.Item.generateItemsFromItemData(
                      t.response.homeItemDataList
                    )
                  : [],
                awayKits: t.success
                  ? factories.Item.generateItemsFromItemData(
                      t.response.awayItemDataList
                    )
                  : []
              }),
              s.notify(i);
          }),
          services.UTUtasRequestQueue.send(t),
          s
        );
      }),
      (UTOnboardingDAO.prototype.selectKits = function selectKits(e, t, i) {
        var s = new UTObservable(),
          n = new UTUtasHttpRequest(e);
        return (
          n.setPath(this.UTAS_REQUEST_PATH + 'onboarding/kits'),
          n.setRequestType(enums.HTTPRequestMethod.POST),
          n.setRequestBody({
            homeKitId: t,
            awayKitId: i
          }),
          n.observe(this, function _onSelectKitsComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            utils.JS.assignPropertyValues(t, i),
              (i.response = {
                awayKitId: t.success ? t.response.awayKitId : 0,
                homeKitId: t.success ? t.response.homeKitId : 0
              }),
              s.notify(i);
          }),
          services.UTUtasRequestQueue.send(n),
          s
        );
      }),
      (UTOnboardingDAO.prototype.getLoanPlayers = function getLoanPlayers(e) {
        var n = new UTObservable(),
          t = new UTUtasHttpRequest(e);
        return (
          t.setPath(this.UTAS_REQUEST_PATH + 'loan/players'),
          t.observe(this, function _onGetLoanPlayersComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse(),
              s = utils.JS.isObject(t.response);
            (i.success = t.success),
              (i.status = t.status),
              (i.response = {
                items: s
                  ? t.response.loans.map(function(e) {
                      return factories.Item.createItem(e.itemData);
                    })
                  : []
              }),
              (i.maxAge = t.maxAge),
              (i.retryAfter = t.retryAfter),
              n.notify(i);
          }),
          services.UTUtasRequestQueue.send(t),
          n
        );
      }),
      (UTOnboardingDAO.prototype.grantLoanPlayer = function grantLoanPlayer(
        e,
        t
      ) {
        var n = new UTObservable(),
          i = new UTUtasHttpRequest(e);
        return (
          i.setPath(this.UTAS_REQUEST_PATH + 'loan/player/' + t.toString()),
          i.setRequestType(enums.HTTPRequestMethod.PUT),
          i.observe(this, function _onGrantLoanPlayerComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse(),
              s = utils.JS.isObject(t.response);
            (i.success = t.success),
              (i.status = t.status),
              (i.response = {
                item: s ? factories.Item.createItem(t.response) : null
              }),
              (i.maxAge = t.maxAge),
              (i.retryAfter = t.retryAfter),
              n.notify(i);
          }),
          services.UTUtasRequestQueue.send(i),
          n
        );
      }),
      new UTOnboardingDAO()
    );
  })()),
  NamespaceManager.Register('services'),
  (services.Onboarding = (function() {
    function UTOnboardingService() {
      UTObject.call(this);
    }
    return (
      utils.JS.inherits(UTOnboardingService, UTObject),
      (UTOnboardingService.prototype.getCountries = function getCountries() {
        var e = new UTObservable(),
          t = new transferobjects.ServiceResponse();
        return (
          (t.success = !0),
          (t.status = enums.HTTPStatusCode.OK),
          (t.data = {
            countries: [
              enums.Country.ENGLAND,
              enums.Country.BRAZIL,
              enums.Country.FRANCE,
              enums.Country.ARGENTINA,
              enums.Country.GERMANY,
              enums.Country.ITALY,
              enums.Country.SPAIN,
              enums.Country.PORTUGAL,
              enums.Country.NETHERLANDS
            ]
          }),
          e.notify(t),
          e
        );
      }),
      (UTOnboardingService.prototype.selectCountry = function selectCountry(e) {
        var i = new UTObservable(),
          t = services.Authentication,
          s = new transferobjects.ServiceResponse();
        var n = utils.FUTData.mapNationIdToOnboardingCountryId(e);
        return (
          0 === n
            ? (utils.Debug.Assert(!1, 'Encountered an unsupported nation ID.'),
              (s.success = !1),
              (s.status = enums.HTTPStatusCode.BAD_REQUEST),
              i.notify(s))
            : accessobjects.Onboarding.selectCountry(t, n).observe(
                this,
                function _onSelectCountryComplete(e, t) {
                  e.unobserve(this),
                    (s.success = t.success),
                    (s.status = t.status),
                    (s.data = {
                      countryId: t.response.countryId
                    }),
                    i.notify(s);
                }
              ),
          i
        );
      }),
      (UTOnboardingService.prototype.getBadges = function getBadges() {
        var s = new UTObservable(),
          e = services.Authentication;
        return (
          accessobjects.Onboarding.getBadges(e).observe(
            this,
            function _onGetBadgesComplete(e, t) {
              e.unobserve(this);
              var i = new transferobjects.ServiceResponse();
              (i.success = t.success),
                (i.status = t.status),
                (i.data = {
                  badges: t.response.badges || []
                }),
                s.notify(i);
            }
          ),
          s
        );
      }),
      (UTOnboardingService.prototype.selectBadge = function selectBadge(i) {
        var s = new UTObservable(),
          e = services.Authentication,
          n = new transferobjects.ServiceResponse();
        return (
          i.isBadge()
            ? accessobjects.Onboarding.selectBadge(e, i.getDefId()).observe(
                this,
                function _onSelectBadgeComplete(e, t) {
                  e.unobserve(this),
                    t.success &&
                      ((i.state = enums.ItemState.ACTIVE_BADGE),
                      (i.pile = enums.FUTItemPile.CLUB),
                      repositories.Item.add(i)),
                    (n.success = t.success),
                    (n.status = t.status),
                    (n.data = {
                      badgeId: t.response.badgeId
                    }),
                    s.notify(n);
                }
              )
            : (utils.Debug.Assert(
                !1,
                'Expected a badge item when selecting a badge.'
              ),
              (n.success = !1),
              (n.status = enums.HTTPStatusCode.BAD_REQUEST),
              s.notify(n)),
          s
        );
      }),
      (UTOnboardingService.prototype.getKits = function getKits() {
        var s = new UTObservable(),
          e = services.Authentication;
        return (
          accessobjects.Onboarding.getKits(e).observe(
            this,
            function _onGetKitsComplete(e, t) {
              e.unobserve(this);
              var i = new transferobjects.ServiceResponse();
              (i.success = t.success),
                (i.status = t.status),
                (i.data = {
                  homeKits: t.response.homeKits || [],
                  awayKits: t.response.awayKits || []
                }),
                s.notify(i);
            }
          ),
          s
        );
      }),
      (UTOnboardingService.prototype.selectKits = function selectKits(i, s) {
        var n = new UTObservable(),
          e = services.Authentication,
          o = new transferobjects.ServiceResponse();
        return (
          i.isKit() && s.isKit()
            ? accessobjects.Onboarding.selectKits(
                e,
                i.getDefId(),
                s.getDefId()
              ).observe(this, function _onSelectKitsComplete(e, t) {
                e.unobserve(this),
                  t.success &&
                    ((i.state = enums.ItemState.ACTIVE_HOME_KIT),
                    (i.pile = enums.FUTItemPile.CLUB),
                    (s.state = enums.ItemState.ACTIVE_AWAY_KIT),
                    (s.pile = enums.FUTItemPile.CLUB),
                    repositories.Item.add([i, s])),
                  (o.success = t.success),
                  (o.status = t.status),
                  (o.data = {
                    awayKitId: t.response.awayKitId,
                    homeKitId: t.response.homeKitId
                  }),
                  n.notify(o);
              })
            : (utils.Debug.Assert(
                i.isKit(),
                'Expected a kit item when selecting a home kit.'
              ),
              utils.Debug.Assert(
                s.isKit(),
                'Expected a kit item when selecting an away kit.'
              ),
              (o.success = !1),
              (o.status = enums.HTTPStatusCode.BAD_REQUEST),
              n.notify(o)),
          n
        );
      }),
      (UTOnboardingService.prototype.getLoanPlayers = function getLoanPlayers() {
        var i = new UTObservable(),
          e = services.Authentication,
          s = new transferobjects.ServiceResponse();
        return (
          accessobjects.Onboarding.getLoanPlayers(e).observe(
            this,
            function _onGetLoanPlayersComplete(e, t) {
              e.unobserve(this),
                (s.data = {
                  items: t.response.items || []
                }),
                (s.success = t.success),
                (s.status = t.status),
                i.notify(s);
            }
          ),
          i
        );
      }),
      (UTOnboardingService.prototype.grantLoanPlayer = function grantLoanPlayer(
        e
      ) {
        var i = new UTObservable(),
          t = services.Authentication,
          s = new transferobjects.ServiceResponse();
        return (
          e.isLoaned()
            ? accessobjects.Onboarding.grantLoanPlayer(t, e.getDefId()).observe(
                this,
                function _onGrantLoanPlayerComplete(e, t) {
                  e.unobserve(this),
                    (s.data = {
                      item: t.response.item || null
                    }),
                    (s.success = t.success),
                    (s.status = t.status),
                    i.notify(s);
                }
              )
            : ((s.success = !1),
              (s.status = enums.HTTPStatusCode.BAD_REQUEST),
              i.notify(s)),
          i
        );
      }),
      (UTOnboardingService.prototype.createClub = function createClub() {
        var n = new UTObservable(),
          o = services.Authentication,
          a = new transferobjects.ServiceResponse();

        function _onCreateClubComplete(e, t) {
          e.unobserve(this),
            (a.success = t.success),
            (a.status = t.status),
            t.success && (a.data = t.data),
            n.notify(a);
        }
        return (
          accessobjects.Onboarding.getHistorical(o).observe(
            this,
            function _onGetHistoricalComplete(e, t) {
              if ((e.unobserve(this), t.success)) {
                var i = t.response,
                  s = o.getCurrentUser().getSelectedPersona();
                s.setLoyaltyRewards(i.rewards),
                  s
                    .createClub(o, i.name, i.abbr)
                    .observe(this, _onCreateClubComplete);
              } else
                (a.success = t.success), (a.status = t.status), n.notify(a);
            }
          ),
          n
        );
      }),
      new UTOnboardingService()
    );
  })()),
  NamespaceManager.Register('accessobjects'),
  (accessobjects.Rivals = (function() {
    function UTRivalsDAO() {
      UTObject.call(this),
        (this._authDelegate = null),
        Object.defineProperty(this, '_authDelegate', {
          writable: !0,
          enumerable: !1
        });
    }
    return (
      utils.JS.inherits(UTRivalsDAO, UTObject),
      (UTRivalsDAO.prototype.setAuthDelegate = function setAuthDelegate(e) {
        e && e.conforms(interfaces.AuthDelegate) && (this._authDelegate = e);
      }),
      (UTRivalsDAO.prototype._triggerUnauthorizedResponse = function _triggerUnauthorizedResponse(
        e
      ) {
        console.log(
          '(UTRivalsDAO) - Missing composite authentication delegate'
        );
        var t = new transferobjects.FUTHttpResponse();
        (t.status = enums.HTTPStatusCode.UNAUTHORIZED), e.notify(t);
      }),
      (UTRivalsDAO.prototype.getWeekendLeagueStatus = function getWeekendLeagueStatus() {
        var s = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(s), s;
        var e = new UTUtasHttpRequest(this._authDelegate);
        return (
          e.setPath('/ut/game/' + GAME_NAME + '/rivals/weekendleague/status'),
          e.observe(this, function _onGetWeekendLeagueStatusComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            utils.JS.assignPropertyValues(t, i),
              (i.response = {
                enabled: !1,
                qualified: !1,
                points: 0,
                threshold: 0
              }),
              t.success &&
                t.response &&
                utils.JS.isObject(t.response) &&
                (i.response = {
                  enabled: t.response.weekendLeagueEnabled || !1,
                  qualified: t.response.qualifiedInWeekendLeague || !1,
                  points: t.response.weekendLeaguePoints || 0,
                  threshold: t.response.weekendLeagueThreshold || 0
                }),
              s.notify(i);
          }),
          services.UTUtasRequestQueue.send(e),
          s
        );
      }),
      (UTRivalsDAO.prototype.getPrizeDetails = function getPrizeDetails() {
        var s = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(s), s;
        var e = new UTUtasHttpRequest(this._authDelegate);
        return (
          e.setPath('/ut/game/' + GAME_NAME + '/rivals/user/prizeDetails'),
          e.observe(this, function _onGetPrizeDetailsComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            (i.response = {
              unclaimedRewards: []
            }),
              utils.JS.isObject(t.response) &&
                utils.JS.isObject(t.response.prizes) &&
                t.response.prizes.prizeTiers.forEach(function(e) {
                  e.categoryAwardsList.forEach(function(e) {
                    i.response.unclaimedRewards.push(
                      new UTConsolidatedRewardsDTO(e)
                    );
                  });
                }),
              (i.status = t.status),
              (i.success = t.success),
              s.notify(i);
          }),
          services.UTUtasRequestQueue.send(e),
          s
        );
      }),
      (UTRivalsDAO.prototype.claimById = function claimById(e) {
        var s = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(s), s;
        var t = new UTUtasHttpRequest(this._authDelegate);
        return (
          t.setRequestType(enums.HTTPRequestMethod.PUT),
          t.setPath('/ut/game/' + GAME_NAME + '/rivals/reward/' + e),
          t.observe(this, function _onClaimRewardsComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            (i.status = t.status),
              (i.success = t.success),
              (i.response = {
                rewards: []
              }),
              t.success &&
                t.response &&
                utils.JS.isObject(t.response) &&
                0 < Object.keys(t.response).length &&
                t.response.awardedPrizes &&
                t.response.awardedPrizes.forEach(function(e) {
                  i.response.rewards.push(new transferobjects.Reward(e));
                }),
              s.notify(i);
          }),
          services.UTUtasRequestQueue.send(t),
          s
        );
      }),
      (UTRivalsDAO.prototype.accessWeekendLeague = function accessWeekendLeague() {
        var i = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(i), i;
        var e = new UTUtasHttpRequest(this._authDelegate);
        return (
          e.setPath(
            '/ut/game/' + GAME_NAME + '/rivals/user/weekendleague/access'
          ),
          e.setRequestType(enums.HTTPRequestMethod.POST),
          e.observe(this, function _onAccessWeekendLeagueComplete(e, t) {
            e.unobserve(this), i.notify(t);
          }),
          services.UTUtasRequestQueue.send(e),
          i
        );
      }),
      new UTRivalsDAO()
    );
  })()),
  NamespaceManager.Register('interfaces'),
  (interfaces.AccessObject = function() {}),
  (interfaces.AccessObject.prototype.setAuthDelegate = function setAuthDelegate(
    e
  ) {}),
  NamespaceManager.Register('repositories'),
  (repositories.RivalRewards = (function() {
    function UTRivalRewardsRepository(e) {
      (this._rewards = new UTHashTable()),
        Object.defineProperty(this, '_rewards', {
          writable: !1,
          enumerable: !1
        }),
        (this._expiryTimestamp = 0),
        utils.JS.isValid(e) && this.add(e);
    }
    return (
      (UTRivalRewardsRepository.prototype.add = function add(e) {
        Array.isArray(e)
          ? e.forEach(function(e) {
              this._rewards.set(e.id, e);
            })
          : this._rewards.set(e.id, e);
      }),
      (UTRivalRewardsRepository.prototype.get = function get(e) {
        return this._rewards.get(e).awards;
      }),
      (UTRivalRewardsRepository.prototype.values = function values() {
        return this._rewards.values();
      }),
      (UTRivalRewardsRepository.prototype.isEmpty = function isEmpty() {
        return this._rewards.length < 1;
      }),
      (UTRivalRewardsRepository.prototype.isCacheExpired = function isCacheExpired() {
        return this._expiryTimestamp < Date.now();
      }),
      (UTRivalRewardsRepository.prototype.reset = function reset() {
        this._rewards.clear(), (this._expiryTimestamp = 0);
      }),
      (UTRivalRewardsRepository.prototype.setCacheTimestamp = function setCacheTimestamp(
        e,
        t
      ) {
        this._expiryTimestamp =
          e + (utils.JS.isNumber(t) ? t * MS_PER_SECOND : 36e5);
      }),
      new UTRivalRewardsRepository()
    );
  })()),
  NamespaceManager.Register('services'),
  (services.Rivals = (function() {
    function UTRivalsService() {
      UTObject.call(this),
        (this._rivalsDAO = null),
        Object.defineProperty(this, '_rivalsDAO', {
          writable: !0,
          enumerable: !1
        });
    }
    return (
      utils.JS.inherits(UTRivalsService, UTObject),
      (UTRivalsService.prototype.setDataAccessObject = function setDataAccessObject(
        e
      ) {
        e && e.conforms(interfaces.AccessObject) && (this._rivalsDAO = e);
      }),
      (UTRivalsService.prototype._triggerObjectNotFound = function _triggerObjectNotFound(
        e
      ) {
        console.log('(UTRivalsService) - Missing Data Access Object');
        var t = new transferobjects.FUTHttpResponse();
        (t.status = enums.HTTPStatusCode.BAD_REQUEST), e.notify(t);
      }),
      (UTRivalsService.prototype.reset = function reset() {
        repositories.RivalRewards.reset();
      }),
      (UTRivalsService.prototype.requestWeekendLeagueState = function requestWeekendLeagueState() {
        var i = new UTObservable(),
          s = new transferobjects.ServiceResponse();
        return (
          accessobjects.Rivals.getWeekendLeagueStatus().observe(
            this,
            function _onGetWeekendLeagueStatusComplete(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                (s.data = {
                  enabled: t.response.enabled,
                  points: t.response.points,
                  qualified: t.response.qualified,
                  threshold: t.response.threshold
                }),
                i.notify(s);
            }
          ),
          i
        );
      }),
      (UTRivalsService.prototype.accessWeekendLeague = function accessWeekendLeague() {
        var i = new UTObservable(),
          s = new transferobjects.ServiceResponse();
        return (
          accessobjects.Rivals.accessWeekendLeague().observe(
            this,
            function _onAccessWeekendLeagueComplete(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                i.notify(s);
            }
          ),
          i
        );
      }),
      (UTRivalsService.prototype.getRewardsInfo = function getRewardsInfo() {
        var i = new UTObservable();
        if (!this._rivalsDAO) return this._triggerObjectNotFound(i), i;
        var s = new transferobjects.ServiceResponse();
        if (
          ((s.data = {
            unclaimedRewards: []
          }),
          !repositories.RivalRewards.isEmpty() &&
            !repositories.RivalRewards.isCacheExpired())
        )
          return (
            (s.success = !0),
            (s.status = enums.HTTPStatusCode.OK),
            (s.data.unclaimedRewards = repositories.RivalRewards.values()),
            i.notify(s),
            i
          );
        return (
          this._rivalsDAO
            .getPrizeDetails()
            .observe(this, function _onGetRewardsInfoComplete(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                s.success &&
                  (t.response.unclaimedRewards.forEach(function(e) {
                    s.data.unclaimedRewards.push(e),
                      repositories.RivalRewards.add(e);
                  }),
                  repositories.RivalRewards.setCacheTimestamp(
                    Date.now(),
                    0 < t.maxAge ? t.maxAge : null
                  )),
                i.notify(s);
            }),
          i
        );
      }),
      (UTRivalsService.prototype.claimById = function claimById(e) {
        var i = new UTObservable();
        if (!this._rivalsDAO) return this._triggerObjectNotFound(i), i;
        var s = new transferobjects.ServiceResponse();
        return (
          this._rivalsDAO
            .claimById(e)
            .observe(this, function _onClaimByIdComplete(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                (s.data = {
                  rewards: t.response.rewards
                }),
                s.success
                  ? this.reset()
                  : services.Notification.queue([
                      services.Localization.localize(
                        'notification.rivals.claimFailed'
                      ),
                      enums.UINotificationType.NEGATIVE
                    ]),
                i.notify(s);
            }),
          i
        );
      }),
      new UTRivalsService()
    );
  })()),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.SquadBattlesEvent = function SquadBattlesEventDTO(e) {
    (this.id = e.sqbtEventId),
      Object.defineProperty(this, 'id', {
        writable: !1
      }),
      (this.rank = e.rank),
      Object.defineProperty(this, 'rank', {
        writable: !1
      }),
      (this.score = e.score),
      Object.defineProperty(this, 'score', {
        writable: !1
      }),
      (this.tierLevel = e.userTierLevel),
      Object.defineProperty(this, 'tierLevel', {
        writable: !1
      }),
      (this.isPrizeAvailable = e.isPrizeAvailable),
      Object.defineProperty(this, 'isPrizeAvailable', {
        writable: !1
      });
    var t = [];
    utils.JS.valToArray(e.prizeTiers).forEach(function(e) {
      e.awards.forEach(function(e) {
        t.push(new transferobjects.Reward(e));
      }, this);
    }, this),
      (this.rewards = t),
      Object.defineProperty(this, 'rewards', {
        writable: !1
      });
  }),
  NamespaceManager.Register('accessobjects'),
  (accessobjects.SquadBattles = (function() {
    function UTSquadBattlesDAO() {
      UTObject.call(this),
        (this._authDelegate = null),
        Object.defineProperty(this, '_authDelegate', {
          writable: !0,
          enumerable: !1
        });
    }
    return (
      utils.JS.inherits(UTSquadBattlesDAO, UTObject),
      (UTSquadBattlesDAO.prototype.setAuthDelegate = function setAuthDelegate(
        e
      ) {
        e && e.conforms(interfaces.AuthDelegate) && (this._authDelegate = e);
      }),
      (UTSquadBattlesDAO.prototype._triggerUnauthorizedResponse = function _triggerUnauthorizedResponse(
        e
      ) {
        console.log(
          'Missing composite authentication delegate in UTSquadBattlesDAO'
        );
        var t = new transferobjects.FUTHttpResponse();
        (t.status = enums.HTTPStatusCode.UNAUTHORIZED), e.notify(t);
      }),
      (UTSquadBattlesDAO.prototype.getHub = function getHub() {
        var s = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(s), s;
        var e = new UTUtasHttpRequest(this._authDelegate);
        return (
          e.setPath('/ut/game/' + GAME_NAME + '/sqbt/user/hub'),
          e.setUrlVariables({
            scope: 'mini'
          }),
          e.observe(this, function _onGetSQBTHubComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            (i.response = {
              event: utils.JS.isObject(t.response)
                ? new transferobjects.SquadBattlesEvent(t.response)
                : null
            }),
              (i.status = t.status),
              (i.success = t.success),
              s.notify(i);
          }),
          services.UTUtasRequestQueue.send(e),
          s
        );
      }),
      (UTSquadBattlesDAO.prototype.claimRewards = function claimRewards() {
        var s = new UTObservable();
        if (!this._authDelegate) return this._triggerUnauthorizedResponse(s), s;
        var e = new UTUtasHttpRequest(this._authDelegate);
        return (
          e.setPath('/ut/game/' + GAME_NAME + '/sqbt/user/prize'),
          e.setRequestType(enums.HTTPRequestMethod.POST),
          e.observe(this, function _onClaimComplete(e, t) {
            e.unobserve(this);
            var i = new transferobjects.FUTHttpResponse();
            (i.response = {
              awards: [],
              allClaimed: !0
            }),
              (i.status = t.status),
              (i.success = t.success),
              utils.JS.isObject(t.response) &&
                t.response.awardedPrizes &&
                (t.response.awardedPrizes.forEach(function(e) {
                  e.awards.forEach(function(e) {
                    i.response.awards.push(new transferobjects.Reward(e));
                  }, this);
                }, this),
                (i.response.allClaimed =
                  0 === t.response.prizesInError.length)),
              s.notify(i);
          }),
          services.UTUtasRequestQueue.send(e),
          s
        );
      }),
      new UTSquadBattlesDAO()
    );
  })()),
  NamespaceManager.Register('services'),
  (services.SquadBattles = (function() {
    function UTSquadBattlesService() {
      (this._currentEvent = null),
        Object.defineProperty(this, '_currentEvent', {
          writable: !0,
          enumerable: !1
        }),
        (this._squadBattlesDAO = null),
        Object.defineProperty(this, '_squadBattlesDAO', {
          writable: !0,
          enumerable: !1
        });
    }
    return (
      (UTSquadBattlesService.prototype.reset = function reset() {
        this._currentEvent = null;
      }),
      (UTSquadBattlesService.prototype.setDataAccessObject = function setDataAccessObject(
        e
      ) {
        e && e.conforms(interfaces.AccessObject) && (this._squadBattlesDAO = e);
      }),
      (UTSquadBattlesService.prototype._triggerObjectNotFound = function _triggerObjectNotFound(
        e
      ) {
        console.log('(UTSquadBattlesService) - Missing Data Access Object');
        var t = new transferobjects.FUTHttpResponse();
        (t.status = enums.HTTPStatusCode.BAD_REQUEST), e.notify(t);
      }),
      (UTSquadBattlesService.prototype.requestCurrentEvent = function requestCurrentEvent() {
        var i = new UTObservable();
        if (!this._squadBattlesDAO) return this._triggerObjectNotFound(i), i;
        var s = new transferobjects.ServiceResponse();
        if (
          ((s.data = {
            event: {}
          }),
          utils.JS.isValid(this._currentEvent))
        )
          return (
            (s.success = !0),
            (s.status = enums.HTTPStatusCode.OK),
            (s.data.event = this._currentEvent),
            i.notify(s),
            i
          );
        return (
          this._squadBattlesDAO
            .getHub()
            .observe(this, function _onSQBTStateRetrieved(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                (s.data = t.response),
                (this._currentEvent = s.data.event),
                i.notify(s);
            }),
          i
        );
      }),
      (UTSquadBattlesService.prototype.claimRewards = function claimRewards() {
        var s = new UTObservable();
        if (!this._squadBattlesDAO) return this._triggerObjectNotFound(s), s;
        var n = new transferobjects.ServiceResponse();
        return (
          this._squadBattlesDAO
            .claimRewards()
            .observe(this, function _onClaimRewardsComplete(e, t) {
              e.unobserve(this), (n.success = t.success), (n.status = t.status);
              var i = {
                id: 1
              };
              (i.awards = t.response.awards),
                (n.data = {
                  awards: [new UTConsolidatedRewardsDTO(i)],
                  allClaimed: t.response.allClaimed
                }),
                t.success
                  ? n.data.allClaimed
                    ? this.reset()
                    : services.Notification.queue([
                        services.Localization.localize(
                          'notification.sqbt.claimAllFailed'
                        ),
                        enums.UINotificationType.NEGATIVE
                      ])
                  : services.Notification.queue([
                      services.Localization.localize(
                        'notification.sqbt.claimFailed'
                      ),
                      enums.UINotificationType.NEGATIVE
                    ]),
                s.notify(n);
            }),
          s
        );
      }),
      new UTSquadBattlesService()
    );
  })()),
  NamespaceManager.Register('services'),
  (services.URL = (function() {
    var n = 'easfc://',
      o = new UTHashTable(),
      s = '';

    function URLService() {}
    return (
      (URLService.prototype.registerDeepLinkID = function registerDeepLinkID(
        e,
        t
      ) {
        o.set(e, t);
      }),
      (URLService.prototype.findValidDeepLinkID = function findValidDeepLinkID(
        e
      ) {
        return (
          utils.JS.find(
            e,
            function(e) {
              return this._isValidDeepLinkID(e);
            }.bind(this)
          ) || enums.DeepLinkSections.NONE
        );
      }),
      (URLService.prototype._isValidDeepLinkID = function _isValidDeepLinkID(
        e
      ) {
        return o.has(e);
      }),
      (URLService.prototype.setDeepLinkURL = function setDeepLinkURL(e, t) {
        if (!utils.JS.isEmpty(e)) {
          var i = decodeURIComponent(e).trim();
          0 !== i.indexOf(n) && ((i = n + 'fut/' + e), t && (i += '/' + t)),
            (s = i);
        }
      }),
      (URLService.prototype.getDeepLinkURL = function getDeepLinkURL() {
        return s;
      }),
      (URLService.prototype.clearDeepLinkURL = function clearDeepLinkURL() {
        s = '';
      }),
      (URLService.prototype.hasDeepLinkURL = function hasDeepLinkURL() {
        return !utils.JS.isEmpty(s);
      }),
      (URLService.prototype.processDeepLinkURL = function processDeepLinkURL() {
        if (!this.hasDeepLinkURL()) return !1;
        var e = this.process(this.getDeepLinkURL());
        return e && this.clearDeepLinkURL(), e;
      }),
      (URLService.prototype.process = function process(e) {
        if (0 === (e = decodeURIComponent(e).trim()).indexOf(n)) {
          if (!this._checkAuth()) return !1;
          var t = e
              .substr(n.length)
              .split('/')
              .filter(function(e) {
                return '' !== e;
              }),
            i = t.shift(),
            s = t.shift();
          if ('fut' !== i || !this._isValidDeepLinkID(s))
            return (
              utils.Debug.Assert(
                !1,
                '[services.URL::process] Unable to process unknown deep link: ' +
                  e
              ),
              !1
            );
          o.get(s)(t);
        } else {
          if (
            !(
              0 === e.indexOf('https://') ||
              0 === e.indexOf('http://') ||
              (isAndroid() && e.indexOf('market://')) ||
              (isIOS() && e.indexOf('itms-apps://'))
            )
          )
            return (
              utils.Debug.Assert(
                !1,
                '[services.URL::process] Unable to process unknown or unsupported URL structure: ' +
                  e
              ),
              !1
            );
          window.open(e, '_system');
        }
        return !0;
      }),
      (URLService.prototype._checkAuth = function _checkAuth() {
        var e = services.Authentication.getFUTAuthState();
        if (
          services.User.getUser().getSelectedPersona().hasFUT &&
          e === enums.FUTAuthState.COMPLETE
        )
          return !0;
        if (e !== enums.FUTAuthState.SERVER_DOWN)
          switch (e) {
            case enums.FUTAuthState.CONCURRENT_SESSION:
              getAppMain()
                .getRootViewController()
                .showLoggedOnConsoleView();
              break;
            case enums.FUTAuthState.NEW_TRIAL_USER:
              getAppMain()
                .getRootViewController()
                .showGettingStartedView(enums.GettingStartedTypes.FIFA);
              break;
            default:
              getAppMain()
                .getRootViewController()
                .showGettingStartedView(enums.GettingStartedTypes.FUT);
          }
        return !1;
      }),
      new URLService()
    );
  })()),
  utils.JS.inherits(UTCareerEntryDTO, UTObject),
  utils.JS.inherits(UTLegendsBioDTO, UTObject),
  utils.JS.inherits(UTConfigurationService, UTObject),
  (UTConfigurationService.prototype.getItemRarity = function getItemRarity(e) {
    return repositories.Rarity.getRarity(e.rareflag, e.getYear());
  }),
  (UTConfigurationService.prototype.loadRarityData = function loadRarityData() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      repositories.Rarity.isCacheExpired()
        ? this._configurationDAO
            .getRarity()
            .observe(this, function _onGetRarityComplete(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                t.success &&
                  (repositories.Rarity.add(
                    t.response.rarities,
                    enums.Year.ASSET
                  ),
                  repositories.Rarity.setCacheTimestamp(
                    Date.now(),
                    0 < t.maxAge ? t.maxAge : null
                  )),
                i.notify(s);
            })
        : ((s.success = !0),
          (s.status = enums.HTTPStatusCode.NOT_MODIFIED),
          i.notify(s)),
      i
    );
  }),
  (UTConfigurationService.prototype.loadStaffStatData = function loadStaffStatData() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      gStaffStatsModel.isDirty()
        ? this._configurationDAO
            .getStaffStats()
            .observe(this, function _onGetStaffStatsComplete(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                t.success &&
                  (gStaffStatsModel.setPlayerAttribBoosts(
                    t.response.playerAttribBoosts
                  ),
                  gStaffStatsModel.setGKAttribBoosts(t.response.gkAttribBoosts),
                  gStaffStatsModel.setHealthAttribBoosts(
                    t.response.healthAttribBoosts
                  ),
                  gStaffStatsModel.setContractBoost(t.response.contractBoost),
                  gStaffStatsModel.setDirtyFlag(!1)),
                i.notify(s);
            })
        : ((s.success = !0),
          (s.status = enums.HTTPStatusCode.NOT_MODIFIED),
          i.notify(s)),
      i
    );
  }),
  (UTConfigurationService.prototype.requestSquadData = function requestSquadData() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      this._configurationDAO
        .getSquadData()
        .observe(this, function _onGetSquadDataComplete(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            t.success &&
              (repositories.Squad.setSquadDataLookup(t.response),
              repositories.PlayStyle.setPlayStyles(t.response.styleAttribMods)),
            i.notify(s);
        }),
      i
    );
  }),
  (UTConfigurationService.prototype.requestTeamConfig = function requestTeamConfig() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      this._configurationDAO
        .getTeamConfig()
        .observe(this, function _onGetTeamConfigComplete(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            t.success && this._parseTeamConfig(t.response),
            i.notify(s);
        }),
      i
    );
  }),
  (UTConfigurationService.prototype.requestStaticPlayerData = function requestStaticPlayerData() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      this._configurationDAO
        .getStaticPlayerData()
        .observe(this, function _onGetStaticPlayerDataComplete(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            t.success &&
              repositories.Item.setStaticData(
                t.response.Players.concat(t.response.LegendsPlayers)
              ),
            i.notify(s);
        }),
      i
    );
  }),
  (UTConfigurationService.prototype.requestPlayerMetaData = function requestPlayerMetaData() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      this._configurationDAO
        .getPlayerMetaData()
        .observe(this, function _onGetPlayerMetaDataComplete(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            t.success && repositories.PlayerMeta.setData(t.response),
            i.notify(s);
        }),
      i
    );
  }),
  (UTConfigurationService.prototype.requestPlayerIconData = function requestPlayerIconData() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      this._configurationDAO
        .getPlayerIconData()
        .observe(this, function _onGetPlayerIconDataComplete(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            t.success && repositories.PlayerIcon.setData(t.response),
            i.notify(s);
        }),
      i
    );
  }),
  (UTConfigurationService.prototype.requestMissingImagesData = function requestMissingImagesData() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      this._configurationDAO
        .getMissingImagesData()
        .observe(this, function _onGetMissingImagesDataComplete(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            t.success && utils.AssetLocator.setPlaceholderData(t.response),
            i.notify(s);
        }),
      i
    );
  }),
  (UTConfigurationService.prototype.requestSettingsData = function requestSettingsData() {
    var o = new UTObservable(),
      a = new transferobjects.ServiceResponse();
    if (!this._serverSettings.isCacheExpired())
      return (
        (a.success = !0),
        (a.status = enums.HTTPStatusCode.NOT_MODIFIED),
        (a.data = {
          settings: this._serverSettings.getSettings()
        }),
        o.notify(a),
        o
      );
    return (
      this._configurationDAO
        .getSettingsData()
        .observe(this, function _onRequestSettingsComplete(e, t) {
          if (
            (e.unobserve(this),
            (a.success = t.success),
            (a.status = t.status),
            t.success)
          ) {
            this._serverSettings.reset(),
              t.response.settings.forEach(function(e) {
                this._serverSettings.setSettingByKey(e.type, e.value);
              }, this),
              this._serverSettings.setCacheTimestamp(
                Date.now(),
                0 < t.maxAge ? t.maxAge : 600
              );
            var i = this._serverSettings.getSettingByKey(
                enums.ServerFeature.TRANSFER_LIST_SIZE
              ),
              s = this._serverSettings.getSettingByKey(
                enums.ServerFeature.TRANSFER_TARGET_SIZE
              ),
              n = this._serverSettings.getSettingByKey(
                enums.ServerFeature.MAX_ALLOWED_SQUADS
              );
            0 < i &&
              repositories.Item.setPileSize(enums.FUTItemPile.TRANSFER, i),
              0 < s &&
                repositories.Item.setPileSize(enums.FUTItemPile.INBOX, s),
              0 < n && services.Squad.setMaxSquads(n);
          }
          (a.data = {
            settings: this._serverSettings.getSettings()
          }),
            o.notify(a);
        }),
      o
    );
  }),
  (UTConfigurationService.prototype.getKillswitchableFeatures = function getKillswitchableFeatures() {
    return this._killswitchFeatures.slice();
  }),
  (UTConfigurationService.prototype.setFeatureEnabled = function setFeatureEnabled(
    e,
    t
  ) {
    this._serverSettings.setSettingByKey(e, t ? 1 : 0);
  }),
  (UTConfigurationService.prototype.checkFeatureEnabled = function checkFeatureEnabled(
    e
  ) {
    return 0 < this._serverSettings.getSettingByKey(e);
  }),
  (UTConfigurationService.prototype.getFeatureSetting = function getFeatureSetting(
    e
  ) {
    return this._serverSettings.getSettingByKey(e);
  }),
  (UTConfigurationService.prototype._parseTeamConfig = function _parseTeamConfig(
    e
  ) {
    e.Years.forEach(function(e) {
      var t = utils.TextUtils.getYearFromString(e.Year);
      repositories.TeamConfig.addTeams(e.Teams, t),
        e.ClubItemTeams && repositories.TeamConfig.addTeams(e.ClubItemTeams, t),
        e.InternationalTeams &&
          repositories.TeamConfig.addTeams(e.InternationalTeams, t),
        e.LegendsTeams &&
          repositories.TeamConfig.addTeams(e.LegendsTeams, t, !0),
        e.CustomTeams &&
          repositories.TeamConfig.addCustomTeams(e.CustomTeams, t),
        repositories.TeamConfig.addLeagues(e.Leagues, t),
        e.LegendsLeagues &&
          repositories.TeamConfig.addLeagues(e.LegendsLeagues, t, !0),
        repositories.TeamConfig.addNations(e.Nations, t);
    }, this);
  }),
  (UTMessagesRepository.prototype.reset = function reset() {
    this.resetDailyGift(),
      (this._cacheExpiration.dailyGift = 0),
      (this._cacheExpiration.liveMessages = 0);
  }),
  (UTMessagesRepository.prototype.getDailyGift = function getDailyGift() {
    return this._dailyGift;
  }),
  (UTMessagesRepository.prototype.setDailyGift = function setDailyGift(e) {
    this._dailyGift = e;
  }),
  (UTMessagesRepository.prototype.resetDailyGift = function resetDailyGift() {
    this._dailyGift = null;
  }),
  (UTMessagesRepository.prototype.isDailyGiftExpired = function isDailyGiftExpired() {
    return this._cacheExpiration.dailyGift < Date.now();
  }),
  (UTMessagesRepository.prototype.isLiveMessagesExpired = function isLiveMessagesExpired() {
    return this._cacheExpiration.liveMessages < Date.now();
  }),
  (UTMessagesRepository.prototype.setLiveMessagesCacheExpiration = function setLiveMessagesCacheExpiration(
    e
  ) {
    this._cacheExpiration.liveMessages = e;
  }),
  (UTMessagesRepository.prototype.setDailyGiftCacheExpiration = function setDailyGiftCacheExpiration(
    e
  ) {
    this._cacheExpiration.dailyGift = e;
  }),
  utils.JS.inherits(UTMessagesService, UTObject),
  (UTMessagesService.prototype.reset = function reset() {
    this._repository.reset();
  }),
  (UTMessagesService.prototype.setDailyGiftFromPayload = function setDailyGiftFromPayload(
    e
  ) {
    this._repository.setDailyGift(new entities.DailyGift(e)),
      this._repository.setDailyGiftCacheExpiration(Date.now() + 36e5);
  }),
  (UTMessagesService.prototype.getLiveMessages = function getLiveMessages() {
    var s = new UTObservable(),
      n = new transferobjects.ServiceResponse();
    if (
      ((n.data = {
        messages: [],
        promoCoins: !1,
        promoItems: !1
      }),
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.LIVE_MESSAGING_ENABLED
      ))
    )
      return (
        (n.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), s.notify(n), s
      );
    if (!this._repository.isLiveMessagesExpired())
      return (
        (n.success = !0),
        (n.status = enums.HTTPStatusCode.NOT_MODIFIED),
        s.notify(n),
        s
      );
    return (
      this._messagesDAO
        .getLiveMessages()
        .observe(this, function _onLiveMessagesRetrieved(e, t) {
          if (
            (e.unobserve(this),
            (n.success = t.success),
            (n.status = t.status),
            n.success)
          ) {
            var i = t.response.promos;
            (n.data.promoCoins = -1 !== i.indexOf(enums.AwardType.COIN)),
              (n.data.promoItems = -1 !== i.indexOf(enums.AwardType.ITEM)),
              (n.data.messages = t.response.messages),
              this._repository.setLiveMessagesCacheExpiration(Date.now() + 3e5);
          } else n.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED && services.Configuration.setFeatureEnabled(enums.ServerFeature.LIVE_MESSAGING_ENABLED, !1);
          s.notify(n);
        }),
      s
    );
  }),
  (UTMessagesService.prototype.readLiveMessage = function readLiveMessage(e) {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    if (
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.LIVE_MESSAGING_ENABLED
      )
    )
      return (
        (s.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), i.notify(s), i
      );
    return (
      this._messagesDAO
        .readLiveMessage(e)
        .observe(this, function _onLiveMessageRead(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            s.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
              services.Configuration.setFeatureEnabled(
                enums.ServerFeature.LIVE_MESSAGING_ENABLED,
                !1
              ),
            i.notify(s);
        }),
      i
    );
  }),
  (UTMessagesService.prototype.getHubMessages = function getHubMessages(e) {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      this._messagesDAO
        .getHubMessages(services.User.getUser().getSelectedPersona().id, e)
        .observe(this, function _onHubMessagesRetrieved(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            (s.data = t.response),
            i.notify(s);
        }),
      i
    );
  }),
  (UTMessagesService.prototype.getDailyGift = function getDailyGift() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse(),
      e = this._repository.getDailyGift();
    if (
      (utils.JS.isValid(e) && e.isValid) ||
      !this._repository.isDailyGiftExpired()
    )
      return (
        (s.success = !0),
        (s.status = enums.HTTPStatusCode.NOT_MODIFIED),
        (s.data = {
          dailyGift: e
        }),
        i.notify(s),
        i
      );
    return (
      this._messagesDAO
        .getDailyGift()
        .observe(this, function _onDailyGiftRetrieved(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            (s.data = t.response),
            this._repository.setDailyGiftCacheExpiration(
              Date.now() + (s.status ? 36e5 : 6e5)
            ),
            s.success && this._repository.setDailyGift(s.data.dailyGift),
            i.notify(s);
        }),
      i
    );
  }),
  (UTMessagesService.prototype.claimDailyGift = function claimDailyGift() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse(),
      n = this._repository.getDailyGift();
    if (
      ((s.data = {
        claimed: !1,
        rewardType: ''
      }),
      !utils.JS.isValid(n) || !n.isValid)
    )
      return (
        (s.success = !1),
        (s.status = enums.HTTPStatusCode.BAD_REQUEST),
        i.notify(s),
        i
      );
    return (
      this._messagesDAO
        .claimDailyGift(n.id)
        .observe(this, function _onDailyGiftClaimed(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            s.success &&
              (n.rewardType === enums.AwardType.COIN
                ? services.User.requestCurrencies()
                : n.rewardType === enums.AwardType.PACK &&
                  services.User.getUser().incrementNumUnopenedPacks(),
              this._repository.resetDailyGift()),
            i.notify(s);
        }),
      i
    );
  }),
  utils.JS.inherits(UTObjectivesRepository, UTObject),
  (UTObjectivesRepository.prototype.reset = function reset() {
    this._categories.clear(),
      (this._activeCampaign = null),
      (this._campaignCacheExpiration = 0),
      (this._objectivesCacheExpiration = 0);
  }),
  (UTObjectivesRepository.prototype.setCampaignCacheTimestamp = function setCampaignCacheTimestamp(
    e
  ) {
    this._campaignCacheExpiration = e;
  }),
  (UTObjectivesRepository.prototype.isCampaignCacheExpired = function isCampaignCacheExpired() {
    return (
      0 === this._campaignCacheExpiration ||
      this._campaignCacheExpiration < Math.round(Date.now() / 1e3)
    );
  }),
  (UTObjectivesRepository.prototype.setObjectivesCacheTimestamp = function setObjectivesCacheTimestamp(
    e
  ) {
    this._objectivesCacheExpiration = e;
  }),
  (UTObjectivesRepository.prototype.isObjectivesCacheExpired = function isObjectivesCacheExpired() {
    return (
      0 === this._objectivesCacheExpiration ||
      this._objectivesCacheExpiration < Math.round(Date.now() / 1e3)
    );
  }),
  (UTObjectivesRepository.prototype.setActiveCampaign = function setActiveCampaign(
    e
  ) {
    this._activeCampaign = e;
  }),
  (UTObjectivesRepository.prototype.getActiveCampaign = function getActiveCampaign() {
    return this._activeCampaign;
  }),
  (UTObjectivesRepository.prototype.setCategories = function setCategories(e) {
    e.forEach(function(i) {
      var e = this._categories.get(i.id);
      (e && 0 !== e.groups.length) ||
        (i.groups.forEach(function(e) {
          var t = utils.JS.isValid(
            utils.JS.find(
              e.groupIdsToUnlock,
              function(e) {
                var t = i.groups.get(e);
                return t && (t.isNotStarted() || t.isInProgress());
              }.bind(this)
            )
          );
          e.setLockedByGroups(t);
        }, this),
        this._categories.set(i.id, i));
    }, this);
  }),
  (UTObjectivesRepository.prototype.getCategories = function getCategories() {
    return this._categories.values();
  }),
  (UTObjectivesRepository.prototype.getCategoryById = function getCategoryById(
    e
  ) {
    return this._categories.get(e);
  }),
  (UTObjectivesRepository.prototype.getGroup = function getGroup(e, t) {
    var i = this.getCategoryById(e);
    return i
      ? utils.JS.find(i.getGroups(), function(e) {
          return e.id === t;
        })
      : null;
  }),
  utils.JS.inherits(UTObjectivesService, UTObject),
  (UTObjectivesService.prototype.reset = function reset() {
    this._repository.reset();
  }),
  (UTObjectivesService.prototype.isCampaignCacheExpired = function isCampaignCacheExpired() {
    return this._repository.isCampaignCacheExpired();
  }),
  (UTObjectivesService.prototype.isObjectivesCacheExpired = function isObjectivesCacheExpired() {
    return this._repository.isObjectivesCacheExpired();
  }),
  (UTObjectivesService.prototype.getActiveCampaign = function getActiveCampaign() {
    var n = new UTObservable(),
      o = new transferobjects.ServiceResponse();
    if (
      ((o.data = {
        campaign: null
      }),
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.OBJECTIVES_ENABLED
      ))
    )
      return (
        (o.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), n.notify(o), n
      );
    if (!this.isCampaignCacheExpired())
      return (
        (o.success = !0),
        (o.status = enums.HTTPStatusCode.NOT_MODIFIED),
        (o.data.campaign = this._repository.getActiveCampaign()),
        n.notify(o),
        n
      );
    return (
      this._objectivesDAO
        .getActiveCampaign()
        .observe(this, function _onActiveCampaignRetrieved(e, t) {
          if (
            (e.unobserve(this),
            (o.success = t.success),
            (o.status = t.status),
            o.success)
          ) {
            o.data = t.response;
            var i = Math.round(Date.now() / MS_PER_SECOND) + 600,
              s = Math.min(i, o.data.campaign.endTime);
            this._repository.reset(),
              this._repository.setCampaignCacheTimestamp(
                Math.max(s, Math.round(Date.now() / MS_PER_SECOND + 30))
              ),
              this._repository.setActiveCampaign(o.data.campaign);
          } else this._repository.setCampaignCacheTimestamp(Date.now() / MS_PER_SECOND + 30), o.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED && services.Configuration.setFeatureEnabled(enums.ServerFeature.OBJECTIVES_ENABLED, !1);
          n.notify(o);
        }),
      n
    );
  }),
  (UTObjectivesService.prototype.getCampaignDetails = function getCampaignDetails(
    i
  ) {
    var s = new UTObservable(),
      n = new transferobjects.ServiceResponse();
    n.data = {
      campaign: null
    };
    var o = i === enums.Objectives.CampaignType.ACTIVE,
      a = this._repository.getActiveCampaign();
    if (
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.OBJECTIVES_ENABLED
      )
    )
      return (
        (n.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), s.notify(n), s
      );
    if (!this.isCampaignCacheExpired() && o && a && a.hasLevels())
      return (
        (n.success = !0),
        (n.status = enums.HTTPStatusCode.NOT_MODIFIED),
        (n.data.campaign = a),
        s.notify(n),
        s
      );

    function _onCampaignDetailsRetrieved(e, t) {
      e.unobserve(this),
        (n.success = t.success),
        (n.status = t.status),
        n.success
          ? ((a = this._repository.getActiveCampaign()),
            o && (a.setLevels(t.response.levels), (n.data.campaign = a)))
          : n.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
            services.Configuration.setFeatureEnabled(
              enums.ServerFeature.OBJECTIVES_ENABLED,
              !1
            ),
        s.notify(n);
    }
    return (
      this.isCampaignCacheExpired() && o
        ? this.getActiveCampaign().observe(this, function(e, t) {
            e.unobserve(this),
              this._objectivesDAO
                .getCampaignDetails(i)
                .observe(this, _onCampaignDetailsRetrieved);
          })
        : this._objectivesDAO
            .getCampaignDetails(i)
            .observe(this, _onCampaignDetailsRetrieved),
      s
    );
  }),
  (UTObjectivesService.prototype.getCategories = function getCategories() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    if (
      ((s.data = {
        categories: []
      }),
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.OBJECTIVES_ENABLED
      ))
    )
      return (
        (s.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), i.notify(s), i
      );
    if (
      !this.isObjectivesCacheExpired() &&
      0 < this._repository.getCategories().length
    )
      return (
        (s.success = !0),
        (s.status = enums.HTTPStatusCode.NOT_MODIFIED),
        (s.data.categories = this._repository.getCategories()),
        i.notify(s),
        i
      );
    return (
      this._objectivesDAO
        .getCategories()
        .observe(this, function _onCategoriesRetrieved(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            s.success
              ? ((s.data = t.response),
                this._repository.setObjectivesCacheTimestamp(
                  Math.round(Date.now() / MS_PER_SECOND) + 300
                ),
                this._repository.setCategories(s.data.categories))
              : (this._repository.setObjectivesCacheTimestamp(
                  Date.now() / MS_PER_SECOND + 30
                ),
                s.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
                  services.Configuration.setFeatureEnabled(
                    enums.ServerFeature.OBJECTIVES_ENABLED,
                    !1
                  )),
            i.notify(s);
        }),
      i
    );
  }),
  (UTObjectivesService.prototype.getCategoryById = function getCategoryById(i) {
    var s = new UTObservable(),
      n = new transferobjects.ServiceResponse();
    if (
      ((n.data = {
        category: null
      }),
      !this.isObjectivesCacheExpired())
    ) {
      var e = this._repository.getCategoryById(i);
      if (e)
        return (
          (n.success = !0),
          (n.status = enums.HTTPStatusCode.NOT_MODIFIED),
          (n.data.category = e),
          s.notify(n),
          s
        );
    }
    return (
      this.getCategories().observe(this, function _onCategoriesRetrieved(e, t) {
        e.unobserve(this),
          (n.success = t.success),
          (n.status = t.status),
          n.success && (n.data.category = this._repository.getCategoryById(i)),
          s.notify(n);
      }),
      s
    );
  }),
  (UTObjectivesService.prototype.getGroup = function getGroup(s, n) {
    var o = new UTObservable(),
      a = new transferobjects.ServiceResponse();
    if (
      ((a.data = {
        group: null
      }),
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.OBJECTIVES_ENABLED
      ))
    )
      return (
        (a.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), o.notify(a), o
      );
    if (
      !this.isObjectivesCacheExpired() &&
      utils.JS.isValid(this._repository.getCategoryById(s))
    ) {
      var e = this._repository.getGroup(s, n);
      if (e && e.hasObjectives())
        return (
          (a.success = !0),
          (a.status = enums.HTTPStatusCode.NOT_MODIFIED),
          (a.data.group = e),
          o.notify(a),
          o
        );
    }

    function _onGroupObjectivesRetrieved(e, t) {
      if (
        (e.unobserve(this),
        (a.success = t.success),
        (a.status = t.status),
        a.success)
      ) {
        var i = this._repository.getGroup(s, n);
        utils.JS.isValid(i) &&
          t.response.objectives.forEach(function(e) {
            i.objectives.set(e.id, e);
          }, this),
          (a.data.group = i);
      }
      o.notify(a);
    }
    return (
      this.getCategoryById(s).observe(this, function _onCategoryByIdRetrieved(
        e,
        t
      ) {
        e.unobserve(this),
          t.success
            ? t.data.category.isMilestones()
              ? this._objectivesDAO
                  .getLearningGroupObjectives(s, n)
                  .observe(this, _onGroupObjectivesRetrieved)
              : this._objectivesDAO
                  .getGroupObjectives(s, n)
                  .observe(this, _onGroupObjectivesRetrieved)
            : ((a.success = t.success), (a.status = t.status), o.notify(a));
      }),
      o
    );
  }),
  (UTObjectivesService.prototype.claimLevelReward = function claimLevelReward(
    n,
    e
  ) {
    var o = new UTObservable(),
      a = new transferobjects.ServiceResponse();
    if (
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.OBJECTIVES_ENABLED
      )
    )
      return (
        (a.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), o.notify(a), o
      );
    return (
      this._objectivesDAO
        .redeemCampaignLevelReward(n, e)
        .observe(this, function _onLevelRewardClaimed(e, t) {
          if (
            (e.unobserve(this),
            (a.success = t.success),
            (a.status = t.status),
            (a.data = {
              rewards: t.response.rewards
            }),
            a.success)
          ) {
            var i = this._repository.getActiveCampaign();
            if (i) {
              i.remainingRewards--;
              var s = i.levels.get(n);
              s.setState(enums.Objectives.LevelState.REWARDED),
                (a.data.level = s);
            }
          }
          o.notify(a);
        }),
      o
    );
  }),
  (UTObjectivesService.prototype.claimGroupReward = function claimGroupReward(
    s,
    n,
    e
  ) {
    var o = new UTObservable(),
      a = new transferobjects.ServiceResponse();
    if (
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.OBJECTIVES_ENABLED
      )
    )
      return (
        (a.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), o.notify(a), o
      );

    function _onGroupRewardClaimed(e, t) {
      if (
        (e.unobserve(this),
        (a.success = t.success),
        (a.status = t.status),
        (a.data = {
          rewards: t.response.rewards
        }),
        a.success)
      ) {
        var i = this._repository.getGroup(s, n);
        i.setState(enums.Objectives.GroupState.REWARDED), (a.data.group = i);
      }
      o.notify(a);
    }
    return (
      e
        ? this._objectivesDAO
            .redeemLearningGroupReward(n)
            .observe(this, _onGroupRewardClaimed)
        : this._objectivesDAO
            .redeemGroupReward(n)
            .observe(this, _onGroupRewardClaimed),
      o
    );
  }),
  (UTObjectivesService.prototype.claimObjectiveReward = function claimObjectiveReward(
    s,
    n,
    o,
    e
  ) {
    var a = new UTObservable(),
      r = new transferobjects.ServiceResponse();
    if (
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.OBJECTIVES_ENABLED
      )
    )
      return (
        (r.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), a.notify(r), a
      );

    function _onObjectiveRewardClaimed(e, t) {
      if (
        (e.unobserve(this),
        (r.success = t.success),
        (r.status = t.status),
        (r.data = {
          rewards: t.response.rewards
        }),
        r.success)
      ) {
        var i = this._repository.getGroup(s, n).objectives.get(o);
        i.setState(enums.Objectives.State.REDEEMED), (r.data.objective = i);
      }
      a.notify(r);
    }
    return (
      e
        ? this._objectivesDAO
            .redeemLearningObjectiveReward(n, o)
            .observe(this, _onObjectiveRewardClaimed)
        : this._objectivesDAO
            .redeemObjectiveReward(n, o)
            .observe(this, _onObjectiveRewardClaimed),
      a
    );
  }),
  (UTObjectivesService.prototype.claimExpiredRewards = function claimExpiredRewards() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    if (
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.OBJECTIVES_ENABLED
      )
    )
      return (
        (s.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), i.notify(s), i
      );
    return (
      this._objectivesDAO
        .redeemExpiredRewards()
        .observe(this, function _onExpiredRewardsClaimed(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            (s.data = {
              rewards: t.response.rewards
            }),
            s.success && this.reset(),
            i.notify(s);
        }),
      i
    );
  }),
  (UTObjectivesService.prototype.update = function update(update) {
    if (utils.JS.isValid(update) && update instanceof UTCampaignUpdatesDTO) {
      if (0 < update.autoRedeemedXp)
        (this._repository.getActiveCampaign().xp += update.autoRedeemedXp),
          services.Notification.queue([
            services.Localization.localize('notification.xp.added'),
            enums.UINotificationType.POSITIVE
          ]);
      0 < update.entries.length &&
        (update.entries.forEach(function(e) {
          -1 === this._updateGroupIds.indexOf(e.groupId) &&
            this._updateGroupIds.push(e.groupId);
        }, this),
        this._triggerUpdates(update.entries));
    }
  }),
  (UTObjectivesService.prototype._triggerUpdates = function _triggerUpdates(e) {
    var o = e.slice(),
      a = o.shift();
    this.getGroup(a.categoryId, a.groupId).observe(
      this,
      function _onGroupRetrieved(e, t) {
        if ((e.unobserve(this), t.success)) {
          var i = t.data.group,
            s = i.objectives.get(a.objectiveId);
          s &&
            (s.setState(a.objectiveState),
            s.setCurrentProgress(a.objectiveProgress),
            (s.isClaimable() || s.isRedeemed()) &&
              getDefaultDispatcher().notify(
                enums.Notification.OBJECTIVE_COMPLETE,
                this,
                {
                  name: s.title
                }
              ));
          var n = this._updateGroupIds.indexOf(a.groupId);
          -1 < n &&
            (this._updateGroupIds.splice(n, 1),
            i.setState(a.groupState),
            (i.isClaimable() || i.isRedeemed()) &&
              getDefaultDispatcher().notify(
                enums.Notification.OBJECTIVE_GROUP_COMPLETE,
                this,
                {
                  name: i.title
                }
              ));
        }
        0 < o.length &&
          ((a = o.shift()),
          this.getGroup(a.categoryId, a.groupId).observe(
            this,
            _onGroupRetrieved
          ));
      }
    );
  }),
  utils.JS.inherits(UTSBCRepository, UTObject),
  (UTSBCRepository.CATEGORIES = {
    ALL: 'All',
    FAVOURITE: 'Favourite'
  }),
  (UTSBCRepository.prototype.reset = function reset() {
    this.sets.clear(), this.categories.clear(), (this._cacheExpiration = 0);
  }),
  (UTSBCRepository.prototype.setCacheTimestamp = function setCacheTimestamp(e) {
    this._cacheExpiration = e;
  }),
  (UTSBCRepository.prototype.isCacheExpired = function isCacheExpired() {
    return (
      0 === this._cacheExpiration ||
      this._cacheExpiration < Math.round(Date.now() / 1e3)
    );
  }),
  (UTSBCRepository.prototype.setCategories = function setCategories(e) {
    e.forEach(function(e) {
      this.categories.set(e.id, e);
    }, this);
    var t = new transferobjects.SBCCategory(
      -2,
      -2,
      services.Localization.localize('sbc.categories.all'),
      enums.SBC.CATEGORY_TYPE.CUSTOM_ALL
    );
    this.categories.set(UTSBCRepository.CATEGORIES.ALL, t);
    var i = new transferobjects.SBCCategory(
      -1,
      -1,
      services.Localization.localize('sbc.categories.favourites'),
      enums.SBC.CATEGORY_TYPE.CUSTOM_FAVOURITE
    );
    this.categories.set(UTSBCRepository.CATEGORIES.FAVOURITE, i);
  }),
  (UTSBCRepository.prototype.setSBCSets = function setSBCSets(e) {
    var t = this.categories.get(UTSBCRepository.CATEGORIES.ALL),
      i = this.categories.get(UTSBCRepository.CATEGORIES.FAVOURITE);
    (t.setIds = []),
      (i.setIds = []),
      e.forEach(function(e) {
        this.sets.set(e.id, e),
          t.setIds.push(e.id),
          e.isFavourite && !e.isComplete() && i.setIds.push(e.id);
      }, this);
  }),
  (UTSBCRepository.prototype.tagFavouriteSet = function tagFavouriteSet(e, t) {
    var i = this.categories.get(UTSBCRepository.CATEGORIES.FAVOURITE).setIds;
    if (t) i.push(e);
    else {
      var s = i.indexOf(e);
      0 <= s && i.splice(s, 1);
    }
  }),
  (UTSBCRepository.prototype.getCategories = function getCategories() {
    this.categories.forEach(function(e) {
      var t;
      for (e.displayable = !1, t = 0; t < e.setIds.length; t++)
        if (this.sets.get(e.setIds[t]).isDisplayable()) {
          e.displayable = !0;
          break;
        }
    }, this);
    var e = this.categories.get(UTSBCRepository.CATEGORIES.FAVOURITE);
    return (
      e && (e.displayable = !0),
      this.categories.values().sort(function categorySort(e, t) {
        return e.priority < t.priority ? -1 : e.priority > t.priority ? 1 : 0;
      })
    );
  }),
  (UTSBCRepository.prototype.getSets = function getSets() {
    return this.sets.values();
  }),
  (UTSBCRepository.prototype.getSetById = function getSetById(e) {
    return this.sets.get(e);
  }),
  utils.JS.inherits(UTSBCService, UTObject),
  (UTSBCService.prototype.reset = function reset() {
    this._repository.reset();
  }),
  (UTSBCService.prototype.isCacheExpired = function isCacheExpired() {
    return this._repository.isCacheExpired();
  }),
  (UTSBCService.prototype.getCachedSBCSquads = function getCachedSBCSquads() {
    return this._repository.getSets().reduce(function(t, e) {
      return (
        0 < e.challenges.length &&
          e.challenges.forEach(function(e) {
            e.squad && t.push(e.squad);
          }, this),
        t
      );
    }, []);
  }),
  (UTSBCService.prototype.requestSets = function requestSets() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    if (
      ((s.data = {
        categories: [],
        sets: []
      }),
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.SBC_ENABLED
      ))
    )
      return (
        (s.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), i.notify(s), i
      );
    if (!this.isCacheExpired())
      return (
        (s.success = !0),
        (s.status = enums.HTTPStatusCode.NOT_MODIFIED),
        (s.data.categories = this._repository.getCategories()),
        (s.data.sets = this._repository.getSets()),
        i.notify(s),
        i
      );
    return (
      this._sbcDAO
        .getSets()
        .observe(this, function _onRequestSetsComplete(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            t.success
              ? (this._repository.setCategories(t.response.categories),
                this._repository.setSBCSets(t.response.sets),
                this._repository.setCacheTimestamp(
                  Math.round(Date.now() / MS_PER_SECOND) + 300
                ))
              : s.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
                services.Configuration.setFeatureEnabled(
                  enums.ServerFeature.SBC_ENABLED,
                  !1
                ),
            (s.data = {
              categories: this._repository.getCategories(),
              sets: this._repository.getSets()
            }),
            i.notify(s);
        }),
      i
    );
  }),
  (UTSBCService.prototype.requestChallengesForSet = function requestChallengesForSet(
    s
  ) {
    var n = new UTObservable(),
      o = new transferobjects.ServiceResponse();
    if (
      ((o.data = {
        challenges: []
      }),
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.SBC_ENABLED
      ))
    )
      return (
        (o.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), n.notify(o), n
      );
    var e = s.challenges.values();
    if (0 < e.length && !this.isCacheExpired())
      return (
        (o.success = !0),
        (o.status = enums.HTTPStatusCode.NOT_MODIFIED),
        (o.data.challenges = e),
        n.notify(o),
        n
      );
    return (
      this._sbcDAO
        .getChallengesForSet(s)
        .observe(this, function _onRequestChallengesComplete(e, t) {
          if (
            (e.unobserve(this),
            (o.success = t.success),
            (o.status = t.status),
            (o.data.challenges = t.response.challenges),
            t.success)
          ) {
            var i = this._repository.getSetById(s.id);
            i.challenges.clear(),
              o.data.challenges.forEach(function(e) {
                i.addChallenge(e);
              }, this);
          } else
            o.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
              services.Configuration.setFeatureEnabled(
                enums.ServerFeature.SBC_ENABLED,
                !1
              );
          n.notify(o);
        }),
      n
    );
  }),
  (UTSBCService.prototype.loadChallenge = function loadChallenge(s) {
    var n = new UTObservable(),
      o = new transferobjects.ServiceResponse();
    if (
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.SBC_ENABLED
      )
    )
      return (
        (o.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), n.notify(o), n
      );
    return (
      this._sbcDAO
        .loadChallenge(s.id, s.isInProgress())
        .observe(this, function _onLoadChallengeComplete(e, t) {
          if (
            (e.unobserve(this),
            (o.success = t.success),
            (o.status = t.status),
            (o.data = t.response),
            o.success)
          ) {
            (s.squad = t.response.squad), s.squad.setSaveDelegate(s);
            var i = {
              squad: s.squad
            };
            s.hasNotStarted() &&
              ((s.status = enums.SBC.CHALLENGE_STATUS.IN_PROGRESS),
              (i.status = s.status)),
              s.onDataChange.notify(i);
          } else o.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED && services.Configuration.setFeatureEnabled(enums.ServerFeature.SBC_ENABLED, !1);
          n.notify(o);
        }),
      n
    );
  }),
  (UTSBCService.prototype.saveChallenge = function saveChallenge(i) {
    var s = new UTObservable(),
      n = new transferobjects.ServiceResponse();
    if (
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.SBC_ENABLED
      )
    )
      return (
        (n.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), s.notify(n), s
      );
    return (
      this._sbcDAO
        .saveChallenge(i.id, i.squad)
        .observe(this, function _onSaveChallengeComplete(e, t) {
          e.unobserve(this),
            (n.success = t.success),
            (n.status = t.status),
            (n.data = t.response),
            n.success
              ? i.onSave.notify()
              : n.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
                services.Configuration.setFeatureEnabled(
                  enums.ServerFeature.SBC_ENABLED,
                  !1
                ),
            s.notify(n);
        }),
      s
    );
  }),
  (UTSBCService.prototype.submitChallenge = function submitChallenge(s, n, i) {
    var o = new UTObservable(),
      a = new transferobjects.ServiceResponse();
    if (
      ((a.data = {
        objectiveUpdates: null,
        itemViolations: [],
        setCompleted: !1
      }),
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.SBC_ENABLED
      ))
    )
      return (
        (a.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), o.notify(a), o
      );
    var r = s.squad;

    function _onSubmitChallengeComplete(e, t) {
      if (
        (e.unobserve(this),
        (a.success = t.success),
        (a.status = t.status),
        (a.data = t.response),
        a.success)
      ) {
        s.timesCompleted++,
          (s.status = enums.SBC.CHALLENGE_STATUS.COMPLETED),
          s.onDataChange.notify({
            status: s.status,
            timesCompleted: s.timesCompleted
          }),
          n.challengesCompletedCount++,
          (a.data.setCompleted = n.isComplete()),
          a.data.setCompleted &&
            (n.timesCompleted++,
            n.repeatable
              ? ((n.challengesCompletedCount = 0),
                n.challenges.forEach(function(e) {
                  e.reset();
                }, this))
              : n.isFavourite && this.toggleFavouriteTag(n));
        var i = r.getFieldPlayers().map(function(e) {
          return e.getItem();
        });
        repositories.Item.remove(i),
          services.Squad.resetSquadsCache(),
          services.Objectives.update(t.response.objectiveUpdates),
          n &&
            n.repeatable &&
            1 === n.timesCompleted &&
            this._repository.reset();
      }
      o.notify(a);
    }
    return (
      this.saveChallenge(s).observe(this, function(e, t) {
        e.unobserve(this),
          t.success &&
            this._sbcDAO
              .submitChallenge(s.id, !!i)
              .observe(this, _onSubmitChallengeComplete);
      }),
      o
    );
  }),
  (UTSBCService.prototype.toggleFavouriteTag = function toggleFavouriteTag(i) {
    var s = new UTObservable(),
      n = new transferobjects.ServiceResponse();
    if (!(i instanceof entities.SBCSet))
      return (
        utils.Debug.Assert(
          !1,
          'Expected a valid SBC set entity when attempting to toggle favourite state.'
        ),
        (n.status = enums.HTTPStatusCode.BAD_REQUEST),
        (n.data = {
          setId: 0,
          isFavourite: !1
        }),
        s.notify(n),
        s
      );
    return (
      this._sbcDAO
        .setFavouriteTag(i, !i.isFavourite)
        .observe(this, function _onSetFavouriteTagComplete(e, t) {
          e.unobserve(this),
            t.success
              ? ((i.isFavourite = !i.isFavourite),
                this._repository.tagFavouriteSet(i.id, i.isFavourite))
              : t.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
                services.Configuration.setFeatureEnabled(
                  enums.ServerFeature.SBC_ENABLED,
                  !1
                ),
            (n.success = t.success),
            (n.status = t.status),
            (n.data = {
              setId: i.id,
              isFavourite: i.isFavourite
            }),
            s.notify(n);
        }),
      s
    );
  }),
  (UTSBCService.prototype.toggleFavouriteTagById = function toggleFavouriteTagById(
    e
  ) {
    return this.toggleFavouriteTag(this._repository.getSetById(e));
  }),
  utils.JS.inherits(UTTOTWSquadRepository, UTObject),
  (UTTOTWSquadRepository.prototype.reset = function reset() {
    (this._cacheTimestamp = 0), this._squadCollection.resetCollection([]);
  }),
  (UTTOTWSquadRepository.prototype.setSquadList = function setSquadList(e) {
    this._squadCollection.resetCollection(e);
  }),
  (UTTOTWSquadRepository.prototype.getSquadList = function getSquadList() {
    return this._squadCollection.values();
  }),
  (UTTOTWSquadRepository.prototype.isCacheExpired = function isCacheExpired() {
    return this._cacheTimestamp < Date.now();
  }),
  (UTTOTWSquadRepository.prototype.setCacheTimestamp = function setCacheTimestamp(
    e,
    t
  ) {
    this._cacheTimestamp =
      e + (utils.JS.isNumber(t) ? t * MS_PER_SECOND : 36e6);
  }),
  utils.JS.inherits(UTSquadService, UTObject),
  (UTSquadService.prototype.reset = function reset() {
    (this._activeSquad = 0),
      repositories.Squad.reset(),
      this._totwRepository.reset();
  }),
  (UTSquadService.prototype.resetSquadsCache = function resetSquadsCache() {
    repositories.Squad.setDirty();
  }),
  (UTSquadService.prototype.getMaxSquads = function getMaxSquads() {
    return this._maxSquads;
  }),
  (UTSquadService.prototype.setMaxSquads = function setMaxSquads(e) {
    this._maxSquads = e;
  }),
  (UTSquadService.prototype.getActiveSquadId = function getActiveSquadId() {
    return this._activeSquad;
  }),
  (UTSquadService.prototype.setActiveSquadId = function setActiveSquadId(t) {
    repositories.Squad.getSquads(
      services.User.getUser().selectedPersona
    ).forEach(function(e) {
      e.setActive(e.getId() === t);
    }),
      (this._activeSquad = t);
  }),
  (UTSquadService.prototype.hasExternalShowOffSquad = function hasExternalShowOffSquad() {
    return !utils.JS.isEmpty(this.unauthenticatedShowOffId);
  }),
  (UTSquadService.prototype.create = function create(e, t, i, s) {
    var n = new UTObservable(),
      o = new transferobjects.ServiceResponse();
    return (
      this._squadDAO
        .create(e, t, i, s)
        .observe(this, function _onSquadCreateComplete(e, t) {
          if (
            (e.unobserve(this),
            (o.status = t.status),
            (o.success = t.success),
            (o.data = {
              squad: t.response.squad
            }),
            t.success)
          ) {
            var i = services.User.getUser().selectedPersona,
              s = t.response.squad;
            repositories.Squad.set(i, s),
              s.setCacheTimestamp(0),
              getDefaultDispatcher().notify(
                enums.Notification.SQUAD_CREATE,
                this,
                o.data
              );
          }
          n.notify(o);
        }),
      n
    );
  }),
  (UTSquadService.prototype.copy = function copy(e, t) {
    var n = new UTObservable(),
      o = new transferobjects.ServiceResponse();
    return (
      this._squadDAO
        .copy(e, t)
        .observe(this, function _onSquadCopyComplete(e, t) {
          if (
            (e.unobserve(this),
            (o.status = t.status),
            (o.success = t.success),
            (o.data = {
              squad: t.response.squad
            }),
            t.success)
          ) {
            var i = services.User.getUser().selectedPersona,
              s = t.response.squad;
            repositories.Squad.set(i, s),
              s.setCacheTimestamp(0),
              getDefaultDispatcher().notify(
                enums.Notification.SQUAD_CREATE,
                this,
                o.data
              );
          }
          n.notify(o);
        }),
      n
    );
  }),
  (UTSquadService.prototype.duplicate = function duplicate(o) {
    var i = new UTObservable();

    function _onCreateDuplicateComplete(e, t) {
      e.unobserve(this), i.notify(t);
    }
    return (
      services.Squad.requestSquadList().observe(this, function(e, t) {
        e.unobserve(this);
        var i = t.data.squads,
          s = o.getPlayers().map(function(e) {
            return e.getItem();
          }),
          n = o.getName();
        (n = utils.TextUtils.squadNameExists(n, i)
          ? utils.TextUtils.createSquadNameCopy(n, i)
          : n),
          this.create(n, o.getFormation().getName(), s, !0).observe(
            this,
            _onCreateDuplicateComplete
          );
      }),
      i
    );
  }),
  (UTSquadService.prototype.rename = function rename(i, s) {
    var n = new UTObservable(),
      o = new transferobjects.ServiceResponse();

    function _onGetSquad(e, t) {
      e.unobserve(this),
        t.success && t.data.squad.setName(s, []),
        (o.data = {
          squad: t.success ? t.data.squad : null
        }),
        n.notify(o),
        getDefaultDispatcher().notify(
          enums.Notification.SQUAD_SAVE,
          this,
          t.data.squad
        );
    }
    return (
      this._squadDAO
        .rename(i, s)
        .observe(this, function _onSquadRenameComplete(e, t) {
          e.unobserve(this),
            (o.status = t.status),
            (o.success = t.success),
            t.success
              ? this.requestSquadById(i).observe(this, _onGetSquad)
              : n.notify(o);
        }),
      n
    );
  }),
  (UTSquadService.prototype.remove = function remove(s) {
    var n = new UTObservable(),
      o = new transferobjects.ServiceResponse();
    return (
      this._squadDAO
        .remove(s)
        .observe(this, function _onSquadRemoveComplete(e, t) {
          if (
            (e.unobserve(this),
            (o.success = t.success),
            (o.status = t.status),
            (o.data = {
              id: s
            }),
            t.success)
          ) {
            var i = services.User.getUser().selectedPersona;
            repositories.Squad.removeSquad(i, s),
              repositories.Squad.setDirty(),
              n.notify(o),
              getDefaultDispatcher().notify(
                enums.Notification.SQUAD_DELETE,
                this,
                o
              );
          } else n.notify(o);
        }),
      n
    );
  }),
  (UTSquadService.prototype.addShowOff = function addShowOff(n) {
    var o = new UTObservable(),
      a = new transferobjects.ServiceResponse();

    function _onCreateShowOffSquadComplete(e, s) {
      e.unobserve(this),
        (a.success = s.success),
        (a.status = s.status),
        s.success
          ? this.requestSquadById(n).observe(this, function(e, t) {
              if ((e.unobserve(this), t)) {
                var i = new transferobjects.ShowOffSquad(
                  t.data.squad,
                  s.response
                );
                a.data = {
                  url:
                    i.url +
                    ':' +
                    services.User.getUser().getSelectedPersona().sku
                };
              }
              o.notify(a);
            })
          : o.notify(a);
    }

    function _onDeleteShowOffSquadComplete(e, t) {
      e.unobserve(this),
        t.success
          ? this._squadDAO
              .createShowOffSquad(n)
              .observe(this, _onCreateShowOffSquadComplete)
          : ((a.status = t.status), o.notify(a));
    }
    return (
      this._squadDAO
        .getShowOffSquads()
        .observe(this, function _onGetShowOffSquadsComplete(e, t) {
          if ((e.unobserve(this), t.success))
            if (10 <= t.response.showOffSquads.length) {
              var i = t.response.showOffSquads.map(function(e) {
                return e.id;
              });
              this.deleteShowOff(Math.min.apply(Math, i)).observe(
                this,
                _onDeleteShowOffSquadComplete
              );
            } else
              this._squadDAO
                .createShowOffSquad(n)
                .observe(this, _onCreateShowOffSquadComplete);
          else (a.status = t.status), o.notify(a);
        }),
      o
    );
  }),
  (UTSquadService.prototype.deleteShowOff = function deleteShowOff(e) {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      this._squadDAO
        .deleteShowOffSquad(e)
        .observe(this, function _onDeleteShowOffSquadComplete(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            i.notify(s);
        }),
      i
    );
  }),
  (UTSquadService.prototype.loadShowOffSquad = function loadShowOffSquad() {
    var n = new UTObservable(),
      o = new transferobjects.ServiceResponse(),
      e = decodeURIComponent(this.unauthenticatedShowOffId).split(':');
    if (
      ((o.data = {
        showOff: null
      }),
      !this.hasExternalShowOffSquad() || 2 !== e.length)
    )
      return (o.status = enums.HTTPStatusCode.BAD_REQUEST), n.notify(o), n;
    var t = e[0],
      a = e[1],
      i = services.Authentication.getServerShardBySKU(a);

    function _onGetShowOffSquadComplete(e, t) {
      e.unobserve(this),
        (this.unauthenticatedShowOffId = ''),
        (o.success = t.success),
        (o.status = t.status),
        (o.data = {
          showOff: t.response.showOff
        }),
        n.notify(o);
    }

    function _getShowOffSquad(e) {
      this._squadDAO
        .getShowOffSquad(e, t)
        .observe(this, _onGetShowOffSquadComplete);
    }
    return (
      utils.JS.isValid(i)
        ? _getShowOffSquad.call(this, i)
        : services.Authentication.requestServerShards().observe(
            this,
            function _onRequestServerShardsComplete(e, t) {
              if ((e.unobserve(this), t.success && 0 < t.data.shards.length)) {
                for (var i in t.data.shards) {
                  var s = t.data.shards[i];
                  if (s.supportsSKU(a))
                    return void _getShowOffSquad.call(this, s);
                }
                (this.unauthenticatedShowOffId = ''), n.notify(o);
              } else
                (this.unauthenticatedShowOffId = ''),
                  (o.status = t.status),
                  n.notify(o);
            }
          ),
      n
    );
  }),
  (UTSquadService.prototype.setActiveSquad = function setActiveSquad(e) {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      this._squadDAO
        .getSquadById(e, -1)
        .observe(this, function _onSetActiveComplete(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            t.success && this.setActiveSquadId(t.response.squad.getId()),
            i.notify(s);
        }),
      i
    );
  }),
  (UTSquadService.prototype.requestSquadById = function requestSquadById(e, s) {
    s = utils.JS.isNumber(s) ? s : services.User.getUser().selectedPersona;
    var n = new UTObservable(),
      o = new transferobjects.ServiceResponse(),
      t = repositories.Squad.getSquadById(s, e);
    return (
      utils.JS.isValid(t) && !t.isCacheExpired()
        ? ((o.success = !0),
          (o.status = enums.HTTPStatusCode.NOT_MODIFIED),
          (o.data = {
            squad: t
          }),
          n.notify(o))
        : this._squadDAO
            .getSquadById(e, s)
            .observe(this, function _onRequestSquadComplete(e, t) {
              if (
                (e.unobserve(this),
                (o.success = t.success),
                (o.status = t.status),
                t.success)
              ) {
                utils.Debug.Assert(
                  utils.JS.isValid(t.response.squad),
                  'Expected a squad entity.'
                ),
                  repositories.Squad.set(s, t.response.squad),
                  s <= 0 && this.setActiveSquadId(t.response.squad.getId());
                var i = repositories.Squad.getSquadById(
                  s,
                  t.response.squad.getId()
                );
                i.setCacheTimestamp(Date.now()),
                  (o.data = {
                    squad: i
                  });
              } else
                o.data = {
                  squad: null
                };
              n.notify(o);
            }),
      n
    );
  }),
  (UTSquadService.prototype.requestSquadByType = function requestSquadByType(
    e
  ) {
    var s = new UTObservable(),
      n = new transferobjects.ServiceResponse(),
      o = services.User.getUser().selectedPersona;
    if (e === enums.UserSquadId.ACTIVE) {
      var t = repositories.Squad.getSquadById(o, this._activeSquad);
      utils.JS.isValid(t) && !t.isCacheExpired()
        ? ((n.success = !0),
          (n.status = enums.HTTPStatusCode.NOT_MODIFIED),
          (n.data = {
            squad: t
          }),
          s.notify(n))
        : this._squadDAO
            .getSquadByType(e)
            .observe(this, function _onGetSquadComplete(e, t) {
              if (
                (e.unobserve(this),
                (n.success = t.success),
                (n.status = t.status),
                t.success)
              ) {
                utils.Debug.Assert(
                  utils.JS.isValid(t.response.squad),
                  'Expected a squad entity.'
                ),
                  repositories.Squad.set(o, t.response.squad);
                var i = repositories.Squad.getSquadById(
                  o,
                  t.response.squad.getId()
                );
                repositories.Squad.getSquadById(
                  o,
                  t.response.squad.getId()
                ).setCacheTimestamp(Date.now()),
                  (n.data = {
                    squad: i
                  });
              } else
                n.data = {
                  squad: null
                };
              s.notify(n);
            });
    } else (n.status = enums.HTTPStatusCode.BAD_REQUEST), s.notify(n);
    return s;
  }),
  (UTSquadService.prototype.requestSquadList = function requestSquadList() {
    var s = new UTObservable(),
      n = new transferobjects.ServiceResponse(),
      o = services.User.getUser().selectedPersona;
    if (!repositories.Squad.isSquadListCacheExpired()) {
      var e = repositories.Squad.getSquads(o);
      return (
        (n.success = !0),
        (n.status = enums.HTTPStatusCode.NOT_MODIFIED),
        (n.data = {
          activeSquadId: this._activeSquad,
          listFull: e.length >= this._maxSquads,
          squads: e
        }),
        s.notify(n),
        s
      );
    }
    return (
      this._squadDAO
        .getSquadList()
        .observe(this, function _onGetSquadListComplete(e, t) {
          e.unobserve(this),
            (n.success = t.success),
            (n.status = t.status),
            t.success &&
              (repositories.Squad.removeSquads(o),
              t.response.squads.forEach(function(e) {
                repositories.Squad.set(o, e);
              }),
              repositories.Squad.setSquadListCacheTimestamp(
                Date.now(),
                0 < t.maxAge ? t.maxAge : null
              ),
              this.setActiveSquadId(t.response.activeSquadId));
          var i = repositories.Squad.getSquads(o);
          (n.data = {
            activeSquadId: this._activeSquad,
            listFull: i.length >= this._maxSquads,
            squads: i
          }),
            s.notify(n);
        }),
      s
    );
  }),
  (UTSquadService.prototype.requestTOTWHistory = function requestTOTWHistory() {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    return (
      this._totwRepository.isCacheExpired()
        ? this._squadDAO
            .getTOTWHistory(0, 90)
            .observe(this, function _onGetTOTWHistoryComplete(e, t) {
              e.unobserve(this),
                (s.success = t.success),
                (s.status = t.status),
                t.success &&
                  (services.Configuration.setFeatureEnabled(
                    enums.ServerFeature.TOTW_HISTORY_ENABLED,
                    !0
                  ),
                  (s.data = {
                    squads: t.response.squads,
                    hasNext: t.response.hasNext,
                    hasPrev: t.response.hasPrev
                  }),
                  this._totwRepository.setSquadList(t.response.squads),
                  this._totwRepository.setCacheTimestamp(
                    Date.now(),
                    0 < t.maxAge ? t.maxAge : null
                  )),
                i.notify(s);
            })
        : ((s.success = !0),
          (s.status = enums.HTTPStatusCode.NOT_MODIFIED),
          (s.data = {
            squads: this._totwRepository.getSquadList(),
            hasNext: !1,
            hasPrev: !1
          }),
          i.notify(s)),
      i
    );
  }),
  (UTSquadService.prototype.removeItemsFromSquads = function removeItemsFromSquads(
    i
  ) {
    function _removeItemFromSquad(e, t) {
      (t.isPlayer() || t.isManager()) &&
        e.forEach(function(e) {
          e.containsItem(t, !0) && e.removeItem(t);
        }, this);
    }
    this.requestSquadList().observe(this, function(e, t) {
      e.unobserve(this),
        Array.isArray(i)
          ? i.forEach(function(e) {
              _removeItemFromSquad.call(this, t.data.squads, e);
            }, this)
          : _removeItemFromSquad.call(this, t.data.squads, i);
    });
  }),
  utils.JS.inherits(UTStoreService, UTObject),
  (UTStoreService.prototype.reset = function reset() {}),
  (UTStoreService.prototype.getPacks = function getPacks(e, t) {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    if (
      ((s.data = {
        packs: []
      }),
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.STORE_ENABLED
      ))
    )
      return (
        (s.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), i.notify(s), i
      );
    return (
      this._storeDAO
        .getPacks(e, t)
        .observe(this, function _onPacksRetrieved(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            s.success
              ? (s.data = t.response)
              : s.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
                services.Configuration.setFeatureEnabled(
                  enums.ServerFeature.STORE_ENABLED,
                  !1
                ),
            i.notify(s);
        }),
      i
    );
  }),
  (UTStoreService.prototype.openPack = function openPack(e) {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    if (
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.STORE_ENABLED
      )
    )
      return (
        (s.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), i.notify(s), i
      );
    if (!e.isMyPack)
      return (s.status = enums.HTTPStatusCode.BAD_REQUEST), i.notify(s), i;
    return (
      this._storeDAO.openPack(e.id).observe(this, function _onPackOpened(e, t) {
        e.unobserve(this),
          (s.success = t.success),
          (s.status = t.status),
          s.success
            ? (s.data = t.response)
            : s.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
              services.Configuration.setFeatureEnabled(
                enums.ServerFeature.STORE_ENABLED,
                !1
              ),
          i.notify(s);
      }),
      i
    );
  }),
  (UTStoreService.prototype.purchasePack = function purchasePack(e, t) {
    var i = new UTObservable(),
      s = new transferobjects.ServiceResponse();
    if (
      !services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.STORE_ENABLED
      )
    )
      return (
        (s.status = enums.HTTPStatusCode.SERVICE_IS_DISABLED), i.notify(s), i
      );
    if (e.isMyPack)
      return (s.status = enums.HTTPStatusCode.BAD_REQUEST), i.notify(s), i;
    return (
      this._storeDAO
        .openPack(e.id, t)
        .observe(this, function _onPackOpened(e, t) {
          e.unobserve(this),
            (s.success = t.success),
            (s.status = t.status),
            s.success
              ? (s.data = t.response)
              : s.status === enums.HTTPStatusCode.SERVICE_IS_DISABLED &&
                services.Configuration.setFeatureEnabled(
                  enums.ServerFeature.STORE_ENABLED,
                  !1
                ),
            i.notify(s);
        }),
      i
    );
  }),
  NamespaceManager.Register('services'),
  (services.UTUtasRequestQueue = (function() {
    function UTUtasRequestQueueService() {
      (this._numOfCurrentRequests = 0),
        Object.defineProperty(this, '_numOfCurrentRequests', {
          writable: !0,
          enumerable: !1
        }),
        (this._queue = []),
        Object.defineProperty(this, '_queue', {
          writable: !1,
          enumerable: !1
        });
    }
    return (
      (UTUtasRequestQueueService.prototype.send = function send(e) {
        e instanceof UTUtasHttpRequest
          ? (this._queue.push(e),
            this._numOfCurrentRequests <
              this._getMaxNumOfConcurrentRequests() && this._handleQueue())
          : utils.Debug.Assert(
              !1,
              'UTUtasRequestQueueService should only receive UTAS HTTP requests.'
            );
      }),
      (UTUtasRequestQueueService.prototype._getMaxNumOfConcurrentRequests = function _getMaxNumOfConcurrentRequests() {
        return (
          services.Configuration.getFeatureSetting(
            enums.ServerFeature.MAX_CONCURRENT_REQUESTS
          ) || 5
        );
      }),
      (UTUtasRequestQueueService.prototype._handleQueue = function _handleQueue() {
        if (0 < this._queue.length) {
          var e = this._queue.shift();
          e.observe(this, this._onRequestFinished),
            e.send(),
            this._numOfCurrentRequests++;
        }
      }),
      (UTUtasRequestQueueService.prototype._onRequestFinished = function _onRequestFinished(
        e
      ) {
        e.unobserve(this), this._numOfCurrentRequests--, this._handleQueue();
      }),
      new UTUtasRequestQueueService()
    );
  })()),
  NamespaceManager.Register('valueobjects'),
  (valueobjects.NetworkErrorVO = function(e, t, i, s) {
    (this._code = e), (this._level = t), (this._title = i), (this._message = s);
  }),
  (valueobjects.NetworkErrorVO.prototype.getMessage = function() {
    return this._message;
  }),
  (valueobjects.NetworkErrorVO.prototype.getTitle = function() {
    return this._title;
  }),
  (valueobjects.NetworkErrorVO.prototype.getCode = function() {
    return this._code;
  }),
  (valueobjects.NetworkErrorVO.prototype.getErrorLevel = function() {
    return this._level;
  }),
  (valueobjects.NetworkErrorVO.prototype.isCritical = function() {
    return this._level === enums.NetworkErrorLevel.CRITICAL;
  }),
  (valueobjects.NetworkErrorVO.prototype.isImportant = function() {
    return this._level === enums.NetworkErrorLevel.IMPORTANT;
  }),
  (valueobjects.NetworkErrorVO.prototype.isUnimportant = function() {
    return this._level === enums.NetworkErrorLevel.UNIMPORTANT;
  });
var NetworkErrorManager = {
  queue: [],
  handlingError: !(valueobjects.NetworkErrorVO.prototype.isCodeValid = function() {
    return 0 < this._code;
  })
};

function UTTargetActionView() {
  UTView.call(this), (this._targets = new UTHashTable());
}

function UTControl() {
  UTTargetActionView.call(this);
}

function UTButtonControl() {
  UTControl.call(this);
}

function UTGroupButtonControl() {
  UTButtonControl.call(this);
}

function UTModalContainerView() {
  UTTargetActionView.call(this), this._generate();
}

function UTPresentationController() {
  UTObject.call(this),
    (this._presentingViewController = null),
    Object.defineProperty(this, '_presentingViewController', {
      writable: !0,
      enumerable: !1
    }),
    (this._presentedViewController = null),
    Object.defineProperty(this, '_presentedViewController', {
      writable: !0,
      enumerable: !1
    }),
    (this._presentedView = null),
    (this._isPresenting = !1);
}

function UTViewController() {
  UTResponder.call(this),
    (this._view = null),
    Object.defineProperty(this, '_view', {
      writable: !0,
      enumerable: !1
    }),
    (this._parentViewController = null),
    Object.defineProperty(this, '_parentViewController', {
      writable: !0,
      enumerable: !1
    }),
    (this._childViewControllers = []),
    Object.defineProperty(this, '_childViewControllers', {
      writable: !0,
      enumerable: !1
    }),
    (this._presentationController = null),
    Object.defineProperty(this, '_presentationController', {
      writable: !0,
      enumerable: !1
    }),
    (this.tabBarItem = null),
    (this.isLoading = !1),
    (this.hasLoaded = !1),
    (this.initialized = !1),
    (this.modalDisplayStyle = enums.UIModalDisplayStyles.FILL);
}

function UTPopupDTO(e, t, i) {
  (this.title = e), (this.message = t), (this.buttonLabels = i);
}

function UTViewModel() {
  UTObject.call(this),
    (this._requests = []),
    Object.defineProperty(this, '_requests', {
      writable: !0,
      enumerable: !1
    }),
    (this._blockingRequests = []),
    Object.defineProperty(this, '_blockingRequests', {
      writable: !0,
      enumerable: !1
    });
}

function UTCaptchaViewModel(e) {
  UTViewModel.call(this),
    (this._captchaDataObject = e),
    Object.defineProperty(this, '_captchaDataObject', {
      writable: !0,
      enumerable: !1
    });
}
(NetworkErrorManager.NUM_INTERNAL_SERVER_ERRORS = 0),
  (NetworkErrorManager.checkCriticalStatus = function checkCriticalStatus(e) {
    return (
      e === enums.HTTPStatusCode.NOT_FOUND ||
      e === enums.HTTPStatusCode.LOGGED_IN_ON_CONSOLE ||
      e === enums.HTTPStatusCode.LOGGED_IN_ON_CONSOLE_LEGACY ||
      e === enums.HTTPStatusCode.ACCOUNT_BANNED ||
      e === enums.HTTPStatusCode.INVALID_COOKIE ||
      e === enums.HTTPStatusCode.CAPTCHA_REQUIRED ||
      e === enums.HTTPStatusCode.FUN_CAPTCHA_REQUIRED ||
      e === enums.HTTPStatusCode.UNAUTHORIZED ||
      e === enums.HTTPStatusCode.UNRECOVERABLE_ERROR ||
      e === enums.HTTPStatusCode.SERVER_ERROR
    );
  }),
  (NetworkErrorManager.generateDefaultStatusMessage = function generateDefaultStatusMessage(
    e
  ) {
    switch (e) {
      case enums.HTTPStatusCode.NOT_FOUND:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.CRITICAL,
          'popup.error.serviceNotFoundTitle',
          'popup.error.serviceNotFound'
        );
      case enums.HTTPStatusCode.LOGGED_IN_ON_CONSOLE:
      case enums.HTTPStatusCode.LOGGED_IN_ON_CONSOLE_LEGACY:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.CRITICAL,
          'signedontoanotherdevice.title',
          'rpcErrorResponses.general.CARDHOUSE_ERR_ALREADY_LOGGEDIN_ON_CONSOLE'
        );
      case enums.HTTPStatusCode.ACCOUNT_BANNED:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.CRITICAL,
          'error.banneduser.header',
          'error.banneduser.body'
        );
      case enums.HTTPStatusCode.INVALID_COOKIE:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.CRITICAL,
          'popup.error.invalidcookieTitle',
          'popup.error.invalidcookie'
        );
      case enums.HTTPStatusCode.CAPTCHA_REQUIRED:
      case enums.HTTPStatusCode.FUN_CAPTCHA_REQUIRED:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.CRITICAL,
          'popup.error.captcharequiredTitle',
          'popup.error.captcharequired'
        );
      case enums.HTTPStatusCode.NO_CONTENT:
      case enums.HTTPStatusCode.BAD_REQUEST:
      case enums.HTTPStatusCode.UT_BAD_REQUEST:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.UNIMPORTANT,
          'popup.error.invalidrequestTitle',
          'popup.error.invalidrequest'
        );
      case enums.HTTPStatusCode.PROFANITY:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.UNIMPORTANT,
          'popup.error.profanityTitle',
          'popup.error.profanity'
        );
      case enums.HTTPStatusCode.NO_CARD_EXISTS:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.UNIMPORTANT,
          'popup.error.NoSuchCardTitle',
          'popup.error.NoSuchCard'
        );
      case enums.HTTPStatusCode.SERVER_ERROR:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.CRITICAL,
          'popup.error.serverdownTitle',
          'popup.error.serverdown'
        );
      case enums.HTTPStatusCode.SERVICE_IS_DISABLED:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.UNIMPORTANT,
          'popup.error.ServiceIsDisabledTitle',
          'popup.error.ServiceIsDisabled'
        );
      case enums.HTTPStatusCode.RATE_LIMIT:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.UNIMPORTANT,
          'popup.error.RateLimitHeader',
          'popup.error.RateLimitBody'
        );
      case enums.HTTPStatusCode.UNAUTHORIZED:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.CRITICAL,
          'popup.error.unauthorized.title',
          'popup.error.unauthorized.body'
        );
      case enums.HTTPStatusCode.UNRECOVERABLE_ERROR:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.CRITICAL,
          'popup.error.cannotcontinueTitle',
          'popup.error.cannotcontinue'
        );
      case enums.HTTPStatusCode.NO_INTERNET_CONNECTION:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.UNIMPORTANT,
          'popup.error.NoInternetConnectionTitle',
          'popup.error.NoInternetConnection'
        );
      case enums.HTTPStatusCode.REQUEST_TIME_OUT:
      case enums.HTTPStatusCode.NETWORK_ERROR:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.UNIMPORTANT,
          'popup.error.networkerrorTitle',
          'popup.error.networkerrorNotCritical'
        );
      case enums.HTTPStatusCode.SOME_ITEMS_NOT_FREE:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.UNIMPORTANT,
          'popup.error.activesquad.itemsNotFreeTitle',
          'popup.error.activesquad.itemsNotFreeMsg'
        );
      default:
        return new valueobjects.NetworkErrorVO(
          e,
          enums.NetworkErrorLevel.UNIMPORTANT,
          'popup.title.genericError',
          'popup.body.genericError'
        );
    }
  }),
  (NetworkErrorManager.handleStatus = function handleStatus(e) {
    NetworkErrorManager.handle(
      NetworkErrorManager.generateDefaultStatusMessage(e)
    );
  }),
  (NetworkErrorManager.handle = function handle(e, t, i) {
    if (NetworkErrorManager.handlingError)
      NetworkErrorManager.queue.push({
        error: e,
        silent: t,
        cb: i
      });
    else {
      if (((NetworkErrorManager.handlingError = !0), e.isCritical())) {
        gClickShield.reset();
        var s = getAppMain().getLoginController();
        (i = s.logout.bind(s, enums.PIN.LOGOUT_EVT_END_REASON.ERROR)),
          services.PIN.sendData(enums.PIN.EVENT.ERROR, {
            sid: services.Authentication.getSession(enums.AuthEnvironment.UTAS)
              .id,
            type: 'disconnect',
            errid: enums.PIN.ERROR_EVT_ERRID.SERVER,
            server_type: 'utas'
          }),
          (NetworkErrorManager.queue = []);
      }
      if (
        (!e.isUnimportant() || (e.isUnimportant() && !t)
          ? utils.PopupManager.displayNetworkError(e, i)
          : utils.JS.isFunction(i) && i(),
        (NetworkErrorManager.handlingError = !1),
        0 < NetworkErrorManager.queue.length)
      ) {
        var n = NetworkErrorManager.queue.shift();
        NetworkErrorManager.handle(n.error, n.silent, n.cb);
      }
    }
  }),
  (NetworkErrorManager.trackServerError = function trackServerError() {
    if (
      (NetworkErrorManager.NUM_INTERNAL_SERVER_ERRORS++,
      NetworkErrorManager.NUM_INTERNAL_SERVER_ERRORS >=
        gConfigurationModel.getConfigNumber(
          models.ConfigurationModel.KEY_MAX_CONSECUTIVE_500_ERRORS
        ))
    ) {
      NetworkErrorManager.NUM_INTERNAL_SERVER_ERRORS = 0;
      var e = new valueobjects.NetworkErrorVO(
        enums.HTTPStatusCode.SERVER_ERROR,
        enums.NetworkErrorLevel.CRITICAL,
        'popup.error.cannotcontinueTitle',
        'popup.error.cannotcontinue'
      );
      return NetworkErrorManager.handle(e, !1), !0;
    }
    return !1;
  }),
  NamespaceManager.Register('views.popups'),
  (views.popups.LiveMessage = function LiveMessage() {
    UTView.call(this), (this._isRendered = !1), this._generate();
  }),
  utils.JS.inherits(views.popups.LiveMessage, UTView),
  (views.popups.LiveMessage.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('ut-livemessage'),
        e.classList.add('sm-ut-content-container'),
        e.classList.add('ut-content-container'),
        (this.__contentContainer = document.createElement('div')),
        this.__contentContainer.classList.add('ut-content');
      var t = document.createElement('div');
      t.classList.add('ut-livemessage-container'),
        (this.__header = document.createElement('header')),
        this.__header.classList.add('ut-livemessage-header');
      var i = document.createElement('div');
      i.classList.add('ut-livemessage-header--meta'),
        (this.__date = document.createElement('p')),
        this.__date.classList.add('ut-livemessage-header--date'),
        i.appendChild(this.__date),
        (this.__numMessages = document.createElement('p')),
        this.__numMessages.classList.add('ut-livemessage-header--counter'),
        i.appendChild(this.__numMessages),
        this.__header.appendChild(i),
        (this.__title = document.createElement('h1')),
        this.__header.appendChild(this.__title),
        (this.__subtitle = document.createElement('h2')),
        this.__header.appendChild(this.__subtitle),
        (this.__info = document.createElement('h3')),
        this.__header.appendChild(this.__info),
        t.appendChild(this.__header);
      var s = document.createElement('div');
      s.classList.add('ut-livemessage-content'),
        (this._image = new UTImageView()),
        this._image
          .getRootElement()
          .classList.add('ut-livemessage-content--image'),
        s.appendChild(this._image.getRootElement()),
        (this.__content = document.createElement('div')),
        this.__content.classList.add('ut-livemessage-content--body'),
        s.appendChild(this.__content),
        t.appendChild(s);
      var n = document.createElement('div');
      n.classList.add('ut-livemessage-footer'),
        (this._continueBtn = new UTStandardButtonControl()),
        this._continueBtn.getRootElement().classList.add('call-to-action'),
        n.appendChild(this._continueBtn.getRootElement()),
        t.appendChild(n),
        this.__contentContainer.appendChild(t),
        e.appendChild(this.__contentContainer),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (views.popups.LiveMessage.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__contentContainer = null),
      (this.__header = null),
      (this.__date = null),
      (this.__numMessages = null),
      (this.__title = null),
      (this.__subtitle = null),
      (this.__info = null),
      this._image.destroy(),
      (this.__content = null),
      this._continueBtn.destroy();
  }),
  (views.popups.LiveMessage.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (views.popups.LiveMessage.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.popups.LiveMessage.prototype.init = function init() {
    this.superclass(),
      this._continueBtn.init(),
      this._continueBtn.setText(
        services.Localization.localize('common.dialog.continue')
      ),
      this.setInteractionState(!0);
  }),
  (views.popups.LiveMessage.prototype.setInteractionState = function setInteractionState(
    e
  ) {
    this._setInteractionStateFlag(e), this._continueBtn.setInteractionState(e);
  }),
  (views.popups.LiveMessage.prototype._renderImages = function _renderImages(
    e,
    t
  ) {
    this._image.setExternalResource(e, !0).observe(this, this._imageLoad),
      (this.__contentContainer.style.backgroundImage = utils.JS.isEmpty(t)
        ? ''
        : 'url(' + t + ')');
  }),
  (views.popups.LiveMessage.prototype._imageLoad = function _imageLoad(
    e,
    t,
    i,
    s
  ) {
    e.unobserve(this), t || i.setLocalResource('images/liveMessageDefault.png');
  }),
  (views.popups.LiveMessage.prototype._renderHeader = function _renderHeader(
    e,
    t
  ) {
    var i = e.textFields.get(enums.ArubaTextFieldType.TITLE),
      s = e.textFields.get(enums.ArubaTextFieldType.SUBTITLE),
      n = e.textFields.get(enums.ArubaTextFieldType.INFO),
      o = utils.JS.isValid(i),
      a = utils.JS.isValid(s),
      r = utils.JS.isValid(n),
      l = r ? n.colour : '';
    this.renderTitleText(o ? i.text : ''),
      (this.__title.style.color = o ? i.colour : ''),
      this.renderSubtitleText(a ? s.text : ''),
      (this.__subtitle.style.color = a ? s.colour : ''),
      this.renderInfoText(r ? n.text : ''),
      (this.__info.style.backgroundColor = l),
      (this.__info.style.color = utils.JS.isEmpty(l) ? '' : '#fff'),
      (this.__numMessages.textContent = t);
  }),
  (views.popups.LiveMessage.prototype.renderTitleText = function renderTitleText(
    e
  ) {
    this.__title.textContent = e;
  }),
  (views.popups.LiveMessage.prototype.renderSubtitleText = function renderSubtitleText(
    e
  ) {
    this.__subtitle.textContent = e;
  }),
  (views.popups.LiveMessage.prototype.renderInfoText = function renderInfoText(
    e
  ) {
    this.__info.textContent = e;
  }),
  (views.popups.LiveMessage.prototype.renderContent = function renderContent(
    e
  ) {
    this.renderContentText(e.text), (this.__content.style.color = e.colour);
  }),
  (views.popups.LiveMessage.prototype.renderContentText = function renderContentText(
    e
  ) {
    this.__content.innerHTML = e;
  }),
  (views.popups.LiveMessage.prototype.render = function render(e, t) {
    var i = e.textFields.get(enums.ArubaTextFieldType.BODY),
      s = e.images.get(enums.ArubaImageType.BODY) || '',
      n = e.images.get(enums.ArubaImageType.BACKGROUND) || '';
    this._isRendered
      ? ($(this.__header).fadeOut(
          200,
          function() {
            this._renderHeader(e, t), $(this.__header).fadeIn(200);
          }.bind(this)
        ),
        $(this.__content).fadeOut(
          200,
          function() {
            this.renderContent(i), $(this.__content).fadeIn(200);
          }.bind(this)
        ),
        this._image.getRoot().fadeOut(
          200,
          function() {
            this._renderImages(s, n), this._image.getRoot().fadeIn(200);
          }.bind(this)
        ))
      : (this._renderHeader(e, t),
        this._renderImages(s, n),
        this.renderContent(i),
        (this._isRendered = !0));
  }),
  (views.popups.LiveMessage.prototype.getContinueButton = function getContinueButton() {
    return this._continueBtn;
  }),
  utils.JS.inherits(UTTargetActionView, UTView),
  (UTTargetActionView.prototype.dealloc = function dealloc() {
    this.superclass(),
      this._targets && (this._targets.clear(), (this._targets = null));
  }),
  (UTTargetActionView.prototype.addTarget = function addTarget(e, t, i) {
    0 <= this.getActions(e, i).indexOf(t) ||
      (this._targets.has(i)
        ? this._targets.get(i).push(
            Object.freeze({
              target: e,
              action: t
            })
          )
        : this._targets.set(i, [
            Object.freeze({
              target: e,
              action: t
            })
          ]));
  }),
  (UTTargetActionView.prototype.removeTarget = function removeTarget(t, i, e) {
    if (this._targets.has(e)) {
      var s = this._targets.get(e).filter(function(e) {
        return !(e.target === t && e.action === i);
      });
      this._targets.set(e, s);
    }
  }),
  (UTTargetActionView.prototype.getActions = function getActions(i, e) {
    var t = [],
      s = this._targets.get(e);
    return (
      s &&
        (t = s.reduce(function(e, t) {
          return t.target === i && e.push(t.action), e;
        }, [])),
      t
    );
  }),
  (UTTargetActionView.prototype._triggerActions = function _triggerActions(
    t,
    i
  ) {
    (i = i || null),
      this._targets.has(t) &&
        this._targets.get(t).forEach(function(e) {
          e.action.call(e.target, this, t, i);
        }, this);
  }),
  utils.JS.inherits(UTControl, UTTargetActionView),
  (UTControl.prototype.blur = function blur() {
    var e = this.getRootElement();
    e === document.activeElement && e.blur();
  }),
  (UTControl.prototype.focus = function focus() {
    var e = this.getRootElement();
    e !== document.activeElement && e.focus();
  }),
  (UTControl.prototype.addTarget = function addTarget(e, t, i) {
    var s = this._evaluateEventString(i);
    utils.Debug.Assert(s, 'Invalid assignment; expected enums.Event.<string>'),
      s && this.superclass(e, t, i);
  }),
  (UTControl.prototype.removeTarget = function removeTarget(e, t, i) {
    var s = this._evaluateEventString(i);
    utils.Debug.Assert(s, 'Invalid assignment; expected enums.Event.<string>'),
      s && this.superclass(e, t, i);
  }),
  (UTControl.prototype.getActions = function getActions(e, t) {
    var i = this._evaluateEventString(t);
    return (
      utils.Debug.Assert(
        i,
        'Invalid assignment; expected enums.Event.<string>'
      ),
      i ? this.superclass(e, t) : []
    );
  }),
  (UTControl.prototype._triggerActions = function _triggerActions(e, t) {
    var i = this._evaluateEventString(e);
    utils.Debug.Assert(i, 'Invalid assignment; expected enums.Event.<string>'),
      i && this.superclass(e, t);
  }),
  (UTControl.prototype._evaluateEventString = function _evaluateEventString(e) {
    var t;
    for (t in enums.Event)
      if (enums.Event.hasOwnProperty(t) && e === enums.Event[t]) return !0;
    return !1;
  }),
  utils.JS.inherits(UTButtonControl, UTControl),
  (UTButtonControl.prototype.init = function init() {
    this.superclass(), this.setInteractionState(!0);
  }),
  (UTButtonControl.prototype.setInteractionState = function setInteractionState(
    e
  ) {
    var t = this._interactionState;
    this.superclass(e),
      this._interactionState !== t &&
        ((this.getRootElement().disabled = !this._interactionState),
        this.toggleClass(enums.UIButtonState.DISABLED, !this._interactionState),
        this._interactionState ||
          this.removeClass(
            [enums.UIButtonState.ACTIVE, enums.UIButtonState.HOVER].join(' ')
          ));
  }),
  (UTButtonControl.prototype.setText = function setText(e) {
    this.getRootElement().textContent = e;
  }),
  (UTButtonControl.prototype._touchStarted = function _touchStarted(e) {
    this.superclass(e), this.addClass(enums.UIButtonState.ACTIVE);
  }),
  (UTButtonControl.prototype._touchMoved = function _touchMoved(e) {
    this.superclass(e), this.removeClass(enums.UIButtonState.ACTIVE);
  }),
  (UTButtonControl.prototype._touchEnded = function _touchEnded(e) {
    this.superclass(e), this.removeClass(enums.UIButtonState.ACTIVE);
  }),
  (UTButtonControl.prototype._touchCancelled = function _touchCancelled(e) {
    this.superclass(e), this.removeClass(enums.UIButtonState.ACTIVE);
  }),
  (UTButtonControl.prototype._mouseLeave = function _mouseLeave(e) {
    this.superclass(e),
      this.removeClass(enums.UIButtonState.ACTIVE),
      this.removeClass(enums.UIButtonState.HOVER);
  }),
  (UTButtonControl.prototype._mouseEnter = function _mouseEnter(e) {
    this.superclass(e), this.addClass(enums.UIButtonState.HOVER);
  }),
  (UTButtonControl.prototype._tapDetected = function _tapDetected(e) {
    this.superclass(e), this._triggerActions(enums.Event.TAP);
  }),
  utils.JS.inherits(UTGroupButtonControl, UTButtonControl),
  (UTGroupButtonControl.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('button');
      (this.__text = document.createElement('span')),
        this.__text.classList.add('btn-text'),
        e.appendChild(this.__text),
        (this.__subtext = document.createElement('span')),
        this.__subtext.classList.add('btn-subtext'),
        e.appendChild(this.__subtext),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTGroupButtonControl.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__text = null),
      (this.__subtext = null);
  }),
  (UTGroupButtonControl.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTGroupButtonControl.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTGroupButtonControl.prototype.setText = function setText(e) {
    this.__text.textContent = e;
  }),
  (UTGroupButtonControl.prototype.setSubtext = function setSubtext(e) {
    this.__subtext.textContent = e;
  }),
  (UTGroupButtonControl.prototype.displayCurrencyIcon = function displayCurrencyIcon(
    e
  ) {
    DOMKit.toggleClass(this.__subtext, 'currency-coins', e);
  }),
  NamespaceManager.Register('views.popups'),
  (views.popups.Dialog = function UTDialogPopupView() {
    UTView.call(this), (this._optionBtns = []), this._generate();
  }),
  utils.JS.inherits(views.popups.Dialog, UTView),
  (views.popups.Dialog.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('section');
      e.classList.add('Dialog');
      var t = document.createElement('header');
      (this.__title = document.createElement('h1')),
        this.__title.classList.add('dialog-title'),
        t.appendChild(this.__title),
        e.appendChild(t);
      var i = document.createElement('div');
      i.classList.add('dialog-body'),
        (this.__msg = document.createElement('p')),
        this.__msg.classList.add('dialog-msg'),
        i.appendChild(this.__msg),
        (this.__btnContainer = document.createElement('div')),
        this.__btnContainer.classList.add('ut-button-group'),
        i.appendChild(this.__btnContainer),
        e.appendChild(i),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (views.popups.Dialog.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__title = null),
      (this.__msg = null),
      (this.__btnContainer = null);
  }),
  (views.popups.Dialog.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (views.popups.Dialog.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.popups.Dialog.prototype.dealloc = function dealloc() {
    this._optionBtns.forEach(function(e) {
      e.dealloc();
    }),
      (this._optionBtns = []),
      this.superclass();
  }),
  (views.popups.Dialog.prototype.getContent = function getContent() {
    return this.__msg;
  }),
  (views.popups.Dialog.prototype.render = function render(e, t, i, s) {
    var n = utils.JS.isValid(s)
      ? services.Localization.localize(e, s)
      : services.Localization.localize(e);
    (this.__msg.innerHTML = new DOMParser().parseFromString(
      n,
      'text/html'
    ).body.innerHTML),
      (this.__title.textContent = services.Localization.localize(t)),
      this.addClass(i),
      this.layoutSubviews();
  }),
  (views.popups.Dialog.prototype.createOption = function createOption(e) {
    var t = new UTGroupButtonControl();
    return (
      t.setText(e),
      t.init(),
      this._optionBtns.push(t),
      this.addSubview(t, this.__btnContainer),
      t
    );
  }),
  utils.JS.inherits(UTModalContainerView, UTTargetActionView),
  (UTModalContainerView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('view-modal-container'),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTModalContainerView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTModalContainerView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTModalContainerView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTModalContainerView.Event = {
    SHIELDPRESS: 'UTModalContainerView.Event.SHIELDPRESS'
  }),
  (UTModalContainerView.prototype.init = function init() {
    this.superclass(), this.setInteractionState(!0);
  }),
  (UTModalContainerView.prototype._touchMoved = function _touchMoved(e) {
    this.getRootElement().contains(e.target)
      ? this.superclass()
      : (e.preventDefault(), e.stopPropagation());
  }),
  (UTModalContainerView.prototype._tapDetected = function _tapDetected(e) {
    e.target === this.getRootElement()
      ? this._triggerActions(UTModalContainerView.Event.SHIELDPRESS)
      : this.superclass();
  }),
  utils.JS.inherits(UTPresentationController, UTObject),
  (UTPresentationController.prototype.initWithViewControllers = function initWithViewControllers(
    e,
    t
  ) {
    this.initialized ||
      (utils.Debug.Assert(
        utils.JS.isValid(e) && e.isSubClass(UTViewController),
        'Presented object expected to be a view controller.'
      ),
      utils.Debug.Assert(
        utils.JS.isValid(t) && t.isSubClass(UTViewController),
        'Presenting object expected to be a view controller.'
      ),
      (this._presentedViewController = e),
      (this._presentingViewController = t),
      this.init());
  }),
  (UTPresentationController.prototype.dealloc = function dealloc() {
    this.superclass(),
      (this._presentedView = null),
      (this._presentedViewController = null),
      (this._presentingViewController = null),
      (this._isPresenting = !1);
  }),
  (UTPresentationController.prototype.getPresentedViewController = function getPresentedViewController() {
    return this._presentedViewController;
  }),
  (UTPresentationController.prototype._insertView = function _insertView(e, t) {
    (this._presentedView = e),
      this._presentedView.getSuperview() !== t &&
        (t.addSubview(this._presentedView), t.layoutSubviews());
  }),
  (UTPresentationController.prototype._presentInFullScreen = function _presentInFullScreen() {
    var e = this._presentedViewController.getView(),
      t = e.getRootElement();
    (t.style.position = 'fixed'),
      (t.style.top = '0'),
      (t.style.left = '0'),
      (t.style.right = '0'),
      (t.style.bottom = '0'),
      (t.style.zIndex = '10'),
      this._insertView(
        e,
        getAppMain()
          .getRootViewController()
          .getView()
      );
  }),
  (UTPresentationController.prototype._presentInContainerContext = function _presentInContainerContext() {
    var e = this._presentedViewController.getView(),
      t = e.getRootElement();
    (t.style.position = 'absolute'),
      (t.style.top = '0'),
      (t.style.left = '0'),
      (t.style.right = '0'),
      (t.style.bottom = '0'),
      (t.style.zIndex = '10'),
      this._insertView(e, this._presentingViewController.getView());
  }),
  (UTPresentationController.prototype._presentInFormModal = function _presentInFormModal() {
    var e = new UTModalContainerView();
    e.init(),
      e.addClass('form-modal'),
      e.addSubview(this._presentedViewController.getView()),
      e.layoutSubviews(),
      e.addTarget(
        this._presentingViewController,
        function(e, t, i) {
          this.dismissViewController(!0);
        },
        UTModalContainerView.Event.SHIELDPRESS
      ),
      this._insertView(
        e,
        getAppMain()
          .getRootViewController()
          .getView()
      );
  }),
  (UTPresentationController.prototype._presentInPageModal = function _presentInPageModal() {
    var e = new UTModalContainerView();
    e.init(),
      e.addClass('page-modal'),
      e.addSubview(this._presentedViewController.getView()),
      e.layoutSubviews(),
      e.addTarget(
        this._presentingViewController,
        function(e, t, i) {
          this.dismissViewController(!0);
        },
        UTModalContainerView.Event.SHIELDPRESS
      ),
      this._insertView(
        e,
        getAppMain()
          .getRootViewController()
          .getView()
      );
  }),
  (UTPresentationController.prototype.present = function present(e, t) {
    if (!this._isPresenting) {
      switch (
        ((this._isPresenting = !0),
        this._presentingViewController.willPresent(
          this._presentedViewController
        ),
        this.presentationWillBegin(),
        this._presentingViewController.addChildViewController(
          this._presentedViewController
        ),
        this._presentedViewController.viewWillAppear(),
        this._presentedViewController.modalDisplayStyle)
      ) {
        case enums.UIModalDisplayStyles.FULLSCREEN:
          this._presentInFullScreen();
          break;
        case enums.UIModalDisplayStyles.FILL:
          this._presentInContainerContext();
          break;
        case enums.UIModalDisplayStyles.FORM:
          this._presentInFormModal();
          break;
        case enums.UIModalDisplayStyles.PAGE:
          this._presentInPageModal();
          break;
        default:
          utils.Debug.Assert(
            !1,
            'View controller does not have a supported modal display style.'
          );
      }
      this._presentedViewController.viewDidAppear(),
        e
          ? this._presentedViewController
              .getView()
              .perform(
                enums.UIAnimation.FADE_IN,
                _completePresentation.bind(this)
              )
          : _completePresentation.call(this);
    }

    function _completePresentation() {
      this.presentationDidEnd(),
        this._presentingViewController.didPresent(
          this._presentedViewController
        ),
        utils.JS.isFunction(t) && t();
    }
  }),
  (UTPresentationController.prototype.dismiss = function dismiss(e, t) {
    this._isPresenting &&
      (this._presentingViewController.willDismiss(
        this._presentedViewController
      ),
      this.dismissalWillBegin(),
      this._presentedViewController.viewWillDisappear(),
      this._presentedView.removeFromSuperview(
        e,
        function _completeDismissal() {
          this._presentedView.isSubClass(UTModalContainerView)
            ? this._presentedView.dealloc()
            : this._presentedView.getRootElement().removeAttribute('style'),
            this._presentingViewController.viewDidDisappear(),
            this.dismissalDidEnd(),
            this._presentingViewController.didDismiss(
              this._presentedViewController
            ),
            (this._presentedView = null),
            (this._isPresenting = !1),
            this._presentingViewController.removeChildViewController(
              this._presentedViewController
            ),
            utils.JS.isFunction(t) && t();
        }.bind(this)
      ));
  }),
  (UTPresentationController.prototype.presentationWillBegin = function presentationWillBegin() {}),
  (UTPresentationController.prototype.presentationDidEnd = function presentationDidEnd() {}),
  (UTPresentationController.prototype.dismissalWillBegin = function dismissalWillBegin() {}),
  (UTPresentationController.prototype.dismissalDidEnd = function dismissalDidEnd() {}),
  utils.JS.inherits(UTViewController, UTResponder),
  (UTViewController.prototype.init = function init() {
    this.initialized || (this.superclass(), (this.initialized = !0));
  }),
  (UTViewController.prototype.dealloc = function dealloc() {
    this.tabBarItem && (this.tabBarItem = null),
      this._presentationController && this.dismissViewController(),
      this.removeFromParentViewController(),
      this._childViewControllers.forEach(function(e) {
        e.willMove(this), (e._parentViewController = null), e.didMove(this);
      }, this),
      (this._childViewControllers = []),
      this._view && (this._view.dealloc(), (this._view = null)),
      this.superclass();
  }),
  (UTViewController.prototype._getTelemetryId = function _getTelemetryId() {
    return null;
  }),
  (UTViewController.prototype.getParentViewController = function getParentViewController() {
    return this._parentViewController;
  }),
  (UTViewController.prototype.getNavigationController = function getNavigationController() {
    for (var e = this.getParentViewController(); null !== e; ) {
      if (e.isSubClass(UTNavigationController)) return e;
      e = e.getParentViewController();
    }
    return null;
  }),
  (UTViewController.prototype.getRootNavigationController = function getRootNavigationController() {
    for (var e = this.getNavigationController(), t = null; null !== e; )
      e = (t = e).getNavigationController();
    return t;
  }),
  (UTViewController.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return null;
  }),
  (UTViewController.prototype._loadView = function _loadView() {
    if (!this.hasLoaded) {
      var e = this._getViewInstanceFromData();
      e &&
        ((this._view = e),
        this._view.setEventDelegate(this),
        this._view.init());
    }
  }),
  (UTViewController.prototype.getView = function getView() {
    return (
      this._view ||
        ((this.isLoading = !0),
        this._loadView(),
        (this.isLoading = !1),
        this.viewDidLoad()),
      this.hasLoaded || this.isLoading || (this.hasLoaded = !0),
      this._view
    );
  }),
  (UTViewController.prototype.setView = function setView(e) {
    if (e !== this._view) {
      if (this._view) {
        var t = this._view;
        t.removeFromSuperview(), t.dealloc();
      }
      this._view = e;
    }
  }),
  (UTViewController.prototype.isViewDisplayed = function isViewDisplayed() {
    var e = this.getView();
    return (
      !!e &&
      (function _checkIfInElement(e, t) {
        var i = e.parentNode;
        return !!i && (i === t || _checkIfInElement(i, t));
      })(e.getRootElement(), document.getElementsByTagName('body')[0])
    );
  }),
  (UTViewController.prototype._getPresentationControllerInstance = function _getPresentationControllerInstance() {
    return new UTPresentationController();
  }),
  (UTViewController.prototype.addChildViewController = function addChildViewController(
    e
  ) {
    e.willMove(this),
      this._childViewControllers.push(e),
      (e._parentViewController = this),
      e.setEventDelegate(this),
      e.didMove(this);
  }),
  (UTViewController.prototype.removeChildViewController = function removeChildViewController(
    e
  ) {
    var t = this._childViewControllers.indexOf(e);
    if (0 <= t) {
      e.willMove(this);
      var i = this.getView(),
        s = e.getView();
      i && s && s.isSubview(i) && s.removeFromSuperview(),
        e.removeEventDelegate(this),
        e._parentViewController === this && (e._parentViewController = null),
        this._childViewControllers.splice(t, 1),
        e.didMove(this);
    }
  }),
  (UTViewController.prototype.removeFromParentViewController = function removeFromParentViewController() {
    var e = this.getParentViewController();
    e && e.removeChildViewController(this);
  }),
  (UTViewController.prototype.presentViewController = function presentViewController(
    e,
    t,
    i
  ) {
    function _performPresentation() {
      (this._presentationController = this._getPresentationControllerInstance()),
        this._presentationController.initWithViewControllers(e, this),
        this._presentationController.present(!!t, i);
    }
    (this._presentationController &&
      this._presentationController.getPresentedViewController() === e) ||
      (this._presentationController
        ? this.dismissViewController(!!t, _performPresentation.bind(this))
        : _performPresentation.call(this));
  }),
  (UTViewController.prototype.dismissViewController = function dismissViewController(
    e,
    t
  ) {
    utils.Debug.Assert(
      utils.JS.isValid(this._presentationController),
      'Attempted to perform a dismiss when no view controller is being presented.'
    ),
      this._presentationController &&
        this._presentationController.dismiss(
          !!e,
          function _completeDismiss() {
            this._presentationController.dealloc(),
              (this._presentationController = null),
              utils.JS.isFunction(t) && t();
          }.bind(this)
        );
  }),
  (UTViewController.prototype.decorateLinks = function decorateLinks(e) {
    DOMKit.findElements(e, 'a').forEach(function(e) {
      ('a' !== e.nodeName && 'A' !== e.nodeName) ||
        (e.addEventListener(enums.Event.TOUCHEND, this._linkHandler, !1),
        e.addEventListener(enums.Event.CLICK, this._linkHandler, !1));
    }, this);
  }),
  (UTViewController.prototype.stripLinks = function stripLinks(e) {
    DOMKit.findElements(e, 'a').forEach(function(e) {
      ('a' !== e.nodeName && 'A' !== e.nodeName) ||
        (e.removeEventListener(enums.Event.TOUCHEND, this._linkHandler, !1),
        e.removeEventListener(enums.Event.CLICK, this._linkHandler, !1));
    }, this);
  }),
  (UTViewController.prototype._linkHandler = function _linkHandler(e) {
    e.preventDefault();
    var t = this.attributes.href || null,
      i = null;
    if (t) return (i = isWeb() ? '_blank' : '_system'), window.open(t.value, i);
  }),
  (UTViewController.prototype.getPresentedViewController = function getPresentedViewController() {
    return this._presentationController
      ? this._presentationController.getPresentedViewController()
      : null;
  }),
  (UTViewController.prototype.getNavigationTitle = function getNavigationTitle() {
    return '';
  }),
  (UTViewController.prototype.getToolbarItems = function getToolbarItems() {
    return this.getNavigationController().getToolbarItems();
  }),
  (UTViewController.prototype.getNavigationItem = function getNavigationItem() {
    return null;
  }),
  (UTViewController.prototype.willMove = function willMove(e) {}),
  (UTViewController.prototype.didMove = function didMove(e) {}),
  (UTViewController.prototype.willPresent = function willPresent(e) {}),
  (UTViewController.prototype.didPresent = function didPresent(e) {}),
  (UTViewController.prototype.willDismiss = function willDismiss(e) {}),
  (UTViewController.prototype.didDismiss = function didDismiss(e) {}),
  (UTViewController.prototype.viewDidLoad = function viewDidLoad() {}),
  (UTViewController.prototype.viewWillAppear = function viewWillAppear() {}),
  (UTViewController.prototype.viewWillDisappear = function viewWillDisappear() {}),
  (UTViewController.prototype.viewDidAppear = function viewDidAppear() {
    var e = this._getTelemetryId();
    utils.JS.isString(e) &&
      services.PIN.sendData(enums.PIN.EVENT.PAGE_VIEW, {
        type: PIN_PAGEVIEW_EVT_TYPE,
        pgid: e
      });
  }),
  (UTViewController.prototype.viewDidDisappear = function viewDidDisappear() {}),
  NamespaceManager.Register('interfaces'),
  (interfaces.KeyboardEventDelegate = function IKeyboardEventDelegate() {}),
  (interfaces.KeyboardEventDelegate.prototype.handleKeyUpEvent = function handleKeyUpEvent(
    e
  ) {}),
  NamespaceManager.Register('controllers.views.popups'),
  (controllers.views.popups.BasePopup = function BasePopup() {
    UTViewController.call(this),
      (this.onExit = new UTObservable()),
      Object.defineProperty(this, 'onExit', {
        writable: !1
      });
  }),
  utils.JS.inherits(controllers.views.popups.BasePopup, UTViewController),
  (controllers.views.popups.BasePopup.prototype.init = function init() {
    this.superclass(),
      getKeyboardEventController().registerDelegate(
        this,
        UTKeyboardEventController.PRIORITY.POPUP
      );
  }),
  (controllers.views.popups.BasePopup.prototype.dealloc = function dealloc() {
    this.onExit.dealloc(),
      (this.onExit = null),
      getKeyboardEventController().unregisterDelegate(
        this,
        UTKeyboardEventController.PRIORITY.POPUP
      ),
      this.superclass();
  }),
  (controllers.views.popups.BasePopup.prototype.onBackButton = function onBackButton() {
    return this.closePopup(), !1;
  }),
  (controllers.views.popups.BasePopup.prototype.closePopup = function closePopup() {
    this.onExit.notify();
  }),
  (controllers.views.popups.BasePopup.prototype.handleKeyUpEvent = function handleKeyUpEvent(
    e
  ) {
    (e.key !== enums.KeyboardKey.ESCAPE &&
      e.key !== enums.KeyboardKey.MS_ESCAPE) ||
      this.onExit.notify(enums.UIDialogOptions.CANCEL);
  }),
  (controllers.views.popups.Dialog = function UTDialogPopupViewController(
    e,
    t,
    i,
    s,
    n
  ) {
    controllers.views.popups.BasePopup.call(this),
      (this._msg = e),
      (this._title = t),
      (this._options = utils.JS.valToArray(n)),
      (this._messageParameters = s || []),
      (this._type = utils.JS.isValid(i) ? i : enums.UIDialogTypes.MESSAGE);
  }),
  utils.JS.inherits(
    controllers.views.popups.Dialog,
    controllers.views.popups.BasePopup
  ),
  (controllers.views.popups.Dialog.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new views.popups.Dialog();
  }),
  (controllers.views.popups.Dialog.prototype.viewDidAppear = function viewDidAppear() {
    this.superclass();
    var i = this.getView();
    this._options.forEach(function(e, t) {
      i.createOption(utils.PopupManager.getLocalizedDialogOption(e)).addTarget(
        this,
        this._eOptionSelected.bind(this, e),
        enums.Event.TAP
      );
    }, this),
      i.render(this._msg, this._title, this._type, this._messageParameters),
      this.decorateLinks(i.getContent());
  }),
  (controllers.views.popups.Dialog.prototype.viewWillDisappear = function viewWillDisappear() {
    this.superclass(), this.stripLinks(this.getView().getContent());
  }),
  (controllers.views.popups.Dialog.prototype.handleKeyUpEvent = function handleKeyUpEvent(
    e
  ) {
    var t;
    this._options.length < 1 ||
      (e.key === enums.KeyboardKey.ESCAPE ||
      e.key === enums.KeyboardKey.MS_ESCAPE
        ? ((t = isWeb() ? this._options[1] : this._options[0]),
          this.onExit.notify(
            utils.JS.isNumber(t) ? t : enums.UIDialogOptions.CANCEL
          ))
        : e.key === enums.KeyboardKey.ENTER &&
          ((t = isWeb() ? this._options[0] : this._options[1]),
          this.onExit.notify(
            utils.JS.isNumber(t) ? t : enums.UIDialogOptions.OK
          )));
  }),
  (controllers.views.popups.Dialog.prototype._eOptionSelected = function _eOptionSelected(
    e
  ) {
    this.onExit.notify(e);
  }),
  NamespaceManager.Register('utils'),
  (utils.PopupManager = {}),
  (utils.PopupManager.displayingNativePopup = !1),
  (utils.PopupManager.ShowAlert = function showAlert(e, i, t) {
    var s = new controllers.views.popups.Dialog(
      e.message,
      e.title,
      enums.UIDialogTypes.ALERT,
      t,
      e.buttonLabels.slice(0, 1)
    );
    s.init(),
      gPopupClickShield.setActivePopup(s),
      s.onExit.observe(this, function(e, t) {
        i && i();
      });
  }),
  (utils.PopupManager.displayNetworkError = function(e, t) {
    var i = new UTPopupDTO(e.getTitle(), e.getMessage(), [
      enums.UIDialogOptions.OK
    ]);
    utils.PopupManager.ShowAlert(i, t);
  }),
  (utils.PopupManager.ShowConfirmation = function showConfirmation(e, t, i, s) {
    utils.JS.isFunction(s) || (s = function() {});
    var n = new controllers.views.popups.Dialog(
      e.message,
      e.title,
      enums.UIDialogTypes.MESSAGE,
      t,
      e.buttonLabels
    );
    n.init(),
      gPopupClickShield.setActivePopup(n),
      n.onExit.observe(this, function(e, t) {
        t !== enums.UIDialogOptions.CANCEL &&
        t !== enums.UIDialogOptions.NO &&
        i
          ? i()
          : s && s();
      });
  }),
  (utils.PopupManager.showNoInternetConnectionPopup = function showNoInternetConnectionPopup() {
    var e = getAppMain().getLoginController(),
      t = e ? e.logout.bind(e, enums.PIN.LOGOUT_EVT_END_REASON.ERROR) : null;
    utils.PopupManager.ShowAlert(
      utils.PopupManager.Alerts.NO_INTERNET_CONNECTION,
      t
    );
  }),
  (utils.PopupManager.getLocalizedDialogOption = function getLocalizedDialogOption(
    e
  ) {
    var t = '';
    switch (e) {
      case enums.UIDialogOptions.RETRY:
        t = 'easfcdown.retry';
        break;
      case enums.UIDialogOptions.OK:
        t = 'common.dialog.ok';
        break;
      case enums.UIDialogOptions.CANCEL:
        t = 'common.dialog.cancel';
        break;
      case enums.UIDialogOptions.YES:
        t = 'popup.yes';
        break;
      case enums.UIDialogOptions.NO:
        t = 'popup.no';
        break;
      case enums.UIDialogOptions.SIGN_OUT:
        t = 'more.signout.button';
        break;
      case enums.UIDialogOptions.TAKE_ME:
        t = 'popup.takeMeThere';
    }
    return services.Localization.localize(t);
  }),
  (utils.PopupManager.Alerts = {}),
  (utils.PopupManager.CONFIRM_DENY = [
    enums.UIDialogOptions.OK,
    enums.UIDialogOptions.CANCEL
  ]),
  (utils.PopupManager.SIGN_OUT = [
    enums.UIDialogOptions.SIGN_OUT,
    enums.UIDialogOptions.CANCEL
  ]),
  (utils.PopupManager.Alerts.ORIGIN_UNAVAILABLE = new UTPopupDTO(
    'popup.originUnavailableTitle',
    'popup.originUnavailable',
    [enums.UIDialogOptions.RETRY]
  )),
  (utils.PopupManager.Alerts.ACCOUNT_BANNED = new UTPopupDTO(
    'error.banneduser.header',
    'error.banneduser.body',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.BID_TOO_LOW = new UTPopupDTO(
    'popup.errorLowBidTitle',
    'popup.bidTooLow',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.CANT_UNWATCH_ACTIVE_BID = new UTPopupDTO(
    'popup.cantUnwatchCardPlayerBidTitle',
    'popup.cantUnwatchCardPlayerBidText',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.WATCH_LIST_FULL = new UTPopupDTO(
    'popup.watchlist.full.title',
    'popup.watchlist.full.message',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.TRANSFER_LIST_FULL = new UTPopupDTO(
    'popup.error.tradetoken.SellItemTradePileFullTitle',
    'popup.error.tradetoken.SellItemTradePileFull',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.DESTINATION_FULL = new UTPopupDTO(
    'popup.error.tradetoken.DestinationFullTitle',
    'popup.error.item.DestinationFull',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.DUPLICATE_SQUAD_NAME = new UTPopupDTO(
    'popup.error.duplicateSquadNameTitle',
    'popup.error.duplicateSquadName',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.CANNOT_DELETE_SQUAD = new UTPopupDTO(
    'popup.cannotdeletesquad.title',
    'popup.cannotdeletesquad.message',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.DID_CREATE_EXCEEDED = new UTPopupDTO(
    'popup.error.DID.CreateExceededHeader',
    'popup.error.DID.CreateExceededBody',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.DID_LOGIN_EXCEEDED = new UTPopupDTO(
    'popup.error.DID.LoginExceededHeader',
    'popup.error.DID.LoginExceededBody',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.DEVICE_SUSPENDED = new UTPopupDTO(
    'popup.error.DeviceSuspendedHeader',
    'popup.error.DeviceSuspendedBody',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.GEOIP_BLACKLISTED = new UTPopupDTO(
    'popup.error.geoipblacklist.title',
    'popup.error.geoipblacklist',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.NO_INTERNET_CONNECTION = new UTPopupDTO(
    'popup.error.NoInternetConnectionTitle',
    'popup.error.NoInternetConnection',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.LOW_MEMORY = new UTPopupDTO(
    'popup.warningLowMemoryTitle',
    'popup.warningLowMemory',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.SERVER_DOWN = new UTPopupDTO(
    'popup.error.serverdownTitle',
    'popup.error.serverdown',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.DUPLICATE_ITEM = new UTPopupDTO(
    'popup.error.item.DuplicatedItemTypeTitle',
    'popup.error.squadManagement.DuplicateItem',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.SERVICE_IS_DISABLED = new UTPopupDTO(
    'popup.error.ServiceIsDisabledTitle',
    'popup.error.ServiceIsDisabled',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.ALL_NEED_TO_BE_CLAIMED = new UTPopupDTO(
    'popup.error.autoassign.cannotAutoAssign',
    'popup.error.autoassign.allFreePack',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.HIT_MAX_LISTING = new UTPopupDTO(
    'popup.error.list.forbidden.title',
    'popup.error.list.forbidden.message',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.TRADING_DISABLED = new UTPopupDTO(
    'tile.disabled.transfersunavailable',
    'popup.error.auctioninfo.tradingdisabled',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.SBC_GRACE_PERIOD = new UTPopupDTO(
    'popup.sbcgraceperiod.title',
    'popup.sbcgraceperiod.message',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.SBC_INELIGIBLE_SQUAD = new UTPopupDTO(
    'popup.sbcineligiblesquad.title',
    'popup.sbcineligiblesquad.message',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.SBC_UNTRADEABLE_NOT_ALLOWED = new UTPopupDTO(
    'popup.sbcineligiblesquad.title',
    'popup.sbcUntradeableNotAllowed.message',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.SQUAD_BUILDER_NO_RESULTS = new UTPopupDTO(
    'popup.title.noSquadBuilderResults',
    'popup.error.squad.builder.noresults',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.ONBOARDING_INTRO = new UTPopupDTO(
    'onboarding.popup.loanswap.title',
    'onboarding.popup.loanswap.body',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Alerts.SAVE_TACTICS = new UTPopupDTO(
    'tactics.popup.savetutorial.title',
    'tactics.popup.savetutorial.body',
    [enums.UIDialogOptions.OK]
  )),
  (utils.PopupManager.Confirmations = {}),
  (utils.PopupManager.Confirmations.CONFIRM_COPY_SQUAD = new UTPopupDTO(
    'manage.copy.message.title',
    'manage.copy.message',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.CONFIRM_RELIST_ALL = new UTPopupDTO(
    'popup.tradepile.relistAllTitle',
    'popup.tradepile.relistAllPriceBandingText',
    [enums.UIDialogOptions.CANCEL, enums.UIDialogOptions.YES]
  )),
  (utils.PopupManager.Confirmations.BID_WHEN_HIGHEST_BIDDER = new UTPopupDTO(
    'popup.confirmHighestBidderTitle',
    'popup.confirmHighestBidder',
    [enums.UIDialogOptions.CANCEL, enums.UIDialogOptions.YES]
  )),
  (utils.PopupManager.Confirmations.CONFIRM_BID = new UTPopupDTO(
    'popup.bidConfirmationTitle',
    'popup.bidConfirmationText',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.CONFIRM_BUY_NOW = new UTPopupDTO(
    'popup.buyNowConfirmationTitle',
    'popup.buyNowConfirmationText',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.UNASSIGNED_ENTITLEMENT = new UTPopupDTO(
    'popup.error.unassignedItemsEntitlementTitle',
    'popup.error.fifacredits.unassignedItemsEntitlement',
    [enums.UIDialogOptions.CANCEL, enums.UIDialogOptions.TAKE_ME]
  )),
  (utils.PopupManager.Confirmations.NEW_ITEMS_FULL = new UTPopupDTO(
    'popup.newItemsFullTitle',
    'popup.newItemsFullText',
    [enums.UIDialogOptions.CANCEL, enums.UIDialogOptions.TAKE_ME]
  )),
  (utils.PopupManager.Confirmations.CONFIRM_DISCARD = new UTPopupDTO(
    'infopanel.label.discard',
    'popup.confirmItemDiscard',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.CONFIRM_DISCARD_ALL = new UTPopupDTO(
    'infopanel.label.discardall',
    'popup.confirmDiscardAll',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.DELETE_SQUAD = new UTPopupDTO(
    'popup.deletesquad.title',
    'popup.deletesquad.message',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.UPDATE_FUT = new UTPopupDTO(
    'popup.updateFUTTitle',
    'popup.update.FUTText',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.ENABLE_USAGE_SHARING = new UTPopupDTO(
    'more.usagesharing.title',
    'more.usagesharing.enablebody',
    [enums.UIDialogOptions.NO, enums.UIDialogOptions.YES]
  )),
  (utils.PopupManager.Confirmations.DISABLE_USAGE_SHARING = new UTPopupDTO(
    'more.usagesharing.title',
    'more.usagesharing.disablebody',
    [enums.UIDialogOptions.NO, enums.UIDialogOptions.YES]
  )),
  (utils.PopupManager.Confirmations.BUY_PACK = new UTPopupDTO(
    'store.confirmation.questionTitle',
    'popup.confirmPurchase',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.BUY_PACK_FIFAPOINTS = new UTPopupDTO(
    'store.confirmation.questionTitle',
    'popup.confirmPointsPurchase',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.SEND_ALL_TO_TRANSFER_LIST = new UTPopupDTO(
    'popup.confirmation.sendAllToTransferListTitle',
    'popup.confirmation.sendAllToTransferList',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.SEND_TO_CLUB = new UTPopupDTO(
    'infopanel.label.club',
    'popup.confirmSendToClub',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.SEND_TO_TRANSFER_LIST = new UTPopupDTO(
    'infopanel.label.sendTradePile',
    'popup.confirmSendToTransferList',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.APPLY_CONSUMABLE = new UTPopupDTO(
    'panel.applyitem.button',
    'popup.confirmApplyConsumable',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.SUBMIT_CHALLENGE = new UTPopupDTO(
    'sbc.overlay.btn.submitChallenge',
    'sbc.popup.submitChallenge.message',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.SIGN_OUT = new UTPopupDTO(
    'more.signout.title',
    'more.signout.body',
    utils.PopupManager.SIGN_OUT
  )),
  (utils.PopupManager.Confirmations.CHANGE_PERSONA = new UTPopupDTO(
    'personaselector.title',
    'personaselector.message',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.CLEAR_SQUAD = new UTPopupDTO(
    'clearSquad.title',
    'clearSquad.message',
    utils.PopupManager.CONFIRM_DENY
  )),
  (utils.PopupManager.Confirmations.WEEKEND_LEAGUE_ACCESS = new UTPopupDTO(
    'rivals.weekendleague.popup.title',
    'rivals.weekendleague.popup.body',
    [enums.UIDialogOptions.NO, enums.UIDialogOptions.YES]
  )),
  (utils.PopupManager.Confirmations.WEEKEND_LEAGUE_ACCESS_GRACE_PERIOD = new UTPopupDTO(
    'rivals.weekendleague.popup.title',
    'rivals.weekendleague.popup.bodyGracePeriod',
    [enums.UIDialogOptions.NO, enums.UIDialogOptions.YES]
  )),
  utils.JS.inherits(UTViewModel, UTObject),
  (UTViewModel.prototype.dealloc = function dealloc() {
    this.superclass(), this.stopTrackingRequests();
  }),
  (UTViewModel.prototype.stopTrackingRequests = function stopTrackingRequests() {
    0 < this._requests.length &&
      (this._requests.forEach(function(e) {
        e.clearObservers();
      }, this),
      (this._requests = [])),
      0 < this._blockingRequests.length &&
        (this._blockingRequests.forEach(function(e) {
          e.clearObservers(),
            gClickShield.hideShield(components.ClickShield.SHIELD.LOADING);
        }, this),
        (this._blockingRequests = []));
  }),
  (UTViewModel.prototype._trackRequest = function _trackRequest(e, s, n) {
    var o = s ? this._blockingRequests : this._requests;
    s && gClickShield.showShield(components.ClickShield.SHIELD.LOADING),
      o.push(
        e.observe(this, function _onRequestComplete(e, t) {
          e.unobserve(this),
            s && gClickShield.hideShield(components.ClickShield.SHIELD.LOADING);
          var i = o.indexOf(e);
          0 <= i && o.splice(i, 1), utils.JS.isFunction(n) && n(t);
        })
      );
  }),
  utils.JS.inherits(UTCaptchaViewModel, UTViewModel),
  (UTCaptchaViewModel.prototype.dealloc = function dealloc() {
    this.superclass(), (this._captchaDataObject = null);
  }),
  (UTCaptchaViewModel.prototype.requestHealthCheck = function requestHealthCheck() {
    var e = this._captchaDataObject.checkHealth();
    return this._trackRequest(e, !0), e;
  }),
  (UTCaptchaViewModel.prototype.requestCaptchaData = function requestCaptchaData() {
    var e = this._captchaDataObject.getCaptchaData();
    return this._trackRequest(e, !0), e;
  }),
  (UTCaptchaViewModel.prototype.validateToken = function validateToken(e) {
    var t = this._captchaDataObject.validateToken(e);
    return this._trackRequest(t, !0), t;
  }),
  (UTCaptchaViewModel.prototype.requestLegacyImage = function requestLegacyImage() {
    var e = this._captchaDataObject.getLegacyImage();
    return this._trackRequest(e, !0), e;
  }),
  (UTCaptchaViewModel.prototype.exchangeLegacyImage = function exchangeLegacyImage() {
    var e = this._captchaDataObject.exchangeLegacyImage();
    return this._trackRequest(e, !0), e;
  }),
  (UTCaptchaViewModel.prototype.validateLegacyAnswer = function validateLegacyAnswer(
    e
  ) {
    var t = this._captchaDataObject.validateLegacyAnswer(e);
    return this._trackRequest(t, !0), t;
  }),
  NamespaceManager.Register('models'),
  (models.StaffStatsModel = function() {
    (this._isDirty = !0),
      (this._playerAttribBoosts = [0, 0, 0, 0, 0, 0]),
      (this._gkAttribBoosts = [0, 0, 0, 0, 0, 0]),
      (this._healthAttribBoosts = [0, 0, 0, 0, 0, 0, 0, 0, 0]),
      (this._contractBoost = 0);
  }),
  (models.StaffStatsModel.prototype.reset = function reset() {
    (this._isDirty = !0),
      (this._playerAttribBoosts = [0, 0, 0, 0, 0, 0]),
      (this._gkAttribBoosts = [0, 0, 0, 0, 0, 0]),
      (this._healthAttribBoosts = [0, 0, 0, 0, 0, 0, 0, 0, 0]),
      (this._contractBoost = 0);
  }),
  (models.StaffStatsModel.prototype.isDirty = function isDirty() {
    return this._isDirty;
  }),
  (models.StaffStatsModel.prototype.setDirtyFlag = function setDirtyFlag(e) {
    this._isDirty = e;
  }),
  (models.StaffStatsModel.prototype.getPlayerAttribBoost = function getPlayerAttribBoost(
    e
  ) {
    return 0 <= e && e < this._playerAttribBoosts.length
      ? this._playerAttribBoosts[e]
      : 0;
  }),
  (models.StaffStatsModel.prototype.getGKAttribBoost = function getGKAttribBoost(
    e
  ) {
    return 0 <= e && e < this._gkAttribBoosts.length
      ? this._gkAttribBoosts[e]
      : 0;
  }),
  (models.StaffStatsModel.prototype.getHealthAttribBoost = function getHealthAttribBoost(
    e
  ) {
    return 0 <= e && e < this._healthAttribBoosts.length
      ? this._healthAttribBoosts[e]
      : 0;
  }),
  (models.StaffStatsModel.prototype.getPlayerAttribBoosts = function getPlayerAttribBoosts() {
    return this._playerAttribBoosts;
  }),
  (models.StaffStatsModel.prototype.setPlayerAttribBoosts = function setPlayerAttribBoosts(
    e
  ) {
    this._playerAttribBoosts = e;
  }),
  (models.StaffStatsModel.prototype.getGKAttribBoosts = function getGKAttribBoosts() {
    return this._gkAttribBoosts;
  }),
  (models.StaffStatsModel.prototype.setGKAttribBoosts = function setGKAttribBoosts(
    e
  ) {
    this._gkAttribBoosts = e;
  }),
  (models.StaffStatsModel.prototype.getHealthAttribBoosts = function getHealthAttribBoosts() {
    return this._healthAttribBoosts;
  }),
  (models.StaffStatsModel.prototype.setHealthAttribBoosts = function setHealthAttribBoosts(
    e
  ) {
    this._healthAttribBoosts = e;
  }),
  (models.StaffStatsModel.prototype.setContractBoost = function setContractBoost(
    e
  ) {
    this._contractBoost = e;
  }),
  (models.StaffStatsModel.prototype.getContractBoost = function getContractBoost() {
    return this._contractBoost;
  });
var gStaffStatsModel = new models.StaffStatsModel();

function UTNimbleMTXItemEntity(e) {
  (this.sku = e.toString()),
    Object.defineProperty(this, 'sku', {
      writable: !1,
      enumberable: !0
    }),
    (this.points = 0),
    (this.title = ''),
    (this.priceFormatted = '');
}

function UTNimbleMTXItemFactory() {
  UTObject.call(this);
}

function UTSquadSlotEntity(e, t) {
  UTObject.call(this),
    (this.onDataUpdated = new UTObservable()),
    Object.defineProperty(this, 'onDataUpdated', {
      writable: !1,
      enumerable: !0
    }),
    (this._index = e),
    (this._kitNumber = 0),
    (this._chemistry = 0),
    (this._item = factories.Item.createItem()),
    (this._position = t || null),
    (this._requirement = null),
    (this._managerBonus = 0);
}

function UTNullSquadSlotEntity() {
  UTSquadSlotEntity.call(this, -1, null);
}

function UTPlayerInstructionsVO(e) {
  UTObject.call(this),
    (this._positionId = e),
    Object.defineProperty(this, '_positionId', {
      enumerable: !1,
      writable: !1
    }),
    (this._instructions = []),
    Object.defineProperty(this, '_instructions', {
      enumerable: !1,
      writable: !0
    });
}

function UTPlayerInstructionGroupEntity(e) {
  UTObject.call(this),
    (this._id = e),
    Object.defineProperty(this, '_id', {
      enumerable: !1,
      writable: !1
    }),
    (this._instructions = []),
    Object.defineProperty(this, '_instructions', {
      enumerable: !1,
      writable: !0
    }),
    (this._selectedInstruction =
      UTPlayerInstructionsVO.INSTRUCTION.NO_INSTRUCTION),
    Object.defineProperty(this, '_selectedInstruction', {
      enumerable: !1,
      writable: !0
    });
}

function UTSquadMentalityEntity(e, t) {
  UTObject.call(this),
    (this.onDataUpdated = new UTObservable()),
    Object.defineProperty(this, 'onDataUpdated', {
      enumerable: !0,
      writable: !1
    }),
    (this._id = e),
    Object.defineProperty(this, '_id', {
      enumerable: !1,
      writable: !1
    }),
    (this._offensiveStyle = UTSquadMentalityEntity.OFFENSIVE_STYLE.BALANCED),
    Object.defineProperty(this, '_offensiveStyle', {
      enumerable: !1,
      writable: !0
    }),
    (this._offensiveWidth = 5),
    Object.defineProperty(this, '_offensiveWidth', {
      enumerable: !1,
      writable: !0
    }),
    (this._offensivePlayersInBox = 5),
    Object.defineProperty(this, '_offensivePlayersInBox', {
      enumerable: !1,
      writable: !0
    }),
    (this._defensiveStyle = UTSquadMentalityEntity.DEFENSIVE_STYLE.BALANCED),
    Object.defineProperty(this, '_defensiveStyle', {
      enumerable: !1,
      writable: !0
    }),
    (this._defensiveWidth = 5),
    Object.defineProperty(this, '_defensiveWidth', {
      enumerable: !1,
      writable: !0
    }),
    (this._defensiveDepth = 5),
    Object.defineProperty(this, '_defensiveDepth', {
      enumerable: !1,
      writable: !0
    }),
    (this._cornerPlayersInBox = 3),
    Object.defineProperty(this, '_cornerPlayersInBox', {
      enumerable: !1,
      writable: !0
    }),
    (this._freeKickPlayersInBox = 3),
    Object.defineProperty(this, '_freeKickPlayersInBox', {
      enumerable: !1,
      writable: !0
    }),
    (this._formation = null),
    Object.defineProperty(this, '_formation', {
      enumerable: !1,
      writable: !0
    }),
    (this._squadId = 0),
    Object.defineProperty(this, '_squadId', {
      enumerable: !1,
      writable: !0
    }),
    (this._instructions = new UTHashTable()),
    Object.defineProperty(this, '_instructions', {
      enumerable: !1,
      writable: !1
    }),
    (this._positions = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]),
    Object.defineProperty(this, '_positions', {
      enumerable: !1,
      writable: !0
    }),
    (this._modified = !1),
    Object.defineProperty(this, '_modified', {
      enumerable: !1,
      writable: !0
    }),
    (this._customized = !1),
    Object.defineProperty(this, '_customized', {
      enumerable: !1,
      writable: !0
    }),
    (this._squadDAO = t),
    Object.defineProperty(this, '_squadDAO', {
      enumerable: !1,
      writable: !1
    });
}

function UTSquadMentalityEntityFactory(e) {
  UTObject.call(this),
    (this._squadDAO = e),
    Object.defineProperty(this, '_squadDAO', {
      enumerable: !1,
      writable: !1
    });
}

function UTSquadEntityFactory(e) {
  UTObject.call(this),
    (this._mentalityFactory = new UTSquadMentalityEntityFactory(e)),
    Object.defineProperty(this, '_mentalityFactory', {
      enumerable: !1,
      writable: !1
    }),
    (this._squadDAO = e),
    Object.defineProperty(this, '_squadDAO', {
      enumerable: !1,
      writable: !1
    });
}

function _parseSquadPayload(t, e) {
  (t._owner = e.personaId),
    (t._id = e.id),
    (t._valid = e.valid),
    (t._captain = e.captain),
    (t._formation = repositories.Squad.getFormation(e.formation)),
    (t._chemistry = e.chemistry),
    (t._rating = e.rating),
    (t._name = e.squadName),
    utils.JS.isEmpty(e.squadType) || (t._type = e.squadType);
  for (var i = 0; i <= entities.Squad.MANAGER_SLOT_INDEX; ) {
    var s = new UTSquadSlotEntity(i, t._formation.getPosition(i)),
      n = 0,
      o = null;
    if (i === entities.Squad.MANAGER_SLOT_INDEX && e.manager)
      o = factories.Item.createItem(e.manager);
    else if (e.players[i]) {
      var a = e.players[i];
      (o = factories.Item.createItem(a.itemData)), (n = a.kitNumber || 0);
    } else o = factories.Item.createItem();
    s.setItem(o),
      s.setKitNumber(n),
      s.onDataUpdated.observe(t, t._eSlotDataUpdated),
      i === entities.Squad.MANAGER_SLOT_INDEX
        ? ((o.type = enums.ItemType.MANAGER), (t._manager = s))
        : ((o.type = enums.ItemType.PLAYER), t._players.push(s)),
      i++;
  }
  for (var r in (t._updateChemistryLinks(),
  t._players.forEach(t._calculateSlotChemistry, t),
  e.tactics &&
    e.tactics.forEach(function(e) {
      t.setTacticMentality(this._mentalityFactory.createMentality(e, t));
    }, this),
  UTSquadMentalityEntity.TYPE)) {
    var l = UTSquadMentalityEntity.TYPE[r];
    t.getTacticMentalityById(l) ||
      t.setTacticMentality(this._mentalityFactory.createDefaultMentality(l, t));
  }
}

function _parseSBCSquadPayload(e, t, i, s) {
  (e._id = t.id),
    (e._formation = repositories.Squad.getFormation(t.formation)),
    (e._chemistry = t.chemistry),
    (e._rating = t.rating);
  for (
    var n = utils.JS.isValid(s), o = 0;
    o < entities.Squad.MANAGER_SLOT_INDEX;

  ) {
    var a = new UTSquadSlotEntity(o, e._formation.getPosition(o)),
      r = o < entities.Squad.FIELD_PLAYERS,
      l = !1,
      c = null;
    if (n && r) {
      var u = s[o];
      u.playerType === enums.SBC.PLAYER_TYPE.BRICK
        ? e.simpleBrickIndices.push(u.index)
        : u.playerType === enums.SBC.PLAYER_TYPE.CUSTOM_BRICK &&
          (e.customBrickIndices.push(u.index), (l = !0)),
        a.setRequirement(
          new transferobjects.SBCPlayerRequirement(
            u,
            l ? i.createRequirements(u.elgReq) : []
          )
        );
    }
    ((c =
      l && t.players[o]
        ? factories.Item.createCustomBrickItem(t.players[o].itemData)
        : t.players[o]
        ? factories.Item.createItem(t.players[o].itemData)
        : factories.Item.createItem()).type = enums.ItemType.PLAYER),
      a.setItem(c),
      a.onDataUpdated.observe(e, e._eSlotDataUpdated),
      e._players.push(a),
      c.concept &&
        r &&
        e._type === enums.SquadType.REGULAR &&
        (e._type = enums.SquadType.DREAM),
      o++;
  }
  e._updateChemistryLinks(), e._players.forEach(e._calculateSlotChemistry, e);
}

function UTItemRepository() {
  UTHashTable.call(this, {}),
    (this._expiryTimestamp = 0),
    Object.defineProperty(this, 'endOfList', {
      writable: !0,
      enumerable: !1
    }),
    (this.endOfList = !1),
    (this.count = -1);
}

function UTClubRepository() {
  UTObject.call(this),
    (this._players = new UTItemRepository()),
    (this._staff = new UTItemRepository()),
    (this._consumables = new UTItemRepository()),
    (this._badges = new UTItemRepository()),
    (this._balls = new UTItemRepository()),
    (this._kits = new UTItemRepository()),
    (this._stadiums = new UTItemRepository()),
    (this._banners = new UTItemRepository()),
    (this._celebrations = new UTItemRepository()),
    (this._tifos = new UTItemRepository()),
    (this._activeItems = new UTHashTable()),
    (this._cacheTimestamp = 0),
    Object.defineProperty(this, '_cacheTimestamp', {
      writable: !0,
      enumerable: !1
    });
}

function LeagueRepository(e) {
  (this._leagues = new UTHashTable()),
    Object.defineProperty(this, '_leagues', {
      writable: !1,
      enumerable: !1
    }),
    utils.JS.isValid(e) && this.add(e);
}

function NationRepository(e) {
  (this._nations = new UTHashTable()),
    Object.defineProperty(this, '_nations', {
      writable: !1,
      enumerable: !1
    }),
    utils.JS.isValid(e) && this.add(e);
}

function TeamRepository(e) {
  (this._teams = new UTHashTable()),
    Object.defineProperty(this, '_teams', {
      writable: !1,
      enumerable: !1
    }),
    utils.JS.isValid(e) && this.add(e);
}

function UTNavigationButtonControl() {
  UTButtonControl.call(this);
}

function UTToolbarButtonControl() {
  UTButtonControl.call(this), (this._unreadBubble = null);
}

function UTNavigationController(e, t) {
  UTViewController.call(this),
    (this._navigationBar = e || new views.NavigationBar()),
    (this._toolbar = t || new views.Toolbar()),
    (this._backButton = new UTNavigationButtonControl()),
    (this._rootController = null),
    (this._currentController = null),
    (this._currentView = null),
    (this.isNavVisible = !1),
    (this.isToolbarVisible = !1),
    (this._isTransitioning = !1);
}

function UTKeyboardEventController() {
  UTObject.call(this),
    (this._eventDelegates = new UTHashTable()),
    (this._keyupHandler = this._eHandleKeyUpEvent.bind(this));
}

function UTRootPresentationController() {
  UTPresentationController.call(this);
}

function UTTabBarItemNotificationView() {
  UTView.call(this);
}

function UTTabBarItemView() {
  UTButtonControl.call(this),
    (this._tag = -1),
    Object.defineProperty(this, '_tag', {
      writable: !0,
      enumerable: !1
    }),
    (this._notifBubble = null),
    Object.defineProperty(this, '_notifBubble', {
      writable: !0,
      enumerable: !1
    });
}

function UTTabBarView() {
  UTTargetActionView.call(this),
    (this._tabItems = []),
    Object.defineProperty(this, '_tabItems', {
      writable: !0,
      enumerable: !1
    }),
    this._generate();
}

function UTTabBarController() {
  UTViewController.call(this),
    (this._currentController = null),
    (this._currentView = null);
}

function UTGameTabBarController() {
  UTTabBarController.call(this);
}

function UTPersonaSelectorView() {
  UTTargetActionView.call(this), (this._personaRows = []);
}

function UTPersonaSelectorViewController() {
  UTViewController.call(this);
}

function UTFlatButtonControl() {
  UTButtonControl.call(this);
}

function UTStandardButtonControl() {
  UTButtonControl.call(this);
}

function UTTextInputControl() {
  UTControl.call(this),
    (this._selectionTimeout = 0),
    Object.defineProperty(this, '_selectionTimeout', {
      writable: !0,
      enumerable: !1
    }),
    (this._blurTimeout = 0),
    Object.defineProperty(this, '_blurTimeout', {
      writable: !0,
      enumerable: !1
    });
}

function UTCaptchaViewController() {
  UTViewController.call(this),
    (this._timeoutId = 0),
    (this._cooldownTimer = new utils.UTTimer()),
    (this._cooldownSeconds = 0),
    (this._captchaAttempt = !1),
    (this._personaController = null),
    (this._captchaViewModel = null),
    Object.defineProperty(this, '_captchaViewModel', {
      writable: !0,
      enumerable: !1
    });
}

function UTFunCaptchaView() {
  UTView.call(this);
}

function UTFunCaptchaViewController() {
  UTViewController.call(this),
    (this._personaController = null),
    Object.defineProperty(this, '_personaController', {
      writable: !0,
      enumerable: !1
    }),
    (this._captchaLoaded = !1),
    Object.defineProperty(this, '_captchaLoaded', {
      writable: !0,
      enumerable: !1
    }),
    (this._captchaViewModel = null),
    Object.defineProperty(this, '_captchaViewModel', {
      writable: !0,
      enumerable: !1
    });
}

function UTGettingStartedViewController() {
  UTViewController.call(this),
    (this._type = enums.GettingStartedTypes.FIFA),
    Object.defineProperty(this, '_type', {
      writable: !0,
      enumerable: !1
    }),
    (this._personaController = null),
    Object.defineProperty(this, '_personaController', {
      writable: !0,
      enumerable: !1
    });
}

function UTLanguageTableCellView() {
  UTTargetActionView.call(this);
}

function UTLanguageSelectView() {
  UTTargetActionView.call(this), (this._cells = []);
}

function UTLanguageSelectViewController() {
  UTViewController.call(this),
    (this._callback = null),
    Object.defineProperty(this, '_callback', {
      writable: !0,
      enumerable: !1
    }),
    (this._locales = []),
    Object.defineProperty(this, '_locales', {
      writable: !0,
      enumerable: !1
    });
}

function UTLicenseViewController() {
  UTViewController.call(this),
    (this._completedFlags = 0),
    (this._hasLowMemory = !1),
    (this._setTimerFlagTimeout = 0);
}

function UTLoginViewController() {
  UTViewController.call(this),
    (this._inAppBrowser = null),
    (this._successCallbackDelegate = null),
    (this._errorCallbackDelegate = null),
    (this._linkCallbackDelegate = null),
    (this._browserDismissedCallbackDelegate = null),
    (this._recreateOnResume = !1);
}

function UTLoggedOnConsoleViewController() {
  UTViewController.call(this), (this._personaController = null);
}

function UTDropDownControl() {
  UTControl.call(this),
    (this.__picker = null),
    (this.__list = null),
    Object.defineProperty(this, 'enabled', {
      get: this.getEnabled,
      set: this.setEnabled,
      enumerable: !0
    }),
    (this.enabled = !0),
    (this._options = []),
    Object.defineProperty(this, '_options', {
      writable: !0,
      enumerable: !1
    }),
    (this._shieldShowing = !1),
    Object.defineProperty(this, '_shieldShowing', {
      writable: !0,
      enumerable: !1
    }),
    (this._defaultIndex = 0),
    Object.defineProperty(this, '_defaultIndex', {
      writable: !0,
      enumerable: !1
    }),
    (this.label = ''),
    Object.defineProperty(this, 'label', {
      get: this.getLabel,
      enumerable: !0
    }),
    (this.id = 0),
    Object.defineProperty(this, 'id', {
      get: this.getId,
      enumerable: !0
    }),
    (this.value = ''),
    Object.defineProperty(this, 'value', {
      get: this.getValue,
      enumerable: !0
    }),
    (this.length = 0),
    Object.defineProperty(this, 'length', {
      get: function() {
        return this._options.length;
      },
      enumerable: !0
    }),
    (this._windowListener = null),
    (this._isOpen = !1),
    (this._searchString = ''),
    Object.defineProperty(this, '_searchString', {
      writable: !0,
      enumerable: !1
    }),
    (this._searchTimeout = 0),
    Object.defineProperty(this, '_searchTimeout', {
      writable: !0,
      enumerable: !1
    });
}

function UTSearchFilterControl() {
  UTDropDownControl.call(this),
    (this.setId = ''),
    (this.image = ''),
    Object.defineProperty(this, 'image', {
      get: this.getImage,
      set: this.setImage,
      enumerable: !0
    }),
    (this._defaultLabel = ''),
    (this._hasDefault = !1),
    (this._iconTable = null);
}

function UTImageButtonControl() {
  UTButtonControl.call(this);
}

function UTItemInfoStateViewModel(e) {
  UTObject.call(this),
    (this._configDelegate = e || null),
    Object.defineProperty(this, '_configDelegate', {
      writable: !1,
      enumerable: !1
    }),
    (this._state =
      (this._configDelegate &&
        parseInt(this._configDelegate.getSessionItem('UTItemInfoState'), 10)) ||
      enums.UIItemInfoState.MAIN),
    Object.defineProperty(this, '_state', {
      writable: !0,
      enumerable: !1
    });
}

function UTItemCanvasDTO(e, t, i, s, n, o) {
  UTObject.call(this),
    (this.element = e || null),
    (this.dynamic = t || !1),
    (this.width = i || 0),
    (this.height = s || 0),
    (this.xPos = n || 0),
    (this.yPos = o || 0);
}

function UTItemStatChevronsView() {
  UTView.call(this), this._generate();
}

function UTItemCanvasView() {
  UTView.call(this),
    (this._ctx = null),
    Object.defineProperty(this, '_ctx', {
      writable: !0,
      enumerable: !1
    }),
    (this._colormap = null),
    Object.defineProperty(this, '_ctx', {
      writable: !0,
      enumerable: !1
    }),
    (this.assets = {}),
    (this.size = enums.ItemViewType.LARGE),
    (this.rendered = !1);
}

function UTItemPlayerCanvasView() {
  UTItemCanvasView.call(this),
    (this.renderSpecial = !1),
    (this.renderConcept = !1);
}

function UTItemPlayerLargeView() {
  components.ItemPlayerBase.call(this), this._generate();
}

function UTItemPlayerSmallView() {
  components.ItemPlayerBase.call(this), this._generate();
}

function UTItemManagerCanvasView() {
  UTItemCanvasView.call(this);
}

function UTImageView() {
  UTView.call(this),
    (this.src = ''),
    (this.path = ''),
    (this._useCache = !0),
    Object.defineProperty(this, '_useCache', {
      writable: !0,
      enumerable: !1
    }),
    (this._imageLoadEvent = new UTObservable());
}
NamespaceManager.Register('utils'),
  (utils.ImagePreloader = function ImagePreloader() {
    UTObject.call(this), (this._preloadedImages = new UTHashTable());
  }),
  utils.JS.inherits(utils.ImagePreloader, UTObject),
  (utils.ImagePreloader.prototype.dealloc = function dealloc() {
    this._preloadedImages.clear(), (this._preloadedImages = null);
  }),
  (utils.ImagePreloader.prototype.preloadImages = function preloadImages(e) {
    e = utils.JS.valToArray(e);
    var t = null,
      i = new UTObservable(),
      s = e.length;

    function imgLoaded(e) {
      --s <= 0 && i.notify(),
        e.target.removeEventListener('load', imgLoaded, !1);
    }
    return (
      e.forEach(function(e) {
        this._preloadedImages.has(e)
          ? s--
          : ((t = new Image()).addEventListener('load', imgLoaded, !1),
            (t.src = e),
            this._preloadedImages.set(e, t));
      }, this),
      i
    );
  }),
  NamespaceManager.Register('utils'),
  (utils.UTTimer = function UTTimer(e, t, i) {
    UTObject.call(this),
      (this._workFunc = utils.JS.isFunction(t) ? t : null),
      (this._interval = utils.JS.isNumber(e) && 0 < e ? e : 1e3),
      (this._errorFunc = utils.JS.isFunction(i) ? i : null),
      (this._expected = 0),
      (this._timeout = 0);
  }),
  utils.JS.inherits(utils.UTTimer, UTObject),
  (utils.UTTimer.prototype.dealloc = function dealloc() {
    this.reset(), this.superclass();
  }),
  (utils.UTTimer.prototype.reset = function reset() {
    this.stop(),
      (this._workFunc = null),
      (this._errorFunc = null),
      (this._interval = 0),
      (this._expected = 0);
  }),
  (utils.UTTimer.prototype.setInterval = function setInterval(e) {
    utils.Debug.Assert(
      utils.JS.isNumber(e) && 0 < e,
      'Expected a number greater than 0.'
    ),
      (this._interval = e);
  }),
  (utils.UTTimer.prototype.setWorkFunc = function setWorkFunc(e) {
    utils.Debug.Assert(utils.JS.isFunction(e), 'Expected a function.'),
      (this._workFunc = utils.JS.isFunction(e) ? e : null);
  }),
  (utils.UTTimer.prototype.setErrorFunc = function setErrorFunc(e) {
    utils.Debug.Assert(utils.JS.isFunction(e), 'Expected a function.'),
      (this._errorFunc = utils.JS.isFunction(e) ? e : null);
  }),
  (utils.UTTimer.prototype.start = function start() {
    this.stop(),
      (this._expected = Date.now() + this._interval),
      (this._timeout = setTimeout(this._step.bind(this), this._interval));
  }),
  (utils.UTTimer.prototype.stop = function stop() {
    clearTimeout(this._timeout), (this._timeout = 0);
  }),
  (utils.UTTimer.prototype._step = function _step() {
    var e = Date.now() - this._expected;
    e > this._interval && this._errorFunc && this._errorFunc.call(),
      (this._expected += this._interval),
      (this._timeout = setTimeout(
        this._step.bind(this),
        Math.max(0, this._interval - e)
      )),
      this._workFunc && this._workFunc.call();
  }),
  NamespaceManager.Register('utils'),
  (utils.AD = new (function ADUtil() {})()),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.DataProviderEntry = function UTDataProviderEntryDTO(
    e,
    t,
    i
  ) {
    (this.id = e),
      Object.defineProperty(this, 'id', {
        writable: !1,
        enumerable: !0
      }),
      (this.value = t),
      Object.defineProperty(this, 'value', {
        writable: !1,
        enumerable: !0
      }),
      (this.label = i),
      Object.defineProperty(this, 'label', {
        writable: !1,
        enumerable: !0
      });
  }),
  NamespaceManager.Register('factories'),
  (factories.DataProvider = (function() {
    function DataProviderFactory() {}
    return (
      (DataProviderFactory.prototype.getSearchPileDP = function getSearchPileDP() {
        return [
          new transferobjects.DataProviderEntry(
            0,
            enums.ItemSearchFeature.CLUB,
            services.Localization.localize('search.searchmode.club')
          ),
          new transferobjects.DataProviderEntry(
            1,
            enums.ItemSearchFeature.CONCEPT,
            services.Localization.localize('search.searchmode.database')
          )
        ];
      }),
      (DataProviderFactory.prototype.getClubTypeDP = function getClubTypeDP() {
        return [
          new transferobjects.DataProviderEntry(
            0,
            enums.SearchCategory.KIT,
            services.Localization.localize('clubtype.kit')
          ),
          new transferobjects.DataProviderEntry(
            1,
            enums.SearchCategory.STADIUM,
            services.Localization.localize('search.filters.stadiums')
          ),
          new transferobjects.DataProviderEntry(
            2,
            enums.SearchCategory.BALL,
            services.Localization.localize('search.filters.balls')
          ),
          new transferobjects.DataProviderEntry(
            3,
            enums.SearchCategory.BADGE,
            services.Localization.localize('clubtype.badge')
          )
        ];
      }),
      (DataProviderFactory.prototype.getTeamDP = function getTeamDP(i) {
        var e = repositories.TeamConfig.getTeamsByYear(enums.Year.ASSET),
          t = [];

        function _generateDataRow(e) {
          return new transferobjects.DataProviderEntry(
            e.id,
            e.id.toString(),
            e.name
          );
        }
        return (
          (t =
            utils.JS.isNumber(i) && 0 <= i
              ? e.reduce(function(e, t) {
                  return i === t.league && e.push(_generateDataRow(t)), e;
                }, [])
              : e.map(_generateDataRow)).unshift(
            new transferobjects.DataProviderEntry(
              -1,
              '-1',
              services.Localization.localize('roles.defaultRole')
            )
          ),
          t
        );
      }),
      (DataProviderFactory.prototype.getCustomTeamDP = function getCustomTeamDP(
        e
      ) {
        e = !!e;
        var t = [];
        return (
          (t = repositories.TeamConfig.getCustomTeamsByYear(
            enums.Year.ASSET
          ).map(function(e) {
            return new transferobjects.DataProviderEntry(
              e.id,
              e.id.toString(),
              e.name
            );
          })),
          e &&
            t.unshift(
              new transferobjects.DataProviderEntry(
                -1,
                '-1',
                services.Localization.localize('roles.defaultRole')
              )
            ),
          t
        );
      }),
      (DataProviderFactory.prototype.getLeagueDP = function getLeagueDP(e) {
        var t,
          i = repositories.TeamConfig.getLeaguesByYear(enums.Year.ASSET),
          s = [],
          n = [],
          o = [],
          a = [],
          r = [
            'ENG 1',
            'ENG 2',
            'ENG 3',
            'ENG 4',
            'FRA 1',
            'FRA 2',
            'ITA 1',
            'ITA 2',
            'GER 1',
            'GER 2',
            'GER 3',
            'ESP 1',
            'ESP 2'
          ],
          l = {};
        for (t = 0; t < r.length; t++) l[r[t]] = t;
        var c,
          u = ['AUT 1', 'CZE 1'],
          d = {};
        for (c = 0; c < u.length; c++) d[u[c]] = c;
        return (
          i.forEach(function(e) {
            0 <= r.indexOf(e.abbreviation)
              ? n.push(e)
              : 0 <= u.indexOf(e.abbreviation)
              ? o.push(e)
              : a.push(e);
          }),
          n.sort(function(e, t) {
            return l[e.abbreviation] - l[t.abbreviation];
          }),
          o.sort(function(e, t) {
            return d[e.abbreviation] - d[t.abbreviation];
          }),
          (i = n.concat(a).concat(o)),
          (s = e
            ? i.reduce(function(e, t) {
                return (
                  t.id !== REWARDS_LEAGUE_ID &&
                    e.push(
                      new transferobjects.DataProviderEntry(
                        t.id,
                        t.id.toString(),
                        t.name + ' (' + t.abbreviation + ')'
                      )
                    ),
                  e
                );
              }, [])
            : i.map(function(e) {
                return new transferobjects.DataProviderEntry(
                  e.id,
                  e.id.toString(),
                  e.name + ' (' + e.abbreviation + ')'
                );
              })).unshift(
            new transferobjects.DataProviderEntry(
              -1,
              '-1',
              services.Localization.localize('roles.defaultRole')
            )
          ),
          s
        );
      }),
      (DataProviderFactory.prototype.getNationDP = function getNationDP(e) {
        e || (e = enums.Year.ASSET);
        var t = TOP_NINE_NATIONS.map(function(e) {
            return new transferobjects.DataProviderEntry(
              e,
              e.toString(),
              utils.FUTLocalization.getNationNameById(e)
            );
          }),
          i = repositories.TeamConfig.getNationsByYear(e).map(function(e) {
            return new transferobjects.DataProviderEntry(
              e.id,
              e.id.toString(),
              e.name
            );
          });
        return [
          new transferobjects.DataProviderEntry(
            -1,
            -1,
            services.Localization.localize('roles.defaultRole')
          )
        ].concat(t, i);
      }),
      (DataProviderFactory.prototype.getPositionModifierDP = function getPositionModifierDP() {
        return [
          new transferobjects.DataProviderEntry(
            -1,
            'any',
            services.Localization.localize('roles.defaultRole')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_LWB_LB,
            'LWB-LB',
            services.Localization.localize('posmods.lwbtolb')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_LB_LWB,
            'LB-LWB',
            services.Localization.localize('posmods.lbtolwb')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_RWB_RB,
            'RWB-RB',
            services.Localization.localize('posmods.rwbtorb')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_RB_RWB,
            'RB-RWB',
            services.Localization.localize('posmods.rbtorwb')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_LM_LW,
            'LM-LW',
            services.Localization.localize('posmods.lmtolw')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_LW_LM,
            'LW-LM',
            services.Localization.localize('posmods.lwtolm')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_RM_RW,
            'RM-RW',
            services.Localization.localize('posmods.rmtorw')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_RW_RM,
            'RW-RM',
            services.Localization.localize('posmods.rwtorm')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_LW_LF,
            'LW-LF',
            services.Localization.localize('posmods.lwtolf')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_LF_LW,
            'LF-LW',
            services.Localization.localize('posmods.lftolw')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_RW_RF,
            'RW-RF',
            services.Localization.localize('posmods.rwtorf')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_RF_RW,
            'RF-RW',
            services.Localization.localize('posmods.rftorw')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_CM_CAM,
            'CM-CAM',
            services.Localization.localize('posmods.cmtocam')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_CAM_CM,
            'CAM-CM',
            services.Localization.localize('posmods.camtocm')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_CM_CDM,
            'CM-CDM',
            services.Localization.localize('posmods.cmtocdm')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_CDM_CM,
            'CDM-CM',
            services.Localization.localize('posmods.cdmtocm')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_CAM_CF,
            'CAM-CF',
            services.Localization.localize('posmods.camtocf')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_CF_CAM,
            'CF-CAM',
            services.Localization.localize('posmods.cftocam')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_CF_ST,
            'CF-ST',
            services.Localization.localize('posmods.cftost')
          ),
          new transferobjects.DataProviderEntry(
            enums.ItemSubType.TRAINING_PLAYER_POS_ST_CF,
            'ST-CF',
            services.Localization.localize('posmods.sttocf')
          )
        ];
      }),
      (DataProviderFactory.prototype.getPlayerPositionDP = function getPlayerPositionDP(
        t
      ) {
        var i = [];
        return (
          PLAYER_ZONE_LOOKUP.forEach(function(e) {
            ((t && 'any' !== e.value) || (!t && 'noGK' !== e.value)) &&
              i.push(
                new transferobjects.DataProviderEntry(
                  e.id,
                  e.value,
                  services.Localization.localize(e.label)
                )
              );
          }),
          SEARCHABLE_POSITIONS.forEach(function(e) {
            var t = repositories.Squad.getPosition(e);
            i.push(
              new transferobjects.DataProviderEntry(
                t.getId(),
                t.getTypeName(),
                utils.FUTLocalization.getLocalizedPositionStringById(
                  t.getTypeId()
                )
              )
            );
          }),
          i
        );
      }),
      (DataProviderFactory.prototype.getPlayStyleDP = function getPlayStyleDP(
        e
      ) {
        function _generatePlayStyleDPObject(e) {
          return new transferobjects.DataProviderEntry(
            e,
            e,
            utils.FUTLocalization.getPlaystyleByID(e)
          );
        }
        var t = [
          new transferobjects.DataProviderEntry(
            -1,
            -1,
            services.Localization.localize('roles.defaultRole')
          )
        ];
        return (
          (utils.JS.isBoolean(e) && e) ||
            (t = t.concat([
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_1
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_2
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_3
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_4
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_5
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_6
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_7
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_8
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_9
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_10
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_11
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_12
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_13
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_14
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_15
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_16
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_17
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_18
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GENERAL_19
              )
            ])),
          (utils.JS.isBoolean(e) && !e) ||
            (t = t.concat([
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GOALKEEPER_1
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GOALKEEPER_2
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GOALKEEPER_3
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GOALKEEPER_4
              ),
              _generatePlayStyleDPObject(
                enums.ItemSubType.TRAINING_PLAYERSTYLE_GOALKEEPER_5
              )
            ])),
          t
        );
      }),
      (DataProviderFactory.prototype.getItemLevelDP = function getItemLevelDP(
        e
      ) {
        var t = [
          new transferobjects.DataProviderEntry(
            -1,
            enums.SearchLevel.ANY,
            services.Localization.localize('roles.defaultRole')
          ),
          new transferobjects.DataProviderEntry(
            0,
            enums.SearchLevel.BRONZE,
            services.Localization.localize('search.cardLevels.cardLevel1')
          ),
          new transferobjects.DataProviderEntry(
            1,
            enums.SearchLevel.SILVER,
            services.Localization.localize('search.cardLevels.cardLevel2')
          ),
          new transferobjects.DataProviderEntry(
            2,
            enums.SearchLevel.GOLD,
            services.Localization.localize('search.cardLevels.cardLevel3')
          )
        ];
        return (
          e &&
            t.push(
              new transferobjects.DataProviderEntry(
                3,
                enums.SearchLevel.SPECIAL,
                services.Localization.localize('search.cardLevels.cardLevel4')
              )
            ),
          t
        );
      }),
      (DataProviderFactory.prototype.getFormationDP = function getFormationDP() {
        return repositories.Squad.getFormations().map(function(e) {
          return new transferobjects.DataProviderEntry(
            e.getId(),
            e.getName(),
            e.getDisplayName()
          );
        });
      }),
      (DataProviderFactory.prototype.getStaffTypeDP = function getStaffTypeDP() {
        return [
          new transferobjects.DataProviderEntry(
            -1,
            enums.SearchCategory.ANY,
            services.Localization.localize('roles.defaultRole')
          ),
          new transferobjects.DataProviderEntry(
            0,
            enums.SearchCategory.MANAGER,
            services.Localization.localize('roles.manager')
          ),
          new transferobjects.DataProviderEntry(
            1,
            enums.SearchCategory.COACH_HEAD,
            services.Localization.localize('roles.headCoach')
          ),
          new transferobjects.DataProviderEntry(
            2,
            enums.SearchCategory.COACH_GK,
            services.Localization.localize('roles.GKCoach')
          ),
          new transferobjects.DataProviderEntry(
            3,
            enums.SearchCategory.COACH_FITNESS,
            services.Localization.localize('roles.fitnessCoach')
          ),
          new transferobjects.DataProviderEntry(
            4,
            enums.SearchCategory.PHYSIO,
            services.Localization.localize('roles.physio')
          )
        ];
      }),
      (DataProviderFactory.prototype.getConsumableTypeDP = function getConsumableTypeDP() {
        return [
          new transferobjects.DataProviderEntry(
            0,
            enums.SearchCategory.PLAYER_TRAINING,
            services.Localization.localize('trainingtype.playerTraining')
          ),
          new transferobjects.DataProviderEntry(
            1,
            enums.SearchCategory.GK_TRAINING,
            services.Localization.localize('trainingtype.GKTraining')
          ),
          new transferobjects.DataProviderEntry(
            2,
            enums.SearchCategory.POSITION,
            services.Localization.localize('trainingtype.position')
          ),
          new transferobjects.DataProviderEntry(
            3,
            enums.SearchCategory.PLAYSTYLE,
            services.Localization.localize('trainingtype.playStyle')
          ),
          new transferobjects.DataProviderEntry(
            4,
            enums.SearchCategory.MANAGER_LEAGUE,
            services.Localization.localize('trainingtype.managerLeague')
          ),
          new transferobjects.DataProviderEntry(
            5,
            enums.SearchCategory.CONTRACT,
            services.Localization.localize('devtype.contract')
          ),
          new transferobjects.DataProviderEntry(
            6,
            enums.SearchCategory.FITNESS,
            services.Localization.localize('devtype.fitness')
          ),
          new transferobjects.DataProviderEntry(
            7,
            enums.SearchCategory.HEALING,
            services.Localization.localize('devtype.healing')
          )
        ];
      }),
      (DataProviderFactory.prototype.getSortTypeDP = function getSortTypeDP() {
        return [
          new transferobjects.DataProviderEntry(
            enums.SearchSortType.VALUE_DESC,
            enums.SearchSort.DESCENDING,
            services.Localization.localize('search.sort.highestValue')
          ),
          new transferobjects.DataProviderEntry(
            enums.SearchSortType.VALUE_ASC,
            enums.SearchSort.ASCENDING,
            services.Localization.localize('search.sort.lowestValue')
          ),
          new transferobjects.DataProviderEntry(
            enums.SearchSortType.RECENCY_DESC,
            enums.SearchSort.DESCENDING,
            services.Localization.localize('search.sort.mostRecent')
          )
        ];
      }),
      (DataProviderFactory.prototype.getTacticOffensiveStyleDP = function getTacticOffensiveStyleDP() {
        return [
          new transferobjects.DataProviderEntry(
            0,
            UTSquadMentalityEntity.OFFENSIVE_STYLE.POSSESSION,
            services.Localization.localize(
              'tactics.mentality.style.offensive.0'
            )
          ),
          new transferobjects.DataProviderEntry(
            1,
            UTSquadMentalityEntity.OFFENSIVE_STYLE.BALANCED,
            services.Localization.localize(
              'tactics.mentality.style.offensive.1'
            )
          ),
          new transferobjects.DataProviderEntry(
            2,
            UTSquadMentalityEntity.OFFENSIVE_STYLE.LONG_BALL,
            services.Localization.localize(
              'tactics.mentality.style.offensive.2'
            )
          ),
          new transferobjects.DataProviderEntry(
            3,
            UTSquadMentalityEntity.OFFENSIVE_STYLE.FAST_BUILD_UP,
            services.Localization.localize(
              'tactics.mentality.style.offensive.3'
            )
          )
        ];
      }),
      (DataProviderFactory.prototype.getTacticDefensiveStyleDP = function getTacticDefensiveStyleDP() {
        return [
          new transferobjects.DataProviderEntry(
            0,
            UTSquadMentalityEntity.DEFENSIVE_STYLE.DROP_BACK,
            services.Localization.localize(
              'tactics.mentality.style.defensive.0'
            )
          ),
          new transferobjects.DataProviderEntry(
            1,
            UTSquadMentalityEntity.DEFENSIVE_STYLE.BALANCED,
            services.Localization.localize(
              'tactics.mentality.style.defensive.1'
            )
          ),
          new transferobjects.DataProviderEntry(
            2,
            UTSquadMentalityEntity.DEFENSIVE_STYLE.PRESSURE_ON_HEAVY_TOUCH,
            services.Localization.localize(
              'tactics.mentality.style.defensive.2'
            )
          ),
          new transferobjects.DataProviderEntry(
            3,
            UTSquadMentalityEntity.DEFENSIVE_STYLE.PRESS_AFTER_POSSESSION_LOSS,
            services.Localization.localize(
              'tactics.mentality.style.defensive.3'
            )
          ),
          new transferobjects.DataProviderEntry(
            4,
            UTSquadMentalityEntity.DEFENSIVE_STYLE.CONSTANT_PRESSURE,
            services.Localization.localize(
              'tactics.mentality.style.defensive.4'
            )
          )
        ];
      }),
      new DataProviderFactory()
    );
  })()),
  utils.JS.inherits(UTNimbleMTXItemEntity, UTObject),
  (UTNimbleMTXItemEntity.prototype.setTitle = function setTitle(e) {
    this.title = isAndroid() ? e.replace(/ *\([^)]*\) */g, ' ').trim() : e;
  }),
  (UTNimbleMTXItemEntity.prototype.getLocalImageAssetId = function getLocalImageAssetId() {
    return 1600 < this.points
      ? 2
      : this.points <= 1600 && 800 <= this.points
      ? 1
      : 0;
  }),
  utils.JS.inherits(UTNimbleMTXItemFactory, UTObject),
  (UTNimbleMTXItemFactory.prototype.generateMTXItem = function generateMTXItem(
    e
  ) {
    var t = new UTNimbleMTXItemEntity(e.sku);
    return (
      t.setTitle(e.title),
      (t.price = e.price),
      (t.priceFormatted = e.priceFormatted),
      (t.type = e.type),
      (t.currency = e.currency),
      t
    );
  }),
  (UTNimbleMTXItemFactory.prototype.generateMTXItemArray = function generateMTXItemArray(
    e
  ) {
    return e.map(function(e) {
      return this.generateMTXItem(e);
    }, this);
  }),
  NamespaceManager.Register('factories'),
  (factories.UTNimbleMTXItem = new UTNimbleMTXItemFactory()),
  NamespaceManager.Register('interfaces'),
  (interfaces.ListItem = function IListItem() {}),
  (interfaces.ListItem.prototype.getItemData = function getItemData() {}),
  (interfaces.ListItem.prototype.getAuctionData = function getAuctionData() {}),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.StaticItemData = function UTStaticItemDataDTO() {
    UTObject.call(this),
      (this.assetId = 0),
      (this.assetType = ''),
      (this.assetYear = -1),
      (this.amount = 0),
      (this.name = enums.Localization.BLANK_STR),
      (this.firstName = enums.Localization.BLANK_STR),
      (this.lastName = enums.Localization.BLANK_STR),
      (this.knownAs = enums.Localization.BLANK_STR),
      (this.description = ''),
      (this.manufacturer = ''),
      (this.trainedAttribute = -1),
      (this.trainPosFrom = ''),
      (this.trainPosTo = ''),
      (this.goldBoost = 0),
      (this.silverBoost = 0),
      (this.bronzeBoost = 0);
  }),
  utils.JS.inherits(transferobjects.StaticItemData, UTObject),
  (transferobjects.StaticItemData.prototype.parseDynamicItemData = function(
    e,
    t
  ) {
    this.amount = t.amount || 0;
  }),
  (transferobjects.StaticItemData.prototype.generateNameData = function generateNameData(
    e,
    t,
    i
  ) {
    (this.firstName = e || enums.Localization.BLANK_STR),
      (this.lastName = t || enums.Localization.BLANK_STR),
      (this.knownAs = i || enums.Localization.BLANK_STR),
      (this.name =
        this.knownAs === enums.Localization.BLANK_STR
          ? this.lastName
          : this.knownAs);
  }),
  (transferobjects.StaticItemData.prototype.getFullName = function getFullName() {
    return this.knownAs === enums.Localization.BLANK_STR
      ? this.firstName + ' ' + this.lastName
      : this.knownAs;
  }),
  (transferobjects.StaticItemData.prototype.hasLoanPackDescription = function hasLoanPackDescription() {
    return 'FreeLoanPackDesc' === this.description;
  }),
  (transferobjects.StaticPlayerItemData = function UTStaticPlayerItemDataDTO() {
    transferobjects.StaticItemData.call(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticPlayerItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticPlayerItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t),
      this.generateNameData(t.firstName, t.lastName, t.knownAs);
  }),
  (transferobjects.StaticPlayerItemData.prototype.hasNameData = function hasNameData() {
    return (
      this.firstName !== enums.Localization.BLANK_STR ||
      this.lastName !== enums.Localization.BLANK_STR ||
      this.knownAs !== enums.Localization.BLANK_STR
    );
  }),
  (transferobjects.StaticManagerItemData = function UTStaticManagerItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticManagerItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticManagerItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t),
      (this.firstName = t.firstName || enums.Localization.BLANK_STR),
      (this.lastName = t.lastName || enums.Localization.BLANK_STR),
      (this.knownAs = t.commonname || enums.Localization.BLANK_STR),
      (this.lastName === enums.Localization.BLANK_STR ||
        utils.JS.isEmpty(this.lastName.trim())) &&
        (this.knownAs = this.firstName),
      (this.amount = t.negotiation || 0),
      this.firstName === enums.Localization.BLANK_STR &&
      this.lastName === enums.Localization.BLANK_STR &&
      this.knownAs === enums.Localization.BLANK_STR
        ? (this.name = enums.Localization.BLANK_STR)
        : (this.name =
            this.knownAs === enums.Localization.BLANK_STR
              ? this.firstName.charAt(0) + '. ' + this.lastName
              : this.knownAs);
  }),
  (transferobjects.StaticStaffItemData = function UTStaticStaffItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticStaffItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticStaffItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t),
      (this.firstName = t.firstName || enums.Localization.BLANK_STR),
      (this.lastName = t.lastName || enums.Localization.BLANK_STR),
      (this.name = this.firstName.trim() + '. ' + this.lastName.trim()),
      (this.trainedAttribute = parseInt(t.attribute, 10) || 0);
  }),
  (transferobjects.StaticBadgeItemData = function UTStaticBadgeItemDataDTO() {
    transferobjects.StaticItemData.apply(this),
      (this.name = services.Localization.localize('card.title.badge'));
  }),
  utils.JS.inherits(
    transferobjects.StaticBadgeItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticBadgeItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t), (this.assetId = parseInt(t.assetId, 10) || 0);
  }),
  NamespaceManager.Register('valueobjects'),
  (transferobjects.StaticKitItemData = function UTStaticKitItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticKitItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticKitItemData.CATEGORY_KIT_HOME = 2),
  (transferobjects.StaticKitItemData.CATEGORY_KIT_AWAY = 3),
  (transferobjects.StaticKitItemData.CATEGORY_KIT_THIRD = 5),
  (transferobjects.StaticKitItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t);
    var i = parseInt(t.category, 10) || 0;
    (this.assetYear = parseInt(t.year, 10) || 0),
      (this.name = services.Localization.localize('clubtype.kit')),
      i === transferobjects.StaticKitItemData.CATEGORY_KIT_HOME
        ? ((this.description = services.Localization.localize(
            'card.desc.homekit'
          )),
          (this.assetType = utils.AssetLocator.IMAGE_TYPE_KIT_HOME))
        : i === transferobjects.StaticKitItemData.CATEGORY_KIT_AWAY
        ? ((this.description = services.Localization.localize(
            'card.desc.awaykit'
          )),
          (this.assetType = utils.AssetLocator.IMAGE_TYPE_KIT_AWAY))
        : ((this.description = services.Localization.localize(
            'card.desc.thirdkit'
          )),
          (this.assetType = utils.AssetLocator.IMAGE_TYPE_KIT_THIRD)),
      0 < this.assetYear &&
        (this.description = services.Localization.localize(
          'card.desc.classickit'
        ));
  }),
  (transferobjects.StaticBallItemData = function UTStaticBallItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticBallItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticBallItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t),
      (this.assetId = parseInt(t.assetId, 10) || 0),
      (this.name = services.Localization.localize('club.edit.ballLabel')),
      (this.description = t.name || 'BallName_' + this.assetId),
      (this.manufacturer = t.manufacturer || '');
  }),
  NamespaceManager.Register('valueobjects'),
  (transferobjects.StaticStadiumItemData = function UTStaticStadiumItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticStadiumItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticStadiumItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t),
      (this.name = services.Localization.localize('club.edit.stadiumLabel')),
      (this.assetId =
        parseInt(t.stadiumid, 10) || parseInt(t.assetId, 10) || 0),
      (this.description = services.Localization.localize(
        'global.stadiumFull.' + APP_YEAR + '.stadium' + this.assetId
      ));
  }),
  (transferobjects.StaticTrainingItemData = function UTStaticTrainingItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticTrainingItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticTrainingItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t);
    var i = e.subtype;
    if (e.isGKTraining())
      switch (
        ((this.name = services.Localization.localize(
          'card.desc.training.goalkeeper'
        )),
        (this.assetType = utils.AssetLocator.IMAGE_TYPE_TRAINING_GKATTRIB),
        i)
      ) {
        case enums.ItemSubType.TRAINING_GK_DIVING:
          (this.assetId = 0), (this.trainedAttribute = 0);
          break;
        case enums.ItemSubType.TRAINING_GK_HANDLING:
          (this.assetId = 1), (this.trainedAttribute = 1);
          break;
        case enums.ItemSubType.TRAINING_GK_KICKING:
          (this.assetId = 2), (this.trainedAttribute = 2);
          break;
        case enums.ItemSubType.TRAINING_GK_SPEED:
          (this.assetId = 4), (this.trainedAttribute = 4);
          break;
        case enums.ItemSubType.TRAINING_GK_POSITION:
          (this.assetId = 5), (this.trainedAttribute = 5);
          break;
        case enums.ItemSubType.TRAINING_GK_REFLEX:
          (this.assetId = 3), (this.trainedAttribute = 3);
          break;
        case enums.ItemSubType.TRAINING_GK_ALL:
          (this.assetId = 6), (this.trainedAttribute = 6);
      }
    else if (e.isPlayerTraining())
      switch (
        ((this.name = services.Localization.localize(
          'card.desc.contract.player'
        )),
        (this.assetType = utils.AssetLocator.IMAGE_TYPE_TRAINING_PLAYERATTRIB),
        i)
      ) {
        case enums.ItemSubType.TRAINING_PLAYER_PACE:
          (this.assetId = 0), (this.trainedAttribute = 0);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_SHOOTING:
          (this.assetId = 1), (this.trainedAttribute = 1);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_PASSING:
          (this.assetId = 2), (this.trainedAttribute = 2);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_DRIBBLING:
          (this.assetId = 3), (this.trainedAttribute = 3);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_HEADING:
          (this.assetId = 5), (this.trainedAttribute = 5);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_DEFEND:
          (this.assetId = 4), (this.trainedAttribute = 4);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_ALL:
          (this.assetId = 6), (this.trainedAttribute = 6);
      }
    else if (e.isPlayerPositionModifier())
      switch (
        ((this.name = services.Localization.localize('card.title.position')),
        (this.assetId = utils.AssetLocator.ASSET_ID_PLAYER),
        (this.assetType = utils.AssetLocator.IMAGE_TYPE_TRAINING_POSITION),
        i)
      ) {
        case enums.ItemSubType.TRAINING_PLAYER_POS_LWB_LB:
          (this.trainPosFrom = enums.PlayerPositions.LWB),
            (this.trainPosTo = enums.PlayerPositions.LB);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_LB_LWB:
          (this.trainPosFrom = enums.PlayerPositions.LB),
            (this.trainPosTo = enums.PlayerPositions.LWB);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_RWB_RB:
          (this.trainPosFrom = enums.PlayerPositions.RWB),
            (this.trainPosTo = enums.PlayerPositions.RB);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_RB_RWB:
          (this.trainPosFrom = enums.PlayerPositions.RB),
            (this.trainPosTo = enums.PlayerPositions.RWB);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_LM_LW:
          (this.trainPosFrom = enums.PlayerPositions.LM),
            (this.trainPosTo = enums.PlayerPositions.LW);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_RM_RW:
          (this.trainPosFrom = enums.PlayerPositions.RM),
            (this.trainPosTo = enums.PlayerPositions.RW);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_LW_LM:
          (this.trainPosFrom = enums.PlayerPositions.LW),
            (this.trainPosTo = enums.PlayerPositions.LM);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_RW_RM:
          (this.trainPosFrom = enums.PlayerPositions.RW),
            (this.trainPosTo = enums.PlayerPositions.RM);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_LW_LF:
          (this.trainPosFrom = enums.PlayerPositions.LW),
            (this.trainPosTo = enums.PlayerPositions.LF);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_RW_RF:
          (this.trainPosFrom = enums.PlayerPositions.RW),
            (this.trainPosTo = enums.PlayerPositions.RF);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_LF_LW:
          (this.trainPosFrom = enums.PlayerPositions.LF),
            (this.trainPosTo = enums.PlayerPositions.LW);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_RF_RW:
          (this.trainPosFrom = enums.PlayerPositions.RF),
            (this.trainPosTo = enums.PlayerPositions.RW);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_CM_CAM:
          (this.trainPosFrom = enums.PlayerPositions.CM),
            (this.trainPosTo = enums.PlayerPositions.CAM);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_CAM_CM:
          (this.trainPosFrom = enums.PlayerPositions.CAM),
            (this.trainPosTo = enums.PlayerPositions.CM);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_CDM_CM:
          (this.trainPosFrom = enums.PlayerPositions.CDM),
            (this.trainPosTo = enums.PlayerPositions.CM);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_CM_CDM:
          (this.trainPosFrom = enums.PlayerPositions.CM),
            (this.trainPosTo = enums.PlayerPositions.CDM);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_CAM_CF:
          (this.trainPosFrom = enums.PlayerPositions.CAM),
            (this.trainPosTo = enums.PlayerPositions.CF);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_CF_CAM:
          (this.trainPosFrom = enums.PlayerPositions.CF),
            (this.trainPosTo = enums.PlayerPositions.CAM);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_CF_ST:
          (this.trainPosFrom = enums.PlayerPositions.CF),
            (this.trainPosTo = enums.PlayerPositions.ST);
          break;
        case enums.ItemSubType.TRAINING_PLAYER_POS_ST_CF:
          (this.trainPosFrom = enums.PlayerPositions.ST),
            (this.trainPosTo = enums.PlayerPositions.CF);
      }
    else
      e.isManagerLeagueModifier()
        ? ((this.name = services.Localization.localize(
            'card.title.leaguechange'
          )),
          (this.assetType = utils.AssetLocator.IMAGE_TYPE_TRAINING_LEAGUEMOD),
          (e.leagueId = this.amount))
        : e.isStyleModifier()
        ? ((this.name = services.Localization.localize('card.title.playstyle')),
          (this.assetType = utils.AssetLocator.IMAGE_TYPE_TRAINING_PLAYSTYLE))
        : utils.Debug.Assert(!1, 'Unknown item subtype: ' + i);
  }),
  (transferobjects.StaticHealingItemData = function UTStaticHealingItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticHealingItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticHealingItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    if ((this.superclass(e, t), e.isPlayerFitness()))
      (this.name = services.Localization.localize('card.desc.contract.player')),
        (this.assetType = utils.AssetLocator.IMAGE_TYPE_HEALING_FITNESS),
        (this.assetId = utils.AssetLocator.ASSET_ID_PLAYER);
    else if (e.isTeamFitness())
      (this.name = services.Localization.localize('card.desc.healing.squad')),
        (this.assetType = utils.AssetLocator.IMAGE_TYPE_HEALING_FITNESS),
        (this.assetId = utils.AssetLocator.ASSET_ID_TEAM);
    else if (e.isInjuryHealing())
      switch (
        ((this.name = services.Localization.localize(
          'card.desc.contract.player'
        )),
        (this.assetType = utils.AssetLocator.IMAGE_TYPE_HEALING_INJURY),
        e.subtype)
      ) {
        case enums.ItemSubType.HEALING_HEAD:
          this.assetId = 0;
          break;
        case enums.ItemSubType.HEALING_SHOULDER:
          this.assetId = 1;
          break;
        case enums.ItemSubType.HEALING_ARM:
          this.assetId = 2;
          break;
        case enums.ItemSubType.HEALING_BACK:
          this.assetId = 3;
          break;
        case enums.ItemSubType.HEALING_HIP:
          this.assetId = 4;
          break;
        case enums.ItemSubType.HEALING_LEG:
          this.assetId = 5;
          break;
        case enums.ItemSubType.HEALING_FOOT:
          this.assetId = 6;
          break;
        case enums.ItemSubType.HEALING_ALL:
          this.assetId = 7;
      }
    else utils.Debug.Assert(!1, 'Unknown item subtype: ' + e.subtype);
  }),
  (transferobjects.StaticContractItemData = function UTStaticContractItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticContractItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticContractItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t),
      (this.assetType = utils.AssetLocator.IMAGE_TYPE_CONTRACT);
    var i = e.isManagerContract();
    (this.assetId = i ? 1 : 0),
      (this.name = services.Localization.localize(
        i ? 'card.desc.contract.manager' : 'card.desc.contract.player'
      )),
      t.bronze && (this.bronzeBoost = parseInt(t.bronze, 10)),
      t.silver && (this.silverBoost = parseInt(t.silver, 10)),
      t.gold && (this.goldBoost = parseInt(t.gold, 10));
  }),
  (transferobjects.StaticMiscItemData = function UTStaticMiscItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticMiscItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticMiscItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    switch (
      (this.superclass(e, t),
      (this.name = services.Localization.localize('card.title.unlock')),
      (this.description = t.description || ''),
      e.subtype)
    ) {
      case enums.ItemSubType.FREE_COINS:
        (this.assetType = utils.AssetLocator.IMAGE_TYPE_BOOST_COIN),
          (this.assetId = utils.AssetLocator.ASSET_ID_DEFAULT);
        break;
      case enums.ItemSubType.DRAFT_TOKEN:
        (this.assetType = utils.AssetLocator.IMAGE_TYPE_DRAFT_TOKEN),
          (this.assetId = utils.AssetLocator.ASSET_ID_DEFAULT);
        break;
      case enums.ItemSubType.PLAYER_PICK_ITEM:
        utils.JS.isEmpty(t.name) || (this.name = t.name),
          (this.assetType = utils.AssetLocator.IMAGE_TYPE_PLAYER_PICK_ITEM),
          (this.assetId = utils.AssetLocator.ASSET_ID_DEFAULT);
        break;
      case enums.ItemSubType.FREE_PACK:
        (this.assetType = utils.AssetLocator.IMAGE_TYPE_BOOST_PACK),
          e.isBronzeRating()
            ? (this.assetId = utils.AssetLocator.ASSET_ID_BRONZE_PACK)
            : e.isSilverRating()
            ? (this.assetId = utils.AssetLocator.ASSET_ID_SILVER_PACK)
            : (this.assetId = utils.AssetLocator.ASSET_ID_GOLD_PACK);
    }
  }),
  (transferobjects.StaticBannerItemData = function UTStaticBannerItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticBannerItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticBannerItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t),
      (this.assetId = parseInt(t.assetId, 10) || 0),
      (this.description = t.description || ''),
      (this.name = 'FUT_BannerName_' + this.assetId);
  }),
  (transferobjects.StaticCelebrationItemData = function UTStaticCelebrationItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticCelebrationItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticCelebrationItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t);
    var i = parseInt(t.resourceId, 10) || 0;
    (this.assetId = parseInt(t.cardassetid, 10) || 0),
      (this.description = t.description || ''),
      (this.name = 'FUT_CelebrationName_' + i);
  }),
  (transferobjects.StaticTifoItemData = function UTStaticTifoItemDataDTO() {
    transferobjects.StaticItemData.apply(this);
  }),
  utils.JS.inherits(
    transferobjects.StaticTifoItemData,
    transferobjects.StaticItemData
  ),
  (transferobjects.StaticTifoItemData.prototype.parseDynamicItemData = function parseDynamicItemData(
    e,
    t
  ) {
    this.superclass(e, t),
      (this.assetId = parseInt(t.assetId, 10) || 0),
      (this.description = t.description || ''),
      (this.name = 'FUT_TifoName_' + this.assetId);
  }),
  NamespaceManager.Register('entities'),
  (entities.Item = function UTItemEntity(e) {
    var i = enums.ItemType.PLAYER;
    Object.defineProperty(this, 'type', {
      set: function(e) {
        var t;
        if (i !== e)
          for (t in enums.ItemType)
            if (enums.ItemType.hasOwnProperty(t)) return void (i = e);
      },
      get: function() {
        return i;
      },
      enumerable: !0
    });
    var s = enums.FUTItemPile.ANY;
    Object.defineProperty(this, 'pile', {
      set: function(e) {
        var t;
        if (s !== e)
          for (t in enums.FUTItemPile)
            if (enums.FUTItemPile.hasOwnProperty(t)) return void (s = e);
      },
      get: function() {
        return s;
      },
      enumerable: !0
    });
    var n = enums.ItemState.FREE;
    Object.defineProperty(this, 'state', {
      set: function(e) {
        var t;
        if (n !== e)
          for (t in enums.ItemState)
            if (enums.ItemState.hasOwnProperty(t)) return void (n = e);
      },
      get: function() {
        return n;
      },
      enumerable: !0
    }),
      (this.onDataUpdated = new UTObservable()),
      Object.defineProperty(this, 'onDataUpdated', {
        writable: !1,
        enumerable: !0
      }),
      (this.id = 0),
      (this.resourceId = 0),
      (this.iconId = 0),
      (this.type = utils.JS.isValid(e) ? e : enums.ItemType.PLAYER),
      (this._assetId = enums.ItemCardAssetId.NONE),
      Object.defineProperty(this, '_assetId', {
        writable: !0,
        enumerable: !1
      }),
      (this.subtype = enums.ItemSubType.NONE),
      (this.lastSalePrice = 0),
      (this.discardValue = 0),
      (this.state = enums.ItemState.FREE),
      (this.untradeable = !0),
      (this.untradeableCount = 0),
      (this.concept = !1),
      (this.contract = -1),
      (this.teamId = -1),
      (this.leagueId = -1),
      (this.nationId = -1),
      (this.loans = -1),
      (this.fitness = -1),
      (this.injuryType = enums.PlayerInjury.NONE),
      (this.injuryGames = 0),
      (this.preferredPosition = -1),
      (this._attributes = [0, 0, 0, 0, 0, 0]),
      (this._lifetimeStats = [0, 0, 0, 0]),
      (this._stats = [0, 0, 0, 0]),
      (this._skillMoves = -1),
      (this._weakFoot = -1),
      (this._offensiveWorkRate = -1),
      (this._defensiveWorkRate = -1),
      (this._preferredFoot = -1),
      (this.training = 0),
      (this._auction = new entities.Auction()),
      (this.duplicateId = 0),
      (this.duplicateItemLoans = -1),
      (this.playStyle = 0),
      (this.loyaltyBonus = 0),
      (this.pile = enums.FUTItemPile.ANY),
      (this.amount = 0),
      (this.stackCount = 0),
      (this.rareflag = entities.Item.Rarity.NONE),
      (this.groups = []),
      (this.rating = 0),
      (this.hasLevels = !1),
      (this.owners = 0),
      (this.timestamp = 0),
      (this._itemPriceLimits = null),
      (this._staticData = this._generateStaticData()),
      (this._trainingItem = null),
      (this._metaData = null);
  }),
  (entities.Item.Rarity = {
    NONE: 0,
    RARE: 1,
    ICON: 12,
    PRIMEICON: 84,
    CHAMPIONS_COMMON: 47,
    CHAMPIONS_RARE: 48,
    CHAMPIONS_MOTM: 49,
    CHAMPIONS_LIVE: 50,
    CHAMPIONS_SBC: 69,
    CHAMPIONS_TOTT: 70
  }),
  Object.freeze(entities.Item.Rarity),
  (entities.Item.prototype.activate = function activate(e) {
    if ((this.clearAuction(), this.isBadge()))
      this.state = enums.ItemState.ACTIVE_BADGE;
    else if (this.isBall()) this.state = enums.ItemState.ACTIVE_BALL;
    else if (this.isKit())
      switch (e) {
        case enums.KitActivationSlot.HOME:
          this.state = enums.ItemState.ACTIVE_HOME_KIT;
          break;
        case enums.KitActivationSlot.AWAY:
          this.state = enums.ItemState.ACTIVE_AWAY_KIT;
      }
    else
      this.isStadium()
        ? (this.state = enums.ItemState.ACTIVE_STADIUM)
        : this.isTifo()
        ? (this.state = enums.ItemState.ACTIVE_TIFO)
        : this.isBanner()
        ? (this.state = enums.ItemState.ACTIVE_BANNER)
        : this.isCelebration() &&
          (this.state = enums.ItemState.ACTIVE_CELEBRATION);
  }),
  (entities.Item.prototype.clearAuction = function clearAuction() {
    this._auction = new entities.Auction();
  }),
  (entities.Item.prototype._generateStaticData = function _generateStaticData() {
    var e;
    switch (this.type) {
      case enums.ItemType.PLAYER:
        e = new transferobjects.StaticPlayerItemData();
        break;
      case enums.ItemType.MANAGER:
        e = new transferobjects.StaticManagerItemData();
        break;
      case enums.ItemType.HEAD_COACH:
      case enums.ItemType.GK_COACH:
      case enums.ItemType.FITNESS_COACH:
      case enums.ItemType.PHYSIO:
        e = new transferobjects.StaticStaffItemData();
        break;
      case enums.ItemType.BADGE:
        e = new transferobjects.StaticBadgeItemData();
        break;
      case enums.ItemType.KIT:
        e = new transferobjects.StaticKitItemData();
        break;
      case enums.ItemType.BALL:
        e = new transferobjects.StaticBallItemData();
        break;
      case enums.ItemType.STADIUM:
        e = new transferobjects.StaticStadiumItemData();
        break;
      case enums.ItemType.TRAINING:
        e = new transferobjects.StaticTrainingItemData();
        break;
      case enums.ItemType.HEALTH:
        e = new transferobjects.StaticHealingItemData();
        break;
      case enums.ItemType.CONTRACT:
        e = new transferobjects.StaticContractItemData();
        break;
      case enums.ItemType.MISC:
        e = new transferobjects.StaticMiscItemData();
        break;
      case enums.ItemType.BANNER:
        e = new transferobjects.StaticBannerItemData();
        break;
      case enums.ItemType.CELEBRATION:
        e = new transferobjects.StaticCelebrationItemData();
        break;
      case enums.ItemType.TIFO:
        e = new transferobjects.StaticTifoItemData();
        break;
      default:
        window.console.log(
          '[createStaticItemData] Reached default statement with itemType ' +
            this.type
        ),
          (e = new transferobjects.StaticItemData());
    }
    return e;
  }),
  (entities.Item.prototype.update = function update(e) {
    (this.lastSalePrice = e.lastSalePrice),
      (this.state = e.state),
      (this.pile = e.pile),
      (this.duplicateId = e.duplicateId),
      (this.stackCount = e.stackCount),
      (this.untradeableCount = e.untradeableCount),
      0 !== e.id &&
        this.getAuctionData().compareTo(e.getAuctionData()) &&
        (this.id = e.id),
      (this.isPlayer() || this.isManager()) &&
        ((this.contract = e.contract), (this.loans = e.loans)),
      this.isPlayer() &&
        ((this.loyaltyBonus = e.loyaltyBonus),
        (this.fitness = e.fitness),
        (this.injuryType = e.injuryType),
        (this.injuryGames = e.injuryGames),
        (this.preferredPosition = e.preferredPosition),
        (this.training = e.training),
        (this.playStyle = e.playStyle)),
      this.getAuctionData().update(e.getAuctionData());
  }),
  (entities.Item.prototype.isValid = function isValid() {
    return (0 !== this.id || 0 !== this.resourceId) && 0 < this.stackCount;
  }),
  (entities.Item.prototype.isStack = function isStack() {
    return 1 < this.stackCount;
  }),
  (entities.Item.prototype.isCustomBrick = function isCustomBrick() {
    return !1;
  }),
  (entities.Item.prototype.getMaskedResourceId = function getMaskedResourceId() {
    return this.resourceId & enums.ItemMask.DATABASE;
  }),
  (entities.Item.prototype.getDefId = function getDefId() {
    return services.Configuration.checkFeatureEnabled(
      enums.ServerFeature.LEGACY_YEAR_ENABLED
    )
      ? this.resourceId & (enums.ItemMask.DATABASE | enums.ItemMask.REVISION)
      : this.resourceId &
          (enums.ItemMask.DATABASE | enums.ItemMask.FULL_REVISION);
  }),
  (entities.Item.prototype.getItemData = function getItemData() {
    return this;
  }),
  (entities.Item.prototype.getTier = function getTier() {
    return this.isValid()
      ? this.isBronzeRating()
        ? enums.ItemRatingTier.BRONZE
        : this.isSilverRating()
        ? enums.ItemRatingTier.SILVER
        : enums.ItemRatingTier.GOLD
      : enums.ItemRatingTier.NONE;
  }),
  (entities.Item.prototype.getBoostLevel = function getBoostLevel() {
    return this.hasTraining()
      ? this._trainingItem.getTier()
      : enums.ItemRatingTier.NONE;
  }),
  (entities.Item.prototype.getYear = function getYear() {
    return enums.Year.ASSET;
  }),
  (entities.Item.prototype.getSearchType = function getSearchType() {
    switch (this.type) {
      case enums.ItemType.PLAYER:
        return enums.SearchType.PLAYER;
      case enums.ItemType.MANAGER:
      case enums.ItemType.HEAD_COACH:
      case enums.ItemType.FITNESS_COACH:
      case enums.ItemType.GK_COACH:
      case enums.ItemType.PHYSIO:
        return enums.SearchType.STAFF;
      case enums.ItemType.BADGE:
      case enums.ItemType.KIT:
        return enums.SearchType.CLUB_INFO;
      case enums.ItemType.STADIUM:
        return enums.SearchType.STADIUM;
      case enums.ItemType.BALL:
        return enums.SearchType.BALL;
      case enums.ItemType.CONTRACT:
      case enums.ItemType.HEALTH:
        return enums.SearchType.CONSUMABLES_DEVELOPMENT;
      case enums.ItemType.TRAINING:
        return enums.SearchType.CONSUMABLES_TRAINING;
      default:
        return (
          utils.Debug.Assert(
            !1,
            "[entities.Item::getSearchType] Unexpected item type. Defaulting to search type 'Any'."
          ),
          enums.SearchType.ANY
        );
    }
  }),
  (entities.Item.prototype.isInjured = function isInjured() {
    return this.isPlayer() && 0 < this.injuryGames;
  }),
  (entities.Item.prototype.hasTraining = function hasTraining() {
    return 0 !== this.training && utils.JS.isValid(this._trainingItem);
  }),
  (entities.Item.prototype.getAppliedTrainingItem = function getAppliedTrainingItem() {
    return this._trainingItem;
  }),
  (entities.Item.prototype.isSuspended = function isSuspended() {
    return this.isPlayer() && 0 < this.getCurrentRedCards();
  }),
  (entities.Item.prototype.getStaticData = function getStaticData() {
    return this._staticData;
  }),
  (entities.Item.prototype.setStaticData = function setStaticData(e) {
    this._staticData = e;
  }),
  (entities.Item.prototype.setTrainingItem = function setTrainingItem(e) {
    utils.Debug.Assert(e.isTraining(), 'Expected a training consumable item.'),
      e.isTraining() && ((this.training = e.id), (this._trainingItem = e));
  }),
  (entities.Item.prototype.getAuctionData = function getAuctionData() {
    return this._auction;
  }),
  (entities.Item.prototype.setAuctionData = function setAuctionData(e) {
    this._auction = e;
  }),
  (entities.Item.prototype.getSkillMoves = function getSkillMoves() {
    return -1 < this._skillMoves
      ? this._skillMoves
      : utils.JS.isValid(this._metaData)
      ? this._metaData.skillMoves
      : -1;
  }),
  (entities.Item.prototype.getWeakFoot = function getWeakFoot() {
    return -1 < this._weakFoot
      ? this._weakFoot
      : utils.JS.isValid(this._metaData)
      ? this._metaData.weakFoot
      : -1;
  }),
  (entities.Item.prototype.getOffensiveWorkRate = function getOffensiveWorkRate() {
    return -1 < this._offensiveWorkRate
      ? this._offensiveWorkRate
      : utils.JS.isValid(this._metaData)
      ? this._metaData.offensiveWorkRate
      : -1;
  }),
  (entities.Item.prototype.getDefensiveWorkRate = function getDefensiveWorkRate() {
    return -1 < this._defensiveWorkRate
      ? this._defensiveWorkRate
      : utils.JS.isValid(this._metaData)
      ? this._metaData.defensiveWorkRate
      : -1;
  }),
  (entities.Item.prototype.isLeftFoot = function isLeftFoot() {
    return -1 < this._preferredFoot
      ? 1 !== parseInt(this._preferredFoot, 10)
      : !!utils.JS.isValid(this._metaData) && this._metaData.isLeftFoot;
  }),
  (entities.Item.prototype.getMetaData = function getMetaData() {
    return this._metaData;
  }),
  (entities.Item.prototype.setMetaData = function setMetaData(e) {
    var t = e instanceof UTPlayerMetaDataDTO;
    utils.Debug.Assert(t, 'Expected a PlayerMetaData DTO'),
      utils.Debug.Assert(
        this.isPlayer(),
        'Cannot assign player meta data to non-player items'
      ),
      t && this.isPlayer() && (this._metaData = e);
  }),
  (entities.Item.prototype.isDiscardable = function isDiscardable() {
    return this.isValid() && !this.isMiscItem();
  }),
  (entities.Item.prototype.isMovable = function isMovable() {
    var e = !this.isDuplicate() && !this.isDuplicateLoanPlayer();
    return (e = e && this.type !== enums.ItemType.MISC);
  }),
  (entities.Item.prototype.isDuplicate = function isDuplicate() {
    return !this.isConsumable() && 0 < this.duplicateId;
  }),
  (entities.Item.prototype.isLoaned = function isLoaned() {
    return 0 <= this.loans;
  }),
  (entities.Item.prototype.isPlayer = function isPlayer() {
    return this.type === enums.ItemType.PLAYER;
  }),
  (entities.Item.prototype.isChampionsLeagueItem = function isChampionsLeagueItem() {
    return (
      (this.rareflag === entities.Item.Rarity.CHAMPIONS_COMMON ||
        this.rareflag === entities.Item.Rarity.CHAMPIONS_RARE ||
        this.rareflag === entities.Item.Rarity.CHAMPIONS_MOTM ||
        this.rareflag === entities.Item.Rarity.CHAMPIONS_LIVE ||
        this.rareflag === entities.Item.Rarity.CHAMPIONS_SBC ||
        this.rareflag === entities.Item.Rarity.CHAMPIONS_TOTT) &&
      this.isPlayer()
    );
  }),
  (entities.Item.prototype.isManager = function isManager() {
    return this.type === enums.ItemType.MANAGER;
  }),
  (entities.Item.prototype.isHeadCoach = function isHeadCoach() {
    return this.type === enums.ItemType.HEAD_COACH;
  }),
  (entities.Item.prototype.isFitnessCoach = function isFitnessCoach() {
    return this.type === enums.ItemType.FITNESS_COACH;
  }),
  (entities.Item.prototype.isGKCoach = function isGKCoach() {
    return this.type === enums.ItemType.GK_COACH;
  }),
  (entities.Item.prototype.isPhysio = function isPhysio() {
    return this.type === enums.ItemType.PHYSIO;
  }),
  (entities.Item.prototype.isCoach = function isCoach() {
    return (
      this.isHeadCoach() ||
      this.isFitnessCoach() ||
      this.isGKCoach() ||
      this.isPhysio()
    );
  }),
  (entities.Item.prototype.isStaff = function isStaff() {
    return this.isManager() || this.isCoach();
  }),
  (entities.Item.prototype.isPlayerBanned = function isPlayerBanned() {
    return (
      this.isValid() &&
      this.isPlayer() &&
      (this.isSuspended() || this.contract <= 0)
    );
  }),
  (entities.Item.prototype.isContractExpired = function isContractExpired() {
    return (this.isPlayer() || this.isManager()) && this.contract <= 0;
  }),
  (entities.Item.prototype.isDuplicateLoanPlayer = function isDuplicateLoanPlayer() {
    return (
      this.isValid() && this.isPlayer() && this.isDuplicate() && this.isLoaned()
    );
  }),
  (entities.Item.prototype.getAttribute = function getAttribute(e, t) {
    var i = this._attributes[e] || 0;
    return (
      this.hasTraining() &&
        !t &&
        (i = this._modifyAttribute(e, parseInt(i, 10))),
      i
    );
  }),
  (entities.Item.prototype.getAttributes = function getAttributes() {
    var e = this.isPlayer() ? this._attributes : [];
    return (
      this.hasTraining() &&
        (e = e.map(function(e, t) {
          return this._modifyAttribute(t, parseInt(e, 10));
        }, this)),
      e
    );
  }),
  (entities.Item.prototype.getStats = function getStats() {
    return this.isPlayer() ? this._stats : [];
  }),
  (entities.Item.prototype.getGamesPlayed = function getGamesPlayed() {
    return this.isPlayer() ? this._stats[0] : 0;
  }),
  (entities.Item.prototype.getGoals = function getGoals() {
    return this.isPlayer() ? this._stats[1] : 0;
  }),
  (entities.Item.prototype.getYellowCards = function getYellowCards() {
    return this.isPlayer() ? this._stats[2] : 0;
  }),
  (entities.Item.prototype.getRedCards = function getRedCards() {
    return this.isPlayer() ? this._stats[3] : 0;
  }),
  (entities.Item.prototype.getCurrentRedCards = function getCurrentRedCards() {
    return this.isPlayer() ? this._stats[4] : 0;
  }),
  (entities.Item.prototype.getLifetimeStats = function getLifetimeStats() {
    return this.isPlayer() ? this._lifetimeStats : [];
  }),
  (entities.Item.prototype.getLoyaltyRequiredGames = function getLoyaltyRequiredGames() {
    return entities.Item.LOYALTY_REQUIRED_GAMES;
  }),
  (entities.Item.prototype.getTotalGamesPlayed = function getTotalGamesPlayed() {
    return this.isPlayer() ? this._lifetimeStats[0] : 0;
  }),
  (entities.Item.prototype.getTotalGoals = function getTotalGoals() {
    return this.isPlayer() ? this._lifetimeStats[1] : 0;
  }),
  (entities.Item.prototype.getTotalYellowCards = function getTotalYellowCards() {
    return this.isPlayer() ? this._lifetimeStats[2] : 0;
  }),
  (entities.Item.prototype.getTotalRedCards = function getTotalRedCards() {
    return this.isPlayer() ? this._lifetimeStats[3] : 0;
  }),
  (entities.Item.prototype.isAttributeBoosted = function isAttributeBoosted(e) {
    return (
      this.hasTraining() &&
      (this._trainingItem.isAllAttributeTraining() ||
        this._trainingItem.getStaticData().trainedAttribute === e)
    );
  }),
  (entities.Item.prototype._modifyAttribute = function _modifyAttribute(e, t) {
    if (this.isAttributeBoosted(e)) {
      var i = this._trainingItem.getStaticData(),
        s = i.amount;
      return (
        this._trainingItem.isPlayerTraining()
          ? (s += Math.floor(
              gStaffStatsModel.getPlayerAttribBoost(e) * i.amount
            ))
          : this._trainingItem.isGKTraining() &&
            (s += Math.floor(gStaffStatsModel.getGKAttribBoost(e) * i.amount)),
        Math.min(t + s, 99)
      );
    }
    return t;
  }),
  (entities.Item.prototype.isGK = function isGK() {
    return 0 === this.preferredPosition;
  }),
  (entities.Item.prototype.isContract = function isContract() {
    return this.type === enums.ItemType.CONTRACT;
  }),
  (entities.Item.prototype.isPlayerContract = function isPlayerContract() {
    return (
      this.isContract() &&
      this._assetId === enums.ItemCardAssetId.CONTRACT_PLAYER
    );
  }),
  (entities.Item.prototype.isManagerContract = function isManagerContract() {
    return (
      this.isContract() &&
      this._assetId === enums.ItemCardAssetId.CONTRACT_MANAGER
    );
  }),
  (entities.Item.prototype.isTraining = function isTraining() {
    return this.type === enums.ItemType.TRAINING;
  }),
  (entities.Item.prototype.isGKTraining = function isGKTraining() {
    return (
      this.isTraining() && this._assetId === enums.ItemCardAssetId.TRAINING_GK
    );
  }),
  (entities.Item.prototype.isPlayerTraining = function isPlayerTraining() {
    return (
      this.isTraining() &&
      this._assetId === enums.ItemCardAssetId.TRAINING_PLAYER
    );
  }),
  (entities.Item.prototype.isAllAttributeTraining = function isAllAttributeTraining() {
    return (
      this.isTraining() &&
      (this.subtype === enums.ItemSubType.TRAINING_GK_ALL ||
        this.subtype === enums.ItemSubType.TRAINING_PLAYER_ALL)
    );
  }),
  (entities.Item.prototype.isPlayerPositionModifier = function isPlayerPositionModifier() {
    return (
      this.isTraining() &&
      this._assetId === enums.ItemCardAssetId.POSITION_MODIFIER
    );
  }),
  (entities.Item.prototype.isStyleModifier = function isStyleModifier() {
    return (
      this.isTraining() &&
      (this._assetId === enums.ItemCardAssetId.PLAYSTYLE_PLAYER ||
        this._assetId === enums.ItemCardAssetId.PLAYSTYLE_GK)
    );
  }),
  (entities.Item.prototype.isPlayerStyleModifier = function isPlayerStyleModifier() {
    return (
      this.isTraining() &&
      this._assetId === enums.ItemCardAssetId.PLAYSTYLE_PLAYER
    );
  }),
  (entities.Item.prototype.isGKStyleModifier = function isGKStyleModifier() {
    return (
      this.isTraining() && this._assetId === enums.ItemCardAssetId.PLAYSTYLE_GK
    );
  }),
  (entities.Item.prototype.isManagerLeagueModifier = function isManagerLeagueModifier() {
    return (
      this.isTraining() &&
      this._assetId === enums.ItemCardAssetId.MANAGER_LEAGUE
    );
  }),
  (entities.Item.prototype.isManagerConsumable = function isManagerConsumable() {
    return this.isManagerLeagueModifier() || this.isManagerContract();
  }),
  (entities.Item.prototype.isHealth = function isHealth() {
    return this.type === enums.ItemType.HEALTH;
  }),
  (entities.Item.prototype.isInjuryHealing = function isInjuryHealing() {
    return this.isHealth() && this._assetId === enums.ItemCardAssetId.HEALING;
  }),
  (entities.Item.prototype.isFitness = function isFitness() {
    return (
      this.isHealth() &&
      (this._assetId === enums.ItemCardAssetId.FITNESS_PLAYER ||
        this._assetId === enums.ItemCardAssetId.FITNESS_TEAM)
    );
  }),
  (entities.Item.prototype.isPlayerFitness = function isPlayerFitness() {
    return (
      this.isHealth() && this._assetId === enums.ItemCardAssetId.FITNESS_PLAYER
    );
  }),
  (entities.Item.prototype.isTeamFitness = function isTeamFitness() {
    return (
      this.isHealth() && this._assetId === enums.ItemCardAssetId.FITNESS_TEAM
    );
  }),
  (entities.Item.prototype.isConsumable = function isConsumable() {
    return this.isContract() || this.isTraining() || this.isHealth();
  }),
  (entities.Item.prototype.isClubConsumable = function isClubConsumable() {
    return this.isConsumable() && this.pile === enums.FUTItemPile.CLUB;
  }),
  (entities.Item.prototype.isBanner = function isBanner() {
    return this.type === enums.ItemType.BANNER;
  }),
  (entities.Item.prototype.isCelebration = function isCelebration() {
    return this.type === enums.ItemType.CELEBRATION;
  }),
  (entities.Item.prototype.isTifo = function isTifo() {
    return this.type === enums.ItemType.TIFO;
  }),
  (entities.Item.prototype.isCustomItem = function isCustomItem() {
    return this.isBanner() || this.isCelebration() || this.isTifo();
  }),
  (entities.Item.prototype.isBadge = function isBadge() {
    return this.type === enums.ItemType.BADGE;
  }),
  (entities.Item.prototype.isBall = function isBall() {
    return this.type === enums.ItemType.BALL;
  }),
  (entities.Item.prototype.isKit = function isKit() {
    return this.type === enums.ItemType.KIT;
  }),
  (entities.Item.prototype.isStadium = function isStadium() {
    return this.type === enums.ItemType.STADIUM;
  }),
  (entities.Item.prototype.isClubItem = function isClubItem() {
    return (
      this.isCustomItem() ||
      this.isBadge() ||
      this.isBall() ||
      this.isKit() ||
      this.isStadium()
    );
  }),
  (entities.Item.prototype.isActiveBanner = function isActiveBanner() {
    return this.isBanner() && this.state === enums.ItemState.ACTIVE_BANNER;
  }),
  (entities.Item.prototype.isActiveCelebration = function isActiveCelebration() {
    return (
      this.isCelebration() && this.state === enums.ItemState.ACTIVE_CELEBRATION
    );
  }),
  (entities.Item.prototype.isActiveTifo = function isActiveTifo() {
    return this.isTifo() && this.state === enums.ItemState.ACTIVE_TIFO;
  }),
  (entities.Item.prototype.isActiveCustomItem = function isActiveCustomItem() {
    return (
      this.isActiveBanner() || this.isActiveCelebration() || this.isActiveTifo()
    );
  }),
  (entities.Item.prototype.isActiveBall = function isActiveBall() {
    return this.isBall() && this.state === enums.ItemState.ACTIVE_BALL;
  }),
  (entities.Item.prototype.isActiveBadge = function isActiveBadge() {
    return this.isBadge() && this.state === enums.ItemState.ACTIVE_BADGE;
  }),
  (entities.Item.prototype.isActiveAwayKit = function isActiveAwayKit() {
    return this.isKit() && this.state === enums.ItemState.ACTIVE_AWAY_KIT;
  }),
  (entities.Item.prototype.isActiveHomeKit = function isActiveHomeKit() {
    return this.isKit() && this.state === enums.ItemState.ACTIVE_HOME_KIT;
  }),
  (entities.Item.prototype.isActiveStadium = function isActiveStadium() {
    return this.isStadium() && this.state === enums.ItemState.ACTIVE_STADIUM;
  }),
  (entities.Item.prototype.isActiveClubItem = function isActiveClubItem() {
    return (
      this.isActiveCustomItem() ||
      this.isActiveBall() ||
      this.isActiveBadge() ||
      this.isActiveAwayKit() ||
      this.isActiveHomeKit() ||
      this.isActiveStadium()
    );
  }),
  (entities.Item.prototype.isMiscItem = function isMiscItem() {
    return this.type === enums.ItemType.MISC;
  }),
  (entities.Item.prototype.isFreeCoins = function isFreeCoins() {
    return this.isMiscItem() && this.subtype === enums.ItemSubType.FREE_COINS;
  }),
  (entities.Item.prototype.isCoinBoost = function isCoinBoost() {
    return this.isMiscItem() && this.subtype === enums.ItemSubType.COIN_BOOST;
  }),
  (entities.Item.prototype.isFreePack = function isFreePack() {
    return this.isMiscItem() && this.subtype === enums.ItemSubType.FREE_PACK;
  }),
  (entities.Item.prototype.isDraftToken = function isDraftToken() {
    return this.isMiscItem() && this.subtype === enums.ItemSubType.DRAFT_TOKEN;
  }),
  (entities.Item.prototype.isPlayerPickItem = function isPlayerPickItem() {
    return (
      this.isMiscItem() && this.subtype === enums.ItemSubType.PLAYER_PICK_ITEM
    );
  }),
  (entities.Item.prototype.isCharityItem = function isCharityItem() {
    return (
      this.getMaskedResourceId() === entities.Item.DANNY_MILLER_CHARITY_ID ||
      this.getMaskedResourceId() === entities.Item.KENTON_CHARITY_ID
    );
  }),
  (entities.Item.prototype.isCommon = function isCommon() {
    return this.rareflag === entities.Item.Rarity.NONE;
  }),
  (entities.Item.prototype.isRare = function isRare() {
    return this.rareflag === entities.Item.Rarity.RARE;
  }),
  (entities.Item.prototype.isSpecial = function isSpecial() {
    return !this.isCommon() && !this.isRare();
  }),
  (entities.Item.prototype.isLegend = function isLegend() {
    return (
      this.rareflag === entities.Item.Rarity.ICON ||
      this.rareflag === entities.Item.Rarity.PRIMEICON
    );
  }),
  (entities.Item.isStoryMode = function isStoryMode(e) {
    return (
      entities.Item.isAlex(e) ||
      entities.Item.isJim(e) ||
      entities.Item.isDanny(e)
    );
  }),
  (entities.Item.isAlex = function isAlex(e) {
    return e >= ALEX_HUNTER_MIN_ID && e <= ALEX_HUNTER_MAX_ID;
  }),
  (entities.Item.isJim = function isJim(e) {
    return e >= JIM_HUNTER_MIN_ID && e <= JIM_HUNTER_MAX_ID;
  }),
  (entities.Item.isDanny = function isDanny(e) {
    return e >= DANNY_WILLIAMS_MIN_ID && e <= DANNY_WILLIAMS_MAX_ID;
  }),
  (entities.Item.prototype.belongsToGroup = function belongsToGroup(e) {
    return -1 < this.groups.indexOf(e);
  }),
  (entities.Item.prototype.hasQualityTiers = function hasQualityTiers() {
    return this.hasLevels;
  }),
  (entities.Item.prototype.isBronzeRating = function isBronzeRating() {
    return this.rating <= 64;
  }),
  (entities.Item.prototype.isSilverRating = function isSilverRating() {
    return this.rating <= 74 && 64 < this.rating;
  }),
  (entities.Item.prototype.isGoldRating = function isGoldRating() {
    return 74 < this.rating;
  }),
  (entities.Item.prototype.prefersDefensePosition = function prefersDefensePosition() {
    return (
      this.isPlayer() &&
      this.preferredPosition >= enums.PlayerPositionsAsInts.RWB &&
      this.preferredPosition <= enums.PlayerPositionsAsInts.LWB
    );
  }),
  (entities.Item.prototype.prefersMidfieldPosition = function prefersMidfieldPosition() {
    return (
      this.isPlayer() &&
      this.preferredPosition >= enums.PlayerPositionsAsInts.RDM &&
      this.preferredPosition <= enums.PlayerPositionsAsInts.LAM
    );
  }),
  (entities.Item.prototype.prefersAttackerPosition = function prefersAttackerPosition() {
    return (
      this.isPlayer() &&
      this.preferredPosition >= enums.PlayerPositionsAsInts.RF
    );
  }),
  (entities.Item.prototype.compareTo = function compareTo(e) {
    var t = this.getAuctionData(),
      i = e.getAuctionData();
    return t.isValid() && i.isValid() ? t.compareTo(i) : this.id === e.id;
  }),
  (entities.Item.prototype.compareResourceTo = function compareResourceTo(
    e,
    t
  ) {
    return e instanceof entities.Item
      ? t
        ? this.resourceId === e.resourceId
        : this.isLegend() && e.isLegend() && 0 < this.iconId && 0 < e.iconId
        ? this.iconId === e.iconId
        : this.getMaskedResourceId() === e.getMaskedResourceId()
      : (utils.Debug.Assert(
          !1,
          '[entities.Item::compareResourceTo] Parameter expected a valid item entity.'
        ),
        !1);
  }),
  (entities.Item.prototype.setItemPriceLimits = function setItemPriceLimits(e) {
    this._itemPriceLimits = e;
  }),
  (entities.Item.prototype.hasPriceLimits = function hasPriceLimits() {
    return null !== this._itemPriceLimits;
  }),
  (entities.Item.prototype.getPriceLimits = function getPriceLimits() {
    return this._itemPriceLimits;
  }),
  (entities.Item.prototype.increaseStackCount = function increaseStackCount(e) {
    return (
      (e = e || 1),
      (this.stackCount = this.stackCount + e),
      this._updateUntradeableState(),
      this.stackCount
    );
  }),
  (entities.Item.prototype.decreaseStackCount = function decreaseStackCount(e) {
    if (((e = e || 1), this.stackCount >= e)) {
      var t = this.stackCount - this.untradeableCount;
      0 < this.untradeableCount &&
        t < e &&
        (this.untradeableCount = this.untradeableCount + (t - e)),
        (this.stackCount -= e);
    } else
      (this.stackCount = 0), this.untradeable && (this.untradeableCount = 0);
    return (
      this._updateUntradeableState(),
      this.untradeable && (this.discardValue = 0),
      this.stackCount
    );
  }),
  (entities.Item.prototype._updateUntradeableState = function _updateUntradeableState() {
    this.untradeable =
      0 < this.untradeableCount && this.stackCount <= this.untradeableCount;
  }),
  (entities.Item.prototype.compareDream = function compareDream(e) {
    return e instanceof entities.Item
      ? this.getMaskedResourceId() === e.getMaskedResourceId() &&
          this.concept !== e.concept
      : (utils.Debug.Assert(
          !1,
          '[entities.Item::compareToDream] Parameter expected a valid item entity.'
        ),
        !1);
  }),
  (entities.Item.prototype.compareType = function compareType(e) {
    return e instanceof entities.Item
      ? this.type === e.type
      : (utils.Debug.Assert(
          !1,
          '[entities.Item::compareType] Parameter expected a valid item entity.'
        ),
        !1);
  }),
  (entities.Item.prototype.canApplyTo = function canApplyTo(e) {
    if (!this.isConsumable() || e.isConsumable()) return !1;
    var t = this.getStaticData();
    if (this.isPlayerStyleModifier())
      return e.isPlayer() && !e.isGK() && e.playStyle !== this.subtype;
    if (this.isGKStyleModifier())
      return e.isGK() && e.playStyle !== this.subtype;
    if (this.isManagerLeagueModifier())
      return e.isManager() && e.leagueId !== this.leagueId;
    if (this.isPlayerTraining()) return e.isPlayer() && !e.isGK();
    if (this.isGKTraining()) return e.isPlayer() && e.isGK();
    if (this.isPlayerContract())
      return e.isPlayer() && !e.isLoaned() && e.contract < 99;
    if (this.isManagerContract()) return e.isManager() && e.contract < 99;
    if (this.isPlayerPositionModifier()) {
      var i = repositories.Squad.getPosition(e.preferredPosition);
      return !!i && i.getTypeName() === t.trainPosFrom;
    }
    return this.isFitness()
      ? e.isPlayer() && (this.isTeamFitness() || e.fitness < 99)
      : !!this.isInjuryHealing() &&
          (e.isInjured() && this._canApplyToInjury(e.injuryType));
  }),
  (entities.Item.prototype._canApplyToInjury = function _canApplyToInjury(e) {
    if (!this.isInjuryHealing()) return !1;
    switch (this.subtype) {
      case enums.ItemSubType.HEALING_HEAD:
        return e === enums.PlayerInjury.HEAD;
      case enums.ItemSubType.HEALING_SHOULDER:
        return e === enums.PlayerInjury.SHOULDER;
      case enums.ItemSubType.HEALING_ARM:
        return e === enums.PlayerInjury.ARM;
      case enums.ItemSubType.HEALING_BACK:
        return e === enums.PlayerInjury.BACK;
      case enums.ItemSubType.HEALING_HIP:
        return e === enums.PlayerInjury.HIP;
      case enums.ItemSubType.HEALING_LEG:
        return e === enums.PlayerInjury.LEG;
      case enums.ItemSubType.HEALING_FOOT:
        return e === enums.PlayerInjury.FOOT;
      case enums.ItemSubType.HEALING_ALL:
        return !0;
    }
    return !1;
  }),
  (entities.Item.DANNY_MILLER_CHARITY_ID = 227904),
  (entities.Item.KENTON_CHARITY_ID = 235430),
  (entities.Item.LOYALTY_REQUIRED_GAMES = 10),
  (entities.CustomBrickItem = function FUTCustomBrickItem() {
    entities.Item.call(this, enums.ItemType.PLAYER);
  }),
  utils.JS.inherits(entities.CustomBrickItem, entities.Item),
  (entities.CustomBrickItem.prototype.activate = function activate(e) {
    var t = new UTObservable();
    return (
      t.notify({
        success: !1,
        error: null
      }),
      t
    );
  }),
  (entities.CustomBrickItem.prototype._generateStaticData = function _generateStaticData() {
    return new transferobjects.StaticItemData();
  }),
  (entities.CustomBrickItem.prototype.update = function update(e) {}),
  (entities.CustomBrickItem.prototype.isValid = function isValid() {
    return !1;
  }),
  (entities.CustomBrickItem.prototype.isCustomBrick = function isCustomBrick() {
    return !0;
  }),
  (entities.CustomBrickItem.prototype.isInjured = function isInjured() {
    return !1;
  }),
  (entities.CustomBrickItem.prototype.hasTraining = function hasTraining() {
    return !1;
  }),
  (entities.CustomBrickItem.prototype.isSuspended = function isSuspended() {
    return !1;
  }),
  (entities.CustomBrickItem.prototype.setStaticData = function setStaticData(
    e
  ) {}),
  (entities.CustomBrickItem.prototype.setAuctionData = function setAuctionData(
    e
  ) {}),
  (entities.CustomBrickItem.prototype.setSkillMoves = function setSkillMoves(
    e
  ) {}),
  (entities.CustomBrickItem.prototype.setWeakFoot = function setWeakFoot(e) {}),
  (entities.CustomBrickItem.prototype.setOffensiveWorkRate = function setOffensiveWorkRate(
    e
  ) {}),
  (entities.CustomBrickItem.prototype.setDefensiveWorkRate = function setDefensiveWorkRate(
    e
  ) {}),
  (entities.CustomBrickItem.prototype.setPreferredFoot = function setPreferredFoot(
    e
  ) {}),
  (entities.CustomBrickItem.prototype.setMetaData = function setMetaData(e) {}),
  (entities.CustomBrickItem.prototype.getAttribute = function getAttribute(
    e,
    t
  ) {
    return 0;
  }),
  (entities.CustomBrickItem.prototype.isAttributeBoosted = function isAttributeBoosted(
    e
  ) {
    return !1;
  }),
  (entities.CustomBrickItem.prototype._modifyAttribute = function _modifyAttribute(
    e,
    t
  ) {
    return 0;
  }),
  (entities.CustomBrickItem.prototype.hasQualityTiers = function hasQualityTiers() {
    return !1;
  }),
  (entities.CustomBrickItem.prototype.compareTo = function compareTo(e) {
    return !1;
  }),
  (entities.CustomBrickItem.prototype.compareResourceTo = function compareResourceTo(
    e,
    t
  ) {
    return !1;
  }),
  (entities.CustomBrickItem.prototype.setItemPriceLimits = function setItemPriceLimits(
    e
  ) {}),
  (entities.CustomBrickItem.prototype.increaseStackCount = function increaseStackCount() {
    return 0;
  }),
  (entities.CustomBrickItem.prototype.decreaseStackCount = function decreaseStackCount() {
    return 0;
  }),
  (entities.CustomBrickItem.prototype._updateUntradeableState = function _updateUntradeableState() {}),
  (entities.CustomBrickItem.prototype.compareDream = function compareDream(e) {
    return !1;
  }),
  (entities.CustomBrickItem.prototype.canApplyTo = function canApplyTo(e) {
    return !1;
  }),
  (entities.CustomBrickItem.prototype._canApplyToInjury = function _canApplyToInjury(
    e
  ) {
    return !1;
  }),
  (entities.NullItem = function FUTNullItem() {
    entities.Item.call(this, enums.ItemType.NONE);
  }),
  utils.JS.inherits(entities.NullItem, entities.Item),
  (entities.NullItem.prototype.activate = function activate(e) {
    var t = new UTObservable();
    return (
      t.notify({
        success: !1,
        error: null
      }),
      t
    );
  }),
  (entities.NullItem.prototype.clearAuction = function clearAuction() {}),
  (entities.NullItem.prototype._generateStaticData = function _generateStaticData() {
    return new transferobjects.StaticItemData();
  }),
  (entities.NullItem.prototype.update = function update(e) {}),
  (entities.NullItem.prototype.isValid = function isValid() {
    return !1;
  }),
  (entities.NullItem.prototype.isInjured = function isInjured() {
    return !1;
  }),
  (entities.NullItem.prototype.hasTraining = function hasTraining() {
    return !1;
  }),
  (entities.NullItem.prototype.isSuspended = function isSuspended() {
    return !1;
  }),
  (entities.NullItem.prototype.setStaticData = function setStaticData(e) {}),
  (entities.NullItem.prototype.setTrainingItem = function setTrainingItem(
    e
  ) {}),
  (entities.NullItem.prototype.setAuctionData = function setAuctionData(e) {}),
  (entities.NullItem.prototype.setSkillMoves = function setSkillMoves(e) {}),
  (entities.NullItem.prototype.setWeakFoot = function setWeakFoot(e) {}),
  (entities.NullItem.prototype.setOffensiveWorkRate = function setOffensiveWorkRate(
    e
  ) {}),
  (entities.NullItem.prototype.setDefensiveWorkRate = function setDefensiveWorkRate(
    e
  ) {}),
  (entities.NullItem.prototype.setPreferredFoot = function setPreferredFoot(
    e
  ) {}),
  (entities.NullItem.prototype.setMetaData = function setMetaData(e) {}),
  (entities.NullItem.prototype.isMovable = function isMovable() {
    return !1;
  }),
  (entities.NullItem.prototype.getAttribute = function getAttribute(e, t) {
    return 0;
  }),
  (entities.NullItem.prototype.getAttributes = function getAttributes() {
    return [];
  }),
  (entities.NullItem.prototype.getStats = function getStats() {
    return [];
  }),
  (entities.NullItem.prototype.isAttributeBoosted = function isAttributeBoosted(
    e
  ) {
    return !1;
  }),
  (entities.NullItem.prototype._modifyAttribute = function _modifyAttribute(
    e,
    t
  ) {
    return 0;
  }),
  (entities.NullItem.prototype.hasQualityTiers = function hasQualityTiers() {
    return !1;
  }),
  (entities.NullItem.prototype.compareTo = function compareTo(e) {
    return !1;
  }),
  (entities.NullItem.prototype.compareResourceTo = function compareResourceTo(
    e,
    t
  ) {
    return !1;
  }),
  (entities.NullItem.prototype.setItemPriceLimits = function setItemPriceLimits(
    e
  ) {}),
  (entities.NullItem.prototype.increaseStackCount = function increaseStackCount() {
    return 0;
  }),
  (entities.NullItem.prototype.decreaseStackCount = function decreaseStackCount() {
    return 0;
  }),
  (entities.NullItem.prototype._updateUntradeableState = function _updateUntradeableState() {}),
  (entities.NullItem.prototype.compareDream = function compareDream(e) {
    return !1;
  }),
  (entities.NullItem.prototype.compareType = function compareType(e) {
    return !1;
  }),
  (entities.NullItem.prototype.canApplyTo = function canApplyTo(e) {
    return !1;
  }),
  (entities.NullItem.prototype._canApplyToInjury = function _canApplyToInjury(
    e
  ) {
    return !1;
  }),
  NamespaceManager.Register('factories'),
  (factories.Item = (function() {
    function ItemEntityFactory() {
      this._auctionFactory = new UTAuctionEntityFactory();
    }

    function _convertCardAssetIdToItemType(e) {
      switch (e) {
        case enums.ItemCardAssetId.CONTRACT_PLAYER:
        case enums.ItemCardAssetId.CONTRACT_MANAGER:
          return enums.ItemType.CONTRACT;
        case enums.ItemCardAssetId.HEALING:
        case enums.ItemCardAssetId.FITNESS_PLAYER:
        case enums.ItemCardAssetId.FITNESS_TEAM:
          return enums.ItemType.HEALTH;
        case enums.ItemCardAssetId.TRAINING_PLAYER:
        case enums.ItemCardAssetId.TRAINING_GK:
        case enums.ItemCardAssetId.MANAGER_LEAGUE:
        case enums.ItemCardAssetId.POSITION_MODIFIER:
        case enums.ItemCardAssetId.PLAYSTYLE_PLAYER:
        case enums.ItemCardAssetId.PLAYSTYLE_GK:
          return enums.ItemType.TRAINING;
      }
      return (
        utils.Debug.Assert(!1, 'Unknown cardassetid: ' + e), enums.ItemType.NONE
      );
    }

    function _normalizePayload(e, t) {
      if (
        (utils.JS.isNumber(e.rareFlag) &&
          ((e.rareflag = e.rareFlag), delete e.rareFlag),
        utils.JS.isNumber(e.teamid) && ((e.teamId = e.teamid), delete e.teamid),
        !utils.JS.isBoolean(t) || t)
      ) {
        if (e.teamId && (!utils.JS.isNumber(e.leagueId) || e.leagueId <= 0)) {
          var i = repositories.TeamConfig.getTeam(e.teamId, enums.Year.ASSET);
          e.leagueId = i ? i.league : -1;
        }
        if (e.leagueId && (!utils.JS.isNumber(e.nation) || e.nation <= 0)) {
          var s = repositories.TeamConfig.getLeague(
            e.leagueId,
            enums.Year.ASSET
          );
          e.nation = s ? s.nation : -1;
        }
      }
      return e;
    }

    function _parseItemPayload(i, e) {
      if (
        ((i.id = e.id),
        (i.resourceId = e.resourceId),
        (i.type = e.itemType),
        (i._assetId = e.cardassetid || enums.ItemCardAssetId.NONE),
        (i.subtype =
          e.cardsubtypeid ||
          (function _generateSubtype(e) {
            switch (
              (utils.Debug.Assert(
                e.isPlayer() || e.isStaff(),
                'Missing required item subtype in server payload.'
              ),
              e.type)
            ) {
              case enums.ItemType.PLAYER:
                return enums.ItemSubType.PLAYER;
              case enums.ItemType.MANAGER:
                return enums.ItemSubType.MANAGER;
              case enums.ItemType.HEAD_COACH:
                return enums.ItemSubType.HEAD_COACH;
              case enums.ItemType.GK_COACH:
                return enums.ItemSubType.GK_COACH;
              case enums.ItemType.FITNESS_COACH:
                return enums.ItemSubType.FITNESS_COACH;
              case enums.ItemType.PHYSIO:
                return enums.ItemSubType.PHYSIO;
            }
            return enums.ItemSubType.NONE;
          })(i)),
        (i.untradeable = !utils.JS.isBoolean(e.untradeable) || e.untradeable),
        (i.lastSalePrice = e.lastSalePrice || 0),
        (i.discardValue = e.discardValue || 0),
        (i.state = e.itemState),
        (i.pile = e.pile),
        (i.amount = e.amount || 0),
        (i.rating = parseInt(e.rating, 10) || 0),
        (i.teamId = e.teamId || 0),
        (i.leagueId = e.leagueId || 0),
        (i.nationId = e.nation || 0),
        (i.rareflag = e.rareflag || 0),
        (i.groups = e.groups || []),
        (i.owners = e.owners || 0),
        (i.timestamp = e.timestamp || 0),
        (i.type === enums.ItemType.KIT || i.type === enums.ItemType.BADGE) &&
          i.nationId < 1 &&
          (i.nationId = 75),
        i.type === enums.ItemType.STADIUM &&
          ((i.ballRestricted =
            !!utils.JS.isBoolean(e.ballRestricted) && e.ballRestricted),
          (i.bannerRestricted =
            !utils.JS.isBoolean(e.bannerRestricted) || e.bannerRestricted),
          (i.tifoRestricted =
            !utils.JS.isBoolean(e.tifoRestricted) || e.tifoRestricted),
          (i.tifoSupportType = e.tifoSupportType || 0),
          i.tifoSupportType !== enums.TifoSupportType.PLAYER &&
            i.tifoSupportType !== enums.TifoSupportType.BOTH &&
            (i.tifoRestricted = !0)),
        (i.stackCount = 1),
        (i.untradeableCount = i.untradeable ? 1 : 0),
        (i.isPlayer() || i.isManager()) &&
          ((i.contract = e.contract),
          (i.concept = e.dream || !1),
          (i.loans = utils.JS.isNumber(e.loans) ? e.loans : -1)),
        i.isPlayer())
      ) {
        i.concept
          ? (i.loyaltyBonus = services.Configuration.checkFeatureEnabled(
              enums.ServerFeature.CONCEPT_SQUAD_LOYALTY_BONUS_ENABLED
            ))
          : (i.loyaltyBonus = e.loyaltyBonus || 0),
          (i.fitness = e.fitness || 99),
          (i.injuryType = e.injuryType || enums.PlayerInjury.NONE),
          (i.injuryGames = e.injuryGames || 0),
          (i.training = utils.JS.isNumber(e.training) ? e.training : 0);
        var t = repositories.Squad.getPositionByUniqueName(e.preferredPosition);
        i.preferredPosition = t ? t.getId() : 0;
        var s = e.preferredPosition === enums.PlayerPositions.GK;
        if (
          ((i.playStyle =
            e.playStyle ||
            (s
              ? enums.ItemSubType.TRAINING_PLAYERSTYLE_GOALKEEPER_5
              : DEFAULT_PLAYSTYLE_ID)),
          Array.isArray(e.attributeArray)
            ? (i._attributes = e.attributeArray)
            : Array.isArray(e.attributeList) &&
              e.attributeList.forEach(function(e, t) {
                i._attributes[t] = e.value;
              }, this),
          Array.isArray(e.lifetimeStatsArray)
            ? (i._lifetimeStats = e.lifetimeStatsArray)
            : Array.isArray(e.lifetimeStats) &&
              e.lifetimeStats.forEach(function(e, t) {
                i._lifetimeStats[t] = e.value;
              }, this),
          Array.isArray(e.statsArray)
            ? (i._stats = e.statsArray)
            : Array.isArray(e.statsList) &&
              e.statsList.forEach(function(e, t) {
                i._stats[t] = e.value;
              }, this),
          i.isLegend())
        ) {
          var n = repositories.PlayerIcon.get(i.getMaskedResourceId());
          i.iconId = n ? n.iconId : 0;
        }
        services.Configuration.checkFeatureEnabled(
          enums.ServerFeature.NEW_SERVER_PLAYER_ATTRIBUTES
        ) &&
          ((i._skillMoves = utils.JS.isNumber(e.skillmoves)
            ? e.skillmoves
            : -1),
          (i._weakFoot = e.weakfootabilitytypecode || -1),
          (i._offensiveWorkRate = utils.JS.isNumber(e.attackingworkrate)
            ? e.attackingworkrate
            : -1),
          (i._defensiveWorkRate = utils.JS.isNumber(e.defensiveworkrate)
            ? e.defensiveworkrate
            : -1),
          (i._preferredFoot = e.preferredfoot || -1));
        var o = repositories.PlayerMeta.get(i.getMaskedResourceId());
        o && i.setMetaData(o);
      }
      i._staticData.parseDynamicItemData(i, e),
        e.trainingItem && (i._trainingItem = this.createItem(e.trainingItem)),
        utils.JS.isNumber(e.marketDataMinPrice) &&
          utils.JS.isNumber(e.marketDataMaxPrice) &&
          (i._itemPriceLimits = new UTValueBandVO(
            e.marketDataMinPrice,
            e.marketDataMaxPrice
          ));
    }
    return (
      (ItemEntityFactory.prototype.createItem = function createItem(e) {
        if (!e) return new entities.NullItem();
        if (
          (e.itemType ||
            (e.itemType = e.cardassetid
              ? _convertCardAssetIdToItemType(e.cardassetid)
              : enums.ItemType.PLAYER),
          (e = _normalizePayload(e)).itemType === enums.ItemType.PLAYER)
        ) {
          var t = repositories.Item.getStaticDataByDefId(
            e.resourceId & enums.ItemMask.DATABASE
          );
          t &&
            ((e.firstName = t.firstName),
            (e.lastName = t.lastName),
            (e.knownAs = t.commonName || enums.Localization.BLANK_STR));
        }
        var i = new entities.Item(e.itemType);
        _parseItemPayload.call(this, i, e);
        var s = services.Configuration.getItemRarity(i);
        return s && (i.hasLevels = s.levels), i;
      }),
      (ItemEntityFactory.prototype.createConsumable = function createConsumable(
        e
      ) {
        if (!e) return new entities.NullItem();
        e.item.itemType ||
          (e.item.itemType = e.item.cardassetid
            ? _convertCardAssetIdToItemType(e.item.cardassetid)
            : enums.ItemType.PLAYER),
          (e.item = _normalizePayload(e.item));
        var t = new entities.Item(e.item.itemType);
        (function _parseConsumablePayload(e, t) {
          t.item.itemType || (t.item.itemType = e.type),
            _parseItemPayload.call(this, e, t.item),
            (e.discardValue = t.discardValue),
            (e.stackCount = t.count),
            (e.resourceId = t.resourceId),
            (e.untradeableCount = t.untradeableCount),
            e._updateUntradeableState();
        }.call(this, t, e));
        var i = services.Configuration.getItemRarity(t);
        return i && (t.hasLevels = i.levels), t;
      }),
      (ItemEntityFactory.prototype.createCustomBrickItem = function createItem(
        e
      ) {
        if (!e) return new entities.NullItem();
        e = _normalizePayload(e, !1);
        var t = new entities.CustomBrickItem();
        return _parseItemPayload.call(this, t, e), t;
      }),
      (ItemEntityFactory.prototype.generateItemsFromItemData = function generateItemsFromItemData(
        e,
        s
      ) {
        return e.map(function(e) {
          var t = utils.JS.isValid(e.count)
            ? this.createConsumable(e)
            : this.createItem(e);
          if (utils.JS.isValid(s)) {
            var i = utils.JS.find(s, function(e) {
              return e.itemId === t.id;
            });
            utils.JS.isValid(i) &&
              ((t.duplicateId = i.duplicateItemId),
              utils.JS.isValid(i.duplicateItemLoans) &&
                (t.duplicateItemLoans = i.duplicateItemLoans));
          }
          return t;
        }, this);
      }),
      (ItemEntityFactory.prototype.generateItemsFromAuctionData = function generateItemsFromAuctionData(
        e,
        n
      ) {
        return e.map(function(e) {
          var t = this.createItem(e.itemData),
            i = this._auctionFactory.createFromUtasObject(e);
          if (
            (t.setAuctionData(i),
            0 === t.id && (t.id = 'Trade' + i.tradeId),
            !t.isConsumable() && utils.JS.isValid(n))
          ) {
            var s = utils.JS.find(n, function(e) {
              return e.itemId === t.id;
            });
            utils.JS.isValid(s) && (t.duplicateId = s.duplicateItemId);
          }
          return t;
        }, this);
      }),
      new ItemEntityFactory()
    );
  })()),
  utils.JS.inherits(UTSquadSlotEntity, UTObject),
  (UTSquadSlotEntity.prototype.getIndex = function getIndex() {
    return this._index;
  }),
  (UTSquadSlotEntity.prototype.getItem = function getItem() {
    return this._item;
  }),
  (UTSquadSlotEntity.prototype.getKitNumber = function getKitNumber() {
    return this._kitNumber;
  }),
  (UTSquadSlotEntity.prototype.setItem = function setItem(e) {
    this._item && this._item.onDataUpdated.unobserve(this),
      (this._item = e),
      this._item.onDataUpdated.observe(this, this._eItemDataUpdated);
  }),
  (UTSquadSlotEntity.prototype.setKitNumber = function setKitNumber(e) {
    this._kitNumber = e;
  }),
  (UTSquadSlotEntity.prototype.getChemistry = function getChemistry() {
    return this._chemistry;
  }),
  (UTSquadSlotEntity.prototype.setChemistry = function setChemistry(e) {
    this._chemistry = Math.min(Math.max(e, 0), 10);
  }),
  (UTSquadSlotEntity.prototype.setPosition = function setPosition(e) {
    this._position = e;
  }),
  (UTSquadSlotEntity.prototype.getGeneralPosition = function getGeneralPosition() {
    return this._position ? this._position.getTypeId() : -1;
  }),
  (UTSquadSlotEntity.prototype.getUniquePosition = function getUniquePosition() {
    return this._position ? this._position.getId() : -1;
  }),
  (UTSquadSlotEntity.prototype.getGeneralPositionName = function getGeneralPositionName() {
    return this._position ? this._position.getTypeName() : '';
  }),
  (UTSquadSlotEntity.prototype.getUniquePositionName = function getUniquePositionName() {
    return this._position ? this._position.getName() : '';
  }),
  (UTSquadSlotEntity.prototype.setRequirement = function setRequirement(e) {
    this._requirement = e;
  }),
  (UTSquadSlotEntity.prototype.getRequirement = function getRequirement() {
    return this._requirement;
  }),
  (UTSquadSlotEntity.prototype.getManagerBonus = function getManagerBonus() {
    return this._managerBonus;
  }),
  (UTSquadSlotEntity.prototype.setManagerBonus = function setManagerBonus(e) {
    this._managerBonus = e;
  }),
  (UTSquadSlotEntity.prototype.getPositionBonus = function getPositionBonus() {
    return this._position &&
      this._item &&
      (this._item.isValid() || this.isCustomBrick())
      ? this._position.getBonus(this._item.preferredPosition)
      : 0;
  }),
  (UTSquadSlotEntity.prototype.hasChemistry = function hasChemistry() {
    return 0 < this._chemistry.get();
  }),
  (UTSquadSlotEntity.prototype.isBrick = function isBrick() {
    return this.isRegularBrick() || this.isCustomBrick();
  }),
  (UTSquadSlotEntity.prototype.isRegularBrick = function isRegularBrick() {
    return !!this._requirement && this._requirement.isRegularBrickType();
  }),
  (UTSquadSlotEntity.prototype.isCustomBrick = function isCustomBrick() {
    return !!this._requirement && this._requirement.isCustomBrickType();
  }),
  (UTSquadSlotEntity.prototype.isValid = function isValid() {
    return !!this._item && this._item.isValid();
  }),
  (UTSquadSlotEntity.prototype.compareTo = function compareTo(e) {
    return this.getIndex() === e.getIndex();
  }),
  (UTSquadSlotEntity.prototype._eItemDataUpdated = function _eItemDataUpdated(
    e,
    t,
    i
  ) {
    this.onDataUpdated.notify(this, {
      item: t
    });
  }),
  utils.JS.inherits(UTNullSquadSlotEntity, UTSquadSlotEntity),
  (UTNullSquadSlotEntity.prototype.getIndex = function getIndex() {
    return -1;
  }),
  (UTNullSquadSlotEntity.prototype.setItem = function setItem(e) {}),
  (UTNullSquadSlotEntity.prototype.setKitNumber = function setKitNumber(e) {}),
  (UTNullSquadSlotEntity.prototype.getChemistry = function getChemistry() {
    return 0;
  }),
  (UTNullSquadSlotEntity.prototype.setChemistry = function setChemistry(e) {}),
  (UTNullSquadSlotEntity.prototype.setPosition = function setPosition(e) {}),
  (UTNullSquadSlotEntity.prototype.getGeneralPosition = function getGeneralPosition() {
    return -1;
  }),
  (UTNullSquadSlotEntity.prototype.getUniquePosition = function getUniquePosition() {
    return -1;
  }),
  (UTNullSquadSlotEntity.prototype.setRequirement = function setRequirement(
    e
  ) {}),
  (UTNullSquadSlotEntity.prototype.getManagerBonus = function getManagerBonus() {
    return 0;
  }),
  (UTNullSquadSlotEntity.prototype.setManagerBonus = function setManagerBonus(
    e
  ) {}),
  (UTNullSquadSlotEntity.prototype.getPositionBonus = function getPositionBonus() {
    return 0;
  }),
  (UTNullSquadSlotEntity.prototype.hasChemistry = function hasChemistry() {
    return !1;
  }),
  (UTNullSquadSlotEntity.prototype.compareTo = function compareTo(e) {
    return !1;
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.SBCPlayerRequirement = function UTSBCPlayerRequirementDTO(
    e,
    t
  ) {
    var i;
    (this.index = e.index),
      Object.defineProperty(this, 'index', {
        writable: !1
      }),
      Object.defineProperty(this, 'playerType', {
        get: function() {
          return i;
        },
        set: function(e) {
          var t;
          for (t in enums.SBC.PLAYER_TYPE)
            if (
              enums.SBC.PLAYER_TYPE.hasOwnProperty(t) &&
              enums.SBC.PLAYER_TYPE[t] === e
            )
              return void (i = e);
          utils.Debug.Assert(
            !1,
            'Invalid playerType assignment to transferobjects.SBCPlayerRequirement'
          );
        }
      }),
      (this.playerType = e.playerType),
      (this.elgReq = t),
      Object.defineProperty(this, 'elgReq', {
        writable: !1
      });
  }),
  (transferobjects.SBCPlayerRequirement.prototype.isRegularBrickType = function isRegularBrickType() {
    return this.playerType === enums.SBC.PLAYER_TYPE.BRICK;
  }),
  (transferobjects.SBCPlayerRequirement.prototype.isCustomBrickType = function isCustomBrickType() {
    return this.playerType === enums.SBC.PLAYER_TYPE.CUSTOM_BRICK;
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.SquadPosition = function UTSquadPositionDTO(e, t) {
    (this._id = e.uniqueId),
      (this._typeId = e.typeId),
      (this._name = e.uniqueName),
      (this._typeName = e.typeName),
      (this._bonusLookup = t);
  }),
  (transferobjects.SquadPosition.prototype.getId = function getId() {
    return this._id;
  }),
  (transferobjects.SquadPosition.prototype.getTypeId = function getTypeId() {
    return this._typeId;
  }),
  (transferobjects.SquadPosition.prototype.getName = function getName() {
    return this._name;
  }),
  (transferobjects.SquadPosition.prototype.getTypeName = function getTypeName() {
    return this._typeName;
  }),
  (transferobjects.SquadPosition.prototype.getBonus = function getBonus(e) {
    return this._bonusLookup[e] || 0;
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.SquadLink = function UTSquadLinkDTO(e) {
    (this._posA = e.a), (this._posB = e.b);
  }),
  (transferobjects.SquadLink.prototype.getPositionA = function getPositionA() {
    return this._posA;
  }),
  (transferobjects.SquadLink.prototype.getPositionB = function getPositionB() {
    return this._posB;
  }),
  (transferobjects.SquadLink.prototype.containsPosition = function containsPosition(
    e
  ) {
    return e === this._posA || e === this._posB;
  }),
  (transferobjects.SquadLink.prototype.getLinkedPosition = function getLinkedPosition(
    e
  ) {
    return (
      utils.Debug.Assert(
        this.containsPosition(e),
        '[SquadLink::getLinkedPosition] Provided position not associated with chemistry link.'
      ),
      e === this._posA ? this._posB : this._posA
    );
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.SquadFormation = function UTSquadFormationDTO(e, t, i, s) {
    (this._id = e.id),
      (this._name = e.name),
      (this._displayName = services.Localization.localize(
        'global.formation.' + e.name
      )),
      (this._teamBonus = t),
      (this._positions = s),
      (this.generalPositions = e.generalPositionSlots),
      Object.defineProperty(this, 'generalPositions', {
        writable: !1
      }),
      (this.uniquePositions = e.uniquePositionSlots),
      Object.defineProperty(this, 'uniquePositions', {
        writable: !1
      }),
      (this._links = i);
  }),
  (transferobjects.SquadFormation.prototype.getId = function getId() {
    return this._id;
  }),
  (transferobjects.SquadFormation.prototype.getName = function getName() {
    return this._name;
  }),
  (transferobjects.SquadFormation.prototype.getDisplayName = function getDisplayName() {
    return this._displayName;
  }),
  (transferobjects.SquadFormation.prototype.getPositions = function getPositions() {
    return this._positions;
  }),
  (transferobjects.SquadFormation.prototype.getPosition = function getPosition(
    e
  ) {
    return this._positions[e] || null;
  }),
  (transferobjects.SquadFormation.prototype.getLinks = function getLinks() {
    return this._links;
  }),
  (transferobjects.SquadFormation.prototype.getTeamBonus = function getTeamBonus(
    e
  ) {
    return this._teamBonus[e] || 0;
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.SquadChemistryLink = function(e, t, i, s) {
    (this._posA = e),
      (this._posB = t),
      (this._chemistry = i),
      (this._isValid = s);
  }),
  (transferobjects.SquadChemistryLink.prototype.getPositionA = function getPositionA() {
    return this._posA;
  }),
  (transferobjects.SquadChemistryLink.prototype.getPositionB = function getPositionB() {
    return this._posB;
  }),
  (transferobjects.SquadChemistryLink.prototype.getChemistry = function getChemistry() {
    return this._chemistry;
  }),
  (transferobjects.SquadChemistryLink.prototype.isValid = function isValid() {
    return this._isValid;
  }),
  NamespaceManager.Register('entities'),
  (entities.Squad = function UTSquadEntity(e) {
    UTObject.call(this),
      (this.onDataUpdated = new UTObservable()),
      Object.defineProperty(this, 'onDataUpdated', {
        writable: !1,
        enumerable: !0
      }),
      (this._owner = 0),
      Object.defineProperty(this, '_owner', {
        enumerable: !1,
        writable: !0
      }),
      (this._id = -1),
      Object.defineProperty(this, '_id', {
        enumerable: !1,
        writable: !0
      }),
      (this._captain = 0),
      Object.defineProperty(this, '_captain', {
        enumerable: !1,
        writable: !0
      }),
      (this._name = ''),
      Object.defineProperty(this, '_name', {
        enumerable: !1,
        writable: !0
      }),
      (this._formation = null),
      Object.defineProperty(this, '_formation', {
        enumerable: !1,
        writable: !0
      }),
      (this._rating = 0),
      Object.defineProperty(this, '_rating', {
        enumerable: !1,
        writable: !0
      }),
      (this._chemistry = 0),
      Object.defineProperty(this, '_chemistry', {
        enumerable: !1,
        writable: !0
      }),
      (this._manager = new UTNullSquadSlotEntity()),
      Object.defineProperty(this, '_manager', {
        enumerable: !1,
        writable: !0
      }),
      (this._players = []),
      Object.defineProperty(this, '_players', {
        enumerable: !1,
        writable: !0
      }),
      (this._chemistryLinks = []),
      Object.defineProperty(this, '_chemistryLinks', {
        enumerable: !1,
        writable: !0
      }),
      (this._type = enums.SquadType.REGULAR),
      Object.defineProperty(this, '_type', {
        enumerable: !1,
        writable: !0
      }),
      (this._valid = !1),
      Object.defineProperty(this, '_valid', {
        enumerable: !1,
        writable: !0
      }),
      (this._isActive = !1),
      Object.defineProperty(this, '_isActive', {
        enumerable: !1,
        writable: !0
      }),
      (this._isTOTW = !1),
      Object.defineProperty(this, '_isTOTW', {
        enumerable: !1,
        writable: !0
      }),
      (this._isSBC = !1),
      Object.defineProperty(this, '_isSBC', {
        enumerable: !1,
        writable: !0
      }),
      (this._isShowOff = !1),
      Object.defineProperty(this, '_isShowOff', {
        enumerable: !1,
        writable: !0
      }),
      (this._timestamp = 0),
      Object.defineProperty(this, '_timestamp', {
        enumerable: !1,
        writable: !0
      }),
      (this._modified = !1),
      Object.defineProperty(this, '_modified', {
        enumerable: !1,
        writable: !0
      }),
      (this.simpleBrickIndices = []),
      (this.customBrickIndices = []),
      (this._mentalities = new UTHashTable()),
      Object.defineProperty(this, '_mentalities', {
        enumerable: !1,
        writable: !1
      }),
      (this._squadSaveDelegate = null),
      (this._squadDAO = e),
      Object.defineProperty(this, '_squadDAO', {
        enumerable: !1,
        writable: !1
      });
  }),
  utils.JS.inherits(entities.Squad, UTObject),
  (entities.Squad.TOTAL_PLAYERS_AND_MANAGER = 24),
  (entities.Squad.TOTAL_PLAYERS = 23),
  (entities.Squad.FIELD_PLAYERS = 11),
  (entities.Squad.SUB_PLAYERS = 7),
  (entities.Squad.RESERVE_PLAYERS = 5),
  (entities.Squad.MANAGER_SLOT_INDEX = 23),
  (entities.Squad.NATION_BONUS = 3),
  (entities.Squad.LEAGUE_BONUS = 3),
  (entities.Squad.CLUB_BONUS = 3),
  (entities.Squad.MANAGER_BONUS = 1),
  (entities.Squad.prototype.save = function save() {
    var i = new UTObservable();
    return (
      this._squadSaveDelegate
        ? this._squadSaveDelegate
            .save(this)
            .observe(this, function _onSquadSaveDelegateComplete(e, t) {
              e.unobserve(this),
                i.notify(t),
                t.success &&
                  (this.setCacheTimestamp(Date.now()),
                  (this._modified = !1),
                  getDefaultDispatcher().notify(
                    enums.Notification.SQUAD_SAVE,
                    this,
                    this
                  ));
            })
        : this._squadDAO
            .save(this)
            .observe(this, function _onSquadSaveComplete(e, t) {
              e.unobserve(this),
                i.notify(t),
                t.success &&
                  (this.setCacheTimestamp(Date.now()),
                  (this._modified = !1),
                  getDefaultDispatcher().notify(
                    enums.Notification.SQUAD_SAVE,
                    this,
                    this
                  ));
            }),
      i
    );
  }),
  (entities.Squad.prototype.setCacheTimestamp = function setCacheTimestamp(e) {
    this._timestamp = e;
  }),
  (entities.Squad.prototype.getOwner = function getOwner() {
    return this._owner;
  }),
  (entities.Squad.prototype.getId = function getId() {
    return this._id;
  }),
  (entities.Squad.prototype.getCaptain = function getCaptain() {
    return this._captain;
  }),
  (entities.Squad.prototype.getManager = function getManager() {
    return this._manager;
  }),
  (entities.Squad.prototype.getPlayer = function getPlayer(e) {
    return (
      utils.Debug.Assert(
        this._isValidPlayerSlot(e),
        '[Squad::getPlayer] Invalid slot value provided.'
      ),
      this.getSlot(e)
    );
  }),
  (entities.Squad.prototype.getPlayers = function getPlayers() {
    return this._players;
  }),
  (entities.Squad.prototype.getFieldPlayers = function getFieldPlayers() {
    return this._players.slice(0, entities.Squad.FIELD_PLAYERS);
  }),
  (entities.Squad.prototype.getSubPlayers = function getSubPlayers() {
    return this._players.slice(
      entities.Squad.FIELD_PLAYERS,
      entities.Squad.FIELD_PLAYERS + entities.Squad.SUB_PLAYERS
    );
  }),
  (entities.Squad.prototype.getReservePlayers = function getReservePlayers() {
    return this._players.slice(
      entities.Squad.FIELD_PLAYERS + entities.Squad.SUB_PLAYERS,
      entities.Squad.TOTAL_PLAYERS
    );
  }),
  (entities.Squad.prototype.getSubAndReservePlayers = function getSubAndReservePlayers() {
    return this._players.slice(
      entities.Squad.FIELD_PLAYERS,
      entities.Squad.TOTAL_PLAYERS
    );
  }),
  (entities.Squad.prototype.getFieldAndSubPlayers = function getFieldAndSubPlayers() {
    return this._players.slice(
      0,
      entities.Squad.FIELD_PLAYERS + entities.Squad.SUB_PLAYERS
    );
  }),
  (entities.Squad.prototype.getPlayersByZone = function getPlayersByZone() {
    var i = {};
    return (
      this._players.forEach(function(e) {
        var t = enums.SquadPositionZones[e.getUniquePosition()];
        utils.JS.isValid(t) &&
          (i.hasOwnProperty(t) || (i[t] = []), i[t].push(e));
      }, this),
      i
    );
  }),
  (entities.Squad.prototype._getSlotByUniquePosition = function _getSlotByUniquePosition(
    t
  ) {
    var e = utils.JS.find(this.getFieldPlayers(), function(e) {
      return e.getUniquePosition() === t;
    });
    return (
      e ||
      (utils.Debug.Assert(
        !1,
        '[Squad::_getPlayerByUniqueSlotId] Unable to find a slot associated with the unique position: ' +
          t
      ),
      new UTNullSquadSlotEntity())
    );
  }),
  (entities.Squad.prototype.getSlot = function getSlot(e) {
    return utils.JS.isNumber(e)
      ? this._getSlotByIndex(e)
      : e instanceof entities.Item
      ? this._getSlotByItem(e)
      : new UTNullSquadSlotEntity();
  }),
  (entities.Squad.prototype._getSlotByIndex = function _getSlotByIndex(e) {
    return e === entities.Squad.MANAGER_SLOT_INDEX
      ? this._manager
      : this._isValidPlayerSlot(e)
      ? this._players[e]
      : new UTNullSquadSlotEntity();
  }),
  (entities.Squad.prototype._getSlotByItem = function _getSlotByItem(t) {
    return this._manager.getItem().id === t.id && t.isValid()
      ? this._manager
      : (t.isValid()
          ? utils.JS.find(this._players, function(e) {
              return e.getItem().id === t.id;
            })
          : utils.JS.find(this._players, function(e) {
              return e.getItem() === t;
            })) || new UTNullSquadSlotEntity();
  }),
  (entities.Squad.prototype.getSlots = function getSlots() {
    var e = this._filterBrickIndices(this._players);
    return this._manager && !this.isSBC() && (e = e.concat(this._manager)), e;
  }),
  (entities.Squad.prototype.getType = function getType() {
    return this._type;
  }),
  (entities.Squad.prototype.getName = function getName() {
    return this._name;
  }),
  (entities.Squad.prototype.setName = function setName(e, t) {
    (this._name = utils.TextUtils.createSquadName(e, t)),
      (this._modified = !0),
      this.onDataUpdated.notify({
        name: this._name
      });
  }),
  (entities.Squad.prototype.getFormation = function getFormation() {
    return this._formation;
  }),
  (entities.Squad.prototype.setFormation = function setFormation(e) {
    if (this._formation.getId() !== e.getId()) {
      (this._formation = e),
        this._players.forEach(function(e) {
          e.setPosition(this._formation.getPosition(e.getIndex()));
        }, this),
        this.updateChemistry();
      var t = this._mentalities.get(UTSquadMentalityEntity.TYPE.BALANCED);
      utils.Debug.Assert(
        utils.JS.isValid(t),
        'Could not find balanced tactics mentality.'
      ),
        t && t.setFormation(e),
        (this._modified = !0),
        this.onDataUpdated.notify({
          slots: this._players.slice(0, entities.Squad.FIELD_PLAYERS),
          chemistry: this.getChemistry(),
          formation: this._formation
        });
    }
  }),
  (entities.Squad.prototype.getStarRating = function getStarRating() {
    var e = this._rating,
      t = 0;
    return e <= enums.TeamStarRanges.RATING_0_0
      ? t
      : (t =
          e <= enums.TeamStarRanges.RATING_0_5
            ? 0.5
            : e <= enums.TeamStarRanges.RATING_1_0
            ? 1
            : e <= enums.TeamStarRanges.RATING_1_5
            ? 1.5
            : e <= enums.TeamStarRanges.RATING_2_0
            ? 2
            : e <= enums.TeamStarRanges.RATING_2_5
            ? 2.5
            : e <= enums.TeamStarRanges.RATING_3_0
            ? 3
            : e <= enums.TeamStarRanges.RATING_3_5
            ? 3.5
            : e <= enums.TeamStarRanges.RATING_4_0
            ? 4
            : e <= enums.TeamStarRanges.RATING_4_5
            ? 4.5
            : 5);
  }),
  (entities.Squad.prototype.getRating = function getRating() {
    return this._rating;
  }),
  (entities.Squad.prototype.getChemistry = function getChemistry() {
    return this._chemistry;
  }),
  (entities.Squad.prototype.getChemistryLinks = function getChemistryLinks() {
    return this._chemistryLinks;
  }),
  (entities.Squad.prototype.setActive = function setActive(e) {
    this._isActive !== e &&
      ((this._isActive = e),
      this.onDataUpdated.notify({
        active: this._isActive
      }));
  }),
  (entities.Squad.prototype.setTOTW = function setTOTW(e) {
    this._isTOTW = e;
  }),
  (entities.Squad.prototype.setSBC = function setSBC(e) {
    this._isSBC = e;
  }),
  (entities.Squad.prototype.setSaveDelegate = function setSaveDelegate(e) {
    this._squadSaveDelegate = e;
  }),
  (entities.Squad.prototype.setShowOff = function setShowOff(e) {
    this._isShowOff = e;
  }),
  (entities.Squad.prototype.getSlotsLinkedToPosition = function getSlotsLinkedToPosition(
    i
  ) {
    var s = this;
    return this._chemistryLinks.reduce(function(e, t) {
      return (
        t.getPositionA() === i
          ? e.push(s._getSlotByUniquePosition(t.getPositionB()))
          : t.getPositionB() === i &&
            e.push(s._getSlotByUniquePosition(t.getPositionA())),
        e
      );
    }, []);
  }),
  (entities.Squad.prototype.getBestAvailableEmptySlotIndex = function getBestAvailableEmptySlotIndex(
    s,
    n
  ) {
    var o, a;
    n = !utils.JS.isBoolean(n) || n;
    var r = 0,
      l = 0,
      c = -1;
    return (
      this.getPlayers()
        .filter(function getEmptySlots(e) {
          return !e.isValid();
        })
        .forEach(function checkIfBestSlot(e) {
          if (!(e.getIndex() < entities.Squad.FIELD_PLAYERS))
            return 0 < r ? c : e.getIndex();
          if ((e.setItemData(s), (a = e.getPositionBonus()), n)) {
            var t;
            for (t = o = 0; t < entities.Squad.FIELD_PLAYERS; ++t) {
              var i = this._players[t];
              o += this._calculateSlotChemistry(i);
            }
            (r < o || l < a) && ((r = o), (l = a), (c = e.getIndex()));
          } else r < a && ((r = a), (c = e.getIndex()));
          this._emptySlot(e);
        }, this),
      c
    );
  }),
  (entities.Squad.prototype.getManagerBonusImpact = function getManagerBonusImpact(
    t
  ) {
    var i = [];
    return (
      t.isManager() &&
        this._players.forEach(function(e) {
          0 < this._calculateManagerBonus(e.getItem(), t) &&
            i.push(e.getIndex());
        }, this),
      i
    );
  }),
  (entities.Squad.prototype._getPlayersForCounters = function _getPlayersForCounters(
    e
  ) {
    return this.getNonBrickSlots(e).filter(function(e) {
      return e.isValid();
    });
  }),
  (entities.Squad.prototype._clubCounter = function _clubCounter(e) {
    var i = {};
    return (
      this._getPlayersForCounters(e).forEach(function incrementClubCount(e) {
        var t = e.getItem().teamId;
        i[t] ? i[t].push(e.getIndex()) : (i[t] = [e.getIndex()]);
      }, this),
      i
    );
  }),
  (entities.Squad.prototype._leagueCounter = function _leagueCounter(e) {
    var i = {};
    return (
      this._getPlayersForCounters(e).forEach(function incrementLeagueCount(e) {
        var t = e.getItem().leagueId;
        i[t] ? i[t].push(e.getIndex()) : (i[t] = [e.getIndex()]);
      }, this),
      i
    );
  }),
  (entities.Squad.prototype._nationCounter = function _nationCounter(e) {
    var i = {};
    return (
      this._getPlayersForCounters(e).forEach(function incrementNationCount(e) {
        var t = e.getItem().nationId;
        i[t] ? i[t].push(e.getIndex()) : (i[t] = [e.getIndex()]);
      }, this),
      i
    );
  }),
  (entities.Squad.prototype._qualityCounter = function _qualityCounter(e) {
    var i = {};
    return (
      this._getPlayersForCounters(e).forEach(function incrementTierCount(e) {
        var t = e.getItem().getTier();
        i[t] ? i[t].push(e.getIndex()) : (i[t] = [e.getIndex()]);
      }, this),
      i
    );
  }),
  (entities.Squad.prototype._playerCountHelper = function _playerCountHelper(
    e,
    i
  ) {
    return Array.isArray(e)
      ? e.reduce(
          function(e, t) {
            return e + i.call(this, t);
          }.bind(this),
          0
        )
      : i.call(this, e);
  }),
  (entities.Squad.prototype.getNumberOfPlayersByRarity = function getNumberOfPlayersByRarity(
    e,
    t
  ) {
    return this._playerCountHelper(e, function(i) {
      return this.getNonBrickSlots(t).reduce(
        function(e, t) {
          return t.isValid() && t.getItem().rareflag === i ? ++e : e;
        }.bind(this),
        0
      );
    });
  }),
  (entities.Squad.prototype.getNumberOfPlayersByGroup = function getNumberOfPlayersByGroup(
    e,
    t
  ) {
    return this._playerCountHelper(e, function(i) {
      return this.getNonBrickSlots(t).reduce(
        function(e, t) {
          return t.isValid() && t.getItem().belongsToGroup(i) ? ++e : e;
        }.bind(this),
        0
      );
    });
  }),
  (entities.Squad.prototype.getPlayersPerQualityTier = function getPlayersPerQualityTier() {
    var i = this._qualityCounter();
    return new UTHashTable(
      Object.keys(i).reduce(function(e, t) {
        return (e[t] = i[t].length), e;
      }, {})
    );
  }),
  (entities.Squad.prototype.getSlotIndicesByQualityTier = function getSlotIndicesByQualityTier(
    e,
    t
  ) {
    return this._qualityCounter(t)[e] || [];
  }),
  (entities.Squad.prototype.getNumberOfPlayersByQualityTier = function getNumberOfPlayersByQualityTier(
    e,
    t
  ) {
    return this._playerCountHelper(e, function(i) {
      return this.getNonBrickSlots(t).reduce(
        function(e, t) {
          return t.isValid() && t.getItem().getTier() === i ? ++e : e;
        }.bind(this),
        0
      );
    });
  }),
  (entities.Squad.prototype.getPlayersPerLeague = function getPlayersPerLeague() {
    var i = this._leagueCounter();
    return new UTHashTable(
      Object.keys(i).reduce(function(e, t) {
        return (e[t] = i[t].length), e;
      }, {})
    );
  }),
  (entities.Squad.prototype.getPopularLeagues = function getPopularLeagues() {
    return utils.JS.getSortedKeys(this._leagueCounter());
  }),
  (entities.Squad.prototype.getSlotIndicesByLeague = function getSlotIndicesByLeague(
    e,
    t
  ) {
    return this._leagueCounter(t)[e] || [];
  }),
  (entities.Squad.prototype.getNumberOfPlayersByLeague = function getNumberOfPlayersByLeague(
    e,
    t
  ) {
    return this._playerCountHelper(e, function(i) {
      return this.getNonBrickSlots(t).reduce(
        function(e, t) {
          return t.isValid() && t.getItem().leagueId === i ? ++e : e;
        }.bind(this),
        0
      );
    });
  }),
  (entities.Squad.prototype.getPopularClubs = function getPopularClubs() {
    return utils.JS.getSortedKeys(this._clubCounter());
  }),
  (entities.Squad.prototype.getPlayersPerClub = function getPlayersPerClub() {
    var i = this._clubCounter();
    return new UTHashTable(
      Object.keys(i).reduce(function(e, t) {
        return (e[t] = i[t].length), e;
      }, {})
    );
  }),
  (entities.Squad.prototype.getSlotIndicesByClub = function getSlotIndicesByClub(
    e,
    t
  ) {
    return this._clubCounter(t)[e] || [];
  }),
  (entities.Squad.prototype.getNumberOfPlayersByClub = function getNumberOfPlayersByClub(
    e,
    t
  ) {
    return this._playerCountHelper(e, function(i) {
      return this.getNonBrickSlots(t).reduce(
        function(e, t) {
          return t.isValid() && t.getItem().teamId === i ? ++e : e;
        }.bind(this),
        0
      );
    });
  }),
  (entities.Squad.prototype.getPopularNationalities = function getPopularNationalities() {
    return utils.JS.getSortedKeys(this._nationCounter());
  }),
  (entities.Squad.prototype.getPlayersPerNation = function getPlayersPerNation() {
    var i = this._nationCounter();
    return new UTHashTable(
      Object.keys(i).reduce(function(e, t) {
        return (e[t] = i[t].length), e;
      }, {})
    );
  }),
  (entities.Squad.prototype.getSlotIndicesByNation = function getSlotIndicesByNation(
    e,
    t
  ) {
    return this._nationCounter(t)[e] || [];
  }),
  (entities.Squad.prototype.getNumberOfPlayersByNation = function getNumberOfPlayersByNation(
    e,
    t
  ) {
    return this._playerCountHelper(e, function(i) {
      return this.getNonBrickSlots(t).reduce(
        function(e, t) {
          return t.isValid() && t.getItem().nationId === i ? ++e : e;
        }.bind(this),
        0
      );
    });
  }),
  (entities.Squad.prototype.getNumberOfLegends = function getNumberOfLegends() {
    return this.getNonBrickSlots().reduce(function(e, t) {
      return t.getItem().isLegend() ? ++e : e;
    }, 0);
  }),
  (entities.Squad.prototype.getBestPlayerByZone = function getBestPlayerByZone(
    e
  ) {
    var t = this.getPlayersByZone()[e],
      i = null;
    return (
      t.forEach(function getBestPlayer(e) {
        (!i || i.getItem().rating < e.getItem().rating) && (i = e);
      }, this),
      i
    );
  }),
  (entities.Squad.prototype.getAverageRatingByZone = function getAverageRatingByZone(
    e
  ) {
    var t = this.getPlayersByZone()[e],
      i = 0;
    if (t.length < 1) return i;
    return (
      t.forEach(function incrementRatingTotal(e) {
        i += e.getItem().rating;
      }, this),
      Math.floor(i / t.length)
    );
  }),
  (entities.Squad.prototype.replaceDreamItem = function replaceDreamItem(t) {
    var e = utils.JS.find(this.getPlayers(), function(e) {
      return e.getItem().compareDream(t);
    });
    e && this._addItemToSlot(e, t);
  }),
  (entities.Squad.prototype._calculateChemistry = function _calculateChemistry() {
    var t = 0;
    this.getFieldPlayers().forEach(function(e) {
      this._isSlotChemCalculable(e) && (t += e.getChemistry());
    }, this),
      (this._chemistry = Math.min(Math.max(Math.round(t), 0), 100));
  }),
  (entities.Squad.prototype._calculateRating = function _calculateRating() {
    var e = this.isSBC()
        ? this.getFieldPlayers()
        : this.getFieldAndSubPlayers(),
      t = services.Configuration.checkFeatureEnabled(
        enums.ServerFeature.SQUAD_RATING_FLOAT_CALCULATION_ENABLED
      ),
      s = 0,
      n = entities.Squad.FIELD_PLAYERS;
    if (
      (e.forEach(function(e, t) {
        var i = e.getItem();
        i.isValid() &&
          ((s += i.rating), t >= entities.Squad.FIELD_PLAYERS && n++);
      }),
      t)
    ) {
      var o = s,
        a = o;
      0 < n && (o /= n),
        (o = Math.min(o, 99)),
        e.forEach(function(e, t) {
          var i = e.getItem();
          if (i.isValid()) {
            if (i.rating <= o) return;
            t < entities.Squad.FIELD_PLAYERS
              ? (a += i.rating - o)
              : (a += 0.5 * (i.rating - o));
          }
        }),
        (s = Math.round(a));
    } else {
      var r = Math.min(Math.floor(s / n), 99);
      e.forEach(function(e, t) {
        var i = e.getItem();
        if (i.isValid()) {
          if (i.rating <= r) return;
          t < entities.Squad.FIELD_PLAYERS
            ? (s += i.rating - r)
            : (s += Math.floor(0.5 * (i.rating - r)));
        }
      });
    }
    this._rating = Math.min(Math.max(Math.floor(s / n), 0), 99);
  }),
  (entities.Squad.prototype._calculateLinkChemistry = function _calculateLinkChemistry(
    e,
    t
  ) {
    var i = 0;
    if (this._isSlotChemCalculable(e) && this._isSlotChemCalculable(t)) {
      var s = e.getItem(),
        n = t.getItem(),
        o =
          s.isLegend() ||
          s.isCharityItem() ||
          n.isLegend() ||
          n.isCharityItem();
      0 < s.nationId &&
        s.nationId === n.nationId &&
        (i += entities.Squad.NATION_BONUS),
        0 < s.teamId &&
          s.teamId === n.teamId &&
          (i += entities.Squad.CLUB_BONUS),
        (o || (0 < s.leagueId && s.leagueId === n.leagueId)) &&
          (i += entities.Squad.LEAGUE_BONUS);
    }
    return i;
  }),
  (entities.Squad.prototype.updateChemistry = function updateChemistry() {
    this._updateChemistryLinks(),
      this._players.forEach(this._calculateSlotChemistry, this),
      this._calculateChemistry();
  }),
  (entities.Squad.prototype._updateChemistryLinks = function _updateChemistryLinks() {
    this._players.length < 1 ||
      ((this._chemistryLinks = []),
      this._formation.getLinks().forEach(function(e) {
        var t = e.getPositionA(),
          i = e.getPositionB(),
          s = this._getSlotByUniquePosition(t),
          n = this._getSlotByUniquePosition(i),
          o = 0,
          a = this._isSlotChemCalculable(s) && this._isSlotChemCalculable(n);
        a && (o = this._calculateLinkChemistry(s, n)),
          this._chemistryLinks.push(
            new transferobjects.SquadChemistryLink(t, i, o, a)
          );
      }, this));
  }),
  (entities.Squad.prototype._calculateSlotChemistry = function _calculateSlotChemistry(
    e
  ) {
    var t = 0;
    if (this._isSlotChemCalculable(e)) {
      var i = e.getItem();
      if (
        ((t += Math.round(
          e.getPositionBonus() * this._calculateConnectionBonus(e)
        )),
        this.hasManager())
      ) {
        var s = this._calculateManagerBonus(i, this._manager.getItem());
        (t += s), e.setManagerBonus(s);
      }
      t += i.loyaltyBonus;
    }
    e.setChemistry(t);
  }),
  (entities.Squad.prototype._calculateManagerBonus = function _calculateManagerBonus(
    e,
    t
  ) {
    return (
      utils.Debug.Assert(
        e.isPlayer(),
        '[Squad::_calculateManagerBonus] First parameter expected to be a player item.'
      ),
      utils.Debug.Assert(
        t.isManager(),
        '[Squad::_calculateManagerBonus] Second parameter expected to be a manager item.'
      ),
      e.nationId === t.nationId || e.leagueId === t.leagueId
        ? entities.Squad.MANAGER_BONUS
        : 0
    );
  }),
  (entities.Squad.prototype._calculateConnectionBonus = function _calculateConnectionBonus(
    i
  ) {
    if (
      i.getIndex() >= entities.Squad.FIELD_PLAYERS ||
      !this._isSlotChemCalculable(i)
    )
      return 0;
    var s = 0,
      n = 0;
    this._chemistryLinks.forEach(function(e) {
      var t = i.getUniquePosition();
      !e.isValid() ||
        (e.getPositionA() !== t && e.getPositionB() !== t) ||
        ((s += e.getChemistry()), ++n);
    }, this);
    var e = 0;
    return (
      5 <= (s = 0 < n ? s / n : 0)
        ? (e = 3)
        : 3 <= s
        ? (e = 2)
        : 1 <= s && (e = 1),
      this._formation.getTeamBonus(e)
    );
  }),
  (entities.Squad.prototype.isCacheExpired = function isCacheExpired() {
    return Date.now() > this._timestamp + 3e5;
  }),
  (entities.Squad.prototype.isModified = function isModified() {
    return this._modified;
  }),
  (entities.Squad.prototype.isDream = function isDream() {
    return this._type === enums.SquadType.DREAM;
  }),
  (entities.Squad.prototype.isValid = function isValid() {
    return this._valid;
  }),
  (entities.Squad.prototype.isActive = function isActive() {
    return this._isActive;
  }),
  (entities.Squad.prototype.isTOTW = function isTOTW() {
    return this._isTOTW;
  }),
  (entities.Squad.prototype.isSBC = function isSBC() {
    return this._isSBC;
  }),
  (entities.Squad.prototype.isShowOff = function isShowOff() {
    return this._isShowOff;
  }),
  (entities.Squad.prototype.isStartingElevenComplete = function isStartingElevenComplete() {
    return this._slotsHaveValidPlayers(0, entities.Squad.FIELD_PLAYERS);
  }),
  (entities.Squad.prototype.areSubsComplete = function areSubsComplete() {
    return this._slotsHaveValidPlayers(
      entities.Squad.FIELD_PLAYERS,
      entities.Squad.FIELD_PLAYERS + entities.Squad.SUB_PLAYERS
    );
  }),
  (entities.Squad.prototype.areReservesComplete = function areReservesComplete() {
    return this._slotsHaveValidPlayers(
      entities.Squad.FIELD_PLAYERS + entities.Squad.SUB_PLAYERS,
      entities.Squad.MANAGER_SLOT_INDEX
    );
  }),
  (entities.Squad.prototype.isValidForTOTW = function isValidForTOTW() {
    return this._slotsHaveValidPlayers(
      0,
      entities.Squad.FIELD_PLAYERS + entities.Squad.SUB_PLAYERS
    );
  }),
  (entities.Squad.prototype.isSquadFull = function isSquadFull() {
    var e = utils.JS.find(this.getNonBrickSlots(), function(e) {
      return !e.isValid();
    });
    return !utils.JS.isValid(e);
  }),
  (entities.Squad.prototype.isSquadEmpty = function isSquadEmpty() {
    var e = utils.JS.find(this._players, function(e) {
      return e.isValid();
    });
    return !utils.JS.isValid(e);
  }),
  (entities.Squad.prototype.isSquadLoaded = function isSquadLoaded() {
    if (this._manager.getItem() instanceof entities.NullItem) return !1;
    var e = utils.JS.find(this._players, function(e) {
      return !(e.getItem() instanceof entities.NullItem);
    });
    return utils.JS.isValid(e);
  }),
  (entities.Squad.prototype._slotsHaveValidPlayers = function _slotsHaveValidPlayers(
    e,
    t
  ) {
    var i;
    for (i = e; i < t; ++i) if (!this._getSlotByIndex(i).isValid()) return !1;
    return !0;
  }),
  (entities.Squad.prototype._isValidPlayerSlot = function _isValidPlayerSlot(
    e
  ) {
    return 0 <= e && e < entities.Squad.MANAGER_SLOT_INDEX;
  }),
  (entities.Squad.prototype._isValidSlotIndex = function _isValidSlotIndex(e) {
    return 0 <= e && e <= entities.Squad.MANAGER_SLOT_INDEX;
  }),
  (entities.Squad.prototype.containsDreamItem = function containsDreamItem(e) {
    if (this.isDream() && 0 !== e.getMaskedResourceId()) {
      var t,
        i = this._players.length;
      for (t = 0; t < i; t++) {
        var s = this._players[t];
        if (s.getItem().compareDream(e)) return s.getIndex();
      }
    }
    return -1;
  }),
  (entities.Squad.prototype.containsVariationOfCard = function containsVariationOfCard(
    e
  ) {
    if (0 !== e.getMaskedResourceId()) {
      var t,
        i = this._players.length;
      for (t = 0; t < i; t++) {
        if (this._players[t].getItem().compareResourceTo(e)) return !0;
      }
    }
    return !1;
  }),
  (entities.Squad.prototype.containsItem = function containsItem(e, t) {
    if (0 === e.resourceId) return !1;
    if (e.resourceId === this._manager.getItem().resourceId) return !0;
    for (var i = this._players.length; 0 < i--; ) {
      var s = this._players[i].getItem();
      if (
        e.compareResourceTo(s, t) &&
        (e.concept || e.pile === s.pile) &&
        (!t || e.isLoaned() === s.isLoaned())
      )
        return !0;
    }
    return !1;
  }),
  (entities.Squad.prototype.hasManager = function hasManager() {
    return this._manager.isValid();
  }),
  (entities.Squad.prototype.swapPlayersByIndex = function swapPlayersByIndex(
    e,
    t
  ) {
    utils.Debug.Assert(
      this._isValidPlayerSlot(e),
      '[Squad::swapPlayersByIndex] Invalid slot index provided for first parameter.'
    ),
      utils.Debug.Assert(
        this._isValidPlayerSlot(t),
        '[Squad::swapPlayersByIndex] Invalid slot index provided for second parameter.'
      );
    var i = this.getSlot(e),
      s = this.getSlot(t),
      n = i.getItem(),
      o = s.getItem(),
      a = i.getKitNumber(),
      r = s.getKitNumber();
    i.setItem(o),
      s.setItem(n),
      i.setKitNumber(r),
      s.setKitNumber(a),
      this.updateChemistry(),
      this._calculateRating(),
      this.isSBC() && this._updateType(),
      (this._modified = !0),
      this.onDataUpdated.notify({
        slots: [i, s],
        chemistry: this.getChemistry(),
        rating: this.getRating(),
        type: this.getType()
      });
  }),
  (entities.Squad.prototype._addItemToSlot = function _addItemToSlot(e, t) {
    var i = e.getItem(),
      s = e.getIndex();
    return (
      e.setItem(t),
      (s < entities.Squad.FIELD_PLAYERS || t.isManager()) &&
        this.updateChemistry(),
      s < entities.Squad.FIELD_PLAYERS + entities.Squad.SUB_PLAYERS &&
        this._calculateRating(),
      this._updateType(),
      i
    );
  }),
  (entities.Squad.prototype.addItemToSlot = function addItemToSlot(e, t) {
    var i = null;
    if (
      (utils.Debug.Assert(
        this._isValidSlotIndex(e),
        'Invalid squad slot index: ' + e
      ),
      this._isValidSlotIndex(e))
    ) {
      var s = this.getSlot(e);
      (i = this._addItemToSlot(s, t)),
        (this._modified = !0),
        this.onDataUpdated.notify({
          slots: [s],
          chemistry: this.getChemistry(),
          rating: this.getRating(),
          type: this.getType()
        });
    }
    return i;
  }),
  (entities.Squad.prototype._emptySlot = function _emptySlot(e) {
    var t = e.getItem().isManager()
      ? new entities.Item(enums.ItemType.MANAGER)
      : new entities.Item();
    (t.playStyle = DEFAULT_PLAYSTYLE_ID), e.setItem(t);
  }),
  (entities.Squad.prototype._removeItemFromSlot = function _removeItemFromSlot(
    e
  ) {
    this._emptySlot(e);
    var t = e.getIndex();
    (t < entities.Squad.FIELD_PLAYERS || e.getItem().isManager()) &&
      this.updateChemistry(),
      t < entities.Squad.FIELD_PLAYERS + entities.Squad.SUB_PLAYERS &&
        this._calculateRating(),
      this._updateType();
  }),
  (entities.Squad.prototype.removeItemFromSlot = function removeItemFromSlot(
    e
  ) {
    if (this._isValidSlotIndex(e)) {
      var t = this.getSlot(e);
      this._removeItemFromSlot(t),
        (this._modified = !0),
        this.onDataUpdated.notify({
          slots: [t],
          chemistry: this.getChemistry(),
          rating: this.getRating(),
          type: this.getType()
        });
    }
  }),
  (entities.Squad.prototype.removeItem = function removeItem(e) {
    var t = this.getSlot(e);
    t.isValid() &&
      (this._removeItemFromSlot(t),
      (this._modified = !0),
      this.onDataUpdated.notify({
        slots: [t],
        chemistry: this.getChemistry(),
        rating: this.getRating(),
        type: this.getType()
      }));
  }),
  (entities.Squad.prototype.update = function update(e) {
    var t = this.isSquadLoaded();
    (this._chemistry = e.getChemistry()),
      (this._rating = e.getRating()),
      (this._name = e.getName()),
      (this._formation = e.getFormation()),
      (this._type = e.getType()),
      (this._valid = e.isValid()),
      (this._captain = e.getCaptain()),
      this._manager && this._manager.onDataUpdated.unobserve(this),
      (this._manager = e.getManager()),
      this._manager.onDataUpdated.observe(this, this._eSlotDataUpdated),
      0 < this._players.length &&
        this._players.forEach(function(e) {
          e.onDataUpdated.unobserve(this);
        }, this),
      (this._players = e.getPlayers()),
      0 < this._players.length &&
        (this._updateChemistryLinks(),
        this._players.forEach(function(e) {
          this._calculateSlotChemistry(e),
            e.onDataUpdated.observe(this, this._eSlotDataUpdated);
        }, this)),
      t &&
        ((this._modified = !0),
        this.onDataUpdated.notify({
          chemistry: this.getChemistry(),
          formation: this.getFormation(),
          name: this.getName(),
          rating: this.getRating(),
          slots: this.getPlayers().concat(this.getManager()),
          type: this.getType()
        }));
  }),
  (entities.Squad.prototype.setPlayers = function setPlayers(e, t) {
    var i = null,
      s = [];
    (e = e.slice(0, entities.Squad.TOTAL_PLAYERS)),
      t &&
        e.forEach(function(e, t) {
          (i = this.getSlot(t)),
            e && e.isPlayer() && !i.isBrick() && this._emptySlot(i);
        }, this),
      e.forEach(function(e, t) {
        (i = this.getSlot(t)),
          e &&
            e.isPlayer() &&
            !i.isBrick() &&
            !this.containsVariationOfCard(e) &&
            (this._addItemToSlot(i, e), s.push(i));
      }, this),
      0 < s.length &&
        ((this._modified = !0),
        this.onDataUpdated.notify({
          slots: s,
          chemistry: this.getChemistry(),
          rating: this.getRating(),
          type: this.getType()
        }));
  }),
  (entities.Squad.prototype.removeAllItems = function removeAllItems(e) {
    var t = [];
    this.getNonBrickSlots(!0).forEach(function(e) {
      e.isValid() && (this._removeItemFromSlot(e), t.push(e));
    }, this);
    var i = 0 < t.length;
    return (
      !e &&
        this.hasManager() &&
        (this._removeItemFromSlot(this._manager),
        t.push(this._manager),
        (i = !0)),
      i &&
        ((this._modified = !0),
        this.onDataUpdated.notify({
          slots: t,
          chemistry: this.getChemistry(),
          rating: this.getRating(),
          type: this.getType()
        })),
      i
    );
  }),
  (entities.Squad.prototype._isSlotChemCalculable = function _isSlotChemCalculable(
    e
  ) {
    return e.isValid() || this._isSlotCustomBrick(e.getIndex());
  }),
  (entities.Squad.prototype._updateType = function _updateType() {
    var e = this.isSBC() ? this.getFieldPlayers() : this.getPlayers(),
      t = enums.SquadType.REGULAR;
    utils.JS.isValid(
      utils.JS.find(e, function(e) {
        return e.getItem().concept;
      })
    ) && (t = enums.SquadType.DREAM),
      (this._type = t);
  }),
  (entities.Squad.prototype.compareTo = function compareTo(e) {
    return this.getId() === e.getId();
  }),
  (entities.Squad.prototype._filterBrickIndices = function _filterBrickIndices(
    e
  ) {
    return e.filter(function(e) {
      return -1 === this.getAllBrickIndices().indexOf(e.getIndex());
    }, this);
  }),
  (entities.Squad.prototype._filterSimpleBrickIndices = function _filterSimpleBrickIndices(
    e
  ) {
    return e.filter(function(e) {
      return -1 === this.simpleBrickIndices.indexOf(e.getIndex());
    }, this);
  }),
  (entities.Squad.prototype.getAllBrickIndices = function getAllBrickIndices() {
    return this.simpleBrickIndices
      .concat(this.customBrickIndices)
      .sort(function(e, t) {
        return e - t;
      });
  }),
  (entities.Squad.prototype._isSlotBrick = function _isSlotBrick(e) {
    return -1 !== this.getAllBrickIndices().indexOf(e);
  }),
  (entities.Squad.prototype._isSlotSimpleBrick = function _isSlotSimpleBrick(
    e
  ) {
    return -1 !== this.simpleBrickIndices.indexOf(e);
  }),
  (entities.Squad.prototype._isSlotCustomBrick = function _isSlotCustomBrick(
    e
  ) {
    return -1 !== this.customBrickIndices.indexOf(e);
  }),
  (entities.Squad.prototype.isSBCSquadEligible = function isSBCSquadEligible() {
    var e = utils.JS.find(this.getNonBrickSlots(), function(e) {
      var t = e.getItem();
      return (
        t.isLoaned() ||
        t.concept ||
        entities.Item.isAlex(t.resourceId) ||
        entities.Item.isJim(t.resourceId) ||
        entities.Item.isDanny(t.resourceId)
      );
    });
    return !utils.JS.isValid(e);
  }),
  (entities.Squad.prototype.getSBCSlots = function getSBCSlots(e) {
    return e ? this._players : this._filterSimpleBrickIndices(this._players);
  }),
  (entities.Squad.prototype.getNonBrickSlots = function getNonBrickSlots(e) {
    var t = e ? this._players : this.getFieldPlayers();
    return 0 === this.getAllBrickIndices().length
      ? t
      : this._filterBrickIndices(t);
  }),
  (entities.Squad.prototype.getNumOfRequiredPlayers = function getNumOfRequiredPlayers() {
    return entities.Squad.FIELD_PLAYERS - this.getAllBrickIndices().length;
  }),
  (entities.Squad.prototype.setTacticMentality = function setTacticMentality(
    e
  ) {
    var t = e.getSquadId() === this.getId();
    utils.Debug.Assert(
      t,
      'Attempted to assign an invalid tactic mentality to the squad.'
    ),
      t &&
        (this._mentalities.has(e.getId()) &&
          this._mentalities.get(e.getId()).onDataUpdated.unobserve(this),
        this._mentalities.set(e.getId(), e),
        e.onDataUpdated.observe(this, this._eMentalityDataUpdated));
  }),
  (entities.Squad.prototype.getTacticMentalities = function getTacticMentalities() {
    return this._mentalities.values();
  }),
  (entities.Squad.prototype.getTacticMentalityById = function getTacticMentalityById(
    e
  ) {
    return this._mentalities.get(e);
  }),
  (entities.Squad.prototype.getTacticSlotsByMentalityId = function getTacticSlotsByMentalityId(
    e
  ) {
    var t = this._mentalities.get(e);
    if (
      (utils.Debug.Assert(
        utils.JS.isValid(t),
        'Could not find a mentality for ID: ' + e
      ),
      t)
    ) {
      var s = t.getFormation();
      return t.getPositions().map(function(e, t) {
        var i = new UTSquadSlotEntity(t, s.getPosition(t));
        return i.setItem(this._players[e].getItem()), i;
      }, this);
    }
    return [];
  }),
  (entities.Squad.prototype.saveTactics = function saveTactics() {
    if (!(this.isSBC() || this.isTOTW() || this.isShowOff())) {
      var i = this.getTacticMentalities(),
        e = this._squadDAO.saveTacticMentalities(this.getId(), i);
      return (
        e.observe(this, function _onSaveTacticMentalitiesComplete(e, t) {
          e.unobserve(this),
            t.success &&
              i.forEach(function(e) {
                e.isModified() && ((e._modified = !1), (e._customized = !0));
              });
        }),
        e
      );
    }
  }),
  (entities.Squad.prototype.hasModifiedTactics = function hasModifiedTactics() {
    return (
      0 <
      this.getTacticMentalities().filter(function(e) {
        return e.isModified();
      }).length
    );
  }),
  (entities.Squad.prototype._eMentalityDataUpdated = function _eMentalityDataUpdated(
    e,
    t,
    i
  ) {
    var s = {
      tactics: {
        mentality: t
      }
    };
    i.offensiveStyle && (s.tactics.offensiveStyle = i.offensiveStyle),
      i.offensiveWidth && (s.tactics.offensiveWidth = i.offensiveWidth),
      i.offensivePlayersInBox &&
        (s.tactics.offensivePlayersInBox = i.offensivePlayersInBox),
      i.cornerPlayersInBox &&
        (s.tactics.cornerPlayersInBox = i.cornerPlayersInBox),
      i.freeKickPlayersInBox &&
        (s.tactics.freeKickPlayersInBox = i.freeKickPlayersInBox),
      i.defensiveStyle && (s.tactics.defensiveStyle = i.defensiveStyle),
      i.defensiveWidth && (s.tactics.defensiveWidth = i.defensiveWidth),
      i.defensiveDepth && (s.tactics.defensiveDepth = i.defensiveDepth),
      i.instructions && (s.tactics.instructions = i.instructions),
      i.formation && (s.tactics.formation = i.formation),
      t.getId() === UTSquadMentalityEntity.TYPE.BALANCED &&
        this._formation.getId() !== t.getFormation().getId() &&
        ((this._modified = !0),
        (this._formation = t.getFormation()),
        this._mentalities.forEach(function(e) {
          e.isCustomized() ||
            e.isModified() ||
            e.getId() === UTSquadMentalityEntity.TYPE.BALANCED ||
            (e._formation = t.getFormation());
        }),
        this._players.forEach(function(e) {
          e.setPosition(this._formation.getPosition(e.getIndex()));
        }, this),
        this.updateChemistry(),
        (s.formation = this._formation)),
      this.onDataUpdated.notify(s);
  }),
  (entities.Squad.prototype._eSlotDataUpdated = function _eSlotDataUpdated(
    e,
    t,
    i
  ) {
    var s = t.getIndex();
    (s < entities.Squad.FIELD_PLAYERS ||
      s === entities.Squad.MANAGER_SLOT_INDEX) &&
      this.updateChemistry(),
      s < entities.Squad.FIELD_PLAYERS + entities.Squad.SUB_PLAYERS &&
        this._calculateRating(),
      this._updateType(),
      (this._modified = !0),
      this.onDataUpdated.notify({
        slots: [t],
        chemistry: this.getChemistry(),
        rating: this.getRating(),
        type: this.getType()
      });
  }),
  utils.JS.inherits(UTPlayerInstructionsVO, UTObject),
  (UTPlayerInstructionsVO.INSTRUCTION = {
    NO_INSTRUCTION: 0,
    JOIN_THE_ATTACK: 1,
    PLAY_AS_STRIKER: 2,
    OVERLAP_RUN: 3,
    MIXED_ATTACK: 4,
    STAY_BACK_WHILE_ATTACKING: 5,
    CUT_PASSING_LANES: 6,
    VARIED_DEFENSE: 7,
    MAN_MARK: 8,
    VARIED_ATTACK: 9,
    GET_FORWARD: 10,
    GET_INTO_THE_BOX_FOR_CROSS: 11,
    MIXED_ATTACK_FOR_CROSS: 12,
    STAY_ON_EDGE_OF_BOX_FOR_CROSS: 13,
    FREE_ROAM: 14,
    COME_BACK_ON_DEFENSE: 15,
    MIXED_DEFENSE: 16,
    STAY_FORWARD: 17,
    CUT_INSIDE: 18,
    VARIED_WIDTH: 19,
    STAY_WIDE: 20,
    GET_IN_BEHIND: 21,
    MIXED_SUPPORT: 22,
    COME_SHORT: 23,
    PRESS_BACK_LINE: 24,
    DRIFT_WIDE: 25,
    STAY_CENTRAL: 26,
    TARGET_MAN: 27,
    STICK_TO_POSITION: 28,
    FALSE_9: 29,
    GK_RUSH_CONSERVATIVE: 30,
    GK_RUSH_NORMAL: 31,
    GK_RUSH_SWEEPER: 32,
    INTERCEPTION_LOW: 33,
    INTERCEPTION_NORMAL: 34,
    INTERCEPTION_AGGRESSIVE: 35,
    INVERTED_RUN: 36,
    COVER_WING: 37,
    ALWAYS_COVER_CENTER: 38,
    GK_SAVE_ON_CROSSES_NORMAL: 39,
    GK_SAVE_ON_CROSSES_COMES_FOR_CROSSES: 40,
    GK_SAVE_ON_CROSSES_CAUTIOUS_WITH_CROSSES: 41,
    GK_OUTSIDE_BOX_NORMAL: 42,
    GK_OUTSIDE_BOX_SWEEPER: 43,
    DROP_BACK_BETWEEN_DEFENDERS: 44
  }),
  (UTPlayerInstructionsVO.prototype.getPositionId = function getPositionId() {
    return this._positionId;
  }),
  (UTPlayerInstructionsVO.prototype.getInstructions = function getInstructions() {
    return this._instructions;
  }),
  (UTPlayerInstructionsVO.prototype.setInstructions = function setInstructions(
    e
  ) {
    var t = Array.isArray(e) && !e.some(isNaN);
    utils.Debug.Assert(
      t,
      'Unable to assign instructions. Expected a numeric array.'
    ),
      t && (this._instructions = e.slice());
  }),
  (UTPlayerInstructionsVO.prototype.setInstructionsFromBitwiseIntegers = function setInstructionsFromBitwiseIntegers(
    e
  ) {
    var t = utils.JS.isNumber(e[0]),
      i = utils.JS.isNumber(e[1]);
    if (
      ((this._instructions = []),
      utils.Debug.Assert(
        t,
        'Expected a 32-bit integer when assigning instructions to UTPlayerInstructionsVO.'
      ),
      utils.Debug.Assert(
        i,
        'Expected a 32-bit integer when assigning instructions to UTPlayerInstructionsVO.'
      ),
      t && i && (0 !== e[0] || 0 !== e[1]))
    )
      for (var s in UTPlayerInstructionsVO.INSTRUCTION)
        if (UTPlayerInstructionsVO.INSTRUCTION.hasOwnProperty(s)) {
          var n = UTPlayerInstructionsVO.INSTRUCTION[s];
          if (n <= 0) continue;
          var o = Math.floor((n - 1) / 30),
            a = n - 30 * o;
          e[o] & (1 << (a - 1)) && this._instructions.push(n);
        }
  }),
  (UTPlayerInstructionsVO.prototype.toBitwiseIntegers = function toBitwiseIntegers() {
    var s = [0, 0];
    return (
      this._instructions.forEach(function(e) {
        if (
          (utils.Debug.Assert(
            0 < e,
            'Encountered an invalid instruction for position ID: ' +
              this._positionId
          ),
          !(e <= 0))
        ) {
          var t = Math.floor((e - 1) / 30),
            i = e - 30 * t;
          s[t] |= 1 << (i - 1);
        }
      }),
      s
    );
  }),
  (UTPlayerInstructionsVO.prototype.equals = function equals(e) {
    if (!(e instanceof UTPlayerInstructionsVO)) return !1;
    var t = this.getInstructions(),
      i = e.getInstructions();
    if (t.length !== i.length) return !1;
    for (var s = 0, n = t.length; s < n; s++) if (t[s] !== i[s]) return !1;
    return this.getPositionId() === e.getPositionId();
  }),
  utils.JS.inherits(UTPlayerInstructionGroupEntity, UTObject),
  (UTPlayerInstructionGroupEntity.prototype.getId = function getId() {
    return this._id;
  }),
  (UTPlayerInstructionGroupEntity.prototype.addInstruction = function addInstruction(
    e
  ) {
    var t = utils.JS.isNumber(e),
      i = this._instructions.indexOf(e) < 0;
    utils.Debug.Assert(t, 'Expected a numeric instruction ID.'),
      utils.Debug.Assert(
        i,
        'Instruction is already assigned to the group. Ignoring request.'
      ),
      t && i && this._instructions.push(e);
  }),
  (UTPlayerInstructionGroupEntity.prototype.setSelectedInstruction = function setSelectedInstruction(
    t,
    e
  ) {
    utils.Debug.Assert(
      Array.isArray(t) && !t.some(isNaN),
      'Expected an array of numbers to search against.'
    ),
      utils.Debug.Assert(
        utils.JS.isNumber(e),
        'Expected a numeric instruction ID.'
      );
    var i = utils.JS.find(this._instructions, function(e) {
      return 0 <= t.indexOf(e);
    });
    utils.JS.isNumber(i)
      ? (this._selectedInstruction = i)
      : 0 <= this._instructions.indexOf(e) && (this._selectedInstruction = e);
  }),
  (UTPlayerInstructionGroupEntity.prototype.getInstructions = function getInstructions() {
    return this._instructions;
  }),
  (UTPlayerInstructionGroupEntity.prototype.getSelectedInstruction = function getSelectedInstruction() {
    return this._selectedInstruction;
  }),
  utils.JS.inherits(UTSquadMentalityEntity, UTObject),
  (UTSquadMentalityEntity.TYPE = {
    ULTRA_DEFENSIVE: 0,
    DEFENSIVE: 1,
    BALANCED: 2,
    ATTACKING: 3,
    ULTRA_ATTACKING: 4
  }),
  (UTSquadMentalityEntity.STYLE = {
    OFFENSIVE_STYLE: 0,
    OFFENSIVE_WIDTH: 1,
    OFFENSIVE_PLAYERS_IN_BOX: 2,
    DEFENSIVE_STYLE: 3,
    DEFENSIVE_WIDTH: 4,
    DEFENSIVE_DEPTH: 5,
    CORNER_PLAYERS_IN_BOX: 6,
    FREE_KICK_PLAYERS_IN_BOX: 7
  }),
  (UTSquadMentalityEntity.OFFENSIVE_STYLE = {
    POSSESSION: 0,
    BALANCED: 1,
    LONG_BALL: 2,
    FAST_BUILD_UP: 3
  }),
  (UTSquadMentalityEntity.DEFENSIVE_STYLE = {
    DROP_BACK: 0,
    BALANCED: 1,
    PRESSURE_ON_HEAVY_TOUCH: 2,
    PRESS_AFTER_POSSESSION_LOSS: 3,
    CONSTANT_PRESSURE: 4
  }),
  (UTSquadMentalityEntity.MIN_OFFENSIVE_WIDTH = 1),
  (UTSquadMentalityEntity.MAX_OFFENSIVE_WIDTH = 10),
  (UTSquadMentalityEntity.MIN_OFFENSIVE_PLAYERS_IN_BOX = 1),
  (UTSquadMentalityEntity.MAX_OFFENSIVE_PLAYERS_IN_BOX = 10),
  (UTSquadMentalityEntity.MIN_CORNER_PLAYERS_IN_BOX = 1),
  (UTSquadMentalityEntity.MAX_CORNER_PLAYERS_IN_BOX = 5),
  (UTSquadMentalityEntity.MIN_FREEKICK_PLAYERS_IN_BOX = 1),
  (UTSquadMentalityEntity.MAX_FREEKICK_PLAYERS_IN_BOX = 5),
  (UTSquadMentalityEntity.MIN_DEFENSIVE_WIDTH = 1),
  (UTSquadMentalityEntity.MAX_DEFENSIVE_WIDTH = 10),
  (UTSquadMentalityEntity.MIN_DEFENSIVE_DEPTH = 1),
  (UTSquadMentalityEntity.MAX_DEFENSIVE_DEPTH = 10),
  (UTSquadMentalityEntity.prototype.getId = function getId() {
    return this._id;
  }),
  (UTSquadMentalityEntity.prototype.getSquadId = function getSquadId() {
    return this._squadId;
  }),
  (UTSquadMentalityEntity.prototype.getFormation = function getFormation() {
    return this._formation;
  }),
  (UTSquadMentalityEntity.prototype.setFormation = function setFormation(e) {
    (this._formation && this._formation.getId() === e.getId()) ||
      ((this._formation = e),
      this._resetInstructions(),
      this._resetPositions(),
      (this._modified = !0),
      this.onDataUpdated.notify(this, {
        formation: this._formation,
        instructions: this._instructions.values(),
        positions: this._positions
      }));
  }),
  (UTSquadMentalityEntity.prototype.getPositions = function getPositions() {
    return this._positions.slice();
  }),
  (UTSquadMentalityEntity.prototype.swapPositionsByIndex = function swapPositionsByIndex(
    e,
    t
  ) {
    var i = utils.JS.isNumber(e) && 0 <= e && e <= 10,
      s = utils.JS.isNumber(t) && 0 <= t && t <= 10;
    if (
      (utils.Debug.Assert(
        i && s,
        'Expected a numeric index representing a slot position.'
      ),
      i && s)
    ) {
      var n = this._positions[e],
        o = this._positions[t];
      (this._positions[e] = o),
        (this._positions[t] = n),
        (this._modified = !0),
        this.onDataUpdated.notify(this, {
          positions: this._positions
        });
    }
  }),
  (UTSquadMentalityEntity.prototype._resetPositions = function _resetPositions() {
    this._positions = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
  }),
  (UTSquadMentalityEntity.prototype.setOffensiveStyle = function setOffensiveStyle(
    e
  ) {
    utils.JS.isNumber(e) &&
      e !== this._offensiveStyle &&
      e >= UTSquadMentalityEntity.OFFENSIVE_STYLE.POSSESSION &&
      e <= UTSquadMentalityEntity.OFFENSIVE_STYLE.FAST_BUILD_UP &&
      ((this._offensiveStyle = e),
      (this._modified = !0),
      this.onDataUpdated.notify(this, {
        offensiveStyle: this._offensiveStyle
      }));
  }),
  (UTSquadMentalityEntity.prototype.getOffensiveStyle = function getOffensiveStyle() {
    return this._offensiveStyle;
  }),
  (UTSquadMentalityEntity.prototype.setOffensiveWidth = function setOffensiveWidth(
    e
  ) {
    if (utils.JS.isNumber(e)) {
      var t = Math.min(Math.max(Math.round(e), 1), 10);
      this._offensiveWidth !== t &&
        ((this._offensiveWidth = t),
        (this._modified = !0),
        this.onDataUpdated.notify(this, {
          offensiveWidth: this._offensiveWidth
        }));
    }
  }),
  (UTSquadMentalityEntity.prototype.getOffensiveWidth = function getOffensiveWidth() {
    return this._offensiveWidth;
  }),
  (UTSquadMentalityEntity.prototype.setOffensivePlayersInBox = function setOffensivePlayersInBox(
    e
  ) {
    if (utils.JS.isNumber(e)) {
      var t = Math.min(Math.max(Math.round(e), 1), 10);
      this._offensivePlayersInBox !== t &&
        ((this._offensivePlayersInBox = t),
        (this._modified = !0),
        this.onDataUpdated.notify(this, {
          offensivePlayersInBox: this._offensivePlayersInBox
        }));
    }
  }),
  (UTSquadMentalityEntity.prototype.getOffensivePlayersInBox = function getOffensivePlayersInBox() {
    return this._offensivePlayersInBox;
  }),
  (UTSquadMentalityEntity.prototype.setCornerPlayersInBox = function setCornerPlayersInBox(
    e
  ) {
    if (utils.JS.isNumber(e)) {
      var t = Math.min(Math.max(Math.round(e), 1), 5);
      this._cornerPlayersInBox !== t &&
        ((this._cornerPlayersInBox = t),
        (this._modified = !0),
        this.onDataUpdated.notify(this, {
          cornerPlayersInBox: this._cornerPlayersInBox
        }));
    }
  }),
  (UTSquadMentalityEntity.prototype.getCornerPlayersInBox = function getCornerPlayersInBox() {
    return this._cornerPlayersInBox;
  }),
  (UTSquadMentalityEntity.prototype.setFreeKickPlayersInBox = function setFreeKickPlayersInBox(
    e
  ) {
    if (utils.JS.isNumber(e)) {
      var t = Math.min(Math.max(Math.round(e), 1), 5);
      this._freeKickPlayersInBox !== t &&
        ((this._freeKickPlayersInBox = t),
        (this._modified = !0),
        this.onDataUpdated.notify(this, {
          freeKickPlayersInBox: this._freeKickPlayersInBox
        }));
    }
  }),
  (UTSquadMentalityEntity.prototype.getFreeKickPlayersInBox = function getFreeKickPlayersInBox() {
    return this._freeKickPlayersInBox;
  }),
  (UTSquadMentalityEntity.prototype.setDefensiveStyle = function setDefensiveStyle(
    e
  ) {
    utils.JS.isNumber(e) &&
      e !== this._defensiveStyle &&
      e >= UTSquadMentalityEntity.DEFENSIVE_STYLE.DROP_BACK &&
      e <= UTSquadMentalityEntity.DEFENSIVE_STYLE.CONSTANT_PRESSURE &&
      ((this._defensiveStyle = e),
      (this._modified = !0),
      this.onDataUpdated.notify(this, {
        defensiveStyle: this._defensiveStyle
      }));
  }),
  (UTSquadMentalityEntity.prototype.getDefensiveStyle = function getDefensiveStyle() {
    return this._defensiveStyle;
  }),
  (UTSquadMentalityEntity.prototype.setDefensiveWidth = function setDefensiveWidth(
    e
  ) {
    if (utils.JS.isNumber(e)) {
      var t = Math.min(Math.max(Math.round(e), 1), 10);
      this._defensiveWidth !== t &&
        ((this._defensiveWidth = t),
        (this._modified = !0),
        this.onDataUpdated.notify(this, {
          defensiveWidth: this._defensiveWidth
        }));
    }
  }),
  (UTSquadMentalityEntity.prototype.getDefensiveWidth = function getDefensiveWidth() {
    return this._defensiveWidth;
  }),
  (UTSquadMentalityEntity.prototype.setDefensiveDepth = function setDefensiveDepth(
    e
  ) {
    if (utils.JS.isNumber(e)) {
      var t = Math.min(Math.max(Math.round(e), 1), 10);
      this._defensiveDepth !== t &&
        ((this._defensiveDepth = t),
        (this._modified = !0),
        this.onDataUpdated.notify(this, {
          defensiveDepth: this._defensiveDepth
        }));
    }
  }),
  (UTSquadMentalityEntity.prototype.getDefensiveDepth = function getDefensiveDepth() {
    return this._defensiveDepth;
  }),
  (UTSquadMentalityEntity.prototype.setInstructionsByPositionId = function setInstructionsByPositionId(
    e,
    t
  ) {
    var i = this._instructions.get(e),
      s = !1;
    i ||
      ((i = new UTPlayerInstructionsVO(e)),
      this._instructions.set(e, i),
      (s = !0));
    var n = i.getInstructions();
    if ((s || (s = n.length !== t.length), !s))
      for (var o = 0, a = n.length; o < a; o++)
        if (n[o] !== t[o]) {
          s = !0;
          break;
        }
    s &&
      (i.setInstructions(t),
      (this._modified = !0),
      this.onDataUpdated.notify(this, {
        instructions: [i]
      }));
  }),
  (UTSquadMentalityEntity.prototype.getInstructionsByPositionId = function getInstructionsByPositionId(
    e
  ) {
    var t = this._instructions.get(e);
    return (
      utils.Debug.Assert(
        utils.JS.isValid(t),
        'Cannot find player instructions for position ID: ' + e
      ),
      t ? t.getInstructions() : []
    );
  }),
  (UTSquadMentalityEntity.prototype.getInstructionGroupsByPositionId = function getInstructionGroupsByPositionId(
    e
  ) {
    var t,
      i = this.getInstructionsByPositionId(e),
      s = [
        enums.PlayerPositionsAsInts.SW,
        enums.PlayerPositionsAsInts.RWB,
        enums.PlayerPositionsAsInts.RB,
        enums.PlayerPositionsAsInts.RCB,
        enums.PlayerPositionsAsInts.CB,
        enums.PlayerPositionsAsInts.LCB,
        enums.PlayerPositionsAsInts.LB,
        enums.PlayerPositionsAsInts.LWB
      ],
      n =
        4 ===
        this._formation.getPositions().reduce(function(e, t) {
          return 0 <= s.indexOf(t.getId()) ? ++e : e;
        }, 0),
      o = [];
    switch (e) {
      case enums.PlayerPositionsAsInts.GK:
        (t = new UTPlayerInstructionGroupEntity(28)).addInstruction(
          UTPlayerInstructionsVO.INSTRUCTION
            .GK_SAVE_ON_CROSSES_COMES_FOR_CROSSES
        ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.GK_SAVE_ON_CROSSES_NORMAL
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION
              .GK_SAVE_ON_CROSSES_CAUTIOUS_WITH_CROSSES
          ),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.GK_SAVE_ON_CROSSES_NORMAL
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(29)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.GK_OUTSIDE_BOX_SWEEPER
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.GK_OUTSIDE_BOX_NORMAL
          ),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.GK_OUTSIDE_BOX_NORMAL
          ),
          o.push(t);
        break;
      case enums.PlayerPositionsAsInts.SW:
      case enums.PlayerPositionsAsInts.RCB:
      case enums.PlayerPositionsAsInts.CB:
      case enums.PlayerPositionsAsInts.LCB:
        (t = new UTPlayerInstructionGroupEntity(0)).addInstruction(
          UTPlayerInstructionsVO.INSTRUCTION.JOIN_THE_ATTACK
        ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.STAY_BACK_WHILE_ATTACKING
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.PLAY_AS_STRIKER),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.STAY_BACK_WHILE_ATTACKING
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(18)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_AGGRESSIVE
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_LOW),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          o.push(t);
        break;
      case enums.PlayerPositionsAsInts.RWB:
      case enums.PlayerPositionsAsInts.RB:
      case enums.PlayerPositionsAsInts.LB:
      case enums.PlayerPositionsAsInts.LWB:
        (t = new UTPlayerInstructionGroupEntity(1)).addInstruction(
          UTPlayerInstructionsVO.INSTRUCTION.JOIN_THE_ATTACK
        ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.VARIED_ATTACK),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.STAY_BACK_WHILE_ATTACKING
          ),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.VARIED_ATTACK
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(19)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_AGGRESSIVE
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_LOW),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(25)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INVERTED_RUN
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.MIXED_ATTACK),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.OVERLAP_RUN),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_ATTACK
          ),
          o.push(t);
        break;
      case enums.PlayerPositionsAsInts.RDM:
      case enums.PlayerPositionsAsInts.CDM:
      case enums.PlayerPositionsAsInts.LDM:
        (t = new UTPlayerInstructionGroupEntity(2)).addInstruction(
          UTPlayerInstructionsVO.INSTRUCTION.CUT_PASSING_LANES
        ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.VARIED_DEFENSE),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.MAN_MARK),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.VARIED_DEFENSE
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(3)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.STAY_BACK_WHILE_ATTACKING
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.VARIED_ATTACK),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.GET_FORWARD),
          n &&
            t.addInstruction(
              UTPlayerInstructionsVO.INSTRUCTION.DROP_BACK_BETWEEN_DEFENDERS
            ),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.VARIED_ATTACK
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(20)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_AGGRESSIVE
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_LOW),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(26)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.ALWAYS_COVER_CENTER
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.COVER_WING),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.COVER_WING
          ),
          o.push(t);
        break;
      case enums.PlayerPositionsAsInts.RCM:
      case enums.PlayerPositionsAsInts.CM:
      case enums.PlayerPositionsAsInts.LCM:
        (t = new UTPlayerInstructionGroupEntity(4)).addInstruction(
          UTPlayerInstructionsVO.INSTRUCTION.STAY_BACK_WHILE_ATTACKING
        ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.VARIED_ATTACK),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.GET_FORWARD),
          n &&
            t.addInstruction(
              UTPlayerInstructionsVO.INSTRUCTION.DROP_BACK_BETWEEN_DEFENDERS
            ),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.VARIED_ATTACK
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(5)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.GET_INTO_THE_BOX_FOR_CROSS
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_ATTACK_FOR_CROSS
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.STAY_ON_EDGE_OF_BOX_FOR_CROSS
          ),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_ATTACK_FOR_CROSS
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(21)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_AGGRESSIVE
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_LOW),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(6)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.FREE_ROAM
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.STICK_TO_POSITION
          ),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.STICK_TO_POSITION
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(27)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.ALWAYS_COVER_CENTER
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.COVER_WING),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.COVER_WING
          ),
          o.push(t);
        break;
      case enums.PlayerPositionsAsInts.RAM:
      case enums.PlayerPositionsAsInts.CAM:
      case enums.PlayerPositionsAsInts.LAM:
        (t = new UTPlayerInstructionGroupEntity(7)).addInstruction(
          UTPlayerInstructionsVO.INSTRUCTION.COME_BACK_ON_DEFENSE
        ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.MIXED_DEFENSE),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.STAY_FORWARD),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_DEFENSE
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(8)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.GET_INTO_THE_BOX_FOR_CROSS
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_ATTACK_FOR_CROSS
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.STAY_ON_EDGE_OF_BOX_FOR_CROSS
          ),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_ATTACK_FOR_CROSS
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(9)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.FREE_ROAM
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.STICK_TO_POSITION
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.DRIFT_WIDE),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.STICK_TO_POSITION
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(22)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_AGGRESSIVE
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_LOW),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          o.push(t);
        break;
      case enums.PlayerPositionsAsInts.RM:
      case enums.PlayerPositionsAsInts.LM:
      case enums.PlayerPositionsAsInts.RW:
      case enums.PlayerPositionsAsInts.LW:
        var a = utils.JS.isValid(
            this._formation.getPosition(enums.PlayerPositionsAsInts.RW)
          ),
          r = utils.JS.isValid(
            this._formation.getPosition(enums.PlayerPositionsAsInts.LW)
          ),
          l =
            e === enums.PlayerPositionsAsInts.RW ||
            e === enums.PlayerPositionsAsInts.LW ||
            (e === enums.PlayerPositionsAsInts.RM && !a) ||
            (e === enums.PlayerPositionsAsInts.LM && !r);
        l &&
          ((t = new UTPlayerInstructionGroupEntity(10)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.COME_BACK_ON_DEFENSE
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.MIXED_DEFENSE),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.STAY_FORWARD),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_DEFENSE
          ),
          o.push(t)),
          (t = new UTPlayerInstructionGroupEntity(11)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.CUT_INSIDE
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.VARIED_WIDTH),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.STAY_WIDE),
          l && t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.FREE_ROAM),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.VARIED_WIDTH
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(12)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.GET_IN_BEHIND
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.MIXED_SUPPORT),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.COME_SHORT),
          l && t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.TARGET_MAN),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_SUPPORT
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(13)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.GET_INTO_THE_BOX_FOR_CROSS
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_ATTACK_FOR_CROSS
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.STAY_ON_EDGE_OF_BOX_FOR_CROSS
          ),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_ATTACK_FOR_CROSS
          ),
          o.push(t),
          ((e === enums.PlayerPositionsAsInts.RM && a) ||
            (e === enums.PlayerPositionsAsInts.LM && r)) &&
            ((t = new UTPlayerInstructionGroupEntity(14)).addInstruction(
              UTPlayerInstructionsVO.INSTRUCTION.FREE_ROAM
            ),
            t.addInstruction(
              UTPlayerInstructionsVO.INSTRUCTION.STICK_TO_POSITION
            ),
            t.setSelectedInstruction(
              i,
              UTPlayerInstructionsVO.INSTRUCTION.STICK_TO_POSITION
            ),
            o.push(t)),
          (t = new UTPlayerInstructionGroupEntity(23)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_AGGRESSIVE
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_LOW),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          o.push(t);
        break;
      case enums.PlayerPositionsAsInts.RF:
      case enums.PlayerPositionsAsInts.CF:
      case enums.PlayerPositionsAsInts.LF:
      case enums.PlayerPositionsAsInts.RS:
      case enums.PlayerPositionsAsInts.ST:
      case enums.PlayerPositionsAsInts.LS:
        (t = new UTPlayerInstructionGroupEntity(16)).addInstruction(
          UTPlayerInstructionsVO.INSTRUCTION.DRIFT_WIDE
        ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.VARIED_WIDTH),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.STAY_CENTRAL),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.VARIED_WIDTH
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(17)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.GET_IN_BEHIND
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.MIXED_ATTACK),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.TARGET_MAN),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.FALSE_9),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_ATTACK
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(24)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_AGGRESSIVE
          ),
          t.addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_LOW),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.INTERCEPTION_NORMAL
          ),
          o.push(t),
          (t = new UTPlayerInstructionGroupEntity(15)).addInstruction(
            UTPlayerInstructionsVO.INSTRUCTION.COME_BACK_ON_DEFENSE
          ),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.MIXED_DEFENSE),
          t.addInstruction(UTPlayerInstructionsVO.INSTRUCTION.STAY_FORWARD),
          t.setSelectedInstruction(
            i,
            UTPlayerInstructionsVO.INSTRUCTION.MIXED_DEFENSE
          ),
          o.push(t);
    }
    return o;
  }),
  (UTSquadMentalityEntity.prototype.isModified = function isModified() {
    return this._modified;
  }),
  (UTSquadMentalityEntity.prototype.isCustomized = function isCustomized() {
    return this._customized;
  }),
  (UTSquadMentalityEntity.prototype.toUtasObject = function toUtasObject() {
    var e;
    switch (this.getId()) {
      case UTSquadMentalityEntity.TYPE.ATTACKING:
        e = 'ATTACKING';
        break;
      case UTSquadMentalityEntity.TYPE.BALANCED:
        e = 'BALANCED';
        break;
      case UTSquadMentalityEntity.TYPE.DEFENSIVE:
        e = 'DEFENSIVE';
        break;
      case UTSquadMentalityEntity.TYPE.ULTRA_ATTACKING:
        e = 'ULTRA_ATTACKING';
        break;
      case UTSquadMentalityEntity.TYPE.ULTRA_DEFENSIVE:
        e = 'ULTRA_DEFENSIVE';
        break;
      default:
        e = 'INVALID';
    }
    utils.Debug.Assert(
      'INVALID' !== e,
      'Invalid mentality ID. Expected an ID of type UTSquadMentalityEntity.TYPE'
    );
    var n = [],
      t = this._formation.getPositions(),
      o = t.length;
    return (
      t.forEach(function(e, t) {
        var i = this._instructions.get(e.getId());
        if (
          (utils.Debug.Assert(
            utils.JS.isValid(i),
            'Unable to find player instructions for formation position: ' + t
          ),
          i)
        ) {
          var s = i.toBitwiseIntegers();
          n.push({
            index: t,
            value: s[0]
          }),
            n.push({
              index: t + o,
              value: s[1]
            });
        }
      }, this),
      {
        squadId: this.getSquadId(),
        tactic: e,
        formation: this.getFormation().getName(),
        positions: this._positions.map(function(e, t) {
          return {
            index: t,
            value: e
          };
        }),
        instructions: n,
        styles: [
          {
            index: UTSquadMentalityEntity.STYLE.OFFENSIVE_STYLE,
            value: this._offensiveStyle
          },
          {
            index: UTSquadMentalityEntity.STYLE.OFFENSIVE_WIDTH,
            value: this._offensiveWidth
          },
          {
            index: UTSquadMentalityEntity.STYLE.OFFENSIVE_PLAYERS_IN_BOX,
            value: this._offensivePlayersInBox
          },
          {
            index: UTSquadMentalityEntity.STYLE.DEFENSIVE_STYLE,
            value: this._defensiveStyle
          },
          {
            index: UTSquadMentalityEntity.STYLE.DEFENSIVE_WIDTH,
            value: this._defensiveWidth
          },
          {
            index: UTSquadMentalityEntity.STYLE.DEFENSIVE_DEPTH,
            value: this._defensiveDepth
          },
          {
            index: UTSquadMentalityEntity.STYLE.CORNER_PLAYERS_IN_BOX,
            value: this._cornerPlayersInBox
          },
          {
            index: UTSquadMentalityEntity.STYLE.FREE_KICK_PLAYERS_IN_BOX,
            value: this._freeKickPlayersInBox
          }
        ]
      }
    );
  }),
  (UTSquadMentalityEntity.prototype.save = function save() {
    var e = this._squadDAO.saveTacticMentalities(this.getSquadId(), [this]);
    return (
      e.observe(this, function _onSaveTacticMentalityComplete(e, t) {
        e.unobserve(this),
          t.success && ((this._modified = !1), (this._customized = !0));
      }),
      e
    );
  }),
  (UTSquadMentalityEntity.prototype._resetInstructions = function _resetInstructions() {
    this._instructions.clear(),
      this._formation.getPositions().forEach(function(e) {
        var t = e.getId(),
          i = new UTPlayerInstructionsVO(t);
        this._instructions.set(t, i);
      }, this);
  }),
  (UTSquadMentalityEntity.prototype.resetInstructions = function resetInstructions() {
    this._resetInstructions(),
      (this._modified = !0),
      this.onDataUpdated.notify(this, {
        instructions: this._instructions.values()
      });
  }),
  utils.JS.inherits(UTSquadMentalityEntityFactory, UTObject),
  (UTSquadMentalityEntityFactory.prototype.createDefaultMentality = function createDefaultMentality(
    e,
    t
  ) {
    var s = new UTSquadMentalityEntity(e, this._squadDAO);
    switch (((s._squadId = t.getId()), (s._formation = t.getFormation()), e)) {
      case UTSquadMentalityEntity.TYPE.ULTRA_DEFENSIVE:
        (s._offensiveStyle = UTSquadMentalityEntity.OFFENSIVE_STYLE.LONG_BALL),
          (s._defensiveStyle =
            UTSquadMentalityEntity.DEFENSIVE_STYLE.DROP_BACK),
          (s._offensivePlayersInBox -= 2),
          (s._defensiveDepth -= 2),
          (s._cornerPlayersInBox -= 2),
          (s._freeKickPlayersInBox -= 2);
        break;
      case UTSquadMentalityEntity.TYPE.DEFENSIVE:
        (s._offensiveStyle = UTSquadMentalityEntity.OFFENSIVE_STYLE.POSSESSION),
          (s._defensiveStyle =
            UTSquadMentalityEntity.DEFENSIVE_STYLE.DROP_BACK),
          (s._offensivePlayersInBox -= 1),
          (s._defensiveDepth -= 1),
          (s._cornerPlayersInBox -= 1),
          (s._freeKickPlayersInBox -= 1);
        break;
      case UTSquadMentalityEntity.TYPE.ATTACKING:
        (s._offensiveStyle =
          UTSquadMentalityEntity.OFFENSIVE_STYLE.FAST_BUILD_UP),
          (s._defensiveStyle =
            UTSquadMentalityEntity.DEFENSIVE_STYLE.PRESS_AFTER_POSSESSION_LOSS),
          (s._offensivePlayersInBox += 1),
          (s._defensiveDepth += 1),
          (s._cornerPlayersInBox += 1),
          (s._freeKickPlayersInBox += 1);
        break;
      case UTSquadMentalityEntity.TYPE.ULTRA_ATTACKING:
        (s._offensiveStyle =
          UTSquadMentalityEntity.OFFENSIVE_STYLE.FAST_BUILD_UP),
          (s._defensiveStyle =
            UTSquadMentalityEntity.DEFENSIVE_STYLE.CONSTANT_PRESSURE),
          (s._offensivePlayersInBox += 2),
          (s._defensiveDepth += 2),
          (s._cornerPlayersInBox += 2),
          (s._freeKickPlayersInBox += 2);
    }
    return (
      s._formation.getPositions().forEach(function(e) {
        var t = e.getId(),
          i = new UTPlayerInstructionsVO(t);
        s._instructions.set(t, i);
      }),
      s
    );
  }),
  (UTSquadMentalityEntityFactory.prototype.createMentality = function createMentality(
    e,
    t
  ) {
    var n = new UTSquadMentalityEntity(
      UTSquadMentalityEntity.TYPE[e.tactic] ||
        UTSquadMentalityEntity.TYPE.BALANCED,
      this._squadDAO
    );
    utils.Debug.Assert(
      e.squadId === t.getId(),
      'Associating squad/mentality with mismatched squad IDs.'
    ),
      (n._squadId = e.squadId),
      (n._formation = repositories.Squad.getFormation(e.formation)),
      (n._customized = !0),
      e.styles.forEach(function(e) {
        switch (e.index) {
          case UTSquadMentalityEntity.STYLE.OFFENSIVE_STYLE:
            n._offensiveStyle = e.value;
            break;
          case UTSquadMentalityEntity.STYLE.OFFENSIVE_WIDTH:
            n._offensiveWidth = e.value;
            break;
          case UTSquadMentalityEntity.STYLE.OFFENSIVE_PLAYERS_IN_BOX:
            n._offensivePlayersInBox = e.value;
            break;
          case UTSquadMentalityEntity.STYLE.DEFENSIVE_STYLE:
            n._defensiveStyle = e.value;
            break;
          case UTSquadMentalityEntity.STYLE.DEFENSIVE_WIDTH:
            n._defensiveWidth = e.value;
            break;
          case UTSquadMentalityEntity.STYLE.DEFENSIVE_DEPTH:
            n._defensiveDepth = e.value;
            break;
          case UTSquadMentalityEntity.STYLE.CORNER_PLAYERS_IN_BOX:
            n._cornerPlayersInBox = e.value;
            break;
          case UTSquadMentalityEntity.STYLE.FREE_KICK_PLAYERS_IN_BOX:
            n._freeKickPlayersInBox = e.value;
        }
      });
    var o = [];
    return (
      e.instructions.forEach(function(e, t) {
        var i =
          t >= entities.Squad.FIELD_PLAYERS
            ? t - entities.Squad.FIELD_PLAYERS
            : t;
        o[i] || (o[i] = []), o[i].push(e.value);
      }),
      n._formation.getPositions().forEach(function(e, t) {
        var i = e.getId(),
          s = n._instructions.get(i);
        s || ((s = new UTPlayerInstructionsVO(i)), n._instructions.set(i, s)),
          s.setInstructionsFromBitwiseIntegers(o[t] || []);
      }),
      e.positions.forEach(function(e) {
        n._positions[e.index] = e.value;
      }),
      n
    );
  }),
  utils.JS.inherits(UTSquadEntityFactory, UTObject),
  (UTSquadEntityFactory.prototype._normalizePayload = function _normalizePayload(
    e
  ) {
    return (
      utils.JS.isNumber(e.starRating) &&
        ((e.rating = e.starRating), delete e.starRating),
      utils.JS.isString(e.squadName) || (e.squadName = ''),
      Array.isArray(e.manager) &&
        (e.manager = 0 < e.manager.length ? e.manager[0] : null),
      e
    );
  }),
  (UTSquadEntityFactory.prototype.createSquad = function createSquad(e) {
    e = this._normalizePayload(e);
    var t = new entities.Squad(this._squadDAO);
    return _parseSquadPayload.call(this, t, e), t;
  }),
  (UTSquadEntityFactory.prototype.createSBCSquad = function createSquad(
    e,
    t,
    i
  ) {
    e = this._normalizePayload(e);
    var s = new entities.Squad(this._squadDAO);
    return s.setSBC(!0), _parseSBCSquadPayload(s, e, t, i), s;
  }),
  utils.JS.inherits(UTItemRepository, UTHashTable),
  (UTItemRepository.prototype.isCacheExpired = function isCacheExpired() {
    return this._expiryTimestamp < Date.now();
  }),
  (UTItemRepository.prototype.reset = function reset() {
    this.clear(),
      this._resetCount(),
      (this.endOfList = !1),
      (this._expiryTimestamp = 0);
  }),
  (UTItemRepository.prototype.isCountSet = function isCountSet() {
    return -1 < this.count;
  }),
  (UTItemRepository.prototype._resetCount = function _resetCount() {
    this.count = -1;
  }),
  (UTItemRepository.prototype.set = function set(e, t) {
    var i = this.has(e) ? this._collection[e] : null;
    return (
      (this._collection[e] = t),
      this.isCountSet() &&
        (this.endOfList ? (this.count = this.length) : i || this._resetCount()),
      i
    );
  }),
  (UTItemRepository.prototype.remove = function remove(e) {
    var t = null;
    return (
      this.has(e) && ((t = this._collection[e]), delete this._collection[e]),
      this.isCountSet() &&
        (this.endOfList ? (this.count = this.length) : t && this._resetCount()),
      t
    );
  }),
  (UTItemRepository.prototype.search = function search(i) {
    return this.values().filter(function(e) {
      if (
        (i.untradeables === enums.SearchUntradeables.ONLY && !e.untradeable) ||
        (i.untradeables === enums.SearchUntradeables.EXCLUDE && e.untradeable)
      )
        return !1;
      if (i.type === enums.SearchType.PLAYER) {
        if (
          i.position !== enums.SearchType.ANY &&
          repositories.Squad.getPositionByUniqueName(i.position).getId() !==
            e.preferredPosition
        )
          return !1;
        if (i.zone !== enums.SearchType.ANY) {
          var t = utils.JS.find(POSITION_ZONE_LOOKUP, function(e) {
            return e.value === i.zone;
          });
          if (
            t.minPosId > e.preferredPosition ||
            t.maxPosId < e.preferredPosition
          )
            return !1;
        }
        if (-1 !== i.playStyle && e.playStyle !== i.playStyle) return !1;
        if (
          0 < i.excludeDefIds.length &&
          -1 < i.excludeDefIds.indexOf(e.getDefId())
        )
          return !1;
      } else if (i.type === enums.SearchType.STAFF && i.category !== enums.SearchCategory.ANY && ((e.isManager() && i.category !== enums.SearchCategory.MANAGER) || (e.isHeadCoach() && i.category !== enums.SearchCategory.COACH_HEAD) || (e.isFitnessCoach() && i.category !== enums.SearchCategory.COACH_FITNESS) || (e.isGKCoach() && i.category !== enums.SearchCategory.COACH_GK) || (e.isPhysio() && i.category !== enums.SearchCategory.PHYSIO))) return !1;
      if (
        i.type !== enums.SearchType.CONSUMABLES_DEVELOPMENT &&
        i.type !== enums.SearchType.CONSUMABLES_TRAINING
      ) {
        if (
          i.level !== enums.SearchType.ANY &&
          ((!e.hasQualityTiers() && i.level !== enums.SearchLevel.SPECIAL) ||
            (e.getTier() === enums.ItemRatingTier.BRONZE &&
              i.level !== enums.SearchLevel.BRONZE) ||
            (e.getTier() === enums.ItemRatingTier.SILVER &&
              i.level !== enums.SearchLevel.SILVER) ||
            (e.getTier() === enums.ItemRatingTier.GOLD &&
              i.level !== enums.SearchLevel.GOLD))
        )
          return !1;
        if (
          (-1 !== i.nation && i.nation !== e.nationId) ||
          (-1 !== i.league && i.league !== e.leagueId) ||
          (-1 !== i.club && i.club !== e.teamId)
        )
          return !1;
      }
      return !0;
    });
  }),
  (UTItemRepository.prototype.setCacheTimestamp = function setCacheTimestamp(
    e,
    t
  ) {
    this._expiryTimestamp =
      e + (utils.JS.isNumber(t) ? t * MS_PER_SECOND : 3e5);
  }),
  utils.JS.inherits(UTClubRepository, UTObject),
  (UTClubRepository.prototype.reset = function reset() {
    this._players.reset(),
      this._staff.reset(),
      this._consumables.reset(),
      this._badges.reset(),
      this._balls.reset(),
      this._kits.reset(),
      this._stadiums.reset(),
      this._banners.reset(),
      this._celebrations.reset(),
      this._tifos.reset(),
      this._activeItems.clear(),
      (this._cacheTimestamp = 0);
  }),
  (UTClubRepository.prototype._getActiveItems = function _getActiveItems() {
    var i = [];
    return (
      this._activeItems.keys().forEach(function(e) {
        var t = this._activeItems.get(e);
        switch (e) {
          case enums.ItemState.ACTIVE_BADGE:
            i.push(this._badges.get(t));
            break;
          case enums.ItemState.ACTIVE_BALL:
            i.push(this._balls.get(t));
            break;
          case enums.ItemState.ACTIVE_AWAY_KIT:
          case enums.ItemState.ACTIVE_HOME_KIT:
            i.push(this._kits.get(t));
            break;
          case enums.ItemState.ACTIVE_STADIUM:
            i.push(this._stadiums.get(t));
            break;
          case enums.ItemState.ACTIVE_BANNER:
            i.push(this._banners.get(t));
            break;
          case enums.ItemState.ACTIVE_CELEBRATION:
            i.push(this._celebrations.get(t));
            break;
          case enums.ItemState.ACTIVE_TIFO:
            i.push(this._tifos.get(t));
        }
      }, this),
      i
    );
  }),
  (UTClubRepository.prototype.getActiveItems = function getActiveItems(t) {
    var e = this._getActiveItems();
    return t
      ? utils.JS.find(e, function(e) {
          return e.state === t;
        })
      : e;
  }),
  (UTClubRepository.prototype.setActiveItem = function setActiveItem(e) {
    if (e.isActiveClubItem()) {
      var t = this.getActiveItems(e.state);
      utils.JS.isValid(t) && t.id !== e.id && (t.state = enums.ItemState.FREE),
        this._activeItems.set(e.state, e.id);
    }
  }),
  (UTClubRepository.prototype._addClubItem = function _addClubItem(e) {
    e.isBadge()
      ? this._badges.set(e.id, e)
      : e.isBall()
      ? this._balls.set(e.id, e)
      : e.isKit()
      ? this._kits.set(e.id, e)
      : e.isStadium()
      ? this._stadiums.set(e.id, e)
      : e.isBanner()
      ? this._banners.set(e.id, e)
      : e.isCelebration()
      ? this._celebrations.set(e.id, e)
      : e.isTifo() && this._tifos.set(e.id, e),
      this.setActiveItem(e);
  }),
  (UTClubRepository.prototype._removeClubItem = function _removeClubItem(e) {
    e.isActiveClubItem()
      ? utils.Debug.Assert(
          !1,
          "[UTClubRepository::_removeClubItem] Can't remove an active club item."
        )
      : e.isBadge()
      ? this._badges.remove(e.id)
      : e.isBall()
      ? this._balls.remove(e.id)
      : e.isKit()
      ? this._kits.remove(e.id)
      : e.isStadium()
      ? this._stadiums.remove(e.id)
      : e.isBanner()
      ? this._banners.remove(e.id)
      : e.isCelebration()
      ? this._celebrations.remove(e.id)
      : e.isTifo() && this._tifos.remove(e.id);
  }),
  (UTClubRepository.prototype._addConsumable = function _addConsumable(e) {
    this._consumables.has(e.resourceId)
      ? this._consumables.get(e.resourceId).increaseStackCount()
      : this._consumables.set(e.resourceId, e);
  }),
  (UTClubRepository.prototype._removeConsumable = function _removeConsumable(
    e
  ) {
    0 === this._consumables.get(e).stackCount && this._consumables.remove(e);
  }),
  (UTClubRepository.prototype.add = function add(e) {
    function _add(e) {
      e.isPlayer()
        ? this._players.set(e.id, e)
        : e.isStaff()
        ? this._staff.set(e.id, e)
        : e.isClubItem()
        ? this._addClubItem(e)
        : e.isConsumable() && this._addConsumable(e);
    }
    Array.isArray(e)
      ? e.forEach(function(e) {
          _add.call(this, e);
        }, this)
      : _add.call(this, e);
  }),
  (UTClubRepository.prototype.remove = function remove(t) {
    function _remove(e) {
      e.isPlayer()
        ? this._players.remove(e.id)
        : t.isStaff()
        ? this._staff.remove(e.id)
        : t.isClubItem()
        ? this._removeClubItem(e)
        : t.isConsumable() && this._removeConsumable(e.resourceId);
    }
    Array.isArray(t)
      ? t.forEach(function(e) {
          _remove.call(this, e);
        }, this)
      : _remove.call(this, t);
  }),
  (UTClubRepository.prototype.update = function update(e) {
    e.isPlayer() && this._players.has(e.id) && this._players.set(e.id, e);
  }),
  (UTClubRepository.prototype.hasStats = function hasStats() {
    return (
      this._players.isCountSet() &&
      this._staff.isCountSet() &&
      this._kits.isCountSet() &&
      this._balls.isCountSet() &&
      this._stadiums.isCountSet() &&
      this._banners.isCountSet() &&
      this._celebrations.isCountSet() &&
      this._tifos.isCountSet()
    );
  }),
  (UTClubRepository.prototype.getStats = function getStats() {
    return [
      new transferobjects.ClubStat({
        type: enums.ClubItemType.PLAYERS,
        typeValue: this._players.count
      }),
      new transferobjects.ClubStat({
        type: enums.ClubItemType.STAFF,
        typeValue: this._staff.count
      }),
      new transferobjects.ClubStat({
        type: enums.ClubItemType.KITS,
        typeValue: this._kits.count
      }),
      new transferobjects.ClubStat({
        type: enums.ClubItemType.BALLS,
        typeValue: this._balls.count
      }),
      new transferobjects.ClubStat({
        type: enums.ClubItemType.STADIA,
        typeValue: this._stadiums.count
      }),
      new transferobjects.ClubStat({
        type: enums.ClubItemType.BANNERS,
        typeValue: this._banners.count
      }),
      new transferobjects.ClubStat({
        type: enums.ClubItemType.CELEBRATIONS,
        typeValue: this._celebrations.count
      }),
      new transferobjects.ClubStat({
        type: enums.ClubItemType.TIFOS,
        typeValue: this._tifos.count
      })
    ];
  }),
  (UTClubRepository.prototype.setStats = function setStats(e) {
    e.forEach(function(e) {
      this.getCollectionByClubItemType(e.type).count = e.count;
    }, this);
  }),
  (UTClubRepository.prototype.getCollectionBySearchCriteria = function getCollectionBySearchCriteria(
    e
  ) {
    switch (e.type) {
      case enums.SearchType.PLAYER:
        return this._players;
      case enums.SearchType.STAFF:
        return this._staff;
      case enums.SearchType.CONSUMABLES_DEVELOPMENT:
      case enums.SearchType.CONSUMABLES_TRAINING:
        return this._consumables;
      case enums.SearchType.CLUB_INFO:
        if (e.category === enums.SearchCategory.BADGE) return this._badges;
        if (e.category === enums.SearchCategory.KIT) return this._kits;
        break;
      case enums.SearchType.BALL:
        return this._balls;
      case enums.SearchType.STADIUM:
        return this._stadiums;
      case enums.SearchType.BANNER:
        return this._banners;
      case enums.SearchType.CELEBRATION:
        return this._celebrations;
      case enums.SearchType.TIFO:
        return this._tifos;
      default:
        return (
          utils.Debug.Assert(
            !1,
            '[UTClubRepository::getCollectionBySearchCriteria] No club collection associated to search type: ' +
              searchType
          ),
          null
        );
    }
  }),
  (UTClubRepository.prototype.getCollectionByClubItemType = function getCollectionByClubItemType(
    e
  ) {
    switch (e) {
      case enums.ClubItemType.PLAYERS:
        return this._players;
      case enums.ClubItemType.STAFF:
        return this._staff;
      case enums.ClubItemType.KITS:
        return this._kits;
      case enums.ClubItemType.BALLS:
        return this._balls;
      case enums.ClubItemType.STADIA:
        return this._stadiums;
      case enums.ClubItemType.BANNERS:
        return this._banners;
      case enums.ClubItemType.CELEBRATIONS:
        return this._celebrations;
      case enums.ClubItemType.TIFOS:
        return this._tifos;
      default:
        return (
          utils.Debug.Assert(
            !1,
            '[UTClubRepository::getCollectionByClubItemType] No club collection associated to club item type: ' +
              e
          ),
          null
        );
    }
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.StaticPlayerData = function UTStaticPlayerDataDTO(e) {
    (this.id = e.id),
      Object.defineProperty(this, 'id', {
        writable: !1
      }),
      (this.firstName = e.f),
      Object.defineProperty(this, 'firstName', {
        writable: !1
      }),
      (this.lastName = e.l),
      Object.defineProperty(this, 'lastName', {
        writable: !1
      }),
      (this.commonName = e.c || null),
      Object.defineProperty(this, 'commonName', {
        writable: !1
      }),
      (this.name = ''),
      Object.defineProperty(this, 'name', {
        get: function() {
          return this.commonName || this.firstName + ' ' + this.lastName;
        }
      }),
      (this.rating = e.r),
      Object.defineProperty(this, 'rating', {
        writable: !1
      }),
      (this.nationId = e.n),
      Object.defineProperty(this, 'nationId', {
        writable: !1
      });
  }),
  NamespaceManager.Register('repositories'),
  (repositories.Item = (function() {
    var i = new UTHashTable();

    function ItemDomainRepository() {
      var t;
      Object.defineProperty(this, 'cachedDurationIndex', {
        get: function() {
          return t;
        },
        set: function(e) {
          utils.JS.isNumber(e) && (t = e);
        }
      }),
        (this._pileSizes = new UTHashTable()),
        (this._unassigned = new UTItemRepository()),
        (this._transfer = new UTItemRepository()),
        (this._inbox = new UTItemRepository()),
        (this._club = new UTClubRepository()),
        (this.cachedDurationIndex = 0),
        this._pileSizes.set(enums.FUTItemPile.PURCHASED, 5),
        this._pileSizes.set(enums.FUTItemPile.TRANSFER, 30),
        this._pileSizes.set(enums.FUTItemPile.INBOX, 30);
    }
    return (
      (ItemDomainRepository.prototype.reset = function reset() {
        this._unassigned.reset(),
          this._transfer.reset(),
          this._inbox.reset(),
          this._club.reset();
      }),
      (ItemDomainRepository.prototype.setCacheTimestamp = function setCacheTimestamp(
        e,
        t,
        i
      ) {
        switch (e) {
          case enums.FUTItemPile.PURCHASED:
            this._unassigned.setCacheTimestamp(t, i);
            break;
          case enums.FUTItemPile.TRANSFER:
            this._transfer.setCacheTimestamp(t, i);
            break;
          case enums.FUTItemPile.INBOX:
            this._inbox.setCacheTimestamp(t, i);
        }
      }),
      (ItemDomainRepository.prototype.setDirty = function setDirty(e) {
        utils.JS.isValid(e)
          ? this.setCacheTimestamp(e, 0, 0)
          : (this._unassigned.setCacheTimestamp(0, 0),
            this._transfer.setCacheTimestamp(0, 0),
            this._inbox.setCacheTimestamp(0, 0));
      }),
      (ItemDomainRepository.prototype.isDirty = function isDirty(e) {
        switch (e) {
          case enums.FUTItemPile.PURCHASED:
            return this._unassigned.isCacheExpired();
          case enums.FUTItemPile.TRANSFER:
            return this._transfer.isCacheExpired();
          case enums.FUTItemPile.INBOX:
            return this._inbox.isCacheExpired();
        }
        return !0;
      }),
      (ItemDomainRepository.prototype.getClub = function getClub() {
        return this._club;
      }),
      (ItemDomainRepository.prototype.setPileSize = function setPileSize(e, t) {
        this._pileSizes.set(e, t);
      }),
      (ItemDomainRepository.prototype.getPileSize = function getPileSize(e) {
        return (
          utils.Debug.Assert(
            this._pileSizes.has(e),
            '[ItemDomainRepository::getPileSize] Unsupported pile requested.'
          ),
          this._pileSizes.get(e) || 0
        );
      }),
      (ItemDomainRepository.prototype.isPileFull = function isPileFull(e) {
        var t = 0,
          i = this._pileSizes.has(e) ? this._pileSizes.get(e) : 0;
        switch (e) {
          case enums.FUTItemPile.PURCHASED:
            t = this._unassigned.length;
            break;
          case enums.FUTItemPile.TRANSFER:
            t = this._transfer.length;
            break;
          case enums.FUTItemPile.INBOX:
            t = this._inbox.length;
            break;
          case enums.FUTItemPile.CLUB:
            return !1;
        }
        return i <= t;
      }),
      (ItemDomainRepository.prototype.numItemsInCache = function numItemsInCache(
        e
      ) {
        switch (e) {
          case enums.FUTItemPile.PURCHASED:
            return this._unassigned.length;
          case enums.FUTItemPile.TRANSFER:
            return this._transfer.length;
          case enums.FUTItemPile.INBOX:
            return this._inbox.length;
          default:
            return utils.Debug.Assert(!1, 'Unsupported item pile: ' + e), 0;
        }
      }),
      (ItemDomainRepository.prototype.hasStaticData = function hasStaticData() {
        return 0 < i.length;
      }),
      (ItemDomainRepository.prototype.setStaticData = function setStaticData(
        e
      ) {
        i.clear(),
          e.forEach(function(e) {
            var t = new transferobjects.StaticPlayerData(e);
            i.set(t.id, t);
          });
      }),
      (ItemDomainRepository.prototype.getStaticDataByDefId = function getStaticDataByDefId(
        e
      ) {
        return i.get(e);
      }),
      (ItemDomainRepository.prototype.getStaticData = function getStaticData() {
        return i.values();
      }),
      (ItemDomainRepository.prototype.getWatchedItems = function getWatchedItems() {
        return this._inbox.values();
      }),
      (ItemDomainRepository.prototype.setWatchedItems = function setWatchedItems(
        e
      ) {
        this._inbox.clear(),
          e.forEach(function(e) {
            this._inbox.set(e.id, e);
          }, this),
          (this._inbox.endOfList = !0);
      }),
      (ItemDomainRepository.prototype.getTransferItems = function getTransferItems() {
        return this._transfer.values();
      }),
      (ItemDomainRepository.prototype.setTransferItems = function setTransferItems(
        e
      ) {
        this._transfer.clear(),
          e.forEach(function(e) {
            this._transfer.set(e.id, e);
          }, this),
          (this._transfer.endOfList = !0);
      }),
      (ItemDomainRepository.prototype.getUnassignedItems = function getUnassignedItems() {
        return this._unassigned.values();
      }),
      (ItemDomainRepository.prototype.setUnassignedItems = function setUnassignedItems(
        e
      ) {
        this._unassigned.clear(),
          e.forEach(function(e) {
            this._unassigned.set(e.id, e);
          }, this),
          (this._unassigned.endOfList = !0);
      }),
      (ItemDomainRepository.prototype.add = function add(e) {
        var i = [];

        function _add(e) {
          var t = e.getAuctionData();
          if (t.watched && !t.tradeOwner) {
            if (this.isPileFull(enums.FUTItemPile.INBOX)) return;
            this._inbox.set(e.id, e);
          } else {
            if (this.isPileFull(e.pile)) return;
            switch (e.pile) {
              case enums.FUTItemPile.PURCHASED:
                this._unassigned.set(e.id, e);
                break;
              case enums.FUTItemPile.TRANSFER:
                this._transfer.set(e.id, e);
                break;
              case enums.FUTItemPile.INBOX:
                this._inbox.set(e.id, e);
                break;
              case enums.FUTItemPile.CLUB:
                this._club.add(e);
            }
          }
          i.push(e);
        }
        return Array.isArray(e) ? e.forEach(_add, this) : _add.call(this, e), i;
      }),
      (ItemDomainRepository.prototype.remove = function remove(e) {
        function _remove(e) {
          var t = e.getAuctionData();
          if (!t.watched || t.tradeOwner)
            switch (e.pile) {
              case enums.FUTItemPile.PURCHASED:
                this._unassigned.remove(e.id);
                break;
              case enums.FUTItemPile.TRANSFER:
                this._transfer.remove(e.id);
                break;
              case enums.FUTItemPile.INBOX:
                this._inbox.remove(e.id);
                break;
              case enums.FUTItemPile.CLUB:
                this._club.remove(e);
            }
          else this._inbox.remove(e.id);
        }
        Array.isArray(e) ? e.forEach(_remove, this) : _remove.call(this, e);
      }),
      (ItemDomainRepository.prototype.update = function update(e) {
        function _update(e) {
          switch (e.pile) {
            case enums.FUTItemPile.CLUB:
              this._club.update(e);
              break;
            default:
              utils.Debug.Assert(
                !1,
                'ItemDomainRepository::update. This pile does not support updating items.'
              );
          }
        }
        Array.isArray(e) ? e.forEach(_update, this) : _update.call(this, e);
      }),
      new ItemDomainRepository()
    );
  })()),
  NamespaceManager.Register('repositories'),
  (repositories.UTNimbleMTXItem = (function() {
    function UTNimbleMTXItemRepository(e) {
      (this._mtxItems = new UTHashTable()),
        Object.defineProperty(this, '_mtxItems', {
          writable: !1,
          enumerable: !1
        }),
        utils.JS.isValid(e) && this.add(e);
    }
    return (
      (UTNimbleMTXItemRepository.prototype.add = function add(e) {
        Array.isArray(e)
          ? e.forEach(function(e) {
              this._mtxItems.set(e.sku, e);
            }, this)
          : this._mtxItems.set(e.sku, e);
      }),
      (UTNimbleMTXItemRepository.prototype.get = function get(e) {
        return this._mtxItems.get(e);
      }),
      (UTNimbleMTXItemRepository.prototype.values = function values() {
        return this._mtxItems.values();
      }),
      (UTNimbleMTXItemRepository.prototype.isEmpty = function isEmpty() {
        return this._mtxItems.length < 1;
      }),
      (UTNimbleMTXItemRepository.prototype.reset = function reset() {
        this._mtxItems.clear();
      }),
      new UTNimbleMTXItemRepository()
    );
  })()),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.PlayStyle = function PlayStyleDTO(e) {
    (this.statBonus = e.statBonus || [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
      Object.defineProperty(this, 'statBonus', {
        writable: !1,
        enumerable: !0
      }),
      (this.style = e.style || 0),
      Object.defineProperty(this, 'style', {
        writable: !1,
        enumerable: !0
      }),
      (this.styleId = e.styleId || 0),
      Object.defineProperty(this, 'styleId', {
        writable: !1,
        enumerable: !0
      }),
      (this.styleType = e.styleType || 0),
      Object.defineProperty(this, 'styleType', {
        writable: !1,
        enumerable: !0
      });
  }),
  NamespaceManager.Register('repositories'),
  (repositories.PlayStyle = (function() {
    function PlayStyleRepository() {
      (this._playstyles = new UTHashTable()),
        Object.defineProperty(this, '_playstyles', {
          writable: !1,
          enumerable: !1
        });
    }
    return (
      (PlayStyleRepository.prototype.setPlayStyles = function setPlayStyles(e) {
        e.forEach(function(e) {
          var t = new transferobjects.PlayStyle(e);
          this._playstyles.set(t.styleId, t);
        }, this);
      }),
      (PlayStyleRepository.prototype.getPlayStyles = function getPlayStyles() {
        return this._playstyles.values();
      }),
      (PlayStyleRepository.prototype.getPlayStyleById = function getPlayStyleById(
        e
      ) {
        return this._playstyles.get(e);
      }),
      (PlayStyleRepository.prototype.getPlayStyleBonusById = function getPlayStyleBonusById(
        e,
        t
      ) {
        var i = this.getPlayStyleById(e);
        return i
          ? t
            ? i.statBonus.slice(6)
            : i.statBonus.slice(0, 6)
          : [0, 0, 0, 0, 0, 0];
      }),
      new PlayStyleRepository()
    );
  })()),
  NamespaceManager.Register('repositories'),
  (repositories.Rarity = (function() {
    function UTItemRarityRepository() {
      UTHashTable.call(this, {}), (this._expiryTimestamp = 0);
    }
    return (
      utils.JS.inherits(UTItemRarityRepository, UTHashTable),
      (UTItemRarityRepository.prototype.add = function add(e, t) {
        this.has(t) || this.set(t, new UTHashTable());
        var i = this.get(t);
        Array.isArray(e)
          ? e.forEach(function(e) {
              i.set(e.id, e);
            })
          : i.set(e.id, e);
      }),
      (UTItemRarityRepository.prototype.getRarity = function getRarity(e, t) {
        t = t || enums.Year.ASSET;
        var i = this.get(t);
        return (
          utils.Debug.Assert(
            utils.JS.isValid(i),
            'Rarity asset year not found: ' + t
          ),
          i && i.has(e) ? i.get(e) : new UTItemRarityDTO()
        );
      }),
      (UTItemRarityRepository.prototype.yearValues = function yearValues(e) {
        var t = this.get(e);
        return t ? t.values() : [];
      }),
      (UTItemRarityRepository.prototype.isCacheExpired = function isCacheExpired() {
        return this._expiryTimestamp < Date.now();
      }),
      (UTItemRarityRepository.prototype.isEmpty = function isEmpty() {
        return this.length < 1;
      }),
      (UTItemRarityRepository.prototype.isYearEmpty = function isYearEmpty(e) {
        var t = this.get(e);
        return !t || t.length < 1;
      }),
      (UTItemRarityRepository.prototype.reset = function reset() {
        this.clear(), (this._expiryTimestamp = 0);
      }),
      (UTItemRarityRepository.prototype.resetYear = function resetYear(e) {
        var t = this.get(e);
        t && t.clear(), e === enums.Year.ASSET && (this._expiryTimestamp = 0);
      }),
      (UTItemRarityRepository.prototype.setCacheTimestamp = function setCacheTimestamp(
        e,
        t
      ) {
        this._expiryTimestamp =
          e + (utils.JS.isNumber(t) ? t * MS_PER_SECOND : 36e5);
      }),
      new UTItemRarityRepository()
    );
  })()),
  NamespaceManager.Register('repositories'),
  (repositories.Squad = (function() {
    function UTSquadRepository() {
      (this._squads = new UTHashTable()),
        (this._formations = new UTHashTable()),
        (this._positions = new UTHashTable()),
        (this._squadListCacheExpiration = 0);
    }
    return (
      (UTSquadRepository.prototype.reset = function reset() {
        (this._squadListCacheExpiration = 0),
          this._squads.clear(),
          this._formations.clear(),
          this._positions.clear();
      }),
      (UTSquadRepository.prototype.setDirty = function setDirty() {
        this._squads.clear(), (this._squadListCacheExpiration = 0);
      }),
      (UTSquadRepository.prototype.set = function set(e, t) {
        var i = t.getId();
        if (this._squads.has(e))
          if (this._squads.get(e).has(i)) {
            var s = this._squads.get(e).get(i);
            s.update(t), s.setCacheTimestamp(0);
          } else this._squads.get(e).set(i, t);
        else {
          var n = {};
          (n[i] = t), this._squads.set(e, new UTHashTable(n));
        }
      }),
      (UTSquadRepository.prototype.getSquadById = function getSquadById(e, t) {
        return this._squads.has(e) ? this._squads.get(e).get(t) : null;
      }),
      (UTSquadRepository.prototype.getSquads = function getSquads(e) {
        return this._squads.has(e) ? this._squads.get(e).values() : [];
      }),
      (UTSquadRepository.prototype.removeSquads = function removeSquads(e) {
        this._squads.has(e) && this._squads.get(e).clear();
      }),
      (UTSquadRepository.prototype.removeSquad = function removeSquad(e, t) {
        this._squads.has(e) && this._squads.get(e).remove(t);
      }),
      (UTSquadRepository.prototype.getFormation = function getFormation(e) {
        return this._formations.get(e);
      }),
      (UTSquadRepository.prototype.getFormations = function getFormations() {
        return this._formations.values();
      }),
      (UTSquadRepository.prototype.getPosition = function getPosition(e) {
        return this._positions.get(e);
      }),
      (UTSquadRepository.prototype.getPositionByUniqueName = function getPositionByUniqueName(
        t
      ) {
        return utils.JS.find(this._positions.values(), function(e) {
          return e.getName() === t;
        });
      }),
      (UTSquadRepository.prototype.setSquadDataLookup = function setSquadDataLookup(
        o
      ) {
        o.formationData.forEach(function(n) {
          var e = utils.JS.find(o.chemLinks, function(e) {
              return e.formationName === n.name;
            }),
            t = e
              ? e.linkData.map(function(e) {
                  return new transferobjects.SquadLink(e);
                })
              : [],
            i = n.uniquePositionSlots.map(function(e, t) {
              var i = n.generalPositionSlots[t],
                s = o.positionBonusTable[i].map(function(e) {
                  return o.bonusValues.Position[e];
                });
              return new transferobjects.SquadPosition(o.positionData[e], s);
            }),
            s = new transferobjects.SquadFormation(n, o.bonusValues.Team, t, i);
          this._formations.set(s.getName(), s);
        }, this),
          o.positionData.forEach(function(e) {
            var t = new transferobjects.SquadPosition(e, []);
            this._positions.set(e.uniqueId, t);
          }, this);
      }),
      (UTSquadRepository.prototype.isSquadListCacheExpired = function isSquadListCacheExpired() {
        return this._squadListCacheExpiration < Date.now();
      }),
      (UTSquadRepository.prototype.setSquadListCacheTimestamp = function setSquadListCacheTimestamp(
        e,
        t
      ) {
        this._squadListCacheExpiration =
          e + (utils.JS.isNumber(t) ? t * MS_PER_SECOND : 6e5);
      }),
      new UTSquadRepository()
    );
  })()),
  (LeagueRepository.prototype.add = function add(e) {
    Array.isArray(e)
      ? e.forEach(function(e) {
          this._leagues.set(e.id, e);
        }, this)
      : this._leagues.set(e.id, e);
  }),
  (LeagueRepository.prototype.get = function get(e) {
    return this._leagues.get(e);
  }),
  (LeagueRepository.prototype.values = function values() {
    return this._leagues.values();
  }),
  (NationRepository.prototype.add = function add(e) {
    Array.isArray(e)
      ? e.forEach(function(e) {
          this._nations.set(e.id, e);
        }, this)
      : this._nations.set(e.id, e);
  }),
  (NationRepository.prototype.get = function get(e) {
    return this._nations.get(e);
  }),
  (NationRepository.prototype.values = function values() {
    return this._nations.values();
  }),
  (TeamRepository.prototype.add = function add(e) {
    Array.isArray(e)
      ? e.forEach(function(e) {
          this._teams.set(e.id, e);
        }, this)
      : this._teams.set(e.id, e);
  }),
  (TeamRepository.prototype.get = function get(e) {
    return this._teams.get(e);
  }),
  (TeamRepository.prototype.values = function values() {
    return this._teams.values();
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.League = function UTLeagueDTO(e, t, i) {
    (this.id = e.LeagueId),
      Object.defineProperty(this, 'id', {
        writable: !1,
        enumerable: !0
      }),
      (this.nation = e.NationId),
      Object.defineProperty(this, 'nation', {
        writable: !1,
        enumerable: !0
      }),
      (this.name = utils.FUTLocalization.getLeagueNameByID(
        this.id,
        t || enums.Year.ASSET
      )),
      Object.defineProperty(this, 'name', {
        writable: !1,
        enumerable: !0
      }),
      (this.abbreviation = utils.FUTLocalization.getLeagueAbbr5ByID(
        this.id,
        t || enums.Year.ASSET
      )),
      Object.defineProperty(this, 'abbreviation', {
        writable: !1,
        enumerable: !0
      }),
      (this.sortName = utils.TextUtils.stripSpecialCharacters(
        this.name
      ).toLowerCase()),
      Object.defineProperty(this, 'sortName', {
        writable: !1,
        enumerable: !0
      }),
      (this.legend = i || !1),
      Object.defineProperty(this, 'legend', {
        writable: !1,
        enumerable: !0
      });
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.Nation = function UTNationDTO(e) {
    (this.id = e),
      Object.defineProperty(this, 'id', {
        writable: !1,
        enumerable: !0
      }),
      (this.name = utils.FUTLocalization.getNationAbb12ById(e)),
      Object.defineProperty(this, 'name', {
        writable: !1,
        enumerable: !0
      }),
      (this.sortName = utils.TextUtils.stripSpecialCharacters(
        this.name
      ).toLowerCase()),
      Object.defineProperty(this, 'sortName', {
        writable: !1,
        enumerable: !0
      });
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.TeamKit = function TeamKitDTO(e) {
    (this.localized = e.L || !1),
      Object.defineProperty(this, 'localized', {
        writable: !1,
        enumerable: !0
      }),
      (this.year = e.Y || 0),
      Object.defineProperty(this, 'year', {
        writable: !1,
        enumerable: !0
      }),
      (this.type = e.type || 0),
      Object.defineProperty(this, 'type', {
        writable: !1,
        enumerable: !0
      }),
      (this.V2 = e.V2 || !1),
      Object.defineProperty(this, 'V2', {
        writable: !1,
        enumerable: !1
      }),
      (this.V4 = e.V4 || !1),
      Object.defineProperty(this, 'V4', {
        writable: !1,
        enumerable: !1
      }),
      (this.V6 = e.V6 || !1),
      Object.defineProperty(this, 'V6', {
        writable: !1,
        enumerable: !1
      });
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.Team = function TeamDTO(e, t, i) {
    (this.id = e.TeamId),
      Object.defineProperty(this, 'id', {
        writable: !1,
        enumerable: !0
      }),
      (this.league = e.LeagueId),
      Object.defineProperty(this, 'league', {
        writable: !1,
        enumerable: !0
      }),
      (this.kits = Array.isArray(e.Kit)
        ? e.Kit.map(function(e) {
            return new transferobjects.TeamKit(e);
          })
        : []),
      Object.defineProperty(this, 'kits', {
        writable: !1,
        enumerable: !0
      }),
      (this.name = utils.FUTLocalization.getTeamAbb15ByID(
        e.TeamId,
        t || enums.Year.ASSET
      )),
      Object.defineProperty(this, 'name', {
        writable: !1,
        enumerable: !0
      }),
      (this.sortName = utils.TextUtils.stripSpecialCharacters(
        this.name
      ).toLowerCase()),
      Object.defineProperty(this, 'sortName', {
        writable: !1,
        enumerable: !0
      }),
      (this.legend = i || !1),
      Object.defineProperty(this, 'legend', {
        writable: !1,
        enumerable: !0
      });
  }),
  NamespaceManager.Register('repositories'),
  (repositories.TeamConfig = (function() {
    function _sortByName(e, t) {
      return services.Localization.isLatinAlphabet()
        ? utils.JS.sortCompare(e.sortName, t.sortName)
        : e.name.localeCompare(
            t.name,
            services.Localization.getLocale().toBCPString(),
            {
              sensitivity: 'accent'
            }
          );
    }

    function TeamConfigRepository() {
      (this._nations = new UTHashTable()),
        Object.defineProperty(this, '_nations', {
          writable: !1,
          enumerable: !1
        }),
        (this._leagues = new UTHashTable()),
        Object.defineProperty(this, '_leagues', {
          writable: !1,
          enumerable: !1
        }),
        (this._teams = new UTHashTable()),
        Object.defineProperty(this, '_teams', {
          writable: !1,
          enumerable: !1
        }),
        (this._customTeams = new UTHashTable()),
        Object.defineProperty(this, '_customTeams', {
          writable: !1,
          enumerable: !1
        });
    }
    return (
      (TeamConfigRepository.prototype.reset = function reset() {
        this._nations.clear(),
          this._leagues.clear(),
          this._teams.clear(),
          this._customTeams.clear();
      }),
      (TeamConfigRepository.prototype.addNations = function addNations(e, t) {
        var i = e.map(function(e) {
          return new transferobjects.Nation(e);
        });
        this._nations.has(t)
          ? this._nations.get(t).add(i)
          : this._nations.set(t, new NationRepository(i));
      }),
      (TeamConfigRepository.prototype.getNation = function getNation(e, t) {
        return (
          t || (t = enums.Year.ASSET),
          this._nations.has(t) ? this._nations.get(t).get(e) : null
        );
      }),
      (TeamConfigRepository.prototype.getNationsByYear = function getNationsByYear(
        e
      ) {
        return this._nations.has(e)
          ? this._nations
              .get(e)
              .values()
              .sort(_sortByName)
          : [];
      }),
      (TeamConfigRepository.prototype.addLeagues = function addLeagues(
        e,
        t,
        i
      ) {
        var s = e.map(function(e) {
          return new transferobjects.League(e, t, i);
        });
        this._leagues.has(t)
          ? this._leagues.get(t).add(s)
          : this._leagues.set(t, new LeagueRepository(s));
      }),
      (TeamConfigRepository.prototype.getLeague = function getLeague(e, t) {
        return (
          t || (t = enums.Year.ASSET),
          this._leagues.has(t) ? this._leagues.get(t).get(e) : null
        );
      }),
      (TeamConfigRepository.prototype.getLeaguesByYear = function getLeaguesByYear(
        e,
        t
      ) {
        if (this._leagues.has(e)) {
          var i = this._leagues.get(e).values();
          return (
            t &&
              (i = i.filter(function(e) {
                return !e.legend;
              })),
            i.sort(_sortByName)
          );
        }
        return [];
      }),
      (TeamConfigRepository.prototype.addTeams = function addTeams(e, t, i) {
        var s = e.map(function(e) {
          return new transferobjects.Team(e, t, i);
        });
        this._teams.has(t)
          ? this._teams.get(t).add(s)
          : this._teams.set(t, new TeamRepository(s));
      }),
      (TeamConfigRepository.prototype.addCustomTeams = function addCustomTeams(
        e,
        t
      ) {
        var i = e.map(function(e) {
          return new transferobjects.Team(e, t);
        });
        this._customTeams.has(t)
          ? this._customTeams.get(t).add(i)
          : this._customTeams.set(t, new TeamRepository(i));
      }),
      (TeamConfigRepository.prototype.getTeam = function getTeam(e, t) {
        return (
          t || (t = enums.Year.ASSET),
          this._teams.has(t) ? this._teams.get(t).get(e) : null
        );
      }),
      (TeamConfigRepository.prototype.getCustomTeam = function getCustomTeam(
        e,
        t
      ) {
        return (
          t || (t = enums.Year.ASSET),
          this._customTeams.has(t) ? this._customTeams.get(t).get(e) : null
        );
      }),
      (TeamConfigRepository.prototype.getTeamsByYear = function getTeamsByYear(
        e,
        t
      ) {
        if (this._teams.has(e)) {
          var i = this._teams.get(e).values();
          return (
            t &&
              (i = i.filter(function(e) {
                return !e.legend;
              })),
            i.sort(_sortByName)
          );
        }
        return [];
      }),
      (TeamConfigRepository.prototype.getCustomTeamsByYear = function getCustomTeamsByYear(
        e
      ) {
        return this._customTeams.has(e)
          ? this._customTeams
              .get(e)
              .values()
              .sort(_sortByName)
          : [];
      }),
      new TeamConfigRepository()
    );
  })()),
  utils.JS.inherits(UTNavigationButtonControl, UTButtonControl),
  (UTNavigationButtonControl.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('button');
      e.classList.add('ut-navigation-button-control'),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTNavigationButtonControl.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTNavigationButtonControl.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTNavigationButtonControl.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  NamespaceManager.Register('views'),
  (views.NavigationBar = function FUINavigationBar() {
    UTTargetActionView.call(this),
      (this._visible = !0),
      Object.defineProperty(this, '_visible', {
        writable: !0,
        enumerable: !1
      }),
      (this._primaryButton = null),
      Object.defineProperty(this, '_primaryButton', {
        writable: !0,
        enumerable: !1
      }),
      (this._secondaryButton = null),
      Object.defineProperty(this, '_secondaryButton', {
        writable: !0,
        enumerable: !1
      }),
      (this._currentStyle = enums.UINavigationBarStyle.DEFAULT),
      Object.defineProperty(this, '_currentStyle', {
        writable: !0,
        enumerable: !1
      }),
      this._generate();
  }),
  utils.JS.inherits(views.NavigationBar, UTTargetActionView),
  (views.NavigationBar.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('ut-navigation-bar-view'),
        (this.__title = document.createElement('h1')),
        this.__title.classList.add('title'),
        e.appendChild(this.__title),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (views.NavigationBar.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__title = null);
  }),
  (views.NavigationBar.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (views.NavigationBar.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.NavigationBar.prototype.dealloc = function dealloc() {
    this._secondaryButton &&
      this._secondaryButton.removeClass('btn-navigation-secondary'),
      (this._primaryButton = null),
      (this._secondaryButton = null),
      this.superclass();
  }),
  (views.NavigationBar.prototype.layoutSubviews = function layoutSubviews() {
    var e = this.getRootElement();
    this._primaryButton &&
      DOMKit.insertBefore(this._primaryButton.getRootElement(), e.firstChild),
      this._secondaryButton &&
        e.appendChild(this._secondaryButton.getRootElement()),
      this._subviews.forEach(function(e) {
        e.view !== this._primaryButton &&
          e.view !== this._secondaryButton &&
          e.container.appendChild(e.view.getRootElement());
      }, this);
  }),
  (views.NavigationBar.prototype.setPrimaryButton = function setPrimaryButton(
    e
  ) {
    this._primaryButton && this._primaryButton.removeFromSuperview(),
      e && this.addSubview(e),
      (this._primaryButton = e);
  }),
  (views.NavigationBar.prototype.setSecondaryButton = function setSecondaryButton(
    e
  ) {
    this._secondaryButton &&
      (this._secondaryButton.removeFromSuperview(),
      this._secondaryButton.removeClass('btn-navigation-secondary')),
      e && (e.addClass('btn-navigation-secondary'), this.addSubview(e)),
      (this._secondaryButton = e);
  }),
  (views.NavigationBar.prototype.setButtons = function setButtons(e, t) {
    this.setPrimaryButton(e), this.setSecondaryButton(t), this.layoutSubviews();
  }),
  (views.NavigationBar.prototype.setHeader = function setHeader(e) {
    this.__title.textContent = e;
  }),
  (views.NavigationBar.prototype.setStyle = function setStyle(e) {
    this._currentStyle !== e &&
      (this.removeClass(this._currentStyle),
      this.addClass(e),
      (this._currentStyle = e));
  }),
  (views.NavigationBar.prototype.setVisible = function setVisible(e, t, i) {
    if (((e = !!e), this._visible !== e)) {
      if (t) {
        var s = this._visible
          ? enums.UIAnimation.FADE_OUT
          : enums.UIAnimation.FADE_IN;
        e && this.setVisibility(!0),
          this.perform(
            s,
            function() {
              e || this.setVisibility(!1), utils.JS.isFunction(i) && i();
            }.bind(this)
          );
      } else this.setVisibility(e), utils.JS.isFunction(i) && i();
      this._visible = e;
    }
  }),
  (views.NavigationContainer = function FUINavigationContainer() {
    UTView.call(this),
      (this._navbar = null),
      (this._toolbar = null),
      this._generate();
  }),
  utils.JS.inherits(views.NavigationContainer, UTView),
  (views.NavigationContainer.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('section');
      e.classList.add('ut-navigation-container-view'),
        (this.__content = document.createElement('div')),
        this.__content.classList.add('ut-navigation-container-view--content'),
        e.appendChild(this.__content),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (views.NavigationContainer.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__content = null);
  }),
  (views.NavigationContainer.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (views.NavigationContainer.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.NavigationContainer.prototype.dealloc = function dealloc() {
    (this._navbar = null), (this._toolbar = null), this.superclass();
  }),
  (views.NavigationContainer.prototype.layoutSubviews = function layoutSubviews() {
    this._subviews.forEach(function(e) {
      e.view !== this._navbar &&
        e.view !== this._toolbar &&
        e.container.appendChild(e.view.getRootElement());
    });
    var e = this.getRootElement();
    this._navbar &&
      DOMKit.insertBefore(this._navbar.getRootElement(), e.firstChild),
      this._toolbar && e.appendChild(this._toolbar.getRootElement());
  }),
  (views.NavigationContainer.prototype.getContentContainer = function getContentContainer() {
    return this.__content;
  }),
  (views.NavigationContainer.prototype.hasNavigationBar = function hasNavigationBar() {
    return this._navbar instanceof views.NavigationBar;
  }),
  (views.NavigationContainer.prototype.hasToolbar = function hasToolbar() {
    return this._toolbar instanceof views.Toolbar;
  }),
  (views.NavigationContainer.prototype.appendNavigationBar = function appendNavigationBar(
    e
  ) {
    this._navbar ||
      (this.addSubview(e), (this._navbar = e), this.layoutSubviews());
  }),
  (views.NavigationContainer.prototype.removeNavigationBar = function removeNavigationBar(
    e
  ) {
    this._navbar &&
      (this._navbar.removeFromSuperview(e), (this._navbar = null));
  }),
  (views.NavigationContainer.prototype.appendToolbar = function appendToolbar(
    e
  ) {
    this._toolbar ||
      (this.addSubview(e), (this._toolbar = e), this.layoutSubviews());
  }),
  (views.NavigationContainer.prototype.setNavigationContext = function setNavigationContext(
    e
  ) {
    var t = this.getContentContainer();
    this.addSubview(e, t), t.appendChild(e.getRootElement());
  }),
  (views.NavigationContainer.prototype.removeToolbar = function removeToolbar(
    e
  ) {
    this._toolbar &&
      (this._toolbar.removeFromSuperview(e), (this._toolbar = null));
  }),
  (views.NavigationContainer.prototype._applyBarDisplayAnimation = function _applyBarDisplayAnimation(
    e
  ) {
    (e.style.transition = 'top 0.3s, bottom 0.3s'),
      this._addListener(
        enums.Event.TRANSITIONEND,
        e,
        function _onBarAnimateComplete() {
          (e.style.transition = ''), this._removeListenersByNS('barAnimate');
        }.bind(this),
        'barAnimate'
      );
  }),
  (views.NavigationContainer.prototype.showNavigationBar = function showNavigationBar(
    e
  ) {
    requestAnimationFrame(
      function _showNavigationBar() {
        this._navbar &&
          (e && this._applyBarDisplayAnimation(this.__content),
          (this.__content.style.top =
            this._navbar.getRootElement().offsetHeight + 'px'),
          this._navbar.setVisible(!0, e));
      }.bind(this)
    );
  }),
  (views.NavigationContainer.prototype.hideNavigationBar = function hideNavigationBar(
    e
  ) {
    requestAnimationFrame(
      function _hideNavigationBar() {
        this._navbar &&
          (e && this._applyBarDisplayAnimation(this.__content),
          (this.__content.style.top = ''),
          this._navbar.setVisible(!1, e));
      }.bind(this)
    );
  }),
  (views.NavigationContainer.prototype.showToolbar = function showToolbar(t) {
    requestAnimationFrame(
      function _showToolbar() {
        if (this._toolbar) {
          var e = this._toolbar.getRootElement().offsetHeight + 'px';
          t && this._applyBarDisplayAnimation(this.__content),
            (this.__content.style.bottom = e),
            this._toolbar.setVisible(!0, t);
        }
      }.bind(this)
    );
  }),
  (views.NavigationContainer.prototype.hideToolbar = function hideToolbar(e) {
    requestAnimationFrame(
      function _hideToolbar() {
        this._toolbar &&
          (e && this._applyBarDisplayAnimation(this.__content),
          (this.__content.style.bottom = ''),
          this._toolbar.setVisible(!1, e));
      }.bind(this)
    );
  }),
  utils.JS.inherits(UTToolbarButtonControl, UTButtonControl),
  (UTToolbarButtonControl.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('button');
      e.classList.add('ut-toolbar-button-control'),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTToolbarButtonControl.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTToolbarButtonControl.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTToolbarButtonControl.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.Toolbar = function FUIToolbar() {
    UTView.call(this),
      (this._visible = !0),
      Object.defineProperty(this, '_visible', {
        writable: !0,
        enumerable: !1
      }),
      this._generate();
  }),
  utils.JS.inherits(views.Toolbar, UTView),
  (views.Toolbar.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('nav');
      e.classList.add('ut-toolbar-view'),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (views.Toolbar.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (views.Toolbar.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (views.Toolbar.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.Toolbar.prototype.setButtons = function setButtons(e) {
    this.removeSubviews(),
      e.forEach(function(e) {
        this.addSubview(e);
      }, this),
      this.layoutSubviews();
  }),
  (views.Toolbar.prototype.setVisible = function setVisible(e, t, i) {
    if (((e = !!e), this._visible !== e)) {
      if (t) {
        var s = this._visible
          ? enums.UIAnimation.FADE_OUT
          : enums.UIAnimation.FADE_IN;
        e && this.setVisibility(!0),
          this.perform(
            s,
            function() {
              e || this.setVisibility(!1), utils.JS.isFunction(i) && i();
            }.bind(this)
          );
      } else this.setVisibility(e), utils.JS.isFunction(i) && i();
      this._visible = e;
    }
  }),
  utils.JS.inherits(UTNavigationController, UTViewController),
  (UTNavigationController.prototype.init = function init() {
    if (!this.initialized) {
      this.superclass();
      var e = this.getRootController();
      e.initialized || e.init();
      var t = this.getPrimaryNavigationItem();
      t.init(),
        t.addTarget(this, this._eBackButtonTapped, enums.Event.TAP),
        this._navigationBar.init(),
        this._toolbar.init();
    }
  }),
  (UTNavigationController.prototype.initWithRootController = function initWithRootController(
    e
  ) {
    this.initialized ||
      (utils.Debug.Assert(
        e.conforms(UTViewController),
        'Initialization expected an instance of UTViewController.'
      ),
      (this._rootController = e),
      this.init(),
      this.addChildViewController(e));
  }),
  (UTNavigationController.prototype.dealloc = function dealloc() {
    this._navigationBar &&
      (this._navigationBar.dealloc(), (this._navigationBar = null)),
      this._toolbar && (this._toolbar.dealloc(), (this._toolbar = null)),
      this.getPrimaryNavigationItem().dealloc(),
      (this._rootController = null),
      (this._currentController = null),
      (this._currentView = null),
      this._childViewControllers.forEach(function(e) {
        e.dealloc();
      }),
      this.superclass();
  }),
  (UTNavigationController.prototype._getRootControllerInstance = function _getRootControllerInstance() {
    return new UTViewController();
  }),
  (UTNavigationController.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new views.NavigationContainer();
  }),
  (UTNavigationController.prototype.viewWillAppear = function viewWillAppear() {
    this.superclass(),
      this._currentController && this._currentController.viewWillAppear();
  }),
  (UTNavigationController.prototype.viewWillDisappear = function viewWillDisappear() {
    this.superclass(),
      this._currentController && this._currentController.viewWillDisappear();
  }),
  (UTNavigationController.prototype.viewDidAppear = function viewDidAppear() {
    this.superclass(),
      !this._currentController && this._rootController
        ? (this._showController(this._rootController, !0),
          this._navigationBar.setPrimaryButton(
            this.getRootPrimaryNavigationItem()
          ),
          this._navigationBar.layoutSubviews())
        : this._currentController && this._currentController.viewDidAppear();
  }),
  (UTNavigationController.prototype.viewDidDisappear = function viewDidDisappear() {
    this.superclass(),
      this._currentController && this._currentController.viewDidDisappear();
  }),
  (UTNavigationController.prototype.setNavigationTitle = function setNavigationTitle(
    e
  ) {
    this._navigationBar.setHeader(e);
  }),
  (UTNavigationController.prototype.setNavigationStyle = function setNavigationStyle(
    e
  ) {
    this._navigationBar.setStyle(e);
  }),
  (UTNavigationController.prototype.setNavigationVisibility = function setNavigationVisibility(
    e,
    t
  ) {
    if (((e = !!e), this.isNavVisible !== e)) {
      var i = this.getView();
      (this.isNavVisible = e),
        i.hasNavigationBar() || i.appendNavigationBar(this._navigationBar),
        this.isNavVisible ? i.showNavigationBar(t) : i.hideNavigationBar(t);
    }
  }),
  (UTNavigationController.prototype.setToolbarVisibility = function setToolbarVisibility(
    e,
    t
  ) {
    if (((e = !!e), this.isToolbarVisible !== e)) {
      var i = this.getView();
      (this.isToolbarVisible = e),
        i.hasToolbar() || i.appendToolbar(this._toolbar),
        this.isToolbarVisible ? i.showToolbar(t) : i.hideToolbar(t);
    }
  }),
  (UTNavigationController.prototype.getRootController = function getRootController() {
    return (
      this._rootController ||
        ((this._rootController = this._getRootControllerInstance()),
        this.addChildViewController(this._rootController)),
      this._rootController
    );
  }),
  (UTNavigationController.prototype.getPreviousController = function getPreviousController(
    e
  ) {
    return (
      (!utils.JS.isNumber(e) || e < 1) && (e = 1),
      this._childViewControllers[
        this._childViewControllers.indexOf(this._currentController) - e
      ] || null
    );
  }),
  (UTNavigationController.prototype.getCurrentController = function getCurrentController() {
    return this._currentController;
  }),
  (UTNavigationController.prototype.getCurrentView = function getCurrentView() {
    return this._currentView;
  }),
  (UTNavigationController.prototype.getToolbarItems = function getToolbarItems() {
    return [];
  }),
  (UTNavigationController.prototype.getPrimaryNavigationItem = function getPrimaryNavigationItem() {
    return this._backButton;
  }),
  (UTNavigationController.prototype.getRootPrimaryNavigationItem = function getRootPrimaryNavigationItem() {
    return null;
  }),
  (UTNavigationController.prototype.getSecondaryNavigationItem = function getSecondaryNavigationItem() {
    return this._currentController
      ? this._currentController.getNavigationItem()
      : null;
  }),
  (UTNavigationController.prototype._showController = function _showController(
    e,
    t
  ) {
    if (this._currentController !== e) {
      gClickShield.showShield(components.ClickShield.SHIELD.INTERACTION),
        this._navigationBar.setInteractionState(!1),
        this._toolbar.setInteractionState(!1);
      var i = this._currentController;
      if (
        ((this._currentController = e), (this._currentView = e.getView()), i)
      ) {
        i.viewWillDisappear();
        var s = i.getView();
        s && s.removeFromSuperview(t);
      }
      this._currentController.viewWillAppear(),
        this._navigationBar.setHeader(this.getNavigationTitle()),
        this._navigationBar.setSecondaryButton(
          this.getSecondaryNavigationItem()
        ),
        this._navigationBar.layoutSubviews(),
        this._toolbar.setButtons(this._currentController.getToolbarItems());
      var n = this.getView();
      this._currentView.getSuperview() !== n &&
        (this.willPush(this._currentController),
        n.setNavigationContext(this._currentView),
        this.didPush(this._currentController)),
        this._navigationBar.setInteractionState(!0),
        this._toolbar.setInteractionState(!0),
        i &&
          (i.viewDidDisappear(),
          this._childViewControllers.indexOf(i) < 0 && i.dealloc()),
        this._currentController.viewDidAppear(),
        setTimeout(
          function() {
            gClickShield.hideShield(components.ClickShield.SHIELD.INTERACTION);
          }.bind(this),
          300
        );
    }
  }),
  (UTNavigationController.prototype.pushViewController = function pushViewController(
    e,
    t
  ) {
    this._isTransitioning ||
      0 <= this._childViewControllers.indexOf(e) ||
      ((this._isTransitioning = !0),
      1 === this._childViewControllers.length &&
        (this._navigationBar.setPrimaryButton(this.getPrimaryNavigationItem()),
        this._navigationBar.layoutSubviews()),
      this.addChildViewController(e),
      this._showController(e, t),
      (this._isTransitioning = !1));
  }),
  (UTNavigationController.prototype.popViewController = function popViewController(
    e
  ) {
    if (this._isTransitioning) return null;
    var t = this._childViewControllers.length - 1,
      i = this._childViewControllers[t],
      s = this._childViewControllers[t - 1];
    return i && s
      ? ((this._isTransitioning = !0),
        this._showController(s, e),
        this.removeChildViewController(i),
        i.dealloc(),
        this._childViewControllers.length <= 1 &&
          (this._navigationBar.setPrimaryButton(
            this.getRootPrimaryNavigationItem()
          ),
          this._navigationBar.layoutSubviews()),
        (this._isTransitioning = !1),
        i)
      : (utils.Debug.Assert(
          !1,
          'Expected the stack to not be empty or at the root already'
        ),
        null);
  }),
  (UTNavigationController.prototype.popToViewController = function popToViewController(
    e,
    t
  ) {
    if (
      this._isTransitioning ||
      !this._currentController ||
      e === this._currentController
    )
      return null;
    var i = null;
    for (
      this._isTransitioning = !0;
      1 <= this._childViewControllers.length &&
      (i = this._childViewControllers[
        this._childViewControllers.length - 1
      ]) !== e;

    )
      (i._parentViewController = null),
        this._childViewControllers.pop(),
        i !== this._currentController && i.dealloc();
    return (
      utils.Debug.Assert(
        1 <= this._childViewControllers.length,
        'View controller not found in navigation stack; stack is now empty.'
      ),
      this._childViewControllers.length <= 1 &&
        this._navigationBar.setPrimaryButton(
          this.getRootPrimaryNavigationItem()
        ),
      this._showController(
        this._childViewControllers[this._childViewControllers.length - 1],
        t
      ),
      (this._isTransitioning = !1),
      i
    );
  }),
  (UTNavigationController.prototype.popToRootViewController = function popToRootViewController(
    e
  ) {
    return 0 < this._childViewControllers.length
      ? this.popToViewController(this._childViewControllers[0], e)
      : null;
  }),
  (UTNavigationController.prototype.getNavigationTitle = function getNavigationTitle() {
    return this._currentController
      ? this._currentController.getNavigationTitle()
      : this._rootController
      ? this._rootController.getNavigationTitle()
      : '';
  }),
  (UTNavigationController.prototype.willPush = function willPush(e) {}),
  (UTNavigationController.prototype.didPush = function didPush(e) {}),
  (UTNavigationController.prototype._eBackButtonTapped = function _eBackButtonTapped(
    e,
    t,
    i
  ) {
    this.popViewController(!0);
  }),
  utils.JS.inherits(UTKeyboardEventController, UTObject),
  (UTKeyboardEventController.PRIORITY = {
    POPUP: 0,
    ACTIVE_ELEMENT: 1,
    VIEW: 2
  }),
  (UTKeyboardEventController.prototype.init = function init() {
    this.superclass(),
      isWeb() &&
        (this._eventDelegates.set(UTKeyboardEventController.PRIORITY.POPUP, []),
        this._eventDelegates.set(
          UTKeyboardEventController.PRIORITY.ACTIVE_ELEMENT,
          []
        ),
        this._eventDelegates.set(UTKeyboardEventController.PRIORITY.VIEW, []),
        document.addEventListener(enums.Event.KEYUP, this._keyupHandler, !1));
  }),
  (UTKeyboardEventController.prototype.dealloc = function dealloc() {
    this.superclass(),
      isWeb() &&
        document.removeEventListener(enums.Event.KEYUP, this._keyupHandler, !1);
  }),
  (UTKeyboardEventController.prototype.registerDelegate = function registerDelegate(
    e,
    t
  ) {
    if (isWeb()) {
      var i = e.conforms(interfaces.KeyboardEventDelegate);
      if (
        (utils.Debug.Assert(
          i,
          'Expected an object that conforms to the KeyboardEventDelegate interface'
        ),
        i)
      ) {
        var s = this._eventDelegates.get(t);
        s && s.indexOf(e) < 0 && s.push(e);
      }
    }
  }),
  (UTKeyboardEventController.prototype.unregisterDelegate = function unregisterDelegate(
    e,
    t
  ) {
    if (isWeb()) {
      var i = this._eventDelegates.get(t);
      if (i) {
        var s = i.indexOf(e);
        0 <= s && i.splice(s, 1);
      }
    }
  }),
  (UTKeyboardEventController.prototype._eHandleKeyUpEvent = function _eHandleKeyUpEvent(
    t
  ) {
    var e = this._eventDelegates.get(UTKeyboardEventController.PRIORITY.POPUP),
      i = this._eventDelegates.get(
        UTKeyboardEventController.PRIORITY.ACTIVE_ELEMENT
      ),
      s = this._eventDelegates.get(UTKeyboardEventController.PRIORITY.VIEW);
    e && 0 < e.length
      ? e.forEach(function(e) {
          e.handleKeyUpEvent(t);
        })
      : i && 0 < i.length
      ? i.forEach(function(e) {
          e.handleKeyUpEvent(t);
        })
      : s &&
        0 < s.length &&
        s.forEach(function(e) {
          e.handleKeyUpEvent(t);
        });
  }),
  utils.JS.inherits(UTRootPresentationController, UTPresentationController),
  (UTRootPresentationController.prototype._presentInContainerContext = function _presentInContainerContext() {
    var e = this._presentedViewController.getView(),
      t = e.getRootElement();
    (t.style.width = '100%'),
      (t.style.height = '100%'),
      this._insertView(e, this._presentingViewController.getView());
  }),
  utils.JS.inherits(UTTabBarItemNotificationView, UTView),
  (UTTabBarItemNotificationView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('ut-tab-bar-item-notif'),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTTabBarItemNotificationView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTTabBarItemNotificationView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTTabBarItemNotificationView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTTabBarItemNotificationView.prototype.setNumber = function setNumber(e) {
    var t = utils.JS.isValid(e) && 0 < e;
    this.getRootElement().textContent = t
      ? services.Localization.localizeNumber(e)
      : '';
  }),
  utils.JS.inherits(UTTabBarItemView, UTButtonControl),
  (UTTabBarItemView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('button');
      e.classList.add('ut-tab-bar-item'),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTTabBarItemView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTTabBarItemView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTTabBarItemView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTTabBarItemView.prototype.dealloc = function dealloc() {
    this.removeNotificationBubble(), this.superclass();
  }),
  (UTTabBarItemView.prototype.setTag = function setTag(e) {
    this._tag = e;
  }),
  (UTTabBarItemView.prototype.getTag = function getTag() {
    return this._tag;
  }),
  (UTTabBarItemView.prototype.removeNotificationBubble = function removeNotificationBubble() {
    utils.JS.isValid(this._notifBubble) &&
      (this._notifBubble.dealloc(), (this._notifBubble = null));
  }),
  (UTTabBarItemView.prototype.addNotificationBubble = function addNotificationBubble() {
    utils.JS.isValid(this._notifBubble) ||
      ((this._notifBubble = new UTTabBarItemNotificationView()),
      this.addSubview(this._notifBubble),
      this.layoutSubviews());
  }),
  utils.JS.inherits(UTTabBarView, UTTargetActionView),
  (UTTabBarView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('section');
      e.classList.add('ut-tab-bar-view'),
        (this.__navTabBar = document.createElement('nav')),
        this.__navTabBar.classList.add('ut-tab-bar'),
        e.appendChild(this.__navTabBar),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTTabBarView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__navTabBar = null);
  }),
  (UTTabBarView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTTabBarView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTTabBarView.Event = {
    TAB_SELECTED: 'UTTabBarView.Event.TAB_SELECTED'
  }),
  (UTTabBarView.prototype.dealloc = function dealloc() {
    this.superclass(),
      this._tabItems.forEach(function(e) {
        e.removeTarget(this, this._eTabSelected, enums.Event.TAP);
      }, this);
  }),
  (UTTabBarView.prototype.layoutSubviews = function layoutSubviews() {
    this._subviews.forEach(function(e) {
      var t = e.view.getRootElement();
      e.container === this.getRootElement()
        ? e.container.insertBefore(t, this.__navTabBar)
        : e.container.appendChild(t);
    }, this);
  }),
  (UTTabBarView.prototype.setTabItems = function setTabItems(e) {
    this._tabItems.forEach(function(e) {
      e.removeFromSuperview();
    }, this),
      (this._tabItems = e.slice()),
      this._tabItems.forEach(function(e) {
        e.addTarget(this, this._eTabSelected, enums.Event.TAP),
          this.addSubview(e, this.__navTabBar);
      }, this);
  }),
  (UTTabBarView.prototype.setSelectedIndex = function setSelectedIndex(i) {
    this._tabItems[i] &&
      this._tabItems.forEach(function(e, t) {
        e.toggleClass(enums.UIState.SELECTED, t === i);
      });
  }),
  (UTTabBarView.prototype.toggleItemNotification = function toggleItemNotification(
    e,
    t
  ) {
    var i = this._tabItems[e];
    i && (t ? i.addNotificationBubble() : i.removeNotificationBubble());
  }),
  (UTTabBarView.prototype._eTabSelected = function _eTabSelected(e, t, i) {
    if (this.isInteractionEnabled()) {
      var s = this._tabItems.indexOf(e);
      this._triggerActions(UTTabBarView.Event.TAB_SELECTED, {
        index: s,
        tag: e.getTag()
      });
    }
  }),
  utils.JS.inherits(UTTabBarController, UTViewController),
  (UTTabBarController.prototype.initWithViewControllers = function initWithViewControllers(
    e
  ) {
    if (!this.initialized) {
      var t = [];
      e.forEach(function(e) {
        this.addChildViewController(e),
          e.tabBarItem ||
            ((e.tabBarItem = new UTTabBarItemView()),
            e.tabBarItem.init(),
            e.tabBarItem.setText(e.getNavigationTitle())),
          t.push(e.tabBarItem);
      }, this);
      var i = this.getView();
      i.setTabItems(t),
        i.addTarget(this, this._eTabSelected, UTTabBarView.Event.TAB_SELECTED),
        this.init();
    }
  }),
  (UTTabBarController.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new UTTabBarView();
  }),
  (UTTabBarController.prototype.viewDidAppear = function viewDidAppear() {
    this.superclass(),
      !this._currentController &&
        0 < this._childViewControllers.length &&
        (this._showController(this._childViewControllers[0]),
        this.getView().setSelectedIndex(0));
  }),
  (UTTabBarController.prototype.getCurrentViewController = function getCurrentViewController() {
    return this._currentController;
  }),
  (UTTabBarController.prototype.setSelectedIndex = function setSelectedIndex(
    e
  ) {
    var t = this._childViewControllers[e];
    t instanceof UTViewController &&
      (this.getView().setSelectedIndex(e), this._showController(t));
  }),
  (UTTabBarController.prototype._getIndexOfTabBarItemByTag = function _getIndexOfTabBarItemByTag(
    e
  ) {
    var t,
      i = -1,
      s = this._childViewControllers.length;
    for (t = 0; t < s; t++) {
      var n = this._childViewControllers[t].tabBarItem;
      if (n && n.getTag() === e) {
        i = t;
        break;
      }
    }
    return i;
  }),
  (UTTabBarController.prototype.setSelectedIndexByTag = function setSelectedIndexByTag(
    e
  ) {
    var t = this._getIndexOfTabBarItemByTag(e);
    0 <= t && this.setSelectedIndex(t);
  }),
  (UTTabBarController.prototype._showController = function _showController(
    e,
    t
  ) {
    if (this._currentController !== e) {
      var i = this.getView();
      gClickShield.showShield(components.ClickShield.SHIELD.INTERACTION),
        i.setInteractionState(!1);
      var s = this._currentController;
      if (
        ((this._currentController = e), (this._currentView = e.getView()), s)
      ) {
        s.viewWillDisappear();
        var n = s.getView();
        n && n.removeFromSuperview(t);
      }
      this._currentController.viewWillAppear(),
        this._currentView.getSuperview() !== i &&
          (i.addSubview(this._currentView), i.layoutSubviews()),
        i.setInteractionState(!0),
        s && s.viewDidDisappear(),
        this._currentController.viewDidAppear(),
        setTimeout(function() {
          gClickShield.hideShield(components.ClickShield.SHIELD.INTERACTION);
        }, 300);
    }
  }),
  (UTTabBarController.prototype._eTabSelected = function _eTabSelected(
    e,
    t,
    i
  ) {
    var s = (i && i.index) || 0,
      n = this._childViewControllers[s];
    n instanceof UTViewController &&
      (this.getView().setSelectedIndex(s), this._showController(n));
  }),
  utils.JS.inherits(UTGameTabBarController, UTTabBarController),
  (UTGameTabBarController.TabTag = {
    HOME: 0,
    SQUADS: 1,
    SBC: 2,
    TRANSFERS: 3,
    STORE: 4,
    CLUB: 5,
    SETTINGS: 6,
    LEADERBOARDS: 7
  }),
  (UTGameTabBarController.prototype.viewDidAppear = function viewDidAppear() {
    this.superclass(),
      this._toggleStoreNotificationBubble(
        0 < services.User.getUser().getNumUnopenedPacks()
      ),
      getDefaultDispatcher().addObserver(
        enums.Notification.STORE_PACK_COUNT_CHANGE,
        this,
        this._nStorePackChange
      );
  }),
  (UTGameTabBarController.prototype.viewWillDisappear = function viewWillDisappear() {
    this.superclass(),
      getDefaultDispatcher().removeObserver(
        enums.Notification.STORE_PACK_COUNT_CHANGE,
        this
      );
  }),
  (UTGameTabBarController.prototype._toggleStoreNotificationBubble = function _toggleStoreNotificationBubble(
    e
  ) {
    var t = this._getIndexOfTabBarItemByTag(
      UTGameTabBarController.TabTag.STORE
    );
    0 <= t && this.getView().toggleItemNotification(t, e);
  }),
  (UTGameTabBarController.prototype._eTabSelected = function _eTabSelected(
    e,
    t,
    i
  ) {
    i.tag !== UTGameTabBarController.TabTag.LEADERBOARDS ||
    services.Configuration.checkFeatureEnabled(
      enums.ServerFeature.LEADERBOARDS_ENABLED
    )
      ? (this.superclass(e, t, i),
        this._currentController instanceof UTNavigationController &&
          this._currentController.popToRootViewController())
      : services.Notification.queue([
          services.Localization.localize('popup.error.LeaderboardsDown'),
          enums.UINotificationType.NEGATIVE
        ]);
  }),
  (UTGameTabBarController.prototype._nStorePackChange = function _nStorePackChange(
    e,
    t,
    i
  ) {
    this._toggleStoreNotificationBubble(0 < i.unopenedPacks);
  }),
  NamespaceManager.Register('interfaces'),
  (interfaces.ListDataComponent = function() {}),
  (interfaces.ListDataComponent.prototype.render = function(e) {}),
  (interfaces.ListDataComponent.prototype.update = function(e) {}),
  NamespaceManager.Register('interfaces'),
  (interfaces.ListRow = function() {}),
  (interfaces.ListRow.prototype.setData = function(e) {}),
  (interfaces.ListRow.prototype.getData = function() {}),
  (interfaces.ListRow.prototype.render = function() {}),
  (interfaces.ListRow.prototype.setDataComponent = function(e) {}),
  (interfaces.ListRow.prototype.setAction = function(e, t) {}),
  (interfaces.ListRow.prototype.setTapCallback = function(e) {}),
  NamespaceManager.Register('components'),
  (components.ListRowPersona = function() {
    UTTargetActionView.call(this),
      (this._data = {
        persona: null,
        club: null
      }),
      (this._tapCallback = null),
      this._generate();
  }),
  utils.JS.inherits(components.ListRowPersona, UTTargetActionView),
  (components.ListRowPersona.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('button');
      e.classList.add('ut-persona-selector-item'),
        e.classList.add('ut-group-button');
      var t = document.createElement('div');
      t.classList.add('ut-persona-selector-item-details'),
        (this.__personaIcon = document.createElement('div')),
        this.__personaIcon.classList.add('btn-icon'),
        t.appendChild(this.__personaIcon),
        (this.__personaName = document.createElement('span')),
        this.__personaName.classList.add('btn-text'),
        t.appendChild(this.__personaName),
        (this.__clubName = document.createElement('span')),
        this.__clubName.classList.add('btn-subtext'),
        t.appendChild(this.__clubName),
        e.appendChild(t),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ListRowPersona.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__personaIcon = null),
      (this.__personaName = null),
      (this.__clubName = null);
  }),
  (components.ListRowPersona.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ListRowPersona.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ListRowPersona.prototype.dealloc = function dealloc() {
    (this._data = null), (this._tapCallback = null), this.superclass();
  }),
  (components.ListRowPersona.prototype.setData = function(e) {
    this._data = e;
  });

function UTListDataPlayerStatsView() {
  UTView.call(this),
    (this.slotData = null),
    (this.comparisonData = null),
    (this._zoneClasses = [
      {
        zone: enums.PlayerZone.ATTACKERS,
        zoneClass: 'zone-att'
      },
      {
        zone: enums.PlayerZone.DEFENDERS,
        zoneClass: 'zone-def'
      },
      {
        zone: enums.PlayerZone.MIDFIELDERS,
        zoneClass: 'zone-mid'
      },
      {
        zone: enums.PlayerZone.GOALKEEPERS,
        zoneClass: 'zone-gk'
      }
    ]);
}

function UTListDataFitnessView() {
  UTView.call(this), (this._comparisonData = null);
}

function UTListActiveTagView() {
  UTView.call(this),
    (this._string = ''),
    (this._iconClass = ''),
    this._generate();
}

function UTToggleControl() {
  UTControl.call(this),
    (this._toggled = !1),
    Object.defineProperty(this, '_toggled', {
      writable: !0,
      enumerable: !1
    });
}

function UTToggleCellView() {
  UTTargetActionView.call(this);
}

function UTToggleControlGroupView() {
  UTTargetActionView.call(this), (this._toggles = new UTHashTable());
}

function UTMyClubSearchFiltersViewController() {
  UTViewController.call(this),
    (this._searchViewmodel = new viewmodels.ItemSearch()),
    (this._clubViewmodel = null),
    (this._searchCriteria = null),
    (this._consumable = null);
}

function UTListNoResultsView() {
  UTView.call(this);
}

function UTSplitView() {
  UTView.call(this),
    (this._lView = null),
    Object.defineProperty(this, '_lView', {
      enumerable: !1,
      writable: !0
    }),
    (this._rView = null),
    Object.defineProperty(this, '_rView', {
      enumerable: !1,
      writable: !0
    });
}

function UTSplitViewController() {
  UTViewController.call(this),
    (this._leftController = null),
    Object.defineProperty(this, '_leftController', {
      enumerable: !1,
      writable: !0
    }),
    (this._rightController = null),
    Object.defineProperty(this, '_rightController', {
      enumerable: !1,
      writable: !0
    }),
    (this._layout = UTSplitViewController.Layout.SIDEBAR_RIGHT),
    Object.defineProperty(this, '_layout', {
      enumerable: !1,
      writable: !0
    });
}

function UTPseudoTableView() {
  UTView.call(this), (this._rowGroups = []);
}

function UTProgressBarView() {
  UTView.call(this),
    (this._progress = 0),
    Object.defineProperty(this, '_progress', {
      writable: !0,
      enumerable: !1
    });
}

function UTCompareActionPanelViewController() {
  UTViewController.call(this),
    (this._btnSwap = null),
    (this.onSwap = new UTObservable());
}

function UTPlayerBioView() {
  UTView.call(this),
    (this._tables = []),
    (this._headers = []),
    (this._pinnedRow = null);
}

function UTPlayerBioViewController() {
  UTViewController.call(this),
    (this._pinnedItem = null),
    (this._viewModel = new viewmodels.ItemList([])),
    (this._pinnedItemController = new controllers.views.PinnedListItem());
}

function UTPackGraphicView() {
  UTView.call(this);
}

function TNSPropertiesDTO() {
  (this.nav = !1),
    (this.controls = !0),
    (this.loop = !1),
    (this.textDirection = services.Localization.isRTL() ? 'rtl' : 'ltr'),
    (this.touch = !0),
    (this.mouseDrag = !0),
    (this.startIndex = 0),
    (this.speed = 300),
    (this.autoplay = !1),
    (this.autoplaySpeed = 5e3),
    (this.prevButton = !1),
    (this.nextButton = !1),
    (this.controlsText = ['', '']),
    (this.autoplayText = ['', '']),
    (this.items = 1),
    (this.navPosition = 'bottom'),
    (this.container = '.slider'),
    (this.preventActionWhenRunning = !1);
}

function TNSContainerView() {
  UTView.call(this),
    (this.properties = null),
    Object.defineProperty(this, 'properties', {
      writable: !0
    }),
    (this.slider = null),
    Object.defineProperty(this, 'slider', {
      writable: !0
    }),
    (this._eventHandler = this._handleSliderEvent.bind(this)),
    Object.defineProperty(this, '_eventHandler', {
      enumerable: !1,
      writable: !1
    }),
    (this._afterChangeCallback = null),
    Object.defineProperty(this, '_afterChangeCallback', {
      enumerable: !1,
      writable: !0
    });
}

function UTRewardsCarouselView() {
  UTView.call(this),
    (this._mobileTitle = ''),
    (this._visibleItems = 1),
    (this._numOfRewards = 0),
    (this._playerItems = []),
    (this._packs = []),
    (this._afterChangeFn = null);
}

function UTPlayerPickRewardsController(e) {
  controllers.views.popups.InGameRewards.call(this),
    (this._rewards = [
      new transferobjects.Reward(
        {
          count: 1
        },
        e
      )
    ]);
}

function UTPlayerPickOptionView() {
  UTTargetActionView.call(this), (this._itemView = null), this._generate();
}

function UTPlayerPicksView() {
  UTTargetActionView.call(this),
    (this._playerPickViews = []),
    (this._phoneLargeItem = null),
    this._generate();
}

function UTPlayerPicksViewController() {
  UTViewController.call(this),
    (this._index = 0),
    (this._picks = []),
    (this._ownership = []),
    (this._isPendingSelection = !1),
    (this._itemInfoStateViewModel = new UTItemInfoStateViewModel(
      gUserSettingsModel
    ));
}

function UTEmptySectionMessageView() {
  UTView.call(this);
}

function UTSectionedSlotList() {
  views.lists.SectionedItemList.call(this), this._generate();
}
(components.ListRowPersona.prototype.getData = function() {
  return this._data;
}),
  (components.ListRowPersona.prototype.render = function() {
    var e = '';
    switch (this._data.club.platform) {
      case enums.Platform.XBO:
        e = enums.UIPlatform.XBO;
        break;
      case enums.Platform.XBX:
        e = enums.UIPlatform.XBX;
        break;
      case enums.Platform.PS4:
        e = enums.UIPlatform.PS4;
        break;
      case enums.Platform.PS3:
        e = enums.UIPlatform.PS3;
        break;
      case enums.Platform.PC:
        e = enums.UIPlatform.PC;
        break;
      case enums.Platform.SWI:
        e = enums.UIPlatform.SWI;
        break;
      default:
        utils.Debug.Assert(
          !1,
          '[components.ListRowPersona] Unrecognized gameSku.'
        );
    }
    (this.__clubName.textContent = this._data.club.name),
      (this.__personaName.textContent = this._data.persona.name),
      this.addClass(e);
  }),
  (components.ListRowPersona.prototype.setDataComponent = function(e) {}),
  (components.ListRowPersona.prototype.setAction = function(e, t) {}),
  (components.ListRowPersona.prototype.setTapCallback = function setTapCallback(
    e
  ) {
    (this._tapCallback = e), this.addClass(enums.UIRowActionClass.MORE);
  }),
  (components.ListRowPersona.prototype._touchStarted = function _touchStarted(
    e
  ) {
    this.superclass(), this.addClass(enums.UIState.ACTIVE);
  }),
  (components.ListRowPersona.prototype._touchMoved = function _touchMoved(e) {
    this.superclass(), this.removeClass(enums.UIState.ACTIVE);
  }),
  (components.ListRowPersona.prototype._touchEnded = function _touchEnded(e) {
    this.superclass(), this.removeClass(enums.UIState.ACTIVE);
  }),
  (components.ListRowPersona.prototype._tapDetected = function _tapDetected(e) {
    this.superclass(),
      utils.JS.isFunction(this._tapCallback) && this._tapCallback(this._data);
  }),
  utils.JS.inherits(UTPersonaSelectorView, UTTargetActionView),
  (UTPersonaSelectorView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('ut-persona-selector'),
        e.classList.add('ut-content-container');
      var t = document.createElement('div');
      t.classList.add('ut-content');
      var i = document.createElement('section'),
        s = document.createElement('header');
      (this.__currentPersonaTitle = document.createElement('h1')),
        s.appendChild(this.__currentPersonaTitle),
        i.appendChild(s);
      var n = document.createElement('div');
      n.classList.add('ut-button-group'),
        (this._selectedPersona = new components.ListRowPersona()),
        n.appendChild(this._selectedPersona.getRootElement()),
        (this.__helpText = document.createElement('p')),
        n.appendChild(this.__helpText),
        i.appendChild(n),
        t.appendChild(i);
      var o = document.createElement('section'),
        a = document.createElement('header');
      (this.__changePersonaTitle = document.createElement('h1')),
        a.appendChild(this.__changePersonaTitle),
        o.appendChild(a),
        (this.__personaList = document.createElement('div')),
        this.__personaList.classList.add('ut-button-group'),
        o.appendChild(this.__personaList),
        t.appendChild(o),
        e.appendChild(t),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTPersonaSelectorView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__currentPersonaTitle = null),
      this._selectedPersona.destroy(),
      (this.__helpText = null),
      (this.__changePersonaTitle = null),
      (this.__personaList = null);
  }),
  (UTPersonaSelectorView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTPersonaSelectorView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTPersonaSelectorView.prototype.init = function init() {
    this.superclass(),
      (this.__currentPersonaTitle.textContent = services.Localization.localize(
        'title.selectedpersona'
      )),
      (this.__changePersonaTitle.textContent = services.Localization.localize(
        'title.personaselector'
      )),
      (this.__helpText.textContent = services.Localization.localize(
        'persona.helptext'
      ));
  }),
  (UTPersonaSelectorView.prototype.dealloc = function dealloc() {
    this._clearPersonaRows(), this.superclass();
  }),
  (UTPersonaSelectorView.prototype._clearPersonaRows = function _clearPersonaRows() {
    this._personaRows.forEach(function(e) {
      e.destroy();
    }),
      (this._personaRows = []);
  }),
  (UTPersonaSelectorView.prototype.setSelectedPersona = function setSelectedPersona(
    e
  ) {
    this._selectedPersona.setData({
      persona: e,
      club: e.getCurrentClub()
    }),
      this._selectedPersona.render();
  }),
  (UTPersonaSelectorView.prototype.setSelectablePersonas = function setSelectablePersonas(
    e
  ) {
    this._clearPersonaRows(),
      DOMKit.empty(this.__personaList),
      e.forEach(function(i) {
        i.getValidClubs().forEach(function(e) {
          var t = new components.ListRowPersona();
          t.setData({
            persona: i,
            club: e
          }),
            t.render(),
            t.setTapCallback(this._onPersonaSelect.bind(this)),
            t.setInteractionState(!0),
            this._personaRows.push(t),
            this.__personaList.appendChild(t.getRootElement());
        }, this);
      }, this);
  }),
  (UTPersonaSelectorView.prototype._onPersonaSelect = function _onPersonaSelect(
    e
  ) {
    TelemetryManager.trackEvent(
      TelemetryManager.Sections.MISC,
      TelemetryManager.Categories.BUTTON_PRESS,
      'Change Persona'
    ),
      this._triggerActions(enums.Event.TAP, e);
  }),
  utils.JS.inherits(UTPersonaSelectorViewController, UTViewController),
  (UTPersonaSelectorViewController.prototype.init = function init() {
    this.superclass(),
      this.getView().addTarget(this, this._ePersonaSelected, enums.Event.TAP);
  }),
  (UTPersonaSelectorViewController.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new UTPersonaSelectorView();
  }),
  (UTPersonaSelectorViewController.prototype._getTelemetryId = function _getTelemetryId() {
    return 'Settings - Persona Selector';
  }),
  (UTPersonaSelectorViewController.prototype.getNavigationTitle = function getNavigationTitle() {
    return services.Localization.localize('navbar.label.personaselector');
  }),
  (UTPersonaSelectorViewController.prototype.viewDidAppear = function viewDidAppear() {
    this.superclass(),
      TelemetryManager.trackPage(
        TelemetryManager.Sections.HOME,
        'Persona Selector'
      );
    var e = this.getView(),
      t = services.User.getUser();
    e.setSelectedPersona(t.getSelectedPersona()),
      e.setSelectablePersonas(t.getPersonas(!0));
  }),
  (UTPersonaSelectorViewController.prototype._changePersona = function _changePersona(
    e,
    t
  ) {
    hasConnection()
      ? ((e.sku = t),
        getAppMain()
          .getLoginController()
          .switchPersona(e))
      : (utils.PopupManager.showNoInternetConnectionPopup(),
        this.getView().setInteractionState(!0));
  }),
  (UTPersonaSelectorViewController.prototype._ePersonaSelected = function _ePersonaSelected(
    e,
    t,
    i
  ) {
    var s = this.getView();
    s.setInteractionState(!1),
      utils.PopupManager.ShowConfirmation(
        utils.PopupManager.Confirmations.CHANGE_PERSONA,
        null,
        this._changePersona.bind(this, i.persona, i.club.sku),
        function() {
          s.setInteractionState(!0);
        }.bind(this)
      );
  }),
  utils.JS.inherits(UTFlatButtonControl, UTButtonControl),
  (UTFlatButtonControl.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('button');
      e.classList.add('flat'), (this.__root = e), (this._generated = !0);
    }
  }),
  (UTFlatButtonControl.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTFlatButtonControl.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTFlatButtonControl.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  NamespaceManager.Register('transferobjects'),
  (transferobjects.PersonaClub = function UTPersonaClubDTO(e) {
    (this.abbr = e.clubAbbr),
      Object.defineProperty(this, 'abbr', {
        writable: !1,
        enumerable: !0
      }),
      (this.name = e.clubName),
      Object.defineProperty(this, 'name', {
        writable: !1,
        enumerable: !0
      }),
      (this.established = e.established),
      Object.defineProperty(this, 'established', {
        writable: !1,
        enumerable: !0
      }),
      (this.lastAccessTime = e.lastAccessTime),
      Object.defineProperty(this, 'lastAccessTime', {
        writable: !1,
        enumerable: !0
      }),
      (this.assetId = e.assetId),
      Object.defineProperty(this, 'assetId', {
        writable: !0,
        enumerable: !0
      }),
      (this.sku = e.sku),
      Object.defineProperty(this, 'sku', {
        writable: !1,
        enumerable: !0
      }),
      (this.platform = utils.FUTData.mapSkuToPlatform(this.sku)),
      Object.defineProperty(this, 'platform', {
        writable: !1,
        enumerable: !0
      }),
      (this.year = e.year),
      Object.defineProperty(this, 'year', {
        writable: !1,
        enumerable: !0
      }),
      (this.isXbox =
        this.platform === enums.Platform.XBX ||
        this.platform === enums.Platform.XBO),
      Object.defineProperty(this, 'isXbox', {
        writable: !1,
        enumerable: !0
      }),
      (this.isPlaystation =
        this.platform === enums.Platform.PS3 ||
        this.platform === enums.Platform.PS4),
      Object.defineProperty(this, 'isPlaystation', {
        writable: !1,
        enumerable: !0
      }),
      (this.isPC = this.platform === enums.Platform.PC),
      Object.defineProperty(this, 'isPC', {
        writable: !1,
        enumerable: !0
      }),
      (this.isSwitch = this.platform === enums.Platform.SWI),
      Object.defineProperty(this, 'isSwitch', {
        writable: !1,
        enumerable: !0
      }),
      (this.isGen3 =
        this.platform === enums.Platform.PS3 ||
        this.platform === enums.Platform.XBX),
      Object.defineProperty(this, 'isGen3', {
        writable: !1,
        enumerable: !0
      });
  }),
  (transferobjects.PersonaClub.prototype.setAssetId = function setAssetId(e) {
    this.assetId = e;
  }),
  NamespaceManager.Register('entities'),
  (entities.Persona = function UTPersonaEntity(e) {
    var t;
    Object.defineProperty(this, 'sku', {
      get: function() {
        return t;
      },
      set: function(e) {
        this.clubs.has(e) && (t = e);
      }
    }),
      (this.id = e.personaId),
      Object.defineProperty(this, 'id', {
        writable: !1
      }),
      (this.name = e.personaName),
      Object.defineProperty(this, 'name', {
        writable: !1
      }),
      (this.isReturningUser = 1 === e.returningUser),
      Object.defineProperty(this, 'isReturningUser', {
        writable: !1
      }),
      (this.isFreeTrial = e.trialFree),
      Object.defineProperty(this, 'isFreeTrial', {
        writable: !1
      }),
      (this.isAccessTrial = e.trial),
      Object.defineProperty(this, 'isAccessTrial', {
        writable: !1
      }),
      (this.state = e.userState || enums.UserState.NONE),
      Object.defineProperty(this, 'state', {
        writable: !1
      }),
      (this.clubs = new UTHashTable()),
      (this.sku = enums.SKU.NONE);
    var r = 0;
    e.userClubList.forEach(function(e) {
      var t = parseInt(APP_YEAR, 10),
        i = t - 1,
        s = parseInt(e.year, 10);
      if ((s === t || s === i) && (this.isReturningUser || s !== i)) {
        var n = enums.SKU.NONE;
        if (utils.JS.isValid(e.skuAccessList)) {
          var o;
          for (o in e.skuAccessList)
            if (
              e.skuAccessList.hasOwnProperty(o) &&
              e.skuAccessList[o] === e.lastAccessTime
            ) {
              n = o;
              break;
            }
          var a = new transferobjects.PersonaClub({
            clubAbbr: e.clubAbbr,
            clubName: e.clubName,
            established: e.established,
            lastAccessTime: e.lastAccessTime,
            assetId: e.assetId,
            platform: e.platform,
            sku: n,
            year: e.year
          });
          this.clubs.set(a.sku, a),
            a.lastAccessTime > r &&
              ((r = a.lastAccessTime), (this.sku = a.sku));
        }
      }
    }, this),
      utils.Debug.Assert(
        this.sku !== enums.SKU.NONE,
        'this account has no sku'
      ),
      (this.hasFUT = 0 < this.clubs.length),
      Object.defineProperty(this, 'hasFUT', {
        writable: !1
      }),
      (this.hasClubForCurrentYear = !1),
      Object.defineProperty(this, 'hasClubForCurrentYear', {
        get: function() {
          return utils.JS.isValid(
            this.clubs.find(function(e) {
              return e.year === APP_YEAR.toString();
            })
          );
        }
      }),
      (this.hasFullAccess =
        !this.isAccessTrial && !this.isFreeTrial && this.hasClubForCurrentYear),
      Object.defineProperty(this, 'hasFullAccess', {
        writable: !1
      }),
      (this.hasOriginAccess = !1),
      Object.defineProperty(this, 'hasOriginAccess', {
        writable: !0
      }),
      (this.isEligibleForMobileStart = !1),
      Object.defineProperty(this, 'isEligibleForMobileStart', {
        get: function() {
          return (
            !!this.isReturningUser &&
            (!this.hasClubForCurrentYear ||
              ((this.sku === enums.SKU.PREV_XBO &&
                !this.clubs.has(enums.SKU.XBO)) ||
                (this.sku === enums.SKU.PREV_PS4 &&
                  !this.clubs.has(enums.SKU.PS4)) ||
                (this.sku === enums.SKU.PREV_PC &&
                  !this.clubs.has(enums.SKU.PC))))
          );
        }
      }),
      (this.platform = enums.Platform.NONE),
      Object.defineProperty(this, 'platform', {
        get: function() {
          return this.clubs.has(this.sku)
            ? this.clubs.get(this.sku).platform
            : enums.Platform.NONE;
        }
      }),
      (this.isXbox = !1),
      Object.defineProperty(this, 'isXbox', {
        get: function() {
          return !!this.clubs.has(this.sku) && this.clubs.get(this.sku).isXbox;
        }
      }),
      (this.isPlaystation = !1),
      Object.defineProperty(this, 'isPlaystation', {
        get: function() {
          return (
            !!this.clubs.has(this.sku) && this.clubs.get(this.sku).isPlaystation
          );
        }
      }),
      (this.isPC = !1),
      Object.defineProperty(this, 'isPC', {
        get: function() {
          return !!this.clubs.has(this.sku) && this.clubs.get(this.sku).isPC;
        }
      }),
      (this.isSwitch = !1),
      Object.defineProperty(this, 'isSwitch', {
        get: function() {
          return (
            !!this.clubs.has(this.sku) && this.clubs.get(this.sku).isSwitch
          );
        }
      }),
      (this.isGen3 = !1),
      Object.defineProperty(this, 'isGen3', {
        get: function() {
          return !!this.clubs.has(this.sku) && this.clubs.get(this.sku).isGen3;
        }
      }),
      (this.lastAccessTime = 0),
      Object.defineProperty(this, 'lastAccessTime', {
        get: function() {
          return this.clubs.has(this.sku)
            ? this.clubs.get(this.sku).lastAccessTime
            : 0;
        }
      }),
      (this._loyaltyRewards = []),
      Object.defineProperty(this, '_loyaltyRewards', {
        writable: !0
      });
  }),
  (entities.Persona.prototype.getValidClubs = function getValidClubs() {
    return this.clubs.filter(function _checkValidClub(e) {
      var t = parseInt(APP_YEAR, 10),
        i = t - 1,
        s = parseInt(e.year, 10),
        n =
          !this.hasClubForCurrentYear &&
          this.isReturningUser &&
          this.state !== enums.UserState.RETURNING_USER_EXPIRED &&
          s === i;
      return s === t || n;
    }, this);
  }),
  (entities.Persona.prototype.getCurrentClub = function getCurrentClub() {
    return this.clubs.get(this.sku);
  }),
  (entities.Persona.prototype.createClub = function createClub(e, t, i) {
    var u = new UTObservable();
    if (
      this.hasClubForCurrentYear ||
      !this.isReturningUser ||
      this.state === enums.UserState.RETURNING_USER_EXPIRED
    )
      return (
        u.notify({
          success: !1,
          status: enums.HTTPStatusCode.FORBIDDEN,
          data: null
        }),
        u
      );
    return (
      accessobjects.Onboarding.createClub(e, t, i).observe(
        this,
        function _onCreateClubComplete(e, t) {
          if ((e.unobserve(this), t.success)) {
            var i = t.response,
              s = utils.FUTData.mapSkuToCurrentYear(this.sku),
              n = utils.JS.find(i.login.actives, function(e) {
                return e.header && 'Badge' === e.header;
              }),
              o = utils.JS.isValid(n) ? n.assetId : -1,
              a = new transferobjects.PersonaClub({
                clubAbbr: i.login.clubAbbr,
                clubName: i.login.clubName,
                established: parseInt(i.login.established, 10),
                lastAccessTime: parseInt(i.login.established, 10),
                assetId: o,
                platform: this.platform,
                sku: s,
                year: APP_YEAR.toString()
              });
            this.clubs.set(a.sku, a), (this.sku = a.sku);
            var r = i.starterPack.map(function(e) {
                return factories.Item.createItem(e);
              }),
              l = null,
              c = r.filter(function(e) {
                return e.isPlayer();
              });
            0 < c.length
              ? c.forEach(function(e) {
                  (!utils.JS.isValid(l) || l.rating < e.rating) && (l = e);
                })
              : r.forEach(function(e) {
                  (!utils.JS.isValid(l) || l.discardValue < e.discardValue) &&
                    (l = e);
                }),
              u.notify({
                success: !0,
                status: t.status,
                data: {
                  items: r,
                  highestRated: l
                }
              });
          } else
            u.notify({
              success: !1,
              status: t.status,
              data: null
            });
        }
      ),
      u
    );
  }),
  (entities.Persona.prototype.setLoyaltyRewards = function setLoyaltyRewards(
    e
  ) {
    this._loyaltyRewards = e;
  }),
  (entities.Persona.prototype.getLoyaltyRewards = function getLoyaltyRewards() {
    return this._loyaltyRewards;
  }),
  NamespaceManager.Register('views'),
  (views.Persona = function PersonaView() {
    UTView.call(this),
      (this._currentPlatform = enums.UIPlatform.NONE),
      this._generate();
  }),
  utils.JS.inherits(views.Persona, UTView),
  (views.Persona.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('persona'),
        (this.__userInfo = document.createElement('div')),
        this.__userInfo.classList.add('user-info'),
        (this._imgBadge = new UTImageView()),
        this.__userInfo.appendChild(this._imgBadge.getRootElement());
      var t = document.createElement('div');
      t.classList.add('user-data-container'),
        (this.__userName = document.createElement('h1')),
        t.appendChild(this.__userName),
        (this.__established = document.createElement('h2')),
        t.appendChild(this.__established),
        this.__userInfo.appendChild(t),
        e.appendChild(this.__userInfo),
        (this.__platform = document.createElement('div')),
        this.__platform.classList.add('platform'),
        (this._actionBtn = new UTFlatButtonControl()),
        this._actionBtn.getRootElement().classList.add('alt'),
        this.__platform.appendChild(this._actionBtn.getRootElement()),
        e.appendChild(this.__platform),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (views.Persona.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__userInfo = null),
      this._imgBadge.destroy(),
      (this.__userName = null),
      (this.__established = null),
      (this.__platform = null),
      this._actionBtn.destroy();
  }),
  (views.Persona.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (views.Persona.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.Persona.prototype.init = function init() {
    this.superclass(),
      this._actionBtn.setText(services.Localization.localize('more.persona')),
      this._actionBtn.init(),
      this._actionBtn.getRoot().hide();
  }),
  (views.Persona.prototype.setClubBadge = function setClubBadge(e) {
    this._imgBadge.setResource(
      utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_BADGE_DARK,
        enums.Year.ASSET,
        e
      )
    ),
      this._imgBadge.addClass('iconActive');
  }),
  (views.Persona.prototype.setUsername = function setUsername(e) {
    this.__userName.textContent = e;
  }),
  (views.Persona.prototype.setEstablishedDate = function setEstablishedDate(e) {
    this.__established.textContent = services.Localization.localizeEstablishedDate(
      new Date(1e3 * e)
    );
  }),
  (views.Persona.prototype.setPlatform = function setPlatform(e) {
    if (this._currentPlatform !== e) {
      switch (
        (this._currentPlatform !== enums.UIPlatform.NONE &&
          this.__platform.classList.remove(this._currentPlatform),
        e)
      ) {
        case enums.Platform.XBO:
          this._currentPlatform = enums.UIPlatform.XBO;
          break;
        case enums.Platform.XBX:
          this._currentPlatform = enums.UIPlatform.XBX;
          break;
        case enums.Platform.PS4:
          this._currentPlatform = enums.UIPlatform.PS4;
          break;
        case enums.Platform.PS3:
          this._currentPlatform = enums.UIPlatform.PS3;
          break;
        case enums.Platform.PC:
          this._currentPlatform = enums.UIPlatform.PC;
          break;
        case enums.Platform.SWI:
          this._currentPlatform = enums.UIPlatform.SWI;
          break;
        default:
          utils.Debug.Assert(!1, 'Encountered an unsupported SKU');
      }
      this.__platform.classList.add(this._currentPlatform);
    }
  }),
  (views.Persona.prototype.getActionButton = function getActionButton() {
    return this._actionBtn;
  }),
  (views.Persona.prototype.setBtnText = function setBtnText(e) {
    this._actionBtn.setText(e);
  }),
  (views.Persona.prototype.setBtnVisibility = function setBtnVisibility(e) {
    this._actionBtn.setDisplay(e);
  }),
  NamespaceManager.Register('viewmodels'),
  (viewmodels.ItemList = function ItemList(e) {
    UTIterator.call(this, e),
      (this.dataUpdated = new UTObservable()),
      Object.defineProperty(this, 'dataUpdated', {
        writable: !1
      }),
      (this._auctionUpdateArray = []),
      (this._auctionUpdateTimer = null),
      (this._auctionObservable = null),
      (this._updateIntervals = [
        {
          expires: 30,
          interval: 1
        },
        {
          expires: 60,
          interval: 5
        },
        {
          expires: 600,
          interval: 120
        },
        {
          expires: 3600,
          interval: 600
        },
        {
          expires: 432e3,
          interval: 43200
        }
      ]),
      (this._pendingExpiryUpdateInterval = 5e3),
      (this.sortByRecency = !1),
      (this.sort = enums.SearchSort.DESCENDING),
      (this._pinnedItem = null);
  }),
  utils.JS.inherits(viewmodels.ItemList, UTIterator),
  (viewmodels.ItemList.prototype.add = function add(e, t) {
    this.superclass(e, t), utils.JS.isNumber(t) || this._organizeItems();
  }),
  (viewmodels.ItemList.prototype.addArray = function addArray(e) {
    var t = this.length;
    e.forEach(function(e) {
      this.add(e, t), t++;
    }, this),
      this._organizeItems();
  }),
  (viewmodels.ItemList.prototype.removeArray = function removeArray(i) {
    var t = [];
    this._collection.forEach(function(e) {
      (function isInArray(t) {
        return !!utils.JS.find(i, function(e) {
          return t.id === e.id;
        });
      })(e) || t.push(e);
    }),
      (this._collection = t),
      this._organizeItems();
  }),
  (viewmodels.ItemList.prototype.getItemList = function getItemList() {
    return this.values();
  }),
  (viewmodels.ItemList.prototype.getPinnedItem = function getPinnedItem() {
    return this._pinnedItem;
  }),
  (viewmodels.ItemList.prototype.setPinnedItem = function setPinnedItem(e) {
    utils.JS.isValid(e) && (this._pinnedItem = e);
  }),
  (viewmodels.ItemList.prototype._organizeItems = function _organizeItems() {
    if (0 !== this.length) {
      var e = this.values().sort(this.sortByType.bind(this));
      this.resetCollection(e);
    }
  }),
  (viewmodels.ItemList.prototype._startAuctionUpdateTimer = function _startAuctionUpdateTimer() {
    this._auctionUpdateTimer
      ? (this._auctionUpdateTimer.reset(),
        this._auctionUpdateTimer.setInterval(1e3),
        this._auctionUpdateTimer.setWorkFunc(
          this.startAuctionUpdates.bind(this)
        ))
      : (this._auctionUpdateTimer = new utils.UTTimer(
          1e3,
          this.startAuctionUpdates.bind(this)
        )),
      this._auctionUpdateTimer.start();
  }),
  (viewmodels.ItemList.prototype.startAuctionUpdates = function startAuctionUpdates(
    e
  ) {
    this.stopAuctionUpdates(), (e = !!e);
    var t = this._auctionUpdateArray.slice(),
      i = utils.JS.isValid(this._pinnedItem)
        ? this.values().concat([this._pinnedItem])
        : this.values();
    (this._auctionUpdateArray = i.filter(function(e) {
      var t = e.getAuctionData();
      if (!t.isUpdating && t.isActiveTrade()) {
        if (
          (t.expires <= 0 || t.getSecondsRemaining() <= 0) &&
          t.getAge() < this._pendingExpiryUpdateInterval
        )
          return !1;
        for (var i = this._updateIntervals.length; 0 < i--; ) {
          var s = this._updateIntervals[i];
          if (
            t.isStale() ||
            (t.getSecondsRemaining() <= s.expires &&
              t.getAgeInSeconds() >= s.interval)
          )
            return !0;
        }
      }
      return !1;
    }, this)),
      0 < this._auctionUpdateArray.length
        ? ((this._auctionObservable = services.Item.refreshAuctions(
            this._auctionUpdateArray,
            e
          )),
          this._auctionObservable.observe(this, function(e, t) {
            e.unobserve(this),
              this.dataUpdated.notify(),
              (this._auctionObservable = null),
              this._startAuctionUpdateTimer();
          }))
        : (0 < t.length && this.dataUpdated.notify(),
          this._startAuctionUpdateTimer());
  }),
  (viewmodels.ItemList.prototype.stopAuctionUpdates = function stopAuctionUpdates() {
    this._auctionUpdateTimer && this._auctionUpdateTimer.reset(),
      this._auctionObservable &&
        (this._auctionObservable.unobserve(this),
        (this._auctionObservable = null));
  }),
  (viewmodels.ItemList.prototype.sortByType = function sortByType(e, t) {
    var i,
      s = {
        RECENCY: 0,
        EXPIRY: 1,
        LOAN: 2,
        UNTRADEABLE: 3,
        DISCARD: 4,
        TYPE: 5,
        LEGEND: 6,
        SPECIAL: 7,
        TIER: 8,
        RARITY: 9,
        RATING: 10,
        RESOURCE: 11,
        PLAYERPICK: 12
      },
      n = [
        enums.ItemType.PLAYER,
        enums.ItemType.MANAGER,
        enums.ItemType.HEAD_COACH,
        enums.ItemType.FITNESS_COACH,
        enums.ItemType.PHYSIO,
        enums.ItemType.GK_COACH,
        enums.ItemType.CONTRACT,
        enums.ItemType.HEALTH,
        enums.ItemType.TRAINING,
        enums.ItemType.BADGE,
        enums.ItemType.KIT,
        enums.ItemType.BALL,
        enums.ItemType.STADIUM,
        enums.ItemType.MISC
      ];

    function getCompareVal(e, t, i) {
      switch (e) {
        case s.RECENCY:
          return utils.JS.sortCompare(
            t.timestamp,
            i.timestamp,
            this.sort === enums.SearchSort.DESCENDING
          );
        case s.EXPIRY:
          return utils.JS.sortCompare(
            t.getAuctionData().getSecondsRemaining(),
            i.getAuctionData().getSecondsRemaining(),
            !1
          );
        case s.LOAN:
          return utils.JS.sortCompare(
            t.isLoaned(),
            i.isLoaned(),
            this.sort === enums.SearchSort.DESCENDING
          );
        case s.UNTRADEABLE:
          return utils.JS.sortCompare(t.untradeable, i.untradeable, !1);
        case s.DISCARD:
          return utils.JS.sortCompare(
            t.discardValue,
            i.discardValue,
            this.sort === enums.SearchSort.DESCENDING
          );
        case s.TYPE:
          return utils.JS.sortCompare(n.indexOf(t.type), n.indexOf(i.type), !1);
        case s.LEGEND:
          return utils.JS.sortCompare(t.isLegend(), i.isLegend(), !0);
        case s.SPECIAL:
          return utils.JS.sortCompare(t.isSpecial(), i.isSpecial(), !0);
        case s.TIER:
          return utils.JS.sortCompare(t.getTier(), i.getTier(), !0);
        case s.RARITY:
          return utils.JS.sortCompare(t.rareflag, i.rareflag, !1);
        case s.RATING:
          return utils.JS.sortCompare(
            t.rating,
            i.rating,
            this.sort === enums.SearchSort.DESCENDING
          );
        case s.RESOURCE:
          return utils.JS.sortCompare(t.resourceId, i.resourceId, !1);
        case s.PLAYERPICK:
          return utils.JS.sortCompare(
            t.isPlayerPickItem(),
            i.isPlayerPickItem(),
            !0
          );
      }
      return 0;
    }
    i =
      e.getAuctionData().isActiveTrade() && t.getAuctionData().isActiveTrade()
        ? [
            s.RECENCY,
            s.EXPIRY,
            s.DISCARD,
            s.TYPE,
            s.LEGEND,
            s.SPECIAL,
            s.TIER,
            s.RATING,
            s.RARITY,
            s.RESOURCE
          ]
        : this.sort === enums.SearchSort.ASCENDING
        ? [s.RECENCY, s.PLAYERPICK, s.DISCARD, s.LOAN, s.RATING, s.RESOURCE]
        : e.concept && t.concept
        ? [s.TIER, s.RATING, s.SPECIAL, s.RARITY, s.RESOURCE]
        : [
            s.RECENCY,
            s.PLAYERPICK,
            s.LOAN,
            s.UNTRADEABLE,
            s.DISCARD,
            s.TYPE,
            s.LEGEND,
            s.SPECIAL,
            s.TIER,
            s.RATING,
            s.RARITY,
            s.RESOURCE
          ];
    for (var o = this.sortByRecency ? 0 : 1, a = 0; 0 === a && o !== i.length; )
      (a = getCompareVal.call(this, i[o], e, t)), o++;
    return a;
  }),
  NamespaceManager.Register('viewmodels'),
  (viewmodels.PaginatedItemList = function(e, t) {
    viewmodels.ItemList.call(this, e),
      (this.numItemsPerPage = utils.JS.isNumber(t) && 0 < t ? t : 15),
      (this.isFull = !1);
  }),
  utils.JS.inherits(viewmodels.PaginatedItemList, viewmodels.ItemList),
  (viewmodels.PaginatedItemList.prototype.resetCollection = function resetCollection(
    e
  ) {
    this.superclass(e), (this.isFull = !1);
  }),
  (viewmodels.PaginatedItemList.prototype.getCurrentPage = function getCurrentPage() {
    return Math.max(Math.ceil((this.getIndex() + 1) / this.numItemsPerPage), 1);
  }),
  (viewmodels.PaginatedItemList.prototype.getNumPages = function getNumPages() {
    return Math.max(Math.ceil(this.length / this.numItemsPerPage), 1);
  }),
  (viewmodels.PaginatedItemList.prototype.getPageIndex = function getPageIndex() {
    return this.getIndex() % this.numItemsPerPage;
  }),
  (viewmodels.PaginatedItemList.prototype._getPageStartIndex = function _getPageStartIndex(
    e
  ) {
    return 1 <= e ? (e - 1) * this.numItemsPerPage : 0;
  }),
  (viewmodels.PaginatedItemList.prototype.getPageItems = function getPageItems() {
    var e = this._getPageStartIndex(this.getCurrentPage());
    return this.values().slice(e, e + this.numItemsPerPage);
  }),
  (viewmodels.PaginatedItemList.prototype.hasPreviousPage = function hasPreviousPage() {
    return 1 < this.getCurrentPage();
  }),
  (viewmodels.PaginatedItemList.prototype.hasNextPage = function hasNextPage() {
    return this.getCurrentPage() < this.getNumPages();
  }),
  (viewmodels.PaginatedItemList.prototype.canShowPage = function canShowPage(
    e
  ) {
    if (
      ((e = utils.JS.isNumber(e) ? e : this.getCurrentPage()),
      utils.Debug.Assert(
        0 < e && e <= this.getNumPages(),
        'viewmodels.PaginatedItemList::canShowPage. Page number out of bounds.'
      ),
      this.isFull)
    )
      return !0;
    var t = this._getPageStartIndex(e);
    return (
      this.values().slice(t, t + this.numItemsPerPage).length ===
      this.numItemsPerPage
    );
  }),
  (viewmodels.PaginatedItemList.prototype.previousPage = function previousPage() {
    return (
      this.hasPreviousPage() &&
        this.setIndex(this._getPageStartIndex(this.getCurrentPage() - 1)),
      this.getPageItems()
    );
  }),
  (viewmodels.PaginatedItemList.prototype.nextPage = function nextPage() {
    return (
      this.hasNextPage() &&
        this.setIndex(this._getPageStartIndex(this.getCurrentPage() + 1)),
      this.getPageItems()
    );
  }),
  NamespaceManager.Register('viewmodels'),
  (viewmodels.Club = function ClubViewModel(e) {
    var t = gConfigurationModel.getConfigObject(
        models.ConfigurationModel.KEY_ITEMS_PER_PAGE
      ),
      i = utils.JS.isValid(t)
        ? t[models.ConfigurationModel.ITEMS_PER_PAGE.CLUB]
        : 20;
    viewmodels.PaginatedItemList.call(this, e, i);
  }),
  utils.JS.inherits(viewmodels.Club, viewmodels.PaginatedItemList),
  (viewmodels.Club.prototype.shouldRequestItems = function shouldRequestItems() {
    return (
      !this.isFull &&
      this.length <= this.numItemsPerPage * this.getCurrentPage()
    );
  }),
  (viewmodels.Club.prototype.removeEmptyConsumables = function removeEmptyConsumables() {
    var e = this.getIndex(),
      t = this.values(),
      i = this.isFull;
    (t = t.filter(function(e) {
      return 0 < e.stackCount;
    })),
      this.resetCollection(t),
      (this.isFull = i),
      this.setIndex(0 < t.length ? Math.min(e, t.length - 1) : 0);
  }),
  (viewmodels.Club.prototype.getActiveItemsURLs = function getActiveItemsURLs() {
    return this._getItemsURLs();
  }),
  (viewmodels.Club.prototype.getActiveItemURL = function getActiveItemURL(e) {
    return this._getItemsURLs(e);
  }),
  (viewmodels.Club.prototype.getActiveItemsImgs = function getActiveItemsImgs() {
    var e,
      t = {},
      i = this._getItemsURLs();
    for (e in i)
      if (i.hasOwnProperty(e)) {
        var s = parseInt(e, 10),
          n = this._getImageLoadListener(s),
          o = new UTImageView();
        o.setResource(i[s], !0).observe(this, n), (t[s] = o);
      }
    return t;
  }),
  (viewmodels.Club.prototype.getActiveItemImg = function getActiveItemImg(e) {
    var t = new UTImageView(),
      i = this._getImageLoadListener(e);
    return t.setResource(this.getActiveItemURL(e), !0).observe(this, i), t;
  }),
  (viewmodels.Club.prototype._getImageLoadListener = function _getImageLoadListener(
    e
  ) {
    var t;
    switch (e) {
      case enums.UIActiveItemImgType.HOME_KIT:
      case enums.UIActiveItemImgType.AWAY_KIT:
        t = this._onKitLoad;
        break;
      case enums.UIActiveItemImgType.BADGE_NORMAL:
      case enums.UIActiveItemImgType.BADGE_DARK:
        t = this._onBadgeLoad;
        break;
      case enums.UIActiveItemImgType.BALL:
        t = this._onBallLoad;
        break;
      case enums.UIActiveItemImgType.STADIUM:
        t = this._onStadiumLoad;
        break;
      default:
        t = this._onKitLoad;
    }
    return t;
  }),
  (viewmodels.Club.prototype._onKitLoad = function _onKitLoad(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(
            /j(\d+)_\d+_\d+\.png/,
            'j$1_' +
              enums.PlaceholderAssetId.TEAM +
              '_' +
              enums.PlaceholderAssetId.KIT +
              '.png'
          )
        );
  }),
  (viewmodels.Club.prototype._onBadgeLoad = function _onBadgeLoad(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.TEAM + '.png')
        );
  }),
  (viewmodels.Club.prototype._onBallLoad = function _onBallLoad(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.BALL + '.png')
        );
  }),
  (viewmodels.Club.prototype._onStadiumLoad = function _onStadiumLoad(
    e,
    t,
    i,
    s
  ) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.STADIUM + '.png')
        );
  }),
  (viewmodels.Club.prototype._getItemsURLs = function _getItemsURLs(a) {
    var e,
      r = {},
      l = utils.JS.isValid(a);
    if (l)
      switch (a) {
        case enums.UIActiveItemImgType.BADGE_NORMAL:
        case enums.UIActiveItemImgType.BADGE_DARK:
          e = enums.ItemState.ACTIVE_BADGE;
          break;
        case enums.UIActiveItemImgType.BALL:
          e = enums.ItemState.ACTIVE_BALL;
          break;
        case enums.UIActiveItemImgType.STADIUM:
          e = enums.ItemState.ACTIVE_STADIUM;
          break;
        case enums.UIActiveItemImgType.HOME_KIT:
          e = enums.ItemState.ACTIVE_HOME_KIT;
          break;
        case enums.UIActiveItemImgType.AWAY_KIT:
          e = enums.ItemState.ACTIVE_AWAY_KIT;
          break;
        case enums.UIActiveItemImgType.BANNER:
          e = enums.ItemState.ACTIVE_BANNER;
          break;
        case enums.UIActiveItemImgType.CELEBRATION:
          e = enums.ItemState.ACTIVE_CELEBRATION;
          break;
        case enums.UIActiveItemImgType.TIFO:
          e = enums.ItemState.ACTIVE_TIFO;
          break;
        default:
          utils.Debug.Assert(
            !1,
            'viewmodels.Club:_getItemsURLs. Expected an enums.UIActiveItemImgType.<number>'
          );
      }
    return (
      utils.JS.valToArray(services.Item.getActiveClubItems(e)).forEach(function(
        e
      ) {
        if (utils.JS.isValid(e)) {
          var t,
            i = e.getStaticData(),
            s = e.getYear(),
            n = '';
          switch (e.state) {
            case enums.ItemState.ACTIVE_BADGE:
              if (
                ((l && a !== enums.UIActiveItemImgType.BADGE_NORMAL) ||
                  ((n = utils.AssetLocator.getImage(
                    utils.AssetLocator.IMAGE_TYPE_BADGE_LIGHT,
                    s,
                    e.teamId
                  )),
                  utils.AssetLocator.hasPlaceholder(
                    enums.PlaceholderAssetKey.CREST,
                    e.teamId.toString(),
                    s,
                    enums.PlaceholderAssetKey.CREST_LIGHT
                  ) &&
                    (n = utils.AssetLocator.getImage(
                      utils.AssetLocator.IMAGE_TYPE_BADGE_LIGHT,
                      s
                    )),
                  (t = enums.UIActiveItemImgType.BADGE_NORMAL)),
                !l || a === enums.UIActiveItemImgType.BADGE_DARK)
              ) {
                var o = utils.AssetLocator.getImage(
                  utils.AssetLocator.IMAGE_TYPE_BADGE_DARK,
                  s,
                  e.teamId
                );
                utils.AssetLocator.hasPlaceholder(
                  enums.PlaceholderAssetKey.CREST,
                  e.teamId.toString(),
                  s,
                  enums.PlaceholderAssetKey.CREST_DARK
                ) &&
                  (o = utils.AssetLocator.getImage(
                    utils.AssetLocator.IMAGE_TYPE_BADGE_DARK,
                    s
                  )),
                  (r[enums.UIActiveItemImgType.BADGE_DARK] = o);
              }
              break;
            case enums.ItemState.ACTIVE_BALL:
              (n = utils.AssetLocator.getImage(
                utils.AssetLocator.IMAGE_TYPE_BALL,
                s,
                i.assetId
              )),
                utils.AssetLocator.hasPlaceholder(
                  enums.PlaceholderAssetKey.BALLS,
                  i.assetId,
                  s
                ) &&
                  (n = utils.AssetLocator.getImage(
                    utils.AssetLocator.IMAGE_TYPE_BALL,
                    s
                  )),
                (t = enums.UIActiveItemImgType.BALL);
              break;
            case enums.ItemState.ACTIVE_STADIUM:
              (n = utils.AssetLocator.getImage(
                utils.AssetLocator.IMAGE_TYPE_STADIUM_FULL,
                s,
                i.assetId
              )),
                (t = enums.UIActiveItemImgType.STADIUM);
              break;
            case enums.ItemState.ACTIVE_HOME_KIT:
              (n = utils.AssetLocator.getImage(
                i.assetType,
                s,
                e.teamId,
                i.assetYear
              )),
                utils.AssetLocator.hasPlaceholderKit(n, s) &&
                  (n = utils.AssetLocator.getImage(i.assetType, s)),
                (t = enums.UIActiveItemImgType.HOME_KIT);
              break;
            case enums.ItemState.ACTIVE_AWAY_KIT:
              (n = utils.AssetLocator.getImage(
                i.assetType,
                s,
                e.teamId,
                i.assetYear
              )),
                utils.AssetLocator.hasPlaceholderKit(n, s) &&
                  (n = utils.AssetLocator.getImage(i.assetType, s)),
                (t = enums.UIActiveItemImgType.AWAY_KIT);
              break;
            case enums.ItemState.ACTIVE_TIFO:
              (n = utils.AssetLocator.getImage(
                utils.AssetLocator.IMAGE_TYPE_TIFO,
                s,
                e.resourceId,
                i.assetYear
              )),
                utils.AssetLocator.hasPlaceholder(
                  enums.PlaceholderAssetKey.TIFOS,
                  e.resourceId,
                  s
                ) &&
                  (n = utils.AssetLocator.getImage(
                    utils.AssetLocator.IMAGE_TYPE_TIFO,
                    s
                  )),
                (t = enums.UIActiveItemImgType.TIFO);
              break;
            case enums.ItemState.ACTIVE_BANNER:
              (n = utils.AssetLocator.getImage(
                utils.AssetLocator.IMAGE_TYPE_BANNER,
                s,
                e.resourceId,
                i.assetYear
              )),
                utils.AssetLocator.hasPlaceholder(
                  enums.PlaceholderAssetKey.BANNERS,
                  e.resourceId,
                  s
                ) &&
                  (n = utils.AssetLocator.getImage(
                    utils.AssetLocator.IMAGE_TYPE_BANNER,
                    s
                  )),
                (t = enums.UIActiveItemImgType.BANNER);
              break;
            case enums.ItemState.ACTIVE_CELEBRATION:
              (n = utils.AssetLocator.getImage(
                utils.AssetLocator.IMAGE_TYPE_CELEBRATION,
                s,
                i.assetId,
                i.assetYear
              )),
                utils.AssetLocator.hasPlaceholder(
                  enums.PlaceholderAssetKey.CELEBRATIONS,
                  e.resourceId,
                  s
                ) &&
                  (n = utils.AssetLocator.getImage(
                    utils.AssetLocator.IMAGE_TYPE_CELEBRATION,
                    s
                  )),
                (t = enums.UIActiveItemImgType.CELEBRATION);
          }
          utils.JS.isEmpty(n) || (r[t] = n);
        }
      }),
      l ? r[a] : r
    );
  }),
  NamespaceManager.Register('controllers.views'),
  (controllers.views.Persona = function PersonaViewController() {
    UTViewController.call(this), (this.showPersonaChanger = !0);
  }),
  utils.JS.inherits(controllers.views.Persona, UTViewController),
  (controllers.views.Persona.prototype.init = function init() {
    this.initialized ||
      (this.superclass(),
      this.getView()
        .getActionButton()
        .addTarget(this, this._ePersonaSelectorSelected, enums.Event.TAP));
  }),
  (controllers.views.Persona.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new views.Persona();
  }),
  (controllers.views.Persona.prototype.viewDidAppear = function viewDidAppear() {
    this.superclass();
    var e = this.getView(),
      t = services.User.getUser(),
      i = services.Authentication.getFUTAuthState(),
      s = i !== enums.FUTAuthState.NO_DATA && t;
    if ((e.setDisplay(s), s)) {
      for (
        var n = t.getSelectedPersona(),
          o = n ? n.getCurrentClub() : null,
          a = !1,
          r = t.getPersonas(!0),
          l = 0;
        l < r.length;
        l++
      )
        if (0 < r[l].getValidClubs().length) {
          a = !0;
          break;
        }
      n &&
        (e.setBtnVisibility(this.showPersonaChanger && a),
        e.setPlatform(n.platform)),
        o &&
          (e.setClubBadge(o.assetId),
          e.setEstablishedDate(o.established),
          e.setUsername(
            n.hasFUT && i === enums.FUTAuthState.COMPLETE ? n.name : o.name
          ));
    }
  }),
  (controllers.views.Persona.prototype._ePersonaSelectorSelected = function _ePersonaSelectorSelected(
    e,
    t,
    i
  ) {
    var s = this.getNavigationController();
    if (s) {
      var n = new UTPersonaSelectorViewController();
      n.init(), s.pushViewController(n);
    }
  }),
  utils.JS.inherits(UTStandardButtonControl, UTButtonControl),
  (UTStandardButtonControl.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('button');
      e.classList.add('btn-standard'),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTStandardButtonControl.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTStandardButtonControl.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTStandardButtonControl.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTStandardButtonControl.prototype._touchStarted = function _touchStarted(e) {
    this.superclass(), this._triggerActions(enums.Event.TOUCHSTART);
  }),
  (UTStandardButtonControl.prototype._touchEnded = function _touchEnded(e) {
    this.superclass(), this._triggerActions(enums.Event.TOUCHEND);
  }),
  (UTStandardButtonControl.prototype._touchCancelled = function _touchCancelled(
    e
  ) {
    this.superclass(), this._triggerActions(enums.Event.TOUCHCANCEL);
  }),
  utils.JS.inherits(UTTextInputControl, UTControl),
  (UTTextInputControl.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('input');
      e.setAttribute('type', 'text'),
        e.classList.add('ut-text-input-control'),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTTextInputControl.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTTextInputControl.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTTextInputControl.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTTextInputControl.prototype.init = function init() {
    this.superclass(), this.setInteractionState(!0);
  }),
  (UTTextInputControl.prototype.dealloc = function dealloc() {
    (this._selectionTimeout = clearTimeout(this._selectionTimeout)),
      (this._blurTimeout = clearTimeout(this._blurTimeout)),
      this.superclass();
  }),
  (UTTextInputControl.prototype.setInteractionState = function setInteractionState(
    e
  ) {
    if (this._setInteractionStateFlag(e)) {
      var t = this.getRootElement(),
        i = 'textEvent';
      this.toggleClass(enums.UIState.DISABLED, !this._interactionState),
        this._interactionState
          ? (t.removeAttribute('disabled'),
            this._addListener(
              enums.Event.FOCUS,
              t,
              this._handleFocusEvent.bind(this),
              i
            ),
            this._addListener(
              enums.Event.BLUR,
              t,
              this._handleBlurEvent.bind(this),
              i
            ),
            this._addListener(
              enums.Event.CHANGE,
              t,
              this._handleChangeEvent.bind(this),
              i
            ),
            this._addListener(
              enums.Event.INPUT,
              t,
              this._handleInputEvent.bind(this),
              i
            ),
            this._addListener(
              enums.Event.CUT,
              t,
              this._handleInputEvent.bind(this),
              i
            ),
            this._addListener(
              enums.Event.PASTE,
              t,
              this._handleInputEvent.bind(this),
              i
            ))
          : (this.blur(),
            t.setAttribute('disabled', 'disabled'),
            this._removeListenersByNS(i));
    }
  }),
  (UTTextInputControl.prototype.getValue = function getValue() {
    return this.getRootElement().value;
  }),
  (UTTextInputControl.prototype.setValue = function setValue(e) {
    this.getRootElement().value = e;
  }),
  (UTTextInputControl.prototype.getType = function getType() {
    return this.getRootElement().getAttribute('type');
  }),
  (UTTextInputControl.prototype.setType = function setType(e) {
    for (var t in enums.UIInputType)
      if (
        enums.UIInputType.hasOwnProperty(t) &&
        enums.UIInputType[t] === newType
      )
        return void this.getRootElement().setAttribute('type', e);
    utils.Debug.Assert(!1, 'Invalid type assignment to text input control.');
  }),
  (UTTextInputControl.prototype.setPlaceholder = function setPlaceholder(e) {
    this.getRootElement().setAttribute('placeholder', e);
  }),
  (UTTextInputControl.prototype.setMaxLength = function setMaxLength(e) {
    this.getRootElement().setAttribute('maxlength', e);
  }),
  (UTTextInputControl.prototype.clear = function clear() {
    this.setValue('');
  }),
  (UTTextInputControl.prototype._handleChangeEvent = function _handleChangeEvent(
    e
  ) {
    this._triggerActions(enums.Event.CHANGE, {
      value: this.getValue()
    });
  }),
  (UTTextInputControl.prototype._handleInputEvent = function _handleInputEvent(
    e
  ) {
    this._triggerActions(enums.Event.INPUT, {
      value: this.getValue(),
      keyCode: e.keyCode
    });
  }),
  (UTTextInputControl.prototype._handleFocusEvent = function _handleFocusEvent(
    e
  ) {
    this._selectionTimeout = setTimeout(
      function _setSelectionRange() {
        var e = this.getRootElement();
        e.setSelectionRange(0, e.value.length);
      }.bind(this),
      50
    );
  }),
  (UTTextInputControl.prototype._handleBlurEvent = function _handleBlurEvent(
    e
  ) {
    clearTimeout(this._selectionTimeout), (this._selectionTimeout = 0);
  }),
  NamespaceManager.Register('views.bootFlow'),
  (views.bootFlow.CaptchaRequired = function UTCaptchaRequiredView() {
    UTView.call(this),
      (this.onContinue = new UTObservable()),
      Object.defineProperty(this, 'onContinue', {
        writable: !1
      }),
      (this.onRefresh = new UTObservable()),
      Object.defineProperty(this, 'onRefresh', {
        writable: !1
      }),
      (this.onTextChange = new UTObservable()),
      Object.defineProperty(this, 'onTextChange', {
        writable: !1
      });
  }),
  utils.JS.inherits(views.bootFlow.CaptchaRequired, UTView),
  (views.bootFlow.CaptchaRequired.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.setAttribute('id', 'CaptchaRequired'),
        e.classList.add('sm-ut-content-container'),
        e.classList.add('ut-content-container');
      var t = document.createElement('div');
      t.classList.add('ut-content'),
        (this.__personaSelectorContainer = document.createElement('div')),
        this.__personaSelectorContainer.classList.add(
          'ut-app-settings-persona-selector'
        ),
        t.appendChild(this.__personaSelectorContainer);
      var i = document.createElement('div');
      i.classList.add('ut-captcha-required'),
        i.classList.add('ut-login-generic');
      var s = document.createElement('div');
      s.classList.add('ut-login-generic-content');
      var n = document.createElement('div');
      (this.__infoTitle = document.createElement('h2')),
        this.__infoTitle.classList.add('title'),
        n.appendChild(this.__infoTitle),
        (this.__infoText = document.createElement('p')),
        n.appendChild(this.__infoText),
        (this.__icon = document.createElement('div')),
        this.__icon.setAttribute('id', 'securityIcon'),
        (this.__captchaImageContainer = document.createElement('div')),
        this.__captchaImageContainer.classList.add('captchaImageContainer'),
        (this.__captchaImage = document.createElement('div')),
        this.__captchaImage.classList.add('captchaImage'),
        this.__captchaImageContainer.appendChild(this.__captchaImage),
        this.__icon.appendChild(this.__captchaImageContainer),
        (this._refreshLink = new UTFlatButtonControl()),
        this._refreshLink.getRootElement().classList.add('camel-case'),
        this._refreshLink.getRootElement().classList.add('refreshBtn'),
        this.__icon.appendChild(this._refreshLink.getRootElement()),
        n.appendChild(this.__icon),
        (this.__captchaAnswerContainer = document.createElement('div')),
        (this._textInput = new UTTextInputControl()),
        this.__captchaAnswerContainer.appendChild(
          this._textInput.getRootElement()
        ),
        (this.__errorText = document.createElement('p')),
        this.__errorText.classList.add('errorText'),
        this.__captchaAnswerContainer.appendChild(this.__errorText),
        (this._validateCaptcha = new UTStandardButtonControl()),
        this._validateCaptcha.getRootElement().classList.add('call-to-action'),
        this.__captchaAnswerContainer.appendChild(
          this._validateCaptcha.getRootElement()
        ),
        n.appendChild(this.__captchaAnswerContainer),
        (this.__captchaWaitContainer = document.createElement('div')),
        this.__captchaWaitContainer.classList.add('captchaWaitContainer'),
        (this.__captchaWaitText = document.createElement('p')),
        this.__captchaWaitText.classList.add('captchaWaitText'),
        this.__captchaWaitContainer.appendChild(this.__captchaWaitText);
      var o = document.createElement('div');
      o.classList.add('captchaWaitBox'),
        (this.__captchaWaitTime = document.createElement('p')),
        this.__captchaWaitTime.classList.add('timeRemaining'),
        o.appendChild(this.__captchaWaitTime),
        this.__captchaWaitContainer.appendChild(o),
        n.appendChild(this.__captchaWaitContainer),
        s.appendChild(n),
        i.appendChild(s),
        t.appendChild(i),
        e.appendChild(t),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (views.bootFlow.CaptchaRequired.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__personaSelectorContainer = null),
      (this.__infoTitle = null),
      (this.__infoText = null),
      (this.__icon = null),
      (this.__captchaImageContainer = null),
      (this.__captchaImage = null),
      this._refreshLink.destroy(),
      (this.__captchaAnswerContainer = null),
      this._textInput.destroy(),
      (this.__errorText = null),
      this._validateCaptcha.destroy(),
      (this.__captchaWaitContainer = null),
      (this.__captchaWaitText = null),
      (this.__captchaWaitTime = null);
  }),
  (views.bootFlow.CaptchaRequired.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (views.bootFlow.CaptchaRequired.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.bootFlow.CaptchaRequired.prototype.init = function init() {
    this._validateCaptcha.init(),
      this._validateCaptcha.setText(
        services.Localization.localize('common.dialog.continue')
      ),
      this._validateCaptcha.setInteractionState(!1),
      this._validateCaptcha.addTarget(
        this.onContinue,
        this.onContinue.notify,
        enums.Event.TAP
      ),
      this._textInput.init(),
      this._textInput.setPlaceholder(
        services.Localization.localize('phishing.input.placeholder')
      ),
      this._textInput.setMaxLength(8),
      this._textInput.addTarget(
        this,
        this._handleInputEvents,
        enums.Event.INPUT
      ),
      this._refreshLink.init(),
      this._refreshLink.addTarget(
        this.onRefresh,
        this.onRefresh.notify,
        enums.Event.TAP
      ),
      this._refreshLink.setText(
        services.Localization.localize('captcha.refresh')
      ),
      (this.__infoTitle.textContent = services.Localization.localize(
        'title.securityquestion'
      )),
      (this.__infoText.textContent = services.Localization.localize(
        'captcha.info.body'
      )),
      DOMKit.toggleDisplayStyle(this.__captchaWaitContainer, !1),
      (this.__captchaWaitText.textContent = services.Localization.localize(
        'captcha.info.wait'
      )),
      (this.__errorText.textContent = services.Localization.localize(
        'captcha.error.incorrectanswer'
      )),
      this.superclass();
  }),
  (views.bootFlow.CaptchaRequired.prototype.dealloc = function dealloc() {
    this.onContinue.dealloc(),
      this.onTextChange.dealloc(),
      (this.onContinue = null),
      (this.onTextChange = null),
      this.superclass();
  }),
  (views.bootFlow.CaptchaRequired.prototype.appendPersonaSelector = function appendPersonaSelector(
    e
  ) {
    this.getRoot().addClass('has-persona-selector'),
      this.addSubview(e, this.__personaSelectorContainer);
  }),
  (views.bootFlow.CaptchaRequired.prototype.toggleCaptchaImageDisplay = function toggleCaptchaImageDisplay(
    e
  ) {
    DOMKit.toggleClass(this.__icon, 'iconHidden', e),
      DOMKit.toggleDisplayStyle(this.__captchaImageContainer, e);
  }),
  (views.bootFlow.CaptchaRequired.prototype.showCaptchaImageLoading = function showCaptchaImageLoading() {
    DOMKit.toggleDisplayStyle(this.__captchaAnswerContainer, !0),
      DOMKit.toggleDisplayStyle(this.__captchaWaitContainer, !1),
      this.clearAnswerInput(),
      this.toggleCaptchaImageDisplay(!1),
      this._textInput.setInteractionState(!1);
  }),
  (views.bootFlow.CaptchaRequired.prototype.showCaptchaWait = function showCaptchaWait(
    e
  ) {
    this._refreshLink.hide(),
      DOMKit.toggleDisplayStyle(this.__captchaImageContainer, !1),
      DOMKit.toggleDisplayStyle(this.__captchaAnswerContainer, !1),
      DOMKit.toggleDisplayStyle(this.__captchaWaitContainer, !0);
  }),
  (views.bootFlow.CaptchaRequired.prototype.updateRemainingCaptchaTime = function updateRemainingCaptchaTime(
    e
  ) {
    this.__captchaWaitTime.textContent = services.Localization.localizeTimeRemaining(
      e
    );
  }),
  (views.bootFlow.CaptchaRequired.prototype.toggleInputs = function toggleInputs(
    e
  ) {
    this._validateCaptcha.setInteractionState(e),
      this._textInput.setInteractionState(e);
  }),
  (views.bootFlow.CaptchaRequired.prototype.toggleContinueButton = function toggleContinueButton(
    e
  ) {
    this._validateCaptcha.setInteractionState(e);
  }),
  (views.bootFlow.CaptchaRequired.prototype.setCaptchaImage = function setCaptchaImage(
    e
  ) {
    var t = document.createElement('img');
    (t.src = 'data:image/jpg;base64,' + e),
      this._refreshLink.show(),
      DOMKit.empty(this.__captchaImage),
      this.__captchaImage.appendChild(t),
      this.toggleCaptchaImageDisplay(!0),
      this._textInput.setInteractionState(!0),
      TelemetryManager.trackEvent(
        TelemetryManager.Sections.MISC,
        TelemetryManager.Categories.CAPTCHA,
        'Image Loaded'
      );
  }),
  (views.bootFlow.CaptchaRequired.prototype.clearAnswerInput = function clearAnswerInput() {
    this._textInput.clear();
  }),
  (views.bootFlow.CaptchaRequired.prototype.getInputValue = function getInputValue() {
    return this._textInput.getValue();
  }),
  (views.bootFlow.CaptchaRequired.prototype.errorVisibility = function errorVisibility(
    e
  ) {
    DOMKit.toggleDisplayStyle(this.__errorText, e);
  }),
  (views.bootFlow.CaptchaRequired.prototype._handleInputEvents = function _handleInputEvents(
    e,
    t,
    i
  ) {
    t === enums.Event.INPUT && this.onTextChange.notify(i.keyCode);
  }),
  utils.JS.inherits(UTCaptchaViewController, UTViewController),
  (UTCaptchaViewController.prototype.init = function init() {
    this.superclass();
    var e = this.getView();
    (this._captchaViewModel = new UTCaptchaViewModel(accessobjects.Captcha)),
      this._captchaViewModel.init(),
      (this._personaController = new controllers.views.Persona()),
      this._personaController.init(),
      this.addChildViewController(this._personaController),
      e.appendPersonaSelector(this._personaController.getView()),
      e.layoutSubviews(),
      e.onContinue.observe(this, function() {
        this._requestCaptchaValidation(e.getInputValue());
      }),
      e.onRefresh.observe(this, this._requestCaptchaExchange),
      e.onTextChange.observe(this, this._onTextChange),
      e.errorVisibility(!1),
      this._requestCaptchaExchange(),
      TelemetryManager.trackPage(TelemetryManager.Sections.LOGIN, 'Captcha');
  }),
  (UTCaptchaViewController.prototype.dealloc = function dealloc() {
    (this._timeoutId = clearTimeout(this._timeoutId)),
      this.superclass(),
      this._captchaViewModel &&
        (this._captchaViewModel.dealloc(), (this._captchaViewModel = null)),
      this._personaController &&
        (this._personaController.dealloc(), (this._personaController = null));
  }),
  (UTCaptchaViewController.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new views.bootFlow.CaptchaRequired();
  }),
  (UTCaptchaViewController.prototype.getNavigationTitle = function getNavigationTitle() {
    return services.Localization.localize('navbar.label.captcha');
  }),
  (UTCaptchaViewController.prototype.viewDidAppear = function viewDidAppear() {
    this.superclass();
    var e = this.getNavigationController();
    e && e.setNavigationVisibility(isPhone(), !0),
      this._personaController && this._personaController.viewDidAppear();
  }),
  (UTCaptchaViewController.prototype.onCaptchaCooldown = function onCaptchaCooldown() {
    (this._cooldownSeconds = services.Authentication.getSession(
      enums.AuthEnvironment.UTAS
    ).captchaCooldown),
      this.getView().showCaptchaWait(),
      this.getView().updateRemainingCaptchaTime(this._cooldownSeconds),
      this._cooldownTimer.stop(),
      this._cooldownTimer.setInterval(1e3),
      this._cooldownTimer.setWorkFunc(
        this.updateRemainingCaptchaTime.bind(this)
      ),
      this._cooldownTimer.start(),
      (this._timeoutId = setTimeout(
        function _onTimeoutCaptchaTokenExchange() {
          clearTimeout(this._timeoutId), this._requestCaptchaExchange();
        }.bind(this),
        1e3 * this._cooldownSeconds
      )),
      TelemetryManager.trackEvent(
        TelemetryManager.Sections.MISC,
        TelemetryManager.Categories.CAPTCHA,
        'User Throttled'
      );
  }),
  (UTCaptchaViewController.prototype._requestCaptchaImage = function _requestCaptchaImage() {
    var i = this.getView();
    i.showCaptchaImageLoading(),
      i.toggleInputs(!1),
      this._captchaViewModel
        .requestLegacyImage()
        .observe(this, function _onRequestLegacyImageComplete(e, t) {
          e.unobserve(this),
            t.success
              ? (i.setCaptchaImage(t.response),
                i.toggleInputs(!0),
                this.updateContinueButtonEnabledState())
              : NetworkErrorManager.checkCriticalStatus(t.status)
              ? NetworkErrorManager.handleStatus(t.status)
              : t.status === enums.HTTPStatusCode.SERVICE_UNAVAILABLE_ERROR
              ? (i.clearAnswerInput(), this.onCaptchaCooldown())
              : (i.clearAnswerInput(),
                i.toggleCaptchaImageDisplay(!0),
                i.toggleInputs(!0),
                this.updateContinueButtonEnabledState(),
                i.errorVisibility(!1));
        });
  }),
  (UTCaptchaViewController.prototype._requestCaptchaValidation = function _requestCaptchaValidation(
    e
  ) {
    var i = this.getView();
    this._captchaAttempt ||
      (hideKeyboard(),
      hasConnection()
        ? ((this._captchaAttempt = !0),
          i.errorVisibility(!1),
          i.toggleInputs(!1),
          this._captchaViewModel
            .validateLegacyAnswer(e)
            .observe(this, function _onCaptchaValidateComplete(e, t) {
              e.unobserve(this),
                (this._captchaAttempt = !1),
                t.success
                  ? getAppMain()
                      .getLoginController()
                      .login(!0)
                  : NetworkErrorManager.checkCriticalStatus(t.status)
                  ? NetworkErrorManager.handleStatus(t.status)
                  : t.status === enums.HTTPStatusCode.SERVICE_UNAVAILABLE_ERROR
                  ? (i.clearAnswerInput(), this.onCaptchaCooldown())
                  : t.status === enums.HTTPStatusCode.NO_INTERNET_CONNECTION
                  ? (utils.PopupManager.ShowAlert(
                      utils.PopupManager.Alerts.NO_INTERNET_CONNECTION
                    ),
                    i.toggleInputs(!0))
                  : (i.clearAnswerInput(),
                    i.toggleInputs(!0),
                    i.errorVisibility(!0),
                    this.updateContinueButtonEnabledState(),
                    t.status === enums.HTTPStatusCode.CONFLICT &&
                      this._requestCaptchaImage());
            }))
        : utils.PopupManager.ShowAlert(
            utils.PopupManager.Alerts.NO_INTERNET_CONNECTION
          ));
  }),
  (UTCaptchaViewController.prototype._requestCaptchaExchange = function _requestCaptchaExchange() {
    var i = this.getView();
    i.showCaptchaImageLoading(),
      this._captchaViewModel
        .exchangeLegacyImage()
        .observe(this, function _onLegacyImageExchangeComplete(e, t) {
          e.unobserve(this),
            t.success
              ? (this._requestCaptchaImage(), i.errorVisibility(!1))
              : NetworkErrorManager.checkCriticalStatus(t.status)
              ? NetworkErrorManager.handleStatus(t.status)
              : t.status === enums.HTTPStatusCode.SERVICE_UNAVAILABLE_ERROR
              ? this.onCaptchaCooldown()
              : (i.toggleCaptchaImageDisplay(!0),
                i.toggleInputs(!0),
                i.errorVisibility(!1),
                this.updateContinueButtonEnabledState());
        });
  }),
  (UTCaptchaViewController.prototype.updateRemainingCaptchaTime = function updateRemainingCaptchaTime() {
    var e = --this._cooldownSeconds;
    e <= 0 && (this._cooldownTimer.reset(), (e = 0)),
      this.getView().updateRemainingCaptchaTime(e);
  }),
  (UTCaptchaViewController.prototype._onTextChange = function _onTextChange(
    e,
    t
  ) {
    this.updateContinueButtonEnabledState(),
      this._captchaAttempt ||
        t !== enums.KeyCode.RETURN ||
        this._requestCaptchaValidation(this.getView().getInputValue());
  }),
  (UTCaptchaViewController.prototype.updateContinueButtonEnabledState = function updateContinueButtonEnabledState() {
    this.getView().toggleContinueButton(
      0 < this.getView().getInputValue().length
    );
  }),
  utils.JS.inherits(UTFunCaptchaView, UTView),
  (UTFunCaptchaView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.setAttribute('id', 'FunCaptchaRequired'),
        e.classList.add('sm-ut-content-container'),
        e.classList.add('ut-content-container');
      var t = document.createElement('div');
      t.classList.add('ut-content'),
        (this.__personaSelectorContainer = document.createElement('div')),
        this.__personaSelectorContainer.classList.add(
          'ut-app-settings-persona-selector'
        ),
        t.appendChild(this.__personaSelectorContainer);
      var i = document.createElement('div');
      i.classList.add('ut-fun-captcha-required'),
        i.classList.add('ut-login-generic');
      var s = document.createElement('div');
      s.classList.add('ut-login-generic-content');
      var n = document.createElement('div');
      (this.__infoTitle = document.createElement('h2')),
        this.__infoTitle.classList.add('title'),
        n.appendChild(this.__infoTitle),
        (this.__infoText = document.createElement('p')),
        n.appendChild(this.__infoText),
        s.appendChild(n);
      var o = document.createElement('div');
      o.setAttribute('id', 'funCaptchaDiv'),
        s.appendChild(o),
        i.appendChild(s),
        t.appendChild(i),
        e.appendChild(t),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTFunCaptchaView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__personaSelectorContainer = null),
      (this.__infoTitle = null),
      (this.__infoText = null);
  }),
  (UTFunCaptchaView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTFunCaptchaView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTFunCaptchaView.prototype.init = function init() {
    this.superclass(),
      (this.__infoTitle.textContent = services.Localization.localize(
        'navbar.label.captcha'
      )),
      (this.__infoText.textContent = services.Localization.localize(
        'captcha.info.body'
      ));
  }),
  (UTFunCaptchaView.prototype.appendPersonaSelector = function appendPersonaSelector(
    e
  ) {
    this.addClass('has-persona-selector'),
      this.addSubview(e, this.__personaSelectorContainer);
  }),
  utils.JS.inherits(UTFunCaptchaViewController, UTViewController),
  (UTFunCaptchaViewController.prototype.init = function init() {
    this.superclass();
    var e = this.getView();
    (this._captchaViewModel = new UTCaptchaViewModel(accessobjects.Captcha)),
      this._captchaViewModel.init(),
      (this._personaController = new controllers.views.Persona()),
      this._personaController.init(),
      this.addChildViewController(this._personaController),
      e.appendPersonaSelector(this._personaController.getView()),
      e.layoutSubviews();
    var t = document.createElement('script');
    (t.id = 'funCaptchaHeaderScript'),
      (t.type = 'text/javascript'),
      (t.async = !0),
      (t.defer = !0),
      (t.src = 'https://ea-api.arkoselabs.com/fc/api/?onload=loadFunCaptcha'),
      document.head.appendChild(t),
      TelemetryManager.trackPage(TelemetryManager.Sections.LOGIN, 'CaptchaV2');
  }),
  (UTFunCaptchaViewController.prototype.dealloc = function dealloc() {
    this.superclass(),
      this._captchaViewModel &&
        (this._captchaViewModel.dealloc(), (this._captchaViewModel = null)),
      this._personaController &&
        (this._personaController.dealloc(), (this._personaController = null));
    var e = document.getElementById('funCaptchaHeaderScript');
    utils.JS.isValid(e) && e.parentNode.removeChild(e);
  }),
  (UTFunCaptchaViewController.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new UTFunCaptchaView();
  }),
  (UTFunCaptchaViewController.prototype.getNavigationTitle = function getNavigationTitle() {
    return services.Localization.localize('navbar.label.captcha');
  }),
  (UTFunCaptchaViewController.prototype.viewDidAppear = function viewDidAppear() {
    this.superclass();
    var e = this.getNavigationController();
    e && e.setNavigationVisibility(isPhone(), !0),
      this._personaController && this._personaController.viewDidAppear(),
      this._loadFunCaptcha();
  }),
  (UTFunCaptchaViewController.prototype._loadFunCaptcha = function _loadFunCaptcha() {
    if (!this._captchaLoaded) {
      var o = document.getElementById('loadFunCaptchaScript');
      this._captchaViewModel
        .requestCaptchaData()
        .observe(this, function _onRequestCaptchaDataComplete(e, t) {
          var i, s;
          e.unobserve(this),
            t.success
              ? ((i =
                  t.response.pk ||
                  gConfigurationModel.getConfigString(
                    models.ConfigurationModel.KEY_FUNCAPTCHA_PK
                  )),
                (s = t.response.blob || null),
                _initCaptcha.call(this, i, s))
              : t.status === enums.HTTPStatusCode.CAPTCHA_REQUIRED
              ? getAppMain()
                  .getRootViewController()
                  .showCaptchaView()
              : ((i = gConfigurationModel.getConfigString(
                  models.ConfigurationModel.KEY_FUNCAPTCHA_PK
                )),
                _initCaptcha.call(this, i, (s = null)));
        });
    }

    function _initCaptcha(e, t) {
      if (!utils.JS.isValid(o)) {
        var i = services.Localization.getLocale().language;
        (o = document.createElement('script')).id = 'loadFunCaptchaScript';
        var s = '';
        null !== t && (s = "'data': {'blob':'" + t + "'},");
        var n =
          "{'public_key': '" +
          e +
          "', " +
          s +
          "'target_html': 'funCaptchaDiv',\t'callback': UTFunCaptchaViewController.captchaCompletedCallback, 'language': '" +
          i +
          "'}";
        (o.innerHTML =
          'var funCaptcha;function loadFunCaptcha() {\tif(!utils.JS.isValid(funCaptcha)){\t\tfunCaptcha = new FunCaptcha(' +
          n +
          ');\t}else{\t\tfunCaptcha.refresh_session();\t}};'),
          document.body.appendChild(o),
          (this._captchaLoaded = !0);
      }
    }
  }),
  (UTFunCaptchaViewController.captchaCompletedCallback = function captchaCompletedCallback() {
    var e = document.getElementById('FunCaptcha-Token').value,
      i = new UTCaptchaViewModel(accessobjects.Captcha);
    i.init(),
      i.validateToken(e).observe(this, function _onValidateTokenComplete(e, t) {
        e.unobserve(this),
          t.success
            ? getAppMain()
                .getLoginController()
                .login(!0)
            : t.status === enums.HTTPStatusCode.CAPTCHA_REQUIRED
            ? getAppMain()
                .getRootViewController()
                .showCaptchaView()
            : getAppMain()
                .getLoginController()
                .logout(),
          i.dealloc();
      });
  }),
  NamespaceManager.Register('views.bootFlow'),
  (views.bootFlow.GettingStarted = function UTGettingStartedView() {
    UTView.call(this), this._generate();
  }),
  utils.JS.inherits(views.bootFlow.GettingStarted, UTView),
  (views.bootFlow.GettingStarted.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('sm-ut-content-container'),
        e.classList.add('ut-content-container');
      var t = document.createElement('div');
      t.classList.add('ut-content'),
        (this.__personaSelectorContainer = document.createElement('div')),
        this.__personaSelectorContainer.classList.add(
          'ut-app-settings-persona-selector'
        ),
        t.appendChild(this.__personaSelectorContainer),
        (this.__bootBox = document.createElement('div')),
        this.__bootBox.classList.add('ut-getting-started');
      var i = document.createElement('div');
      i.classList.add('ut-getting-started-logo'),
        (this._futLogo = new views.bootFlow.FUTLogo()),
        i.appendChild(this._futLogo.getRootElement()),
        this.__bootBox.appendChild(i);
      var s = document.createElement('div');
      s.classList.add('ut-getting-started-content');
      var n = document.createElement('div');
      n.classList.add('ut-getting-started--scrollable'),
        (this.__infoTitle = document.createElement('h2')),
        n.appendChild(this.__infoTitle),
        (this.__description = document.createElement('p')),
        this.__description.classList.add('description'),
        n.appendChild(this.__description),
        (this.__steps = document.createElement('ul')),
        this.__steps.classList.add('isolated-section'),
        this.__steps.classList.add('steps');
      var o = document.createElement('li');
      (this.__step1 = document.createElement('span')),
        o.appendChild(this.__step1),
        this.__steps.appendChild(o);
      var a = document.createElement('li');
      (this.__step2 = document.createElement('span')),
        a.appendChild(this.__step2),
        this.__steps.appendChild(a),
        n.appendChild(this.__steps),
        (this.__joinTheClub = document.createElement('p')),
        n.appendChild(this.__joinTheClub),
        s.appendChild(n),
        (this._learnMore = new UTStandardButtonControl()),
        this._learnMore
          .getRootElement()
          .classList.add('ut-getting-started--button'),
        this._learnMore.getRootElement().classList.add('call-to-action'),
        s.appendChild(this._learnMore.getRootElement()),
        this.__bootBox.appendChild(s),
        t.appendChild(this.__bootBox),
        e.appendChild(t),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (views.bootFlow.GettingStarted.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__personaSelectorContainer = null),
      (this.__bootBox = null),
      this._futLogo.destroy(),
      (this.__infoTitle = null),
      (this.__description = null),
      (this.__steps = null),
      (this.__step1 = null),
      (this.__step2 = null),
      (this.__joinTheClub = null),
      this._learnMore.destroy();
  }),
  (views.bootFlow.GettingStarted.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (views.bootFlow.GettingStarted.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.bootFlow.GettingStarted.prototype.init = function init() {
    this.superclass(),
      this._learnMore.init(),
      this._learnMore.setText(
        services.Localization.localize('gettingstarted.learnmore')
      ),
      this._futLogo.init(),
      this._futLogo.loadImages();
  }),
  (views.bootFlow.GettingStarted.prototype.appendPersonaSelector = function appendPersonaSelector(
    e
  ) {
    this.addClass('has-persona-selector'),
      this.addSubview(e, this.__personaSelectorContainer);
  }),
  (views.bootFlow.GettingStarted.prototype.render = function render(e) {
    var t = '';
    switch (e) {
      case enums.GettingStartedTypes.ACCESS_TRIAL:
        t = 'gettingStartedFifa.contentTrial';
        break;
      case enums.GettingStartedTypes.FREE_TRIAL:
        t = 'gettingStartedFifa.freeTrial';
        break;
      case enums.GettingStartedTypes.FUT:
        t = 'gettingstarted.futcontent1';
        break;
      case enums.GettingStartedTypes.PLATFORM_SWITCH:
        t = 'gettingstarted.switchcontent1';
        break;
      case enums.GettingStartedTypes.PLATFORM_GEN3:
        t = 'gettingstarted.gen3content1';
        break;
      case enums.GettingStartedTypes.WEBSTART_OVER:
        t = 'webstartaccessover.text';
        break;
      default:
        t = 'gettingStartedFifa.content1';
    }
    (this.__description.textContent = services.Localization.localize(t)),
      e === enums.GettingStartedTypes.WEBSTART_OVER
        ? (this.__steps.parentNode.removeChild(this.__steps),
          (this.__infoTitle.textContent = services.Localization.localize(
            'gettingstarted.fifa'
          )),
          (this.__joinTheClub.textContent = services.Localization.localize(
            'gettingstarted.jointheclub'
          )))
        : (DOMKit.toggleDisplayStyle(this.__joinTheClub, !1),
          (this.__infoTitle.textContent = services.Localization.localize(
            'navbar.label.gettingstarted'
          )),
          e === enums.GettingStartedTypes.PLATFORM_SWITCH ||
          e === enums.GettingStartedTypes.PLATFORM_GEN3
            ? this.__steps.parentNode.removeChild(this.__steps)
            : e === enums.GettingStartedTypes.FUT
            ? ((this.__step1.textContent = services.Localization.localize(
                'gettingstarted.futstep1'
              )),
              (this.__step2.textContent = services.Localization.localize(
                'gettingstarted.futstep3'
              )))
            : ((this.__step1.textContent = services.Localization.localize(
                'gettingStartedFifa.content2'
              )),
              (this.__step2.textContent = services.Localization.localize(
                'gettingStartedFifa.content4'
              ))));
  }),
  (views.bootFlow.GettingStarted.prototype.getLearnMoreButton = function getLearnMoreButton() {
    return this._learnMore;
  }),
  utils.JS.inherits(UTGettingStartedViewController, UTViewController),
  (UTGettingStartedViewController.prototype.init = function init() {
    this.initialized ||
      (this.superclass(),
      this.getView()
        .getLearnMoreButton()
        .addTarget(this, this._eLearnMoreSelected, enums.Event.TAP),
      TelemetryManager.trackPage(
        TelemetryManager.Sections.LOGIN,
        'No FUT Data'
      ));
  }),
  (UTGettingStartedViewController.prototype.dealloc = function dealloc() {
    this.superclass(),
      utils.JS.isValid(this._personaController) &&
        (this._personaController.dealloc(), (this._personaController = null));
  }),
  (UTGettingStartedViewController.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new views.bootFlow.GettingStarted();
  }),
  (UTGettingStartedViewController.prototype.getNavigationTitle = function getNavigationTitle() {
    return services.Localization.localize('navbar.label.gettingstarted');
  }),
  (UTGettingStartedViewController.prototype.viewDidAppear = function viewDidAppear() {
    this.superclass();
    var e = this.getNavigationController();
    e && e.setNavigationVisibility(isPhone(), !0),
      this._personaController && this._personaController.viewDidAppear();
  }),
  (UTGettingStartedViewController.prototype.setType = function setType(e) {
    var t,
      i = !1;
    for (t in enums.GettingStartedTypes)
      if (
        enums.GettingStartedTypes.hasOwnProperty(t) &&
        enums.GettingStartedTypes[t] === e
      ) {
        i = !0;
        break;
      }
    if ((utils.Debug.Assert(i, 'Invalid getting started page type: ' + e), i)) {
      this._type = e;
      var s =
          services.Authentication.getFUTAuthState() ===
            enums.FUTAuthState.NO_DATA ||
          !services.User.getUser().getSelectedPersona().hasClubForCurrentYear,
        n = this._type !== enums.GettingStartedTypes.FIFA && !s;
      this.getView().render(this._type), n && this._generatePersonaController();
    }
  }),
  (UTGettingStartedViewController.prototype._generatePersonaController = function _generatePersonaController() {
    if (!this._personaController) {
      var e = this.getView();
      (this._personaController = new controllers.views.Persona()),
        this._personaController.init(),
        this.addChildViewController(this._personaController),
        e.appendPersonaSelector(this._personaController.getView()),
        e.layoutSubviews();
    }
  }),
  (UTGettingStartedViewController.prototype._eLearnMoreSelected = function _eLearnMoreSelected(
    e,
    t
  ) {
    var i;
    if (this._type !== enums.GettingStartedTypes.FIFA)
      switch (services.Localization.getLocale().region) {
        case enums.Region.USA:
          i = services.Localization.localize('link.gettingstartedfut.en_us');
          break;
        case enums.Region.CANADA:
          i = services.Localization.localize('link.gettingstartedfut.en_ca');
          break;
        case enums.Region.AUSTRALIA:
          i = services.Localization.localize('link.gettingstartedfut.en_au');
          break;
        default:
          i = services.Localization.localize('link.gettingstartedfut');
      }
    else i = services.Localization.localize('link.gettingstartedfifa');
    services.URL.process(i);
  }),
  utils.JS.inherits(UTLanguageTableCellView, UTTargetActionView),
  (UTLanguageTableCellView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('ut-language-table-cell-view'),
        (this.__name = document.createElement('span')),
        this.__name.classList.add('ut-language-table-cell-view--name'),
        e.appendChild(this.__name),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTLanguageTableCellView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__name = null);
  }),
  (UTLanguageTableCellView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTLanguageTableCellView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTLanguageTableCellView.prototype.init = function init() {
    this.superclass(), this.setInteractionState(!0);
  }),
  (UTLanguageTableCellView.prototype.setInteractionState = function setInteractionState(
    e
  ) {
    var t = this._interactionState;
    this.superclass(e),
      this._interactionState !== t &&
        this.toggleClass(enums.UIState.DISABLED, !this._interactionState);
  }),
  (UTLanguageTableCellView.prototype.setName = function setName(e) {
    this.__name.textContent = e;
  }),
  (UTLanguageTableCellView.prototype._mouseEnter = function _mouseEnter(e) {
    this.addClass(enums.UIState.HOVER);
  }),
  (UTLanguageTableCellView.prototype._mouseLeave = function _mouseLeave(e) {
    this.removeClass(enums.UIState.HOVER);
  }),
  (UTLanguageTableCellView.prototype._touchStarted = function _touchStarted(e) {
    this.superclass(e), this.addClass(enums.UIState.ACTIVE);
  }),
  (UTLanguageTableCellView.prototype._touchMoved = function _touchMoved(e) {
    this.superclass(e), this.removeClass(enums.UIState.ACTIVE);
  }),
  (UTLanguageTableCellView.prototype._touchEnded = function _touchEnded(e) {
    this.superclass(e), this.removeClass(enums.UIState.ACTIVE);
  }),
  (UTLanguageTableCellView.prototype._tapDetected = function _tapDetected(e) {
    this.superclass(e),
      this._triggerActions(enums.Event.TAP, {
        squad: this._squad
      });
  }),
  utils.JS.inherits(UTLanguageSelectView, UTTargetActionView),
  (UTLanguageSelectView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('ut-language-select'),
        e.classList.add('sm-ut-content-container'),
        e.classList.add('ut-content-container');
      var t = document.createElement('div');
      t.classList.add('ut-content');
      var i = document.createElement('div');
      i.classList.add('ut-language-select-content'),
        (this._futLogo = new views.bootFlow.FUTLogo()),
        i.appendChild(this._futLogo.getRootElement()),
        (this.__languageTable = document.createElement('div')),
        this.__languageTable.classList.add('ut-language-select--table'),
        i.appendChild(this.__languageTable),
        t.appendChild(i),
        e.appendChild(t),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTLanguageSelectView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._futLogo.destroy(),
      (this.__languageTable = null);
  }),
  (UTLanguageSelectView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTLanguageSelectView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTLanguageSelectView.prototype.init = function init() {
    this.superclass(),
      this._futLogo.init(),
      this._futLogo.loadImages(
        isPhone() ? enums.UIThemeVariation.LIGHT : enums.UIThemeVariation.DARK
      );
  }),
  (UTLanguageSelectView.prototype.dealloc = function dealloc() {
    this._clearLanguageCells(), this.superclass();
  }),
  (UTLanguageSelectView.prototype._clearLanguageCells = function _clearLanguageCells() {
    this._cells.forEach(function(e) {
      e.dealloc();
    }),
      (this._cells = []);
  }),
  (UTLanguageSelectView.prototype._generateLanguageCell = function _generateLanguageCell(
    e
  ) {
    var t = new UTLanguageTableCellView();
    t.init(),
      t.setName(e.name),
      t.addTarget(this, this._eLanguageSelected, enums.Event.TAP),
      this._cells.push(t),
      this.addSubview(t, this.__languageTable);
  }),
  (UTLanguageSelectView.prototype.setLocales = function setLocales(e) {
    this._clearLanguageCells(),
      e.forEach(this._generateLanguageCell, this),
      this.layoutSubviews();
  }),
  (UTLanguageSelectView.prototype._eLanguageSelected = function _eLanguageSelected(
    e,
    t,
    i
  ) {
    this._triggerActions(enums.Event.TAP, {
      index: this._cells.indexOf(e)
    });
  }),
  utils.JS.inherits(UTLanguageSelectViewController, UTViewController),
  (UTLanguageSelectViewController.prototype.init = function init() {
    this.superclass(),
      (this._locales = services.Localization.getSupportedLocales()),
      this.getView().addTarget(this, this._eLanguageSelected, enums.Event.TAP),
      TelemetryManager.trackPage(
        TelemetryManager.Sections.LOGIN,
        'Language Select'
      );
  }),
  (UTLanguageSelectViewController.prototype.dealloc = function dealloc() {
    (this._callback = null), (this._locales = []), this.superclass();
  }),
  (UTLanguageSelectViewController.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new UTLanguageSelectView();
  }),
  (UTLanguageSelectViewController.prototype.getNavigationTitle = function getNavigationTitle() {
    return services.Localization.localize('title.languageselect');
  }),
  (UTLanguageSelectViewController.prototype.viewDidAppear = function viewDidAppear() {
    this.superclass(), this.getView().setLocales(this._locales);
  }),
  (UTLanguageSelectViewController.prototype.setLanguageSelectCallback = function setLanguageSelectCallback(
    e
  ) {
    this._callback = e;
  }),
  (UTLanguageSelectViewController.prototype._selectLocale = function _selectLocale(
    e
  ) {
    gClickShield.showShield(components.ClickShield.SHIELD.LOADING),
      getStorage().setItem(STORAGE_LOCALE_KEY, e.toString()),
      services.Localization.setLocale(e),
      services.Localization.requestLocalization().observe(
        this,
        function _onRequestLocalizationComplete(e, t) {
          e.unobserve(this),
            utils.JS.isFunction(this._callback) && this._callback(),
            gClickShield.hideShield(components.ClickShield.SHIELD.LOADING);
        }
      );
  }),
  (UTLanguageSelectViewController.prototype._eLanguageSelected = function _eLanguageSelected(
    e,
    t,
    i
  ) {
    var s = this._locales[i.index];
    utils.Debug.Assert(
      utils.JS.isValid(s),
      'Missing data for selected language.'
    ),
      s && this._selectLocale(s);
  }),
  NamespaceManager.Register('views.bootFlow'),
  (views.bootFlow.License = function LicenseView() {
    UTTargetActionView.call(this),
      (this._cbLicenseImageLoad = null),
      this._generate();
  }),
  utils.JS.inherits(views.bootFlow.License, UTTargetActionView),
  (views.bootFlow.License.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('ut-license'),
        e.classList.add('sm-ut-content-container'),
        e.classList.add('ut-content-container');
      var t = document.createElement('div');
      t.classList.add('ut-content-center'), t.classList.add('ut-content');
      var i = document.createElement('div');
      i.classList.add('ut-license-content'),
        (this.__licenseLogo = document.createElement('img')),
        this.__licenseLogo.classList.add('licenseLogo'),
        i.appendChild(this.__licenseLogo),
        (this.__licenseTitle = document.createElement('h1')),
        this.__licenseTitle.classList.add('licenseTitle'),
        i.appendChild(this.__licenseTitle),
        (this.__licenseText1 = document.createElement('p')),
        this.__licenseText1.classList.add('licenseBody'),
        i.appendChild(this.__licenseText1),
        (this.__licenseText2 = document.createElement('p')),
        this.__licenseText2.classList.add('licenseBody'),
        i.appendChild(this.__licenseText2),
        t.appendChild(i),
        e.appendChild(t),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (views.bootFlow.License.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__licenseLogo = null),
      (this.__licenseTitle = null),
      (this.__licenseText1 = null),
      (this.__licenseText2 = null);
  }),
  (views.bootFlow.License.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (views.bootFlow.License.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.bootFlow.License.prototype.init = function init() {
    (this._cbLicenseImageLoad = this._eLicenseImageLoad.bind(this)),
      this.__licenseLogo.addEventListener(
        enums.Event.LOAD,
        this._cbLicenseImageLoad,
        !1
      ),
      (this.__licenseTitle.textContent = services.Localization.localize(
        'license.text.header'
      ).toUpperCase()),
      (this.__licenseText1.textContent = services.Localization.localize(
        'license.text.body1'
      )),
      (this.__licenseText2.textContent = services.Localization.localize(
        'license.text.body2'
      )),
      DOMKit.toggleDisplayStyle(this.__licenseLogo, !1),
      (this.__licenseLogo.src = utils.AssetLocator.getLicenseLogoURI(
        services.Localization.getLocale().language
      )),
      this.superclass();
  }),
  (views.bootFlow.License.prototype.dealloc = function dealloc() {
    this._clearLoadEventListener(), this.superclass();
  }),
  (views.bootFlow.License.prototype._clearLoadEventListener = function _clearLoadEventListener() {
    this._cbLicenseImageLoad &&
      (this.__licenseLogo.removeEventListener(
        enums.Event.LOAD,
        this._cbLicenseImageLoad,
        !1
      ),
      (this._cbLicenseImageLoad = null));
  }),
  (views.bootFlow.License.prototype._eLicenseImageLoad = function _eLicenseImageLoad(
    e
  ) {
    this._clearLoadEventListener(),
      DOMKit.addClass(this.__licenseLogo, 'fade-in-screen'),
      DOMKit.toggleDisplayStyle(this.__licenseLogo, !0),
      this._triggerActions(enums.Event.LOAD);
  }),
  utils.JS.inherits(UTLicenseViewController, UTViewController),
  (UTLicenseViewController.FLAGS = {
    TIMER: 1,
    MEMORY: 2
  }),
  (UTLicenseViewController.LOW_MEMORY_LIMIT = 25600),
  (UTLicenseViewController.prototype.init = function init() {
    this.superclass(),
      this.getView().addTarget(this, this._eLicenseImageLoad, enums.Event.LOAD);
    var e = getDefaultDispatcher();
    e.addObserver(enums.Notification.APP_PAUSE, this, this._nAppPaused),
      e.addObserver(enums.Notification.APP_RESUME, this, this._nAppResumed),
      TelemetryManager.trackPage(TelemetryManager.Sections.LOGIN, 'Legal');
  }),
  (UTLicenseViewController.prototype.dealloc = function dealloc() {
    clearTimeout(this._setTimerFlagTimeout);
    var e = getDefaultDispatcher();
    e.removeObserver(enums.Notification.APP_PAUSE, this),
      e.removeObserver(enums.Notification.APP_RESUME, this),
      this.superclass();
  }),
  (UTLicenseViewController.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new views.bootFlow.License();
  }),
  (UTLicenseViewController.prototype.getNavigationTitle = function getNavigationTitle() {
    return services.Localization.localize('gettingstarted.welcome');
  }),
  (UTLicenseViewController.prototype._eLicenseImageLoad = function _eLicenseImageLoad(
    e,
    t,
    i
  ) {
    this.checkFreeDiskSpace(), this._startDisplayTimer();
  }),
  (UTLicenseViewController.prototype._startDisplayTimer = function _startDisplayTimer() {
    clearTimeout(this._setTimerFlagTimeout),
      (this._setTimerFlagTimeout = setTimeout(
        this._setContinueFlag.bind(this, UTLicenseViewController.FLAGS.TIMER),
        3e3
      ));
  }),
  (UTLicenseViewController.prototype._checkFlagState = function _checkFlagState() {
    this._completedFlags ===
      (UTLicenseViewController.FLAGS.TIMER |
        UTLicenseViewController.FLAGS.MEMORY) &&
      (this._hasLowMemory
        ? utils.PopupManager.ShowAlert(
            utils.PopupManager.Alerts.LOW_MEMORY,
            this._transitionToLogin.bind(this)
          )
        : this._transitionToLogin());
  }),
  (UTLicenseViewController.prototype._setContinueFlag = function _setContinueFlag(
    e
  ) {
    utils.Debug.Assert(
      !(this._completedFlags & e),
      'Flag has already been set.'
    ),
      (this._completedFlags = this._completedFlags | e),
      this._checkFlagState();
  }),
  (UTLicenseViewController.prototype.checkFreeDiskSpace = function checkFreeDiskSpace() {
    function _onRetrieveFreeSpaceFail() {
      this._setContinueFlag(UTLicenseViewController.FLAGS.MEMORY);
    }
    isChrome()
      ? _onRetrieveFreeSpaceFail.call(this)
      : window.plugins.utilities.getFreeDiskSpace(
          function _onRetrieveFreeSpaceSuccess(e) {
            (this._hasLowMemory = e < UTLicenseViewController.LOW_MEMORY_LIMIT),
              this._setContinueFlag(UTLicenseViewController.FLAGS.MEMORY);
          }.bind(this),
          _onRetrieveFreeSpaceFail.bind(this)
        );
  }),
  (UTLicenseViewController.prototype._transitionToLogin = function _transitionToLogin() {
    getAppMain()
      .getRootViewController()
      .showLoginView();
  }),
  (UTLicenseViewController.prototype._nAppPaused = function _nAppPaused(
    e,
    t,
    i
  ) {
    clearTimeout(this._setTimerFlagTimeout);
  }),
  (UTLicenseViewController.prototype._nAppResumed = function _nAppResumed(
    e,
    t,
    i
  ) {
    this._completedFlags & UTLicenseViewController.FLAGS.TIMER ||
      this._startDisplayTimer();
  }),
  NamespaceManager.Register('views.bootFlow'),
  (views.bootFlow.Login = function UTLoginView() {
    UTView.call(this), this._generate();
  }),
  utils.JS.inherits(views.bootFlow.Login, UTView),
  (views.bootFlow.Login.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.setAttribute('id', 'Login'),
        e.classList.add('ut-login'),
        e.classList.add('sm-ut-content-container'),
        e.classList.add('ut-content-container');
      var t = document.createElement('div');
      t.classList.add('ut-content');
      var i = document.createElement('div');
      i.classList.add('ut-login-content'),
        (this._futLogo = new views.bootFlow.FUTLogo()),
        i.appendChild(this._futLogo.getRootElement()),
        (this._btnLogin = new UTStandardButtonControl()),
        this._btnLogin.getRootElement().classList.add('call-to-action'),
        i.appendChild(this._btnLogin.getRootElement()),
        (this._linkGettingStarted = new UTFlatButtonControl()),
        this._linkGettingStarted.getRootElement().classList.add('alt'),
        this._linkGettingStarted.getRootElement().classList.add('camel-case'),
        i.appendChild(this._linkGettingStarted.getRootElement()),
        t.appendChild(i),
        e.appendChild(t),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (views.bootFlow.Login.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._futLogo.destroy(),
      this._btnLogin.destroy(),
      this._linkGettingStarted.destroy();
  }),
  (views.bootFlow.Login.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (views.bootFlow.Login.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.bootFlow.Login.prototype.init = function init() {
    this.superclass(),
      this._btnLogin.init(),
      this._btnLogin.setText(
        services.Localization.localize('login.loginButtonText')
      ),
      this._linkGettingStarted.init(),
      this._linkGettingStarted.setText(
        services.Localization.localize('login.gettingstarted')
      ),
      this._linkGettingStarted.addTarget(
        this,
        this._eGettingStarted,
        enums.Event.TAP
      ),
      this._futLogo.init(),
      this._futLogo.loadImages(enums.UIThemeVariation.DARK);
  }),
  (views.bootFlow.Login.prototype.getLoginButton = function getLoginButton() {
    return this._btnLogin;
  }),
  (views.bootFlow.Login.prototype.enableLoginButton = function enableLoginButton(
    e
  ) {
    this._btnLogin.setInteractionState(e);
  }),
  (views.bootFlow.Login.prototype._eGettingStarted = function _eGettingStarted(
    e,
    t,
    i
  ) {
    services.URL.process(services.Localization.localize('link.gettingstarted'));
  }),
  (models.ShowOffLoginModel = function UTShowOffLoginModel() {
    models.LoginModel.call(this), (this._showOffDTO = null);
  }),
  utils.JS.inherits(models.ShowOffLoginModel, models.LoginModel),
  (models.ShowOffLoginModel.LOGIN_STEP = {
    EXTENDED_LOC: 0,
    PRE_LOAD_SQUAD: 1,
    LOAD_SQUAD: 2,
    SQUAD_SCREEN: 3
  }),
  (models.ShowOffLoginModel.prototype._runCurrentStep = function _runCurrentStep() {
    switch (this._currentLoginStep) {
      case models.ShowOffLoginModel.LOGIN_STEP.EXTENDED_LOC:
        this._getExtendedLocFile();
        break;
      case models.ShowOffLoginModel.LOGIN_STEP.PRE_LOAD_SQUAD:
        this._onPreLoadSquad();
        break;
      case models.ShowOffLoginModel.LOGIN_STEP.LOAD_SQUAD:
        this._getShowOffSquad();
        break;
      case models.ShowOffLoginModel.LOGIN_STEP.SQUAD_SCREEN:
        this._goToSquadScreen();
        break;
      default:
        utils.Debug.Assert(
          !1,
          '[models.ShowOffLoginModel] Invalid or unsupported bootflow step requested.'
        ),
          (this._isRunning = !1),
          utils.PopupManager.ShowAlert(
            utils.PopupManager.Alerts.ORIGIN_UNAVAILABLE,
            this.logout.bind(this)
          ),
          gClickShield.hideShield(components.ClickShield.SHIELD.LOADING);
    }
  }),
  (models.ShowOffLoginModel.prototype._onPreLoadSquad = function _onPreLoadSquad() {
    function _onStaticDataRequestFail() {
      (this._isRunning = !1),
        utils.PopupManager.ShowAlert(
          utils.PopupManager.Alerts.ORIGIN_UNAVAILABLE,
          this.logout.bind(this)
        ),
        gClickShield.hideShield(components.ClickShield.SHIELD.LOADING);
    }

    function _onRequestSquadDataComplete(e, t) {
      e.unobserve(this),
        t.success ? this._runNextStep() : _onStaticDataRequestFail.call(this);
    }

    function _onGetRarityComplete(e, t) {
      e.unobserve(this),
        t.success
          ? services.Configuration.requestSquadData().observe(
              this,
              _onRequestSquadDataComplete
            )
          : _onStaticDataRequestFail.call(this);
    }

    function _onMissingImagesDataRequested(e, t) {
      e.unobserve(this),
        t.success
          ? services.Configuration.loadRarityData().observe(
              this,
              _onGetRarityComplete
            )
          : _onStaticDataRequestFail.call(this);
    }

    function _onPlayerIconDataRequested(e, t) {
      e.unobserve(this),
        t.success
          ? services.Configuration.requestMissingImagesData().observe(
              this,
              _onMissingImagesDataRequested
            )
          : _onStaticDataRequestFail.call(this);
    }

    function _onPlayerMetaDataRequested(e, t) {
      e.unobserve(this),
        t.success
          ? services.Configuration.requestPlayerIconData().observe(
              this,
              _onPlayerIconDataRequested
            )
          : _onStaticDataRequestFail.call(this);
    }

    function _onStaticPlayerDataRequested(e, t) {
      e.unobserve(this),
        t.success
          ? services.Configuration.requestPlayerMetaData().observe(
              this,
              _onPlayerMetaDataRequested
            )
          : _onStaticDataRequestFail.call(this);
    }
    services.Configuration.requestTeamConfig().observe(
      this,
      function _onTeamConfigRequested(e, t) {
        e.unobserve(this),
          t.success
            ? services.Configuration.requestStaticPlayerData().observe(
                this,
                _onStaticPlayerDataRequested
              )
            : _onStaticDataRequestFail.call(this);
      }
    );
  }),
  (models.ShowOffLoginModel.prototype._getShowOffSquad = function _getShowOffSquad() {
    services.Squad.loadShowOffSquad().observe(this, function(e, t) {
      (e.unobserve(this), t.success)
        ? ((this._showOffDTO = t.data.showOff), this._runNextStep())
        : (window.location.search.substring(1).length &&
            void 0 !== window.history &&
            void 0 !== window.history.pushState &&
            window.history.pushState(
              {},
              document.title,
              window.location.pathname
            ),
          (this._isRunning = !1),
          gClickShield.hideShield(components.ClickShield.SHIELD.LOADING));
    });
  }),
  (models.ShowOffLoginModel.prototype._goToSquadScreen = function _goToSquadScreen() {
    (this._isRunning = !1),
      getAppMain()
        .getRootViewController()
        .showSharedSquadView(this._showOffDTO),
      gClickShield.hideShield(components.ClickShield.SHIELD.LOADING);
  }),
  (models.ShowOffLoginModel.prototype.logout = function logout() {
    utils.Debug.Assert(
      !this._isRunning,
      '[LOGIN] Attempted to logout when a login/logout request is already running.'
    ),
      this._isRunning || this._resetApp();
  }),
  utils.JS.inherits(UTLoginViewController, UTViewController),
  (UTLoginViewController.IOS_STATUS_BAR_STYLE = {
    DEFAULT: 0,
    BLACK: 1
  }),
  (UTLoginViewController.prototype.init = function init() {
    this.superclass(),
      eadp.identity.setConnectHost(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_EADP_CONNECT_HOST
        )
      ),
      eadp.identity.setPortalHost(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_EADP_PORTAL_HOST
        )
      ),
      eadp.identity.setProxyHost(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_EADP_PROXY_HOST
        )
      ),
      eadp.identity.setClientId(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_EADP_CLIENT_ID
        )
      ),
      eadp.identity.setClientSecret(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_EADP_CLIENT_SECRET
        )
      ),
      eadp.identity.setLocale(
        services.Localization.getLocale().toEANetworkString()
      ),
      eadp.identity.setDeviceId(getUUID()),
      eadp.identity.setReleaseType(
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_RELEASE_TYPE
        )
      );
    var e = window.location.href,
      t = utils.HTTP.getParamsFromUrl(e),
      i = utils.HTTP.getUriRoot(e),
      s = services.URL.findValidDeepLinkID(t.keys());
    s !== enums.DeepLinkSections.NONE &&
      (services.URL.setDeepLinkURL(s, t.get(s)),
      getStorage().setItem(
        STORAGE_DEEP_LINK_KEY,
        services.URL.getDeepLinkURL()
      )),
      (i = i.replace(/\/$/, '') + '/auth.html'),
      eadp.identity.setRedirectUri(i),
      this.getView()
        .getLoginButton()
        .addTarget(this, this._eLoginSelected, enums.Event.TAP),
      TelemetryManager.trackPage(TelemetryManager.Sections.LOGIN, 'Login');
  }),
  (UTLoginViewController.prototype.dealloc = function dealloc() {
    this.superclass();
  }),
  (UTLoginViewController.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new views.bootFlow.Login();
  }),
  (UTLoginViewController.prototype.getNavigationTitle = function getNavigationTitle() {
    return services.Localization.localize('navbar.label.loginfut');
  }),
  (UTLoginViewController.prototype.viewDidAppear = function viewDidAppear() {
    var e = function() {
        console.log('[controllers.LoginController] Unable to auto-login.'),
          this.getView().enableLoginButton(!0);
      }.bind(this),
      t = function() {
        eadp.identity.getUserInfo(
          this._onEadpUserInfoSuccess.bind(this),
          this._onEadpUserInfoFail.bind(this)
        );
      }.bind(this);
    services.Squad.hasExternalShowOffSquad()
      ? this._startUnauthenticatedLoginFlow()
      : isWeb()
      ? (this.getView().enableLoginButton(!1),
        eadp.identity.getAccessToken()
          ? t()
          : eadp.identity.checkEADPAuth(t, e))
      : eadp.identity.isAuthenticated(
          function() {
            console.log('LOGIN: Attempting to auto-authenticate...'),
              this.getView().enableLoginButton(!1),
              eadp.identity.checkEADPAuth(t, e);
          }.bind(this)
        ),
      getDefaultDispatcher().addObserver(
        enums.Notification.APP_RESUME,
        this,
        this._nAppResumed
      );
  }),
  (UTLoginViewController.prototype.viewWillDisappear = function viewWillDisappear() {
    this.superclass(),
      getDefaultDispatcher().removeObserver(
        enums.Notification.APP_RESUME,
        this
      );
  }),
  (UTLoginViewController.prototype._startUnauthenticatedLoginFlow = function _startUnauthenticatedLoginFlow() {
    var e = getAppMain();
    e.setLoginController(new models.ShowOffLoginModel()),
      e.getLoginController().login();
  }),
  (UTLoginViewController.prototype._onEadpLoginComplete = function _onEadpLoginComplete() {
    eadp.identity.getUserInfo(
      this._onEadpUserInfoSuccess.bind(this),
      this._onEadpUserInfoFail.bind(this)
    );
  }),
  (UTLoginViewController.prototype._onEadpUserInfoFail = function _onEadpUserInfoFail(
    e
  ) {
    return e === eadp.identity.error.LOCAL_STORAGE
      ? (utils.Debug.Assert(
          !1,
          '[controllers.LoginController] Unable to save EADP Identity data in local storage.'
        ),
        void this.getView().enableLoginButton(!0))
      : e === eadp.identity.error.REFRESH_TOKEN
      ? (console.log('LOGIN: EADP requires a login refresh.'),
        void this.getView().enableLoginButton(!0))
      : e === eadp.identity.error.SERVER
      ? (console.log('LOGIN: An unknown EADP server error occurred.'),
        void this.getView().enableLoginButton(!0))
      : void 0;
  }),
  (UTLoginViewController.prototype._onEadpUserInfoSuccess = function _onEadpUserInfoSuccess(
    e
  ) {
    var t = getAppMain();
    t.setLoginController(new models.LoginModel()),
      services.User.setCurrent(new entities.User(e)),
      gUserSettingsModel.setUserKey(e.pidId.toString()),
      isChrome() ||
        window.plugins.utilities.registerNimble(
          e.pidId,
          getStorage().getItem(STORAGE_PN_STATUS_KEY),
          function() {},
          function() {}
        ),
      t.getLoginController().login();
  }),
  (UTLoginViewController.prototype._eLoginSelected = function _eLoginSelected(
    e,
    t
  ) {
    gClientUpdate.disablePolling(),
      TelemetryManager.trackEvent(
        TelemetryManager.Sections.LOGIN,
        TelemetryManager.Categories.BUTTON_PRESS,
        'Login'
      ),
      this.getView().enableLoginButton(!1),
      this.createLoginView();
  }),
  (UTLoginViewController.prototype.createLoginView = function createLoginView() {
    if (hasConnection())
      if (isChrome())
        eadp.identity.initiateLoginFlow(
          'Login',
          this.onAccessTokenSuccess.bind(this),
          this.onAccessTokenFail.bind(this)
        );
      else {
        var e = eadp.identity.getLoginUrl();
        window.console.log('Opening EADP: ' + e),
          (this._inAppBrowser = window.open(e, '_blank', 'location=no')),
          (this._successCallbackDelegate = this.iabLoadStart.bind(this)),
          (this._errorCallbackDelegate = this.iabLoadError.bind(this)),
          (this._browserDismissedCallbackDelegate = this.iabExit.bind(this)),
          (this._linkCallbackDelegate = this.iabLoadStop.bind(this)),
          this._inAppBrowser.addEventListener(
            'loadstart',
            this._successCallbackDelegate,
            !1
          ),
          this._inAppBrowser.addEventListener(
            'loadstart',
            this._linkCallbackDelegate,
            !1
          ),
          this._inAppBrowser.addEventListener(
            'loadstop',
            this._linkCallbackDelegate,
            !1
          ),
          this._inAppBrowser.addEventListener(
            'loaderror',
            this._errorCallbackDelegate,
            !1
          ),
          this._inAppBrowser.addEventListener(
            'exit',
            this._browserDismissedCallbackDelegate,
            !1
          );
      }
    else
      utils.PopupManager.ShowAlert(
        utils.PopupManager.Alerts.ORIGIN_UNAVAILABLE,
        function() {
          this.getView().enableLoginButton(!0);
        }.bind(this)
      );
  }),
  (UTLoginViewController.prototype.closeLoginView = function closeLoginView() {
    this.isLoginViewOpen() &&
      (this._inAppBrowser.removeEventListener(
        'loadstart',
        this._successCallbackDelegate,
        !1
      ),
      this._inAppBrowser.removeEventListener(
        'loadstart',
        this._linkCallbackDelegate,
        !1
      ),
      this._inAppBrowser.removeEventListener(
        'loadstop',
        this._linkCallbackDelegate,
        !1
      ),
      this._inAppBrowser.removeEventListener(
        'loaderror',
        this._errorCallbackDelegate,
        !1
      ),
      this._inAppBrowser.removeEventListener(
        'exit',
        this._browserDismissedCallbackDelegate,
        !1
      ),
      (this._successCallbackDelegate = null),
      (this._errorCallbackDelegate = null),
      (this._browserDismissedCallbackDelegate = null),
      this._inAppBrowser.close(),
      (this._inAppBrowser = null),
      gClientUpdate.pollForUpdates(function() {
        getAppMain()
          .getRootViewController()
          .showClientUpdateView();
      }));
  }),
  (UTLoginViewController.prototype.iabLoadStart = function iabLoadStart(e) {
    if (
      eadp.identity.isErrorPattern(
        e.url,
        '/p/mobile/fifa/companion/code',
        'code'
      )
    )
      getAppMain()
        .getLoginController()
        .logout(),
        this.closeLoginView(),
        this.getView().enableLoginButton(!0);
    else if (e.url && -1 !== e.url.indexOf('code=')) {
      this.closeLoginView();
      var t = e.url.split('code=')[1].split('&')[0];
      eadp.identity.exchangeAccessToken(
        t,
        this.onAccessTokenSuccess.bind(this),
        this.onAccessTokenFail.bind(this)
      );
    }
  }),
  (UTLoginViewController.prototype.iabLoadStop = function iabLoadStop(e) {
    eadp.identity.isExternalLink(e.url) &&
      (this.closeLoginView(),
      this.getView().enableLoginButton(!0),
      (this._recreateOnResume = !0),
      services.URL.process(e.url));
  }),
  (UTLoginViewController.prototype.iabLoadError = function iabLoadError(e) {
    utils.PopupManager.ShowAlert(
      utils.PopupManager.Alerts.ORIGIN_UNAVAILABLE,
      this.iabExit.bind(this)
    );
  }),
  (UTLoginViewController.prototype.iabExit = function iabExit(e) {
    this.closeLoginView(), this.getView().enableLoginButton(!0);
  }),
  (UTLoginViewController.prototype.onAccessTokenSuccess = function onAccessTokenSuccess(
    e
  ) {
    isChrome() && eadp.identity.closeLoginFlow(), this._onEadpLoginComplete();
  }),
  (UTLoginViewController.prototype.onAccessTokenFail = function onAccessTokenFail(
    e
  ) {
    console.log('access token failure!'), this._onEadpLoginComplete();
  }),
  (UTLoginViewController.prototype.isLoginViewOpen = function isLoginViewOpen() {
    return utils.JS.isValid(this._inAppBrowser);
  }),
  (UTLoginViewController.prototype._nAppResumed = function _nAppResumed(
    e,
    t,
    i
  ) {
    services.Squad.hasExternalShowOffSquad()
      ? (this.isLoginViewOpen() &&
          (this.closeLoginView(), this.getView().enableLoginButton(!0)),
        this._startUnauthenticatedLoginFlow())
      : this._recreateOnResume &&
        ((this._recreateOnResume = !1),
        this.getView().enableLoginButton(!1),
        this.createLoginView());
  }),
  NamespaceManager.Register('views.bootFlow'),
  (views.bootFlow.LoggedOnConsole = function UTLoggedOnConsoleView() {
    UTView.call(this),
      (this.onRetryTap = new UTObservable()),
      Object.defineProperty(this, 'onImageLoaded', {
        writable: !1
      }),
      this._generate();
  }),
  utils.JS.inherits(views.bootFlow.LoggedOnConsole, UTView),
  (views.bootFlow.LoggedOnConsole.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('sm-ut-content-container'),
        e.classList.add('ut-content-container');
      var t = document.createElement('div');
      t.classList.add('ut-content'),
        (this.__personaSelectorContainer = document.createElement('div')),
        this.__personaSelectorContainer.classList.add(
          'ut-app-settings-persona-selector'
        ),
        t.appendChild(this.__personaSelectorContainer);
      var i = document.createElement('div');
      i.classList.add('ut-logged-on-console'),
        i.classList.add('ut-login-generic');
      var s = document.createElement('div');
      s.classList.add('ut-login-generic-content');
      var n = document.createElement('div');
      (this.__longOnTitle = document.createElement('h2')),
        n.appendChild(this.__longOnTitle),
        (this.__message1 = document.createElement('p')),
        n.appendChild(this.__message1),
        (this.__message2 = document.createElement('p')),
        n.appendChild(this.__message2),
        (this._btnRetry = new UTStandardButtonControl()),
        this._btnRetry.getRootElement().classList.add('call-to-action'),
        n.appendChild(this._btnRetry.getRootElement()),
        s.appendChild(n),
        i.appendChild(s),
        t.appendChild(i),
        e.appendChild(t),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (views.bootFlow.LoggedOnConsole.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__personaSelectorContainer = null),
      (this.__longOnTitle = null),
      (this.__message1 = null),
      (this.__message2 = null),
      this._btnRetry.destroy();
  }),
  (views.bootFlow.LoggedOnConsole.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (views.bootFlow.LoggedOnConsole.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (views.bootFlow.LoggedOnConsole.prototype.init = function init() {
    this.superclass(),
      (this.__longOnTitle.textContent = services.Localization.localize(
        'signedontoanotherdevice.title'
      )),
      (this.__message1.textContent = services.Localization.localize(
        'signedontoanotherdevice.message1'
      )),
      (this.__message2.textContent = services.Localization.localize(
        'signedontoanotherdevice.message2'
      )),
      this._btnRetry.init(),
      this._btnRetry.setText(
        services.Localization.localize('common.dialog.retry')
      ),
      this._btnRetry.addTarget(
        this.onRetryTap,
        this.onRetryTap.notify,
        enums.Event.TAP
      );
  }),
  (views.bootFlow.LoggedOnConsole.prototype.appendPersonaSelector = function appendPersonaSelector(
    e
  ) {
    this.addClass('has-persona-selector'),
      this.addSubview(e, this.__personaSelectorContainer);
  }),
  utils.JS.inherits(UTLoggedOnConsoleViewController, UTViewController),
  (UTLoggedOnConsoleViewController.prototype.init = function init() {
    this.superclass();
    var e = this.getView();
    e.onRetryTap.observe(this, this._onRetryAuth),
      (this._personaController = new controllers.views.Persona()),
      this._personaController.init(),
      this.addChildViewController(this._personaController),
      e.appendPersonaSelector(this._personaController.getView()),
      e.layoutSubviews(),
      TelemetryManager.trackPage(
        TelemetryManager.Sections.LOGIN,
        'Logged in on Console'
      );
  }),
  (UTLoggedOnConsoleViewController.prototype.dealloc = function dealloc() {
    this.superclass(),
      this._personaController &&
        (this._personaController.dealloc(), (this._personaController = null));
  }),
  (UTLoggedOnConsoleViewController.prototype._getViewInstanceFromData = function _getViewInstanceFromData() {
    return new views.bootFlow.LoggedOnConsole();
  }),
  (UTLoggedOnConsoleViewController.prototype.getNavigationTitle = function getNavigationTitle() {
    return services.Localization.localize('signedontoanotherdevice.title');
  }),
  (UTLoggedOnConsoleViewController.prototype.viewDidAppear = function viewDidAppear() {
    this.superclass();
    var e = this.getNavigationController();
    e && e.setNavigationVisibility(isPhone(), !0),
      this._personaController && this._personaController.viewDidAppear();
  }),
  (UTLoggedOnConsoleViewController.prototype._onRetryAuth = function _onRetryAuth() {
    this.getView().setInteractionState(!1),
      getAppMain()
        .getLoginController()
        .login(!0);
  }),
  utils.JS.inherits(UTDropDownControl, UTControl),
  (UTDropDownControl.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('inline-list-select'),
        e.classList.add('ut-drop-down-control'),
        (this.__animatedContainer = document.createElement('div')),
        this.__animatedContainer.classList.add('inline-container'),
        (this.__label = document.createElement('span')),
        this.__label.classList.add('label'),
        this.__animatedContainer.appendChild(this.__label),
        e.appendChild(this.__animatedContainer),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTDropDownControl.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__animatedContainer = null),
      (this.__label = null);
  }),
  (UTDropDownControl.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTDropDownControl.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTDropDownControl.prototype.init = function init() {
    this.superclass();
    var e = this.getDropDownElement();
    this._addListener(enums.Event.CHANGE, e, this._handleChange.bind(this)),
      isPhone()
        ? this.__animatedContainer.appendChild(e)
        : ((this._windowListener = this._windowClick.bind(this)),
          (this.__list = document.createElement('ul')),
          DOMKit.addClass(this.__list, 'inline-list'),
          this._startHandlingEvents(this.__animatedContainer));
  }),
  (UTDropDownControl.prototype.dealloc = function dealloc() {
    this._removeListenersByName(enums.Event.CHANGE),
      this._removeWindowListener(),
      getKeyboardEventController().unregisterDelegate(
        this,
        UTKeyboardEventController.PRIORITY.ACTIVE_ELEMENT
      ),
      (this._options = []),
      (this._windowListener = null),
      (this.__list = null),
      (this.__picker = null),
      this.superclass();
  }),
  (UTDropDownControl.prototype.setInteractionState = function setInteractionState(
    e
  ) {
    if (this._setInteractionStateFlag(e))
      if ((this.toggleClass(enums.UIState.DISABLED, !e), this.__list))
        this._interactionState
          ? this._startHandlingEvents(this.__animatedContainer)
          : this._stopHandlingEvents();
      else {
        var t = this.getDropDownElement();
        e ||
          t !== document.activeElement ||
          t.dispatchEvent(utils.JS.createEvent('blur')),
          (t.disabled = !e);
      }
  }),
  (UTDropDownControl.prototype._requiresFlip = function _requiresFlip() {
    return (
      !!this.__list &&
      window.innerHeight <
        this.getRootElement().getBoundingClientRect().bottom +
          this.__list.clientHeight
    );
  }),
  (UTDropDownControl.prototype._open = function _open() {
    !this._isOpen &&
      this.__list &&
      ((this._isOpen = !0),
      this.__animatedContainer.appendChild(this.__list),
      this._requiresFlip() &&
        (this.__animatedContainer.insertBefore(
          this.__list,
          this.__animatedContainer.children.item(0)
        ),
        (this.__animatedContainer.style.top =
          '-' + this.__list.clientHeight.toString() + 'px'),
        this.addClass(enums.UIDirection.FLIP_VERTICAL)),
      DOMKit.addClass(
        this.__list.children[this.getDropDownElement().selectedIndex],
        enums.UIState.SELECTED
      ),
      this._scrollToSelected(),
      this.addClass('is-open'),
      this._addWindowListener(),
      getKeyboardEventController().registerDelegate(
        this,
        UTKeyboardEventController.PRIORITY.ACTIVE_ELEMENT
      ));
  }),
  (UTDropDownControl.prototype._close = function _close() {
    this._isOpen &&
      this.__list &&
      ((this._isOpen = !1),
      this._removeWindowListener(),
      getKeyboardEventController().unregisterDelegate(
        this,
        UTKeyboardEventController.PRIORITY.ACTIVE_ELEMENT
      ),
      (this.__animatedContainer.style.top = '0px'),
      DOMKit.remove(this.__list),
      this.removeClass(['is-open', enums.UIDirection.FLIP_VERTICAL].join(' ')));
  }),
  (UTDropDownControl.prototype._addWindowListener = function _addWindowListener() {
    this._removeWindowListener(),
      requestAnimationFrame(
        function() {
          window.addEventListener(enums.Event.CLICK, this._windowListener, !1),
            window.addEventListener(
              enums.Event.TOUCHEND,
              this._windowListener,
              !1
            );
        }.bind(this)
      );
  }),
  (UTDropDownControl.prototype._removeWindowListener = function _removeWindowListener() {
    window.removeEventListener(enums.Event.CLICK, this._windowListener, !1),
      window.removeEventListener(
        enums.Event.TOUCHEND,
        this._windowListener,
        !1
      );
  }),
  (UTDropDownControl.prototype._scrollToSelected = function _scrollToSelected() {
    var e = this.__list.children.item(this.getDropDownElement().selectedIndex);
    e && (this.__list.scrollTop = e.offsetTop);
  }),
  (UTDropDownControl.prototype._windowClick = function _windowClick(e) {
    ('li' === e.target.nodeName.toLowerCase() &&
      e.target.parentNode === this.__list) ||
      this._close();
  }),
  (UTDropDownControl.prototype.getDropDownElement = function getDropDownElement() {
    return (
      this.__picker || (this.__picker = document.createElement('select')),
      this.__picker
    );
  }),
  (UTDropDownControl.prototype.getEnabled = function getEnabled() {
    return this.isInteractionEnabled();
  }),
  (UTDropDownControl.prototype.setEnabled = function setEnabled(e) {
    (e = !!e), this.setInteractionState(e);
  }),
  (UTDropDownControl.prototype._generateWebOptionElement = function _generateWebOptionElement(
    e
  ) {
    var t = document.createElement('li');
    return (t.textContent = e.label), t;
  }),
  (UTDropDownControl.prototype.setOptions = function setOptions(e) {
    Array.isArray(e) &&
      ((this._options = e),
      this._generateNativeOptions(),
      (this.__label.textContent = this.getLabel()),
      this.__list &&
        (DOMKit.empty(this.__list),
        e.forEach(function(e) {
          this.__list.appendChild(this._generateWebOptionElement(e));
        }, this))),
      this.removeClass(['is-open', enums.UIDirection.FLIP_VERTICAL].join(' '));
  }),
  (UTDropDownControl.prototype.getOptions = function getOptions() {
    return this._options.slice();
  }),
  (UTDropDownControl.prototype.setIndex = function setIndex(e) {
    var t = this.getDropDownElement();
    if (utils.JS.isNumber(e) && t.selectedIndex !== e) {
      if (this.__list) {
        var i = this.__list.children.item(t.selectedIndex),
          s = this.__list.children.item(e);
        i && DOMKit.removeClass(i, enums.UIState.SELECTED),
          s && DOMKit.addClass(s, enums.UIState.SELECTED);
      }
      (t.selectedIndex = e), t.dispatchEvent(utils.JS.createEvent('change'));
    }
  }),
  (UTDropDownControl.prototype.getIndex = function getIndex() {
    return this.getDropDownElement().selectedIndex;
  }),
  (UTDropDownControl.prototype.setIndexById = function setIndexById(e) {
    for (var t = this._options.length; 0 < t--; )
      if (this._options[t].id === e) {
        this.setIndex(t);
        break;
      }
  }),
  (UTDropDownControl.prototype.setIndexByValue = function setIndexByValue(e) {
    for (var t = this._options.length; 0 < t--; )
      if (this._options[t].value === e) return this.setIndex(t), !0;
    return !1;
  }),
  (UTDropDownControl.prototype.setDefaultIndexById = function setDefaultIndexById(
    e,
    t
  ) {
    for (var i = this._options.length; 0 < i--; )
      if (this._options[i].id === e)
        return (this._defaultIndex = i), t && this.setIndex(i), !0;
    return !1;
  }),
  (UTDropDownControl.prototype.setDefaultIndexByValue = function setDefaultIndexByValue(
    e,
    t
  ) {
    for (var i = this._options.length; 0 < i--; )
      if (this._options[i].value === e) {
        (this._defaultIndex = i), t && this.setIndex(i);
        break;
      }
  }),
  (UTDropDownControl.prototype.getDefaultIndex = function getDefaultIndex() {
    return this._defaultIndex;
  }),
  (UTDropDownControl.prototype.getLabel = function getLabel() {
    var e = this._options[this.getIndex()];
    return e ? e.label : '';
  }),
  (UTDropDownControl.prototype.getId = function getId() {
    var e = this._options[this.getIndex()];
    return e ? e.id : -1;
  }),
  (UTDropDownControl.prototype.getValue = function getValue() {
    var e = this._options[this.getIndex()];
    return e ? e.value : '';
  }),
  (UTDropDownControl.prototype.blur = function blur() {
    var e = this.getDropDownElement();
    e === document.activeElement && e.blur();
  }),
  (UTDropDownControl.prototype.focus = function focus() {
    var e = this.getDropDownElement();
    e !== document.activeElement && e.focus();
  }),
  (UTDropDownControl.prototype._handleDropdownSearch = function _handleDropdownSearch(
    e
  ) {
    0 < this._searchTimeout && clearTimeout(this._searchTimeout),
      (this._searchTimeout = setTimeout(
        function _resetSearch() {
          (this._searchTimeout = 0), (this._searchString = '');
        }.bind(this),
        1e3
      ));
    var i = (this._searchString += e),
      t = DOMKit.HTMLCollectionToArray(this.__list.childNodes),
      s = utils.JS.find(t, function(e) {
        var t = getComputedStyle(e);
        return (
          'none' !== t.display &&
          'visible' === t.visibility &&
          0 ===
            e.textContent
              .trim()
              .toLowerCase()
              .indexOf(i.trim().toLowerCase())
        );
      });
    s && (this.__list.scrollTop = s.offsetTop);
  }),
  (UTDropDownControl.prototype.handleKeyUpEvent = function handleKeyUpEvent(e) {
    /^[a-zA-Z0-9 ]$/.test(e.key) &&
      this._handleDropdownSearch(e.key.toString());
  }),
  (UTDropDownControl.prototype._handleChange = function _handleChange(e) {
    this.isInteractionEnabled() &&
      ((this.__label.textContent = this.getLabel()),
      this._triggerActions(enums.Event.CHANGE, {
        index: this.getIndex(),
        id: this.getId(),
        value: this.getValue()
      }));
  }),
  (UTDropDownControl.prototype._handleFocus = function _handleFocus(e) {
    this.enabled &&
      !this._shieldShowing &&
      ((this._shieldShowing = !0),
      gClickShield.showShield(components.ClickShield.SHIELD.FULL));
  }),
  (UTDropDownControl.prototype._handleBlur = function _handleBlur(e) {
    this._shieldShowing &&
      (gClickShield.hideShield(components.ClickShield.SHIELD.FULL),
      (this._shieldShowing = !1));
  }),
  (UTDropDownControl.prototype._touchStarted = function _touchStarted(e) {
    this.enabled &&
      requestAnimationFrame(
        function() {
          this.addClass(enums.UIState.ACTIVE);
        }.bind(this)
      );
  }),
  (UTDropDownControl.prototype._touchMoved = function _touchMoved(e) {
    requestAnimationFrame(
      function() {
        this.removeClass(enums.UIState.ACTIVE);
      }.bind(this)
    );
  }),
  (UTDropDownControl.prototype._touchEnded = function _touchEnded(e) {
    requestAnimationFrame(
      function() {
        this.removeClass(enums.UIState.ACTIVE);
      }.bind(this)
    );
  }),
  (UTDropDownControl.prototype._tapDetected = function _tapDetected(e) {
    if (this.isInteractionEnabled() && this.__list) {
      var t = e.target.nodeName.toLowerCase();
      if ('ul' !== t)
        if ('li' === t) {
          var i = DOMKit.HTMLCollectionToArray(this.__list.children);
          this.setIndex(i.indexOf(e.target)), this._close();
        } else this._isOpen ? this._close() : this._open();
    }
  }),
  (UTDropDownControl.prototype._mouseLeave = function _mouseLeave(e) {
    this.removeClass(enums.UIState.HOVER);
  }),
  (UTDropDownControl.prototype._mouseEnter = function _mouseEnter(e) {
    this.addClass(enums.UIState.HOVER);
  }),
  (UTDropDownControl.prototype._generateNativeOptions = function _generateNativeOptions() {
    var i = this.getDropDownElement();
    DOMKit.empty(i),
      this._options.forEach(function _generateOptionElement(e) {
        var t = document.createElement('option');
        (t.value = e.value), (t.textContent = e.label), i.appendChild(t);
      }, this),
      this.setIndex(this._defaultIndex);
  }),
  utils.JS.inherits(UTSearchFilterControl, UTDropDownControl),
  (UTSearchFilterControl.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('inline-list-select'),
        e.classList.add('ut-search-filter-control'),
        (this.__animatedContainer = document.createElement('div')),
        this.__animatedContainer.classList.add('inline-container');
      var t = document.createElement('div');
      t.classList.add('ut-search-filter-control--row'),
        (this.__filterImage = document.createElement('img')),
        this.__filterImage.classList.add('ut-search-filter-control--row-image'),
        t.appendChild(this.__filterImage),
        (this.__label = document.createElement('span')),
        this.__label.classList.add('label'),
        t.appendChild(this.__label),
        (this._clearBtn = new UTFlatButtonControl()),
        this._clearBtn
          .getRootElement()
          .classList.add('ut-search-filter-control--row-button'),
        t.appendChild(this._clearBtn.getRootElement()),
        this.__animatedContainer.appendChild(t),
        e.appendChild(this.__animatedContainer),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTSearchFilterControl.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__animatedContainer = null),
      (this.__filterImage = null),
      (this.__label = null),
      this._clearBtn.destroy();
  }),
  (UTSearchFilterControl.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTSearchFilterControl.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTSearchFilterControl.prototype.init = function init() {
    this.superclass(),
      this._clearBtn.init(),
      this._clearBtn.addTarget(this, this._onClear, enums.Event.TAP);
  }),
  (UTSearchFilterControl.prototype.dealloc = function dealloc() {
    (this._iconTable = null), this.superclass();
  }),
  (UTSearchFilterControl.prototype._generateWebOptionElement = function _generateWebOptionElement(
    e
  ) {
    var t = utils.JS.isValid(this._iconTable),
      i = document.createElement('li');
    if (((i.textContent = e.label), t)) {
      var s = this._iconTable.get(e.value);
      utils.JS.isEmpty(s) ||
        (DOMKit.addClass(i, 'with-icon'),
        (i.style.backgroundImage = "url('" + s + "')"));
    }
    return i;
  }),
  (UTSearchFilterControl.prototype.setOptions = function setOptions(e) {
    this.superclass(e),
      this.removeClass('has-selection'),
      0 === this.getIndex() &&
        this._hasDefault &&
        (this.__label.textContent = this._defaultLabel);
  }),
  (UTSearchFilterControl.prototype.getImage = function getImage() {
    return this.__filterImage.getAttribute('src');
  }),
  (UTSearchFilterControl.prototype.setImage = function setImage(e) {
    var t = utils.JS.isEmpty(e);
    this.toggleClass('has-image', !t),
      t || this.__filterImage.setAttribute('src', e);
  }),
  (UTSearchFilterControl.prototype.setDefaultLabel = function setDefaultLabel(
    e
  ) {
    (this._defaultLabel = e),
      0 === this.getIndex() &&
        this._hasDefault &&
        (this.__label.textContent = this._defaultLabel);
  }),
  (UTSearchFilterControl.prototype.setIndex = function setIndex(e) {
    this.superclass(e),
      this.toggleClass(
        'has-selection',
        0 !== this.getIndex() || !this._hasDefault
      );
  }),
  (UTSearchFilterControl.prototype.setHasDefault = function setHasDefault(e) {
    (this._hasDefault = e), this.toggleClass('has-default', e);
  }),
  (UTSearchFilterControl.prototype.setIconTable = function setIconTable(e) {
    this._iconTable = e;
  }),
  (UTSearchFilterControl.prototype._handleChange = function _handleChange(e) {
    this.superclass(e),
      0 === this.getIndex() &&
        this._hasDefault &&
        (this.__label.textContent = this._defaultLabel);
  }),
  (UTSearchFilterControl.prototype._onClear = function _onClear(e) {
    if (this.enabled) {
      var t = this.getDropDownElement().parentNode;
      isPhone() &&
        utils.JS.isValid(t) &&
        (t.removeChild(this.getDropDownElement()),
        setTimeout(
          function() {
            this.__animatedContainer.appendChild(this.getDropDownElement());
          }.bind(this),
          500
        )),
        this.setIndex(this.getDefaultIndex());
    }
  }),
  utils.JS.inherits(UTImageButtonControl, UTButtonControl),
  (UTImageButtonControl.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('button');
      e.classList.add('ut-image-button-control'),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTImageButtonControl.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTImageButtonControl.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTImageButtonControl.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  utils.JS.inherits(UTItemInfoStateViewModel, UTObject),
  (UTItemInfoStateViewModel.prototype.setState = function setState(e) {
    this._configDelegate &&
      (this._configDelegate.setSessionItem('UTItemInfoState', e),
      getDefaultDispatcher().notify(
        enums.Notification.UI_ITEM_STATE_CHANGE,
        this,
        {
          state: e
        }
      )),
      (this._state = e);
  }),
  (UTItemInfoStateViewModel.prototype.getState = function getState() {
    return (
      (this._configDelegate &&
        parseInt(this._configDelegate.getSessionItem('UTItemInfoState'), 10)) ||
      this._state
    );
  }),
  (UTItemInfoStateViewModel.prototype.nextState = function nextState() {
    switch (this.getState()) {
      case enums.UIItemInfoState.MAIN:
        this.setState(enums.UIItemInfoState.BIO);
        break;
      case enums.UIItemInfoState.BIO:
        this.setState(enums.UIItemInfoState.STATS);
        break;
      case enums.UIItemInfoState.STATS:
        this.setState(enums.UIItemInfoState.STYLE);
        break;
      case enums.UIItemInfoState.STYLE:
      default:
        this.setState(enums.UIItemInfoState.MAIN);
    }
    return this._state;
  }),
  utils.JS.inherits(UTItemCanvasDTO, UTObject),
  (components.ItemFUTBase = function ItemFUTBaseView() {
    UTView.call(this),
      (this._renderConcept = !0),
      Object.defineProperty(this, '_renderConcept', {
        writable: !0,
        enumerable: !1
      }),
      (this._rendered = !1),
      Object.defineProperty(this, '_rendered', {
        writable: !0,
        enumerable: !1
      }),
      (this._canShowSecondaryViews = !0),
      Object.defineProperty(this, '_canShowSecondaryViews', {
        writable: !0,
        enumerable: !1
      }),
      (this._infoStateViewModel = new UTItemInfoStateViewModel(
        gUserSettingsModel
      )),
      Object.defineProperty(this, '_infoStateViewModel', {
        writable: !1,
        enumerable: !1
      }),
      (this.assets = {}),
      (this._assetsLoaded = {});
  }),
  utils.JS.inherits(components.ItemFUTBase, UTView),
  (components.ItemFUTBase.CLASS = {
    ACTIVE_CLUB_ITEM: 'activeItem',
    CONTRACT_EXPIRED: 'restricted-contract',
    INJURED: 'restricted-injured',
    SUSPENDED: 'restricted-suspended',
    DYNAMIC_PORTRAIT: 'dynamic-portrait',
    CONCEPT: 'concept',
    EMPTY: 'empty',
    LOAN: 'loan',
    CHEM_BONUS: 'hasBonus',
    INVALID_STAT: 'invalidStat',
    PLAYSTYLE: 'playStyle',
    PLAYEROUT: 'playerOut',
    AUCTION_WINNING: 'winning',
    AUCTION_WON: 'won',
    AUCTION_EXPIRED: 'expired',
    AUCTION_OUTBID: 'outbid',
    LOADING: 'ut-item-loading',
    LOADED: 'ut-item-loaded',
    CHAMPIONS: 'champions'
  }),
  (components.ItemFUTBase.QUALITY = {
    BRONZE: 'bronze',
    SILVER: 'silver',
    GOLD: 'gold'
  }),
  (components.ItemFUTBase.STATUS_OVERLAY_TYPE = ['common', 'rare', 'specials']),
  (components.ItemFUTBase.prototype.init = function init() {
    this.superclass(),
      getDefaultDispatcher().addObserver(
        enums.Notification.UI_ITEM_STATE_CHANGE,
        this,
        this._nInfoStateChanged
      );
  }),
  (components.ItemFUTBase.prototype.dealloc = function dealloc() {
    getDefaultDispatcher().removeObserver(
      enums.Notification.UI_ITEM_STATE_CHANGE,
      this
    ),
      this.superclass();
  }),
  (components.ItemFUTBase.prototype.renderConcept = function renderConcept(e) {
    this._renderConcept = e;
  }),
  (components.ItemFUTBase.prototype.showSecondaryViews = function showSecondaryViews(
    e
  ) {
    this._canShowSecondaryViews = !!e;
  }),
  (components.ItemFUTBase.onFlagImageLoad = function onFlagImageLoad(
    e,
    t,
    i,
    s
  ) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.FLAG + '.png')
        );
  }),
  (components.ItemFUTBase.prototype.setItemInfoState = function setItemInfoState(
    e
  ) {}),
  (components.ItemFUTBase.prototype.render = function render(e) {
    var t = services.Configuration.getItemRarity(e, e.getYear());
    this._rendered && this._resetRender(),
      this._canvas &&
        (this._canvas.clearCanvas(),
        this.removeClass(components.ItemFUTBase.CLASS.LOADED),
        this.addClass(components.ItemFUTBase.CLASS.LOADING)),
      (this.assets = {}),
      (this._assetsLoaded = {}),
      this._renderShell(e, t),
      this._render(e, t),
      this.renderAuctionState(e.getAuctionData()),
      (this._rendered = !0);
    var i =
      this._infoStateViewModel && this._canShowSecondaryViews
        ? this._infoStateViewModel.getState()
        : enums.UIItemInfoState.MAIN;
    this.setItemInfoState(i);
  }),
  (components.ItemFUTBase.prototype._renderComplete = function _renderComplete() {
    this.removeClass(components.ItemFUTBase.CLASS.LOADING),
      this.addClass(components.ItemFUTBase.CLASS.LOADED);
  }),
  (components.ItemFUTBase.prototype._resetRender = function _resetRender() {}),
  (components.ItemFUTBase.prototype.canRender = function canRender(e) {
    return (
      utils.Debug.Assert(
        !1,
        '[components.ItemFUTBase] Abstract method canRender not implemented.'
      ),
      !1
    );
  }),
  (components.ItemFUTBase.prototype._render = function _render(e, t) {
    utils.Debug.Assert(
      !1,
      '[components.ItemFUTBase] Abstract method _render not implemented.'
    );
  }),
  (components.ItemFUTBase.prototype._renderShell = function _renderShell(e, t) {
    this._rendered &&
      this.removeClass(
        components.ItemFUTBase.CLASS.CONCEPT +
          ' ' +
          components.ItemFUTBase.CLASS.EMPTY
      ),
      e.isValid()
        ? this._renderConcept && e.concept
          ? this.addClass(components.ItemFUTBase.CLASS.CONCEPT)
          : (this.toggleClass(
              components.ItemFUTBase.CLASS.ACTIVE_CLUB_ITEM,
              e.isActiveClubItem()
            ),
            this.removeClass(
              components.ItemFUTBase.STATUS_OVERLAY_TYPE.join(' ')
            ),
            this.addClass(components.ItemFUTBase.STATUS_OVERLAY_TYPE[t.shell]))
        : this.addClass(components.ItemFUTBase.CLASS.EMPTY);
  }),
  (components.ItemFUTBase.prototype._setShell = function _setShell(e, t, i) {
    var s,
      n = this.getRootElement(),
      o = e.isPlayer() || e.isManager(),
      a = e.isStaff() && !o,
      r = utils.JS.isString(i) ? i : '';
    s = a ? 2 : o ? 1 : 0;
    var l = e.hasQualityTiers() ? e.getTier() : enums.ItemRatingTier.NONE,
      c = utils.AssetLocator.getShellURL(t, s, e.rareflag, l, r);
    o
      ? ((this.assets[enums.ItemAssetType.SHELL] = this._getAssetDimensions(
          enums.ItemAssetType.SHELL,
          !1
        )),
        this._loadAsset(c, enums.ItemAssetType.SHELL, e))
      : (n.style.backgroundImage = 'url(' + c + ')');
  }),
  (components.ItemFUTBase.prototype._setLocalShell = function _setLocalShell(
    e,
    t
  ) {
    var i = this.getRootElement(),
      s = e.concept && this._renderConcept,
      n = s && e.rareflag > entities.Item.Rarity.RARE ? 2 : e.rareflag,
      o = e.hasQualityTiers() ? e.getTier() : enums.ItemRatingTier.NONE,
      a = utils.AssetLocator.getLocalShellURL(s, n, o, t);
    this._canvas
      ? ((this.assets[enums.ItemAssetType.SHELL] = this._getAssetDimensions(
          enums.ItemAssetType.SHELL,
          !1
        )),
        this._loadAsset(a, enums.ItemAssetType.SHELL, e))
      : (i.style.backgroundImage = 'url(' + a + ')');
  }),
  (components.ItemFUTBase.prototype.renderAuctionState = function renderAuctionState(
    e
  ) {
    if (this._rendered) {
      var t = [
        components.ItemFUTBase.CLASS.AUCTION_WON,
        components.ItemFUTBase.CLASS.AUCTION_WINNING,
        components.ItemFUTBase.CLASS.AUCTION_EXPIRED,
        components.ItemFUTBase.CLASS.AUCTION_OUTBID
      ].join(' ');
      this.removeClass(t);
    }
    e.isValid() &&
      (e.isWon()
        ? this.addClass(components.ItemFUTBase.CLASS.AUCTION_WON)
        : e.isHighestBid() || e.isBought() || e.isSold()
        ? this.addClass(components.ItemFUTBase.CLASS.AUCTION_WINNING)
        : e.isActiveTrade() && e.isOutbid()
        ? this.addClass(components.ItemFUTBase.CLASS.AUCTION_OUTBID)
        : (e.isClosedTrade() || e.isExpired()) &&
          this.addClass(components.ItemFUTBase.CLASS.AUCTION_EXPIRED));
  }),
  (components.ItemFUTBase.prototype.renderChemistry = function renderChemistry(
    e,
    t,
    i
  ) {}),
  (components.ItemFUTBase.prototype._applyColors = function _applyColors(e, t) {
    var i = this.getRootElement();
    DOMKit.findElements(i, e).forEach(function(e) {
      e.style.color = 'rgba(' + t.r + ', ' + t.g + ', ' + t.b + ', 1)';
    });
  }),
  (components.ItemFUTBase.prototype._getAssetDimensions = function _getAssetDimensions(
    e,
    t
  ) {}),
  (components.ItemFUTBase.prototype._requestResource = function _requestResource(
    e,
    t,
    i,
    s
  ) {
    var n =
        gConfigurationModel.getConfigString(
          models.ConfigurationModel.KEY_RESOURCE_ROOT
        ) + e,
      o = s || this._onLoadAssetError;
    this._loadAsset(n, t, i, o);
  }),
  (components.ItemFUTBase.prototype._loadAsset = function _loadAsset(
    e,
    t,
    i,
    s
  ) {
    var n, o, a;
    if (this.assets[t]) {
      var r = new Image();
      if (!this.assets[t]) return;
      (n = function _onLoadError() {
        r.removeEventListener('load', o, !1),
          r.removeEventListener('error', a, !1),
          s ? s.apply(this, [t, i]) : this._onLoadAssetError(t, i);
      }),
        (o = function _onLoadSuccess() {
          r.removeEventListener('load', o, !1),
            r.removeEventListener('error', a, !1),
            this._onLoadAssetSuccess(t, r);
        }.bind(this)),
        (a = n.bind(this)),
        e &&
          ((r.src = e),
          r.addEventListener('load', o, !1),
          r.addEventListener('error', a, !1));
    }
  }),
  (components.ItemFUTBase.prototype._onLoadAssetSuccess = function _onLoadAssetSuccess(
    e,
    t
  ) {
    this._canvas &&
      ((this.assets[e].element = t),
      (this._assetsLoaded[e] = !0),
      this._onLoadComplete());
  }),
  (components.ItemFUTBase.prototype._onLoadAssetError = function _onLoadAssetError(
    e,
    t
  ) {
    this._canvas &&
      ((this.assets[e].element = null),
      (this._assetsLoaded[e] = !1),
      this._onLoadComplete());
  }),
  (components.ItemFUTBase.prototype._onLoadComplete = function _onLoadComplete() {
    if (
      Object.keys(this._assetsLoaded).length >= Object.keys(this.assets).length
    ) {
      var e =
        this._infoStateViewModel && this._canShowSecondaryViews
          ? this._infoStateViewModel.getState()
          : enums.UIItemInfoState.MAIN;
      this._canvas.setAssets(this.assets),
        this._canvas.setState(e),
        this._renderComplete();
    }
  }),
  (components.ItemFUTBase.prototype._nInfoStateChanged = function _nInfoStateChanged(
    e,
    t,
    i
  ) {
    this.setItemInfoState(i.state);
  }),
  (components.ItemPlayerBase = function ItemPlayerBaseView() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemPlayerBase, components.ItemFUTBase),
  (components.ItemPlayerBase.onImageLoad = function onImageLoad(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.PLAYER + '.png')
        );
  }),
  (components.ItemPlayerBase.prototype.renderChemistry = function renderChemistry(
    e,
    t,
    i
  ) {
    var o = repositories.PlayStyle.getPlayStyleBonusById(
        e.playStyle,
        e.isGK()
      ).slice(0, 6),
      a = Math.max(t - 4, 0),
      s = [2, 3, 4, 5, 0, 1],
      r = s.filter(function(e) {
        return 0 < o[e];
      });
    s.forEach(function _applyChevronChemistry(e) {
      var t = this['_chevronSet' + (e + 1)];
      if (t) {
        var i = o[e],
          s = a - r.indexOf(e),
          n = 0;
        if (0 < i && 0 < s) for (; n < i && 0 < s; ) (s -= r.length), n++;
        t.setChemistryBoost(n);
      }
    }, this);
  }),
  (components.ItemPlayerBase.prototype._render = function _render(e, t) {
    if (e.isValid()) {
      var i,
        s = e.getYear(),
        n = t.getExpColorMap(e.getTier()),
        o =
          e.isContractExpired() &&
          !e.getAuctionData().isSold() &&
          !e.isLoaned();
      if (
        (e.concept ||
          (e.isInjured()
            ? this.addClass(components.ItemFUTBase.CLASS.INJURED)
            : o
            ? this.addClass(components.ItemFUTBase.CLASS.CONTRACT_EXPIRED)
            : e.isSuspended() &&
              this.addClass(components.ItemFUTBase.CLASS.SUSPENDED)),
        e.hasTraining())
      )
        (i =
          e.getBoostLevel() === enums.ItemRatingTier.GOLD
            ? components.ItemFUTBase.QUALITY.GOLD
            : e.getBoostLevel() === enums.ItemRatingTier.SILVER
            ? components.ItemFUTBase.QUALITY.SILVER
            : components.ItemFUTBase.QUALITY.BRONZE),
          DOMKit.addClass(this.__trainingBoost, i);
      this.toggleClass(
        components.ItemFUTBase.CLASS.CHAMPIONS,
        e.isChampionsLeagueItem() && !services.Localization.isRTL()
      ),
        this.toggleClass(components.ItemFUTBase.CLASS.LOAN, e.isLoaned()),
        e.isLoaned() &&
          this.__loanInfoTab &&
          (this.__loanInfoTab.textContent = e.contract.toString()),
        (this.__playerRating.innerHTML = e.rating.toString());
      var a = utils.FUTLocalization.getLocalizedPositionStringById(
        e.preferredPosition
      );
      if (
        ((this.__playerPosition.innerHTML = a),
        this._setPortrait(e),
        this._setFlag(e),
        this._setBadge(e, n.useLightCrest),
        this._setLeague(e, n.useLightCrest),
        this.__bioNation &&
          (this.__bioNation.textContent = utils.FUTLocalization.getNationAbb3ById(
            e.nationId
          )),
        this.__bioClub &&
          (this.__bioClub.textContent = utils.FUTLocalization.getTeamAbb3ByID(
            e.teamId,
            s
          )),
        this.__bioLeague &&
          (this.__bioLeague.textContent = utils.FUTLocalization.getLeagueAbbr5ByID(
            e.leagueId,
            s
          )),
        this.__playerManagerBonus &&
          (this.__playerManagerBonus.textContent = 'M'),
        this.__playerLoyaltyIcon)
      ) {
        var r = 0 < e.loyaltyBonus && !e.getAuctionData().isValid();
        DOMKit.toggleClass(
          this.__playerLoyaltyIcon,
          components.ItemFUTBase.CLASS.CHEM_BONUS,
          r
        );
      }
      this._setSkillMoves(e.getSkillMoves()),
        this._setWeakFoot(e.isLeftFoot(), e.getWeakFoot());
    }
  }),
  (components.ItemPlayerBase.prototype.canRender = function canRender(e) {
    return utils.JS.isValid(e) && e.isPlayer() && !e.isCustomBrick();
  }),
  (components.ItemPlayerBase.prototype._resetRender = function _resetRender() {
    DOMKit.removeClass(
      this.__trainingBoost,
      [
        components.ItemFUTBase.QUALITY.GOLD,
        components.ItemFUTBase.QUALITY.SILVER,
        components.ItemFUTBase.QUALITY.BRONZE
      ].join(' ')
    ),
      this.removeClass(
        [
          components.ItemFUTBase.CLASS.CONTRACT_EXPIRED,
          components.ItemFUTBase.CLASS.SUSPENDED,
          components.ItemFUTBase.CLASS.INJURED
        ].join(' ')
      ),
      this.removeClass(components.ItemFUTBase.CLASS.LOAN),
      this.removeClass(components.ItemFUTBase.CLASS.CHAMPIONS),
      this.__loanInfoTab && (this.__loanInfoTab.textContent = ''),
      this._mainImage &&
        this._mainImage.removeClass(
          components.ItemFUTBase.CLASS.DYNAMIC_PORTRAIT
        ),
      this.getRootElement().removeAttribute('style'),
      (this.assets = {}),
      this._canvas && this._canvas.clearCanvas();
  }),
  (components.ItemPlayerBase.prototype._createConceptRarity = function _createConceptRarity() {
    return new UTItemRarityDTO({
      colors: ['d2e2f6', 'a8b7c9', '4b5e78', '7a899d'],
      lgColorIndices: [1, 1, 1, 1, 2, 2, 3, 4, 4],
      smColorIndices: [1, 1, 1, 1, 2, 2, 3, 4, 4],
      colorsPerLevel: 4
    });
  }),
  (components.ItemPlayerBase.prototype._applyChevrons = function _applyChevrons(
    e
  ) {
    utils.Debug.Assert(
      6 === e.length,
      'Expected 6 entries in chevronList array.'
    ),
      e.slice(0, 6).forEach(function applyChevrons(e, t) {
        var i = this['_chevronSet' + (t + 1)];
        i && i.setChevronCount(e);
      }, this);
  }),
  (components.ItemPlayerBase.prototype._onLoadDynamicPortraitError = function _onLoadDynamicPortraitError(
    e,
    t
  ) {
    e === enums.ItemAssetType.MAIN &&
      ((this.assets[enums.ItemAssetType.MAIN] = this._getAssetDimensions(
        enums.ItemAssetType.MAIN,
        !1
      )),
      this._requestResource(
        utils.AssetLocator.getImage(
          utils.AssetLocator.IMAGE_TYPE_PORTRAIT,
          t.getYear(),
          this._getItemAssetId(t.getMaskedResourceId(), t.getYear())
        ),
        enums.ItemAssetType.MAIN,
        t
      ));
  }),
  (components.ItemPlayerBase.prototype._onLoadAssetError = function _onLoadAssetError(
    e,
    t
  ) {
    var i;
    if (e === enums.ItemAssetType.MAIN)
      return (
        (i = t.isBronzeRating()
          ? enums.PlaceholderAssetId.PLAYER_BRONZE
          : t.isSilverRating()
          ? enums.PlaceholderAssetId.PLAYER_SILVER
          : enums.PlaceholderAssetId.PLAYER_GOLD),
        void this._requestResource(
          utils.AssetLocator.getImage(
            utils.AssetLocator.IMAGE_TYPE_PORTRAIT,
            t.getYear(),
            this._getItemAssetId(i, t.getYear())
          ),
          enums.ItemAssetType.MAIN,
          t
        )
      );
    (this._assetsLoaded[e] = !1), this._onLoadComplete();
  }),
  (components.ItemPlayerBase.prototype._getItemAssetId = function _getItemAssetId(
    e,
    t
  ) {
    return (
      entities.Item.isAlex(e)
        ? (e = ALEX_HUNTER_PLACEHOLDER_ASSET_ID)
        : entities.Item.isJim(e)
        ? (e = JIM_HUNTER_PLACEHOLDER_ASSET_ID)
        : entities.Item.isDanny(e)
        ? (e = DANNY_WILLIAMS_PLACEHOLDER_ASSET_ID)
        : utils.AssetLocator.hasPlaceholder(
            enums.PlaceholderAssetKey.PLAYERS,
            e,
            t
          ) && (e = enums.PlaceholderAssetId.PLAYER),
      e
    );
  }),
  (components.ItemPlayerBase.prototype._setPortrait = function _setPortrait(e) {
    if (this._canvas) {
      var t =
          e.isSpecial() &&
          !e.isLegend() &&
          !entities.Item.isStoryMode(e.getMaskedResourceId()),
        i = this._getItemAssetId(e.getMaskedResourceId(), e.getYear()),
        s = t
          ? utils.AssetLocator.getImage(
              utils.AssetLocator.IMAGE_TYPE_DYNAMIC_PORTRAIT,
              e.getYear(),
              e.getDefId()
            )
          : utils.AssetLocator.getImage(
              utils.AssetLocator.IMAGE_TYPE_PORTRAIT,
              e.getYear(),
              i
            ),
        n = t ? this._onLoadDynamicPortraitError : this._onLoadAssetError;
      (this.assets[enums.ItemAssetType.MAIN] = this._getAssetDimensions(
        enums.ItemAssetType.MAIN,
        t
      )),
        this._requestResource(s, enums.ItemAssetType.MAIN, e, n);
    } else
      this._mainImage
        ? this._setImageElementPortrait(e)
        : utils.Debug.Assert(
            !1,
            'MissingElement: Canvas or Image Element Missing to render asset id:' +
              e.assetId
          );
  }),
  (components.ItemPlayerBase.prototype._setImageElementPortrait = function _setImageElementPortrait(
    e
  ) {
    var t = this._getItemAssetId(e.getMaskedResourceId(), e.getYear()),
      n = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_PORTRAIT,
        e.getYear(),
        t
      );
    if (e.isSpecial()) {
      var i = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_DYNAMIC_PORTRAIT,
        e.getYear(),
        e.getDefId()
      );
      this._mainImage
        .setResource(i, !0)
        .observe(this, function onDynamicPortraitLoad(e, t, i, s) {
          e.unobserve(this),
            t
              ? this._mainImage.addClass(
                  components.ItemFUTBase.CLASS.DYNAMIC_PORTRAIT
                )
              : this._mainImage
                  .setResource(n, !0)
                  .observe(
                    this._mainImage,
                    components.ItemPlayerBase.onImageLoad
                  );
        });
    } else
      this._mainImage
        .setResource(n, !0)
        .observe(this._mainImage, components.ItemPlayerBase.onImageLoad);
  }),
  (components.ItemPlayerBase.prototype._setFlag = function _setFlag(e) {
    var t = utils.AssetLocator.getImage(
      utils.AssetLocator.IMAGE_TYPE_FLAG,
      e.getYear(),
      e.nationId
    );
    this._canvas
      ? ((this.assets[enums.ItemAssetType.FLAG] = this._getAssetDimensions(
          enums.ItemAssetType.FLAG,
          !1
        )),
        this._requestResource(t, enums.ItemAssetType.FLAG, e),
        this._bioFlagImage.setResource(t))
      : this._flagImage.setResource(t);
  }),
  (components.ItemPlayerBase.prototype._setBadge = function _setBadge(e, t) {
    var i = t
        ? utils.AssetLocator.IMAGE_TYPE_BADGE_LIGHT
        : utils.AssetLocator.IMAGE_TYPE_BADGE_DARK,
      s = e.teamId,
      n = e.getYear();
    (utils.AssetLocator.hasPlaceholder(
      enums.PlaceholderAssetKey.CREST,
      s.toString(),
      n,
      enums.PlaceholderAssetKey.CREST_LIGHT
    ) ||
      utils.AssetLocator.hasPlaceholder(
        enums.PlaceholderAssetKey.CREST,
        s.toString(),
        n,
        enums.PlaceholderAssetKey.CREST_DARK
      )) &&
      (s = enums.PlaceholderAssetId.TEAM);
    var o = utils.AssetLocator.getImage(i, n, s);
    this._canvas
      ? ((this.assets[enums.ItemAssetType.BADGE] = this._getAssetDimensions(
          enums.ItemAssetType.BADGE,
          !1
        )),
        this._requestResource(o, enums.ItemAssetType.BADGE, e),
        this._bioBadgeImage.setResource(o))
      : this._badgeImage.setResource(o);
  }),
  (components.ItemPlayerBase.prototype._setLeague = function _setLeague(e, t) {
    if (this._canvas) {
      var i = t
        ? utils.AssetLocator.IMAGE_TYPE_LEAGUE_LIGHT
        : utils.AssetLocator.IMAGE_TYPE_LEAGUE_DARK;
      this._bioLeagueImage.setResource(
        utils.AssetLocator.getImage(i, e.getYear(), e.leagueId)
      );
    }
  }),
  (components.ItemPlayerBase.prototype._setSkillMoves = function _setSkillMoves(
    e
  ) {}),
  (components.ItemPlayerBase.prototype._setWeakFoot = function _setWeakFoot(
    e,
    t
  ) {}),
  utils.JS.inherits(UTItemStatChevronsView, UTView),
  (UTItemStatChevronsView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('chevrons');
      var t = document.createElement('div');
      t.classList.add('chevron1'), t.classList.add('chevron'), e.appendChild(t);
      var i = document.createElement('div');
      i.classList.add('chevron2'), i.classList.add('chevron'), e.appendChild(i);
      var s = document.createElement('div');
      s.classList.add('chevron3'),
        s.classList.add('chevron'),
        e.appendChild(s),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTItemStatChevronsView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTItemStatChevronsView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTItemStatChevronsView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTItemStatChevronsView.prototype.setChevronCount = function setChevronCount(
    i
  ) {
    DOMKit.HTMLCollectionToArray(this.getRootElement().children)
      .reverse()
      .forEach(function(e, t) {
        e.style.display = i < t + 1 ? 'none' : '';
      });
  }),
  (UTItemStatChevronsView.prototype.setChemistryBoost = function setChemistryBoost(
    i
  ) {
    DOMKit.HTMLCollectionToArray(this.getRootElement().children)
      .reverse()
      .forEach(function(e, t) {
        DOMKit.toggleClass(e, 'chemBoost', t < i);
      });
  }),
  utils.JS.inherits(UTItemCanvasView, UTView),
  (UTItemCanvasView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('canvas');
      (this.__root = e), (this._generated = !0);
    }
  }),
  (UTItemCanvasView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTItemCanvasView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTItemCanvasView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTItemCanvasView.prototype.init = function init() {
    this.superclass();
    var e = this.getRootElement();
    (this._ctx = e.getContext('2d')),
      (e.style.width = '100%'),
      (e.style.height = '100%'),
      (this._ctx.globalCompositeOperation = 'source-over');
  }),
  (UTItemCanvasView.prototype.dealloc = function dealloc() {
    (this._ctx = null),
      (this._colormap = null),
      (this.assets = {}),
      (this.rendered = !1),
      this.superclass();
  }),
  (UTItemCanvasView.prototype.setSize = function setSize(e) {
    var t = this.getRootElement(),
      i =
        1 === window.devicePixelRatio
          ? 1.5 * window.devicePixelRatio
          : window.devicePixelRatio;
    (this.size = e) === enums.ItemViewType.LARGE
      ? ((t.width = 152 * i),
        (t.height = 212 * i),
        (t.style.width = '152px'),
        (t.style.height = '212px'))
      : e === enums.ItemViewType.SMALL &&
        ((t.width = 97 * i),
        (t.height = 114 * i),
        (t.style.width = '100%'),
        (t.style.height = '100%')),
      this._ctx.scale(i, i);
  }),
  (UTItemCanvasView.prototype.setColorMap = function setColorMap(e) {
    this._colormap = e;
  }),
  (UTItemCanvasView.prototype.setAssets = function setAssets(e) {
    this.assets = e;
  }),
  (UTItemCanvasView.prototype.setState = function setState(e) {}),
  (UTItemCanvasView.prototype.clearCanvas = function clearCanvas() {
    var e = this.getRootElement();
    this._ctx &&
      ((this._ctx.globalCompositeOperation = 'source-over'),
      this._ctx.clearRect(0, 0, e.width, e.height)),
      (this.rendered = !1);
  }),
  (UTItemCanvasView.prototype.getWidth = function getWidth() {
    var e =
      1 === window.devicePixelRatio
        ? 1.5 * window.devicePixelRatio
        : window.devicePixelRatio;
    return this.getRootElement().width / e;
  }),
  (UTItemCanvasView.prototype.getHeight = function getHeight() {
    var e =
      1 === window.devicePixelRatio
        ? 1.5 * window.devicePixelRatio
        : window.devicePixelRatio;
    return this.getRootElement().height / e;
  }),
  (UTItemCanvasView.prototype._drawAsset = function _drawAsset(e) {
    var t = this.assets[e];
    if (t && t.element && t.element.complete) {
      var i = t.element.width || t.width,
        s = t.element.height || t.height;
      this._ctx.drawImage(
        t.element,
        0,
        0,
        i,
        s,
        t.xPos,
        t.yPos,
        t.width,
        t.height
      );
    }
  }),
  (UTItemCanvasView.prototype._drawBgColor = function _drawBgColor() {
    var e = this.getRootElement(),
      t = this._colormap.background,
      i = 'rgba(' + t.r + ', ' + t.g + ', ' + t.b + ', 1)';
    (this._ctx.fillStyle = '#000000'),
      (this._ctx.globalAlpha = 0),
      this._drawAsset(enums.ItemAssetType.SHELL),
      (this._ctx.globalCompositeOperation = 'source-atop'),
      (this._ctx.globalAlpha = 1),
      (this._ctx.fillStyle = i),
      this._ctx.fillRect(0, 0, e.width, e.height),
      (this._ctx.globalCompositeOperation = 'source-over');
  }),
  (UTItemCanvasView.prototype._drawDivider = function _drawDivider(e, t, i, s) {
    utils.Debug.Assert(
      utils.JS.isValid(this._colormap),
      'Render Warning: color map is not defined when attempting to draw dividers.'
    );
    var n = this._colormap.dividers,
      o = 'rgba(' + n.r + ', ' + n.g + ', ' + n.b + ', 1)';
    this._ctx.beginPath(),
      this._ctx.moveTo(e, t),
      this._ctx.lineTo(i, s),
      (this._ctx.strokeStyle = o),
      this._ctx.stroke();
  }),
  (UTItemCanvasView.prototype._maskItem = function _maskItem() {
    (this._ctx.globalAlpha = 0),
      this._drawAsset(enums.ItemAssetType.SHELL),
      (this._ctx.globalCompositeOperation = 'source-atop'),
      (this._ctx.globalAlpha = 1);
  }),
  (UTItemCanvasView.prototype._resetMask = function _maskItem() {
    this._ctx.globalCompositeOperation = 'source-over';
  }),
  utils.JS.inherits(UTItemPlayerCanvasView, UTItemCanvasView),
  (UTItemPlayerCanvasView.prototype.setState = function setState(e) {
    switch ((this.clearCanvas(), e)) {
      case enums.UIItemInfoState.STYLE:
        this._renderStyleView();
        break;
      case enums.UIItemInfoState.BIO:
        this._renderBioView();
        break;
      case enums.UIItemInfoState.STATS:
        this._renderStatsView();
        break;
      case enums.UIItemInfoState.MAIN:
        this._renderMainView();
    }
    this.rendered = !0;
  }),
  (UTItemPlayerCanvasView.prototype._renderAsDynamic = function _renderAsDynamic() {
    var e = this.assets[enums.ItemAssetType.MAIN];
    return (
      !!(e && e.element && e.element.complete) &&
      (this.renderSpecial &&
        !this.renderConcept &&
        this.assets[enums.ItemAssetType.MAIN].dynamic)
    );
  }),
  (UTItemPlayerCanvasView.prototype._renderMainView = function _renderMainView() {
    if (
      (this._drawAsset(enums.ItemAssetType.SHELL),
      this._maskItem(),
      this._drawAsset(enums.ItemAssetType.MAIN),
      this._resetMask(),
      this._renderAsDynamic() && (this._drawArc(), this._drawTransparentBar()),
      this._drawAsset(enums.ItemAssetType.BADGE),
      this._drawAsset(enums.ItemAssetType.FLAG),
      this.size === enums.ItemViewType.LARGE)
    ) {
      var e = this.getWidth();
      this._drawDivider(34, 131.5, 117, 131.5),
        this._drawDivider((e - 1) / 2, 135, (e - 1) / 2, 171),
        this._drawDivider(68, 174, 84, 174),
        this._drawDivider(36, 66.5, 51, 66.5),
        this._drawDivider(36, 85.5, 51, 85.5);
    }
  }),
  (UTItemPlayerCanvasView.prototype._renderStyleView = function _renderStyleView() {
    if (
      (this._drawAsset(enums.ItemAssetType.SHELL),
      this._drawBgColor(),
      this.size === enums.ItemViewType.SMALL)
    )
      this._smallViewAlternateViewLines();
    else {
      var e = this.getWidth(),
        t = (e - 1) / 2,
        i = 36,
        s = e - 36;
      this._drawDivider(i, 110.5, s, 110.5),
        this._drawDivider(i, 130.5, s, 130.5),
        this._drawDivider(t, 132.5, t, 172.5),
        this.renderConcept ||
          ((i = t - 10.5),
          (s = t + 10.5),
          this._drawDivider(i, 175.5, s, 175.5));
    }
  }),
  (UTItemPlayerCanvasView.prototype._renderBioView = function _renderBioView() {
    if (
      (this._drawAsset(enums.ItemAssetType.SHELL),
      this._drawBgColor(),
      this.size === enums.ItemViewType.SMALL)
    )
      this._smallViewAlternateViewLines();
    else {
      var e = this.getWidth(),
        t = (e - 1) / 2,
        i = e - 26;
      this._drawDivider(26, 55.5, i, 55.5),
        this._drawDivider(26, 90.5, i, 90.5),
        this._drawDivider(26, 125.5, i, 125.5),
        this._drawDivider(26, 160.5, i, 160.5),
        this._drawDivider(t, 170.5, t, 182.5);
    }
  }),
  (UTItemPlayerCanvasView.prototype._renderStatsView = function _renderStatsView() {
    if (
      (this._drawAsset(enums.ItemAssetType.SHELL),
      this._drawBgColor(),
      this.size === enums.ItemViewType.SMALL)
    )
      this._smallViewAlternateViewLines();
    else {
      var e = this.getWidth(),
        t = (e - 1) / 2,
        i = 26,
        s = e - 26;
      this._drawDivider(i, 55.5, s, 55.5),
        this._drawDivider(i, 81.5, s, 81.5),
        this._drawDivider(i, 108.5, s, 108.5),
        this._drawDivider(i, 134.5, s, 134.5),
        this._drawDivider(i, 160.5, s, 160.5),
        this.renderConcept ||
          ((i = t - 10.5),
          (s = t + 10.5),
          this._drawDivider(i, 175.5, s, 175.5));
    }
  }),
  (UTItemPlayerCanvasView.prototype._drawArc = function _drawArc() {
    if (this.renderSpecial && this.size !== enums.ItemViewType.SMALL) {
      var e = this.getWidth(),
        t = this.getHeight();
      this._maskItem(),
        this._ctx.beginPath(),
        this._ctx.moveTo(0, t / 1.1),
        this._ctx.quadraticCurveTo(e / 1.1, t / 1.75, e - 29, 0),
        this._ctx.quadraticCurveTo(e, 0, e, 0),
        this._ctx.quadraticCurveTo(e, t, e, t + 20),
        (this._ctx.fillStyle = 'rgba(0, 0, 0, 0.10)'),
        this._ctx.fill(),
        this._resetMask();
    }
  }),
  (UTItemPlayerCanvasView.prototype._drawTransparentBar = function _drawTransparentBar() {
    if (this.renderSpecial) {
      var e, t;
      utils.Debug.Assert(
        utils.JS.isValid(this._colormap),
        'Render Warning: color map is not defined when attempting to draw transparent bar.'
      );
      var i = this.getHeight(),
        s = this._ctx.createLinearGradient(0, 0, 24, i),
        n = this._colormap.background,
        o = 'rgba(' + n.r + ', ' + n.g + ', ' + n.b + ', 0.675)',
        a = 'rgba(' + n.r + ', ' + n.g + ', ' + n.b + ', 0)';
      this._maskItem(),
        s.addColorStop(0, a),
        s.addColorStop(0.1, a),
        s.addColorStop(0.333, o),
        s.addColorStop(0.666, o),
        s.addColorStop(0.9, a),
        s.addColorStop(1, a),
        (t =
          this.size === enums.ItemViewType.LARGE
            ? ((e = 30), 27)
            : ((e = 13), 20)),
        this._ctx.beginPath(),
        (this._ctx.fillStyle = s),
        this._ctx.fillRect(e, 0, t, i),
        this._resetMask();
    }
  }),
  (UTItemPlayerCanvasView.prototype._smallViewAlternateViewLines = function _smallViewAlternateViewLines() {
    if (this.size !== enums.ItemViewType.LARGE) {
      var e = this.getWidth() - 17;
      this._drawDivider(17, 29.5, e, 29.5),
        this._drawDivider(17, 47.5, e, 47.5),
        this._drawDivider(17, 65.5, e, 65.5),
        this._drawDivider(17, 83.5, e, 83.5);
    }
  }),
  utils.JS.inherits(UTItemPlayerLargeView, components.ItemPlayerBase),
  (UTItemPlayerLargeView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('player'),
        e.classList.add('item'),
        (this._canvas = new UTItemPlayerCanvasView()),
        (this._canvas.width = '152'),
        (this._canvas.height = '212'),
        e.appendChild(this._canvas.getRootElement());
      var t = document.createElement('div');
      t.classList.add('ut-item-loader'), e.appendChild(t);
      var i = document.createElement('div');
      i.classList.add('statusOverlay'),
        e.appendChild(i),
        (this.__trainingBoost = document.createElement('div')),
        this.__trainingBoost.classList.add('ut-item-player-status--training'),
        this.__trainingBoost.classList.add('ut-item-player-status'),
        e.appendChild(this.__trainingBoost);
      var s = document.createElement('div');
      s.classList.add('ut-item-player-status--restricted'),
        s.classList.add('ut-item-player-status'),
        e.appendChild(s),
        (this.__playerName = document.createElement('div')),
        this.__playerName.classList.add('name'),
        e.appendChild(this.__playerName),
        (this.__playStyle = document.createElement('div')),
        this.__playStyle.classList.add('playStyle'),
        e.appendChild(this.__playStyle),
        (this.__mainViewDiv = document.createElement('div')),
        this.__mainViewDiv.classList.add('ut-item-view--main'),
        this.__mainViewDiv.classList.add('ut-item-view'),
        (this.__loanInfoTab = document.createElement('div')),
        this.__loanInfoTab.classList.add('ut-item-player-status--loan'),
        this.__mainViewDiv.appendChild(this.__loanInfoTab);
      var n = document.createElement('div');
      n.classList.add('playerOverview'),
        (this.__playerRating = document.createElement('div')),
        this.__playerRating.classList.add('rating'),
        n.appendChild(this.__playerRating),
        (this.__playerPosition = document.createElement('div')),
        this.__playerPosition.classList.add('position'),
        n.appendChild(this.__playerPosition),
        this.__mainViewDiv.appendChild(n);
      var o = document.createElement('div');
      o.classList.add('statCellRow');
      var a = document.createElement('div');
      a.classList.add('statCell');
      var r = document.createElement('span');
      r.classList.add('Pace'),
        r.classList.add('statValue'),
        a.appendChild(r),
        (this.__attribute0 = document.createElement('span')),
        this.__attribute0.classList.add('Pace'),
        this.__attribute0.classList.add('statLabel'),
        a.appendChild(this.__attribute0),
        o.appendChild(a);
      var l = document.createElement('div');
      l.classList.add('statCell');
      var c = document.createElement('span');
      c.classList.add('Dribbling'),
        c.classList.add('statValue'),
        l.appendChild(c),
        (this.__attribute3 = document.createElement('span')),
        this.__attribute3.classList.add('Dribbling'),
        this.__attribute3.classList.add('statLabel'),
        l.appendChild(this.__attribute3),
        o.appendChild(l),
        this.__mainViewDiv.appendChild(o);
      var u = document.createElement('div');
      u.classList.add('statCellRow');
      var d = document.createElement('div');
      d.classList.add('statCell');
      var h = document.createElement('span');
      h.classList.add('Shooting'),
        h.classList.add('statValue'),
        d.appendChild(h),
        (this.__attribute1 = document.createElement('span')),
        this.__attribute1.classList.add('Shooting'),
        this.__attribute1.classList.add('statLabel'),
        d.appendChild(this.__attribute1),
        u.appendChild(d);
      var p = document.createElement('div');
      p.classList.add('statCell');
      var _ = document.createElement('span');
      _.classList.add('Defending'),
        _.classList.add('statValue'),
        p.appendChild(_),
        (this.__attribute4 = document.createElement('span')),
        this.__attribute4.classList.add('Defending'),
        this.__attribute4.classList.add('statLabel'),
        p.appendChild(this.__attribute4),
        u.appendChild(p),
        this.__mainViewDiv.appendChild(u);
      var m = document.createElement('div');
      m.classList.add('statCellRow');
      var g = document.createElement('div');
      g.classList.add('statCell');
      var T = document.createElement('span');
      T.classList.add('Passing'),
        T.classList.add('statValue'),
        g.appendChild(T),
        (this.__attribute2 = document.createElement('span')),
        this.__attribute2.classList.add('Passing'),
        this.__attribute2.classList.add('statLabel'),
        g.appendChild(this.__attribute2),
        m.appendChild(g);
      var S = document.createElement('div');
      S.classList.add('statCell');
      var C = document.createElement('span');
      C.classList.add('Header'),
        C.classList.add('statValue'),
        S.appendChild(C),
        (this.__attribute5 = document.createElement('span')),
        this.__attribute5.classList.add('Header'),
        this.__attribute5.classList.add('statLabel'),
        S.appendChild(this.__attribute5),
        m.appendChild(S),
        this.__mainViewDiv.appendChild(m),
        e.appendChild(this.__mainViewDiv),
        (this.__statsViewDiv = document.createElement('div')),
        this.__statsViewDiv.classList.add('ut-item-view--stats'),
        this.__statsViewDiv.classList.add('ut-item-view'),
        (this.__skillMoves = document.createElement('div')),
        this.__skillMoves.classList.add('ut-item-row'),
        (this.__skillMovesLabel = document.createElement('span')),
        this.__skillMovesLabel.classList.add('ut-item-row-label--left'),
        this.__skillMovesLabel.classList.add('ut-item-row-label'),
        this.__skillMoves.appendChild(this.__skillMovesLabel);
      var y = document.createElement('div');
      y.classList.add('ut-star-rating'),
        this.__skillMoves.appendChild(y),
        (this.__skillMovesRating = document.createElement('span')),
        this.__skillMoves.appendChild(this.__skillMovesRating),
        this.__statsViewDiv.appendChild(this.__skillMoves),
        (this.__weakFoot = document.createElement('div')),
        this.__weakFoot.classList.add('ut-item-row'),
        (this.__weakFootLabel = document.createElement('span')),
        this.__weakFootLabel.classList.add('ut-item-row-label--left'),
        this.__weakFootLabel.classList.add('ut-item-row-label'),
        this.__weakFoot.appendChild(this.__weakFootLabel);
      var v = document.createElement('div');
      v.classList.add('ut-star-rating'),
        this.__weakFoot.appendChild(v),
        (this.__weakFootRating = document.createElement('span')),
        this.__weakFoot.appendChild(this.__weakFootRating),
        this.__statsViewDiv.appendChild(this.__weakFoot),
        (this.__statsRowFitness = document.createElement('div')),
        this.__statsRowFitness.classList.add('ut-item-row'),
        (this.__playerFitnessLabel = document.createElement('span')),
        this.__playerFitnessLabel.classList.add('ut-item-row-label--left'),
        this.__playerFitnessLabel.classList.add('ut-item-row-label'),
        this.__statsRowFitness.appendChild(this.__playerFitnessLabel);
      var f = document.createElement('div');
      f.classList.add('ut-item-progress-bar'),
        (this.__playerFitnessBar = document.createElement('span')),
        f.appendChild(this.__playerFitnessBar),
        this.__statsRowFitness.appendChild(f),
        (this.__playerFitness = document.createElement('span')),
        this.__playerFitness.classList.add('ut-item-row-label--right'),
        this.__playerFitness.classList.add('ut-item-row-label'),
        this.__statsRowFitness.appendChild(this.__playerFitness),
        this.__statsViewDiv.appendChild(this.__statsRowFitness),
        (this.__statsRowContract = document.createElement('div')),
        this.__statsRowContract.classList.add('ut-item-row'),
        (this.__playerContractLabel = document.createElement('span')),
        this.__playerContractLabel.classList.add('ut-item-row-label--left'),
        this.__playerContractLabel.classList.add('ut-item-row-label'),
        this.__statsRowContract.appendChild(this.__playerContractLabel),
        (this.__playerContract = document.createElement('span')),
        this.__playerContract.classList.add('ut-item-row-label--right'),
        this.__playerContract.classList.add('ut-item-row-label'),
        this.__statsRowContract.appendChild(this.__playerContract),
        this.__statsViewDiv.appendChild(this.__statsRowContract),
        (this.__statsRowInjury = document.createElement('div')),
        this.__statsRowInjury.classList.add('ut-item-row--multiline'),
        this.__statsRowInjury.classList.add('ut-item-row--center'),
        this.__statsRowInjury.classList.add('ut-item-row'),
        (this.__injuryLabel = document.createElement('span')),
        this.__injuryLabel.classList.add('ut-item-row-label'),
        this.__statsRowInjury.appendChild(this.__injuryLabel),
        (this.__injury = document.createElement('span')),
        this.__injury.classList.add('ut-item-row-label'),
        this.__statsRowInjury.appendChild(this.__injury),
        this.__statsViewDiv.appendChild(this.__statsRowInjury),
        e.appendChild(this.__statsViewDiv),
        (this.__styleViewDiv = document.createElement('div')),
        this.__styleViewDiv.classList.add('ut-item-view--style'),
        this.__styleViewDiv.classList.add('ut-item-view'),
        (this.__playStyleName = document.createElement('div')),
        this.__playStyleName.classList.add('name'),
        this.__styleViewDiv.appendChild(this.__playStyleName),
        (this.__playStyleLarge = document.createElement('div')),
        this.__playStyleLarge.classList.add('playStyle'),
        this.__playStyleLarge.classList.add('ut-play-style--large'),
        this.__styleViewDiv.appendChild(this.__playStyleLarge);
      var w = document.createElement('div');
      w.classList.add('statCellRow');
      var I = document.createElement('div');
      I.classList.add('statCell'),
        (this._chevronSet1 = new UTItemStatChevronsView()),
        I.appendChild(this._chevronSet1.getRootElement());
      var b = document.createElement('span');
      b.classList.add('Pace'),
        b.classList.add('statLabel'),
        I.appendChild(b),
        w.appendChild(I);
      var E = document.createElement('div');
      E.classList.add('statCell'),
        (this._chevronSet4 = new UTItemStatChevronsView()),
        E.appendChild(this._chevronSet4.getRootElement());
      var L = document.createElement('span');
      L.classList.add('Dribbling'),
        L.classList.add('statLabel'),
        E.appendChild(L),
        w.appendChild(E),
        this.__styleViewDiv.appendChild(w);
      var U = document.createElement('div');
      U.classList.add('statCellRow');
      var A = document.createElement('div');
      A.classList.add('statCell'),
        (this._chevronSet2 = new UTItemStatChevronsView()),
        A.appendChild(this._chevronSet2.getRootElement());
      var V = document.createElement('span');
      V.classList.add('Shooting'),
        V.classList.add('statLabel'),
        A.appendChild(V),
        U.appendChild(A);
      var R = document.createElement('div');
      R.classList.add('statCell'),
        (this._chevronSet5 = new UTItemStatChevronsView()),
        R.appendChild(this._chevronSet5.getRootElement());
      var P = document.createElement('span');
      P.classList.add('Defending'),
        P.classList.add('statLabel'),
        R.appendChild(P),
        U.appendChild(R),
        this.__styleViewDiv.appendChild(U);
      var D = document.createElement('div');
      D.classList.add('statCellRow');
      var O = document.createElement('div');
      O.classList.add('statCell'),
        (this._chevronSet3 = new UTItemStatChevronsView()),
        O.appendChild(this._chevronSet3.getRootElement());
      var N = document.createElement('span');
      N.classList.add('Passing'),
        N.classList.add('statLabel'),
        O.appendChild(N),
        D.appendChild(O);
      var B = document.createElement('div');
      B.classList.add('statCell'),
        (this._chevronSet6 = new UTItemStatChevronsView()),
        B.appendChild(this._chevronSet6.getRootElement());
      var M = document.createElement('span');
      M.classList.add('Header'),
        M.classList.add('statLabel'),
        B.appendChild(M),
        D.appendChild(B),
        this.__styleViewDiv.appendChild(D),
        e.appendChild(this.__styleViewDiv),
        (this.__bioViewDiv = document.createElement('div')),
        this.__bioViewDiv.classList.add('ut-item-view--bio'),
        this.__bioViewDiv.classList.add('ut-item-view');
      var q = document.createElement('div');
      q.classList.add('ut-item-row');
      var k = document.createElement('span');
      k.classList.add('ut-item-row-label--left'),
        k.classList.add('ut-item-row-label'),
        (this._bioFlagImage = new UTImageView()),
        k.appendChild(this._bioFlagImage.getRootElement()),
        q.appendChild(k),
        (this.__bioNation = document.createElement('span')),
        this.__bioNation.classList.add('ut-item-row-label--right'),
        this.__bioNation.classList.add('ut-item-row-label'),
        q.appendChild(this.__bioNation),
        this.__bioViewDiv.appendChild(q);
      var F = document.createElement('div');
      F.classList.add('ut-item-row');
      var G = document.createElement('span');
      G.classList.add('ut-item-row-label--left'),
        G.classList.add('ut-item-row-label'),
        (this._bioLeagueImage = new UTImageView()),
        G.appendChild(this._bioLeagueImage.getRootElement()),
        F.appendChild(G),
        (this.__bioLeague = document.createElement('span')),
        this.__bioLeague.classList.add('ut-item-row-label--right'),
        this.__bioLeague.classList.add('ut-item-row-label'),
        F.appendChild(this.__bioLeague),
        this.__bioViewDiv.appendChild(F);
      var x = document.createElement('div');
      x.classList.add('ut-item-row');
      var z = document.createElement('span');
      z.classList.add('ut-item-row-label--left'),
        z.classList.add('ut-item-row-label'),
        (this._bioBadgeImage = new UTImageView()),
        z.appendChild(this._bioBadgeImage.getRootElement()),
        x.appendChild(z),
        (this.__bioClub = document.createElement('span')),
        this.__bioClub.classList.add('ut-item-row-label--right'),
        this.__bioClub.classList.add('ut-item-row-label'),
        x.appendChild(this.__bioClub),
        this.__bioViewDiv.appendChild(x);
      var H = document.createElement('div');
      H.classList.add('ut-item-player-bonuses'),
        (this.__playerLoyaltyIcon = document.createElement('span')),
        this.__playerLoyaltyIcon.classList.add('ut-item-player-bonus'),
        this.__playerLoyaltyIcon.classList.add('loyalty'),
        H.appendChild(this.__playerLoyaltyIcon),
        (this.__playerManagerBonus = document.createElement('span')),
        this.__playerManagerBonus.classList.add('ut-item-player-bonus'),
        this.__playerManagerBonus.classList.add('manager'),
        H.appendChild(this.__playerManagerBonus),
        this.__bioViewDiv.appendChild(H),
        e.appendChild(this.__bioViewDiv),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTItemPlayerLargeView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._canvas.destroy(),
      (this.__trainingBoost = null),
      (this.__playerName = null),
      (this.__playStyle = null),
      (this.__mainViewDiv = null),
      (this.__loanInfoTab = null),
      (this.__playerRating = null),
      (this.__playerPosition = null),
      (this.__attribute0 = null),
      (this.__attribute3 = null),
      (this.__attribute1 = null),
      (this.__attribute4 = null),
      (this.__attribute2 = null),
      (this.__attribute5 = null),
      (this.__statsViewDiv = null),
      (this.__skillMoves = null),
      (this.__skillMovesLabel = null),
      (this.__skillMovesRating = null),
      (this.__weakFoot = null),
      (this.__weakFootLabel = null),
      (this.__weakFootRating = null),
      (this.__statsRowFitness = null),
      (this.__playerFitnessLabel = null),
      (this.__playerFitnessBar = null),
      (this.__playerFitness = null),
      (this.__statsRowContract = null),
      (this.__playerContractLabel = null),
      (this.__playerContract = null),
      (this.__statsRowInjury = null),
      (this.__injuryLabel = null),
      (this.__injury = null),
      (this.__styleViewDiv = null),
      (this.__playStyleName = null),
      (this.__playStyleLarge = null),
      this._chevronSet1.destroy(),
      this._chevronSet4.destroy(),
      this._chevronSet2.destroy(),
      this._chevronSet5.destroy(),
      this._chevronSet3.destroy(),
      this._chevronSet6.destroy(),
      (this.__bioViewDiv = null),
      this._bioFlagImage.destroy(),
      (this.__bioNation = null),
      this._bioLeagueImage.destroy(),
      (this.__bioLeague = null),
      this._bioBadgeImage.destroy(),
      (this.__bioClub = null),
      (this.__playerLoyaltyIcon = null),
      (this.__playerManagerBonus = null);
  }),
  (UTItemPlayerLargeView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTItemPlayerLargeView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTItemPlayerLargeView.prototype.init = function init() {
    this.superclass(), this._canvas.init();
  }),
  (UTItemPlayerLargeView.prototype.setItemInfoState = function setItemInfoState(
    e
  ) {
    DOMKit.toggleDisplayStyle(
      this.__playStyle,
      e !== enums.UIItemInfoState.BIO
    ),
      DOMKit.toggleDisplayStyle(
        this.__mainViewDiv,
        e === enums.UIItemInfoState.MAIN
      ),
      DOMKit.toggleDisplayStyle(
        this.__bioViewDiv,
        e === enums.UIItemInfoState.BIO
      ),
      DOMKit.toggleDisplayStyle(
        this.__statsViewDiv,
        e === enums.UIItemInfoState.STATS
      ),
      DOMKit.toggleDisplayStyle(
        this.__styleViewDiv,
        e === enums.UIItemInfoState.STYLE
      ),
      DOMKit.toggleClass(
        this.__playerName,
        'main-view',
        e === enums.UIItemInfoState.MAIN || e === enums.UIItemInfoState.STYLE
      ),
      this._canvas.rendered && this._canvas.setState(e);
  }),
  (UTItemPlayerLargeView.prototype.renderChemistry = function renderChemistry(
    e,
    t,
    i
  ) {
    this.superclass(e, t, i),
      DOMKit.toggleClass(
        this.__playerManagerBonus,
        components.ItemFUTBase.CLASS.CHEM_BONUS,
        0 < i
      );
  }),
  (UTItemPlayerLargeView.prototype._render = function _render(e, t) {
    if (e.isValid()) {
      e.concept
        ? ((t = this._createConceptRarity()),
          this._setLocalShell(e, enums.ItemViewType.LARGE))
        : this._setShell(e, enums.ItemViewType.LARGE, t.getGuid());
      var i = this.getRootElement(),
        s = e.getStaticData(),
        n = t.getExpColorMap(e.getTier());
      this._canvas &&
        (this._canvas.setSize(enums.ItemViewType.LARGE),
        this._canvas.setColorMap(n),
        (this._canvas.renderSpecial = e.isSpecial()),
        (this._canvas.renderConcept = e.concept)),
        this.superclass(e, t),
        (this.__playerName.textContent = s.name);
      var o,
        a,
        r = e.isGK();
      if (
        ((DOMKit.findElements(
          i,
          '.statValue.Pace'
        )[0].innerHTML = e
          .getAttribute(r ? enums.GKStats.DIVING : enums.PlayerStats.PACE, !1)
          .toString()),
        (DOMKit.findElements(
          i,
          '.statValue.Header'
        )[0].innerHTML = e
          .getAttribute(
            r ? enums.GKStats.POSITION : enums.PlayerStats.HEADING,
            !1
          )
          .toString()),
        (DOMKit.findElements(
          i,
          '.statValue.Dribbling'
        )[0].innerHTML = e
          .getAttribute(
            r ? enums.GKStats.REFLEX : enums.PlayerStats.DRIBBLING,
            !1
          )
          .toString()),
        (DOMKit.findElements(
          i,
          '.statValue.Shooting'
        )[0].innerHTML = e
          .getAttribute(
            r ? enums.GKStats.HANDLING : enums.PlayerStats.SHOOTING,
            !1
          )
          .toString()),
        (DOMKit.findElements(
          i,
          '.statValue.Defending'
        )[0].innerHTML = e
          .getAttribute(r ? enums.GKStats.SPEED : enums.PlayerStats.DEFEND, !1)
          .toString()),
        (DOMKit.findElements(
          i,
          '.statValue.Passing'
        )[0].innerHTML = e
          .getAttribute(
            r ? enums.GKStats.KICKING : enums.PlayerStats.PASSING,
            !1
          )
          .toString()),
        setStatLabel(
          '.statLabel.Pace',
          r
            ? services.Localization.localize('cards.cardfront.divingAbbr')
            : services.Localization.localize('cards.cardfront.paceAbbr')
        ),
        setStatLabel(
          '.statLabel.Header',
          r
            ? services.Localization.localize('cards.cardfront.positionAbbr')
            : services.Localization.localize('cards.cardfront.headingAbbr')
        ),
        setStatLabel(
          '.statLabel.Dribbling',
          r
            ? services.Localization.localize('cards.cardfront.reflexAbbr')
            : services.Localization.localize('cards.cardfront.dribblingAbbr')
        ),
        setStatLabel(
          '.statLabel.Shooting',
          r
            ? services.Localization.localize('cards.cardfront.handlingAbbr')
            : services.Localization.localize('cards.cardfront.shootingAbbr')
        ),
        setStatLabel(
          '.statLabel.Defending',
          r
            ? services.Localization.localize('cards.cardfront.speedAbbr')
            : services.Localization.localize('cards.cardfront.defendingAbbr')
        ),
        setStatLabel(
          '.statLabel.Passing',
          r
            ? services.Localization.localize('cards.cardfront.kickAbbr')
            : services.Localization.localize('cards.cardfront.passingAbbr')
        ),
        e.hasTraining())
      )
        for (
          o =
            e.getBoostLevel() === enums.ItemRatingTier.GOLD
              ? components.ItemFUTBase.QUALITY.GOLD
              : e.getBoostLevel() === enums.ItemRatingTier.SILVER
              ? components.ItemFUTBase.QUALITY.SILVER
              : components.ItemFUTBase.QUALITY.BRONZE,
            a = 0;
          a < 6;
          ++a
        )
          utils.JS.isValid(this['__attribute' + a]) &&
            e.isAttributeBoosted(a) &&
            DOMKit.addClass(this['__attribute' + a], o);
      n &&
        (this._applyColors('.playerOverview', n.header),
        this._applyColors('.name', n.name),
        this._applyColors('.ut-item-view--main .statValue', n.attributeValues),
        this._applyColors('.ut-item-view--main .statLabel', n.footer),
        this._applyColors('.playStyle span', n.playStyleText),
        this._applyColors('.playStyle', n.playStyleIcon)),
        n && this._applyColors('.ut-item-view--bio', n.name),
        DOMKit.removeClass(
          this.__statsRowContract,
          components.ItemFUTBase.CLASS.INVALID_STAT
        ),
        DOMKit.toggleClass(
          this.__statsRowFitness,
          components.ItemFUTBase.CLASS.INVALID_STAT,
          e.isInjured()
        ),
        e.isSuspended()
          ? (DOMKit.addClass(
              this.__statsRowContract,
              components.ItemFUTBase.CLASS.INVALID_STAT
            ),
            (this.__playerContractLabel.textContent = services.Localization.localize(
              'item.status.suspended'
            )),
            (this.__playerContract.textContent = ''))
          : ((this.__playerContractLabel.textContent = services.Localization.localize(
              'cards.cardfront.contractAbbr'
            )),
            (this.__playerFitnessLabel.textContent = services.Localization.localize(
              'cards.cardfront.fitnessAbbr'
            )),
            (this.__playerContract.textContent = ' ' + e.contract.toString()),
            (this.__playerFitness.textContent = e.fitness.toString()),
            (this.__playerFitnessBar.style.width = e.fitness + '%'),
            e.fitness <= 20
              ? (this.__playerFitnessBar.style.backgroundColor =
                  'rgba(224, 0, 0, 1)')
              : e.fitness <= 60 &&
                (this.__playerFitnessBar.style.backgroundColor =
                  'rgba(224, 144, 0, 1)')),
        e.isInjured()
          ? (DOMKit.toggleDisplayStyle(this.__statsRowInjury, !0),
            (this.__injuryLabel.textContent =
              services.Localization.localize('item.status.injured') +
              ' ' +
              e.injuryType),
            (this.__injury.textContent = services.Localization.localize(
              'item.status.outnummatches',
              [e.injuryGames]
            )))
          : DOMKit.toggleDisplayStyle(this.__statsRowInjury, !1),
        n && this._applyColors('.ut-item-view--stats', n.name);
      var l = e.playStyle,
        c = utils.FUTLocalization.getPlaystyleByID(l);
      if ((DOMKit.addClass(this.__playStyle, 'chemstyle' + l), e.isValid())) {
        var u = repositories.PlayStyle.getPlayStyleBonusById(l, e.isGK());
        this._applyChevrons(u);
      }
      (this.__playStyleName.textContent = c),
        DOMKit.addClass(this.__playStyleLarge, 'chemstyle' + l),
        n && this._applyColors('.ut-item-view--style', n.name);
    }

    function setStatLabel(e, t) {
      DOMKit.findElements(i, e).forEach(function(e) {
        e.innerHTML = t;
      });
    }
  }),
  (UTItemPlayerLargeView.prototype._resetRender = function _resetRender() {
    var e = this.getRootElement();
    this.superclass();
    var t = [
      components.ItemFUTBase.QUALITY.GOLD,
      components.ItemFUTBase.QUALITY.SILVER,
      components.ItemFUTBase.QUALITY.BRONZE
    ].join(' ');

    function _getIconClasses(e) {
      return (e.className.match(/(^|\s)chemstyle\S+/g) || []).join(' ');
    }
    DOMKit.findElements(e, '.statLabel').forEach(function(e) {
      DOMKit.removeClass(e, t);
    }),
      DOMKit.removeClass(this.__playStyle, _getIconClasses(this.__playStyle)),
      DOMKit.removeClass(
        this.__playStyleLarge,
        _getIconClasses(this.__playStyleLarge)
      );
  }),
  (UTItemPlayerLargeView.prototype._getAssetDimensions = function _getAssetDimensions(
    e,
    t
  ) {
    t = t || !1;
    var i = 0,
      s = 0,
      n = 0,
      o = 0;
    return (
      e === enums.ItemAssetType.MAIN
        ? ((i = t ? 113 : 73),
          (s = t ? 130 : 73),
          (n = t ? 18 : 55),
          (o = t ? 31 : 37))
        : e === enums.ItemAssetType.BADGE
        ? ((s = i = 22), (n = 33), (o = 88))
        : e === enums.ItemAssetType.FLAG
        ? ((i = 20), (s = 12), (n = 34), (o = 70))
        : e === enums.ItemAssetType.SHELL && ((i = 152), (s = 212)),
      new UTItemCanvasDTO(null, t, i, s, n, o)
    );
  }),
  (UTItemPlayerLargeView.prototype._setSkillMoves = function _setSkillMoves(e) {
    (this.__skillMovesLabel.textContent = services.Localization.localize(
      'cards.cardfront.skillMoves'
    )),
      (this.__skillMovesRating.textContent = e);
  }),
  (UTItemPlayerLargeView.prototype._setWeakFoot = function _setWeakFoot(e, t) {
    var i = e
      ? services.Localization.localize('cards.cardfront.weakFootRightAbbr')
      : services.Localization.localize('cards.cardfront.weakFootLeftAbbr');
    services.Localization.localize('cards.cardfront.weakFootAbbr'),
      (this.__weakFootLabel.textContent =
        services.Localization.localize('cards.cardfront.weakFoot') +
        ' (' +
        i +
        ')'),
      (this.__weakFootRating.textContent = t);
  }),
  utils.JS.inherits(UTItemPlayerSmallView, components.ItemPlayerBase),
  (UTItemPlayerSmallView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('player'),
        e.classList.add('item'),
        (this._canvas = new UTItemPlayerCanvasView()),
        (this._canvas.width = '97'),
        (this._canvas.height = '114'),
        e.appendChild(this._canvas.getRootElement());
      var t = document.createElement('div');
      t.classList.add('ut-item-loader'), e.appendChild(t);
      var i = document.createElement('div');
      i.classList.add('statusOverlay'),
        e.appendChild(i),
        (this.__trainingBoost = document.createElement('div')),
        this.__trainingBoost.classList.add('ut-item-player-status--training'),
        this.__trainingBoost.classList.add('ut-item-player-status'),
        e.appendChild(this.__trainingBoost);
      var s = document.createElement('div');
      s.classList.add('ut-item-player-status--restricted'),
        s.classList.add('ut-item-player-status'),
        e.appendChild(s),
        (this.__mainViewDiv = document.createElement('div')),
        this.__mainViewDiv.classList.add('ut-item-view--main'),
        this.__mainViewDiv.classList.add('ut-item-view'),
        (this.__loanInfoTab = document.createElement('div')),
        this.__loanInfoTab.classList.add('ut-item-player-status--loan'),
        this.__mainViewDiv.appendChild(this.__loanInfoTab);
      var n = document.createElement('div');
      n.classList.add('playerOverview'),
        (this.__playerRating = document.createElement('div')),
        this.__playerRating.classList.add('rating'),
        n.appendChild(this.__playerRating),
        (this.__playerPosition = document.createElement('div')),
        this.__playerPosition.classList.add('position'),
        n.appendChild(this.__playerPosition),
        this.__mainViewDiv.appendChild(n),
        e.appendChild(this.__mainViewDiv),
        (this.__statsViewDiv = document.createElement('div')),
        this.__statsViewDiv.classList.add('ut-item-view--stats'),
        this.__statsViewDiv.classList.add('ut-item-view'),
        (this.__skillMoves = document.createElement('div')),
        this.__skillMoves.classList.add('ut-item-row'),
        (this.__skillMovesLabel = document.createElement('span')),
        this.__skillMovesLabel.classList.add('ut-item-row-label--left'),
        this.__skillMovesLabel.classList.add('ut-item-row-label'),
        this.__skillMoves.appendChild(this.__skillMovesLabel);
      var o = document.createElement('div');
      o.classList.add('ut-star-rating'),
        this.__skillMoves.appendChild(o),
        (this.__skillMovesRating = document.createElement('span')),
        this.__skillMoves.appendChild(this.__skillMovesRating),
        this.__statsViewDiv.appendChild(this.__skillMoves),
        (this.__weakFoot = document.createElement('div')),
        this.__weakFoot.classList.add('ut-item-row'),
        (this.__weakFootLabel = document.createElement('span')),
        this.__weakFootLabel.classList.add('ut-item-row-label--left'),
        this.__weakFootLabel.classList.add('ut-item-row-label'),
        this.__weakFoot.appendChild(this.__weakFootLabel);
      var a = document.createElement('div');
      a.classList.add('ut-star-rating'),
        this.__weakFoot.appendChild(a),
        (this.__weakFootRating = document.createElement('span')),
        this.__weakFoot.appendChild(this.__weakFootRating),
        this.__statsViewDiv.appendChild(this.__weakFoot),
        (this.__statsRowFitness = document.createElement('div')),
        this.__statsRowFitness.classList.add('ut-item-row'),
        (this.__playerFitnessLabel = document.createElement('span')),
        this.__statsRowFitness.appendChild(this.__playerFitnessLabel);
      var r = document.createElement('div');
      r.classList.add('ut-item-progress-bar'),
        (this.__playerFitnessBar = document.createElement('span')),
        r.appendChild(this.__playerFitnessBar),
        this.__statsRowFitness.appendChild(r),
        (this.__playerFitness = document.createElement('span')),
        this.__statsRowFitness.appendChild(this.__playerFitness),
        this.__statsViewDiv.appendChild(this.__statsRowFitness),
        (this.__statsRowContract = document.createElement('div')),
        this.__statsRowContract.classList.add('contracts'),
        this.__statsRowContract.classList.add('ut-item-row--center'),
        this.__statsRowContract.classList.add('ut-item-row'),
        (this.__playerContractLabel = document.createElement('span')),
        this.__playerContractLabel.classList.add('ut-item-row-label'),
        this.__statsRowContract.appendChild(this.__playerContractLabel),
        (this.__playerContract = document.createElement('span')),
        this.__playerContract.classList.add('ut-item-row-label'),
        this.__statsRowContract.appendChild(this.__playerContract),
        this.__statsViewDiv.appendChild(this.__statsRowContract),
        e.appendChild(this.__statsViewDiv),
        (this.__styleViewDiv = document.createElement('div')),
        this.__styleViewDiv.classList.add('ut-item-view--style'),
        this.__styleViewDiv.classList.add('ut-item-view');
      var l = document.createElement('div');
      l.classList.add('ut-item-row'), l.classList.add('statCellRow');
      var c = document.createElement('div');
      c.classList.add('statCell'),
        (this._chevronSet1 = new UTItemStatChevronsView()),
        c.appendChild(this._chevronSet1.getRootElement()),
        (this.__statLabel1 = document.createElement('span')),
        this.__statLabel1.classList.add('statLabel'),
        c.appendChild(this.__statLabel1),
        l.appendChild(c);
      var u = document.createElement('div');
      u.classList.add('statCell'),
        (this._chevronSet4 = new UTItemStatChevronsView()),
        u.appendChild(this._chevronSet4.getRootElement()),
        (this.__statLabel4 = document.createElement('span')),
        this.__statLabel4.classList.add('Dribbling'),
        this.__statLabel4.classList.add('statLabel'),
        u.appendChild(this.__statLabel4),
        l.appendChild(u),
        this.__styleViewDiv.appendChild(l);
      var d = document.createElement('div');
      d.classList.add('ut-item-row'), d.classList.add('statCellRow');
      var h = document.createElement('div');
      h.classList.add('statCell'),
        (this._chevronSet2 = new UTItemStatChevronsView()),
        h.appendChild(this._chevronSet2.getRootElement()),
        (this.__statLabel2 = document.createElement('span')),
        this.__statLabel2.classList.add('Shooting'),
        this.__statLabel2.classList.add('statLabel'),
        h.appendChild(this.__statLabel2),
        d.appendChild(h);
      var p = document.createElement('div');
      p.classList.add('statCell'),
        (this._chevronSet5 = new UTItemStatChevronsView()),
        p.appendChild(this._chevronSet5.getRootElement()),
        (this.__statLabel5 = document.createElement('span')),
        this.__statLabel5.classList.add('Defending'),
        this.__statLabel5.classList.add('statLabel'),
        p.appendChild(this.__statLabel5),
        d.appendChild(p),
        this.__styleViewDiv.appendChild(d);
      var _ = document.createElement('div');
      _.classList.add('ut-item-row'), _.classList.add('statCellRow');
      var m = document.createElement('div');
      m.classList.add('statCell'),
        (this._chevronSet3 = new UTItemStatChevronsView()),
        m.appendChild(this._chevronSet3.getRootElement()),
        (this.__statLabel3 = document.createElement('span')),
        this.__statLabel3.classList.add('Passing'),
        this.__statLabel3.classList.add('statLabel'),
        m.appendChild(this.__statLabel3),
        _.appendChild(m);
      var g = document.createElement('div');
      g.classList.add('statCell'),
        (this._chevronSet6 = new UTItemStatChevronsView()),
        g.appendChild(this._chevronSet6.getRootElement()),
        (this.__statLabel6 = document.createElement('span')),
        this.__statLabel6.classList.add('Header'),
        this.__statLabel6.classList.add('statLabel'),
        g.appendChild(this.__statLabel6),
        _.appendChild(g),
        this.__styleViewDiv.appendChild(_),
        e.appendChild(this.__styleViewDiv),
        (this.__bioViewDiv = document.createElement('div')),
        this.__bioViewDiv.classList.add('ut-item-view--bio'),
        this.__bioViewDiv.classList.add('ut-item-view');
      var T = document.createElement('div');
      T.classList.add('ut-item-row');
      var S = document.createElement('span');
      S.classList.add('ut-item-row-label--left'),
        S.classList.add('ut-item-row-label'),
        (this._bioFlagImage = new UTImageView()),
        S.appendChild(this._bioFlagImage.getRootElement()),
        T.appendChild(S),
        (this.__bioNation = document.createElement('span')),
        this.__bioNation.classList.add('ut-item-row-label--right'),
        this.__bioNation.classList.add('ut-item-row-label'),
        T.appendChild(this.__bioNation),
        this.__bioViewDiv.appendChild(T);
      var C = document.createElement('div');
      C.classList.add('ut-item-row');
      var y = document.createElement('span');
      y.classList.add('ut-item-row-label--left'),
        y.classList.add('ut-item-row-label'),
        (this._bioLeagueImage = new UTImageView()),
        y.appendChild(this._bioLeagueImage.getRootElement()),
        C.appendChild(y),
        (this.__bioLeague = document.createElement('span')),
        this.__bioLeague.classList.add('ut-item-row-label--right'),
        this.__bioLeague.classList.add('ut-item-row-label'),
        C.appendChild(this.__bioLeague),
        this.__bioViewDiv.appendChild(C);
      var v = document.createElement('div');
      v.classList.add('ut-item-row');
      var f = document.createElement('span');
      f.classList.add('ut-item-row-label--left'),
        f.classList.add('ut-item-row-label'),
        (this._bioBadgeImage = new UTImageView()),
        f.appendChild(this._bioBadgeImage.getRootElement()),
        v.appendChild(f),
        (this.__bioClub = document.createElement('span')),
        this.__bioClub.classList.add('ut-item-row-label--right'),
        this.__bioClub.classList.add('ut-item-row-label'),
        v.appendChild(this.__bioClub),
        this.__bioViewDiv.appendChild(v);
      var w = document.createElement('div');
      w.classList.add('ut-item-player-bonuses'),
        w.classList.add('ut-item-row'),
        (this.__playerLoyaltyIcon = document.createElement('span')),
        this.__playerLoyaltyIcon.classList.add('ut-item-player-bonus'),
        this.__playerLoyaltyIcon.classList.add('loyalty'),
        w.appendChild(this.__playerLoyaltyIcon),
        (this.__playerManagerBonus = document.createElement('span')),
        this.__playerManagerBonus.classList.add('ut-item-player-bonus'),
        this.__playerManagerBonus.classList.add('manager'),
        w.appendChild(this.__playerManagerBonus),
        this.__bioViewDiv.appendChild(w),
        e.appendChild(this.__bioViewDiv),
        (this.__playStyle = document.createElement('div')),
        this.__playStyle.classList.add('playStyle'),
        e.appendChild(this.__playStyle),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTItemPlayerSmallView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._canvas.destroy(),
      (this.__trainingBoost = null),
      (this.__mainViewDiv = null),
      (this.__loanInfoTab = null),
      (this.__playerRating = null),
      (this.__playerPosition = null),
      (this.__statsViewDiv = null),
      (this.__skillMoves = null),
      (this.__skillMovesLabel = null),
      (this.__skillMovesRating = null),
      (this.__weakFoot = null),
      (this.__weakFootLabel = null),
      (this.__weakFootRating = null),
      (this.__statsRowFitness = null),
      (this.__playerFitnessLabel = null),
      (this.__playerFitnessBar = null),
      (this.__playerFitness = null),
      (this.__statsRowContract = null),
      (this.__playerContractLabel = null),
      (this.__playerContract = null),
      (this.__styleViewDiv = null),
      this._chevronSet1.destroy(),
      (this.__statLabel1 = null),
      this._chevronSet4.destroy(),
      (this.__statLabel4 = null),
      this._chevronSet2.destroy(),
      (this.__statLabel2 = null),
      this._chevronSet5.destroy(),
      (this.__statLabel5 = null),
      this._chevronSet3.destroy(),
      (this.__statLabel3 = null),
      this._chevronSet6.destroy(),
      (this.__statLabel6 = null),
      (this.__bioViewDiv = null),
      this._bioFlagImage.destroy(),
      (this.__bioNation = null),
      this._bioLeagueImage.destroy(),
      (this.__bioLeague = null),
      this._bioBadgeImage.destroy(),
      (this.__bioClub = null),
      (this.__playerLoyaltyIcon = null),
      (this.__playerManagerBonus = null),
      (this.__playStyle = null);
  }),
  (UTItemPlayerSmallView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTItemPlayerSmallView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTItemPlayerSmallView.prototype.init = function init() {
    this.superclass(), this._canvas.init();
  }),
  (UTItemPlayerSmallView.prototype.setItemInfoState = function setItemInfoState(
    e
  ) {
    DOMKit.toggleDisplayStyle(
      this.__statsViewDiv,
      e === enums.UIItemInfoState.STATS
    ),
      DOMKit.toggleDisplayStyle(
        this.__bioViewDiv,
        e === enums.UIItemInfoState.BIO
      ),
      DOMKit.toggleDisplayStyle(
        this.__mainViewDiv,
        e === enums.UIItemInfoState.MAIN
      ),
      DOMKit.toggleDisplayStyle(
        this.__styleViewDiv,
        e === enums.UIItemInfoState.STYLE
      ),
      DOMKit.toggleDisplayStyle(
        this.__playStyle,
        e === enums.UIItemInfoState.STYLE || e === enums.UIItemInfoState.MAIN
      ),
      this._canvas.rendered && this._canvas.setState(e);
  }),
  (UTItemPlayerSmallView.prototype.renderChemistry = function renderChemistry(
    e,
    t,
    i
  ) {
    this.superclass(e, t, i),
      DOMKit.toggleClass(
        this.__playerManagerBonus,
        components.ItemFUTBase.CLASS.CHEM_BONUS,
        0 < i
      );
  }),
  (UTItemPlayerSmallView.prototype._render = function _render(e, t) {
    if ((this.getRoot().data('info', e), e.isValid())) {
      e.concept
        ? ((t = this._createConceptRarity()),
          this._setLocalShell(e, enums.ItemViewType.SMALL))
        : this._setShell(e, enums.ItemViewType.SMALL, t.getGuid());
      var i = e.playStyle,
        s = t.getSmallColorMap(e.getTier());
      this._canvas &&
        (this._canvas.setSize(enums.ItemViewType.SMALL),
        this._canvas.setColorMap(s),
        (this._canvas.renderSpecial = e.isSpecial()),
        (this._canvas.renderConcept = e.concept)),
        this.superclass(e, t),
        s &&
          (this._applyColors('.playerOverview', s.header),
          this._applyColors('.playStyle', s.playStyleIcon)),
        DOMKit.addClass(this.__playStyle, 'chemstyle' + i),
        s && this._applyColors('.ut-item-view--bio', s.footer),
        DOMKit.removeClass(
          this.__statsRowContract,
          components.ItemFUTBase.CLASS.INVALID_STAT
        ),
        DOMKit.toggleClass(
          this.__statsRowFitness,
          components.ItemFUTBase.CLASS.INVALID_STAT,
          e.isInjured()
        ),
        e.isSuspended()
          ? (DOMKit.addClass(
              this.__statsRowContract,
              components.ItemFUTBase.CLASS.INVALID_STAT
            ),
            (this.__playerContractLabel.textContent = services.Localization.localize(
              'item.status.suspended'
            )))
          : ((this.__playerContractLabel.textContent = services.Localization.localize(
              'cards.cardfront.contractAbbr'
            )),
            (this.__playerFitnessLabel.textContent = services.Localization.localize(
              'cards.cardfront.fitnessAbbr'
            )),
            (this.__playerContract.textContent = e.contract.toString()),
            (this.__playerFitness.textContent = e.fitness.toString()),
            (this.__playerFitnessBar.style.width = e.fitness + '%'),
            e.fitness <= 20
              ? (this.__playerFitnessBar.style.backgroundColor =
                  'rgba(224,0,0,1)')
              : e.fitness < 60 &&
                (this.__playerFitnessBar.style.backgroundColor =
                  'rgba(224,142,0,1)')),
        s && this._applyColors('.ut-item-view--stats', s.footer);
      var n = e.isGK();
      if (
        ((this.__statLabel1.textContent = services.Localization.localize(
          n ? 'cards.cardfront.divingAbbr' : 'cards.cardfront.paceAbbr'
        )),
        (this.__statLabel2.textContent = services.Localization.localize(
          n ? 'cards.cardfront.handlingAbbr' : 'cards.cardfront.shootingAbbr'
        )),
        (this.__statLabel3.textContent = services.Localization.localize(
          n ? 'cards.cardfront.kickAbbr' : 'cards.cardfront.passingAbbr'
        )),
        (this.__statLabel4.textContent = services.Localization.localize(
          n ? 'cards.cardfront.reflexAbbr' : 'cards.cardfront.dribblingAbbr'
        )),
        (this.__statLabel5.textContent = services.Localization.localize(
          n ? 'cards.cardfront.speedAbbr' : 'cards.cardfront.defendingAbbr'
        )),
        (this.__statLabel6.textContent = services.Localization.localize(
          n ? 'cards.cardfront.positionAbbr' : 'cards.cardfront.headingAbbr'
        )),
        e.isValid())
      ) {
        var o = repositories.PlayStyle.getPlayStyleBonusById(i, e.isGK());
        this._applyChevrons(o);
      }
      s && this._applyColors('.ut-item-view--style', s.footer);
    }
  }),
  (UTItemPlayerSmallView.prototype._resetRender = function _resetRender() {
    this.superclass(),
      DOMKit.removeClass(
        this.__playStyle,
        (function _getIconClasses(e) {
          return (e.className.match(/(^|\s)chemstyle\S+/g) || []).join(' ');
        })(this.__playStyle)
      );
  }),
  (UTItemPlayerSmallView.prototype._getAssetDimensions = function _getAssetDimensions(
    e,
    t
  ) {
    t = t || !1;
    var i = 0,
      s = 0,
      n = 0,
      o = 0;
    return (
      e === enums.ItemAssetType.MAIN
        ? ((i = t ? 78 : 53),
          (s = t ? 85 : 53),
          (n = t ? 6 : 32),
          (o = t ? 21 : 28))
        : e === enums.ItemAssetType.BADGE
        ? ((s = i = 18), (n = 14), (o = 63))
        : e === enums.ItemAssetType.FLAG
        ? ((i = 14), (s = 8), (n = 16), (o = 53))
        : e === enums.ItemAssetType.SHELL && ((i = 97), (s = 114)),
      new UTItemCanvasDTO(null, t, i, s, n, o)
    );
  }),
  (UTItemPlayerSmallView.prototype._setSkillMoves = function _setSkillMoves(e) {
    (this.__skillMovesLabel.textContent = services.Localization.localize(
      'cards.cardfront.skillMovesAbbr'
    )),
      (this.__skillMovesRating.textContent = e);
  }),
  (UTItemPlayerSmallView.prototype._setWeakFoot = function _setWeakFoot(e, t) {
    var i = e
      ? services.Localization.localize('cards.cardfront.weakFootRightAbbr')
      : services.Localization.localize('cards.cardfront.weakFootLeftAbbr');
    (this.__weakFootLabel.textContent =
      services.Localization.localize('cards.cardfront.weakFootAbbr') +
      ' (' +
      i +
      ')'),
      (this.__weakFootRating.textContent = t);
  }),
  (components.ItemManagerBase = function ItemManagerBaseView() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemManagerBase, components.ItemFUTBase),
  (components.ItemManagerBase.onImageLoad = function onImageLoad(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.STAFF + '.png')
        );
  }),
  (components.ItemManagerBase.prototype._render = function _render(e, t) {
    if (((this.__position.textContent = ''), e.isValid())) {
      var i = e.getYear();
      e.concept ||
        !e.isContractExpired() ||
        e.getAuctionData().isSold() ||
        this.addClass(components.ItemFUTBase.CLASS.CONTRACT_EXPIRED);
      var s = utils.AssetLocator.hasPlaceholder(
          enums.PlaceholderAssetKey.STAFF,
          e.getMaskedResourceId().toString(),
          i
        )
          ? enums.PlaceholderAssetId.STAFF
          : e.getMaskedResourceId(),
        n = utils.AssetLocator.getImage(
          utils.AssetLocator.IMAGE_TYPE_PORTRAIT,
          i,
          s
        );
      (this.assets[enums.ItemAssetType.MAIN] = this._getAssetDimensions(
        enums.ItemAssetType.MAIN,
        !1
      )),
        this._requestResource(n, enums.ItemAssetType.MAIN, e),
        this._setFlag(e);
      var o = t.getExpColorMap(e.getTier());
      this._setLeague(e, o.useLightCrest),
        (this.__position.textContent = services.Localization.localize(
          'cards.cardfrontlarge.manager'
        ));
    }
  }),
  (components.ItemManagerBase.prototype._setFlag = function _setFlag(e) {
    var t = utils.AssetLocator.getImage(
      utils.AssetLocator.IMAGE_TYPE_FLAG,
      e.getYear(),
      e.nationId
    );
    (this.assets[enums.ItemAssetType.FLAG] = this._getAssetDimensions(
      enums.ItemAssetType.FLAG,
      !1
    )),
      this._requestResource(t, enums.ItemAssetType.FLAG, e),
      this._bioFlagImage.setResource(t);
  }),
  (components.ItemManagerBase.prototype._setLeague = function _setLeague(e, t) {
    var i = utils.AssetLocator.getImage(
      t
        ? utils.AssetLocator.IMAGE_TYPE_LEAGUE_LIGHT
        : utils.AssetLocator.IMAGE_TYPE_LEAGUE_DARK,
      e.getYear(),
      e.leagueId
    );
    this._bioLeagueImage.setResource(i),
      (this.assets[enums.ItemAssetType.BADGE] = this._getAssetDimensions(
        enums.ItemAssetType.BADGE,
        !1
      )),
      this._requestResource(i, enums.ItemAssetType.BADGE, e);
  }),
  (components.ItemManagerBase.prototype.canRender = function canRender(e) {
    return e.isManager();
  }),
  (components.ItemManagerBase.prototype._resetRender = function _resetRender() {
    this.removeClass(components.ItemFUTBase.CLASS.CONTRACT_EXPIRED),
      this.getRootElement().removeAttribute('style'),
      (this.assets = {});
  }),
  utils.JS.inherits(UTItemManagerCanvasView, UTItemCanvasView),
  (UTItemManagerCanvasView.prototype.setState = function setState(e) {
    switch ((this.clearCanvas(), e)) {
      case enums.UIItemInfoState.MAIN:
      case enums.UIItemInfoState.STATS:
        this._renderMainView();
        break;
      case enums.UIItemInfoState.BIO:
      case enums.UIItemInfoState.STYLE:
        this._renderBioView();
    }
    this.rendered = !0;
  }),
  (UTItemManagerCanvasView.prototype._renderMainView = function _renderMainView() {
    if (
      (this._drawAsset(enums.ItemAssetType.SHELL),
      this._drawAsset(enums.ItemAssetType.MAIN),
      this._drawAsset(enums.ItemAssetType.FLAG),
      this._drawAsset(enums.ItemAssetType.BADGE),
      this.size === enums.ItemViewType.LARGE)
    ) {
      var e = (this.getWidth() - 1) / 2;
      this._drawDivider(34, 130.5, 117, 130.5);
      var t = e - 9.5,
        i = e + 9.5;
      this._drawDivider(t, 175.5, i, 175.5),
        this._drawDivider(36, 66, 49, 66),
        this._drawDivider(36, 85, 49, 85);
    }
  }),
  (UTItemManagerCanvasView.prototype._renderBioView = function _renderBioView() {
    var e, t;
    if (
      (this._drawAsset(enums.ItemAssetType.SHELL),
      this._drawBgColor(),
      this.size === enums.ItemViewType.LARGE)
    ) {
      var i = this.getWidth(),
        s = (i - 1) / 2;
      (t = i - (e = 26)),
        this._drawDivider(e, 55.5, t, 55.5),
        this._drawDivider(e, 81.5, t, 81.5),
        this._drawDivider(e, 108.5, t, 108.5),
        this._drawDivider(e, 134.5, t, 134.5),
        this._drawDivider(e, 160.5, t, 160.5),
        (t = e = s - 10.5),
        this._drawDivider(e, 175.5, t, 175.5);
    } else
      this.size === enums.ItemViewType.SMALL &&
        ((e = 17),
        (t = this.getWidth() - 17),
        this._drawDivider(e, 26.4, t, 26.4),
        this._drawDivider(e, 45.7, t, 45.7),
        this._drawDivider(e, 64.7, t, 64.7),
        this._drawDivider(e, 84.4, t, 84.4));
  }),
  (components.ItemManagerLarge = function ItemManagerLargeView() {
    components.ItemManagerBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemManagerLarge, components.ItemManagerBase),
  (components.ItemManagerLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('manager'),
        e.classList.add('staff'),
        e.classList.add('item'),
        (this._canvas = new UTItemManagerCanvasView()),
        (this._canvas.width = '152'),
        (this._canvas.height = '212'),
        e.appendChild(this._canvas.getRootElement());
      var t = document.createElement('div');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this.__infoTab = document.createElement('div')),
        this.__infoTab.classList.add('infoTab'),
        e.appendChild(this.__infoTab),
        (this.__position = document.createElement('div')),
        this.__position.classList.add('position'),
        e.appendChild(this.__position),
        (this.__itemName = document.createElement('div')),
        this.__itemName.classList.add('name'),
        e.appendChild(this.__itemName),
        (this.__mainViewDiv = document.createElement('div')),
        this.__mainViewDiv.classList.add('mainView'),
        (this.__managerText = document.createElement('div')),
        this.__managerText.classList.add('infoRow'),
        this.__mainViewDiv.appendChild(this.__managerText),
        e.appendChild(this.__mainViewDiv),
        (this.__bioViewDiv = document.createElement('div')),
        this.__bioViewDiv.classList.add('bioView');
      var i = document.createElement('div');
      i.classList.add('ut-item-row');
      var s = document.createElement('span');
      s.classList.add('ut-item-row-label--left'),
        s.classList.add('ut-item-row-label'),
        (this._bioFlagImage = new UTImageView()),
        s.appendChild(this._bioFlagImage.getRootElement()),
        i.appendChild(s),
        (this.__managerNation = document.createElement('span')),
        this.__managerNation.classList.add('ut-item-row-label--right'),
        this.__managerNation.classList.add('ut-item-row-label'),
        i.appendChild(this.__managerNation),
        this.__bioViewDiv.appendChild(i);
      var n = document.createElement('div');
      n.classList.add('ut-item-row');
      var o = document.createElement('span');
      o.classList.add('ut-item-row-label--left'),
        o.classList.add('ut-item-row-label'),
        (this._bioLeagueImage = new UTImageView()),
        o.appendChild(this._bioLeagueImage.getRootElement()),
        n.appendChild(o),
        (this.__managerLeague = document.createElement('span')),
        this.__managerLeague.classList.add('ut-item-row-label--right'),
        this.__managerLeague.classList.add('ut-item-row-label'),
        n.appendChild(this.__managerLeague),
        this.__bioViewDiv.appendChild(n);
      var a = document.createElement('div');
      a.classList.add('ut-item-row'),
        (this.__managerNegotiationTitle = document.createElement('span')),
        this.__managerNegotiationTitle.classList.add('ut-item-row-label--left'),
        this.__managerNegotiationTitle.classList.add('ut-item-row-label'),
        a.appendChild(this.__managerNegotiationTitle),
        (this.__managerNegotiation = document.createElement('span')),
        this.__managerNegotiation.classList.add('ut-item-row-label--right'),
        this.__managerNegotiation.classList.add('ut-item-row-label'),
        a.appendChild(this.__managerNegotiation),
        this.__bioViewDiv.appendChild(a);
      var r = document.createElement('div');
      r.classList.add('ut-item-row'),
        (this.__managerContractTitle = document.createElement('span')),
        this.__managerContractTitle.classList.add('ut-item-row-label--left'),
        this.__managerContractTitle.classList.add('ut-item-row-label'),
        r.appendChild(this.__managerContractTitle),
        (this.__managerContract = document.createElement('span')),
        this.__managerContract.classList.add('ut-item-row-label--right'),
        this.__managerContract.classList.add('ut-item-row-label'),
        r.appendChild(this.__managerContract),
        this.__bioViewDiv.appendChild(r),
        e.appendChild(this.__bioViewDiv);
      var l = document.createElement('div');
      l.classList.add('manager'),
        l.classList.add('iconStaff'),
        e.appendChild(l),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemManagerLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._canvas.destroy(),
      (this.__infoTab = null),
      (this.__position = null),
      (this.__itemName = null),
      (this.__mainViewDiv = null),
      (this.__managerText = null),
      (this.__bioViewDiv = null),
      this._bioFlagImage.destroy(),
      (this.__managerNation = null),
      this._bioLeagueImage.destroy(),
      (this.__managerLeague = null),
      (this.__managerNegotiationTitle = null),
      (this.__managerNegotiation = null),
      (this.__managerContractTitle = null),
      (this.__managerContract = null);
  }),
  (components.ItemManagerLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemManagerLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemManagerLarge.prototype.init = function init() {
    this.superclass(), this._canvas.init();
  }),
  (components.ItemManagerLarge.prototype.setItemInfoState = function setItemInfoState(
    e
  ) {
    DOMKit.toggleDisplayStyle(
      this.__position,
      e === enums.UIItemInfoState.MAIN || e === enums.UIItemInfoState.STATS
    ),
      DOMKit.toggleDisplayStyle(
        this.__mainViewDiv,
        e === enums.UIItemInfoState.MAIN || e === enums.UIItemInfoState.STATS
      ),
      DOMKit.toggleDisplayStyle(
        this.__bioViewDiv,
        e !== enums.UIItemInfoState.MAIN && e !== enums.UIItemInfoState.STATS
      ),
      DOMKit.toggleClass(
        this.__itemName,
        'main-view',
        e === enums.UIItemInfoState.MAIN || e === enums.UIItemInfoState.STATS
      ),
      this._canvas.rendered && this._canvas.setState(e);
  }),
  (components.ItemManagerLarge.prototype._render = function _render(e, t) {
    var i = e.getStaticData(),
      s = e.isValid();
    this.superclass(e, t),
      this._canvas &&
        (this._canvas.setSize(enums.ItemViewType.LARGE),
        this._canvas.setColorMap(t.getExpColorMap(e.getTier()))),
      s && this._setShell(e, enums.ItemViewType.LARGE),
      (this.__itemName.textContent = i.name);
    var n = s ? t.getExpColorMap(e.getTier()) : null;
    (this.__managerText.textContent = services.Localization.localize(
      'cards.cardfront.manager'
    )),
      n &&
        (this._applyColors('.position', n.header),
        this._applyColors('.name', n.name),
        this._applyColors('.mainView .infoRow', n.footer)),
      (this.__managerNation.textContent = utils.FUTLocalization.getNationNameById(
        e.nationId
      )),
      (this.__managerLeague.textContent = utils.FUTLocalization.getLeagueNameByID(
        e.leagueId,
        e.getYear()
      )),
      (this.__managerNegotiationTitle.textContent = services.Localization.localize(
        'cards.cardfront.negotiations'
      )),
      (this.__managerNegotiation.textContent = i.amount + '%'),
      (this.__managerContractTitle.textContent = services.Localization.localize(
        'cards.cardfront.contracts'
      )),
      (this.__managerContract.textContent = services.Localization.localizeNumber(
        e.contract
      )),
      n && this._applyColors('.bioView .infoRow', n.footer);
  }),
  (components.ItemManagerLarge.prototype._getAssetDimensions = function _getAssetDimensions(
    e,
    t
  ) {
    t = t || !1;
    var i = 0,
      s = 0,
      n = 0,
      o = 0;
    return (
      e === enums.ItemAssetType.MAIN
        ? ((s = i = 73), (n = 55), (o = 37))
        : e === enums.ItemAssetType.BADGE
        ? ((s = i = 18), (n = 34), (o = 88))
        : e === enums.ItemAssetType.FLAG
        ? ((i = 18), (s = 13), (n = 34), (o = 69))
        : e === enums.ItemAssetType.SHELL && ((i = 152), (s = 212)),
      new UTItemCanvasDTO(null, t, i, s, n, o)
    );
  }),
  (components.ItemStaffBase = function ItemStaffBaseView() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemStaffBase, components.ItemFUTBase),
  (components.ItemStaffBase.ICON = {
    HEAD_COACH: 'headCoach',
    GK_COACH: 'gkCoach',
    FITNESS_COACH: 'fitnessCoach',
    PHYSIO_COACH: 'physioCoach'
  }),
  (components.ItemStaffBase.onImageLoad = function onImageLoad(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.STAFF + '.png')
        );
  }),
  (components.ItemStaffBase.prototype._render = function _render(e, t) {
    var i = '',
      s = e.getYear();
    switch (e.type) {
      case enums.ItemType.HEAD_COACH:
        i = components.ItemStaffBase.ICON.HEAD_COACH;
        break;
      case enums.ItemType.GK_COACH:
        i = components.ItemStaffBase.ICON.GK_COACH;
        break;
      case enums.ItemType.FITNESS_COACH:
        i = components.ItemStaffBase.ICON.FITNESS_COACH;
        break;
      case enums.ItemType.PHYSIO:
        i = components.ItemStaffBase.ICON.PHYSIO_COACH;
        break;
      default:
        utils.Debug.Assert(
          !1,
          '[components.ItemStaffBase] Reached default case when selecting the icon in _render() method.'
        );
    }
    DOMKit.addClass(this.__itemIcon, i);
    var n = utils.AssetLocator.getImage(
      utils.AssetLocator.IMAGE_TYPE_PORTRAIT,
      s,
      e.getMaskedResourceId()
    );
    utils.AssetLocator.hasPlaceholder(
      enums.PlaceholderAssetKey.STAFF,
      e.getMaskedResourceId().toString(),
      s
    ) &&
      (n = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_PORTRAIT,
        s,
        enums.PlaceholderAssetId.STAFF
      )),
      this._mainImage
        .setResource(n, !0)
        .observe(this._mainImage, components.ItemStaffBase.onImageLoad);
  }),
  (components.ItemStaffBase.prototype.canRender = function canRender(e) {
    return e.isCoach();
  }),
  (components.ItemStaffBase.prototype._resetRender = function _resetRender() {
    var e = [
      components.ItemStaffBase.ICON.HEAD_COACH,
      components.ItemStaffBase.ICON.GK_COACH,
      components.ItemStaffBase.ICON.FITNESS_COACH,
      components.ItemStaffBase.ICON.PHYSIO_COACH
    ].join(' ');
    DOMKit.removeClass(this.__itemIcon, e),
      this.getRootElement().removeAttribute('style');
  }),
  (components.ItemStaffLarge = function ItemStaffLargeView() {
    components.ItemStaffBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemStaffLarge, components.ItemStaffBase),
  (components.ItemStaffLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('staff'),
        e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('staff'),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__itemName = document.createElement('div')),
        this.__itemName.classList.add('name'),
        e.appendChild(this.__itemName);
      var i = document.createElement('div');
      i.classList.add('infoView'),
        (this.__line1 = document.createElement('div')),
        this.__line1.classList.add('infoRow'),
        i.appendChild(this.__line1),
        (this.__line2 = document.createElement('div')),
        this.__line2.classList.add('infoRow'),
        i.appendChild(this.__line2),
        e.appendChild(i);
      var s = document.createElement('div');
      s.classList.add('debugView'),
        (this.__staffDebug = document.createElement('div')),
        this.__staffDebug.classList.add('infoRow'),
        s.appendChild(this.__staffDebug),
        e.appendChild(s),
        (this.__itemIcon = document.createElement('div')),
        this.__itemIcon.classList.add('iconStaff'),
        e.appendChild(this.__itemIcon),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemStaffLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy(),
      (this.__itemName = null),
      (this.__line1 = null),
      (this.__line2 = null),
      (this.__staffDebug = null),
      (this.__itemIcon = null);
  }),
  (components.ItemStaffLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemStaffLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemStaffLarge.prototype._render = function _render(e, t) {
    var i = e.getStaticData();
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.LARGE);
    var s = t.getExpColorMap(e.getTier());
    (this.__itemName.textContent = i.name),
      (this.__line1.textContent = services.Localization.localize(
        'card.desc.staff.bonus',
        [services.Localization.localizeNumber(i.amount)]
      )),
      (this.__line2.textContent = utils.FUTLocalization.getStaffAttribute(
        e.type,
        i.trainedAttribute
      )),
      this._applyColors('.name', s.name),
      this._applyColors('.infoView .infoRow', s.footer);
  }),
  (components.ItemConsumableBase = function ItemConsumableBaseView() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemConsumableBase, components.ItemFUTBase),
  (components.ItemConsumableBase.ICON = {
    PLAYER_FITNESS: 'playerFitness',
    SQUAD_FITNESS: 'squadFitness',
    GK_TRAINING: 'gkTraining',
    HEALING: 'healing',
    MANAGER_CONTRACT: 'managerContract',
    MANAGER_LEAGUE: 'managerLeague',
    PLAYER_CONTRACT: 'playerContract',
    PLAYER_TRAINING: 'playerTraining',
    POSITIONING: 'positioning'
  }),
  (components.ItemConsumableBase.CLASS = {
    CONTRACTS: 'contracts',
    CONTRACT_STATS: 'contractStats',
    BRONZE_BOOST: 'bronzeBoost',
    SILVER_BOOST: 'silverBoost',
    GOLD_BOOST: 'goldBoost'
  }),
  (components.ItemConsumableBase.prototype.getImageUrl = function getImageUrl(
    e,
    t,
    i
  ) {
    return utils.AssetLocator.getImage(e, t, i);
  }),
  (components.ItemConsumableBase.prototype._render = function _render(e, t) {
    this._renderConsumableStack(e);
    var i = e.getStaticData(),
      s = this.getImageUrl(i.assetType, e.getYear(), i.assetId);
    this._mainImage.setResource(s), this._setConsumableIcon(e);
  }),
  (components.ItemConsumableBase.prototype.canRender = function canRender(e) {
    return e.isConsumable() && !e.isStyleModifier();
  }),
  (components.ItemConsumableBase.prototype._resetRender = function _resetRender() {
    var e = [
      components.ItemConsumableBase.ICON.PLAYER_FITNESS,
      components.ItemConsumableBase.ICON.SQUAD_FITNESS,
      components.ItemConsumableBase.ICON.GK_TRAINING,
      components.ItemConsumableBase.ICON.HEALING,
      components.ItemConsumableBase.ICON.MANAGER_CONTRACT,
      components.ItemConsumableBase.ICON.MANAGER_LEAGUE,
      components.ItemConsumableBase.ICON.PLAYER_CONTRACT,
      components.ItemConsumableBase.ICON.PLAYER_TRAINING,
      components.ItemConsumableBase.ICON.POSITIONING
    ].join(' ');
    DOMKit.removeClass(this.__itemIcon, e),
      this.getRootElement().removeAttribute('style');
  }),
  (components.ItemConsumableBase.prototype._renderConsumableStack = function _renderConsumableStack(
    e
  ) {
    var t = 1 < e.stackCount;
    (this.__stackCount.textContent = t ? e.stackCount.toString() : ''),
      DOMKit.toggleDisplayStyle(this.__stackCount, t);
  }),
  (components.ItemConsumableBase.prototype._setConsumableIcon = function _setConsumableIcon(
    e
  ) {
    var t = '';
    switch (e.type) {
      case enums.ItemType.CONTRACT:
        t = e.isPlayerContract()
          ? components.ItemConsumableBase.ICON.PLAYER_CONTRACT
          : components.ItemConsumableBase.ICON.MANAGER_CONTRACT;
        break;
      case enums.ItemType.TRAINING:
        e.isGKTraining()
          ? (t = components.ItemConsumableBase.ICON.GK_TRAINING)
          : e.isPlayerTraining()
          ? (t = components.ItemConsumableBase.ICON.PLAYER_TRAINING)
          : e.isPlayerPositionModifier()
          ? (t = components.ItemConsumableBase.ICON.POSITIONING)
          : e.isManagerLeagueModifier() &&
            (t = components.ItemConsumableBase.ICON.MANAGER_LEAGUE);
        break;
      case enums.ItemType.HEALTH:
        t = e.isPlayerFitness()
          ? components.ItemConsumableBase.ICON.PLAYER_FITNESS
          : e.isTeamFitness()
          ? components.ItemConsumableBase.ICON.SQUAD_FITNESS
          : components.ItemConsumableBase.ICON.HEALING;
        break;
      default:
        utils.Debug.Assert(
          !1,
          '[components.ItemConsumableBase] Hit default case for method _setConsumableIcon().'
        );
    }
    DOMKit.addClass(this.__itemIcon, t);
  }),
  (components.ItemConsumableLarge = function ItemConsumableLargeView() {
    components.ItemConsumableBase.call(this), this._generate();
  }),
  utils.JS.inherits(
    components.ItemConsumableLarge,
    components.ItemConsumableBase
  ),
  (components.ItemConsumableLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('consumable'),
        e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this.__stackCount = document.createElement('div')),
        this.__stackCount.classList.add('infoTab'),
        e.appendChild(this.__stackCount),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement());
      var i = document.createElement('div');
      i.classList.add('ut-item-consumable-details'),
        (this.__itemName = document.createElement('div')),
        this.__itemName.classList.add('name'),
        i.appendChild(this.__itemName);
      var s = document.createElement('div');
      s.classList.add('infoView'),
        (this.__line1 = document.createElement('div')),
        this.__line1.classList.add('infoRow'),
        s.appendChild(this.__line1),
        (this.__line2 = document.createElement('div')),
        this.__line2.classList.add('infoRow'),
        s.appendChild(this.__line2),
        i.appendChild(s),
        (this.__itemIcon = document.createElement('div')),
        this.__itemIcon.classList.add('iconConsumable'),
        i.appendChild(this.__itemIcon),
        e.appendChild(i),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemConsumableLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__stackCount = null),
      this._mainImage.destroy(),
      (this.__itemName = null),
      (this.__line1 = null),
      (this.__line2 = null),
      (this.__itemIcon = null);
  }),
  (components.ItemConsumableLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemConsumableLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemConsumableLarge.prototype._render = function _render(e, t) {
    var i = e.getStaticData();
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.LARGE);
    var s = t.getExpColorMap(e.getTier());
    this.__itemName.textContent = i.name;
    var n = '',
      o = '',
      a = '';
    if (e.isContract()) {
      var r = document.createElement('span'),
        l = document.createElement('span'),
        c = document.createElement('span');
      (r.textContent = '+' + i.bronzeBoost),
        (l.textContent = '+' + i.silverBoost),
        (c.textContent = '+' + i.goldBoost),
        DOMKit.addClass(r, components.ItemConsumableBase.CLASS.BRONZE_BOOST),
        DOMKit.addClass(l, components.ItemConsumableBase.CLASS.SILVER_BOOST),
        DOMKit.addClass(c, components.ItemConsumableBase.CLASS.GOLD_BOOST),
        DOMKit.empty(this.__line1),
        DOMKit.addClass(
          this.__line1,
          components.ItemConsumableBase.CLASS.CONTRACT_STATS
        ),
        this.__line1.appendChild(r),
        this.__line1.appendChild(l),
        this.__line1.appendChild(c),
        e.isPlayerContract()
          ? (this.__itemName.textContent = services.Localization.localize(
              'card.title.playercontracts'
            ))
          : (this.__itemName.textContent = services.Localization.localize(
              'card.title.managercontracts'
            )),
        (this.__line2.textContent = services.Localization.localize(
          'card.desc.contract.matches'
        ));
    } else if (e.isTraining()) {
      var u = utils.FUTLocalization.convertAttributeIdToHALString(
        i.trainedAttribute,
        e.isGKTraining()
      );
      e.isGKTraining()
        ? ((n = services.Localization.localize(
            'trainingtype.goalkeeperTraining'
          )),
          (o = '+' + services.Localization.localizeNumber(i.amount)),
          (a = services.Localization.localize(
            'card.desc.training.gkattrib.' + u
          )))
        : e.isPlayerTraining()
        ? ((n = services.Localization.localize('trainingtype.playerTraining')),
          (o = '+' + services.Localization.localizeNumber(i.amount)),
          (a = services.Localization.localize(
            'card.desc.training.attrib.' + u
          )))
        : e.isPlayerPositionModifier()
        ? ((n = services.Localization.localize('card.title.positionmodifier')),
          (o = services.Localization.localize(
            'card.desc.training.pos.' + i.trainPosFrom + '_' + i.trainPosTo
          )))
        : e.isManagerLeagueModifier() &&
          ((n = services.Localization.localize('card.title.leaguechange')),
          (o = utils.FUTLocalization.getLeagueNameByID(e.leagueId))),
        (this.__itemName.textContent = n),
        (this.__line1.textContent = o),
        (this.__line2.textContent = a);
    } else if (e.isHealth()) {
      if (
        ((n = services.Localization.localize('card.title.healing')),
        (o = '+' + services.Localization.localizeNumber(i.amount)),
        e.isPlayerFitness())
      )
        (n = services.Localization.localize('card.title.playerfitness')),
          (a = services.Localization.localize('card.title.fitness'));
      else if (e.isTeamFitness())
        (n = services.Localization.localize('card.title.squadfitness')),
          (a = services.Localization.localize('card.title.fitness'));
      else
        switch (e.subtype) {
          case enums.ItemSubType.HEALING_HEAD:
            a = services.Localization.localize('card.desc.healing.head');
            break;
          case enums.ItemSubType.HEALING_SHOULDER:
            a = services.Localization.localize('card.desc.healing.shoulder');
            break;
          case enums.ItemSubType.HEALING_ARM:
            a = services.Localization.localize('card.desc.healing.arm');
            break;
          case enums.ItemSubType.HEALING_BACK:
            a = services.Localization.localize('card.desc.healing.back');
            break;
          case enums.ItemSubType.HEALING_HIP:
            a = services.Localization.localize('card.desc.healing.hip');
            break;
          case enums.ItemSubType.HEALING_LEG:
            a = services.Localization.localize('card.desc.healing.leg');
            break;
          case enums.ItemSubType.HEALING_FOOT:
            a = services.Localization.localize('card.desc.healing.foot');
            break;
          case enums.ItemSubType.HEALING_ALL:
            a = services.Localization.localize(
              'card.desc.healing.all.injuries'
            );
        }
      (this.__itemName.textContent = n),
        (this.__line1.textContent = o),
        (this.__line2.textContent = a);
    }
    utils.JS.isValid(s) &&
      (this._applyColors('.name', s.name),
      this._applyColors('.infoView .infoRow', s.footer));
  }),
  (components.ItemConsumableLarge.prototype._resetRender = function _resetRender() {
    this.superclass(),
      DOMKit.removeClass(
        this.__line1,
        components.ItemConsumableBase.CLASS.CONTRACT_STATS
      );
  }),
  (components.ItemChemistryStyleBase = function ItemChemistryStyleBaseView() {
    components.ItemConsumableBase.call(this);
  }),
  utils.JS.inherits(
    components.ItemChemistryStyleBase,
    components.ItemConsumableBase
  ),
  (components.ItemChemistryStyleBase.prototype._render = function _render(
    e,
    t
  ) {
    this._renderConsumableStack(e);
  }),
  (components.ItemChemistryStyleBase.prototype.canRender = function canRender(
    e
  ) {
    return e.isStyleModifier();
  }),
  (components.ItemChemistryStyleBase.prototype._resetRender = function _resetRender() {
    this.getRootElement().removeAttribute('style');
  }),
  (components.ItemChemistryStyleLarge = function UTItemChemistryStyleLargeView() {
    components.ItemChemistryStyleBase.call(this), this._generate();
  }),
  utils.JS.inherits(
    components.ItemChemistryStyleLarge,
    components.ItemChemistryStyleBase
  ),
  (components.ItemChemistryStyleLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('chemistryStyle'),
        e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this.__stackCount = document.createElement('div')),
        this.__stackCount.classList.add('infoTab'),
        e.appendChild(this.__stackCount),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__itemName = document.createElement('div')),
        this.__itemName.classList.add('name'),
        e.appendChild(this.__itemName);
      var i = document.createElement('div');
      i.classList.add('styleView');
      var s = document.createElement('div');
      s.classList.add('statCellRow');
      var n = document.createElement('div');
      n.classList.add('statCell'),
        (this._chevronSet1 = new UTItemStatChevronsView()),
        n.appendChild(this._chevronSet1.getRootElement()),
        (this.__statLabel1 = document.createElement('span')),
        this.__statLabel1.classList.add('statLabel'),
        n.appendChild(this.__statLabel1),
        s.appendChild(n);
      var o = document.createElement('div');
      o.classList.add('statCell'),
        (this._chevronSet4 = new UTItemStatChevronsView()),
        o.appendChild(this._chevronSet4.getRootElement()),
        (this.__statLabel4 = document.createElement('span')),
        this.__statLabel4.classList.add('statLabel'),
        o.appendChild(this.__statLabel4),
        s.appendChild(o),
        i.appendChild(s);
      var a = document.createElement('div');
      a.classList.add('statCellRow');
      var r = document.createElement('div');
      r.classList.add('statCell'),
        (this._chevronSet2 = new UTItemStatChevronsView()),
        r.appendChild(this._chevronSet2.getRootElement()),
        (this.__statLabel2 = document.createElement('span')),
        this.__statLabel2.classList.add('statLabel'),
        r.appendChild(this.__statLabel2),
        a.appendChild(r);
      var l = document.createElement('div');
      l.classList.add('statCell'),
        (this._chevronSet5 = new UTItemStatChevronsView()),
        l.appendChild(this._chevronSet5.getRootElement()),
        (this.__statLabel5 = document.createElement('span')),
        this.__statLabel5.classList.add('statLabel'),
        l.appendChild(this.__statLabel5),
        a.appendChild(l),
        i.appendChild(a);
      var c = document.createElement('div');
      c.classList.add('statCellRow');
      var u = document.createElement('div');
      u.classList.add('statCell'),
        (this._chevronSet3 = new UTItemStatChevronsView()),
        u.appendChild(this._chevronSet3.getRootElement()),
        (this.__statLabel3 = document.createElement('span')),
        this.__statLabel3.classList.add('statLabel'),
        u.appendChild(this.__statLabel3),
        c.appendChild(u);
      var d = document.createElement('div');
      d.classList.add('statCell'),
        (this._chevronSet6 = new UTItemStatChevronsView()),
        d.appendChild(this._chevronSet6.getRootElement()),
        (this.__statLabel6 = document.createElement('span')),
        this.__statLabel6.classList.add('statLabel'),
        d.appendChild(this.__statLabel6),
        c.appendChild(d),
        i.appendChild(c),
        e.appendChild(i),
        (this.__itemIcon = document.createElement('div')),
        this.__itemIcon.classList.add('chemistryStyle'),
        this.__itemIcon.classList.add('iconConsumable'),
        e.appendChild(this.__itemIcon),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemChemistryStyleLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__stackCount = null),
      this._mainImage.destroy(),
      (this.__itemName = null),
      this._chevronSet1.destroy(),
      (this.__statLabel1 = null),
      this._chevronSet4.destroy(),
      (this.__statLabel4 = null),
      this._chevronSet2.destroy(),
      (this.__statLabel2 = null),
      this._chevronSet5.destroy(),
      (this.__statLabel5 = null),
      this._chevronSet3.destroy(),
      (this.__statLabel3 = null),
      this._chevronSet6.destroy(),
      (this.__statLabel6 = null),
      (this.__itemIcon = null);
  }),
  (components.ItemChemistryStyleLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemChemistryStyleLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemChemistryStyleLarge.prototype._render = function _render(
    e,
    t
  ) {
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.LARGE);
    var i = e.getStaticData(),
      s = t.getExpColorMap(e.getTier()),
      n = utils.AssetLocator.getImage(i.assetType, e.getYear(), e.subtype);
    this._mainImage.setResource(n);
    var o = e.subtype,
      a = utils.FUTLocalization.getPlaystyleByID(o);
    this.__itemName.textContent = a;
    var r = e.isGKStyleModifier();
    (this.__statLabel1.textContent = services.Localization.localize(
      r ? 'cards.cardfront.divingAbbr' : 'cards.cardfront.paceAbbr'
    )),
      (this.__statLabel2.textContent = services.Localization.localize(
        r ? 'cards.cardfront.handlingAbbr' : 'cards.cardfront.shootingAbbr'
      )),
      (this.__statLabel3.textContent = services.Localization.localize(
        r ? 'cards.cardfront.kickAbbr' : 'cards.cardfront.passingAbbr'
      )),
      (this.__statLabel4.textContent = services.Localization.localize(
        r ? 'cards.cardfront.reflexAbbr' : 'cards.cardfront.dribblingAbbr'
      )),
      (this.__statLabel5.textContent = services.Localization.localize(
        r ? 'cards.cardfront.speedAbbr' : 'cards.cardfront.defendingAbbr'
      )),
      (this.__statLabel6.textContent = services.Localization.localize(
        r ? 'cards.cardfront.positionAbbr' : 'cards.cardfront.headingAbbr'
      ));
    var l = repositories.PlayStyle.getPlayStyleBonusById(o, r);
    this._applyChevrons(l),
      utils.JS.isValid(s) &&
        (this._applyColors('.itemTypeName', s.header),
        this._applyColors('.name', s.name),
        this._applyColors('.styleView .statLabel', s.footer));
  }),
  (components.ItemChemistryStyleLarge.prototype._applyChevrons = function _applyChevrons(
    e
  ) {
    e.slice(0, 6).forEach(function applyChevrons(e, t) {
      var i = this['_chevronSet' + (t + 1)];
      i && (i.setChevronCount(e), i.setChemistryBoost(e));
      var s = this['__statLabel' + (t + 1)];
      s && DOMKit.toggleClass(s, 'chemBoost', 0 < e);
    }, this);
  }),
  (components.ItemBadgeBase = function() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemBadgeBase, components.ItemFUTBase),
  (components.ItemBadgeBase.onImageLoad = function(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.TEAM + '.png')
        );
  }),
  (components.ItemBadgeBase.prototype._render = function(e, t) {
    var i = e.getYear(),
      s = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_BADGE_LIGHT,
        i,
        e.teamId
      );
    utils.AssetLocator.hasPlaceholder(
      enums.PlaceholderAssetKey.CREST,
      e.teamId,
      i,
      enums.PlaceholderAssetKey.CREST_LIGHT
    ) &&
      (s = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_BADGE_LIGHT,
        i,
        enums.PlaceholderAssetId.TEAM
      )),
      this._mainImage
        .setResource(s, !0)
        .observe(this._mainImage, components.ItemBadgeBase.onImageLoad);
  }),
  (components.ItemBadgeBase.prototype.canRender = function(e) {
    return e.isBadge();
  }),
  (components.ItemBadgeLarge = function ItemBadgeLargeView() {
    components.ItemBadgeBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemBadgeLarge, components.ItemBadgeBase),
  (components.ItemBadgeLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('badge'),
        e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._flagImage = new UTImageView()),
        this._flagImage.getRootElement().classList.add('flag'),
        e.appendChild(this._flagImage.getRootElement()),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__clubName = document.createElement('div')),
        this.__clubName.classList.add('name'),
        e.appendChild(this.__clubName);
      var i = document.createElement('div');
      i.classList.add('clubView'),
        (this.__itemName = document.createElement('div')),
        this.__itemName.classList.add('clubLine'),
        i.appendChild(this.__itemName),
        e.appendChild(i);
      var s = document.createElement('div');
      s.classList.add('badge'),
        s.classList.add('iconClub'),
        e.appendChild(s),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemBadgeLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._flagImage.destroy(),
      this._mainImage.destroy(),
      (this.__clubName = null),
      (this.__itemName = null);
  }),
  (components.ItemBadgeLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemBadgeLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemBadgeLarge.prototype._render = function _render(e, t) {
    var i = t.getExpColorMap(e.getTier());
    this.superclass(e, t),
      this._setShell(e, enums.ItemViewType.LARGE),
      (this.__itemName.textContent = services.Localization.localize(
        'card.desc.badge'
      )),
      (this.__clubName.textContent = utils.FUTLocalization.getTeamAbb15ByID(
        e.teamId,
        e.getYear()
      )),
      this._applyColors('.name', i.name),
      this._applyColors('.clubView .clubLine', i.footer);
  }),
  (components.ItemKitBase = function ItemKitBaseView() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemKitBase, components.ItemFUTBase),
  (components.ItemKitBase.onImageLoad = function onImageLoad(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(
            /j(\d+)_\d+_\d+\.png/,
            'j$1_' +
              enums.PlaceholderAssetId.TEAM +
              '_' +
              enums.PlaceholderAssetId.KIT +
              '.png'
          )
        );
  }),
  (components.ItemKitBase.prototype._render = function _render(e, t) {
    var i = e.getStaticData(),
      s = e.getYear(),
      n = i.assetType,
      o = utils.AssetLocator.getImage(n, s, e.teamId, i.assetYear);
    utils.AssetLocator.hasPlaceholderKit(o, s) &&
      (o = utils.AssetLocator.getImage(
        n,
        s,
        enums.PlaceholderAssetId.TEAM,
        enums.PlaceholderAssetId.KIT
      )),
      this._mainImage
        .setResource(o, !0)
        .observe(this._mainImage, components.ItemKitBase.onImageLoad);
    var a = utils.AssetLocator.getImage(
      utils.AssetLocator.IMAGE_TYPE_FLAG,
      s,
      e.nationId
    );
    this._flagImage
      .setResource(a, !0)
      .observe(this._flagImage, components.ItemFUTBase.onFlagImageLoad);
    var r = utils.AssetLocator.getImage(
      utils.AssetLocator.IMAGE_TYPE_BADGE_LIGHT,
      s,
      e.teamId
    );
    utils.AssetLocator.hasPlaceholder(
      enums.PlaceholderAssetKey.CREST,
      e.teamId.toString(),
      s,
      enums.PlaceholderAssetKey.CREST_LIGHT
    ) &&
      (r = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_BADGE_LIGHT,
        s,
        enums.PlaceholderAssetId.TEAM
      )),
      this._badgeImage
        .setResource(r, !0)
        .observe(this._badgeImage, components.ItemBadgeBase.onImageLoad);
  }),
  (components.ItemKitBase.prototype.canRender = function canRender(e) {
    return e.isKit();
  }),
  (components.ItemKitLarge = function ItemKitLargeView() {
    components.ItemKitBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemKitLarge, components.ItemKitBase),
  (components.ItemKitLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'), e.classList.add('kit'), e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('statusOverlay'), e.appendChild(t);
      var i = document.createElement('div');
      i.classList.add('kitOverview'),
        (this._flagImage = new UTImageView()),
        this._flagImage.getRootElement().classList.add('flag'),
        i.appendChild(this._flagImage.getRootElement()),
        (this._badgeImage = new UTImageView()),
        this._badgeImage.getRootElement().classList.add('badge'),
        i.appendChild(this._badgeImage.getRootElement()),
        e.appendChild(i),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__clubName = document.createElement('div')),
        this.__clubName.classList.add('name'),
        e.appendChild(this.__clubName);
      var s = document.createElement('div');
      s.classList.add('clubView'),
        (this.__kitText = document.createElement('div')),
        this.__kitText.classList.add('clubRow'),
        s.appendChild(this.__kitText),
        e.appendChild(s);
      var n = document.createElement('div');
      n.classList.add('kit'),
        n.classList.add('iconClub'),
        e.appendChild(n),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemKitLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._flagImage.destroy(),
      this._badgeImage.destroy(),
      this._mainImage.destroy(),
      (this.__clubName = null),
      (this.__kitText = null);
  }),
  (components.ItemKitLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemKitLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemKitLarge.prototype._render = function _render(e, t) {
    var i = e.getStaticData();
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.LARGE);
    var s = t.getExpColorMap(e.getTier());
    (this.__clubName.textContent = utils.FUTLocalization.getTeamAbb15ByID(
      e.teamId,
      e.getYear()
    )),
      (this.__kitText.textContent = i.description),
      this._applyColors('.name', s.name),
      this._applyColors('.clubView .clubRow', s.footer);
  }),
  (components.ItemBallBase = function() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemBallBase, components.ItemFUTBase),
  (components.ItemBallBase.onImageLoad = function(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.BALL + '.png')
        );
  }),
  (components.ItemBallBase.prototype._render = function(e, t) {
    var i = e.getStaticData(),
      s = e.getYear(),
      n = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_BALL,
        s,
        i.assetId
      );
    utils.AssetLocator.hasPlaceholder(
      enums.PlaceholderAssetKey.BALLS,
      i.assetId,
      s
    ) &&
      (n = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_BALL,
        s,
        enums.PlaceholderAssetId.BALL
      )),
      this._mainImage
        .setResource(n, !0)
        .observe(this._mainImage, components.ItemBallBase.onImageLoad);
  }),
  (components.ItemBallBase.prototype.canRender = function(e) {
    return e.isBall();
  }),
  (components.ItemBallLarge = function ItemBallLargeView() {
    components.ItemBallBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemBallLarge, components.ItemBallBase),
  (components.ItemBallLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('ball'),
        e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__ballName = document.createElement('div')),
        this.__ballName.classList.add('name'),
        e.appendChild(this.__ballName);
      var i = document.createElement('div');
      i.classList.add('ball'),
        i.classList.add('iconClub'),
        e.appendChild(i),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemBallLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy(),
      (this.__ballName = null);
  }),
  (components.ItemBallLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemBallLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemBallLarge.prototype._render = function _render(e, t) {
    var i = e.getStaticData();
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.LARGE);
    var s = t.getExpColorMap(e.getTier());
    (this.__ballName.textContent = services.Localization.localize(
      i.description
    )),
      this._applyColors('.name', s.name),
      this._applyColors('.clubView clubRow', s.footer);
  }),
  (components.ItemStadiumBase = function ItemStadiumBaseView() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemStadiumBase, components.ItemFUTBase),
  (components.ItemStadiumBase.onImageLoad = function onImageLoad(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.STADIUM + '.png')
        );
  }),
  (components.ItemStadiumBase.prototype.getImageUrl = function getImageUrl(
    e,
    t,
    i
  ) {
    return utils.AssetLocator.getImage(e, t, i);
  }),
  (components.ItemStadiumBase.prototype._render = function _render(e, t) {
    var i = this.getImageUrl(
      utils.AssetLocator.IMAGE_TYPE_STADIUM_FULL,
      e.getYear(),
      e.getStaticData().assetId
    );
    this._mainImage
      .setResource(i, !0)
      .observe(this._mainImage, components.ItemStadiumBase.onImageLoad);
  }),
  (components.ItemStadiumBase.prototype._renderRestrictions = function _renderRestrictions(
    e
  ) {
    e.bannerRestricted && (this.__restrictedBanner.style.display = 'none'),
      e.tifoRestricted && (this.__restrictedTifo.style.display = 'none');
  }),
  (components.ItemStadiumBase.prototype.canRender = function canRender(e) {
    return e.isStadium();
  }),
  (components.ItemStadiumLarge = function ItemStadiumLargeView() {
    components.ItemStadiumBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemStadiumLarge, components.ItemStadiumBase),
  (components.ItemStadiumLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('stadium'),
        e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__stadiumName = document.createElement('div')),
        this.__stadiumName.classList.add('name'),
        e.appendChild(this.__stadiumName);
      var i = document.createElement('div');
      i.classList.add('stadium'),
        i.classList.add('iconClub'),
        e.appendChild(i),
        (this.__restrictedIcons = document.createElement('div')),
        this.__restrictedIcons.classList.add('restricted'),
        (this.__restrictedBanner = document.createElement('div')),
        this.__restrictedBanner.classList.add('banner'),
        this.__restrictedBanner.classList.add('iconClub'),
        this.__restrictedIcons.appendChild(this.__restrictedBanner),
        (this.__restrictedTifo = document.createElement('div')),
        this.__restrictedTifo.classList.add('tifo'),
        this.__restrictedTifo.classList.add('iconClub'),
        this.__restrictedIcons.appendChild(this.__restrictedTifo),
        e.appendChild(this.__restrictedIcons),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemStadiumLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy(),
      (this.__stadiumName = null),
      (this.__restrictedIcons = null),
      (this.__restrictedBanner = null),
      (this.__restrictedTifo = null);
  }),
  (components.ItemStadiumLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemStadiumLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemStadiumLarge.prototype._render = function _render(e, t) {
    var i = e.getStaticData();
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.LARGE);
    var s = t.getExpColorMap(e.getTier());
    this._renderRestrictions(e),
      (this.__stadiumName.textContent = i.description),
      this._applyColors('.name', s.name),
      this._applyColors('.clubView .clubLine', s.footer);
  }),
  (components.ItemMiscBase = function ItemMiscBaseView() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemMiscBase, components.ItemFUTBase),
  (components.ItemMiscBase.CLASS = {
    PLAYER_PICK: 'player-pick'
  }),
  (components.ItemMiscBase.ICON = {
    COINS: 'freeCoins',
    DRAFT_TOKEN: 'draftToken',
    FREE_PACK: 'freePack'
  }),
  (components.ItemMiscBase.prototype.getImageUrl = function getImageUrl(
    e,
    t,
    i
  ) {
    return utils.AssetLocator.getImage(e, t, i);
  }),
  (components.ItemMiscBase.prototype._render = function _render(e, t) {
    var i = e.getStaticData(),
      s = '';
    e.isPlayerPickItem()
      ? DOMKit.addClass(
          this.getRootElement(),
          components.ItemMiscBase.CLASS.PLAYER_PICK
        )
      : (e.isFreeCoins()
          ? (s = components.ItemMiscBase.ICON.COINS)
          : e.isDraftToken()
          ? (s = components.ItemMiscBase.ICON.DRAFT_TOKEN)
          : e.isFreePack() && (s = components.ItemMiscBase.ICON.FREE_PACK),
        DOMKit.addClass(this.__itemIcon, s),
        this._mainImage.setResource(
          this.getImageUrl(i.assetType, e.getYear(), i.assetId)
        ));
  }),
  (components.ItemMiscBase.prototype.canRender = function canRender(e) {
    return e.isMiscItem();
  }),
  (components.ItemMiscBase.prototype._resetRender = function _resetRender() {
    var e = [
      components.ItemMiscBase.ICON.COINS,
      components.ItemMiscBase.ICON.DRAFT_TOKEN,
      components.ItemMiscBase.ICON.FREE_PACK
    ].join(' ');
    DOMKit.removeClass(this.__itemIcon, e),
      DOMKit.removeClass(
        this.getRootElement(),
        components.ItemMiscBase.CLASS.PLAYER_PICK
      ),
      this.getRootElement().removeAttribute('style'),
      this._mainImage.clearResource();
  }),
  (components.ItemMiscLarge = function ItemMiscLargeView() {
    components.ItemMiscBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemMiscLarge, components.ItemMiscBase),
  (components.ItemMiscLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('misc'),
        e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement());
      var i = document.createElement('div');
      i.classList.add('ut-item-misc-details'),
        (this.__itemName = document.createElement('div')),
        this.__itemName.classList.add('name'),
        i.appendChild(this.__itemName);
      var s = document.createElement('div');
      s.classList.add('infoView'),
        (this.__itemDesc = document.createElement('div')),
        this.__itemDesc.classList.add('line'),
        s.appendChild(this.__itemDesc),
        i.appendChild(s),
        (this.__itemIcon = document.createElement('div')),
        this.__itemIcon.classList.add('iconConsumable'),
        i.appendChild(this.__itemIcon),
        e.appendChild(i),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemMiscLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy(),
      (this.__itemName = null),
      (this.__itemDesc = null),
      (this.__itemIcon = null);
  }),
  (components.ItemMiscLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemMiscLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemMiscLarge.prototype._render = function _render(e) {
    var t = e.getStaticData(),
      i = '',
      s = '';
    if (
      (this.superclass(e),
      (s = e.isPlayerPickItem()
        ? services.Localization.localize('card.title.playerpicks')
        : (this._setShell(e, enums.ItemViewType.LARGE), t.name)),
      e.isFreeCoins())
    )
      i = services.Localization.localize('card.desc.misc.coins', [t.amount]);
    else if (e.isDraftToken())
      i = services.Localization.localize('card.desc.misc.drafttoken');
    else if (e.isFreePack())
      if (t.hasLoanPackDescription())
        i = services.Localization.localize('card.desc.FreeLoanPackDesc');
      else
        switch (t.assetId) {
          case utils.AssetLocator.ASSET_ID_BRONZE_PACK:
            i = services.Localization.localize('card.desc.freebronze');
            break;
          case utils.AssetLocator.ASSET_ID_SILVER_PACK:
            i = services.Localization.localize('card.desc.freesilver');
            break;
          case utils.AssetLocator.ASSET_ID_GOLD_PACK:
            i = services.Localization.localize('card.desc.freegold');
        }
    (this.__itemName.textContent = s), (this.__itemDesc.textContent = i);
  }),
  (components.ItemTifoBase = function() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemTifoBase, components.ItemFUTBase),
  (components.ItemTifoBase.onImageLoad = function(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.TIFO + '.png')
        );
  }),
  (components.ItemTifoBase.prototype._render = function(e, t) {}),
  (components.ItemTifoBase.prototype.canRender = function(e) {
    return e.isTifo();
  }),
  (components.ItemTifoLarge = function ItemTifoLargeView() {
    components.ItemTifoBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemTifoLarge, components.ItemTifoBase),
  (components.ItemTifoLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('tifo'),
        e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__tifoName = document.createElement('div')),
        this.__tifoName.classList.add('name'),
        e.appendChild(this.__tifoName);
      var i = document.createElement('div');
      i.classList.add('clubView'),
        (this.__tifoText = document.createElement('div')),
        this.__tifoText.classList.add('clubRow'),
        i.appendChild(this.__tifoText),
        e.appendChild(i);
      var s = document.createElement('div');
      s.classList.add('tifo'),
        s.classList.add('iconClub'),
        e.appendChild(s),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemTifoLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy(),
      (this.__tifoName = null),
      (this.__tifoText = null);
  }),
  (components.ItemTifoLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemTifoLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemTifoLarge.prototype._render = function _render(e, t) {
    var i = e.getStaticData(),
      s = e.getYear();
    this.superclass(e, t);
    var n = utils.AssetLocator.getImage(
      utils.AssetLocator.IMAGE_TYPE_TIFO,
      s,
      i.assetId
    );
    utils.AssetLocator.hasPlaceholder(
      enums.PlaceholderAssetKey.TIFOS,
      i.assetId,
      s
    ) &&
      (n = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_TIFO,
        s,
        enums.PlaceholderAssetId.TIFO
      )),
      this._mainImage
        .setResource(n, !0)
        .observe(this._mainImage, components.ItemTifoBase.onImageLoad),
      this._setShell(e, enums.ItemViewType.LARGE);
    var o = t.getExpColorMap(e.getTier());
    (this.__tifoName.textContent = services.Localization.localize(i.name)),
      (this.__tifoText.textContent = services.Localization.localize(
        'card.desc.tifo'
      )),
      this._applyColors('.name', o.name),
      this._applyColors('.clubView .clubRow', o.footer);
  }),
  (components.ItemBannerBase = function() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemBannerBase, components.ItemFUTBase),
  (components.ItemBannerBase.onImageLoad = function(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.BANNER + '.png')
        );
  }),
  (components.ItemBannerBase.prototype._render = function(e, t) {}),
  (components.ItemBannerBase.prototype.canRender = function(e) {
    return e.isBanner();
  }),
  (components.ItemBannerLarge = function ItemBannerLargeView() {
    components.ItemBannerBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemBannerLarge, components.ItemBannerBase),
  (components.ItemBannerLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('banner'),
        e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__bannerName = document.createElement('div')),
        this.__bannerName.classList.add('name'),
        e.appendChild(this.__bannerName);
      var i = document.createElement('div');
      i.classList.add('clubView'),
        (this.__bannerText = document.createElement('div')),
        this.__bannerText.classList.add('clubRow'),
        i.appendChild(this.__bannerText),
        e.appendChild(i);
      var s = document.createElement('div');
      s.classList.add('banner'),
        s.classList.add('iconClub'),
        e.appendChild(s),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemBannerLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy(),
      (this.__bannerName = null),
      (this.__bannerText = null);
  }),
  (components.ItemBannerLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemBannerLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemBannerLarge.prototype._render = function _render(e, t) {
    var i = e.getYear(),
      s = e.resourceId;
    this.superclass(e, t);
    var n = utils.AssetLocator.getImage(
      utils.AssetLocator.IMAGE_TYPE_BANNER,
      i,
      s
    );
    utils.AssetLocator.hasPlaceholder(
      enums.PlaceholderAssetKey.BANNERS,
      s,
      i
    ) &&
      (n = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_BANNER,
        i,
        enums.PlaceholderAssetId.BANNER
      )),
      this._mainImage
        .setResource(n, !0)
        .observe(this._mainImage, components.ItemBannerBase.onImageLoad),
      this._setShell(e, enums.ItemViewType.LARGE);
    var o = t.getExpColorMap(e.getTier());
    (this.__bannerName.textContent = services.Localization.localize(
      e.getStaticData().name
    )),
      (this.__bannerText.textContent = services.Localization.localize(
        'card.desc.banner'
      )),
      this._applyColors('.name', o.name),
      this._applyColors('.clubView .clubRow', o.footer);
  }),
  (components.ItemCelebrationBase = function() {
    components.ItemFUTBase.call(this);
  }),
  utils.JS.inherits(components.ItemCelebrationBase, components.ItemFUTBase),
  (components.ItemCelebrationBase.onImageLoad = function(e, t, i, s) {
    e.unobserve(this),
      t ||
        i.replaceAndShowResource(
          s.replace(/\d+\.png/, enums.PlaceholderAssetId.CELEBRATION + '.png')
        );
  }),
  (components.ItemCelebrationBase.prototype._render = function(e, t) {}),
  (components.ItemCelebrationBase.prototype.canRender = function(e) {
    return e.isCelebration();
  }),
  (components.ItemCelebrationLarge = function ItemCelebrationLargeView() {
    components.ItemCelebrationBase.call(this), this._generate();
  }),
  utils.JS.inherits(
    components.ItemCelebrationLarge,
    components.ItemCelebrationBase
  ),
  (components.ItemCelebrationLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('large'),
        e.classList.add('celebration'),
        e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__celebrationName = document.createElement('div')),
        this.__celebrationName.classList.add('name'),
        e.appendChild(this.__celebrationName);
      var i = document.createElement('div');
      i.classList.add('clubView'),
        (this.__celebrationText = document.createElement('div')),
        this.__celebrationText.classList.add('clubRow'),
        i.appendChild(this.__celebrationText),
        e.appendChild(i);
      var s = document.createElement('div');
      s.classList.add('celebration'),
        s.classList.add('iconClub'),
        e.appendChild(s),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemCelebrationLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy(),
      (this.__celebrationName = null),
      (this.__celebrationText = null);
  }),
  (components.ItemCelebrationLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemCelebrationLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemCelebrationLarge.prototype._render = function _render(e, t) {
    var i = e.getStaticData(),
      s = e.getYear(),
      n = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_CELEBRATION,
        s,
        i.assetId
      );
    utils.AssetLocator.hasPlaceholder(
      enums.PlaceholderAssetKey.CELEBRATIONS,
      i.assetId,
      s
    ) &&
      (n = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_CELEBRATION,
        s,
        enums.PlaceholderAssetId.CELEBRATION
      )),
      this._mainImage
        .setResource(n, !0)
        .observe(this._mainImage, components.ItemCelebrationBase.onImageLoad),
      this.superclass(e, t),
      this._setShell(e, enums.ItemViewType.LARGE);
    var o = t.getExpColorMap(e.getTier());
    (this.__celebrationName.textContent = services.Localization.localize(
      'FUT_CelebrationName_' + e.resourceId
    )),
      (this.__celebrationText.textContent = services.Localization.localize(
        'card.desc.celebration'
      )),
      this._applyColors('.name', o.name),
      this._applyColors('.clubView .clubRow', o.footer);
  }),
  (components.ItemManagerSmall = function ItemManagerSmallView() {
    components.ItemManagerBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemManagerSmall, components.ItemManagerBase),
  (components.ItemManagerSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('manager'),
        e.classList.add('staff'),
        e.classList.add('item'),
        (this._canvas = new UTItemManagerCanvasView()),
        (this._canvas.width = '90'),
        (this._canvas.height = '114'),
        e.appendChild(this._canvas.getRootElement());
      var t = document.createElement('span');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this.__infoTab = document.createElement('span')),
        this.__infoTab.classList.add('infoTab'),
        e.appendChild(this.__infoTab),
        (this.__position = document.createElement('div')),
        this.__position.classList.add('position'),
        e.appendChild(this.__position),
        (this.__iconDiv = document.createElement('div')),
        this.__iconDiv.classList.add('manager'),
        this.__iconDiv.classList.add('iconStaff'),
        e.appendChild(this.__iconDiv),
        (this.__bioViewDiv = document.createElement('div')),
        this.__bioViewDiv.classList.add('bioView');
      var i = document.createElement('div');
      i.classList.add('ut-item-row');
      var s = document.createElement('span');
      s.classList.add('ut-item-row-label--left'),
        s.classList.add('ut-item-row-label'),
        (this._bioFlagImage = new UTImageView()),
        s.appendChild(this._bioFlagImage.getRootElement()),
        i.appendChild(s),
        (this.__managerNation = document.createElement('span')),
        this.__managerNation.classList.add('ut-item-row-label--right'),
        this.__managerNation.classList.add('ut-item-row-label'),
        i.appendChild(this.__managerNation),
        this.__bioViewDiv.appendChild(i);
      var n = document.createElement('div');
      n.classList.add('ut-item-row');
      var o = document.createElement('span');
      o.classList.add('ut-item-row-label--left'),
        o.classList.add('ut-item-row-label'),
        (this._bioLeagueImage = new UTImageView()),
        o.appendChild(this._bioLeagueImage.getRootElement()),
        n.appendChild(o),
        (this.__managerLeague = document.createElement('span')),
        this.__managerLeague.classList.add('ut-item-row-label--right'),
        this.__managerLeague.classList.add('ut-item-row-label'),
        n.appendChild(this.__managerLeague),
        this.__bioViewDiv.appendChild(n);
      var a = document.createElement('div');
      a.classList.add('ut-item-row'),
        (this.__managerNegotiationTitle = document.createElement('span')),
        this.__managerNegotiationTitle.classList.add('ut-item-row-label--left'),
        this.__managerNegotiationTitle.classList.add('ut-item-row-label'),
        a.appendChild(this.__managerNegotiationTitle),
        (this.__managerNegotiation = document.createElement('span')),
        this.__managerNegotiation.classList.add('ut-item-row-label--right'),
        this.__managerNegotiation.classList.add('ut-item-row-label'),
        a.appendChild(this.__managerNegotiation),
        this.__bioViewDiv.appendChild(a);
      var r = document.createElement('div');
      r.classList.add('ut-item-row--center'),
        r.classList.add('ut-item-row'),
        (this.__managerContractTitle = document.createElement('span')),
        this.__managerContractTitle.classList.add('ut-item-row-label'),
        r.appendChild(this.__managerContractTitle),
        (this.__managerContract = document.createElement('span')),
        this.__managerContract.classList.add('ut-item-row-label'),
        r.appendChild(this.__managerContract),
        this.__bioViewDiv.appendChild(r),
        e.appendChild(this.__bioViewDiv),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemManagerSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._canvas.destroy(),
      (this.__infoTab = null),
      (this.__position = null),
      (this.__iconDiv = null),
      (this.__bioViewDiv = null),
      this._bioFlagImage.destroy(),
      (this.__managerNation = null),
      this._bioLeagueImage.destroy(),
      (this.__managerLeague = null),
      (this.__managerNegotiationTitle = null),
      (this.__managerNegotiation = null),
      (this.__managerContractTitle = null),
      (this.__managerContract = null);
  }),
  (components.ItemManagerSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemManagerSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemManagerSmall.prototype.init = function init() {
    this.superclass(), this._canvas.init();
  }),
  (components.ItemManagerSmall.prototype.setItemInfoState = function setItemInfoState(
    e
  ) {
    DOMKit.toggleDisplayStyle(
      this.__position,
      e === enums.UIItemInfoState.MAIN || e === enums.UIItemInfoState.STATS
    ),
      DOMKit.toggleDisplayStyle(
        this.__iconDiv,
        e === enums.UIItemInfoState.MAIN || e === enums.UIItemInfoState.STATS
      ),
      DOMKit.toggleDisplayStyle(
        this.__bioViewDiv,
        e !== enums.UIItemInfoState.MAIN && e !== enums.UIItemInfoState.STATS
      ),
      this._canvas.rendered && this._canvas.setState(e);
  }),
  (components.ItemManagerSmall.prototype._render = function _render(e, t) {
    var i = e.getStaticData(),
      s = e.isValid();
    this.superclass(e, t),
      this._canvas &&
        (this._canvas.setSize(enums.ItemViewType.SMALL),
        this._canvas.setColorMap(t.getSmallColorMap(e.getTier()))),
      s && this._setShell(e, enums.ItemViewType.SMALL);
    var n = s ? t.getSmallColorMap(e.getTier()) : null;
    n &&
      (this._applyColors('.position', n.header),
      this._applyColors('.itemDesc', n.footer)),
      (this.__managerNation.textContent = utils.FUTLocalization.getNationAbb3ById(
        e.nationId
      )),
      (this.__managerLeague.textContent = utils.FUTLocalization.getLeagueAbbr5ByID(
        e.leagueId,
        e.getYear()
      )),
      (this.__managerNegotiationTitle.textContent = services.Localization.localize(
        'cards.cardfront.negotiations'
      )),
      (this.__managerNegotiation.textContent = i.amount + '%'),
      (this.__managerContractTitle.textContent = services.Localization.localize(
        'cards.cardfront.contractAbbr'
      )),
      (this.__managerContract.textContent = services.Localization.localizeNumber(
        e.contract
      ));
  }),
  (components.ItemManagerSmall.prototype._getAssetDimensions = function _getAssetDimensions(
    e,
    t
  ) {
    t = t || !1;
    var i = 0,
      s = 0,
      n = 0,
      o = 0;
    return (
      e === enums.ItemAssetType.MAIN
        ? ((s = i = 53), (n = 33), (o = 28))
        : e === enums.ItemAssetType.BADGE
        ? ((s = i = 14), (n = 18), (o = 63))
        : e === enums.ItemAssetType.FLAG
        ? ((i = 14), (s = 9), (n = 18), (o = 49))
        : e === enums.ItemAssetType.SHELL && ((i = 97), (s = 114)),
      new UTItemCanvasDTO(null, t, i, s, n, o)
    );
  }),
  (components.ItemStaffSmall = function ItemStaffSmallView() {
    components.ItemStaffBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemStaffSmall, components.ItemStaffBase),
  (components.ItemStaffSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('staff'),
        e.classList.add('item');
      var t = document.createElement('span');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__desc = document.createElement('div')),
        this.__desc.classList.add('itemDesc'),
        e.appendChild(this.__desc),
        (this.__itemIcon = document.createElement('div')),
        this.__itemIcon.classList.add('iconStaff'),
        e.appendChild(this.__itemIcon),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemStaffSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy(),
      (this.__desc = null),
      (this.__itemIcon = null);
  }),
  (components.ItemStaffSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemStaffSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemStaffSmall.prototype._render = function _render(e, t) {
    var i = e.getStaticData();
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.SMALL);
    var s = t.getSmallColorMap(e.getTier());
    (this.__desc.textContent =
      utils.FUTLocalization.getStaffAttributeAbbr(e.type, i.trainedAttribute) +
      ' ' +
      services.Localization.localize('card.desc.staff.bonus', [
        services.Localization.localizeNumber(i.amount)
      ])),
      this._applyColors('.itemDesc', s.footer);
  }),
  (components.ItemConsumableSmall = function ItemConsumableSmallView() {
    components.ItemConsumableBase.call(this), this._generate();
  }),
  utils.JS.inherits(
    components.ItemConsumableSmall,
    components.ItemConsumableBase
  ),
  (components.ItemConsumableSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('consumable'),
        e.classList.add('item');
      var t = document.createElement('span');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this.__stackCount = document.createElement('div')),
        this.__stackCount.classList.add('infoTab'),
        e.appendChild(this.__stackCount),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__desc = document.createElement('div')),
        this.__desc.classList.add('itemDesc'),
        e.appendChild(this.__desc),
        (this.__itemIcon = document.createElement('div')),
        this.__itemIcon.classList.add('iconConsumable'),
        e.appendChild(this.__itemIcon),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemConsumableSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__stackCount = null),
      this._mainImage.destroy(),
      (this.__desc = null),
      (this.__itemIcon = null);
  }),
  (components.ItemConsumableSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemConsumableSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemConsumableSmall.prototype.getImageUrl = function getImageUrl(
    e,
    t,
    i
  ) {
    return utils.AssetLocator.getSmallImage(e, t, i);
  }),
  (components.ItemConsumableSmall.prototype._render = function _render(e, t) {
    var i = e.getStaticData();
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.SMALL);
    var s = t.getSmallColorMap(e.getTier());
    if (e.isContract()) {
      var n = document.createElement('span'),
        o = document.createElement('span'),
        a = document.createElement('span');
      (n.textContent = '+' + i.bronzeBoost),
        (o.textContent = '+' + i.silverBoost),
        (a.textContent = '+' + i.goldBoost),
        DOMKit.addClass(n, components.ItemConsumableBase.CLASS.BRONZE_BOOST),
        DOMKit.addClass(o, components.ItemConsumableBase.CLASS.SILVER_BOOST),
        DOMKit.addClass(a, components.ItemConsumableBase.CLASS.GOLD_BOOST),
        DOMKit.empty(this.__desc),
        DOMKit.addClass(
          this.__desc,
          components.ItemConsumableBase.CLASS.CONTRACT_STATS
        ),
        this.__desc.appendChild(n),
        this.__desc.appendChild(o),
        this.__desc.appendChild(a),
        this.addClass(components.ItemConsumableBase.CLASS.CONTRACTS);
    }
    utils.JS.isValid(s) && this._applyColors('.itemDesc', s.footer);
  }),
  (components.ItemChemistryStyleSmall = function ItemChemistryStyleSmallView() {
    components.ItemChemistryStyleBase.call(this), this._generate();
  }),
  utils.JS.inherits(
    components.ItemChemistryStyleSmall,
    components.ItemChemistryStyleBase
  ),
  (components.ItemChemistryStyleSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('chemistryStyle'),
        e.classList.add('item');
      var t = document.createElement('span');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this.__stackCount = document.createElement('div')),
        this.__stackCount.classList.add('infoTab'),
        e.appendChild(this.__stackCount),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__desc = document.createElement('div')),
        this.__desc.classList.add('itemDesc'),
        e.appendChild(this.__desc),
        (this.__itemIcon = document.createElement('div')),
        this.__itemIcon.classList.add('chemistryStyle'),
        this.__itemIcon.classList.add('iconConsumable'),
        e.appendChild(this.__itemIcon),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemChemistryStyleSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__stackCount = null),
      this._mainImage.destroy(),
      (this.__desc = null),
      (this.__itemIcon = null);
  }),
  (components.ItemChemistryStyleSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemChemistryStyleSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemChemistryStyleSmall.prototype._render = function _render(
    e,
    t
  ) {
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.SMALL);
    var i = t.getSmallColorMap(e.getTier()),
      s = e.getStaticData(),
      n = utils.AssetLocator.getImage(s.assetType, e.getYear(), e.subtype);
    this._mainImage.setResource(n), this._applyColors('.itemDesc', i.footer);
  }),
  (components.ItemBadgeSmall = function ItemBadgeSmallView() {
    components.ItemBadgeBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemBadgeSmall, components.ItemBadgeBase),
  (components.ItemBadgeSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('badge'),
        e.classList.add('item');
      var t = document.createElement('span');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement());
      var i = document.createElement('div');
      i.classList.add('badge'),
        i.classList.add('iconClub'),
        e.appendChild(i),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemBadgeSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy();
  }),
  (components.ItemBadgeSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemBadgeSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemBadgeSmall.prototype._render = function _render(e, t) {
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.SMALL);
  }),
  (components.ItemKitSmall = function ItemKitSmallView() {
    components.ItemKitBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemKitSmall, components.ItemKitBase),
  (components.ItemKitSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'), e.classList.add('kit'), e.classList.add('item');
      var t = document.createElement('span');
      t.classList.add('statusOverlay'), e.appendChild(t);
      var i = document.createElement('div');
      i.classList.add('kitOverview'),
        (this._flagImage = new UTImageView()),
        this._flagImage.getRootElement().classList.add('flag'),
        i.appendChild(this._flagImage.getRootElement()),
        (this._badgeImage = new UTImageView()),
        this._badgeImage.getRootElement().classList.add('badge'),
        i.appendChild(this._badgeImage.getRootElement()),
        e.appendChild(i),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__desc = document.createElement('div')),
        this.__desc.classList.add('itemDesc'),
        e.appendChild(this.__desc);
      var s = document.createElement('div');
      s.classList.add('kit'),
        s.classList.add('iconClub'),
        e.appendChild(s),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemKitSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._flagImage.destroy(),
      this._badgeImage.destroy(),
      this._mainImage.destroy(),
      (this.__desc = null);
  }),
  (components.ItemKitSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemKitSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemKitSmall.prototype._render = function _render(e, t) {
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.SMALL);
    var i = t.getSmallColorMap(e.getTier());
    (this.__desc.textContent = e.getStaticData().description),
      this._applyColors('.itemDesc', i.footer);
  }),
  (components.ItemBallSmall = function ItemBallSmallView() {
    components.ItemBallBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemBallSmall, components.ItemBallBase),
  (components.ItemBallSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('ball'),
        e.classList.add('item');
      var t = document.createElement('span');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement());
      var i = document.createElement('div');
      i.classList.add('ball'),
        i.classList.add('iconClub'),
        e.appendChild(i),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemBallSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy();
  }),
  (components.ItemBallSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemBallSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemBallSmall.prototype._render = function _render(e, t) {
    this.superclass(e, t), this._setShell(e, enums.ItemViewType.SMALL);
  }),
  (components.ItemStadiumSmall = function ItemStadiumSmallView() {
    components.ItemStadiumBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemStadiumSmall, components.ItemStadiumBase),
  (components.ItemStadiumSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('stadium'),
        e.classList.add('item');
      var t = document.createElement('span');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement());
      var i = document.createElement('div');
      i.classList.add('stadium'),
        i.classList.add('iconClub'),
        e.appendChild(i),
        (this.__restrictedIcons = document.createElement('div')),
        this.__restrictedIcons.classList.add('restricted'),
        (this.__restrictedBanner = document.createElement('div')),
        this.__restrictedBanner.classList.add('banner'),
        this.__restrictedBanner.classList.add('iconClub'),
        this.__restrictedIcons.appendChild(this.__restrictedBanner),
        (this.__restrictedTifo = document.createElement('div')),
        this.__restrictedTifo.classList.add('tifo'),
        this.__restrictedTifo.classList.add('iconClub'),
        this.__restrictedIcons.appendChild(this.__restrictedTifo),
        e.appendChild(this.__restrictedIcons),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemStadiumSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy(),
      (this.__restrictedIcons = null),
      (this.__restrictedBanner = null),
      (this.__restrictedTifo = null);
  }),
  (components.ItemStadiumSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemStadiumSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemStadiumSmall.prototype.getImageUrl = function getImageUrl(
    e,
    t,
    i
  ) {
    return utils.AssetLocator.getSmallImage(e, t, i);
  }),
  (components.ItemStadiumSmall.prototype._render = function _render(e, t) {
    this.superclass(e, t),
      this._setShell(e, enums.ItemViewType.SMALL),
      this._renderRestrictions(e);
  }),
  (components.ItemMiscSmall = function ItemMiscSmallView() {
    components.ItemMiscBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemMiscSmall, components.ItemMiscBase),
  (components.ItemMiscSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('misc'),
        e.classList.add('item');
      var t = document.createElement('span');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement()),
        (this.__itemName = document.createElement('div')),
        this.__itemName.classList.add('name'),
        e.appendChild(this.__itemName),
        (this.__itemIcon = document.createElement('div')),
        this.__itemIcon.classList.add('iconConsumable'),
        e.appendChild(this.__itemIcon),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemMiscSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy(),
      (this.__itemName = null),
      (this.__itemIcon = null);
  }),
  (components.ItemMiscSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemMiscSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemMiscSmall.prototype.getImageUrl = function getImageUrl(
    e,
    t,
    i
  ) {
    return utils.AssetLocator.getSmallImage(e, t, i);
  }),
  (components.ItemMiscSmall.prototype._render = function _render(e, t) {
    this.superclass(e, t),
      e.isPlayerPickItem()
        ? (this.__itemName.textContent = services.Localization.localize(
            'card.title.playerpicks'
          ))
        : this._setShell(e, enums.ItemViewType.SMALL);
  }),
  (components.ItemTifoSmall = function ItemTifoSmallView() {
    components.ItemTifoBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemTifoSmall, components.ItemTifoBase),
  (components.ItemTifoSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('tifo'),
        e.classList.add('item');
      var t = document.createElement('span');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement());
      var i = document.createElement('div');
      i.classList.add('tifo'),
        i.classList.add('iconClub'),
        e.appendChild(i),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemTifoSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy();
  }),
  (components.ItemTifoSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemTifoSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemTifoSmall.prototype._render = function _render(e, t) {
    var i = e.getYear(),
      s = e.getStaticData();
    this.superclass(e, t);
    var n = utils.AssetLocator.getImage(
      utils.AssetLocator.IMAGE_TYPE_TIFO_SMALL,
      i,
      s.assetId
    );
    utils.AssetLocator.hasPlaceholder(
      enums.PlaceholderAssetKey.TIFOS,
      s.assetId,
      i
    ) &&
      (n = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_TIFO,
        i,
        enums.PlaceholderAssetId.TIFO
      )),
      this._mainImage
        .setResource(n, !0)
        .observe(this._mainImage, components.ItemTifoBase.onImageLoad),
      this._setShell(e, enums.ItemViewType.SMALL);
  }),
  (components.ItemBannerSmall = function ItemBannerSmallView() {
    components.ItemBannerBase.call(this), this._generate();
  }),
  utils.JS.inherits(components.ItemBannerSmall, components.ItemBannerBase),
  (components.ItemBannerSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('banner'),
        e.classList.add('item');
      var t = document.createElement('span');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement());
      var i = document.createElement('div');
      i.classList.add('banner'),
        i.classList.add('iconClub'),
        e.appendChild(i),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemBannerSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy();
  }),
  (components.ItemBannerSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemBannerSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemBannerSmall.prototype._render = function _render(e, t) {
    var i = e.resourceId,
      s = e.getYear();
    this.superclass(e, t);
    var n = utils.AssetLocator.getImage(
      utils.AssetLocator.IMAGE_TYPE_BANNER_SMALL,
      s,
      i
    );
    utils.AssetLocator.hasPlaceholder(
      enums.PlaceholderAssetKey.BANNERS,
      i,
      s
    ) &&
      (n = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_BANNER,
        s,
        enums.PlaceholderAssetId.BANNER
      )),
      this._mainImage
        .setResource(n, !0)
        .observe(this._mainImage, components.ItemBannerBase.onImageLoad),
      this._setShell(e, enums.ItemViewType.SMALL);
  }),
  (components.ItemCelebrationSmall = function ItemCelebrationSmallView() {
    components.ItemCelebrationBase.call(this), this._generate();
  }),
  utils.JS.inherits(
    components.ItemCelebrationSmall,
    components.ItemCelebrationBase
  ),
  (components.ItemCelebrationSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('small'),
        e.classList.add('celebration'),
        e.classList.add('item');
      var t = document.createElement('span');
      t.classList.add('statusOverlay'),
        e.appendChild(t),
        (this._mainImage = new UTImageView()),
        this._mainImage.getRootElement().classList.add('photo'),
        e.appendChild(this._mainImage.getRootElement());
      var i = document.createElement('div');
      i.classList.add('celebration'),
        i.classList.add('iconClub'),
        e.appendChild(i),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ItemCelebrationSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      this._mainImage.destroy();
  }),
  (components.ItemCelebrationSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ItemCelebrationSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ItemCelebrationSmall.prototype._render = function _render(e, t) {
    var i = e.getStaticData(),
      s = e.getYear();
    this.superclass(e, t);
    var n = utils.AssetLocator.getImage(
      utils.AssetLocator.IMAGE_TYPE_CELEBRATION_SMALL,
      s,
      i.assetId
    );
    utils.AssetLocator.hasPlaceholder(
      enums.PlaceholderAssetKey.CELEBRATIONS,
      i.assetId,
      s
    ) &&
      (n = utils.AssetLocator.getImage(
        utils.AssetLocator.IMAGE_TYPE_CELEBRATION,
        s,
        enums.PlaceholderAssetId.CELEBRATION
      )),
      this._mainImage
        .setResource(n, !0)
        .observe(this._mainImage, components.ItemCelebrationBase.onImageLoad),
      this._setShell(e, enums.ItemViewType.SMALL);
  }),
  utils.JS.inherits(UTImageView, UTView),
  (UTImageView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('img');
      e.setAttribute('src', 'images/transparent.png'),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTImageView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (UTImageView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTImageView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTImageView.prototype.allowImageCaching = function allowImageCaching(e) {
    this._useCache = !!e;
  }),
  (UTImageView.prototype.setLocalResource = function setLocalResource(e) {
    this.src = e;
    var t = this.getRootElement();
    if (t) {
      var i = utils.JS.isString(e) && 0 < e.length;
      (t.src = i ? e : ''), (t.style.display = i ? '' : 'none');
    }
  }),
  (UTImageView.prototype.replaceAndShowResource = function replaceAndShowResource(
    e
  ) {
    var t = this.getRootElement();
    t &&
      (this._useCache || (e = e + '?' + Date.now()),
      (t.src = e),
      (t.style.display = ''));
  }),
  (UTImageView.prototype.setExternalResource = function setExternalResource(
    e,
    t
  ) {
    return this._loadResource(e, !!t, !0);
  }),
  (UTImageView.prototype.setResource = function setResource(e, t) {
    return this._loadResource(e, !!t, !1);
  }),
  (UTImageView.prototype.clearResource = function clearResource() {
    (this.src = ''), (this.getRootElement().src = '');
  }),
  (UTImageView.prototype._loadResource = function _loadResource(e, t, i) {
    if (
      ((this.src =
        !0 === i
          ? e
          : gConfigurationModel.getConfigString(
              models.ConfigurationModel.KEY_RESOURCE_ROOT
            ) + e),
      (this.path = e),
      (this.getRootElement().style.display = 'none'),
      !utils.HTTP.urlHasImage(this.src))
    )
      return (
        this._imageLoadEvent.notify(!1, this, this.src), this._imageLoadEvent
      );
    if (t) {
      var s = this.getRootElement();
      this._addListener(
        enums.Event.LOAD,
        s,
        this._handleLoadSuccessEvent.bind(this)
      ),
        this._addListener(
          enums.Event.ERROR,
          s,
          this._handleLoadFailEvent.bind(this)
        );
    }
    return this.replaceAndShowResource(this.src), this._imageLoadEvent;
  }),
  (UTImageView.prototype._handleLoadSuccessEvent = function _handleLoadSuccessEvent(
    e
  ) {
    var t = this.getRootElement();
    t.complete &&
      (0 === t.naturalWidth
        ? this._imageLoadEvent.notify(!1, this, this.src)
        : this._imageLoadEvent.notify(!0, this, this.src),
      this._removeListenersByName(enums.Event.LOAD, enums.Event.ERROR));
  }),
  (UTImageView.prototype._handleLoadFailEvent = function _handleLoadFailEvent(
    e
  ) {
    this._imageLoadEvent.notify(!1, this, this.src),
      this._removeListenersByName(enums.Event.LOAD, enums.Event.ERROR);
  }),
  (components.CustomBrickItemBase = function() {
    components.ItemFUTBase.call(this), (this._imgLoaders = []);
  }),
  utils.JS.inherits(components.CustomBrickItemBase, components.ItemFUTBase),
  (components.CustomBrickItemBase.prototype._render = function _render(e) {
    this._renderCustomRequirement(
      enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_ID,
      e.leagueId
    ),
      this._renderCustomRequirement(
        enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_ID,
        e.teamId
      ),
      this._renderCustomRequirement(
        enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_ID,
        e.nationId
      );
  }),
  (components.CustomBrickItemBase.prototype._resetRender = function _resetRender() {
    this._imgLoaders.forEach(function(e) {
      e.dealloc();
    }, this),
      (this._imgLoaders = []),
      this.getRootElement().removeAttribute('style');
  }),
  (components.CustomBrickItemBase.prototype._renderShell = function _renderShell(
    e,
    t
  ) {}),
  (components.CustomBrickItemBase.prototype._renderCustomRequirement = function _checkForCustomRequirement(
    e,
    t
  ) {
    var i = this._generateImageLoader(e, t);
    this._imgLoaders.push(i),
      this.getRootElement().appendChild(i.getRootElement());
  }),
  (components.CustomBrickItemBase.prototype._generateImageLoader = function _generateImageLoader(
    e,
    t
  ) {
    var i = new UTImageView();
    switch (e) {
      case enums.SBC.ELG_KEY.FUT_ELGRULE_NATION_ID:
        i.setResource(
          utils.AssetLocator.getImage(
            utils.AssetLocator.IMAGE_TYPE_FLAG,
            enums.Year.ASSET,
            t
          )
        );
        break;
      case enums.SBC.ELG_KEY.FUT_ELGRULE_LEAGUE_ID:
        i.setResource(
          utils.AssetLocator.getImage(
            utils.AssetLocator.IMAGE_TYPE_LEAGUE_DARK,
            enums.Year.ASSET,
            t
          )
        );
        break;
      case enums.SBC.ELG_KEY.FUT_ELGRULE_CLUB_ID:
        i.setResource(
          utils.AssetLocator.getImage(
            utils.AssetLocator.IMAGE_TYPE_BADGE_DARK,
            enums.Year.ASSET,
            t
          )
        );
        break;
      default:
        utils.Debug.Assert(!1, 'Reached default case: ' + e);
    }
    return i;
  }),
  (components.CustomBrickItemBase.prototype.canRender = function canRender(e) {
    return e.isCustomBrick();
  }),
  (components.CustomBrickItemSmall = function() {
    components.CustomBrickItemBase.call(this), this._generate();
  }),
  utils.JS.inherits(
    components.CustomBrickItemSmall,
    components.CustomBrickItemBase
  ),
  (components.CustomBrickItemSmall.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('custom-brick'),
        e.classList.add('small'),
        e.classList.add('item');
      var t = document.createElement('div');
      t.classList.add('lock'),
        e.appendChild(t),
        (this.__league = document.createElement('span')),
        e.appendChild(this.__league),
        (this.__team = document.createElement('span')),
        e.appendChild(this.__team),
        (this.__nation = document.createElement('span')),
        e.appendChild(this.__nation),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.CustomBrickItemSmall.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__league = null),
      (this.__team = null),
      (this.__nation = null);
  }),
  (components.CustomBrickItemSmall.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.CustomBrickItemSmall.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.CustomBrickItemSmall.prototype._render = function _render(e) {
    this.superclass(e),
      0 === e.nationId
        ? (this.__nation.textContent = services.Localization.localize(
            'roles.defaultRole'
          ))
        : (this.__nation.textContent = utils.FUTLocalization.getNationAbb3ById(
            e.nationId
          )),
      0 === e.leagueId
        ? (this.__league.textContent = services.Localization.localize(
            'roles.defaultRole'
          ))
        : (this.__league.textContent = utils.FUTLocalization.getLeagueAbbr5ByID(
            e.leagueId,
            e.getYear()
          )),
      0 === e.teamId
        ? (this.__team.textContent = services.Localization.localize(
            'roles.defaultRole'
          ))
        : (this.__team.textContent = utils.FUTLocalization.getTeamAbb3ByID(
            e.teamId,
            e.getYear()
          ));
  }),
  (components.CustomBrickItemLarge = function() {
    components.CustomBrickItemBase.call(this), this._generate();
  }),
  utils.JS.inherits(
    components.CustomBrickItemLarge,
    components.CustomBrickItemBase
  ),
  (components.CustomBrickItemLarge.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('custom-brick'),
        e.classList.add('large'),
        e.classList.add('item'),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.CustomBrickItemLarge.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null);
  }),
  (components.CustomBrickItemLarge.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.CustomBrickItemLarge.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  NamespaceManager.Register('factories'),
  (factories.ItemView = (function() {
    function UTItemViewFactory() {
      UTObject.call(this);
    }
    return (
      utils.JS.inherits(UTItemViewFactory, UTObject),
      (UTItemViewFactory.prototype.createLargeItem = function createLargeItem(
        e
      ) {
        var t;
        switch (
          (utils.Debug.Assert(
            e instanceof entities.Item,
            'Expected an item entity'
          ),
          e.type)
        ) {
          case enums.ItemType.PLAYER:
            t = e.isCustomBrick()
              ? new components.CustomBrickItemLarge()
              : new UTItemPlayerLargeView();
            break;
          case enums.ItemType.MANAGER:
            t = new components.ItemManagerLarge();
            break;
          case enums.ItemType.BADGE:
            t = new components.ItemBadgeLarge();
            break;
          case enums.ItemType.KIT:
            t = new components.ItemKitLarge();
            break;
          case enums.ItemType.BALL:
            t = new components.ItemBallLarge();
            break;
          case enums.ItemType.STADIUM:
            t = new components.ItemStadiumLarge();
            break;
          case enums.ItemType.TRAINING:
            t = e.isStyleModifier()
              ? new components.ItemChemistryStyleLarge()
              : new components.ItemConsumableLarge();
            break;
          case enums.ItemType.HEALTH:
          case enums.ItemType.CONTRACT:
            t = new components.ItemConsumableLarge();
            break;
          case enums.ItemType.MISC:
            t = new components.ItemMiscLarge();
            break;
          case enums.ItemType.HEAD_COACH:
          case enums.ItemType.GK_COACH:
          case enums.ItemType.FITNESS_COACH:
          case enums.ItemType.PHYSIO:
            t = new components.ItemStaffLarge();
            break;
          case enums.ItemType.TIFO:
            t = new components.ItemTifoLarge();
            break;
          case enums.ItemType.BANNER:
            t = new components.ItemBannerLarge();
            break;
          case enums.ItemType.CELEBRATION:
            t = new components.ItemCelebrationLarge();
            break;
          default:
            t = new UTItemPlayerLargeView();
        }
        return t;
      }),
      (UTItemViewFactory.prototype.createSmallItem = function createSmallItem(
        e
      ) {
        var t;
        switch (
          (utils.Debug.Assert(
            e instanceof entities.Item,
            'Expected an item entity'
          ),
          e.type)
        ) {
          case enums.ItemType.PLAYER:
            t = e.isCustomBrick()
              ? new components.CustomBrickItemSmall()
              : new UTItemPlayerSmallView();
            break;
          case enums.ItemType.MANAGER:
            t = new components.ItemManagerSmall();
            break;
          case enums.ItemType.BADGE:
            t = new components.ItemBadgeSmall();
            break;
          case enums.ItemType.KIT:
            t = new components.ItemKitSmall();
            break;
          case enums.ItemType.BALL:
            t = new components.ItemBallSmall();
            break;
          case enums.ItemType.STADIUM:
            t = new components.ItemStadiumSmall();
            break;
          case enums.ItemType.TRAINING:
            t = e.isStyleModifier()
              ? new components.ItemChemistryStyleSmall()
              : new components.ItemConsumableSmall();
            break;
          case enums.ItemType.HEALTH:
          case enums.ItemType.CONTRACT:
            t = new components.ItemConsumableSmall();
            break;
          case enums.ItemType.MISC:
            t = new components.ItemMiscSmall();
            break;
          case enums.ItemType.TIFO:
            t = new components.ItemTifoSmall();
            break;
          case enums.ItemType.BANNER:
            t = new components.ItemBannerSmall();
            break;
          case enums.ItemType.CELEBRATION:
            t = new components.ItemCelebrationSmall();
            break;
          case enums.ItemType.HEAD_COACH:
          case enums.ItemType.GK_COACH:
          case enums.ItemType.FITNESS_COACH:
          case enums.ItemType.PHYSIO:
            t = new components.ItemStaffSmall();
            break;
          default:
            t = new UTItemPlayerSmallView();
        }
        return t;
      }),
      new UTItemViewFactory()
    );
  })()),
  (components.ListDataPlaystyle = function UTListDataPlayStyleView() {
    UTView.call(this), this._generate();
  });

function UTSendToSquadView() {
  UTView.call(this),
    (this._pinnedRow = null),
    Object.defineProperty(this, '_pinnedRow', {
      writable: !0,
      enumerable: !1
    }),
    (this.onSlotSelected = new UTObservable()),
    Object.defineProperty(this, 'onSlotSelected', {
      writable: !1,
      enumerable: !0
    }),
    this._generate();
}

function UTSquadSectionListViewModel(e) {
  viewmodels.ItemSectionList.call(this, e),
    this.setSection(
      UTSquadSectionListViewModel.SECTION.STARTING_ELEVEN,
      function(e) {
        return 0 <= e.getIndex() && e.getIndex() < entities.Squad.FIELD_PLAYERS;
      },
      UTSquadSectionListViewModel.SECTION.STARTING_ELEVEN
    ),
    this.setSection(
      UTSquadSectionListViewModel.SECTION.SUBS,
      function(e) {
        return (
          e.getIndex() >= entities.Squad.FIELD_PLAYERS &&
          e.getIndex() <
            entities.Squad.FIELD_PLAYERS + entities.Squad.SUB_PLAYERS
        );
      },
      UTSquadSectionListViewModel.SECTION.SUBS
    ),
    this.setSection(
      UTSquadSectionListViewModel.SECTION.RESERVES,
      function(e) {
        return (
          e.getIndex() >=
            entities.Squad.FIELD_PLAYERS + entities.Squad.SUB_PLAYERS &&
          e.getIndex() < entities.Squad.MANAGER_SLOT_INDEX
        );
      },
      UTSquadSectionListViewModel.SECTION.RESERVES
    ),
    this._organizeItems();
}

function UTSendToSquadViewController() {
  UTViewController.call(this),
    (this._viewmodel = null),
    (this._pinnedItem = null),
    (this._squad = null),
    (this._selectedSlotIndex = -1),
    (this._defaultedToActiveSquad = !1);
}

function UTMarketSearchView() {
  UTTargetActionView.call(this),
    (this._pinnedItemView = null),
    Object.defineProperty(this, '_pinnedItemView', {
      writable: !0,
      enumerable: !1
    });
}

function UTSquadMarketSearchViewModel() {
  UTObject.call(this),
    (this._squad = null),
    Object.defineProperty(this, '_squad', {
      writable: !0,
      enumerable: !1
    }),
    (this._slotIndex = 0),
    Object.defineProperty(this, '_slotIndex', {
      writable: !0,
      enumerable: !1
    });
}

function UTTransferMarketPaginationViewModel() {
  UTViewModel.call(this),
    (this._paginationList = null),
    Object.defineProperty(this, '_paginationList', {
      enumerable: !1,
      writable: !0
    }),
    (this._pageIndex = 1),
    Object.defineProperty(this, '_pageIndex', {
      enumerable: !1,
      writable: !0
    });
}

function UTMarketSearchResultsViewController() {
  UTViewController.call(this),
    (this._itemListViewDelegate = null),
    Object.defineProperty(this, '_itemListViewDelegate', {
      writable: !0,
      enumerable: !1
    }),
    (this._paginationViewModel = null),
    Object.defineProperty(this, '_paginationViewModel', {
      writable: !0,
      enumerable: !1
    }),
    (this._searchCriteria = null),
    Object.defineProperty(this, '_searchCriteria', {
      writable: !0,
      enumerable: !1
    }),
    (this._squadContext = null),
    Object.defineProperty(this, '_squadContext', {
      writable: !0,
      enumerable: !1
    }),
    (this._compareItem = null),
    Object.defineProperty(this, '_compareItem', {
      writable: !0,
      enumerable: !1
    }),
    (this._selectedItem = null),
    Object.defineProperty(this, '_selectedItem', {
      writable: !0,
      enumerable: !1
    }),
    (this._pinnedListItem = null),
    Object.defineProperty(this, '_pinnedListItem', {
      writable: !0,
      enumerable: !1
    }),
    (this._arbitraryInterval = 0),
    Object.defineProperty(this, '_arbitraryInterval', {
      writable: !0,
      enumerable: !1
    }),
    (this.onDataChange = new UTObservable()),
    Object.defineProperty(this, 'onDataChange', {
      writable: !1,
      enumerable: !0
    });
}

function UTMarketSearchResultsSplitViewController() {
  UTSplitViewController.call(this),
    (this._listController = new UTMarketSearchResultsViewController()),
    (this._itemDetailController = new controllers.navigation.ItemDetails());
}

function UTPlayerSearchControl() {
  UTControl.call(this),
    (this._timeout = 0),
    (this._closeTimeout = 0),
    (this._inputChangeTimeout = 0),
    (this._tapDelay = 0),
    (this._searchEngine = new utils.PlayerSearchEngine(
      repositories.Item.getStaticData()
    )),
    (this._currentQuery = []),
    (this._currentName = ''),
    (this._isOpen = !1),
    (this._selected = null),
    (this._windowListener = this._windowClick.bind(this));
}

function UTNumberInputControl() {
  UTControl.call(this),
    (this.value = 0),
    Object.defineProperty(this, 'value', {
      get: this.getValue,
      set: this.setValue,
      enumerable: !0
    }),
    (this._minValue = Number.MIN_SAFE_INTEGER),
    Object.defineProperty(this, '_minValue', {
      writable: !0,
      enumerable: !1
    }),
    (this._maxValue = Number.MAX_SAFE_INTEGER),
    Object.defineProperty(this, '_maxValue', {
      writable: !0,
      enumerable: !1
    }),
    (this._selectionTimeout = 0),
    Object.defineProperty(this, '_selectionTimeout', {
      writable: !0,
      enumerable: !1
    });
}

function UTCurrencyInputControl() {
  UTNumberInputControl.call(this),
    (this._defaultValue = 0),
    Object.defineProperty(this, '_defaultValue', {
      writable: !0,
      enumerable: !1
    });
}

function UTNumericInputSpinnerControl() {
  UTView.call(this);
}

function UTMarketSearchFiltersView() {
  UTTargetActionView.call(this),
    (this._pinnedListRowItem = null),
    Object.defineProperty(this, '_pinnedListRowItem', {
      writable: !0,
      enumerable: !1
    });
}

function UTMarketSearchFiltersViewController() {
  UTViewController.call(this),
    (this._viewmodel = null),
    (this._squadContext = null);
}

function UTToggleButtonControl() {
  UTButtonControl.call(this),
    (this._checked = !1),
    (this._textOn = ''),
    (this._textOff = '');
}

function UTTileDimOverlayView() {
  UTView.call(this);
}

function UTTileView() {
  UTTargetActionView.call(this),
    (this._title = ''),
    Object.defineProperty(this, '_title', {
      writable: !0,
      enumerable: !1
    }),
    (this._highlightTimeout = 0),
    Object.defineProperty(this, '_highlightTimeout', {
      writable: !0,
      enumerable: !1
    }),
    (this._contentView = null),
    Object.defineProperty(this, '_contentView', {
      writable: !0,
      enumerable: !1
    }),
    (this._dimOverlay = null),
    Object.defineProperty(this, '_dimOverlay', {
      writable: !0,
      enumerable: !1
    }),
    (this.contentLoaded = !1);
}

function UTConsumablesHubView() {
  UTView.call(this);
}

function UTConsumablesHubViewController() {
  UTViewController.call(this), (this._viewmodel = null);
}

function UTCustomItemsHubView() {
  UTView.call(this);
}

function UTCustomItemsHubViewController() {
  UTViewController.call(this), (this._viewmodel = null);
}

function UTClubHubView() {
  UTView.call(this), this._generate();
}

function UTClubHubViewController() {
  UTViewController.call(this), (this._viewmodel = new viewmodels.Club([]));
}

function UTGoToLinkController() {
  UTObject.call(this), (this._nc = null);
}

function UTUnassignedItemsViewModel(e) {
  viewmodels.ItemSectionList.call(this, e),
    (this._requests = []),
    Object.defineProperty(this, '_permutation', {
      writable: !0,
      enumerable: !1
    }),
    this.setSection(
      UTUnassignedItemsViewModel.SECTION.ITEMS,
      function(e) {
        return e.isMovable() || e.isMiscItem();
      },
      UTUnassignedItemsViewModel.SECTION.ITEMS
    ),
    this.setSection(
      UTUnassignedItemsViewModel.SECTION.DUPLICATES,
      function(e) {
        return !e.isMovable() && !e.isMiscItem();
      },
      UTUnassignedItemsViewModel.SECTION.DUPLICATES
    ),
    this._organizeItems();
}
utils.JS.inherits(components.ListDataPlaystyle, UTView),
  (components.ListDataPlaystyle.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('list-data-playstyle'), e.classList.add('styleView');
      var t = document.createElement('ul'),
        i = document.createElement('li');
      (this.__label1 = document.createElement('span')),
        this.__label1.classList.add('Pace'),
        this.__label1.classList.add('statLabel'),
        i.appendChild(this.__label1),
        (this._chevronSet1 = new UTItemStatChevronsView()),
        i.appendChild(this._chevronSet1.getRootElement()),
        t.appendChild(i);
      var s = document.createElement('li');
      (this.__label2 = document.createElement('span')),
        this.__label2.classList.add('Shooting'),
        this.__label2.classList.add('statLabel'),
        s.appendChild(this.__label2),
        (this._chevronSet2 = new UTItemStatChevronsView()),
        s.appendChild(this._chevronSet2.getRootElement()),
        t.appendChild(s);
      var n = document.createElement('li');
      (this.__label3 = document.createElement('span')),
        this.__label3.classList.add('Passing'),
        this.__label3.classList.add('statLabel'),
        n.appendChild(this.__label3),
        (this._chevronSet3 = new UTItemStatChevronsView()),
        n.appendChild(this._chevronSet3.getRootElement()),
        t.appendChild(n);
      var o = document.createElement('li');
      (this.__label4 = document.createElement('span')),
        this.__label4.classList.add('Dibbling'),
        this.__label4.classList.add('statLabel'),
        o.appendChild(this.__label4),
        (this._chevronSet4 = new UTItemStatChevronsView()),
        o.appendChild(this._chevronSet4.getRootElement()),
        t.appendChild(o);
      var a = document.createElement('li');
      (this.__label5 = document.createElement('span')),
        this.__label5.classList.add('Defending'),
        this.__label5.classList.add('statLabel'),
        a.appendChild(this.__label5),
        (this._chevronSet5 = new UTItemStatChevronsView()),
        a.appendChild(this._chevronSet5.getRootElement()),
        t.appendChild(a);
      var r = document.createElement('li');
      (this.__label6 = document.createElement('span')),
        this.__label6.classList.add('Header'),
        this.__label6.classList.add('statLabel'),
        r.appendChild(this.__label6),
        (this._chevronSet6 = new UTItemStatChevronsView()),
        r.appendChild(this._chevronSet6.getRootElement()),
        t.appendChild(r),
        e.appendChild(t),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ListDataPlaystyle.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__label1 = null),
      this._chevronSet1.destroy(),
      (this.__label2 = null),
      this._chevronSet2.destroy(),
      (this.__label3 = null),
      this._chevronSet3.destroy(),
      (this.__label4 = null),
      this._chevronSet4.destroy(),
      (this.__label5 = null),
      this._chevronSet5.destroy(),
      (this.__label6 = null),
      this._chevronSet6.destroy();
  }),
  (components.ListDataPlaystyle.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ListDataPlaystyle.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ListDataPlaystyle.prototype.render = function render(e) {
    var t = e.isPlayer() ? e.playStyle : e.subtype,
      i = e.isPlayer() ? e.isGK() : e.isGKStyleModifier(),
      s = repositories.PlayStyle.getPlayStyleBonusById(t, i);
    this._applyChevrons(s),
      (this.__label1.textContent = services.Localization.localize(
        i ? 'cards.cardfront.divingAbbr' : 'cards.cardfront.paceAbbr'
      )),
      (this.__label2.textContent = services.Localization.localize(
        i ? 'cards.cardfront.handlingAbbr' : 'cards.cardfront.shootingAbbr'
      )),
      (this.__label3.textContent = services.Localization.localize(
        i ? 'cards.cardfront.kickAbbr' : 'cards.cardfront.passingAbbr'
      )),
      (this.__label4.textContent = services.Localization.localize(
        i ? 'cards.cardfront.reflexAbbr' : 'cards.cardfront.dribblingAbbr'
      )),
      (this.__label5.textContent = services.Localization.localize(
        i ? 'cards.cardfront.speedAbbr' : 'cards.cardfront.defendingAbbr'
      )),
      (this.__label6.textContent = services.Localization.localize(
        i ? 'cards.cardfront.positionAbbr' : 'cards.cardfront.headingAbbr'
      ));
  }),
  (components.ListDataPlaystyle.prototype.update = function update(e) {}),
  (components.ListDataPlaystyle.prototype._applyChevrons = function _applyChevrons(
    e
  ) {
    e.slice(0, 6).forEach(function applyChevrons(e, t) {
      var i = this['_chevronSet' + (t + 1)];
      i && (i.setChevronCount(e), i.setChemistryBoost(e));
      var s = this['__label' + (t + 1)];
      s && DOMKit.toggleClass(s, 'chemBoost', 0 < e);
    }, this);
  }),
  utils.JS.inherits(UTListDataPlayerStatsView, UTView),
  (UTListDataPlayerStatsView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('player-stats-data-component');
      var t = document.createElement('ul'),
        i = document.createElement('li'),
        s = document.createElement('span');
      s.classList.add('label'), i.appendChild(s);
      var n = document.createElement('span');
      n.classList.add('value'), i.appendChild(n), t.appendChild(i);
      var o = document.createElement('li'),
        a = document.createElement('span');
      a.classList.add('label'), o.appendChild(a);
      var r = document.createElement('span');
      r.classList.add('value'), o.appendChild(r), t.appendChild(o);
      var l = document.createElement('li'),
        c = document.createElement('span');
      c.classList.add('label'), l.appendChild(c);
      var u = document.createElement('span');
      u.classList.add('value'), l.appendChild(u), t.appendChild(l);
      var d = document.createElement('li'),
        h = document.createElement('span');
      h.classList.add('label'), d.appendChild(h);
      var p = document.createElement('span');
      p.classList.add('value'), d.appendChild(p), t.appendChild(d);
      var _ = document.createElement('li'),
        m = document.createElement('span');
      m.classList.add('label'), _.appendChild(m);
      var g = document.createElement('span');
      g.classList.add('value'), _.appendChild(g), t.appendChild(_);
      var T = document.createElement('li'),
        S = document.createElement('span');
      S.classList.add('label'), T.appendChild(S);
      var C = document.createElement('span');
      C.classList.add('value'),
        T.appendChild(C),
        t.appendChild(T),
        e.appendChild(t),
        (this.__slotPosition = document.createElement('span')),
        this.__slotPosition.classList.add('slot-position'),
        e.appendChild(this.__slotPosition),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTListDataPlayerStatsView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__slotPosition = null);
  }),
  (UTListDataPlayerStatsView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTListDataPlayerStatsView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTListDataPlayerStatsView.prototype.setSlotData = function setSlotData(e) {
    this.slotData = e || null;
  }),
  (UTListDataPlayerStatsView.prototype.setComparisonData = function setComparisonData(
    e
  ) {
    this.comparisonData = e;
  }),
  (UTListDataPlayerStatsView.prototype.render = function render(e) {
    var t = e.getAttributes(),
      i = this.getRoot().find('li'),
      s = this.getRoot().find('.label'),
      n = this.getRoot().find('.value'),
      o = e.isGK()
        ? enums.Localization.STATS_LABELS_GK
        : enums.Localization.STATS_LABELS_PLAYER;

    function limitToMax(e) {
      return 99 < e ? 99 : e;
    }
    var a,
      r = 0;
    for (r = 0; r < t.length; r++)
      e.isValid()
        ? ((s.get(r).innerHTML = services.Localization.localize(o[r])),
          (n.get(r).innerHTML = t[r]))
        : ((s.get(r).innerHTML = ''), (n.get(r).innerHTML = ''));
    if (
      (s.removeClass('statIncrease statDecrease'),
      n.removeClass('statIncrease statDecrease'),
      utils.JS.isValid(this.comparisonData) &&
        this.comparisonData.isValid() &&
        e.compareType(this.comparisonData))
    ) {
      var l,
        c,
        u = t.slice(),
        d = this.comparisonData.getStaticData(),
        h = '',
        p = this.comparisonData.getAttributes();
      if (
        this.comparisonData.isPlayer() &&
        e.isPlayer() &&
        this.comparisonData.isGK() === e.isGK()
      )
        for (r = 0; r < t.length; r++)
          t[r] !== p[r] &&
            ((h = t[r] > p[r] ? 'statIncrease' : 'statDecrease'),
            s.eq(r).addClass(h),
            n.eq(r).addClass(h));
      else if (
        this.comparisonData.isPlayerTraining() ||
        this.comparisonData.isGKTraining()
      ) {
        if (e.hasTraining()) {
          var _ = e.getAppliedTrainingItem(),
            m = _.getStaticData();
          if (
            ((l = m.amount),
            (c = m.trainedAttribute),
            _.isAllAttributeTraining())
          )
            for (r = 0; r < t.length; r++) u[r] -= l;
          else u[c] -= l;
        }
        if (
          ((l = d.amount),
          (c = d.trainedAttribute),
          this.comparisonData.isAllAttributeTraining())
        )
          for (r = 0; r < t.length; r++) u[r] = limitToMax(u[r] + l);
        else u[c] = limitToMax(u[c] + l);
        for (r = 0; r < t.length; r++) {
          var g = u[r],
            T = t[r];
          (h = T < g ? 'statIncrease' : g < T ? 'statDecrease' : ''),
            s.eq(r).addClass(h),
            n.eq(r).addClass(h),
            (n.get(r).innerHTML = g);
        }
      }
    }
    if (e.hasTraining())
      for (
        a =
          e.getBoostLevel() === enums.ItemRatingTier.GOLD
            ? components.ItemFUTBase.QUALITY.GOLD
            : e.getBoostLevel() === enums.ItemRatingTier.SILVER
            ? components.ItemFUTBase.QUALITY.SILVER
            : components.ItemFUTBase.QUALITY.BRONZE,
          r = 0;
        r < t.length;
        ++r
      )
        e.isAttributeBoosted(r) && i.eq(r).addClass(a);
    if (
      utils.JS.isValid(this.slotData) &&
      utils.JS.isValid(this.slotData.getUniquePosition())
    ) {
      var S = this.slotData.getGeneralPosition();
      utils.JS.isValid(S) &&
        ((this.__slotPosition.textContent = utils.FUTLocalization.getLocalizedPositionStringById(
          S
        )),
        DOMKit.addClass(
          this.__slotPosition,
          this.getZoneClass(this.slotData.getGeneralPosition())
        ));
    }
  }),
  (UTListDataPlayerStatsView.prototype.update = function update(e) {}),
  (UTListDataPlayerStatsView.prototype.getZoneClass = function getZoneClass(e) {
    var t = enums.SquadPositionZones[e],
      i = 0;
    for (i = 0; i < this._zoneClasses.length; i++)
      if (this._zoneClasses[i].zone === t)
        return this._zoneClasses[i].zoneClass;
    return '';
  }),
  (components.ListDataString = function() {
    (this.string = ''), this._generate();
  }),
  (components.ListDataString.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('dataString'),
        (this.__str = document.createElement('span')),
        this.__str.classList.add('subtype'),
        e.appendChild(this.__str),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ListDataString.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__str = null);
  }),
  (components.ListDataString.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ListDataString.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ListDataString.prototype.render = function() {
    this.__str.textContent = this.string;
  }),
  (components.ListDataString.prototype.update = function() {}),
  (components.ListDataString.prototype.destroy = function() {
    this.destroyGeneratedElements();
  }),
  (components.ListDataString.prototype.setString = function(e) {
    this.string = e;
  }),
  (components.ListDataString.prototype.getString = function() {
    return this.string;
  }),
  NamespaceManager.Register('components'),
  (components.ListDataContracts = function() {
    (this._comparisonData = null), this._generate();
  }),
  (components.ListDataContracts.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('contracts-data-component'),
        (this.__label = document.createElement('span')),
        e.appendChild(this.__label),
        (this.__delta = document.createElement('span')),
        this.__delta.classList.add('statIncrease'),
        e.appendChild(this.__delta),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ListDataContracts.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__label = null),
      (this.__delta = null);
  }),
  (components.ListDataContracts.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ListDataContracts.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ListDataContracts.prototype.init = function init() {}),
  (components.ListDataContracts.prototype.destroy = function destroy() {
    (this._comparisonData = null), this.destroyGeneratedElements();
  }),
  (components.ListDataContracts.prototype.render = function render(e) {
    if (
      ((this.__label.textContent = services.Localization.localize(
        'listdata.contracts',
        [e.contract]
      )),
      this._comparisonData && this._comparisonData.isContract())
    ) {
      var t,
        i = this._comparisonData.getStaticData();
      (t = e.isBronzeRating()
        ? i.bronzeBoost
        : e.isSilverRating()
        ? i.silverBoost
        : i.goldBoost),
        (this.__delta.textContent = ' +' + t);
    }
  }),
  (components.ListDataContracts.prototype.setComparisonData = function setComparisonData(
    e
  ) {
    this._comparisonData = e;
  }),
  (components.ListDataContracts.prototype.update = function update(e) {}),
  utils.JS.inherits(UTListDataFitnessView, UTView),
  (UTListDataFitnessView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      (this.__label = document.createElement('span')),
        e.appendChild(this.__label),
        (this.__delta = document.createElement('span')),
        this.__delta.classList.add('statIncrease'),
        e.appendChild(this.__delta),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTListDataFitnessView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__label = null),
      (this.__delta = null);
  }),
  (UTListDataFitnessView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTListDataFitnessView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTListDataFitnessView.prototype.dealloc = function dealloc() {
    (this._comparisonData = null), this.superclass();
  }),
  (UTListDataFitnessView.prototype.render = function render(e) {
    if (
      ((this.__label.textContent = services.Localization.localize(
        'listdata.fitness',
        [e.fitness]
      )),
      utils.JS.isValid(this._comparisonData) &&
        this._comparisonData.isFitness())
    ) {
      var t = this._comparisonData.getStaticData(),
        i = t.amount - Math.max(t.amount + e.fitness - 99, 0);
      this.__delta.textContent = ' +' + i;
    }
  }),
  (UTListDataFitnessView.prototype.setComparisonData = function setComparisonData(
    e
  ) {
    this._comparisonData = e;
  }),
  (UTListDataFitnessView.prototype.update = function update(e) {}),
  NamespaceManager.Register('components'),
  (components.ListDataPlayerPosition = function() {
    (this._comparisonData = null), this._generate();
  }),
  (components.ListDataPlayerPosition.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      (this.__label = document.createElement('span')),
        e.appendChild(this.__label),
        (this.__delta = document.createElement('span')),
        this.__delta.classList.add('statIncrease'),
        e.appendChild(this.__delta),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ListDataPlayerPosition.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__label = null),
      (this.__delta = null);
  }),
  (components.ListDataPlayerPosition.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ListDataPlayerPosition.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ListDataPlayerPosition.prototype.init = function init() {}),
  (components.ListDataPlayerPosition.prototype.destroy = function destroy() {
    (this._comparisonData = null), this.destroyGeneratedElements();
  }),
  (components.ListDataPlayerPosition.prototype.render = function render(e) {
    var t = services.Localization.localize(
      'extendedPlayerInfo.positions.position' + e.preferredPosition
    );
    if (
      ((this.__label.textContent = services.Localization.localize(
        'listdata.change',
        [t]
      )),
      utils.JS.isValid(this._comparisonData) &&
        this._comparisonData.isPlayerPositionModifier())
    ) {
      var i = this._comparisonData.getStaticData(),
        s = utils.FUTLocalization.getLocalizedPositionStringByName(
          i.trainPosTo
        );
      this.__delta.textContent = ' ' + s;
    }
  }),
  (components.ListDataPlayerPosition.prototype.setComparisonData = function setComparisonData(
    e
  ) {
    this._comparisonData = e;
  }),
  (components.ListDataPlayerPosition.prototype.update = function update(e) {}),
  NamespaceManager.Register('utils'),
  (utils.FUTLocalization = {}),
  (utils.FUTLocalization.getNationNameById = function getNationNameById(e) {
    return services.Localization.localize('search.nationName.nation' + e);
  }),
  (utils.FUTLocalization.getNationAbb3ById = function getNationAbb3ById(e) {
    return services.Localization.localize('nationAbbrvByID_' + e);
  }),
  (utils.FUTLocalization.getNationAbb12ById = function getNationAbb12ById(e) {
    return services.Localization.localize('search.nationAbbr12.nation' + e);
  }),
  (utils.FUTLocalization.getFormationByName = function getFormationByName(e) {
    return services.Localization.localize('global.formation.' + e);
  }),
  (utils.FUTLocalization.getPlaystyleByID = function getPlaystyleByID(e, t) {
    return 0 < e
      ? services.Localization.localize('playstyles.playstyle' + e)
      : services.Localization.localize('playstyles.invalid.playstyle0');
  }),
  (utils.FUTLocalization.getTeamAbb3ByID = function getTeamAbb3ByID(e, t) {
    return services.Localization.localize(
      'global.teamabbr3.' + APP_YEAR + '.team' + e
    );
  }),
  (utils.FUTLocalization.getTeamAbb15ByID = function getTeamAbb15ByID(e, t) {
    return services.Localization.localize(
      'global.teamabbr15.' + APP_YEAR + '.team' + e
    );
  }),
  (utils.FUTLocalization.getLeagueAbbr5ByID = function getLeagueAbbr5ByID(
    e,
    t
  ) {
    return services.Localization.localize(
      'global.leagueabbr5.' + APP_YEAR + '.league' + e
    );
  }),
  (utils.FUTLocalization.getLeagueNameByID = function getLeagueNameByID(e, t) {
    return services.Localization.localize(
      'global.leagueabbr15.' + APP_YEAR + '.league' + e
    );
  }),
  (utils.FUTLocalization.getStaffAttribute = function getStaffAttribute(e, t) {
    var i = '';
    switch (e) {
      case enums.ItemType.HEAD_COACH:
        i = services.Localization.localize(
          [
            'headcoach.pace',
            'headcoach.shooting',
            'headcoach.passing',
            'headcoach.dribbling',
            'headcoach.defending',
            'headcoach.heading'
          ][t]
        );
        break;
      case enums.ItemType.GK_COACH:
        i = services.Localization.localize(
          [
            'gkcoach.diving',
            'gkcoach.handling',
            'gkcoach.kicking',
            'gkcoach.reflexes',
            'gkcoach.speed',
            'gkcoach.positioning'
          ][t]
        );
        break;
      case enums.ItemType.PHYSIO:
        i = services.Localization.localize(
          [
            'physiocoach.head',
            'physiocoach.shoulder',
            'physiocoach.arm',
            'physiocoach.back',
            'physiocoach.hip',
            'physiocoach.leg',
            'physiocoach.foot'
          ][t]
        );
        break;
      case enums.ItemType.FITNESS_COACH:
        i = services.Localization.localize('fitnesscoach.fitness');
        break;
      default:
        window.console.log(
          '[FUTLocalization] getStaffAttribute() reached default state = ' + e
        );
    }
    return i;
  }),
  (utils.FUTLocalization.convertAttributeIdToHALString = function convertAttributeIdToHALString(
    e,
    t
  ) {
    return (
      (t
        ? [
            'Diving',
            'Handling',
            'Kicking',
            'Reflex',
            'Speed',
            'Position',
            'All'
          ]
        : [
            'Pace',
            'Shooting',
            'Passing',
            'Dribbling',
            'Defend',
            'Heading',
            'All'
          ])[e] || ''
    );
  }),
  (utils.FUTLocalization.getStaffAttributeAbbr = function getStaffAttributeAbbr(
    e,
    t
  ) {
    var i = '';
    switch (e) {
      case enums.ItemType.HEAD_COACH:
        i = services.Localization.localize(
          [
            'cards.cardfront.paceAbbr',
            'cards.cardfront.shootingAbbr',
            'cards.cardfront.passingAbbr',
            'cards.cardfront.dribblingAbbr',
            'cards.cardfront.defendingAbbr',
            'cards.cardfront.headingAbbr'
          ][t]
        );
        break;
      case enums.ItemType.GK_COACH:
        i = services.Localization.localize(
          [
            'cards.cardfront.divingAbbr',
            'cards.cardfront.handlingAbbr',
            'cards.cardfront.kickAbbr',
            'cards.cardfront.reflexAbbr',
            'cards.cardfront.speedAbbr',
            'cards.cardfront.positionAbbr'
          ][t]
        );
        break;
      case enums.ItemType.PHYSIO:
        i = services.Localization.localize(
          [
            'physiocoach.head.abbr',
            'physiocoach.shoulder.abbr',
            'physiocoach.arm.abbr',
            'physiocoach.back.abbr',
            'physiocoach.hip.abbr',
            'physiocoach.leg.abbr',
            'physiocoach.foot.abbr'
          ][t]
        );
        break;
      case enums.ItemType.FITNESS_COACH:
        i = services.Localization.localize('fitnesscoach.fitness.abbr');
        break;
      default:
        window.console.log(
          '[FUTLocalization] getStaffAttributeAbbr() reached default state = ' +
            e
        );
    }
    return i;
  }),
  (utils.FUTLocalization.getLocalizedPositionStringByName = function getLocalizedPositionStringByName(
    e
  ) {
    var t = repositories.Squad.getPositionByUniqueName(e);
    return t
      ? services.Localization.localize(
          'extendedPlayerInfo.positions.position' + t.getId().toString()
        )
      : '';
  }),
  (utils.FUTLocalization.getLocalizedPositionStringById = function getLocalizedPositionStringById(
    e
  ) {
    var t = repositories.Squad.getPosition(e);
    return t
      ? services.Localization.localize(
          'extendedPlayerInfo.positions.position' + t.getId().toString()
        )
      : '';
  }),
  (utils.FUTLocalization.getSaveTechniqueString = function getSaveTechniqueString(
    e
  ) {
    return 0 < e
      ? services.Localization.localize(
          'extendedPlayerInfo.saveTechnique.acrobatic'
        )
      : services.Localization.localize(
          'extendedPlayerInfo.saveTechnique.traditional'
        );
  }),
  (utils.FUTLocalization.convertInjuryTypeToText = function convertInjuryTypeToText(
    e
  ) {
    switch (e) {
      case enums.PlayerInjury.NONE:
        return '';
      case enums.PlayerInjury.HEAD:
        return services.Localization.localize('card.desc.healing.head');
      case enums.PlayerInjury.SHOULDER:
        return services.Localization.localize('card.desc.healing.shoulder');
      case enums.PlayerInjury.ARM:
        return services.Localization.localize('card.desc.healing.arm');
      case enums.PlayerInjury.BACK:
        return services.Localization.localize('card.desc.healing.back');
      case enums.PlayerInjury.HIP:
        return services.Localization.localize('card.desc.healing.hip');
      case enums.PlayerInjury.LEG:
        return services.Localization.localize('card.desc.healing.leg');
      case enums.PlayerInjury.FOOT:
        return services.Localization.localize('card.desc.healing.foot');
    }
    return (
      utils.Debug.Assert(
        !1,
        '[FUT Localization - convertInjuryTypeToText] - invalid injuryType: ' +
          e
      ),
      ''
    );
  }),
  NamespaceManager.Register('components'),
  (components.ListDataHealing = function() {
    (this._comparisonData = null), this._generate();
  }),
  (components.ListDataHealing.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      (this.__label = document.createElement('span')),
        e.appendChild(this.__label),
        (this.__delta = document.createElement('span')),
        this.__delta.classList.add('statIncrease'),
        e.appendChild(this.__delta),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ListDataHealing.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__label = null),
      (this.__delta = null);
  }),
  (components.ListDataHealing.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ListDataHealing.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ListDataHealing.prototype.init = function init() {}),
  (components.ListDataHealing.prototype.destroy = function destroy() {
    (this._comparisonData = null), this.destroyGeneratedElements();
  }),
  (components.ListDataHealing.prototype.render = function render(e) {
    if (
      ((this.__label.textContent = services.Localization.localize(
        'listdata.injury',
        [
          utils.FUTLocalization.convertInjuryTypeToText(e.injuryType),
          e.injuryGames
        ]
      )),
      utils.JS.isValid(this._comparisonData) &&
        this._comparisonData.isInjuryHealing())
    ) {
      var t = this._comparisonData.getStaticData(),
        i = e.injuryGames - (t.amount < 0 ? e.injuryGames : t.amount);
      this.__delta.textContent = ' -' + i;
    }
  }),
  (components.ListDataHealing.prototype.setComparisonData = function setComparisonData(
    e
  ) {
    this._comparisonData = e;
  }),
  (components.ListDataHealing.prototype.update = function update(e) {}),
  NamespaceManager.Register('components'),
  (components.ListDataManagerLeague = function() {
    (this._comparisonData = null), this._generate();
  }),
  (components.ListDataManagerLeague.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      (this.__label = document.createElement('span')),
        e.appendChild(this.__label),
        (this.__delta = document.createElement('span')),
        this.__delta.classList.add('statIncrease'),
        e.appendChild(this.__delta),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (components.ListDataManagerLeague.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__label = null),
      (this.__delta = null);
  }),
  (components.ListDataManagerLeague.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (components.ListDataManagerLeague.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (components.ListDataManagerLeague.prototype.init = function init() {}),
  (components.ListDataManagerLeague.prototype.destroy = function destroy() {
    (this._comparisonData = null), this.destroyGeneratedElements();
  }),
  (components.ListDataManagerLeague.prototype.render = function render(e) {
    var t = utils.FUTLocalization.getLeagueNameByID(e.leagueId);
    if (
      ((this.__label.textContent = services.Localization.localize(
        'listdata.change',
        [t]
      )),
      utils.JS.isValid(this._comparisonData) &&
        this._comparisonData.isManagerLeagueModifier())
    ) {
      var i = this._comparisonData.getStaticData(),
        s = utils.FUTLocalization.getLeagueNameByID(i.amount);
      this.__delta.textContent = ' ' + s;
    }
  }),
  (components.ListDataManagerLeague.prototype.setComparisonData = function setComparisonData(
    e
  ) {
    this._comparisonData = e;
  }),
  (components.ListDataManagerLeague.prototype.update = function update(e) {}),
  utils.JS.inherits(UTListActiveTagView, UTView),
  (UTListActiveTagView.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('div');
      e.classList.add('active-tag');
      var t = document.createElement('div');
      t.classList.add('label-container'),
        (this.__activeTagIcon = document.createElement('span')),
        this.__activeTagIcon.classList.add('fut_icon'),
        t.appendChild(this.__activeTagIcon),
        (this.__tagName = document.createElement('span')),
        this.__tagName.classList.add('label'),
        t.appendChild(this.__tagName),
        e.appendChild(t),
        (this.__root = e),
        (this._generated = !0);
    }
  }),
  (UTListActiveTagView.prototype.destroyGeneratedElements = function destroyGeneratedElements() {
    $(this.__root)
      .off()
      .remove(),
      (this.__root = null),
      (this.__activeTagIcon = null),
      (this.__tagName = null);
  }),
  (UTListActiveTagView.prototype.getRoot = function getRoot() {
    return $(this.__root);
  }),
  (UTListActiveTagView.prototype.getRootElement = function getRootElement() {
    return this.__root;
  }),
  (UTListActiveTagView.prototype.render = function render() {
    this.__tagName.textContent = this._string;
  }),
  (UTListActiveTagView.prototype.setString = function setString(e) {
    this._string = e;
  }),
  (UTListActiveTagView.prototype.getString = function getString() {
    return this._string;
  }),
  (UTListActiveTagView.prototype.setIconClass = function setIconClass(e) {
    DOMKit.removeClass(this.__activeTagIcon, this._iconClass),
      DOMKit.addClass(this.__activeTagIcon, e),
      (this._iconClass = e);
  }),
  NamespaceManager.Register('components'),
  (components.ListRowItem = function ItemListRowView() {
    UTTargetActionView.call(this),
      (this.slotData = null),
      (this.comparisonData = null),
      (this.data = null),
      (this._viewDirty = !0),
      (this._dataComponent = null),
      (this._activeTagComponent = null),
      (this._itemComponent = null),
      (this._hasAction = !1),
      (this._tapCallback = null),
      (this._renderMode = enums.UIListItemPriority.DEFAULT),
      this._generate();
  }),
  utils.JS.inherits(components.ListRowItem, UTTargetActionView),
  (components.ListRowItem.prototype._generate = function _generate() {
    if (!this._generated) {
      var e = document.createElement('li');
      e.classList.add('listFUTItem'),
        (this._btnAction = new UTImageButtonControl()),
        this._btnAction.getRootElement().classList.add('btnAction'),
        e.appendChild(this._btnAction.getRootElement()),
        (this.__rowContent = document.createElement('div')),
        this.__rowContent.classList.add('rowContent'),
        (this.__entityContainer = document.createElement('div')),
        this.__entityContainer.classList.add('entityContainer'),
        (this.__name = document.createElement('div')),
        this.__name.classList.add('name'),
        this.__entityContainer.appendChild(this.__name),
        this.__rowContent.appendChild(this.__entityContainer),
        (this.__auction = document.createElement('div')),
        this.__auction.classList.add('auction');
      var t = document.createElement('div');
      t.classList.add('auctionStartPrice'),
        t.classList.add('auctionValue'),
        (this.__auctionStartLabel = document.createElement('span')),
        this.__auctionStartLabel.classList.add('label'),
        t.appendChild(this.__auctionStartLabel),
        (this.__auctionStartValue = document.createElement('span')),
        this.__auctionStartValue.classList.add('currency-coins'),
        this.__auctionStartValue.classList.add('value'),
        t.appendChild(this.__auctionStartValue),
        this.__auction.appendChild(t);
      var i = document.createElement('div');
      i.classList.add('auctionValue'),
        (this.__auctionBidLabel = document.createElement('span')),
        this.__auctionBidLabel.classList.add('label'),
        i.appendChild(this.__auctionBidLabel),
        (this.