package hu.advancedweb.scott.instrumentation.transformation;

/**
 * Metadata of a field accessed by a test case.
 * 
 * @author David Csakvari
 */
class AccessedField {
	
	final String owner;
	final String name;
	final String desc;
	final boolean isStatic;
	
	public AccessedField(String owner, String name, String desc, boolean isStatic) {
		this.owner = owner;
		this.name = name;
		this.desc = desc;
		this.isStatic = isStatic;
	}

	@Override
	public String toString() {
		return "AccessedField [owner=" + owner + ", name=" + name + ", desc=" + desc + ", isStatic=" + isStatic + "]";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((desc == null) ? 0 : desc.hashCode());
		result = prime * result + (isStatic ? 1231 : 1237);
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result + ((owner == null) ? 0 : owner.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AccessedField other = (AccessedField) obj;
		if (desc == null) {
			if (other.desc != null)
				return false;
		} else if (!desc.equals(other.desc))
			return false;
		if (isStatic != other.isStatic)
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (owner == null) {
			if (other.owner != null)
				return false;
		} else if (!owner.equals(other.owner))
			return false;
		return true;
	}
	
}
