/*
  Dokan : user-mode file system library for Windows

  Copyright (C) 2015 - 2016 Adrien J. <liryna.stark@gmail.com> and Maxime C. <maxime@islog.com>
  Copyright (C) 2007 - 2011 Hiroki Asakawa <info@dokan-dev.net>

  http://dokan-dev.github.io

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#define WIN32_NO_STATUS
#include <windows.h>
#undef WIN32_NO_STATUS
#include "dokan.h"
#include "fileinfo.h"
#include <malloc.h>
#include <ntstatus.h>
#include <stdio.h>
#include <stdlib.h>
#include <winbase.h>

static NTSTATUS DOKAN_CALLBACK
MyDokanFSCreateFile(LPCWSTR FileName, PDOKAN_IO_SECURITY_CONTEXT SecurityContext,
                 ACCESS_MASK DesiredAccess, ULONG FileAttributes,
                 ULONG ShareAccess, ULONG CreateDisposition,
                 ULONG CreateOptions, PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(SecurityContext);
  UNREFERENCED_PARAMETER(DesiredAccess);
  UNREFERENCED_PARAMETER(FileAttributes);
  UNREFERENCED_PARAMETER(ShareAccess);
  UNREFERENCED_PARAMETER(CreateDisposition);
  UNREFERENCED_PARAMETER(CreateOptions);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static void DOKAN_CALLBACK MyDokanFSCloseFile(LPCWSTR FileName,
                                           PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(DokanFileInfo);
}

static void DOKAN_CALLBACK MyDokanFSCleanup(LPCWSTR FileName,
                                         PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(DokanFileInfo);
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSReadFile(LPCWSTR FileName, LPVOID Buffer,
                                              DWORD BufferLength,
                                              LPDWORD ReadLength,
                                              LONGLONG Offset,
                                              PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(Buffer);
  UNREFERENCED_PARAMETER(BufferLength);
  UNREFERENCED_PARAMETER(ReadLength);
  UNREFERENCED_PARAMETER(Offset);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSWriteFile(LPCWSTR FileName, LPCVOID Buffer,
                                               DWORD NumberOfBytesToWrite,
                                               LPDWORD NumberOfBytesWritten,
                                               LONGLONG Offset,
                                               PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(Buffer);
  UNREFERENCED_PARAMETER(NumberOfBytesToWrite);
  UNREFERENCED_PARAMETER(NumberOfBytesWritten);
  UNREFERENCED_PARAMETER(Offset);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK
MyDokanFSFlushFileBuffers(LPCWSTR FileName, PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSGetFileInformation(
    LPCWSTR FileName, LPBY_HANDLE_FILE_INFORMATION HandleFileInformation,
    PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(HandleFileInformation);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK
MyDokanFSFindFiles(LPCWSTR FileName,
                PFillFindData FillFindData, // function pointer
                PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(FillFindData);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK
MyDokanFSDeleteFile(LPCWSTR FileName, PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK
MyDokanFSDeleteDirectory(LPCWSTR FileName, PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK
MyDokanFSMoveFile(LPCWSTR FileName, // existing file name
               LPCWSTR NewFileName, BOOL ReplaceIfExisting,
               PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(NewFileName);
  UNREFERENCED_PARAMETER(ReplaceIfExisting);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSLockFile(LPCWSTR FileName,
                                              LONGLONG ByteOffset,
                                              LONGLONG Length,
                                              PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(ByteOffset);
  UNREFERENCED_PARAMETER(Length);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSSetEndOfFile(
    LPCWSTR FileName, LONGLONG ByteOffset, PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(ByteOffset);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSSetAllocationSize(
    LPCWSTR FileName, LONGLONG AllocSize, PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(AllocSize);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSSetFileAttributes(
    LPCWSTR FileName, DWORD FileAttributes, PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(FileAttributes);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK
MyDokanFSSetFileTime(LPCWSTR FileName, CONST FILETIME *CreationTime,
                  CONST FILETIME *LastAccessTime, CONST FILETIME *LastWriteTime,
                  PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(CreationTime);
  UNREFERENCED_PARAMETER(LastAccessTime);
  UNREFERENCED_PARAMETER(LastWriteTime);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK
MyDokanFSUnlockFile(LPCWSTR FileName, LONGLONG ByteOffset, LONGLONG Length,
                 PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(ByteOffset);
  UNREFERENCED_PARAMETER(Length);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSGetFileSecurity(
    LPCWSTR FileName, PSECURITY_INFORMATION SecurityInformation,
    PSECURITY_DESCRIPTOR SecurityDescriptor, ULONG BufferLength,
    PULONG LengthNeeded, PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(SecurityInformation);
  UNREFERENCED_PARAMETER(SecurityDescriptor);
  UNREFERENCED_PARAMETER(BufferLength);
  UNREFERENCED_PARAMETER(LengthNeeded);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSSetFileSecurity(
    LPCWSTR FileName, PSECURITY_INFORMATION SecurityInformation,
    PSECURITY_DESCRIPTOR SecurityDescriptor, ULONG SecurityDescriptorLength,
    PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(SecurityInformation);
  UNREFERENCED_PARAMETER(SecurityDescriptor);
  UNREFERENCED_PARAMETER(SecurityDescriptorLength);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSGetVolumeInformation(
    LPWSTR VolumeNameBuffer, DWORD VolumeNameSize, LPDWORD VolumeSerialNumber,
    LPDWORD MaximumComponentLength, LPDWORD FileSystemFlags,
    LPWSTR FileSystemNameBuffer, DWORD FileSystemNameSize,
    PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(DokanFileInfo);

  wcscpy_s(VolumeNameBuffer, VolumeNameSize, L"DOKAN");
  *VolumeSerialNumber = 0x19831116;
  *MaximumComponentLength = 256;
  *FileSystemFlags = FILE_CASE_SENSITIVE_SEARCH | FILE_CASE_PRESERVED_NAMES |
                     FILE_SUPPORTS_REMOTE_STORAGE | FILE_UNICODE_ON_DISK |
                     FILE_PERSISTENT_ACLS;

  // File system name could be anything up to 10 characters.
  // But Windows check few feature availability based on file system name.
  // For this, it is recommended to set NTFS or FAT here.
  wcscpy_s(FileSystemNameBuffer, FileSystemNameSize, L"NTFS");

  return STATUS_SUCCESS;
}

NTSTATUS DOKAN_CALLBACK
MyDokanFSFindStreams(LPCWSTR FileName, PFillFindStreamData FillFindStreamData,
                  PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(FileName);
  UNREFERENCED_PARAMETER(FillFindStreamData);
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_NOT_IMPLEMENTED;
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSMounted(PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_SUCCESS;
}

static NTSTATUS DOKAN_CALLBACK MyDokanFSUnmounted(PDOKAN_FILE_INFO DokanFileInfo) {
  UNREFERENCED_PARAMETER(DokanFileInfo);

  return STATUS_SUCCESS;
}

int __cdecl wmain(ULONG argc, PWCHAR argv[]) {
  int status;

  PDOKAN_OPERATIONS dokanOperations =
      (PDOKAN_OPERATIONS)malloc(sizeof(DOKAN_OPERATIONS));
  if (dokanOperations == NULL) {
    return EXIT_FAILURE;
  }
  PDOKAN_OPTIONS dokanOptions = (PDOKAN_OPTIONS)malloc(sizeof(DOKAN_OPTIONS));
  if (dokanOptions == NULL) {
    free(dokanOperations);
    return EXIT_FAILURE;
  }

  UNREFERENCED_PARAMETER(argc);
  UNREFERENCED_PARAMETER(argv);

  ZeroMemory(dokanOptions, sizeof(DOKAN_OPTIONS));
  dokanOptions->Version = DOKAN_VERSION;
  dokanOptions->ThreadCount = 0; // use default

  dokanOptions->Options |= DOKAN_OPTION_MOUNT_MANAGER; // Use mount manager
  dokanOptions->Options |= DOKAN_OPTION_ALT_STREAM; // Implements alternative streams

  ZeroMemory(dokanOperations, sizeof(DOKAN_OPERATIONS));
  dokanOperations->ZwCreateFile = MyDokanFSCreateFile;
  dokanOperations->Cleanup = MyDokanFSCleanup;
  dokanOperations->CloseFile = MyDokanFSCloseFile;
  dokanOperations->ReadFile = MyDokanFSReadFile;
  dokanOperations->WriteFile = MyDokanFSWriteFile;
  dokanOperations->FlushFileBuffers = MyDokanFSFlushFileBuffers;
  dokanOperations->GetFileInformation = MyDokanFSGetFileInformation;
  dokanOperations->FindFiles = MyDokanFSFindFiles;
  dokanOperations->FindFilesWithPattern = NULL;
  dokanOperations->SetFileAttributes = MyDokanFSSetFileAttributes;
  dokanOperations->SetFileTime = MyDokanFSSetFileTime;
  dokanOperations->DeleteFile = MyDokanFSDeleteFile;
  dokanOperations->DeleteDirectory = MyDokanFSDeleteDirectory;
  dokanOperations->MoveFile = MyDokanFSMoveFile;
  dokanOperations->SetEndOfFile = MyDokanFSSetEndOfFile;
  dokanOperations->SetAllocationSize = MyDokanFSSetAllocationSize;
  dokanOperations->LockFile = MyDokanFSLockFile;
  dokanOperations->UnlockFile = MyDokanFSUnlockFile;
  dokanOperations->GetFileSecurity = MyDokanFSGetFileSecurity;
  dokanOperations->SetFileSecurity = MyDokanFSSetFileSecurity;
  dokanOperations->GetDiskFreeSpace = NULL;
  dokanOperations->GetVolumeInformation = MyDokanFSGetVolumeInformation;
  dokanOperations->Unmounted = MyDokanFSUnmounted;
  dokanOperations->FindStreams = MyDokanFSFindStreams;
  dokanOperations->Mounted = MyDokanFSMounted;

  status = DokanMain(dokanOptions, dokanOperations);
  switch (status) {
  case DOKAN_SUCCESS:
    fprintf(stderr, "Success\n");
    break;
  case DOKAN_ERROR:
    fprintf(stderr, "Error\n");
    break;
  case DOKAN_DRIVE_LETTER_ERROR:
    fprintf(stderr, "Bad Drive letter\n");
    break;
  case DOKAN_DRIVER_INSTALL_ERROR:
    fprintf(stderr, "Can't install driver\n");
    break;
  case DOKAN_START_ERROR:
    fprintf(stderr, "Driver something wrong\n");
    break;
  case DOKAN_MOUNT_ERROR:
    fprintf(stderr, "Can't assign a drive letter\n");
    break;
  case DOKAN_MOUNT_POINT_ERROR:
    fprintf(stderr, "Mount point error\n");
    break;
  case DOKAN_VERSION_ERROR:
    fprintf(stderr, "Version error\n");
    break;
  default:
    fprintf(stderr, "Unknown error: %d\n", status);
    break;
  }

  free(dokanOptions);
  free(dokanOperations);
  return EXIT_SUCCESS;
}
