using System.Diagnostics.Tracing;

namespace DotNext.Net.Cluster.Consensus.Raft.Http;

using IClientMetricsCollector = Metrics.IClientMetricsCollector;

/// <summary>
/// Contains a set of callbacks that can be used to report
/// runtime metrics generated by HTTP-specific implementation of Raft cluster node.
/// </summary>
/// <remarks>
/// You need to register singleton service of type <see cref="MetricsCollector"/>
/// to collect metrics produced by Raft node.
/// </remarks>
[Obsolete("Use System.Diagnostics.Metrics infrastructure instead.", UrlFormat = "https://learn.microsoft.com/en-us/dotnet/core/diagnostics/metrics")]
public class HttpMetricsCollector : MetricsCollector, IClientMetricsCollector
{
    /// <inheritdoc cref="IClientMetricsCollector.ReportResponseTime(TimeSpan)"/>
    public virtual void ReportResponseTime(TimeSpan value)
    {
    }

    /// <inheritdoc/>
    void IClientMetricsCollector.ReportResponseTime(TimeSpan value)
    {
        ResponseTimeCounter?.WriteMetric(value.TotalMilliseconds);
        ReportResponseTime(value);
    }

    /// <summary>
    /// Gets or sets counter that allows to count response time from every cluster node.
    /// </summary>
    public EventCounter? ResponseTimeCounter
    {
        get;
        set;
    }
}