# Community Guidelines

Adapted from [the Expo Community Guidelines](https://expo.dev/guidelines).

## Our Pledge

In the interest of fostering an open and welcoming environment, we pledge to making participation in our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience or education, nationality, personal appearance, race, religion, sexual identity and orientation, or any other such characteristic.

We expect to revise this document over time, and as such situations which present new questions may result in additional future guidelines or rules, which we will include in this document.

### Our Standards for Community Conduct

The vast majority of participants in our community already adhere to these guidelines. If you find yourself asking whether behavior you're engaging in is acceptable by these guidelines, we encourage you to first ask yourself whether this behavior would be appropriate in the workplace or at a social gathering with mixed company. These guidelines are significantly more limited in what they prohibit than what is typically considered unacceptable behavior in offline social settings. We also don't expect to be able to preemptively define all acceptable or unacceptable behavior.

Our primary guideline for acceptable community interactions is that they show empathy towards other community members. Some examples of working towards a positive, empathic environment include:

- Using welcoming and inclusive language
- Being respectful of differing viewpoints and experiences
- Providing criticism in a constructive, actionable format
- Gracefully accepting criticism
- Focusing on what is best for the community

Our primary guideline for unacceptable community interactions is that they engage in conduct which could reasonably be considered inappropriate in a professional setting. Some specific examples of this include:

- The use of sexualized language or imagery and unwelcome sexual attention or advances
- Trolling, insulting/derogatory comments, and personal or political attacks
- Public or private harassment
- Publishing others' private information, such as a physical or electronic address, without explicit permission

### Our Standards for Content Hosted by Expo

In addition to providing an environment for developers to learn, collaborate, and share with each other, Expo also provides a service for hosting your projects. We apply a slightly different set of standards to projects hosted on our service. At a minimum, your projects should respect:

- Apple's "Safety" and "Intellectual Property" criteria from the [App Store Review Guidelines](https://developer.apple.com/app-store/review/guidelines/)
- Google's "Restricted Content" and "Intellectual Property, Deception, and Spam" criteria from the [Play Store Developer Content Policy](https://play.google.com/about/developer-content-policy/)

### Our Responsibilities

Community moderators are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Community moderators have the right and responsibility to remove, edit, or reject comments, commits, code, forum posts, issues, and other contributions that are not aligned with these guidelines, or to temporarily or permanently ban any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

### Scope

The standards of conduct apply in any portion of the Expo developer community, including but not limited to the Expo developer forums, Discord servers, GitHub repositories, or the feature request board.

The standards for content apply to projects published to Expo's services, as well as to content sent through Expo's servers (e.g. push notifications).

### Reporting Violations

Because of the volume of activity in Expo's community and the number of projects published, we rely on reports from our community members to take action on infringing members and projects.

Instances of abusive, harassing, or otherwise unacceptable behavior or content may be [reported by](https://expo.dev/contact) contacting us. All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. We will make every reasonable effort to maintain the confidentiality of the reporter. Further details of specific enforcement policies may be posted separately.
