---
title: Drawer
---

To use [drawer navigator](https://reactnavigation.org/docs/drawer-based-navigation) you'll need to install some extra dependencies.

```bash
npx expo install @react-navigation/drawer react-native-gesture-handler react-native-reanimated
```

Next you'll need to update your `babel.config.js` to include the reanimated plugin.

```js title=babel.config.js
module.exports = {
    presets: [
        ...
    ],
    plugins: [
        ...
        'react-native-reanimated/plugin',
    ],
};
```

> After changing your `babel.config.js`, clear the babel cache `npx expo start --clear`

Now you can use the `Drawer` layout to create a drawer navigator:

```js
import { Drawer } from "expo-router/drawer";

export default function Layout() {
  return <Drawer />;
}
```
