/*
 * Copyright (c) 2017 Nam Nguyen, nam@ene.im
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package im.ene.toro.sample.complex;

import android.os.Bundle;
import im.ene.toro.sample.Deck;
import im.ene.toro.sample.common.BaseActivity;

/**
 * @author eneim (7/2/17).
 */

public class ComplexListActivity extends BaseActivity {

  @Override protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    if (savedInstanceState == null) {
      try {
        Deck.present(this, ComplexListFragment.class);
      } catch (Deck.ToroDemoException e) {
        e.printStackTrace();
        if (e.getCause() != null) e.getCause().printStackTrace();
      }
    }
  }
}
