// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package blob

import (
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/google/uuid"
)

const (
	// Label holds the string label denoting the blob type in the database.
	Label = "blob"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldUUID holds the string denoting the uuid field in the database.
	FieldUUID = "uuid"
	// FieldCount holds the string denoting the count field in the database.
	FieldCount = "count"
	// EdgeParent holds the string denoting the parent edge name in mutations.
	EdgeParent = "parent"
	// EdgeLinks holds the string denoting the links edge name in mutations.
	EdgeLinks = "links"
	// EdgeBlobLinks holds the string denoting the blob_links edge name in mutations.
	EdgeBlobLinks = "blob_links"
	// Table holds the table name of the blob in the database.
	Table = "blobs"
	// ParentTable is the table that holds the parent relation/edge.
	ParentTable = "blobs"
	// ParentColumn is the table column denoting the parent relation/edge.
	ParentColumn = "blob_parent"
	// LinksTable is the table that holds the links relation/edge. The primary key declared below.
	LinksTable = "blob_links"
	// BlobLinksTable is the table that holds the blob_links relation/edge.
	BlobLinksTable = "blob_links"
	// BlobLinksInverseTable is the table name for the BlobLink entity.
	// It exists in this package in order to avoid circular dependency with the "bloblink" package.
	BlobLinksInverseTable = "blob_links"
	// BlobLinksColumn is the table column denoting the blob_links relation/edge.
	BlobLinksColumn = "blob_id"
)

// Columns holds all SQL columns for blob fields.
var Columns = []string{
	FieldID,
	FieldUUID,
	FieldCount,
}

// ForeignKeys holds the SQL foreign-keys that are owned by the "blobs"
// table and are not defined as standalone fields in the schema.
var ForeignKeys = []string{
	"blob_parent",
}

var (
	// LinksPrimaryKey and LinksColumn2 are the table columns denoting the
	// primary key for the links relation (M2M).
	LinksPrimaryKey = []string{"blob_id", "link_id"}
)

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	for i := range ForeignKeys {
		if column == ForeignKeys[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultUUID holds the default value on creation for the "uuid" field.
	DefaultUUID func() uuid.UUID
	// DefaultCount holds the default value on creation for the "count" field.
	DefaultCount int
	// DefaultID holds the default value on creation for the "id" field.
	DefaultID func() uuid.UUID
)

// OrderOption defines the ordering options for the Blob queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByUUID orders the results by the uuid field.
func ByUUID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUUID, opts...).ToFunc()
}

// ByCount orders the results by the count field.
func ByCount(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCount, opts...).ToFunc()
}

// ByParentField orders the results by parent field.
func ByParentField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newParentStep(), sql.OrderByField(field, opts...))
	}
}

// ByLinksCount orders the results by links count.
func ByLinksCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newLinksStep(), opts...)
	}
}

// ByLinks orders the results by links terms.
func ByLinks(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newLinksStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// ByBlobLinksCount orders the results by blob_links count.
func ByBlobLinksCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newBlobLinksStep(), opts...)
	}
}

// ByBlobLinks orders the results by blob_links terms.
func ByBlobLinks(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newBlobLinksStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newParentStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(Table, FieldID),
		sqlgraph.Edge(sqlgraph.O2O, false, ParentTable, ParentColumn),
	)
}
func newLinksStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(Table, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, false, LinksTable, LinksPrimaryKey...),
	)
}
func newBlobLinksStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(BlobLinksInverseTable, BlobLinksColumn),
		sqlgraph.Edge(sqlgraph.O2M, true, BlobLinksTable, BlobLinksColumn),
	)
}
