// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package bloblink

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the bloblink type in the database.
	Label = "blob_link"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldBlobID holds the string denoting the blob_id field in the database.
	FieldBlobID = "blob_id"
	// FieldLinkID holds the string denoting the link_id field in the database.
	FieldLinkID = "link_id"
	// EdgeBlob holds the string denoting the blob edge name in mutations.
	EdgeBlob = "blob"
	// EdgeLink holds the string denoting the link edge name in mutations.
	EdgeLink = "link"
	// BlobFieldID holds the string denoting the ID field of the Blob.
	BlobFieldID = "id"
	// Table holds the table name of the bloblink in the database.
	Table = "blob_links"
	// BlobTable is the table that holds the blob relation/edge.
	BlobTable = "blob_links"
	// BlobInverseTable is the table name for the Blob entity.
	// It exists in this package in order to avoid circular dependency with the "blob" package.
	BlobInverseTable = "blobs"
	// BlobColumn is the table column denoting the blob relation/edge.
	BlobColumn = "blob_id"
	// LinkTable is the table that holds the link relation/edge.
	LinkTable = "blob_links"
	// LinkInverseTable is the table name for the Blob entity.
	// It exists in this package in order to avoid circular dependency with the "blob" package.
	LinkInverseTable = "blobs"
	// LinkColumn is the table column denoting the link relation/edge.
	LinkColumn = "link_id"
)

// Columns holds all SQL columns for bloblink fields.
var Columns = []string{
	FieldCreatedAt,
	FieldBlobID,
	FieldLinkID,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
)

// OrderOption defines the ordering options for the BlobLink queries.
type OrderOption func(*sql.Selector)

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByBlobID orders the results by the blob_id field.
func ByBlobID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldBlobID, opts...).ToFunc()
}

// ByLinkID orders the results by the link_id field.
func ByLinkID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldLinkID, opts...).ToFunc()
}

// ByBlobField orders the results by blob field.
func ByBlobField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newBlobStep(), sql.OrderByField(field, opts...))
	}
}

// ByLinkField orders the results by link field.
func ByLinkField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newLinkStep(), sql.OrderByField(field, opts...))
	}
}
func newBlobStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, BlobColumn),
		sqlgraph.To(BlobInverseTable, BlobFieldID),
		sqlgraph.Edge(sqlgraph.M2O, false, BlobTable, BlobColumn),
	)
}
func newLinkStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, LinkColumn),
		sqlgraph.To(LinkInverseTable, BlobFieldID),
		sqlgraph.Edge(sqlgraph.M2O, false, LinkTable, LinkColumn),
	)
}
