// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/customid/ent/blob"
	"entgo.io/ent/entc/integration/customid/ent/bloblink"
	"entgo.io/ent/entc/integration/customid/ent/predicate"
	"github.com/google/uuid"
)

// BlobLinkQuery is the builder for querying BlobLink entities.
type BlobLinkQuery struct {
	config
	ctx        *QueryContext
	order      []bloblink.OrderOption
	inters     []Interceptor
	predicates []predicate.BlobLink
	withBlob   *BlobQuery
	withLink   *BlobQuery
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the BlobLinkQuery builder.
func (blq *BlobLinkQuery) Where(ps ...predicate.BlobLink) *BlobLinkQuery {
	blq.predicates = append(blq.predicates, ps...)
	return blq
}

// Limit the number of records to be returned by this query.
func (blq *BlobLinkQuery) Limit(limit int) *BlobLinkQuery {
	blq.ctx.Limit = &limit
	return blq
}

// Offset to start from.
func (blq *BlobLinkQuery) Offset(offset int) *BlobLinkQuery {
	blq.ctx.Offset = &offset
	return blq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (blq *BlobLinkQuery) Unique(unique bool) *BlobLinkQuery {
	blq.ctx.Unique = &unique
	return blq
}

// Order specifies how the records should be ordered.
func (blq *BlobLinkQuery) Order(o ...bloblink.OrderOption) *BlobLinkQuery {
	blq.order = append(blq.order, o...)
	return blq
}

// QueryBlob chains the current query on the "blob" edge.
func (blq *BlobLinkQuery) QueryBlob() *BlobQuery {
	query := (&BlobClient{config: blq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := blq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := blq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(bloblink.Table, bloblink.BlobColumn, selector),
			sqlgraph.To(blob.Table, blob.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, bloblink.BlobTable, bloblink.BlobColumn),
		)
		fromU = sqlgraph.SetNeighbors(blq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// QueryLink chains the current query on the "link" edge.
func (blq *BlobLinkQuery) QueryLink() *BlobQuery {
	query := (&BlobClient{config: blq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := blq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := blq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(bloblink.Table, bloblink.LinkColumn, selector),
			sqlgraph.To(blob.Table, blob.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, bloblink.LinkTable, bloblink.LinkColumn),
		)
		fromU = sqlgraph.SetNeighbors(blq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first BlobLink entity from the query.
// Returns a *NotFoundError when no BlobLink was found.
func (blq *BlobLinkQuery) First(ctx context.Context) (*BlobLink, error) {
	nodes, err := blq.Limit(1).All(setContextOp(ctx, blq.ctx, "First"))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{bloblink.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (blq *BlobLinkQuery) FirstX(ctx context.Context) *BlobLink {
	node, err := blq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// Only returns a single BlobLink entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one BlobLink entity is found.
// Returns a *NotFoundError when no BlobLink entities are found.
func (blq *BlobLinkQuery) Only(ctx context.Context) (*BlobLink, error) {
	nodes, err := blq.Limit(2).All(setContextOp(ctx, blq.ctx, "Only"))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{bloblink.Label}
	default:
		return nil, &NotSingularError{bloblink.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (blq *BlobLinkQuery) OnlyX(ctx context.Context) *BlobLink {
	node, err := blq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// All executes the query and returns a list of BlobLinks.
func (blq *BlobLinkQuery) All(ctx context.Context) ([]*BlobLink, error) {
	ctx = setContextOp(ctx, blq.ctx, "All")
	if err := blq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*BlobLink, *BlobLinkQuery]()
	return withInterceptors[[]*BlobLink](ctx, blq, qr, blq.inters)
}

// AllX is like All, but panics if an error occurs.
func (blq *BlobLinkQuery) AllX(ctx context.Context) []*BlobLink {
	nodes, err := blq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// Count returns the count of the given query.
func (blq *BlobLinkQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, blq.ctx, "Count")
	if err := blq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, blq, querierCount[*BlobLinkQuery](), blq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (blq *BlobLinkQuery) CountX(ctx context.Context) int {
	count, err := blq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (blq *BlobLinkQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, blq.ctx, "Exist")
	switch _, err := blq.First(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("ent: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (blq *BlobLinkQuery) ExistX(ctx context.Context) bool {
	exist, err := blq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the BlobLinkQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (blq *BlobLinkQuery) Clone() *BlobLinkQuery {
	if blq == nil {
		return nil
	}
	return &BlobLinkQuery{
		config:     blq.config,
		ctx:        blq.ctx.Clone(),
		order:      append([]bloblink.OrderOption{}, blq.order...),
		inters:     append([]Interceptor{}, blq.inters...),
		predicates: append([]predicate.BlobLink{}, blq.predicates...),
		withBlob:   blq.withBlob.Clone(),
		withLink:   blq.withLink.Clone(),
		// clone intermediate query.
		sql:  blq.sql.Clone(),
		path: blq.path,
	}
}

// WithBlob tells the query-builder to eager-load the nodes that are connected to
// the "blob" edge. The optional arguments are used to configure the query builder of the edge.
func (blq *BlobLinkQuery) WithBlob(opts ...func(*BlobQuery)) *BlobLinkQuery {
	query := (&BlobClient{config: blq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	blq.withBlob = query
	return blq
}

// WithLink tells the query-builder to eager-load the nodes that are connected to
// the "link" edge. The optional arguments are used to configure the query builder of the edge.
func (blq *BlobLinkQuery) WithLink(opts ...func(*BlobQuery)) *BlobLinkQuery {
	query := (&BlobClient{config: blq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	blq.withLink = query
	return blq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		CreatedAt time.Time `json:"created_at,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.BlobLink.Query().
//		GroupBy(bloblink.FieldCreatedAt).
//		Aggregate(ent.Count()).
//		Scan(ctx, &v)
func (blq *BlobLinkQuery) GroupBy(field string, fields ...string) *BlobLinkGroupBy {
	blq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &BlobLinkGroupBy{build: blq}
	grbuild.flds = &blq.ctx.Fields
	grbuild.label = bloblink.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		CreatedAt time.Time `json:"created_at,omitempty"`
//	}
//
//	client.BlobLink.Query().
//		Select(bloblink.FieldCreatedAt).
//		Scan(ctx, &v)
func (blq *BlobLinkQuery) Select(fields ...string) *BlobLinkSelect {
	blq.ctx.Fields = append(blq.ctx.Fields, fields...)
	sbuild := &BlobLinkSelect{BlobLinkQuery: blq}
	sbuild.label = bloblink.Label
	sbuild.flds, sbuild.scan = &blq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a BlobLinkSelect configured with the given aggregations.
func (blq *BlobLinkQuery) Aggregate(fns ...AggregateFunc) *BlobLinkSelect {
	return blq.Select().Aggregate(fns...)
}

func (blq *BlobLinkQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range blq.inters {
		if inter == nil {
			return fmt.Errorf("ent: uninitialized interceptor (forgotten import ent/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, blq); err != nil {
				return err
			}
		}
	}
	for _, f := range blq.ctx.Fields {
		if !bloblink.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
		}
	}
	if blq.path != nil {
		prev, err := blq.path(ctx)
		if err != nil {
			return err
		}
		blq.sql = prev
	}
	return nil
}

func (blq *BlobLinkQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*BlobLink, error) {
	var (
		nodes       = []*BlobLink{}
		_spec       = blq.querySpec()
		loadedTypes = [2]bool{
			blq.withBlob != nil,
			blq.withLink != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*BlobLink).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &BlobLink{config: blq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, blq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := blq.withBlob; query != nil {
		if err := blq.loadBlob(ctx, query, nodes, nil,
			func(n *BlobLink, e *Blob) { n.Edges.Blob = e }); err != nil {
			return nil, err
		}
	}
	if query := blq.withLink; query != nil {
		if err := blq.loadLink(ctx, query, nodes, nil,
			func(n *BlobLink, e *Blob) { n.Edges.Link = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (blq *BlobLinkQuery) loadBlob(ctx context.Context, query *BlobQuery, nodes []*BlobLink, init func(*BlobLink), assign func(*BlobLink, *Blob)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*BlobLink)
	for i := range nodes {
		fk := nodes[i].BlobID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(blob.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "blob_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}
func (blq *BlobLinkQuery) loadLink(ctx context.Context, query *BlobQuery, nodes []*BlobLink, init func(*BlobLink), assign func(*BlobLink, *Blob)) error {
	ids := make([]uuid.UUID, 0, len(nodes))
	nodeids := make(map[uuid.UUID][]*BlobLink)
	for i := range nodes {
		fk := nodes[i].LinkID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	if len(ids) == 0 {
		return nil
	}
	query.Where(blob.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "link_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (blq *BlobLinkQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := blq.querySpec()
	_spec.Unique = false
	_spec.Node.Columns = nil
	return sqlgraph.CountNodes(ctx, blq.driver, _spec)
}

func (blq *BlobLinkQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(bloblink.Table, bloblink.Columns, nil)
	_spec.From = blq.sql
	if unique := blq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if blq.path != nil {
		_spec.Unique = true
	}
	if fields := blq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		for i := range fields {
			_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
		}
		if blq.withBlob != nil {
			_spec.Node.AddColumnOnce(bloblink.FieldBlobID)
		}
		if blq.withLink != nil {
			_spec.Node.AddColumnOnce(bloblink.FieldLinkID)
		}
	}
	if ps := blq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := blq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := blq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := blq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (blq *BlobLinkQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(blq.driver.Dialect())
	t1 := builder.Table(bloblink.Table)
	columns := blq.ctx.Fields
	if len(columns) == 0 {
		columns = bloblink.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if blq.sql != nil {
		selector = blq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if blq.ctx.Unique != nil && *blq.ctx.Unique {
		selector.Distinct()
	}
	for _, p := range blq.predicates {
		p(selector)
	}
	for _, p := range blq.order {
		p(selector)
	}
	if offset := blq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := blq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// BlobLinkGroupBy is the group-by builder for BlobLink entities.
type BlobLinkGroupBy struct {
	selector
	build *BlobLinkQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (blgb *BlobLinkGroupBy) Aggregate(fns ...AggregateFunc) *BlobLinkGroupBy {
	blgb.fns = append(blgb.fns, fns...)
	return blgb
}

// Scan applies the selector query and scans the result into the given value.
func (blgb *BlobLinkGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, blgb.build.ctx, "GroupBy")
	if err := blgb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*BlobLinkQuery, *BlobLinkGroupBy](ctx, blgb.build, blgb, blgb.build.inters, v)
}

func (blgb *BlobLinkGroupBy) sqlScan(ctx context.Context, root *BlobLinkQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(blgb.fns))
	for _, fn := range blgb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*blgb.flds)+len(blgb.fns))
		for _, f := range *blgb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*blgb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := blgb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// BlobLinkSelect is the builder for selecting fields of BlobLink entities.
type BlobLinkSelect struct {
	*BlobLinkQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (bls *BlobLinkSelect) Aggregate(fns ...AggregateFunc) *BlobLinkSelect {
	bls.fns = append(bls.fns, fns...)
	return bls
}

// Scan applies the selector query and scans the result into the given value.
func (bls *BlobLinkSelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, bls.ctx, "Select")
	if err := bls.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*BlobLinkQuery, *BlobLinkSelect](ctx, bls.BlobLinkQuery, bls, bls.inters, v)
}

func (bls *BlobLinkSelect) sqlScan(ctx context.Context, root *BlobLinkQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(bls.fns))
	for _, fn := range bls.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*bls.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := bls.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}
