// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package car

import (
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/customid/ent/predicate"
)

// ID filters vertices based on their ID field.
func ID(id int) predicate.Car {
	return predicate.Car(sql.FieldEQ(FieldID, id))
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id int) predicate.Car {
	return predicate.Car(sql.FieldEQ(FieldID, id))
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id int) predicate.Car {
	return predicate.Car(sql.FieldNEQ(FieldID, id))
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...int) predicate.Car {
	return predicate.Car(sql.FieldIn(FieldID, ids...))
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...int) predicate.Car {
	return predicate.Car(sql.FieldNotIn(FieldID, ids...))
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id int) predicate.Car {
	return predicate.Car(sql.FieldGT(FieldID, id))
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id int) predicate.Car {
	return predicate.Car(sql.FieldGTE(FieldID, id))
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id int) predicate.Car {
	return predicate.Car(sql.FieldLT(FieldID, id))
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id int) predicate.Car {
	return predicate.Car(sql.FieldLTE(FieldID, id))
}

// BeforeID applies equality check predicate on the "before_id" field. It's identical to BeforeIDEQ.
func BeforeID(v float64) predicate.Car {
	return predicate.Car(sql.FieldEQ(FieldBeforeID, v))
}

// AfterID applies equality check predicate on the "after_id" field. It's identical to AfterIDEQ.
func AfterID(v float64) predicate.Car {
	return predicate.Car(sql.FieldEQ(FieldAfterID, v))
}

// Model applies equality check predicate on the "model" field. It's identical to ModelEQ.
func Model(v string) predicate.Car {
	return predicate.Car(sql.FieldEQ(FieldModel, v))
}

// BeforeIDEQ applies the EQ predicate on the "before_id" field.
func BeforeIDEQ(v float64) predicate.Car {
	return predicate.Car(sql.FieldEQ(FieldBeforeID, v))
}

// BeforeIDNEQ applies the NEQ predicate on the "before_id" field.
func BeforeIDNEQ(v float64) predicate.Car {
	return predicate.Car(sql.FieldNEQ(FieldBeforeID, v))
}

// BeforeIDIn applies the In predicate on the "before_id" field.
func BeforeIDIn(vs ...float64) predicate.Car {
	return predicate.Car(sql.FieldIn(FieldBeforeID, vs...))
}

// BeforeIDNotIn applies the NotIn predicate on the "before_id" field.
func BeforeIDNotIn(vs ...float64) predicate.Car {
	return predicate.Car(sql.FieldNotIn(FieldBeforeID, vs...))
}

// BeforeIDGT applies the GT predicate on the "before_id" field.
func BeforeIDGT(v float64) predicate.Car {
	return predicate.Car(sql.FieldGT(FieldBeforeID, v))
}

// BeforeIDGTE applies the GTE predicate on the "before_id" field.
func BeforeIDGTE(v float64) predicate.Car {
	return predicate.Car(sql.FieldGTE(FieldBeforeID, v))
}

// BeforeIDLT applies the LT predicate on the "before_id" field.
func BeforeIDLT(v float64) predicate.Car {
	return predicate.Car(sql.FieldLT(FieldBeforeID, v))
}

// BeforeIDLTE applies the LTE predicate on the "before_id" field.
func BeforeIDLTE(v float64) predicate.Car {
	return predicate.Car(sql.FieldLTE(FieldBeforeID, v))
}

// BeforeIDIsNil applies the IsNil predicate on the "before_id" field.
func BeforeIDIsNil() predicate.Car {
	return predicate.Car(sql.FieldIsNull(FieldBeforeID))
}

// BeforeIDNotNil applies the NotNil predicate on the "before_id" field.
func BeforeIDNotNil() predicate.Car {
	return predicate.Car(sql.FieldNotNull(FieldBeforeID))
}

// AfterIDEQ applies the EQ predicate on the "after_id" field.
func AfterIDEQ(v float64) predicate.Car {
	return predicate.Car(sql.FieldEQ(FieldAfterID, v))
}

// AfterIDNEQ applies the NEQ predicate on the "after_id" field.
func AfterIDNEQ(v float64) predicate.Car {
	return predicate.Car(sql.FieldNEQ(FieldAfterID, v))
}

// AfterIDIn applies the In predicate on the "after_id" field.
func AfterIDIn(vs ...float64) predicate.Car {
	return predicate.Car(sql.FieldIn(FieldAfterID, vs...))
}

// AfterIDNotIn applies the NotIn predicate on the "after_id" field.
func AfterIDNotIn(vs ...float64) predicate.Car {
	return predicate.Car(sql.FieldNotIn(FieldAfterID, vs...))
}

// AfterIDGT applies the GT predicate on the "after_id" field.
func AfterIDGT(v float64) predicate.Car {
	return predicate.Car(sql.FieldGT(FieldAfterID, v))
}

// AfterIDGTE applies the GTE predicate on the "after_id" field.
func AfterIDGTE(v float64) predicate.Car {
	return predicate.Car(sql.FieldGTE(FieldAfterID, v))
}

// AfterIDLT applies the LT predicate on the "after_id" field.
func AfterIDLT(v float64) predicate.Car {
	return predicate.Car(sql.FieldLT(FieldAfterID, v))
}

// AfterIDLTE applies the LTE predicate on the "after_id" field.
func AfterIDLTE(v float64) predicate.Car {
	return predicate.Car(sql.FieldLTE(FieldAfterID, v))
}

// AfterIDIsNil applies the IsNil predicate on the "after_id" field.
func AfterIDIsNil() predicate.Car {
	return predicate.Car(sql.FieldIsNull(FieldAfterID))
}

// AfterIDNotNil applies the NotNil predicate on the "after_id" field.
func AfterIDNotNil() predicate.Car {
	return predicate.Car(sql.FieldNotNull(FieldAfterID))
}

// ModelEQ applies the EQ predicate on the "model" field.
func ModelEQ(v string) predicate.Car {
	return predicate.Car(sql.FieldEQ(FieldModel, v))
}

// ModelNEQ applies the NEQ predicate on the "model" field.
func ModelNEQ(v string) predicate.Car {
	return predicate.Car(sql.FieldNEQ(FieldModel, v))
}

// ModelIn applies the In predicate on the "model" field.
func ModelIn(vs ...string) predicate.Car {
	return predicate.Car(sql.FieldIn(FieldModel, vs...))
}

// ModelNotIn applies the NotIn predicate on the "model" field.
func ModelNotIn(vs ...string) predicate.Car {
	return predicate.Car(sql.FieldNotIn(FieldModel, vs...))
}

// ModelGT applies the GT predicate on the "model" field.
func ModelGT(v string) predicate.Car {
	return predicate.Car(sql.FieldGT(FieldModel, v))
}

// ModelGTE applies the GTE predicate on the "model" field.
func ModelGTE(v string) predicate.Car {
	return predicate.Car(sql.FieldGTE(FieldModel, v))
}

// ModelLT applies the LT predicate on the "model" field.
func ModelLT(v string) predicate.Car {
	return predicate.Car(sql.FieldLT(FieldModel, v))
}

// ModelLTE applies the LTE predicate on the "model" field.
func ModelLTE(v string) predicate.Car {
	return predicate.Car(sql.FieldLTE(FieldModel, v))
}

// ModelContains applies the Contains predicate on the "model" field.
func ModelContains(v string) predicate.Car {
	return predicate.Car(sql.FieldContains(FieldModel, v))
}

// ModelHasPrefix applies the HasPrefix predicate on the "model" field.
func ModelHasPrefix(v string) predicate.Car {
	return predicate.Car(sql.FieldHasPrefix(FieldModel, v))
}

// ModelHasSuffix applies the HasSuffix predicate on the "model" field.
func ModelHasSuffix(v string) predicate.Car {
	return predicate.Car(sql.FieldHasSuffix(FieldModel, v))
}

// ModelEqualFold applies the EqualFold predicate on the "model" field.
func ModelEqualFold(v string) predicate.Car {
	return predicate.Car(sql.FieldEqualFold(FieldModel, v))
}

// ModelContainsFold applies the ContainsFold predicate on the "model" field.
func ModelContainsFold(v string) predicate.Car {
	return predicate.Car(sql.FieldContainsFold(FieldModel, v))
}

// HasOwner applies the HasEdge predicate on the "owner" edge.
func HasOwner() predicate.Car {
	return predicate.Car(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, OwnerTable, OwnerColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasOwnerWith applies the HasEdge predicate on the "owner" edge with a given conditions (other predicates).
func HasOwnerWith(preds ...predicate.Pet) predicate.Car {
	return predicate.Car(func(s *sql.Selector) {
		step := newOwnerStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.Car) predicate.Car {
	return predicate.Car(sql.AndPredicates(predicates...))
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.Car) predicate.Car {
	return predicate.Car(sql.OrPredicates(predicates...))
}

// Not applies the not operator on the given predicate.
func Not(p predicate.Car) predicate.Car {
	return predicate.Car(sql.NotPredicates(p))
}
