// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package link

import (
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/entc/integration/customid/ent/schema"
	uuidc "entgo.io/ent/entc/integration/customid/uuidcompatible"
)

const (
	// Label holds the string label denoting the link type in the database.
	Label = "link"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldLinkInformation holds the string denoting the link_information field in the database.
	FieldLinkInformation = "link_information"
	// Table holds the table name of the link in the database.
	Table = "links"
)

// Columns holds all SQL columns for link fields.
var Columns = []string{
	FieldID,
	FieldLinkInformation,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultLinkInformation holds the default value on creation for the "link_information" field.
	DefaultLinkInformation map[string]schema.LinkInformation
	// DefaultID holds the default value on creation for the "id" field.
	DefaultID func() uuidc.UUIDC
)

// OrderOption defines the ordering options for the Link queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}
