// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/customid/ent/mixinid"
	"entgo.io/ent/entc/integration/customid/ent/predicate"
	"entgo.io/ent/schema/field"
)

// MixinIDDelete is the builder for deleting a MixinID entity.
type MixinIDDelete struct {
	config
	hooks    []Hook
	mutation *MixinIDMutation
}

// Where appends a list predicates to the MixinIDDelete builder.
func (mid *MixinIDDelete) Where(ps ...predicate.MixinID) *MixinIDDelete {
	mid.mutation.Where(ps...)
	return mid
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (mid *MixinIDDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, mid.sqlExec, mid.mutation, mid.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (mid *MixinIDDelete) ExecX(ctx context.Context) int {
	n, err := mid.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (mid *MixinIDDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(mixinid.Table, sqlgraph.NewFieldSpec(mixinid.FieldID, field.TypeUUID))
	if ps := mid.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, mid.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	mid.mutation.done = true
	return affected, err
}

// MixinIDDeleteOne is the builder for deleting a single MixinID entity.
type MixinIDDeleteOne struct {
	mid *MixinIDDelete
}

// Where appends a list predicates to the MixinIDDelete builder.
func (mido *MixinIDDeleteOne) Where(ps ...predicate.MixinID) *MixinIDDeleteOne {
	mido.mid.mutation.Where(ps...)
	return mido
}

// Exec executes the deletion query.
func (mido *MixinIDDeleteOne) Exec(ctx context.Context) error {
	n, err := mido.mid.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{mixinid.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (mido *MixinIDDeleteOne) ExecX(ctx context.Context) {
	if err := mido.Exec(ctx); err != nil {
		panic(err)
	}
}
