// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/entc/integration/edgeschema/ent/attachedfile"
	"entgo.io/ent/entc/integration/edgeschema/ent/file"
	"entgo.io/ent/entc/integration/edgeschema/ent/process"
)

// AttachedFile is the model entity for the AttachedFile schema.
type AttachedFile struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// AttachTime holds the value of the "attach_time" field.
	AttachTime time.Time `json:"attach_time,omitempty"`
	// FID holds the value of the "f_id" field.
	FID int `json:"f_id,omitempty"`
	// ProcID holds the value of the "proc_id" field.
	ProcID int `json:"proc_id,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the AttachedFileQuery when eager-loading is set.
	Edges        AttachedFileEdges `json:"edges"`
	selectValues sql.SelectValues
}

// AttachedFileEdges holds the relations/edges for other nodes in the graph.
type AttachedFileEdges struct {
	// Fi holds the value of the fi edge.
	Fi *File `json:"fi,omitempty"`
	// Proc holds the value of the proc edge.
	Proc *Process `json:"proc,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [2]bool
}

// FiOrErr returns the Fi value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e AttachedFileEdges) FiOrErr() (*File, error) {
	if e.loadedTypes[0] {
		if e.Fi == nil {
			// Edge was loaded but was not found.
			return nil, &NotFoundError{label: file.Label}
		}
		return e.Fi, nil
	}
	return nil, &NotLoadedError{edge: "fi"}
}

// ProcOrErr returns the Proc value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e AttachedFileEdges) ProcOrErr() (*Process, error) {
	if e.loadedTypes[1] {
		if e.Proc == nil {
			// Edge was loaded but was not found.
			return nil, &NotFoundError{label: process.Label}
		}
		return e.Proc, nil
	}
	return nil, &NotLoadedError{edge: "proc"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*AttachedFile) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case attachedfile.FieldID, attachedfile.FieldFID, attachedfile.FieldProcID:
			values[i] = new(sql.NullInt64)
		case attachedfile.FieldAttachTime:
			values[i] = new(sql.NullTime)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the AttachedFile fields.
func (af *AttachedFile) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case attachedfile.FieldID:
			value, ok := values[i].(*sql.NullInt64)
			if !ok {
				return fmt.Errorf("unexpected type %T for field id", value)
			}
			af.ID = int(value.Int64)
		case attachedfile.FieldAttachTime:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field attach_time", values[i])
			} else if value.Valid {
				af.AttachTime = value.Time
			}
		case attachedfile.FieldFID:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field f_id", values[i])
			} else if value.Valid {
				af.FID = int(value.Int64)
			}
		case attachedfile.FieldProcID:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field proc_id", values[i])
			} else if value.Valid {
				af.ProcID = int(value.Int64)
			}
		default:
			af.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the AttachedFile.
// This includes values selected through modifiers, order, etc.
func (af *AttachedFile) Value(name string) (ent.Value, error) {
	return af.selectValues.Get(name)
}

// QueryFi queries the "fi" edge of the AttachedFile entity.
func (af *AttachedFile) QueryFi() *FileQuery {
	return NewAttachedFileClient(af.config).QueryFi(af)
}

// QueryProc queries the "proc" edge of the AttachedFile entity.
func (af *AttachedFile) QueryProc() *ProcessQuery {
	return NewAttachedFileClient(af.config).QueryProc(af)
}

// Update returns a builder for updating this AttachedFile.
// Note that you need to call AttachedFile.Unwrap() before calling this method if this AttachedFile
// was returned from a transaction, and the transaction was committed or rolled back.
func (af *AttachedFile) Update() *AttachedFileUpdateOne {
	return NewAttachedFileClient(af.config).UpdateOne(af)
}

// Unwrap unwraps the AttachedFile entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (af *AttachedFile) Unwrap() *AttachedFile {
	_tx, ok := af.config.driver.(*txDriver)
	if !ok {
		panic("ent: AttachedFile is not a transactional entity")
	}
	af.config.driver = _tx.drv
	return af
}

// String implements the fmt.Stringer.
func (af *AttachedFile) String() string {
	var builder strings.Builder
	builder.WriteString("AttachedFile(")
	builder.WriteString(fmt.Sprintf("id=%v, ", af.ID))
	builder.WriteString("attach_time=")
	builder.WriteString(af.AttachTime.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("f_id=")
	builder.WriteString(fmt.Sprintf("%v", af.FID))
	builder.WriteString(", ")
	builder.WriteString("proc_id=")
	builder.WriteString(fmt.Sprintf("%v", af.ProcID))
	builder.WriteByte(')')
	return builder.String()
}

// AttachedFiles is a parsable slice of AttachedFile.
type AttachedFiles []*AttachedFile
