// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package attachedfile

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the attachedfile type in the database.
	Label = "attached_file"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldAttachTime holds the string denoting the attach_time field in the database.
	FieldAttachTime = "attach_time"
	// FieldFID holds the string denoting the f_id field in the database.
	FieldFID = "f_id"
	// FieldProcID holds the string denoting the proc_id field in the database.
	FieldProcID = "proc_id"
	// EdgeFi holds the string denoting the fi edge name in mutations.
	EdgeFi = "fi"
	// EdgeProc holds the string denoting the proc edge name in mutations.
	EdgeProc = "proc"
	// Table holds the table name of the attachedfile in the database.
	Table = "attached_files"
	// FiTable is the table that holds the fi relation/edge.
	FiTable = "attached_files"
	// FiInverseTable is the table name for the File entity.
	// It exists in this package in order to avoid circular dependency with the "file" package.
	FiInverseTable = "files"
	// FiColumn is the table column denoting the fi relation/edge.
	FiColumn = "f_id"
	// ProcTable is the table that holds the proc relation/edge.
	ProcTable = "attached_files"
	// ProcInverseTable is the table name for the Process entity.
	// It exists in this package in order to avoid circular dependency with the "process" package.
	ProcInverseTable = "processes"
	// ProcColumn is the table column denoting the proc relation/edge.
	ProcColumn = "proc_id"
)

// Columns holds all SQL columns for attachedfile fields.
var Columns = []string{
	FieldID,
	FieldAttachTime,
	FieldFID,
	FieldProcID,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultAttachTime holds the default value on creation for the "attach_time" field.
	DefaultAttachTime func() time.Time
)

// OrderOption defines the ordering options for the AttachedFile queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByAttachTime orders the results by the attach_time field.
func ByAttachTime(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldAttachTime, opts...).ToFunc()
}

// ByFID orders the results by the f_id field.
func ByFID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFID, opts...).ToFunc()
}

// ByProcID orders the results by the proc_id field.
func ByProcID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldProcID, opts...).ToFunc()
}

// ByFiField orders the results by fi field.
func ByFiField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newFiStep(), sql.OrderByField(field, opts...))
	}
}

// ByProcField orders the results by proc field.
func ByProcField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newProcStep(), sql.OrderByField(field, opts...))
	}
}
func newFiStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(FiInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, false, FiTable, FiColumn),
	)
}
func newProcStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(ProcInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2O, false, ProcTable, ProcColumn),
	)
}
