// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package attachedfile

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/predicate"
)

// ID filters vertices based on their ID field.
func ID(id int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldEQ(FieldID, id))
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldEQ(FieldID, id))
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldNEQ(FieldID, id))
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldIn(FieldID, ids...))
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldNotIn(FieldID, ids...))
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldGT(FieldID, id))
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldGTE(FieldID, id))
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldLT(FieldID, id))
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldLTE(FieldID, id))
}

// AttachTime applies equality check predicate on the "attach_time" field. It's identical to AttachTimeEQ.
func AttachTime(v time.Time) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldEQ(FieldAttachTime, v))
}

// FID applies equality check predicate on the "f_id" field. It's identical to FIDEQ.
func FID(v int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldEQ(FieldFID, v))
}

// ProcID applies equality check predicate on the "proc_id" field. It's identical to ProcIDEQ.
func ProcID(v int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldEQ(FieldProcID, v))
}

// AttachTimeEQ applies the EQ predicate on the "attach_time" field.
func AttachTimeEQ(v time.Time) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldEQ(FieldAttachTime, v))
}

// AttachTimeNEQ applies the NEQ predicate on the "attach_time" field.
func AttachTimeNEQ(v time.Time) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldNEQ(FieldAttachTime, v))
}

// AttachTimeIn applies the In predicate on the "attach_time" field.
func AttachTimeIn(vs ...time.Time) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldIn(FieldAttachTime, vs...))
}

// AttachTimeNotIn applies the NotIn predicate on the "attach_time" field.
func AttachTimeNotIn(vs ...time.Time) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldNotIn(FieldAttachTime, vs...))
}

// AttachTimeGT applies the GT predicate on the "attach_time" field.
func AttachTimeGT(v time.Time) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldGT(FieldAttachTime, v))
}

// AttachTimeGTE applies the GTE predicate on the "attach_time" field.
func AttachTimeGTE(v time.Time) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldGTE(FieldAttachTime, v))
}

// AttachTimeLT applies the LT predicate on the "attach_time" field.
func AttachTimeLT(v time.Time) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldLT(FieldAttachTime, v))
}

// AttachTimeLTE applies the LTE predicate on the "attach_time" field.
func AttachTimeLTE(v time.Time) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldLTE(FieldAttachTime, v))
}

// FIDEQ applies the EQ predicate on the "f_id" field.
func FIDEQ(v int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldEQ(FieldFID, v))
}

// FIDNEQ applies the NEQ predicate on the "f_id" field.
func FIDNEQ(v int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldNEQ(FieldFID, v))
}

// FIDIn applies the In predicate on the "f_id" field.
func FIDIn(vs ...int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldIn(FieldFID, vs...))
}

// FIDNotIn applies the NotIn predicate on the "f_id" field.
func FIDNotIn(vs ...int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldNotIn(FieldFID, vs...))
}

// ProcIDEQ applies the EQ predicate on the "proc_id" field.
func ProcIDEQ(v int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldEQ(FieldProcID, v))
}

// ProcIDNEQ applies the NEQ predicate on the "proc_id" field.
func ProcIDNEQ(v int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldNEQ(FieldProcID, v))
}

// ProcIDIn applies the In predicate on the "proc_id" field.
func ProcIDIn(vs ...int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldIn(FieldProcID, vs...))
}

// ProcIDNotIn applies the NotIn predicate on the "proc_id" field.
func ProcIDNotIn(vs ...int) predicate.AttachedFile {
	return predicate.AttachedFile(sql.FieldNotIn(FieldProcID, vs...))
}

// HasFi applies the HasEdge predicate on the "fi" edge.
func HasFi() predicate.AttachedFile {
	return predicate.AttachedFile(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, FiTable, FiColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasFiWith applies the HasEdge predicate on the "fi" edge with a given conditions (other predicates).
func HasFiWith(preds ...predicate.File) predicate.AttachedFile {
	return predicate.AttachedFile(func(s *sql.Selector) {
		step := newFiStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// HasProc applies the HasEdge predicate on the "proc" edge.
func HasProc() predicate.AttachedFile {
	return predicate.AttachedFile(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, ProcTable, ProcColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasProcWith applies the HasEdge predicate on the "proc" edge with a given conditions (other predicates).
func HasProcWith(preds ...predicate.Process) predicate.AttachedFile {
	return predicate.AttachedFile(func(s *sql.Selector) {
		step := newProcStep()
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.AttachedFile) predicate.AttachedFile {
	return predicate.AttachedFile(sql.AndPredicates(predicates...))
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.AttachedFile) predicate.AttachedFile {
	return predicate.AttachedFile(sql.OrPredicates(predicates...))
}

// Not applies the not operator on the given predicate.
func Not(p predicate.AttachedFile) predicate.AttachedFile {
	return predicate.AttachedFile(sql.NotPredicates(p))
}
