// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/attachedfile"
	"entgo.io/ent/entc/integration/edgeschema/ent/predicate"
	"entgo.io/ent/schema/field"
)

// AttachedFileDelete is the builder for deleting a AttachedFile entity.
type AttachedFileDelete struct {
	config
	hooks    []Hook
	mutation *AttachedFileMutation
}

// Where appends a list predicates to the AttachedFileDelete builder.
func (afd *AttachedFileDelete) Where(ps ...predicate.AttachedFile) *AttachedFileDelete {
	afd.mutation.Where(ps...)
	return afd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (afd *AttachedFileDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, afd.sqlExec, afd.mutation, afd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (afd *AttachedFileDelete) ExecX(ctx context.Context) int {
	n, err := afd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (afd *AttachedFileDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(attachedfile.Table, sqlgraph.NewFieldSpec(attachedfile.FieldID, field.TypeInt))
	if ps := afd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, afd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	afd.mutation.done = true
	return affected, err
}

// AttachedFileDeleteOne is the builder for deleting a single AttachedFile entity.
type AttachedFileDeleteOne struct {
	afd *AttachedFileDelete
}

// Where appends a list predicates to the AttachedFileDelete builder.
func (afdo *AttachedFileDeleteOne) Where(ps ...predicate.AttachedFile) *AttachedFileDeleteOne {
	afdo.afd.mutation.Where(ps...)
	return afdo
}

// Exec executes the deletion query.
func (afdo *AttachedFileDeleteOne) Exec(ctx context.Context) error {
	n, err := afdo.afd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{attachedfile.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (afdo *AttachedFileDeleteOne) ExecX(ctx context.Context) {
	if err := afdo.Exec(ctx); err != nil {
		panic(err)
	}
}
