// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/attachedfile"
	"entgo.io/ent/entc/integration/edgeschema/ent/file"
	"entgo.io/ent/entc/integration/edgeschema/ent/predicate"
	"entgo.io/ent/entc/integration/edgeschema/ent/process"
	"entgo.io/ent/schema/field"
)

// AttachedFileUpdate is the builder for updating AttachedFile entities.
type AttachedFileUpdate struct {
	config
	hooks    []Hook
	mutation *AttachedFileMutation
}

// Where appends a list predicates to the AttachedFileUpdate builder.
func (afu *AttachedFileUpdate) Where(ps ...predicate.AttachedFile) *AttachedFileUpdate {
	afu.mutation.Where(ps...)
	return afu
}

// SetAttachTime sets the "attach_time" field.
func (afu *AttachedFileUpdate) SetAttachTime(t time.Time) *AttachedFileUpdate {
	afu.mutation.SetAttachTime(t)
	return afu
}

// SetNillableAttachTime sets the "attach_time" field if the given value is not nil.
func (afu *AttachedFileUpdate) SetNillableAttachTime(t *time.Time) *AttachedFileUpdate {
	if t != nil {
		afu.SetAttachTime(*t)
	}
	return afu
}

// SetFID sets the "f_id" field.
func (afu *AttachedFileUpdate) SetFID(i int) *AttachedFileUpdate {
	afu.mutation.SetFID(i)
	return afu
}

// SetProcID sets the "proc_id" field.
func (afu *AttachedFileUpdate) SetProcID(i int) *AttachedFileUpdate {
	afu.mutation.SetProcID(i)
	return afu
}

// SetFiID sets the "fi" edge to the File entity by ID.
func (afu *AttachedFileUpdate) SetFiID(id int) *AttachedFileUpdate {
	afu.mutation.SetFiID(id)
	return afu
}

// SetFi sets the "fi" edge to the File entity.
func (afu *AttachedFileUpdate) SetFi(f *File) *AttachedFileUpdate {
	return afu.SetFiID(f.ID)
}

// SetProc sets the "proc" edge to the Process entity.
func (afu *AttachedFileUpdate) SetProc(p *Process) *AttachedFileUpdate {
	return afu.SetProcID(p.ID)
}

// Mutation returns the AttachedFileMutation object of the builder.
func (afu *AttachedFileUpdate) Mutation() *AttachedFileMutation {
	return afu.mutation
}

// ClearFi clears the "fi" edge to the File entity.
func (afu *AttachedFileUpdate) ClearFi() *AttachedFileUpdate {
	afu.mutation.ClearFi()
	return afu
}

// ClearProc clears the "proc" edge to the Process entity.
func (afu *AttachedFileUpdate) ClearProc() *AttachedFileUpdate {
	afu.mutation.ClearProc()
	return afu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (afu *AttachedFileUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, afu.sqlSave, afu.mutation, afu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (afu *AttachedFileUpdate) SaveX(ctx context.Context) int {
	affected, err := afu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (afu *AttachedFileUpdate) Exec(ctx context.Context) error {
	_, err := afu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (afu *AttachedFileUpdate) ExecX(ctx context.Context) {
	if err := afu.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (afu *AttachedFileUpdate) check() error {
	if _, ok := afu.mutation.FiID(); afu.mutation.FiCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "AttachedFile.fi"`)
	}
	if _, ok := afu.mutation.ProcID(); afu.mutation.ProcCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "AttachedFile.proc"`)
	}
	return nil
}

func (afu *AttachedFileUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := afu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(attachedfile.Table, attachedfile.Columns, sqlgraph.NewFieldSpec(attachedfile.FieldID, field.TypeInt))
	if ps := afu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := afu.mutation.AttachTime(); ok {
		_spec.SetField(attachedfile.FieldAttachTime, field.TypeTime, value)
	}
	if afu.mutation.FiCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   attachedfile.FiTable,
			Columns: []string{attachedfile.FiColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(file.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := afu.mutation.FiIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   attachedfile.FiTable,
			Columns: []string{attachedfile.FiColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(file.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if afu.mutation.ProcCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   attachedfile.ProcTable,
			Columns: []string{attachedfile.ProcColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(process.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := afu.mutation.ProcIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   attachedfile.ProcTable,
			Columns: []string{attachedfile.ProcColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(process.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, afu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{attachedfile.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	afu.mutation.done = true
	return n, nil
}

// AttachedFileUpdateOne is the builder for updating a single AttachedFile entity.
type AttachedFileUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *AttachedFileMutation
}

// SetAttachTime sets the "attach_time" field.
func (afuo *AttachedFileUpdateOne) SetAttachTime(t time.Time) *AttachedFileUpdateOne {
	afuo.mutation.SetAttachTime(t)
	return afuo
}

// SetNillableAttachTime sets the "attach_time" field if the given value is not nil.
func (afuo *AttachedFileUpdateOne) SetNillableAttachTime(t *time.Time) *AttachedFileUpdateOne {
	if t != nil {
		afuo.SetAttachTime(*t)
	}
	return afuo
}

// SetFID sets the "f_id" field.
func (afuo *AttachedFileUpdateOne) SetFID(i int) *AttachedFileUpdateOne {
	afuo.mutation.SetFID(i)
	return afuo
}

// SetProcID sets the "proc_id" field.
func (afuo *AttachedFileUpdateOne) SetProcID(i int) *AttachedFileUpdateOne {
	afuo.mutation.SetProcID(i)
	return afuo
}

// SetFiID sets the "fi" edge to the File entity by ID.
func (afuo *AttachedFileUpdateOne) SetFiID(id int) *AttachedFileUpdateOne {
	afuo.mutation.SetFiID(id)
	return afuo
}

// SetFi sets the "fi" edge to the File entity.
func (afuo *AttachedFileUpdateOne) SetFi(f *File) *AttachedFileUpdateOne {
	return afuo.SetFiID(f.ID)
}

// SetProc sets the "proc" edge to the Process entity.
func (afuo *AttachedFileUpdateOne) SetProc(p *Process) *AttachedFileUpdateOne {
	return afuo.SetProcID(p.ID)
}

// Mutation returns the AttachedFileMutation object of the builder.
func (afuo *AttachedFileUpdateOne) Mutation() *AttachedFileMutation {
	return afuo.mutation
}

// ClearFi clears the "fi" edge to the File entity.
func (afuo *AttachedFileUpdateOne) ClearFi() *AttachedFileUpdateOne {
	afuo.mutation.ClearFi()
	return afuo
}

// ClearProc clears the "proc" edge to the Process entity.
func (afuo *AttachedFileUpdateOne) ClearProc() *AttachedFileUpdateOne {
	afuo.mutation.ClearProc()
	return afuo
}

// Where appends a list predicates to the AttachedFileUpdate builder.
func (afuo *AttachedFileUpdateOne) Where(ps ...predicate.AttachedFile) *AttachedFileUpdateOne {
	afuo.mutation.Where(ps...)
	return afuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (afuo *AttachedFileUpdateOne) Select(field string, fields ...string) *AttachedFileUpdateOne {
	afuo.fields = append([]string{field}, fields...)
	return afuo
}

// Save executes the query and returns the updated AttachedFile entity.
func (afuo *AttachedFileUpdateOne) Save(ctx context.Context) (*AttachedFile, error) {
	return withHooks(ctx, afuo.sqlSave, afuo.mutation, afuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (afuo *AttachedFileUpdateOne) SaveX(ctx context.Context) *AttachedFile {
	node, err := afuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (afuo *AttachedFileUpdateOne) Exec(ctx context.Context) error {
	_, err := afuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (afuo *AttachedFileUpdateOne) ExecX(ctx context.Context) {
	if err := afuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (afuo *AttachedFileUpdateOne) check() error {
	if _, ok := afuo.mutation.FiID(); afuo.mutation.FiCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "AttachedFile.fi"`)
	}
	if _, ok := afuo.mutation.ProcID(); afuo.mutation.ProcCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "AttachedFile.proc"`)
	}
	return nil
}

func (afuo *AttachedFileUpdateOne) sqlSave(ctx context.Context) (_node *AttachedFile, err error) {
	if err := afuo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(attachedfile.Table, attachedfile.Columns, sqlgraph.NewFieldSpec(attachedfile.FieldID, field.TypeInt))
	id, ok := afuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "AttachedFile.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := afuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, attachedfile.FieldID)
		for _, f := range fields {
			if !attachedfile.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != attachedfile.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := afuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := afuo.mutation.AttachTime(); ok {
		_spec.SetField(attachedfile.FieldAttachTime, field.TypeTime, value)
	}
	if afuo.mutation.FiCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   attachedfile.FiTable,
			Columns: []string{attachedfile.FiColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(file.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := afuo.mutation.FiIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   attachedfile.FiTable,
			Columns: []string{attachedfile.FiColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(file.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if afuo.mutation.ProcCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   attachedfile.ProcTable,
			Columns: []string{attachedfile.ProcColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(process.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := afuo.mutation.ProcIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   attachedfile.ProcTable,
			Columns: []string{attachedfile.ProcColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(process.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &AttachedFile{config: afuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, afuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{attachedfile.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	afuo.mutation.done = true
	return _node, nil
}
