// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"log"
	"reflect"

	"entgo.io/ent"
	"entgo.io/ent/entc/integration/edgeschema/ent/migrate"
	"github.com/google/uuid"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/attachedfile"
	"entgo.io/ent/entc/integration/edgeschema/ent/file"
	"entgo.io/ent/entc/integration/edgeschema/ent/friendship"
	"entgo.io/ent/entc/integration/edgeschema/ent/group"
	"entgo.io/ent/entc/integration/edgeschema/ent/grouptag"
	"entgo.io/ent/entc/integration/edgeschema/ent/process"
	"entgo.io/ent/entc/integration/edgeschema/ent/relationship"
	"entgo.io/ent/entc/integration/edgeschema/ent/relationshipinfo"
	"entgo.io/ent/entc/integration/edgeschema/ent/role"
	"entgo.io/ent/entc/integration/edgeschema/ent/roleuser"
	"entgo.io/ent/entc/integration/edgeschema/ent/tag"
	"entgo.io/ent/entc/integration/edgeschema/ent/tweet"
	"entgo.io/ent/entc/integration/edgeschema/ent/tweetlike"
	"entgo.io/ent/entc/integration/edgeschema/ent/tweettag"
	"entgo.io/ent/entc/integration/edgeschema/ent/user"
	"entgo.io/ent/entc/integration/edgeschema/ent/usergroup"
	"entgo.io/ent/entc/integration/edgeschema/ent/usertweet"
)

// Client is the client that holds all ent builders.
type Client struct {
	config
	// Schema is the client for creating, migrating and dropping schema.
	Schema *migrate.Schema
	// AttachedFile is the client for interacting with the AttachedFile builders.
	AttachedFile *AttachedFileClient
	// File is the client for interacting with the File builders.
	File *FileClient
	// Friendship is the client for interacting with the Friendship builders.
	Friendship *FriendshipClient
	// Group is the client for interacting with the Group builders.
	Group *GroupClient
	// GroupTag is the client for interacting with the GroupTag builders.
	GroupTag *GroupTagClient
	// Process is the client for interacting with the Process builders.
	Process *ProcessClient
	// Relationship is the client for interacting with the Relationship builders.
	Relationship *RelationshipClient
	// RelationshipInfo is the client for interacting with the RelationshipInfo builders.
	RelationshipInfo *RelationshipInfoClient
	// Role is the client for interacting with the Role builders.
	Role *RoleClient
	// RoleUser is the client for interacting with the RoleUser builders.
	RoleUser *RoleUserClient
	// Tag is the client for interacting with the Tag builders.
	Tag *TagClient
	// Tweet is the client for interacting with the Tweet builders.
	Tweet *TweetClient
	// TweetLike is the client for interacting with the TweetLike builders.
	TweetLike *TweetLikeClient
	// TweetTag is the client for interacting with the TweetTag builders.
	TweetTag *TweetTagClient
	// User is the client for interacting with the User builders.
	User *UserClient
	// UserGroup is the client for interacting with the UserGroup builders.
	UserGroup *UserGroupClient
	// UserTweet is the client for interacting with the UserTweet builders.
	UserTweet *UserTweetClient
}

// NewClient creates a new client configured with the given options.
func NewClient(opts ...Option) *Client {
	cfg := config{log: log.Println, hooks: &hooks{}, inters: &inters{}}
	cfg.options(opts...)
	client := &Client{config: cfg}
	client.init()
	return client
}

func (c *Client) init() {
	c.Schema = migrate.NewSchema(c.driver)
	c.AttachedFile = NewAttachedFileClient(c.config)
	c.File = NewFileClient(c.config)
	c.Friendship = NewFriendshipClient(c.config)
	c.Group = NewGroupClient(c.config)
	c.GroupTag = NewGroupTagClient(c.config)
	c.Process = NewProcessClient(c.config)
	c.Relationship = NewRelationshipClient(c.config)
	c.RelationshipInfo = NewRelationshipInfoClient(c.config)
	c.Role = NewRoleClient(c.config)
	c.RoleUser = NewRoleUserClient(c.config)
	c.Tag = NewTagClient(c.config)
	c.Tweet = NewTweetClient(c.config)
	c.TweetLike = NewTweetLikeClient(c.config)
	c.TweetTag = NewTweetTagClient(c.config)
	c.User = NewUserClient(c.config)
	c.UserGroup = NewUserGroupClient(c.config)
	c.UserTweet = NewUserTweetClient(c.config)
}

type (
	// config is the configuration for the client and its builder.
	config struct {
		// driver used for executing database requests.
		driver dialect.Driver
		// debug enable a debug logging.
		debug bool
		// log used for logging on debug mode.
		log func(...any)
		// hooks to execute on mutations.
		hooks *hooks
		// interceptors to execute on queries.
		inters *inters
	}
	// Option function to configure the client.
	Option func(*config)
)

// options applies the options on the config object.
func (c *config) options(opts ...Option) {
	for _, opt := range opts {
		opt(c)
	}
	if c.debug {
		c.driver = dialect.Debug(c.driver, c.log)
	}
}

// Debug enables debug logging on the ent.Driver.
func Debug() Option {
	return func(c *config) {
		c.debug = true
	}
}

// Log sets the logging function for debug mode.
func Log(fn func(...any)) Option {
	return func(c *config) {
		c.log = fn
	}
}

// Driver configures the client driver.
func Driver(driver dialect.Driver) Option {
	return func(c *config) {
		c.driver = driver
	}
}

// Open opens a database/sql.DB specified by the driver name and
// the data source name, and returns a new client attached to it.
// Optional parameters can be added for configuring the client.
func Open(driverName, dataSourceName string, options ...Option) (*Client, error) {
	switch driverName {
	case dialect.MySQL, dialect.Postgres, dialect.SQLite:
		drv, err := sql.Open(driverName, dataSourceName)
		if err != nil {
			return nil, err
		}
		return NewClient(append(options, Driver(drv))...), nil
	default:
		return nil, fmt.Errorf("unsupported driver: %q", driverName)
	}
}

// ErrTxStarted is returned when trying to start a new transaction from a transactional client.
var ErrTxStarted = errors.New("ent: cannot start a transaction within a transaction")

// Tx returns a new transactional client. The provided context
// is used until the transaction is committed or rolled back.
func (c *Client) Tx(ctx context.Context) (*Tx, error) {
	if _, ok := c.driver.(*txDriver); ok {
		return nil, ErrTxStarted
	}
	tx, err := newTx(ctx, c.driver)
	if err != nil {
		return nil, fmt.Errorf("ent: starting a transaction: %w", err)
	}
	cfg := c.config
	cfg.driver = tx
	return &Tx{
		ctx:              ctx,
		config:           cfg,
		AttachedFile:     NewAttachedFileClient(cfg),
		File:             NewFileClient(cfg),
		Friendship:       NewFriendshipClient(cfg),
		Group:            NewGroupClient(cfg),
		GroupTag:         NewGroupTagClient(cfg),
		Process:          NewProcessClient(cfg),
		Relationship:     NewRelationshipClient(cfg),
		RelationshipInfo: NewRelationshipInfoClient(cfg),
		Role:             NewRoleClient(cfg),
		RoleUser:         NewRoleUserClient(cfg),
		Tag:              NewTagClient(cfg),
		Tweet:            NewTweetClient(cfg),
		TweetLike:        NewTweetLikeClient(cfg),
		TweetTag:         NewTweetTagClient(cfg),
		User:             NewUserClient(cfg),
		UserGroup:        NewUserGroupClient(cfg),
		UserTweet:        NewUserTweetClient(cfg),
	}, nil
}

// BeginTx returns a transactional client with specified options.
func (c *Client) BeginTx(ctx context.Context, opts *sql.TxOptions) (*Tx, error) {
	if _, ok := c.driver.(*txDriver); ok {
		return nil, errors.New("ent: cannot start a transaction within a transaction")
	}
	tx, err := c.driver.(interface {
		BeginTx(context.Context, *sql.TxOptions) (dialect.Tx, error)
	}).BeginTx(ctx, opts)
	if err != nil {
		return nil, fmt.Errorf("ent: starting a transaction: %w", err)
	}
	cfg := c.config
	cfg.driver = &txDriver{tx: tx, drv: c.driver}
	return &Tx{
		ctx:              ctx,
		config:           cfg,
		AttachedFile:     NewAttachedFileClient(cfg),
		File:             NewFileClient(cfg),
		Friendship:       NewFriendshipClient(cfg),
		Group:            NewGroupClient(cfg),
		GroupTag:         NewGroupTagClient(cfg),
		Process:          NewProcessClient(cfg),
		Relationship:     NewRelationshipClient(cfg),
		RelationshipInfo: NewRelationshipInfoClient(cfg),
		Role:             NewRoleClient(cfg),
		RoleUser:         NewRoleUserClient(cfg),
		Tag:              NewTagClient(cfg),
		Tweet:            NewTweetClient(cfg),
		TweetLike:        NewTweetLikeClient(cfg),
		TweetTag:         NewTweetTagClient(cfg),
		User:             NewUserClient(cfg),
		UserGroup:        NewUserGroupClient(cfg),
		UserTweet:        NewUserTweetClient(cfg),
	}, nil
}

// Debug returns a new debug-client. It's used to get verbose logging on specific operations.
//
//	client.Debug().
//		AttachedFile.
//		Query().
//		Count(ctx)
func (c *Client) Debug() *Client {
	if c.debug {
		return c
	}
	cfg := c.config
	cfg.driver = dialect.Debug(c.driver, c.log)
	client := &Client{config: cfg}
	client.init()
	return client
}

// Close closes the database connection and prevents new queries from starting.
func (c *Client) Close() error {
	return c.driver.Close()
}

// Use adds the mutation hooks to all the entity clients.
// In order to add hooks to a specific client, call: `client.Node.Use(...)`.
func (c *Client) Use(hooks ...Hook) {
	for _, n := range []interface{ Use(...Hook) }{
		c.AttachedFile, c.File, c.Friendship, c.Group, c.GroupTag, c.Process,
		c.Relationship, c.RelationshipInfo, c.Role, c.RoleUser, c.Tag, c.Tweet,
		c.TweetLike, c.TweetTag, c.User, c.UserGroup, c.UserTweet,
	} {
		n.Use(hooks...)
	}
}

// Intercept adds the query interceptors to all the entity clients.
// In order to add interceptors to a specific client, call: `client.Node.Intercept(...)`.
func (c *Client) Intercept(interceptors ...Interceptor) {
	for _, n := range []interface{ Intercept(...Interceptor) }{
		c.AttachedFile, c.File, c.Friendship, c.Group, c.GroupTag, c.Process,
		c.Relationship, c.RelationshipInfo, c.Role, c.RoleUser, c.Tag, c.Tweet,
		c.TweetLike, c.TweetTag, c.User, c.UserGroup, c.UserTweet,
	} {
		n.Intercept(interceptors...)
	}
}

// Mutate implements the ent.Mutator interface.
func (c *Client) Mutate(ctx context.Context, m Mutation) (Value, error) {
	switch m := m.(type) {
	case *AttachedFileMutation:
		return c.AttachedFile.mutate(ctx, m)
	case *FileMutation:
		return c.File.mutate(ctx, m)
	case *FriendshipMutation:
		return c.Friendship.mutate(ctx, m)
	case *GroupMutation:
		return c.Group.mutate(ctx, m)
	case *GroupTagMutation:
		return c.GroupTag.mutate(ctx, m)
	case *ProcessMutation:
		return c.Process.mutate(ctx, m)
	case *RelationshipMutation:
		return c.Relationship.mutate(ctx, m)
	case *RelationshipInfoMutation:
		return c.RelationshipInfo.mutate(ctx, m)
	case *RoleMutation:
		return c.Role.mutate(ctx, m)
	case *RoleUserMutation:
		return c.RoleUser.mutate(ctx, m)
	case *TagMutation:
		return c.Tag.mutate(ctx, m)
	case *TweetMutation:
		return c.Tweet.mutate(ctx, m)
	case *TweetLikeMutation:
		return c.TweetLike.mutate(ctx, m)
	case *TweetTagMutation:
		return c.TweetTag.mutate(ctx, m)
	case *UserMutation:
		return c.User.mutate(ctx, m)
	case *UserGroupMutation:
		return c.UserGroup.mutate(ctx, m)
	case *UserTweetMutation:
		return c.UserTweet.mutate(ctx, m)
	default:
		return nil, fmt.Errorf("ent: unknown mutation type %T", m)
	}
}

// AttachedFileClient is a client for the AttachedFile schema.
type AttachedFileClient struct {
	config
}

// NewAttachedFileClient returns a client for the AttachedFile from the given config.
func NewAttachedFileClient(c config) *AttachedFileClient {
	return &AttachedFileClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `attachedfile.Hooks(f(g(h())))`.
func (c *AttachedFileClient) Use(hooks ...Hook) {
	c.hooks.AttachedFile = append(c.hooks.AttachedFile, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `attachedfile.Intercept(f(g(h())))`.
func (c *AttachedFileClient) Intercept(interceptors ...Interceptor) {
	c.inters.AttachedFile = append(c.inters.AttachedFile, interceptors...)
}

// Create returns a builder for creating a AttachedFile entity.
func (c *AttachedFileClient) Create() *AttachedFileCreate {
	mutation := newAttachedFileMutation(c.config, OpCreate)
	return &AttachedFileCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of AttachedFile entities.
func (c *AttachedFileClient) CreateBulk(builders ...*AttachedFileCreate) *AttachedFileCreateBulk {
	return &AttachedFileCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *AttachedFileClient) MapCreateBulk(slice any, setFunc func(*AttachedFileCreate, int)) *AttachedFileCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &AttachedFileCreateBulk{err: fmt.Errorf("calling to AttachedFileClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*AttachedFileCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &AttachedFileCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for AttachedFile.
func (c *AttachedFileClient) Update() *AttachedFileUpdate {
	mutation := newAttachedFileMutation(c.config, OpUpdate)
	return &AttachedFileUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *AttachedFileClient) UpdateOne(af *AttachedFile) *AttachedFileUpdateOne {
	mutation := newAttachedFileMutation(c.config, OpUpdateOne, withAttachedFile(af))
	return &AttachedFileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *AttachedFileClient) UpdateOneID(id int) *AttachedFileUpdateOne {
	mutation := newAttachedFileMutation(c.config, OpUpdateOne, withAttachedFileID(id))
	return &AttachedFileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for AttachedFile.
func (c *AttachedFileClient) Delete() *AttachedFileDelete {
	mutation := newAttachedFileMutation(c.config, OpDelete)
	return &AttachedFileDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *AttachedFileClient) DeleteOne(af *AttachedFile) *AttachedFileDeleteOne {
	return c.DeleteOneID(af.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *AttachedFileClient) DeleteOneID(id int) *AttachedFileDeleteOne {
	builder := c.Delete().Where(attachedfile.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &AttachedFileDeleteOne{builder}
}

// Query returns a query builder for AttachedFile.
func (c *AttachedFileClient) Query() *AttachedFileQuery {
	return &AttachedFileQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeAttachedFile},
		inters: c.Interceptors(),
	}
}

// Get returns a AttachedFile entity by its id.
func (c *AttachedFileClient) Get(ctx context.Context, id int) (*AttachedFile, error) {
	return c.Query().Where(attachedfile.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *AttachedFileClient) GetX(ctx context.Context, id int) *AttachedFile {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryFi queries the fi edge of a AttachedFile.
func (c *AttachedFileClient) QueryFi(af *AttachedFile) *FileQuery {
	query := (&FileClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := af.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(attachedfile.Table, attachedfile.FieldID, id),
			sqlgraph.To(file.Table, file.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, attachedfile.FiTable, attachedfile.FiColumn),
		)
		fromV = sqlgraph.Neighbors(af.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryProc queries the proc edge of a AttachedFile.
func (c *AttachedFileClient) QueryProc(af *AttachedFile) *ProcessQuery {
	query := (&ProcessClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := af.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(attachedfile.Table, attachedfile.FieldID, id),
			sqlgraph.To(process.Table, process.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, attachedfile.ProcTable, attachedfile.ProcColumn),
		)
		fromV = sqlgraph.Neighbors(af.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *AttachedFileClient) Hooks() []Hook {
	return c.hooks.AttachedFile
}

// Interceptors returns the client interceptors.
func (c *AttachedFileClient) Interceptors() []Interceptor {
	return c.inters.AttachedFile
}

func (c *AttachedFileClient) mutate(ctx context.Context, m *AttachedFileMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&AttachedFileCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&AttachedFileUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&AttachedFileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&AttachedFileDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown AttachedFile mutation op: %q", m.Op())
	}
}

// FileClient is a client for the File schema.
type FileClient struct {
	config
}

// NewFileClient returns a client for the File from the given config.
func NewFileClient(c config) *FileClient {
	return &FileClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `file.Hooks(f(g(h())))`.
func (c *FileClient) Use(hooks ...Hook) {
	c.hooks.File = append(c.hooks.File, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `file.Intercept(f(g(h())))`.
func (c *FileClient) Intercept(interceptors ...Interceptor) {
	c.inters.File = append(c.inters.File, interceptors...)
}

// Create returns a builder for creating a File entity.
func (c *FileClient) Create() *FileCreate {
	mutation := newFileMutation(c.config, OpCreate)
	return &FileCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of File entities.
func (c *FileClient) CreateBulk(builders ...*FileCreate) *FileCreateBulk {
	return &FileCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *FileClient) MapCreateBulk(slice any, setFunc func(*FileCreate, int)) *FileCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &FileCreateBulk{err: fmt.Errorf("calling to FileClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*FileCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &FileCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for File.
func (c *FileClient) Update() *FileUpdate {
	mutation := newFileMutation(c.config, OpUpdate)
	return &FileUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *FileClient) UpdateOne(f *File) *FileUpdateOne {
	mutation := newFileMutation(c.config, OpUpdateOne, withFile(f))
	return &FileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *FileClient) UpdateOneID(id int) *FileUpdateOne {
	mutation := newFileMutation(c.config, OpUpdateOne, withFileID(id))
	return &FileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for File.
func (c *FileClient) Delete() *FileDelete {
	mutation := newFileMutation(c.config, OpDelete)
	return &FileDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *FileClient) DeleteOne(f *File) *FileDeleteOne {
	return c.DeleteOneID(f.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *FileClient) DeleteOneID(id int) *FileDeleteOne {
	builder := c.Delete().Where(file.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &FileDeleteOne{builder}
}

// Query returns a query builder for File.
func (c *FileClient) Query() *FileQuery {
	return &FileQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeFile},
		inters: c.Interceptors(),
	}
}

// Get returns a File entity by its id.
func (c *FileClient) Get(ctx context.Context, id int) (*File, error) {
	return c.Query().Where(file.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *FileClient) GetX(ctx context.Context, id int) *File {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryProcesses queries the processes edge of a File.
func (c *FileClient) QueryProcesses(f *File) *ProcessQuery {
	query := (&ProcessClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := f.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(file.Table, file.FieldID, id),
			sqlgraph.To(process.Table, process.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, file.ProcessesTable, file.ProcessesPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(f.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *FileClient) Hooks() []Hook {
	return c.hooks.File
}

// Interceptors returns the client interceptors.
func (c *FileClient) Interceptors() []Interceptor {
	return c.inters.File
}

func (c *FileClient) mutate(ctx context.Context, m *FileMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&FileCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&FileUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&FileUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&FileDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown File mutation op: %q", m.Op())
	}
}

// FriendshipClient is a client for the Friendship schema.
type FriendshipClient struct {
	config
}

// NewFriendshipClient returns a client for the Friendship from the given config.
func NewFriendshipClient(c config) *FriendshipClient {
	return &FriendshipClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `friendship.Hooks(f(g(h())))`.
func (c *FriendshipClient) Use(hooks ...Hook) {
	c.hooks.Friendship = append(c.hooks.Friendship, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `friendship.Intercept(f(g(h())))`.
func (c *FriendshipClient) Intercept(interceptors ...Interceptor) {
	c.inters.Friendship = append(c.inters.Friendship, interceptors...)
}

// Create returns a builder for creating a Friendship entity.
func (c *FriendshipClient) Create() *FriendshipCreate {
	mutation := newFriendshipMutation(c.config, OpCreate)
	return &FriendshipCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Friendship entities.
func (c *FriendshipClient) CreateBulk(builders ...*FriendshipCreate) *FriendshipCreateBulk {
	return &FriendshipCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *FriendshipClient) MapCreateBulk(slice any, setFunc func(*FriendshipCreate, int)) *FriendshipCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &FriendshipCreateBulk{err: fmt.Errorf("calling to FriendshipClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*FriendshipCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &FriendshipCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Friendship.
func (c *FriendshipClient) Update() *FriendshipUpdate {
	mutation := newFriendshipMutation(c.config, OpUpdate)
	return &FriendshipUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *FriendshipClient) UpdateOne(f *Friendship) *FriendshipUpdateOne {
	mutation := newFriendshipMutation(c.config, OpUpdateOne, withFriendship(f))
	return &FriendshipUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *FriendshipClient) UpdateOneID(id int) *FriendshipUpdateOne {
	mutation := newFriendshipMutation(c.config, OpUpdateOne, withFriendshipID(id))
	return &FriendshipUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Friendship.
func (c *FriendshipClient) Delete() *FriendshipDelete {
	mutation := newFriendshipMutation(c.config, OpDelete)
	return &FriendshipDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *FriendshipClient) DeleteOne(f *Friendship) *FriendshipDeleteOne {
	return c.DeleteOneID(f.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *FriendshipClient) DeleteOneID(id int) *FriendshipDeleteOne {
	builder := c.Delete().Where(friendship.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &FriendshipDeleteOne{builder}
}

// Query returns a query builder for Friendship.
func (c *FriendshipClient) Query() *FriendshipQuery {
	return &FriendshipQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeFriendship},
		inters: c.Interceptors(),
	}
}

// Get returns a Friendship entity by its id.
func (c *FriendshipClient) Get(ctx context.Context, id int) (*Friendship, error) {
	return c.Query().Where(friendship.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *FriendshipClient) GetX(ctx context.Context, id int) *Friendship {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryUser queries the user edge of a Friendship.
func (c *FriendshipClient) QueryUser(f *Friendship) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := f.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(friendship.Table, friendship.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, friendship.UserTable, friendship.UserColumn),
		)
		fromV = sqlgraph.Neighbors(f.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryFriend queries the friend edge of a Friendship.
func (c *FriendshipClient) QueryFriend(f *Friendship) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := f.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(friendship.Table, friendship.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, friendship.FriendTable, friendship.FriendColumn),
		)
		fromV = sqlgraph.Neighbors(f.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *FriendshipClient) Hooks() []Hook {
	return c.hooks.Friendship
}

// Interceptors returns the client interceptors.
func (c *FriendshipClient) Interceptors() []Interceptor {
	return c.inters.Friendship
}

func (c *FriendshipClient) mutate(ctx context.Context, m *FriendshipMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&FriendshipCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&FriendshipUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&FriendshipUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&FriendshipDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Friendship mutation op: %q", m.Op())
	}
}

// GroupClient is a client for the Group schema.
type GroupClient struct {
	config
}

// NewGroupClient returns a client for the Group from the given config.
func NewGroupClient(c config) *GroupClient {
	return &GroupClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `group.Hooks(f(g(h())))`.
func (c *GroupClient) Use(hooks ...Hook) {
	c.hooks.Group = append(c.hooks.Group, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `group.Intercept(f(g(h())))`.
func (c *GroupClient) Intercept(interceptors ...Interceptor) {
	c.inters.Group = append(c.inters.Group, interceptors...)
}

// Create returns a builder for creating a Group entity.
func (c *GroupClient) Create() *GroupCreate {
	mutation := newGroupMutation(c.config, OpCreate)
	return &GroupCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Group entities.
func (c *GroupClient) CreateBulk(builders ...*GroupCreate) *GroupCreateBulk {
	return &GroupCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *GroupClient) MapCreateBulk(slice any, setFunc func(*GroupCreate, int)) *GroupCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &GroupCreateBulk{err: fmt.Errorf("calling to GroupClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*GroupCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &GroupCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Group.
func (c *GroupClient) Update() *GroupUpdate {
	mutation := newGroupMutation(c.config, OpUpdate)
	return &GroupUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *GroupClient) UpdateOne(gr *Group) *GroupUpdateOne {
	mutation := newGroupMutation(c.config, OpUpdateOne, withGroup(gr))
	return &GroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *GroupClient) UpdateOneID(id int) *GroupUpdateOne {
	mutation := newGroupMutation(c.config, OpUpdateOne, withGroupID(id))
	return &GroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Group.
func (c *GroupClient) Delete() *GroupDelete {
	mutation := newGroupMutation(c.config, OpDelete)
	return &GroupDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *GroupClient) DeleteOne(gr *Group) *GroupDeleteOne {
	return c.DeleteOneID(gr.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *GroupClient) DeleteOneID(id int) *GroupDeleteOne {
	builder := c.Delete().Where(group.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &GroupDeleteOne{builder}
}

// Query returns a query builder for Group.
func (c *GroupClient) Query() *GroupQuery {
	return &GroupQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeGroup},
		inters: c.Interceptors(),
	}
}

// Get returns a Group entity by its id.
func (c *GroupClient) Get(ctx context.Context, id int) (*Group, error) {
	return c.Query().Where(group.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *GroupClient) GetX(ctx context.Context, id int) *Group {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryUsers queries the users edge of a Group.
func (c *GroupClient) QueryUsers(gr *Group) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := gr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(group.Table, group.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, group.UsersTable, group.UsersPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(gr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryTags queries the tags edge of a Group.
func (c *GroupClient) QueryTags(gr *Group) *TagQuery {
	query := (&TagClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := gr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(group.Table, group.FieldID, id),
			sqlgraph.To(tag.Table, tag.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, group.TagsTable, group.TagsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(gr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryJoinedUsers queries the joined_users edge of a Group.
func (c *GroupClient) QueryJoinedUsers(gr *Group) *UserGroupQuery {
	query := (&UserGroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := gr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(group.Table, group.FieldID, id),
			sqlgraph.To(usergroup.Table, usergroup.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, group.JoinedUsersTable, group.JoinedUsersColumn),
		)
		fromV = sqlgraph.Neighbors(gr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryGroupTags queries the group_tags edge of a Group.
func (c *GroupClient) QueryGroupTags(gr *Group) *GroupTagQuery {
	query := (&GroupTagClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := gr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(group.Table, group.FieldID, id),
			sqlgraph.To(grouptag.Table, grouptag.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, group.GroupTagsTable, group.GroupTagsColumn),
		)
		fromV = sqlgraph.Neighbors(gr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *GroupClient) Hooks() []Hook {
	return c.hooks.Group
}

// Interceptors returns the client interceptors.
func (c *GroupClient) Interceptors() []Interceptor {
	return c.inters.Group
}

func (c *GroupClient) mutate(ctx context.Context, m *GroupMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&GroupCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&GroupUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&GroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&GroupDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Group mutation op: %q", m.Op())
	}
}

// GroupTagClient is a client for the GroupTag schema.
type GroupTagClient struct {
	config
}

// NewGroupTagClient returns a client for the GroupTag from the given config.
func NewGroupTagClient(c config) *GroupTagClient {
	return &GroupTagClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `grouptag.Hooks(f(g(h())))`.
func (c *GroupTagClient) Use(hooks ...Hook) {
	c.hooks.GroupTag = append(c.hooks.GroupTag, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `grouptag.Intercept(f(g(h())))`.
func (c *GroupTagClient) Intercept(interceptors ...Interceptor) {
	c.inters.GroupTag = append(c.inters.GroupTag, interceptors...)
}

// Create returns a builder for creating a GroupTag entity.
func (c *GroupTagClient) Create() *GroupTagCreate {
	mutation := newGroupTagMutation(c.config, OpCreate)
	return &GroupTagCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of GroupTag entities.
func (c *GroupTagClient) CreateBulk(builders ...*GroupTagCreate) *GroupTagCreateBulk {
	return &GroupTagCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *GroupTagClient) MapCreateBulk(slice any, setFunc func(*GroupTagCreate, int)) *GroupTagCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &GroupTagCreateBulk{err: fmt.Errorf("calling to GroupTagClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*GroupTagCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &GroupTagCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for GroupTag.
func (c *GroupTagClient) Update() *GroupTagUpdate {
	mutation := newGroupTagMutation(c.config, OpUpdate)
	return &GroupTagUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *GroupTagClient) UpdateOne(gt *GroupTag) *GroupTagUpdateOne {
	mutation := newGroupTagMutation(c.config, OpUpdateOne, withGroupTag(gt))
	return &GroupTagUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *GroupTagClient) UpdateOneID(id int) *GroupTagUpdateOne {
	mutation := newGroupTagMutation(c.config, OpUpdateOne, withGroupTagID(id))
	return &GroupTagUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for GroupTag.
func (c *GroupTagClient) Delete() *GroupTagDelete {
	mutation := newGroupTagMutation(c.config, OpDelete)
	return &GroupTagDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *GroupTagClient) DeleteOne(gt *GroupTag) *GroupTagDeleteOne {
	return c.DeleteOneID(gt.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *GroupTagClient) DeleteOneID(id int) *GroupTagDeleteOne {
	builder := c.Delete().Where(grouptag.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &GroupTagDeleteOne{builder}
}

// Query returns a query builder for GroupTag.
func (c *GroupTagClient) Query() *GroupTagQuery {
	return &GroupTagQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeGroupTag},
		inters: c.Interceptors(),
	}
}

// Get returns a GroupTag entity by its id.
func (c *GroupTagClient) Get(ctx context.Context, id int) (*GroupTag, error) {
	return c.Query().Where(grouptag.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *GroupTagClient) GetX(ctx context.Context, id int) *GroupTag {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryTag queries the tag edge of a GroupTag.
func (c *GroupTagClient) QueryTag(gt *GroupTag) *TagQuery {
	query := (&TagClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := gt.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(grouptag.Table, grouptag.FieldID, id),
			sqlgraph.To(tag.Table, tag.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, grouptag.TagTable, grouptag.TagColumn),
		)
		fromV = sqlgraph.Neighbors(gt.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryGroup queries the group edge of a GroupTag.
func (c *GroupTagClient) QueryGroup(gt *GroupTag) *GroupQuery {
	query := (&GroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := gt.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(grouptag.Table, grouptag.FieldID, id),
			sqlgraph.To(group.Table, group.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, grouptag.GroupTable, grouptag.GroupColumn),
		)
		fromV = sqlgraph.Neighbors(gt.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *GroupTagClient) Hooks() []Hook {
	return c.hooks.GroupTag
}

// Interceptors returns the client interceptors.
func (c *GroupTagClient) Interceptors() []Interceptor {
	return c.inters.GroupTag
}

func (c *GroupTagClient) mutate(ctx context.Context, m *GroupTagMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&GroupTagCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&GroupTagUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&GroupTagUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&GroupTagDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown GroupTag mutation op: %q", m.Op())
	}
}

// ProcessClient is a client for the Process schema.
type ProcessClient struct {
	config
}

// NewProcessClient returns a client for the Process from the given config.
func NewProcessClient(c config) *ProcessClient {
	return &ProcessClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `process.Hooks(f(g(h())))`.
func (c *ProcessClient) Use(hooks ...Hook) {
	c.hooks.Process = append(c.hooks.Process, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `process.Intercept(f(g(h())))`.
func (c *ProcessClient) Intercept(interceptors ...Interceptor) {
	c.inters.Process = append(c.inters.Process, interceptors...)
}

// Create returns a builder for creating a Process entity.
func (c *ProcessClient) Create() *ProcessCreate {
	mutation := newProcessMutation(c.config, OpCreate)
	return &ProcessCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Process entities.
func (c *ProcessClient) CreateBulk(builders ...*ProcessCreate) *ProcessCreateBulk {
	return &ProcessCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *ProcessClient) MapCreateBulk(slice any, setFunc func(*ProcessCreate, int)) *ProcessCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &ProcessCreateBulk{err: fmt.Errorf("calling to ProcessClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*ProcessCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &ProcessCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Process.
func (c *ProcessClient) Update() *ProcessUpdate {
	mutation := newProcessMutation(c.config, OpUpdate)
	return &ProcessUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *ProcessClient) UpdateOne(pr *Process) *ProcessUpdateOne {
	mutation := newProcessMutation(c.config, OpUpdateOne, withProcess(pr))
	return &ProcessUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *ProcessClient) UpdateOneID(id int) *ProcessUpdateOne {
	mutation := newProcessMutation(c.config, OpUpdateOne, withProcessID(id))
	return &ProcessUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Process.
func (c *ProcessClient) Delete() *ProcessDelete {
	mutation := newProcessMutation(c.config, OpDelete)
	return &ProcessDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *ProcessClient) DeleteOne(pr *Process) *ProcessDeleteOne {
	return c.DeleteOneID(pr.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *ProcessClient) DeleteOneID(id int) *ProcessDeleteOne {
	builder := c.Delete().Where(process.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &ProcessDeleteOne{builder}
}

// Query returns a query builder for Process.
func (c *ProcessClient) Query() *ProcessQuery {
	return &ProcessQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeProcess},
		inters: c.Interceptors(),
	}
}

// Get returns a Process entity by its id.
func (c *ProcessClient) Get(ctx context.Context, id int) (*Process, error) {
	return c.Query().Where(process.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *ProcessClient) GetX(ctx context.Context, id int) *Process {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryFiles queries the files edge of a Process.
func (c *ProcessClient) QueryFiles(pr *Process) *FileQuery {
	query := (&FileClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := pr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(process.Table, process.FieldID, id),
			sqlgraph.To(file.Table, file.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, process.FilesTable, process.FilesPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(pr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryAttachedFiles queries the attached_files edge of a Process.
func (c *ProcessClient) QueryAttachedFiles(pr *Process) *AttachedFileQuery {
	query := (&AttachedFileClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := pr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(process.Table, process.FieldID, id),
			sqlgraph.To(attachedfile.Table, attachedfile.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, process.AttachedFilesTable, process.AttachedFilesColumn),
		)
		fromV = sqlgraph.Neighbors(pr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *ProcessClient) Hooks() []Hook {
	return c.hooks.Process
}

// Interceptors returns the client interceptors.
func (c *ProcessClient) Interceptors() []Interceptor {
	return c.inters.Process
}

func (c *ProcessClient) mutate(ctx context.Context, m *ProcessMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&ProcessCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&ProcessUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&ProcessUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&ProcessDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Process mutation op: %q", m.Op())
	}
}

// RelationshipClient is a client for the Relationship schema.
type RelationshipClient struct {
	config
}

// NewRelationshipClient returns a client for the Relationship from the given config.
func NewRelationshipClient(c config) *RelationshipClient {
	return &RelationshipClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `relationship.Hooks(f(g(h())))`.
func (c *RelationshipClient) Use(hooks ...Hook) {
	c.hooks.Relationship = append(c.hooks.Relationship, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `relationship.Intercept(f(g(h())))`.
func (c *RelationshipClient) Intercept(interceptors ...Interceptor) {
	c.inters.Relationship = append(c.inters.Relationship, interceptors...)
}

// Create returns a builder for creating a Relationship entity.
func (c *RelationshipClient) Create() *RelationshipCreate {
	mutation := newRelationshipMutation(c.config, OpCreate)
	return &RelationshipCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Relationship entities.
func (c *RelationshipClient) CreateBulk(builders ...*RelationshipCreate) *RelationshipCreateBulk {
	return &RelationshipCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *RelationshipClient) MapCreateBulk(slice any, setFunc func(*RelationshipCreate, int)) *RelationshipCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &RelationshipCreateBulk{err: fmt.Errorf("calling to RelationshipClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*RelationshipCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &RelationshipCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Relationship.
func (c *RelationshipClient) Update() *RelationshipUpdate {
	mutation := newRelationshipMutation(c.config, OpUpdate)
	return &RelationshipUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *RelationshipClient) UpdateOne(r *Relationship) *RelationshipUpdateOne {
	mutation := newRelationshipMutation(c.config, OpUpdateOne)
	mutation.user = &r.UserID
	mutation.relative = &r.RelativeID
	return &RelationshipUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Relationship.
func (c *RelationshipClient) Delete() *RelationshipDelete {
	mutation := newRelationshipMutation(c.config, OpDelete)
	return &RelationshipDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Query returns a query builder for Relationship.
func (c *RelationshipClient) Query() *RelationshipQuery {
	return &RelationshipQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeRelationship},
		inters: c.Interceptors(),
	}
}

// QueryUser queries the user edge of a Relationship.
func (c *RelationshipClient) QueryUser(r *Relationship) *UserQuery {
	return c.Query().
		Where(relationship.UserID(r.UserID), relationship.RelativeID(r.RelativeID)).
		QueryUser()
}

// QueryRelative queries the relative edge of a Relationship.
func (c *RelationshipClient) QueryRelative(r *Relationship) *UserQuery {
	return c.Query().
		Where(relationship.UserID(r.UserID), relationship.RelativeID(r.RelativeID)).
		QueryRelative()
}

// QueryInfo queries the info edge of a Relationship.
func (c *RelationshipClient) QueryInfo(r *Relationship) *RelationshipInfoQuery {
	return c.Query().
		Where(relationship.UserID(r.UserID), relationship.RelativeID(r.RelativeID)).
		QueryInfo()
}

// Hooks returns the client hooks.
func (c *RelationshipClient) Hooks() []Hook {
	hooks := c.hooks.Relationship
	return append(hooks[:len(hooks):len(hooks)], relationship.Hooks[:]...)
}

// Interceptors returns the client interceptors.
func (c *RelationshipClient) Interceptors() []Interceptor {
	return c.inters.Relationship
}

func (c *RelationshipClient) mutate(ctx context.Context, m *RelationshipMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&RelationshipCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&RelationshipUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&RelationshipUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&RelationshipDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Relationship mutation op: %q", m.Op())
	}
}

// RelationshipInfoClient is a client for the RelationshipInfo schema.
type RelationshipInfoClient struct {
	config
}

// NewRelationshipInfoClient returns a client for the RelationshipInfo from the given config.
func NewRelationshipInfoClient(c config) *RelationshipInfoClient {
	return &RelationshipInfoClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `relationshipinfo.Hooks(f(g(h())))`.
func (c *RelationshipInfoClient) Use(hooks ...Hook) {
	c.hooks.RelationshipInfo = append(c.hooks.RelationshipInfo, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `relationshipinfo.Intercept(f(g(h())))`.
func (c *RelationshipInfoClient) Intercept(interceptors ...Interceptor) {
	c.inters.RelationshipInfo = append(c.inters.RelationshipInfo, interceptors...)
}

// Create returns a builder for creating a RelationshipInfo entity.
func (c *RelationshipInfoClient) Create() *RelationshipInfoCreate {
	mutation := newRelationshipInfoMutation(c.config, OpCreate)
	return &RelationshipInfoCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of RelationshipInfo entities.
func (c *RelationshipInfoClient) CreateBulk(builders ...*RelationshipInfoCreate) *RelationshipInfoCreateBulk {
	return &RelationshipInfoCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *RelationshipInfoClient) MapCreateBulk(slice any, setFunc func(*RelationshipInfoCreate, int)) *RelationshipInfoCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &RelationshipInfoCreateBulk{err: fmt.Errorf("calling to RelationshipInfoClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*RelationshipInfoCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &RelationshipInfoCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for RelationshipInfo.
func (c *RelationshipInfoClient) Update() *RelationshipInfoUpdate {
	mutation := newRelationshipInfoMutation(c.config, OpUpdate)
	return &RelationshipInfoUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *RelationshipInfoClient) UpdateOne(ri *RelationshipInfo) *RelationshipInfoUpdateOne {
	mutation := newRelationshipInfoMutation(c.config, OpUpdateOne, withRelationshipInfo(ri))
	return &RelationshipInfoUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *RelationshipInfoClient) UpdateOneID(id int) *RelationshipInfoUpdateOne {
	mutation := newRelationshipInfoMutation(c.config, OpUpdateOne, withRelationshipInfoID(id))
	return &RelationshipInfoUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for RelationshipInfo.
func (c *RelationshipInfoClient) Delete() *RelationshipInfoDelete {
	mutation := newRelationshipInfoMutation(c.config, OpDelete)
	return &RelationshipInfoDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *RelationshipInfoClient) DeleteOne(ri *RelationshipInfo) *RelationshipInfoDeleteOne {
	return c.DeleteOneID(ri.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *RelationshipInfoClient) DeleteOneID(id int) *RelationshipInfoDeleteOne {
	builder := c.Delete().Where(relationshipinfo.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &RelationshipInfoDeleteOne{builder}
}

// Query returns a query builder for RelationshipInfo.
func (c *RelationshipInfoClient) Query() *RelationshipInfoQuery {
	return &RelationshipInfoQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeRelationshipInfo},
		inters: c.Interceptors(),
	}
}

// Get returns a RelationshipInfo entity by its id.
func (c *RelationshipInfoClient) Get(ctx context.Context, id int) (*RelationshipInfo, error) {
	return c.Query().Where(relationshipinfo.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *RelationshipInfoClient) GetX(ctx context.Context, id int) *RelationshipInfo {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *RelationshipInfoClient) Hooks() []Hook {
	return c.hooks.RelationshipInfo
}

// Interceptors returns the client interceptors.
func (c *RelationshipInfoClient) Interceptors() []Interceptor {
	return c.inters.RelationshipInfo
}

func (c *RelationshipInfoClient) mutate(ctx context.Context, m *RelationshipInfoMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&RelationshipInfoCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&RelationshipInfoUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&RelationshipInfoUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&RelationshipInfoDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown RelationshipInfo mutation op: %q", m.Op())
	}
}

// RoleClient is a client for the Role schema.
type RoleClient struct {
	config
}

// NewRoleClient returns a client for the Role from the given config.
func NewRoleClient(c config) *RoleClient {
	return &RoleClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `role.Hooks(f(g(h())))`.
func (c *RoleClient) Use(hooks ...Hook) {
	c.hooks.Role = append(c.hooks.Role, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `role.Intercept(f(g(h())))`.
func (c *RoleClient) Intercept(interceptors ...Interceptor) {
	c.inters.Role = append(c.inters.Role, interceptors...)
}

// Create returns a builder for creating a Role entity.
func (c *RoleClient) Create() *RoleCreate {
	mutation := newRoleMutation(c.config, OpCreate)
	return &RoleCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Role entities.
func (c *RoleClient) CreateBulk(builders ...*RoleCreate) *RoleCreateBulk {
	return &RoleCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *RoleClient) MapCreateBulk(slice any, setFunc func(*RoleCreate, int)) *RoleCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &RoleCreateBulk{err: fmt.Errorf("calling to RoleClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*RoleCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &RoleCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Role.
func (c *RoleClient) Update() *RoleUpdate {
	mutation := newRoleMutation(c.config, OpUpdate)
	return &RoleUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *RoleClient) UpdateOne(r *Role) *RoleUpdateOne {
	mutation := newRoleMutation(c.config, OpUpdateOne, withRole(r))
	return &RoleUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *RoleClient) UpdateOneID(id int) *RoleUpdateOne {
	mutation := newRoleMutation(c.config, OpUpdateOne, withRoleID(id))
	return &RoleUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Role.
func (c *RoleClient) Delete() *RoleDelete {
	mutation := newRoleMutation(c.config, OpDelete)
	return &RoleDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *RoleClient) DeleteOne(r *Role) *RoleDeleteOne {
	return c.DeleteOneID(r.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *RoleClient) DeleteOneID(id int) *RoleDeleteOne {
	builder := c.Delete().Where(role.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &RoleDeleteOne{builder}
}

// Query returns a query builder for Role.
func (c *RoleClient) Query() *RoleQuery {
	return &RoleQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeRole},
		inters: c.Interceptors(),
	}
}

// Get returns a Role entity by its id.
func (c *RoleClient) Get(ctx context.Context, id int) (*Role, error) {
	return c.Query().Where(role.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *RoleClient) GetX(ctx context.Context, id int) *Role {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryUser queries the user edge of a Role.
func (c *RoleClient) QueryUser(r *Role) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := r.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(role.Table, role.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, role.UserTable, role.UserPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(r.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryRolesUsers queries the roles_users edge of a Role.
func (c *RoleClient) QueryRolesUsers(r *Role) *RoleUserQuery {
	query := (&RoleUserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := r.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(role.Table, role.FieldID, id),
			sqlgraph.To(roleuser.Table, roleuser.RoleColumn),
			sqlgraph.Edge(sqlgraph.O2M, true, role.RolesUsersTable, role.RolesUsersColumn),
		)
		fromV = sqlgraph.Neighbors(r.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *RoleClient) Hooks() []Hook {
	return c.hooks.Role
}

// Interceptors returns the client interceptors.
func (c *RoleClient) Interceptors() []Interceptor {
	return c.inters.Role
}

func (c *RoleClient) mutate(ctx context.Context, m *RoleMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&RoleCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&RoleUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&RoleUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&RoleDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Role mutation op: %q", m.Op())
	}
}

// RoleUserClient is a client for the RoleUser schema.
type RoleUserClient struct {
	config
}

// NewRoleUserClient returns a client for the RoleUser from the given config.
func NewRoleUserClient(c config) *RoleUserClient {
	return &RoleUserClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `roleuser.Hooks(f(g(h())))`.
func (c *RoleUserClient) Use(hooks ...Hook) {
	c.hooks.RoleUser = append(c.hooks.RoleUser, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `roleuser.Intercept(f(g(h())))`.
func (c *RoleUserClient) Intercept(interceptors ...Interceptor) {
	c.inters.RoleUser = append(c.inters.RoleUser, interceptors...)
}

// Create returns a builder for creating a RoleUser entity.
func (c *RoleUserClient) Create() *RoleUserCreate {
	mutation := newRoleUserMutation(c.config, OpCreate)
	return &RoleUserCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of RoleUser entities.
func (c *RoleUserClient) CreateBulk(builders ...*RoleUserCreate) *RoleUserCreateBulk {
	return &RoleUserCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *RoleUserClient) MapCreateBulk(slice any, setFunc func(*RoleUserCreate, int)) *RoleUserCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &RoleUserCreateBulk{err: fmt.Errorf("calling to RoleUserClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*RoleUserCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &RoleUserCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for RoleUser.
func (c *RoleUserClient) Update() *RoleUserUpdate {
	mutation := newRoleUserMutation(c.config, OpUpdate)
	return &RoleUserUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *RoleUserClient) UpdateOne(ru *RoleUser) *RoleUserUpdateOne {
	mutation := newRoleUserMutation(c.config, OpUpdateOne)
	mutation.user = &ru.UserID
	mutation.role = &ru.RoleID
	return &RoleUserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for RoleUser.
func (c *RoleUserClient) Delete() *RoleUserDelete {
	mutation := newRoleUserMutation(c.config, OpDelete)
	return &RoleUserDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Query returns a query builder for RoleUser.
func (c *RoleUserClient) Query() *RoleUserQuery {
	return &RoleUserQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeRoleUser},
		inters: c.Interceptors(),
	}
}

// QueryRole queries the role edge of a RoleUser.
func (c *RoleUserClient) QueryRole(ru *RoleUser) *RoleQuery {
	return c.Query().
		Where(roleuser.UserID(ru.UserID), roleuser.RoleID(ru.RoleID)).
		QueryRole()
}

// QueryUser queries the user edge of a RoleUser.
func (c *RoleUserClient) QueryUser(ru *RoleUser) *UserQuery {
	return c.Query().
		Where(roleuser.UserID(ru.UserID), roleuser.RoleID(ru.RoleID)).
		QueryUser()
}

// Hooks returns the client hooks.
func (c *RoleUserClient) Hooks() []Hook {
	return c.hooks.RoleUser
}

// Interceptors returns the client interceptors.
func (c *RoleUserClient) Interceptors() []Interceptor {
	return c.inters.RoleUser
}

func (c *RoleUserClient) mutate(ctx context.Context, m *RoleUserMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&RoleUserCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&RoleUserUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&RoleUserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&RoleUserDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown RoleUser mutation op: %q", m.Op())
	}
}

// TagClient is a client for the Tag schema.
type TagClient struct {
	config
}

// NewTagClient returns a client for the Tag from the given config.
func NewTagClient(c config) *TagClient {
	return &TagClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `tag.Hooks(f(g(h())))`.
func (c *TagClient) Use(hooks ...Hook) {
	c.hooks.Tag = append(c.hooks.Tag, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `tag.Intercept(f(g(h())))`.
func (c *TagClient) Intercept(interceptors ...Interceptor) {
	c.inters.Tag = append(c.inters.Tag, interceptors...)
}

// Create returns a builder for creating a Tag entity.
func (c *TagClient) Create() *TagCreate {
	mutation := newTagMutation(c.config, OpCreate)
	return &TagCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Tag entities.
func (c *TagClient) CreateBulk(builders ...*TagCreate) *TagCreateBulk {
	return &TagCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *TagClient) MapCreateBulk(slice any, setFunc func(*TagCreate, int)) *TagCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &TagCreateBulk{err: fmt.Errorf("calling to TagClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*TagCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &TagCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Tag.
func (c *TagClient) Update() *TagUpdate {
	mutation := newTagMutation(c.config, OpUpdate)
	return &TagUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *TagClient) UpdateOne(t *Tag) *TagUpdateOne {
	mutation := newTagMutation(c.config, OpUpdateOne, withTag(t))
	return &TagUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *TagClient) UpdateOneID(id int) *TagUpdateOne {
	mutation := newTagMutation(c.config, OpUpdateOne, withTagID(id))
	return &TagUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Tag.
func (c *TagClient) Delete() *TagDelete {
	mutation := newTagMutation(c.config, OpDelete)
	return &TagDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *TagClient) DeleteOne(t *Tag) *TagDeleteOne {
	return c.DeleteOneID(t.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *TagClient) DeleteOneID(id int) *TagDeleteOne {
	builder := c.Delete().Where(tag.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &TagDeleteOne{builder}
}

// Query returns a query builder for Tag.
func (c *TagClient) Query() *TagQuery {
	return &TagQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeTag},
		inters: c.Interceptors(),
	}
}

// Get returns a Tag entity by its id.
func (c *TagClient) Get(ctx context.Context, id int) (*Tag, error) {
	return c.Query().Where(tag.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *TagClient) GetX(ctx context.Context, id int) *Tag {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryTweets queries the tweets edge of a Tag.
func (c *TagClient) QueryTweets(t *Tag) *TweetQuery {
	query := (&TweetClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tag.Table, tag.FieldID, id),
			sqlgraph.To(tweet.Table, tweet.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, tag.TweetsTable, tag.TweetsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryGroups queries the groups edge of a Tag.
func (c *TagClient) QueryGroups(t *Tag) *GroupQuery {
	query := (&GroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tag.Table, tag.FieldID, id),
			sqlgraph.To(group.Table, group.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, tag.GroupsTable, tag.GroupsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryTweetTags queries the tweet_tags edge of a Tag.
func (c *TagClient) QueryTweetTags(t *Tag) *TweetTagQuery {
	query := (&TweetTagClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tag.Table, tag.FieldID, id),
			sqlgraph.To(tweettag.Table, tweettag.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, tag.TweetTagsTable, tag.TweetTagsColumn),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryGroupTags queries the group_tags edge of a Tag.
func (c *TagClient) QueryGroupTags(t *Tag) *GroupTagQuery {
	query := (&GroupTagClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tag.Table, tag.FieldID, id),
			sqlgraph.To(grouptag.Table, grouptag.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, tag.GroupTagsTable, tag.GroupTagsColumn),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *TagClient) Hooks() []Hook {
	return c.hooks.Tag
}

// Interceptors returns the client interceptors.
func (c *TagClient) Interceptors() []Interceptor {
	return c.inters.Tag
}

func (c *TagClient) mutate(ctx context.Context, m *TagMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&TagCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&TagUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&TagUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&TagDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Tag mutation op: %q", m.Op())
	}
}

// TweetClient is a client for the Tweet schema.
type TweetClient struct {
	config
}

// NewTweetClient returns a client for the Tweet from the given config.
func NewTweetClient(c config) *TweetClient {
	return &TweetClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `tweet.Hooks(f(g(h())))`.
func (c *TweetClient) Use(hooks ...Hook) {
	c.hooks.Tweet = append(c.hooks.Tweet, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `tweet.Intercept(f(g(h())))`.
func (c *TweetClient) Intercept(interceptors ...Interceptor) {
	c.inters.Tweet = append(c.inters.Tweet, interceptors...)
}

// Create returns a builder for creating a Tweet entity.
func (c *TweetClient) Create() *TweetCreate {
	mutation := newTweetMutation(c.config, OpCreate)
	return &TweetCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Tweet entities.
func (c *TweetClient) CreateBulk(builders ...*TweetCreate) *TweetCreateBulk {
	return &TweetCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *TweetClient) MapCreateBulk(slice any, setFunc func(*TweetCreate, int)) *TweetCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &TweetCreateBulk{err: fmt.Errorf("calling to TweetClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*TweetCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &TweetCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Tweet.
func (c *TweetClient) Update() *TweetUpdate {
	mutation := newTweetMutation(c.config, OpUpdate)
	return &TweetUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *TweetClient) UpdateOne(t *Tweet) *TweetUpdateOne {
	mutation := newTweetMutation(c.config, OpUpdateOne, withTweet(t))
	return &TweetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *TweetClient) UpdateOneID(id int) *TweetUpdateOne {
	mutation := newTweetMutation(c.config, OpUpdateOne, withTweetID(id))
	return &TweetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Tweet.
func (c *TweetClient) Delete() *TweetDelete {
	mutation := newTweetMutation(c.config, OpDelete)
	return &TweetDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *TweetClient) DeleteOne(t *Tweet) *TweetDeleteOne {
	return c.DeleteOneID(t.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *TweetClient) DeleteOneID(id int) *TweetDeleteOne {
	builder := c.Delete().Where(tweet.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &TweetDeleteOne{builder}
}

// Query returns a query builder for Tweet.
func (c *TweetClient) Query() *TweetQuery {
	return &TweetQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeTweet},
		inters: c.Interceptors(),
	}
}

// Get returns a Tweet entity by its id.
func (c *TweetClient) Get(ctx context.Context, id int) (*Tweet, error) {
	return c.Query().Where(tweet.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *TweetClient) GetX(ctx context.Context, id int) *Tweet {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryLikedUsers queries the liked_users edge of a Tweet.
func (c *TweetClient) QueryLikedUsers(t *Tweet) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tweet.Table, tweet.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, tweet.LikedUsersTable, tweet.LikedUsersPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUser queries the user edge of a Tweet.
func (c *TweetClient) QueryUser(t *Tweet) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tweet.Table, tweet.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, tweet.UserTable, tweet.UserPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryTags queries the tags edge of a Tweet.
func (c *TweetClient) QueryTags(t *Tweet) *TagQuery {
	query := (&TagClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tweet.Table, tweet.FieldID, id),
			sqlgraph.To(tag.Table, tag.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, tweet.TagsTable, tweet.TagsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryLikes queries the likes edge of a Tweet.
func (c *TweetClient) QueryLikes(t *Tweet) *TweetLikeQuery {
	query := (&TweetLikeClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tweet.Table, tweet.FieldID, id),
			sqlgraph.To(tweetlike.Table, tweetlike.TweetColumn),
			sqlgraph.Edge(sqlgraph.O2M, true, tweet.LikesTable, tweet.LikesColumn),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryTweetUser queries the tweet_user edge of a Tweet.
func (c *TweetClient) QueryTweetUser(t *Tweet) *UserTweetQuery {
	query := (&UserTweetClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tweet.Table, tweet.FieldID, id),
			sqlgraph.To(usertweet.Table, usertweet.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, tweet.TweetUserTable, tweet.TweetUserColumn),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryTweetTags queries the tweet_tags edge of a Tweet.
func (c *TweetClient) QueryTweetTags(t *Tweet) *TweetTagQuery {
	query := (&TweetTagClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tweet.Table, tweet.FieldID, id),
			sqlgraph.To(tweettag.Table, tweettag.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, tweet.TweetTagsTable, tweet.TweetTagsColumn),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *TweetClient) Hooks() []Hook {
	return c.hooks.Tweet
}

// Interceptors returns the client interceptors.
func (c *TweetClient) Interceptors() []Interceptor {
	return c.inters.Tweet
}

func (c *TweetClient) mutate(ctx context.Context, m *TweetMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&TweetCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&TweetUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&TweetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&TweetDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Tweet mutation op: %q", m.Op())
	}
}

// TweetLikeClient is a client for the TweetLike schema.
type TweetLikeClient struct {
	config
}

// NewTweetLikeClient returns a client for the TweetLike from the given config.
func NewTweetLikeClient(c config) *TweetLikeClient {
	return &TweetLikeClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `tweetlike.Hooks(f(g(h())))`.
func (c *TweetLikeClient) Use(hooks ...Hook) {
	c.hooks.TweetLike = append(c.hooks.TweetLike, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `tweetlike.Intercept(f(g(h())))`.
func (c *TweetLikeClient) Intercept(interceptors ...Interceptor) {
	c.inters.TweetLike = append(c.inters.TweetLike, interceptors...)
}

// Create returns a builder for creating a TweetLike entity.
func (c *TweetLikeClient) Create() *TweetLikeCreate {
	mutation := newTweetLikeMutation(c.config, OpCreate)
	return &TweetLikeCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of TweetLike entities.
func (c *TweetLikeClient) CreateBulk(builders ...*TweetLikeCreate) *TweetLikeCreateBulk {
	return &TweetLikeCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *TweetLikeClient) MapCreateBulk(slice any, setFunc func(*TweetLikeCreate, int)) *TweetLikeCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &TweetLikeCreateBulk{err: fmt.Errorf("calling to TweetLikeClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*TweetLikeCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &TweetLikeCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for TweetLike.
func (c *TweetLikeClient) Update() *TweetLikeUpdate {
	mutation := newTweetLikeMutation(c.config, OpUpdate)
	return &TweetLikeUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *TweetLikeClient) UpdateOne(tl *TweetLike) *TweetLikeUpdateOne {
	mutation := newTweetLikeMutation(c.config, OpUpdateOne)
	mutation.user = &tl.UserID
	mutation.tweet = &tl.TweetID
	return &TweetLikeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for TweetLike.
func (c *TweetLikeClient) Delete() *TweetLikeDelete {
	mutation := newTweetLikeMutation(c.config, OpDelete)
	return &TweetLikeDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Query returns a query builder for TweetLike.
func (c *TweetLikeClient) Query() *TweetLikeQuery {
	return &TweetLikeQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeTweetLike},
		inters: c.Interceptors(),
	}
}

// QueryTweet queries the tweet edge of a TweetLike.
func (c *TweetLikeClient) QueryTweet(tl *TweetLike) *TweetQuery {
	return c.Query().
		Where(tweetlike.UserID(tl.UserID), tweetlike.TweetID(tl.TweetID)).
		QueryTweet()
}

// QueryUser queries the user edge of a TweetLike.
func (c *TweetLikeClient) QueryUser(tl *TweetLike) *UserQuery {
	return c.Query().
		Where(tweetlike.UserID(tl.UserID), tweetlike.TweetID(tl.TweetID)).
		QueryUser()
}

// Hooks returns the client hooks.
func (c *TweetLikeClient) Hooks() []Hook {
	hooks := c.hooks.TweetLike
	return append(hooks[:len(hooks):len(hooks)], tweetlike.Hooks[:]...)
}

// Interceptors returns the client interceptors.
func (c *TweetLikeClient) Interceptors() []Interceptor {
	return c.inters.TweetLike
}

func (c *TweetLikeClient) mutate(ctx context.Context, m *TweetLikeMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&TweetLikeCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&TweetLikeUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&TweetLikeUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&TweetLikeDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown TweetLike mutation op: %q", m.Op())
	}
}

// TweetTagClient is a client for the TweetTag schema.
type TweetTagClient struct {
	config
}

// NewTweetTagClient returns a client for the TweetTag from the given config.
func NewTweetTagClient(c config) *TweetTagClient {
	return &TweetTagClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `tweettag.Hooks(f(g(h())))`.
func (c *TweetTagClient) Use(hooks ...Hook) {
	c.hooks.TweetTag = append(c.hooks.TweetTag, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `tweettag.Intercept(f(g(h())))`.
func (c *TweetTagClient) Intercept(interceptors ...Interceptor) {
	c.inters.TweetTag = append(c.inters.TweetTag, interceptors...)
}

// Create returns a builder for creating a TweetTag entity.
func (c *TweetTagClient) Create() *TweetTagCreate {
	mutation := newTweetTagMutation(c.config, OpCreate)
	return &TweetTagCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of TweetTag entities.
func (c *TweetTagClient) CreateBulk(builders ...*TweetTagCreate) *TweetTagCreateBulk {
	return &TweetTagCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *TweetTagClient) MapCreateBulk(slice any, setFunc func(*TweetTagCreate, int)) *TweetTagCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &TweetTagCreateBulk{err: fmt.Errorf("calling to TweetTagClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*TweetTagCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &TweetTagCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for TweetTag.
func (c *TweetTagClient) Update() *TweetTagUpdate {
	mutation := newTweetTagMutation(c.config, OpUpdate)
	return &TweetTagUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *TweetTagClient) UpdateOne(tt *TweetTag) *TweetTagUpdateOne {
	mutation := newTweetTagMutation(c.config, OpUpdateOne, withTweetTag(tt))
	return &TweetTagUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *TweetTagClient) UpdateOneID(id uuid.UUID) *TweetTagUpdateOne {
	mutation := newTweetTagMutation(c.config, OpUpdateOne, withTweetTagID(id))
	return &TweetTagUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for TweetTag.
func (c *TweetTagClient) Delete() *TweetTagDelete {
	mutation := newTweetTagMutation(c.config, OpDelete)
	return &TweetTagDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *TweetTagClient) DeleteOne(tt *TweetTag) *TweetTagDeleteOne {
	return c.DeleteOneID(tt.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *TweetTagClient) DeleteOneID(id uuid.UUID) *TweetTagDeleteOne {
	builder := c.Delete().Where(tweettag.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &TweetTagDeleteOne{builder}
}

// Query returns a query builder for TweetTag.
func (c *TweetTagClient) Query() *TweetTagQuery {
	return &TweetTagQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeTweetTag},
		inters: c.Interceptors(),
	}
}

// Get returns a TweetTag entity by its id.
func (c *TweetTagClient) Get(ctx context.Context, id uuid.UUID) (*TweetTag, error) {
	return c.Query().Where(tweettag.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *TweetTagClient) GetX(ctx context.Context, id uuid.UUID) *TweetTag {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryTag queries the tag edge of a TweetTag.
func (c *TweetTagClient) QueryTag(tt *TweetTag) *TagQuery {
	query := (&TagClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := tt.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tweettag.Table, tweettag.FieldID, id),
			sqlgraph.To(tag.Table, tag.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, tweettag.TagTable, tweettag.TagColumn),
		)
		fromV = sqlgraph.Neighbors(tt.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryTweet queries the tweet edge of a TweetTag.
func (c *TweetTagClient) QueryTweet(tt *TweetTag) *TweetQuery {
	query := (&TweetClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := tt.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(tweettag.Table, tweettag.FieldID, id),
			sqlgraph.To(tweet.Table, tweet.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, tweettag.TweetTable, tweettag.TweetColumn),
		)
		fromV = sqlgraph.Neighbors(tt.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *TweetTagClient) Hooks() []Hook {
	return c.hooks.TweetTag
}

// Interceptors returns the client interceptors.
func (c *TweetTagClient) Interceptors() []Interceptor {
	return c.inters.TweetTag
}

func (c *TweetTagClient) mutate(ctx context.Context, m *TweetTagMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&TweetTagCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&TweetTagUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&TweetTagUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&TweetTagDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown TweetTag mutation op: %q", m.Op())
	}
}

// UserClient is a client for the User schema.
type UserClient struct {
	config
}

// NewUserClient returns a client for the User from the given config.
func NewUserClient(c config) *UserClient {
	return &UserClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `user.Hooks(f(g(h())))`.
func (c *UserClient) Use(hooks ...Hook) {
	c.hooks.User = append(c.hooks.User, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `user.Intercept(f(g(h())))`.
func (c *UserClient) Intercept(interceptors ...Interceptor) {
	c.inters.User = append(c.inters.User, interceptors...)
}

// Create returns a builder for creating a User entity.
func (c *UserClient) Create() *UserCreate {
	mutation := newUserMutation(c.config, OpCreate)
	return &UserCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of User entities.
func (c *UserClient) CreateBulk(builders ...*UserCreate) *UserCreateBulk {
	return &UserCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *UserClient) MapCreateBulk(slice any, setFunc func(*UserCreate, int)) *UserCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &UserCreateBulk{err: fmt.Errorf("calling to UserClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*UserCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &UserCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for User.
func (c *UserClient) Update() *UserUpdate {
	mutation := newUserMutation(c.config, OpUpdate)
	return &UserUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *UserClient) UpdateOne(u *User) *UserUpdateOne {
	mutation := newUserMutation(c.config, OpUpdateOne, withUser(u))
	return &UserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *UserClient) UpdateOneID(id int) *UserUpdateOne {
	mutation := newUserMutation(c.config, OpUpdateOne, withUserID(id))
	return &UserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for User.
func (c *UserClient) Delete() *UserDelete {
	mutation := newUserMutation(c.config, OpDelete)
	return &UserDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *UserClient) DeleteOne(u *User) *UserDeleteOne {
	return c.DeleteOneID(u.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *UserClient) DeleteOneID(id int) *UserDeleteOne {
	builder := c.Delete().Where(user.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &UserDeleteOne{builder}
}

// Query returns a query builder for User.
func (c *UserClient) Query() *UserQuery {
	return &UserQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeUser},
		inters: c.Interceptors(),
	}
}

// Get returns a User entity by its id.
func (c *UserClient) Get(ctx context.Context, id int) (*User, error) {
	return c.Query().Where(user.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *UserClient) GetX(ctx context.Context, id int) *User {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryGroups queries the groups edge of a User.
func (c *UserClient) QueryGroups(u *User) *GroupQuery {
	query := (&GroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(group.Table, group.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, user.GroupsTable, user.GroupsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryFriends queries the friends edge of a User.
func (c *UserClient) QueryFriends(u *User) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, user.FriendsTable, user.FriendsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryRelatives queries the relatives edge of a User.
func (c *UserClient) QueryRelatives(u *User) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, user.RelativesTable, user.RelativesPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryLikedTweets queries the liked_tweets edge of a User.
func (c *UserClient) QueryLikedTweets(u *User) *TweetQuery {
	query := (&TweetClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(tweet.Table, tweet.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, user.LikedTweetsTable, user.LikedTweetsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryTweets queries the tweets edge of a User.
func (c *UserClient) QueryTweets(u *User) *TweetQuery {
	query := (&TweetClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(tweet.Table, tweet.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, user.TweetsTable, user.TweetsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryRoles queries the roles edge of a User.
func (c *UserClient) QueryRoles(u *User) *RoleQuery {
	query := (&RoleClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(role.Table, role.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, user.RolesTable, user.RolesPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryJoinedGroups queries the joined_groups edge of a User.
func (c *UserClient) QueryJoinedGroups(u *User) *UserGroupQuery {
	query := (&UserGroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(usergroup.Table, usergroup.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, user.JoinedGroupsTable, user.JoinedGroupsColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryFriendships queries the friendships edge of a User.
func (c *UserClient) QueryFriendships(u *User) *FriendshipQuery {
	query := (&FriendshipClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(friendship.Table, friendship.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, user.FriendshipsTable, user.FriendshipsColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryRelationship queries the relationship edge of a User.
func (c *UserClient) QueryRelationship(u *User) *RelationshipQuery {
	query := (&RelationshipClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(relationship.Table, relationship.UserColumn),
			sqlgraph.Edge(sqlgraph.O2M, true, user.RelationshipTable, user.RelationshipColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryLikes queries the likes edge of a User.
func (c *UserClient) QueryLikes(u *User) *TweetLikeQuery {
	query := (&TweetLikeClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(tweetlike.Table, tweetlike.UserColumn),
			sqlgraph.Edge(sqlgraph.O2M, true, user.LikesTable, user.LikesColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryUserTweets queries the user_tweets edge of a User.
func (c *UserClient) QueryUserTweets(u *User) *UserTweetQuery {
	query := (&UserTweetClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(usertweet.Table, usertweet.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, user.UserTweetsTable, user.UserTweetsColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryRolesUsers queries the roles_users edge of a User.
func (c *UserClient) QueryRolesUsers(u *User) *RoleUserQuery {
	query := (&RoleUserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(roleuser.Table, roleuser.UserColumn),
			sqlgraph.Edge(sqlgraph.O2M, true, user.RolesUsersTable, user.RolesUsersColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *UserClient) Hooks() []Hook {
	hooks := c.hooks.User
	return append(hooks[:len(hooks):len(hooks)], user.Hooks[:]...)
}

// Interceptors returns the client interceptors.
func (c *UserClient) Interceptors() []Interceptor {
	return c.inters.User
}

func (c *UserClient) mutate(ctx context.Context, m *UserMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&UserCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&UserUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&UserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&UserDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown User mutation op: %q", m.Op())
	}
}

// UserGroupClient is a client for the UserGroup schema.
type UserGroupClient struct {
	config
}

// NewUserGroupClient returns a client for the UserGroup from the given config.
func NewUserGroupClient(c config) *UserGroupClient {
	return &UserGroupClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `usergroup.Hooks(f(g(h())))`.
func (c *UserGroupClient) Use(hooks ...Hook) {
	c.hooks.UserGroup = append(c.hooks.UserGroup, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `usergroup.Intercept(f(g(h())))`.
func (c *UserGroupClient) Intercept(interceptors ...Interceptor) {
	c.inters.UserGroup = append(c.inters.UserGroup, interceptors...)
}

// Create returns a builder for creating a UserGroup entity.
func (c *UserGroupClient) Create() *UserGroupCreate {
	mutation := newUserGroupMutation(c.config, OpCreate)
	return &UserGroupCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of UserGroup entities.
func (c *UserGroupClient) CreateBulk(builders ...*UserGroupCreate) *UserGroupCreateBulk {
	return &UserGroupCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *UserGroupClient) MapCreateBulk(slice any, setFunc func(*UserGroupCreate, int)) *UserGroupCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &UserGroupCreateBulk{err: fmt.Errorf("calling to UserGroupClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*UserGroupCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &UserGroupCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for UserGroup.
func (c *UserGroupClient) Update() *UserGroupUpdate {
	mutation := newUserGroupMutation(c.config, OpUpdate)
	return &UserGroupUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *UserGroupClient) UpdateOne(ug *UserGroup) *UserGroupUpdateOne {
	mutation := newUserGroupMutation(c.config, OpUpdateOne, withUserGroup(ug))
	return &UserGroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *UserGroupClient) UpdateOneID(id int) *UserGroupUpdateOne {
	mutation := newUserGroupMutation(c.config, OpUpdateOne, withUserGroupID(id))
	return &UserGroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for UserGroup.
func (c *UserGroupClient) Delete() *UserGroupDelete {
	mutation := newUserGroupMutation(c.config, OpDelete)
	return &UserGroupDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *UserGroupClient) DeleteOne(ug *UserGroup) *UserGroupDeleteOne {
	return c.DeleteOneID(ug.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *UserGroupClient) DeleteOneID(id int) *UserGroupDeleteOne {
	builder := c.Delete().Where(usergroup.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &UserGroupDeleteOne{builder}
}

// Query returns a query builder for UserGroup.
func (c *UserGroupClient) Query() *UserGroupQuery {
	return &UserGroupQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeUserGroup},
		inters: c.Interceptors(),
	}
}

// Get returns a UserGroup entity by its id.
func (c *UserGroupClient) Get(ctx context.Context, id int) (*UserGroup, error) {
	return c.Query().Where(usergroup.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *UserGroupClient) GetX(ctx context.Context, id int) *UserGroup {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryUser queries the user edge of a UserGroup.
func (c *UserGroupClient) QueryUser(ug *UserGroup) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ug.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroup.Table, usergroup.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, usergroup.UserTable, usergroup.UserColumn),
		)
		fromV = sqlgraph.Neighbors(ug.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryGroup queries the group edge of a UserGroup.
func (c *UserGroupClient) QueryGroup(ug *UserGroup) *GroupQuery {
	query := (&GroupClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ug.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usergroup.Table, usergroup.FieldID, id),
			sqlgraph.To(group.Table, group.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, usergroup.GroupTable, usergroup.GroupColumn),
		)
		fromV = sqlgraph.Neighbors(ug.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *UserGroupClient) Hooks() []Hook {
	return c.hooks.UserGroup
}

// Interceptors returns the client interceptors.
func (c *UserGroupClient) Interceptors() []Interceptor {
	return c.inters.UserGroup
}

func (c *UserGroupClient) mutate(ctx context.Context, m *UserGroupMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&UserGroupCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&UserGroupUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&UserGroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&UserGroupDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown UserGroup mutation op: %q", m.Op())
	}
}

// UserTweetClient is a client for the UserTweet schema.
type UserTweetClient struct {
	config
}

// NewUserTweetClient returns a client for the UserTweet from the given config.
func NewUserTweetClient(c config) *UserTweetClient {
	return &UserTweetClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `usertweet.Hooks(f(g(h())))`.
func (c *UserTweetClient) Use(hooks ...Hook) {
	c.hooks.UserTweet = append(c.hooks.UserTweet, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `usertweet.Intercept(f(g(h())))`.
func (c *UserTweetClient) Intercept(interceptors ...Interceptor) {
	c.inters.UserTweet = append(c.inters.UserTweet, interceptors...)
}

// Create returns a builder for creating a UserTweet entity.
func (c *UserTweetClient) Create() *UserTweetCreate {
	mutation := newUserTweetMutation(c.config, OpCreate)
	return &UserTweetCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of UserTweet entities.
func (c *UserTweetClient) CreateBulk(builders ...*UserTweetCreate) *UserTweetCreateBulk {
	return &UserTweetCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *UserTweetClient) MapCreateBulk(slice any, setFunc func(*UserTweetCreate, int)) *UserTweetCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &UserTweetCreateBulk{err: fmt.Errorf("calling to UserTweetClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*UserTweetCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &UserTweetCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for UserTweet.
func (c *UserTweetClient) Update() *UserTweetUpdate {
	mutation := newUserTweetMutation(c.config, OpUpdate)
	return &UserTweetUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *UserTweetClient) UpdateOne(ut *UserTweet) *UserTweetUpdateOne {
	mutation := newUserTweetMutation(c.config, OpUpdateOne, withUserTweet(ut))
	return &UserTweetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *UserTweetClient) UpdateOneID(id int) *UserTweetUpdateOne {
	mutation := newUserTweetMutation(c.config, OpUpdateOne, withUserTweetID(id))
	return &UserTweetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for UserTweet.
func (c *UserTweetClient) Delete() *UserTweetDelete {
	mutation := newUserTweetMutation(c.config, OpDelete)
	return &UserTweetDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *UserTweetClient) DeleteOne(ut *UserTweet) *UserTweetDeleteOne {
	return c.DeleteOneID(ut.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *UserTweetClient) DeleteOneID(id int) *UserTweetDeleteOne {
	builder := c.Delete().Where(usertweet.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &UserTweetDeleteOne{builder}
}

// Query returns a query builder for UserTweet.
func (c *UserTweetClient) Query() *UserTweetQuery {
	return &UserTweetQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeUserTweet},
		inters: c.Interceptors(),
	}
}

// Get returns a UserTweet entity by its id.
func (c *UserTweetClient) Get(ctx context.Context, id int) (*UserTweet, error) {
	return c.Query().Where(usertweet.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *UserTweetClient) GetX(ctx context.Context, id int) *UserTweet {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryUser queries the user edge of a UserTweet.
func (c *UserTweetClient) QueryUser(ut *UserTweet) *UserQuery {
	query := (&UserClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ut.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usertweet.Table, usertweet.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, usertweet.UserTable, usertweet.UserColumn),
		)
		fromV = sqlgraph.Neighbors(ut.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryTweet queries the tweet edge of a UserTweet.
func (c *UserTweetClient) QueryTweet(ut *UserTweet) *TweetQuery {
	query := (&TweetClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ut.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(usertweet.Table, usertweet.FieldID, id),
			sqlgraph.To(tweet.Table, tweet.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, usertweet.TweetTable, usertweet.TweetColumn),
		)
		fromV = sqlgraph.Neighbors(ut.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *UserTweetClient) Hooks() []Hook {
	return c.hooks.UserTweet
}

// Interceptors returns the client interceptors.
func (c *UserTweetClient) Interceptors() []Interceptor {
	return c.inters.UserTweet
}

func (c *UserTweetClient) mutate(ctx context.Context, m *UserTweetMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&UserTweetCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&UserTweetUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&UserTweetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&UserTweetDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown UserTweet mutation op: %q", m.Op())
	}
}

// hooks and interceptors per client, for fast access.
type (
	hooks struct {
		AttachedFile, File, Friendship, Group, GroupTag, Process, Relationship,
		RelationshipInfo, Role, RoleUser, Tag, Tweet, TweetLike, TweetTag, User,
		UserGroup, UserTweet []ent.Hook
	}
	inters struct {
		AttachedFile, File, Friendship, Group, GroupTag, Process, Relationship,
		RelationshipInfo, Role, RoleUser, Tag, Tweet, TweetLike, TweetTag, User,
		UserGroup, UserTweet []ent.Interceptor
	}
)
