// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/grouptag"
	"entgo.io/ent/entc/integration/edgeschema/ent/predicate"
	"entgo.io/ent/schema/field"
)

// GroupTagDelete is the builder for deleting a GroupTag entity.
type GroupTagDelete struct {
	config
	hooks    []Hook
	mutation *GroupTagMutation
}

// Where appends a list predicates to the GroupTagDelete builder.
func (gtd *GroupTagDelete) Where(ps ...predicate.GroupTag) *GroupTagDelete {
	gtd.mutation.Where(ps...)
	return gtd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (gtd *GroupTagDelete) Exec(ctx context.Context) (int, error) {
	return withHooks(ctx, gtd.sqlExec, gtd.mutation, gtd.hooks)
}

// ExecX is like Exec, but panics if an error occurs.
func (gtd *GroupTagDelete) ExecX(ctx context.Context) int {
	n, err := gtd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (gtd *GroupTagDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := sqlgraph.NewDeleteSpec(grouptag.Table, sqlgraph.NewFieldSpec(grouptag.FieldID, field.TypeInt))
	if ps := gtd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, gtd.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	gtd.mutation.done = true
	return affected, err
}

// GroupTagDeleteOne is the builder for deleting a single GroupTag entity.
type GroupTagDeleteOne struct {
	gtd *GroupTagDelete
}

// Where appends a list predicates to the GroupTagDelete builder.
func (gtdo *GroupTagDeleteOne) Where(ps ...predicate.GroupTag) *GroupTagDeleteOne {
	gtdo.gtd.mutation.Where(ps...)
	return gtdo
}

// Exec executes the deletion query.
func (gtdo *GroupTagDeleteOne) Exec(ctx context.Context) error {
	n, err := gtdo.gtd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{grouptag.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (gtdo *GroupTagDeleteOne) ExecX(ctx context.Context) {
	if err := gtdo.Exec(ctx); err != nil {
		panic(err)
	}
}
