// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package privacy

import (
	"context"

	"entgo.io/ent/entc/integration/edgeschema/ent"
	"entgo.io/ent/entql"

	"entgo.io/ent/privacy"
)

var (
	// Allow may be returned by rules to indicate that the policy
	// evaluation should terminate with allow decision.
	Allow = privacy.Allow

	// Deny may be returned by rules to indicate that the policy
	// evaluation should terminate with deny decision.
	Deny = privacy.Deny

	// Skip may be returned by rules to indicate that the policy
	// evaluation should continue to the next rule.
	Skip = privacy.Skip
)

// Allowf returns a formatted wrapped Allow decision.
func Allowf(format string, a ...any) error {
	return privacy.Allowf(format, a...)
}

// Denyf returns a formatted wrapped Deny decision.
func Denyf(format string, a ...any) error {
	return privacy.Denyf(format, a...)
}

// Skipf returns a formatted wrapped Skip decision.
func Skipf(format string, a ...any) error {
	return privacy.Skipf(format, a...)
}

// DecisionContext creates a new context from the given parent context with
// a policy decision attach to it.
func DecisionContext(parent context.Context, decision error) context.Context {
	return privacy.DecisionContext(parent, decision)
}

// DecisionFromContext retrieves the policy decision from the context.
func DecisionFromContext(ctx context.Context) (error, bool) {
	return privacy.DecisionFromContext(ctx)
}

type (
	// Policy groups query and mutation policies.
	Policy = privacy.Policy

	// QueryRule defines the interface deciding whether a
	// query is allowed and optionally modify it.
	QueryRule = privacy.QueryRule
	// QueryPolicy combines multiple query rules into a single policy.
	QueryPolicy = privacy.QueryPolicy

	// MutationRule defines the interface which decides whether a
	// mutation is allowed and optionally modifies it.
	MutationRule = privacy.MutationRule
	// MutationPolicy combines multiple mutation rules into a single policy.
	MutationPolicy = privacy.MutationPolicy
	// MutationRuleFunc type is an adapter which allows the use of
	// ordinary functions as mutation rules.
	MutationRuleFunc = privacy.MutationRuleFunc

	// QueryMutationRule is an interface which groups query and mutation rules.
	QueryMutationRule = privacy.QueryMutationRule
)

// QueryRuleFunc type is an adapter to allow the use of
// ordinary functions as query rules.
type QueryRuleFunc func(context.Context, ent.Query) error

// Eval returns f(ctx, q).
func (f QueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	return f(ctx, q)
}

// AlwaysAllowRule returns a rule that returns an allow decision.
func AlwaysAllowRule() QueryMutationRule {
	return privacy.AlwaysAllowRule()
}

// AlwaysDenyRule returns a rule that returns a deny decision.
func AlwaysDenyRule() QueryMutationRule {
	return privacy.AlwaysDenyRule()
}

// ContextQueryMutationRule creates a query/mutation rule from a context eval func.
func ContextQueryMutationRule(eval func(context.Context) error) QueryMutationRule {
	return privacy.ContextQueryMutationRule(eval)
}

// OnMutationOperation evaluates the given rule only on a given mutation operation.
func OnMutationOperation(rule MutationRule, op ent.Op) MutationRule {
	return privacy.OnMutationOperation(rule, op)
}

// DenyMutationOperationRule returns a rule denying specified mutation operation.
func DenyMutationOperationRule(op ent.Op) MutationRule {
	rule := MutationRuleFunc(func(_ context.Context, m ent.Mutation) error {
		return Denyf("ent/privacy: operation %s is not allowed", m.Op())
	})
	return OnMutationOperation(rule, op)
}

// The AttachedFileQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type AttachedFileQueryRuleFunc func(context.Context, *ent.AttachedFileQuery) error

// EvalQuery return f(ctx, q).
func (f AttachedFileQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.AttachedFileQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.AttachedFileQuery", q)
}

// The AttachedFileMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type AttachedFileMutationRuleFunc func(context.Context, *ent.AttachedFileMutation) error

// EvalMutation calls f(ctx, m).
func (f AttachedFileMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.AttachedFileMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.AttachedFileMutation", m)
}

// The FileQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type FileQueryRuleFunc func(context.Context, *ent.FileQuery) error

// EvalQuery return f(ctx, q).
func (f FileQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.FileQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.FileQuery", q)
}

// The FileMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type FileMutationRuleFunc func(context.Context, *ent.FileMutation) error

// EvalMutation calls f(ctx, m).
func (f FileMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.FileMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.FileMutation", m)
}

// The FriendshipQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type FriendshipQueryRuleFunc func(context.Context, *ent.FriendshipQuery) error

// EvalQuery return f(ctx, q).
func (f FriendshipQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.FriendshipQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.FriendshipQuery", q)
}

// The FriendshipMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type FriendshipMutationRuleFunc func(context.Context, *ent.FriendshipMutation) error

// EvalMutation calls f(ctx, m).
func (f FriendshipMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.FriendshipMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.FriendshipMutation", m)
}

// The GroupQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type GroupQueryRuleFunc func(context.Context, *ent.GroupQuery) error

// EvalQuery return f(ctx, q).
func (f GroupQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.GroupQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.GroupQuery", q)
}

// The GroupMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type GroupMutationRuleFunc func(context.Context, *ent.GroupMutation) error

// EvalMutation calls f(ctx, m).
func (f GroupMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.GroupMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.GroupMutation", m)
}

// The GroupTagQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type GroupTagQueryRuleFunc func(context.Context, *ent.GroupTagQuery) error

// EvalQuery return f(ctx, q).
func (f GroupTagQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.GroupTagQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.GroupTagQuery", q)
}

// The GroupTagMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type GroupTagMutationRuleFunc func(context.Context, *ent.GroupTagMutation) error

// EvalMutation calls f(ctx, m).
func (f GroupTagMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.GroupTagMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.GroupTagMutation", m)
}

// The ProcessQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type ProcessQueryRuleFunc func(context.Context, *ent.ProcessQuery) error

// EvalQuery return f(ctx, q).
func (f ProcessQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.ProcessQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.ProcessQuery", q)
}

// The ProcessMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type ProcessMutationRuleFunc func(context.Context, *ent.ProcessMutation) error

// EvalMutation calls f(ctx, m).
func (f ProcessMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.ProcessMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.ProcessMutation", m)
}

// The RelationshipQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type RelationshipQueryRuleFunc func(context.Context, *ent.RelationshipQuery) error

// EvalQuery return f(ctx, q).
func (f RelationshipQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.RelationshipQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.RelationshipQuery", q)
}

// The RelationshipMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type RelationshipMutationRuleFunc func(context.Context, *ent.RelationshipMutation) error

// EvalMutation calls f(ctx, m).
func (f RelationshipMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.RelationshipMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.RelationshipMutation", m)
}

// The RelationshipInfoQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type RelationshipInfoQueryRuleFunc func(context.Context, *ent.RelationshipInfoQuery) error

// EvalQuery return f(ctx, q).
func (f RelationshipInfoQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.RelationshipInfoQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.RelationshipInfoQuery", q)
}

// The RelationshipInfoMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type RelationshipInfoMutationRuleFunc func(context.Context, *ent.RelationshipInfoMutation) error

// EvalMutation calls f(ctx, m).
func (f RelationshipInfoMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.RelationshipInfoMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.RelationshipInfoMutation", m)
}

// The RoleQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type RoleQueryRuleFunc func(context.Context, *ent.RoleQuery) error

// EvalQuery return f(ctx, q).
func (f RoleQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.RoleQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.RoleQuery", q)
}

// The RoleMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type RoleMutationRuleFunc func(context.Context, *ent.RoleMutation) error

// EvalMutation calls f(ctx, m).
func (f RoleMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.RoleMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.RoleMutation", m)
}

// The RoleUserQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type RoleUserQueryRuleFunc func(context.Context, *ent.RoleUserQuery) error

// EvalQuery return f(ctx, q).
func (f RoleUserQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.RoleUserQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.RoleUserQuery", q)
}

// The RoleUserMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type RoleUserMutationRuleFunc func(context.Context, *ent.RoleUserMutation) error

// EvalMutation calls f(ctx, m).
func (f RoleUserMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.RoleUserMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.RoleUserMutation", m)
}

// The TagQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type TagQueryRuleFunc func(context.Context, *ent.TagQuery) error

// EvalQuery return f(ctx, q).
func (f TagQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.TagQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.TagQuery", q)
}

// The TagMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type TagMutationRuleFunc func(context.Context, *ent.TagMutation) error

// EvalMutation calls f(ctx, m).
func (f TagMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.TagMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.TagMutation", m)
}

// The TweetQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type TweetQueryRuleFunc func(context.Context, *ent.TweetQuery) error

// EvalQuery return f(ctx, q).
func (f TweetQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.TweetQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.TweetQuery", q)
}

// The TweetMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type TweetMutationRuleFunc func(context.Context, *ent.TweetMutation) error

// EvalMutation calls f(ctx, m).
func (f TweetMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.TweetMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.TweetMutation", m)
}

// The TweetLikeQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type TweetLikeQueryRuleFunc func(context.Context, *ent.TweetLikeQuery) error

// EvalQuery return f(ctx, q).
func (f TweetLikeQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.TweetLikeQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.TweetLikeQuery", q)
}

// The TweetLikeMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type TweetLikeMutationRuleFunc func(context.Context, *ent.TweetLikeMutation) error

// EvalMutation calls f(ctx, m).
func (f TweetLikeMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.TweetLikeMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.TweetLikeMutation", m)
}

// The TweetTagQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type TweetTagQueryRuleFunc func(context.Context, *ent.TweetTagQuery) error

// EvalQuery return f(ctx, q).
func (f TweetTagQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.TweetTagQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.TweetTagQuery", q)
}

// The TweetTagMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type TweetTagMutationRuleFunc func(context.Context, *ent.TweetTagMutation) error

// EvalMutation calls f(ctx, m).
func (f TweetTagMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.TweetTagMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.TweetTagMutation", m)
}

// The UserQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type UserQueryRuleFunc func(context.Context, *ent.UserQuery) error

// EvalQuery return f(ctx, q).
func (f UserQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.UserQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.UserQuery", q)
}

// The UserMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type UserMutationRuleFunc func(context.Context, *ent.UserMutation) error

// EvalMutation calls f(ctx, m).
func (f UserMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.UserMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.UserMutation", m)
}

// The UserGroupQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type UserGroupQueryRuleFunc func(context.Context, *ent.UserGroupQuery) error

// EvalQuery return f(ctx, q).
func (f UserGroupQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.UserGroupQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.UserGroupQuery", q)
}

// The UserGroupMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type UserGroupMutationRuleFunc func(context.Context, *ent.UserGroupMutation) error

// EvalMutation calls f(ctx, m).
func (f UserGroupMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.UserGroupMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.UserGroupMutation", m)
}

// The UserTweetQueryRuleFunc type is an adapter to allow the use of ordinary
// functions as a query rule.
type UserTweetQueryRuleFunc func(context.Context, *ent.UserTweetQuery) error

// EvalQuery return f(ctx, q).
func (f UserTweetQueryRuleFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	if q, ok := q.(*ent.UserTweetQuery); ok {
		return f(ctx, q)
	}
	return Denyf("ent/privacy: unexpected query type %T, expect *ent.UserTweetQuery", q)
}

// The UserTweetMutationRuleFunc type is an adapter to allow the use of ordinary
// functions as a mutation rule.
type UserTweetMutationRuleFunc func(context.Context, *ent.UserTweetMutation) error

// EvalMutation calls f(ctx, m).
func (f UserTweetMutationRuleFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	if m, ok := m.(*ent.UserTweetMutation); ok {
		return f(ctx, m)
	}
	return Denyf("ent/privacy: unexpected mutation type %T, expect *ent.UserTweetMutation", m)
}

type (
	// Filter is the interface that wraps the Where function
	// for filtering nodes in queries and mutations.
	Filter interface {
		// Where applies a filter on the executed query/mutation.
		Where(entql.P)
	}

	// The FilterFunc type is an adapter that allows the use of ordinary
	// functions as filters for query and mutation types.
	FilterFunc func(context.Context, Filter) error
)

// EvalQuery calls f(ctx, q) if the query implements the Filter interface, otherwise it is denied.
func (f FilterFunc) EvalQuery(ctx context.Context, q ent.Query) error {
	fr, err := queryFilter(q)
	if err != nil {
		return err
	}
	return f(ctx, fr)
}

// EvalMutation calls f(ctx, q) if the mutation implements the Filter interface, otherwise it is denied.
func (f FilterFunc) EvalMutation(ctx context.Context, m ent.Mutation) error {
	fr, err := mutationFilter(m)
	if err != nil {
		return err
	}
	return f(ctx, fr)
}

var _ QueryMutationRule = FilterFunc(nil)

func queryFilter(q ent.Query) (Filter, error) {
	switch q := q.(type) {
	case *ent.AttachedFileQuery:
		return q.Filter(), nil
	case *ent.FileQuery:
		return q.Filter(), nil
	case *ent.FriendshipQuery:
		return q.Filter(), nil
	case *ent.GroupQuery:
		return q.Filter(), nil
	case *ent.GroupTagQuery:
		return q.Filter(), nil
	case *ent.ProcessQuery:
		return q.Filter(), nil
	case *ent.RelationshipQuery:
		return q.Filter(), nil
	case *ent.RelationshipInfoQuery:
		return q.Filter(), nil
	case *ent.RoleQuery:
		return q.Filter(), nil
	case *ent.RoleUserQuery:
		return q.Filter(), nil
	case *ent.TagQuery:
		return q.Filter(), nil
	case *ent.TweetQuery:
		return q.Filter(), nil
	case *ent.TweetLikeQuery:
		return q.Filter(), nil
	case *ent.TweetTagQuery:
		return q.Filter(), nil
	case *ent.UserQuery:
		return q.Filter(), nil
	case *ent.UserGroupQuery:
		return q.Filter(), nil
	case *ent.UserTweetQuery:
		return q.Filter(), nil
	default:
		return nil, Denyf("ent/privacy: unexpected query type %T for query filter", q)
	}
}

func mutationFilter(m ent.Mutation) (Filter, error) {
	switch m := m.(type) {
	case *ent.AttachedFileMutation:
		return m.Filter(), nil
	case *ent.FileMutation:
		return m.Filter(), nil
	case *ent.FriendshipMutation:
		return m.Filter(), nil
	case *ent.GroupMutation:
		return m.Filter(), nil
	case *ent.GroupTagMutation:
		return m.Filter(), nil
	case *ent.ProcessMutation:
		return m.Filter(), nil
	case *ent.RelationshipMutation:
		return m.Filter(), nil
	case *ent.RelationshipInfoMutation:
		return m.Filter(), nil
	case *ent.RoleMutation:
		return m.Filter(), nil
	case *ent.RoleUserMutation:
		return m.Filter(), nil
	case *ent.TagMutation:
		return m.Filter(), nil
	case *ent.TweetMutation:
		return m.Filter(), nil
	case *ent.TweetLikeMutation:
		return m.Filter(), nil
	case *ent.TweetTagMutation:
		return m.Filter(), nil
	case *ent.UserMutation:
		return m.Filter(), nil
	case *ent.UserGroupMutation:
		return m.Filter(), nil
	case *ent.UserTweetMutation:
		return m.Filter(), nil
	default:
		return nil, Denyf("ent/privacy: unexpected mutation type %T for mutation filter", m)
	}
}
