// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/entc/integration/edgeschema/ent/process"
)

// Process is the model entity for the Process schema.
type Process struct {
	config
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the ProcessQuery when eager-loading is set.
	Edges        ProcessEdges `json:"edges"`
	selectValues sql.SelectValues
}

// ProcessEdges holds the relations/edges for other nodes in the graph.
type ProcessEdges struct {
	// Files that were attached by this process
	Files []*File `json:"files,omitempty"`
	// AttachedFiles holds the value of the attached_files edge.
	AttachedFiles []*AttachedFile `json:"attached_files,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [2]bool
}

// FilesOrErr returns the Files value or an error if the edge
// was not loaded in eager-loading.
func (e ProcessEdges) FilesOrErr() ([]*File, error) {
	if e.loadedTypes[0] {
		return e.Files, nil
	}
	return nil, &NotLoadedError{edge: "files"}
}

// AttachedFilesOrErr returns the AttachedFiles value or an error if the edge
// was not loaded in eager-loading.
func (e ProcessEdges) AttachedFilesOrErr() ([]*AttachedFile, error) {
	if e.loadedTypes[1] {
		return e.AttachedFiles, nil
	}
	return nil, &NotLoadedError{edge: "attached_files"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Process) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case process.FieldID:
			values[i] = new(sql.NullInt64)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Process fields.
func (pr *Process) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case process.FieldID:
			value, ok := values[i].(*sql.NullInt64)
			if !ok {
				return fmt.Errorf("unexpected type %T for field id", value)
			}
			pr.ID = int(value.Int64)
		default:
			pr.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the Process.
// This includes values selected through modifiers, order, etc.
func (pr *Process) Value(name string) (ent.Value, error) {
	return pr.selectValues.Get(name)
}

// QueryFiles queries the "files" edge of the Process entity.
func (pr *Process) QueryFiles() *FileQuery {
	return NewProcessClient(pr.config).QueryFiles(pr)
}

// QueryAttachedFiles queries the "attached_files" edge of the Process entity.
func (pr *Process) QueryAttachedFiles() *AttachedFileQuery {
	return NewProcessClient(pr.config).QueryAttachedFiles(pr)
}

// Update returns a builder for updating this Process.
// Note that you need to call Process.Unwrap() before calling this method if this Process
// was returned from a transaction, and the transaction was committed or rolled back.
func (pr *Process) Update() *ProcessUpdateOne {
	return NewProcessClient(pr.config).UpdateOne(pr)
}

// Unwrap unwraps the Process entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (pr *Process) Unwrap() *Process {
	_tx, ok := pr.config.driver.(*txDriver)
	if !ok {
		panic("ent: Process is not a transactional entity")
	}
	pr.config.driver = _tx.drv
	return pr
}

// String implements the fmt.Stringer.
func (pr *Process) String() string {
	var builder strings.Builder
	builder.WriteString("Process(")
	builder.WriteString(fmt.Sprintf("id=%v", pr.ID))
	builder.WriteByte(')')
	return builder.String()
}

// Processes is a parsable slice of Process.
type Processes []*Process
