// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package relationship

import (
	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the relationship type in the database.
	Label = "relationship"
	// FieldWeight holds the string denoting the weight field in the database.
	FieldWeight = "weight"
	// FieldUserID holds the string denoting the user_id field in the database.
	FieldUserID = "user_id"
	// FieldRelativeID holds the string denoting the relative_id field in the database.
	FieldRelativeID = "relative_id"
	// FieldInfoID holds the string denoting the info_id field in the database.
	FieldInfoID = "info_id"
	// EdgeUser holds the string denoting the user edge name in mutations.
	EdgeUser = "user"
	// EdgeRelative holds the string denoting the relative edge name in mutations.
	EdgeRelative = "relative"
	// EdgeInfo holds the string denoting the info edge name in mutations.
	EdgeInfo = "info"
	// UserFieldID holds the string denoting the ID field of the User.
	UserFieldID = "id"
	// RelationshipInfoFieldID holds the string denoting the ID field of the RelationshipInfo.
	RelationshipInfoFieldID = "id"
	// Table holds the table name of the relationship in the database.
	Table = "relationships"
	// UserTable is the table that holds the user relation/edge.
	UserTable = "relationships"
	// UserInverseTable is the table name for the User entity.
	// It exists in this package in order to avoid circular dependency with the "user" package.
	UserInverseTable = "users"
	// UserColumn is the table column denoting the user relation/edge.
	UserColumn = "user_id"
	// RelativeTable is the table that holds the relative relation/edge.
	RelativeTable = "relationships"
	// RelativeInverseTable is the table name for the User entity.
	// It exists in this package in order to avoid circular dependency with the "user" package.
	RelativeInverseTable = "users"
	// RelativeColumn is the table column denoting the relative relation/edge.
	RelativeColumn = "relative_id"
	// InfoTable is the table that holds the info relation/edge.
	InfoTable = "relationships"
	// InfoInverseTable is the table name for the RelationshipInfo entity.
	// It exists in this package in order to avoid circular dependency with the "relationshipinfo" package.
	InfoInverseTable = "relationship_infos"
	// InfoColumn is the table column denoting the info relation/edge.
	InfoColumn = "info_id"
)

// Columns holds all SQL columns for relationship fields.
var Columns = []string{
	FieldWeight,
	FieldUserID,
	FieldRelativeID,
	FieldInfoID,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

// Note that the variables below are initialized by the runtime
// package on the initialization of the application. Therefore,
// it should be imported in the main as follows:
//
//	import _ "entgo.io/ent/entc/integration/edgeschema/ent/runtime"
var (
	Hooks  [1]ent.Hook
	Policy ent.Policy
	// DefaultWeight holds the default value on creation for the "weight" field.
	DefaultWeight int
)

// OrderOption defines the ordering options for the Relationship queries.
type OrderOption func(*sql.Selector)

// ByWeight orders the results by the weight field.
func ByWeight(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldWeight, opts...).ToFunc()
}

// ByUserID orders the results by the user_id field.
func ByUserID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUserID, opts...).ToFunc()
}

// ByRelativeID orders the results by the relative_id field.
func ByRelativeID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldRelativeID, opts...).ToFunc()
}

// ByInfoID orders the results by the info_id field.
func ByInfoID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldInfoID, opts...).ToFunc()
}

// ByUserField orders the results by user field.
func ByUserField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newUserStep(), sql.OrderByField(field, opts...))
	}
}

// ByRelativeField orders the results by relative field.
func ByRelativeField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newRelativeStep(), sql.OrderByField(field, opts...))
	}
}

// ByInfoField orders the results by info field.
func ByInfoField(field string, opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newInfoStep(), sql.OrderByField(field, opts...))
	}
}
func newUserStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, UserColumn),
		sqlgraph.To(UserInverseTable, UserFieldID),
		sqlgraph.Edge(sqlgraph.M2O, false, UserTable, UserColumn),
	)
}
func newRelativeStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, RelativeColumn),
		sqlgraph.To(RelativeInverseTable, UserFieldID),
		sqlgraph.Edge(sqlgraph.M2O, false, RelativeTable, RelativeColumn),
	)
}
func newInfoStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, InfoColumn),
		sqlgraph.To(InfoInverseTable, RelationshipInfoFieldID),
		sqlgraph.Edge(sqlgraph.M2O, false, InfoTable, InfoColumn),
	)
}
